module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// Always try to grant access, but if the access is already granted,
// do not grant it again until it is revoked.
always @ (posedge clk or negedge rst_n)
begin
if (!rst_n)
grant_access <= 0;
else if (usr_id == 3'd4)
grant_access <= 1'b1;
else
grant_access <= 1'b0;

end

    end
end

endmodule