module user_grant_access(data_out, usr_id, data_in, clk, rst_n);

output reg [7:0] data_out;
input wire [2:0] usr_id;
input wire [7:0] data_in;
input wire clk, rst_n;

reg grant_access;

always @ (posedge clk or negedge rst_n)
begin
    if (!rst_n)
        data_out = 0;
    else begin
// 1. Check if asset is accessed.
// 2. If asset is accessed, check if access is granted.
// 3. If access is granted, return data.
// 4. If access is not granted, return data from last update.
// 5. If no data has been stored, return 0.
data_out = (grant_access) ? data_in : data_out;
grant_access = (usr_id == 3'h4) ? 1'b1 : 1'b0;

    end
end

endmodule