module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

assign default_val = d;
if (~resetn) begin
	not_locked <= default_val;
	locked <= default_val;
end
else repeat (16) // synchronized to clk domain
	begin: _1_
	assign not_locked[i] = attr[i] ? 1'b0 : default_val;
	assign attr[i] = d;
	end
 


end

endmodule