module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// IF the reset signal is low, the latch should hold the current value of d
// so that when we set the output again, we're in the same state as before
// the reset signal goes high.
// The latch should only hold the value of "d" if the "unlock" signal
// is high - if the "unlock" signal is low, then it should remain latched as zero.
if (resetn) begin
 locked <= 0;
end
else begin
 if (unlock) begin
 locked <= d;
 end
 else begin
 locked <= locked;
 end
end


 


end

endmodule