module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// When the reset signal is low, locked should be 0.
// When the reset signal is high, locked should be 1.
// This is a reset-and-hold design.

// When the reset signal is low, locked should be 0.
// When the reset signal is high, locked should be 1.
// This is a reset-and-hold design.
assign locked = (resetn) ? 1 : d;

 


end

endmodule