module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

always @(*) begin
	 if (~resetn) begin
	 q <= 0;
	 locked <= 0;
	 end
	 else begin
	 case ({q})
	 2'b00: begin
	 q <= 2'b01;
	 locked <= 0;
	 end
	 2'b01: begin
	 q <= 2'b10;
	 locked <= 1;
	 end
	 2'b10: begin
	 q <= 2'b11;
	 locked <= 0;
	 end
	 2'b11: begin
	 q <= 2'b01;
	 locked <= 1;
	 end
	 endcase
	 end
	end
	
end

endmodule