module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

assign d = (~resetn)&(~unlock);

if (resetn == 1'b0) begin
locked = 1'b0; // unlocked
end
else if (resetn == 1'b1) begin
if (lock == d) begin
locked = 1'b1; // locked
end
else begin
locked = 1'b0;
end
end

end

endmodule