module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// 1. Use a flag to identify reset.
// 2. Asynchronously reset the register to the default value, never write a 0 to the register.
	if (resetn == 1'b0) begin
	locked <= 1'b0;
	end
	else if (unlock == 1'b1) begin
	locked <= d;
	end
	else begin
	locked <= locked;
	end
 


end

endmodule