module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

if(unlock) begin
	locked <= d;
end else begin
	locked <= locked;
end

/*
//traditional method
always @(*) begin
	case ({clk,resetn})
	
	{1'b0,1'b0}:locked <= locked;
	
	{1'b0,1'b1}:locked <= d;
	
	{1'b1,1'b0}:locked <= 1'b0;
	
	{1'b1,1'b1}:locked <= d;
	
	endcase
end
*/
 


end

endmodule