module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// if (resetn == 0) begin
// locked <= 0;
// end

// If the reset signal is low, locked should be a high impedence
// (i.e. a wire) and should not be assigned a value, otherwise
// it will be the same as d.
// If the reset signal is high, then the circuit should
// behave as a regular latch.

assign locked = (resetn == 0) ? 1'b1 : d;

 


end

endmodule