module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

//	1) Setting the output to a particular value when the reset signal goes low.
//	2) Setting the output to a default value when the reset signal stays low.

if(!resetn) begin
	locked <= 1'b0;
end

else if (unlock) begin
	locked <= d;
end

else begin
	locked <= locked;
end

 


end

endmodule