module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// 1) We should only be using the LOCKED output when the unlock input is low.
// 2) The LOCKED output should not be used to gate the clock.
assign locked = (unlock) ? d : 1'b0;

 


end

endmodule