module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// This is a good trick to remember: 
// if you're going to test something
// that changes over time, use a clocked always block
// to put the correct value in the register at each clock
// edge.
//
// If you're going to test something that is only
// true for one clock cycle, use a combinational always block
// with a begin/end block.
//
if(~resetn) begin
	locked <= 1'b0;
end
else begin
	if(unlock) begin
	locked <= d;
	end
	else begin
	locked <= locked;
	end
end

 


end

endmodule