module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

assign enabled = (unlock)?1'b1:1'b0;
assign d_in = (unlock)?d:1'bz;

always @(posedge clk or negedge resetn) begin

if(~resetn | ~enabled) begin
locked <= 1'b0;
end

else begin
locked <= d_in;
end

end


end

endmodule