module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

//
// NOTE: The reset logic has been modified to guarantee that the values are
// not changed by reset. 
//
if(unlock) begin
	if (locked) locked <= d;
	else locked <= 1'b0;
end
else begin
	if (locked) locked <= locked;
	else locked <= 1'b0;
end
 

end

endmodule