module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

if(resetn == 1'b0)begin
	locked <= 1'b0;
	end
if (unlock == 1'b1) begin
	locked <= d | locked ;
	end else begin
	locked <= locked;
	end

end
// END FIX

// Make sure that the registers holding the lock hold a 0 value for at least one clock cycle.
// Otherwise everything becomes inconsistent.
always @(resetn)begin
	if(resetn == 0)begin
	locked <= 0;
	end
 



end

endmodule