module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

always @(unlock)
begin
	if (resetn == 0)
	begin
	/*
	 * On Reset, assign a zero to the lock register.
	 * This is the safest state in which to operate.
	 *
	 * The security settings are not important when the system is first programmed.
	 *
	 * The lock register is assigned the value of the previous lock register.
	 * This allows the system to start in a locked state on reset.
	 */
	locked <= 1'b0;
	end
	else
	begin
	locked <= d;
	end
end

 


end

endmodule