module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// 1. Use a different reset signal for the lock register.
// 2. Ensure that the lock register is initialized to a locked state.
// 3. Use a synchronous reset block for the lock register.

if (resetn == 1'b0)
	locked <= 1'b0;
else if (unlock == 1'b1)
	locked <= d;
else
	locked <= locked;

 


end

endmodule