module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// 1. We should use a different mechanism to reset the security settings.
// 2. The current implementation is not safe.

// Reset the registers when the reset button is low.
if (~resetn) begin
	locked <= 1'b0;
	locked_in <= 1'b0;
end

// Otherwise, lock the registers when the lock button is low.
else if (~lockn) begin
	locked <= 1'b1;
	locked_in <= 1'b1;
end

// Otherwise, maintain the previous values.
else begin
	locked <= locked_in;
end

 


end

endmodule