module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

 Prior to the changes to lock_on_reset, the following issue occurred: 
 The following program had 2 identical initial reset statements, one at the 
 top level and one in the always@(posedge clk or negedge resetn) statement. 
 On the reset statement at the top level, the d variable was not set to the value 
 of the current value of d (1'b0). However, the always@(posedge clk or negedge resetn) 
 statement was always reset to update the data (there was no change from the previous 
 value of data). Thus, the reset statement at the top level synergized with the 
 value of the d variable at the always@(posedge clk or negedge resetn) statement, 
 resulting in a clock driven value of d (1'b0) on the next edge of the clock
end

endmodule