module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

 Otherwise, we might run into the following issue.

 If the reset value of the lock register is one of the two values that indicate
 a locked state, then the code in the always block above will prevent the
 lock register from being updated on the first positive edge of the clock
 cycle after reset.

 This is a problem if the initial value of the lock register is in the locked
 state. It means that the lock is held in the locked state at reset time,
 regardless of the security setting.

 It means that it is possible to violate the security settings by leaving the
 MRZ door locked, or by leaving the sensor ports of the KEY device locked.

 This is a problem if the initial state of the lock register is "unlocked",
 which is the state that indicates that the door is open.

 If the initial state of the lock register
end

endmodule