module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// 1. Use a standard synchronous reset block.
// 2. The reset value is not a sensitive value.
// 3. The reset value is not used in the reset block.
// 4. The reset value is assigned in the reset block.
// 5. The reset value is not used in the reset block.
// 6. The reset value is not assigned in the reset block.
assign locked = (resetn) ? 1'b0 : d;
 


end

endmodule