module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin


// This is not the correct code. It is impossible to determine if the
// reset is a strong 0 or a strong 1.

// This is a different way to do it. The problem is that it is
// possible to get a false positive on the locked output.
// The trick is to use a strong 1 and a strong 0.
// If the output is not gated then it will be driven by the
// strong 1. If it is gated then it will be driven by the
// strong 0.

// This can be done by using the or operator on the locked
// output and the not of the d input.

// Example:
// if (resetn)
// locked = 1'b1;
// else
// locked = 1'b0;
// if (resetn)
// locked = 1'b0;
// else
// locked = 1'b1;

end

endmodule