module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// latter in always block overwrites the assignment in the if-then block above
// latter in always block is
// flippant in this case, because q is always holding the same value as d_in
// above sequence can be inferred as a flip-flop with a preset and reset
// as shown in the diagram

if (~resetn) begin
locked <= 1'b0;
end

else begin

if (unlock) begin
locked <= d;
end

else begin
locked <= locked;
end

end

 


end

endmodule