module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// 1. security mechanism lock triggered upon low pulse of reset signal
// 2. registers holding security settings should only be updated when module is reset through the same or a later (sporadic) low pulse of the reset signal
// a) the module is first locked after being reset
// b) the module can only be unlocked by a subsequent low pulse of the reset signal
// c) the reset should not be deasserted for more than 200ns after reset signal goes low
// d) the module should recover from a reset with the same or lower security level in the event of an external reset signal that deasserts the reset signal or a clock glitch
if (resetn == 0) begin
locked = 0;
// if (resetn == 0) begin
// locked = d;
// end

end

// if resetn is asserted, lock value is asserted
// if reset is not asserted and unlock is asserted, lock value is
end

endmodule