module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

locked <= d;
// What if we did not reset the machine (e.g. during a software load)?
if (~resetn) begin
locked <= 1'b0;
end
 


end

endmodule