module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

// Perhaps because of a race condition on the reset line?
// i.e. when you make a reset request before previous
// requests have been dealt with, q can end up in one
// of the other states.

case(q)

0:begin

if(resetn) locked <= 0;
if(unlock) locked <= 1;

end;

1:begin

if(resetn) locked <= 0;

end;
default:begin

locked <= 1;

end;

endcase

 


end

endmodule