module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

	if (~resetn) begin
// Prefer an efficient AND circuit:
// if (!resetn) begin
// 	locked <= 0; 
// end
// Use a wire as a buffer and then an OR
// if (~resetn) begin
// 	locked <= d; 
// end
// or use a non-blocking statement for the if statement body
	if(unlock) begin
	locked <= d;
	end
	else begin
	locked <= locked;
	end
end


end

endmodule