module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

assign combout = (unlock) ? d : locked;

// LATCHED:
//��下面的assign combout = ~locked;

// RIGHT:
// edited to latch lock according to defaults
assign combout = (~locked) | d;

// RIGHT END:
// set *default* to 5'b00000, 1*1*1*1
assign combout = (~locked) | 0;

 


end

endmodule