module lock_on_reset
(
input wire clk,
input wire resetn,
input wire unlock,
input wire d,
output reg locked
);

always @(posedge clk or negedge resetn) begin

assign enabled = (unlock) ? 1'b1 : 1'b0;
assign valid = (unlock) ? d : locked;

always @(posedge clk or negedge resetn) begin
	if (!resetn) begin
	locked <= 1'b0;
	end
	else begin
	locked <= valid;
	end
end


end

endmodule