// See LICENSE for license details.

#ifndef _RISCV_SBI_H
#define _RISCV_SBI_H

#define SBI_SET_TIMER 0
#define SBI_CONSOLE_PUTCHAR 1
#define SBI_CONSOLE_GETCHAR 2
#define SBI_CLEAR_IPI 3
#define SBI_SEND_IPI 4
#define SBI_REMOTE_FENCE_I 5
#define SBI_REMOTE_SFENCE_VMA 6
#define SBI_REMOTE_SFENCE_VMA_ASID 7
#define SBI_SHUTDOWN 8

#define SBI_AES0_START_ENCRYPT 20
#define SBI_AES0_WAIT 21
#define SBI_AES0_DATA_OUT 22
#define SBI_SHA256_HASH 23
#define SBI_HMAC_HASH 24
#define SBI_DMA_COPY 25
#define SBI_CMP 26
#define SBI_AES1_READ_DATA 31
#define SBI_AES1_WRITE_DATA 32
#define SBI_AES1_READ_CONFIG 33
#define SBI_AES1_WRITE_CONFIG 34
#define SBI_PUTS 35
#define SBI_DMA_END 36
#define SBI_RNG_WAIT 37
#define SBI_RNG_READ_DATA 38
#define SBI_RNG_READ_POLY 39
#define SBI_RNG_WRITE_POLY 40
#define SBI_RNG_READ_SEED 41
#define SBI_RNG_WRITE_SEED 42
#define SBI_RNG_READ_RAND_SEG 43
#define SBI_RNG_READ_STATE_COUNTER 44
#define SBI_AES2_START_ENCRYPT 45
#define SBI_AES2_WAIT 46
#define SBI_AES2_DATA_OUT 47
#define SBI_RST 52
#define SBI_RSA_WAIT 48
#define SBI_RSA_WRITE_PNUM 49
#define SBI_RSA_WRITE_MSG_IN 50
#define SBI_RSA_READ_MSG_OUT 51

#endif
