// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: tlu_multi_mix_3_hwint_rand_66_s1.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
********************************************************************************
   random seed:	220441980
   Jal tlu_multi_mix_3_hwint.j:	
********************************************************************************/



#define PCONTEXT	0x10
#define SCONTEXT	0x10

#define MAIN_PAGE_NUCLEUS_ALSO
#define MAIN_PAGE_HV_ALSO

#include "spu_diag.h"
#define DATA_SRC_RA 0x0000000170001000
#define DATA_SRC_PA ra2pa(DATA_SRC_RA, 0)
#define DATA_DEST_RA 0x0000000170002000
#define DATA_DEST_PA ra2pa(DATA_DEST_RA, 0)

#include "my_intr_handlers.s"
#include "my_trap_handlers.s"
#include "tlu_custom_trap_handlers.s"

#include "enable_traps.h"
#include "boot.s"

.text
.global main

main:

! Register init code

	setx 0x0021fd39b6604a19, %g1, %g0
	setx 0xe13ce54ddf9335b0, %g1, %g1
	setx 0x7e656371231cbd94, %g1, %g2
	setx 0x3396ea1affa843c2, %g1, %g3
	setx 0xbf78d70adcdc24e7, %g1, %g4
	setx 0x42ec7841e19533a5, %g1, %g5
	setx 0x449c25e520be7b70, %g1, %g6
	setx 0xce03f16df0ec4bba, %g1, %g7
	setx 0x13983043f9355179, %g1, %r16
	setx 0xe78bf4a77c6185ad, %g1, %r17
	setx 0x326980ddcd000da3, %g1, %r18
	setx 0x14f0ec008f8ae765, %g1, %r19
	setx 0xce2e9313cfbf68ca, %g1, %r20
	setx 0xf70deb170f1bba3c, %g1, %r21
	setx 0xdfcb9db3c8c548c3, %g1, %r22
	setx 0x9d807fc453c05775, %g1, %r23
	setx 0xb580ab7a2b769454, %g1, %r24
	setx 0x66a0abef8d22201c, %g1, %r25
	setx 0x081889b8ae97bf87, %g1, %r26
	setx 0xc104b91e177dc678, %g1, %r27
	setx 0x7516272dec02d789, %g1, %r28
	setx 0x600755c410af11cd, %g1, %r29
	setx 0x5c947ab390661e36, %g1, %r30
	setx 0x95ae483f6038f935, %g1, %r31
	save
	setx 0x8436a46abb019c9f, %g1, %r16
	setx 0x5ba49cbcb8d4db53, %g1, %r17
	setx 0x88ec72b1b7a951d5, %g1, %r18
	setx 0x1ac474bf50ab1352, %g1, %r19
	setx 0x5fd599fff931497a, %g1, %r20
	setx 0x182b4be4618c2ec0, %g1, %r21
	setx 0xc7c7a373729b51d7, %g1, %r22
	setx 0xee0538752a0b1c74, %g1, %r23
	setx 0x45d976662562fb7b, %g1, %r24
	setx 0xf4c0d74ad96a7514, %g1, %r25
	setx 0x58be315acec8ac33, %g1, %r26
	setx 0xaffbc1a8f7fb68af, %g1, %r27
	setx 0xcdba52b26713e1e4, %g1, %r28
	setx 0xdcbb2515e34b5978, %g1, %r29
	setx 0x8c453ca9198da5b4, %g1, %r30
	setx 0x26248493b352113c, %g1, %r31
	save
	setx 0x6bd207eadcb5adb3, %g1, %r16
	setx 0x0d73fdba472c13de, %g1, %r17
	setx 0xa4a5b92546137429, %g1, %r18
	setx 0xa6a1107d4cefd567, %g1, %r19
	setx 0x510eb98f51e09c52, %g1, %r20
	setx 0x54ac6729332392b6, %g1, %r21
	setx 0x7911362aa2943e53, %g1, %r22
	setx 0xc76152014c1ed415, %g1, %r23
	setx 0x1d57062dd2a6bac8, %g1, %r24
	setx 0x1288fca4e20cb562, %g1, %r25
	setx 0x06791007fa9f3ac7, %g1, %r26
	setx 0xc47010399287b842, %g1, %r27
	setx 0x31960acda881c689, %g1, %r28
	setx 0xb3b3b18d63b3137f, %g1, %r29
	setx 0xab6491b9b4f1bcc5, %g1, %r30
	setx 0xee967463f00128aa, %g1, %r31
	save
	setx 0xa286a5e994b2a2cd, %g1, %r16
	setx 0x9fd4086ec3f11cec, %g1, %r17
	setx 0xc9157d36d0f52dfe, %g1, %r18
	setx 0x570445c8cb406f9b, %g1, %r19
	setx 0x949839106a6f2cb0, %g1, %r20
	setx 0xb568c3d9ce444620, %g1, %r21
	setx 0x9b5dec7a288476af, %g1, %r22
	setx 0x2ea38144eedb49ce, %g1, %r23
	setx 0x0f6fb3d68038d071, %g1, %r24
	setx 0xc9e7a9bcd26263b7, %g1, %r25
	setx 0x0cd8a3a00b507c1d, %g1, %r26
	setx 0xa23984bab5ddba93, %g1, %r27
	setx 0x6b3de86193e089dd, %g1, %r28
	setx 0x9320e7cac03e47d0, %g1, %r29
	setx 0xbad5889e2386cfb5, %g1, %r30
	setx 0xd82c477a78d299c8, %g1, %r31
	save
	setx 0x5fccee39f79b17ea, %g1, %r16
	setx 0xcfdb3089132f28d6, %g1, %r17
	setx 0xf3650af8757c5b53, %g1, %r18
	setx 0x98dc2f23235d7485, %g1, %r19
	setx 0x61526ef209dd810d, %g1, %r20
	setx 0xbd9e49e628e793c1, %g1, %r21
	setx 0x6337413e08523c02, %g1, %r22
	setx 0x64b50cb67ab9e8cd, %g1, %r23
	setx 0xadb32440b5855c78, %g1, %r24
	setx 0xd540c177ae094d06, %g1, %r25
	setx 0x8772191e5f7fb3f7, %g1, %r26
	setx 0x14b83b10e30ff142, %g1, %r27
	setx 0x0268d814216af8ca, %g1, %r28
	setx 0x99f3fa16ead6a22f, %g1, %r29
	setx 0x73c924308689a819, %g1, %r30
	setx 0x850eba789a82cfaf, %g1, %r31
	save
	setx 0xd93aeac7bf41b769, %g1, %r16
	setx 0xdac44d6b79d19b51, %g1, %r17
	setx 0xf3175941e01c59b3, %g1, %r18
	setx 0xc3a0d17c93f05a89, %g1, %r19
	setx 0xcab0d9b7007fccfc, %g1, %r20
	setx 0x75ac62747f894cbb, %g1, %r21
	setx 0xa8450038a97f1983, %g1, %r22
	setx 0xb81931eb6e8dffa9, %g1, %r23
	setx 0x2a2bb4894cd9f242, %g1, %r24
	setx 0x41090c3f758b6f22, %g1, %r25
	setx 0xa8133f673caa3890, %g1, %r26
	setx 0x7109daa0ab8461b5, %g1, %r27
	setx 0xada088fe19755c32, %g1, %r28
	setx 0x1088576ccdd8f9e0, %g1, %r29
	setx 0x1149f975e3025afd, %g1, %r30
	setx 0x15843a0488e4d605, %g1, %r31
	save
	setx 0x2b66daa2cedb6d85, %g1, %r16
	setx 0x1d5d2c6a6ca1e9ba, %g1, %r17
	setx 0xf04ece5f5fb03f20, %g1, %r18
	setx 0x72d3f452ed6bf335, %g1, %r19
	setx 0x6c8b0fcfc59fa718, %g1, %r20
	setx 0x6f6d898dcc680c18, %g1, %r21
	setx 0x1ed84a4c2bcb2adc, %g1, %r22
	setx 0x94bfb07e34599788, %g1, %r23
	setx 0x18f7613adc7f6ed4, %g1, %r24
	setx 0xdba0de1bb3aede38, %g1, %r25
	setx 0x2a48d2eb3ce1796c, %g1, %r26
	setx 0xabffdafe171ff7ba, %g1, %r27
	setx 0x41bcd63ea4cbee8a, %g1, %r28
	setx 0x6f0c9562cf6d45fc, %g1, %r29
	setx 0x13e49e2bfa159ddf, %g1, %r30
	setx 0x00cebc54ce4868c6, %g1, %r31
	save
	setx 0x590be3de6fde3dca, %g1, %r16
	setx 0xc912608a2e534a64, %g1, %r17
	setx 0x3bda4a57c0364466, %g1, %r18
	setx 0x113ddba91dbebc8d, %g1, %r19
	setx 0x56e32ba4cdbe0860, %g1, %r20
	setx 0xb6b9d24caf87fea2, %g1, %r21
	setx 0xd0b5d42ec717a894, %g1, %r22
	setx 0xb09762a261bc0793, %g1, %r23
	setx 0x51f9fc54094de08e, %g1, %r24
	setx 0x092f9fa2a8d7dace, %g1, %r25
	setx 0x722b8c049aa70040, %g1, %r26
	setx 0x48036f427f18f1cb, %g1, %r27
	setx 0xd5c68bc9cb043a71, %g1, %r28
	setx 0xf94b43a8e6d2813d, %g1, %r29
	setx 0x393cc22b39d54cc6, %g1, %r30
	setx 0xc4db6a42fc76abf3, %g1, %r31
	ta	T_CHANGE_HPRIV
	wr	%g0, 4, %fprs
	setx	data_start_0, %r1, %g7
	ldd	[%g7+0], %f0
	ldd	[%g7+8], %f2
	ldd	[%g7+16], %f4
	ldd	[%g7+24], %f6
	ldd	[%g7+32], %f8
	ldd	[%g7+40], %f10
	ldd	[%g7+48], %f12
	ldd	[%g7+56], %f14
	ldd	[%g7+64], %f16
	ldd	[%g7+72], %f18
	ldd	[%g7+80], %f20
	ldd	[%g7+88], %f22
	ldd	[%g7+96], %f24
	ldd	[%g7+104], %f26
	ldd	[%g7+112], %f28
	ldd	[%g7+120], %f30
	ldd	[%g7+128], %f32
	ldd	[%g7+136], %f34
	ldd	[%g7+144], %f36
	ldd	[%g7+152], %f38
	ldd	[%g7+160], %f40
	ldd	[%g7+168], %f42
	ldd	[%g7+176], %f44
	ldd	[%g7+184], %f46
	ldd	[%g7+192], %f48
	ldd	[%g7+200], %f50
	ldd	[%g7+208], %f52
	ldd	[%g7+216], %f54
	ldd	[%g7+224], %f56
	ldd	[%g7+232], %f58
	ldd	[%g7+240], %f60
	ldd	[%g7+248], %f62
	setx	fsr_data, %r1, %g7
	stx	%fsr, [%g7]
	ldx	[%g7], %g4
	setx	%hi(0x0f000000), %g1, %g3
	or	%g4, %g3, %g4
	stx	%g4, [%g7]
	ldx	[%g7], %fsr
	setx	%hi(0x1ffe0000f), %g1, %g2
	stxa	%g2, [%g0] 0x45
	mov	0x38, %g3
	setx	data_start_0, %g1, %g2
	stxa	%g2, [%g3] 0x58
	ta	T_CHANGE_NONHPRIV
	ta	%icc, T_RD_THID
! fork: source strm = 0xffffffff; target strm = 0x2
	cmp	%o1, 1
	setx	fork_lbl_0_1, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x4
	cmp	%o1, 2
	setx	fork_lbl_0_2, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x8
	cmp	%o1, 3
	setx	fork_lbl_0_3, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
T0_spu_op_0:
	ta	T_CHANGE_HPRIV
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x3f, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	MASync_ADDR, %g1
	ldxa	[%g0 + %g1] SPU_ASI, %g2
	set	0xff, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x3f, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	MASync_ADDR, %g1
	ldxa	[%g0 + %g1] SPU_ASI, %g2
	ta	T_CHANGE_NONHPRIV
	.word 0xbde4a163  ! 3: SAVE_I	save	%r18, 0x0001, %r30
	.word 0x89942096  ! 4: WRPR_TICK_I	wrpr	%r16, 0x0096, %tick
	.word 0xb1e4e122  ! 5: SAVE_I	save	%r19, 0x0001, %r24
hwintr_0_0:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_0), 16, 16)) -> intp(0, 0, 10)
	.word 0xb5e4e077  ! 9: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xb7e42047  ! 12: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xbfe4e117  ! 15: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb3e561d1  ! 16: SAVE_I	save	%r21, 0x0001, %r25
	.word 0x9194a0e6  ! 19: WRPR_PIL_I	wrpr	%r18, 0x00e6, %pil
	.word 0x919520fc  ! 20: WRPR_PIL_I	wrpr	%r20, 0x00fc, %pil
hwintr_0_1:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_1), 16, 16)) -> intp(0, 0, 1d)
hwintr_0_2:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_2), 16, 16)) -> intp(0, 0, 20)
	.word 0xbde4a118  ! 34: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xbf518000  ! 35: RDPR_PSTATE	<illegal instruction>
	.word 0xb5520000  ! 36: RDPR_PIL	<illegal instruction>
	.word 0xb1e4619a  ! 37: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xba1c0000  ! 39: XOR_R	xor 	%r16, %r0, %r29
	.word 0xbc3cc000  ! 41: XNOR_R	xnor 	%r19, %r0, %r30
	.word 0xb5e4a071  ! 47: SAVE_I	save	%r18, 0x0001, %r26
	ta	T_CHANGE_HPRIV
T0_spu_op_1:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1209, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0x83956181  ! 50: WRPR_TNPC_I	wrpr	%r21, 0x0181, %tnpc
	.word 0xbfe4e19b  ! 57: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbfe56009  ! 58: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xbbe5e0ac  ! 59: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb3e4a1b0  ! 64: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xbfe46024  ! 66: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xbbe52017  ! 67: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xb9e561f0  ! 70: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xb7e46006  ! 73: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xb1e5a172  ! 74: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xbde46059  ! 75: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb804e05a  ! 76: ADD_I	add 	%r19, 0x005a, %r28
	.word 0xb9e560c5  ! 77: SAVE_I	save	%r21, 0x0001, %r28
hwintr_0_3:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_3), 16, 16)) -> intp(0, 0, 2)
	.word 0xb9e4a18b  ! 79: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xb1641800  ! 80: MOVcc_R	<illegal instruction>
	.word 0xbbe561a6  ! 82: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xbfe4a0fc  ! 85: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb9e521e0  ! 87: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb7e4e00a  ! 88: SAVE_I	save	%r19, 0x0001, %r27
	.word 0x8994207e  ! 98: WRPR_TICK_I	wrpr	%r16, 0x007e, %tick
	.word 0xbde5a0bf  ! 99: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xbfe420d1  ! 100: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xb5e46015  ! 101: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb751c000  ! 102: RDPR_TL	<illegal instruction>
	ta	T_CHANGE_HPRIV
T0_spu_op_2:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x201, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xb950c000  ! 106: RDPR_TT	<illegal instruction>
	.word 0xb1e560d5  ! 107: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb3e5e013  ! 110: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb9e4210c  ! 111: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xb3510000  ! 112: RDPR_TICK	<illegal instruction>
	.word 0xb5e5a192  ! 114: SAVE_I	save	%r22, 0x0001, %r26
hwintr_0_4:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_4), 16, 16)) -> intp(0, 0, 23)
	.word 0xb1e5a05a  ! 121: SAVE_I	save	%r22, 0x0001, %r24
	.word 0x8595605b  ! 123: WRPR_TSTATE_I	wrpr	%r21, 0x005b, %tstate
	.word 0xbde4e170  ! 124: SAVE_I	save	%r19, 0x0001, %r30
	.word 0xb03c4000  ! 125: XNOR_R	xnor 	%r17, %r0, %r24
	.word 0xba45e105  ! 126: ADDC_I	addc 	%r23, 0x0105, %r29
	mov	1, %r12
	.word 0x8f932000  ! 130: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_0_5:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_5), 16, 16)) -> intp(0, 0, 2)
	ta	T_CHANGE_HPRIV
T0_spu_op_3:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a09, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbebc60bc  ! 136: XNORcc_I	xnorcc 	%r17, 0x00bc, %r31
	.word 0xbde42102  ! 138: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xb9e4e175  ! 139: SAVE_I	save	%r19, 0x0001, %r28
	.word 0x8794e0eb  ! 141: WRPR_TT_I	wrpr	%r19, 0x00eb, %tt
	.word 0xb49d21ae  ! 143: XORcc_I	xorcc 	%r20, 0x01ae, %r26
	.word 0xbac40000  ! 146: ADDCcc_R	addccc 	%r16, %r0, %r29
	.word 0xbde5e072  ! 147: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb5e4e181  ! 152: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xbde52171  ! 153: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xbde4a05d  ! 157: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xbc35a04f  ! 162: SUBC_I	orn 	%r22, 0x004f, %r30
	.word 0x8795a12f  ! 163: WRPR_TT_I	wrpr	%r22, 0x012f, %tt
	.word 0xb7e4201e  ! 167: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb6bd4000  ! 169: XNORcc_R	xnorcc 	%r21, %r0, %r27
	.word 0xba3421e8  ! 170: ORN_I	orn 	%r16, 0x01e8, %r29
	.word 0xb5510000  ! 172: RDPR_TICK	<illegal instruction>
	.word 0xbd500000  ! 174: RDPR_TPC	<illegal instruction>
	.word 0xbc24c000  ! 175: SUB_R	sub 	%r19, %r0, %r30
	.word 0xb5e52061  ! 176: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xbbe5618b  ! 177: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xbde5615f  ! 178: SAVE_I	save	%r21, 0x0001, %r30
	.word 0x81952191  ! 180: WRPR_TPC_I	wrpr	%r20, 0x0191, %tpc
hwintr_0_6:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_6), 16, 16)) -> intp(0, 0, 34)
	.word 0xb3e4a0e6  ! 183: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xbfe4a12e  ! 187: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbde4e1cc  ! 188: SAVE_I	save	%r19, 0x0001, %r30
hwintr_0_7:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_7), 16, 16)) -> intp(0, 0, 3c)
	.word 0xb3e421c7  ! 199: SAVE_I	save	%r16, 0x0001, %r25
hwintr_0_8:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_8), 16, 16)) -> intp(0, 0, 3d)
	.word 0xb93d0000  ! 211: SRA_R	sra 	%r20, %r0, %r28
	.word 0x8595e1d6  ! 215: WRPR_TSTATE_I	wrpr	%r23, 0x01d6, %tstate
	.word 0xbfe5a174  ! 217: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb3e52196  ! 218: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb7e5a12e  ! 220: SAVE_I	save	%r22, 0x0001, %r27
	.word 0x8194a082  ! 221: WRPR_TPC_I	wrpr	%r18, 0x0082, %tpc
hwintr_0_9:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_9), 16, 16)) -> intp(0, 0, 5)
	.word 0xb3e42145  ! 223: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xbde4a192  ! 226: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb750c000  ! 229: RDPR_TT	<illegal instruction>
	.word 0xbbe521d6  ! 230: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xb3e4e101  ! 231: SAVE_I	save	%r19, 0x0001, %r25
hwintr_0_10:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_10), 16, 16)) -> intp(0, 0, 0)
	.word 0xb9508000  ! 238: RDPR_TSTATE	<illegal instruction>
hwintr_0_11:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_11), 16, 16)) -> intp(0, 0, 28)
	.word 0xbde46183  ! 241: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb3e420ed  ! 250: SAVE_I	save	%r16, 0x0001, %r25
	mov	0, %r14
	.word 0xa193a000  ! 254: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8794a1f4  ! 256: WRPR_TT_I	wrpr	%r18, 0x01f4, %tt
	mov	2, %r14
	.word 0xa193a000  ! 257: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_0_12:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_12), 16, 16)) -> intp(0, 0, 0)
	.word 0xb5e5e1b8  ! 264: SAVE_I	save	%r23, 0x0001, %r26
hwintr_0_13:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_13), 16, 16)) -> intp(0, 0, e)
	.word 0x8795e0bc  ! 266: WRPR_TT_I	wrpr	%r23, 0x00bc, %tt
	.word 0xbde52078  ! 269: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xb750c000  ! 270: RDPR_TT	<illegal instruction>
	.word 0x8194607e  ! 272: WRPR_TPC_I	wrpr	%r17, 0x007e, %tpc
	.word 0xb1e461bf  ! 276: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb1500000  ! 280: RDPR_TPC	<illegal instruction>
	.word 0xb5e56162  ! 284: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb1e4e10e  ! 285: SAVE_I	save	%r19, 0x0001, %r24
	mov	2, %r14
	.word 0xa193a000  ! 287: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb1e46188  ! 288: SAVE_I	save	%r17, 0x0001, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81983b1b  ! 295: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b1b, %hpstate
	.word 0xb1e5e050  ! 296: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb7e4e03c  ! 297: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb7e4a03a  ! 298: SAVE_I	save	%r18, 0x0001, %r27
	ta	T_CHANGE_HPRIV
	.word 0x819829d3  ! 299: WRHPR_HPSTATE_I	wrhpr	%r0, 0x09d3, %hpstate
	.word 0xb415c000  ! 301: OR_R	or 	%r23, %r0, %r26
	.word 0xb9e56040  ! 303: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xb40de13f  ! 304: AND_I	and 	%r23, 0x013f, %r26
	.word 0xb551c000  ! 305: RDPR_TL	<illegal instruction>
	.word 0xb1510000  ! 306: RDPR_TICK	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982e99  ! 309: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e99, %hpstate
	.word 0xb3e5e1a9  ! 312: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb5500000  ! 315: RDPR_TPC	<illegal instruction>
	.word 0xb8b54000  ! 316: ORNcc_R	orncc 	%r21, %r0, %r28
	.word 0xb551c000  ! 320: RDPR_TL	<illegal instruction>
	.word 0xbc458000  ! 321: ADDC_R	addc 	%r22, %r0, %r30
	.word 0xbbe5a1b0  ! 323: SAVE_I	save	%r22, 0x0001, %r29
	.word 0x8195e0a9  ! 325: WRPR_TPC_I	wrpr	%r23, 0x00a9, %tpc
	.word 0xbde520c4  ! 327: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xbbe4e1ac  ! 328: SAVE_I	save	%r19, 0x0001, %r29
hwintr_0_14:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_14), 16, 16)) -> intp(0, 0, 9)
	.word 0xb1e56144  ! 331: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xbbe5e128  ! 333: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb9e4617e  ! 335: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xb1e520a8  ! 336: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb7e4614f  ! 337: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xbde46131  ! 338: SAVE_I	save	%r17, 0x0001, %r30
hwintr_0_15:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_15), 16, 16)) -> intp(0, 0, 1b)
	.word 0xb9e561ba  ! 341: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xba1c2117  ! 342: XOR_I	xor 	%r16, 0x0117, %r29
	.word 0xbfe4e068  ! 349: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb551c000  ! 353: RDPR_TL	<illegal instruction>
	.word 0xb41521ff  ! 354: OR_I	or 	%r20, 0x01ff, %r26
	.word 0xb20de131  ! 359: AND_I	and 	%r23, 0x0131, %r25
	.word 0xbbe4208b  ! 361: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb5e5613b  ! 362: SAVE_I	save	%r21, 0x0001, %r26
hwintr_0_16:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_16), 16, 16)) -> intp(0, 0, 21)
	.word 0x8d9460e8  ! 364: WRPR_PSTATE_I	wrpr	%r17, 0x00e8, %pstate
	.word 0xb5e42097  ! 369: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xb17d4400  ! 370: MOVR_R	movre	%r21, %r0, %r24
	.word 0xb9e5a04e  ! 374: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xb7e4a153  ! 375: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xbbe5a1b8  ! 379: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb1e4a1d1  ! 380: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xbde4a14e  ! 383: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb1518000  ! 384: RDPR_PSTATE	<illegal instruction>
	.word 0xbfe5a01c  ! 387: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xbde5e153  ! 389: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xbb51c000  ! 391: RDPR_TL	<illegal instruction>
	.word 0xb3e5a1f1  ! 396: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xbfe4e1e7  ! 397: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbde56128  ! 400: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xbbe5604d  ! 402: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xbf2d0000  ! 405: SLL_R	sll 	%r20, %r0, %r31
	.word 0xb9e5202c  ! 410: SAVE_I	save	%r20, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	ta	T_CHANGE_HPRIV
	.word 0x81983d81  ! 418: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d81, %hpstate
	.word 0x8595a0c1  ! 419: WRPR_TSTATE_I	wrpr	%r22, 0x00c1, %tstate
	.word 0xb9e4a01b  ! 428: SAVE_I	save	%r18, 0x0001, %r28
	.word 0x8594610f  ! 429: WRPR_TSTATE_I	wrpr	%r17, 0x010f, %tstate
	.word 0xbbe4e087  ! 434: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xb9510000  ! 436: RDPR_TICK	<illegal instruction>
	.word 0xbbe421ca  ! 437: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xbc248000  ! 440: SUB_R	sub 	%r18, %r0, %r30
	.word 0xb1e46116  ! 444: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb9e4a01e  ! 446: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xbde420d7  ! 449: SAVE_I	save	%r16, 0x0001, %r30
	mov	2, %r12
	.word 0x8f932000  ! 450: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb17d4400  ! 451: MOVR_R	movre	%r21, %r0, %r24
	.word 0xb5e5600a  ! 454: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xbb510000  ! 458: RDPR_TICK	<illegal instruction>
	.word 0xbde52043  ! 462: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xb3e5203f  ! 465: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xbbe52186  ! 466: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xbb50c000  ! 468: RDPR_TT	<illegal instruction>
	.word 0xb3e5e169  ! 469: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbde46056  ! 471: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb1e4e030  ! 473: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb7e4204f  ! 477: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb7e4e065  ! 479: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb5e52096  ! 480: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xbd520000  ! 481: RDPR_PIL	<illegal instruction>
	.word 0xbab5c000  ! 482: SUBCcc_R	orncc 	%r23, %r0, %r29
	.word 0xb5e5e0a4  ! 485: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xbd51c000  ! 487: RDPR_TL	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982d13  ! 494: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d13, %hpstate
	.word 0xbf480000  ! 496: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xb1e5e142  ! 500: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xbde4200c  ! 502: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xbbe46044  ! 504: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xbb500000  ! 505: RDPR_TPC	<illegal instruction>
	.word 0xb7518000  ! 513: RDPR_PSTATE	<illegal instruction>
	.word 0xb1e561e8  ! 514: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb9e46197  ! 518: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xbf50c000  ! 524: RDPR_TT	<illegal instruction>
	.word 0xb7e5e12d  ! 526: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xbd540000  ! 527: RDPR_GL	<illegal instruction>
	.word 0x8595a049  ! 530: WRPR_TSTATE_I	wrpr	%r22, 0x0049, %tstate
	.word 0xbb7dc400  ! 531: MOVR_R	movre	%r23, %r0, %r29
	.word 0xb3480000  ! 532: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xb8adc000  ! 536: ANDNcc_R	andncc 	%r23, %r0, %r28
hwintr_0_17:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_17), 16, 16)) -> intp(0, 0, 4)
	.word 0xb28c21f5  ! 538: ANDcc_I	andcc 	%r16, 0x01f5, %r25
hwintr_0_18:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_18), 16, 16)) -> intp(0, 0, 11)
	.word 0xb3e521b8  ! 545: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb1e46028  ! 546: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb1e5e02c  ! 547: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb150c000  ! 548: RDPR_TT	<illegal instruction>
	.word 0xbb51c000  ! 549: RDPR_TL	<illegal instruction>
	.word 0xbd2ca001  ! 550: SLL_I	sll 	%r18, 0x0001, %r30
	.word 0xb3e5a0af  ! 554: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb5e42036  ! 557: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xb1540000  ! 559: RDPR_GL	<illegal instruction>
	.word 0xb025c000  ! 561: SUB_R	sub 	%r23, %r0, %r24
	.word 0xb9e5a0b7  ! 562: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xb5e56018  ! 563: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb9508000  ! 564: RDPR_TSTATE	<illegal instruction>
	.word 0x9195a036  ! 565: WRPR_PIL_I	wrpr	%r22, 0x0036, %pil
	ta	T_CHANGE_HPRIV
	.word 0x81982e01  ! 567: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e01, %hpstate
	.word 0xbfe560b5  ! 571: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xbfe4a1ab  ! 575: SAVE_I	save	%r18, 0x0001, %r31
hwintr_0_19:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_19), 16, 16)) -> intp(0, 0, 2a)
	.word 0xb9e4a185  ! 584: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xb1e42132  ! 589: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xbbe56099  ! 590: SAVE_I	save	%r21, 0x0001, %r29
	mov	1, %r14
	.word 0xa193a000  ! 594: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_0_20:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_20), 16, 16)) -> intp(0, 0, 3e)
	.word 0xbfe4e09b  ! 596: SAVE_I	save	%r19, 0x0001, %r31
hwintr_0_21:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_21), 16, 16)) -> intp(0, 0, 21)
hwintr_0_22:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_22), 16, 16)) -> intp(0, 0, 26)
	.word 0xbfe5205a  ! 601: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xb1e56001  ! 602: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xbd520000  ! 605: RDPR_PIL	<illegal instruction>
	.word 0x899421f0  ! 608: WRPR_TICK_I	wrpr	%r16, 0x01f0, %tick
	.word 0xbe444000  ! 609: ADDC_R	addc 	%r17, %r0, %r31
hwintr_0_23:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_23), 16, 16)) -> intp(0, 0, 23)
	.word 0xb3e56139  ! 613: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xbe1da179  ! 614: XOR_I	xor 	%r22, 0x0179, %r31
	.word 0xbde4a1e3  ! 615: SAVE_I	save	%r18, 0x0001, %r30
	mov	0, %r12
	.word 0x8f932000  ! 620: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbbe4a147  ! 624: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xbde56105  ! 628: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb3e520d5  ! 629: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb8054000  ! 631: ADD_R	add 	%r21, %r0, %r28
	.word 0xb7e52009  ! 632: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xb02c60f5  ! 633: ANDN_I	andn 	%r17, 0x00f5, %r24
	.word 0x8d952066  ! 634: WRPR_PSTATE_I	wrpr	%r20, 0x0066, %pstate
	ta	T_CHANGE_HPRIV
	.word 0x81982883  ! 635: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0883, %hpstate
	.word 0xbfe5a1df  ! 640: SAVE_I	save	%r22, 0x0001, %r31
	mov	1, %r14
	.word 0xa193a000  ! 645: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8395a1c5  ! 646: WRPR_TNPC_I	wrpr	%r22, 0x01c5, %tnpc
	.word 0xb0adc000  ! 648: ANDNcc_R	andncc 	%r23, %r0, %r24
	.word 0xbbe5215a  ! 649: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xbde4a016  ! 652: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb7e421cf  ! 653: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xbbe5e095  ! 658: SAVE_I	save	%r23, 0x0001, %r29
	.word 0x8995212f  ! 668: WRPR_TICK_I	wrpr	%r20, 0x012f, %tick
	.word 0xb3e420dc  ! 670: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xb9e56076  ! 672: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xb5e4a17d  ! 675: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb751c000  ! 678: RDPR_TL	<illegal instruction>
	.word 0xb9e5e0f6  ! 680: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbeac605b  ! 682: ANDNcc_I	andncc 	%r17, 0x005b, %r31
	.word 0xb9e5e056  ! 686: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbde5606b  ! 693: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb2a54000  ! 694: SUBcc_R	subcc 	%r21, %r0, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81983cdb  ! 695: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1cdb, %hpstate
	.word 0xbd540000  ! 698: RDPR_GL	<illegal instruction>
hwintr_0_24:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_24), 16, 16)) -> intp(0, 0, 28)
	.word 0xb3e52177  ! 703: SAVE_I	save	%r20, 0x0001, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81983851  ! 706: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1851, %hpstate
hwintr_0_25:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_25), 16, 16)) -> intp(0, 0, 27)
	.word 0xb7e5a1aa  ! 709: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb1e4e178  ! 710: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbbe5a06d  ! 711: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xbbe5a048  ! 714: SAVE_I	save	%r22, 0x0001, %r29
	.word 0x87946166  ! 718: WRPR_TT_I	wrpr	%r17, 0x0166, %tt
	.word 0xbfe5a127  ! 720: SAVE_I	save	%r22, 0x0001, %r31
hwintr_0_26:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_26), 16, 16)) -> intp(0, 0, 2)
	.word 0xbde5a0ed  ! 723: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xbc2ce12b  ! 725: ANDN_I	andn 	%r19, 0x012b, %r30
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
hwintr_0_27:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_27), 16, 16)) -> intp(0, 0, 4)
	.word 0xbbe4e1e6  ! 730: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xb7e420da  ! 731: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb5e4210f  ! 734: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xbf50c000  ! 738: RDPR_TT	<illegal instruction>
	.word 0xb2c58000  ! 739: ADDCcc_R	addccc 	%r22, %r0, %r25
hwintr_0_28:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_28), 16, 16)) -> intp(0, 0, 26)
hwintr_0_29:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_29), 16, 16)) -> intp(0, 0, e)
hwintr_0_30:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_30), 16, 16)) -> intp(0, 0, 3f)
hwintr_0_31:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_31), 16, 16)) -> intp(0, 0, 1)
hwintr_0_32:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_32), 16, 16)) -> intp(0, 0, 14)
	.word 0xb7e56138  ! 753: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xb9e5213f  ! 760: SAVE_I	save	%r20, 0x0001, %r28
	.word 0x8394e01d  ! 762: WRPR_TNPC_I	wrpr	%r19, 0x001d, %tnpc
hwintr_0_33:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_33), 16, 16)) -> intp(0, 0, 6)
	.word 0xb1500000  ! 768: RDPR_TPC	<illegal instruction>
	.word 0xb3518000  ! 774: RDPR_PSTATE	<illegal instruction>
	.word 0x83946051  ! 776: WRPR_TNPC_I	wrpr	%r17, 0x0051, %tnpc
	.word 0xbbe4a0ed  ! 777: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xb7e5a121  ! 779: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb5e42134  ! 780: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xbfe4a049  ! 781: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbbe420cf  ! 782: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb1e5a084  ! 783: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb9520000  ! 784: RDPR_PIL	<illegal instruction>
	.word 0xb9e5e1ad  ! 788: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbabd2010  ! 790: XNORcc_I	xnorcc 	%r20, 0x0010, %r29
	.word 0xb64460e9  ! 792: ADDC_I	addc 	%r17, 0x00e9, %r27
	.word 0xb9e4218b  ! 793: SAVE_I	save	%r16, 0x0001, %r28
hwintr_0_34:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_34), 16, 16)) -> intp(0, 0, 3f)
	.word 0xb5e42000  ! 799: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xbbe5e060  ! 809: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbc9dc000  ! 812: XORcc_R	xorcc 	%r23, %r0, %r30
	.word 0xbbe460a3  ! 815: SAVE_I	save	%r17, 0x0001, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81983c49  ! 818: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c49, %hpstate
	.word 0xb1e5a1e9  ! 823: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xbbe4e17d  ! 825: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xbfe5e011  ! 827: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xb5e4a10f  ! 828: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbe45e1ce  ! 830: ADDC_I	addc 	%r23, 0x01ce, %r31
hwintr_0_35:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_35), 16, 16)) -> intp(0, 0, 1f)
	.word 0xb9e56124  ! 832: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xb634a197  ! 833: SUBC_I	orn 	%r18, 0x0197, %r27
	.word 0xb5e4a0e3  ! 836: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb3e421be  ! 837: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xb22c0000  ! 842: ANDN_R	andn 	%r16, %r0, %r25
	.word 0xb1e460ae  ! 844: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbde5a0f3  ! 845: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xb7e4a07d  ! 847: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xbfe4e158  ! 852: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbbe4a18d  ! 853: SAVE_I	save	%r18, 0x0001, %r29
hwintr_0_36:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_36), 16, 16)) -> intp(0, 0, 1e)
	.word 0x8d9420b4  ! 860: WRPR_PSTATE_I	wrpr	%r16, 0x00b4, %pstate
	.word 0xbfe420f7  ! 861: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xbc858000  ! 862: ADDcc_R	addcc 	%r22, %r0, %r30
	.word 0x899521ab  ! 866: WRPR_TICK_I	wrpr	%r20, 0x01ab, %tick
	.word 0xb7e5217c  ! 870: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xbcbc0000  ! 872: XNORcc_R	xnorcc 	%r16, %r0, %r30
	.word 0xbde4e034  ! 873: SAVE_I	save	%r19, 0x0001, %r30
	mov	1, %r12
	.word 0x8f932000  ! 878: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb9e46145  ! 879: SAVE_I	save	%r17, 0x0001, %r28
hwintr_0_37:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_37), 16, 16)) -> intp(0, 0, 33)
	.word 0xb7e560ee  ! 884: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xbb51c000  ! 886: RDPR_TL	<illegal instruction>
	.word 0xbfe4a194  ! 890: SAVE_I	save	%r18, 0x0001, %r31
	.word 0x81946165  ! 891: WRPR_TPC_I	wrpr	%r17, 0x0165, %tpc
	.word 0xb0c4e16e  ! 893: ADDCcc_I	addccc 	%r19, 0x016e, %r24
	.word 0xb9e42151  ! 895: SAVE_I	save	%r16, 0x0001, %r28
	mov	1, %r12
	.word 0x8f932000  ! 896: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbde4a025  ! 898: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb5518000  ! 901: RDPR_PSTATE	<illegal instruction>
	.word 0xb9e520f8  ! 903: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb5e5a06a  ! 904: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xb32d4000  ! 907: SLL_R	sll 	%r21, %r0, %r25
	.word 0xb9e4e113  ! 908: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xbbe461f3  ! 909: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xb9e4e124  ! 910: SAVE_I	save	%r19, 0x0001, %r28
	.word 0x8394213a  ! 912: WRPR_TNPC_I	wrpr	%r16, 0x013a, %tnpc
	.word 0xbc942161  ! 913: ORcc_I	orcc 	%r16, 0x0161, %r30
	.word 0xb88da01c  ! 916: ANDcc_I	andcc 	%r22, 0x001c, %r28
	.word 0xb3500000  ! 918: RDPR_TPC	<illegal instruction>
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xb1e4a176  ! 924: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xb1508000  ! 927: RDPR_TSTATE	<illegal instruction>
	.word 0xb7e4e0f3  ! 928: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb750c000  ! 929: RDPR_TT	<illegal instruction>
	.word 0xbaa58000  ! 934: SUBcc_R	subcc 	%r22, %r0, %r29
	.word 0xbf50c000  ! 940: RDPR_TT	<illegal instruction>
hwintr_0_38:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_38), 16, 16)) -> intp(0, 0, 19)
	.word 0xbbe5e168  ! 943: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb9e4e0f4  ! 945: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb9e5e160  ! 947: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbbe46112  ! 950: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xbde5e0c2  ! 953: SAVE_I	save	%r23, 0x0001, %r30
hwintr_0_39:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_39), 16, 16)) -> intp(0, 0, 11)
	ta	T_CHANGE_HPRIV
	.word 0x81983c11  ! 955: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c11, %hpstate
	.word 0xb151c000  ! 958: RDPR_TL	<illegal instruction>
	.word 0xb5e5a0fc  ! 959: SAVE_I	save	%r22, 0x0001, %r26
	.word 0x8d95e089  ! 962: WRPR_PSTATE_I	wrpr	%r23, 0x0089, %pstate
	.word 0xb61d0000  ! 967: XOR_R	xor 	%r20, %r0, %r27
	.word 0xbbe56177  ! 970: SAVE_I	save	%r21, 0x0001, %r29
	mov	1, %r14
	.word 0xa193a000  ! 973: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_0_40:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_40), 16, 16)) -> intp(0, 0, c)
hwintr_0_41:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_41), 16, 16)) -> intp(0, 0, 28)
	.word 0xba940000  ! 984: ORcc_R	orcc 	%r16, %r0, %r29
	.word 0xb2b44000  ! 985: ORNcc_R	orncc 	%r17, %r0, %r25
	.word 0xbbe52139  ! 986: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xb9e4e065  ! 988: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb9e4e047  ! 993: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xbbe5e1e1  ! 994: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb5480000  ! 1004: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xb7e42143  ! 1006: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xbf3d4000  ! 1009: SRA_R	sra 	%r21, %r0, %r31
	.word 0xb5e42100  ! 1011: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xbbe460e8  ! 1015: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xbbe5e009  ! 1021: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbde4a0f7  ! 1025: SAVE_I	save	%r18, 0x0001, %r30
hwintr_0_42:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_42), 16, 16)) -> intp(0, 0, 27)
	.word 0xb9e4e084  ! 1031: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb7e5e0b2  ! 1032: SAVE_I	save	%r23, 0x0001, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982953  ! 1039: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0953, %hpstate
hwintr_0_43:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_43), 16, 16)) -> intp(0, 0, 23)
	mov	0, %r12
	.word 0x8f932000  ! 1047: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x89952165  ! 1048: WRPR_TICK_I	wrpr	%r20, 0x0165, %tick
	.word 0xb9508000  ! 1052: RDPR_TSTATE	<illegal instruction>
	.word 0x879561f1  ! 1053: WRPR_TT_I	wrpr	%r21, 0x01f1, %tt
	.word 0xb4944000  ! 1058: ORcc_R	orcc 	%r17, %r0, %r26
	.word 0xbac54000  ! 1059: ADDCcc_R	addccc 	%r21, %r0, %r29
	.word 0xb5504000  ! 1060: RDPR_TNPC	<illegal instruction>
	.word 0xb3518000  ! 1064: RDPR_PSTATE	<illegal instruction>
	.word 0x8195e099  ! 1065: WRPR_TPC_I	wrpr	%r23, 0x0099, %tpc
	.word 0x8d952080  ! 1070: WRPR_PSTATE_I	wrpr	%r20, 0x0080, %pstate
hwintr_0_44:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_44), 16, 16)) -> intp(0, 0, 3b)
	.word 0xb7540000  ! 1072: RDPR_GL	<illegal instruction>
hwintr_0_45:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_45), 16, 16)) -> intp(0, 0, 2a)
	.word 0xb5e561e4  ! 1075: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb7e5e153  ! 1076: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xbbe5e136  ! 1077: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb3e46039  ! 1079: SAVE_I	save	%r17, 0x0001, %r25
	.word 0x85942158  ! 1080: WRPR_TSTATE_I	wrpr	%r16, 0x0158, %tstate
	.word 0xb7500000  ! 1088: RDPR_TPC	<illegal instruction>
hwintr_0_46:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_46), 16, 16)) -> intp(0, 0, 35)
	.word 0xb3518000  ! 1092: RDPR_PSTATE	<illegal instruction>
	.word 0xb9e4a19e  ! 1094: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xb7e560ff  ! 1095: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xb7e52147  ! 1099: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xbfe42194  ! 1102: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xbe3ce1a9  ! 1103: XNOR_I	xnor 	%r19, 0x01a9, %r31
hwintr_0_47:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_47), 16, 16)) -> intp(0, 0, 1f)
	.word 0x8595e0f8  ! 1106: WRPR_TSTATE_I	wrpr	%r23, 0x00f8, %tstate
	.word 0xb5e4e07c  ! 1111: SAVE_I	save	%r19, 0x0001, %r26
	.word 0x859461fe  ! 1113: WRPR_TSTATE_I	wrpr	%r17, 0x01fe, %tstate
	.word 0xbc2ca15b  ! 1116: ANDN_I	andn 	%r18, 0x015b, %r30
	.word 0xbfe5a0a3  ! 1119: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb49ce12a  ! 1130: XORcc_I	xorcc 	%r19, 0x012a, %r26
	.word 0xb5e4619e  ! 1133: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xbde560cb  ! 1135: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb1e520b2  ! 1138: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb7e4a116  ! 1140: SAVE_I	save	%r18, 0x0001, %r27
hwintr_0_48:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_48), 16, 16)) -> intp(0, 0, 14)
	.word 0xb81ce13d  ! 1149: XOR_I	xor 	%r19, 0x013d, %r28
	.word 0xbd510000  ! 1151: RDPR_TICK	<illegal instruction>
	.word 0xb3500000  ! 1152: RDPR_TPC	<illegal instruction>
	.word 0xb1510000  ! 1155: RDPR_TICK	<illegal instruction>
	.word 0xb9e46126  ! 1162: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xb4ad0000  ! 1164: ANDNcc_R	andncc 	%r20, %r0, %r26
	.word 0xbf50c000  ! 1169: RDPR_TT	<illegal instruction>
	.word 0xb5e4e049  ! 1171: SAVE_I	save	%r19, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	.word 0x819828cb  ! 1173: WRHPR_HPSTATE_I	wrhpr	%r0, 0x08cb, %hpstate
	.word 0xb4bda1fd  ! 1176: XNORcc_I	xnorcc 	%r22, 0x01fd, %r26
	.word 0x8394606b  ! 1186: WRPR_TNPC_I	wrpr	%r17, 0x006b, %tnpc
	.word 0xb3e561a1  ! 1187: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xb3508000  ! 1191: RDPR_TSTATE	<illegal instruction>
	.word 0xbfe4e084  ! 1192: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb9e46114  ! 1195: SAVE_I	save	%r17, 0x0001, %r28
hwintr_0_49:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_49), 16, 16)) -> intp(0, 0, 2f)
	.word 0x8d94a07a  ! 1198: WRPR_PSTATE_I	wrpr	%r18, 0x007a, %pstate
	.word 0xb3e5e06d  ! 1199: SAVE_I	save	%r23, 0x0001, %r25
hwintr_0_50:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_50), 16, 16)) -> intp(0, 0, 19)
hwintr_0_51:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_51), 16, 16)) -> intp(0, 0, 3e)
hwintr_0_52:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_52), 16, 16)) -> intp(0, 0, 0)
	.word 0xb5e5a0c3  ! 1210: SAVE_I	save	%r22, 0x0001, %r26
hwintr_0_53:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_53), 16, 16)) -> intp(0, 0, 2)
	.word 0xbde46104  ! 1215: SAVE_I	save	%r17, 0x0001, %r30
	ta	T_CHANGE_HPRIV
	.word 0x81982bd1  ! 1219: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0bd1, %hpstate
hwintr_0_54:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_54), 16, 16)) -> intp(0, 0, 2)
	ta	T_CHANGE_HPRIV
	.word 0x81982b8b  ! 1223: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b8b, %hpstate
	.word 0xbbe4a04b  ! 1226: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xb1e42115  ! 1227: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xb9e42026  ! 1229: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xb5e4e130  ! 1230: SAVE_I	save	%r19, 0x0001, %r26
hwintr_0_55:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_55), 16, 16)) -> intp(0, 0, 25)
	.word 0xb1e56007  ! 1233: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb0b4a049  ! 1235: SUBCcc_I	orncc 	%r18, 0x0049, %r24
	.word 0xbbe4e1e1  ! 1236: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xb1e42093  ! 1238: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xb7e421ca  ! 1241: SAVE_I	save	%r16, 0x0001, %r27
	.word 0x8795600c  ! 1242: WRPR_TT_I	wrpr	%r21, 0x000c, %tt
	.word 0xb3e46010  ! 1247: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xbfe4a158  ! 1248: SAVE_I	save	%r18, 0x0001, %r31
	ta	T_CHANGE_HPRIV
	.word 0x81982dcb  ! 1249: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dcb, %hpstate
	.word 0xb7e5208f  ! 1254: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xb9e5a008  ! 1255: SAVE_I	save	%r22, 0x0001, %r28
hwintr_0_56:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_56), 16, 16)) -> intp(0, 0, 29)
	.word 0xbf500000  ! 1264: RDPR_TPC	<illegal instruction>
hwintr_0_57:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_57), 16, 16)) -> intp(0, 0, 2a)
	.word 0xbde4a17f  ! 1268: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb3e4e1a9  ! 1271: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb7e4a105  ! 1272: SAVE_I	save	%r18, 0x0001, %r27
	.word 0x8795a126  ! 1273: WRPR_TT_I	wrpr	%r22, 0x0126, %tt
	.word 0x89956037  ! 1274: WRPR_TICK_I	wrpr	%r21, 0x0037, %tick
	.word 0xb1e4e07a  ! 1275: SAVE_I	save	%r19, 0x0001, %r24
	mov	0, %r14
	.word 0xa193a000  ! 1276: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb3e52138  ! 1277: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb5e4e0b1  ! 1278: SAVE_I	save	%r19, 0x0001, %r26
hwintr_0_58:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_58), 16, 16)) -> intp(0, 0, 2f)
hwintr_0_59:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_59), 16, 16)) -> intp(0, 0, 19)
	.word 0xb5e5e08e  ! 1284: SAVE_I	save	%r23, 0x0001, %r26
hwintr_0_60:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_60), 16, 16)) -> intp(0, 0, 1d)
	.word 0xbc45c000  ! 1287: ADDC_R	addc 	%r23, %r0, %r30
	.word 0xbc8d0000  ! 1289: ANDcc_R	andcc 	%r20, %r0, %r30
	.word 0xbebd4000  ! 1292: XNORcc_R	xnorcc 	%r21, %r0, %r31
	.word 0xb1e4e0bb  ! 1293: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbb641800  ! 1298: MOVcc_R	<illegal instruction>
	.word 0xb5e5e1cd  ! 1304: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xbfe46084  ! 1307: SAVE_I	save	%r17, 0x0001, %r31
hwintr_0_61:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_61), 16, 16)) -> intp(0, 0, 28)
	.word 0xb7e5217e  ! 1312: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xb21cc000  ! 1324: XOR_R	xor 	%r19, %r0, %r25
	.word 0xb5e4e184  ! 1328: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xb5e420f1  ! 1331: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xbebc4000  ! 1332: XNORcc_R	xnorcc 	%r17, %r0, %r31
	.word 0xbfe5a013  ! 1335: SAVE_I	save	%r22, 0x0001, %r31
hwintr_0_62:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_62), 16, 16)) -> intp(0, 0, 22)
	.word 0xb6b4c000  ! 1338: ORNcc_R	orncc 	%r19, %r0, %r27
	.word 0xb3e561de  ! 1340: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xb5e5a041  ! 1342: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xb1e4e100  ! 1345: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb9e521c2  ! 1346: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb7e5e19d  ! 1348: SAVE_I	save	%r23, 0x0001, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81983ac3  ! 1353: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1ac3, %hpstate
	.word 0xbde4e06a  ! 1355: SAVE_I	save	%r19, 0x0001, %r30
	.word 0xb9e46003  ! 1359: SAVE_I	save	%r17, 0x0001, %r28
	.word 0x8794e156  ! 1361: WRPR_TT_I	wrpr	%r19, 0x0156, %tt
	.word 0xb1520000  ! 1367: RDPR_PIL	<illegal instruction>
	.word 0xbbe4e11f  ! 1368: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xb5480000  ! 1374: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xb1e5a1ed  ! 1378: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xbde5612f  ! 1381: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xbfe46020  ! 1382: SAVE_I	save	%r17, 0x0001, %r31
	mov	2, %r14
	.word 0xa193a000  ! 1383: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbbe46089  ! 1384: SAVE_I	save	%r17, 0x0001, %r29
hwintr_0_63:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_63), 16, 16)) -> intp(0, 0, a)
	.word 0xb3e4e121  ! 1391: SAVE_I	save	%r19, 0x0001, %r25
hwintr_0_64:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_64), 16, 16)) -> intp(0, 0, e)
	.word 0x91956049  ! 1393: WRPR_PIL_I	wrpr	%r21, 0x0049, %pil
	.word 0xb7e4203c  ! 1394: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xbbe520bc  ! 1401: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xb7e560d7  ! 1403: SAVE_I	save	%r21, 0x0001, %r27
hwintr_0_65:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_65), 16, 16)) -> intp(0, 0, 25)
	mov	0, %r14
	.word 0xa193a000  ! 1411: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb151c000  ! 1413: RDPR_TL	<illegal instruction>
	.word 0xbde5610d  ! 1418: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb9508000  ! 1426: RDPR_TSTATE	<illegal instruction>
	.word 0xb9518000  ! 1427: RDPR_PSTATE	<illegal instruction>
	.word 0xb73c2001  ! 1428: SRA_I	sra 	%r16, 0x0001, %r27
	.word 0xbbe5e11a  ! 1429: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbbe460d1  ! 1434: SAVE_I	save	%r17, 0x0001, %r29
hwintr_0_66:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_66), 16, 16)) -> intp(0, 0, 27)
	.word 0xb7e4a18b  ! 1438: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xb5e4616a  ! 1439: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb2946113  ! 1444: ORcc_I	orcc 	%r17, 0x0113, %r25
hwintr_0_67:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_67), 16, 16)) -> intp(0, 0, 26)
	.word 0xb9e5e1f2  ! 1446: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xb5643801  ! 1448: MOVcc_I	<illegal instruction>
	.word 0xb0acc000  ! 1449: ANDNcc_R	andncc 	%r19, %r0, %r24
	.word 0xb3e52197  ! 1451: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb3e561af  ! 1454: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xb3e5a16a  ! 1456: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb1e561d6  ! 1459: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb9e4a103  ! 1462: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xb52df001  ! 1468: SLLX_I	sllx	%r23, 0x0001, %r26
	.word 0xbde5a110  ! 1469: SAVE_I	save	%r22, 0x0001, %r30
	mov	2, %r14
	.word 0xa193a000  ! 1470: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7e5201f  ! 1472: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xb53ca001  ! 1473: SRA_I	sra 	%r18, 0x0001, %r26
	.word 0xb9643801  ! 1474: MOVcc_I	<illegal instruction>
	.word 0xbb520000  ! 1476: RDPR_PIL	<illegal instruction>
	.word 0xb7e4611d  ! 1478: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xbf520000  ! 1483: RDPR_PIL	<illegal instruction>
	ta	T_CHANGE_HPRIV
T0_spu_op_4:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a43, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xb7e46014  ! 1488: SAVE_I	save	%r17, 0x0001, %r27
	.word 0x919461f9  ! 1489: WRPR_PIL_I	wrpr	%r17, 0x01f9, %pil
	.word 0xbde5e0b1  ! 1491: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xbbe5e000  ! 1496: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbbe5a0ea  ! 1503: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xbde4e054  ! 1504: SAVE_I	save	%r19, 0x0001, %r30
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xbde5e02e  ! 1513: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb5e4e022  ! 1514: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xbbe4e103  ! 1518: SAVE_I	save	%r19, 0x0001, %r29
	.word 0x87942033  ! 1519: WRPR_TT_I	wrpr	%r16, 0x0033, %tt
	.word 0x9194e0ad  ! 1521: WRPR_PIL_I	wrpr	%r19, 0x00ad, %pil
	.word 0xb7e5a0bd  ! 1522: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xbde4e085  ! 1525: SAVE_I	save	%r19, 0x0001, %r30
	ta	T_CHANGE_HPRIV
	.word 0x81982e09  ! 1528: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e09, %hpstate
	.word 0xb1e4a02a  ! 1529: SAVE_I	save	%r18, 0x0001, %r24
hwintr_0_68:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_68), 16, 16)) -> intp(0, 0, 8)
	.word 0xb5e52127  ! 1540: SAVE_I	save	%r20, 0x0001, %r26
	mov	2, %r12
	.word 0x8f932000  ! 1541: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb1e5a0f8  ! 1544: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb7e5a17a  ! 1545: SAVE_I	save	%r22, 0x0001, %r27
	.word 0x8d94214e  ! 1546: WRPR_PSTATE_I	wrpr	%r16, 0x014e, %pstate
	.word 0xb1e5a1b1  ! 1547: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xbbe4617b  ! 1549: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xb1e5e113  ! 1553: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xbde46024  ! 1554: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb7e4a122  ! 1555: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xbbe420af  ! 1556: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb1e46153  ! 1562: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbde4e005  ! 1563: SAVE_I	save	%r19, 0x0001, %r30
	mov	1, %r12
	.word 0x8f932000  ! 1566: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbfe5a0f8  ! 1567: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb7e4604f  ! 1568: SAVE_I	save	%r17, 0x0001, %r27
hwintr_0_69:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_69), 16, 16)) -> intp(0, 0, 14)
	.word 0xb33c2001  ! 1574: SRA_I	sra 	%r16, 0x0001, %r25
	.word 0xb1e4e104  ! 1576: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb3e5e0ab  ! 1578: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb1e4a151  ! 1580: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xb1e5e0aa  ! 1581: SAVE_I	save	%r23, 0x0001, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81983e5b  ! 1584: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e5b, %hpstate
	.word 0xb5e5211e  ! 1585: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xbfe4e116  ! 1587: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbde4a146  ! 1590: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb7e4a088  ! 1594: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xb7e56066  ! 1598: SAVE_I	save	%r21, 0x0001, %r27
	mov	1, %r14
	.word 0xa193a000  ! 1599: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbde460d1  ! 1601: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xbde4a061  ! 1604: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xbde4e133  ! 1605: SAVE_I	save	%r19, 0x0001, %r30
	.word 0xb9520000  ! 1607: RDPR_PIL	<illegal instruction>
	.word 0xb7e520b3  ! 1615: SAVE_I	save	%r20, 0x0001, %r27
	.word 0x8594e18a  ! 1618: WRPR_TSTATE_I	wrpr	%r19, 0x018a, %tstate
	.word 0xb7e4e1c4  ! 1619: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb3e5206a  ! 1620: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb1e4e1e2  ! 1628: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb9520000  ! 1629: RDPR_PIL	<illegal instruction>
	.word 0xb53c2001  ! 1631: SRA_I	sra 	%r16, 0x0001, %r26
	.word 0xb1e4a00a  ! 1636: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xb5518000  ! 1642: RDPR_PSTATE	<illegal instruction>
	.word 0xbb51c000  ! 1644: RDPR_TL	<illegal instruction>
	.word 0xb7e42113  ! 1647: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xbfe420de  ! 1653: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xb3500000  ! 1656: RDPR_TPC	<illegal instruction>
	.word 0xb5e4e0bd  ! 1658: SAVE_I	save	%r19, 0x0001, %r26
	.word 0x8994e0ed  ! 1661: WRPR_TICK_I	wrpr	%r19, 0x00ed, %tick
	.word 0xb9e460d8  ! 1662: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xbde52033  ! 1669: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xb9e4214f  ! 1670: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xb01da1e1  ! 1672: XOR_I	xor 	%r22, 0x01e1, %r24
	.word 0xb9e4607d  ! 1676: SAVE_I	save	%r17, 0x0001, %r28
hwintr_0_70:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_70), 16, 16)) -> intp(0, 0, 3b)
	.word 0xbfe4e0ee  ! 1685: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbd51c000  ! 1687: RDPR_TL	<illegal instruction>
	.word 0xb3e42192  ! 1688: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xb1e561e9  ! 1690: SAVE_I	save	%r21, 0x0001, %r24
	mov	1, %r12
	.word 0x8f932000  ! 1691: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_0_71:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_71), 16, 16)) -> intp(0, 0, 10)
	.word 0xb1e460bf  ! 1700: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb5e560de  ! 1703: SAVE_I	save	%r21, 0x0001, %r26
	.word 0x899560fd  ! 1704: WRPR_TICK_I	wrpr	%r21, 0x00fd, %tick
	mov	1, %r14
	.word 0xa193a000  ! 1705: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbde4a0dc  ! 1706: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb5e560d3  ! 1707: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb1e4a10e  ! 1708: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xb3504000  ! 1709: RDPR_TNPC	<illegal instruction>
	.word 0xb7e520d9  ! 1711: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xbde4a175  ! 1712: SAVE_I	save	%r18, 0x0001, %r30
hwintr_0_72:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_72), 16, 16)) -> intp(0, 0, 14)
hwintr_0_73:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_73), 16, 16)) -> intp(0, 0, 37)
	ta	T_CHANGE_HPRIV
	.word 0x81983853  ! 1719: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1853, %hpstate
	.word 0xbd510000  ! 1722: RDPR_TICK	<illegal instruction>
hwintr_0_74:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_74), 16, 16)) -> intp(0, 0, 20)
	.word 0xba3de06f  ! 1727: XNOR_I	xnor 	%r23, 0x006f, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81982d49  ! 1728: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d49, %hpstate
hwintr_0_75:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_75), 16, 16)) -> intp(0, 0, 32)
hwintr_0_76:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_76), 16, 16)) -> intp(0, 0, 18)
	.word 0xb1e52108  ! 1734: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb5e4a06c  ! 1735: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbf51c000  ! 1737: RDPR_TL	<illegal instruction>
	.word 0xb43c2078  ! 1742: XNOR_I	xnor 	%r16, 0x0078, %r26
	.word 0xb2c46156  ! 1743: ADDCcc_I	addccc 	%r17, 0x0156, %r25
hwintr_0_77:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_77), 16, 16)) -> intp(0, 0, 3b)
	.word 0xb5e561ab  ! 1749: SAVE_I	save	%r21, 0x0001, %r26
	.word 0x8994219c  ! 1750: WRPR_TICK_I	wrpr	%r16, 0x019c, %tick
	.word 0x899421df  ! 1751: WRPR_TICK_I	wrpr	%r16, 0x01df, %tick
	.word 0xb9510000  ! 1758: RDPR_TICK	<illegal instruction>
	.word 0xb1e46194  ! 1760: SAVE_I	save	%r17, 0x0001, %r24
hwintr_0_78:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_78), 16, 16)) -> intp(0, 0, 19)
	.word 0xb950c000  ! 1764: RDPR_TT	<illegal instruction>
	.word 0xb7e4e0b9  ! 1765: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xbe9c8000  ! 1769: XORcc_R	xorcc 	%r18, %r0, %r31
	.word 0x9195a115  ! 1771: WRPR_PIL_I	wrpr	%r22, 0x0115, %pil
	ta	T_CHANGE_HPRIV
	.word 0x81983bcb  ! 1773: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1bcb, %hpstate
	.word 0xb7e5a123  ! 1778: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xbfe5e02a  ! 1780: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xb9e5e08d  ! 1782: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xb7e56011  ! 1788: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xbfe46043  ! 1789: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xbde421c2  ! 1790: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xbfe5a03c  ! 1791: SAVE_I	save	%r22, 0x0001, %r31
hwintr_0_79:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_79), 16, 16)) -> intp(0, 0, d)
	.word 0xb7e4a13e  ! 1795: SAVE_I	save	%r18, 0x0001, %r27
	mov	1, %r12
	.word 0x8f932000  ! 1798: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_0_80:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_80), 16, 16)) -> intp(0, 0, 3a)
	.word 0xb1e521f9  ! 1802: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb3e46150  ! 1803: SAVE_I	save	%r17, 0x0001, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81982d01  ! 1805: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d01, %hpstate
	.word 0xb1e420bc  ! 1806: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xb5e5e166  ! 1809: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xb3e42001  ! 1810: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xb3508000  ! 1811: RDPR_TSTATE	<illegal instruction>
	.word 0xb7e5e0de  ! 1812: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xb1e56089  ! 1816: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xbd7d6401  ! 1817: MOVR_I	movre	%r21, 0x1, %r30
	.word 0xbfe460db  ! 1818: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xbd50c000  ! 1822: RDPR_TT	<illegal instruction>
	.word 0xb3e4a18f  ! 1825: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xb3e5e1cb  ! 1826: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb5e56002  ! 1829: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xbb7de401  ! 1832: MOVR_I	movre	%r23, 0x1, %r29
	.word 0xbfe5e01f  ! 1833: SAVE_I	save	%r23, 0x0001, %r31
hwintr_0_81:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_81), 16, 16)) -> intp(0, 0, 22)
	ta	T_CHANGE_HPRIV
	.word 0x81982ecb  ! 1835: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0ecb, %hpstate
	.word 0xb1e561d0  ! 1838: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb1e4e01b  ! 1839: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb1e46009  ! 1842: SAVE_I	save	%r17, 0x0001, %r24
hwintr_0_82:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_82), 16, 16)) -> intp(0, 0, 34)
	.word 0xbbe4a17a  ! 1847: SAVE_I	save	%r18, 0x0001, %r29
	.word 0x8d946023  ! 1851: WRPR_PSTATE_I	wrpr	%r17, 0x0023, %pstate
	.word 0xb5520000  ! 1854: RDPR_PIL	<illegal instruction>
hwintr_0_83:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_83), 16, 16)) -> intp(0, 0, 24)
	.word 0xbfe5a1c9  ! 1861: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xbbe4a14e  ! 1864: SAVE_I	save	%r18, 0x0001, %r29
	ta	T_CHANGE_HPRIV
T0_spu_op_5:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x20d, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	mov	1, %r12
	.word 0x8f932000  ! 1872: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb5e4a017  ! 1878: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb5e5e1cc  ! 1879: SAVE_I	save	%r23, 0x0001, %r26
	.word 0x9195e0eb  ! 1882: WRPR_PIL_I	wrpr	%r23, 0x00eb, %pil
	.word 0xbbe42155  ! 1884: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb5e5a1b3  ! 1885: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xb5e4a121  ! 1887: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbd518000  ! 1888: RDPR_PSTATE	<illegal instruction>
	.word 0xb73d2001  ! 1891: SRA_I	sra 	%r20, 0x0001, %r27
	.word 0xb5e56069  ! 1897: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb4252081  ! 1898: SUB_I	sub 	%r20, 0x0081, %r26
	.word 0x8195602c  ! 1899: WRPR_TPC_I	wrpr	%r21, 0x002c, %tpc
	.word 0xbbe4a17c  ! 1902: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xb9e4e047  ! 1906: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xbe244000  ! 1909: SUB_R	sub 	%r17, %r0, %r31
	.word 0xb5e5a089  ! 1910: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xb3504000  ! 1911: RDPR_TNPC	<illegal instruction>
	.word 0xb9e420e0  ! 1914: SAVE_I	save	%r16, 0x0001, %r28
	.word 0x8d94a13a  ! 1915: WRPR_PSTATE_I	wrpr	%r18, 0x013a, %pstate
	.word 0xbfe46112  ! 1916: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xb1e46033  ! 1917: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb9e561da  ! 1918: SAVE_I	save	%r21, 0x0001, %r28
hwintr_0_84:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_84), 16, 16)) -> intp(0, 0, 3e)
	.word 0xb7e5215c  ! 1926: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xbbe42009  ! 1927: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xbbe4e006  ! 1929: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xbaacc000  ! 1930: ANDNcc_R	andncc 	%r19, %r0, %r29
	.word 0x8195e159  ! 1936: WRPR_TPC_I	wrpr	%r23, 0x0159, %tpc
hwintr_0_85:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_85), 16, 16)) -> intp(0, 0, b)
	.word 0xb3e5201a  ! 1938: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb1e4e1a2  ! 1940: SAVE_I	save	%r19, 0x0001, %r24
	.word 0x9194214b  ! 1943: WRPR_PIL_I	wrpr	%r16, 0x014b, %pil
	.word 0xbde4205f  ! 1944: SAVE_I	save	%r16, 0x0001, %r30
	.word 0x8d94a1b3  ! 1946: WRPR_PSTATE_I	wrpr	%r18, 0x01b3, %pstate
	.word 0xb3344000  ! 1947: SRL_R	srl 	%r17, %r0, %r25
hwintr_0_86:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_86), 16, 16)) -> intp(0, 0, 11)
	.word 0xb751c000  ! 1954: RDPR_TL	<illegal instruction>
	.word 0xb89521c3  ! 1958: ORcc_I	orcc 	%r20, 0x01c3, %r28
hwintr_0_87:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_87), 16, 16)) -> intp(0, 0, 2e)
	.word 0xb73da001  ! 1965: SRA_I	sra 	%r22, 0x0001, %r27
hwintr_0_88:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_88), 16, 16)) -> intp(0, 0, 18)
	.word 0xbbe46155  ! 1971: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xb3e460c0  ! 1972: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb5508000  ! 1974: RDPR_TSTATE	<illegal instruction>
	.word 0xb9540000  ! 1978: RDPR_GL	<illegal instruction>
	.word 0xbde561a7  ! 1981: SAVE_I	save	%r21, 0x0001, %r30
	.word 0x9194e15b  ! 1982: WRPR_PIL_I	wrpr	%r19, 0x015b, %pil
	.word 0x9194e0d1  ! 1983: WRPR_PIL_I	wrpr	%r19, 0x00d1, %pil
	.word 0xbf34e001  ! 1985: SRL_I	srl 	%r19, 0x0001, %r31
	.word 0xb3e42150  ! 1987: SAVE_I	save	%r16, 0x0001, %r25
hwintr_0_89:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_89), 16, 16)) -> intp(0, 0, 1d)
	mov	1, %r14
	.word 0xa193a000  ! 1996: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9e4a195  ! 1998: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xb5e5a070  ! 2002: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xb5e561e4  ! 2003: SAVE_I	save	%r21, 0x0001, %r26
hwintr_0_90:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_90), 16, 16)) -> intp(0, 0, 9)
	.word 0x8795a00a  ! 2009: WRPR_TT_I	wrpr	%r22, 0x000a, %tt
hwintr_0_91:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_91), 16, 16)) -> intp(0, 0, 36)
	.word 0xbde5608d  ! 2020: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb0454000  ! 2024: ADDC_R	addc 	%r21, %r0, %r24
	.word 0xbbe5219b  ! 2027: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xbb51c000  ! 2028: RDPR_TL	<illegal instruction>
	.word 0xbb520000  ! 2029: RDPR_PIL	<illegal instruction>
hwintr_0_92:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_92), 16, 16)) -> intp(0, 0, 17)
	.word 0xbfe5a1a5  ! 2031: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb5e561f7  ! 2035: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xbfe460a6  ! 2043: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xbfe46021  ! 2047: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xb9e5a019  ! 2048: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xbbe420ff  ! 2049: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb1e5609b  ! 2050: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb3e5616d  ! 2054: SAVE_I	save	%r21, 0x0001, %r25
	.word 0x8194a187  ! 2056: WRPR_TPC_I	wrpr	%r18, 0x0187, %tpc
	.word 0xb22cc000  ! 2060: ANDN_R	andn 	%r19, %r0, %r25
	.word 0x8194e12d  ! 2064: WRPR_TPC_I	wrpr	%r19, 0x012d, %tpc
	.word 0xb9e461f4  ! 2065: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xba8de1cf  ! 2067: ANDcc_I	andcc 	%r23, 0x01cf, %r29
	.word 0xbbe560a0  ! 2069: SAVE_I	save	%r21, 0x0001, %r29
hwintr_0_93:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_93), 16, 16)) -> intp(0, 0, 1)
	.word 0xb7e5618d  ! 2086: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xbbe4e048  ! 2088: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xb7e4a10c  ! 2093: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xbb504000  ! 2094: RDPR_TNPC	<illegal instruction>
	.word 0x839521f1  ! 2096: WRPR_TNPC_I	wrpr	%r20, 0x01f1, %tnpc
	.word 0xb1e4e04c  ! 2097: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbfe42016  ! 2103: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xb5e5e07d  ! 2104: SAVE_I	save	%r23, 0x0001, %r26
hwintr_0_94:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_94), 16, 16)) -> intp(0, 0, c)
	.word 0xb3480000  ! 2109: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xb9510000  ! 2111: RDPR_TICK	<illegal instruction>
	.word 0xb614a128  ! 2113: OR_I	or 	%r18, 0x0128, %r27
	.word 0xbfe4e0cb  ! 2114: SAVE_I	save	%r19, 0x0001, %r31
	.word 0x8994a1d3  ! 2115: WRPR_TICK_I	wrpr	%r18, 0x01d3, %tick
	.word 0xb9e521f3  ! 2117: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb1e42052  ! 2119: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xb551c000  ! 2122: RDPR_TL	<illegal instruction>
	.word 0xbe04207c  ! 2123: ADD_I	add 	%r16, 0x007c, %r31
	.word 0xb3e5a0ea  ! 2125: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb2858000  ! 2128: ADDcc_R	addcc 	%r22, %r0, %r25
	.word 0xba24c000  ! 2130: SUB_R	sub 	%r19, %r0, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81983d89  ! 2131: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d89, %hpstate
	.word 0xbfe4e0ad  ! 2133: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbbe5e0c1  ! 2134: SAVE_I	save	%r23, 0x0001, %r29
	mov	0, %r12
	.word 0x8f932000  ! 2138: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb3e5605d  ! 2139: SAVE_I	save	%r21, 0x0001, %r25
hwintr_0_95:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_95), 16, 16)) -> intp(0, 0, 12)
	.word 0xb835e1f3  ! 2143: SUBC_I	orn 	%r23, 0x01f3, %r28
hwintr_0_96:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_96), 16, 16)) -> intp(0, 0, 3a)
	mov	2, %r14
	.word 0xa193a000  ! 2148: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb3e5219a  ! 2150: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb7e5a060  ! 2155: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xbd504000  ! 2156: RDPR_TNPC	<illegal instruction>
	mov	0, %r12
	.word 0x8f932000  ! 2161: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbbe52135  ! 2163: SAVE_I	save	%r20, 0x0001, %r29
	.word 0x8594e046  ! 2167: WRPR_TSTATE_I	wrpr	%r19, 0x0046, %tstate
	.word 0xb7e42075  ! 2171: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb7510000  ! 2173: RDPR_TICK	<illegal instruction>
	.word 0xb3e5e047  ! 2174: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbde5e193  ! 2180: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xbbe461b2  ! 2182: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xbfe4e05c  ! 2184: SAVE_I	save	%r19, 0x0001, %r31
	.word 0x85952120  ! 2186: WRPR_TSTATE_I	wrpr	%r20, 0x0120, %tstate
	.word 0xb5e461bc  ! 2191: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xbf510000  ! 2192: RDPR_TICK	<illegal instruction>
	.word 0xbbe560d8  ! 2194: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb7e5202f  ! 2195: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xb7e520cc  ! 2197: SAVE_I	save	%r20, 0x0001, %r27
hwintr_0_97:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_97), 16, 16)) -> intp(0, 0, 27)
	.word 0xb1e4a12f  ! 2201: SAVE_I	save	%r18, 0x0001, %r24
	mov	1, %r12
	.word 0x8f932000  ! 2202: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbfe420ed  ! 2203: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xbfe520d4  ! 2204: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xb3e4a0d2  ! 2205: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xbb510000  ! 2207: RDPR_TICK	<illegal instruction>
hwintr_0_98:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_98), 16, 16)) -> intp(0, 0, 3a)
	.word 0x8794e10c  ! 2218: WRPR_TT_I	wrpr	%r19, 0x010c, %tt
	.word 0xbde5213c  ! 2219: SAVE_I	save	%r20, 0x0001, %r30
hwintr_0_99:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_99), 16, 16)) -> intp(0, 0, c)
	.word 0xb5508000  ! 2228: RDPR_TSTATE	<illegal instruction>
	mov	1, %r12
	.word 0x8f932000  ! 2230: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_0_100:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_100), 16, 16)) -> intp(0, 0, 1b)
	.word 0xb32cd000  ! 2233: SLLX_R	sllx	%r19, %r0, %r25
	.word 0xb1e561cf  ! 2235: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xbfe4e0c0  ! 2236: SAVE_I	save	%r19, 0x0001, %r31
	ta	T_CHANGE_HPRIV
	.word 0x81982c13  ! 2240: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c13, %hpstate
hwintr_0_101:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_101), 16, 16)) -> intp(0, 0, 37)
	.word 0xb3643801  ! 2246: MOVcc_I	<illegal instruction>
	.word 0xbfe5205c  ! 2252: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xb5643801  ! 2256: MOVcc_I	<illegal instruction>
	.word 0xb150c000  ! 2258: RDPR_TT	<illegal instruction>
	.word 0xbfe561db  ! 2266: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xb1e561d6  ! 2267: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xbfe4a1c2  ! 2269: SAVE_I	save	%r18, 0x0001, %r31
hwintr_0_102:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_102), 16, 16)) -> intp(0, 0, 1)
hwintr_0_103:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_103), 16, 16)) -> intp(0, 0, 18)
	.word 0xb1504000  ! 2274: RDPR_TNPC	<illegal instruction>
	mov	0, %r14
	.word 0xa193a000  ! 2277: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xb6a40000  ! 2281: SUBcc_R	subcc 	%r16, %r0, %r27
	.word 0xbde420c8  ! 2282: SAVE_I	save	%r16, 0x0001, %r30
hwintr_0_104:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_104), 16, 16)) -> intp(0, 0, 36)
	.word 0xbde561d0  ! 2286: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb1e42188  ! 2288: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xbbe4a0fe  ! 2289: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xb5500000  ! 2292: RDPR_TPC	<illegal instruction>
	.word 0xb4946107  ! 2296: ORcc_I	orcc 	%r17, 0x0107, %r26
	.word 0xbfe5a046  ! 2302: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb5e4a071  ! 2303: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb9e5616e  ! 2304: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xb5e4a1fd  ! 2305: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbfe4e192  ! 2307: SAVE_I	save	%r19, 0x0001, %r31
	.word 0x899421c5  ! 2309: WRPR_TICK_I	wrpr	%r16, 0x01c5, %tick
	.word 0xb1e5609e  ! 2310: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xbbe5e003  ! 2311: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbfe560c6  ! 2313: SAVE_I	save	%r21, 0x0001, %r31
	.word 0x9195a1c5  ! 2317: WRPR_PIL_I	wrpr	%r22, 0x01c5, %pil
	.word 0xb7e521bb  ! 2320: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xbbe4a16d  ! 2324: SAVE_I	save	%r18, 0x0001, %r29
hwintr_0_105:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_105), 16, 16)) -> intp(0, 0, 1e)
	ta	T_CHANGE_HPRIV
	.word 0x81983893  ! 2327: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1893, %hpstate
	.word 0xbbe4617f  ! 2328: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xb3520000  ! 2332: RDPR_PIL	<illegal instruction>
	.word 0xb9504000  ! 2334: RDPR_TNPC	<illegal instruction>
hwintr_0_106:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_106), 16, 16)) -> intp(0, 0, 14)
	.word 0xb1508000  ! 2339: RDPR_TSTATE	<illegal instruction>
	.word 0xb7520000  ! 2341: RDPR_PIL	<illegal instruction>
	.word 0xb9e56158  ! 2343: SAVE_I	save	%r21, 0x0001, %r28
hwintr_0_107:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_107), 16, 16)) -> intp(0, 0, 27)
	.word 0xb9e4a126  ! 2347: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xb1e5a104  ! 2348: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb5508000  ! 2351: RDPR_TSTATE	<illegal instruction>
	.word 0xbcac4000  ! 2353: ANDNcc_R	andncc 	%r17, %r0, %r30
	.word 0xbd50c000  ! 2355: RDPR_TT	<illegal instruction>
hwintr_0_108:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_108), 16, 16)) -> intp(0, 0, 7)
	ta	T_CHANGE_HPRIV
	.word 0x8198295b  ! 2358: WRHPR_HPSTATE_I	wrhpr	%r0, 0x095b, %hpstate
	.word 0xb5e560fc  ! 2359: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xbca5e140  ! 2361: SUBcc_I	subcc 	%r23, 0x0140, %r30
	.word 0xba84e1f4  ! 2365: ADDcc_I	addcc 	%r19, 0x01f4, %r29
	mov	2, %r12
	.word 0x8f932000  ! 2367: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb3504000  ! 2369: RDPR_TNPC	<illegal instruction>
	.word 0xb1e4a01d  ! 2370: SAVE_I	save	%r18, 0x0001, %r24
	.word 0x8594e0c4  ! 2371: WRPR_TSTATE_I	wrpr	%r19, 0x00c4, %tstate
	.word 0xb7e4212e  ! 2380: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb7e5a1b2  ! 2383: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb89cc000  ! 2385: XORcc_R	xorcc 	%r19, %r0, %r28
	.word 0x8d94a1fa  ! 2388: WRPR_PSTATE_I	wrpr	%r18, 0x01fa, %pstate
	.word 0xbd2d6001  ! 2389: SLL_I	sll 	%r21, 0x0001, %r30
	.word 0xb5e5e100  ! 2391: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xbb3ca001  ! 2392: SRA_I	sra 	%r18, 0x0001, %r29
	.word 0xbe25208a  ! 2393: SUB_I	sub 	%r20, 0x008a, %r31
	.word 0xb01520dd  ! 2395: OR_I	or 	%r20, 0x00dd, %r24
	.word 0xb8358000  ! 2397: ORN_R	orn 	%r22, %r0, %r28
	.word 0xbbe4e186  ! 2401: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xbf50c000  ! 2405: RDPR_TT	<illegal instruction>
	.word 0xbfe4e115  ! 2409: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb5e521ea  ! 2412: SAVE_I	save	%r20, 0x0001, %r26
hwintr_0_109:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_109), 16, 16)) -> intp(0, 0, 4)
	.word 0xb5e4617c  ! 2424: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb5e4617b  ! 2425: SAVE_I	save	%r17, 0x0001, %r26
	mov	2, %r14
	.word 0xa193a000  ! 2427: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb02d21c4  ! 2434: ANDN_I	andn 	%r20, 0x01c4, %r24
	.word 0xbde5612b  ! 2438: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb5e4617e  ! 2439: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb5e521f7  ! 2442: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb7e46195  ! 2445: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xb3e4e07c  ! 2447: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xbde52023  ! 2448: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xbfe4a004  ! 2450: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbaa5216a  ! 2454: SUBcc_I	subcc 	%r20, 0x016a, %r29
	.word 0xb9e4619f  ! 2456: SAVE_I	save	%r17, 0x0001, %r28
hwintr_0_110:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_110), 16, 16)) -> intp(0, 0, 16)
	.word 0xb3508000  ! 2462: RDPR_TSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81983b93  ! 2464: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b93, %hpstate
	.word 0x899420d6  ! 2467: WRPR_TICK_I	wrpr	%r16, 0x00d6, %tick
	.word 0xb6b48000  ! 2468: ORNcc_R	orncc 	%r18, %r0, %r27
	.word 0xbb480000  ! 2474: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xbd50c000  ! 2475: RDPR_TT	<illegal instruction>
hwintr_0_111:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_111), 16, 16)) -> intp(0, 0, 16)
	.word 0xb9510000  ! 2478: RDPR_TICK	<illegal instruction>
	.word 0x8995e08a  ! 2479: WRPR_TICK_I	wrpr	%r23, 0x008a, %tick
hwintr_0_112:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_112), 16, 16)) -> intp(0, 0, 16)
	.word 0xb3504000  ! 2485: RDPR_TNPC	<illegal instruction>
hwintr_0_113:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_113), 16, 16)) -> intp(0, 0, 2d)
	.word 0xbbe5e06c  ! 2494: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb7e56025  ! 2496: SAVE_I	save	%r21, 0x0001, %r27
hwintr_0_114:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_114), 16, 16)) -> intp(0, 0, 13)
	.word 0xb9500000  ! 2503: RDPR_TPC	<illegal instruction>
	mov	0, %r14
	.word 0xa193a000  ! 2513: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8195a1ad  ! 2514: WRPR_TPC_I	wrpr	%r22, 0x01ad, %tpc
	.word 0xbd3c9000  ! 2520: SRAX_R	srax	%r18, %r0, %r30
	.word 0xb1e5601b  ! 2527: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb7e5a186  ! 2531: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb5e5a19a  ! 2532: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xb1e4e0f4  ! 2536: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbde5a160  ! 2537: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xb5e4a1b8  ! 2538: SAVE_I	save	%r18, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xbde421ea  ! 2545: SAVE_I	save	%r16, 0x0001, %r30
hwintr_0_115:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_115), 16, 16)) -> intp(0, 0, 2c)
	.word 0xbfe4e008  ! 2553: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb1e5e179  ! 2556: SAVE_I	save	%r23, 0x0001, %r24
	mov	0, %r12
	.word 0x8f932000  ! 2557: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbbe5604e  ! 2561: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb33cf001  ! 2563: SRAX_I	srax	%r19, 0x0001, %r25
	.word 0xbac58000  ! 2565: ADDCcc_R	addccc 	%r22, %r0, %r29
	.word 0xb1e460fa  ! 2566: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbde5e150  ! 2567: SAVE_I	save	%r23, 0x0001, %r30
	.word 0x8195202c  ! 2572: WRPR_TPC_I	wrpr	%r20, 0x002c, %tpc
hwintr_0_116:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_116), 16, 16)) -> intp(0, 0, 2d)
	.word 0xbde5a0f3  ! 2576: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xbe05e025  ! 2577: ADD_I	add 	%r23, 0x0025, %r31
	.word 0xb5e46012  ! 2579: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xbde5e1f0  ! 2580: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb7508000  ! 2584: RDPR_TSTATE	<illegal instruction>
	.word 0xb3e4a0e4  ! 2589: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xb2b5611f  ! 2592: ORNcc_I	orncc 	%r21, 0x011f, %r25
hwintr_0_117:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_117), 16, 16)) -> intp(0, 0, 11)
	.word 0xb1e4e121  ! 2598: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbbe4a1b9  ! 2599: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xb5e42038  ! 2600: SAVE_I	save	%r16, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81982919  ! 2607: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0919, %hpstate
	.word 0xb750c000  ! 2608: RDPR_TT	<illegal instruction>
	.word 0xb1520000  ! 2610: RDPR_PIL	<illegal instruction>
hwintr_0_118:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_118), 16, 16)) -> intp(0, 0, 25)
hwintr_0_119:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_119), 16, 16)) -> intp(0, 0, 1f)
	.word 0xb02cc000  ! 2619: ANDN_R	andn 	%r19, %r0, %r24
hwintr_0_120:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_120), 16, 16)) -> intp(0, 0, 3a)
	.word 0xb2058000  ! 2623: ADD_R	add 	%r22, %r0, %r25
	.word 0xb9e5a139  ! 2628: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xb1e460f7  ! 2629: SAVE_I	save	%r17, 0x0001, %r24
hwintr_0_121:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_121), 16, 16)) -> intp(0, 0, 33)
	.word 0xbbe5a1ae  ! 2631: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb1540000  ! 2633: RDPR_GL	<illegal instruction>
	.word 0xb7e5a121  ! 2634: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb29de003  ! 2635: XORcc_I	xorcc 	%r23, 0x0003, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81983fd9  ! 2640: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1fd9, %hpstate
hwintr_0_122:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_122), 16, 16)) -> intp(0, 0, 31)
	.word 0xb7480000  ! 2648: RDHPR_HPSTATE	rdhpr	%hpstate, %r27
hwintr_0_123:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_123), 16, 16)) -> intp(0, 0, 20)
	.word 0xb3e4209f  ! 2652: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xbb500000  ! 2653: RDPR_TPC	<illegal instruction>
hwintr_0_124:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_124), 16, 16)) -> intp(0, 0, 2b)
	.word 0xb3e561d7  ! 2658: SAVE_I	save	%r21, 0x0001, %r25
hwintr_0_125:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_125), 16, 16)) -> intp(0, 0, 36)
	.word 0xb8c48000  ! 2662: ADDCcc_R	addccc 	%r18, %r0, %r28
	.word 0xb1e4a14f  ! 2663: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xbd480000  ! 2665: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xb3e5e093  ! 2668: SAVE_I	save	%r23, 0x0001, %r25
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xbe144000  ! 2670: OR_R	or 	%r17, %r0, %r31
	.word 0xb9352001  ! 2671: SRL_I	srl 	%r20, 0x0001, %r28
	.word 0xb7e4e009  ! 2676: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb3e52194  ! 2679: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xbfe5a158  ! 2683: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb1e461ef  ! 2685: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb7e46019  ! 2687: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xb9520000  ! 2689: RDPR_PIL	<illegal instruction>
	.word 0xba2d0000  ! 2690: ANDN_R	andn 	%r20, %r0, %r29
	.word 0xb3e42180  ! 2692: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xb3e5e148  ! 2694: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbbe46027  ! 2696: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xbde5e0d8  ! 2704: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xbf3dc000  ! 2705: SRA_R	sra 	%r23, %r0, %r31
	.word 0xb17de401  ! 2709: MOVR_I	movre	%r23, 0x1, %r24
	.word 0xb9e56182  ! 2710: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xb3480000  ! 2716: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xbfe5e02e  ! 2717: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xba2ca1c1  ! 2720: ANDN_I	andn 	%r18, 0x01c1, %r29
	.word 0xbde5a04d  ! 2728: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xbbe4200b  ! 2733: SAVE_I	save	%r16, 0x0001, %r29
	.word 0x83946117  ! 2735: WRPR_TNPC_I	wrpr	%r17, 0x0117, %tnpc
	.word 0xbde5e178  ! 2736: SAVE_I	save	%r23, 0x0001, %r30
	.word 0x8d94e133  ! 2737: WRPR_PSTATE_I	wrpr	%r19, 0x0133, %pstate
	.word 0xb53d5000  ! 2739: SRAX_R	srax	%r21, %r0, %r26
	.word 0xbbe5e09d  ! 2744: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb1e4e18e  ! 2745: SAVE_I	save	%r19, 0x0001, %r24
hwintr_0_126:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_126), 16, 16)) -> intp(0, 0, 21)
	.word 0xb7e5e046  ! 2747: SAVE_I	save	%r23, 0x0001, %r27
	.word 0x8795a186  ! 2749: WRPR_TT_I	wrpr	%r22, 0x0186, %tt
	.word 0xb3e5a09d  ! 2751: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb3e4601b  ! 2755: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb9e5e132  ! 2757: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xb4c4e0f0  ! 2758: ADDCcc_I	addccc 	%r19, 0x00f0, %r26
	.word 0xb1e520a7  ! 2760: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xbde4e00f  ! 2762: SAVE_I	save	%r19, 0x0001, %r30
	.word 0x839420f8  ! 2764: WRPR_TNPC_I	wrpr	%r16, 0x00f8, %tnpc
hwintr_0_127:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_127), 16, 16)) -> intp(0, 0, 2)
hwintr_0_128:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_128), 16, 16)) -> intp(0, 0, 14)
	.word 0xbde561e0  ! 2771: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xbaa54000  ! 2772: SUBcc_R	subcc 	%r21, %r0, %r29
	.word 0xbfe46071  ! 2773: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xb1e4a02f  ! 2774: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xb9e5a1fe  ! 2778: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xbfe4a1f6  ! 2784: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb7e52017  ! 2788: SAVE_I	save	%r20, 0x0001, %r27
	.word 0x87942141  ! 2789: WRPR_TT_I	wrpr	%r16, 0x0141, %tt
	.word 0xb1480000  ! 2792: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
hwintr_0_129:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_129), 16, 16)) -> intp(0, 0, 14)
	.word 0xb7e4e086  ! 2796: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb1e420e5  ! 2799: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xb0358000  ! 2805: ORN_R	orn 	%r22, %r0, %r24
hwintr_0_130:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_130), 16, 16)) -> intp(0, 0, 10)
	.word 0xb7e4a134  ! 2812: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xb5e460de  ! 2814: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xbf510000  ! 2817: RDPR_TICK	<illegal instruction>
	.word 0x879421ab  ! 2822: WRPR_TT_I	wrpr	%r16, 0x01ab, %tt
hwintr_0_131:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_131), 16, 16)) -> intp(0, 0, 2)
	.word 0x8794a1dc  ! 2829: WRPR_TT_I	wrpr	%r18, 0x01dc, %tt
	.word 0xbfe4a109  ! 2832: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbfe5a118  ! 2835: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xbde4a189  ! 2836: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb4a4e1c2  ! 2838: SUBcc_I	subcc 	%r19, 0x01c2, %r26
	.word 0xb1e4e0ad  ! 2839: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbde4a169  ! 2840: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb7e420a8  ! 2842: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb5520000  ! 2844: RDPR_PIL	rdpr	%pil, %r26
	.word 0xb1340000  ! 2851: SRL_R	srl 	%r16, %r0, %r24
	.word 0xb7e5e021  ! 2852: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xbe9de074  ! 2854: XORcc_I	xorcc 	%r23, 0x0074, %r31
	.word 0xbfe42068  ! 2857: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xb5e5e12c  ! 2858: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xb1e4609f  ! 2859: SAVE_I	save	%r17, 0x0001, %r24
	.word 0x8d94e173  ! 2860: WRPR_PSTATE_I	wrpr	%r19, 0x0173, %pstate
	.word 0xb3e4609d  ! 2865: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb5e46175  ! 2866: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xbcc5a1d8  ! 2867: ADDCcc_I	addccc 	%r22, 0x01d8, %r30
	.word 0xb9e5212d  ! 2868: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xbcc5e007  ! 2874: ADDCcc_I	addccc 	%r23, 0x0007, %r30
	.word 0xb08561dc  ! 2877: ADDcc_I	addcc 	%r21, 0x01dc, %r24
	.word 0xbde4e1ed  ! 2883: SAVE_I	save	%r19, 0x0001, %r30
hwintr_0_132:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_132), 16, 16)) -> intp(0, 0, 23)
	.word 0x8194a119  ! 2886: WRPR_TPC_I	wrpr	%r18, 0x0119, %tpc
hwintr_0_133:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_133), 16, 16)) -> intp(0, 0, 19)
	.word 0xb9500000  ! 2892: RDPR_TPC	<illegal instruction>
	.word 0x8d95e0f0  ! 2894: WRPR_PSTATE_I	wrpr	%r23, 0x00f0, %pstate
	.word 0xb3e4a00c  ! 2895: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xb68ce176  ! 2897: ANDcc_I	andcc 	%r19, 0x0176, %r27
	.word 0x8d95e155  ! 2898: WRPR_PSTATE_I	wrpr	%r23, 0x0155, %pstate
	.word 0xb1520000  ! 2899: RDPR_PIL	<illegal instruction>
	.word 0xbfe52171  ! 2903: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xb7e5e0ba  ! 2904: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xb9508000  ! 2907: RDPR_TSTATE	<illegal instruction>
	.word 0xb9e521fe  ! 2908: SAVE_I	save	%r20, 0x0001, %r28
hwintr_0_134:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_134), 16, 16)) -> intp(0, 0, 39)
	.word 0xb5e4613c  ! 2916: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb5e5a11a  ! 2923: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xb7e4e01e  ! 2924: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb5e5211d  ! 2931: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xbf510000  ! 2936: RDPR_TICK	<illegal instruction>
	.word 0xb7e4a049  ! 2937: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xb3e5205e  ! 2938: SAVE_I	save	%r20, 0x0001, %r25
	mov	2, %r14
	.word 0xa193a000  ! 2940: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	ta	T_CHANGE_HPRIV
	.word 0x81983881  ! 2941: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1881, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81982c51  ! 2942: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c51, %hpstate
	.word 0xb9e4e0c6  ! 2948: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb13cf001  ! 2951: SRAX_I	srax	%r19, 0x0001, %r24
	.word 0xbfe4a07e  ! 2953: SAVE_I	save	%r18, 0x0001, %r31
hwintr_0_135:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_135), 16, 16)) -> intp(0, 0, a)
	.word 0xb5e5a0a8  ! 2955: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xbb504000  ! 2956: RDPR_TNPC	<illegal instruction>
	.word 0xbfe5a11b  ! 2957: SAVE_I	save	%r22, 0x0001, %r31
hwintr_0_136:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_136), 16, 16)) -> intp(0, 0, f)
	.word 0xb1e4e167  ! 2967: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb9e4a0d6  ! 2968: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xbd504000  ! 2969: RDPR_TNPC	<illegal instruction>
	.word 0xb9e520cc  ! 2971: SAVE_I	save	%r20, 0x0001, %r28
hwintr_0_137:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_137), 16, 16)) -> intp(0, 0, 1b)
	.word 0xbfe52099  ! 2973: SAVE_I	save	%r20, 0x0001, %r31
	ta	T_CHANGE_HPRIV
	.word 0x81983bc9  ! 2978: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1bc9, %hpstate
	.word 0xb4246053  ! 2980: SUB_I	sub 	%r17, 0x0053, %r26
	.word 0xbfe421e6  ! 2985: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xb3e5e187  ! 2987: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbbe5613c  ! 2988: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xbf508000  ! 2989: RDPR_TSTATE	<illegal instruction>
	.word 0xbde5206b  ! 2990: SAVE_I	save	%r20, 0x0001, %r30
	.word 0x89956004  ! 2992: WRPR_TICK_I	wrpr	%r21, 0x0004, %tick
	.word 0xbb510000  ! 2993: RDPR_TICK	<illegal instruction>
	.word 0xb2bda09c  ! 2994: XNORcc_I	xnorcc 	%r22, 0x009c, %r25
	.word 0xbfe4e104  ! 2996: SAVE_I	save	%r19, 0x0001, %r31
	ta	T_CHANGE_HPRIV
	.word 0x81982b19  ! 3000: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b19, %hpstate
	.word 0xb83420f8  ! 3004: ORN_I	orn 	%r16, 0x00f8, %r28
hwintr_0_138:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_138), 16, 16)) -> intp(0, 0, 34)
	.word 0xb7520000  ! 3006: RDPR_PIL	<illegal instruction>
	.word 0xbec48000  ! 3009: ADDCcc_R	addccc 	%r18, %r0, %r31
	.word 0xbde4a175  ! 3015: SAVE_I	save	%r18, 0x0001, %r30
	.word 0x8195214f  ! 3016: WRPR_TPC_I	wrpr	%r20, 0x014f, %tpc
	.word 0x839520eb  ! 3017: WRPR_TNPC_I	wrpr	%r20, 0x00eb, %tnpc
	.word 0xb9e4a1eb  ! 3018: SAVE_I	save	%r18, 0x0001, %r28
	ta	T_CHANGE_HPRIV
T0_spu_op_6:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a07, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xb5500000  ! 3022: RDPR_TPC	<illegal instruction>
	.word 0xb9520000  ! 3023: RDPR_PIL	<illegal instruction>
	.word 0xb5e52190  ! 3027: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb3e52120  ! 3029: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xbde521f0  ! 3031: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xbfe4211a  ! 3040: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xbfe5e0ef  ! 3047: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xb5e4e16b  ! 3048: SAVE_I	save	%r19, 0x0001, %r26
	.word 0x819461de  ! 3052: WRPR_TPC_I	wrpr	%r17, 0x01de, %tpc
	.word 0xb1504000  ! 3054: RDPR_TNPC	<illegal instruction>
	.word 0xb3e4e03a  ! 3055: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb7508000  ! 3057: RDPR_TSTATE	<illegal instruction>
	.word 0xb7e5e03c  ! 3061: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xb7e4a0f0  ! 3062: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xb1e561b7  ! 3064: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xbde5e054  ! 3068: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb1e5a012  ! 3070: SAVE_I	save	%r22, 0x0001, %r24
	.word 0x89942018  ! 3071: WRPR_TICK_I	wrpr	%r16, 0x0018, %tick
	.word 0xb57c6401  ! 3074: MOVR_I	movre	%r17, 0x1, %r26
hwintr_0_139:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_139), 16, 16)) -> intp(0, 0, 14)
	.word 0x8d94a0f6  ! 3078: WRPR_PSTATE_I	wrpr	%r18, 0x00f6, %pstate
	.word 0xbfe4a1cd  ! 3081: SAVE_I	save	%r18, 0x0001, %r31
	mov	1, %r14
	.word 0xa193a000  ! 3083: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7e4a1b9  ! 3084: SAVE_I	save	%r18, 0x0001, %r27
	.word 0x8995a02c  ! 3091: WRPR_TICK_I	wrpr	%r22, 0x002c, %tick
	.word 0xbde5604a  ! 3092: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb951c000  ! 3097: RDPR_TL	<illegal instruction>
	.word 0xbde5a1b8  ! 3098: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xbde5e183  ! 3099: SAVE_I	save	%r23, 0x0001, %r30
hwintr_0_140:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_140), 16, 16)) -> intp(0, 0, 32)
	mov	0, %r12
	.word 0x8f932000  ! 3101: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbfe5619f  ! 3105: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xb62ce15f  ! 3106: ANDN_I	andn 	%r19, 0x015f, %r27
	.word 0xb3e5e016  ! 3109: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbbe560bd  ! 3110: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb1e56172  ! 3114: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb3e5a147  ! 3116: SAVE_I	save	%r22, 0x0001, %r25
hwintr_0_141:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_141), 16, 16)) -> intp(0, 0, 30)
	.word 0xbbe461c3  ! 3120: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xbd7c6401  ! 3121: MOVR_I	movre	%r17, 0x1, %r30
	.word 0xbfe46068  ! 3126: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xb7e5e014  ! 3128: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xb1e56119  ! 3130: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb3e561d7  ! 3134: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xbf518000  ! 3135: RDPR_PSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xb7e4e01a  ! 3139: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb9e4e044  ! 3141: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb5e5e1cb  ! 3144: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xbe84a1b0  ! 3145: ADDcc_I	addcc 	%r18, 0x01b0, %r31
	.word 0xb57d0400  ! 3146: MOVR_R	movre	%r20, %r0, %r26
	.word 0x81946017  ! 3152: WRPR_TPC_I	wrpr	%r17, 0x0017, %tpc
	.word 0xb9e5612d  ! 3153: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xb1e5e17c  ! 3154: SAVE_I	save	%r23, 0x0001, %r24
hwintr_0_142:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_142), 16, 16)) -> intp(0, 0, 7)
	.word 0xbde420ee  ! 3163: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xb61cc000  ! 3165: XOR_R	xor 	%r19, %r0, %r27
	.word 0xb1e52055  ! 3167: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb9e5a178  ! 3168: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xbf504000  ! 3170: RDPR_TNPC	<illegal instruction>
	.word 0x8d952072  ! 3171: WRPR_PSTATE_I	wrpr	%r20, 0x0072, %pstate
	.word 0xbfe5e195  ! 3175: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xbfe4e1b2  ! 3178: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb1e5e012  ! 3182: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb7e4a1b0  ! 3185: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xb9e5e17f  ! 3186: SAVE_I	save	%r23, 0x0001, %r28
hwintr_0_143:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_143), 16, 16)) -> intp(0, 0, 2e)
	.word 0x8d9461a7  ! 3191: WRPR_PSTATE_I	wrpr	%r17, 0x01a7, %pstate
	.word 0xb3e5e17b  ! 3192: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbde4e058  ! 3193: SAVE_I	save	%r19, 0x0001, %r30
	.word 0xb3510000  ! 3196: RDPR_TICK	<illegal instruction>
hwintr_0_144:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_144), 16, 16)) -> intp(0, 0, 4)
	.word 0xbf500000  ! 3200: RDPR_TPC	<illegal instruction>
	.word 0xb3e5a11a  ! 3206: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xbfe4e12d  ! 3210: SAVE_I	save	%r19, 0x0001, %r31
	.word 0x8794a05d  ! 3215: WRPR_TT_I	wrpr	%r18, 0x005d, %tt
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xb1e52167  ! 3220: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb5508000  ! 3222: RDPR_TSTATE	<illegal instruction>
hwintr_0_145:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_145), 16, 16)) -> intp(0, 0, 3b)
	.word 0xb9e561dd  ! 3232: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xbde4214e  ! 3236: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xb7e4a0dc  ! 3238: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xbb3da001  ! 3239: SRA_I	sra 	%r22, 0x0001, %r29
	.word 0x8795602e  ! 3241: WRPR_TT_I	wrpr	%r21, 0x002e, %tt
	.word 0xb5e4a138  ! 3244: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb49c61e0  ! 3245: XORcc_I	xorcc 	%r17, 0x01e0, %r26
	.word 0xb3e4e1ff  ! 3246: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb9540000  ! 3247: RDPR_GL	<illegal instruction>
	.word 0xb3e4e16c  ! 3248: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb3e4e105  ! 3249: SAVE_I	save	%r19, 0x0001, %r25
	.word 0x8195a115  ! 3250: WRPR_TPC_I	wrpr	%r22, 0x0115, %tpc
	.word 0xbd7dc400  ! 3254: MOVR_R	movre	%r23, %r0, %r30
	.word 0xb7e5a0cd  ! 3258: SAVE_I	save	%r22, 0x0001, %r27
	mov	2, %r14
	.word 0xa193a000  ! 3260: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbfe521a2  ! 3264: SAVE_I	save	%r20, 0x0001, %r31
	.word 0x899460f0  ! 3265: WRPR_TICK_I	wrpr	%r17, 0x00f0, %tick
	mov	2, %r14
	.word 0xa193a000  ! 3269: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb6ad0000  ! 3270: ANDNcc_R	andncc 	%r20, %r0, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982a01  ! 3271: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a01, %hpstate
	.word 0xb151c000  ! 3274: RDPR_TL	<illegal instruction>
hwintr_0_146:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_146), 16, 16)) -> intp(0, 0, 3d)
	.word 0x83956078  ! 3278: WRPR_TNPC_I	wrpr	%r21, 0x0078, %tnpc
	.word 0xb9e520c7  ! 3281: SAVE_I	save	%r20, 0x0001, %r28
hwintr_0_147:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_147), 16, 16)) -> intp(0, 0, 2c)
	.word 0xb1e4e0c9  ! 3283: SAVE_I	save	%r19, 0x0001, %r24
hwintr_0_148:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_148), 16, 16)) -> intp(0, 0, 37)
	.word 0xbbe460b1  ! 3288: SAVE_I	save	%r17, 0x0001, %r29
hwintr_0_149:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_149), 16, 16)) -> intp(0, 0, c)
	.word 0xbfe5a1e0  ! 3291: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb7e460f7  ! 3293: SAVE_I	save	%r17, 0x0001, %r27
hwintr_0_150:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_150), 16, 16)) -> intp(0, 0, a)
	.word 0xbfe4e01e  ! 3296: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbfe4e0e0  ! 3298: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbbe42133  ! 3300: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb1e5e126  ! 3301: SAVE_I	save	%r23, 0x0001, %r24
hwintr_0_151:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_151), 16, 16)) -> intp(0, 0, 34)
hwintr_0_152:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_152), 16, 16)) -> intp(0, 0, 3e)
	.word 0xbd3c0000  ! 3308: SRA_R	sra 	%r16, %r0, %r30
	.word 0xba3c2113  ! 3310: XNOR_I	xnor 	%r16, 0x0113, %r29
	mov	0, %r12
	.word 0x8f932000  ! 3313: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbf520000  ! 3314: RDPR_PIL	<illegal instruction>
	.word 0xb3e4617a  ! 3317: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb1e5a114  ! 3319: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb3e46076  ! 3320: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xbf520000  ! 3321: RDPR_PIL	<illegal instruction>
	.word 0xb9e420a5  ! 3326: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xbbe560cb  ! 3327: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb12df001  ! 3332: SLLX_I	sllx	%r23, 0x0001, %r24
	.word 0xb5e461f5  ! 3336: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb3e4212e  ! 3338: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xbde52136  ! 3347: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xb434e0df  ! 3351: ORN_I	orn 	%r19, 0x00df, %r26
	.word 0xb3e4604b  ! 3352: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb9e5a025  ! 3354: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xb1e5e173  ! 3357: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xbfe46121  ! 3361: SAVE_I	save	%r17, 0x0001, %r31
	ta	T_CHANGE_HPRIV
	.word 0x81983a41  ! 3366: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a41, %hpstate
	.word 0xbf518000  ! 3371: RDPR_PSTATE	<illegal instruction>
	.word 0xbde5a0d4  ! 3372: SAVE_I	save	%r22, 0x0001, %r30
hwintr_0_153:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_153), 16, 16)) -> intp(0, 0, 30)
	.word 0xbfe561b2  ! 3378: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xb5e56122  ! 3380: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb7e5a01a  ! 3381: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb151c000  ! 3383: RDPR_TL	<illegal instruction>
	.word 0xb5e4a02b  ! 3388: SAVE_I	save	%r18, 0x0001, %r26
hwintr_0_154:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_154), 16, 16)) -> intp(0, 0, 1e)
	.word 0xb3540000  ! 3393: RDPR_GL	<illegal instruction>
	.word 0xb9520000  ! 3394: RDPR_PIL	<illegal instruction>
	.word 0xbbe5614d  ! 3397: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb1e42169  ! 3401: SAVE_I	save	%r16, 0x0001, %r24
	.word 0x85942030  ! 3405: WRPR_TSTATE_I	wrpr	%r16, 0x0030, %tstate
	.word 0xbbe520fe  ! 3407: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xb5e4a0d1  ! 3416: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbbe5a11e  ! 3422: SAVE_I	save	%r22, 0x0001, %r29
	.word 0x81952142  ! 3423: WRPR_TPC_I	wrpr	%r20, 0x0142, %tpc
	mov	0, %r12
	.word 0x8f932000  ! 3426: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb7352001  ! 3428: SRL_I	srl 	%r20, 0x0001, %r27
	.word 0xb7540000  ! 3429: RDPR_GL	<illegal instruction>
	.word 0xb1e5a14e  ! 3432: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xbfe4214a  ! 3433: SAVE_I	save	%r16, 0x0001, %r31
hwintr_0_155:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_155), 16, 16)) -> intp(0, 0, 6)
hwintr_0_156:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_156), 16, 16)) -> intp(0, 0, 6)
	.word 0xbbe4a083  ! 3438: SAVE_I	save	%r18, 0x0001, %r29
	mov	0, %r14
	.word 0xa193a000  ! 3440: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7e560e8  ! 3443: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xb735e001  ! 3444: SRL_I	srl 	%r23, 0x0001, %r27
	.word 0xb72c3001  ! 3446: SLLX_I	sllx	%r16, 0x0001, %r27
hwintr_0_157:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_157), 16, 16)) -> intp(0, 0, 10)
	.word 0xbb2cd000  ! 3450: SLLX_R	sllx	%r19, %r0, %r29
	.word 0x81956091  ! 3451: WRPR_TPC_I	wrpr	%r21, 0x0091, %tpc
hwintr_0_158:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_158), 16, 16)) -> intp(0, 0, 14)
	.word 0xb9e521da  ! 3454: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xbfe5201c  ! 3455: SAVE_I	save	%r20, 0x0001, %r31
hwintr_0_159:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_159), 16, 16)) -> intp(0, 0, 31)
	.word 0xb7e5a1c0  ! 3459: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xbfe4200c  ! 3460: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xb1641800  ! 3461: MOVcc_R	<illegal instruction>
	.word 0xb1e5e0b5  ! 3465: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb751c000  ! 3466: RDPR_TL	<illegal instruction>
	.word 0xbfe52121  ! 3467: SAVE_I	save	%r20, 0x0001, %r31
hwintr_0_160:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_160), 16, 16)) -> intp(0, 0, 10)
	.word 0xbbe421a4  ! 3469: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb9e42166  ! 3470: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xbbe5e0e2  ! 3471: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb8446022  ! 3472: ADDC_I	addc 	%r17, 0x0022, %r28
	.word 0xbfe5601c  ! 3474: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xb1e56072  ! 3475: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xbfe4a1c9  ! 3479: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbbe4a041  ! 3482: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xbfe52183  ! 3486: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xbfe5a0a2  ! 3490: SAVE_I	save	%r22, 0x0001, %r31
hwintr_0_161:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_161), 16, 16)) -> intp(0, 0, 3c)
	.word 0xb9e4a1ed  ! 3495: SAVE_I	save	%r18, 0x0001, %r28
hwintr_0_162:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_162), 16, 16)) -> intp(0, 0, 1c)
	.word 0xb7e5a170  ! 3497: SAVE_I	save	%r22, 0x0001, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81983c0b  ! 3498: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c0b, %hpstate
	.word 0xb4a40000  ! 3500: SUBcc_R	subcc 	%r16, %r0, %r26
hwintr_0_163:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_163), 16, 16)) -> intp(0, 0, 15)
	.word 0xbfe4a104  ! 3507: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbb518000  ! 3509: RDPR_PSTATE	<illegal instruction>
	.word 0xb234610b  ! 3520: ORN_I	orn 	%r17, 0x010b, %r25
	.word 0xbbe5604e  ! 3521: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb7e5208e  ! 3523: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xb9e5e089  ! 3526: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbfe4a0e5  ! 3527: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbbe5200c  ! 3529: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xb9e521d8  ! 3533: SAVE_I	save	%r20, 0x0001, %r28
	ta	T_CHANGE_HPRIV
T0_spu_op_7:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0xa0d, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x8198395b  ! 3540: WRHPR_HPSTATE_I	wrhpr	%r0, 0x195b, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81982a11  ! 3545: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a11, %hpstate
	.word 0x8794a068  ! 3547: WRPR_TT_I	wrpr	%r18, 0x0068, %tt
	.word 0xb7e5a05c  ! 3548: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb4958000  ! 3550: ORcc_R	orcc 	%r22, %r0, %r26
	.word 0xbbe4e166  ! 3551: SAVE_I	save	%r19, 0x0001, %r29
hwintr_0_164:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_164), 16, 16)) -> intp(0, 0, 37)
	.word 0xb7e560ff  ! 3561: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xb9e4e1c9  ! 3565: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb3e5a111  ! 3566: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb1e5203c  ! 3573: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb7e42046  ! 3576: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xbde461fb  ! 3577: SAVE_I	save	%r17, 0x0001, %r30
	.word 0x919560f4  ! 3580: WRPR_PIL_I	wrpr	%r21, 0x00f4, %pil
	.word 0xb7e4218c  ! 3581: SAVE_I	save	%r16, 0x0001, %r27
hwintr_0_165:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_165), 16, 16)) -> intp(0, 0, 26)
	.word 0xbde521a9  ! 3590: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xbde4200e  ! 3591: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xb33d1000  ! 3593: SRAX_R	srax	%r20, %r0, %r25
	.word 0xb3504000  ! 3600: RDPR_TNPC	<illegal instruction>
	.word 0xb4842109  ! 3604: ADDcc_I	addcc 	%r16, 0x0109, %r26
	.word 0xb1e4e15c  ! 3606: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbfe5a194  ! 3607: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb3e421ed  ! 3612: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xbbe52162  ! 3614: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xb7520000  ! 3624: RDPR_PIL	<illegal instruction>
hwintr_0_166:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_166), 16, 16)) -> intp(0, 0, 20)
	.word 0xbde4a13f  ! 3633: SAVE_I	save	%r18, 0x0001, %r30
	ta	T_CHANGE_HPRIV
	.word 0x81982a4b  ! 3636: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a4b, %hpstate
	.word 0xb7e4e16f  ! 3643: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xbde46067  ! 3645: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xbcb44000  ! 3652: ORNcc_R	orncc 	%r17, %r0, %r30
	.word 0xbbe461ed  ! 3653: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xbd510000  ! 3657: RDPR_TICK	<illegal instruction>
	.word 0xbbe560dc  ! 3663: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb3355000  ! 3664: SRLX_R	srlx	%r21, %r0, %r25
	.word 0xb7e4209a  ! 3665: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb1e5600b  ! 3668: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xbde5a1d9  ! 3672: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xbde5e1fa  ! 3674: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb1e5e06d  ! 3679: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb7e421de  ! 3680: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xbebd8000  ! 3681: XNORcc_R	xnorcc 	%r22, %r0, %r31
hwintr_0_167:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_167), 16, 16)) -> intp(0, 0, 1c)
	.word 0xb03c0000  ! 3684: XNOR_R	xnor 	%r16, %r0, %r24
hwintr_0_168:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_168), 16, 16)) -> intp(0, 0, 21)
	.word 0xbfe4201d  ! 3687: SAVE_I	save	%r16, 0x0001, %r31
	.word 0x8595606e  ! 3691: WRPR_TSTATE_I	wrpr	%r21, 0x006e, %tstate
	.word 0xb97cc400  ! 3694: MOVR_R	movre	%r19, %r0, %r28
	mov	1, %r14
	.word 0xa193a000  ! 3695: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbfe421b3  ! 3697: SAVE_I	save	%r16, 0x0001, %r31
	.word 0x8194215f  ! 3698: WRPR_TPC_I	wrpr	%r16, 0x015f, %tpc
	.word 0xbd508000  ! 3704: RDPR_TSTATE	<illegal instruction>
	.word 0xb5e520eb  ! 3705: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xbde5a037  ! 3708: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xbb504000  ! 3710: RDPR_TNPC	<illegal instruction>
hwintr_0_169:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_169), 16, 16)) -> intp(0, 0, 7)
hwintr_0_170:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_170), 16, 16)) -> intp(0, 0, 2f)
	.word 0xb9e5a0da  ! 3716: SAVE_I	save	%r22, 0x0001, %r28
	.word 0x83952009  ! 3718: WRPR_TNPC_I	wrpr	%r20, 0x0009, %tnpc
hwintr_0_171:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_171), 16, 16)) -> intp(0, 0, 2f)
	.word 0xb5e4a1b6  ! 3728: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb5e420cc  ! 3729: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xb62c4000  ! 3734: ANDN_R	andn 	%r17, %r0, %r27
hwintr_0_172:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_172), 16, 16)) -> intp(0, 0, 33)
	.word 0x8995609b  ! 3740: WRPR_TICK_I	wrpr	%r21, 0x009b, %tick
	.word 0xb5480000  ! 3747: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xb3e5a1f5  ! 3749: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb40c8000  ! 3751: AND_R	and 	%r18, %r0, %r26
	.word 0x8594a07b  ! 3756: WRPR_TSTATE_I	wrpr	%r18, 0x007b, %tstate
	.word 0xbde5a01c  ! 3759: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xb7e5a034  ! 3764: SAVE_I	save	%r22, 0x0001, %r27
hwintr_0_173:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_173), 16, 16)) -> intp(0, 0, 6)
	.word 0x8d946196  ! 3771: WRPR_PSTATE_I	wrpr	%r17, 0x0196, %pstate
	.word 0xb5510000  ! 3772: RDPR_TICK	<illegal instruction>
	.word 0x899461d3  ! 3774: WRPR_TICK_I	wrpr	%r17, 0x01d3, %tick
hwintr_0_174:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_174), 16, 16)) -> intp(0, 0, 32)
	.word 0xb3e4205f  ! 3777: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xb7e420c6  ! 3782: SAVE_I	save	%r16, 0x0001, %r27
hwintr_0_175:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_175), 16, 16)) -> intp(0, 0, 8)
	ta	T_CHANGE_HPRIV
	.word 0x81982b51  ! 3787: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b51, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81982b8b  ! 3789: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b8b, %hpstate
	.word 0xb7e5206d  ! 3793: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xb00ca112  ! 3796: AND_I	and 	%r18, 0x0112, %r24
	.word 0xb9510000  ! 3797: RDPR_TICK	<illegal instruction>
	.word 0xb7e4a152  ! 3799: SAVE_I	save	%r18, 0x0001, %r27
hwintr_0_176:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_176), 16, 16)) -> intp(0, 0, 16)
	.word 0xbde5e009  ! 3801: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xbb3c0000  ! 3802: SRA_R	sra 	%r16, %r0, %r29
	.word 0xb7e4e0a3  ! 3806: SAVE_I	save	%r19, 0x0001, %r27
	.word 0x8d95e0cf  ! 3809: WRPR_PSTATE_I	wrpr	%r23, 0x00cf, %pstate
	.word 0xb3e52144  ! 3811: SAVE_I	save	%r20, 0x0001, %r25
	ta	T_CHANGE_HPRIV
T0_spu_op_8:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0xa43, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xb1500000  ! 3815: RDPR_TPC	<illegal instruction>
hwintr_0_177:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_177), 16, 16)) -> intp(0, 0, 12)
	mov	0, %r12
	.word 0x8f932000  ! 3821: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb1e4e05f  ! 3824: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbfe46182  ! 3825: SAVE_I	save	%r17, 0x0001, %r31
hwintr_0_178:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_178), 16, 16)) -> intp(0, 0, 1b)
	.word 0xbb518000  ! 3830: RDPR_PSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982d93  ! 3831: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d93, %hpstate
hwintr_0_179:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_179), 16, 16)) -> intp(0, 0, 1)
	.word 0xb5e521d2  ! 3835: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xbfe56038  ! 3836: SAVE_I	save	%r21, 0x0001, %r31
hwintr_0_180:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_180), 16, 16)) -> intp(0, 0, 34)
	.word 0xb48c2178  ! 3840: ANDcc_I	andcc 	%r16, 0x0178, %r26
hwintr_0_181:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_181), 16, 16)) -> intp(0, 0, 1)
hwintr_0_182:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_182), 16, 16)) -> intp(0, 0, 26)
	.word 0xbaa4c000  ! 3849: SUBcc_R	subcc 	%r19, %r0, %r29
	.word 0xb3e5e0ac  ! 3855: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb9e4a16d  ! 3856: SAVE_I	save	%r18, 0x0001, %r28
	.word 0x899561e1  ! 3858: WRPR_TICK_I	wrpr	%r21, 0x01e1, %tick
	ta	T_CHANGE_HPRIV
	.word 0x81982d53  ! 3865: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d53, %hpstate
	.word 0xb9e5209b  ! 3867: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb8b58000  ! 3868: ORNcc_R	orncc 	%r22, %r0, %r28
	.word 0xbd50c000  ! 3872: RDPR_TT	<illegal instruction>
	.word 0xb9e42038  ! 3875: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xb5e4a187  ! 3876: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbf510000  ! 3877: RDPR_TICK	<illegal instruction>
	.word 0xb9518000  ! 3880: RDPR_PSTATE	<illegal instruction>
	.word 0x9194a03f  ! 3881: WRPR_PIL_I	wrpr	%r18, 0x003f, %pil
	.word 0xb1e46054  ! 3890: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb7e56129  ! 3895: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xb7e5e111  ! 3896: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xbc8c20e5  ! 3897: ANDcc_I	andcc 	%r16, 0x00e5, %r30
	.word 0xb5e561b2  ! 3902: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xbd520000  ! 3905: RDPR_PIL	<illegal instruction>
	.word 0xb9e4e0b7  ! 3906: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xbfe521f4  ! 3908: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xb0c4e156  ! 3910: ADDCcc_I	addccc 	%r19, 0x0156, %r24
	.word 0xbf3dd000  ! 3911: SRAX_R	srax	%r23, %r0, %r31
	.word 0x81946098  ! 3913: WRPR_TPC_I	wrpr	%r17, 0x0098, %tpc
	.word 0x9194e005  ! 3914: WRPR_PIL_I	wrpr	%r19, 0x0005, %pil
	.word 0xb1504000  ! 3915: RDPR_TNPC	<illegal instruction>
	.word 0xbbe52078  ! 3917: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xbbe5217d  ! 3918: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xbb504000  ! 3924: RDPR_TNPC	<illegal instruction>
	.word 0xb7e4a1d8  ! 3929: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xb3e5a0fe  ! 3932: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb0a521e0  ! 3935: SUBcc_I	subcc 	%r20, 0x01e0, %r24
	.word 0xb7500000  ! 3937: RDPR_TPC	<illegal instruction>
	mov	1, %r14
	.word 0xa193a000  ! 3941: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_0_183:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_183), 16, 16)) -> intp(0, 0, 3e)
	.word 0xb7e521a6  ! 3948: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xbe2c0000  ! 3949: ANDN_R	andn 	%r16, %r0, %r31
	.word 0xb9e420ba  ! 3951: SAVE_I	save	%r16, 0x0001, %r28
	.word 0x9195a15b  ! 3953: WRPR_PIL_I	wrpr	%r22, 0x015b, %pil
	.word 0xb3e421ab  ! 3957: SAVE_I	save	%r16, 0x0001, %r25
	mov	1, %r14
	.word 0xa193a000  ! 3959: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_0_184:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_184), 16, 16)) -> intp(0, 0, e)
	.word 0xbd510000  ! 3965: RDPR_TICK	<illegal instruction>
	.word 0xb1e521e5  ! 3967: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xbfe4a04e  ! 3968: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbbe42062  ! 3971: SAVE_I	save	%r16, 0x0001, %r29
hwintr_0_185:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_185), 16, 16)) -> intp(0, 0, d)
	.word 0xbde42011  ! 3978: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xbf508000  ! 3979: RDPR_TSTATE	<illegal instruction>
	.word 0xbde521ee  ! 3980: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xb3e560b2  ! 3985: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xbf504000  ! 3986: RDPR_TNPC	<illegal instruction>
	.word 0x8395a1f4  ! 3990: WRPR_TNPC_I	wrpr	%r22, 0x01f4, %tnpc
	.word 0xb7e46182  ! 3991: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xb1e56098  ! 3992: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb3e4a13d  ! 3993: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xb7e4602f  ! 3994: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xbde4e0e7  ! 3997: SAVE_I	save	%r19, 0x0001, %r30
hwintr_0_186:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_186), 16, 16)) -> intp(0, 0, 39)
	.word 0xb1e4601d  ! 4000: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb00c0000  ! 4003: AND_R	and 	%r16, %r0, %r24
	.word 0xb42de06f  ! 4005: ANDN_I	andn 	%r23, 0x006f, %r26
	.word 0xb1500000  ! 4006: RDPR_TPC	<illegal instruction>
	.word 0xb5518000  ! 4008: RDPR_PSTATE	<illegal instruction>
	.word 0xbfe52163  ! 4013: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xb9e4e0d5  ! 4014: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xbf540000  ! 4015: RDPR_GL	<illegal instruction>
	.word 0xb0356113  ! 4017: SUBC_I	orn 	%r21, 0x0113, %r24
	.word 0xbebc0000  ! 4020: XNORcc_R	xnorcc 	%r16, %r0, %r31
	.word 0xbfe4a104  ! 4021: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb3e521fc  ! 4022: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb12dc000  ! 4024: SLL_R	sll 	%r23, %r0, %r24
	.word 0xbfe5615e  ! 4030: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xbde460bb  ! 4032: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb5e4a126  ! 4036: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbfe4a0dd  ! 4039: SAVE_I	save	%r18, 0x0001, %r31
	ta	T_CHANGE_HPRIV
	.word 0x81983803  ! 4045: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1803, %hpstate
	.word 0xb7e4a085  ! 4047: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xbe940000  ! 4048: ORcc_R	orcc 	%r16, %r0, %r31
	.word 0xb7e42069  ! 4051: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb5e5a0c0  ! 4052: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xb9e560fe  ! 4053: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xbab50000  ! 4058: SUBCcc_R	orncc 	%r20, %r0, %r29
hwintr_0_187:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_187), 16, 16)) -> intp(0, 0, 3a)
	.word 0xb150c000  ! 4063: RDPR_TT	<illegal instruction>
	.word 0x89942028  ! 4065: WRPR_TICK_I	wrpr	%r16, 0x0028, %tick
	mov	0, %r14
	.word 0xa193a000  ! 4069: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbb51c000  ! 4070: RDPR_TL	<illegal instruction>
	.word 0xb7e5a007  ! 4071: SAVE_I	save	%r22, 0x0001, %r27
hwintr_0_188:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_188), 16, 16)) -> intp(0, 0, 2)
	.word 0xbfe42106  ! 4084: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xb3e5a1c6  ! 4086: SAVE_I	save	%r22, 0x0001, %r25
hwintr_0_189:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_189), 16, 16)) -> intp(0, 0, e)
	.word 0xbde56003  ! 4088: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xbde560ce  ! 4089: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb6b50000  ! 4092: ORNcc_R	orncc 	%r20, %r0, %r27
	.word 0xbde5e037  ! 4093: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb5e4e098  ! 4095: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xb1e52019  ! 4097: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xbde5e1c8  ! 4098: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb9e5a004  ! 4100: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xb8344000  ! 4102: ORN_R	orn 	%r17, %r0, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81983ac1  ! 4104: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1ac1, %hpstate
	.word 0xb5e4617f  ! 4105: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb7e4e1b2  ! 4106: SAVE_I	save	%r19, 0x0001, %r27
	ta	T_CHANGE_HPRIV
T0_spu_op_9:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a01, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbbe56017  ! 4108: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xbde5a151  ! 4112: SAVE_I	save	%r22, 0x0001, %r30
hwintr_0_190:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_190), 16, 16)) -> intp(0, 0, 6)
	.word 0x8d95a0d1  ! 4117: WRPR_PSTATE_I	wrpr	%r22, 0x00d1, %pstate
	.word 0xb5e4a161  ! 4120: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbf3d4000  ! 4121: SRA_R	sra 	%r21, %r0, %r31
hwintr_0_191:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_191), 16, 16)) -> intp(0, 0, 38)
	.word 0xb5e4612b  ! 4123: SAVE_I	save	%r17, 0x0001, %r26
hwintr_0_192:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_192), 16, 16)) -> intp(0, 0, 3c)
	.word 0x85942178  ! 4129: WRPR_TSTATE_I	wrpr	%r16, 0x0178, %tstate
	.word 0xb014c000  ! 4135: OR_R	or 	%r19, %r0, %r24
	.word 0xb1e5e1ea  ! 4136: SAVE_I	save	%r23, 0x0001, %r24
hwintr_0_193:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_193), 16, 16)) -> intp(0, 0, 30)
	.word 0xb5e4209b  ! 4139: SAVE_I	save	%r16, 0x0001, %r26
hwintr_0_194:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_194), 16, 16)) -> intp(0, 0, 1e)
	.word 0xb9520000  ! 4144: RDPR_PIL	<illegal instruction>
	.word 0xbc344000  ! 4147: SUBC_R	orn 	%r17, %r0, %r30
	.word 0xb9520000  ! 4149: RDPR_PIL	<illegal instruction>
hwintr_0_195:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_195), 16, 16)) -> intp(0, 0, 12)
	.word 0xb9e5a0c4  ! 4155: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xb1e5e10e  ! 4156: SAVE_I	save	%r23, 0x0001, %r24
	.word 0x859520f7  ! 4159: WRPR_TSTATE_I	wrpr	%r20, 0x00f7, %tstate
	.word 0xb5e5a17d  ! 4161: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xbd510000  ! 4165: RDPR_TICK	<illegal instruction>
	.word 0xb3e52195  ! 4170: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xbde4a17e  ! 4173: SAVE_I	save	%r18, 0x0001, %r30
	.word 0x85946186  ! 4174: WRPR_TSTATE_I	wrpr	%r17, 0x0186, %tstate
	.word 0xb5e5618c  ! 4175: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb9e52187  ! 4177: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb8b54000  ! 4179: SUBCcc_R	orncc 	%r21, %r0, %r28
hwintr_0_196:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_196), 16, 16)) -> intp(0, 0, e)
hwintr_0_197:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_197), 16, 16)) -> intp(0, 0, e)
hwintr_0_198:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_198), 16, 16)) -> intp(0, 0, 20)
hwintr_0_199:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_199), 16, 16)) -> intp(0, 0, c)
	.word 0x919560fc  ! 4192: WRPR_PIL_I	wrpr	%r21, 0x00fc, %pil
	.word 0xb3518000  ! 4199: RDPR_PSTATE	<illegal instruction>
	.word 0xbbe4612f  ! 4201: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xbf510000  ! 4202: RDPR_TICK	<illegal instruction>
hwintr_0_200:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_200), 16, 16)) -> intp(0, 0, 21)
	.word 0xbf342001  ! 4205: SRL_I	srl 	%r16, 0x0001, %r31
	.word 0xbbe46000  ! 4208: SAVE_I	save	%r17, 0x0001, %r29
hwintr_0_201:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_201), 16, 16)) -> intp(0, 0, 14)
	.word 0xb5e5e116  ! 4213: SAVE_I	save	%r23, 0x0001, %r26
hwintr_0_202:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_202), 16, 16)) -> intp(0, 0, 3)
	.word 0xbbe4a0ce  ! 4217: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xbfe5a179  ! 4221: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xbf480000  ! 4224: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xb1e5e0f2  ! 4225: SAVE_I	save	%r23, 0x0001, %r24
	.word 0x91956194  ! 4227: WRPR_PIL_I	wrpr	%r21, 0x0194, %pil
	.word 0xbfe5a0ea  ! 4230: SAVE_I	save	%r22, 0x0001, %r31
hwintr_0_203:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_203), 16, 16)) -> intp(0, 0, 33)
	mov	0, %r12
	.word 0x8f932000  ! 4233: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbbe4618b  ! 4234: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xb7e5a034  ! 4237: SAVE_I	save	%r22, 0x0001, %r27
	.word 0x8795a069  ! 4238: WRPR_TT_I	wrpr	%r22, 0x0069, %tt
	.word 0xbfe4603c  ! 4240: SAVE_I	save	%r17, 0x0001, %r31
hwintr_0_204:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_204), 16, 16)) -> intp(0, 0, 2c)
	.word 0x81942105  ! 4256: WRPR_TPC_I	wrpr	%r16, 0x0105, %tpc
	.word 0xb9e46163  ! 4259: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xbf520000  ! 4260: RDPR_PIL	<illegal instruction>
	.word 0xb5e5e084  ! 4262: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xb5e52170  ! 4263: SAVE_I	save	%r20, 0x0001, %r26
hwintr_0_205:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_205), 16, 16)) -> intp(0, 0, 7)
	.word 0xbb508000  ! 4269: RDPR_TSTATE	<illegal instruction>
	.word 0xbfe4a005  ! 4272: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbbe4e06f  ! 4274: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xbfe5a085  ! 4277: SAVE_I	save	%r22, 0x0001, %r31
hwintr_0_206:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_206), 16, 16)) -> intp(0, 0, 2a)
	.word 0xb97c8400  ! 4285: MOVR_R	movre	%r18, %r0, %r28
	.word 0xbde5612c  ! 4286: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xbde520e4  ! 4287: SAVE_I	save	%r20, 0x0001, %r30
	ta	T_CHANGE_HPRIV
T0_spu_op_10:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a4d, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xb5e461ab  ! 4292: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb1520000  ! 4296: RDPR_PIL	<illegal instruction>
	.word 0xb73d1000  ! 4297: SRAX_R	srax	%r20, %r0, %r27
	.word 0xb7480000  ! 4304: RDHPR_HPSTATE	rdhpr	%hpstate, %r27
	.word 0xb7e460ff  ! 4305: SAVE_I	save	%r17, 0x0001, %r27
	mov	0, %r14
	.word 0xa193a000  ! 4306: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x89942030  ! 4309: WRPR_TICK_I	wrpr	%r16, 0x0030, %tick
	mov	2, %r14
	.word 0xa193a000  ! 4310: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7e52158  ! 4312: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xbb51c000  ! 4316: RDPR_TL	<illegal instruction>
	mov	1, %r12
	.word 0x8f932000  ! 4318: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbbe4a19d  ! 4319: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xb1e5e037  ! 4324: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb3e520a9  ! 4325: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb5e5211f  ! 4329: SAVE_I	save	%r20, 0x0001, %r26
	.word 0x8d94a1b6  ! 4332: WRPR_PSTATE_I	wrpr	%r18, 0x01b6, %pstate
	.word 0xbde46142  ! 4335: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb1e5217a  ! 4339: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb634e099  ! 4342: SUBC_I	orn 	%r19, 0x0099, %r27
	mov	1, %r14
	.word 0xa193a000  ! 4347: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x87952153  ! 4351: WRPR_TT_I	wrpr	%r20, 0x0153, %tt
	.word 0xbfe5e11f  ! 4352: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xb5e4e031  ! 4354: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xb1e5a04a  ! 4355: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb5510000  ! 4356: RDPR_TICK	<illegal instruction>
	.word 0xbf508000  ! 4357: RDPR_TSTATE	<illegal instruction>
	.word 0xb3e4a161  ! 4358: SAVE_I	save	%r18, 0x0001, %r25
hwintr_0_207:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_207), 16, 16)) -> intp(0, 0, 6)
	.word 0xb1e5e1c4  ! 4361: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb5e56099  ! 4362: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb6ace0ae  ! 4364: ANDNcc_I	andncc 	%r19, 0x00ae, %r27
	.word 0x8194e097  ! 4365: WRPR_TPC_I	wrpr	%r19, 0x0097, %tpc
	.word 0xb1e4615f  ! 4367: SAVE_I	save	%r17, 0x0001, %r24
hwintr_0_208:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_208), 16, 16)) -> intp(0, 0, 1f)
	.word 0xb551c000  ! 4372: RDPR_TL	<illegal instruction>
	.word 0xbfe4e072  ! 4374: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb1e4a055  ! 4377: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xb23d6198  ! 4381: XNOR_I	xnor 	%r21, 0x0198, %r25
	.word 0xb7e4e136  ! 4382: SAVE_I	save	%r19, 0x0001, %r27
	mov	1, %r12
	.word 0x8f932000  ! 4383: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbea4a1b2  ! 4385: SUBcc_I	subcc 	%r18, 0x01b2, %r31
	.word 0xb1e5e020  ! 4399: SAVE_I	save	%r23, 0x0001, %r24
hwintr_0_209:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_209), 16, 16)) -> intp(0, 0, 18)
	.word 0xb7480000  ! 4406: RDHPR_HPSTATE	rdhpr	%hpstate, %r27
	.word 0xb9e520ea  ! 4407: SAVE_I	save	%r20, 0x0001, %r28
hwintr_0_210:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_210), 16, 16)) -> intp(0, 0, 23)
	.word 0xb7e5a0bc  ! 4410: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xbe2c8000  ! 4411: ANDN_R	andn 	%r18, %r0, %r31
	.word 0xb3e5a17b  ! 4417: SAVE_I	save	%r22, 0x0001, %r25
hwintr_0_211:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_211), 16, 16)) -> intp(0, 0, 28)
hwintr_0_212:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_212), 16, 16)) -> intp(0, 0, 20)
	.word 0xb2ac0000  ! 4423: ANDNcc_R	andncc 	%r16, %r0, %r25
	.word 0xb3e4a02b  ! 4425: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xbbe5e18a  ! 4426: SAVE_I	save	%r23, 0x0001, %r29
hwintr_0_213:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_213), 16, 16)) -> intp(0, 0, 3e)
	.word 0xb1e5e046  ! 4442: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb6158000  ! 4444: OR_R	or 	%r22, %r0, %r27
	.word 0xb9e5a03f  ! 4448: SAVE_I	save	%r22, 0x0001, %r28
	.word 0x8d94219b  ! 4451: WRPR_PSTATE_I	wrpr	%r16, 0x019b, %pstate
	.word 0xbc9d8000  ! 4453: XORcc_R	xorcc 	%r22, %r0, %r30
	.word 0xbfe4e003  ! 4455: SAVE_I	save	%r19, 0x0001, %r31
	.word 0x9195a1dd  ! 4456: WRPR_PIL_I	wrpr	%r22, 0x01dd, %pil
	.word 0xbfe4e0d9  ! 4463: SAVE_I	save	%r19, 0x0001, %r31
	ta	T_CHANGE_HPRIV
	.word 0x81982dd3  ! 4466: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dd3, %hpstate
hwintr_0_214:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_214), 16, 16)) -> intp(0, 0, 4)
	.word 0xb1e5a1d5  ! 4474: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xbb500000  ! 4476: RDPR_TPC	<illegal instruction>
hwintr_0_215:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_215), 16, 16)) -> intp(0, 0, 27)
	.word 0xbf508000  ! 4480: RDPR_TSTATE	<illegal instruction>
	.word 0xb9518000  ! 4482: RDPR_PSTATE	<illegal instruction>
	.word 0xbde4a0f9  ! 4484: SAVE_I	save	%r18, 0x0001, %r30
	ta	T_CHANGE_HPRIV
	.word 0x81982fd1  ! 4490: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0fd1, %hpstate
	.word 0x8595a150  ! 4491: WRPR_TSTATE_I	wrpr	%r22, 0x0150, %tstate
	.word 0xb3e4a093  ! 4493: SAVE_I	save	%r18, 0x0001, %r25
	.word 0x8794e1d2  ! 4494: WRPR_TT_I	wrpr	%r19, 0x01d2, %tt
	.word 0xb6458000  ! 4497: ADDC_R	addc 	%r22, %r0, %r27
	.word 0xb9e4e1fb  ! 4505: SAVE_I	save	%r19, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xb5e461e1  ! 4511: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb350c000  ! 4512: RDPR_TT	<illegal instruction>
hwintr_0_216:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_216), 16, 16)) -> intp(0, 0, 2d)
	.word 0xb1520000  ! 4516: RDPR_PIL	<illegal instruction>
	.word 0xbb480000  ! 4517: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	ta	T_CHANGE_HPRIV
T0_spu_op_11:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a43, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbd518000  ! 4523: RDPR_PSTATE	<illegal instruction>
hwintr_0_217:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_217), 16, 16)) -> intp(0, 0, c)
	.word 0xbf2c9000  ! 4526: SLLX_R	sllx	%r18, %r0, %r31
	ta	T_CHANGE_HPRIV
	.word 0x81982c89  ! 4527: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c89, %hpstate
	.word 0xb1e421dd  ! 4530: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xb1e56054  ! 4531: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb1e5e1f0  ! 4534: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb7e5e18e  ! 4536: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xbde52170  ! 4537: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xbbe5a149  ! 4538: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb9e5610d  ! 4539: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xbde42023  ! 4540: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xbde52050  ! 4542: SAVE_I	save	%r20, 0x0001, %r30
	.word 0x81952125  ! 4543: WRPR_TPC_I	wrpr	%r20, 0x0125, %tpc
	.word 0xb9e5e174  ! 4545: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbfe5a09b  ! 4546: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xbfe4604c  ! 4547: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xbb510000  ! 4549: RDPR_TICK	<illegal instruction>
	.word 0xb5e56152  ! 4552: SAVE_I	save	%r21, 0x0001, %r26
hwintr_0_218:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_218), 16, 16)) -> intp(0, 0, 3a)
	.word 0xbde4218c  ! 4555: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xbd510000  ! 4559: RDPR_TICK	<illegal instruction>
hwintr_0_219:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_219), 16, 16)) -> intp(0, 0, 11)
	.word 0xb5518000  ! 4561: RDPR_PSTATE	<illegal instruction>
	.word 0xbde4a113  ! 4564: SAVE_I	save	%r18, 0x0001, %r30
hwintr_0_220:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_220), 16, 16)) -> intp(0, 0, 22)
	.word 0x8595a182  ! 4567: WRPR_TSTATE_I	wrpr	%r22, 0x0182, %tstate
	.word 0xb5e4a073  ! 4570: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb9e5e025  ! 4571: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xb5e4a0c1  ! 4572: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb0b4a0c8  ! 4573: SUBCcc_I	orncc 	%r18, 0x00c8, %r24
	.word 0xb9e5e18d  ! 4577: SAVE_I	save	%r23, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982b13  ! 4580: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b13, %hpstate
	.word 0xbde52172  ! 4581: SAVE_I	save	%r20, 0x0001, %r30
	.word 0x8995a001  ! 4584: WRPR_TICK_I	wrpr	%r22, 0x0001, %tick
	.word 0xbfe4e093  ! 4587: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbbe461fb  ! 4588: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xb62460ba  ! 4589: SUB_I	sub 	%r17, 0x00ba, %r27
	.word 0xb7e5a070  ! 4591: SAVE_I	save	%r22, 0x0001, %r27
	.word 0x9194a091  ! 4599: WRPR_PIL_I	wrpr	%r18, 0x0091, %pil
	.word 0xbde5617c  ! 4600: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb7e420dc  ! 4601: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb5e460cb  ! 4605: SAVE_I	save	%r17, 0x0001, %r26
hwintr_0_221:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_221), 16, 16)) -> intp(0, 0, 17)
	.word 0x8d94212e  ! 4613: WRPR_PSTATE_I	wrpr	%r16, 0x012e, %pstate
	.word 0xb5e4215b  ! 4615: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xbbe5a1c2  ! 4619: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb5354000  ! 4620: SRL_R	srl 	%r21, %r0, %r26
	.word 0xb294a131  ! 4625: ORcc_I	orcc 	%r18, 0x0131, %r25
	.word 0xb351c000  ! 4626: RDPR_TL	<illegal instruction>
	.word 0xbca48000  ! 4628: SUBcc_R	subcc 	%r18, %r0, %r30
hwintr_0_222:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_222), 16, 16)) -> intp(0, 0, 7)
	ta	T_CHANGE_HPRIV
	.word 0x81982b09  ! 4636: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b09, %hpstate
	.word 0xb1e42191  ! 4637: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xb42cc000  ! 4638: ANDN_R	andn 	%r19, %r0, %r26
	.word 0xb9e4a1d5  ! 4644: SAVE_I	save	%r18, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982b53  ! 4645: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b53, %hpstate
hwintr_0_223:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_223), 16, 16)) -> intp(0, 0, 0)
	.word 0xbde561b3  ! 4651: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb00d8000  ! 4652: AND_R	and 	%r22, %r0, %r24
	mov	1, %r14
	.word 0xa193a000  ! 4653: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9643801  ! 4654: MOVcc_I	<illegal instruction>
	.word 0xb9e5216a  ! 4655: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb0342168  ! 4663: SUBC_I	orn 	%r16, 0x0168, %r24
	.word 0xb3e4608e  ! 4664: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb9e4a15c  ! 4665: SAVE_I	save	%r18, 0x0001, %r28
	mov	2, %r14
	.word 0xa193a000  ! 4669: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7e56035  ! 4670: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xb1e461a4  ! 4675: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb29c0000  ! 4681: XORcc_R	xorcc 	%r16, %r0, %r25
	.word 0xbfe4a0c8  ! 4683: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb7e520d9  ! 4685: SAVE_I	save	%r20, 0x0001, %r27
hwintr_0_224:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_224), 16, 16)) -> intp(0, 0, 37)
	.word 0xb9510000  ! 4692: RDPR_TICK	<illegal instruction>
	.word 0xb8a52173  ! 4693: SUBcc_I	subcc 	%r20, 0x0173, %r28
	.word 0xbde520da  ! 4695: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xb350c000  ! 4700: RDPR_TT	<illegal instruction>
	.word 0xb1504000  ! 4705: RDPR_TNPC	<illegal instruction>
	.word 0xb9e560a5  ! 4709: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xb7e5609a  ! 4711: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xb7e4206a  ! 4713: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xbfe4a0ba  ! 4715: SAVE_I	save	%r18, 0x0001, %r31
hwintr_0_225:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_225), 16, 16)) -> intp(0, 0, 2a)
	.word 0x899421a1  ! 4720: WRPR_TICK_I	wrpr	%r16, 0x01a1, %tick
	.word 0xbf520000  ! 4722: RDPR_PIL	<illegal instruction>
	.word 0xbd500000  ! 4724: RDPR_TPC	<illegal instruction>
	.word 0xba95219a  ! 4727: ORcc_I	orcc 	%r20, 0x019a, %r29
	.word 0xbfe420af  ! 4728: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xb0bd4000  ! 4731: XNORcc_R	xnorcc 	%r21, %r0, %r24
	.word 0xb13dd000  ! 4735: SRAX_R	srax	%r23, %r0, %r24
	.word 0xbbe56088  ! 4737: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb7e420e4  ! 4738: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb9e5e190  ! 4740: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xb9e46075  ! 4742: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xb48561b9  ! 4744: ADDcc_I	addcc 	%r21, 0x01b9, %r26
	.word 0x8d956133  ! 4745: WRPR_PSTATE_I	wrpr	%r21, 0x0133, %pstate
	.word 0xb9e4a1f7  ! 4747: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xbde56074  ! 4748: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xbfe42143  ! 4750: SAVE_I	save	%r16, 0x0001, %r31
	.word 0x9195a040  ! 4751: WRPR_PIL_I	wrpr	%r22, 0x0040, %pil
	.word 0xb7e4210f  ! 4752: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb9e4213a  ! 4753: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xb3e461fc  ! 4754: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb9540000  ! 4758: RDPR_GL	<illegal instruction>
	.word 0xbfe46130  ! 4759: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xb3e4e110  ! 4763: SAVE_I	save	%r19, 0x0001, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81982a03  ! 4764: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a03, %hpstate
	.word 0xbfe5e191  ! 4768: SAVE_I	save	%r23, 0x0001, %r31
	mov	2, %r12
	.word 0x8f932000  ! 4773: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb97ce401  ! 4775: MOVR_I	movre	%r19, 0x1, %r28
	.word 0xbd500000  ! 4779: RDPR_TPC	<illegal instruction>
	.word 0xbb520000  ! 4780: RDPR_PIL	<illegal instruction>
	.word 0xb835c000  ! 4781: ORN_R	orn 	%r23, %r0, %r28
	.word 0xbfe4e0c5  ! 4782: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb6c561f6  ! 4784: ADDCcc_I	addccc 	%r21, 0x01f6, %r27
	.word 0xb3e5e09f  ! 4789: SAVE_I	save	%r23, 0x0001, %r25
	.word 0x839520e2  ! 4790: WRPR_TNPC_I	wrpr	%r20, 0x00e2, %tnpc
	.word 0xb485a047  ! 4791: ADDcc_I	addcc 	%r22, 0x0047, %r26
	.word 0xbbe5e154  ! 4793: SAVE_I	save	%r23, 0x0001, %r29
hwintr_0_226:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_226), 16, 16)) -> intp(0, 0, 33)
	.word 0xbde4e1e3  ! 4797: SAVE_I	save	%r19, 0x0001, %r30
	.word 0xb1e4a1af  ! 4800: SAVE_I	save	%r18, 0x0001, %r24
hwintr_0_227:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_227), 16, 16)) -> intp(0, 0, 18)
	.word 0x89946030  ! 4803: WRPR_TICK_I	wrpr	%r17, 0x0030, %tick
	.word 0xb3518000  ! 4804: RDPR_PSTATE	<illegal instruction>
	.word 0xb9e42059  ! 4806: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xbbe461ac  ! 4808: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xb1e4e0d7  ! 4811: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb1e46181  ! 4814: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbe2d4000  ! 4823: ANDN_R	andn 	%r21, %r0, %r31
	.word 0xbfe4e111  ! 4825: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbfe561af  ! 4826: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xb3e5e050  ! 4830: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbf508000  ! 4831: RDPR_TSTATE	<illegal instruction>
	.word 0x87956034  ! 4833: WRPR_TT_I	wrpr	%r21, 0x0034, %tt
	.word 0xbbe4e1a0  ! 4837: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xb3e5e12f  ! 4838: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbfe4a1a9  ! 4839: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbb2d3001  ! 4841: SLLX_I	sllx	%r20, 0x0001, %r29
	.word 0xbc94e030  ! 4844: ORcc_I	orcc 	%r19, 0x0030, %r30
	.word 0xbbe52189  ! 4849: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xb5e5603d  ! 4850: SAVE_I	save	%r21, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81982951  ! 4851: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0951, %hpstate
	.word 0xb884e149  ! 4852: ADDcc_I	addcc 	%r19, 0x0149, %r28
	.word 0xb1e4e1cd  ! 4854: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb1e46038  ! 4855: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbfe5a19b  ! 4856: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb1e4e0f0  ! 4859: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb350c000  ! 4863: RDPR_TT	<illegal instruction>
	.word 0xbde5608a  ! 4865: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb1480000  ! 4867: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xbbe42129  ! 4868: SAVE_I	save	%r16, 0x0001, %r29
	.word 0x8995613b  ! 4874: WRPR_TICK_I	wrpr	%r21, 0x013b, %tick
hwintr_0_228:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_228), 16, 16)) -> intp(0, 0, 1e)
	ta	T_CHANGE_HPRIV
	.word 0x81983f11  ! 4879: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f11, %hpstate
	.word 0xb3e520ae  ! 4880: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb9e460a8  ! 4881: SAVE_I	save	%r17, 0x0001, %r28
hwintr_0_229:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_229), 16, 16)) -> intp(0, 0, b)
	.word 0xbde5a0cd  ! 4884: SAVE_I	save	%r22, 0x0001, %r30
	.word 0x83942072  ! 4887: WRPR_TNPC_I	wrpr	%r16, 0x0072, %tnpc
hwintr_0_230:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_230), 16, 16)) -> intp(0, 0, 10)
	.word 0xb81c206e  ! 4892: XOR_I	xor 	%r16, 0x006e, %r28
	.word 0xbde5e01f  ! 4902: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xbbe4e11a  ! 4903: SAVE_I	save	%r19, 0x0001, %r29
hwintr_0_231:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_231), 16, 16)) -> intp(0, 0, b)
hwintr_0_232:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_232), 16, 16)) -> intp(0, 0, 16)
	.word 0xbfe4e13b  ! 4912: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb5e5e156  ! 4914: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xb40c8000  ! 4915: AND_R	and 	%r18, %r0, %r26
	.word 0xb9e56191  ! 4916: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xbbe5e0d2  ! 4917: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb9e460a2  ! 4918: SAVE_I	save	%r17, 0x0001, %r28
hwintr_0_233:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_233), 16, 16)) -> intp(0, 0, 2)
	.word 0xbfe560db  ! 4920: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xbc8de0b6  ! 4923: ANDcc_I	andcc 	%r23, 0x00b6, %r30
	ta	T_CHANGE_HPRIV
T0_spu_op_12:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a01, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbfe42026  ! 4927: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xbbe420c5  ! 4929: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xbbe5a17c  ! 4936: SAVE_I	save	%r22, 0x0001, %r29
	mov	2, %r12
	.word 0x8f932000  ! 4937: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xbde4210b  ! 4939: SAVE_I	save	%r16, 0x0001, %r30
hwintr_0_234:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_234), 16, 16)) -> intp(0, 0, 9)
hwintr_0_235:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_235), 16, 16)) -> intp(0, 0, 2f)
	.word 0xb3e5e1db  ! 4943: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbfe52124  ! 4945: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xb7e5e1a4  ! 4950: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xb1e4e192  ! 4953: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbfe4e016  ! 4956: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbb540000  ! 4957: RDPR_GL	<illegal instruction>
	.word 0xbb7c6401  ! 4962: MOVR_I	movre	%r17, 0x1, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81982f11  ! 4969: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f11, %hpstate
	.word 0xb5e5e1a2  ! 4971: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xbde4e0be  ! 4976: SAVE_I	save	%r19, 0x0001, %r30
	.word 0x839421bb  ! 4983: WRPR_TNPC_I	wrpr	%r16, 0x01bb, %tnpc
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xb60c2195  ! 4990: AND_I	and 	%r16, 0x0195, %r27
	.word 0xb6bc6159  ! 4991: XNORcc_I	xnorcc 	%r17, 0x0159, %r27
	.word 0xbe35c000  ! 5001: ORN_R	orn 	%r23, %r0, %r31
	.word 0x8d9560da  ! 5002: WRPR_PSTATE_I	wrpr	%r21, 0x00da, %pstate
	.word 0xb7e5a0d3  ! 5003: SAVE_I	save	%r22, 0x0001, %r27
	mov	1, %r12
	.word 0x8f932000  ! 5007: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_0_236:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_236), 16, 16)) -> intp(0, 0, d)
	.word 0xb1e4e0c0  ! 5010: SAVE_I	save	%r19, 0x0001, %r24
	ta	T_CHANGE_HPRIV
	.word 0x819828c9  ! 5014: WRHPR_HPSTATE_I	wrhpr	%r0, 0x08c9, %hpstate
	.word 0xb80ca033  ! 5018: AND_I	and 	%r18, 0x0033, %r28
	.word 0xb7504000  ! 5020: RDPR_TNPC	<illegal instruction>
	.word 0xb9e560a6  ! 5027: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xbfe5e157  ! 5029: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xb1e4e1f4  ! 5030: SAVE_I	save	%r19, 0x0001, %r24
hwintr_0_237:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_237), 16, 16)) -> intp(0, 0, 17)
	.word 0xbde5e1b3  ! 5036: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xbbe4e1c9  ! 5039: SAVE_I	save	%r19, 0x0001, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81983843  ! 5042: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1843, %hpstate
	.word 0xb350c000  ! 5044: RDPR_TT	<illegal instruction>
	.word 0xb6b50000  ! 5049: SUBCcc_R	orncc 	%r20, %r0, %r27
	.word 0xb88c61b6  ! 5052: ANDcc_I	andcc 	%r17, 0x01b6, %r28
	.word 0xb3e5602f  ! 5054: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xbbe56145  ! 5060: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb9e5a126  ! 5061: SAVE_I	save	%r22, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982b19  ! 5062: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b19, %hpstate
	.word 0xbde4a12b  ! 5069: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xbde5a1b2  ! 5072: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xb6bd60fc  ! 5079: XNORcc_I	xnorcc 	%r21, 0x00fc, %r27
	.word 0xbde5a020  ! 5080: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xb9510000  ! 5081: RDPR_TICK	<illegal instruction>
hwintr_0_238:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_238), 16, 16)) -> intp(0, 0, 0)
	.word 0xb1e4e05c  ! 5086: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbf480000  ! 5087: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xbde521c4  ! 5092: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xb7518000  ! 5093: RDPR_PSTATE	<illegal instruction>
	.word 0xb8ac201b  ! 5094: ANDNcc_I	andncc 	%r16, 0x001b, %r28
	.word 0xb9e561ee  ! 5099: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xbbe52075  ! 5106: SAVE_I	save	%r20, 0x0001, %r29
	ta	T_CHANGE_HPRIV
T0_spu_op_13:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a05, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0x8d95208e  ! 5109: WRPR_PSTATE_I	wrpr	%r20, 0x008e, %pstate
	ta	T_CHANGE_HPRIV
T0_spu_op_14:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a0f, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbfe42041  ! 5114: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xbb2de001  ! 5115: SLL_I	sll 	%r23, 0x0001, %r29
	.word 0xb7e4a11f  ! 5122: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xb3e521e1  ! 5123: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb7e4e1dd  ! 5124: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xbca561b3  ! 5125: SUBcc_I	subcc 	%r21, 0x01b3, %r30
	.word 0xb5e5e065  ! 5126: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xbbe420c1  ! 5128: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xbbe5a153  ! 5131: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb3e52100  ! 5133: SAVE_I	save	%r20, 0x0001, %r25
hwintr_0_239:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_239), 16, 16)) -> intp(0, 0, 16)
	.word 0xbde520e3  ! 5139: SAVE_I	save	%r20, 0x0001, %r30
	ta	T_CHANGE_HPRIV
	.word 0x81983bc3  ! 5140: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1bc3, %hpstate
	.word 0xb9e5e05a  ! 5143: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xb9e5e151  ! 5146: SAVE_I	save	%r23, 0x0001, %r28
	.word 0x8994a086  ! 5149: WRPR_TICK_I	wrpr	%r18, 0x0086, %tick
	.word 0x9194a12c  ! 5151: WRPR_PIL_I	wrpr	%r18, 0x012c, %pil
hwintr_0_240:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_240), 16, 16)) -> intp(0, 0, 37)
	.word 0xb3500000  ! 5156: RDPR_TPC	<illegal instruction>
	mov	0, %r12
	.word 0x8f932000  ! 5163: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb3e52190  ! 5164: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb9e460e0  ! 5165: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xb8b4e182  ! 5166: ORNcc_I	orncc 	%r19, 0x0182, %r28
	.word 0xb7e4e099  ! 5167: SAVE_I	save	%r19, 0x0001, %r27
	.word 0x8d95e0da  ! 5171: WRPR_PSTATE_I	wrpr	%r23, 0x00da, %pstate
	.word 0xb1e5a054  ! 5173: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb8b4a009  ! 5174: ORNcc_I	orncc 	%r18, 0x0009, %r28
	.word 0xb5e4a180  ! 5175: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb3e4e157  ! 5181: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb5e56116  ! 5182: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xbbe5e059  ! 5186: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb7e52013  ! 5187: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xbfe5609e  ! 5188: SAVE_I	save	%r21, 0x0001, %r31
hwintr_0_241:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_241), 16, 16)) -> intp(0, 0, 2e)
	ta	T_CHANGE_HPRIV
	.word 0x81982a91  ! 5191: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a91, %hpstate
	.word 0xb9e52196  ! 5192: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb1508000  ! 5195: RDPR_TSTATE	<illegal instruction>
hwintr_0_242:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_242), 16, 16)) -> intp(0, 0, 1b)
	.word 0x8395a0e6  ! 5199: WRPR_TNPC_I	wrpr	%r22, 0x00e6, %tnpc
	.word 0xb1520000  ! 5200: RDPR_PIL	<illegal instruction>
	.word 0xb7e5a011  ! 5202: SAVE_I	save	%r22, 0x0001, %r27
	ta	T_CHANGE_HPRIV
	.word 0x8198291b  ! 5207: WRHPR_HPSTATE_I	wrhpr	%r0, 0x091b, %hpstate
	ta	T_CHANGE_HPRIV
T0_spu_op_15:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x209, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbbe5e094  ! 5212: SAVE_I	save	%r23, 0x0001, %r29
	mov	1, %r14
	.word 0xa193a000  ! 5215: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbde561ea  ! 5218: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb7e4e048  ! 5219: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb7e561f3  ! 5225: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xbf50c000  ! 5226: RDPR_TT	<illegal instruction>
	.word 0x87956014  ! 5228: WRPR_TT_I	wrpr	%r21, 0x0014, %tt
	.word 0xb3480000  ! 5231: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
hwintr_0_243:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_243), 16, 16)) -> intp(0, 0, 1e)
	.word 0xb3e4a165  ! 5241: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xbc1520bb  ! 5246: OR_I	or 	%r20, 0x00bb, %r30
	.word 0xbfe4610a  ! 5247: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xbde5e033  ! 5250: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xbfe421a1  ! 5255: SAVE_I	save	%r16, 0x0001, %r31
hwintr_0_244:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_244), 16, 16)) -> intp(0, 0, 11)
	.word 0x8d94218c  ! 5259: WRPR_PSTATE_I	wrpr	%r16, 0x018c, %pstate
	.word 0xbde561f6  ! 5262: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xbbe5a027  ! 5263: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb9e52050  ! 5264: SAVE_I	save	%r20, 0x0001, %r28
	.word 0x839560de  ! 5267: WRPR_TNPC_I	wrpr	%r21, 0x00de, %tnpc
hwintr_0_245:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_245), 16, 16)) -> intp(0, 0, 38)
	.word 0x8994a109  ! 5271: WRPR_TICK_I	wrpr	%r18, 0x0109, %tick
hwintr_0_246:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_246), 16, 16)) -> intp(0, 0, 3a)
	.word 0xbbe4e096  ! 5274: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xbfe4e084  ! 5277: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb1e5604a  ! 5279: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb9e5219e  ! 5281: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xbde420c6  ! 5282: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xbd480000  ! 5287: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
hwintr_0_247:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_247), 16, 16)) -> intp(0, 0, 1e)
	.word 0x83956030  ! 5292: WRPR_TNPC_I	wrpr	%r21, 0x0030, %tnpc
hwintr_0_248:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_248), 16, 16)) -> intp(0, 0, 2)
	.word 0x8395e0d5  ! 5294: WRPR_TNPC_I	wrpr	%r23, 0x00d5, %tnpc
	.word 0xb5e4e026  ! 5295: SAVE_I	save	%r19, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81983e51  ! 5297: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e51, %hpstate
	.word 0xb1e52055  ! 5303: SAVE_I	save	%r20, 0x0001, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81983fc1  ! 5310: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1fc1, %hpstate
	.word 0xbbe4608c  ! 5312: SAVE_I	save	%r17, 0x0001, %r29
	mov	1, %r12
	.word 0x8f932000  ! 5313: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_0_249:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_249), 16, 16)) -> intp(0, 0, 11)
hwintr_0_250:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_250), 16, 16)) -> intp(0, 0, 16)
	.word 0xb7e4e0a6  ! 5321: SAVE_I	save	%r19, 0x0001, %r27
hwintr_0_251:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_251), 16, 16)) -> intp(0, 0, 23)
	.word 0xb7e5e1b2  ! 5325: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xb1500000  ! 5330: RDPR_TPC	<illegal instruction>
	.word 0xbbe5a019  ! 5331: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xbf510000  ! 5335: RDPR_TICK	<illegal instruction>
	.word 0xb9e420f8  ! 5337: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xb5e4a14c  ! 5339: SAVE_I	save	%r18, 0x0001, %r26
	.word 0x91942159  ! 5340: WRPR_PIL_I	wrpr	%r16, 0x0159, %pil
	.word 0x8395e1fa  ! 5343: WRPR_TNPC_I	wrpr	%r23, 0x01fa, %tnpc
	.word 0xb9e4e06f  ! 5346: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xbb510000  ! 5352: RDPR_TICK	<illegal instruction>
	.word 0xb83d4000  ! 5353: XNOR_R	xnor 	%r21, %r0, %r28
	.word 0xbbe561a4  ! 5354: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xbe95e15a  ! 5355: ORcc_I	orcc 	%r23, 0x015a, %r31
	.word 0xb2348000  ! 5356: SUBC_R	orn 	%r18, %r0, %r25
	.word 0x839521cb  ! 5357: WRPR_TNPC_I	wrpr	%r20, 0x01cb, %tnpc
hwintr_0_252:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_252), 16, 16)) -> intp(0, 0, 36)
	.word 0xb750c000  ! 5369: RDPR_TT	<illegal instruction>
	.word 0xb4350000  ! 5373: ORN_R	orn 	%r20, %r0, %r26
	.word 0xb7e52038  ! 5374: SAVE_I	save	%r20, 0x0001, %r27
hwintr_0_253:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_253), 16, 16)) -> intp(0, 0, 28)
	.word 0xbde4a1c7  ! 5380: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb5e5a1ad  ! 5381: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xb3e4e1a9  ! 5388: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb1e5e0d4  ! 5394: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xbde56108  ! 5400: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb5e460bc  ! 5403: SAVE_I	save	%r17, 0x0001, %r26
hwintr_0_254:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_254), 16, 16)) -> intp(0, 0, 2b)
	.word 0xba2dc000  ! 5408: ANDN_R	andn 	%r23, %r0, %r29
	.word 0xbd480000  ! 5410: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xb7510000  ! 5414: RDPR_TICK	<illegal instruction>
	.word 0xb1e52100  ! 5416: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xbde52165  ! 5417: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xbbe5a1fe  ! 5421: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb9e5a042  ! 5422: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xbde5e1ec  ! 5426: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb9e5e13b  ! 5428: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbb510000  ! 5429: RDPR_TICK	<illegal instruction>
	.word 0xbf508000  ! 5434: RDPR_TSTATE	<illegal instruction>
	.word 0xb5e5e0d5  ! 5436: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xbf518000  ! 5437: RDPR_PSTATE	<illegal instruction>
	.word 0xbbe52158  ! 5438: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xbfe52103  ! 5439: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xb9e4e05a  ! 5440: SAVE_I	save	%r19, 0x0001, %r28
	.word 0x8995a0a1  ! 5441: WRPR_TICK_I	wrpr	%r22, 0x00a1, %tick
	.word 0xb7e5a0fd  ! 5444: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb1e4203e  ! 5445: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xb33d4000  ! 5446: SRA_R	sra 	%r21, %r0, %r25
	.word 0xb1e52172  ! 5447: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb1e46159  ! 5448: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbf520000  ! 5451: RDPR_PIL	<illegal instruction>
	.word 0xbde56042  ! 5454: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xbbe52073  ! 5455: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xbfe5a11d  ! 5461: SAVE_I	save	%r22, 0x0001, %r31
	ta	T_CHANGE_HPRIV
T0_spu_op_16:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a09, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbde4614c  ! 5465: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb3e5205e  ! 5470: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb3e5e14d  ! 5473: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb7e4a066  ! 5474: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xbe2ca031  ! 5478: ANDN_I	andn 	%r18, 0x0031, %r31
hwintr_0_255:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_255), 16, 16)) -> intp(0, 0, 0)
	.word 0xbd508000  ! 5483: RDPR_TSTATE	<illegal instruction>
	.word 0xb1e4a15e  ! 5489: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xb6846015  ! 5501: ADDcc_I	addcc 	%r17, 0x0015, %r27
	.word 0xb3e56107  ! 5502: SAVE_I	save	%r21, 0x0001, %r25
	.word 0x9195a1f2  ! 5503: WRPR_PIL_I	wrpr	%r22, 0x01f2, %pil
	.word 0xb02cc000  ! 5506: ANDN_R	andn 	%r19, %r0, %r24
	.word 0xbde520b7  ! 5508: SAVE_I	save	%r20, 0x0001, %r30
	ta	T_CHANGE_HPRIV
	.word 0x81983f09  ! 5510: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f09, %hpstate
	.word 0xbde561e2  ! 5516: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xbb500000  ! 5518: RDPR_TPC	<illegal instruction>
	.word 0xb5518000  ! 5522: RDPR_PSTATE	<illegal instruction>
	.word 0xb5e46184  ! 5524: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb7480000  ! 5525: RDHPR_HPSTATE	rdhpr	%hpstate, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982a9b  ! 5531: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a9b, %hpstate
	.word 0xbde4212c  ! 5534: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xbde52184  ! 5538: SAVE_I	save	%r20, 0x0001, %r30
	.word 0x8d946001  ! 5548: WRPR_PSTATE_I	wrpr	%r17, 0x0001, %pstate
	.word 0xb5e46147  ! 5549: SAVE_I	save	%r17, 0x0001, %r26
	.word 0x8d952193  ! 5551: WRPR_PSTATE_I	wrpr	%r20, 0x0193, %pstate
	.word 0xb1504000  ! 5555: RDPR_TNPC	<illegal instruction>
	ta	T_CHANGE_HPRIV
T0_spu_op_17:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0xa0b, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
hwintr_0_256:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_256), 16, 16)) -> intp(0, 0, 17)
	.word 0xb7e5a118  ! 5566: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xbde5e10d  ! 5567: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xbfe5e1a1  ! 5569: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xbde46108  ! 5571: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xbde5a0a3  ! 5572: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xb7508000  ! 5573: RDPR_TSTATE	<illegal instruction>
	.word 0xb9e461b8  ! 5576: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xbfe5612b  ! 5577: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xb1e5e1f6  ! 5578: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb81d607a  ! 5579: XOR_I	xor 	%r21, 0x007a, %r28
	.word 0xb935b001  ! 5580: SRLX_I	srlx	%r22, 0x0001, %r28
	mov	0, %r14
	.word 0xa193a000  ! 5585: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8d94e1e9  ! 5588: WRPR_PSTATE_I	wrpr	%r19, 0x01e9, %pstate
	.word 0xbbe460e6  ! 5595: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xb1e4e0f3  ! 5597: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb751c000  ! 5598: RDPR_TL	<illegal instruction>
	.word 0xb5e5a064  ! 5601: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xbfe421fb  ! 5602: SAVE_I	save	%r16, 0x0001, %r31
	mov	0, %r14
	.word 0xa193a000  ! 5607: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7e5e149  ! 5610: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xb3504000  ! 5613: RDPR_TNPC	<illegal instruction>
	.word 0xb5e5e1a9  ! 5623: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xbb2cc000  ! 5624: SLL_R	sll 	%r19, %r0, %r29
	.word 0xb3e4e093  ! 5625: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb72cb001  ! 5626: SLLX_I	sllx	%r18, 0x0001, %r27
	.word 0xbbe5a15b  ! 5628: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb72c5000  ! 5629: SLLX_R	sllx	%r17, %r0, %r27
	.word 0xb7540000  ! 5630: RDPR_GL	<illegal instruction>
	.word 0xbbe5a0c1  ! 5635: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb7e5e14c  ! 5636: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xb5504000  ! 5640: RDPR_TNPC	<illegal instruction>
	.word 0xbfe4a071  ! 5641: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbb518000  ! 5642: RDPR_PSTATE	<illegal instruction>
	.word 0xb1e4e146  ! 5643: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb9e4a136  ! 5646: SAVE_I	save	%r18, 0x0001, %r28
	.word 0x85952063  ! 5648: WRPR_TSTATE_I	wrpr	%r20, 0x0063, %tstate
	.word 0xbf480000  ! 5649: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xb37c8400  ! 5650: MOVR_R	movre	%r18, %r0, %r25
	mov	1, %r12
	.word 0x8f932000  ! 5651: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb3e5e05a  ! 5652: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb9e5e0ec  ! 5653: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xb094c000  ! 5658: ORcc_R	orcc 	%r19, %r0, %r24
	.word 0xb5e4e137  ! 5660: SAVE_I	save	%r19, 0x0001, %r26
	.word 0x91952190  ! 5667: WRPR_PIL_I	wrpr	%r20, 0x0190, %pil
	.word 0xbfe5602e  ! 5670: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xb03c0000  ! 5672: XNOR_R	xnor 	%r16, %r0, %r24
	.word 0xbfe4a0f9  ! 5674: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb1e5e161  ! 5675: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb7e521fe  ! 5678: SAVE_I	save	%r20, 0x0001, %r27
	.word 0x8195615d  ! 5679: WRPR_TPC_I	wrpr	%r21, 0x015d, %tpc
hwintr_0_257:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_257), 16, 16)) -> intp(0, 0, 32)
	.word 0xb7e4a135  ! 5684: SAVE_I	save	%r18, 0x0001, %r27
	ta	T_CHANGE_HPRIV
	.word 0x8198298b  ! 5688: WRHPR_HPSTATE_I	wrhpr	%r0, 0x098b, %hpstate
	.word 0xbbe5e08a  ! 5689: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb1540000  ! 5691: RDPR_GL	<illegal instruction>
	.word 0xb1e4a056  ! 5692: SAVE_I	save	%r18, 0x0001, %r24
hwintr_0_258:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_258), 16, 16)) -> intp(0, 0, 31)
	.word 0xb7e5203e  ! 5695: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xb4858000  ! 5696: ADDcc_R	addcc 	%r22, %r0, %r26
	.word 0xb7e560ae  ! 5699: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xb3e4205f  ! 5701: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xb9e520e0  ! 5702: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb550c000  ! 5707: RDPR_TT	<illegal instruction>
	.word 0xb3518000  ! 5708: RDPR_PSTATE	<illegal instruction>
	.word 0xb3e5e1dc  ! 5714: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbde42061  ! 5716: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xb3e4e00e  ! 5719: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb7e4a018  ! 5723: SAVE_I	save	%r18, 0x0001, %r27
hwintr_0_259:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_259), 16, 16)) -> intp(0, 0, 2d)
hwintr_0_260:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_260), 16, 16)) -> intp(0, 0, 1c)
	.word 0xbbe5602d  ! 5729: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xbfe520fa  ! 5730: SAVE_I	save	%r20, 0x0001, %r31
	mov	0, %r12
	.word 0x8f932000  ! 5732: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xb43d60d1  ! 5738: XNOR_I	xnor 	%r21, 0x00d1, %r26
	.word 0xbbe5a17e  ! 5741: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb3500000  ! 5742: RDPR_TPC	<illegal instruction>
hwintr_0_261:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_261), 16, 16)) -> intp(0, 0, 1a)
	.word 0xb3e5e08b  ! 5745: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbfe4a06e  ! 5747: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb1e5e0f5  ! 5750: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xbde4a0f2  ! 5751: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb7518000  ! 5752: RDPR_PSTATE	<illegal instruction>
	.word 0xbfe5e060  ! 5754: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xb3e4a11c  ! 5758: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xb7e5a0a8  ! 5759: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xbfe4e00e  ! 5764: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb9480000  ! 5767: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	mov	0, %r12
	.word 0x8f932000  ! 5769: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb9508000  ! 5771: RDPR_TSTATE	<illegal instruction>
	.word 0xb5e460e1  ! 5773: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb1e4e07f  ! 5775: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb5e5e0ea  ! 5778: SAVE_I	save	%r23, 0x0001, %r26
hwintr_0_262:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_262), 16, 16)) -> intp(0, 0, 35)
hwintr_0_263:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_263), 16, 16)) -> intp(0, 0, 14)
	.word 0x899561b6  ! 5783: WRPR_TICK_I	wrpr	%r21, 0x01b6, %tick
	.word 0x8594e168  ! 5784: WRPR_TSTATE_I	wrpr	%r19, 0x0168, %tstate
	.word 0x83946051  ! 5785: WRPR_TNPC_I	wrpr	%r17, 0x0051, %tnpc
	ta	T_CHANGE_HPRIV
T0_spu_op_18:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a0d, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbb3d4000  ! 5794: SRA_R	sra 	%r21, %r0, %r29
hwintr_0_264:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_264), 16, 16)) -> intp(0, 0, 1d)
	.word 0xbde5604d  ! 5800: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb9e5e0e4  ! 5802: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbde4a1c7  ! 5804: SAVE_I	save	%r18, 0x0001, %r30
	ta	T_CHANGE_HPRIV
T0_spu_op_19:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a03, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xb7520000  ! 5811: RDPR_PIL	<illegal instruction>
	.word 0xb7e460f0  ! 5815: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xbbe56169  ! 5816: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb1e4e00d  ! 5820: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbfe5e171  ! 5823: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xbca4e12e  ! 5824: SUBcc_I	subcc 	%r19, 0x012e, %r30
	.word 0xb3e52167  ! 5828: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xbb340000  ! 5829: SRL_R	srl 	%r16, %r0, %r29
	.word 0xbbe461ae  ! 5831: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xb034c000  ! 5832: ORN_R	orn 	%r19, %r0, %r24
	.word 0xbf3c5000  ! 5833: SRAX_R	srax	%r17, %r0, %r31
	.word 0xbfe4a09d  ! 5835: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb150c000  ! 5838: RDPR_TT	<illegal instruction>
	.word 0x8794603b  ! 5840: WRPR_TT_I	wrpr	%r17, 0x003b, %tt
	.word 0xbde5e0bf  ! 5845: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb9500000  ! 5848: RDPR_TPC	<illegal instruction>
	.word 0x8994e0c9  ! 5855: WRPR_TICK_I	wrpr	%r19, 0x00c9, %tick
	.word 0xbde5a053  ! 5856: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xb3e4e0a9  ! 5858: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb7508000  ! 5860: RDPR_TSTATE	<illegal instruction>
	.word 0xb3e4603b  ! 5862: SAVE_I	save	%r17, 0x0001, %r25
	mov	1, %r14
	.word 0xa193a000  ! 5864: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x83952103  ! 5869: WRPR_TNPC_I	wrpr	%r20, 0x0103, %tnpc
	.word 0xbfe4e054  ! 5874: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb37d6401  ! 5875: MOVR_I	movre	%r21, 0x1, %r25
	.word 0xb7510000  ! 5877: RDPR_TICK	<illegal instruction>
	.word 0xb404a095  ! 5878: ADD_I	add 	%r18, 0x0095, %r26
	.word 0xb2b54000  ! 5879: ORNcc_R	orncc 	%r21, %r0, %r25
	.word 0xbd510000  ! 5881: RDPR_TICK	<illegal instruction>
hwintr_0_265:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_265), 16, 16)) -> intp(0, 0, 3a)
	.word 0xbb2d7001  ! 5883: SLLX_I	sllx	%r21, 0x0001, %r29
	.word 0xbde4e0a6  ! 5884: SAVE_I	save	%r19, 0x0001, %r30
	.word 0xb815c000  ! 5887: OR_R	or 	%r23, %r0, %r28
hwintr_0_266:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_266), 16, 16)) -> intp(0, 0, 3a)
hwintr_0_267:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_267), 16, 16)) -> intp(0, 0, 21)
	.word 0xb5520000  ! 5895: RDPR_PIL	<illegal instruction>
	.word 0xb3e521f4  ! 5896: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb1e52191  ! 5900: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xbfe5a089  ! 5901: SAVE_I	save	%r22, 0x0001, %r31
hwintr_0_268:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_268), 16, 16)) -> intp(0, 0, 19)
	.word 0xbbe5e04a  ! 5905: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbde560c5  ! 5906: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb9e560b0  ! 5907: SAVE_I	save	%r21, 0x0001, %r28
	ta	T_CHANGE_HPRIV
T0_spu_op_20:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0xa07, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbde4a014  ! 5909: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xbfe4a1ae  ! 5911: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb5e4e0ff  ! 5912: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xb7e5e03e  ! 5914: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xbde4a009  ! 5915: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb5e520a0  ! 5918: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb9540000  ! 5920: RDPR_GL	<illegal instruction>
	.word 0xb53c6001  ! 5921: SRA_I	sra 	%r17, 0x0001, %r26
	.word 0xb5e52126  ! 5922: SAVE_I	save	%r20, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81982909  ! 5930: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0909, %hpstate
	.word 0xbcb5c000  ! 5931: ORNcc_R	orncc 	%r23, %r0, %r30
	.word 0xb7e561a4  ! 5933: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xb5e4612b  ! 5935: SAVE_I	save	%r17, 0x0001, %r26
hwintr_0_269:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_269), 16, 16)) -> intp(0, 0, 3e)
	.word 0xbf520000  ! 5938: RDPR_PIL	<illegal instruction>
	.word 0xbcb5e044  ! 5940: SUBCcc_I	orncc 	%r23, 0x0044, %r30
hwintr_0_270:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_270), 16, 16)) -> intp(0, 0, f)
	.word 0xb49cc000  ! 5946: XORcc_R	xorcc 	%r19, %r0, %r26
	.word 0xb8858000  ! 5949: ADDcc_R	addcc 	%r22, %r0, %r28
	.word 0xb7e46163  ! 5950: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xbbe5219e  ! 5958: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xb1e421e8  ! 5959: SAVE_I	save	%r16, 0x0001, %r24
	.word 0x8995208a  ! 5960: WRPR_TICK_I	wrpr	%r20, 0x008a, %tick
	.word 0xb5e46120  ! 5962: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb5e5212f  ! 5969: SAVE_I	save	%r20, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81982813  ! 5971: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0813, %hpstate
	.word 0xb72c0000  ! 5972: SLL_R	sll 	%r16, %r0, %r27
hwintr_0_271:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_271), 16, 16)) -> intp(0, 0, d)
	.word 0xbb2d5000  ! 5978: SLLX_R	sllx	%r21, %r0, %r29
	.word 0x89946071  ! 5987: WRPR_TICK_I	wrpr	%r17, 0x0071, %tick
	.word 0xb3500000  ! 5992: RDPR_TPC	<illegal instruction>
	.word 0xb2ad2137  ! 5993: ANDNcc_I	andncc 	%r20, 0x0137, %r25
	.word 0xb7e56147  ! 6000: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xbde4a14f  ! 6001: SAVE_I	save	%r18, 0x0001, %r30
	mov	0, %r14
	.word 0xa193a000  ! 6002: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7500000  ! 6003: RDPR_TPC	<illegal instruction>
	.word 0x9194e08a  ! 6008: WRPR_PIL_I	wrpr	%r19, 0x008a, %pil
hwintr_0_272:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_272), 16, 16)) -> intp(0, 0, a)
	.word 0xb1e561f1  ! 6010: SAVE_I	save	%r21, 0x0001, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982a81  ! 6011: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a81, %hpstate
	.word 0x8795a06a  ! 6012: WRPR_TT_I	wrpr	%r22, 0x006a, %tt
	.word 0xb1e52075  ! 6018: SAVE_I	save	%r20, 0x0001, %r24
	.word 0x9195e03a  ! 6020: WRPR_PIL_I	wrpr	%r23, 0x003a, %pil
	.word 0xb3e5a00f  ! 6021: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xbde521f1  ! 6022: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xb8b48000  ! 6024: ORNcc_R	orncc 	%r18, %r0, %r28
hwintr_0_273:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_273), 16, 16)) -> intp(0, 0, 7)
	.word 0xbde5e0a4  ! 6028: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb7540000  ! 6030: RDPR_GL	<illegal instruction>
	.word 0xb5e561b4  ! 6036: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb7e5e1d0  ! 6037: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xb1350000  ! 6038: SRL_R	srl 	%r20, %r0, %r24
	.word 0xb3e5e19c  ! 6042: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbd50c000  ! 6044: RDPR_TT	<illegal instruction>
	.word 0xb0ad211d  ! 6045: ANDNcc_I	andncc 	%r20, 0x011d, %r24
	.word 0xb5e5611f  ! 6047: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xbfe46022  ! 6048: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xbde56107  ! 6051: SAVE_I	save	%r21, 0x0001, %r30
hwintr_0_274:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_274), 16, 16)) -> intp(0, 0, 12)
	.word 0xb3e4e1b9  ! 6057: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb4148000  ! 6058: OR_R	or 	%r18, %r0, %r26
	.word 0xb3e5609f  ! 6060: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xbfe4a094  ! 6062: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb3e5214e  ! 6064: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xbfe4a097  ! 6068: SAVE_I	save	%r18, 0x0001, %r31
hwintr_0_275:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_275), 16, 16)) -> intp(0, 0, 3d)
	.word 0x8595e127  ! 6071: WRPR_TSTATE_I	wrpr	%r23, 0x0127, %tstate
	.word 0xbb641800  ! 6072: MOVcc_R	<illegal instruction>
hwintr_0_276:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_276), 16, 16)) -> intp(0, 0, c)
	.word 0xb3e5e14f  ! 6076: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb5e56007  ! 6077: SAVE_I	save	%r21, 0x0001, %r26
	.word 0x8394e0b8  ! 6078: WRPR_TNPC_I	wrpr	%r19, 0x00b8, %tnpc
	.word 0xbfe5e0fe  ! 6090: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xbd540000  ! 6091: RDPR_GL	<illegal instruction>
hwintr_0_277:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_277), 16, 16)) -> intp(0, 0, 17)
	.word 0xbde5a0b4  ! 6099: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xb1e5616b  ! 6101: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb5e4a073  ! 6104: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb7e461d0  ! 6105: SAVE_I	save	%r17, 0x0001, %r27
hwintr_0_278:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_278), 16, 16)) -> intp(0, 0, 21)
	.word 0xb5e42106  ! 6110: SAVE_I	save	%r16, 0x0001, %r26
	.word 0x839421c0  ! 6111: WRPR_TNPC_I	wrpr	%r16, 0x01c0, %tnpc
	.word 0xbfe5a0f9  ! 6113: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb9480000  ! 6114: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xb9e520c7  ! 6115: SAVE_I	save	%r20, 0x0001, %r28
hwintr_0_279:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_279), 16, 16)) -> intp(0, 0, 14)
	.word 0x8d9461e0  ! 6118: WRPR_PSTATE_I	wrpr	%r17, 0x01e0, %pstate
	.word 0xb7e4e024  ! 6119: SAVE_I	save	%r19, 0x0001, %r27
hwintr_0_280:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_280), 16, 16)) -> intp(0, 0, 39)
	.word 0xb3500000  ! 6128: RDPR_TPC	<illegal instruction>
	.word 0xb3e5a15c  ! 6129: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb3e5e1e3  ! 6139: SAVE_I	save	%r23, 0x0001, %r25
	ta	T_CHANGE_HPRIV
	.word 0x819828d1  ! 6140: WRHPR_HPSTATE_I	wrhpr	%r0, 0x08d1, %hpstate
	.word 0xbfe46069  ! 6146: SAVE_I	save	%r17, 0x0001, %r31
	.word 0x819561ed  ! 6148: WRPR_TPC_I	wrpr	%r21, 0x01ed, %tpc
	.word 0xbbe5a09c  ! 6150: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb3510000  ! 6151: RDPR_TICK	<illegal instruction>
	.word 0xbbe421aa  ! 6155: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb7e42149  ! 6157: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb6bd2008  ! 6160: XNORcc_I	xnorcc 	%r20, 0x0008, %r27
	.word 0xb534a001  ! 6161: SRL_I	srl 	%r18, 0x0001, %r26
	.word 0xb17cc400  ! 6162: MOVR_R	movre	%r19, %r0, %r24
	.word 0xb1e4a086  ! 6163: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xbfe5a1d0  ! 6168: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xbfe461b6  ! 6172: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xbbe46138  ! 6173: SAVE_I	save	%r17, 0x0001, %r29
	.word 0x8194e06c  ! 6181: WRPR_TPC_I	wrpr	%r19, 0x006c, %tpc
	.word 0xbfe4a0a4  ! 6188: SAVE_I	save	%r18, 0x0001, %r31
	ta	T_CHANGE_HPRIV
T0_spu_op_21:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0xa03, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbde461ae  ! 6193: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb0452115  ! 6195: ADDC_I	addc 	%r20, 0x0115, %r24
	.word 0xbb50c000  ! 6197: RDPR_TT	rdpr	%tt, %r29
hwintr_0_281:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_281), 16, 16)) -> intp(0, 0, 30)
	.word 0xbf510000  ! 6200: RDPR_TICK	<illegal instruction>
	.word 0xb1e56074  ! 6203: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb1e5a0db  ! 6205: SAVE_I	save	%r22, 0x0001, %r24
hwintr_0_282:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_282), 16, 16)) -> intp(0, 0, 11)
	.word 0xb7540000  ! 6207: RDPR_GL	<illegal instruction>
	.word 0xb3510000  ! 6208: RDPR_TICK	<illegal instruction>
	mov	1, %r14
	.word 0xa193a000  ! 6209: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	mov	0, %r14
	.word 0xa193a000  ! 6210: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_0_283:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_283), 16, 16)) -> intp(0, 0, 27)
hwintr_0_284:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_284), 16, 16)) -> intp(0, 0, 2d)
hwintr_0_285:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_285), 16, 16)) -> intp(0, 0, 16)
	.word 0xbbe5217f  ! 6234: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xbf520000  ! 6235: RDPR_PIL	<illegal instruction>
hwintr_0_286:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_286), 16, 16)) -> intp(0, 0, 5)
	.word 0x91956088  ! 6237: WRPR_PIL_I	wrpr	%r21, 0x0088, %pil
	.word 0x8594206a  ! 6238: WRPR_TSTATE_I	wrpr	%r16, 0x006a, %tstate
	.word 0xb5e4e1cf  ! 6239: SAVE_I	save	%r19, 0x0001, %r26
	.word 0x8595e097  ! 6245: WRPR_TSTATE_I	wrpr	%r23, 0x0097, %tstate
	.word 0xbb520000  ! 6246: RDPR_PIL	<illegal instruction>
hwintr_0_287:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_287), 16, 16)) -> intp(0, 0, 19)
	ta	T_CHANGE_HPRIV
	.word 0x81983a81  ! 6256: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a81, %hpstate
	.word 0xb3518000  ! 6257: RDPR_PSTATE	<illegal instruction>
	.word 0xbde4e078  ! 6261: SAVE_I	save	%r19, 0x0001, %r30
	.word 0xb7e56049  ! 6263: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xb3e4e1f5  ! 6264: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb1e4e0ea  ! 6266: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb3480000  ! 6267: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0x8194e014  ! 6268: WRPR_TPC_I	wrpr	%r19, 0x0014, %tpc
	.word 0xbde5a0c4  ! 6269: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xb1e52112  ! 6271: SAVE_I	save	%r20, 0x0001, %r24
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xb9e56011  ! 6284: SAVE_I	save	%r21, 0x0001, %r28
	ta	T_CHANGE_HPRIV
T0_spu_op_22:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a07, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbfe5219c  ! 6294: SAVE_I	save	%r20, 0x0001, %r31
hwintr_0_288:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_288), 16, 16)) -> intp(0, 0, 2c)
	.word 0xb92ca001  ! 6298: SLL_I	sll 	%r18, 0x0001, %r28
	.word 0xbf520000  ! 6299: RDPR_PIL	<illegal instruction>
	.word 0xb6046170  ! 6303: ADD_I	add 	%r17, 0x0170, %r27
hwintr_0_289:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_289), 16, 16)) -> intp(0, 0, 28)
hwintr_0_290:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_290), 16, 16)) -> intp(0, 0, 1)
	.word 0xb93cb001  ! 6307: SRAX_I	srax	%r18, 0x0001, %r28
	.word 0xb62c6102  ! 6310: ANDN_I	andn 	%r17, 0x0102, %r27
	.word 0xbe1c8000  ! 6311: XOR_R	xor 	%r18, %r0, %r31
	.word 0xbbe4a117  ! 6315: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xbbe5e1b9  ! 6317: SAVE_I	save	%r23, 0x0001, %r29
	.word 0x8d95606c  ! 6320: WRPR_PSTATE_I	wrpr	%r21, 0x006c, %pstate
	.word 0xbf520000  ! 6323: RDPR_PIL	<illegal instruction>
	.word 0xbd51c000  ! 6324: RDPR_TL	<illegal instruction>
hwintr_0_291:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_291), 16, 16)) -> intp(0, 0, 28)
	.word 0x8595a0b5  ! 6330: WRPR_TSTATE_I	wrpr	%r22, 0x00b5, %tstate
	.word 0xb5e5a103  ! 6332: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xb9480000  ! 6334: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xbde4205b  ! 6335: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xb751c000  ! 6336: RDPR_TL	<illegal instruction>
	.word 0xbc348000  ! 6337: SUBC_R	orn 	%r18, %r0, %r30
	.word 0xb3e4a1ab  ! 6339: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xb1e4e0ac  ! 6341: SAVE_I	save	%r19, 0x0001, %r24
	mov	1, %r12
	.word 0x8f932000  ! 6344: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb7e4e078  ! 6348: SAVE_I	save	%r19, 0x0001, %r27
	mov	1, %r12
	.word 0x8f932000  ! 6354: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x879521de  ! 6357: WRPR_TT_I	wrpr	%r20, 0x01de, %tt
hwintr_0_292:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_292), 16, 16)) -> intp(0, 0, 1)
	.word 0xb1480000  ! 6359: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xbde4a142  ! 6361: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb1e5e075  ! 6362: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xbde4e09f  ! 6364: SAVE_I	save	%r19, 0x0001, %r30
	.word 0xb1e460a4  ! 6371: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb6850000  ! 6372: ADDcc_R	addcc 	%r20, %r0, %r27
hwintr_0_293:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_293), 16, 16)) -> intp(0, 0, 3b)
	ta	T_CHANGE_HPRIV
T0_spu_op_23:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x20d, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xb9e460e8  ! 6376: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xbfe5e011  ! 6379: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xb49d8000  ! 6384: XORcc_R	xorcc 	%r22, %r0, %r26
	.word 0xbfe4a1cf  ! 6385: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbde42133  ! 6386: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xb024c000  ! 6389: SUB_R	sub 	%r19, %r0, %r24
	.word 0xb7e46160  ! 6391: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xbde421a2  ! 6400: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xb1e46107  ! 6401: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbfe4206b  ! 6402: SAVE_I	save	%r16, 0x0001, %r31
	.word 0x8795619c  ! 6403: WRPR_TT_I	wrpr	%r21, 0x019c, %tt
	.word 0xbb504000  ! 6414: RDPR_TNPC	<illegal instruction>
	.word 0xb3e4e168  ! 6420: SAVE_I	save	%r19, 0x0001, %r25
hwintr_0_294:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_294), 16, 16)) -> intp(0, 0, 3f)
	ta	T_CHANGE_HPRIV
	.word 0x81983e59  ! 6425: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e59, %hpstate
	.word 0xb7518000  ! 6427: RDPR_PSTATE	<illegal instruction>
	.word 0xb9e521e2  ! 6432: SAVE_I	save	%r20, 0x0001, %r28
	.word 0x819520b5  ! 6433: WRPR_TPC_I	wrpr	%r20, 0x00b5, %tpc
	.word 0xbb480000  ! 6435: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
hwintr_0_295:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_295), 16, 16)) -> intp(0, 0, 1f)
	.word 0xb1e5e063  ! 6440: SAVE_I	save	%r23, 0x0001, %r24
hwintr_0_296:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_296), 16, 16)) -> intp(0, 0, 3b)
	.word 0xb92c1000  ! 6444: SLLX_R	sllx	%r16, %r0, %r28
	.word 0xb7e5a11f  ! 6446: SAVE_I	save	%r22, 0x0001, %r27
hwintr_0_297:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_297), 16, 16)) -> intp(0, 0, 2)
	.word 0xb92c9000  ! 6449: SLLX_R	sllx	%r18, %r0, %r28
	.word 0xb9e42085  ! 6450: SAVE_I	save	%r16, 0x0001, %r28
hwintr_0_298:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_298), 16, 16)) -> intp(0, 0, 17)
	.word 0x81952109  ! 6461: WRPR_TPC_I	wrpr	%r20, 0x0109, %tpc
	ta	T_CHANGE_HPRIV
	.word 0x81983dd9  ! 6463: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1dd9, %hpstate
hwintr_0_299:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_299), 16, 16)) -> intp(0, 0, 1a)
	ta	T_CHANGE_HPRIV
	.word 0x81982a91  ! 6465: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a91, %hpstate
	.word 0xb5e420e5  ! 6467: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xba8d0000  ! 6468: ANDcc_R	andcc 	%r20, %r0, %r29
	.word 0xb3e421fb  ! 6473: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xb33d4000  ! 6476: SRA_R	sra 	%r21, %r0, %r25
	.word 0x8394a180  ! 6477: WRPR_TNPC_I	wrpr	%r18, 0x0180, %tnpc
	.word 0x83942001  ! 6483: WRPR_TNPC_I	wrpr	%r16, 0x0001, %tnpc
	.word 0xbfe4e14e  ! 6484: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbd540000  ! 6485: RDPR_GL	<illegal instruction>
	.word 0xbbe5e07b  ! 6486: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb1e46117  ! 6487: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbd35c000  ! 6488: SRL_R	srl 	%r23, %r0, %r30
	.word 0xb7e4e078  ! 6492: SAVE_I	save	%r19, 0x0001, %r27
	.word 0x91946118  ! 6498: WRPR_PIL_I	wrpr	%r17, 0x0118, %pil
	.word 0x8194a0df  ! 6503: WRPR_TPC_I	wrpr	%r18, 0x00df, %tpc
	.word 0xb9520000  ! 6505: RDPR_PIL	<illegal instruction>
	.word 0xbbe46063  ! 6509: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xb5e52157  ! 6513: SAVE_I	save	%r20, 0x0001, %r26
hwintr_0_300:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_300), 16, 16)) -> intp(0, 0, 3f)
hwintr_0_301:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_301), 16, 16)) -> intp(0, 0, 38)
	.word 0x839561d8  ! 6519: WRPR_TNPC_I	wrpr	%r21, 0x01d8, %tnpc
	.word 0x87952136  ! 6520: WRPR_TT_I	wrpr	%r20, 0x0136, %tt
	.word 0xbd510000  ! 6523: RDPR_TICK	<illegal instruction>
	.word 0xb2c4a195  ! 6526: ADDCcc_I	addccc 	%r18, 0x0195, %r25
	.word 0xb7500000  ! 6529: RDPR_TPC	<illegal instruction>
	.word 0xb3e4e079  ! 6535: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xbbe46187  ! 6536: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xbfe5a106  ! 6537: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xbfe421a7  ! 6538: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xb1e5e153  ! 6543: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb1e46127  ! 6544: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbabd4000  ! 6546: XNORcc_R	xnorcc 	%r21, %r0, %r29
	.word 0xbfe560dc  ! 6549: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xb72da001  ! 6551: SLL_I	sll 	%r22, 0x0001, %r27
	.word 0xb9508000  ! 6552: RDPR_TSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982ad3  ! 6553: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0ad3, %hpstate
	.word 0xba3c0000  ! 6554: XNOR_R	xnor 	%r16, %r0, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81983c91  ! 6555: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c91, %hpstate
	.word 0xbb3d0000  ! 6557: SRA_R	sra 	%r20, %r0, %r29
	.word 0xb5e420db  ! 6559: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xbf7dc400  ! 6562: MOVR_R	movre	%r23, %r0, %r31
	.word 0xbfe4e016  ! 6563: SAVE_I	save	%r19, 0x0001, %r31
	.word 0x919421e5  ! 6567: WRPR_PIL_I	wrpr	%r16, 0x01e5, %pil
	.word 0xb3480000  ! 6568: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xb245c000  ! 6571: ADDC_R	addc 	%r23, %r0, %r25
	.word 0xb9e4e06d  ! 6573: SAVE_I	save	%r19, 0x0001, %r28
	.word 0x8995e0d7  ! 6577: WRPR_TICK_I	wrpr	%r23, 0x00d7, %tick
	.word 0xbde5e0d5  ! 6580: SAVE_I	save	%r23, 0x0001, %r30
	ta	T_CHANGE_HPRIV
T0_spu_op_24:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a49, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0x8d95618f  ! 6584: WRPR_PSTATE_I	wrpr	%r21, 0x018f, %pstate
	.word 0xb9e4a1ba  ! 6585: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xb7e5e042  ! 6586: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xb5e4a146  ! 6593: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbde5602f  ! 6603: SAVE_I	save	%r21, 0x0001, %r30
hwintr_0_302:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_302), 16, 16)) -> intp(0, 0, 3a)
	.word 0xbfe5a01f  ! 6606: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb0144000  ! 6607: OR_R	or 	%r17, %r0, %r24
hwintr_0_303:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_303), 16, 16)) -> intp(0, 0, 39)
	.word 0xb951c000  ! 6619: RDPR_TL	<illegal instruction>
	.word 0xb9e460e7  ! 6620: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xb150c000  ! 6622: RDPR_TT	<illegal instruction>
	.word 0xbd500000  ! 6623: RDPR_TPC	<illegal instruction>
	.word 0xbbe4a0d7  ! 6625: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xbfe4e119  ! 6628: SAVE_I	save	%r19, 0x0001, %r31
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0x8d94e027  ! 6632: WRPR_PSTATE_I	wrpr	%r19, 0x0027, %pstate
	.word 0xbfe421bd  ! 6633: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xbfe4a1ad  ! 6639: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb1e4a0b8  ! 6643: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xbb35f001  ! 6647: SRLX_I	srlx	%r23, 0x0001, %r29
	.word 0xb97c8400  ! 6648: MOVR_R	movre	%r18, %r0, %r28
hwintr_0_304:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_304), 16, 16)) -> intp(0, 0, 1)
	.word 0xbde5e068  ! 6656: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xbf35c000  ! 6659: SRL_R	srl 	%r23, %r0, %r31
	.word 0xb5e421b6  ! 6660: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xb9480000  ! 6661: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xbfe561d5  ! 6664: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xbbe4201d  ! 6666: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb7e4e0e2  ! 6670: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb7e4e050  ! 6672: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb1504000  ! 6675: RDPR_TNPC	<illegal instruction>
	.word 0x8194a196  ! 6677: WRPR_TPC_I	wrpr	%r18, 0x0196, %tpc
hwintr_0_305:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_305), 16, 16)) -> intp(0, 0, 27)
	ta	T_CHANGE_HPRIV
	.word 0x81983c91  ! 6682: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c91, %hpstate
	.word 0xb9e52179  ! 6683: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xba2d60a5  ! 6684: ANDN_I	andn 	%r21, 0x00a5, %r29
	.word 0xbd480000  ! 6685: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xb5e4a169  ! 6686: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb12dd000  ! 6694: SLLX_R	sllx	%r23, %r0, %r24
	.word 0xb1518000  ! 6698: RDPR_PSTATE	<illegal instruction>
	.word 0xbd520000  ! 6702: RDPR_PIL	<illegal instruction>
	.word 0xbe85c000  ! 6706: ADDcc_R	addcc 	%r23, %r0, %r31
hwintr_0_306:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_306), 16, 16)) -> intp(0, 0, 0)
	.word 0xb7e4208a  ! 6718: SAVE_I	save	%r16, 0x0001, %r27
hwintr_0_307:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_307), 16, 16)) -> intp(0, 0, 38)
	.word 0xbf540000  ! 6725: RDPR_GL	<illegal instruction>
	.word 0xbfe421d7  ! 6728: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xbd500000  ! 6732: RDPR_TPC	<illegal instruction>
	.word 0xb5500000  ! 6733: RDPR_TPC	<illegal instruction>
	.word 0xbe8da17e  ! 6736: ANDcc_I	andcc 	%r22, 0x017e, %r31
	.word 0xbde521f5  ! 6737: SAVE_I	save	%r20, 0x0001, %r30
	.word 0x8395a098  ! 6745: WRPR_TNPC_I	wrpr	%r22, 0x0098, %tnpc
	.word 0xb1e4a014  ! 6748: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xbf510000  ! 6749: RDPR_TICK	<illegal instruction>
	.word 0xb4a520d9  ! 6750: SUBcc_I	subcc 	%r20, 0x00d9, %r26
	.word 0xb3e5a1aa  ! 6754: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb33d4000  ! 6755: SRA_R	sra 	%r21, %r0, %r25
	.word 0xb7e4602c  ! 6757: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xb9504000  ! 6758: RDPR_TNPC	<illegal instruction>
	.word 0xb5e5e0e7  ! 6760: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xb3e561d4  ! 6762: SAVE_I	save	%r21, 0x0001, %r25
hwintr_0_308:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_308), 16, 16)) -> intp(0, 0, 16)
	.word 0xb1520000  ! 6767: RDPR_PIL	<illegal instruction>
	.word 0xb9e5e07a  ! 6768: SAVE_I	save	%r23, 0x0001, %r28
	.word 0x919461c1  ! 6770: WRPR_PIL_I	wrpr	%r17, 0x01c1, %pil
	.word 0xb5e4217f  ! 6771: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xbf342001  ! 6772: SRL_I	srl 	%r16, 0x0001, %r31
	.word 0xb5e4e04b  ! 6773: SAVE_I	save	%r19, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81983d8b  ! 6774: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d8b, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81982d4b  ! 6777: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d4b, %hpstate
	.word 0xb3e42155  ! 6779: SAVE_I	save	%r16, 0x0001, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81982881  ! 6780: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0881, %hpstate
	.word 0xbde5605d  ! 6784: SAVE_I	save	%r21, 0x0001, %r30
hwintr_0_309:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_309), 16, 16)) -> intp(0, 0, 12)
	.word 0xba2d4000  ! 6788: ANDN_R	andn 	%r21, %r0, %r29
	.word 0xbbe56091  ! 6792: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb5e4a063  ! 6796: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbd504000  ! 6802: RDPR_TNPC	<illegal instruction>
	.word 0xb1e521df  ! 6803: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb7e52048  ! 6809: SAVE_I	save	%r20, 0x0001, %r27
hwintr_0_310:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_310), 16, 16)) -> intp(0, 0, 33)
	.word 0xbb480000  ! 6813: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xb5e4602b  ! 6816: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb3e4e174  ! 6826: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xbd7da401  ! 6827: MOVR_I	movre	%r22, 0x1, %r30
	.word 0xbfe5e012  ! 6828: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xb644a099  ! 6829: ADDC_I	addc 	%r18, 0x0099, %r27
	.word 0xb33dd000  ! 6831: SRAX_R	srax	%r23, %r0, %r25
hwintr_0_311:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_311), 16, 16)) -> intp(0, 0, 17)
	.word 0xb3e460b6  ! 6835: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb5e5a13d  ! 6840: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xb7e42161  ! 6842: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xbbe4605f  ! 6847: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xb3e4e178  ! 6849: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xbfe560ef  ! 6850: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xb9e5a185  ! 6854: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xbbe4a10c  ! 6858: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xb2846168  ! 6860: ADDcc_I	addcc 	%r17, 0x0168, %r25
hwintr_0_312:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_312), 16, 16)) -> intp(0, 0, 3a)
	.word 0xb3e4a1ab  ! 6863: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xbb51c000  ! 6866: RDPR_TL	<illegal instruction>
	.word 0xba34e1cf  ! 6868: SUBC_I	orn 	%r19, 0x01cf, %r29
	.word 0xb5e4a181  ! 6870: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbbe5a1bf  ! 6873: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb41da05d  ! 6874: XOR_I	xor 	%r22, 0x005d, %r26
	.word 0xbbe56110  ! 6875: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb9e421d3  ! 6876: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xbbe4e1cb  ! 6878: SAVE_I	save	%r19, 0x0001, %r29
	mov	1, %r12
	.word 0x8f932000  ! 6883: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x879420cf  ! 6893: WRPR_TT_I	wrpr	%r16, 0x00cf, %tt
hwintr_0_313:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_313), 16, 16)) -> intp(0, 0, 13)
	.word 0xb5504000  ! 6898: RDPR_TNPC	<illegal instruction>
	.word 0x819561b1  ! 6899: WRPR_TPC_I	wrpr	%r21, 0x01b1, %tpc
	.word 0xbfe52051  ! 6906: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xbfe460d4  ! 6908: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xb3540000  ! 6910: RDPR_GL	<illegal instruction>
	.word 0xb61de070  ! 6916: XOR_I	xor 	%r23, 0x0070, %r27
	.word 0xb5e5213e  ! 6917: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb3e4a0d1  ! 6920: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xbfe52086  ! 6925: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xbb520000  ! 6927: RDPR_PIL	<illegal instruction>
	.word 0xbfe5a0d3  ! 6929: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xbde461fe  ! 6930: SAVE_I	save	%r17, 0x0001, %r30
hwintr_0_314:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_314), 16, 16)) -> intp(0, 0, 12)
hwintr_0_315:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_315), 16, 16)) -> intp(0, 0, 33)
	.word 0xb1e46026  ! 6934: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb7e4a063  ! 6935: SAVE_I	save	%r18, 0x0001, %r27
hwintr_0_316:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_316), 16, 16)) -> intp(0, 0, 3e)
	.word 0xb9e4e045  ! 6939: SAVE_I	save	%r19, 0x0001, %r28
hwintr_0_317:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_317), 16, 16)) -> intp(0, 0, 38)
	ta	T_CHANGE_HPRIV
	.word 0x81983c4b  ! 6943: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c4b, %hpstate
	.word 0xbb7c2401  ! 6945: MOVR_I	movre	%r16, 0x1, %r29
	.word 0xbde46149  ! 6946: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb734e001  ! 6948: SRL_I	srl 	%r19, 0x0001, %r27
	.word 0xbd51c000  ! 6949: RDPR_TL	<illegal instruction>
	.word 0xbbe4e09a  ! 6953: SAVE_I	save	%r19, 0x0001, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81982f43  ! 6957: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f43, %hpstate
	.word 0xb7e420d5  ! 6960: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xbbe42137  ! 6964: SAVE_I	save	%r16, 0x0001, %r29
hwintr_0_318:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_318), 16, 16)) -> intp(0, 0, 29)
	.word 0xb53ce001  ! 6972: SRA_I	sra 	%r19, 0x0001, %r26
	.word 0xb3e5a0ae  ! 6974: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb9e521b5  ! 6976: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb7e56186  ! 6980: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xbb518000  ! 6981: RDPR_PSTATE	<illegal instruction>
	.word 0xb7e460c5  ! 6982: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xb5e521ae  ! 6983: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xbe0c61b3  ! 6986: AND_I	and 	%r17, 0x01b3, %r31
hwintr_0_319:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_319), 16, 16)) -> intp(0, 0, 27)
hwintr_0_320:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_320), 16, 16)) -> intp(0, 0, 1e)
hwintr_0_321:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_321), 16, 16)) -> intp(0, 0, 10)
	ta	T_CHANGE_HPRIV
	.word 0x81983f09  ! 6996: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f09, %hpstate
	.word 0xbfe4e1f6  ! 7003: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xbde4607d  ! 7006: SAVE_I	save	%r17, 0x0001, %r30
	.word 0x8595a151  ! 7011: WRPR_TSTATE_I	wrpr	%r22, 0x0151, %tstate
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0x8795614f  ! 7016: WRPR_TT_I	wrpr	%r21, 0x014f, %tt
	.word 0xb3e4e0c1  ! 7018: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb3518000  ! 7024: RDPR_PSTATE	<illegal instruction>
	.word 0xb7e4a13c  ! 7026: SAVE_I	save	%r18, 0x0001, %r27
hwintr_0_322:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_322), 16, 16)) -> intp(0, 0, 27)
	.word 0xbebca0af  ! 7031: XNORcc_I	xnorcc 	%r18, 0x00af, %r31
	.word 0xb751c000  ! 7035: RDPR_TL	<illegal instruction>
hwintr_0_323:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_323), 16, 16)) -> intp(0, 0, 28)
	.word 0xbb518000  ! 7042: RDPR_PSTATE	<illegal instruction>
hwintr_0_324:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_324), 16, 16)) -> intp(0, 0, 32)
	.word 0xbbe461eb  ! 7046: SAVE_I	save	%r17, 0x0001, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81983f89  ! 7047: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f89, %hpstate
	.word 0x919520fa  ! 7052: WRPR_PIL_I	wrpr	%r20, 0x00fa, %pil
	.word 0xbb510000  ! 7053: RDPR_TICK	<illegal instruction>
	.word 0xb9e5e008  ! 7054: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xb3e52078  ! 7055: SAVE_I	save	%r20, 0x0001, %r25
	.word 0x9195a012  ! 7056: WRPR_PIL_I	wrpr	%r22, 0x0012, %pil
	.word 0xb7e5e133  ! 7057: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xbde4a0d3  ! 7060: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xbb3d8000  ! 7062: SRA_R	sra 	%r22, %r0, %r29
	.word 0xbfe5e191  ! 7066: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xbfe46123  ! 7068: SAVE_I	save	%r17, 0x0001, %r31
	.word 0x9195a1d1  ! 7069: WRPR_PIL_I	wrpr	%r22, 0x01d1, %pil
	.word 0xb9e46049  ! 7070: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xbe05e1c1  ! 7071: ADD_I	add 	%r23, 0x01c1, %r31
	.word 0xb3e42070  ! 7074: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xb5e4a1ab  ! 7075: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb8158000  ! 7080: OR_R	or 	%r22, %r0, %r28
	.word 0xbde5a19d  ! 7082: SAVE_I	save	%r22, 0x0001, %r30
	ta	T_CHANGE_HPRIV
	.word 0x81982c13  ! 7084: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c13, %hpstate
	.word 0xb9e5614b  ! 7085: SAVE_I	save	%r21, 0x0001, %r28
hwintr_0_325:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_325), 16, 16)) -> intp(0, 0, 33)
	.word 0x8d95603d  ! 7096: WRPR_PSTATE_I	wrpr	%r21, 0x003d, %pstate
	ta	T_CHANGE_HPRIV
T0_spu_op_25:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0xa0b, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xb5510000  ! 7098: RDPR_TICK	<illegal instruction>
	.word 0xb3e52060  ! 7103: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb9e4619f  ! 7104: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xb1345000  ! 7106: SRLX_R	srlx	%r17, %r0, %r24
	.word 0xbde42045  ! 7107: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xbbe421ea  ! 7109: SAVE_I	save	%r16, 0x0001, %r29
	mov	0, %r14
	.word 0xa193a000  ! 7111: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb805c000  ! 7113: ADD_R	add 	%r23, %r0, %r28
hwintr_0_326:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_326), 16, 16)) -> intp(0, 0, d)
	.word 0xb7e5a08a  ! 7117: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb3e4606d  ! 7118: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb835617c  ! 7119: SUBC_I	orn 	%r21, 0x017c, %r28
	ta	T_CHANGE_HPRIV
T0_spu_op_26:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a09, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbbe5a10f  ! 7123: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb7e5a09d  ! 7124: SAVE_I	save	%r22, 0x0001, %r27
hwintr_0_327:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_327), 16, 16)) -> intp(0, 0, 6)
	.word 0xb750c000  ! 7130: RDPR_TT	<illegal instruction>
	.word 0xbfe421e7  ! 7132: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xb3e52095  ! 7134: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xbc1dc000  ! 7135: XOR_R	xor 	%r23, %r0, %r30
	.word 0xb32c4000  ! 7137: SLL_R	sll 	%r17, %r0, %r25
	.word 0xbf51c000  ! 7138: RDPR_TL	<illegal instruction>
	.word 0xb3e5a11d  ! 7141: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xbe1d4000  ! 7150: XOR_R	xor 	%r21, %r0, %r31
	.word 0xbfe46008  ! 7155: SAVE_I	save	%r17, 0x0001, %r31
	.word 0x8195e0a2  ! 7162: WRPR_TPC_I	wrpr	%r23, 0x00a2, %tpc
	.word 0xbbe5e063  ! 7163: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb1e4202a  ! 7164: SAVE_I	save	%r16, 0x0001, %r24
hwintr_0_328:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_328), 16, 16)) -> intp(0, 0, 23)
	.word 0xbb520000  ! 7166: RDPR_PIL	<illegal instruction>
	.word 0xb1e42064  ! 7167: SAVE_I	save	%r16, 0x0001, %r24
hwintr_0_329:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_329), 16, 16)) -> intp(0, 0, 6)
	.word 0xb3e5a099  ! 7173: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb5e5212f  ! 7174: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb1e4a19b  ! 7175: SAVE_I	save	%r18, 0x0001, %r24
	.word 0x8995e1c0  ! 7178: WRPR_TICK_I	wrpr	%r23, 0x01c0, %tick
	.word 0x8794e04d  ! 7179: WRPR_TT_I	wrpr	%r19, 0x004d, %tt
	.word 0xbde5a0f5  ! 7180: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xbfe4a035  ! 7181: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb3e4a110  ! 7186: SAVE_I	save	%r18, 0x0001, %r25
	.word 0x879420cc  ! 7189: WRPR_TT_I	wrpr	%r16, 0x00cc, %tt
	.word 0xbf520000  ! 7194: RDPR_PIL	<illegal instruction>
	.word 0xbde4a08f  ! 7198: SAVE_I	save	%r18, 0x0001, %r30
	.word 0x89952017  ! 7200: WRPR_TICK_I	wrpr	%r20, 0x0017, %tick
	.word 0xb7e461f4  ! 7201: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xbbe5e09d  ! 7202: SAVE_I	save	%r23, 0x0001, %r29
	.word 0x859560c3  ! 7207: WRPR_TSTATE_I	wrpr	%r21, 0x00c3, %tstate
hwintr_0_330:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_330), 16, 16)) -> intp(0, 0, 1a)
	.word 0xb1e4e005  ! 7212: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb5e52046  ! 7215: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb150c000  ! 7217: RDPR_TT	<illegal instruction>
	.word 0xbb504000  ! 7221: RDPR_TNPC	<illegal instruction>
	.word 0xb4258000  ! 7222: SUB_R	sub 	%r22, %r0, %r26
	.word 0xbde5e0e4  ! 7227: SAVE_I	save	%r23, 0x0001, %r30
hwintr_0_331:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_331), 16, 16)) -> intp(0, 0, 27)
	.word 0xb9e5608c  ! 7229: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xb5e46145  ! 7230: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xbde5603a  ! 7232: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xbfe5e024  ! 7234: SAVE_I	save	%r23, 0x0001, %r31
	mov	1, %r14
	.word 0xa193a000  ! 7235: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	mov	1, %r14
	.word 0xa193a000  ! 7237: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_0_332:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_332), 16, 16)) -> intp(0, 0, 10)
	ta	T_CHANGE_HPRIV
	.word 0x81983dd3  ! 7242: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1dd3, %hpstate
	.word 0x919420f2  ! 7247: WRPR_PIL_I	wrpr	%r16, 0x00f2, %pil
	ta	T_CHANGE_HPRIV
	.word 0x81983c91  ! 7250: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c91, %hpstate
	.word 0x859421d7  ! 7251: WRPR_TSTATE_I	wrpr	%r16, 0x01d7, %tstate
	.word 0xb7e56117  ! 7258: SAVE_I	save	%r21, 0x0001, %r27
	mov	0, %r12
	.word 0x8f932000  ! 7259: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb7e4e0cf  ! 7260: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xbfe56126  ! 7264: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xb1518000  ! 7267: RDPR_PSTATE	<illegal instruction>
	.word 0xbabdc000  ! 7268: XNORcc_R	xnorcc 	%r23, %r0, %r29
	.word 0xbde461d0  ! 7271: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xbf2da001  ! 7272: SLL_I	sll 	%r22, 0x0001, %r31
	.word 0xbfe5a06c  ! 7276: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xbde52124  ! 7277: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xbea5a012  ! 7278: SUBcc_I	subcc 	%r22, 0x0012, %r31
	.word 0xb9e56024  ! 7281: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xbde5210c  ! 7282: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xbde5a032  ! 7286: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xbfe4615c  ! 7287: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xb3e4e0e4  ! 7299: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb3e5e149  ! 7301: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbd51c000  ! 7302: RDPR_TL	<illegal instruction>
	.word 0xbde5e1ca  ! 7306: SAVE_I	save	%r23, 0x0001, %r30
	.word 0x8994e019  ! 7307: WRPR_TICK_I	wrpr	%r19, 0x0019, %tick
	ta	T_CHANGE_HPRIV
	.word 0x81983d19  ! 7313: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d19, %hpstate
	.word 0xbb510000  ! 7314: RDPR_TICK	<illegal instruction>
	.word 0xb9e4e023  ! 7318: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb7e420de  ! 7320: SAVE_I	save	%r16, 0x0001, %r27
	.word 0x819521d2  ! 7322: WRPR_TPC_I	wrpr	%r20, 0x01d2, %tpc
	.word 0xb12c3001  ! 7323: SLLX_I	sllx	%r16, 0x0001, %r24
	.word 0xbbe4e03d  ! 7324: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xb5e421e6  ! 7326: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xbde4e0e6  ! 7327: SAVE_I	save	%r19, 0x0001, %r30
	.word 0xb3e4a1f7  ! 7328: SAVE_I	save	%r18, 0x0001, %r25
	mov	2, %r14
	.word 0xa193a000  ! 7332: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xba8c8000  ! 7336: ANDcc_R	andcc 	%r18, %r0, %r29
	mov	2, %r14
	.word 0xa193a000  ! 7340: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_0_333:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_333), 16, 16)) -> intp(0, 0, 8)
	.word 0xb3520000  ! 7347: RDPR_PIL	<illegal instruction>
	.word 0xb7504000  ! 7349: RDPR_TNPC	<illegal instruction>
	.word 0xb9e520c2  ! 7351: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb4bc0000  ! 7353: XNORcc_R	xnorcc 	%r16, %r0, %r26
	.word 0xb1e4e017  ! 7356: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb7e4613e  ! 7357: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xb3e52077  ! 7358: SAVE_I	save	%r20, 0x0001, %r25
	.word 0x8d94207c  ! 7360: WRPR_PSTATE_I	wrpr	%r16, 0x007c, %pstate
	.word 0xbfe46028  ! 7362: SAVE_I	save	%r17, 0x0001, %r31
hwintr_0_334:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_334), 16, 16)) -> intp(0, 0, 39)
	.word 0x839420f8  ! 7367: WRPR_TNPC_I	wrpr	%r16, 0x00f8, %tnpc
hwintr_0_335:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_335), 16, 16)) -> intp(0, 0, 3e)
hwintr_0_336:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_336), 16, 16)) -> intp(0, 0, 3f)
	.word 0xb3e5a0b0  ! 7378: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb7e5a1a1  ! 7381: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xbbe5a111  ! 7382: SAVE_I	save	%r22, 0x0001, %r29
	mov	2, %r12
	.word 0x8f932000  ! 7383: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb3e42062  ! 7386: SAVE_I	save	%r16, 0x0001, %r25
	.word 0x8394a1ac  ! 7387: WRPR_TNPC_I	wrpr	%r18, 0x01ac, %tnpc
	.word 0x8594e1c0  ! 7388: WRPR_TSTATE_I	wrpr	%r19, 0x01c0, %tstate
	.word 0xb1e4612a  ! 7389: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbd641800  ! 7391: MOVcc_R	<illegal instruction>
hwintr_0_337:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_337), 16, 16)) -> intp(0, 0, 1f)
	.word 0xbde460d8  ! 7398: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb3504000  ! 7403: RDPR_TNPC	<illegal instruction>
hwintr_0_338:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_338), 16, 16)) -> intp(0, 0, 29)
	mov	1, %r12
	.word 0x8f932000  ! 7407: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_0_339:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_339), 16, 16)) -> intp(0, 0, 1)
	.word 0xb7e5a0be  ! 7410: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb9e4218a  ! 7414: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xb3e460f0  ! 7417: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb3e46032  ! 7418: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb1e5a08e  ! 7424: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb29d21b0  ! 7425: XORcc_I	xorcc 	%r20, 0x01b0, %r25
	.word 0xbd504000  ! 7426: RDPR_TNPC	<illegal instruction>
	.word 0xbf50c000  ! 7429: RDPR_TT	<illegal instruction>
	.word 0xb1520000  ! 7432: RDPR_PIL	<illegal instruction>
	.word 0xb1e52117  ! 7435: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xbbe56139  ! 7437: SAVE_I	save	%r21, 0x0001, %r29
hwintr_0_340:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_340), 16, 16)) -> intp(0, 0, 1)
	.word 0xb1e5e19b  ! 7444: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb3e5e0db  ! 7446: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb1e5a02c  ! 7448: SAVE_I	save	%r22, 0x0001, %r24
	mov	2, %r14
	.word 0xa193a000  ! 7449: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb3e4e00d  ! 7451: SAVE_I	save	%r19, 0x0001, %r25
	.word 0xb5e5613e  ! 7452: SAVE_I	save	%r21, 0x0001, %r26
hwintr_0_341:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_341), 16, 16)) -> intp(0, 0, 37)
	.word 0xbde5e095  ! 7455: SAVE_I	save	%r23, 0x0001, %r30
hwintr_0_342:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_342), 16, 16)) -> intp(0, 0, 1e)
	.word 0xb1e56062  ! 7457: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb3504000  ! 7458: RDPR_TNPC	<illegal instruction>
	.word 0xb5e460b2  ! 7459: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb7e5a15c  ! 7460: SAVE_I	save	%r22, 0x0001, %r27
hwintr_0_343:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_343), 16, 16)) -> intp(0, 0, e)
	.word 0xb9500000  ! 7464: RDPR_TPC	<illegal instruction>
	.word 0x8395611b  ! 7471: WRPR_TNPC_I	wrpr	%r21, 0x011b, %tnpc
	.word 0xb1504000  ! 7474: RDPR_TNPC	<illegal instruction>
	.word 0xbbe5201b  ! 7476: SAVE_I	save	%r20, 0x0001, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81982a99  ! 7482: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a99, %hpstate
	.word 0xbde4607a  ! 7486: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb5508000  ! 7487: RDPR_TSTATE	<illegal instruction>
	.word 0xb9e5e041  ! 7489: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbfe5e05b  ! 7491: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xb9e4204a  ! 7498: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xb3e521df  ! 7501: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xbde56180  ! 7506: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb5e42085  ! 7507: SAVE_I	save	%r16, 0x0001, %r26
hwintr_0_344:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_344), 16, 16)) -> intp(0, 0, 3a)
	.word 0xbb480000  ! 7510: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xb77cc400  ! 7511: MOVR_R	movre	%r19, %r0, %r27
	.word 0xb5e5208a  ! 7513: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb6a4209c  ! 7519: SUBcc_I	subcc 	%r16, 0x009c, %r27
	.word 0xb1e4a193  ! 7521: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xb7e4e01d  ! 7522: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xbde560b9  ! 7525: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb29dc000  ! 7527: XORcc_R	xorcc 	%r23, %r0, %r25
	.word 0xb88c4000  ! 7528: ANDcc_R	andcc 	%r17, %r0, %r28
	mov	1, %r14
	.word 0xa193a000  ! 7530: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9e46044  ! 7533: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xb7504000  ! 7534: RDPR_TNPC	<illegal instruction>
	.word 0xb7e5e0af  ! 7535: SAVE_I	save	%r23, 0x0001, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982b83  ! 7537: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b83, %hpstate
	.word 0xbde52039  ! 7542: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xbfe561ad  ! 7548: SAVE_I	save	%r21, 0x0001, %r31
hwintr_0_345:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_345), 16, 16)) -> intp(0, 0, 11)
hwintr_0_346:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_346), 16, 16)) -> intp(0, 0, a)
	.word 0xbbe5a1c0  ! 7551: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb1e5e01f  ! 7553: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb1e4a180  ! 7554: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xbd51c000  ! 7558: RDPR_TL	<illegal instruction>
	.word 0x85942004  ! 7560: WRPR_TSTATE_I	wrpr	%r16, 0x0004, %tstate
	.word 0x899421c4  ! 7565: WRPR_TICK_I	wrpr	%r16, 0x01c4, %tick
	.word 0xb1480000  ! 7572: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0x91946005  ! 7573: WRPR_PIL_I	wrpr	%r17, 0x0005, %pil
	ta	T_CHANGE_HPRIV
	.word 0x81983d9b  ! 7577: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d9b, %hpstate
	.word 0x8d956102  ! 7578: WRPR_PSTATE_I	wrpr	%r21, 0x0102, %pstate
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xb1e421e2  ! 7580: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xb9e56040  ! 7584: SAVE_I	save	%r21, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	.word 0x819828c9  ! 7585: WRHPR_HPSTATE_I	wrhpr	%r0, 0x08c9, %hpstate
hwintr_0_347:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_347), 16, 16)) -> intp(0, 0, 3c)
	.word 0xbd50c000  ! 7590: RDPR_TT	<illegal instruction>
	.word 0xb7e4a156  ! 7591: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xb5e4a051  ! 7592: SAVE_I	save	%r18, 0x0001, %r26
	.word 0x8d95a020  ! 7593: WRPR_PSTATE_I	wrpr	%r22, 0x0020, %pstate
	.word 0xb89ce1e2  ! 7595: XORcc_I	xorcc 	%r19, 0x01e2, %r28
hwintr_0_348:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_348), 16, 16)) -> intp(0, 0, 8)
	.word 0xb750c000  ! 7599: RDPR_TT	<illegal instruction>
	.word 0xb3518000  ! 7600: RDPR_PSTATE	<illegal instruction>
	.word 0xb3e560d6  ! 7601: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xb7e4e09b  ! 7604: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xbb348000  ! 7608: SRL_R	srl 	%r18, %r0, %r29
	.word 0xbfe4619c  ! 7617: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xbbe561e1  ! 7621: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xbde46129  ! 7622: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xbe44c000  ! 7623: ADDC_R	addc 	%r19, %r0, %r31
hwintr_0_349:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_349), 16, 16)) -> intp(0, 0, 0)
	.word 0xbde5e080  ! 7630: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb7e421e7  ! 7636: SAVE_I	save	%r16, 0x0001, %r27
	mov	1, %r14
	.word 0xa193a000  ! 7638: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb3e5e14a  ! 7639: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb6046173  ! 7643: ADD_I	add 	%r17, 0x0173, %r27
	.word 0xbfe420a3  ! 7644: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xbbe42011  ! 7650: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb550c000  ! 7653: RDPR_TT	<illegal instruction>
	.word 0xb035e0d2  ! 7655: SUBC_I	orn 	%r23, 0x00d2, %r24
	.word 0xbfe5a1bc  ! 7660: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb9e561ec  ! 7661: SAVE_I	save	%r21, 0x0001, %r28
	.word 0x8794e178  ! 7668: WRPR_TT_I	wrpr	%r19, 0x0178, %tt
	.word 0xb1e5a1b6  ! 7670: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb9643801  ! 7675: MOVcc_I	<illegal instruction>
	.word 0xb3520000  ! 7681: RDPR_PIL	<illegal instruction>
	.word 0xb3e5e1cf  ! 7683: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xbec48000  ! 7685: ADDCcc_R	addccc 	%r18, %r0, %r31
hwintr_0_350:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_350), 16, 16)) -> intp(0, 0, 39)
	.word 0x8394e083  ! 7691: WRPR_TNPC_I	wrpr	%r19, 0x0083, %tnpc
	.word 0xb1e4610a  ! 7694: SAVE_I	save	%r17, 0x0001, %r24
	ta	T_CHANGE_HPRIV
T0_spu_op_27:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x203, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
hwintr_0_351:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_351), 16, 16)) -> intp(0, 0, 14)
	.word 0xb1e4606d  ! 7704: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb7518000  ! 7705: RDPR_PSTATE	<illegal instruction>
	.word 0xbf510000  ! 7707: RDPR_TICK	<illegal instruction>
	.word 0x8d942053  ! 7709: WRPR_PSTATE_I	wrpr	%r16, 0x0053, %pstate
	.word 0xb9e4e023  ! 7710: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb5e4e130  ! 7712: SAVE_I	save	%r19, 0x0001, %r26
hwintr_0_352:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_352), 16, 16)) -> intp(0, 0, 5)
	.word 0xb5e4e13f  ! 7719: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xb551c000  ! 7723: RDPR_TL	<illegal instruction>
	.word 0xb7e5a09e  ! 7726: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb9508000  ! 7733: RDPR_TSTATE	<illegal instruction>
	.word 0x8d9521e4  ! 7736: WRPR_PSTATE_I	wrpr	%r20, 0x01e4, %pstate
	.word 0x85956127  ! 7737: WRPR_TSTATE_I	wrpr	%r21, 0x0127, %tstate
	mov	1, %r12
	.word 0x8f932000  ! 7738: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbde52070  ! 7746: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xb1510000  ! 7752: RDPR_TICK	<illegal instruction>
	.word 0xb1508000  ! 7753: RDPR_TSTATE	<illegal instruction>
hwintr_0_353:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_353), 16, 16)) -> intp(0, 0, 3f)
	.word 0xba248000  ! 7756: SUB_R	sub 	%r18, %r0, %r29
	.word 0xbbe42166  ! 7766: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xbb480000  ! 7770: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xbde5a1f4  ! 7775: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xbde56137  ! 7778: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb751c000  ! 7779: RDPR_TL	<illegal instruction>
	.word 0xb134f001  ! 7783: SRLX_I	srlx	%r19, 0x0001, %r24
	.word 0xb1e4e149  ! 7787: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb3e4a1d2  ! 7789: SAVE_I	save	%r18, 0x0001, %r25
hwintr_0_354:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_354), 16, 16)) -> intp(0, 0, 16)
hwintr_0_355:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_355), 16, 16)) -> intp(0, 0, 6)
	.word 0xb5e421ce  ! 7797: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xb49da177  ! 7800: XORcc_I	xorcc 	%r22, 0x0177, %r26
	.word 0xbde5a111  ! 7801: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xb1520000  ! 7805: RDPR_PIL	<illegal instruction>
	.word 0xbf355000  ! 7809: SRLX_R	srlx	%r21, %r0, %r31
hwintr_0_356:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_356), 16, 16)) -> intp(0, 0, 3c)
	.word 0xb1504000  ! 7812: RDPR_TNPC	<illegal instruction>
	.word 0xbc952036  ! 7813: ORcc_I	orcc 	%r20, 0x0036, %r30
	.word 0xb5e4a1c8  ! 7814: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb9508000  ! 7815: RDPR_TSTATE	<illegal instruction>
	.word 0xbfe5e1ff  ! 7818: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xbd520000  ! 7824: RDPR_PIL	<illegal instruction>
	.word 0xb5e52169  ! 7827: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb9e461f5  ! 7832: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xbfe4e0c5  ! 7833: SAVE_I	save	%r19, 0x0001, %r31
	.word 0x8d94a050  ! 7834: WRPR_PSTATE_I	wrpr	%r18, 0x0050, %pstate
hwintr_0_357:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_357), 16, 16)) -> intp(0, 0, 3f)
	.word 0xbfe5a057  ! 7836: SAVE_I	save	%r22, 0x0001, %r31
	.word 0x89942057  ! 7840: WRPR_TICK_I	wrpr	%r16, 0x0057, %tick
	ta	T_CHANGE_HPRIV
	.word 0x81982c09  ! 7844: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c09, %hpstate
	.word 0xbbe5e0cc  ! 7846: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbe35e14f  ! 7849: ORN_I	orn 	%r23, 0x014f, %r31
	.word 0xb3e5a133  ! 7852: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb7e5a020  ! 7854: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xbbe4e10d  ! 7860: SAVE_I	save	%r19, 0x0001, %r29
hwintr_0_358:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_358), 16, 16)) -> intp(0, 0, 1)
	.word 0xbc25e15a  ! 7862: SUB_I	sub 	%r23, 0x015a, %r30
	.word 0xb7e520a1  ! 7863: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xb9e561d7  ! 7866: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xb5e5e16c  ! 7868: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xb1e5a1c6  ! 7869: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb5504000  ! 7870: RDPR_TNPC	<illegal instruction>
	.word 0xb3e421f1  ! 7874: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xb1e5a1ca  ! 7875: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb4154000  ! 7877: OR_R	or 	%r21, %r0, %r26
	.word 0xbfe5e0e3  ! 7878: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xb1e560f9  ! 7881: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb53df001  ! 7882: SRAX_I	srax	%r23, 0x0001, %r26
	.word 0xbbe5e1f4  ! 7888: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbbe4611e  ! 7890: SAVE_I	save	%r17, 0x0001, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81983b93  ! 7897: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b93, %hpstate
hwintr_0_359:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_359), 16, 16)) -> intp(0, 0, b)
	.word 0xbde42032  ! 7899: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xb5504000  ! 7900: RDPR_TNPC	<illegal instruction>
hwintr_0_360:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_360), 16, 16)) -> intp(0, 0, 11)
	.word 0xb3e420d5  ! 7904: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xb8a4c000  ! 7909: SUBcc_R	subcc 	%r19, %r0, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982d41  ! 7911: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d41, %hpstate
	.word 0xbfe520ae  ! 7912: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xb9e4a1d0  ! 7913: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xbd518000  ! 7915: RDPR_PSTATE	<illegal instruction>
	.word 0xb7e5211d  ! 7917: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xb5508000  ! 7919: RDPR_TSTATE	<illegal instruction>
hwintr_0_361:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_361), 16, 16)) -> intp(0, 0, c)
hwintr_0_362:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_362), 16, 16)) -> intp(0, 0, 2d)
	.word 0xbd508000  ! 7926: RDPR_TSTATE	<illegal instruction>
	.word 0xb9540000  ! 7927: RDPR_GL	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982dc9  ! 7928: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dc9, %hpstate
	.word 0x8195618a  ! 7929: WRPR_TPC_I	wrpr	%r21, 0x018a, %tpc
	.word 0xb3e4617e  ! 7930: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb7e5a12b  ! 7933: SAVE_I	save	%r22, 0x0001, %r27
	.word 0x8195e1b9  ! 7934: WRPR_TPC_I	wrpr	%r23, 0x01b9, %tpc
	.word 0xbbe4a197  ! 7942: SAVE_I	save	%r18, 0x0001, %r29
hwintr_0_363:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_363), 16, 16)) -> intp(0, 0, b)
	.word 0xbfe46165  ! 7946: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xb1e5e00e  ! 7949: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb5e5205b  ! 7950: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xbbe42071  ! 7952: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb1e5e055  ! 7953: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb5e4e0a6  ! 7957: SAVE_I	save	%r19, 0x0001, %r26
hwintr_0_364:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_364), 16, 16)) -> intp(0, 0, 2e)
	.word 0xb4340000  ! 7959: ORN_R	orn 	%r16, %r0, %r26
	.word 0xbde4a005  ! 7962: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb5e461da  ! 7966: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xbbe5e037  ! 7968: SAVE_I	save	%r23, 0x0001, %r29
	mov	2, %r14
	.word 0xa193a000  ! 7978: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb3504000  ! 7983: RDPR_TNPC	<illegal instruction>
hwintr_0_365:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_365), 16, 16)) -> intp(0, 0, 1d)
	.word 0x87952186  ! 7990: WRPR_TT_I	wrpr	%r20, 0x0186, %tt
	.word 0xbbe5e09a  ! 7996: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb5e521db  ! 7998: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb8bda10e  ! 7999: XNORcc_I	xnorcc 	%r22, 0x010e, %r28
hwintr_0_366:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_366), 16, 16)) -> intp(0, 0, 12)
	.word 0xbbe5e127  ! 8007: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb9504000  ! 8008: RDPR_TNPC	<illegal instruction>
hwintr_0_367:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_367), 16, 16)) -> intp(0, 0, 25)
hwintr_0_368:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_368), 16, 16)) -> intp(0, 0, 11)
	.word 0xbfe521b4  ! 8017: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xb9e4e00a  ! 8020: SAVE_I	save	%r19, 0x0001, %r28
	.word 0x8395e147  ! 8021: WRPR_TNPC_I	wrpr	%r23, 0x0147, %tnpc
	ta	T_CHANGE_HPRIV
	.word 0x81983b03  ! 8022: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b03, %hpstate
hwintr_0_369:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_369), 16, 16)) -> intp(0, 0, 1b)
	.word 0xbbe4a0ef  ! 8026: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xb7e560a2  ! 8032: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xb53c8000  ! 8035: SRA_R	sra 	%r18, %r0, %r26
hwintr_0_370:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_370), 16, 16)) -> intp(0, 0, 1e)
	.word 0xb350c000  ! 8038: RDPR_TT	<illegal instruction>
	.word 0x89956011  ! 8039: WRPR_TICK_I	wrpr	%r21, 0x0011, %tick
hwintr_0_371:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_371), 16, 16)) -> intp(0, 0, 0)
hwintr_0_372:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_372), 16, 16)) -> intp(0, 0, 15)
	.word 0xb7e4a05a  ! 8045: SAVE_I	save	%r18, 0x0001, %r27
hwintr_0_373:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_373), 16, 16)) -> intp(0, 0, 1e)
hwintr_0_374:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_374), 16, 16)) -> intp(0, 0, 2f)
	.word 0xb1500000  ! 8052: RDPR_TPC	<illegal instruction>
	.word 0xbfe5a0a6  ! 8053: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb9500000  ! 8054: RDPR_TPC	<illegal instruction>
	.word 0xbc85e1c7  ! 8055: ADDcc_I	addcc 	%r23, 0x01c7, %r30
	.word 0xb1e560cc  ! 8056: SAVE_I	save	%r21, 0x0001, %r24
	ta	T_CHANGE_HPRIV
T0_spu_op_28:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x20b, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xb5e4e105  ! 8060: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xbbe5205b  ! 8062: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xbfe5a139  ! 8063: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb7e4e074  ! 8066: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xbbe521e8  ! 8068: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xb151c000  ! 8072: RDPR_TL	<illegal instruction>
	.word 0xb7e5a1b9  ! 8075: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xbde4a111  ! 8076: SAVE_I	save	%r18, 0x0001, %r30
hwintr_0_375:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_375), 16, 16)) -> intp(0, 0, 3c)
	.word 0xb1e560ba  ! 8081: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb1e5a091  ! 8083: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb9e4e142  ! 8085: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xbc348000  ! 8090: ORN_R	orn 	%r18, %r0, %r30
hwintr_0_376:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_376), 16, 16)) -> intp(0, 0, 20)
	.word 0xb7e5a005  ! 8095: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb5e561f8  ! 8096: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb5e5a16f  ! 8097: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xbec461a0  ! 8101: ADDCcc_I	addccc 	%r17, 0x01a0, %r31
	.word 0xbde42126  ! 8104: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xb7520000  ! 8108: RDPR_PIL	<illegal instruction>
hwintr_0_377:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_377), 16, 16)) -> intp(0, 0, 3f)
	.word 0xb7540000  ! 8116: RDPR_GL	<illegal instruction>
	.word 0x8595a037  ! 8117: WRPR_TSTATE_I	wrpr	%r22, 0x0037, %tstate
	.word 0xbfe42150  ! 8118: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xb4ade1a4  ! 8119: ANDNcc_I	andncc 	%r23, 0x01a4, %r26
	.word 0xbbe460cd  ! 8120: SAVE_I	save	%r17, 0x0001, %r29
hwintr_0_378:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_378), 16, 16)) -> intp(0, 0, 2c)
hwintr_0_379:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_379), 16, 16)) -> intp(0, 0, 2)
	.word 0xbfe4a0fb  ! 8123: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb5e5e15b  ! 8124: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xb5508000  ! 8126: RDPR_TSTATE	<illegal instruction>
	.word 0xb0b54000  ! 8131: ORNcc_R	orncc 	%r21, %r0, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982cdb  ! 8135: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0cdb, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81982f13  ! 8137: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f13, %hpstate
	.word 0xbde5e0b2  ! 8142: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xbf500000  ! 8146: RDPR_TPC	<illegal instruction>
	.word 0xb4158000  ! 8148: OR_R	or 	%r22, %r0, %r26
	.word 0xb1e4613a  ! 8153: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbde4217e  ! 8155: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xb1e5618f  ! 8156: SAVE_I	save	%r21, 0x0001, %r24
hwintr_0_380:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_380), 16, 16)) -> intp(0, 0, 1c)
	.word 0xb1e4a0ec  ! 8160: SAVE_I	save	%r18, 0x0001, %r24
hwintr_0_381:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_381), 16, 16)) -> intp(0, 0, f)
	.word 0xb7e5a0da  ! 8165: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb7e5a166  ! 8166: SAVE_I	save	%r22, 0x0001, %r27
hwintr_0_382:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_382), 16, 16)) -> intp(0, 0, 3)
	.word 0xb1508000  ! 8169: RDPR_TSTATE	<illegal instruction>
	.word 0xb3e5a106  ! 8172: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb9e4e007  ! 8175: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb3e520f0  ! 8176: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb7e4e00e  ! 8177: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb5e5e037  ! 8179: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xb7e52146  ! 8181: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xbbe4a1e3  ! 8184: SAVE_I	save	%r18, 0x0001, %r29
	.word 0x839520a2  ! 8185: WRPR_TNPC_I	wrpr	%r20, 0x00a2, %tnpc
	.word 0xbd518000  ! 8188: RDPR_PSTATE	<illegal instruction>
	.word 0xb895a064  ! 8189: ORcc_I	orcc 	%r22, 0x0064, %r28
	.word 0xb1e5e0b4  ! 8190: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb3e520e1  ! 8192: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb5e4e00d  ! 8195: SAVE_I	save	%r19, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81982c59  ! 8201: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c59, %hpstate
	.word 0xb7e4a07f  ! 8202: SAVE_I	save	%r18, 0x0001, %r27
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xbde420e2  ! 8204: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xbbe4a0f6  ! 8207: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xbfe5e150  ! 8212: SAVE_I	save	%r23, 0x0001, %r31
hwintr_0_383:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_383), 16, 16)) -> intp(0, 0, 2c)
	.word 0x89942104  ! 8217: WRPR_TICK_I	wrpr	%r16, 0x0104, %tick
	.word 0xbde4a00d  ! 8219: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xbbe42061  ! 8220: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb0246170  ! 8222: SUB_I	sub 	%r17, 0x0170, %r24
	.word 0x8795e04b  ! 8223: WRPR_TT_I	wrpr	%r23, 0x004b, %tt
hwintr_0_384:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_384), 16, 16)) -> intp(0, 0, 36)
	.word 0xb5e4a151  ! 8226: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbbe460a8  ! 8227: SAVE_I	save	%r17, 0x0001, %r29
	.word 0xb5e56005  ! 8229: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xbb518000  ! 8233: RDPR_PSTATE	<illegal instruction>
	.word 0xb550c000  ! 8235: RDPR_TT	<illegal instruction>
hwintr_0_385:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_385), 16, 16)) -> intp(0, 0, 2)
	.word 0x8194e031  ! 8240: WRPR_TPC_I	wrpr	%r19, 0x0031, %tpc
	.word 0xbebdc000  ! 8241: XNORcc_R	xnorcc 	%r23, %r0, %r31
	.word 0xb3540000  ! 8246: RDPR_GL	<illegal instruction>
	.word 0xbb504000  ! 8250: RDPR_TNPC	<illegal instruction>
	.word 0xb3e52063  ! 8255: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb3540000  ! 8257: RDPR_GL	<illegal instruction>
	.word 0xbde4e189  ! 8258: SAVE_I	save	%r19, 0x0001, %r30
	ta	T_CHANGE_HPRIV
	.word 0x81983b4b  ! 8263: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b4b, %hpstate
	.word 0x8d95a171  ! 8265: WRPR_PSTATE_I	wrpr	%r22, 0x0171, %pstate
	.word 0xbde461cc  ! 8270: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xbfe420eb  ! 8272: SAVE_I	save	%r16, 0x0001, %r31
	.word 0x8d95e1ca  ! 8274: WRPR_PSTATE_I	wrpr	%r23, 0x01ca, %pstate
	.word 0xb3510000  ! 8281: RDPR_TICK	<illegal instruction>
	.word 0xb9e5e1e9  ! 8282: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xb3e5a0ef  ! 8283: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb3e5e147  ! 8286: SAVE_I	save	%r23, 0x0001, %r25
	.word 0x85952103  ! 8287: WRPR_TSTATE_I	wrpr	%r20, 0x0103, %tstate
hwintr_0_386:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_386), 16, 16)) -> intp(0, 0, 1e)
	.word 0xbd504000  ! 8292: RDPR_TNPC	<illegal instruction>
	.word 0xbde561e1  ! 8297: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xbbe5a0d1  ! 8301: SAVE_I	save	%r22, 0x0001, %r29
hwintr_0_387:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_387), 16, 16)) -> intp(0, 0, 8)
	.word 0xbfe4a03f  ! 8308: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbc35c000  ! 8312: ORN_R	orn 	%r23, %r0, %r30
hwintr_0_388:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_388), 16, 16)) -> intp(0, 0, e)
	.word 0xbfe56082  ! 8315: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xb53c5000  ! 8316: SRAX_R	srax	%r17, %r0, %r26
	.word 0xb9e4e08e  ! 8318: SAVE_I	save	%r19, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81983843  ! 8319: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1843, %hpstate
	.word 0xb5e52184  ! 8324: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb1e460f9  ! 8325: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xb9480000  ! 8328: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982e4b  ! 8329: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e4b, %hpstate
	.word 0xb3e42033  ! 8335: SAVE_I	save	%r16, 0x0001, %r25
hwintr_0_389:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_389), 16, 16)) -> intp(0, 0, 10)
	.word 0xbbe4a159  ! 8341: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xbde5a09a  ! 8342: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xb404a161  ! 8346: ADD_I	add 	%r18, 0x0161, %r26
	.word 0xb9e46153  ! 8347: SAVE_I	save	%r17, 0x0001, %r28
	.word 0x899560c3  ! 8348: WRPR_TICK_I	wrpr	%r21, 0x00c3, %tick
	.word 0xb12cb001  ! 8354: SLLX_I	sllx	%r18, 0x0001, %r24
	.word 0x8195e0b6  ! 8356: WRPR_TPC_I	wrpr	%r23, 0x00b6, %tpc
	.word 0xb0b520a5  ! 8358: SUBCcc_I	orncc 	%r20, 0x00a5, %r24
hwintr_0_390:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_390), 16, 16)) -> intp(0, 0, 2a)
	.word 0x9194608f  ! 8362: WRPR_PIL_I	wrpr	%r17, 0x008f, %pil
hwintr_0_391:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_391), 16, 16)) -> intp(0, 0, 36)
hwintr_0_392:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_392), 16, 16)) -> intp(0, 0, 2b)
	.word 0xb1e4605c  ! 8369: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbb510000  ! 8371: RDPR_TICK	<illegal instruction>
	.word 0xb7e4e09f  ! 8379: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb350c000  ! 8380: RDPR_TT	<illegal instruction>
	.word 0xbfe5e078  ! 8381: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xbf510000  ! 8384: RDPR_TICK	<illegal instruction>
hwintr_0_393:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_393), 16, 16)) -> intp(0, 0, 19)
	.word 0xb5e52145  ! 8389: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb9e4a003  ! 8391: SAVE_I	save	%r18, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81983e1b  ! 8392: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e1b, %hpstate
	.word 0xb52c3001  ! 8393: SLLX_I	sllx	%r16, 0x0001, %r26
	mov	2, %r12
	.word 0x8f932000  ! 8395: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbfe521b2  ! 8399: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xb2352019  ! 8401: SUBC_I	orn 	%r20, 0x0019, %r25
	.word 0xb5480000  ! 8402: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xbde560ab  ! 8404: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xbbe46025  ! 8409: SAVE_I	save	%r17, 0x0001, %r29
hwintr_0_394:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_394), 16, 16)) -> intp(0, 0, 11)
	.word 0xb5e4e12d  ! 8416: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xbde52005  ! 8419: SAVE_I	save	%r20, 0x0001, %r30
hwintr_0_395:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_395), 16, 16)) -> intp(0, 0, 16)
	.word 0xb9e520f0  ! 8421: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb92cf001  ! 8422: SLLX_I	sllx	%r19, 0x0001, %r28
	.word 0xb3e5602b  ! 8423: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xb5e421d7  ! 8425: SAVE_I	save	%r16, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81983d53  ! 8427: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d53, %hpstate
	.word 0xb7504000  ! 8430: RDPR_TNPC	<illegal instruction>
	.word 0xb7508000  ! 8431: RDPR_TSTATE	<illegal instruction>
hwintr_0_396:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_396), 16, 16)) -> intp(0, 0, 1c)
hwintr_0_397:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_397), 16, 16)) -> intp(0, 0, 1f)
	.word 0xb3e46042  ! 8442: SAVE_I	save	%r17, 0x0001, %r25
	.word 0x8194600e  ! 8443: WRPR_TPC_I	wrpr	%r17, 0x000e, %tpc
	mov	2, %r14
	.word 0xa193a000  ! 8444: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb5540000  ! 8445: RDPR_GL	<illegal instruction>
	.word 0xb7e5a0dc  ! 8447: SAVE_I	save	%r22, 0x0001, %r27
	.word 0x8195603e  ! 8449: WRPR_TPC_I	wrpr	%r21, 0x003e, %tpc
	.word 0xb5e4a17b  ! 8450: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb3e42069  ! 8451: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xbb520000  ! 8454: RDPR_PIL	<illegal instruction>
	.word 0xb3540000  ! 8455: RDPR_GL	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x819838d9  ! 8457: WRHPR_HPSTATE_I	wrhpr	%r0, 0x18d9, %hpstate
	.word 0x8994608a  ! 8462: WRPR_TICK_I	wrpr	%r17, 0x008a, %tick
	.word 0xb9e5e14d  ! 8465: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbbe5a1d6  ! 8468: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb13d3001  ! 8474: SRAX_I	srax	%r20, 0x0001, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982f83  ! 8477: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f83, %hpstate
	.word 0xb9e4a0a6  ! 8482: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xbd520000  ! 8483: RDPR_PIL	<illegal instruction>
	.word 0xb7e46169  ! 8485: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xb3e5a159  ! 8491: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xbde5605b  ! 8492: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb9e420fe  ! 8493: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xb5e56031  ! 8494: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xbc94c000  ! 8498: ORcc_R	orcc 	%r19, %r0, %r30
	ta	T_CHANGE_HPRIV
T0_spu_op_29:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0xa0b, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0x85946108  ! 8504: WRPR_TSTATE_I	wrpr	%r17, 0x0108, %tstate
	.word 0xbfe4e080  ! 8508: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb7e5a1d4  ! 8509: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xbde520a5  ! 8511: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xb3e5e1d1  ! 8513: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb5518000  ! 8514: RDPR_PSTATE	<illegal instruction>
	.word 0xbde461e2  ! 8517: SAVE_I	save	%r17, 0x0001, %r30
hwintr_0_398:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_398), 16, 16)) -> intp(0, 0, 3a)
	.word 0xbd349000  ! 8520: SRLX_R	srlx	%r18, %r0, %r30
hwintr_0_399:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_399), 16, 16)) -> intp(0, 0, 0)
	.word 0xb7e5a04a  ! 8525: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xbf51c000  ! 8526: RDPR_TL	<illegal instruction>
	.word 0xbbe4a021  ! 8528: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xb7e5e1b3  ! 8529: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xbde4216a  ! 8531: SAVE_I	save	%r16, 0x0001, %r30
hwintr_0_400:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_400), 16, 16)) -> intp(0, 0, 19)
hwintr_0_401:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_401), 16, 16)) -> intp(0, 0, 29)
hwintr_0_402:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_402), 16, 16)) -> intp(0, 0, 3e)
	.word 0xbe254000  ! 8539: SUB_R	sub 	%r21, %r0, %r31
	.word 0x8194e0ad  ! 8540: WRPR_TPC_I	wrpr	%r19, 0x00ad, %tpc
hwintr_0_403:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_403), 16, 16)) -> intp(0, 0, 11)
hwintr_0_404:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_404), 16, 16)) -> intp(0, 0, 6)
	.word 0xb1643801  ! 8549: MOVcc_I	<illegal instruction>
	ta	T_CHANGE_HPRIV
T0_spu_op_30:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0xa41, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xb1e52082  ! 8556: SAVE_I	save	%r20, 0x0001, %r24
hwintr_0_405:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_405), 16, 16)) -> intp(0, 0, 3f)
	.word 0xb9e4e178  ! 8560: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb1643801  ! 8562: MOVcc_I	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81983fd1  ! 8566: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1fd1, %hpstate
	.word 0xb1e5e11a  ! 8568: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xbab4e141  ! 8572: ORNcc_I	orncc 	%r19, 0x0141, %r29
	.word 0x9194e13a  ! 8575: WRPR_PIL_I	wrpr	%r19, 0x013a, %pil
	.word 0xb5e4606c  ! 8576: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb7e4a19f  ! 8579: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xb3e46136  ! 8581: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xb3520000  ! 8585: RDPR_PIL	<illegal instruction>
	.word 0xb7e4e1fe  ! 8589: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb951c000  ! 8593: RDPR_TL	<illegal instruction>
	.word 0xb1518000  ! 8596: RDPR_PSTATE	<illegal instruction>
	.word 0xb9e460ce  ! 8598: SAVE_I	save	%r17, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xbbe4a121  ! 8606: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xb7540000  ! 8607: RDPR_GL	<illegal instruction>
	.word 0x859521c5  ! 8610: WRPR_TSTATE_I	wrpr	%r20, 0x01c5, %tstate
	.word 0xbbe5a19b  ! 8613: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb9e521b0  ! 8616: SAVE_I	save	%r20, 0x0001, %r28
hwintr_0_406:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_406), 16, 16)) -> intp(0, 0, 25)
	.word 0xbbe5e04f  ! 8618: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbd518000  ! 8620: RDPR_PSTATE	<illegal instruction>
	.word 0xb72cf001  ! 8623: SLLX_I	sllx	%r19, 0x0001, %r27
	.word 0xbde4a0b5  ! 8627: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xbfe4e107  ! 8630: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb3518000  ! 8634: RDPR_PSTATE	<illegal instruction>
	mov	2, %r12
	.word 0x8f932000  ! 8635: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb6256031  ! 8636: SUB_I	sub 	%r21, 0x0031, %r27
	.word 0xbb520000  ! 8638: RDPR_PIL	<illegal instruction>
hwintr_0_407:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_407), 16, 16)) -> intp(0, 0, 3f)
	.word 0x899420c7  ! 8641: WRPR_TICK_I	wrpr	%r16, 0x00c7, %tick
	.word 0xbde5e02d  ! 8648: SAVE_I	save	%r23, 0x0001, %r30
hwintr_0_408:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_408), 16, 16)) -> intp(0, 0, 2)
	.word 0xb3e5e04a  ! 8659: SAVE_I	save	%r23, 0x0001, %r25
hwintr_0_409:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_409), 16, 16)) -> intp(0, 0, 39)
	.word 0xb5e5a17f  ! 8663: SAVE_I	save	%r22, 0x0001, %r26
hwintr_0_410:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_410), 16, 16)) -> intp(0, 0, 3b)
	.word 0xbfe561dc  ! 8668: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xb3e520f1  ! 8669: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xbbe460c1  ! 8672: SAVE_I	save	%r17, 0x0001, %r29
	.word 0x9195e187  ! 8676: WRPR_PIL_I	wrpr	%r23, 0x0187, %pil
	.word 0xb5e46138  ! 8680: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xbca4e043  ! 8681: SUBcc_I	subcc 	%r19, 0x0043, %r30
	.word 0xbaa52068  ! 8685: SUBcc_I	subcc 	%r20, 0x0068, %r29
	.word 0xb5e460be  ! 8688: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb5e4e035  ! 8689: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xb5500000  ! 8690: RDPR_TPC	<illegal instruction>
hwintr_0_411:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_411), 16, 16)) -> intp(0, 0, 2b)
	.word 0xb9e520fc  ! 8696: SAVE_I	save	%r20, 0x0001, %r28
	.word 0xb1e5e1cd  ! 8698: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb3e5a121  ! 8699: SAVE_I	save	%r22, 0x0001, %r25
	.word 0x8995a16e  ! 8703: WRPR_TICK_I	wrpr	%r22, 0x016e, %tick
	.word 0xb69d217d  ! 8704: XORcc_I	xorcc 	%r20, 0x017d, %r27
	.word 0xb09cc000  ! 8705: XORcc_R	xorcc 	%r19, %r0, %r24
	.word 0xbbe5611a  ! 8706: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xbf2d3001  ! 8707: SLLX_I	sllx	%r20, 0x0001, %r31
	.word 0xbfe56007  ! 8708: SAVE_I	save	%r21, 0x0001, %r31
hwintr_0_412:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_412), 16, 16)) -> intp(0, 0, b)
	.word 0xb32c2001  ! 8711: SLL_I	sll 	%r16, 0x0001, %r25
	.word 0xbde5e1b0  ! 8714: SAVE_I	save	%r23, 0x0001, %r30
hwintr_0_413:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_413), 16, 16)) -> intp(0, 0, 25)
	mov	2, %r14
	.word 0xa193a000  ! 8718: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb1540000  ! 8719: RDPR_GL	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81983e49  ! 8721: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e49, %hpstate
	.word 0xbcb521f1  ! 8723: ORNcc_I	orncc 	%r20, 0x01f1, %r30
	.word 0xbbe5a125  ! 8728: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb9e4e0d5  ! 8729: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb3e4e14f  ! 8731: SAVE_I	save	%r19, 0x0001, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81983a01  ! 8732: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a01, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81982983  ! 8734: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0983, %hpstate
	.word 0xb9e4e1a7  ! 8737: SAVE_I	save	%r19, 0x0001, %r28
hwintr_0_414:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_414), 16, 16)) -> intp(0, 0, 3e)
	.word 0xb9e4e0c3  ! 8741: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb9e5a1a3  ! 8743: SAVE_I	save	%r22, 0x0001, %r28
	.word 0x85946030  ! 8744: WRPR_TSTATE_I	wrpr	%r17, 0x0030, %tstate
	.word 0xb7e4a0ba  ! 8745: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xb7520000  ! 8746: RDPR_PIL	<illegal instruction>
	.word 0x859420f7  ! 8747: WRPR_TSTATE_I	wrpr	%r16, 0x00f7, %tstate
	.word 0xb1e520ee  ! 8748: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb3480000  ! 8750: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xb5e4a118  ! 8752: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbbe461a2  ! 8753: SAVE_I	save	%r17, 0x0001, %r29
	mov	1, %r14
	.word 0xa193a000  ! 8754: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb2454000  ! 8755: ADDC_R	addc 	%r21, %r0, %r25
	.word 0xb351c000  ! 8756: RDPR_TL	<illegal instruction>
	.word 0xbfe5a0bf  ! 8757: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xbfe5e142  ! 8761: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xb4044000  ! 8762: ADD_R	add 	%r17, %r0, %r26
	.word 0xbfe5213c  ! 8764: SAVE_I	save	%r20, 0x0001, %r31
hwintr_0_415:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_415), 16, 16)) -> intp(0, 0, 1c)
	.word 0x87946106  ! 8767: WRPR_TT_I	wrpr	%r17, 0x0106, %tt
	.word 0xb494a057  ! 8770: ORcc_I	orcc 	%r18, 0x0057, %r26
	.word 0xb20d4000  ! 8771: AND_R	and 	%r21, %r0, %r25
	.word 0xb9e4e0ca  ! 8773: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb9e4e185  ! 8774: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb7508000  ! 8780: RDPR_TSTATE	<illegal instruction>
	.word 0xb7e4215b  ! 8782: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xbfe5a1cb  ! 8784: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb9e46036  ! 8785: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xb3e560d7  ! 8789: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xb9e5a0cd  ! 8793: SAVE_I	save	%r22, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982919  ! 8794: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0919, %hpstate
	.word 0xbfe4a1ae  ! 8795: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb934c000  ! 8796: SRL_R	srl 	%r19, %r0, %r28
	.word 0xb69c4000  ! 8798: XORcc_R	xorcc 	%r17, %r0, %r27
	.word 0xb1e460ed  ! 8800: SAVE_I	save	%r17, 0x0001, %r24
hwintr_0_416:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_416), 16, 16)) -> intp(0, 0, 32)
	.word 0xbde4e1ff  ! 8806: SAVE_I	save	%r19, 0x0001, %r30
	.word 0xb3e5a03e  ! 8809: SAVE_I	save	%r22, 0x0001, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81983891  ! 8814: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1891, %hpstate
	.word 0xb2c4c000  ! 8816: ADDCcc_R	addccc 	%r19, %r0, %r25
	.word 0xbc0d4000  ! 8820: AND_R	and 	%r21, %r0, %r30
	.word 0xb7e521ca  ! 8823: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xb9e5e09c  ! 8826: SAVE_I	save	%r23, 0x0001, %r28
	.word 0x81942114  ! 8828: WRPR_TPC_I	wrpr	%r16, 0x0114, %tpc
	ta	T_CHANGE_HPRIV
	.word 0x81982a49  ! 8829: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a49, %hpstate
	.word 0xb5e5e0f9  ! 8832: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xbd510000  ! 8833: RDPR_TICK	<illegal instruction>
	.word 0xb1e5214e  ! 8836: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb5e4e0fb  ! 8840: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xb3e4a0bc  ! 8841: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xb3e46058  ! 8843: SAVE_I	save	%r17, 0x0001, %r25
	.word 0xba84c000  ! 8844: ADDcc_R	addcc 	%r19, %r0, %r29
	.word 0xbf504000  ! 8845: RDPR_TNPC	<illegal instruction>
	.word 0x8594205c  ! 8847: WRPR_TSTATE_I	wrpr	%r16, 0x005c, %tstate
	.word 0xbbe56004  ! 8853: SAVE_I	save	%r21, 0x0001, %r29
hwintr_0_417:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_417), 16, 16)) -> intp(0, 0, 2c)
	mov	2, %r12
	.word 0x8f932000  ! 8858: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb1e4a0e9  ! 8860: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xbfe4610c  ! 8862: SAVE_I	save	%r17, 0x0001, %r31
	.word 0xb1518000  ! 8863: RDPR_PSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81983b51  ! 8864: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b51, %hpstate
	.word 0xb1e4e099  ! 8866: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb7e5e04d  ! 8869: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xbbe5e004  ! 8874: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb3e4a1e0  ! 8876: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xba25c000  ! 8878: SUB_R	sub 	%r23, %r0, %r29
	.word 0xb5e4e0b8  ! 8880: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xb1e461db  ! 8881: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xba0da0d6  ! 8884: AND_I	and 	%r22, 0x00d6, %r29
	.word 0xbf352001  ! 8886: SRL_I	srl 	%r20, 0x0001, %r31
	.word 0xb1e42111  ! 8889: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xbfe420b2  ! 8909: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xbfe5a111  ! 8914: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb1e560d9  ! 8916: SAVE_I	save	%r21, 0x0001, %r24
hwintr_0_418:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_418), 16, 16)) -> intp(0, 0, 17)
	.word 0xb1e56186  ! 8921: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xbde52002  ! 8922: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xb9e5a033  ! 8923: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xb9e5a10d  ! 8924: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xb150c000  ! 8925: RDPR_TT	<illegal instruction>
	.word 0xb9e4e08c  ! 8929: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xb1e421b1  ! 8930: SAVE_I	save	%r16, 0x0001, %r24
	.word 0x839560e9  ! 8931: WRPR_TNPC_I	wrpr	%r21, 0x00e9, %tnpc
	.word 0xb9e521c4  ! 8937: SAVE_I	save	%r20, 0x0001, %r28
hwintr_0_419:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_419), 16, 16)) -> intp(0, 0, 3f)
	.word 0xb1e4a0b9  ! 8939: SAVE_I	save	%r18, 0x0001, %r24
hwintr_0_420:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_420), 16, 16)) -> intp(0, 0, f)
hwintr_0_421:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_421), 16, 16)) -> intp(0, 0, 7)
	.word 0xb9e5e107  ! 8948: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbfe5203c  ! 8949: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xbde4a097  ! 8951: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb40ca080  ! 8952: AND_I	and 	%r18, 0x0080, %r26
	.word 0xb834e08b  ! 8956: SUBC_I	orn 	%r19, 0x008b, %r28
	.word 0xb5e4e168  ! 8962: SAVE_I	save	%r19, 0x0001, %r26
	.word 0xbde5a032  ! 8964: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xb3e5a0ab  ! 8966: SAVE_I	save	%r22, 0x0001, %r25
hwintr_0_422:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_422), 16, 16)) -> intp(0, 0, 1b)
	.word 0xb9e5e0b4  ! 8974: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbf343001  ! 8977: SRLX_I	srlx	%r16, 0x0001, %r31
	.word 0xbbe421dc  ! 8978: SAVE_I	save	%r16, 0x0001, %r29
hwintr_0_423:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_423), 16, 16)) -> intp(0, 0, 34)
	.word 0xbbe56021  ! 8983: SAVE_I	save	%r21, 0x0001, %r29
	.word 0x8394a00c  ! 8984: WRPR_TNPC_I	wrpr	%r18, 0x000c, %tnpc
	.word 0xbde4e06b  ! 8986: SAVE_I	save	%r19, 0x0001, %r30
	.word 0xb5e4207d  ! 8987: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xb5480000  ! 8988: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81982d49  ! 8992: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d49, %hpstate
	.word 0xb20d0000  ! 8993: AND_R	and 	%r20, %r0, %r25
	.word 0xbbe520f8  ! 8996: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xb9518000  ! 9001: RDPR_PSTATE	<illegal instruction>
hwintr_0_424:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_424), 16, 16)) -> intp(0, 0, 16)
	.word 0xbde461dc  ! 9005: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb1e4e032  ! 9006: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbfe5a11e  ! 9007: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb7e5e15b  ! 9008: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xbb3d7001  ! 9010: SRAX_I	srax	%r21, 0x0001, %r29
	.word 0xb835c000  ! 9015: SUBC_R	orn 	%r23, %r0, %r28
	.word 0xb7e5a06e  ! 9017: SAVE_I	save	%r22, 0x0001, %r27
	.word 0xb5480000  ! 9019: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xb9e4a065  ! 9021: SAVE_I	save	%r18, 0x0001, %r28
	ta	T_CHANGE_HPRIV
T0_spu_op_31:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a03, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xbabca199  ! 9024: XNORcc_I	xnorcc 	%r18, 0x0199, %r29
	.word 0xb1518000  ! 9028: RDPR_PSTATE	<illegal instruction>
	.word 0xb7e5e023  ! 9034: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xb614a1dd  ! 9037: OR_I	or 	%r18, 0x01dd, %r27
	.word 0xb7e5211e  ! 9038: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xbfe5a180  ! 9044: SAVE_I	save	%r22, 0x0001, %r31
	.word 0xb1e5a067  ! 9045: SAVE_I	save	%r22, 0x0001, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81983899  ! 9051: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1899, %hpstate
	.word 0xbd510000  ! 9057: RDPR_TICK	<illegal instruction>
	mov	2, %r14
	.word 0xa193a000  ! 9059: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb350c000  ! 9063: RDPR_TT	<illegal instruction>
	.word 0xbfe5e173  ! 9064: SAVE_I	save	%r23, 0x0001, %r31
hwintr_0_425:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_425), 16, 16)) -> intp(0, 0, 29)
hwintr_0_426:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_426), 16, 16)) -> intp(0, 0, 1c)
	.word 0xb7e46114  ! 9072: SAVE_I	save	%r17, 0x0001, %r27
hwintr_0_427:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_427), 16, 16)) -> intp(0, 0, 0)
	.word 0xb9e461d5  ! 9074: SAVE_I	save	%r17, 0x0001, %r28
	.word 0x85946085  ! 9077: WRPR_TSTATE_I	wrpr	%r17, 0x0085, %tstate
	.word 0x91946082  ! 9078: WRPR_PIL_I	wrpr	%r17, 0x0082, %pil
	.word 0x8595e1ab  ! 9079: WRPR_TSTATE_I	wrpr	%r23, 0x01ab, %tstate
	.word 0xbf480000  ! 9080: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0x9195e0a7  ! 9083: WRPR_PIL_I	wrpr	%r23, 0x00a7, %pil
	.word 0xbfe4e013  ! 9093: SAVE_I	save	%r19, 0x0001, %r31
	.word 0xb7e42138  ! 9096: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb815e198  ! 9097: OR_I	or 	%r23, 0x0198, %r28
	.word 0xbcb48000  ! 9098: SUBCcc_R	orncc 	%r18, %r0, %r30
	.word 0xb1e5200f  ! 9099: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb7346001  ! 9100: SRL_I	srl 	%r17, 0x0001, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81983c89  ! 9101: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c89, %hpstate
	.word 0xb7e561e7  ! 9105: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xbf643801  ! 9110: MOVcc_I	<illegal instruction>
	.word 0xb62d4000  ! 9113: ANDN_R	andn 	%r21, %r0, %r27
	.word 0xb1e4e194  ! 9119: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb3e42138  ! 9120: SAVE_I	save	%r16, 0x0001, %r25
	.word 0x8795e08e  ! 9121: WRPR_TT_I	wrpr	%r23, 0x008e, %tt
	.word 0xbd500000  ! 9122: RDPR_TPC	<illegal instruction>
	.word 0xbf520000  ! 9125: RDPR_PIL	<illegal instruction>
hwintr_0_428:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_428), 16, 16)) -> intp(0, 0, 32)
	.word 0x859521ef  ! 9131: WRPR_TSTATE_I	wrpr	%r20, 0x01ef, %tstate
	.word 0xb7e461dd  ! 9132: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xbde4202a  ! 9134: SAVE_I	save	%r16, 0x0001, %r30
hwintr_0_429:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_429), 16, 16)) -> intp(0, 0, 38)
	.word 0xb3e4a13a  ! 9137: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xb950c000  ! 9141: RDPR_TT	<illegal instruction>
hwintr_0_430:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_430), 16, 16)) -> intp(0, 0, 3e)
	.word 0xbc24e114  ! 9143: SUB_I	sub 	%r19, 0x0114, %r30
	.word 0xbfe560f9  ! 9145: SAVE_I	save	%r21, 0x0001, %r31
hwintr_0_431:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_431), 16, 16)) -> intp(0, 0, 31)
	.word 0xb3e5e0ab  ! 9149: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb5e560ea  ! 9155: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb0bd618f  ! 9156: XNORcc_I	xnorcc 	%r21, 0x018f, %r24
	.word 0xb7e561b8  ! 9159: SAVE_I	save	%r21, 0x0001, %r27
	.word 0xb935c000  ! 9164: SRL_R	srl 	%r23, %r0, %r28
	.word 0xbb3da001  ! 9166: SRA_I	sra 	%r22, 0x0001, %r29
	.word 0xbfe5e00c  ! 9167: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xbbe420c5  ! 9170: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xbeb48000  ! 9172: SUBCcc_R	orncc 	%r18, %r0, %r31
	.word 0xb3e4a14d  ! 9177: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xb9520000  ! 9178: RDPR_PIL	<illegal instruction>
	.word 0xb92cb001  ! 9181: SLLX_I	sllx	%r18, 0x0001, %r28
	.word 0xbbe5e0d2  ! 9183: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb1e46131  ! 9184: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbe054000  ! 9185: ADD_R	add 	%r21, %r0, %r31
	.word 0xbca4a1a4  ! 9187: SUBcc_I	subcc 	%r18, 0x01a4, %r30
	.word 0xbbe5a09a  ! 9190: SAVE_I	save	%r22, 0x0001, %r29
hwintr_0_432:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_432), 16, 16)) -> intp(0, 0, 36)
	.word 0xb1e4219f  ! 9196: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xb72d4000  ! 9202: SLL_R	sll 	%r21, %r0, %r27
	.word 0xbbe421f2  ! 9205: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xbabd2052  ! 9206: XNORcc_I	xnorcc 	%r20, 0x0052, %r29
	.word 0xbbe4a06f  ! 9208: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xb635a195  ! 9209: SUBC_I	orn 	%r22, 0x0195, %r27
	.word 0xbd50c000  ! 9210: RDPR_TT	<illegal instruction>
	.word 0xb3e52112  ! 9211: SAVE_I	save	%r20, 0x0001, %r25
	.word 0x8995e144  ! 9215: WRPR_TICK_I	wrpr	%r23, 0x0144, %tick
	.word 0xbbe4a10e  ! 9217: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xbfe5203c  ! 9219: SAVE_I	save	%r20, 0x0001, %r31
	.word 0xb1e5a008  ! 9222: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb9504000  ! 9223: RDPR_TNPC	<illegal instruction>
	.word 0xbbe5e07e  ! 9227: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbc358000  ! 9229: ORN_R	orn 	%r22, %r0, %r30
	.word 0xb7518000  ! 9232: RDPR_PSTATE	<illegal instruction>
	.word 0xbe450000  ! 9233: ADDC_R	addc 	%r20, %r0, %r31
	.word 0x91946143  ! 9237: WRPR_PIL_I	wrpr	%r17, 0x0143, %pil
	.word 0xb9e5a033  ! 9239: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xb5520000  ! 9241: RDPR_PIL	<illegal instruction>
	.word 0xb9e521da  ! 9242: SAVE_I	save	%r20, 0x0001, %r28
	.word 0x91946185  ! 9244: WRPR_PIL_I	wrpr	%r17, 0x0185, %pil
	.word 0xbfe52093  ! 9245: SAVE_I	save	%r20, 0x0001, %r31
	.word 0x8594e1dd  ! 9250: WRPR_TSTATE_I	wrpr	%r19, 0x01dd, %tstate
	.word 0xb5e5a009  ! 9252: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xb3e560c8  ! 9254: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xb9e4e16c  ! 9256: SAVE_I	save	%r19, 0x0001, %r28
hwintr_0_433:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_433), 16, 16)) -> intp(0, 0, 3b)
	.word 0xbd480000  ! 9259: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xb3e56006  ! 9261: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xb5e4a071  ! 9265: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xbde4e022  ! 9267: SAVE_I	save	%r19, 0x0001, %r30
hwintr_0_434:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_434), 16, 16)) -> intp(0, 0, 39)
	.word 0x919461e4  ! 9271: WRPR_PIL_I	wrpr	%r17, 0x01e4, %pil
	.word 0xb37d6401  ! 9272: MOVR_I	movre	%r21, 0x1, %r25
	.word 0xb1e561a0  ! 9273: SAVE_I	save	%r21, 0x0001, %r24
	.word 0xb2442071  ! 9278: ADDC_I	addc 	%r16, 0x0071, %r25
	.word 0xb3e4212e  ! 9279: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xbde56115  ! 9282: SAVE_I	save	%r21, 0x0001, %r30
	ta	T_CHANGE_HPRIV
	.word 0x81983c49  ! 9288: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c49, %hpstate
	.word 0xb21da18e  ! 9290: XOR_I	xor 	%r22, 0x018e, %r25
	.word 0xb5e5e0e3  ! 9292: SAVE_I	save	%r23, 0x0001, %r26
	.word 0x89942014  ! 9294: WRPR_TICK_I	wrpr	%r16, 0x0014, %tick
	.word 0xb7e4600d  ! 9295: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xb6c4e1ce  ! 9296: ADDCcc_I	addccc 	%r19, 0x01ce, %r27
	.word 0xb5e4608b  ! 9297: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb1508000  ! 9302: RDPR_TSTATE	<illegal instruction>
	.word 0xb1e4216a  ! 9306: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xb7510000  ! 9308: RDPR_TICK	<illegal instruction>
hwintr_0_435:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_435), 16, 16)) -> intp(0, 0, 25)
	.word 0xbbe4a041  ! 9314: SAVE_I	save	%r18, 0x0001, %r29
	.word 0xb3e52089  ! 9315: SAVE_I	save	%r20, 0x0001, %r25
	.word 0xb1e460ec  ! 9320: SAVE_I	save	%r17, 0x0001, %r24
	.word 0x9194218e  ! 9321: WRPR_PIL_I	wrpr	%r16, 0x018e, %pil
	.word 0xbd504000  ! 9323: RDPR_TNPC	<illegal instruction>
	.word 0x919521ef  ! 9328: WRPR_PIL_I	wrpr	%r20, 0x01ef, %pil
	.word 0x919521e8  ! 9329: WRPR_PIL_I	wrpr	%r20, 0x01e8, %pil
	.word 0xbe0c6095  ! 9331: AND_I	and 	%r17, 0x0095, %r31
	mov	2, %r12
	.word 0x8f932000  ! 9334: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb3e5611d  ! 9336: SAVE_I	save	%r21, 0x0001, %r25
hwintr_0_436:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_436), 16, 16)) -> intp(0, 0, d)
	.word 0xb3e42037  ! 9341: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xbf500000  ! 9343: RDPR_TPC	<illegal instruction>
	.word 0xbb504000  ! 9345: RDPR_TNPC	<illegal instruction>
	.word 0xb1e5e03a  ! 9351: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xbbe5a135  ! 9358: SAVE_I	save	%r22, 0x0001, %r29
hwintr_0_437:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_437), 16, 16)) -> intp(0, 0, 1f)
	.word 0xb1e460a2  ! 9363: SAVE_I	save	%r17, 0x0001, %r24
	.word 0xbde5612d  ! 9366: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb7e46199  ! 9371: SAVE_I	save	%r17, 0x0001, %r27
	.word 0x8595a1f2  ! 9372: WRPR_TSTATE_I	wrpr	%r22, 0x01f2, %tstate
	.word 0xb150c000  ! 9374: RDPR_TT	<illegal instruction>
	.word 0xbde4a0f4  ! 9375: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xbfe5a1f4  ! 9379: SAVE_I	save	%r22, 0x0001, %r31
	mov	0, %r14
	.word 0xa193a000  ! 9382: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb5e5a1aa  ! 9384: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xbde5600f  ! 9386: SAVE_I	save	%r21, 0x0001, %r30
	.word 0xb7e4a1e9  ! 9387: SAVE_I	save	%r18, 0x0001, %r27
	.word 0xb7e5e198  ! 9389: SAVE_I	save	%r23, 0x0001, %r27
	mov	0, %r14
	.word 0xa193a000  ! 9390: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	mov	2, %r14
	.word 0xa193a000  ! 9392: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb3e56129  ! 9395: SAVE_I	save	%r21, 0x0001, %r25
	mov	0, %r14
	.word 0xa193a000  ! 9396: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb5520000  ! 9398: RDPR_PIL	<illegal instruction>
	.word 0xb3e4207e  ! 9399: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xbbe5e06d  ! 9400: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbde5e195  ! 9401: SAVE_I	save	%r23, 0x0001, %r30
hwintr_0_438:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_438), 16, 16)) -> intp(0, 0, 3e)
	.word 0xb1e5e06b  ! 9406: SAVE_I	save	%r23, 0x0001, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982d19  ! 9409: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d19, %hpstate
hwintr_0_439:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_439), 16, 16)) -> intp(0, 0, 12)
	.word 0xb9e46051  ! 9415: SAVE_I	save	%r17, 0x0001, %r28
hwintr_0_440:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_440), 16, 16)) -> intp(0, 0, 3c)
	.word 0xb5518000  ! 9419: RDPR_PSTATE	<illegal instruction>
	.word 0xba9ca00d  ! 9422: XORcc_I	xorcc 	%r18, 0x000d, %r29
	.word 0x8d94a069  ! 9423: WRPR_PSTATE_I	wrpr	%r18, 0x0069, %pstate
	.word 0xbd480000  ! 9424: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xbbe4e061  ! 9431: SAVE_I	save	%r19, 0x0001, %r29
	.word 0x8d95a12b  ! 9433: WRPR_PSTATE_I	wrpr	%r22, 0x012b, %pstate
	.word 0xb6448000  ! 9434: ADDC_R	addc 	%r18, %r0, %r27
	.word 0xb1e4202e  ! 9436: SAVE_I	save	%r16, 0x0001, %r24
	.word 0xbf480000  ! 9437: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xb350c000  ! 9438: RDPR_TT	<illegal instruction>
hwintr_0_441:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_441), 16, 16)) -> intp(0, 0, f)
	.word 0xb295e1a4  ! 9444: ORcc_I	orcc 	%r23, 0x01a4, %r25
	.word 0xbbe4216a  ! 9446: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xbbe4210a  ! 9447: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xb7510000  ! 9448: RDPR_TICK	<illegal instruction>
	.word 0xbb480000  ! 9449: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xb9e5a195  ! 9451: SAVE_I	save	%r22, 0x0001, %r28
hwintr_0_442:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_442), 16, 16)) -> intp(0, 0, 27)
	.word 0xb5e5a007  ! 9456: SAVE_I	save	%r22, 0x0001, %r26
	.word 0xbbe56133  ! 9458: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb9e420f8  ! 9459: SAVE_I	save	%r16, 0x0001, %r28
	.word 0xbbe5e006  ! 9461: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbf51c000  ! 9462: RDPR_TL	<illegal instruction>
	.word 0xbbe42072  ! 9463: SAVE_I	save	%r16, 0x0001, %r29
	.word 0xbd3c8000  ! 9464: SRA_R	sra 	%r18, %r0, %r30
	.word 0xb7e4201b  ! 9468: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb1e4e1df  ! 9469: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xb1e5e0f9  ! 9476: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb9e4e1f4  ! 9483: SAVE_I	save	%r19, 0x0001, %r28
	.word 0xbfe5216f  ! 9487: SAVE_I	save	%r20, 0x0001, %r31
hwintr_0_443:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_443), 16, 16)) -> intp(0, 0, 23)
	.word 0xb7e46079  ! 9490: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xbfe4a017  ! 9498: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb9510000  ! 9499: RDPR_TICK	<illegal instruction>
	.word 0xbd3d1000  ! 9500: SRAX_R	srax	%r20, %r0, %r30
	.word 0x9195e1c9  ! 9501: WRPR_PIL_I	wrpr	%r23, 0x01c9, %pil
	.word 0xbbe5a106  ! 9505: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xbe152152  ! 9506: OR_I	or 	%r20, 0x0152, %r31
	.word 0xb445c000  ! 9511: ADDC_R	addc 	%r23, %r0, %r26
	.word 0x8195a10e  ! 9515: WRPR_TPC_I	wrpr	%r22, 0x010e, %tpc
	.word 0xbde4e00f  ! 9521: SAVE_I	save	%r19, 0x0001, %r30
	.word 0xbbe5e08c  ! 9525: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xbfe521b3  ! 9530: SAVE_I	save	%r20, 0x0001, %r31
hwintr_0_444:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_444), 16, 16)) -> intp(0, 0, 4)
	.word 0x8994e03e  ! 9542: WRPR_TICK_I	wrpr	%r19, 0x003e, %tick
hwintr_0_445:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_445), 16, 16)) -> intp(0, 0, 21)
	.word 0xbfe4a0e8  ! 9546: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xb1e5e191  ! 9549: SAVE_I	save	%r23, 0x0001, %r24
	.word 0xb5e5a008  ! 9553: SAVE_I	save	%r22, 0x0001, %r26
hwintr_0_446:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_446), 16, 16)) -> intp(0, 0, 18)
	ta	T_CHANGE_HPRIV
T0_spu_op_32:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x1a05, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
	.word 0xb5e4201b  ! 9561: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xb69d6020  ! 9562: XORcc_I	xorcc 	%r21, 0x0020, %r27
	.word 0xb02dc000  ! 9563: ANDN_R	andn 	%r23, %r0, %r24
	.word 0xb3508000  ! 9564: RDPR_TSTATE	<illegal instruction>
	.word 0xb3e5a1b4  ! 9567: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xb6b5e132  ! 9570: ORNcc_I	orncc 	%r23, 0x0132, %r27
	.word 0xbbe5a11c  ! 9576: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb5e52031  ! 9579: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb350c000  ! 9583: RDPR_TT	<illegal instruction>
	.word 0xbf500000  ! 9585: RDPR_TPC	<illegal instruction>
hwintr_0_447:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_447), 16, 16)) -> intp(0, 0, 4)
hwintr_0_448:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_448), 16, 16)) -> intp(0, 0, 7)
	.word 0xb2ac218e  ! 9589: ANDNcc_I	andncc 	%r16, 0x018e, %r25
hwintr_0_449:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_449), 16, 16)) -> intp(0, 0, 30)
	.word 0xb7e4605e  ! 9595: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xbc3ce159  ! 9601: XNOR_I	xnor 	%r19, 0x0159, %r30
hwintr_0_450:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_450), 16, 16)) -> intp(0, 0, 35)
	.word 0xbde4a173  ! 9610: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xb1e4e18d  ! 9611: SAVE_I	save	%r19, 0x0001, %r24
	.word 0xbbe5218f  ! 9612: SAVE_I	save	%r20, 0x0001, %r29
	.word 0xbfe5e045  ! 9613: SAVE_I	save	%r23, 0x0001, %r31
	.word 0xbbe4a107  ! 9614: SAVE_I	save	%r18, 0x0001, %r29
	.word 0x8394611a  ! 9615: WRPR_TNPC_I	wrpr	%r17, 0x011a, %tnpc
	.word 0xb9e5e13f  ! 9617: SAVE_I	save	%r23, 0x0001, %r28
	.word 0xbbe5e03f  ! 9618: SAVE_I	save	%r23, 0x0001, %r29
	.word 0xb9e46124  ! 9619: SAVE_I	save	%r17, 0x0001, %r28
	.word 0x8d95e0c7  ! 9620: WRPR_PSTATE_I	wrpr	%r23, 0x00c7, %pstate
hwintr_0_451:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_451), 16, 16)) -> intp(0, 0, 27)
	.word 0xbbe5619e  ! 9624: SAVE_I	save	%r21, 0x0001, %r29
	.word 0x8794e149  ! 9625: WRPR_TT_I	wrpr	%r19, 0x0149, %tt
	.word 0xb1e52134  ! 9628: SAVE_I	save	%r20, 0x0001, %r24
	.word 0xb9e5e189  ! 9629: SAVE_I	save	%r23, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xb42c61bb  ! 9634: ANDN_I	andn 	%r17, 0x01bb, %r26
	.word 0xb1353001  ! 9643: SRLX_I	srlx	%r20, 0x0001, %r24
	.word 0x8d952117  ! 9644: WRPR_PSTATE_I	wrpr	%r20, 0x0117, %pstate
	.word 0xb1e521c1  ! 9645: SAVE_I	save	%r20, 0x0001, %r24
hwintr_0_452:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_452), 16, 16)) -> intp(0, 0, 3b)
	.word 0xb7e421c9  ! 9647: SAVE_I	save	%r16, 0x0001, %r27
	.word 0xb1e5e141  ! 9649: SAVE_I	save	%r23, 0x0001, %r24
hwintr_0_453:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_453), 16, 16)) -> intp(0, 0, 2f)
hwintr_0_454:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_454), 16, 16)) -> intp(0, 0, 3f)
	.word 0xb3e5a1a1  ! 9659: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xbde5a0dc  ! 9660: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xbfe52162  ! 9662: SAVE_I	save	%r20, 0x0001, %r31
hwintr_0_455:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_455), 16, 16)) -> intp(0, 0, 2b)
	.word 0xb3e5615f  ! 9664: SAVE_I	save	%r21, 0x0001, %r25
	.word 0x8d94a175  ! 9665: WRPR_PSTATE_I	wrpr	%r18, 0x0175, %pstate
	.word 0xb150c000  ! 9667: RDPR_TT	<illegal instruction>
	.word 0xbfe42168  ! 9668: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xb9e56014  ! 9670: SAVE_I	save	%r21, 0x0001, %r28
	.word 0xbfe4218f  ! 9675: SAVE_I	save	%r16, 0x0001, %r31
	mov	1, %r14
	.word 0xa193a000  ! 9678: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb414c000  ! 9680: OR_R	or 	%r19, %r0, %r26
	.word 0xbf346001  ! 9681: SRL_I	srl 	%r17, 0x0001, %r31
hwintr_0_456:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_456), 16, 16)) -> intp(0, 0, 6)
	.word 0xb3e4a042  ! 9684: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xb3e4a149  ! 9685: SAVE_I	save	%r18, 0x0001, %r25
	mov	0, %r14
	.word 0xa193a000  ! 9689: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb3e5210f  ! 9690: SAVE_I	save	%r20, 0x0001, %r25
	.word 0x8595e0a1  ! 9691: WRPR_TSTATE_I	wrpr	%r23, 0x00a1, %tstate
	.word 0xbde5e064  ! 9692: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb950c000  ! 9695: RDPR_TT	<illegal instruction>
	.word 0xb1e5a129  ! 9696: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb5e421dc  ! 9698: SAVE_I	save	%r16, 0x0001, %r26
	.word 0xbde5208e  ! 9700: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xb9e5a099  ! 9701: SAVE_I	save	%r22, 0x0001, %r28
hwintr_0_457:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_457), 16, 16)) -> intp(0, 0, f)
	.word 0xb1e4e100  ! 9706: SAVE_I	save	%r19, 0x0001, %r24
hwintr_0_458:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_458), 16, 16)) -> intp(0, 0, 19)
	.word 0xb5e46056  ! 9708: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xb7e5e188  ! 9709: SAVE_I	save	%r23, 0x0001, %r27
	.word 0xb5e461cb  ! 9715: SAVE_I	save	%r17, 0x0001, %r26
	.word 0xbde4a01b  ! 9716: SAVE_I	save	%r18, 0x0001, %r30
	.word 0xbbe4e18a  ! 9719: SAVE_I	save	%r19, 0x0001, %r29
	.word 0x859560e6  ! 9720: WRPR_TSTATE_I	wrpr	%r21, 0x00e6, %tstate
	.word 0xbe158000  ! 9722: OR_R	or 	%r22, %r0, %r31
	mov	0, %r14
	.word 0xa193a000  ! 9725: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb5e5e03a  ! 9729: SAVE_I	save	%r23, 0x0001, %r26
	.word 0xbc1d8000  ! 9730: XOR_R	xor 	%r22, %r0, %r30
	.word 0xbd508000  ! 9733: RDPR_TSTATE	<illegal instruction>
	.word 0xb7e420fb  ! 9735: SAVE_I	save	%r16, 0x0001, %r27
	.word 0x8595a03a  ! 9739: WRPR_TSTATE_I	wrpr	%r22, 0x003a, %tstate
	.word 0x859560bb  ! 9740: WRPR_TSTATE_I	wrpr	%r21, 0x00bb, %tstate
	.word 0x8995e07d  ! 9742: WRPR_TICK_I	wrpr	%r23, 0x007d, %tick
hwintr_0_459:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_459), 16, 16)) -> intp(0, 0, 1)
	.word 0xb7e52169  ! 9749: SAVE_I	save	%r20, 0x0001, %r27
	.word 0xb1e4a1cf  ! 9750: SAVE_I	save	%r18, 0x0001, %r24
	.word 0xb6148000  ! 9751: OR_R	or 	%r18, %r0, %r27
	.word 0xb82d60d7  ! 9752: ANDN_I	andn 	%r21, 0x00d7, %r28
	mov	2, %r12
	.word 0x8f932000  ! 9758: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb3e4a082  ! 9760: SAVE_I	save	%r18, 0x0001, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81982d01  ! 9766: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d01, %hpstate
	.word 0xbde52118  ! 9768: SAVE_I	save	%r20, 0x0001, %r30
	.word 0xbfe4204a  ! 9769: SAVE_I	save	%r16, 0x0001, %r31
	.word 0xbbe56051  ! 9770: SAVE_I	save	%r21, 0x0001, %r29
	.word 0xb7e4e080  ! 9771: SAVE_I	save	%r19, 0x0001, %r27
	mov	0, %r14
	.word 0xa193a000  ! 9773: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb43ce008  ! 9776: XNOR_I	xnor 	%r19, 0x0008, %r26
	.word 0xbde5e0bb  ! 9777: SAVE_I	save	%r23, 0x0001, %r30
	.word 0xb3e5a09f  ! 9780: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xbbe4a04d  ! 9784: SAVE_I	save	%r18, 0x0001, %r29
hwintr_0_460:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_460), 16, 16)) -> intp(0, 0, 21)
	.word 0xbbe5a13a  ! 9790: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb5e56058  ! 9794: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb7e5e02d  ! 9795: SAVE_I	save	%r23, 0x0001, %r27
	.word 0x9194608d  ! 9796: WRPR_PIL_I	wrpr	%r17, 0x008d, %pil
	.word 0xb5e560dc  ! 9799: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xbde420df  ! 9800: SAVE_I	save	%r16, 0x0001, %r30
	.word 0xbf51c000  ! 9801: RDPR_TL	<illegal instruction>
	.word 0xb1e4e1ec  ! 9804: SAVE_I	save	%r19, 0x0001, %r24
	.word 0x8d952032  ! 9808: WRPR_PSTATE_I	wrpr	%r20, 0x0032, %pstate
	.word 0xb4058000  ! 9809: ADD_R	add 	%r22, %r0, %r26
	.word 0xbbe5a079  ! 9814: SAVE_I	save	%r22, 0x0001, %r29
	.word 0xb5e4a18c  ! 9816: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb5e56163  ! 9818: SAVE_I	save	%r21, 0x0001, %r26
	.word 0xb7e56067  ! 9819: SAVE_I	save	%r21, 0x0001, %r27
hwintr_0_461:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_461), 16, 16)) -> intp(0, 0, 2)
	.word 0xb3e4213b  ! 9824: SAVE_I	save	%r16, 0x0001, %r25
	.word 0xb7e460e3  ! 9826: SAVE_I	save	%r17, 0x0001, %r27
	.word 0xb5e520aa  ! 9827: SAVE_I	save	%r20, 0x0001, %r26
	.word 0xb7e4e0d3  ! 9831: SAVE_I	save	%r19, 0x0001, %r27
	.word 0xb7e52062  ! 9833: SAVE_I	save	%r20, 0x0001, %r27
hwintr_0_462:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_462), 16, 16)) -> intp(0, 0, 38)
	.word 0xb3e560bd  ! 9836: SAVE_I	save	%r21, 0x0001, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81983d03  ! 9838: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d03, %hpstate
	.word 0xb3e5a053  ! 9839: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xbea48000  ! 9840: SUBcc_R	subcc 	%r18, %r0, %r31
	.word 0xbde460c0  ! 9844: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xb21c2021  ! 9847: XOR_I	xor 	%r16, 0x0021, %r25
	.word 0x87952162  ! 9848: WRPR_TT_I	wrpr	%r20, 0x0162, %tt
	.word 0xb5520000  ! 9849: RDPR_PIL	<illegal instruction>
	.word 0xb3e56054  ! 9850: SAVE_I	save	%r21, 0x0001, %r25
	.word 0xb1e5a069  ! 9851: SAVE_I	save	%r22, 0x0001, %r24
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xbfe560d2  ! 9853: SAVE_I	save	%r21, 0x0001, %r31
	.word 0xbde46183  ! 9855: SAVE_I	save	%r17, 0x0001, %r30
	.word 0xbfe4e1d6  ! 9857: SAVE_I	save	%r19, 0x0001, %r31
	.word 0x839520b3  ! 9863: WRPR_TNPC_I	wrpr	%r20, 0x00b3, %tnpc
hwintr_0_463:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_463), 16, 16)) -> intp(0, 0, 15)
	.word 0xb9e4a114  ! 9874: SAVE_I	save	%r18, 0x0001, %r28
	.word 0xbfe560bd  ! 9878: SAVE_I	save	%r21, 0x0001, %r31
hwintr_0_464:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_464), 16, 16)) -> intp(0, 0, 7)
	.word 0xb5e561b4  ! 9880: SAVE_I	save	%r21, 0x0001, %r26
	.word 0x8394e0d1  ! 9883: WRPR_TNPC_I	wrpr	%r19, 0x00d1, %tnpc
	.word 0xb034e16a  ! 9889: ORN_I	orn 	%r19, 0x016a, %r24
	.word 0xbbe5a11e  ! 9893: SAVE_I	save	%r22, 0x0001, %r29
	.word 0x8d95e071  ! 9894: WRPR_PSTATE_I	wrpr	%r23, 0x0071, %pstate
hwintr_0_465:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_465), 16, 16)) -> intp(0, 0, f)
	.word 0xb4b5a04c  ! 9899: ORNcc_I	orncc 	%r22, 0x004c, %r26
	.word 0xb7e4a187  ! 9900: SAVE_I	save	%r18, 0x0001, %r27
hwintr_0_466:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_466), 16, 16)) -> intp(0, 0, 1d)
	.word 0xb5e4a029  ! 9908: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xba84c000  ! 9909: ADDcc_R	addcc 	%r19, %r0, %r29
	.word 0xba2560c2  ! 9917: SUB_I	sub 	%r21, 0x00c2, %r29
hwintr_0_467:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_467), 16, 16)) -> intp(0, 0, 1b)
	.word 0xbf480000  ! 9924: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xb750c000  ! 9925: RDPR_TT	<illegal instruction>
	.word 0xb3e5a0ff  ! 9927: SAVE_I	save	%r22, 0x0001, %r25
	.word 0xbde5a12a  ! 9931: SAVE_I	save	%r22, 0x0001, %r30
	.word 0xbde4215b  ! 9933: SAVE_I	save	%r16, 0x0001, %r30
	mov	1, %r14
	.word 0xa193a000  ! 9934: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9e46128  ! 9937: SAVE_I	save	%r17, 0x0001, %r28
	.word 0xb4b560a3  ! 9941: SUBCcc_I	orncc 	%r21, 0x00a3, %r26
hwintr_0_468:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_468), 16, 16)) -> intp(0, 0, 20)
	ta	T_CHANGE_HPRIV
T0_spu_op_33:
	set	0x0, %g2
	set	REG_MA_ADDR_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	setx	DATA_SRC_PA, %g1, %g2
	set	REG_MPA_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	set	0x201, %g2
	set	REG_MA_CTL_ADDR, %g1
	stxa	%g2, [%g0 + %g1] SPU_ASI
	rdhpr	%hpstate, %g1
	wrhpr	%g1, 4, %hpstate	!T_CHANGE_NONHPRIV
hwintr_0_469:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_469), 16, 16)) -> intp(0, 0, 18)
	.word 0xb3504000  ! 9952: RDPR_TNPC	<illegal instruction>
	.word 0xb9e5a09a  ! 9953: SAVE_I	save	%r22, 0x0001, %r28
	.word 0xb1e5a136  ! 9955: SAVE_I	save	%r22, 0x0001, %r24
	.word 0xb9e42135  ! 9957: SAVE_I	save	%r16, 0x0001, %r28
	.word 0x8d9521ad  ! 9968: WRPR_PSTATE_I	wrpr	%r20, 0x01ad, %pstate
	.word 0xbbe4e033  ! 9969: SAVE_I	save	%r19, 0x0001, %r29
	.word 0xb3e5e028  ! 9973: SAVE_I	save	%r23, 0x0001, %r25
	.word 0xb5e4a0a8  ! 9976: SAVE_I	save	%r18, 0x0001, %r26
	.word 0xb3e4a199  ! 9977: SAVE_I	save	%r18, 0x0001, %r25
	.word 0xb1e5a0b0  ! 9980: SAVE_I	save	%r22, 0x0001, %r24
hwintr_0_470:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_470), 16, 16)) -> intp(0, 0, 12)
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xbfe4a1a4  ! 9988: SAVE_I	save	%r18, 0x0001, %r31
	.word 0xbac48000  ! 9990: ADDCcc_R	addccc 	%r18, %r0, %r29
hwintr_0_471:
!$EV trig_pc_d(0,expr(@VA(.MAIN.hwintr_0_471), 16, 16)) -> intp(0, 0, 2a)
	.word 0xb5e5e0e2  ! 9996: SAVE_I	save	%r23, 0x0001, %r26
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_3:
	setx	data_start_0, %g1, %r16
	setx	data_start_1, %g1, %r17
	setx	data_start_2, %g1, %r18
	setx	data_start_3, %g1, %r19
	setx	data_start_4, %g1, %r20
	setx	data_start_5, %g1, %r21
	setx	data_start_6, %g1, %r22
	setx	data_start_7, %g1, %r23
	.word 0x8994a00c  ! 4: WRPR_TICK_I	wrpr	%r18, 0x000c, %tick
hwintr_3_0:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_0), 16, 16)) -> intp(3, 0, 2f)
	.word 0xf62ca1e1  ! 7: STB_I	stb	%r27, [%r18 + 0x01e1]
	.word 0xf82c6051  ! 11: STB_I	stb	%r28, [%r17 + 0x0051]
	.word 0x9195e1fe  ! 19: WRPR_PIL_I	wrpr	%r23, 0x01fe, %pil
	.word 0x9195a1e5  ! 20: WRPR_PIL_I	wrpr	%r22, 0x01e5, %pil
	.word 0xfe2cc000  ! 21: STB_R	stb	%r31, [%r19 + %r0]
	.word 0xfc2ca174  ! 23: STB_I	stb	%r30, [%r18 + 0x0174]
hwintr_3_1:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_1), 16, 16)) -> intp(3, 0, 9)
hwintr_3_2:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_2), 16, 16)) -> intp(3, 0, 18)
	.word 0xb5518000  ! 35: RDPR_PSTATE	rdpr	%pstate, %r26
	.word 0xb9520000  ! 36: RDPR_PIL	<illegal instruction>
	.word 0xb61dc000  ! 39: XOR_R	xor 	%r23, %r0, %r27
	.word 0xbc3c4000  ! 41: XNOR_R	xnor 	%r17, %r0, %r30
	.word 0xf53d6004  ! 42: STDF_I	std	%f26, [0x0004, %r21]
	.word 0xfe352197  ! 45: STH_I	sth	%r31, [%r20 + 0x0197]
	.word 0x83956090  ! 50: WRPR_TNPC_I	wrpr	%r21, 0x0090, %tnpc
	.word 0xf03d20c6  ! 52: STD_I	std	%r24, [%r20 + 0x00c6]
	.word 0xf62d8000  ! 53: STB_R	stb	%r27, [%r22 + %r0]
	.word 0xfa742000  ! 60: STX_I	stx	%r29, [%r16 + 0x0000]
	.word 0xf625a03d  ! 62: STW_I	stw	%r27, [%r22 + 0x003d]
	.word 0xf62cc000  ! 65: STB_R	stb	%r27, [%r19 + %r0]
	setx	data_start_0, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb40460d2  ! 76: ADD_I	add 	%r17, 0x00d2, %r26
hwintr_3_3:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_3), 16, 16)) -> intp(3, 0, 21)
	.word 0xbf641800  ! 80: MOVcc_R	<illegal instruction>
	.word 0xf53c4000  ! 89: STDF_R	std	%f26, [%r0, %r17]
	.word 0xf73cc000  ! 92: STDF_R	std	%f27, [%r0, %r19]
	.word 0xf82da06a  ! 95: STB_I	stb	%r28, [%r22 + 0x006a]
	.word 0x8995a197  ! 98: WRPR_TICK_I	wrpr	%r22, 0x0197, %tick
	.word 0xb151c000  ! 102: RDPR_TL	rdpr	%tl, %r24
	.word 0xff3dc000  ! 104: STDF_R	std	%f31, [%r0, %r23]
	.word 0xb150c000  ! 106: RDPR_TT	<illegal instruction>
	.word 0xb3510000  ! 112: RDPR_TICK	<illegal instruction>
	.word 0xf6250000  ! 113: STW_R	stw	%r27, [%r20 + %r0]
	.word 0xfc2c20aa  ! 117: STB_I	stb	%r30, [%r16 + 0x00aa]
hwintr_3_4:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_4), 16, 16)) -> intp(3, 0, 38)
	.word 0x8594a1cc  ! 123: WRPR_TSTATE_I	wrpr	%r18, 0x01cc, %tstate
	.word 0xb23d8000  ! 125: XNOR_R	xnor 	%r22, %r0, %r25
	.word 0xb044606a  ! 126: ADDC_I	addc 	%r17, 0x006a, %r24
	.word 0xf8244000  ! 127: STW_R	stw	%r28, [%r17 + %r0]
	.word 0xf074c000  ! 128: STX_R	stx	%r24, [%r19 + %r0]
	mov	2, %r12
	.word 0x8f932000  ! 130: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_3_5:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_5), 16, 16)) -> intp(3, 0, 12)
	.word 0xfc74a00c  ! 133: STX_I	stx	%r30, [%r18 + 0x000c]
	.word 0xbcbde1f9  ! 136: XNORcc_I	xnorcc 	%r23, 0x01f9, %r30
	.word 0x87952197  ! 141: WRPR_TT_I	wrpr	%r20, 0x0197, %tt
	.word 0xb09da17a  ! 143: XORcc_I	xorcc 	%r22, 0x017a, %r24
	.word 0xbec44000  ! 146: ADDCcc_R	addccc 	%r17, %r0, %r31
	.word 0xf6242082  ! 149: STW_I	stw	%r27, [%r16 + 0x0082]
	.word 0xfa24a1e0  ! 160: STW_I	stw	%r29, [%r18 + 0x01e0]
	.word 0xb43460a2  ! 162: SUBC_I	orn 	%r17, 0x00a2, %r26
	.word 0x8794a119  ! 163: WRPR_TT_I	wrpr	%r18, 0x0119, %tt
	.word 0xf474a0cc  ! 164: STX_I	stx	%r26, [%r18 + 0x00cc]
	.word 0xf13ca022  ! 168: STDF_I	std	%f24, [0x0022, %r18]
	.word 0xb0bd4000  ! 169: XNORcc_R	xnorcc 	%r21, %r0, %r24
	.word 0xbc35a020  ! 170: ORN_I	orn 	%r22, 0x0020, %r30
	.word 0xbb510000  ! 172: RDPR_TICK	rdpr	%tick, %r29
	.word 0xbb500000  ! 174: RDPR_TPC	<illegal instruction>
	.word 0xbc254000  ! 175: SUB_R	sub 	%r21, %r0, %r30
	.word 0x8194202a  ! 180: WRPR_TPC_I	wrpr	%r16, 0x002a, %tpc
	.word 0xf23d8000  ! 181: STD_R	std	%r25, [%r22 + %r0]
hwintr_3_6:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_6), 16, 16)) -> intp(3, 0, 2c)
	.word 0xfe3560c5  ! 184: STH_I	sth	%r31, [%r21 + 0x00c5]
	.word 0xf2354000  ! 189: STH_R	sth	%r25, [%r21 + %r0]
	.word 0xf62c617a  ! 194: STB_I	stb	%r27, [%r17 + 0x017a]
hwintr_3_7:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_7), 16, 16)) -> intp(3, 0, 31)
	.word 0xf53c4000  ! 196: STDF_R	std	%f26, [%r0, %r17]
	.word 0xfe34e0fc  ! 197: STH_I	sth	%r31, [%r19 + 0x00fc]
	.word 0xfa25211b  ! 198: STW_I	stw	%r29, [%r20 + 0x011b]
	.word 0xf2342077  ! 200: STH_I	sth	%r25, [%r16 + 0x0077]
	.word 0xfd3cc000  ! 206: STDF_R	std	%f30, [%r0, %r19]
	.word 0xf03461c4  ! 208: STH_I	sth	%r24, [%r17 + 0x01c4]
	.word 0xfc34604a  ! 209: STH_I	sth	%r30, [%r17 + 0x004a]
hwintr_3_8:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_8), 16, 16)) -> intp(3, 0, 35)
	.word 0xbb3c4000  ! 211: SRA_R	sra 	%r17, %r0, %r29
	.word 0xf235e060  ! 213: STH_I	sth	%r25, [%r23 + 0x0060]
	.word 0x8594a156  ! 215: WRPR_TSTATE_I	wrpr	%r18, 0x0156, %tstate
	.word 0x81946156  ! 221: WRPR_TPC_I	wrpr	%r17, 0x0156, %tpc
hwintr_3_9:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_9), 16, 16)) -> intp(3, 0, 32)
	.word 0xf0340000  ! 224: STH_R	sth	%r24, [%r16 + %r0]
	.word 0xf42da0e7  ! 225: STB_I	stb	%r26, [%r22 + 0x00e7]
	.word 0xb350c000  ! 229: RDPR_TT	rdpr	%tt, %r25
hwintr_3_10:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_10), 16, 16)) -> intp(3, 0, 25)
	.word 0xf63d4000  ! 236: STD_R	std	%r27, [%r21 + %r0]
	.word 0xb9508000  ! 238: RDPR_TSTATE	<illegal instruction>
hwintr_3_11:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_11), 16, 16)) -> intp(3, 0, f)
	.word 0xf625a1d6  ! 242: STW_I	stw	%r27, [%r22 + 0x01d6]
	.word 0xf13ce134  ! 244: STDF_I	std	%f24, [0x0134, %r19]
	.word 0xf625a1c9  ! 245: STW_I	stw	%r27, [%r22 + 0x01c9]
	.word 0xf434c000  ! 248: STH_R	sth	%r26, [%r19 + %r0]
	.word 0xf23d6077  ! 249: STD_I	std	%r25, [%r21 + 0x0077]
	.word 0xf074a035  ! 253: STX_I	stx	%r24, [%r18 + 0x0035]
	mov	2, %r14
	.word 0xa193a000  ! 254: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x87956005  ! 256: WRPR_TT_I	wrpr	%r21, 0x0005, %tt
	mov	0, %r14
	.word 0xa193a000  ! 257: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf675e16f  ! 260: STX_I	stx	%r27, [%r23 + 0x016f]
hwintr_3_12:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_12), 16, 16)) -> intp(3, 0, 1a)
hwintr_3_13:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_13), 16, 16)) -> intp(3, 0, 2)
	.word 0x87942178  ! 266: WRPR_TT_I	wrpr	%r16, 0x0178, %tt
	setx	data_start_6, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb550c000  ! 270: RDPR_TT	rdpr	%tt, %r26
	.word 0x8195a144  ! 272: WRPR_TPC_I	wrpr	%r22, 0x0144, %tpc
	.word 0xfb3cc000  ! 273: STDF_R	std	%f29, [%r0, %r19]
	.word 0xf63c4000  ! 274: STD_R	std	%r27, [%r17 + %r0]
	.word 0xfc24a13b  ! 279: STW_I	stw	%r30, [%r18 + 0x013b]
	.word 0xb9500000  ! 280: RDPR_TPC	rdpr	%tpc, %r28
	mov	2, %r14
	.word 0xa193a000  ! 287: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfa3dc000  ! 289: STD_R	std	%r29, [%r23 + %r0]
	.word 0xf674c000  ! 290: STX_R	stx	%r27, [%r19 + %r0]
	.word 0xf2350000  ! 293: STH_R	sth	%r25, [%r20 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982959  ! 295: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0959, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81983909  ! 299: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1909, %hpstate
	.word 0xb8154000  ! 301: OR_R	or 	%r21, %r0, %r28
	.word 0xb40c61fe  ! 304: AND_I	and 	%r17, 0x01fe, %r26
	.word 0xb751c000  ! 305: RDPR_TL	rdpr	%tl, %r27
	.word 0xb5510000  ! 306: RDPR_TICK	<illegal instruction>
	.word 0xfd3c0000  ! 307: STDF_R	std	%f30, [%r0, %r16]
	.word 0xf22d8000  ! 308: STB_R	stb	%r25, [%r22 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81983e93  ! 309: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e93, %hpstate
	.word 0xf035c000  ! 311: STH_R	sth	%r24, [%r23 + %r0]
	.word 0xbb500000  ! 315: RDPR_TPC	rdpr	%tpc, %r29
	.word 0xb2b54000  ! 316: ORNcc_R	orncc 	%r21, %r0, %r25
	.word 0xf03da03f  ! 318: STD_I	std	%r24, [%r22 + 0x003f]
	.word 0xf024c000  ! 319: STW_R	stw	%r24, [%r19 + %r0]
	.word 0xbd51c000  ! 320: RDPR_TL	<illegal instruction>
	.word 0xb6458000  ! 321: ADDC_R	addc 	%r22, %r0, %r27
	.word 0xf6256078  ! 322: STW_I	stw	%r27, [%r21 + 0x0078]
	.word 0x8194e01d  ! 325: WRPR_TPC_I	wrpr	%r19, 0x001d, %tpc
hwintr_3_14:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_14), 16, 16)) -> intp(3, 0, 35)
hwintr_3_15:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_15), 16, 16)) -> intp(3, 0, 23)
	.word 0xb01de105  ! 342: XOR_I	xor 	%r23, 0x0105, %r24
	.word 0xf02d4000  ! 345: STB_R	stb	%r24, [%r21 + %r0]
	.word 0xf0240000  ! 347: STW_R	stw	%r24, [%r16 + %r0]
	.word 0xf73d0000  ! 348: STDF_R	std	%f27, [%r0, %r20]
	.word 0xf6358000  ! 352: STH_R	sth	%r27, [%r22 + %r0]
	.word 0xbf51c000  ! 353: RDPR_TL	rdpr	%tl, %r31
	.word 0xb215603e  ! 354: OR_I	or 	%r21, 0x003e, %r25
	.word 0xfe7521b9  ! 355: STX_I	stx	%r31, [%r20 + 0x01b9]
	.word 0xf82d61dd  ! 357: STB_I	stb	%r28, [%r21 + 0x01dd]
	.word 0xb00d6184  ! 359: AND_I	and 	%r21, 0x0184, %r24
hwintr_3_16:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_16), 16, 16)) -> intp(3, 0, 24)
	.word 0x8d95a1f1  ! 364: WRPR_PSTATE_I	wrpr	%r22, 0x01f1, %pstate
	.word 0xf6752166  ! 368: STX_I	stx	%r27, [%r20 + 0x0166]
	.word 0xbf7d4400  ! 370: MOVR_R	movre	%r21, %r0, %r31
	.word 0xfa2c4000  ! 371: STB_R	stb	%r29, [%r17 + %r0]
	.word 0xf53cc000  ! 372: STDF_R	std	%f26, [%r0, %r19]
	setx	data_start_4, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xbd518000  ! 384: RDPR_PSTATE	rdpr	%pstate, %r30
	.word 0xf8758000  ! 386: STX_R	stx	%r28, [%r22 + %r0]
	.word 0xf23d0000  ! 390: STD_R	std	%r25, [%r20 + %r0]
	.word 0xb151c000  ! 391: RDPR_TL	<illegal instruction>
	.word 0xfe240000  ! 392: STW_R	stw	%r31, [%r16 + %r0]
	.word 0xf0358000  ! 393: STH_R	sth	%r24, [%r22 + %r0]
	.word 0xf235a047  ! 394: STH_I	sth	%r25, [%r22 + 0x0047]
	.word 0xfc35a0f8  ! 404: STH_I	sth	%r30, [%r22 + 0x00f8]
	.word 0xbd2d4000  ! 405: SLL_R	sll 	%r21, %r0, %r30
	.word 0xf2344000  ! 407: STH_R	sth	%r25, [%r17 + %r0]
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xf0248000  ! 415: STW_R	stw	%r24, [%r18 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81983c13  ! 418: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c13, %hpstate
	.word 0x8595e18a  ! 419: WRPR_TSTATE_I	wrpr	%r23, 0x018a, %tstate
	.word 0xf8750000  ! 421: STX_R	stx	%r28, [%r20 + %r0]
	.word 0xf82dc000  ! 424: STB_R	stb	%r28, [%r23 + %r0]
	.word 0xf23cc000  ! 426: STD_R	std	%r25, [%r19 + %r0]
	.word 0x8595a118  ! 429: WRPR_TSTATE_I	wrpr	%r22, 0x0118, %tstate
	.word 0xb7510000  ! 436: RDPR_TICK	rdpr	%tick, %r27
	.word 0xbc25c000  ! 440: SUB_R	sub 	%r23, %r0, %r30
	mov	2, %r12
	.word 0x8f932000  ! 450: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb77d4400  ! 451: MOVR_R	movre	%r21, %r0, %r27
	.word 0xbb510000  ! 458: RDPR_TICK	rdpr	%tick, %r29
	.word 0xf62ce00c  ! 461: STB_I	stb	%r27, [%r19 + 0x000c]
	.word 0xf8242058  ! 467: STW_I	stw	%r28, [%r16 + 0x0058]
	.word 0xbf50c000  ! 468: RDPR_TT	<illegal instruction>
	.word 0xfe744000  ! 474: STX_R	stx	%r31, [%r17 + %r0]
	.word 0xfe248000  ! 478: STW_R	stw	%r31, [%r18 + %r0]
	.word 0xbd520000  ! 481: RDPR_PIL	<illegal instruction>
	.word 0xbeb44000  ! 482: SUBCcc_R	orncc 	%r17, %r0, %r31
	.word 0xf834c000  ! 483: STH_R	sth	%r28, [%r19 + %r0]
	.word 0xfa240000  ! 486: STW_R	stw	%r29, [%r16 + %r0]
	.word 0xb951c000  ! 487: RDPR_TL	<illegal instruction>
	.word 0xfc748000  ! 493: STX_R	stx	%r30, [%r18 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81983ac9  ! 494: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1ac9, %hpstate
	.word 0xb9480000  ! 496: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xf13ce175  ! 497: STDF_I	std	%f24, [0x0175, %r19]
	.word 0xfe24a056  ! 499: STW_I	stw	%r31, [%r18 + 0x0056]
	.word 0xbf500000  ! 505: RDPR_TPC	rdpr	%tpc, %r31
	.word 0xf02c0000  ! 507: STB_R	stb	%r24, [%r16 + %r0]
	setx	data_start_2, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb5518000  ! 513: RDPR_PSTATE	<illegal instruction>
	.word 0xf53c4000  ! 517: STDF_R	std	%f26, [%r0, %r17]
	.word 0xf0342090  ! 521: STH_I	sth	%r24, [%r16 + 0x0090]
	.word 0xf93c8000  ! 523: STDF_R	std	%f28, [%r0, %r18]
	.word 0xb750c000  ! 524: RDPR_TT	<illegal instruction>
	.word 0xbb540000  ! 527: RDPR_GL	<illegal instruction>
	.word 0xf875a13a  ! 528: STX_I	stx	%r28, [%r22 + 0x013a]
	.word 0xf82c8000  ! 529: STB_R	stb	%r28, [%r18 + %r0]
	.word 0x8594a117  ! 530: WRPR_TSTATE_I	wrpr	%r18, 0x0117, %tstate
	.word 0xb57c4400  ! 531: MOVR_R	movre	%r17, %r0, %r26
	.word 0xbd480000  ! 532: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xfc3dc000  ! 533: STD_R	std	%r30, [%r23 + %r0]
	.word 0xb0ac8000  ! 536: ANDNcc_R	andncc 	%r18, %r0, %r24
hwintr_3_17:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_17), 16, 16)) -> intp(3, 0, 1f)
	.word 0xb08ca021  ! 538: ANDcc_I	andcc 	%r18, 0x0021, %r24
hwintr_3_18:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_18), 16, 16)) -> intp(3, 0, 37)
	.word 0xf624a097  ! 542: STW_I	stw	%r27, [%r18 + 0x0097]
	.word 0xfa348000  ! 544: STH_R	sth	%r29, [%r18 + %r0]
	.word 0xbd50c000  ! 548: RDPR_TT	<illegal instruction>
	.word 0xbf51c000  ! 549: RDPR_TL	<illegal instruction>
	.word 0xb92d2001  ! 550: SLL_I	sll 	%r20, 0x0001, %r28
	.word 0xfd3d8000  ! 553: STDF_R	std	%f30, [%r0, %r22]
	.word 0xf82c2096  ! 556: STB_I	stb	%r28, [%r16 + 0x0096]
	.word 0xbd540000  ! 559: RDPR_GL	<illegal instruction>
	.word 0xbe258000  ! 561: SUB_R	sub 	%r22, %r0, %r31
	.word 0xb1508000  ! 564: RDPR_TSTATE	<illegal instruction>
	.word 0x919561b5  ! 565: WRPR_PIL_I	wrpr	%r21, 0x01b5, %pil
	ta	T_CHANGE_HPRIV
	.word 0x81983a09  ! 567: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a09, %hpstate
	.word 0xf275604a  ! 569: STX_I	stx	%r25, [%r21 + 0x004a]
hwintr_3_19:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_19), 16, 16)) -> intp(3, 0, 1e)
	.word 0xf6250000  ! 585: STW_R	stw	%r27, [%r20 + %r0]
	.word 0xf33c617b  ! 591: STDF_I	std	%f25, [0x017b, %r17]
	.word 0xf42ce110  ! 592: STB_I	stb	%r26, [%r19 + 0x0110]
	.word 0xf025e141  ! 593: STW_I	stw	%r24, [%r23 + 0x0141]
	mov	0, %r14
	.word 0xa193a000  ! 594: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_3_20:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_20), 16, 16)) -> intp(3, 0, 36)
hwintr_3_21:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_21), 16, 16)) -> intp(3, 0, 2f)
	.word 0xfe2c21d6  ! 598: STB_I	stb	%r31, [%r16 + 0x01d6]
hwintr_3_22:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_22), 16, 16)) -> intp(3, 0, 3c)
	.word 0xfa2d6129  ! 604: STB_I	stb	%r29, [%r21 + 0x0129]
	.word 0xb3520000  ! 605: RDPR_PIL	rdpr	%pil, %r25
	.word 0x8994e009  ! 608: WRPR_TICK_I	wrpr	%r19, 0x0009, %tick
	.word 0xb0444000  ! 609: ADDC_R	addc 	%r17, %r0, %r24
hwintr_3_23:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_23), 16, 16)) -> intp(3, 0, 2c)
	.word 0xb81ca0b3  ! 614: XOR_I	xor 	%r18, 0x00b3, %r28
	.word 0xf225a0c5  ! 617: STW_I	stw	%r25, [%r22 + 0x00c5]
	.word 0xfa24e0f5  ! 619: STW_I	stw	%r29, [%r19 + 0x00f5]
	mov	2, %r12
	.word 0x8f932000  ! 620: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfb3c8000  ! 621: STDF_R	std	%f29, [%r0, %r18]
	.word 0xf13c214a  ! 622: STDF_I	std	%f24, [0x014a, %r16]
	.word 0xfe2da1b3  ! 627: STB_I	stb	%r31, [%r22 + 0x01b3]
	.word 0xfe744000  ! 630: STX_R	stx	%r31, [%r17 + %r0]
	.word 0xb604c000  ! 631: ADD_R	add 	%r19, %r0, %r27
	.word 0xbe2ce1cd  ! 633: ANDN_I	andn 	%r19, 0x01cd, %r31
	.word 0x8d95e102  ! 634: WRPR_PSTATE_I	wrpr	%r23, 0x0102, %pstate
	ta	T_CHANGE_HPRIV
	.word 0x81982b43  ! 635: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b43, %hpstate
	.word 0xf02c8000  ! 637: STB_R	stb	%r24, [%r18 + %r0]
	.word 0xf0752137  ! 638: STX_I	stx	%r24, [%r20 + 0x0137]
	.word 0xfe34a1d2  ! 641: STH_I	sth	%r31, [%r18 + 0x01d2]
	.word 0xfc2c0000  ! 644: STB_R	stb	%r30, [%r16 + %r0]
	mov	1, %r14
	.word 0xa193a000  ! 645: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8395e041  ! 646: WRPR_TNPC_I	wrpr	%r23, 0x0041, %tnpc
	.word 0xbead8000  ! 648: ANDNcc_R	andncc 	%r22, %r0, %r31
	.word 0xfa2de12d  ! 654: STB_I	stb	%r29, [%r23 + 0x012d]
	.word 0xf625a08a  ! 655: STW_I	stw	%r27, [%r22 + 0x008a]
	.word 0xf62d0000  ! 656: STB_R	stb	%r27, [%r20 + %r0]
	.word 0xf6252115  ! 660: STW_I	stw	%r27, [%r20 + 0x0115]
	.word 0xf23c0000  ! 662: STD_R	std	%r25, [%r16 + %r0]
	.word 0xf8744000  ! 663: STX_R	stx	%r28, [%r17 + %r0]
	.word 0xf73de05a  ! 665: STDF_I	std	%f27, [0x005a, %r23]
	.word 0xf03d2011  ! 666: STD_I	std	%r24, [%r20 + 0x0011]
	.word 0x8994e168  ! 668: WRPR_TICK_I	wrpr	%r19, 0x0168, %tick
	.word 0xf625c000  ! 669: STW_R	stw	%r27, [%r23 + %r0]
	.word 0xf42cc000  ! 671: STB_R	stb	%r26, [%r19 + %r0]
	.word 0xb751c000  ! 678: RDPR_TL	rdpr	%tl, %r27
	.word 0xfc3c21bb  ! 679: STD_I	std	%r30, [%r16 + 0x01bb]
	.word 0xbaace08c  ! 682: ANDNcc_I	andncc 	%r19, 0x008c, %r29
	.word 0xfa244000  ! 688: STW_R	stw	%r29, [%r17 + %r0]
	.word 0xb0a5c000  ! 694: SUBcc_R	subcc 	%r23, %r0, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81983a41  ! 695: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a41, %hpstate
	.word 0xf93de08a  ! 697: STDF_I	std	%f28, [0x008a, %r23]
	.word 0xbb540000  ! 698: RDPR_GL	rdpr	%-, %r29
	.word 0xf03c201a  ! 699: STD_I	std	%r24, [%r16 + 0x001a]
hwintr_3_24:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_24), 16, 16)) -> intp(3, 0, 34)
	.word 0xfe24c000  ! 702: STW_R	stw	%r31, [%r19 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x819829d9  ! 706: WRHPR_HPSTATE_I	wrhpr	%r0, 0x09d9, %hpstate
hwintr_3_25:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_25), 16, 16)) -> intp(3, 0, d)
	.word 0xf22c8000  ! 713: STB_R	stb	%r25, [%r18 + %r0]
	.word 0x8794a1ff  ! 718: WRPR_TT_I	wrpr	%r18, 0x01ff, %tt
	.word 0xf53de1c1  ! 721: STDF_I	std	%f26, [0x01c1, %r23]
hwintr_3_26:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_26), 16, 16)) -> intp(3, 0, 35)
	.word 0xb22ce08e  ! 725: ANDN_I	andn 	%r19, 0x008e, %r25
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xfd3dc000  ! 728: STDF_R	std	%f30, [%r0, %r23]
hwintr_3_27:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_27), 16, 16)) -> intp(3, 0, f)
	.word 0xf635a19c  ! 732: STH_I	sth	%r27, [%r22 + 0x019c]
	.word 0xbf50c000  ! 738: RDPR_TT	rdpr	%tt, %r31
	.word 0xb2c44000  ! 739: ADDCcc_R	addccc 	%r17, %r0, %r25
hwintr_3_28:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_28), 16, 16)) -> intp(3, 0, 7)
	.word 0xfe242081  ! 741: STW_I	stw	%r31, [%r16 + 0x0081]
hwintr_3_29:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_29), 16, 16)) -> intp(3, 0, 23)
	.word 0xf075c000  ! 743: STX_R	stx	%r24, [%r23 + %r0]
	.word 0xf2244000  ! 745: STW_R	stw	%r25, [%r17 + %r0]
hwintr_3_30:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_30), 16, 16)) -> intp(3, 0, 0)
hwintr_3_31:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_31), 16, 16)) -> intp(3, 0, 30)
hwintr_3_32:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_32), 16, 16)) -> intp(3, 0, 24)
	.word 0xfa252185  ! 754: STW_I	stw	%r29, [%r20 + 0x0185]
	.word 0xf42c6162  ! 758: STB_I	stb	%r26, [%r17 + 0x0162]
	.word 0xf82d6149  ! 759: STB_I	stb	%r28, [%r21 + 0x0149]
	.word 0x8395a106  ! 762: WRPR_TNPC_I	wrpr	%r22, 0x0106, %tnpc
	.word 0xfe3d4000  ! 763: STD_R	std	%r31, [%r21 + %r0]
	.word 0xf225c000  ! 765: STW_R	stw	%r25, [%r23 + %r0]
hwintr_3_33:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_33), 16, 16)) -> intp(3, 0, 2b)
	.word 0xb1500000  ! 768: RDPR_TPC	rdpr	%tpc, %r24
	.word 0xf03c4000  ! 770: STD_R	std	%r24, [%r17 + %r0]
	.word 0xf834c000  ! 772: STH_R	sth	%r28, [%r19 + %r0]
	.word 0xbb518000  ! 774: RDPR_PSTATE	<illegal instruction>
	.word 0x839561f4  ! 776: WRPR_TNPC_I	wrpr	%r21, 0x01f4, %tnpc
	.word 0xb3520000  ! 784: RDPR_PIL	rdpr	%pil, %r25
	.word 0xfb3d0000  ! 786: STDF_R	std	%f29, [%r0, %r20]
	.word 0xf2742014  ! 787: STX_I	stx	%r25, [%r16 + 0x0014]
	.word 0xb2bc60ea  ! 790: XNORcc_I	xnorcc 	%r17, 0x00ea, %r25
	.word 0xb044e00b  ! 792: ADDC_I	addc 	%r19, 0x000b, %r24
	.word 0xfc254000  ! 794: STW_R	stw	%r30, [%r21 + %r0]
hwintr_3_34:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_34), 16, 16)) -> intp(3, 0, 2)
	.word 0xf73d2047  ! 804: STDF_I	std	%f27, [0x0047, %r20]
	.word 0xf33d21f8  ! 810: STDF_I	std	%f25, [0x01f8, %r20]
	.word 0xba9d0000  ! 812: XORcc_R	xorcc 	%r20, %r0, %r29
	.word 0xf53c6197  ! 814: STDF_I	std	%f26, [0x0197, %r17]
	.word 0xf624e19a  ! 816: STW_I	stw	%r27, [%r19 + 0x019a]
	ta	T_CHANGE_HPRIV
	.word 0x81982e5b  ! 818: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e5b, %hpstate
	.word 0xfa3520df  ! 819: STH_I	sth	%r29, [%r20 + 0x00df]
	.word 0xfe2ce094  ! 820: STB_I	stb	%r31, [%r19 + 0x0094]
	.word 0xf03c606d  ! 822: STD_I	std	%r24, [%r17 + 0x006d]
	.word 0xf8350000  ! 824: STH_R	sth	%r28, [%r20 + %r0]
	.word 0xb445e138  ! 830: ADDC_I	addc 	%r23, 0x0138, %r26
hwintr_3_35:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_35), 16, 16)) -> intp(3, 0, 34)
	.word 0xbe35e017  ! 833: SUBC_I	orn 	%r23, 0x0017, %r31
	.word 0xf93d8000  ! 835: STDF_R	std	%f28, [%r0, %r22]
	.word 0xf93da006  ! 841: STDF_I	std	%f28, [0x0006, %r22]
	.word 0xbc2d4000  ! 842: ANDN_R	andn 	%r21, %r0, %r30
	.word 0xf2748000  ! 843: STX_R	stx	%r25, [%r18 + %r0]
	.word 0xfe2d2177  ! 846: STB_I	stb	%r31, [%r20 + 0x0177]
	.word 0xf23cc000  ! 849: STD_R	std	%r25, [%r19 + %r0]
	.word 0xfa246106  ! 851: STW_I	stw	%r29, [%r17 + 0x0106]
	.word 0xfa3d61f6  ! 854: STD_I	std	%r29, [%r21 + 0x01f6]
hwintr_3_36:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_36), 16, 16)) -> intp(3, 0, 24)
	.word 0xf8358000  ! 857: STH_R	sth	%r28, [%r22 + %r0]
	.word 0xf434e1a6  ! 858: STH_I	sth	%r26, [%r19 + 0x01a6]
	.word 0x8d9420ed  ! 860: WRPR_PSTATE_I	wrpr	%r16, 0x00ed, %pstate
	.word 0xba84c000  ! 862: ADDcc_R	addcc 	%r19, %r0, %r29
	.word 0xf43c6062  ! 863: STD_I	std	%r26, [%r17 + 0x0062]
	.word 0xf2244000  ! 864: STW_R	stw	%r25, [%r17 + %r0]
	.word 0xf635c000  ! 865: STH_R	sth	%r27, [%r23 + %r0]
	.word 0x89942159  ! 866: WRPR_TICK_I	wrpr	%r16, 0x0159, %tick
	.word 0xf425e10a  ! 867: STW_I	stw	%r26, [%r23 + 0x010a]
	.word 0xfa2d4000  ! 868: STB_R	stb	%r29, [%r21 + %r0]
	.word 0xf23460d1  ! 869: STH_I	sth	%r25, [%r17 + 0x00d1]
	.word 0xbebdc000  ! 872: XNORcc_R	xnorcc 	%r23, %r0, %r31
	.word 0xf0358000  ! 875: STH_R	sth	%r24, [%r22 + %r0]
	.word 0xf8252189  ! 876: STW_I	stw	%r28, [%r20 + 0x0189]
	mov	0, %r12
	.word 0x8f932000  ! 878: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_3_37:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_37), 16, 16)) -> intp(3, 0, 16)
	.word 0xb151c000  ! 886: RDPR_TL	rdpr	%tl, %r24
	.word 0x819420db  ! 891: WRPR_TPC_I	wrpr	%r16, 0x00db, %tpc
	.word 0xfe3d4000  ! 892: STD_R	std	%r31, [%r21 + %r0]
	.word 0xbac561de  ! 893: ADDCcc_I	addccc 	%r21, 0x01de, %r29
	mov	2, %r12
	.word 0x8f932000  ! 896: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf53c8000  ! 897: STDF_R	std	%f26, [%r0, %r18]
	.word 0xf23c60ab  ! 900: STD_I	std	%r25, [%r17 + 0x00ab]
	.word 0xb5518000  ! 901: RDPR_PSTATE	rdpr	%pstate, %r26
	.word 0xbf2cc000  ! 907: SLL_R	sll 	%r19, %r0, %r31
	.word 0xf02d8000  ! 911: STB_R	stb	%r24, [%r22 + %r0]
	.word 0x8394e010  ! 912: WRPR_TNPC_I	wrpr	%r19, 0x0010, %tnpc
	.word 0xb694e0e0  ! 913: ORcc_I	orcc 	%r19, 0x00e0, %r27
	.word 0xb08ca0a9  ! 916: ANDcc_I	andcc 	%r18, 0x00a9, %r24
	.word 0xbb500000  ! 918: RDPR_TPC	rdpr	%tpc, %r29
	.word 0xf63420a6  ! 919: STH_I	sth	%r27, [%r16 + 0x00a6]
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xfe244000  ! 922: STW_R	stw	%r31, [%r17 + %r0]
	.word 0xf13d0000  ! 925: STDF_R	std	%f24, [%r0, %r20]
	.word 0xbd508000  ! 927: RDPR_TSTATE	<illegal instruction>
	.word 0xb150c000  ! 929: RDPR_TT	<illegal instruction>
	.word 0xf4348000  ! 930: STH_R	sth	%r26, [%r18 + %r0]
	.word 0xf4752115  ! 932: STX_I	stx	%r26, [%r20 + 0x0115]
	.word 0xb4a58000  ! 934: SUBcc_R	subcc 	%r22, %r0, %r26
	.word 0xfa75e047  ! 935: STX_I	stx	%r29, [%r23 + 0x0047]
	.word 0xf2340000  ! 937: STH_R	sth	%r25, [%r16 + %r0]
	.word 0xfd3ca001  ! 938: STDF_I	std	%f30, [0x0001, %r18]
	.word 0xb150c000  ! 940: RDPR_TT	<illegal instruction>
hwintr_3_38:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_38), 16, 16)) -> intp(3, 0, 3d)
	.word 0xf42c0000  ! 942: STB_R	stb	%r26, [%r16 + %r0]
	.word 0xfe74c000  ! 946: STX_R	stx	%r31, [%r19 + %r0]
	.word 0xfc348000  ! 948: STH_R	sth	%r30, [%r18 + %r0]
	.word 0xf8250000  ! 949: STW_R	stw	%r28, [%r20 + %r0]
hwintr_3_39:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_39), 16, 16)) -> intp(3, 0, 25)
	ta	T_CHANGE_HPRIV
	.word 0x81982a09  ! 955: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a09, %hpstate
	.word 0xf33dc000  ! 956: STDF_R	std	%f25, [%r0, %r23]
	.word 0xb351c000  ! 958: RDPR_TL	rdpr	%tl, %r25
	.word 0x8d9560e5  ! 962: WRPR_PSTATE_I	wrpr	%r21, 0x00e5, %pstate
	.word 0xf275a0f9  ! 965: STX_I	stx	%r25, [%r22 + 0x00f9]
	.word 0xb81c8000  ! 967: XOR_R	xor 	%r18, %r0, %r28
	setx	data_start_7, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf42cc000  ! 972: STB_R	stb	%r26, [%r19 + %r0]
	mov	1, %r14
	.word 0xa193a000  ! 973: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf73d0000  ! 976: STDF_R	std	%f27, [%r0, %r20]
hwintr_3_40:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_40), 16, 16)) -> intp(3, 0, 34)
hwintr_3_41:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_41), 16, 16)) -> intp(3, 0, 7)
	.word 0xb695c000  ! 984: ORcc_R	orcc 	%r23, %r0, %r27
	.word 0xb8b54000  ! 985: ORNcc_R	orncc 	%r21, %r0, %r28
	.word 0xfa34c000  ! 987: STH_R	sth	%r29, [%r19 + %r0]
	setx	data_start_7, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfd3c8000  ! 991: STDF_R	std	%f30, [%r0, %r18]
	.word 0xf03c0000  ! 996: STD_R	std	%r24, [%r16 + %r0]
	.word 0xfe2521d6  ! 997: STW_I	stw	%r31, [%r20 + 0x01d6]
	.word 0xf8248000  ! 1001: STW_R	stw	%r28, [%r18 + %r0]
	.word 0xbb480000  ! 1004: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xfe3c2134  ! 1008: STD_I	std	%r31, [%r16 + 0x0134]
	.word 0xbd3d0000  ! 1009: SRA_R	sra 	%r20, %r0, %r30
	.word 0xf73ca013  ! 1020: STDF_I	std	%f27, [0x0013, %r18]
	.word 0xf43ce17e  ! 1023: STD_I	std	%r26, [%r19 + 0x017e]
hwintr_3_42:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_42), 16, 16)) -> intp(3, 0, 2c)
	setx	data_start_5, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81983f43  ! 1039: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f43, %hpstate
hwintr_3_43:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_43), 16, 16)) -> intp(3, 0, 2a)
	.word 0xf73de194  ! 1043: STDF_I	std	%f27, [0x0194, %r23]
	mov	1, %r12
	.word 0x8f932000  ! 1047: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x8994e0bd  ! 1048: WRPR_TICK_I	wrpr	%r19, 0x00bd, %tick
	.word 0xf02cc000  ! 1050: STB_R	stb	%r24, [%r19 + %r0]
	.word 0xbd508000  ! 1052: RDPR_TSTATE	rdpr	%tstate, %r30
	.word 0x8794a0c5  ! 1053: WRPR_TT_I	wrpr	%r18, 0x00c5, %tt
	.word 0xf53c0000  ! 1056: STDF_R	std	%f26, [%r0, %r16]
	.word 0xfa3de1a6  ! 1057: STD_I	std	%r29, [%r23 + 0x01a6]
	.word 0xba940000  ! 1058: ORcc_R	orcc 	%r16, %r0, %r29
	.word 0xb0c5c000  ! 1059: ADDCcc_R	addccc 	%r23, %r0, %r24
	.word 0xb1504000  ! 1060: RDPR_TNPC	rdpr	%tnpc, %r24
	.word 0xf8346003  ! 1063: STH_I	sth	%r28, [%r17 + 0x0003]
	.word 0xbd518000  ! 1064: RDPR_PSTATE	<illegal instruction>
	.word 0x819461fd  ! 1065: WRPR_TPC_I	wrpr	%r17, 0x01fd, %tpc
	.word 0xf13ca0b2  ! 1068: STDF_I	std	%f24, [0x00b2, %r18]
	.word 0x8d94a025  ! 1070: WRPR_PSTATE_I	wrpr	%r18, 0x0025, %pstate
hwintr_3_44:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_44), 16, 16)) -> intp(3, 0, 35)
	.word 0xb7540000  ! 1072: RDPR_GL	rdpr	%-, %r27
hwintr_3_45:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_45), 16, 16)) -> intp(3, 0, d)
	.word 0xff3dc000  ! 1074: STDF_R	std	%f31, [%r0, %r23]
	.word 0xfa258000  ! 1078: STW_R	stw	%r29, [%r22 + %r0]
	.word 0x859461aa  ! 1080: WRPR_TSTATE_I	wrpr	%r17, 0x01aa, %tstate
	.word 0xb1500000  ! 1088: RDPR_TPC	rdpr	%tpc, %r24
	.word 0xf0258000  ! 1090: STW_R	stw	%r24, [%r22 + %r0]
hwintr_3_46:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_46), 16, 16)) -> intp(3, 0, 8)
	.word 0xb7518000  ! 1092: RDPR_PSTATE	<illegal instruction>
	.word 0xf834e04a  ! 1093: STH_I	sth	%r28, [%r19 + 0x004a]
	.word 0xfb3ca0a1  ! 1100: STDF_I	std	%f29, [0x00a1, %r18]
	.word 0xb23d21e0  ! 1103: XNOR_I	xnor 	%r20, 0x01e0, %r25
hwintr_3_47:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_47), 16, 16)) -> intp(3, 0, 11)
	.word 0xfe3ca192  ! 1105: STD_I	std	%r31, [%r18 + 0x0192]
	.word 0x85956078  ! 1106: WRPR_TSTATE_I	wrpr	%r21, 0x0078, %tstate
	.word 0xf33de07b  ! 1107: STDF_I	std	%f25, [0x007b, %r23]
	.word 0xf225e1b3  ! 1108: STW_I	stw	%r25, [%r23 + 0x01b3]
	.word 0x8594e126  ! 1113: WRPR_TSTATE_I	wrpr	%r19, 0x0126, %tstate
	setx	data_start_0, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa75610a  ! 1115: STX_I	stx	%r29, [%r21 + 0x010a]
	.word 0xb22c202a  ! 1116: ANDN_I	andn 	%r16, 0x002a, %r25
	.word 0xfa24c000  ! 1117: STW_R	stw	%r29, [%r19 + %r0]
	.word 0xfc2ca11e  ! 1120: STB_I	stb	%r30, [%r18 + 0x011e]
	setx	data_start_2, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf0242063  ! 1123: STW_I	stw	%r24, [%r16 + 0x0063]
	.word 0xf82ce00f  ! 1127: STB_I	stb	%r28, [%r19 + 0x000f]
	.word 0xb29ce0ec  ! 1130: XORcc_I	xorcc 	%r19, 0x00ec, %r25
	.word 0xf875c000  ! 1132: STX_R	stx	%r28, [%r23 + %r0]
	.word 0xfe25a1fe  ! 1142: STW_I	stw	%r31, [%r22 + 0x01fe]
hwintr_3_48:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_48), 16, 16)) -> intp(3, 0, 20)
	.word 0xfe2c0000  ! 1146: STB_R	stb	%r31, [%r16 + %r0]
	.word 0xba1d6117  ! 1149: XOR_I	xor 	%r21, 0x0117, %r29
	.word 0xb9510000  ! 1151: RDPR_TICK	rdpr	%tick, %r28
	.word 0xb3500000  ! 1152: RDPR_TPC	<illegal instruction>
	.word 0xfa34e149  ! 1153: STH_I	sth	%r29, [%r19 + 0x0149]
	.word 0xfa7561ff  ! 1154: STX_I	stx	%r29, [%r21 + 0x01ff]
	.word 0xb9510000  ! 1155: RDPR_TICK	<illegal instruction>
	.word 0xf63de15c  ! 1156: STD_I	std	%r27, [%r23 + 0x015c]
	.word 0xf024a0fa  ! 1157: STW_I	stw	%r24, [%r18 + 0x00fa]
	.word 0xf8254000  ! 1158: STW_R	stw	%r28, [%r21 + %r0]
	.word 0xbcad4000  ! 1164: ANDNcc_R	andncc 	%r21, %r0, %r30
	.word 0xfa3c20c3  ! 1165: STD_I	std	%r29, [%r16 + 0x00c3]
	.word 0xf2742115  ! 1166: STX_I	stx	%r25, [%r16 + 0x0115]
	.word 0xf22c4000  ! 1168: STB_R	stb	%r25, [%r17 + %r0]
	.word 0xbd50c000  ! 1169: RDPR_TT	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982a49  ! 1173: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a49, %hpstate
	.word 0xb0bde0d1  ! 1176: XNORcc_I	xnorcc 	%r23, 0x00d1, %r24
	.word 0xf4356024  ! 1180: STH_I	sth	%r26, [%r21 + 0x0024]
	.word 0xf87460f4  ! 1181: STX_I	stx	%r28, [%r17 + 0x00f4]
	.word 0xfa3c2195  ! 1182: STD_I	std	%r29, [%r16 + 0x0195]
	.word 0x839520fc  ! 1186: WRPR_TNPC_I	wrpr	%r20, 0x00fc, %tnpc
	.word 0xfa742160  ! 1190: STX_I	stx	%r29, [%r16 + 0x0160]
	.word 0xb7508000  ! 1191: RDPR_TSTATE	rdpr	%tstate, %r27
	.word 0xf62da066  ! 1193: STB_I	stb	%r27, [%r22 + 0x0066]
	.word 0xfa3dc000  ! 1194: STD_R	std	%r29, [%r23 + %r0]
	.word 0xf43da044  ! 1196: STD_I	std	%r26, [%r22 + 0x0044]
hwintr_3_49:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_49), 16, 16)) -> intp(3, 0, 1c)
	.word 0x8d94e102  ! 1198: WRPR_PSTATE_I	wrpr	%r19, 0x0102, %pstate
hwintr_3_50:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_50), 16, 16)) -> intp(3, 0, 6)
hwintr_3_51:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_51), 16, 16)) -> intp(3, 0, 2a)
hwintr_3_52:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_52), 16, 16)) -> intp(3, 0, 36)
	.word 0xf435e02f  ! 1209: STH_I	sth	%r26, [%r23 + 0x002f]
hwintr_3_53:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_53), 16, 16)) -> intp(3, 0, 3f)
	setx	data_start_7, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x8198299b  ! 1219: WRHPR_HPSTATE_I	wrhpr	%r0, 0x099b, %hpstate
hwintr_3_54:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_54), 16, 16)) -> intp(3, 0, 6)
	ta	T_CHANGE_HPRIV
	.word 0x81982a99  ! 1223: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a99, %hpstate
	.word 0xf8752170  ! 1228: STX_I	stx	%r28, [%r20 + 0x0170]
hwintr_3_55:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_55), 16, 16)) -> intp(3, 0, 1b)
	.word 0xf22d8000  ! 1234: STB_R	stb	%r25, [%r22 + %r0]
	.word 0xb2b4206e  ! 1235: SUBCcc_I	orncc 	%r16, 0x006e, %r25
	.word 0xf53d606e  ! 1240: STDF_I	std	%f26, [0x006e, %r21]
	.word 0x8794a188  ! 1242: WRPR_TT_I	wrpr	%r18, 0x0188, %tt
	ta	T_CHANGE_HPRIV
	.word 0x81982951  ! 1249: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0951, %hpstate
	.word 0xf83d4000  ! 1252: STD_R	std	%r28, [%r21 + %r0]
	.word 0xfa2de1fe  ! 1253: STB_I	stb	%r29, [%r23 + 0x01fe]
hwintr_3_56:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_56), 16, 16)) -> intp(3, 0, 19)
	.word 0xf73c0000  ! 1257: STDF_R	std	%f27, [%r0, %r16]
	.word 0xf73da03c  ! 1258: STDF_I	std	%f27, [0x003c, %r22]
	.word 0xf42dc000  ! 1260: STB_R	stb	%r26, [%r23 + %r0]
	.word 0xf13d2153  ! 1263: STDF_I	std	%f24, [0x0153, %r20]
	.word 0xbb500000  ! 1264: RDPR_TPC	rdpr	%tpc, %r29
hwintr_3_57:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_57), 16, 16)) -> intp(3, 0, 0)
	.word 0xf634a1d8  ! 1267: STH_I	sth	%r27, [%r18 + 0x01d8]
	.word 0xf0754000  ! 1269: STX_R	stx	%r24, [%r21 + %r0]
	.word 0xfc24a060  ! 1270: STW_I	stw	%r30, [%r18 + 0x0060]
	.word 0x87946086  ! 1273: WRPR_TT_I	wrpr	%r17, 0x0086, %tt
	.word 0x8995a068  ! 1274: WRPR_TICK_I	wrpr	%r22, 0x0068, %tick
	mov	0, %r14
	.word 0xa193a000  ! 1276: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_3_58:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_58), 16, 16)) -> intp(3, 0, 1c)
hwintr_3_59:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_59), 16, 16)) -> intp(3, 0, 37)
	.word 0xfe742078  ! 1282: STX_I	stx	%r31, [%r16 + 0x0078]
hwintr_3_60:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_60), 16, 16)) -> intp(3, 0, 38)
	.word 0xbc458000  ! 1287: ADDC_R	addc 	%r22, %r0, %r30
	.word 0xf03d4000  ! 1288: STD_R	std	%r24, [%r21 + %r0]
	.word 0xbe8d0000  ! 1289: ANDcc_R	andcc 	%r20, %r0, %r31
	.word 0xfd3ce156  ! 1290: STDF_I	std	%f30, [0x0156, %r19]
	.word 0xbebc8000  ! 1292: XNORcc_R	xnorcc 	%r18, %r0, %r31
	.word 0xf73d4000  ! 1294: STDF_R	std	%f27, [%r0, %r21]
	.word 0xf23c8000  ! 1295: STD_R	std	%r25, [%r18 + %r0]
	.word 0xf83d0000  ! 1297: STD_R	std	%r28, [%r20 + %r0]
	.word 0xb9641800  ! 1298: MOVcc_R	<illegal instruction>
	.word 0xf635a19e  ! 1302: STH_I	sth	%r27, [%r22 + 0x019e]
	.word 0xfa752079  ! 1303: STX_I	stx	%r29, [%r20 + 0x0079]
	.word 0xf2358000  ! 1308: STH_R	sth	%r25, [%r22 + %r0]
	.word 0xfc2c61d4  ! 1310: STB_I	stb	%r30, [%r17 + 0x01d4]
hwintr_3_61:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_61), 16, 16)) -> intp(3, 0, b)
	.word 0xfe3ca0d3  ! 1314: STD_I	std	%r31, [%r18 + 0x00d3]
	.word 0xf435a1d0  ! 1315: STH_I	sth	%r26, [%r22 + 0x01d0]
	.word 0xf02ce046  ! 1317: STB_I	stb	%r24, [%r19 + 0x0046]
	.word 0xf43ce125  ! 1319: STD_I	std	%r26, [%r19 + 0x0125]
	.word 0xb81d8000  ! 1324: XOR_R	xor 	%r22, %r0, %r28
	.word 0xf235e1b9  ! 1329: STH_I	sth	%r25, [%r23 + 0x01b9]
	.word 0xb8bc4000  ! 1332: XNORcc_R	xnorcc 	%r17, %r0, %r28
	setx	data_start_0, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_62:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_62), 16, 16)) -> intp(3, 0, 1b)
	.word 0xf93d8000  ! 1337: STDF_R	std	%f28, [%r0, %r22]
	.word 0xb2b40000  ! 1338: ORNcc_R	orncc 	%r16, %r0, %r25
	.word 0xf63d213a  ! 1339: STD_I	std	%r27, [%r20 + 0x013a]
	.word 0xf835e036  ! 1351: STH_I	sth	%r28, [%r23 + 0x0036]
	setx	data_start_5, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81982ec1  ! 1353: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0ec1, %hpstate
	.word 0xf93c4000  ! 1357: STDF_R	std	%f28, [%r0, %r17]
	.word 0xf024a060  ! 1358: STW_I	stw	%r24, [%r18 + 0x0060]
	.word 0xfc3c0000  ! 1360: STD_R	std	%r30, [%r16 + %r0]
	.word 0x8795e19f  ! 1361: WRPR_TT_I	wrpr	%r23, 0x019f, %tt
	.word 0xfa346071  ! 1363: STH_I	sth	%r29, [%r17 + 0x0071]
	.word 0xb1520000  ! 1367: RDPR_PIL	rdpr	%pil, %r24
	.word 0xfe7461e3  ! 1369: STX_I	stx	%r31, [%r17 + 0x01e3]
	.word 0xfe340000  ! 1371: STH_R	sth	%r31, [%r16 + %r0]
	.word 0xb7480000  ! 1374: RDHPR_HPSTATE	rdhpr	%hpstate, %r27
	.word 0xfc754000  ! 1376: STX_R	stx	%r30, [%r21 + %r0]
	.word 0xf2258000  ! 1379: STW_R	stw	%r25, [%r22 + %r0]
	.word 0xf43d8000  ! 1380: STD_R	std	%r26, [%r22 + %r0]
	mov	1, %r14
	.word 0xa193a000  ! 1383: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_3_63:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_63), 16, 16)) -> intp(3, 0, 8)
	.word 0xf63c0000  ! 1390: STD_R	std	%r27, [%r16 + %r0]
hwintr_3_64:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_64), 16, 16)) -> intp(3, 0, 28)
	.word 0x919560c9  ! 1393: WRPR_PIL_I	wrpr	%r21, 0x00c9, %pil
	.word 0xfc2c6135  ! 1396: STB_I	stb	%r30, [%r17 + 0x0135]
	.word 0xfa24e186  ! 1397: STW_I	stw	%r29, [%r19 + 0x0186]
	.word 0xfc258000  ! 1398: STW_R	stw	%r30, [%r22 + %r0]
	setx	data_start_4, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa3ce0a6  ! 1402: STD_I	std	%r29, [%r19 + 0x00a6]
hwintr_3_65:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_65), 16, 16)) -> intp(3, 0, 28)
	.word 0xf6350000  ! 1410: STH_R	sth	%r27, [%r20 + %r0]
	mov	0, %r14
	.word 0xa193a000  ! 1411: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb351c000  ! 1413: RDPR_TL	rdpr	%tl, %r25
	.word 0xfc340000  ! 1415: STH_R	sth	%r30, [%r16 + %r0]
	.word 0xf73cc000  ! 1417: STDF_R	std	%f27, [%r0, %r19]
	.word 0xfa3c8000  ! 1420: STD_R	std	%r29, [%r18 + %r0]
	.word 0xfe35c000  ! 1424: STH_R	sth	%r31, [%r23 + %r0]
	.word 0xb5508000  ! 1426: RDPR_TSTATE	<illegal instruction>
	.word 0xb3518000  ! 1427: RDPR_PSTATE	<illegal instruction>
	.word 0xb53c2001  ! 1428: SRA_I	sra 	%r16, 0x0001, %r26
	.word 0xf825c000  ! 1430: STW_R	stw	%r28, [%r23 + %r0]
	.word 0xf02c4000  ! 1431: STB_R	stb	%r24, [%r17 + %r0]
	.word 0xf034c000  ! 1433: STH_R	sth	%r24, [%r19 + %r0]
hwintr_3_66:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_66), 16, 16)) -> intp(3, 0, 28)
	.word 0xf475e129  ! 1437: STX_I	stx	%r26, [%r23 + 0x0129]
	.word 0xf82d4000  ! 1442: STB_R	stb	%r28, [%r21 + %r0]
	.word 0xf824a17e  ! 1443: STW_I	stw	%r28, [%r18 + 0x017e]
	.word 0xb49420d0  ! 1444: ORcc_I	orcc 	%r16, 0x00d0, %r26
hwintr_3_67:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_67), 16, 16)) -> intp(3, 0, 11)
	.word 0xbf643801  ! 1448: MOVcc_I	<illegal instruction>
	.word 0xb8ac4000  ! 1449: ANDNcc_R	andncc 	%r17, %r0, %r28
	.word 0xfd3c0000  ! 1457: STDF_R	std	%f30, [%r0, %r16]
	.word 0xfc75e001  ! 1460: STX_I	stx	%r30, [%r23 + 0x0001]
	.word 0xf83d6171  ! 1463: STD_I	std	%r28, [%r21 + 0x0171]
	.word 0xf73de091  ! 1465: STDF_I	std	%f27, [0x0091, %r23]
	.word 0xbd2df001  ! 1468: SLLX_I	sllx	%r23, 0x0001, %r30
	mov	0, %r14
	.word 0xa193a000  ! 1470: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbd3da001  ! 1473: SRA_I	sra 	%r22, 0x0001, %r30
	.word 0xb5643801  ! 1474: MOVcc_I	<illegal instruction>
	.word 0xb3520000  ! 1476: RDPR_PIL	rdpr	%pil, %r25
	.word 0xf835e156  ! 1479: STH_I	sth	%r28, [%r23 + 0x0156]
	.word 0xff3cc000  ! 1480: STDF_R	std	%f31, [%r0, %r19]
	.word 0xfc24e0a2  ! 1481: STW_I	stw	%r30, [%r19 + 0x00a2]
	.word 0xf034a02d  ! 1482: STH_I	sth	%r24, [%r18 + 0x002d]
	.word 0xbd520000  ! 1483: RDPR_PIL	<illegal instruction>
	setx	data_start_1, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa74c000  ! 1487: STX_R	stx	%r29, [%r19 + %r0]
	.word 0x9194a1c0  ! 1489: WRPR_PIL_I	wrpr	%r18, 0x01c0, %pil
	.word 0xf6240000  ! 1493: STW_R	stw	%r27, [%r16 + %r0]
	.word 0xf43c8000  ! 1494: STD_R	std	%r26, [%r18 + %r0]
	setx	data_start_2, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r20, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfc3560be  ! 1502: STH_I	sth	%r30, [%r21 + 0x00be]
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xfa25e041  ! 1512: STW_I	stw	%r29, [%r23 + 0x0041]
	.word 0x8794e059  ! 1519: WRPR_TT_I	wrpr	%r19, 0x0059, %tt
	.word 0xf33ca0f4  ! 1520: STDF_I	std	%f25, [0x00f4, %r18]
	.word 0x9194a06b  ! 1521: WRPR_PIL_I	wrpr	%r18, 0x006b, %pil
	.word 0xf634a0d4  ! 1523: STH_I	sth	%r27, [%r18 + 0x00d4]
	.word 0xfa2460c2  ! 1524: STW_I	stw	%r29, [%r17 + 0x00c2]
	.word 0xfa244000  ! 1527: STW_R	stw	%r29, [%r17 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982d99  ! 1528: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d99, %hpstate
	.word 0xfa74615d  ! 1534: STX_I	stx	%r29, [%r17 + 0x015d]
	.word 0xf02c6078  ! 1538: STB_I	stb	%r24, [%r17 + 0x0078]
hwintr_3_68:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_68), 16, 16)) -> intp(3, 0, 3a)
	mov	1, %r12
	.word 0x8f932000  ! 1541: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xff3dc000  ! 1542: STDF_R	std	%f31, [%r0, %r23]
	.word 0x8d95e128  ! 1546: WRPR_PSTATE_I	wrpr	%r23, 0x0128, %pstate
	.word 0xf13da01c  ! 1550: STDF_I	std	%f24, [0x001c, %r22]
	.word 0xf73c21a0  ! 1557: STDF_I	std	%f27, [0x01a0, %r16]
	setx	data_start_7, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf83c21d7  ! 1564: STD_I	std	%r28, [%r16 + 0x01d7]
	mov	1, %r12
	.word 0x8f932000  ! 1566: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_3_69:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_69), 16, 16)) -> intp(3, 0, 12)
	.word 0xf03461e2  ! 1571: STH_I	sth	%r24, [%r17 + 0x01e2]
	.word 0xbf3c6001  ! 1574: SRA_I	sra 	%r17, 0x0001, %r31
	.word 0xfa2d2033  ! 1577: STB_I	stb	%r29, [%r20 + 0x0033]
	.word 0xfe74615b  ! 1582: STX_I	stx	%r31, [%r17 + 0x015b]
	ta	T_CHANGE_HPRIV
	.word 0x81982c11  ! 1584: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c11, %hpstate
	.word 0xfa240000  ! 1595: STW_R	stw	%r29, [%r16 + %r0]
	.word 0xf82dc000  ! 1596: STB_R	stb	%r28, [%r23 + %r0]
	mov	0, %r14
	.word 0xa193a000  ! 1599: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfe3da0a0  ! 1600: STD_I	std	%r31, [%r22 + 0x00a0]
	.word 0xf93ca02c  ! 1603: STDF_I	std	%f28, [0x002c, %r18]
	.word 0xf82d0000  ! 1606: STB_R	stb	%r28, [%r20 + %r0]
	.word 0xb7520000  ! 1607: RDPR_PIL	rdpr	%pil, %r27
	.word 0xf62d0000  ! 1608: STB_R	stb	%r27, [%r20 + %r0]
	.word 0x8595a10b  ! 1618: WRPR_TSTATE_I	wrpr	%r22, 0x010b, %tstate
	.word 0xfe344000  ! 1623: STH_R	sth	%r31, [%r17 + %r0]
	.word 0xf2748000  ! 1625: STX_R	stx	%r25, [%r18 + %r0]
	.word 0xbd520000  ! 1629: RDPR_PIL	rdpr	%pil, %r30
	.word 0xf075a0ba  ! 1630: STX_I	stx	%r24, [%r22 + 0x00ba]
	.word 0xbb3de001  ! 1631: SRA_I	sra 	%r23, 0x0001, %r29
	.word 0xfe244000  ! 1632: STW_R	stw	%r31, [%r17 + %r0]
	.word 0xfa75c000  ! 1634: STX_R	stx	%r29, [%r23 + %r0]
	.word 0xfe75a024  ! 1635: STX_I	stx	%r31, [%r22 + 0x0024]
	.word 0xbb518000  ! 1642: RDPR_PSTATE	<illegal instruction>
	.word 0xf0348000  ! 1643: STH_R	sth	%r24, [%r18 + %r0]
	.word 0xb951c000  ! 1644: RDPR_TL	<illegal instruction>
	.word 0xf6244000  ! 1646: STW_R	stw	%r27, [%r17 + %r0]
	.word 0xfe25a099  ! 1651: STW_I	stw	%r31, [%r22 + 0x0099]
	.word 0xf224c000  ! 1652: STW_R	stw	%r25, [%r19 + %r0]
	.word 0xf47560c6  ! 1654: STX_I	stx	%r26, [%r21 + 0x00c6]
	.word 0xfb3d8000  ! 1655: STDF_R	std	%f29, [%r0, %r22]
	.word 0xbd500000  ! 1656: RDPR_TPC	<illegal instruction>
	.word 0xf2248000  ! 1657: STW_R	stw	%r25, [%r18 + %r0]
	.word 0x8994e178  ! 1661: WRPR_TICK_I	wrpr	%r19, 0x0178, %tick
	.word 0xfc358000  ! 1664: STH_R	sth	%r30, [%r22 + %r0]
	.word 0xff3ce195  ! 1666: STDF_I	std	%f31, [0x0195, %r19]
	.word 0xfc348000  ! 1668: STH_R	sth	%r30, [%r18 + %r0]
	.word 0xb61ca02b  ! 1672: XOR_I	xor 	%r18, 0x002b, %r27
	.word 0xfc2c8000  ! 1673: STB_R	stb	%r30, [%r18 + %r0]
hwintr_3_70:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_70), 16, 16)) -> intp(3, 0, 1b)
	.word 0xf33de0e7  ! 1678: STDF_I	std	%f25, [0x00e7, %r23]
	.word 0xf83c8000  ! 1679: STD_R	std	%r28, [%r18 + %r0]
	.word 0xb151c000  ! 1687: RDPR_TL	rdpr	%tl, %r24
	mov	2, %r12
	.word 0x8f932000  ! 1691: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf225c000  ! 1692: STW_R	stw	%r25, [%r23 + %r0]
	.word 0xf274a0dc  ! 1693: STX_I	stx	%r25, [%r18 + 0x00dc]
hwintr_3_71:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_71), 16, 16)) -> intp(3, 0, 37)
	.word 0xf73da1f0  ! 1697: STDF_I	std	%f27, [0x01f0, %r22]
	.word 0x8994e108  ! 1704: WRPR_TICK_I	wrpr	%r19, 0x0108, %tick
	mov	2, %r14
	.word 0xa193a000  ! 1705: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7504000  ! 1709: RDPR_TNPC	rdpr	%tnpc, %r27
hwintr_3_72:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_72), 16, 16)) -> intp(3, 0, 14)
hwintr_3_73:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_73), 16, 16)) -> intp(3, 0, e)
	.word 0xfd3d8000  ! 1715: STDF_R	std	%f30, [%r0, %r22]
	.word 0xf82c0000  ! 1717: STB_R	stb	%r28, [%r16 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982b43  ! 1719: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b43, %hpstate
	.word 0xb7510000  ! 1722: RDPR_TICK	rdpr	%tick, %r27
	.word 0xf675203a  ! 1724: STX_I	stx	%r27, [%r20 + 0x003a]
hwintr_3_74:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_74), 16, 16)) -> intp(3, 0, 7)
	.word 0xb83ce03a  ! 1727: XNOR_I	xnor 	%r19, 0x003a, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81983c8b  ! 1728: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c8b, %hpstate
hwintr_3_75:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_75), 16, 16)) -> intp(3, 0, 6)
	.word 0xfe358000  ! 1731: STH_R	sth	%r31, [%r22 + %r0]
hwintr_3_76:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_76), 16, 16)) -> intp(3, 0, 0)
	.word 0xfc2d0000  ! 1733: STB_R	stb	%r30, [%r20 + %r0]
	.word 0xf22461b3  ! 1736: STW_I	stw	%r25, [%r17 + 0x01b3]
	.word 0xb151c000  ! 1737: RDPR_TL	rdpr	%tl, %r24
	.word 0xbc3d617a  ! 1742: XNOR_I	xnor 	%r21, 0x017a, %r30
	.word 0xbac4e07a  ! 1743: ADDCcc_I	addccc 	%r19, 0x007a, %r29
	.word 0xf275e182  ! 1744: STX_I	stx	%r25, [%r23 + 0x0182]
hwintr_3_77:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_77), 16, 16)) -> intp(3, 0, 2)
	.word 0xf635a103  ! 1747: STH_I	sth	%r27, [%r22 + 0x0103]
	.word 0xfc2d8000  ! 1748: STB_R	stb	%r30, [%r22 + %r0]
	.word 0x8994a0ef  ! 1750: WRPR_TICK_I	wrpr	%r18, 0x00ef, %tick
	.word 0x8995a073  ! 1751: WRPR_TICK_I	wrpr	%r22, 0x0073, %tick
	.word 0xfc258000  ! 1757: STW_R	stw	%r30, [%r22 + %r0]
	.word 0xb3510000  ! 1758: RDPR_TICK	rdpr	%tick, %r25
	.word 0xf434e1a9  ! 1759: STH_I	sth	%r26, [%r19 + 0x01a9]
hwintr_3_78:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_78), 16, 16)) -> intp(3, 0, 1)
	.word 0xb550c000  ! 1764: RDPR_TT	<illegal instruction>
	.word 0xf875a126  ! 1766: STX_I	stx	%r28, [%r22 + 0x0126]
	.word 0xbc9cc000  ! 1769: XORcc_R	xorcc 	%r19, %r0, %r30
	.word 0xfb3c21ce  ! 1770: STDF_I	std	%f29, [0x01ce, %r16]
	.word 0x9194606a  ! 1771: WRPR_PIL_I	wrpr	%r17, 0x006a, %pil
	ta	T_CHANGE_HPRIV
	.word 0x81982c9b  ! 1773: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c9b, %hpstate
	.word 0xfb3dc000  ! 1774: STDF_R	std	%f29, [%r0, %r23]
	.word 0xfe34e06b  ! 1777: STH_I	sth	%r31, [%r19 + 0x006b]
	.word 0xf074601b  ! 1784: STX_I	stx	%r24, [%r17 + 0x001b]
	setx	data_start_4, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_79:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_79), 16, 16)) -> intp(3, 0, d)
	.word 0xfb3ce13a  ! 1797: STDF_I	std	%f29, [0x013a, %r19]
	mov	0, %r12
	.word 0x8f932000  ! 1798: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_3_80:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_80), 16, 16)) -> intp(3, 0, 5)
	ta	T_CHANGE_HPRIV
	.word 0x81982a93  ! 1805: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a93, %hpstate
	.word 0xb3508000  ! 1811: RDPR_TSTATE	rdpr	%tstate, %r25
	.word 0xbb7c6401  ! 1817: MOVR_I	movre	%r17, 0x1, %r29
	.word 0xfe240000  ! 1821: STW_R	stw	%r31, [%r16 + %r0]
	.word 0xb950c000  ! 1822: RDPR_TT	<illegal instruction>
	.word 0xfe2da047  ! 1823: STB_I	stb	%r31, [%r22 + 0x0047]
	.word 0xb57c6401  ! 1832: MOVR_I	movre	%r17, 0x1, %r26
hwintr_3_81:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_81), 16, 16)) -> intp(3, 0, 1d)
	ta	T_CHANGE_HPRIV
	.word 0x81983f01  ! 1835: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f01, %hpstate
hwintr_3_82:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_82), 16, 16)) -> intp(3, 0, 26)
	.word 0xfe3c61ea  ! 1848: STD_I	std	%r31, [%r17 + 0x01ea]
	.word 0x8d94a01e  ! 1851: WRPR_PSTATE_I	wrpr	%r18, 0x001e, %pstate
	.word 0xb5520000  ! 1854: RDPR_PIL	rdpr	%pil, %r26
	.word 0xf22c4000  ! 1855: STB_R	stb	%r25, [%r17 + %r0]
hwintr_3_83:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_83), 16, 16)) -> intp(3, 0, 21)
	.word 0xfa35213a  ! 1862: STH_I	sth	%r29, [%r20 + 0x013a]
	.word 0xfe75a051  ! 1863: STX_I	stx	%r31, [%r22 + 0x0051]
	mov	2, %r12
	.word 0x8f932000  ! 1872: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf8244000  ! 1875: STW_R	stw	%r28, [%r17 + %r0]
	.word 0xfc3c8000  ! 1876: STD_R	std	%r30, [%r18 + %r0]
	.word 0xfb3d0000  ! 1880: STDF_R	std	%f29, [%r0, %r20]
	.word 0x9194608c  ! 1882: WRPR_PIL_I	wrpr	%r17, 0x008c, %pil
	.word 0xf6342062  ! 1883: STH_I	sth	%r27, [%r16 + 0x0062]
	.word 0xf825212e  ! 1886: STW_I	stw	%r28, [%r20 + 0x012e]
	.word 0xb9518000  ! 1888: RDPR_PSTATE	rdpr	%pstate, %r28
	.word 0xf034c000  ! 1889: STH_R	sth	%r24, [%r19 + %r0]
	.word 0xb53d2001  ! 1891: SRA_I	sra 	%r20, 0x0001, %r26
	.word 0xf435603a  ! 1893: STH_I	sth	%r26, [%r21 + 0x003a]
	.word 0xf02d8000  ! 1896: STB_R	stb	%r24, [%r22 + %r0]
	.word 0xb025a070  ! 1898: SUB_I	sub 	%r22, 0x0070, %r24
	.word 0x8195e04d  ! 1899: WRPR_TPC_I	wrpr	%r23, 0x004d, %tpc
	.word 0xfc758000  ! 1900: STX_R	stx	%r30, [%r22 + %r0]
	setx	data_start_7, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf0244000  ! 1907: STW_R	stw	%r24, [%r17 + %r0]
	.word 0xf0748000  ! 1908: STX_R	stx	%r24, [%r18 + %r0]
	.word 0xb225c000  ! 1909: SUB_R	sub 	%r23, %r0, %r25
	.word 0xb7504000  ! 1911: RDPR_TNPC	rdpr	%tnpc, %r27
	.word 0x8d9460ce  ! 1915: WRPR_PSTATE_I	wrpr	%r17, 0x00ce, %pstate
hwintr_3_84:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_84), 16, 16)) -> intp(3, 0, 14)
	.word 0xb4ad0000  ! 1930: ANDNcc_R	andncc 	%r20, %r0, %r26
	.word 0xfc2c61ec  ! 1932: STB_I	stb	%r30, [%r17 + 0x01ec]
	.word 0xf22520b8  ! 1933: STW_I	stw	%r25, [%r20 + 0x00b8]
	.word 0xfe2c8000  ! 1935: STB_R	stb	%r31, [%r18 + %r0]
	.word 0x819460fa  ! 1936: WRPR_TPC_I	wrpr	%r17, 0x00fa, %tpc
hwintr_3_85:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_85), 16, 16)) -> intp(3, 0, 39)
	.word 0xf42de148  ! 1942: STB_I	stb	%r26, [%r23 + 0x0148]
	.word 0x9195a197  ! 1943: WRPR_PIL_I	wrpr	%r22, 0x0197, %pil
	.word 0xf824a0b7  ! 1945: STW_I	stw	%r28, [%r18 + 0x00b7]
	.word 0x8d94216d  ! 1946: WRPR_PSTATE_I	wrpr	%r16, 0x016d, %pstate
	.word 0xb3340000  ! 1947: SRL_R	srl 	%r16, %r0, %r25
	.word 0xf23d207f  ! 1950: STD_I	std	%r25, [%r20 + 0x007f]
hwintr_3_86:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_86), 16, 16)) -> intp(3, 0, 20)
	.word 0xfc7520f9  ! 1953: STX_I	stx	%r30, [%r20 + 0x00f9]
	.word 0xbb51c000  ! 1954: RDPR_TL	rdpr	%tl, %r29
	.word 0xfe240000  ! 1956: STW_R	stw	%r31, [%r16 + %r0]
	.word 0xb694e040  ! 1958: ORcc_I	orcc 	%r19, 0x0040, %r27
	.word 0xf22c4000  ! 1963: STB_R	stb	%r25, [%r17 + %r0]
hwintr_3_87:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_87), 16, 16)) -> intp(3, 0, 17)
	.word 0xb33ce001  ! 1965: SRA_I	sra 	%r19, 0x0001, %r25
hwintr_3_88:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_88), 16, 16)) -> intp(3, 0, 37)
	.word 0xf23c4000  ! 1969: STD_R	std	%r25, [%r17 + %r0]
	.word 0xf834e075  ! 1970: STH_I	sth	%r28, [%r19 + 0x0075]
	.word 0xb3508000  ! 1974: RDPR_TSTATE	<illegal instruction>
	.word 0xbf540000  ! 1978: RDPR_GL	<illegal instruction>
	.word 0x919520ca  ! 1982: WRPR_PIL_I	wrpr	%r20, 0x00ca, %pil
	.word 0x91956058  ! 1983: WRPR_PIL_I	wrpr	%r21, 0x0058, %pil
	.word 0xb7356001  ! 1985: SRL_I	srl 	%r21, 0x0001, %r27
hwintr_3_89:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_89), 16, 16)) -> intp(3, 0, 1b)
	.word 0xf475e09d  ! 1989: STX_I	stx	%r26, [%r23 + 0x009d]
	.word 0xfa258000  ! 1990: STW_R	stw	%r29, [%r22 + %r0]
	.word 0xfe3d21df  ! 1992: STD_I	std	%r31, [%r20 + 0x01df]
	.word 0xf2244000  ! 1993: STW_R	stw	%r25, [%r17 + %r0]
	mov	1, %r14
	.word 0xa193a000  ! 1996: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_3_90:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_90), 16, 16)) -> intp(3, 0, 11)
	.word 0xf03c8000  ! 2005: STD_R	std	%r24, [%r18 + %r0]
	.word 0xf43d603c  ! 2006: STD_I	std	%r26, [%r21 + 0x003c]
	.word 0x87946023  ! 2009: WRPR_TT_I	wrpr	%r17, 0x0023, %tt
	.word 0xf82c219d  ! 2010: STB_I	stb	%r28, [%r16 + 0x019d]
	.word 0xf0258000  ! 2011: STW_R	stw	%r24, [%r22 + %r0]
hwintr_3_91:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_91), 16, 16)) -> intp(3, 0, 24)
	.word 0xf024e1fd  ! 2019: STW_I	stw	%r24, [%r19 + 0x01fd]
	.word 0xf2254000  ! 2021: STW_R	stw	%r25, [%r21 + %r0]
	setx	data_start_2, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb8448000  ! 2024: ADDC_R	addc 	%r18, %r0, %r28
	.word 0xb351c000  ! 2028: RDPR_TL	rdpr	%tl, %r25
	.word 0xb1520000  ! 2029: RDPR_PIL	<illegal instruction>
hwintr_3_92:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_92), 16, 16)) -> intp(3, 0, 5)
	.word 0xf6754000  ! 2041: STX_R	stx	%r27, [%r21 + %r0]
	.word 0xfc7420db  ! 2044: STX_I	stx	%r30, [%r16 + 0x00db]
	.word 0xff3dc000  ! 2046: STDF_R	std	%f31, [%r0, %r23]
	.word 0xf8348000  ! 2051: STH_R	sth	%r28, [%r18 + %r0]
	.word 0xfc342048  ! 2052: STH_I	sth	%r30, [%r16 + 0x0048]
	.word 0x8195e163  ! 2056: WRPR_TPC_I	wrpr	%r23, 0x0163, %tpc
	.word 0xfa340000  ! 2057: STH_R	sth	%r29, [%r16 + %r0]
	.word 0xfa3ca189  ! 2059: STD_I	std	%r29, [%r18 + 0x0189]
	.word 0xb02c8000  ! 2060: ANDN_R	andn 	%r18, %r0, %r24
	.word 0xf474611c  ! 2062: STX_I	stx	%r26, [%r17 + 0x011c]
	.word 0x8194e0eb  ! 2064: WRPR_TPC_I	wrpr	%r19, 0x00eb, %tpc
	.word 0xba8de1f1  ! 2067: ANDcc_I	andcc 	%r23, 0x01f1, %r29
	.word 0xf6754000  ! 2073: STX_R	stx	%r27, [%r21 + %r0]
	.word 0xf23dc000  ! 2074: STD_R	std	%r25, [%r23 + %r0]
	.word 0xf93c2058  ! 2078: STDF_I	std	%f28, [0x0058, %r16]
hwintr_3_93:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_93), 16, 16)) -> intp(3, 0, 3f)
	.word 0xfa24e05d  ! 2082: STW_I	stw	%r29, [%r19 + 0x005d]
	.word 0xf03420ac  ! 2085: STH_I	sth	%r24, [%r16 + 0x00ac]
	.word 0xfa340000  ! 2087: STH_R	sth	%r29, [%r16 + %r0]
	.word 0xf02560d8  ! 2089: STW_I	stw	%r24, [%r21 + 0x00d8]
	.word 0xb3504000  ! 2094: RDPR_TNPC	rdpr	%tnpc, %r25
	.word 0x8395e1b5  ! 2096: WRPR_TNPC_I	wrpr	%r23, 0x01b5, %tnpc
	.word 0xf6240000  ! 2106: STW_R	stw	%r27, [%r16 + %r0]
hwintr_3_94:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_94), 16, 16)) -> intp(3, 0, 3a)
	.word 0xb1480000  ! 2109: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xb3510000  ! 2111: RDPR_TICK	<illegal instruction>
	.word 0xfe74a188  ! 2112: STX_I	stx	%r31, [%r18 + 0x0188]
	.word 0xb015a030  ! 2113: OR_I	or 	%r22, 0x0030, %r24
	.word 0x899460b8  ! 2115: WRPR_TICK_I	wrpr	%r17, 0x00b8, %tick
	.word 0xf0758000  ! 2120: STX_R	stx	%r24, [%r22 + %r0]
	.word 0xb951c000  ! 2122: RDPR_TL	rdpr	%tl, %r28
	.word 0xba046114  ! 2123: ADD_I	add 	%r17, 0x0114, %r29
	.word 0xfd3d60df  ! 2127: STDF_I	std	%f30, [0x00df, %r21]
	.word 0xbe854000  ! 2128: ADDcc_R	addcc 	%r21, %r0, %r31
	.word 0xb2244000  ! 2130: SUB_R	sub 	%r17, %r0, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81982899  ! 2131: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0899, %hpstate
	.word 0xf13c0000  ! 2136: STDF_R	std	%f24, [%r0, %r16]
	mov	0, %r12
	.word 0x8f932000  ! 2138: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_3_95:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_95), 16, 16)) -> intp(3, 0, 11)
	.word 0xb235a120  ! 2143: SUBC_I	orn 	%r22, 0x0120, %r25
hwintr_3_96:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_96), 16, 16)) -> intp(3, 0, 39)
	.word 0xfa3421f8  ! 2145: STH_I	sth	%r29, [%r16 + 0x01f8]
	.word 0xf8358000  ! 2147: STH_R	sth	%r28, [%r22 + %r0]
	mov	0, %r14
	.word 0xa193a000  ! 2148: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfa34c000  ! 2151: STH_R	sth	%r29, [%r19 + %r0]
	.word 0xf0344000  ! 2153: STH_R	sth	%r24, [%r17 + %r0]
	setx	data_start_6, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb3504000  ! 2156: RDPR_TNPC	rdpr	%tnpc, %r25
	.word 0xf6250000  ! 2158: STW_R	stw	%r27, [%r20 + %r0]
	.word 0xf6256162  ! 2159: STW_I	stw	%r27, [%r21 + 0x0162]
	mov	0, %r12
	.word 0x8f932000  ! 2161: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x85956169  ! 2167: WRPR_TSTATE_I	wrpr	%r21, 0x0169, %tstate
	.word 0xfc2d0000  ! 2169: STB_R	stb	%r30, [%r20 + %r0]
	.word 0xf275c000  ! 2172: STX_R	stx	%r25, [%r23 + %r0]
	.word 0xbf510000  ! 2173: RDPR_TICK	rdpr	%tick, %r31
	.word 0xf23460eb  ! 2177: STH_I	sth	%r25, [%r17 + 0x00eb]
	.word 0xf62de18d  ! 2179: STB_I	stb	%r27, [%r23 + 0x018d]
	.word 0x859560c4  ! 2186: WRPR_TSTATE_I	wrpr	%r21, 0x00c4, %tstate
	.word 0xb7510000  ! 2192: RDPR_TICK	rdpr	%tick, %r27
	.word 0xfc74e1e2  ! 2196: STX_I	stx	%r30, [%r19 + 0x01e2]
	.word 0xf4250000  ! 2198: STW_R	stw	%r26, [%r20 + %r0]
hwintr_3_97:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_97), 16, 16)) -> intp(3, 0, 1e)
	mov	1, %r12
	.word 0x8f932000  ! 2202: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb1510000  ! 2207: RDPR_TICK	rdpr	%tick, %r24
hwintr_3_98:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_98), 16, 16)) -> intp(3, 0, 30)
	.word 0xf6354000  ! 2210: STH_R	sth	%r27, [%r21 + %r0]
	.word 0xfa2460c5  ! 2211: STW_I	stw	%r29, [%r17 + 0x00c5]
	.word 0xf2748000  ! 2212: STX_R	stx	%r25, [%r18 + %r0]
	.word 0xf8258000  ! 2215: STW_R	stw	%r28, [%r22 + %r0]
	.word 0xf224e104  ! 2216: STW_I	stw	%r25, [%r19 + 0x0104]
	.word 0x8795a168  ! 2218: WRPR_TT_I	wrpr	%r22, 0x0168, %tt
hwintr_3_99:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_99), 16, 16)) -> intp(3, 0, 25)
	.word 0xfc3c0000  ! 2221: STD_R	std	%r30, [%r16 + %r0]
	.word 0xf4340000  ! 2223: STH_R	sth	%r26, [%r16 + %r0]
	.word 0xfc250000  ! 2224: STW_R	stw	%r30, [%r20 + %r0]
	.word 0xb9508000  ! 2228: RDPR_TSTATE	rdpr	%tstate, %r28
	mov	2, %r12
	.word 0x8f932000  ! 2230: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf42c8000  ! 2231: STB_R	stb	%r26, [%r18 + %r0]
hwintr_3_100:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_100), 16, 16)) -> intp(3, 0, 1c)
	.word 0xbd2d5000  ! 2233: SLLX_R	sllx	%r21, %r0, %r30
	.word 0xff3c20b4  ! 2234: STDF_I	std	%f31, [0x00b4, %r16]
	ta	T_CHANGE_HPRIV
	.word 0x81982d59  ! 2240: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d59, %hpstate
hwintr_3_101:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_101), 16, 16)) -> intp(3, 0, 8)
	.word 0xf8248000  ! 2244: STW_R	stw	%r28, [%r18 + %r0]
	.word 0xb3643801  ! 2246: MOVcc_I	<illegal instruction>
	.word 0xb5643801  ! 2256: MOVcc_I	<illegal instruction>
	.word 0xbd50c000  ! 2258: RDPR_TT	rdpr	%tt, %r30
	.word 0xf03ca0a7  ! 2265: STD_I	std	%r24, [%r18 + 0x00a7]
hwintr_3_102:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_102), 16, 16)) -> intp(3, 0, 25)
	.word 0xf53c6131  ! 2271: STDF_I	std	%f26, [0x0131, %r17]
hwintr_3_103:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_103), 16, 16)) -> intp(3, 0, 1f)
	.word 0xb1504000  ! 2274: RDPR_TNPC	rdpr	%tnpc, %r24
	mov	1, %r14
	.word 0xa193a000  ! 2277: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf33ca07d  ! 2278: STDF_I	std	%f25, [0x007d, %r18]
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xb8a44000  ! 2281: SUBcc_R	subcc 	%r17, %r0, %r28
hwintr_3_104:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_104), 16, 16)) -> intp(3, 0, d)
	.word 0xb1500000  ! 2292: RDPR_TPC	rdpr	%tpc, %r24
	.word 0xf8754000  ! 2293: STX_R	stx	%r28, [%r21 + %r0]
	.word 0xb495e163  ! 2296: ORcc_I	orcc 	%r23, 0x0163, %r26
	.word 0xf634a093  ! 2301: STH_I	sth	%r27, [%r18 + 0x0093]
	.word 0x899461ea  ! 2309: WRPR_TICK_I	wrpr	%r17, 0x01ea, %tick
	.word 0xf13d8000  ! 2312: STDF_R	std	%f24, [%r0, %r22]
	.word 0x9194607b  ! 2317: WRPR_PIL_I	wrpr	%r17, 0x007b, %pil
	.word 0xfd3d208e  ! 2319: STDF_I	std	%f30, [0x008e, %r20]
	.word 0xf475216e  ! 2322: STX_I	stx	%r26, [%r20 + 0x016e]
	.word 0xfb3cc000  ! 2323: STDF_R	std	%f29, [%r0, %r19]
hwintr_3_105:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_105), 16, 16)) -> intp(3, 0, 0)
	.word 0xfa24e0b1  ! 2326: STW_I	stw	%r29, [%r19 + 0x00b1]
	ta	T_CHANGE_HPRIV
	.word 0x81982f89  ! 2327: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f89, %hpstate
	.word 0xf13d8000  ! 2329: STDF_R	std	%f24, [%r0, %r22]
	.word 0xfa3d4000  ! 2330: STD_R	std	%r29, [%r21 + %r0]
	.word 0xbf520000  ! 2332: RDPR_PIL	rdpr	%pil, %r31
	.word 0xbb504000  ! 2334: RDPR_TNPC	<illegal instruction>
hwintr_3_106:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_106), 16, 16)) -> intp(3, 0, 24)
	.word 0xf83ca1d0  ! 2338: STD_I	std	%r28, [%r18 + 0x01d0]
	.word 0xbb508000  ! 2339: RDPR_TSTATE	<illegal instruction>
	.word 0xf0256037  ! 2340: STW_I	stw	%r24, [%r21 + 0x0037]
	.word 0xb3520000  ! 2341: RDPR_PIL	<illegal instruction>
	.word 0xf83d217b  ! 2342: STD_I	std	%r28, [%r20 + 0x017b]
hwintr_3_107:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_107), 16, 16)) -> intp(3, 0, 17)
	.word 0xfe258000  ! 2349: STW_R	stw	%r31, [%r22 + %r0]
	.word 0xb5508000  ! 2351: RDPR_TSTATE	<illegal instruction>
	.word 0xb0adc000  ! 2353: ANDNcc_R	andncc 	%r23, %r0, %r24
	.word 0xbf50c000  ! 2355: RDPR_TT	<illegal instruction>
hwintr_3_108:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_108), 16, 16)) -> intp(3, 0, 19)
	ta	T_CHANGE_HPRIV
	.word 0x81983d0b  ! 2358: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d0b, %hpstate
	.word 0xfa3c207d  ! 2360: STD_I	std	%r29, [%r16 + 0x007d]
	.word 0xb4a5a10f  ! 2361: SUBcc_I	subcc 	%r22, 0x010f, %r26
	.word 0xfe24a148  ! 2362: STW_I	stw	%r31, [%r18 + 0x0148]
	.word 0xfd3ce070  ! 2363: STDF_I	std	%f30, [0x0070, %r19]
	.word 0xb6852099  ! 2365: ADDcc_I	addcc 	%r20, 0x0099, %r27
	.word 0xf6344000  ! 2366: STH_R	sth	%r27, [%r17 + %r0]
	mov	2, %r12
	.word 0x8f932000  ! 2367: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfe2c4000  ! 2368: STB_R	stb	%r31, [%r17 + %r0]
	.word 0xb9504000  ! 2369: RDPR_TNPC	rdpr	%tnpc, %r28
	.word 0x859461db  ! 2371: WRPR_TSTATE_I	wrpr	%r17, 0x01db, %tstate
	.word 0xf024e02d  ! 2372: STW_I	stw	%r24, [%r19 + 0x002d]
	.word 0xfa25c000  ! 2376: STW_R	stw	%r29, [%r23 + %r0]
	.word 0xf83521bd  ! 2381: STH_I	sth	%r28, [%r20 + 0x01bd]
	.word 0xb49c0000  ! 2385: XORcc_R	xorcc 	%r16, %r0, %r26
	.word 0x8d956190  ! 2388: WRPR_PSTATE_I	wrpr	%r21, 0x0190, %pstate
	.word 0xbb2da001  ! 2389: SLL_I	sll 	%r22, 0x0001, %r29
	.word 0xb13ca001  ! 2392: SRA_I	sra 	%r18, 0x0001, %r24
	.word 0xb0252114  ! 2393: SUB_I	sub 	%r20, 0x0114, %r24
	.word 0xf2352099  ! 2394: STH_I	sth	%r25, [%r20 + 0x0099]
	.word 0xb41460ed  ! 2395: OR_I	or 	%r17, 0x00ed, %r26
	.word 0xbe354000  ! 2397: ORN_R	orn 	%r21, %r0, %r31
	.word 0xfd3de049  ! 2398: STDF_I	std	%f30, [0x0049, %r23]
	.word 0xfc2c0000  ! 2399: STB_R	stb	%r30, [%r16 + %r0]
	.word 0xf434c000  ! 2400: STH_R	sth	%r26, [%r19 + %r0]
	.word 0xf62c6026  ! 2402: STB_I	stb	%r27, [%r17 + 0x0026]
	.word 0xf224a143  ! 2403: STW_I	stw	%r25, [%r18 + 0x0143]
	.word 0xb150c000  ! 2405: RDPR_TT	rdpr	%tt, %r24
hwintr_3_109:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_109), 16, 16)) -> intp(3, 0, 3a)
	.word 0xf63ce19c  ! 2419: STD_I	std	%r27, [%r19 + 0x019c]
	.word 0xf83c8000  ! 2420: STD_R	std	%r28, [%r18 + %r0]
	.word 0xf63cc000  ! 2422: STD_R	std	%r27, [%r19 + %r0]
	mov	2, %r14
	.word 0xa193a000  ! 2427: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbc2d2158  ! 2434: ANDN_I	andn 	%r20, 0x0158, %r30
	.word 0xfc340000  ! 2437: STH_R	sth	%r30, [%r16 + %r0]
	.word 0xfe35e07e  ! 2441: STH_I	sth	%r31, [%r23 + 0x007e]
	.word 0xf02ce168  ! 2446: STB_I	stb	%r24, [%r19 + 0x0168]
	.word 0xf42421c6  ! 2451: STW_I	stw	%r26, [%r16 + 0x01c6]
	.word 0xfc2d4000  ! 2452: STB_R	stb	%r30, [%r21 + %r0]
	.word 0xbea560e8  ! 2454: SUBcc_I	subcc 	%r21, 0x00e8, %r31
hwintr_3_110:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_110), 16, 16)) -> intp(3, 0, 23)
	.word 0xf73d4000  ! 2460: STDF_R	std	%f27, [%r0, %r21]
	.word 0xb5508000  ! 2462: RDPR_TSTATE	rdpr	%tstate, %r26
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81983b53  ! 2464: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b53, %hpstate
	.word 0xf62de01c  ! 2465: STB_I	stb	%r27, [%r23 + 0x001c]
	.word 0x89952186  ! 2467: WRPR_TICK_I	wrpr	%r20, 0x0186, %tick
	.word 0xb6b5c000  ! 2468: ORNcc_R	orncc 	%r23, %r0, %r27
	.word 0xf235e1eb  ! 2470: STH_I	sth	%r25, [%r23 + 0x01eb]
	.word 0xf53c0000  ! 2471: STDF_R	std	%f26, [%r0, %r16]
	.word 0xb1480000  ! 2474: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xb950c000  ! 2475: RDPR_TT	<illegal instruction>
hwintr_3_111:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_111), 16, 16)) -> intp(3, 0, 17)
	.word 0xfd3c2008  ! 2477: STDF_I	std	%f30, [0x0008, %r16]
	.word 0xb7510000  ! 2478: RDPR_TICK	<illegal instruction>
	.word 0x8995e1ad  ! 2479: WRPR_TICK_I	wrpr	%r23, 0x01ad, %tick
	.word 0xf6254000  ! 2481: STW_R	stw	%r27, [%r21 + %r0]
hwintr_3_112:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_112), 16, 16)) -> intp(3, 0, 2d)
	.word 0xb5504000  ! 2485: RDPR_TNPC	rdpr	%tnpc, %r26
hwintr_3_113:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_113), 16, 16)) -> intp(3, 0, 39)
	.word 0xfc240000  ! 2488: STW_R	stw	%r30, [%r16 + %r0]
	.word 0xf62d4000  ! 2489: STB_R	stb	%r27, [%r21 + %r0]
	.word 0xf13da156  ! 2492: STDF_I	std	%f24, [0x0156, %r22]
	.word 0xf22c0000  ! 2497: STB_R	stb	%r25, [%r16 + %r0]
hwintr_3_114:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_114), 16, 16)) -> intp(3, 0, 2f)
	.word 0xb9500000  ! 2503: RDPR_TPC	<illegal instruction>
	.word 0xf03d210c  ! 2507: STD_I	std	%r24, [%r20 + 0x010c]
	.word 0xfa2c0000  ! 2510: STB_R	stb	%r29, [%r16 + %r0]
	mov	1, %r14
	.word 0xa193a000  ! 2513: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8195a006  ! 2514: WRPR_TPC_I	wrpr	%r22, 0x0006, %tpc
	.word 0xfb3d4000  ! 2515: STDF_R	std	%f29, [%r0, %r21]
	.word 0xf43560fd  ! 2517: STH_I	sth	%r26, [%r21 + 0x00fd]
	.word 0xbf3dd000  ! 2520: SRAX_R	srax	%r23, %r0, %r31
	.word 0xfa342080  ! 2525: STH_I	sth	%r29, [%r16 + 0x0080]
	.word 0xf8256000  ! 2533: STW_I	stw	%r28, [%r21 + 0x0000]
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
hwintr_3_115:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_115), 16, 16)) -> intp(3, 0, 1b)
	.word 0xf425c000  ! 2551: STW_R	stw	%r26, [%r23 + %r0]
	.word 0xfe3d2117  ! 2552: STD_I	std	%r31, [%r20 + 0x0117]
	.word 0xfb3d8000  ! 2554: STDF_R	std	%f29, [%r0, %r22]
	.word 0xff3c4000  ! 2555: STDF_R	std	%f31, [%r0, %r17]
	mov	1, %r12
	.word 0x8f932000  ! 2557: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfa34217a  ! 2560: STH_I	sth	%r29, [%r16 + 0x017a]
	.word 0xbf3d3001  ! 2563: SRAX_I	srax	%r20, 0x0001, %r31
	.word 0xb6c4c000  ! 2565: ADDCcc_R	addccc 	%r19, %r0, %r27
	.word 0xfc2c0000  ! 2569: STB_R	stb	%r30, [%r16 + %r0]
	.word 0x8195e0c8  ! 2572: WRPR_TPC_I	wrpr	%r23, 0x00c8, %tpc
hwintr_3_116:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_116), 16, 16)) -> intp(3, 0, 3f)
	.word 0xb00420f0  ! 2577: ADD_I	add 	%r16, 0x00f0, %r24
	.word 0xf73ca199  ! 2581: STDF_I	std	%f27, [0x0199, %r18]
	.word 0xf235e03e  ! 2583: STH_I	sth	%r25, [%r23 + 0x003e]
	.word 0xbf508000  ! 2584: RDPR_TSTATE	rdpr	%tstate, %r31
	.word 0xf6348000  ! 2585: STH_R	sth	%r27, [%r18 + %r0]
	.word 0xf6756069  ! 2586: STX_I	stx	%r27, [%r21 + 0x0069]
	.word 0xf6258000  ! 2590: STW_R	stw	%r27, [%r22 + %r0]
	.word 0xbcb52181  ! 2592: ORNcc_I	orncc 	%r20, 0x0181, %r30
hwintr_3_117:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_117), 16, 16)) -> intp(3, 0, 1d)
	.word 0xf234c000  ! 2595: STH_R	sth	%r25, [%r19 + %r0]
	.word 0xf53c6095  ! 2601: STDF_I	std	%f26, [0x0095, %r17]
	.word 0xf025e096  ! 2604: STW_I	stw	%r24, [%r23 + 0x0096]
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81982c91  ! 2607: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c91, %hpstate
	.word 0xbd50c000  ! 2608: RDPR_TT	rdpr	%tt, %r30
	.word 0xf42d4000  ! 2609: STB_R	stb	%r26, [%r21 + %r0]
	.word 0xbf520000  ! 2610: RDPR_PIL	<illegal instruction>
	.word 0xf0752074  ! 2612: STX_I	stx	%r24, [%r20 + 0x0074]
	.word 0xfe248000  ! 2613: STW_R	stw	%r31, [%r18 + %r0]
hwintr_3_118:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_118), 16, 16)) -> intp(3, 0, 2b)
hwintr_3_119:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_119), 16, 16)) -> intp(3, 0, 38)
	.word 0xbe2d4000  ! 2619: ANDN_R	andn 	%r21, %r0, %r31
	.word 0xfa2d0000  ! 2620: STB_R	stb	%r29, [%r20 + %r0]
hwintr_3_120:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_120), 16, 16)) -> intp(3, 0, e)
	.word 0xbc050000  ! 2623: ADD_R	add 	%r20, %r0, %r30
hwintr_3_121:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_121), 16, 16)) -> intp(3, 0, 1e)
	.word 0xb1540000  ! 2633: RDPR_GL	<illegal instruction>
	.word 0xb69d20dd  ! 2635: XORcc_I	xorcc 	%r20, 0x00dd, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982acb  ! 2640: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0acb, %hpstate
hwintr_3_122:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_122), 16, 16)) -> intp(3, 0, 5)
	.word 0xf674e0ed  ! 2644: STX_I	stx	%r27, [%r19 + 0x00ed]
	.word 0xb9480000  ! 2648: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
hwintr_3_123:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_123), 16, 16)) -> intp(3, 0, 1b)
	.word 0xb7500000  ! 2653: RDPR_TPC	rdpr	%tpc, %r27
hwintr_3_124:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_124), 16, 16)) -> intp(3, 0, e)
	.word 0xf825e0a4  ! 2657: STW_I	stw	%r28, [%r23 + 0x00a4]
hwintr_3_125:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_125), 16, 16)) -> intp(3, 0, 16)
	.word 0xfd3c6154  ! 2661: STDF_I	std	%f30, [0x0154, %r17]
	.word 0xb8c44000  ! 2662: ADDCcc_R	addccc 	%r17, %r0, %r28
	.word 0xb3480000  ! 2665: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xf02c2091  ! 2666: STB_I	stb	%r24, [%r16 + 0x0091]
	.word 0xfc75e00f  ! 2667: STX_I	stx	%r30, [%r23 + 0x000f]
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xb8154000  ! 2670: OR_R	or 	%r21, %r0, %r28
	.word 0xb1352001  ! 2671: SRL_I	srl 	%r20, 0x0001, %r24
	.word 0xfa24c000  ! 2674: STW_R	stw	%r29, [%r19 + %r0]
	.word 0xf2240000  ! 2677: STW_R	stw	%r25, [%r16 + %r0]
	.word 0xf0344000  ! 2680: STH_R	sth	%r24, [%r17 + %r0]
	setx	data_start_3, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf33ca0ea  ! 2686: STDF_I	std	%f25, [0x00ea, %r18]
	.word 0xbf520000  ! 2689: RDPR_PIL	<illegal instruction>
	.word 0xb42cc000  ! 2690: ANDN_R	andn 	%r19, %r0, %r26
	setx	data_start_5, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf22d21d1  ! 2695: STB_I	stb	%r25, [%r20 + 0x01d1]
	.word 0xf53ce013  ! 2701: STDF_I	std	%f26, [0x0013, %r19]
	setx	data_start_7, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb73d8000  ! 2705: SRA_R	sra 	%r22, %r0, %r27
	.word 0xbf7ce401  ! 2709: MOVR_I	movre	%r19, 0x1, %r31
	.word 0xfe3c4000  ! 2715: STD_R	std	%r31, [%r17 + %r0]
	.word 0xbd480000  ! 2716: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xfc354000  ! 2718: STH_R	sth	%r30, [%r21 + %r0]
	.word 0xb62da07e  ! 2720: ANDN_I	andn 	%r22, 0x007e, %r27
	.word 0xf0740000  ! 2721: STX_R	stx	%r24, [%r16 + %r0]
	.word 0xfc34a03c  ! 2722: STH_I	sth	%r30, [%r18 + 0x003c]
	.word 0xf62ce13e  ! 2723: STB_I	stb	%r27, [%r19 + 0x013e]
	.word 0xf63d0000  ! 2725: STD_R	std	%r27, [%r20 + %r0]
	.word 0xfe2ce0fa  ! 2726: STB_I	stb	%r31, [%r19 + 0x00fa]
	.word 0xf825604d  ! 2727: STW_I	stw	%r28, [%r21 + 0x004d]
	.word 0x839420be  ! 2735: WRPR_TNPC_I	wrpr	%r16, 0x00be, %tnpc
	.word 0x8d95204c  ! 2737: WRPR_PSTATE_I	wrpr	%r20, 0x004c, %pstate
	.word 0xf02c4000  ! 2738: STB_R	stb	%r24, [%r17 + %r0]
	.word 0xb13c5000  ! 2739: SRAX_R	srax	%r17, %r0, %r24
	.word 0xfe2c2005  ! 2740: STB_I	stb	%r31, [%r16 + 0x0005]
	.word 0xf4246089  ! 2742: STW_I	stw	%r26, [%r17 + 0x0089]
hwintr_3_126:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_126), 16, 16)) -> intp(3, 0, 1f)
	.word 0x87956097  ! 2749: WRPR_TT_I	wrpr	%r21, 0x0097, %tt
	.word 0xf4754000  ! 2750: STX_R	stx	%r26, [%r21 + %r0]
	.word 0xf0358000  ! 2753: STH_R	sth	%r24, [%r22 + %r0]
	.word 0xbec56085  ! 2758: ADDCcc_I	addccc 	%r21, 0x0085, %r31
	.word 0x8394a16a  ! 2764: WRPR_TNPC_I	wrpr	%r18, 0x016a, %tnpc
hwintr_3_127:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_127), 16, 16)) -> intp(3, 0, 3c)
	.word 0xfc3d0000  ! 2769: STD_R	std	%r30, [%r20 + %r0]
hwintr_3_128:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_128), 16, 16)) -> intp(3, 0, 19)
	.word 0xbea4c000  ! 2772: SUBcc_R	subcc 	%r19, %r0, %r31
	.word 0xf6248000  ! 2775: STW_R	stw	%r27, [%r18 + %r0]
	setx	data_start_7, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	setx	data_start_4, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf33d4000  ! 2783: STDF_R	std	%f25, [%r0, %r21]
	.word 0xf0758000  ! 2786: STX_R	stx	%r24, [%r22 + %r0]
	.word 0x8794a1d0  ! 2789: WRPR_TT_I	wrpr	%r18, 0x01d0, %tt
	.word 0xb5480000  ! 2792: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xf674a153  ! 2793: STX_I	stx	%r27, [%r18 + 0x0153]
hwintr_3_129:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_129), 16, 16)) -> intp(3, 0, 1b)
	.word 0xf4344000  ! 2797: STH_R	sth	%r26, [%r17 + %r0]
	.word 0xf62ca113  ! 2798: STB_I	stb	%r27, [%r18 + 0x0113]
	.word 0xb2344000  ! 2805: ORN_R	orn 	%r17, %r0, %r25
hwintr_3_130:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_130), 16, 16)) -> intp(3, 0, 31)
	.word 0xfd3d6175  ! 2815: STDF_I	std	%f30, [0x0175, %r21]
	.word 0xb7510000  ! 2817: RDPR_TICK	<illegal instruction>
	.word 0xf674e1b8  ! 2818: STX_I	stx	%r27, [%r19 + 0x01b8]
	.word 0x8795a011  ! 2822: WRPR_TT_I	wrpr	%r22, 0x0011, %tt
	.word 0xfc754000  ! 2826: STX_R	stx	%r30, [%r21 + %r0]
hwintr_3_131:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_131), 16, 16)) -> intp(3, 0, 25)
	.word 0x8795a0c8  ! 2829: WRPR_TT_I	wrpr	%r22, 0x00c8, %tt
	.word 0xf43d202b  ! 2831: STD_I	std	%r26, [%r20 + 0x002b]
	.word 0xb8a561aa  ! 2838: SUBcc_I	subcc 	%r21, 0x01aa, %r28
	.word 0xbf520000  ! 2844: RDPR_PIL	rdpr	%pil, %r31
	.word 0xf22d0000  ! 2845: STB_R	stb	%r25, [%r20 + %r0]
	setx	data_start_0, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfc34217c  ! 2848: STH_I	sth	%r30, [%r16 + 0x017c]
	.word 0xbf34c000  ! 2851: SRL_R	srl 	%r19, %r0, %r31
	.word 0xb69c6174  ! 2854: XORcc_I	xorcc 	%r17, 0x0174, %r27
	.word 0x8d95604a  ! 2860: WRPR_PSTATE_I	wrpr	%r21, 0x004a, %pstate
	.word 0xfa3d2004  ! 2862: STD_I	std	%r29, [%r20 + 0x0004]
	.word 0xf53d8000  ! 2864: STDF_R	std	%f26, [%r0, %r22]
	.word 0xb8c56024  ! 2867: ADDCcc_I	addccc 	%r21, 0x0024, %r28
	.word 0xf42d0000  ! 2871: STB_R	stb	%r26, [%r20 + %r0]
	.word 0xf075e116  ! 2873: STX_I	stx	%r24, [%r23 + 0x0116]
	.word 0xbcc46135  ! 2874: ADDCcc_I	addccc 	%r17, 0x0135, %r30
	.word 0xb0842176  ! 2877: ADDcc_I	addcc 	%r16, 0x0176, %r24
	setx	data_start_2, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf02521e7  ! 2882: STW_I	stw	%r24, [%r20 + 0x01e7]
hwintr_3_132:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_132), 16, 16)) -> intp(3, 0, 4)
	.word 0x81942006  ! 2886: WRPR_TPC_I	wrpr	%r16, 0x0006, %tpc
	.word 0xf33d8000  ! 2887: STDF_R	std	%f25, [%r0, %r22]
hwintr_3_133:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_133), 16, 16)) -> intp(3, 0, 3e)
	.word 0xbd500000  ! 2892: RDPR_TPC	rdpr	%tpc, %r30
	.word 0x8d9460b6  ! 2894: WRPR_PSTATE_I	wrpr	%r17, 0x00b6, %pstate
	.word 0xbe8d2049  ! 2897: ANDcc_I	andcc 	%r20, 0x0049, %r31
	.word 0x8d94e11a  ! 2898: WRPR_PSTATE_I	wrpr	%r19, 0x011a, %pstate
	.word 0xb9520000  ! 2899: RDPR_PIL	rdpr	%pil, %r28
	.word 0xfd3c6101  ! 2902: STDF_I	std	%f30, [0x0101, %r17]
	.word 0xbf508000  ! 2907: RDPR_TSTATE	rdpr	%tstate, %r31
	.word 0xfc348000  ! 2909: STH_R	sth	%r30, [%r18 + %r0]
hwintr_3_134:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_134), 16, 16)) -> intp(3, 0, d)
	.word 0xf42ca17a  ! 2912: STB_I	stb	%r26, [%r18 + 0x017a]
	.word 0xf4744000  ! 2915: STX_R	stx	%r26, [%r17 + %r0]
	.word 0xfe34e167  ! 2928: STH_I	sth	%r31, [%r19 + 0x0167]
	.word 0xfa3cc000  ! 2932: STD_R	std	%r29, [%r19 + %r0]
	.word 0xf0754000  ! 2935: STX_R	stx	%r24, [%r21 + %r0]
	.word 0xb3510000  ! 2936: RDPR_TICK	<illegal instruction>
	mov	0, %r14
	.word 0xa193a000  ! 2940: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	ta	T_CHANGE_HPRIV
	.word 0x81983849  ! 2941: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1849, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81983c13  ! 2942: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c13, %hpstate
	.word 0xfa3c604f  ! 2944: STD_I	std	%r29, [%r17 + 0x004f]
	.word 0xfd3c6022  ! 2945: STDF_I	std	%f30, [0x0022, %r17]
	.word 0xfe75a19c  ! 2946: STX_I	stx	%r31, [%r22 + 0x019c]
	.word 0xf13c6058  ! 2949: STDF_I	std	%f24, [0x0058, %r17]
	.word 0xbf3d7001  ! 2951: SRAX_I	srax	%r21, 0x0001, %r31
hwintr_3_135:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_135), 16, 16)) -> intp(3, 0, 31)
	.word 0xb5504000  ! 2956: RDPR_TNPC	rdpr	%tnpc, %r26
	.word 0xf2352053  ! 2960: STH_I	sth	%r25, [%r20 + 0x0053]
	.word 0xf02cc000  ! 2961: STB_R	stb	%r24, [%r19 + %r0]
hwintr_3_136:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_136), 16, 16)) -> intp(3, 0, 36)
	.word 0xf83ce169  ! 2964: STD_I	std	%r28, [%r19 + 0x0169]
	.word 0xfa3561ea  ! 2966: STH_I	sth	%r29, [%r21 + 0x01ea]
	.word 0xb3504000  ! 2969: RDPR_TNPC	<illegal instruction>
hwintr_3_137:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_137), 16, 16)) -> intp(3, 0, f)
	ta	T_CHANGE_HPRIV
	.word 0x81982843  ! 2978: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0843, %hpstate
	.word 0xb8256144  ! 2980: SUB_I	sub 	%r21, 0x0144, %r28
	.word 0xf43dc000  ! 2982: STD_R	std	%r26, [%r23 + %r0]
	.word 0xf53de017  ! 2984: STDF_I	std	%f26, [0x0017, %r23]
	.word 0xf03ca137  ! 2986: STD_I	std	%r24, [%r18 + 0x0137]
	.word 0xb7508000  ! 2989: RDPR_TSTATE	rdpr	%tstate, %r27
	.word 0x89946050  ! 2992: WRPR_TICK_I	wrpr	%r17, 0x0050, %tick
	.word 0xb3510000  ! 2993: RDPR_TICK	rdpr	%tick, %r25
	.word 0xb8bd6185  ! 2994: XNORcc_I	xnorcc 	%r21, 0x0185, %r28
	.word 0xf23d0000  ! 2997: STD_R	std	%r25, [%r20 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81983f93  ! 3000: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f93, %hpstate
	.word 0xf835e099  ! 3003: STH_I	sth	%r28, [%r23 + 0x0099]
	.word 0xb03561ba  ! 3004: ORN_I	orn 	%r21, 0x01ba, %r24
hwintr_3_138:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_138), 16, 16)) -> intp(3, 0, 13)
	.word 0xbf520000  ! 3006: RDPR_PIL	rdpr	%pil, %r31
	.word 0xbec40000  ! 3009: ADDCcc_R	addccc 	%r16, %r0, %r31
	.word 0xf0748000  ! 3013: STX_R	stx	%r24, [%r18 + %r0]
	.word 0x8195a07e  ! 3016: WRPR_TPC_I	wrpr	%r22, 0x007e, %tpc
	.word 0x8394609a  ! 3017: WRPR_TNPC_I	wrpr	%r17, 0x009a, %tnpc
	.word 0xf33c8000  ! 3021: STDF_R	std	%f25, [%r0, %r18]
	.word 0xbf500000  ! 3022: RDPR_TPC	rdpr	%tpc, %r31
	.word 0xb7520000  ! 3023: RDPR_PIL	<illegal instruction>
	.word 0xfc2d8000  ! 3030: STB_R	stb	%r30, [%r22 + %r0]
	.word 0xf43da13e  ! 3032: STD_I	std	%r26, [%r22 + 0x013e]
	.word 0xf025603e  ! 3035: STW_I	stw	%r24, [%r21 + 0x003e]
	.word 0xf93c21fd  ! 3036: STDF_I	std	%f28, [0x01fd, %r16]
	.word 0xfe3d8000  ! 3037: STD_R	std	%r31, [%r22 + %r0]
	.word 0xf435e0c0  ! 3038: STH_I	sth	%r26, [%r23 + 0x00c0]
	.word 0xf93ca0ff  ! 3041: STDF_I	std	%f28, [0x00ff, %r18]
	setx	data_start_5, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa3c618e  ! 3045: STD_I	std	%r29, [%r17 + 0x018e]
	.word 0xf42c8000  ! 3050: STB_R	stb	%r26, [%r18 + %r0]
	.word 0x8195a199  ! 3052: WRPR_TPC_I	wrpr	%r22, 0x0199, %tpc
	.word 0xb3504000  ! 3054: RDPR_TNPC	rdpr	%tnpc, %r25
	.word 0xf6248000  ! 3056: STW_R	stw	%r27, [%r18 + %r0]
	.word 0xb9508000  ! 3057: RDPR_TSTATE	<illegal instruction>
	.word 0xfd3c4000  ! 3058: STDF_R	std	%f30, [%r0, %r17]
	setx	data_start_2, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfc3c8000  ! 3067: STD_R	std	%r30, [%r18 + %r0]
	.word 0xf024c000  ! 3069: STW_R	stw	%r24, [%r19 + %r0]
	.word 0x8994a1d6  ! 3071: WRPR_TICK_I	wrpr	%r18, 0x01d6, %tick
	.word 0xfa750000  ! 3073: STX_R	stx	%r29, [%r20 + %r0]
	.word 0xb57d6401  ! 3074: MOVR_I	movre	%r21, 0x1, %r26
hwintr_3_139:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_139), 16, 16)) -> intp(3, 0, 8)
	.word 0x8d95a038  ! 3078: WRPR_PSTATE_I	wrpr	%r22, 0x0038, %pstate
	.word 0xf63ca06a  ! 3079: STD_I	std	%r27, [%r18 + 0x006a]
	.word 0xf42ce0a5  ! 3082: STB_I	stb	%r26, [%r19 + 0x00a5]
	mov	2, %r14
	.word 0xa193a000  ! 3083: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf93c61b9  ! 3085: STDF_I	std	%f28, [0x01b9, %r17]
	.word 0xf33ca014  ! 3087: STDF_I	std	%f25, [0x0014, %r18]
	.word 0xf62d0000  ! 3089: STB_R	stb	%r27, [%r20 + %r0]
	.word 0x8995e083  ! 3091: WRPR_TICK_I	wrpr	%r23, 0x0083, %tick
	.word 0xf87421b1  ! 3093: STX_I	stx	%r28, [%r16 + 0x01b1]
	.word 0xb951c000  ! 3097: RDPR_TL	rdpr	%tl, %r28
hwintr_3_140:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_140), 16, 16)) -> intp(3, 0, f)
	mov	2, %r12
	.word 0x8f932000  ! 3101: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf6740000  ! 3103: STX_R	stx	%r27, [%r16 + %r0]
	.word 0xfc750000  ! 3104: STX_R	stx	%r30, [%r20 + %r0]
	.word 0xbc2d61d4  ! 3106: ANDN_I	andn 	%r21, 0x01d4, %r30
	.word 0xf47521e1  ! 3111: STX_I	stx	%r26, [%r20 + 0x01e1]
	.word 0xf274e13e  ! 3112: STX_I	stx	%r25, [%r19 + 0x013e]
	.word 0xfc3ca056  ! 3117: STD_I	std	%r30, [%r18 + 0x0056]
hwintr_3_141:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_141), 16, 16)) -> intp(3, 0, 13)
	.word 0xbf7c6401  ! 3121: MOVR_I	movre	%r17, 0x1, %r31
	.word 0xf4354000  ! 3129: STH_R	sth	%r26, [%r21 + %r0]
	.word 0xf73ce15d  ! 3132: STDF_I	std	%f27, [0x015d, %r19]
	.word 0xb3518000  ! 3135: RDPR_PSTATE	rdpr	%pstate, %r25
	.word 0xfa2de0ea  ! 3136: STB_I	stb	%r29, [%r23 + 0x00ea]
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xba85219a  ! 3145: ADDcc_I	addcc 	%r20, 0x019a, %r29
	.word 0xb37c0400  ! 3146: MOVR_R	movre	%r16, %r0, %r25
	.word 0xfb3d0000  ! 3147: STDF_R	std	%f29, [%r0, %r20]
	.word 0xf43ce0df  ! 3148: STD_I	std	%r26, [%r19 + 0x00df]
	.word 0x8194a0c1  ! 3152: WRPR_TPC_I	wrpr	%r18, 0x00c1, %tpc
hwintr_3_142:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_142), 16, 16)) -> intp(3, 0, 16)
	.word 0xf435c000  ! 3160: STH_R	sth	%r26, [%r23 + %r0]
	.word 0xb81d4000  ! 3165: XOR_R	xor 	%r21, %r0, %r28
	.word 0xb1504000  ! 3170: RDPR_TNPC	rdpr	%tnpc, %r24
	.word 0x8d94e104  ! 3171: WRPR_PSTATE_I	wrpr	%r19, 0x0104, %pstate
	.word 0xf73cc000  ! 3174: STDF_R	std	%f27, [%r0, %r19]
	.word 0xf434e0e1  ! 3181: STH_I	sth	%r26, [%r19 + 0x00e1]
	.word 0xf83421dd  ! 3183: STH_I	sth	%r28, [%r16 + 0x01dd]
	setx	data_start_7, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_143:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_143), 16, 16)) -> intp(3, 0, 2c)
	.word 0xf33c0000  ! 3190: STDF_R	std	%f25, [%r0, %r16]
	.word 0x8d95a0da  ! 3191: WRPR_PSTATE_I	wrpr	%r22, 0x00da, %pstate
	.word 0xff3c2042  ! 3194: STDF_I	std	%f31, [0x0042, %r16]
	.word 0xb5510000  ! 3196: RDPR_TICK	rdpr	%tick, %r26
hwintr_3_144:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_144), 16, 16)) -> intp(3, 0, 3a)
	.word 0xb9500000  ! 3200: RDPR_TPC	<illegal instruction>
	.word 0xfe75603f  ! 3203: STX_I	stx	%r31, [%r21 + 0x003f]
	.word 0x8794609a  ! 3215: WRPR_TT_I	wrpr	%r17, 0x009a, %tt
	.word 0xf8340000  ! 3216: STH_R	sth	%r28, [%r16 + %r0]
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xb7508000  ! 3222: RDPR_TSTATE	rdpr	%tstate, %r27
	.word 0xf2254000  ! 3223: STW_R	stw	%r25, [%r21 + %r0]
	.word 0xfa240000  ! 3225: STW_R	stw	%r29, [%r16 + %r0]
	setx	data_start_4, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_145:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_145), 16, 16)) -> intp(3, 0, 16)
	setx	data_start_1, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa74a1fc  ! 3237: STX_I	stx	%r29, [%r18 + 0x01fc]
	.word 0xb53de001  ! 3239: SRA_I	sra 	%r23, 0x0001, %r26
	.word 0xfa746088  ! 3240: STX_I	stx	%r29, [%r17 + 0x0088]
	.word 0x8794219e  ! 3241: WRPR_TT_I	wrpr	%r16, 0x019e, %tt
	.word 0xf42d2162  ! 3242: STB_I	stb	%r26, [%r20 + 0x0162]
	.word 0xb29ce0c6  ! 3245: XORcc_I	xorcc 	%r19, 0x00c6, %r25
	.word 0xb9540000  ! 3247: RDPR_GL	rdpr	%-, %r28
	.word 0x819561fe  ! 3250: WRPR_TPC_I	wrpr	%r21, 0x01fe, %tpc
	.word 0xbd7c0400  ! 3254: MOVR_R	movre	%r16, %r0, %r30
	.word 0xfe3d60ca  ! 3256: STD_I	std	%r31, [%r21 + 0x00ca]
	.word 0xfd3ca1e6  ! 3259: STDF_I	std	%f30, [0x01e6, %r18]
	mov	2, %r14
	.word 0xa193a000  ! 3260: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf825e1e2  ! 3261: STW_I	stw	%r28, [%r23 + 0x01e2]
	.word 0xfa3c6057  ! 3263: STD_I	std	%r29, [%r17 + 0x0057]
	.word 0x89942114  ! 3265: WRPR_TICK_I	wrpr	%r16, 0x0114, %tick
	mov	2, %r14
	.word 0xa193a000  ! 3269: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb8ad0000  ! 3270: ANDNcc_R	andncc 	%r20, %r0, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982bc9  ! 3271: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0bc9, %hpstate
	.word 0xfc358000  ! 3273: STH_R	sth	%r30, [%r22 + %r0]
	.word 0xb151c000  ! 3274: RDPR_TL	rdpr	%tl, %r24
hwintr_3_146:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_146), 16, 16)) -> intp(3, 0, 1c)
	.word 0xfa2d4000  ! 3276: STB_R	stb	%r29, [%r21 + %r0]
	.word 0x8395e161  ! 3278: WRPR_TNPC_I	wrpr	%r23, 0x0161, %tnpc
hwintr_3_147:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_147), 16, 16)) -> intp(3, 0, b)
	.word 0xf42c20ec  ! 3285: STB_I	stb	%r26, [%r16 + 0x00ec]
	.word 0xf83dc000  ! 3286: STD_R	std	%r28, [%r23 + %r0]
hwintr_3_148:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_148), 16, 16)) -> intp(3, 0, 35)
	.word 0xfd3d4000  ! 3289: STDF_R	std	%f30, [%r0, %r21]
hwintr_3_149:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_149), 16, 16)) -> intp(3, 0, 2b)
	setx	data_start_3, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_150:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_150), 16, 16)) -> intp(3, 0, 20)
	.word 0xfe340000  ! 3297: STH_R	sth	%r31, [%r16 + %r0]
hwintr_3_151:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_151), 16, 16)) -> intp(3, 0, 36)
	.word 0xfc248000  ! 3304: STW_R	stw	%r30, [%r18 + %r0]
	.word 0xfe74e0e7  ! 3305: STX_I	stx	%r31, [%r19 + 0x00e7]
hwintr_3_152:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_152), 16, 16)) -> intp(3, 0, 3c)
	.word 0xb53c0000  ! 3308: SRA_R	sra 	%r16, %r0, %r26
	.word 0xf874e19e  ! 3309: STX_I	stx	%r28, [%r19 + 0x019e]
	.word 0xb63d612d  ! 3310: XNOR_I	xnor 	%r21, 0x012d, %r27
	mov	0, %r12
	.word 0x8f932000  ! 3313: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb1520000  ! 3314: RDPR_PIL	rdpr	%pil, %r24
	.word 0xfc3dc000  ! 3315: STD_R	std	%r30, [%r23 + %r0]
	.word 0xfe254000  ! 3318: STW_R	stw	%r31, [%r21 + %r0]
	.word 0xb5520000  ! 3321: RDPR_PIL	<illegal instruction>
	.word 0xf82ce123  ! 3323: STB_I	stb	%r28, [%r19 + 0x0123]
	.word 0xf424e14f  ! 3328: STW_I	stw	%r26, [%r19 + 0x014f]
	.word 0xb92cf001  ! 3332: SLLX_I	sllx	%r19, 0x0001, %r28
	.word 0xfb3cc000  ! 3333: STDF_R	std	%f29, [%r0, %r19]
	.word 0xf73cc000  ! 3337: STDF_R	std	%f27, [%r0, %r19]
	.word 0xf53c61d1  ! 3341: STDF_I	std	%f26, [0x01d1, %r17]
	.word 0xfa2d8000  ! 3343: STB_R	stb	%r29, [%r22 + %r0]
	.word 0xf02cc000  ! 3344: STB_R	stb	%r24, [%r19 + %r0]
	.word 0xf074c000  ! 3346: STX_R	stx	%r24, [%r19 + %r0]
	.word 0xf62521b1  ! 3350: STW_I	stw	%r27, [%r20 + 0x01b1]
	.word 0xb63420e3  ! 3351: ORN_I	orn 	%r16, 0x00e3, %r27
	.word 0xf33c20e9  ! 3353: STDF_I	std	%f25, [0x00e9, %r16]
	.word 0xf43cc000  ! 3355: STD_R	std	%r26, [%r19 + %r0]
	.word 0xfb3ca009  ! 3356: STDF_I	std	%f29, [0x0009, %r18]
	.word 0xf07421db  ! 3359: STX_I	stx	%r24, [%r16 + 0x01db]
	.word 0xf2756044  ! 3363: STX_I	stx	%r25, [%r21 + 0x0044]
	.word 0xfe3c2155  ! 3365: STD_I	std	%r31, [%r16 + 0x0155]
	ta	T_CHANGE_HPRIV
	.word 0x81982d81  ! 3366: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d81, %hpstate
	.word 0xf02ce003  ! 3367: STB_I	stb	%r24, [%r19 + 0x0003]
	setx	data_start_5, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xbf518000  ! 3371: RDPR_PSTATE	rdpr	%pstate, %r31
hwintr_3_153:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_153), 16, 16)) -> intp(3, 0, 8)
	.word 0xf025a11c  ! 3376: STW_I	stw	%r24, [%r22 + 0x011c]
	.word 0xf6240000  ! 3377: STW_R	stw	%r27, [%r16 + %r0]
	.word 0xf33d213c  ! 3379: STDF_I	std	%f25, [0x013c, %r20]
	.word 0xb551c000  ! 3383: RDPR_TL	<illegal instruction>
	.word 0xf275e183  ! 3385: STX_I	stx	%r25, [%r23 + 0x0183]
	.word 0xf274e0cc  ! 3387: STX_I	stx	%r25, [%r19 + 0x00cc]
hwintr_3_154:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_154), 16, 16)) -> intp(3, 0, 33)
	.word 0xb9540000  ! 3393: RDPR_GL	<illegal instruction>
	.word 0xb3520000  ! 3394: RDPR_PIL	<illegal instruction>
	.word 0xf43ce1f5  ! 3398: STD_I	std	%r26, [%r19 + 0x01f5]
	.word 0x8595e050  ! 3405: WRPR_TSTATE_I	wrpr	%r23, 0x0050, %tstate
	.word 0xfc35c000  ! 3406: STH_R	sth	%r30, [%r23 + %r0]
	.word 0xf13dc000  ! 3413: STDF_R	std	%f24, [%r0, %r23]
	.word 0xf53c2081  ! 3415: STDF_I	std	%f26, [0x0081, %r16]
	.word 0x8194a050  ! 3423: WRPR_TPC_I	wrpr	%r18, 0x0050, %tpc
	mov	1, %r12
	.word 0x8f932000  ! 3426: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb335e001  ! 3428: SRL_I	srl 	%r23, 0x0001, %r25
	.word 0xb3540000  ! 3429: RDPR_GL	rdpr	%-, %r25
	.word 0xfe3dc000  ! 3430: STD_R	std	%r31, [%r23 + %r0]
	.word 0xf4242034  ! 3435: STW_I	stw	%r26, [%r16 + 0x0034]
hwintr_3_155:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_155), 16, 16)) -> intp(3, 0, f)
hwintr_3_156:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_156), 16, 16)) -> intp(3, 0, c)
	mov	0, %r14
	.word 0xa193a000  ! 3440: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbd35e001  ! 3444: SRL_I	srl 	%r23, 0x0001, %r30
	.word 0xf63d4000  ! 3445: STD_R	std	%r27, [%r21 + %r0]
	.word 0xbb2df001  ! 3446: SLLX_I	sllx	%r23, 0x0001, %r29
	.word 0xfe3c219d  ! 3447: STD_I	std	%r31, [%r16 + 0x019d]
hwintr_3_157:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_157), 16, 16)) -> intp(3, 0, a)
	.word 0xf8750000  ! 3449: STX_R	stx	%r28, [%r20 + %r0]
	.word 0xb72d1000  ! 3450: SLLX_R	sllx	%r20, %r0, %r27
	.word 0x819421fc  ! 3451: WRPR_TPC_I	wrpr	%r16, 0x01fc, %tpc
	.word 0xff3c60c1  ! 3452: STDF_I	std	%f31, [0x00c1, %r17]
hwintr_3_158:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_158), 16, 16)) -> intp(3, 0, 26)
hwintr_3_159:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_159), 16, 16)) -> intp(3, 0, 17)
	.word 0xb9641800  ! 3461: MOVcc_R	<illegal instruction>
	.word 0xfe2421df  ! 3464: STW_I	stw	%r31, [%r16 + 0x01df]
	.word 0xbd51c000  ! 3466: RDPR_TL	rdpr	%tl, %r30
hwintr_3_160:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_160), 16, 16)) -> intp(3, 0, 31)
	.word 0xb844e027  ! 3472: ADDC_I	addc 	%r19, 0x0027, %r28
	.word 0xf93d0000  ! 3473: STDF_R	std	%f28, [%r0, %r20]
	.word 0xfe3d0000  ! 3476: STD_R	std	%r31, [%r20 + %r0]
	.word 0xf4350000  ! 3480: STH_R	sth	%r26, [%r20 + %r0]
	.word 0xf73c4000  ! 3485: STDF_R	std	%f27, [%r0, %r17]
	.word 0xfa75a0be  ! 3488: STX_I	stx	%r29, [%r22 + 0x00be]
	.word 0xf0754000  ! 3489: STX_R	stx	%r24, [%r21 + %r0]
hwintr_3_161:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_161), 16, 16)) -> intp(3, 0, 8)
	.word 0xf62d0000  ! 3494: STB_R	stb	%r27, [%r20 + %r0]
hwintr_3_162:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_162), 16, 16)) -> intp(3, 0, 28)
	ta	T_CHANGE_HPRIV
	.word 0x81983993  ! 3498: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1993, %hpstate
	.word 0xb6a5c000  ! 3500: SUBcc_R	subcc 	%r23, %r0, %r27
	.word 0xf73d8000  ! 3503: STDF_R	std	%f27, [%r0, %r22]
	.word 0xf875c000  ! 3504: STX_R	stx	%r28, [%r23 + %r0]
hwintr_3_163:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_163), 16, 16)) -> intp(3, 0, 3)
	.word 0xb7518000  ! 3509: RDPR_PSTATE	rdpr	%pstate, %r27
	.word 0xfc756184  ! 3513: STX_I	stx	%r30, [%r21 + 0x0184]
	.word 0xf024a1c4  ! 3514: STW_I	stw	%r24, [%r18 + 0x01c4]
	.word 0xf83cc000  ! 3519: STD_R	std	%r28, [%r19 + %r0]
	.word 0xb0352165  ! 3520: ORN_I	orn 	%r20, 0x0165, %r24
	setx	data_start_6, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r20, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa3c0000  ! 3530: STD_R	std	%r29, [%r16 + %r0]
	.word 0xfa354000  ! 3536: STH_R	sth	%r29, [%r21 + %r0]
	.word 0xf6358000  ! 3537: STH_R	sth	%r27, [%r22 + %r0]
	.word 0xf6254000  ! 3538: STW_R	stw	%r27, [%r21 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982bdb  ! 3540: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0bdb, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81982d51  ! 3545: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d51, %hpstate
	.word 0x87946177  ! 3547: WRPR_TT_I	wrpr	%r17, 0x0177, %tt
	.word 0xbc95c000  ! 3550: ORcc_R	orcc 	%r23, %r0, %r30
	.word 0xfa3ce1e7  ! 3553: STD_I	std	%r29, [%r19 + 0x01e7]
	.word 0xf43ca135  ! 3555: STD_I	std	%r26, [%r18 + 0x0135]
	.word 0xf82560d5  ! 3558: STW_I	stw	%r28, [%r21 + 0x00d5]
hwintr_3_164:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_164), 16, 16)) -> intp(3, 0, 31)
	.word 0xf875c000  ! 3563: STX_R	stx	%r28, [%r23 + %r0]
	.word 0xf4756037  ! 3570: STX_I	stx	%r26, [%r21 + 0x0037]
	.word 0xfe750000  ! 3571: STX_R	stx	%r31, [%r20 + %r0]
	.word 0xf53c0000  ! 3579: STDF_R	std	%f26, [%r0, %r16]
	.word 0x9194617a  ! 3580: WRPR_PIL_I	wrpr	%r17, 0x017a, %pil
	.word 0xf2750000  ! 3582: STX_R	stx	%r25, [%r20 + %r0]
	.word 0xfa7421c8  ! 3583: STX_I	stx	%r29, [%r16 + 0x01c8]
	.word 0xfa3c0000  ! 3586: STD_R	std	%r29, [%r16 + %r0]
	.word 0xf22c8000  ! 3587: STB_R	stb	%r25, [%r18 + %r0]
hwintr_3_165:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_165), 16, 16)) -> intp(3, 0, 23)
	.word 0xbf3d5000  ! 3593: SRAX_R	srax	%r21, %r0, %r31
	.word 0xf825616f  ! 3599: STW_I	stw	%r28, [%r21 + 0x016f]
	.word 0xb9504000  ! 3600: RDPR_TNPC	rdpr	%tnpc, %r28
	.word 0xf07561a7  ! 3601: STX_I	stx	%r24, [%r21 + 0x01a7]
	.word 0xfd3c60cc  ! 3602: STDF_I	std	%f30, [0x00cc, %r17]
	.word 0xbe85a1a5  ! 3604: ADDcc_I	addcc 	%r22, 0x01a5, %r31
	.word 0xfc75e19d  ! 3611: STX_I	stx	%r30, [%r23 + 0x019d]
	.word 0xf435c000  ! 3618: STH_R	sth	%r26, [%r23 + %r0]
	.word 0xfa3c2166  ! 3619: STD_I	std	%r29, [%r16 + 0x0166]
	.word 0xfc2ca05e  ! 3621: STB_I	stb	%r30, [%r18 + 0x005e]
	.word 0xb5520000  ! 3624: RDPR_PIL	<illegal instruction>
	.word 0xfb3c0000  ! 3625: STDF_R	std	%f29, [%r0, %r16]
	.word 0xf93cc000  ! 3628: STDF_R	std	%f28, [%r0, %r19]
	.word 0xf024e116  ! 3631: STW_I	stw	%r24, [%r19 + 0x0116]
hwintr_3_166:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_166), 16, 16)) -> intp(3, 0, 3)
	ta	T_CHANGE_HPRIV
	.word 0x8198299b  ! 3636: WRHPR_HPSTATE_I	wrhpr	%r0, 0x099b, %hpstate
	.word 0xfa75c000  ! 3639: STX_R	stx	%r29, [%r23 + %r0]
	.word 0xf02d8000  ! 3642: STB_R	stb	%r24, [%r22 + %r0]
	.word 0xf625c000  ! 3646: STW_R	stw	%r27, [%r23 + %r0]
	.word 0xf2252068  ! 3647: STW_I	stw	%r25, [%r20 + 0x0068]
	.word 0xf43cc000  ! 3651: STD_R	std	%r26, [%r19 + %r0]
	.word 0xbcb40000  ! 3652: ORNcc_R	orncc 	%r16, %r0, %r30
	.word 0xb5510000  ! 3657: RDPR_TICK	rdpr	%tick, %r26
	.word 0xf43d609e  ! 3661: STD_I	std	%r26, [%r21 + 0x009e]
	.word 0xfc742041  ! 3662: STX_I	stx	%r30, [%r16 + 0x0041]
	.word 0xb5355000  ! 3664: SRLX_R	srlx	%r21, %r0, %r26
	.word 0xf63de13a  ! 3667: STD_I	std	%r27, [%r23 + 0x013a]
	.word 0xf4248000  ! 3670: STW_R	stw	%r26, [%r18 + %r0]
	.word 0xfa2d2150  ! 3671: STB_I	stb	%r29, [%r20 + 0x0150]
	.word 0xf8740000  ! 3675: STX_R	stx	%r28, [%r16 + %r0]
	.word 0xb0bcc000  ! 3681: XNORcc_R	xnorcc 	%r19, %r0, %r24
hwintr_3_167:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_167), 16, 16)) -> intp(3, 0, b)
	.word 0xb03d0000  ! 3684: XNOR_R	xnor 	%r20, %r0, %r24
hwintr_3_168:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_168), 16, 16)) -> intp(3, 0, 2c)
	.word 0xfd3c4000  ! 3689: STDF_R	std	%f30, [%r0, %r17]
	.word 0x8595e1d8  ! 3691: WRPR_TSTATE_I	wrpr	%r23, 0x01d8, %tstate
	.word 0xf035e1e5  ! 3692: STH_I	sth	%r24, [%r23 + 0x01e5]
	.word 0xf73c0000  ! 3693: STDF_R	std	%f27, [%r0, %r16]
	.word 0xb77d0400  ! 3694: MOVR_R	movre	%r20, %r0, %r27
	mov	0, %r14
	.word 0xa193a000  ! 3695: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8194a0f3  ! 3698: WRPR_TPC_I	wrpr	%r18, 0x00f3, %tpc
	setx	data_start_4, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb3508000  ! 3704: RDPR_TSTATE	rdpr	%tstate, %r25
	.word 0xf13de1fd  ! 3707: STDF_I	std	%f24, [0x01fd, %r23]
	.word 0xf43d8000  ! 3709: STD_R	std	%r26, [%r22 + %r0]
	.word 0xb9504000  ! 3710: RDPR_TNPC	<illegal instruction>
hwintr_3_169:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_169), 16, 16)) -> intp(3, 0, 21)
hwintr_3_170:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_170), 16, 16)) -> intp(3, 0, 12)
	.word 0xf4756157  ! 3714: STX_I	stx	%r26, [%r21 + 0x0157]
	.word 0x8395a1e1  ! 3718: WRPR_TNPC_I	wrpr	%r22, 0x01e1, %tnpc
	.word 0xfa75e184  ! 3722: STX_I	stx	%r29, [%r23 + 0x0184]
hwintr_3_171:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_171), 16, 16)) -> intp(3, 0, 14)
	.word 0xf275c000  ! 3725: STX_R	stx	%r25, [%r23 + %r0]
	.word 0xf235a04c  ! 3732: STH_I	sth	%r25, [%r22 + 0x004c]
	.word 0xb22d0000  ! 3734: ANDN_R	andn 	%r20, %r0, %r25
hwintr_3_172:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_172), 16, 16)) -> intp(3, 0, 39)
	.word 0x8995e1ae  ! 3740: WRPR_TICK_I	wrpr	%r23, 0x01ae, %tick
	.word 0xf83cc000  ! 3741: STD_R	std	%r28, [%r19 + %r0]
	.word 0xf2746107  ! 3742: STX_I	stx	%r25, [%r17 + 0x0107]
	.word 0xb1480000  ! 3747: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xf82d4000  ! 3748: STB_R	stb	%r28, [%r21 + %r0]
	.word 0xba0c0000  ! 3751: AND_R	and 	%r16, %r0, %r29
	.word 0xf73c606a  ! 3752: STDF_I	std	%f27, [0x006a, %r17]
	.word 0x85946088  ! 3756: WRPR_TSTATE_I	wrpr	%r17, 0x0088, %tstate
	.word 0xfc358000  ! 3757: STH_R	sth	%r30, [%r22 + %r0]
	.word 0xfe2cc000  ! 3758: STB_R	stb	%r31, [%r19 + %r0]
hwintr_3_173:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_173), 16, 16)) -> intp(3, 0, 2a)
	.word 0xfe3de0b7  ! 3768: STD_I	std	%r31, [%r23 + 0x00b7]
	.word 0xfc746044  ! 3769: STX_I	stx	%r30, [%r17 + 0x0044]
	.word 0x8d9520a0  ! 3771: WRPR_PSTATE_I	wrpr	%r20, 0x00a0, %pstate
	.word 0xbd510000  ! 3772: RDPR_TICK	rdpr	%tick, %r30
	.word 0xf075a03e  ! 3773: STX_I	stx	%r24, [%r22 + 0x003e]
	.word 0x8994a029  ! 3774: WRPR_TICK_I	wrpr	%r18, 0x0029, %tick
hwintr_3_174:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_174), 16, 16)) -> intp(3, 0, 31)
	.word 0xf0250000  ! 3778: STW_R	stw	%r24, [%r20 + %r0]
	.word 0xfe34c000  ! 3780: STH_R	sth	%r31, [%r19 + %r0]
	.word 0xfe2d4000  ! 3781: STB_R	stb	%r31, [%r21 + %r0]
	.word 0xf475e1fa  ! 3783: STX_I	stx	%r26, [%r23 + 0x01fa]
	.word 0xfe75606b  ! 3784: STX_I	stx	%r31, [%r21 + 0x006b]
hwintr_3_175:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_175), 16, 16)) -> intp(3, 0, 29)
	.word 0xf275a125  ! 3786: STX_I	stx	%r25, [%r22 + 0x0125]
	ta	T_CHANGE_HPRIV
	.word 0x819839db  ! 3787: WRHPR_HPSTATE_I	wrhpr	%r0, 0x19db, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81983a11  ! 3789: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a11, %hpstate
	.word 0xf33dc000  ! 3790: STDF_R	std	%f25, [%r0, %r23]
	.word 0xfe74214e  ! 3792: STX_I	stx	%r31, [%r16 + 0x014e]
	.word 0xf43dc000  ! 3794: STD_R	std	%r26, [%r23 + %r0]
	.word 0xfa35c000  ! 3795: STH_R	sth	%r29, [%r23 + %r0]
	.word 0xb80d2110  ! 3796: AND_I	and 	%r20, 0x0110, %r28
	.word 0xbf510000  ! 3797: RDPR_TICK	rdpr	%tick, %r31
	.word 0xfe3d6162  ! 3798: STD_I	std	%r31, [%r21 + 0x0162]
hwintr_3_176:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_176), 16, 16)) -> intp(3, 0, 2a)
	.word 0xb13cc000  ! 3802: SRA_R	sra 	%r19, %r0, %r24
	.word 0xf63d61af  ! 3805: STD_I	std	%r27, [%r21 + 0x01af]
	.word 0xf13d8000  ! 3807: STDF_R	std	%f24, [%r0, %r22]
	.word 0x8d94a1f7  ! 3809: WRPR_PSTATE_I	wrpr	%r18, 0x01f7, %pstate
	.word 0xb9500000  ! 3815: RDPR_TPC	rdpr	%tpc, %r28
	.word 0xf43d2129  ! 3816: STD_I	std	%r26, [%r20 + 0x0129]
hwintr_3_177:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_177), 16, 16)) -> intp(3, 0, 11)
	mov	1, %r12
	.word 0x8f932000  ! 3821: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf6750000  ! 3828: STX_R	stx	%r27, [%r20 + %r0]
hwintr_3_178:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_178), 16, 16)) -> intp(3, 0, 3f)
	.word 0xb1518000  ! 3830: RDPR_PSTATE	rdpr	%pstate, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982dcb  ! 3831: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dcb, %hpstate
hwintr_3_179:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_179), 16, 16)) -> intp(3, 0, 3a)
hwintr_3_180:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_180), 16, 16)) -> intp(3, 0, 7)
	.word 0xf035a098  ! 3839: STH_I	sth	%r24, [%r22 + 0x0098]
	.word 0xb88ce034  ! 3840: ANDcc_I	andcc 	%r19, 0x0034, %r28
hwintr_3_181:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_181), 16, 16)) -> intp(3, 0, f)
	.word 0xfe742057  ! 3846: STX_I	stx	%r31, [%r16 + 0x0057]
hwintr_3_182:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_182), 16, 16)) -> intp(3, 0, 20)
	.word 0xb0a54000  ! 3849: SUBcc_R	subcc 	%r21, %r0, %r24
	.word 0xf93c6168  ! 3853: STDF_I	std	%f28, [0x0168, %r17]
	.word 0xf834a00d  ! 3854: STH_I	sth	%r28, [%r18 + 0x000d]
	.word 0xfc258000  ! 3857: STW_R	stw	%r30, [%r22 + %r0]
	.word 0x89956002  ! 3858: WRPR_TICK_I	wrpr	%r21, 0x0002, %tick
	.word 0xf62d0000  ! 3860: STB_R	stb	%r27, [%r20 + %r0]
	.word 0xfa2cc000  ! 3862: STB_R	stb	%r29, [%r19 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81983dd3  ! 3865: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1dd3, %hpstate
	.word 0xb0b54000  ! 3868: ORNcc_R	orncc 	%r21, %r0, %r24
	.word 0xb950c000  ! 3872: RDPR_TT	rdpr	%tt, %r28
	.word 0xf824e062  ! 3873: STW_I	stw	%r28, [%r19 + 0x0062]
	.word 0xb3510000  ! 3877: RDPR_TICK	<illegal instruction>
	.word 0xfa24e0dc  ! 3878: STW_I	stw	%r29, [%r19 + 0x00dc]
	.word 0xf235c000  ! 3879: STH_R	sth	%r25, [%r23 + %r0]
	.word 0xb9518000  ! 3880: RDPR_PSTATE	<illegal instruction>
	.word 0x9195217d  ! 3881: WRPR_PIL_I	wrpr	%r20, 0x017d, %pil
	.word 0xf8354000  ! 3882: STH_R	sth	%r28, [%r21 + %r0]
	.word 0xfa344000  ! 3884: STH_R	sth	%r29, [%r17 + %r0]
	.word 0xfe34a0c7  ! 3886: STH_I	sth	%r31, [%r18 + 0x00c7]
	.word 0xf434e130  ! 3887: STH_I	sth	%r26, [%r19 + 0x0130]
	.word 0xf675a0b1  ! 3892: STX_I	stx	%r27, [%r22 + 0x00b1]
	.word 0xf02c60a0  ! 3894: STB_I	stb	%r24, [%r17 + 0x00a0]
	.word 0xbe8d6075  ! 3897: ANDcc_I	andcc 	%r21, 0x0075, %r31
	.word 0xf62dc000  ! 3898: STB_R	stb	%r27, [%r23 + %r0]
	.word 0xfc254000  ! 3900: STW_R	stw	%r30, [%r21 + %r0]
	.word 0xb3520000  ! 3905: RDPR_PIL	rdpr	%pil, %r25
	.word 0xfc25a06c  ! 3909: STW_I	stw	%r30, [%r22 + 0x006c]
	.word 0xb4c5a09b  ! 3910: ADDCcc_I	addccc 	%r22, 0x009b, %r26
	.word 0xbf3c5000  ! 3911: SRAX_R	srax	%r17, %r0, %r31
	.word 0x8195e1f3  ! 3913: WRPR_TPC_I	wrpr	%r23, 0x01f3, %tpc
	.word 0x91942015  ! 3914: WRPR_PIL_I	wrpr	%r16, 0x0015, %pil
	.word 0xb7504000  ! 3915: RDPR_TNPC	rdpr	%tnpc, %r27
	.word 0xf63d4000  ! 3916: STD_R	std	%r27, [%r21 + %r0]
	.word 0xf874e122  ! 3919: STX_I	stx	%r28, [%r19 + 0x0122]
	.word 0xf62ce14b  ! 3920: STB_I	stb	%r27, [%r19 + 0x014b]
	.word 0xbb504000  ! 3924: RDPR_TNPC	<illegal instruction>
	.word 0xfc24e12a  ! 3925: STW_I	stw	%r30, [%r19 + 0x012a]
	.word 0xf2250000  ! 3926: STW_R	stw	%r25, [%r20 + %r0]
	.word 0xf634e193  ! 3931: STH_I	sth	%r27, [%r19 + 0x0193]
	.word 0xbca5a0f3  ! 3935: SUBcc_I	subcc 	%r22, 0x00f3, %r30
	.word 0xf33ce024  ! 3936: STDF_I	std	%f25, [0x0024, %r19]
	.word 0xb1500000  ! 3937: RDPR_TPC	<illegal instruction>
	mov	1, %r14
	.word 0xa193a000  ! 3941: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_3_183:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_183), 16, 16)) -> intp(3, 0, 2f)
	.word 0xb82c4000  ! 3949: ANDN_R	andn 	%r17, %r0, %r28
	.word 0xfa25a0a3  ! 3952: STW_I	stw	%r29, [%r22 + 0x00a3]
	.word 0x9194e15e  ! 3953: WRPR_PIL_I	wrpr	%r19, 0x015e, %pil
	.word 0xf53d0000  ! 3954: STDF_R	std	%f26, [%r0, %r20]
	mov	1, %r14
	.word 0xa193a000  ! 3959: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfe74c000  ! 3962: STX_R	stx	%r31, [%r19 + %r0]
hwintr_3_184:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_184), 16, 16)) -> intp(3, 0, a)
	.word 0xb3510000  ! 3965: RDPR_TICK	rdpr	%tick, %r25
	.word 0xf2748000  ! 3972: STX_R	stx	%r25, [%r18 + %r0]
hwintr_3_185:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_185), 16, 16)) -> intp(3, 0, 3a)
	.word 0xb7508000  ! 3979: RDPR_TSTATE	<illegal instruction>
	.word 0xf43c20d4  ! 3981: STD_I	std	%r26, [%r16 + 0x00d4]
	.word 0xf624e0bf  ! 3983: STW_I	stw	%r27, [%r19 + 0x00bf]
	.word 0xb3504000  ! 3986: RDPR_TNPC	<illegal instruction>
	.word 0xf224a084  ! 3987: STW_I	stw	%r25, [%r18 + 0x0084]
	.word 0x8394e04b  ! 3990: WRPR_TNPC_I	wrpr	%r19, 0x004b, %tnpc
	.word 0xf63c8000  ! 3995: STD_R	std	%r27, [%r18 + %r0]
	.word 0xf03c4000  ! 3996: STD_R	std	%r24, [%r17 + %r0]
hwintr_3_186:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_186), 16, 16)) -> intp(3, 0, 33)
	.word 0xf13c0000  ! 3999: STDF_R	std	%f24, [%r0, %r16]
	.word 0xba0d0000  ! 4003: AND_R	and 	%r20, %r0, %r29
	.word 0xb82c201e  ! 4005: ANDN_I	andn 	%r16, 0x001e, %r28
	.word 0xb9500000  ! 4006: RDPR_TPC	rdpr	%tpc, %r28
	.word 0xb1518000  ! 4008: RDPR_PSTATE	<illegal instruction>
	.word 0xfc240000  ! 4011: STW_R	stw	%r30, [%r16 + %r0]
	.word 0xb9540000  ! 4015: RDPR_GL	<illegal instruction>
	setx	data_start_1, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb634e064  ! 4017: SUBC_I	orn 	%r19, 0x0064, %r27
	setx	data_start_2, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb6bc0000  ! 4020: XNORcc_R	xnorcc 	%r16, %r0, %r27
	.word 0xb12c8000  ! 4024: SLL_R	sll 	%r18, %r0, %r24
	.word 0xf03c0000  ! 4025: STD_R	std	%r24, [%r16 + %r0]
	.word 0xf634e1b9  ! 4026: STH_I	sth	%r27, [%r19 + 0x01b9]
	.word 0xfe2521d2  ! 4031: STW_I	stw	%r31, [%r20 + 0x01d2]
	.word 0xf62d2010  ! 4034: STB_I	stb	%r27, [%r20 + 0x0010]
	.word 0xfb3d204a  ! 4035: STDF_I	std	%f29, [0x004a, %r20]
	.word 0xfa25c000  ! 4040: STW_R	stw	%r29, [%r23 + %r0]
	.word 0xf02de07a  ! 4043: STB_I	stb	%r24, [%r23 + 0x007a]
	setx	data_start_6, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81982cc3  ! 4045: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0cc3, %hpstate
	.word 0xba944000  ! 4048: ORcc_R	orcc 	%r17, %r0, %r29
	.word 0xf22d60d4  ! 4054: STB_I	stb	%r25, [%r21 + 0x00d4]
	.word 0xf93c21fb  ! 4057: STDF_I	std	%f28, [0x01fb, %r16]
	.word 0xb4b50000  ! 4058: SUBCcc_R	orncc 	%r20, %r0, %r26
	.word 0xf03d0000  ! 4060: STD_R	std	%r24, [%r20 + %r0]
hwintr_3_187:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_187), 16, 16)) -> intp(3, 0, 3a)
	.word 0xbd50c000  ! 4063: RDPR_TT	rdpr	%tt, %r30
	.word 0xf2348000  ! 4064: STH_R	sth	%r25, [%r18 + %r0]
	.word 0x8995a039  ! 4065: WRPR_TICK_I	wrpr	%r22, 0x0039, %tick
	.word 0xf635e0ad  ! 4067: STH_I	sth	%r27, [%r23 + 0x00ad]
	.word 0xf825a1ee  ! 4068: STW_I	stw	%r28, [%r22 + 0x01ee]
	mov	0, %r14
	.word 0xa193a000  ! 4069: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb951c000  ! 4070: RDPR_TL	rdpr	%tl, %r28
	.word 0xf83d8000  ! 4073: STD_R	std	%r28, [%r22 + %r0]
	.word 0xf8742004  ! 4075: STX_I	stx	%r28, [%r16 + 0x0004]
	.word 0xf02c4000  ! 4076: STB_R	stb	%r24, [%r17 + %r0]
hwintr_3_188:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_188), 16, 16)) -> intp(3, 0, e)
	.word 0xf63d20b3  ! 4082: STD_I	std	%r27, [%r20 + 0x00b3]
	.word 0xf825c000  ! 4083: STW_R	stw	%r28, [%r23 + %r0]
	setx	data_start_2, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_189:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_189), 16, 16)) -> intp(3, 0, 3a)
	.word 0xbab50000  ! 4092: ORNcc_R	orncc 	%r20, %r0, %r29
	.word 0xfa3d6011  ! 4094: STD_I	std	%r29, [%r21 + 0x0011]
	.word 0xba344000  ! 4102: ORN_R	orn 	%r17, %r0, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81982dc1  ! 4104: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dc1, %hpstate
	.word 0xf03d2164  ! 4109: STD_I	std	%r24, [%r20 + 0x0164]
	.word 0xf73ce1b1  ! 4110: STDF_I	std	%f27, [0x01b1, %r19]
	.word 0xf03c0000  ! 4111: STD_R	std	%r24, [%r16 + %r0]
	setx	data_start_0, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa346105  ! 4114: STH_I	sth	%r29, [%r17 + 0x0105]
	.word 0xfa344000  ! 4115: STH_R	sth	%r29, [%r17 + %r0]
hwintr_3_190:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_190), 16, 16)) -> intp(3, 0, 11)
	.word 0x8d9420ea  ! 4117: WRPR_PSTATE_I	wrpr	%r16, 0x00ea, %pstate
	.word 0xb93c0000  ! 4121: SRA_R	sra 	%r16, %r0, %r28
hwintr_3_191:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_191), 16, 16)) -> intp(3, 0, 2a)
	.word 0xf23d8000  ! 4124: STD_R	std	%r25, [%r22 + %r0]
hwintr_3_192:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_192), 16, 16)) -> intp(3, 0, 36)
	.word 0xfc75c000  ! 4128: STX_R	stx	%r30, [%r23 + %r0]
	.word 0x8594e079  ! 4129: WRPR_TSTATE_I	wrpr	%r19, 0x0079, %tstate
	.word 0xfa35a1f5  ! 4131: STH_I	sth	%r29, [%r22 + 0x01f5]
	.word 0xf73dc000  ! 4132: STDF_R	std	%f27, [%r0, %r23]
	.word 0xbc140000  ! 4135: OR_R	or 	%r16, %r0, %r30
hwintr_3_193:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_193), 16, 16)) -> intp(3, 0, 2a)
	.word 0xf27460ff  ! 4141: STX_I	stx	%r25, [%r17 + 0x00ff]
hwintr_3_194:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_194), 16, 16)) -> intp(3, 0, 18)
	.word 0xf674c000  ! 4143: STX_R	stx	%r27, [%r19 + %r0]
	.word 0xbb520000  ! 4144: RDPR_PIL	rdpr	%pil, %r29
	.word 0xbc34c000  ! 4147: SUBC_R	orn 	%r19, %r0, %r30
	.word 0xb1520000  ! 4149: RDPR_PIL	<illegal instruction>
hwintr_3_195:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_195), 16, 16)) -> intp(3, 0, 3a)
	.word 0xfa34a055  ! 4157: STH_I	sth	%r29, [%r18 + 0x0055]
	.word 0x85952120  ! 4159: WRPR_TSTATE_I	wrpr	%r20, 0x0120, %tstate
	.word 0xb7510000  ! 4165: RDPR_TICK	rdpr	%tick, %r27
	.word 0xf0748000  ! 4166: STX_R	stx	%r24, [%r18 + %r0]
	.word 0xfe35a067  ! 4167: STH_I	sth	%r31, [%r22 + 0x0067]
	.word 0xfb3dc000  ! 4169: STDF_R	std	%f29, [%r0, %r23]
	.word 0xf42ca073  ! 4172: STB_I	stb	%r26, [%r18 + 0x0073]
	.word 0x859460d2  ! 4174: WRPR_TSTATE_I	wrpr	%r17, 0x00d2, %tstate
	.word 0xf82c4000  ! 4176: STB_R	stb	%r28, [%r17 + %r0]
	.word 0xb8b54000  ! 4179: SUBCcc_R	orncc 	%r21, %r0, %r28
hwintr_3_196:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_196), 16, 16)) -> intp(3, 0, 22)
hwintr_3_197:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_197), 16, 16)) -> intp(3, 0, 16)
hwintr_3_198:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_198), 16, 16)) -> intp(3, 0, 37)
	.word 0xf82d4000  ! 4186: STB_R	stb	%r28, [%r21 + %r0]
hwintr_3_199:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_199), 16, 16)) -> intp(3, 0, c)
	setx	data_start_0, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf33d4000  ! 4191: STDF_R	std	%f25, [%r0, %r21]
	.word 0x9195a07a  ! 4192: WRPR_PIL_I	wrpr	%r22, 0x007a, %pil
	.word 0xf53d0000  ! 4193: STDF_R	std	%f26, [%r0, %r20]
	.word 0xf03c21e8  ! 4194: STD_I	std	%r24, [%r16 + 0x01e8]
	.word 0xb1518000  ! 4199: RDPR_PSTATE	rdpr	%pstate, %r24
	.word 0xf13d6153  ! 4200: STDF_I	std	%f24, [0x0153, %r21]
	.word 0xb7510000  ! 4202: RDPR_TICK	<illegal instruction>
hwintr_3_200:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_200), 16, 16)) -> intp(3, 0, 28)
	.word 0xb535e001  ! 4205: SRL_I	srl 	%r23, 0x0001, %r26
	.word 0xf82cc000  ! 4209: STB_R	stb	%r28, [%r19 + %r0]
	.word 0xf275a0fb  ! 4211: STX_I	stx	%r25, [%r22 + 0x00fb]
hwintr_3_201:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_201), 16, 16)) -> intp(3, 0, 35)
hwintr_3_202:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_202), 16, 16)) -> intp(3, 0, 23)
	.word 0xf4254000  ! 4218: STW_R	stw	%r26, [%r21 + %r0]
	.word 0xf23ca03a  ! 4222: STD_I	std	%r25, [%r18 + 0x003a]
	.word 0xb3480000  ! 4224: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0x9194a082  ! 4227: WRPR_PIL_I	wrpr	%r18, 0x0082, %pil
	.word 0xfa258000  ! 4229: STW_R	stw	%r29, [%r22 + %r0]
hwintr_3_203:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_203), 16, 16)) -> intp(3, 0, 18)
	mov	1, %r12
	.word 0x8f932000  ! 4233: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x8794206f  ! 4238: WRPR_TT_I	wrpr	%r16, 0x006f, %tt
	.word 0xfa2c0000  ! 4241: STB_R	stb	%r29, [%r16 + %r0]
	setx	data_start_2, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_204:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_204), 16, 16)) -> intp(3, 0, 13)
	.word 0xfe3c6031  ! 4255: STD_I	std	%r31, [%r17 + 0x0031]
	.word 0x8194e174  ! 4256: WRPR_TPC_I	wrpr	%r19, 0x0174, %tpc
	.word 0xb9520000  ! 4260: RDPR_PIL	rdpr	%pil, %r28
	.word 0xf0240000  ! 4261: STW_R	stw	%r24, [%r16 + %r0]
	.word 0xf6744000  ! 4265: STX_R	stx	%r27, [%r17 + %r0]
hwintr_3_205:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_205), 16, 16)) -> intp(3, 0, 3d)
	.word 0xb9508000  ! 4269: RDPR_TSTATE	<illegal instruction>
	setx	data_start_1, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfb3d0000  ! 4271: STDF_R	std	%f29, [%r0, %r20]
	.word 0xfe340000  ! 4275: STH_R	sth	%r31, [%r16 + %r0]
hwintr_3_206:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_206), 16, 16)) -> intp(3, 0, 35)
	.word 0xff3dc000  ! 4280: STDF_R	std	%f31, [%r0, %r23]
	.word 0xf82ca17e  ! 4281: STB_I	stb	%r28, [%r18 + 0x017e]
	.word 0xbf7c0400  ! 4285: MOVR_R	movre	%r16, %r0, %r31
	.word 0xf03c8000  ! 4290: STD_R	std	%r24, [%r18 + %r0]
	.word 0xf62d4000  ! 4291: STB_R	stb	%r27, [%r21 + %r0]
	.word 0xf42c4000  ! 4293: STB_R	stb	%r26, [%r17 + %r0]
	.word 0xb1520000  ! 4296: RDPR_PIL	<illegal instruction>
	.word 0xb73dd000  ! 4297: SRAX_R	srax	%r23, %r0, %r27
	setx	data_start_2, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfe2ce130  ! 4302: STB_I	stb	%r31, [%r19 + 0x0130]
	.word 0xf474c000  ! 4303: STX_R	stx	%r26, [%r19 + %r0]
	.word 0xb9480000  ! 4304: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	mov	1, %r14
	.word 0xa193a000  ! 4306: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfc3c207b  ! 4307: STD_I	std	%r30, [%r16 + 0x007b]
	.word 0x8994208a  ! 4309: WRPR_TICK_I	wrpr	%r16, 0x008a, %tick
	mov	2, %r14
	.word 0xa193a000  ! 4310: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfb3d8000  ! 4313: STDF_R	std	%f29, [%r0, %r22]
	.word 0xfa24c000  ! 4314: STW_R	stw	%r29, [%r19 + %r0]
	.word 0xbd51c000  ! 4316: RDPR_TL	rdpr	%tl, %r30
	mov	2, %r12
	.word 0x8f932000  ! 4318: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfe3c2010  ! 4320: STD_I	std	%r31, [%r16 + 0x0010]
	.word 0xfc2c60bf  ! 4331: STB_I	stb	%r30, [%r17 + 0x00bf]
	.word 0x8d95e018  ! 4332: WRPR_PSTATE_I	wrpr	%r23, 0x0018, %pstate
	.word 0xf8744000  ! 4333: STX_R	stx	%r28, [%r17 + %r0]
	.word 0xf83ca092  ! 4341: STD_I	std	%r28, [%r18 + 0x0092]
	.word 0xbe35e12d  ! 4342: SUBC_I	orn 	%r23, 0x012d, %r31
	setx	data_start_3, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf6750000  ! 4344: STX_R	stx	%r27, [%r20 + %r0]
	mov	2, %r14
	.word 0xa193a000  ! 4347: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfe2da146  ! 4348: STB_I	stb	%r31, [%r22 + 0x0146]
	.word 0xf03d4000  ! 4349: STD_R	std	%r24, [%r21 + %r0]
	.word 0x87946034  ! 4351: WRPR_TT_I	wrpr	%r17, 0x0034, %tt
	.word 0xbb510000  ! 4356: RDPR_TICK	rdpr	%tick, %r29
	.word 0xbd508000  ! 4357: RDPR_TSTATE	<illegal instruction>
	.word 0xfe34e1f2  ! 4359: STH_I	sth	%r31, [%r19 + 0x01f2]
hwintr_3_207:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_207), 16, 16)) -> intp(3, 0, 32)
	.word 0xbcada05d  ! 4364: ANDNcc_I	andncc 	%r22, 0x005d, %r30
	.word 0x8194a138  ! 4365: WRPR_TPC_I	wrpr	%r18, 0x0138, %tpc
hwintr_3_208:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_208), 16, 16)) -> intp(3, 0, 15)
	.word 0xf03d0000  ! 4370: STD_R	std	%r24, [%r20 + %r0]
	.word 0xb151c000  ! 4372: RDPR_TL	rdpr	%tl, %r24
	.word 0xf474a025  ! 4373: STX_I	stx	%r26, [%r18 + 0x0025]
	.word 0xf63461d9  ! 4379: STH_I	sth	%r27, [%r17 + 0x01d9]
	.word 0xb23de010  ! 4381: XNOR_I	xnor 	%r23, 0x0010, %r25
	mov	1, %r12
	.word 0x8f932000  ! 4383: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb6a4e0c8  ! 4385: SUBcc_I	subcc 	%r19, 0x00c8, %r27
	.word 0xfc3d4000  ! 4387: STD_R	std	%r30, [%r21 + %r0]
	setx	data_start_0, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf82520d4  ! 4396: STW_I	stw	%r28, [%r20 + 0x00d4]
	.word 0xf27421e6  ! 4398: STX_I	stx	%r25, [%r16 + 0x01e6]
	.word 0xf63d600a  ! 4400: STD_I	std	%r27, [%r21 + 0x000a]
hwintr_3_209:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_209), 16, 16)) -> intp(3, 0, 3f)
	.word 0xf42de161  ! 4403: STB_I	stb	%r26, [%r23 + 0x0161]
	.word 0xb9480000  ! 4406: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
hwintr_3_210:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_210), 16, 16)) -> intp(3, 0, 3a)
	.word 0xb42dc000  ! 4411: ANDN_R	andn 	%r23, %r0, %r26
	setx	data_start_5, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf07561a2  ! 4415: STX_I	stx	%r24, [%r21 + 0x01a2]
hwintr_3_211:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_211), 16, 16)) -> intp(3, 0, 3)
hwintr_3_212:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_212), 16, 16)) -> intp(3, 0, 12)
	.word 0xb0adc000  ! 4423: ANDNcc_R	andncc 	%r23, %r0, %r24
hwintr_3_213:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_213), 16, 16)) -> intp(3, 0, d)
	.word 0xf42c0000  ! 4429: STB_R	stb	%r26, [%r16 + %r0]
	.word 0xfa3ce0da  ! 4430: STD_I	std	%r29, [%r19 + 0x00da]
	.word 0xff3c0000  ! 4437: STDF_R	std	%f31, [%r0, %r16]
	.word 0xf13d0000  ! 4441: STDF_R	std	%f24, [%r0, %r20]
	.word 0xbe154000  ! 4444: OR_R	or 	%r21, %r0, %r31
	.word 0xf62ca049  ! 4445: STB_I	stb	%r27, [%r18 + 0x0049]
	.word 0x8d956051  ! 4451: WRPR_PSTATE_I	wrpr	%r21, 0x0051, %pstate
	.word 0xb29dc000  ! 4453: XORcc_R	xorcc 	%r23, %r0, %r25
	.word 0x9195e019  ! 4456: WRPR_PIL_I	wrpr	%r23, 0x0019, %pil
	.word 0xf23d20d3  ! 4462: STD_I	std	%r25, [%r20 + 0x00d3]
	.word 0xf475a07a  ! 4464: STX_I	stx	%r26, [%r22 + 0x007a]
	.word 0xf73c4000  ! 4465: STDF_R	std	%f27, [%r0, %r17]
	ta	T_CHANGE_HPRIV
	.word 0x81982841  ! 4466: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0841, %hpstate
	setx	data_start_2, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_214:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_214), 16, 16)) -> intp(3, 0, 39)
	.word 0xf434e03e  ! 4471: STH_I	sth	%r26, [%r19 + 0x003e]
	.word 0xf83de15f  ! 4473: STD_I	std	%r28, [%r23 + 0x015f]
	.word 0xf434c000  ! 4475: STH_R	sth	%r26, [%r19 + %r0]
	.word 0xb9500000  ! 4476: RDPR_TPC	rdpr	%tpc, %r28
hwintr_3_215:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_215), 16, 16)) -> intp(3, 0, 2a)
	.word 0xf33c0000  ! 4479: STDF_R	std	%f25, [%r0, %r16]
	.word 0xbf508000  ! 4480: RDPR_TSTATE	<illegal instruction>
	.word 0xb9518000  ! 4482: RDPR_PSTATE	<illegal instruction>
	setx	data_start_5, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81982a0b  ! 4490: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a0b, %hpstate
	.word 0x8595e0fc  ! 4491: WRPR_TSTATE_I	wrpr	%r23, 0x00fc, %tstate
	.word 0x8795616f  ! 4494: WRPR_TT_I	wrpr	%r21, 0x016f, %tt
	.word 0xf8740000  ! 4496: STX_R	stx	%r28, [%r16 + %r0]
	.word 0xbc454000  ! 4497: ADDC_R	addc 	%r21, %r0, %r30
	.word 0xfb3d4000  ! 4498: STDF_R	std	%f29, [%r0, %r21]
	.word 0xf07421a4  ! 4500: STX_I	stx	%r24, [%r16 + 0x01a4]
	.word 0xf03c4000  ! 4507: STD_R	std	%r24, [%r17 + %r0]
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xbd50c000  ! 4512: RDPR_TT	rdpr	%tt, %r30
	.word 0xf835e15d  ! 4513: STH_I	sth	%r28, [%r23 + 0x015d]
hwintr_3_216:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_216), 16, 16)) -> intp(3, 0, 26)
	.word 0xf8350000  ! 4515: STH_R	sth	%r28, [%r20 + %r0]
	.word 0xb3520000  ! 4516: RDPR_PIL	<illegal instruction>
	.word 0xb9480000  ! 4517: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xfa34614f  ! 4521: STH_I	sth	%r29, [%r17 + 0x014f]
	.word 0xb7518000  ! 4523: RDPR_PSTATE	<illegal instruction>
hwintr_3_217:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_217), 16, 16)) -> intp(3, 0, 23)
	.word 0xbb2d5000  ! 4526: SLLX_R	sllx	%r21, %r0, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81983f9b  ! 4527: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f9b, %hpstate
	.word 0xfc3d0000  ! 4528: STD_R	std	%r30, [%r20 + %r0]
	.word 0xf03c8000  ! 4532: STD_R	std	%r24, [%r18 + %r0]
	.word 0x81956004  ! 4543: WRPR_TPC_I	wrpr	%r21, 0x0004, %tpc
	.word 0xbb510000  ! 4549: RDPR_TICK	rdpr	%tick, %r29
	.word 0xfa3c2060  ! 4551: STD_I	std	%r29, [%r16 + 0x0060]
hwintr_3_218:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_218), 16, 16)) -> intp(3, 0, 1a)
	.word 0xf82520f9  ! 4556: STW_I	stw	%r28, [%r20 + 0x00f9]
	.word 0xb9510000  ! 4559: RDPR_TICK	<illegal instruction>
hwintr_3_219:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_219), 16, 16)) -> intp(3, 0, 3)
	.word 0xbf518000  ! 4561: RDPR_PSTATE	<illegal instruction>
	.word 0xf82cc000  ! 4563: STB_R	stb	%r28, [%r19 + %r0]
hwintr_3_220:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_220), 16, 16)) -> intp(3, 0, f)
	.word 0x85942112  ! 4567: WRPR_TSTATE_I	wrpr	%r16, 0x0112, %tstate
	.word 0xfa3de073  ! 4568: STD_I	std	%r29, [%r23 + 0x0073]
	.word 0xfc2ce0e4  ! 4569: STB_I	stb	%r30, [%r19 + 0x00e4]
	.word 0xbeb46133  ! 4573: SUBCcc_I	orncc 	%r17, 0x0133, %r31
	.word 0xf03c8000  ! 4575: STD_R	std	%r24, [%r18 + %r0]
	.word 0xf8748000  ! 4578: STX_R	stx	%r28, [%r18 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982ed9  ! 4580: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0ed9, %hpstate
	.word 0xf625e01b  ! 4583: STW_I	stw	%r27, [%r23 + 0x001b]
	.word 0x8995a04f  ! 4584: WRPR_TICK_I	wrpr	%r22, 0x004f, %tick
	.word 0xbc25a0e2  ! 4589: SUB_I	sub 	%r22, 0x00e2, %r30
	.word 0xfa756161  ! 4590: STX_I	stx	%r29, [%r21 + 0x0161]
	.word 0xf73d8000  ! 4592: STDF_R	std	%f27, [%r0, %r22]
	.word 0xf73c21a5  ! 4593: STDF_I	std	%f27, [0x01a5, %r16]
	.word 0xf424e008  ! 4598: STW_I	stw	%r26, [%r19 + 0x0008]
	.word 0x9195a1aa  ! 4599: WRPR_PIL_I	wrpr	%r22, 0x01aa, %pil
	.word 0xfc242040  ! 4602: STW_I	stw	%r30, [%r16 + 0x0040]
	.word 0xf234a15a  ! 4603: STH_I	sth	%r25, [%r18 + 0x015a]
	.word 0xf03d4000  ! 4604: STD_R	std	%r24, [%r21 + %r0]
	.word 0xfe25c000  ! 4606: STW_R	stw	%r31, [%r23 + %r0]
	.word 0xf025a19f  ! 4607: STW_I	stw	%r24, [%r22 + 0x019f]
	.word 0xf63d6058  ! 4608: STD_I	std	%r27, [%r21 + 0x0058]
	.word 0xfe74603c  ! 4611: STX_I	stx	%r31, [%r17 + 0x003c]
hwintr_3_221:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_221), 16, 16)) -> intp(3, 0, 11)
	.word 0x8d94212a  ! 4613: WRPR_PSTATE_I	wrpr	%r16, 0x012a, %pstate
	.word 0xf074215b  ! 4618: STX_I	stx	%r24, [%r16 + 0x015b]
	.word 0xbd340000  ! 4620: SRL_R	srl 	%r16, %r0, %r30
	.word 0xf33ce157  ! 4621: STDF_I	std	%f25, [0x0157, %r19]
	.word 0xb69460e6  ! 4625: ORcc_I	orcc 	%r17, 0x00e6, %r27
	.word 0xb351c000  ! 4626: RDPR_TL	rdpr	%tl, %r25
	.word 0xb6a5c000  ! 4628: SUBcc_R	subcc 	%r23, %r0, %r27
hwintr_3_222:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_222), 16, 16)) -> intp(3, 0, 2c)
	.word 0xf8358000  ! 4634: STH_R	sth	%r28, [%r22 + %r0]
	.word 0xfc2c8000  ! 4635: STB_R	stb	%r30, [%r18 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81983e11  ! 4636: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e11, %hpstate
	.word 0xbe2d4000  ! 4638: ANDN_R	andn 	%r21, %r0, %r31
	.word 0xfc75a186  ! 4641: STX_I	stx	%r30, [%r22 + 0x0186]
	ta	T_CHANGE_HPRIV
	.word 0x81983cc3  ! 4645: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1cc3, %hpstate
hwintr_3_223:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_223), 16, 16)) -> intp(3, 0, 39)
	.word 0xfd3cc000  ! 4649: STDF_R	std	%f30, [%r0, %r19]
	.word 0xb80c4000  ! 4652: AND_R	and 	%r17, %r0, %r28
	mov	1, %r14
	.word 0xa193a000  ! 4653: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9643801  ! 4654: MOVcc_I	<illegal instruction>
	.word 0xfb3d0000  ! 4658: STDF_R	std	%f29, [%r0, %r20]
	.word 0xf075600d  ! 4660: STX_I	stx	%r24, [%r21 + 0x000d]
	.word 0xfe2d6076  ! 4662: STB_I	stb	%r31, [%r21 + 0x0076]
	.word 0xb63561e1  ! 4663: SUBC_I	orn 	%r21, 0x01e1, %r27
	.word 0xf73dc000  ! 4668: STDF_R	std	%f27, [%r0, %r23]
	mov	1, %r14
	.word 0xa193a000  ! 4669: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfc24e091  ! 4672: STW_I	stw	%r30, [%r19 + 0x0091]
	.word 0xf02c4000  ! 4677: STB_R	stb	%r24, [%r17 + %r0]
	.word 0xfe35e15d  ! 4679: STH_I	sth	%r31, [%r23 + 0x015d]
	.word 0xb09c4000  ! 4681: XORcc_R	xorcc 	%r17, %r0, %r24
	.word 0xfc25c000  ! 4682: STW_R	stw	%r30, [%r23 + %r0]
hwintr_3_224:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_224), 16, 16)) -> intp(3, 0, 2b)
	.word 0xf63de12e  ! 4689: STD_I	std	%r27, [%r23 + 0x012e]
	.word 0xf434a0d2  ! 4690: STH_I	sth	%r26, [%r18 + 0x00d2]
	.word 0xbb510000  ! 4692: RDPR_TICK	rdpr	%tick, %r29
	.word 0xb6a46121  ! 4693: SUBcc_I	subcc 	%r17, 0x0121, %r27
	.word 0xf02c4000  ! 4696: STB_R	stb	%r24, [%r17 + %r0]
	.word 0xfe350000  ! 4698: STH_R	sth	%r31, [%r20 + %r0]
	.word 0xf33d0000  ! 4699: STDF_R	std	%f25, [%r0, %r20]
	.word 0xbf50c000  ! 4700: RDPR_TT	<illegal instruction>
	.word 0xfe2c0000  ! 4703: STB_R	stb	%r31, [%r16 + %r0]
	.word 0xfc3520a8  ! 4704: STH_I	sth	%r30, [%r20 + 0x00a8]
	.word 0xbb504000  ! 4705: RDPR_TNPC	<illegal instruction>
	.word 0xf474a0ed  ! 4712: STX_I	stx	%r26, [%r18 + 0x00ed]
hwintr_3_225:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_225), 16, 16)) -> intp(3, 0, 2f)
	.word 0xf6358000  ! 4718: STH_R	sth	%r27, [%r22 + %r0]
	.word 0xfa34c000  ! 4719: STH_R	sth	%r29, [%r19 + %r0]
	.word 0x8994e05b  ! 4720: WRPR_TICK_I	wrpr	%r19, 0x005b, %tick
	.word 0xf42c8000  ! 4721: STB_R	stb	%r26, [%r18 + %r0]
	.word 0xbd520000  ! 4722: RDPR_PIL	rdpr	%pil, %r30
	.word 0xf03c6073  ! 4723: STD_I	std	%r24, [%r17 + 0x0073]
	.word 0xbb500000  ! 4724: RDPR_TPC	<illegal instruction>
	.word 0xf875a1a7  ! 4726: STX_I	stx	%r28, [%r22 + 0x01a7]
	.word 0xb4946110  ! 4727: ORcc_I	orcc 	%r17, 0x0110, %r26
	.word 0xf23dc000  ! 4729: STD_R	std	%r25, [%r23 + %r0]
	.word 0xfa344000  ! 4730: STH_R	sth	%r29, [%r17 + %r0]
	.word 0xb8bc0000  ! 4731: XNORcc_R	xnorcc 	%r16, %r0, %r28
	.word 0xf23d4000  ! 4732: STD_R	std	%r25, [%r21 + %r0]
	.word 0xb53d1000  ! 4735: SRAX_R	srax	%r20, %r0, %r26
	.word 0xfe2d4000  ! 4741: STB_R	stb	%r31, [%r21 + %r0]
	.word 0xf2340000  ! 4743: STH_R	sth	%r25, [%r16 + %r0]
	.word 0xbe84209e  ! 4744: ADDcc_I	addcc 	%r16, 0x009e, %r31
	.word 0x8d95a0c1  ! 4745: WRPR_PSTATE_I	wrpr	%r22, 0x00c1, %pstate
	.word 0xfe2cc000  ! 4746: STB_R	stb	%r31, [%r19 + %r0]
	.word 0x9195e097  ! 4751: WRPR_PIL_I	wrpr	%r23, 0x0097, %pil
	.word 0xfc2420e4  ! 4757: STW_I	stw	%r30, [%r16 + 0x00e4]
	.word 0xb9540000  ! 4758: RDPR_GL	rdpr	%-, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81983d93  ! 4764: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d93, %hpstate
	.word 0xfc3ca028  ! 4765: STD_I	std	%r30, [%r18 + 0x0028]
	.word 0xf13da061  ! 4766: STDF_I	std	%f24, [0x0061, %r22]
	.word 0xf834a0e4  ! 4770: STH_I	sth	%r28, [%r18 + 0x00e4]
	.word 0xf62d6139  ! 4771: STB_I	stb	%r27, [%r21 + 0x0139]
	mov	0, %r12
	.word 0x8f932000  ! 4773: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf62c4000  ! 4774: STB_R	stb	%r27, [%r17 + %r0]
	.word 0xb17c2401  ! 4775: MOVR_I	movre	%r16, 0x1, %r24
	.word 0xb3500000  ! 4779: RDPR_TPC	rdpr	%tpc, %r25
	.word 0xbd520000  ! 4780: RDPR_PIL	<illegal instruction>
	.word 0xb8358000  ! 4781: ORN_R	orn 	%r22, %r0, %r28
	.word 0xbac4610e  ! 4784: ADDCcc_I	addccc 	%r17, 0x010e, %r29
	.word 0x8395a118  ! 4790: WRPR_TNPC_I	wrpr	%r22, 0x0118, %tnpc
	.word 0xb484e1a5  ! 4791: ADDcc_I	addcc 	%r19, 0x01a5, %r26
hwintr_3_226:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_226), 16, 16)) -> intp(3, 0, 3d)
hwintr_3_227:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_227), 16, 16)) -> intp(3, 0, 1d)
	.word 0xf33c4000  ! 4802: STDF_R	std	%f25, [%r0, %r17]
	.word 0x899521b0  ! 4803: WRPR_TICK_I	wrpr	%r20, 0x01b0, %tick
	.word 0xb5518000  ! 4804: RDPR_PSTATE	rdpr	%pstate, %r26
	.word 0xf875c000  ! 4807: STX_R	stx	%r28, [%r23 + %r0]
	.word 0xf83d60d3  ! 4815: STD_I	std	%r28, [%r21 + 0x00d3]
	.word 0xfc342136  ! 4818: STH_I	sth	%r30, [%r16 + 0x0136]
	.word 0xfa74c000  ! 4821: STX_R	stx	%r29, [%r19 + %r0]
	.word 0xba2c4000  ! 4823: ANDN_R	andn 	%r17, %r0, %r29
	.word 0xfa340000  ! 4829: STH_R	sth	%r29, [%r16 + %r0]
	.word 0xbd508000  ! 4831: RDPR_TSTATE	<illegal instruction>
	.word 0x87952155  ! 4833: WRPR_TT_I	wrpr	%r20, 0x0155, %tt
	.word 0xbf2df001  ! 4841: SLLX_I	sllx	%r23, 0x0001, %r31
	.word 0xfa2ce070  ! 4842: STB_I	stb	%r29, [%r19 + 0x0070]
	.word 0xfe25c000  ! 4843: STW_R	stw	%r31, [%r23 + %r0]
	.word 0xb4942156  ! 4844: ORcc_I	orcc 	%r16, 0x0156, %r26
	.word 0xf53d21f5  ! 4846: STDF_I	std	%f26, [0x01f5, %r20]
	.word 0xf82ce128  ! 4847: STB_I	stb	%r28, [%r19 + 0x0128]
	ta	T_CHANGE_HPRIV
	.word 0x81982853  ! 4851: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0853, %hpstate
	.word 0xba84613c  ! 4852: ADDcc_I	addcc 	%r17, 0x013c, %r29
	.word 0xf224c000  ! 4853: STW_R	stw	%r25, [%r19 + %r0]
	.word 0xf075e039  ! 4857: STX_I	stx	%r24, [%r23 + 0x0039]
	.word 0xbb50c000  ! 4863: RDPR_TT	rdpr	%tt, %r29
	.word 0xfc2d2021  ! 4864: STB_I	stb	%r30, [%r20 + 0x0021]
	.word 0xb9480000  ! 4867: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xf83c211f  ! 4870: STD_I	std	%r28, [%r16 + 0x011f]
	.word 0xfa35e03b  ! 4871: STH_I	sth	%r29, [%r23 + 0x003b]
	.word 0x899521ab  ! 4874: WRPR_TICK_I	wrpr	%r20, 0x01ab, %tick
hwintr_3_228:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_228), 16, 16)) -> intp(3, 0, 27)
	ta	T_CHANGE_HPRIV
	.word 0x819829cb  ! 4879: WRHPR_HPSTATE_I	wrhpr	%r0, 0x09cb, %hpstate
hwintr_3_229:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_229), 16, 16)) -> intp(3, 0, 34)
	.word 0x8395a00c  ! 4887: WRPR_TNPC_I	wrpr	%r22, 0x000c, %tnpc
	.word 0xff3d8000  ! 4888: STDF_R	std	%f31, [%r0, %r22]
	.word 0xff3d8000  ! 4889: STDF_R	std	%f31, [%r0, %r22]
hwintr_3_230:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_230), 16, 16)) -> intp(3, 0, 19)
	.word 0xb41d2059  ! 4892: XOR_I	xor 	%r20, 0x0059, %r26
	.word 0xf03c6126  ! 4896: STD_I	std	%r24, [%r17 + 0x0126]
	.word 0xff3d21cc  ! 4897: STDF_I	std	%f31, [0x01cc, %r20]
	.word 0xf2352189  ! 4900: STH_I	sth	%r25, [%r20 + 0x0189]
hwintr_3_231:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_231), 16, 16)) -> intp(3, 0, 21)
hwintr_3_232:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_232), 16, 16)) -> intp(3, 0, 12)
	setx	data_start_7, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfe352031  ! 4911: STH_I	sth	%r31, [%r20 + 0x0031]
	.word 0xb40cc000  ! 4915: AND_R	and 	%r19, %r0, %r26
hwintr_3_233:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_233), 16, 16)) -> intp(3, 0, 24)
	.word 0xb88c61d4  ! 4923: ANDcc_I	andcc 	%r17, 0x01d4, %r28
	.word 0xfc740000  ! 4930: STX_R	stx	%r30, [%r16 + %r0]
	setx	data_start_6, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfd3c21a3  ! 4935: STDF_I	std	%f30, [0x01a3, %r16]
	mov	2, %r12
	.word 0x8f932000  ! 4937: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
hwintr_3_234:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_234), 16, 16)) -> intp(3, 0, 2a)
hwintr_3_235:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_235), 16, 16)) -> intp(3, 0, 3b)
	.word 0xfa3c20d0  ! 4946: STD_I	std	%r29, [%r16 + 0x00d0]
	.word 0xf234e10b  ! 4951: STH_I	sth	%r25, [%r19 + 0x010b]
	.word 0xfe348000  ! 4952: STH_R	sth	%r31, [%r18 + %r0]
	.word 0xf83c4000  ! 4955: STD_R	std	%r28, [%r17 + %r0]
	.word 0xb7540000  ! 4957: RDPR_GL	rdpr	%-, %r27
	.word 0xf83ce0cb  ! 4960: STD_I	std	%r28, [%r19 + 0x00cb]
	.word 0xb37ca401  ! 4962: MOVR_I	movre	%r18, 0x1, %r25
	.word 0xfe358000  ! 4965: STH_R	sth	%r31, [%r22 + %r0]
	.word 0xfb3ca0e8  ! 4966: STDF_I	std	%f29, [0x00e8, %r18]
	.word 0xf625e16b  ! 4968: STW_I	stw	%r27, [%r23 + 0x016b]
	ta	T_CHANGE_HPRIV
	.word 0x81983f43  ! 4969: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f43, %hpstate
	.word 0xfc25e173  ! 4972: STW_I	stw	%r30, [%r23 + 0x0173]
	.word 0xf62cc000  ! 4980: STB_R	stb	%r27, [%r19 + %r0]
	.word 0x8395a1c0  ! 4983: WRPR_TNPC_I	wrpr	%r22, 0x01c0, %tnpc
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xfa75c000  ! 4985: STX_R	stx	%r29, [%r23 + %r0]
	.word 0xb20de1c1  ! 4990: AND_I	and 	%r23, 0x01c1, %r25
	.word 0xb2bd20b3  ! 4991: XNORcc_I	xnorcc 	%r20, 0x00b3, %r25
	.word 0xfc2421cd  ! 4992: STW_I	stw	%r30, [%r16 + 0x01cd]
	.word 0xf0754000  ! 4994: STX_R	stx	%r24, [%r21 + %r0]
	.word 0xf63cc000  ! 4995: STD_R	std	%r27, [%r19 + %r0]
	.word 0xf93d61e9  ! 4999: STDF_I	std	%f28, [0x01e9, %r21]
	.word 0xf22d0000  ! 5000: STB_R	stb	%r25, [%r20 + %r0]
	.word 0xb4340000  ! 5001: ORN_R	orn 	%r16, %r0, %r26
	.word 0x8d94e191  ! 5002: WRPR_PSTATE_I	wrpr	%r19, 0x0191, %pstate
	.word 0xf42c8000  ! 5004: STB_R	stb	%r26, [%r18 + %r0]
	mov	1, %r12
	.word 0x8f932000  ! 5007: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_3_236:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_236), 16, 16)) -> intp(3, 0, d)
	ta	T_CHANGE_HPRIV
	.word 0x81983f89  ! 5014: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f89, %hpstate
	.word 0xb60ce116  ! 5018: AND_I	and 	%r19, 0x0116, %r27
	.word 0xbd504000  ! 5020: RDPR_TNPC	rdpr	%tnpc, %r30
	.word 0xf82560f1  ! 5021: STW_I	stw	%r28, [%r21 + 0x00f1]
	.word 0xfb3dc000  ! 5032: STDF_R	std	%f29, [%r0, %r23]
hwintr_3_237:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_237), 16, 16)) -> intp(3, 0, 1b)
	.word 0xfb3d4000  ! 5034: STDF_R	std	%f29, [%r0, %r21]
	.word 0xf874c000  ! 5035: STX_R	stx	%r28, [%r19 + %r0]
	.word 0xfa3cc000  ! 5038: STD_R	std	%r29, [%r19 + %r0]
	.word 0xf034e076  ! 5040: STH_I	sth	%r24, [%r19 + 0x0076]
	ta	T_CHANGE_HPRIV
	.word 0x819829d9  ! 5042: WRHPR_HPSTATE_I	wrhpr	%r0, 0x09d9, %hpstate
	.word 0xf024c000  ! 5043: STW_R	stw	%r24, [%r19 + %r0]
	.word 0xb950c000  ! 5044: RDPR_TT	rdpr	%tt, %r28
	.word 0xf73d0000  ! 5046: STDF_R	std	%f27, [%r0, %r20]
	.word 0xf42c8000  ! 5048: STB_R	stb	%r26, [%r18 + %r0]
	.word 0xbab4c000  ! 5049: SUBCcc_R	orncc 	%r19, %r0, %r29
	.word 0xb08c604f  ! 5052: ANDcc_I	andcc 	%r17, 0x004f, %r24
	.word 0xfa3c4000  ! 5055: STD_R	std	%r29, [%r17 + %r0]
	.word 0xf53c4000  ! 5059: STDF_R	std	%f26, [%r0, %r17]
	ta	T_CHANGE_HPRIV
	.word 0x81982d83  ! 5062: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d83, %hpstate
	.word 0xf874c000  ! 5064: STX_R	stx	%r28, [%r19 + %r0]
	.word 0xf13c8000  ! 5068: STDF_R	std	%f24, [%r0, %r18]
	.word 0xfa24c000  ! 5070: STW_R	stw	%r29, [%r19 + %r0]
	.word 0xf0344000  ! 5073: STH_R	sth	%r24, [%r17 + %r0]
	.word 0xf43da012  ! 5074: STD_I	std	%r26, [%r22 + 0x0012]
	.word 0xf4244000  ! 5076: STW_R	stw	%r26, [%r17 + %r0]
	.word 0xb2bc20ce  ! 5079: XNORcc_I	xnorcc 	%r16, 0x00ce, %r25
	.word 0xb9510000  ! 5081: RDPR_TICK	rdpr	%tick, %r28
hwintr_3_238:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_238), 16, 16)) -> intp(3, 0, 27)
	.word 0xb9480000  ! 5087: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xfc24c000  ! 5089: STW_R	stw	%r30, [%r19 + %r0]
	.word 0xbd518000  ! 5093: RDPR_PSTATE	rdpr	%pstate, %r30
	.word 0xb0ace1c8  ! 5094: ANDNcc_I	andncc 	%r19, 0x01c8, %r24
	.word 0xf224a0a3  ! 5095: STW_I	stw	%r25, [%r18 + 0x00a3]
	.word 0xf43c21c0  ! 5096: STD_I	std	%r26, [%r16 + 0x01c0]
	setx	data_start_7, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8d94a0c4  ! 5109: WRPR_PSTATE_I	wrpr	%r18, 0x00c4, %pstate
	.word 0xf27560cd  ! 5112: STX_I	stx	%r25, [%r21 + 0x00cd]
	.word 0xbb2da001  ! 5115: SLL_I	sll 	%r22, 0x0001, %r29
	.word 0xfa35a13f  ! 5116: STH_I	sth	%r29, [%r22 + 0x013f]
	.word 0xf62de005  ! 5119: STB_I	stb	%r27, [%r23 + 0x0005]
	.word 0xf53c0000  ! 5120: STDF_R	std	%f26, [%r0, %r16]
	.word 0xb0a4a0fa  ! 5125: SUBcc_I	subcc 	%r18, 0x00fa, %r24
hwintr_3_239:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_239), 16, 16)) -> intp(3, 0, 3e)
	ta	T_CHANGE_HPRIV
	.word 0x81983a09  ! 5140: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a09, %hpstate
	.word 0xf82c0000  ! 5142: STB_R	stb	%r28, [%r16 + %r0]
	.word 0xfe24c000  ! 5144: STW_R	stw	%r31, [%r19 + %r0]
	.word 0xf835a106  ! 5147: STH_I	sth	%r28, [%r22 + 0x0106]
	.word 0x89952088  ! 5149: WRPR_TICK_I	wrpr	%r20, 0x0088, %tick
	.word 0x9195e072  ! 5151: WRPR_PIL_I	wrpr	%r23, 0x0072, %pil
	.word 0xf62de052  ! 5153: STB_I	stb	%r27, [%r23 + 0x0052]
hwintr_3_240:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_240), 16, 16)) -> intp(3, 0, 1a)
	.word 0xb3500000  ! 5156: RDPR_TPC	rdpr	%tpc, %r25
	.word 0xfb3c20eb  ! 5161: STDF_I	std	%f29, [0x00eb, %r16]
	.word 0xf13ce18b  ! 5162: STDF_I	std	%f24, [0x018b, %r19]
	mov	1, %r12
	.word 0x8f932000  ! 5163: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb2b4e03d  ! 5166: ORNcc_I	orncc 	%r19, 0x003d, %r25
	.word 0xfc354000  ! 5168: STH_R	sth	%r30, [%r21 + %r0]
	.word 0xf22520f3  ! 5170: STW_I	stw	%r25, [%r20 + 0x00f3]
	.word 0x8d94e1ca  ! 5171: WRPR_PSTATE_I	wrpr	%r19, 0x01ca, %pstate
	.word 0xbab520cc  ! 5174: ORNcc_I	orncc 	%r20, 0x00cc, %r29
	.word 0xfc3de117  ! 5176: STD_I	std	%r30, [%r23 + 0x0117]
	.word 0xf6754000  ! 5180: STX_R	stx	%r27, [%r21 + %r0]
	.word 0xf225a0d4  ! 5185: STW_I	stw	%r25, [%r22 + 0x00d4]
hwintr_3_241:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_241), 16, 16)) -> intp(3, 0, 0)
	ta	T_CHANGE_HPRIV
	.word 0x81983a19  ! 5191: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a19, %hpstate
	.word 0xb1508000  ! 5195: RDPR_TSTATE	rdpr	%tstate, %r24
hwintr_3_242:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_242), 16, 16)) -> intp(3, 0, 21)
	.word 0xfe2c6093  ! 5197: STB_I	stb	%r31, [%r17 + 0x0093]
	.word 0xf025c000  ! 5198: STW_R	stw	%r24, [%r23 + %r0]
	.word 0x839460cb  ! 5199: WRPR_TNPC_I	wrpr	%r17, 0x00cb, %tnpc
	.word 0xb9520000  ! 5200: RDPR_PIL	rdpr	%pil, %r28
	.word 0xfb3da12e  ! 5205: STDF_I	std	%f29, [0x012e, %r22]
	ta	T_CHANGE_HPRIV
	.word 0x81983b49  ! 5207: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b49, %hpstate
	.word 0xf13cc000  ! 5210: STDF_R	std	%f24, [%r0, %r19]
	.word 0xfe2c4000  ! 5214: STB_R	stb	%r31, [%r17 + %r0]
	mov	1, %r14
	.word 0xa193a000  ! 5215: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf42d4000  ! 5217: STB_R	stb	%r26, [%r21 + %r0]
	setx	data_start_6, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfb3c8000  ! 5223: STDF_R	std	%f29, [%r0, %r18]
	.word 0xbb50c000  ! 5226: RDPR_TT	rdpr	%tt, %r29
	.word 0x879560a9  ! 5228: WRPR_TT_I	wrpr	%r21, 0x00a9, %tt
	.word 0xb1480000  ! 5231: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
hwintr_3_243:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_243), 16, 16)) -> intp(3, 0, 1d)
	.word 0xfd3dc000  ! 5239: STDF_R	std	%f30, [%r0, %r23]
	.word 0xf03c4000  ! 5240: STD_R	std	%r24, [%r17 + %r0]
	.word 0xbc15e1c6  ! 5246: OR_I	or 	%r23, 0x01c6, %r30
	.word 0xf234c000  ! 5252: STH_R	sth	%r25, [%r19 + %r0]
	.word 0xf8748000  ! 5253: STX_R	stx	%r28, [%r18 + %r0]
	.word 0xf02c4000  ! 5256: STB_R	stb	%r24, [%r17 + %r0]
hwintr_3_244:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_244), 16, 16)) -> intp(3, 0, 0)
	.word 0x8d942176  ! 5259: WRPR_PSTATE_I	wrpr	%r16, 0x0176, %pstate
	.word 0xfa24e010  ! 5260: STW_I	stw	%r29, [%r19 + 0x0010]
	.word 0x8395a019  ! 5267: WRPR_TNPC_I	wrpr	%r22, 0x0019, %tnpc
hwintr_3_245:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_245), 16, 16)) -> intp(3, 0, 3a)
	.word 0x899461b8  ! 5271: WRPR_TICK_I	wrpr	%r17, 0x01b8, %tick
hwintr_3_246:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_246), 16, 16)) -> intp(3, 0, 11)
	.word 0xf234a03a  ! 5275: STH_I	sth	%r25, [%r18 + 0x003a]
	.word 0xf22d60b9  ! 5280: STB_I	stb	%r25, [%r21 + 0x00b9]
	.word 0xf834a131  ! 5285: STH_I	sth	%r28, [%r18 + 0x0131]
	.word 0xbf480000  ! 5287: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
hwintr_3_247:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_247), 16, 16)) -> intp(3, 0, 11)
	.word 0xf275e107  ! 5289: STX_I	stx	%r25, [%r23 + 0x0107]
	.word 0x839421a0  ! 5292: WRPR_TNPC_I	wrpr	%r16, 0x01a0, %tnpc
hwintr_3_248:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_248), 16, 16)) -> intp(3, 0, 1)
	.word 0x83952141  ! 5294: WRPR_TNPC_I	wrpr	%r20, 0x0141, %tnpc
	.word 0xfa750000  ! 5296: STX_R	stx	%r29, [%r20 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982e8b  ! 5297: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e8b, %hpstate
	.word 0xfc742109  ! 5298: STX_I	stx	%r30, [%r16 + 0x0109]
	ta	T_CHANGE_HPRIV
	.word 0x81983d4b  ! 5310: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d4b, %hpstate
	mov	2, %r12
	.word 0x8f932000  ! 5313: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfe2420b5  ! 5314: STW_I	stw	%r31, [%r16 + 0x00b5]
hwintr_3_249:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_249), 16, 16)) -> intp(3, 0, 1b)
	.word 0xf27561ac  ! 5317: STX_I	stx	%r25, [%r21 + 0x01ac]
hwintr_3_250:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_250), 16, 16)) -> intp(3, 0, 21)
	.word 0xf83c60ca  ! 5319: STD_I	std	%r28, [%r17 + 0x00ca]
	.word 0xf42c61d1  ! 5320: STB_I	stb	%r26, [%r17 + 0x01d1]
	.word 0xf875219a  ! 5323: STX_I	stx	%r28, [%r20 + 0x019a]
hwintr_3_251:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_251), 16, 16)) -> intp(3, 0, 1a)
	.word 0xfc3d0000  ! 5326: STD_R	std	%r30, [%r20 + %r0]
	.word 0xf03de1f1  ! 5327: STD_I	std	%r24, [%r23 + 0x01f1]
	.word 0xf02da101  ! 5328: STB_I	stb	%r24, [%r22 + 0x0101]
	.word 0xfa75a123  ! 5329: STX_I	stx	%r29, [%r22 + 0x0123]
	.word 0xbf500000  ! 5330: RDPR_TPC	rdpr	%tpc, %r31
	.word 0xb7510000  ! 5335: RDPR_TICK	<illegal instruction>
	setx	data_start_3, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r20, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x9195a05d  ! 5340: WRPR_PIL_I	wrpr	%r22, 0x005d, %pil
	.word 0xf73d0000  ! 5341: STDF_R	std	%f27, [%r0, %r20]
	.word 0x8395a193  ! 5343: WRPR_TNPC_I	wrpr	%r22, 0x0193, %tnpc
	.word 0xfc354000  ! 5348: STH_R	sth	%r30, [%r21 + %r0]
	.word 0xb9510000  ! 5352: RDPR_TICK	rdpr	%tick, %r28
	.word 0xb23c8000  ! 5353: XNOR_R	xnor 	%r18, %r0, %r25
	.word 0xbc94a166  ! 5355: ORcc_I	orcc 	%r18, 0x0166, %r30
	.word 0xbe350000  ! 5356: SUBC_R	orn 	%r20, %r0, %r31
	.word 0x8395e00b  ! 5357: WRPR_TNPC_I	wrpr	%r23, 0x000b, %tnpc
	.word 0xfc24a029  ! 5360: STW_I	stw	%r30, [%r18 + 0x0029]
hwintr_3_252:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_252), 16, 16)) -> intp(3, 0, 21)
	.word 0xf43c209b  ! 5364: STD_I	std	%r26, [%r16 + 0x009b]
	.word 0xfa754000  ! 5365: STX_R	stx	%r29, [%r21 + %r0]
	.word 0xf42d8000  ! 5368: STB_R	stb	%r26, [%r22 + %r0]
	.word 0xbb50c000  ! 5369: RDPR_TT	rdpr	%tt, %r29
	.word 0xfa2dc000  ! 5370: STB_R	stb	%r29, [%r23 + %r0]
	.word 0xf82de168  ! 5371: STB_I	stb	%r28, [%r23 + 0x0168]
	.word 0xb8358000  ! 5373: ORN_R	orn 	%r22, %r0, %r28
hwintr_3_253:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_253), 16, 16)) -> intp(3, 0, 2b)
	.word 0xf73ca06a  ! 5377: STDF_I	std	%f27, [0x006a, %r18]
	.word 0xf8750000  ! 5382: STX_R	stx	%r28, [%r20 + %r0]
	.word 0xf63de00a  ! 5384: STD_I	std	%r27, [%r23 + 0x000a]
	.word 0xf2340000  ! 5386: STH_R	sth	%r25, [%r16 + %r0]
	.word 0xf425212e  ! 5389: STW_I	stw	%r26, [%r20 + 0x012e]
	.word 0xf875a0c9  ! 5393: STX_I	stx	%r28, [%r22 + 0x00c9]
	.word 0xf53da1ce  ! 5397: STDF_I	std	%f26, [0x01ce, %r22]
	.word 0xf02c8000  ! 5398: STB_R	stb	%r24, [%r18 + %r0]
hwintr_3_254:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_254), 16, 16)) -> intp(3, 0, 22)
	.word 0xfe2461a4  ! 5406: STW_I	stw	%r31, [%r17 + 0x01a4]
	.word 0xb82d8000  ! 5408: ANDN_R	andn 	%r22, %r0, %r28
	.word 0xb3480000  ! 5410: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xf0352019  ! 5411: STH_I	sth	%r24, [%r20 + 0x0019]
	.word 0xb5510000  ! 5414: RDPR_TICK	<illegal instruction>
	.word 0xf434a14b  ! 5415: STH_I	sth	%r26, [%r18 + 0x014b]
	.word 0xb7510000  ! 5429: RDPR_TICK	<illegal instruction>
	.word 0xf625a10c  ! 5431: STW_I	stw	%r27, [%r22 + 0x010c]
	.word 0xb5508000  ! 5434: RDPR_TSTATE	<illegal instruction>
	.word 0xbf518000  ! 5437: RDPR_PSTATE	<illegal instruction>
	.word 0x8995a056  ! 5441: WRPR_TICK_I	wrpr	%r22, 0x0056, %tick
	.word 0xf53ca1e8  ! 5443: STDF_I	std	%f26, [0x01e8, %r18]
	.word 0xb33c4000  ! 5446: SRA_R	sra 	%r17, %r0, %r25
	.word 0xfe2dc000  ! 5450: STB_R	stb	%r31, [%r23 + %r0]
	.word 0xb9520000  ! 5451: RDPR_PIL	rdpr	%pil, %r28
	.word 0xf43c0000  ! 5453: STD_R	std	%r26, [%r16 + %r0]
	.word 0xf6244000  ! 5456: STW_R	stw	%r27, [%r17 + %r0]
	.word 0xfa248000  ! 5458: STW_R	stw	%r29, [%r18 + %r0]
	.word 0xf42ce15d  ! 5466: STB_I	stb	%r26, [%r19 + 0x015d]
	.word 0xf63cc000  ! 5467: STD_R	std	%r27, [%r19 + %r0]
	.word 0xf63ce13c  ! 5469: STD_I	std	%r27, [%r19 + 0x013c]
	.word 0xf0754000  ! 5471: STX_R	stx	%r24, [%r21 + %r0]
	.word 0xf22c8000  ! 5472: STB_R	stb	%r25, [%r18 + %r0]
	.word 0xf13c8000  ! 5475: STDF_R	std	%f24, [%r0, %r18]
	.word 0xb02de0d8  ! 5478: ANDN_I	andn 	%r23, 0x00d8, %r24
hwintr_3_255:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_255), 16, 16)) -> intp(3, 0, 19)
	.word 0xfc2d21c5  ! 5482: STB_I	stb	%r30, [%r20 + 0x01c5]
	.word 0xbb508000  ! 5483: RDPR_TSTATE	<illegal instruction>
	.word 0xf33cc000  ! 5487: STDF_R	std	%f25, [%r0, %r19]
	.word 0xfa750000  ! 5488: STX_R	stx	%r29, [%r20 + %r0]
	.word 0xf02c4000  ! 5493: STB_R	stb	%r24, [%r17 + %r0]
	.word 0xf03de0a6  ! 5498: STD_I	std	%r24, [%r23 + 0x00a6]
	.word 0xfc348000  ! 5499: STH_R	sth	%r30, [%r18 + %r0]
	.word 0xb484209f  ! 5501: ADDcc_I	addcc 	%r16, 0x009f, %r26
	.word 0x919561a8  ! 5503: WRPR_PIL_I	wrpr	%r21, 0x01a8, %pil
	.word 0xfe74e12b  ! 5504: STX_I	stx	%r31, [%r19 + 0x012b]
	.word 0xf0356058  ! 5505: STH_I	sth	%r24, [%r21 + 0x0058]
	.word 0xb22d4000  ! 5506: ANDN_R	andn 	%r21, %r0, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81983d59  ! 5510: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d59, %hpstate
	.word 0xfa3d8000  ! 5512: STD_R	std	%r29, [%r22 + %r0]
	.word 0xfa2c0000  ! 5515: STB_R	stb	%r29, [%r16 + %r0]
	.word 0xb9500000  ! 5518: RDPR_TPC	rdpr	%tpc, %r28
	.word 0xfe2de0e4  ! 5519: STB_I	stb	%r31, [%r23 + 0x00e4]
	.word 0xb5518000  ! 5522: RDPR_PSTATE	<illegal instruction>
	.word 0xf6240000  ! 5523: STW_R	stw	%r27, [%r16 + %r0]
	.word 0xb9480000  ! 5525: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81983f19  ! 5531: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f19, %hpstate
	.word 0xfc756012  ! 5533: STX_I	stx	%r30, [%r21 + 0x0012]
	setx	data_start_2, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r20, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8d94a08a  ! 5548: WRPR_PSTATE_I	wrpr	%r18, 0x008a, %pstate
	.word 0xf23c8000  ! 5550: STD_R	std	%r25, [%r18 + %r0]
	.word 0x8d95a0ce  ! 5551: WRPR_PSTATE_I	wrpr	%r22, 0x00ce, %pstate
	.word 0xb5504000  ! 5555: RDPR_TNPC	rdpr	%tnpc, %r26
	.word 0xf835c000  ! 5558: STH_R	sth	%r28, [%r23 + %r0]
	.word 0xf42cc000  ! 5561: STB_R	stb	%r26, [%r19 + %r0]
	.word 0xf0252032  ! 5563: STW_I	stw	%r24, [%r20 + 0x0032]
hwintr_3_256:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_256), 16, 16)) -> intp(3, 0, 35)
	.word 0xfa348000  ! 5568: STH_R	sth	%r29, [%r18 + %r0]
	.word 0xb1508000  ! 5573: RDPR_TSTATE	<illegal instruction>
	.word 0xf6754000  ! 5574: STX_R	stx	%r27, [%r21 + %r0]
	.word 0xfc258000  ! 5575: STW_R	stw	%r30, [%r22 + %r0]
	.word 0xba1c60b6  ! 5579: XOR_I	xor 	%r17, 0x00b6, %r29
	.word 0xbb34b001  ! 5580: SRLX_I	srlx	%r18, 0x0001, %r29
	.word 0xf425e1f7  ! 5581: STW_I	stw	%r26, [%r23 + 0x01f7]
	mov	1, %r14
	.word 0xa193a000  ! 5585: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf474c000  ! 5586: STX_R	stx	%r26, [%r19 + %r0]
	.word 0x8d94e188  ! 5588: WRPR_PSTATE_I	wrpr	%r19, 0x0188, %pstate
	.word 0xb351c000  ! 5598: RDPR_TL	rdpr	%tl, %r25
	.word 0xf425c000  ! 5600: STW_R	stw	%r26, [%r23 + %r0]
	.word 0xfb3d8000  ! 5603: STDF_R	std	%f29, [%r0, %r22]
	mov	1, %r14
	.word 0xa193a000  ! 5607: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9504000  ! 5613: RDPR_TNPC	rdpr	%tnpc, %r28
	.word 0xf93c8000  ! 5615: STDF_R	std	%f28, [%r0, %r18]
	.word 0xfc758000  ! 5616: STX_R	stx	%r30, [%r22 + %r0]
	.word 0xf075c000  ! 5620: STX_R	stx	%r24, [%r23 + %r0]
	.word 0xf23ce068  ! 5621: STD_I	std	%r25, [%r19 + 0x0068]
	.word 0xfe3ca115  ! 5622: STD_I	std	%r31, [%r18 + 0x0115]
	.word 0xb32c4000  ! 5624: SLL_R	sll 	%r17, %r0, %r25
	.word 0xb32c3001  ! 5626: SLLX_I	sllx	%r16, 0x0001, %r25
	.word 0xb72d9000  ! 5629: SLLX_R	sllx	%r22, %r0, %r27
	.word 0xbb540000  ! 5630: RDPR_GL	<illegal instruction>
	.word 0xf234c000  ! 5633: STH_R	sth	%r25, [%r19 + %r0]
	.word 0xf93c8000  ! 5637: STDF_R	std	%f28, [%r0, %r18]
	.word 0xb1504000  ! 5640: RDPR_TNPC	<illegal instruction>
	.word 0xb5518000  ! 5642: RDPR_PSTATE	<illegal instruction>
	.word 0x8594605a  ! 5648: WRPR_TSTATE_I	wrpr	%r17, 0x005a, %tstate
	.word 0xbd480000  ! 5649: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xbf7c4400  ! 5650: MOVR_R	movre	%r17, %r0, %r31
	mov	0, %r12
	.word 0x8f932000  ! 5651: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf23ce147  ! 5655: STD_I	std	%r25, [%r19 + 0x0147]
	.word 0xf034a1b7  ! 5656: STH_I	sth	%r24, [%r18 + 0x01b7]
	.word 0xfa35a1e6  ! 5657: STH_I	sth	%r29, [%r22 + 0x01e6]
	.word 0xbc94c000  ! 5658: ORcc_R	orcc 	%r19, %r0, %r30
	.word 0xfa3d0000  ! 5659: STD_R	std	%r29, [%r20 + %r0]
	.word 0x9194201e  ! 5667: WRPR_PIL_I	wrpr	%r16, 0x001e, %pil
	.word 0xb23d8000  ! 5672: XNOR_R	xnor 	%r22, %r0, %r25
	.word 0xf6744000  ! 5673: STX_R	stx	%r27, [%r17 + %r0]
	.word 0x8194605f  ! 5679: WRPR_TPC_I	wrpr	%r17, 0x005f, %tpc
hwintr_3_257:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_257), 16, 16)) -> intp(3, 0, 36)
	ta	T_CHANGE_HPRIV
	.word 0x81982f13  ! 5688: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f13, %hpstate
	.word 0xbd540000  ! 5691: RDPR_GL	rdpr	%-, %r30
hwintr_3_258:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_258), 16, 16)) -> intp(3, 0, 0)
	.word 0xb6840000  ! 5696: ADDcc_R	addcc 	%r16, %r0, %r27
	.word 0xf53d8000  ! 5698: STDF_R	std	%f26, [%r0, %r22]
	.word 0xf43dc000  ! 5703: STD_R	std	%r26, [%r23 + %r0]
	.word 0xb150c000  ! 5707: RDPR_TT	<illegal instruction>
	.word 0xb3518000  ! 5708: RDPR_PSTATE	<illegal instruction>
	.word 0xf83da11b  ! 5709: STD_I	std	%r28, [%r22 + 0x011b]
	.word 0xf03c6071  ! 5718: STD_I	std	%r24, [%r17 + 0x0071]
	.word 0xf4354000  ! 5720: STH_R	sth	%r26, [%r21 + %r0]
hwintr_3_259:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_259), 16, 16)) -> intp(3, 0, 1f)
hwintr_3_260:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_260), 16, 16)) -> intp(3, 0, 18)
	mov	2, %r12
	.word 0x8f932000  ! 5732: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfb3d4000  ! 5734: STDF_R	std	%f29, [%r0, %r21]
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xfa35a0f7  ! 5736: STH_I	sth	%r29, [%r22 + 0x00f7]
	.word 0xf83c610d  ! 5737: STD_I	std	%r28, [%r17 + 0x010d]
	.word 0xbe3c6096  ! 5738: XNOR_I	xnor 	%r17, 0x0096, %r31
	.word 0xf63ce131  ! 5739: STD_I	std	%r27, [%r19 + 0x0131]
	.word 0xb5500000  ! 5742: RDPR_TPC	rdpr	%tpc, %r26
hwintr_3_261:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_261), 16, 16)) -> intp(3, 0, 2)
	.word 0xfc3d8000  ! 5746: STD_R	std	%r30, [%r22 + %r0]
	.word 0xbb518000  ! 5752: RDPR_PSTATE	<illegal instruction>
	.word 0xf93d2093  ! 5753: STDF_I	std	%f28, [0x0093, %r20]
	.word 0xf53d4000  ! 5761: STDF_R	std	%f26, [%r0, %r21]
	.word 0xf4252122  ! 5765: STW_I	stw	%r26, [%r20 + 0x0122]
	.word 0xfd3c200f  ! 5766: STDF_I	std	%f30, [0x000f, %r16]
	.word 0xbf480000  ! 5767: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	mov	2, %r12
	.word 0x8f932000  ! 5769: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb1508000  ! 5771: RDPR_TSTATE	rdpr	%tstate, %r24
	.word 0xf42c4000  ! 5777: STB_R	stb	%r26, [%r17 + %r0]
	.word 0xf22d61dd  ! 5779: STB_I	stb	%r25, [%r21 + 0x01dd]
hwintr_3_262:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_262), 16, 16)) -> intp(3, 0, 15)
hwintr_3_263:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_263), 16, 16)) -> intp(3, 0, 18)
	.word 0x899421cb  ! 5783: WRPR_TICK_I	wrpr	%r16, 0x01cb, %tick
	.word 0x85956070  ! 5784: WRPR_TSTATE_I	wrpr	%r21, 0x0070, %tstate
	.word 0x8395e1f2  ! 5785: WRPR_TNPC_I	wrpr	%r23, 0x01f2, %tnpc
	.word 0xbd3c4000  ! 5794: SRA_R	sra 	%r17, %r0, %r30
	.word 0xf82460b5  ! 5797: STW_I	stw	%r28, [%r17 + 0x00b5]
	.word 0xfc2d0000  ! 5798: STB_R	stb	%r30, [%r20 + %r0]
hwintr_3_264:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_264), 16, 16)) -> intp(3, 0, 1f)
	.word 0xf02c0000  ! 5801: STB_R	stb	%r24, [%r16 + %r0]
	.word 0xfc2c6040  ! 5803: STB_I	stb	%r30, [%r17 + 0x0040]
	.word 0xfe354000  ! 5805: STH_R	sth	%r31, [%r21 + %r0]
	.word 0xf425a1d4  ! 5808: STW_I	stw	%r26, [%r22 + 0x01d4]
	.word 0xf23da07d  ! 5809: STD_I	std	%r25, [%r22 + 0x007d]
	.word 0xbb520000  ! 5811: RDPR_PIL	rdpr	%pil, %r29
	.word 0xb0a5a15c  ! 5824: SUBcc_I	subcc 	%r22, 0x015c, %r24
	.word 0xfe2c6116  ! 5825: STB_I	stb	%r31, [%r17 + 0x0116]
	.word 0xb5340000  ! 5829: SRL_R	srl 	%r16, %r0, %r26
	.word 0xb4358000  ! 5832: ORN_R	orn 	%r22, %r0, %r26
	.word 0xbd3c5000  ! 5833: SRAX_R	srax	%r17, %r0, %r30
	.word 0xf875a14a  ! 5834: STX_I	stx	%r28, [%r22 + 0x014a]
	.word 0xb350c000  ! 5838: RDPR_TT	<illegal instruction>
	.word 0xf73d20b8  ! 5839: STDF_I	std	%f27, [0x00b8, %r20]
	.word 0x8794a06a  ! 5840: WRPR_TT_I	wrpr	%r18, 0x006a, %tt
	.word 0xf83ca01a  ! 5841: STD_I	std	%r28, [%r18 + 0x001a]
	.word 0xf33d8000  ! 5846: STDF_R	std	%f25, [%r0, %r22]
	.word 0xb7500000  ! 5848: RDPR_TPC	rdpr	%tpc, %r27
	.word 0xf73c8000  ! 5849: STDF_R	std	%f27, [%r0, %r18]
	.word 0xfa2ce0d6  ! 5853: STB_I	stb	%r29, [%r19 + 0x00d6]
	.word 0xf73da0e5  ! 5854: STDF_I	std	%f27, [0x00e5, %r22]
	.word 0x8995a143  ! 5855: WRPR_TICK_I	wrpr	%r22, 0x0143, %tick
	.word 0xfe74a030  ! 5857: STX_I	stx	%r31, [%r18 + 0x0030]
	.word 0xb7508000  ! 5860: RDPR_TSTATE	rdpr	%tstate, %r27
	.word 0xff3ca08f  ! 5861: STDF_I	std	%f31, [0x008f, %r18]
	.word 0xf33c4000  ! 5863: STDF_R	std	%f25, [%r0, %r17]
	mov	1, %r14
	.word 0xa193a000  ! 5864: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf82520a4  ! 5866: STW_I	stw	%r28, [%r20 + 0x00a4]
	.word 0x8394a09e  ! 5869: WRPR_TNPC_I	wrpr	%r18, 0x009e, %tnpc
	.word 0xf6246127  ! 5872: STW_I	stw	%r27, [%r17 + 0x0127]
	.word 0xfa7460b9  ! 5873: STX_I	stx	%r29, [%r17 + 0x00b9]
	.word 0xb17d2401  ! 5875: MOVR_I	movre	%r20, 0x1, %r24
	.word 0xb9510000  ! 5877: RDPR_TICK	rdpr	%tick, %r28
	.word 0xb8042021  ! 5878: ADD_I	add 	%r16, 0x0021, %r28
	.word 0xb6b5c000  ! 5879: ORNcc_R	orncc 	%r23, %r0, %r27
	.word 0xbf510000  ! 5881: RDPR_TICK	<illegal instruction>
hwintr_3_265:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_265), 16, 16)) -> intp(3, 0, 2d)
	.word 0xbb2d7001  ! 5883: SLLX_I	sllx	%r21, 0x0001, %r29
	.word 0xfe344000  ! 5886: STH_R	sth	%r31, [%r17 + %r0]
	.word 0xb4154000  ! 5887: OR_R	or 	%r21, %r0, %r26
	.word 0xfe74e10c  ! 5890: STX_I	stx	%r31, [%r19 + 0x010c]
hwintr_3_266:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_266), 16, 16)) -> intp(3, 0, 1c)
hwintr_3_267:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_267), 16, 16)) -> intp(3, 0, 16)
	.word 0xf53c0000  ! 5893: STDF_R	std	%f26, [%r0, %r16]
	.word 0xfd3cc000  ! 5894: STDF_R	std	%f30, [%r0, %r19]
	.word 0xbd520000  ! 5895: RDPR_PIL	<illegal instruction>
	.word 0xf43de033  ! 5898: STD_I	std	%r26, [%r23 + 0x0033]
	.word 0xfc248000  ! 5902: STW_R	stw	%r30, [%r18 + %r0]
hwintr_3_268:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_268), 16, 16)) -> intp(3, 0, 32)
	.word 0xfc358000  ! 5904: STH_R	sth	%r30, [%r22 + %r0]
	.word 0xfe358000  ! 5917: STH_R	sth	%r31, [%r22 + %r0]
	.word 0xb5540000  ! 5920: RDPR_GL	<illegal instruction>
	.word 0xb33c6001  ! 5921: SRA_I	sra 	%r17, 0x0001, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81982b1b  ! 5930: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b1b, %hpstate
	.word 0xbeb54000  ! 5931: ORNcc_R	orncc 	%r21, %r0, %r31
	setx	data_start_6, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_269:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_269), 16, 16)) -> intp(3, 0, 30)
	.word 0xb9520000  ! 5938: RDPR_PIL	rdpr	%pil, %r28
	.word 0xb2b56120  ! 5940: SUBCcc_I	orncc 	%r21, 0x0120, %r25
hwintr_3_270:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_270), 16, 16)) -> intp(3, 0, 1b)
	.word 0xbe9c8000  ! 5946: XORcc_R	xorcc 	%r18, %r0, %r31
	.word 0xb8848000  ! 5949: ADDcc_R	addcc 	%r18, %r0, %r28
	.word 0xf42c60d2  ! 5951: STB_I	stb	%r26, [%r17 + 0x00d2]
	.word 0xf82ce1cb  ! 5956: STB_I	stb	%r28, [%r19 + 0x01cb]
	.word 0x8995a10c  ! 5960: WRPR_TICK_I	wrpr	%r22, 0x010c, %tick
	.word 0xf024606b  ! 5963: STW_I	stw	%r24, [%r17 + 0x006b]
	.word 0xff3da040  ! 5965: STDF_I	std	%f31, [0x0040, %r22]
	.word 0xf4248000  ! 5966: STW_R	stw	%r26, [%r18 + %r0]
	.word 0xf0354000  ! 5970: STH_R	sth	%r24, [%r21 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982dd3  ! 5971: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dd3, %hpstate
	.word 0xb32dc000  ! 5972: SLL_R	sll 	%r23, %r0, %r25
hwintr_3_271:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_271), 16, 16)) -> intp(3, 0, 17)
	.word 0xfa74a01e  ! 5976: STX_I	stx	%r29, [%r18 + 0x001e]
	.word 0xb12c1000  ! 5978: SLLX_R	sllx	%r16, %r0, %r24
	.word 0xf23ce032  ! 5983: STD_I	std	%r25, [%r19 + 0x0032]
	.word 0x8995a190  ! 5987: WRPR_TICK_I	wrpr	%r22, 0x0190, %tick
	.word 0xf03ca14d  ! 5988: STD_I	std	%r24, [%r18 + 0x014d]
	.word 0xb5500000  ! 5992: RDPR_TPC	rdpr	%tpc, %r26
	.word 0xbaade0bd  ! 5993: ANDNcc_I	andncc 	%r23, 0x00bd, %r29
	.word 0xf824e06c  ! 5995: STW_I	stw	%r28, [%r19 + 0x006c]
	.word 0xf33d210c  ! 5997: STDF_I	std	%f25, [0x010c, %r20]
	mov	2, %r14
	.word 0xa193a000  ! 6002: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9500000  ! 6003: RDPR_TPC	rdpr	%tpc, %r28
	.word 0xfa758000  ! 6005: STX_R	stx	%r29, [%r22 + %r0]
	.word 0xf93d609d  ! 6006: STDF_I	std	%f28, [0x009d, %r21]
	.word 0xfe24a042  ! 6007: STW_I	stw	%r31, [%r18 + 0x0042]
	.word 0x9194a173  ! 6008: WRPR_PIL_I	wrpr	%r18, 0x0173, %pil
hwintr_3_272:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_272), 16, 16)) -> intp(3, 0, 3e)
	ta	T_CHANGE_HPRIV
	.word 0x81983f51  ! 6011: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f51, %hpstate
	.word 0x879460d3  ! 6012: WRPR_TT_I	wrpr	%r17, 0x00d3, %tt
	.word 0xfc3421af  ! 6014: STH_I	sth	%r30, [%r16 + 0x01af]
	.word 0xf824606f  ! 6016: STW_I	stw	%r28, [%r17 + 0x006f]
	.word 0xf42da12a  ! 6017: STB_I	stb	%r26, [%r22 + 0x012a]
	.word 0x9195e0be  ! 6020: WRPR_PIL_I	wrpr	%r23, 0x00be, %pil
	.word 0xf02c0000  ! 6023: STB_R	stb	%r24, [%r16 + %r0]
	.word 0xb8b4c000  ! 6024: ORNcc_R	orncc 	%r19, %r0, %r28
hwintr_3_273:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_273), 16, 16)) -> intp(3, 0, 9)
	.word 0xf6344000  ! 6029: STH_R	sth	%r27, [%r17 + %r0]
	.word 0xbb540000  ! 6030: RDPR_GL	rdpr	%-, %r29
	.word 0xfa74e17d  ! 6032: STX_I	stx	%r29, [%r19 + 0x017d]
	.word 0xb1344000  ! 6038: SRL_R	srl 	%r17, %r0, %r24
	.word 0xfb3cc000  ! 6039: STDF_R	std	%f29, [%r0, %r19]
	.word 0xf82c6170  ! 6040: STB_I	stb	%r28, [%r17 + 0x0170]
	.word 0xfc2da15c  ! 6043: STB_I	stb	%r30, [%r22 + 0x015c]
	.word 0xb550c000  ! 6044: RDPR_TT	<illegal instruction>
	.word 0xb8ade032  ! 6045: ANDNcc_I	andncc 	%r23, 0x0032, %r28
	.word 0xfe350000  ! 6053: STH_R	sth	%r31, [%r20 + %r0]
hwintr_3_274:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_274), 16, 16)) -> intp(3, 0, 33)
	.word 0xba158000  ! 6058: OR_R	or 	%r22, %r0, %r29
	.word 0xfc2d0000  ! 6065: STB_R	stb	%r30, [%r20 + %r0]
	.word 0xf93c0000  ! 6067: STDF_R	std	%f28, [%r0, %r16]
hwintr_3_275:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_275), 16, 16)) -> intp(3, 0, 32)
	.word 0xfc2ce0f1  ! 6070: STB_I	stb	%r30, [%r19 + 0x00f1]
	.word 0x8594a0c8  ! 6071: WRPR_TSTATE_I	wrpr	%r18, 0x00c8, %tstate
	.word 0xbd641800  ! 6072: MOVcc_R	<illegal instruction>
	setx	data_start_5, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_276:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_276), 16, 16)) -> intp(3, 0, 32)
	.word 0x8395a15a  ! 6078: WRPR_TNPC_I	wrpr	%r22, 0x015a, %tnpc
	.word 0xfe2da1f9  ! 6081: STB_I	stb	%r31, [%r22 + 0x01f9]
	.word 0xf27421c9  ! 6084: STX_I	stx	%r25, [%r16 + 0x01c9]
	.word 0xf2340000  ! 6086: STH_R	sth	%r25, [%r16 + %r0]
	.word 0xf2754000  ! 6087: STX_R	stx	%r25, [%r21 + %r0]
	.word 0xb5540000  ! 6091: RDPR_GL	rdpr	%-, %r26
	.word 0xff3d8000  ! 6094: STDF_R	std	%f31, [%r0, %r22]
	.word 0xf024e1ba  ! 6095: STW_I	stw	%r24, [%r19 + 0x01ba]
hwintr_3_277:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_277), 16, 16)) -> intp(3, 0, 36)
	.word 0xf475205d  ! 6097: STX_I	stx	%r26, [%r20 + 0x005d]
	.word 0xfc240000  ! 6100: STW_R	stw	%r30, [%r16 + %r0]
	.word 0xf4742030  ! 6103: STX_I	stx	%r26, [%r16 + 0x0030]
	.word 0xf0358000  ! 6106: STH_R	sth	%r24, [%r22 + %r0]
	.word 0xf424c000  ! 6107: STW_R	stw	%r26, [%r19 + %r0]
hwintr_3_278:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_278), 16, 16)) -> intp(3, 0, 16)
	.word 0x83952004  ! 6111: WRPR_TNPC_I	wrpr	%r20, 0x0004, %tnpc
	.word 0xb1480000  ! 6114: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
hwintr_3_279:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_279), 16, 16)) -> intp(3, 0, d)
	.word 0x8d95e139  ! 6118: WRPR_PSTATE_I	wrpr	%r23, 0x0139, %pstate
	.word 0xf02dc000  ! 6120: STB_R	stb	%r24, [%r23 + %r0]
	.word 0xfe2ce0c2  ! 6125: STB_I	stb	%r31, [%r19 + 0x00c2]
	.word 0xfc24608e  ! 6126: STW_I	stw	%r30, [%r17 + 0x008e]
hwintr_3_280:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_280), 16, 16)) -> intp(3, 0, 25)
	.word 0xb5500000  ! 6128: RDPR_TPC	rdpr	%tpc, %r26
	.word 0xf83c6056  ! 6130: STD_I	std	%r28, [%r17 + 0x0056]
	.word 0xfc35c000  ! 6131: STH_R	sth	%r30, [%r23 + %r0]
	.word 0xf6342031  ! 6135: STH_I	sth	%r27, [%r16 + 0x0031]
	.word 0xf8356143  ! 6136: STH_I	sth	%r28, [%r21 + 0x0143]
	ta	T_CHANGE_HPRIV
	.word 0x8198280b  ! 6140: WRHPR_HPSTATE_I	wrhpr	%r0, 0x080b, %hpstate
	.word 0xff3c214a  ! 6141: STDF_I	std	%f31, [0x014a, %r16]
	.word 0xfc2de076  ! 6145: STB_I	stb	%r30, [%r23 + 0x0076]
	.word 0x8195a0c2  ! 6148: WRPR_TPC_I	wrpr	%r22, 0x00c2, %tpc
	.word 0xbf510000  ! 6151: RDPR_TICK	rdpr	%tick, %r31
	.word 0xf4344000  ! 6152: STH_R	sth	%r26, [%r17 + %r0]
	.word 0xfa2da0f3  ! 6156: STB_I	stb	%r29, [%r22 + 0x00f3]
	.word 0xf93d60bd  ! 6158: STDF_I	std	%f28, [0x00bd, %r21]
	.word 0xb4bd614c  ! 6160: XNORcc_I	xnorcc 	%r21, 0x014c, %r26
	.word 0xb134e001  ! 6161: SRL_I	srl 	%r19, 0x0001, %r24
	.word 0xb57dc400  ! 6162: MOVR_R	movre	%r23, %r0, %r26
	.word 0xfc24e1fe  ! 6164: STW_I	stw	%r30, [%r19 + 0x01fe]
	.word 0xfe254000  ! 6169: STW_R	stw	%r31, [%r21 + %r0]
	.word 0xf83c2147  ! 6171: STD_I	std	%r28, [%r16 + 0x0147]
	.word 0xf82ce19b  ! 6176: STB_I	stb	%r28, [%r19 + 0x019b]
	.word 0xf07560f4  ! 6179: STX_I	stx	%r24, [%r21 + 0x00f4]
	.word 0x819460b5  ! 6181: WRPR_TPC_I	wrpr	%r17, 0x00b5, %tpc
	.word 0xf4248000  ! 6183: STW_R	stw	%r26, [%r18 + %r0]
	.word 0xfa3560a1  ! 6186: STH_I	sth	%r29, [%r21 + 0x00a1]
	.word 0xfc35a1cd  ! 6189: STH_I	sth	%r30, [%r22 + 0x01cd]
	.word 0xff3ca007  ! 6194: STDF_I	std	%f31, [0x0007, %r18]
	.word 0xbe456102  ! 6195: ADDC_I	addc 	%r21, 0x0102, %r31
	.word 0xbf50c000  ! 6197: RDPR_TT	rdpr	%tt, %r31
	.word 0xf93ce039  ! 6198: STDF_I	std	%f28, [0x0039, %r19]
hwintr_3_281:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_281), 16, 16)) -> intp(3, 0, 1)
	.word 0xb3510000  ! 6200: RDPR_TICK	<illegal instruction>
hwintr_3_282:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_282), 16, 16)) -> intp(3, 0, 8)
	.word 0xb3540000  ! 6207: RDPR_GL	<illegal instruction>
	.word 0xbb510000  ! 6208: RDPR_TICK	<illegal instruction>
	mov	0, %r14
	.word 0xa193a000  ! 6209: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	mov	0, %r14
	.word 0xa193a000  ! 6210: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfa358000  ! 6211: STH_R	sth	%r29, [%r22 + %r0]
	.word 0xfe346038  ! 6212: STH_I	sth	%r31, [%r17 + 0x0038]
	.word 0xf62d0000  ! 6213: STB_R	stb	%r27, [%r20 + %r0]
hwintr_3_283:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_283), 16, 16)) -> intp(3, 0, 9)
hwintr_3_284:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_284), 16, 16)) -> intp(3, 0, 2f)
hwintr_3_285:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_285), 16, 16)) -> intp(3, 0, c)
	.word 0xf82ca1e1  ! 6222: STB_I	stb	%r28, [%r18 + 0x01e1]
	.word 0xfd3c4000  ! 6225: STDF_R	std	%f30, [%r0, %r17]
	.word 0xf43da00f  ! 6233: STD_I	std	%r26, [%r22 + 0x000f]
	.word 0xb5520000  ! 6235: RDPR_PIL	rdpr	%pil, %r26
hwintr_3_286:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_286), 16, 16)) -> intp(3, 0, 25)
	.word 0x919521fc  ! 6237: WRPR_PIL_I	wrpr	%r20, 0x01fc, %pil
	.word 0x85946004  ! 6238: WRPR_TSTATE_I	wrpr	%r17, 0x0004, %tstate
	.word 0xf07420a9  ! 6242: STX_I	stx	%r24, [%r16 + 0x00a9]
	.word 0x8595616b  ! 6245: WRPR_TSTATE_I	wrpr	%r21, 0x016b, %tstate
	.word 0xb5520000  ! 6246: RDPR_PIL	rdpr	%pil, %r26
	.word 0xf43c0000  ! 6247: STD_R	std	%r26, [%r16 + %r0]
hwintr_3_287:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_287), 16, 16)) -> intp(3, 0, 1b)
	.word 0xf42460d8  ! 6250: STW_I	stw	%r26, [%r17 + 0x00d8]
	.word 0xf53c2097  ! 6251: STDF_I	std	%f26, [0x0097, %r16]
	.word 0xf6348000  ! 6255: STH_R	sth	%r27, [%r18 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81983d11  ! 6256: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d11, %hpstate
	.word 0xb3518000  ! 6257: RDPR_PSTATE	rdpr	%pstate, %r25
	.word 0xbb480000  ! 6267: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0x8194e005  ! 6268: WRPR_TPC_I	wrpr	%r19, 0x0005, %tpc
	.word 0xf2750000  ! 6270: STX_R	stx	%r25, [%r20 + %r0]
	.word 0xf02c2089  ! 6273: STB_I	stb	%r24, [%r16 + 0x0089]
	.word 0xf024e1d6  ! 6274: STW_I	stw	%r24, [%r19 + 0x01d6]
	.word 0xf02c0000  ! 6279: STB_R	stb	%r24, [%r16 + %r0]
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
hwintr_3_288:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_288), 16, 16)) -> intp(3, 0, 1f)
	.word 0xbd2ca001  ! 6298: SLL_I	sll 	%r18, 0x0001, %r30
	.word 0xb9520000  ! 6299: RDPR_PIL	rdpr	%pil, %r28
	.word 0xfd3cc000  ! 6302: STDF_R	std	%f30, [%r0, %r19]
	.word 0xb605e177  ! 6303: ADD_I	add 	%r23, 0x0177, %r27
hwintr_3_289:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_289), 16, 16)) -> intp(3, 0, 3c)
hwintr_3_290:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_290), 16, 16)) -> intp(3, 0, b)
	.word 0xb13cb001  ! 6307: SRAX_I	srax	%r18, 0x0001, %r24
	.word 0xf8344000  ! 6308: STH_R	sth	%r28, [%r17 + %r0]
	setx	data_start_4, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb82ce111  ! 6310: ANDN_I	andn 	%r19, 0x0111, %r28
	.word 0xba1cc000  ! 6311: XOR_R	xor 	%r19, %r0, %r29
	.word 0xf82c4000  ! 6312: STB_R	stb	%r28, [%r17 + %r0]
	.word 0xf23ce0d5  ! 6314: STD_I	std	%r25, [%r19 + 0x00d5]
	.word 0x8d95a0fa  ! 6320: WRPR_PSTATE_I	wrpr	%r22, 0x00fa, %pstate
	.word 0xf2248000  ! 6322: STW_R	stw	%r25, [%r18 + %r0]
	.word 0xbf520000  ! 6323: RDPR_PIL	rdpr	%pil, %r31
	.word 0xbd51c000  ! 6324: RDPR_TL	<illegal instruction>
	.word 0xfa248000  ! 6325: STW_R	stw	%r29, [%r18 + %r0]
	.word 0xfe754000  ! 6326: STX_R	stx	%r31, [%r21 + %r0]
hwintr_3_291:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_291), 16, 16)) -> intp(3, 0, 7)
	.word 0x8595a0e9  ! 6330: WRPR_TSTATE_I	wrpr	%r22, 0x00e9, %tstate
	.word 0xf13ca15d  ! 6333: STDF_I	std	%f24, [0x015d, %r18]
	.word 0xb7480000  ! 6334: RDHPR_HPSTATE	rdhpr	%hpstate, %r27
	.word 0xbb51c000  ! 6336: RDPR_TL	<illegal instruction>
	.word 0xb6350000  ! 6337: SUBC_R	orn 	%r20, %r0, %r27
	.word 0xf73c603d  ! 6338: STDF_I	std	%f27, [0x003d, %r17]
	.word 0xfa2ce11d  ! 6340: STB_I	stb	%r29, [%r19 + 0x011d]
	mov	2, %r12
	.word 0x8f932000  ! 6344: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf73c8000  ! 6350: STDF_R	std	%f27, [%r0, %r18]
	.word 0xf63ce139  ! 6351: STD_I	std	%r27, [%r19 + 0x0139]
	mov	0, %r12
	.word 0x8f932000  ! 6354: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x8795615f  ! 6357: WRPR_TT_I	wrpr	%r21, 0x015f, %tt
hwintr_3_292:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_292), 16, 16)) -> intp(3, 0, f)
	.word 0xbb480000  ! 6359: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xf6340000  ! 6363: STH_R	sth	%r27, [%r16 + %r0]
	.word 0xfc3c60ab  ! 6365: STD_I	std	%r30, [%r17 + 0x00ab]
	.word 0xfc340000  ! 6366: STH_R	sth	%r30, [%r16 + %r0]
	.word 0xfa2dc000  ! 6368: STB_R	stb	%r29, [%r23 + %r0]
	.word 0xf235a144  ! 6370: STH_I	sth	%r25, [%r22 + 0x0144]
	.word 0xb0844000  ! 6372: ADDcc_R	addcc 	%r17, %r0, %r24
hwintr_3_293:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_293), 16, 16)) -> intp(3, 0, 35)
	.word 0xf03cc000  ! 6374: STD_R	std	%r24, [%r19 + %r0]
	setx	data_start_5, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf2346180  ! 6383: STH_I	sth	%r25, [%r17 + 0x0180]
	.word 0xb89cc000  ! 6384: XORcc_R	xorcc 	%r19, %r0, %r28
	.word 0xfd3d4000  ! 6388: STDF_R	std	%f30, [%r0, %r21]
	.word 0xb425c000  ! 6389: SUB_R	sub 	%r23, %r0, %r26
	.word 0xfd3d4000  ! 6392: STDF_R	std	%f30, [%r0, %r21]
	.word 0xf824e092  ! 6395: STW_I	stw	%r28, [%r19 + 0x0092]
	.word 0xfe344000  ! 6398: STH_R	sth	%r31, [%r17 + %r0]
	.word 0x879520e5  ! 6403: WRPR_TT_I	wrpr	%r20, 0x00e5, %tt
	.word 0xfe25c000  ! 6405: STW_R	stw	%r31, [%r23 + %r0]
	.word 0xfe2c8000  ! 6406: STB_R	stb	%r31, [%r18 + %r0]
	.word 0xf434c000  ! 6409: STH_R	sth	%r26, [%r19 + %r0]
	.word 0xbb504000  ! 6414: RDPR_TNPC	rdpr	%tnpc, %r29
	.word 0xf83de16a  ! 6415: STD_I	std	%r28, [%r23 + 0x016a]
	.word 0xf2756181  ! 6416: STX_I	stx	%r25, [%r21 + 0x0181]
	.word 0xfd3d8000  ! 6418: STDF_R	std	%f30, [%r0, %r22]
hwintr_3_294:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_294), 16, 16)) -> intp(3, 0, 4)
	ta	T_CHANGE_HPRIV
	.word 0x81983a41  ! 6425: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a41, %hpstate
	.word 0xb7518000  ! 6427: RDPR_PSTATE	rdpr	%pstate, %r27
	.word 0x819520bd  ! 6433: WRPR_TPC_I	wrpr	%r20, 0x00bd, %tpc
	.word 0xf82cc000  ! 6434: STB_R	stb	%r28, [%r19 + %r0]
	.word 0xb5480000  ! 6435: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xfe750000  ! 6438: STX_R	stx	%r31, [%r20 + %r0]
hwintr_3_295:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_295), 16, 16)) -> intp(3, 0, e)
hwintr_3_296:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_296), 16, 16)) -> intp(3, 0, 16)
	.word 0xfa2cc000  ! 6443: STB_R	stb	%r29, [%r19 + %r0]
	.word 0xbb2d9000  ! 6444: SLLX_R	sllx	%r22, %r0, %r29
hwintr_3_297:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_297), 16, 16)) -> intp(3, 0, 19)
	.word 0xb52dd000  ! 6449: SLLX_R	sllx	%r23, %r0, %r26
hwintr_3_298:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_298), 16, 16)) -> intp(3, 0, 3a)
	.word 0xfa3c8000  ! 6455: STD_R	std	%r29, [%r18 + %r0]
	.word 0xf33de062  ! 6460: STDF_I	std	%f25, [0x0062, %r23]
	.word 0x81956157  ! 6461: WRPR_TPC_I	wrpr	%r21, 0x0157, %tpc
	ta	T_CHANGE_HPRIV
	.word 0x81983a99  ! 6463: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a99, %hpstate
hwintr_3_299:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_299), 16, 16)) -> intp(3, 0, 1a)
	ta	T_CHANGE_HPRIV
	.word 0x81982b83  ! 6465: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b83, %hpstate
	.word 0xb48c0000  ! 6468: ANDcc_R	andcc 	%r16, %r0, %r26
	.word 0xf82dc000  ! 6471: STB_R	stb	%r28, [%r23 + %r0]
	.word 0xfc258000  ! 6474: STW_R	stw	%r30, [%r22 + %r0]
	.word 0xb33d8000  ! 6476: SRA_R	sra 	%r22, %r0, %r25
	.word 0x8394a046  ! 6477: WRPR_TNPC_I	wrpr	%r18, 0x0046, %tnpc
	.word 0xfa3da1c6  ! 6479: STD_I	std	%r29, [%r22 + 0x01c6]
	.word 0xfd3da16b  ! 6480: STDF_I	std	%f30, [0x016b, %r22]
	.word 0xf23c2116  ! 6481: STD_I	std	%r25, [%r16 + 0x0116]
	.word 0x8394e078  ! 6483: WRPR_TNPC_I	wrpr	%r19, 0x0078, %tnpc
	.word 0xbb540000  ! 6485: RDPR_GL	rdpr	%-, %r29
	.word 0xb5348000  ! 6488: SRL_R	srl 	%r18, %r0, %r26
	.word 0xfe2cc000  ! 6493: STB_R	stb	%r31, [%r19 + %r0]
	.word 0xf73dc000  ! 6494: STDF_R	std	%f27, [%r0, %r23]
	.word 0x9195a05b  ! 6498: WRPR_PIL_I	wrpr	%r22, 0x005b, %pil
	.word 0xf625215a  ! 6501: STW_I	stw	%r27, [%r20 + 0x015a]
	.word 0x8194e12b  ! 6503: WRPR_TPC_I	wrpr	%r19, 0x012b, %tpc
	.word 0xb5520000  ! 6505: RDPR_PIL	rdpr	%pil, %r26
	.word 0xf82c21bd  ! 6506: STB_I	stb	%r28, [%r16 + 0x01bd]
	.word 0xfe2ce1bc  ! 6514: STB_I	stb	%r31, [%r19 + 0x01bc]
hwintr_3_300:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_300), 16, 16)) -> intp(3, 0, 32)
hwintr_3_301:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_301), 16, 16)) -> intp(3, 0, 23)
	.word 0x8394a1b2  ! 6519: WRPR_TNPC_I	wrpr	%r18, 0x01b2, %tnpc
	.word 0x87956028  ! 6520: WRPR_TT_I	wrpr	%r21, 0x0028, %tt
	.word 0xb9510000  ! 6523: RDPR_TICK	rdpr	%tick, %r28
	.word 0xb8c42186  ! 6526: ADDCcc_I	addccc 	%r16, 0x0186, %r28
	.word 0xbd500000  ! 6529: RDPR_TPC	<illegal instruction>
	.word 0xfc354000  ! 6532: STH_R	sth	%r30, [%r21 + %r0]
	.word 0xfa34e098  ! 6533: STH_I	sth	%r29, [%r19 + 0x0098]
	setx	data_start_0, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf035c000  ! 6545: STH_R	sth	%r24, [%r23 + %r0]
	.word 0xbebd4000  ! 6546: XNORcc_R	xnorcc 	%r21, %r0, %r31
	.word 0xf53cc000  ! 6548: STDF_R	std	%f26, [%r0, %r19]
	.word 0xbb2da001  ! 6551: SLL_I	sll 	%r22, 0x0001, %r29
	.word 0xb1508000  ! 6552: RDPR_TSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x819838c3  ! 6553: WRHPR_HPSTATE_I	wrhpr	%r0, 0x18c3, %hpstate
	.word 0xba3c4000  ! 6554: XNOR_R	xnor 	%r17, %r0, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81983dd9  ! 6555: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1dd9, %hpstate
	.word 0xb53c8000  ! 6557: SRA_R	sra 	%r18, %r0, %r26
	.word 0xbb7c0400  ! 6562: MOVR_R	movre	%r16, %r0, %r29
	.word 0xfe25c000  ! 6564: STW_R	stw	%r31, [%r23 + %r0]
	.word 0xf875611d  ! 6566: STX_I	stx	%r28, [%r21 + 0x011d]
	.word 0x91952059  ! 6567: WRPR_PIL_I	wrpr	%r20, 0x0059, %pil
	.word 0xbd480000  ! 6568: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xfc74c000  ! 6570: STX_R	stx	%r30, [%r19 + %r0]
	.word 0xb4458000  ! 6571: ADDC_R	addc 	%r22, %r0, %r26
	.word 0xf93c60cd  ! 6572: STDF_I	std	%f28, [0x00cd, %r17]
	.word 0x899520af  ! 6577: WRPR_TICK_I	wrpr	%r20, 0x00af, %tick
	.word 0xf42c0000  ! 6583: STB_R	stb	%r26, [%r16 + %r0]
	.word 0x8d956103  ! 6584: WRPR_PSTATE_I	wrpr	%r21, 0x0103, %pstate
	.word 0xf23c2100  ! 6587: STD_I	std	%r25, [%r16 + 0x0100]
	.word 0xf63c8000  ! 6592: STD_R	std	%r27, [%r18 + %r0]
	.word 0xf62dc000  ! 6595: STB_R	stb	%r27, [%r23 + %r0]
	.word 0xfe35e0b0  ! 6600: STH_I	sth	%r31, [%r23 + 0x00b0]
	.word 0xf2240000  ! 6601: STW_R	stw	%r25, [%r16 + %r0]
	.word 0xf43ca1e2  ! 6602: STD_I	std	%r26, [%r18 + 0x01e2]
hwintr_3_302:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_302), 16, 16)) -> intp(3, 0, 3c)
	.word 0xf635201d  ! 6605: STH_I	sth	%r27, [%r20 + 0x001d]
	.word 0xb2158000  ! 6607: OR_R	or 	%r22, %r0, %r25
hwintr_3_303:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_303), 16, 16)) -> intp(3, 0, 25)
	.word 0xf075619e  ! 6609: STX_I	stx	%r24, [%r21 + 0x019e]
	.word 0xf33c0000  ! 6611: STDF_R	std	%f25, [%r0, %r16]
	.word 0xf225a14e  ! 6614: STW_I	stw	%r25, [%r22 + 0x014e]
	.word 0xf43c60ac  ! 6617: STD_I	std	%r26, [%r17 + 0x00ac]
	.word 0xbf51c000  ! 6619: RDPR_TL	rdpr	%tl, %r31
	.word 0xb150c000  ! 6622: RDPR_TT	<illegal instruction>
	.word 0xb3500000  ! 6623: RDPR_TPC	<illegal instruction>
	.word 0xf93d0000  ! 6624: STDF_R	std	%f28, [%r0, %r20]
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	setx	data_start_7, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r20, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8d94a145  ! 6632: WRPR_PSTATE_I	wrpr	%r18, 0x0145, %pstate
	.word 0xf435a0e3  ! 6638: STH_I	sth	%r26, [%r22 + 0x00e3]
	setx	data_start_5, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfc758000  ! 6644: STX_R	stx	%r30, [%r22 + %r0]
	.word 0xf8258000  ! 6645: STW_R	stw	%r28, [%r22 + %r0]
	.word 0xbf343001  ! 6647: SRLX_I	srlx	%r16, 0x0001, %r31
	.word 0xbf7cc400  ! 6648: MOVR_R	movre	%r19, %r0, %r31
	.word 0xfe258000  ! 6649: STW_R	stw	%r31, [%r22 + %r0]
	.word 0xf73d0000  ! 6652: STDF_R	std	%f27, [%r0, %r20]
hwintr_3_304:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_304), 16, 16)) -> intp(3, 0, 0)
	.word 0xf33d4000  ! 6654: STDF_R	std	%f25, [%r0, %r21]
	.word 0xf62c61c8  ! 6658: STB_I	stb	%r27, [%r17 + 0x01c8]
	.word 0xbb354000  ! 6659: SRL_R	srl 	%r21, %r0, %r29
	.word 0xb3480000  ! 6661: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xf4248000  ! 6662: STW_R	stw	%r26, [%r18 + %r0]
	.word 0xbb504000  ! 6675: RDPR_TNPC	<illegal instruction>
	.word 0xf03d8000  ! 6676: STD_R	std	%r24, [%r22 + %r0]
	.word 0x81952155  ! 6677: WRPR_TPC_I	wrpr	%r20, 0x0155, %tpc
	.word 0xf62c4000  ! 6678: STB_R	stb	%r27, [%r17 + %r0]
hwintr_3_305:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_305), 16, 16)) -> intp(3, 0, 14)
	.word 0xf4244000  ! 6681: STW_R	stw	%r26, [%r17 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982981  ! 6682: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0981, %hpstate
	.word 0xba2ce015  ! 6684: ANDN_I	andn 	%r19, 0x0015, %r29
	.word 0xbd480000  ! 6685: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xf33d8000  ! 6691: STDF_R	std	%f25, [%r0, %r22]
	.word 0xfd3d8000  ! 6692: STDF_R	std	%f30, [%r0, %r22]
	.word 0xfd3d614f  ! 6693: STDF_I	std	%f30, [0x014f, %r21]
	.word 0xbf2d9000  ! 6694: SLLX_R	sllx	%r22, %r0, %r31
	.word 0xf824c000  ! 6696: STW_R	stw	%r28, [%r19 + %r0]
	.word 0xfa2d8000  ! 6697: STB_R	stb	%r29, [%r22 + %r0]
	.word 0xbd518000  ! 6698: RDPR_PSTATE	<illegal instruction>
	.word 0xfb3c4000  ! 6700: STDF_R	std	%f29, [%r0, %r17]
	.word 0xb3520000  ! 6702: RDPR_PIL	<illegal instruction>
	.word 0xf2246116  ! 6703: STW_I	stw	%r25, [%r17 + 0x0116]
	.word 0xb885c000  ! 6706: ADDcc_R	addcc 	%r23, %r0, %r28
	.word 0xf475e06b  ! 6708: STX_I	stx	%r26, [%r23 + 0x006b]
	.word 0xf0354000  ! 6712: STH_R	sth	%r24, [%r21 + %r0]
	.word 0xf62dc000  ! 6716: STB_R	stb	%r27, [%r23 + %r0]
hwintr_3_306:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_306), 16, 16)) -> intp(3, 0, 27)
	setx	data_start_1, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_307:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_307), 16, 16)) -> intp(3, 0, f)
	.word 0xb5540000  ! 6725: RDPR_GL	<illegal instruction>
	.word 0xf22dc000  ! 6730: STB_R	stb	%r25, [%r23 + %r0]
	.word 0xb1500000  ! 6732: RDPR_TPC	<illegal instruction>
	.word 0xb3500000  ! 6733: RDPR_TPC	<illegal instruction>
	setx	data_start_5, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb88da0f6  ! 6736: ANDcc_I	andcc 	%r22, 0x00f6, %r28
	.word 0x8395e1a6  ! 6745: WRPR_TNPC_I	wrpr	%r23, 0x01a6, %tnpc
	.word 0xb9510000  ! 6749: RDPR_TICK	rdpr	%tick, %r28
	.word 0xbaa4e1ca  ! 6750: SUBcc_I	subcc 	%r19, 0x01ca, %r29
	.word 0xf874a079  ! 6752: STX_I	stx	%r28, [%r18 + 0x0079]
	.word 0xb73d8000  ! 6755: SRA_R	sra 	%r22, %r0, %r27
	.word 0xf13d8000  ! 6756: STDF_R	std	%f24, [%r0, %r22]
	.word 0xb7504000  ! 6758: RDPR_TNPC	<illegal instruction>
	setx	data_start_7, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf87460e9  ! 6763: STX_I	stx	%r28, [%r17 + 0x00e9]
hwintr_3_308:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_308), 16, 16)) -> intp(3, 0, 33)
	.word 0xf23c4000  ! 6766: STD_R	std	%r25, [%r17 + %r0]
	.word 0xbd520000  ! 6767: RDPR_PIL	<illegal instruction>
	.word 0x9195a09a  ! 6770: WRPR_PIL_I	wrpr	%r22, 0x009a, %pil
	.word 0xb534e001  ! 6772: SRL_I	srl 	%r19, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	.word 0x8198389b  ! 6774: WRHPR_HPSTATE_I	wrhpr	%r0, 0x189b, %hpstate
	.word 0xf224a081  ! 6775: STW_I	stw	%r25, [%r18 + 0x0081]
	ta	T_CHANGE_HPRIV
	.word 0x81983c43  ! 6777: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c43, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81983ad9  ! 6780: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1ad9, %hpstate
hwintr_3_309:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_309), 16, 16)) -> intp(3, 0, a)
	.word 0xfa35c000  ! 6786: STH_R	sth	%r29, [%r23 + %r0]
	.word 0xb62d0000  ! 6788: ANDN_R	andn 	%r20, %r0, %r27
	setx	data_start_2, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf635c000  ! 6798: STH_R	sth	%r27, [%r23 + %r0]
	.word 0xf6346045  ! 6799: STH_I	sth	%r27, [%r17 + 0x0045]
	.word 0xb3504000  ! 6802: RDPR_TNPC	rdpr	%tnpc, %r25
	.word 0xfc254000  ! 6804: STW_R	stw	%r30, [%r21 + %r0]
	.word 0xfc2ce1b8  ! 6805: STB_I	stb	%r30, [%r19 + 0x01b8]
	.word 0xfe748000  ! 6807: STX_R	stx	%r31, [%r18 + %r0]
hwintr_3_310:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_310), 16, 16)) -> intp(3, 0, 1)
	.word 0xbd480000  ! 6813: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xf82c619f  ! 6814: STB_I	stb	%r28, [%r17 + 0x019f]
	.word 0xf03ca0ad  ! 6819: STD_I	std	%r24, [%r18 + 0x00ad]
	.word 0xf23ce0c6  ! 6821: STD_I	std	%r25, [%r19 + 0x00c6]
	.word 0xf83d0000  ! 6822: STD_R	std	%r28, [%r20 + %r0]
	.word 0xb57c2401  ! 6827: MOVR_I	movre	%r16, 0x1, %r26
	.word 0xb04521ec  ! 6829: ADDC_I	addc 	%r20, 0x01ec, %r24
	.word 0xf73d0000  ! 6830: STDF_R	std	%f27, [%r0, %r20]
	.word 0xb53d1000  ! 6831: SRAX_R	srax	%r20, %r0, %r26
	.word 0xf234a13c  ! 6832: STH_I	sth	%r25, [%r18 + 0x013c]
hwintr_3_311:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_311), 16, 16)) -> intp(3, 0, 7)
	.word 0xfe34a0f7  ! 6841: STH_I	sth	%r31, [%r18 + 0x00f7]
	.word 0xfc758000  ! 6844: STX_R	stx	%r30, [%r22 + %r0]
	.word 0xf33c0000  ! 6856: STDF_R	std	%f25, [%r0, %r16]
	.word 0xf275e03a  ! 6857: STX_I	stx	%r25, [%r23 + 0x003a]
	.word 0xbe8420cb  ! 6860: ADDcc_I	addcc 	%r16, 0x00cb, %r31
hwintr_3_312:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_312), 16, 16)) -> intp(3, 0, 31)
	.word 0xf4344000  ! 6862: STH_R	sth	%r26, [%r17 + %r0]
	.word 0xbf51c000  ! 6866: RDPR_TL	<illegal instruction>
	.word 0xb234e046  ! 6868: SUBC_I	orn 	%r19, 0x0046, %r25
	.word 0xfc340000  ! 6869: STH_R	sth	%r30, [%r16 + %r0]
	.word 0xf225a0ed  ! 6872: STW_I	stw	%r25, [%r22 + 0x00ed]
	.word 0xb81da03e  ! 6874: XOR_I	xor 	%r22, 0x003e, %r28
	.word 0xf4752176  ! 6879: STX_I	stx	%r26, [%r20 + 0x0176]
	mov	2, %r12
	.word 0x8f932000  ! 6883: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfe2d60e5  ! 6885: STB_I	stb	%r31, [%r21 + 0x00e5]
	.word 0xf63d6175  ! 6889: STD_I	std	%r27, [%r21 + 0x0175]
	.word 0xfc74c000  ! 6891: STX_R	stx	%r30, [%r19 + %r0]
	.word 0xf53da007  ! 6892: STDF_I	std	%f26, [0x0007, %r22]
	.word 0x8794a1ef  ! 6893: WRPR_TT_I	wrpr	%r18, 0x01ef, %tt
hwintr_3_313:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_313), 16, 16)) -> intp(3, 0, 1b)
	.word 0xb7504000  ! 6898: RDPR_TNPC	rdpr	%tnpc, %r27
	.word 0x8194e157  ! 6899: WRPR_TPC_I	wrpr	%r19, 0x0157, %tpc
	.word 0xfb3de031  ! 6900: STDF_I	std	%f29, [0x0031, %r23]
	.word 0xf62cc000  ! 6902: STB_R	stb	%r27, [%r19 + %r0]
	.word 0xfc3d4000  ! 6905: STD_R	std	%r30, [%r21 + %r0]
	.word 0xf23de021  ! 6907: STD_I	std	%r25, [%r23 + 0x0021]
	.word 0xfc3d21ee  ! 6909: STD_I	std	%r30, [%r20 + 0x01ee]
	.word 0xb9540000  ! 6910: RDPR_GL	rdpr	%-, %r28
	.word 0xfe75e170  ! 6912: STX_I	stx	%r31, [%r23 + 0x0170]
	.word 0xbe1ce113  ! 6916: XOR_I	xor 	%r19, 0x0113, %r31
	.word 0xf23d603a  ! 6919: STD_I	std	%r25, [%r21 + 0x003a]
	.word 0xfe74e053  ! 6921: STX_I	stx	%r31, [%r19 + 0x0053]
	.word 0xff3c4000  ! 6922: STDF_R	std	%f31, [%r0, %r17]
	.word 0xfc3dc000  ! 6923: STD_R	std	%r30, [%r23 + %r0]
	.word 0xf675c000  ! 6926: STX_R	stx	%r27, [%r23 + %r0]
	.word 0xbf520000  ! 6927: RDPR_PIL	<illegal instruction>
hwintr_3_314:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_314), 16, 16)) -> intp(3, 0, d)
	.word 0xfe3d6094  ! 6932: STD_I	std	%r31, [%r21 + 0x0094]
hwintr_3_315:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_315), 16, 16)) -> intp(3, 0, 2b)
	.word 0xf0750000  ! 6937: STX_R	stx	%r24, [%r20 + %r0]
hwintr_3_316:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_316), 16, 16)) -> intp(3, 0, 11)
	.word 0xfe3cc000  ! 6941: STD_R	std	%r31, [%r19 + %r0]
hwintr_3_317:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_317), 16, 16)) -> intp(3, 0, 1a)
	ta	T_CHANGE_HPRIV
	.word 0x8198391b  ! 6943: WRHPR_HPSTATE_I	wrhpr	%r0, 0x191b, %hpstate
	.word 0xf4742126  ! 6944: STX_I	stx	%r26, [%r16 + 0x0126]
	.word 0xbb7d2401  ! 6945: MOVR_I	movre	%r20, 0x1, %r29
	.word 0xf424e0b2  ! 6947: STW_I	stw	%r26, [%r19 + 0x00b2]
	.word 0xbf35e001  ! 6948: SRL_I	srl 	%r23, 0x0001, %r31
	.word 0xb951c000  ! 6949: RDPR_TL	rdpr	%tl, %r28
	.word 0xfe2c609b  ! 6954: STB_I	stb	%r31, [%r17 + 0x009b]
	.word 0xfa3d0000  ! 6955: STD_R	std	%r29, [%r20 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982cd3  ! 6957: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0cd3, %hpstate
	.word 0xf42d6038  ! 6958: STB_I	stb	%r26, [%r21 + 0x0038]
hwintr_3_318:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_318), 16, 16)) -> intp(3, 0, e)
	.word 0xf075a057  ! 6966: STX_I	stx	%r24, [%r22 + 0x0057]
	.word 0xfc342000  ! 6969: STH_I	sth	%r30, [%r16 + 0x0000]
	.word 0xbb3de001  ! 6972: SRA_I	sra 	%r23, 0x0001, %r29
	.word 0xf675c000  ! 6973: STX_R	stx	%r27, [%r23 + %r0]
	.word 0xfd3c4000  ! 6975: STDF_R	std	%f30, [%r0, %r17]
	.word 0xfe2d8000  ! 6977: STB_R	stb	%r31, [%r22 + %r0]
	.word 0xb3518000  ! 6981: RDPR_PSTATE	rdpr	%pstate, %r25
	.word 0xbe0d60d5  ! 6986: AND_I	and 	%r21, 0x00d5, %r31
	.word 0xf22c4000  ! 6987: STB_R	stb	%r25, [%r17 + %r0]
hwintr_3_319:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_319), 16, 16)) -> intp(3, 0, 37)
hwintr_3_320:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_320), 16, 16)) -> intp(3, 0, e)
hwintr_3_321:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_321), 16, 16)) -> intp(3, 0, d)
	.word 0xfd3c8000  ! 6993: STDF_R	std	%f30, [%r0, %r18]
	.word 0xf875a061  ! 6995: STX_I	stx	%r28, [%r22 + 0x0061]
	ta	T_CHANGE_HPRIV
	.word 0x81982a59  ! 6996: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a59, %hpstate
	.word 0xf13d0000  ! 6997: STDF_R	std	%f24, [%r0, %r20]
	.word 0xf02c615b  ! 6998: STB_I	stb	%r24, [%r17 + 0x015b]
	.word 0xfc246168  ! 7002: STW_I	stw	%r30, [%r17 + 0x0168]
	setx	data_start_0, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf034c000  ! 7007: STH_R	sth	%r24, [%r19 + %r0]
	.word 0x8595a0fb  ! 7011: WRPR_TSTATE_I	wrpr	%r22, 0x00fb, %tstate
	.word 0xf43d0000  ! 7013: STD_R	std	%r26, [%r20 + %r0]
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xf2254000  ! 7015: STW_R	stw	%r25, [%r21 + %r0]
	.word 0x8794a152  ! 7016: WRPR_TT_I	wrpr	%r18, 0x0152, %tt
	.word 0xfa2d8000  ! 7019: STB_R	stb	%r29, [%r22 + %r0]
	.word 0xfc2de025  ! 7022: STB_I	stb	%r30, [%r23 + 0x0025]
	.word 0xb3518000  ! 7024: RDPR_PSTATE	rdpr	%pstate, %r25
hwintr_3_322:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_322), 16, 16)) -> intp(3, 0, 26)
	.word 0xb0bd20af  ! 7031: XNORcc_I	xnorcc 	%r20, 0x00af, %r24
	setx	data_start_2, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf82cc000  ! 7033: STB_R	stb	%r28, [%r19 + %r0]
	.word 0xb551c000  ! 7035: RDPR_TL	<illegal instruction>
	.word 0xf234c000  ! 7036: STH_R	sth	%r25, [%r19 + %r0]
	.word 0xfd3d209a  ! 7037: STDF_I	std	%f30, [0x009a, %r20]
hwintr_3_323:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_323), 16, 16)) -> intp(3, 0, 31)
	.word 0xb1518000  ! 7042: RDPR_PSTATE	<illegal instruction>
	.word 0xfa346057  ! 7043: STH_I	sth	%r29, [%r17 + 0x0057]
hwintr_3_324:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_324), 16, 16)) -> intp(3, 0, 13)
	ta	T_CHANGE_HPRIV
	.word 0x81982bd3  ! 7047: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0bd3, %hpstate
	.word 0xfb3cc000  ! 7049: STDF_R	std	%f29, [%r0, %r19]
	.word 0x9194a19b  ! 7052: WRPR_PIL_I	wrpr	%r18, 0x019b, %pil
	.word 0xbf510000  ! 7053: RDPR_TICK	rdpr	%tick, %r31
	.word 0x9194e158  ! 7056: WRPR_PIL_I	wrpr	%r19, 0x0158, %pil
	.word 0xf93d60e8  ! 7058: STDF_I	std	%f28, [0x00e8, %r21]
	.word 0xb93c8000  ! 7062: SRA_R	sra 	%r18, %r0, %r28
	.word 0xf83d4000  ! 7065: STD_R	std	%r28, [%r21 + %r0]
	.word 0x91956082  ! 7069: WRPR_PIL_I	wrpr	%r21, 0x0082, %pil
	.word 0xb0046139  ! 7071: ADD_I	add 	%r17, 0x0139, %r24
	.word 0xbc150000  ! 7080: OR_R	or 	%r20, %r0, %r30
	ta	T_CHANGE_HPRIV
	.word 0x81983f09  ! 7084: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f09, %hpstate
	.word 0xfc2ca172  ! 7091: STB_I	stb	%r30, [%r18 + 0x0172]
hwintr_3_325:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_325), 16, 16)) -> intp(3, 0, 9)
	.word 0xf4758000  ! 7094: STX_R	stx	%r26, [%r22 + %r0]
	.word 0x8d94e1ef  ! 7096: WRPR_PSTATE_I	wrpr	%r19, 0x01ef, %pstate
	.word 0xb7510000  ! 7098: RDPR_TICK	rdpr	%tick, %r27
	.word 0xf23c4000  ! 7099: STD_R	std	%r25, [%r17 + %r0]
	.word 0xfa744000  ! 7102: STX_R	stx	%r29, [%r17 + %r0]
	.word 0xb534d000  ! 7106: SRLX_R	srlx	%r19, %r0, %r26
	mov	0, %r14
	.word 0xa193a000  ! 7111: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb0058000  ! 7113: ADD_R	add 	%r22, %r0, %r24
hwintr_3_326:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_326), 16, 16)) -> intp(3, 0, 1b)
	.word 0xf63d4000  ! 7116: STD_R	std	%r27, [%r21 + %r0]
	.word 0xb83460d7  ! 7119: SUBC_I	orn 	%r17, 0x00d7, %r28
	.word 0xfd3c6088  ! 7120: STDF_I	std	%f30, [0x0088, %r17]
	.word 0xf43c0000  ! 7125: STD_R	std	%r26, [%r16 + %r0]
	.word 0xf42520f5  ! 7127: STW_I	stw	%r26, [%r20 + 0x00f5]
hwintr_3_327:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_327), 16, 16)) -> intp(3, 0, 1)
	.word 0xb150c000  ! 7130: RDPR_TT	rdpr	%tt, %r24
	.word 0xf63d4000  ! 7133: STD_R	std	%r27, [%r21 + %r0]
	.word 0xb01dc000  ! 7135: XOR_R	xor 	%r23, %r0, %r24
	.word 0xfe3d60f2  ! 7136: STD_I	std	%r31, [%r21 + 0x00f2]
	.word 0xbd2d0000  ! 7137: SLL_R	sll 	%r20, %r0, %r30
	.word 0xb551c000  ! 7138: RDPR_TL	<illegal instruction>
	.word 0xfc352049  ! 7139: STH_I	sth	%r30, [%r20 + 0x0049]
	.word 0xf274a099  ! 7140: STX_I	stx	%r25, [%r18 + 0x0099]
	setx	data_start_2, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfc2d8000  ! 7148: STB_R	stb	%r30, [%r22 + %r0]
	.word 0xb41d8000  ! 7150: XOR_R	xor 	%r22, %r0, %r26
	.word 0xff3c60f1  ! 7151: STDF_I	std	%f31, [0x00f1, %r17]
	.word 0xfe3c4000  ! 7152: STD_R	std	%r31, [%r17 + %r0]
	.word 0xf63c213b  ! 7153: STD_I	std	%r27, [%r16 + 0x013b]
	.word 0xfa3c610a  ! 7154: STD_I	std	%r29, [%r17 + 0x010a]
	.word 0xf43c21bd  ! 7156: STD_I	std	%r26, [%r16 + 0x01bd]
	setx	data_start_1, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf834c000  ! 7160: STH_R	sth	%r28, [%r19 + %r0]
	.word 0x8195e0c8  ! 7162: WRPR_TPC_I	wrpr	%r23, 0x00c8, %tpc
hwintr_3_328:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_328), 16, 16)) -> intp(3, 0, 36)
	.word 0xb7520000  ! 7166: RDPR_PIL	rdpr	%pil, %r27
hwintr_3_329:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_329), 16, 16)) -> intp(3, 0, 1c)
	.word 0xf63de082  ! 7172: STD_I	std	%r27, [%r23 + 0x0082]
	.word 0xf42d603e  ! 7176: STB_I	stb	%r26, [%r21 + 0x003e]
	.word 0xfc2da172  ! 7177: STB_I	stb	%r30, [%r22 + 0x0172]
	.word 0x8994a114  ! 7178: WRPR_TICK_I	wrpr	%r18, 0x0114, %tick
	.word 0x8795e188  ! 7179: WRPR_TT_I	wrpr	%r23, 0x0188, %tt
	.word 0xf635a160  ! 7182: STH_I	sth	%r27, [%r22 + 0x0160]
	.word 0xf42d8000  ! 7183: STB_R	stb	%r26, [%r22 + %r0]
	.word 0xfa35a072  ! 7185: STH_I	sth	%r29, [%r22 + 0x0072]
	.word 0x8794e195  ! 7189: WRPR_TT_I	wrpr	%r19, 0x0195, %tt
	.word 0xfa25218d  ! 7190: STW_I	stw	%r29, [%r20 + 0x018d]
	.word 0xf23ca128  ! 7192: STD_I	std	%r25, [%r18 + 0x0128]
	.word 0xbd520000  ! 7194: RDPR_PIL	rdpr	%pil, %r30
	setx	data_start_3, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x899460b2  ! 7200: WRPR_TICK_I	wrpr	%r17, 0x00b2, %tick
	.word 0x859420d9  ! 7207: WRPR_TSTATE_I	wrpr	%r16, 0x00d9, %tstate
hwintr_3_330:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_330), 16, 16)) -> intp(3, 0, 32)
	setx	data_start_2, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf53d8000  ! 7210: STDF_R	std	%f26, [%r0, %r22]
	.word 0xf82dc000  ! 7211: STB_R	stb	%r28, [%r23 + %r0]
	.word 0xb350c000  ! 7217: RDPR_TT	rdpr	%tt, %r25
	.word 0xfc742147  ! 7220: STX_I	stx	%r30, [%r16 + 0x0147]
	.word 0xb7504000  ! 7221: RDPR_TNPC	<illegal instruction>
	.word 0xbc244000  ! 7222: SUB_R	sub 	%r17, %r0, %r30
hwintr_3_331:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_331), 16, 16)) -> intp(3, 0, c)
	.word 0xf93c8000  ! 7231: STDF_R	std	%f28, [%r0, %r18]
	mov	0, %r14
	.word 0xa193a000  ! 7235: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xff3d8000  ! 7236: STDF_R	std	%f31, [%r0, %r22]
	mov	1, %r14
	.word 0xa193a000  ! 7237: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf22d200b  ! 7238: STB_I	stb	%r25, [%r20 + 0x000b]
hwintr_3_332:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_332), 16, 16)) -> intp(3, 0, 32)
	ta	T_CHANGE_HPRIV
	.word 0x81982fc1  ! 7242: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0fc1, %hpstate
	setx	data_start_1, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x9194a1be  ! 7247: WRPR_PIL_I	wrpr	%r18, 0x01be, %pil
	.word 0xf824a1f6  ! 7248: STW_I	stw	%r28, [%r18 + 0x01f6]
	ta	T_CHANGE_HPRIV
	.word 0x81982ac1  ! 7250: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0ac1, %hpstate
	.word 0x85952158  ! 7251: WRPR_TSTATE_I	wrpr	%r20, 0x0158, %tstate
	.word 0xfa3cc000  ! 7253: STD_R	std	%r29, [%r19 + %r0]
	.word 0xfe2c8000  ! 7254: STB_R	stb	%r31, [%r18 + %r0]
	mov	2, %r12
	.word 0x8f932000  ! 7259: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xff3dc000  ! 7266: STDF_R	std	%f31, [%r0, %r23]
	.word 0xb3518000  ! 7267: RDPR_PSTATE	rdpr	%pstate, %r25
	.word 0xb0bd8000  ! 7268: XNORcc_R	xnorcc 	%r22, %r0, %r24
	.word 0xf42460c1  ! 7269: STW_I	stw	%r26, [%r17 + 0x00c1]
	.word 0xb12d2001  ! 7272: SLL_I	sll 	%r20, 0x0001, %r24
	.word 0xf2354000  ! 7274: STH_R	sth	%r25, [%r21 + %r0]
	.word 0xfc2d0000  ! 7275: STB_R	stb	%r30, [%r20 + %r0]
	.word 0xbea420d0  ! 7278: SUBcc_I	subcc 	%r16, 0x00d0, %r31
	.word 0xf8740000  ! 7284: STX_R	stx	%r28, [%r16 + %r0]
	.word 0xf22d6112  ! 7285: STB_I	stb	%r25, [%r21 + 0x0112]
	.word 0xb551c000  ! 7302: RDPR_TL	<illegal instruction>
	.word 0xf22d61d7  ! 7303: STB_I	stb	%r25, [%r21 + 0x01d7]
	.word 0xfc24e0d5  ! 7305: STW_I	stw	%r30, [%r19 + 0x00d5]
	.word 0x899560fb  ! 7307: WRPR_TICK_I	wrpr	%r21, 0x00fb, %tick
	.word 0xf2344000  ! 7311: STH_R	sth	%r25, [%r17 + %r0]
	.word 0xfe2dc000  ! 7312: STB_R	stb	%r31, [%r23 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x819839d1  ! 7313: WRHPR_HPSTATE_I	wrhpr	%r0, 0x19d1, %hpstate
	.word 0xb7510000  ! 7314: RDPR_TICK	rdpr	%tick, %r27
	.word 0xf93ce013  ! 7321: STDF_I	std	%f28, [0x0013, %r19]
	.word 0x8194a1d4  ! 7322: WRPR_TPC_I	wrpr	%r18, 0x01d4, %tpc
	.word 0xb52df001  ! 7323: SLLX_I	sllx	%r23, 0x0001, %r26
	.word 0xfe25a056  ! 7330: STW_I	stw	%r31, [%r22 + 0x0056]
	mov	2, %r14
	.word 0xa193a000  ! 7332: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf2750000  ! 7334: STX_R	stx	%r25, [%r20 + %r0]
	.word 0xb68dc000  ! 7336: ANDcc_R	andcc 	%r23, %r0, %r27
	.word 0xfe3ce0c9  ! 7337: STD_I	std	%r31, [%r19 + 0x00c9]
	mov	0, %r14
	.word 0xa193a000  ! 7340: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_3_333:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_333), 16, 16)) -> intp(3, 0, 1a)
	.word 0xf435c000  ! 7342: STH_R	sth	%r26, [%r23 + %r0]
	.word 0xb3520000  ! 7347: RDPR_PIL	rdpr	%pil, %r25
	.word 0xbd504000  ! 7349: RDPR_TNPC	rdpr	%tnpc, %r30
	.word 0xbabd0000  ! 7353: XNORcc_R	xnorcc 	%r20, %r0, %r29
	.word 0xf0344000  ! 7355: STH_R	sth	%r24, [%r17 + %r0]
	.word 0x8d94e0e1  ! 7360: WRPR_PSTATE_I	wrpr	%r19, 0x00e1, %pstate
hwintr_3_334:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_334), 16, 16)) -> intp(3, 0, 3c)
	setx	data_start_3, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x839420fa  ! 7367: WRPR_TNPC_I	wrpr	%r16, 0x00fa, %tnpc
	setx	data_start_3, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_335:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_335), 16, 16)) -> intp(3, 0, 11)
hwintr_3_336:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_336), 16, 16)) -> intp(3, 0, 2)
	.word 0xf825e04c  ! 7379: STW_I	stw	%r28, [%r23 + 0x004c]
	.word 0xf025a11a  ! 7380: STW_I	stw	%r24, [%r22 + 0x011a]
	mov	2, %r12
	.word 0x8f932000  ! 7383: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfa3d0000  ! 7385: STD_R	std	%r29, [%r20 + %r0]
	.word 0x8394e02d  ! 7387: WRPR_TNPC_I	wrpr	%r19, 0x002d, %tnpc
	.word 0x8594201b  ! 7388: WRPR_TSTATE_I	wrpr	%r16, 0x001b, %tstate
	.word 0xb7641800  ! 7391: MOVcc_R	<illegal instruction>
	.word 0xf624a138  ! 7392: STW_I	stw	%r27, [%r18 + 0x0138]
hwintr_3_337:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_337), 16, 16)) -> intp(3, 0, 23)
	.word 0xfa3c6124  ! 7399: STD_I	std	%r29, [%r17 + 0x0124]
	.word 0xff3de0cb  ! 7400: STDF_I	std	%f31, [0x00cb, %r23]
	.word 0xb5504000  ! 7403: RDPR_TNPC	rdpr	%tnpc, %r26
hwintr_3_338:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_338), 16, 16)) -> intp(3, 0, 2e)
	mov	0, %r12
	.word 0x8f932000  ! 7407: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_3_339:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_339), 16, 16)) -> intp(3, 0, 4)
	.word 0xf034c000  ! 7409: STH_R	sth	%r24, [%r19 + %r0]
	.word 0xf2240000  ! 7411: STW_R	stw	%r25, [%r16 + %r0]
	.word 0xf43c2142  ! 7412: STD_I	std	%r26, [%r16 + 0x0142]
	.word 0xf62de080  ! 7413: STB_I	stb	%r27, [%r23 + 0x0080]
	.word 0xf8750000  ! 7416: STX_R	stx	%r28, [%r20 + %r0]
	.word 0xf82da1f8  ! 7421: STB_I	stb	%r28, [%r22 + 0x01f8]
	.word 0xbe9c20dd  ! 7425: XORcc_I	xorcc 	%r16, 0x00dd, %r31
	.word 0xb3504000  ! 7426: RDPR_TNPC	rdpr	%tnpc, %r25
	.word 0xfa25219e  ! 7427: STW_I	stw	%r29, [%r20 + 0x019e]
	.word 0xb150c000  ! 7429: RDPR_TT	<illegal instruction>
	.word 0xfa74e147  ! 7430: STX_I	stx	%r29, [%r19 + 0x0147]
	.word 0xbd520000  ! 7432: RDPR_PIL	<illegal instruction>
hwintr_3_340:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_340), 16, 16)) -> intp(3, 0, 30)
	.word 0xfa3ce128  ! 7445: STD_I	std	%r29, [%r19 + 0x0128]
	.word 0xf43d0000  ! 7447: STD_R	std	%r26, [%r20 + %r0]
	mov	1, %r14
	.word 0xa193a000  ! 7449: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfe25a111  ! 7450: STW_I	stw	%r31, [%r22 + 0x0111]
hwintr_3_341:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_341), 16, 16)) -> intp(3, 0, 17)
hwintr_3_342:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_342), 16, 16)) -> intp(3, 0, 2a)
	.word 0xb7504000  ! 7458: RDPR_TNPC	rdpr	%tnpc, %r27
	.word 0xf63d20fd  ! 7461: STD_I	std	%r27, [%r20 + 0x00fd]
	.word 0xfc75c000  ! 7462: STX_R	stx	%r30, [%r23 + %r0]
hwintr_3_343:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_343), 16, 16)) -> intp(3, 0, b)
	.word 0xb9500000  ! 7464: RDPR_TPC	<illegal instruction>
	.word 0xf075a1a5  ! 7466: STX_I	stx	%r24, [%r22 + 0x01a5]
	.word 0xf024a082  ! 7467: STW_I	stw	%r24, [%r18 + 0x0082]
	.word 0xf53d0000  ! 7470: STDF_R	std	%f26, [%r0, %r20]
	.word 0x8394e104  ! 7471: WRPR_TNPC_I	wrpr	%r19, 0x0104, %tnpc
	.word 0xb3504000  ! 7474: RDPR_TNPC	rdpr	%tnpc, %r25
	.word 0xf13da147  ! 7477: STDF_I	std	%f24, [0x0147, %r22]
	.word 0xfa75a173  ! 7479: STX_I	stx	%r29, [%r22 + 0x0173]
	.word 0xf825e16d  ! 7480: STW_I	stw	%r28, [%r23 + 0x016d]
	.word 0xff3de11e  ! 7481: STDF_I	std	%f31, [0x011e, %r23]
	ta	T_CHANGE_HPRIV
	.word 0x81983e19  ! 7482: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e19, %hpstate
	.word 0xfd3ca14a  ! 7484: STDF_I	std	%f30, [0x014a, %r18]
	.word 0xb7508000  ! 7487: RDPR_TSTATE	rdpr	%tstate, %r27
	.word 0xfa3d4000  ! 7493: STD_R	std	%r29, [%r21 + %r0]
	.word 0xfa744000  ! 7499: STX_R	stx	%r29, [%r17 + %r0]
	.word 0xfd3d617e  ! 7504: STDF_I	std	%f30, [0x017e, %r21]
hwintr_3_344:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_344), 16, 16)) -> intp(3, 0, 3e)
	.word 0xb1480000  ! 7510: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xbf7c8400  ! 7511: MOVR_R	movre	%r18, %r0, %r31
	.word 0xf2250000  ! 7512: STW_R	stw	%r25, [%r20 + %r0]
	.word 0xbea5e1a7  ! 7519: SUBcc_I	subcc 	%r23, 0x01a7, %r31
	.word 0xfc250000  ! 7520: STW_R	stw	%r30, [%r20 + %r0]
	.word 0xfa258000  ! 7524: STW_R	stw	%r29, [%r22 + %r0]
	.word 0xfe246179  ! 7526: STW_I	stw	%r31, [%r17 + 0x0179]
	.word 0xb49d4000  ! 7527: XORcc_R	xorcc 	%r21, %r0, %r26
	.word 0xb08dc000  ! 7528: ANDcc_R	andcc 	%r23, %r0, %r24
	.word 0xfe3da0df  ! 7529: STD_I	std	%r31, [%r22 + 0x00df]
	mov	1, %r14
	.word 0xa193a000  ! 7530: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf13d215a  ! 7532: STDF_I	std	%f24, [0x015a, %r20]
	.word 0xbd504000  ! 7534: RDPR_TNPC	rdpr	%tnpc, %r30
	.word 0xf27460bf  ! 7536: STX_I	stx	%r25, [%r17 + 0x00bf]
	ta	T_CHANGE_HPRIV
	.word 0x81983b59  ! 7537: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b59, %hpstate
	.word 0xfe340000  ! 7544: STH_R	sth	%r31, [%r16 + %r0]
	.word 0xfe2d8000  ! 7547: STB_R	stb	%r31, [%r22 + %r0]
hwintr_3_345:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_345), 16, 16)) -> intp(3, 0, 4)
hwintr_3_346:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_346), 16, 16)) -> intp(3, 0, 29)
	.word 0xb951c000  ! 7558: RDPR_TL	rdpr	%tl, %r28
	.word 0x85942021  ! 7560: WRPR_TSTATE_I	wrpr	%r16, 0x0021, %tstate
	.word 0xfc2c0000  ! 7563: STB_R	stb	%r30, [%r16 + %r0]
	.word 0x89956196  ! 7565: WRPR_TICK_I	wrpr	%r21, 0x0196, %tick
	.word 0xb7480000  ! 7572: RDHPR_HPSTATE	rdhpr	%hpstate, %r27
	.word 0x919520ea  ! 7573: WRPR_PIL_I	wrpr	%r20, 0x00ea, %pil
	.word 0xfc25c000  ! 7575: STW_R	stw	%r30, [%r23 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81983c51  ! 7577: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c51, %hpstate
	.word 0x8d94604c  ! 7578: WRPR_PSTATE_I	wrpr	%r17, 0x004c, %pstate
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xfa25c000  ! 7582: STW_R	stw	%r29, [%r23 + %r0]
	.word 0xf63c0000  ! 7583: STD_R	std	%r27, [%r16 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81983a59  ! 7585: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a59, %hpstate
	.word 0xf63ca0fc  ! 7587: STD_I	std	%r27, [%r18 + 0x00fc]
hwintr_3_347:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_347), 16, 16)) -> intp(3, 0, 31)
	.word 0xb950c000  ! 7590: RDPR_TT	rdpr	%tt, %r28
	.word 0x8d94e09d  ! 7593: WRPR_PSTATE_I	wrpr	%r19, 0x009d, %pstate
	.word 0xb89ca065  ! 7595: XORcc_I	xorcc 	%r18, 0x0065, %r28
hwintr_3_348:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_348), 16, 16)) -> intp(3, 0, 3c)
	.word 0xfc748000  ! 7598: STX_R	stx	%r30, [%r18 + %r0]
	.word 0xb150c000  ! 7599: RDPR_TT	rdpr	%tt, %r24
	.word 0xb1518000  ! 7600: RDPR_PSTATE	<illegal instruction>
	.word 0xfa350000  ! 7603: STH_R	sth	%r29, [%r20 + %r0]
	.word 0xf13d0000  ! 7607: STDF_R	std	%f24, [%r0, %r20]
	.word 0xbd348000  ! 7608: SRL_R	srl 	%r18, %r0, %r30
	.word 0xfe3de1b3  ! 7609: STD_I	std	%r31, [%r23 + 0x01b3]
	.word 0xf03c6117  ! 7610: STD_I	std	%r24, [%r17 + 0x0117]
	.word 0xf63c0000  ! 7613: STD_R	std	%r27, [%r16 + %r0]
	.word 0xf8350000  ! 7616: STH_R	sth	%r28, [%r20 + %r0]
	.word 0xfe756144  ! 7618: STX_I	stx	%r31, [%r21 + 0x0144]
	.word 0xf024c000  ! 7619: STW_R	stw	%r24, [%r19 + %r0]
	.word 0xbc458000  ! 7623: ADDC_R	addc 	%r22, %r0, %r30
	.word 0xf73dc000  ! 7626: STDF_R	std	%f27, [%r0, %r23]
hwintr_3_349:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_349), 16, 16)) -> intp(3, 0, 11)
	.word 0xf22d8000  ! 7632: STB_R	stb	%r25, [%r22 + %r0]
	.word 0xf43d0000  ! 7634: STD_R	std	%r26, [%r20 + %r0]
	.word 0xfa2c0000  ! 7635: STB_R	stb	%r29, [%r16 + %r0]
	mov	0, %r14
	.word 0xa193a000  ! 7638: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf43ce074  ! 7640: STD_I	std	%r26, [%r19 + 0x0074]
	.word 0xfc74e12c  ! 7641: STX_I	stx	%r30, [%r19 + 0x012c]
	.word 0xbc05a121  ! 7643: ADD_I	add 	%r22, 0x0121, %r30
	.word 0xb750c000  ! 7653: RDPR_TT	rdpr	%tt, %r27
	.word 0xb635a092  ! 7655: SUBC_I	orn 	%r22, 0x0092, %r27
	.word 0xf074c000  ! 7665: STX_R	stx	%r24, [%r19 + %r0]
	.word 0x8794e08b  ! 7668: WRPR_TT_I	wrpr	%r19, 0x008b, %tt
	.word 0xff3d4000  ! 7669: STDF_R	std	%f31, [%r0, %r21]
	.word 0xf02c0000  ! 7671: STB_R	stb	%r24, [%r16 + %r0]
	.word 0xf8356121  ! 7672: STH_I	sth	%r28, [%r21 + 0x0121]
	.word 0xb1643801  ! 7675: MOVcc_I	<illegal instruction>
	.word 0xbf520000  ! 7681: RDPR_PIL	rdpr	%pil, %r31
	.word 0xff3ce1af  ! 7684: STDF_I	std	%f31, [0x01af, %r19]
	.word 0xb4c4c000  ! 7685: ADDCcc_R	addccc 	%r19, %r0, %r26
	.word 0xfc74a0c9  ! 7686: STX_I	stx	%r30, [%r18 + 0x00c9]
	.word 0xf225e162  ! 7688: STW_I	stw	%r25, [%r23 + 0x0162]
	.word 0xf8740000  ! 7689: STX_R	stx	%r28, [%r16 + %r0]
hwintr_3_350:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_350), 16, 16)) -> intp(3, 0, f)
	.word 0x83952000  ! 7691: WRPR_TNPC_I	wrpr	%r20, 0x0000, %tnpc
	.word 0xfa2ca10d  ! 7699: STB_I	stb	%r29, [%r18 + 0x010d]
hwintr_3_351:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_351), 16, 16)) -> intp(3, 0, 1c)
	.word 0xbd518000  ! 7705: RDPR_PSTATE	rdpr	%pstate, %r30
	.word 0xfe3d218a  ! 7706: STD_I	std	%r31, [%r20 + 0x018a]
	.word 0xbd510000  ! 7707: RDPR_TICK	<illegal instruction>
	.word 0xfa3c4000  ! 7708: STD_R	std	%r29, [%r17 + %r0]
	.word 0x8d94609d  ! 7709: WRPR_PSTATE_I	wrpr	%r17, 0x009d, %pstate
hwintr_3_352:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_352), 16, 16)) -> intp(3, 0, 23)
	.word 0xf23d4000  ! 7714: STD_R	std	%r25, [%r21 + %r0]
	.word 0xfb3c2018  ! 7715: STDF_I	std	%f29, [0x0018, %r16]
	setx	data_start_2, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa3521fd  ! 7722: STH_I	sth	%r29, [%r20 + 0x01fd]
	.word 0xb751c000  ! 7723: RDPR_TL	rdpr	%tl, %r27
	.word 0xf83c8000  ! 7725: STD_R	std	%r28, [%r18 + %r0]
	.word 0xfe75a13a  ! 7731: STX_I	stx	%r31, [%r22 + 0x013a]
	.word 0xbd508000  ! 7733: RDPR_TSTATE	<illegal instruction>
	.word 0xfc35e0ad  ! 7734: STH_I	sth	%r30, [%r23 + 0x00ad]
	.word 0x8d956113  ! 7736: WRPR_PSTATE_I	wrpr	%r21, 0x0113, %pstate
	.word 0x8594e13c  ! 7737: WRPR_TSTATE_I	wrpr	%r19, 0x013c, %tstate
	mov	1, %r12
	.word 0x8f932000  ! 7738: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfa348000  ! 7742: STH_R	sth	%r29, [%r18 + %r0]
	.word 0xfe2c2010  ! 7743: STB_I	stb	%r31, [%r16 + 0x0010]
	.word 0xfb3de1ab  ! 7744: STDF_I	std	%f29, [0x01ab, %r23]
	setx	data_start_4, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf67561e8  ! 7751: STX_I	stx	%r27, [%r21 + 0x01e8]
	.word 0xbd510000  ! 7752: RDPR_TICK	rdpr	%tick, %r30
	.word 0xbb508000  ! 7753: RDPR_TSTATE	<illegal instruction>
hwintr_3_353:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_353), 16, 16)) -> intp(3, 0, 16)
	.word 0xba250000  ! 7756: SUB_R	sub 	%r20, %r0, %r29
	.word 0xf035e157  ! 7758: STH_I	sth	%r24, [%r23 + 0x0157]
	.word 0xf33c0000  ! 7763: STDF_R	std	%f25, [%r0, %r16]
	setx	data_start_2, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf82d0000  ! 7769: STB_R	stb	%r28, [%r20 + %r0]
	.word 0xbd480000  ! 7770: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xfe2da05a  ! 7772: STB_I	stb	%r31, [%r22 + 0x005a]
	.word 0xbf51c000  ! 7779: RDPR_TL	<illegal instruction>
	.word 0xfc3c4000  ! 7780: STD_R	std	%r30, [%r17 + %r0]
	.word 0xf13dc000  ! 7781: STDF_R	std	%f24, [%r0, %r23]
	.word 0xb9357001  ! 7783: SRLX_I	srlx	%r21, 0x0001, %r28
	.word 0xf82c8000  ! 7785: STB_R	stb	%r28, [%r18 + %r0]
hwintr_3_354:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_354), 16, 16)) -> intp(3, 0, 12)
hwintr_3_355:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_355), 16, 16)) -> intp(3, 0, 39)
	.word 0xfa3c8000  ! 7793: STD_R	std	%r29, [%r18 + %r0]
	.word 0xfa25e021  ! 7795: STW_I	stw	%r29, [%r23 + 0x0021]
	.word 0xfa3dc000  ! 7799: STD_R	std	%r29, [%r23 + %r0]
	.word 0xb09ca1c3  ! 7800: XORcc_I	xorcc 	%r18, 0x01c3, %r24
	.word 0xb1520000  ! 7805: RDPR_PIL	<illegal instruction>
	.word 0xf42c0000  ! 7806: STB_R	stb	%r26, [%r16 + %r0]
	setx	data_start_4, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xbd35d000  ! 7809: SRLX_R	srlx	%r23, %r0, %r30
hwintr_3_356:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_356), 16, 16)) -> intp(3, 0, 28)
	.word 0xbd504000  ! 7812: RDPR_TNPC	<illegal instruction>
	.word 0xb495e082  ! 7813: ORcc_I	orcc 	%r23, 0x0082, %r26
	.word 0xb9508000  ! 7815: RDPR_TSTATE	<illegal instruction>
	.word 0xfe3c6026  ! 7816: STD_I	std	%r31, [%r17 + 0x0026]
	.word 0xfa35216a  ! 7819: STH_I	sth	%r29, [%r20 + 0x016a]
	.word 0xbf520000  ! 7824: RDPR_PIL	<illegal instruction>
	.word 0xfa3d8000  ! 7828: STD_R	std	%r29, [%r22 + %r0]
	.word 0x8d9520ab  ! 7834: WRPR_PSTATE_I	wrpr	%r20, 0x00ab, %pstate
hwintr_3_357:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_357), 16, 16)) -> intp(3, 0, 3)
	.word 0xf47460c6  ! 7837: STX_I	stx	%r26, [%r17 + 0x00c6]
	.word 0x8994602b  ! 7840: WRPR_TICK_I	wrpr	%r17, 0x002b, %tick
	.word 0xfc35e17a  ! 7843: STH_I	sth	%r30, [%r23 + 0x017a]
	ta	T_CHANGE_HPRIV
	.word 0x81982951  ! 7844: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0951, %hpstate
	.word 0xb23460b0  ! 7849: ORN_I	orn 	%r17, 0x00b0, %r25
	.word 0xfe3da1f6  ! 7858: STD_I	std	%r31, [%r22 + 0x01f6]
	.word 0xf43c8000  ! 7859: STD_R	std	%r26, [%r18 + %r0]
hwintr_3_358:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_358), 16, 16)) -> intp(3, 0, 28)
	.word 0xbe25201d  ! 7862: SUB_I	sub 	%r20, 0x001d, %r31
	.word 0xb5504000  ! 7870: RDPR_TNPC	rdpr	%tnpc, %r26
	.word 0xfc75a066  ! 7876: STX_I	stx	%r30, [%r22 + 0x0066]
	.word 0xbe150000  ! 7877: OR_R	or 	%r20, %r0, %r31
	.word 0xf22dc000  ! 7879: STB_R	stb	%r25, [%r23 + %r0]
	.word 0xbd3d3001  ! 7882: SRAX_I	srax	%r20, 0x0001, %r30
	.word 0xf0742118  ! 7884: STX_I	stx	%r24, [%r16 + 0x0118]
	.word 0xf82461f1  ! 7885: STW_I	stw	%r28, [%r17 + 0x01f1]
	.word 0xf275e0fd  ! 7894: STX_I	stx	%r25, [%r23 + 0x00fd]
	.word 0xfc254000  ! 7895: STW_R	stw	%r30, [%r21 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982d41  ! 7897: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d41, %hpstate
hwintr_3_359:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_359), 16, 16)) -> intp(3, 0, 1)
	.word 0xbd504000  ! 7900: RDPR_TNPC	rdpr	%tnpc, %r30
hwintr_3_360:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_360), 16, 16)) -> intp(3, 0, 33)
	.word 0xf43cc000  ! 7905: STD_R	std	%r26, [%r19 + %r0]
	.word 0xb4a48000  ! 7909: SUBcc_R	subcc 	%r18, %r0, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81982b19  ! 7911: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b19, %hpstate
	.word 0xf4350000  ! 7914: STH_R	sth	%r26, [%r20 + %r0]
	.word 0xbb518000  ! 7915: RDPR_PSTATE	rdpr	%pstate, %r29
	.word 0xfc3c8000  ! 7916: STD_R	std	%r30, [%r18 + %r0]
	.word 0xbb508000  ! 7919: RDPR_TSTATE	<illegal instruction>
	.word 0xf82ca0a0  ! 7920: STB_I	stb	%r28, [%r18 + 0x00a0]
	.word 0xf0248000  ! 7921: STW_R	stw	%r24, [%r18 + %r0]
hwintr_3_361:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_361), 16, 16)) -> intp(3, 0, 3)
hwintr_3_362:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_362), 16, 16)) -> intp(3, 0, 1b)
	.word 0xb3508000  ! 7926: RDPR_TSTATE	<illegal instruction>
	.word 0xb7540000  ! 7927: RDPR_GL	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982e41  ! 7928: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e41, %hpstate
	.word 0x81942113  ! 7929: WRPR_TPC_I	wrpr	%r16, 0x0113, %tpc
	.word 0x8195a088  ! 7934: WRPR_TPC_I	wrpr	%r22, 0x0088, %tpc
	.word 0xfa2d2063  ! 7936: STB_I	stb	%r29, [%r20 + 0x0063]
	.word 0xfa340000  ! 7937: STH_R	sth	%r29, [%r16 + %r0]
	.word 0xf13c8000  ! 7938: STDF_R	std	%f24, [%r0, %r18]
	.word 0xf63c4000  ! 7939: STD_R	std	%r27, [%r17 + %r0]
hwintr_3_363:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_363), 16, 16)) -> intp(3, 0, 1d)
	.word 0xfc248000  ! 7948: STW_R	stw	%r30, [%r18 + %r0]
	setx	data_start_1, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_364:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_364), 16, 16)) -> intp(3, 0, c)
	.word 0xb2340000  ! 7959: ORN_R	orn 	%r16, %r0, %r25
	.word 0xf474a1ef  ! 7960: STX_I	stx	%r26, [%r18 + 0x01ef]
	.word 0xf035606c  ! 7964: STH_I	sth	%r24, [%r21 + 0x006c]
	.word 0xfa3c0000  ! 7969: STD_R	std	%r29, [%r16 + %r0]
	mov	1, %r14
	.word 0xa193a000  ! 7978: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbb504000  ! 7983: RDPR_TNPC	rdpr	%tnpc, %r29
hwintr_3_365:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_365), 16, 16)) -> intp(3, 0, 3)
	.word 0x8795a0c2  ! 7990: WRPR_TT_I	wrpr	%r22, 0x00c2, %tt
	.word 0xfd3d8000  ! 7991: STDF_R	std	%f30, [%r0, %r22]
	.word 0xfa75e037  ! 7994: STX_I	stx	%r29, [%r23 + 0x0037]
	.word 0xb8bda00e  ! 7999: XNORcc_I	xnorcc 	%r22, 0x000e, %r28
hwintr_3_366:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_366), 16, 16)) -> intp(3, 0, 1d)
	.word 0xf73de143  ! 8006: STDF_I	std	%f27, [0x0143, %r23]
	.word 0xb5504000  ! 8008: RDPR_TNPC	rdpr	%tnpc, %r26
	.word 0xf02420b9  ! 8010: STW_I	stw	%r24, [%r16 + 0x00b9]
hwintr_3_367:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_367), 16, 16)) -> intp(3, 0, 22)
hwintr_3_368:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_368), 16, 16)) -> intp(3, 0, 2)
	.word 0xfa2421ee  ! 8013: STW_I	stw	%r29, [%r16 + 0x01ee]
	.word 0x839561b3  ! 8021: WRPR_TNPC_I	wrpr	%r21, 0x01b3, %tnpc
	ta	T_CHANGE_HPRIV
	.word 0x81982f8b  ! 8022: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f8b, %hpstate
hwintr_3_369:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_369), 16, 16)) -> intp(3, 0, 3c)
	.word 0xf074c000  ! 8028: STX_R	stx	%r24, [%r19 + %r0]
	.word 0xf4258000  ! 8031: STW_R	stw	%r26, [%r22 + %r0]
	.word 0xbd3c0000  ! 8035: SRA_R	sra 	%r16, %r0, %r30
	.word 0xf8344000  ! 8036: STH_R	sth	%r28, [%r17 + %r0]
hwintr_3_370:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_370), 16, 16)) -> intp(3, 0, a)
	.word 0xb150c000  ! 8038: RDPR_TT	rdpr	%tt, %r24
	.word 0x8994e1f1  ! 8039: WRPR_TICK_I	wrpr	%r19, 0x01f1, %tick
hwintr_3_371:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_371), 16, 16)) -> intp(3, 0, 14)
hwintr_3_372:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_372), 16, 16)) -> intp(3, 0, 1e)
hwintr_3_373:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_373), 16, 16)) -> intp(3, 0, 21)
hwintr_3_374:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_374), 16, 16)) -> intp(3, 0, 2d)
	.word 0xfc7520dc  ! 8051: STX_I	stx	%r30, [%r20 + 0x00dc]
	.word 0xb5500000  ! 8052: RDPR_TPC	rdpr	%tpc, %r26
	.word 0xb9500000  ! 8054: RDPR_TPC	<illegal instruction>
	.word 0xb484e0c5  ! 8055: ADDcc_I	addcc 	%r19, 0x00c5, %r26
	.word 0xfc2c8000  ! 8061: STB_R	stb	%r30, [%r18 + %r0]
	.word 0xb751c000  ! 8072: RDPR_TL	<illegal instruction>
	.word 0xf635e1a0  ! 8078: STH_I	sth	%r27, [%r23 + 0x01a0]
	.word 0xf22de1b8  ! 8079: STB_I	stb	%r25, [%r23 + 0x01b8]
hwintr_3_375:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_375), 16, 16)) -> intp(3, 0, b)
	.word 0xfc2560b9  ! 8082: STW_I	stw	%r30, [%r21 + 0x00b9]
	.word 0xf435e1e2  ! 8087: STH_I	sth	%r26, [%r23 + 0x01e2]
	.word 0xf93ca00a  ! 8089: STDF_I	std	%f28, [0x000a, %r18]
	.word 0xb8344000  ! 8090: ORN_R	orn 	%r17, %r0, %r28
hwintr_3_376:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_376), 16, 16)) -> intp(3, 0, 2c)
	.word 0xbcc461f4  ! 8101: ADDCcc_I	addccc 	%r17, 0x01f4, %r30
	.word 0xfc3c8000  ! 8105: STD_R	std	%r30, [%r18 + %r0]
	.word 0xbd520000  ! 8108: RDPR_PIL	rdpr	%pil, %r30
	.word 0xf82461ce  ! 8109: STW_I	stw	%r28, [%r17 + 0x01ce]
	.word 0xfe344000  ! 8112: STH_R	sth	%r31, [%r17 + %r0]
hwintr_3_377:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_377), 16, 16)) -> intp(3, 0, d)
	.word 0xb1540000  ! 8116: RDPR_GL	<illegal instruction>
	.word 0x8594e1ea  ! 8117: WRPR_TSTATE_I	wrpr	%r19, 0x01ea, %tstate
	.word 0xb0ade1fd  ! 8119: ANDNcc_I	andncc 	%r23, 0x01fd, %r24
hwintr_3_378:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_378), 16, 16)) -> intp(3, 0, 24)
hwintr_3_379:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_379), 16, 16)) -> intp(3, 0, 2a)
	.word 0xb3508000  ! 8126: RDPR_TSTATE	rdpr	%tstate, %r25
	.word 0xf13dc000  ! 8128: STDF_R	std	%f24, [%r0, %r23]
	.word 0xbcb44000  ! 8131: ORNcc_R	orncc 	%r17, %r0, %r30
	.word 0xf62cc000  ! 8132: STB_R	stb	%r27, [%r19 + %r0]
	.word 0xf83c4000  ! 8134: STD_R	std	%r28, [%r17 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982a83  ! 8135: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a83, %hpstate
	.word 0xf83c0000  ! 8136: STD_R	std	%r28, [%r16 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81983ac9  ! 8137: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1ac9, %hpstate
	.word 0xf22d8000  ! 8138: STB_R	stb	%r25, [%r22 + %r0]
	.word 0xf8352126  ! 8140: STH_I	sth	%r28, [%r20 + 0x0126]
	.word 0xf63c8000  ! 8141: STD_R	std	%r27, [%r18 + %r0]
	.word 0xf63c0000  ! 8144: STD_R	std	%r27, [%r16 + %r0]
	.word 0xf53c4000  ! 8145: STDF_R	std	%f26, [%r0, %r17]
	.word 0xb9500000  ! 8146: RDPR_TPC	rdpr	%tpc, %r28
	.word 0xfe7461ba  ! 8147: STX_I	stx	%r31, [%r17 + 0x01ba]
	.word 0xbe148000  ! 8148: OR_R	or 	%r18, %r0, %r31
	.word 0xf635e1e8  ! 8149: STH_I	sth	%r27, [%r23 + 0x01e8]
	.word 0xfe35e149  ! 8150: STH_I	sth	%r31, [%r23 + 0x0149]
	.word 0xf62de167  ! 8152: STB_I	stb	%r27, [%r23 + 0x0167]
	.word 0xf03d6183  ! 8158: STD_I	std	%r24, [%r21 + 0x0183]
hwintr_3_380:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_380), 16, 16)) -> intp(3, 0, 30)
	.word 0xf33d0000  ! 8161: STDF_R	std	%f25, [%r0, %r20]
hwintr_3_381:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_381), 16, 16)) -> intp(3, 0, 1a)
	.word 0xf42c2093  ! 8167: STB_I	stb	%r26, [%r16 + 0x0093]
hwintr_3_382:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_382), 16, 16)) -> intp(3, 0, 15)
	.word 0xb1508000  ! 8169: RDPR_TSTATE	rdpr	%tstate, %r24
	.word 0xfd3d20e7  ! 8170: STDF_I	std	%f30, [0x00e7, %r20]
	.word 0xf824c000  ! 8171: STW_R	stw	%r28, [%r19 + %r0]
	.word 0xf73ce048  ! 8180: STDF_I	std	%f27, [0x0048, %r19]
	.word 0x8395e1ce  ! 8185: WRPR_TNPC_I	wrpr	%r23, 0x01ce, %tnpc
	.word 0xf02d0000  ! 8187: STB_R	stb	%r24, [%r20 + %r0]
	.word 0xb9518000  ! 8188: RDPR_PSTATE	rdpr	%pstate, %r28
	.word 0xb2942064  ! 8189: ORcc_I	orcc 	%r16, 0x0064, %r25
	.word 0xfb3ce18f  ! 8196: STDF_I	std	%f29, [0x018f, %r19]
	.word 0xfe254000  ! 8198: STW_R	stw	%r31, [%r21 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81983f49  ! 8201: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f49, %hpstate
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xf53ce022  ! 8209: STDF_I	std	%f26, [0x0022, %r19]
	.word 0xf4248000  ! 8211: STW_R	stw	%r26, [%r18 + %r0]
hwintr_3_383:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_383), 16, 16)) -> intp(3, 0, b)
	.word 0xf93ce181  ! 8216: STDF_I	std	%f28, [0x0181, %r19]
	.word 0x89956140  ! 8217: WRPR_TICK_I	wrpr	%r21, 0x0140, %tick
	.word 0xb624e151  ! 8222: SUB_I	sub 	%r19, 0x0151, %r27
	.word 0x8795e1c0  ! 8223: WRPR_TT_I	wrpr	%r23, 0x01c0, %tt
hwintr_3_384:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_384), 16, 16)) -> intp(3, 0, 13)
	.word 0xf874c000  ! 8232: STX_R	stx	%r28, [%r19 + %r0]
	.word 0xb9518000  ! 8233: RDPR_PSTATE	rdpr	%pstate, %r28
	.word 0xbd50c000  ! 8235: RDPR_TT	<illegal instruction>
hwintr_3_385:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_385), 16, 16)) -> intp(3, 0, 8)
	.word 0x8194e1e9  ! 8240: WRPR_TPC_I	wrpr	%r19, 0x01e9, %tpc
	.word 0xbabdc000  ! 8241: XNORcc_R	xnorcc 	%r23, %r0, %r29
	.word 0xf035c000  ! 8242: STH_R	sth	%r24, [%r23 + %r0]
	.word 0xf8758000  ! 8245: STX_R	stx	%r28, [%r22 + %r0]
	.word 0xb1540000  ! 8246: RDPR_GL	rdpr	%-, %r24
	.word 0xf62d8000  ! 8249: STB_R	stb	%r27, [%r22 + %r0]
	.word 0xbd504000  ! 8250: RDPR_TNPC	<illegal instruction>
	.word 0xfe34a01e  ! 8253: STH_I	sth	%r31, [%r18 + 0x001e]
	.word 0xff3c4000  ! 8254: STDF_R	std	%f31, [%r0, %r17]
	.word 0xf07420ba  ! 8256: STX_I	stx	%r24, [%r16 + 0x00ba]
	.word 0xbf540000  ! 8257: RDPR_GL	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81983f01  ! 8263: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f01, %hpstate
	.word 0xfa35a089  ! 8264: STH_I	sth	%r29, [%r22 + 0x0089]
	.word 0x8d94215d  ! 8265: WRPR_PSTATE_I	wrpr	%r16, 0x015d, %pstate
	.word 0xf13da102  ! 8266: STDF_I	std	%f24, [0x0102, %r22]
	.word 0xf035e0f9  ! 8271: STH_I	sth	%r24, [%r23 + 0x00f9]
	.word 0xfe2dc000  ! 8273: STB_R	stb	%r31, [%r23 + %r0]
	.word 0x8d95a195  ! 8274: WRPR_PSTATE_I	wrpr	%r22, 0x0195, %pstate
	.word 0xfa248000  ! 8275: STW_R	stw	%r29, [%r18 + %r0]
	.word 0xb7510000  ! 8281: RDPR_TICK	rdpr	%tick, %r27
	.word 0x8594e010  ! 8287: WRPR_TSTATE_I	wrpr	%r19, 0x0010, %tstate
hwintr_3_386:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_386), 16, 16)) -> intp(3, 0, 11)
	.word 0xb5504000  ! 8292: RDPR_TNPC	rdpr	%tnpc, %r26
	.word 0xf13da095  ! 8298: STDF_I	std	%f24, [0x0095, %r22]
	.word 0xf274a1ec  ! 8299: STX_I	stx	%r25, [%r18 + 0x01ec]
	setx	data_start_1, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_387:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_387), 16, 16)) -> intp(3, 0, 33)
	.word 0xf275611c  ! 8307: STX_I	stx	%r25, [%r21 + 0x011c]
	.word 0xbe35c000  ! 8312: ORN_R	orn 	%r23, %r0, %r31
hwintr_3_388:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_388), 16, 16)) -> intp(3, 0, 24)
	.word 0xb93d9000  ! 8316: SRAX_R	srax	%r22, %r0, %r28
	.word 0xf2748000  ! 8317: STX_R	stx	%r25, [%r18 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x8198290b  ! 8319: WRHPR_HPSTATE_I	wrhpr	%r0, 0x090b, %hpstate
	.word 0xf62da180  ! 8320: STB_I	stb	%r27, [%r22 + 0x0180]
	.word 0xb5480000  ! 8328: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81983f89  ! 8329: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f89, %hpstate
	.word 0xf63d4000  ! 8336: STD_R	std	%r27, [%r21 + %r0]
	.word 0xfc74601a  ! 8337: STX_I	stx	%r30, [%r17 + 0x001a]
	.word 0xfc3c4000  ! 8338: STD_R	std	%r30, [%r17 + %r0]
hwintr_3_389:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_389), 16, 16)) -> intp(3, 0, 25)
	.word 0xfa3561e9  ! 8343: STH_I	sth	%r29, [%r21 + 0x01e9]
	.word 0xfd3d0000  ! 8344: STDF_R	std	%f30, [%r0, %r20]
	.word 0xb4042193  ! 8346: ADD_I	add 	%r16, 0x0193, %r26
	.word 0x8994a161  ! 8348: WRPR_TICK_I	wrpr	%r18, 0x0161, %tick
	.word 0xf62c4000  ! 8349: STB_R	stb	%r27, [%r17 + %r0]
	.word 0xf13c6147  ! 8350: STDF_I	std	%f24, [0x0147, %r17]
	.word 0xb52db001  ! 8354: SLLX_I	sllx	%r22, 0x0001, %r26
	.word 0x8194e07f  ! 8356: WRPR_TPC_I	wrpr	%r19, 0x007f, %tpc
	.word 0xbcb4207d  ! 8358: SUBCcc_I	orncc 	%r16, 0x007d, %r30
hwintr_3_390:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_390), 16, 16)) -> intp(3, 0, 17)
	.word 0x9195e190  ! 8362: WRPR_PIL_I	wrpr	%r23, 0x0190, %pil
hwintr_3_391:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_391), 16, 16)) -> intp(3, 0, 21)
	setx	data_start_6, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_392:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_392), 16, 16)) -> intp(3, 0, 1)
	.word 0xfa2d8000  ! 8370: STB_R	stb	%r29, [%r22 + %r0]
	.word 0xbf510000  ! 8371: RDPR_TICK	rdpr	%tick, %r31
	.word 0xfe252154  ! 8375: STW_I	stw	%r31, [%r20 + 0x0154]
	.word 0xb950c000  ! 8380: RDPR_TT	<illegal instruction>
	.word 0xb1510000  ! 8384: RDPR_TICK	<illegal instruction>
	.word 0xfe3de0d0  ! 8385: STD_I	std	%r31, [%r23 + 0x00d0]
hwintr_3_393:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_393), 16, 16)) -> intp(3, 0, 7)
	ta	T_CHANGE_HPRIV
	.word 0x81983fd1  ! 8392: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1fd1, %hpstate
	.word 0xbd2c7001  ! 8393: SLLX_I	sllx	%r17, 0x0001, %r30
	mov	0, %r12
	.word 0x8f932000  ! 8395: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb834a1ea  ! 8401: SUBC_I	orn 	%r18, 0x01ea, %r28
	.word 0xb3480000  ! 8402: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
hwintr_3_394:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_394), 16, 16)) -> intp(3, 0, 27)
	.word 0xf42ce184  ! 8411: STB_I	stb	%r26, [%r19 + 0x0184]
	.word 0xfc748000  ! 8414: STX_R	stx	%r30, [%r18 + %r0]
hwintr_3_395:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_395), 16, 16)) -> intp(3, 0, b)
	.word 0xbf2cf001  ! 8422: SLLX_I	sllx	%r19, 0x0001, %r31
	.word 0xf224a0fd  ! 8426: STW_I	stw	%r25, [%r18 + 0x00fd]
	ta	T_CHANGE_HPRIV
	.word 0x81983adb  ! 8427: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1adb, %hpstate
	.word 0xb9504000  ! 8430: RDPR_TNPC	rdpr	%tnpc, %r28
	.word 0xb3508000  ! 8431: RDPR_TSTATE	<illegal instruction>
	.word 0xfe75e012  ! 8432: STX_I	stx	%r31, [%r23 + 0x0012]
	.word 0xf8342085  ! 8435: STH_I	sth	%r28, [%r16 + 0x0085]
hwintr_3_396:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_396), 16, 16)) -> intp(3, 0, 23)
hwintr_3_397:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_397), 16, 16)) -> intp(3, 0, 3)
	.word 0xfc340000  ! 8438: STH_R	sth	%r30, [%r16 + %r0]
	.word 0xfc258000  ! 8441: STW_R	stw	%r30, [%r22 + %r0]
	.word 0x819520e2  ! 8443: WRPR_TPC_I	wrpr	%r20, 0x00e2, %tpc
	mov	2, %r14
	.word 0xa193a000  ! 8444: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7540000  ! 8445: RDPR_GL	rdpr	%-, %r27
	.word 0xf27521f8  ! 8446: STX_I	stx	%r25, [%r20 + 0x01f8]
	.word 0x8195209b  ! 8449: WRPR_TPC_I	wrpr	%r20, 0x009b, %tpc
	.word 0xb3520000  ! 8454: RDPR_PIL	rdpr	%pil, %r25
	.word 0xb7540000  ! 8455: RDPR_GL	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x8198285b  ! 8457: WRHPR_HPSTATE_I	wrhpr	%r0, 0x085b, %hpstate
	.word 0xf42c0000  ! 8461: STB_R	stb	%r26, [%r16 + %r0]
	.word 0x8994e1f6  ! 8462: WRPR_TICK_I	wrpr	%r19, 0x01f6, %tick
	.word 0xf4344000  ! 8464: STH_R	sth	%r26, [%r17 + %r0]
	.word 0xf93ca1e2  ! 8466: STDF_I	std	%f28, [0x01e2, %r18]
	.word 0xf82de0c4  ! 8467: STB_I	stb	%r28, [%r23 + 0x00c4]
	.word 0xf03c2041  ! 8470: STD_I	std	%r24, [%r16 + 0x0041]
	.word 0xf73c21ed  ! 8472: STDF_I	std	%f27, [0x01ed, %r16]
	.word 0xfc2421bd  ! 8473: STW_I	stw	%r30, [%r16 + 0x01bd]
	.word 0xbb3d3001  ! 8474: SRAX_I	srax	%r20, 0x0001, %r29
	.word 0xf874e155  ! 8475: STX_I	stx	%r28, [%r19 + 0x0155]
	ta	T_CHANGE_HPRIV
	.word 0x81982d53  ! 8477: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d53, %hpstate
	.word 0xfc2d61b1  ! 8479: STB_I	stb	%r30, [%r21 + 0x01b1]
	.word 0xfa244000  ! 8481: STW_R	stw	%r29, [%r17 + %r0]
	.word 0xb5520000  ! 8483: RDPR_PIL	rdpr	%pil, %r26
	.word 0xfa352132  ! 8489: STH_I	sth	%r29, [%r20 + 0x0132]
	.word 0xf22c0000  ! 8497: STB_R	stb	%r25, [%r16 + %r0]
	.word 0xb6948000  ! 8498: ORcc_R	orcc 	%r18, %r0, %r27
	.word 0xfa3da0c9  ! 8500: STD_I	std	%r29, [%r22 + 0x00c9]
	.word 0xf53c20ac  ! 8501: STDF_I	std	%f26, [0x00ac, %r16]
	.word 0xf6742074  ! 8503: STX_I	stx	%r27, [%r16 + 0x0074]
	.word 0x8595e093  ! 8504: WRPR_TSTATE_I	wrpr	%r23, 0x0093, %tstate
	.word 0xfe2c6005  ! 8512: STB_I	stb	%r31, [%r17 + 0x0005]
	.word 0xbf518000  ! 8514: RDPR_PSTATE	rdpr	%pstate, %r31
hwintr_3_398:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_398), 16, 16)) -> intp(3, 0, 3e)
	.word 0xb7349000  ! 8520: SRLX_R	srlx	%r18, %r0, %r27
hwintr_3_399:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_399), 16, 16)) -> intp(3, 0, 0)
	.word 0xfe7521ef  ! 8522: STX_I	stx	%r31, [%r20 + 0x01ef]
	setx	data_start_7, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb551c000  ! 8526: RDPR_TL	rdpr	%tl, %r26
	.word 0xf43d2111  ! 8530: STD_I	std	%r26, [%r20 + 0x0111]
hwintr_3_400:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_400), 16, 16)) -> intp(3, 0, b)
	.word 0xf33ce0ed  ! 8533: STDF_I	std	%f25, [0x00ed, %r19]
	.word 0xfc34a075  ! 8534: STH_I	sth	%r30, [%r18 + 0x0075]
hwintr_3_401:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_401), 16, 16)) -> intp(3, 0, 24)
hwintr_3_402:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_402), 16, 16)) -> intp(3, 0, 13)
	.word 0xbe258000  ! 8539: SUB_R	sub 	%r22, %r0, %r31
	.word 0x8195e1d6  ! 8540: WRPR_TPC_I	wrpr	%r23, 0x01d6, %tpc
	setx	data_start_6, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_403:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_403), 16, 16)) -> intp(3, 0, a)
hwintr_3_404:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_404), 16, 16)) -> intp(3, 0, 5)
	.word 0xb3643801  ! 8549: MOVcc_I	<illegal instruction>
	.word 0xf234c000  ! 8552: STH_R	sth	%r25, [%r19 + %r0]
hwintr_3_405:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_405), 16, 16)) -> intp(3, 0, 3a)
	.word 0xb7643801  ! 8562: MOVcc_I	<illegal instruction>
	.word 0xf82de1eb  ! 8565: STB_I	stb	%r28, [%r23 + 0x01eb]
	ta	T_CHANGE_HPRIV
	.word 0x81982943  ! 8566: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0943, %hpstate
	.word 0xb4b52187  ! 8572: ORNcc_I	orncc 	%r20, 0x0187, %r26
	.word 0xfc3d0000  ! 8573: STD_R	std	%r30, [%r20 + %r0]
	.word 0x9194e01d  ! 8575: WRPR_PIL_I	wrpr	%r19, 0x001d, %pil
	.word 0xfe358000  ! 8577: STH_R	sth	%r31, [%r22 + %r0]
	.word 0xfa3561d4  ! 8582: STH_I	sth	%r29, [%r21 + 0x01d4]
	.word 0xf634c000  ! 8584: STH_R	sth	%r27, [%r19 + %r0]
	.word 0xbf520000  ! 8585: RDPR_PIL	rdpr	%pil, %r31
	.word 0xf62c2067  ! 8587: STB_I	stb	%r27, [%r16 + 0x0067]
	.word 0xf0344000  ! 8588: STH_R	sth	%r24, [%r17 + %r0]
	.word 0xf23c8000  ! 8590: STD_R	std	%r25, [%r18 + %r0]
	.word 0xb951c000  ! 8593: RDPR_TL	<illegal instruction>
	.word 0xfe75c000  ! 8595: STX_R	stx	%r31, [%r23 + %r0]
	.word 0xb7518000  ! 8596: RDPR_PSTATE	<illegal instruction>
	.word 0xfe2c600b  ! 8597: STB_I	stb	%r31, [%r17 + 0x000b]
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xf6354000  ! 8602: STH_R	sth	%r27, [%r21 + %r0]
	.word 0xfb3de04f  ! 8605: STDF_I	std	%f29, [0x004f, %r23]
	.word 0xb3540000  ! 8607: RDPR_GL	rdpr	%-, %r25
	.word 0x859561ae  ! 8610: WRPR_TSTATE_I	wrpr	%r21, 0x01ae, %tstate
	.word 0xf675a17a  ! 8615: STX_I	stx	%r27, [%r22 + 0x017a]
hwintr_3_406:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_406), 16, 16)) -> intp(3, 0, 3f)
	.word 0xf02da1f9  ! 8619: STB_I	stb	%r24, [%r22 + 0x01f9]
	.word 0xb9518000  ! 8620: RDPR_PSTATE	rdpr	%pstate, %r28
	.word 0xfa3dc000  ! 8621: STD_R	std	%r29, [%r23 + %r0]
	.word 0xf73ce019  ! 8622: STDF_I	std	%f27, [0x0019, %r19]
	.word 0xb12df001  ! 8623: SLLX_I	sllx	%r23, 0x0001, %r24
	.word 0xf02c0000  ! 8625: STB_R	stb	%r24, [%r16 + %r0]
	.word 0xf62d8000  ! 8632: STB_R	stb	%r27, [%r22 + %r0]
	.word 0xf224e15a  ! 8633: STW_I	stw	%r25, [%r19 + 0x015a]
	.word 0xbd518000  ! 8634: RDPR_PSTATE	<illegal instruction>
	mov	1, %r12
	.word 0x8f932000  ! 8635: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb4256145  ! 8636: SUB_I	sub 	%r21, 0x0145, %r26
	.word 0xb5520000  ! 8638: RDPR_PIL	rdpr	%pil, %r26
hwintr_3_407:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_407), 16, 16)) -> intp(3, 0, 21)
	.word 0x8994216a  ! 8641: WRPR_TICK_I	wrpr	%r16, 0x016a, %tick
	.word 0xf63da128  ! 8644: STD_I	std	%r27, [%r22 + 0x0128]
	.word 0xfc25a1d7  ! 8645: STW_I	stw	%r30, [%r22 + 0x01d7]
hwintr_3_408:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_408), 16, 16)) -> intp(3, 0, d)
	.word 0xf13ca148  ! 8654: STDF_I	std	%f24, [0x0148, %r18]
hwintr_3_409:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_409), 16, 16)) -> intp(3, 0, 31)
	.word 0xf53c0000  ! 8662: STDF_R	std	%f26, [%r0, %r16]
hwintr_3_410:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_410), 16, 16)) -> intp(3, 0, 28)
	.word 0xf675a02b  ! 8670: STX_I	stx	%r27, [%r22 + 0x002b]
	.word 0xf03d4000  ! 8674: STD_R	std	%r24, [%r21 + %r0]
	.word 0xf33da0c9  ! 8675: STDF_I	std	%f25, [0x00c9, %r22]
	.word 0x9195a1a4  ! 8676: WRPR_PIL_I	wrpr	%r22, 0x01a4, %pil
	.word 0xfe75c000  ! 8679: STX_R	stx	%r31, [%r23 + %r0]
	.word 0xb4a421d2  ! 8681: SUBcc_I	subcc 	%r16, 0x01d2, %r26
	.word 0xf83d6135  ! 8684: STD_I	std	%r28, [%r21 + 0x0135]
	.word 0xb0a4a0df  ! 8685: SUBcc_I	subcc 	%r18, 0x00df, %r24
	.word 0xfe7560ed  ! 8687: STX_I	stx	%r31, [%r21 + 0x00ed]
	.word 0xb9500000  ! 8690: RDPR_TPC	rdpr	%tpc, %r28
hwintr_3_411:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_411), 16, 16)) -> intp(3, 0, 3f)
	.word 0xf2744000  ! 8700: STX_R	stx	%r25, [%r17 + %r0]
	.word 0xf73ce015  ! 8701: STDF_I	std	%f27, [0x0015, %r19]
	.word 0x8995a001  ! 8703: WRPR_TICK_I	wrpr	%r22, 0x0001, %tick
	.word 0xbe9ca16b  ! 8704: XORcc_I	xorcc 	%r18, 0x016b, %r31
	.word 0xb69d4000  ! 8705: XORcc_R	xorcc 	%r21, %r0, %r27
	.word 0xbb2c3001  ! 8707: SLLX_I	sllx	%r16, 0x0001, %r29
hwintr_3_412:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_412), 16, 16)) -> intp(3, 0, 23)
	.word 0xbb2d6001  ! 8711: SLL_I	sll 	%r21, 0x0001, %r29
hwintr_3_413:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_413), 16, 16)) -> intp(3, 0, 18)
	mov	0, %r14
	.word 0xa193a000  ! 8718: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbd540000  ! 8719: RDPR_GL	rdpr	%-, %r30
	ta	T_CHANGE_HPRIV
	.word 0x81983853  ! 8721: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1853, %hpstate
	.word 0xf83d0000  ! 8722: STD_R	std	%r28, [%r20 + %r0]
	.word 0xb4b4a129  ! 8723: ORNcc_I	orncc 	%r18, 0x0129, %r26
	.word 0xf33c8000  ! 8725: STDF_R	std	%f25, [%r0, %r18]
	.word 0xf63d0000  ! 8726: STD_R	std	%r27, [%r20 + %r0]
	.word 0xfa2cc000  ! 8730: STB_R	stb	%r29, [%r19 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81983bc9  ! 8732: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1bc9, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81983e51  ! 8734: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e51, %hpstate
	.word 0xf4248000  ! 8736: STW_R	stw	%r26, [%r18 + %r0]
	.word 0xf82d60b9  ! 8739: STB_I	stb	%r28, [%r21 + 0x00b9]
hwintr_3_414:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_414), 16, 16)) -> intp(3, 0, 11)
	.word 0xff3d4000  ! 8742: STDF_R	std	%f31, [%r0, %r21]
	.word 0x8594e1c4  ! 8744: WRPR_TSTATE_I	wrpr	%r19, 0x01c4, %tstate
	.word 0xbd520000  ! 8746: RDPR_PIL	rdpr	%pil, %r30
	.word 0x8594617e  ! 8747: WRPR_TSTATE_I	wrpr	%r17, 0x017e, %tstate
	.word 0xb3480000  ! 8750: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xf475614d  ! 8751: STX_I	stx	%r26, [%r21 + 0x014d]
	mov	0, %r14
	.word 0xa193a000  ! 8754: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb2454000  ! 8755: ADDC_R	addc 	%r21, %r0, %r25
	.word 0xb151c000  ! 8756: RDPR_TL	rdpr	%tl, %r24
	.word 0xfd3de0d0  ! 8759: STDF_I	std	%f30, [0x00d0, %r23]
	.word 0xbc050000  ! 8762: ADD_R	add 	%r20, %r0, %r30
	.word 0xf93ce039  ! 8763: STDF_I	std	%f28, [0x0039, %r19]
	.word 0xf024e151  ! 8765: STW_I	stw	%r24, [%r19 + 0x0151]
hwintr_3_415:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_415), 16, 16)) -> intp(3, 0, 1e)
	.word 0x8794a169  ! 8767: WRPR_TT_I	wrpr	%r18, 0x0169, %tt
	.word 0xbc952089  ! 8770: ORcc_I	orcc 	%r20, 0x0089, %r30
	.word 0xbe0cc000  ! 8771: AND_R	and 	%r19, %r0, %r31
	.word 0xf33dc000  ! 8775: STDF_R	std	%f25, [%r0, %r23]
	.word 0xf43c217f  ! 8776: STD_I	std	%r26, [%r16 + 0x017f]
	.word 0xfe75208c  ! 8778: STX_I	stx	%r31, [%r20 + 0x008c]
	.word 0xb9508000  ! 8780: RDPR_TSTATE	rdpr	%tstate, %r28
	.word 0xfe2d20af  ! 8787: STB_I	stb	%r31, [%r20 + 0x00af]
	.word 0xf4244000  ! 8791: STW_R	stw	%r26, [%r17 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982b89  ! 8794: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b89, %hpstate
	.word 0xb5358000  ! 8796: SRL_R	srl 	%r22, %r0, %r26
	.word 0xb09c4000  ! 8798: XORcc_R	xorcc 	%r17, %r0, %r24
hwintr_3_416:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_416), 16, 16)) -> intp(3, 0, 17)
	.word 0xfc34e12f  ! 8804: STH_I	sth	%r30, [%r19 + 0x012f]
	.word 0xfa3c0000  ! 8808: STD_R	std	%r29, [%r16 + %r0]
	.word 0xfa3d60c0  ! 8812: STD_I	std	%r29, [%r21 + 0x00c0]
	ta	T_CHANGE_HPRIV
	.word 0x819839d1  ! 8814: WRHPR_HPSTATE_I	wrhpr	%r0, 0x19d1, %hpstate
	.word 0xb4c44000  ! 8816: ADDCcc_R	addccc 	%r17, %r0, %r26
	.word 0xf22d8000  ! 8817: STB_R	stb	%r25, [%r22 + %r0]
	.word 0xf4348000  ! 8818: STH_R	sth	%r26, [%r18 + %r0]
	.word 0xba0c0000  ! 8820: AND_R	and 	%r16, %r0, %r29
	.word 0xfa740000  ! 8821: STX_R	stx	%r29, [%r16 + %r0]
	.word 0xfc752077  ! 8827: STX_I	stx	%r30, [%r20 + 0x0077]
	.word 0x8194e11d  ! 8828: WRPR_TPC_I	wrpr	%r19, 0x011d, %tpc
	ta	T_CHANGE_HPRIV
	.word 0x81982d43  ! 8829: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d43, %hpstate
	.word 0xfa24a1a6  ! 8830: STW_I	stw	%r29, [%r18 + 0x01a6]
	.word 0xb3510000  ! 8833: RDPR_TICK	rdpr	%tick, %r25
	.word 0xf63c4000  ! 8838: STD_R	std	%r27, [%r17 + %r0]
	.word 0xf83d4000  ! 8839: STD_R	std	%r28, [%r21 + %r0]
	.word 0xf0348000  ! 8842: STH_R	sth	%r24, [%r18 + %r0]
	.word 0xb684c000  ! 8844: ADDcc_R	addcc 	%r19, %r0, %r27
	.word 0xb3504000  ! 8845: RDPR_TNPC	<illegal instruction>
	.word 0x8594e177  ! 8847: WRPR_TSTATE_I	wrpr	%r19, 0x0177, %tstate
	.word 0xfb3d212c  ! 8852: STDF_I	std	%f29, [0x012c, %r20]
	.word 0xf42da153  ! 8854: STB_I	stb	%r26, [%r22 + 0x0153]
hwintr_3_417:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_417), 16, 16)) -> intp(3, 0, 1f)
	mov	1, %r12
	.word 0x8f932000  ! 8858: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfc3c8000  ! 8859: STD_R	std	%r30, [%r18 + %r0]
	.word 0xb1518000  ! 8863: RDPR_PSTATE	rdpr	%pstate, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982d8b  ! 8864: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d8b, %hpstate
	.word 0xfa74619b  ! 8865: STX_I	stx	%r29, [%r17 + 0x019b]
	.word 0xfa254000  ! 8870: STW_R	stw	%r29, [%r21 + %r0]
	setx	data_start_7, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf33c602d  ! 8877: STDF_I	std	%f25, [0x002d, %r17]
	.word 0xbc248000  ! 8878: SUB_R	sub 	%r18, %r0, %r30
	.word 0xb00d20b0  ! 8884: AND_I	and 	%r20, 0x00b0, %r24
	.word 0xbb356001  ! 8886: SRL_I	srl 	%r21, 0x0001, %r29
	.word 0xf62c0000  ! 8888: STB_R	stb	%r27, [%r16 + %r0]
	.word 0xf33dc000  ! 8896: STDF_R	std	%f25, [%r0, %r23]
	.word 0xfa25a0f6  ! 8897: STW_I	stw	%r29, [%r22 + 0x00f6]
	.word 0xf93c8000  ! 8898: STDF_R	std	%f28, [%r0, %r18]
	.word 0xf73dc000  ! 8899: STDF_R	std	%f27, [%r0, %r23]
	.word 0xfc35c000  ! 8900: STH_R	sth	%r30, [%r23 + %r0]
	.word 0xf73da070  ! 8902: STDF_I	std	%f27, [0x0070, %r22]
	.word 0xfe2461e1  ! 8903: STW_I	stw	%r31, [%r17 + 0x01e1]
	.word 0xfd3da0a8  ! 8906: STDF_I	std	%f30, [0x00a8, %r22]
	.word 0xfc74c000  ! 8910: STX_R	stx	%r30, [%r19 + %r0]
	.word 0xfa35e0fc  ! 8917: STH_I	sth	%r29, [%r23 + 0x00fc]
hwintr_3_418:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_418), 16, 16)) -> intp(3, 0, 1f)
	.word 0xb550c000  ! 8925: RDPR_TT	rdpr	%tt, %r26
	.word 0xfc2c4000  ! 8928: STB_R	stb	%r30, [%r17 + %r0]
	.word 0x8395e18a  ! 8931: WRPR_TNPC_I	wrpr	%r23, 0x018a, %tnpc
	.word 0xfe24c000  ! 8932: STW_R	stw	%r31, [%r19 + %r0]
hwintr_3_419:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_419), 16, 16)) -> intp(3, 0, 8)
	.word 0xff3c609a  ! 8940: STDF_I	std	%f31, [0x009a, %r17]
hwintr_3_420:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_420), 16, 16)) -> intp(3, 0, 26)
hwintr_3_421:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_421), 16, 16)) -> intp(3, 0, 3)
	.word 0xfc354000  ! 8943: STH_R	sth	%r30, [%r21 + %r0]
	.word 0xff3da1a5  ! 8945: STDF_I	std	%f31, [0x01a5, %r22]
	.word 0xf53c4000  ! 8946: STDF_R	std	%f26, [%r0, %r17]
	.word 0xf22421c8  ! 8950: STW_I	stw	%r25, [%r16 + 0x01c8]
	.word 0xba0c6118  ! 8952: AND_I	and 	%r17, 0x0118, %r29
	.word 0xb634a12f  ! 8956: SUBC_I	orn 	%r18, 0x012f, %r27
	.word 0xfc2561b5  ! 8961: STW_I	stw	%r30, [%r21 + 0x01b5]
	.word 0xf33d6188  ! 8967: STDF_I	std	%f25, [0x0188, %r21]
	.word 0xf0250000  ! 8969: STW_R	stw	%r24, [%r20 + %r0]
	.word 0xf43d8000  ! 8970: STD_R	std	%r26, [%r22 + %r0]
hwintr_3_422:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_422), 16, 16)) -> intp(3, 0, d)
	.word 0xf6348000  ! 8975: STH_R	sth	%r27, [%r18 + %r0]
	.word 0xbd34b001  ! 8977: SRLX_I	srlx	%r18, 0x0001, %r30
	.word 0xfe2da10c  ! 8979: STB_I	stb	%r31, [%r22 + 0x010c]
hwintr_3_423:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_423), 16, 16)) -> intp(3, 0, 9)
	setx	data_start_4, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8394e199  ! 8984: WRPR_TNPC_I	wrpr	%r19, 0x0199, %tnpc
	.word 0xfd3c21e2  ! 8985: STDF_I	std	%f30, [0x01e2, %r16]
	.word 0xbb480000  ! 8988: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xfc250000  ! 8990: STW_R	stw	%r30, [%r20 + %r0]
	.word 0xf824e129  ! 8991: STW_I	stw	%r28, [%r19 + 0x0129]
	ta	T_CHANGE_HPRIV
	.word 0x81983859  ! 8992: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1859, %hpstate
	.word 0xb20dc000  ! 8993: AND_R	and 	%r23, %r0, %r25
	.word 0xfa35e1ee  ! 8997: STH_I	sth	%r29, [%r23 + 0x01ee]
	.word 0xfe758000  ! 8998: STX_R	stx	%r31, [%r22 + %r0]
	.word 0xf475c000  ! 8999: STX_R	stx	%r26, [%r23 + %r0]
	.word 0xbb518000  ! 9001: RDPR_PSTATE	rdpr	%pstate, %r29
hwintr_3_424:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_424), 16, 16)) -> intp(3, 0, 31)
	.word 0xfa2c2076  ! 9009: STB_I	stb	%r29, [%r16 + 0x0076]
	.word 0xbd3c7001  ! 9010: SRAX_I	srax	%r17, 0x0001, %r30
	.word 0xf6746049  ! 9011: STX_I	stx	%r27, [%r17 + 0x0049]
	.word 0xb6344000  ! 9015: SUBC_R	orn 	%r17, %r0, %r27
	.word 0xfc2ca13f  ! 9016: STB_I	stb	%r30, [%r18 + 0x013f]
	.word 0xbd480000  ! 9019: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xf43cc000  ! 9022: STD_R	std	%r26, [%r19 + %r0]
	.word 0xb8bc2141  ! 9024: XNORcc_I	xnorcc 	%r16, 0x0141, %r28
	.word 0xf074c000  ! 9026: STX_R	stx	%r24, [%r19 + %r0]
	.word 0xb1518000  ! 9028: RDPR_PSTATE	<illegal instruction>
	.word 0xf475e113  ! 9030: STX_I	stx	%r26, [%r23 + 0x0113]
	.word 0xbc156175  ! 9037: OR_I	or 	%r21, 0x0175, %r30
	.word 0xfa352004  ! 9040: STH_I	sth	%r29, [%r20 + 0x0004]
	.word 0xf33d211f  ! 9042: STDF_I	std	%f25, [0x011f, %r20]
	.word 0xf33de0de  ! 9046: STDF_I	std	%f25, [0x00de, %r23]
	.word 0xfc2c61df  ! 9050: STB_I	stb	%r30, [%r17 + 0x01df]
	ta	T_CHANGE_HPRIV
	.word 0x8198395b  ! 9051: WRHPR_HPSTATE_I	wrhpr	%r0, 0x195b, %hpstate
	.word 0xf23c61b4  ! 9054: STD_I	std	%r25, [%r17 + 0x01b4]
	.word 0xb3510000  ! 9057: RDPR_TICK	rdpr	%tick, %r25
	mov	2, %r14
	.word 0xa193a000  ! 9059: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf2758000  ! 9060: STX_R	stx	%r25, [%r22 + %r0]
	.word 0xbb50c000  ! 9063: RDPR_TT	rdpr	%tt, %r29
	setx	data_start_0, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_425:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_425), 16, 16)) -> intp(3, 0, 1c)
	.word 0xf0254000  ! 9068: STW_R	stw	%r24, [%r21 + %r0]
hwintr_3_426:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_426), 16, 16)) -> intp(3, 0, 1a)
	.word 0xfa2d602b  ! 9070: STB_I	stb	%r29, [%r21 + 0x002b]
hwintr_3_427:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_427), 16, 16)) -> intp(3, 0, 1b)
	.word 0x859461b5  ! 9077: WRPR_TSTATE_I	wrpr	%r17, 0x01b5, %tstate
	.word 0x9195a1e4  ! 9078: WRPR_PIL_I	wrpr	%r22, 0x01e4, %pil
	.word 0x8594a0d5  ! 9079: WRPR_TSTATE_I	wrpr	%r18, 0x00d5, %tstate
	.word 0xbd480000  ! 9080: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xfe2c20fd  ! 9081: STB_I	stb	%r31, [%r16 + 0x00fd]
	.word 0x91942035  ! 9083: WRPR_PIL_I	wrpr	%r16, 0x0035, %pil
	.word 0xff3dc000  ! 9085: STDF_R	std	%f31, [%r0, %r23]
	.word 0xf82d0000  ! 9089: STB_R	stb	%r28, [%r20 + %r0]
	.word 0xf43c8000  ! 9090: STD_R	std	%r26, [%r18 + %r0]
	.word 0xfe744000  ! 9092: STX_R	stx	%r31, [%r17 + %r0]
	.word 0xbc1560f1  ! 9097: OR_I	or 	%r21, 0x00f1, %r30
	.word 0xb2b4c000  ! 9098: SUBCcc_R	orncc 	%r19, %r0, %r25
	.word 0xb934e001  ! 9100: SRL_I	srl 	%r19, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81983b51  ! 9101: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b51, %hpstate
	.word 0xf075c000  ! 9102: STX_R	stx	%r24, [%r23 + %r0]
	setx	data_start_4, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb7643801  ! 9110: MOVcc_I	<illegal instruction>
	.word 0xf93d2039  ! 9112: STDF_I	std	%f28, [0x0039, %r20]
	.word 0xbe2c0000  ! 9113: ANDN_R	andn 	%r16, %r0, %r31
	setx	data_start_4, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8794e08a  ! 9121: WRPR_TT_I	wrpr	%r19, 0x008a, %tt
	.word 0xb7500000  ! 9122: RDPR_TPC	rdpr	%tpc, %r27
	.word 0xf93c8000  ! 9124: STDF_R	std	%f28, [%r0, %r18]
	.word 0xb5520000  ! 9125: RDPR_PIL	<illegal instruction>
hwintr_3_428:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_428), 16, 16)) -> intp(3, 0, 1a)
	.word 0xf034a189  ! 9130: STH_I	sth	%r24, [%r18 + 0x0189]
	.word 0x8594a0af  ! 9131: WRPR_TSTATE_I	wrpr	%r18, 0x00af, %tstate
	.word 0xf675e081  ! 9133: STX_I	stx	%r27, [%r23 + 0x0081]
hwintr_3_429:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_429), 16, 16)) -> intp(3, 0, 31)
	.word 0xf6752015  ! 9138: STX_I	stx	%r27, [%r20 + 0x0015]
	.word 0xfc7461d1  ! 9139: STX_I	stx	%r30, [%r17 + 0x01d1]
	.word 0xb350c000  ! 9141: RDPR_TT	rdpr	%tt, %r25
hwintr_3_430:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_430), 16, 16)) -> intp(3, 0, 3b)
	.word 0xb825a179  ! 9143: SUB_I	sub 	%r22, 0x0179, %r28
hwintr_3_431:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_431), 16, 16)) -> intp(3, 0, f)
	.word 0xf475618f  ! 9148: STX_I	stx	%r26, [%r21 + 0x018f]
	.word 0xfd3da033  ! 9153: STDF_I	std	%f30, [0x0033, %r22]
	.word 0xb2bc60c6  ! 9156: XNORcc_I	xnorcc 	%r17, 0x00c6, %r25
	setx	data_start_3, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xbd344000  ! 9164: SRL_R	srl 	%r17, %r0, %r30
	.word 0xb73da001  ! 9166: SRA_I	sra 	%r22, 0x0001, %r27
	.word 0xf13d4000  ! 9171: STDF_R	std	%f24, [%r0, %r21]
	.word 0xb6b44000  ! 9172: SUBCcc_R	orncc 	%r17, %r0, %r27
	.word 0xfc2c8000  ! 9175: STB_R	stb	%r30, [%r18 + %r0]
	.word 0xfa2d0000  ! 9176: STB_R	stb	%r29, [%r20 + %r0]
	.word 0xb7520000  ! 9178: RDPR_PIL	<illegal instruction>
	.word 0xbd2d7001  ! 9181: SLLX_I	sllx	%r21, 0x0001, %r30
	.word 0xff3c21a2  ! 9182: STDF_I	std	%f31, [0x01a2, %r16]
	.word 0xb2058000  ! 9185: ADD_R	add 	%r22, %r0, %r25
	.word 0xbaa56132  ! 9187: SUBcc_I	subcc 	%r21, 0x0132, %r29
hwintr_3_432:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_432), 16, 16)) -> intp(3, 0, 3a)
	.word 0xf0744000  ! 9193: STX_R	stx	%r24, [%r17 + %r0]
	.word 0xf42da090  ! 9194: STB_I	stb	%r26, [%r22 + 0x0090]
	.word 0xf435a152  ! 9197: STH_I	sth	%r26, [%r22 + 0x0152]
	.word 0xfa34a11e  ! 9199: STH_I	sth	%r29, [%r18 + 0x011e]
	.word 0xbd2c0000  ! 9202: SLL_R	sll 	%r16, %r0, %r30
	.word 0xbabc61b2  ! 9206: XNORcc_I	xnorcc 	%r17, 0x01b2, %r29
	.word 0xfc74615e  ! 9207: STX_I	stx	%r30, [%r17 + 0x015e]
	.word 0xb23421e0  ! 9209: SUBC_I	orn 	%r16, 0x01e0, %r25
	.word 0xbb50c000  ! 9210: RDPR_TT	<illegal instruction>
	.word 0xf82d8000  ! 9212: STB_R	stb	%r28, [%r22 + %r0]
	.word 0xf8248000  ! 9213: STW_R	stw	%r28, [%r18 + %r0]
	.word 0x89956062  ! 9215: WRPR_TICK_I	wrpr	%r21, 0x0062, %tick
	.word 0xb5504000  ! 9223: RDPR_TNPC	rdpr	%tnpc, %r26
	.word 0xfb3c60a4  ! 9224: STDF_I	std	%f29, [0x00a4, %r17]
	.word 0xb4348000  ! 9229: ORN_R	orn 	%r18, %r0, %r26
	.word 0xb7518000  ! 9232: RDPR_PSTATE	<illegal instruction>
	.word 0xb6448000  ! 9233: ADDC_R	addc 	%r18, %r0, %r27
	.word 0xfe350000  ! 9236: STH_R	sth	%r31, [%r20 + %r0]
	.word 0x9194a026  ! 9237: WRPR_PIL_I	wrpr	%r18, 0x0026, %pil
	.word 0xfc3c2134  ! 9240: STD_I	std	%r30, [%r16 + 0x0134]
	.word 0xbb520000  ! 9241: RDPR_PIL	rdpr	%pil, %r29
	.word 0x919461f9  ! 9244: WRPR_PIL_I	wrpr	%r17, 0x01f9, %pil
	.word 0xfc254000  ! 9246: STW_R	stw	%r30, [%r21 + %r0]
	setx	data_start_7, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8595a02d  ! 9250: WRPR_TSTATE_I	wrpr	%r22, 0x002d, %tstate
	.word 0xfe3d20cc  ! 9253: STD_I	std	%r31, [%r20 + 0x00cc]
hwintr_3_433:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_433), 16, 16)) -> intp(3, 0, 1c)
	.word 0xb1480000  ! 9259: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
hwintr_3_434:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_434), 16, 16)) -> intp(3, 0, 22)
	.word 0x9195a086  ! 9271: WRPR_PIL_I	wrpr	%r22, 0x0086, %pil
	.word 0xbd7de401  ! 9272: MOVR_I	movre	%r23, 0x1, %r30
	.word 0xba44209b  ! 9278: ADDC_I	addc 	%r16, 0x009b, %r29
	.word 0xfa34c000  ! 9280: STH_R	sth	%r29, [%r19 + %r0]
	.word 0xf6254000  ! 9283: STW_R	stw	%r27, [%r21 + %r0]
	.word 0xff3de107  ! 9284: STDF_I	std	%f31, [0x0107, %r23]
	.word 0xfa754000  ! 9286: STX_R	stx	%r29, [%r21 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x81982c99  ! 9288: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c99, %hpstate
	.word 0xfa3560a3  ! 9289: STH_I	sth	%r29, [%r21 + 0x00a3]
	.word 0xb21ca165  ! 9290: XOR_I	xor 	%r18, 0x0165, %r25
	.word 0x8995a0c4  ! 9294: WRPR_TICK_I	wrpr	%r22, 0x00c4, %tick
	.word 0xb8c4e0a7  ! 9296: ADDCcc_I	addccc 	%r19, 0x00a7, %r28
	.word 0xfe24e1c6  ! 9298: STW_I	stw	%r31, [%r19 + 0x01c6]
	.word 0xb7508000  ! 9302: RDPR_TSTATE	rdpr	%tstate, %r27
	.word 0xfa750000  ! 9304: STX_R	stx	%r29, [%r20 + %r0]
	.word 0xf73c6176  ! 9307: STDF_I	std	%f27, [0x0176, %r17]
	.word 0xbb510000  ! 9308: RDPR_TICK	<illegal instruction>
hwintr_3_435:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_435), 16, 16)) -> intp(3, 0, 15)
	.word 0xfa3dc000  ! 9318: STD_R	std	%r29, [%r23 + %r0]
	.word 0x9194a0ba  ! 9321: WRPR_PIL_I	wrpr	%r18, 0x00ba, %pil
	.word 0xb9504000  ! 9323: RDPR_TNPC	rdpr	%tnpc, %r28
	.word 0xf274207d  ! 9327: STX_I	stx	%r25, [%r16 + 0x007d]
	.word 0x9195a03c  ! 9328: WRPR_PIL_I	wrpr	%r22, 0x003c, %pil
	.word 0x9195a12b  ! 9329: WRPR_PIL_I	wrpr	%r22, 0x012b, %pil
	.word 0xb80ce0ba  ! 9331: AND_I	and 	%r19, 0x00ba, %r28
	mov	1, %r12
	.word 0x8f932000  ! 9334: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_3_436:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_436), 16, 16)) -> intp(3, 0, 17)
	.word 0xf635a117  ! 9339: STH_I	sth	%r27, [%r22 + 0x0117]
	.word 0xfa2c610b  ! 9340: STB_I	stb	%r29, [%r17 + 0x010b]
	.word 0xfe252100  ! 9342: STW_I	stw	%r31, [%r20 + 0x0100]
	.word 0xb3500000  ! 9343: RDPR_TPC	rdpr	%tpc, %r25
	.word 0xbf504000  ! 9345: RDPR_TNPC	<illegal instruction>
	.word 0xfe74c000  ! 9347: STX_R	stx	%r31, [%r19 + %r0]
	.word 0xf6346117  ! 9349: STH_I	sth	%r27, [%r17 + 0x0117]
	.word 0xf8256142  ! 9350: STW_I	stw	%r28, [%r21 + 0x0142]
	.word 0xf13d4000  ! 9354: STDF_R	std	%f24, [%r0, %r21]
	.word 0xfe3dc000  ! 9355: STD_R	std	%r31, [%r23 + %r0]
	.word 0xff3d0000  ! 9357: STDF_R	std	%f31, [%r0, %r20]
hwintr_3_437:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_437), 16, 16)) -> intp(3, 0, 11)
	.word 0xf275606c  ! 9361: STX_I	stx	%r25, [%r21 + 0x006c]
	.word 0xfe3c0000  ! 9362: STD_R	std	%r31, [%r16 + %r0]
	.word 0xf22d8000  ! 9364: STB_R	stb	%r25, [%r22 + %r0]
	.word 0xfc250000  ! 9370: STW_R	stw	%r30, [%r20 + %r0]
	.word 0x8595a144  ! 9372: WRPR_TSTATE_I	wrpr	%r22, 0x0144, %tstate
	.word 0xb350c000  ! 9374: RDPR_TT	rdpr	%tt, %r25
	.word 0xfe3d8000  ! 9377: STD_R	std	%r31, [%r22 + %r0]
	.word 0xf03c8000  ! 9378: STD_R	std	%r24, [%r18 + %r0]
	.word 0xf4254000  ! 9381: STW_R	stw	%r26, [%r21 + %r0]
	mov	0, %r14
	.word 0xa193a000  ! 9382: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	mov	0, %r14
	.word 0xa193a000  ! 9390: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	mov	1, %r14
	.word 0xa193a000  ! 9392: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	mov	2, %r14
	.word 0xa193a000  ! 9396: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb1520000  ! 9398: RDPR_PIL	rdpr	%pil, %r24
hwintr_3_438:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_438), 16, 16)) -> intp(3, 0, 8)
	.word 0xff3c8000  ! 9408: STDF_R	std	%f31, [%r0, %r18]
	ta	T_CHANGE_HPRIV
	.word 0x81982c81  ! 9409: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c81, %hpstate
	.word 0xf53de1a2  ! 9413: STDF_I	std	%f26, [0x01a2, %r23]
hwintr_3_439:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_439), 16, 16)) -> intp(3, 0, 1d)
hwintr_3_440:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_440), 16, 16)) -> intp(3, 0, e)
	.word 0xbb518000  ! 9419: RDPR_PSTATE	rdpr	%pstate, %r29
	.word 0xb69d2141  ! 9422: XORcc_I	xorcc 	%r20, 0x0141, %r27
	.word 0x8d9560ff  ! 9423: WRPR_PSTATE_I	wrpr	%r21, 0x00ff, %pstate
	.word 0xb1480000  ! 9424: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	setx	data_start_1, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8d95a137  ! 9433: WRPR_PSTATE_I	wrpr	%r22, 0x0137, %pstate
	.word 0xb4450000  ! 9434: ADDC_R	addc 	%r20, %r0, %r26
	.word 0xbd480000  ! 9437: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xbd50c000  ! 9438: RDPR_TT	rdpr	%tt, %r30
	.word 0xf63560d3  ! 9439: STH_I	sth	%r27, [%r21 + 0x00d3]
	.word 0xf8742035  ! 9441: STX_I	stx	%r28, [%r16 + 0x0035]
hwintr_3_441:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_441), 16, 16)) -> intp(3, 0, 33)
	.word 0xba94e18c  ! 9444: ORcc_I	orcc 	%r19, 0x018c, %r29
	.word 0xf635a034  ! 9445: STH_I	sth	%r27, [%r22 + 0x0034]
	.word 0xb3510000  ! 9448: RDPR_TICK	<illegal instruction>
	.word 0xb3480000  ! 9449: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
hwintr_3_442:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_442), 16, 16)) -> intp(3, 0, 25)
	.word 0xfc35e159  ! 9460: STH_I	sth	%r30, [%r23 + 0x0159]
	.word 0xbd51c000  ! 9462: RDPR_TL	<illegal instruction>
	.word 0xbf3cc000  ! 9464: SRA_R	sra 	%r19, %r0, %r31
	.word 0xf93da07c  ! 9470: STDF_I	std	%f28, [0x007c, %r22]
	.word 0xff3d8000  ! 9473: STDF_R	std	%f31, [%r0, %r22]
	.word 0xf225c000  ! 9478: STW_R	stw	%r25, [%r23 + %r0]
	.word 0xfc340000  ! 9480: STH_R	sth	%r30, [%r16 + %r0]
	.word 0xf83da153  ! 9482: STD_I	std	%r28, [%r22 + 0x0153]
	.word 0xfa2c8000  ! 9486: STB_R	stb	%r29, [%r18 + %r0]
	.word 0xfa256126  ! 9488: STW_I	stw	%r29, [%r21 + 0x0126]
hwintr_3_443:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_443), 16, 16)) -> intp(3, 0, e)
	.word 0xfe2c6039  ! 9493: STB_I	stb	%r31, [%r17 + 0x0039]
	.word 0xbb510000  ! 9499: RDPR_TICK	<illegal instruction>
	.word 0xb53c5000  ! 9500: SRAX_R	srax	%r17, %r0, %r26
	.word 0x919420c5  ! 9501: WRPR_PIL_I	wrpr	%r16, 0x00c5, %pil
	.word 0xf8746052  ! 9502: STX_I	stx	%r28, [%r17 + 0x0052]
	.word 0xfe3da1e8  ! 9503: STD_I	std	%r31, [%r22 + 0x01e8]
	.word 0xbe15e00b  ! 9506: OR_I	or 	%r23, 0x000b, %r31
	setx	data_start_3, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	setx	data_start_1, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb0458000  ! 9511: ADDC_R	addc 	%r22, %r0, %r24
	.word 0x8195217e  ! 9515: WRPR_TPC_I	wrpr	%r20, 0x017e, %tpc
	.word 0xf22d8000  ! 9516: STB_R	stb	%r25, [%r22 + %r0]
	.word 0xfa35a141  ! 9518: STH_I	sth	%r29, [%r22 + 0x0141]
	.word 0xf93d4000  ! 9520: STDF_R	std	%f28, [%r0, %r21]
	.word 0xfa35208c  ! 9522: STH_I	sth	%r29, [%r20 + 0x008c]
	.word 0xf73c8000  ! 9524: STDF_R	std	%f27, [%r0, %r18]
hwintr_3_444:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_444), 16, 16)) -> intp(3, 0, 39)
	setx	data_start_5, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf8246072  ! 9538: STW_I	stw	%r28, [%r17 + 0x0072]
	.word 0xf8254000  ! 9540: STW_R	stw	%r28, [%r21 + %r0]
	.word 0xf42c20ab  ! 9541: STB_I	stb	%r26, [%r16 + 0x00ab]
	.word 0x89952017  ! 9542: WRPR_TICK_I	wrpr	%r20, 0x0017, %tick
hwintr_3_445:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_445), 16, 16)) -> intp(3, 0, 36)
	.word 0xf43c6037  ! 9544: STD_I	std	%r26, [%r17 + 0x0037]
	.word 0xf235e1e5  ! 9552: STH_I	sth	%r25, [%r23 + 0x01e5]
	.word 0xf03ca093  ! 9554: STD_I	std	%r24, [%r18 + 0x0093]
hwintr_3_446:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_446), 16, 16)) -> intp(3, 0, 3c)
	.word 0xb69d218e  ! 9562: XORcc_I	xorcc 	%r20, 0x018e, %r27
	.word 0xba2cc000  ! 9563: ANDN_R	andn 	%r19, %r0, %r29
	.word 0xb5508000  ! 9564: RDPR_TSTATE	rdpr	%tstate, %r26
	.word 0xf834e157  ! 9566: STH_I	sth	%r28, [%r19 + 0x0157]
	.word 0xf4748000  ! 9568: STX_R	stx	%r26, [%r18 + %r0]
	.word 0xf024c000  ! 9569: STW_R	stw	%r24, [%r19 + %r0]
	.word 0xbeb460ce  ! 9570: ORNcc_I	orncc 	%r17, 0x00ce, %r31
	.word 0xf03dc000  ! 9572: STD_R	std	%r24, [%r23 + %r0]
	.word 0xf23ca009  ! 9578: STD_I	std	%r25, [%r18 + 0x0009]
	.word 0xfe25207e  ! 9580: STW_I	stw	%r31, [%r20 + 0x007e]
	.word 0xb950c000  ! 9583: RDPR_TT	<illegal instruction>
	.word 0xf435a1a2  ! 9584: STH_I	sth	%r26, [%r22 + 0x01a2]
	.word 0xb3500000  ! 9585: RDPR_TPC	<illegal instruction>
hwintr_3_447:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_447), 16, 16)) -> intp(3, 0, 3e)
hwintr_3_448:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_448), 16, 16)) -> intp(3, 0, 14)
	.word 0xbaad6068  ! 9589: ANDNcc_I	andncc 	%r21, 0x0068, %r29
	.word 0xfe2c20b1  ! 9590: STB_I	stb	%r31, [%r16 + 0x00b1]
hwintr_3_449:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_449), 16, 16)) -> intp(3, 0, 32)
	.word 0xf6250000  ! 9592: STW_R	stw	%r27, [%r20 + %r0]
	.word 0xfe75c000  ! 9598: STX_R	stx	%r31, [%r23 + %r0]
	.word 0xf43da199  ! 9599: STD_I	std	%r26, [%r22 + 0x0199]
	.word 0xb83da0e4  ! 9601: XNOR_I	xnor 	%r22, 0x00e4, %r28
hwintr_3_450:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_450), 16, 16)) -> intp(3, 0, 36)
	setx	data_start_5, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf62de0f2  ! 9605: STB_I	stb	%r27, [%r23 + 0x00f2]
	.word 0xf82c4000  ! 9608: STB_R	stb	%r28, [%r17 + %r0]
	.word 0x8395e0f5  ! 9615: WRPR_TNPC_I	wrpr	%r23, 0x00f5, %tnpc
	.word 0xfa354000  ! 9616: STH_R	sth	%r29, [%r21 + %r0]
	.word 0x8d95e13a  ! 9620: WRPR_PSTATE_I	wrpr	%r23, 0x013a, %pstate
hwintr_3_451:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_451), 16, 16)) -> intp(3, 0, 28)
	.word 0x8794a19d  ! 9625: WRPR_TT_I	wrpr	%r18, 0x019d, %tt
	.word 0xf43d8000  ! 9627: STD_R	std	%r26, [%r22 + %r0]
	.word 0xf22ce044  ! 9630: STB_I	stb	%r25, [%r19 + 0x0044]
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xba2da00f  ! 9634: ANDN_I	andn 	%r22, 0x000f, %r29
	.word 0xf4344000  ! 9637: STH_R	sth	%r26, [%r17 + %r0]
	.word 0xf634c000  ! 9640: STH_R	sth	%r27, [%r19 + %r0]
	.word 0xf4254000  ! 9641: STW_R	stw	%r26, [%r21 + %r0]
	.word 0xb935b001  ! 9643: SRLX_I	srlx	%r22, 0x0001, %r28
	.word 0x8d94e061  ! 9644: WRPR_PSTATE_I	wrpr	%r19, 0x0061, %pstate
hwintr_3_452:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_452), 16, 16)) -> intp(3, 0, 5)
hwintr_3_453:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_453), 16, 16)) -> intp(3, 0, 2c)
	.word 0xf13d4000  ! 9651: STDF_R	std	%f24, [%r0, %r21]
	.word 0xf13de119  ! 9652: STDF_I	std	%f24, [0x0119, %r23]
	.word 0xfc2dc000  ! 9654: STB_R	stb	%r30, [%r23 + %r0]
	.word 0xf034a0a3  ! 9655: STH_I	sth	%r24, [%r18 + 0x00a3]
hwintr_3_454:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_454), 16, 16)) -> intp(3, 0, 28)
	.word 0xf73c4000  ! 9661: STDF_R	std	%f27, [%r0, %r17]
hwintr_3_455:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_455), 16, 16)) -> intp(3, 0, 2a)
	.word 0x8d9421a5  ! 9665: WRPR_PSTATE_I	wrpr	%r16, 0x01a5, %pstate
	.word 0xb150c000  ! 9667: RDPR_TT	rdpr	%tt, %r24
	.word 0xfe254000  ! 9673: STW_R	stw	%r31, [%r21 + %r0]
	mov	0, %r14
	.word 0xa193a000  ! 9678: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf83c4000  ! 9679: STD_R	std	%r28, [%r17 + %r0]
	.word 0xb4158000  ! 9680: OR_R	or 	%r22, %r0, %r26
	.word 0xb5356001  ! 9681: SRL_I	srl 	%r21, 0x0001, %r26
hwintr_3_456:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_456), 16, 16)) -> intp(3, 0, 14)
	.word 0xfa356072  ! 9686: STH_I	sth	%r29, [%r21 + 0x0072]
	mov	1, %r14
	.word 0xa193a000  ! 9689: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8594e06c  ! 9691: WRPR_TSTATE_I	wrpr	%r19, 0x006c, %tstate
	.word 0xfa2ce06d  ! 9694: STB_I	stb	%r29, [%r19 + 0x006d]
	.word 0xbf50c000  ! 9695: RDPR_TT	rdpr	%tt, %r31
	.word 0xfa2cc000  ! 9697: STB_R	stb	%r29, [%r19 + %r0]
	.word 0xf6752088  ! 9699: STX_I	stx	%r27, [%r20 + 0x0088]
	.word 0xf03de1e9  ! 9702: STD_I	std	%r24, [%r23 + 0x01e9]
hwintr_3_457:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_457), 16, 16)) -> intp(3, 0, 25)
	.word 0xf035617e  ! 9704: STH_I	sth	%r24, [%r21 + 0x017e]
hwintr_3_458:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_458), 16, 16)) -> intp(3, 0, 21)
	.word 0xf93de033  ! 9711: STDF_I	std	%f28, [0x0033, %r23]
	.word 0x8594a137  ! 9720: WRPR_TSTATE_I	wrpr	%r18, 0x0137, %tstate
	.word 0xb415c000  ! 9722: OR_R	or 	%r23, %r0, %r26
	mov	0, %r14
	.word 0xa193a000  ! 9725: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf23d8000  ! 9727: STD_R	std	%r25, [%r22 + %r0]
	.word 0xf82da171  ! 9728: STB_I	stb	%r28, [%r22 + 0x0171]
	.word 0xba1c0000  ! 9730: XOR_R	xor 	%r16, %r0, %r29
	.word 0xfe354000  ! 9731: STH_R	sth	%r31, [%r21 + %r0]
	.word 0xbf508000  ! 9733: RDPR_TSTATE	rdpr	%tstate, %r31
	.word 0xf2348000  ! 9738: STH_R	sth	%r25, [%r18 + %r0]
	.word 0x85952131  ! 9739: WRPR_TSTATE_I	wrpr	%r20, 0x0131, %tstate
	.word 0x8594e0b6  ! 9740: WRPR_TSTATE_I	wrpr	%r19, 0x00b6, %tstate
	.word 0x8995e138  ! 9742: WRPR_TICK_I	wrpr	%r23, 0x0138, %tick
	setx	data_start_7, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa340000  ! 9744: STH_R	sth	%r29, [%r16 + %r0]
	.word 0xfc25a08e  ! 9747: STW_I	stw	%r30, [%r22 + 0x008e]
hwintr_3_459:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_459), 16, 16)) -> intp(3, 0, 35)
	.word 0xb6154000  ! 9751: OR_R	or 	%r21, %r0, %r27
	.word 0xbe2c2038  ! 9752: ANDN_I	andn 	%r16, 0x0038, %r31
	.word 0xfa3d0000  ! 9754: STD_R	std	%r29, [%r20 + %r0]
	.word 0xfc24c000  ! 9756: STW_R	stw	%r30, [%r19 + %r0]
	mov	2, %r12
	.word 0x8f932000  ! 9758: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfa35c000  ! 9761: STH_R	sth	%r29, [%r23 + %r0]
	.word 0xf02c4000  ! 9762: STB_R	stb	%r24, [%r17 + %r0]
	.word 0xf2358000  ! 9764: STH_R	sth	%r25, [%r22 + %r0]
	ta	T_CHANGE_HPRIV
	.word 0x819839d1  ! 9766: WRHPR_HPSTATE_I	wrhpr	%r0, 0x19d1, %hpstate
	.word 0xfc25a0e7  ! 9767: STW_I	stw	%r30, [%r22 + 0x00e7]
	mov	0, %r14
	.word 0xa193a000  ! 9773: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb63d20db  ! 9776: XNOR_I	xnor 	%r20, 0x00db, %r27
	.word 0xf8250000  ! 9786: STW_R	stw	%r28, [%r20 + %r0]
hwintr_3_460:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_460), 16, 16)) -> intp(3, 0, 7)
	.word 0xf83cc000  ! 9792: STD_R	std	%r28, [%r19 + %r0]
	.word 0x9195a005  ! 9796: WRPR_PIL_I	wrpr	%r22, 0x0005, %pil
	.word 0xf4744000  ! 9797: STX_R	stx	%r26, [%r17 + %r0]
	.word 0xb951c000  ! 9801: RDPR_TL	rdpr	%tl, %r28
	.word 0xfc2ce02b  ! 9802: STB_I	stb	%r30, [%r19 + 0x002b]
	.word 0xf034217e  ! 9805: STH_I	sth	%r24, [%r16 + 0x017e]
	.word 0x8d94a016  ! 9808: WRPR_PSTATE_I	wrpr	%r18, 0x0016, %pstate
	.word 0xb4040000  ! 9809: ADD_R	add 	%r16, %r0, %r26
	.word 0xf435c000  ! 9810: STH_R	sth	%r26, [%r23 + %r0]
	.word 0xf13d0000  ! 9813: STDF_R	std	%f24, [%r0, %r20]
	.word 0xfa2de02a  ! 9820: STB_I	stb	%r29, [%r23 + 0x002a]
hwintr_3_461:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_461), 16, 16)) -> intp(3, 0, 1a)
	.word 0xfd3d4000  ! 9823: STDF_R	std	%f30, [%r0, %r21]
hwintr_3_462:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_462), 16, 16)) -> intp(3, 0, a)
	ta	T_CHANGE_HPRIV
	.word 0x8198291b  ! 9838: WRHPR_HPSTATE_I	wrhpr	%r0, 0x091b, %hpstate
	.word 0xb0a54000  ! 9840: SUBcc_R	subcc 	%r21, %r0, %r24
	.word 0xf024c000  ! 9841: STW_R	stw	%r24, [%r19 + %r0]
	.word 0xf23d4000  ! 9843: STD_R	std	%r25, [%r21 + %r0]
	.word 0xf33da0a9  ! 9845: STDF_I	std	%f25, [0x00a9, %r22]
	.word 0xb81da1e9  ! 9847: XOR_I	xor 	%r22, 0x01e9, %r28
	.word 0x8794210d  ! 9848: WRPR_TT_I	wrpr	%r16, 0x010d, %tt
	.word 0xb3520000  ! 9849: RDPR_PIL	rdpr	%pil, %r25
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xfc3d61df  ! 9854: STD_I	std	%r30, [%r21 + 0x01df]
	.word 0xf62dc000  ! 9856: STB_R	stb	%r27, [%r23 + %r0]
	.word 0xf73d60b3  ! 9858: STDF_I	std	%f27, [0x00b3, %r21]
	.word 0xff3d211e  ! 9859: STDF_I	std	%f31, [0x011e, %r20]
	.word 0xfc3cc000  ! 9860: STD_R	std	%r30, [%r19 + %r0]
	.word 0xf22561be  ! 9862: STW_I	stw	%r25, [%r21 + 0x01be]
	.word 0x8394e0ec  ! 9863: WRPR_TNPC_I	wrpr	%r19, 0x00ec, %tnpc
	.word 0xf82d8000  ! 9864: STB_R	stb	%r28, [%r22 + %r0]
	.word 0xf83ca194  ! 9865: STD_I	std	%r28, [%r18 + 0x0194]
hwintr_3_463:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_463), 16, 16)) -> intp(3, 0, 3f)
hwintr_3_464:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_464), 16, 16)) -> intp(3, 0, 11)
	.word 0x8395e0ae  ! 9883: WRPR_TNPC_I	wrpr	%r23, 0x00ae, %tnpc
	.word 0xf93c2067  ! 9886: STDF_I	std	%f28, [0x0067, %r16]
	.word 0xbc34e0bd  ! 9889: ORN_I	orn 	%r19, 0x00bd, %r30
	.word 0xf8744000  ! 9891: STX_R	stx	%r28, [%r17 + %r0]
	setx	data_start_4, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8d94a1b1  ! 9894: WRPR_PSTATE_I	wrpr	%r18, 0x01b1, %pstate
	setx	data_start_0, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_3_465:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_465), 16, 16)) -> intp(3, 0, 16)
	.word 0xb4b5215a  ! 9899: ORNcc_I	orncc 	%r20, 0x015a, %r26
	.word 0xfc2c4000  ! 9902: STB_R	stb	%r30, [%r17 + %r0]
hwintr_3_466:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_466), 16, 16)) -> intp(3, 0, 2b)
	.word 0xfe3c4000  ! 9907: STD_R	std	%r31, [%r17 + %r0]
	.word 0xb2848000  ! 9909: ADDcc_R	addcc 	%r18, %r0, %r25
	.word 0xf43460a3  ! 9914: STH_I	sth	%r26, [%r17 + 0x00a3]
	.word 0xf62dc000  ! 9916: STB_R	stb	%r27, [%r23 + %r0]
	.word 0xba25e186  ! 9917: SUB_I	sub 	%r23, 0x0186, %r29
hwintr_3_467:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_467), 16, 16)) -> intp(3, 0, 9)
	.word 0xfc24218a  ! 9921: STW_I	stw	%r30, [%r16 + 0x018a]
	.word 0xb3480000  ! 9924: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xb150c000  ! 9925: RDPR_TT	rdpr	%tt, %r24
	mov	1, %r14
	.word 0xa193a000  ! 9934: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfc24e193  ! 9939: STW_I	stw	%r30, [%r19 + 0x0193]
	.word 0xf8358000  ! 9940: STH_R	sth	%r28, [%r22 + %r0]
	.word 0xb2b46142  ! 9941: SUBCcc_I	orncc 	%r17, 0x0142, %r25
hwintr_3_468:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_468), 16, 16)) -> intp(3, 0, 39)
	setx	data_start_1, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf02ce15f  ! 9945: STB_I	stb	%r24, [%r19 + 0x015f]
hwintr_3_469:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_469), 16, 16)) -> intp(3, 0, 27)
	.word 0xfe250000  ! 9949: STW_R	stw	%r31, [%r20 + %r0]
	.word 0xfb3c4000  ! 9951: STDF_R	std	%f29, [%r0, %r17]
	.word 0xbf504000  ! 9952: RDPR_TNPC	rdpr	%tnpc, %r31
	.word 0xff3de04f  ! 9956: STDF_I	std	%f31, [0x004f, %r23]
	.word 0xf22521a3  ! 9959: STW_I	stw	%r25, [%r20 + 0x01a3]
	.word 0xf875a103  ! 9960: STX_I	stx	%r28, [%r22 + 0x0103]
	.word 0xf82c0000  ! 9961: STB_R	stb	%r28, [%r16 + %r0]
	.word 0xfc354000  ! 9964: STH_R	sth	%r30, [%r21 + %r0]
	.word 0xff3d8000  ! 9967: STDF_R	std	%f31, [%r0, %r22]
	.word 0x8d94a0ba  ! 9968: WRPR_PSTATE_I	wrpr	%r18, 0x00ba, %pstate
	.word 0xf2758000  ! 9970: STX_R	stx	%r25, [%r22 + %r0]
hwintr_3_470:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_470), 16, 16)) -> intp(3, 0, 26)
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xfb3de099  ! 9987: STDF_I	std	%f29, [0x0099, %r23]
	.word 0xb4c48000  ! 9990: ADDCcc_R	addccc 	%r18, %r0, %r26
hwintr_3_471:
!$EV trig_pc_d(3,expr(@VA(.MAIN.hwintr_3_471), 16, 16)) -> intp(3, 0, 18)
	.word 0xf03dc000  ! 9994: STD_R	std	%r24, [%r23 + %r0]
	.word 0xf8340000  ! 9997: STH_R	sth	%r28, [%r16 + %r0]
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_2:
	setx	data_start_0, %g1, %r16
	setx	data_start_1, %g1, %r17
	setx	data_start_2, %g1, %r18
	setx	data_start_3, %g1, %r19
	setx	data_start_4, %g1, %r20
	setx	data_start_5, %g1, %r21
	setx	data_start_6, %g1, %r22
	setx	data_start_7, %g1, %r23
	.word 0xfa04a031  ! 1: LDUW_I	lduw	[%r18 + 0x0031], %r29
	.word 0x8994e062  ! 4: WRPR_TICK_I	wrpr	%r19, 0x0062, %tick
hwintr_2_0:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_0), 16, 16)) -> intp(2, 0, 17)
	.word 0xf84c0000  ! 8: LDSB_R	ldsb	[%r16 + %r0], %r28
	.word 0xf60d600f  ! 10: LDUB_I	ldub	[%r21 + 0x000f], %r27
	.word 0xfa5d60a1  ! 13: LDX_I	ldx	[%r21 + 0x00a1], %r29
	.word 0xf64ce0b0  ! 14: LDSB_I	ldsb	[%r19 + 0x00b0], %r27
	.word 0x9195e0b9  ! 19: WRPR_PIL_I	wrpr	%r23, 0x00b9, %pil
	.word 0x919421bf  ! 20: WRPR_PIL_I	wrpr	%r16, 0x01bf, %pil
	.word 0xfa556195  ! 25: LDSH_I	ldsh	[%r21 + 0x0195], %r29
	.word 0xfc5420f7  ! 26: LDSH_I	ldsh	[%r16 + 0x00f7], %r30
hwintr_2_1:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_1), 16, 16)) -> intp(2, 0, 2b)
	.word 0xfb1c4000  ! 28: LDDF_R	ldd	[%r17, %r0], %f29
hwintr_2_2:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_2), 16, 16)) -> intp(2, 0, 26)
	.word 0xf244c000  ! 33: LDSW_R	ldsw	[%r19 + %r0], %r25
	.word 0xb3518000  ! 35: RDPR_PSTATE	<illegal instruction>
	.word 0xbb520000  ! 36: RDPR_PIL	<illegal instruction>
	.word 0xf44de1bc  ! 38: LDSB_I	ldsb	[%r23 + 0x01bc], %r26
	.word 0xbe1c8000  ! 39: XOR_R	xor 	%r18, %r0, %r31
	.word 0xf80c8000  ! 40: LDUB_R	ldub	[%r18 + %r0], %r28
	.word 0xb83d0000  ! 41: XNOR_R	xnor 	%r20, %r0, %r28
	.word 0xfc444000  ! 48: LDSW_R	ldsw	[%r17 + %r0], %r30
	.word 0x8395a1a2  ! 50: WRPR_TNPC_I	wrpr	%r22, 0x01a2, %tnpc
	.word 0xfc1c0000  ! 56: LDD_R	ldd	[%r16 + %r0], %r30
	.word 0xfa4de0fa  ! 61: LDSB_I	ldsb	[%r23 + 0x00fa], %r29
	.word 0xf014614f  ! 68: LDUH_I	lduh	[%r17 + 0x014f], %r24
	setx	data_start_2, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb00421c8  ! 76: ADD_I	add 	%r16, 0x01c8, %r24
hwintr_2_3:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_3), 16, 16)) -> intp(2, 0, 3b)
	.word 0xbd641800  ! 80: MOVcc_R	<illegal instruction>
	.word 0xf21cc000  ! 83: LDD_R	ldd	[%r19 + %r0], %r25
	.word 0xff1de1aa  ! 90: LDDF_I	ldd	[%r23, 0x01aa], %f31
	.word 0xfc44a195  ! 93: LDSW_I	ldsw	[%r18 + 0x0195], %r30
	.word 0xf91d4000  ! 96: LDDF_R	ldd	[%r21, %r0], %f28
	.word 0x899520a6  ! 98: WRPR_TICK_I	wrpr	%r20, 0x00a6, %tick
	.word 0xb151c000  ! 102: RDPR_TL	<illegal instruction>
	.word 0xf8556129  ! 105: LDSH_I	ldsh	[%r21 + 0x0129], %r28
	.word 0xbb50c000  ! 106: RDPR_TT	<illegal instruction>
	.word 0xbb510000  ! 112: RDPR_TICK	<illegal instruction>
	.word 0xf2150000  ! 115: LDUH_R	lduh	[%r20 + %r0], %r25
	.word 0xf05d4000  ! 118: LDX_R	ldx	[%r21 + %r0], %r24
hwintr_2_4:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_4), 16, 16)) -> intp(2, 0, 5)
	.word 0xf45ca1db  ! 120: LDX_I	ldx	[%r18 + 0x01db], %r26
	.word 0xf85ca126  ! 122: LDX_I	ldx	[%r18 + 0x0126], %r28
	.word 0x8594e076  ! 123: WRPR_TSTATE_I	wrpr	%r19, 0x0076, %tstate
	.word 0xb63d4000  ! 125: XNOR_R	xnor 	%r21, %r0, %r27
	.word 0xb2456046  ! 126: ADDC_I	addc 	%r21, 0x0046, %r25
	mov	2, %r12
	.word 0x8f932000  ! 130: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_2_5:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_5), 16, 16)) -> intp(2, 0, c)
	.word 0xf00ca1fb  ! 132: LDUB_I	ldub	[%r18 + 0x01fb], %r24
	.word 0xfc0d610b  ! 134: LDUB_I	ldub	[%r21 + 0x010b], %r30
	.word 0xbabda0dd  ! 136: XNORcc_I	xnorcc 	%r22, 0x00dd, %r29
	.word 0xf61de026  ! 140: LDD_I	ldd	[%r23 + 0x0026], %r27
	.word 0x8795a07c  ! 141: WRPR_TT_I	wrpr	%r22, 0x007c, %tt
	.word 0xb49d20eb  ! 143: XORcc_I	xorcc 	%r20, 0x00eb, %r26
	.word 0xf644a006  ! 144: LDSW_I	ldsw	[%r18 + 0x0006], %r27
	.word 0xf11d61fd  ! 145: LDDF_I	ldd	[%r21, 0x01fd], %f24
	.word 0xbcc50000  ! 146: ADDCcc_R	addccc 	%r20, %r0, %r30
	.word 0xf814e1e6  ! 148: LDUH_I	lduh	[%r19 + 0x01e6], %r28
	.word 0xf60c0000  ! 150: LDUB_R	ldub	[%r16 + %r0], %r27
	.word 0xf6050000  ! 159: LDUW_R	lduw	[%r20 + %r0], %r27
	.word 0xf4148000  ! 161: LDUH_R	lduh	[%r18 + %r0], %r26
	.word 0xb4356171  ! 162: SUBC_I	orn 	%r21, 0x0171, %r26
	.word 0x8794a1c2  ! 163: WRPR_TT_I	wrpr	%r18, 0x01c2, %tt
	.word 0xf25c4000  ! 165: LDX_R	ldx	[%r17 + %r0], %r25
	.word 0xf6440000  ! 166: LDSW_R	ldsw	[%r16 + %r0], %r27
	.word 0xbabcc000  ! 169: XNORcc_R	xnorcc 	%r19, %r0, %r29
	.word 0xba35a005  ! 170: ORN_I	orn 	%r22, 0x0005, %r29
	.word 0xf414e1e2  ! 171: LDUH_I	lduh	[%r19 + 0x01e2], %r26
	.word 0xb3510000  ! 172: RDPR_TICK	<illegal instruction>
	.word 0xb3500000  ! 174: RDPR_TPC	<illegal instruction>
	.word 0xb2240000  ! 175: SUB_R	sub 	%r16, %r0, %r25
	.word 0x819561e8  ! 180: WRPR_TPC_I	wrpr	%r21, 0x01e8, %tpc
hwintr_2_6:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_6), 16, 16)) -> intp(2, 0, 1)
	.word 0xf0440000  ! 186: LDSW_R	ldsw	[%r16 + %r0], %r24
	.word 0xf81d8000  ! 190: LDD_R	ldd	[%r22 + %r0], %r28
	.word 0xf4554000  ! 193: LDSH_R	ldsh	[%r21 + %r0], %r26
hwintr_2_7:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_7), 16, 16)) -> intp(2, 0, 1f)
	.word 0xfe5ce065  ! 202: LDX_I	ldx	[%r19 + 0x0065], %r31
	.word 0xf414619e  ! 203: LDUH_I	lduh	[%r17 + 0x019e], %r26
	.word 0xf8546060  ! 204: LDSH_I	ldsh	[%r17 + 0x0060], %r28
	.word 0xfc15608d  ! 207: LDUH_I	lduh	[%r21 + 0x008d], %r30
hwintr_2_8:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_8), 16, 16)) -> intp(2, 0, e)
	.word 0xbb3c0000  ! 211: SRA_R	sra 	%r16, %r0, %r29
	.word 0xf655614c  ! 212: LDSH_I	ldsh	[%r21 + 0x014c], %r27
	.word 0x8595e03a  ! 215: WRPR_TSTATE_I	wrpr	%r23, 0x003a, %tstate
	.word 0xfc548000  ! 216: LDSH_R	ldsh	[%r18 + %r0], %r30
	.word 0x81952152  ! 221: WRPR_TPC_I	wrpr	%r20, 0x0152, %tpc
hwintr_2_9:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_9), 16, 16)) -> intp(2, 0, 14)
	.word 0xbb50c000  ! 229: RDPR_TT	<illegal instruction>
hwintr_2_10:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_10), 16, 16)) -> intp(2, 0, 27)
	.word 0xf00c4000  ! 234: LDUB_R	ldub	[%r17 + %r0], %r24
	.word 0xf80460ce  ! 235: LDUW_I	lduw	[%r17 + 0x00ce], %r28
	.word 0xb3508000  ! 238: RDPR_TSTATE	<illegal instruction>
	.word 0xfc446096  ! 239: LDSW_I	ldsw	[%r17 + 0x0096], %r30
hwintr_2_11:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_11), 16, 16)) -> intp(2, 0, 3e)
	.word 0xf64460cc  ! 251: LDSW_I	ldsw	[%r17 + 0x00cc], %r27
	.word 0xf84561a4  ! 252: LDSW_I	ldsw	[%r21 + 0x01a4], %r28
	mov	0, %r14
	.word 0xa193a000  ! 254: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x87956051  ! 256: WRPR_TT_I	wrpr	%r21, 0x0051, %tt
	mov	0, %r14
	.word 0xa193a000  ! 257: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf71da0ed  ! 258: LDDF_I	ldd	[%r22, 0x00ed], %f27
hwintr_2_12:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_12), 16, 16)) -> intp(2, 0, 32)
hwintr_2_13:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_13), 16, 16)) -> intp(2, 0, 3c)
	.word 0x87956091  ! 266: WRPR_TT_I	wrpr	%r21, 0x0091, %tt
	.word 0xf45c8000  ! 267: LDX_R	ldx	[%r18 + %r0], %r26
	setx	data_start_7, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb350c000  ! 270: RDPR_TT	rdpr	%tt, %r25
	.word 0x8195a125  ! 272: WRPR_TPC_I	wrpr	%r22, 0x0125, %tpc
	.word 0xfe5cc000  ! 275: LDX_R	ldx	[%r19 + %r0], %r31
	.word 0xb3500000  ! 280: RDPR_TPC	<illegal instruction>
	.word 0xf20c8000  ! 283: LDUB_R	ldub	[%r18 + %r0], %r25
	.word 0xf4144000  ! 286: LDUH_R	lduh	[%r17 + %r0], %r26
	mov	1, %r14
	.word 0xa193a000  ! 287: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfc05e0c6  ! 292: LDUW_I	lduw	[%r23 + 0x00c6], %r30
	.word 0xf8442069  ! 294: LDSW_I	ldsw	[%r16 + 0x0069], %r28
	ta	T_CHANGE_HPRIV
	.word 0x81983f5b  ! 295: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f5b, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81983d83  ! 299: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d83, %hpstate
	.word 0xfc5d604d  ! 300: LDX_I	ldx	[%r21 + 0x004d], %r30
	.word 0xbc148000  ! 301: OR_R	or 	%r18, %r0, %r30
	.word 0xf2554000  ! 302: LDSH_R	ldsh	[%r21 + %r0], %r25
	.word 0xba0ce1f8  ! 304: AND_I	and 	%r19, 0x01f8, %r29
	.word 0xbf51c000  ! 305: RDPR_TL	<illegal instruction>
	.word 0xb9510000  ! 306: RDPR_TICK	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81983f93  ! 309: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f93, %hpstate
	.word 0xfc0d8000  ! 310: LDUB_R	ldub	[%r22 + %r0], %r30
	.word 0xf8540000  ! 313: LDSH_R	ldsh	[%r16 + %r0], %r28
	.word 0xb1500000  ! 315: RDPR_TPC	<illegal instruction>
	.word 0xb6b54000  ! 316: ORNcc_R	orncc 	%r21, %r0, %r27
	.word 0xfc1d4000  ! 317: LDD_R	ldd	[%r21 + %r0], %r30
	.word 0xb951c000  ! 320: RDPR_TL	<illegal instruction>
	.word 0xb0444000  ! 321: ADDC_R	addc 	%r17, %r0, %r24
	.word 0x819561d0  ! 325: WRPR_TPC_I	wrpr	%r21, 0x01d0, %tpc
	.word 0xf244e1f8  ! 326: LDSW_I	ldsw	[%r19 + 0x01f8], %r25
hwintr_2_14:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_14), 16, 16)) -> intp(2, 0, 1f)
hwintr_2_15:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_15), 16, 16)) -> intp(2, 0, 32)
	.word 0xb41c2077  ! 342: XOR_I	xor 	%r16, 0x0077, %r26
	.word 0xf45dc000  ! 343: LDX_R	ldx	[%r23 + %r0], %r26
	.word 0xf854e058  ! 344: LDSH_I	ldsh	[%r19 + 0x0058], %r28
	.word 0xfa1d0000  ! 346: LDD_R	ldd	[%r20 + %r0], %r29
	.word 0xfd1da074  ! 350: LDDF_I	ldd	[%r22, 0x0074], %f30
	.word 0xbd51c000  ! 353: RDPR_TL	rdpr	%tl, %r30
	.word 0xba1421c6  ! 354: OR_I	or 	%r16, 0x01c6, %r29
	.word 0xb20d60b1  ! 359: AND_I	and 	%r21, 0x00b1, %r25
hwintr_2_16:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_16), 16, 16)) -> intp(2, 0, f)
	.word 0x8d946007  ! 364: WRPR_PSTATE_I	wrpr	%r17, 0x0007, %pstate
	.word 0xfe44e19c  ! 366: LDSW_I	ldsw	[%r19 + 0x019c], %r31
	.word 0xb97c8400  ! 370: MOVR_R	movre	%r18, %r0, %r28
	.word 0xf205203d  ! 373: LDUW_I	lduw	[%r20 + 0x003d], %r25
	.word 0xfa458000  ! 376: LDSW_R	ldsw	[%r22 + %r0], %r29
	setx	data_start_0, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf0044000  ! 382: LDUW_R	lduw	[%r17 + %r0], %r24
	.word 0xbb518000  ! 384: RDPR_PSTATE	<illegal instruction>
	.word 0xb351c000  ! 391: RDPR_TL	<illegal instruction>
	.word 0xf2044000  ! 399: LDUW_R	lduw	[%r17 + %r0], %r25
	.word 0xf8540000  ! 401: LDSH_R	ldsh	[%r16 + %r0], %r28
	.word 0xb92d0000  ! 405: SLL_R	sll 	%r20, %r0, %r28
	.word 0xf055a044  ! 408: LDSH_I	ldsh	[%r22 + 0x0044], %r24
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xf11d605f  ! 412: LDDF_I	ldd	[%r21, 0x005f], %f24
	.word 0xf014e0f3  ! 414: LDUH_I	lduh	[%r19 + 0x00f3], %r24
	.word 0xf80d0000  ! 416: LDUB_R	ldub	[%r20 + %r0], %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982949  ! 418: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0949, %hpstate
	.word 0x8594610c  ! 419: WRPR_TSTATE_I	wrpr	%r17, 0x010c, %tstate
	.word 0xfe554000  ! 420: LDSH_R	ldsh	[%r21 + %r0], %r31
	.word 0xf21c2131  ! 422: LDD_I	ldd	[%r16 + 0x0131], %r25
	.word 0x859521b0  ! 429: WRPR_TSTATE_I	wrpr	%r20, 0x01b0, %tstate
	.word 0xf05ce1fb  ! 430: LDX_I	ldx	[%r19 + 0x01fb], %r24
	.word 0xf815208b  ! 431: LDUH_I	lduh	[%r20 + 0x008b], %r28
	.word 0xf11d0000  ! 435: LDDF_R	ldd	[%r20, %r0], %f24
	.word 0xb5510000  ! 436: RDPR_TICK	<illegal instruction>
	.word 0xb4250000  ! 440: SUB_R	sub 	%r20, %r0, %r26
	.word 0xf6050000  ! 441: LDUW_R	lduw	[%r20 + %r0], %r27
	.word 0xf71ca0dc  ! 442: LDDF_I	ldd	[%r18, 0x00dc], %f27
	mov	0, %r12
	.word 0x8f932000  ! 450: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbd7d4400  ! 451: MOVR_R	movre	%r21, %r0, %r30
	.word 0xf85c4000  ! 452: LDX_R	ldx	[%r17 + %r0], %r28
	.word 0xf244c000  ! 455: LDSW_R	ldsw	[%r19 + %r0], %r25
	.word 0xf31da146  ! 456: LDDF_I	ldd	[%r22, 0x0146], %f25
	.word 0xb9510000  ! 458: RDPR_TICK	<illegal instruction>
	.word 0xf11dc000  ! 463: LDDF_R	ldd	[%r23, %r0], %f24
	.word 0xfd1d8000  ! 464: LDDF_R	ldd	[%r22, %r0], %f30
	.word 0xb750c000  ! 468: RDPR_TT	<illegal instruction>
	.word 0xf01d6065  ! 470: LDD_I	ldd	[%r21 + 0x0065], %r24
	.word 0xf40de041  ! 472: LDUB_I	ldub	[%r23 + 0x0041], %r26
	.word 0xf20d6186  ! 475: LDUB_I	ldub	[%r21 + 0x0186], %r25
	.word 0xb1520000  ! 481: RDPR_PIL	<illegal instruction>
	.word 0xb8b5c000  ! 482: SUBCcc_R	orncc 	%r23, %r0, %r28
	.word 0xf81dc000  ! 484: LDD_R	ldd	[%r23 + %r0], %r28
	.word 0xb351c000  ! 487: RDPR_TL	<illegal instruction>
	.word 0xf444c000  ! 489: LDSW_R	ldsw	[%r19 + %r0], %r26
	.word 0xfe15c000  ! 492: LDUH_R	lduh	[%r23 + %r0], %r31
	ta	T_CHANGE_HPRIV
	.word 0x81982c99  ! 494: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c99, %hpstate
	.word 0xfe55e0a7  ! 495: LDSH_I	ldsh	[%r23 + 0x00a7], %r31
	.word 0xbf480000  ! 496: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xfe158000  ! 498: LDUH_R	lduh	[%r22 + %r0], %r31
	.word 0xb5500000  ! 505: RDPR_TPC	rdpr	%tpc, %r26
	.word 0xf91d0000  ! 506: LDDF_R	ldd	[%r20, %r0], %f28
	.word 0xf404613e  ! 508: LDUW_I	lduw	[%r17 + 0x013e], %r26
	.word 0xf21ca061  ! 510: LDD_I	ldd	[%r18 + 0x0061], %r25
	setx	data_start_2, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf00de18c  ! 512: LDUB_I	ldub	[%r23 + 0x018c], %r24
	.word 0xb7518000  ! 513: RDPR_PSTATE	<illegal instruction>
	.word 0xf65d0000  ! 515: LDX_R	ldx	[%r20 + %r0], %r27
	.word 0xf6140000  ! 519: LDUH_R	lduh	[%r16 + %r0], %r27
	.word 0xf65cc000  ! 520: LDX_R	ldx	[%r19 + %r0], %r27
	.word 0xb350c000  ! 524: RDPR_TT	<illegal instruction>
	.word 0xbf540000  ! 527: RDPR_GL	<illegal instruction>
	.word 0x8595e19b  ! 530: WRPR_TSTATE_I	wrpr	%r23, 0x019b, %tstate
	.word 0xbb7cc400  ! 531: MOVR_R	movre	%r19, %r0, %r29
	.word 0xb3480000  ! 532: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xf25d0000  ! 534: LDX_R	ldx	[%r20 + %r0], %r25
	.word 0xf80da0f9  ! 535: LDUB_I	ldub	[%r22 + 0x00f9], %r28
	.word 0xb0ac8000  ! 536: ANDNcc_R	andncc 	%r18, %r0, %r24
hwintr_2_17:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_17), 16, 16)) -> intp(2, 0, 3c)
	.word 0xb08ce1a4  ! 538: ANDcc_I	andcc 	%r19, 0x01a4, %r24
	.word 0xf0058000  ! 539: LDUW_R	lduw	[%r22 + %r0], %r24
hwintr_2_18:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_18), 16, 16)) -> intp(2, 0, 2b)
	.word 0xb750c000  ! 548: RDPR_TT	<illegal instruction>
	.word 0xb551c000  ! 549: RDPR_TL	<illegal instruction>
	.word 0xbd2da001  ! 550: SLL_I	sll 	%r22, 0x0001, %r30
	.word 0xfa4c21f6  ! 552: LDSB_I	ldsb	[%r16 + 0x01f6], %r29
	.word 0xf25de12b  ! 555: LDX_I	ldx	[%r23 + 0x012b], %r25
	.word 0xb5540000  ! 559: RDPR_GL	<illegal instruction>
	.word 0xb6240000  ! 561: SUB_R	sub 	%r16, %r0, %r27
	.word 0xbb508000  ! 564: RDPR_TSTATE	<illegal instruction>
	.word 0x9194e11f  ! 565: WRPR_PIL_I	wrpr	%r19, 0x011f, %pil
	ta	T_CHANGE_HPRIV
	.word 0x81982dc3  ! 567: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dc3, %hpstate
	.word 0xf0154000  ! 570: LDUH_R	lduh	[%r21 + %r0], %r24
	.word 0xf00dc000  ! 572: LDUB_R	ldub	[%r23 + %r0], %r24
	.word 0xf645a1d1  ! 574: LDSW_I	ldsw	[%r22 + 0x01d1], %r27
	.word 0xf80c0000  ! 579: LDUB_R	ldub	[%r16 + %r0], %r28
hwintr_2_19:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_19), 16, 16)) -> intp(2, 0, 8)
	.word 0xf614c000  ! 582: LDUH_R	lduh	[%r19 + %r0], %r27
	.word 0xfe0d0000  ! 586: LDUB_R	ldub	[%r20 + %r0], %r31
	.word 0xf40ce177  ! 587: LDUB_I	ldub	[%r19 + 0x0177], %r26
	mov	1, %r14
	.word 0xa193a000  ! 594: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_2_20:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_20), 16, 16)) -> intp(2, 0, 2e)
hwintr_2_21:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_21), 16, 16)) -> intp(2, 0, 3d)
hwintr_2_22:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_22), 16, 16)) -> intp(2, 0, 24)
	.word 0xb5520000  ! 605: RDPR_PIL	<illegal instruction>
	.word 0xf91ca1bf  ! 606: LDDF_I	ldd	[%r18, 0x01bf], %f28
	.word 0x8995e168  ! 608: WRPR_TICK_I	wrpr	%r23, 0x0168, %tick
	.word 0xb0448000  ! 609: ADDC_R	addc 	%r18, %r0, %r24
hwintr_2_23:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_23), 16, 16)) -> intp(2, 0, 9)
	.word 0xb01de1bb  ! 614: XOR_I	xor 	%r23, 0x01bb, %r24
	.word 0xf205a104  ! 616: LDUW_I	lduw	[%r22 + 0x0104], %r25
	mov	1, %r12
	.word 0x8f932000  ! 620: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfe5ce0fa  ! 625: LDX_I	ldx	[%r19 + 0x00fa], %r31
	.word 0xf81ce0df  ! 626: LDD_I	ldd	[%r19 + 0x00df], %r28
	.word 0xba040000  ! 631: ADD_R	add 	%r16, %r0, %r29
	.word 0xb62c60e0  ! 633: ANDN_I	andn 	%r17, 0x00e0, %r27
	.word 0x8d9420b4  ! 634: WRPR_PSTATE_I	wrpr	%r16, 0x00b4, %pstate
	ta	T_CHANGE_HPRIV
	.word 0x81982f03  ! 635: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f03, %hpstate
	.word 0xf8450000  ! 639: LDSW_R	ldsw	[%r20 + %r0], %r28
	.word 0xf445a1f1  ! 643: LDSW_I	ldsw	[%r22 + 0x01f1], %r26
	mov	1, %r14
	.word 0xa193a000  ! 645: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8395a102  ! 646: WRPR_TNPC_I	wrpr	%r22, 0x0102, %tnpc
	.word 0xf51c2116  ! 647: LDDF_I	ldd	[%r16, 0x0116], %f26
	.word 0xb6ac4000  ! 648: ANDNcc_R	andncc 	%r17, %r0, %r27
	.word 0xfc14c000  ! 661: LDUH_R	lduh	[%r19 + %r0], %r30
	.word 0xf615e149  ! 667: LDUH_I	lduh	[%r23 + 0x0149], %r27
	.word 0x899521a8  ! 668: WRPR_TICK_I	wrpr	%r20, 0x01a8, %tick
	.word 0xf614a1ee  ! 673: LDUH_I	lduh	[%r18 + 0x01ee], %r27
	.word 0xf05c4000  ! 674: LDX_R	ldx	[%r17 + %r0], %r24
	.word 0xf51c8000  ! 676: LDDF_R	ldd	[%r18, %r0], %f26
	.word 0xb551c000  ! 678: RDPR_TL	<illegal instruction>
	.word 0xbcac2049  ! 682: ANDNcc_I	andncc 	%r16, 0x0049, %r30
	.word 0xf455608a  ! 683: LDSH_I	ldsh	[%r21 + 0x008a], %r26
	.word 0xfe0ce097  ! 692: LDUB_I	ldub	[%r19 + 0x0097], %r31
	.word 0xb0a58000  ! 694: SUBcc_R	subcc 	%r22, %r0, %r24
	ta	T_CHANGE_HPRIV
	.word 0x819829d1  ! 695: WRHPR_HPSTATE_I	wrhpr	%r0, 0x09d1, %hpstate
	.word 0xf01d4000  ! 696: LDD_R	ldd	[%r21 + %r0], %r24
	.word 0xb7540000  ! 698: RDPR_GL	<illegal instruction>
hwintr_2_24:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_24), 16, 16)) -> intp(2, 0, 22)
	.word 0xf0558000  ! 704: LDSH_R	ldsh	[%r22 + %r0], %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982fdb  ! 706: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0fdb, %hpstate
hwintr_2_25:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_25), 16, 16)) -> intp(2, 0, 3e)
	.word 0xfa0ca0fc  ! 715: LDUB_I	ldub	[%r18 + 0x00fc], %r29
	.word 0x87942162  ! 718: WRPR_TT_I	wrpr	%r16, 0x0162, %tt
hwintr_2_26:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_26), 16, 16)) -> intp(2, 0, 33)
	.word 0xb22c61e8  ! 725: ANDN_I	andn 	%r17, 0x01e8, %r25
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xf80cc000  ! 727: LDUB_R	ldub	[%r19 + %r0], %r28
hwintr_2_27:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_27), 16, 16)) -> intp(2, 0, e)
	.word 0xfb1da1f8  ! 733: LDDF_I	ldd	[%r22, 0x01f8], %f29
	.word 0xf00c0000  ! 736: LDUB_R	ldub	[%r16 + %r0], %r24
	.word 0xfc14e008  ! 737: LDUH_I	lduh	[%r19 + 0x0008], %r30
	.word 0xb550c000  ! 738: RDPR_TT	rdpr	%tt, %r26
	.word 0xb4c48000  ! 739: ADDCcc_R	addccc 	%r18, %r0, %r26
hwintr_2_28:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_28), 16, 16)) -> intp(2, 0, 1b)
hwintr_2_29:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_29), 16, 16)) -> intp(2, 0, 25)
hwintr_2_30:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_30), 16, 16)) -> intp(2, 0, 26)
	.word 0xf85ce1b5  ! 747: LDX_I	ldx	[%r19 + 0x01b5], %r28
hwintr_2_31:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_31), 16, 16)) -> intp(2, 0, 19)
hwintr_2_32:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_32), 16, 16)) -> intp(2, 0, 1f)
	.word 0xf4140000  ! 751: LDUH_R	lduh	[%r16 + %r0], %r26
	.word 0xf845c000  ! 752: LDSW_R	ldsw	[%r23 + %r0], %r28
	.word 0xf25de135  ! 755: LDX_I	ldx	[%r23 + 0x0135], %r25
	.word 0xf00460a3  ! 757: LDUW_I	lduw	[%r17 + 0x00a3], %r24
	.word 0x8394a0fe  ! 762: WRPR_TNPC_I	wrpr	%r18, 0x00fe, %tnpc
	.word 0xfd1d61ce  ! 766: LDDF_I	ldd	[%r21, 0x01ce], %f30
hwintr_2_33:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_33), 16, 16)) -> intp(2, 0, 4)
	.word 0xb7500000  ! 768: RDPR_TPC	<illegal instruction>
	.word 0xf0548000  ! 769: LDSH_R	ldsh	[%r18 + %r0], %r24
	.word 0xbf518000  ! 774: RDPR_PSTATE	<illegal instruction>
	.word 0xfa54c000  ! 775: LDSH_R	ldsh	[%r19 + %r0], %r29
	.word 0x839421fd  ! 776: WRPR_TNPC_I	wrpr	%r16, 0x01fd, %tnpc
	.word 0xfe14a12a  ! 778: LDUH_I	lduh	[%r18 + 0x012a], %r31
	.word 0xbd520000  ! 784: RDPR_PIL	<illegal instruction>
	.word 0xf64c0000  ! 785: LDSB_R	ldsb	[%r16 + %r0], %r27
	.word 0xb0bde141  ! 790: XNORcc_I	xnorcc 	%r23, 0x0141, %r24
	.word 0xf8456123  ! 791: LDSW_I	ldsw	[%r21 + 0x0123], %r28
	.word 0xb044e018  ! 792: ADDC_I	addc 	%r19, 0x0018, %r24
	.word 0xf45cc000  ! 795: LDX_R	ldx	[%r19 + %r0], %r26
hwintr_2_34:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_34), 16, 16)) -> intp(2, 0, 27)
	.word 0xf05de145  ! 798: LDX_I	ldx	[%r23 + 0x0145], %r24
	.word 0xf84c605d  ! 801: LDSB_I	ldsb	[%r17 + 0x005d], %r28
	.word 0xfb1d60eb  ! 803: LDDF_I	ldd	[%r21, 0x00eb], %f29
	.word 0xf2450000  ! 805: LDSW_R	ldsw	[%r20 + %r0], %r25
	.word 0xbe9c0000  ! 812: XORcc_R	xorcc 	%r16, %r0, %r31
	ta	T_CHANGE_HPRIV
	.word 0x81983d19  ! 818: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d19, %hpstate
	.word 0xfc1d0000  ! 826: LDD_R	ldd	[%r20 + %r0], %r30
	.word 0xf21d6175  ! 829: LDD_I	ldd	[%r21 + 0x0175], %r25
	.word 0xba45e0c8  ! 830: ADDC_I	addc 	%r23, 0x00c8, %r29
hwintr_2_35:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_35), 16, 16)) -> intp(2, 0, 18)
	.word 0xba356135  ! 833: SUBC_I	orn 	%r21, 0x0135, %r29
	.word 0xfc0da17d  ! 834: LDUB_I	ldub	[%r22 + 0x017d], %r30
	.word 0xb02c8000  ! 842: ANDN_R	andn 	%r18, %r0, %r24
	.word 0xfa1d60f7  ! 848: LDD_I	ldd	[%r21 + 0x00f7], %r29
	.word 0xf44d4000  ! 850: LDSB_R	ldsb	[%r21 + %r0], %r26
hwintr_2_36:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_36), 16, 16)) -> intp(2, 0, 39)
	.word 0xf6456186  ! 859: LDSW_I	ldsw	[%r21 + 0x0186], %r27
	.word 0x8d9560d8  ! 860: WRPR_PSTATE_I	wrpr	%r21, 0x00d8, %pstate
	.word 0xb2858000  ! 862: ADDcc_R	addcc 	%r22, %r0, %r25
	.word 0x8995e119  ! 866: WRPR_TICK_I	wrpr	%r23, 0x0119, %tick
	.word 0xfe55a1df  ! 871: LDSH_I	ldsh	[%r22 + 0x01df], %r31
	.word 0xb8bc8000  ! 872: XNORcc_R	xnorcc 	%r18, %r0, %r28
	mov	0, %r12
	.word 0x8f932000  ! 878: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_2_37:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_37), 16, 16)) -> intp(2, 0, 5)
	.word 0xbf51c000  ! 886: RDPR_TL	<illegal instruction>
	.word 0xf6040000  ! 888: LDUW_R	lduw	[%r16 + %r0], %r27
	.word 0x8195a182  ! 891: WRPR_TPC_I	wrpr	%r22, 0x0182, %tpc
	.word 0xb6c4a129  ! 893: ADDCcc_I	addccc 	%r18, 0x0129, %r27
	.word 0xf6158000  ! 894: LDUH_R	lduh	[%r22 + %r0], %r27
	mov	0, %r12
	.word 0x8f932000  ! 896: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb9518000  ! 901: RDPR_PSTATE	<illegal instruction>
	.word 0xb92c4000  ! 907: SLL_R	sll 	%r17, %r0, %r28
	.word 0x839460bf  ! 912: WRPR_TNPC_I	wrpr	%r17, 0x00bf, %tnpc
	.word 0xb8946082  ! 913: ORcc_I	orcc 	%r17, 0x0082, %r28
	.word 0xba8ce013  ! 916: ANDcc_I	andcc 	%r19, 0x0013, %r29
	.word 0xf61d4000  ! 917: LDD_R	ldd	[%r21 + %r0], %r27
	.word 0xb9500000  ! 918: RDPR_TPC	<illegal instruction>
	.word 0xf80d0000  ! 920: LDUB_R	ldub	[%r20 + %r0], %r28
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xfa55c000  ! 926: LDSH_R	ldsh	[%r23 + %r0], %r29
	.word 0xb1508000  ! 927: RDPR_TSTATE	<illegal instruction>
	.word 0xbb50c000  ! 929: RDPR_TT	<illegal instruction>
	.word 0xf64d8000  ! 931: LDSB_R	ldsb	[%r22 + %r0], %r27
	.word 0xf31d4000  ! 933: LDDF_R	ldd	[%r21, %r0], %f25
	.word 0xb6a44000  ! 934: SUBcc_R	subcc 	%r17, %r0, %r27
	.word 0xbb50c000  ! 940: RDPR_TT	<illegal instruction>
hwintr_2_38:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_38), 16, 16)) -> intp(2, 0, 23)
	.word 0xf41c61cf  ! 951: LDD_I	ldd	[%r17 + 0x01cf], %r26
hwintr_2_39:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_39), 16, 16)) -> intp(2, 0, 10)
	ta	T_CHANGE_HPRIV
	.word 0x81982b51  ! 955: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b51, %hpstate
	.word 0xb551c000  ! 958: RDPR_TL	<illegal instruction>
	.word 0x8d95e16a  ! 962: WRPR_PSTATE_I	wrpr	%r23, 0x016a, %pstate
	.word 0xb41d8000  ! 967: XOR_R	xor 	%r22, %r0, %r26
	setx	data_start_4, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfe0420da  ! 971: LDUW_I	lduw	[%r16 + 0x00da], %r31
	mov	1, %r14
	.word 0xa193a000  ! 973: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_2_40:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_40), 16, 16)) -> intp(2, 0, 38)
	.word 0xf45521d8  ! 979: LDSH_I	ldsh	[%r20 + 0x01d8], %r26
	.word 0xf60c61cf  ! 980: LDUB_I	ldub	[%r17 + 0x01cf], %r27
	.word 0xf854c000  ! 981: LDSH_R	ldsh	[%r19 + %r0], %r28
hwintr_2_41:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_41), 16, 16)) -> intp(2, 0, 17)
	.word 0xb0950000  ! 984: ORcc_R	orcc 	%r20, %r0, %r24
	.word 0xb8b48000  ! 985: ORNcc_R	orncc 	%r18, %r0, %r28
	.word 0xfa048000  ! 989: LDUW_R	lduw	[%r18 + %r0], %r29
	setx	data_start_4, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa0d0000  ! 1002: LDUB_R	ldub	[%r20 + %r0], %r29
	.word 0xb9480000  ! 1004: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xbd3c8000  ! 1009: SRA_R	sra 	%r18, %r0, %r30
	.word 0xf61c4000  ! 1010: LDD_R	ldd	[%r17 + %r0], %r27
	.word 0xfa04602f  ! 1012: LDUW_I	lduw	[%r17 + 0x002f], %r29
	.word 0xf444a03f  ! 1016: LDSW_I	ldsw	[%r18 + 0x003f], %r26
	.word 0xf85ca040  ! 1018: LDX_I	ldx	[%r18 + 0x0040], %r28
	.word 0xfc4c0000  ! 1019: LDSB_R	ldsb	[%r16 + %r0], %r30
	.word 0xfa44c000  ! 1026: LDSW_R	ldsw	[%r19 + %r0], %r29
hwintr_2_42:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_42), 16, 16)) -> intp(2, 0, b)
	setx	data_start_4, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfe1ca15d  ! 1029: LDD_I	ldd	[%r18 + 0x015d], %r31
	.word 0xf60ce02b  ! 1030: LDUB_I	ldub	[%r19 + 0x002b], %r27
	.word 0xf24d6030  ! 1033: LDSB_I	ldsb	[%r21 + 0x0030], %r25
	.word 0xf71c0000  ! 1034: LDDF_R	ldd	[%r16, %r0], %f27
	.word 0xf20c603d  ! 1035: LDUB_I	ldub	[%r17 + 0x003d], %r25
	.word 0xf65461b4  ! 1038: LDSH_I	ldsh	[%r17 + 0x01b4], %r27
	ta	T_CHANGE_HPRIV
	.word 0x81983841  ! 1039: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1841, %hpstate
hwintr_2_43:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_43), 16, 16)) -> intp(2, 0, 22)
	mov	0, %r12
	.word 0x8f932000  ! 1047: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x8995611d  ! 1048: WRPR_TICK_I	wrpr	%r21, 0x011d, %tick
	.word 0xf6448000  ! 1049: LDSW_R	ldsw	[%r18 + %r0], %r27
	.word 0xb9508000  ! 1052: RDPR_TSTATE	<illegal instruction>
	.word 0x8795210f  ! 1053: WRPR_TT_I	wrpr	%r20, 0x010f, %tt
	.word 0xb295c000  ! 1058: ORcc_R	orcc 	%r23, %r0, %r25
	.word 0xb4c4c000  ! 1059: ADDCcc_R	addccc 	%r19, %r0, %r26
	.word 0xbf504000  ! 1060: RDPR_TNPC	<illegal instruction>
	.word 0xf65c8000  ! 1062: LDX_R	ldx	[%r18 + %r0], %r27
	.word 0xb5518000  ! 1064: RDPR_PSTATE	<illegal instruction>
	.word 0x8195e0e5  ! 1065: WRPR_TPC_I	wrpr	%r23, 0x00e5, %tpc
	.word 0x8d95a158  ! 1070: WRPR_PSTATE_I	wrpr	%r22, 0x0158, %pstate
hwintr_2_44:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_44), 16, 16)) -> intp(2, 0, 28)
	.word 0xb9540000  ! 1072: RDPR_GL	<illegal instruction>
hwintr_2_45:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_45), 16, 16)) -> intp(2, 0, 2f)
	.word 0x859461bb  ! 1080: WRPR_TSTATE_I	wrpr	%r17, 0x01bb, %tstate
	.word 0xf41d21ca  ! 1081: LDD_I	ldd	[%r20 + 0x01ca], %r26
	.word 0xf6544000  ! 1084: LDSH_R	ldsh	[%r17 + %r0], %r27
	.word 0xfa158000  ! 1087: LDUH_R	lduh	[%r22 + %r0], %r29
	.word 0xbd500000  ! 1088: RDPR_TPC	<illegal instruction>
hwintr_2_46:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_46), 16, 16)) -> intp(2, 0, 13)
	.word 0xbb518000  ! 1092: RDPR_PSTATE	<illegal instruction>
	.word 0xf20cc000  ! 1096: LDUB_R	ldub	[%r19 + %r0], %r25
	.word 0xf64d0000  ! 1098: LDSB_R	ldsb	[%r20 + %r0], %r27
	.word 0xba3c2172  ! 1103: XNOR_I	xnor 	%r16, 0x0172, %r29
hwintr_2_47:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_47), 16, 16)) -> intp(2, 0, 3c)
	.word 0x8595e196  ! 1106: WRPR_TSTATE_I	wrpr	%r23, 0x0196, %tstate
	.word 0xfa54200f  ! 1110: LDSH_I	ldsh	[%r16 + 0x000f], %r29
	.word 0xfc1d0000  ! 1112: LDD_R	ldd	[%r20 + %r0], %r30
	.word 0x8595212f  ! 1113: WRPR_TSTATE_I	wrpr	%r20, 0x012f, %tstate
	setx	data_start_0, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xbc2c2186  ! 1116: ANDN_I	andn 	%r16, 0x0186, %r30
	.word 0xf0148000  ! 1118: LDUH_R	lduh	[%r18 + %r0], %r24
	setx	data_start_0, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfe054000  ! 1124: LDUW_R	lduw	[%r21 + %r0], %r31
	.word 0xfa0cc000  ! 1129: LDUB_R	ldub	[%r19 + %r0], %r29
	.word 0xb49da0ac  ! 1130: XORcc_I	xorcc 	%r22, 0x00ac, %r26
	.word 0xfa1d0000  ! 1131: LDD_R	ldd	[%r20 + %r0], %r29
	.word 0xfc15a0bc  ! 1136: LDUH_I	lduh	[%r22 + 0x00bc], %r30
	.word 0xf51dc000  ! 1141: LDDF_R	ldd	[%r23, %r0], %f26
hwintr_2_48:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_48), 16, 16)) -> intp(2, 0, 22)
	.word 0xf6044000  ! 1148: LDUW_R	lduw	[%r17 + %r0], %r27
	.word 0xbc1c21e1  ! 1149: XOR_I	xor 	%r16, 0x01e1, %r30
	.word 0xfe1cc000  ! 1150: LDD_R	ldd	[%r19 + %r0], %r31
	.word 0xbf510000  ! 1151: RDPR_TICK	<illegal instruction>
	.word 0xbb500000  ! 1152: RDPR_TPC	<illegal instruction>
	.word 0xbb510000  ! 1155: RDPR_TICK	<illegal instruction>
	.word 0xf25ce190  ! 1160: LDX_I	ldx	[%r19 + 0x0190], %r25
	.word 0xf41d8000  ! 1161: LDD_R	ldd	[%r22 + %r0], %r26
	.word 0xf455a03b  ! 1163: LDSH_I	ldsh	[%r22 + 0x003b], %r26
	.word 0xbeac4000  ! 1164: ANDNcc_R	andncc 	%r17, %r0, %r31
	.word 0xf61d8000  ! 1167: LDD_R	ldd	[%r22 + %r0], %r27
	.word 0xb550c000  ! 1169: RDPR_TT	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81983b59  ! 1173: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b59, %hpstate
	.word 0xb2bd2084  ! 1176: XNORcc_I	xnorcc 	%r20, 0x0084, %r25
	.word 0xf81c8000  ! 1177: LDD_R	ldd	[%r18 + %r0], %r28
	.word 0xf45c61f9  ! 1178: LDX_I	ldx	[%r17 + 0x01f9], %r26
	.word 0xfe548000  ! 1179: LDSH_R	ldsh	[%r18 + %r0], %r31
	.word 0x83942020  ! 1186: WRPR_TNPC_I	wrpr	%r16, 0x0020, %tnpc
	.word 0xbd508000  ! 1191: RDPR_TSTATE	<illegal instruction>
hwintr_2_49:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_49), 16, 16)) -> intp(2, 0, 6)
	.word 0x8d94a1c8  ! 1198: WRPR_PSTATE_I	wrpr	%r18, 0x01c8, %pstate
	.word 0xfa0c0000  ! 1200: LDUB_R	ldub	[%r16 + %r0], %r29
hwintr_2_50:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_50), 16, 16)) -> intp(2, 0, 4)
	.word 0xf214e168  ! 1202: LDUH_I	lduh	[%r19 + 0x0168], %r25
	.word 0xf00d20ab  ! 1203: LDUB_I	ldub	[%r20 + 0x00ab], %r24
	.word 0xfc4ce090  ! 1204: LDSB_I	ldsb	[%r19 + 0x0090], %r30
hwintr_2_51:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_51), 16, 16)) -> intp(2, 0, b)
hwintr_2_52:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_52), 16, 16)) -> intp(2, 0, 2d)
	.word 0xf84c0000  ! 1208: LDSB_R	ldsb	[%r16 + %r0], %r28
hwintr_2_53:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_53), 16, 16)) -> intp(2, 0, 34)
	.word 0xfe5c8000  ! 1216: LDX_R	ldx	[%r18 + %r0], %r31
	setx	data_start_3, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81983ed1  ! 1219: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1ed1, %hpstate
hwintr_2_54:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_54), 16, 16)) -> intp(2, 0, a)
	.word 0xf40cc000  ! 1222: LDUB_R	ldub	[%r19 + %r0], %r26
	ta	T_CHANGE_HPRIV
	.word 0x81982b1b  ! 1223: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b1b, %hpstate
hwintr_2_55:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_55), 16, 16)) -> intp(2, 0, 2e)
	.word 0xfc1d4000  ! 1232: LDD_R	ldd	[%r21 + %r0], %r30
	.word 0xb0b5e1da  ! 1235: SUBCcc_I	orncc 	%r23, 0x01da, %r24
	.word 0xfc54e02c  ! 1237: LDSH_I	ldsh	[%r19 + 0x002c], %r30
	.word 0xf01da006  ! 1239: LDD_I	ldd	[%r22 + 0x0006], %r24
	.word 0x8794e196  ! 1242: WRPR_TT_I	wrpr	%r19, 0x0196, %tt
	.word 0xfa454000  ! 1243: LDSW_R	ldsw	[%r21 + %r0], %r29
	.word 0xf65dc000  ! 1246: LDX_R	ldx	[%r23 + %r0], %r27
	ta	T_CHANGE_HPRIV
	.word 0x8198390b  ! 1249: WRHPR_HPSTATE_I	wrhpr	%r0, 0x190b, %hpstate
	.word 0xfc14c000  ! 1250: LDUH_R	lduh	[%r19 + %r0], %r30
hwintr_2_56:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_56), 16, 16)) -> intp(2, 0, b)
	.word 0xf41d6028  ! 1259: LDD_I	ldd	[%r21 + 0x0028], %r26
	.word 0xf80d2158  ! 1262: LDUB_I	ldub	[%r20 + 0x0158], %r28
	.word 0xb3500000  ! 1264: RDPR_TPC	<illegal instruction>
hwintr_2_57:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_57), 16, 16)) -> intp(2, 0, 30)
	.word 0xf2540000  ! 1266: LDSH_R	ldsh	[%r16 + %r0], %r25
	.word 0x8795604f  ! 1273: WRPR_TT_I	wrpr	%r21, 0x004f, %tt
	.word 0x899461b9  ! 1274: WRPR_TICK_I	wrpr	%r17, 0x01b9, %tick
	mov	0, %r14
	.word 0xa193a000  ! 1276: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf445e0cf  ! 1279: LDSW_I	ldsw	[%r23 + 0x00cf], %r26
hwintr_2_58:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_58), 16, 16)) -> intp(2, 0, 7)
hwintr_2_59:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_59), 16, 16)) -> intp(2, 0, 3b)
	.word 0xfc45a1dc  ! 1283: LDSW_I	ldsw	[%r22 + 0x01dc], %r30
hwintr_2_60:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_60), 16, 16)) -> intp(2, 0, 10)
	.word 0xb644c000  ! 1287: ADDC_R	addc 	%r19, %r0, %r27
	.word 0xb48d8000  ! 1289: ANDcc_R	andcc 	%r22, %r0, %r26
	.word 0xb8bd0000  ! 1292: XNORcc_R	xnorcc 	%r20, %r0, %r28
	.word 0xbd641800  ! 1298: MOVcc_R	<illegal instruction>
	.word 0xfa44c000  ! 1300: LDSW_R	ldsw	[%r19 + %r0], %r29
	.word 0xfa14a1c4  ! 1301: LDUH_I	lduh	[%r18 + 0x01c4], %r29
	.word 0xfc5c4000  ! 1309: LDX_R	ldx	[%r17 + %r0], %r30
hwintr_2_61:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_61), 16, 16)) -> intp(2, 0, 1c)
	.word 0xf4152123  ! 1313: LDUH_I	lduh	[%r20 + 0x0123], %r26
	.word 0xfe04e17c  ! 1316: LDUW_I	lduw	[%r19 + 0x017c], %r31
	.word 0xf445e114  ! 1320: LDSW_I	ldsw	[%r23 + 0x0114], %r26
	.word 0xfa04e0ab  ! 1321: LDUW_I	lduw	[%r19 + 0x00ab], %r29
	.word 0xb01d4000  ! 1324: XOR_R	xor 	%r21, %r0, %r24
	.word 0xf25c20b3  ! 1325: LDX_I	ldx	[%r16 + 0x00b3], %r25
	.word 0xf4158000  ! 1327: LDUH_R	lduh	[%r22 + %r0], %r26
	.word 0xbebc0000  ! 1332: XNORcc_R	xnorcc 	%r16, %r0, %r31
	.word 0xfc14a1a5  ! 1333: LDUH_I	lduh	[%r18 + 0x01a5], %r30
	setx	data_start_1, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_2_62:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_62), 16, 16)) -> intp(2, 0, 1a)
	.word 0xb0b58000  ! 1338: ORNcc_R	orncc 	%r22, %r0, %r24
	.word 0xf31cc000  ! 1341: LDDF_R	ldd	[%r19, %r0], %f25
	.word 0xf84d6002  ! 1349: LDSB_I	ldsb	[%r21 + 0x0002], %r28
	setx	data_start_1, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x819839db  ! 1353: WRHPR_HPSTATE_I	wrhpr	%r0, 0x19db, %hpstate
	.word 0xf254a1af  ! 1354: LDSH_I	ldsh	[%r18 + 0x01af], %r25
	.word 0x879460b7  ! 1361: WRPR_TT_I	wrpr	%r17, 0x00b7, %tt
	.word 0xfc054000  ! 1364: LDUW_R	lduw	[%r21 + %r0], %r30
	.word 0xbd520000  ! 1367: RDPR_PIL	<illegal instruction>
	.word 0xfe556025  ! 1370: LDSH_I	ldsh	[%r21 + 0x0025], %r31
	.word 0xf64c210e  ! 1372: LDSB_I	ldsb	[%r16 + 0x010e], %r27
	.word 0xbb480000  ! 1374: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xf645e165  ! 1377: LDSW_I	ldsw	[%r23 + 0x0165], %r27
	mov	1, %r14
	.word 0xa193a000  ! 1383: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf85560de  ! 1385: LDSH_I	ldsh	[%r21 + 0x00de], %r28
	.word 0xfc1ce011  ! 1387: LDD_I	ldd	[%r19 + 0x0011], %r30
hwintr_2_63:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_63), 16, 16)) -> intp(2, 0, 2)
hwintr_2_64:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_64), 16, 16)) -> intp(2, 0, 2b)
	.word 0x919560fd  ! 1393: WRPR_PIL_I	wrpr	%r21, 0x00fd, %pil
	.word 0xfc15c000  ! 1399: LDUH_R	lduh	[%r23 + %r0], %r30
	setx	data_start_7, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_2_65:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_65), 16, 16)) -> intp(2, 0, 4)
	.word 0xff1d4000  ! 1408: LDDF_R	ldd	[%r21, %r0], %f31
	mov	2, %r14
	.word 0xa193a000  ! 1411: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb751c000  ! 1413: RDPR_TL	<illegal instruction>
	.word 0xf25ce1e2  ! 1416: LDX_I	ldx	[%r19 + 0x01e2], %r25
	.word 0xf40de014  ! 1419: LDUB_I	ldub	[%r23 + 0x0014], %r26
	.word 0xf40de0ca  ! 1422: LDUB_I	ldub	[%r23 + 0x00ca], %r26
	.word 0xbb508000  ! 1426: RDPR_TSTATE	<illegal instruction>
	.word 0xbd518000  ! 1427: RDPR_PSTATE	<illegal instruction>
	.word 0xb53d6001  ! 1428: SRA_I	sra 	%r21, 0x0001, %r26
	.word 0xfe4c61bc  ! 1432: LDSB_I	ldsb	[%r17 + 0x01bc], %r31
hwintr_2_66:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_66), 16, 16)) -> intp(2, 0, 36)
	.word 0xf41c0000  ! 1436: LDD_R	ldd	[%r16 + %r0], %r26
	.word 0xb09420a3  ! 1444: ORcc_I	orcc 	%r16, 0x00a3, %r24
hwintr_2_67:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_67), 16, 16)) -> intp(2, 0, 1f)
	.word 0xbb643801  ! 1448: MOVcc_I	<illegal instruction>
	.word 0xb0ac8000  ! 1449: ANDNcc_R	andncc 	%r18, %r0, %r24
	.word 0xf005e0f7  ! 1450: LDUW_I	lduw	[%r23 + 0x00f7], %r24
	.word 0xfe558000  ! 1452: LDSH_R	ldsh	[%r22 + %r0], %r31
	.word 0xfb1c4000  ! 1453: LDDF_R	ldd	[%r17, %r0], %f29
	.word 0xf40cc000  ! 1455: LDUB_R	ldub	[%r19 + %r0], %r26
	.word 0xfa456159  ! 1458: LDSW_I	ldsw	[%r21 + 0x0159], %r29
	.word 0xf045e028  ! 1461: LDSW_I	ldsw	[%r23 + 0x0028], %r24
	.word 0xf40c4000  ! 1464: LDUB_R	ldub	[%r17 + %r0], %r26
	.word 0xb72c7001  ! 1468: SLLX_I	sllx	%r17, 0x0001, %r27
	mov	2, %r14
	.word 0xa193a000  ! 1470: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb93da001  ! 1473: SRA_I	sra 	%r22, 0x0001, %r28
	.word 0xbd643801  ! 1474: MOVcc_I	<illegal instruction>
	.word 0xf25d8000  ! 1475: LDX_R	ldx	[%r22 + %r0], %r25
	.word 0xb5520000  ! 1476: RDPR_PIL	<illegal instruction>
	.word 0xfe556171  ! 1477: LDSH_I	ldsh	[%r21 + 0x0171], %r31
	.word 0xb3520000  ! 1483: RDPR_PIL	<illegal instruction>
	setx	data_start_0, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x91952192  ! 1489: WRPR_PIL_I	wrpr	%r20, 0x0192, %pil
	.word 0xf8056191  ! 1495: LDUW_I	lduw	[%r21 + 0x0191], %r28
	setx	data_start_2, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r20, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa5d212d  ! 1498: LDX_I	ldx	[%r20 + 0x012d], %r29
	.word 0xfc04c000  ! 1505: LDUW_R	lduw	[%r19 + %r0], %r30
	.word 0xf45460c5  ! 1506: LDSH_I	ldsh	[%r17 + 0x00c5], %r26
	.word 0xfe554000  ! 1508: LDSH_R	ldsh	[%r21 + %r0], %r31
	.word 0xf64c4000  ! 1509: LDSB_R	ldsb	[%r17 + %r0], %r27
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xf81d8000  ! 1511: LDD_R	ldd	[%r22 + %r0], %r28
	.word 0xf0442043  ! 1515: LDSW_I	ldsw	[%r16 + 0x0043], %r24
	.word 0xf404c000  ! 1516: LDUW_R	lduw	[%r19 + %r0], %r26
	.word 0x8794a078  ! 1519: WRPR_TT_I	wrpr	%r18, 0x0078, %tt
	.word 0x9194e07c  ! 1521: WRPR_PIL_I	wrpr	%r19, 0x007c, %pil
	.word 0xf445a054  ! 1526: LDSW_I	ldsw	[%r22 + 0x0054], %r26
	ta	T_CHANGE_HPRIV
	.word 0x819829d3  ! 1528: WRHPR_HPSTATE_I	wrhpr	%r0, 0x09d3, %hpstate
	.word 0xf415614a  ! 1530: LDUH_I	lduh	[%r21 + 0x014a], %r26
	.word 0xf84461de  ! 1532: LDSW_I	ldsw	[%r17 + 0x01de], %r28
	.word 0xfc45e09e  ! 1536: LDSW_I	ldsw	[%r23 + 0x009e], %r30
hwintr_2_68:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_68), 16, 16)) -> intp(2, 0, 10)
	mov	2, %r12
	.word 0x8f932000  ! 1541: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf415e104  ! 1543: LDUH_I	lduh	[%r23 + 0x0104], %r26
	.word 0x8d942045  ! 1546: WRPR_PSTATE_I	wrpr	%r16, 0x0045, %pstate
	.word 0xf2144000  ! 1548: LDUH_R	lduh	[%r17 + %r0], %r25
	.word 0xf015e182  ! 1552: LDUH_I	lduh	[%r23 + 0x0182], %r24
	setx	data_start_1, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf44d8000  ! 1559: LDSB_R	ldsb	[%r22 + %r0], %r26
	.word 0xf01d4000  ! 1560: LDD_R	ldd	[%r21 + %r0], %r24
	.word 0xf04ca1da  ! 1561: LDSB_I	ldsb	[%r18 + 0x01da], %r24
	mov	0, %r12
	.word 0x8f932000  ! 1566: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_2_69:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_69), 16, 16)) -> intp(2, 0, 2d)
	.word 0xf0054000  ! 1570: LDUW_R	lduw	[%r21 + %r0], %r24
	.word 0xf454c000  ! 1572: LDSH_R	ldsh	[%r19 + %r0], %r26
	.word 0xb53ce001  ! 1574: SRA_I	sra 	%r19, 0x0001, %r26
	.word 0xfa044000  ! 1579: LDUW_R	lduw	[%r17 + %r0], %r29
	.word 0xf40da1b9  ! 1583: LDUB_I	ldub	[%r22 + 0x01b9], %r26
	ta	T_CHANGE_HPRIV
	.word 0x81983e81  ! 1584: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e81, %hpstate
	.word 0xfc4de199  ! 1586: LDSB_I	ldsb	[%r23 + 0x0199], %r30
	.word 0xf804a083  ! 1588: LDUW_I	lduw	[%r18 + 0x0083], %r28
	.word 0xf20d8000  ! 1591: LDUB_R	ldub	[%r22 + %r0], %r25
	.word 0xf80d4000  ! 1593: LDUB_R	ldub	[%r21 + %r0], %r28
	.word 0xf84461a7  ! 1597: LDSW_I	ldsw	[%r17 + 0x01a7], %r28
	mov	0, %r14
	.word 0xa193a000  ! 1599: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf4148000  ! 1602: LDUH_R	lduh	[%r18 + %r0], %r26
	.word 0xb9520000  ! 1607: RDPR_PIL	<illegal instruction>
	.word 0xf51c8000  ! 1609: LDDF_R	ldd	[%r18, %r0], %f26
	.word 0xfc4d4000  ! 1611: LDSB_R	ldsb	[%r21 + %r0], %r30
	.word 0xf40de1e2  ! 1613: LDUB_I	ldub	[%r23 + 0x01e2], %r26
	.word 0xf44d4000  ! 1614: LDSB_R	ldsb	[%r21 + %r0], %r26
	.word 0xf854c000  ! 1617: LDSH_R	ldsh	[%r19 + %r0], %r28
	.word 0x859520ea  ! 1618: WRPR_TSTATE_I	wrpr	%r20, 0x00ea, %tstate
	.word 0xf014c000  ! 1624: LDUH_R	lduh	[%r19 + %r0], %r24
	.word 0xf05ca0da  ! 1626: LDX_I	ldx	[%r18 + 0x00da], %r24
	.word 0xb1520000  ! 1629: RDPR_PIL	<illegal instruction>
	.word 0xb73c6001  ! 1631: SRA_I	sra 	%r17, 0x0001, %r27
	.word 0xf615e1c9  ! 1637: LDUH_I	lduh	[%r23 + 0x01c9], %r27
	.word 0xf04d60a1  ! 1638: LDSB_I	ldsb	[%r21 + 0x00a1], %r24
	.word 0xb9518000  ! 1642: RDPR_PSTATE	<illegal instruction>
	.word 0xbb51c000  ! 1644: RDPR_TL	<illegal instruction>
	.word 0xf804c000  ! 1649: LDUW_R	lduw	[%r19 + %r0], %r28
	.word 0xfa0d612a  ! 1650: LDUB_I	ldub	[%r21 + 0x012a], %r29
	.word 0xb5500000  ! 1656: RDPR_TPC	<illegal instruction>
	.word 0xf25d2165  ! 1660: LDX_I	ldx	[%r20 + 0x0165], %r25
	.word 0x8995a179  ! 1661: WRPR_TICK_I	wrpr	%r22, 0x0179, %tick
	.word 0xf445e114  ! 1667: LDSW_I	ldsw	[%r23 + 0x0114], %r26
	.word 0xf61ca029  ! 1671: LDD_I	ldd	[%r18 + 0x0029], %r27
	.word 0xba1c21dd  ! 1672: XOR_I	xor 	%r16, 0x01dd, %r29
	.word 0xf61c60a5  ! 1674: LDD_I	ldd	[%r17 + 0x00a5], %r27
hwintr_2_70:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_70), 16, 16)) -> intp(2, 0, 3a)
	.word 0xf71dc000  ! 1683: LDDF_R	ldd	[%r23, %r0], %f27
	.word 0xbb51c000  ! 1687: RDPR_TL	<illegal instruction>
	mov	1, %r12
	.word 0x8f932000  ! 1691: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf0448000  ! 1694: LDSW_R	ldsw	[%r18 + %r0], %r24
hwintr_2_71:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_71), 16, 16)) -> intp(2, 0, 1a)
	.word 0xfe4521f4  ! 1696: LDSW_I	ldsw	[%r20 + 0x01f4], %r31
	.word 0x8995a187  ! 1704: WRPR_TICK_I	wrpr	%r22, 0x0187, %tick
	mov	0, %r14
	.word 0xa193a000  ! 1705: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb5504000  ! 1709: RDPR_TNPC	<illegal instruction>
	.word 0xf04c61a8  ! 1710: LDSB_I	ldsb	[%r17 + 0x01a8], %r24
hwintr_2_72:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_72), 16, 16)) -> intp(2, 0, 17)
hwintr_2_73:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_73), 16, 16)) -> intp(2, 0, 18)
	ta	T_CHANGE_HPRIV
	.word 0x81983c49  ! 1719: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c49, %hpstate
	.word 0xf91cc000  ! 1720: LDDF_R	ldd	[%r19, %r0], %f28
	.word 0xf6544000  ! 1721: LDSH_R	ldsh	[%r17 + %r0], %r27
	.word 0xb3510000  ! 1722: RDPR_TICK	<illegal instruction>
	.word 0xfe4cc000  ! 1723: LDSB_R	ldsb	[%r19 + %r0], %r31
hwintr_2_74:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_74), 16, 16)) -> intp(2, 0, 2f)
	.word 0xbc3ce175  ! 1727: XNOR_I	xnor 	%r19, 0x0175, %r30
	ta	T_CHANGE_HPRIV
	.word 0x81982953  ! 1728: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0953, %hpstate
	.word 0xfc44603c  ! 1729: LDSW_I	ldsw	[%r17 + 0x003c], %r30
hwintr_2_75:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_75), 16, 16)) -> intp(2, 0, 37)
hwintr_2_76:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_76), 16, 16)) -> intp(2, 0, 3)
	.word 0xbf51c000  ! 1737: RDPR_TL	<illegal instruction>
	.word 0xf64c21bb  ! 1740: LDSB_I	ldsb	[%r16 + 0x01bb], %r27
	.word 0xb23da10d  ! 1742: XNOR_I	xnor 	%r22, 0x010d, %r25
	.word 0xbac5a19d  ! 1743: ADDCcc_I	addccc 	%r22, 0x019d, %r29
	.word 0xf01c8000  ! 1745: LDD_R	ldd	[%r18 + %r0], %r24
hwintr_2_77:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_77), 16, 16)) -> intp(2, 0, 22)
	.word 0x8994a19b  ! 1750: WRPR_TICK_I	wrpr	%r18, 0x019b, %tick
	.word 0x89946010  ! 1751: WRPR_TICK_I	wrpr	%r17, 0x0010, %tick
	.word 0xfa0d4000  ! 1752: LDUB_R	ldub	[%r21 + %r0], %r29
	.word 0xf044c000  ! 1753: LDSW_R	ldsw	[%r19 + %r0], %r24
	.word 0xf2554000  ! 1754: LDSH_R	ldsh	[%r21 + %r0], %r25
	.word 0xf2444000  ! 1756: LDSW_R	ldsw	[%r17 + %r0], %r25
	.word 0xbb510000  ! 1758: RDPR_TICK	<illegal instruction>
	.word 0xf6448000  ! 1761: LDSW_R	ldsw	[%r18 + %r0], %r27
hwintr_2_78:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_78), 16, 16)) -> intp(2, 0, 7)
	.word 0xfc5ca0c1  ! 1763: LDX_I	ldx	[%r18 + 0x00c1], %r30
	.word 0xb950c000  ! 1764: RDPR_TT	<illegal instruction>
	.word 0xf84c8000  ! 1768: LDSB_R	ldsb	[%r18 + %r0], %r28
	.word 0xbe9c4000  ! 1769: XORcc_R	xorcc 	%r17, %r0, %r31
	.word 0x91946001  ! 1771: WRPR_PIL_I	wrpr	%r17, 0x0001, %pil
	ta	T_CHANGE_HPRIV
	.word 0x819829d9  ! 1773: WRHPR_HPSTATE_I	wrhpr	%r0, 0x09d9, %hpstate
	.word 0xf44cc000  ! 1783: LDSB_R	ldsb	[%r19 + %r0], %r26
	.word 0xf414c000  ! 1785: LDUH_R	lduh	[%r19 + %r0], %r26
	.word 0xf65c21e3  ! 1787: LDX_I	ldx	[%r16 + 0x01e3], %r27
	.word 0xf40da02d  ! 1792: LDUB_I	ldub	[%r22 + 0x002d], %r26
	setx	data_start_7, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_2_79:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_79), 16, 16)) -> intp(2, 0, 18)
	mov	0, %r12
	.word 0x8f932000  ! 1798: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_2_80:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_80), 16, 16)) -> intp(2, 0, 21)
	ta	T_CHANGE_HPRIV
	.word 0x81983e01  ! 1805: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e01, %hpstate
	.word 0xb9508000  ! 1811: RDPR_TSTATE	<illegal instruction>
	.word 0xfc45c000  ! 1814: LDSW_R	ldsw	[%r23 + %r0], %r30
	.word 0xf25c4000  ! 1815: LDX_R	ldx	[%r17 + %r0], %r25
	.word 0xbf7de401  ! 1817: MOVR_I	movre	%r23, 0x1, %r31
	.word 0xf64c0000  ! 1820: LDSB_R	ldsb	[%r16 + %r0], %r27
	.word 0xb350c000  ! 1822: RDPR_TT	<illegal instruction>
	.word 0xf4442178  ! 1824: LDSW_I	ldsw	[%r16 + 0x0178], %r26
	.word 0xf81c8000  ! 1830: LDD_R	ldd	[%r18 + %r0], %r28
	.word 0xbf7da401  ! 1832: MOVR_I	movre	%r22, 0x1, %r31
hwintr_2_81:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_81), 16, 16)) -> intp(2, 0, 1f)
	ta	T_CHANGE_HPRIV
	.word 0x81983959  ! 1835: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1959, %hpstate
	.word 0xf61ce095  ! 1840: LDD_I	ldd	[%r19 + 0x0095], %r27
	.word 0xfa0ca0f9  ! 1841: LDUB_I	ldub	[%r18 + 0x00f9], %r29
	.word 0xf255c000  ! 1844: LDSH_R	ldsh	[%r23 + %r0], %r25
	.word 0xf6550000  ! 1845: LDSH_R	ldsh	[%r20 + %r0], %r27
hwintr_2_82:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_82), 16, 16)) -> intp(2, 0, 29)
	.word 0x8d95e06c  ! 1851: WRPR_PSTATE_I	wrpr	%r23, 0x006c, %pstate
	.word 0xf21ca0dc  ! 1852: LDD_I	ldd	[%r18 + 0x00dc], %r25
	.word 0xb3520000  ! 1854: RDPR_PIL	<illegal instruction>
	.word 0xfc0c211b  ! 1857: LDUB_I	ldub	[%r16 + 0x011b], %r30
hwintr_2_83:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_83), 16, 16)) -> intp(2, 0, 5)
	.word 0xfc146085  ! 1859: LDUH_I	lduh	[%r17 + 0x0085], %r30
	.word 0xfa45a113  ! 1868: LDSW_I	ldsw	[%r22 + 0x0113], %r29
	.word 0xf65c8000  ! 1869: LDX_R	ldx	[%r18 + %r0], %r27
	.word 0xf2544000  ! 1871: LDSH_R	ldsh	[%r17 + %r0], %r25
	mov	1, %r12
	.word 0x8f932000  ! 1872: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x9194607f  ! 1882: WRPR_PIL_I	wrpr	%r17, 0x007f, %pil
	.word 0xbf518000  ! 1888: RDPR_PSTATE	<illegal instruction>
	.word 0xb73c2001  ! 1891: SRA_I	sra 	%r16, 0x0001, %r27
	.word 0xb425a0a2  ! 1898: SUB_I	sub 	%r22, 0x00a2, %r26
	.word 0x81942048  ! 1899: WRPR_TPC_I	wrpr	%r16, 0x0048, %tpc
	.word 0xfe14e1c6  ! 1901: LDUH_I	lduh	[%r19 + 0x01c6], %r31
	setx	data_start_1, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfe15c000  ! 1905: LDUH_R	lduh	[%r23 + %r0], %r31
	.word 0xba258000  ! 1909: SUB_R	sub 	%r22, %r0, %r29
	.word 0xb3504000  ! 1911: RDPR_TNPC	<illegal instruction>
	.word 0xfa152023  ! 1912: LDUH_I	lduh	[%r20 + 0x0023], %r29
	.word 0xf815e15b  ! 1913: LDUH_I	lduh	[%r23 + 0x015b], %r28
	.word 0x8d95e0ae  ! 1915: WRPR_PSTATE_I	wrpr	%r23, 0x00ae, %pstate
	.word 0xf85d0000  ! 1921: LDX_R	ldx	[%r20 + %r0], %r28
	.word 0xf2142133  ! 1924: LDUH_I	lduh	[%r16 + 0x0133], %r25
hwintr_2_84:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_84), 16, 16)) -> intp(2, 0, 6)
	.word 0xbcad8000  ! 1930: ANDNcc_R	andncc 	%r22, %r0, %r30
	.word 0xfc058000  ! 1931: LDUW_R	lduw	[%r22 + %r0], %r30
	.word 0x81952062  ! 1936: WRPR_TPC_I	wrpr	%r20, 0x0062, %tpc
hwintr_2_85:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_85), 16, 16)) -> intp(2, 0, 1c)
	.word 0xfa5461b3  ! 1939: LDSH_I	ldsh	[%r17 + 0x01b3], %r29
	.word 0xff1d61dc  ! 1941: LDDF_I	ldd	[%r21, 0x01dc], %f31
	.word 0x9194e178  ! 1943: WRPR_PIL_I	wrpr	%r19, 0x0178, %pil
	.word 0x8d94a10f  ! 1946: WRPR_PSTATE_I	wrpr	%r18, 0x010f, %pstate
	.word 0xb9340000  ! 1947: SRL_R	srl 	%r16, %r0, %r28
	.word 0xfa4dc000  ! 1949: LDSB_R	ldsb	[%r23 + %r0], %r29
hwintr_2_86:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_86), 16, 16)) -> intp(2, 0, 9)
	.word 0xb751c000  ! 1954: RDPR_TL	<illegal instruction>
	.word 0xfa0d8000  ! 1955: LDUB_R	ldub	[%r22 + %r0], %r29
	.word 0xbc95e1b1  ! 1958: ORcc_I	orcc 	%r23, 0x01b1, %r30
	.word 0xfe5da10d  ! 1959: LDX_I	ldx	[%r22 + 0x010d], %r31
hwintr_2_87:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_87), 16, 16)) -> intp(2, 0, c)
	.word 0xb33d6001  ! 1965: SRA_I	sra 	%r21, 0x0001, %r25
hwintr_2_88:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_88), 16, 16)) -> intp(2, 0, 7)
	.word 0xf804607f  ! 1967: LDUW_I	lduw	[%r17 + 0x007f], %r28
	.word 0xbd508000  ! 1974: RDPR_TSTATE	<illegal instruction>
	.word 0xf2554000  ! 1975: LDSH_R	ldsh	[%r21 + %r0], %r25
	.word 0xb1540000  ! 1978: RDPR_GL	<illegal instruction>
	.word 0xff1dc000  ! 1979: LDDF_R	ldd	[%r23, %r0], %f31
	.word 0x91946059  ! 1982: WRPR_PIL_I	wrpr	%r17, 0x0059, %pil
	.word 0x9194e027  ! 1983: WRPR_PIL_I	wrpr	%r19, 0x0027, %pil
	.word 0xf205a08a  ! 1984: LDUW_I	lduw	[%r22 + 0x008a], %r25
	.word 0xbf352001  ! 1985: SRL_I	srl 	%r20, 0x0001, %r31
	.word 0xfa1de097  ! 1986: LDD_I	ldd	[%r23 + 0x0097], %r29
hwintr_2_89:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_89), 16, 16)) -> intp(2, 0, 38)
	.word 0xf85c6021  ! 1994: LDX_I	ldx	[%r17 + 0x0021], %r28
	.word 0xf65c0000  ! 1995: LDX_R	ldx	[%r16 + %r0], %r27
	mov	0, %r14
	.word 0xa193a000  ! 1996: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_2_90:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_90), 16, 16)) -> intp(2, 0, 19)
	.word 0xfa0ca112  ! 2008: LDUB_I	ldub	[%r18 + 0x0112], %r29
	.word 0x8794e082  ! 2009: WRPR_TT_I	wrpr	%r19, 0x0082, %tt
hwintr_2_91:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_91), 16, 16)) -> intp(2, 0, 39)
	.word 0xfe05a1bb  ! 2013: LDUW_I	lduw	[%r22 + 0x01bb], %r31
	.word 0xf0044000  ! 2014: LDUW_R	lduw	[%r17 + %r0], %r24
	.word 0xf0140000  ! 2016: LDUH_R	lduh	[%r16 + %r0], %r24
	.word 0xf51c604b  ! 2018: LDDF_I	ldd	[%r17, 0x004b], %f26
	setx	data_start_5, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xbc448000  ! 2024: ADDC_R	addc 	%r18, %r0, %r30
	.word 0xf64da1a2  ! 2025: LDSB_I	ldsb	[%r22 + 0x01a2], %r27
	.word 0xf40d8000  ! 2026: LDUB_R	ldub	[%r22 + %r0], %r26
	.word 0xb351c000  ! 2028: RDPR_TL	<illegal instruction>
	.word 0xb1520000  ! 2029: RDPR_PIL	<illegal instruction>
hwintr_2_92:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_92), 16, 16)) -> intp(2, 0, 3)
	.word 0xf4056008  ! 2033: LDUW_I	lduw	[%r21 + 0x0008], %r26
	.word 0xfa05a10c  ! 2039: LDUW_I	lduw	[%r22 + 0x010c], %r29
	.word 0xf04d4000  ! 2040: LDSB_R	ldsb	[%r21 + %r0], %r24
	.word 0xf60ca086  ! 2045: LDUB_I	ldub	[%r18 + 0x0086], %r27
	.word 0xfc44c000  ! 2055: LDSW_R	ldsw	[%r19 + %r0], %r30
	.word 0x8194a0ec  ! 2056: WRPR_TPC_I	wrpr	%r18, 0x00ec, %tpc
	.word 0xbe2d8000  ! 2060: ANDN_R	andn 	%r22, %r0, %r31
	.word 0xf81420c0  ! 2061: LDUH_I	lduh	[%r16 + 0x00c0], %r28
	.word 0x81956099  ! 2064: WRPR_TPC_I	wrpr	%r21, 0x0099, %tpc
	.word 0xb08de1d2  ! 2067: ANDcc_I	andcc 	%r23, 0x01d2, %r24
	.word 0xf45c2044  ! 2070: LDX_I	ldx	[%r16 + 0x0044], %r26
	.word 0xf11d4000  ! 2071: LDDF_R	ldd	[%r21, %r0], %f24
	.word 0xfb1cc000  ! 2072: LDDF_R	ldd	[%r19, %r0], %f29
	.word 0xf41de1dc  ! 2075: LDD_I	ldd	[%r23 + 0x01dc], %r26
	.word 0xf01c4000  ! 2076: LDD_R	ldd	[%r17 + %r0], %r24
	.word 0xf81da03e  ! 2077: LDD_I	ldd	[%r22 + 0x003e], %r28
	.word 0xf64da0f1  ! 2080: LDSB_I	ldsb	[%r22 + 0x00f1], %r27
hwintr_2_93:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_93), 16, 16)) -> intp(2, 0, f)
	.word 0xf51ca132  ! 2090: LDDF_I	ldd	[%r18, 0x0132], %f26
	.word 0xf51da078  ! 2091: LDDF_I	ldd	[%r22, 0x0078], %f26
	.word 0xfa1ce1a7  ! 2092: LDD_I	ldd	[%r19 + 0x01a7], %r29
	.word 0xb7504000  ! 2094: RDPR_TNPC	<illegal instruction>
	.word 0x839460a0  ! 2096: WRPR_TNPC_I	wrpr	%r17, 0x00a0, %tnpc
	.word 0xf80c8000  ! 2100: LDUB_R	ldub	[%r18 + %r0], %r28
	.word 0xf204612b  ! 2101: LDUW_I	lduw	[%r17 + 0x012b], %r25
	.word 0xfd1dc000  ! 2107: LDDF_R	ldd	[%r23, %r0], %f30
hwintr_2_94:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_94), 16, 16)) -> intp(2, 0, c)
	.word 0xbb480000  ! 2109: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xb5510000  ! 2111: RDPR_TICK	<illegal instruction>
	.word 0xba1460f0  ! 2113: OR_I	or 	%r17, 0x00f0, %r29
	.word 0x8994a11d  ! 2115: WRPR_TICK_I	wrpr	%r18, 0x011d, %tick
	.word 0xf854c000  ! 2116: LDSH_R	ldsh	[%r19 + %r0], %r28
	.word 0xb751c000  ! 2122: RDPR_TL	<illegal instruction>
	.word 0xb0042131  ! 2123: ADD_I	add 	%r16, 0x0131, %r24
	.word 0xfc4c4000  ! 2124: LDSB_R	ldsb	[%r17 + %r0], %r30
	.word 0xb8858000  ! 2128: ADDcc_R	addcc 	%r22, %r0, %r28
	.word 0xfc05a17a  ! 2129: LDUW_I	lduw	[%r22 + 0x017a], %r30
	.word 0xb6248000  ! 2130: SUB_R	sub 	%r18, %r0, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982c1b  ! 2131: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c1b, %hpstate
	.word 0xf445a1ec  ! 2132: LDSW_I	ldsw	[%r22 + 0x01ec], %r26
	.word 0xf81561da  ! 2137: LDUH_I	lduh	[%r21 + 0x01da], %r28
	mov	0, %r12
	.word 0x8f932000  ! 2138: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfa058000  ! 2140: LDUW_R	lduw	[%r22 + %r0], %r29
	.word 0xf80521a8  ! 2141: LDUW_I	lduw	[%r20 + 0x01a8], %r28
hwintr_2_95:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_95), 16, 16)) -> intp(2, 0, 2b)
	.word 0xb434207d  ! 2143: SUBC_I	orn 	%r16, 0x007d, %r26
hwintr_2_96:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_96), 16, 16)) -> intp(2, 0, 1a)
	.word 0xfe5da012  ! 2146: LDX_I	ldx	[%r22 + 0x0012], %r31
	mov	0, %r14
	.word 0xa193a000  ! 2148: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf45cc000  ! 2149: LDX_R	ldx	[%r19 + %r0], %r26
	setx	data_start_6, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb5504000  ! 2156: RDPR_TNPC	<illegal instruction>
	mov	2, %r12
	.word 0x8f932000  ! 2161: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf2044000  ! 2166: LDUW_R	lduw	[%r17 + %r0], %r25
	.word 0x8595a118  ! 2167: WRPR_TSTATE_I	wrpr	%r22, 0x0118, %tstate
	.word 0xf6144000  ! 2168: LDUH_R	lduh	[%r17 + %r0], %r27
	.word 0xb7510000  ! 2173: RDPR_TICK	rdpr	%tick, %r27
	.word 0xf455c000  ! 2178: LDSH_R	ldsh	[%r23 + %r0], %r26
	.word 0xf01c8000  ! 2181: LDD_R	ldd	[%r18 + %r0], %r24
	.word 0x85946017  ! 2186: WRPR_TSTATE_I	wrpr	%r17, 0x0017, %tstate
	.word 0xf85de0ee  ! 2187: LDX_I	ldx	[%r23 + 0x00ee], %r28
	.word 0xf844c000  ! 2188: LDSW_R	ldsw	[%r19 + %r0], %r28
	.word 0xfc040000  ! 2190: LDUW_R	lduw	[%r16 + %r0], %r30
	.word 0xb7510000  ! 2192: RDPR_TICK	<illegal instruction>
hwintr_2_97:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_97), 16, 16)) -> intp(2, 0, f)
	mov	1, %r12
	.word 0x8f932000  ! 2202: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf214c000  ! 2206: LDUH_R	lduh	[%r19 + %r0], %r25
	.word 0xb9510000  ! 2207: RDPR_TICK	<illegal instruction>
hwintr_2_98:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_98), 16, 16)) -> intp(2, 0, 23)
	.word 0xf4158000  ! 2213: LDUH_R	lduh	[%r22 + %r0], %r26
	.word 0x8794a1c3  ! 2218: WRPR_TT_I	wrpr	%r18, 0x01c3, %tt
hwintr_2_99:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_99), 16, 16)) -> intp(2, 0, c)
	.word 0xfc0da033  ! 2225: LDUB_I	ldub	[%r22 + 0x0033], %r30
	.word 0xf00de15a  ! 2227: LDUB_I	ldub	[%r23 + 0x015a], %r24
	.word 0xbd508000  ! 2228: RDPR_TSTATE	<illegal instruction>
	.word 0xfb1c4000  ! 2229: LDDF_R	ldd	[%r17, %r0], %f29
	mov	0, %r12
	.word 0x8f932000  ! 2230: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_2_100:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_100), 16, 16)) -> intp(2, 0, 3)
	.word 0xbd2d1000  ! 2233: SLLX_R	sllx	%r20, %r0, %r30
	.word 0xf91d4000  ! 2238: LDDF_R	ldd	[%r21, %r0], %f28
	ta	T_CHANGE_HPRIV
	.word 0x81983fd9  ! 2240: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1fd9, %hpstate
hwintr_2_101:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_101), 16, 16)) -> intp(2, 0, e)
	.word 0xfc0dc000  ! 2242: LDUB_R	ldub	[%r23 + %r0], %r30
	.word 0xb5643801  ! 2246: MOVcc_I	<illegal instruction>
	.word 0xf64d8000  ! 2247: LDSB_R	ldsb	[%r22 + %r0], %r27
	.word 0xf65c4000  ! 2248: LDX_R	ldx	[%r17 + %r0], %r27
	.word 0xfe5d0000  ! 2253: LDX_R	ldx	[%r20 + %r0], %r31
	.word 0xb1643801  ! 2256: MOVcc_I	<illegal instruction>
	.word 0xbf50c000  ! 2258: RDPR_TT	<illegal instruction>
	.word 0xf014617f  ! 2259: LDUH_I	lduh	[%r17 + 0x017f], %r24
	.word 0xf80d21ef  ! 2262: LDUB_I	ldub	[%r20 + 0x01ef], %r28
	.word 0xf00461f3  ! 2268: LDUW_I	lduw	[%r17 + 0x01f3], %r24
hwintr_2_102:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_102), 16, 16)) -> intp(2, 0, 0)
hwintr_2_103:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_103), 16, 16)) -> intp(2, 0, 16)
	.word 0xb7504000  ! 2274: RDPR_TNPC	<illegal instruction>
	mov	1, %r14
	.word 0xa193a000  ! 2277: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xfe5420de  ! 2280: LDSH_I	ldsh	[%r16 + 0x00de], %r31
	.word 0xb6a44000  ! 2281: SUBcc_R	subcc 	%r17, %r0, %r27
hwintr_2_104:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_104), 16, 16)) -> intp(2, 0, 20)
	.word 0xf44ce019  ! 2284: LDSB_I	ldsb	[%r19 + 0x0019], %r26
	.word 0xf2142081  ! 2290: LDUH_I	lduh	[%r16 + 0x0081], %r25
	.word 0xb1500000  ! 2292: RDPR_TPC	<illegal instruction>
	.word 0xf11c0000  ! 2294: LDDF_R	ldd	[%r16, %r0], %f24
	.word 0xf41d4000  ! 2295: LDD_R	ldd	[%r21 + %r0], %r26
	.word 0xbe95e061  ! 2296: ORcc_I	orcc 	%r23, 0x0061, %r31
	.word 0xf4158000  ! 2300: LDUH_R	lduh	[%r22 + %r0], %r26
	.word 0xf60c4000  ! 2306: LDUB_R	ldub	[%r17 + %r0], %r27
	.word 0x8995e014  ! 2309: WRPR_TICK_I	wrpr	%r23, 0x0014, %tick
	.word 0xfe05a16f  ! 2314: LDUW_I	lduw	[%r22 + 0x016f], %r31
	.word 0x9195201e  ! 2317: WRPR_PIL_I	wrpr	%r20, 0x001e, %pil
	.word 0xf80d4000  ! 2318: LDUB_R	ldub	[%r21 + %r0], %r28
hwintr_2_105:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_105), 16, 16)) -> intp(2, 0, 25)
	ta	T_CHANGE_HPRIV
	.word 0x81982ec9  ! 2327: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0ec9, %hpstate
	.word 0xb1520000  ! 2332: RDPR_PIL	rdpr	%pil, %r24
	.word 0xf45d8000  ! 2333: LDX_R	ldx	[%r22 + %r0], %r26
	.word 0xbd504000  ! 2334: RDPR_TNPC	<illegal instruction>
hwintr_2_106:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_106), 16, 16)) -> intp(2, 0, 6)
	.word 0xbd508000  ! 2339: RDPR_TSTATE	<illegal instruction>
	.word 0xb3520000  ! 2341: RDPR_PIL	<illegal instruction>
	.word 0xf51d4000  ! 2344: LDDF_R	ldd	[%r21, %r0], %f26
hwintr_2_107:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_107), 16, 16)) -> intp(2, 0, 15)
	.word 0xf31c4000  ! 2350: LDDF_R	ldd	[%r17, %r0], %f25
	.word 0xbd508000  ! 2351: RDPR_TSTATE	<illegal instruction>
	.word 0xfa54a033  ! 2352: LDSH_I	ldsh	[%r18 + 0x0033], %r29
	.word 0xbaac0000  ! 2353: ANDNcc_R	andncc 	%r16, %r0, %r29
	.word 0xbb50c000  ! 2355: RDPR_TT	<illegal instruction>
hwintr_2_108:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_108), 16, 16)) -> intp(2, 0, 34)
	ta	T_CHANGE_HPRIV
	.word 0x81983a11  ! 2358: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a11, %hpstate
	.word 0xb4a46091  ! 2361: SUBcc_I	subcc 	%r17, 0x0091, %r26
	.word 0xb284a0db  ! 2365: ADDcc_I	addcc 	%r18, 0x00db, %r25
	mov	2, %r12
	.word 0x8f932000  ! 2367: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb3504000  ! 2369: RDPR_TNPC	<illegal instruction>
	.word 0x8594601f  ! 2371: WRPR_TSTATE_I	wrpr	%r17, 0x001f, %tstate
	.word 0xfc54c000  ! 2373: LDSH_R	ldsh	[%r19 + %r0], %r30
	.word 0xf64ce1e4  ! 2377: LDSB_I	ldsb	[%r19 + 0x01e4], %r27
	.word 0xfe5da050  ! 2382: LDX_I	ldx	[%r22 + 0x0050], %r31
	.word 0xbe9dc000  ! 2385: XORcc_R	xorcc 	%r23, %r0, %r31
	.word 0xfc04c000  ! 2387: LDUW_R	lduw	[%r19 + %r0], %r30
	.word 0x8d95e1e1  ! 2388: WRPR_PSTATE_I	wrpr	%r23, 0x01e1, %pstate
	.word 0xb12c2001  ! 2389: SLL_I	sll 	%r16, 0x0001, %r24
	.word 0xfc1ca1dc  ! 2390: LDD_I	ldd	[%r18 + 0x01dc], %r30
	.word 0xb33c6001  ! 2392: SRA_I	sra 	%r17, 0x0001, %r25
	.word 0xb0242013  ! 2393: SUB_I	sub 	%r16, 0x0013, %r24
	.word 0xb0156078  ! 2395: OR_I	or 	%r21, 0x0078, %r24
	.word 0xbc34c000  ! 2397: ORN_R	orn 	%r19, %r0, %r30
	.word 0xb550c000  ! 2405: RDPR_TT	<illegal instruction>
	.word 0xf04521c5  ! 2408: LDSW_I	ldsw	[%r20 + 0x01c5], %r24
	.word 0xf81ca013  ! 2417: LDD_I	ldd	[%r18 + 0x0013], %r28
hwintr_2_109:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_109), 16, 16)) -> intp(2, 0, 3d)
	.word 0xf255c000  ! 2423: LDSH_R	ldsh	[%r23 + %r0], %r25
	.word 0xf00560ce  ! 2426: LDUW_I	lduw	[%r21 + 0x00ce], %r24
	mov	1, %r14
	.word 0xa193a000  ! 2427: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf91da08f  ! 2432: LDDF_I	ldd	[%r22, 0x008f], %f28
	.word 0xb62c6071  ! 2434: ANDN_I	andn 	%r17, 0x0071, %r27
	.word 0xf8454000  ! 2440: LDSW_R	ldsw	[%r21 + %r0], %r28
	.word 0xf804a10f  ! 2443: LDUW_I	lduw	[%r18 + 0x010f], %r28
	.word 0xfc040000  ! 2449: LDUW_R	lduw	[%r16 + %r0], %r30
	.word 0xbea56165  ! 2454: SUBcc_I	subcc 	%r21, 0x0165, %r31
	.word 0xf60d2155  ! 2455: LDUB_I	ldub	[%r20 + 0x0155], %r27
hwintr_2_110:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_110), 16, 16)) -> intp(2, 0, 14)
	.word 0xbd508000  ! 2462: RDPR_TSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81982e1b  ! 2464: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e1b, %hpstate
	.word 0xfc150000  ! 2466: LDUH_R	lduh	[%r20 + %r0], %r30
	.word 0x899561c5  ! 2467: WRPR_TICK_I	wrpr	%r21, 0x01c5, %tick
	.word 0xb2b50000  ! 2468: ORNcc_R	orncc 	%r20, %r0, %r25
	.word 0xbb480000  ! 2474: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xb350c000  ! 2475: RDPR_TT	<illegal instruction>
hwintr_2_111:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_111), 16, 16)) -> intp(2, 0, c)
	.word 0xb9510000  ! 2478: RDPR_TICK	<illegal instruction>
	.word 0x899421ec  ! 2479: WRPR_TICK_I	wrpr	%r16, 0x01ec, %tick
hwintr_2_112:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_112), 16, 16)) -> intp(2, 0, 2d)
	.word 0xf40560c5  ! 2484: LDUW_I	lduw	[%r21 + 0x00c5], %r26
	.word 0xbd504000  ! 2485: RDPR_TNPC	<illegal instruction>
	.word 0xfa5d6157  ! 2486: LDX_I	ldx	[%r21 + 0x0157], %r29
hwintr_2_113:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_113), 16, 16)) -> intp(2, 0, 1d)
	.word 0xfa55c000  ! 2493: LDSH_R	ldsh	[%r23 + %r0], %r29
	.word 0xf2048000  ! 2495: LDUW_R	lduw	[%r18 + %r0], %r25
	.word 0xf2144000  ! 2498: LDUH_R	lduh	[%r17 + %r0], %r25
hwintr_2_114:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_114), 16, 16)) -> intp(2, 0, 35)
	.word 0xfc042035  ! 2500: LDUW_I	lduw	[%r16 + 0x0035], %r30
	.word 0xf2554000  ! 2501: LDSH_R	ldsh	[%r21 + %r0], %r25
	.word 0xff1c0000  ! 2502: LDDF_R	ldd	[%r16, %r0], %f31
	.word 0xbd500000  ! 2503: RDPR_TPC	<illegal instruction>
	.word 0xfe5d21f1  ! 2504: LDX_I	ldx	[%r20 + 0x01f1], %r31
	.word 0xf84d0000  ! 2508: LDSB_R	ldsb	[%r20 + %r0], %r28
	.word 0xfa14c000  ! 2511: LDUH_R	lduh	[%r19 + %r0], %r29
	.word 0xfb1c0000  ! 2512: LDDF_R	ldd	[%r16, %r0], %f29
	mov	2, %r14
	.word 0xa193a000  ! 2513: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8195e0d5  ! 2514: WRPR_TPC_I	wrpr	%r23, 0x00d5, %tpc
	.word 0xf04ca1f6  ! 2519: LDSB_I	ldsb	[%r18 + 0x01f6], %r24
	.word 0xbb3c1000  ! 2520: SRAX_R	srax	%r16, %r0, %r29
	.word 0xf65d4000  ! 2523: LDX_R	ldx	[%r21 + %r0], %r27
	.word 0xf91c6196  ! 2526: LDDF_I	ldd	[%r17, 0x0196], %f28
	.word 0xf2058000  ! 2528: LDUW_R	lduw	[%r22 + %r0], %r25
	.word 0xf20d61da  ! 2534: LDUB_I	ldub	[%r21 + 0x01da], %r25
	.word 0xf45c4000  ! 2535: LDX_R	ldx	[%r17 + %r0], %r26
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xf51d20be  ! 2540: LDDF_I	ldd	[%r20, 0x00be], %f26
	.word 0xf91ca1b1  ! 2541: LDDF_I	ldd	[%r18, 0x01b1], %f28
	.word 0xf004c000  ! 2542: LDUW_R	lduw	[%r19 + %r0], %r24
	.word 0xfe5d6026  ! 2544: LDX_I	ldx	[%r21 + 0x0026], %r31
hwintr_2_115:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_115), 16, 16)) -> intp(2, 0, 2)
	.word 0xf8050000  ! 2549: LDUW_R	lduw	[%r20 + %r0], %r28
	mov	0, %r12
	.word 0x8f932000  ! 2557: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf4158000  ! 2558: LDUH_R	lduh	[%r22 + %r0], %r26
	.word 0xfc04e1d8  ! 2559: LDUW_I	lduw	[%r19 + 0x01d8], %r30
	.word 0xf01d8000  ! 2562: LDD_R	ldd	[%r22 + %r0], %r24
	.word 0xbd3cb001  ! 2563: SRAX_I	srax	%r18, 0x0001, %r30
	.word 0xb4c58000  ! 2565: ADDCcc_R	addccc 	%r22, %r0, %r26
	.word 0x8194a0ff  ! 2572: WRPR_TPC_I	wrpr	%r18, 0x00ff, %tpc
hwintr_2_116:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_116), 16, 16)) -> intp(2, 0, 38)
	.word 0xfa444000  ! 2574: LDSW_R	ldsw	[%r17 + %r0], %r29
	.word 0xb005200f  ! 2577: ADD_I	add 	%r20, 0x000f, %r24
	.word 0xb9508000  ! 2584: RDPR_TSTATE	rdpr	%tstate, %r28
	.word 0xbcb4a0d0  ! 2592: ORNcc_I	orncc 	%r18, 0x00d0, %r30
hwintr_2_117:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_117), 16, 16)) -> intp(2, 0, 2b)
	.word 0xf64d8000  ! 2596: LDSB_R	ldsb	[%r22 + %r0], %r27
	.word 0xfc14e1b2  ! 2602: LDUH_I	lduh	[%r19 + 0x01b2], %r30
	.word 0xfb1da06f  ! 2603: LDDF_I	ldd	[%r22, 0x006f], %f29
	.word 0xf20d8000  ! 2605: LDUB_R	ldub	[%r22 + %r0], %r25
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81983e53  ! 2607: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e53, %hpstate
	.word 0xbb50c000  ! 2608: RDPR_TT	<illegal instruction>
	.word 0xbd520000  ! 2610: RDPR_PIL	<illegal instruction>
	.word 0xfe446155  ! 2611: LDSW_I	ldsw	[%r17 + 0x0155], %r31
	.word 0xfe1c8000  ! 2614: LDD_R	ldd	[%r18 + %r0], %r31
hwintr_2_118:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_118), 16, 16)) -> intp(2, 0, 12)
	.word 0xf245c000  ! 2616: LDSW_R	ldsw	[%r23 + %r0], %r25
hwintr_2_119:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_119), 16, 16)) -> intp(2, 0, 2a)
	.word 0xb82cc000  ! 2619: ANDN_R	andn 	%r19, %r0, %r28
hwintr_2_120:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_120), 16, 16)) -> intp(2, 0, 17)
	.word 0xbc040000  ! 2623: ADD_R	add 	%r16, %r0, %r30
	.word 0xf25d0000  ! 2625: LDX_R	ldx	[%r20 + %r0], %r25
	.word 0xf11c0000  ! 2626: LDDF_R	ldd	[%r16, %r0], %f24
hwintr_2_121:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_121), 16, 16)) -> intp(2, 0, 38)
	.word 0xbb540000  ! 2633: RDPR_GL	<illegal instruction>
	.word 0xb49da13b  ! 2635: XORcc_I	xorcc 	%r22, 0x013b, %r26
	.word 0xf2148000  ! 2636: LDUH_R	lduh	[%r18 + %r0], %r25
	.word 0xfc5d8000  ! 2637: LDX_R	ldx	[%r22 + %r0], %r30
	.word 0xf65c619b  ! 2638: LDX_I	ldx	[%r17 + 0x019b], %r27
	ta	T_CHANGE_HPRIV
	.word 0x819838cb  ! 2640: WRHPR_HPSTATE_I	wrhpr	%r0, 0x18cb, %hpstate
hwintr_2_122:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_122), 16, 16)) -> intp(2, 0, 34)
	.word 0xfc0420b0  ! 2645: LDUW_I	lduw	[%r16 + 0x00b0], %r30
	.word 0xf845c000  ! 2646: LDSW_R	ldsw	[%r23 + %r0], %r28
	.word 0xbd480000  ! 2648: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xfe1da096  ! 2649: LDD_I	ldd	[%r22 + 0x0096], %r31
hwintr_2_123:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_123), 16, 16)) -> intp(2, 0, 3)
	.word 0xbb500000  ! 2653: RDPR_TPC	<illegal instruction>
	.word 0xfd1d4000  ! 2654: LDDF_R	ldd	[%r21, %r0], %f30
hwintr_2_124:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_124), 16, 16)) -> intp(2, 0, 29)
	.word 0xf20ca00d  ! 2659: LDUB_I	ldub	[%r18 + 0x000d], %r25
hwintr_2_125:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_125), 16, 16)) -> intp(2, 0, 12)
	.word 0xb0c5c000  ! 2662: ADDCcc_R	addccc 	%r23, %r0, %r24
	.word 0xb9480000  ! 2665: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xb0154000  ! 2670: OR_R	or 	%r21, %r0, %r24
	.word 0xb535a001  ! 2671: SRL_I	srl 	%r22, 0x0001, %r26
	.word 0xf71c8000  ! 2672: LDDF_R	ldd	[%r18, %r0], %f27
	.word 0xf11d0000  ! 2673: LDDF_R	ldd	[%r20, %r0], %f24
	.word 0xfc55e071  ! 2678: LDSH_I	ldsh	[%r23 + 0x0071], %r30
	setx	data_start_3, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf00d205c  ! 2684: LDUB_I	ldub	[%r20 + 0x005c], %r24
	.word 0xb3520000  ! 2689: RDPR_PIL	<illegal instruction>
	.word 0xb02d8000  ! 2690: ANDN_R	andn 	%r22, %r0, %r24
	setx	data_start_5, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfe45c000  ! 2697: LDSW_R	ldsw	[%r23 + %r0], %r31
	.word 0xfc4d4000  ! 2699: LDSB_R	ldsb	[%r21 + %r0], %r30
	.word 0xf244a0e2  ! 2700: LDSW_I	ldsw	[%r18 + 0x00e2], %r25
	setx	data_start_4, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb13c0000  ! 2705: SRA_R	sra 	%r16, %r0, %r24
	.word 0xf45c8000  ! 2706: LDX_R	ldx	[%r18 + %r0], %r26
	.word 0xfa542053  ! 2707: LDSH_I	ldsh	[%r16 + 0x0053], %r29
	.word 0xb97c6401  ! 2709: MOVR_I	movre	%r17, 0x1, %r28
	.word 0xf41ca03f  ! 2712: LDD_I	ldd	[%r18 + 0x003f], %r26
	.word 0xfe54c000  ! 2713: LDSH_R	ldsh	[%r19 + %r0], %r31
	.word 0xb1480000  ! 2716: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xf85ca1f4  ! 2719: LDX_I	ldx	[%r18 + 0x01f4], %r28
	.word 0xb42d6119  ! 2720: ANDN_I	andn 	%r21, 0x0119, %r26
	.word 0xfa440000  ! 2724: LDSW_R	ldsw	[%r16 + %r0], %r29
	.word 0xf6556001  ! 2729: LDSH_I	ldsh	[%r21 + 0x0001], %r27
	.word 0xfe4dc000  ! 2730: LDSB_R	ldsb	[%r23 + %r0], %r31
	.word 0xf255e1ec  ! 2731: LDSH_I	ldsh	[%r23 + 0x01ec], %r25
	.word 0xf055616d  ! 2732: LDSH_I	ldsh	[%r21 + 0x016d], %r24
	.word 0x839461ca  ! 2735: WRPR_TNPC_I	wrpr	%r17, 0x01ca, %tnpc
	.word 0x8d942065  ! 2737: WRPR_PSTATE_I	wrpr	%r16, 0x0065, %pstate
	.word 0xb53dd000  ! 2739: SRAX_R	srax	%r23, %r0, %r26
	.word 0xfb1c61ad  ! 2741: LDDF_I	ldd	[%r17, 0x01ad], %f29
	.word 0xfc0c0000  ! 2743: LDUB_R	ldub	[%r16 + %r0], %r30
hwintr_2_126:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_126), 16, 16)) -> intp(2, 0, 34)
	.word 0x879560bc  ! 2749: WRPR_TT_I	wrpr	%r21, 0x00bc, %tt
	.word 0xf85d0000  ! 2752: LDX_R	ldx	[%r20 + %r0], %r28
	.word 0xbec420ea  ! 2758: ADDCcc_I	addccc 	%r16, 0x00ea, %r31
	.word 0xfa4de01b  ! 2761: LDSB_I	ldsb	[%r23 + 0x001b], %r29
	.word 0xf24c4000  ! 2763: LDSB_R	ldsb	[%r17 + %r0], %r25
	.word 0x839420f7  ! 2764: WRPR_TNPC_I	wrpr	%r16, 0x00f7, %tnpc
	.word 0xfe5c4000  ! 2765: LDX_R	ldx	[%r17 + %r0], %r31
hwintr_2_127:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_127), 16, 16)) -> intp(2, 0, 26)
	.word 0xfc0c200d  ! 2768: LDUB_I	ldub	[%r16 + 0x000d], %r30
hwintr_2_128:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_128), 16, 16)) -> intp(2, 0, 2f)
	.word 0xb2a44000  ! 2772: SUBcc_R	subcc 	%r17, %r0, %r25
	setx	data_start_2, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	setx	data_start_7, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa154000  ! 2779: LDUH_R	lduh	[%r21 + %r0], %r29
	.word 0xf6058000  ! 2780: LDUW_R	lduw	[%r22 + %r0], %r27
	.word 0xff1d0000  ! 2787: LDDF_R	ldd	[%r20, %r0], %f31
	.word 0x87952034  ! 2789: WRPR_TT_I	wrpr	%r20, 0x0034, %tt
	.word 0xbf480000  ! 2792: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
hwintr_2_129:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_129), 16, 16)) -> intp(2, 0, 30)
	.word 0xfc1d6094  ! 2795: LDD_I	ldd	[%r21 + 0x0094], %r30
	.word 0xf61c0000  ! 2801: LDD_R	ldd	[%r16 + %r0], %r27
	.word 0xfc5c8000  ! 2802: LDX_R	ldx	[%r18 + %r0], %r30
	.word 0xf8152141  ! 2803: LDUH_I	lduh	[%r20 + 0x0141], %r28
	.word 0xfe0d4000  ! 2804: LDUB_R	ldub	[%r21 + %r0], %r31
	.word 0xbe354000  ! 2805: ORN_R	orn 	%r21, %r0, %r31
	.word 0xf24420ed  ! 2808: LDSW_I	ldsw	[%r16 + 0x00ed], %r25
hwintr_2_130:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_130), 16, 16)) -> intp(2, 0, 30)
	.word 0xfe1460f7  ! 2813: LDUH_I	lduh	[%r17 + 0x00f7], %r31
	.word 0xb9510000  ! 2817: RDPR_TICK	<illegal instruction>
	.word 0xf6548000  ! 2819: LDSH_R	ldsh	[%r18 + %r0], %r27
	.word 0xf205e151  ! 2821: LDUW_I	lduw	[%r23 + 0x0151], %r25
	.word 0x87946101  ! 2822: WRPR_TT_I	wrpr	%r17, 0x0101, %tt
hwintr_2_131:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_131), 16, 16)) -> intp(2, 0, 1a)
	.word 0x8795213b  ! 2829: WRPR_TT_I	wrpr	%r20, 0x013b, %tt
	.word 0xfe15c000  ! 2830: LDUH_R	lduh	[%r23 + %r0], %r31
	.word 0xfa154000  ! 2833: LDUH_R	lduh	[%r21 + %r0], %r29
	.word 0xfe1ca1dc  ! 2834: LDD_I	ldd	[%r18 + 0x01dc], %r31
	.word 0xf8044000  ! 2837: LDUW_R	lduw	[%r17 + %r0], %r28
	.word 0xb6a4e06b  ! 2838: SUBcc_I	subcc 	%r19, 0x006b, %r27
	.word 0xf80d4000  ! 2843: LDUB_R	ldub	[%r21 + %r0], %r28
	.word 0xbf520000  ! 2844: RDPR_PIL	rdpr	%pil, %r31
	setx	data_start_5, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf31c61e9  ! 2849: LDDF_I	ldd	[%r17, 0x01e9], %f25
	.word 0xb7358000  ! 2851: SRL_R	srl 	%r22, %r0, %r27
	.word 0xb89de016  ! 2854: XORcc_I	xorcc 	%r23, 0x0016, %r28
	.word 0x8d946061  ! 2860: WRPR_PSTATE_I	wrpr	%r17, 0x0061, %pstate
	.word 0xf40ce1ef  ! 2861: LDUB_I	ldub	[%r19 + 0x01ef], %r26
	.word 0xb8c4e0f3  ! 2867: ADDCcc_I	addccc 	%r19, 0x00f3, %r28
	.word 0xf81ce1c0  ! 2870: LDD_I	ldd	[%r19 + 0x01c0], %r28
	.word 0xfa5d8000  ! 2872: LDX_R	ldx	[%r22 + %r0], %r29
	.word 0xb2c52074  ! 2874: ADDCcc_I	addccc 	%r20, 0x0074, %r25
	.word 0xf45c4000  ! 2876: LDX_R	ldx	[%r17 + %r0], %r26
	.word 0xb48461ee  ! 2877: ADDcc_I	addcc 	%r17, 0x01ee, %r26
	.word 0xfe05e115  ! 2878: LDUW_I	lduw	[%r23 + 0x0115], %r31
	.word 0xfe0d20d6  ! 2879: LDUB_I	ldub	[%r20 + 0x00d6], %r31
	.word 0xf244601d  ! 2880: LDSW_I	ldsw	[%r17 + 0x001d], %r25
	setx	data_start_3, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_2_132:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_132), 16, 16)) -> intp(2, 0, 15)
	.word 0x8195e191  ! 2886: WRPR_TPC_I	wrpr	%r23, 0x0191, %tpc
hwintr_2_133:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_133), 16, 16)) -> intp(2, 0, 37)
	.word 0xfb1c0000  ! 2889: LDDF_R	ldd	[%r16, %r0], %f29
	.word 0xfa4c219a  ! 2890: LDSB_I	ldsb	[%r16 + 0x019a], %r29
	.word 0xb7500000  ! 2892: RDPR_TPC	<illegal instruction>
	.word 0xf85c8000  ! 2893: LDX_R	ldx	[%r18 + %r0], %r28
	.word 0x8d956118  ! 2894: WRPR_PSTATE_I	wrpr	%r21, 0x0118, %pstate
	.word 0xf64d4000  ! 2896: LDSB_R	ldsb	[%r21 + %r0], %r27
	.word 0xb48da028  ! 2897: ANDcc_I	andcc 	%r22, 0x0028, %r26
	.word 0x8d95609b  ! 2898: WRPR_PSTATE_I	wrpr	%r21, 0x009b, %pstate
	.word 0xb9520000  ! 2899: RDPR_PIL	<illegal instruction>
	.word 0xf00d8000  ! 2900: LDUB_R	ldub	[%r22 + %r0], %r24
	.word 0xf6444000  ! 2901: LDSW_R	ldsw	[%r17 + %r0], %r27
	.word 0xf615c000  ! 2905: LDUH_R	lduh	[%r23 + %r0], %r27
	.word 0xb9508000  ! 2907: RDPR_TSTATE	rdpr	%tstate, %r28
hwintr_2_134:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_134), 16, 16)) -> intp(2, 0, 35)
	.word 0xfe1da1e3  ! 2911: LDD_I	ldd	[%r22 + 0x01e3], %r31
	.word 0xf60de0b7  ! 2914: LDUB_I	ldub	[%r23 + 0x00b7], %r27
	.word 0xfe5d0000  ! 2918: LDX_R	ldx	[%r20 + %r0], %r31
	.word 0xfe4c0000  ! 2921: LDSB_R	ldsb	[%r16 + %r0], %r31
	.word 0xf81ce0de  ! 2922: LDD_I	ldd	[%r19 + 0x00de], %r28
	.word 0xf2054000  ! 2926: LDUW_R	lduw	[%r21 + %r0], %r25
	.word 0xf2042047  ! 2929: LDUW_I	lduw	[%r16 + 0x0047], %r25
	.word 0xfc558000  ! 2934: LDSH_R	ldsh	[%r22 + %r0], %r30
	.word 0xb7510000  ! 2936: RDPR_TICK	<illegal instruction>
	mov	0, %r14
	.word 0xa193a000  ! 2940: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	ta	T_CHANGE_HPRIV
	.word 0x81982a4b  ! 2941: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a4b, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81983f01  ! 2942: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f01, %hpstate
	.word 0xb53cb001  ! 2951: SRAX_I	srax	%r18, 0x0001, %r26
hwintr_2_135:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_135), 16, 16)) -> intp(2, 0, 20)
	.word 0xbf504000  ! 2956: RDPR_TNPC	<illegal instruction>
	.word 0xf0154000  ! 2959: LDUH_R	lduh	[%r21 + %r0], %r24
hwintr_2_136:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_136), 16, 16)) -> intp(2, 0, 1e)
	.word 0xb5504000  ! 2969: RDPR_TNPC	<illegal instruction>
hwintr_2_137:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_137), 16, 16)) -> intp(2, 0, 1b)
	.word 0xf21de06e  ! 2975: LDD_I	ldd	[%r23 + 0x006e], %r25
	ta	T_CHANGE_HPRIV
	.word 0x81983a01  ! 2978: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a01, %hpstate
	.word 0xfe0de153  ! 2979: LDUB_I	ldub	[%r23 + 0x0153], %r31
	.word 0xbe242113  ! 2980: SUB_I	sub 	%r16, 0x0113, %r31
	.word 0xf0150000  ! 2983: LDUH_R	lduh	[%r20 + %r0], %r24
	.word 0xbb508000  ! 2989: RDPR_TSTATE	<illegal instruction>
	.word 0x8995a0c3  ! 2992: WRPR_TICK_I	wrpr	%r22, 0x00c3, %tick
	.word 0xb9510000  ! 2993: RDPR_TICK	<illegal instruction>
	.word 0xb6bca048  ! 2994: XNORcc_I	xnorcc 	%r18, 0x0048, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982fd3  ! 3000: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0fd3, %hpstate
	.word 0xb235e095  ! 3004: ORN_I	orn 	%r23, 0x0095, %r25
hwintr_2_138:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_138), 16, 16)) -> intp(2, 0, e)
	.word 0xb5520000  ! 3006: RDPR_PIL	rdpr	%pil, %r26
	.word 0xf31de0b1  ! 3007: LDDF_I	ldd	[%r23, 0x00b1], %f25
	.word 0xb2c54000  ! 3009: ADDCcc_R	addccc 	%r21, %r0, %r25
	.word 0xf60da0fd  ! 3014: LDUB_I	ldub	[%r22 + 0x00fd], %r27
	.word 0x819561f5  ! 3016: WRPR_TPC_I	wrpr	%r21, 0x01f5, %tpc
	.word 0x8395e03f  ! 3017: WRPR_TNPC_I	wrpr	%r23, 0x003f, %tnpc
	.word 0xbd500000  ! 3022: RDPR_TPC	rdpr	%tpc, %r30
	.word 0xb7520000  ! 3023: RDPR_PIL	<illegal instruction>
	.word 0xf31de047  ! 3024: LDDF_I	ldd	[%r23, 0x0047], %f25
	.word 0xf31dc000  ! 3025: LDDF_R	ldd	[%r23, %r0], %f25
	.word 0xf80420ce  ! 3039: LDUW_I	lduw	[%r16 + 0x00ce], %r28
	setx	data_start_2, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfe4cc000  ! 3044: LDSB_R	ldsb	[%r19 + %r0], %r31
	.word 0xf4142146  ! 3046: LDUH_I	lduh	[%r16 + 0x0146], %r26
	.word 0xf4440000  ! 3051: LDSW_R	ldsw	[%r16 + %r0], %r26
	.word 0x819421f5  ! 3052: WRPR_TPC_I	wrpr	%r16, 0x01f5, %tpc
	.word 0xbd504000  ! 3054: RDPR_TNPC	<illegal instruction>
	.word 0xb5508000  ! 3057: RDPR_TSTATE	<illegal instruction>
	.word 0xfa154000  ! 3059: LDUH_R	lduh	[%r21 + %r0], %r29
	.word 0xf04d4000  ! 3060: LDSB_R	ldsb	[%r21 + %r0], %r24
	setx	data_start_2, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf11c0000  ! 3065: LDDF_R	ldd	[%r16, %r0], %f24
	.word 0xfc558000  ! 3066: LDSH_R	ldsh	[%r22 + %r0], %r30
	.word 0x8994e16f  ! 3071: WRPR_TICK_I	wrpr	%r19, 0x016f, %tick
	.word 0xb17ca401  ! 3074: MOVR_I	movre	%r18, 0x1, %r24
	.word 0xfa456037  ! 3076: LDSW_I	ldsw	[%r21 + 0x0037], %r29
hwintr_2_139:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_139), 16, 16)) -> intp(2, 0, 6)
	.word 0x8d94203f  ! 3078: WRPR_PSTATE_I	wrpr	%r16, 0x003f, %pstate
	.word 0xf64dc000  ! 3080: LDSB_R	ldsb	[%r23 + %r0], %r27
	mov	2, %r14
	.word 0xa193a000  ! 3083: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfe150000  ! 3088: LDUH_R	lduh	[%r20 + %r0], %r31
	.word 0x8995e17d  ! 3091: WRPR_TICK_I	wrpr	%r23, 0x017d, %tick
	.word 0xf4540000  ! 3094: LDSH_R	ldsh	[%r16 + %r0], %r26
	.word 0xf4544000  ! 3095: LDSH_R	ldsh	[%r17 + %r0], %r26
	.word 0xbf51c000  ! 3097: RDPR_TL	<illegal instruction>
hwintr_2_140:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_140), 16, 16)) -> intp(2, 0, 26)
	mov	1, %r12
	.word 0x8f932000  ! 3101: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbc2de18a  ! 3106: ANDN_I	andn 	%r23, 0x018a, %r30
	.word 0xf4150000  ! 3107: LDUH_R	lduh	[%r20 + %r0], %r26
	.word 0xfc5c0000  ! 3118: LDX_R	ldx	[%r16 + %r0], %r30
hwintr_2_141:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_141), 16, 16)) -> intp(2, 0, 30)
	.word 0xb17de401  ! 3121: MOVR_I	movre	%r23, 0x1, %r24
	.word 0xf84c601a  ! 3125: LDSB_I	ldsb	[%r17 + 0x001a], %r28
	.word 0xfc0c0000  ! 3127: LDUB_R	ldub	[%r16 + %r0], %r30
	.word 0xb7518000  ! 3135: RDPR_PSTATE	<illegal instruction>
	.word 0xf51c219c  ! 3137: LDDF_I	ldd	[%r16, 0x019c], %f26
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xfe54c000  ! 3140: LDSH_R	ldsh	[%r19 + %r0], %r31
	.word 0xf455c000  ! 3143: LDSH_R	ldsh	[%r23 + %r0], %r26
	.word 0xb485e096  ! 3145: ADDcc_I	addcc 	%r23, 0x0096, %r26
	.word 0xbf7c0400  ! 3146: MOVR_R	movre	%r16, %r0, %r31
	.word 0xfc0ca09b  ! 3150: LDUB_I	ldub	[%r18 + 0x009b], %r30
	.word 0xfa0c6096  ! 3151: LDUB_I	ldub	[%r17 + 0x0096], %r29
	.word 0x8194a05f  ! 3152: WRPR_TPC_I	wrpr	%r18, 0x005f, %tpc
	.word 0xf6140000  ! 3156: LDUH_R	lduh	[%r16 + %r0], %r27
	.word 0xf404c000  ! 3157: LDUW_R	lduw	[%r19 + %r0], %r26
	.word 0xfe4ce0b2  ! 3158: LDSB_I	ldsb	[%r19 + 0x00b2], %r31
hwintr_2_142:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_142), 16, 16)) -> intp(2, 0, 0)
	.word 0xfe4c20cb  ! 3161: LDSB_I	ldsb	[%r16 + 0x00cb], %r31
	.word 0xfe54a179  ! 3164: LDSH_I	ldsh	[%r18 + 0x0179], %r31
	.word 0xbc1cc000  ! 3165: XOR_R	xor 	%r19, %r0, %r30
	.word 0xfa05c000  ! 3166: LDUW_R	lduw	[%r23 + %r0], %r29
	.word 0xf40561b1  ! 3169: LDUW_I	lduw	[%r21 + 0x01b1], %r26
	.word 0xb3504000  ! 3170: RDPR_TNPC	<illegal instruction>
	.word 0x8d9560e6  ! 3171: WRPR_PSTATE_I	wrpr	%r21, 0x00e6, %pstate
	.word 0xf84c0000  ! 3172: LDSB_R	ldsb	[%r16 + %r0], %r28
	.word 0xf61d0000  ! 3179: LDD_R	ldd	[%r20 + %r0], %r27
	.word 0xfb1d0000  ! 3180: LDDF_R	ldd	[%r20, %r0], %f29
	setx	data_start_7, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf71c8000  ! 3187: LDDF_R	ldd	[%r18, %r0], %f27
hwintr_2_143:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_143), 16, 16)) -> intp(2, 0, 30)
	.word 0xfe0d8000  ! 3189: LDUB_R	ldub	[%r22 + %r0], %r31
	.word 0x8d956004  ! 3191: WRPR_PSTATE_I	wrpr	%r21, 0x0004, %pstate
	.word 0xb7510000  ! 3196: RDPR_TICK	<illegal instruction>
hwintr_2_144:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_144), 16, 16)) -> intp(2, 0, 16)
	.word 0xf015a1b8  ! 3199: LDUH_I	lduh	[%r22 + 0x01b8], %r24
	.word 0xb5500000  ! 3200: RDPR_TPC	<illegal instruction>
	.word 0xf80dc000  ! 3201: LDUB_R	ldub	[%r23 + %r0], %r28
	.word 0xf04c4000  ! 3204: LDSB_R	ldsb	[%r17 + %r0], %r24
	.word 0xfa55a0d8  ! 3213: LDSH_I	ldsh	[%r22 + 0x00d8], %r29
	.word 0x8794611e  ! 3215: WRPR_TT_I	wrpr	%r17, 0x011e, %tt
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xfe5d60e2  ! 3218: LDX_I	ldx	[%r21 + 0x00e2], %r31
	.word 0xfa5c8000  ! 3219: LDX_R	ldx	[%r18 + %r0], %r29
	.word 0xfe55e137  ! 3221: LDSH_I	ldsh	[%r23 + 0x0137], %r31
	.word 0xbb508000  ! 3222: RDPR_TSTATE	<illegal instruction>
	.word 0xf71d8000  ! 3224: LDDF_R	ldd	[%r22, %r0], %f27
	setx	data_start_7, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf8046050  ! 3228: LDUW_I	lduw	[%r17 + 0x0050], %r28
hwintr_2_145:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_145), 16, 16)) -> intp(2, 0, 22)
	setx	data_start_0, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf80da09c  ! 3234: LDUB_I	ldub	[%r22 + 0x009c], %r28
	.word 0xbf3da001  ! 3239: SRA_I	sra 	%r22, 0x0001, %r31
	.word 0x8795e184  ! 3241: WRPR_TT_I	wrpr	%r23, 0x0184, %tt
	.word 0xfe45a0dc  ! 3243: LDSW_I	ldsw	[%r22 + 0x00dc], %r31
	.word 0xb89d2147  ! 3245: XORcc_I	xorcc 	%r20, 0x0147, %r28
	.word 0xbf540000  ! 3247: RDPR_GL	<illegal instruction>
	.word 0x81946157  ! 3250: WRPR_TPC_I	wrpr	%r17, 0x0157, %tpc
	.word 0xf0054000  ! 3251: LDUW_R	lduw	[%r21 + %r0], %r24
	.word 0xb77c8400  ! 3254: MOVR_R	movre	%r18, %r0, %r27
	mov	2, %r14
	.word 0xa193a000  ! 3260: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8994219c  ! 3265: WRPR_TICK_I	wrpr	%r16, 0x019c, %tick
	.word 0xf644a078  ! 3267: LDSW_I	ldsw	[%r18 + 0x0078], %r27
	mov	1, %r14
	.word 0xa193a000  ! 3269: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb6acc000  ! 3270: ANDNcc_R	andncc 	%r19, %r0, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982911  ! 3271: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0911, %hpstate
	.word 0xb951c000  ! 3274: RDPR_TL	<illegal instruction>
hwintr_2_146:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_146), 16, 16)) -> intp(2, 0, 16)
	.word 0xf4148000  ! 3277: LDUH_R	lduh	[%r18 + %r0], %r26
	.word 0x8394e140  ! 3278: WRPR_TNPC_I	wrpr	%r19, 0x0140, %tnpc
	.word 0xfe0c8000  ! 3279: LDUB_R	ldub	[%r18 + %r0], %r31
hwintr_2_147:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_147), 16, 16)) -> intp(2, 0, 38)
	.word 0xf91d6014  ! 3284: LDDF_I	ldd	[%r21, 0x0014], %f28
hwintr_2_148:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_148), 16, 16)) -> intp(2, 0, 2f)
hwintr_2_149:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_149), 16, 16)) -> intp(2, 0, 12)
	setx	data_start_1, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_2_150:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_150), 16, 16)) -> intp(2, 0, 2f)
	.word 0xf25c60e6  ! 3299: LDX_I	ldx	[%r17 + 0x00e6], %r25
hwintr_2_151:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_151), 16, 16)) -> intp(2, 0, 2a)
	.word 0xf45da189  ! 3303: LDX_I	ldx	[%r22 + 0x0189], %r26
hwintr_2_152:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_152), 16, 16)) -> intp(2, 0, 36)
	.word 0xbf3c8000  ! 3308: SRA_R	sra 	%r18, %r0, %r31
	.word 0xb23c603d  ! 3310: XNOR_I	xnor 	%r17, 0x003d, %r25
	.word 0xf00c202a  ! 3311: LDUB_I	ldub	[%r16 + 0x002a], %r24
	mov	1, %r12
	.word 0x8f932000  ! 3313: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb9520000  ! 3314: RDPR_PIL	<illegal instruction>
	.word 0xf80da046  ! 3316: LDUB_I	ldub	[%r22 + 0x0046], %r28
	.word 0xb7520000  ! 3321: RDPR_PIL	<illegal instruction>
	.word 0xf405615f  ! 3322: LDUW_I	lduw	[%r21 + 0x015f], %r26
	.word 0xfe1de039  ! 3324: LDD_I	ldd	[%r23 + 0x0039], %r31
	.word 0xf60d2125  ! 3325: LDUB_I	ldub	[%r20 + 0x0125], %r27
	.word 0xf8048000  ! 3329: LDUW_R	lduw	[%r18 + %r0], %r28
	.word 0xf20c4000  ! 3330: LDUB_R	ldub	[%r17 + %r0], %r25
	.word 0xf40da1dd  ! 3331: LDUB_I	ldub	[%r22 + 0x01dd], %r26
	.word 0xb92cf001  ! 3332: SLLX_I	sllx	%r19, 0x0001, %r28
	.word 0xf6446013  ! 3334: LDSW_I	ldsw	[%r17 + 0x0013], %r27
	.word 0xf8050000  ! 3335: LDUW_R	lduw	[%r20 + %r0], %r28
	.word 0xf814c000  ! 3339: LDUH_R	lduh	[%r19 + %r0], %r28
	.word 0xf04d8000  ! 3340: LDSB_R	ldsb	[%r22 + %r0], %r24
	.word 0xfa4ce1f8  ! 3345: LDSB_I	ldsb	[%r19 + 0x01f8], %r29
	.word 0xb4352007  ! 3351: ORN_I	orn 	%r20, 0x0007, %r26
	.word 0xf8156063  ! 3360: LDUH_I	lduh	[%r21 + 0x0063], %r28
	ta	T_CHANGE_HPRIV
	.word 0x819828c9  ! 3366: WRHPR_HPSTATE_I	wrhpr	%r0, 0x08c9, %hpstate
	.word 0xf45521db  ! 3368: LDSH_I	ldsh	[%r20 + 0x01db], %r26
	setx	data_start_3, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb7518000  ! 3371: RDPR_PSTATE	rdpr	%pstate, %r27
hwintr_2_153:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_153), 16, 16)) -> intp(2, 0, 25)
	.word 0xf61d4000  ! 3382: LDD_R	ldd	[%r21 + %r0], %r27
	.word 0xbb51c000  ! 3383: RDPR_TL	<illegal instruction>
	.word 0xfc54c000  ! 3389: LDSH_R	ldsh	[%r19 + %r0], %r30
hwintr_2_154:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_154), 16, 16)) -> intp(2, 0, a)
	.word 0xf8558000  ! 3391: LDSH_R	ldsh	[%r22 + %r0], %r28
	.word 0xbf540000  ! 3393: RDPR_GL	<illegal instruction>
	.word 0xbd520000  ! 3394: RDPR_PIL	<illegal instruction>
	.word 0xf00ca036  ! 3399: LDUB_I	ldub	[%r18 + 0x0036], %r24
	.word 0xf4444000  ! 3402: LDSW_R	ldsw	[%r17 + %r0], %r26
	.word 0xf61d4000  ! 3403: LDD_R	ldd	[%r21 + %r0], %r27
	.word 0xf91c8000  ! 3404: LDDF_R	ldd	[%r18, %r0], %f28
	.word 0x8595e06a  ! 3405: WRPR_TSTATE_I	wrpr	%r23, 0x006a, %tstate
	.word 0xf4452134  ! 3408: LDSW_I	ldsw	[%r20 + 0x0134], %r26
	.word 0xfc558000  ! 3409: LDSH_R	ldsh	[%r22 + %r0], %r30
	.word 0xfa144000  ! 3410: LDUH_R	lduh	[%r17 + %r0], %r29
	.word 0xf245e1b3  ! 3411: LDSW_I	ldsw	[%r23 + 0x01b3], %r25
	.word 0xf21c613e  ! 3412: LDD_I	ldd	[%r17 + 0x013e], %r25
	.word 0xf61c618a  ! 3421: LDD_I	ldd	[%r17 + 0x018a], %r27
	.word 0x8194216a  ! 3423: WRPR_TPC_I	wrpr	%r16, 0x016a, %tpc
	mov	1, %r12
	.word 0x8f932000  ! 3426: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb3356001  ! 3428: SRL_I	srl 	%r21, 0x0001, %r25
	.word 0xbd540000  ! 3429: RDPR_GL	<illegal instruction>
	.word 0xfc5560a4  ! 3434: LDSH_I	ldsh	[%r21 + 0x00a4], %r30
hwintr_2_155:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_155), 16, 16)) -> intp(2, 0, 26)
hwintr_2_156:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_156), 16, 16)) -> intp(2, 0, 31)
	mov	2, %r14
	.word 0xa193a000  ! 3440: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb734a001  ! 3444: SRL_I	srl 	%r18, 0x0001, %r27
	.word 0xbd2d3001  ! 3446: SLLX_I	sllx	%r20, 0x0001, %r30
hwintr_2_157:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_157), 16, 16)) -> intp(2, 0, 2e)
	.word 0xb92d9000  ! 3450: SLLX_R	sllx	%r22, %r0, %r28
	.word 0x8194e05e  ! 3451: WRPR_TPC_I	wrpr	%r19, 0x005e, %tpc
hwintr_2_158:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_158), 16, 16)) -> intp(2, 0, 3b)
hwintr_2_159:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_159), 16, 16)) -> intp(2, 0, f)
	.word 0xb5641800  ! 3461: MOVcc_R	<illegal instruction>
	.word 0xfa040000  ! 3462: LDUW_R	lduw	[%r16 + %r0], %r29
	.word 0xf81de162  ! 3463: LDD_I	ldd	[%r23 + 0x0162], %r28
	.word 0xb951c000  ! 3466: RDPR_TL	<illegal instruction>
hwintr_2_160:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_160), 16, 16)) -> intp(2, 0, 1d)
	.word 0xbc44a098  ! 3472: ADDC_I	addc 	%r18, 0x0098, %r30
	.word 0xf2042008  ! 3478: LDUW_I	lduw	[%r16 + 0x0008], %r25
	.word 0xf44ce146  ! 3484: LDSB_I	ldsb	[%r19 + 0x0146], %r26
	.word 0xf11ce08e  ! 3487: LDDF_I	ldd	[%r19, 0x008e], %f24
hwintr_2_161:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_161), 16, 16)) -> intp(2, 0, 10)
	.word 0xfe4c6071  ! 3492: LDSB_I	ldsb	[%r17 + 0x0071], %r31
hwintr_2_162:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_162), 16, 16)) -> intp(2, 0, c)
	ta	T_CHANGE_HPRIV
	.word 0x81983e19  ! 3498: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e19, %hpstate
	.word 0xf31c6168  ! 3499: LDDF_I	ldd	[%r17, 0x0168], %f25
	.word 0xbca48000  ! 3500: SUBcc_R	subcc 	%r18, %r0, %r30
hwintr_2_163:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_163), 16, 16)) -> intp(2, 0, 39)
	.word 0xbd518000  ! 3509: RDPR_PSTATE	<illegal instruction>
	.word 0xf41d0000  ! 3510: LDD_R	ldd	[%r20 + %r0], %r26
	.word 0xfa5d4000  ! 3512: LDX_R	ldx	[%r21 + %r0], %r29
	.word 0xf24c215e  ! 3515: LDSB_I	ldsb	[%r16 + 0x015e], %r25
	.word 0xff1d2181  ! 3516: LDDF_I	ldd	[%r20, 0x0181], %f31
	.word 0xfc15613d  ! 3517: LDUH_I	lduh	[%r21 + 0x013d], %r30
	.word 0xb835e1d7  ! 3520: ORN_I	orn 	%r23, 0x01d7, %r28
	setx	data_start_4, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r20, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf85d8000  ! 3531: LDX_R	ldx	[%r22 + %r0], %r28
	.word 0xf4158000  ! 3534: LDUH_R	lduh	[%r22 + %r0], %r26
	ta	T_CHANGE_HPRIV
	.word 0x81982d81  ! 3540: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d81, %hpstate
	.word 0xf615e011  ! 3541: LDUH_I	lduh	[%r23 + 0x0011], %r27
	.word 0xf0540000  ! 3542: LDSH_R	ldsh	[%r16 + %r0], %r24
	.word 0xfc548000  ! 3543: LDSH_R	ldsh	[%r18 + %r0], %r30
	ta	T_CHANGE_HPRIV
	.word 0x81982b43  ! 3545: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b43, %hpstate
	.word 0x8795e0ee  ! 3547: WRPR_TT_I	wrpr	%r23, 0x00ee, %tt
	.word 0xf644a1f9  ! 3549: LDSW_I	ldsw	[%r18 + 0x01f9], %r27
	.word 0xb8944000  ! 3550: ORcc_R	orcc 	%r17, %r0, %r28
hwintr_2_164:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_164), 16, 16)) -> intp(2, 0, 23)
	.word 0xf44cc000  ! 3562: LDSB_R	ldsb	[%r19 + %r0], %r26
	.word 0xf015c000  ! 3568: LDUH_R	lduh	[%r23 + %r0], %r24
	.word 0xf51de197  ! 3574: LDDF_I	ldd	[%r23, 0x0197], %f26
	.word 0xf44c61ce  ! 3575: LDSB_I	ldsb	[%r17 + 0x01ce], %r26
	.word 0x91946190  ! 3580: WRPR_PIL_I	wrpr	%r17, 0x0190, %pil
	.word 0xf6054000  ! 3584: LDUW_R	lduw	[%r21 + %r0], %r27
	.word 0xf61c21b1  ! 3585: LDD_I	ldd	[%r16 + 0x01b1], %r27
hwintr_2_165:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_165), 16, 16)) -> intp(2, 0, 2d)
	.word 0xf24cc000  ! 3589: LDSB_R	ldsb	[%r19 + %r0], %r25
	.word 0xf20d4000  ! 3592: LDUB_R	ldub	[%r21 + %r0], %r25
	.word 0xbb3cd000  ! 3593: SRAX_R	srax	%r19, %r0, %r29
	.word 0xf4548000  ! 3598: LDSH_R	ldsh	[%r18 + %r0], %r26
	.word 0xb7504000  ! 3600: RDPR_TNPC	<illegal instruction>
	.word 0xb684217f  ! 3604: ADDcc_I	addcc 	%r16, 0x017f, %r27
	.word 0xfc45e0ca  ! 3608: LDSW_I	ldsw	[%r23 + 0x00ca], %r30
	.word 0xf20d61ed  ! 3609: LDUB_I	ldub	[%r21 + 0x01ed], %r25
	.word 0xf60d4000  ! 3610: LDUB_R	ldub	[%r21 + %r0], %r27
	.word 0xf21cc000  ! 3615: LDD_R	ldd	[%r19 + %r0], %r25
	.word 0xf4154000  ! 3616: LDUH_R	lduh	[%r21 + %r0], %r26
	.word 0xf00dc000  ! 3622: LDUB_R	ldub	[%r23 + %r0], %r24
	.word 0xf91c4000  ! 3623: LDDF_R	ldd	[%r17, %r0], %f28
	.word 0xbf520000  ! 3624: RDPR_PIL	<illegal instruction>
	.word 0xf4450000  ! 3626: LDSW_R	ldsw	[%r20 + %r0], %r26
	.word 0xf24d6142  ! 3630: LDSB_I	ldsb	[%r21 + 0x0142], %r25
hwintr_2_166:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_166), 16, 16)) -> intp(2, 0, 22)
	ta	T_CHANGE_HPRIV
	.word 0x819839d1  ! 3636: WRHPR_HPSTATE_I	wrhpr	%r0, 0x19d1, %hpstate
	.word 0xf65cc000  ! 3638: LDX_R	ldx	[%r19 + %r0], %r27
	.word 0xfe5d608e  ! 3644: LDX_I	ldx	[%r21 + 0x008e], %r31
	.word 0xf6142124  ! 3648: LDUH_I	lduh	[%r16 + 0x0124], %r27
	.word 0xf41d8000  ! 3649: LDD_R	ldd	[%r22 + %r0], %r26
	.word 0xfa55e097  ! 3650: LDSH_I	ldsh	[%r23 + 0x0097], %r29
	.word 0xb0b4c000  ! 3652: ORNcc_R	orncc 	%r19, %r0, %r24
	.word 0xf31cc000  ! 3654: LDDF_R	ldd	[%r19, %r0], %f25
	.word 0xf4042025  ! 3655: LDUW_I	lduw	[%r16 + 0x0025], %r26
	.word 0xf655e119  ! 3656: LDSH_I	ldsh	[%r23 + 0x0119], %r27
	.word 0xb1510000  ! 3657: RDPR_TICK	<illegal instruction>
	.word 0xb1341000  ! 3664: SRLX_R	srlx	%r16, %r0, %r24
	.word 0xf85ca110  ! 3666: LDX_I	ldx	[%r18 + 0x0110], %r28
	.word 0xb2bc4000  ! 3681: XNORcc_R	xnorcc 	%r17, %r0, %r25
hwintr_2_167:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_167), 16, 16)) -> intp(2, 0, 36)
	.word 0xba3d8000  ! 3684: XNOR_R	xnor 	%r22, %r0, %r29
hwintr_2_168:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_168), 16, 16)) -> intp(2, 0, 10)
	.word 0xf71d4000  ! 3686: LDDF_R	ldd	[%r21, %r0], %f27
	.word 0x859560ed  ! 3691: WRPR_TSTATE_I	wrpr	%r21, 0x00ed, %tstate
	.word 0xbf7c0400  ! 3694: MOVR_R	movre	%r16, %r0, %r31
	mov	0, %r14
	.word 0xa193a000  ! 3695: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf20d21e0  ! 3696: LDUB_I	ldub	[%r20 + 0x01e0], %r25
	.word 0x8194212b  ! 3698: WRPR_TPC_I	wrpr	%r16, 0x012b, %tpc
	.word 0xfc1de1b5  ! 3700: LDD_I	ldd	[%r23 + 0x01b5], %r30
	setx	data_start_5, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb3508000  ! 3704: RDPR_TSTATE	<illegal instruction>
	.word 0xf255c000  ! 3706: LDSH_R	ldsh	[%r23 + %r0], %r25
	.word 0xb7504000  ! 3710: RDPR_TNPC	<illegal instruction>
hwintr_2_169:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_169), 16, 16)) -> intp(2, 0, 3d)
hwintr_2_170:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_170), 16, 16)) -> intp(2, 0, 26)
	.word 0xf054c000  ! 3715: LDSH_R	ldsh	[%r19 + %r0], %r24
	.word 0xfc458000  ! 3717: LDSW_R	ldsw	[%r22 + %r0], %r30
	.word 0x839561e7  ! 3718: WRPR_TNPC_I	wrpr	%r21, 0x01e7, %tnpc
	.word 0xf4148000  ! 3721: LDUH_R	lduh	[%r18 + %r0], %r26
hwintr_2_171:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_171), 16, 16)) -> intp(2, 0, 1)
	.word 0xfe44e1b2  ! 3726: LDSW_I	ldsw	[%r19 + 0x01b2], %r31
	.word 0xfe458000  ! 3727: LDSW_R	ldsw	[%r22 + %r0], %r31
	.word 0xf2444000  ! 3730: LDSW_R	ldsw	[%r17 + %r0], %r25
	.word 0xfa0d0000  ! 3731: LDUB_R	ldub	[%r20 + %r0], %r29
	.word 0xf2558000  ! 3733: LDSH_R	ldsh	[%r22 + %r0], %r25
	.word 0xb42d4000  ! 3734: ANDN_R	andn 	%r21, %r0, %r26
hwintr_2_172:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_172), 16, 16)) -> intp(2, 0, 28)
	.word 0xf84d6008  ! 3738: LDSB_I	ldsb	[%r21 + 0x0008], %r28
	.word 0xfc0d4000  ! 3739: LDUB_R	ldub	[%r21 + %r0], %r30
	.word 0x8995a100  ! 3740: WRPR_TICK_I	wrpr	%r22, 0x0100, %tick
	.word 0xfa4d8000  ! 3745: LDSB_R	ldsb	[%r22 + %r0], %r29
	.word 0xb5480000  ! 3747: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xfe150000  ! 3750: LDUH_R	lduh	[%r20 + %r0], %r31
	.word 0xb00cc000  ! 3751: AND_R	and 	%r19, %r0, %r24
	.word 0xf80cc000  ! 3754: LDUB_R	ldub	[%r19 + %r0], %r28
	.word 0x859461c0  ! 3756: WRPR_TSTATE_I	wrpr	%r17, 0x01c0, %tstate
	.word 0xfe5ce1b2  ! 3761: LDX_I	ldx	[%r19 + 0x01b2], %r31
	.word 0xf20561f5  ! 3765: LDUW_I	lduw	[%r21 + 0x01f5], %r25
hwintr_2_173:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_173), 16, 16)) -> intp(2, 0, 0)
	.word 0xfc154000  ! 3770: LDUH_R	lduh	[%r21 + %r0], %r30
	.word 0x8d94a0e0  ! 3771: WRPR_PSTATE_I	wrpr	%r18, 0x00e0, %pstate
	.word 0xbd510000  ! 3772: RDPR_TICK	<illegal instruction>
	.word 0x899560d0  ! 3774: WRPR_TICK_I	wrpr	%r21, 0x00d0, %tick
hwintr_2_174:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_174), 16, 16)) -> intp(2, 0, 23)
	.word 0xf71da0a9  ! 3776: LDDF_I	ldd	[%r22, 0x00a9], %f27
hwintr_2_175:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_175), 16, 16)) -> intp(2, 0, 2e)
	ta	T_CHANGE_HPRIV
	.word 0x81982a81  ! 3787: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a81, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81983e0b  ! 3789: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e0b, %hpstate
	.word 0xf854c000  ! 3791: LDSH_R	ldsh	[%r19 + %r0], %r28
	.word 0xb80d2028  ! 3796: AND_I	and 	%r20, 0x0028, %r28
	.word 0xbb510000  ! 3797: RDPR_TICK	rdpr	%tick, %r29
hwintr_2_176:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_176), 16, 16)) -> intp(2, 0, 26)
	.word 0xb73c4000  ! 3802: SRA_R	sra 	%r17, %r0, %r27
	.word 0xfe154000  ! 3804: LDUH_R	lduh	[%r21 + %r0], %r31
	.word 0x8d94a0d8  ! 3809: WRPR_PSTATE_I	wrpr	%r18, 0x00d8, %pstate
	.word 0xfa1d0000  ! 3810: LDD_R	ldd	[%r20 + %r0], %r29
	.word 0xf20d4000  ! 3812: LDUB_R	ldub	[%r21 + %r0], %r25
	.word 0xbb500000  ! 3815: RDPR_TPC	<illegal instruction>
	.word 0xf64dc000  ! 3817: LDSB_R	ldsb	[%r23 + %r0], %r27
hwintr_2_177:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_177), 16, 16)) -> intp(2, 0, 1a)
	mov	2, %r12
	.word 0x8f932000  ! 3821: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfe4d4000  ! 3826: LDSB_R	ldsb	[%r21 + %r0], %r31
	.word 0xf84c8000  ! 3827: LDSB_R	ldsb	[%r18 + %r0], %r28
hwintr_2_178:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_178), 16, 16)) -> intp(2, 0, b)
	.word 0xb7518000  ! 3830: RDPR_PSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x819839d9  ! 3831: WRHPR_HPSTATE_I	wrhpr	%r0, 0x19d9, %hpstate
hwintr_2_179:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_179), 16, 16)) -> intp(2, 0, d)
hwintr_2_180:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_180), 16, 16)) -> intp(2, 0, 2f)
	.word 0xb88c20a4  ! 3840: ANDcc_I	andcc 	%r16, 0x00a4, %r28
hwintr_2_181:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_181), 16, 16)) -> intp(2, 0, 6)
	.word 0xfa1de079  ! 3843: LDD_I	ldd	[%r23 + 0x0079], %r29
	.word 0xf44de1ea  ! 3844: LDSB_I	ldsb	[%r23 + 0x01ea], %r26
	.word 0xfd1dc000  ! 3845: LDDF_R	ldd	[%r23, %r0], %f30
hwintr_2_182:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_182), 16, 16)) -> intp(2, 0, 3)
	.word 0xb0a54000  ! 3849: SUBcc_R	subcc 	%r21, %r0, %r24
	.word 0xf2446159  ! 3851: LDSW_I	ldsw	[%r17 + 0x0159], %r25
	.word 0x8995a05b  ! 3858: WRPR_TICK_I	wrpr	%r22, 0x005b, %tick
	.word 0xfa14a0c4  ! 3863: LDUH_I	lduh	[%r18 + 0x00c4], %r29
	.word 0xfe5c8000  ! 3864: LDX_R	ldx	[%r18 + %r0], %r31
	ta	T_CHANGE_HPRIV
	.word 0x81983f89  ! 3865: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f89, %hpstate
	.word 0xf405213f  ! 3866: LDUW_I	lduw	[%r20 + 0x013f], %r26
	.word 0xb2b48000  ! 3868: ORNcc_R	orncc 	%r18, %r0, %r25
	.word 0xfe458000  ! 3870: LDSW_R	ldsw	[%r22 + %r0], %r31
	.word 0xf40ca09a  ! 3871: LDUB_I	ldub	[%r18 + 0x009a], %r26
	.word 0xb550c000  ! 3872: RDPR_TT	<illegal instruction>
	.word 0xbf510000  ! 3877: RDPR_TICK	<illegal instruction>
	.word 0xb9518000  ! 3880: RDPR_PSTATE	<illegal instruction>
	.word 0x9194a09a  ! 3881: WRPR_PIL_I	wrpr	%r18, 0x009a, %pil
	.word 0xfe4d2008  ! 3883: LDSB_I	ldsb	[%r20 + 0x0008], %r31
	.word 0xfc5d4000  ! 3888: LDX_R	ldx	[%r21 + %r0], %r30
	.word 0xf25de1fd  ! 3893: LDX_I	ldx	[%r23 + 0x01fd], %r25
	.word 0xbc8c61cc  ! 3897: ANDcc_I	andcc 	%r17, 0x01cc, %r30
	.word 0xf04d0000  ! 3904: LDSB_R	ldsb	[%r20 + %r0], %r24
	.word 0xbf520000  ! 3905: RDPR_PIL	<illegal instruction>
	.word 0xb6c52082  ! 3910: ADDCcc_I	addccc 	%r20, 0x0082, %r27
	.word 0xbf3cd000  ! 3911: SRAX_R	srax	%r19, %r0, %r31
	.word 0x819420db  ! 3913: WRPR_TPC_I	wrpr	%r16, 0x00db, %tpc
	.word 0x91952040  ! 3914: WRPR_PIL_I	wrpr	%r20, 0x0040, %pil
	.word 0xb1504000  ! 3915: RDPR_TNPC	<illegal instruction>
	.word 0xfe554000  ! 3922: LDSH_R	ldsh	[%r21 + %r0], %r31
	.word 0xbd504000  ! 3924: RDPR_TNPC	<illegal instruction>
	.word 0xfa5460f2  ! 3928: LDSH_I	ldsh	[%r17 + 0x00f2], %r29
	.word 0xf71d0000  ! 3930: LDDF_R	ldd	[%r20, %r0], %f27
	.word 0xfc4c4000  ! 3933: LDSB_R	ldsb	[%r17 + %r0], %r30
	.word 0xb6a5600f  ! 3935: SUBcc_I	subcc 	%r21, 0x000f, %r27
	.word 0xb3500000  ! 3937: RDPR_TPC	<illegal instruction>
	.word 0xf25c2173  ! 3938: LDX_I	ldx	[%r16 + 0x0173], %r25
	.word 0xf85ce1d7  ! 3940: LDX_I	ldx	[%r19 + 0x01d7], %r28
	mov	1, %r14
	.word 0xa193a000  ! 3941: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfc54c000  ! 3942: LDSH_R	ldsh	[%r19 + %r0], %r30
hwintr_2_183:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_183), 16, 16)) -> intp(2, 0, e)
	.word 0xf91cc000  ! 3946: LDDF_R	ldd	[%r19, %r0], %f28
	.word 0xb02c4000  ! 3949: ANDN_R	andn 	%r17, %r0, %r24
	.word 0xf8558000  ! 3950: LDSH_R	ldsh	[%r22 + %r0], %r28
	.word 0x9195609b  ! 3953: WRPR_PIL_I	wrpr	%r21, 0x009b, %pil
	.word 0xfc1c8000  ! 3956: LDD_R	ldd	[%r18 + %r0], %r30
	mov	1, %r14
	.word 0xa193a000  ! 3959: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfe050000  ! 3963: LDUW_R	lduw	[%r20 + %r0], %r31
hwintr_2_184:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_184), 16, 16)) -> intp(2, 0, 10)
	.word 0xbf510000  ! 3965: RDPR_TICK	<illegal instruction>
	.word 0xfa0ce140  ! 3970: LDUB_I	ldub	[%r19 + 0x0140], %r29
	.word 0xfc454000  ! 3973: LDSW_R	ldsw	[%r21 + %r0], %r30
hwintr_2_185:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_185), 16, 16)) -> intp(2, 0, 2f)
	.word 0xf51d0000  ! 3975: LDDF_R	ldd	[%r20, %r0], %f26
	.word 0xf814e10f  ! 3977: LDUH_I	lduh	[%r19 + 0x010f], %r28
	.word 0xb3508000  ! 3979: RDPR_TSTATE	<illegal instruction>
	.word 0xb5504000  ! 3986: RDPR_TNPC	<illegal instruction>
	.word 0xf804e157  ! 3989: LDUW_I	lduw	[%r19 + 0x0157], %r28
	.word 0x8395e0ae  ! 3990: WRPR_TNPC_I	wrpr	%r23, 0x00ae, %tnpc
hwintr_2_186:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_186), 16, 16)) -> intp(2, 0, 38)
	.word 0xb60d8000  ! 4003: AND_R	and 	%r22, %r0, %r27
	.word 0xfc04a023  ! 4004: LDUW_I	lduw	[%r18 + 0x0023], %r30
	.word 0xb22da1d3  ! 4005: ANDN_I	andn 	%r22, 0x01d3, %r25
	.word 0xbb500000  ! 4006: RDPR_TPC	<illegal instruction>
	.word 0xb1518000  ! 4008: RDPR_PSTATE	<illegal instruction>
	.word 0xf71d4000  ! 4012: LDDF_R	ldd	[%r21, %r0], %f27
	.word 0xb7540000  ! 4015: RDPR_GL	<illegal instruction>
	setx	data_start_1, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb83560af  ! 4017: SUBC_I	orn 	%r21, 0x00af, %r28
	setx	data_start_3, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf25c8000  ! 4019: LDX_R	ldx	[%r18 + %r0], %r25
	.word 0xb4bc4000  ! 4020: XNORcc_R	xnorcc 	%r17, %r0, %r26
	.word 0xfe444000  ! 4023: LDSW_R	ldsw	[%r17 + %r0], %r31
	.word 0xb12c4000  ! 4024: SLL_R	sll 	%r17, %r0, %r24
	.word 0xfe550000  ! 4027: LDSH_R	ldsh	[%r20 + %r0], %r31
	.word 0xff1da14d  ! 4029: LDDF_I	ldd	[%r22, 0x014d], %f31
	.word 0xf31d617b  ! 4033: LDDF_I	ldd	[%r21, 0x017b], %f25
	.word 0xfe058000  ! 4037: LDUW_R	lduw	[%r22 + %r0], %r31
	.word 0xf64ce137  ! 4041: LDSB_I	ldsb	[%r19 + 0x0137], %r27
	setx	data_start_1, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x819828c3  ! 4045: WRHPR_HPSTATE_I	wrhpr	%r0, 0x08c3, %hpstate
	.word 0xf04d616e  ! 4046: LDSB_I	ldsb	[%r21 + 0x016e], %r24
	.word 0xb894c000  ! 4048: ORcc_R	orcc 	%r19, %r0, %r28
	.word 0xf61ca143  ! 4049: LDD_I	ldd	[%r18 + 0x0143], %r27
	.word 0xf31da19a  ! 4055: LDDF_I	ldd	[%r22, 0x019a], %f25
	.word 0xb2b44000  ! 4058: SUBCcc_R	orncc 	%r17, %r0, %r25
	.word 0xf055e10c  ! 4059: LDSH_I	ldsh	[%r23 + 0x010c], %r24
	.word 0xfe5c6158  ! 4061: LDX_I	ldx	[%r17 + 0x0158], %r31
hwintr_2_187:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_187), 16, 16)) -> intp(2, 0, 4)
	.word 0xb150c000  ! 4063: RDPR_TT	<illegal instruction>
	.word 0x89946142  ! 4065: WRPR_TICK_I	wrpr	%r17, 0x0142, %tick
	.word 0xf31c601a  ! 4066: LDDF_I	ldd	[%r17, 0x001a], %f25
	mov	0, %r14
	.word 0xa193a000  ! 4069: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbb51c000  ! 4070: RDPR_TL	<illegal instruction>
	.word 0xfe4ca04d  ! 4072: LDSB_I	ldsb	[%r18 + 0x004d], %r31
	.word 0xf01ca02c  ! 4074: LDD_I	ldd	[%r18 + 0x002c], %r24
hwintr_2_188:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_188), 16, 16)) -> intp(2, 0, 3d)
	.word 0xf91d21d5  ! 4081: LDDF_I	ldd	[%r20, 0x01d5], %f28
	setx	data_start_2, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_2_189:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_189), 16, 16)) -> intp(2, 0, c)
	.word 0xf65d0000  ! 4091: LDX_R	ldx	[%r20 + %r0], %r27
	.word 0xb2b5c000  ! 4092: ORNcc_R	orncc 	%r23, %r0, %r25
	.word 0xf8540000  ! 4096: LDSH_R	ldsh	[%r16 + %r0], %r28
	.word 0xf31de0f5  ! 4099: LDDF_I	ldd	[%r23, 0x00f5], %f25
	.word 0xbc350000  ! 4102: ORN_R	orn 	%r20, %r0, %r30
	.word 0xfa4460da  ! 4103: LDSW_I	ldsw	[%r17 + 0x00da], %r29
	ta	T_CHANGE_HPRIV
	.word 0x81982cc1  ! 4104: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0cc1, %hpstate
	setx	data_start_7, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_2_190:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_190), 16, 16)) -> intp(2, 0, 8)
	.word 0x8d94a16c  ! 4117: WRPR_PSTATE_I	wrpr	%r18, 0x016c, %pstate
	.word 0xfa540000  ! 4118: LDSH_R	ldsh	[%r16 + %r0], %r29
	.word 0xbb3c0000  ! 4121: SRA_R	sra 	%r16, %r0, %r29
hwintr_2_191:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_191), 16, 16)) -> intp(2, 0, 15)
	.word 0xf655c000  ! 4125: LDSH_R	ldsh	[%r23 + %r0], %r27
hwintr_2_192:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_192), 16, 16)) -> intp(2, 0, 31)
	.word 0xfa054000  ! 4127: LDUW_R	lduw	[%r21 + %r0], %r29
	.word 0x8595215f  ! 4129: WRPR_TSTATE_I	wrpr	%r20, 0x015f, %tstate
	.word 0xf6144000  ! 4134: LDUH_R	lduh	[%r17 + %r0], %r27
	.word 0xb4154000  ! 4135: OR_R	or 	%r21, %r0, %r26
hwintr_2_193:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_193), 16, 16)) -> intp(2, 0, 29)
hwintr_2_194:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_194), 16, 16)) -> intp(2, 0, 3e)
	.word 0xb7520000  ! 4144: RDPR_PIL	<illegal instruction>
	.word 0xfe5d2160  ! 4145: LDX_I	ldx	[%r20 + 0x0160], %r31
	.word 0xf80de08f  ! 4146: LDUB_I	ldub	[%r23 + 0x008f], %r28
	.word 0xb2350000  ! 4147: SUBC_R	orn 	%r20, %r0, %r25
	.word 0xbb520000  ! 4149: RDPR_PIL	<illegal instruction>
hwintr_2_195:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_195), 16, 16)) -> intp(2, 0, 3c)
	.word 0xf414216a  ! 4154: LDUH_I	lduh	[%r16 + 0x016a], %r26
	.word 0xf24d0000  ! 4158: LDSB_R	ldsb	[%r20 + %r0], %r25
	.word 0x8595a0df  ! 4159: WRPR_TSTATE_I	wrpr	%r22, 0x00df, %tstate
	.word 0xb9510000  ! 4165: RDPR_TICK	<illegal instruction>
	.word 0xfa4da147  ! 4171: LDSB_I	ldsb	[%r22 + 0x0147], %r29
	.word 0x8594a153  ! 4174: WRPR_TSTATE_I	wrpr	%r18, 0x0153, %tstate
	.word 0xf6054000  ! 4178: LDUW_R	lduw	[%r21 + %r0], %r27
	.word 0xbab50000  ! 4179: SUBCcc_R	orncc 	%r20, %r0, %r29
hwintr_2_196:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_196), 16, 16)) -> intp(2, 0, 1f)
	.word 0xfe0cc000  ! 4183: LDUB_R	ldub	[%r19 + %r0], %r31
hwintr_2_197:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_197), 16, 16)) -> intp(2, 0, 2d)
hwintr_2_198:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_198), 16, 16)) -> intp(2, 0, 3f)
hwintr_2_199:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_199), 16, 16)) -> intp(2, 0, 1a)
	.word 0xf8148000  ! 4188: LDUH_R	lduh	[%r18 + %r0], %r28
	setx	data_start_1, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x9194e055  ! 4192: WRPR_PIL_I	wrpr	%r19, 0x0055, %pil
	.word 0xf244214a  ! 4196: LDSW_I	ldsw	[%r16 + 0x014a], %r25
	.word 0xf60c4000  ! 4197: LDUB_R	ldub	[%r17 + %r0], %r27
	.word 0xf00d8000  ! 4198: LDUB_R	ldub	[%r22 + %r0], %r24
	.word 0xb3518000  ! 4199: RDPR_PSTATE	<illegal instruction>
	.word 0xbf510000  ! 4202: RDPR_TICK	<illegal instruction>
hwintr_2_200:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_200), 16, 16)) -> intp(2, 0, 18)
	.word 0xb7342001  ! 4205: SRL_I	srl 	%r16, 0x0001, %r27
	.word 0xfc5c4000  ! 4206: LDX_R	ldx	[%r17 + %r0], %r30
hwintr_2_201:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_201), 16, 16)) -> intp(2, 0, c)
hwintr_2_202:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_202), 16, 16)) -> intp(2, 0, 1)
	.word 0xf2140000  ! 4215: LDUH_R	lduh	[%r16 + %r0], %r25
	.word 0xf01c61e6  ! 4216: LDD_I	ldd	[%r17 + 0x01e6], %r24
	.word 0xf20d0000  ! 4220: LDUB_R	ldub	[%r20 + %r0], %r25
	.word 0xbb480000  ! 4224: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xf91cc000  ! 4226: LDDF_R	ldd	[%r19, %r0], %f28
	.word 0x9195a07d  ! 4227: WRPR_PIL_I	wrpr	%r22, 0x007d, %pil
hwintr_2_203:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_203), 16, 16)) -> intp(2, 0, 25)
	mov	2, %r12
	.word 0x8f932000  ! 4233: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf2052165  ! 4235: LDUW_I	lduw	[%r20 + 0x0165], %r25
	.word 0xf11c8000  ! 4236: LDDF_R	ldd	[%r18, %r0], %f24
	.word 0x8795a0b9  ! 4238: WRPR_TT_I	wrpr	%r22, 0x00b9, %tt
	.word 0xfe0c8000  ! 4239: LDUB_R	ldub	[%r18 + %r0], %r31
	.word 0xf04d0000  ! 4242: LDSB_R	ldsb	[%r20 + %r0], %r24
	.word 0xf845c000  ! 4243: LDSW_R	ldsw	[%r23 + %r0], %r28
	.word 0xf24cc000  ! 4244: LDSB_R	ldsb	[%r19 + %r0], %r25
	.word 0xfc0de05c  ! 4246: LDUB_I	ldub	[%r23 + 0x005c], %r30
	setx	data_start_6, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf51ce1d4  ! 4250: LDDF_I	ldd	[%r19, 0x01d4], %f26
hwintr_2_204:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_204), 16, 16)) -> intp(2, 0, 20)
	.word 0xf61dc000  ! 4254: LDD_R	ldd	[%r23 + %r0], %r27
	.word 0x8195a083  ! 4256: WRPR_TPC_I	wrpr	%r22, 0x0083, %tpc
	.word 0xf80c8000  ! 4257: LDUB_R	ldub	[%r18 + %r0], %r28
	.word 0xfb1ce118  ! 4258: LDDF_I	ldd	[%r19, 0x0118], %f29
	.word 0xb3520000  ! 4260: RDPR_PIL	<illegal instruction>
	.word 0xf51c2161  ! 4264: LDDF_I	ldd	[%r16, 0x0161], %f26
hwintr_2_205:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_205), 16, 16)) -> intp(2, 0, 2d)
	.word 0xbb508000  ! 4269: RDPR_TSTATE	<illegal instruction>
	setx	data_start_4, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa15a157  ! 4276: LDUH_I	lduh	[%r22 + 0x0157], %r29
hwintr_2_206:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_206), 16, 16)) -> intp(2, 0, 2e)
	.word 0xfb1dc000  ! 4282: LDDF_R	ldd	[%r23, %r0], %f29
	.word 0xfc5d4000  ! 4284: LDX_R	ldx	[%r21 + %r0], %r30
	.word 0xbf7cc400  ! 4285: MOVR_R	movre	%r19, %r0, %r31
	.word 0xfe1ca052  ! 4289: LDD_I	ldd	[%r18 + 0x0052], %r31
	.word 0xfe5560a4  ! 4294: LDSH_I	ldsh	[%r21 + 0x00a4], %r31
	.word 0xf45c4000  ! 4295: LDX_R	ldx	[%r17 + %r0], %r26
	.word 0xb3520000  ! 4296: RDPR_PIL	<illegal instruction>
	.word 0xb53c5000  ! 4297: SRAX_R	srax	%r17, %r0, %r26
	.word 0xf6044000  ! 4298: LDUW_R	lduw	[%r17 + %r0], %r27
	.word 0xfa45607a  ! 4299: LDSW_I	ldsw	[%r21 + 0x007a], %r29
	setx	data_start_0, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb3480000  ! 4304: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	mov	1, %r14
	.word 0xa193a000  ! 4306: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x899461d2  ! 4309: WRPR_TICK_I	wrpr	%r17, 0x01d2, %tick
	mov	0, %r14
	.word 0xa193a000  ! 4310: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb151c000  ! 4316: RDPR_TL	<illegal instruction>
	.word 0xf80c8000  ! 4317: LDUB_R	ldub	[%r18 + %r0], %r28
	mov	0, %r12
	.word 0x8f932000  ! 4318: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfc448000  ! 4321: LDSW_R	ldsw	[%r18 + %r0], %r30
	.word 0xfc4cc000  ! 4323: LDSB_R	ldsb	[%r19 + %r0], %r30
	.word 0xf00c61bf  ! 4326: LDUB_I	ldub	[%r17 + 0x01bf], %r24
	.word 0xfa15e04c  ! 4327: LDUH_I	lduh	[%r23 + 0x004c], %r29
	.word 0xf805603e  ! 4328: LDUW_I	lduw	[%r21 + 0x003e], %r28
	.word 0x8d94a0a7  ! 4332: WRPR_PSTATE_I	wrpr	%r18, 0x00a7, %pstate
	.word 0xfa440000  ! 4334: LDSW_R	ldsw	[%r16 + %r0], %r29
	.word 0xb235a161  ! 4342: SUBC_I	orn 	%r22, 0x0161, %r25
	setx	data_start_1, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfc5d8000  ! 4345: LDX_R	ldx	[%r22 + %r0], %r30
	mov	0, %r14
	.word 0xa193a000  ! 4347: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8794207a  ! 4351: WRPR_TT_I	wrpr	%r16, 0x007a, %tt
	.word 0xbd510000  ! 4356: RDPR_TICK	<illegal instruction>
	.word 0xbb508000  ! 4357: RDPR_TSTATE	<illegal instruction>
hwintr_2_207:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_207), 16, 16)) -> intp(2, 0, 2e)
	.word 0xfc1d8000  ! 4363: LDD_R	ldd	[%r22 + %r0], %r30
	.word 0xb0ada03e  ! 4364: ANDNcc_I	andncc 	%r22, 0x003e, %r24
	.word 0x8194607e  ! 4365: WRPR_TPC_I	wrpr	%r17, 0x007e, %tpc
	.word 0xf204607b  ! 4366: LDUW_I	lduw	[%r17 + 0x007b], %r25
hwintr_2_208:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_208), 16, 16)) -> intp(2, 0, 21)
	.word 0xbb51c000  ! 4372: RDPR_TL	<illegal instruction>
	.word 0xf25c6085  ! 4378: LDX_I	ldx	[%r17 + 0x0085], %r25
	.word 0xf8044000  ! 4380: LDUW_R	lduw	[%r17 + %r0], %r28
	.word 0xb23de0ec  ! 4381: XNOR_I	xnor 	%r23, 0x00ec, %r25
	mov	2, %r12
	.word 0x8f932000  ! 4383: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb0a5601c  ! 4385: SUBcc_I	subcc 	%r21, 0x001c, %r24
	.word 0xf2454000  ! 4386: LDSW_R	ldsw	[%r21 + %r0], %r25
	.word 0xf61d6182  ! 4389: LDD_I	ldd	[%r21 + 0x0182], %r27
	.word 0xf2144000  ! 4390: LDUH_R	lduh	[%r17 + %r0], %r25
	.word 0xfa054000  ! 4391: LDUW_R	lduw	[%r21 + %r0], %r29
	setx	data_start_0, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf20d4000  ! 4393: LDUB_R	ldub	[%r21 + %r0], %r25
	.word 0xf61c0000  ! 4394: LDD_R	ldd	[%r16 + %r0], %r27
hwintr_2_209:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_209), 16, 16)) -> intp(2, 0, 6)
	.word 0xf4554000  ! 4405: LDSH_R	ldsh	[%r21 + %r0], %r26
	.word 0xb5480000  ! 4406: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xfc544000  ! 4408: LDSH_R	ldsh	[%r17 + %r0], %r30
hwintr_2_210:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_210), 16, 16)) -> intp(2, 0, 4)
	.word 0xb02c4000  ! 4411: ANDN_R	andn 	%r17, %r0, %r24
	setx	data_start_4, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfc55201b  ! 4416: LDSH_I	ldsh	[%r20 + 0x001b], %r30
hwintr_2_211:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_211), 16, 16)) -> intp(2, 0, 0)
	.word 0xfa0ce139  ! 4419: LDUB_I	ldub	[%r19 + 0x0139], %r29
	.word 0xfe45605a  ! 4420: LDSW_I	ldsw	[%r21 + 0x005a], %r31
hwintr_2_212:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_212), 16, 16)) -> intp(2, 0, 24)
	.word 0xb2ac4000  ! 4423: ANDNcc_R	andncc 	%r17, %r0, %r25
hwintr_2_213:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_213), 16, 16)) -> intp(2, 0, 39)
	.word 0xfc144000  ! 4431: LDUH_R	lduh	[%r17 + %r0], %r30
	.word 0xfc5c20eb  ! 4434: LDX_I	ldx	[%r16 + 0x00eb], %r30
	.word 0xf71d4000  ! 4435: LDDF_R	ldd	[%r21, %r0], %f27
	.word 0xfa0d0000  ! 4439: LDUB_R	ldub	[%r20 + %r0], %r29
	.word 0xfa046038  ! 4440: LDUW_I	lduw	[%r17 + 0x0038], %r29
	.word 0xb214c000  ! 4444: OR_R	or 	%r19, %r0, %r25
	.word 0xf31c6061  ! 4446: LDDF_I	ldd	[%r17, 0x0061], %f25
	.word 0xfa54208b  ! 4447: LDSH_I	ldsh	[%r16 + 0x008b], %r29
	.word 0xfa54c000  ! 4449: LDSH_R	ldsh	[%r19 + %r0], %r29
	.word 0x8d95a11d  ! 4451: WRPR_PSTATE_I	wrpr	%r22, 0x011d, %pstate
	.word 0xb49d4000  ! 4453: XORcc_R	xorcc 	%r21, %r0, %r26
	.word 0xfa5c4000  ! 4454: LDX_R	ldx	[%r17 + %r0], %r29
	.word 0x9194e178  ! 4456: WRPR_PIL_I	wrpr	%r19, 0x0178, %pil
	.word 0xfc54a17b  ! 4457: LDSH_I	ldsh	[%r18 + 0x017b], %r30
	.word 0xf2442199  ! 4459: LDSW_I	ldsw	[%r16 + 0x0199], %r25
	ta	T_CHANGE_HPRIV
	.word 0x81982959  ! 4466: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0959, %hpstate
	setx	data_start_7, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfc0d20fb  ! 4468: LDUB_I	ldub	[%r20 + 0x00fb], %r30
hwintr_2_214:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_214), 16, 16)) -> intp(2, 0, 6)
	.word 0xf04d609b  ! 4470: LDSB_I	ldsb	[%r21 + 0x009b], %r24
	.word 0xfe45a060  ! 4472: LDSW_I	ldsw	[%r22 + 0x0060], %r31
	.word 0xbd500000  ! 4476: RDPR_TPC	<illegal instruction>
hwintr_2_215:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_215), 16, 16)) -> intp(2, 0, c)
	.word 0xfa05219f  ! 4478: LDUW_I	lduw	[%r20 + 0x019f], %r29
	.word 0xbd508000  ! 4480: RDPR_TSTATE	<illegal instruction>
	.word 0xf80d60f3  ! 4481: LDUB_I	ldub	[%r21 + 0x00f3], %r28
	.word 0xb9518000  ! 4482: RDPR_PSTATE	<illegal instruction>
	setx	data_start_7, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfc4c204e  ! 4489: LDSB_I	ldsb	[%r16 + 0x004e], %r30
	ta	T_CHANGE_HPRIV
	.word 0x81983d91  ! 4490: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d91, %hpstate
	.word 0x859460d1  ! 4491: WRPR_TSTATE_I	wrpr	%r17, 0x00d1, %tstate
	.word 0x8794a087  ! 4494: WRPR_TT_I	wrpr	%r18, 0x0087, %tt
	.word 0xba440000  ! 4497: ADDC_R	addc 	%r16, %r0, %r29
	.word 0xf31c2009  ! 4503: LDDF_I	ldd	[%r16, 0x0009], %f25
	.word 0xfe0d4000  ! 4504: LDUB_R	ldub	[%r21 + %r0], %r31
	.word 0xf6444000  ! 4506: LDSW_R	ldsw	[%r17 + %r0], %r27
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xbf50c000  ! 4512: RDPR_TT	<illegal instruction>
hwintr_2_216:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_216), 16, 16)) -> intp(2, 0, d)
	.word 0xb7520000  ! 4516: RDPR_PIL	<illegal instruction>
	.word 0xbd480000  ! 4517: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xf444e10b  ! 4520: LDSW_I	ldsw	[%r19 + 0x010b], %r26
	.word 0xb9518000  ! 4523: RDPR_PSTATE	<illegal instruction>
hwintr_2_217:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_217), 16, 16)) -> intp(2, 0, 39)
	.word 0xb12c1000  ! 4526: SLLX_R	sllx	%r16, %r0, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982c8b  ! 4527: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c8b, %hpstate
	.word 0xf44cc000  ! 4529: LDSB_R	ldsb	[%r19 + %r0], %r26
	.word 0xfc552006  ! 4535: LDSH_I	ldsh	[%r20 + 0x0006], %r30
	.word 0xf01c4000  ! 4541: LDD_R	ldd	[%r17 + %r0], %r24
	.word 0x81946033  ! 4543: WRPR_TPC_I	wrpr	%r17, 0x0033, %tpc
	.word 0xf61d4000  ! 4544: LDD_R	ldd	[%r21 + %r0], %r27
	.word 0xfa4cc000  ! 4548: LDSB_R	ldsb	[%r19 + %r0], %r29
	.word 0xbb510000  ! 4549: RDPR_TICK	<illegal instruction>
	.word 0xfa05605d  ! 4550: LDUW_I	lduw	[%r21 + 0x005d], %r29
	.word 0xf85da144  ! 4553: LDX_I	ldx	[%r22 + 0x0144], %r28
hwintr_2_218:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_218), 16, 16)) -> intp(2, 0, 23)
	.word 0xb7510000  ! 4559: RDPR_TICK	<illegal instruction>
hwintr_2_219:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_219), 16, 16)) -> intp(2, 0, 7)
	.word 0xb3518000  ! 4561: RDPR_PSTATE	<illegal instruction>
hwintr_2_220:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_220), 16, 16)) -> intp(2, 0, 3b)
	.word 0xfa45a171  ! 4566: LDSW_I	ldsw	[%r22 + 0x0171], %r29
	.word 0x8594a029  ! 4567: WRPR_TSTATE_I	wrpr	%r18, 0x0029, %tstate
	.word 0xb4b5a1e1  ! 4573: SUBCcc_I	orncc 	%r22, 0x01e1, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81982941  ! 4580: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0941, %hpstate
	.word 0x8994a0b3  ! 4584: WRPR_TICK_I	wrpr	%r18, 0x00b3, %tick
	.word 0xb224a07c  ! 4589: SUB_I	sub 	%r18, 0x007c, %r25
	.word 0x9195e1b0  ! 4599: WRPR_PIL_I	wrpr	%r23, 0x01b0, %pil
	.word 0xf6154000  ! 4610: LDUH_R	lduh	[%r21 + %r0], %r27
hwintr_2_221:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_221), 16, 16)) -> intp(2, 0, 33)
	.word 0x8d942008  ! 4613: WRPR_PSTATE_I	wrpr	%r16, 0x0008, %pstate
	.word 0xbf354000  ! 4620: SRL_R	srl 	%r21, %r0, %r31
	.word 0xf85d0000  ! 4623: LDX_R	ldx	[%r20 + %r0], %r28
	.word 0xb894e000  ! 4625: ORcc_I	orcc 	%r19, 0x0000, %r28
	.word 0xbf51c000  ! 4626: RDPR_TL	<illegal instruction>
	.word 0xf61c61cf  ! 4627: LDD_I	ldd	[%r17 + 0x01cf], %r27
	.word 0xb8a4c000  ! 4628: SUBcc_R	subcc 	%r19, %r0, %r28
hwintr_2_222:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_222), 16, 16)) -> intp(2, 0, 1e)
	.word 0xf055e058  ! 4631: LDSH_I	ldsh	[%r23 + 0x0058], %r24
	.word 0xf014a022  ! 4632: LDUH_I	lduh	[%r18 + 0x0022], %r24
	.word 0xf31da119  ! 4633: LDDF_I	ldd	[%r22, 0x0119], %f25
	ta	T_CHANGE_HPRIV
	.word 0x81982811  ! 4636: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0811, %hpstate
	.word 0xbe2d0000  ! 4638: ANDN_R	andn 	%r20, %r0, %r31
	.word 0xf45dc000  ! 4640: LDX_R	ldx	[%r23 + %r0], %r26
	.word 0xfe1460a6  ! 4642: LDUH_I	lduh	[%r17 + 0x00a6], %r31
	.word 0xf0156115  ! 4643: LDUH_I	lduh	[%r21 + 0x0115], %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982fc1  ! 4645: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0fc1, %hpstate
hwintr_2_223:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_223), 16, 16)) -> intp(2, 0, 1c)
	.word 0xfc540000  ! 4647: LDSH_R	ldsh	[%r16 + %r0], %r30
	.word 0xf71de1ad  ! 4648: LDDF_I	ldd	[%r23, 0x01ad], %f27
	.word 0xb40cc000  ! 4652: AND_R	and 	%r19, %r0, %r26
	mov	2, %r14
	.word 0xa193a000  ! 4653: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbf643801  ! 4654: MOVcc_I	<illegal instruction>
	.word 0xfb1cc000  ! 4656: LDDF_R	ldd	[%r19, %r0], %f29
	.word 0xf45d0000  ! 4657: LDX_R	ldx	[%r20 + %r0], %r26
	.word 0xb235a1e3  ! 4663: SUBC_I	orn 	%r22, 0x01e3, %r25
	.word 0xf00de032  ! 4666: LDUB_I	ldub	[%r23 + 0x0032], %r24
	.word 0xf814602b  ! 4667: LDUH_I	lduh	[%r17 + 0x002b], %r28
	mov	1, %r14
	.word 0xa193a000  ! 4669: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf605605a  ! 4674: LDUW_I	lduw	[%r21 + 0x005a], %r27
	.word 0xb69d0000  ! 4681: XORcc_R	xorcc 	%r20, %r0, %r27
	.word 0xf604e03b  ! 4686: LDUW_I	lduw	[%r19 + 0x003b], %r27
hwintr_2_224:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_224), 16, 16)) -> intp(2, 0, 24)
	.word 0xf8140000  ! 4691: LDUH_R	lduh	[%r16 + %r0], %r28
	.word 0xb3510000  ! 4692: RDPR_TICK	<illegal instruction>
	.word 0xb8a4a1ea  ! 4693: SUBcc_I	subcc 	%r18, 0x01ea, %r28
	.word 0xf21d0000  ! 4694: LDD_R	ldd	[%r20 + %r0], %r25
	.word 0xf00d20c4  ! 4697: LDUB_I	ldub	[%r20 + 0x00c4], %r24
	.word 0xbd50c000  ! 4700: RDPR_TT	<illegal instruction>
	.word 0xfc040000  ! 4701: LDUW_R	lduw	[%r16 + %r0], %r30
	.word 0xbb504000  ! 4705: RDPR_TNPC	<illegal instruction>
	.word 0xf21ce16a  ! 4706: LDD_I	ldd	[%r19 + 0x016a], %r25
hwintr_2_225:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_225), 16, 16)) -> intp(2, 0, 2c)
	.word 0xf45ce06c  ! 4717: LDX_I	ldx	[%r19 + 0x006c], %r26
	.word 0x8994a05c  ! 4720: WRPR_TICK_I	wrpr	%r18, 0x005c, %tick
	.word 0xb1520000  ! 4722: RDPR_PIL	<illegal instruction>
	.word 0xb5500000  ! 4724: RDPR_TPC	<illegal instruction>
	.word 0xf8554000  ! 4725: LDSH_R	ldsh	[%r21 + %r0], %r28
	.word 0xba94e087  ! 4727: ORcc_I	orcc 	%r19, 0x0087, %r29
	.word 0xb8bcc000  ! 4731: XNORcc_R	xnorcc 	%r19, %r0, %r28
	.word 0xbb3cd000  ! 4735: SRAX_R	srax	%r19, %r0, %r29
	.word 0xf25c4000  ! 4739: LDX_R	ldx	[%r17 + %r0], %r25
	.word 0xb285a1bf  ! 4744: ADDcc_I	addcc 	%r22, 0x01bf, %r25
	.word 0x8d946172  ! 4745: WRPR_PSTATE_I	wrpr	%r17, 0x0172, %pstate
	.word 0x919420f9  ! 4751: WRPR_PIL_I	wrpr	%r16, 0x00f9, %pil
	.word 0xb9540000  ! 4758: RDPR_GL	<illegal instruction>
	.word 0xf65ce198  ! 4760: LDX_I	ldx	[%r19 + 0x0198], %r27
	.word 0xf4550000  ! 4761: LDSH_R	ldsh	[%r20 + %r0], %r26
	ta	T_CHANGE_HPRIV
	.word 0x81982949  ! 4764: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0949, %hpstate
	.word 0xfa454000  ! 4769: LDSW_R	ldsw	[%r21 + %r0], %r29
	.word 0xfe044000  ! 4772: LDUW_R	lduw	[%r17 + %r0], %r31
	mov	0, %r12
	.word 0x8f932000  ! 4773: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbf7c6401  ! 4775: MOVR_I	movre	%r17, 0x1, %r31
	.word 0xf4150000  ! 4776: LDUH_R	lduh	[%r20 + %r0], %r26
	.word 0xfe4c2138  ! 4777: LDSB_I	ldsb	[%r16 + 0x0138], %r31
	.word 0xf64c21aa  ! 4778: LDSB_I	ldsb	[%r16 + 0x01aa], %r27
	.word 0xbd500000  ! 4779: RDPR_TPC	<illegal instruction>
	.word 0xb5520000  ! 4780: RDPR_PIL	<illegal instruction>
	.word 0xbc344000  ! 4781: ORN_R	orn 	%r17, %r0, %r30
	.word 0xbac4e0b5  ! 4784: ADDCcc_I	addccc 	%r19, 0x00b5, %r29
	.word 0x8394e1c7  ! 4790: WRPR_TNPC_I	wrpr	%r19, 0x01c7, %tnpc
	.word 0xb084a1ce  ! 4791: ADDcc_I	addcc 	%r18, 0x01ce, %r24
hwintr_2_226:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_226), 16, 16)) -> intp(2, 0, 1b)
hwintr_2_227:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_227), 16, 16)) -> intp(2, 0, 2b)
	.word 0x8995206f  ! 4803: WRPR_TICK_I	wrpr	%r20, 0x006f, %tick
	.word 0xbf518000  ! 4804: RDPR_PSTATE	<illegal instruction>
	.word 0xf4554000  ! 4810: LDSH_R	ldsh	[%r21 + %r0], %r26
	.word 0xfa4d20bf  ! 4812: LDSB_I	ldsb	[%r20 + 0x00bf], %r29
	.word 0xf41de0ef  ! 4813: LDD_I	ldd	[%r23 + 0x00ef], %r26
	.word 0xf41d21bf  ! 4816: LDD_I	ldd	[%r20 + 0x01bf], %r26
	.word 0xfc5dc000  ! 4817: LDX_R	ldx	[%r23 + %r0], %r30
	.word 0xf405c000  ! 4819: LDUW_R	lduw	[%r23 + %r0], %r26
	.word 0xf91d0000  ! 4820: LDDF_R	ldd	[%r20, %r0], %f28
	.word 0xb42d8000  ! 4823: ANDN_R	andn 	%r22, %r0, %r26
	.word 0xfe1d0000  ! 4828: LDD_R	ldd	[%r20 + %r0], %r31
	.word 0xbb508000  ! 4831: RDPR_TSTATE	<illegal instruction>
	.word 0x8795e147  ! 4833: WRPR_TT_I	wrpr	%r23, 0x0147, %tt
	.word 0xf605a0f4  ! 4834: LDUW_I	lduw	[%r22 + 0x00f4], %r27
	.word 0xf04d8000  ! 4840: LDSB_R	ldsb	[%r22 + %r0], %r24
	.word 0xbd2db001  ! 4841: SLLX_I	sllx	%r22, 0x0001, %r30
	.word 0xb294a037  ! 4844: ORcc_I	orcc 	%r18, 0x0037, %r25
	.word 0xfe054000  ! 4845: LDUW_R	lduw	[%r21 + %r0], %r31
	.word 0xf11c8000  ! 4848: LDDF_R	ldd	[%r18, %r0], %f24
	ta	T_CHANGE_HPRIV
	.word 0x8198298b  ! 4851: WRHPR_HPSTATE_I	wrhpr	%r0, 0x098b, %hpstate
	.word 0xb885e08a  ! 4852: ADDcc_I	addcc 	%r23, 0x008a, %r28
	.word 0xfe5ca0e7  ! 4858: LDX_I	ldx	[%r18 + 0x00e7], %r31
	.word 0xfa4c2157  ! 4860: LDSB_I	ldsb	[%r16 + 0x0157], %r29
	.word 0xb550c000  ! 4863: RDPR_TT	<illegal instruction>
	.word 0xbd480000  ! 4867: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xf24c4000  ! 4869: LDSB_R	ldsb	[%r17 + %r0], %r25
	.word 0xfe04a0ea  ! 4872: LDUW_I	lduw	[%r18 + 0x00ea], %r31
	.word 0x8994e012  ! 4874: WRPR_TICK_I	wrpr	%r19, 0x0012, %tick
hwintr_2_228:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_228), 16, 16)) -> intp(2, 0, d)
	ta	T_CHANGE_HPRIV
	.word 0x81982c51  ! 4879: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c51, %hpstate
	.word 0xf64c618a  ! 4882: LDSB_I	ldsb	[%r17 + 0x018a], %r27
hwintr_2_229:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_229), 16, 16)) -> intp(2, 0, 1)
	.word 0xf64420e1  ! 4886: LDSW_I	ldsw	[%r16 + 0x00e1], %r27
	.word 0x8394a03d  ! 4887: WRPR_TNPC_I	wrpr	%r18, 0x003d, %tnpc
hwintr_2_230:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_230), 16, 16)) -> intp(2, 0, 27)
	.word 0xf8146076  ! 4891: LDUH_I	lduh	[%r17 + 0x0076], %r28
	.word 0xbe1c20cc  ! 4892: XOR_I	xor 	%r16, 0x00cc, %r31
	.word 0xfa0c2099  ! 4893: LDUB_I	ldub	[%r16 + 0x0099], %r29
	.word 0xfa458000  ! 4894: LDSW_R	ldsw	[%r22 + %r0], %r29
	.word 0xfc1c4000  ! 4899: LDD_R	ldd	[%r17 + %r0], %r30
	.word 0xfe154000  ! 4904: LDUH_R	lduh	[%r21 + %r0], %r31
	.word 0xf51de0f0  ! 4905: LDDF_I	ldd	[%r23, 0x00f0], %f26
	.word 0xfa152180  ! 4906: LDUH_I	lduh	[%r20 + 0x0180], %r29
hwintr_2_231:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_231), 16, 16)) -> intp(2, 0, 0)
hwintr_2_232:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_232), 16, 16)) -> intp(2, 0, 24)
	setx	data_start_5, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xba0cc000  ! 4915: AND_R	and 	%r19, %r0, %r29
hwintr_2_233:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_233), 16, 16)) -> intp(2, 0, 3c)
	.word 0xfb1c603e  ! 4921: LDDF_I	ldd	[%r17, 0x003e], %f29
	.word 0xf0448000  ! 4922: LDSW_R	ldsw	[%r18 + %r0], %r24
	.word 0xb08de04f  ! 4923: ANDcc_I	andcc 	%r23, 0x004f, %r24
	.word 0xfc148000  ! 4925: LDUH_R	lduh	[%r18 + %r0], %r30
	.word 0xfc058000  ! 4926: LDUW_R	lduw	[%r22 + %r0], %r30
	.word 0xf2454000  ! 4931: LDSW_R	ldsw	[%r21 + %r0], %r25
	setx	data_start_2, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	mov	1, %r12
	.word 0x8f932000  ! 4937: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
hwintr_2_234:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_234), 16, 16)) -> intp(2, 0, 1a)
hwintr_2_235:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_235), 16, 16)) -> intp(2, 0, c)
	.word 0xf054e04d  ! 4947: LDSH_I	ldsh	[%r19 + 0x004d], %r24
	.word 0xfe0ca175  ! 4949: LDUB_I	ldub	[%r18 + 0x0175], %r31
	.word 0xf00d602e  ! 4954: LDUB_I	ldub	[%r21 + 0x002e], %r24
	.word 0xb5540000  ! 4957: RDPR_GL	<illegal instruction>
	.word 0xf05c0000  ! 4958: LDX_R	ldx	[%r16 + %r0], %r24
	.word 0xf0548000  ! 4961: LDSH_R	ldsh	[%r18 + %r0], %r24
	.word 0xb17d6401  ! 4962: MOVR_I	movre	%r21, 0x1, %r24
	ta	T_CHANGE_HPRIV
	.word 0x8198284b  ! 4969: WRHPR_HPSTATE_I	wrhpr	%r0, 0x084b, %hpstate
	.word 0xf455e0b6  ! 4973: LDSH_I	ldsh	[%r23 + 0x00b6], %r26
	.word 0xf0546025  ! 4974: LDSH_I	ldsh	[%r17 + 0x0025], %r24
	.word 0xf24d20cc  ! 4978: LDSB_I	ldsb	[%r20 + 0x00cc], %r25
	.word 0xfe5d8000  ! 4979: LDX_R	ldx	[%r22 + %r0], %r31
	.word 0xf25ce149  ! 4981: LDX_I	ldx	[%r19 + 0x0149], %r25
	.word 0xf455c000  ! 4982: LDSH_R	ldsh	[%r23 + %r0], %r26
	.word 0x8395a1fb  ! 4983: WRPR_TNPC_I	wrpr	%r22, 0x01fb, %tnpc
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xfa150000  ! 4986: LDUH_R	lduh	[%r20 + %r0], %r29
	.word 0xfe4d2137  ! 4987: LDSB_I	ldsb	[%r20 + 0x0137], %r31
	.word 0xf44c0000  ! 4988: LDSB_R	ldsb	[%r16 + %r0], %r26
	.word 0xbc0c2020  ! 4990: AND_I	and 	%r16, 0x0020, %r30
	.word 0xb6bd611e  ! 4991: XNORcc_I	xnorcc 	%r21, 0x011e, %r27
	.word 0xf855a13a  ! 4993: LDSH_I	ldsh	[%r22 + 0x013a], %r28
	.word 0xf41d8000  ! 4996: LDD_R	ldd	[%r22 + %r0], %r26
	.word 0xf85cc000  ! 4997: LDX_R	ldx	[%r19 + %r0], %r28
	.word 0xf44d0000  ! 4998: LDSB_R	ldsb	[%r20 + %r0], %r26
	.word 0xba34c000  ! 5001: ORN_R	orn 	%r19, %r0, %r29
	.word 0x8d94a0fb  ! 5002: WRPR_PSTATE_I	wrpr	%r18, 0x00fb, %pstate
	.word 0xf20d4000  ! 5005: LDUB_R	ldub	[%r21 + %r0], %r25
	mov	2, %r12
	.word 0x8f932000  ! 5007: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_2_236:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_236), 16, 16)) -> intp(2, 0, 0)
	.word 0xf2550000  ! 5009: LDSH_R	ldsh	[%r20 + %r0], %r25
	.word 0xfe1560cd  ! 5011: LDUH_I	lduh	[%r21 + 0x00cd], %r31
	.word 0xf6054000  ! 5012: LDUW_R	lduw	[%r21 + %r0], %r27
	ta	T_CHANGE_HPRIV
	.word 0x81983f13  ! 5014: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f13, %hpstate
	.word 0xfe44e018  ! 5017: LDSW_I	ldsw	[%r19 + 0x0018], %r31
	.word 0xb80da014  ! 5018: AND_I	and 	%r22, 0x0014, %r28
	.word 0xbd504000  ! 5020: RDPR_TNPC	<illegal instruction>
	.word 0xfe4c61ed  ! 5024: LDSB_I	ldsb	[%r17 + 0x01ed], %r31
	.word 0xf45d0000  ! 5026: LDX_R	ldx	[%r20 + %r0], %r26
hwintr_2_237:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_237), 16, 16)) -> intp(2, 0, 2d)
	.word 0xf51cc000  ! 5037: LDDF_R	ldd	[%r19, %r0], %f26
	ta	T_CHANGE_HPRIV
	.word 0x81982951  ! 5042: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0951, %hpstate
	.word 0xb550c000  ! 5044: RDPR_TT	<illegal instruction>
	.word 0xfe5d8000  ! 5045: LDX_R	ldx	[%r22 + %r0], %r31
	.word 0xf04460e9  ! 5047: LDSW_I	ldsw	[%r17 + 0x00e9], %r24
	.word 0xbcb4c000  ! 5049: SUBCcc_R	orncc 	%r19, %r0, %r30
	.word 0xf0440000  ! 5051: LDSW_R	ldsw	[%r16 + %r0], %r24
	.word 0xb88d20ae  ! 5052: ANDcc_I	andcc 	%r20, 0x00ae, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81983ecb  ! 5062: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1ecb, %hpstate
	.word 0xfb1d604e  ! 5063: LDDF_I	ldd	[%r21, 0x004e], %f29
	.word 0xf85561cf  ! 5078: LDSH_I	ldsh	[%r21 + 0x01cf], %r28
	.word 0xb0bd60b8  ! 5079: XNORcc_I	xnorcc 	%r21, 0x00b8, %r24
	.word 0xbf510000  ! 5081: RDPR_TICK	<illegal instruction>
hwintr_2_238:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_238), 16, 16)) -> intp(2, 0, 9)
	.word 0xf71c8000  ! 5084: LDDF_R	ldd	[%r18, %r0], %f27
	.word 0xb3480000  ! 5087: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xb9518000  ! 5093: RDPR_PSTATE	<illegal instruction>
	.word 0xb6ac615d  ! 5094: ANDNcc_I	andncc 	%r17, 0x015d, %r27
	.word 0xfd1dc000  ! 5097: LDDF_R	ldd	[%r23, %r0], %f30
	.word 0xf04c604c  ! 5098: LDSB_I	ldsb	[%r17 + 0x004c], %r24
	setx	data_start_6, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf205c000  ! 5101: LDUW_R	lduw	[%r23 + %r0], %r25
	.word 0xf0146167  ! 5104: LDUH_I	lduh	[%r17 + 0x0167], %r24
	.word 0xfb1c2159  ! 5108: LDDF_I	ldd	[%r16, 0x0159], %f29
	.word 0x8d94e030  ! 5109: WRPR_PSTATE_I	wrpr	%r19, 0x0030, %pstate
	.word 0xfa44a11a  ! 5111: LDSW_I	ldsw	[%r18 + 0x011a], %r29
	.word 0xf644a0f1  ! 5113: LDSW_I	ldsw	[%r18 + 0x00f1], %r27
	.word 0xbd2c2001  ! 5115: SLL_I	sll 	%r16, 0x0001, %r30
	.word 0xfc1c2196  ! 5117: LDD_I	ldd	[%r16 + 0x0196], %r30
	.word 0xf21d211b  ! 5118: LDD_I	ldd	[%r20 + 0x011b], %r25
	.word 0xfa55e1d3  ! 5121: LDSH_I	ldsh	[%r23 + 0x01d3], %r29
	.word 0xb0a521cf  ! 5125: SUBcc_I	subcc 	%r20, 0x01cf, %r24
	.word 0xfc550000  ! 5129: LDSH_R	ldsh	[%r20 + %r0], %r30
	.word 0xfc1c61a7  ! 5130: LDD_I	ldd	[%r17 + 0x01a7], %r30
	.word 0xfa4de1bd  ! 5132: LDSB_I	ldsb	[%r23 + 0x01bd], %r29
	.word 0xff1c0000  ! 5134: LDDF_R	ldd	[%r16, %r0], %f31
hwintr_2_239:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_239), 16, 16)) -> intp(2, 0, 0)
	.word 0xfa05618b  ! 5136: LDUW_I	lduw	[%r21 + 0x018b], %r29
	.word 0xf045c000  ! 5138: LDSW_R	ldsw	[%r23 + %r0], %r24
	ta	T_CHANGE_HPRIV
	.word 0x8198391b  ! 5140: WRHPR_HPSTATE_I	wrhpr	%r0, 0x191b, %hpstate
	.word 0xf855218c  ! 5141: LDSH_I	ldsh	[%r20 + 0x018c], %r28
	.word 0xf454e002  ! 5145: LDSH_I	ldsh	[%r19 + 0x0002], %r26
	.word 0x89956036  ! 5149: WRPR_TICK_I	wrpr	%r21, 0x0036, %tick
	.word 0xfa454000  ! 5150: LDSW_R	ldsw	[%r21 + %r0], %r29
	.word 0x9195e02f  ! 5151: WRPR_PIL_I	wrpr	%r23, 0x002f, %pil
hwintr_2_240:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_240), 16, 16)) -> intp(2, 0, 15)
	.word 0xbf500000  ! 5156: RDPR_TPC	<illegal instruction>
	.word 0xf21d4000  ! 5157: LDD_R	ldd	[%r21 + %r0], %r25
	.word 0xf20ca064  ! 5160: LDUB_I	ldub	[%r18 + 0x0064], %r25
	mov	0, %r12
	.word 0x8f932000  ! 5163: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb4b4e137  ! 5166: ORNcc_I	orncc 	%r19, 0x0137, %r26
	.word 0x8d95a027  ! 5171: WRPR_PSTATE_I	wrpr	%r22, 0x0027, %pstate
	.word 0xb4b5e0b3  ! 5174: ORNcc_I	orncc 	%r23, 0x00b3, %r26
	.word 0xf61ce01c  ! 5183: LDD_I	ldd	[%r19 + 0x001c], %r27
hwintr_2_241:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_241), 16, 16)) -> intp(2, 0, 34)
	.word 0xf254e0b4  ! 5190: LDSH_I	ldsh	[%r19 + 0x00b4], %r25
	ta	T_CHANGE_HPRIV
	.word 0x81982a41  ! 5191: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a41, %hpstate
	.word 0xbf508000  ! 5195: RDPR_TSTATE	<illegal instruction>
hwintr_2_242:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_242), 16, 16)) -> intp(2, 0, 2d)
	.word 0x839421c5  ! 5199: WRPR_TNPC_I	wrpr	%r16, 0x01c5, %tnpc
	.word 0xb1520000  ! 5200: RDPR_PIL	<illegal instruction>
	.word 0xf255c000  ! 5201: LDSH_R	ldsh	[%r23 + %r0], %r25
	.word 0xff1d2145  ! 5203: LDDF_I	ldd	[%r20, 0x0145], %f31
	.word 0xf45d4000  ! 5206: LDX_R	ldx	[%r21 + %r0], %r26
	ta	T_CHANGE_HPRIV
	.word 0x81983d4b  ! 5207: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d4b, %hpstate
	.word 0xf8544000  ! 5208: LDSH_R	ldsh	[%r17 + %r0], %r28
	mov	0, %r14
	.word 0xa193a000  ! 5215: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	setx	data_start_4, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb150c000  ! 5226: RDPR_TT	<illegal instruction>
	.word 0x8794e084  ! 5228: WRPR_TT_I	wrpr	%r19, 0x0084, %tt
	.word 0xb7480000  ! 5231: RDHPR_HPSTATE	rdhpr	%hpstate, %r27
hwintr_2_243:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_243), 16, 16)) -> intp(2, 0, 35)
	.word 0xfc45a1bd  ! 5234: LDSW_I	ldsw	[%r22 + 0x01bd], %r30
	.word 0xff1ca01f  ! 5237: LDDF_I	ldd	[%r18, 0x001f], %f31
	.word 0xf51c219a  ! 5242: LDDF_I	ldd	[%r16, 0x019a], %f26
	.word 0xf51ca041  ! 5243: LDDF_I	ldd	[%r18, 0x0041], %f26
	.word 0xfc150000  ! 5245: LDUH_R	lduh	[%r20 + %r0], %r30
	.word 0xb615214e  ! 5246: OR_I	or 	%r20, 0x014e, %r27
	.word 0xf80d8000  ! 5248: LDUB_R	ldub	[%r22 + %r0], %r28
	.word 0xf05d4000  ! 5257: LDX_R	ldx	[%r21 + %r0], %r24
hwintr_2_244:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_244), 16, 16)) -> intp(2, 0, 1c)
	.word 0x8d9520f1  ! 5259: WRPR_PSTATE_I	wrpr	%r20, 0x00f1, %pstate
	.word 0xf11c8000  ! 5261: LDDF_R	ldd	[%r18, %r0], %f24
	.word 0xff1dc000  ! 5265: LDDF_R	ldd	[%r23, %r0], %f31
	.word 0xf05de0e2  ! 5266: LDX_I	ldx	[%r23 + 0x00e2], %r24
	.word 0x8395a17d  ! 5267: WRPR_TNPC_I	wrpr	%r22, 0x017d, %tnpc
hwintr_2_245:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_245), 16, 16)) -> intp(2, 0, 32)
	.word 0x8995e108  ! 5271: WRPR_TICK_I	wrpr	%r23, 0x0108, %tick
hwintr_2_246:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_246), 16, 16)) -> intp(2, 0, 13)
	.word 0xf044a10a  ! 5273: LDSW_I	ldsw	[%r18 + 0x010a], %r24
	.word 0xf20d0000  ! 5276: LDUB_R	ldub	[%r20 + %r0], %r25
	.word 0xf01cc000  ! 5278: LDD_R	ldd	[%r19 + %r0], %r24
	.word 0xb3480000  ! 5287: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
hwintr_2_247:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_247), 16, 16)) -> intp(2, 0, c)
	.word 0x83952124  ! 5292: WRPR_TNPC_I	wrpr	%r20, 0x0124, %tnpc
hwintr_2_248:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_248), 16, 16)) -> intp(2, 0, 20)
	.word 0x8394e1c5  ! 5294: WRPR_TNPC_I	wrpr	%r19, 0x01c5, %tnpc
	ta	T_CHANGE_HPRIV
	.word 0x81982809  ! 5297: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0809, %hpstate
	.word 0xfe550000  ! 5300: LDSH_R	ldsh	[%r20 + %r0], %r31
	.word 0xfa540000  ! 5305: LDSH_R	ldsh	[%r16 + %r0], %r29
	.word 0xf05d6035  ! 5307: LDX_I	ldx	[%r21 + 0x0035], %r24
	.word 0xfa544000  ! 5308: LDSH_R	ldsh	[%r17 + %r0], %r29
	ta	T_CHANGE_HPRIV
	.word 0x81982889  ! 5310: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0889, %hpstate
	mov	1, %r12
	.word 0x8f932000  ! 5313: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf005a0ad  ! 5315: LDUW_I	lduw	[%r22 + 0x00ad], %r24
hwintr_2_249:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_249), 16, 16)) -> intp(2, 0, 29)
hwintr_2_250:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_250), 16, 16)) -> intp(2, 0, 3c)
hwintr_2_251:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_251), 16, 16)) -> intp(2, 0, 6)
	.word 0xb9500000  ! 5330: RDPR_TPC	rdpr	%tpc, %r28
	.word 0xfe454000  ! 5333: LDSW_R	ldsw	[%r21 + %r0], %r31
	.word 0xf04d0000  ! 5334: LDSB_R	ldsb	[%r20 + %r0], %r24
	.word 0xbd510000  ! 5335: RDPR_TICK	<illegal instruction>
	setx	data_start_1, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r20, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x91942037  ! 5340: WRPR_PIL_I	wrpr	%r16, 0x0037, %pil
	.word 0xf655e1a5  ! 5342: LDSH_I	ldsh	[%r23 + 0x01a5], %r27
	.word 0x8395e1be  ! 5343: WRPR_TNPC_I	wrpr	%r23, 0x01be, %tnpc
	.word 0xfa444000  ! 5344: LDSW_R	ldsw	[%r17 + %r0], %r29
	.word 0xf8040000  ! 5345: LDUW_R	lduw	[%r16 + %r0], %r28
	.word 0xf6154000  ! 5350: LDUH_R	lduh	[%r21 + %r0], %r27
	.word 0xb3510000  ! 5352: RDPR_TICK	<illegal instruction>
	.word 0xbc3c8000  ! 5353: XNOR_R	xnor 	%r18, %r0, %r30
	.word 0xbe95e133  ! 5355: ORcc_I	orcc 	%r23, 0x0133, %r31
	.word 0xb0340000  ! 5356: SUBC_R	orn 	%r16, %r0, %r24
	.word 0x8394a02b  ! 5357: WRPR_TNPC_I	wrpr	%r18, 0x002b, %tnpc
hwintr_2_252:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_252), 16, 16)) -> intp(2, 0, 30)
	.word 0xf80c8000  ! 5363: LDUB_R	ldub	[%r18 + %r0], %r28
	.word 0xf8458000  ! 5366: LDSW_R	ldsw	[%r22 + %r0], %r28
	.word 0xb950c000  ! 5369: RDPR_TT	<illegal instruction>
	.word 0xbe34c000  ! 5373: ORN_R	orn 	%r19, %r0, %r31
hwintr_2_253:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_253), 16, 16)) -> intp(2, 0, 2a)
	.word 0xf24de1f8  ! 5378: LDSB_I	ldsb	[%r23 + 0x01f8], %r25
	.word 0xf0054000  ! 5390: LDUW_R	lduw	[%r21 + %r0], %r24
	.word 0xfe5da11b  ! 5391: LDX_I	ldx	[%r22 + 0x011b], %r31
	.word 0xfa558000  ! 5392: LDSH_R	ldsh	[%r22 + %r0], %r29
	.word 0xf25de159  ! 5395: LDX_I	ldx	[%r23 + 0x0159], %r25
	.word 0xf414a03e  ! 5396: LDUH_I	lduh	[%r18 + 0x003e], %r26
	.word 0xf4148000  ! 5399: LDUH_R	lduh	[%r18 + %r0], %r26
	.word 0xf41421f3  ! 5401: LDUH_I	lduh	[%r16 + 0x01f3], %r26
	.word 0xf24c0000  ! 5402: LDSB_R	ldsb	[%r16 + %r0], %r25
hwintr_2_254:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_254), 16, 16)) -> intp(2, 0, 26)
	.word 0xfc4c8000  ! 5405: LDSB_R	ldsb	[%r18 + %r0], %r30
	.word 0xf2154000  ! 5407: LDUH_R	lduh	[%r21 + %r0], %r25
	.word 0xb62d8000  ! 5408: ANDN_R	andn 	%r22, %r0, %r27
	.word 0xbb480000  ! 5410: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xb3510000  ! 5414: RDPR_TICK	<illegal instruction>
	.word 0xfe5d0000  ! 5424: LDX_R	ldx	[%r20 + %r0], %r31
	.word 0xfc140000  ! 5425: LDUH_R	lduh	[%r16 + %r0], %r30
	.word 0xb5510000  ! 5429: RDPR_TICK	<illegal instruction>
	.word 0xf71d4000  ! 5430: LDDF_R	ldd	[%r21, %r0], %f27
	.word 0xb1508000  ! 5434: RDPR_TSTATE	<illegal instruction>
	.word 0xfe0d0000  ! 5435: LDUB_R	ldub	[%r20 + %r0], %r31
	.word 0xb7518000  ! 5437: RDPR_PSTATE	<illegal instruction>
	.word 0x8995218b  ! 5441: WRPR_TICK_I	wrpr	%r20, 0x018b, %tick
	.word 0xb53c0000  ! 5446: SRA_R	sra 	%r16, %r0, %r26
	.word 0xb3520000  ! 5451: RDPR_PIL	<illegal instruction>
	.word 0xfe0d6150  ! 5464: LDUB_I	ldub	[%r21 + 0x0150], %r31
	.word 0xf81da04f  ! 5477: LDD_I	ldd	[%r22 + 0x004f], %r28
	.word 0xbe2ce11b  ! 5478: ANDN_I	andn 	%r19, 0x011b, %r31
	.word 0xf44dc000  ! 5479: LDSB_R	ldsb	[%r23 + %r0], %r26
	.word 0xfc05c000  ! 5480: LDUW_R	lduw	[%r23 + %r0], %r30
hwintr_2_255:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_255), 16, 16)) -> intp(2, 0, 3b)
	.word 0xb3508000  ! 5483: RDPR_TSTATE	<illegal instruction>
	.word 0xf81d8000  ! 5485: LDD_R	ldd	[%r22 + %r0], %r28
	.word 0xfa5c201b  ! 5490: LDX_I	ldx	[%r16 + 0x001b], %r29
	.word 0xf6056074  ! 5491: LDUW_I	lduw	[%r21 + 0x0074], %r27
	.word 0xfe0c61f5  ! 5492: LDUB_I	ldub	[%r17 + 0x01f5], %r31
	.word 0xfe1cc000  ! 5494: LDD_R	ldd	[%r19 + %r0], %r31
	.word 0xf845e136  ! 5497: LDSW_I	ldsw	[%r23 + 0x0136], %r28
	.word 0xb884a196  ! 5501: ADDcc_I	addcc 	%r18, 0x0196, %r28
	.word 0x91942158  ! 5503: WRPR_PIL_I	wrpr	%r16, 0x0158, %pil
	.word 0xb82d4000  ! 5506: ANDN_R	andn 	%r21, %r0, %r28
	.word 0xff1de140  ! 5509: LDDF_I	ldd	[%r23, 0x0140], %f31
	ta	T_CHANGE_HPRIV
	.word 0x81983a59  ! 5510: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a59, %hpstate
	.word 0xf71d21c2  ! 5511: LDDF_I	ldd	[%r20, 0x01c2], %f27
	.word 0xfb1d4000  ! 5513: LDDF_R	ldd	[%r21, %r0], %f29
	.word 0xf24d4000  ! 5517: LDSB_R	ldsb	[%r21 + %r0], %r25
	.word 0xbf500000  ! 5518: RDPR_TPC	<illegal instruction>
	.word 0xf204a1bb  ! 5521: LDUW_I	lduw	[%r18 + 0x01bb], %r25
	.word 0xbb518000  ! 5522: RDPR_PSTATE	<illegal instruction>
	.word 0xbd480000  ! 5525: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xf51ce117  ! 5528: LDDF_I	ldd	[%r19, 0x0117], %f26
	.word 0xf0540000  ! 5529: LDSH_R	ldsh	[%r16 + %r0], %r24
	.word 0xfa0dc000  ! 5530: LDUB_R	ldub	[%r23 + %r0], %r29
	ta	T_CHANGE_HPRIV
	.word 0x8198384b  ! 5531: WRHPR_HPSTATE_I	wrhpr	%r0, 0x184b, %hpstate
	.word 0xfc5da0e4  ! 5535: LDX_I	ldx	[%r22 + 0x00e4], %r30
	.word 0xfe4c4000  ! 5536: LDSB_R	ldsb	[%r17 + %r0], %r31
	setx	data_start_0, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r20, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf0544000  ! 5540: LDSH_R	ldsh	[%r17 + %r0], %r24
	.word 0xf615a07a  ! 5541: LDUH_I	lduh	[%r22 + 0x007a], %r27
	.word 0xfa1cc000  ! 5547: LDD_R	ldd	[%r19 + %r0], %r29
	.word 0x8d9461b6  ! 5548: WRPR_PSTATE_I	wrpr	%r17, 0x01b6, %pstate
	.word 0x8d94201f  ! 5551: WRPR_PSTATE_I	wrpr	%r16, 0x001f, %pstate
	.word 0xfa540000  ! 5554: LDSH_R	ldsh	[%r16 + %r0], %r29
	.word 0xb9504000  ! 5555: RDPR_TNPC	<illegal instruction>
	.word 0xf91c4000  ! 5560: LDDF_R	ldd	[%r17, %r0], %f28
hwintr_2_256:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_256), 16, 16)) -> intp(2, 0, 21)
	.word 0xf615e082  ! 5565: LDUH_I	lduh	[%r23 + 0x0082], %r27
	.word 0xbf508000  ! 5573: RDPR_TSTATE	<illegal instruction>
	.word 0xb41d6052  ! 5579: XOR_I	xor 	%r21, 0x0052, %r26
	.word 0xb1353001  ! 5580: SRLX_I	srlx	%r20, 0x0001, %r24
	.word 0xfa050000  ! 5582: LDUW_R	lduw	[%r20 + %r0], %r29
	mov	2, %r14
	.word 0xa193a000  ! 5585: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfc048000  ! 5587: LDUW_R	lduw	[%r18 + %r0], %r30
	.word 0x8d94a1d6  ! 5588: WRPR_PSTATE_I	wrpr	%r18, 0x01d6, %pstate
	.word 0xf04560b0  ! 5589: LDSW_I	ldsw	[%r21 + 0x00b0], %r24
	.word 0xfc5cc000  ! 5590: LDX_R	ldx	[%r19 + %r0], %r30
	.word 0xfc4c2057  ! 5591: LDSB_I	ldsb	[%r16 + 0x0057], %r30
	.word 0xf01c4000  ! 5592: LDD_R	ldd	[%r17 + %r0], %r24
	.word 0xfc45619f  ! 5594: LDSW_I	ldsw	[%r21 + 0x019f], %r30
	.word 0xfe558000  ! 5596: LDSH_R	ldsh	[%r22 + %r0], %r31
	.word 0xb951c000  ! 5598: RDPR_TL	<illegal instruction>
	.word 0xfe54201f  ! 5604: LDSH_I	ldsh	[%r16 + 0x001f], %r31
	.word 0xf84c0000  ! 5605: LDSB_R	ldsb	[%r16 + %r0], %r28
	.word 0xfa0d2030  ! 5606: LDUB_I	ldub	[%r20 + 0x0030], %r29
	mov	1, %r14
	.word 0xa193a000  ! 5607: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf65421c1  ! 5608: LDSH_I	ldsh	[%r16 + 0x01c1], %r27
	.word 0xf4558000  ! 5609: LDSH_R	ldsh	[%r22 + %r0], %r26
	.word 0xb5504000  ! 5613: RDPR_TNPC	<illegal instruction>
	.word 0xf2450000  ! 5618: LDSW_R	ldsw	[%r20 + %r0], %r25
	.word 0xb92cc000  ! 5624: SLL_R	sll 	%r19, %r0, %r28
	.word 0xb92cb001  ! 5626: SLLX_I	sllx	%r18, 0x0001, %r28
	.word 0xf2540000  ! 5627: LDSH_R	ldsh	[%r16 + %r0], %r25
	.word 0xb72c9000  ! 5629: SLLX_R	sllx	%r18, %r0, %r27
	.word 0xb5540000  ! 5630: RDPR_GL	<illegal instruction>
	.word 0xfa45c000  ! 5631: LDSW_R	ldsw	[%r23 + %r0], %r29
	.word 0xfc0d0000  ! 5632: LDUB_R	ldub	[%r20 + %r0], %r30
	.word 0xfa548000  ! 5634: LDSH_R	ldsh	[%r18 + %r0], %r29
	.word 0xfc0d601c  ! 5638: LDUB_I	ldub	[%r21 + 0x001c], %r30
	.word 0xf6044000  ! 5639: LDUW_R	lduw	[%r17 + %r0], %r27
	.word 0xbf504000  ! 5640: RDPR_TNPC	<illegal instruction>
	.word 0xbf518000  ! 5642: RDPR_PSTATE	<illegal instruction>
	.word 0xfe1d8000  ! 5644: LDD_R	ldd	[%r22 + %r0], %r31
	.word 0x8594e0cb  ! 5648: WRPR_TSTATE_I	wrpr	%r19, 0x00cb, %tstate
	.word 0xb1480000  ! 5649: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xb57dc400  ! 5650: MOVR_R	movre	%r23, %r0, %r26
	mov	1, %r12
	.word 0x8f932000  ! 5651: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb8954000  ! 5658: ORcc_R	orcc 	%r21, %r0, %r28
	.word 0xfc158000  ! 5661: LDUH_R	lduh	[%r22 + %r0], %r30
	.word 0xfa5ce15c  ! 5662: LDX_I	ldx	[%r19 + 0x015c], %r29
	.word 0xf11d4000  ! 5663: LDDF_R	ldd	[%r21, %r0], %f24
	.word 0x91956083  ! 5667: WRPR_PIL_I	wrpr	%r21, 0x0083, %pil
	.word 0xf0040000  ! 5668: LDUW_R	lduw	[%r16 + %r0], %r24
	.word 0xf45560f1  ! 5669: LDSH_I	ldsh	[%r21 + 0x00f1], %r26
	.word 0xf0140000  ! 5671: LDUH_R	lduh	[%r16 + %r0], %r24
	.word 0xba3cc000  ! 5672: XNOR_R	xnor 	%r19, %r0, %r29
	.word 0x8194615a  ! 5679: WRPR_TPC_I	wrpr	%r17, 0x015a, %tpc
	.word 0xf64c8000  ! 5680: LDSB_R	ldsb	[%r18 + %r0], %r27
hwintr_2_257:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_257), 16, 16)) -> intp(2, 0, 7)
	ta	T_CHANGE_HPRIV
	.word 0x81982a49  ! 5688: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a49, %hpstate
	.word 0xf8458000  ! 5690: LDSW_R	ldsw	[%r22 + %r0], %r28
	.word 0xb9540000  ! 5691: RDPR_GL	<illegal instruction>
hwintr_2_258:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_258), 16, 16)) -> intp(2, 0, 1a)
	.word 0xbe858000  ! 5696: ADDcc_R	addcc 	%r22, %r0, %r31
	.word 0xfa4de052  ! 5700: LDSB_I	ldsb	[%r23 + 0x0052], %r29
	.word 0xfe5c0000  ! 5706: LDX_R	ldx	[%r16 + %r0], %r31
	.word 0xbd50c000  ! 5707: RDPR_TT	<illegal instruction>
	.word 0xb7518000  ! 5708: RDPR_PSTATE	<illegal instruction>
	.word 0xfe1de0d7  ! 5712: LDD_I	ldd	[%r23 + 0x00d7], %r31
	.word 0xf4444000  ! 5721: LDSW_R	ldsw	[%r17 + %r0], %r26
hwintr_2_259:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_259), 16, 16)) -> intp(2, 0, 3c)
hwintr_2_260:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_260), 16, 16)) -> intp(2, 0, 30)
	.word 0xfd1d6015  ! 5727: LDDF_I	ldd	[%r21, 0x0015], %f30
	.word 0xf84520d4  ! 5728: LDSW_I	ldsw	[%r20 + 0x00d4], %r28
	mov	1, %r12
	.word 0x8f932000  ! 5732: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xb43c6004  ! 5738: XNOR_I	xnor 	%r17, 0x0004, %r26
	.word 0xf24d8000  ! 5740: LDSB_R	ldsb	[%r22 + %r0], %r25
	.word 0xb7500000  ! 5742: RDPR_TPC	<illegal instruction>
hwintr_2_261:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_261), 16, 16)) -> intp(2, 0, 31)
	.word 0xf255a153  ! 5748: LDSH_I	ldsh	[%r22 + 0x0153], %r25
	.word 0xbf518000  ! 5752: RDPR_PSTATE	<illegal instruction>
	.word 0xfa4d608b  ! 5760: LDSB_I	ldsb	[%r21 + 0x008b], %r29
	.word 0xfd1d609a  ! 5762: LDDF_I	ldd	[%r21, 0x009a], %f30
	.word 0xf80ce00c  ! 5763: LDUB_I	ldub	[%r19 + 0x000c], %r28
	.word 0xb5480000  ! 5767: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xfa5521fc  ! 5768: LDSH_I	ldsh	[%r20 + 0x01fc], %r29
	mov	1, %r12
	.word 0x8f932000  ! 5769: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb1508000  ! 5771: RDPR_TSTATE	<illegal instruction>
	.word 0xfa4c0000  ! 5772: LDSB_R	ldsb	[%r16 + %r0], %r29
	.word 0xf444c000  ! 5774: LDSW_R	ldsw	[%r19 + %r0], %r26
hwintr_2_262:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_262), 16, 16)) -> intp(2, 0, 1f)
hwintr_2_263:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_263), 16, 16)) -> intp(2, 0, 10)
	.word 0x8995e03b  ! 5783: WRPR_TICK_I	wrpr	%r23, 0x003b, %tick
	.word 0x85942199  ! 5784: WRPR_TSTATE_I	wrpr	%r16, 0x0199, %tstate
	.word 0x83942160  ! 5785: WRPR_TNPC_I	wrpr	%r16, 0x0160, %tnpc
	.word 0xf054a023  ! 5786: LDSH_I	ldsh	[%r18 + 0x0023], %r24
	.word 0xfd1dc000  ! 5791: LDDF_R	ldd	[%r23, %r0], %f30
	.word 0xfa4d0000  ! 5792: LDSB_R	ldsb	[%r20 + %r0], %r29
	.word 0xfe44202a  ! 5793: LDSW_I	ldsw	[%r16 + 0x002a], %r31
	.word 0xb53cc000  ! 5794: SRA_R	sra 	%r19, %r0, %r26
	.word 0xfa048000  ! 5795: LDUW_R	lduw	[%r18 + %r0], %r29
	.word 0xf64d0000  ! 5796: LDSB_R	ldsb	[%r20 + %r0], %r27
hwintr_2_264:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_264), 16, 16)) -> intp(2, 0, 18)
	.word 0xb9520000  ! 5811: RDPR_PIL	<illegal instruction>
	.word 0xf045a089  ! 5814: LDSW_I	ldsw	[%r22 + 0x0089], %r24
	.word 0xfc542079  ! 5818: LDSH_I	ldsh	[%r16 + 0x0079], %r30
	.word 0xf71de0d0  ! 5821: LDDF_I	ldd	[%r23, 0x00d0], %f27
	.word 0xb8a5a16f  ! 5824: SUBcc_I	subcc 	%r22, 0x016f, %r28
	.word 0xb9354000  ! 5829: SRL_R	srl 	%r21, %r0, %r28
	.word 0xf415a086  ! 5830: LDUH_I	lduh	[%r22 + 0x0086], %r26
	.word 0xb234c000  ! 5832: ORN_R	orn 	%r19, %r0, %r25
	.word 0xbf3cd000  ! 5833: SRAX_R	srax	%r19, %r0, %r31
	.word 0xf655a1a1  ! 5837: LDSH_I	ldsh	[%r22 + 0x01a1], %r27
	.word 0xb150c000  ! 5838: RDPR_TT	<illegal instruction>
	.word 0x8795206d  ! 5840: WRPR_TT_I	wrpr	%r20, 0x006d, %tt
	.word 0xfc4cc000  ! 5842: LDSB_R	ldsb	[%r19 + %r0], %r30
	.word 0xf01c4000  ! 5844: LDD_R	ldd	[%r17 + %r0], %r24
	.word 0xb7500000  ! 5848: RDPR_TPC	<illegal instruction>
	.word 0xfe1d0000  ! 5851: LDD_R	ldd	[%r20 + %r0], %r31
	.word 0x8995a0dd  ! 5855: WRPR_TICK_I	wrpr	%r22, 0x00dd, %tick
	.word 0xb5508000  ! 5860: RDPR_TSTATE	<illegal instruction>
	mov	1, %r14
	.word 0xa193a000  ! 5864: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf01c0000  ! 5865: LDD_R	ldd	[%r16 + %r0], %r24
	.word 0x83956163  ! 5869: WRPR_TNPC_I	wrpr	%r21, 0x0163, %tnpc
	.word 0xf45dc000  ! 5870: LDX_R	ldx	[%r23 + %r0], %r26
	.word 0xbd7c6401  ! 5875: MOVR_I	movre	%r17, 0x1, %r30
	.word 0xb3510000  ! 5877: RDPR_TICK	<illegal instruction>
	.word 0xb804613d  ! 5878: ADD_I	add 	%r17, 0x013d, %r28
	.word 0xb2b54000  ! 5879: ORNcc_R	orncc 	%r21, %r0, %r25
	.word 0xb1510000  ! 5881: RDPR_TICK	<illegal instruction>
hwintr_2_265:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_265), 16, 16)) -> intp(2, 0, 36)
	.word 0xbf2d7001  ! 5883: SLLX_I	sllx	%r21, 0x0001, %r31
	.word 0xfc4d0000  ! 5885: LDSB_R	ldsb	[%r20 + %r0], %r30
	.word 0xbe158000  ! 5887: OR_R	or 	%r22, %r0, %r31
	.word 0xf455e099  ! 5888: LDSH_I	ldsh	[%r23 + 0x0099], %r26
hwintr_2_266:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_266), 16, 16)) -> intp(2, 0, 36)
hwintr_2_267:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_267), 16, 16)) -> intp(2, 0, 2a)
	.word 0xbf520000  ! 5895: RDPR_PIL	<illegal instruction>
	.word 0xfe15a02f  ! 5899: LDUH_I	lduh	[%r22 + 0x002f], %r31
hwintr_2_268:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_268), 16, 16)) -> intp(2, 0, 28)
	.word 0xf01de1ac  ! 5910: LDD_I	ldd	[%r23 + 0x01ac], %r24
	.word 0xf814605f  ! 5913: LDUH_I	lduh	[%r17 + 0x005f], %r28
	.word 0xfb1d0000  ! 5916: LDDF_R	ldd	[%r20, %r0], %f29
	.word 0xfe54c000  ! 5919: LDSH_R	ldsh	[%r19 + %r0], %r31
	.word 0xb5540000  ! 5920: RDPR_GL	<illegal instruction>
	.word 0xb73c2001  ! 5921: SRA_I	sra 	%r16, 0x0001, %r27
	.word 0xf844a136  ! 5926: LDSW_I	ldsw	[%r18 + 0x0136], %r28
	.word 0xf31c4000  ! 5928: LDDF_R	ldd	[%r17, %r0], %f25
	.word 0xf014a08d  ! 5929: LDUH_I	lduh	[%r18 + 0x008d], %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982801  ! 5930: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0801, %hpstate
	.word 0xb2b40000  ! 5931: ORNcc_R	orncc 	%r16, %r0, %r25
	setx	data_start_6, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf00d8000  ! 5934: LDUB_R	ldub	[%r22 + %r0], %r24
	.word 0xf4148000  ! 5936: LDUH_R	lduh	[%r18 + %r0], %r26
hwintr_2_269:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_269), 16, 16)) -> intp(2, 0, 27)
	.word 0xb1520000  ! 5938: RDPR_PIL	<illegal instruction>
	.word 0xf0544000  ! 5939: LDSH_R	ldsh	[%r17 + %r0], %r24
	.word 0xb8b5e0a8  ! 5940: SUBCcc_I	orncc 	%r23, 0x00a8, %r28
	.word 0xf244a0c8  ! 5941: LDSW_I	ldsw	[%r18 + 0x00c8], %r25
hwintr_2_270:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_270), 16, 16)) -> intp(2, 0, 2d)
	.word 0xfe1da1ff  ! 5945: LDD_I	ldd	[%r22 + 0x01ff], %r31
	.word 0xb69cc000  ! 5946: XORcc_R	xorcc 	%r19, %r0, %r27
	.word 0xb8854000  ! 5949: ADDcc_R	addcc 	%r21, %r0, %r28
	.word 0xf41d8000  ! 5952: LDD_R	ldd	[%r22 + %r0], %r26
	.word 0xfe4ce18f  ! 5955: LDSB_I	ldsb	[%r19 + 0x018f], %r31
	.word 0xfe158000  ! 5957: LDUH_R	lduh	[%r22 + %r0], %r31
	.word 0x8994a1d8  ! 5960: WRPR_TICK_I	wrpr	%r18, 0x01d8, %tick
	.word 0xf81ca197  ! 5967: LDD_I	ldd	[%r18 + 0x0197], %r28
	ta	T_CHANGE_HPRIV
	.word 0x81983f9b  ! 5971: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f9b, %hpstate
	.word 0xbf2d0000  ! 5972: SLL_R	sll 	%r20, %r0, %r31
hwintr_2_271:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_271), 16, 16)) -> intp(2, 0, c)
	.word 0xf254c000  ! 5975: LDSH_R	ldsh	[%r19 + %r0], %r25
	.word 0xbf2d1000  ! 5978: SLLX_R	sllx	%r20, %r0, %r31
	.word 0xf25cc000  ! 5980: LDX_R	ldx	[%r19 + %r0], %r25
	.word 0xfc5c60a3  ! 5982: LDX_I	ldx	[%r17 + 0x00a3], %r30
	.word 0xf054a00e  ! 5985: LDSH_I	ldsh	[%r18 + 0x000e], %r24
	.word 0xfc058000  ! 5986: LDUW_R	lduw	[%r22 + %r0], %r30
	.word 0x8995211b  ! 5987: WRPR_TICK_I	wrpr	%r20, 0x011b, %tick
	.word 0xf8540000  ! 5989: LDSH_R	ldsh	[%r16 + %r0], %r28
	.word 0xf51d8000  ! 5991: LDDF_R	ldd	[%r22, %r0], %f26
	.word 0xbf500000  ! 5992: RDPR_TPC	<illegal instruction>
	.word 0xbcac6063  ! 5993: ANDNcc_I	andncc 	%r17, 0x0063, %r30
	.word 0xf51ce058  ! 5996: LDDF_I	ldd	[%r19, 0x0058], %f26
	mov	0, %r14
	.word 0xa193a000  ! 6002: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9500000  ! 6003: RDPR_TPC	<illegal instruction>
	.word 0x91952025  ! 6008: WRPR_PIL_I	wrpr	%r20, 0x0025, %pil
hwintr_2_272:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_272), 16, 16)) -> intp(2, 0, 19)
	ta	T_CHANGE_HPRIV
	.word 0x81982c49  ! 6011: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c49, %hpstate
	.word 0x8794a1cf  ! 6012: WRPR_TT_I	wrpr	%r18, 0x01cf, %tt
	.word 0xfc0d203a  ! 6013: LDUB_I	ldub	[%r20 + 0x003a], %r30
	.word 0x91946194  ! 6020: WRPR_PIL_I	wrpr	%r17, 0x0194, %pil
	.word 0xb4b58000  ! 6024: ORNcc_R	orncc 	%r22, %r0, %r26
hwintr_2_273:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_273), 16, 16)) -> intp(2, 0, 1c)
	.word 0xf65d4000  ! 6027: LDX_R	ldx	[%r21 + %r0], %r27
	.word 0xb3540000  ! 6030: RDPR_GL	<illegal instruction>
	.word 0xfd1c4000  ! 6031: LDDF_R	ldd	[%r17, %r0], %f30
	.word 0xfe5de1eb  ! 6035: LDX_I	ldx	[%r23 + 0x01eb], %r31
	.word 0xb134c000  ! 6038: SRL_R	srl 	%r19, %r0, %r24
	.word 0xf04d8000  ! 6041: LDSB_R	ldsb	[%r22 + %r0], %r24
	.word 0xb750c000  ! 6044: RDPR_TT	<illegal instruction>
	.word 0xb2ac61b4  ! 6045: ANDNcc_I	andncc 	%r17, 0x01b4, %r25
	.word 0xf61561b7  ! 6049: LDUH_I	lduh	[%r21 + 0x01b7], %r27
	.word 0xfe448000  ! 6050: LDSW_R	ldsw	[%r18 + %r0], %r31
	.word 0xfc144000  ! 6054: LDUH_R	lduh	[%r17 + %r0], %r30
	.word 0xf454e158  ! 6055: LDSH_I	ldsh	[%r19 + 0x0158], %r26
hwintr_2_274:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_274), 16, 16)) -> intp(2, 0, 31)
	.word 0xb2158000  ! 6058: OR_R	or 	%r22, %r0, %r25
	.word 0xf4054000  ! 6059: LDUW_R	lduw	[%r21 + %r0], %r26
	.word 0xf6544000  ! 6061: LDSH_R	ldsh	[%r17 + %r0], %r27
	.word 0xfd1da036  ! 6066: LDDF_I	ldd	[%r22, 0x0036], %f30
hwintr_2_275:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_275), 16, 16)) -> intp(2, 0, 19)
	.word 0x859421ae  ! 6071: WRPR_TSTATE_I	wrpr	%r16, 0x01ae, %tstate
	.word 0xb9641800  ! 6072: MOVcc_R	<illegal instruction>
	setx	data_start_4, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_2_276:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_276), 16, 16)) -> intp(2, 0, 32)
	.word 0xfa440000  ! 6075: LDSW_R	ldsw	[%r16 + %r0], %r29
	.word 0x8394e0e0  ! 6078: WRPR_TNPC_I	wrpr	%r19, 0x00e0, %tnpc
	.word 0xfe45c000  ! 6079: LDSW_R	ldsw	[%r23 + %r0], %r31
	.word 0xfc150000  ! 6088: LDUH_R	lduh	[%r20 + %r0], %r30
	.word 0xf91d4000  ! 6089: LDDF_R	ldd	[%r21, %r0], %f28
	.word 0xbb540000  ! 6091: RDPR_GL	<illegal instruction>
	.word 0xfb1ce017  ! 6093: LDDF_I	ldd	[%r19, 0x0017], %f29
hwintr_2_277:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_277), 16, 16)) -> intp(2, 0, 19)
	.word 0xfa1de050  ! 6102: LDD_I	ldd	[%r23 + 0x0050], %r29
	.word 0xfe054000  ! 6108: LDUW_R	lduw	[%r21 + %r0], %r31
hwintr_2_278:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_278), 16, 16)) -> intp(2, 0, 27)
	.word 0x839521cf  ! 6111: WRPR_TNPC_I	wrpr	%r20, 0x01cf, %tnpc
	.word 0xb3480000  ! 6114: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
hwintr_2_279:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_279), 16, 16)) -> intp(2, 0, 38)
	.word 0xf04c0000  ! 6117: LDSB_R	ldsb	[%r16 + %r0], %r24
	.word 0x8d9521b6  ! 6118: WRPR_PSTATE_I	wrpr	%r20, 0x01b6, %pstate
	.word 0xf80d2182  ! 6121: LDUB_I	ldub	[%r20 + 0x0182], %r28
	.word 0xf204e00c  ! 6123: LDUW_I	lduw	[%r19 + 0x000c], %r25
hwintr_2_280:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_280), 16, 16)) -> intp(2, 0, 3c)
	.word 0xbb500000  ! 6128: RDPR_TPC	<illegal instruction>
	.word 0xf6456062  ! 6132: LDSW_I	ldsw	[%r21 + 0x0062], %r27
	.word 0xf0052106  ! 6133: LDUW_I	lduw	[%r20 + 0x0106], %r24
	.word 0xfa1ca1c0  ! 6137: LDD_I	ldd	[%r18 + 0x01c0], %r29
	.word 0xff1ce015  ! 6138: LDDF_I	ldd	[%r19, 0x0015], %f31
	ta	T_CHANGE_HPRIV
	.word 0x81982cd1  ! 6140: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0cd1, %hpstate
	.word 0xf91da027  ! 6142: LDDF_I	ldd	[%r22, 0x0027], %f28
	.word 0xff1c601e  ! 6143: LDDF_I	ldd	[%r17, 0x001e], %f31
	.word 0xfb1ca10c  ! 6147: LDDF_I	ldd	[%r18, 0x010c], %f29
	.word 0x819521ef  ! 6148: WRPR_TPC_I	wrpr	%r20, 0x01ef, %tpc
	.word 0xfe54e1a7  ! 6149: LDSH_I	ldsh	[%r19 + 0x01a7], %r31
	.word 0xbd510000  ! 6151: RDPR_TICK	rdpr	%tick, %r30
	.word 0xf454611f  ! 6154: LDSH_I	ldsh	[%r17 + 0x011f], %r26
	.word 0xf21ce16e  ! 6159: LDD_I	ldd	[%r19 + 0x016e], %r25
	.word 0xbabce081  ! 6160: XNORcc_I	xnorcc 	%r19, 0x0081, %r29
	.word 0xb5356001  ! 6161: SRL_I	srl 	%r21, 0x0001, %r26
	.word 0xb37c0400  ! 6162: MOVR_R	movre	%r16, %r0, %r25
	.word 0xfe5de1cf  ! 6165: LDX_I	ldx	[%r23 + 0x01cf], %r31
	.word 0xf8450000  ! 6166: LDSW_R	ldsw	[%r20 + %r0], %r28
	.word 0xfe1d616f  ! 6177: LDD_I	ldd	[%r21 + 0x016f], %r31
	.word 0xf445606f  ! 6178: LDSW_I	ldsw	[%r21 + 0x006f], %r26
	.word 0xf414e0f1  ! 6180: LDUH_I	lduh	[%r19 + 0x00f1], %r26
	.word 0x819520d6  ! 6181: WRPR_TPC_I	wrpr	%r20, 0x00d6, %tpc
	.word 0xb644e0d8  ! 6195: ADDC_I	addc 	%r19, 0x00d8, %r27
	.word 0xbf50c000  ! 6197: RDPR_TT	rdpr	%tt, %r31
hwintr_2_281:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_281), 16, 16)) -> intp(2, 0, f)
	.word 0xb9510000  ! 6200: RDPR_TICK	<illegal instruction>
	.word 0xf80cc000  ! 6201: LDUB_R	ldub	[%r19 + %r0], %r28
hwintr_2_282:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_282), 16, 16)) -> intp(2, 0, 1b)
	.word 0xbb540000  ! 6207: RDPR_GL	<illegal instruction>
	.word 0xb7510000  ! 6208: RDPR_TICK	<illegal instruction>
	mov	1, %r14
	.word 0xa193a000  ! 6209: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	mov	1, %r14
	.word 0xa193a000  ! 6210: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_2_283:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_283), 16, 16)) -> intp(2, 0, 3a)
	.word 0xfc0d2063  ! 6216: LDUB_I	ldub	[%r20 + 0x0063], %r30
hwintr_2_284:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_284), 16, 16)) -> intp(2, 0, b)
hwintr_2_285:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_285), 16, 16)) -> intp(2, 0, 0)
	.word 0xf04d2032  ! 6223: LDSB_I	ldsb	[%r20 + 0x0032], %r24
	.word 0xf31c6157  ! 6226: LDDF_I	ldd	[%r17, 0x0157], %f25
	.word 0xfe0d60a9  ! 6227: LDUB_I	ldub	[%r21 + 0x00a9], %r31
	.word 0xfa04c000  ! 6229: LDUW_R	lduw	[%r19 + %r0], %r29
	.word 0xbd520000  ! 6235: RDPR_PIL	<illegal instruction>
hwintr_2_286:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_286), 16, 16)) -> intp(2, 0, 2b)
	.word 0x91946197  ! 6237: WRPR_PIL_I	wrpr	%r17, 0x0197, %pil
	.word 0x8595e1c3  ! 6238: WRPR_TSTATE_I	wrpr	%r23, 0x01c3, %tstate
	.word 0xfa050000  ! 6241: LDUW_R	lduw	[%r20 + %r0], %r29
	.word 0xf44da195  ! 6244: LDSB_I	ldsb	[%r22 + 0x0195], %r26
	.word 0x8595606c  ! 6245: WRPR_TSTATE_I	wrpr	%r21, 0x006c, %tstate
	.word 0xb3520000  ! 6246: RDPR_PIL	rdpr	%pil, %r25
hwintr_2_287:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_287), 16, 16)) -> intp(2, 0, 26)
	.word 0xfa0d2161  ! 6252: LDUB_I	ldub	[%r20 + 0x0161], %r29
	.word 0xfe44a1fa  ! 6253: LDSW_I	ldsw	[%r18 + 0x01fa], %r31
	.word 0xfa14606b  ! 6254: LDUH_I	lduh	[%r17 + 0x006b], %r29
	ta	T_CHANGE_HPRIV
	.word 0x81983cc1  ! 6256: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1cc1, %hpstate
	.word 0xb9518000  ! 6257: RDPR_PSTATE	<illegal instruction>
	.word 0xf25dc000  ! 6258: LDX_R	ldx	[%r23 + %r0], %r25
	.word 0xf04da1c8  ! 6260: LDSB_I	ldsb	[%r22 + 0x01c8], %r24
	.word 0xf45d205f  ! 6262: LDX_I	ldx	[%r20 + 0x005f], %r26
	.word 0xbd480000  ! 6267: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0x8194e1e7  ! 6268: WRPR_TPC_I	wrpr	%r19, 0x01e7, %tpc
	.word 0xf6454000  ! 6272: LDSW_R	ldsw	[%r21 + %r0], %r27
	.word 0xf20ce182  ! 6276: LDUB_I	ldub	[%r19 + 0x0182], %r25
	.word 0xf45c2173  ! 6280: LDX_I	ldx	[%r16 + 0x0173], %r26
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xf31c20e6  ! 6282: LDDF_I	ldd	[%r16, 0x00e6], %f25
	.word 0xf4540000  ! 6283: LDSH_R	ldsh	[%r16 + %r0], %r26
	.word 0xf51da099  ! 6286: LDDF_I	ldd	[%r22, 0x0099], %f26
	.word 0xf21c6169  ! 6288: LDD_I	ldd	[%r17 + 0x0169], %r25
	.word 0xf6440000  ! 6289: LDSW_R	ldsw	[%r16 + %r0], %r27
	.word 0xfe4c21b8  ! 6290: LDSB_I	ldsb	[%r16 + 0x01b8], %r31
	.word 0xfa150000  ! 6291: LDUH_R	lduh	[%r20 + %r0], %r29
	.word 0xf215e0e5  ! 6292: LDUH_I	lduh	[%r23 + 0x00e5], %r25
	.word 0xfc4c0000  ! 6295: LDSB_R	ldsb	[%r16 + %r0], %r30
	.word 0xf60d8000  ! 6296: LDUB_R	ldub	[%r22 + %r0], %r27
hwintr_2_288:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_288), 16, 16)) -> intp(2, 0, 31)
	.word 0xb92c2001  ! 6298: SLL_I	sll 	%r16, 0x0001, %r28
	.word 0xb7520000  ! 6299: RDPR_PIL	<illegal instruction>
	.word 0xfc05c000  ! 6301: LDUW_R	lduw	[%r23 + %r0], %r30
	.word 0xb405e172  ! 6303: ADD_I	add 	%r23, 0x0172, %r26
hwintr_2_289:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_289), 16, 16)) -> intp(2, 0, 2d)
hwintr_2_290:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_290), 16, 16)) -> intp(2, 0, 28)
	.word 0xb33cf001  ! 6307: SRAX_I	srax	%r19, 0x0001, %r25
	setx	data_start_2, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb22ce0c1  ! 6310: ANDN_I	andn 	%r19, 0x00c1, %r25
	.word 0xb81c0000  ! 6311: XOR_R	xor 	%r16, %r0, %r28
	.word 0xf6440000  ! 6316: LDSW_R	ldsw	[%r16 + %r0], %r27
	.word 0xfa4c0000  ! 6319: LDSB_R	ldsb	[%r16 + %r0], %r29
	.word 0x8d95e1db  ! 6320: WRPR_PSTATE_I	wrpr	%r23, 0x01db, %pstate
	.word 0xbd520000  ! 6323: RDPR_PIL	rdpr	%pil, %r30
	.word 0xbf51c000  ! 6324: RDPR_TL	<illegal instruction>
	.word 0xfe0dc000  ! 6327: LDUB_R	ldub	[%r23 + %r0], %r31
	.word 0xf0556088  ! 6328: LDSH_I	ldsh	[%r21 + 0x0088], %r24
hwintr_2_291:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_291), 16, 16)) -> intp(2, 0, 31)
	.word 0x859560f9  ! 6330: WRPR_TSTATE_I	wrpr	%r21, 0x00f9, %tstate
	.word 0xbf480000  ! 6334: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xbf51c000  ! 6336: RDPR_TL	<illegal instruction>
	.word 0xb435c000  ! 6337: SUBC_R	orn 	%r23, %r0, %r26
	.word 0xf84c4000  ! 6343: LDSB_R	ldsb	[%r17 + %r0], %r28
	mov	0, %r12
	.word 0x8f932000  ! 6344: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf2454000  ! 6345: LDSW_R	ldsw	[%r21 + %r0], %r25
	.word 0xf40de034  ! 6349: LDUB_I	ldub	[%r23 + 0x0034], %r26
	.word 0xf44da0b0  ! 6352: LDSB_I	ldsb	[%r22 + 0x00b0], %r26
	mov	2, %r12
	.word 0x8f932000  ! 6354: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf80461ce  ! 6355: LDUW_I	lduw	[%r17 + 0x01ce], %r28
	.word 0xf40521bf  ! 6356: LDUW_I	lduw	[%r20 + 0x01bf], %r26
	.word 0x8795a00e  ! 6357: WRPR_TT_I	wrpr	%r22, 0x000e, %tt
hwintr_2_292:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_292), 16, 16)) -> intp(2, 0, 3a)
	.word 0xb1480000  ! 6359: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xfa1ce14a  ! 6360: LDD_I	ldd	[%r19 + 0x014a], %r29
	.word 0xfe5c4000  ! 6369: LDX_R	ldx	[%r17 + %r0], %r31
	.word 0xba850000  ! 6372: ADDcc_R	addcc 	%r20, %r0, %r29
hwintr_2_293:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_293), 16, 16)) -> intp(2, 0, 3f)
	setx	data_start_6, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb09c0000  ! 6384: XORcc_R	xorcc 	%r16, %r0, %r24
	.word 0xf05d0000  ! 6387: LDX_R	ldx	[%r20 + %r0], %r24
	.word 0xb8240000  ! 6389: SUB_R	sub 	%r16, %r0, %r28
	.word 0xfc0d61fa  ! 6393: LDUB_I	ldub	[%r21 + 0x01fa], %r30
	.word 0xf8148000  ! 6394: LDUH_R	lduh	[%r18 + %r0], %r28
	.word 0xf654613b  ! 6399: LDSH_I	ldsh	[%r17 + 0x013b], %r27
	.word 0x8794e08a  ! 6403: WRPR_TT_I	wrpr	%r19, 0x008a, %tt
	.word 0xf2550000  ! 6408: LDSH_R	ldsh	[%r20 + %r0], %r25
	.word 0xfe5da1db  ! 6411: LDX_I	ldx	[%r22 + 0x01db], %r31
	.word 0xf84c8000  ! 6412: LDSB_R	ldsb	[%r18 + %r0], %r28
	.word 0xb9504000  ! 6414: RDPR_TNPC	<illegal instruction>
hwintr_2_294:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_294), 16, 16)) -> intp(2, 0, 1f)
	.word 0xfe14615f  ! 6422: LDUH_I	lduh	[%r17 + 0x015f], %r31
	.word 0xf804a16c  ! 6424: LDUW_I	lduw	[%r18 + 0x016c], %r28
	ta	T_CHANGE_HPRIV
	.word 0x819828d9  ! 6425: WRHPR_HPSTATE_I	wrhpr	%r0, 0x08d9, %hpstate
	.word 0xf04d8000  ! 6426: LDSB_R	ldsb	[%r22 + %r0], %r24
	.word 0xb9518000  ! 6427: RDPR_PSTATE	<illegal instruction>
	.word 0xf11cc000  ! 6429: LDDF_R	ldd	[%r19, %r0], %f24
	.word 0xfa0cc000  ! 6431: LDUB_R	ldub	[%r19 + %r0], %r29
	.word 0x8194a04f  ! 6433: WRPR_TPC_I	wrpr	%r18, 0x004f, %tpc
	.word 0xb5480000  ! 6435: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
hwintr_2_295:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_295), 16, 16)) -> intp(2, 0, d)
hwintr_2_296:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_296), 16, 16)) -> intp(2, 0, 2c)
	.word 0xbf2d9000  ! 6444: SLLX_R	sllx	%r22, %r0, %r31
	.word 0xf11c20ea  ! 6445: LDDF_I	ldd	[%r16, 0x00ea], %f24
	.word 0xf814c000  ! 6447: LDUH_R	lduh	[%r19 + %r0], %r28
hwintr_2_297:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_297), 16, 16)) -> intp(2, 0, b)
	.word 0xb32cd000  ! 6449: SLLX_R	sllx	%r19, %r0, %r25
	.word 0xf41c617b  ! 6451: LDD_I	ldd	[%r17 + 0x017b], %r26
hwintr_2_298:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_298), 16, 16)) -> intp(2, 0, b)
	.word 0xf25dc000  ! 6456: LDX_R	ldx	[%r23 + %r0], %r25
	.word 0xfe542174  ! 6458: LDSH_I	ldsh	[%r16 + 0x0174], %r31
	.word 0x8194e1e5  ! 6461: WRPR_TPC_I	wrpr	%r19, 0x01e5, %tpc
	ta	T_CHANGE_HPRIV
	.word 0x81982b59  ! 6463: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b59, %hpstate
hwintr_2_299:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_299), 16, 16)) -> intp(2, 0, c)
	ta	T_CHANGE_HPRIV
	.word 0x81983ec1  ! 6465: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1ec1, %hpstate
	.word 0xfc548000  ! 6466: LDSH_R	ldsh	[%r18 + %r0], %r30
	.word 0xb48c4000  ! 6468: ANDcc_R	andcc 	%r17, %r0, %r26
	.word 0xf654e196  ! 6469: LDSH_I	ldsh	[%r19 + 0x0196], %r27
	.word 0xf214a0cc  ! 6472: LDUH_I	lduh	[%r18 + 0x00cc], %r25
	.word 0xf24c2077  ! 6475: LDSB_I	ldsb	[%r16 + 0x0077], %r25
	.word 0xb73d8000  ! 6476: SRA_R	sra 	%r22, %r0, %r27
	.word 0x8394e087  ! 6477: WRPR_TNPC_I	wrpr	%r19, 0x0087, %tnpc
	.word 0xfa1c8000  ! 6478: LDD_R	ldd	[%r18 + %r0], %r29
	.word 0xf40c8000  ! 6482: LDUB_R	ldub	[%r18 + %r0], %r26
	.word 0x839460a9  ! 6483: WRPR_TNPC_I	wrpr	%r17, 0x00a9, %tnpc
	.word 0xbb540000  ! 6485: RDPR_GL	<illegal instruction>
	.word 0xb9348000  ! 6488: SRL_R	srl 	%r18, %r0, %r28
	.word 0xfc44c000  ! 6491: LDSW_R	ldsw	[%r19 + %r0], %r30
	.word 0xf41ce09d  ! 6495: LDD_I	ldd	[%r19 + 0x009d], %r26
	.word 0xfc5c209f  ! 6497: LDX_I	ldx	[%r16 + 0x009f], %r30
	.word 0x9194601a  ! 6498: WRPR_PIL_I	wrpr	%r17, 0x001a, %pil
	.word 0xff1c6141  ! 6502: LDDF_I	ldd	[%r17, 0x0141], %f31
	.word 0x8195618e  ! 6503: WRPR_TPC_I	wrpr	%r21, 0x018e, %tpc
	.word 0xbb520000  ! 6505: RDPR_PIL	<illegal instruction>
	.word 0xf045c000  ! 6512: LDSW_R	ldsw	[%r23 + %r0], %r24
hwintr_2_300:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_300), 16, 16)) -> intp(2, 0, 1d)
hwintr_2_301:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_301), 16, 16)) -> intp(2, 0, 1e)
	.word 0xf01d21c4  ! 6517: LDD_I	ldd	[%r20 + 0x01c4], %r24
	.word 0x839420aa  ! 6519: WRPR_TNPC_I	wrpr	%r16, 0x00aa, %tnpc
	.word 0x8794a015  ! 6520: WRPR_TT_I	wrpr	%r18, 0x0015, %tt
	.word 0xb1510000  ! 6523: RDPR_TICK	<illegal instruction>
	.word 0xfa1ca0fb  ! 6524: LDD_I	ldd	[%r18 + 0x00fb], %r29
	.word 0xb0c5e15e  ! 6526: ADDCcc_I	addccc 	%r23, 0x015e, %r24
	.word 0xf11d2003  ! 6527: LDDF_I	ldd	[%r20, 0x0003], %f24
	.word 0xb5500000  ! 6529: RDPR_TPC	<illegal instruction>
	.word 0xf80c0000  ! 6531: LDUB_R	ldub	[%r16 + %r0], %r28
	.word 0xf244e02d  ! 6539: LDSW_I	ldsw	[%r19 + 0x002d], %r25
	setx	data_start_4, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf20dc000  ! 6542: LDUB_R	ldub	[%r23 + %r0], %r25
	.word 0xb8bc8000  ! 6546: XNORcc_R	xnorcc 	%r18, %r0, %r28
	.word 0xf845e160  ! 6550: LDSW_I	ldsw	[%r23 + 0x0160], %r28
	.word 0xbb2c2001  ! 6551: SLL_I	sll 	%r16, 0x0001, %r29
	.word 0xb9508000  ! 6552: RDPR_TSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982d03  ! 6553: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d03, %hpstate
	.word 0xb63d8000  ! 6554: XNOR_R	xnor 	%r22, %r0, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982dd1  ! 6555: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dd1, %hpstate
	.word 0xf24ca03a  ! 6556: LDSB_I	ldsb	[%r18 + 0x003a], %r25
	.word 0xb93d8000  ! 6557: SRA_R	sra 	%r22, %r0, %r28
	.word 0xbb7d4400  ! 6562: MOVR_R	movre	%r21, %r0, %r29
	.word 0xf455a0cd  ! 6565: LDSH_I	ldsh	[%r22 + 0x00cd], %r26
	.word 0x9195603c  ! 6567: WRPR_PIL_I	wrpr	%r21, 0x003c, %pil
	.word 0xb9480000  ! 6568: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xf71c4000  ! 6569: LDDF_R	ldd	[%r17, %r0], %f27
	.word 0xb245c000  ! 6571: ADDC_R	addc 	%r23, %r0, %r25
	.word 0xfc156119  ! 6575: LDUH_I	lduh	[%r21 + 0x0119], %r30
	.word 0xf4448000  ! 6576: LDSW_R	ldsw	[%r18 + %r0], %r26
	.word 0x8994e0e9  ! 6577: WRPR_TICK_I	wrpr	%r19, 0x00e9, %tick
	.word 0xf41cc000  ! 6578: LDD_R	ldd	[%r19 + %r0], %r26
	.word 0x8d95a078  ! 6584: WRPR_PSTATE_I	wrpr	%r22, 0x0078, %pstate
	.word 0xf25cc000  ! 6591: LDX_R	ldx	[%r19 + %r0], %r25
	.word 0xf2550000  ! 6594: LDSH_R	ldsh	[%r20 + %r0], %r25
	.word 0xf6454000  ! 6597: LDSW_R	ldsw	[%r21 + %r0], %r27
	.word 0xfc5cc000  ! 6598: LDX_R	ldx	[%r19 + %r0], %r30
	.word 0xf05ca187  ! 6599: LDX_I	ldx	[%r18 + 0x0187], %r24
hwintr_2_302:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_302), 16, 16)) -> intp(2, 0, 35)
	.word 0xb2150000  ! 6607: OR_R	or 	%r20, %r0, %r25
hwintr_2_303:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_303), 16, 16)) -> intp(2, 0, 34)
	.word 0xfa15c000  ! 6610: LDUH_R	lduh	[%r23 + %r0], %r29
	.word 0xfe450000  ! 6615: LDSW_R	ldsw	[%r20 + %r0], %r31
	.word 0xf45d0000  ! 6618: LDX_R	ldx	[%r20 + %r0], %r26
	.word 0xbb51c000  ! 6619: RDPR_TL	rdpr	%tl, %r29
	.word 0xf05c8000  ! 6621: LDX_R	ldx	[%r18 + %r0], %r24
	.word 0xbd50c000  ! 6622: RDPR_TT	<illegal instruction>
	.word 0xb5500000  ! 6623: RDPR_TPC	<illegal instruction>
	.word 0xf65d8000  ! 6626: LDX_R	ldx	[%r22 + %r0], %r27
	.word 0xfe44c000  ! 6627: LDSW_R	ldsw	[%r19 + %r0], %r31
	.word 0xf855e027  ! 6629: LDSH_I	ldsh	[%r23 + 0x0027], %r28
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	setx	data_start_4, %g1, %r20
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r20, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8d95213b  ! 6632: WRPR_PSTATE_I	wrpr	%r20, 0x013b, %pstate
	.word 0xf405c000  ! 6637: LDUW_R	lduw	[%r23 + %r0], %r26
	.word 0xf054e13b  ! 6640: LDSH_I	ldsh	[%r19 + 0x013b], %r24
	.word 0xf0044000  ! 6641: LDUW_R	lduw	[%r17 + %r0], %r24
	setx	data_start_1, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfa0de048  ! 6646: LDUB_I	ldub	[%r23 + 0x0048], %r29
	.word 0xbf353001  ! 6647: SRLX_I	srlx	%r20, 0x0001, %r31
	.word 0xbd7c4400  ! 6648: MOVR_R	movre	%r17, %r0, %r30
	.word 0xfc4420a8  ! 6651: LDSW_I	ldsw	[%r16 + 0x00a8], %r30
hwintr_2_304:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_304), 16, 16)) -> intp(2, 0, 1a)
	.word 0xf84d4000  ! 6655: LDSB_R	ldsb	[%r21 + %r0], %r28
	.word 0xb1350000  ! 6659: SRL_R	srl 	%r20, %r0, %r24
	.word 0xb3480000  ! 6661: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xf005c000  ! 6663: LDUW_R	lduw	[%r23 + %r0], %r24
	.word 0xf4448000  ! 6667: LDSW_R	ldsw	[%r18 + %r0], %r26
	.word 0xf8446179  ! 6668: LDSW_I	ldsw	[%r17 + 0x0179], %r28
	.word 0xf21ca1fa  ! 6669: LDD_I	ldd	[%r18 + 0x01fa], %r25
	.word 0xbf504000  ! 6675: RDPR_TNPC	<illegal instruction>
	.word 0x819461a6  ! 6677: WRPR_TPC_I	wrpr	%r17, 0x01a6, %tpc
	.word 0xf20de0da  ! 6679: LDUB_I	ldub	[%r23 + 0x00da], %r25
hwintr_2_305:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_305), 16, 16)) -> intp(2, 0, 3a)
	ta	T_CHANGE_HPRIV
	.word 0x81983b19  ! 6682: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b19, %hpstate
	.word 0xb82c2143  ! 6684: ANDN_I	andn 	%r16, 0x0143, %r28
	.word 0xbb480000  ! 6685: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xf805a01b  ! 6687: LDUW_I	lduw	[%r22 + 0x001b], %r28
	.word 0xf60dc000  ! 6689: LDUB_R	ldub	[%r23 + %r0], %r27
	.word 0xfe1ce131  ! 6690: LDD_I	ldd	[%r19 + 0x0131], %r31
	.word 0xb52c1000  ! 6694: SLLX_R	sllx	%r16, %r0, %r26
	.word 0xf11d4000  ! 6695: LDDF_R	ldd	[%r21, %r0], %f24
	.word 0xbd518000  ! 6698: RDPR_PSTATE	<illegal instruction>
	.word 0xfc548000  ! 6699: LDSH_R	ldsh	[%r18 + %r0], %r30
	.word 0xb7520000  ! 6702: RDPR_PIL	<illegal instruction>
	.word 0xf0046095  ! 6705: LDUW_I	lduw	[%r17 + 0x0095], %r24
	.word 0xb0848000  ! 6706: ADDcc_R	addcc 	%r18, %r0, %r24
	.word 0xfc0d8000  ! 6709: LDUB_R	ldub	[%r22 + %r0], %r30
	.word 0xf2142068  ! 6714: LDUH_I	lduh	[%r16 + 0x0068], %r25
hwintr_2_306:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_306), 16, 16)) -> intp(2, 0, 29)
	setx	data_start_7, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf60461a4  ! 6720: LDUW_I	lduw	[%r17 + 0x01a4], %r27
	.word 0xf445e067  ! 6721: LDSW_I	ldsw	[%r23 + 0x0067], %r26
hwintr_2_307:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_307), 16, 16)) -> intp(2, 0, f)
	.word 0xf844e062  ! 6723: LDSW_I	ldsw	[%r19 + 0x0062], %r28
	.word 0xf244a005  ! 6724: LDSW_I	ldsw	[%r18 + 0x0005], %r25
	.word 0xb7540000  ! 6725: RDPR_GL	<illegal instruction>
	.word 0xf25ca019  ! 6726: LDX_I	ldx	[%r18 + 0x0019], %r25
	.word 0xf80c0000  ! 6731: LDUB_R	ldub	[%r16 + %r0], %r28
	.word 0xb3500000  ! 6732: RDPR_TPC	<illegal instruction>
	.word 0xb7500000  ! 6733: RDPR_TPC	<illegal instruction>
	setx	data_start_1, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb48d21f3  ! 6736: ANDcc_I	andcc 	%r20, 0x01f3, %r26
	.word 0xf0044000  ! 6739: LDUW_R	lduw	[%r17 + %r0], %r24
	.word 0xf21dc000  ! 6742: LDD_R	ldd	[%r23 + %r0], %r25
	.word 0xf6450000  ! 6744: LDSW_R	ldsw	[%r20 + %r0], %r27
	.word 0x8395e03f  ! 6745: WRPR_TNPC_I	wrpr	%r23, 0x003f, %tnpc
	.word 0xb7510000  ! 6749: RDPR_TICK	<illegal instruction>
	.word 0xb8a4e13a  ! 6750: SUBcc_I	subcc 	%r19, 0x013a, %r28
	.word 0xf11d0000  ! 6751: LDDF_R	ldd	[%r20, %r0], %f24
	.word 0xb33d8000  ! 6755: SRA_R	sra 	%r22, %r0, %r25
	.word 0xb9504000  ! 6758: RDPR_TNPC	<illegal instruction>
	setx	data_start_0, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf0540000  ! 6761: LDSH_R	ldsh	[%r16 + %r0], %r24
hwintr_2_308:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_308), 16, 16)) -> intp(2, 0, 1f)
	.word 0xf25cc000  ! 6765: LDX_R	ldx	[%r19 + %r0], %r25
	.word 0xbd520000  ! 6767: RDPR_PIL	<illegal instruction>
	.word 0xfa04a194  ! 6769: LDUW_I	lduw	[%r18 + 0x0194], %r29
	.word 0x919520cd  ! 6770: WRPR_PIL_I	wrpr	%r20, 0x00cd, %pil
	.word 0xb7356001  ! 6772: SRL_I	srl 	%r21, 0x0001, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982c19  ! 6774: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c19, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81983881  ! 6777: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1881, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81982f01  ! 6780: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f01, %hpstate
	.word 0xfe0420eb  ! 6781: LDUW_I	lduw	[%r16 + 0x00eb], %r31
hwintr_2_309:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_309), 16, 16)) -> intp(2, 0, 37)
	.word 0xf25d0000  ! 6787: LDX_R	ldx	[%r20 + %r0], %r25
	.word 0xb62c0000  ! 6788: ANDN_R	andn 	%r16, %r0, %r27
	.word 0xf2446026  ! 6791: LDSW_I	ldsw	[%r17 + 0x0026], %r25
	.word 0xfd1d4000  ! 6793: LDDF_R	ldd	[%r21, %r0], %f30
	.word 0xf0458000  ! 6794: LDSW_R	ldsw	[%r22 + %r0], %r24
	.word 0xf41d60f3  ! 6795: LDD_I	ldd	[%r21 + 0x00f3], %r26
	setx	data_start_4, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf814c000  ! 6800: LDUH_R	lduh	[%r19 + %r0], %r28
	.word 0xbb504000  ! 6802: RDPR_TNPC	<illegal instruction>
	.word 0xf8540000  ! 6808: LDSH_R	ldsh	[%r16 + %r0], %r28
hwintr_2_310:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_310), 16, 16)) -> intp(2, 0, 2c)
	.word 0xb1480000  ! 6813: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xfc1460f5  ! 6815: LDUH_I	lduh	[%r17 + 0x00f5], %r30
	.word 0xf644205f  ! 6817: LDSW_I	ldsw	[%r16 + 0x005f], %r27
	.word 0xf24c615f  ! 6818: LDSB_I	ldsb	[%r17 + 0x015f], %r25
	.word 0xf45de080  ! 6823: LDX_I	ldx	[%r23 + 0x0080], %r26
	.word 0xf51dc000  ! 6824: LDDF_R	ldd	[%r23, %r0], %f26
	.word 0xb37ce401  ! 6827: MOVR_I	movre	%r19, 0x1, %r25
	.word 0xb0446159  ! 6829: ADDC_I	addc 	%r17, 0x0159, %r24
	.word 0xbf3dd000  ! 6831: SRAX_R	srax	%r23, %r0, %r31
	.word 0xf244c000  ! 6833: LDSW_R	ldsw	[%r19 + %r0], %r25
hwintr_2_311:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_311), 16, 16)) -> intp(2, 0, 10)
	.word 0xfa1da133  ! 6843: LDD_I	ldd	[%r22 + 0x0133], %r29
	.word 0xf31c0000  ! 6846: LDDF_R	ldd	[%r16, %r0], %f25
	.word 0xfa1c6187  ! 6851: LDD_I	ldd	[%r17 + 0x0187], %r29
	.word 0xf61ca0e1  ! 6855: LDD_I	ldd	[%r18 + 0x00e1], %r27
	.word 0xfa046042  ! 6859: LDUW_I	lduw	[%r17 + 0x0042], %r29
	.word 0xb485e10c  ! 6860: ADDcc_I	addcc 	%r23, 0x010c, %r26
hwintr_2_312:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_312), 16, 16)) -> intp(2, 0, 13)
	.word 0xf2048000  ! 6865: LDUW_R	lduw	[%r18 + %r0], %r25
	.word 0xbf51c000  ! 6866: RDPR_TL	<illegal instruction>
	.word 0xfe1da14a  ! 6867: LDD_I	ldd	[%r22 + 0x014a], %r31
	.word 0xb635a1fa  ! 6868: SUBC_I	orn 	%r22, 0x01fa, %r27
	.word 0xbc1ce1ad  ! 6874: XOR_I	xor 	%r19, 0x01ad, %r30
	.word 0xfb1dc000  ! 6877: LDDF_R	ldd	[%r23, %r0], %f29
	.word 0xf64d4000  ! 6880: LDSB_R	ldsb	[%r21 + %r0], %r27
	mov	1, %r12
	.word 0x8f932000  ! 6883: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf244e0de  ! 6886: LDSW_I	ldsw	[%r19 + 0x00de], %r25
	.word 0xf24cc000  ! 6887: LDSB_R	ldsb	[%r19 + %r0], %r25
	.word 0xf24d8000  ! 6888: LDSB_R	ldsb	[%r22 + %r0], %r25
	.word 0xf2558000  ! 6890: LDSH_R	ldsh	[%r22 + %r0], %r25
	.word 0x87942139  ! 6893: WRPR_TT_I	wrpr	%r16, 0x0139, %tt
	.word 0xfc5cc000  ! 6895: LDX_R	ldx	[%r19 + %r0], %r30
	.word 0xf6550000  ! 6896: LDSH_R	ldsh	[%r20 + %r0], %r27
hwintr_2_313:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_313), 16, 16)) -> intp(2, 0, 27)
	.word 0xb7504000  ! 6898: RDPR_TNPC	<illegal instruction>
	.word 0x81952069  ! 6899: WRPR_TPC_I	wrpr	%r20, 0x0069, %tpc
	.word 0xf0152111  ! 6901: LDUH_I	lduh	[%r20 + 0x0111], %r24
	.word 0xf845203b  ! 6904: LDSW_I	ldsw	[%r20 + 0x003b], %r28
	.word 0xb3540000  ! 6910: RDPR_GL	<illegal instruction>
	.word 0xf015e1d8  ! 6911: LDUH_I	lduh	[%r23 + 0x01d8], %r24
	.word 0xbc1d2095  ! 6916: XOR_I	xor 	%r20, 0x0095, %r30
	.word 0xfc0d6113  ! 6918: LDUB_I	ldub	[%r21 + 0x0113], %r30
	.word 0xfc044000  ! 6924: LDUW_R	lduw	[%r17 + %r0], %r30
	.word 0xbd520000  ! 6927: RDPR_PIL	<illegal instruction>
	.word 0xfc0d2018  ! 6928: LDUB_I	ldub	[%r20 + 0x0018], %r30
hwintr_2_314:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_314), 16, 16)) -> intp(2, 0, 31)
hwintr_2_315:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_315), 16, 16)) -> intp(2, 0, 1d)
	.word 0xfe04e071  ! 6936: LDUW_I	lduw	[%r19 + 0x0071], %r31
hwintr_2_316:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_316), 16, 16)) -> intp(2, 0, 3c)
	.word 0xfc548000  ! 6940: LDSH_R	ldsh	[%r18 + %r0], %r30
hwintr_2_317:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_317), 16, 16)) -> intp(2, 0, 15)
	ta	T_CHANGE_HPRIV
	.word 0x81982cc9  ! 6943: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0cc9, %hpstate
	.word 0xb57c2401  ! 6945: MOVR_I	movre	%r16, 0x1, %r26
	.word 0xb534a001  ! 6948: SRL_I	srl 	%r18, 0x0001, %r26
	.word 0xb551c000  ! 6949: RDPR_TL	<illegal instruction>
	.word 0xf4052136  ! 6950: LDUW_I	lduw	[%r20 + 0x0136], %r26
	.word 0xf244602c  ! 6956: LDSW_I	ldsw	[%r17 + 0x002c], %r25
	ta	T_CHANGE_HPRIV
	.word 0x81983c49  ! 6957: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c49, %hpstate
	.word 0xf01d8000  ! 6959: LDD_R	ldd	[%r22 + %r0], %r24
hwintr_2_318:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_318), 16, 16)) -> intp(2, 0, 3d)
	.word 0xf8554000  ! 6968: LDSH_R	ldsh	[%r21 + %r0], %r28
	.word 0xf644c000  ! 6970: LDSW_R	ldsw	[%r19 + %r0], %r27
	.word 0xbd3da001  ! 6972: SRA_I	sra 	%r22, 0x0001, %r30
	.word 0xb3518000  ! 6981: RDPR_PSTATE	<illegal instruction>
	.word 0xf04c0000  ! 6984: LDSB_R	ldsb	[%r16 + %r0], %r24
	.word 0xb00ca0f9  ! 6986: AND_I	and 	%r18, 0x00f9, %r24
	.word 0xf91c6169  ! 6988: LDDF_I	ldd	[%r17, 0x0169], %f28
hwintr_2_319:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_319), 16, 16)) -> intp(2, 0, 2d)
hwintr_2_320:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_320), 16, 16)) -> intp(2, 0, 1f)
hwintr_2_321:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_321), 16, 16)) -> intp(2, 0, 22)
	.word 0xf84c0000  ! 6992: LDSB_R	ldsb	[%r16 + %r0], %r28
	.word 0xf41ca1d4  ! 6994: LDD_I	ldd	[%r18 + 0x01d4], %r26
	ta	T_CHANGE_HPRIV
	.word 0x81982893  ! 6996: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0893, %hpstate
	.word 0xfa4ce191  ! 6999: LDSB_I	ldsb	[%r19 + 0x0191], %r29
	.word 0xfe14a076  ! 7000: LDUH_I	lduh	[%r18 + 0x0076], %r31
	.word 0xfc0520eb  ! 7001: LDUW_I	lduw	[%r20 + 0x00eb], %r30
	setx	data_start_3, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf71c603c  ! 7008: LDDF_I	ldd	[%r17, 0x003c], %f27
	.word 0xfd1dc000  ! 7009: LDDF_R	ldd	[%r23, %r0], %f30
	.word 0xf4144000  ! 7010: LDUH_R	lduh	[%r17 + %r0], %r26
	.word 0x8594a181  ! 7011: WRPR_TSTATE_I	wrpr	%r18, 0x0181, %tstate
	.word 0xf4544000  ! 7012: LDSH_R	ldsh	[%r17 + %r0], %r26
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0x8795a0d9  ! 7016: WRPR_TT_I	wrpr	%r22, 0x00d9, %tt
	.word 0xf41ce0a9  ! 7017: LDD_I	ldd	[%r19 + 0x00a9], %r26
	.word 0xbd518000  ! 7024: RDPR_PSTATE	<illegal instruction>
	.word 0xf2454000  ! 7028: LDSW_R	ldsw	[%r21 + %r0], %r25
hwintr_2_322:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_322), 16, 16)) -> intp(2, 0, 1f)
	.word 0xf61dc000  ! 7030: LDD_R	ldd	[%r23 + %r0], %r27
	.word 0xbebd2163  ! 7031: XNORcc_I	xnorcc 	%r20, 0x0163, %r31
	setx	data_start_1, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xbb51c000  ! 7035: RDPR_TL	<illegal instruction>
	.word 0xf00d0000  ! 7038: LDUB_R	ldub	[%r20 + %r0], %r24
	.word 0xfa5d2073  ! 7039: LDX_I	ldx	[%r20 + 0x0073], %r29
hwintr_2_323:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_323), 16, 16)) -> intp(2, 0, 29)
	.word 0xb9518000  ! 7042: RDPR_PSTATE	<illegal instruction>
hwintr_2_324:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_324), 16, 16)) -> intp(2, 0, 1c)
	ta	T_CHANGE_HPRIV
	.word 0x819838db  ! 7047: WRHPR_HPSTATE_I	wrhpr	%r0, 0x18db, %hpstate
	.word 0xfa54e008  ! 7050: LDSH_I	ldsh	[%r19 + 0x0008], %r29
	.word 0xfd1c8000  ! 7051: LDDF_R	ldd	[%r18, %r0], %f30
	.word 0x9194214c  ! 7052: WRPR_PIL_I	wrpr	%r16, 0x014c, %pil
	.word 0xb9510000  ! 7053: RDPR_TICK	rdpr	%tick, %r28
	.word 0x9195a137  ! 7056: WRPR_PIL_I	wrpr	%r22, 0x0137, %pil
	.word 0xf24c21c6  ! 7061: LDSB_I	ldsb	[%r16 + 0x01c6], %r25
	.word 0xb93d8000  ! 7062: SRA_R	sra 	%r22, %r0, %r28
	.word 0xf31c2018  ! 7063: LDDF_I	ldd	[%r16, 0x0018], %f25
	.word 0xf045a1fc  ! 7064: LDSW_I	ldsw	[%r22 + 0x01fc], %r24
	.word 0x91942063  ! 7069: WRPR_PIL_I	wrpr	%r16, 0x0063, %pil
	.word 0xbe04e1ec  ! 7071: ADD_I	add 	%r19, 0x01ec, %r31
	.word 0xfe5dc000  ! 7072: LDX_R	ldx	[%r23 + %r0], %r31
	.word 0xf65cc000  ! 7076: LDX_R	ldx	[%r19 + %r0], %r27
	.word 0xb415c000  ! 7080: OR_R	or 	%r23, %r0, %r26
	.word 0xf255613f  ! 7081: LDSH_I	ldsh	[%r21 + 0x013f], %r25
	.word 0xf05c0000  ! 7083: LDX_R	ldx	[%r16 + %r0], %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982ec9  ! 7084: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0ec9, %hpstate
	.word 0xf2456102  ! 7086: LDSW_I	ldsw	[%r21 + 0x0102], %r25
	.word 0xf81d6080  ! 7088: LDD_I	ldd	[%r21 + 0x0080], %r28
	.word 0xff1d21c8  ! 7092: LDDF_I	ldd	[%r20, 0x01c8], %f31
hwintr_2_325:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_325), 16, 16)) -> intp(2, 0, 1b)
	.word 0x8d94a0c0  ! 7096: WRPR_PSTATE_I	wrpr	%r18, 0x00c0, %pstate
	.word 0xb3510000  ! 7098: RDPR_TICK	<illegal instruction>
	.word 0xf84d2013  ! 7100: LDSB_I	ldsb	[%r20 + 0x0013], %r28
	.word 0xf4458000  ! 7105: LDSW_R	ldsw	[%r22 + %r0], %r26
	.word 0xbd359000  ! 7106: SRLX_R	srlx	%r22, %r0, %r30
	mov	0, %r14
	.word 0xa193a000  ! 7111: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf05461b2  ! 7112: LDSH_I	ldsh	[%r17 + 0x01b2], %r24
	.word 0xb605c000  ! 7113: ADD_R	add 	%r23, %r0, %r27
hwintr_2_326:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_326), 16, 16)) -> intp(2, 0, 21)
	.word 0xb635215e  ! 7119: SUBC_I	orn 	%r20, 0x015e, %r27
	.word 0xf20d4000  ! 7121: LDUB_R	ldub	[%r21 + %r0], %r25
	.word 0xfa058000  ! 7126: LDUW_R	lduw	[%r22 + %r0], %r29
hwintr_2_327:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_327), 16, 16)) -> intp(2, 0, e)
	.word 0xf41c0000  ! 7129: LDD_R	ldd	[%r16 + %r0], %r26
	.word 0xb750c000  ! 7130: RDPR_TT	<illegal instruction>
	.word 0xb41c8000  ! 7135: XOR_R	xor 	%r18, %r0, %r26
	.word 0xbd2c0000  ! 7137: SLL_R	sll 	%r16, %r0, %r30
	.word 0xbf51c000  ! 7138: RDPR_TL	<illegal instruction>
	setx	data_start_3, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xff1cc000  ! 7143: LDDF_R	ldd	[%r19, %r0], %f31
	.word 0xfa15c000  ! 7145: LDUH_R	lduh	[%r23 + %r0], %r29
	.word 0xf01da1ac  ! 7146: LDD_I	ldd	[%r22 + 0x01ac], %r24
	.word 0xf31c8000  ! 7147: LDDF_R	ldd	[%r18, %r0], %f25
	.word 0xbc1d4000  ! 7150: XOR_R	xor 	%r21, %r0, %r30
	.word 0xfe4cc000  ! 7157: LDSB_R	ldsb	[%r19 + %r0], %r31
	setx	data_start_7, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8195e158  ! 7162: WRPR_TPC_I	wrpr	%r23, 0x0158, %tpc
hwintr_2_328:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_328), 16, 16)) -> intp(2, 0, 17)
	.word 0xb5520000  ! 7166: RDPR_PIL	<illegal instruction>
	.word 0xfa4c0000  ! 7169: LDSB_R	ldsb	[%r16 + %r0], %r29
hwintr_2_329:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_329), 16, 16)) -> intp(2, 0, 35)
	.word 0x8994a1d9  ! 7178: WRPR_TICK_I	wrpr	%r18, 0x01d9, %tick
	.word 0x8794e1f6  ! 7179: WRPR_TT_I	wrpr	%r19, 0x01f6, %tt
	.word 0xfc5421c9  ! 7184: LDSH_I	ldsh	[%r16 + 0x01c9], %r30
	.word 0xfa1ce073  ! 7188: LDD_I	ldd	[%r19 + 0x0073], %r29
	.word 0x8794e09b  ! 7189: WRPR_TT_I	wrpr	%r19, 0x009b, %tt
	.word 0xf91de0f2  ! 7191: LDDF_I	ldd	[%r23, 0x00f2], %f28
	.word 0xfc5c6117  ! 7193: LDX_I	ldx	[%r17 + 0x0117], %r30
	.word 0xb7520000  ! 7194: RDPR_PIL	<illegal instruction>
	setx	data_start_3, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x89956121  ! 7200: WRPR_TICK_I	wrpr	%r21, 0x0121, %tick
	.word 0xf6144000  ! 7203: LDUH_R	lduh	[%r17 + %r0], %r27
	.word 0x8594617e  ! 7207: WRPR_TSTATE_I	wrpr	%r17, 0x017e, %tstate
hwintr_2_330:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_330), 16, 16)) -> intp(2, 0, 3)
	setx	data_start_0, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf80de09c  ! 7213: LDUB_I	ldub	[%r23 + 0x009c], %r28
	.word 0xf91c4000  ! 7216: LDDF_R	ldd	[%r17, %r0], %f28
	.word 0xb150c000  ! 7217: RDPR_TT	<illegal instruction>
	.word 0xb7504000  ! 7221: RDPR_TNPC	<illegal instruction>
	.word 0xbc24c000  ! 7222: SUB_R	sub 	%r19, %r0, %r30
	.word 0xf0040000  ! 7225: LDUW_R	lduw	[%r16 + %r0], %r24
	.word 0xf0450000  ! 7226: LDSW_R	ldsw	[%r20 + %r0], %r24
hwintr_2_331:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_331), 16, 16)) -> intp(2, 0, 1f)
	mov	1, %r14
	.word 0xa193a000  ! 7235: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	mov	0, %r14
	.word 0xa193a000  ! 7237: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_2_332:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_332), 16, 16)) -> intp(2, 0, 39)
	ta	T_CHANGE_HPRIV
	.word 0x81983fdb  ! 7242: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1fdb, %hpstate
	setx	data_start_2, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x9194a1bd  ! 7247: WRPR_PIL_I	wrpr	%r18, 0x01bd, %pil
	ta	T_CHANGE_HPRIV
	.word 0x81982e41  ! 7250: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e41, %hpstate
	.word 0x8594a1b7  ! 7251: WRPR_TSTATE_I	wrpr	%r18, 0x01b7, %tstate
	.word 0xf05da144  ! 7255: LDX_I	ldx	[%r22 + 0x0144], %r24
	mov	2, %r12
	.word 0x8f932000  ! 7259: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfb1c8000  ! 7261: LDDF_R	ldd	[%r18, %r0], %f29
	.word 0xf21da000  ! 7262: LDD_I	ldd	[%r22 + 0x0000], %r25
	.word 0xbd518000  ! 7267: RDPR_PSTATE	<illegal instruction>
	.word 0xbebd8000  ! 7268: XNORcc_R	xnorcc 	%r22, %r0, %r31
	.word 0xf04c0000  ! 7270: LDSB_R	ldsb	[%r16 + %r0], %r24
	.word 0xb12ca001  ! 7272: SLL_I	sll 	%r18, 0x0001, %r24
	.word 0xfc450000  ! 7273: LDSW_R	ldsw	[%r20 + %r0], %r30
	.word 0xbea42066  ! 7278: SUBcc_I	subcc 	%r16, 0x0066, %r31
	.word 0xf404e169  ! 7283: LDUW_I	lduw	[%r19 + 0x0169], %r26
	.word 0xf04d614c  ! 7289: LDSB_I	ldsb	[%r21 + 0x014c], %r24
	.word 0xf25da03d  ! 7290: LDX_I	ldx	[%r22 + 0x003d], %r25
	.word 0xfe4cc000  ! 7291: LDSB_R	ldsb	[%r19 + %r0], %r31
	.word 0xf81c8000  ! 7292: LDD_R	ldd	[%r18 + %r0], %r28
	.word 0xf404e0f4  ! 7294: LDUW_I	lduw	[%r19 + 0x00f4], %r26
	.word 0xf84ce0dc  ! 7296: LDSB_I	ldsb	[%r19 + 0x00dc], %r28
	.word 0xfe1c4000  ! 7297: LDD_R	ldd	[%r17 + %r0], %r31
	.word 0xfa5c8000  ! 7298: LDX_R	ldx	[%r18 + %r0], %r29
	.word 0xf41461f0  ! 7300: LDUH_I	lduh	[%r17 + 0x01f0], %r26
	.word 0xb151c000  ! 7302: RDPR_TL	<illegal instruction>
	.word 0x89956082  ! 7307: WRPR_TICK_I	wrpr	%r21, 0x0082, %tick
	.word 0xfe4d604b  ! 7310: LDSB_I	ldsb	[%r21 + 0x004b], %r31
	ta	T_CHANGE_HPRIV
	.word 0x8198389b  ! 7313: WRHPR_HPSTATE_I	wrhpr	%r0, 0x189b, %hpstate
	.word 0xb7510000  ! 7314: RDPR_TICK	<illegal instruction>
	.word 0xfc5c6147  ! 7315: LDX_I	ldx	[%r17 + 0x0147], %r30
	.word 0xf31ca070  ! 7316: LDDF_I	ldd	[%r18, 0x0070], %f25
	.word 0x81946051  ! 7322: WRPR_TPC_I	wrpr	%r17, 0x0051, %tpc
	.word 0xb72db001  ! 7323: SLLX_I	sllx	%r22, 0x0001, %r27
	mov	0, %r14
	.word 0xa193a000  ! 7332: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb68cc000  ! 7336: ANDcc_R	andcc 	%r19, %r0, %r27
	.word 0xfa044000  ! 7338: LDUW_R	lduw	[%r17 + %r0], %r29
	mov	1, %r14
	.word 0xa193a000  ! 7340: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_2_333:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_333), 16, 16)) -> intp(2, 0, 12)
	.word 0xf81c8000  ! 7344: LDD_R	ldd	[%r18 + %r0], %r28
	.word 0xb5520000  ! 7347: RDPR_PIL	<illegal instruction>
	.word 0xb3504000  ! 7349: RDPR_TNPC	<illegal instruction>
	.word 0xb8bc4000  ! 7353: XNORcc_R	xnorcc 	%r17, %r0, %r28
	.word 0xf64ca09a  ! 7354: LDSB_I	ldsb	[%r18 + 0x009a], %r27
	.word 0x8d94611e  ! 7360: WRPR_PSTATE_I	wrpr	%r17, 0x011e, %pstate
hwintr_2_334:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_334), 16, 16)) -> intp(2, 0, 21)
	setx	data_start_4, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xff1c4000  ! 7365: LDDF_R	ldd	[%r17, %r0], %f31
	.word 0x8394e1b9  ! 7367: WRPR_TNPC_I	wrpr	%r19, 0x01b9, %tnpc
	setx	data_start_0, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf2042154  ! 7370: LDUW_I	lduw	[%r16 + 0x0154], %r25
	.word 0xfe054000  ! 7371: LDUW_R	lduw	[%r21 + %r0], %r31
hwintr_2_335:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_335), 16, 16)) -> intp(2, 0, 4)
hwintr_2_336:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_336), 16, 16)) -> intp(2, 0, 17)
	.word 0xf11de1af  ! 7377: LDDF_I	ldd	[%r23, 0x01af], %f24
	mov	0, %r12
	.word 0x8f932000  ! 7383: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x8395e10c  ! 7387: WRPR_TNPC_I	wrpr	%r23, 0x010c, %tnpc
	.word 0x8594e11d  ! 7388: WRPR_TSTATE_I	wrpr	%r19, 0x011d, %tstate
	.word 0xb3641800  ! 7391: MOVcc_R	<illegal instruction>
	.word 0xf8558000  ! 7395: LDSH_R	ldsh	[%r22 + %r0], %r28
hwintr_2_337:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_337), 16, 16)) -> intp(2, 0, 36)
	.word 0xfe5da192  ! 7401: LDX_I	ldx	[%r22 + 0x0192], %r31
	.word 0xf91d2168  ! 7402: LDDF_I	ldd	[%r20, 0x0168], %f28
	.word 0xbb504000  ! 7403: RDPR_TNPC	<illegal instruction>
hwintr_2_338:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_338), 16, 16)) -> intp(2, 0, 3f)
	mov	0, %r12
	.word 0x8f932000  ! 7407: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_2_339:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_339), 16, 16)) -> intp(2, 0, f)
	.word 0xf71c8000  ! 7422: LDDF_R	ldd	[%r18, %r0], %f27
	.word 0xb09c2064  ! 7425: XORcc_I	xorcc 	%r16, 0x0064, %r24
	.word 0xbf504000  ! 7426: RDPR_TNPC	<illegal instruction>
	.word 0xfb1dc000  ! 7428: LDDF_R	ldd	[%r23, %r0], %f29
	.word 0xb550c000  ! 7429: RDPR_TT	<illegal instruction>
	.word 0xf445e106  ! 7431: LDSW_I	ldsw	[%r23 + 0x0106], %r26
	.word 0xb9520000  ! 7432: RDPR_PIL	<illegal instruction>
	.word 0xfa1c0000  ! 7433: LDD_R	ldd	[%r16 + %r0], %r29
	.word 0xfa558000  ! 7439: LDSH_R	ldsh	[%r22 + %r0], %r29
hwintr_2_340:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_340), 16, 16)) -> intp(2, 0, b)
	.word 0xf605c000  ! 7442: LDUW_R	lduw	[%r23 + %r0], %r27
	.word 0xf055a1c0  ! 7443: LDSH_I	ldsh	[%r22 + 0x01c0], %r24
	mov	1, %r14
	.word 0xa193a000  ! 7449: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_2_341:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_341), 16, 16)) -> intp(2, 0, 38)
	.word 0xfc0de128  ! 7454: LDUB_I	ldub	[%r23 + 0x0128], %r30
hwintr_2_342:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_342), 16, 16)) -> intp(2, 0, 1f)
	.word 0xb7504000  ! 7458: RDPR_TNPC	<illegal instruction>
hwintr_2_343:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_343), 16, 16)) -> intp(2, 0, 3b)
	.word 0xb9500000  ! 7464: RDPR_TPC	<illegal instruction>
	.word 0xf60ce080  ! 7465: LDUB_I	ldub	[%r19 + 0x0080], %r27
	.word 0xf0054000  ! 7468: LDUW_R	lduw	[%r21 + %r0], %r24
	.word 0xfe0c6017  ! 7469: LDUB_I	ldub	[%r17 + 0x0017], %r31
	.word 0x839420e9  ! 7471: WRPR_TNPC_I	wrpr	%r16, 0x00e9, %tnpc
	.word 0xf414a1f5  ! 7473: LDUH_I	lduh	[%r18 + 0x01f5], %r26
	.word 0xb5504000  ! 7474: RDPR_TNPC	<illegal instruction>
	.word 0xfc4c4000  ! 7475: LDSB_R	ldsb	[%r17 + %r0], %r30
	.word 0xf04ca0f9  ! 7478: LDSB_I	ldsb	[%r18 + 0x00f9], %r24
	ta	T_CHANGE_HPRIV
	.word 0x81983849  ! 7482: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1849, %hpstate
	.word 0xf0456110  ! 7483: LDSW_I	ldsw	[%r21 + 0x0110], %r24
	.word 0xb5508000  ! 7487: RDPR_TSTATE	<illegal instruction>
	.word 0xf40461ad  ! 7494: LDUW_I	lduw	[%r17 + 0x01ad], %r26
	.word 0xf11d61fc  ! 7495: LDDF_I	ldd	[%r21, 0x01fc], %f24
	.word 0xfe4d60cd  ! 7496: LDSB_I	ldsb	[%r21 + 0x00cd], %r31
	.word 0xfc0da17a  ! 7497: LDUB_I	ldub	[%r22 + 0x017a], %r30
	.word 0xf0056117  ! 7500: LDUW_I	lduw	[%r21 + 0x0117], %r24
	.word 0xf05cc000  ! 7505: LDX_R	ldx	[%r19 + %r0], %r24
hwintr_2_344:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_344), 16, 16)) -> intp(2, 0, 4)
	.word 0xbf480000  ! 7510: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xb37cc400  ! 7511: MOVR_R	movre	%r19, %r0, %r25
	.word 0xf20d4000  ! 7514: LDUB_R	ldub	[%r21 + %r0], %r25
	.word 0xfe5c4000  ! 7516: LDX_R	ldx	[%r17 + %r0], %r31
	.word 0xf25d21e3  ! 7517: LDX_I	ldx	[%r20 + 0x01e3], %r25
	.word 0xf64c606f  ! 7518: LDSB_I	ldsb	[%r17 + 0x006f], %r27
	.word 0xb8a46179  ! 7519: SUBcc_I	subcc 	%r17, 0x0179, %r28
	.word 0xb09c0000  ! 7527: XORcc_R	xorcc 	%r16, %r0, %r24
	.word 0xb88dc000  ! 7528: ANDcc_R	andcc 	%r23, %r0, %r28
	mov	0, %r14
	.word 0xa193a000  ! 7530: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf854c000  ! 7531: LDSH_R	ldsh	[%r19 + %r0], %r28
	.word 0xbd504000  ! 7534: RDPR_TNPC	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982e41  ! 7537: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e41, %hpstate
	.word 0xfe1c60e6  ! 7541: LDD_I	ldd	[%r17 + 0x00e6], %r31
	.word 0xf04d0000  ! 7543: LDSB_R	ldsb	[%r20 + %r0], %r24
	.word 0xf65ce0fb  ! 7546: LDX_I	ldx	[%r19 + 0x00fb], %r27
hwintr_2_345:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_345), 16, 16)) -> intp(2, 0, 10)
hwintr_2_346:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_346), 16, 16)) -> intp(2, 0, 21)
	.word 0xff1ce06e  ! 7552: LDDF_I	ldd	[%r19, 0x006e], %f31
	.word 0xf71cc000  ! 7556: LDDF_R	ldd	[%r19, %r0], %f27
	.word 0xb351c000  ! 7558: RDPR_TL	<illegal instruction>
	.word 0xf245c000  ! 7559: LDSW_R	ldsw	[%r23 + %r0], %r25
	.word 0x8594207c  ! 7560: WRPR_TSTATE_I	wrpr	%r16, 0x007c, %tstate
	.word 0x8994e04f  ! 7565: WRPR_TICK_I	wrpr	%r19, 0x004f, %tick
	.word 0xfe4c0000  ! 7567: LDSB_R	ldsb	[%r16 + %r0], %r31
	.word 0xf0050000  ! 7568: LDUW_R	lduw	[%r20 + %r0], %r24
	.word 0xfe14e1fc  ! 7570: LDUH_I	lduh	[%r19 + 0x01fc], %r31
	.word 0xf05de0e7  ! 7571: LDX_I	ldx	[%r23 + 0x00e7], %r24
	.word 0xb7480000  ! 7572: RDHPR_HPSTATE	rdhpr	%hpstate, %r27
	.word 0x919520e3  ! 7573: WRPR_PIL_I	wrpr	%r20, 0x00e3, %pil
	.word 0xfe048000  ! 7576: LDUW_R	lduw	[%r18 + %r0], %r31
	ta	T_CHANGE_HPRIV
	.word 0x81982ac1  ! 7577: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0ac1, %hpstate
	.word 0x8d95207b  ! 7578: WRPR_PSTATE_I	wrpr	%r20, 0x007b, %pstate
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xf65cc000  ! 7581: LDX_R	ldx	[%r19 + %r0], %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982dd1  ! 7585: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dd1, %hpstate
	.word 0xfc4ce117  ! 7588: LDSB_I	ldsb	[%r19 + 0x0117], %r30
hwintr_2_347:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_347), 16, 16)) -> intp(2, 0, 1f)
	.word 0xbd50c000  ! 7590: RDPR_TT	<illegal instruction>
	.word 0x8d95a0df  ! 7593: WRPR_PSTATE_I	wrpr	%r22, 0x00df, %pstate
	.word 0xb09da1b4  ! 7595: XORcc_I	xorcc 	%r22, 0x01b4, %r24
hwintr_2_348:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_348), 16, 16)) -> intp(2, 0, 18)
	.word 0xb150c000  ! 7599: RDPR_TT	<illegal instruction>
	.word 0xb3518000  ! 7600: RDPR_PSTATE	<illegal instruction>
	.word 0xbb358000  ! 7608: SRL_R	srl 	%r22, %r0, %r29
	.word 0xf11dc000  ! 7615: LDDF_R	ldd	[%r23, %r0], %f24
	.word 0xb8444000  ! 7623: ADDC_R	addc 	%r17, %r0, %r28
	.word 0xf41d0000  ! 7624: LDD_R	ldd	[%r20 + %r0], %r26
hwintr_2_349:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_349), 16, 16)) -> intp(2, 0, 26)
	.word 0xfc44617b  ! 7629: LDSW_I	ldsw	[%r17 + 0x017b], %r30
	.word 0xf855e0c5  ! 7631: LDSH_I	ldsh	[%r23 + 0x00c5], %r28
	.word 0xf604a161  ! 7637: LDUW_I	lduw	[%r18 + 0x0161], %r27
	mov	1, %r14
	.word 0xa193a000  ! 7638: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbe05a0b3  ! 7643: ADD_I	add 	%r22, 0x00b3, %r31
	.word 0xfe544000  ! 7648: LDSH_R	ldsh	[%r17 + %r0], %r31
	.word 0xfa056057  ! 7649: LDUW_I	lduw	[%r21 + 0x0057], %r29
	.word 0xfe4c8000  ! 7651: LDSB_R	ldsb	[%r18 + %r0], %r31
	.word 0xfe1c61cb  ! 7652: LDD_I	ldd	[%r17 + 0x01cb], %r31
	.word 0xb150c000  ! 7653: RDPR_TT	<illegal instruction>
	.word 0xb8352138  ! 7655: SUBC_I	orn 	%r20, 0x0138, %r28
	.word 0xfc450000  ! 7662: LDSW_R	ldsw	[%r20 + %r0], %r30
	.word 0xf245c000  ! 7663: LDSW_R	ldsw	[%r23 + %r0], %r25
	.word 0x8794a088  ! 7668: WRPR_TT_I	wrpr	%r18, 0x0088, %tt
	.word 0xb3643801  ! 7675: MOVcc_I	<illegal instruction>
	.word 0xf2546104  ! 7677: LDSH_I	ldsh	[%r17 + 0x0104], %r25
	.word 0xfe1d211c  ! 7679: LDD_I	ldd	[%r20 + 0x011c], %r31
	.word 0xb1520000  ! 7681: RDPR_PIL	rdpr	%pil, %r24
	.word 0xbac4c000  ! 7685: ADDCcc_R	addccc 	%r19, %r0, %r29
	.word 0xf815c000  ! 7687: LDUH_R	lduh	[%r23 + %r0], %r28
hwintr_2_350:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_350), 16, 16)) -> intp(2, 0, 25)
	.word 0x839561f3  ! 7691: WRPR_TNPC_I	wrpr	%r21, 0x01f3, %tnpc
	.word 0xf444200b  ! 7692: LDSW_I	ldsw	[%r16 + 0x000b], %r26
	.word 0xf4440000  ! 7695: LDSW_R	ldsw	[%r16 + %r0], %r26
	.word 0xf81c21b5  ! 7697: LDD_I	ldd	[%r16 + 0x01b5], %r28
hwintr_2_351:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_351), 16, 16)) -> intp(2, 0, 24)
	.word 0xf91d4000  ! 7702: LDDF_R	ldd	[%r21, %r0], %f28
	.word 0xf4058000  ! 7703: LDUW_R	lduw	[%r22 + %r0], %r26
	.word 0xb1518000  ! 7705: RDPR_PSTATE	<illegal instruction>
	.word 0xbb510000  ! 7707: RDPR_TICK	<illegal instruction>
	.word 0x8d9561a5  ! 7709: WRPR_PSTATE_I	wrpr	%r21, 0x01a5, %pstate
	.word 0xf4054000  ! 7711: LDUW_R	lduw	[%r21 + %r0], %r26
hwintr_2_352:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_352), 16, 16)) -> intp(2, 0, 34)
	.word 0xfc044000  ! 7717: LDUW_R	lduw	[%r17 + %r0], %r30
	.word 0xfc446171  ! 7718: LDSW_I	ldsw	[%r17 + 0x0171], %r30
	setx	data_start_6, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xbf51c000  ! 7723: RDPR_TL	<illegal instruction>
	.word 0xfc4de07b  ! 7728: LDSB_I	ldsb	[%r23 + 0x007b], %r30
	.word 0xf2040000  ! 7730: LDUW_R	lduw	[%r16 + %r0], %r25
	.word 0xf60da0dc  ! 7732: LDUB_I	ldub	[%r22 + 0x00dc], %r27
	.word 0xb3508000  ! 7733: RDPR_TSTATE	<illegal instruction>
	.word 0x8d956142  ! 7736: WRPR_PSTATE_I	wrpr	%r21, 0x0142, %pstate
	.word 0x859461b7  ! 7737: WRPR_TSTATE_I	wrpr	%r17, 0x01b7, %tstate
	mov	2, %r12
	.word 0x8f932000  ! 7738: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xfa450000  ! 7739: LDSW_R	ldsw	[%r20 + %r0], %r29
	.word 0xf20d6191  ! 7745: LDUB_I	ldub	[%r21 + 0x0191], %r25
	setx	data_start_3, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf51d8000  ! 7748: LDDF_R	ldd	[%r22, %r0], %f26
	.word 0xbd510000  ! 7752: RDPR_TICK	<illegal instruction>
	.word 0xb3508000  ! 7753: RDPR_TSTATE	<illegal instruction>
hwintr_2_353:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_353), 16, 16)) -> intp(2, 0, 29)
	.word 0xb0244000  ! 7756: SUB_R	sub 	%r17, %r0, %r24
	.word 0xfa148000  ! 7757: LDUH_R	lduh	[%r18 + %r0], %r29
	.word 0xf44c2038  ! 7761: LDSB_I	ldsb	[%r16 + 0x0038], %r26
	setx	data_start_1, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf04d0000  ! 7765: LDSB_R	ldsb	[%r20 + %r0], %r24
	.word 0xfe5de0cd  ! 7768: LDX_I	ldx	[%r23 + 0x00cd], %r31
	.word 0xbf480000  ! 7770: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xf8144000  ! 7773: LDUH_R	lduh	[%r17 + %r0], %r28
	.word 0xfe558000  ! 7776: LDSH_R	ldsh	[%r22 + %r0], %r31
	.word 0xb951c000  ! 7779: RDPR_TL	<illegal instruction>
	.word 0xb535b001  ! 7783: SRLX_I	srlx	%r22, 0x0001, %r26
	.word 0xf21de1c2  ! 7784: LDD_I	ldd	[%r23 + 0x01c2], %r25
	.word 0xf25d0000  ! 7786: LDX_R	ldx	[%r20 + %r0], %r25
	.word 0xfe54c000  ! 7788: LDSH_R	ldsh	[%r19 + %r0], %r31
hwintr_2_354:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_354), 16, 16)) -> intp(2, 0, 3c)
hwintr_2_355:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_355), 16, 16)) -> intp(2, 0, 1c)
	.word 0xfc5c0000  ! 7796: LDX_R	ldx	[%r16 + %r0], %r30
	.word 0xf015a0ad  ! 7798: LDUH_I	lduh	[%r22 + 0x00ad], %r24
	.word 0xbe9c20f6  ! 7800: XORcc_I	xorcc 	%r16, 0x00f6, %r31
	.word 0xfc44c000  ! 7803: LDSW_R	ldsw	[%r19 + %r0], %r30
	.word 0xb5520000  ! 7805: RDPR_PIL	<illegal instruction>
	setx	data_start_1, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb135d000  ! 7809: SRLX_R	srlx	%r23, %r0, %r24
hwintr_2_356:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_356), 16, 16)) -> intp(2, 0, 29)
	.word 0xbf504000  ! 7812: RDPR_TNPC	<illegal instruction>
	.word 0xbe9520a0  ! 7813: ORcc_I	orcc 	%r20, 0x00a0, %r31
	.word 0xb5508000  ! 7815: RDPR_TSTATE	<illegal instruction>
	.word 0xf804c000  ! 7817: LDUW_R	lduw	[%r19 + %r0], %r28
	.word 0xfa55e02c  ! 7820: LDSH_I	ldsh	[%r23 + 0x002c], %r29
	.word 0xf805e174  ! 7821: LDUW_I	lduw	[%r23 + 0x0174], %r28
	.word 0xf40dc000  ! 7823: LDUB_R	ldub	[%r23 + %r0], %r26
	.word 0xb5520000  ! 7824: RDPR_PIL	<illegal instruction>
	.word 0xf00d217b  ! 7826: LDUB_I	ldub	[%r20 + 0x017b], %r24
	.word 0x8d952177  ! 7834: WRPR_PSTATE_I	wrpr	%r20, 0x0177, %pstate
hwintr_2_357:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_357), 16, 16)) -> intp(2, 0, 26)
	.word 0x89956185  ! 7840: WRPR_TICK_I	wrpr	%r21, 0x0185, %tick
	ta	T_CHANGE_HPRIV
	.word 0x81983a8b  ! 7844: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a8b, %hpstate
	.word 0xba35a0e4  ! 7849: ORN_I	orn 	%r22, 0x00e4, %r29
	.word 0xfa050000  ! 7850: LDUW_R	lduw	[%r20 + %r0], %r29
	.word 0xf44cc000  ! 7853: LDSB_R	ldsb	[%r19 + %r0], %r26
	.word 0xf2046012  ! 7855: LDUW_I	lduw	[%r17 + 0x0012], %r25
hwintr_2_358:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_358), 16, 16)) -> intp(2, 0, 23)
	.word 0xb425a0fc  ! 7862: SUB_I	sub 	%r22, 0x00fc, %r26
	.word 0xfe454000  ! 7864: LDSW_R	ldsw	[%r21 + %r0], %r31
	.word 0xb5504000  ! 7870: RDPR_TNPC	<illegal instruction>
	.word 0xfa5cc000  ! 7872: LDX_R	ldx	[%r19 + %r0], %r29
	.word 0xb8150000  ! 7877: OR_R	or 	%r20, %r0, %r28
	.word 0xf2554000  ! 7880: LDSH_R	ldsh	[%r21 + %r0], %r25
	.word 0xb73cf001  ! 7882: SRAX_I	srax	%r19, 0x0001, %r27
	.word 0xf21560b3  ! 7889: LDUH_I	lduh	[%r21 + 0x00b3], %r25
	.word 0xfb1d2024  ! 7892: LDDF_I	ldd	[%r20, 0x0024], %f29
	.word 0xf61d2118  ! 7893: LDD_I	ldd	[%r20 + 0x0118], %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982c59  ! 7897: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c59, %hpstate
hwintr_2_359:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_359), 16, 16)) -> intp(2, 0, 37)
	.word 0xb1504000  ! 7900: RDPR_TNPC	<illegal instruction>
	.word 0xfd1d61ea  ! 7901: LDDF_I	ldd	[%r21, 0x01ea], %f30
hwintr_2_360:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_360), 16, 16)) -> intp(2, 0, 30)
	.word 0xfa55c000  ! 7906: LDSH_R	ldsh	[%r23 + %r0], %r29
	.word 0xf64d0000  ! 7907: LDSB_R	ldsb	[%r20 + %r0], %r27
	.word 0xfe042011  ! 7908: LDUW_I	lduw	[%r16 + 0x0011], %r31
	.word 0xbea5c000  ! 7909: SUBcc_R	subcc 	%r23, %r0, %r31
	.word 0xf00c4000  ! 7910: LDUB_R	ldub	[%r17 + %r0], %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982f0b  ! 7911: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f0b, %hpstate
	.word 0xb5518000  ! 7915: RDPR_PSTATE	<illegal instruction>
	.word 0xb1508000  ! 7919: RDPR_TSTATE	<illegal instruction>
	.word 0xfb1d601c  ! 7922: LDDF_I	ldd	[%r21, 0x001c], %f29
hwintr_2_361:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_361), 16, 16)) -> intp(2, 0, 34)
hwintr_2_362:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_362), 16, 16)) -> intp(2, 0, 2e)
	.word 0xb9508000  ! 7926: RDPR_TSTATE	<illegal instruction>
	.word 0xb9540000  ! 7927: RDPR_GL	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x8198298b  ! 7928: WRHPR_HPSTATE_I	wrhpr	%r0, 0x098b, %hpstate
	.word 0x8195a0be  ! 7929: WRPR_TPC_I	wrpr	%r22, 0x00be, %tpc
	.word 0xf91c4000  ! 7931: LDDF_R	ldd	[%r17, %r0], %f28
	.word 0xfe44e0f0  ! 7932: LDSW_I	ldsw	[%r19 + 0x00f0], %r31
	.word 0x819560f1  ! 7934: WRPR_TPC_I	wrpr	%r21, 0x00f1, %tpc
	.word 0xf40de1be  ! 7940: LDUB_I	ldub	[%r23 + 0x01be], %r26
	.word 0xf455616e  ! 7941: LDSH_I	ldsh	[%r21 + 0x016e], %r26
	.word 0xf0552044  ! 7944: LDSH_I	ldsh	[%r20 + 0x0044], %r24
hwintr_2_363:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_363), 16, 16)) -> intp(2, 0, 1e)
	.word 0xf854a197  ! 7954: LDSH_I	ldsh	[%r18 + 0x0197], %r28
	setx	data_start_6, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf31c6128  ! 7956: LDDF_I	ldd	[%r17, 0x0128], %f25
hwintr_2_364:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_364), 16, 16)) -> intp(2, 0, 33)
	.word 0xba358000  ! 7959: ORN_R	orn 	%r22, %r0, %r29
	.word 0xfa1461a3  ! 7973: LDUH_I	lduh	[%r17 + 0x01a3], %r29
	.word 0xfd1da18a  ! 7974: LDDF_I	ldd	[%r22, 0x018a], %f30
	.word 0xf11d0000  ! 7977: LDDF_R	ldd	[%r20, %r0], %f24
	mov	0, %r14
	.word 0xa193a000  ! 7978: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf60c21b9  ! 7979: LDUB_I	ldub	[%r16 + 0x01b9], %r27
	.word 0xf44dc000  ! 7981: LDSB_R	ldsb	[%r23 + %r0], %r26
	.word 0xb7504000  ! 7983: RDPR_TNPC	<illegal instruction>
	.word 0xf844c000  ! 7985: LDSW_R	ldsw	[%r19 + %r0], %r28
	.word 0xfa05a19d  ! 7987: LDUW_I	lduw	[%r22 + 0x019d], %r29
hwintr_2_365:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_365), 16, 16)) -> intp(2, 0, 19)
	.word 0xfa440000  ! 7989: LDSW_R	ldsw	[%r16 + %r0], %r29
	.word 0x87952091  ! 7990: WRPR_TT_I	wrpr	%r20, 0x0091, %tt
	.word 0xf24ce030  ! 7992: LDSB_I	ldsb	[%r19 + 0x0030], %r25
	.word 0xb6bde17a  ! 7999: XNORcc_I	xnorcc 	%r23, 0x017a, %r27
hwintr_2_366:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_366), 16, 16)) -> intp(2, 0, 2c)
	.word 0xf214e13a  ! 8002: LDUH_I	lduh	[%r19 + 0x013a], %r25
	.word 0xff1da163  ! 8003: LDDF_I	ldd	[%r22, 0x0163], %f31
	.word 0xfe45a1d0  ! 8004: LDSW_I	ldsw	[%r22 + 0x01d0], %r31
	.word 0xb5504000  ! 8008: RDPR_TNPC	<illegal instruction>
	.word 0xf60ce0a9  ! 8009: LDUB_I	ldub	[%r19 + 0x00a9], %r27
hwintr_2_367:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_367), 16, 16)) -> intp(2, 0, 2)
hwintr_2_368:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_368), 16, 16)) -> intp(2, 0, 32)
	.word 0xfc4d603e  ! 8014: LDSB_I	ldsb	[%r21 + 0x003e], %r30
	.word 0xf6158000  ! 8018: LDUH_R	lduh	[%r22 + %r0], %r27
	.word 0x8395e0e3  ! 8021: WRPR_TNPC_I	wrpr	%r23, 0x00e3, %tnpc
	ta	T_CHANGE_HPRIV
	.word 0x81982dc3  ! 8022: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dc3, %hpstate
	.word 0xf2044000  ! 8023: LDUW_R	lduw	[%r17 + %r0], %r25
hwintr_2_369:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_369), 16, 16)) -> intp(2, 0, f)
	.word 0xfb1d21b5  ! 8027: LDDF_I	ldd	[%r20, 0x01b5], %f29
	.word 0xfe1c610f  ! 8029: LDD_I	ldd	[%r17 + 0x010f], %r31
	.word 0xf84d4000  ! 8033: LDSB_R	ldsb	[%r21 + %r0], %r28
	.word 0xb93c8000  ! 8035: SRA_R	sra 	%r18, %r0, %r28
hwintr_2_370:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_370), 16, 16)) -> intp(2, 0, 33)
	.word 0xbb50c000  ! 8038: RDPR_TT	<illegal instruction>
	.word 0x89942033  ! 8039: WRPR_TICK_I	wrpr	%r16, 0x0033, %tick
hwintr_2_371:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_371), 16, 16)) -> intp(2, 0, 22)
hwintr_2_372:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_372), 16, 16)) -> intp(2, 0, 19)
	.word 0xfe54a051  ! 8044: LDSH_I	ldsh	[%r18 + 0x0051], %r31
hwintr_2_373:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_373), 16, 16)) -> intp(2, 0, 14)
	.word 0xfc548000  ! 8048: LDSH_R	ldsh	[%r18 + %r0], %r30
hwintr_2_374:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_374), 16, 16)) -> intp(2, 0, f)
	.word 0xbb500000  ! 8052: RDPR_TPC	<illegal instruction>
	.word 0xb3500000  ! 8054: RDPR_TPC	<illegal instruction>
	.word 0xbe85e1d0  ! 8055: ADDcc_I	addcc 	%r23, 0x01d0, %r31
	.word 0xf64d4000  ! 8058: LDSB_R	ldsb	[%r21 + %r0], %r27
	.word 0xf2052008  ! 8059: LDUW_I	lduw	[%r20 + 0x0008], %r25
	.word 0xf20d6126  ! 8067: LDUB_I	ldub	[%r21 + 0x0126], %r25
	.word 0xfc0ce0da  ! 8070: LDUB_I	ldub	[%r19 + 0x00da], %r30
	.word 0xfc55e14a  ! 8071: LDSH_I	ldsh	[%r23 + 0x014a], %r30
	.word 0xb351c000  ! 8072: RDPR_TL	<illegal instruction>
	.word 0xf40dc000  ! 8073: LDUB_R	ldub	[%r23 + %r0], %r26
hwintr_2_375:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_375), 16, 16)) -> intp(2, 0, a)
	.word 0xfa5d20c6  ! 8084: LDX_I	ldx	[%r20 + 0x00c6], %r29
	.word 0xf80420a0  ! 8086: LDUW_I	lduw	[%r16 + 0x00a0], %r28
	.word 0xf40c4000  ! 8088: LDUB_R	ldub	[%r17 + %r0], %r26
	.word 0xb4348000  ! 8090: ORN_R	orn 	%r18, %r0, %r26
hwintr_2_376:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_376), 16, 16)) -> intp(2, 0, 5)
	.word 0xfa05e1ff  ! 8094: LDUW_I	lduw	[%r23 + 0x01ff], %r29
	.word 0xfa450000  ! 8100: LDSW_R	ldsw	[%r20 + %r0], %r29
	.word 0xb2c42130  ! 8101: ADDCcc_I	addccc 	%r16, 0x0130, %r25
	.word 0xf51c4000  ! 8102: LDDF_R	ldd	[%r17, %r0], %f26
	.word 0xfe550000  ! 8107: LDSH_R	ldsh	[%r20 + %r0], %r31
	.word 0xbb520000  ! 8108: RDPR_PIL	<illegal instruction>
	.word 0xf05d4000  ! 8111: LDX_R	ldx	[%r21 + %r0], %r24
hwintr_2_377:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_377), 16, 16)) -> intp(2, 0, c)
	.word 0xfe05a09c  ! 8114: LDUW_I	lduw	[%r22 + 0x009c], %r31
	.word 0xbb540000  ! 8116: RDPR_GL	<illegal instruction>
	.word 0x8594206f  ! 8117: WRPR_TSTATE_I	wrpr	%r16, 0x006f, %tstate
	.word 0xb8aca055  ! 8119: ANDNcc_I	andncc 	%r18, 0x0055, %r28
hwintr_2_378:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_378), 16, 16)) -> intp(2, 0, 27)
hwintr_2_379:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_379), 16, 16)) -> intp(2, 0, 2)
	.word 0xf044a02b  ! 8125: LDSW_I	ldsw	[%r18 + 0x002b], %r24
	.word 0xbd508000  ! 8126: RDPR_TSTATE	<illegal instruction>
	.word 0xfd1d2030  ! 8127: LDDF_I	ldd	[%r20, 0x0030], %f30
	.word 0xf60d8000  ! 8129: LDUB_R	ldub	[%r22 + %r0], %r27
	.word 0xb0b54000  ! 8131: ORNcc_R	orncc 	%r21, %r0, %r24
	.word 0xf815c000  ! 8133: LDUH_R	lduh	[%r23 + %r0], %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982c9b  ! 8135: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c9b, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81982a93  ! 8137: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a93, %hpstate
	.word 0xfc0c61c6  ! 8143: LDUB_I	ldub	[%r17 + 0x01c6], %r30
	.word 0xb1500000  ! 8146: RDPR_TPC	<illegal instruction>
	.word 0xb2144000  ! 8148: OR_R	or 	%r17, %r0, %r25
	.word 0xf31dc000  ! 8151: LDDF_R	ldd	[%r23, %r0], %f25
hwintr_2_380:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_380), 16, 16)) -> intp(2, 0, 16)
hwintr_2_381:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_381), 16, 16)) -> intp(2, 0, a)
hwintr_2_382:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_382), 16, 16)) -> intp(2, 0, 16)
	.word 0xb3508000  ! 8169: RDPR_TSTATE	<illegal instruction>
	.word 0xf84c4000  ! 8173: LDSB_R	ldsb	[%r17 + %r0], %r28
	.word 0xfb1d4000  ! 8174: LDDF_R	ldd	[%r21, %r0], %f29
	.word 0xf91c4000  ! 8182: LDDF_R	ldd	[%r17, %r0], %f28
	.word 0x8395618a  ! 8185: WRPR_TNPC_I	wrpr	%r21, 0x018a, %tnpc
	.word 0xb7518000  ! 8188: RDPR_PSTATE	<illegal instruction>
	.word 0xb295a0a1  ! 8189: ORcc_I	orcc 	%r22, 0x00a1, %r25
	.word 0xf01de04d  ! 8199: LDD_I	ldd	[%r23 + 0x004d], %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982b13  ! 8201: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b13, %hpstate
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xfd1d8000  ! 8206: LDDF_R	ldd	[%r22, %r0], %f30
	.word 0xf81d8000  ! 8208: LDD_R	ldd	[%r22 + %r0], %r28
	.word 0xf6558000  ! 8210: LDSH_R	ldsh	[%r22 + %r0], %r27
hwintr_2_383:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_383), 16, 16)) -> intp(2, 0, 31)
	.word 0xf8150000  ! 8214: LDUH_R	lduh	[%r20 + %r0], %r28
	.word 0xf2542155  ! 8215: LDSH_I	ldsh	[%r16 + 0x0155], %r25
	.word 0x8995605c  ! 8217: WRPR_TICK_I	wrpr	%r21, 0x005c, %tick
	.word 0xf91da10b  ! 8218: LDDF_I	ldd	[%r22, 0x010b], %f28
	.word 0xf51d21d3  ! 8221: LDDF_I	ldd	[%r20, 0x01d3], %f26
	.word 0xb624a121  ! 8222: SUB_I	sub 	%r18, 0x0121, %r27
	.word 0x87956151  ! 8223: WRPR_TT_I	wrpr	%r21, 0x0151, %tt
hwintr_2_384:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_384), 16, 16)) -> intp(2, 0, 1e)
	.word 0xf8446005  ! 8231: LDSW_I	ldsw	[%r17 + 0x0005], %r28
	.word 0xbf518000  ! 8233: RDPR_PSTATE	<illegal instruction>
	.word 0xbb50c000  ! 8235: RDPR_TT	<illegal instruction>
	.word 0xfc448000  ! 8236: LDSW_R	ldsw	[%r18 + %r0], %r30
	.word 0xf51dc000  ! 8237: LDDF_R	ldd	[%r23, %r0], %f26
hwintr_2_385:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_385), 16, 16)) -> intp(2, 0, 3b)
	.word 0x8195e0d7  ! 8240: WRPR_TPC_I	wrpr	%r23, 0x00d7, %tpc
	.word 0xbabd0000  ! 8241: XNORcc_R	xnorcc 	%r20, %r0, %r29
	.word 0xf01d0000  ! 8243: LDD_R	ldd	[%r20 + %r0], %r24
	.word 0xb1540000  ! 8246: RDPR_GL	<illegal instruction>
	.word 0xf65cc000  ! 8247: LDX_R	ldx	[%r19 + %r0], %r27
	.word 0xb3504000  ! 8250: RDPR_TNPC	<illegal instruction>
	.word 0xfa4421e7  ! 8251: LDSW_I	ldsw	[%r16 + 0x01e7], %r29
	.word 0xff1da0cf  ! 8252: LDDF_I	ldd	[%r22, 0x00cf], %f31
	.word 0xb1540000  ! 8257: RDPR_GL	<illegal instruction>
	.word 0xfc0421f4  ! 8259: LDUW_I	lduw	[%r16 + 0x01f4], %r30
	ta	T_CHANGE_HPRIV
	.word 0x81982a9b  ! 8263: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a9b, %hpstate
	.word 0x8d95605a  ! 8265: WRPR_PSTATE_I	wrpr	%r21, 0x005a, %pstate
	.word 0xf855c000  ! 8268: LDSH_R	ldsh	[%r23 + %r0], %r28
	.word 0xfa042044  ! 8269: LDUW_I	lduw	[%r16 + 0x0044], %r29
	.word 0x8d95e017  ! 8274: WRPR_PSTATE_I	wrpr	%r23, 0x0017, %pstate
	.word 0xf44d2140  ! 8276: LDSB_I	ldsb	[%r20 + 0x0140], %r26
	.word 0xfc0c4000  ! 8278: LDUB_R	ldub	[%r17 + %r0], %r30
	.word 0xf804607d  ! 8280: LDUW_I	lduw	[%r17 + 0x007d], %r28
	.word 0xbd510000  ! 8281: RDPR_TICK	<illegal instruction>
	.word 0xf04d8000  ! 8284: LDSB_R	ldsb	[%r22 + %r0], %r24
	.word 0x85942038  ! 8287: WRPR_TSTATE_I	wrpr	%r16, 0x0038, %tstate
	.word 0xf85de159  ! 8290: LDX_I	ldx	[%r23 + 0x0159], %r28
hwintr_2_386:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_386), 16, 16)) -> intp(2, 0, 15)
	.word 0xb3504000  ! 8292: RDPR_TNPC	<illegal instruction>
	.word 0xf044c000  ! 8296: LDSW_R	ldsw	[%r19 + %r0], %r24
	.word 0xfd1d2146  ! 8300: LDDF_I	ldd	[%r20, 0x0146], %f30
	.word 0xf21c8000  ! 8302: LDD_R	ldd	[%r18 + %r0], %r25
	setx	data_start_3, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_2_387:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_387), 16, 16)) -> intp(2, 0, 1c)
	.word 0xff1d4000  ! 8305: LDDF_R	ldd	[%r21, %r0], %f31
	.word 0xf6448000  ! 8306: LDSW_R	ldsw	[%r18 + %r0], %r27
	.word 0xfe0ca170  ! 8310: LDUB_I	ldub	[%r18 + 0x0170], %r31
	.word 0xb6340000  ! 8312: ORN_R	orn 	%r16, %r0, %r27
hwintr_2_388:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_388), 16, 16)) -> intp(2, 0, 1e)
	.word 0xfe05e08a  ! 8314: LDUW_I	lduw	[%r23 + 0x008a], %r31
	.word 0xb13d9000  ! 8316: SRAX_R	srax	%r22, %r0, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81982ac1  ! 8319: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0ac1, %hpstate
	.word 0xf4546095  ! 8321: LDSH_I	ldsh	[%r17 + 0x0095], %r26
	.word 0xfe05c000  ! 8322: LDUW_R	lduw	[%r23 + %r0], %r31
	.word 0xf255614c  ! 8326: LDSH_I	ldsh	[%r21 + 0x014c], %r25
	.word 0xb1480000  ! 8328: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81983d4b  ! 8329: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d4b, %hpstate
	.word 0xf45c60b6  ! 8331: LDX_I	ldx	[%r17 + 0x00b6], %r26
	.word 0xf255a105  ! 8332: LDSH_I	ldsh	[%r22 + 0x0105], %r25
	.word 0xf614a1f7  ! 8339: LDUH_I	lduh	[%r18 + 0x01f7], %r27
hwintr_2_389:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_389), 16, 16)) -> intp(2, 0, 1d)
	.word 0xb20520ad  ! 8346: ADD_I	add 	%r20, 0x00ad, %r25
	.word 0x899460ec  ! 8348: WRPR_TICK_I	wrpr	%r17, 0x00ec, %tick
	.word 0xfe058000  ! 8351: LDUW_R	lduw	[%r22 + %r0], %r31
	.word 0xf814c000  ! 8352: LDUH_R	lduh	[%r19 + %r0], %r28
	.word 0xbd2df001  ! 8354: SLLX_I	sllx	%r23, 0x0001, %r30
	.word 0xfa5d4000  ! 8355: LDX_R	ldx	[%r21 + %r0], %r29
	.word 0x8195a0be  ! 8356: WRPR_TPC_I	wrpr	%r22, 0x00be, %tpc
	.word 0xf85c4000  ! 8357: LDX_R	ldx	[%r17 + %r0], %r28
	.word 0xb6b521fe  ! 8358: SUBCcc_I	orncc 	%r20, 0x01fe, %r27
	.word 0xfa442113  ! 8360: LDSW_I	ldsw	[%r16 + 0x0113], %r29
hwintr_2_390:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_390), 16, 16)) -> intp(2, 0, 6)
	.word 0x9194e138  ! 8362: WRPR_PIL_I	wrpr	%r19, 0x0138, %pil
	.word 0xf21d21f2  ! 8363: LDD_I	ldd	[%r20 + 0x01f2], %r25
hwintr_2_391:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_391), 16, 16)) -> intp(2, 0, 38)
	.word 0xf51d0000  ! 8365: LDDF_R	ldd	[%r20, %r0], %f26
	.word 0xfc15e01a  ! 8366: LDUH_I	lduh	[%r23 + 0x001a], %r30
	setx	data_start_0, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_2_392:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_392), 16, 16)) -> intp(2, 0, 1)
	.word 0xb9510000  ! 8371: RDPR_TICK	rdpr	%tick, %r28
	.word 0xf4046039  ! 8373: LDUW_I	lduw	[%r17 + 0x0039], %r26
	.word 0xf64ce0c6  ! 8374: LDSB_I	ldsb	[%r19 + 0x00c6], %r27
	.word 0xfb1d0000  ! 8376: LDDF_R	ldd	[%r20, %r0], %f29
	.word 0xf71ca041  ! 8377: LDDF_I	ldd	[%r18, 0x0041], %f27
	.word 0xbd50c000  ! 8380: RDPR_TT	<illegal instruction>
	.word 0xf4040000  ! 8382: LDUW_R	lduw	[%r16 + %r0], %r26
	.word 0xb9510000  ! 8384: RDPR_TICK	<illegal instruction>
hwintr_2_393:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_393), 16, 16)) -> intp(2, 0, 1b)
	ta	T_CHANGE_HPRIV
	.word 0x81982cc9  ! 8392: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0cc9, %hpstate
	.word 0xbd2df001  ! 8393: SLLX_I	sllx	%r23, 0x0001, %r30
	mov	0, %r12
	.word 0x8f932000  ! 8395: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf81c2189  ! 8397: LDD_I	ldd	[%r16 + 0x0189], %r28
	.word 0xf44ce0fd  ! 8398: LDSB_I	ldsb	[%r19 + 0x00fd], %r26
	.word 0xf11d4000  ! 8400: LDDF_R	ldd	[%r21, %r0], %f24
	.word 0xb834a0e7  ! 8401: SUBC_I	orn 	%r18, 0x00e7, %r28
	.word 0xbb480000  ! 8402: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xf414c000  ! 8406: LDUH_R	lduh	[%r19 + %r0], %r26
	.word 0xf21c0000  ! 8407: LDD_R	ldd	[%r16 + %r0], %r25
hwintr_2_394:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_394), 16, 16)) -> intp(2, 0, 16)
	.word 0xf8544000  ! 8412: LDSH_R	ldsh	[%r17 + %r0], %r28
	.word 0xfa4d4000  ! 8413: LDSB_R	ldsb	[%r21 + %r0], %r29
	.word 0xfa550000  ! 8415: LDSH_R	ldsh	[%r20 + %r0], %r29
	.word 0xfe44a0d6  ! 8417: LDSW_I	ldsw	[%r18 + 0x00d6], %r31
hwintr_2_395:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_395), 16, 16)) -> intp(2, 0, 3c)
	.word 0xb52db001  ! 8422: SLLX_I	sllx	%r22, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81983f99  ! 8427: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f99, %hpstate
	.word 0xfc4de1f1  ! 8428: LDSB_I	ldsb	[%r23 + 0x01f1], %r30
	.word 0xf24d60b9  ! 8429: LDSB_I	ldsb	[%r21 + 0x00b9], %r25
	.word 0xb7504000  ! 8430: RDPR_TNPC	<illegal instruction>
	.word 0xb3508000  ! 8431: RDPR_TSTATE	<illegal instruction>
hwintr_2_396:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_396), 16, 16)) -> intp(2, 0, 1c)
hwintr_2_397:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_397), 16, 16)) -> intp(2, 0, 7)
	.word 0x8194e0b7  ! 8443: WRPR_TPC_I	wrpr	%r19, 0x00b7, %tpc
	mov	0, %r14
	.word 0xa193a000  ! 8444: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb3540000  ! 8445: RDPR_GL	<illegal instruction>
	.word 0xf61c0000  ! 8448: LDD_R	ldd	[%r16 + %r0], %r27
	.word 0x8194a18e  ! 8449: WRPR_TPC_I	wrpr	%r18, 0x018e, %tpc
	.word 0xfe448000  ! 8452: LDSW_R	ldsw	[%r18 + %r0], %r31
	.word 0xb9520000  ! 8454: RDPR_PIL	<illegal instruction>
	.word 0xbd540000  ! 8455: RDPR_GL	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81983c19  ! 8457: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c19, %hpstate
	.word 0xf41d20e5  ! 8460: LDD_I	ldd	[%r20 + 0x00e5], %r26
	.word 0x8994a156  ! 8462: WRPR_TICK_I	wrpr	%r18, 0x0156, %tick
	.word 0xfc5dc000  ! 8463: LDX_R	ldx	[%r23 + %r0], %r30
	.word 0xfc452018  ! 8469: LDSW_I	ldsw	[%r20 + 0x0018], %r30
	.word 0xbd3d3001  ! 8474: SRAX_I	srax	%r20, 0x0001, %r30
	.word 0xfe458000  ! 8476: LDSW_R	ldsw	[%r22 + %r0], %r31
	ta	T_CHANGE_HPRIV
	.word 0x81983843  ! 8477: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1843, %hpstate
	.word 0xb7520000  ! 8483: RDPR_PIL	<illegal instruction>
	.word 0xf91da103  ! 8484: LDDF_I	ldd	[%r22, 0x0103], %f28
	.word 0xfe54c000  ! 8486: LDSH_R	ldsh	[%r19 + %r0], %r31
	.word 0xfe1d603f  ! 8496: LDD_I	ldd	[%r21 + 0x003f], %r31
	.word 0xbc940000  ! 8498: ORcc_R	orcc 	%r16, %r0, %r30
	.word 0x85946070  ! 8504: WRPR_TSTATE_I	wrpr	%r17, 0x0070, %tstate
	.word 0xf01c0000  ! 8506: LDD_R	ldd	[%r16 + %r0], %r24
	.word 0xbb518000  ! 8514: RDPR_PSTATE	rdpr	%pstate, %r29
hwintr_2_398:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_398), 16, 16)) -> intp(2, 0, 36)
	.word 0xfc4c0000  ! 8519: LDSB_R	ldsb	[%r16 + %r0], %r30
	.word 0xbd355000  ! 8520: SRLX_R	srlx	%r21, %r0, %r30
hwintr_2_399:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_399), 16, 16)) -> intp(2, 0, 1b)
	setx	data_start_7, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb951c000  ! 8526: RDPR_TL	<illegal instruction>
hwintr_2_400:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_400), 16, 16)) -> intp(2, 0, 4)
	.word 0xf21c4000  ! 8535: LDD_R	ldd	[%r17 + %r0], %r25
hwintr_2_401:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_401), 16, 16)) -> intp(2, 0, 3d)
hwintr_2_402:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_402), 16, 16)) -> intp(2, 0, 14)
	.word 0xba25c000  ! 8539: SUB_R	sub 	%r23, %r0, %r29
	.word 0x819461df  ! 8540: WRPR_TPC_I	wrpr	%r17, 0x01df, %tpc
	.word 0xf00d2069  ! 8542: LDUB_I	ldub	[%r20 + 0x0069], %r24
	setx	data_start_2, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf455a0cd  ! 8544: LDSH_I	ldsh	[%r22 + 0x00cd], %r26
hwintr_2_403:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_403), 16, 16)) -> intp(2, 0, 38)
	.word 0xfa44612a  ! 8546: LDSW_I	ldsw	[%r17 + 0x012a], %r29
	.word 0xf04d4000  ! 8547: LDSB_R	ldsb	[%r21 + %r0], %r24
hwintr_2_404:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_404), 16, 16)) -> intp(2, 0, 12)
	.word 0xb9643801  ! 8549: MOVcc_I	<illegal instruction>
	.word 0xf005c000  ! 8553: LDUW_R	lduw	[%r23 + %r0], %r24
	.word 0xfa1d0000  ! 8557: LDD_R	ldd	[%r20 + %r0], %r29
hwintr_2_405:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_405), 16, 16)) -> intp(2, 0, 34)
	.word 0xfa1da0a7  ! 8559: LDD_I	ldd	[%r22 + 0x00a7], %r29
	.word 0xbb643801  ! 8562: MOVcc_I	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982a03  ! 8566: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a03, %hpstate
	.word 0xf91c8000  ! 8567: LDDF_R	ldd	[%r18, %r0], %f28
	.word 0xf055203f  ! 8570: LDSH_I	ldsh	[%r20 + 0x003f], %r24
	.word 0xb2b4e084  ! 8572: ORNcc_I	orncc 	%r19, 0x0084, %r25
	.word 0xfe1c4000  ! 8574: LDD_R	ldd	[%r17 + %r0], %r31
	.word 0x9194a0f1  ! 8575: WRPR_PIL_I	wrpr	%r18, 0x00f1, %pil
	.word 0xfb1cc000  ! 8580: LDDF_R	ldd	[%r19, %r0], %f29
	.word 0xf80da0dc  ! 8583: LDUB_I	ldub	[%r22 + 0x00dc], %r28
	.word 0xbf520000  ! 8585: RDPR_PIL	rdpr	%pil, %r31
	.word 0xf8050000  ! 8586: LDUW_R	lduw	[%r20 + %r0], %r28
	.word 0xf85461b2  ! 8591: LDSH_I	ldsh	[%r17 + 0x01b2], %r28
	.word 0xbd51c000  ! 8593: RDPR_TL	<illegal instruction>
	.word 0xb7518000  ! 8596: RDPR_PSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xf444c000  ! 8601: LDSW_R	ldsw	[%r19 + %r0], %r26
	.word 0xf40c8000  ! 8603: LDUB_R	ldub	[%r18 + %r0], %r26
	.word 0xbb540000  ! 8607: RDPR_GL	<illegal instruction>
	.word 0xf51ce195  ! 8608: LDDF_I	ldd	[%r19, 0x0195], %f26
	.word 0x85956006  ! 8610: WRPR_TSTATE_I	wrpr	%r21, 0x0006, %tstate
	.word 0xf2050000  ! 8611: LDUW_R	lduw	[%r20 + %r0], %r25
hwintr_2_406:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_406), 16, 16)) -> intp(2, 0, 36)
	.word 0xb7518000  ! 8620: RDPR_PSTATE	<illegal instruction>
	.word 0xbd2db001  ! 8623: SLLX_I	sllx	%r22, 0x0001, %r30
	.word 0xf31c20e6  ! 8624: LDDF_I	ldd	[%r16, 0x00e6], %f25
	.word 0xf204e106  ! 8626: LDUW_I	lduw	[%r19 + 0x0106], %r25
	.word 0xf00cc000  ! 8628: LDUB_R	ldub	[%r19 + %r0], %r24
	.word 0xf405a08a  ! 8629: LDUW_I	lduw	[%r22 + 0x008a], %r26
	.word 0xf84c0000  ! 8631: LDSB_R	ldsb	[%r16 + %r0], %r28
	.word 0xbd518000  ! 8634: RDPR_PSTATE	<illegal instruction>
	mov	1, %r12
	.word 0x8f932000  ! 8635: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb0256066  ! 8636: SUB_I	sub 	%r21, 0x0066, %r24
	.word 0xb3520000  ! 8638: RDPR_PIL	<illegal instruction>
hwintr_2_407:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_407), 16, 16)) -> intp(2, 0, 39)
	.word 0xf71c615d  ! 8640: LDDF_I	ldd	[%r17, 0x015d], %f27
	.word 0x899520e9  ! 8641: WRPR_TICK_I	wrpr	%r20, 0x00e9, %tick
	.word 0xf51de160  ! 8642: LDDF_I	ldd	[%r23, 0x0160], %f26
	.word 0xf64da176  ! 8643: LDSB_I	ldsb	[%r22 + 0x0176], %r27
hwintr_2_408:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_408), 16, 16)) -> intp(2, 0, 2d)
	.word 0xf20d2093  ! 8651: LDUB_I	ldub	[%r20 + 0x0093], %r25
	.word 0xf65dc000  ! 8653: LDX_R	ldx	[%r23 + %r0], %r27
	.word 0xfe0d8000  ! 8655: LDUB_R	ldub	[%r22 + %r0], %r31
	.word 0xf60ce082  ! 8657: LDUB_I	ldub	[%r19 + 0x0082], %r27
	.word 0xf24d0000  ! 8658: LDSB_R	ldsb	[%r20 + %r0], %r25
hwintr_2_409:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_409), 16, 16)) -> intp(2, 0, 1a)
	.word 0xf60ce11a  ! 8661: LDUB_I	ldub	[%r19 + 0x011a], %r27
hwintr_2_410:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_410), 16, 16)) -> intp(2, 0, 2)
	.word 0xfa548000  ! 8673: LDSH_R	ldsh	[%r18 + %r0], %r29
	.word 0x9195a1b8  ! 8676: WRPR_PIL_I	wrpr	%r22, 0x01b8, %pil
	.word 0xfa5c4000  ! 8678: LDX_R	ldx	[%r17 + %r0], %r29
	.word 0xb2a4211b  ! 8681: SUBcc_I	subcc 	%r16, 0x011b, %r25
	.word 0xb0a460ed  ! 8685: SUBcc_I	subcc 	%r17, 0x00ed, %r24
	.word 0xbb500000  ! 8690: RDPR_TPC	<illegal instruction>
hwintr_2_411:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_411), 16, 16)) -> intp(2, 0, d)
	.word 0xfe0c8000  ! 8693: LDUB_R	ldub	[%r18 + %r0], %r31
	.word 0xf11c60f6  ! 8694: LDDF_I	ldd	[%r17, 0x00f6], %f24
	.word 0xf65c20b8  ! 8702: LDX_I	ldx	[%r16 + 0x00b8], %r27
	.word 0x899520e2  ! 8703: WRPR_TICK_I	wrpr	%r20, 0x00e2, %tick
	.word 0xbc9da059  ! 8704: XORcc_I	xorcc 	%r22, 0x0059, %r30
	.word 0xbe9dc000  ! 8705: XORcc_R	xorcc 	%r23, %r0, %r31
	.word 0xb32c7001  ! 8707: SLLX_I	sllx	%r17, 0x0001, %r25
	.word 0xf6454000  ! 8709: LDSW_R	ldsw	[%r21 + %r0], %r27
hwintr_2_412:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_412), 16, 16)) -> intp(2, 0, 39)
	.word 0xb12d6001  ! 8711: SLL_I	sll 	%r21, 0x0001, %r24
	.word 0xf60d608a  ! 8712: LDUB_I	ldub	[%r21 + 0x008a], %r27
hwintr_2_413:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_413), 16, 16)) -> intp(2, 0, e)
	.word 0xfa04a043  ! 8716: LDUW_I	lduw	[%r18 + 0x0043], %r29
	.word 0xf80d60f9  ! 8717: LDUB_I	ldub	[%r21 + 0x00f9], %r28
	mov	0, %r14
	.word 0xa193a000  ! 8718: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb1540000  ! 8719: RDPR_GL	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982c5b  ! 8721: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c5b, %hpstate
	.word 0xbeb4a1e8  ! 8723: ORNcc_I	orncc 	%r18, 0x01e8, %r31
	.word 0xf855e10c  ! 8727: LDSH_I	ldsh	[%r23 + 0x010c], %r28
	ta	T_CHANGE_HPRIV
	.word 0x81983dd9  ! 8732: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1dd9, %hpstate
	.word 0xf44dc000  ! 8733: LDSB_R	ldsb	[%r23 + %r0], %r26
	ta	T_CHANGE_HPRIV
	.word 0x81982a1b  ! 8734: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a1b, %hpstate
	.word 0xfc4cc000  ! 8735: LDSB_R	ldsb	[%r19 + %r0], %r30
	.word 0xf2458000  ! 8738: LDSW_R	ldsw	[%r22 + %r0], %r25
hwintr_2_414:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_414), 16, 16)) -> intp(2, 0, 1a)
	.word 0x8595a056  ! 8744: WRPR_TSTATE_I	wrpr	%r22, 0x0056, %tstate
	.word 0xb3520000  ! 8746: RDPR_PIL	<illegal instruction>
	.word 0x8595606a  ! 8747: WRPR_TSTATE_I	wrpr	%r21, 0x006a, %tstate
	.word 0xf4552090  ! 8749: LDSH_I	ldsh	[%r20 + 0x0090], %r26
	.word 0xb3480000  ! 8750: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	mov	1, %r14
	.word 0xa193a000  ! 8754: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb444c000  ! 8755: ADDC_R	addc 	%r19, %r0, %r26
	.word 0xb751c000  ! 8756: RDPR_TL	<illegal instruction>
	.word 0xfa1c205d  ! 8758: LDD_I	ldd	[%r16 + 0x005d], %r29
	.word 0xb404c000  ! 8762: ADD_R	add 	%r19, %r0, %r26
hwintr_2_415:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_415), 16, 16)) -> intp(2, 0, 28)
	.word 0x8795a0f9  ! 8767: WRPR_TT_I	wrpr	%r22, 0x00f9, %tt
	.word 0xf40dc000  ! 8768: LDUB_R	ldub	[%r23 + %r0], %r26
	.word 0xf614c000  ! 8769: LDUH_R	lduh	[%r19 + %r0], %r27
	.word 0xb49460d1  ! 8770: ORcc_I	orcc 	%r17, 0x00d1, %r26
	.word 0xb40d0000  ! 8771: AND_R	and 	%r20, %r0, %r26
	.word 0xf60ca1d5  ! 8772: LDUB_I	ldub	[%r18 + 0x01d5], %r27
	.word 0xf41d2016  ! 8777: LDD_I	ldd	[%r20 + 0x0016], %r26
	.word 0xfc450000  ! 8779: LDSW_R	ldsw	[%r20 + %r0], %r30
	.word 0xbf508000  ! 8780: RDPR_TSTATE	<illegal instruction>
	.word 0xf81de1c1  ! 8790: LDD_I	ldd	[%r23 + 0x01c1], %r28
	.word 0xf854e0c2  ! 8792: LDSH_I	ldsh	[%r19 + 0x00c2], %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982941  ! 8794: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0941, %hpstate
	.word 0xb535c000  ! 8796: SRL_R	srl 	%r23, %r0, %r26
	.word 0xbc9dc000  ! 8798: XORcc_R	xorcc 	%r23, %r0, %r30
	.word 0xf31d8000  ! 8799: LDDF_R	ldd	[%r22, %r0], %f25
hwintr_2_416:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_416), 16, 16)) -> intp(2, 0, 2d)
	.word 0xfa550000  ! 8807: LDSH_R	ldsh	[%r20 + %r0], %r29
	.word 0xf845a052  ! 8810: LDSW_I	ldsw	[%r22 + 0x0052], %r28
	.word 0xf85ca0f6  ! 8813: LDX_I	ldx	[%r18 + 0x00f6], %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982b51  ! 8814: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b51, %hpstate
	.word 0xf81d0000  ! 8815: LDD_R	ldd	[%r20 + %r0], %r28
	.word 0xb8c40000  ! 8816: ADDCcc_R	addccc 	%r16, %r0, %r28
	.word 0xb20d4000  ! 8820: AND_R	and 	%r21, %r0, %r25
	.word 0xf45dc000  ! 8822: LDX_R	ldx	[%r23 + %r0], %r26
	.word 0x8195a0a5  ! 8828: WRPR_TPC_I	wrpr	%r22, 0x00a5, %tpc
	ta	T_CHANGE_HPRIV
	.word 0x81982c83  ! 8829: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c83, %hpstate
	.word 0xfd1d6130  ! 8831: LDDF_I	ldd	[%r21, 0x0130], %f30
	.word 0xbf510000  ! 8833: RDPR_TICK	<illegal instruction>
	.word 0xfc0c4000  ! 8834: LDUB_R	ldub	[%r17 + %r0], %r30
	.word 0xf4158000  ! 8837: LDUH_R	lduh	[%r22 + %r0], %r26
	.word 0xb084c000  ! 8844: ADDcc_R	addcc 	%r19, %r0, %r24
	.word 0xb7504000  ! 8845: RDPR_TNPC	<illegal instruction>
	.word 0xf61d0000  ! 8846: LDD_R	ldd	[%r20 + %r0], %r27
	.word 0x8594601b  ! 8847: WRPR_TSTATE_I	wrpr	%r17, 0x001b, %tstate
	.word 0xfa5560a3  ! 8849: LDSH_I	ldsh	[%r21 + 0x00a3], %r29
	.word 0xfa5d8000  ! 8851: LDX_R	ldx	[%r22 + %r0], %r29
	.word 0xf01cc000  ! 8856: LDD_R	ldd	[%r19 + %r0], %r24
hwintr_2_417:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_417), 16, 16)) -> intp(2, 0, 34)
	mov	1, %r12
	.word 0x8f932000  ! 8858: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf2442194  ! 8861: LDSW_I	ldsw	[%r16 + 0x0194], %r25
	.word 0xb5518000  ! 8863: RDPR_PSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982d43  ! 8864: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d43, %hpstate
	.word 0xfc5ce031  ! 8871: LDX_I	ldx	[%r19 + 0x0031], %r30
	setx	data_start_5, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xbc240000  ! 8878: SUB_R	sub 	%r16, %r0, %r30
	.word 0xf41de18a  ! 8882: LDD_I	ldd	[%r23 + 0x018a], %r26
	.word 0xbe0d60a5  ! 8884: AND_I	and 	%r21, 0x00a5, %r31
	.word 0xf60cc000  ! 8885: LDUB_R	ldub	[%r19 + %r0], %r27
	.word 0xb7352001  ! 8886: SRL_I	srl 	%r20, 0x0001, %r27
	.word 0xfa058000  ! 8887: LDUW_R	lduw	[%r22 + %r0], %r29
	.word 0xf2056141  ! 8893: LDUW_I	lduw	[%r21 + 0x0141], %r25
	.word 0xf4448000  ! 8894: LDSW_R	ldsw	[%r18 + %r0], %r26
	.word 0xf205618c  ! 8901: LDUW_I	lduw	[%r21 + 0x018c], %r25
	.word 0xf91ce1c9  ! 8904: LDDF_I	ldd	[%r19, 0x01c9], %f28
	.word 0xfc1d2196  ! 8907: LDD_I	ldd	[%r20 + 0x0196], %r30
	.word 0xf4146132  ! 8912: LDUH_I	lduh	[%r17 + 0x0132], %r26
	.word 0xf01c0000  ! 8913: LDD_R	ldd	[%r16 + %r0], %r24
	.word 0xf4054000  ! 8915: LDUW_R	lduw	[%r21 + %r0], %r26
hwintr_2_418:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_418), 16, 16)) -> intp(2, 0, 39)
	.word 0xf04ce1ea  ! 8919: LDSB_I	ldsb	[%r19 + 0x01ea], %r24
	.word 0xf4158000  ! 8920: LDUH_R	lduh	[%r22 + %r0], %r26
	.word 0xb350c000  ! 8925: RDPR_TT	<illegal instruction>
	.word 0x8394a0c5  ! 8931: WRPR_TNPC_I	wrpr	%r18, 0x00c5, %tnpc
	.word 0xf80da024  ! 8933: LDUB_I	ldub	[%r22 + 0x0024], %r28
	.word 0xf844c000  ! 8934: LDSW_R	ldsw	[%r19 + %r0], %r28
	.word 0xfa0d60fb  ! 8936: LDUB_I	ldub	[%r21 + 0x00fb], %r29
hwintr_2_419:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_419), 16, 16)) -> intp(2, 0, 23)
hwintr_2_420:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_420), 16, 16)) -> intp(2, 0, 1c)
hwintr_2_421:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_421), 16, 16)) -> intp(2, 0, 21)
	.word 0xfa4561d9  ! 8944: LDSW_I	ldsw	[%r21 + 0x01d9], %r29
	.word 0xfa1c0000  ! 8947: LDD_R	ldd	[%r16 + %r0], %r29
	.word 0xb60d2152  ! 8952: AND_I	and 	%r20, 0x0152, %r27
	.word 0xf71da180  ! 8954: LDDF_I	ldd	[%r22, 0x0180], %f27
	.word 0xbc3560c6  ! 8956: SUBC_I	orn 	%r21, 0x00c6, %r30
	.word 0xfa458000  ! 8965: LDSW_R	ldsw	[%r22 + %r0], %r29
	.word 0xfe0c201f  ! 8968: LDUB_I	ldub	[%r16 + 0x001f], %r31
hwintr_2_422:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_422), 16, 16)) -> intp(2, 0, 18)
	.word 0xf64c208a  ! 8976: LDSB_I	ldsb	[%r16 + 0x008a], %r27
	.word 0xb5357001  ! 8977: SRLX_I	srlx	%r21, 0x0001, %r26
hwintr_2_423:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_423), 16, 16)) -> intp(2, 0, a)
	setx	data_start_4, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8394604b  ! 8984: WRPR_TNPC_I	wrpr	%r17, 0x004b, %tnpc
	.word 0xb5480000  ! 8988: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xfe0dc000  ! 8989: LDUB_R	ldub	[%r23 + %r0], %r31
	ta	T_CHANGE_HPRIV
	.word 0x819829d9  ! 8992: WRHPR_HPSTATE_I	wrhpr	%r0, 0x09d9, %hpstate
	.word 0xb60c0000  ! 8993: AND_R	and 	%r16, %r0, %r27
	.word 0xf01dc000  ! 8994: LDD_R	ldd	[%r23 + %r0], %r24
	.word 0xfe54606c  ! 8995: LDSH_I	ldsh	[%r17 + 0x006c], %r31
	.word 0xfa1561b7  ! 9000: LDUH_I	lduh	[%r21 + 0x01b7], %r29
	.word 0xb5518000  ! 9001: RDPR_PSTATE	<illegal instruction>
	.word 0xf05cc000  ! 9003: LDX_R	ldx	[%r19 + %r0], %r24
hwintr_2_424:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_424), 16, 16)) -> intp(2, 0, d)
	.word 0xb73d3001  ! 9010: SRAX_I	srax	%r20, 0x0001, %r27
	.word 0xfe5d4000  ! 9012: LDX_R	ldx	[%r21 + %r0], %r31
	.word 0xf40da138  ! 9013: LDUB_I	ldub	[%r22 + 0x0138], %r26
	.word 0xbe34c000  ! 9015: SUBC_R	orn 	%r19, %r0, %r31
	.word 0xf64460b2  ! 9018: LDSW_I	ldsw	[%r17 + 0x00b2], %r27
	.word 0xb9480000  ! 9019: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xbabc6091  ! 9024: XNORcc_I	xnorcc 	%r17, 0x0091, %r29
	.word 0xfc4d21e2  ! 9025: LDSB_I	ldsb	[%r20 + 0x01e2], %r30
	.word 0xb7518000  ! 9028: RDPR_PSTATE	<illegal instruction>
	.word 0xf414e0f6  ! 9029: LDUH_I	lduh	[%r19 + 0x00f6], %r26
	.word 0xf244604b  ! 9031: LDSW_I	ldsw	[%r17 + 0x004b], %r25
	.word 0xfe140000  ! 9032: LDUH_R	lduh	[%r16 + %r0], %r31
	.word 0xfc1ce152  ! 9035: LDD_I	ldd	[%r19 + 0x0152], %r30
	.word 0xfe04c000  ! 9036: LDUW_R	lduw	[%r19 + %r0], %r31
	.word 0xb415603b  ! 9037: OR_I	or 	%r21, 0x003b, %r26
	.word 0xfe54e1be  ! 9041: LDSH_I	ldsh	[%r19 + 0x01be], %r31
	.word 0xfe1c2126  ! 9043: LDD_I	ldd	[%r16 + 0x0126], %r31
	.word 0xfa04a150  ! 9048: LDUW_I	lduw	[%r18 + 0x0150], %r29
	.word 0xfc454000  ! 9049: LDSW_R	ldsw	[%r21 + %r0], %r30
	ta	T_CHANGE_HPRIV
	.word 0x81982989  ! 9051: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0989, %hpstate
	.word 0xfa0de0bc  ! 9053: LDUB_I	ldub	[%r23 + 0x00bc], %r29
	.word 0xb7510000  ! 9057: RDPR_TICK	<illegal instruction>
	.word 0xf45d0000  ! 9058: LDX_R	ldx	[%r20 + %r0], %r26
	mov	1, %r14
	.word 0xa193a000  ! 9059: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb750c000  ! 9063: RDPR_TT	<illegal instruction>
	setx	data_start_4, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_2_425:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_425), 16, 16)) -> intp(2, 0, 22)
	.word 0xfc54c000  ! 9067: LDSH_R	ldsh	[%r19 + %r0], %r30
hwintr_2_426:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_426), 16, 16)) -> intp(2, 0, 1b)
	.word 0xfe552094  ! 9071: LDSH_I	ldsh	[%r20 + 0x0094], %r31
hwintr_2_427:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_427), 16, 16)) -> intp(2, 0, 2b)
	.word 0xfc450000  ! 9076: LDSW_R	ldsw	[%r20 + %r0], %r30
	.word 0x8595212a  ! 9077: WRPR_TSTATE_I	wrpr	%r20, 0x012a, %tstate
	.word 0x9195e171  ! 9078: WRPR_PIL_I	wrpr	%r23, 0x0171, %pil
	.word 0x859421fc  ! 9079: WRPR_TSTATE_I	wrpr	%r16, 0x01fc, %tstate
	.word 0xb1480000  ! 9080: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xf40d6164  ! 9082: LDUB_I	ldub	[%r21 + 0x0164], %r26
	.word 0x91942130  ! 9083: WRPR_PIL_I	wrpr	%r16, 0x0130, %pil
	.word 0xfa04e067  ! 9086: LDUW_I	lduw	[%r19 + 0x0067], %r29
	.word 0xf44c4000  ! 9088: LDSB_R	ldsb	[%r17 + %r0], %r26
	.word 0xfc448000  ! 9094: LDSW_R	ldsw	[%r18 + %r0], %r30
	.word 0xf054c000  ! 9095: LDSH_R	ldsh	[%r19 + %r0], %r24
	.word 0xb615a143  ! 9097: OR_I	or 	%r22, 0x0143, %r27
	.word 0xb4b50000  ! 9098: SUBCcc_R	orncc 	%r20, %r0, %r26
	.word 0xb9346001  ! 9100: SRL_I	srl 	%r17, 0x0001, %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982f4b  ! 9101: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f4b, %hpstate
	.word 0xfc4c8000  ! 9103: LDSB_R	ldsb	[%r18 + %r0], %r30
	setx	data_start_7, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf00ce0c8  ! 9107: LDUB_I	ldub	[%r19 + 0x00c8], %r24
	.word 0xf91c2012  ! 9108: LDDF_I	ldd	[%r16, 0x0012], %f28
	.word 0xb1643801  ! 9110: MOVcc_I	<illegal instruction>
	.word 0xb82c4000  ! 9113: ANDN_R	andn 	%r17, %r0, %r28
	setx	data_start_5, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf0044000  ! 9116: LDUW_R	lduw	[%r17 + %r0], %r24
	.word 0xf85ce17e  ! 9118: LDX_I	ldx	[%r19 + 0x017e], %r28
	.word 0x879420ef  ! 9121: WRPR_TT_I	wrpr	%r16, 0x00ef, %tt
	.word 0xbf500000  ! 9122: RDPR_TPC	<illegal instruction>
	.word 0xbf520000  ! 9125: RDPR_PIL	<illegal instruction>
hwintr_2_428:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_428), 16, 16)) -> intp(2, 0, 11)
	.word 0xfc15201b  ! 9129: LDUH_I	lduh	[%r20 + 0x001b], %r30
	.word 0x85956117  ! 9131: WRPR_TSTATE_I	wrpr	%r21, 0x0117, %tstate
hwintr_2_429:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_429), 16, 16)) -> intp(2, 0, 2)
	.word 0xf645e020  ! 9140: LDSW_I	ldsw	[%r23 + 0x0020], %r27
	.word 0xb550c000  ! 9141: RDPR_TT	<illegal instruction>
hwintr_2_430:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_430), 16, 16)) -> intp(2, 0, 2e)
	.word 0xb824e0e8  ! 9143: SUB_I	sub 	%r19, 0x00e8, %r28
	.word 0xfe44e1b9  ! 9144: LDSW_I	ldsw	[%r19 + 0x01b9], %r31
hwintr_2_431:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_431), 16, 16)) -> intp(2, 0, 1e)
	.word 0xfc05a196  ! 9150: LDUW_I	lduw	[%r22 + 0x0196], %r30
	.word 0xbabca182  ! 9156: XNORcc_I	xnorcc 	%r18, 0x0182, %r29
	setx	data_start_2, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf85d8000  ! 9158: LDX_R	ldx	[%r22 + %r0], %r28
	.word 0xbb354000  ! 9164: SRL_R	srl 	%r21, %r0, %r29
	.word 0xfc5d209c  ! 9165: LDX_I	ldx	[%r20 + 0x009c], %r30
	.word 0xb33d2001  ! 9166: SRA_I	sra 	%r20, 0x0001, %r25
	.word 0xfa4c0000  ! 9168: LDSB_R	ldsb	[%r16 + %r0], %r29
	.word 0xb8b4c000  ! 9172: SUBCcc_R	orncc 	%r19, %r0, %r28
	.word 0xf414c000  ! 9174: LDUH_R	lduh	[%r19 + %r0], %r26
	.word 0xbb520000  ! 9178: RDPR_PIL	<illegal instruction>
	.word 0xbf2cb001  ! 9181: SLLX_I	sllx	%r18, 0x0001, %r31
	.word 0xb4058000  ! 9185: ADD_R	add 	%r22, %r0, %r26
	.word 0xb4a461ef  ! 9187: SUBcc_I	subcc 	%r17, 0x01ef, %r26
	.word 0xfe5ca129  ! 9188: LDX_I	ldx	[%r18 + 0x0129], %r31
hwintr_2_432:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_432), 16, 16)) -> intp(2, 0, 26)
	.word 0xfc058000  ! 9195: LDUW_R	lduw	[%r22 + %r0], %r30
	.word 0xb32d0000  ! 9202: SLL_R	sll 	%r20, %r0, %r25
	.word 0xf71ce074  ! 9204: LDDF_I	ldd	[%r19, 0x0074], %f27
	.word 0xbebc6159  ! 9206: XNORcc_I	xnorcc 	%r17, 0x0159, %r31
	.word 0xb83421c7  ! 9209: SUBC_I	orn 	%r16, 0x01c7, %r28
	.word 0xb350c000  ! 9210: RDPR_TT	<illegal instruction>
	.word 0x899420f4  ! 9215: WRPR_TICK_I	wrpr	%r16, 0x00f4, %tick
	.word 0xf85da0a8  ! 9216: LDX_I	ldx	[%r22 + 0x00a8], %r28
	.word 0xf4440000  ! 9218: LDSW_R	ldsw	[%r16 + %r0], %r26
	.word 0xb3504000  ! 9223: RDPR_TNPC	<illegal instruction>
	.word 0xf8154000  ! 9226: LDUH_R	lduh	[%r21 + %r0], %r28
	.word 0xbc354000  ! 9229: ORN_R	orn 	%r21, %r0, %r30
	.word 0xb7518000  ! 9232: RDPR_PSTATE	<illegal instruction>
	.word 0xba458000  ! 9233: ADDC_R	addc 	%r22, %r0, %r29
	.word 0xf214e1d9  ! 9235: LDUH_I	lduh	[%r19 + 0x01d9], %r25
	.word 0x9195a098  ! 9237: WRPR_PIL_I	wrpr	%r22, 0x0098, %pil
	.word 0xfe454000  ! 9238: LDSW_R	ldsw	[%r21 + %r0], %r31
	.word 0xb9520000  ! 9241: RDPR_PIL	<illegal instruction>
	.word 0xf11c219c  ! 9243: LDDF_I	ldd	[%r16, 0x019c], %f24
	.word 0x9195e145  ! 9244: WRPR_PIL_I	wrpr	%r23, 0x0145, %pil
	.word 0xfc05213b  ! 9247: LDUW_I	lduw	[%r20 + 0x013b], %r30
	setx	data_start_4, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8594e122  ! 9250: WRPR_TSTATE_I	wrpr	%r19, 0x0122, %tstate
	.word 0xf804e034  ! 9251: LDUW_I	lduw	[%r19 + 0x0034], %r28
	.word 0xf05ca01b  ! 9257: LDX_I	ldx	[%r18 + 0x001b], %r24
hwintr_2_433:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_433), 16, 16)) -> intp(2, 0, 1b)
	.word 0xb7480000  ! 9259: RDHPR_HPSTATE	rdhpr	%hpstate, %r27
	.word 0xf31cc000  ! 9260: LDDF_R	ldd	[%r19, %r0], %f25
	.word 0xf4046111  ! 9268: LDUW_I	lduw	[%r17 + 0x0111], %r26
hwintr_2_434:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_434), 16, 16)) -> intp(2, 0, 37)
	.word 0x91946136  ! 9271: WRPR_PIL_I	wrpr	%r17, 0x0136, %pil
	.word 0xb77c6401  ! 9272: MOVR_I	movre	%r17, 0x1, %r27
	.word 0xfe5c4000  ! 9274: LDX_R	ldx	[%r17 + %r0], %r31
	.word 0xf40c8000  ! 9276: LDUB_R	ldub	[%r18 + %r0], %r26
	.word 0xbc442036  ! 9278: ADDC_I	addc 	%r16, 0x0036, %r30
	.word 0xf8452004  ! 9285: LDSW_I	ldsw	[%r20 + 0x0004], %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982b51  ! 9288: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b51, %hpstate
	.word 0xb41d208e  ! 9290: XOR_I	xor 	%r20, 0x008e, %r26
	.word 0xf4042000  ! 9291: LDUW_I	lduw	[%r16 + 0x0000], %r26
	.word 0xf8150000  ! 9293: LDUH_R	lduh	[%r20 + %r0], %r28
	.word 0x899520b6  ! 9294: WRPR_TICK_I	wrpr	%r20, 0x00b6, %tick
	.word 0xbec5218d  ! 9296: ADDCcc_I	addccc 	%r20, 0x018d, %r31
	.word 0xf2454000  ! 9300: LDSW_R	ldsw	[%r21 + %r0], %r25
	.word 0xb3508000  ! 9302: RDPR_TSTATE	<illegal instruction>
	.word 0xb3510000  ! 9308: RDPR_TICK	<illegal instruction>
	.word 0xfa4521ab  ! 9309: LDSW_I	ldsw	[%r20 + 0x01ab], %r29
hwintr_2_435:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_435), 16, 16)) -> intp(2, 0, 3c)
	.word 0xf654215e  ! 9316: LDSH_I	ldsh	[%r16 + 0x015e], %r27
	.word 0x9194e1ba  ! 9321: WRPR_PIL_I	wrpr	%r19, 0x01ba, %pil
	.word 0xfc0c4000  ! 9322: LDUB_R	ldub	[%r17 + %r0], %r30
	.word 0xbb504000  ! 9323: RDPR_TNPC	<illegal instruction>
	.word 0xfc1c4000  ! 9326: LDD_R	ldd	[%r17 + %r0], %r30
	.word 0x9195a1a9  ! 9328: WRPR_PIL_I	wrpr	%r22, 0x01a9, %pil
	.word 0x919521e4  ! 9329: WRPR_PIL_I	wrpr	%r20, 0x01e4, %pil
	.word 0xb60d6069  ! 9331: AND_I	and 	%r21, 0x0069, %r27
	.word 0xf84c0000  ! 9333: LDSB_R	ldsb	[%r16 + %r0], %r28
	mov	2, %r12
	.word 0x8f932000  ! 9334: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf605202c  ! 9335: LDUW_I	lduw	[%r20 + 0x002c], %r27
hwintr_2_436:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_436), 16, 16)) -> intp(2, 0, 2c)
	.word 0xb5500000  ! 9343: RDPR_TPC	<illegal instruction>
	.word 0xfe5d0000  ! 9344: LDX_R	ldx	[%r20 + %r0], %r31
	.word 0xb3504000  ! 9345: RDPR_TNPC	<illegal instruction>
	.word 0xf8050000  ! 9346: LDUW_R	lduw	[%r20 + %r0], %r28
	.word 0xf31c4000  ! 9353: LDDF_R	ldd	[%r17, %r0], %f25
hwintr_2_437:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_437), 16, 16)) -> intp(2, 0, 3a)
	.word 0xfc058000  ! 9360: LDUW_R	lduw	[%r22 + %r0], %r30
	.word 0xfe0461df  ! 9367: LDUW_I	lduw	[%r17 + 0x01df], %r31
	.word 0xfe54a031  ! 9369: LDSH_I	ldsh	[%r18 + 0x0031], %r31
	.word 0x8594e1ce  ! 9372: WRPR_TSTATE_I	wrpr	%r19, 0x01ce, %tstate
	.word 0xb350c000  ! 9374: RDPR_TT	<illegal instruction>
	.word 0xf45c60f2  ! 9380: LDX_I	ldx	[%r17 + 0x00f2], %r26
	mov	2, %r14
	.word 0xa193a000  ! 9382: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xf44c8000  ! 9383: LDSB_R	ldsb	[%r18 + %r0], %r26
	.word 0xf25d61af  ! 9385: LDX_I	ldx	[%r21 + 0x01af], %r25
	mov	1, %r14
	.word 0xa193a000  ! 9390: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	mov	2, %r14
	.word 0xa193a000  ! 9392: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfb1ce052  ! 9393: LDDF_I	ldd	[%r19, 0x0052], %f29
	.word 0xfc4cc000  ! 9394: LDSB_R	ldsb	[%r19 + %r0], %r30
	mov	1, %r14
	.word 0xa193a000  ! 9396: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7520000  ! 9398: RDPR_PIL	<illegal instruction>
	.word 0xf8144000  ! 9403: LDUH_R	lduh	[%r17 + %r0], %r28
hwintr_2_438:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_438), 16, 16)) -> intp(2, 0, 2e)
	.word 0xf85d607c  ! 9407: LDX_I	ldx	[%r21 + 0x007c], %r28
	ta	T_CHANGE_HPRIV
	.word 0x81982f13  ! 9409: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f13, %hpstate
hwintr_2_439:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_439), 16, 16)) -> intp(2, 0, 3c)
hwintr_2_440:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_440), 16, 16)) -> intp(2, 0, 18)
	.word 0xf05d21e3  ! 9418: LDX_I	ldx	[%r20 + 0x01e3], %r24
	.word 0xb9518000  ! 9419: RDPR_PSTATE	<illegal instruction>
	.word 0xb69ca11c  ! 9422: XORcc_I	xorcc 	%r18, 0x011c, %r27
	.word 0x8d95e1b9  ! 9423: WRPR_PSTATE_I	wrpr	%r23, 0x01b9, %pstate
	.word 0xbf480000  ! 9424: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	setx	data_start_7, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8d95e136  ! 9433: WRPR_PSTATE_I	wrpr	%r23, 0x0136, %pstate
	.word 0xb244c000  ! 9434: ADDC_R	addc 	%r19, %r0, %r25
	.word 0xb9480000  ! 9437: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xb950c000  ! 9438: RDPR_TT	<illegal instruction>
	.word 0xf04c2011  ! 9440: LDSB_I	ldsb	[%r16 + 0x0011], %r24
hwintr_2_441:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_441), 16, 16)) -> intp(2, 0, 32)
	.word 0xb89461bd  ! 9444: ORcc_I	orcc 	%r17, 0x01bd, %r28
	.word 0xb1510000  ! 9448: RDPR_TICK	<illegal instruction>
	.word 0xbd480000  ! 9449: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xf0444000  ! 9452: LDSW_R	ldsw	[%r17 + %r0], %r24
	.word 0xf2544000  ! 9453: LDSH_R	ldsh	[%r17 + %r0], %r25
	.word 0xfe44619a  ! 9454: LDSW_I	ldsw	[%r17 + 0x019a], %r31
hwintr_2_442:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_442), 16, 16)) -> intp(2, 0, 27)
	.word 0xf51d2174  ! 9457: LDDF_I	ldd	[%r20, 0x0174], %f26
	.word 0xb151c000  ! 9462: RDPR_TL	<illegal instruction>
	.word 0xb73d8000  ! 9464: SRA_R	sra 	%r22, %r0, %r27
	.word 0xfe45a00a  ! 9467: LDSW_I	ldsw	[%r22 + 0x000a], %r31
	.word 0xf01c2017  ! 9471: LDD_I	ldd	[%r16 + 0x0017], %r24
	.word 0xf25da14d  ! 9472: LDX_I	ldx	[%r22 + 0x014d], %r25
	.word 0xfc156111  ! 9474: LDUH_I	lduh	[%r21 + 0x0111], %r30
	.word 0xf804e0c2  ! 9477: LDUW_I	lduw	[%r19 + 0x00c2], %r28
	.word 0xf51d4000  ! 9485: LDDF_R	ldd	[%r21, %r0], %f26
hwintr_2_443:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_443), 16, 16)) -> intp(2, 0, 29)
	.word 0xf005a065  ! 9491: LDUW_I	lduw	[%r22 + 0x0065], %r24
	.word 0xf0450000  ! 9492: LDSW_R	ldsw	[%r20 + %r0], %r24
	.word 0xfa55208c  ! 9494: LDSH_I	ldsh	[%r20 + 0x008c], %r29
	.word 0xf4140000  ! 9497: LDUH_R	lduh	[%r16 + %r0], %r26
	.word 0xbb510000  ! 9499: RDPR_TICK	<illegal instruction>
	.word 0xbd3c1000  ! 9500: SRAX_R	srax	%r16, %r0, %r30
	.word 0x919560b0  ! 9501: WRPR_PIL_I	wrpr	%r21, 0x00b0, %pil
	.word 0xf25dc000  ! 9504: LDX_R	ldx	[%r23 + %r0], %r25
	.word 0xb41420e3  ! 9506: OR_I	or 	%r16, 0x00e3, %r26
	.word 0xfa4c8000  ! 9507: LDSB_R	ldsb	[%r18 + %r0], %r29
	setx	data_start_6, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	setx	data_start_6, %g1, %r21
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r21, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xb4444000  ! 9511: ADDC_R	addc 	%r17, %r0, %r26
	.word 0xfe0ca0b6  ! 9513: LDUB_I	ldub	[%r18 + 0x00b6], %r31
	.word 0xf80c8000  ! 9514: LDUB_R	ldub	[%r18 + %r0], %r28
	.word 0x8195615c  ! 9515: WRPR_TPC_I	wrpr	%r21, 0x015c, %tpc
	.word 0xf2442079  ! 9517: LDSW_I	ldsw	[%r16 + 0x0079], %r25
	.word 0xf61dc000  ! 9519: LDD_R	ldd	[%r23 + %r0], %r27
	.word 0xfe5c8000  ! 9523: LDX_R	ldx	[%r18 + %r0], %r31
	.word 0xf65da159  ! 9526: LDX_I	ldx	[%r22 + 0x0159], %r27
	.word 0xf405606d  ! 9527: LDUW_I	lduw	[%r21 + 0x006d], %r26
	.word 0xfa0c0000  ! 9529: LDUB_R	ldub	[%r16 + %r0], %r29
hwintr_2_444:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_444), 16, 16)) -> intp(2, 0, 20)
	.word 0xfc546037  ! 9533: LDSH_I	ldsh	[%r17 + 0x0037], %r30
	setx	data_start_0, %g1, %r18
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r18, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfd1c8000  ! 9535: LDDF_R	ldd	[%r18, %r0], %f30
	.word 0xfa054000  ! 9537: LDUW_R	lduw	[%r21 + %r0], %r29
	.word 0x8994611b  ! 9542: WRPR_TICK_I	wrpr	%r17, 0x011b, %tick
hwintr_2_445:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_445), 16, 16)) -> intp(2, 0, 4)
	.word 0xf51ca174  ! 9545: LDDF_I	ldd	[%r18, 0x0174], %f26
	.word 0xf2142196  ! 9548: LDUH_I	lduh	[%r16 + 0x0196], %r25
	.word 0xfa140000  ! 9551: LDUH_R	lduh	[%r16 + %r0], %r29
hwintr_2_446:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_446), 16, 16)) -> intp(2, 0, 39)
	.word 0xf61c8000  ! 9556: LDD_R	ldd	[%r18 + %r0], %r27
	.word 0xf51ce097  ! 9557: LDDF_I	ldd	[%r19, 0x0097], %f26
	.word 0xf8144000  ! 9560: LDUH_R	lduh	[%r17 + %r0], %r28
	.word 0xbe9d61cc  ! 9562: XORcc_I	xorcc 	%r21, 0x01cc, %r31
	.word 0xb42c8000  ! 9563: ANDN_R	andn 	%r18, %r0, %r26
	.word 0xb5508000  ! 9564: RDPR_TSTATE	<illegal instruction>
	.word 0xfa558000  ! 9565: LDSH_R	ldsh	[%r22 + %r0], %r29
	.word 0xb0b4a1f1  ! 9570: ORNcc_I	orncc 	%r18, 0x01f1, %r24
	.word 0xf454e02d  ! 9571: LDSH_I	ldsh	[%r19 + 0x002d], %r26
	.word 0xf04c6077  ! 9573: LDSB_I	ldsb	[%r17 + 0x0077], %r24
	.word 0xfe0dc000  ! 9574: LDUB_R	ldub	[%r23 + %r0], %r31
	.word 0xfc5d21bd  ! 9577: LDX_I	ldx	[%r20 + 0x01bd], %r30
	.word 0xb750c000  ! 9583: RDPR_TT	<illegal instruction>
	.word 0xbb500000  ! 9585: RDPR_TPC	<illegal instruction>
hwintr_2_447:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_447), 16, 16)) -> intp(2, 0, 3a)
hwintr_2_448:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_448), 16, 16)) -> intp(2, 0, 3c)
	.word 0xb6ad611a  ! 9589: ANDNcc_I	andncc 	%r21, 0x011a, %r27
hwintr_2_449:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_449), 16, 16)) -> intp(2, 0, 2b)
	.word 0xf65d0000  ! 9594: LDX_R	ldx	[%r20 + %r0], %r27
	.word 0xf81de001  ! 9596: LDD_I	ldd	[%r23 + 0x0001], %r28
	.word 0xf91da0f0  ! 9597: LDDF_I	ldd	[%r22, 0x00f0], %f28
	.word 0xf4558000  ! 9600: LDSH_R	ldsh	[%r22 + %r0], %r26
	.word 0xbc3ca12b  ! 9601: XNOR_I	xnor 	%r18, 0x012b, %r30
hwintr_2_450:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_450), 16, 16)) -> intp(2, 0, 14)
	.word 0xf855e13a  ! 9603: LDSH_I	ldsh	[%r23 + 0x013a], %r28
	setx	data_start_6, %g1, %r16
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r16, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xfc148000  ! 9609: LDUH_R	lduh	[%r18 + %r0], %r30
	.word 0x83942179  ! 9615: WRPR_TNPC_I	wrpr	%r16, 0x0179, %tnpc
	.word 0x8d95616d  ! 9620: WRPR_PSTATE_I	wrpr	%r21, 0x016d, %pstate
hwintr_2_451:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_451), 16, 16)) -> intp(2, 0, 1)
	.word 0x8795a1af  ! 9625: WRPR_TT_I	wrpr	%r22, 0x01af, %tt
	.word 0xf0558000  ! 9626: LDSH_R	ldsh	[%r22 + %r0], %r24
	.word 0xf51da0c3  ! 9631: LDDF_I	ldd	[%r22, 0x00c3], %f26
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xbe2c2173  ! 9634: ANDN_I	andn 	%r16, 0x0173, %r31
	.word 0xf414a055  ! 9635: LDUH_I	lduh	[%r18 + 0x0055], %r26
	.word 0xfe14e006  ! 9636: LDUH_I	lduh	[%r19 + 0x0006], %r31
	.word 0xf64421f0  ! 9638: LDSW_I	ldsw	[%r16 + 0x01f0], %r27
	.word 0xbd357001  ! 9643: SRLX_I	srlx	%r21, 0x0001, %r30
	.word 0x8d942067  ! 9644: WRPR_PSTATE_I	wrpr	%r16, 0x0067, %pstate
hwintr_2_452:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_452), 16, 16)) -> intp(2, 0, 37)
	.word 0xf21de0c1  ! 9648: LDD_I	ldd	[%r23 + 0x00c1], %r25
hwintr_2_453:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_453), 16, 16)) -> intp(2, 0, 17)
	.word 0xf11c0000  ! 9653: LDDF_R	ldd	[%r16, %r0], %f24
hwintr_2_454:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_454), 16, 16)) -> intp(2, 0, a)
	.word 0xfd1c4000  ! 9658: LDDF_R	ldd	[%r17, %r0], %f30
hwintr_2_455:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_455), 16, 16)) -> intp(2, 0, 11)
	.word 0x8d95e0f8  ! 9665: WRPR_PSTATE_I	wrpr	%r23, 0x00f8, %pstate
	.word 0xfe45a049  ! 9666: LDSW_I	ldsw	[%r22 + 0x0049], %r31
	.word 0xbf50c000  ! 9667: RDPR_TT	<illegal instruction>
	.word 0xf6440000  ! 9671: LDSW_R	ldsw	[%r16 + %r0], %r27
	.word 0xf71d6052  ! 9672: LDDF_I	ldd	[%r21, 0x0052], %f27
	.word 0xfa44600e  ! 9674: LDSW_I	ldsw	[%r17 + 0x000e], %r29
	.word 0xf44da092  ! 9676: LDSB_I	ldsb	[%r22 + 0x0092], %r26
	.word 0xf24ce07e  ! 9677: LDSB_I	ldsb	[%r19 + 0x007e], %r25
	mov	0, %r14
	.word 0xa193a000  ! 9678: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb6144000  ! 9680: OR_R	or 	%r17, %r0, %r27
	.word 0xb735e001  ! 9681: SRL_I	srl 	%r23, 0x0001, %r27
hwintr_2_456:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_456), 16, 16)) -> intp(2, 0, 25)
	.word 0xfc04e1c7  ! 9688: LDUW_I	lduw	[%r19 + 0x01c7], %r30
	mov	2, %r14
	.word 0xa193a000  ! 9689: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x859420d4  ! 9691: WRPR_TSTATE_I	wrpr	%r16, 0x00d4, %tstate
	.word 0xb350c000  ! 9695: RDPR_TT	rdpr	%tt, %r25
hwintr_2_457:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_457), 16, 16)) -> intp(2, 0, 1f)
	.word 0xfc5dc000  ! 9705: LDX_R	ldx	[%r23 + %r0], %r30
hwintr_2_458:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_458), 16, 16)) -> intp(2, 0, 17)
	.word 0xf44d4000  ! 9710: LDSB_R	ldsb	[%r21 + %r0], %r26
	.word 0xf21420a3  ! 9713: LDUH_I	lduh	[%r16 + 0x00a3], %r25
	.word 0x85942154  ! 9720: WRPR_TSTATE_I	wrpr	%r16, 0x0154, %tstate
	.word 0xfa5de1d7  ! 9721: LDX_I	ldx	[%r23 + 0x01d7], %r29
	.word 0xb6144000  ! 9722: OR_R	or 	%r17, %r0, %r27
	.word 0xf8452158  ! 9723: LDSW_I	ldsw	[%r20 + 0x0158], %r28
	mov	2, %r14
	.word 0xa193a000  ! 9725: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xfa04e1a5  ! 9726: LDUW_I	lduw	[%r19 + 0x01a5], %r29
	.word 0xb41cc000  ! 9730: XOR_R	xor 	%r19, %r0, %r26
	.word 0xfc1c8000  ! 9732: LDD_R	ldd	[%r18 + %r0], %r30
	.word 0xbf508000  ! 9733: RDPR_TSTATE	rdpr	%tstate, %r31
	.word 0xfc042087  ! 9734: LDUW_I	lduw	[%r16 + 0x0087], %r30
	.word 0x8595a115  ! 9739: WRPR_TSTATE_I	wrpr	%r22, 0x0115, %tstate
	.word 0x859521a3  ! 9740: WRPR_TSTATE_I	wrpr	%r20, 0x01a3, %tstate
	.word 0x899561b6  ! 9742: WRPR_TICK_I	wrpr	%r21, 0x01b6, %tick
	setx	data_start_2, %g1, %r22
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r22, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf055e0d0  ! 9745: LDSH_I	ldsh	[%r23 + 0x00d0], %r24
hwintr_2_459:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_459), 16, 16)) -> intp(2, 0, 18)
	.word 0xb6148000  ! 9751: OR_R	or 	%r18, %r0, %r27
	.word 0xb42ce04c  ! 9752: ANDN_I	andn 	%r19, 0x004c, %r26
	mov	1, %r12
	.word 0x8f932000  ! 9758: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xf0454000  ! 9759: LDSW_R	ldsw	[%r21 + %r0], %r24
	.word 0xf0448000  ! 9763: LDSW_R	ldsw	[%r18 + %r0], %r24
	.word 0xfc550000  ! 9765: LDSH_R	ldsh	[%r20 + %r0], %r30
	ta	T_CHANGE_HPRIV
	.word 0x81983899  ! 9766: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1899, %hpstate
	mov	0, %r14
	.word 0xa193a000  ! 9773: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb43c6014  ! 9776: XNOR_I	xnor 	%r17, 0x0014, %r26
	.word 0xf25dc000  ! 9778: LDX_R	ldx	[%r23 + %r0], %r25
	.word 0xfc0561df  ! 9779: LDUW_I	lduw	[%r21 + 0x01df], %r30
	.word 0xf044c000  ! 9782: LDSW_R	ldsw	[%r19 + %r0], %r24
	.word 0xfc4c0000  ! 9783: LDSB_R	ldsb	[%r16 + %r0], %r30
hwintr_2_460:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_460), 16, 16)) -> intp(2, 0, 2d)
	.word 0xf04dc000  ! 9791: LDSB_R	ldsb	[%r23 + %r0], %r24
	.word 0x919560c3  ! 9796: WRPR_PIL_I	wrpr	%r21, 0x00c3, %pil
	.word 0xf81c618a  ! 9798: LDD_I	ldd	[%r17 + 0x018a], %r28
	.word 0xb551c000  ! 9801: RDPR_TL	<illegal instruction>
	.word 0xf64da1bd  ! 9803: LDSB_I	ldsb	[%r22 + 0x01bd], %r27
	.word 0x8d94600a  ! 9808: WRPR_PSTATE_I	wrpr	%r17, 0x000a, %pstate
	.word 0xb005c000  ! 9809: ADD_R	add 	%r23, %r0, %r24
hwintr_2_461:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_461), 16, 16)) -> intp(2, 0, 8)
	.word 0xf11d0000  ! 9829: LDDF_R	ldd	[%r20, %r0], %f24
	.word 0xf91da151  ! 9830: LDDF_I	ldd	[%r22, 0x0151], %f28
	.word 0xfa058000  ! 9832: LDUW_R	lduw	[%r22 + %r0], %r29
	.word 0xf81dc000  ! 9834: LDD_R	ldd	[%r23 + %r0], %r28
hwintr_2_462:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_462), 16, 16)) -> intp(2, 0, 3f)
	ta	T_CHANGE_HPRIV
	.word 0x81982dcb  ! 9838: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dcb, %hpstate
	.word 0xbea44000  ! 9840: SUBcc_R	subcc 	%r17, %r0, %r31
	.word 0xf91d60a6  ! 9846: LDDF_I	ldd	[%r21, 0x00a6], %f28
	.word 0xb01c60e7  ! 9847: XOR_I	xor 	%r17, 0x00e7, %r24
	.word 0x879561b4  ! 9848: WRPR_TT_I	wrpr	%r21, 0x01b4, %tt
	.word 0xb9520000  ! 9849: RDPR_PIL	<illegal instruction>
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0x8395a047  ! 9863: WRPR_TNPC_I	wrpr	%r22, 0x0047, %tnpc
	.word 0xfd1c0000  ! 9869: LDDF_R	ldd	[%r16, %r0], %f30
hwintr_2_463:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_463), 16, 16)) -> intp(2, 0, 3f)
	.word 0xf71ce02f  ! 9872: LDDF_I	ldd	[%r19, 0x002f], %f27
	.word 0xf80ce067  ! 9873: LDUB_I	ldub	[%r19 + 0x0067], %r28
	.word 0xfe4421ce  ! 9875: LDSW_I	ldsw	[%r16 + 0x01ce], %r31
hwintr_2_464:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_464), 16, 16)) -> intp(2, 0, 12)
	.word 0xf8540000  ! 9881: LDSH_R	ldsh	[%r16 + %r0], %r28
	.word 0x8394e1c5  ! 9883: WRPR_TNPC_I	wrpr	%r19, 0x01c5, %tnpc
	.word 0xfc0de02c  ! 9885: LDUB_I	ldub	[%r23 + 0x002c], %r30
	.word 0xf405a0f7  ! 9888: LDUW_I	lduw	[%r22 + 0x00f7], %r26
	.word 0xb435e13a  ! 9889: ORN_I	orn 	%r23, 0x013a, %r26
	.word 0xf4442019  ! 9890: LDSW_I	ldsw	[%r16 + 0x0019], %r26
	setx	data_start_4, %g1, %r23
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r23, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0x8d95a1d6  ! 9894: WRPR_PSTATE_I	wrpr	%r22, 0x01d6, %pstate
	setx	data_start_2, %g1, %r17
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r17, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
hwintr_2_465:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_465), 16, 16)) -> intp(2, 0, 3e)
	.word 0xb6b5e1d1  ! 9899: ORNcc_I	orncc 	%r23, 0x01d1, %r27
hwintr_2_466:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_466), 16, 16)) -> intp(2, 0, 1e)
	.word 0xb684c000  ! 9909: ADDcc_R	addcc 	%r19, %r0, %r27
	.word 0xf61de126  ! 9910: LDD_I	ldd	[%r23 + 0x0126], %r27
	.word 0xf71c214d  ! 9911: LDDF_I	ldd	[%r16, 0x014d], %f27
	.word 0xfa0de09b  ! 9913: LDUB_I	ldub	[%r23 + 0x009b], %r29
	.word 0xb225605d  ! 9917: SUB_I	sub 	%r21, 0x005d, %r25
	.word 0xfa5c2057  ! 9918: LDX_I	ldx	[%r16 + 0x0057], %r29
hwintr_2_467:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_467), 16, 16)) -> intp(2, 0, a)
	.word 0xf25d4000  ! 9922: LDX_R	ldx	[%r21 + %r0], %r25
	.word 0xbf480000  ! 9924: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xb350c000  ! 9925: RDPR_TT	<illegal instruction>
	mov	0, %r14
	.word 0xa193a000  ! 9934: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb6b561f7  ! 9941: SUBCcc_I	orncc 	%r21, 0x01f7, %r27
hwintr_2_468:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_468), 16, 16)) -> intp(2, 0, 34)
	setx	data_start_0, %g1, %r19
	ta	T_CHANGE_HPRIV
	mov	0x38, %g1
	stxa	%r19, [%g1] 0x58
	ta	T_CHANGE_NONHPRIV
	.word 0xf64c215b  ! 9946: LDSB_I	ldsb	[%r16 + 0x015b], %r27
hwintr_2_469:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_469), 16, 16)) -> intp(2, 0, 28)
	.word 0xb1504000  ! 9952: RDPR_TNPC	rdpr	%tnpc, %r24
	.word 0xf00d20d0  ! 9958: LDUB_I	ldub	[%r20 + 0x00d0], %r24
	.word 0xfe0cc000  ! 9962: LDUB_R	ldub	[%r19 + %r0], %r31
	.word 0xff1d0000  ! 9966: LDDF_R	ldd	[%r20, %r0], %f31
	.word 0x8d95e01f  ! 9968: WRPR_PSTATE_I	wrpr	%r23, 0x001f, %pstate
	.word 0xf71cc000  ! 9978: LDDF_R	ldd	[%r19, %r0], %f27
	.word 0xfe05e063  ! 9979: LDUW_I	lduw	[%r23 + 0x0063], %r31
	.word 0xf85ce1e9  ! 9981: LDX_I	ldx	[%r19 + 0x01e9], %r28
hwintr_2_470:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_470), 16, 16)) -> intp(2, 0, 12)
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xf61dc000  ! 9989: LDD_R	ldd	[%r23 + %r0], %r27
	.word 0xb0c5c000  ! 9990: ADDCcc_R	addccc 	%r23, %r0, %r24
hwintr_2_471:
!$EV trig_pc_d(2,expr(@VA(.MAIN.hwintr_2_471), 16, 16)) -> intp(2, 0, d)
	.word 0xf6140000  ! 9995: LDUH_R	lduh	[%r16 + %r0], %r27
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_1:
	.word 0xbda4c920  ! 2: FMULs	fmuls	%f19, %f0, %f30
	.word 0x8995a08a  ! 4: WRPR_TICK_I	wrpr	%r22, 0x008a, %tick
hwintr_1_0:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_0), 16, 16)) -> intp(1, 0, 0)
	.word 0xbfab8820  ! 17: FMOVPOS	fmovs	%fcc1, %f0, %f31
	.word 0xb3a58860  ! 18: FADDq	dis not found

	.word 0x9195e16f  ! 19: WRPR_PIL_I	wrpr	%r23, 0x016f, %pil
	.word 0x9195e16f  ! 20: WRPR_PIL_I	wrpr	%r23, 0x016f, %pil
	.word 0xb3a80820  ! 22: FMOVRLEZ	fmovs	%fcc1, %f0, %f25
	.word 0xb3a40940  ! 24: FMULd	fmuld	%f16, %f0, %f56
hwintr_1_1:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_1), 16, 16)) -> intp(1, 0, 3e)
	.word 0xb1a8c820  ! 29: FMOVL	fmovs	%fcc1, %f0, %f24
	.word 0xb3a00040  ! 30: FMOVd	fmovd	%f0, %f56
	.word 0xb5a88820  ! 31: FMOVLE	fmovs	%fcc1, %f0, %f26
hwintr_1_2:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_2), 16, 16)) -> intp(1, 0, 1d)
	.word 0xb1518000  ! 35: RDPR_PSTATE	<illegal instruction>
	.word 0xb3520000  ! 36: RDPR_PIL	<illegal instruction>
	.word 0xb81c0000  ! 39: XOR_R	xor 	%r16, %r0, %r28
	.word 0xb43cc000  ! 41: XNOR_R	xnor 	%r19, %r0, %r26
	.word 0xbda00560  ! 43: FSQRTq	fsqrt	
	.word 0xbba548c0  ! 44: FSUBd	fsubd	%f52, %f0, %f60
	.word 0xb9a00560  ! 46: FSQRTq	fsqrt	
	.word 0x8395607f  ! 50: WRPR_TNPC_I	wrpr	%r21, 0x007f, %tnpc
	.word 0xb3aa4820  ! 51: FMOVNE	fmovs	%fcc1, %f0, %f25
	.word 0xbbab0820  ! 54: FMOVGU	fmovs	%fcc1, %f0, %f29
	.word 0xbbab4820  ! 55: FMOVCC	fmovs	%fcc1, %f0, %f29
	.word 0xb1a409c0  ! 63: FDIVd	fdivd	%f16, %f0, %f24
	.word 0xbba509a0  ! 69: FDIVs	fdivs	%f20, %f0, %f29
	.word 0xbba00560  ! 72: FSQRTq	fsqrt	
	.word 0xb20521f6  ! 76: ADD_I	add 	%r20, 0x01f6, %r25
hwintr_1_3:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_3), 16, 16)) -> intp(1, 0, 32)
	.word 0xb5641800  ! 80: MOVcc_R	<illegal instruction>
	.word 0xbfa90820  ! 81: FMOVLEU	fmovs	%fcc1, %f0, %f31
	.word 0xb9aa8820  ! 84: FMOVG	fmovs	%fcc1, %f0, %f28
	.word 0xbda80420  ! 86: FMOVRZ	dis not found

	.word 0xb7a90820  ! 91: FMOVLEU	fmovs	%fcc1, %f0, %f27
	.word 0xb5a4c9c0  ! 94: FDIVd	fdivd	%f50, %f0, %f26
	.word 0xbfa00560  ! 97: FSQRTq	fsqrt	
	.word 0x899521e2  ! 98: WRPR_TICK_I	wrpr	%r20, 0x01e2, %tick
	.word 0xb951c000  ! 102: RDPR_TL	<illegal instruction>
	.word 0xb550c000  ! 106: RDPR_TT	<illegal instruction>
	.word 0xbda81c20  ! 108: FMOVRGEZ	dis not found

	.word 0xb3a00020  ! 109: FMOVs	fmovs	%f0, %f25
	.word 0xbf510000  ! 112: RDPR_TICK	<illegal instruction>
	.word 0xb9a4c820  ! 116: FADDs	fadds	%f19, %f0, %f28
hwintr_1_4:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_4), 16, 16)) -> intp(1, 0, 3e)
	.word 0x8594a166  ! 123: WRPR_TSTATE_I	wrpr	%r18, 0x0166, %tstate
	.word 0xb83cc000  ! 125: XNOR_R	xnor 	%r19, %r0, %r28
	.word 0xbc44e1f6  ! 126: ADDC_I	addc 	%r19, 0x01f6, %r30
	.word 0xbda80420  ! 129: FMOVRZ	dis not found

	mov	0, %r12
	.word 0x8f932000  ! 130: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_1_5:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_5), 16, 16)) -> intp(1, 0, 1f)
	.word 0xb2bda139  ! 136: XNORcc_I	xnorcc 	%r22, 0x0139, %r25
	.word 0xbda50960  ! 137: FMULq	dis not found

	.word 0x879421f4  ! 141: WRPR_TT_I	wrpr	%r16, 0x01f4, %tt
	.word 0xbba549c0  ! 142: FDIVd	fdivd	%f52, %f0, %f60
	.word 0xb29c20da  ! 143: XORcc_I	xorcc 	%r16, 0x00da, %r25
	.word 0xb8c44000  ! 146: ADDCcc_R	addccc 	%r17, %r0, %r28
	.word 0xb9a81820  ! 151: FMOVRGZ	fmovs	%fcc3, %f0, %f28
	.word 0xbda80820  ! 154: FMOVN	fmovs	%fcc1, %f0, %f30
	.word 0xb1a90820  ! 155: FMOVLEU	fmovs	%fcc1, %f0, %f24
	.word 0xb5a94820  ! 156: FMOVCS	fmovs	%fcc1, %f0, %f26
	.word 0xb9a58920  ! 158: FMULs	fmuls	%f22, %f0, %f28
	.word 0xb63561a8  ! 162: SUBC_I	orn 	%r21, 0x01a8, %r27
	.word 0x8795e015  ! 163: WRPR_TT_I	wrpr	%r23, 0x0015, %tt
	.word 0xb0bc4000  ! 169: XNORcc_R	xnorcc 	%r17, %r0, %r24
	.word 0xb835610d  ! 170: ORN_I	orn 	%r21, 0x010d, %r28
	.word 0xb1510000  ! 172: RDPR_TICK	<illegal instruction>
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xbd500000  ! 174: RDPR_TPC	<illegal instruction>
	.word 0xba248000  ! 175: SUB_R	sub 	%r18, %r0, %r29
	.word 0xb9aa0820  ! 179: FMOVA	fmovs	%fcc1, %f0, %f28
	.word 0x8194204a  ! 180: WRPR_TPC_I	wrpr	%r16, 0x004a, %tpc
hwintr_1_6:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_6), 16, 16)) -> intp(1, 0, 23)
	.word 0xbda00020  ! 185: FMOVs	fmovs	%f0, %f30
	.word 0xbfa58940  ! 191: FMULd	fmuld	%f22, %f0, %f62
	.word 0xb1ab8820  ! 192: FMOVPOS	fmovs	%fcc1, %f0, %f24
hwintr_1_7:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_7), 16, 16)) -> intp(1, 0, 35)
	.word 0xb5a488a0  ! 201: FSUBs	fsubs	%f18, %f0, %f26
	.word 0xbdaa0820  ! 205: FMOVA	fmovs	%fcc1, %f0, %f30
hwintr_1_8:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_8), 16, 16)) -> intp(1, 0, 8)
	.word 0xb13cc000  ! 211: SRA_R	sra 	%r19, %r0, %r24
	.word 0xb1a94820  ! 214: FMOVCS	fmovs	%fcc1, %f0, %f24
	.word 0x8594a098  ! 215: WRPR_TSTATE_I	wrpr	%r18, 0x0098, %tstate
	.word 0xb5a90820  ! 219: FMOVLEU	fmovs	%fcc1, %f0, %f26
	.word 0x819461d1  ! 221: WRPR_TPC_I	wrpr	%r17, 0x01d1, %tpc
hwintr_1_9:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_9), 16, 16)) -> intp(1, 0, 26)
	.word 0xb5a44820  ! 227: FADDs	fadds	%f17, %f0, %f26
	.word 0xbda44940  ! 228: FMULd	fmuld	%f48, %f0, %f30
	.word 0xb150c000  ! 229: RDPR_TT	<illegal instruction>
hwintr_1_10:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_10), 16, 16)) -> intp(1, 0, d)
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xbba489c0  ! 237: FDIVd	fdivd	%f18, %f0, %f60
	.word 0xb3508000  ! 238: RDPR_TSTATE	<illegal instruction>
hwintr_1_11:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_11), 16, 16)) -> intp(1, 0, 3a)
	ldda	[%r16 + %g0] 0xf0, %f2
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xb9a00560  ! 247: FSQRTq	fsqrt	
	mov	2, %r14
	.word 0xa193a000  ! 254: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9a448c0  ! 255: FSUBd	fsubd	%f48, %f0, %f28
	.word 0x8794a128  ! 256: WRPR_TT_I	wrpr	%r18, 0x0128, %tt
	mov	2, %r14
	.word 0xa193a000  ! 257: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbba40820  ! 259: FADDs	fadds	%f16, %f0, %f29
	.word 0xb1a4c920  ! 261: FMULs	fmuls	%f19, %f0, %f24
	.word 0xb1a5c820  ! 262: FADDs	fadds	%f23, %f0, %f24
hwintr_1_12:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_12), 16, 16)) -> intp(1, 0, 26)
hwintr_1_13:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_13), 16, 16)) -> intp(1, 0, 17)
	.word 0x8795e1d8  ! 266: WRPR_TT_I	wrpr	%r23, 0x01d8, %tt
	.word 0xbb50c000  ! 270: RDPR_TT	<illegal instruction>
	.word 0xb3a5c9a0  ! 271: FDIVs	fdivs	%f23, %f0, %f25
	.word 0x81952006  ! 272: WRPR_TPC_I	wrpr	%r20, 0x0006, %tpc
	.word 0xb5a50940  ! 277: FMULd	fmuld	%f20, %f0, %f26
	.word 0xb3a58920  ! 278: FMULs	fmuls	%f22, %f0, %f25
	.word 0xb7500000  ! 280: RDPR_TPC	<illegal instruction>
	.word 0xb9a408e0  ! 281: FSUBq	dis not found

	.word 0xbba8c820  ! 282: FMOVL	fmovs	%fcc1, %f0, %f29
	mov	1, %r14
	.word 0xa193a000  ! 287: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbfab8820  ! 291: FMOVPOS	fmovs	%fcc1, %f0, %f31
	ta	T_CHANGE_HPRIV
	.word 0x81983e91  ! 295: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e91, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81983e9b  ! 299: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e9b, %hpstate
	.word 0xb414c000  ! 301: OR_R	or 	%r19, %r0, %r26
	.word 0xb80d60c3  ! 304: AND_I	and 	%r21, 0x00c3, %r28
	.word 0xbf51c000  ! 305: RDPR_TL	<illegal instruction>
	.word 0xbd510000  ! 306: RDPR_TICK	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x8198398b  ! 309: WRHPR_HPSTATE_I	wrhpr	%r0, 0x198b, %hpstate
	.word 0xb9a48860  ! 314: FADDq	dis not found

	.word 0xb9500000  ! 315: RDPR_TPC	<illegal instruction>
	.word 0xbeb50000  ! 316: ORNcc_R	orncc 	%r20, %r0, %r31
	.word 0xb151c000  ! 320: RDPR_TL	<illegal instruction>
	.word 0xbe458000  ! 321: ADDC_R	addc 	%r22, %r0, %r31
	.word 0xb9aa0820  ! 324: FMOVA	fmovs	%fcc1, %f0, %f28
	.word 0x8195201e  ! 325: WRPR_TPC_I	wrpr	%r20, 0x001e, %tpc
	.word 0xb1a80820  ! 329: FMOVN	fmovs	%fcc1, %f0, %f24
hwintr_1_14:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_14), 16, 16)) -> intp(1, 0, 37)
	.word 0xbda54860  ! 332: FADDq	dis not found

	.word 0xbba81420  ! 334: FMOVRNZ	dis not found

	.word 0xbba5c940  ! 339: FMULd	fmuld	%f54, %f0, %f60
hwintr_1_15:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_15), 16, 16)) -> intp(1, 0, 15)
	.word 0xb41c2066  ! 342: XOR_I	xor 	%r16, 0x0066, %r26
	.word 0xb9aa0820  ! 351: FMOVA	fmovs	%fcc1, %f0, %f28
	.word 0xb951c000  ! 353: RDPR_TL	<illegal instruction>
	.word 0xbc15208d  ! 354: OR_I	or 	%r20, 0x008d, %r30
	.word 0xb5a90820  ! 356: FMOVLEU	fmovs	%fcc1, %f0, %f26
	.word 0xb7aa0820  ! 358: FMOVA	fmovs	%fcc1, %f0, %f27
	.word 0xbe0da018  ! 359: AND_I	and 	%r22, 0x0018, %r31
	.word 0xbfaac820  ! 360: FMOVGE	fmovs	%fcc1, %f0, %f31
hwintr_1_16:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_16), 16, 16)) -> intp(1, 0, 8)
	.word 0x8d94218c  ! 364: WRPR_PSTATE_I	wrpr	%r16, 0x018c, %pstate
	.word 0xb3a409a0  ! 365: FDIVs	fdivs	%f16, %f0, %f25
	.word 0xbba81820  ! 367: FMOVRGZ	fmovs	%fcc3, %f0, %f29
	.word 0xb77c8400  ! 370: MOVR_R	movre	%r18, %r0, %r27
	.word 0xb9a84820  ! 377: FMOVE	fmovs	%fcc1, %f0, %f28
	.word 0xbfa58940  ! 381: FMULd	fmuld	%f22, %f0, %f62
	.word 0xbb518000  ! 384: RDPR_PSTATE	<illegal instruction>
	.word 0xb9aa0820  ! 385: FMOVA	fmovs	%fcc1, %f0, %f28
	.word 0xb7ab0820  ! 388: FMOVGU	fmovs	%fcc1, %f0, %f27
	.word 0xb951c000  ! 391: RDPR_TL	<illegal instruction>
	.word 0xb7a81c20  ! 395: FMOVRGEZ	dis not found

	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xb7a84820  ! 403: FMOVE	fmovs	%fcc1, %f0, %f27
	.word 0xb92dc000  ! 405: SLL_R	sll 	%r23, %r0, %r28
	.word 0xb3a8c820  ! 406: FMOVL	fmovs	%fcc1, %f0, %f25
	.word 0xb1a84820  ! 409: FMOVE	fmovs	%fcc1, %f0, %f24
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xbba4c8c0  ! 413: FSUBd	fsubd	%f50, %f0, %f60
	.word 0xb3a81420  ! 417: FMOVRNZ	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x81983d81  ! 418: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d81, %hpstate
	.word 0x8595201b  ! 419: WRPR_TSTATE_I	wrpr	%r20, 0x001b, %tstate
	.word 0xbda44840  ! 423: FADDd	faddd	%f48, %f0, %f30
	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xb5a88820  ! 427: FMOVLE	fmovs	%fcc1, %f0, %f26
	.word 0x859421d9  ! 429: WRPR_TSTATE_I	wrpr	%r16, 0x01d9, %tstate
	.word 0xb7a5c860  ! 432: FADDq	dis not found

	.word 0xb3a48840  ! 433: FADDd	faddd	%f18, %f0, %f56
	.word 0xbd510000  ! 436: RDPR_TICK	<illegal instruction>
	.word 0xb5a00520  ! 438: FSQRTs	fsqrt	
	.word 0xb5a00560  ! 439: FSQRTq	fsqrt	
	.word 0xb2258000  ! 440: SUB_R	sub 	%r22, %r0, %r25
	.word 0xb5ab8820  ! 443: FMOVPOS	fmovs	%fcc1, %f0, %f26
	.word 0xbda80420  ! 445: FMOVRZ	dis not found

	.word 0xb7a448a0  ! 447: FSUBs	fsubs	%f17, %f0, %f27
	.word 0xb7a40940  ! 448: FMULd	fmuld	%f16, %f0, %f58
	mov	2, %r12
	.word 0x8f932000  ! 450: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb57d8400  ! 451: MOVR_R	movre	%r22, %r0, %r26
	.word 0xbbaa0820  ! 453: FMOVA	fmovs	%fcc1, %f0, %f29
	.word 0xb5a50860  ! 457: FADDq	dis not found

	.word 0xb9510000  ! 458: RDPR_TICK	<illegal instruction>
	.word 0xb7a589a0  ! 459: FDIVs	fdivs	%f22, %f0, %f27
	.word 0xbda90820  ! 460: FMOVLEU	fmovs	%fcc1, %f0, %f30
	.word 0xb150c000  ! 468: RDPR_TT	<illegal instruction>
	.word 0xb9a00020  ! 476: FMOVs	fmovs	%f0, %f28
	.word 0xbd520000  ! 481: RDPR_PIL	<illegal instruction>
	.word 0xb2b50000  ! 482: SUBCcc_R	orncc 	%r20, %r0, %r25
	.word 0xb351c000  ! 487: RDPR_TL	<illegal instruction>
	.word 0xbda58940  ! 488: FMULd	fmuld	%f22, %f0, %f30
	.word 0xb5a84820  ! 490: FMOVE	fmovs	%fcc1, %f0, %f26
	.word 0xb3abc820  ! 491: FMOVVC	fmovs	%fcc1, %f0, %f25
	ta	T_CHANGE_HPRIV
	.word 0x81983c5b  ! 494: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c5b, %hpstate
	.word 0xbf480000  ! 496: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xb1a81820  ! 501: FMOVRGZ	fmovs	%fcc3, %f0, %f24
	.word 0xbfaac820  ! 503: FMOVGE	fmovs	%fcc1, %f0, %f31
	.word 0xb5500000  ! 505: RDPR_TPC	<illegal instruction>
	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xb9518000  ! 513: RDPR_PSTATE	<illegal instruction>
	.word 0xb5aa0820  ! 516: FMOVA	fmovs	%fcc1, %f0, %f26
	.word 0xb1aa0820  ! 522: FMOVA	fmovs	%fcc1, %f0, %f24
	.word 0xbf50c000  ! 524: RDPR_TT	<illegal instruction>
	.word 0xb9ab4820  ! 525: FMOVCC	fmovs	%fcc1, %f0, %f28
	.word 0xb3540000  ! 527: RDPR_GL	<illegal instruction>
	.word 0x8594e050  ! 530: WRPR_TSTATE_I	wrpr	%r19, 0x0050, %tstate
	.word 0xb77d0400  ! 531: MOVR_R	movre	%r20, %r0, %r27
	.word 0xb3480000  ! 532: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xb0ac0000  ! 536: ANDNcc_R	andncc 	%r16, %r0, %r24
hwintr_1_17:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_17), 16, 16)) -> intp(1, 0, 1a)
	.word 0xba8ce0bd  ! 538: ANDcc_I	andcc 	%r19, 0x00bd, %r29
hwintr_1_18:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_18), 16, 16)) -> intp(1, 0, 15)
	.word 0xb9a81420  ! 541: FMOVRNZ	dis not found

	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xb950c000  ! 548: RDPR_TT	<illegal instruction>
	.word 0xb951c000  ! 549: RDPR_TL	<illegal instruction>
	.word 0xb32c2001  ! 550: SLL_I	sll 	%r16, 0x0001, %r25
	.word 0xbba84820  ! 551: FMOVE	fmovs	%fcc1, %f0, %f29
	.word 0xb1ab4820  ! 558: FMOVCC	fmovs	%fcc1, %f0, %f24
	.word 0xb1540000  ! 559: RDPR_GL	<illegal instruction>
	.word 0xb5a88820  ! 560: FMOVLE	fmovs	%fcc1, %f0, %f26
	.word 0xbe250000  ! 561: SUB_R	sub 	%r20, %r0, %r31
	.word 0xbf508000  ! 564: RDPR_TSTATE	<illegal instruction>
	.word 0x9195a054  ! 565: WRPR_PIL_I	wrpr	%r22, 0x0054, %pil
	.word 0xb1a5c820  ! 566: FADDs	fadds	%f23, %f0, %f24
	ta	T_CHANGE_HPRIV
	.word 0x81982c49  ! 567: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c49, %hpstate
	.word 0xb7a00040  ! 568: FMOVd	fmovd	%f0, %f58
	.word 0xb7a4c8a0  ! 573: FSUBs	fsubs	%f19, %f0, %f27
	.word 0xb3a509a0  ! 576: FDIVs	fdivs	%f20, %f0, %f25
	.word 0xbba00540  ! 577: FSQRTd	fsqrt	
	.word 0xb9a81c20  ! 578: FMOVRGEZ	dis not found

hwintr_1_19:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_19), 16, 16)) -> intp(1, 0, 38)
	.word 0xb9a88820  ! 581: FMOVLE	fmovs	%fcc1, %f0, %f28
	.word 0xbba488a0  ! 583: FSUBs	fsubs	%f18, %f0, %f29
	.word 0xbfa50820  ! 588: FADDs	fadds	%f20, %f0, %f31
	mov	0, %r14
	.word 0xa193a000  ! 594: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_1_20:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_20), 16, 16)) -> intp(1, 0, 5)
hwintr_1_21:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_21), 16, 16)) -> intp(1, 0, 2e)
hwintr_1_22:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_22), 16, 16)) -> intp(1, 0, c)
	.word 0xb3a448c0  ! 600: FSUBd	fsubd	%f48, %f0, %f56
	.word 0xbfa80420  ! 603: FMOVRZ	dis not found

	.word 0xb7520000  ! 605: RDPR_PIL	<illegal instruction>
	.word 0xb9a81420  ! 607: FMOVRNZ	dis not found

	.word 0x8994e133  ! 608: WRPR_TICK_I	wrpr	%r19, 0x0133, %tick
	.word 0xb644c000  ! 609: ADDC_R	addc 	%r19, %r0, %r27
	.word 0xb5a44920  ! 610: FMULs	fmuls	%f17, %f0, %f26
	.word 0xbfa00540  ! 611: FSQRTd	fsqrt	
hwintr_1_23:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_23), 16, 16)) -> intp(1, 0, 32)
	.word 0xb61c2015  ! 614: XOR_I	xor 	%r16, 0x0015, %r27
	.word 0xbba88820  ! 618: FMOVLE	fmovs	%fcc1, %f0, %f29
	mov	2, %r12
	.word 0x8f932000  ! 620: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb1a00540  ! 623: FSQRTd	fsqrt	
	.word 0xb2044000  ! 631: ADD_R	add 	%r17, %r0, %r25
	.word 0xb62c6120  ! 633: ANDN_I	andn 	%r17, 0x0120, %r27
	.word 0x8d94e058  ! 634: WRPR_PSTATE_I	wrpr	%r19, 0x0058, %pstate
	ta	T_CHANGE_HPRIV
	.word 0x81982dc9  ! 635: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dc9, %hpstate
	.word 0xb5ab4820  ! 636: FMOVCC	fmovs	%fcc1, %f0, %f26
	ldda	[%r16 + %g0] 0xf0, %f2
	mov	0, %r14
	.word 0xa193a000  ! 645: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x839561bc  ! 646: WRPR_TNPC_I	wrpr	%r21, 0x01bc, %tnpc
	.word 0xbaad8000  ! 648: ANDNcc_R	andncc 	%r22, %r0, %r29
	.word 0xb5a00560  ! 650: FSQRTq	fsqrt	
	.word 0xb9aa4820  ! 651: FMOVNE	fmovs	%fcc1, %f0, %f28
	.word 0xbba84820  ! 657: FMOVE	fmovs	%fcc1, %f0, %f29
	.word 0xb3a50860  ! 659: FADDq	dis not found

	.word 0xbba448e0  ! 664: FSUBq	dis not found

	.word 0x899420a0  ! 668: WRPR_TICK_I	wrpr	%r16, 0x00a0, %tick
	.word 0xbbaa4820  ! 677: FMOVNE	fmovs	%fcc1, %f0, %f29
	.word 0xb751c000  ! 678: RDPR_TL	<illegal instruction>
	.word 0xb7a48860  ! 681: FADDq	dis not found

	.word 0xbaace03a  ! 682: ANDNcc_I	andncc 	%r19, 0x003a, %r29
	.word 0xbba80420  ! 684: FMOVRZ	dis not found

	.word 0xb9a589c0  ! 685: FDIVd	fdivd	%f22, %f0, %f28
	.word 0xbda80c20  ! 687: FMOVRLZ	dis not found

	.word 0xbda84820  ! 689: FMOVE	fmovs	%fcc1, %f0, %f30
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xb7a00540  ! 691: FSQRTd	fsqrt	
	.word 0xb6a5c000  ! 694: SUBcc_R	subcc 	%r23, %r0, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982e03  ! 695: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e03, %hpstate
	.word 0xb3540000  ! 698: RDPR_GL	<illegal instruction>
hwintr_1_24:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_24), 16, 16)) -> intp(1, 0, f)
	.word 0xb5a00520  ! 701: FSQRTs	fsqrt	
	.word 0xb1a00520  ! 705: FSQRTs	fsqrt	
	ta	T_CHANGE_HPRIV
	.word 0x81983d03  ! 706: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d03, %hpstate
	.word 0xb9a40820  ! 707: FADDs	fadds	%f16, %f0, %f28
hwintr_1_25:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_25), 16, 16)) -> intp(1, 0, 2a)
	.word 0xb5a409e0  ! 712: FDIVq	dis not found

	.word 0xbda488e0  ! 716: FSUBq	dis not found

	.word 0xb5a00040  ! 717: FMOVd	fmovd	%f0, %f26
	.word 0x879421df  ! 718: WRPR_TT_I	wrpr	%r16, 0x01df, %tt
	.word 0xb3a408c0  ! 719: FSUBd	fsubd	%f16, %f0, %f56
hwintr_1_26:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_26), 16, 16)) -> intp(1, 0, 1)
	.word 0xb7a5c840  ! 724: FADDd	faddd	%f54, %f0, %f58
	.word 0xba2d21fd  ! 725: ANDN_I	andn 	%r20, 0x01fd, %r29
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
hwintr_1_27:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_27), 16, 16)) -> intp(1, 0, 24)
	.word 0xb9a58820  ! 735: FADDs	fadds	%f22, %f0, %f28
	.word 0xb350c000  ! 738: RDPR_TT	<illegal instruction>
	.word 0xb2c4c000  ! 739: ADDCcc_R	addccc 	%r19, %r0, %r25
hwintr_1_28:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_28), 16, 16)) -> intp(1, 0, a)
hwintr_1_29:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_29), 16, 16)) -> intp(1, 0, 2f)
	ldda	[%r16 + %g0] 0xf0, %f2
hwintr_1_30:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_30), 16, 16)) -> intp(1, 0, 16)
hwintr_1_31:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_31), 16, 16)) -> intp(1, 0, 5)
hwintr_1_32:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_32), 16, 16)) -> intp(1, 0, 3f)
	.word 0xb9a00520  ! 750: FSQRTs	fsqrt	
	.word 0xbfa00560  ! 756: FSQRTq	fsqrt	
	.word 0xb3a90820  ! 761: FMOVLEU	fmovs	%fcc1, %f0, %f25
	.word 0x8394218a  ! 762: WRPR_TNPC_I	wrpr	%r16, 0x018a, %tnpc
	.word 0xbba5c820  ! 764: FADDs	fadds	%f23, %f0, %f29
hwintr_1_33:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_33), 16, 16)) -> intp(1, 0, 11)
	.word 0xb3500000  ! 768: RDPR_TPC	<illegal instruction>
	.word 0xbfa00040  ! 771: FMOVd	fmovd	%f0, %f62
	.word 0xb1a5c960  ! 773: FMULq	dis not found

	.word 0xb7518000  ! 774: RDPR_PSTATE	<illegal instruction>
	.word 0x839560df  ! 776: WRPR_TNPC_I	wrpr	%r21, 0x00df, %tnpc
	.word 0xb9520000  ! 784: RDPR_PIL	<illegal instruction>
	.word 0xb3a48820  ! 789: FADDs	fadds	%f18, %f0, %f25
	.word 0xb2bda192  ! 790: XNORcc_I	xnorcc 	%r22, 0x0192, %r25
	.word 0xb845a03a  ! 792: ADDC_I	addc 	%r22, 0x003a, %r28
hwintr_1_34:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_34), 16, 16)) -> intp(1, 0, 36)
	.word 0xb1ab4820  ! 797: FMOVCC	fmovs	%fcc1, %f0, %f24
	.word 0xb3a00520  ! 800: FSQRTs	fsqrt	
	.word 0xbba4c8a0  ! 802: FSUBs	fsubs	%f19, %f0, %f29
	.word 0xbfa00560  ! 806: FSQRTq	fsqrt	
	.word 0xbba54940  ! 807: FMULd	fmuld	%f52, %f0, %f60
	.word 0xb5aa8820  ! 808: FMOVG	fmovs	%fcc1, %f0, %f26
	.word 0xbfa84820  ! 811: FMOVE	fmovs	%fcc1, %f0, %f31
	.word 0xb69d4000  ! 812: XORcc_R	xorcc 	%r21, %r0, %r27
	.word 0xb5aac820  ! 813: FMOVGE	fmovs	%fcc1, %f0, %f26
	ldda	[%r16 + %g0] 0xf0, %f2
	ta	T_CHANGE_HPRIV
	.word 0x81982a5b  ! 818: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a5b, %hpstate
	.word 0xb9aac820  ! 821: FMOVGE	fmovs	%fcc1, %f0, %f28
	.word 0xb64520a7  ! 830: ADDC_I	addc 	%r20, 0x00a7, %r27
hwintr_1_35:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_35), 16, 16)) -> intp(1, 0, f)
	.word 0xb835a0bc  ! 833: SUBC_I	orn 	%r22, 0x00bc, %r28
	.word 0xbbab4820  ! 838: FMOVCC	fmovs	%fcc1, %f0, %f29
	.word 0xbba40840  ! 839: FADDd	faddd	%f16, %f0, %f60
	.word 0xb1a449c0  ! 840: FDIVd	fdivd	%f48, %f0, %f24
	.word 0xb42d4000  ! 842: ANDN_R	andn 	%r21, %r0, %r26
hwintr_1_36:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_36), 16, 16)) -> intp(1, 0, 1e)
	.word 0xb1a81820  ! 856: FMOVRGZ	fmovs	%fcc3, %f0, %f24
	.word 0x8d95e16b  ! 860: WRPR_PSTATE_I	wrpr	%r23, 0x016b, %pstate
	.word 0xb884c000  ! 862: ADDcc_R	addcc 	%r19, %r0, %r28
	.word 0x8994a14e  ! 866: WRPR_TICK_I	wrpr	%r18, 0x014e, %tick
	.word 0xbebc8000  ! 872: XNORcc_R	xnorcc 	%r18, %r0, %r31
	.word 0xb7a81420  ! 874: FMOVRNZ	dis not found

	.word 0xbdaa4820  ! 877: FMOVNE	fmovs	%fcc1, %f0, %f30
	mov	2, %r12
	.word 0x8f932000  ! 878: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb9a54960  ! 880: FMULq	dis not found

hwintr_1_37:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_37), 16, 16)) -> intp(1, 0, 1)
	.word 0xb7a508c0  ! 882: FSUBd	fsubd	%f20, %f0, %f58
	.word 0xbda448c0  ! 883: FSUBd	fsubd	%f48, %f0, %f30
	.word 0xb5a00560  ! 885: FSQRTq	fsqrt	
	.word 0xb551c000  ! 886: RDPR_TL	<illegal instruction>
	.word 0xbfa00040  ! 887: FMOVd	fmovd	%f0, %f62
	.word 0xb3a00040  ! 889: FMOVd	fmovd	%f0, %f56
	.word 0x8194a14a  ! 891: WRPR_TPC_I	wrpr	%r18, 0x014a, %tpc
	.word 0xb4c5e0e2  ! 893: ADDCcc_I	addccc 	%r23, 0x00e2, %r26
	mov	2, %r12
	.word 0x8f932000  ! 896: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb5aa4820  ! 899: FMOVNE	fmovs	%fcc1, %f0, %f26
	.word 0xbf518000  ! 901: RDPR_PSTATE	<illegal instruction>
	.word 0xb9a81c20  ! 902: FMOVRGEZ	dis not found

	.word 0xbba00020  ! 905: FMOVs	fmovs	%f0, %f29
	.word 0xb7a94820  ! 906: FMOVCS	fmovs	%fcc1, %f0, %f27
	.word 0xbb2c0000  ! 907: SLL_R	sll 	%r16, %r0, %r29
	.word 0x83956168  ! 912: WRPR_TNPC_I	wrpr	%r21, 0x0168, %tnpc
	.word 0xb29420d9  ! 913: ORcc_I	orcc 	%r16, 0x00d9, %r25
	.word 0xbba5c8c0  ! 914: FSUBd	fsubd	%f54, %f0, %f60
	.word 0xb3a50860  ! 915: FADDq	dis not found

	.word 0xb68de024  ! 916: ANDcc_I	andcc 	%r23, 0x0024, %r27
	.word 0xbb500000  ! 918: RDPR_TPC	<illegal instruction>
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xb3a00020  ! 923: FMOVs	fmovs	%f0, %f25
	.word 0xbd508000  ! 927: RDPR_TSTATE	<illegal instruction>
	.word 0xb150c000  ! 929: RDPR_TT	<illegal instruction>
	.word 0xb6a54000  ! 934: SUBcc_R	subcc 	%r21, %r0, %r27
	.word 0xbbaa0820  ! 936: FMOVA	fmovs	%fcc1, %f0, %f29
	.word 0xbda00020  ! 939: FMOVs	fmovs	%f0, %f30
	.word 0xb550c000  ! 940: RDPR_TT	<illegal instruction>
hwintr_1_38:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_38), 16, 16)) -> intp(1, 0, 5)
	.word 0xbfa98820  ! 944: FMOVNEG	fmovs	%fcc1, %f0, %f31
	.word 0xb5a00520  ! 952: FSQRTs	fsqrt	
hwintr_1_39:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_39), 16, 16)) -> intp(1, 0, d)
	ta	T_CHANGE_HPRIV
	.word 0x81982d11  ! 955: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d11, %hpstate
	.word 0xbfa00020  ! 957: FMOVs	fmovs	%f0, %f31
	.word 0xbd51c000  ! 958: RDPR_TL	<illegal instruction>
	.word 0xbba5c8a0  ! 960: FSUBs	fsubs	%f23, %f0, %f29
	.word 0xbda8c820  ! 961: FMOVL	fmovs	%fcc1, %f0, %f30
	.word 0x8d9560f1  ! 962: WRPR_PSTATE_I	wrpr	%r21, 0x00f1, %pstate
	.word 0xbba58820  ! 963: FADDs	fadds	%f22, %f0, %f29
	.word 0xb5a4c920  ! 964: FMULs	fmuls	%f19, %f0, %f26
	.word 0xb3a4c8e0  ! 966: FSUBq	dis not found

	.word 0xbe1dc000  ! 967: XOR_R	xor 	%r23, %r0, %r31
	.word 0xb9a94820  ! 969: FMOVCS	fmovs	%fcc1, %f0, %f28
	mov	2, %r14
	.word 0xa193a000  ! 973: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbfa81420  ! 974: FMOVRNZ	dis not found

	.word 0xbfa4c9c0  ! 975: FDIVd	fdivd	%f50, %f0, %f62
hwintr_1_40:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_40), 16, 16)) -> intp(1, 0, a)
	.word 0xb9a81c20  ! 978: FMOVRGEZ	dis not found

	.word 0xb9a508a0  ! 982: FSUBs	fsubs	%f20, %f0, %f28
hwintr_1_41:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_41), 16, 16)) -> intp(1, 0, 31)
	.word 0xb4944000  ! 984: ORcc_R	orcc 	%r17, %r0, %r26
	.word 0xb2b40000  ! 985: ORNcc_R	orncc 	%r16, %r0, %r25
	.word 0xb1a00520  ! 992: FSQRTs	fsqrt	
	.word 0xb7a5c8e0  ! 995: FSUBq	dis not found

	.word 0xb3a58960  ! 998: FMULq	dis not found

	.word 0xb3aac820  ! 999: FMOVGE	fmovs	%fcc1, %f0, %f25
	.word 0xb7a44960  ! 1000: FMULq	dis not found

	.word 0xb3a4c860  ! 1003: FADDq	dis not found

	.word 0xb3480000  ! 1004: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xb5a80420  ! 1005: FMOVRZ	dis not found

	.word 0xb1ab8820  ! 1007: FMOVPOS	fmovs	%fcc1, %f0, %f24
	.word 0xb73c0000  ! 1009: SRA_R	sra 	%r16, %r0, %r27
	.word 0xbbabc820  ! 1013: FMOVVC	fmovs	%fcc1, %f0, %f29
	.word 0xbda81420  ! 1014: FMOVRNZ	dis not found

	.word 0xb9a88820  ! 1017: FMOVLE	fmovs	%fcc1, %f0, %f28
	.word 0xb7a90820  ! 1022: FMOVLEU	fmovs	%fcc1, %f0, %f27
	.word 0xb1a5c940  ! 1024: FMULd	fmuld	%f54, %f0, %f24
hwintr_1_42:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_42), 16, 16)) -> intp(1, 0, 2f)
	.word 0xb7a549a0  ! 1036: FDIVs	fdivs	%f21, %f0, %f27
	.word 0xbda00540  ! 1037: FSQRTd	fsqrt	
	ta	T_CHANGE_HPRIV
	.word 0x81982a4b  ! 1039: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a4b, %hpstate
	.word 0xbbaa0820  ! 1040: FMOVA	fmovs	%fcc1, %f0, %f29
hwintr_1_43:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_43), 16, 16)) -> intp(1, 0, 21)
	.word 0xb3ab0820  ! 1042: FMOVGU	fmovs	%fcc1, %f0, %f25
	.word 0xb3ab0820  ! 1044: FMOVGU	fmovs	%fcc1, %f0, %f25
	.word 0xb5a448c0  ! 1045: FSUBd	fsubd	%f48, %f0, %f26
	.word 0xbfa98820  ! 1046: FMOVNEG	fmovs	%fcc1, %f0, %f31
	mov	2, %r12
	.word 0x8f932000  ! 1047: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x89952092  ! 1048: WRPR_TICK_I	wrpr	%r20, 0x0092, %tick
	.word 0xb9a508e0  ! 1051: FSUBq	dis not found

	.word 0xbf508000  ! 1052: RDPR_TSTATE	<illegal instruction>
	.word 0x8794a1b3  ! 1053: WRPR_TT_I	wrpr	%r18, 0x01b3, %tt
	.word 0xb3a80820  ! 1054: FMOVRLEZ	fmovs	%fcc1, %f0, %f25
	.word 0xb1a00520  ! 1055: FSQRTs	fsqrt	
	.word 0xbc950000  ! 1058: ORcc_R	orcc 	%r20, %r0, %r30
	.word 0xb4c54000  ! 1059: ADDCcc_R	addccc 	%r21, %r0, %r26
	.word 0xbb504000  ! 1060: RDPR_TNPC	<illegal instruction>
	.word 0xb9a44840  ! 1061: FADDd	faddd	%f48, %f0, %f28
	.word 0xb1518000  ! 1064: RDPR_PSTATE	<illegal instruction>
	.word 0x8195207d  ! 1065: WRPR_TPC_I	wrpr	%r20, 0x007d, %tpc
	.word 0xb1ab4820  ! 1066: FMOVCC	fmovs	%fcc1, %f0, %f24
	.word 0xb1a54940  ! 1067: FMULd	fmuld	%f52, %f0, %f24
	.word 0xbfa50820  ! 1069: FADDs	fadds	%f20, %f0, %f31
	.word 0x8d94e1f6  ! 1070: WRPR_PSTATE_I	wrpr	%r19, 0x01f6, %pstate
hwintr_1_44:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_44), 16, 16)) -> intp(1, 0, 36)
	.word 0xb7540000  ! 1072: RDPR_GL	<illegal instruction>
hwintr_1_45:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_45), 16, 16)) -> intp(1, 0, 37)
	.word 0x85956187  ! 1080: WRPR_TSTATE_I	wrpr	%r21, 0x0187, %tstate
	.word 0xb5a80420  ! 1082: FMOVRZ	dis not found

	.word 0xb3a98820  ! 1083: FMOVNEG	fmovs	%fcc1, %f0, %f25
	.word 0xb9a84820  ! 1085: FMOVE	fmovs	%fcc1, %f0, %f28
	.word 0xb5a81820  ! 1086: FMOVRGZ	fmovs	%fcc3, %f0, %f26
	.word 0xbd500000  ! 1088: RDPR_TPC	<illegal instruction>
	.word 0xbda40820  ! 1089: FADDs	fadds	%f16, %f0, %f30
hwintr_1_46:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_46), 16, 16)) -> intp(1, 0, 1e)
	.word 0xb9518000  ! 1092: RDPR_PSTATE	<illegal instruction>
	.word 0xb5a409e0  ! 1097: FDIVq	dis not found

	.word 0xb9a589e0  ! 1101: FDIVq	dis not found

	.word 0xb43ce03e  ! 1103: XNOR_I	xnor 	%r19, 0x003e, %r26
hwintr_1_47:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_47), 16, 16)) -> intp(1, 0, 8)
	.word 0x8594a1f5  ! 1106: WRPR_TSTATE_I	wrpr	%r18, 0x01f5, %tstate
	.word 0xbfa00560  ! 1109: FSQRTq	fsqrt	
	.word 0x8594601a  ! 1113: WRPR_TSTATE_I	wrpr	%r17, 0x001a, %tstate
	.word 0xb22ce1be  ! 1116: ANDN_I	andn 	%r19, 0x01be, %r25
	.word 0xbda489e0  ! 1122: FDIVq	dis not found

	.word 0xb9a94820  ! 1125: FMOVCS	fmovs	%fcc1, %f0, %f28
	.word 0xb1aa0820  ! 1126: FMOVA	fmovs	%fcc1, %f0, %f24
	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xba9de038  ! 1130: XORcc_I	xorcc 	%r23, 0x0038, %r29
	.word 0xb7a84820  ! 1134: FMOVE	fmovs	%fcc1, %f0, %f27
	.word 0xbfa00040  ! 1137: FMOVd	fmovd	%f0, %f62
	.word 0xb1a00540  ! 1139: FSQRTd	fsqrt	
	.word 0xb1a98820  ! 1143: FMOVNEG	fmovs	%fcc1, %f0, %f24
	.word 0xbba80c20  ! 1144: FMOVRLZ	dis not found

hwintr_1_48:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_48), 16, 16)) -> intp(1, 0, 3d)
	.word 0xb5a548e0  ! 1147: FSUBq	dis not found

	.word 0xb61d204c  ! 1149: XOR_I	xor 	%r20, 0x004c, %r27
	.word 0xbd510000  ! 1151: RDPR_TICK	<illegal instruction>
	.word 0xb3500000  ! 1152: RDPR_TPC	<illegal instruction>
	.word 0xb1510000  ! 1155: RDPR_TICK	<illegal instruction>
	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xb8ad8000  ! 1164: ANDNcc_R	andncc 	%r22, %r0, %r28
	.word 0xbd50c000  ! 1169: RDPR_TT	<illegal instruction>
	.word 0xb3a58920  ! 1170: FMULs	fmuls	%f22, %f0, %f25
	.word 0xb5a00560  ! 1172: FSQRTq	fsqrt	
	ta	T_CHANGE_HPRIV
	.word 0x81982bc3  ! 1173: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0bc3, %hpstate
	.word 0xb7a00020  ! 1174: FMOVs	fmovs	%f0, %f27
	.word 0xb9a00560  ! 1175: FSQRTq	fsqrt	
	.word 0xb6bda16c  ! 1176: XNORcc_I	xnorcc 	%r22, 0x016c, %r27
	.word 0xbda00560  ! 1183: FSQRTq	fsqrt	
	.word 0xbda80820  ! 1184: FMOVN	fmovs	%fcc1, %f0, %f30
	.word 0xb3a00540  ! 1185: FSQRTd	fsqrt	
	.word 0x839460b5  ! 1186: WRPR_TNPC_I	wrpr	%r17, 0x00b5, %tnpc
	.word 0xbfa48960  ! 1188: FMULq	dis not found

	.word 0xbda00540  ! 1189: FSQRTd	fsqrt	
	.word 0xb1508000  ! 1191: RDPR_TSTATE	<illegal instruction>
hwintr_1_49:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_49), 16, 16)) -> intp(1, 0, d)
	.word 0x8d9521a2  ! 1198: WRPR_PSTATE_I	wrpr	%r20, 0x01a2, %pstate
hwintr_1_50:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_50), 16, 16)) -> intp(1, 0, c)
hwintr_1_51:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_51), 16, 16)) -> intp(1, 0, 1f)
hwintr_1_52:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_52), 16, 16)) -> intp(1, 0, 27)
	.word 0xbba80820  ! 1207: FMOVN	fmovs	%fcc1, %f0, %f29
hwintr_1_53:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_53), 16, 16)) -> intp(1, 0, 2)
	.word 0xb9aac820  ! 1212: FMOVGE	fmovs	%fcc1, %f0, %f28
	.word 0xb1ab4820  ! 1213: FMOVCC	fmovs	%fcc1, %f0, %f24
	.word 0xb7aa0820  ! 1214: FMOVA	fmovs	%fcc1, %f0, %f27
	.word 0xbbaa0820  ! 1217: FMOVA	fmovs	%fcc1, %f0, %f29
	ta	T_CHANGE_HPRIV
	.word 0x81982e03  ! 1219: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e03, %hpstate
hwintr_1_54:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_54), 16, 16)) -> intp(1, 0, 2d)
	.word 0xbdab0820  ! 1221: FMOVGU	fmovs	%fcc1, %f0, %f30
	ta	T_CHANGE_HPRIV
	.word 0x81982cc3  ! 1223: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0cc3, %hpstate
	.word 0xbda94820  ! 1224: FMOVCS	fmovs	%fcc1, %f0, %f30
	.word 0xb7a84820  ! 1225: FMOVE	fmovs	%fcc1, %f0, %f27
hwintr_1_55:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_55), 16, 16)) -> intp(1, 0, 14)
	.word 0xb6b4e00a  ! 1235: SUBCcc_I	orncc 	%r19, 0x000a, %r27
	.word 0x8794e1c0  ! 1242: WRPR_TT_I	wrpr	%r19, 0x01c0, %tt
	.word 0xb7a00540  ! 1244: FSQRTd	fsqrt	
	.word 0xbfa8c820  ! 1245: FMOVL	fmovs	%fcc1, %f0, %f31
	ta	T_CHANGE_HPRIV
	.word 0x81983ad9  ! 1249: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1ad9, %hpstate
	.word 0xbfa589c0  ! 1251: FDIVd	fdivd	%f22, %f0, %f62
hwintr_1_56:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_56), 16, 16)) -> intp(1, 0, 23)
	.word 0xb1a80c20  ! 1261: FMOVRLZ	dis not found

	.word 0xb9500000  ! 1264: RDPR_TPC	<illegal instruction>
hwintr_1_57:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_57), 16, 16)) -> intp(1, 0, 1a)
	.word 0x8795a0f8  ! 1273: WRPR_TT_I	wrpr	%r22, 0x00f8, %tt
	.word 0x8994e106  ! 1274: WRPR_TICK_I	wrpr	%r19, 0x0106, %tick
	mov	1, %r14
	.word 0xa193a000  ! 1276: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_1_58:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_58), 16, 16)) -> intp(1, 0, 29)
hwintr_1_59:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_59), 16, 16)) -> intp(1, 0, 36)
hwintr_1_60:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_60), 16, 16)) -> intp(1, 0, 1f)
	.word 0xbba81c20  ! 1286: FMOVRGEZ	dis not found

	.word 0xbe458000  ! 1287: ADDC_R	addc 	%r22, %r0, %r31
	.word 0xb28c4000  ! 1289: ANDcc_R	andcc 	%r17, %r0, %r25
	.word 0xbda408c0  ! 1291: FSUBd	fsubd	%f16, %f0, %f30
	.word 0xbebc8000  ! 1292: XNORcc_R	xnorcc 	%r18, %r0, %r31
	.word 0xbda94820  ! 1296: FMOVCS	fmovs	%fcc1, %f0, %f30
	.word 0xb7641800  ! 1298: MOVcc_R	<illegal instruction>
	.word 0xbba54820  ! 1299: FADDs	fadds	%f21, %f0, %f29
	.word 0xb5a80820  ! 1305: FMOVRLEZ	fmovs	%fcc1, %f0, %f26
	.word 0xb9a5c840  ! 1306: FADDd	faddd	%f54, %f0, %f28
hwintr_1_61:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_61), 16, 16)) -> intp(1, 0, 3c)
	.word 0xb5a00020  ! 1318: FMOVs	fmovs	%f0, %f26
	.word 0xb7ab8820  ! 1322: FMOVPOS	fmovs	%fcc1, %f0, %f27
	.word 0xbba50920  ! 1323: FMULs	fmuls	%f20, %f0, %f29
	.word 0xb81c0000  ! 1324: XOR_R	xor 	%r16, %r0, %r28
	.word 0xbdab0820  ! 1326: FMOVGU	fmovs	%fcc1, %f0, %f30
	.word 0xbfa00560  ! 1330: FSQRTq	fsqrt	
	.word 0xbcbd8000  ! 1332: XNORcc_R	xnorcc 	%r22, %r0, %r30
hwintr_1_62:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_62), 16, 16)) -> intp(1, 0, 5)
	.word 0xbcb4c000  ! 1338: ORNcc_R	orncc 	%r19, %r0, %r30
	.word 0xbda84820  ! 1343: FMOVE	fmovs	%fcc1, %f0, %f30
	.word 0xb9a489e0  ! 1344: FDIVq	dis not found

	.word 0xb1a00520  ! 1347: FSQRTs	fsqrt	
	.word 0xbda98820  ! 1350: FMOVNEG	fmovs	%fcc1, %f0, %f30
	ta	T_CHANGE_HPRIV
	.word 0x81982d59  ! 1353: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0d59, %hpstate
	.word 0xb5a9c820  ! 1356: FMOVVS	fmovs	%fcc1, %f0, %f26
	.word 0x8794e118  ! 1361: WRPR_TT_I	wrpr	%r19, 0x0118, %tt
	.word 0xb9ab4820  ! 1362: FMOVCC	fmovs	%fcc1, %f0, %f28
	.word 0xb5aa0820  ! 1365: FMOVA	fmovs	%fcc1, %f0, %f26
	.word 0xb3a508e0  ! 1366: FSUBq	dis not found

	.word 0xb1520000  ! 1367: RDPR_PIL	<illegal instruction>
	.word 0xb3a5c8a0  ! 1373: FSUBs	fsubs	%f23, %f0, %f25
	.word 0xbb480000  ! 1374: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xbfa80820  ! 1375: FMOVRLEZ	fmovs	%fcc1, %f0, %f31
	mov	0, %r14
	.word 0xa193a000  ! 1383: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9ab4820  ! 1386: FMOVCC	fmovs	%fcc1, %f0, %f28
	.word 0xbfa408e0  ! 1388: FSUBq	dis not found

hwintr_1_63:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_63), 16, 16)) -> intp(1, 0, 11)
hwintr_1_64:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_64), 16, 16)) -> intp(1, 0, 2f)
	.word 0x91952055  ! 1393: WRPR_PIL_I	wrpr	%r20, 0x0055, %pil
	.word 0xb3a80c20  ! 1395: FMOVRLZ	dis not found

	.word 0xbfa81c20  ! 1404: FMOVRGEZ	dis not found

	.word 0xbfaa8820  ! 1405: FMOVG	fmovs	%fcc1, %f0, %f31
	.word 0xb1a489a0  ! 1406: FDIVs	fdivs	%f18, %f0, %f24
hwintr_1_65:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_65), 16, 16)) -> intp(1, 0, a)
	.word 0xbfa589a0  ! 1409: FDIVs	fdivs	%f22, %f0, %f31
	mov	1, %r14
	.word 0xa193a000  ! 1411: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7ab8820  ! 1412: FMOVPOS	fmovs	%fcc1, %f0, %f27
	.word 0xb351c000  ! 1413: RDPR_TL	<illegal instruction>
	.word 0xbba409c0  ! 1414: FDIVd	fdivd	%f16, %f0, %f60
	.word 0xbfa48960  ! 1421: FMULq	dis not found

	.word 0xb9aac820  ! 1423: FMOVGE	fmovs	%fcc1, %f0, %f28
	.word 0xb9a81420  ! 1425: FMOVRNZ	dis not found

	.word 0xb1508000  ! 1426: RDPR_TSTATE	<illegal instruction>
	.word 0xbb518000  ! 1427: RDPR_PSTATE	<illegal instruction>
	.word 0xbd3da001  ! 1428: SRA_I	sra 	%r22, 0x0001, %r30
hwintr_1_66:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_66), 16, 16)) -> intp(1, 0, 2d)
	.word 0xb3a58820  ! 1440: FADDs	fadds	%f22, %f0, %f25
	.word 0xb5a8c820  ! 1441: FMOVL	fmovs	%fcc1, %f0, %f26
	.word 0xb295215d  ! 1444: ORcc_I	orcc 	%r20, 0x015d, %r25
hwintr_1_67:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_67), 16, 16)) -> intp(1, 0, 33)
	.word 0xb7ab0820  ! 1447: FMOVGU	fmovs	%fcc1, %f0, %f27
	.word 0xb9643801  ! 1448: MOVcc_I	<illegal instruction>
	.word 0xb0ad0000  ! 1449: ANDNcc_R	andncc 	%r20, %r0, %r24
	.word 0xb7a84820  ! 1466: FMOVE	fmovs	%fcc1, %f0, %f27
	.word 0xb7a80c20  ! 1467: FMOVRLZ	dis not found

	.word 0xb92df001  ! 1468: SLLX_I	sllx	%r23, 0x0001, %r28
	mov	1, %r14
	.word 0xa193a000  ! 1470: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbfa44860  ! 1471: FADDq	dis not found

	.word 0xb53da001  ! 1473: SRA_I	sra 	%r22, 0x0001, %r26
	.word 0xbf643801  ! 1474: MOVcc_I	<illegal instruction>
	.word 0xb5520000  ! 1476: RDPR_PIL	<illegal instruction>
	.word 0xbd520000  ! 1483: RDPR_PIL	<illegal instruction>
	.word 0xb5a4c820  ! 1484: FADDs	fadds	%f19, %f0, %f26
	.word 0x919520be  ! 1489: WRPR_PIL_I	wrpr	%r20, 0x00be, %pil
	.word 0xb7aa4820  ! 1490: FMOVNE	fmovs	%fcc1, %f0, %f27
	ldda	[%r16 + %g0] 0xf0, %f2
	ldda	[%r20 + %g0] 0xf0, %f2
	.word 0xb7a80820  ! 1500: FMOVN	fmovs	%fcc1, %f0, %f27
	.word 0xbba488e0  ! 1501: FSUBq	dis not found

	.word 0xb7a80420  ! 1507: FMOVRZ	dis not found

	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xb9a90820  ! 1517: FMOVLEU	fmovs	%fcc1, %f0, %f28
	.word 0x8794605c  ! 1519: WRPR_TT_I	wrpr	%r17, 0x005c, %tt
	.word 0x9195e1ba  ! 1521: WRPR_PIL_I	wrpr	%r23, 0x01ba, %pil
	ta	T_CHANGE_HPRIV
	.word 0x81983b49  ! 1528: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b49, %hpstate
	.word 0xb9a54960  ! 1531: FMULq	dis not found

	.word 0xb1a44820  ! 1533: FADDs	fadds	%f17, %f0, %f24
	.word 0xb5a44860  ! 1535: FADDq	dis not found

	.word 0xbda5c9a0  ! 1537: FDIVs	fdivs	%f23, %f0, %f30
hwintr_1_68:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_68), 16, 16)) -> intp(1, 0, 30)
	mov	1, %r12
	.word 0x8f932000  ! 1541: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x8d95e060  ! 1546: WRPR_PSTATE_I	wrpr	%r23, 0x0060, %pstate
	.word 0xbfa5c8c0  ! 1551: FSUBd	fsubd	%f54, %f0, %f62
	.word 0xb3a44840  ! 1565: FADDd	faddd	%f48, %f0, %f56
	mov	0, %r12
	.word 0x8f932000  ! 1566: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_1_69:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_69), 16, 16)) -> intp(1, 0, 31)
	.word 0xbfa44840  ! 1573: FADDd	faddd	%f48, %f0, %f62
	.word 0xb53c6001  ! 1574: SRA_I	sra 	%r17, 0x0001, %r26
	.word 0xb9a40860  ! 1575: FADDq	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x81982e93  ! 1584: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e93, %hpstate
	.word 0xb7a80820  ! 1589: FMOVN	fmovs	%fcc1, %f0, %f27
	.word 0xbfa589c0  ! 1592: FDIVd	fdivd	%f22, %f0, %f62
	mov	2, %r14
	.word 0xa193a000  ! 1599: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbd520000  ! 1607: RDPR_PIL	<illegal instruction>
	.word 0xb3a58960  ! 1610: FMULq	dis not found

	.word 0xbda00040  ! 1612: FMOVd	fmovd	%f0, %f30
	.word 0xb1a88820  ! 1616: FMOVLE	fmovs	%fcc1, %f0, %f24
	.word 0x8595a087  ! 1618: WRPR_TSTATE_I	wrpr	%r22, 0x0087, %tstate
	.word 0xb7a58840  ! 1621: FADDd	faddd	%f22, %f0, %f58
	.word 0xb3a44860  ! 1622: FADDq	dis not found

	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xbd520000  ! 1629: RDPR_PIL	<illegal instruction>
	.word 0xb33c6001  ! 1631: SRA_I	sra 	%r17, 0x0001, %r25
	.word 0xb7a81c20  ! 1633: FMOVRGEZ	dis not found

	.word 0xbfa448c0  ! 1639: FSUBd	fsubd	%f48, %f0, %f62
	.word 0xbfa509e0  ! 1640: FDIVq	dis not found

	.word 0xb9a50840  ! 1641: FADDd	faddd	%f20, %f0, %f28
	.word 0xb1518000  ! 1642: RDPR_PSTATE	<illegal instruction>
	.word 0xb351c000  ! 1644: RDPR_TL	<illegal instruction>
	.word 0xbfab0820  ! 1645: FMOVGU	fmovs	%fcc1, %f0, %f31
	.word 0xbfa00040  ! 1648: FMOVd	fmovd	%f0, %f62
	.word 0xb3500000  ! 1656: RDPR_TPC	<illegal instruction>
	.word 0xb3a40960  ! 1659: FMULq	dis not found

	.word 0x89952011  ! 1661: WRPR_TICK_I	wrpr	%r20, 0x0011, %tick
	.word 0xb1a94820  ! 1663: FMOVCS	fmovs	%fcc1, %f0, %f24
	.word 0xb9a4c860  ! 1665: FADDq	dis not found

	.word 0xb21ca100  ! 1672: XOR_I	xor 	%r18, 0x0100, %r25
	ldda	[%r16 + %g0] 0xf0, %f2
hwintr_1_70:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_70), 16, 16)) -> intp(1, 0, 1a)
	.word 0xb7a50940  ! 1680: FMULd	fmuld	%f20, %f0, %f58
	.word 0xbfa81c20  ! 1681: FMOVRGEZ	dis not found

	.word 0xbfa5c9c0  ! 1682: FDIVd	fdivd	%f54, %f0, %f62
	.word 0xbba40840  ! 1684: FADDd	faddd	%f16, %f0, %f60
	.word 0xbba40940  ! 1686: FMULd	fmuld	%f16, %f0, %f60
	.word 0xbd51c000  ! 1687: RDPR_TL	<illegal instruction>
	.word 0xbba94820  ! 1689: FMOVCS	fmovs	%fcc1, %f0, %f29
	mov	1, %r12
	.word 0x8f932000  ! 1691: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_1_71:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_71), 16, 16)) -> intp(1, 0, 6)
	.word 0xb1a80820  ! 1698: FMOVN	fmovs	%fcc1, %f0, %f24
	.word 0xbba50860  ! 1699: FADDq	dis not found

	.word 0xbfa408c0  ! 1701: FSUBd	fsubd	%f16, %f0, %f62
	.word 0xbda40960  ! 1702: FMULq	dis not found

	.word 0x899520c3  ! 1704: WRPR_TICK_I	wrpr	%r20, 0x00c3, %tick
	mov	1, %r14
	.word 0xa193a000  ! 1705: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7504000  ! 1709: RDPR_TNPC	<illegal instruction>
hwintr_1_72:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_72), 16, 16)) -> intp(1, 0, 2a)
hwintr_1_73:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_73), 16, 16)) -> intp(1, 0, 21)
	.word 0xb7a40920  ! 1716: FMULs	fmuls	%f16, %f0, %f27
	.word 0xb3a81c20  ! 1718: FMOVRGEZ	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x81982c83  ! 1719: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c83, %hpstate
	.word 0xb1510000  ! 1722: RDPR_TICK	<illegal instruction>
hwintr_1_74:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_74), 16, 16)) -> intp(1, 0, a)
	.word 0xbba81420  ! 1726: FMOVRNZ	dis not found

	.word 0xba3d61ed  ! 1727: XNOR_I	xnor 	%r21, 0x01ed, %r29
	ta	T_CHANGE_HPRIV
	.word 0x819839cb  ! 1728: WRHPR_HPSTATE_I	wrhpr	%r0, 0x19cb, %hpstate
hwintr_1_75:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_75), 16, 16)) -> intp(1, 0, 1c)
hwintr_1_76:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_76), 16, 16)) -> intp(1, 0, 30)
	.word 0xbd51c000  ! 1737: RDPR_TL	<illegal instruction>
	.word 0xb5a5c9e0  ! 1738: FDIVq	dis not found

	.word 0xb7a588a0  ! 1739: FSUBs	fsubs	%f22, %f0, %f27
	.word 0xb5a58940  ! 1741: FMULd	fmuld	%f22, %f0, %f26
	.word 0xbc3d60da  ! 1742: XNOR_I	xnor 	%r21, 0x00da, %r30
	.word 0xb2c5a07a  ! 1743: ADDCcc_I	addccc 	%r22, 0x007a, %r25
hwintr_1_77:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_77), 16, 16)) -> intp(1, 0, 36)
	.word 0x8995619c  ! 1750: WRPR_TICK_I	wrpr	%r21, 0x019c, %tick
	.word 0x899461e6  ! 1751: WRPR_TICK_I	wrpr	%r17, 0x01e6, %tick
	.word 0xb5a80420  ! 1755: FMOVRZ	dis not found

	.word 0xb1510000  ! 1758: RDPR_TICK	<illegal instruction>
hwintr_1_78:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_78), 16, 16)) -> intp(1, 0, 37)
	.word 0xb150c000  ! 1764: RDPR_TT	<illegal instruction>
	.word 0xb3a54860  ! 1767: FADDq	dis not found

	.word 0xb49d8000  ! 1769: XORcc_R	xorcc 	%r22, %r0, %r26
	.word 0x9194a046  ! 1771: WRPR_PIL_I	wrpr	%r18, 0x0046, %pil
	ldda	[%r16 + %g0] 0xf0, %f2
	ta	T_CHANGE_HPRIV
	.word 0x819829cb  ! 1773: WRHPR_HPSTATE_I	wrhpr	%r0, 0x09cb, %hpstate
	.word 0xb1a489e0  ! 1775: FDIVq	dis not found

	.word 0xb1ab8820  ! 1776: FMOVPOS	fmovs	%fcc1, %f0, %f24
	.word 0xbfa508c0  ! 1779: FSUBd	fsubd	%f20, %f0, %f62
	.word 0xb3ab4820  ! 1781: FMOVCC	fmovs	%fcc1, %f0, %f25
	.word 0xb5a80820  ! 1786: FMOVN	fmovs	%fcc1, %f0, %f26
hwintr_1_79:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_79), 16, 16)) -> intp(1, 0, 37)
	.word 0xbda48840  ! 1796: FADDd	faddd	%f18, %f0, %f30
	mov	0, %r12
	.word 0x8f932000  ! 1798: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbda00520  ! 1799: FSQRTs	fsqrt	
	.word 0xbda44840  ! 1800: FADDd	faddd	%f48, %f0, %f30
hwintr_1_80:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_80), 16, 16)) -> intp(1, 0, 3b)
	.word 0xb1a549c0  ! 1804: FDIVd	fdivd	%f52, %f0, %f24
	ta	T_CHANGE_HPRIV
	.word 0x81982cd9  ! 1805: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0cd9, %hpstate
	.word 0xb5a448c0  ! 1807: FSUBd	fsubd	%f48, %f0, %f26
	.word 0xb5a00520  ! 1808: FSQRTs	fsqrt	
	.word 0xb9508000  ! 1811: RDPR_TSTATE	<illegal instruction>
	.word 0xbba98820  ! 1813: FMOVNEG	fmovs	%fcc1, %f0, %f29
	.word 0xbb7ce401  ! 1817: MOVR_I	movre	%r19, 0x1, %r29
	.word 0xb3a84820  ! 1819: FMOVE	fmovs	%fcc1, %f0, %f25
	.word 0xb150c000  ! 1822: RDPR_TT	<illegal instruction>
	.word 0xb5a80820  ! 1827: FMOVRLEZ	fmovs	%fcc1, %f0, %f26
	.word 0xb1a448c0  ! 1828: FSUBd	fsubd	%f48, %f0, %f24
	.word 0xbfa40840  ! 1831: FADDd	faddd	%f16, %f0, %f62
	.word 0xb37c6401  ! 1832: MOVR_I	movre	%r17, 0x1, %r25
hwintr_1_81:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_81), 16, 16)) -> intp(1, 0, 16)
	ta	T_CHANGE_HPRIV
	.word 0x81983d8b  ! 1835: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d8b, %hpstate
	ldda	[%r22 + %g0] 0xf0, %f2
	.word 0xbda4c9c0  ! 1837: FDIVd	fdivd	%f50, %f0, %f30
	.word 0xbfa81c20  ! 1843: FMOVRGEZ	dis not found

hwintr_1_82:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_82), 16, 16)) -> intp(1, 0, 19)
	.word 0xb9aa4820  ! 1849: FMOVNE	fmovs	%fcc1, %f0, %f28
	.word 0xbfa80420  ! 1850: FMOVRZ	dis not found

	.word 0x8d94e0ae  ! 1851: WRPR_PSTATE_I	wrpr	%r19, 0x00ae, %pstate
	.word 0xb9a81c20  ! 1853: FMOVRGEZ	dis not found

	.word 0xbb520000  ! 1854: RDPR_PIL	<illegal instruction>
	.word 0xb7a94820  ! 1856: FMOVCS	fmovs	%fcc1, %f0, %f27
hwintr_1_83:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_83), 16, 16)) -> intp(1, 0, 1a)
	.word 0xbda50940  ! 1860: FMULd	fmuld	%f20, %f0, %f30
	.word 0xb3a90820  ! 1865: FMOVLEU	fmovs	%fcc1, %f0, %f25
	.word 0xb1ab0820  ! 1866: FMOVGU	fmovs	%fcc1, %f0, %f24
	.word 0xb9a88820  ! 1867: FMOVLE	fmovs	%fcc1, %f0, %f28
	mov	0, %r12
	.word 0x8f932000  ! 1872: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb5a54820  ! 1873: FADDs	fadds	%f21, %f0, %f26
	.word 0xbba94820  ! 1874: FMOVCS	fmovs	%fcc1, %f0, %f29
	.word 0xb1a508e0  ! 1877: FSUBq	dis not found

	.word 0xbfa81420  ! 1881: FMOVRNZ	dis not found

	.word 0x9194618d  ! 1882: WRPR_PIL_I	wrpr	%r17, 0x018d, %pil
	.word 0xbb518000  ! 1888: RDPR_PSTATE	<illegal instruction>
	.word 0xb3a409e0  ! 1890: FDIVq	dis not found

	.word 0xb13c6001  ! 1891: SRA_I	sra 	%r17, 0x0001, %r24
	ldda	[%r22 + %g0] 0xf0, %f2
	.word 0xb5a408c0  ! 1894: FSUBd	fsubd	%f16, %f0, %f26
	.word 0xb1a48840  ! 1895: FADDd	faddd	%f18, %f0, %f24
	.word 0xb424a082  ! 1898: SUB_I	sub 	%r18, 0x0082, %r26
	.word 0x81942021  ! 1899: WRPR_TPC_I	wrpr	%r16, 0x0021, %tpc
	.word 0xbfa98820  ! 1904: FMOVNEG	fmovs	%fcc1, %f0, %f31
	.word 0xb2254000  ! 1909: SUB_R	sub 	%r21, %r0, %r25
	.word 0xbb504000  ! 1911: RDPR_TNPC	<illegal instruction>
	.word 0x8d95e1a8  ! 1915: WRPR_PSTATE_I	wrpr	%r23, 0x01a8, %pstate
	.word 0xbba80820  ! 1919: FMOVRLEZ	fmovs	%fcc1, %f0, %f29
	.word 0xbba90820  ! 1920: FMOVLEU	fmovs	%fcc1, %f0, %f29
	.word 0xbfa4c840  ! 1922: FADDd	faddd	%f50, %f0, %f62
	.word 0xb5a589c0  ! 1923: FDIVd	fdivd	%f22, %f0, %f26
hwintr_1_84:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_84), 16, 16)) -> intp(1, 0, 2)
	.word 0xb5abc820  ! 1928: FMOVVC	fmovs	%fcc1, %f0, %f26
	.word 0xb0acc000  ! 1930: ANDNcc_R	andncc 	%r19, %r0, %r24
	.word 0xbba548e0  ! 1934: FSUBq	dis not found

	.word 0x8195a05d  ! 1936: WRPR_TPC_I	wrpr	%r22, 0x005d, %tpc
hwintr_1_85:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_85), 16, 16)) -> intp(1, 0, 3b)
	.word 0x91942077  ! 1943: WRPR_PIL_I	wrpr	%r16, 0x0077, %pil
	.word 0x8d95a195  ! 1946: WRPR_PSTATE_I	wrpr	%r22, 0x0195, %pstate
	.word 0xbb340000  ! 1947: SRL_R	srl 	%r16, %r0, %r29
	ldda	[%r21 + %g0] 0xf0, %f2
hwintr_1_86:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_86), 16, 16)) -> intp(1, 0, 24)
	.word 0xb1a40940  ! 1952: FMULd	fmuld	%f16, %f0, %f24
	.word 0xb551c000  ! 1954: RDPR_TL	<illegal instruction>
	.word 0xbfa00560  ! 1957: FSQRTq	fsqrt	
	.word 0xb294e197  ! 1958: ORcc_I	orcc 	%r19, 0x0197, %r25
	.word 0xbbaa0820  ! 1960: FMOVA	fmovs	%fcc1, %f0, %f29
	.word 0xb9a48960  ! 1961: FMULq	dis not found

	.word 0xbba88820  ! 1962: FMOVLE	fmovs	%fcc1, %f0, %f29
hwintr_1_87:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_87), 16, 16)) -> intp(1, 0, b)
	.word 0xb33c6001  ! 1965: SRA_I	sra 	%r17, 0x0001, %r25
hwintr_1_88:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_88), 16, 16)) -> intp(1, 0, 32)
	.word 0xb3a00520  ! 1968: FSQRTs	fsqrt	
	.word 0xbda80420  ! 1973: FMOVRZ	dis not found

	.word 0xb5508000  ! 1974: RDPR_TSTATE	<illegal instruction>
	.word 0xb3a80820  ! 1976: FMOVRLEZ	fmovs	%fcc1, %f0, %f25
	.word 0xbba00560  ! 1977: FSQRTq	fsqrt	
	.word 0xbd540000  ! 1978: RDPR_GL	<illegal instruction>
	.word 0xb5a00540  ! 1980: FSQRTd	fsqrt	
	.word 0x9194202d  ! 1982: WRPR_PIL_I	wrpr	%r16, 0x002d, %pil
	.word 0x9195a1aa  ! 1983: WRPR_PIL_I	wrpr	%r22, 0x01aa, %pil
	.word 0xb3342001  ! 1985: SRL_I	srl 	%r16, 0x0001, %r25
hwintr_1_89:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_89), 16, 16)) -> intp(1, 0, 36)
	.word 0xbdaac820  ! 1991: FMOVGE	fmovs	%fcc1, %f0, %f30
	mov	0, %r14
	.word 0xa193a000  ! 1996: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9aa8820  ! 1997: FMOVG	fmovs	%fcc1, %f0, %f28
	ldda	[%r21 + %g0] 0xf0, %f2
	.word 0xb1a94820  ! 2000: FMOVCS	fmovs	%fcc1, %f0, %f24
	.word 0xb7a48820  ! 2001: FADDs	fadds	%f18, %f0, %f27
hwintr_1_90:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_90), 16, 16)) -> intp(1, 0, 29)
	.word 0xb7a80820  ! 2007: FMOVRLEZ	fmovs	%fcc1, %f0, %f27
	.word 0x8795a081  ! 2009: WRPR_TT_I	wrpr	%r22, 0x0081, %tt
hwintr_1_91:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_91), 16, 16)) -> intp(1, 0, 0)
	.word 0xbbaa4820  ! 2015: FMOVNE	fmovs	%fcc1, %f0, %f29
	.word 0xbda588c0  ! 2017: FSUBd	fsubd	%f22, %f0, %f30
	.word 0xbfa44960  ! 2022: FMULq	dis not found

	.word 0xbc444000  ! 2024: ADDC_R	addc 	%r17, %r0, %r30
	.word 0xb751c000  ! 2028: RDPR_TL	<illegal instruction>
	.word 0xb5520000  ! 2029: RDPR_PIL	<illegal instruction>
hwintr_1_92:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_92), 16, 16)) -> intp(1, 0, 25)
	.word 0xbda81c20  ! 2032: FMOVRGEZ	dis not found

	.word 0xb1a81820  ! 2034: FMOVRGZ	fmovs	%fcc3, %f0, %f24
	.word 0xb9a81820  ! 2036: FMOVRGZ	fmovs	%fcc3, %f0, %f28
	.word 0xb5a548c0  ! 2037: FSUBd	fsubd	%f52, %f0, %f26
	ldda	[%r17 + %g0] 0xf0, %f2
	.word 0xbfa98820  ! 2042: FMOVNEG	fmovs	%fcc1, %f0, %f31
	.word 0xb3a94820  ! 2053: FMOVCS	fmovs	%fcc1, %f0, %f25
	.word 0x8195a11f  ! 2056: WRPR_TPC_I	wrpr	%r22, 0x011f, %tpc
	.word 0xbfaa4820  ! 2058: FMOVNE	fmovs	%fcc1, %f0, %f31
	.word 0xb42d4000  ! 2060: ANDN_R	andn 	%r21, %r0, %r26
	.word 0xb9a54960  ! 2063: FMULq	dis not found

	.word 0x8194a007  ! 2064: WRPR_TPC_I	wrpr	%r18, 0x0007, %tpc
	.word 0xb7a00560  ! 2066: FSQRTq	fsqrt	
	.word 0xb88d20f9  ! 2067: ANDcc_I	andcc 	%r20, 0x00f9, %r28
	.word 0xb5a94820  ! 2068: FMOVCS	fmovs	%fcc1, %f0, %f26
	.word 0xb1aa4820  ! 2079: FMOVNE	fmovs	%fcc1, %f0, %f24
hwintr_1_93:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_93), 16, 16)) -> intp(1, 0, 6)
	.word 0xbbaa0820  ! 2083: FMOVA	fmovs	%fcc1, %f0, %f29
	.word 0xb3aa0820  ! 2084: FMOVA	fmovs	%fcc1, %f0, %f25
	.word 0xb3504000  ! 2094: RDPR_TNPC	<illegal instruction>
	.word 0xbfa409c0  ! 2095: FDIVd	fdivd	%f16, %f0, %f62
	.word 0x8394e088  ! 2096: WRPR_TNPC_I	wrpr	%r19, 0x0088, %tnpc
	.word 0xbfab8820  ! 2098: FMOVPOS	fmovs	%fcc1, %f0, %f31
	.word 0xb9ab4820  ! 2099: FMOVCC	fmovs	%fcc1, %f0, %f28
	ldda	[%r17 + %g0] 0xf0, %f2
	.word 0xbbaa0820  ! 2105: FMOVA	fmovs	%fcc1, %f0, %f29
hwintr_1_94:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_94), 16, 16)) -> intp(1, 0, 1e)
	.word 0xbd480000  ! 2109: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xbfa58840  ! 2110: FADDd	faddd	%f22, %f0, %f62
	.word 0xbb510000  ! 2111: RDPR_TICK	<illegal instruction>
	.word 0xba1521ea  ! 2113: OR_I	or 	%r20, 0x01ea, %r29
	.word 0x8995a129  ! 2115: WRPR_TICK_I	wrpr	%r22, 0x0129, %tick
	.word 0xb9a88820  ! 2118: FMOVLE	fmovs	%fcc1, %f0, %f28
	.word 0xb9a00540  ! 2121: FSQRTd	fsqrt	
	.word 0xb951c000  ! 2122: RDPR_TL	<illegal instruction>
	.word 0xba05a1b1  ! 2123: ADD_I	add 	%r22, 0x01b1, %r29
	.word 0xbda549e0  ! 2126: FDIVq	dis not found

	.word 0xb6854000  ! 2128: ADDcc_R	addcc 	%r21, %r0, %r27
	.word 0xb0244000  ! 2130: SUB_R	sub 	%r17, %r0, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81983e9b  ! 2131: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e9b, %hpstate
	.word 0xb1a5c920  ! 2135: FMULs	fmuls	%f23, %f0, %f24
	mov	0, %r12
	.word 0x8f932000  ! 2138: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_1_95:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_95), 16, 16)) -> intp(1, 0, 6)
	.word 0xbc3521c0  ! 2143: SUBC_I	orn 	%r20, 0x01c0, %r30
hwintr_1_96:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_96), 16, 16)) -> intp(1, 0, 6)
	mov	1, %r14
	.word 0xa193a000  ! 2148: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbba00520  ! 2152: FSQRTs	fsqrt	
	.word 0xb1504000  ! 2156: RDPR_TNPC	<illegal instruction>
	.word 0xb7a00020  ! 2157: FMOVs	fmovs	%f0, %f27
	.word 0xb5ab0820  ! 2160: FMOVGU	fmovs	%fcc1, %f0, %f26
	mov	1, %r12
	.word 0x8f932000  ! 2161: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb3aa0820  ! 2162: FMOVA	fmovs	%fcc1, %f0, %f25
	.word 0xb5a00520  ! 2164: FSQRTs	fsqrt	
	.word 0xb7a589a0  ! 2165: FDIVs	fdivs	%f22, %f0, %f27
	.word 0x85942140  ! 2167: WRPR_TSTATE_I	wrpr	%r16, 0x0140, %tstate
	.word 0xb3aa8820  ! 2170: FMOVG	fmovs	%fcc1, %f0, %f25
	.word 0xbf510000  ! 2173: RDPR_TICK	<illegal instruction>
	.word 0xbfa409e0  ! 2175: FDIVq	dis not found

	.word 0xbba44940  ! 2176: FMULd	fmuld	%f48, %f0, %f60
	.word 0xb5a54860  ! 2183: FADDq	dis not found

	.word 0xb9a84820  ! 2185: FMOVE	fmovs	%fcc1, %f0, %f28
	.word 0x8595604d  ! 2186: WRPR_TSTATE_I	wrpr	%r21, 0x004d, %tstate
	.word 0xbfa00020  ! 2189: FMOVs	fmovs	%f0, %f31
	.word 0xb9510000  ! 2192: RDPR_TICK	<illegal instruction>
	.word 0xb5a88820  ! 2193: FMOVLE	fmovs	%fcc1, %f0, %f26
	ldda	[%r23 + %g0] 0xf0, %f2
hwintr_1_97:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_97), 16, 16)) -> intp(1, 0, 3)
	mov	0, %r12
	.word 0x8f932000  ! 2202: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb1510000  ! 2207: RDPR_TICK	<illegal instruction>
	.word 0xb9a509c0  ! 2208: FDIVd	fdivd	%f20, %f0, %f28
hwintr_1_98:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_98), 16, 16)) -> intp(1, 0, 20)
	.word 0xb5ab8820  ! 2214: FMOVPOS	fmovs	%fcc1, %f0, %f26
	.word 0xb7ab0820  ! 2217: FMOVGU	fmovs	%fcc1, %f0, %f27
	.word 0x8795e0d4  ! 2218: WRPR_TT_I	wrpr	%r23, 0x00d4, %tt
hwintr_1_99:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_99), 16, 16)) -> intp(1, 0, 3)
	.word 0xbba44860  ! 2222: FADDq	dis not found

	.word 0xb7a00540  ! 2226: FSQRTd	fsqrt	
	.word 0xb9508000  ! 2228: RDPR_TSTATE	<illegal instruction>
	mov	2, %r12
	.word 0x8f932000  ! 2230: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_1_100:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_100), 16, 16)) -> intp(1, 0, e)
	.word 0xb12c9000  ! 2233: SLLX_R	sllx	%r18, %r0, %r24
	.word 0xb7a00540  ! 2237: FSQRTd	fsqrt	
	.word 0xbba508c0  ! 2239: FSUBd	fsubd	%f20, %f0, %f60
	ta	T_CHANGE_HPRIV
	.word 0x81983e13  ! 2240: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e13, %hpstate
hwintr_1_101:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_101), 16, 16)) -> intp(1, 0, 0)
	.word 0xbda00560  ! 2243: FSQRTq	fsqrt	
	.word 0xbbab8820  ! 2245: FMOVPOS	fmovs	%fcc1, %f0, %f29
	.word 0xbd643801  ! 2246: MOVcc_I	<illegal instruction>
	.word 0xbda80820  ! 2249: FMOVRLEZ	fmovs	%fcc1, %f0, %f30
	.word 0xbfa80820  ! 2250: FMOVRLEZ	fmovs	%fcc1, %f0, %f31
	.word 0xbba00560  ! 2251: FSQRTq	fsqrt	
	.word 0xb9a81c20  ! 2254: FMOVRGEZ	dis not found

	.word 0xb9a5c8a0  ! 2255: FSUBs	fsubs	%f23, %f0, %f28
	.word 0xb5643801  ! 2256: MOVcc_I	<illegal instruction>
	.word 0xbba549a0  ! 2257: FDIVs	fdivs	%f21, %f0, %f29
	.word 0xb150c000  ! 2258: RDPR_TT	<illegal instruction>
	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xb3a58860  ! 2261: FADDq	dis not found

	.word 0xbfab4820  ! 2263: FMOVCC	fmovs	%fcc1, %f0, %f31
	.word 0xb1a5c960  ! 2264: FMULq	dis not found

hwintr_1_102:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_102), 16, 16)) -> intp(1, 0, 1c)
	.word 0xbfa00560  ! 2272: FSQRTq	fsqrt	
hwintr_1_103:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_103), 16, 16)) -> intp(1, 0, 14)
	.word 0xb9504000  ! 2274: RDPR_TNPC	<illegal instruction>
	.word 0xb1a8c820  ! 2275: FMOVL	fmovs	%fcc1, %f0, %f24
	.word 0xb1a549e0  ! 2276: FDIVq	dis not found

	mov	2, %r14
	.word 0xa193a000  ! 2277: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xbaa40000  ! 2281: SUBcc_R	subcc 	%r16, %r0, %r29
hwintr_1_104:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_104), 16, 16)) -> intp(1, 0, 2f)
	.word 0xbda84820  ! 2285: FMOVE	fmovs	%fcc1, %f0, %f30
	.word 0xbba00560  ! 2287: FSQRTq	fsqrt	
	.word 0xb1a409a0  ! 2291: FDIVs	fdivs	%f16, %f0, %f24
	.word 0xb7500000  ! 2292: RDPR_TPC	<illegal instruction>
	.word 0xb495e07c  ! 2296: ORcc_I	orcc 	%r23, 0x007c, %r26
	.word 0xb5aa0820  ! 2297: FMOVA	fmovs	%fcc1, %f0, %f26
	.word 0xb5a4c820  ! 2298: FADDs	fadds	%f19, %f0, %f26
	.word 0xb5a88820  ! 2299: FMOVLE	fmovs	%fcc1, %f0, %f26
	.word 0xb5a589a0  ! 2308: FDIVs	fdivs	%f22, %f0, %f26
	.word 0x89946156  ! 2309: WRPR_TICK_I	wrpr	%r17, 0x0156, %tick
	.word 0xbfa549a0  ! 2315: FDIVs	fdivs	%f21, %f0, %f31
	.word 0xb1a54820  ! 2316: FADDs	fadds	%f21, %f0, %f24
	.word 0x9195a157  ! 2317: WRPR_PIL_I	wrpr	%r22, 0x0157, %pil
	.word 0xbda8c820  ! 2321: FMOVL	fmovs	%fcc1, %f0, %f30
hwintr_1_105:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_105), 16, 16)) -> intp(1, 0, 9)
	ta	T_CHANGE_HPRIV
	.word 0x819829c9  ! 2327: WRHPR_HPSTATE_I	wrhpr	%r0, 0x09c9, %hpstate
	.word 0xbfa48920  ! 2331: FMULs	fmuls	%f18, %f0, %f31
	.word 0xb7520000  ! 2332: RDPR_PIL	<illegal instruction>
	.word 0xb7504000  ! 2334: RDPR_TNPC	<illegal instruction>
hwintr_1_106:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_106), 16, 16)) -> intp(1, 0, 2a)
	.word 0xbfa00020  ! 2336: FMOVs	fmovs	%f0, %f31
	.word 0xbda81820  ! 2337: FMOVRGZ	fmovs	%fcc3, %f0, %f30
	.word 0xbb508000  ! 2339: RDPR_TSTATE	<illegal instruction>
	.word 0xbf520000  ! 2341: RDPR_PIL	<illegal instruction>
	.word 0xb7a5c920  ! 2345: FMULs	fmuls	%f23, %f0, %f27
hwintr_1_107:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_107), 16, 16)) -> intp(1, 0, 2a)
	.word 0xbf508000  ! 2351: RDPR_TSTATE	<illegal instruction>
	.word 0xb6ac8000  ! 2353: ANDNcc_R	andncc 	%r18, %r0, %r27
	.word 0xb9a00540  ! 2354: FSQRTd	fsqrt	
	.word 0xb550c000  ! 2355: RDPR_TT	<illegal instruction>
	.word 0xb9a94820  ! 2356: FMOVCS	fmovs	%fcc1, %f0, %f28
hwintr_1_108:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_108), 16, 16)) -> intp(1, 0, 31)
	ta	T_CHANGE_HPRIV
	.word 0x81983f93  ! 2358: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f93, %hpstate
	.word 0xbea4e02b  ! 2361: SUBcc_I	subcc 	%r19, 0x002b, %r31
	.word 0xb7a90820  ! 2364: FMOVLEU	fmovs	%fcc1, %f0, %f27
	.word 0xbe856018  ! 2365: ADDcc_I	addcc 	%r21, 0x0018, %r31
	mov	0, %r12
	.word 0x8f932000  ! 2367: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb3504000  ! 2369: RDPR_TNPC	<illegal instruction>
	.word 0x8594a076  ! 2371: WRPR_TSTATE_I	wrpr	%r18, 0x0076, %tstate
	.word 0xbba448e0  ! 2374: FSUBq	dis not found

	.word 0xbfa90820  ! 2375: FMOVLEU	fmovs	%fcc1, %f0, %f31
	.word 0xbfaa8820  ! 2378: FMOVG	fmovs	%fcc1, %f0, %f31
	.word 0xbfa80820  ! 2379: FMOVRLEZ	fmovs	%fcc1, %f0, %f31
	.word 0xbfa98820  ! 2384: FMOVNEG	fmovs	%fcc1, %f0, %f31
	.word 0xba9d4000  ! 2385: XORcc_R	xorcc 	%r21, %r0, %r29
	.word 0xb9a81420  ! 2386: FMOVRNZ	dis not found

	.word 0x8d9561cf  ! 2388: WRPR_PSTATE_I	wrpr	%r21, 0x01cf, %pstate
	.word 0xb32d6001  ! 2389: SLL_I	sll 	%r21, 0x0001, %r25
	.word 0xbf3ce001  ! 2392: SRA_I	sra 	%r19, 0x0001, %r31
	.word 0xb62420f8  ! 2393: SUB_I	sub 	%r16, 0x00f8, %r27
	.word 0xb414a147  ! 2395: OR_I	or 	%r18, 0x0147, %r26
	.word 0xb9a4c9a0  ! 2396: FDIVs	fdivs	%f19, %f0, %f28
	.word 0xb0340000  ! 2397: ORN_R	orn 	%r16, %r0, %r24
	.word 0xbfa00560  ! 2404: FSQRTq	fsqrt	
	.word 0xb550c000  ! 2405: RDPR_TT	<illegal instruction>
	.word 0xbfab8820  ! 2406: FMOVPOS	fmovs	%fcc1, %f0, %f31
	.word 0xb9a80c20  ! 2407: FMOVRLZ	dis not found

	.word 0xb7a50860  ! 2410: FADDq	dis not found

	.word 0xbba94820  ! 2411: FMOVCS	fmovs	%fcc1, %f0, %f29
	.word 0xbba88820  ! 2413: FMOVLE	fmovs	%fcc1, %f0, %f29
	.word 0xb3a94820  ! 2414: FMOVCS	fmovs	%fcc1, %f0, %f25
	.word 0xb9aa0820  ! 2415: FMOVA	fmovs	%fcc1, %f0, %f28
	.word 0xb1a94820  ! 2416: FMOVCS	fmovs	%fcc1, %f0, %f24
hwintr_1_109:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_109), 16, 16)) -> intp(1, 0, b)
	.word 0xb9a00540  ! 2421: FSQRTd	fsqrt	
	mov	0, %r14
	.word 0xa193a000  ! 2427: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7a48920  ! 2428: FMULs	fmuls	%f18, %f0, %f27
	.word 0xbba488e0  ! 2429: FSUBq	dis not found

	.word 0xb3a00540  ! 2430: FSQRTd	fsqrt	
	.word 0xbfa00560  ! 2431: FSQRTq	fsqrt	
	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xb62c618a  ! 2434: ANDN_I	andn 	%r17, 0x018a, %r27
	.word 0xb3a4c9e0  ! 2435: FDIVq	dis not found

	.word 0xb5a44840  ! 2436: FADDd	faddd	%f48, %f0, %f26
	.word 0xb5aa8820  ! 2444: FMOVG	fmovs	%fcc1, %f0, %f26
	.word 0xbda4c9e0  ! 2453: FDIVq	dis not found

	.word 0xb8a52199  ! 2454: SUBcc_I	subcc 	%r20, 0x0199, %r28
hwintr_1_110:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_110), 16, 16)) -> intp(1, 0, 25)
	.word 0xb1ab4820  ! 2458: FMOVCC	fmovs	%fcc1, %f0, %f24
	.word 0xbba00540  ! 2459: FSQRTd	fsqrt	
	.word 0xbfa00560  ! 2461: FSQRTq	fsqrt	
	.word 0xbd508000  ! 2462: RDPR_TSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81983a89  ! 2464: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a89, %hpstate
	.word 0x8995a07d  ! 2467: WRPR_TICK_I	wrpr	%r22, 0x007d, %tick
	.word 0xb8b48000  ! 2468: ORNcc_R	orncc 	%r18, %r0, %r28
	.word 0xb1a48820  ! 2469: FADDs	fadds	%f18, %f0, %f24
	.word 0xb5a488e0  ! 2472: FSUBq	dis not found

	.word 0xb7a00560  ! 2473: FSQRTq	fsqrt	
	.word 0xb7480000  ! 2474: RDHPR_HPSTATE	rdhpr	%hpstate, %r27
	.word 0xbd50c000  ! 2475: RDPR_TT	<illegal instruction>
hwintr_1_111:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_111), 16, 16)) -> intp(1, 0, 10)
	.word 0xbf510000  ! 2478: RDPR_TICK	<illegal instruction>
	.word 0x8994a10e  ! 2479: WRPR_TICK_I	wrpr	%r18, 0x010e, %tick
	.word 0xb1a50820  ! 2480: FADDs	fadds	%f20, %f0, %f24
hwintr_1_112:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_112), 16, 16)) -> intp(1, 0, 8)
	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xb9504000  ! 2485: RDPR_TNPC	<illegal instruction>
hwintr_1_113:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_113), 16, 16)) -> intp(1, 0, 18)
	.word 0xb7aa4820  ! 2490: FMOVNE	fmovs	%fcc1, %f0, %f27
	.word 0xb3a00040  ! 2491: FMOVd	fmovd	%f0, %f56
hwintr_1_114:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_114), 16, 16)) -> intp(1, 0, 36)
	.word 0xbf500000  ! 2503: RDPR_TPC	<illegal instruction>
	.word 0xb5a98820  ! 2505: FMOVNEG	fmovs	%fcc1, %f0, %f26
	.word 0xb1ab8820  ! 2506: FMOVPOS	fmovs	%fcc1, %f0, %f24
	ldda	[%r23 + %g0] 0xf0, %f2
	mov	1, %r14
	.word 0xa193a000  ! 2513: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8194a07f  ! 2514: WRPR_TPC_I	wrpr	%r18, 0x007f, %tpc
	.word 0xbbaac820  ! 2516: FMOVGE	fmovs	%fcc1, %f0, %f29
	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xb33d1000  ! 2520: SRAX_R	srax	%r20, %r0, %r25
	.word 0xb1a80c20  ! 2521: FMOVRLZ	dis not found

	.word 0xbba54840  ! 2522: FADDd	faddd	%f52, %f0, %f60
	.word 0xbda80420  ! 2524: FMOVRZ	dis not found

	.word 0xb5a00560  ! 2529: FSQRTq	fsqrt	
	.word 0xb9a00020  ! 2530: FMOVs	fmovs	%f0, %f28
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xbba90820  ! 2543: FMOVLEU	fmovs	%fcc1, %f0, %f29
hwintr_1_115:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_115), 16, 16)) -> intp(1, 0, 20)
	.word 0xb5a549a0  ! 2547: FDIVs	fdivs	%f21, %f0, %f26
	.word 0xb1a00040  ! 2548: FMOVd	fmovd	%f0, %f24
	.word 0xbda48940  ! 2550: FMULd	fmuld	%f18, %f0, %f30
	mov	0, %r12
	.word 0x8f932000  ! 2557: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb53d7001  ! 2563: SRAX_I	srax	%r21, 0x0001, %r26
	.word 0xbfa54960  ! 2564: FMULq	dis not found

	.word 0xbcc5c000  ! 2565: ADDCcc_R	addccc 	%r23, %r0, %r30
	.word 0xb1a80c20  ! 2568: FMOVRLZ	dis not found

	.word 0xb7a44940  ! 2570: FMULd	fmuld	%f48, %f0, %f58
	.word 0xb1a5c920  ! 2571: FMULs	fmuls	%f23, %f0, %f24
	.word 0x8194e1bb  ! 2572: WRPR_TPC_I	wrpr	%r19, 0x01bb, %tpc
hwintr_1_116:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_116), 16, 16)) -> intp(1, 0, 2f)
	.word 0xb3abc820  ! 2575: FMOVVC	fmovs	%fcc1, %f0, %f25
	.word 0xb205e136  ! 2577: ADD_I	add 	%r23, 0x0136, %r25
	.word 0xbfa588e0  ! 2578: FSUBq	dis not found

	.word 0xbfab8820  ! 2582: FMOVPOS	fmovs	%fcc1, %f0, %f31
	.word 0xb5508000  ! 2584: RDPR_TSTATE	<illegal instruction>
	.word 0xb7a4c8e0  ! 2587: FSUBq	dis not found

	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xb5a5c820  ! 2591: FADDs	fadds	%f23, %f0, %f26
	.word 0xbab5e022  ! 2592: ORNcc_I	orncc 	%r23, 0x0022, %r29
	.word 0xbfa4c8c0  ! 2593: FSUBd	fsubd	%f50, %f0, %f62
hwintr_1_117:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_117), 16, 16)) -> intp(1, 0, 2b)
	.word 0xb3a00040  ! 2597: FMOVd	fmovd	%f0, %f56
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x81982bd1  ! 2607: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0bd1, %hpstate
	.word 0xb550c000  ! 2608: RDPR_TT	<illegal instruction>
	.word 0xb3520000  ! 2610: RDPR_PIL	<illegal instruction>
hwintr_1_118:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_118), 16, 16)) -> intp(1, 0, 27)
hwintr_1_119:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_119), 16, 16)) -> intp(1, 0, c)
	.word 0xb1a5c8a0  ! 2618: FSUBs	fsubs	%f23, %f0, %f24
	.word 0xb42c4000  ! 2619: ANDN_R	andn 	%r17, %r0, %r26
	.word 0xb9a4c940  ! 2621: FMULd	fmuld	%f50, %f0, %f28
hwintr_1_120:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_120), 16, 16)) -> intp(1, 0, 3b)
	.word 0xb2044000  ! 2623: ADD_R	add 	%r17, %r0, %r25
	.word 0xb5a8c820  ! 2624: FMOVL	fmovs	%fcc1, %f0, %f26
	.word 0xbdaac820  ! 2627: FMOVGE	fmovs	%fcc1, %f0, %f30
hwintr_1_121:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_121), 16, 16)) -> intp(1, 0, 2c)
	.word 0xb9a489c0  ! 2632: FDIVd	fdivd	%f18, %f0, %f28
	.word 0xb1540000  ! 2633: RDPR_GL	<illegal instruction>
	.word 0xb89de0ab  ! 2635: XORcc_I	xorcc 	%r23, 0x00ab, %r28
	.word 0xb7a00560  ! 2639: FSQRTq	fsqrt	
	ta	T_CHANGE_HPRIV
	.word 0x81983903  ! 2640: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1903, %hpstate
	.word 0xbbab8820  ! 2641: FMOVPOS	fmovs	%fcc1, %f0, %f29
	.word 0xb9a508a0  ! 2642: FSUBs	fsubs	%f20, %f0, %f28
hwintr_1_122:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_122), 16, 16)) -> intp(1, 0, 22)
	.word 0xb1a90820  ! 2647: FMOVLEU	fmovs	%fcc1, %f0, %f24
	.word 0xbb480000  ! 2648: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
hwintr_1_123:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_123), 16, 16)) -> intp(1, 0, 2c)
	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xb3500000  ! 2653: RDPR_TPC	<illegal instruction>
	.word 0xb7a449e0  ! 2655: FDIVq	dis not found

hwintr_1_124:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_124), 16, 16)) -> intp(1, 0, 6)
hwintr_1_125:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_125), 16, 16)) -> intp(1, 0, 2e)
	.word 0xb4c54000  ! 2662: ADDCcc_R	addccc 	%r21, %r0, %r26
	.word 0xbba80820  ! 2664: FMOVN	fmovs	%fcc1, %f0, %f29
	.word 0xb7480000  ! 2665: RDHPR_HPSTATE	rdhpr	%hpstate, %r27
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xb214c000  ! 2670: OR_R	or 	%r19, %r0, %r25
	.word 0xb734e001  ! 2671: SRL_I	srl 	%r19, 0x0001, %r27
	.word 0xb7a00560  ! 2675: FSQRTq	fsqrt	
	.word 0xb1a00520  ! 2682: FSQRTs	fsqrt	
	.word 0xbfa94820  ! 2688: FMOVCS	fmovs	%fcc1, %f0, %f31
	.word 0xb9520000  ! 2689: RDPR_PIL	<illegal instruction>
	.word 0xba2c0000  ! 2690: ANDN_R	andn 	%r16, %r0, %r29
	.word 0xb5a80420  ! 2691: FMOVRZ	dis not found

	.word 0xbfa4c840  ! 2698: FADDd	faddd	%f50, %f0, %f62
	.word 0xbda81420  ! 2703: FMOVRNZ	dis not found

	.word 0xbd3c4000  ! 2705: SRA_R	sra 	%r17, %r0, %r30
	.word 0xbbab4820  ! 2708: FMOVCC	fmovs	%fcc1, %f0, %f29
	.word 0xb57da401  ! 2709: MOVR_I	movre	%r22, 0x1, %r26
	.word 0xb7a80c20  ! 2711: FMOVRLZ	dis not found

	.word 0xb5a448c0  ! 2714: FSUBd	fsubd	%f48, %f0, %f26
	.word 0xb5480000  ! 2716: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xb82d61d5  ! 2720: ANDN_I	andn 	%r21, 0x01d5, %r28
	.word 0xbfa4c8c0  ! 2734: FSUBd	fsubd	%f50, %f0, %f62
	.word 0x8395e1c6  ! 2735: WRPR_TNPC_I	wrpr	%r23, 0x01c6, %tnpc
	.word 0x8d95a149  ! 2737: WRPR_PSTATE_I	wrpr	%r22, 0x0149, %pstate
	.word 0xb33d9000  ! 2739: SRAX_R	srax	%r22, %r0, %r25
hwintr_1_126:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_126), 16, 16)) -> intp(1, 0, 28)
	.word 0xbda00520  ! 2748: FSQRTs	fsqrt	
	.word 0x8795610b  ! 2749: WRPR_TT_I	wrpr	%r21, 0x010b, %tt
	.word 0xb5a409c0  ! 2754: FDIVd	fdivd	%f16, %f0, %f26
	.word 0xb1a5c960  ! 2756: FMULq	dis not found

	.word 0xbcc4e1be  ! 2758: ADDCcc_I	addccc 	%r19, 0x01be, %r30
	.word 0xb3a80420  ! 2759: FMOVRZ	dis not found

	.word 0x83946030  ! 2764: WRPR_TNPC_I	wrpr	%r17, 0x0030, %tnpc
	.word 0xb5a81420  ! 2766: FMOVRNZ	dis not found

hwintr_1_127:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_127), 16, 16)) -> intp(1, 0, 0)
hwintr_1_128:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_128), 16, 16)) -> intp(1, 0, 20)
	.word 0xb6a44000  ! 2772: SUBcc_R	subcc 	%r17, %r0, %r27
	.word 0xb9a489e0  ! 2781: FDIVq	dis not found

	.word 0xb7a54920  ! 2782: FMULs	fmuls	%f21, %f0, %f27
	.word 0xb9a00540  ! 2785: FSQRTd	fsqrt	
	.word 0x8795a16c  ! 2789: WRPR_TT_I	wrpr	%r22, 0x016c, %tt
	.word 0xb9a54820  ! 2790: FADDs	fadds	%f21, %f0, %f28
	.word 0xb3a40960  ! 2791: FMULq	dis not found

	.word 0xb5480000  ! 2792: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
hwintr_1_129:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_129), 16, 16)) -> intp(1, 0, 17)
	.word 0xbfa408c0  ! 2800: FSUBd	fsubd	%f16, %f0, %f62
	.word 0xba358000  ! 2805: ORN_R	orn 	%r22, %r0, %r29
	.word 0xbda00560  ! 2806: FSQRTq	fsqrt	
	.word 0xbda54820  ! 2807: FADDs	fadds	%f21, %f0, %f30
hwintr_1_130:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_130), 16, 16)) -> intp(1, 0, 36)
	.word 0xbfab4820  ! 2810: FMOVCC	fmovs	%fcc1, %f0, %f31
	.word 0xb1a4c960  ! 2811: FMULq	dis not found

	.word 0xb7a4c8e0  ! 2816: FSUBq	dis not found

	.word 0xbb510000  ! 2817: RDPR_TICK	<illegal instruction>
	.word 0xbfa50920  ! 2820: FMULs	fmuls	%f20, %f0, %f31
	.word 0x8794a136  ! 2822: WRPR_TT_I	wrpr	%r18, 0x0136, %tt
	.word 0xb9a9c820  ! 2823: FMOVVS	fmovs	%fcc1, %f0, %f28
	.word 0xb7a54840  ! 2824: FADDd	faddd	%f52, %f0, %f58
	.word 0xb5a81c20  ! 2825: FMOVRGEZ	dis not found

	.word 0xbfa449c0  ! 2827: FDIVd	fdivd	%f48, %f0, %f62
hwintr_1_131:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_131), 16, 16)) -> intp(1, 0, 1d)
	.word 0x879521bc  ! 2829: WRPR_TT_I	wrpr	%r20, 0x01bc, %tt
	.word 0xb2a4e11e  ! 2838: SUBcc_I	subcc 	%r19, 0x011e, %r25
	.word 0xb5a488e0  ! 2841: FSUBq	dis not found

	.word 0xbf520000  ! 2844: RDPR_PIL	rdpr	%pil, %r31
	.word 0xb3aa0820  ! 2847: FMOVA	fmovs	%fcc1, %f0, %f25
	.word 0xb7a00560  ! 2850: FSQRTq	fsqrt	
	.word 0xb1354000  ! 2851: SRL_R	srl 	%r21, %r0, %r24
	.word 0xb9a5c960  ! 2853: FMULq	dis not found

	.word 0xb69ca190  ! 2854: XORcc_I	xorcc 	%r18, 0x0190, %r27
	.word 0xbfaa0820  ! 2855: FMOVA	fmovs	%fcc1, %f0, %f31
	.word 0xb9a4c9c0  ! 2856: FDIVd	fdivd	%f50, %f0, %f28
	.word 0x8d942028  ! 2860: WRPR_PSTATE_I	wrpr	%r16, 0x0028, %pstate
	.word 0xbba88820  ! 2863: FMOVLE	fmovs	%fcc1, %f0, %f29
	.word 0xbec461bb  ! 2867: ADDCcc_I	addccc 	%r17, 0x01bb, %r31
	.word 0xbba9c820  ! 2869: FMOVVS	fmovs	%fcc1, %f0, %f29
	.word 0xb0c46107  ! 2874: ADDCcc_I	addccc 	%r17, 0x0107, %r24
	.word 0xbda489a0  ! 2875: FDIVs	fdivs	%f18, %f0, %f30
	.word 0xb285a0c2  ! 2877: ADDcc_I	addcc 	%r22, 0x00c2, %r25
	.word 0xb9a84820  ! 2884: FMOVE	fmovs	%fcc1, %f0, %f28
hwintr_1_132:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_132), 16, 16)) -> intp(1, 0, d)
	.word 0x8195207e  ! 2886: WRPR_TPC_I	wrpr	%r20, 0x007e, %tpc
hwintr_1_133:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_133), 16, 16)) -> intp(1, 0, 1d)
	.word 0xbfab8820  ! 2891: FMOVPOS	fmovs	%fcc1, %f0, %f31
	.word 0xbb500000  ! 2892: RDPR_TPC	<illegal instruction>
	.word 0x8d9521aa  ! 2894: WRPR_PSTATE_I	wrpr	%r20, 0x01aa, %pstate
	.word 0xbe8c604f  ! 2897: ANDcc_I	andcc 	%r17, 0x004f, %r31
	.word 0x8d95e0c3  ! 2898: WRPR_PSTATE_I	wrpr	%r23, 0x00c3, %pstate
	.word 0xb5520000  ! 2899: RDPR_PIL	<illegal instruction>
	ldda	[%r19 + %g0] 0xf0, %f2
	.word 0xbb508000  ! 2907: RDPR_TSTATE	<illegal instruction>
hwintr_1_134:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_134), 16, 16)) -> intp(1, 0, 34)
	.word 0xb3a00560  ! 2913: FSQRTq	fsqrt	
	.word 0xb7a48940  ! 2917: FMULd	fmuld	%f18, %f0, %f58
	.word 0xb5a80c20  ! 2919: FMOVRLZ	dis not found

	.word 0xb9ab8820  ! 2920: FMOVPOS	fmovs	%fcc1, %f0, %f28
	.word 0xbbab8820  ! 2925: FMOVPOS	fmovs	%fcc1, %f0, %f29
	.word 0xb3aa8820  ! 2927: FMOVG	fmovs	%fcc1, %f0, %f25
	.word 0xb5a80820  ! 2930: FMOVN	fmovs	%fcc1, %f0, %f26
	.word 0xb9a94820  ! 2933: FMOVCS	fmovs	%fcc1, %f0, %f28
	.word 0xb5510000  ! 2936: RDPR_TICK	<illegal instruction>
	.word 0xb9a509a0  ! 2939: FDIVs	fdivs	%f20, %f0, %f28
	mov	0, %r14
	.word 0xa193a000  ! 2940: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	ta	T_CHANGE_HPRIV
	.word 0x8198291b  ! 2941: WRHPR_HPSTATE_I	wrhpr	%r0, 0x091b, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x819839db  ! 2942: WRHPR_HPSTATE_I	wrhpr	%r0, 0x19db, %hpstate
	.word 0xb7a00520  ! 2943: FSQRTs	fsqrt	
	.word 0xbdab8820  ! 2947: FMOVPOS	fmovs	%fcc1, %f0, %f30
	.word 0xbda588c0  ! 2950: FSUBd	fsubd	%f22, %f0, %f30
	.word 0xb13cf001  ! 2951: SRAX_I	srax	%r19, 0x0001, %r24
	.word 0xbba80820  ! 2952: FMOVN	fmovs	%fcc1, %f0, %f29
hwintr_1_135:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_135), 16, 16)) -> intp(1, 0, 7)
	.word 0xbd504000  ! 2956: RDPR_TNPC	<illegal instruction>
	.word 0xb9abc820  ! 2958: FMOVVC	fmovs	%fcc1, %f0, %f28
	.word 0xb3aac820  ! 2962: FMOVGE	fmovs	%fcc1, %f0, %f25
hwintr_1_136:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_136), 16, 16)) -> intp(1, 0, 1f)
	.word 0xbda4c8c0  ! 2965: FSUBd	fsubd	%f50, %f0, %f30
	.word 0xb3504000  ! 2969: RDPR_TNPC	<illegal instruction>
	.word 0xbda409a0  ! 2970: FDIVs	fdivs	%f16, %f0, %f30
hwintr_1_137:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_137), 16, 16)) -> intp(1, 0, 6)
	.word 0xbda81420  ! 2974: FMOVRNZ	dis not found

	.word 0xb5ab0820  ! 2976: FMOVGU	fmovs	%fcc1, %f0, %f26
	.word 0xb5a00040  ! 2977: FMOVd	fmovd	%f0, %f26
	ta	T_CHANGE_HPRIV
	.word 0x81982a0b  ! 2978: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a0b, %hpstate
	.word 0xb424a1d6  ! 2980: SUB_I	sub 	%r18, 0x01d6, %r26
	ldda	[%r19 + %g0] 0xf0, %f2
	.word 0xb3508000  ! 2989: RDPR_TSTATE	<illegal instruction>
	.word 0xb7a9c820  ! 2991: FMOVVS	fmovs	%fcc1, %f0, %f27
	.word 0x8994e1c5  ! 2992: WRPR_TICK_I	wrpr	%r19, 0x01c5, %tick
	.word 0xbf510000  ! 2993: RDPR_TICK	<illegal instruction>
	.word 0xb8bda18f  ! 2994: XNORcc_I	xnorcc 	%r22, 0x018f, %r28
	.word 0xb1a4c920  ! 2995: FMULs	fmuls	%f19, %f0, %f24
	.word 0xb5a00020  ! 2998: FMOVs	fmovs	%f0, %f26
	.word 0xbfa44960  ! 2999: FMULq	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x81983903  ! 3000: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1903, %hpstate
	.word 0xb9a40920  ! 3001: FMULs	fmuls	%f16, %f0, %f28
	.word 0xbba50960  ! 3002: FMULq	dis not found

	.word 0xbc356148  ! 3004: ORN_I	orn 	%r21, 0x0148, %r30
hwintr_1_138:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_138), 16, 16)) -> intp(1, 0, 3)
	.word 0xb9520000  ! 3006: RDPR_PIL	<illegal instruction>
	.word 0xb5a488c0  ! 3008: FSUBd	fsubd	%f18, %f0, %f26
	.word 0xbec5c000  ! 3009: ADDCcc_R	addccc 	%r23, %r0, %r31
	ldda	[%r19 + %g0] 0xf0, %f2
	ldda	[%r19 + %g0] 0xf0, %f2
	.word 0xb5aa8820  ! 3012: FMOVG	fmovs	%fcc1, %f0, %f26
	.word 0x81946069  ! 3016: WRPR_TPC_I	wrpr	%r17, 0x0069, %tpc
	.word 0x8394611e  ! 3017: WRPR_TNPC_I	wrpr	%r17, 0x011e, %tnpc
	.word 0xbfa54920  ! 3019: FMULs	fmuls	%f21, %f0, %f31
	.word 0xb9500000  ! 3022: RDPR_TPC	<illegal instruction>
	.word 0xbb520000  ! 3023: RDPR_PIL	<illegal instruction>
	.word 0xb3ab0820  ! 3026: FMOVGU	fmovs	%fcc1, %f0, %f25
	.word 0xb1a00520  ! 3028: FSQRTs	fsqrt	
	.word 0xbfa5c9a0  ! 3033: FDIVs	fdivs	%f23, %f0, %f31
	.word 0xbda588a0  ! 3034: FSUBs	fsubs	%f22, %f0, %f30
	.word 0xb7aa8820  ! 3043: FMOVG	fmovs	%fcc1, %f0, %f27
	.word 0xb9a80c20  ! 3049: FMOVRLZ	dis not found

	.word 0x819561f0  ! 3052: WRPR_TPC_I	wrpr	%r21, 0x01f0, %tpc
	.word 0xbba80820  ! 3053: FMOVRLEZ	fmovs	%fcc1, %f0, %f29
	.word 0xb3504000  ! 3054: RDPR_TNPC	<illegal instruction>
	.word 0xb7508000  ! 3057: RDPR_TSTATE	<illegal instruction>
	.word 0x8995a18f  ! 3071: WRPR_TICK_I	wrpr	%r22, 0x018f, %tick
	.word 0xbba90820  ! 3072: FMOVLEU	fmovs	%fcc1, %f0, %f29
	.word 0xbd7ce401  ! 3074: MOVR_I	movre	%r19, 0x1, %r30
	ldda	[%r19 + %g0] 0xf0, %f2
hwintr_1_139:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_139), 16, 16)) -> intp(1, 0, 1)
	.word 0x8d942194  ! 3078: WRPR_PSTATE_I	wrpr	%r16, 0x0194, %pstate
	mov	0, %r14
	.word 0xa193a000  ! 3083: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb3a589a0  ! 3086: FDIVs	fdivs	%f22, %f0, %f25
	.word 0xb5a00020  ! 3090: FMOVs	fmovs	%f0, %f26
	.word 0x899561e8  ! 3091: WRPR_TICK_I	wrpr	%r21, 0x01e8, %tick
	.word 0xb5aac820  ! 3096: FMOVGE	fmovs	%fcc1, %f0, %f26
	.word 0xbd51c000  ! 3097: RDPR_TL	<illegal instruction>
hwintr_1_140:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_140), 16, 16)) -> intp(1, 0, 8)
	mov	2, %r12
	.word 0x8f932000  ! 3101: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbba488a0  ! 3102: FSUBs	fsubs	%f18, %f0, %f29
	.word 0xb42da017  ! 3106: ANDN_I	andn 	%r22, 0x0017, %r26
	.word 0xbfa84820  ! 3108: FMOVE	fmovs	%fcc1, %f0, %f31
	.word 0xb9a409e0  ! 3113: FDIVq	dis not found

	.word 0xbda40840  ! 3115: FADDd	faddd	%f16, %f0, %f30
hwintr_1_141:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_141), 16, 16)) -> intp(1, 0, 34)
	.word 0xbb7c6401  ! 3121: MOVR_I	movre	%r17, 0x1, %r29
	.word 0xb9a84820  ! 3122: FMOVE	fmovs	%fcc1, %f0, %f28
	.word 0xb3a84820  ! 3123: FMOVE	fmovs	%fcc1, %f0, %f25
	.word 0xb5a409a0  ! 3124: FDIVs	fdivs	%f16, %f0, %f26
	.word 0xb9a81820  ! 3131: FMOVRGZ	fmovs	%fcc3, %f0, %f28
	.word 0xb1a4c9c0  ! 3133: FDIVd	fdivd	%f50, %f0, %f24
	.word 0xb3518000  ! 3135: RDPR_PSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xb9a5c940  ! 3142: FMULd	fmuld	%f54, %f0, %f28
	.word 0xb68420bc  ! 3145: ADDcc_I	addcc 	%r16, 0x00bc, %r27
	.word 0xb37dc400  ! 3146: MOVR_R	movre	%r23, %r0, %r25
	.word 0xb5a549e0  ! 3149: FDIVq	dis not found

	.word 0x8194a023  ! 3152: WRPR_TPC_I	wrpr	%r18, 0x0023, %tpc
	ldda	[%r19 + %g0] 0xf0, %f2
hwintr_1_142:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_142), 16, 16)) -> intp(1, 0, e)
	.word 0xb5ab4820  ! 3162: FMOVCC	fmovs	%fcc1, %f0, %f26
	.word 0xba1c4000  ! 3165: XOR_R	xor 	%r17, %r0, %r29
	.word 0xbf504000  ! 3170: RDPR_TNPC	<illegal instruction>
	.word 0x8d9421e3  ! 3171: WRPR_PSTATE_I	wrpr	%r16, 0x01e3, %pstate
	.word 0xbda58920  ! 3173: FMULs	fmuls	%f22, %f0, %f30
	.word 0xbba00040  ! 3176: FMOVd	fmovd	%f0, %f60
	.word 0xb9ab0820  ! 3177: FMOVGU	fmovs	%fcc1, %f0, %f28
hwintr_1_143:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_143), 16, 16)) -> intp(1, 0, 5)
	.word 0x8d95a0c4  ! 3191: WRPR_PSTATE_I	wrpr	%r22, 0x00c4, %pstate
	.word 0xbba00540  ! 3195: FSQRTd	fsqrt	
	.word 0xb9510000  ! 3196: RDPR_TICK	<illegal instruction>
	.word 0xbda81c20  ! 3197: FMOVRGEZ	dis not found

hwintr_1_144:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_144), 16, 16)) -> intp(1, 0, b)
	.word 0xb1500000  ! 3200: RDPR_TPC	<illegal instruction>
	.word 0xb5aa4820  ! 3202: FMOVNE	fmovs	%fcc1, %f0, %f26
	.word 0xb9a488e0  ! 3205: FSUBq	dis not found

	.word 0xb9a548c0  ! 3207: FSUBd	fsubd	%f52, %f0, %f28
	.word 0xb3a98820  ! 3208: FMOVNEG	fmovs	%fcc1, %f0, %f25
	.word 0xb9a90820  ! 3209: FMOVLEU	fmovs	%fcc1, %f0, %f28
	.word 0xb1a00040  ! 3211: FMOVd	fmovd	%f0, %f24
	.word 0xb3a80820  ! 3212: FMOVN	fmovs	%fcc1, %f0, %f25
	.word 0xbdaac820  ! 3214: FMOVGE	fmovs	%fcc1, %f0, %f30
	.word 0x8794e067  ! 3215: WRPR_TT_I	wrpr	%r19, 0x0067, %tt
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xb7508000  ! 3222: RDPR_TSTATE	<illegal instruction>
	.word 0xbda00540  ! 3227: FSQRTd	fsqrt	
hwintr_1_145:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_145), 16, 16)) -> intp(1, 0, 21)
	.word 0xb7a00540  ! 3230: FSQRTd	fsqrt	
	.word 0xbbab4820  ! 3231: FMOVCC	fmovs	%fcc1, %f0, %f29
	.word 0xb5a80420  ! 3235: FMOVRZ	dis not found

	.word 0xb93de001  ! 3239: SRA_I	sra 	%r23, 0x0001, %r28
	.word 0x8795214a  ! 3241: WRPR_TT_I	wrpr	%r20, 0x014a, %tt
	.word 0xb09c20e3  ! 3245: XORcc_I	xorcc 	%r16, 0x00e3, %r24
	.word 0xb7540000  ! 3247: RDPR_GL	<illegal instruction>
	.word 0x819421cb  ! 3250: WRPR_TPC_I	wrpr	%r16, 0x01cb, %tpc
	.word 0xb9aa8820  ! 3252: FMOVG	fmovs	%fcc1, %f0, %f28
	.word 0xb5a48840  ! 3253: FADDd	faddd	%f18, %f0, %f26
	.word 0xb97cc400  ! 3254: MOVR_R	movre	%r19, %r0, %r28
	.word 0xbba5c8a0  ! 3255: FSUBs	fsubs	%f23, %f0, %f29
	.word 0xb5a98820  ! 3257: FMOVNEG	fmovs	%fcc1, %f0, %f26
	mov	1, %r14
	.word 0xa193a000  ! 3260: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbda489c0  ! 3262: FDIVd	fdivd	%f18, %f0, %f30
	.word 0x8995e1d9  ! 3265: WRPR_TICK_I	wrpr	%r23, 0x01d9, %tick
	.word 0xbfa549c0  ! 3266: FDIVd	fdivd	%f52, %f0, %f62
	.word 0xb5a588e0  ! 3268: FSUBq	dis not found

	mov	0, %r14
	.word 0xa193a000  ! 3269: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbeac0000  ! 3270: ANDNcc_R	andncc 	%r16, %r0, %r31
	ta	T_CHANGE_HPRIV
	.word 0x819828d1  ! 3271: WRHPR_HPSTATE_I	wrhpr	%r0, 0x08d1, %hpstate
	.word 0xb1a5c820  ! 3272: FADDs	fadds	%f23, %f0, %f24
	.word 0xbb51c000  ! 3274: RDPR_TL	<illegal instruction>
hwintr_1_146:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_146), 16, 16)) -> intp(1, 0, 33)
	.word 0x83952062  ! 3278: WRPR_TNPC_I	wrpr	%r20, 0x0062, %tnpc
	.word 0xb9a98820  ! 3280: FMOVNEG	fmovs	%fcc1, %f0, %f28
hwintr_1_147:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_147), 16, 16)) -> intp(1, 0, 16)
hwintr_1_148:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_148), 16, 16)) -> intp(1, 0, 21)
hwintr_1_149:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_149), 16, 16)) -> intp(1, 0, 2f)
hwintr_1_150:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_150), 16, 16)) -> intp(1, 0, 30)
	.word 0xb1a508a0  ! 3295: FSUBs	fsubs	%f20, %f0, %f24
hwintr_1_151:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_151), 16, 16)) -> intp(1, 0, 3e)
hwintr_1_152:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_152), 16, 16)) -> intp(1, 0, f)
	.word 0xb3a448c0  ! 3307: FSUBd	fsubd	%f48, %f0, %f56
	.word 0xb93d4000  ! 3308: SRA_R	sra 	%r21, %r0, %r28
	.word 0xb83da0ed  ! 3310: XNOR_I	xnor 	%r22, 0x00ed, %r28
	.word 0xbfaac820  ! 3312: FMOVGE	fmovs	%fcc1, %f0, %f31
	mov	2, %r12
	.word 0x8f932000  ! 3313: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbb520000  ! 3314: RDPR_PIL	<illegal instruction>
	.word 0xb5520000  ! 3321: RDPR_PIL	<illegal instruction>
	.word 0xbf2c7001  ! 3332: SLLX_I	sllx	%r17, 0x0001, %r31
	.word 0xb7a409e0  ! 3342: FDIVq	dis not found

	.word 0xb9a81420  ! 3348: FMOVRNZ	dis not found

	.word 0xb5a409c0  ! 3349: FDIVd	fdivd	%f16, %f0, %f26
	.word 0xb234203e  ! 3351: ORN_I	orn 	%r16, 0x003e, %r25
	.word 0xbfa00540  ! 3358: FSQRTd	fsqrt	
	.word 0xb9a5c9e0  ! 3362: FDIVq	dis not found

	.word 0xbda00560  ! 3364: FSQRTq	fsqrt	
	ta	T_CHANGE_HPRIV
	.word 0x81982e09  ! 3366: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e09, %hpstate
	.word 0xbfa48960  ! 3369: FMULq	dis not found

	.word 0xb7518000  ! 3371: RDPR_PSTATE	<illegal instruction>
	.word 0xbda81820  ! 3373: FMOVRGZ	fmovs	%fcc3, %f0, %f30
hwintr_1_153:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_153), 16, 16)) -> intp(1, 0, 13)
	.word 0xbfa40960  ! 3375: FMULq	dis not found

	.word 0xbb51c000  ! 3383: RDPR_TL	<illegal instruction>
	.word 0xbba5c8c0  ! 3384: FSUBd	fsubd	%f54, %f0, %f60
	.word 0xbfa50860  ! 3386: FADDq	dis not found

hwintr_1_154:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_154), 16, 16)) -> intp(1, 0, 2a)
	.word 0xb3a54960  ! 3392: FMULq	dis not found

	.word 0xbb540000  ! 3393: RDPR_GL	<illegal instruction>
	.word 0xb3520000  ! 3394: RDPR_PIL	<illegal instruction>
	.word 0xb5a00540  ! 3395: FSQRTd	fsqrt	
	.word 0xb5a80820  ! 3396: FMOVN	fmovs	%fcc1, %f0, %f26
	.word 0xb7a81420  ! 3400: FMOVRNZ	dis not found

	.word 0x85942107  ! 3405: WRPR_TSTATE_I	wrpr	%r16, 0x0107, %tstate
	.word 0xb9a80420  ! 3414: FMOVRZ	dis not found

	.word 0xb1a00560  ! 3417: FSQRTq	fsqrt	
	.word 0xbfa00020  ! 3418: FMOVs	fmovs	%f0, %f31
	.word 0xb3a5c9a0  ! 3419: FDIVs	fdivs	%f23, %f0, %f25
	.word 0xbfa589a0  ! 3420: FDIVs	fdivs	%f22, %f0, %f31
	.word 0x81952178  ! 3423: WRPR_TPC_I	wrpr	%r20, 0x0178, %tpc
	.word 0xb7a54960  ! 3424: FMULq	dis not found

	.word 0xbba448a0  ! 3425: FSUBs	fsubs	%f17, %f0, %f29
	mov	1, %r12
	.word 0x8f932000  ! 3426: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb5a81820  ! 3427: FMOVRGZ	fmovs	%fcc3, %f0, %f26
	.word 0xb135a001  ! 3428: SRL_I	srl 	%r22, 0x0001, %r24
	.word 0xb3540000  ! 3429: RDPR_GL	<illegal instruction>
	.word 0xbfa80820  ! 3431: FMOVRLEZ	fmovs	%fcc1, %f0, %f31
hwintr_1_155:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_155), 16, 16)) -> intp(1, 0, 1c)
hwintr_1_156:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_156), 16, 16)) -> intp(1, 0, 1)
	.word 0xbda8c820  ! 3439: FMOVL	fmovs	%fcc1, %f0, %f30
	mov	2, %r14
	.word 0xa193a000  ! 3440: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb5a98820  ! 3441: FMOVNEG	fmovs	%fcc1, %f0, %f26
	.word 0xbda8c820  ! 3442: FMOVL	fmovs	%fcc1, %f0, %f30
	.word 0xbb34e001  ! 3444: SRL_I	srl 	%r19, 0x0001, %r29
	.word 0xbf2d3001  ! 3446: SLLX_I	sllx	%r20, 0x0001, %r31
hwintr_1_157:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_157), 16, 16)) -> intp(1, 0, 2a)
	.word 0xbf2c1000  ! 3450: SLLX_R	sllx	%r16, %r0, %r31
	.word 0x8194a105  ! 3451: WRPR_TPC_I	wrpr	%r18, 0x0105, %tpc
hwintr_1_158:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_158), 16, 16)) -> intp(1, 0, 21)
	.word 0xb5a00560  ! 3456: FSQRTq	fsqrt	
	.word 0xbba88820  ! 3457: FMOVLE	fmovs	%fcc1, %f0, %f29
hwintr_1_159:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_159), 16, 16)) -> intp(1, 0, 3f)
	.word 0xbf641800  ! 3461: MOVcc_R	<illegal instruction>
	.word 0xb151c000  ! 3466: RDPR_TL	<illegal instruction>
hwintr_1_160:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_160), 16, 16)) -> intp(1, 0, 27)
	.word 0xb04560de  ! 3472: ADDC_I	addc 	%r21, 0x00de, %r24
	.word 0xb5a80420  ! 3477: FMOVRZ	dis not found

	.word 0xbda449a0  ! 3481: FDIVs	fdivs	%f17, %f0, %f30
	.word 0xb5a40920  ! 3483: FMULs	fmuls	%f16, %f0, %f26
hwintr_1_161:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_161), 16, 16)) -> intp(1, 0, 8)
	ldda	[%r18 + %g0] 0xf0, %f2
hwintr_1_162:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_162), 16, 16)) -> intp(1, 0, 10)
	ta	T_CHANGE_HPRIV
	.word 0x819838cb  ! 3498: WRHPR_HPSTATE_I	wrhpr	%r0, 0x18cb, %hpstate
	.word 0xb2a54000  ! 3500: SUBcc_R	subcc 	%r21, %r0, %r25
	.word 0xbda80c20  ! 3501: FMOVRLZ	dis not found

	.word 0xb5a88820  ! 3502: FMOVLE	fmovs	%fcc1, %f0, %f26
hwintr_1_163:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_163), 16, 16)) -> intp(1, 0, 38)
	ldda	[%r18 + %g0] 0xf0, %f2
	.word 0xbba4c8a0  ! 3508: FSUBs	fsubs	%f19, %f0, %f29
	.word 0xb7518000  ! 3509: RDPR_PSTATE	<illegal instruction>
	ldda	[%r18 + %g0] 0xf0, %f2
	.word 0xbfa508c0  ! 3518: FSUBd	fsubd	%f20, %f0, %f62
	.word 0xbc342113  ! 3520: ORN_I	orn 	%r16, 0x0113, %r30
	.word 0xb5a80820  ! 3522: FMOVRLEZ	fmovs	%fcc1, %f0, %f26
	.word 0xb3a4c920  ! 3525: FMULs	fmuls	%f19, %f0, %f25
	.word 0xb9a508c0  ! 3528: FSUBd	fsubd	%f20, %f0, %f28
	.word 0xb5a40960  ! 3532: FMULq	dis not found

	.word 0xb7a00540  ! 3535: FSQRTd	fsqrt	
	ta	T_CHANGE_HPRIV
	.word 0x81982953  ! 3540: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0953, %hpstate
	.word 0xbda448e0  ! 3544: FSUBq	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x81982b91  ! 3545: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b91, %hpstate
	.word 0xb1ab8820  ! 3546: FMOVPOS	fmovs	%fcc1, %f0, %f24
	.word 0x8794a067  ! 3547: WRPR_TT_I	wrpr	%r18, 0x0067, %tt
	.word 0xba948000  ! 3550: ORcc_R	orcc 	%r18, %r0, %r29
	.word 0xb7a00520  ! 3552: FSQRTs	fsqrt	
	.word 0xb3a589c0  ! 3554: FDIVd	fdivd	%f22, %f0, %f56
	.word 0xbda00560  ! 3556: FSQRTq	fsqrt	
	.word 0xb1a8c820  ! 3557: FMOVL	fmovs	%fcc1, %f0, %f24
hwintr_1_164:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_164), 16, 16)) -> intp(1, 0, 2f)
	.word 0xb1a81420  ! 3560: FMOVRNZ	dis not found

	.word 0xb1a8c820  ! 3564: FMOVL	fmovs	%fcc1, %f0, %f24
	.word 0xbfa44940  ! 3567: FMULd	fmuld	%f48, %f0, %f62
	.word 0xb3a00040  ! 3569: FMOVd	fmovd	%f0, %f56
	.word 0xbba50940  ! 3572: FMULd	fmuld	%f20, %f0, %f60
	.word 0xbfa88820  ! 3578: FMOVLE	fmovs	%fcc1, %f0, %f31
	.word 0x9195a1a8  ! 3580: WRPR_PIL_I	wrpr	%r22, 0x01a8, %pil
hwintr_1_165:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_165), 16, 16)) -> intp(1, 0, 1e)
	.word 0xbd3cd000  ! 3593: SRAX_R	srax	%r19, %r0, %r30
	.word 0xb3a488a0  ! 3594: FSUBs	fsubs	%f18, %f0, %f25
	.word 0xb9abc820  ! 3595: FMOVVC	fmovs	%fcc1, %f0, %f28
	.word 0xb5a54960  ! 3596: FMULq	dis not found

	.word 0xb7a48840  ! 3597: FADDd	faddd	%f18, %f0, %f58
	.word 0xbb504000  ! 3600: RDPR_TNPC	<illegal instruction>
	.word 0xbba589e0  ! 3603: FDIVq	dis not found

	.word 0xb285a0d1  ! 3604: ADDcc_I	addcc 	%r22, 0x00d1, %r25
	.word 0xbda449e0  ! 3605: FDIVq	dis not found

	.word 0xb9a50940  ! 3613: FMULd	fmuld	%f20, %f0, %f28
	.word 0xb5a00540  ! 3617: FSQRTd	fsqrt	
	.word 0xb7a80820  ! 3620: FMOVN	fmovs	%fcc1, %f0, %f27
	.word 0xbb520000  ! 3624: RDPR_PIL	<illegal instruction>
	.word 0xb7a9c820  ! 3627: FMOVVS	fmovs	%fcc1, %f0, %f27
	.word 0xb7a44860  ! 3629: FADDq	dis not found

hwintr_1_166:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_166), 16, 16)) -> intp(1, 0, 3e)
	.word 0xbfab4820  ! 3634: FMOVCC	fmovs	%fcc1, %f0, %f31
	.word 0xbfa50820  ! 3635: FADDs	fadds	%f20, %f0, %f31
	ta	T_CHANGE_HPRIV
	.word 0x81983b41  ! 3636: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b41, %hpstate
	.word 0xb1a81420  ! 3637: FMOVRNZ	dis not found

	.word 0xb3a54840  ! 3640: FADDd	faddd	%f52, %f0, %f56
	.word 0xbda00540  ! 3641: FSQRTd	fsqrt	
	.word 0xbeb50000  ! 3652: ORNcc_R	orncc 	%r20, %r0, %r31
	.word 0xb9510000  ! 3657: RDPR_TICK	<illegal instruction>
	.word 0xb1a48920  ! 3658: FMULs	fmuls	%f18, %f0, %f24
	.word 0xb3a81420  ! 3659: FMOVRNZ	dis not found

	.word 0xbda00560  ! 3660: FSQRTq	fsqrt	
	.word 0xb9359000  ! 3664: SRLX_R	srlx	%r22, %r0, %r28
	.word 0xb7a90820  ! 3669: FMOVLEU	fmovs	%fcc1, %f0, %f27
	.word 0xbba98820  ! 3673: FMOVNEG	fmovs	%fcc1, %f0, %f29
	.word 0xb7a408a0  ! 3676: FSUBs	fsubs	%f16, %f0, %f27
	.word 0xb7a00560  ! 3677: FSQRTq	fsqrt	
	.word 0xbda488e0  ! 3678: FSUBq	dis not found

	.word 0xb6bdc000  ! 3681: XNORcc_R	xnorcc 	%r23, %r0, %r27
	.word 0xb3ab8820  ! 3682: FMOVPOS	fmovs	%fcc1, %f0, %f25
hwintr_1_167:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_167), 16, 16)) -> intp(1, 0, 8)
	.word 0xb03d4000  ! 3684: XNOR_R	xnor 	%r21, %r0, %r24
hwintr_1_168:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_168), 16, 16)) -> intp(1, 0, 8)
	.word 0xb1a509a0  ! 3688: FDIVs	fdivs	%f20, %f0, %f24
	.word 0xb9a4c8c0  ! 3690: FSUBd	fsubd	%f50, %f0, %f28
	.word 0x8594a0fd  ! 3691: WRPR_TSTATE_I	wrpr	%r18, 0x00fd, %tstate
	.word 0xb37c0400  ! 3694: MOVR_R	movre	%r16, %r0, %r25
	mov	0, %r14
	.word 0xa193a000  ! 3695: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8195204c  ! 3698: WRPR_TPC_I	wrpr	%r20, 0x004c, %tpc
	.word 0xb5a88820  ! 3699: FMOVLE	fmovs	%fcc1, %f0, %f26
	.word 0xbbaa4820  ! 3701: FMOVNE	fmovs	%fcc1, %f0, %f29
	.word 0xbba589e0  ! 3702: FDIVq	dis not found

	.word 0xb9508000  ! 3704: RDPR_TSTATE	<illegal instruction>
	.word 0xb5504000  ! 3710: RDPR_TNPC	<illegal instruction>
	.word 0xbda54960  ! 3711: FMULq	dis not found

hwintr_1_169:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_169), 16, 16)) -> intp(1, 0, 23)
hwintr_1_170:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_170), 16, 16)) -> intp(1, 0, 6)
	.word 0x83952083  ! 3718: WRPR_TNPC_I	wrpr	%r20, 0x0083, %tnpc
	.word 0xb9a54960  ! 3719: FMULq	dis not found

	.word 0xb7a50920  ! 3720: FMULs	fmuls	%f20, %f0, %f27
hwintr_1_171:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_171), 16, 16)) -> intp(1, 0, 1a)
	.word 0xbda80420  ! 3724: FMOVRZ	dis not found

	.word 0xba2c0000  ! 3734: ANDN_R	andn 	%r16, %r0, %r29
hwintr_1_172:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_172), 16, 16)) -> intp(1, 0, e)
	.word 0xbfa94820  ! 3736: FMOVCS	fmovs	%fcc1, %f0, %f31
	.word 0xb7ab4820  ! 3737: FMOVCC	fmovs	%fcc1, %f0, %f27
	.word 0x899420db  ! 3740: WRPR_TICK_I	wrpr	%r16, 0x00db, %tick
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xb5a449e0  ! 3744: FDIVq	dis not found

	.word 0xb1aa8820  ! 3746: FMOVG	fmovs	%fcc1, %f0, %f24
	.word 0xbf480000  ! 3747: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xb80c4000  ! 3751: AND_R	and 	%r17, %r0, %r28
	.word 0xb5a94820  ! 3753: FMOVCS	fmovs	%fcc1, %f0, %f26
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0x8594a156  ! 3756: WRPR_TSTATE_I	wrpr	%r18, 0x0156, %tstate
	.word 0xbba548a0  ! 3760: FSUBs	fsubs	%f21, %f0, %f29
	.word 0xbda00020  ! 3762: FMOVs	fmovs	%f0, %f30
	.word 0xbfa58820  ! 3763: FADDs	fadds	%f22, %f0, %f31
hwintr_1_173:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_173), 16, 16)) -> intp(1, 0, 12)
	.word 0xb7a94820  ! 3767: FMOVCS	fmovs	%fcc1, %f0, %f27
	.word 0x8d94a1ef  ! 3771: WRPR_PSTATE_I	wrpr	%r18, 0x01ef, %pstate
	.word 0xbb510000  ! 3772: RDPR_TICK	<illegal instruction>
	.word 0x8995e03c  ! 3774: WRPR_TICK_I	wrpr	%r23, 0x003c, %tick
hwintr_1_174:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_174), 16, 16)) -> intp(1, 0, 32)
	.word 0xbfa48820  ! 3779: FADDs	fadds	%f18, %f0, %f31
hwintr_1_175:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_175), 16, 16)) -> intp(1, 0, 3d)
	ta	T_CHANGE_HPRIV
	.word 0x81982fc9  ! 3787: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0fc9, %hpstate
	.word 0xb3a9c820  ! 3788: FMOVVS	fmovs	%fcc1, %f0, %f25
	ta	T_CHANGE_HPRIV
	.word 0x81983ed1  ! 3789: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1ed1, %hpstate
	.word 0xbe0d61a4  ! 3796: AND_I	and 	%r21, 0x01a4, %r31
	.word 0xb7510000  ! 3797: RDPR_TICK	<illegal instruction>
hwintr_1_176:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_176), 16, 16)) -> intp(1, 0, 11)
	.word 0xb53c0000  ! 3802: SRA_R	sra 	%r16, %r0, %r26
	.word 0xbda449a0  ! 3803: FDIVs	fdivs	%f17, %f0, %f30
	.word 0xbfab8820  ! 3808: FMOVPOS	fmovs	%fcc1, %f0, %f31
	.word 0x8d94602d  ! 3809: WRPR_PSTATE_I	wrpr	%r17, 0x002d, %pstate
	.word 0xb3a408a0  ! 3814: FSUBs	fsubs	%f16, %f0, %f25
	.word 0xb1500000  ! 3815: RDPR_TPC	<illegal instruction>
	.word 0xbfa44940  ! 3818: FMULd	fmuld	%f48, %f0, %f62
hwintr_1_177:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_177), 16, 16)) -> intp(1, 0, 1f)
	.word 0xb9a80c20  ! 3820: FMOVRLZ	dis not found

	mov	2, %r12
	.word 0x8f932000  ! 3821: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xb1a8c820  ! 3823: FMOVL	fmovs	%fcc1, %f0, %f24
hwintr_1_178:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_178), 16, 16)) -> intp(1, 0, 20)
	.word 0xbf518000  ! 3830: RDPR_PSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982dd3  ! 3831: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0dd3, %hpstate
	.word 0xb9a98820  ! 3832: FMOVNEG	fmovs	%fcc1, %f0, %f28
	.word 0xb9a00560  ! 3833: FSQRTq	fsqrt	
hwintr_1_179:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_179), 16, 16)) -> intp(1, 0, e)
	.word 0xbba58820  ! 3837: FADDs	fadds	%f22, %f0, %f29
hwintr_1_180:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_180), 16, 16)) -> intp(1, 0, 1)
	.word 0xb68d60f1  ! 3840: ANDcc_I	andcc 	%r21, 0x00f1, %r27
hwintr_1_181:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_181), 16, 16)) -> intp(1, 0, a)
	.word 0xb3a4c8a0  ! 3842: FSUBs	fsubs	%f19, %f0, %f25
hwintr_1_182:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_182), 16, 16)) -> intp(1, 0, 9)
	.word 0xb7a00540  ! 3848: FSQRTd	fsqrt	
	.word 0xb4a48000  ! 3849: SUBcc_R	subcc 	%r18, %r0, %r26
	.word 0xbba8c820  ! 3850: FMOVL	fmovs	%fcc1, %f0, %f29
	.word 0xbfa489a0  ! 3852: FDIVs	fdivs	%f18, %f0, %f31
	.word 0x8995a1bc  ! 3858: WRPR_TICK_I	wrpr	%r22, 0x01bc, %tick
	.word 0xbbaa4820  ! 3859: FMOVNE	fmovs	%fcc1, %f0, %f29
	.word 0xbfa84820  ! 3861: FMOVE	fmovs	%fcc1, %f0, %f31
	ta	T_CHANGE_HPRIV
	.word 0x81982c83  ! 3865: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c83, %hpstate
	.word 0xb4b44000  ! 3868: ORNcc_R	orncc 	%r17, %r0, %r26
	.word 0xbfa48840  ! 3869: FADDd	faddd	%f18, %f0, %f62
	.word 0xb350c000  ! 3872: RDPR_TT	<illegal instruction>
	.word 0xb1a94820  ! 3874: FMOVCS	fmovs	%fcc1, %f0, %f24
	.word 0xb1510000  ! 3877: RDPR_TICK	<illegal instruction>
	.word 0xbb518000  ! 3880: RDPR_PSTATE	<illegal instruction>
	.word 0x9194e12e  ! 3881: WRPR_PIL_I	wrpr	%r19, 0x012e, %pil
	.word 0xb7a80820  ! 3885: FMOVN	fmovs	%fcc1, %f0, %f27
	.word 0xb5a00020  ! 3889: FMOVs	fmovs	%f0, %f26
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xb88ce0f4  ! 3897: ANDcc_I	andcc 	%r19, 0x00f4, %r28
	.word 0xb5a94820  ! 3899: FMOVCS	fmovs	%fcc1, %f0, %f26
	.word 0xbfab0820  ! 3901: FMOVGU	fmovs	%fcc1, %f0, %f31
	.word 0xb9a80820  ! 3903: FMOVRLEZ	fmovs	%fcc1, %f0, %f28
	.word 0xbd520000  ! 3905: RDPR_PIL	<illegal instruction>
	.word 0xb5a489e0  ! 3907: FDIVq	dis not found

	.word 0xb8c46080  ! 3910: ADDCcc_I	addccc 	%r17, 0x0080, %r28
	.word 0xbd3d9000  ! 3911: SRAX_R	srax	%r22, %r0, %r30
	.word 0xb1a88820  ! 3912: FMOVLE	fmovs	%fcc1, %f0, %f24
	.word 0x8195a0ea  ! 3913: WRPR_TPC_I	wrpr	%r22, 0x00ea, %tpc
	.word 0x9195a1b9  ! 3914: WRPR_PIL_I	wrpr	%r22, 0x01b9, %pil
	.word 0xb1504000  ! 3915: RDPR_TNPC	<illegal instruction>
	.word 0xb7a48860  ! 3921: FADDq	dis not found

	.word 0xb7a4c9a0  ! 3923: FDIVs	fdivs	%f19, %f0, %f27
	.word 0xbf504000  ! 3924: RDPR_TNPC	<illegal instruction>
	.word 0xb3a4c9e0  ! 3927: FDIVq	dis not found

	.word 0xb3a88820  ! 3934: FMOVLE	fmovs	%fcc1, %f0, %f25
	.word 0xb6a5e189  ! 3935: SUBcc_I	subcc 	%r23, 0x0189, %r27
	.word 0xb7500000  ! 3937: RDPR_TPC	<illegal instruction>
	.word 0xbda54840  ! 3939: FADDd	faddd	%f52, %f0, %f30
	mov	2, %r14
	.word 0xa193a000  ! 3941: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_1_183:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_183), 16, 16)) -> intp(1, 0, 0)
	.word 0xb3aa4820  ! 3944: FMOVNE	fmovs	%fcc1, %f0, %f25
	.word 0xb7a80820  ! 3945: FMOVN	fmovs	%fcc1, %f0, %f27
	.word 0xb9abc820  ! 3947: FMOVVC	fmovs	%fcc1, %f0, %f28
	.word 0xbc2c4000  ! 3949: ANDN_R	andn 	%r17, %r0, %r30
	.word 0x9195a0ea  ! 3953: WRPR_PIL_I	wrpr	%r22, 0x00ea, %pil
	.word 0xbdaa4820  ! 3955: FMOVNE	fmovs	%fcc1, %f0, %f30
	.word 0xbfaa0820  ! 3958: FMOVA	fmovs	%fcc1, %f0, %f31
	mov	2, %r14
	.word 0xa193a000  ! 3959: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbfa549c0  ! 3960: FDIVd	fdivd	%f52, %f0, %f62
	.word 0xb7aa4820  ! 3961: FMOVNE	fmovs	%fcc1, %f0, %f27
hwintr_1_184:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_184), 16, 16)) -> intp(1, 0, 17)
	.word 0xbf510000  ! 3965: RDPR_TICK	<illegal instruction>
	.word 0xbdab4820  ! 3966: FMOVCC	fmovs	%fcc1, %f0, %f30
	.word 0xbfa94820  ! 3969: FMOVCS	fmovs	%fcc1, %f0, %f31
hwintr_1_185:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_185), 16, 16)) -> intp(1, 0, 0)
	.word 0xbda58860  ! 3976: FADDq	dis not found

	.word 0xb1508000  ! 3979: RDPR_TSTATE	<illegal instruction>
	.word 0xb5a80c20  ! 3982: FMOVRLZ	dis not found

	.word 0xb1a80820  ! 3984: FMOVN	fmovs	%fcc1, %f0, %f24
	.word 0xb3504000  ! 3986: RDPR_TNPC	<illegal instruction>
	.word 0xb3a00560  ! 3988: FSQRTq	fsqrt	
	.word 0x839421b0  ! 3990: WRPR_TNPC_I	wrpr	%r16, 0x01b0, %tnpc
hwintr_1_186:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_186), 16, 16)) -> intp(1, 0, 1d)
	.word 0xbba84820  ! 4001: FMOVE	fmovs	%fcc1, %f0, %f29
	.word 0xbfabc820  ! 4002: FMOVVC	fmovs	%fcc1, %f0, %f31
	.word 0xb20d4000  ! 4003: AND_R	and 	%r21, %r0, %r25
	.word 0xba2da135  ! 4005: ANDN_I	andn 	%r22, 0x0135, %r29
	.word 0xbb500000  ! 4006: RDPR_TPC	<illegal instruction>
	.word 0xb5a81420  ! 4007: FMOVRNZ	dis not found

	.word 0xb5518000  ! 4008: RDPR_PSTATE	<illegal instruction>
	.word 0xbbabc820  ! 4009: FMOVVC	fmovs	%fcc1, %f0, %f29
	.word 0xbfa00540  ! 4010: FSQRTd	fsqrt	
	.word 0xb1540000  ! 4015: RDPR_GL	<illegal instruction>
	.word 0xb43421d6  ! 4017: SUBC_I	orn 	%r16, 0x01d6, %r26
	.word 0xbcbc8000  ! 4020: XNORcc_R	xnorcc 	%r18, %r0, %r30
	.word 0xbd2d8000  ! 4024: SLL_R	sll 	%r22, %r0, %r30
	.word 0xb1ab8820  ! 4028: FMOVPOS	fmovs	%fcc1, %f0, %f24
	.word 0xb7a588c0  ! 4038: FSUBd	fsubd	%f22, %f0, %f58
	.word 0xb5aa8820  ! 4042: FMOVG	fmovs	%fcc1, %f0, %f26
	ta	T_CHANGE_HPRIV
	.word 0x81983d1b  ! 4045: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d1b, %hpstate
	.word 0xba948000  ! 4048: ORcc_R	orcc 	%r18, %r0, %r29
	.word 0xbfa88820  ! 4050: FMOVLE	fmovs	%fcc1, %f0, %f31
	.word 0xb5a98820  ! 4056: FMOVNEG	fmovs	%fcc1, %f0, %f26
	.word 0xb0b44000  ! 4058: SUBCcc_R	orncc 	%r17, %r0, %r24
hwintr_1_187:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_187), 16, 16)) -> intp(1, 0, d)
	.word 0xbf50c000  ! 4063: RDPR_TT	<illegal instruction>
	.word 0x899560ff  ! 4065: WRPR_TICK_I	wrpr	%r21, 0x00ff, %tick
	mov	0, %r14
	.word 0xa193a000  ! 4069: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb751c000  ! 4070: RDPR_TL	<illegal instruction>
hwintr_1_188:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_188), 16, 16)) -> intp(1, 0, 2f)
	.word 0xbfa00560  ! 4078: FSQRTq	fsqrt	
	.word 0xb7a48940  ! 4079: FMULd	fmuld	%f18, %f0, %f58
	.word 0xbba00040  ! 4080: FMOVd	fmovd	%f0, %f60
hwintr_1_189:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_189), 16, 16)) -> intp(1, 0, 3a)
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xbeb44000  ! 4092: ORNcc_R	orncc 	%r17, %r0, %r31
	.word 0xb5a5c9a0  ! 4101: FDIVs	fdivs	%f23, %f0, %f26
	.word 0xb4348000  ! 4102: ORN_R	orn 	%r18, %r0, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81983c43  ! 4104: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c43, %hpstate
hwintr_1_190:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_190), 16, 16)) -> intp(1, 0, a)
	.word 0x8d95e05f  ! 4117: WRPR_PSTATE_I	wrpr	%r23, 0x005f, %pstate
	.word 0xb1a98820  ! 4119: FMOVNEG	fmovs	%fcc1, %f0, %f24
	.word 0xb13d8000  ! 4121: SRA_R	sra 	%r22, %r0, %r24
hwintr_1_191:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_191), 16, 16)) -> intp(1, 0, 30)
hwintr_1_192:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_192), 16, 16)) -> intp(1, 0, f)
	.word 0x8595a15f  ! 4129: WRPR_TSTATE_I	wrpr	%r22, 0x015f, %tstate
	.word 0xbba448e0  ! 4130: FSUBq	dis not found

	.word 0xb9a488e0  ! 4133: FSUBq	dis not found

	.word 0xb015c000  ! 4135: OR_R	or 	%r23, %r0, %r24
hwintr_1_193:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_193), 16, 16)) -> intp(1, 0, 2d)
	.word 0xb9abc820  ! 4138: FMOVVC	fmovs	%fcc1, %f0, %f28
	.word 0xb5a548a0  ! 4140: FSUBs	fsubs	%f21, %f0, %f26
hwintr_1_194:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_194), 16, 16)) -> intp(1, 0, 1b)
	.word 0xbf520000  ! 4144: RDPR_PIL	<illegal instruction>
	.word 0xba344000  ! 4147: SUBC_R	orn 	%r17, %r0, %r29
	.word 0xb1a90820  ! 4148: FMOVLEU	fmovs	%fcc1, %f0, %f24
	.word 0xb5520000  ! 4149: RDPR_PIL	<illegal instruction>
	.word 0xb7a00560  ! 4150: FSQRTq	fsqrt	
hwintr_1_195:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_195), 16, 16)) -> intp(1, 0, 1c)
	.word 0xb7a5c860  ! 4152: FADDq	dis not found

	.word 0xb9a54860  ! 4153: FADDq	dis not found

	.word 0x8594e138  ! 4159: WRPR_TSTATE_I	wrpr	%r19, 0x0138, %tstate
	.word 0xb5a00020  ! 4160: FMOVs	fmovs	%f0, %f26
	.word 0xbfaa0820  ! 4162: FMOVA	fmovs	%fcc1, %f0, %f31
	.word 0xb1a5c940  ! 4163: FMULd	fmuld	%f54, %f0, %f24
	.word 0xb7a5c820  ! 4164: FADDs	fadds	%f23, %f0, %f27
	.word 0xbb510000  ! 4165: RDPR_TICK	<illegal instruction>
	.word 0xb1abc820  ! 4168: FMOVVC	fmovs	%fcc1, %f0, %f24
	.word 0x8595a10d  ! 4174: WRPR_TSTATE_I	wrpr	%r22, 0x010d, %tstate
	.word 0xb6b48000  ! 4179: SUBCcc_R	orncc 	%r18, %r0, %r27
	.word 0xb3a00560  ! 4180: FSQRTq	fsqrt	
	.word 0xb9a00020  ! 4181: FMOVs	fmovs	%f0, %f28
hwintr_1_196:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_196), 16, 16)) -> intp(1, 0, 2f)
hwintr_1_197:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_197), 16, 16)) -> intp(1, 0, b)
hwintr_1_198:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_198), 16, 16)) -> intp(1, 0, 31)
hwintr_1_199:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_199), 16, 16)) -> intp(1, 0, a)
	.word 0xbfa80420  ! 4190: FMOVRZ	dis not found

	.word 0x9194a14c  ! 4192: WRPR_PIL_I	wrpr	%r18, 0x014c, %pil
	.word 0xb1a00520  ! 4195: FSQRTs	fsqrt	
	.word 0xbb518000  ! 4199: RDPR_PSTATE	<illegal instruction>
	.word 0xbd510000  ! 4202: RDPR_TICK	<illegal instruction>
	.word 0xb9a58860  ! 4203: FADDq	dis not found

hwintr_1_200:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_200), 16, 16)) -> intp(1, 0, 31)
	.word 0xbd356001  ! 4205: SRL_I	srl 	%r21, 0x0001, %r30
	.word 0xbfa4c820  ! 4207: FADDs	fadds	%f19, %f0, %f31
	.word 0xb9aac820  ! 4210: FMOVGE	fmovs	%fcc1, %f0, %f28
hwintr_1_201:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_201), 16, 16)) -> intp(1, 0, 14)
hwintr_1_202:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_202), 16, 16)) -> intp(1, 0, 1c)
	.word 0xbda548e0  ! 4219: FSUBq	dis not found

	.word 0xb9a00540  ! 4223: FSQRTd	fsqrt	
	.word 0xbd480000  ! 4224: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0x919421bd  ! 4227: WRPR_PIL_I	wrpr	%r16, 0x01bd, %pil
	.word 0xb5a84820  ! 4228: FMOVE	fmovs	%fcc1, %f0, %f26
	.word 0xbdab8820  ! 4231: FMOVPOS	fmovs	%fcc1, %f0, %f30
hwintr_1_203:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_203), 16, 16)) -> intp(1, 0, 37)
	mov	0, %r12
	.word 0x8f932000  ! 4233: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x8795611e  ! 4238: WRPR_TT_I	wrpr	%r21, 0x011e, %tt
	.word 0xbfa00520  ! 4245: FSQRTs	fsqrt	
	.word 0xb9a84820  ! 4248: FMOVE	fmovs	%fcc1, %f0, %f28
	.word 0xb7a80820  ! 4249: FMOVN	fmovs	%fcc1, %f0, %f27
	.word 0xbda94820  ! 4251: FMOVCS	fmovs	%fcc1, %f0, %f30
hwintr_1_204:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_204), 16, 16)) -> intp(1, 0, 11)
	.word 0xb3a5c8e0  ! 4253: FSUBq	dis not found

	.word 0x8195a0d3  ! 4256: WRPR_TPC_I	wrpr	%r22, 0x00d3, %tpc
	.word 0xbf520000  ! 4260: RDPR_PIL	<illegal instruction>
	.word 0xb1a8c820  ! 4266: FMOVL	fmovs	%fcc1, %f0, %f24
	.word 0xb9a508a0  ! 4267: FSUBs	fsubs	%f20, %f0, %f28
hwintr_1_205:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_205), 16, 16)) -> intp(1, 0, 3a)
	.word 0xb9508000  ! 4269: RDPR_TSTATE	<illegal instruction>
	.word 0xb3a00540  ! 4273: FSQRTd	fsqrt	
hwintr_1_206:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_206), 16, 16)) -> intp(1, 0, 26)
	.word 0xb1a80820  ! 4279: FMOVN	fmovs	%fcc1, %f0, %f24
	.word 0xbfa00520  ! 4283: FSQRTs	fsqrt	
	.word 0xb77d0400  ! 4285: MOVR_R	movre	%r20, %r0, %r27
	.word 0xb9520000  ! 4296: RDPR_PIL	<illegal instruction>
	.word 0xb13cd000  ! 4297: SRAX_R	srax	%r19, %r0, %r24
	.word 0xbba81420  ! 4301: FMOVRNZ	dis not found

	.word 0xbd480000  ! 4304: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	mov	2, %r14
	.word 0xa193a000  ! 4306: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9a589e0  ! 4308: FDIVq	dis not found

	.word 0x899561d2  ! 4309: WRPR_TICK_I	wrpr	%r21, 0x01d2, %tick
	mov	0, %r14
	.word 0xa193a000  ! 4310: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbba00020  ! 4311: FMOVs	fmovs	%f0, %f29
	.word 0xbfaa0820  ! 4315: FMOVA	fmovs	%fcc1, %f0, %f31
	.word 0xb351c000  ! 4316: RDPR_TL	<illegal instruction>
	mov	2, %r12
	.word 0x8f932000  ! 4318: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb9a54940  ! 4322: FMULd	fmuld	%f52, %f0, %f28
	.word 0xb3a80c20  ! 4330: FMOVRLZ	dis not found

	.word 0x8d95a0d1  ! 4332: WRPR_PSTATE_I	wrpr	%r22, 0x00d1, %pstate
	.word 0xb5abc820  ! 4336: FMOVVC	fmovs	%fcc1, %f0, %f26
	.word 0xb7a80c20  ! 4337: FMOVRLZ	dis not found

	.word 0xbda9c820  ! 4338: FMOVVS	fmovs	%fcc1, %f0, %f30
	.word 0xb3a8c820  ! 4340: FMOVL	fmovs	%fcc1, %f0, %f25
	.word 0xb835a1a0  ! 4342: SUBC_I	orn 	%r22, 0x01a0, %r28
	.word 0xb7aa0820  ! 4346: FMOVA	fmovs	%fcc1, %f0, %f27
	mov	1, %r14
	.word 0xa193a000  ! 4347: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb9a548e0  ! 4350: FSUBq	dis not found

	.word 0x879521b8  ! 4351: WRPR_TT_I	wrpr	%r20, 0x01b8, %tt
	.word 0xb7a408a0  ! 4353: FSUBs	fsubs	%f16, %f0, %f27
	.word 0xbb510000  ! 4356: RDPR_TICK	<illegal instruction>
	.word 0xbf508000  ! 4357: RDPR_TSTATE	<illegal instruction>
hwintr_1_207:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_207), 16, 16)) -> intp(1, 0, 26)
	.word 0xbead61aa  ! 4364: ANDNcc_I	andncc 	%r21, 0x01aa, %r31
	.word 0x819460d0  ! 4365: WRPR_TPC_I	wrpr	%r17, 0x00d0, %tpc
hwintr_1_208:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_208), 16, 16)) -> intp(1, 0, 3f)
	.word 0xb9a5c840  ! 4369: FADDd	faddd	%f54, %f0, %f28
	.word 0xbfab8820  ! 4371: FMOVPOS	fmovs	%fcc1, %f0, %f31
	.word 0xbb51c000  ! 4372: RDPR_TL	<illegal instruction>
	.word 0xbba44820  ! 4375: FADDs	fadds	%f17, %f0, %f29
	.word 0xb1a94820  ! 4376: FMOVCS	fmovs	%fcc1, %f0, %f24
	.word 0xb03c60da  ! 4381: XNOR_I	xnor 	%r17, 0x00da, %r24
	mov	0, %r12
	.word 0x8f932000  ! 4383: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb1a00040  ! 4384: FMOVd	fmovd	%f0, %f24
	.word 0xb0a5e047  ! 4385: SUBcc_I	subcc 	%r23, 0x0047, %r24
	.word 0xb3a94820  ! 4388: FMOVCS	fmovs	%fcc1, %f0, %f25
	.word 0xbbaa0820  ! 4395: FMOVA	fmovs	%fcc1, %f0, %f29
	.word 0xb3aac820  ! 4397: FMOVGE	fmovs	%fcc1, %f0, %f25
	.word 0xb9a81420  ! 4401: FMOVRNZ	dis not found

hwintr_1_209:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_209), 16, 16)) -> intp(1, 0, 31)
	.word 0xb5a00040  ! 4404: FMOVd	fmovd	%f0, %f26
	.word 0xb3480000  ! 4406: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
hwintr_1_210:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_210), 16, 16)) -> intp(1, 0, 15)
	.word 0xbe2d4000  ! 4411: ANDN_R	andn 	%r21, %r0, %r31
	.word 0xb3aa8820  ! 4413: FMOVG	fmovs	%fcc1, %f0, %f25
	.word 0xb7a48860  ! 4414: FADDq	dis not found

hwintr_1_211:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_211), 16, 16)) -> intp(1, 0, 24)
	.word 0xb5a488a0  ! 4421: FSUBs	fsubs	%f18, %f0, %f26
hwintr_1_212:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_212), 16, 16)) -> intp(1, 0, 1b)
	.word 0xb4ad0000  ! 4423: ANDNcc_R	andncc 	%r20, %r0, %r26
	ldda	[%r22 + %g0] 0xf0, %f2
	.word 0xb3aac820  ! 4427: FMOVGE	fmovs	%fcc1, %f0, %f25
hwintr_1_213:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_213), 16, 16)) -> intp(1, 0, 1c)
	.word 0xbbaa0820  ! 4432: FMOVA	fmovs	%fcc1, %f0, %f29
	.word 0xbba00540  ! 4433: FSQRTd	fsqrt	
	.word 0xb1a00540  ! 4436: FSQRTd	fsqrt	
	.word 0xbda80420  ! 4438: FMOVRZ	dis not found

	.word 0xb1a409c0  ! 4443: FDIVd	fdivd	%f16, %f0, %f24
	.word 0xb8158000  ! 4444: OR_R	or 	%r22, %r0, %r28
	.word 0xb3a54960  ! 4450: FMULq	dis not found

	.word 0x8d95205b  ! 4451: WRPR_PSTATE_I	wrpr	%r20, 0x005b, %pstate
	.word 0xbda4c840  ! 4452: FADDd	faddd	%f50, %f0, %f30
	.word 0xb49c0000  ! 4453: XORcc_R	xorcc 	%r16, %r0, %r26
	.word 0x9195e0f7  ! 4456: WRPR_PIL_I	wrpr	%r23, 0x00f7, %pil
	.word 0xb5a58920  ! 4458: FMULs	fmuls	%f22, %f0, %f26
	.word 0xbda54960  ! 4460: FMULq	dis not found

	.word 0xbda4c840  ! 4461: FADDd	faddd	%f50, %f0, %f30
	ta	T_CHANGE_HPRIV
	.word 0x81982cc1  ! 4466: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0cc1, %hpstate
hwintr_1_214:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_214), 16, 16)) -> intp(1, 0, c)
	.word 0xb7500000  ! 4476: RDPR_TPC	<illegal instruction>
hwintr_1_215:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_215), 16, 16)) -> intp(1, 0, 27)
	.word 0xbb508000  ! 4480: RDPR_TSTATE	<illegal instruction>
	.word 0xb7518000  ! 4482: RDPR_PSTATE	<illegal instruction>
	.word 0xbba80820  ! 4483: FMOVRLEZ	fmovs	%fcc1, %f0, %f29
	.word 0xbba409a0  ! 4485: FDIVs	fdivs	%f16, %f0, %f29
	.word 0xbfa00560  ! 4486: FSQRTq	fsqrt	
	.word 0xbdaa4820  ! 4487: FMOVNE	fmovs	%fcc1, %f0, %f30
	ta	T_CHANGE_HPRIV
	.word 0x819838db  ! 4490: WRHPR_HPSTATE_I	wrhpr	%r0, 0x18db, %hpstate
	.word 0x8594e16e  ! 4491: WRPR_TSTATE_I	wrpr	%r19, 0x016e, %tstate
	.word 0xb3a00560  ! 4492: FSQRTq	fsqrt	
	.word 0x87942138  ! 4494: WRPR_TT_I	wrpr	%r16, 0x0138, %tt
	.word 0xb1a40860  ! 4495: FADDq	dis not found

	.word 0xbc458000  ! 4497: ADDC_R	addc 	%r22, %r0, %r30
	.word 0xbfab4820  ! 4499: FMOVCC	fmovs	%fcc1, %f0, %f31
	.word 0xbfa5c840  ! 4501: FADDd	faddd	%f54, %f0, %f62
	.word 0xb7a5c840  ! 4502: FADDd	faddd	%f54, %f0, %f58
	.word 0xbfaa8820  ! 4508: FMOVG	fmovs	%fcc1, %f0, %f31
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xb3a9c820  ! 4510: FMOVVS	fmovs	%fcc1, %f0, %f25
	.word 0xbd50c000  ! 4512: RDPR_TT	<illegal instruction>
hwintr_1_216:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_216), 16, 16)) -> intp(1, 0, 11)
	.word 0xb3520000  ! 4516: RDPR_PIL	<illegal instruction>
	.word 0xb5480000  ! 4517: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xbfa88820  ! 4518: FMOVLE	fmovs	%fcc1, %f0, %f31
	.word 0xb1a4c820  ! 4519: FADDs	fadds	%f19, %f0, %f24
	.word 0xb9518000  ! 4523: RDPR_PSTATE	<illegal instruction>
hwintr_1_217:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_217), 16, 16)) -> intp(1, 0, 28)
	.word 0xb7a40840  ! 4525: FADDd	faddd	%f16, %f0, %f58
	.word 0xb72cd000  ! 4526: SLLX_R	sllx	%r19, %r0, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982853  ! 4527: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0853, %hpstate
	.word 0xb7a449c0  ! 4533: FDIVd	fdivd	%f48, %f0, %f58
	.word 0x81952156  ! 4543: WRPR_TPC_I	wrpr	%r20, 0x0156, %tpc
	.word 0xb1510000  ! 4549: RDPR_TICK	<illegal instruction>
hwintr_1_218:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_218), 16, 16)) -> intp(1, 0, 1b)
	.word 0xb7aa4820  ! 4557: FMOVNE	fmovs	%fcc1, %f0, %f27
	.word 0xb7a00520  ! 4558: FSQRTs	fsqrt	
	.word 0xb1510000  ! 4559: RDPR_TICK	<illegal instruction>
hwintr_1_219:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_219), 16, 16)) -> intp(1, 0, 2b)
	.word 0xbd518000  ! 4561: RDPR_PSTATE	<illegal instruction>
	.word 0xbda588a0  ! 4562: FSUBs	fsubs	%f22, %f0, %f30
hwintr_1_220:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_220), 16, 16)) -> intp(1, 0, 10)
	.word 0x8594209a  ! 4567: WRPR_TSTATE_I	wrpr	%r16, 0x009a, %tstate
	.word 0xb2b4a00f  ! 4573: SUBCcc_I	orncc 	%r18, 0x000f, %r25
	.word 0xb9a588e0  ! 4574: FSUBq	dis not found

	.word 0xbda448e0  ! 4576: FSUBq	dis not found

	.word 0xb7a00560  ! 4579: FSQRTq	fsqrt	
	ta	T_CHANGE_HPRIV
	.word 0x81982f51  ! 4580: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f51, %hpstate
	ldda	[%r21 + %g0] 0xf0, %f2
	.word 0x899461c6  ! 4584: WRPR_TICK_I	wrpr	%r17, 0x01c6, %tick
	.word 0xbfa58920  ! 4585: FMULs	fmuls	%f22, %f0, %f31
	.word 0xbba80c20  ! 4586: FMOVRLZ	dis not found

	.word 0xbc256002  ! 4589: SUB_I	sub 	%r21, 0x0002, %r30
	.word 0xbba84820  ! 4594: FMOVE	fmovs	%fcc1, %f0, %f29
	.word 0xb3a84820  ! 4595: FMOVE	fmovs	%fcc1, %f0, %f25
	.word 0xb9a509e0  ! 4596: FDIVq	dis not found

	.word 0xb9a549c0  ! 4597: FDIVd	fdivd	%f52, %f0, %f28
	.word 0x9195e10f  ! 4599: WRPR_PIL_I	wrpr	%r23, 0x010f, %pil
	.word 0xb1a4c8c0  ! 4609: FSUBd	fsubd	%f50, %f0, %f24
hwintr_1_221:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_221), 16, 16)) -> intp(1, 0, 3)
	.word 0x8d95e036  ! 4613: WRPR_PSTATE_I	wrpr	%r23, 0x0036, %pstate
	.word 0xb5a81420  ! 4614: FMOVRNZ	dis not found

	.word 0xb3a50860  ! 4616: FADDq	dis not found

	.word 0xb9a81c20  ! 4617: FMOVRGEZ	dis not found

	.word 0xb7348000  ! 4620: SRL_R	srl 	%r18, %r0, %r27
	.word 0xb9a54960  ! 4622: FMULq	dis not found

	.word 0xbfa409c0  ! 4624: FDIVd	fdivd	%f16, %f0, %f62
	.word 0xba94a057  ! 4625: ORcc_I	orcc 	%r18, 0x0057, %r29
	.word 0xbb51c000  ! 4626: RDPR_TL	<illegal instruction>
	.word 0xb0a40000  ! 4628: SUBcc_R	subcc 	%r16, %r0, %r24
hwintr_1_222:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_222), 16, 16)) -> intp(1, 0, 30)
	.word 0xb1a4c9e0  ! 4630: FDIVq	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x81983b13  ! 4636: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b13, %hpstate
	.word 0xb42c0000  ! 4638: ANDN_R	andn 	%r16, %r0, %r26
	.word 0xb3aa0820  ! 4639: FMOVA	fmovs	%fcc1, %f0, %f25
	ta	T_CHANGE_HPRIV
	.word 0x81982ac1  ! 4645: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0ac1, %hpstate
hwintr_1_223:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_223), 16, 16)) -> intp(1, 0, f)
	.word 0xbfa54920  ! 4650: FMULs	fmuls	%f21, %f0, %f31
	.word 0xb00d8000  ! 4652: AND_R	and 	%r22, %r0, %r24
	mov	2, %r14
	.word 0xa193a000  ! 4653: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb3643801  ! 4654: MOVcc_I	<illegal instruction>
	.word 0xbfa00560  ! 4659: FSQRTq	fsqrt	
	.word 0xbfa00520  ! 4661: FSQRTs	fsqrt	
	.word 0xbe3461c3  ! 4663: SUBC_I	orn 	%r17, 0x01c3, %r31
	mov	0, %r14
	.word 0xa193a000  ! 4669: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb5a40940  ! 4671: FMULd	fmuld	%f16, %f0, %f26
	.word 0xb9a588c0  ! 4673: FSUBd	fsubd	%f22, %f0, %f28
	.word 0xb9a00540  ! 4676: FSQRTd	fsqrt	
	.word 0xbfa44960  ! 4678: FMULq	dis not found

	.word 0xb7a44940  ! 4680: FMULd	fmuld	%f48, %f0, %f58
	.word 0xb09cc000  ! 4681: XORcc_R	xorcc 	%r19, %r0, %r24
	.word 0xb9aac820  ! 4684: FMOVGE	fmovs	%fcc1, %f0, %f28
hwintr_1_224:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_224), 16, 16)) -> intp(1, 0, 1f)
	.word 0xbfaac820  ! 4688: FMOVGE	fmovs	%fcc1, %f0, %f31
	.word 0xb5510000  ! 4692: RDPR_TICK	<illegal instruction>
	.word 0xb2a4a16b  ! 4693: SUBcc_I	subcc 	%r18, 0x016b, %r25
	.word 0xbb50c000  ! 4700: RDPR_TT	<illegal instruction>
	.word 0xb7a98820  ! 4702: FMOVNEG	fmovs	%fcc1, %f0, %f27
	.word 0xb5504000  ! 4705: RDPR_TNPC	<illegal instruction>
	.word 0xb1a00560  ! 4707: FSQRTq	fsqrt	
	.word 0xb9a4c920  ! 4708: FMULs	fmuls	%f19, %f0, %f28
	.word 0xbda448e0  ! 4710: FSUBq	dis not found

	.word 0xb9a00560  ! 4714: FSQRTq	fsqrt	
hwintr_1_225:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_225), 16, 16)) -> intp(1, 0, 28)
	.word 0x89952180  ! 4720: WRPR_TICK_I	wrpr	%r20, 0x0180, %tick
	.word 0xb9520000  ! 4722: RDPR_PIL	<illegal instruction>
	.word 0xb3500000  ! 4724: RDPR_TPC	<illegal instruction>
	.word 0xb494a03c  ! 4727: ORcc_I	orcc 	%r18, 0x003c, %r26
	.word 0xb8bc4000  ! 4731: XNORcc_R	xnorcc 	%r17, %r0, %r28
	.word 0xb5ab4820  ! 4733: FMOVCC	fmovs	%fcc1, %f0, %f26
	ldda	[%r21 + %g0] 0xf0, %f2
	.word 0xbb3d5000  ! 4735: SRAX_R	srax	%r21, %r0, %r29
	.word 0xb9a548a0  ! 4736: FSUBs	fsubs	%f21, %f0, %f28
	.word 0xb285e0af  ! 4744: ADDcc_I	addcc 	%r23, 0x00af, %r25
	.word 0x8d95a012  ! 4745: WRPR_PSTATE_I	wrpr	%r22, 0x0012, %pstate
	.word 0xbda00560  ! 4749: FSQRTq	fsqrt	
	.word 0x9194e0e7  ! 4751: WRPR_PIL_I	wrpr	%r19, 0x00e7, %pil
	.word 0xbba50960  ! 4755: FMULq	dis not found

	.word 0xbba4c940  ! 4756: FMULd	fmuld	%f50, %f0, %f60
	.word 0xb9540000  ! 4758: RDPR_GL	<illegal instruction>
	.word 0xbba50940  ! 4762: FMULd	fmuld	%f20, %f0, %f60
	ta	T_CHANGE_HPRIV
	.word 0x81982c59  ! 4764: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c59, %hpstate
	.word 0xb9a54860  ! 4767: FADDq	dis not found

	mov	1, %r12
	.word 0x8f932000  ! 4773: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbd7da401  ! 4775: MOVR_I	movre	%r22, 0x1, %r30
	.word 0xbf500000  ! 4779: RDPR_TPC	<illegal instruction>
	.word 0xb3520000  ! 4780: RDPR_PIL	<illegal instruction>
	.word 0xba34c000  ! 4781: ORN_R	orn 	%r19, %r0, %r29
	.word 0xbfa44820  ! 4783: FADDs	fadds	%f17, %f0, %f31
	.word 0xb6c5a0d1  ! 4784: ADDCcc_I	addccc 	%r22, 0x00d1, %r27
	.word 0xb9a9c820  ! 4785: FMOVVS	fmovs	%fcc1, %f0, %f28
	.word 0xbfa8c820  ! 4786: FMOVL	fmovs	%fcc1, %f0, %f31
	ldda	[%r21 + %g0] 0xf0, %f2
	.word 0xbfa81420  ! 4788: FMOVRNZ	dis not found

	.word 0x83946126  ! 4790: WRPR_TNPC_I	wrpr	%r17, 0x0126, %tnpc
	.word 0xbc8421e1  ! 4791: ADDcc_I	addcc 	%r16, 0x01e1, %r30
	.word 0xb7a5c940  ! 4792: FMULd	fmuld	%f54, %f0, %f58
hwintr_1_226:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_226), 16, 16)) -> intp(1, 0, 20)
	.word 0xb1a4c9c0  ! 4795: FDIVd	fdivd	%f50, %f0, %f24
	.word 0xb5a58920  ! 4796: FMULs	fmuls	%f22, %f0, %f26
	.word 0xbba5c940  ! 4798: FMULd	fmuld	%f54, %f0, %f60
	.word 0xb1a00020  ! 4799: FMOVs	fmovs	%f0, %f24
hwintr_1_227:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_227), 16, 16)) -> intp(1, 0, 4)
	.word 0x8995a15c  ! 4803: WRPR_TICK_I	wrpr	%r22, 0x015c, %tick
	.word 0xbd518000  ! 4804: RDPR_PSTATE	<illegal instruction>
	.word 0xb5a00560  ! 4805: FSQRTq	fsqrt	
	.word 0xb9a81820  ! 4809: FMOVRGZ	fmovs	%fcc3, %f0, %f28
	.word 0xbfa80420  ! 4822: FMOVRZ	dis not found

	.word 0xbe2dc000  ! 4823: ANDN_R	andn 	%r23, %r0, %r31
	.word 0xb9a00520  ! 4824: FSQRTs	fsqrt	
	.word 0xb7ab8820  ! 4827: FMOVPOS	fmovs	%fcc1, %f0, %f27
	.word 0xb5508000  ! 4831: RDPR_TSTATE	<illegal instruction>
	.word 0xb7a81c20  ! 4832: FMOVRGEZ	dis not found

	.word 0x879461e9  ! 4833: WRPR_TT_I	wrpr	%r17, 0x01e9, %tt
	.word 0xb1a81420  ! 4835: FMOVRNZ	dis not found

	.word 0xb5a5c9a0  ! 4836: FDIVs	fdivs	%f23, %f0, %f26
	.word 0xb12cf001  ! 4841: SLLX_I	sllx	%r19, 0x0001, %r24
	.word 0xba94e076  ! 4844: ORcc_I	orcc 	%r19, 0x0076, %r29
	ta	T_CHANGE_HPRIV
	.word 0x81983b51  ! 4851: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b51, %hpstate
	.word 0xb485a02a  ! 4852: ADDcc_I	addcc 	%r22, 0x002a, %r26
	.word 0xb1a00020  ! 4861: FMOVs	fmovs	%f0, %f24
	ldda	[%r21 + %g0] 0xf0, %f2
	.word 0xb950c000  ! 4863: RDPR_TT	<illegal instruction>
	.word 0xbda80820  ! 4866: FMOVRLEZ	fmovs	%fcc1, %f0, %f30
	.word 0xbb480000  ! 4867: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xb3a00560  ! 4873: FSQRTq	fsqrt	
	.word 0x8994e087  ! 4874: WRPR_TICK_I	wrpr	%r19, 0x0087, %tick
	.word 0xbda5c9a0  ! 4875: FDIVs	fdivs	%f23, %f0, %f30
	.word 0xbfa40920  ! 4876: FMULs	fmuls	%f16, %f0, %f31
hwintr_1_228:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_228), 16, 16)) -> intp(1, 0, 2c)
	.word 0xb3a00020  ! 4878: FMOVs	fmovs	%f0, %f25
	ta	T_CHANGE_HPRIV
	.word 0x81982e43  ! 4879: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e43, %hpstate
hwintr_1_229:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_229), 16, 16)) -> intp(1, 0, 17)
	ldda	[%r21 + %g0] 0xf0, %f2
	.word 0x8395615c  ! 4887: WRPR_TNPC_I	wrpr	%r21, 0x015c, %tnpc
hwintr_1_230:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_230), 16, 16)) -> intp(1, 0, 1e)
	.word 0xba1de027  ! 4892: XOR_I	xor 	%r23, 0x0027, %r29
	.word 0xb7abc820  ! 4895: FMOVVC	fmovs	%fcc1, %f0, %f27
	.word 0xbbaa4820  ! 4898: FMOVNE	fmovs	%fcc1, %f0, %f29
	.word 0xb1aa8820  ! 4901: FMOVG	fmovs	%fcc1, %f0, %f24
hwintr_1_231:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_231), 16, 16)) -> intp(1, 0, 19)
hwintr_1_232:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_232), 16, 16)) -> intp(1, 0, 2d)
	.word 0xb5a00560  ! 4910: FSQRTq	fsqrt	
	.word 0xbda81820  ! 4913: FMOVRGZ	fmovs	%fcc3, %f0, %f30
	.word 0xbc0c4000  ! 4915: AND_R	and 	%r17, %r0, %r30
hwintr_1_233:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_233), 16, 16)) -> intp(1, 0, 2c)
	.word 0xbc8d2172  ! 4923: ANDcc_I	andcc 	%r20, 0x0172, %r30
	.word 0xb9a00040  ! 4928: FMOVd	fmovd	%f0, %f28
	ldda	[%r21 + %g0] 0xf0, %f2
	.word 0xbdabc820  ! 4933: FMOVVC	fmovs	%fcc1, %f0, %f30
	mov	0, %r12
	.word 0x8f932000  ! 4937: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
hwintr_1_234:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_234), 16, 16)) -> intp(1, 0, 3c)
	.word 0xbda90820  ! 4941: FMOVLEU	fmovs	%fcc1, %f0, %f30
hwintr_1_235:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_235), 16, 16)) -> intp(1, 0, 2b)
	.word 0xbba408a0  ! 4944: FSUBs	fsubs	%f16, %f0, %f29
	.word 0xb5a00520  ! 4948: FSQRTs	fsqrt	
	.word 0xb3540000  ! 4957: RDPR_GL	<illegal instruction>
	.word 0xb1a5c8e0  ! 4959: FSUBq	dis not found

	.word 0xb17d2401  ! 4962: MOVR_I	movre	%r20, 0x1, %r24
	.word 0xb9a88820  ! 4963: FMOVLE	fmovs	%fcc1, %f0, %f28
	ldda	[%r19 + %g0] 0xf0, %f2
	.word 0xbda4c960  ! 4967: FMULq	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x81982e13  ! 4969: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e13, %hpstate
	.word 0xb9a509a0  ! 4970: FDIVs	fdivs	%f20, %f0, %f28
	.word 0xbdaa8820  ! 4975: FMOVG	fmovs	%fcc1, %f0, %f30
	.word 0xb1a00040  ! 4977: FMOVd	fmovd	%f0, %f24
	.word 0x8395a0b6  ! 4983: WRPR_TNPC_I	wrpr	%r22, 0x00b6, %tnpc
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xbfa4c9c0  ! 4989: FDIVd	fdivd	%f50, %f0, %f62
	.word 0xb00ca1e8  ! 4990: AND_I	and 	%r18, 0x01e8, %r24
	.word 0xbcbca007  ! 4991: XNORcc_I	xnorcc 	%r18, 0x0007, %r30
	.word 0xbc358000  ! 5001: ORN_R	orn 	%r22, %r0, %r30
	.word 0x8d95e003  ! 5002: WRPR_PSTATE_I	wrpr	%r23, 0x0003, %pstate
	.word 0xbba588e0  ! 5006: FSUBq	dis not found

	mov	0, %r12
	.word 0x8f932000  ! 5007: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_1_236:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_236), 16, 16)) -> intp(1, 0, 2a)
	.word 0xbda54920  ! 5013: FMULs	fmuls	%f21, %f0, %f30
	ta	T_CHANGE_HPRIV
	.word 0x81982a53  ! 5014: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a53, %hpstate
	.word 0xbbab0820  ! 5015: FMOVGU	fmovs	%fcc1, %f0, %f29
	.word 0xbfa40840  ! 5016: FADDd	faddd	%f16, %f0, %f62
	.word 0xb60da182  ! 5018: AND_I	and 	%r22, 0x0182, %r27
	.word 0xbdaa4820  ! 5019: FMOVNE	fmovs	%fcc1, %f0, %f30
	.word 0xb5504000  ! 5020: RDPR_TNPC	<illegal instruction>
	.word 0xbdaac820  ! 5022: FMOVGE	fmovs	%fcc1, %f0, %f30
	.word 0xb1ab4820  ! 5023: FMOVCC	fmovs	%fcc1, %f0, %f24
	.word 0xbba00040  ! 5025: FMOVd	fmovd	%f0, %f60
	.word 0xb1aa0820  ! 5028: FMOVA	fmovs	%fcc1, %f0, %f24
	.word 0xb1a448c0  ! 5031: FSUBd	fsubd	%f48, %f0, %f24
hwintr_1_237:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_237), 16, 16)) -> intp(1, 0, 3f)
	.word 0xb7a509c0  ! 5041: FDIVd	fdivd	%f20, %f0, %f58
	ta	T_CHANGE_HPRIV
	.word 0x81983993  ! 5042: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1993, %hpstate
	.word 0xb750c000  ! 5044: RDPR_TT	<illegal instruction>
	.word 0xb6b58000  ! 5049: SUBCcc_R	orncc 	%r22, %r0, %r27
	.word 0xbfab8820  ! 5050: FMOVPOS	fmovs	%fcc1, %f0, %f31
	.word 0xbe8ca117  ! 5052: ANDcc_I	andcc 	%r18, 0x0117, %r31
	ldda	[%r19 + %g0] 0xf0, %f2
	.word 0xb3aac820  ! 5056: FMOVGE	fmovs	%fcc1, %f0, %f25
	.word 0xb7aac820  ! 5057: FMOVGE	fmovs	%fcc1, %f0, %f27
	.word 0xbba54860  ! 5058: FADDq	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x819828d3  ! 5062: WRHPR_HPSTATE_I	wrhpr	%r0, 0x08d3, %hpstate
	ldda	[%r19 + %g0] 0xf0, %f2
	.word 0xbdaa0820  ! 5066: FMOVA	fmovs	%fcc1, %f0, %f30
	.word 0xb1a8c820  ! 5067: FMOVL	fmovs	%fcc1, %f0, %f24
	.word 0xb3a488e0  ! 5071: FSUBq	dis not found

	.word 0xb7a84820  ! 5075: FMOVE	fmovs	%fcc1, %f0, %f27
	.word 0xb3a449a0  ! 5077: FDIVs	fdivs	%f17, %f0, %f25
	.word 0xb6bda05e  ! 5079: XNORcc_I	xnorcc 	%r22, 0x005e, %r27
	.word 0xbb510000  ! 5081: RDPR_TICK	<illegal instruction>
hwintr_1_238:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_238), 16, 16)) -> intp(1, 0, 5)
	.word 0xb9a5c9c0  ! 5083: FDIVd	fdivd	%f54, %f0, %f28
	.word 0xb1ab8820  ! 5085: FMOVPOS	fmovs	%fcc1, %f0, %f24
	.word 0xb9480000  ! 5087: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xb9a00520  ! 5088: FSQRTs	fsqrt	
	.word 0xb1a589c0  ! 5090: FDIVd	fdivd	%f22, %f0, %f24
	.word 0xb3a90820  ! 5091: FMOVLEU	fmovs	%fcc1, %f0, %f25
	.word 0xb7518000  ! 5093: RDPR_PSTATE	<illegal instruction>
	.word 0xb4ad6075  ! 5094: ANDNcc_I	andncc 	%r21, 0x0075, %r26
	.word 0xb3a94820  ! 5102: FMOVCS	fmovs	%fcc1, %f0, %f25
	.word 0xb5a54960  ! 5103: FMULq	dis not found

	.word 0xb7a54840  ! 5105: FADDd	faddd	%f52, %f0, %f58
	.word 0x8d94a12f  ! 5109: WRPR_PSTATE_I	wrpr	%r18, 0x012f, %pstate
	.word 0xbd2de001  ! 5115: SLL_I	sll 	%r23, 0x0001, %r30
	.word 0xbca56038  ! 5125: SUBcc_I	subcc 	%r21, 0x0038, %r30
	.word 0xbfaa4820  ! 5127: FMOVNE	fmovs	%fcc1, %f0, %f31
hwintr_1_239:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_239), 16, 16)) -> intp(1, 0, 22)
	.word 0xb1abc820  ! 5137: FMOVVC	fmovs	%fcc1, %f0, %f24
	ta	T_CHANGE_HPRIV
	.word 0x81983fdb  ! 5140: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1fdb, %hpstate
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0x89946068  ! 5149: WRPR_TICK_I	wrpr	%r17, 0x0068, %tick
	.word 0x919460bf  ! 5151: WRPR_PIL_I	wrpr	%r17, 0x00bf, %pil
	.word 0xb7a81820  ! 5152: FMOVRGZ	fmovs	%fcc3, %f0, %f27
hwintr_1_240:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_240), 16, 16)) -> intp(1, 0, 16)
	.word 0xb3a80820  ! 5155: FMOVRLEZ	fmovs	%fcc1, %f0, %f25
	.word 0xb1500000  ! 5156: RDPR_TPC	<illegal instruction>
	.word 0xb3ab0820  ! 5158: FMOVGU	fmovs	%fcc1, %f0, %f25
	.word 0xb5a58940  ! 5159: FMULd	fmuld	%f22, %f0, %f26
	mov	2, %r12
	.word 0x8f932000  ! 5163: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb2b520f9  ! 5166: ORNcc_I	orncc 	%r20, 0x00f9, %r25
	.word 0xb5a4c8e0  ! 5169: FSUBq	dis not found

	.word 0x8d95e192  ! 5171: WRPR_PSTATE_I	wrpr	%r23, 0x0192, %pstate
	.word 0xb3a4c840  ! 5172: FADDd	faddd	%f50, %f0, %f56
	.word 0xb0b5e112  ! 5174: ORNcc_I	orncc 	%r23, 0x0112, %r24
	.word 0xb3aa0820  ! 5177: FMOVA	fmovs	%fcc1, %f0, %f25
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xbba488c0  ! 5179: FSUBd	fsubd	%f18, %f0, %f60
	.word 0xb1a9c820  ! 5184: FMOVVS	fmovs	%fcc1, %f0, %f24
hwintr_1_241:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_241), 16, 16)) -> intp(1, 0, a)
	ta	T_CHANGE_HPRIV
	.word 0x81982c19  ! 5191: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c19, %hpstate
	.word 0xbda5c820  ! 5193: FADDs	fadds	%f23, %f0, %f30
	.word 0xb5a81820  ! 5194: FMOVRGZ	fmovs	%fcc3, %f0, %f26
	.word 0xb3508000  ! 5195: RDPR_TSTATE	<illegal instruction>
hwintr_1_242:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_242), 16, 16)) -> intp(1, 0, 7)
	.word 0x8395e0f7  ! 5199: WRPR_TNPC_I	wrpr	%r23, 0x00f7, %tnpc
	.word 0xb3520000  ! 5200: RDPR_PIL	<illegal instruction>
	.word 0xb3a40960  ! 5204: FMULq	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x81983d49  ! 5207: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d49, %hpstate
	.word 0xb9a00540  ! 5209: FSQRTd	fsqrt	
	.word 0xb9a80420  ! 5213: FMOVRZ	dis not found

	mov	1, %r14
	.word 0xa193a000  ! 5215: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb3a00520  ! 5216: FSQRTs	fsqrt	
	.word 0xbda00520  ! 5220: FSQRTs	fsqrt	
	.word 0xb5a488c0  ! 5221: FSUBd	fsubd	%f18, %f0, %f26
	.word 0xbda98820  ! 5224: FMOVNEG	fmovs	%fcc1, %f0, %f30
	.word 0xbf50c000  ! 5226: RDPR_TT	<illegal instruction>
	.word 0xbba589c0  ! 5227: FDIVd	fdivd	%f22, %f0, %f60
	.word 0x8794601f  ! 5228: WRPR_TT_I	wrpr	%r17, 0x001f, %tt
	.word 0xb3a00560  ! 5229: FSQRTq	fsqrt	
	.word 0xb3a408a0  ! 5230: FSUBs	fsubs	%f16, %f0, %f25
	.word 0xb9480000  ! 5231: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
hwintr_1_243:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_243), 16, 16)) -> intp(1, 0, 1c)
	.word 0xb3a00520  ! 5233: FSQRTs	fsqrt	
	.word 0xb7a549c0  ! 5235: FDIVd	fdivd	%f52, %f0, %f58
	.word 0xbba58940  ! 5236: FMULd	fmuld	%f22, %f0, %f60
	.word 0xbda00560  ! 5238: FSQRTq	fsqrt	
	.word 0xb1a00540  ! 5244: FSQRTd	fsqrt	
	.word 0xbe15e18a  ! 5246: OR_I	or 	%r23, 0x018a, %r31
	.word 0xb5a90820  ! 5249: FMOVLEU	fmovs	%fcc1, %f0, %f26
	.word 0xbda408a0  ! 5251: FSUBs	fsubs	%f16, %f0, %f30
	.word 0xb7a4c8e0  ! 5254: FSUBq	dis not found

hwintr_1_244:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_244), 16, 16)) -> intp(1, 0, 1c)
	.word 0x8d95a0c2  ! 5259: WRPR_PSTATE_I	wrpr	%r22, 0x00c2, %pstate
	.word 0x8395a097  ! 5267: WRPR_TNPC_I	wrpr	%r22, 0x0097, %tnpc
	.word 0xbda00560  ! 5268: FSQRTq	fsqrt	
hwintr_1_245:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_245), 16, 16)) -> intp(1, 0, 3f)
	.word 0xb9a549c0  ! 5270: FDIVd	fdivd	%f52, %f0, %f28
	.word 0x899561cd  ! 5271: WRPR_TICK_I	wrpr	%r21, 0x01cd, %tick
hwintr_1_246:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_246), 16, 16)) -> intp(1, 0, 29)
	.word 0xb7a509c0  ! 5283: FDIVd	fdivd	%f20, %f0, %f58
	.word 0xb9a84820  ! 5284: FMOVE	fmovs	%fcc1, %f0, %f28
	.word 0xb9a98820  ! 5286: FMOVNEG	fmovs	%fcc1, %f0, %f28
	.word 0xbb480000  ! 5287: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
hwintr_1_247:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_247), 16, 16)) -> intp(1, 0, 1a)
	.word 0xbfa448c0  ! 5290: FSUBd	fsubd	%f48, %f0, %f62
	.word 0xbdaa4820  ! 5291: FMOVNE	fmovs	%fcc1, %f0, %f30
	.word 0x839460ce  ! 5292: WRPR_TNPC_I	wrpr	%r17, 0x00ce, %tnpc
hwintr_1_248:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_248), 16, 16)) -> intp(1, 0, 26)
	.word 0x8395e021  ! 5294: WRPR_TNPC_I	wrpr	%r23, 0x0021, %tnpc
	ta	T_CHANGE_HPRIV
	.word 0x81983c91  ! 5297: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c91, %hpstate
	.word 0xb7a90820  ! 5299: FMOVLEU	fmovs	%fcc1, %f0, %f27
	.word 0xbba4c940  ! 5301: FMULd	fmuld	%f50, %f0, %f60
	ldda	[%r18 + %g0] 0xf0, %f2
	.word 0xb3a48860  ! 5304: FADDq	dis not found

	.word 0xbba58960  ! 5306: FMULq	dis not found

	.word 0xb7a8c820  ! 5309: FMOVL	fmovs	%fcc1, %f0, %f27
	ta	T_CHANGE_HPRIV
	.word 0x81982c41  ! 5310: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0c41, %hpstate
	.word 0xb1a80820  ! 5311: FMOVRLEZ	fmovs	%fcc1, %f0, %f24
	mov	1, %r12
	.word 0x8f932000  ! 5313: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_1_249:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_249), 16, 16)) -> intp(1, 0, 18)
hwintr_1_250:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_250), 16, 16)) -> intp(1, 0, a)
	.word 0xb7a54840  ! 5322: FADDd	faddd	%f52, %f0, %f58
hwintr_1_251:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_251), 16, 16)) -> intp(1, 0, 2c)
	.word 0xb7500000  ! 5330: RDPR_TPC	<illegal instruction>
	.word 0xbfaac820  ! 5332: FMOVGE	fmovs	%fcc1, %f0, %f31
	.word 0xb3510000  ! 5335: RDPR_TICK	<illegal instruction>
	.word 0xbfa5c9c0  ! 5338: FDIVd	fdivd	%f54, %f0, %f62
	.word 0x91956129  ! 5340: WRPR_PIL_I	wrpr	%r21, 0x0129, %pil
	.word 0x8395618f  ! 5343: WRPR_TNPC_I	wrpr	%r21, 0x018f, %tnpc
	.word 0xb7aa8820  ! 5347: FMOVG	fmovs	%fcc1, %f0, %f27
	.word 0xb5a54860  ! 5349: FADDq	dis not found

	.word 0xb5a4c9c0  ! 5351: FDIVd	fdivd	%f50, %f0, %f26
	.word 0xb9510000  ! 5352: RDPR_TICK	<illegal instruction>
	.word 0xb83cc000  ! 5353: XNOR_R	xnor 	%r19, %r0, %r28
	.word 0xb895a146  ! 5355: ORcc_I	orcc 	%r22, 0x0146, %r28
	.word 0xb635c000  ! 5356: SUBC_R	orn 	%r23, %r0, %r27
	.word 0x839520b6  ! 5357: WRPR_TNPC_I	wrpr	%r20, 0x00b6, %tnpc
	.word 0xb3a00040  ! 5358: FMOVd	fmovd	%f0, %f56
	.word 0xbbaa4820  ! 5359: FMOVNE	fmovs	%fcc1, %f0, %f29
hwintr_1_252:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_252), 16, 16)) -> intp(1, 0, 26)
	.word 0xbfa48840  ! 5362: FADDd	faddd	%f18, %f0, %f62
	.word 0xb7ab4820  ! 5367: FMOVCC	fmovs	%fcc1, %f0, %f27
	.word 0xbf50c000  ! 5369: RDPR_TT	<illegal instruction>
	.word 0xb9a00540  ! 5372: FSQRTd	fsqrt	
	.word 0xb4354000  ! 5373: ORN_R	orn 	%r21, %r0, %r26
	.word 0xb7a81820  ! 5375: FMOVRGZ	fmovs	%fcc3, %f0, %f27
hwintr_1_253:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_253), 16, 16)) -> intp(1, 0, 14)
	.word 0xbba98820  ! 5379: FMOVNEG	fmovs	%fcc1, %f0, %f29
	.word 0xb7a80820  ! 5383: FMOVRLEZ	fmovs	%fcc1, %f0, %f27
	.word 0xb9aac820  ! 5385: FMOVGE	fmovs	%fcc1, %f0, %f28
	.word 0xbba44960  ! 5387: FMULq	dis not found

hwintr_1_254:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_254), 16, 16)) -> intp(1, 0, 27)
	.word 0xbc2cc000  ! 5408: ANDN_R	andn 	%r19, %r0, %r30
	.word 0xbfa408c0  ! 5409: FSUBd	fsubd	%f16, %f0, %f62
	.word 0xb1480000  ! 5410: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xbdab0820  ! 5412: FMOVGU	fmovs	%fcc1, %f0, %f30
	.word 0xbdaa8820  ! 5413: FMOVG	fmovs	%fcc1, %f0, %f30
	.word 0xbd510000  ! 5414: RDPR_TICK	<illegal instruction>
	.word 0xbfab8820  ! 5418: FMOVPOS	fmovs	%fcc1, %f0, %f31
	.word 0xb5a488e0  ! 5419: FSUBq	dis not found

	.word 0xb1a58940  ! 5420: FMULd	fmuld	%f22, %f0, %f24
	.word 0xb7a5c920  ! 5423: FMULs	fmuls	%f23, %f0, %f27
	.word 0xb1a00560  ! 5427: FSQRTq	fsqrt	
	.word 0xb5510000  ! 5429: RDPR_TICK	<illegal instruction>
	.word 0xb1a90820  ! 5432: FMOVLEU	fmovs	%fcc1, %f0, %f24
	.word 0xb7a509a0  ! 5433: FDIVs	fdivs	%f20, %f0, %f27
	.word 0xb5508000  ! 5434: RDPR_TSTATE	<illegal instruction>
	.word 0xbb518000  ! 5437: RDPR_PSTATE	<illegal instruction>
	.word 0x8994a100  ! 5441: WRPR_TICK_I	wrpr	%r18, 0x0100, %tick
	.word 0xbda00020  ! 5442: FMOVs	fmovs	%f0, %f30
	.word 0xb13dc000  ! 5446: SRA_R	sra 	%r23, %r0, %r24
	.word 0xb1a80820  ! 5449: FMOVRLEZ	fmovs	%fcc1, %f0, %f24
	.word 0xbd520000  ! 5451: RDPR_PIL	<illegal instruction>
	.word 0xb7a80420  ! 5452: FMOVRZ	dis not found

	.word 0xbda80c20  ! 5457: FMOVRLZ	dis not found

	.word 0xbdaac820  ! 5459: FMOVGE	fmovs	%fcc1, %f0, %f30
	.word 0xbfa5c920  ! 5460: FMULs	fmuls	%f23, %f0, %f31
	.word 0xb1a549c0  ! 5463: FDIVd	fdivd	%f52, %f0, %f24
	.word 0xbda48820  ! 5468: FADDs	fadds	%f18, %f0, %f30
	.word 0xb5a00560  ! 5476: FSQRTq	fsqrt	
	.word 0xb02de137  ! 5478: ANDN_I	andn 	%r23, 0x0137, %r24
hwintr_1_255:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_255), 16, 16)) -> intp(1, 0, 23)
	.word 0xb3508000  ! 5483: RDPR_TSTATE	<illegal instruction>
	.word 0xb1a508c0  ! 5484: FSUBd	fsubd	%f20, %f0, %f24
	.word 0xbda00520  ! 5486: FSQRTs	fsqrt	
	ldda	[%r20 + %g0] 0xf0, %f2
	.word 0xbba5c8c0  ! 5496: FSUBd	fsubd	%f54, %f0, %f60
	.word 0xb9a50840  ! 5500: FADDd	faddd	%f20, %f0, %f28
	.word 0xbc84200c  ! 5501: ADDcc_I	addcc 	%r16, 0x000c, %r30
	.word 0x9195e0cf  ! 5503: WRPR_PIL_I	wrpr	%r23, 0x00cf, %pil
	.word 0xb02dc000  ! 5506: ANDN_R	andn 	%r23, %r0, %r24
	.word 0xb1a00020  ! 5507: FMOVs	fmovs	%f0, %f24
	ta	T_CHANGE_HPRIV
	.word 0x81983d4b  ! 5510: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d4b, %hpstate
	.word 0xbfa54820  ! 5514: FADDs	fadds	%f21, %f0, %f31
	.word 0xb7500000  ! 5518: RDPR_TPC	<illegal instruction>
	.word 0xb7a58860  ! 5520: FADDq	dis not found

	.word 0xbd518000  ! 5522: RDPR_PSTATE	<illegal instruction>
	.word 0xb1480000  ! 5525: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xbda8c820  ! 5526: FMOVL	fmovs	%fcc1, %f0, %f30
	.word 0xb3a00020  ! 5527: FMOVs	fmovs	%f0, %f25
	ta	T_CHANGE_HPRIV
	.word 0x81983b53  ! 5531: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b53, %hpstate
	.word 0xb7a54820  ! 5532: FADDs	fadds	%f21, %f0, %f27
	.word 0xbdab0820  ! 5539: FMOVGU	fmovs	%fcc1, %f0, %f30
	.word 0xbba00520  ! 5542: FSQRTs	fsqrt	
	.word 0xbfaac820  ! 5543: FMOVGE	fmovs	%fcc1, %f0, %f31
	ldda	[%r20 + %g0] 0xf0, %f2
	.word 0xb1abc820  ! 5545: FMOVVC	fmovs	%fcc1, %f0, %f24
	.word 0xb9a508a0  ! 5546: FSUBs	fsubs	%f20, %f0, %f28
	.word 0x8d95e179  ! 5548: WRPR_PSTATE_I	wrpr	%r23, 0x0179, %pstate
	.word 0x8d9560f1  ! 5551: WRPR_PSTATE_I	wrpr	%r21, 0x00f1, %pstate
	.word 0xb1a80420  ! 5552: FMOVRZ	dis not found

	.word 0xbda00040  ! 5553: FMOVd	fmovd	%f0, %f30
	.word 0xbd504000  ! 5555: RDPR_TNPC	<illegal instruction>
	.word 0xb3a58920  ! 5556: FMULs	fmuls	%f22, %f0, %f25
	.word 0xb1a00040  ! 5557: FMOVd	fmovd	%f0, %f24
	.word 0xb1a509e0  ! 5559: FDIVq	dis not found

hwintr_1_256:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_256), 16, 16)) -> intp(1, 0, 16)
	.word 0xbba81420  ! 5570: FMOVRNZ	dis not found

	.word 0xb1508000  ! 5573: RDPR_TSTATE	<illegal instruction>
	.word 0xb41c20bd  ! 5579: XOR_I	xor 	%r16, 0x00bd, %r26
	.word 0xbd35b001  ! 5580: SRLX_I	srlx	%r22, 0x0001, %r30
	.word 0xb9aa8820  ! 5583: FMOVG	fmovs	%fcc1, %f0, %f28
	.word 0xb1a548e0  ! 5584: FSUBq	dis not found

	mov	1, %r14
	.word 0xa193a000  ! 5585: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0x8d94a18f  ! 5588: WRPR_PSTATE_I	wrpr	%r18, 0x018f, %pstate
	.word 0xb3a84820  ! 5593: FMOVE	fmovs	%fcc1, %f0, %f25
	.word 0xb751c000  ! 5598: RDPR_TL	<illegal instruction>
	.word 0xbba00020  ! 5599: FMOVs	fmovs	%f0, %f29
	mov	1, %r14
	.word 0xa193a000  ! 5607: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb1a81420  ! 5611: FMOVRNZ	dis not found

	.word 0xb3a589e0  ! 5612: FDIVq	dis not found

	.word 0xb3504000  ! 5613: RDPR_TNPC	<illegal instruction>
	.word 0xbdaa0820  ! 5614: FMOVA	fmovs	%fcc1, %f0, %f30
	.word 0xb1a40820  ! 5617: FADDs	fadds	%f16, %f0, %f24
	.word 0xb3a44940  ! 5619: FMULd	fmuld	%f48, %f0, %f56
	.word 0xb72d4000  ! 5624: SLL_R	sll 	%r21, %r0, %r27
	.word 0xb72c3001  ! 5626: SLLX_I	sllx	%r16, 0x0001, %r27
	.word 0xbb2c9000  ! 5629: SLLX_R	sllx	%r18, %r0, %r29
	.word 0xbf540000  ! 5630: RDPR_GL	<illegal instruction>
	.word 0xb1504000  ! 5640: RDPR_TNPC	<illegal instruction>
	.word 0xb7518000  ! 5642: RDPR_PSTATE	<illegal instruction>
	.word 0xbdaa8820  ! 5645: FMOVG	fmovs	%fcc1, %f0, %f30
	.word 0xb3a8c820  ! 5647: FMOVL	fmovs	%fcc1, %f0, %f25
	.word 0x85946055  ! 5648: WRPR_TSTATE_I	wrpr	%r17, 0x0055, %tstate
	.word 0xb1480000  ! 5649: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xb77c4400  ! 5650: MOVR_R	movre	%r17, %r0, %r27
	mov	1, %r12
	.word 0x8f932000  ! 5651: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb9a8c820  ! 5654: FMOVL	fmovs	%fcc1, %f0, %f28
	.word 0xb6950000  ! 5658: ORcc_R	orcc 	%r20, %r0, %r27
	.word 0xb5a54960  ! 5664: FMULq	dis not found

	.word 0xbba54860  ! 5665: FADDq	dis not found

	.word 0xbfa44820  ! 5666: FADDs	fadds	%f17, %f0, %f31
	.word 0x9195603d  ! 5667: WRPR_PIL_I	wrpr	%r21, 0x003d, %pil
	.word 0xbc3dc000  ! 5672: XNOR_R	xnor 	%r23, %r0, %r30
	.word 0xbda80820  ! 5676: FMOVRLEZ	fmovs	%fcc1, %f0, %f30
	.word 0xb1a88820  ! 5677: FMOVLE	fmovs	%fcc1, %f0, %f24
	.word 0x819460f6  ! 5679: WRPR_TPC_I	wrpr	%r17, 0x00f6, %tpc
	.word 0xb1a81420  ! 5681: FMOVRNZ	dis not found

	.word 0xbba4c940  ! 5682: FMULd	fmuld	%f50, %f0, %f60
hwintr_1_257:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_257), 16, 16)) -> intp(1, 0, 8)
	.word 0xbda00540  ! 5685: FSQRTd	fsqrt	
	.word 0xb3a80420  ! 5686: FMOVRZ	dis not found

	ldda	[%r20 + %g0] 0xf0, %f2
	ta	T_CHANGE_HPRIV
	.word 0x81982f1b  ! 5688: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0f1b, %hpstate
	.word 0xbb540000  ! 5691: RDPR_GL	<illegal instruction>
	.word 0xbfa98820  ! 5693: FMOVNEG	fmovs	%fcc1, %f0, %f31
hwintr_1_258:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_258), 16, 16)) -> intp(1, 0, 1d)
	.word 0xb8848000  ! 5696: ADDcc_R	addcc 	%r18, %r0, %r28
	.word 0xb7a00540  ! 5697: FSQRTd	fsqrt	
	.word 0xbba54820  ! 5704: FADDs	fadds	%f21, %f0, %f29
	.word 0xb3a4c840  ! 5705: FADDd	faddd	%f50, %f0, %f56
	.word 0xb150c000  ! 5707: RDPR_TT	<illegal instruction>
	.word 0xbb518000  ! 5708: RDPR_PSTATE	<illegal instruction>
	.word 0xb5a58920  ! 5710: FMULs	fmuls	%f22, %f0, %f26
	.word 0xb3a5c8c0  ! 5711: FSUBd	fsubd	%f54, %f0, %f56
	.word 0xbbab0820  ! 5713: FMOVGU	fmovs	%fcc1, %f0, %f29
	.word 0xb5a4c9a0  ! 5715: FDIVs	fdivs	%f19, %f0, %f26
	.word 0xb5a90820  ! 5717: FMOVLEU	fmovs	%fcc1, %f0, %f26
	.word 0xbba90820  ! 5722: FMOVLEU	fmovs	%fcc1, %f0, %f29
hwintr_1_259:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_259), 16, 16)) -> intp(1, 0, 1f)
	.word 0xb1a00560  ! 5725: FSQRTq	fsqrt	
hwintr_1_260:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_260), 16, 16)) -> intp(1, 0, 31)
	.word 0xb9ab8820  ! 5731: FMOVPOS	fmovs	%fcc1, %f0, %f28
	mov	1, %r12
	.word 0x8f932000  ! 5732: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbda90820  ! 5733: FMOVLEU	fmovs	%fcc1, %f0, %f30
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xbe3c6035  ! 5738: XNOR_I	xnor 	%r17, 0x0035, %r31
	.word 0xbd500000  ! 5742: RDPR_TPC	<illegal instruction>
hwintr_1_261:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_261), 16, 16)) -> intp(1, 0, a)
	.word 0xbda489e0  ! 5744: FDIVq	dis not found

	.word 0xbfaa8820  ! 5749: FMOVG	fmovs	%fcc1, %f0, %f31
	.word 0xb1518000  ! 5752: RDPR_PSTATE	<illegal instruction>
	.word 0xb1abc820  ! 5755: FMOVVC	fmovs	%fcc1, %f0, %f24
	.word 0xb9ab8820  ! 5756: FMOVPOS	fmovs	%fcc1, %f0, %f28
	.word 0xb5aa4820  ! 5757: FMOVNE	fmovs	%fcc1, %f0, %f26
	.word 0xbd480000  ! 5767: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	mov	2, %r12
	.word 0x8f932000  ! 5769: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb7a40960  ! 5770: FMULq	dis not found

	.word 0xb7508000  ! 5771: RDPR_TSTATE	<illegal instruction>
	.word 0xbbabc820  ! 5776: FMOVVC	fmovs	%fcc1, %f0, %f29
	.word 0xb1a5c960  ! 5780: FMULq	dis not found

hwintr_1_262:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_262), 16, 16)) -> intp(1, 0, 1a)
hwintr_1_263:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_263), 16, 16)) -> intp(1, 0, 0)
	.word 0x8994a195  ! 5783: WRPR_TICK_I	wrpr	%r18, 0x0195, %tick
	.word 0x8594a17f  ! 5784: WRPR_TSTATE_I	wrpr	%r18, 0x017f, %tstate
	.word 0x8395e0e9  ! 5785: WRPR_TNPC_I	wrpr	%r23, 0x00e9, %tnpc
	.word 0xb9a00020  ! 5787: FMOVs	fmovs	%f0, %f28
	.word 0xb1ab0820  ! 5788: FMOVGU	fmovs	%fcc1, %f0, %f24
	.word 0xb9a5c820  ! 5789: FADDs	fadds	%f23, %f0, %f28
	.word 0xbd3c4000  ! 5794: SRA_R	sra 	%r17, %r0, %r30
hwintr_1_264:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_264), 16, 16)) -> intp(1, 0, 2f)
	.word 0xb7a548a0  ! 5806: FSUBs	fsubs	%f21, %f0, %f27
	.word 0xb5a80820  ! 5810: FMOVN	fmovs	%fcc1, %f0, %f26
	.word 0xbb520000  ! 5811: RDPR_PIL	<illegal instruction>
	.word 0xbdab8820  ! 5812: FMOVPOS	fmovs	%fcc1, %f0, %f30
	.word 0xb1a40860  ! 5813: FADDq	dis not found

	.word 0xb7a81420  ! 5817: FMOVRNZ	dis not found

	ldda	[%r20 + %g0] 0xf0, %f2
	.word 0xb3aa8820  ! 5822: FMOVG	fmovs	%fcc1, %f0, %f25
	.word 0xbea56073  ! 5824: SUBcc_I	subcc 	%r21, 0x0073, %r31
	.word 0xbba548e0  ! 5826: FSUBq	dis not found

	.word 0xb3a44820  ! 5827: FADDs	fadds	%f17, %f0, %f25
	.word 0xbd35c000  ! 5829: SRL_R	srl 	%r23, %r0, %r30
	.word 0xb035c000  ! 5832: ORN_R	orn 	%r23, %r0, %r24
	.word 0xb13d9000  ! 5833: SRAX_R	srax	%r22, %r0, %r24
	ldda	[%r20 + %g0] 0xf0, %f2
	.word 0xb550c000  ! 5838: RDPR_TT	<illegal instruction>
	.word 0x8795a189  ! 5840: WRPR_TT_I	wrpr	%r22, 0x0189, %tt
	.word 0xb1a98820  ! 5843: FMOVNEG	fmovs	%fcc1, %f0, %f24
	.word 0xb9a80420  ! 5847: FMOVRZ	dis not found

	.word 0xbd500000  ! 5848: RDPR_TPC	<illegal instruction>
	.word 0xb9a00520  ! 5850: FSQRTs	fsqrt	
	.word 0xb7a9c820  ! 5852: FMOVVS	fmovs	%fcc1, %f0, %f27
	.word 0x8994617f  ! 5855: WRPR_TICK_I	wrpr	%r17, 0x017f, %tick
	.word 0xb9a50940  ! 5859: FMULd	fmuld	%f20, %f0, %f28
	.word 0xb1508000  ! 5860: RDPR_TSTATE	<illegal instruction>
	mov	0, %r14
	.word 0xa193a000  ! 5864: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb7a80c20  ! 5867: FMOVRLZ	dis not found

	.word 0xbba98820  ! 5868: FMOVNEG	fmovs	%fcc1, %f0, %f29
	.word 0x8395a0a6  ! 5869: WRPR_TNPC_I	wrpr	%r22, 0x00a6, %tnpc
	.word 0xbba488a0  ! 5871: FSUBs	fsubs	%f18, %f0, %f29
	.word 0xb17c2401  ! 5875: MOVR_I	movre	%r16, 0x1, %r24
	.word 0xb9ab0820  ! 5876: FMOVGU	fmovs	%fcc1, %f0, %f28
	.word 0xbd510000  ! 5877: RDPR_TICK	<illegal instruction>
	.word 0xbe042065  ! 5878: ADD_I	add 	%r16, 0x0065, %r31
	.word 0xb2b44000  ! 5879: ORNcc_R	orncc 	%r17, %r0, %r25
	.word 0xb5a408c0  ! 5880: FSUBd	fsubd	%f16, %f0, %f26
	.word 0xb9510000  ! 5881: RDPR_TICK	<illegal instruction>
hwintr_1_265:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_265), 16, 16)) -> intp(1, 0, d)
	.word 0xb52cb001  ! 5883: SLLX_I	sllx	%r18, 0x0001, %r26
	.word 0xb2148000  ! 5887: OR_R	or 	%r18, %r0, %r25
	.word 0xbfa54820  ! 5889: FADDs	fadds	%f21, %f0, %f31
hwintr_1_266:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_266), 16, 16)) -> intp(1, 0, 1f)
hwintr_1_267:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_267), 16, 16)) -> intp(1, 0, 2)
	.word 0xb5520000  ! 5895: RDPR_PIL	<illegal instruction>
	.word 0xbfa00540  ! 5897: FSQRTd	fsqrt	
hwintr_1_268:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_268), 16, 16)) -> intp(1, 0, 23)
	.word 0xb7540000  ! 5920: RDPR_GL	<illegal instruction>
	.word 0xb93ca001  ! 5921: SRA_I	sra 	%r18, 0x0001, %r28
	.word 0xb9a98820  ! 5923: FMOVNEG	fmovs	%fcc1, %f0, %f28
	.word 0xb3a54860  ! 5924: FADDq	dis not found

	.word 0xb7a84820  ! 5925: FMOVE	fmovs	%fcc1, %f0, %f27
	.word 0xbdab8820  ! 5927: FMOVPOS	fmovs	%fcc1, %f0, %f30
	ta	T_CHANGE_HPRIV
	.word 0x81982a19  ! 5930: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a19, %hpstate
	.word 0xb0b50000  ! 5931: ORNcc_R	orncc 	%r20, %r0, %r24
hwintr_1_269:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_269), 16, 16)) -> intp(1, 0, 2)
	.word 0xb1520000  ! 5938: RDPR_PIL	<illegal instruction>
	.word 0xb4b5215a  ! 5940: SUBCcc_I	orncc 	%r20, 0x015a, %r26
	.word 0xb9a90820  ! 5942: FMOVLEU	fmovs	%fcc1, %f0, %f28
	.word 0xb3a80820  ! 5943: FMOVRLEZ	fmovs	%fcc1, %f0, %f25
hwintr_1_270:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_270), 16, 16)) -> intp(1, 0, 2e)
	.word 0xb69d4000  ! 5946: XORcc_R	xorcc 	%r21, %r0, %r27
	.word 0xb7a408a0  ! 5947: FSUBs	fsubs	%f16, %f0, %f27
	.word 0xb5a448c0  ! 5948: FSUBd	fsubd	%f48, %f0, %f26
	.word 0xba85c000  ! 5949: ADDcc_R	addcc 	%r23, %r0, %r29
	.word 0xb1a58820  ! 5953: FADDs	fadds	%f22, %f0, %f24
	.word 0xbda81820  ! 5954: FMOVRGZ	fmovs	%fcc3, %f0, %f30
	.word 0x8994205d  ! 5960: WRPR_TICK_I	wrpr	%r16, 0x005d, %tick
	.word 0xb1ab0820  ! 5961: FMOVGU	fmovs	%fcc1, %f0, %f24
	.word 0xbba54960  ! 5964: FMULq	dis not found

	.word 0xb7a5c940  ! 5968: FMULd	fmuld	%f54, %f0, %f58
	ta	T_CHANGE_HPRIV
	.word 0x81982a53  ! 5971: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a53, %hpstate
	.word 0xb32c8000  ! 5972: SLL_R	sll 	%r18, %r0, %r25
	.word 0xbfa94820  ! 5973: FMOVCS	fmovs	%fcc1, %f0, %f31
hwintr_1_271:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_271), 16, 16)) -> intp(1, 0, 2b)
	.word 0xb5a88820  ! 5977: FMOVLE	fmovs	%fcc1, %f0, %f26
	.word 0xbb2d1000  ! 5978: SLLX_R	sllx	%r20, %r0, %r29
	.word 0xb9a54960  ! 5979: FMULq	dis not found

	.word 0xb9a4c9c0  ! 5981: FDIVd	fdivd	%f50, %f0, %f28
	.word 0xbba88820  ! 5984: FMOVLE	fmovs	%fcc1, %f0, %f29
	.word 0x8995e043  ! 5987: WRPR_TICK_I	wrpr	%r23, 0x0043, %tick
	.word 0xb7ab0820  ! 5990: FMOVGU	fmovs	%fcc1, %f0, %f27
	.word 0xb7500000  ! 5992: RDPR_TPC	<illegal instruction>
	.word 0xb6ac21c4  ! 5993: ANDNcc_I	andncc 	%r16, 0x01c4, %r27
	.word 0xb5a449e0  ! 5994: FDIVq	dis not found

	.word 0xb5a90820  ! 5998: FMOVLEU	fmovs	%fcc1, %f0, %f26
	.word 0xbda50840  ! 5999: FADDd	faddd	%f20, %f0, %f30
	mov	0, %r14
	.word 0xa193a000  ! 6002: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbb500000  ! 6003: RDPR_TPC	<illegal instruction>
	.word 0xb5a81c20  ! 6004: FMOVRGEZ	dis not found

	.word 0x919561a9  ! 6008: WRPR_PIL_I	wrpr	%r21, 0x01a9, %pil
hwintr_1_272:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_272), 16, 16)) -> intp(1, 0, 22)
	ta	T_CHANGE_HPRIV
	.word 0x81983849  ! 6011: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1849, %hpstate
	.word 0x87952122  ! 6012: WRPR_TT_I	wrpr	%r20, 0x0122, %tt
	.word 0xbdabc820  ! 6015: FMOVVC	fmovs	%fcc1, %f0, %f30
	.word 0xb5ab8820  ! 6019: FMOVPOS	fmovs	%fcc1, %f0, %f26
	.word 0x919521ec  ! 6020: WRPR_PIL_I	wrpr	%r20, 0x01ec, %pil
	.word 0xb8b58000  ! 6024: ORNcc_R	orncc 	%r22, %r0, %r28
	.word 0xbba4c8a0  ! 6025: FSUBs	fsubs	%f19, %f0, %f29
hwintr_1_273:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_273), 16, 16)) -> intp(1, 0, 3d)
	.word 0xb7540000  ! 6030: RDPR_GL	<illegal instruction>
	.word 0xb7a589e0  ! 6033: FDIVq	dis not found

	.word 0xb1aac820  ! 6034: FMOVGE	fmovs	%fcc1, %f0, %f24
	.word 0xbf358000  ! 6038: SRL_R	srl 	%r22, %r0, %r31
	.word 0xb750c000  ! 6044: RDPR_TT	<illegal instruction>
	.word 0xbeaca095  ! 6045: ANDNcc_I	andncc 	%r18, 0x0095, %r31
	.word 0xbba9c820  ! 6046: FMOVVS	fmovs	%fcc1, %f0, %f29
	.word 0xb5a81c20  ! 6052: FMOVRGEZ	dis not found

hwintr_1_274:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_274), 16, 16)) -> intp(1, 0, 3b)
	.word 0xba15c000  ! 6058: OR_R	or 	%r23, %r0, %r29
	.word 0xb3a9c820  ! 6063: FMOVVS	fmovs	%fcc1, %f0, %f25
hwintr_1_275:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_275), 16, 16)) -> intp(1, 0, b)
	.word 0x85942184  ! 6071: WRPR_TSTATE_I	wrpr	%r16, 0x0184, %tstate
	.word 0xb9641800  ! 6072: MOVcc_R	<illegal instruction>
hwintr_1_276:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_276), 16, 16)) -> intp(1, 0, 3c)
	.word 0x8395a127  ! 6078: WRPR_TNPC_I	wrpr	%r22, 0x0127, %tnpc
	ldda	[%r17 + %g0] 0xf0, %f2
	.word 0xb7a00040  ! 6082: FMOVd	fmovd	%f0, %f58
	.word 0xbda5c860  ! 6083: FADDq	dis not found

	.word 0xb5a5c820  ! 6085: FADDs	fadds	%f23, %f0, %f26
	.word 0xb5540000  ! 6091: RDPR_GL	<illegal instruction>
	.word 0xb7a408c0  ! 6092: FSUBd	fsubd	%f16, %f0, %f58
hwintr_1_277:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_277), 16, 16)) -> intp(1, 0, 2f)
	.word 0xb1abc820  ! 6098: FMOVVC	fmovs	%fcc1, %f0, %f24
hwintr_1_278:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_278), 16, 16)) -> intp(1, 0, 0)
	.word 0x839460b9  ! 6111: WRPR_TNPC_I	wrpr	%r17, 0x00b9, %tnpc
	.word 0xb3a4c8e0  ! 6112: FSUBq	dis not found

	.word 0xbf480000  ! 6114: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
hwintr_1_279:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_279), 16, 16)) -> intp(1, 0, 2e)
	.word 0x8d95218f  ! 6118: WRPR_PSTATE_I	wrpr	%r20, 0x018f, %pstate
	.word 0xb1a489c0  ! 6122: FDIVd	fdivd	%f18, %f0, %f24
	.word 0xb9aac820  ! 6124: FMOVGE	fmovs	%fcc1, %f0, %f28
hwintr_1_280:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_280), 16, 16)) -> intp(1, 0, c)
	.word 0xb5500000  ! 6128: RDPR_TPC	<illegal instruction>
	.word 0xb9a80820  ! 6134: FMOVRLEZ	fmovs	%fcc1, %f0, %f28
	ta	T_CHANGE_HPRIV
	.word 0x81982b91  ! 6140: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b91, %hpstate
	.word 0xb9a448e0  ! 6144: FSUBq	dis not found

	.word 0x8194e1ab  ! 6148: WRPR_TPC_I	wrpr	%r19, 0x01ab, %tpc
	.word 0xbf510000  ! 6151: RDPR_TICK	<illegal instruction>
	.word 0xb7aa4820  ! 6153: FMOVNE	fmovs	%fcc1, %f0, %f27
	.word 0xb6bc616c  ! 6160: XNORcc_I	xnorcc 	%r17, 0x016c, %r27
	.word 0xb3356001  ! 6161: SRL_I	srl 	%r21, 0x0001, %r25
	.word 0xbd7d0400  ! 6162: MOVR_R	movre	%r20, %r0, %r30
	.word 0xb1a80420  ! 6167: FMOVRZ	dis not found

	.word 0xb9a409e0  ! 6170: FDIVq	dis not found

	.word 0xb7a81c20  ! 6174: FMOVRGEZ	dis not found

	.word 0xb7a44840  ! 6175: FADDd	faddd	%f48, %f0, %f58
	.word 0x819520ff  ! 6181: WRPR_TPC_I	wrpr	%r20, 0x00ff, %tpc
	.word 0xbda00040  ! 6182: FMOVd	fmovd	%f0, %f30
	.word 0xbda81820  ! 6184: FMOVRGZ	fmovs	%fcc3, %f0, %f30
	.word 0xb7a9c820  ! 6185: FMOVVS	fmovs	%fcc1, %f0, %f27
	ldda	[%r17 + %g0] 0xf0, %f2
	.word 0xb9abc820  ! 6190: FMOVVC	fmovs	%fcc1, %f0, %f28
	.word 0xb3a548c0  ! 6192: FSUBd	fsubd	%f52, %f0, %f56
	.word 0xb445e0db  ! 6195: ADDC_I	addc 	%r23, 0x00db, %r26
	.word 0xb3aa4820  ! 6196: FMOVNE	fmovs	%fcc1, %f0, %f25
	.word 0xbf50c000  ! 6197: RDPR_TT	rdpr	%tt, %r31
hwintr_1_281:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_281), 16, 16)) -> intp(1, 0, 7)
	.word 0xb1510000  ! 6200: RDPR_TICK	<illegal instruction>
	.word 0xbda488a0  ! 6202: FSUBs	fsubs	%f18, %f0, %f30
	.word 0xb5a80c20  ! 6204: FMOVRLZ	dis not found

hwintr_1_282:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_282), 16, 16)) -> intp(1, 0, 28)
	.word 0xb7540000  ! 6207: RDPR_GL	<illegal instruction>
	.word 0xb5510000  ! 6208: RDPR_TICK	<illegal instruction>
	mov	2, %r14
	.word 0xa193a000  ! 6209: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	mov	1, %r14
	.word 0xa193a000  ! 6210: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbba4c8a0  ! 6214: FSUBs	fsubs	%f19, %f0, %f29
hwintr_1_283:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_283), 16, 16)) -> intp(1, 0, 11)
	.word 0xbfaa4820  ! 6217: FMOVNE	fmovs	%fcc1, %f0, %f31
	.word 0xb9a98820  ! 6218: FMOVNEG	fmovs	%fcc1, %f0, %f28
	.word 0xbba409c0  ! 6219: FDIVd	fdivd	%f16, %f0, %f60
hwintr_1_284:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_284), 16, 16)) -> intp(1, 0, 1c)
hwintr_1_285:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_285), 16, 16)) -> intp(1, 0, 1)
	.word 0xbba40840  ! 6224: FADDd	faddd	%f16, %f0, %f60
	ldda	[%r17 + %g0] 0xf0, %f2
	.word 0xb1a00040  ! 6230: FMOVd	fmovd	%f0, %f24
	ldda	[%r17 + %g0] 0xf0, %f2
	.word 0xb3a00520  ! 6232: FSQRTs	fsqrt	
	.word 0xb3520000  ! 6235: RDPR_PIL	<illegal instruction>
hwintr_1_286:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_286), 16, 16)) -> intp(1, 0, 17)
	.word 0x9195a05c  ! 6237: WRPR_PIL_I	wrpr	%r22, 0x005c, %pil
	.word 0x8594e0bc  ! 6238: WRPR_TSTATE_I	wrpr	%r19, 0x00bc, %tstate
	.word 0xb5a81820  ! 6240: FMOVRGZ	fmovs	%fcc3, %f0, %f26
	.word 0xb9a00560  ! 6243: FSQRTq	fsqrt	
	.word 0x8594611d  ! 6245: WRPR_TSTATE_I	wrpr	%r17, 0x011d, %tstate
	.word 0xbf520000  ! 6246: RDPR_PIL	<illegal instruction>
	ldda	[%r17 + %g0] 0xf0, %f2
hwintr_1_287:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_287), 16, 16)) -> intp(1, 0, 39)
	ta	T_CHANGE_HPRIV
	.word 0x81982849  ! 6256: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0849, %hpstate
	.word 0xb5518000  ! 6257: RDPR_PSTATE	<illegal instruction>
	.word 0xb9a00020  ! 6259: FMOVs	fmovs	%f0, %f28
	.word 0xb1a54860  ! 6265: FADDq	dis not found

	.word 0xb5480000  ! 6267: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0x8194a0b0  ! 6268: WRPR_TPC_I	wrpr	%r18, 0x00b0, %tpc
	.word 0xb5aa8820  ! 6275: FMOVG	fmovs	%fcc1, %f0, %f26
	.word 0xbfa4c940  ! 6277: FMULd	fmuld	%f50, %f0, %f62
	.word 0xbfa00560  ! 6278: FSQRTq	fsqrt	
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0xb5a81420  ! 6287: FMOVRNZ	dis not found

	.word 0xb1a81420  ! 6293: FMOVRNZ	dis not found

hwintr_1_288:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_288), 16, 16)) -> intp(1, 0, 3)
	.word 0xbb2d2001  ! 6298: SLL_I	sll 	%r20, 0x0001, %r29
	.word 0xb3520000  ! 6299: RDPR_PIL	<illegal instruction>
	.word 0xb5a00020  ! 6300: FMOVs	fmovs	%f0, %f26
	.word 0xb4042190  ! 6303: ADD_I	add 	%r16, 0x0190, %r26
hwintr_1_289:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_289), 16, 16)) -> intp(1, 0, 37)
hwintr_1_290:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_290), 16, 16)) -> intp(1, 0, 35)
	.word 0xb5a84820  ! 6306: FMOVE	fmovs	%fcc1, %f0, %f26
	.word 0xb13df001  ! 6307: SRAX_I	srax	%r23, 0x0001, %r24
	.word 0xb02c200f  ! 6310: ANDN_I	andn 	%r16, 0x000f, %r24
	.word 0xb01d0000  ! 6311: XOR_R	xor 	%r20, %r0, %r24
	.word 0xb7a80820  ! 6313: FMOVRLEZ	fmovs	%fcc1, %f0, %f27
	.word 0xb9a90820  ! 6318: FMOVLEU	fmovs	%fcc1, %f0, %f28
	.word 0x8d942022  ! 6320: WRPR_PSTATE_I	wrpr	%r16, 0x0022, %pstate
	.word 0xb1a508e0  ! 6321: FSUBq	dis not found

	.word 0xb7520000  ! 6323: RDPR_PIL	<illegal instruction>
	.word 0xb551c000  ! 6324: RDPR_TL	<illegal instruction>
hwintr_1_291:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_291), 16, 16)) -> intp(1, 0, 2e)
	.word 0x8594a1fc  ! 6330: WRPR_TSTATE_I	wrpr	%r18, 0x01fc, %tstate
	.word 0xbba81c20  ! 6331: FMOVRGEZ	dis not found

	.word 0xb3480000  ! 6334: RDHPR_HPSTATE	rdhpr	%hpstate, %r25
	.word 0xb151c000  ! 6336: RDPR_TL	<illegal instruction>
	.word 0xba35c000  ! 6337: SUBC_R	orn 	%r23, %r0, %r29
	.word 0xb1a8c820  ! 6342: FMOVL	fmovs	%fcc1, %f0, %f24
	mov	1, %r12
	.word 0x8f932000  ! 6344: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb7a00040  ! 6346: FMOVd	fmovd	%f0, %f58
	.word 0xb5a00040  ! 6347: FMOVd	fmovd	%f0, %f26
	.word 0xbfa90820  ! 6353: FMOVLEU	fmovs	%fcc1, %f0, %f31
	mov	2, %r12
	.word 0x8f932000  ! 6354: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0x8795a16c  ! 6357: WRPR_TT_I	wrpr	%r22, 0x016c, %tt
hwintr_1_292:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_292), 16, 16)) -> intp(1, 0, 15)
	.word 0xbf480000  ! 6359: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xbfa80c20  ! 6367: FMOVRLZ	dis not found

	.word 0xb0850000  ! 6372: ADDcc_R	addcc 	%r20, %r0, %r24
hwintr_1_293:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_293), 16, 16)) -> intp(1, 0, e)
	.word 0xb7aa8820  ! 6377: FMOVG	fmovs	%fcc1, %f0, %f27
	.word 0xb1a50960  ! 6380: FMULq	dis not found

	.word 0xb7aa0820  ! 6381: FMOVA	fmovs	%fcc1, %f0, %f27
	.word 0xbba48960  ! 6382: FMULq	dis not found

	.word 0xbe9d4000  ! 6384: XORcc_R	xorcc 	%r21, %r0, %r31
	.word 0xba244000  ! 6389: SUB_R	sub 	%r17, %r0, %r29
	.word 0xbda88820  ! 6390: FMOVLE	fmovs	%fcc1, %f0, %f30
	.word 0xb9ab4820  ! 6396: FMOVCC	fmovs	%fcc1, %f0, %f28
	.word 0xb3a00520  ! 6397: FSQRTs	fsqrt	
	.word 0x87952029  ! 6403: WRPR_TT_I	wrpr	%r20, 0x0029, %tt
	.word 0xbda90820  ! 6404: FMOVLEU	fmovs	%fcc1, %f0, %f30
	.word 0xb3a00560  ! 6407: FSQRTq	fsqrt	
	.word 0xb5a488e0  ! 6410: FSUBq	dis not found

	.word 0xb9a00040  ! 6413: FMOVd	fmovd	%f0, %f28
	.word 0xb1504000  ! 6414: RDPR_TNPC	<illegal instruction>
	.word 0xbba00540  ! 6417: FSQRTd	fsqrt	
	.word 0xbbab4820  ! 6419: FMOVCC	fmovs	%fcc1, %f0, %f29
hwintr_1_294:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_294), 16, 16)) -> intp(1, 0, 33)
	.word 0xb5a80820  ! 6423: FMOVN	fmovs	%fcc1, %f0, %f26
	ta	T_CHANGE_HPRIV
	.word 0x8198289b  ! 6425: WRHPR_HPSTATE_I	wrhpr	%r0, 0x089b, %hpstate
	.word 0xb3518000  ! 6427: RDPR_PSTATE	<illegal instruction>
	.word 0xb3a00020  ! 6428: FMOVs	fmovs	%f0, %f25
	.word 0xb1a4c9c0  ! 6430: FDIVd	fdivd	%f50, %f0, %f24
	.word 0x81956017  ! 6433: WRPR_TPC_I	wrpr	%r21, 0x0017, %tpc
	.word 0xbd480000  ! 6435: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0xb9a44940  ! 6436: FMULd	fmuld	%f48, %f0, %f28
	.word 0xb1a80820  ! 6437: FMOVN	fmovs	%fcc1, %f0, %f24
hwintr_1_295:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_295), 16, 16)) -> intp(1, 0, 36)
hwintr_1_296:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_296), 16, 16)) -> intp(1, 0, 36)
	.word 0xbfa508e0  ! 6442: FSUBq	dis not found

	.word 0xb12d5000  ! 6444: SLLX_R	sllx	%r21, %r0, %r24
hwintr_1_297:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_297), 16, 16)) -> intp(1, 0, 3)
	.word 0xb12d9000  ! 6449: SLLX_R	sllx	%r22, %r0, %r24
	.word 0xb1a00560  ! 6452: FSQRTq	fsqrt	
hwintr_1_298:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_298), 16, 16)) -> intp(1, 0, 2)
	.word 0xbfa00540  ! 6454: FSQRTd	fsqrt	
	.word 0xb5a5c9a0  ! 6457: FDIVs	fdivs	%f23, %f0, %f26
	.word 0xbba48920  ! 6459: FMULs	fmuls	%f18, %f0, %f29
	.word 0x8194a048  ! 6461: WRPR_TPC_I	wrpr	%r18, 0x0048, %tpc
	ldda	[%r16 + %g0] 0xf0, %f2
	ta	T_CHANGE_HPRIV
	.word 0x81982953  ! 6463: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0953, %hpstate
hwintr_1_299:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_299), 16, 16)) -> intp(1, 0, 1f)
	ta	T_CHANGE_HPRIV
	.word 0x81982e41  ! 6465: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e41, %hpstate
	.word 0xb88d0000  ! 6468: ANDcc_R	andcc 	%r20, %r0, %r28
	.word 0xb5a80420  ! 6470: FMOVRZ	dis not found

	.word 0xbd3d8000  ! 6476: SRA_R	sra 	%r22, %r0, %r30
	.word 0x8394601b  ! 6477: WRPR_TNPC_I	wrpr	%r17, 0x001b, %tnpc
	.word 0x839520d7  ! 6483: WRPR_TNPC_I	wrpr	%r20, 0x00d7, %tnpc
	.word 0xb7540000  ! 6485: RDPR_GL	<illegal instruction>
	.word 0xb1340000  ! 6488: SRL_R	srl 	%r16, %r0, %r24
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xb5a81c20  ! 6490: FMOVRGEZ	dis not found

	.word 0xb1a50860  ! 6496: FADDq	dis not found

	.word 0x919521e4  ! 6498: WRPR_PIL_I	wrpr	%r20, 0x01e4, %pil
	.word 0xb7a508c0  ! 6499: FSUBd	fsubd	%f20, %f0, %f58
	.word 0xb9a81c20  ! 6500: FMOVRGEZ	dis not found

	.word 0x819560c6  ! 6503: WRPR_TPC_I	wrpr	%r21, 0x00c6, %tpc
	.word 0xb9a80820  ! 6504: FMOVRLEZ	fmovs	%fcc1, %f0, %f28
	.word 0xb3520000  ! 6505: RDPR_PIL	<illegal instruction>
	.word 0xbdabc820  ! 6507: FMOVVC	fmovs	%fcc1, %f0, %f30
	.word 0xb9abc820  ! 6508: FMOVVC	fmovs	%fcc1, %f0, %f28
	.word 0xb1a508a0  ! 6510: FSUBs	fsubs	%f20, %f0, %f24
	.word 0xbba98820  ! 6511: FMOVNEG	fmovs	%fcc1, %f0, %f29
hwintr_1_300:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_300), 16, 16)) -> intp(1, 0, 11)
hwintr_1_301:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_301), 16, 16)) -> intp(1, 0, 34)
	.word 0xbba58920  ! 6518: FMULs	fmuls	%f22, %f0, %f29
	.word 0x8394e19b  ! 6519: WRPR_TNPC_I	wrpr	%r19, 0x019b, %tnpc
	.word 0x8794a19a  ! 6520: WRPR_TT_I	wrpr	%r18, 0x019a, %tt
	.word 0xb1a98820  ! 6521: FMOVNEG	fmovs	%fcc1, %f0, %f24
	.word 0xb1a488e0  ! 6522: FSUBq	dis not found

	.word 0xbf510000  ! 6523: RDPR_TICK	<illegal instruction>
	.word 0xb7a80c20  ! 6525: FMOVRLZ	dis not found

	.word 0xb0c5e0de  ! 6526: ADDCcc_I	addccc 	%r23, 0x00de, %r24
	.word 0xbda81420  ! 6528: FMOVRNZ	dis not found

	.word 0xb3500000  ! 6529: RDPR_TPC	<illegal instruction>
	.word 0xb5a00560  ! 6530: FSQRTq	fsqrt	
	.word 0xbfa81820  ! 6534: FMOVRGZ	fmovs	%fcc3, %f0, %f31
	.word 0xbda58940  ! 6540: FMULd	fmuld	%f22, %f0, %f30
	.word 0xbebd4000  ! 6546: XNORcc_R	xnorcc 	%r21, %r0, %r31
	.word 0xb9ab0820  ! 6547: FMOVGU	fmovs	%fcc1, %f0, %f28
	.word 0xb92d2001  ! 6551: SLL_I	sll 	%r20, 0x0001, %r28
	.word 0xbf508000  ! 6552: RDPR_TSTATE	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982901  ! 6553: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0901, %hpstate
	.word 0xb03d4000  ! 6554: XNOR_R	xnor 	%r21, %r0, %r24
	ta	T_CHANGE_HPRIV
	.word 0x81983b59  ! 6555: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b59, %hpstate
	.word 0xbb3c4000  ! 6557: SRA_R	sra 	%r17, %r0, %r29
	.word 0xb3abc820  ! 6558: FMOVVC	fmovs	%fcc1, %f0, %f25
	.word 0xbfa48840  ! 6560: FADDd	faddd	%f18, %f0, %f62
	ldda	[%r22 + %g0] 0xf0, %f2
	.word 0xb77cc400  ! 6562: MOVR_R	movre	%r19, %r0, %r27
	.word 0x9195a080  ! 6567: WRPR_PIL_I	wrpr	%r22, 0x0080, %pil
	.word 0xbb480000  ! 6568: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xba450000  ! 6571: ADDC_R	addc 	%r20, %r0, %r29
	.word 0xb9a80820  ! 6574: FMOVRLEZ	fmovs	%fcc1, %f0, %f28
	.word 0x8994615c  ! 6577: WRPR_TICK_I	wrpr	%r17, 0x015c, %tick
	.word 0xbfa5c8c0  ! 6579: FSUBd	fsubd	%f54, %f0, %f62
	.word 0xb9a48940  ! 6582: FMULd	fmuld	%f18, %f0, %f28
	.word 0x8d95a1dd  ! 6584: WRPR_PSTATE_I	wrpr	%r22, 0x01dd, %pstate
	.word 0xb9a9c820  ! 6588: FMOVVS	fmovs	%fcc1, %f0, %f28
	.word 0xb7a488e0  ! 6589: FSUBq	dis not found

	.word 0xb1a449e0  ! 6590: FDIVq	dis not found

	.word 0xb1aac820  ! 6596: FMOVGE	fmovs	%fcc1, %f0, %f24
hwintr_1_302:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_302), 16, 16)) -> intp(1, 0, 9)
	.word 0xb2154000  ! 6607: OR_R	or 	%r21, %r0, %r25
hwintr_1_303:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_303), 16, 16)) -> intp(1, 0, 1a)
	.word 0xb9a00560  ! 6612: FSQRTq	fsqrt	
	.word 0xb1a54960  ! 6613: FMULq	dis not found

	.word 0xb7a40920  ! 6616: FMULs	fmuls	%f16, %f0, %f27
	.word 0xb151c000  ! 6619: RDPR_TL	<illegal instruction>
	.word 0xb950c000  ! 6622: RDPR_TT	<illegal instruction>
	.word 0xbb500000  ! 6623: RDPR_TPC	<illegal instruction>
	ta	T_CHANGE_HPRIV
	mov	8, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	flush
	.word 0x8d94e012  ! 6632: WRPR_PSTATE_I	wrpr	%r19, 0x0012, %pstate
	.word 0xb9a8c820  ! 6634: FMOVL	fmovs	%fcc1, %f0, %f28
	.word 0xbdaac820  ! 6635: FMOVGE	fmovs	%fcc1, %f0, %f30
	.word 0xb7a508e0  ! 6636: FSUBq	dis not found

	.word 0xb535b001  ! 6647: SRLX_I	srlx	%r22, 0x0001, %r26
	.word 0xb37d4400  ! 6648: MOVR_R	movre	%r21, %r0, %r25
	.word 0xb3a509a0  ! 6650: FDIVs	fdivs	%f20, %f0, %f25
hwintr_1_304:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_304), 16, 16)) -> intp(1, 0, 14)
	.word 0xbda8c820  ! 6657: FMOVL	fmovs	%fcc1, %f0, %f30
	.word 0xbf34c000  ! 6659: SRL_R	srl 	%r19, %r0, %r31
	.word 0xbf480000  ! 6661: RDHPR_HPSTATE	rdhpr	%hpstate, %r31
	.word 0xb1a00540  ! 6665: FSQRTd	fsqrt	
	.word 0xbfa88820  ! 6671: FMOVLE	fmovs	%fcc1, %f0, %f31
	.word 0xb1a548c0  ! 6673: FSUBd	fsubd	%f52, %f0, %f24
	.word 0xb3a5c8a0  ! 6674: FSUBs	fsubs	%f23, %f0, %f25
	.word 0xbb504000  ! 6675: RDPR_TNPC	<illegal instruction>
	.word 0x8195e1fb  ! 6677: WRPR_TPC_I	wrpr	%r23, 0x01fb, %tpc
hwintr_1_305:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_305), 16, 16)) -> intp(1, 0, 21)
	ta	T_CHANGE_HPRIV
	.word 0x81983993  ! 6682: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1993, %hpstate
	.word 0xb42ce075  ! 6684: ANDN_I	andn 	%r19, 0x0075, %r26
	.word 0xb1480000  ! 6685: RDHPR_HPSTATE	rdhpr	%hpstate, %r24
	.word 0xb3a00520  ! 6688: FSQRTs	fsqrt	
	.word 0xbf2cd000  ! 6694: SLLX_R	sllx	%r19, %r0, %r31
	.word 0xbb518000  ! 6698: RDPR_PSTATE	<illegal instruction>
	.word 0xbda488c0  ! 6701: FSUBd	fsubd	%f18, %f0, %f30
	.word 0xbb520000  ! 6702: RDPR_PIL	<illegal instruction>
	.word 0xb9a00520  ! 6704: FSQRTs	fsqrt	
	.word 0xb6858000  ! 6706: ADDcc_R	addcc 	%r22, %r0, %r27
	.word 0xb9a50840  ! 6707: FADDd	faddd	%f20, %f0, %f28
	.word 0xb9a80c20  ! 6710: FMOVRLZ	dis not found

	.word 0xb9a548e0  ! 6711: FSUBq	dis not found

	.word 0xb9a84820  ! 6713: FMOVE	fmovs	%fcc1, %f0, %f28
	.word 0xb9a58820  ! 6715: FADDs	fadds	%f22, %f0, %f28
hwintr_1_306:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_306), 16, 16)) -> intp(1, 0, 15)
hwintr_1_307:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_307), 16, 16)) -> intp(1, 0, 19)
	.word 0xbd540000  ! 6725: RDPR_GL	<illegal instruction>
	.word 0xbba00540  ! 6727: FSQRTd	fsqrt	
	.word 0xbbab4820  ! 6729: FMOVCC	fmovs	%fcc1, %f0, %f29
	.word 0xbf500000  ! 6732: RDPR_TPC	<illegal instruction>
	.word 0xbd500000  ! 6733: RDPR_TPC	<illegal instruction>
	.word 0xbda00040  ! 6735: FMOVd	fmovd	%f0, %f30
	.word 0xb88ca1fd  ! 6736: ANDcc_I	andcc 	%r18, 0x01fd, %r28
	.word 0xbda44860  ! 6738: FADDq	dis not found

	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xb9a44940  ! 6741: FMULd	fmuld	%f48, %f0, %f28
	.word 0xb9a4c960  ! 6743: FMULq	dis not found

	.word 0x839421fa  ! 6745: WRPR_TNPC_I	wrpr	%r16, 0x01fa, %tnpc
	.word 0xbba94820  ! 6746: FMOVCS	fmovs	%fcc1, %f0, %f29
	.word 0xb1a5c940  ! 6747: FMULd	fmuld	%f54, %f0, %f24
	.word 0xb9510000  ! 6749: RDPR_TICK	<illegal instruction>
	.word 0xb8a4600b  ! 6750: SUBcc_I	subcc 	%r17, 0x000b, %r28
	.word 0xb9a84820  ! 6753: FMOVE	fmovs	%fcc1, %f0, %f28
	.word 0xb93d4000  ! 6755: SRA_R	sra 	%r21, %r0, %r28
	.word 0xb7504000  ! 6758: RDPR_TNPC	<illegal instruction>
hwintr_1_308:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_308), 16, 16)) -> intp(1, 0, 2)
	.word 0xbd520000  ! 6767: RDPR_PIL	<illegal instruction>
	.word 0x9194e1cf  ! 6770: WRPR_PIL_I	wrpr	%r19, 0x01cf, %pil
	.word 0xb7342001  ! 6772: SRL_I	srl 	%r16, 0x0001, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81983e81  ! 6774: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e81, %hpstate
	ldda	[%r23 + %g0] 0xf0, %f2
	ta	T_CHANGE_HPRIV
	.word 0x81983e9b  ! 6777: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e9b, %hpstate
	ldda	[%r23 + %g0] 0xf0, %f2
	ta	T_CHANGE_HPRIV
	.word 0x81983ec3  ! 6780: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1ec3, %hpstate
	.word 0xbda00540  ! 6782: FSQRTd	fsqrt	
	.word 0xbda80820  ! 6783: FMOVN	fmovs	%fcc1, %f0, %f30
hwintr_1_309:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_309), 16, 16)) -> intp(1, 0, 1e)
	.word 0xba2d4000  ! 6788: ANDN_R	andn 	%r21, %r0, %r29
	.word 0xbba80420  ! 6789: FMOVRZ	dis not found

	.word 0xbfa94820  ! 6790: FMOVCS	fmovs	%fcc1, %f0, %f31
	.word 0xb5a5c960  ! 6801: FMULq	dis not found

	.word 0xb1504000  ! 6802: RDPR_TNPC	<illegal instruction>
	.word 0xbda80820  ! 6806: FMOVN	fmovs	%fcc1, %f0, %f30
hwintr_1_310:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_310), 16, 16)) -> intp(1, 0, 39)
	.word 0xbfa5c920  ! 6811: FMULs	fmuls	%f23, %f0, %f31
	.word 0xb5ab4820  ! 6812: FMOVCC	fmovs	%fcc1, %f0, %f26
	.word 0xb9480000  ! 6813: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xb3a549a0  ! 6820: FDIVs	fdivs	%f21, %f0, %f25
	.word 0xbfaa0820  ! 6825: FMOVA	fmovs	%fcc1, %f0, %f31
	.word 0xb57c6401  ! 6827: MOVR_I	movre	%r17, 0x1, %r26
	.word 0xbe45e089  ! 6829: ADDC_I	addc 	%r23, 0x0089, %r31
	.word 0xb53c1000  ! 6831: SRAX_R	srax	%r16, %r0, %r26
hwintr_1_311:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_311), 16, 16)) -> intp(1, 0, 12)
	.word 0xb7aa4820  ! 6836: FMOVNE	fmovs	%fcc1, %f0, %f27
	.word 0xbdab4820  ! 6837: FMOVCC	fmovs	%fcc1, %f0, %f30
	.word 0xb5a44960  ! 6838: FMULq	dis not found

	.word 0xbfaac820  ! 6839: FMOVGE	fmovs	%fcc1, %f0, %f31
	.word 0xb3a4c9c0  ! 6845: FDIVd	fdivd	%f50, %f0, %f56
	.word 0xbda509e0  ! 6848: FDIVq	dis not found

	.word 0xbfa94820  ! 6852: FMOVCS	fmovs	%fcc1, %f0, %f31
	.word 0xb5a81420  ! 6853: FMOVRNZ	dis not found

	.word 0xbc84e002  ! 6860: ADDcc_I	addcc 	%r19, 0x0002, %r30
hwintr_1_312:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_312), 16, 16)) -> intp(1, 0, 3c)
	.word 0xbda00520  ! 6864: FSQRTs	fsqrt	
	.word 0xb151c000  ! 6866: RDPR_TL	<illegal instruction>
	.word 0xba352188  ! 6868: SUBC_I	orn 	%r20, 0x0188, %r29
	.word 0xbbaa0820  ! 6871: FMOVA	fmovs	%fcc1, %f0, %f29
	.word 0xbe1c6024  ! 6874: XOR_I	xor 	%r17, 0x0024, %r31
	.word 0xbba40940  ! 6881: FMULd	fmuld	%f16, %f0, %f60
	.word 0xbfa448c0  ! 6882: FSUBd	fsubd	%f48, %f0, %f62
	mov	2, %r12
	.word 0x8f932000  ! 6883: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb1a00020  ! 6884: FMOVs	fmovs	%f0, %f24
	.word 0x8795e0e1  ! 6893: WRPR_TT_I	wrpr	%r23, 0x00e1, %tt
	.word 0xb5a509e0  ! 6894: FDIVq	dis not found

hwintr_1_313:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_313), 16, 16)) -> intp(1, 0, 3f)
	.word 0xbb504000  ! 6898: RDPR_TNPC	<illegal instruction>
	.word 0x819420ee  ! 6899: WRPR_TPC_I	wrpr	%r16, 0x00ee, %tpc
	.word 0xb7a9c820  ! 6903: FMOVVS	fmovs	%fcc1, %f0, %f27
	.word 0xb3540000  ! 6910: RDPR_GL	<illegal instruction>
	.word 0xbba58820  ! 6913: FADDs	fadds	%f22, %f0, %f29
	.word 0xbfa548e0  ! 6914: FSUBq	dis not found

	.word 0xb1a4c9c0  ! 6915: FDIVd	fdivd	%f50, %f0, %f24
	.word 0xbc1c20bb  ! 6916: XOR_I	xor 	%r16, 0x00bb, %r30
	.word 0xb1520000  ! 6927: RDPR_PIL	<illegal instruction>
hwintr_1_314:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_314), 16, 16)) -> intp(1, 0, 2c)
hwintr_1_315:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_315), 16, 16)) -> intp(1, 0, 38)
hwintr_1_316:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_316), 16, 16)) -> intp(1, 0, 4)
hwintr_1_317:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_317), 16, 16)) -> intp(1, 0, 34)
	ta	T_CHANGE_HPRIV
	.word 0x81982b8b  ! 6943: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b8b, %hpstate
	.word 0xbd7c2401  ! 6945: MOVR_I	movre	%r16, 0x1, %r30
	.word 0xb535a001  ! 6948: SRL_I	srl 	%r22, 0x0001, %r26
	.word 0xbf51c000  ! 6949: RDPR_TL	<illegal instruction>
	.word 0xbba44840  ! 6951: FADDd	faddd	%f48, %f0, %f60
	.word 0xbfa4c940  ! 6952: FMULd	fmuld	%f50, %f0, %f62
	ta	T_CHANGE_HPRIV
	.word 0x81983e13  ! 6957: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1e13, %hpstate
	.word 0xbda4c8a0  ! 6961: FSUBs	fsubs	%f19, %f0, %f30
	.word 0xbda5c920  ! 6962: FMULs	fmuls	%f23, %f0, %f30
	.word 0xb3a8c820  ! 6963: FMOVL	fmovs	%fcc1, %f0, %f25
hwintr_1_318:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_318), 16, 16)) -> intp(1, 0, f)
	.word 0xb9aa0820  ! 6967: FMOVA	fmovs	%fcc1, %f0, %f28
	.word 0xb5a408a0  ! 6971: FSUBs	fsubs	%f16, %f0, %f26
	.word 0xbf3c2001  ! 6972: SRA_I	sra 	%r16, 0x0001, %r31
	.word 0xb5a44920  ! 6978: FMULs	fmuls	%f17, %f0, %f26
	ldda	[%r19 + %g0] 0xf0, %f2
	.word 0xb5518000  ! 6981: RDPR_PSTATE	<illegal instruction>
	.word 0xbfab4820  ! 6985: FMOVCC	fmovs	%fcc1, %f0, %f31
	.word 0xbc0d206f  ! 6986: AND_I	and 	%r20, 0x006f, %r30
hwintr_1_319:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_319), 16, 16)) -> intp(1, 0, 26)
hwintr_1_320:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_320), 16, 16)) -> intp(1, 0, 27)
hwintr_1_321:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_321), 16, 16)) -> intp(1, 0, 3)
	ta	T_CHANGE_HPRIV
	.word 0x81982b4b  ! 6996: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b4b, %hpstate
	.word 0xbfa489e0  ! 7004: FDIVq	dis not found

	.word 0x8594a178  ! 7011: WRPR_TSTATE_I	wrpr	%r18, 0x0178, %tstate
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0x8794615a  ! 7016: WRPR_TT_I	wrpr	%r17, 0x015a, %tt
	.word 0xbbaa4820  ! 7020: FMOVNE	fmovs	%fcc1, %f0, %f29
	ldda	[%r21 + %g0] 0xf0, %f2
	.word 0xbba00020  ! 7023: FMOVs	fmovs	%f0, %f29
	.word 0xb3518000  ! 7024: RDPR_PSTATE	<illegal instruction>
	.word 0xb3a81420  ! 7025: FMOVRNZ	dis not found

	.word 0xb5a90820  ! 7027: FMOVLEU	fmovs	%fcc1, %f0, %f26
hwintr_1_322:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_322), 16, 16)) -> intp(1, 0, 38)
	.word 0xbebd2168  ! 7031: XNORcc_I	xnorcc 	%r20, 0x0168, %r31
	.word 0xbfa81420  ! 7034: FMOVRNZ	dis not found

	.word 0xb151c000  ! 7035: RDPR_TL	<illegal instruction>
	.word 0xb3aa8820  ! 7040: FMOVG	fmovs	%fcc1, %f0, %f25
hwintr_1_323:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_323), 16, 16)) -> intp(1, 0, 1a)
	.word 0xbf518000  ! 7042: RDPR_PSTATE	<illegal instruction>
	.word 0xbfa5c9e0  ! 7044: FDIVq	dis not found

hwintr_1_324:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_324), 16, 16)) -> intp(1, 0, 24)
	ta	T_CHANGE_HPRIV
	.word 0x81983ad1  ! 7047: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1ad1, %hpstate
	.word 0xbbab4820  ! 7048: FMOVCC	fmovs	%fcc1, %f0, %f29
	.word 0x9195211b  ! 7052: WRPR_PIL_I	wrpr	%r20, 0x011b, %pil
	.word 0xbd510000  ! 7053: RDPR_TICK	<illegal instruction>
	.word 0x9194e0c6  ! 7056: WRPR_PIL_I	wrpr	%r19, 0x00c6, %pil
	.word 0xb1a549c0  ! 7059: FDIVd	fdivd	%f52, %f0, %f24
	.word 0xb33c8000  ! 7062: SRA_R	sra 	%r18, %r0, %r25
	.word 0xbbab0820  ! 7067: FMOVGU	fmovs	%fcc1, %f0, %f29
	.word 0x91942148  ! 7069: WRPR_PIL_I	wrpr	%r16, 0x0148, %pil
	.word 0xba0421d1  ! 7071: ADD_I	add 	%r16, 0x01d1, %r29
	.word 0xb1a80420  ! 7073: FMOVRZ	dis not found

	.word 0xb5a4c9a0  ! 7077: FDIVs	fdivs	%f19, %f0, %f26
	.word 0xb9a94820  ! 7078: FMOVCS	fmovs	%fcc1, %f0, %f28
	.word 0xb3a00520  ! 7079: FSQRTs	fsqrt	
	.word 0xb2158000  ! 7080: OR_R	or 	%r22, %r0, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81982941  ! 7084: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0941, %hpstate
	.word 0xbdab8820  ! 7087: FMOVPOS	fmovs	%fcc1, %f0, %f30
	.word 0xb7a40820  ! 7089: FADDs	fadds	%f16, %f0, %f27
	.word 0xbda00520  ! 7090: FSQRTs	fsqrt	
hwintr_1_325:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_325), 16, 16)) -> intp(1, 0, 1c)
	.word 0xbda98820  ! 7095: FMOVNEG	fmovs	%fcc1, %f0, %f30
	.word 0x8d95a1f4  ! 7096: WRPR_PSTATE_I	wrpr	%r22, 0x01f4, %pstate
	.word 0xb9510000  ! 7098: RDPR_TICK	<illegal instruction>
	.word 0xb1a509e0  ! 7101: FDIVq	dis not found

	.word 0xb1351000  ! 7106: SRLX_R	srlx	%r20, %r0, %r24
	.word 0xb7a80820  ! 7108: FMOVN	fmovs	%fcc1, %f0, %f27
	.word 0xb9a54820  ! 7110: FADDs	fadds	%f21, %f0, %f28
	mov	2, %r14
	.word 0xa193a000  ! 7111: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xba05c000  ! 7113: ADD_R	add 	%r23, %r0, %r29
hwintr_1_326:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_326), 16, 16)) -> intp(1, 0, 3f)
	.word 0xbda80c20  ! 7115: FMOVRLZ	dis not found

	.word 0xba346192  ! 7119: SUBC_I	orn 	%r17, 0x0192, %r29
hwintr_1_327:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_327), 16, 16)) -> intp(1, 0, e)
	.word 0xb750c000  ! 7130: RDPR_TT	<illegal instruction>
	.word 0xbba44840  ! 7131: FADDd	faddd	%f48, %f0, %f60
	.word 0xb21d4000  ! 7135: XOR_R	xor 	%r21, %r0, %r25
	.word 0xbb2cc000  ! 7137: SLL_R	sll 	%r19, %r0, %r29
	.word 0xbb51c000  ! 7138: RDPR_TL	<illegal instruction>
	.word 0xbda80820  ! 7144: FMOVRLEZ	fmovs	%fcc1, %f0, %f30
	.word 0xbda00520  ! 7149: FSQRTs	fsqrt	
	.word 0xb01cc000  ! 7150: XOR_R	xor 	%r19, %r0, %r24
	.word 0xb5a4c860  ! 7158: FADDq	dis not found

	.word 0xbda5c920  ! 7161: FMULs	fmuls	%f23, %f0, %f30
	.word 0x8195601a  ! 7162: WRPR_TPC_I	wrpr	%r21, 0x001a, %tpc
hwintr_1_328:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_328), 16, 16)) -> intp(1, 0, 27)
	.word 0xb7520000  ! 7166: RDPR_PIL	<illegal instruction>
	.word 0xb3a81c20  ! 7168: FMOVRGEZ	dis not found

hwintr_1_329:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_329), 16, 16)) -> intp(1, 0, 3d)
	.word 0xbfa48860  ! 7171: FADDq	dis not found

	.word 0x8994e1c6  ! 7178: WRPR_TICK_I	wrpr	%r19, 0x01c6, %tick
	.word 0x8794603b  ! 7179: WRPR_TT_I	wrpr	%r17, 0x003b, %tt
	.word 0xbda5c9a0  ! 7187: FDIVs	fdivs	%f23, %f0, %f30
	.word 0x87942027  ! 7189: WRPR_TT_I	wrpr	%r16, 0x0027, %tt
	.word 0xb9520000  ! 7194: RDPR_PIL	<illegal instruction>
	.word 0xb5a84820  ! 7196: FMOVE	fmovs	%fcc1, %f0, %f26
	.word 0xbda48940  ! 7197: FMULd	fmuld	%f18, %f0, %f30
	.word 0xb1a81c20  ! 7199: FMOVRGEZ	dis not found

	.word 0x899420c9  ! 7200: WRPR_TICK_I	wrpr	%r16, 0x00c9, %tick
	.word 0xb5a549a0  ! 7204: FDIVs	fdivs	%f21, %f0, %f26
	.word 0xb3a5c820  ! 7205: FADDs	fadds	%f23, %f0, %f25
	.word 0xb1a98820  ! 7206: FMOVNEG	fmovs	%fcc1, %f0, %f24
	.word 0x8595e079  ! 7207: WRPR_TSTATE_I	wrpr	%r23, 0x0079, %tstate
hwintr_1_330:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_330), 16, 16)) -> intp(1, 0, 1e)
	.word 0xb3a90820  ! 7214: FMOVLEU	fmovs	%fcc1, %f0, %f25
	.word 0xb550c000  ! 7217: RDPR_TT	<illegal instruction>
	.word 0xbfa44820  ! 7218: FADDs	fadds	%f17, %f0, %f31
	.word 0xbda8c820  ! 7219: FMOVL	fmovs	%fcc1, %f0, %f30
	.word 0xb3504000  ! 7221: RDPR_TNPC	<illegal instruction>
	.word 0xb2248000  ! 7222: SUB_R	sub 	%r18, %r0, %r25
	.word 0xb1a81c20  ! 7223: FMOVRGEZ	dis not found

	.word 0xbda409c0  ! 7224: FDIVd	fdivd	%f16, %f0, %f30
hwintr_1_331:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_331), 16, 16)) -> intp(1, 0, 37)
	.word 0xb9a40840  ! 7233: FADDd	faddd	%f16, %f0, %f28
	mov	0, %r14
	.word 0xa193a000  ! 7235: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	mov	1, %r14
	.word 0xa193a000  ! 7237: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbda80420  ! 7239: FMOVRZ	dis not found

	.word 0xbda58920  ! 7240: FMULs	fmuls	%f22, %f0, %f30
hwintr_1_332:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_332), 16, 16)) -> intp(1, 0, 8)
	ta	T_CHANGE_HPRIV
	.word 0x8198285b  ! 7242: WRHPR_HPSTATE_I	wrhpr	%r0, 0x085b, %hpstate
	.word 0xbbaac820  ! 7243: FMOVGE	fmovs	%fcc1, %f0, %f29
	.word 0xbbab8820  ! 7245: FMOVPOS	fmovs	%fcc1, %f0, %f29
	.word 0xb9aa0820  ! 7246: FMOVA	fmovs	%fcc1, %f0, %f28
	.word 0x919520ee  ! 7247: WRPR_PIL_I	wrpr	%r20, 0x00ee, %pil
	.word 0xb7a448a0  ! 7249: FSUBs	fsubs	%f17, %f0, %f27
	ta	T_CHANGE_HPRIV
	.word 0x81983a5b  ! 7250: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1a5b, %hpstate
	.word 0x8594a045  ! 7251: WRPR_TSTATE_I	wrpr	%r18, 0x0045, %tstate
	ldda	[%r19 + %g0] 0xf0, %f2
	.word 0xbda54960  ! 7256: FMULq	dis not found

	.word 0xb5a488c0  ! 7257: FSUBd	fsubd	%f18, %f0, %f26
	mov	2, %r12
	.word 0x8f932000  ! 7259: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbba4c820  ! 7263: FADDs	fadds	%f19, %f0, %f29
	.word 0xb9aa0820  ! 7265: FMOVA	fmovs	%fcc1, %f0, %f28
	.word 0xbf518000  ! 7267: RDPR_PSTATE	<illegal instruction>
	.word 0xbabd0000  ! 7268: XNORcc_R	xnorcc 	%r20, %r0, %r29
	.word 0xb52d2001  ! 7272: SLL_I	sll 	%r20, 0x0001, %r26
	.word 0xbca520ed  ! 7278: SUBcc_I	subcc 	%r20, 0x00ed, %r30
	.word 0xb7a8c820  ! 7279: FMOVL	fmovs	%fcc1, %f0, %f27
	.word 0xb9ab0820  ! 7280: FMOVGU	fmovs	%fcc1, %f0, %f28
	.word 0xb1a80c20  ! 7288: FMOVRLZ	dis not found

	ldda	[%r19 + %g0] 0xf0, %f2
	.word 0xb3a44820  ! 7295: FADDs	fadds	%f17, %f0, %f25
	.word 0xbb51c000  ! 7302: RDPR_TL	<illegal instruction>
	.word 0xb3a48960  ! 7304: FMULq	dis not found

	.word 0x8995613d  ! 7307: WRPR_TICK_I	wrpr	%r21, 0x013d, %tick
	.word 0xb9a00560  ! 7308: FSQRTq	fsqrt	
	.word 0xb1a80820  ! 7309: FMOVN	fmovs	%fcc1, %f0, %f24
	ta	T_CHANGE_HPRIV
	.word 0x81982b59  ! 7313: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b59, %hpstate
	.word 0xbb510000  ! 7314: RDPR_TICK	<illegal instruction>
	.word 0xbda488a0  ! 7317: FSUBs	fsubs	%f18, %f0, %f30
	.word 0xbda8c820  ! 7319: FMOVL	fmovs	%fcc1, %f0, %f30
	.word 0x8195a1d3  ! 7322: WRPR_TPC_I	wrpr	%r22, 0x01d3, %tpc
	.word 0xb92c3001  ! 7323: SLLX_I	sllx	%r16, 0x0001, %r28
	.word 0xbba4c8a0  ! 7325: FSUBs	fsubs	%f19, %f0, %f29
	.word 0xb1a8c820  ! 7329: FMOVL	fmovs	%fcc1, %f0, %f24
	.word 0xb9ab0820  ! 7331: FMOVGU	fmovs	%fcc1, %f0, %f28
	mov	2, %r14
	.word 0xa193a000  ! 7332: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb1a94820  ! 7333: FMOVCS	fmovs	%fcc1, %f0, %f24
	.word 0xb7aac820  ! 7335: FMOVGE	fmovs	%fcc1, %f0, %f27
	.word 0xb68d4000  ! 7336: ANDcc_R	andcc 	%r21, %r0, %r27
	.word 0xb5a8c820  ! 7339: FMOVL	fmovs	%fcc1, %f0, %f26
	mov	2, %r14
	.word 0xa193a000  ! 7340: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_1_333:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_333), 16, 16)) -> intp(1, 0, 3a)
	.word 0xb9a9c820  ! 7343: FMOVVS	fmovs	%fcc1, %f0, %f28
	.word 0xb3a81420  ! 7345: FMOVRNZ	dis not found

	.word 0xbfa48860  ! 7346: FADDq	dis not found

	.word 0xb5520000  ! 7347: RDPR_PIL	<illegal instruction>
	.word 0xb1a449a0  ! 7348: FDIVs	fdivs	%f17, %f0, %f24
	.word 0xb5504000  ! 7349: RDPR_TNPC	<illegal instruction>
	.word 0xb3a50920  ! 7350: FMULs	fmuls	%f20, %f0, %f25
	.word 0xbdaa4820  ! 7352: FMOVNE	fmovs	%fcc1, %f0, %f30
	.word 0xb8bc0000  ! 7353: XNORcc_R	xnorcc 	%r16, %r0, %r28
	.word 0xbda44860  ! 7359: FADDq	dis not found

	.word 0x8d95e00e  ! 7360: WRPR_PSTATE_I	wrpr	%r23, 0x000e, %pstate
	.word 0xb3a58920  ! 7361: FMULs	fmuls	%f22, %f0, %f25
hwintr_1_334:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_334), 16, 16)) -> intp(1, 0, 7)
	.word 0xb1a44820  ! 7366: FADDs	fadds	%f17, %f0, %f24
	.word 0x83942171  ! 7367: WRPR_TNPC_I	wrpr	%r16, 0x0171, %tnpc
	.word 0xbba00560  ! 7369: FSQRTq	fsqrt	
hwintr_1_335:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_335), 16, 16)) -> intp(1, 0, b)
	.word 0xb3a488e0  ! 7373: FSUBq	dis not found

	.word 0xb9a48940  ! 7374: FMULd	fmuld	%f18, %f0, %f28
	.word 0xb7a8c820  ! 7375: FMOVL	fmovs	%fcc1, %f0, %f27
hwintr_1_336:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_336), 16, 16)) -> intp(1, 0, 11)
	mov	1, %r12
	.word 0x8f932000  ! 7383: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xb9a409a0  ! 7384: FDIVs	fdivs	%f16, %f0, %f28
	.word 0x83956191  ! 7387: WRPR_TNPC_I	wrpr	%r21, 0x0191, %tnpc
	.word 0x859521ce  ! 7388: WRPR_TSTATE_I	wrpr	%r20, 0x01ce, %tstate
	.word 0xbbabc820  ! 7390: FMOVVC	fmovs	%fcc1, %f0, %f29
	.word 0xb5641800  ! 7391: MOVcc_R	<illegal instruction>
	.word 0xb3a98820  ! 7393: FMOVNEG	fmovs	%fcc1, %f0, %f25
	.word 0xb7a81820  ! 7394: FMOVRGZ	fmovs	%fcc3, %f0, %f27
	.word 0xb9a548a0  ! 7396: FSUBs	fsubs	%f21, %f0, %f28
hwintr_1_337:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_337), 16, 16)) -> intp(1, 0, 3a)
	.word 0xb7504000  ! 7403: RDPR_TNPC	<illegal instruction>
hwintr_1_338:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_338), 16, 16)) -> intp(1, 0, 2c)
	.word 0xb5a44940  ! 7405: FMULd	fmuld	%f48, %f0, %f26
	.word 0xbfa80420  ! 7406: FMOVRZ	dis not found

	mov	2, %r12
	.word 0x8f932000  ! 7407: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
hwintr_1_339:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_339), 16, 16)) -> intp(1, 0, 2)
	ldda	[%r18 + %g0] 0xf0, %f2
	ldda	[%r18 + %g0] 0xf0, %f2
	.word 0xb7a00020  ! 7420: FMOVs	fmovs	%f0, %f27
	.word 0xb7a44960  ! 7423: FMULq	dis not found

	.word 0xb49de092  ! 7425: XORcc_I	xorcc 	%r23, 0x0092, %r26
	.word 0xb3504000  ! 7426: RDPR_TNPC	<illegal instruction>
	.word 0xb350c000  ! 7429: RDPR_TT	<illegal instruction>
	.word 0xb1520000  ! 7432: RDPR_PIL	<illegal instruction>
	.word 0xb1a54920  ! 7434: FMULs	fmuls	%f21, %f0, %f24
	.word 0xbda81420  ! 7436: FMOVRNZ	dis not found

	.word 0xb7a00560  ! 7438: FSQRTq	fsqrt	
hwintr_1_340:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_340), 16, 16)) -> intp(1, 0, 32)
	.word 0xbbab8820  ! 7441: FMOVPOS	fmovs	%fcc1, %f0, %f29
	mov	2, %r14
	.word 0xa193a000  ! 7449: WRPR_GL_I	wrpr	%r14, 0x0000, %-
hwintr_1_341:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_341), 16, 16)) -> intp(1, 0, 28)
hwintr_1_342:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_342), 16, 16)) -> intp(1, 0, 1d)
	.word 0xb7504000  ! 7458: RDPR_TNPC	<illegal instruction>
hwintr_1_343:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_343), 16, 16)) -> intp(1, 0, 1)
	.word 0xbb500000  ! 7464: RDPR_TPC	<illegal instruction>
	.word 0x8394e0f3  ! 7471: WRPR_TNPC_I	wrpr	%r19, 0x00f3, %tnpc
	.word 0xb3a80820  ! 7472: FMOVRLEZ	fmovs	%fcc1, %f0, %f25
	.word 0xbd504000  ! 7474: RDPR_TNPC	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982b99  ! 7482: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b99, %hpstate
	.word 0xb7a5c9a0  ! 7485: FDIVs	fdivs	%f23, %f0, %f27
	.word 0xb9508000  ! 7487: RDPR_TSTATE	<illegal instruction>
	.word 0xbda00040  ! 7488: FMOVd	fmovd	%f0, %f30
	.word 0xb7a489c0  ! 7490: FDIVd	fdivd	%f18, %f0, %f58
	.word 0xb3a80820  ! 7492: FMOVN	fmovs	%fcc1, %f0, %f25
	.word 0xb9a9c820  ! 7502: FMOVVS	fmovs	%fcc1, %f0, %f28
	.word 0xb7a00520  ! 7503: FSQRTs	fsqrt	
hwintr_1_344:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_344), 16, 16)) -> intp(1, 0, 27)
	.word 0xbda00560  ! 7509: FSQRTq	fsqrt	
	.word 0xb5480000  ! 7510: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	.word 0xbf7dc400  ! 7511: MOVR_R	movre	%r23, %r0, %r31
	.word 0xb1aac820  ! 7515: FMOVGE	fmovs	%fcc1, %f0, %f24
	.word 0xbca4605f  ! 7519: SUBcc_I	subcc 	%r17, 0x005f, %r30
	ldda	[%r18 + %g0] 0xf0, %f2
	.word 0xba9cc000  ! 7527: XORcc_R	xorcc 	%r19, %r0, %r29
	.word 0xb48c4000  ! 7528: ANDcc_R	andcc 	%r17, %r0, %r26
	mov	1, %r14
	.word 0xa193a000  ! 7530: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbb504000  ! 7534: RDPR_TNPC	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81983f1b  ! 7537: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f1b, %hpstate
	.word 0xbda589c0  ! 7538: FDIVd	fdivd	%f22, %f0, %f30
	ldda	[%r18 + %g0] 0xf0, %f2
	.word 0xb7a84820  ! 7540: FMOVE	fmovs	%fcc1, %f0, %f27
	.word 0xbda81c20  ! 7545: FMOVRGEZ	dis not found

hwintr_1_345:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_345), 16, 16)) -> intp(1, 0, 3)
hwintr_1_346:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_346), 16, 16)) -> intp(1, 0, 12)
	.word 0xb7a81420  ! 7555: FMOVRNZ	dis not found

	.word 0xbda5c9c0  ! 7557: FDIVd	fdivd	%f54, %f0, %f30
	.word 0xb751c000  ! 7558: RDPR_TL	<illegal instruction>
	.word 0x859461a0  ! 7560: WRPR_TSTATE_I	wrpr	%r17, 0x01a0, %tstate
	.word 0xbba5c9e0  ! 7561: FDIVq	dis not found

	.word 0xbdabc820  ! 7562: FMOVVC	fmovs	%fcc1, %f0, %f30
	.word 0xbdab8820  ! 7564: FMOVPOS	fmovs	%fcc1, %f0, %f30
	.word 0x899461e9  ! 7565: WRPR_TICK_I	wrpr	%r17, 0x01e9, %tick
	.word 0xbda84820  ! 7566: FMOVE	fmovs	%fcc1, %f0, %f30
	.word 0xb3ab4820  ! 7569: FMOVCC	fmovs	%fcc1, %f0, %f25
	.word 0xbd480000  ! 7572: RDHPR_HPSTATE	rdhpr	%hpstate, %r30
	.word 0x919421ac  ! 7573: WRPR_PIL_I	wrpr	%r16, 0x01ac, %pil
	.word 0xb1a00560  ! 7574: FSQRTq	fsqrt	
	ta	T_CHANGE_HPRIV
	.word 0x819828c9  ! 7577: WRHPR_HPSTATE_I	wrhpr	%r0, 0x08c9, %hpstate
	.word 0x8d94a151  ! 7578: WRPR_PSTATE_I	wrpr	%r18, 0x0151, %pstate
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV
	.word 0x8198389b  ! 7585: WRHPR_HPSTATE_I	wrhpr	%r0, 0x189b, %hpstate
	ldda	[%r18 + %g0] 0xf0, %f2
hwintr_1_347:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_347), 16, 16)) -> intp(1, 0, 2b)
	.word 0xb950c000  ! 7590: RDPR_TT	<illegal instruction>
	.word 0x8d95a184  ! 7593: WRPR_PSTATE_I	wrpr	%r22, 0x0184, %pstate
	.word 0xb3aa4820  ! 7594: FMOVNE	fmovs	%fcc1, %f0, %f25
	.word 0xb69d20ba  ! 7595: XORcc_I	xorcc 	%r20, 0x00ba, %r27
	.word 0xbfa80c20  ! 7596: FMOVRLZ	dis not found

hwintr_1_348:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_348), 16, 16)) -> intp(1, 0, 27)
	.word 0xbf50c000  ! 7599: RDPR_TT	<illegal instruction>
	.word 0xbb518000  ! 7600: RDPR_PSTATE	<illegal instruction>
	.word 0xb5a00520  ! 7602: FSQRTs	fsqrt	
	.word 0xbfa00540  ! 7605: FSQRTd	fsqrt	
	.word 0xb9a84820  ! 7606: FMOVE	fmovs	%fcc1, %f0, %f28
	.word 0xb3350000  ! 7608: SRL_R	srl 	%r20, %r0, %r25
	.word 0xb5a80820  ! 7611: FMOVN	fmovs	%fcc1, %f0, %f26
	.word 0xbba00560  ! 7612: FSQRTq	fsqrt	
	ldda	[%r18 + %g0] 0xf0, %f2
	.word 0xb1a81820  ! 7620: FMOVRGZ	fmovs	%fcc3, %f0, %f24
	.word 0xbe45c000  ! 7623: ADDC_R	addc 	%r23, %r0, %r31
	.word 0xb7a508a0  ! 7625: FSUBs	fsubs	%f20, %f0, %f27
	.word 0xbba409c0  ! 7627: FDIVd	fdivd	%f16, %f0, %f60
hwintr_1_349:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_349), 16, 16)) -> intp(1, 0, 32)
	.word 0xbba90820  ! 7633: FMOVLEU	fmovs	%fcc1, %f0, %f29
	mov	0, %r14
	.word 0xa193a000  ! 7638: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbda00560  ! 7642: FSQRTq	fsqrt	
	.word 0xbc0421d9  ! 7643: ADD_I	add 	%r16, 0x01d9, %r30
	.word 0xb3a408e0  ! 7645: FSUBq	dis not found

	.word 0xb3ab8820  ! 7646: FMOVPOS	fmovs	%fcc1, %f0, %f25
	.word 0xb5a80820  ! 7647: FMOVN	fmovs	%fcc1, %f0, %f26
	.word 0xb550c000  ! 7653: RDPR_TT	<illegal instruction>
	.word 0xb9a588a0  ! 7654: FSUBs	fsubs	%f22, %f0, %f28
	.word 0xb63521c9  ! 7655: SUBC_I	orn 	%r20, 0x01c9, %r27
	.word 0xb1aa4820  ! 7656: FMOVNE	fmovs	%fcc1, %f0, %f24
	.word 0xbfa81c20  ! 7657: FMOVRGEZ	dis not found

	.word 0xbda90820  ! 7658: FMOVLEU	fmovs	%fcc1, %f0, %f30
	.word 0xb3a00520  ! 7659: FSQRTs	fsqrt	
	.word 0xb7a88820  ! 7664: FMOVLE	fmovs	%fcc1, %f0, %f27
	.word 0xb1a44820  ! 7666: FADDs	fadds	%f17, %f0, %f24
	.word 0xbfa00520  ! 7667: FSQRTs	fsqrt	
	.word 0x879521e2  ! 7668: WRPR_TT_I	wrpr	%r20, 0x01e2, %tt
	.word 0xb7ab0820  ! 7673: FMOVGU	fmovs	%fcc1, %f0, %f27
	.word 0xbda409e0  ! 7674: FDIVq	dis not found

	.word 0xb7643801  ! 7675: MOVcc_I	<illegal instruction>
	.word 0xbfa5c960  ! 7676: FMULq	dis not found

	.word 0xbfa5c860  ! 7678: FADDq	dis not found

	.word 0xb3a81c20  ! 7680: FMOVRGEZ	dis not found

	.word 0xbd520000  ! 7681: RDPR_PIL	<illegal instruction>
	.word 0xbda80420  ! 7682: FMOVRZ	dis not found

	.word 0xb6c58000  ! 7685: ADDCcc_R	addccc 	%r22, %r0, %r27
hwintr_1_350:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_350), 16, 16)) -> intp(1, 0, 39)
	.word 0x839561cc  ! 7691: WRPR_TNPC_I	wrpr	%r21, 0x01cc, %tnpc
	.word 0xbba84820  ! 7693: FMOVE	fmovs	%fcc1, %f0, %f29
	.word 0xb9a00560  ! 7696: FSQRTq	fsqrt	
	.word 0xb7a40940  ! 7698: FMULd	fmuld	%f16, %f0, %f58
hwintr_1_351:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_351), 16, 16)) -> intp(1, 0, 15)
	.word 0xb5518000  ! 7705: RDPR_PSTATE	<illegal instruction>
	.word 0xb7510000  ! 7707: RDPR_TICK	<illegal instruction>
	.word 0x8d95e0a8  ! 7709: WRPR_PSTATE_I	wrpr	%r23, 0x00a8, %pstate
hwintr_1_352:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_352), 16, 16)) -> intp(1, 0, 16)
	.word 0xbda488c0  ! 7716: FSUBd	fsubd	%f18, %f0, %f30
	.word 0xbfaa8820  ! 7721: FMOVG	fmovs	%fcc1, %f0, %f31
	.word 0xb951c000  ! 7723: RDPR_TL	<illegal instruction>
	.word 0xb7a80c20  ! 7724: FMOVRLZ	dis not found

	.word 0xb7a00520  ! 7727: FSQRTs	fsqrt	
	.word 0xb7abc820  ! 7729: FMOVVC	fmovs	%fcc1, %f0, %f27
	.word 0xb5508000  ! 7733: RDPR_TSTATE	<illegal instruction>
	.word 0xb5a80420  ! 7735: FMOVRZ	dis not found

	.word 0x8d95e155  ! 7736: WRPR_PSTATE_I	wrpr	%r23, 0x0155, %pstate
	.word 0x859421be  ! 7737: WRPR_TSTATE_I	wrpr	%r16, 0x01be, %tstate
	mov	2, %r12
	.word 0x8f932000  ! 7738: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbbab4820  ! 7740: FMOVCC	fmovs	%fcc1, %f0, %f29
	.word 0xbba00020  ! 7741: FMOVs	fmovs	%f0, %f29
	.word 0xb9a58840  ! 7749: FADDd	faddd	%f22, %f0, %f28
	.word 0xb3a54860  ! 7750: FADDq	dis not found

	.word 0xb9510000  ! 7752: RDPR_TICK	<illegal instruction>
	.word 0xb9508000  ! 7753: RDPR_TSTATE	<illegal instruction>
	.word 0xb9a549e0  ! 7754: FDIVq	dis not found

hwintr_1_353:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_353), 16, 16)) -> intp(1, 0, 27)
	.word 0xb425c000  ! 7756: SUB_R	sub 	%r23, %r0, %r26
	.word 0xbda40960  ! 7759: FMULq	dis not found

	.word 0xbdabc820  ! 7760: FMOVVC	fmovs	%fcc1, %f0, %f30
	.word 0xb5a98820  ! 7762: FMOVNEG	fmovs	%fcc1, %f0, %f26
	.word 0xb3a88820  ! 7767: FMOVLE	fmovs	%fcc1, %f0, %f25
	.word 0xb9480000  ! 7770: RDHPR_HPSTATE	rdhpr	%hpstate, %r28
	.word 0xb5a00560  ! 7771: FSQRTq	fsqrt	
	.word 0xb7ab4820  ! 7774: FMOVCC	fmovs	%fcc1, %f0, %f27
	.word 0xbba81820  ! 7777: FMOVRGZ	fmovs	%fcc3, %f0, %f29
	.word 0xb951c000  ! 7779: RDPR_TL	<illegal instruction>
	.word 0xb9a88820  ! 7782: FMOVLE	fmovs	%fcc1, %f0, %f28
	.word 0xbf357001  ! 7783: SRLX_I	srlx	%r21, 0x0001, %r31
	.word 0xb7a00520  ! 7790: FSQRTs	fsqrt	
hwintr_1_354:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_354), 16, 16)) -> intp(1, 0, 17)
hwintr_1_355:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_355), 16, 16)) -> intp(1, 0, 15)
	.word 0xb5a54940  ! 7794: FMULd	fmuld	%f52, %f0, %f26
	.word 0xbe9ce177  ! 7800: XORcc_I	xorcc 	%r19, 0x0177, %r31
	.word 0xbda00560  ! 7802: FSQRTq	fsqrt	
	ldda	[%r23 + %g0] 0xf0, %f2
	.word 0xb3520000  ! 7805: RDPR_PIL	<illegal instruction>
	.word 0xb5a54960  ! 7807: FMULq	dis not found

	.word 0xbb349000  ! 7809: SRLX_R	srlx	%r18, %r0, %r29
hwintr_1_356:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_356), 16, 16)) -> intp(1, 0, 1b)
	.word 0xb9a90820  ! 7811: FMOVLEU	fmovs	%fcc1, %f0, %f28
	.word 0xb7504000  ! 7812: RDPR_TNPC	<illegal instruction>
	.word 0xbc95211c  ! 7813: ORcc_I	orcc 	%r20, 0x011c, %r30
	.word 0xbf508000  ! 7815: RDPR_TSTATE	<illegal instruction>
	.word 0xbfaa4820  ! 7822: FMOVNE	fmovs	%fcc1, %f0, %f31
	.word 0xb1520000  ! 7824: RDPR_PIL	<illegal instruction>
	.word 0xbfa44860  ! 7825: FADDq	dis not found

	.word 0xbdaac820  ! 7829: FMOVGE	fmovs	%fcc1, %f0, %f30
	.word 0xb3a54920  ! 7830: FMULs	fmuls	%f21, %f0, %f25
	.word 0xb3a489a0  ! 7831: FDIVs	fdivs	%f18, %f0, %f25
	.word 0x8d94e0f3  ! 7834: WRPR_PSTATE_I	wrpr	%r19, 0x00f3, %pstate
hwintr_1_357:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_357), 16, 16)) -> intp(1, 0, 18)
	.word 0xb7a80c20  ! 7838: FMOVRLZ	dis not found

	.word 0xbba44960  ! 7839: FMULq	dis not found

	.word 0x899461a6  ! 7840: WRPR_TICK_I	wrpr	%r17, 0x01a6, %tick
	.word 0xb9a00560  ! 7841: FSQRTq	fsqrt	
	.word 0xb1a54860  ! 7842: FADDq	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x81982e4b  ! 7844: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e4b, %hpstate
	.word 0xb3a509a0  ! 7845: FDIVs	fdivs	%f20, %f0, %f25
	.word 0xb5aac820  ! 7847: FMOVGE	fmovs	%fcc1, %f0, %f26
	.word 0xb3a5c860  ! 7848: FADDq	dis not found

	.word 0xba35a0f0  ! 7849: ORN_I	orn 	%r22, 0x00f0, %r29
	.word 0xb1a81820  ! 7851: FMOVRGZ	fmovs	%fcc3, %f0, %f24
	.word 0xb7a44940  ! 7856: FMULd	fmuld	%f48, %f0, %f58
	.word 0xbda00520  ! 7857: FSQRTs	fsqrt	
hwintr_1_358:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_358), 16, 16)) -> intp(1, 0, 28)
	.word 0xba256167  ! 7862: SUB_I	sub 	%r21, 0x0167, %r29
	.word 0xbbabc820  ! 7865: FMOVVC	fmovs	%fcc1, %f0, %f29
	.word 0xb1a44820  ! 7867: FADDs	fadds	%f17, %f0, %f24
	.word 0xbf504000  ! 7870: RDPR_TNPC	<illegal instruction>
	.word 0xb5a8c820  ! 7871: FMOVL	fmovs	%fcc1, %f0, %f26
	.word 0xb1a90820  ! 7873: FMOVLEU	fmovs	%fcc1, %f0, %f24
	.word 0xbc154000  ! 7877: OR_R	or 	%r21, %r0, %r30
	.word 0xb53cf001  ! 7882: SRAX_I	srax	%r19, 0x0001, %r26
	.word 0xbda4c940  ! 7883: FMULd	fmuld	%f50, %f0, %f30
	.word 0xb9ab0820  ! 7886: FMOVGU	fmovs	%fcc1, %f0, %f28
	.word 0xb7a9c820  ! 7887: FMOVVS	fmovs	%fcc1, %f0, %f27
	.word 0xbbab8820  ! 7891: FMOVPOS	fmovs	%fcc1, %f0, %f29
	.word 0xb1a00540  ! 7896: FSQRTd	fsqrt	
	ta	T_CHANGE_HPRIV
	.word 0x81983b19  ! 7897: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1b19, %hpstate
hwintr_1_359:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_359), 16, 16)) -> intp(1, 0, 13)
	.word 0xbb504000  ! 7900: RDPR_TNPC	<illegal instruction>
hwintr_1_360:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_360), 16, 16)) -> intp(1, 0, 7)
	.word 0xbda00020  ! 7903: FMOVs	fmovs	%f0, %f30
	.word 0xb2a40000  ! 7909: SUBcc_R	subcc 	%r16, %r0, %r25
	ta	T_CHANGE_HPRIV
	.word 0x81982e11  ! 7911: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0e11, %hpstate
	.word 0xbf518000  ! 7915: RDPR_PSTATE	<illegal instruction>
	.word 0xb9a54840  ! 7918: FADDd	faddd	%f52, %f0, %f28
	.word 0xb3508000  ! 7919: RDPR_TSTATE	<illegal instruction>
	.word 0xb9a81c20  ! 7923: FMOVRGEZ	dis not found

hwintr_1_361:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_361), 16, 16)) -> intp(1, 0, 34)
hwintr_1_362:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_362), 16, 16)) -> intp(1, 0, 16)
	.word 0xb1508000  ! 7926: RDPR_TSTATE	<illegal instruction>
	.word 0xbd540000  ! 7927: RDPR_GL	<illegal instruction>
	ta	T_CHANGE_HPRIV
	.word 0x81982a99  ! 7928: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0a99, %hpstate
	.word 0x81952145  ! 7929: WRPR_TPC_I	wrpr	%r20, 0x0145, %tpc
	.word 0x81956141  ! 7934: WRPR_TPC_I	wrpr	%r21, 0x0141, %tpc
	ldda	[%r16 + %g0] 0xf0, %f2
	.word 0xbbab4820  ! 7943: FMOVCC	fmovs	%fcc1, %f0, %f29
hwintr_1_363:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_363), 16, 16)) -> intp(1, 0, 22)
	.word 0xb1a48940  ! 7947: FMULd	fmuld	%f18, %f0, %f24
	.word 0xbba449a0  ! 7951: FDIVs	fdivs	%f17, %f0, %f29
hwintr_1_364:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_364), 16, 16)) -> intp(1, 0, 23)
	.word 0xbc35c000  ! 7959: ORN_R	orn 	%r23, %r0, %r30
	.word 0xb5a44960  ! 7961: FMULq	dis not found

	ldda	[%r22 + %g0] 0xf0, %f2
	ldda	[%r22 + %g0] 0xf0, %f2
	.word 0xb1a50860  ! 7967: FADDq	dis not found

	.word 0xbfa81c20  ! 7970: FMOVRGEZ	dis not found

	.word 0xbfa80420  ! 7971: FMOVRZ	dis not found

	.word 0xb7a5c960  ! 7972: FMULq	dis not found

	.word 0xb9a508a0  ! 7975: FSUBs	fsubs	%f20, %f0, %f28
	.word 0xb3a54840  ! 7976: FADDd	faddd	%f52, %f0, %f56
	mov	2, %r14
	.word 0xa193a000  ! 7978: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xbda508a0  ! 7980: FSUBs	fsubs	%f20, %f0, %f30
	.word 0xb1a9c820  ! 7982: FMOVVS	fmovs	%fcc1, %f0, %f24
	.word 0xbf504000  ! 7983: RDPR_TNPC	<illegal instruction>
	.word 0xb5a5c840  ! 7984: FADDd	faddd	%f54, %f0, %f26
	.word 0xb7a44920  ! 7986: FMULs	fmuls	%f17, %f0, %f27
hwintr_1_365:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_365), 16, 16)) -> intp(1, 0, 3f)
	.word 0x87952071  ! 7990: WRPR_TT_I	wrpr	%r20, 0x0071, %tt
	.word 0xb9a00560  ! 7993: FSQRTq	fsqrt	
	.word 0xbda00520  ! 7995: FSQRTs	fsqrt	
	.word 0xbbaa8820  ! 7997: FMOVG	fmovs	%fcc1, %f0, %f29
	.word 0xb2bda189  ! 7999: XNORcc_I	xnorcc 	%r22, 0x0189, %r25
	.word 0xbba81c20  ! 8000: FMOVRGEZ	dis not found

hwintr_1_366:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_366), 16, 16)) -> intp(1, 0, 20)
	.word 0xbfa4c840  ! 8005: FADDd	faddd	%f50, %f0, %f62
	.word 0xb9504000  ! 8008: RDPR_TNPC	<illegal instruction>
hwintr_1_367:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_367), 16, 16)) -> intp(1, 0, 1b)
hwintr_1_368:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_368), 16, 16)) -> intp(1, 0, 27)
	.word 0xbfa81820  ! 8015: FMOVRGZ	fmovs	%fcc3, %f0, %f31
	.word 0xbda409e0  ! 8016: FDIVq	dis not found

	.word 0xb1a90820  ! 8019: FMOVLEU	fmovs	%fcc1, %f0, %f24
	.word 0x839521d4  ! 8021: WRPR_TNPC_I	wrpr	%r20, 0x01d4, %tnpc
	ta	T_CHANGE_HPRIV
	.word 0x81982cd9  ! 8022: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0cd9, %hpstate
hwintr_1_369:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_369), 16, 16)) -> intp(1, 0, 22)
	.word 0xb3a00560  ! 8025: FSQRTq	fsqrt	
	.word 0xb1a80820  ! 8030: FMOVRLEZ	fmovs	%fcc1, %f0, %f24
	.word 0xb7a81820  ! 8034: FMOVRGZ	fmovs	%fcc3, %f0, %f27
	.word 0xb13cc000  ! 8035: SRA_R	sra 	%r19, %r0, %r24
hwintr_1_370:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_370), 16, 16)) -> intp(1, 0, 19)
	.word 0xb550c000  ! 8038: RDPR_TT	<illegal instruction>
	.word 0x89952036  ! 8039: WRPR_TICK_I	wrpr	%r20, 0x0036, %tick
hwintr_1_371:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_371), 16, 16)) -> intp(1, 0, d)
	.word 0xb3a44860  ! 8041: FADDq	dis not found

	.word 0xbba44940  ! 8042: FMULd	fmuld	%f48, %f0, %f60
hwintr_1_372:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_372), 16, 16)) -> intp(1, 0, 22)
	.word 0xb3ab0820  ! 8046: FMOVGU	fmovs	%fcc1, %f0, %f25
hwintr_1_373:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_373), 16, 16)) -> intp(1, 0, 1f)
	.word 0xb9a588e0  ! 8049: FSUBq	dis not found

hwintr_1_374:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_374), 16, 16)) -> intp(1, 0, 31)
	.word 0xb7500000  ! 8052: RDPR_TPC	<illegal instruction>
	.word 0xb5500000  ! 8054: RDPR_TPC	<illegal instruction>
	.word 0xb485a08d  ! 8055: ADDcc_I	addcc 	%r22, 0x008d, %r26
	ldda	[%r22 + %g0] 0xf0, %f2
	.word 0xb3ab0820  ! 8065: FMOVGU	fmovs	%fcc1, %f0, %f25
	.word 0xb5a448e0  ! 8069: FSUBq	dis not found

	.word 0xb751c000  ! 8072: RDPR_TL	<illegal instruction>
	.word 0xbda00040  ! 8074: FMOVd	fmovd	%f0, %f30
	.word 0xb9a508e0  ! 8077: FSUBq	dis not found

hwintr_1_375:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_375), 16, 16)) -> intp(1, 0, 17)
	.word 0xb0350000  ! 8090: ORN_R	orn 	%r20, %r0, %r24
	.word 0xb3a50820  ! 8091: FADDs	fadds	%f20, %f0, %f25
hwintr_1_376:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_376), 16, 16)) -> intp(1, 0, 1a)
	ldda	[%r22 + %g0] 0xf0, %f2
	.word 0xb1a50840  ! 8098: FADDd	faddd	%f20, %f0, %f24
	.word 0xb9ab0820  ! 8099: FMOVGU	fmovs	%fcc1, %f0, %f28
	.word 0xb2c4211b  ! 8101: ADDCcc_I	addccc 	%r16, 0x011b, %r25
	.word 0xb7abc820  ! 8103: FMOVVC	fmovs	%fcc1, %f0, %f27
	.word 0xb3a81820  ! 8106: FMOVRGZ	fmovs	%fcc3, %f0, %f25
	.word 0xb9520000  ! 8108: RDPR_PIL	<illegal instruction>
	ldda	[%r22 + %g0] 0xf0, %f2
hwintr_1_377:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_377), 16, 16)) -> intp(1, 0, 32)
	.word 0xb1a9c820  ! 8115: FMOVVS	fmovs	%fcc1, %f0, %f24
	.word 0xb3540000  ! 8116: RDPR_GL	<illegal instruction>
	.word 0x85952001  ! 8117: WRPR_TSTATE_I	wrpr	%r20, 0x0001, %tstate
	.word 0xb2ac6008  ! 8119: ANDNcc_I	andncc 	%r17, 0x0008, %r25
hwintr_1_378:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_378), 16, 16)) -> intp(1, 0, 0)
hwintr_1_379:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_379), 16, 16)) -> intp(1, 0, 29)
	.word 0xbb508000  ! 8126: RDPR_TSTATE	<illegal instruction>
	.word 0xbfa9c820  ! 8130: FMOVVS	fmovs	%fcc1, %f0, %f31
	.word 0xb6b44000  ! 8131: ORNcc_R	orncc 	%r17, %r0, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81982b43  ! 8135: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0b43, %hpstate
	ta	T_CHANGE_HPRIV
	.word 0x81983f09  ! 8137: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1f09, %hpstate
	.word 0xbfa508c0  ! 8139: FSUBd	fsubd	%f20, %f0, %f62
	.word 0xb9500000  ! 8146: RDPR_TPC	<illegal instruction>
	.word 0xbc148000  ! 8148: OR_R	or 	%r18, %r0, %r30
	.word 0xb9a50960  ! 8154: FMULq	dis not found

	.word 0xb3a9c820  ! 8157: FMOVVS	fmovs	%fcc1, %f0, %f25
hwintr_1_380:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_380), 16, 16)) -> intp(1, 0, 29)
	.word 0xbda48960  ! 8162: FMULq	dis not found

hwintr_1_381:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_381), 16, 16)) -> intp(1, 0, 16)
	.word 0xb3aa8820  ! 8164: FMOVG	fmovs	%fcc1, %f0, %f25
hwintr_1_382:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_382), 16, 16)) -> intp(1, 0, 39)
	.word 0xb1508000  ! 8169: RDPR_TSTATE	<illegal instruction>
	.word 0xb1a00540  ! 8178: FSQRTd	fsqrt	
	.word 0xb3a80820  ! 8183: FMOVRLEZ	fmovs	%fcc1, %f0, %f25
	.word 0x839521c8  ! 8185: WRPR_TNPC_I	wrpr	%r20, 0x01c8, %tnpc
	.word 0xbfa88820  ! 8186: FMOVLE	fmovs	%fcc1, %f0, %f31
	.word 0xbb518000  ! 8188: RDPR_PSTATE	<illegal instruction>
	.word 0xbe95e190  ! 8189: ORcc_I	orcc 	%r23, 0x0190, %r31
	.word 0xbfab0820  ! 8191: FMOVGU	fmovs	%fcc1, %f0, %f31
	.word 0xb9a81420  ! 8193: FMOVRNZ	dis not found

	.word 0xb9a489c0  ! 8194: FDIVd	fdivd	%f18, %f0, %f28
	.word 0xb3aa8820  ! 8197: FMOVG	fmovs	%fcc1, %f0, %f25
	.word 0xb1a508e0  ! 8200: FSUBq	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x81983d99  ! 8201: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d99, %hpstate
	ta	T_CHANGE_HPRIV
	mov	0, %g1
	stxa	%g0, [%g1] 0x60
	flush
	ta	T_CHANGE_NONHPRIV
	.word 0xbda00540  ! 8205: FSQRTd	fsqrt	
hwintr_1_383:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_383), 16, 16)) -> intp(1, 0, 2a)
	.word 0x8995e090  ! 8217: WRPR_TICK_I	wrpr	%r23, 0x0090, %tick
	.word 0xba2521d6  ! 8222: SUB_I	sub 	%r20, 0x01d6, %r29
	.word 0x879420b1  ! 8223: WRPR_TT_I	wrpr	%r16, 0x00b1, %tt
	.word 0xbba8c820  ! 8224: FMOVL	fmovs	%fcc1, %f0, %f29
hwintr_1_384:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_384), 16, 16)) -> intp(1, 0, 27)
	.word 0xb7a48940  ! 8228: FMULd	fmuld	%f18, %f0, %f58
	.word 0xb5a50860  ! 8230: FADDq	dis not found

	.word 0xb7518000  ! 8233: RDPR_PSTATE	<illegal instruction>
	.word 0xb3a80820  ! 8234: FMOVRLEZ	fmovs	%fcc1, %f0, %f25
	.word 0xb750c000  ! 8235: RDPR_TT	<illegal instruction>
hwintr_1_385:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_385), 16, 16)) -> intp(1, 0, 3a)
	.word 0xb7a58940  ! 8239: FMULd	fmuld	%f22, %f0, %f58
	.word 0x8195a068  ! 8240: WRPR_TPC_I	wrpr	%r22, 0x0068, %tpc
	.word 0xb6bc0000  ! 8241: XNORcc_R	xnorcc 	%r16, %r0, %r27
	.word 0xb9ab0820  ! 8244: FMOVGU	fmovs	%fcc1, %f0, %f28
	.word 0xbb540000  ! 8246: RDPR_GL	<illegal instruction>
	.word 0xbfa54920  ! 8248: FMULs	fmuls	%f21, %f0, %f31
	.word 0xb9504000  ! 8250: RDPR_TNPC	<illegal instruction>
	.word 0xbd540000  ! 8257: RDPR_GL	<illegal instruction>
	.word 0xbda40840  ! 8260: FADDd	faddd	%f16, %f0, %f30
	.word 0xb9a84820  ! 8261: FMOVE	fmovs	%fcc1, %f0, %f28
	.word 0xb7a80c20  ! 8262: FMOVRLZ	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x81983d01  ! 8263: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d01, %hpstate
	.word 0x8d95a022  ! 8265: WRPR_PSTATE_I	wrpr	%r22, 0x0022, %pstate
	.word 0xbda40920  ! 8267: FMULs	fmuls	%f16, %f0, %f30
	.word 0x8d95a03a  ! 8274: WRPR_PSTATE_I	wrpr	%r22, 0x003a, %pstate
	.word 0xb3a4c820  ! 8277: FADDs	fadds	%f19, %f0, %f25
	.word 0xb5a84820  ! 8279: FMOVE	fmovs	%fcc1, %f0, %f26
	.word 0xb1510000  ! 8281: RDPR_TICK	<illegal instruction>
	.word 0xbba00540  ! 8285: FSQRTd	fsqrt	
	.word 0x85946000  ! 8287: WRPR_TSTATE_I	wrpr	%r17, 0x0000, %tstate
	.word 0xb9a9c820  ! 8288: FMOVVS	fmovs	%fcc1, %f0, %f28
	.word 0xb5a00040  ! 8289: FMOVd	fmovd	%f0, %f26
hwintr_1_386:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_386), 16, 16)) -> intp(1, 0, 27)
	.word 0xbb504000  ! 8292: RDPR_TNPC	<illegal instruction>
	.word 0xb3aa8820  ! 8293: FMOVG	fmovs	%fcc1, %f0, %f25
	.word 0xb9a409a0  ! 8294: FDIVs	fdivs	%f16, %f0, %f28
	.word 0xb1a84820  ! 8295: FMOVE	fmovs	%fcc1, %f0, %f24
hwintr_1_387:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_387), 16, 16)) -> intp(1, 0, 32)
	.word 0xbfa489a0  ! 8309: FDIVs	fdivs	%f18, %f0, %f31
	.word 0xb9a448a0  ! 8311: FSUBs	fsubs	%f17, %f0, %f28
	.word 0xb4344000  ! 8312: ORN_R	orn 	%r17, %r0, %r26
hwintr_1_388:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_388), 16, 16)) -> intp(1, 0, d)
	.word 0xb73c5000  ! 8316: SRAX_R	srax	%r17, %r0, %r27
	ta	T_CHANGE_HPRIV
	.word 0x81983d1b  ! 8319: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1d1b, %hpstate
	.word 0xbba509c0  ! 8323: FDIVd	fdivd	%f20, %f0, %f60
	.word 0xb3a00540  ! 8327: FSQRTd	fsqrt	
	.word 0xb5480000  ! 8328: RDHPR_HPSTATE	rdhpr	%hpstate, %r26
	ta	T_CHANGE_HPRIV
	.word 0x81983c5b  ! 8329: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1c5b, %hpstate
	.word 0xbfa448a0  ! 8330: FSUBs	fsubs	%f17, %f0, %f31
	.word 0xbfa00040  ! 8333: FMOVd	fmovd	%f0, %f62
	.word 0xbba94820  ! 8334: FMOVCS	fmovs	%fcc1, %f0, %f29
hwintr_1_389:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_389), 16, 16)) -> intp(1, 0, b)
	.word 0xbda00020  ! 8345: FMOVs	fmovs	%f0, %f30
	.word 0xba0460da  ! 8346: ADD_I	add 	%r17, 0x00da, %r29
	.word 0x8995a161  ! 8348: WRPR_TICK_I	wrpr	%r22, 0x0161, %tick
	.word 0xbfa448c0  ! 8353: FSUBd	fsubd	%f48, %f0, %f62
	.word 0xb92db001  ! 8354: SLLX_I	sllx	%r22, 0x0001, %r28
	.word 0x8195e11a  ! 8356: WRPR_TPC_I	wrpr	%r23, 0x011a, %tpc
	.word 0xb4b5a082  ! 8358: SUBCcc_I	orncc 	%r22, 0x0082, %r26
	.word 0xb1ab0820  ! 8359: FMOVGU	fmovs	%fcc1, %f0, %f24
hwintr_1_390:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_390), 16, 16)) -> intp(1, 0, 30)
	.word 0x9194a15f  ! 8362: WRPR_PIL_I	wrpr	%r18, 0x015f, %pil
hwintr_1_391:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_391), 16, 16)) -> intp(1, 0, 1d)
hwintr_1_392:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_392), 16, 16)) -> intp(1, 0, 21)
	.word 0xbd510000  ! 8371: RDPR_TICK	<illegal instruction>
	.word 0xb9a58820  ! 8372: FADDs	fadds	%f22, %f0, %f28
	.word 0xb5a81420  ! 8378: FMOVRNZ	dis not found

	.word 0xb950c000  ! 8380: RDPR_TT	<illegal instruction>
	.word 0xb9aa0820  ! 8383: FMOVA	fmovs	%fcc1, %f0, %f28
	.word 0xbf510000  ! 8384: RDPR_TICK	<illegal instruction>
	.word 0xb5a80820  ! 8386: FMOVN	fmovs	%fcc1, %f0, %f26
hwintr_1_393:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_393), 16, 16)) -> intp(1, 0, 37)
	.word 0xb7a81420  ! 8388: FMOVRNZ	dis not found

	.word 0xb7a81c20  ! 8390: FMOVRGEZ	dis not found

	ta	T_CHANGE_HPRIV
	.word 0x81983913  ! 8392: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1913, %hpstate
	.word 0xb52df001  ! 8393: SLLX_I	sllx	%r23, 0x0001, %r26
	.word 0xb3a549e0  ! 8394: FDIVq	dis not found

	mov	0, %r12
	.word 0x8f932000  ! 8395: WRPR_TL_I	wrpr	%r12, 0x0000, %tl
	.word 0xbba80820  ! 8396: FMOVRLEZ	fmovs	%fcc1, %f0, %f29
	.word 0xb8356187  ! 8401: SUBC_I	orn 	%r21, 0x0187, %r28
	.word 0xbb480000  ! 8402: RDHPR_HPSTATE	rdhpr	%hpstate, %r29
	.word 0xbba80c20  ! 8403: FMOVRLZ	dis not found

	.word 0xb7a81420  ! 8405: FMOVRNZ	dis not found

	.word 0xbfa408e0  ! 8408: FSUBq	dis not found

hwintr_1_394:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_394), 16, 16)) -> intp(1, 0, 35)
	.word 0xb9aa4820  ! 8418: FMOVNE	fmovs	%fcc1, %f0, %f28
hwintr_1_395:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_395), 16, 16)) -> intp(1, 0, 30)
	.word 0xb92c3001  ! 8422: SLLX_I	sllx	%r16, 0x0001, %r28
	.word 0xbba448a0  ! 8424: FSUBs	fsubs	%f17, %f0, %f29
	ta	T_CHANGE_HPRIV
	.word 0x81983fc9  ! 8427: WRHPR_HPSTATE_I	wrhpr	%r0, 0x1fc9, %hpstate
	.word 0xb5504000  ! 8430: RDPR_TNPC	<illegal instruction>
	.word 0xbb508000  ! 8431: RDPR_TSTATE	<illegal instruction>
	.word 0xb3a50860  ! 8433: FADDq	dis not found

	.word 0xb7aac820  ! 8434: FMOVGE	fmovs	%fcc1, %f0, %f27
hwintr_1_396:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_396), 16, 16)) -> intp(1, 0, 38)
hwintr_1_397:
!$EV trig_pc_d(1,expr(@VA(.MAIN.hwintr_1_397), 16, 16)) -> intp(1, 0, 35)
	.word 0xb5ab0820  ! 8439: FMOVGU	fmovs	%fcc1, %f0, %f26
	.word 0xb7a548c0  ! 8440: FSUBd	fsubd	%f52, %f0, %f58
	.word 0x8195a07d  ! 8443: WRPR_TPC_I	wrpr	%r22, 0x007d, %tpc
	mov	1, %r14
	.word 0xa193a000  ! 8444: WRPR_GL_I	wrpr	%r14, 0x0000, %-
	.word 0xb1540000  ! 8445: RDPR_GL	<illegal instruction>
	.word 0x81952019  ! 8449: WRPR_TPC_I	wrpr	%r20, 0x0019, %tpc
	.word 0xbda488a0  ! 8453: FSUBs	fsubs	%f18, %f0, %f30
	.word 0xb1520000  ! 8454: RDPR_PIL	<illegal instruction>
	.word 0xbf540000  ! 8455: RDPR_GL	<illegal instruction>
	.word 0xbfa90820  ! 8456: FMOVLEU	fmovs	%fcc1, %f0, %f31
	ta	T_CHANGE_HPRIV
	.word 0x81982ed9  ! 8457: WRHPR_HPSTATE_I	wrhpr	%r0, 0x0ed9, %hpstate
	.word 0xb1a00540  ! 8458: FSQRTd	fsqrt	
	.word 0xbda4c840  ! 8459: FADDd	faddd	%f50, %f0, %f30
	.word 0x89956175  ! 8462: WRPR_TICK_I	wrpr	%r21, 0x0175, %tick
	.word 0xb9a81420  ! 8471: FMOVRNZ	dis not found

	.word 0xb53d3001  ! 8474: SRAX_I	srax	%r20, 0x0001, %r26
	ta	T_CHANGE_HPRIV
	.word 0x8198398b  ! 8477: WRHPR_HPSTATE_I	wrhpr	%r0, 0x198b, %hpstate
	.word 0xb7aa4820  ! 8478: FMOVNE	fmovs	%fcc1, %f0, %f2