// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: fp_fdiv_man_sv.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/***********************************************************************
 * Name:   fp_muldiv0.s
 * Date:   07/29/03
 *
 *
 *  Description:
 *  	This test is intended test fp mul and div
 *
 **********************************************************************/

#define	H_T0_Fp_exception_ieee_754_0x21 T0_Fp_exception_ieee_754
#define	H_T0_Fp_exception_other_0x22 T0_Fp_exception_other

#define ENABLE_T0_Fp_disabled_0x20
#include "boot.s"

.global sam_fast_immu_miss
.global sam_fast_dmmu_miss

.text
.global main  

main:

        wr      	%g0, 0x4, %fprs         /* make sure fef is 1 */

	setx		fsr_tem_en, %l0, %l3	! fsr tem enable value

/*******************************************************
 * Simple data
 *******************************************************/

	! By default, mask is disabled

	ld	[%l3+0x0], %fsr		! Read it from memory - trap disabled

	setx    fp_fdivd, %l0, %l4      ! Double precision data

!!!	set	0x40, %g6		! Max loop count rd
	set	0x177, %g6		! Max loop count rd
	set	0x0,  %g2               ! loop1 iterator
	
	set	0x0,  %g5               ! loop1 iterator
	set	0x0,  %g7               ! loop0 iterator	

	walking_one_loop1:		
	
	ldd     [%l4+%g2], %f0          
	add     %g2, 0x8,  %g2

	ldd     [%l4+%g2], %f2
	add     %g2, 0x8,  %g2

	fdivd   %f0, %f2, %f10
	fdivd   %f2, %f0, %f20
		
	add	%g5, 0x1, %g5
	subcc	%g5, %g6, %g9
	
	bne,a	walking_one_loop1	! If not 0, go to test more
        nop

	
/*******************************************************
 * Exit code
 *******************************************************/

test_pass:
	ta		T_GOOD_TRAP

test_fail:
	ta		T_BAD_TRAP

/*******************************************************
 * Data section 
 *******************************************************/
	
.data

.align 512

fp_fdivd:
! Special cases (for fdivd):
! FPop(+{minsub,min,max},(1.0+3ulp)) RN,RZ,RM,RP
        .word   0,0x00000000,0x000000a5,0x00000000,0x00000001
        .word   0x3ff00000,0x00000003,0x00000000,0x00000001
        .word   0,0x00000000,0x000000a5,0x00100000,0x00000000
        .word   0x3ff00000,0x00000003,0x000fffff,0xfffffffd
        .word   0,0x00000000,0x00000021,0x7fefffff,0xffffffff
        .word   0x3ff00000,0x00000003,0x7fefffff,0xfffffff9
        .word   0,0x40000000,0x400000a5,0x00000000,0x00000001
        .word   0x3ff00000,0x00000003,0x00000000,0x00000000
        .word   0,0x40000000,0x400000a5,0x00100000,0x00000000
        .word   0x3ff00000,0x00000003,0x000fffff,0xfffffffd
        .word   0,0x40000000,0x40000021,0x7fefffff,0xffffffff
        .word   0x3ff00000,0x00000003,0x7fefffff,0xfffffff9
        .word   0,0xc0000000,0xc00000a5,0x00000000,0x00000001
        .word   0x3ff00000,0x00000003,0x00000000,0x00000000
        .word   0,0xc0000000,0xc00000a5,0x00100000,0x00000000
        .word   0x3ff00000,0x00000003,0x000fffff,0xfffffffd
        .word   0,0xc0000000,0xc0000021,0x7fefffff,0xffffffff
        .word   0x3ff00000,0x00000003,0x7fefffff,0xfffffff9
        .word   0,0x80000000,0x800000a5,0x00000000,0x00000001
        .word   0x3ff00000,0x00000003,0x00000000,0x00000001
        .word   0,0x80000000,0x800000a5,0x00100000,0x00000000
        .word   0x3ff00000,0x00000003,0x000fffff,0xfffffffe
        .word   0,0x80000000,0x80000021,0x7fefffff,0xffffffff
        .word   0x3ff00000,0x00000003,0x7fefffff,0xfffffffa
! FPop(-{minsub,min,max},(1.0+3ulp)) RN,RZ,RM,RP
        .word   0,0x00000000,0x000000a5,0x80000000,0x00000001
        .word   0x3ff00000,0x00000003,0x80000000,0x00000001
        .word   0,0x00000000,0x000000a5,0x80100000,0x00000000
        .word   0x3ff00000,0x00000003,0x800fffff,0xfffffffd
        .word   0,0x00000000,0x00000021,0xffefffff,0xffffffff
        .word   0x3ff00000,0x00000003,0xffefffff,0xfffffff9
        .word   0,0x40000000,0x400000a5,0x80000000,0x00000001
        .word   0x3ff00000,0x00000003,0x80000000,0x00000000
        .word   0,0x40000000,0x400000a5,0x80100000,0x00000000
        .word   0x3ff00000,0x00000003,0x800fffff,0xfffffffd
        .word   0,0x40000000,0x40000021,0xffefffff,0xffffffff
        .word   0x3ff00000,0x00000003,0xffefffff,0xfffffff9
        .word   0,0xc0000000,0xc00000a5,0x80000000,0x00000001
        .word   0x3ff00000,0x00000003,0x80000000,0x00000001
        .word   0,0xc0000000,0xc00000a5,0x80100000,0x00000000
        .word   0x3ff00000,0x00000003,0x800fffff,0xfffffffe
        .word   0,0xc0000000,0xc0000021,0xffefffff,0xffffffff
        .word   0x3ff00000,0x00000003,0xffefffff,0xfffffffa
        .word   0,0x80000000,0x800000a5,0x80000000,0x00000001
        .word   0x3ff00000,0x00000003,0x80000000,0x00000000
        .word   0,0x80000000,0x800000a5,0x80100000,0x00000000
        .word   0x3ff00000,0x00000003,0x800fffff,0xfffffffd
        .word   0,0x80000000,0x80000021,0xffefffff,0xffffffff
        .word   0x3ff00000,0x00000003,0xffefffff,0xfffffff9
! x+2ulp / x
! x+3ulp / x+ulp where x=1.333333333....
        .word   0,0x00000000,0x00000021,0x3ff55555,0x55555557
        .word   0x3ff55555,0x55555555,0x3ff00000,0x00000002
        .word   0,0x00000000,0x00000021,0x3ff55555,0x55555558
        .word   0x3ff55555,0x55555556,0x3ff00000,0x00000001
! misc
        .word   0,0,0xa5,0x000fffff,0xfffffff8
        .word   0x3ff00000,0x00000008,0x000fffff,0xfffffff0
        .word   0,0x40000000,0x400000a5,0x000fffff,0xfffffff8
        .word   0x3ff00000,0x00000008,0x000fffff,0xfffffff0
        .word   0,0x80000000,0x800000a5,0x000fffff,0xfffffff8
        .word   0x3ff00000,0x00000008,0x000fffff,0xfffffff1
        .word   0,0xc0000000,0xc00000a5,0x000fffff,0xfffffff8
        .word   0x3ff00000,0x00000008,0x000fffff,0xfffffff0
	! FPop(+-0,+-0) under all kind of roundings
        .word   0,0x00000000,0x00000210,0x00000000,0x00000000
        .word   0x00000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x00000000,0x00000210,0x80000000,0x00000000
        .word   0x80000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x00000000,0x00000210,0x00000000,0x00000000
        .word   0x80000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x00000000,0x00000210,0x80000000,0x00000000
        .word   0x00000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x40000000,0x40000210,0x00000000,0x00000000
        .word   0x00000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x40000000,0x40000210,0x80000000,0x00000000
        .word   0x80000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x40000000,0x40000210,0x00000000,0x00000000
        .word   0x80000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x40000000,0x40000210,0x80000000,0x00000000
        .word   0x00000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x80000000,0x80000210,0x00000000,0x00000000
        .word   0x00000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x80000000,0x80000210,0x80000000,0x00000000
        .word   0x80000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x80000000,0x80000210,0x00000000,0x00000000
        .word   0x80000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x80000000,0x80000210,0x80000000,0x00000000
        .word   0x00000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0xc0000000,0xc0000210,0x00000000,0x00000000
        .word   0x00000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0xc0000000,0xc0000210,0x80000000,0x00000000
        .word   0x80000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0xc0000000,0xc0000210,0x00000000,0x00000000
        .word   0x80000000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0xc0000000,0xc0000210,0x80000000,0x00000000
        .word   0x00000000,0x00000000,0x7fffffff,0xffffffff
! FPop(+minsub ,+{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0x00000000,0x00000001
        .word   0x00000000,0x00000001,0x3ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x00000000,0x00000001
        .word   0x00100000,0x00000000,0x3cb00000,0x00000000
        .word   0,0x00000000,0x00000000,0x00000000,0x00000001
        .word   0x3ff00000,0x00000000,0x00000000,0x00000001
        .word   0,0x00000000,0x000000a5,0x00000000,0x00000001
        .word   0x7fefffff,0xffffffff,0x00000000,0x00000000
        .word   0,0x00000000,0x00000000,0x00000000,0x00000001
        .word   0x7ff00000,0x00000000,0x00000000,0x00000000
        .word   0,0x00000000,0x00000210,0x00000000,0x00000001
        .word   0x7ff00000,0x00000001,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x00000000,0x00000001
        .word   0x7ff80000,0x00000000,0x7ff80000,0x00000000
! FPop(+minsub ,-{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0x00000000,0x00000001
        .word   0x80000000,0x00000001,0xbff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x00000000,0x00000001
        .word   0x80100000,0x00000000,0xbcb00000,0x00000000
        .word   0,0x00000000,0x00000000,0x00000000,0x00000001
        .word   0xbff00000,0x00000000,0x80000000,0x00000001
        .word   0,0x00000000,0x000000a5,0x00000000,0x00000001
        .word   0xffefffff,0xffffffff,0x80000000,0x00000000
        .word   0,0x00000000,0x00000000,0x00000000,0x00000001
        .word   0xfff00000,0x00000000,0x80000000,0x00000000
        .word   0,0x00000000,0x00000210,0x00000000,0x00000001
        .word   0xfff00000,0x00000001,0xfff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x00000000,0x00000001
        .word   0xfff80000,0x00000000,0xfff80000,0x00000000
! FPop(-minsub ,+{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0x80000000,0x00000001
        .word   0x00000000,0x00000001,0xbff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x80000000,0x00000001
        .word   0x00100000,0x00000000,0xbcb00000,0x00000000
        .word   0,0x00000000,0x00000000,0x80000000,0x00000001
        .word   0x3ff00000,0x00000000,0x80000000,0x00000001
        .word   0,0x00000000,0x000000a5,0x80000000,0x00000001
        .word   0x7fefffff,0xffffffff,0x80000000,0x00000000
        .word   0,0x00000000,0x00000000,0x80000000,0x00000001
        .word   0x7ff00000,0x00000000,0x80000000,0x00000000
        .word   0,0x00000000,0x00000210,0x80000000,0x00000001
        .word   0x7ff00000,0x00000001,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x80000000,0x00000001
        .word   0x7ff80000,0x00000000,0x7ff80000,0x00000000
! FPop(-minsub ,-{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0x80000000,0x00000001
        .word   0x80000000,0x00000001,0x3ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x80000000,0x00000001
        .word   0x80100000,0x00000000,0x3cb00000,0x00000000
        .word   0,0x00000000,0x00000000,0x80000000,0x00000001
        .word   0xbff00000,0x00000000,0x00000000,0x00000001
        .word   0,0x00000000,0x000000a5,0x80000000,0x00000001
        .word   0xffefffff,0xffffffff,0x00000000,0x00000000
        .word   0,0x00000000,0x00000000,0x80000000,0x00000001
        .word   0xfff00000,0x00000000,0x00000000,0x00000000
        .word   0,0x00000000,0x00000210,0x80000000,0x00000001
        .word   0xfff00000,0x00000001,0xfff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x80000000,0x00000001
        .word   0xfff80000,0x00000000,0xfff80000,0x00000000
! FPop(+min ,+{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0x00100000,0x00000000
        .word   0x00000000,0x00000001,0x43300000,0x00000000
        .word   0,0x00000000,0x00000000,0x00100000,0x00000000
        .word   0x00100000,0x00000000,0x3ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x00100000,0x00000000
        .word   0x3ff00000,0x00000000,0x00100000,0x00000000
        .word   0,0x00000000,0x000000a5,0x00100000,0x00000000
        .word   0x7fefffff,0xffffffff,0x00000000,0x00000000
        .word   0,0x00000000,0x00000000,0x00100000,0x00000000
        .word   0x7ff00000,0x00000000,0x00000000,0x00000000
        .word   0,0x00000000,0x00000210,0x00100000,0x00000000
        .word   0x7ff00000,0x00000001,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x00100000,0x00000000
        .word   0x7ff80000,0x00000000,0x7ff80000,0x00000000
! FPop(+min ,-{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0x00100000,0x00000000
        .word   0x80000000,0x00000001,0xc3300000,0x00000000
        .word   0,0x00000000,0x00000000,0x00100000,0x00000000
        .word   0x80100000,0x00000000,0xbff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x00100000,0x00000000
        .word   0xbff00000,0x00000000,0x80100000,0x00000000
        .word   0,0x00000000,0x000000a5,0x00100000,0x00000000
        .word   0xffefffff,0xffffffff,0x80000000,0x00000000
        .word   0,0x00000000,0x00000000,0x00100000,0x00000000
        .word   0xfff00000,0x00000000,0x80000000,0x00000000
        .word   0,0x00000000,0x00000210,0x00100000,0x00000000
        .word   0xfff00000,0x00000001,0xfff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x00100000,0x00000000
        .word   0xfff80000,0x00000000,0xfff80000,0x00000000
! FPop(-min ,+{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0x80100000,0x00000000
        .word   0x00000000,0x00000001,0xc3300000,0x00000000
        .word   0,0x00000000,0x00000000,0x80100000,0x00000000
        .word   0x00100000,0x00000000,0xbff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x80100000,0x00000000
        .word   0x3ff00000,0x00000000,0x80100000,0x00000000
        .word   0,0x00000000,0x000000a5,0x80100000,0x00000000
        .word   0x7fefffff,0xffffffff,0x80000000,0x00000000
        .word   0,0x00000000,0x00000000,0x80100000,0x00000000
        .word   0x7ff00000,0x00000000,0x80000000,0x00000000
        .word   0,0x00000000,0x00000210,0x80100000,0x00000000
        .word   0x7ff00000,0x00000001,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x80100000,0x00000000
        .word   0x7ff80000,0x00000000,0x7ff80000,0x00000000
! FPop(-min ,-{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0x80100000,0x00000000
        .word   0x80000000,0x00000001,0x43300000,0x00000000
        .word   0,0x00000000,0x00000000,0x80100000,0x00000000
        .word   0x80100000,0x00000000,0x3ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x80100000,0x00000000
        .word   0xbff00000,0x00000000,0x00100000,0x00000000
        .word   0,0x00000000,0x000000a5,0x80100000,0x00000000
        .word   0xffefffff,0xffffffff,0x00000000,0x00000000
        .word   0,0x00000000,0x00000000,0x80100000,0x00000000
        .word   0xfff00000,0x00000000,0x00000000,0x00000000
        .word   0,0x00000000,0x00000210,0x80100000,0x00000000
        .word   0xfff00000,0x00000001,0xfff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x80100000,0x00000000
        .word   0xfff80000,0x00000000,0xfff80000,0x00000000
! FPop(+1.0 ,+{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000129,0x3ff00000,0x00000000
        .word   0x00000000,0x00000001,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x3ff00000,0x00000000
        .word   0x00100000,0x00000000,0x7fd00000,0x00000000
        .word   0,0x00000000,0x00000000,0x3ff00000,0x00000000
        .word   0x3ff00000,0x00000000,0x3ff00000,0x00000000
        .word   0,0x00000000,0x000000a5,0x3ff00000,0x00000000
        .word   0x7fefffff,0xffffffff,0x00040000,0x00000000
        .word   0,0x00000000,0x00000000,0x3ff00000,0x00000000
        .word   0x7ff00000,0x00000000,0x00000000,0x00000000
        .word   0,0x00000000,0x00000210,0x3ff00000,0x00000000
        .word   0x7ff00000,0x00000001,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x3ff00000,0x00000000
        .word   0x7ff80000,0x00000000,0x7ff80000,0x00000000
! FPop(+1.0 ,-{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000129,0x3ff00000,0x00000000
        .word   0x80000000,0x00000001,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x3ff00000,0x00000000
        .word   0x80100000,0x00000000,0xffd00000,0x00000000
        .word   0,0x00000000,0x00000000,0x3ff00000,0x00000000
        .word   0xbff00000,0x00000000,0xbff00000,0x00000000
        .word   0,0x00000000,0x000000a5,0x3ff00000,0x00000000
        .word   0xffefffff,0xffffffff,0x80040000,0x00000000
        .word   0,0x00000000,0x00000000,0x3ff00000,0x00000000
        .word   0xfff00000,0x00000000,0x80000000,0x00000000
        .word   0,0x00000000,0x00000210,0x3ff00000,0x00000000
        .word   0xfff00000,0x00000001,0xfff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x3ff00000,0x00000000
        .word   0xfff80000,0x00000000,0xfff80000,0x00000000
! FPop(-1.0 ,+{minsub,min,1,max,inf,snan,qnan ) 
        .word   0,0x00000000,0x00000129,0xbff00000,0x00000000
        .word   0x00000000,0x00000001,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000000,0xbff00000,0x00000000
        .word   0x00100000,0x00000000,0xffd00000,0x00000000
        .word   0,0x00000000,0x00000000,0xbff00000,0x00000000
        .word   0x3ff00000,0x00000000,0xbff00000,0x00000000
        .word   0,0x00000000,0x000000a5,0xbff00000,0x00000000
        .word   0x7fefffff,0xffffffff,0x80040000,0x00000000
        .word   0,0x00000000,0x00000000,0xbff00000,0x00000000
        .word   0x7ff00000,0x00000000,0x80000000,0x00000000
        .word   0,0x00000000,0x00000210,0xbff00000,0x00000000
        .word   0x7ff00000,0x00000001,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000000,0xbff00000,0x00000000
        .word   0x7ff80000,0x00000000,0x7ff80000,0x00000000
! FPop(-1.0 ,-{minsub,min,1,max,inf,snan,qnan ) 
        .word   0,0x00000000,0x00000129,0xbff00000,0x00000000
        .word   0x80000000,0x00000001,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0xbff00000,0x00000000
        .word   0x80100000,0x00000000,0x7fd00000,0x00000000
        .word   0,0x00000000,0x00000000,0xbff00000,0x00000000
        .word   0xbff00000,0x00000000,0x3ff00000,0x00000000
        .word   0,0x00000000,0x000000a5,0xbff00000,0x00000000
        .word   0xffefffff,0xffffffff,0x00040000,0x00000000
        .word   0,0x00000000,0x00000000,0xbff00000,0x00000000
        .word   0xfff00000,0x00000000,0x00000000,0x00000000
        .word   0,0x00000000,0x00000210,0xbff00000,0x00000000
        .word   0xfff00000,0x00000001,0xfff80000,0x00000001
        .word   0,0x00000000,0x00000000,0xbff00000,0x00000000
        .word   0xfff80000,0x00000000,0xfff80000,0x00000000
! FPop(max ,{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000129,0x7fefffff,0xffffffff
        .word   0x00000000,0x00000001,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000129,0x7fefffff,0xffffffff
        .word   0x00100000,0x00000000,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x7fefffff,0xffffffff
        .word   0x3ff00000,0x00000000,0x7fefffff,0xffffffff
        .word   0,0x00000000,0x00000000,0x7fefffff,0xffffffff
        .word   0x7fefffff,0xffffffff,0x3ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x7fefffff,0xffffffff
        .word   0x7ff00000,0x00000000,0x00000000,0x00000000
        .word   0,0x00000000,0x00000210,0x7fefffff,0xffffffff
        .word   0x7ff00000,0x00000001,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x7fefffff,0xffffffff
        .word   0x7ff80000,0x00000000,0x7ff80000,0x00000000
! FPop(max ,-{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000129,0x7fefffff,0xffffffff
        .word   0x80000000,0x00000001,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000129,0x7fefffff,0xffffffff
        .word   0x80100000,0x00000000,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x7fefffff,0xffffffff
        .word   0xbff00000,0x00000000,0xffefffff,0xffffffff
        .word   0,0x00000000,0x00000000,0x7fefffff,0xffffffff
        .word   0xffefffff,0xffffffff,0xbff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x7fefffff,0xffffffff
        .word   0xfff00000,0x00000000,0x80000000,0x00000000
        .word   0,0x00000000,0x00000210,0x7fefffff,0xffffffff
        .word   0xfff00000,0x00000001,0xfff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x7fefffff,0xffffffff
        .word   0xfff80000,0x00000000,0xfff80000,0x00000000
! FPop(-max ,{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000129,0xffefffff,0xffffffff
        .word   0x00000000,0x00000001,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000129,0xffefffff,0xffffffff
        .word   0x00100000,0x00000000,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000000,0xffefffff,0xffffffff
        .word   0x3ff00000,0x00000000,0xffefffff,0xffffffff
        .word   0,0x00000000,0x00000000,0xffefffff,0xffffffff
        .word   0x7fefffff,0xffffffff,0xbff00000,0x00000000
        .word   0,0x00000000,0x00000000,0xffefffff,0xffffffff
        .word   0x7ff00000,0x00000000,0x80000000,0x00000000
        .word   0,0x00000000,0x00000210,0xffefffff,0xffffffff
        .word   0x7ff00000,0x00000001,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000000,0xffefffff,0xffffffff
        .word   0x7ff80000,0x00000000,0x7ff80000,0x00000000
! FPop(-max ,-{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000129,0xffefffff,0xffffffff
        .word   0x80000000,0x00000001,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000129,0xffefffff,0xffffffff
        .word   0x80100000,0x00000000,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0xffefffff,0xffffffff
        .word   0xbff00000,0x00000000,0x7fefffff,0xffffffff
        .word   0,0x00000000,0x00000000,0xffefffff,0xffffffff
        .word   0xffefffff,0xffffffff,0x3ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0xffefffff,0xffffffff
        .word   0xfff00000,0x00000000,0x00000000,0x00000000
        .word   0,0x00000000,0x00000210,0xffefffff,0xffffffff
        .word   0xfff00000,0x00000001,0xfff80000,0x00000001
        .word   0,0x00000000,0x00000000,0xffefffff,0xffffffff
        .word   0xfff80000,0x00000000,0xfff80000,0x00000000
! FPop(inf ,{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0x7ff00000,0x00000000
        .word   0x00000000,0x00000001,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x7ff00000,0x00000000
        .word   0x00100000,0x00000000,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x7ff00000,0x00000000
        .word   0x3ff00000,0x00000000,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x7ff00000,0x00000000
        .word   0x7fefffff,0xffffffff,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000210,0x7ff00000,0x00000000
        .word   0x7ff00000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x00000000,0x00000210,0x7ff00000,0x00000000
        .word   0x7ff00000,0x00000001,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x7ff00000,0x00000000
        .word   0x7ff80000,0x00000000,0x7ff80000,0x00000000
! FPop(inf ,-{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0x7ff00000,0x00000000
        .word   0x80000000,0x00000001,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x7ff00000,0x00000000
        .word   0x80100000,0x00000000,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x7ff00000,0x00000000
        .word   0xbff00000,0x00000000,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000000,0x7ff00000,0x00000000
        .word   0xffefffff,0xffffffff,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000210,0x7ff00000,0x00000000
        .word   0xfff00000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x00000000,0x00000210,0x7ff00000,0x00000000
        .word   0xfff00000,0x00000001,0xfff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x7ff00000,0x00000000
        .word   0xfff80000,0x00000000,0xfff80000,0x00000000
! FPop(-inf ,+{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0xfff00000,0x00000000
        .word   0x00000000,0x00000001,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000000,0xfff00000,0x00000000
        .word   0x00100000,0x00000000,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000000,0xfff00000,0x00000000
        .word   0x3ff00000,0x00000000,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000000,0xfff00000,0x00000000
        .word   0x7fefffff,0xffffffff,0xfff00000,0x00000000
        .word   0,0x00000000,0x00000210,0xfff00000,0x00000000
        .word   0x7ff00000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x00000000,0x00000210,0xfff00000,0x00000000
        .word   0x7ff00000,0x00000001,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000000,0xfff00000,0x00000000
        .word   0x7ff80000,0x00000000,0x7ff80000,0x00000000
! FPop(-inf ,-{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0xfff00000,0x00000000
        .word   0x80000000,0x00000001,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0xfff00000,0x00000000
        .word   0x80100000,0x00000000,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0xfff00000,0x00000000
        .word   0xbff00000,0x00000000,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000000,0xfff00000,0x00000000
        .word   0xffefffff,0xffffffff,0x7ff00000,0x00000000
        .word   0,0x00000000,0x00000210,0xfff00000,0x00000000
        .word   0xfff00000,0x00000000,0x7fffffff,0xffffffff
        .word   0,0x00000000,0x00000210,0xfff00000,0x00000000
        .word   0xfff00000,0x00000001,0xfff80000,0x00000001
        .word   0,0x00000000,0x00000000,0xfff00000,0x00000000
        .word   0xfff80000,0x00000000,0xfff80000,0x00000000
! FPop(snan ,{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000210,0x7ff00000,0x00000001
        .word   0x00000000,0x00000001,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000210,0x7ff00000,0x00000001
        .word   0x00100000,0x00000000,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000210,0x7ff00000,0x00000001
        .word   0x3ff00000,0x00000000,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000210,0x7ff00000,0x00000001
        .word   0x7fefffff,0xffffffff,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000210,0x7ff00000,0x00000001
        .word   0x7ff00000,0x00000000,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000210,0x7ff00000,0x00000001
        .word   0x7ff00000,0x00000002,0x7ff80000,0x00000002
        .word   0,0x00000000,0x00000210,0x7ff00000,0x00000001
        .word   0x7ff80000,0x00000000,0x7ff80000,0x00000001
! FPop(qnan ,{minsub,min,1,max,inf,snan,qnan )
        .word   0,0x00000000,0x00000000,0x7ff80000,0x00000000
        .word   0x00000000,0x00000001,0x7ff80000,0x00000000
        .word   0,0x00000000,0x00000000,0x7ff80000,0x00000000
        .word   0x00100000,0x00000000,0x7ff80000,0x00000000
        .word   0,0x00000000,0x00000000,0x7ff80000,0x00000000
        .word   0x3ff00000,0x00000000,0x7ff80000,0x00000000
        .word   0,0x00000000,0x00000000,0x7ff80000,0x00000000
        .word   0x7fefffff,0xffffffff,0x7ff80000,0x00000000
        .word   0,0x00000000,0x00000000,0x7ff80000,0x00000000
        .word   0x7ff00000,0x00000000,0x7ff80000,0x00000000
        .word   0,0x00000000,0x00000210,0x7ff80000,0x00000000
        .word   0x7ff00000,0x00000001,0x7ff80000,0x00000001
        .word   0,0x00000000,0x00000000,0x7ff80000,0x00000000
        .word   0x7ff80000,0x00000002,0x7ff80000,0x00000002
! Appendix N on with NaN operand(s)
! number + qNaN = qNaN
        .word   0,0,0x3fff0000,1
        .word   0x7fff0000,0x3,0x7fff0000,0x3
! number + sNaN = qsNaN (invalid)
        .word   0,0,0x210,0x3fff0000,1
        .word   0x7ff70000,0x3,0x7fff0000,0x3
! qNaN + number = qNaN
        .word   0,0,0x7ffa1111,0xffffffff
        .word   0x40010000,0x2,0x7ffa1111,0xffffffff
! sNaN + number = qsNaN (invalid)
        .word   0,0,0x210,0x7ff21111,0xffffffff
        .word   0x40010000,0x2,0x7ffa1111,0xffffffff
! qNaN1 + qNaN2 = qNaN2
        .word   0,0,0x7ff9abcd,0xffffffff
        .word   0x7fff0000,0x1,0x7fff0000,0x1
! qNaN1 + sNaN2 = qsNaN2 (invalid)
        .word   0,0,0x210,0x7ff9abcd,0xffffffff
        .word   0x7ff70000,0x1,0x7fff0000,0x1
! sNaN1 + qNaN2 = qsNaN1
        .word   0,0,0x210,0x7ff1abcd,0xffffffff
        .word   0x7fff0000,0x1,0x7ff9abcd,0xffffffff
! sNaN1 + sNaN2 = qsNaN2
        .word   0,0,0x210,0x7ff1abcd,0xffffffff
        .word   0x7ff70000,0x1,0x7fff0000,0x1
        .word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	.word   0x00000000,0x00000000,0x00000000,0x00000000
	
.align 256

fsr_tem_en:
	.word		0x0f800000	! TEM - all enabled - rd 0
	.word		0x4f800000	! TEM - all enabled - rd 1
	.word		0x8f800000	! TEM - all enabled - rd 2
	.word		0xcf800000	! TEM - all enabled - rd 3
        .word           0x00000000      ! TEM - walk through all values
        .word           0x0f800000
	.word           0x01000000
        .word           0x01800000
	.word           0x02000000
        .word           0x02800000
        .word           0x03000000
	.word           0x03800000
	.word           0x04000000
	.word           0x04800000
	.word           0x05000000
	.word           0x05800000
	.word           0x06000000
	.word           0x06800000
	.word           0x07000000
	.word           0x07800000
	.word           0x08000000
	.word           0x08800000
	.word           0x09000000
	.word           0x09800000
	.word           0x0a000000
	.word           0x0a800000
	.word           0x0b000000
	.word           0x0b800000
	.word           0x0c000000
	.word           0x0c800000
	.word           0x0d000000
	.word           0x0d800000
	.word           0x0e000000
	.word           0x0e800000
	.word           0x0f000000
	.word           0x0f800000
	.word           0x01800000
	.word           0x02800000
	.word           0x03800000
	.word           0x04800000
	
	
	
	
fsr_tem_dis:
	.word		0x00000000	! TEM - all disabled
	.word		0x40000000	! TEM - all disabled
	.word		0x80000000	! TEM - all disabled
	.word		0xc0000000	! TEM - all disabled

/*******************************************************
 * My own trap handlers
 *******************************************************/

SECTION .USER_TRAP_FOR_SUP TEXT_VA=0x20008000, DATA_VA=0x20018000
attr_text {
        Name = .USER_TRAP_FOR_SUP,
        RA=0x20008000,
        PA=ra2pa(0x20008000,0),
        part_0_i_ctx_zero_ps0_tsb,
        TTE_G=0, TTE_Context=0, TTE_V=1, TTE_Size=0x0, TTE_NFO=0,
        TTE_IE=0, TTE_Soft2=0, TTE_Diag=0, TTE_Soft=0,
        TTE_L=0, TTE_CP=1, TTE_CV=0, TTE_E=0, TTE_P=1, TTE_W=0
        }
attr_data {
        Name = .USER_TRAP_FOR_SUP,
        RA=0x20018000,
        PA=ra2pa(0x20018000,0),
        part_0_d_ctx_zero_ps0_tsb,
        TTE_G=0, TTE_Context=0, TTE_V=1, TTE_Size=0x0, TTE_NFO=0,
        TTE_IE=0, TTE_Soft2=0, TTE_Diag=0, TTE_Soft=0,
        TTE_L=0, TTE_CP=1, TTE_CV=0, TTE_E=0, TTE_P=1, TTE_W=1
        }

.global	T0_Fp_exception_ieee_754
.global	T0_Fp_exception_other
T0_Fp_exception_ieee_754:	
	rdpr	%tpc, %i0
	rdpr	%tnpc, %i1
	rdpr	%tstate, %i1
	rdpr	%tt, %i1
	setx	scratch, %l0, %l5	! scratch
	stx	%fsr, [%l5+0x0]
	ldx	[%l5+0x0], %fsr		! Need to test the sync operation
	done
	nop

T0_Fp_exception_other:	
	rdpr	%tpc, %i0
	rdpr	%tnpc, %i1
	rdpr	%tstate, %i1
	rdpr	%tt, %i1
	setx	scratch, %l0, %l5	! scratch
	stx	%fsr, [%l5+0x0]
	ldx	[%l5+0x0], %fsr		! Need to test the sync operation
	done
	nop

.data
.align 128

scratch:
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
