# Contributing

Thank you for considering contributing to FPnew!
We very much appreciate contributions such as submitting bug reports and feature requests, writing code which can be included in the project or improvements to the documentation.

When contributing to this repository, please first discuss the change you wish to make via issue, email, or any other method with the owners of this repository before making a change.

Please, don't use the issue tracker for support questions. Instead, consider contacting the maintainers or consulting the [PULP forums](https://pulp-platform.org/community/index.php).


## Repository Structure

This repository loosely follows the [GitFlow Branching Model](https://nvie.com/posts/a-successful-git-branching-model/).

Some points about the workflow:
- `master` branch will be used for versioned releases of the project
- `develop` branch is the base for all development going on
- New features / bugfixes shall create a *feature branch* off `develop` and merge back into it when the feature / fix is complete.
- GitHub pull requests should be used to contribute your work by opening a PR against `develop`.
- Commits should reflect some meaningful step of work and will likely be squashed and rebased before merging if it's for a single feature only.

## :wip: Under Construction

This document is incomplete. We're working on it...
