/* Copyright 2018 ETH Zurich and University of Bologna.
 * Copyright and related rights are licensed under the Solderpad Hardware
 * License, Version 0.51 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://solderpad.org/licenses/SHL-0.51. Unless required by applicable law
 * or agreed to in writing, software, hardware and materials distributed under
 * this License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * File: $filename.v
 *
 * Description: Auto-generated bootrom
 */

// Auto-generated code
module bootrom (
   input  logic         clk_i,
   input  logic         req_i,
   input  logic [63:0]  addr_i,
   output logic [63:0]  rdata_o
);
    localparam int RomSize = 866;

    const logic [RomSize-1:0][63:0] mem = {
        64'h00000000_00000000,
        64'h0a0d2165_6e6f6420,
        64'h00000000_00206567,
        64'h616d6920_746f6f62,
        64'h20676e69_79706f63,
        64'h00000000_00000009,
        64'h3a656d61_6e090a0d,
        64'h00093a73_65747562,
        64'h69727474_61090a0d,
        64'h00000009_3a61626c,
        64'h20747361_6c090a0d,
        64'h0000093a_61626c20,
        64'h74737269_66090a0d,
        64'h00000000_00000000,
        64'h09202020_20203a64,
        64'h69756720_6e6f6974,
        64'h69747261_70090a0d,
        64'h00000000_00000000,
        64'h093a6469_75672065,
        64'h70797420_6e6f6974,
        64'h69747261_70090a0d,
        64'h00000000_20797274,
        64'h6e65206e_6f697469,
        64'h74726170_20747067,
        64'h00000009_20203a73,
        64'h65697274_6e65206e,
        64'h6f697469_74726170,
        64'h20657a69_73090a0d,
        64'h00000009_3a736569,
        64'h72746e65_206e6f69,
        64'h74697472_61702072,
        64'h65626d75_6e090a0d,
        64'h00000009_2020203a,
        64'h61626c20_73656972,
        64'h746e6520_6e6f6974,
        64'h69747261_70090a0d,
        64'h00093a61_646c2070,
        64'h756b6361_62090a0d,
        64'h00000000_00000000,
        64'h093a6162_6c20746e,
        64'h65727275_63090a0d,
        64'h00000009_3a646576,
        64'h72657365_72090a0d,
        64'h00093a72_65646165,
        64'h685f6372_63090a0d,
        64'h00000000_00000909,
        64'h3a657a69_73090a0d,
        64'h00000009_3a6e6f69,
        64'h73697665_72090a0d,
        64'h0000093a_65727574,
        64'h616e6769_73090a0d,
        64'h00000000_003a7265,
        64'h64616568_20656c62,
        64'h6174206e_6f697469,
        64'h74726170_20747067,
        64'h0000203a_65756c61,
        64'h76206e72_75746572,
        64'h2079706f_63206473,
        64'h00000000_0000000a,
        64'h0d216465_6c696166,
        64'h20647261_63204453,
        64'h00000000_0000000a,
        64'h0d216465_7a696c61,
        64'h6974696e_69206473,
        64'h00000000_0a0d676e,
        64'h69746978_65202e2e,
        64'h2e647320_657a696c,
        64'h61697469_6e692074,
        64'h6f6e2064_6c756f63,
        64'h00000000_0000002e,
        64'h00000000_0000000a,
        64'h0d6b636f_6c622044,
        64'h53206461_65722074,
        64'h6f6e2064_6c756f63,
        64'h0000000a_0d202e2e,
        64'h2e445320_676e697a,
        64'h696c6169_74696e69,
        64'h00000031_34646d63,
        64'h00000035_35646d63,
        64'h00000000_30646d63,
        64'h00000020_3a206573,
        64'h6e6f7073_65720920,
        64'h00000000_0020646e,
        64'h616d6d6f_63204453,
        64'h00000000_203f3f79,
        64'h74706d65_20746f6e,
        64'h206f6669_66207872,
        64'h00000000_00000a0d,
        64'h2164657a_696c6169,
        64'h74696e69_20495053,
        64'h00000000_00007830,
        64'h203a7375_74617473,
        64'h00000000_00000a0d,
        64'h49505320_74696e69,
        64'h00000a0d_21646c72,
        64'h6f57206f_6c6c6548,
        64'h00322d74_6c756166,
        64'h65642d69_72742c78,
        64'h6e6c7800_746c7561,
        64'h6665642d_6972742c,
        64'h786e6c78_006c6175,
        64'h642d7369_2c786e6c,
        64'h7800746e_65736572,
        64'h702d7470_75727265,
        64'h746e692c_786e6c78,
        64'h00687464_69772d32,
        64'h6f697067_2c786e6c,
        64'h78006874_6469772d,
        64'h6f697067_2c786e6c,
        64'h7800322d_746c7561,
        64'h6665642d_74756f64,
        64'h2c786e6c_7800746c,
        64'h75616665_642d7475,
        64'h6f642c78_6e6c7800,
        64'h322d7374_75706e69,
        64'h2d6c6c61_2c786e6c,
        64'h78007374_75706e69,
        64'h2d6c6c61_2c786e6c,
        64'h78007265_6c6c6f72,
        64'h746e6f63_2d6f6970,
        64'h6700736c_6c65632d,
        64'h6f697067_23007373,
        64'h65726464_612d6361,
        64'h6d2d6c61_636f6c00,
        64'h70772d65_6c626173,
        64'h69640073_65676e61,
        64'h722d6567_61746c6f,
        64'h76007963_6e657571,
        64'h6572662d_78616d2d,
        64'h69707300_6f697461,
        64'h722d6b63_732c786e,
        64'h6c780073_7469622d,
        64'h72656673_6e617274,
        64'h2d6d756e_2c786e6c,
        64'h78007374_69622d73,
        64'h732d6d75_6e2c786e,
        64'h6c780074_73697865,
        64'h2d6f6669_662c786e,
        64'h6c780079_6c696d61,
        64'h662c786e_6c780068,
        64'h74646977_2d6f692d,
        64'h67657200_74666968,
        64'h732d6765_72007374,
        64'h70757272_65746e69,
        64'h00746e65_7261702d,
        64'h74707572_7265746e,
        64'h69006465_6570732d,
        64'h746e6572_72756300,
        64'h7665646e_2c766373,
        64'h69720079_7469726f,
        64'h6972702d_78616d2c,
        64'h76637369_72007365,
        64'h6d616e2d_67657200,
        64'h6465646e_65747865,
        64'h2d737470_75727265,
        64'h746e6900_7365676e,
        64'h61720064_65646e65,
        64'h70737573_2d657461,
        64'h74732d6e_69617465,
        64'h72007265_67676972,
        64'h742d746c_75616665,
        64'h642c7875_6e696c00,
        64'h736f6970_6700656c,
        64'h646e6168_702c7875,
        64'h6e696c00_72656c6c,
        64'h6f72746e_6f632d74,
        64'h70757272_65746e69,
        64'h00736c6c_65632d74,
        64'h70757272_65746e69,
        64'h23007469_6c70732d,
        64'h626c7400_65707974,
        64'h2d756d6d_00617369,
        64'h2c766373_69720073,
        64'h75746174_73006765,
        64'h72006570_79745f65,
        64'h63697665_64007963,
        64'h6e657571_6572662d,
        64'h6b636f6c_63007963,
        64'h6e657571_6572662d,
        64'h65736162_656d6974,
        64'h00687461_702d7475,
        64'h6f647473_006c6564,
        64'h6f6d0065_6c626974,
        64'h61706d6f_6300736c,
        64'h6c65632d_657a6973,
        64'h2300736c_6c65632d,
        64'h73736572_64646123,
        64'h09000000_02000000,
        64'h02000000_02000000,
        64'h01000000_bb000000,
        64'h04000000_03000000,
        64'h01000000_b5000000,
        64'h04000000_03000000,
        64'hffffffff_c5020000,
        64'h04000000_03000000,
        64'hffffffff_b4020000,
        64'h04000000_03000000,
        64'h01000000_a7020000,
        64'h04000000_03000000,
        64'h00000000_90020000,
        64'h04000000_03000000,
        64'h08000000_7f020000,
        64'h04000000_03000000,
        64'h08000000_6f020000,
        64'h04000000_03000000,
        64'h00000000_5b020000,
        64'h04000000_03000000,
        64'h00000000_49020000,
        64'h04000000_03000000,
        64'h00000000_37020000,
        64'h04000000_03000000,
        64'h00000000_27020000,
        64'h04000000_03000000,
        64'h00000100_00000000,
        64'h00000040_00000000,
        64'h67000000_10000000,
        64'h03000000_17020000,
        64'h00000000_03000000,
        64'h00000000_612e3030,
        64'h2e312d6f_6970672d,
        64'h7370782c_786e6c78,
        64'h1b000000_15000000,
        64'h03000000_02000000,
        64'h0b020000_04000000,
        64'h03000000_00000030,
        64'h30303030_30303440,
        64'h6f697067_01000000,
        64'h02000000_00800000,
        64'h00000000_00000030,
        64'h00000000_67000000,
        64'h10000000_03000000,
        64'h00007fe3_023e1800,
        64'hf9010000_06000000,
        64'h03000000_00000000,
        64'h03000000_58010000,
        64'h08000000_03000000,
        64'h03000000_47010000,
        64'h04000000_03000000,
        64'h006b726f_7774656e,
        64'h5b000000_08000000,
        64'h03000000_00687465,
        64'h2d637369_72776f6c,
        64'h1b000000_0c000000,
        64'h03000000_00000000,
        64'h30303030_30303033,
        64'h40687465_2d637369,
        64'h72776f6c_01000000,
        64'h02000000_02000000,
        64'hee010000_00000000,
        64'h03000000_e40c0000,
        64'he40c0000_df010000,
        64'h08000000_03000000,
        64'h20bcbe00_cd010000,
        64'h04000000_03000000,
        64'h00000000_67000000,
        64'h04000000_03000000,
        64'h00000000_746f6c73,
        64'h2d697073_2d636d6d,
        64'h1b000000_0d000000,
        64'h03000000_00000030,
        64'h40636d6d_01000000,
        64'h04000000_be010000,
        64'h04000000_03000000,
        64'h08000000_a7010000,
        64'h04000000_03000000,
        64'h01000000_96010000,
        64'h04000000_03000000,
        64'h01000000_86010000,
        64'h04000000_03000000,
        64'h00377865_746e696b,
        64'h7a010000_08000000,
        64'h03000000_00100000,
        64'h00000000_00000020,
        64'h00000000_67000000,
        64'h10000000_03000000,
        64'h02000000_02000000,
        64'h58010000_08000000,
        64'h03000000_03000000,
        64'h47010000_04000000,
        64'h03000000_00000000,
        64'h0f000000_04000000,
        64'h03000000_01000000,
        64'h00000000_04000000,
        64'h03000000_00612e30,
        64'h302e322d_6970732d,
        64'h7370782c_786e6c78,
        64'h00622e30_302e322d,
        64'h6970732d_7370782c,
        64'h786e6c78_1b000000,
        64'h28000000_03000000,
        64'h00000000_30303030,
        64'h30303032_40697073,
        64'h2d737078_01000000,
        64'h02000000_04000000,
        64'h6d010000_04000000,
        64'h03000000_02000000,
        64'h63010000_04000000,
        64'h03000000_01000000,
        64'h58010000_04000000,
        64'h03000000_03000000,
        64'h47010000_04000000,
        64'h03000000_00c20100,
        64'h39010000_04000000,
        64'h03000000_80f0fa02,
        64'h4b000000_04000000,
        64'h03000000_00100000,
        64'h00000000_00000010,
        64'h00000000_67000000,
        64'h10000000_03000000,
        64'h00303537_3631736e,
        64'h1b000000_08000000,
        64'h03000000_00000030,
        64'h30303030_30303140,
        64'h74726175_01000000,
        64'h02000000_006c6f72,
        64'h746e6f63_11010000,
        64'h08000000_03000000,
        64'h00100000_00000000,
        64'h00000000_00000000,
        64'h67000000_10000000,
        64'h03000000_ffff0000,
        64'h02000000_fd000000,
        64'h08000000_03000000,
        64'h00333130_2d677562,
        64'h65642c76_63736972,
        64'h1b000000_10000000,
        64'h03000000_00003040,
        64'h72656c6c_6f72746e,
        64'h6f632d67_75626564,
        64'h01000000_02000000,
        64'h03000000_bb000000,
        64'h04000000_03000000,
        64'h03000000_b5000000,
        64'h04000000_03000000,
        64'h03000000_2e010000,
        64'h04000000_03000000,
        64'h07000000_1b010000,
        64'h04000000_03000000,
        64'h00000004_00000000,
        64'h0000000c_00000000,
        64'h67000000_10000000,
        64'h03000000_09000000,
        64'h02000000_0b000000,
        64'h02000000_fd000000,
        64'h10000000_03000000,
        64'ha0000000_00000000,
        64'h03000000_00306369,
        64'h6c702c76_63736972,
        64'h1b000000_0c000000,
        64'h03000000_01000000,
        64'h8f000000_04000000,
        64'h03000000_00000000,
        64'h00000000_04000000,
        64'h03000000_00000000,
        64'h30303030_30306340,
        64'h72656c6c_6f72746e,
        64'h6f632d74_70757272,
        64'h65746e69_01000000,
        64'h02000000_006c6f72,
        64'h746e6f63_11010000,
        64'h08000000_03000000,
        64'h00000c00_00000000,
        64'h00000002_00000000,
        64'h67000000_10000000,
        64'h03000000_07000000,
        64'h02000000_03000000,
        64'h02000000_fd000000,
        64'h10000000_03000000,
        64'h00000000_30746e69,
        64'h6c632c76_63736972,
        64'h1b000000_0d000000,
        64'h03000000_00000030,
        64'h30303030_30324074,
        64'h6e696c63_01000000,
        64'hf6000000_00000000,
        64'h03000000_00007375,
        64'h622d656c_706d6973,
        64'h00636f73_2d657261,
        64'h622d656e_61697261,
        64'h2c687465_1b000000,
        64'h1f000000_03000000,
        64'h02000000_0f000000,
        64'h04000000_03000000,
        64'h02000000_00000000,
        64'h04000000_03000000,
        64'h00636f73_01000000,
        64'h02000000_02000000,
        64'hdf000000_00000000,
        64'h03000000_00000074,
        64'h61656274_72616568,
        64'hc9000000_0a000000,
        64'h03000000_00000000,
        64'h01000000_01000000,
        64'hc3000000_0c000000,
        64'h03000000_00000064,
        64'h656c2d74_61656274,
        64'h72616568_01000000,
        64'h00000073_64656c2d,
        64'h6f697067_1b000000,
        64'h0a000000_03000000,
        64'h00000000_7364656c,
        64'h01000000_02000000,
        64'h00000040_00000000,
        64'h00000080_00000000,
        64'h67000000_10000000,
        64'h03000000_00007972,
        64'h6f6d656d_5b000000,
        64'h07000000_03000000,
        64'h00303030_30303030,
        64'h38407972_6f6d656d,
        64'h01000000_02000000,
        64'h02000000_02000000,
        64'h02000000_bb000000,
        64'h04000000_03000000,
        64'h02000000_b5000000,
        64'h04000000_03000000,
        64'h00006374_6e692d75,
        64'h70632c76_63736972,
        64'h1b000000_0f000000,
        64'h03000000_a0000000,
        64'h00000000_03000000,
        64'h01000000_8f000000,
        64'h04000000_03000000,
        64'h00000000_72656c6c,
        64'h6f72746e_6f632d74,
        64'h70757272_65746e69,
        64'h01000000_85000000,
        64'h00000000_03000000,
        64'h00003933_76732c76,
        64'h63736972_7c000000,
        64'h0b000000_03000000,
        64'h00006364_66616d69,
        64'h34367672_72000000,
        64'h0b000000_03000000,
        64'h00000076_63736972,
        64'h00656e61_69726120,
        64'h2c687465_1b000000,
        64'h12000000_03000000,
        64'h00000000_79616b6f,
        64'h6b000000_05000000,
        64'h03000000_00000000,
        64'h67000000_04000000,
        64'h03000000_00757063,
        64'h5b000000_04000000,
        64'h03000000_80f0fa02,
        64'h4b000000_04000000,
        64'h03000000_00000030,
        64'h40757063_01000000,
        64'hc0e1e400_38000000,
        64'h04000000_03000000,
        64'h00000000_0f000000,
        64'h04000000_03000000,
        64'h01000000_00000000,
        64'h04000000_03000000,
        64'h00000000_73757063,
        64'h01000000_02000000,
        64'h00000030_30323531,
        64'h313a3030_30303030,
        64'h30314074_7261752f,
        64'h636f732f_2c000000,
        64'h1a000000_03000000,
        64'h00006e65_736f6863,
        64'h01000000_00657261,
        64'h622d656e_61697261,
        64'h2c687465_26000000,
        64'h10000000_03000000,
        64'h00766564_2d657261,
        64'h622d656e_61697261,
        64'h2c687465_1b000000,
        64'h14000000_03000000,
        64'h02000000_0f000000,
        64'h04000000_03000000,
        64'h02000000_00000000,
        64'h04000000_03000000,
        64'h00000000_01000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00090000_d8020000,
        64'h00000000_10000000,
        64'h11000000_28000000,
        64'h38090000_38000000,
        64'h100c0000_edfe0dd0,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h46454443_42413938,
        64'h37363534_33323130,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_a0018402,
        64'h15058593_00000597,
        64'h01f41413_0010041b,
        64'he911d23f_f0ef057e,
        64'h65a14505_edcff0ef,
        64'hd8050513_00001517,
        64'hea4ff0ef_e4060805,
        64'h05132005_85931141,
        64'h02faf537_65f1bbb5,
        64'hf00ff0ef_09450513,
        64'h00001517_b3f5dee5,
        64'h05130000_1517f98f,
        64'hf0ef8526_f1cff0ef,
        64'hef050513_00001517,
        64'hf28ff0ef_ee450513,
        64'h00001517_c50d84aa,
        64'hc33ff0ef_8552865a,
        64'h020aa583_f44ff0ef,
        64'h0c050513_00001517,
        64'hf57993e3_08048493,
        64'hf58ff0ef_2985e3e5,
        64'h05130000_1517ff2c,
        64'h1be382ff_f0ef0905,
        64'h00094503_f74ff0ef,
        64'h0e050513_00001517,
        64'h803ff0ef_7088f86f,
        64'hf0ef0e25_05130000,
        64'h1517815f_f0ef6c88,
        64'hf98ff0ef_0e450513,
        64'h00001517_827ff0ef,
        64'h07048c13_02848913,
        64'h6888fb2f_f0ef0ee5,
        64'h05130000_1517ff2c,
        64'h1be3887f_f0ef0905,
        64'h00094503_01090c13,
        64'hfd0ff0ef_0ec50513,
        64'h00001517_fe991be3,
        64'h8a5ff0ef_09050009,
        64'h4503ff04_8913feef,
        64'hf0ef0ea5_05130000,
        64'h15178bff_f0ef0ff9,
        64'hf513803f_f0ef0e65,
        64'h05130000_1517b5fd,
        64'hef050513_00001517,
        64'h89bff0ef_854e81ff,
        64'hf0efff25_05130000,
        64'h151782bf_f0effe65,
        64'h05130000_1517c50d,
        64'h080489aa_8a8ad39f,
        64'hf0ef850a_46057101,
        64'h04892583_84dff0ef,
        64'hf3050513_00001517,
        64'h89bff0ef_455685ff,
        64'hf0ef1225_05130000,
        64'h15178adf_f0ef4546,
        64'h871ff0ef_11450513,
        64'h00001517_8ffff0ef,
        64'h6526883f_f0ef1065,
        64'h05130000_1517911f,
        64'hf0ef7502_895ff0ef,
        64'h10850513_00001517,
        64'h923ff0ef_65628a7f,
        64'hf0ef1025_05130000,
        64'h15178f5f_f0ef4552,
        64'h8b9ff0ef_10450513,
        64'h00001517_907ff0ef,
        64'h45428cbf_f0ef1065,
        64'h05130000_1517919f,
        64'hf0ef4532_8ddff0ef,
        64'h10850513_00001517,
        64'h92bff0ef_45228eff,
        64'hf0ef10a5_05130000,
        64'h151797df_f0ef4b91,
        64'h6502903f_f0ef10e5,
        64'h05130000_151790ff,
        64'hf0ef0fa5_05130000,
        64'h1517bf61_54f991ff,
        64'hf0ef0025_05130000,
        64'h15179adf_f0ef8526,
        64'h931ff0ef_10450513,
        64'h00001517_93dff0ef,
        64'h0f850513_00001517,
        64'hc90584aa_890ae49f,
        64'hf0ef850a_45854605,
        64'h710195bf_f0ef0fe5,
        64'h05130000_15178082,
        64'h61616c02_6ba26b42,
        64'h6ae27a02_79a27942,
        64'h74e26406_852660a6,
        64'hfb040113_54fd987f,
        64'hf0ef1025_05130000,
        64'h1517c51d_df3ff0ef,
        64'h8b2e8a2a_0880e062,
        64'he45eec56_f44ef84a,
        64'hfc26e486_e85af052,
        64'he0a2715d_b7655479,
        64'h80826169_6baa6b4a,
        64'h6aea7a0a_79aa794a,
        64'h74ea640e_60ae8522,
        64'h547d9d3f_f0ef1265,
        64'h05130000_1517c59f,
        64'hf0efc5df_f0efc61f,
        64'hf0efc65f_f0efc69f,
        64'hf0efc6df_f0efc71f,
        64'hf0efc75f_f0efa805,
        64'hc7bff0ef_c87ff0ef,
        64'h45314581_46054401,
        64'hf93046e3_19fda17f,
        64'hf0ef18a5_05130000,
        64'h1517e799_0359e7b3,
        64'h07241a63_29019041,
        64'h14428c49_cafff0ef,
        64'h90410305_141384a2,
        64'h0085151b_cbfff0ef,
        64'hfd641ae3_04040413,
        64'hff7497e3_892af13f,
        64'hf0ef0485_854a0007,
        64'hc5830094_07b30400,
        64'h0b934481_c67ff0ef,
        64'h850a0400_05938622,
        64'h49018426_20048b13,
        64'hff451ee3_cffff0ef,
        64'h3e800a93_0fe00a13,
        64'he951d15f_f0ef4549,
        64'h85a20ff6_76130016,
        64'h66130015_161bf49f,
        64'hf0ef0ff4_7593f51f,
        64'hf0ef0ff5_f5930084,
        64'h559bf5df_f0ef0ff5,
        64'hf5930104_559bf69f,
        64'hf0ef4501_0ff5f593,
        64'h0184559b_fee79be3,
        64'h078500c6_802300f1,
        64'h06b30800_0713567d,
        64'h47810209_d993842e,
        64'h84aae55e_e95aed56,
        64'hf152f94a_e586fd26,
        64'he1a20206_1993f54e,
        64'h71558082_91411542,
        64'h8d3d8ff9_0057979b,
        64'h17016709_0107d79b,
        64'h0105179b_4105551b,
        64'h0105151b_8d2d00c5,
        64'h95138da9_893d0045,
        64'hd51b8da9_91411542,
        64'h8d5d0522_0085579b,
        64'h808207f5_75138d2d,
        64'h00451593_8d2d8d3d,
        64'h0045d51b_0075d79b,
        64'h8de98082_0141853e,
        64'h640260a2_4781c111,
        64'h57f5f89f_f0efc511,
        64'h57f9efbf_f0efc911,
        64'h57fdeb7f_f0effc6d,
        64'he03ff0ef_347d4429,
        64'hb91ff0ef_2cc50513,
        64'h00001517_c89ff0ef,
        64'he022e406_11418082,
        64'h61050015_351364a2,
        64'h644260e2_0004051b,
        64'hfc940ce3_e37ff0ef,
        64'heb3ff0ef_2f450513,
        64'h00001517_85aa842a,
        64'he53ff0ef_02900513,
        64'h400005b7_07700613,
        64'hfbdff0ef_4485e822,
        64'hec06e426_11018082,
        64'h01410015_3513157d,
        64'h640260a2_0004051b,
        64'hef3ff0ef_32e50513,
        64'h85a20000_1517e89f,
        64'hf0ef842a_e97ff0ef,
        64'he022e406_03700513,
        64'h45810650_06131141,
        64'h80826105_690264a2,
        64'h644260e2_00153513,
        64'hf5650513_0004051b,
        64'h01249863_88bd00f9,
        64'h1b634501_4785ec9f,
        64'hf0efecdf_f0ef842a,
        64'hed3ff0ef_84aaed9f,
        64'hf0efeddf_f0efee1f,
        64'hf0ef892a_eefff0ef,
        64'he04ae426_e822ec06,
        64'h45211aa0_05930870,
        64'h06131101_bfcd4501,
        64'h80826105_690264a2,
        64'h644260e2_4505f89f,
        64'hf0ef4585_3bc50513,
        64'h00001517_fe9915e3,
        64'hc00df25f_f0ef892a,
        64'h347df35f_f0ef4501,
        64'h45810950_06134485,
        64'h71040413_e04aec06,
        64'he4266409_e8221101,
        64'hcd1ff06f_61053b65,
        64'h05130000_151760e2,
        64'h6442da7f_f0ef852e,
        64'h65a2cebf_f0ef3fe5,
        64'h05130000_1517cf7f,
        64'hf0ef8522_cfdff0ef,
        64'he42eec06_40450513,
        64'h00001517_842ae822,
        64'h11018082_614564e2,
        64'h740270a2_f47d147d,
        64'h0007d463_4187d79b,
        64'h0185179b_fa7ff0ef,
        64'heb5ff0ef_85320640,
        64'h04136622_ec1ff0ef,
        64'h0ff47513_ec9ff0ef,
        64'h0ff57513_0084551b,
        64'hed5ff0ef_0ff57513,
        64'h0104551b_ee1ff0ef,
        64'h0ff57513_0184551b,
        64'heedff0ef_0404e513,
        64'hfebff0ef_84aa842e,
        64'hec26f022_e432f406,
        64'h7179f07f_f06f0ff0,
        64'h05138082_557db7e9,
        64'h00d70023_078500f6,
        64'h073306c8_2683ff79,
        64'h8b055178_bf4dd6b8,
        64'h07850007_c7038082,
        64'h4501d3b8_4719dbb8,
        64'h577d2000_07b700b6,
        64'hef630007_869b2000,
        64'h08372000_0537fff5,
        64'h8b85537c_20000737,
        64'hd3b82000_07b71060,
        64'h0713fff5_37fd0001,
        64'h03200793_04b76163,
        64'h40a7873b_87aa2000,
        64'h06b7dbb8_57792000,
        64'h07b706b7_ec631000,
        64'h07938082_610564a2,
        64'hd3b84719_dbb86442,
        64'h60e20ff4_7513577d,
        64'h200007b7_e25ff0ef,
        64'h50850513_00001517,
        64'heb3ff0ef_91011502,
        64'h4088e3bf_f0ef5265,
        64'h05130000_1517e395,
        64'h8b852401_53fc57e0,
        64'hff658b05_06478493,
        64'h53f8d3b8_10600713,
        64'h200007b7_fff537fd,
        64'h00010640_0793d7a8,
        64'hdbb85779_e426e822,
        64'hec062000_07b71101,
        64'he81ff06f_61055565,
        64'h05130000_151764a2,
        64'h60e26442_d03c4799,
        64'he99ff0ef_57c50513,
        64'h00001517_f27ff0ef,
        64'h91010204_95132481,
        64'heb1ff0ef_57450513,
        64'h00001517_5064d03c,
        64'h16600793_ec5ff0ef,
        64'h5a850513_00001517,
        64'hf53ff0ef_91010204,
        64'h95132481_eddff0ef,
        64'h5a050513_00001517,
        64'h5064d03c_10400793,
        64'h20000437_fff537fd,
        64'h000147a9_c3b84729,
        64'h200007b7_f05ff0ef,
        64'he426e822_ec065c05,
        64'h05131101_00001517,
        64'h80824108_8082c10c,
        64'h80826105_60e2ecff,
        64'hf0ef0091_4503ed7f,
        64'hf0ef0081_4503f55f,
        64'hf0efec06_002c1101,
        64'h80826145_694264e2,
        64'h740270a2_fe9410e3,
        64'hef9ff0ef_00914503,
        64'hf01ff0ef_34610081,
        64'h4503f81f_f0ef0ff5,
        64'h7513002c_00895533,
        64'h54e10380_0413892a,
        64'hf406e84a_ec26f022,
        64'h71798082_61456942,
        64'h64e27402_70a2fe94,
        64'h10e3f3bf_f0ef0091,
        64'h4503f43f_f0ef3461,
        64'h00814503_fc3ff0ef,
        64'h0ff57513_002c0089,
        64'h553b54e1_4461892a,
        64'hf406e84a_ec26f022,
        64'h71798082_00f58023,
        64'h0007c783_00e580a3,
        64'h97aa8111_00074703,
        64'h973e00f5_771396e7,
        64'h87930000_1797b7f5,
        64'h0405f93f_f0ef8082,
        64'h01416402_60a2e509,
        64'h00044503_842ae406,
        64'he0221141_808200e7,
        64'h88230200_071300e7,
        64'h8423fc70_071300e7,
        64'h8623470d_00a78223,
        64'h0ff57513_00e78023,
        64'h0085551b_0ff57713,
        64'h00e78623_f8000713,
        64'h00078223_100007b7,
        64'h02b5553b_0045959b,
        64'h808200a7_0023dfe5,
        64'h0207f793_01474783,
        64'h10000737_80820205,
        64'h75130147_c5031000,
        64'h07b78082_00054503,
        64'h808200b5_00238082,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00000000_00000000,
        64'h00048067_01f49493,
        64'h0010049b_b8458593,
        64'h00001597_f1402573,
        64'hff24c6e3_4009091b,
        64'h02000937_00448493,
        64'hfe091ee3_0004a903,
        64'h00092023_00990933,
        64'h00291913_f1402973,
        64'h020004b7_fe090ae3,
        64'h00897913_34402973,
        64'h10500073_ff24c6e3,
        64'h4009091b_02000937,
        64'h00448493_0124a023,
        64'h00100913_020004b7,
        64'h25f000ef_01a11113,
        64'h0210011b_03249663,
        64'hf1402973_00000493,
        64'h30491073_00800913
    };

    logic [$clog2(RomSize)-1:0] addr_q;

    always_ff @(posedge clk_i) begin
        if (req_i) begin
            addr_q <= addr_i[$clog2(RomSize)-1+3:3];
        end
    end

    // this prevents spurious Xes from propagating into
    // the speculative fetch stage of the core
    assign rdata_o = (addr_q < RomSize) ? mem[addr_q] : '0;
endmodule
