/////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  - This file is only to help the participants with basic API's to interact with the SoC
//  - You can also, write your own functions / modify the code here, to interact with the 
//    peripherals since all of this is considered as user space code.
//
/////////////////////////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "ariane_api.h"

void main(void)
{
	printf("This code shows the usage of available RSA APIs\n"); 
  /*
    1.The RSA is implemented based on (m^e)^d = m (mod n), where m is message, e is encryption key, d is decryption key, n is modulus. 
    e,d,n are very large positive integer number generated by two 1024-bit prime number.
    2.The standard size of encryption key e is 2048-bit following the minimal recommendation from NIST-SP800-57 part1 revision4, Table 2, page 53.
    We deploy Right-to-Left binary exponentiation to facilitate the operation of RSA in hardware.
    3.The size of input message "msg_in" is 2048-bit to ease the hardware implementation.
    However, we need to make sure the value of msg_in is less than 2^1024 to prevent calculation overflow.
    The RSA module allows use to switch between encryption and decryption mode using the API "rsa_write_msg_in()", where 1 is for encryption and 0 is for decryption.
    4.(Warning!) The default size of e,d,n,msg_in and msg_out is 64-bit because the simulation speed is very low (> 1hr) if you use verilator to simulate the standard version.
    However, if you use modelsim, there is no such performance issue. You can change the default size at the wrapper of RSA.
  */
    uint32_t p_num[64] = {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x0000000d, 
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000011};
    
    uint32_t msg_in[64]= {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000, 
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
                          0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000006};


    uint32_t msg_out[64] = {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
                            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0};

    rsa_write_prime_num(p_num);
    //encrypt first
    rsa_write_msg_in(msg_in, 1);
    //rst_id(13);
    rsa_read_msg_out(msg_out);

    printf("rsa en %08x, %08x\n", msg_out[62], msg_out[63]);

    msg_in[63] = 0x00000029;
    //decrypt
    rsa_write_msg_in(msg_in, 0);
    rsa_read_msg_out(msg_out);

    printf("rsa de %08x, %08x\n", msg_out[62], msg_out[63]);

}

