// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: tlu_asi_access_mt_2_rand_43_s1.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
********************************************************************************
   random seed:	165029898
   Jal tlu_asi_access_mt_2.j:	
********************************************************************************/



#define PCONTEXT	0x10
#define SCONTEXT	0x10

#define MAIN_PAGE_NUCLEUS_ALSO
#define MAIN_PAGE_HV_ALSO

#define ALL_MY_INTR_HANDLERS
#include "my_intr_handlers.s"
#include "my_trap_handlers.s"
#include "tlu_custom_trap_handlers.s"

#include "enable_traps.h"
#include "boot.s"

.text
.global main

main:

	ta 	%icc, T_CHANGE_HPRIV
	mov	0x123, %g1
	wr	%g0, 0x20, %asi
	stxa	%g1, [0x00] %asi
	stxa	%g1, [0x08] %asi
	stxa	%g1, [0x10] %asi
	stxa	%g1, [0x18] %asi
	stxa	%g1, [0x20] %asi
	stxa	%g1, [0x28] %asi
	stxa	%g1, [0x30] %asi
	stxa	%g1, [0x38] %asi
	ta 	%icc, T_CHANGE_NONHPRIV

! Register init code

	setx 0x8381ccb5ca232f65, %g1, %g0
	setx 0xad2f80e9bc1317dc, %g1, %g1
	setx 0xca1b1556a3daeaed, %g1, %g2
	setx 0xb2b864041b2eb3ef, %g1, %g3
	setx 0xae57d24a4f599eea, %g1, %g4
	setx 0x941a8a9ebc76be7d, %g1, %g5
	setx 0x0e360492ca858ab3, %g1, %g6
	setx 0x4c9a3303caa3ab86, %g1, %g7
	setx 0x49101f6f6879e0b9, %g1, %r16
	setx 0x6498ccfc706ac350, %g1, %r17
	setx 0x61373642c9e840dc, %g1, %r18
	setx 0xfe1a34fd00c2d983, %g1, %r19
	setx 0xd186a778c93961fb, %g1, %r20
	setx 0x79619be7d90155c2, %g1, %r21
	setx 0xc3f64399b5654d86, %g1, %r22
	setx 0xcba77442b9d50e11, %g1, %r23
	setx 0x0e91945be8c57a01, %g1, %r24
	setx 0x079dd743505c6eb6, %g1, %r25
	setx 0xd7eaa1a3e48b805e, %g1, %r26
	setx 0x20086bbc1ac3d59d, %g1, %r27
	setx 0xb2dd85a67c677f08, %g1, %r28
	setx 0x1bed706ff9f78651, %g1, %r29
	setx 0x72e5f5127c4b3440, %g1, %r30
	setx 0x2b08d703d1fdf03c, %g1, %r31
	save
	setx 0x28cdc5703fce7e98, %g1, %r16
	setx 0xb6afa300fb524f82, %g1, %r17
	setx 0x26323b76398438f5, %g1, %r18
	setx 0x3cb5f93c80859ec3, %g1, %r19
	setx 0x55f4ab872ac02ee4, %g1, %r20
	setx 0x0ef74402e8aac6ae, %g1, %r21
	setx 0xc64d49774070395f, %g1, %r22
	setx 0x143cf130eabcadc4, %g1, %r23
	setx 0xd1b63a988353c15d, %g1, %r24
	setx 0x71c99d0e3a257a4c, %g1, %r25
	setx 0xf35330aef6dacf80, %g1, %r26
	setx 0xca3de4008664b2b1, %g1, %r27
	setx 0xa5452951a45288fa, %g1, %r28
	setx 0x4ac0abdd33614954, %g1, %r29
	setx 0xc1ff6e05f99ab83a, %g1, %r30
	setx 0xc5119fbf39d57e02, %g1, %r31
	save
	setx 0xd14fe791c224e448, %g1, %r16
	setx 0x7fc47e5dc9fcbc98, %g1, %r17
	setx 0xa499a2c83295b87c, %g1, %r18
	setx 0x33d6665f9108c23e, %g1, %r19
	setx 0xf92d5d6f5ad84d64, %g1, %r20
	setx 0x5bf6328c1f972f62, %g1, %r21
	setx 0x633c8205199ad0e2, %g1, %r22
	setx 0x96b42aa34fe42a2c, %g1, %r23
	setx 0xd9035b6d66dbcd9f, %g1, %r24
	setx 0x995722ceb52abc49, %g1, %r25
	setx 0xee7cb435b77c29c4, %g1, %r26
	setx 0xb59601e917633b32, %g1, %r27
	setx 0xb7539ee3a0311463, %g1, %r28
	setx 0x5830ac2ba191d474, %g1, %r29
	setx 0x7bdd302e6cdc5c57, %g1, %r30
	setx 0x5e15e2e697d5f4fa, %g1, %r31
	restore
	mov	0x28, %r16
	mov	0x8, %r17
	mov	0x40, %r18
	mov	0x20, %r19
	mov	0x7e8, %r20
	mov	0x3d0, %r21
	mov	0x7f8, %r22
	mov	0x3f0, %r23
	mov	0x68, %r24
	mov	0x60, %r25
	mov	0x50, %r26
	mov	0x28, %r27
	mov	0, %r28
	mov	0, %r29
	mov	0, %r30
	mov	0, %r31
	ta	%icc, T_CHANGE_HPRIV
	wr	%g0, 0x4f, %asi
	stxa	%g0, [%g0] 0x42
	mov	0x38, %g1
	stxa	%g0, [%g1] 0x58
	ta	%icc, T_RD_THID
! fork: source strm = 0xffffffff; target strm = 0x2
	cmp	%o1, 1
	setx	fork_lbl_0_1, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x4
	cmp	%o1, 2
	setx	fork_lbl_0_2, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x8
	cmp	%o1, 3
	setx	fork_lbl_0_3, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
	.word 0xe4b4c400  ! 1: STHA_R	stha	%r18, [%r19 + %r0] 0x20
	.word 0xe49d44a0  ! 2: LDDA_R	ldda	[%r21, %r0] 0x25, %r18
	mov	0x58, %r17
	.word 0xe6b70e80  ! 4: STHA_R	stha	%r19, [%r28 + %r0] 0x74
	.word 0xe6a6e000  ! 5: STWA_I	stwa	%r19, [%r27 + 0x0000] %asi
	.word 0xe69ea000  ! 6: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r19
	.word 0x87802074  ! 7: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xea9689e0  ! 8: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r21
	mov	0x8, %r17
	.word 0xe28649e0  ! 10: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r17
	.word 0xe69f0e40  ! 11: LDDA_R	ldda	[%r28, %r0] 0x72, %r19
	mov	0x7c0, %r20
	.word 0x87802020  ! 13: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 14: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x48, %r19
	mov	0x38, %r25
	.word 0xee8609e0  ! 17: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r23
	.word 0xe68dc4a0  ! 18: LDUBA_R	lduba	[%r23, %r0] 0x25, %r19
	.word 0xe6a584a0  ! 19: STWA_R	stwa	%r19, [%r22 + %r0] 0x25
	.word 0xe6d6e000  ! 20: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r19
	.word 0xe6d62000  ! 21: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r19
	.word 0xe6ae2000  ! 22: STBA_I	stba	%r19, [%r24 + 0x0000] %asi
	.word 0xe6f62000  ! 23: STXA_I	stxa	%r19, [%r24 + 0x0000] %asi
	.word 0xeaa7ce80  ! 24: STWA_R	stwa	%r21, [%r31 + %r0] 0x74
	.word 0xeadee000  ! 25: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r21
	.word 0xe0af0e40  ! 26: STBA_R	stba	%r16, [%r28 + %r0] 0x72
	.word 0xe0a6a000  ! 27: STWA_I	stwa	%r16, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 28: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 29: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r19
	.word 0xecccc400  ! 31: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r22
	.word 0xecf46000  ! 32: STXA_I	stxa	%r22, [%r17 + 0x0000] %asi
	mov	0x18, %r16
	mov	0x7f8, %r22
	.word 0xecbc2000  ! 35: STDA_I	stda	%r22, [%r16 + 0x0000] %asi
	.word 0xee940400  ! 36: LDUHA_R	lduha	[%r16, %r0] 0x20, %r23
	.word 0xeeb46000  ! 37: STHA_I	stha	%r23, [%r17 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xee8ce000  ! 39: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r23
	.word 0x87802074  ! 40: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeef7e000  ! 41: STXA_I	stxa	%r23, [%r31 + 0x0000] %asi
	.word 0xeef72000  ! 42: STXA_I	stxa	%r23, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 43: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6848400  ! 44: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r19
	.word 0x8780204f  ! 45: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8b40400  ! 46: STHA_R	stha	%r20, [%r16 + %r0] 0x20
	.word 0xe8966000  ! 47: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r20
	mov	0x7d0, %r21
	.word 0xe6b48400  ! 49: STHA_R	stha	%r19, [%r18 + %r0] 0x20
	.word 0xe6bea000  ! 50: STDA_I	stda	%r19, [%r26 + 0x0000] %asi
	mov	0x58, %r27
	.word 0xe6ce2000  ! 52: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r19
	mov	0x7c8, %r23
	.word 0xe08689e0  ! 54: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r16
	.word 0xe0bea000  ! 55: STDA_I	stda	%r16, [%r26 + 0x0000] %asi
	.word 0xe0d6e000  ! 56: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r16
	.word 0xe0bee000  ! 57: STDA_I	stda	%r16, [%r27 + 0x0000] %asi
	.word 0xe0dee000  ! 58: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r16
	.word 0x87802072  ! 59: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6afce40  ! 60: STBA_R	stba	%r19, [%r31 + %r0] 0x72
	mov	0x3e0, %r23
	.word 0xe6f76000  ! 62: STXA_I	stxa	%r19, [%r29 + 0x0000] %asi
	.word 0xecdc0400  ! 63: LDXA_R	ldxa	[%r16, %r0] 0x20, %r22
	.word 0xecb7e000  ! 64: STHA_I	stha	%r22, [%r31 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xecbf2000  ! 66: STDA_I	stda	%r22, [%r28 + 0x0000] %asi
	.word 0xeac584a0  ! 67: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r21
	mov	0x40, %r27
	.word 0xeab76000  ! 69: STHA_I	stha	%r21, [%r29 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xeaa7a000  ! 71: STWA_I	stwa	%r21, [%r30 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xe6bf8e80  ! 73: STDA_R	stda	%r19, [%r30 + %r0] 0x74
	.word 0x8780204f  ! 74: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r18
	.word 0xe6866000  ! 76: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r19
	mov	0x38, %r17
	.word 0xe6c62000  ! 78: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r19
	mov	0x60, %r18
	.word 0xe2f4c400  ! 80: STXA_R	stxa	%r17, [%r19 + %r0] 0x20
	mov	0x3f0, %r20
	.word 0xe2f6e000  ! 82: STXA_I	stxa	%r17, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 83: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe284a000  ! 84: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r17
	mov	0x58, %r25
	mov	0x48, %r16
	mov	0x8, %r26
	.word 0xe4bf8e40  ! 88: STDA_R	stda	%r18, [%r30 + %r0] 0x72
	.word 0xeebc4400  ! 89: STDA_R	stda	%r23, [%r17 + %r0] 0x20
	mov	0x3c0, %r22
	.word 0x87802020  ! 91: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeeb4a000  ! 92: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	.word 0xe2cf0e80  ! 93: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r17
	mov	0x3d0, %r20
	.word 0xe2dc4400  ! 95: LDXA_R	ldxa	[%r17, %r0] 0x20, %r17
	.word 0xe88649e0  ! 96: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r20
	.word 0xe8f70e80  ! 97: STXA_R	stxa	%r20, [%r28 + %r0] 0x74
	.word 0xe8cc2000  ! 98: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r20
	.word 0xe4ad84a0  ! 99: STBA_R	stba	%r18, [%r22 + %r0] 0x25
	.word 0xe4dce000  ! 100: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r18
	.word 0xe0d70e80  ! 101: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r16
	mov	0x78, %r25
	.word 0xea8f8e40  ! 103: LDUBA_R	lduba	[%r30, %r0] 0x72, %r21
	.word 0xeacc6000  ! 104: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r21
	.word 0xeaa48400  ! 105: STWA_R	stwa	%r21, [%r18 + %r0] 0x20
	.word 0x87802020  ! 106: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeabca000  ! 107: STDA_I	stda	%r21, [%r18 + 0x0000] %asi
	.word 0xeaf4e000  ! 108: STXA_I	stxa	%r21, [%r19 + 0x0000] %asi
	mov	0x7c8, %r21
	mov	0x7e8, %r22
	mov	0x7d0, %r22
	mov	0x3f8, %r20
	.word 0xea846000  ! 113: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r21
	mov	0x50, %r25
	.word 0xecdc0400  ! 115: LDXA_R	ldxa	[%r16, %r0] 0x20, %r22
	.word 0xeca46000  ! 116: STWA_I	stwa	%r22, [%r17 + 0x0000] %asi
	wr_tick_cmpr_0_0:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdc, %g2
	or	%g4, 0xe2, %g4
	or	%g6, 0xff, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xec9c2000  ! 118: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r22
	.word 0x87802020  ! 119: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecf544a0  ! 120: STXA_R	stxa	%r22, [%r21 + %r0] 0x25
	.word 0x87802073  ! 121: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r23
	.word 0xeca7e000  ! 123: STWA_I	stwa	%r22, [%r31 + 0x0000] %asi
	mov	0x7c0, %r23
	mov	0x60, %r27
	.word 0xeccf6000  ! 126: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r22
	.word 0xec8fa000  ! 127: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r22
	.word 0xecbfa000  ! 128: STDA_I	stda	%r22, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 129: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xec862000  ! 130: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r22
	.word 0x87802025  ! 131: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe28cc400  ! 132: LDUBA_R	lduba	[%r19, %r0] 0x20, %r17
	.word 0xe8de49e0  ! 133: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r20
	mov	0x70, %r26
	.word 0xe4be09e0  ! 135: STDA_R	stda	%r18, [%r24 + %r0] 0x4f
	.word 0xe4ad2000  ! 136: STBA_I	stba	%r18, [%r20 + 0x0000] %asi
	.word 0xe485a000  ! 137: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r18
	.word 0xeadec9e0  ! 138: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r21
	.word 0xea85e000  ! 139: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r21
	mov	0x48, %r16
	.word 0xeabd2000  ! 141: STDA_I	stda	%r21, [%r20 + 0x0000] %asi
	.word 0xe4dcc400  ! 142: LDXA_R	ldxa	[%r19, %r0] 0x20, %r18
	.word 0xe4bda000  ! 143: STDA_I	stda	%r18, [%r22 + 0x0000] %asi
	.word 0xe4bd6000  ! 144: STDA_I	stda	%r18, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 145: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0870e80  ! 146: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r16
	.word 0x87802025  ! 147: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 148: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r19
	.word 0xe89f8e60  ! 150: LDDA_R	ldda	[%r30, %r0] 0x73, %r20
	.word 0xe8d76000  ! 151: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r20
	.word 0xe8f7a000  ! 152: STXA_I	stxa	%r20, [%r30 + 0x0000] %asi
	.word 0xe8bfe000  ! 153: STDA_I	stda	%r20, [%r31 + 0x0000] %asi
	.word 0xe8afe000  ! 154: STBA_I	stba	%r20, [%r31 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xe8a72000  ! 156: STWA_I	stwa	%r20, [%r28 + 0x0000] %asi
	.word 0xeea70e80  ! 157: STWA_R	stwa	%r23, [%r28 + %r0] 0x74
	.word 0xe6df0e40  ! 158: LDXA_R	ldxa	[%r28, %r0] 0x72, %r19
	.word 0xeeb7ce60  ! 159: STHA_R	stha	%r23, [%r31 + %r0] 0x73
	.word 0xeeaf2000  ! 160: STBA_I	stba	%r23, [%r28 + 0x0000] %asi
	.word 0xe4a40400  ! 161: STWA_R	stwa	%r18, [%r16 + %r0] 0x20
	.word 0xe4f7e000  ! 162: STXA_I	stxa	%r18, [%r31 + 0x0000] %asi
	.word 0xeaac0400  ! 163: STBA_R	stba	%r21, [%r16 + %r0] 0x20
	mov	0x3f0, %r23
	.word 0x87802020  ! 165: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4d44400  ! 166: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r18
	.word 0x87802020  ! 167: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 168: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4a7a000  ! 169: STWA_I	stwa	%r18, [%r30 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xeaa7ce80  ! 171: STWA_R	stwa	%r21, [%r31 + %r0] 0x74
	.word 0xeadfa000  ! 172: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r21
	.word 0xe2b78e60  ! 173: STHA_R	stha	%r17, [%r30 + %r0] 0x73
	mov	0x7f8, %r22
	.word 0xe2bf2000  ! 175: STDA_I	stda	%r17, [%r28 + 0x0000] %asi
	mov	0x7c0, %r23
	mov	0x8, %r26
	.word 0xeab7ce40  ! 178: STHA_R	stha	%r21, [%r31 + %r0] 0x72
	.word 0xe2f7ce40  ! 179: STXA_R	stxa	%r17, [%r31 + %r0] 0x72
	.word 0x87802020  ! 180: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r22
	.word 0xe2cca000  ! 182: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r17
	.word 0xecbf8e80  ! 183: STDA_R	stda	%r22, [%r30 + %r0] 0x74
	.word 0xecac2000  ! 184: STBA_I	stba	%r22, [%r16 + 0x0000] %asi
	.word 0xe0ae89e0  ! 185: STBA_R	stba	%r16, [%r26 + %r0] 0x4f
	mov	0x0, %r19
	.word 0xeedf0e60  ! 187: LDXA_R	ldxa	[%r28, %r0] 0x73, %r23
	.word 0xe4dc4400  ! 188: LDXA_R	ldxa	[%r17, %r0] 0x20, %r18
	mov	0x48, %r19
	.word 0x87802074  ! 190: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r25
	.word 0xe4bfe000  ! 192: STDA_I	stda	%r18, [%r31 + 0x0000] %asi
	.word 0xe4f76000  ! 193: STXA_I	stxa	%r18, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 194: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r27
	.word 0xecad44a0  ! 196: STBA_R	stba	%r22, [%r21 + %r0] 0x25
	.word 0x87802072  ! 197: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecbc4400  ! 198: STDA_R	stda	%r22, [%r17 + %r0] 0x20
	mov	0x40, %r16
	mov	0x7c8, %r23
	.word 0xe4ad84a0  ! 201: STBA_R	stba	%r18, [%r22 + %r0] 0x25
	mov	0x18, %r25
	mov	0x18, %r19
	.word 0xe4bfe000  ! 204: STDA_I	stda	%r18, [%r31 + 0x0000] %asi
	.word 0xead74e80  ! 205: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r21
	mov	0x70, %r19
	.word 0xe0bf4e60  ! 207: STDA_R	stda	%r16, [%r29 + %r0] 0x73
	.word 0xe8f74e80  ! 208: STXA_R	stxa	%r20, [%r29 + %r0] 0x74
	mov	0x18, %r16
	.word 0xe89f2000  ! 210: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r20
	.word 0x87802025  ! 211: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe49f0e40  ! 212: LDDA_R	ldda	[%r28, %r0] 0x72, %r18
	.word 0xe8a44400  ! 213: STWA_R	stwa	%r20, [%r17 + %r0] 0x20
	.word 0xe8f56000  ! 214: STXA_I	stxa	%r20, [%r21 + 0x0000] %asi
	.word 0xec9ec9e0  ! 215: LDDA_R	ldda	[%r27, %r0] 0x4f, %r22
	.word 0xecad84a0  ! 216: STBA_R	stba	%r22, [%r22 + %r0] 0x25
	.word 0x87802072  ! 217: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecf72000  ! 218: STXA_I	stxa	%r22, [%r28 + 0x0000] %asi
	.word 0xec87e000  ! 219: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r22
	.word 0xe08d04a0  ! 220: LDUBA_R	lduba	[%r20, %r0] 0x25, %r16
	.word 0xe4c40400  ! 221: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r18
	.word 0xe88ec9e0  ! 222: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r20
	.word 0xe8c7e000  ! 223: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r20
	.word 0x87802020  ! 224: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeab48400  ! 225: STHA_R	stha	%r21, [%r18 + %r0] 0x20
	.word 0xea8ca000  ! 226: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r21
	.word 0xeaa42000  ! 227: STWA_I	stwa	%r21, [%r16 + 0x0000] %asi
	.word 0xe4c544a0  ! 228: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r18
	.word 0xec9689e0  ! 229: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r22
	.word 0xe2f48400  ! 230: STXA_R	stxa	%r17, [%r18 + %r0] 0x20
	.word 0xe2ac2000  ! 231: STBA_I	stba	%r17, [%r16 + 0x0000] %asi
	.word 0xe4d40400  ! 232: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r18
	.word 0xe2d7ce60  ! 233: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r17
	.word 0xe2a42000  ! 234: STWA_I	stwa	%r17, [%r16 + 0x0000] %asi
	.word 0xe2bc2000  ! 235: STDA_I	stda	%r17, [%r16 + 0x0000] %asi
	.word 0xe6d48400  ! 236: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r19
	mov	0x20, %r25
	mov	0x40, %r25
	mov	0x7d8, %r20
	.word 0x87802072  ! 240: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6cf6000  ! 241: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r19
	.word 0x87802074  ! 242: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6f7e000  ! 243: STXA_I	stxa	%r19, [%r31 + 0x0000] %asi
	.word 0xeeaf8e40  ! 244: STBA_R	stba	%r23, [%r30 + %r0] 0x72
	.word 0xeef7e000  ! 245: STXA_I	stxa	%r23, [%r31 + 0x0000] %asi
	.word 0xeecfe000  ! 246: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r23
	.word 0xe2a78e60  ! 247: STWA_R	stwa	%r17, [%r30 + %r0] 0x73
	.word 0xe6c689e0  ! 248: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r19
	.word 0xe49cc400  ! 249: LDDA_R	ldda	[%r19, %r0] 0x20, %r18
	.word 0x87802072  ! 250: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4af6000  ! 251: STBA_I	stba	%r18, [%r29 + 0x0000] %asi
	.word 0xe69f0e80  ! 252: LDDA_R	ldda	[%r28, %r0] 0x74, %r19
	.word 0x87802020  ! 253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 254: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6872000  ! 255: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r19
	mov	0x28, %r25
	.word 0xea970e40  ! 257: LDUHA_R	lduha	[%r28, %r0] 0x72, %r21
	mov	0x7d0, %r22
	.word 0x87802020  ! 259: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2bc8400  ! 260: STDA_R	stda	%r17, [%r18 + %r0] 0x20
	.word 0xee9c0400  ! 261: LDDA_R	ldda	[%r16, %r0] 0x20, %r23
	.word 0xeeac6000  ! 262: STBA_I	stba	%r23, [%r17 + 0x0000] %asi
	mov	0x68, %r27
	mov	0x3e0, %r23
	.word 0xe4b48400  ! 265: STHA_R	stha	%r18, [%r18 + %r0] 0x20
	mov	0x3c0, %r23
	.word 0xe4c4a000  ! 267: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r18
	.word 0x87802020  ! 268: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8b4c400  ! 269: STHA_R	stha	%r20, [%r19 + %r0] 0x20
	mov	0x40, %r26
	.word 0xe8846000  ! 271: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r20
	.word 0xeab74e60  ! 272: STHA_R	stha	%r21, [%r29 + %r0] 0x73
	mov	0x38, %r19
	.word 0xe4f4c400  ! 274: STXA_R	stxa	%r18, [%r19 + %r0] 0x20
	.word 0xeef6c9e0  ! 275: STXA_R	stxa	%r23, [%r27 + %r0] 0x4f
	.word 0xeecc6000  ! 276: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r23
	.word 0xe09f8e80  ! 277: LDDA_R	ldda	[%r30, %r0] 0x74, %r16
	.word 0x87802020  ! 278: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0c46000  ! 279: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r16
	.word 0xe4f4c400  ! 280: STXA_R	stxa	%r18, [%r19 + %r0] 0x20
	.word 0xe8bcc400  ! 281: STDA_R	stda	%r20, [%r19 + %r0] 0x20
	.word 0xe6f584a0  ! 282: STXA_R	stxa	%r19, [%r22 + %r0] 0x25
	mov	0x48, %r27
	.word 0xe4878e80  ! 284: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r18
	.word 0xe4840400  ! 285: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r18
	mov	0x20, %r24
	.word 0x87802074  ! 287: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xea9c0400  ! 288: LDDA_R	ldda	[%r16, %r0] 0x20, %r21
	.word 0x87802072  ! 289: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2d40400  ! 290: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r17
	mov	0x40, %r17
	mov	0x7c0, %r23
	.word 0xe2c76000  ! 293: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r17
	.word 0x87802020  ! 294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4af4e60  ! 295: STBA_R	stba	%r18, [%r29 + %r0] 0x73
	.word 0xe4dcc400  ! 296: LDXA_R	ldxa	[%r19, %r0] 0x20, %r18
	.word 0x87802025  ! 297: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 298: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r16
	.word 0xe4afe000  ! 300: STBA_I	stba	%r18, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 301: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6df4e60  ! 302: LDXA_R	ldxa	[%r29, %r0] 0x73, %r19
	mov	0x7e0, %r22
	.word 0xe4df0e40  ! 304: LDXA_R	ldxa	[%r28, %r0] 0x72, %r18
	.word 0x87802072  ! 305: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 306: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea94c400  ! 307: LDUHA_R	lduha	[%r19, %r0] 0x20, %r21
	.word 0xe2dc8400  ! 308: LDXA_R	ldxa	[%r18, %r0] 0x20, %r17
	.word 0xe4f7ce80  ! 309: STXA_R	stxa	%r18, [%r31 + %r0] 0x74
	mov	0x3f0, %r22
	.word 0xe4ac6000  ! 311: STBA_I	stba	%r18, [%r17 + 0x0000] %asi
	.word 0xe4d4e000  ! 312: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r18
	.word 0xecc44400  ! 313: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r22
	.word 0x87802073  ! 314: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r16
	mov	0x10, %r25
	wr_tick_cmpr_0_1:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf3, %g2
	or	%g4, 0xa9, %g4
	or	%g6, 0xfb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 318: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec8c6000  ! 319: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r22
	.word 0xeca4e000  ! 320: STWA_I	stwa	%r22, [%r19 + 0x0000] %asi
	.word 0xe4bc0400  ! 321: STDA_R	stda	%r18, [%r16 + %r0] 0x20
	.word 0xe4ac2000  ! 322: STBA_I	stba	%r18, [%r16 + 0x0000] %asi
	wr_tick_cmpr_0_2:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdc, %g2
	or	%g4, 0xa2, %g4
	or	%g6, 0x83, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 324: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4b7e000  ! 325: STHA_I	stha	%r18, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 326: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 327: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r17
	.word 0xe4870e60  ! 329: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r18
	.word 0xe4bc2000  ! 330: STDA_I	stda	%r18, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 331: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeea584a0  ! 332: STWA_R	stwa	%r23, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 333: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r27
	.word 0xeeb6e000  ! 335: STHA_I	stha	%r23, [%r27 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xeeb6e000  ! 337: STHA_I	stha	%r23, [%r27 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802074  ! 339: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6b5c4a0  ! 340: STHA_R	stha	%r19, [%r23 + %r0] 0x25
	.word 0x87802074  ! 341: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r22
	mov	0x28, %r24
	.word 0x87802074  ! 344: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r18
	.word 0xe4b40400  ! 346: STHA_R	stha	%r18, [%r16 + %r0] 0x20
	.word 0xe0d7ce60  ! 347: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r16
	.word 0xe0c7e000  ! 348: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r16
	.word 0xe0df6000  ! 349: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r16
	mov	0x18, %r25
	mov	0x20, %r26
	.word 0xe0b7e000  ! 352: STHA_I	stha	%r16, [%r31 + 0x0000] %asi
	.word 0xe0b72000  ! 353: STHA_I	stha	%r16, [%r28 + 0x0000] %asi
	mov	0x18, %r27
	mov	0x7e0, %r22
	mov	0x28, %r26
	.word 0xe0ccc400  ! 357: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r16
	.word 0xe09e09e0  ! 358: LDDA_R	ldda	[%r24, %r0] 0x4f, %r16
	.word 0xe8bf0e80  ! 359: STDA_R	stda	%r20, [%r28 + %r0] 0x74
	.word 0xe88fa000  ! 360: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r20
	.word 0xe8df6000  ! 361: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r20
	.word 0xe8df2000  ! 362: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r20
	.word 0xe2dc0400  ! 363: LDXA_R	ldxa	[%r16, %r0] 0x20, %r17
	.word 0xe2a72000  ! 364: STWA_I	stwa	%r17, [%r28 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xe2d7e000  ! 366: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r17
	.word 0x87802072  ! 367: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2cfa000  ! 368: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r17
	.word 0x87802072  ! 369: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 370: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2bf2000  ! 371: STDA_I	stda	%r17, [%r28 + 0x0000] %asi
	.word 0xe2a7a000  ! 372: STWA_I	stwa	%r17, [%r30 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xe2972000  ! 374: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r17
	mov	0x7c0, %r23
	.word 0xe6cdc4a0  ! 376: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r19
	.word 0xe4ac8400  ! 377: STBA_R	stba	%r18, [%r18 + %r0] 0x20
	.word 0xe49fa000  ! 378: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r18
	.word 0xee84c400  ! 379: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r23
	.word 0xee97a000  ! 380: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r23
	.word 0xe49504a0  ! 381: LDUHA_R	lduha	[%r20, %r0] 0x25, %r18
	mov	0x7e8, %r22
	.word 0xe4cf6000  ! 383: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r18
	mov	0x7e8, %r21
	.word 0xe4f7a000  ! 385: STXA_I	stxa	%r18, [%r30 + 0x0000] %asi
	.word 0xe497e000  ! 386: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r18
	.word 0xe49f2000  ! 387: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r18
	mov	0x28, %r27
	.word 0xe29f0e40  ! 389: LDDA_R	ldda	[%r28, %r0] 0x72, %r17
	mov	0x28, %r17
	.word 0xe28f2000  ! 391: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r17
	.word 0xe0f4c400  ! 392: STXA_R	stxa	%r16, [%r19 + %r0] 0x20
	.word 0xe0f7a000  ! 393: STXA_I	stxa	%r16, [%r30 + 0x0000] %asi
	.word 0xe0c72000  ! 394: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r16
	.word 0xe8840400  ! 395: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r20
	.word 0xe8b76000  ! 396: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	.word 0xe8f7e000  ! 397: STXA_I	stxa	%r20, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 399: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4d584a0  ! 400: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r18
	.word 0xe4bfa000  ! 401: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xe0af4e60  ! 403: STBA_R	stba	%r16, [%r29 + %r0] 0x73
	.word 0xe0df2000  ! 404: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r16
	mov	0x40, %r27
	.word 0xe08f2000  ! 406: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r16
	.word 0xe6bc4400  ! 407: STDA_R	stda	%r19, [%r17 + %r0] 0x20
	mov	0x3c0, %r20
	mov	0x20, %r17
	.word 0xe2f4c400  ! 410: STXA_R	stxa	%r17, [%r19 + %r0] 0x20
	.word 0xeed504a0  ! 411: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r23
	.word 0x87802020  ! 412: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb74e60  ! 413: STHA_R	stha	%r22, [%r29 + %r0] 0x73
	mov	0x60, %r27
	.word 0xe8bf4e80  ! 415: STDA_R	stda	%r20, [%r29 + %r0] 0x74
	mov	0x40, %r19
	mov	0x3d8, %r20
	.word 0x87802025  ! 418: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0f7ce60  ! 419: STXA_R	stxa	%r16, [%r31 + %r0] 0x73
	.word 0xe0bd2000  ! 420: STDA_I	stda	%r16, [%r20 + 0x0000] %asi
	.word 0xe08de000  ! 421: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r16
	mov	0x3f8, %r21
	.word 0xe2df8e60  ! 423: LDXA_R	ldxa	[%r30, %r0] 0x73, %r17
	.word 0xeab78e40  ! 424: STHA_R	stha	%r21, [%r30 + %r0] 0x72
	.word 0xeab5a000  ! 425: STHA_I	stha	%r21, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 426: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 427: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 428: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8af0e40  ! 429: STBA_R	stba	%r20, [%r28 + %r0] 0x72
	.word 0x87802072  ! 430: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6d44400  ! 431: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r19
	.word 0x87802020  ! 432: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6a42000  ! 433: STWA_I	stwa	%r19, [%r16 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0x87802072  ! 435: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0c689e0  ! 436: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r16
	.word 0xe0df2000  ! 437: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r16
	.word 0xea8dc4a0  ! 438: LDUBA_R	lduba	[%r23, %r0] 0x25, %r21
	mov	0x48, %r26
	.word 0xe89dc4a0  ! 440: LDDA_R	ldda	[%r23, %r0] 0x25, %r20
	mov	0x38, %r26
	.word 0xeef74e40  ! 442: STXA_R	stxa	%r23, [%r29 + %r0] 0x72
	mov	0x10, %r26
	.word 0x87802025  ! 444: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe08f8e40  ! 445: LDUBA_R	lduba	[%r30, %r0] 0x72, %r16
	.word 0x87802025  ! 446: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4a7ce80  ! 447: STWA_R	stwa	%r18, [%r31 + %r0] 0x74
	.word 0xe4a52000  ! 448: STWA_I	stwa	%r18, [%r20 + 0x0000] %asi
	.word 0xe4a5a000  ! 449: STWA_I	stwa	%r18, [%r22 + 0x0000] %asi
	.word 0xea970e80  ! 450: LDUHA_R	lduha	[%r28, %r0] 0x74, %r21
	.word 0x87802072  ! 451: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r24
	.word 0xeef6c9e0  ! 453: STXA_R	stxa	%r23, [%r27 + %r0] 0x4f
	.word 0xeebf6000  ! 454: STDA_I	stda	%r23, [%r29 + 0x0000] %asi
	.word 0xeea7e000  ! 455: STWA_I	stwa	%r23, [%r31 + 0x0000] %asi
	.word 0xeedf6000  ! 456: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r23
	.word 0x8780204f  ! 457: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 458: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeecf2000  ! 459: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r23
	.word 0xeaf48400  ! 460: STXA_R	stxa	%r21, [%r18 + %r0] 0x20
	.word 0xeab76000  ! 461: STHA_I	stha	%r21, [%r29 + 0x0000] %asi
	mov	0x48, %r16
	.word 0x87802074  ! 463: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeef78e60  ! 464: STXA_R	stxa	%r23, [%r30 + %r0] 0x73
	.word 0x87802073  ! 465: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 466: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xee86e000  ! 467: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r23
	mov	0x7c8, %r20
	.word 0x87802073  ! 469: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 470: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeef62000  ! 471: STXA_I	stxa	%r23, [%r24 + 0x0000] %asi
	.word 0xeeb6a000  ! 472: STHA_I	stha	%r23, [%r26 + 0x0000] %asi
	mov	0x48, %r19
	mov	0x28, %r18
	.word 0x87802020  ! 475: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xee9ca000  ! 476: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r23
	.word 0xeebca000  ! 477: STDA_I	stda	%r23, [%r18 + 0x0000] %asi
	.word 0xe2f649e0  ! 478: STXA_R	stxa	%r17, [%r25 + %r0] 0x4f
	.word 0xe2c504a0  ! 479: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r17
	.word 0xe2dce000  ! 480: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r17
	.word 0xe2cca000  ! 481: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r17
	.word 0xe2848400  ! 482: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r17
	.word 0xe2ace000  ! 483: STBA_I	stba	%r17, [%r19 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xe2aca000  ! 485: STBA_I	stba	%r17, [%r18 + 0x0000] %asi
	.word 0xe284e000  ! 486: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r17
	.word 0xe6b40400  ! 487: STHA_R	stha	%r19, [%r16 + %r0] 0x20
	.word 0xe6bca000  ! 488: STDA_I	stda	%r19, [%r18 + 0x0000] %asi
	.word 0xe6a4e000  ! 489: STWA_I	stwa	%r19, [%r19 + 0x0000] %asi
	.word 0xe6aca000  ! 490: STBA_I	stba	%r19, [%r18 + 0x0000] %asi
	.word 0xe684e000  ! 491: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r19
	.word 0x87802025  ! 492: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r20
	mov	0x3d8, %r21
	.word 0xe6ac4400  ! 495: STBA_R	stba	%r19, [%r17 + %r0] 0x20
	mov	0x78, %r27
	.word 0x8780204f  ! 497: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d0, %r23
	.word 0xe8a40400  ! 499: STWA_R	stwa	%r20, [%r16 + %r0] 0x20
	.word 0x87802020  ! 500: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8842000  ! 501: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r20
	mov	0x3e0, %r21
	.word 0xe8d46000  ! 503: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r20
	.word 0xe894e000  ! 504: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r20
	.word 0xe8842000  ! 505: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r20
	.word 0x87802020  ! 506: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea944400  ! 507: LDUHA_R	lduha	[%r17, %r0] 0x20, %r21
	.word 0xeecf0e40  ! 508: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r23
	.word 0xee9ce000  ! 509: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r23
	.word 0xe4bf4e60  ! 510: STDA_R	stda	%r18, [%r29 + %r0] 0x73
	mov	0x10, %r16
	.word 0xe4c78e40  ! 512: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r18
	.word 0xe6c74e40  ! 513: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r19
	.word 0xe69c0400  ! 514: LDDA_R	ldda	[%r16, %r0] 0x20, %r19
	.word 0xe0c70e80  ! 515: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r16
	mov	0x3f0, %r20
	.word 0x87802073  ! 517: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r17
	.word 0xe0cfe000  ! 519: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r16
	.word 0xe0876000  ! 520: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r16
	.word 0xe0a72000  ! 521: STWA_I	stwa	%r16, [%r28 + 0x0000] %asi
	.word 0xe0b76000  ! 522: STHA_I	stha	%r16, [%r29 + 0x0000] %asi
	.word 0xe8c7ce40  ! 523: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r20
	.word 0xe89fe000  ! 524: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r20
	.word 0xe8bfe000  ! 525: STDA_I	stda	%r20, [%r31 + 0x0000] %asi
	.word 0xe8972000  ! 526: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r20
	.word 0xee9584a0  ! 527: LDUHA_R	lduha	[%r22, %r0] 0x25, %r23
	.word 0xeeafa000  ! 528: STBA_I	stba	%r23, [%r30 + 0x0000] %asi
	.word 0xeef7e000  ! 529: STXA_I	stxa	%r23, [%r31 + 0x0000] %asi
	.word 0xeeaf6000  ! 530: STBA_I	stba	%r23, [%r29 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0xeaf504a0  ! 532: STXA_R	stxa	%r21, [%r20 + %r0] 0x25
	.word 0xea840400  ! 533: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r21
	mov	0x68, %r16
	.word 0xe6cf0e60  ! 535: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r19
	mov	0x70, %r16
	.word 0xe6f72000  ! 537: STXA_I	stxa	%r19, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe68fe000  ! 539: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r19
	.word 0x87802073  ! 540: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeeb44400  ! 541: STHA_R	stha	%r23, [%r17 + %r0] 0x20
	mov	0x58, %r17
	.word 0xeeafa000  ! 543: STBA_I	stba	%r23, [%r30 + 0x0000] %asi
	.word 0xeeaf2000  ! 544: STBA_I	stba	%r23, [%r28 + 0x0000] %asi
	.word 0xeed72000  ! 545: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r23
	.word 0xeebf2000  ! 546: STDA_I	stda	%r23, [%r28 + 0x0000] %asi
	.word 0xeec7e000  ! 547: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r23
	.word 0x87802073  ! 548: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xeef7a000  ! 550: STXA_I	stxa	%r23, [%r30 + 0x0000] %asi
	.word 0xeeb7a000  ! 551: STHA_I	stha	%r23, [%r30 + 0x0000] %asi
	.word 0xeebf6000  ! 552: STDA_I	stda	%r23, [%r29 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xeedf2000  ! 554: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r23
	.word 0x87802072  ! 555: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe28649e0  ! 556: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r17
	.word 0xe2f7ce40  ! 557: STXA_R	stxa	%r17, [%r31 + %r0] 0x72
	.word 0xe297a000  ! 558: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r17
	.word 0xecac8400  ! 559: STBA_R	stba	%r22, [%r18 + %r0] 0x20
	mov	0x58, %r17
	.word 0xecb7a000  ! 561: STHA_I	stha	%r22, [%r30 + 0x0000] %asi
	.word 0xe6c6c9e0  ! 562: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r19
	mov	0x7c0, %r22
	.word 0xe6f72000  ! 564: STXA_I	stxa	%r19, [%r28 + 0x0000] %asi
	.word 0xe68f4e40  ! 565: LDUBA_R	lduba	[%r29, %r0] 0x72, %r19
	.word 0xe6cfa000  ! 566: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r19
	.word 0xecdc8400  ! 567: LDXA_R	ldxa	[%r18, %r0] 0x20, %r22
	.word 0xe8d70e80  ! 568: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r20
	.word 0xe2ad44a0  ! 569: STBA_R	stba	%r17, [%r21 + %r0] 0x25
	.word 0xea87ce40  ! 570: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r21
	.word 0xeac44400  ! 571: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r21
	.word 0xe49dc4a0  ! 572: LDDA_R	ldda	[%r23, %r0] 0x25, %r18
	.word 0xe4f7e000  ! 573: STXA_I	stxa	%r18, [%r31 + 0x0000] %asi
	.word 0xeaa689e0  ! 574: STWA_R	stwa	%r21, [%r26 + %r0] 0x4f
	.word 0xeaf72000  ! 575: STXA_I	stxa	%r21, [%r28 + 0x0000] %asi
	mov	0x28, %r24
	.word 0x87802020  ! 577: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeadca000  ! 578: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r21
	.word 0x87802020  ! 579: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea842000  ! 580: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r21
	.word 0xe0d4c400  ! 581: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r16
	.word 0xe0b584a0  ! 582: STHA_R	stha	%r16, [%r22 + %r0] 0x25
	.word 0xe0ace000  ! 583: STBA_I	stba	%r16, [%r19 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xe0bce000  ! 585: STDA_I	stda	%r16, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 586: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0f7a000  ! 587: STXA_I	stxa	%r16, [%r30 + 0x0000] %asi
	.word 0xeeac4400  ! 588: STBA_R	stba	%r23, [%r17 + %r0] 0x20
	.word 0xe6d4c400  ! 589: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r19
	mov	0x3d0, %r22
	.word 0xe687a000  ! 591: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r19
	wr_tick_cmpr_0_3:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdd, %g2
	or	%g4, 0xee, %g4
	or	%g6, 0xd0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xecbf4e80  ! 593: STDA_R	stda	%r22, [%r29 + %r0] 0x74
	.word 0xecbf2000  ! 594: STDA_I	stda	%r22, [%r28 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xec876000  ! 596: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r22
	.word 0xecbf8e40  ! 597: STDA_R	stda	%r22, [%r30 + %r0] 0x72
	.word 0xec976000  ! 598: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r22
	.word 0xec97e000  ! 599: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r22
	.word 0xe4a70e60  ! 600: STWA_R	stwa	%r18, [%r28 + %r0] 0x73
	.word 0xe6bfce60  ! 601: STDA_R	stda	%r19, [%r31 + %r0] 0x73
	.word 0xe6d70e40  ! 602: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r19
	.word 0xe6f7e000  ! 603: STXA_I	stxa	%r19, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 604: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 605: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0b689e0  ! 606: STHA_R	stha	%r16, [%r26 + %r0] 0x4f
	.word 0xe0a7e000  ! 607: STWA_I	stwa	%r16, [%r31 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xee974e60  ! 609: LDUHA_R	lduha	[%r29, %r0] 0x73, %r23
	.word 0x87802073  ! 610: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeea609e0  ! 611: STWA_R	stwa	%r23, [%r24 + %r0] 0x4f
	.word 0xeea7a000  ! 612: STWA_I	stwa	%r23, [%r30 + 0x0000] %asi
	.word 0xee972000  ! 613: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r23
	.word 0xeef7a000  ! 614: STXA_I	stxa	%r23, [%r30 + 0x0000] %asi
	.word 0xeebf8e60  ! 615: STDA_R	stda	%r23, [%r30 + %r0] 0x73
	.word 0xe0dc4400  ! 616: LDXA_R	ldxa	[%r17, %r0] 0x20, %r16
	.word 0x87802074  ! 617: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0bf6000  ! 618: STDA_I	stda	%r16, [%r29 + 0x0000] %asi
	.word 0xee9c4400  ! 619: LDDA_R	ldda	[%r17, %r0] 0x20, %r23
	.word 0x87802020  ! 620: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeeb7ce80  ! 621: STHA_R	stha	%r23, [%r31 + %r0] 0x74
	.word 0x87802074  ! 622: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0bfce80  ! 623: STDA_R	stda	%r16, [%r31 + %r0] 0x74
	.word 0xe4cf8e80  ! 624: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r18
	.word 0xe4cfe000  ! 625: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r18
	.word 0xe28c0400  ! 626: LDUBA_R	lduba	[%r16, %r0] 0x20, %r17
	.word 0xe6bcc400  ! 627: STDA_R	stda	%r19, [%r19 + %r0] 0x20
	mov	0x7c0, %r21
	wr_tick_cmpr_0_4:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdd, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0x98, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x60, %r27
	wr_tick_cmpr_0_5:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9f, %g2
	or	%g4, 0x9f, %g4
	or	%g6, 0xf0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe4cd44a0  ! 632: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r18
	.word 0x87802073  ! 633: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r16
	mov	0x60, %r25
	.word 0xe4872000  ! 636: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r18
	.word 0xe4876000  ! 637: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r18
	.word 0xe4af8e40  ! 638: STBA_R	stba	%r18, [%r30 + %r0] 0x72
	.word 0xec9c4400  ! 639: LDDA_R	ldda	[%r17, %r0] 0x20, %r22
	.word 0xec976000  ! 640: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r22
	mov	0x58, %r19
	mov	0x70, %r25
	.word 0x87802020  ! 643: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4944400  ! 644: LDUHA_R	lduha	[%r17, %r0] 0x20, %r18
	mov	0x28, %r16
	.word 0xe4a46000  ! 646: STWA_I	stwa	%r18, [%r17 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xee840400  ! 648: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r23
	.word 0xe8b4c400  ! 649: STHA_R	stha	%r20, [%r19 + %r0] 0x20
	.word 0xe696c9e0  ! 650: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r19
	.word 0xec9649e0  ! 651: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r22
	.word 0xe8a649e0  ! 652: STWA_R	stwa	%r20, [%r25 + %r0] 0x4f
	.word 0xe8c649e0  ! 653: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r20
	.word 0xe8b46000  ! 654: STHA_I	stha	%r20, [%r17 + 0x0000] %asi
	mov	0x68, %r18
	mov	0x3f8, %r21
	mov	0x3c8, %r23
	mov	0x78, %r27
	mov	0x68, %r18
	mov	0x7c8, %r22
	mov	0x7f8, %r23
	.word 0xe0df4e80  ! 662: LDXA_R	ldxa	[%r29, %r0] 0x74, %r16
	.word 0x87802073  ! 663: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4ac4400  ! 664: STBA_R	stba	%r18, [%r17 + %r0] 0x20
	.word 0xe4cf2000  ! 665: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r18
	.word 0xe4df6000  ! 666: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r18
	mov	0x7d8, %r20
	.word 0x87802020  ! 668: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r27
	wr_tick_cmpr_0_6:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe1, %g2
	or	%g4, 0xbd, %g4
	or	%g6, 0x87, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe4c4e000  ! 671: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r18
	.word 0xe4ac6000  ! 672: STBA_I	stba	%r18, [%r17 + 0x0000] %asi
	.word 0xeac40400  ! 673: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r21
	.word 0x87802074  ! 674: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0afce40  ! 675: STBA_R	stba	%r16, [%r31 + %r0] 0x72
	.word 0x87802072  ! 676: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xe6c78e60  ! 678: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r19
	.word 0xe6af6000  ! 679: STBA_I	stba	%r19, [%r29 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xe68fe000  ! 681: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r19
	.word 0x87802072  ! 682: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 683: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6d6a000  ! 684: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r19
	.word 0xe2a48400  ! 685: STWA_R	stwa	%r17, [%r18 + %r0] 0x20
	.word 0xeaaf0e80  ! 686: STBA_R	stba	%r21, [%r28 + %r0] 0x74
	mov	0x40, %r19
	.word 0xeaf62000  ! 688: STXA_I	stxa	%r21, [%r24 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xe6b74e60  ! 690: STHA_R	stha	%r19, [%r29 + %r0] 0x73
	mov	0x60, %r19
	.word 0xe6d66000  ! 692: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r19
	.word 0xe8b7ce40  ! 693: STHA_R	stha	%r20, [%r31 + %r0] 0x72
	.word 0xe8c6a000  ! 694: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r20
	.word 0xe2d70e80  ! 695: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r17
	.word 0xee9f0e60  ! 696: LDDA_R	ldda	[%r28, %r0] 0x73, %r23
	.word 0xe68d04a0  ! 697: LDUBA_R	lduba	[%r20, %r0] 0x25, %r19
	.word 0xe6b62000  ! 698: STHA_I	stha	%r19, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 699: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6de6000  ! 700: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r19
	mov	0x28, %r25
	.word 0x87802072  ! 702: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6d78e60  ! 703: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r19
	.word 0x87802020  ! 704: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r17
	.word 0xe68ca000  ! 706: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r19
	.word 0x87802020  ! 707: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6aca000  ! 708: STBA_I	stba	%r19, [%r18 + 0x0000] %asi
	.word 0xe897ce60  ! 709: LDUHA_R	lduha	[%r31, %r0] 0x73, %r20
	mov	0x78, %r24
	.word 0xe8cc6000  ! 711: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r20
	.word 0xe88ce000  ! 712: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r20
	.word 0xe89c2000  ! 713: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r20
	.word 0xe6b44400  ! 714: STHA_R	stha	%r19, [%r17 + %r0] 0x20
	mov	0x28, %r19
	.word 0xe68c6000  ! 716: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r19
	.word 0xe8c7ce80  ! 717: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r20
	mov	0x8, %r16
	.word 0xe8bc6000  ! 719: STDA_I	stda	%r20, [%r17 + 0x0000] %asi
	.word 0xe89c2000  ! 720: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r20
	mov	0x68, %r17
	.word 0xe8b42000  ! 722: STHA_I	stha	%r20, [%r16 + 0x0000] %asi
	.word 0xe8b46000  ! 723: STHA_I	stha	%r20, [%r17 + 0x0000] %asi
	.word 0xe8c46000  ! 724: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r20
	.word 0xeecfce60  ! 725: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r23
	.word 0xee9f8e80  ! 726: LDDA_R	ldda	[%r30, %r0] 0x74, %r23
	.word 0xeeb42000  ! 727: STHA_I	stha	%r23, [%r16 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xeedce000  ! 729: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r23
	.word 0xeef4a000  ! 730: STXA_I	stxa	%r23, [%r18 + 0x0000] %asi
	.word 0xe0a78e40  ! 731: STWA_R	stwa	%r16, [%r30 + %r0] 0x72
	.word 0xe0a46000  ! 732: STWA_I	stwa	%r16, [%r17 + 0x0000] %asi
	.word 0xe0f46000  ! 733: STXA_I	stxa	%r16, [%r17 + 0x0000] %asi
	.word 0xe09c6000  ! 734: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r16
	.word 0xe0d46000  ! 735: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r16
	.word 0xe8c78e80  ! 736: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r20
	.word 0xe8cf8e80  ! 737: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r20
	wr_tick_cmpr_0_7:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9f, %g2
	or	%g4, 0xbb, %g4
	or	%g6, 0x9d, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe0c4c400  ! 739: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r16
	mov	0x3d8, %r21
	.word 0x87802020  ! 741: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0bc6000  ! 742: STDA_I	stda	%r16, [%r17 + 0x0000] %asi
	.word 0xeeaf0e60  ! 743: STBA_R	stba	%r23, [%r28 + %r0] 0x73
	.word 0xeef4e000  ! 744: STXA_I	stxa	%r23, [%r19 + 0x0000] %asi
	mov	0x38, %r27
	mov	0x48, %r17
	.word 0x87802072  ! 747: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeeaf6000  ! 748: STBA_I	stba	%r23, [%r29 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xeebfa000  ! 750: STDA_I	stda	%r23, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 751: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeebee000  ! 752: STDA_I	stda	%r23, [%r27 + 0x0000] %asi
	.word 0xee8ea000  ! 753: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r23
	.word 0xeeaee000  ! 754: STBA_I	stba	%r23, [%r27 + 0x0000] %asi
	mov	0x8, %r25
	.word 0x87802073  ! 756: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2c40400  ! 757: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r17
	.word 0x87802072  ! 758: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r19
	mov	0x8, %r26
	.word 0xe2dfa000  ! 761: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r17
	.word 0xeaf7ce80  ! 762: STXA_R	stxa	%r21, [%r31 + %r0] 0x74
	mov	0x3c0, %r21
	.word 0xe0c78e80  ! 764: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r16
	.word 0xe0a76000  ! 765: STWA_I	stwa	%r16, [%r29 + 0x0000] %asi
	.word 0xe0af6000  ! 766: STBA_I	stba	%r16, [%r29 + 0x0000] %asi
	.word 0xe0d7a000  ! 767: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r16
	mov	0x0, %r26
	.word 0xe09fe000  ! 769: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r16
	.word 0xe08fe000  ! 770: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r16
	.word 0xe0afa000  ! 771: STBA_I	stba	%r16, [%r30 + 0x0000] %asi
	mov	0x7f8, %r23
	mov	0x8, %r26
	.word 0x87802020  ! 774: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r20
	mov	0x68, %r19
	mov	0x58, %r24
	mov	0x0, %r17
	.word 0xe2978e60  ! 779: LDUHA_R	lduha	[%r30, %r0] 0x73, %r17
	.word 0xe294a000  ! 780: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r17
	mov	0x70, %r25
	.word 0xe29c2000  ! 782: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r17
	.word 0xead5c4a0  ! 783: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r21
	mov	0x78, %r16
	mov	0x50, %r19
	.word 0xeacce000  ! 786: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r21
	.word 0x87802072  ! 787: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeab7a000  ! 788: STHA_I	stha	%r21, [%r30 + 0x0000] %asi
	.word 0xecb6c9e0  ! 789: STHA_R	stha	%r22, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 790: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecc72000  ! 791: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r22
	.word 0xec978e40  ! 792: LDUHA_R	lduha	[%r30, %r0] 0x72, %r22
	.word 0xec872000  ! 793: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r22
	mov	0x7e0, %r21
	.word 0xe0ac8400  ! 795: STBA_R	stba	%r16, [%r18 + %r0] 0x20
	.word 0xe0bfa000  ! 796: STDA_I	stda	%r16, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 797: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_0_8:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xaa, %g2
	or	%g4, 0xe1, %g4
	or	%g6, 0xf4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x8780204f  ! 799: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0de6000  ! 800: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r16
	mov	0x0, %r24
	.word 0x87802074  ! 802: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 803: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0d4e000  ! 804: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r16
	.word 0xe0c4e000  ! 805: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r16
	.word 0xe0bc2000  ! 806: STDA_I	stda	%r16, [%r16 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xe6ac0400  ! 808: STBA_R	stba	%r19, [%r16 + %r0] 0x20
	.word 0xe8874e60  ! 809: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r20
	.word 0xe8ace000  ! 810: STBA_I	stba	%r20, [%r19 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xe0de09e0  ! 812: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r16
	mov	0x3e8, %r20
	wr_tick_cmpr_0_9:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x88, %g2
	or	%g4, 0x8f, %g4
	or	%g6, 0xee, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 815: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a42000  ! 816: STWA_I	stwa	%r16, [%r16 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xeeb44400  ! 818: STHA_R	stha	%r23, [%r17 + %r0] 0x20
	mov	0x50, %r19
	.word 0xeedc6000  ! 820: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r23
	.word 0xeeb4a000  ! 821: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	wr_tick_cmpr_0_10:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0xd8, %g4
	or	%g6, 0xfb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x50, %r24
	.word 0xe08f8e40  ! 824: LDUBA_R	lduba	[%r30, %r0] 0x72, %r16
	.word 0xe0dcc400  ! 825: LDXA_R	ldxa	[%r19, %r0] 0x20, %r16
	mov	0x3c0, %r23
	.word 0xe0bc6000  ! 827: STDA_I	stda	%r16, [%r17 + 0x0000] %asi
	.word 0xe0cce000  ! 828: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r16
	.word 0x87802025  ! 829: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xec8f8e60  ! 830: LDUBA_R	lduba	[%r30, %r0] 0x73, %r22
	mov	0x18, %r26
	.word 0xe4c44400  ! 832: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r18
	.word 0xec9e09e0  ! 833: LDDA_R	ldda	[%r24, %r0] 0x4f, %r22
	.word 0xeca5a000  ! 834: STWA_I	stwa	%r22, [%r22 + 0x0000] %asi
	.word 0xe68e49e0  ! 835: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r19
	.word 0xe6dd6000  ! 836: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r19
	.word 0xe0af8e60  ! 837: STBA_R	stba	%r16, [%r30 + %r0] 0x73
	.word 0xe0c52000  ! 838: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r16
	.word 0xe0cde000  ! 839: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r16
	.word 0x8780204f  ! 840: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe496c9e0  ! 841: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r18
	mov	0x70, %r19
	.word 0xeaa74e60  ! 843: STWA_R	stwa	%r21, [%r29 + %r0] 0x73
	.word 0xeef70e40  ! 844: STXA_R	stxa	%r23, [%r28 + %r0] 0x72
	.word 0xeabc4400  ! 845: STDA_R	stda	%r21, [%r17 + %r0] 0x20
	mov	0x7f8, %r23
	.word 0xea9e6000  ! 847: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r21
	mov	0x20, %r25
	.word 0x87802072  ! 849: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecb44400  ! 850: STHA_R	stha	%r22, [%r17 + %r0] 0x20
	.word 0xeec40400  ! 851: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r23
	.word 0xe297ce80  ! 852: LDUHA_R	lduha	[%r31, %r0] 0x74, %r17
	.word 0xe2f7e000  ! 853: STXA_I	stxa	%r17, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 854: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecbec9e0  ! 855: STDA_R	stda	%r22, [%r27 + %r0] 0x4f
	mov	0x8, %r16
	.word 0xec86e000  ! 857: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r22
	.word 0x87802074  ! 858: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xecdf2000  ! 859: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r22
	.word 0x87802074  ! 860: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xec8f6000  ! 861: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	.word 0x87802074  ! 862: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xecbf4e60  ! 863: STDA_R	stda	%r22, [%r29 + %r0] 0x73
	.word 0x87802074  ! 864: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeec7ce60  ! 865: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r23
	mov	0x3e8, %r22
	.word 0xeea72000  ! 867: STWA_I	stwa	%r23, [%r28 + 0x0000] %asi
	.word 0xeecfe000  ! 868: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r23
	.word 0xeebf2000  ! 869: STDA_I	stda	%r23, [%r28 + 0x0000] %asi
	.word 0xea9c0400  ! 870: LDDA_R	ldda	[%r16, %r0] 0x20, %r21
	.word 0x8780204f  ! 871: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4d70e80  ! 872: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r18
	.word 0x87802074  ! 873: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4f7a000  ! 874: STXA_I	stxa	%r18, [%r30 + 0x0000] %asi
	.word 0xe48fe000  ! 875: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r18
	mov	0x68, %r24
	mov	0x70, %r16
	.word 0xe2de09e0  ! 878: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r17
	.word 0xe287a000  ! 879: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r17
	.word 0x87802020  ! 880: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8bd04a0  ! 881: STDA_R	stda	%r20, [%r20 + %r0] 0x25
	.word 0xe8a4a000  ! 882: STWA_I	stwa	%r20, [%r18 + 0x0000] %asi
	.word 0xe8dce000  ! 883: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r20
	.word 0xeec6c9e0  ! 884: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r23
	mov	0x7c8, %r20
	mov	0x7c8, %r20
	.word 0xe28584a0  ! 887: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r17
	.word 0xe0b7ce80  ! 888: STHA_R	stha	%r16, [%r31 + %r0] 0x74
	.word 0xe0aca000  ! 889: STBA_I	stba	%r16, [%r18 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xe694c400  ! 891: LDUHA_R	lduha	[%r19, %r0] 0x20, %r19
	.word 0xe2844400  ! 892: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r17
	mov	0x38, %r24
	.word 0x87802020  ! 894: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2946000  ! 895: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r17
	.word 0x87802025  ! 896: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r27
	mov	0x30, %r27
	.word 0xe29d2000  ! 899: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r17
	.word 0x87802025  ! 900: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeccc0400  ! 901: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r22
	mov	0x10, %r26
	.word 0x87802020  ! 903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2a48400  ! 904: STWA_R	stwa	%r17, [%r18 + %r0] 0x20
	.word 0xe2bc6000  ! 905: STDA_I	stda	%r17, [%r17 + 0x0000] %asi
	.word 0xe2b4e000  ! 906: STHA_I	stha	%r17, [%r19 + 0x0000] %asi
	.word 0xe08e09e0  ! 907: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r16
	.word 0xe2bf8e60  ! 908: STDA_R	stda	%r17, [%r30 + %r0] 0x73
	.word 0xecce09e0  ! 909: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r22
	mov	0x68, %r24
	mov	0x40, %r27
	.word 0xecbca000  ! 912: STDA_I	stda	%r22, [%r18 + 0x0000] %asi
	.word 0xec94e000  ! 913: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r22
	.word 0xecb46000  ! 914: STHA_I	stha	%r22, [%r17 + 0x0000] %asi
	.word 0xe6cfce60  ! 915: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r19
	mov	0x7d0, %r22
	.word 0xe6cca000  ! 917: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r19
	.word 0xe684e000  ! 918: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r19
	.word 0xe8f649e0  ! 919: STXA_R	stxa	%r20, [%r25 + %r0] 0x4f
	.word 0xe8a46000  ! 920: STWA_I	stwa	%r20, [%r17 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xe6c40400  ! 922: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r19
	.word 0x87802020  ! 923: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeca70e80  ! 924: STWA_R	stwa	%r22, [%r28 + %r0] 0x74
	.word 0xe0c78e60  ! 925: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r16
	.word 0xe08ca000  ! 926: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r16
	.word 0xe09c6000  ! 927: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r16
	mov	0x7c8, %r23
	.word 0x87802020  ! 929: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r26
	.word 0xe0bca000  ! 931: STDA_I	stda	%r16, [%r18 + 0x0000] %asi
	mov	0x58, %r24
	mov	0x50, %r17
	wr_tick_cmpr_0_11:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x95, %g2
	or	%g4, 0xbf, %g4
	or	%g6, 0xd5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe0ac4400  ! 935: STBA_R	stba	%r16, [%r17 + %r0] 0x20
	.word 0xe09ce000  ! 936: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r16
	mov	0x7e0, %r23
	.word 0xe0bca000  ! 938: STDA_I	stda	%r16, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 939: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x8780204f  ! 941: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe08ee000  ! 942: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r16
	.word 0xe0a66000  ! 943: STWA_I	stwa	%r16, [%r25 + 0x0000] %asi
	.word 0xe8c649e0  ! 944: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r20
	.word 0x87802020  ! 945: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea9ec9e0  ! 946: LDDA_R	ldda	[%r27, %r0] 0x4f, %r21
	.word 0xeacf0e40  ! 947: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r21
	.word 0xecb4c400  ! 948: STHA_R	stha	%r22, [%r19 + %r0] 0x20
	.word 0xe0c7ce40  ! 949: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r16
	wr_tick_cmpr_0_12:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x95, %g2
	or	%g4, 0x8e, %g4
	or	%g6, 0xae, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 951: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0afa000  ! 952: STBA_I	stba	%r16, [%r30 + 0x0000] %asi
	.word 0xe09fa000  ! 953: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r16
	mov	0x70, %r19
	.word 0xe0972000  ! 955: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r16
	mov	0x78, %r26
	.word 0xe0af6000  ! 957: STBA_I	stba	%r16, [%r29 + 0x0000] %asi
	.word 0xe0f72000  ! 958: STXA_I	stxa	%r16, [%r28 + 0x0000] %asi
	mov	0x7f8, %r21
	mov	0x3d0, %r20
	.word 0xe0a7e000  ! 961: STWA_I	stwa	%r16, [%r31 + 0x0000] %asi
	mov	0x18, %r26
	mov	0x68, %r17
	.word 0x87802020  ! 964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0bc6000  ! 965: STDA_I	stda	%r16, [%r17 + 0x0000] %asi
	.word 0xe0d46000  ! 966: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r16
	.word 0xe0878e40  ! 967: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r16
	.word 0xe0f4e000  ! 968: STXA_I	stxa	%r16, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 969: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r27
	.word 0x8780204f  ! 971: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 972: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0ad2000  ! 973: STBA_I	stba	%r16, [%r20 + 0x0000] %asi
	.word 0xe09d2000  ! 974: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r16
	.word 0xea8f8e40  ! 975: LDUBA_R	lduba	[%r30, %r0] 0x72, %r21
	.word 0xeaa40400  ! 976: STWA_R	stwa	%r21, [%r16 + %r0] 0x20
	.word 0xe0a7ce40  ! 977: STWA_R	stwa	%r16, [%r31 + %r0] 0x72
	mov	0x30, %r24
	.word 0x87802020  ! 979: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	.word 0x87802025  ! 981: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4d504a0  ! 982: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r18
	.word 0xe4f52000  ! 983: STXA_I	stxa	%r18, [%r20 + 0x0000] %asi
	.word 0xe4a5e000  ! 984: STWA_I	stwa	%r18, [%r23 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xe4a5a000  ! 986: STWA_I	stwa	%r18, [%r22 + 0x0000] %asi
	.word 0xe68fce80  ! 987: LDUBA_R	lduba	[%r31, %r0] 0x74, %r19
	mov	0x3f8, %r20
	.word 0xe8b48400  ! 989: STHA_R	stha	%r20, [%r18 + %r0] 0x20
	mov	0x70, %r17
	.word 0x87802073  ! 991: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 992: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r23
	.word 0xeedc4400  ! 994: LDXA_R	ldxa	[%r17, %r0] 0x20, %r23
	.word 0xeea52000  ! 995: STWA_I	stwa	%r23, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 996: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r26
	.word 0xee966000  ! 998: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r23
	mov	0x70, %r24
	mov	0x18, %r18
	.word 0xeeae6000  ! 1001: STBA_I	stba	%r23, [%r25 + 0x0000] %asi
	.word 0xeeaea000  ! 1002: STBA_I	stba	%r23, [%r26 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0x87802020  ! 1004: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeea4a000  ! 1005: STWA_I	stwa	%r23, [%r18 + 0x0000] %asi
	mov	0x0, %r18
	.word 0x87802020  ! 1007: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r24
	mov	0x18, %r24
	.word 0x8780204f  ! 1010: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r27
	mov	0x58, %r24
	.word 0xe0bc0400  ! 1013: STDA_R	stda	%r16, [%r16 + %r0] 0x20
	.word 0xe0ce6000  ! 1014: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r16
	.word 0xe0aea000  ! 1015: STBA_I	stba	%r16, [%r26 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xe0de2000  ! 1017: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r16
	mov	0x38, %r18
	.word 0x87802020  ! 1019: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaa6c9e0  ! 1020: STWA_R	stwa	%r21, [%r27 + %r0] 0x4f
	.word 0xe4c70e80  ! 1021: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r18
	mov	0x60, %r19
	.word 0xea9e89e0  ! 1023: LDDA_R	ldda	[%r26, %r0] 0x4f, %r21
	.word 0xec9fce80  ! 1024: LDDA_R	ldda	[%r31, %r0] 0x74, %r22
	mov	0x78, %r25
	.word 0xecbfce80  ! 1026: STDA_R	stda	%r22, [%r31 + %r0] 0x74
	.word 0xecc42000  ! 1027: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r22
	mov	0x3f8, %r21
	mov	0x60, %r16
	.word 0xec84a000  ! 1030: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r22
	mov	0x3f8, %r22
	.word 0xe09fce40  ! 1032: LDDA_R	ldda	[%r31, %r0] 0x72, %r16
	mov	0x30, %r27
	.word 0x87802072  ! 1034: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6f48400  ! 1035: STXA_R	stxa	%r19, [%r18 + %r0] 0x20
	.word 0xe2a70e40  ! 1036: STWA_R	stwa	%r17, [%r28 + %r0] 0x72
	.word 0xee8fce60  ! 1037: LDUBA_R	lduba	[%r31, %r0] 0x73, %r23
	.word 0xeccfce80  ! 1038: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r22
	mov	0x3d0, %r20
	.word 0xeaf7ce40  ! 1040: STXA_R	stxa	%r21, [%r31 + %r0] 0x72
	.word 0xe89dc4a0  ! 1041: LDDA_R	ldda	[%r23, %r0] 0x25, %r20
	.word 0xe8b7e000  ! 1042: STHA_I	stha	%r20, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1043: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xee878e60  ! 1044: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r23
	mov	0x58, %r25
	.word 0xeeb4e000  ! 1046: STHA_I	stha	%r23, [%r19 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xea9f0e40  ! 1048: LDDA_R	ldda	[%r28, %r0] 0x72, %r21
	.word 0xe48f8e80  ! 1049: LDUBA_R	lduba	[%r30, %r0] 0x74, %r18
	.word 0xe4aca000  ! 1050: STBA_I	stba	%r18, [%r18 + 0x0000] %asi
	.word 0xe4c46000  ! 1051: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r18
	.word 0x8780204f  ! 1052: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xea9e89e0  ! 1053: LDDA_R	ldda	[%r26, %r0] 0x4f, %r21
	.word 0xecc649e0  ! 1054: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r22
	.word 0xe2de49e0  ! 1055: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r17
	wr_tick_cmpr_0_13:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x84, %g2
	or	%g4, 0x8e, %g4
	or	%g6, 0xa6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7d8, %r23
	mov	0x50, %r24
	.word 0xe2aee000  ! 1059: STBA_I	stba	%r17, [%r27 + 0x0000] %asi
	mov	0x10, %r16
	mov	0x0, %r18
	.word 0xe2f6e000  ! 1062: STXA_I	stxa	%r17, [%r27 + 0x0000] %asi
	.word 0xe2f40400  ! 1063: STXA_R	stxa	%r17, [%r16 + %r0] 0x20
	.word 0xe2dee000  ! 1064: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r17
	mov	0x7d8, %r21
	.word 0xe296e000  ! 1066: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r17
	.word 0xe0d74e40  ! 1067: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r16
	.word 0x87802020  ! 1068: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r18
	.word 0xe0bca000  ! 1070: STDA_I	stda	%r16, [%r18 + 0x0000] %asi
	.word 0xe6f74e80  ! 1071: STXA_R	stxa	%r19, [%r29 + %r0] 0x74
	.word 0xe8b609e0  ! 1072: STHA_R	stha	%r20, [%r24 + %r0] 0x4f
	.word 0xe8cca000  ! 1073: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r20
	.word 0xe8c6c9e0  ! 1074: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r20
	mov	0x40, %r24
	.word 0xe4ae09e0  ! 1076: STBA_R	stba	%r18, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 1077: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8af0e80  ! 1078: STBA_R	stba	%r20, [%r28 + %r0] 0x74
	.word 0xe4848400  ! 1079: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r18
	.word 0x8780204f  ! 1080: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r24
	.word 0x87802020  ! 1082: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe49c6000  ! 1083: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r18
	.word 0xecc44400  ! 1084: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r22
	mov	0x18, %r16
	.word 0xecbce000  ! 1086: STDA_I	stda	%r22, [%r19 + 0x0000] %asi
	.word 0xeca42000  ! 1087: STWA_I	stwa	%r22, [%r16 + 0x0000] %asi
	.word 0xe0b584a0  ! 1088: STHA_R	stha	%r16, [%r22 + %r0] 0x25
	mov	0x70, %r26
	mov	0x8, %r19
	.word 0xe0f42000  ! 1091: STXA_I	stxa	%r16, [%r16 + 0x0000] %asi
	.word 0xe0bc4400  ! 1092: STDA_R	stda	%r16, [%r17 + %r0] 0x20
	mov	0x3c8, %r20
	.word 0xe6bfce80  ! 1094: STDA_R	stda	%r19, [%r31 + %r0] 0x74
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7e8, %r20
	.word 0xeaf4c400  ! 1097: STXA_R	stxa	%r21, [%r19 + %r0] 0x20
	mov	0x0, %r19
	.word 0xea9c8400  ! 1099: LDDA_R	ldda	[%r18, %r0] 0x20, %r21
	.word 0xeabc6000  ! 1100: STDA_I	stda	%r21, [%r17 + 0x0000] %asi
	.word 0xe2848400  ! 1101: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r17
	.word 0xee840400  ! 1102: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r23
	mov	0x3e0, %r20
	.word 0xe6d78e60  ! 1104: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r19
	.word 0xecc4c400  ! 1105: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r22
	.word 0xe69584a0  ! 1106: LDUHA_R	lduha	[%r22, %r0] 0x25, %r19
	.word 0xe6bca000  ! 1107: STDA_I	stda	%r19, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 1108: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r27
	.word 0xe8a44400  ! 1110: STWA_R	stwa	%r20, [%r17 + %r0] 0x20
	.word 0xeef70e60  ! 1111: STXA_R	stxa	%r23, [%r28 + %r0] 0x73
	.word 0xe69c0400  ! 1112: LDDA_R	ldda	[%r16, %r0] 0x20, %r19
	.word 0xe6dfa000  ! 1113: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r19
	.word 0xe0b40400  ! 1114: STHA_R	stha	%r16, [%r16 + %r0] 0x20
	mov	0x20, %r25
	mov	0x28, %r18
	.word 0xe6af0e60  ! 1117: STBA_R	stba	%r19, [%r28 + %r0] 0x73
	mov	0x28, %r27
	.word 0x87802020  ! 1119: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r19
	.word 0xe6842000  ! 1121: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r19
	.word 0xeac78e60  ! 1122: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r21
	.word 0xeaa4e000  ! 1123: STWA_I	stwa	%r21, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 1124: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeac52000  ! 1125: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r21
	.word 0xeaf5a000  ! 1126: STXA_I	stxa	%r21, [%r22 + 0x0000] %asi
	.word 0xeacde000  ! 1127: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r21
	.word 0xea8d2000  ! 1128: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r21
	.word 0x87802074  ! 1129: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeaafe000  ! 1130: STBA_I	stba	%r21, [%r31 + 0x0000] %asi
	.word 0xea8fa000  ! 1131: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r21
	.word 0xeadf2000  ! 1132: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r21
	.word 0x87802025  ! 1133: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2f544a0  ! 1134: STXA_R	stxa	%r17, [%r21 + %r0] 0x25
	.word 0xe2ad2000  ! 1135: STBA_I	stba	%r17, [%r20 + 0x0000] %asi
	.word 0xe2852000  ! 1136: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r17
	mov	0x7e8, %r20
	mov	0x48, %r27
	mov	0x8, %r16
	.word 0xe2bda000  ! 1140: STDA_I	stda	%r17, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 1141: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2bfa000  ! 1142: STDA_I	stda	%r17, [%r30 + 0x0000] %asi
	.word 0xe28f2000  ! 1143: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r17
	mov	0x48, %r16
	.word 0x87802020  ! 1145: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1146: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8f609e0  ! 1147: STXA_R	stxa	%r20, [%r24 + %r0] 0x4f
	.word 0xe89fe000  ! 1148: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r20
	mov	0x58, %r16
	.word 0xe8bf6000  ! 1150: STDA_I	stda	%r20, [%r29 + 0x0000] %asi
	.word 0xe8afe000  ! 1151: STBA_I	stba	%r20, [%r31 + 0x0000] %asi
	.word 0xe8af2000  ! 1152: STBA_I	stba	%r20, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1153: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xead74e40  ! 1154: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r21
	mov	0x48, %r27
	.word 0xe49fce40  ! 1156: LDDA_R	ldda	[%r31, %r0] 0x72, %r18
	wr_tick_cmpr_0_14:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe9, %g2
	or	%g4, 0xb7, %g4
	or	%g6, 0xe4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x40, %r16
	.word 0x8780204f  ! 1159: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2d78e40  ! 1160: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r17
	.word 0x87802025  ! 1161: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2bd2000  ! 1162: STDA_I	stda	%r17, [%r20 + 0x0000] %asi
	mov	0x70, %r18
	.word 0x87802073  ! 1164: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r23
	.word 0xe0b4c400  ! 1166: STHA_R	stha	%r16, [%r19 + %r0] 0x20
	.word 0xe0bf6000  ! 1167: STDA_I	stda	%r16, [%r29 + 0x0000] %asi
	mov	0x60, %r27
	.word 0x87802020  ! 1169: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	.word 0xe0f4a000  ! 1171: STXA_I	stxa	%r16, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1172: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a46000  ! 1173: STWA_I	stwa	%r16, [%r17 + 0x0000] %asi
	.word 0xe2af0e60  ! 1174: STBA_R	stba	%r17, [%r28 + %r0] 0x73
	.word 0xeeb44400  ! 1175: STHA_R	stha	%r23, [%r17 + %r0] 0x20
	mov	0x10, %r26
	.word 0xe2cc8400  ! 1177: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r17
	mov	0x3c0, %r21
	mov	0x8, %r19
	.word 0xecf70e60  ! 1180: STXA_R	stxa	%r22, [%r28 + %r0] 0x73
	.word 0xecbc2000  ! 1181: STDA_I	stda	%r22, [%r16 + 0x0000] %asi
	.word 0xecf46000  ! 1182: STXA_I	stxa	%r22, [%r17 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xe2cc8400  ! 1184: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r17
	.word 0xe2f42000  ! 1185: STXA_I	stxa	%r17, [%r16 + 0x0000] %asi
	mov	0x3e8, %r22
	mov	0x7e8, %r20
	.word 0xe2b46000  ! 1188: STHA_I	stha	%r17, [%r17 + 0x0000] %asi
	.word 0xe8c584a0  ! 1189: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r20
	.word 0xeaa584a0  ! 1190: STWA_R	stwa	%r21, [%r22 + %r0] 0x25
	.word 0xe0f48400  ! 1191: STXA_R	stxa	%r16, [%r18 + %r0] 0x20
	.word 0xeac78e60  ! 1192: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r21
	.word 0xeac46000  ! 1193: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r21
	mov	0x70, %r18
	.word 0xec8fce40  ! 1195: LDUBA_R	lduba	[%r31, %r0] 0x72, %r22
	.word 0xecbc2000  ! 1196: STDA_I	stda	%r22, [%r16 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xe2970e60  ! 1198: LDUHA_R	lduha	[%r28, %r0] 0x73, %r17
	mov	0x7f8, %r21
	.word 0xe2cca000  ! 1200: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r17
	.word 0xe2f4a000  ! 1201: STXA_I	stxa	%r17, [%r18 + 0x0000] %asi
	.word 0xe4ac4400  ! 1202: STBA_R	stba	%r18, [%r17 + %r0] 0x20
	.word 0xe4cca000  ! 1203: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r18
	.word 0xe89544a0  ! 1204: LDUHA_R	lduha	[%r21, %r0] 0x25, %r20
	mov	0x78, %r18
	.word 0xe886c9e0  ! 1206: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r20
	.word 0xe89c2000  ! 1207: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r20
	.word 0xe8df0e40  ! 1208: LDXA_R	ldxa	[%r28, %r0] 0x72, %r20
	mov	0x7c0, %r22
	mov	0x8, %r19
	mov	0x7c8, %r22
	.word 0xe8bca000  ! 1212: STDA_I	stda	%r20, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1213: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	.word 0xe8ac2000  ! 1215: STBA_I	stba	%r20, [%r16 + 0x0000] %asi
	.word 0xe8cc6000  ! 1216: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r20
	mov	0x8, %r16
	.word 0xe8aca000  ! 1218: STBA_I	stba	%r20, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 1219: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeabe09e0  ! 1220: STDA_R	stda	%r21, [%r24 + %r0] 0x4f
	.word 0xe8a70e40  ! 1221: STWA_R	stwa	%r20, [%r28 + %r0] 0x72
	mov	0x18, %r24
	.word 0xe09e09e0  ! 1223: LDDA_R	ldda	[%r24, %r0] 0x4f, %r16
	mov	0x7e8, %r20
	mov	0x7e8, %r21
	.word 0xe0ae2000  ! 1226: STBA_I	stba	%r16, [%r24 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xe0a6a000  ! 1228: STWA_I	stwa	%r16, [%r26 + 0x0000] %asi
	.word 0xeacf8e80  ! 1229: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r21
	.word 0xeca74e60  ! 1230: STWA_R	stwa	%r22, [%r29 + %r0] 0x73
	.word 0xeaa70e40  ! 1231: STWA_R	stwa	%r21, [%r28 + %r0] 0x72
	.word 0xe8b609e0  ! 1232: STHA_R	stha	%r20, [%r24 + %r0] 0x4f
	.word 0xe8c6a000  ! 1233: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r20
	.word 0xe8f62000  ! 1234: STXA_I	stxa	%r20, [%r24 + 0x0000] %asi
	.word 0xe2b40400  ! 1235: STHA_R	stha	%r17, [%r16 + %r0] 0x20
	.word 0xe2dea000  ! 1236: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r17
	mov	0x20, %r19
	mov	0x78, %r17
	.word 0xecd40400  ! 1239: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r22
	.word 0xecaea000  ! 1240: STBA_I	stba	%r22, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 1241: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r20
	.word 0xec96e000  ! 1243: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r22
	.word 0x87802072  ! 1244: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xec8fa000  ! 1245: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r22
	.word 0xeebf0e40  ! 1246: STDA_R	stda	%r23, [%r28 + %r0] 0x72
	.word 0xeadd84a0  ! 1247: LDXA_R	ldxa	[%r22, %r0] 0x25, %r21
	.word 0x87802074  ! 1248: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1249: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6844400  ! 1250: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r19
	.word 0x87802020  ! 1251: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe69c2000  ! 1252: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r19
	.word 0xe694a000  ! 1253: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r19
	.word 0xe4cf4e40  ! 1254: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r18
	mov	0x50, %r19
	.word 0xe48c2000  ! 1256: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r18
	.word 0xe8f74e60  ! 1257: STXA_R	stxa	%r20, [%r29 + %r0] 0x73
	.word 0xe88ca000  ! 1258: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r20
	.word 0xe8aca000  ! 1259: STBA_I	stba	%r20, [%r18 + 0x0000] %asi
	.word 0xeaccc400  ! 1260: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r21
	.word 0xe6b44400  ! 1261: STHA_R	stha	%r19, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 1262: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6aee000  ! 1263: STBA_I	stba	%r19, [%r27 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xea8c8400  ! 1265: LDUBA_R	lduba	[%r18, %r0] 0x20, %r21
	mov	0x58, %r16
	.word 0xea866000  ! 1267: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r21
	.word 0xeac62000  ! 1268: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r21
	ta	T_CHANGE_HPRIV	! macro
	.word 0xeabe2000  ! 1270: STDA_I	stda	%r21, [%r24 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xeaf7ce60  ! 1272: STXA_R	stxa	%r21, [%r31 + %r0] 0x73
	.word 0xe2b504a0  ! 1273: STHA_R	stha	%r17, [%r20 + %r0] 0x25
	.word 0xe69c8400  ! 1274: LDDA_R	ldda	[%r18, %r0] 0x20, %r19
	.word 0xe4af4e60  ! 1275: STBA_R	stba	%r18, [%r29 + %r0] 0x73
	mov	0x7e0, %r23
	.word 0xe4a62000  ! 1277: STWA_I	stwa	%r18, [%r24 + 0x0000] %asi
	.word 0xe6c4c400  ! 1278: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r19
	.word 0xeede49e0  ! 1279: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r23
	.word 0xeeb62000  ! 1280: STHA_I	stha	%r23, [%r24 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xeef6e000  ! 1282: STXA_I	stxa	%r23, [%r27 + 0x0000] %asi
	.word 0xe6bfce60  ! 1283: STDA_R	stda	%r19, [%r31 + %r0] 0x73
	mov	0x3f8, %r21
	mov	0x3f8, %r23
	mov	0x3c8, %r23
	.word 0xe69ee000  ! 1287: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r19
	.word 0x87802073  ! 1288: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xead74e40  ! 1289: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r21
	mov	0x10, %r25
	.word 0xeaa76000  ! 1291: STWA_I	stwa	%r21, [%r29 + 0x0000] %asi
	.word 0xeed7ce40  ! 1292: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r23
	.word 0x87802025  ! 1293: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r25
	.word 0xeab78e40  ! 1295: STHA_R	stha	%r21, [%r30 + %r0] 0x72
	.word 0xeaf5e000  ! 1296: STXA_I	stxa	%r21, [%r23 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xeadde000  ! 1298: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r21
	.word 0xeab56000  ! 1299: STHA_I	stha	%r21, [%r21 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0x87802074  ! 1301: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xecd78e40  ! 1302: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r22
	.word 0xe28504a0  ! 1303: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r17
	mov	0x8, %r17
	.word 0xe2f7e000  ! 1305: STXA_I	stxa	%r17, [%r31 + 0x0000] %asi
	mov	0x7f8, %r23
	mov	0x8, %r24
	mov	0x48, %r16
	.word 0xe2a76000  ! 1309: STWA_I	stwa	%r17, [%r29 + 0x0000] %asi
	mov	0x0, %r17
	mov	0x3d8, %r22
	.word 0xe4a40400  ! 1312: STWA_R	stwa	%r18, [%r16 + %r0] 0x20
	mov	0x7d8, %r21
	.word 0xe48f2000  ! 1314: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r18
	.word 0xe4d584a0  ! 1315: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r18
	.word 0xe2d74e40  ! 1316: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r17
	.word 0xe2c72000  ! 1317: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r17
	.word 0xe2c4c400  ! 1318: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r17
	.word 0xe2dfa000  ! 1319: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r17
	.word 0xe2d76000  ! 1320: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r17
	.word 0x87802074  ! 1321: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r26
	.word 0xeaf78e40  ! 1323: STXA_R	stxa	%r21, [%r30 + %r0] 0x72
	.word 0xe2af0e80  ! 1324: STBA_R	stba	%r17, [%r28 + %r0] 0x74
	.word 0xeeac8400  ! 1325: STBA_R	stba	%r23, [%r18 + %r0] 0x20
	.word 0xeebfe000  ! 1326: STDA_I	stda	%r23, [%r31 + 0x0000] %asi
	mov	0x58, %r18
	mov	0x10, %r24
	.word 0xee87e000  ! 1329: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r23
	.word 0xeebf0e60  ! 1330: STDA_R	stda	%r23, [%r28 + %r0] 0x73
	.word 0xee8fe000  ! 1331: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r23
	.word 0xeeaf2000  ! 1332: STBA_I	stba	%r23, [%r28 + 0x0000] %asi
	.word 0xeeaf6000  ! 1333: STBA_I	stba	%r23, [%r29 + 0x0000] %asi
	.word 0xe0cec9e0  ! 1334: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r16
	.word 0xe0bfa000  ! 1335: STDA_I	stda	%r16, [%r30 + 0x0000] %asi
	.word 0xe0976000  ! 1336: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r16
	.word 0xe0a7e000  ! 1337: STWA_I	stwa	%r16, [%r31 + 0x0000] %asi
	.word 0xe8a48400  ! 1338: STWA_R	stwa	%r20, [%r18 + %r0] 0x20
	mov	0x78, %r24
	.word 0xeaaf8e80  ! 1340: STBA_R	stba	%r21, [%r30 + %r0] 0x74
	.word 0xe2a40400  ! 1341: STWA_R	stwa	%r17, [%r16 + %r0] 0x20
	.word 0xeaf78e60  ! 1342: STXA_R	stxa	%r21, [%r30 + %r0] 0x73
	.word 0xea8f6000  ! 1343: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r21
	.word 0xead40400  ! 1344: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r21
	.word 0xe2af4e40  ! 1345: STBA_R	stba	%r17, [%r29 + %r0] 0x72
	.word 0xe08f4e60  ! 1346: LDUBA_R	lduba	[%r29, %r0] 0x73, %r16
	.word 0xe0874e60  ! 1347: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r16
	.word 0x87802020  ! 1348: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6d4c400  ! 1349: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r19
	mov	0x3c0, %r22
	.word 0xe6cc2000  ! 1351: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r19
	mov	0x7c0, %r20
	mov	0x28, %r26
	.word 0xe6a42000  ! 1354: STWA_I	stwa	%r19, [%r16 + 0x0000] %asi
	.word 0xe6b4a000  ! 1355: STHA_I	stha	%r19, [%r18 + 0x0000] %asi
	.word 0xe6946000  ! 1356: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r19
	.word 0x87802025  ! 1357: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeaaf0e80  ! 1358: STBA_R	stba	%r21, [%r28 + %r0] 0x74
	.word 0xeaa5e000  ! 1359: STWA_I	stwa	%r21, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 1360: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r23
	.word 0x87802020  ! 1362: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xead42000  ! 1363: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r21
	.word 0x87802073  ! 1364: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xead7e000  ! 1365: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r21
	mov	0x7e0, %r23
	.word 0x87802020  ! 1367: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaa4a000  ! 1368: STWA_I	stwa	%r21, [%r18 + 0x0000] %asi
	.word 0xe4f78e60  ! 1369: STXA_R	stxa	%r18, [%r30 + %r0] 0x73
	.word 0xe4942000  ! 1370: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r18
	.word 0x87802072  ! 1371: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 1372: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4d5a000  ! 1373: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r18
	.word 0xe0d74e60  ! 1374: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r16
	mov	0x78, %r26
	mov	0x28, %r26
	mov	0x7e8, %r22
	.word 0xe0bda000  ! 1378: STDA_I	stda	%r16, [%r22 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xe0bd6000  ! 1380: STDA_I	stda	%r16, [%r21 + 0x0000] %asi
	.word 0xeaaf0e60  ! 1381: STBA_R	stba	%r21, [%r28 + %r0] 0x73
	.word 0xe8ac0400  ! 1382: STBA_R	stba	%r20, [%r16 + %r0] 0x20
	.word 0xe8ade000  ! 1383: STBA_I	stba	%r20, [%r23 + 0x0000] %asi
	.word 0xe8d5e000  ! 1384: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r20
	.word 0xe885e000  ! 1385: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r20
	.word 0xe8a52000  ! 1386: STWA_I	stwa	%r20, [%r20 + 0x0000] %asi
	.word 0xea8584a0  ! 1387: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r21
	.word 0xea856000  ! 1388: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r21
	.word 0xeab52000  ! 1389: STHA_I	stha	%r21, [%r20 + 0x0000] %asi
	mov	0x0, %r16
	mov	0x50, %r27
	.word 0xe4970e40  ! 1392: LDUHA_R	lduha	[%r28, %r0] 0x72, %r18
	.word 0xe4b5a000  ! 1393: STHA_I	stha	%r18, [%r22 + 0x0000] %asi
	.word 0xe4dd6000  ! 1394: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r18
	mov	0x3e8, %r22
	.word 0xe4c52000  ! 1396: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r18
	.word 0xe4ad2000  ! 1397: STBA_I	stba	%r18, [%r20 + 0x0000] %asi
	.word 0xeea504a0  ! 1398: STWA_R	stwa	%r23, [%r20 + %r0] 0x25
	.word 0xe8f4c400  ! 1399: STXA_R	stxa	%r20, [%r19 + %r0] 0x20
	mov	0x7e0, %r21
	.word 0xe88d04a0  ! 1401: LDUBA_R	lduba	[%r20, %r0] 0x25, %r20
	.word 0xe89da000  ! 1402: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r20
	.word 0xe89d6000  ! 1403: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r20
	.word 0xe8dd2000  ! 1404: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r20
	.word 0xe08689e0  ! 1405: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r16
	.word 0xe4f584a0  ! 1406: STXA_R	stxa	%r18, [%r22 + %r0] 0x25
	.word 0xe08d04a0  ! 1407: LDUBA_R	lduba	[%r20, %r0] 0x25, %r16
	.word 0xe0ad6000  ! 1408: STBA_I	stba	%r16, [%r21 + 0x0000] %asi
	mov	0x58, %r27
	.word 0xeef4c400  ! 1410: STXA_R	stxa	%r23, [%r19 + %r0] 0x20
	.word 0xeab78e60  ! 1411: STHA_R	stha	%r21, [%r30 + %r0] 0x73
	.word 0xea8d2000  ! 1412: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r21
	.word 0xec874e80  ! 1413: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r22
	mov	0x78, %r27
	.word 0x87802072  ! 1415: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r17
	.word 0xe4c5c4a0  ! 1417: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r18
	mov	0x10, %r16
	.word 0xeaf544a0  ! 1419: STXA_R	stxa	%r21, [%r21 + %r0] 0x25
	.word 0xead76000  ! 1420: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r21
	mov	0x78, %r24
	.word 0xead7e000  ! 1422: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r21
	.word 0x87802074  ! 1423: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeabf6000  ! 1424: STDA_I	stda	%r21, [%r29 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xeaf72000  ! 1426: STXA_I	stxa	%r21, [%r28 + 0x0000] %asi
	mov	0x48, %r18
	mov	0x7e8, %r22
	.word 0xeaa7a000  ! 1429: STWA_I	stwa	%r21, [%r30 + 0x0000] %asi
	.word 0xe2ad04a0  ! 1430: STBA_R	stba	%r17, [%r20 + %r0] 0x25
	.word 0xe2b689e0  ! 1431: STHA_R	stha	%r17, [%r26 + %r0] 0x4f
	.word 0xe29f6000  ! 1432: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r17
	.word 0xeedfce60  ! 1433: LDXA_R	ldxa	[%r31, %r0] 0x73, %r23
	.word 0xeacfce60  ! 1434: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r21
	.word 0xea972000  ! 1435: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r21
	.word 0xeadfa000  ! 1436: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r21
	.word 0xea97e000  ! 1437: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r21
	mov	0x58, %r25
	mov	0x40, %r26
	.word 0xeadf6000  ! 1440: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r21
	.word 0x8780204f  ! 1441: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r22
	mov	0x8, %r25
	mov	0x60, %r27
	.word 0xe8b504a0  ! 1445: STHA_R	stha	%r20, [%r20 + %r0] 0x25
	.word 0xea8f4e60  ! 1446: LDUBA_R	lduba	[%r29, %r0] 0x73, %r21
	.word 0xe4f78e80  ! 1447: STXA_R	stxa	%r18, [%r30 + %r0] 0x74
	.word 0xe6af8e80  ! 1448: STBA_R	stba	%r19, [%r30 + %r0] 0x74
	.word 0xe686e000  ! 1449: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r19
	.word 0x87802072  ! 1450: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r19
	.word 0x87802020  ! 1452: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe694e000  ! 1453: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r19
	mov	0x68, %r27
	.word 0xe6a4a000  ! 1455: STWA_I	stwa	%r19, [%r18 + 0x0000] %asi
	.word 0xe6cce000  ! 1456: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r19
	mov	0x28, %r24
	mov	0x48, %r19
	.word 0xe6a46000  ! 1459: STWA_I	stwa	%r19, [%r17 + 0x0000] %asi
	mov	0x38, %r25
	mov	0x3e0, %r22
	.word 0xeadcc400  ! 1462: LDXA_R	ldxa	[%r19, %r0] 0x20, %r21
	.word 0xe48f8e40  ! 1463: LDUBA_R	lduba	[%r30, %r0] 0x72, %r18
	.word 0xe4bce000  ! 1464: STDA_I	stda	%r18, [%r19 + 0x0000] %asi
	.word 0xe0a4c400  ! 1465: STWA_R	stwa	%r16, [%r19 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xe0a4a000  ! 1467: STWA_I	stwa	%r16, [%r18 + 0x0000] %asi
	.word 0xe4ce89e0  ! 1468: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r18
	.word 0xecf649e0  ! 1469: STXA_R	stxa	%r22, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 1470: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xecb76000  ! 1471: STHA_I	stha	%r22, [%r29 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xe8a584a0  ! 1473: STWA_R	stwa	%r20, [%r22 + %r0] 0x25
	.word 0xe89f2000  ! 1474: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r20
	.word 0x87802073  ! 1475: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeeae89e0  ! 1476: STBA_R	stba	%r23, [%r26 + %r0] 0x4f
	.word 0xeed5c4a0  ! 1477: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r23
	.word 0xe6ad44a0  ! 1478: STBA_R	stba	%r19, [%r21 + %r0] 0x25
	.word 0xecf7ce80  ! 1479: STXA_R	stxa	%r22, [%r31 + %r0] 0x74
	.word 0xecb76000  ! 1480: STHA_I	stha	%r22, [%r29 + 0x0000] %asi
	.word 0xe8f78e60  ! 1481: STXA_R	stxa	%r20, [%r30 + %r0] 0x73
	mov	0x78, %r25
	mov	0x0, %r19
	.word 0xe8d76000  ! 1484: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r20
	mov	0x0, %r24
	mov	0x48, %r25
	.word 0xe6978e40  ! 1487: LDUHA_R	lduha	[%r30, %r0] 0x72, %r19
	mov	0x18, %r17
	.word 0xe6afa000  ! 1489: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	.word 0xe6df2000  ! 1490: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r19
	.word 0xe0b78e60  ! 1491: STHA_R	stha	%r16, [%r30 + %r0] 0x73
	mov	0x10, %r25
	.word 0xe09f2000  ! 1493: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r16
	.word 0xeace89e0  ! 1494: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r21
	.word 0xeaaf2000  ! 1495: STBA_I	stba	%r21, [%r28 + 0x0000] %asi
	.word 0xecb74e80  ! 1496: STHA_R	stha	%r22, [%r29 + %r0] 0x74
	.word 0xec9fa000  ! 1497: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r22
	.word 0xe6dc0400  ! 1498: LDXA_R	ldxa	[%r16, %r0] 0x20, %r19
	.word 0x87802073  ! 1499: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1500: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4bcc400  ! 1501: STDA_R	stda	%r18, [%r19 + %r0] 0x20
	.word 0xe49fe000  ! 1502: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r18
	.word 0xead649e0  ! 1503: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r21
	mov	0x8, %r19
	.word 0x87802025  ! 1505: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6a74e60  ! 1506: STWA_R	stwa	%r19, [%r29 + %r0] 0x73
	.word 0xe6bd6000  ! 1507: STDA_I	stda	%r19, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 1508: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r18
	mov	0x20, %r17
	.word 0xe8bdc4a0  ! 1511: STDA_R	stda	%r20, [%r23 + %r0] 0x25
	.word 0xe8aee000  ! 1512: STBA_I	stba	%r20, [%r27 + 0x0000] %asi
	.word 0xe8862000  ! 1513: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r20
	.word 0x87802072  ! 1514: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1515: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8aec9e0  ! 1516: STBA_R	stba	%r20, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1517: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8d4a000  ! 1518: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r20
	.word 0x87802025  ! 1519: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8cde000  ! 1520: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r20
	mov	0x3d8, %r20
	.word 0xe8c5a000  ! 1522: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r20
	.word 0xe88d2000  ! 1523: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r20
	.word 0xe8f7ce80  ! 1524: STXA_R	stxa	%r20, [%r31 + %r0] 0x74
	.word 0xee8c0400  ! 1525: LDUBA_R	lduba	[%r16, %r0] 0x20, %r23
	mov	0x78, %r27
	.word 0xeebd2000  ! 1527: STDA_I	stda	%r23, [%r20 + 0x0000] %asi
	.word 0xe4d70e80  ! 1528: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r18
	mov	0x48, %r24
	.word 0xe484c400  ! 1530: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r18
	.word 0xe4a5e000  ! 1531: STWA_I	stwa	%r18, [%r23 + 0x0000] %asi
	.word 0xeebf4e40  ! 1532: STDA_R	stda	%r23, [%r29 + %r0] 0x72
	.word 0x87802025  ! 1533: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xee9da000  ! 1534: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r23
	.word 0xeeb5e000  ! 1535: STHA_I	stha	%r23, [%r23 + 0x0000] %asi
	wr_tick_cmpr_0_15:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdc, %g2
	or	%g4, 0xd7, %g4
	or	%g6, 0xfc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeaf7ce80  ! 1537: STXA_R	stxa	%r21, [%r31 + %r0] 0x74
	.word 0xe095c4a0  ! 1538: LDUHA_R	lduha	[%r23, %r0] 0x25, %r16
	ta	T_CHANGE_HPRIV	! macro
	.word 0xec9f0e80  ! 1540: LDDA_R	ldda	[%r28, %r0] 0x74, %r22
	.word 0xec9de000  ! 1541: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r22
	mov	0x50, %r27
	mov	0x68, %r16
	.word 0xecb56000  ! 1544: STHA_I	stha	%r22, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 1545: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 1546: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeeaec9e0  ! 1547: STBA_R	stba	%r23, [%r27 + %r0] 0x4f
	.word 0xee8da000  ! 1548: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r23
	.word 0xeef44400  ! 1549: STXA_R	stxa	%r23, [%r17 + %r0] 0x20
	.word 0xeed52000  ! 1550: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r23
	.word 0xeed5e000  ! 1551: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r23
	.word 0xeeade000  ! 1552: STBA_I	stba	%r23, [%r23 + 0x0000] %asi
	.word 0xe2a48400  ! 1553: STWA_R	stwa	%r17, [%r18 + %r0] 0x20
	.word 0xe2d52000  ! 1554: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r17
	.word 0xe4bf0e60  ! 1555: STDA_R	stda	%r18, [%r28 + %r0] 0x73
	.word 0xeecfce80  ! 1556: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r23
	.word 0xeaa70e40  ! 1557: STWA_R	stwa	%r21, [%r28 + %r0] 0x72
	.word 0xeabd6000  ! 1558: STDA_I	stda	%r21, [%r21 + 0x0000] %asi
	.word 0xe6bc0400  ! 1559: STDA_R	stda	%r19, [%r16 + %r0] 0x20
	.word 0xe6bdc4a0  ! 1560: STDA_R	stda	%r19, [%r23 + %r0] 0x25
	.word 0xeeb6c9e0  ! 1561: STHA_R	stha	%r23, [%r27 + %r0] 0x4f
	.word 0xe29f8e60  ! 1562: LDDA_R	ldda	[%r30, %r0] 0x73, %r17
	.word 0x87802074  ! 1563: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeabfce40  ! 1564: STDA_R	stda	%r21, [%r31 + %r0] 0x72
	.word 0xeaf544a0  ! 1565: STXA_R	stxa	%r21, [%r21 + %r0] 0x25
	.word 0xe0c48400  ! 1566: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r16
	.word 0x87802020  ! 1567: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1568: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8c544a0  ! 1569: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r20
	.word 0xeabc4400  ! 1570: STDA_R	stda	%r21, [%r17 + %r0] 0x20
	.word 0xe0c78e80  ! 1571: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r16
	.word 0xeeadc4a0  ! 1572: STBA_R	stba	%r23, [%r23 + %r0] 0x25
	.word 0x87802074  ! 1573: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4cc8400  ! 1574: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r18
	.word 0xe4bf2000  ! 1575: STDA_I	stda	%r18, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1576: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r25
	.word 0xeeacc400  ! 1578: STBA_R	stba	%r23, [%r19 + %r0] 0x20
	mov	0x8, %r27
	.word 0xeea74e60  ! 1580: STWA_R	stwa	%r23, [%r29 + %r0] 0x73
	.word 0x87802072  ! 1581: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeeb7e000  ! 1582: STHA_I	stha	%r23, [%r31 + 0x0000] %asi
	mov	0x78, %r16
	mov	0x58, %r18
	mov	0x78, %r27
	.word 0xe2ce09e0  ! 1586: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r17
	.word 0xe284c400  ! 1587: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r17
	mov	0x18, %r18
	.word 0xe2af2000  ! 1589: STBA_I	stba	%r17, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1590: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r26
	.word 0xe4a78e60  ! 1592: STWA_R	stwa	%r18, [%r30 + %r0] 0x73
	.word 0x87802025  ! 1593: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecd70e40  ! 1594: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r22
	.word 0x8780204f  ! 1595: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xec862000  ! 1596: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r22
	.word 0xe4dfce60  ! 1597: LDXA_R	ldxa	[%r31, %r0] 0x73, %r18
	.word 0xe4a62000  ! 1598: STWA_I	stwa	%r18, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 1599: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1600: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4a46000  ! 1601: STWA_I	stwa	%r18, [%r17 + 0x0000] %asi
	.word 0xe6a609e0  ! 1602: STWA_R	stwa	%r19, [%r24 + %r0] 0x4f
	.word 0xee944400  ! 1603: LDUHA_R	lduha	[%r17, %r0] 0x20, %r23
	.word 0x87802074  ! 1604: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4ac4400  ! 1605: STBA_R	stba	%r18, [%r17 + %r0] 0x20
	.word 0xe684c400  ! 1606: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r19
	.word 0xe6cfa000  ! 1607: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r19
	mov	0x7d8, %r22
	wr_tick_cmpr_0_16:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xcf, %g2
	or	%g4, 0xd1, %g4
	or	%g6, 0xfe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeca78e60  ! 1610: STWA_R	stwa	%r22, [%r30 + %r0] 0x73
	.word 0xec8fa000  ! 1611: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r22
	.word 0xe4a6c9e0  ! 1612: STWA_R	stwa	%r18, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 1613: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r16
	.word 0xe6b5c4a0  ! 1615: STHA_R	stha	%r19, [%r23 + %r0] 0x25
	.word 0x87802072  ! 1616: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1617: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2a4c400  ! 1618: STWA_R	stwa	%r17, [%r19 + %r0] 0x20
	mov	0x30, %r17
	mov	0x7e0, %r22
	mov	0x10, %r26
	.word 0xe294a000  ! 1622: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r17
	.word 0x8780204f  ! 1623: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6870e60  ! 1624: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r19
	.word 0xee9f4e40  ! 1625: LDDA_R	ldda	[%r29, %r0] 0x72, %r23
	mov	0x30, %r19
	.word 0x87802073  ! 1627: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeeb76000  ! 1628: STHA_I	stha	%r23, [%r29 + 0x0000] %asi
	.word 0xe2974e60  ! 1629: LDUHA_R	lduha	[%r29, %r0] 0x73, %r17
	.word 0x87802073  ! 1630: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeec40400  ! 1631: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r23
	.word 0x8780204f  ! 1632: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeeb6a000  ! 1633: STHA_I	stha	%r23, [%r26 + 0x0000] %asi
	.word 0xeecee000  ! 1634: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r23
	.word 0xeef66000  ! 1635: STXA_I	stxa	%r23, [%r25 + 0x0000] %asi
	.word 0xee862000  ! 1636: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r23
	.word 0xee866000  ! 1637: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r23
	.word 0xeece2000  ! 1638: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r23
	.word 0xe28ec9e0  ! 1639: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r17
	.word 0xe2bee000  ! 1640: STDA_I	stda	%r17, [%r27 + 0x0000] %asi
	.word 0xe2b6e000  ! 1641: STHA_I	stha	%r17, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 1642: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r19
	.word 0xe09ec9e0  ! 1644: LDDA_R	ldda	[%r27, %r0] 0x4f, %r16
	.word 0xe4c544a0  ! 1645: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r18
	.word 0xe4dce000  ! 1646: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r18
	.word 0x87802072  ! 1647: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8f74e80  ! 1648: STXA_R	stxa	%r20, [%r29 + %r0] 0x74
	.word 0x87802025  ! 1649: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1650: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8bc6000  ! 1651: STDA_I	stda	%r20, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 1652: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8b7e000  ! 1653: STHA_I	stha	%r20, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 1654: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1655: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r23
	mov	0x8, %r24
	.word 0xe49c0400  ! 1658: LDDA_R	ldda	[%r16, %r0] 0x20, %r18
	.word 0xe49de000  ! 1659: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r18
	.word 0xe2f649e0  ! 1660: STXA_R	stxa	%r17, [%r25 + %r0] 0x4f
	.word 0xe28c0400  ! 1661: LDUBA_R	lduba	[%r16, %r0] 0x20, %r17
	.word 0xe8bf0e60  ! 1662: STDA_R	stda	%r20, [%r28 + %r0] 0x73
	mov	0x3c0, %r23
	.word 0xec948400  ! 1664: LDUHA_R	lduha	[%r18, %r0] 0x20, %r22
	mov	0x58, %r19
	.word 0xeca52000  ! 1666: STWA_I	stwa	%r22, [%r20 + 0x0000] %asi
	.word 0xecbda000  ! 1667: STDA_I	stda	%r22, [%r22 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xecd70e80  ! 1669: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r22
	.word 0xe2cf4e40  ! 1670: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r17
	mov	0x7e8, %r22
	mov	0x18, %r18
	mov	0x28, %r19
	.word 0xe2ada000  ! 1674: STBA_I	stba	%r17, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 1675: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 1676: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4cfce40  ! 1677: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r18
	.word 0xe4c5a000  ! 1678: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r18
	.word 0xe4a5a000  ! 1679: STWA_I	stwa	%r18, [%r22 + 0x0000] %asi
	.word 0xe2970e60  ! 1680: LDUHA_R	lduha	[%r28, %r0] 0x73, %r17
	mov	0x3e0, %r22
	mov	0x70, %r19
	.word 0xe8b689e0  ! 1683: STHA_R	stha	%r20, [%r26 + %r0] 0x4f
	.word 0xe8d5e000  ! 1684: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r20
	.word 0xecc48400  ! 1685: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r22
	mov	0x10, %r27
	.word 0xe28f0e40  ! 1687: LDUBA_R	lduba	[%r28, %r0] 0x72, %r17
	.word 0xe4af0e60  ! 1688: STBA_R	stba	%r18, [%r28 + %r0] 0x73
	mov	0x20, %r26
	mov	0x3c8, %r22
	.word 0xe4c56000  ! 1691: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r18
	mov	0x8, %r18
	mov	0x48, %r18
	.word 0x87802025  ! 1694: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r23
	.word 0xe4bfce40  ! 1696: STDA_R	stda	%r18, [%r31 + %r0] 0x72
	mov	0x7d0, %r22
	.word 0xe4ada000  ! 1698: STBA_I	stba	%r18, [%r22 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xee9649e0  ! 1700: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r23
	.word 0xeedde000  ! 1701: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r23
	wr_tick_cmpr_0_17:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfd, %g2
	or	%g4, 0xd9, %g4
	or	%g6, 0x9c, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeeb7ce60  ! 1703: STHA_R	stha	%r23, [%r31 + %r0] 0x73
	.word 0xee9de000  ! 1704: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r23
	mov	0x28, %r17
	mov	0x7f0, %r21
	mov	0x68, %r19
	.word 0x87802073  ! 1708: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeaf6c9e0  ! 1709: STXA_R	stxa	%r21, [%r27 + %r0] 0x4f
	.word 0xe08f8e80  ! 1710: LDUBA_R	lduba	[%r30, %r0] 0x74, %r16
	mov	0x10, %r27
	.word 0xe6af4e60  ! 1712: STBA_R	stba	%r19, [%r29 + %r0] 0x73
	.word 0x87802072  ! 1713: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r19
	.word 0xe6a76000  ! 1715: STWA_I	stwa	%r19, [%r29 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xe6b72000  ! 1717: STHA_I	stha	%r19, [%r28 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xeadc4400  ! 1719: LDXA_R	ldxa	[%r17, %r0] 0x20, %r21
	.word 0x87802074  ! 1720: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r18
	.word 0xe0a48400  ! 1722: STWA_R	stwa	%r16, [%r18 + %r0] 0x20
	.word 0xe0c7e000  ! 1723: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r16
	.word 0x8780204f  ! 1724: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xee948400  ! 1725: LDUHA_R	lduha	[%r18, %r0] 0x20, %r23
	.word 0x87802020  ! 1726: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0dfce40  ! 1727: LDXA_R	ldxa	[%r31, %r0] 0x72, %r16
	mov	0x20, %r19
	.word 0x87802025  ! 1729: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0cd2000  ! 1730: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r16
	.word 0xec874e40  ! 1731: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r22
	wr_tick_cmpr_0_18:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd6, %g2
	or	%g4, 0xf1, %g4
	or	%g6, 0x8d, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe6d7ce40  ! 1733: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r19
	.word 0xec8f4e80  ! 1734: LDUBA_R	lduba	[%r29, %r0] 0x74, %r22
	.word 0xecdd2000  ! 1735: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r22
	.word 0xe884c400  ! 1736: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r20
	mov	0x50, %r19
	.word 0x87802072  ! 1738: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8f76000  ! 1739: STXA_I	stxa	%r20, [%r29 + 0x0000] %asi
	.word 0xe4dc4400  ! 1740: LDXA_R	ldxa	[%r17, %r0] 0x20, %r18
	.word 0xe2840400  ! 1741: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r17
	.word 0xe6d5c4a0  ! 1742: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r19
	.word 0xe4cd84a0  ! 1743: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r18
	.word 0xe4bfe000  ! 1744: STDA_I	stda	%r18, [%r31 + 0x0000] %asi
	.word 0xe2a689e0  ! 1745: STWA_R	stwa	%r17, [%r26 + %r0] 0x4f
	.word 0xe4bd04a0  ! 1746: STDA_R	stda	%r18, [%r20 + %r0] 0x25
	.word 0xe097ce40  ! 1747: LDUHA_R	lduha	[%r31, %r0] 0x72, %r16
	.word 0x87802025  ! 1748: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f0, %r21
	.word 0xea870e40  ! 1750: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r21
	mov	0x30, %r18
	mov	0x18, %r26
	mov	0x48, %r27
	.word 0xe29cc400  ! 1754: LDDA_R	ldda	[%r19, %r0] 0x20, %r17
	.word 0xe6a78e60  ! 1755: STWA_R	stwa	%r19, [%r30 + %r0] 0x73
	.word 0xe69da000  ! 1756: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r19
	.word 0xee8504a0  ! 1757: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r23
	.word 0xeea5e000  ! 1758: STWA_I	stwa	%r23, [%r23 + 0x0000] %asi
	.word 0xeea52000  ! 1759: STWA_I	stwa	%r23, [%r20 + 0x0000] %asi
	.word 0xee952000  ! 1760: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r23
	.word 0xee8d6000  ! 1761: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r23
	mov	0x50, %r17
	mov	0x28, %r19
	mov	0x7c0, %r23
	.word 0xee8d6000  ! 1765: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r23
	.word 0xeed5e000  ! 1766: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r23
	.word 0x87802074  ! 1767: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8f5c4a0  ! 1768: STXA_R	stxa	%r20, [%r23 + %r0] 0x25
	mov	0x7c8, %r22
	.word 0xe88fa000  ! 1770: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r20
	.word 0xe2bcc400  ! 1771: STDA_R	stda	%r17, [%r19 + %r0] 0x20
	.word 0xe287a000  ! 1772: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r17
	.word 0xe6de89e0  ! 1773: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r19
	.word 0xe4a74e60  ! 1774: STWA_R	stwa	%r18, [%r29 + %r0] 0x73
	.word 0x87802072  ! 1775: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2b74e60  ! 1776: STHA_R	stha	%r17, [%r29 + %r0] 0x73
	.word 0xe28fa000  ! 1777: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r17
	mov	0x68, %r26
	.word 0x8780204f  ! 1779: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r26
	mov	0x0, %r16
	.word 0xe2ce2000  ! 1782: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r17
	.word 0x87802072  ! 1783: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_0_19:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x91, %g2
	or	%g4, 0xa6, %g4
	or	%g6, 0xd1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe6bf8e60  ! 1785: STDA_R	stda	%r19, [%r30 + %r0] 0x73
	.word 0xeef6c9e0  ! 1786: STXA_R	stxa	%r23, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1787: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	mov	0x50, %r16
	.word 0xe0f689e0  ! 1790: STXA_R	stxa	%r16, [%r26 + %r0] 0x4f
	.word 0xe09c2000  ! 1791: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r16
	.word 0x87802073  ! 1792: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea97ce80  ! 1793: LDUHA_R	lduha	[%r31, %r0] 0x74, %r21
	.word 0xeabfe000  ! 1794: STDA_I	stda	%r21, [%r31 + 0x0000] %asi
	.word 0xea9f6000  ! 1795: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r21
	mov	0x7c0, %r23
	.word 0xe8df8e40  ! 1797: LDXA_R	ldxa	[%r30, %r0] 0x72, %r20
	.word 0xe28fce80  ! 1798: LDUBA_R	lduba	[%r31, %r0] 0x74, %r17
	mov	0x68, %r16
	.word 0xe2f544a0  ! 1800: STXA_R	stxa	%r17, [%r21 + %r0] 0x25
	.word 0x87802072  ! 1801: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r16
	.word 0xe6844400  ! 1803: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r19
	.word 0xe6a7e000  ! 1804: STWA_I	stwa	%r19, [%r31 + 0x0000] %asi
	.word 0xec87ce60  ! 1805: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r22
	.word 0xecdfa000  ! 1806: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r22
	.word 0xeab78e60  ! 1807: STHA_R	stha	%r21, [%r30 + %r0] 0x73
	mov	0x48, %r16
	.word 0xe88f4e80  ! 1809: LDUBA_R	lduba	[%r29, %r0] 0x74, %r20
	.word 0xe8af2000  ! 1810: STBA_I	stba	%r20, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1811: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeef6c9e0  ! 1812: STXA_R	stxa	%r23, [%r27 + %r0] 0x4f
	.word 0xee8ca000  ! 1813: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r23
	.word 0xe2de09e0  ! 1814: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r17
	.word 0xe2842000  ! 1815: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r17
	.word 0xe28c2000  ! 1816: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r17
	mov	0x50, %r19
	mov	0x38, %r17
	.word 0x87802020  ! 1819: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2d42000  ! 1820: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r17
	.word 0xeea74e80  ! 1821: STWA_R	stwa	%r23, [%r29 + %r0] 0x74
	.word 0xee946000  ! 1822: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r23
	.word 0xe0bf0e80  ! 1823: STDA_R	stda	%r16, [%r28 + %r0] 0x74
	.word 0xe4bd04a0  ! 1824: STDA_R	stda	%r18, [%r20 + %r0] 0x25
	mov	0x48, %r25
	.word 0xe4b42000  ! 1826: STHA_I	stha	%r18, [%r16 + 0x0000] %asi
	.word 0xe4ace000  ! 1827: STBA_I	stba	%r18, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 1828: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4a66000  ! 1829: STWA_I	stwa	%r18, [%r25 + 0x0000] %asi
	.word 0xeeae89e0  ! 1830: STBA_R	stba	%r23, [%r26 + %r0] 0x4f
	.word 0xeea66000  ! 1831: STWA_I	stwa	%r23, [%r25 + 0x0000] %asi
	.word 0xeef62000  ! 1832: STXA_I	stxa	%r23, [%r24 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xeef66000  ! 1834: STXA_I	stxa	%r23, [%r25 + 0x0000] %asi
	.word 0xe69dc4a0  ! 1835: LDDA_R	ldda	[%r23, %r0] 0x25, %r19
	.word 0xe6a66000  ! 1836: STWA_I	stwa	%r19, [%r25 + 0x0000] %asi
	.word 0xe6cea000  ! 1837: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r19
	.word 0xe6df8e40  ! 1838: LDXA_R	ldxa	[%r30, %r0] 0x72, %r19
	.word 0xe09d44a0  ! 1839: LDDA_R	ldda	[%r21, %r0] 0x25, %r16
	mov	0x10, %r19
	mov	0x68, %r18
	.word 0xec978e80  ! 1842: LDUHA_R	lduha	[%r30, %r0] 0x74, %r22
	.word 0xecf504a0  ! 1843: STXA_R	stxa	%r22, [%r20 + %r0] 0x25
	mov	0x18, %r16
	.word 0xecdee000  ! 1845: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r22
	.word 0xe6cd84a0  ! 1846: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r19
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7e0, %r22
	.word 0xe68ea000  ! 1849: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r19
	ta	T_CHANGE_PRIV	! macro
	.word 0xe6aea000  ! 1851: STBA_I	stba	%r19, [%r26 + 0x0000] %asi
	.word 0xe6f62000  ! 1852: STXA_I	stxa	%r19, [%r24 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xe6bf8e40  ! 1854: STDA_R	stda	%r19, [%r30 + %r0] 0x72
	.word 0x87802073  ! 1855: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe29f8e40  ! 1856: LDDA_R	ldda	[%r30, %r0] 0x72, %r17
	.word 0xe4bd04a0  ! 1857: STDA_R	stda	%r18, [%r20 + %r0] 0x25
	.word 0xe4af2000  ! 1858: STBA_I	stba	%r18, [%r28 + 0x0000] %asi
	.word 0xe4b7e000  ! 1859: STHA_I	stha	%r18, [%r31 + 0x0000] %asi
	.word 0xe4c7e000  ! 1860: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r18
	.word 0xeaa40400  ! 1861: STWA_R	stwa	%r21, [%r16 + %r0] 0x20
	.word 0xea9fe000  ! 1862: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r21
	.word 0x8780204f  ! 1863: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xea9e6000  ! 1864: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r21
	.word 0xeaf66000  ! 1865: STXA_I	stxa	%r21, [%r25 + 0x0000] %asi
	mov	0x38, %r16
	.word 0xecdf0e40  ! 1867: LDXA_R	ldxa	[%r28, %r0] 0x72, %r22
	.word 0xe0f48400  ! 1868: STXA_R	stxa	%r16, [%r18 + %r0] 0x20
	.word 0xe4df4e80  ! 1869: LDXA_R	ldxa	[%r29, %r0] 0x74, %r18
	.word 0xeeb70e80  ! 1870: STHA_R	stha	%r23, [%r28 + %r0] 0x74
	.word 0xeede2000  ! 1871: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r23
	.word 0xe08c0400  ! 1872: LDUBA_R	lduba	[%r16, %r0] 0x20, %r16
	mov	0x58, %r17
	.word 0xe0a6e000  ! 1874: STWA_I	stwa	%r16, [%r27 + 0x0000] %asi
	.word 0xe8f4c400  ! 1875: STXA_R	stxa	%r20, [%r19 + %r0] 0x20
	.word 0xec870e80  ! 1876: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r22
	.word 0xead74e40  ! 1877: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r21
	mov	0x3f8, %r22
	.word 0xea96e000  ! 1879: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r21
	mov	0x68, %r24
	.word 0xea962000  ! 1881: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r21
	.word 0xeaf6e000  ! 1882: STXA_I	stxa	%r21, [%r27 + 0x0000] %asi
	.word 0xea966000  ! 1883: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r21
	.word 0xeab6a000  ! 1884: STHA_I	stha	%r21, [%r26 + 0x0000] %asi
	.word 0xea8e89e0  ! 1885: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r21
	.word 0xea9e2000  ! 1886: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r21
	.word 0xe29d44a0  ! 1887: LDDA_R	ldda	[%r21, %r0] 0x25, %r17
	.word 0xecae89e0  ! 1888: STBA_R	stba	%r22, [%r26 + %r0] 0x4f
	.word 0xee978e60  ! 1889: LDUHA_R	lduha	[%r30, %r0] 0x73, %r23
	mov	0x28, %r25
	.word 0xe4c48400  ! 1891: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r18
	.word 0xe4bee000  ! 1892: STDA_I	stda	%r18, [%r27 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xe8848400  ! 1894: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r20
	.word 0xeedd44a0  ! 1895: LDXA_R	ldxa	[%r21, %r0] 0x25, %r23
	.word 0x87802020  ! 1896: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeecc2000  ! 1897: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r23
	.word 0xeab609e0  ! 1898: STHA_R	stha	%r21, [%r24 + %r0] 0x4f
	.word 0xead4c400  ! 1899: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r21
	.word 0xe28f4e40  ! 1900: LDUBA_R	lduba	[%r29, %r0] 0x72, %r17
	.word 0xe0d584a0  ! 1901: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r16
	mov	0x78, %r19
	.word 0xeaa40400  ! 1903: STWA_R	stwa	%r21, [%r16 + %r0] 0x20
	.word 0x87802074  ! 1904: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0bf0e40  ! 1905: STDA_R	stda	%r16, [%r28 + %r0] 0x72
	mov	0x7e0, %r22
	.word 0xe08f2000  ! 1907: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r16
	.word 0xe0c76000  ! 1908: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r16
	mov	0x7f0, %r21
	mov	0x7f0, %r23
	mov	0x3d8, %r22
	.word 0xe0bfa000  ! 1912: STDA_I	stda	%r16, [%r30 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0x87802074  ! 1914: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0bfa000  ! 1915: STDA_I	stda	%r16, [%r30 + 0x0000] %asi
	.word 0xecbf4e80  ! 1916: STDA_R	stda	%r22, [%r29 + %r0] 0x74
	.word 0xecb7a000  ! 1917: STHA_I	stha	%r22, [%r30 + 0x0000] %asi
	.word 0xecc72000  ! 1918: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r22
	.word 0xeca7a000  ! 1919: STWA_I	stwa	%r22, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1920: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r23
	.word 0xecbd2000  ! 1922: STDA_I	stda	%r22, [%r20 + 0x0000] %asi
	mov	0x48, %r25
	mov	0x38, %r27
	.word 0x87802072  ! 1925: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r22
	wr_tick_cmpr_0_20:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xca, %g2
	or	%g4, 0xec, %g4
	or	%g6, 0x90, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe0bc8400  ! 1928: STDA_R	stda	%r16, [%r18 + %r0] 0x20
	mov	0x68, %r19
	.word 0xe09fe000  ! 1930: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r16
	.word 0xe0af0e40  ! 1931: STBA_R	stba	%r16, [%r28 + %r0] 0x72
	.word 0x87802072  ! 1932: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1933: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0a76000  ! 1934: STWA_I	stwa	%r16, [%r29 + 0x0000] %asi
	.word 0xe09fa000  ! 1935: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r16
	.word 0xe097e000  ! 1936: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r16
	.word 0x8780204f  ! 1937: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0a6e000  ! 1938: STWA_I	stwa	%r16, [%r27 + 0x0000] %asi
	.word 0xe0b6e000  ! 1939: STHA_I	stha	%r16, [%r27 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xe8f44400  ! 1941: STXA_R	stxa	%r20, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1942: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1943: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4874e80  ! 1944: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r18
	.word 0xe4f62000  ! 1945: STXA_I	stxa	%r18, [%r24 + 0x0000] %asi
	.word 0xe4c62000  ! 1946: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r18
	mov	0x38, %r18
	.word 0xe8d48400  ! 1948: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r20
	.word 0x8780204f  ! 1949: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8a70e40  ! 1950: STWA_R	stwa	%r20, [%r28 + %r0] 0x72
	.word 0xe8dee000  ! 1951: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r20
	mov	0x10, %r24
	.word 0xe8a66000  ! 1953: STWA_I	stwa	%r20, [%r25 + 0x0000] %asi
	.word 0xeabc0400  ! 1954: STDA_R	stda	%r21, [%r16 + %r0] 0x20
	.word 0xe8b7ce40  ! 1955: STHA_R	stha	%r20, [%r31 + %r0] 0x72
	.word 0x87802020  ! 1956: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8a48400  ! 1957: STWA_R	stwa	%r20, [%r18 + %r0] 0x20
	mov	0x70, %r27
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xe09c4400  ! 1960: LDDA_R	ldda	[%r17, %r0] 0x20, %r16
	.word 0xe0bca000  ! 1961: STDA_I	stda	%r16, [%r18 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7d0, %r22
	.word 0xeaa40400  ! 1964: STWA_R	stwa	%r21, [%r16 + %r0] 0x20
	.word 0xe2948400  ! 1965: LDUHA_R	lduha	[%r18, %r0] 0x20, %r17
	.word 0xe8a40400  ! 1966: STWA_R	stwa	%r20, [%r16 + %r0] 0x20
	.word 0xe0f48400  ! 1967: STXA_R	stxa	%r16, [%r18 + %r0] 0x20
	.word 0xe0942000  ! 1968: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r16
	.word 0xeec7ce80  ! 1969: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r23
	wr_tick_cmpr_0_21:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfa, %g2
	or	%g4, 0xb8, %g4
	or	%g6, 0x9d, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3f0, %r22
	.word 0xe0d6c9e0  ! 1972: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r16
	.word 0xe0dc2000  ! 1973: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r16
	.word 0xe0ac2000  ! 1974: STBA_I	stba	%r16, [%r16 + 0x0000] %asi
	.word 0xe0bca000  ! 1975: STDA_I	stda	%r16, [%r18 + 0x0000] %asi
	.word 0xe6a504a0  ! 1976: STWA_R	stwa	%r19, [%r20 + %r0] 0x25
	.word 0xeabd44a0  ! 1977: STDA_R	stda	%r21, [%r21 + %r0] 0x25
	.word 0xe4c40400  ! 1978: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r18
	mov	0x78, %r26
	.word 0xe4b40400  ! 1980: STHA_R	stha	%r18, [%r16 + %r0] 0x20
	mov	0x48, %r27
	.word 0x87802020  ! 1982: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r21
	wr_tick_cmpr_0_22:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe2, %g2
	or	%g4, 0xc9, %g4
	or	%g6, 0x92, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe4f78e80  ! 1985: STXA_R	stxa	%r18, [%r30 + %r0] 0x74
	.word 0xead70e40  ! 1986: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r21
	mov	0x7d0, %r23
	.word 0xee974e60  ! 1988: LDUHA_R	lduha	[%r29, %r0] 0x73, %r23
	.word 0x87802020  ! 1989: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeecca000  ! 1990: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r23
	.word 0xeed46000  ! 1991: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r23
	.word 0xeecca000  ! 1992: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r23
	mov	0x60, %r19
	.word 0xeec46000  ! 1994: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r23
	.word 0xeea46000  ! 1995: STWA_I	stwa	%r23, [%r17 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xeef42000  ! 1997: STXA_I	stxa	%r23, [%r16 + 0x0000] %asi
	.word 0xe4bc4400  ! 1998: STDA_R	stda	%r18, [%r17 + %r0] 0x20
	.word 0xe4d46000  ! 1999: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r18
	.word 0xe48c2000  ! 2000: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r18
	.word 0xea848400  ! 2001: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r21
	.word 0xe4ae09e0  ! 2002: STBA_R	stba	%r18, [%r24 + %r0] 0x4f
	mov	0x3d8, %r23
	.word 0xe4b46000  ! 2004: STHA_I	stha	%r18, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 2005: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4f70e40  ! 2006: STXA_R	stxa	%r18, [%r28 + %r0] 0x72
	.word 0xe4f66000  ! 2007: STXA_I	stxa	%r18, [%r25 + 0x0000] %asi
	.word 0xe48d44a0  ! 2008: LDUBA_R	lduba	[%r21, %r0] 0x25, %r18
	mov	0x38, %r27
	.word 0xe0ccc400  ! 2010: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r16
	.word 0xe09ea000  ! 2011: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r16
	.word 0xe6c74e60  ! 2012: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r19
	.word 0xe2d4c400  ! 2013: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r17
	mov	0x70, %r27
	.word 0xecac0400  ! 2015: STBA_R	stba	%r22, [%r16 + %r0] 0x20
	.word 0xe8dc0400  ! 2016: LDXA_R	ldxa	[%r16, %r0] 0x20, %r20
	.word 0xe886a000  ! 2017: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r20
	.word 0x87802074  ! 2018: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe897a000  ! 2019: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r20
	.word 0x87802074  ! 2020: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r24
	.word 0xeeb74e60  ! 2022: STHA_R	stha	%r23, [%r29 + %r0] 0x73
	.word 0x87802074  ! 2023: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2024: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2c78e60  ! 2025: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r17
	.word 0xecaf4e80  ! 2026: STBA_R	stba	%r22, [%r29 + %r0] 0x74
	.word 0xec94e000  ! 2027: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r22
	.word 0xec8c6000  ! 2028: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r22
	mov	0x78, %r17
	.word 0xeccc2000  ! 2030: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r22
	mov	0x78, %r19
	.word 0xecf42000  ! 2032: STXA_I	stxa	%r22, [%r16 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xe2cf0e60  ! 2034: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r17
	.word 0xe2bc6000  ! 2035: STDA_I	stda	%r17, [%r17 + 0x0000] %asi
	.word 0xe2ce89e0  ! 2036: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r17
	mov	0x8, %r25
	.word 0xe2bce000  ! 2038: STDA_I	stda	%r17, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 2039: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r19
	mov	0x78, %r25
	mov	0x7f8, %r22
	.word 0x87802072  ! 2043: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e8, %r23
	.word 0x87802020  ! 2045: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2046: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 2047: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeec70e40  ! 2048: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r23
	.word 0xeeb6e000  ! 2049: STHA_I	stha	%r23, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 2050: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeebd04a0  ! 2051: STDA_R	stda	%r23, [%r20 + %r0] 0x25
	mov	0x3f0, %r22
	mov	0x60, %r16
	mov	0x68, %r17
	mov	0x68, %r19
	.word 0x87802020  ! 2056: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xee9ca000  ! 2057: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r23
	.word 0xeeac2000  ! 2058: STBA_I	stba	%r23, [%r16 + 0x0000] %asi
	mov	0x48, %r24
	mov	0x28, %r24
	mov	0x48, %r16
	mov	0x7f8, %r21
	.word 0xeebc6000  ! 2063: STDA_I	stda	%r23, [%r17 + 0x0000] %asi
	.word 0xeef46000  ! 2064: STXA_I	stxa	%r23, [%r17 + 0x0000] %asi
	.word 0xeecca000  ! 2065: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r23
	mov	0x7e8, %r23
	mov	0x7f8, %r20
	.word 0x87802074  ! 2068: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeebf6000  ! 2069: STDA_I	stda	%r23, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2070: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe29f4e80  ! 2071: LDDA_R	ldda	[%r29, %r0] 0x74, %r17
	.word 0xe484c400  ! 2072: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r18
	.word 0xe0b5c4a0  ! 2073: STHA_R	stha	%r16, [%r23 + %r0] 0x25
	mov	0x3f8, %r22
	mov	0x78, %r26
	.word 0xe0ac2000  ! 2076: STBA_I	stba	%r16, [%r16 + 0x0000] %asi
	mov	0x7f0, %r20
	mov	0x7f8, %r21
	.word 0xeebf0e60  ! 2079: STDA_R	stda	%r23, [%r28 + %r0] 0x73
	mov	0x30, %r24
	.word 0xeaa584a0  ! 2081: STWA_R	stwa	%r21, [%r22 + %r0] 0x25
	.word 0xe0bf4e40  ! 2082: STDA_R	stda	%r16, [%r29 + %r0] 0x72
	.word 0xe4de49e0  ! 2083: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r18
	.word 0xe4cce000  ! 2084: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r18
	.word 0x87802020  ! 2085: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe89fce60  ! 2086: LDDA_R	ldda	[%r31, %r0] 0x73, %r20
	.word 0x87802072  ! 2087: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8afe000  ! 2088: STBA_I	stba	%r20, [%r31 + 0x0000] %asi
	.word 0xe8f44400  ! 2089: STXA_R	stxa	%r20, [%r17 + %r0] 0x20
	mov	0x3c8, %r22
	.word 0xe08649e0  ! 2091: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r16
	mov	0x8, %r18
	.word 0xe0af6000  ! 2093: STBA_I	stba	%r16, [%r29 + 0x0000] %asi
	.word 0xe08fe000  ! 2094: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r16
	.word 0xecf4c400  ! 2095: STXA_R	stxa	%r22, [%r19 + %r0] 0x20
	.word 0xe8ce09e0  ! 2096: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r20
	mov	0x28, %r18
	mov	0x50, %r26
	.word 0xe0b78e40  ! 2099: STHA_R	stha	%r16, [%r30 + %r0] 0x72
	.word 0xeaac8400  ! 2100: STBA_R	stba	%r21, [%r18 + %r0] 0x20
	.word 0xe0bc0400  ! 2101: STDA_R	stda	%r16, [%r16 + %r0] 0x20
	mov	0x3f0, %r21
	.word 0xe68e09e0  ! 2103: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r19
	.word 0xea8f4e60  ! 2104: LDUBA_R	lduba	[%r29, %r0] 0x73, %r21
	.word 0xeaf7a000  ! 2105: STXA_I	stxa	%r21, [%r30 + 0x0000] %asi
	mov	0x30, %r16
	.word 0xea8f2000  ! 2107: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r21
	.word 0xeab7e000  ! 2108: STHA_I	stha	%r21, [%r31 + 0x0000] %asi
	.word 0xec8f0e60  ! 2109: LDUBA_R	lduba	[%r28, %r0] 0x73, %r22
	.word 0xecad84a0  ! 2110: STBA_R	stba	%r22, [%r22 + %r0] 0x25
	mov	0x28, %r25
	.word 0xe6a6c9e0  ! 2112: STWA_R	stwa	%r19, [%r27 + %r0] 0x4f
	.word 0xecb74e40  ! 2113: STHA_R	stha	%r22, [%r29 + %r0] 0x72
	.word 0x87802020  ! 2114: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a609e0  ! 2115: STWA_R	stwa	%r16, [%r24 + %r0] 0x4f
	.word 0xe0b46000  ! 2116: STHA_I	stha	%r16, [%r17 + 0x0000] %asi
	.word 0xe0bc2000  ! 2117: STDA_I	stda	%r16, [%r16 + 0x0000] %asi
	.word 0xe09ce000  ! 2118: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r16
	.word 0xe0d46000  ! 2119: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r16
	mov	0x18, %r25
	mov	0x3f0, %r22
	.word 0xe2a584a0  ! 2122: STWA_R	stwa	%r17, [%r22 + %r0] 0x25
	mov	0x0, %r18
	.word 0x87802073  ! 2124: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2af6000  ! 2125: STBA_I	stba	%r17, [%r29 + 0x0000] %asi
	.word 0xecbec9e0  ! 2126: STDA_R	stda	%r22, [%r27 + %r0] 0x4f
	mov	0x70, %r19
	.word 0xec97e000  ! 2128: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r22
	.word 0x87802025  ! 2129: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2130: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8b78e60  ! 2131: STHA_R	stha	%r20, [%r30 + %r0] 0x73
	.word 0xe8a72000  ! 2132: STWA_I	stwa	%r20, [%r28 + 0x0000] %asi
	.word 0xe8a7e000  ! 2133: STWA_I	stwa	%r20, [%r31 + 0x0000] %asi
	.word 0xe0a689e0  ! 2134: STWA_R	stwa	%r16, [%r26 + %r0] 0x4f
	.word 0xe4b689e0  ! 2135: STHA_R	stha	%r18, [%r26 + %r0] 0x4f
	.word 0xee8689e0  ! 2136: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r23
	mov	0x8, %r17
	.word 0xee972000  ! 2138: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r23
	.word 0xee96c9e0  ! 2139: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r23
	mov	0x58, %r19
	.word 0xeecfa000  ! 2141: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r23
	mov	0x78, %r24
	.word 0xe88d44a0  ! 2143: LDUBA_R	lduba	[%r21, %r0] 0x25, %r20
	.word 0x87802020  ! 2144: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb70e60  ! 2145: STHA_R	stha	%r22, [%r28 + %r0] 0x73
	.word 0x87802020  ! 2146: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0dcc400  ! 2147: LDXA_R	ldxa	[%r19, %r0] 0x20, %r16
	.word 0xe0846000  ! 2148: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r16
	.word 0xe0a46000  ! 2149: STWA_I	stwa	%r16, [%r17 + 0x0000] %asi
	.word 0xeedc0400  ! 2150: LDXA_R	ldxa	[%r16, %r0] 0x20, %r23
	.word 0xee8ca000  ! 2151: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r23
	mov	0x20, %r26
	.word 0x87802072  ! 2153: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r20
	mov	0x50, %r16
	.word 0x87802025  ! 2156: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeea5a000  ! 2157: STWA_I	stwa	%r23, [%r22 + 0x0000] %asi
	mov	0x68, %r25
	mov	0x30, %r16
	.word 0xee9d2000  ! 2160: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r23
	.word 0xe8d78e40  ! 2161: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r20
	.word 0xe8f5a000  ! 2162: STXA_I	stxa	%r20, [%r22 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xe2df0e80  ! 2164: LDXA_R	ldxa	[%r28, %r0] 0x74, %r17
	.word 0x87802074  ! 2165: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r22
	mov	0x18, %r17
	.word 0x87802072  ! 2168: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe297a000  ! 2169: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r17
	mov	0x58, %r26
	.word 0xe4b4c400  ! 2171: STHA_R	stha	%r18, [%r19 + %r0] 0x20
	mov	0x0, %r25
	mov	0x3f0, %r20
	mov	0x38, %r26
	.word 0x8780204f  ! 2175: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r23
	.word 0xe0970e60  ! 2177: LDUHA_R	lduha	[%r28, %r0] 0x73, %r16
	.word 0xe0f66000  ! 2178: STXA_I	stxa	%r16, [%r25 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xeec78e80  ! 2180: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r23
	mov	0x50, %r27
	.word 0xeeb62000  ! 2182: STHA_I	stha	%r23, [%r24 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xee9ee000  ! 2184: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r23
	mov	0x20, %r19
	mov	0x0, %r25
	.word 0xe8cc8400  ! 2187: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r20
	.word 0xecb7ce40  ! 2188: STHA_R	stha	%r22, [%r31 + %r0] 0x72
	.word 0x87802073  ! 2189: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xec9f2000  ! 2190: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r22
	mov	0x30, %r25
	.word 0xecdf6000  ! 2192: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r22
	.word 0x87802020  ! 2193: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecbca000  ! 2194: STDA_I	stda	%r22, [%r18 + 0x0000] %asi
	.word 0xec8c6000  ! 2195: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r22
	.word 0x8780204f  ! 2196: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2940400  ! 2197: LDUHA_R	lduha	[%r16, %r0] 0x20, %r17
	.word 0xeed44400  ! 2198: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r23
	.word 0x87802020  ! 2199: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeebca000  ! 2200: STDA_I	stda	%r23, [%r18 + 0x0000] %asi
	mov	0x7f0, %r22
	mov	0x20, %r26
	.word 0xe0874e80  ! 2203: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r16
	.word 0xe0bc2000  ! 2204: STDA_I	stda	%r16, [%r16 + 0x0000] %asi
	.word 0xe4dc0400  ! 2205: LDXA_R	ldxa	[%r16, %r0] 0x20, %r18
	.word 0xe4b48400  ! 2206: STHA_R	stha	%r18, [%r18 + %r0] 0x20
	.word 0x87802073  ! 2207: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xec97ce80  ! 2208: LDUHA_R	lduha	[%r31, %r0] 0x74, %r22
	.word 0xeed7ce80  ! 2209: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r23
	mov	0x7f0, %r22
	.word 0xeef76000  ! 2211: STXA_I	stxa	%r23, [%r29 + 0x0000] %asi
	.word 0xeaf48400  ! 2212: STXA_R	stxa	%r21, [%r18 + %r0] 0x20
	.word 0xeacf2000  ! 2213: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r21
	.word 0xea976000  ! 2214: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r21
	mov	0x20, %r27
	.word 0xead7e000  ! 2216: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r21
	.word 0xe0a4c400  ! 2217: STWA_R	stwa	%r16, [%r19 + %r0] 0x20
	.word 0xe0b74e40  ! 2218: STHA_R	stha	%r16, [%r29 + %r0] 0x72
	.word 0xe6cec9e0  ! 2219: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r19
	.word 0xe8bf0e40  ! 2220: STDA_R	stda	%r20, [%r28 + %r0] 0x72
	mov	0x0, %r16
	.word 0xe8bfe000  ! 2222: STDA_I	stda	%r20, [%r31 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xe8ac4400  ! 2224: STBA_R	stba	%r20, [%r17 + %r0] 0x20
	.word 0xe88fa000  ! 2225: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r20
	mov	0x3c0, %r20
	.word 0xec9f0e60  ! 2227: LDDA_R	ldda	[%r28, %r0] 0x73, %r22
	mov	0x70, %r19
	.word 0xeca76000  ! 2229: STWA_I	stwa	%r22, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2230: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecdf2000  ! 2231: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r22
	.word 0xe0f48400  ! 2232: STXA_R	stxa	%r16, [%r18 + %r0] 0x20
	mov	0x3d8, %r20
	.word 0xe0af2000  ! 2234: STBA_I	stba	%r16, [%r28 + 0x0000] %asi
	.word 0xe0cfa000  ! 2235: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r16
	mov	0x48, %r25
	ta	T_CHANGE_HPRIV	! macro
	.word 0xeea584a0  ! 2238: STWA_R	stwa	%r23, [%r22 + %r0] 0x25
	.word 0xeef48400  ! 2239: STXA_R	stxa	%r23, [%r18 + %r0] 0x20
	.word 0xea9c0400  ! 2240: LDDA_R	ldda	[%r16, %r0] 0x20, %r21
	.word 0xeebe09e0  ! 2241: STDA_R	stda	%r23, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 2242: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaae09e0  ! 2243: STBA_R	stba	%r21, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 2244: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaac2000  ! 2245: STBA_I	stba	%r21, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 2246: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeacf8e80  ! 2247: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r21
	.word 0x87802020  ! 2248: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2974e40  ! 2249: LDUHA_R	lduha	[%r29, %r0] 0x72, %r17
	.word 0xe6bc8400  ! 2250: STDA_R	stda	%r19, [%r18 + %r0] 0x20
	.word 0xe68c6000  ! 2251: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r19
	.word 0xeca74e60  ! 2252: STWA_R	stwa	%r22, [%r29 + %r0] 0x73
	.word 0xeea584a0  ! 2253: STWA_R	stwa	%r23, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 2254: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2255: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeeb7a000  ! 2256: STHA_I	stha	%r23, [%r30 + 0x0000] %asi
	.word 0xeaf44400  ! 2257: STXA_R	stxa	%r21, [%r17 + %r0] 0x20
	mov	0x48, %r26
	.word 0xeaa76000  ! 2259: STWA_I	stwa	%r21, [%r29 + 0x0000] %asi
	.word 0xe0dec9e0  ! 2260: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r16
	mov	0x7f8, %r21
	mov	0x7d0, %r23
	mov	0x8, %r19
	.word 0xe69f4e60  ! 2264: LDDA_R	ldda	[%r29, %r0] 0x73, %r19
	mov	0x40, %r25
	mov	0x60, %r19
	.word 0xe8ccc400  ! 2267: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r20
	.word 0xe28c0400  ! 2268: LDUBA_R	lduba	[%r16, %r0] 0x20, %r17
	mov	0x18, %r25
	mov	0x70, %r26
	mov	0x3c0, %r20
	.word 0xe2bf6000  ! 2272: STDA_I	stda	%r17, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2273: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2b42000  ! 2274: STHA_I	stha	%r17, [%r16 + 0x0000] %asi
	.word 0xe4b609e0  ! 2275: STHA_R	stha	%r18, [%r24 + %r0] 0x4f
	.word 0xe4f46000  ! 2276: STXA_I	stxa	%r18, [%r17 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xe494a000  ! 2278: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r18
	mov	0x0, %r27
	.word 0xe4aca000  ! 2280: STBA_I	stba	%r18, [%r18 + 0x0000] %asi
	.word 0xe4946000  ! 2281: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r18
	.word 0x87802072  ! 2282: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 2283: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4b7e000  ! 2284: STHA_I	stha	%r18, [%r31 + 0x0000] %asi
	.word 0xe4d72000  ! 2285: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r18
	.word 0xe0a78e40  ! 2286: STWA_R	stwa	%r16, [%r30 + %r0] 0x72
	.word 0x87802025  ! 2287: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r20
	.word 0xe09d2000  ! 2289: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r16
	mov	0x68, %r25
	.word 0x87802025  ! 2291: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeadc8400  ! 2292: LDXA_R	ldxa	[%r18, %r0] 0x20, %r21
	.word 0xec9e49e0  ! 2293: LDDA_R	ldda	[%r25, %r0] 0x4f, %r22
	.word 0x8780204f  ! 2294: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecf66000  ! 2295: STXA_I	stxa	%r22, [%r25 + 0x0000] %asi
	.word 0xecb66000  ! 2296: STHA_I	stha	%r22, [%r25 + 0x0000] %asi
	.word 0xecbe2000  ! 2297: STDA_I	stda	%r22, [%r24 + 0x0000] %asi
	mov	0x78, %r24
	mov	0x7d8, %r20
	.word 0xecf6e000  ! 2300: STXA_I	stxa	%r22, [%r27 + 0x0000] %asi
	.word 0xe6a78e80  ! 2301: STWA_R	stwa	%r19, [%r30 + %r0] 0x74
	.word 0xeaa504a0  ! 2302: STWA_R	stwa	%r21, [%r20 + %r0] 0x25
	mov	0x70, %r16
	.word 0xea96a000  ! 2304: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r21
	.word 0xe4cc4400  ! 2305: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r18
	.word 0xe4b6e000  ! 2306: STHA_I	stha	%r18, [%r27 + 0x0000] %asi
	.word 0xe4be6000  ! 2307: STDA_I	stda	%r18, [%r25 + 0x0000] %asi
	.word 0xe4be2000  ! 2308: STDA_I	stda	%r18, [%r24 + 0x0000] %asi
	.word 0xe4f62000  ! 2309: STXA_I	stxa	%r18, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe4a62000  ! 2311: STWA_I	stwa	%r18, [%r24 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0xe2d6c9e0  ! 2313: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r17
	.word 0xe2f40400  ! 2314: STXA_R	stxa	%r17, [%r16 + %r0] 0x20
	.word 0xe8f48400  ! 2315: STXA_R	stxa	%r20, [%r18 + %r0] 0x20
	.word 0xe8b62000  ! 2316: STHA_I	stha	%r20, [%r24 + 0x0000] %asi
	.word 0xe4940400  ! 2317: LDUHA_R	lduha	[%r16, %r0] 0x20, %r18
	.word 0xeca40400  ! 2318: STWA_R	stwa	%r22, [%r16 + %r0] 0x20
	.word 0xe6d74e80  ! 2319: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r19
	.word 0x87802072  ! 2320: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0a74e80  ! 2321: STWA_R	stwa	%r16, [%r29 + %r0] 0x74
	.word 0x87802073  ! 2322: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeeafce60  ! 2323: STBA_R	stba	%r23, [%r31 + %r0] 0x73
	mov	0x3d0, %r23
	mov	0x18, %r25
	.word 0xeebfe000  ! 2326: STDA_I	stda	%r23, [%r31 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xee872000  ! 2328: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r23
	.word 0xe6b649e0  ! 2329: STHA_R	stha	%r19, [%r25 + %r0] 0x4f
	.word 0xe2df8e40  ! 2330: LDXA_R	ldxa	[%r30, %r0] 0x72, %r17
	.word 0x87802072  ! 2331: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe287a000  ! 2332: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r17
	.word 0xea9c8400  ! 2333: LDDA_R	ldda	[%r18, %r0] 0x20, %r21
	mov	0x3c0, %r20
	.word 0xe8bfce60  ! 2335: STDA_R	stda	%r20, [%r31 + %r0] 0x73
	mov	0x0, %r18
	.word 0xe897a000  ! 2337: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r20
	.word 0xe8dc0400  ! 2338: LDXA_R	ldxa	[%r16, %r0] 0x20, %r20
	.word 0xeaf74e60  ! 2339: STXA_R	stxa	%r21, [%r29 + %r0] 0x73
	.word 0xe8a6c9e0  ! 2340: STWA_R	stwa	%r20, [%r27 + %r0] 0x4f
	.word 0xe0be49e0  ! 2341: STDA_R	stda	%r16, [%r25 + %r0] 0x4f
	ta	T_CHANGE_PRIV	! macro
	mov	0x7c0, %r21
	.word 0xe4dd04a0  ! 2344: LDXA_R	ldxa	[%r20, %r0] 0x25, %r18
	mov	0x28, %r27
	.word 0xe48f2000  ! 2346: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r18
	.word 0xead504a0  ! 2347: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r21
	mov	0x28, %r18
	.word 0xe8bf0e40  ! 2349: STDA_R	stda	%r20, [%r28 + %r0] 0x72
	.word 0x87802025  ! 2350: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r25
	.word 0xe8bd2000  ! 2352: STDA_I	stda	%r20, [%r20 + 0x0000] %asi
	.word 0xec848400  ! 2353: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r22
	.word 0xe4a70e40  ! 2354: STWA_R	stwa	%r18, [%r28 + %r0] 0x72
	mov	0x3e8, %r23
	.word 0xe2cc0400  ! 2356: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r17
	mov	0x7f0, %r23
	.word 0xe2ada000  ! 2358: STBA_I	stba	%r17, [%r22 + 0x0000] %asi
	.word 0xeecc0400  ! 2359: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r23
	.word 0xeead6000  ! 2360: STBA_I	stba	%r23, [%r21 + 0x0000] %asi
	.word 0xeead2000  ! 2361: STBA_I	stba	%r23, [%r20 + 0x0000] %asi
	.word 0xecbd84a0  ! 2362: STDA_R	stda	%r22, [%r22 + %r0] 0x25
	.word 0xeccd2000  ! 2363: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r22
	.word 0xec9d6000  ! 2364: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r22
	.word 0xecd5a000  ! 2365: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r22
	.word 0xeea48400  ! 2366: STWA_R	stwa	%r23, [%r18 + %r0] 0x20
	mov	0x0, %r24
	mov	0x3e8, %r22
	.word 0xe8af8e60  ! 2369: STBA_R	stba	%r20, [%r30 + %r0] 0x73
	.word 0xe8c5e000  ! 2370: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r20
	.word 0xe4870e60  ! 2371: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r18
	.word 0xeadcc400  ! 2372: LDXA_R	ldxa	[%r19, %r0] 0x20, %r21
	mov	0x3c0, %r20
	.word 0xe6a48400  ! 2374: STWA_R	stwa	%r19, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2375: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6ac6000  ! 2376: STBA_I	stba	%r19, [%r17 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xe6a42000  ! 2378: STWA_I	stwa	%r19, [%r16 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xe6bc6000  ! 2380: STDA_I	stda	%r19, [%r17 + 0x0000] %asi
	.word 0xe0c6c9e0  ! 2381: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r16
	.word 0x87802020  ! 2382: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r17
	.word 0xeea609e0  ! 2384: STWA_R	stwa	%r23, [%r24 + %r0] 0x4f
	.word 0xeaf74e60  ! 2385: STXA_R	stxa	%r21, [%r29 + %r0] 0x73
	.word 0xe69c8400  ! 2386: LDDA_R	ldda	[%r18, %r0] 0x20, %r19
	.word 0xe684a000  ! 2387: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r19
	.word 0xe6b46000  ! 2388: STHA_I	stha	%r19, [%r17 + 0x0000] %asi
	mov	0x30, %r16
	mov	0x78, %r19
	.word 0xe6c42000  ! 2391: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r19
	.word 0xe6cce000  ! 2392: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r19
	mov	0x0, %r17
	mov	0x60, %r26
	.word 0xe6f4e000  ! 2395: STXA_I	stxa	%r19, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2396: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6a4e000  ! 2397: STWA_I	stwa	%r19, [%r19 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0x87802025  ! 2399: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeebfce60  ! 2400: STDA_R	stda	%r23, [%r31 + %r0] 0x73
	.word 0xeeade000  ! 2401: STBA_I	stba	%r23, [%r23 + 0x0000] %asi
	.word 0xec8cc400  ! 2402: LDUBA_R	lduba	[%r19, %r0] 0x20, %r22
	.word 0xecb52000  ! 2403: STHA_I	stha	%r22, [%r20 + 0x0000] %asi
	mov	0x20, %r18
	.word 0xecf40400  ! 2405: STXA_R	stxa	%r22, [%r16 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xecc52000  ! 2407: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r22
	.word 0xee9cc400  ! 2408: LDDA_R	ldda	[%r19, %r0] 0x20, %r23
	.word 0x87802073  ! 2409: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r18
	.word 0xe4848400  ! 2411: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r18
	.word 0xe4b7a000  ! 2412: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	mov	0x78, %r25
	.word 0x87802073  ! 2414: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r20
	.word 0xe6bf0e40  ! 2416: STDA_R	stda	%r19, [%r28 + %r0] 0x72
	mov	0x38, %r27
	.word 0xe6afa000  ! 2418: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	.word 0xe6af6000  ! 2419: STBA_I	stba	%r19, [%r29 + 0x0000] %asi
	.word 0xe2b7ce60  ! 2420: STHA_R	stha	%r17, [%r31 + %r0] 0x73
	mov	0x78, %r18
	.word 0xe4dc0400  ! 2422: LDXA_R	ldxa	[%r16, %r0] 0x20, %r18
	.word 0xec84c400  ! 2423: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r22
	.word 0xecf76000  ! 2424: STXA_I	stxa	%r22, [%r29 + 0x0000] %asi
	.word 0xecc76000  ! 2425: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0xeaa609e0  ! 2426: STWA_R	stwa	%r21, [%r24 + %r0] 0x4f
	.word 0xecbdc4a0  ! 2427: STDA_R	stda	%r22, [%r23 + %r0] 0x25
	.word 0xeac40400  ! 2428: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r21
	.word 0x87802073  ! 2429: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea9f6000  ! 2430: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r21
	mov	0x0, %r27
	.word 0xeaaf6000  ! 2432: STBA_I	stba	%r21, [%r29 + 0x0000] %asi
	mov	0x58, %r27
	mov	0x48, %r25
	.word 0xe4a70e40  ! 2435: STWA_R	stwa	%r18, [%r28 + %r0] 0x72
	mov	0x20, %r19
	.word 0x87802025  ! 2437: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0be49e0  ! 2438: STDA_R	stda	%r16, [%r25 + %r0] 0x4f
	.word 0xe0ada000  ! 2439: STBA_I	stba	%r16, [%r22 + 0x0000] %asi
	.word 0xe2f78e40  ! 2440: STXA_R	stxa	%r17, [%r30 + %r0] 0x72
	.word 0xec8d44a0  ! 2441: LDUBA_R	lduba	[%r21, %r0] 0x25, %r22
	.word 0xecade000  ! 2442: STBA_I	stba	%r22, [%r23 + 0x0000] %asi
	.word 0xecd56000  ! 2443: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r22
	mov	0x10, %r25
	.word 0xecb5a000  ! 2445: STHA_I	stha	%r22, [%r22 + 0x0000] %asi
	.word 0xecad2000  ! 2446: STBA_I	stba	%r22, [%r20 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xecbd2000  ! 2448: STDA_I	stda	%r22, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 2449: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4afce40  ! 2450: STBA_R	stba	%r18, [%r31 + %r0] 0x72
	.word 0xe4b72000  ! 2451: STHA_I	stha	%r18, [%r28 + 0x0000] %asi
	mov	0x3d0, %r23
	mov	0x70, %r18
	.word 0xe0f40400  ! 2454: STXA_R	stxa	%r16, [%r16 + %r0] 0x20
	wr_tick_cmpr_0_23:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb8, %g2
	or	%g4, 0x8c, %g4
	or	%g6, 0x90, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 2456: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe685c4a0  ! 2457: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r19
	mov	0x8, %r17
	.word 0x87802025  ! 2459: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r16
	.word 0xe6a5a000  ! 2461: STWA_I	stwa	%r19, [%r22 + 0x0000] %asi
	.word 0xe49d04a0  ! 2462: LDDA_R	ldda	[%r20, %r0] 0x25, %r18
	.word 0xe4bd2000  ! 2463: STDA_I	stda	%r18, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 2464: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2465: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe89f0e60  ! 2466: LDDA_R	ldda	[%r28, %r0] 0x73, %r20
	.word 0xe8df2000  ! 2467: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r20
	.word 0x87802020  ! 2468: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2c4c400  ! 2469: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r17
	.word 0xe2f70e60  ! 2470: STXA_R	stxa	%r17, [%r28 + %r0] 0x73
	.word 0x87802074  ! 2471: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe287e000  ! 2472: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r17
	.word 0xe4dfce40  ! 2473: LDXA_R	ldxa	[%r31, %r0] 0x72, %r18
	mov	0x60, %r19
	.word 0x87802072  ! 2475: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8a74e60  ! 2476: STWA_R	stwa	%r20, [%r29 + %r0] 0x73
	.word 0xeaf44400  ! 2477: STXA_R	stxa	%r21, [%r17 + %r0] 0x20
	.word 0xe8f544a0  ! 2478: STXA_R	stxa	%r20, [%r21 + %r0] 0x25
	.word 0xe88f6000  ! 2479: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r20
	.word 0xe897a000  ! 2480: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r20
	.word 0xe28f8e40  ! 2481: LDUBA_R	lduba	[%r30, %r0] 0x72, %r17
	.word 0x87802072  ! 2482: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2840400  ! 2483: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r17
	.word 0xeea74e80  ! 2484: STWA_R	stwa	%r23, [%r29 + %r0] 0x74
	mov	0x30, %r19
	.word 0xee97a000  ! 2486: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r23
	mov	0x58, %r18
	mov	0x20, %r19
	mov	0x7f8, %r21
	.word 0xeeb7e000  ! 2490: STHA_I	stha	%r23, [%r31 + 0x0000] %asi
	mov	0x78, %r16
	mov	0x48, %r24
	.word 0xe6c544a0  ! 2493: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r19
	.word 0xe2c78e80  ! 2494: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r17
	.word 0xe29f2000  ! 2495: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r17
	.word 0xeaf78e80  ! 2496: STXA_R	stxa	%r21, [%r30 + %r0] 0x74
	.word 0xe0ddc4a0  ! 2497: LDXA_R	ldxa	[%r23, %r0] 0x25, %r16
	.word 0xe0976000  ! 2498: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r16
	.word 0xe0f76000  ! 2499: STXA_I	stxa	%r16, [%r29 + 0x0000] %asi
	.word 0xe0d72000  ! 2500: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r16
	.word 0xeaae89e0  ! 2501: STBA_R	stba	%r21, [%r26 + %r0] 0x4f
	.word 0xeaa76000  ! 2502: STWA_I	stwa	%r21, [%r29 + 0x0000] %asi
	.word 0xeaafe000  ! 2503: STBA_I	stba	%r21, [%r31 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xeabfa000  ! 2505: STDA_I	stda	%r21, [%r30 + 0x0000] %asi
	.word 0xeacf2000  ! 2506: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r21
	mov	0x38, %r18
	.word 0x87802020  ! 2508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea8e09e0  ! 2509: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r21
	mov	0x38, %r18
	mov	0x58, %r26
	mov	0x7d0, %r23
	mov	0x7f0, %r23
	mov	0x7d8, %r21
	.word 0xeab4a000  ! 2515: STHA_I	stha	%r21, [%r18 + 0x0000] %asi
	.word 0xe8874e40  ! 2516: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r20
	mov	0x8, %r16
	.word 0xe2bc0400  ! 2518: STDA_R	stda	%r17, [%r16 + %r0] 0x20
	.word 0xe0df4e60  ! 2519: LDXA_R	ldxa	[%r29, %r0] 0x73, %r16
	mov	0x78, %r16
	.word 0xe0d4a000  ! 2521: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r16
	.word 0xe0ac6000  ! 2522: STBA_I	stba	%r16, [%r17 + 0x0000] %asi
	.word 0xee9f0e80  ! 2523: LDDA_R	ldda	[%r28, %r0] 0x74, %r23
	mov	0x7e0, %r23
	.word 0xe4af8e80  ! 2525: STBA_R	stba	%r18, [%r30 + %r0] 0x74
	.word 0xe4cc2000  ! 2526: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r18
	.word 0xe4bce000  ! 2527: STDA_I	stda	%r18, [%r19 + 0x0000] %asi
	wr_tick_cmpr_0_24:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa7, %g2
	or	%g4, 0xe3, %g4
	or	%g6, 0xd5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe4c46000  ! 2529: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r18
	mov	0x20, %r19
	.word 0xe4dc8400  ! 2531: LDXA_R	ldxa	[%r18, %r0] 0x20, %r18
	mov	0x7c0, %r22
	.word 0xe0944400  ! 2533: LDUHA_R	lduha	[%r17, %r0] 0x20, %r16
	.word 0x8780204f  ! 2534: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xee870e80  ! 2535: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r23
	mov	0x18, %r18
	.word 0xeedee000  ! 2537: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r23
	.word 0xe0f70e80  ! 2538: STXA_R	stxa	%r16, [%r28 + %r0] 0x74
	.word 0xe0b66000  ! 2539: STHA_I	stha	%r16, [%r25 + 0x0000] %asi
	.word 0xe09c8400  ! 2540: LDDA_R	ldda	[%r18, %r0] 0x20, %r16
	.word 0xe08e6000  ! 2541: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r16
	.word 0xecd44400  ! 2542: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r22
	mov	0x8, %r19
	mov	0x70, %r25
	.word 0xecc6e000  ! 2545: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r22
	.word 0xe49ec9e0  ! 2546: LDDA_R	ldda	[%r27, %r0] 0x4f, %r18
	.word 0xe6ac8400  ! 2547: STBA_R	stba	%r19, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2548: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6ace000  ! 2549: STBA_I	stba	%r19, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 2550: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r20
	.word 0xe4878e40  ! 2552: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r18
	.word 0xe4afe000  ! 2553: STBA_I	stba	%r18, [%r31 + 0x0000] %asi
	mov	0x40, %r27
	mov	0x30, %r24
	.word 0x87802025  ! 2556: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4ade000  ! 2557: STBA_I	stba	%r18, [%r23 + 0x0000] %asi
	.word 0xe4bd2000  ! 2558: STDA_I	stda	%r18, [%r20 + 0x0000] %asi
	.word 0xe4cda000  ! 2559: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r18
	.word 0xe4f56000  ! 2560: STXA_I	stxa	%r18, [%r21 + 0x0000] %asi
	.word 0xe6bcc400  ! 2561: STDA_R	stda	%r19, [%r19 + %r0] 0x20
	mov	0x3c8, %r20
	.word 0xe6856000  ! 2563: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r19
	mov	0x10, %r19
	.word 0xe6b5e000  ! 2565: STHA_I	stha	%r19, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 2566: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6876000  ! 2567: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r19
	mov	0x3f0, %r21
	mov	0x38, %r27
	.word 0xe6876000  ! 2570: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r19
	.word 0xe6b7a000  ! 2571: STHA_I	stha	%r19, [%r30 + 0x0000] %asi
	.word 0xe68f6000  ! 2572: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r19
	.word 0xe6df2000  ! 2573: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r19
	.word 0xe6bfa000  ! 2574: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xe8bdc4a0  ! 2575: STDA_R	stda	%r20, [%r23 + %r0] 0x25
	.word 0xeadfce60  ! 2576: LDXA_R	ldxa	[%r31, %r0] 0x73, %r21
	mov	0x28, %r26
	.word 0xe2de09e0  ! 2578: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r17
	.word 0x87802025  ! 2579: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0ddc4a0  ! 2580: LDXA_R	ldxa	[%r23, %r0] 0x25, %r16
	.word 0xe2d74e80  ! 2581: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r17
	mov	0x0, %r25
	mov	0x40, %r17
	.word 0xe6bfce40  ! 2584: STDA_R	stda	%r19, [%r31 + %r0] 0x72
	.word 0xe6a5e000  ! 2585: STWA_I	stwa	%r19, [%r23 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xecbec9e0  ! 2587: STDA_R	stda	%r22, [%r27 + %r0] 0x4f
	.word 0xecb5e000  ! 2588: STHA_I	stha	%r22, [%r23 + 0x0000] %asi
	.word 0xecf5e000  ! 2589: STXA_I	stxa	%r22, [%r23 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0x8780204f  ! 2591: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2bf4e40  ! 2592: STDA_R	stda	%r17, [%r29 + %r0] 0x72
	.word 0xe2a6e000  ! 2593: STWA_I	stwa	%r17, [%r27 + 0x0000] %asi
	mov	0x48, %r26
	mov	0x70, %r16
	.word 0xeaf70e60  ! 2596: STXA_R	stxa	%r21, [%r28 + %r0] 0x73
	.word 0xeace2000  ! 2597: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r21
	mov	0x3e0, %r21
	.word 0xead62000  ! 2599: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r21
	.word 0x8780204f  ! 2600: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r23
	.word 0xe4dc8400  ! 2602: LDXA_R	ldxa	[%r18, %r0] 0x20, %r18
	.word 0xeadc4400  ! 2603: LDXA_R	ldxa	[%r17, %r0] 0x20, %r21
	.word 0x87802074  ! 2604: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeaa76000  ! 2605: STWA_I	stwa	%r21, [%r29 + 0x0000] %asi
	.word 0xea9f2000  ! 2606: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r21
	.word 0x87802020  ! 2607: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaa4a000  ! 2608: STWA_I	stwa	%r21, [%r18 + 0x0000] %asi
	.word 0xea94e000  ! 2609: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r21
	.word 0xeaafce60  ! 2610: STBA_R	stba	%r21, [%r31 + %r0] 0x73
	mov	0x3d0, %r20
	.word 0xecb6c9e0  ! 2612: STHA_R	stha	%r22, [%r27 + %r0] 0x4f
	.word 0xecdca000  ! 2613: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r22
	mov	0x7c0, %r22
	.word 0xe6cf0e40  ! 2615: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r19
	.word 0xe2b70e80  ! 2616: STHA_R	stha	%r17, [%r28 + %r0] 0x74
	.word 0xe2bca000  ! 2617: STDA_I	stda	%r17, [%r18 + 0x0000] %asi
	.word 0xe0afce60  ! 2618: STBA_R	stba	%r16, [%r31 + %r0] 0x73
	mov	0x20, %r24
	.word 0xe0bc6000  ! 2620: STDA_I	stda	%r16, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 2621: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r24
	mov	0x18, %r17
	.word 0xe89f0e80  ! 2624: LDDA_R	ldda	[%r28, %r0] 0x74, %r20
	mov	0x7e0, %r22
	.word 0xe6b4c400  ! 2626: STHA_R	stha	%r19, [%r19 + %r0] 0x20
	.word 0xe0d74e80  ! 2627: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r16
	.word 0x87802020  ! 2628: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r23
	.word 0xe0aca000  ! 2630: STBA_I	stba	%r16, [%r18 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0x87802020  ! 2632: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe084a000  ! 2633: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r16
	.word 0xe2bc8400  ! 2634: STDA_R	stda	%r17, [%r18 + %r0] 0x20
	.word 0xe2bf0e60  ! 2635: STDA_R	stda	%r17, [%r28 + %r0] 0x73
	.word 0xe284a000  ! 2636: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r17
	.word 0xe2f46000  ! 2637: STXA_I	stxa	%r17, [%r17 + 0x0000] %asi
	mov	0x60, %r17
	.word 0x87802020  ! 2639: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2ac6000  ! 2640: STBA_I	stba	%r17, [%r17 + 0x0000] %asi
	mov	0x68, %r16
	mov	0x0, %r19
	mov	0x30, %r25
	mov	0x60, %r19
	.word 0x87802072  ! 2645: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeedcc400  ! 2646: LDXA_R	ldxa	[%r19, %r0] 0x20, %r23
	.word 0xeeb7a000  ! 2647: STHA_I	stha	%r23, [%r30 + 0x0000] %asi
	.word 0xee87e000  ! 2648: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r23
	.word 0xeeb76000  ! 2649: STHA_I	stha	%r23, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 2650: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e0, %r20
	.word 0x87802020  ! 2652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xee8ce000  ! 2653: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r23
	.word 0xe68f0e60  ! 2654: LDUBA_R	lduba	[%r28, %r0] 0x73, %r19
	.word 0xe6b4a000  ! 2655: STHA_I	stha	%r19, [%r18 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xe6b4c400  ! 2657: STHA_R	stha	%r19, [%r19 + %r0] 0x20
	mov	0x78, %r24
	.word 0xe69ca000  ! 2659: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r19
	.word 0x87802073  ! 2660: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r18
	.word 0xe48f4e80  ! 2662: LDUBA_R	lduba	[%r29, %r0] 0x74, %r18
	mov	0x0, %r27
	.word 0xe4f72000  ! 2664: STXA_I	stxa	%r18, [%r28 + 0x0000] %asi
	.word 0xeab5c4a0  ! 2665: STHA_R	stha	%r21, [%r23 + %r0] 0x25
	mov	0x3e0, %r22
	mov	0x3e0, %r22
	.word 0xecb649e0  ! 2668: STHA_R	stha	%r22, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 2669: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecad2000  ! 2670: STBA_I	stba	%r22, [%r20 + 0x0000] %asi
	.word 0xe2874e60  ! 2671: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r17
	.word 0x87802025  ! 2672: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2cda000  ! 2673: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r17
	.word 0xe2f70e60  ! 2674: STXA_R	stxa	%r17, [%r28 + %r0] 0x73
	.word 0x87802025  ! 2675: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r25
	.word 0xe2c5e000  ! 2677: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r17
	.word 0xe6af8e80  ! 2678: STBA_R	stba	%r19, [%r30 + %r0] 0x74
	.word 0xe8b44400  ! 2679: STHA_R	stha	%r20, [%r17 + %r0] 0x20
	.word 0x87802073  ! 2680: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8f609e0  ! 2681: STXA_R	stxa	%r20, [%r24 + %r0] 0x4f
	.word 0xe8b7a000  ! 2682: STHA_I	stha	%r20, [%r30 + 0x0000] %asi
	.word 0xe0a70e40  ! 2683: STWA_R	stwa	%r16, [%r28 + %r0] 0x72
	.word 0xee8cc400  ! 2684: LDUBA_R	lduba	[%r19, %r0] 0x20, %r23
	mov	0x28, %r17
	.word 0xecb4c400  ! 2686: STHA_R	stha	%r22, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 2687: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecd62000  ! 2688: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r22
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x7f0, %r20
	.word 0x87802020  ! 2691: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb48400  ! 2692: STHA_R	stha	%r22, [%r18 + %r0] 0x20
	.word 0xecbf4e80  ! 2693: STDA_R	stda	%r22, [%r29 + %r0] 0x74
	mov	0x40, %r17
	mov	0x38, %r17
	.word 0xecdc2000  ! 2696: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r22
	.word 0xeccc2000  ! 2697: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r22
	.word 0xe2b78e40  ! 2698: STHA_R	stha	%r17, [%r30 + %r0] 0x72
	mov	0x20, %r26
	.word 0xe2bc2000  ! 2700: STDA_I	stda	%r17, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 2701: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2702: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0a609e0  ! 2703: STWA_R	stwa	%r16, [%r24 + %r0] 0x4f
	.word 0xe0f76000  ! 2704: STXA_I	stxa	%r16, [%r29 + 0x0000] %asi
	.word 0xe0d7e000  ! 2705: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r16
	.word 0xe0a5c4a0  ! 2706: STWA_R	stwa	%r16, [%r23 + %r0] 0x25
	.word 0xe0976000  ! 2707: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r16
	mov	0x3c8, %r21
	mov	0x7d0, %r21
	.word 0xe0a72000  ! 2710: STWA_I	stwa	%r16, [%r28 + 0x0000] %asi
	.word 0xe4d4c400  ! 2711: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r18
	mov	0x70, %r19
	.word 0xe48fa000  ! 2713: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r18
	.word 0xe4bf2000  ! 2714: STDA_I	stda	%r18, [%r28 + 0x0000] %asi
	.word 0xe4bfa000  ! 2715: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 2716: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r26
	.word 0xe4d6a000  ! 2718: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r18
	mov	0x7e8, %r20
	mov	0x18, %r24
	.word 0xe4f78e80  ! 2721: STXA_R	stxa	%r18, [%r30 + %r0] 0x74
	.word 0xe48f4e40  ! 2722: LDUBA_R	lduba	[%r29, %r0] 0x72, %r18
	.word 0xe4cee000  ! 2723: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r18
	.word 0xe4be49e0  ! 2724: STDA_R	stda	%r18, [%r25 + %r0] 0x4f
	.word 0xe4aee000  ! 2725: STBA_I	stba	%r18, [%r27 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802073  ! 2727: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4d7a000  ! 2728: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r18
	mov	0x7f8, %r23
	mov	0x3f8, %r23
	.word 0x87802074  ! 2731: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2a609e0  ! 2732: STWA_R	stwa	%r17, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 2733: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 2734: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2735: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8dc4400  ! 2736: LDXA_R	ldxa	[%r17, %r0] 0x20, %r20
	.word 0xe4dfce40  ! 2737: LDXA_R	ldxa	[%r31, %r0] 0x72, %r18
	.word 0x87802020  ! 2738: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r24
	.word 0x87802020  ! 2740: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2b70e80  ! 2741: STHA_R	stha	%r17, [%r28 + %r0] 0x74
	.word 0xec940400  ! 2742: LDUHA_R	lduha	[%r16, %r0] 0x20, %r22
	mov	0x7d8, %r22
	.word 0xecf4a000  ! 2744: STXA_I	stxa	%r22, [%r18 + 0x0000] %asi
	.word 0xec8c6000  ! 2745: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r22
	.word 0xe2ce89e0  ! 2746: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r17
	mov	0x30, %r26
	.word 0x8780204f  ! 2748: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2a66000  ! 2749: STWA_I	stwa	%r17, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 2750: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2bea000  ! 2751: STDA_I	stda	%r17, [%r26 + 0x0000] %asi
	.word 0xe2b70e80  ! 2752: STHA_R	stha	%r17, [%r28 + %r0] 0x74
	.word 0xe6f74e80  ! 2753: STXA_R	stxa	%r19, [%r29 + %r0] 0x74
	.word 0x87802074  ! 2754: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe09f0e80  ! 2755: LDDA_R	ldda	[%r28, %r0] 0x74, %r16
	.word 0xe0ac0400  ! 2756: STBA_R	stba	%r16, [%r16 + %r0] 0x20
	mov	0x70, %r24
	.word 0x87802025  ! 2758: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0c5a000  ! 2759: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r16
	mov	0x3c0, %r23
	mov	0x70, %r26
	.word 0xe0f52000  ! 2762: STXA_I	stxa	%r16, [%r20 + 0x0000] %asi
	.word 0xe0940400  ! 2763: LDUHA_R	lduha	[%r16, %r0] 0x20, %r16
	mov	0x8, %r27
	.word 0xeeb44400  ! 2765: STHA_R	stha	%r23, [%r17 + %r0] 0x20
	.word 0xeaddc4a0  ! 2766: LDXA_R	ldxa	[%r23, %r0] 0x25, %r21
	.word 0x87802020  ! 2767: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaa4e000  ! 2768: STWA_I	stwa	%r21, [%r19 + 0x0000] %asi
	.word 0xea8ce000  ! 2769: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r21
	.word 0xead4e000  ! 2770: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r21
	.word 0xe6b70e60  ! 2771: STHA_R	stha	%r19, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 2772: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeeb544a0  ! 2773: STHA_R	stha	%r23, [%r21 + %r0] 0x25
	mov	0x58, %r24
	.word 0x87802025  ! 2775: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r25
	.word 0xea84c400  ! 2777: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r21
	mov	0x7d0, %r20
	.word 0x8780204f  ! 2779: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xea8e6000  ! 2780: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r21
	.word 0xeabe2000  ! 2781: STDA_I	stda	%r21, [%r24 + 0x0000] %asi
	.word 0xea966000  ! 2782: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r21
	mov	0x70, %r26
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x30, %r24
	.word 0xeaf70e80  ! 2786: STXA_R	stxa	%r21, [%r28 + %r0] 0x74
	.word 0xeab6a000  ! 2787: STHA_I	stha	%r21, [%r26 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0x87802072  ! 2789: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r23
	.word 0xeaafce80  ! 2791: STBA_R	stba	%r21, [%r31 + %r0] 0x74
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802074  ! 2793: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 2794: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeadda000  ! 2795: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r21
	.word 0xe0844400  ! 2796: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r16
	.word 0xe6f689e0  ! 2797: STXA_R	stxa	%r19, [%r26 + %r0] 0x4f
	mov	0x7d0, %r21
	.word 0xe6bda000  ! 2799: STDA_I	stda	%r19, [%r22 + 0x0000] %asi
	mov	0x58, %r27
	mov	0x68, %r25
	.word 0xea874e40  ! 2802: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r21
	.word 0xe4d689e0  ! 2803: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r18
	.word 0xe4d56000  ! 2804: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r18
	mov	0x0, %r19
	.word 0x87802072  ! 2806: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r22
	.word 0xeebf0e40  ! 2808: STDA_R	stda	%r23, [%r28 + %r0] 0x72
	.word 0x87802025  ! 2809: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xee8da000  ! 2810: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r23
	.word 0xeabc0400  ! 2811: STDA_R	stda	%r21, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2812: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeed70e80  ! 2813: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r23
	mov	0x3e8, %r21
	mov	0x58, %r18
	.word 0xeebc2000  ! 2816: STDA_I	stda	%r23, [%r16 + 0x0000] %asi
	.word 0xee842000  ! 2817: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r23
	.word 0x8780204f  ! 2818: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeec6a000  ! 2819: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r23
	.word 0xeaf74e60  ! 2820: STXA_R	stxa	%r21, [%r29 + %r0] 0x73
	.word 0x87802025  ! 2821: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2822: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d0, %r20
	mov	0x3f0, %r21
	mov	0x20, %r24
	.word 0xeaf7e000  ! 2826: STXA_I	stxa	%r21, [%r31 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xeab7e000  ! 2828: STHA_I	stha	%r21, [%r31 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0x8780204f  ! 2830: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4bfce40  ! 2831: STDA_R	stda	%r18, [%r31 + %r0] 0x72
	.word 0xe887ce60  ! 2832: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r20
	.word 0xe8ae2000  ! 2833: STBA_I	stba	%r20, [%r24 + 0x0000] %asi
	.word 0xe08f8e40  ! 2834: LDUBA_R	lduba	[%r30, %r0] 0x72, %r16
	.word 0xe6bc0400  ! 2835: STDA_R	stda	%r19, [%r16 + %r0] 0x20
	mov	0x48, %r26
	mov	0x20, %r18
	.word 0xe4bec9e0  ! 2838: STDA_R	stda	%r18, [%r27 + %r0] 0x4f
	mov	0x7c0, %r20
	mov	0x38, %r17
	.word 0x87802074  ! 2841: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r23
	mov	0x10, %r26
	.word 0x87802020  ! 2844: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6978e60  ! 2845: LDUHA_R	lduha	[%r30, %r0] 0x73, %r19
	.word 0xe68c6000  ! 2846: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r19
	.word 0xe2c544a0  ! 2847: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r17
	mov	0x10, %r17
	.word 0xe6adc4a0  ! 2849: STBA_R	stba	%r19, [%r23 + %r0] 0x25
	.word 0xe68ca000  ! 2850: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r19
	.word 0x87802025  ! 2851: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6ad2000  ! 2852: STBA_I	stba	%r19, [%r20 + 0x0000] %asi
	.word 0xe0f544a0  ! 2853: STXA_R	stxa	%r16, [%r21 + %r0] 0x25
	.word 0x87802073  ! 2854: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0cfe000  ! 2855: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r16
	.word 0x87802072  ! 2856: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0f76000  ! 2857: STXA_I	stxa	%r16, [%r29 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xeaf70e60  ! 2859: STXA_R	stxa	%r21, [%r28 + %r0] 0x73
	.word 0xea9f2000  ! 2860: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r21
	.word 0xe4b7ce60  ! 2861: STHA_R	stha	%r18, [%r31 + %r0] 0x73
	mov	0x58, %r24
	wr_tick_cmpr_0_25:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0xb7, %g4
	or	%g6, 0xc1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x30, %r18
	.word 0xe8f5c4a0  ! 2865: STXA_R	stxa	%r20, [%r23 + %r0] 0x25
	.word 0xe09689e0  ! 2866: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r16
	mov	0x60, %r19
	.word 0xe2d4c400  ! 2868: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r17
	.word 0xe2af6000  ! 2869: STBA_I	stba	%r17, [%r29 + 0x0000] %asi
	.word 0xe29f6000  ! 2870: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r17
	.word 0xe497ce80  ! 2871: LDUHA_R	lduha	[%r31, %r0] 0x74, %r18
	.word 0xe88f8e40  ! 2872: LDUBA_R	lduba	[%r30, %r0] 0x72, %r20
	.word 0xe8a7e000  ! 2873: STWA_I	stwa	%r20, [%r31 + 0x0000] %asi
	.word 0xe89c0400  ! 2874: LDDA_R	ldda	[%r16, %r0] 0x20, %r20
	.word 0x8780204f  ! 2875: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 2877: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeac40400  ! 2878: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r21
	.word 0x87802074  ! 2879: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeac72000  ! 2880: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r21
	.word 0x87802073  ! 2881: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r25
	mov	0x18, %r24
	.word 0xeaf76000  ! 2884: STXA_I	stxa	%r21, [%r29 + 0x0000] %asi
	.word 0xea9fa000  ! 2885: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r21
	.word 0xeaafe000  ! 2886: STBA_I	stba	%r21, [%r31 + 0x0000] %asi
	.word 0xeacfe000  ! 2887: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r21
	.word 0xeaafe000  ! 2888: STBA_I	stba	%r21, [%r31 + 0x0000] %asi
	.word 0xea8fe000  ! 2889: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r21
	.word 0x87802020  ! 2890: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeac4e000  ! 2891: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r21
	mov	0x58, %r25
	.word 0x8780204f  ! 2893: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r25
	.word 0xeaa6e000  ! 2895: STWA_I	stwa	%r21, [%r27 + 0x0000] %asi
	.word 0xecb4c400  ! 2896: STHA_R	stha	%r22, [%r19 + %r0] 0x20
	.word 0xe08f4e60  ! 2897: LDUBA_R	lduba	[%r29, %r0] 0x73, %r16
	mov	0x30, %r19
	.word 0xe0bea000  ! 2899: STDA_I	stda	%r16, [%r26 + 0x0000] %asi
	.word 0xe0cee000  ! 2900: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r16
	mov	0x70, %r27
	.word 0xe4bc4400  ! 2902: STDA_R	stda	%r18, [%r17 + %r0] 0x20
	.word 0xe4aea000  ! 2903: STBA_I	stba	%r18, [%r26 + 0x0000] %asi
	.word 0xe097ce80  ! 2904: LDUHA_R	lduha	[%r31, %r0] 0x74, %r16
	mov	0x70, %r18
	.word 0x8780204f  ! 2906: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r27
	.word 0x87802025  ! 2908: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r18
	.word 0x87802025  ! 2910: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2911: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0d7e000  ! 2912: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r16
	.word 0xe0df2000  ! 2913: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r16
	.word 0xe0a72000  ! 2914: STWA_I	stwa	%r16, [%r28 + 0x0000] %asi
	.word 0xe0a72000  ! 2915: STWA_I	stwa	%r16, [%r28 + 0x0000] %asi
	.word 0xe097e000  ! 2916: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r16
	mov	0x60, %r17
	.word 0x87802073  ! 2918: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe08fe000  ! 2919: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r16
	.word 0xeadc4400  ! 2920: LDXA_R	ldxa	[%r17, %r0] 0x20, %r21
	.word 0xe2be09e0  ! 2921: STDA_R	stda	%r17, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 2922: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecd70e40  ! 2923: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r22
	.word 0xec8ca000  ! 2924: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r22
	.word 0xe2b74e60  ! 2925: STHA_R	stha	%r17, [%r29 + %r0] 0x73
	.word 0xe6870e80  ! 2926: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r19
	mov	0x20, %r25
	mov	0x38, %r26
	mov	0x20, %r17
	.word 0xecaf4e40  ! 2930: STBA_R	stba	%r22, [%r29 + %r0] 0x72
	.word 0xecf4a000  ! 2931: STXA_I	stxa	%r22, [%r18 + 0x0000] %asi
	.word 0xecf48400  ! 2932: STXA_R	stxa	%r22, [%r18 + %r0] 0x20
	.word 0xe4af4e80  ! 2933: STBA_R	stba	%r18, [%r29 + %r0] 0x74
	.word 0xe4b42000  ! 2934: STHA_I	stha	%r18, [%r16 + 0x0000] %asi
	.word 0xe4ac2000  ! 2935: STBA_I	stba	%r18, [%r16 + 0x0000] %asi
	.word 0xea8c0400  ! 2936: LDUBA_R	lduba	[%r16, %r0] 0x20, %r21
	.word 0xea9ce000  ! 2937: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r21
	.word 0xeac4a000  ! 2938: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r21
	.word 0x87802072  ! 2939: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0dc8400  ! 2940: LDXA_R	ldxa	[%r18, %r0] 0x20, %r16
	.word 0xe0a78e80  ! 2941: STWA_R	stwa	%r16, [%r30 + %r0] 0x74
	.word 0xe8ac4400  ! 2942: STBA_R	stba	%r20, [%r17 + %r0] 0x20
	mov	0x0, %r16
	.word 0xe8cf2000  ! 2944: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r20
	mov	0x60, %r27
	.word 0xeede89e0  ! 2946: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r23
	.word 0xeeaf6000  ! 2947: STBA_I	stba	%r23, [%r29 + 0x0000] %asi
	.word 0xeebf6000  ! 2948: STDA_I	stda	%r23, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2949: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r17
	.word 0xe6d74e40  ! 2951: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r19
	mov	0x3e8, %r20
	mov	0x10, %r26
	.word 0xee97ce80  ! 2954: LDUHA_R	lduha	[%r31, %r0] 0x74, %r23
	mov	0x18, %r18
	.word 0xeaf5c4a0  ! 2956: STXA_R	stxa	%r21, [%r23 + %r0] 0x25
	.word 0xe2be89e0  ! 2957: STDA_R	stda	%r17, [%r26 + %r0] 0x4f
	.word 0xe2842000  ! 2958: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r17
	.word 0x87802020  ! 2959: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r26
	.word 0xeca4c400  ! 2961: STWA_R	stwa	%r22, [%r19 + %r0] 0x20
	mov	0x58, %r25
	mov	0x28, %r19
	.word 0xe0f44400  ! 2964: STXA_R	stxa	%r16, [%r17 + %r0] 0x20
	.word 0xe6c74e80  ! 2965: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r19
	.word 0xe6d4e000  ! 2966: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r19
	mov	0x68, %r16
	.word 0xe28fce40  ! 2968: LDUBA_R	lduba	[%r31, %r0] 0x72, %r17
	.word 0x87802020  ! 2969: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2970: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe284a000  ! 2971: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r17
	.word 0xe2bcc400  ! 2972: STDA_R	stda	%r17, [%r19 + %r0] 0x20
	mov	0x48, %r25
	.word 0xe08d84a0  ! 2974: LDUBA_R	lduba	[%r22, %r0] 0x25, %r16
	.word 0xe09c6000  ! 2975: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r16
	mov	0x7d8, %r20
	mov	0x28, %r24
	.word 0x87802073  ! 2978: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0f7e000  ! 2979: STXA_I	stxa	%r16, [%r31 + 0x0000] %asi
	.word 0xe0b7a000  ! 2980: STHA_I	stha	%r16, [%r30 + 0x0000] %asi
	.word 0xe8b74e40  ! 2981: STHA_R	stha	%r20, [%r29 + %r0] 0x72
	.word 0xe8bf6000  ! 2982: STDA_I	stda	%r20, [%r29 + 0x0000] %asi
	.word 0xeeb4c400  ! 2983: STHA_R	stha	%r23, [%r19 + %r0] 0x20
	.word 0xeec7a000  ! 2984: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r23
	.word 0x87802025  ! 2985: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe48c8400  ! 2986: LDUBA_R	lduba	[%r18, %r0] 0x20, %r18
	mov	0x7f0, %r23
	.word 0xe8bdc4a0  ! 2988: STDA_R	stda	%r20, [%r23 + %r0] 0x25
	wr_tick_cmpr_0_26:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xad, %g2
	or	%g4, 0xef, %g4
	or	%g6, 0xec, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeab609e0  ! 2990: STHA_R	stha	%r21, [%r24 + %r0] 0x4f
	.word 0xea9da000  ! 2991: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r21
	.word 0xe6bc8400  ! 2992: STDA_R	stda	%r19, [%r18 + %r0] 0x20
	.word 0xe89f4e60  ! 2993: LDDA_R	ldda	[%r29, %r0] 0x73, %r20
	mov	0x20, %r26
	.word 0xeec7ce80  ! 2995: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r23
	.word 0xe8bd04a0  ! 2996: STDA_R	stda	%r20, [%r20 + %r0] 0x25
	mov	0x78, %r26
	.word 0x87802073  ! 2998: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8f72000  ! 2999: STXA_I	stxa	%r20, [%r28 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xe8dfa000  ! 3001: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r20
	.word 0x87802072  ! 3002: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3003: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3004: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3005: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xec974e40  ! 3006: LDUHA_R	lduha	[%r29, %r0] 0x72, %r22
	.word 0xecb70e60  ! 3007: STHA_R	stha	%r22, [%r28 + %r0] 0x73
	.word 0x87802072  ! 3008: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r19
	.word 0xec976000  ! 3010: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r22
	mov	0x10, %r18
	.word 0xe8944400  ! 3012: LDUHA_R	lduha	[%r17, %r0] 0x20, %r20
	.word 0xe2844400  ! 3013: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r17
	.word 0xecf70e60  ! 3014: STXA_R	stxa	%r22, [%r28 + %r0] 0x73
	.word 0x87802020  ! 3015: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4cf4e80  ! 3016: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r18
	mov	0x50, %r24
	.word 0xe68d84a0  ! 3018: LDUBA_R	lduba	[%r22, %r0] 0x25, %r19
	.word 0xe6a42000  ! 3019: STWA_I	stwa	%r19, [%r16 + 0x0000] %asi
	.word 0xe0bf4e60  ! 3020: STDA_R	stda	%r16, [%r29 + %r0] 0x73
	mov	0x7e0, %r21
	.word 0xeecf8e40  ! 3022: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r23
	.word 0xeef42000  ! 3023: STXA_I	stxa	%r23, [%r16 + 0x0000] %asi
	.word 0xe2be09e0  ! 3024: STDA_R	stda	%r17, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 3025: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0dc4400  ! 3026: LDXA_R	ldxa	[%r17, %r0] 0x20, %r16
	.word 0xea8e09e0  ! 3027: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r21
	.word 0xe0bf0e60  ! 3028: STDA_R	stda	%r16, [%r28 + %r0] 0x73
	mov	0x10, %r27
	.word 0xec9649e0  ! 3030: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r22
	mov	0x8, %r16
	.word 0xec85a000  ! 3032: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r22
	.word 0xea878e60  ! 3033: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r21
	mov	0x3d0, %r20
	.word 0xeaa5e000  ! 3035: STWA_I	stwa	%r21, [%r23 + 0x0000] %asi
	.word 0xea85e000  ! 3036: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r21
	mov	0x50, %r27
	.word 0xe8cc0400  ! 3038: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r20
	.word 0xe4d70e60  ! 3039: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r18
	.word 0x87802020  ! 3040: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2ac4400  ! 3041: STBA_R	stba	%r17, [%r17 + %r0] 0x20
	.word 0xe2d4a000  ! 3042: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r17
	.word 0x87802025  ! 3043: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8cc4400  ! 3044: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r20
	.word 0x87802020  ! 3045: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8a42000  ! 3046: STWA_I	stwa	%r20, [%r16 + 0x0000] %asi
	.word 0xe8dce000  ! 3047: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r20
	.word 0xe8946000  ! 3048: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r20
	.word 0xeadd84a0  ! 3049: LDXA_R	ldxa	[%r22, %r0] 0x25, %r21
	.word 0xeaf4a000  ! 3050: STXA_I	stxa	%r21, [%r18 + 0x0000] %asi
	.word 0xe4c74e60  ! 3051: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r18
	mov	0x70, %r18
	mov	0x8, %r25
	.word 0xe8f40400  ! 3054: STXA_R	stxa	%r20, [%r16 + %r0] 0x20
	.word 0xe6af4e80  ! 3055: STBA_R	stba	%r19, [%r29 + %r0] 0x74
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x18, %r19
	mov	0x70, %r27
	.word 0x87802073  ! 3059: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6f76000  ! 3060: STXA_I	stxa	%r19, [%r29 + 0x0000] %asi
	.word 0xecdfce80  ! 3061: LDXA_R	ldxa	[%r31, %r0] 0x74, %r22
	.word 0xecdf2000  ! 3062: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r22
	mov	0x48, %r19
	.word 0xe08504a0  ! 3064: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r16
	.word 0xe0f76000  ! 3065: STXA_I	stxa	%r16, [%r29 + 0x0000] %asi
	.word 0xecbd04a0  ! 3066: STDA_R	stda	%r22, [%r20 + %r0] 0x25
	.word 0xecaf6000  ! 3067: STBA_I	stba	%r22, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3068: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec8c2000  ! 3069: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r22
	.word 0xe69c8400  ! 3070: LDDA_R	ldda	[%r18, %r0] 0x20, %r19
	.word 0xecc78e40  ! 3071: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r22
	.word 0xe2af8e80  ! 3072: STBA_R	stba	%r17, [%r30 + %r0] 0x74
	.word 0x87802020  ! 3073: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3074: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2df6000  ! 3075: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r17
	.word 0xe29fe000  ! 3076: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r17
	.word 0xe68f0e40  ! 3077: LDUBA_R	lduba	[%r28, %r0] 0x72, %r19
	.word 0xe6a7a000  ! 3078: STWA_I	stwa	%r19, [%r30 + 0x0000] %asi
	mov	0x7c8, %r21
	mov	0x3f8, %r21
	.word 0x87802073  ! 3081: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6b72000  ! 3082: STHA_I	stha	%r19, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3083: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	.word 0xe0974e40  ! 3085: LDUHA_R	lduha	[%r29, %r0] 0x72, %r16
	.word 0xe0a46000  ! 3086: STWA_I	stwa	%r16, [%r17 + 0x0000] %asi
	.word 0xe4b7ce60  ! 3087: STHA_R	stha	%r18, [%r31 + %r0] 0x73
	.word 0x87802025  ! 3088: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3089: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r18
	mov	0x38, %r16
	.word 0xe8bf8e40  ! 3092: STDA_R	stda	%r20, [%r30 + %r0] 0x72
	.word 0x87802074  ! 3093: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3094: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8a46000  ! 3095: STWA_I	stwa	%r20, [%r17 + 0x0000] %asi
	.word 0xe89ce000  ! 3096: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r20
	.word 0xe8c4e000  ! 3097: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r20
	.word 0xe8c4e000  ! 3098: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r20
	.word 0x87802020  ! 3099: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe88ce000  ! 3100: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r20
	mov	0x7f0, %r23
	.word 0xea870e40  ! 3102: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r21
	.word 0xe097ce60  ! 3103: LDUHA_R	lduha	[%r31, %r0] 0x73, %r16
	mov	0x30, %r24
	mov	0x7f8, %r22
	.word 0xe0bce000  ! 3106: STDA_I	stda	%r16, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3107: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeacc8400  ! 3108: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r21
	.word 0x87802073  ! 3109: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xec8f8e40  ! 3110: LDUBA_R	lduba	[%r30, %r0] 0x72, %r22
	mov	0x20, %r16
	.word 0xeed78e40  ! 3112: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r23
	.word 0xeca504a0  ! 3113: STWA_R	stwa	%r22, [%r20 + %r0] 0x25
	.word 0xec8f6000  ! 3114: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	.word 0xeea5c4a0  ! 3115: STWA_R	stwa	%r23, [%r23 + %r0] 0x25
	.word 0xec9e09e0  ! 3116: LDDA_R	ldda	[%r24, %r0] 0x4f, %r22
	mov	0x7e0, %r23
	.word 0xee874e40  ! 3118: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r23
	.word 0xeedf6000  ! 3119: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r23
	mov	0x50, %r19
	.word 0xeed72000  ! 3121: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r23
	.word 0x87802072  ! 3122: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xee872000  ! 3123: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r23
	.word 0xe48fce60  ! 3124: LDUBA_R	lduba	[%r31, %r0] 0x73, %r18
	.word 0xe4f76000  ! 3125: STXA_I	stxa	%r18, [%r29 + 0x0000] %asi
	.word 0xea9f8e60  ! 3126: LDDA_R	ldda	[%r30, %r0] 0x73, %r21
	.word 0xea9f2000  ! 3127: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r21
	mov	0x10, %r18
	.word 0xeabfe000  ! 3129: STDA_I	stda	%r21, [%r31 + 0x0000] %asi
	.word 0xeabf2000  ! 3130: STDA_I	stda	%r21, [%r28 + 0x0000] %asi
	.word 0xe29609e0  ! 3131: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r17
	.word 0xe2f76000  ! 3132: STXA_I	stxa	%r17, [%r29 + 0x0000] %asi
	.word 0xe09d84a0  ! 3133: LDDA_R	ldda	[%r22, %r0] 0x25, %r16
	mov	0x50, %r24
	.word 0xeead04a0  ! 3135: STBA_R	stba	%r23, [%r20 + %r0] 0x25
	.word 0xeeafa000  ! 3136: STBA_I	stba	%r23, [%r30 + 0x0000] %asi
	.word 0xecd5c4a0  ! 3137: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r22
	mov	0x3d8, %r23
	.word 0xecaf2000  ! 3139: STBA_I	stba	%r22, [%r28 + 0x0000] %asi
	wr_tick_cmpr_0_27:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd4, %g2
	or	%g4, 0xa9, %g4
	or	%g6, 0x85, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x40, %r25
	.word 0x87802020  ! 3142: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecc46000  ! 3143: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r22
	.word 0xecf42000  ! 3144: STXA_I	stxa	%r22, [%r16 + 0x0000] %asi
	.word 0xecac2000  ! 3145: STBA_I	stba	%r22, [%r16 + 0x0000] %asi
	.word 0xe6a7ce40  ! 3146: STWA_R	stwa	%r19, [%r31 + %r0] 0x72
	.word 0xe6946000  ! 3147: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r19
	.word 0x87802020  ! 3148: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6940400  ! 3149: LDUHA_R	lduha	[%r16, %r0] 0x20, %r19
	mov	0x40, %r24
	.word 0xe6cc2000  ! 3151: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r19
	mov	0x3e0, %r22
	.word 0x87802025  ! 3153: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6a52000  ! 3154: STWA_I	stwa	%r19, [%r20 + 0x0000] %asi
	.word 0xeccc4400  ! 3155: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r22
	.word 0xecada000  ! 3156: STBA_I	stba	%r22, [%r22 + 0x0000] %asi
	.word 0xe4cf0e80  ! 3157: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r18
	mov	0x38, %r18
	mov	0x3c8, %r21
	mov	0x38, %r19
	mov	0x7c8, %r23
	mov	0x58, %r16
	mov	0x58, %r16
	.word 0xe4b5e000  ! 3164: STHA_I	stha	%r18, [%r23 + 0x0000] %asi
	.word 0xe0bcc400  ! 3165: STDA_R	stda	%r16, [%r19 + %r0] 0x20
	.word 0xe0d56000  ! 3166: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r16
	.word 0x87802072  ! 3167: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0dfe000  ! 3168: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r16
	mov	0x40, %r19
	.word 0xe09fe000  ! 3170: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r16
	.word 0xe09fe000  ! 3171: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r16
	.word 0xe0bc8400  ! 3172: STDA_R	stda	%r16, [%r18 + %r0] 0x20
	.word 0xe0b72000  ! 3173: STHA_I	stha	%r16, [%r28 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xe09c0400  ! 3175: LDDA_R	ldda	[%r16, %r0] 0x20, %r16
	.word 0xecaec9e0  ! 3176: STBA_R	stba	%r22, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 3177: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeab7ce40  ! 3178: STHA_R	stha	%r21, [%r31 + %r0] 0x72
	.word 0xeadca000  ! 3179: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r21
	mov	0x3e8, %r21
	.word 0xe0a78e40  ! 3181: STWA_R	stwa	%r16, [%r30 + %r0] 0x72
	.word 0xe88c4400  ! 3182: LDUBA_R	lduba	[%r17, %r0] 0x20, %r20
	.word 0xe8d78e60  ! 3183: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r20
	.word 0xe894a000  ! 3184: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r20
	.word 0xe2bc4400  ! 3185: STDA_R	stda	%r17, [%r17 + %r0] 0x20
	mov	0x68, %r16
	.word 0x8780204f  ! 3187: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2dea000  ! 3188: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r17
	.word 0xe2f66000  ! 3189: STXA_I	stxa	%r17, [%r25 + 0x0000] %asi
	.word 0xeacd04a0  ! 3190: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r21
	.word 0xe0d70e60  ! 3191: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r16
	.word 0xe0c62000  ! 3192: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r16
	.word 0xe09609e0  ! 3193: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r16
	.word 0xe6bec9e0  ! 3194: STDA_R	stda	%r19, [%r27 + %r0] 0x4f
	.word 0xe0978e60  ! 3195: LDUHA_R	lduha	[%r30, %r0] 0x73, %r16
	mov	0x7c0, %r23
	.word 0x87802073  ! 3197: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0cf6000  ! 3198: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r16
	mov	0x28, %r16
	.word 0x87802072  ! 3200: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r19
	.word 0xe0c7e000  ! 3202: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r16
	mov	0x8, %r19
	mov	0x7d8, %r21
	mov	0x40, %r19
	mov	0x60, %r24
	.word 0xe097a000  ! 3207: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r16
	mov	0x3f8, %r22
	.word 0xecdd04a0  ! 3209: LDXA_R	ldxa	[%r20, %r0] 0x25, %r22
	.word 0x87802025  ! 3210: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecc52000  ! 3211: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r22
	.word 0x87802074  ! 3212: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeacf0e60  ! 3213: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r21
	.word 0x87802020  ! 3214: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r22
	.word 0x8780204f  ! 3216: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xea96a000  ! 3217: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r21
	.word 0xe6bf8e80  ! 3218: STDA_R	stda	%r19, [%r30 + %r0] 0x74
	.word 0xeac48400  ! 3219: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r21
	.word 0xe2a689e0  ! 3220: STWA_R	stwa	%r17, [%r26 + %r0] 0x4f
	.word 0xe29ea000  ! 3221: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r17
	.word 0xe2b62000  ! 3222: STHA_I	stha	%r17, [%r24 + 0x0000] %asi
	.word 0xe48c8400  ! 3223: LDUBA_R	lduba	[%r18, %r0] 0x20, %r18
	.word 0xe48ee000  ! 3224: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r18
	mov	0x7d8, %r23
	.word 0xe4f689e0  ! 3226: STXA_R	stxa	%r18, [%r26 + %r0] 0x4f
	.word 0xe496e000  ! 3227: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r18
	mov	0x30, %r27
	.word 0x87802020  ! 3229: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3230: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3231: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3232: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r26
	.word 0x87802074  ! 3234: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4b4c400  ! 3235: STHA_R	stha	%r18, [%r19 + %r0] 0x20
	.word 0xec87ce60  ! 3236: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r22
	.word 0xe6afce80  ! 3237: STBA_R	stba	%r19, [%r31 + %r0] 0x74
	.word 0x87802025  ! 3238: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe097ce80  ! 3239: LDUHA_R	lduha	[%r31, %r0] 0x74, %r16
	.word 0xeef44400  ! 3240: STXA_R	stxa	%r23, [%r17 + %r0] 0x20
	.word 0xe8cf4e80  ! 3241: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r20
	mov	0x48, %r24
	.word 0xeedf8e80  ! 3243: LDXA_R	ldxa	[%r30, %r0] 0x74, %r23
	mov	0x40, %r24
	mov	0x40, %r18
	.word 0x87802074  ! 3246: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6a609e0  ! 3247: STWA_R	stwa	%r19, [%r24 + %r0] 0x4f
	.word 0xe687a000  ! 3248: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r19
	.word 0xe6cfe000  ! 3249: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r19
	.word 0xe8f78e80  ! 3250: STXA_R	stxa	%r20, [%r30 + %r0] 0x74
	.word 0xe8b7a000  ! 3251: STHA_I	stha	%r20, [%r30 + 0x0000] %asi
	.word 0xee9cc400  ! 3252: LDDA_R	ldda	[%r19, %r0] 0x20, %r23
	mov	0x68, %r27
	mov	0x3c8, %r20
	.word 0x8780204f  ! 3255: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3256: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r18
	.word 0xeea42000  ! 3258: STWA_I	stwa	%r23, [%r16 + 0x0000] %asi
	.word 0xeea42000  ! 3259: STWA_I	stwa	%r23, [%r16 + 0x0000] %asi
	.word 0xeebc2000  ! 3260: STDA_I	stda	%r23, [%r16 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xeecc6000  ! 3262: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r23
	.word 0xee9c2000  ! 3263: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r23
	.word 0xec95c4a0  ! 3264: LDUHA_R	lduha	[%r23, %r0] 0x25, %r22
	.word 0xec9c8400  ! 3265: LDDA_R	ldda	[%r18, %r0] 0x20, %r22
	.word 0x87802073  ! 3266: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3267: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r23
	.word 0xeccfa000  ! 3269: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r22
	.word 0xecf7a000  ! 3270: STXA_I	stxa	%r22, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 3271: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe29f8e60  ! 3272: LDDA_R	ldda	[%r30, %r0] 0x73, %r17
	.word 0xe4b48400  ! 3273: STHA_R	stha	%r18, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3274: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe484a000  ! 3275: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r18
	.word 0xecd584a0  ! 3276: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r22
	mov	0x7f8, %r22
	.word 0xe4b6c9e0  ! 3278: STHA_R	stha	%r18, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 3279: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8b544a0  ! 3280: STHA_R	stha	%r20, [%r21 + %r0] 0x25
	.word 0xe8bca000  ! 3281: STDA_I	stda	%r20, [%r18 + 0x0000] %asi
	.word 0xeaa504a0  ! 3282: STWA_R	stwa	%r21, [%r20 + %r0] 0x25
	mov	0x8, %r27
	.word 0xeab46000  ! 3284: STHA_I	stha	%r21, [%r17 + 0x0000] %asi
	.word 0xeabc2000  ! 3285: STDA_I	stda	%r21, [%r16 + 0x0000] %asi
	.word 0xe8df0e40  ! 3286: LDXA_R	ldxa	[%r28, %r0] 0x72, %r20
	.word 0xe6ccc400  ! 3287: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r19
	.word 0xe684e000  ! 3288: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r19
	.word 0xe684e000  ! 3289: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r19
	.word 0xe6cca000  ! 3290: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r19
	mov	0x3d0, %r23
	.word 0xeca74e60  ! 3292: STWA_R	stwa	%r22, [%r29 + %r0] 0x73
	mov	0x8, %r16
	.word 0xe2d7ce60  ! 3294: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r17
	mov	0x68, %r27
	.word 0x8780204f  ! 3296: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r18
	.word 0x87802020  ! 3298: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3299: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8a74e80  ! 3300: STWA_R	stwa	%r20, [%r29 + %r0] 0x74
	.word 0xe8f76000  ! 3301: STXA_I	stxa	%r20, [%r29 + 0x0000] %asi
	.word 0xeab5c4a0  ! 3302: STHA_R	stha	%r21, [%r23 + %r0] 0x25
	.word 0xe0b78e60  ! 3303: STHA_R	stha	%r16, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 3304: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r19
	.word 0xe0c6a000  ! 3306: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r16
	wr_tick_cmpr_0_28:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe8, %g2
	or	%g4, 0xef, %g4
	or	%g6, 0x94, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x40, %r16
	.word 0xe0bea000  ! 3309: STDA_I	stda	%r16, [%r26 + 0x0000] %asi
	.word 0xe2f544a0  ! 3310: STXA_R	stxa	%r17, [%r21 + %r0] 0x25
	.word 0xe2966000  ! 3311: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r17
	.word 0xe2d6a000  ! 3312: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r17
	.word 0xe2c62000  ! 3313: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r17
	.word 0xe2be2000  ! 3314: STDA_I	stda	%r17, [%r24 + 0x0000] %asi
	.word 0xe2a62000  ! 3315: STWA_I	stwa	%r17, [%r24 + 0x0000] %asi
	.word 0xe2ce6000  ! 3316: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r17
	.word 0xe2d74e80  ! 3317: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r17
	mov	0x60, %r25
	.word 0xe2ce2000  ! 3319: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r17
	.word 0xe2c66000  ! 3320: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r17
	.word 0xe2862000  ! 3321: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r17
	.word 0xe2cea000  ! 3322: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r17
	mov	0x10, %r24
	.word 0xe0ae09e0  ! 3324: STBA_R	stba	%r16, [%r24 + %r0] 0x4f
	.word 0xeaaf8e60  ! 3325: STBA_R	stba	%r21, [%r30 + %r0] 0x73
	.word 0x87802020  ! 3326: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeab4e000  ! 3327: STHA_I	stha	%r21, [%r19 + 0x0000] %asi
	.word 0xe89f4e80  ! 3328: LDDA_R	ldda	[%r29, %r0] 0x74, %r20
	.word 0xe495c4a0  ! 3329: LDUHA_R	lduha	[%r23, %r0] 0x25, %r18
	.word 0xe49ca000  ! 3330: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r18
	.word 0xe4b4a000  ! 3331: STHA_I	stha	%r18, [%r18 + 0x0000] %asi
	mov	0x18, %r24
	mov	0x7e0, %r22
	.word 0xe4d42000  ! 3334: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r18
	.word 0xe4cc6000  ! 3335: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r18
	.word 0xe0c584a0  ! 3336: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r16
	mov	0x70, %r16
	.word 0xee878e80  ! 3338: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r23
	mov	0x28, %r26
	.word 0xeeac2000  ! 3340: STBA_I	stba	%r23, [%r16 + 0x0000] %asi
	.word 0xee8ce000  ! 3341: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r23
	mov	0x38, %r26
	.word 0xeef42000  ! 3343: STXA_I	stxa	%r23, [%r16 + 0x0000] %asi
	.word 0xeeb4a000  ! 3344: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	mov	0x0, %r18
	.word 0x8780204f  ! 3346: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe48dc4a0  ! 3347: LDUBA_R	lduba	[%r23, %r0] 0x25, %r18
	.word 0xeccc4400  ! 3348: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r22
	.word 0xec962000  ! 3349: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r22
	.word 0x87802020  ! 3350: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xee9544a0  ! 3351: LDUHA_R	lduha	[%r21, %r0] 0x25, %r23
	.word 0xee8ca000  ! 3352: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r23
	.word 0xeebc6000  ! 3353: STDA_I	stda	%r23, [%r17 + 0x0000] %asi
	.word 0xeea4e000  ! 3354: STWA_I	stwa	%r23, [%r19 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xecf44400  ! 3356: STXA_R	stxa	%r22, [%r17 + %r0] 0x20
	.word 0x87802025  ! 3357: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecb5e000  ! 3358: STHA_I	stha	%r22, [%r23 + 0x0000] %asi
	mov	0x18, %r24
	mov	0x7c0, %r23
	mov	0x3d8, %r21
	mov	0x68, %r17
	.word 0xec8de000  ! 3363: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r22
	mov	0x28, %r27
	.word 0x8780204f  ! 3365: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecdee000  ! 3366: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r22
	mov	0x68, %r24
	mov	0x8, %r19
	.word 0x87802020  ! 3369: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0dd04a0  ! 3370: LDXA_R	ldxa	[%r20, %r0] 0x25, %r16
	.word 0xe8cc0400  ! 3371: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r20
	.word 0xe88c2000  ! 3372: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r20
	mov	0x7c8, %r23
	.word 0xe8bca000  ! 3374: STDA_I	stda	%r20, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3375: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r26
	.word 0xe68f8e40  ! 3377: LDUBA_R	lduba	[%r30, %r0] 0x72, %r19
	.word 0x8780204f  ! 3378: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xee9f0e80  ! 3379: LDDA_R	ldda	[%r28, %r0] 0x74, %r23
	.word 0x87802072  ! 3380: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe68cc400  ! 3381: LDUBA_R	lduba	[%r19, %r0] 0x20, %r19
	.word 0xe6a7a000  ! 3382: STWA_I	stwa	%r19, [%r30 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xe6bcc400  ! 3384: STDA_R	stda	%r19, [%r19 + %r0] 0x20
	.word 0xe6a76000  ! 3385: STWA_I	stwa	%r19, [%r29 + 0x0000] %asi
	mov	0x3c8, %r22
	mov	0x28, %r17
	mov	0x7c0, %r20
	.word 0xe8bfce40  ! 3389: STDA_R	stda	%r20, [%r31 + %r0] 0x72
	.word 0xea9504a0  ! 3390: LDUHA_R	lduha	[%r20, %r0] 0x25, %r21
	.word 0xea8fe000  ! 3391: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r21
	.word 0xe4878e40  ! 3392: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r18
	.word 0xe4d7a000  ! 3393: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r18
	.word 0xe4972000  ! 3394: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r18
	mov	0x10, %r27
	.word 0xe4976000  ! 3396: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r18
	.word 0xe4f48400  ! 3397: STXA_R	stxa	%r18, [%r18 + %r0] 0x20
	.word 0xe4df6000  ! 3398: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r18
	.word 0x87802025  ! 3399: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0a584a0  ! 3400: STWA_R	stwa	%r16, [%r22 + %r0] 0x25
	mov	0x38, %r19
	.word 0x87802025  ! 3402: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0b5a000  ! 3403: STHA_I	stha	%r16, [%r22 + 0x0000] %asi
	.word 0xe08d6000  ! 3404: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r16
	mov	0x20, %r25
	.word 0xeadec9e0  ! 3406: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r21
	mov	0x70, %r18
	.word 0xeab52000  ! 3408: STHA_I	stha	%r21, [%r20 + 0x0000] %asi
	.word 0xe0bfce80  ! 3409: STDA_R	stda	%r16, [%r31 + %r0] 0x74
	mov	0x40, %r24
	.word 0x87802020  ! 3411: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	mov	0x58, %r16
	.word 0x87802020  ! 3414: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaa689e0  ! 3415: STWA_R	stwa	%r21, [%r26 + %r0] 0x4f
	.word 0xea8ce000  ! 3416: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r21
	.word 0xea8c2000  ! 3417: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r21
	.word 0xea9ca000  ! 3418: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r21
	.word 0xee96c9e0  ! 3419: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r23
	.word 0xeebc2000  ! 3420: STDA_I	stda	%r23, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 3421: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r24
	.word 0xee876000  ! 3423: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r23
	.word 0xe88f4e80  ! 3424: LDUBA_R	lduba	[%r29, %r0] 0x74, %r20
	.word 0xe8a70e80  ! 3425: STWA_R	stwa	%r20, [%r28 + %r0] 0x74
	.word 0x87802020  ! 3426: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeec74e80  ! 3427: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r23
	mov	0x70, %r19
	.word 0x87802074  ! 3429: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 3430: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r16
	.word 0xe6bc4400  ! 3432: STDA_R	stda	%r19, [%r17 + %r0] 0x20
	.word 0x87802073  ! 3433: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6bf6000  ! 3434: STDA_I	stda	%r19, [%r29 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xe6dc4400  ! 3436: LDXA_R	ldxa	[%r17, %r0] 0x20, %r19
	.word 0xe2cf0e40  ! 3437: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r17
	mov	0x3d0, %r22
	.word 0xe8f74e80  ! 3439: STXA_R	stxa	%r20, [%r29 + %r0] 0x74
	.word 0xe8b7a000  ! 3440: STHA_I	stha	%r20, [%r30 + 0x0000] %asi
	.word 0xe4b544a0  ! 3441: STHA_R	stha	%r18, [%r21 + %r0] 0x25
	.word 0xe2dfce40  ! 3442: LDXA_R	ldxa	[%r31, %r0] 0x72, %r17
	.word 0xe2d44400  ! 3443: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r17
	.word 0xe8d7ce40  ! 3444: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r20
	.word 0xe8d7a000  ! 3445: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r20
	.word 0x87802074  ! 3446: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe897e000  ! 3447: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r20
	.word 0x87802020  ! 3448: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeef74e40  ! 3449: STXA_R	stxa	%r23, [%r29 + %r0] 0x72
	.word 0xee84a000  ! 3450: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r23
	.word 0xee8c2000  ! 3451: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r23
	.word 0xeeac2000  ! 3452: STBA_I	stba	%r23, [%r16 + 0x0000] %asi
	mov	0x68, %r19
	mov	0x58, %r25
	mov	0x70, %r18
	.word 0xecbc4400  ! 3456: STDA_R	stda	%r22, [%r17 + %r0] 0x20
	.word 0xecf70e40  ! 3457: STXA_R	stxa	%r22, [%r28 + %r0] 0x72
	.word 0xecaca000  ! 3458: STBA_I	stba	%r22, [%r18 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xe0f70e60  ! 3460: STXA_R	stxa	%r16, [%r28 + %r0] 0x73
	.word 0xe09c2000  ! 3461: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r16
	.word 0xe48e09e0  ! 3462: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r18
	.word 0xecf4c400  ! 3463: STXA_R	stxa	%r22, [%r19 + %r0] 0x20
	.word 0xecaca000  ! 3464: STBA_I	stba	%r22, [%r18 + 0x0000] %asi
	.word 0xecc7ce60  ! 3465: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r22
	.word 0x87802074  ! 3466: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xecd70e60  ! 3467: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r22
	.word 0xecaf6000  ! 3468: STBA_I	stba	%r22, [%r29 + 0x0000] %asi
	.word 0xeaf74e40  ! 3469: STXA_R	stxa	%r21, [%r29 + %r0] 0x72
	mov	0x60, %r19
	.word 0xeac76000  ! 3471: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r21
	.word 0xe0afce60  ! 3472: STBA_R	stba	%r16, [%r31 + %r0] 0x73
	.word 0xe0bfa000  ! 3473: STDA_I	stda	%r16, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3474: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3475: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r27
	.word 0xe0a72000  ! 3477: STWA_I	stwa	%r16, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 3478: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3479: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8b7ce60  ! 3480: STHA_R	stha	%r20, [%r31 + %r0] 0x73
	.word 0xe8c72000  ! 3481: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r20
	.word 0xe8af6000  ! 3482: STBA_I	stba	%r20, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3483: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0940400  ! 3484: LDUHA_R	lduha	[%r16, %r0] 0x20, %r16
	.word 0xe0b42000  ! 3485: STHA_I	stha	%r16, [%r16 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xe0d42000  ! 3487: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r16
	mov	0x20, %r27
	.word 0x87802020  ! 3489: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe48c4400  ! 3490: LDUBA_R	lduba	[%r17, %r0] 0x20, %r18
	.word 0xe2c689e0  ! 3491: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r17
	.word 0xecb7ce80  ! 3492: STHA_R	stha	%r22, [%r31 + %r0] 0x74
	.word 0xe8bf0e80  ! 3493: STDA_R	stda	%r20, [%r28 + %r0] 0x74
	.word 0xeca7ce80  ! 3494: STWA_R	stwa	%r22, [%r31 + %r0] 0x74
	mov	0x30, %r25
	.word 0xe2a78e60  ! 3496: STWA_R	stwa	%r17, [%r30 + %r0] 0x73
	.word 0xe2dc2000  ! 3497: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r17
	.word 0xe0ad84a0  ! 3498: STBA_R	stba	%r16, [%r22 + %r0] 0x25
	.word 0xe0f4e000  ! 3499: STXA_I	stxa	%r16, [%r19 + 0x0000] %asi
	.word 0xe084c400  ! 3500: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r16
	mov	0x7d8, %r22
	.word 0xe0bc2000  ! 3502: STDA_I	stda	%r16, [%r16 + 0x0000] %asi
	.word 0xe0a42000  ! 3503: STWA_I	stwa	%r16, [%r16 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xe08c2000  ! 3505: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r16
	.word 0xe2bcc400  ! 3506: STDA_R	stda	%r17, [%r19 + %r0] 0x20
	.word 0xe2de09e0  ! 3507: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r17
	wr_tick_cmpr_0_29:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb9, %g2
	or	%g4, 0xed, %g4
	or	%g6, 0xff, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeccc8400  ! 3509: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r22
	.word 0xec9f8e80  ! 3510: LDDA_R	ldda	[%r30, %r0] 0x74, %r22
	.word 0x87802072  ! 3511: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe69e09e0  ! 3512: LDDA_R	ldda	[%r24, %r0] 0x4f, %r19
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xeab70e60  ! 3514: STHA_R	stha	%r21, [%r28 + %r0] 0x73
	.word 0xe0878e80  ! 3515: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r16
	.word 0xe8b70e80  ! 3516: STHA_R	stha	%r20, [%r28 + %r0] 0x74
	.word 0xe8afa000  ! 3517: STBA_I	stba	%r20, [%r30 + 0x0000] %asi
	.word 0xe8a7e000  ! 3518: STWA_I	stwa	%r20, [%r31 + 0x0000] %asi
	.word 0xe8876000  ! 3519: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r20
	.word 0xe8c72000  ! 3520: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r20
	.word 0x87802074  ! 3521: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeeaf8e60  ! 3522: STBA_R	stba	%r23, [%r30 + %r0] 0x73
	.word 0xee876000  ! 3523: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r23
	.word 0xe8df4e80  ! 3524: LDXA_R	ldxa	[%r29, %r0] 0x74, %r20
	mov	0x7f0, %r23
	.word 0xe2bc0400  ! 3526: STDA_R	stda	%r17, [%r16 + %r0] 0x20
	.word 0xecb70e80  ! 3527: STHA_R	stha	%r22, [%r28 + %r0] 0x74
	.word 0xe2b70e40  ! 3528: STHA_R	stha	%r17, [%r28 + %r0] 0x72
	.word 0xea8f8e40  ! 3529: LDUBA_R	lduba	[%r30, %r0] 0x72, %r21
	.word 0xe0c7ce40  ! 3530: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r16
	.word 0xe0bfa000  ! 3531: STDA_I	stda	%r16, [%r30 + 0x0000] %asi
	.word 0xe0bfa000  ! 3532: STDA_I	stda	%r16, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3533: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0d42000  ! 3534: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r16
	.word 0x87802073  ! 3535: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3536: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeca44400  ! 3537: STWA_R	stwa	%r22, [%r17 + %r0] 0x20
	.word 0x87802025  ! 3538: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xea8fce60  ! 3539: LDUBA_R	lduba	[%r31, %r0] 0x73, %r21
	.word 0x87802020  ! 3540: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r21
	.word 0x87802020  ! 3542: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3543: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 3544: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xead7a000  ! 3545: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r21
	mov	0x70, %r25
	mov	0x38, %r26
	.word 0xea972000  ! 3548: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r21
	.word 0x87802025  ! 3549: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeaada000  ! 3550: STBA_I	stba	%r21, [%r22 + 0x0000] %asi
	mov	0x78, %r24
	.word 0x87802025  ! 3552: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecc44400  ! 3553: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r22
	.word 0xecbde000  ! 3554: STDA_I	stda	%r22, [%r23 + 0x0000] %asi
	.word 0xe6a689e0  ! 3555: STWA_R	stwa	%r19, [%r26 + %r0] 0x4f
	.word 0xecc40400  ! 3556: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r22
	.word 0xecbd6000  ! 3557: STDA_I	stda	%r22, [%r21 + 0x0000] %asi
	.word 0xeaa48400  ! 3558: STWA_R	stwa	%r21, [%r18 + %r0] 0x20
	mov	0x3d8, %r22
	mov	0x3c0, %r20
	.word 0x87802074  ! 3561: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeeb70e60  ! 3562: STHA_R	stha	%r23, [%r28 + %r0] 0x73
	mov	0x38, %r26
	.word 0x87802072  ! 3564: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeebfa000  ! 3565: STDA_I	stda	%r23, [%r30 + 0x0000] %asi
	.word 0xeeaf2000  ! 3566: STBA_I	stba	%r23, [%r28 + 0x0000] %asi
	.word 0xeeafe000  ! 3567: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0xeea7e000  ! 3568: STWA_I	stwa	%r23, [%r31 + 0x0000] %asi
	.word 0xe0d48400  ! 3569: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r16
	mov	0x3e0, %r22
	mov	0x70, %r16
	mov	0x20, %r17
	mov	0x3d0, %r21
	.word 0xe0dd04a0  ! 3574: LDXA_R	ldxa	[%r20, %r0] 0x25, %r16
	.word 0xeec7ce40  ! 3575: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r23
	.word 0xeec76000  ! 3576: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r23
	.word 0xe0c44400  ! 3577: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r16
	mov	0x7e0, %r20
	.word 0xe0af6000  ! 3579: STBA_I	stba	%r16, [%r29 + 0x0000] %asi
	.word 0xe0f72000  ! 3580: STXA_I	stxa	%r16, [%r28 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xe0b7a000  ! 3582: STHA_I	stha	%r16, [%r30 + 0x0000] %asi
	.word 0xe0afa000  ! 3583: STBA_I	stba	%r16, [%r30 + 0x0000] %asi
	.word 0xe0cf6000  ! 3584: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r16
	mov	0x18, %r27
	.word 0x87802074  ! 3586: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8a4c400  ! 3587: STWA_R	stwa	%r20, [%r19 + %r0] 0x20
	.word 0xe8af2000  ! 3588: STBA_I	stba	%r20, [%r28 + 0x0000] %asi
	.word 0xead4c400  ! 3589: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r21
	.word 0xeabf6000  ! 3590: STDA_I	stda	%r21, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3591: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeaa7e000  ! 3592: STWA_I	stwa	%r21, [%r31 + 0x0000] %asi
	.word 0xe0af4e40  ! 3593: STBA_R	stba	%r16, [%r29 + %r0] 0x72
	mov	0x30, %r25
	.word 0xecf74e80  ! 3595: STXA_R	stxa	%r22, [%r29 + %r0] 0x74
	.word 0x87802020  ! 3596: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec94a000  ! 3597: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r22
	.word 0xe0d584a0  ! 3598: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r16
	mov	0x3d8, %r22
	mov	0x70, %r26
	.word 0x87802072  ! 3601: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r26
	.word 0xe0872000  ! 3603: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r16
	mov	0x48, %r26
	.word 0xe0d72000  ! 3605: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r16
	.word 0xe0cd04a0  ! 3606: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r16
	.word 0xecdc0400  ! 3607: LDXA_R	ldxa	[%r16, %r0] 0x20, %r22
	.word 0xecc76000  ! 3608: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0xecafe000  ! 3609: STBA_I	stba	%r22, [%r31 + 0x0000] %asi
	mov	0x28, %r19
	mov	0x10, %r26
	.word 0xecf7a000  ! 3612: STXA_I	stxa	%r22, [%r30 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xec8689e0  ! 3614: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r22
	.word 0xecf7a000  ! 3615: STXA_I	stxa	%r22, [%r30 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xecf76000  ! 3617: STXA_I	stxa	%r22, [%r29 + 0x0000] %asi
	.word 0xecc7a000  ! 3618: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r22
	mov	0x40, %r26
	.word 0xe4a44400  ! 3620: STWA_R	stwa	%r18, [%r17 + %r0] 0x20
	.word 0xe8dfce80  ! 3621: LDXA_R	ldxa	[%r31, %r0] 0x74, %r20
	.word 0xe4cfce60  ! 3622: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r18
	.word 0xe49f2000  ! 3623: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r18
	.word 0xe8bc8400  ! 3624: STDA_R	stda	%r20, [%r18 + %r0] 0x20
	.word 0xe0cf8e40  ! 3625: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r16
	.word 0xe6f78e80  ! 3626: STXA_R	stxa	%r19, [%r30 + %r0] 0x74
	.word 0xe8b70e40  ! 3627: STHA_R	stha	%r20, [%r28 + %r0] 0x72
	.word 0xe6a44400  ! 3628: STWA_R	stwa	%r19, [%r17 + %r0] 0x20
	.word 0x87802072  ! 3629: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r26
	.word 0xe69fe000  ! 3631: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r19
	.word 0xe6afa000  ! 3632: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	.word 0xe6bfa000  ! 3633: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xea8f8e40  ! 3634: LDUBA_R	lduba	[%r30, %r0] 0x72, %r21
	.word 0xead72000  ! 3635: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r21
	.word 0xe4d504a0  ! 3636: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r18
	mov	0x60, %r17
	.word 0xea9fce40  ! 3638: LDDA_R	ldda	[%r31, %r0] 0x72, %r21
	mov	0x7e0, %r21
	.word 0x8780204f  ! 3640: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeadee000  ! 3641: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r21
	.word 0xeaa62000  ! 3642: STWA_I	stwa	%r21, [%r24 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xea86a000  ! 3644: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r21
	.word 0xeab66000  ! 3645: STHA_I	stha	%r21, [%r25 + 0x0000] %asi
	.word 0xe6c48400  ! 3646: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r19
	mov	0x60, %r18
	.word 0xe6f62000  ! 3648: STXA_I	stxa	%r19, [%r24 + 0x0000] %asi
	.word 0xe68ea000  ! 3649: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r19
	.word 0xe6cee000  ! 3650: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r19
	mov	0x7f0, %r21
	mov	0x50, %r17
	.word 0xeaad04a0  ! 3653: STBA_R	stba	%r21, [%r20 + %r0] 0x25
	.word 0xe0ae09e0  ! 3654: STBA_R	stba	%r16, [%r24 + %r0] 0x4f
	.word 0xe08ea000  ! 3655: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r16
	.word 0xe086a000  ! 3656: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r16
	.word 0xeaaf4e80  ! 3657: STBA_R	stba	%r21, [%r29 + %r0] 0x74
	.word 0xe08d84a0  ! 3658: LDUBA_R	lduba	[%r22, %r0] 0x25, %r16
	.word 0x87802073  ! 3659: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe48c4400  ! 3660: LDUBA_R	lduba	[%r17, %r0] 0x20, %r18
	.word 0xe49609e0  ! 3661: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r18
	mov	0x48, %r27
	.word 0xe4a7a000  ! 3663: STWA_I	stwa	%r18, [%r30 + 0x0000] %asi
	.word 0xe2dd44a0  ! 3664: LDXA_R	ldxa	[%r21, %r0] 0x25, %r17
	.word 0xecf44400  ! 3665: STXA_R	stxa	%r22, [%r17 + %r0] 0x20
	.word 0xec9fe000  ! 3666: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r22
	mov	0x0, %r18
	.word 0xecafa000  ! 3668: STBA_I	stba	%r22, [%r30 + 0x0000] %asi
	.word 0xecc78e80  ! 3669: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r22
	.word 0x87802072  ! 3670: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeccf6000  ! 3671: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r22
	.word 0xe4a7ce60  ! 3672: STWA_R	stwa	%r18, [%r31 + %r0] 0x73
	.word 0xec96c9e0  ! 3673: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r22
	.word 0xe4b78e40  ! 3674: STHA_R	stha	%r18, [%r30 + %r0] 0x72
	.word 0xe4b76000  ! 3675: STHA_I	stha	%r18, [%r29 + 0x0000] %asi
	.word 0xea970e80  ! 3676: LDUHA_R	lduha	[%r28, %r0] 0x74, %r21
	mov	0x7f8, %r22
	.word 0xeca504a0  ! 3678: STWA_R	stwa	%r22, [%r20 + %r0] 0x25
	.word 0xec8f6000  ! 3679: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	mov	0x68, %r25
	.word 0xecbf2000  ! 3681: STDA_I	stda	%r22, [%r28 + 0x0000] %asi
	.word 0xecc72000  ! 3682: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r22
	.word 0xeca689e0  ! 3683: STWA_R	stwa	%r22, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 3684: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeef7ce60  ! 3685: STXA_R	stxa	%r23, [%r31 + %r0] 0x73
	mov	0x48, %r16
	.word 0xe89609e0  ! 3687: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r20
	.word 0xe8dd6000  ! 3688: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r20
	mov	0x50, %r19
	.word 0xe8856000  ! 3690: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r20
	.word 0xe8ce09e0  ! 3691: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r20
	.word 0x87802073  ! 3692: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c0, %r23
	.word 0x87802072  ! 3694: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4a6c9e0  ! 3695: STWA_R	stwa	%r18, [%r27 + %r0] 0x4f
	mov	0x40, %r19
	.word 0xe09c4400  ! 3697: LDDA_R	ldda	[%r17, %r0] 0x20, %r16
	.word 0xe0a7a000  ! 3698: STWA_I	stwa	%r16, [%r30 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xeabfce60  ! 3700: STDA_R	stda	%r21, [%r31 + %r0] 0x73
	.word 0xe6acc400  ! 3701: STBA_R	stba	%r19, [%r19 + %r0] 0x20
	.word 0xe6bf2000  ! 3702: STDA_I	stda	%r19, [%r28 + 0x0000] %asi
	wr_tick_cmpr_0_30:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xee, %g2
	or	%g4, 0xd7, %g4
	or	%g6, 0xf7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7c8, %r23
	.word 0xeea689e0  ! 3705: STWA_R	stwa	%r23, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 3706: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2c4c400  ! 3707: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r17
	mov	0x68, %r19
	.word 0xe2f52000  ! 3709: STXA_I	stxa	%r17, [%r20 + 0x0000] %asi
	.word 0xe6b70e60  ! 3710: STHA_R	stha	%r19, [%r28 + %r0] 0x73
	.word 0xeeb78e60  ! 3711: STHA_R	stha	%r23, [%r30 + %r0] 0x73
	.word 0x87802025  ! 3712: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r24
	.word 0xe4d44400  ! 3714: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r18
	.word 0xecd4c400  ! 3715: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r22
	.word 0xe0b689e0  ! 3716: STHA_R	stha	%r16, [%r26 + %r0] 0x4f
	.word 0xe0cda000  ! 3717: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r16
	mov	0x70, %r17
	.word 0x87802020  ! 3719: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r23
	.word 0xe0c4e000  ! 3721: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r16
	.word 0xe0b4e000  ! 3722: STHA_I	stha	%r16, [%r19 + 0x0000] %asi
	mov	0x10, %r27
	.word 0x87802073  ! 3724: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r26
	.word 0xe0972000  ! 3726: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r16
	.word 0xeeaf0e40  ! 3727: STBA_R	stba	%r23, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 3728: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeebe6000  ! 3729: STDA_I	stda	%r23, [%r25 + 0x0000] %asi
	.word 0xee966000  ! 3730: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r23
	.word 0xeebea000  ! 3731: STDA_I	stda	%r23, [%r26 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xeadf8e40  ! 3733: LDXA_R	ldxa	[%r30, %r0] 0x72, %r21
	.word 0xe2f7ce80  ! 3734: STXA_R	stxa	%r17, [%r31 + %r0] 0x74
	mov	0x3e8, %r22
	.word 0x87802020  ! 3736: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecdf8e40  ! 3737: LDXA_R	ldxa	[%r30, %r0] 0x72, %r22
	.word 0xeccc6000  ! 3738: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r22
	.word 0xecb42000  ! 3739: STHA_I	stha	%r22, [%r16 + 0x0000] %asi
	.word 0xecd42000  ! 3740: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r22
	.word 0xecbc2000  ! 3741: STDA_I	stda	%r22, [%r16 + 0x0000] %asi
	.word 0xea9544a0  ! 3742: LDUHA_R	lduha	[%r21, %r0] 0x25, %r21
	.word 0xead46000  ! 3743: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r21
	mov	0x40, %r27
	.word 0xeaac4400  ! 3745: STBA_R	stba	%r21, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3746: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2b70e80  ! 3747: STHA_R	stha	%r17, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 3748: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2ce2000  ! 3749: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r17
	.word 0xe29e2000  ! 3750: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r17
	.word 0x87802072  ! 3751: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802025  ! 3753: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2dde000  ! 3754: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r17
	.word 0xec97ce60  ! 3755: LDUHA_R	lduha	[%r31, %r0] 0x73, %r22
	.word 0xeabe09e0  ! 3756: STDA_R	stda	%r21, [%r24 + %r0] 0x4f
	.word 0xeab5e000  ! 3757: STHA_I	stha	%r21, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 3758: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xee9649e0  ! 3759: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r23
	.word 0xe6af4e40  ! 3760: STBA_R	stba	%r19, [%r29 + %r0] 0x72
	.word 0xeaa40400  ! 3761: STWA_R	stwa	%r21, [%r16 + %r0] 0x20
	.word 0x87802074  ! 3762: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x50, %r27
	.word 0xea87a000  ! 3765: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r21
	mov	0x3e8, %r20
	.word 0xeeaf0e80  ! 3767: STBA_R	stba	%r23, [%r28 + %r0] 0x74
	.word 0xe2bd84a0  ! 3768: STDA_R	stda	%r17, [%r22 + %r0] 0x25
	mov	0x78, %r17
	.word 0x87802020  ! 3770: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8ce89e0  ! 3771: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r20
	mov	0x7f0, %r23
	.word 0xe8942000  ! 3773: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r20
	mov	0x78, %r18
	.word 0xe8d42000  ! 3775: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r20
	.word 0xe8ac6000  ! 3776: STBA_I	stba	%r20, [%r17 + 0x0000] %asi
	.word 0xe8f4a000  ! 3777: STXA_I	stxa	%r20, [%r18 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xe88ca000  ! 3779: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r20
	.word 0xe8cce000  ! 3780: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r20
	.word 0xe2bec9e0  ! 3781: STDA_R	stda	%r17, [%r27 + %r0] 0x4f
	.word 0xe49689e0  ! 3782: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r18
	mov	0x0, %r16
	.word 0xe6b48400  ! 3784: STHA_R	stha	%r19, [%r18 + %r0] 0x20
	.word 0xe6842000  ! 3785: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r19
	.word 0x87802025  ! 3786: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8f544a0  ! 3787: STXA_R	stxa	%r20, [%r21 + %r0] 0x25
	.word 0xe895a000  ! 3788: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r20
	.word 0xe895a000  ! 3789: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r20
	.word 0xe8c52000  ! 3790: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r20
	mov	0x8, %r26
	.word 0xec95c4a0  ! 3792: LDUHA_R	lduha	[%r23, %r0] 0x25, %r22
	.word 0xec95a000  ! 3793: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r22
	.word 0x8780204f  ! 3794: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeadcc400  ! 3795: LDXA_R	ldxa	[%r19, %r0] 0x20, %r21
	mov	0x3d0, %r23
	.word 0xea966000  ! 3797: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r21
	.word 0xea86a000  ! 3798: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r21
	.word 0xeab6e000  ! 3799: STHA_I	stha	%r21, [%r27 + 0x0000] %asi
	.word 0xea96e000  ! 3800: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r21
	.word 0x87802025  ! 3801: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xea9d6000  ! 3802: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r21
	.word 0xe2bf8e60  ! 3803: STDA_R	stda	%r17, [%r30 + %r0] 0x73
	.word 0xe2a544a0  ! 3804: STWA_R	stwa	%r17, [%r21 + %r0] 0x25
	.word 0xe28da000  ! 3805: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r17
	.word 0xe2c5a000  ! 3806: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r17
	mov	0x28, %r26
	mov	0x3d0, %r22
	.word 0xe6c689e0  ! 3809: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r19
	.word 0xe68d2000  ! 3810: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r19
	.word 0x87802025  ! 3811: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3812: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r25
	.word 0x87802025  ! 3814: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6bda000  ! 3815: STDA_I	stda	%r19, [%r22 + 0x0000] %asi
	.word 0xe2a74e80  ! 3816: STWA_R	stwa	%r17, [%r29 + %r0] 0x74
	.word 0x87802020  ! 3817: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2bc6000  ! 3818: STDA_I	stda	%r17, [%r17 + 0x0000] %asi
	.word 0xe29c2000  ! 3819: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r17
	.word 0xe2c46000  ! 3820: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r17
	.word 0xe2cfce60  ! 3821: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r17
	.word 0xeadcc400  ! 3822: LDXA_R	ldxa	[%r19, %r0] 0x20, %r21
	.word 0xecdcc400  ! 3823: LDXA_R	ldxa	[%r19, %r0] 0x20, %r22
	.word 0xecb40400  ! 3824: STHA_R	stha	%r22, [%r16 + %r0] 0x20
	.word 0xec8ce000  ! 3825: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r22
	mov	0x7c0, %r20
	mov	0x18, %r16
	mov	0x7c8, %r23
	mov	0x7f8, %r21
	.word 0xec8c2000  ! 3830: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r22
	mov	0x60, %r24
	.word 0xecdca000  ! 3832: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r22
	.word 0xeca4e000  ! 3833: STWA_I	stwa	%r22, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 3834: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeab40400  ! 3835: STHA_R	stha	%r21, [%r16 + %r0] 0x20
	.word 0x87802074  ! 3836: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3837: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe08504a0  ! 3838: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r16
	.word 0x87802020  ! 3839: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec8689e0  ! 3840: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r22
	mov	0x10, %r27
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x30, %r27
	mov	0x3d8, %r23
	mov	0x3f8, %r21
	.word 0xeca46000  ! 3846: STWA_I	stwa	%r22, [%r17 + 0x0000] %asi
	.word 0xec8ca000  ! 3847: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r22
	mov	0x78, %r27
	.word 0xec8c6000  ! 3849: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r22
	.word 0xecc42000  ! 3850: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r22
	.word 0x87802072  ! 3851: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c0, %r21
	mov	0x3e0, %r20
	.word 0xec9f2000  ! 3854: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r22
	.word 0xe0ac0400  ! 3855: STBA_R	stba	%r16, [%r16 + %r0] 0x20
	.word 0xe09fa000  ! 3856: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r16
	.word 0xe49c4400  ! 3857: LDDA_R	ldda	[%r17, %r0] 0x20, %r18
	.word 0xe68f4e40  ! 3858: LDUBA_R	lduba	[%r29, %r0] 0x72, %r19
	.word 0xe6b7a000  ! 3859: STHA_I	stha	%r19, [%r30 + 0x0000] %asi
	mov	0x30, %r27
	mov	0x38, %r19
	.word 0xecb78e80  ! 3862: STHA_R	stha	%r22, [%r30 + %r0] 0x74
	.word 0xee9f0e60  ! 3863: LDDA_R	ldda	[%r28, %r0] 0x73, %r23
	.word 0xee8f6000  ! 3864: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r23
	.word 0x8780204f  ! 3865: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeccd04a0  ! 3866: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r22
	mov	0x68, %r27
	.word 0x8780204f  ! 3868: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3869: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb4e000  ! 3870: STHA_I	stha	%r22, [%r19 + 0x0000] %asi
	.word 0xecace000  ! 3871: STBA_I	stba	%r22, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 3872: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecf66000  ! 3873: STXA_I	stxa	%r22, [%r25 + 0x0000] %asi
	.word 0xeaaf4e40  ! 3874: STBA_R	stba	%r21, [%r29 + %r0] 0x72
	.word 0x87802074  ! 3875: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r21
	.word 0x87802025  ! 3877: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeac56000  ! 3878: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r21
	.word 0xeead84a0  ! 3879: STBA_R	stba	%r23, [%r22 + %r0] 0x25
	.word 0xeecd6000  ! 3880: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r23
	.word 0xeaaf4e60  ! 3881: STBA_R	stba	%r21, [%r29 + %r0] 0x73
	.word 0xe4a74e40  ! 3882: STWA_R	stwa	%r18, [%r29 + %r0] 0x72
	.word 0x87802074  ! 3883: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe686c9e0  ! 3884: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r19
	.word 0xea9f0e60  ! 3885: LDDA_R	ldda	[%r28, %r0] 0x73, %r21
	.word 0xeabc0400  ! 3886: STDA_R	stda	%r21, [%r16 + %r0] 0x20
	mov	0x3f8, %r23
	.word 0xe8c40400  ! 3888: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r20
	mov	0x28, %r25
	.word 0xe8c76000  ! 3890: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r20
	mov	0x3f0, %r20
	.word 0xe8a7a000  ! 3892: STWA_I	stwa	%r20, [%r30 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xe88609e0  ! 3894: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r20
	.word 0xe8cf2000  ! 3895: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r20
	.word 0x87802020  ! 3896: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec844400  ! 3897: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r22
	.word 0x87802073  ! 3898: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 3899: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecd52000  ! 3900: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r22
	.word 0xe6af8e60  ! 3901: STBA_R	stba	%r19, [%r30 + %r0] 0x73
	.word 0xe6ad2000  ! 3902: STBA_I	stba	%r19, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 3903: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3904: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_0_31:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd7, %g2
	or	%g4, 0xe1, %g4
	or	%g6, 0xbe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3f0, %r21
	.word 0xe6a4e000  ! 3907: STWA_I	stwa	%r19, [%r19 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xe684a000  ! 3909: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r19
	.word 0xe4df0e60  ! 3910: LDXA_R	ldxa	[%r28, %r0] 0x73, %r18
	mov	0x38, %r19
	.word 0xe4a4e000  ! 3912: STWA_I	stwa	%r18, [%r19 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xe4f42000  ! 3914: STXA_I	stxa	%r18, [%r16 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xe4bc4400  ! 3916: STDA_R	stda	%r18, [%r17 + %r0] 0x20
	.word 0xe4a4e000  ! 3917: STWA_I	stwa	%r18, [%r19 + 0x0000] %asi
	.word 0xe484e000  ! 3918: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r18
	mov	0x7e8, %r21
	.word 0xe4bca000  ! 3920: STDA_I	stda	%r18, [%r18 + 0x0000] %asi
	.word 0xe4bca000  ! 3921: STDA_I	stda	%r18, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3922: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r22
	mov	0x7c8, %r20
	.word 0x87802072  ! 3925: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r17
	.word 0x87802020  ! 3927: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4ac6000  ! 3928: STBA_I	stba	%r18, [%r17 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xeabd84a0  ! 3930: STDA_R	stda	%r21, [%r22 + %r0] 0x25
	.word 0xea84e000  ! 3931: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r21
	.word 0xeeb74e80  ! 3932: STHA_R	stha	%r23, [%r29 + %r0] 0x74
	.word 0x87802072  ! 3933: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2c78e40  ! 3934: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r17
	.word 0xecbc0400  ! 3935: STDA_R	stda	%r22, [%r16 + %r0] 0x20
	.word 0xecd76000  ! 3936: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r22
	.word 0x87802020  ! 3937: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec842000  ! 3938: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r22
	.word 0xe8f5c4a0  ! 3939: STXA_R	stxa	%r20, [%r23 + %r0] 0x25
	.word 0x87802020  ! 3940: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	mov	0x68, %r17
	.word 0xe8a46000  ! 3943: STWA_I	stwa	%r20, [%r17 + 0x0000] %asi
	.word 0xe8b46000  ! 3944: STHA_I	stha	%r20, [%r17 + 0x0000] %asi
	.word 0xe8ace000  ! 3945: STBA_I	stba	%r20, [%r19 + 0x0000] %asi
	.word 0xe28f0e60  ! 3946: LDUBA_R	lduba	[%r28, %r0] 0x73, %r17
	.word 0xee9c0400  ! 3947: LDDA_R	ldda	[%r16, %r0] 0x20, %r23
	.word 0xe2a70e60  ! 3948: STWA_R	stwa	%r17, [%r28 + %r0] 0x73
	mov	0x3d0, %r22
	.word 0x87802074  ! 3950: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2bfa000  ! 3951: STDA_I	stda	%r17, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 3952: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r18
	.word 0x87802074  ! 3954: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r17
	.word 0xe2b76000  ! 3956: STHA_I	stha	%r17, [%r29 + 0x0000] %asi
	.word 0xe88f0e80  ! 3957: LDUBA_R	lduba	[%r28, %r0] 0x74, %r20
	.word 0xe4ac8400  ! 3958: STBA_R	stba	%r18, [%r18 + %r0] 0x20
	.word 0xe4876000  ! 3959: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r18
	mov	0x40, %r19
	.word 0xe4b7a000  ! 3961: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	.word 0xe48d84a0  ! 3962: LDUBA_R	lduba	[%r22, %r0] 0x25, %r18
	.word 0xe2ac4400  ! 3963: STBA_R	stba	%r17, [%r17 + %r0] 0x20
	.word 0xec96c9e0  ! 3964: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r22
	.word 0xe6dfce40  ! 3965: LDXA_R	ldxa	[%r31, %r0] 0x72, %r19
	mov	0x38, %r27
	.word 0xe09d84a0  ! 3967: LDDA_R	ldda	[%r22, %r0] 0x25, %r16
	.word 0xe2840400  ! 3968: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r17
	.word 0xe4dc4400  ! 3969: LDXA_R	ldxa	[%r17, %r0] 0x20, %r18
	.word 0xe4a7a000  ! 3970: STWA_I	stwa	%r18, [%r30 + 0x0000] %asi
	.word 0xe4cfa000  ! 3971: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r18
	.word 0xe4b72000  ! 3972: STHA_I	stha	%r18, [%r28 + 0x0000] %asi
	.word 0xe4bf6000  ! 3973: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	.word 0xe4bfe000  ! 3974: STDA_I	stda	%r18, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3975: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r27
	.word 0xe0c74e40  ! 3977: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r16
	.word 0xe28f4e80  ! 3978: LDUBA_R	lduba	[%r29, %r0] 0x74, %r17
	.word 0xe2f4a000  ! 3979: STXA_I	stxa	%r17, [%r18 + 0x0000] %asi
	.word 0xeebec9e0  ! 3980: STDA_R	stda	%r23, [%r27 + %r0] 0x4f
	.word 0xecbd44a0  ! 3981: STDA_R	stda	%r22, [%r21 + %r0] 0x25
	.word 0xecdc6000  ! 3982: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r22
	.word 0xec94a000  ! 3983: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r22
	.word 0x87802072  ! 3984: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecb70e60  ! 3985: STHA_R	stha	%r22, [%r28 + %r0] 0x73
	mov	0x50, %r16
	.word 0xeaa689e0  ! 3987: STWA_R	stwa	%r21, [%r26 + %r0] 0x4f
	.word 0xeacf4e80  ! 3988: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r21
	.word 0xe6d74e80  ! 3989: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r19
	.word 0x87802073  ! 3990: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4d70e80  ! 3991: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r18
	.word 0xe4c72000  ! 3992: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r18
	.word 0x87802025  ! 3993: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4b4c400  ! 3994: STHA_R	stha	%r18, [%r19 + %r0] 0x20
	.word 0xe4bd2000  ! 3995: STDA_I	stda	%r18, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 3996: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r24
	.word 0xeab40400  ! 3998: STHA_R	stha	%r21, [%r16 + %r0] 0x20
	mov	0x40, %r17
	mov	0x48, %r24
	.word 0x87802072  ! 4001: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4bf8e60  ! 4002: STDA_R	stda	%r18, [%r30 + %r0] 0x73
	mov	0x40, %r18
	.word 0xe4972000  ! 4004: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r18
	.word 0xe4cf2000  ! 4005: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r18
	.word 0xe6cfce80  ! 4006: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r19
	.word 0xead6c9e0  ! 4007: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r21
	.word 0x87802073  ! 4008: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe28cc400  ! 4009: LDUBA_R	lduba	[%r19, %r0] 0x20, %r17
	mov	0x30, %r19
	.word 0xeacf4e60  ! 4011: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r21
	.word 0xe4ce89e0  ! 4012: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r18
	.word 0xe4a72000  ! 4013: STWA_I	stwa	%r18, [%r28 + 0x0000] %asi
	mov	0x20, %r17
	.word 0x87802074  ! 4015: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4016: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r19
	.word 0xe2c78e40  ! 4018: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r17
	.word 0xe287a000  ! 4019: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r17
	.word 0xe2c72000  ! 4020: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r17
	.word 0xe8b74e60  ! 4021: STHA_R	stha	%r20, [%r29 + %r0] 0x73
	mov	0x7c8, %r23
	mov	0x40, %r26
	.word 0xe8cf2000  ! 4024: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r20
	.word 0xec9c8400  ! 4025: LDDA_R	ldda	[%r18, %r0] 0x20, %r22
	.word 0xeca72000  ! 4026: STWA_I	stwa	%r22, [%r28 + 0x0000] %asi
	mov	0x40, %r27
	.word 0x87802074  ! 4028: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8f7ce80  ! 4029: STXA_R	stxa	%r20, [%r31 + %r0] 0x74
	.word 0xe6b7ce60  ! 4030: STHA_R	stha	%r19, [%r31 + %r0] 0x73
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3e0, %r22
	mov	0x3d0, %r23
	.word 0x87802072  ! 4034: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8af0e80  ! 4035: STBA_R	stba	%r20, [%r28 + %r0] 0x74
	.word 0xe88fa000  ! 4036: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r20
	.word 0x87802074  ! 4037: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8f7a000  ! 4038: STXA_I	stxa	%r20, [%r30 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xe89c4400  ! 4040: LDDA_R	ldda	[%r17, %r0] 0x20, %r20
	.word 0xe8af2000  ! 4041: STBA_I	stba	%r20, [%r28 + 0x0000] %asi
	.word 0xe6f649e0  ! 4042: STXA_R	stxa	%r19, [%r25 + %r0] 0x4f
	mov	0x3d0, %r22
	mov	0x7e8, %r22
	.word 0xe687ce80  ! 4045: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r19
	mov	0x7d0, %r21
	.word 0xeadc4400  ! 4047: LDXA_R	ldxa	[%r17, %r0] 0x20, %r21
	.word 0xeaa7a000  ! 4048: STWA_I	stwa	%r21, [%r30 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xe0de89e0  ! 4050: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r16
	.word 0xe0af6000  ! 4051: STBA_I	stba	%r16, [%r29 + 0x0000] %asi
	.word 0xee8c8400  ! 4052: LDUBA_R	lduba	[%r18, %r0] 0x20, %r23
	.word 0xe0dcc400  ! 4053: LDXA_R	ldxa	[%r19, %r0] 0x20, %r16
	.word 0x87802073  ! 4054: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe084c400  ! 4055: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r16
	.word 0x87802025  ! 4056: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeaf584a0  ! 4057: STXA_R	stxa	%r21, [%r22 + %r0] 0x25
	.word 0xeacda000  ! 4058: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r21
	.word 0xeabd2000  ! 4059: STDA_I	stda	%r21, [%r20 + 0x0000] %asi
	.word 0xe6844400  ! 4060: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r19
	.word 0xe6ad6000  ! 4061: STBA_I	stba	%r19, [%r21 + 0x0000] %asi
	mov	0x70, %r18
	.word 0x87802020  ! 4063: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r27
	.word 0xe6f4e000  ! 4065: STXA_I	stxa	%r19, [%r19 + 0x0000] %asi
	.word 0xecd544a0  ! 4066: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r22
	.word 0xecb42000  ! 4067: STHA_I	stha	%r22, [%r16 + 0x0000] %asi
	.word 0xecd42000  ! 4068: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r22
	mov	0x10, %r18
	.word 0xecd4e000  ! 4070: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r22
	mov	0x7e0, %r23
	.word 0x87802074  ! 4072: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xec8f6000  ! 4073: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	mov	0x68, %r26
	.word 0xe6c7ce80  ! 4075: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r19
	.word 0xe69f6000  ! 4076: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r19
	.word 0x87802074  ! 4077: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe697e000  ! 4078: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r19
	.word 0xe6af2000  ! 4079: STBA_I	stba	%r19, [%r28 + 0x0000] %asi
	.word 0xecbdc4a0  ! 4080: STDA_R	stda	%r22, [%r23 + %r0] 0x25
	.word 0x87802020  ! 4081: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeef48400  ! 4082: STXA_R	stxa	%r23, [%r18 + %r0] 0x20
	mov	0x70, %r16
	.word 0x87802020  ! 4084: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6cec9e0  ! 4085: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r19
	.word 0xe0cd84a0  ! 4086: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r16
	.word 0xeab7ce60  ! 4087: STHA_R	stha	%r21, [%r31 + %r0] 0x73
	.word 0xea9ce000  ! 4088: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r21
	.word 0xea8ce000  ! 4089: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r21
	.word 0xeaace000  ! 4090: STBA_I	stba	%r21, [%r19 + 0x0000] %asi
	.word 0xeeb78e60  ! 4091: STHA_R	stha	%r23, [%r30 + %r0] 0x73
	.word 0xe8f4c400  ! 4092: STXA_R	stxa	%r20, [%r19 + %r0] 0x20
	mov	0x40, %r17
	.word 0x8780204f  ! 4094: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8b66000  ! 4095: STHA_I	stha	%r20, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 4096: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeca48400  ! 4097: STWA_R	stwa	%r22, [%r18 + %r0] 0x20
	.word 0xecf42000  ! 4098: STXA_I	stxa	%r22, [%r16 + 0x0000] %asi
	.word 0xecdce000  ! 4099: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r22
	.word 0xe48e09e0  ! 4100: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r18
	.word 0xe4b4a000  ! 4101: STHA_I	stha	%r18, [%r18 + 0x0000] %asi
	.word 0xe4aca000  ! 4102: STBA_I	stba	%r18, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 4103: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4104: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4105: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4a46000  ! 4106: STWA_I	stwa	%r18, [%r17 + 0x0000] %asi
	.word 0xe4c4a000  ! 4107: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r18
	.word 0xeecf4e40  ! 4108: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r23
	.word 0xee8c6000  ! 4109: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r23
	.word 0xee8ce000  ! 4110: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r23
	.word 0xee9ce000  ! 4111: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r23
	.word 0xeed40400  ! 4112: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r23
	.word 0xeed46000  ! 4113: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r23
	.word 0x87802074  ! 4114: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeebf6000  ! 4115: STDA_I	stda	%r23, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 4116: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r19
	.word 0xe8f78e60  ! 4118: STXA_R	stxa	%r20, [%r30 + %r0] 0x73
	.word 0xe6ce89e0  ! 4119: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r19
	.word 0xe0f4c400  ! 4120: STXA_R	stxa	%r16, [%r19 + %r0] 0x20
	.word 0xe0c5a000  ! 4121: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r16
	.word 0xecf44400  ! 4122: STXA_R	stxa	%r22, [%r17 + %r0] 0x20
	.word 0xe4b70e60  ! 4123: STHA_R	stha	%r18, [%r28 + %r0] 0x73
	mov	0x8, %r26
	.word 0xe2f7ce60  ! 4125: STXA_R	stxa	%r17, [%r31 + %r0] 0x73
	.word 0x87802074  ! 4126: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe28fe000  ! 4127: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r17
	mov	0x58, %r18
	ta	T_CHANGE_PRIV	! macro
	.word 0xe2c7a000  ! 4130: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r17
	.word 0xe2b76000  ! 4131: STHA_I	stha	%r17, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4132: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4133: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4134: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe29f2000  ! 4135: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r17
	.word 0xe287e000  ! 4136: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r17
	.word 0x87802073  ! 4137: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeef44400  ! 4138: STXA_R	stxa	%r23, [%r17 + %r0] 0x20
	.word 0xee8f2000  ! 4139: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r23
	.word 0x87802020  ! 4140: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4141: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xec8f0e80  ! 4142: LDUBA_R	lduba	[%r28, %r0] 0x74, %r22
	.word 0xeef5c4a0  ! 4143: STXA_R	stxa	%r23, [%r23 + %r0] 0x25
	mov	0x3f0, %r23
	mov	0x40, %r26
	.word 0xeace09e0  ! 4146: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r21
	mov	0x50, %r27
	.word 0x87802073  ! 4148: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 4149: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0ae09e0  ! 4150: STBA_R	stba	%r16, [%r24 + %r0] 0x4f
	.word 0xe0dd2000  ! 4151: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r16
	.word 0xe0bd6000  ! 4152: STDA_I	stda	%r16, [%r21 + 0x0000] %asi
	.word 0xe0f52000  ! 4153: STXA_I	stxa	%r16, [%r20 + 0x0000] %asi
	.word 0xe0c5e000  ! 4154: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r16
	.word 0xe095e000  ! 4155: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r16
	.word 0xeaa7ce60  ! 4156: STWA_R	stwa	%r21, [%r31 + %r0] 0x73
	mov	0x30, %r24
	.word 0xeaf56000  ! 4158: STXA_I	stxa	%r21, [%r21 + 0x0000] %asi
	.word 0xea85e000  ! 4159: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r21
	.word 0xe495c4a0  ! 4160: LDUHA_R	lduha	[%r23, %r0] 0x25, %r18
	.word 0x87802074  ! 4161: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4afe000  ! 4162: STBA_I	stba	%r18, [%r31 + 0x0000] %asi
	.word 0xe4f7e000  ! 4163: STXA_I	stxa	%r18, [%r31 + 0x0000] %asi
	.word 0xee8cc400  ! 4164: LDUBA_R	lduba	[%r19, %r0] 0x20, %r23
	.word 0xeaf78e40  ! 4165: STXA_R	stxa	%r21, [%r30 + %r0] 0x72
	.word 0xeaaf6000  ! 4166: STBA_I	stba	%r21, [%r29 + 0x0000] %asi
	.word 0xeadfe000  ! 4167: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r21
	.word 0xea872000  ! 4168: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r21
	mov	0x20, %r25
	mov	0x7f8, %r21
	mov	0x60, %r16
	.word 0xe4b74e80  ! 4172: STHA_R	stha	%r18, [%r29 + %r0] 0x74
	.word 0xe4f7e000  ! 4173: STXA_I	stxa	%r18, [%r31 + 0x0000] %asi
	.word 0xe4f7a000  ! 4174: STXA_I	stxa	%r18, [%r30 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xe0f649e0  ! 4176: STXA_R	stxa	%r16, [%r25 + %r0] 0x4f
	.word 0xeedd84a0  ! 4177: LDXA_R	ldxa	[%r22, %r0] 0x25, %r23
	.word 0xeef72000  ! 4178: STXA_I	stxa	%r23, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3d0, %r23
	.word 0xeec76000  ! 4181: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r23
	.word 0x87802072  ! 4182: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeea76000  ! 4183: STWA_I	stwa	%r23, [%r29 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xeeb7e000  ! 4185: STHA_I	stha	%r23, [%r31 + 0x0000] %asi
	.word 0xeeb7e000  ! 4186: STHA_I	stha	%r23, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4187: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0c78e60  ! 4188: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r16
	.word 0xe0c4c400  ! 4189: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r16
	mov	0x20, %r16
	.word 0xe88c0400  ! 4191: LDUBA_R	lduba	[%r16, %r0] 0x20, %r20
	.word 0xe8aca000  ! 4192: STBA_I	stba	%r20, [%r18 + 0x0000] %asi
	.word 0xe8bce000  ! 4193: STDA_I	stda	%r20, [%r19 + 0x0000] %asi
	.word 0xe08e09e0  ! 4194: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r16
	mov	0x38, %r18
	.word 0x8780204f  ! 4196: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r22
	mov	0x68, %r24
	mov	0x7c8, %r23
	.word 0xe6cd44a0  ! 4200: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r19
	.word 0xe6ae2000  ! 4201: STBA_I	stba	%r19, [%r24 + 0x0000] %asi
	.word 0xecf689e0  ! 4202: STXA_R	stxa	%r22, [%r26 + %r0] 0x4f
	mov	0x20, %r16
	.word 0x87802020  ! 4204: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeef48400  ! 4205: STXA_R	stxa	%r23, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4206: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeeb4e000  ! 4207: STHA_I	stha	%r23, [%r19 + 0x0000] %asi
	.word 0xe6adc4a0  ! 4208: STBA_R	stba	%r19, [%r23 + %r0] 0x25
	.word 0x87802074  ! 4209: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6afa000  ! 4210: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	mov	0x38, %r27
	.word 0xe2b4c400  ! 4212: STHA_R	stha	%r17, [%r19 + %r0] 0x20
	.word 0x87802072  ! 4213: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r23
	.word 0xe8b40400  ! 4215: STHA_R	stha	%r20, [%r16 + %r0] 0x20
	.word 0xe89609e0  ! 4216: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r20
	.word 0x87802074  ! 4217: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0c649e0  ! 4218: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r16
	.word 0xecdc8400  ! 4219: LDXA_R	ldxa	[%r18, %r0] 0x20, %r22
	.word 0x87802020  ! 4220: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb42000  ! 4221: STHA_I	stha	%r22, [%r16 + 0x0000] %asi
	.word 0xecc4e000  ! 4222: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r22
	mov	0x20, %r19
	.word 0xe8b74e40  ! 4224: STHA_R	stha	%r20, [%r29 + %r0] 0x72
	.word 0xe8d4a000  ! 4225: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r20
	mov	0x48, %r16
	mov	0x10, %r26
	.word 0xe8b42000  ! 4228: STHA_I	stha	%r20, [%r16 + 0x0000] %asi
	.word 0xe8842000  ! 4229: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r20
	.word 0xe8dc2000  ! 4230: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r20
	.word 0xeaa544a0  ! 4231: STWA_R	stwa	%r21, [%r21 + %r0] 0x25
	.word 0xe6b78e60  ! 4232: STHA_R	stha	%r19, [%r30 + %r0] 0x73
	mov	0x58, %r24
	.word 0x87802020  ! 4234: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r27
	.word 0x87802020  ! 4236: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe28504a0  ! 4237: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r17
	.word 0xe2ac6000  ! 4238: STBA_I	stba	%r17, [%r17 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xe294a000  ! 4240: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r17
	mov	0x68, %r25
	.word 0xe2dce000  ! 4242: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r17
	wr_tick_cmpr_0_32:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x83, %g2
	or	%g4, 0xac, %g4
	or	%g6, 0xcf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe6b44400  ! 4244: STHA_R	stha	%r19, [%r17 + %r0] 0x20
	.word 0xecce89e0  ! 4245: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r22
	.word 0xeccca000  ! 4246: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r22
	mov	0x10, %r27
	.word 0xecaca000  ! 4248: STBA_I	stba	%r22, [%r18 + 0x0000] %asi
	.word 0xecf4e000  ! 4249: STXA_I	stxa	%r22, [%r19 + 0x0000] %asi
	.word 0xecbf4e80  ! 4250: STDA_R	stda	%r22, [%r29 + %r0] 0x74
	.word 0xea8689e0  ! 4251: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r21
	.word 0xe8a78e60  ! 4252: STWA_R	stwa	%r20, [%r30 + %r0] 0x73
	mov	0x68, %r27
	.word 0xe6ce49e0  ! 4254: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r19
	.word 0x87802020  ! 4255: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4dd84a0  ! 4256: LDXA_R	ldxa	[%r22, %r0] 0x25, %r18
	mov	0x38, %r16
	mov	0x58, %r19
	.word 0xeeddc4a0  ! 4259: LDXA_R	ldxa	[%r23, %r0] 0x25, %r23
	.word 0xee8c0400  ! 4260: LDUBA_R	lduba	[%r16, %r0] 0x20, %r23
	mov	0x70, %r18
	.word 0xeeac6000  ! 4262: STBA_I	stba	%r23, [%r17 + 0x0000] %asi
	.word 0xee8c2000  ! 4263: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r23
	.word 0xeea4a000  ! 4264: STWA_I	stwa	%r23, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 4265: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeccf0e40  ! 4266: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r22
	mov	0x70, %r18
	.word 0xeead44a0  ! 4268: STBA_R	stba	%r23, [%r21 + %r0] 0x25
	.word 0xeeaf6000  ! 4269: STBA_I	stba	%r23, [%r29 + 0x0000] %asi
	mov	0x78, %r17
	mov	0x0, %r17
	mov	0x10, %r19
	.word 0xeeb76000  ! 4273: STHA_I	stha	%r23, [%r29 + 0x0000] %asi
	mov	0x70, %r24
	.word 0x87802020  ! 4275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeeac2000  ! 4276: STBA_I	stba	%r23, [%r16 + 0x0000] %asi
	mov	0x58, %r19
	.word 0x87802025  ! 4278: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4279: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r19
	mov	0x48, %r24
	.word 0xe2dcc400  ! 4282: LDXA_R	ldxa	[%r19, %r0] 0x20, %r17
	.word 0xe2bfce40  ! 4283: STDA_R	stda	%r17, [%r31 + %r0] 0x72
	.word 0x87802074  ! 4284: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r24
	.word 0xe4b48400  ! 4286: STHA_R	stha	%r18, [%r18 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0xe4df6000  ! 4288: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r18
	mov	0x38, %r16
	.word 0xe487e000  ! 4290: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r18
	.word 0xe4bfa000  ! 4291: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 4292: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4293: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4c7e000  ! 4294: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r18
	.word 0xe4bfa000  ! 4295: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 4296: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe495a000  ! 4297: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r18
	.word 0xe4952000  ! 4298: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r18
	.word 0xe6d609e0  ! 4299: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r19
	.word 0x87802072  ! 4300: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecbf0e60  ! 4301: STDA_R	stda	%r22, [%r28 + %r0] 0x73
	.word 0xe2a78e40  ! 4302: STWA_R	stwa	%r17, [%r30 + %r0] 0x72
	.word 0xe2bfa000  ! 4303: STDA_I	stda	%r17, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4304: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe28c6000  ! 4305: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r17
	.word 0xec8fce60  ! 4306: LDUBA_R	lduba	[%r31, %r0] 0x73, %r22
	.word 0xeac74e40  ! 4307: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r21
	mov	0x58, %r19
	mov	0x78, %r26
	.word 0xea9f0e40  ! 4310: LDDA_R	ldda	[%r28, %r0] 0x72, %r21
	mov	0x40, %r16
	.word 0x87802020  ! 4312: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r22
	.word 0xeedc8400  ! 4314: LDXA_R	ldxa	[%r18, %r0] 0x20, %r23
	.word 0xeef4e000  ! 4315: STXA_I	stxa	%r23, [%r19 + 0x0000] %asi
	.word 0xe697ce60  ! 4316: LDUHA_R	lduha	[%r31, %r0] 0x73, %r19
	.word 0xe6aec9e0  ! 4317: STBA_R	stba	%r19, [%r27 + %r0] 0x4f
	.word 0xee8c4400  ! 4318: LDUBA_R	lduba	[%r17, %r0] 0x20, %r23
	.word 0xeeafce60  ! 4319: STBA_R	stba	%r23, [%r31 + %r0] 0x73
	.word 0xeeace000  ! 4320: STBA_I	stba	%r23, [%r19 + 0x0000] %asi
	.word 0xec8f4e80  ! 4321: LDUBA_R	lduba	[%r29, %r0] 0x74, %r22
	mov	0x3d8, %r23
	.word 0xecc42000  ! 4323: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r22
	.word 0xeebe09e0  ! 4324: STDA_R	stda	%r23, [%r24 + %r0] 0x4f
	.word 0xee942000  ! 4325: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r23
	.word 0xeeb46000  ! 4326: STHA_I	stha	%r23, [%r17 + 0x0000] %asi
	.word 0xecbfce40  ! 4327: STDA_R	stda	%r22, [%r31 + %r0] 0x72
	.word 0xecdc6000  ! 4328: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r22
	.word 0xecace000  ! 4329: STBA_I	stba	%r22, [%r19 + 0x0000] %asi
	.word 0xecdc6000  ! 4330: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r22
	mov	0x3c0, %r22
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 4333: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeca62000  ! 4334: STWA_I	stwa	%r22, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 4335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec94e000  ! 4336: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r22
	.word 0x87802020  ! 4337: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb46000  ! 4338: STHA_I	stha	%r22, [%r17 + 0x0000] %asi
	.word 0xeccca000  ! 4339: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r22
	.word 0xea8dc4a0  ! 4340: LDUBA_R	lduba	[%r23, %r0] 0x25, %r21
	.word 0x87802020  ! 4341: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4342: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2a48400  ! 4343: STWA_R	stwa	%r17, [%r18 + %r0] 0x20
	.word 0xe29f2000  ! 4344: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r17
	.word 0xe2c72000  ! 4345: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r17
	mov	0x40, %r19
	.word 0x87802072  ! 4347: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d0, %r20
	.word 0x87802072  ! 4349: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4350: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2872000  ! 4351: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r17
	.word 0xe287a000  ! 4352: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r17
	.word 0xe2b76000  ! 4353: STHA_I	stha	%r17, [%r29 + 0x0000] %asi
	mov	0x68, %r19
	.word 0xecbc0400  ! 4355: STDA_R	stda	%r22, [%r16 + %r0] 0x20
	.word 0x87802072  ! 4356: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecb72000  ! 4357: STHA_I	stha	%r22, [%r28 + 0x0000] %asi
	.word 0xe2bd84a0  ! 4358: STDA_R	stda	%r17, [%r22 + %r0] 0x25
	.word 0xe2d76000  ! 4359: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r17
	.word 0x87802020  ! 4360: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2f4a000  ! 4361: STXA_I	stxa	%r17, [%r18 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xe2afce60  ! 4363: STBA_R	stba	%r17, [%r31 + %r0] 0x73
	.word 0xe2d46000  ! 4364: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r17
	.word 0xeaac4400  ! 4365: STBA_R	stba	%r21, [%r17 + %r0] 0x20
	.word 0xeeb40400  ! 4366: STHA_R	stha	%r23, [%r16 + %r0] 0x20
	.word 0xeeb42000  ! 4367: STHA_I	stha	%r23, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4368: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeec46000  ! 4369: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r23
	mov	0x8, %r19
	.word 0xeab44400  ! 4371: STHA_R	stha	%r21, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4372: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4c78e60  ! 4373: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r18
	.word 0xe4846000  ! 4374: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r18
	.word 0xe0f689e0  ! 4375: STXA_R	stxa	%r16, [%r26 + %r0] 0x4f
	mov	0x48, %r19
	.word 0xe0b4e000  ! 4377: STHA_I	stha	%r16, [%r19 + 0x0000] %asi
	mov	0x58, %r24
	.word 0x87802020  ! 4379: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0b42000  ! 4380: STHA_I	stha	%r16, [%r16 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xe0a4e000  ! 4382: STWA_I	stwa	%r16, [%r19 + 0x0000] %asi
	.word 0xe084e000  ! 4383: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r16
	.word 0xee97ce80  ! 4384: LDUHA_R	lduha	[%r31, %r0] 0x74, %r23
	mov	0x60, %r17
	mov	0x58, %r18
	.word 0xeebc2000  ! 4387: STDA_I	stda	%r23, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4388: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r17
	.word 0x87802073  ! 4390: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r23
	mov	0x10, %r26
	.word 0x87802073  ! 4393: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeec7a000  ! 4394: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r23
	.word 0xee8fe000  ! 4395: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r23
	.word 0xeecf6000  ! 4396: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r23
	.word 0xeebf8e80  ! 4397: STDA_R	stda	%r23, [%r30 + %r0] 0x74
	mov	0x7e0, %r21
	.word 0xe8bc0400  ! 4399: STDA_R	stda	%r20, [%r16 + %r0] 0x20
	.word 0xe8d72000  ! 4400: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r20
	.word 0xe897e000  ! 4401: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r20
	.word 0xe89f2000  ! 4402: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r20
	.word 0xea970e40  ! 4403: LDUHA_R	lduha	[%r28, %r0] 0x72, %r21
	mov	0x50, %r16
	.word 0xe6b5c4a0  ! 4405: STHA_R	stha	%r19, [%r23 + %r0] 0x25
	.word 0xe6b70e40  ! 4406: STHA_R	stha	%r19, [%r28 + %r0] 0x72
	.word 0xe6cf2000  ! 4407: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r19
	.word 0x87802020  ! 4408: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8f5c4a0  ! 4409: STXA_R	stxa	%r20, [%r23 + %r0] 0x25
	mov	0x8, %r18
	.word 0xe8bf0e60  ! 4411: STDA_R	stda	%r20, [%r28 + %r0] 0x73
	.word 0xe8b4e000  ! 4412: STHA_I	stha	%r20, [%r19 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0x87802073  ! 4414: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 4415: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r24
	.word 0x8780204f  ! 4417: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8df4e60  ! 4418: LDXA_R	ldxa	[%r29, %r0] 0x73, %r20
	.word 0xe0a74e80  ! 4419: STWA_R	stwa	%r16, [%r29 + %r0] 0x74
	.word 0xe8a78e60  ! 4420: STWA_R	stwa	%r20, [%r30 + %r0] 0x73
	.word 0xe8866000  ! 4421: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r20
	.word 0xecb689e0  ! 4422: STHA_R	stha	%r22, [%r26 + %r0] 0x4f
	.word 0xecae2000  ! 4423: STBA_I	stba	%r22, [%r24 + 0x0000] %asi
	.word 0xecd6a000  ! 4424: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r22
	.word 0xec862000  ! 4425: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r22
	.word 0xecaea000  ! 4426: STBA_I	stba	%r22, [%r26 + 0x0000] %asi
	.word 0xecf66000  ! 4427: STXA_I	stxa	%r22, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 4428: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecc6e000  ! 4429: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r22
	.word 0xec9ea000  ! 4430: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r22
	.word 0xec86a000  ! 4431: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r22
	.word 0xe6f70e40  ! 4432: STXA_R	stxa	%r19, [%r28 + %r0] 0x72
	.word 0xe28f4e60  ! 4433: LDUBA_R	lduba	[%r29, %r0] 0x73, %r17
	.word 0xecc609e0  ! 4434: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r22
	.word 0xe4b48400  ! 4435: STHA_R	stha	%r18, [%r18 + %r0] 0x20
	.word 0x87802072  ! 4436: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 4437: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4f40400  ! 4438: STXA_R	stxa	%r18, [%r16 + %r0] 0x20
	mov	0x20, %r27
	.word 0xecf6c9e0  ! 4440: STXA_R	stxa	%r22, [%r27 + %r0] 0x4f
	.word 0xecb72000  ! 4441: STHA_I	stha	%r22, [%r28 + 0x0000] %asi
	.word 0xecdfe000  ! 4442: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r22
	.word 0xecdfe000  ! 4443: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r22
	.word 0xeccf4e40  ! 4444: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r22
	wr_tick_cmpr_0_33:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8e, %g2
	or	%g4, 0xbc, %g4
	or	%g6, 0xbf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeadfce40  ! 4446: LDXA_R	ldxa	[%r31, %r0] 0x72, %r21
	mov	0x7f0, %r22
	.word 0xe6af4e40  ! 4448: STBA_R	stba	%r19, [%r29 + %r0] 0x72
	.word 0xe49c4400  ! 4449: LDDA_R	ldda	[%r17, %r0] 0x20, %r18
	.word 0xe8d5c4a0  ! 4450: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r20
	mov	0x3e0, %r22
	.word 0xe8f44400  ! 4452: STXA_R	stxa	%r20, [%r17 + %r0] 0x20
	.word 0xe6c74e40  ! 4453: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r19
	.word 0xe6af6000  ! 4454: STBA_I	stba	%r19, [%r29 + 0x0000] %asi
	mov	0x8, %r25
	mov	0x40, %r24
	.word 0xe4b689e0  ! 4457: STHA_R	stha	%r18, [%r26 + %r0] 0x4f
	.word 0xe6b7ce80  ! 4458: STHA_R	stha	%r19, [%r31 + %r0] 0x74
	.word 0xe6dfe000  ! 4459: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r19
	.word 0xe8a7ce80  ! 4460: STWA_R	stwa	%r20, [%r31 + %r0] 0x74
	.word 0xe28ec9e0  ! 4461: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r17
	mov	0x48, %r18
	.word 0x87802025  ! 4463: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe28d6000  ! 4464: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r17
	.word 0xe29da000  ! 4465: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r17
	.word 0xe2bd6000  ! 4466: STDA_I	stda	%r17, [%r21 + 0x0000] %asi
	.word 0xe28d2000  ! 4467: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r17
	.word 0x87802073  ! 4468: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2d72000  ! 4469: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r17
	.word 0xe6ad44a0  ! 4470: STBA_R	stba	%r19, [%r21 + %r0] 0x25
	wr_tick_cmpr_0_34:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8b, %g2
	or	%g4, 0xf3, %g4
	or	%g6, 0xec, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe6af2000  ! 4472: STBA_I	stba	%r19, [%r28 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xeeaec9e0  ! 4474: STBA_R	stba	%r23, [%r27 + %r0] 0x4f
	.word 0xe0dfce60  ! 4475: LDXA_R	ldxa	[%r31, %r0] 0x73, %r16
	.word 0xe0a72000  ! 4476: STWA_I	stwa	%r16, [%r28 + 0x0000] %asi
	.word 0xe0b44400  ! 4477: STHA_R	stha	%r16, [%r17 + %r0] 0x20
	mov	0x7f0, %r23
	.word 0xecf689e0  ! 4479: STXA_R	stxa	%r22, [%r26 + %r0] 0x4f
	.word 0xe6bc8400  ! 4480: STDA_R	stda	%r19, [%r18 + %r0] 0x20
	.word 0xe68fe000  ! 4481: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r19
	mov	0x70, %r25
	.word 0xeea649e0  ! 4483: STWA_R	stwa	%r23, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 4484: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0d504a0  ! 4485: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r16
	.word 0xe0c7e000  ! 4486: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r16
	.word 0xe0df6000  ! 4487: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r16
	.word 0x87802025  ! 4488: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe88f0e60  ! 4489: LDUBA_R	lduba	[%r28, %r0] 0x73, %r20
	.word 0xe8f56000  ! 4490: STXA_I	stxa	%r20, [%r21 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0x87802025  ! 4492: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe89da000  ! 4493: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r20
	.word 0xeeb40400  ! 4494: STHA_R	stha	%r23, [%r16 + %r0] 0x20
	mov	0x30, %r24
	mov	0x7f0, %r23
	.word 0x87802072  ! 4497: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4bf4e40  ! 4498: STDA_R	stda	%r18, [%r29 + %r0] 0x72
	.word 0xe2d48400  ! 4499: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r17
	.word 0xe2cf6000  ! 4500: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r17
	.word 0x87802025  ! 4501: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4502: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xea9ec9e0  ! 4503: LDDA_R	ldda	[%r27, %r0] 0x4f, %r21
	.word 0xeadfe000  ! 4504: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r21
	.word 0x8780204f  ! 4505: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xea9584a0  ! 4506: LDUHA_R	lduha	[%r22, %r0] 0x25, %r21
	.word 0xeaf40400  ! 4507: STXA_R	stxa	%r21, [%r16 + %r0] 0x20
	.word 0xec9f4e60  ! 4508: LDDA_R	ldda	[%r29, %r0] 0x73, %r22
	.word 0xe8d70e80  ! 4509: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r20
	.word 0xe8aea000  ! 4510: STBA_I	stba	%r20, [%r26 + 0x0000] %asi
	.word 0xe29d04a0  ! 4511: LDDA_R	ldda	[%r20, %r0] 0x25, %r17
	mov	0x7e0, %r21
	.word 0xe4a5c4a0  ! 4513: STWA_R	stwa	%r18, [%r23 + %r0] 0x25
	.word 0xe4b48400  ! 4514: STHA_R	stha	%r18, [%r18 + %r0] 0x20
	.word 0xe6dec9e0  ! 4515: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r19
	.word 0xe6b6a000  ! 4516: STHA_I	stha	%r19, [%r26 + 0x0000] %asi
	.word 0xe6bea000  ! 4517: STDA_I	stda	%r19, [%r26 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xe6f6a000  ! 4519: STXA_I	stxa	%r19, [%r26 + 0x0000] %asi
	.word 0xe0bf0e60  ! 4520: STDA_R	stda	%r16, [%r28 + %r0] 0x73
	.word 0x87802025  ! 4521: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8b40400  ! 4522: STHA_R	stha	%r20, [%r16 + %r0] 0x20
	mov	0x0, %r25
	.word 0xe8b56000  ! 4524: STHA_I	stha	%r20, [%r21 + 0x0000] %asi
	.word 0xe8c56000  ! 4525: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r20
	.word 0xe885a000  ! 4526: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r20
	.word 0x87802072  ! 4527: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r16
	.word 0xeef78e80  ! 4529: STXA_R	stxa	%r23, [%r30 + %r0] 0x74
	.word 0xec9609e0  ! 4530: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r22
	.word 0xec8fe000  ! 4531: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r22
	.word 0xecdfa000  ! 4532: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r22
	.word 0x87802020  ! 4533: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r26
	.word 0xec9c2000  ! 4535: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r22
	.word 0xec8e49e0  ! 4536: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r22
	mov	0x3c8, %r20
	mov	0x7f0, %r21
	.word 0xea970e40  ! 4539: LDUHA_R	lduha	[%r28, %r0] 0x72, %r21
	.word 0x87802020  ! 4540: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2b7ce40  ! 4541: STHA_R	stha	%r17, [%r31 + %r0] 0x72
	.word 0xecf544a0  ! 4542: STXA_R	stxa	%r22, [%r21 + %r0] 0x25
	.word 0xe4bc8400  ! 4543: STDA_R	stda	%r18, [%r18 + %r0] 0x20
	.word 0xecaf0e40  ! 4544: STBA_R	stba	%r22, [%r28 + %r0] 0x72
	mov	0x78, %r17
	.word 0x87802072  ! 4546: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r16
	mov	0x3f8, %r20
	.word 0xec9fe000  ! 4549: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r22
	.word 0xecc76000  ! 4550: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0x87802072  ! 4551: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecf7a000  ! 4552: STXA_I	stxa	%r22, [%r30 + 0x0000] %asi
	.word 0xeeae49e0  ! 4553: STBA_R	stba	%r23, [%r25 + %r0] 0x4f
	.word 0xeec76000  ! 4554: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r23
	mov	0x10, %r17
	mov	0x3f8, %r22
	.word 0xe287ce40  ! 4557: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r17
	.word 0xe6cf8e40  ! 4558: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r19
	.word 0xeca40400  ! 4559: STWA_R	stwa	%r22, [%r16 + %r0] 0x20
	.word 0xe88e09e0  ! 4560: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r20
	.word 0xeace49e0  ! 4561: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r21
	.word 0xe4a44400  ! 4562: STWA_R	stwa	%r18, [%r17 + %r0] 0x20
	.word 0xe4d72000  ! 4563: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r18
	.word 0x87802020  ! 4564: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea8cc400  ! 4565: LDUBA_R	lduba	[%r19, %r0] 0x20, %r21
	.word 0xeabc2000  ! 4566: STDA_I	stda	%r21, [%r16 + 0x0000] %asi
	.word 0xe0a78e60  ! 4567: STWA_R	stwa	%r16, [%r30 + %r0] 0x73
	.word 0xeadec9e0  ! 4568: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r21
	.word 0xe8af0e80  ! 4569: STBA_R	stba	%r20, [%r28 + %r0] 0x74
	.word 0xe8c4e000  ! 4570: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r20
	mov	0x50, %r26
	.word 0xecf70e60  ! 4572: STXA_R	stxa	%r22, [%r28 + %r0] 0x73
	.word 0xecb42000  ! 4573: STHA_I	stha	%r22, [%r16 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x70, %r17
	mov	0x3c0, %r23
	.word 0xeabdc4a0  ! 4577: STDA_R	stda	%r21, [%r23 + %r0] 0x25
	.word 0xea9609e0  ! 4578: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r21
	.word 0xec8ec9e0  ! 4579: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r22
	.word 0xeccca000  ! 4580: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r22
	.word 0x87802073  ! 4581: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xecf72000  ! 4582: STXA_I	stxa	%r22, [%r28 + 0x0000] %asi
	.word 0xe2b70e80  ! 4583: STHA_R	stha	%r17, [%r28 + %r0] 0x74
	.word 0x87802020  ! 4584: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4585: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r26
	.word 0x87802074  ! 4587: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2c72000  ! 4588: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r17
	.word 0xe0cc4400  ! 4589: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r16
	mov	0x60, %r25
	.word 0xe0af6000  ! 4591: STBA_I	stba	%r16, [%r29 + 0x0000] %asi
	.word 0xe0b5c4a0  ! 4592: STHA_R	stha	%r16, [%r23 + %r0] 0x25
	mov	0x50, %r16
	.word 0xe6bc8400  ! 4594: STDA_R	stda	%r19, [%r18 + %r0] 0x20
	mov	0x10, %r19
	mov	0x3f0, %r20
	mov	0x7d8, %r22
	mov	0x7f8, %r21
	mov	0x7e0, %r21
	mov	0x3c0, %r20
	.word 0xe6af6000  ! 4601: STBA_I	stba	%r19, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 4602: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r22
	.word 0xe2ac8400  ! 4604: STBA_R	stba	%r17, [%r18 + %r0] 0x20
	.word 0xecf48400  ! 4605: STXA_R	stxa	%r22, [%r18 + %r0] 0x20
	.word 0xecbf2000  ! 4606: STDA_I	stda	%r22, [%r28 + 0x0000] %asi
	.word 0xe2de89e0  ! 4607: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r17
	mov	0x58, %r17
	.word 0x87802020  ! 4609: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4610: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r23
	mov	0x7e8, %r21
	.word 0xe287e000  ! 4613: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r17
	.word 0xeacc8400  ! 4614: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r21
	.word 0xe0a48400  ! 4615: STWA_R	stwa	%r16, [%r18 + %r0] 0x20
	mov	0x8, %r17
	mov	0x0, %r16
	mov	0x3c8, %r21
	.word 0x87802025  ! 4619: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4620: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r16
	mov	0x0, %r25
	mov	0x50, %r19
	.word 0x87802074  ! 4624: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r21
	.word 0xe0b7e000  ! 4626: STHA_I	stha	%r16, [%r31 + 0x0000] %asi
	.word 0xe09fe000  ! 4627: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r16
	mov	0x3d0, %r21
	.word 0xe2c7ce80  ! 4629: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r17
	.word 0xe2bfe000  ! 4630: STDA_I	stda	%r17, [%r31 + 0x0000] %asi
	.word 0xe2d76000  ! 4631: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r17
	.word 0xe68f4e80  ! 4632: LDUBA_R	lduba	[%r29, %r0] 0x74, %r19
	.word 0xe4f78e60  ! 4633: STXA_R	stxa	%r18, [%r30 + %r0] 0x73
	.word 0xe4a76000  ! 4634: STWA_I	stwa	%r18, [%r29 + 0x0000] %asi
	.word 0xe6a4c400  ! 4635: STWA_R	stwa	%r19, [%r19 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xe687a000  ! 4637: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r19
	.word 0xe6c76000  ! 4638: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r19
	.word 0xe6876000  ! 4639: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r19
	.word 0xe2af0e40  ! 4640: STBA_R	stba	%r17, [%r28 + %r0] 0x72
	.word 0xe2bfe000  ! 4641: STDA_I	stda	%r17, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 4642: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe29c8400  ! 4643: LDDA_R	ldda	[%r18, %r0] 0x20, %r17
	.word 0xe28fe000  ! 4644: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r17
	mov	0x7e8, %r23
	.word 0xe2b76000  ! 4646: STHA_I	stha	%r17, [%r29 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x68, %r16
	.word 0x8780204f  ! 4649: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe897ce40  ! 4650: LDUHA_R	lduha	[%r31, %r0] 0x72, %r20
	.word 0xe8bea000  ! 4651: STDA_I	stda	%r20, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 4652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4653: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecbcc400  ! 4654: STDA_R	stda	%r22, [%r19 + %r0] 0x20
	.word 0xecaf6000  ! 4655: STBA_I	stba	%r22, [%r29 + 0x0000] %asi
	.word 0xe28d04a0  ! 4656: LDUBA_R	lduba	[%r20, %r0] 0x25, %r17
	mov	0x7d0, %r22
	.word 0xe2d72000  ! 4658: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r17
	.word 0x8780204f  ! 4659: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8b4c400  ! 4660: STHA_R	stha	%r20, [%r19 + %r0] 0x20
	.word 0xe8bee000  ! 4661: STDA_I	stda	%r20, [%r27 + 0x0000] %asi
	.word 0xec8e49e0  ! 4662: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r22
	.word 0x87802020  ! 4663: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0978e40  ! 4664: LDUHA_R	lduha	[%r30, %r0] 0x72, %r16
	.word 0xe094a000  ! 4665: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r16
	.word 0x87802020  ! 4666: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r19
	mov	0x60, %r24
	.word 0xe2c649e0  ! 4669: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r17
	.word 0xe0f4c400  ! 4670: STXA_R	stxa	%r16, [%r19 + %r0] 0x20
	.word 0xe0aca000  ! 4671: STBA_I	stba	%r16, [%r18 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xe0a4a000  ! 4673: STWA_I	stwa	%r16, [%r18 + 0x0000] %asi
	.word 0xe09c6000  ! 4674: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r16
	.word 0xe0d46000  ! 4675: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r16
	.word 0xe69584a0  ! 4676: LDUHA_R	lduha	[%r22, %r0] 0x25, %r19
	.word 0xe6942000  ! 4677: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r19
	.word 0xe0a78e60  ! 4678: STWA_R	stwa	%r16, [%r30 + %r0] 0x73
	mov	0x7c8, %r22
	.word 0xe29f8e60  ! 4680: LDDA_R	ldda	[%r30, %r0] 0x73, %r17
	.word 0x87802025  ! 4681: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8f40400  ! 4682: STXA_R	stxa	%r20, [%r16 + %r0] 0x20
	.word 0xe0b70e80  ! 4683: STHA_R	stha	%r16, [%r28 + %r0] 0x74
	.word 0xe0a5a000  ! 4684: STWA_I	stwa	%r16, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 4685: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0af2000  ! 4686: STBA_I	stba	%r16, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4687: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb7ce40  ! 4688: STHA_R	stha	%r22, [%r31 + %r0] 0x72
	.word 0xea970e40  ! 4689: LDUHA_R	lduha	[%r28, %r0] 0x72, %r21
	.word 0xeeb70e60  ! 4690: STHA_R	stha	%r23, [%r28 + %r0] 0x73
	mov	0x40, %r17
	.word 0xe6ad44a0  ! 4692: STBA_R	stba	%r19, [%r21 + %r0] 0x25
	.word 0xe6f46000  ! 4693: STXA_I	stxa	%r19, [%r17 + 0x0000] %asi
	.word 0xe8b48400  ! 4694: STHA_R	stha	%r20, [%r18 + %r0] 0x20
	.word 0xe8b4c400  ! 4695: STHA_R	stha	%r20, [%r19 + %r0] 0x20
	.word 0xea8609e0  ! 4696: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r21
	mov	0x30, %r18
	mov	0x3e8, %r22
	.word 0xeaac2000  ! 4699: STBA_I	stba	%r21, [%r16 + 0x0000] %asi
	.word 0xe0c6c9e0  ! 4700: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r16
	.word 0xeec5c4a0  ! 4701: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r23
	.word 0xeab584a0  ! 4702: STHA_R	stha	%r21, [%r22 + %r0] 0x25
	.word 0x87802020  ! 4703: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeadca000  ! 4704: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r21
	mov	0x7e8, %r21
	.word 0xead46000  ! 4706: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r21
	.word 0xecbd04a0  ! 4707: STDA_R	stda	%r22, [%r20 + %r0] 0x25
	.word 0xe0f74e80  ! 4708: STXA_R	stxa	%r16, [%r29 + %r0] 0x74
	.word 0xe09e09e0  ! 4709: LDDA_R	ldda	[%r24, %r0] 0x4f, %r16
	.word 0xe084a000  ! 4710: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r16
	mov	0x10, %r24
	.word 0xe0a4e000  ! 4712: STWA_I	stwa	%r16, [%r19 + 0x0000] %asi
	.word 0xeeb4c400  ! 4713: STHA_R	stha	%r23, [%r19 + %r0] 0x20
	.word 0xe8c504a0  ! 4714: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r20
	.word 0xe8b46000  ! 4715: STHA_I	stha	%r20, [%r17 + 0x0000] %asi
	.word 0xe8cc2000  ! 4716: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r20
	mov	0x50, %r17
	.word 0xe8bca000  ! 4718: STDA_I	stda	%r20, [%r18 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xe8bc6000  ! 4720: STDA_I	stda	%r20, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 4721: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r24
	.word 0xe494c400  ! 4723: LDUHA_R	lduha	[%r19, %r0] 0x20, %r18
	.word 0xe49fce60  ! 4724: LDDA_R	ldda	[%r31, %r0] 0x73, %r18
	.word 0xe4b62000  ! 4725: STHA_I	stha	%r18, [%r24 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xe4aea000  ! 4727: STBA_I	stba	%r18, [%r26 + 0x0000] %asi
	.word 0xe4b6e000  ! 4728: STHA_I	stha	%r18, [%r27 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xeecdc4a0  ! 4730: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r23
	.word 0x87802025  ! 4731: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeec56000  ! 4732: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r23
	.word 0xeed5e000  ! 4733: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r23
	mov	0x7f0, %r20
	.word 0xeeada000  ! 4735: STBA_I	stba	%r23, [%r22 + 0x0000] %asi
	.word 0xeea5e000  ! 4736: STWA_I	stwa	%r23, [%r23 + 0x0000] %asi
	mov	0x0, %r24
	mov	0x70, %r24
	.word 0xee8da000  ! 4739: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r23
	.word 0xeeada000  ! 4740: STBA_I	stba	%r23, [%r22 + 0x0000] %asi
	.word 0xeea52000  ! 4741: STWA_I	stwa	%r23, [%r20 + 0x0000] %asi
	mov	0x7e0, %r21
	.word 0xe2c44400  ! 4743: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r17
	mov	0x70, %r16
	mov	0x3d0, %r21
	.word 0x87802074  ! 4746: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2df6000  ! 4747: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r17
	mov	0x7f8, %r23
	.word 0xeab609e0  ! 4749: STHA_R	stha	%r21, [%r24 + %r0] 0x4f
	.word 0xeaf72000  ! 4750: STXA_I	stxa	%r21, [%r28 + 0x0000] %asi
	.word 0xe48f0e40  ! 4751: LDUBA_R	lduba	[%r28, %r0] 0x72, %r18
	.word 0xe4bf2000  ! 4752: STDA_I	stda	%r18, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 4753: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4754: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r23
	.word 0xe4a44400  ! 4756: STWA_R	stwa	%r18, [%r17 + %r0] 0x20
	.word 0xe09c4400  ! 4757: LDDA_R	ldda	[%r17, %r0] 0x20, %r16
	.word 0xe09c2000  ! 4758: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r16
	.word 0xe08504a0  ! 4759: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r16
	.word 0xe89fce80  ! 4760: LDDA_R	ldda	[%r31, %r0] 0x74, %r20
	mov	0x7c8, %r20
	.word 0xe8b4a000  ! 4762: STHA_I	stha	%r20, [%r18 + 0x0000] %asi
	.word 0xe69c0400  ! 4763: LDDA_R	ldda	[%r16, %r0] 0x20, %r19
	.word 0xe6946000  ! 4764: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r19
	.word 0xe6ac2000  ! 4765: STBA_I	stba	%r19, [%r16 + 0x0000] %asi
	.word 0xe6d7ce80  ! 4766: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r19
	.word 0xe0c74e80  ! 4767: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r16
	.word 0xe4b44400  ! 4768: STHA_R	stha	%r18, [%r17 + %r0] 0x20
	.word 0xe4bce000  ! 4769: STDA_I	stda	%r18, [%r19 + 0x0000] %asi
	.word 0xe297ce40  ! 4770: LDUHA_R	lduha	[%r31, %r0] 0x72, %r17
	.word 0xe2f4a000  ! 4771: STXA_I	stxa	%r17, [%r18 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xee940400  ! 4773: LDUHA_R	lduha	[%r16, %r0] 0x20, %r23
	.word 0x87802073  ! 4774: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeec7e000  ! 4775: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r23
	.word 0x87802072  ! 4776: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0f4c400  ! 4777: STXA_R	stxa	%r16, [%r19 + %r0] 0x20
	.word 0xe0df6000  ! 4778: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r16
	.word 0xe0a72000  ! 4779: STWA_I	stwa	%r16, [%r28 + 0x0000] %asi
	.word 0xe8c74e40  ! 4780: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r20
	.word 0xe8d78e60  ! 4781: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r20
	.word 0xe88f6000  ! 4782: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r20
	.word 0x87802020  ! 4783: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecf74e80  ! 4784: STXA_R	stxa	%r22, [%r29 + %r0] 0x74
	.word 0xecb42000  ! 4785: STHA_I	stha	%r22, [%r16 + 0x0000] %asi
	.word 0xeca46000  ! 4786: STWA_I	stwa	%r22, [%r17 + 0x0000] %asi
	.word 0xec9ca000  ! 4787: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r22
	.word 0xe08c8400  ! 4788: LDUBA_R	lduba	[%r18, %r0] 0x20, %r16
	.word 0x87802020  ! 4789: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4790: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r22
	mov	0x8, %r24
	.word 0xe4af0e40  ! 4793: STBA_R	stba	%r18, [%r28 + %r0] 0x72
	.word 0xe4d66000  ! 4794: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r18
	mov	0x48, %r27
	.word 0xe49ea000  ! 4796: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r18
	.word 0xe49fce80  ! 4797: LDDA_R	ldda	[%r31, %r0] 0x74, %r18
	.word 0xe2f78e40  ! 4798: STXA_R	stxa	%r17, [%r30 + %r0] 0x72
	mov	0x48, %r27
	.word 0xe2f6e000  ! 4800: STXA_I	stxa	%r17, [%r27 + 0x0000] %asi
	.word 0xe0dcc400  ! 4801: LDXA_R	ldxa	[%r19, %r0] 0x20, %r16
	.word 0x87802020  ! 4802: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r21
	.word 0xe0dce000  ! 4804: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r16
	mov	0x3e0, %r23
	mov	0x20, %r24
	.word 0xe2d609e0  ! 4807: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r17
	.word 0xe2b4e000  ! 4808: STHA_I	stha	%r17, [%r19 + 0x0000] %asi
	.word 0xecacc400  ! 4809: STBA_R	stba	%r22, [%r19 + %r0] 0x20
	mov	0x8, %r18
	.word 0xec9c2000  ! 4811: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r22
	.word 0x87802020  ! 4812: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec87ce40  ! 4813: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r22
	.word 0xecb42000  ! 4814: STHA_I	stha	%r22, [%r16 + 0x0000] %asi
	.word 0xe6f7ce80  ! 4815: STXA_R	stxa	%r19, [%r31 + %r0] 0x74
	mov	0x8, %r24
	.word 0xe6bce000  ! 4817: STDA_I	stda	%r19, [%r19 + 0x0000] %asi
	wr_tick_cmpr_0_35:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x87, %g2
	or	%g4, 0xf1, %g4
	or	%g6, 0x85, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 4819: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6ce89e0  ! 4820: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r19
	.word 0xe6d72000  ! 4821: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r19
	.word 0x87802020  ! 4822: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4823: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0afce60  ! 4824: STBA_R	stba	%r16, [%r31 + %r0] 0x73
	.word 0xecd40400  ! 4825: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r22
	.word 0xec8fe000  ! 4826: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r22
	mov	0x3c8, %r23
	.word 0xecbfa000  ! 4828: STDA_I	stda	%r22, [%r30 + 0x0000] %asi
	.word 0xec8fe000  ! 4829: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r22
	mov	0x78, %r25
	.word 0xec8fe000  ! 4831: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r22
	mov	0x3e8, %r23
	.word 0xecd7e000  ! 4833: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r22
	.word 0xec976000  ! 4834: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r22
	.word 0xec9fa000  ! 4835: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r22
	.word 0xec87a000  ! 4836: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r22
	.word 0xecd72000  ! 4837: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r22
	mov	0x0, %r19
	.word 0xecf76000  ! 4839: STXA_I	stxa	%r22, [%r29 + 0x0000] %asi
	.word 0xec972000  ! 4840: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r22
	.word 0x87802020  ! 4841: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe08584a0  ! 4842: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r16
	.word 0xe29584a0  ! 4843: LDUHA_R	lduha	[%r22, %r0] 0x25, %r17
	.word 0xe2bc6000  ! 4844: STDA_I	stda	%r17, [%r17 + 0x0000] %asi
	.word 0xe2bce000  ! 4845: STDA_I	stda	%r17, [%r19 + 0x0000] %asi
	.word 0xe29c2000  ! 4846: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r17
	.word 0xe6d40400  ! 4847: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r19
	.word 0xeca78e80  ! 4848: STWA_R	stwa	%r22, [%r30 + %r0] 0x74
	.word 0xe2b70e40  ! 4849: STHA_R	stha	%r17, [%r28 + %r0] 0x72
	.word 0xe29ce000  ! 4850: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r17
	.word 0xe8cf4e60  ! 4851: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r20
	.word 0xe8dc2000  ! 4852: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r20
	.word 0xe6c70e40  ! 4853: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r19
	.word 0xe6dca000  ! 4854: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r19
	.word 0xe6c4a000  ! 4855: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r19
	.word 0xe6f42000  ! 4856: STXA_I	stxa	%r19, [%r16 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xe4d78e60  ! 4858: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r18
	.word 0x87802073  ! 4859: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 4860: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4a7a000  ! 4861: STWA_I	stwa	%r18, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 4862: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4af6000  ! 4863: STBA_I	stba	%r18, [%r29 + 0x0000] %asi
	.word 0xe4dfe000  ! 4864: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r18
	.word 0xe4af2000  ! 4865: STBA_I	stba	%r18, [%r28 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xe4f7e000  ! 4867: STXA_I	stxa	%r18, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 4868: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4d6a000  ! 4869: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r18
	.word 0x87802073  ! 4870: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r16
	.word 0xe6bc4400  ! 4872: STDA_R	stda	%r19, [%r17 + %r0] 0x20
	.word 0xeaa74e80  ! 4873: STWA_R	stwa	%r21, [%r29 + %r0] 0x74
	mov	0x3c8, %r22
	mov	0x68, %r17
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xeabf6000  ! 4877: STDA_I	stda	%r21, [%r29 + 0x0000] %asi
	mov	0x20, %r17
	ta	T_CHANGE_PRIV	! macro
	.word 0xee8fce60  ! 4880: LDUBA_R	lduba	[%r31, %r0] 0x73, %r23
	.word 0xecf6c9e0  ! 4881: STXA_R	stxa	%r22, [%r27 + %r0] 0x4f
	mov	0x3d8, %r22
	.word 0xecc72000  ! 4883: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r22
	mov	0x10, %r19
	mov	0x28, %r25
	.word 0xeca7ce60  ! 4886: STWA_R	stwa	%r22, [%r31 + %r0] 0x73
	.word 0xec972000  ! 4887: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r22
	.word 0xecbfe000  ! 4888: STDA_I	stda	%r22, [%r31 + 0x0000] %asi
	.word 0xecc72000  ! 4889: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r22
	.word 0xecb72000  ! 4890: STHA_I	stha	%r22, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 4891: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecbd6000  ! 4892: STDA_I	stda	%r22, [%r21 + 0x0000] %asi
	.word 0xee87ce60  ! 4893: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r23
	.word 0xe8944400  ! 4894: LDUHA_R	lduha	[%r17, %r0] 0x20, %r20
	.word 0xe8a52000  ! 4895: STWA_I	stwa	%r20, [%r20 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xe885a000  ! 4897: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r20
	.word 0xe8856000  ! 4898: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r20
	.word 0xe8dda000  ! 4899: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r20
	.word 0xeef44400  ! 4900: STXA_R	stxa	%r23, [%r17 + %r0] 0x20
	.word 0xeeb52000  ! 4901: STHA_I	stha	%r23, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 4902: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4903: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 4904: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_0_36:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd9, %g2
	or	%g4, 0x90, %g4
	or	%g6, 0xb0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe8ae89e0  ! 4906: STBA_R	stba	%r20, [%r26 + %r0] 0x4f
	.word 0xee8584a0  ! 4907: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r23
	.word 0xecb504a0  ! 4908: STHA_R	stha	%r22, [%r20 + %r0] 0x25
	.word 0xe0a48400  ! 4909: STWA_R	stwa	%r16, [%r18 + %r0] 0x20
	.word 0xe0976000  ! 4910: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r16
	.word 0xe09fe000  ! 4911: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r16
	.word 0xe2afce80  ! 4912: STBA_R	stba	%r17, [%r31 + %r0] 0x74
	.word 0xe2d76000  ! 4913: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r17
	mov	0x20, %r19
	mov	0x68, %r27
	.word 0xe8c40400  ! 4916: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r20
	.word 0xe0970e80  ! 4917: LDUHA_R	lduha	[%r28, %r0] 0x74, %r16
	.word 0xe8bcc400  ! 4918: STDA_R	stda	%r20, [%r19 + %r0] 0x20
	.word 0xecbc4400  ! 4919: STDA_R	stda	%r22, [%r17 + %r0] 0x20
	mov	0x7e8, %r20
	.word 0xec97a000  ! 4921: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r22
	mov	0x20, %r27
	.word 0xecd76000  ! 4923: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r22
	.word 0xecdfe000  ! 4924: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r22
	.word 0xecdfa000  ! 4925: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r22
	mov	0x48, %r17
	.word 0xea9cc400  ! 4927: LDDA_R	ldda	[%r19, %r0] 0x20, %r21
	mov	0x10, %r16
	.word 0xe2f74e60  ! 4929: STXA_R	stxa	%r17, [%r29 + %r0] 0x73
	.word 0x87802020  ! 4930: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r17
	mov	0x18, %r25
	.word 0xe2974e80  ! 4933: LDUHA_R	lduha	[%r29, %r0] 0x74, %r17
	.word 0xe8b70e80  ! 4934: STHA_R	stha	%r20, [%r28 + %r0] 0x74
	.word 0xe8c4e000  ! 4935: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r20
	wr_tick_cmpr_0_37:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x91, %g2
	or	%g4, 0xe6, %g4
	or	%g6, 0x82, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeeb609e0  ! 4937: STHA_R	stha	%r23, [%r24 + %r0] 0x4f
	.word 0xe89689e0  ! 4938: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r20
	.word 0xe8bce000  ! 4939: STDA_I	stda	%r20, [%r19 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xe8a7ce40  ! 4941: STWA_R	stwa	%r20, [%r31 + %r0] 0x72
	.word 0xe8be09e0  ! 4942: STDA_R	stda	%r20, [%r24 + %r0] 0x4f
	mov	0x7e0, %r23
	.word 0xe8dce000  ! 4944: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r20
	mov	0x70, %r27
	mov	0x3d0, %r22
	.word 0xe8f42000  ! 4947: STXA_I	stxa	%r20, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4948: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r22
	.word 0x87802020  ! 4950: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8c42000  ! 4951: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r20
	.word 0xe8aca000  ! 4952: STBA_I	stba	%r20, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 4953: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe89d6000  ! 4954: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r20
	.word 0xe8a5e000  ! 4955: STWA_I	stwa	%r20, [%r23 + 0x0000] %asi
	.word 0xe8b56000  ! 4956: STHA_I	stha	%r20, [%r21 + 0x0000] %asi
	.word 0xe2bd04a0  ! 4957: STDA_R	stda	%r17, [%r20 + %r0] 0x25
	.word 0x87802020  ! 4958: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2bc6000  ! 4959: STDA_I	stda	%r17, [%r17 + 0x0000] %asi
	.word 0xe2ace000  ! 4960: STBA_I	stba	%r17, [%r19 + 0x0000] %asi
	.word 0xeef78e60  ! 4961: STXA_R	stxa	%r23, [%r30 + %r0] 0x73
	.word 0xe89649e0  ! 4962: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r20
	.word 0xecde89e0  ! 4963: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r22
	.word 0xecb42000  ! 4964: STHA_I	stha	%r22, [%r16 + 0x0000] %asi
	.word 0xe8f504a0  ! 4965: STXA_R	stxa	%r20, [%r20 + %r0] 0x25
	.word 0xe8ac2000  ! 4966: STBA_I	stba	%r20, [%r16 + 0x0000] %asi
	.word 0xe8bca000  ! 4967: STDA_I	stda	%r20, [%r18 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xecf544a0  ! 4969: STXA_R	stxa	%r22, [%r21 + %r0] 0x25
	.word 0xeedf8e40  ! 4970: LDXA_R	ldxa	[%r30, %r0] 0x72, %r23
	.word 0xeeb4a000  ! 4971: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	.word 0xeeb4e000  ! 4972: STHA_I	stha	%r23, [%r19 + 0x0000] %asi
	mov	0x10, %r27
	mov	0x50, %r24
	.word 0xe4b649e0  ! 4975: STHA_R	stha	%r18, [%r25 + %r0] 0x4f
	.word 0xec970e40  ! 4976: LDUHA_R	lduha	[%r28, %r0] 0x72, %r22
	.word 0xecaca000  ! 4977: STBA_I	stba	%r22, [%r18 + 0x0000] %asi
	.word 0xeca4a000  ! 4978: STWA_I	stwa	%r22, [%r18 + 0x0000] %asi
	.word 0xec942000  ! 4979: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r22
	.word 0xecac2000  ! 4980: STBA_I	stba	%r22, [%r16 + 0x0000] %asi
	.word 0xecbc2000  ! 4981: STDA_I	stda	%r22, [%r16 + 0x0000] %asi
	.word 0xecd46000  ! 4982: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r22
	.word 0xecbc2000  ! 4983: STDA_I	stda	%r22, [%r16 + 0x0000] %asi
	.word 0xecb4e000  ! 4984: STHA_I	stha	%r22, [%r19 + 0x0000] %asi
	.word 0xec978e60  ! 4985: LDUHA_R	lduha	[%r30, %r0] 0x73, %r22
	.word 0xe6cfce60  ! 4986: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r19
	.word 0xe6bc6000  ! 4987: STDA_I	stda	%r19, [%r17 + 0x0000] %asi
	.word 0xeedc8400  ! 4988: LDXA_R	ldxa	[%r18, %r0] 0x20, %r23
	.word 0xeaa78e80  ! 4989: STWA_R	stwa	%r21, [%r30 + %r0] 0x74
	.word 0xe8aec9e0  ! 4990: STBA_R	stba	%r20, [%r27 + %r0] 0x4f
	mov	0x28, %r18
	.word 0x87802073  ! 4992: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8b7a000  ! 4993: STHA_I	stha	%r20, [%r30 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xe89e49e0  ! 4995: LDDA_R	ldda	[%r25, %r0] 0x4f, %r20
	mov	0x3d8, %r21
	mov	0x20, %r18
	.word 0xe8afe000  ! 4998: STBA_I	stba	%r20, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 4999: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r26
	.word 0xecb40400  ! 5001: STHA_R	stha	%r22, [%r16 + %r0] 0x20
	.word 0x87802073  ! 5002: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xecbfa000  ! 5003: STDA_I	stda	%r22, [%r30 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xeac6c9e0  ! 5005: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r21
	.word 0x87802073  ! 5006: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r26
	.word 0xeaa7e000  ! 5008: STWA_I	stwa	%r21, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 5009: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r22
	.word 0xeab76000  ! 5011: STHA_I	stha	%r21, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 5012: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea9ce000  ! 5013: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r21
	mov	0x60, %r17
	.word 0x87802073  ! 5015: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeaf7e000  ! 5016: STXA_I	stxa	%r21, [%r31 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xe48d84a0  ! 5018: LDUBA_R	lduba	[%r22, %r0] 0x25, %r18
	.word 0xeebfce80  ! 5019: STDA_R	stda	%r23, [%r31 + %r0] 0x74
	.word 0xeab584a0  ! 5020: STHA_R	stha	%r21, [%r22 + %r0] 0x25
	.word 0xeaf76000  ! 5021: STXA_I	stxa	%r21, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 5022: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea9ca000  ! 5023: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r21
	.word 0xeaa48400  ! 5024: STWA_R	stwa	%r21, [%r18 + %r0] 0x20
	.word 0xeaa4a000  ! 5025: STWA_I	stwa	%r21, [%r18 + 0x0000] %asi
	.word 0xeac4e000  ! 5026: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r21
	.word 0x87802073  ! 5027: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8a504a0  ! 5028: STWA_R	stwa	%r20, [%r20 + %r0] 0x25
	.word 0xe4848400  ! 5029: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r18
	.word 0xe4874e40  ! 5030: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r18
	mov	0x3c8, %r23
	.word 0xee84c400  ! 5032: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r23
	.word 0xeecf0e80  ! 5033: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r23
	mov	0x78, %r19
	.word 0xeab70e40  ! 5035: STHA_R	stha	%r21, [%r28 + %r0] 0x72
	.word 0x87802020  ! 5036: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r21
	mov	0x3f8, %r22
	.word 0xeab46000  ! 5039: STHA_I	stha	%r21, [%r17 + 0x0000] %asi
	.word 0xeadca000  ! 5040: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r21
	.word 0xeaf4e000  ! 5041: STXA_I	stxa	%r21, [%r19 + 0x0000] %asi
	.word 0xeaf4a000  ! 5042: STXA_I	stxa	%r21, [%r18 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0x8780204f  ! 5044: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_0_38:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x90, %g2
	or	%g4, 0x85, %g4
	or	%g6, 0xc1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 5046: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r24
	.word 0xe4cf0e80  ! 5048: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r18
	.word 0xe4f76000  ! 5049: STXA_I	stxa	%r18, [%r29 + 0x0000] %asi
	.word 0xe4af6000  ! 5050: STBA_I	stba	%r18, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 5051: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4d7a000  ! 5052: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r18
	mov	0x3e0, %r20
	.word 0xeca44400  ! 5054: STWA_R	stwa	%r22, [%r17 + %r0] 0x20
	.word 0xeccc4400  ! 5055: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r22
	.word 0x87802020  ! 5056: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x0, %r18
	.word 0xec946000  ! 5059: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r22
	.word 0x87802073  ! 5060: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r18
	.word 0xecd74e40  ! 5062: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r22
	.word 0xecf72000  ! 5063: STXA_I	stxa	%r22, [%r28 + 0x0000] %asi
	.word 0xecb72000  ! 5064: STHA_I	stha	%r22, [%r28 + 0x0000] %asi
	.word 0xecbf8e60  ! 5065: STDA_R	stda	%r22, [%r30 + %r0] 0x73
	.word 0x87802020  ! 5066: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r17
	.word 0xeadf0e40  ! 5068: LDXA_R	ldxa	[%r28, %r0] 0x72, %r21
	.word 0xeab42000  ! 5069: STHA_I	stha	%r21, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 5070: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xead4e000  ! 5071: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r21
	.word 0xeab4e000  ! 5072: STHA_I	stha	%r21, [%r19 + 0x0000] %asi
	.word 0xeab42000  ! 5073: STHA_I	stha	%r21, [%r16 + 0x0000] %asi
	.word 0xe6b78e40  ! 5074: STHA_R	stha	%r19, [%r30 + %r0] 0x72
	.word 0xe29504a0  ! 5075: LDUHA_R	lduha	[%r20, %r0] 0x25, %r17
	mov	0x7f8, %r22
	.word 0xe8bf8e60  ! 5077: STDA_R	stda	%r20, [%r30 + %r0] 0x73
	.word 0xe0f7ce80  ! 5078: STXA_R	stxa	%r16, [%r31 + %r0] 0x74
	mov	0x68, %r17
	wr_tick_cmpr_0_39:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe7, %g2
	or	%g4, 0xb0, %g4
	or	%g6, 0xc3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xecdf4e60  ! 5081: LDXA_R	ldxa	[%r29, %r0] 0x73, %r22
	.word 0xecf609e0  ! 5082: STXA_R	stxa	%r22, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 5083: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r20
	.word 0xec9ce000  ! 5085: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r22
	.word 0x8780204f  ! 5086: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecb6a000  ! 5087: STHA_I	stha	%r22, [%r26 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xeaf584a0  ! 5089: STXA_R	stxa	%r21, [%r22 + %r0] 0x25
	mov	0x3e0, %r20
	.word 0xe4a74e40  ! 5091: STWA_R	stwa	%r18, [%r29 + %r0] 0x72
	.word 0xe4aee000  ! 5092: STBA_I	stba	%r18, [%r27 + 0x0000] %asi
	.word 0xe4a6e000  ! 5093: STWA_I	stwa	%r18, [%r27 + 0x0000] %asi
	.word 0xe8bf4e60  ! 5094: STDA_R	stda	%r20, [%r29 + %r0] 0x73
	.word 0xe0b78e40  ! 5095: STHA_R	stha	%r16, [%r30 + %r0] 0x72
	.word 0x87802025  ! 5096: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6dcc400  ! 5097: LDXA_R	ldxa	[%r19, %r0] 0x20, %r19
	mov	0x0, %r18
	.word 0xe6f52000  ! 5099: STXA_I	stxa	%r19, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 5100: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe69e6000  ! 5101: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r19
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xe6c62000  ! 5103: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r19
	mov	0x18, %r16
	.word 0x87802020  ! 5105: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r20
	.word 0xecc48400  ! 5107: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r22
	mov	0x7c8, %r21
	.word 0x87802074  ! 5109: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeccf2000  ! 5110: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r22
	.word 0x87802073  ! 5111: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 5112: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xec9ee000  ! 5113: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r22
	mov	0x3c0, %r21
	mov	0x8, %r19
	.word 0xe2a7ce40  ! 5116: STWA_R	stwa	%r17, [%r31 + %r0] 0x72
	.word 0xee8e09e0  ! 5117: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r23
	.word 0x87802073  ! 5118: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r18
	.word 0xeeb72000  ! 5120: STHA_I	stha	%r23, [%r28 + 0x0000] %asi
	.word 0xeebfa000  ! 5121: STDA_I	stda	%r23, [%r30 + 0x0000] %asi
	.word 0xe0f44400  ! 5122: STXA_R	stxa	%r16, [%r17 + %r0] 0x20
	mov	0x30, %r16
	.word 0xe8ad04a0  ! 5124: STBA_R	stba	%r20, [%r20 + %r0] 0x25
	.word 0xeebf4e40  ! 5125: STDA_R	stda	%r23, [%r29 + %r0] 0x72
	.word 0xee97a000  ! 5126: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r23
	.word 0xee972000  ! 5127: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r23
	ta	T_CHANGE_HPRIV	! macro
	.word 0xeeb76000  ! 5129: STHA_I	stha	%r23, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 5130: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xee8f8e60  ! 5131: LDUBA_R	lduba	[%r30, %r0] 0x73, %r23
	.word 0xee9e6000  ! 5132: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r23
	mov	0x3d8, %r20
	.word 0xeef6a000  ! 5134: STXA_I	stxa	%r23, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 5135: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 5136: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8cf0e80  ! 5137: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r20
	.word 0xe6c48400  ! 5138: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r19
	.word 0xe6f70e80  ! 5139: STXA_R	stxa	%r19, [%r28 + %r0] 0x74
	.word 0xe6b5e000  ! 5140: STHA_I	stha	%r19, [%r23 + 0x0000] %asi
	.word 0xe6f5a000  ! 5141: STXA_I	stxa	%r19, [%r22 + 0x0000] %asi
	.word 0xe6ad6000  ! 5142: STBA_I	stba	%r19, [%r21 + 0x0000] %asi
	.word 0xe6a5e000  ! 5143: STWA_I	stwa	%r19, [%r23 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xe6c52000  ! 5145: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r19
	.word 0xe0d5c4a0  ! 5146: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r16
	mov	0x28, %r27
	.word 0x87802072  ! 5148: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r24
	.word 0xe0bfe000  ! 5150: STDA_I	stda	%r16, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 5151: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r23
	.word 0xeaa40400  ! 5153: STWA_R	stwa	%r21, [%r16 + %r0] 0x20
	.word 0xead7e000  ! 5154: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r21
	mov	0x7d0, %r23
	mov	0x7d0, %r22
	mov	0x0, %r17
	mov	0x58, %r24
	mov	0x60, %r25
	.word 0xeadf2000  ! 5160: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r21
	.word 0xeeae49e0  ! 5161: STBA_R	stba	%r23, [%r25 + %r0] 0x4f
	.word 0xeeaf4e80  ! 5162: STBA_R	stba	%r23, [%r29 + %r0] 0x74
	.word 0xeea76000  ! 5163: STWA_I	stwa	%r23, [%r29 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xe4d689e0  ! 5165: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r18
	.word 0xead7ce40  ! 5166: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r21
	.word 0xeacf2000  ! 5167: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r21
	mov	0x50, %r19
	.word 0x8780204f  ! 5169: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xea966000  ! 5170: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r21
	.word 0xeade2000  ! 5171: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r21
	mov	0x60, %r18
	.word 0xe6bc4400  ! 5173: STDA_R	stda	%r19, [%r17 + %r0] 0x20
	mov	0x30, %r24
	.word 0xe6b62000  ! 5175: STHA_I	stha	%r19, [%r24 + 0x0000] %asi
	.word 0xe69dc4a0  ! 5176: LDDA_R	ldda	[%r23, %r0] 0x25, %r19
	.word 0x87802073  ! 5177: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d0, %r23
	.word 0x8780204f  ! 5179: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6dee000  ! 5180: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r19
	.word 0xe2afce80  ! 5181: STBA_R	stba	%r17, [%r31 + %r0] 0x74
	.word 0xecb74e60  ! 5182: STHA_R	stha	%r22, [%r29 + %r0] 0x73
	.word 0x87802073  ! 5183: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xec9fa000  ! 5184: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r22
	.word 0xeccf4e80  ! 5185: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r22
	.word 0xec8f6000  ! 5186: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	mov	0x58, %r25
	mov	0x40, %r17
	.word 0xecaec9e0  ! 5189: STBA_R	stba	%r22, [%r27 + %r0] 0x4f
	mov	0x60, %r19
	.word 0xeca76000  ! 5191: STWA_I	stwa	%r22, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 5192: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 5193: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe287ce60  ! 5194: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r17
	.word 0xe2d7a000  ! 5195: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r17
	.word 0xe6f44400  ! 5196: STXA_R	stxa	%r19, [%r17 + %r0] 0x20
	.word 0xe6d7ce60  ! 5197: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r19
	.word 0xe6f7a000  ! 5198: STXA_I	stxa	%r19, [%r30 + 0x0000] %asi
	.word 0xe4bf8e40  ! 5199: STDA_R	stda	%r18, [%r30 + %r0] 0x72
	.word 0x87802020  ! 5200: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 5201: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8a504a0  ! 5202: STWA_R	stwa	%r20, [%r20 + %r0] 0x25
	mov	0x28, %r27
	.word 0xe8b76000  ! 5204: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	.word 0xe8d76000  ! 5205: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r20
	.word 0xe8cfa000  ! 5206: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r20
	.word 0xe4b70e60  ! 5207: STHA_R	stha	%r18, [%r28 + %r0] 0x73
	.word 0xe8b74e80  ! 5208: STHA_R	stha	%r20, [%r29 + %r0] 0x74
	.word 0xe8df6000  ! 5209: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r20
	.word 0xe8b7a000  ! 5210: STHA_I	stha	%r20, [%r30 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xe8f72000  ! 5212: STXA_I	stxa	%r20, [%r28 + 0x0000] %asi
	mov	0x60, %r18
	.word 0x87802020  ! 5214: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec97ce40  ! 5215: LDUHA_R	lduha	[%r31, %r0] 0x72, %r22
	.word 0xe4a7ce40  ! 5216: STWA_R	stwa	%r18, [%r31 + %r0] 0x72
	mov	0x30, %r16
	.word 0xeacf0e40  ! 5218: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r21
	.word 0xeabca000  ! 5219: STDA_I	stda	%r21, [%r18 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xeaf4a000  ! 5221: STXA_I	stxa	%r21, [%r18 + 0x0000] %asi
	.word 0xea94e000  ! 5222: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r21
	.word 0xeaf42000  ! 5223: STXA_I	stxa	%r21, [%r16 + 0x0000] %asi
	.word 0xe8b48400  ! 5224: STHA_R	stha	%r20, [%r18 + %r0] 0x20
	.word 0xe8a42000  ! 5225: STWA_I	stwa	%r20, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 5226: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r19
	.word 0xeabf4e80  ! 5228: STDA_R	stda	%r21, [%r29 + %r0] 0x74
	.word 0x87802072  ! 5229: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeaa72000  ! 5230: STWA_I	stwa	%r21, [%r28 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xe6a40400  ! 5232: STWA_R	stwa	%r19, [%r16 + %r0] 0x20
	.word 0xe6876000  ! 5233: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r19
	.word 0xe6b76000  ! 5234: STHA_I	stha	%r19, [%r29 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xe6bfce60  ! 5236: STDA_R	stda	%r19, [%r31 + %r0] 0x73
	.word 0xe6a76000  ! 5237: STWA_I	stwa	%r19, [%r29 + 0x0000] %asi
	mov	0x68, %r18
	mov	0x28, %r16
	mov	0x7f0, %r22
	.word 0xe4af4e40  ! 5241: STBA_R	stba	%r18, [%r29 + %r0] 0x72
	.word 0xe8b40400  ! 5242: STHA_R	stha	%r20, [%r16 + %r0] 0x20
	mov	0x7f0, %r23
	mov	0x78, %r24
	.word 0xe29689e0  ! 5245: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r17
	mov	0x68, %r16
	.word 0xe2d72000  ! 5247: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r17
	.word 0xe2f72000  ! 5248: STXA_I	stxa	%r17, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 5249: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 5250: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d0, %r20
	.word 0xe2dfa000  ! 5252: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r17
	.word 0x87802020  ! 5253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2b4a000  ! 5254: STHA_I	stha	%r17, [%r18 + 0x0000] %asi
	.word 0xe2a4e000  ! 5255: STWA_I	stwa	%r17, [%r19 + 0x0000] %asi
	mov	0x7c8, %r23
	mov	0x30, %r16
	.word 0x87802025  ! 5258: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe285e000  ! 5259: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r17
	mov	0x7d8, %r20
	.word 0x87802020  ! 5261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea9fce40  ! 5262: LDDA_R	ldda	[%r31, %r0] 0x72, %r21
	.word 0x87802074  ! 5263: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r20
	mov	0x50, %r19
	.word 0xeaf76000  ! 5266: STXA_I	stxa	%r21, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 5267: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xea8f2000  ! 5268: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r21
	mov	0x48, %r27
	.word 0x87802073  ! 5270: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2bfce40  ! 5271: STDA_R	stda	%r17, [%r31 + %r0] 0x72
	.word 0xe8df8e40  ! 5272: LDXA_R	ldxa	[%r30, %r0] 0x72, %r20
	.word 0xe8dfa000  ! 5273: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r20
	.word 0x87802020  ! 5274: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r17
	.word 0x87802074  ! 5276: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xec8fce60  ! 5277: LDUBA_R	lduba	[%r31, %r0] 0x73, %r22
	.word 0xecc76000  ! 5278: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0xe8af4e80  ! 5279: STBA_R	stba	%r20, [%r29 + %r0] 0x74
	.word 0x87802074  ! 5280: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r23
	mov	0x7c8, %r22
	.word 0xe8b7a000  ! 5283: STHA_I	stha	%r20, [%r30 + 0x0000] %asi
	.word 0xe8c72000  ! 5284: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r20
	.word 0xea84c400  ! 5285: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r21
	.word 0x87802025  ! 5286: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecd74e40  ! 5287: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r22
	.word 0xeca56000  ! 5288: STWA_I	stwa	%r22, [%r21 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xea8cc400  ! 5290: LDUBA_R	lduba	[%r19, %r0] 0x20, %r21
	.word 0xeab52000  ! 5291: STHA_I	stha	%r21, [%r20 + 0x0000] %asi
	.word 0xeabde000  ! 5292: STDA_I	stda	%r21, [%r23 + 0x0000] %asi
	.word 0xe2a4c400  ! 5293: STWA_R	stwa	%r17, [%r19 + %r0] 0x20
	.word 0xe2cd2000  ! 5294: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r17
	mov	0x38, %r17
	.word 0xe2af4e40  ! 5296: STBA_R	stba	%r17, [%r29 + %r0] 0x72
	.word 0x8780204f  ! 5297: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r17
	mov	0x3e8, %r23
	mov	0x7d0, %r22
	.word 0xe2b62000  ! 5301: STHA_I	stha	%r17, [%r24 + 0x0000] %asi
	.word 0xe484c400  ! 5302: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r18
	mov	0x68, %r24
	.word 0xe4ae6000  ! 5304: STBA_I	stba	%r18, [%r25 + 0x0000] %asi
	.word 0xe8a74e80  ! 5305: STWA_R	stwa	%r20, [%r29 + %r0] 0x74
	.word 0xe8a62000  ! 5306: STWA_I	stwa	%r20, [%r24 + 0x0000] %asi
	.word 0xe8c62000  ! 5307: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r20
	.word 0xe08f8e60  ! 5308: LDUBA_R	lduba	[%r30, %r0] 0x73, %r16
	mov	0x50, %r26
	.word 0xe0a544a0  ! 5310: STWA_R	stwa	%r16, [%r21 + %r0] 0x25
	.word 0xe0be2000  ! 5311: STDA_I	stda	%r16, [%r24 + 0x0000] %asi
	.word 0xe09e6000  ! 5312: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r16
	.word 0xe4dcc400  ! 5313: LDXA_R	ldxa	[%r19, %r0] 0x20, %r18
	.word 0xeaa74e40  ! 5314: STWA_R	stwa	%r21, [%r29 + %r0] 0x72
	mov	0x3c8, %r20
	.word 0xeacf8e40  ! 5316: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r21
	.word 0xeaa48400  ! 5317: STWA_R	stwa	%r21, [%r18 + %r0] 0x20
	.word 0xeaaea000  ! 5318: STBA_I	stba	%r21, [%r26 + 0x0000] %asi
	.word 0xe2cf8e60  ! 5319: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r17
	.word 0xe2cee000  ! 5320: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r17
	.word 0xe2d6e000  ! 5321: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r17
	.word 0x87802072  ! 5322: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c8, %r22
	.word 0xe287a000  ! 5324: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r17
	.word 0xe6ac0400  ! 5325: STBA_R	stba	%r19, [%r16 + %r0] 0x20
	.word 0xe6a7e000  ! 5326: STWA_I	stwa	%r19, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 5327: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 5328: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 5329: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 5330: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe68e2000  ! 5331: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r19
	.word 0xe6a6a000  ! 5332: STWA_I	stwa	%r19, [%r26 + 0x0000] %asi
	.word 0xea9e49e0  ! 5333: LDDA_R	ldda	[%r25, %r0] 0x4f, %r21
	.word 0xe49e89e0  ! 5334: LDDA_R	ldda	[%r26, %r0] 0x4f, %r18
	.word 0xe8c609e0  ! 5335: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r20
	.word 0xe8d62000  ! 5336: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r20
	.word 0xe8d66000  ! 5337: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r20
	.word 0x87802025  ! 5338: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r23
	mov	0x50, %r18
	.word 0x8780204f  ! 5341: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8ce2000  ! 5342: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r20
	mov	0x50, %r18
	.word 0xe8aea000  ! 5344: STBA_I	stba	%r20, [%r26 + 0x0000] %asi
	.word 0xe8aee000  ! 5345: STBA_I	stba	%r20, [%r27 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xe8c6a000  ! 5347: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r20
	.word 0xe8962000  ! 5348: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r20
	.word 0xead78e60  ! 5349: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r21
	.word 0xea940400  ! 5350: LDUHA_R	lduha	[%r16, %r0] 0x20, %r21
	.word 0xea96e000  ! 5351: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r21
	.word 0xe8978e60  ! 5352: LDUHA_R	lduha	[%r30, %r0] 0x73, %r20
	.word 0xe6de09e0  ! 5353: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r19
	.word 0xe6f7ce40  ! 5354: STXA_R	stxa	%r19, [%r31 + %r0] 0x72
	mov	0x7c0, %r21
	mov	0x18, %r26
	.word 0xec9d84a0  ! 5357: LDDA_R	ldda	[%r22, %r0] 0x25, %r22
	.word 0x87802020  ! 5358: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 5359: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecace000  ! 5360: STBA_I	stba	%r22, [%r19 + 0x0000] %asi
	.word 0xee84c400  ! 5361: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r23
	.word 0xe0cf8e40  ! 5362: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r16
	.word 0xe0842000  ! 5363: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r16
	.word 0xe0f4e000  ! 5364: STXA_I	stxa	%r16, [%r19 + 0x0000] %asi
	.word 0xec948400  ! 5365: LDUHA_R	lduha	[%r18, %r0] 0x20, %r22
	.word 0x8780204f  ! 5366: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xec974e60  ! 5367: LDUHA_R	lduha	[%r29, %r0] 0x73, %r22
	.word 0xe6f78e80  ! 5368: STXA_R	stxa	%r19, [%r30 + %r0] 0x74
	.word 0x87802020  ! 5369: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4970e60  ! 5370: LDUHA_R	lduha	[%r28, %r0] 0x73, %r18
	mov	0x28, %r18
	.word 0xe4c42000  ! 5372: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r18
	.word 0x87802072  ! 5373: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0f544a0  ! 5374: STXA_R	stxa	%r16, [%r21 + %r0] 0x25
	wr_tick_cmpr_0_40:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xca, %g2
	or	%g4, 0xdc, %g4
	or	%g6, 0xa2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 5376: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r16
	mov	0x30, %r18
	.word 0xe0dce000  ! 5379: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r16
	.word 0x87802020  ! 5380: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 5381: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaaf4e60  ! 5382: STBA_R	stba	%r21, [%r29 + %r0] 0x73
	.word 0xeea4c400  ! 5383: STWA_R	stwa	%r23, [%r19 + %r0] 0x20
	.word 0xe6bec9e0  ! 5384: STDA_R	stda	%r19, [%r27 + %r0] 0x4f
	.word 0xe68d44a0  ! 5385: LDUBA_R	lduba	[%r21, %r0] 0x25, %r19
	wr_tick_cmpr_0_41:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfe, %g2
	or	%g4, 0xdd, %g4
	or	%g6, 0xa5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 5387: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 5388: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6cc6000  ! 5389: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r19
	mov	0x50, %r24
	.word 0x87802020  ! 5391: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r18
	.word 0x87802020  ! 5393: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6c42000  ! 5394: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r19
	.word 0x8780204f  ! 5395: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xee944400  ! 5396: LDUHA_R	lduha	[%r17, %r0] 0x20, %r23
	.word 0xeeaea000  ! 5397: STBA_I	stba	%r23, [%r26 + 0x0000] %asi
	.word 0xeecea000  ! 5398: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r23
	mov	0x8, %r24
	.word 0x8780204f  ! 5400: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r20
	wr_tick_cmpr_0_42:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbd, %g2
	or	%g4, 0xb2, %g4
	or	%g6, 0xc1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xee966000  ! 5403: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r23
	.word 0x87802025  ! 5404: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r17
	.word 0xeec5a000  ! 5406: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r23
	.word 0xeebde000  ! 5407: STDA_I	stda	%r23, [%r23 + 0x0000] %asi
	mov	0x70, %r19
	.word 0x87802072  ! 5409: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeed72000  ! 5410: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r23
	.word 0xeed7e000  ! 5411: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r23
	.word 0xe2a609e0  ! 5412: STWA_R	stwa	%r17, [%r24 + %r0] 0x4f
	.word 0xe6b48400  ! 5413: STHA_R	stha	%r19, [%r18 + %r0] 0x20
	mov	0x48, %r16
	.word 0xe6f72000  ! 5415: STXA_I	stxa	%r19, [%r28 + 0x0000] %asi
	.word 0xe6d7e000  ! 5416: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r19
	.word 0xe4cc4400  ! 5417: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r18
	mov	0x30, %r19
	mov	0x40, %r26
	.word 0xe4b7a000  ! 5420: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xe4bf2000  ! 5422: STDA_I	stda	%r18, [%r28 + 0x0000] %asi
	.word 0xe4b48400  ! 5423: STHA_R	stha	%r18, [%r18 + %r0] 0x20
	.word 0x87802074  ! 5424: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4a7e000  ! 5425: STWA_I	stwa	%r18, [%r31 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xe4af6000  ! 5427: STBA_I	stba	%r18, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 5428: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe486e000  ! 5429: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r18
	.word 0xeccec9e0  ! 5430: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r22
	mov	0x7d0, %r21
	mov	0x50, %r27
	.word 0xe2b7ce60  ! 5433: STHA_R	stha	%r17, [%r31 + %r0] 0x73
	mov	0x10, %r25
	.word 0xe4944400  ! 5435: LDUHA_R	lduha	[%r17, %r0] 0x20, %r18
	.word 0xeaacc400  ! 5436: STBA_R	stba	%r21, [%r19 + %r0] 0x20
	.word 0xeea48400  ! 5437: STWA_R	stwa	%r23, [%r18 + %r0] 0x20
	.word 0xee8e89e0  ! 5438: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r23
	.word 0xeedea000  ! 5439: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r23
	.word 0xec9f4e80  ! 5440: LDDA_R	ldda	[%r29, %r0] 0x74, %r22
	mov	0x3c0, %r21
	.word 0x87802073  ! 5442: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f8, %r23
	.word 0x8780204f  ! 5444: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 5445: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r19
	.word 0xe2f7ce80  ! 5447: STXA_R	stxa	%r17, [%r31 + %r0] 0x74
	.word 0x87802074  ! 5448: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 5449: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8f70e60  ! 5450: STXA_R	stxa	%r20, [%r28 + %r0] 0x73
	mov	0x7f0, %r21
	mov	0x7d8, %r23
	mov	0x3c0, %r23
	.word 0xe8a5e000  ! 5454: STWA_I	stwa	%r20, [%r23 + 0x0000] %asi
	.word 0xe085c4a0  ! 5455: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r16
	.word 0x87802073  ! 5456: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0afa000  ! 5457: STBA_I	stba	%r16, [%r30 + 0x0000] %asi
	.word 0xe0f72000  ! 5458: STXA_I	stxa	%r16, [%r28 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xe0b72000  ! 5460: STHA_I	stha	%r16, [%r28 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xee96c9e0  ! 5462: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r23
	.word 0xeed7e000  ! 5463: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r23
	.word 0xeed76000  ! 5464: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r23
	.word 0xe4cfce80  ! 5465: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r18
	.word 0xe4bf4e40  ! 5466: STDA_R	stda	%r18, [%r29 + %r0] 0x72
	.word 0xe6bdc4a0  ! 5467: STDA_R	stda	%r19, [%r23 + %r0] 0x25
	.word 0xe6972000  ! 5468: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r19
	.word 0xe6972000  ! 5469: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r19
	.word 0xe6b7e000  ! 5470: STHA_I	stha	%r19, [%r31 + 0x0000] %asi
	.word 0xe68fe000  ! 5471: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r19
	.word 0xe69f2000  ! 5472: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r19
	.word 0xe6c76000  ! 5473: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r19
	.word 0xe6b504a0  ! 5474: STHA_R	stha	%r19, [%r20 + %r0] 0x25
	.word 0xe0cf0e60  ! 5475: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r16
	.word 0xeef7ce40  ! 5476: STXA_R	stxa	%r23, [%r31 + %r0] 0x72
	.word 0xeeb7a000  ! 5477: STHA_I	stha	%r23, [%r30 + 0x0000] %asi
	.word 0xe0ac0400  ! 5478: STBA_R	stba	%r16, [%r16 + %r0] 0x20
	.word 0xe0afe000  ! 5479: STBA_I	stba	%r16, [%r31 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xe0afe000  ! 5481: STBA_I	stba	%r16, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 5482: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r26
	.word 0xe0b7a000  ! 5484: STHA_I	stha	%r16, [%r30 + 0x0000] %asi
	wr_tick_cmpr_0_43:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xec, %g2
	or	%g4, 0xcc, %g4
	or	%g6, 0xff, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe0872000  ! 5486: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r16
	.word 0xe8af8e40  ! 5487: STBA_R	stba	%r20, [%r30 + %r0] 0x72
	.word 0xe8bf6000  ! 5488: STDA_I	stda	%r20, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 5489: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2df8e60  ! 5490: LDXA_R	ldxa	[%r30, %r0] 0x73, %r17
	.word 0xeaa584a0  ! 5491: STWA_R	stwa	%r21, [%r22 + %r0] 0x25
	mov	0x38, %r17
	.word 0xeaaee000  ! 5493: STBA_I	stba	%r21, [%r27 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xeadee000  ! 5495: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r21
	.word 0x87802074  ! 5496: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0cf8e60  ! 5497: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r16
	mov	0x7c0, %r21
	.word 0xe89f4e40  ! 5499: LDDA_R	ldda	[%r29, %r0] 0x72, %r20
	.word 0x87802025  ! 5500: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r23
	.word 0x87802020  ! 5502: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8b42000  ! 5503: STHA_I	stha	%r20, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 5504: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8b44400  ! 5505: STHA_R	stha	%r20, [%r17 + %r0] 0x20
	mov	0x0, %r18
	.word 0xe8afe000  ! 5507: STBA_I	stba	%r20, [%r31 + 0x0000] %asi
	wr_tick_cmpr_0_44:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb7, %g2
	or	%g4, 0xab, %g4
	or	%g6, 0xba, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 5509: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe88c2000  ! 5510: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r20
	.word 0x87802074  ! 5511: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe8af2000  ! 5513: STBA_I	stba	%r20, [%r28 + 0x0000] %asi
	.word 0xe8b76000  ! 5514: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	.word 0xead544a0  ! 5515: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r21
	.word 0x87802074  ! 5516: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeadc0400  ! 5517: LDXA_R	ldxa	[%r16, %r0] 0x20, %r21
	mov	0x7f8, %r20
	.word 0xe0a689e0  ! 5519: STWA_R	stwa	%r16, [%r26 + %r0] 0x4f
	.word 0xe08f2000  ! 5520: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r16
	.word 0x87802072  ! 5521: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2ccc400  ! 5522: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r17
	.word 0xe4f544a0  ! 5523: STXA_R	stxa	%r18, [%r21 + %r0] 0x25
	.word 0xe8af0e60  ! 5524: STBA_R	stba	%r20, [%r28 + %r0] 0x73
	.word 0xe8d76000  ! 5525: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r20
	.word 0x87802072  ! 5526: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8876000  ! 5527: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r20
	.word 0xe6d70e60  ! 5528: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r19
	.word 0x87802020  ! 5529: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe08f0e80  ! 5530: LDUBA_R	lduba	[%r28, %r0] 0x74, %r16
	.word 0xe2940400  ! 5531: LDUHA_R	lduha	[%r16, %r0] 0x20, %r17
	.word 0xe2c46000  ! 5532: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r17
	.word 0xe2d4e000  ! 5533: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r17
	.word 0xe294e000  ! 5534: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r17
	mov	0x28, %r17
	.word 0xeab74e40  ! 5536: STHA_R	stha	%r21, [%r29 + %r0] 0x72
	.word 0xeaf46000  ! 5537: STXA_I	stxa	%r21, [%r17 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xecbc4400  ! 5539: STDA_R	stda	%r22, [%r17 + %r0] 0x20
	.word 0xe0840400  ! 5540: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r16
	.word 0x87802072  ! 5541: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 5542: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0b5a000  ! 5543: STHA_I	stha	%r16, [%r22 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xe0d56000  ! 5545: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r16
	.word 0xe6cd04a0  ! 5546: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r19
	.word 0xe6f5e000  ! 5547: STXA_I	stxa	%r19, [%r23 + 0x0000] %asi
	.word 0xe6c52000  ! 5548: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r19
	.word 0x87802073  ! 5549: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2d7ce40  ! 5550: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r17
	.word 0x87802020  ! 5551: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r27
	.word 0xe2c44400  ! 5553: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r17
	mov	0x40, %r17
	wr_tick_cmpr_0_45:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9b, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0xd4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe2f46000  ! 5556: STXA_I	stxa	%r17, [%r17 + 0x0000] %asi
	.word 0xe2c4c400  ! 5557: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r17
	.word 0xe2a46000  ! 5558: STWA_I	stwa	%r17, [%r17 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xeca74e40  ! 5560: STWA_R	stwa	%r22, [%r29 + %r0] 0x72
	mov	0x50, %r17
	.word 0x87802073  ! 5562: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 5563: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8f74e80  ! 5564: STXA_R	stxa	%r20, [%r29 + %r0] 0x74
	.word 0xe2b4c400  ! 5565: STHA_R	stha	%r17, [%r19 + %r0] 0x20
	.word 0xe2df6000  ! 5566: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r17
	.word 0x87802025  ! 5567: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0ddc4a0  ! 5568: LDXA_R	ldxa	[%r23, %r0] 0x25, %r16
	mov	0x30, %r27
	.word 0xe487ce80  ! 5570: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r18
	.word 0x87802073  ! 5571: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r24
	.word 0xe4dfa000  ! 5573: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r18
	.word 0xe6de49e0  ! 5574: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r19
	.word 0xe6df2000  ! 5575: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r19
	mov	0x68, %r25
	.word 0xe6b7e000  ! 5577: STHA_I	stha	%r19, [%r31 + 0x0000] %asi
	.word 0xecf649e0  ! 5578: STXA_R	stxa	%r22, [%r25 + %r0] 0x4f
	mov	0x10, %r17
	.word 0xeccf6000  ! 5580: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r22
	.word 0xeca7a000  ! 5581: STWA_I	stwa	%r22, [%r30 + 0x0000] %asi
	.word 0xeca72000  ! 5582: STWA_I	stwa	%r22, [%r28 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xe4940400  ! 5584: LDUHA_R	lduha	[%r16, %r0] 0x20, %r18
	.word 0xe4f7ce40  ! 5585: STXA_R	stxa	%r18, [%r31 + %r0] 0x72
	.word 0xe4af2000  ! 5586: STBA_I	stba	%r18, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 5587: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r27
	.word 0xe6c78e60  ! 5589: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r19
	mov	0x7c0, %r23
	mov	0x78, %r19
	.word 0xe0b44400  ! 5592: STHA_R	stha	%r16, [%r17 + %r0] 0x20
	mov	0x38, %r25
	.word 0xecb4c400  ! 5594: STHA_R	stha	%r22, [%r19 + %r0] 0x20
	.word 0xe4ac8400  ! 5595: STBA_R	stba	%r18, [%r18 + %r0] 0x20
	mov	0x48, %r17
	.word 0xe0cec9e0  ! 5597: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r16
	.word 0xe4f44400  ! 5598: STXA_R	stxa	%r18, [%r17 + %r0] 0x20
	.word 0xe2d44400  ! 5599: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r17
	.word 0xe8b7ce60  ! 5600: STHA_R	stha	%r20, [%r31 + %r0] 0x73
	mov	0x7e8, %r21
	mov	0x78, %r26
	.word 0xe8a5e000  ! 5603: STWA_I	stwa	%r20, [%r23 + 0x0000] %asi
	.word 0xe88da000  ! 5604: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r20
	mov	0x7f0, %r21
	.word 0xe8948400  ! 5606: LDUHA_R	lduha	[%r18, %r0] 0x20, %r20
	.word 0xe8f56000  ! 5607: STXA_I	stxa	%r20, [%r21 + 0x0000] %asi
	.word 0xe88c8400  ! 5608: LDUBA_R	lduba	[%r18, %r0] 0x20, %r20
	.word 0xe8a52000  ! 5609: STWA_I	stwa	%r20, [%r20 + 0x0000] %asi
	.word 0xe8d52000  ! 5610: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r20
	mov	0x8, %r18
	.word 0xe2d4c400  ! 5612: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r17
	.word 0xe0d4c400  ! 5613: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r16
	.word 0xe8c40400  ! 5614: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r20
	.word 0xe8ad2000  ! 5615: STBA_I	stba	%r20, [%r20 + 0x0000] %asi
	.word 0xe8a52000  ! 5616: STWA_I	stwa	%r20, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 5617: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8966000  ! 5618: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r20
	.word 0xe8cea000  ! 5619: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r20
	.word 0x87802074  ! 5620: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2bf0e40  ! 5621: STDA_R	stda	%r17, [%r28 + %r0] 0x72
	.word 0x87802025  ! 5622: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0bdc4a0  ! 5623: STDA_R	stda	%r16, [%r23 + %r0] 0x25
	.word 0xee9d44a0  ! 5624: LDDA_R	ldda	[%r21, %r0] 0x25, %r23
	.word 0xe6bc8400  ! 5625: STDA_R	stda	%r19, [%r18 + %r0] 0x20
	.word 0xe6af4e60  ! 5626: STBA_R	stba	%r19, [%r29 + %r0] 0x73
	mov	0x50, %r24
	.word 0xe2be89e0  ! 5628: STDA_R	stda	%r17, [%r26 + %r0] 0x4f
	.word 0xe2a5a000  ! 5629: STWA_I	stwa	%r17, [%r22 + 0x0000] %asi
	.word 0xe2b5a000  ! 5630: STHA_I	stha	%r17, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 5631: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r20
	.word 0xe08f4e60  ! 5633: LDUBA_R	lduba	[%r29, %r0] 0x73, %r16
	.word 0xe0de2000  ! 5634: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r16
	.word 0xeaf48400  ! 5635: STXA_R	stxa	%r21, [%r18 + %r0] 0x20
	.word 0xecc5c4a0  ! 5636: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r22
	mov	0x78, %r25
	mov	0x18, %r16
	.word 0x8780204f  ! 5639: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r27
	mov	0x3f0, %r20
	mov	0x10, %r19
	.word 0xe69504a0  ! 5643: LDUHA_R	lduha	[%r20, %r0] 0x25, %r19
	.word 0x8780204f  ! 5644: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r24
	.word 0xe2c78e40  ! 5646: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r17
	.word 0xe2f66000  ! 5647: STXA_I	stxa	%r17, [%r25 + 0x0000] %asi
	.word 0xeca74e80  ! 5648: STWA_R	stwa	%r22, [%r29 + %r0] 0x74
	.word 0xe68504a0  ! 5649: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r19
	.word 0xe6c66000  ! 5650: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r19
	mov	0x60, %r25
	.word 0xecdf4e60  ! 5652: LDXA_R	ldxa	[%r29, %r0] 0x73, %r22
	mov	0x68, %r19
	.word 0xe28504a0  ! 5654: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r17
	mov	0x38, %r19
	mov	0x30, %r18
	mov	0x7f0, %r20
	ta	T_CHANGE_HPRIV	! macro
	.word 0xe2f6a000  ! 5659: STXA_I	stxa	%r17, [%r26 + 0x0000] %asi
	.word 0xe2d6a000  ! 5660: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r17
	.word 0xee9689e0  ! 5661: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r23
	mov	0x78, %r25
	.word 0x87802025  ! 5663: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 5664: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	wr_tick_cmpr_0_46:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8f, %g2
	or	%g4, 0xd1, %g4
	or	%g6, 0xb6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x8, %r16
	.word 0xee842000  ! 5668: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r23
	mov	0x7c8, %r21
	.word 0xee9ce000  ! 5670: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r23
	.word 0x87802072  ! 5671: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeed7e000  ! 5672: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r23
	.word 0x87802073  ! 5673: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f8, %r23
	mov	0x28, %r27
	.word 0xeecf2000  ! 5676: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r23
	.word 0xe4b609e0  ! 5677: STHA_R	stha	%r18, [%r24 + %r0] 0x4f
	.word 0xe2b74e40  ! 5678: STHA_R	stha	%r17, [%r29 + %r0] 0x72
	.word 0x87802020  ! 5679: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2bc6000  ! 5680: STDA_I	stda	%r17, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 5681: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe284a000  ! 5682: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r17
	.word 0x87802020  ! 5683: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2a40400  ! 5684: STWA_R	stwa	%r17, [%r16 + %r0] 0x20
	.word 0x87802025  ! 5685: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r23
	.word 0x87802020  ! 5687: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 5688: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2b4e000  ! 5689: STHA_I	stha	%r17, [%r19 + 0x0000] %asi
	.word 0xee8d44a0  ! 5690: LDUBA_R	lduba	[%r21, %r0] 0x25, %r23
	.word 0x87802020  ! 5691: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeea4a000  ! 5692: STWA_I	stwa	%r23, [%r18 + 0x0000] %asi
	.word 0xe09c8400  ! 5693: LDDA_R	ldda	[%r18, %r0] 0x20, %r16
	mov	0x7e0, %r21
	.word 0xeef584a0  ! 5695: STXA_R	stxa	%r23, [%r22 + %r0] 0x25
	.word 0x87802074  ! 5696: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r17
	.word 0x87802073  ! 5698: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r26
	mov	0x30, %r24
	mov	0x7e8, %r23
	mov	0x20, %r18
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xeed76000  ! 5704: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r23
	mov	0x48, %r26
	.word 0xecf78e80  ! 5706: STXA_R	stxa	%r22, [%r30 + %r0] 0x74
	.word 0xea87ce60  ! 5707: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r21
	mov	0x0, %r19
	.word 0xea9fa000  ! 5709: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r21
	.word 0xea872000  ! 5710: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r21
	.word 0x87802025  ! 5711: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r21
	.word 0xe2948400  ! 5713: LDUHA_R	lduha	[%r18, %r0] 0x20, %r17
	mov	0x3e0, %r22
	wr_tick_cmpr_0_47:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe7, %g2
	or	%g4, 0xda, %g4
	or	%g6, 0xf7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x48, %r25
	.word 0xe29da000  ! 5717: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r17
	.word 0xec9d84a0  ! 5718: LDDA_R	ldda	[%r22, %r0] 0x25, %r22
	mov	0x7c8, %r23
	.word 0xec9d2000  ! 5720: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r22
	.word 0xeca56000  ! 5721: STWA_I	stwa	%r22, [%r21 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xe88c8400  ! 5723: LDUBA_R	lduba	[%r18, %r0] 0x20, %r20
	mov	0x20, %r27
	.word 0xe8b56000  ! 5725: STHA_I	stha	%r20, [%r21 + 0x0000] %asi
	.word 0xe8b56000  ! 5726: STHA_I	stha	%r20, [%r21 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xe29c0400  ! 5728: LDDA_R	ldda	[%r16, %r0] 0x20, %r17
	.word 0xe2f5e000  ! 5729: STXA_I	stxa	%r17, [%r23 + 0x0000] %asi
	mov	0x18, %r17
	mov	0x28, %r19
	mov	0x38, %r26
	.word 0xe0cf8e60  ! 5733: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r16
	.word 0xeacf0e60  ! 5734: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r21
	mov	0x18, %r19
	mov	0x60, %r27
	.word 0xecd4c400  ! 5737: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r22
	.word 0xec85a000  ! 5738: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r22
	.word 0x87802020  ! 5739: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecd46000  ! 5740: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r22
	.word 0xea9f0e60  ! 5741: LDDA_R	ldda	[%r28, %r0] 0x73, %r21
	.word 0xe4bc0400  ! 5742: STDA_R	stda	%r18, [%r16 + %r0] 0x20
	.word 0xe2f78e80  ! 5743: STXA_R	stxa	%r17, [%r30 + %r0] 0x74
	.word 0xe2a4a000  ! 5744: STWA_I	stwa	%r17, [%r18 + 0x0000] %asi
	mov	0x8, %r26
	.word 0x87802020  ! 5746: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2d4e000  ! 5747: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r17
	mov	0x70, %r25
	.word 0x87802073  ! 5749: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 5750: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe28c6000  ! 5751: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r17
	.word 0xe0f74e40  ! 5752: STXA_R	stxa	%r16, [%r29 + %r0] 0x72
	mov	0x60, %r27
	.word 0xe0b46000  ! 5754: STHA_I	stha	%r16, [%r17 + 0x0000] %asi
	.word 0xeaafce80  ! 5755: STBA_R	stba	%r21, [%r31 + %r0] 0x74
	.word 0xeadc2000  ! 5756: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r21
	.word 0xe2bfce40  ! 5757: STDA_R	stda	%r17, [%r31 + %r0] 0x72
	.word 0xecb40400  ! 5758: STHA_R	stha	%r22, [%r16 + %r0] 0x20
	.word 0xe2afce80  ! 5759: STBA_R	stba	%r17, [%r31 + %r0] 0x74
	.word 0x87802074  ! 5760: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r27
	.word 0xeece49e0  ! 5762: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r23
	.word 0xeec7a000  ! 5763: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r23
	.word 0xe68d04a0  ! 5764: LDUBA_R	lduba	[%r20, %r0] 0x25, %r19
	.word 0xe0cc0400  ! 5765: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r16
	.word 0xe0b76000  ! 5766: STHA_I	stha	%r16, [%r29 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xe0c72000  ! 5768: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r16
	.word 0xe6f584a0  ! 5769: STXA_R	stxa	%r19, [%r22 + %r0] 0x25
	.word 0xeabcc400  ! 5770: STDA_R	stda	%r21, [%r19 + %r0] 0x20
	.word 0xea9f2000  ! 5771: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r21
	mov	0x7f0, %r22
	.word 0xe2f5c4a0  ! 5773: STXA_R	stxa	%r17, [%r23 + %r0] 0x25
	mov	0x40, %r25
	.word 0xe2afa000  ! 5775: STBA_I	stba	%r17, [%r30 + 0x0000] %asi
	.word 0xe2af2000  ! 5776: STBA_I	stba	%r17, [%r28 + 0x0000] %asi
	.word 0xe2f72000  ! 5777: STXA_I	stxa	%r17, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 5778: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe297ce60  ! 5779: LDUHA_R	lduha	[%r31, %r0] 0x73, %r17
	.word 0xea94c400  ! 5780: LDUHA_R	lduha	[%r19, %r0] 0x20, %r21
	.word 0xea8ca000  ! 5781: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r21
	.word 0xe2b40400  ! 5782: STHA_R	stha	%r17, [%r16 + %r0] 0x20
	.word 0xe2a42000  ! 5783: STWA_I	stwa	%r17, [%r16 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xe2ac8400  ! 5785: STBA_R	stba	%r17, [%r18 + %r0] 0x20
	.word 0xe0b7ce60  ! 5786: STHA_R	stha	%r16, [%r31 + %r0] 0x73
	.word 0xeeaf0e60  ! 5787: STBA_R	stba	%r23, [%r28 + %r0] 0x73
	.word 0xe6be89e0  ! 5788: STDA_R	stda	%r19, [%r26 + %r0] 0x4f
	.word 0xeecf8e40  ! 5789: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r23
	.word 0x87802074  ! 5790: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8bc8400  ! 5791: STDA_R	stda	%r20, [%r18 + %r0] 0x20
	.word 0xe6b504a0  ! 5792: STHA_R	stha	%r19, [%r20 + %r0] 0x25
	.word 0xe2d78e60  ! 5793: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r17
	mov	0x48, %r24
	.word 0xeeb7ce80  ! 5795: STHA_R	stha	%r23, [%r31 + %r0] 0x74
	.word 0xee97a000  ! 5796: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r23
	.word 0xee9fe000  ! 5797: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r23
	.word 0xe8df0e80  ! 5798: LDXA_R	ldxa	[%r28, %r0] 0x74, %r20
	.word 0xeaacc400  ! 5799: STBA_R	stba	%r21, [%r19 + %r0] 0x20
	mov	0x3c0, %r22
	.word 0xe6c689e0  ! 5801: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r19
	mov	0x20, %r19
	mov	0x60, %r19
	mov	0x3f0, %r20
	.word 0x87802073  ! 5805: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 5806: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeeb649e0  ! 5807: STHA_R	stha	%r23, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 5808: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeec7a000  ! 5809: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r23
	mov	0x7c0, %r23
	.word 0xe8a74e40  ! 5811: STWA_R	stwa	%r20, [%r29 + %r0] 0x72
	.word 0x87802025  ! 5812: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0dcc400  ! 5813: LDXA_R	ldxa	[%r19, %r0] 0x20, %r16
	mov	0x38, %r27
	mov	0x40, %r27
	mov	0x60, %r26
	.word 0xeeac4400  ! 5817: STBA_R	stba	%r23, [%r17 + %r0] 0x20
	mov	0x60, %r19
	.word 0xe8940400  ! 5819: LDUHA_R	lduha	[%r16, %r0] 0x20, %r20
	.word 0xe0f74e40  ! 5820: STXA_R	stxa	%r16, [%r29 + %r0] 0x72
	.word 0xe6ac8400  ! 5821: STBA_R	stba	%r19, [%r18 + %r0] 0x20
	.word 0xe6f56000  ! 5822: STXA_I	stxa	%r19, [%r21 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xe8b78e60  ! 5824: STHA_R	stha	%r20, [%r30 + %r0] 0x73
	.word 0xe88da000  ! 5825: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r20
	.word 0xeebc0400  ! 5826: STDA_R	stda	%r23, [%r16 + %r0] 0x20
	.word 0xee856000  ! 5827: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r23
	.word 0xe2de09e0  ! 5828: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r17
	mov	0x10, %r24
	.word 0x8780204f  ! 5830: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 5831: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f8, %r23
	.word 0xe2b7a000  ! 5833: STHA_I	stha	%r17, [%r30 + 0x0000] %asi
	.word 0xe297a000  ! 5834: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r17
	.word 0x87802025  ! 5835: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 5836: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r24
	mov	0x10, %r24
	.word 0xeea78e60  ! 5839: STWA_R	stwa	%r23, [%r30 + %r0] 0x73
	.word 0xe69689e0  ! 5840: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r19
	.word 0x8780204f  ! 5841: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6de2000  ! 5842: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r19
	mov	0x7d8, %r20
	.word 0xeebf4e40  ! 5844: STDA_R	stda	%r23, [%r29 + %r0] 0x72
	.word 0xe0dc8400  ! 5845: LDXA_R	ldxa	[%r18, %r0] 0x20, %r16
	.word 0xe0862000  ! 5846: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r16
	.word 0xe0b66000  ! 5847: STHA_I	stha	%r16, [%r25 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x0, %r17
	.word 0xe0dea000  ! 5850: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r16
	.word 0xe0f62000  ! 5851: STXA_I	stxa	%r16, [%r24 + 0x0000] %asi
	.word 0xeeacc400  ! 5852: STBA_R	stba	%r23, [%r19 + %r0] 0x20
	.word 0xeea66000  ! 5853: STWA_I	stwa	%r23, [%r25 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xeed6a000  ! 5855: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r23
	.word 0x87802074  ! 5856: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0f78e80  ! 5857: STXA_R	stxa	%r16, [%r30 + %r0] 0x74
	.word 0xe0bfe000  ! 5858: STDA_I	stda	%r16, [%r31 + 0x0000] %asi
	.word 0xe0bfa000  ! 5859: STDA_I	stda	%r16, [%r30 + 0x0000] %asi
	mov	0x10, %r26
	.word 0xe0bc0400  ! 5861: STDA_R	stda	%r16, [%r16 + %r0] 0x20
	.word 0xe2cf4e60  ! 5862: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r17
	.word 0xe29f6000  ! 5863: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r17
	.word 0xe2a76000  ! 5864: STWA_I	stwa	%r17, [%r29 + 0x0000] %asi
	.word 0xe2a7a000  ! 5865: STWA_I	stwa	%r17, [%r30 + 0x0000] %asi
	.word 0xe29fe000  ! 5866: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r17
	.word 0xe29fe000  ! 5867: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r17
	mov	0x3d8, %r21
	.word 0xe287e000  ! 5869: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r17
	.word 0xe8d544a0  ! 5870: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r20
	.word 0xe2bcc400  ! 5871: STDA_R	stda	%r17, [%r19 + %r0] 0x20
	.word 0xe287e000  ! 5872: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r17
	mov	0x20, %r18
	mov	0x7e0, %r23
	.word 0xeecf0e80  ! 5875: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r23
	mov	0x78, %r26
	.word 0xeebf6000  ! 5877: STDA_I	stda	%r23, [%r29 + 0x0000] %asi
	.word 0xeecf2000  ! 5878: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r23
	mov	0x70, %r27
	.word 0xeebfa000  ! 5880: STDA_I	stda	%r23, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 5881: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeef4a000  ! 5882: STXA_I	stxa	%r23, [%r18 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xee846000  ! 5884: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r23
	.word 0xec878e60  ! 5885: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r22
	mov	0x70, %r19
	.word 0xec94e000  ! 5887: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r22
	.word 0xec8c2000  ! 5888: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r22
	.word 0xeccc0400  ! 5889: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r22
	.word 0x87802074  ! 5890: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4b74e60  ! 5891: STHA_R	stha	%r18, [%r29 + %r0] 0x73
	.word 0xe4a7e000  ! 5892: STWA_I	stwa	%r18, [%r31 + 0x0000] %asi
	.word 0xe6ae89e0  ! 5893: STBA_R	stba	%r19, [%r26 + %r0] 0x4f
	.word 0xe6bc0400  ! 5894: STDA_R	stda	%r19, [%r16 + %r0] 0x20
	.word 0x87802072  ! 5895: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6a7a000  ! 5896: STWA_I	stwa	%r19, [%r30 + 0x0000] %asi
	.word 0xe6972000  ! 5897: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r19
	mov	0x7e8, %r21
	.word 0xe0dc8400  ! 5899: LDXA_R	ldxa	[%r18, %r0] 0x20, %r16
	mov	0x7d0, %r22
	.word 0xe097a000  ! 5901: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r16
	.word 0xe08f4e80  ! 5902: LDUBA_R	lduba	[%r29, %r0] 0x74, %r16
	mov	0x3d8, %r21
	.word 0xeab78e60  ! 5904: STHA_R	stha	%r21, [%r30 + %r0] 0x73
	.word 0x87802025  ! 5905: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r27
	mov	0x38, %r18
	.word 0xea8de000  ! 5908: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r21
	.word 0xea852000  ! 5909: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r21
	.word 0x87802072  ! 5910: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 5911: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 5912: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaa46000  ! 5913: STWA_I	stwa	%r21, [%r17 + 0x0000] %asi
	.word 0xe2c44400  ! 5914: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r17
	mov	0x50, %r18
	mov	0x50, %r25
	.word 0xe2d4e000  ! 5917: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r17
	.word 0xe2aca000  ! 5918: STBA_I	stba	%r17, [%r18 + 0x0000] %asi
	.word 0xe2d46000  ! 5919: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r17
	.word 0xe4dc0400  ! 5920: LDXA_R	ldxa	[%r16, %r0] 0x20, %r18
	.word 0xe8d48400  ! 5921: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r20
	.word 0x87802020  ! 5922: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 5923: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r26
	.word 0xe8ad2000  ! 5925: STBA_I	stba	%r20, [%r20 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xeea78e40  ! 5927: STWA_R	stwa	%r23, [%r30 + %r0] 0x72
	.word 0xeeb52000  ! 5928: STHA_I	stha	%r23, [%r20 + 0x0000] %asi
	.word 0xe8a74e40  ! 5929: STWA_R	stwa	%r20, [%r29 + %r0] 0x72
	.word 0xe8852000  ! 5930: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r20
	.word 0xeabf4e80  ! 5931: STDA_R	stda	%r21, [%r29 + %r0] 0x74
	mov	0x60, %r16
	.word 0xe4b48400  ! 5933: STHA_R	stha	%r18, [%r18 + %r0] 0x20
	.word 0x87802072  ! 5934: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r26
	.word 0xe89c8400  ! 5936: LDDA_R	ldda	[%r18, %r0] 0x20, %r20
	.word 0xe88fa000  ! 5937: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r20
	.word 0xe8bfe000  ! 5938: STDA_I	stda	%r20, [%r31 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xe887e000  ! 5940: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r20
	.word 0x87802020  ! 5941: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeec70e40  ! 5942: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r23
	.word 0xee94a000  ! 5943: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r23
	.word 0xe6a74e40  ! 5944: STWA_R	stwa	%r19, [%r29 + %r0] 0x72
	.word 0xe69ca000  ! 5945: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r19
	mov	0x60, %r18
	mov	0x70, %r24
	.word 0xea97ce60  ! 5948: LDUHA_R	lduha	[%r31, %r0] 0x73, %r21
	.word 0xe89ec9e0  ! 5949: LDDA_R	ldda	[%r27, %r0] 0x4f, %r20
	.word 0xe8cc2000  ! 5950: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r20
	.word 0x87802020  ! 5951: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8af8e40  ! 5952: STBA_R	stba	%r20, [%r30 + %r0] 0x72
	.word 0xe8dce000  ! 5953: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r20
	.word 0xe2f74e80  ! 5954: STXA_R	stxa	%r17, [%r29 + %r0] 0x74
	mov	0x3c8, %r23
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x30, %r18
	.word 0xec8dc4a0  ! 5958: LDUBA_R	lduba	[%r23, %r0] 0x25, %r22
	.word 0xec946000  ! 5959: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r22
	.word 0xecaf8e40  ! 5960: STBA_R	stba	%r22, [%r30 + %r0] 0x72
	.word 0xe49cc400  ! 5961: LDDA_R	ldda	[%r19, %r0] 0x20, %r18
	mov	0x48, %r18
	.word 0x87802025  ! 5963: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_0_48:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0xf5, %g4
	or	%g6, 0xc7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe4852000  ! 5965: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r18
	.word 0xe4cd2000  ! 5966: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r18
	.word 0xe69cc400  ! 5967: LDDA_R	ldda	[%r19, %r0] 0x20, %r19
	mov	0x48, %r27
	wr_tick_cmpr_0_49:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb9, %g2
	or	%g4, 0xf8, %g4
	or	%g6, 0xc4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_0_50:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf4, %g2
	or	%g4, 0x89, %g4
	or	%g6, 0x9b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7c0, %r20
	.word 0xe6bde000  ! 5972: STDA_I	stda	%r19, [%r23 + 0x0000] %asi
	.word 0xe6952000  ! 5973: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r19
	.word 0xe6952000  ! 5974: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r19
	.word 0xe6b56000  ! 5975: STHA_I	stha	%r19, [%r21 + 0x0000] %asi
	.word 0xe6b5e000  ! 5976: STHA_I	stha	%r19, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 5977: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r25
	mov	0x10, %r26
	.word 0xe6de2000  ! 5980: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r19
	.word 0xe6c78e60  ! 5981: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r19
	.word 0x87802073  ! 5982: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6af0e60  ! 5983: STBA_R	stba	%r19, [%r28 + %r0] 0x73
	mov	0x3f8, %r22
	.word 0x87802074  ! 5985: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 5986: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6f7a000  ! 5987: STXA_I	stxa	%r19, [%r30 + 0x0000] %asi
	.word 0xe69fe000  ! 5988: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r19
	.word 0xe6cfe000  ! 5989: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r19
	.word 0xe6bfe000  ! 5990: STDA_I	stda	%r19, [%r31 + 0x0000] %asi
	.word 0xe2944400  ! 5991: LDUHA_R	lduha	[%r17, %r0] 0x20, %r17
	mov	0x78, %r25
	.word 0xe2f76000  ! 5993: STXA_I	stxa	%r17, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 5994: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0af4e60  ! 5995: STBA_R	stba	%r16, [%r29 + %r0] 0x73
	mov	0x3e0, %r21
	.word 0xe0f56000  ! 5997: STXA_I	stxa	%r16, [%r21 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xe087ce80  ! 5999: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r16
	.word 0xe0d5a000  ! 6000: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r16
	.word 0xeca74e40  ! 6001: STWA_R	stwa	%r22, [%r29 + %r0] 0x72
	.word 0xe0870e80  ! 6002: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r16
	.word 0xe0dde000  ! 6003: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r16
	.word 0xecac4400  ! 6004: STBA_R	stba	%r22, [%r17 + %r0] 0x20
	.word 0xec856000  ! 6005: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r22
	.word 0xe8b78e80  ! 6006: STHA_R	stha	%r20, [%r30 + %r0] 0x74
	mov	0x30, %r19
	.word 0xe8ada000  ! 6008: STBA_I	stba	%r20, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 6009: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r25
	mov	0x18, %r18
	.word 0xe8bf2000  ! 6012: STDA_I	stda	%r20, [%r28 + 0x0000] %asi
	.word 0xe29f4e60  ! 6013: LDDA_R	ldda	[%r29, %r0] 0x73, %r17
	.word 0x87802020  ! 6014: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2cc6000  ! 6015: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r17
	mov	0x7c0, %r23
	.word 0xeccf8e60  ! 6017: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r22
	.word 0xecbc6000  ! 6018: STDA_I	stda	%r22, [%r17 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xe8ac8400  ! 6020: STBA_R	stba	%r20, [%r18 + %r0] 0x20
	.word 0xe88ca000  ! 6021: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r20
	.word 0xe88c2000  ! 6022: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r20
	mov	0x50, %r18
	.word 0xe8cc8400  ! 6024: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r20
	.word 0xe2bf4e80  ! 6025: STDA_R	stda	%r17, [%r29 + %r0] 0x74
	.word 0xe2846000  ! 6026: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r17
	.word 0xe2ac6000  ! 6027: STBA_I	stba	%r17, [%r17 + 0x0000] %asi
	.word 0xea9cc400  ! 6028: LDDA_R	ldda	[%r19, %r0] 0x20, %r21
	.word 0xeeb70e80  ! 6029: STHA_R	stha	%r23, [%r28 + %r0] 0x74
	.word 0xe697ce80  ! 6030: LDUHA_R	lduha	[%r31, %r0] 0x74, %r19
	.word 0x87802074  ! 6031: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r16
	mov	0x58, %r27
	.word 0xe6afe000  ! 6034: STBA_I	stba	%r19, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 6035: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 6036: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4a48400  ! 6037: STWA_R	stwa	%r18, [%r18 + %r0] 0x20
	.word 0xe4c4a000  ! 6038: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r18
	.word 0x8780204f  ! 6039: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xead4c400  ! 6040: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r21
	.word 0xeab66000  ! 6041: STHA_I	stha	%r21, [%r25 + 0x0000] %asi
	mov	0x70, %r24
	mov	0x40, %r25
	.word 0x87802072  ! 6044: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 6045: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea9f6000  ! 6046: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r21
	.word 0x8780204f  ! 6047: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe88f4e40  ! 6048: LDUBA_R	lduba	[%r29, %r0] 0x72, %r20
	.word 0x87802020  ! 6049: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeea48400  ! 6050: STWA_R	stwa	%r23, [%r18 + %r0] 0x20
	.word 0x87802025  ! 6051: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r27
	.word 0xee8d2000  ! 6053: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r23
	.word 0x87802072  ! 6054: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeebf4e60  ! 6055: STDA_R	stda	%r23, [%r29 + %r0] 0x73
	mov	0x48, %r18
	mov	0x40, %r26
	.word 0xeeafe000  ! 6058: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 6059: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecacc400  ! 6060: STBA_R	stba	%r22, [%r19 + %r0] 0x20
	.word 0xecbea000  ! 6061: STDA_I	stda	%r22, [%r26 + 0x0000] %asi
	.word 0xe6ac0400  ! 6062: STBA_R	stba	%r19, [%r16 + %r0] 0x20
	.word 0x87802072  ! 6063: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeabcc400  ! 6064: STDA_R	stda	%r21, [%r19 + %r0] 0x20
	.word 0xe29f4e80  ! 6065: LDDA_R	ldda	[%r29, %r0] 0x74, %r17
	.word 0xeabd04a0  ! 6066: STDA_R	stda	%r21, [%r20 + %r0] 0x25
	.word 0xeac48400  ! 6067: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r21
	.word 0xeccdc4a0  ! 6068: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r22
	.word 0xe484c400  ! 6069: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r18
	.word 0xe4af4e80  ! 6070: STBA_R	stba	%r18, [%r29 + %r0] 0x74
	.word 0x87802074  ! 6071: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4d7a000  ! 6072: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r18
	.word 0xe8ae49e0  ! 6073: STBA_R	stba	%r20, [%r25 + %r0] 0x4f
	.word 0xeccf0e40  ! 6074: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r22
	.word 0xeca7e000  ! 6075: STWA_I	stwa	%r22, [%r31 + 0x0000] %asi
	.word 0xecd72000  ! 6076: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r22
	.word 0xec87e000  ! 6077: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r22
	.word 0xe6bc8400  ! 6078: STDA_R	stda	%r19, [%r18 + %r0] 0x20
	mov	0x70, %r27
	.word 0xe89544a0  ! 6080: LDUHA_R	lduha	[%r21, %r0] 0x25, %r20
	.word 0x87802074  ! 6081: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r20
	.word 0xe8b7e000  ! 6083: STHA_I	stha	%r20, [%r31 + 0x0000] %asi
	.word 0xeea504a0  ! 6084: STWA_R	stwa	%r23, [%r20 + %r0] 0x25
	.word 0xee8f6000  ! 6085: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r23
	.word 0xe2cf4e60  ! 6086: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r17
	mov	0x30, %r19
	.word 0x87802025  ! 6088: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4bf4e60  ! 6089: STDA_R	stda	%r18, [%r29 + %r0] 0x73
	.word 0xe49de000  ! 6090: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r18
	.word 0xe4a5e000  ! 6091: STWA_I	stwa	%r18, [%r23 + 0x0000] %asi
	.word 0xe4ade000  ! 6092: STBA_I	stba	%r18, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 6093: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeacf0e60  ! 6094: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r21
	.word 0xe2cf8e40  ! 6095: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r17
	.word 0x87802073  ! 6096: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0bd44a0  ! 6097: STDA_R	stda	%r16, [%r21 + %r0] 0x25
	.word 0xe8a40400  ! 6098: STWA_R	stwa	%r20, [%r16 + %r0] 0x20
	mov	0x7e0, %r20
	.word 0xe897e000  ! 6100: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r20
	mov	0x10, %r26
	.word 0xe8d72000  ! 6102: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r20
	.word 0xeeb5c4a0  ! 6103: STHA_R	stha	%r23, [%r23 + %r0] 0x25
	.word 0x87802072  ! 6104: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeea7e000  ! 6105: STWA_I	stwa	%r23, [%r31 + 0x0000] %asi
	.word 0xea8649e0  ! 6106: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r21
	.word 0x87802073  ! 6107: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeacf2000  ! 6108: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r21
	.word 0xea976000  ! 6109: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r21
	.word 0x87802073  ! 6110: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r17
	.word 0xeaf7e000  ! 6112: STXA_I	stxa	%r21, [%r31 + 0x0000] %asi
	.word 0xe8ae89e0  ! 6113: STBA_R	stba	%r20, [%r26 + %r0] 0x4f
	.word 0xe4a78e40  ! 6114: STWA_R	stwa	%r18, [%r30 + %r0] 0x72
	mov	0x58, %r19
	.word 0xe4a72000  ! 6116: STWA_I	stwa	%r18, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802025  ! 6118: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecf7ce40  ! 6119: STXA_R	stxa	%r22, [%r31 + %r0] 0x72
	.word 0xecdde000  ! 6120: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r22
	.word 0xecc56000  ! 6121: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r22
	.word 0xecd5a000  ! 6122: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r22
	.word 0x87802025  ! 6123: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xec8da000  ! 6124: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r22
	mov	0x18, %r18
	.word 0xecbda000  ! 6126: STDA_I	stda	%r22, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 6127: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	.word 0xe0b7ce80  ! 6129: STHA_R	stha	%r16, [%r31 + %r0] 0x74
	.word 0xeef4c400  ! 6130: STXA_R	stxa	%r23, [%r19 + %r0] 0x20
	.word 0xeeb4e000  ! 6131: STHA_I	stha	%r23, [%r19 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x60, %r27
	mov	0x28, %r19
	mov	0x3f8, %r21
	mov	0x60, %r25
	.word 0xe08584a0  ! 6137: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r16
	.word 0xe08c6000  ! 6138: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r16
	mov	0x40, %r24
	.word 0xe0842000  ! 6140: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r16
	mov	0x7d8, %r23
	mov	0x20, %r24
	.word 0xe0bc2000  ! 6143: STDA_I	stda	%r16, [%r16 + 0x0000] %asi
	.word 0xe0ac6000  ! 6144: STBA_I	stba	%r16, [%r17 + 0x0000] %asi
	.word 0xe0842000  ! 6145: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r16
	mov	0x3c0, %r20
	.word 0xe0cf4e40  ! 6147: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r16
	.word 0xe2c504a0  ! 6148: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r17
	.word 0xe2dca000  ! 6149: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r17
	.word 0xe2ace000  ! 6150: STBA_I	stba	%r17, [%r19 + 0x0000] %asi
	mov	0x60, %r17
	mov	0x7f8, %r23
	.word 0xe8d4c400  ! 6153: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r20
	mov	0x3c0, %r21
	.word 0xe88ce000  ! 6155: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r20
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7e8, %r22
	.word 0xe6b74e80  ! 6158: STHA_R	stha	%r19, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 6159: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe68ec9e0  ! 6160: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r19
	.word 0xe89f0e80  ! 6161: LDDA_R	ldda	[%r28, %r0] 0x74, %r20
	.word 0xe6cf8e60  ! 6162: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r19
	.word 0xe68e6000  ! 6163: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r19
	.word 0xe0a74e40  ! 6164: STWA_R	stwa	%r16, [%r29 + %r0] 0x72
	.word 0xe0f6c9e0  ! 6165: STXA_R	stxa	%r16, [%r27 + %r0] 0x4f
	mov	0x7c0, %r22
	.word 0x87802073  ! 6167: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r16
	.word 0xe2de09e0  ! 6169: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r17
	mov	0x40, %r17
	.word 0xe2944400  ! 6171: LDUHA_R	lduha	[%r17, %r0] 0x20, %r17
	.word 0xe28fe000  ! 6172: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r17
	.word 0xe2972000  ! 6173: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r17
	.word 0xe2a7a000  ! 6174: STWA_I	stwa	%r17, [%r30 + 0x0000] %asi
	mov	0x3f8, %r22
	.word 0xec8fce60  ! 6176: LDUBA_R	lduba	[%r31, %r0] 0x73, %r22
	mov	0x7d0, %r23
	.word 0x87802073  ! 6178: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r21
	.word 0xee97ce60  ! 6180: LDUHA_R	lduha	[%r31, %r0] 0x73, %r23
	mov	0x3c8, %r23
	.word 0xe29584a0  ! 6182: LDUHA_R	lduha	[%r22, %r0] 0x25, %r17
	.word 0xe6ccc400  ! 6183: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r19
	.word 0x87802073  ! 6184: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r18
	.word 0x87802072  ! 6186: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6c76000  ! 6187: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r19
	.word 0xe6af2000  ! 6188: STBA_I	stba	%r19, [%r28 + 0x0000] %asi
	.word 0xe4d7ce40  ! 6189: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r18
	.word 0xe4bf6000  ! 6190: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xe4f7e000  ! 6192: STXA_I	stxa	%r18, [%r31 + 0x0000] %asi
	.word 0xee9ec9e0  ! 6193: LDDA_R	ldda	[%r27, %r0] 0x4f, %r23
	.word 0xe6f44400  ! 6194: STXA_R	stxa	%r19, [%r17 + %r0] 0x20
	mov	0x30, %r26
	.word 0xe69f2000  ! 6196: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r19
	.word 0xe6dfe000  ! 6197: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r19
	mov	0x40, %r26
	.word 0xe6bfa000  ! 6199: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xe6c72000  ! 6200: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r19
	.word 0xeef70e40  ! 6201: STXA_R	stxa	%r23, [%r28 + %r0] 0x72
	.word 0xeec72000  ! 6202: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r23
	mov	0x60, %r27
	.word 0xe4ae09e0  ! 6204: STBA_R	stba	%r18, [%r24 + %r0] 0x4f
	mov	0x40, %r24
	.word 0xe4f72000  ! 6206: STXA_I	stxa	%r18, [%r28 + 0x0000] %asi
	.word 0xe4df6000  ! 6207: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r18
	mov	0x3d0, %r23
	.word 0xe4c7e000  ! 6209: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r18
	.word 0xe4af2000  ! 6210: STBA_I	stba	%r18, [%r28 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xe4c7a000  ! 6212: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r18
	.word 0xecdfce60  ! 6213: LDXA_R	ldxa	[%r31, %r0] 0x73, %r22
	.word 0xe6be49e0  ! 6214: STDA_R	stda	%r19, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 6215: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r25
	.word 0xe6dc2000  ! 6217: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r19
	mov	0x3e8, %r20
	.word 0x87802074  ! 6219: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6afa000  ! 6220: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	.word 0xe6cfe000  ! 6221: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r19
	.word 0xe6d44400  ! 6222: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r19
	.word 0xeef649e0  ! 6223: STXA_R	stxa	%r23, [%r25 + %r0] 0x4f
	mov	0x28, %r24
	.word 0xeeb7e000  ! 6225: STHA_I	stha	%r23, [%r31 + 0x0000] %asi
	.word 0xee97a000  ! 6226: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r23
	mov	0x3d8, %r23
	.word 0xeec76000  ! 6228: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r23
	.word 0xe2a4c400  ! 6229: STWA_R	stwa	%r17, [%r19 + %r0] 0x20
	.word 0xe2afe000  ! 6230: STBA_I	stba	%r17, [%r31 + 0x0000] %asi
	.word 0xeca74e60  ! 6231: STWA_R	stwa	%r22, [%r29 + %r0] 0x73
	.word 0xe4d40400  ! 6232: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r18
	.word 0x87802025  ! 6233: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 6234: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4bfa000  ! 6235: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	.word 0xeed78e40  ! 6236: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r23
	mov	0x60, %r25
	.word 0x87802072  ! 6238: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeec72000  ! 6239: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r23
	mov	0x18, %r17
	.word 0xeab44400  ! 6241: STHA_R	stha	%r21, [%r17 + %r0] 0x20
	.word 0x87802025  ! 6242: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r23
	.word 0x87802073  ! 6244: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeab7a000  ! 6245: STHA_I	stha	%r21, [%r30 + 0x0000] %asi
	.word 0xe6bdc4a0  ! 6246: STDA_R	stda	%r19, [%r23 + %r0] 0x25
	mov	0x68, %r16
	mov	0x70, %r18
	.word 0x87802020  ! 6249: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6ac8400  ! 6250: STBA_R	stba	%r19, [%r18 + %r0] 0x20
	.word 0xe8970e80  ! 6251: LDUHA_R	lduha	[%r28, %r0] 0x74, %r20
	.word 0x87802025  ! 6252: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 6253: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0978e40  ! 6254: LDUHA_R	lduha	[%r30, %r0] 0x72, %r16
	mov	0x7d8, %r22
	.word 0xe0f72000  ! 6256: STXA_I	stxa	%r16, [%r28 + 0x0000] %asi
	.word 0xee844400  ! 6257: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r23
	.word 0x87802073  ! 6258: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xee9f6000  ! 6259: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r23
	.word 0xeeafe000  ! 6260: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 6261: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r18
	.word 0xeed7a000  ! 6263: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r23
	mov	0x7e8, %r23
	mov	0x70, %r24
	.word 0xeea76000  ! 6266: STWA_I	stwa	%r23, [%r29 + 0x0000] %asi
	mov	0x48, %r24
	mov	0x3f0, %r20
	mov	0x7e0, %r20
	.word 0xeac48400  ! 6270: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r21
	mov	0x7c8, %r20
	mov	0x28, %r24
	.word 0xe4974e80  ! 6273: LDUHA_R	lduha	[%r29, %r0] 0x74, %r18
	.word 0xe48fa000  ! 6274: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r18
	mov	0x60, %r19
	.word 0xe8f70e40  ! 6276: STXA_R	stxa	%r20, [%r28 + %r0] 0x72
	mov	0x78, %r27
	.word 0xeeac4400  ! 6278: STBA_R	stba	%r23, [%r17 + %r0] 0x20
	.word 0xeeaf6000  ! 6279: STBA_I	stba	%r23, [%r29 + 0x0000] %asi
	.word 0xeeaf6000  ! 6280: STBA_I	stba	%r23, [%r29 + 0x0000] %asi
	.word 0xeef72000  ! 6281: STXA_I	stxa	%r23, [%r28 + 0x0000] %asi
	mov	0x7d8, %r23
	mov	0x3d8, %r20
	mov	0x7c8, %r23
	.word 0xe4f78e40  ! 6285: STXA_R	stxa	%r18, [%r30 + %r0] 0x72
	.word 0x87802072  ! 6286: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4a76000  ! 6287: STWA_I	stwa	%r18, [%r29 + 0x0000] %asi
	.word 0xe48f2000  ! 6288: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r18
	.word 0xe4972000  ! 6289: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r18
	mov	0x48, %r26
	.word 0xe4df4e40  ! 6291: LDXA_R	ldxa	[%r29, %r0] 0x72, %r18
	.word 0xe4bf6000  ! 6292: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 6293: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6a78e60  ! 6294: STWA_R	stwa	%r19, [%r30 + %r0] 0x73
	.word 0xecdec9e0  ! 6295: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r22
	.word 0xec9ce000  ! 6296: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r22
	mov	0x20, %r16
	.word 0xe8cc0400  ! 6298: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r20
	.word 0xe6f44400  ! 6299: STXA_R	stxa	%r19, [%r17 + %r0] 0x20
	.word 0xeed544a0  ! 6300: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r23
	.word 0x87802025  ! 6301: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xee85a000  ! 6302: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r23
	.word 0xe0d70e60  ! 6303: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r16
	.word 0xe0d56000  ! 6304: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r16
	mov	0x0, %r16
	.word 0xe09de000  ! 6306: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r16
	.word 0xe08d2000  ! 6307: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r16
	mov	0x68, %r18
	.word 0xeed6c9e0  ! 6309: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r23
	.word 0xeed52000  ! 6310: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r23
	.word 0xe48fce80  ! 6311: LDUBA_R	lduba	[%r31, %r0] 0x74, %r18
	.word 0xe4ade000  ! 6312: STBA_I	stba	%r18, [%r23 + 0x0000] %asi
	.word 0xe4a5e000  ! 6313: STWA_I	stwa	%r18, [%r23 + 0x0000] %asi
	.word 0xe4ada000  ! 6314: STBA_I	stba	%r18, [%r22 + 0x0000] %asi
	.word 0xe8acc400  ! 6315: STBA_R	stba	%r20, [%r19 + %r0] 0x20
	.word 0xe8f5a000  ! 6316: STXA_I	stxa	%r20, [%r22 + 0x0000] %asi
	mov	0x3c8, %r20
	mov	0x18, %r26
	.word 0xeabc4400  ! 6319: STDA_R	stda	%r21, [%r17 + %r0] 0x20
	.word 0xeab5e000  ! 6320: STHA_I	stha	%r21, [%r23 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0x87802020  ! 6322: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 6323: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8d609e0  ! 6324: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r20
	.word 0x87802020  ! 6325: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8acc400  ! 6326: STBA_R	stba	%r20, [%r19 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0xe0d4c400  ! 6328: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r16
	mov	0x48, %r25
	mov	0x38, %r24
	.word 0x87802072  ! 6331: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r16
	.word 0xe8af8e60  ! 6333: STBA_R	stba	%r20, [%r30 + %r0] 0x73
	mov	0x3f8, %r22
	.word 0xe6bc4400  ! 6335: STDA_R	stda	%r19, [%r17 + %r0] 0x20
	.word 0xee9504a0  ! 6336: LDUHA_R	lduha	[%r20, %r0] 0x25, %r23
	.word 0xeedf6000  ! 6337: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r23
	.word 0x87802020  ! 6338: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe09f4e40  ! 6339: LDDA_R	ldda	[%r29, %r0] 0x72, %r16
	.word 0xe0b46000  ! 6340: STHA_I	stha	%r16, [%r17 + 0x0000] %asi
	mov	0x30, %r25
	mov	0x18, %r26
	mov	0x7c0, %r22
	.word 0xe0c4a000  ! 6344: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r16
	.word 0xe4978e80  ! 6345: LDUHA_R	lduha	[%r30, %r0] 0x74, %r18
	mov	0x10, %r27
	.word 0x87802020  ! 6347: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r21
	mov	0x30, %r19
	.word 0x87802020  ! 6350: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2b78e80  ! 6351: STHA_R	stha	%r17, [%r30 + %r0] 0x74
	.word 0xe294e000  ! 6352: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r17
	.word 0x87802073  ! 6353: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2af6000  ! 6354: STBA_I	stba	%r17, [%r29 + 0x0000] %asi
	.word 0xe6b4c400  ! 6355: STHA_R	stha	%r19, [%r19 + %r0] 0x20
	.word 0xe697e000  ! 6356: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r19
	.word 0xe2a4c400  ! 6357: STWA_R	stwa	%r17, [%r19 + %r0] 0x20
	mov	0x3d0, %r22
	.word 0x87802074  ! 6359: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r18
	.word 0xeacf4e60  ! 6361: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r21
	mov	0x48, %r24
	.word 0xead7a000  ! 6363: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r21
	mov	0x28, %r26
	mov	0x7f8, %r23
	.word 0xeab7a000  ! 6366: STHA_I	stha	%r21, [%r30 + 0x0000] %asi
	wr_tick_cmpr_0_51:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa6, %g2
	or	%g4, 0x97, %g4
	or	%g6, 0xa5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 6368: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeac7a000  ! 6369: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r21
	.word 0x87802020  ! 6370: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r22
	.word 0xe0cd04a0  ! 6372: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r16
	.word 0xe0c4a000  ! 6373: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r16
	.word 0xe0f4a000  ! 6374: STXA_I	stxa	%r16, [%r18 + 0x0000] %asi
	.word 0xe0c609e0  ! 6375: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r16
	.word 0xeef689e0  ! 6376: STXA_R	stxa	%r23, [%r26 + %r0] 0x4f
	mov	0x60, %r27
	.word 0xeef4e000  ! 6378: STXA_I	stxa	%r23, [%r19 + 0x0000] %asi
	.word 0xee846000  ! 6379: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r23
	.word 0xe0ac8400  ! 6380: STBA_R	stba	%r16, [%r18 + %r0] 0x20
	mov	0x0, %r24
	.word 0xe2be49e0  ! 6382: STDA_R	stda	%r17, [%r25 + %r0] 0x4f
	.word 0xe0bf4e60  ! 6383: STDA_R	stda	%r16, [%r29 + %r0] 0x73
	.word 0xe0dca000  ! 6384: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r16
	.word 0xe0cce000  ! 6385: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r16
	.word 0xe8c48400  ! 6386: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r20
	.word 0xe4a609e0  ! 6387: STWA_R	stwa	%r18, [%r24 + %r0] 0x4f
	.word 0xeebec9e0  ! 6388: STDA_R	stda	%r23, [%r27 + %r0] 0x4f
	.word 0xeeb46000  ! 6389: STHA_I	stha	%r23, [%r17 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x28, %r19
	.word 0xeeb42000  ! 6392: STHA_I	stha	%r23, [%r16 + 0x0000] %asi
	.word 0xeccc0400  ! 6393: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r22
	.word 0xe6874e40  ! 6394: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r19
	mov	0x68, %r19
	.word 0x8780204f  ! 6396: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 6397: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeabf8e40  ! 6398: STDA_R	stda	%r21, [%r30 + %r0] 0x72
	.word 0xea9f2000  ! 6399: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r21
	mov	0x30, %r25
	.word 0xeaf7a000  ! 6401: STXA_I	stxa	%r21, [%r30 + 0x0000] %asi
	.word 0xeecd84a0  ! 6402: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r23
	.word 0xeec7e000  ! 6403: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r23
	.word 0xe8ce49e0  ! 6404: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r20
	.word 0xeaddc4a0  ! 6405: LDXA_R	ldxa	[%r23, %r0] 0x25, %r21
	.word 0xe6f78e60  ! 6406: STXA_R	stxa	%r19, [%r30 + %r0] 0x73
	mov	0x7f8, %r22
	mov	0x70, %r25
	.word 0xe4c7ce60  ! 6409: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r18
	.word 0xe497e000  ! 6410: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r18
	.word 0xe497e000  ! 6411: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r18
	.word 0xe48fa000  ! 6412: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r18
	.word 0xe4afe000  ! 6413: STBA_I	stba	%r18, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 6414: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe295c4a0  ! 6415: LDUHA_R	lduha	[%r23, %r0] 0x25, %r17
	.word 0xe2ccc400  ! 6416: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r17
	mov	0x3d0, %r23
	.word 0xec974e40  ! 6418: LDUHA_R	lduha	[%r29, %r0] 0x72, %r22
	mov	0x60, %r25
	mov	0x3c8, %r22
	.word 0x87802025  ! 6421: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8bfce80  ! 6422: STDA_R	stda	%r20, [%r31 + %r0] 0x74
	.word 0xe8b52000  ! 6423: STHA_I	stha	%r20, [%r20 + 0x0000] %asi
	.word 0xe8d5e000  ! 6424: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r20
	.word 0xe88c0400  ! 6425: LDUBA_R	lduba	[%r16, %r0] 0x20, %r20
	.word 0xe89de000  ! 6426: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r20
	mov	0x38, %r17
	.word 0xe8f5e000  ! 6428: STXA_I	stxa	%r20, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 6429: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r22
	.word 0xe8846000  ! 6431: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r20
	wr_tick_cmpr_0_52:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa9, %g2
	or	%g4, 0xde, %g4
	or	%g6, 0xe4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 6433: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 6434: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeede09e0  ! 6435: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r23
	.word 0xec8c8400  ! 6436: LDUBA_R	lduba	[%r18, %r0] 0x20, %r22
	mov	0x7e8, %r22
	mov	0x50, %r16
	.word 0xecc66000  ! 6439: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r22
	mov	0x7e0, %r23
	.word 0x87802073  ! 6441: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xecbf2000  ! 6442: STDA_I	stda	%r22, [%r28 + 0x0000] %asi
	.word 0xe0c584a0  ! 6443: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r16
	mov	0x48, %r17
	mov	0x7e8, %r20
	.word 0xe0af2000  ! 6446: STBA_I	stba	%r16, [%r28 + 0x0000] %asi
	.word 0xe0b7a000  ! 6447: STHA_I	stha	%r16, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 6448: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0c6a000  ! 6449: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r16
	.word 0xe684c400  ! 6450: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r19
	.word 0xe6a6e000  ! 6451: STWA_I	stwa	%r19, [%r27 + 0x0000] %asi
	.word 0x87802072  ! 6452: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2ad04a0  ! 6453: STBA_R	stba	%r17, [%r20 + %r0] 0x25
	.word 0xe0ad44a0  ! 6454: STBA_R	stba	%r16, [%r21 + %r0] 0x25
	.word 0x87802020  ! 6455: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r21
	mov	0x3f0, %r21
	.word 0xe0cce000  ! 6458: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r16
	.word 0xe0dc2000  ! 6459: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r16
	.word 0xe09ca000  ! 6460: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r16
	.word 0xe6cfce40  ! 6461: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r19
	.word 0xe6a7ce80  ! 6462: STWA_R	stwa	%r19, [%r31 + %r0] 0x74
	.word 0xe6ace000  ! 6463: STBA_I	stba	%r19, [%r19 + 0x0000] %asi
	.word 0xe2b74e60  ! 6464: STHA_R	stha	%r17, [%r29 + %r0] 0x73
	mov	0x38, %r18
	.word 0x87802025  ! 6466: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe285e000  ! 6467: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r17
	wr_tick_cmpr_0_53:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xba, %g2
	or	%g4, 0x88, %g4
	or	%g6, 0xfa, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3f0, %r23
	mov	0x48, %r24
	.word 0x87802020  ! 6471: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	.word 0x8780204f  ! 6473: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r26
	mov	0x50, %r19
	.word 0xead78e80  ! 6476: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r21
	.word 0xeabe6000  ! 6477: STDA_I	stda	%r21, [%r25 + 0x0000] %asi
	.word 0xeacea000  ! 6478: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r21
	.word 0x87802020  ! 6479: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xead46000  ! 6480: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r21
	mov	0x3d8, %r22
	.word 0xea846000  ! 6482: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r21
	.word 0xe2bc0400  ! 6483: STDA_R	stda	%r17, [%r16 + %r0] 0x20
	.word 0xecb44400  ! 6484: STHA_R	stha	%r22, [%r17 + %r0] 0x20
	.word 0xecf42000  ! 6485: STXA_I	stxa	%r22, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 6486: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2aec9e0  ! 6487: STBA_R	stba	%r17, [%r27 + %r0] 0x4f
	mov	0x3d0, %r20
	.word 0x87802020  ! 6489: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2ac2000  ! 6490: STBA_I	stba	%r17, [%r16 + 0x0000] %asi
	.word 0xe6b4c400  ! 6491: STHA_R	stha	%r19, [%r19 + %r0] 0x20
	.word 0xe6d4e000  ! 6492: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r19
	.word 0xe6c46000  ! 6493: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r19
	.word 0xe6ce89e0  ! 6494: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r19
	.word 0xeecf4e80  ! 6495: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r23
	.word 0xeef4e000  ! 6496: STXA_I	stxa	%r23, [%r19 + 0x0000] %asi
	.word 0xe8b7ce80  ! 6497: STHA_R	stha	%r20, [%r31 + %r0] 0x74
	.word 0xe8cce000  ! 6498: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r20
	mov	0x70, %r27
	mov	0x48, %r24
	mov	0x3f8, %r22
	.word 0x87802025  ! 6502: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0f5c4a0  ! 6503: STXA_R	stxa	%r16, [%r23 + %r0] 0x25
	.word 0xe0d78e60  ! 6504: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r16
	.word 0x87802020  ! 6505: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0842000  ! 6506: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r16
	.word 0xe0b42000  ! 6507: STHA_I	stha	%r16, [%r16 + 0x0000] %asi
	mov	0x50, %r18
	.word 0x87802073  ! 6509: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r21
	.word 0xe0c7a000  ! 6511: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r16
	.word 0x87802020  ! 6512: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0ace000  ! 6513: STBA_I	stba	%r16, [%r19 + 0x0000] %asi
	.word 0xe0942000  ! 6514: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r16
	.word 0xe0cc6000  ! 6515: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r16
	.word 0xe8a4c400  ! 6516: STWA_R	stwa	%r20, [%r19 + %r0] 0x20
	mov	0x60, %r18
	ta	T_CHANGE_PRIV	! macro
	ta	T_CHANGE_PRIV	! macro
	mov	0x28, %r16
	.word 0xe6840400  ! 6521: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r19
	.word 0x87802025  ! 6522: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeef70e60  ! 6523: STXA_R	stxa	%r23, [%r28 + %r0] 0x73
	.word 0xe28c8400  ! 6524: LDUBA_R	lduba	[%r18, %r0] 0x20, %r17
	mov	0x3e0, %r23
	.word 0xe2dde000  ! 6526: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r17
	.word 0xe29da000  ! 6527: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r17
	.word 0xe2bd2000  ! 6528: STDA_I	stda	%r17, [%r20 + 0x0000] %asi
	.word 0xe8bf0e40  ! 6529: STDA_R	stda	%r20, [%r28 + %r0] 0x72
	.word 0xe8b52000  ! 6530: STHA_I	stha	%r20, [%r20 + 0x0000] %asi
	.word 0xe8bde000  ! 6531: STDA_I	stda	%r20, [%r23 + 0x0000] %asi
	.word 0xe29f8e40  ! 6532: LDDA_R	ldda	[%r30, %r0] 0x72, %r17
	mov	0x3d8, %r21
	.word 0x87802074  ! 6534: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 6535: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r22
	mov	0x30, %r27
	.word 0xe2ac2000  ! 6538: STBA_I	stba	%r17, [%r16 + 0x0000] %asi
	.word 0xe2bc2000  ! 6539: STDA_I	stda	%r17, [%r16 + 0x0000] %asi
	.word 0xe2f46000  ! 6540: STXA_I	stxa	%r17, [%r17 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xea874e80  ! 6542: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r21
	.word 0x87802025  ! 6543: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeacde000  ! 6544: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r21
	.word 0xe2a44400  ! 6545: STWA_R	stwa	%r17, [%r17 + %r0] 0x20
	.word 0xe28da000  ! 6546: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r17
	mov	0x50, %r27
	.word 0xe2c40400  ! 6548: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r17
	.word 0xe2cd2000  ! 6549: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r17
	mov	0x18, %r24
	.word 0xe68dc4a0  ! 6551: LDUBA_R	lduba	[%r23, %r0] 0x25, %r19
	.word 0xe6852000  ! 6552: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r19
	mov	0x8, %r16
	.word 0x87802020  ! 6554: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe68ce000  ! 6555: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r19
	.word 0xe6b4a000  ! 6556: STHA_I	stha	%r19, [%r18 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xe69ca000  ! 6558: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r19
	.word 0xe68c6000  ! 6559: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r19
	.word 0xe6f4a000  ! 6560: STXA_I	stxa	%r19, [%r18 + 0x0000] %asi
	.word 0xe6dca000  ! 6561: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r19
	.word 0x87802072  ! 6562: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r19
	.word 0xe6bf6000  ! 6564: STDA_I	stda	%r19, [%r29 + 0x0000] %asi
	.word 0xeec4c400  ! 6565: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r23
	mov	0x50, %r17
	.word 0xee976000  ! 6567: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r23
	mov	0x3d8, %r20
	.word 0x87802074  ! 6569: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 6570: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r21
	.word 0xeacfce60  ! 6572: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r21
	.word 0xec840400  ! 6573: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r22
	.word 0xecd4e000  ! 6574: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r22
	.word 0xeccc6000  ! 6575: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r22
	.word 0xeab504a0  ! 6576: STHA_R	stha	%r21, [%r20 + %r0] 0x25
	mov	0x10, %r17
	.word 0x87802025  ! 6578: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xea852000  ! 6579: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r21
	.word 0x87802020  ! 6580: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec96c9e0  ! 6581: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r22
	.word 0xec8ce000  ! 6582: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r22
	.word 0x8780204f  ! 6583: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6ae09e0  ! 6584: STBA_R	stba	%r19, [%r24 + %r0] 0x4f
	.word 0xe0978e60  ! 6585: LDUHA_R	lduha	[%r30, %r0] 0x73, %r16
	.word 0x87802025  ! 6586: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0c5e000  ! 6587: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r16
	.word 0x87802025  ! 6588: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 6589: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 6590: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r20
	mov	0x40, %r18
	.word 0xeaa40400  ! 6593: STWA_R	stwa	%r21, [%r16 + %r0] 0x20
	.word 0xee9f8e40  ! 6594: LDDA_R	ldda	[%r30, %r0] 0x72, %r23
	.word 0xe6dd04a0  ! 6595: LDXA_R	ldxa	[%r20, %r0] 0x25, %r19
	.word 0xe8c4c400  ! 6596: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r20
	.word 0xeca7ce40  ! 6597: STWA_R	stwa	%r22, [%r31 + %r0] 0x72
	.word 0xee86c9e0  ! 6598: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r23
	.word 0x87802073  ! 6599: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r24
	mov	0x28, %r18
	.word 0xee97a000  ! 6602: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r23
	.word 0xee97a000  ! 6603: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r23
	mov	0x18, %r16
	.word 0xeec7e000  ! 6605: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r23
	.word 0x87802074  ! 6606: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xea8f0e60  ! 6607: LDUBA_R	lduba	[%r28, %r0] 0x73, %r21
	.word 0x87802073  ! 6608: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r26
	.word 0xeac76000  ! 6610: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r21
	mov	0x7d8, %r22
	mov	0x20, %r27
	.word 0xea9c8400  ! 6613: LDDA_R	ldda	[%r18, %r0] 0x20, %r21
	.word 0x87802073  ! 6614: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea878e80  ! 6615: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r21
	.word 0x87802025  ! 6616: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeabd2000  ! 6617: STDA_I	stda	%r21, [%r20 + 0x0000] %asi
	.word 0xea8de000  ! 6618: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r21
	.word 0xe89f4e40  ! 6619: LDDA_R	ldda	[%r29, %r0] 0x72, %r20
	.word 0xe8ada000  ! 6620: STBA_I	stba	%r20, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 6621: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8f46000  ! 6622: STXA_I	stxa	%r20, [%r17 + 0x0000] %asi
	.word 0xe88ca000  ! 6623: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r20
	mov	0x3d0, %r23
	.word 0xe0bf4e40  ! 6625: STDA_R	stda	%r16, [%r29 + %r0] 0x72
	.word 0xe0a46000  ! 6626: STWA_I	stwa	%r16, [%r17 + 0x0000] %asi
	mov	0x20, %r17
	.word 0x87802020  ! 6628: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r19
	mov	0x7d0, %r20
	.word 0xe0bce000  ! 6631: STDA_I	stda	%r16, [%r19 + 0x0000] %asi
	.word 0xecd78e80  ! 6632: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r22
	mov	0x3c8, %r21
	.word 0xeeb544a0  ! 6634: STHA_R	stha	%r23, [%r21 + %r0] 0x25
	.word 0xeecf0e60  ! 6635: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r23
	.word 0xe6c44400  ! 6636: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r19
	.word 0xe4974e80  ! 6637: LDUHA_R	lduha	[%r29, %r0] 0x74, %r18
	.word 0xe0d74e60  ! 6638: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r16
	.word 0xeacd44a0  ! 6639: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r21
	.word 0xea9c2000  ! 6640: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r21
	mov	0x8, %r18
	mov	0x78, %r17
	.word 0xeabca000  ! 6643: STDA_I	stda	%r21, [%r18 + 0x0000] %asi
	.word 0xea970e40  ! 6644: LDUHA_R	lduha	[%r28, %r0] 0x72, %r21
	mov	0x18, %r27
	mov	0x0, %r16
	mov	0x3f8, %r23
	.word 0xeab4a000  ! 6648: STHA_I	stha	%r21, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 6649: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4bc8400  ! 6650: STDA_R	stda	%r18, [%r18 + %r0] 0x20
	.word 0xeabcc400  ! 6651: STDA_R	stda	%r21, [%r19 + %r0] 0x20
	.word 0x87802073  ! 6652: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea8f2000  ! 6653: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r21
	mov	0x28, %r19
	.word 0xe4b44400  ! 6655: STHA_R	stha	%r18, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 6656: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4bea000  ! 6657: STDA_I	stda	%r18, [%r26 + 0x0000] %asi
	mov	0x68, %r25
	mov	0x68, %r17
	.word 0xe4966000  ! 6660: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r18
	.word 0xe8cd84a0  ! 6661: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r20
	.word 0x87802073  ! 6662: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4df0e80  ! 6663: LDXA_R	ldxa	[%r28, %r0] 0x74, %r18
	.word 0xe09f4e40  ! 6664: LDDA_R	ldda	[%r29, %r0] 0x72, %r16
	.word 0x87802020  ! 6665: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe09ce000  ! 6666: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r16
	.word 0x87802073  ! 6667: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r20
	.word 0xe097e000  ! 6669: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r16
	.word 0xe0d7a000  ! 6670: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r16
	mov	0x40, %r17
	mov	0x7d0, %r20
	.word 0xe0dfa000  ! 6673: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r16
	.word 0xe0872000  ! 6674: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r16
	.word 0xe0cf6000  ! 6675: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r16
	mov	0x20, %r24
	mov	0x3c0, %r23
	.word 0xe0bf2000  ! 6678: STDA_I	stda	%r16, [%r28 + 0x0000] %asi
	.word 0xe0dfe000  ! 6679: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r16
	mov	0x3f8, %r21
	.word 0xe0a78e60  ! 6681: STWA_R	stwa	%r16, [%r30 + %r0] 0x73
	.word 0xe0cf2000  ! 6682: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r16
	.word 0xe09f2000  ! 6683: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r16
	mov	0x3d8, %r22
	.word 0xee8f8e40  ! 6685: LDUBA_R	lduba	[%r30, %r0] 0x72, %r23
	.word 0xe4ae49e0  ! 6686: STBA_R	stba	%r18, [%r25 + %r0] 0x4f
	.word 0xe48fa000  ! 6687: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r18
	mov	0x3c0, %r22
	.word 0xe4bfa000  ! 6689: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xe4bfe000  ! 6691: STDA_I	stda	%r18, [%r31 + 0x0000] %asi
	.word 0xe4b7a000  ! 6692: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	mov	0x0, %r27
	.word 0x87802020  ! 6694: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4a4a000  ! 6695: STWA_I	stwa	%r18, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 6696: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4df2000  ! 6697: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r18
	.word 0xe6a544a0  ! 6698: STWA_R	stwa	%r19, [%r21 + %r0] 0x25
	mov	0x68, %r25
	mov	0x10, %r16
	mov	0x3d0, %r22
	.word 0xe6bd04a0  ! 6702: STDA_R	stda	%r19, [%r20 + %r0] 0x25
	.word 0xe6f544a0  ! 6703: STXA_R	stxa	%r19, [%r21 + %r0] 0x25
	.word 0xe6a72000  ! 6704: STWA_I	stwa	%r19, [%r28 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xeecd04a0  ! 6706: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r23
	.word 0xee972000  ! 6707: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r23
	.word 0xe6a6c9e0  ! 6708: STWA_R	stwa	%r19, [%r27 + %r0] 0x4f
	.word 0xe0d74e80  ! 6709: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r16
	.word 0xe087e000  ! 6710: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r16
	.word 0xeef544a0  ! 6711: STXA_R	stxa	%r23, [%r21 + %r0] 0x25
	.word 0xe4974e40  ! 6712: LDUHA_R	lduha	[%r29, %r0] 0x72, %r18
	.word 0xe4876000  ! 6713: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r18
	mov	0x10, %r25
	.word 0xe4b7a000  ! 6715: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	.word 0xe69ec9e0  ! 6716: LDDA_R	ldda	[%r27, %r0] 0x4f, %r19
	.word 0xe697e000  ! 6717: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r19
	.word 0xe6f7e000  ! 6718: STXA_I	stxa	%r19, [%r31 + 0x0000] %asi
	.word 0xe6bfa000  ! 6719: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xeea74e60  ! 6720: STWA_R	stwa	%r23, [%r29 + %r0] 0x73
	.word 0xeec76000  ! 6721: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r23
	.word 0x87802025  ! 6722: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeedd04a0  ! 6723: LDXA_R	ldxa	[%r20, %r0] 0x25, %r23
	mov	0x10, %r27
	.word 0x87802025  ! 6725: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r16
	.word 0xeeada000  ! 6727: STBA_I	stba	%r23, [%r22 + 0x0000] %asi
	.word 0xeea52000  ! 6728: STWA_I	stwa	%r23, [%r20 + 0x0000] %asi
	.word 0xe2a609e0  ! 6729: STWA_R	stwa	%r17, [%r24 + %r0] 0x4f
	mov	0x50, %r27
	.word 0xe29584a0  ! 6731: LDUHA_R	lduha	[%r22, %r0] 0x25, %r17
	mov	0x30, %r18
	.word 0xe88d44a0  ! 6733: LDUBA_R	lduba	[%r21, %r0] 0x25, %r20
	.word 0xe8f5a000  ! 6734: STXA_I	stxa	%r20, [%r22 + 0x0000] %asi
	.word 0xe8bd2000  ! 6735: STDA_I	stda	%r20, [%r20 + 0x0000] %asi
	.word 0xe88c8400  ! 6736: LDUBA_R	lduba	[%r18, %r0] 0x20, %r20
	.word 0xe694c400  ! 6737: LDUHA_R	lduha	[%r19, %r0] 0x20, %r19
	.word 0xeeaf4e40  ! 6738: STBA_R	stba	%r23, [%r29 + %r0] 0x72
	mov	0x18, %r25
	mov	0x3f8, %r21
	mov	0x58, %r19
	.word 0xeea40400  ! 6742: STWA_R	stwa	%r23, [%r16 + %r0] 0x20
	.word 0xeedd6000  ! 6743: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r23
	.word 0xe4b649e0  ! 6744: STHA_R	stha	%r18, [%r25 + %r0] 0x4f
	ta	T_CHANGE_PRIV	! macro
	.word 0xe6a6c9e0  ! 6746: STWA_R	stwa	%r19, [%r27 + %r0] 0x4f
	.word 0xe2f7ce40  ! 6747: STXA_R	stxa	%r17, [%r31 + %r0] 0x72
	.word 0xe28de000  ! 6748: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r17
	mov	0x18, %r16
	.word 0xe09f4e40  ! 6750: LDDA_R	ldda	[%r29, %r0] 0x72, %r16
	.word 0x87802073  ! 6751: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0976000  ! 6752: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r16
	.word 0x87802072  ! 6753: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r27
	mov	0x60, %r25
	.word 0xecc70e80  ! 6756: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r22
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802073  ! 6758: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0f5c4a0  ! 6759: STXA_R	stxa	%r16, [%r23 + %r0] 0x25
	wr_tick_cmpr_0_54:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xab, %g2
	or	%g4, 0x80, %g4
	or	%g6, 0xc6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x38, %r24
	.word 0xe8a78e80  ! 6762: STWA_R	stwa	%r20, [%r30 + %r0] 0x74
	.word 0xe8bfe000  ! 6763: STDA_I	stda	%r20, [%r31 + 0x0000] %asi
	.word 0xe8af2000  ! 6764: STBA_I	stba	%r20, [%r28 + 0x0000] %asi
	.word 0xeca689e0  ! 6765: STWA_R	stwa	%r22, [%r26 + %r0] 0x4f
	.word 0xe2d78e80  ! 6766: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r17
	.word 0xe8bf0e80  ! 6767: STDA_R	stda	%r20, [%r28 + %r0] 0x74
	.word 0xe8a72000  ! 6768: STWA_I	stwa	%r20, [%r28 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xe6ac4400  ! 6770: STBA_R	stba	%r19, [%r17 + %r0] 0x20
	.word 0x87802020  ! 6771: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r23
	.word 0xe6842000  ! 6773: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r19
	.word 0xe4ae49e0  ! 6774: STBA_R	stba	%r18, [%r25 + %r0] 0x4f
	.word 0xe2afce80  ! 6775: STBA_R	stba	%r17, [%r31 + %r0] 0x74
	.word 0xe2f46000  ! 6776: STXA_I	stxa	%r17, [%r17 + 0x0000] %asi
	.word 0xe2d42000  ! 6777: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r17
	mov	0x60, %r19
	.word 0x87802072  ! 6779: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8ce49e0  ! 6780: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r20
	.word 0xe89fce80  ! 6781: LDDA_R	ldda	[%r31, %r0] 0x74, %r20
	.word 0xecdc8400  ! 6782: LDXA_R	ldxa	[%r18, %r0] 0x20, %r22
	.word 0xecbfe000  ! 6783: STDA_I	stda	%r22, [%r31 + 0x0000] %asi
	.word 0xecd76000  ! 6784: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r22
	mov	0x48, %r18
	.word 0xec8fe000  ! 6786: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r22
	.word 0xeab70e60  ! 6787: STHA_R	stha	%r21, [%r28 + %r0] 0x73
	.word 0xeaa7e000  ! 6788: STWA_I	stwa	%r21, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 6789: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r26
	mov	0x58, %r17
	.word 0x87802020  ! 6792: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r24
	.word 0xeef48400  ! 6794: STXA_R	stxa	%r23, [%r18 + %r0] 0x20
	.word 0xe0f4c400  ! 6795: STXA_R	stxa	%r16, [%r19 + %r0] 0x20
	.word 0x87802025  ! 6796: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f0, %r23
	.word 0xe2a40400  ! 6798: STWA_R	stwa	%r17, [%r16 + %r0] 0x20
	.word 0x87802020  ! 6799: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 6800: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r23
	.word 0xe6a649e0  ! 6802: STWA_R	stwa	%r19, [%r25 + %r0] 0x4f
	.word 0xe28f0e60  ! 6803: LDUBA_R	lduba	[%r28, %r0] 0x73, %r17
	.word 0xe2bfe000  ! 6804: STDA_I	stda	%r17, [%r31 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xe2b72000  ! 6806: STHA_I	stha	%r17, [%r28 + 0x0000] %asi
	.word 0xeccc0400  ! 6807: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r22
	mov	0x48, %r16
	.word 0xecdfa000  ! 6809: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r22
	.word 0xecc76000  ! 6810: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0xecc7e000  ! 6811: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r22
	.word 0xec87a000  ! 6812: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r22
	.word 0xec8f2000  ! 6813: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r22
	.word 0xecf76000  ! 6814: STXA_I	stxa	%r22, [%r29 + 0x0000] %asi
	.word 0xecf7a000  ! 6815: STXA_I	stxa	%r22, [%r30 + 0x0000] %asi
	.word 0xec972000  ! 6816: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r22
	mov	0x70, %r25
	mov	0x28, %r16
	.word 0xeca7e000  ! 6819: STWA_I	stwa	%r22, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 6820: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xecaf4e80  ! 6821: STBA_R	stba	%r22, [%r29 + %r0] 0x74
	.word 0xe0bc8400  ! 6822: STDA_R	stda	%r16, [%r18 + %r0] 0x20
	.word 0xe0c7e000  ! 6823: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r16
	.word 0xe0df6000  ! 6824: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r16
	.word 0x87802020  ! 6825: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0f4e000  ! 6826: STXA_I	stxa	%r16, [%r19 + 0x0000] %asi
	mov	0x7c0, %r22
	mov	0x0, %r19
	mov	0x3c8, %r20
	mov	0x7c0, %r21
	.word 0x87802072  ! 6831: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2c40400  ! 6832: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r17
	.word 0xe2dfa000  ! 6833: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r17
	.word 0x87802072  ! 6834: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2b72000  ! 6835: STHA_I	stha	%r17, [%r28 + 0x0000] %asi
	.word 0xe2f7a000  ! 6836: STXA_I	stxa	%r17, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 6837: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a44400  ! 6838: STWA_R	stwa	%r16, [%r17 + %r0] 0x20
	.word 0xeadf0e40  ! 6839: LDXA_R	ldxa	[%r28, %r0] 0x72, %r21
	.word 0xe4cc0400  ! 6840: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r18
	.word 0xe4846000  ! 6841: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r18
	mov	0x28, %r17
	.word 0xe2f504a0  ! 6843: STXA_R	stxa	%r17, [%r20 + %r0] 0x25
	mov	0x7c0, %r22
	.word 0x8780204f  ! 6845: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 6846: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe084c400  ! 6847: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r16
	.word 0xe09c6000  ! 6848: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r16
	mov	0x48, %r19
	.word 0xe0b42000  ! 6850: STHA_I	stha	%r16, [%r16 + 0x0000] %asi
	.word 0xe2b44400  ! 6851: STHA_R	stha	%r17, [%r17 + %r0] 0x20
	.word 0xe294a000  ! 6852: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r17
	.word 0xecb544a0  ! 6853: STHA_R	stha	%r22, [%r21 + %r0] 0x25
	.word 0x87802074  ! 6854: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 6855: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecb62000  ! 6856: STHA_I	stha	%r22, [%r24 + 0x0000] %asi
	.word 0xe0a74e40  ! 6857: STWA_R	stwa	%r16, [%r29 + %r0] 0x72
	.word 0xee840400  ! 6858: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r23
	mov	0x8, %r25
	.word 0xe8948400  ! 6860: LDUHA_R	lduha	[%r18, %r0] 0x20, %r20
	.word 0xe886e000  ! 6861: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r20
	.word 0xe8a70e80  ! 6862: STWA_R	stwa	%r20, [%r28 + %r0] 0x74
	.word 0xe8a6a000  ! 6863: STWA_I	stwa	%r20, [%r26 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xe0dd44a0  ! 6865: LDXA_R	ldxa	[%r21, %r0] 0x25, %r16
	.word 0xe6acc400  ! 6866: STBA_R	stba	%r19, [%r19 + %r0] 0x20
	mov	0x78, %r17
	.word 0xeca70e60  ! 6868: STWA_R	stwa	%r22, [%r28 + %r0] 0x73
	mov	0x28, %r17
	.word 0xe6c74e80  ! 6870: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r19
	.word 0xe69e2000  ! 6871: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r19
	.word 0xeef44400  ! 6872: STXA_R	stxa	%r23, [%r17 + %r0] 0x20
	mov	0x58, %r16
	.word 0xeeaee000  ! 6874: STBA_I	stba	%r23, [%r27 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xeec6a000  ! 6876: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r23
	.word 0xe29d84a0  ! 6877: LDDA_R	ldda	[%r22, %r0] 0x25, %r17
	mov	0x3f8, %r23
	mov	0x38, %r25
	.word 0x87802072  ! 6880: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2afa000  ! 6881: STBA_I	stba	%r17, [%r30 + 0x0000] %asi
	.word 0xe2cf6000  ! 6882: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r17
	.word 0xe4bf4e60  ! 6883: STDA_R	stda	%r18, [%r29 + %r0] 0x73
	mov	0x18, %r17
	.word 0xe48fe000  ! 6885: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r18
	.word 0xe69e49e0  ! 6886: LDDA_R	ldda	[%r25, %r0] 0x4f, %r19
	.word 0xe68fa000  ! 6887: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r19
	.word 0xe6b76000  ! 6888: STHA_I	stha	%r19, [%r29 + 0x0000] %asi
	.word 0xe49f4e40  ! 6889: LDDA_R	ldda	[%r29, %r0] 0x72, %r18
	.word 0xe4d7e000  ! 6890: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r18
	mov	0x68, %r17
	.word 0xe48649e0  ! 6892: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r18
	mov	0x70, %r26
	.word 0xe4df2000  ! 6894: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r18
	.word 0xe4d7a000  ! 6895: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r18
	.word 0x87802020  ! 6896: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 6897: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r25
	.word 0xe4ac2000  ! 6899: STBA_I	stba	%r18, [%r16 + 0x0000] %asi
	mov	0x48, %r25
	mov	0x78, %r19
	.word 0xe4bc6000  ! 6902: STDA_I	stda	%r18, [%r17 + 0x0000] %asi
	mov	0x30, %r26
	mov	0x38, %r24
	.word 0xe8b689e0  ! 6905: STHA_R	stha	%r20, [%r26 + %r0] 0x4f
	.word 0xe8df0e80  ! 6906: LDXA_R	ldxa	[%r28, %r0] 0x74, %r20
	mov	0x78, %r18
	mov	0x3c8, %r22
	.word 0xe8b70e60  ! 6909: STHA_R	stha	%r20, [%r28 + %r0] 0x73
	.word 0xe88ca000  ! 6910: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r20
	.word 0xe0b44400  ! 6911: STHA_R	stha	%r16, [%r17 + %r0] 0x20
	.word 0x87802073  ! 6912: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe09f6000  ! 6913: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r16
	.word 0xe8c74e60  ! 6914: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r20
	.word 0x87802073  ! 6915: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8c7a000  ! 6916: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r20
	.word 0xe8afa000  ! 6917: STBA_I	stba	%r20, [%r30 + 0x0000] %asi
	.word 0xe89f2000  ! 6918: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r20
	mov	0x78, %r25
	.word 0xe8cf2000  ! 6920: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r20
	.word 0xe8cfe000  ! 6921: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r20
	mov	0x3f0, %r23
	.word 0xe8f7a000  ! 6923: STXA_I	stxa	%r20, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 6924: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8dc6000  ! 6925: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r20
	.word 0x87802020  ! 6926: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8dc2000  ! 6927: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r20
	.word 0xe2bf8e40  ! 6928: STDA_R	stda	%r17, [%r30 + %r0] 0x72
	.word 0xee97ce80  ! 6929: LDUHA_R	lduha	[%r31, %r0] 0x74, %r23
	.word 0xe0f48400  ! 6930: STXA_R	stxa	%r16, [%r18 + %r0] 0x20
	mov	0x70, %r25
	.word 0xe0bca000  ! 6932: STDA_I	stda	%r16, [%r18 + 0x0000] %asi
	.word 0xe0ac2000  ! 6933: STBA_I	stba	%r16, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 6934: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe09ca000  ! 6935: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r16
	.word 0xe0f4e000  ! 6936: STXA_I	stxa	%r16, [%r19 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xe0b42000  ! 6938: STHA_I	stha	%r16, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 6939: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 6940: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0f42000  ! 6941: STXA_I	stxa	%r16, [%r16 + 0x0000] %asi
	.word 0xe2b584a0  ! 6942: STHA_R	stha	%r17, [%r22 + %r0] 0x25
	.word 0xee8fce40  ! 6943: LDUBA_R	lduba	[%r31, %r0] 0x72, %r23
	mov	0x40, %r16
	.word 0xeedca000  ! 6945: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r23
	.word 0xe2b4c400  ! 6946: STHA_R	stha	%r17, [%r19 + %r0] 0x20
	.word 0xe2d4e000  ! 6947: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r17
	mov	0x38, %r27
	mov	0x70, %r19
	.word 0xe2bf8e60  ! 6950: STDA_R	stda	%r17, [%r30 + %r0] 0x73
	.word 0xe2846000  ! 6951: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r17
	.word 0xe2b46000  ! 6952: STHA_I	stha	%r17, [%r17 + 0x0000] %asi
	.word 0xeadf8e40  ! 6953: LDXA_R	ldxa	[%r30, %r0] 0x72, %r21
	.word 0xe4b70e80  ! 6954: STHA_R	stha	%r18, [%r28 + %r0] 0x74
	.word 0xe4bce000  ! 6955: STDA_I	stda	%r18, [%r19 + 0x0000] %asi
	.word 0xe8c649e0  ! 6956: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r20
	.word 0xeedfce40  ! 6957: LDXA_R	ldxa	[%r31, %r0] 0x72, %r23
	.word 0xeeb4a000  ! 6958: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	.word 0xe2870e80  ! 6959: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r17
	.word 0xeaa78e60  ! 6960: STWA_R	stwa	%r21, [%r30 + %r0] 0x73
	.word 0xecdc4400  ! 6961: LDXA_R	ldxa	[%r17, %r0] 0x20, %r22
	.word 0x8780204f  ! 6962: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecbea000  ! 6963: STDA_I	stda	%r22, [%r26 + 0x0000] %asi
	.word 0xe6a70e80  ! 6964: STWA_R	stwa	%r19, [%r28 + %r0] 0x74
	.word 0xe6b66000  ! 6965: STHA_I	stha	%r19, [%r25 + 0x0000] %asi
	.word 0xe6862000  ! 6966: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r19
	mov	0x7c0, %r22
	.word 0xe4ae49e0  ! 6968: STBA_R	stba	%r18, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 6969: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4d7e000  ! 6970: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r18
	.word 0xe0d4c400  ! 6971: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r16
	.word 0x87802072  ! 6972: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4f70e80  ! 6973: STXA_R	stxa	%r18, [%r28 + %r0] 0x74
	.word 0xe48fa000  ! 6974: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r18
	.word 0xe6dcc400  ! 6975: LDXA_R	ldxa	[%r19, %r0] 0x20, %r19
	.word 0xe6ae09e0  ! 6976: STBA_R	stba	%r19, [%r24 + %r0] 0x4f
	mov	0x0, %r26
	.word 0xe6876000  ! 6978: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r19
	mov	0x78, %r24
	mov	0x40, %r18
	mov	0x7c0, %r21
	.word 0x87802025  ! 6982: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r24
	.word 0xe69d6000  ! 6984: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r19
	.word 0xe6a56000  ! 6985: STWA_I	stwa	%r19, [%r21 + 0x0000] %asi
	.word 0xe8af4e80  ! 6986: STBA_R	stba	%r20, [%r29 + %r0] 0x74
	.word 0x87802025  ! 6987: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_0_55:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8b, %g2
	or	%g4, 0xec, %g4
	or	%g6, 0xb1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe8f52000  ! 6989: STXA_I	stxa	%r20, [%r20 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xeaa7ce40  ! 6991: STWA_R	stwa	%r21, [%r31 + %r0] 0x72
	.word 0x87802073  ! 6992: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 6993: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8ad84a0  ! 6994: STBA_R	stba	%r20, [%r22 + %r0] 0x25
	mov	0x7e0, %r22
	.word 0xe6b48400  ! 6996: STHA_R	stha	%r19, [%r18 + %r0] 0x20
	.word 0xec948400  ! 6997: LDUHA_R	lduha	[%r18, %r0] 0x20, %r22
	.word 0x87802074  ! 6998: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe88609e0  ! 6999: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r20
	.word 0x87802020  ! 7000: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe28f8e40  ! 7001: LDUBA_R	lduba	[%r30, %r0] 0x72, %r17
	.word 0xe88dc4a0  ! 7002: LDUBA_R	lduba	[%r23, %r0] 0x25, %r20
	.word 0xeed44400  ! 7003: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r23
	.word 0xeef46000  ! 7004: STXA_I	stxa	%r23, [%r17 + 0x0000] %asi
	.word 0xeebc6000  ! 7005: STDA_I	stda	%r23, [%r17 + 0x0000] %asi
	.word 0xecae49e0  ! 7006: STBA_R	stba	%r22, [%r25 + %r0] 0x4f
	.word 0xe6c40400  ! 7007: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r19
	mov	0x70, %r19
	.word 0xe6ac2000  ! 7009: STBA_I	stba	%r19, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 7010: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaf78e60  ! 7011: STXA_R	stxa	%r21, [%r30 + %r0] 0x73
	mov	0x0, %r24
	.word 0xead4a000  ! 7013: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r21
	.word 0x87802020  ! 7014: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	.word 0xeaaca000  ! 7016: STBA_I	stba	%r21, [%r18 + 0x0000] %asi
	.word 0xe6a4c400  ! 7017: STWA_R	stwa	%r19, [%r19 + %r0] 0x20
	mov	0x7d8, %r22
	.word 0xe6f4a000  ! 7019: STXA_I	stxa	%r19, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 7020: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6af2000  ! 7021: STBA_I	stba	%r19, [%r28 + 0x0000] %asi
	.word 0xe6dfa000  ! 7022: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r19
	.word 0x87802073  ! 7023: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r26
	.word 0xea8d04a0  ! 7025: LDUBA_R	lduba	[%r20, %r0] 0x25, %r21
	mov	0x48, %r27
	.word 0xea972000  ! 7027: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r21
	.word 0xeaf72000  ! 7028: STXA_I	stxa	%r21, [%r28 + 0x0000] %asi
	.word 0xe89dc4a0  ! 7029: LDDA_R	ldda	[%r23, %r0] 0x25, %r20
	.word 0xe8af2000  ! 7030: STBA_I	stba	%r20, [%r28 + 0x0000] %asi
	.word 0xe8af2000  ! 7031: STBA_I	stba	%r20, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 7032: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r25
	.word 0xe8c72000  ! 7034: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r20
	.word 0xe8afa000  ! 7035: STBA_I	stba	%r20, [%r30 + 0x0000] %asi
	.word 0xe8cf2000  ! 7036: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r20
	.word 0xe8b7a000  ! 7037: STHA_I	stha	%r20, [%r30 + 0x0000] %asi
	.word 0xeaa7ce40  ! 7038: STWA_R	stwa	%r21, [%r31 + %r0] 0x72
	.word 0xea972000  ! 7039: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r21
	.word 0xe4ad84a0  ! 7040: STBA_R	stba	%r18, [%r22 + %r0] 0x25
	.word 0x87802020  ! 7041: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r21
	mov	0x3f0, %r22
	.word 0xe4f42000  ! 7044: STXA_I	stxa	%r18, [%r16 + 0x0000] %asi
	.word 0xe8cfce40  ! 7045: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r20
	.word 0xe8a4e000  ! 7046: STWA_I	stwa	%r20, [%r19 + 0x0000] %asi
	mov	0x68, %r27
	.word 0x87802020  ! 7048: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8d42000  ! 7049: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r20
	.word 0xe29cc400  ! 7050: LDDA_R	ldda	[%r19, %r0] 0x20, %r17
	.word 0xe2a42000  ! 7051: STWA_I	stwa	%r17, [%r16 + 0x0000] %asi
	.word 0xe29c2000  ! 7052: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r17
	.word 0x87802020  ! 7053: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2bce000  ! 7054: STDA_I	stda	%r17, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 7055: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2cd2000  ! 7056: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r17
	.word 0xe48d84a0  ! 7057: LDUBA_R	lduba	[%r22, %r0] 0x25, %r18
	.word 0xe4a56000  ! 7058: STWA_I	stwa	%r18, [%r21 + 0x0000] %asi
	.word 0xe48d6000  ! 7059: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r18
	.word 0xeabfce80  ! 7060: STDA_R	stda	%r21, [%r31 + %r0] 0x74
	.word 0x87802020  ! 7061: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 7062: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaaca000  ! 7063: STBA_I	stba	%r21, [%r18 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xea9c2000  ! 7065: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r21
	.word 0xe2cc4400  ! 7066: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r17
	.word 0xe8bc0400  ! 7067: STDA_R	stda	%r20, [%r16 + %r0] 0x20
	.word 0x87802025  ! 7068: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r19
	.word 0xeebc0400  ! 7070: STDA_R	stda	%r23, [%r16 + %r0] 0x20
	.word 0xe895c4a0  ! 7071: LDUHA_R	lduha	[%r23, %r0] 0x25, %r20
	.word 0x87802025  ! 7072: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_0_56:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfd, %g2
	or	%g4, 0x87, %g4
	or	%g6, 0x87, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xec8cc400  ! 7074: LDUBA_R	lduba	[%r19, %r0] 0x20, %r22
	.word 0xecada000  ! 7075: STBA_I	stba	%r22, [%r22 + 0x0000] %asi
	.word 0xecbde000  ! 7076: STDA_I	stda	%r22, [%r23 + 0x0000] %asi
	.word 0xe285c4a0  ! 7077: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r17
	mov	0x58, %r18
	.word 0xe28d2000  ! 7079: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r17
	mov	0x7d8, %r21
	.word 0xe28d6000  ! 7081: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r17
	.word 0xe2a5e000  ! 7082: STWA_I	stwa	%r17, [%r23 + 0x0000] %asi
	.word 0xe2f52000  ! 7083: STXA_I	stxa	%r17, [%r20 + 0x0000] %asi
	.word 0xe2b56000  ! 7084: STHA_I	stha	%r17, [%r21 + 0x0000] %asi
	.word 0xe28f0e40  ! 7085: LDUBA_R	lduba	[%r28, %r0] 0x72, %r17
	.word 0xe2f5e000  ! 7086: STXA_I	stxa	%r17, [%r23 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xe6dfce80  ! 7088: LDXA_R	ldxa	[%r31, %r0] 0x74, %r19
	.word 0xe695e000  ! 7089: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r19
	.word 0x87802074  ! 7090: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r17
	.word 0x87802072  ! 7092: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_0_57:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb3, %g2
	or	%g4, 0xac, %g4
	or	%g6, 0xde, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe69f2000  ! 7094: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r19
	mov	0x7f0, %r21
	.word 0xe6a7e000  ! 7096: STWA_I	stwa	%r19, [%r31 + 0x0000] %asi
	.word 0xe68fe000  ! 7097: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r19
	.word 0xecb544a0  ! 7098: STHA_R	stha	%r22, [%r21 + %r0] 0x25
	.word 0xe496c9e0  ! 7099: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r18
	mov	0x7d8, %r20
	mov	0x18, %r24
	.word 0xec948400  ! 7102: LDUHA_R	lduha	[%r18, %r0] 0x20, %r22
	.word 0xeca7e000  ! 7103: STWA_I	stwa	%r22, [%r31 + 0x0000] %asi
	.word 0xeca76000  ! 7104: STWA_I	stwa	%r22, [%r29 + 0x0000] %asi
	.word 0xec97e000  ! 7105: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r22
	.word 0xec8fa000  ! 7106: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r22
	.word 0xee8e89e0  ! 7107: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r23
	.word 0x87802072  ! 7108: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xea8f0e40  ! 7109: LDUBA_R	lduba	[%r28, %r0] 0x72, %r21
	mov	0x20, %r16
	.word 0xe0dc4400  ! 7111: LDXA_R	ldxa	[%r17, %r0] 0x20, %r16
	.word 0xe09fa000  ! 7112: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r16
	mov	0x0, %r17
	.word 0x87802020  ! 7114: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r21
	.word 0xe0bce000  ! 7116: STDA_I	stda	%r16, [%r19 + 0x0000] %asi
	.word 0xe0a78e80  ! 7117: STWA_R	stwa	%r16, [%r30 + %r0] 0x74
	mov	0x3f8, %r20
	.word 0xe0a4e000  ! 7119: STWA_I	stwa	%r16, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 7120: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 7121: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0f4a000  ! 7122: STXA_I	stxa	%r16, [%r18 + 0x0000] %asi
	.word 0xecf649e0  ! 7123: STXA_R	stxa	%r22, [%r25 + %r0] 0x4f
	mov	0x8, %r18
	mov	0x40, %r24
	.word 0xecc4a000  ! 7126: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r22
	.word 0xecac4400  ! 7127: STBA_R	stba	%r22, [%r17 + %r0] 0x20
	.word 0xecc46000  ! 7128: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r22
	.word 0xecb4a000  ! 7129: STHA_I	stha	%r22, [%r18 + 0x0000] %asi
	.word 0xeeacc400  ! 7130: STBA_R	stba	%r23, [%r19 + %r0] 0x20
	wr_tick_cmpr_0_58:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xed, %g2
	or	%g4, 0xae, %g4
	or	%g6, 0x8d, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x8, %r26
	.word 0xeed4e000  ! 7133: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r23
	mov	0x7e8, %r21
	mov	0x48, %r19
	.word 0xeecc6000  ! 7136: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r23
	.word 0x8780204f  ! 7137: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8a78e40  ! 7138: STWA_R	stwa	%r20, [%r30 + %r0] 0x72
	.word 0xe8d66000  ! 7139: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r20
	.word 0xe8f62000  ! 7140: STXA_I	stxa	%r20, [%r24 + 0x0000] %asi
	.word 0xe4af8e40  ! 7141: STBA_R	stba	%r18, [%r30 + %r0] 0x72
	.word 0xe8dd04a0  ! 7142: LDXA_R	ldxa	[%r20, %r0] 0x25, %r20
	.word 0x87802072  ! 7143: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r21
	mov	0x3f0, %r22
	mov	0x48, %r26
	.word 0xe8dfa000  ! 7147: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r20
	mov	0x3d0, %r22
	mov	0x58, %r16
	.word 0xe8af2000  ! 7150: STBA_I	stba	%r20, [%r28 + 0x0000] %asi
	.word 0xe4844400  ! 7151: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r18
	.word 0xe4c72000  ! 7152: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r18
	.word 0x87802072  ! 7153: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe49f2000  ! 7154: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r18
	.word 0xe49fa000  ! 7155: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r18
	.word 0xe0c7ce80  ! 7156: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r16
	.word 0x8780204f  ! 7157: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeabd04a0  ! 7158: STDA_R	stda	%r21, [%r20 + %r0] 0x25
	.word 0x87802073  ! 7159: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 7160: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeaaee000  ! 7161: STBA_I	stba	%r21, [%r27 + 0x0000] %asi
	.word 0xeaa6a000  ! 7162: STWA_I	stwa	%r21, [%r26 + 0x0000] %asi
	.word 0xe0f7ce40  ! 7163: STXA_R	stxa	%r16, [%r31 + %r0] 0x72
	mov	0x3c0, %r21
	.word 0x87802074  ! 7165: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeeafce80  ! 7166: STBA_R	stba	%r23, [%r31 + %r0] 0x74
	.word 0xee97e000  ! 7167: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r23
	.word 0x8780204f  ! 7168: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r17
	.word 0xee866000  ! 7170: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r23
	.word 0xe2f7ce80  ! 7171: STXA_R	stxa	%r17, [%r31 + %r0] 0x74
	mov	0x40, %r26
	mov	0x28, %r19
	.word 0xe2c62000  ! 7174: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r17
	.word 0xe2be2000  ! 7175: STDA_I	stda	%r17, [%r24 + 0x0000] %asi
	.word 0xeacfce60  ! 7176: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r21
	.word 0xee8f4e60  ! 7177: LDUBA_R	lduba	[%r29, %r0] 0x73, %r23
	.word 0xee8e6000  ! 7178: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r23
	.word 0xecf4c400  ! 7179: STXA_R	stxa	%r22, [%r19 + %r0] 0x20
	.word 0xe2de49e0  ! 7180: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r17
	.word 0xe2ce89e0  ! 7181: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r17
	.word 0xe2b62000  ! 7182: STHA_I	stha	%r17, [%r24 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xeaaf4e80  ! 7184: STBA_R	stba	%r21, [%r29 + %r0] 0x74
	mov	0x58, %r27
	.word 0xeac66000  ! 7186: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r21
	.word 0xea8ee000  ! 7187: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r21
	.word 0xe494c400  ! 7188: LDUHA_R	lduha	[%r19, %r0] 0x20, %r18
	.word 0xe68fce40  ! 7189: LDUBA_R	lduba	[%r31, %r0] 0x72, %r19
	.word 0xe6aee000  ! 7190: STBA_I	stba	%r19, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 7191: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2f504a0  ! 7192: STXA_R	stxa	%r17, [%r20 + %r0] 0x25
	.word 0x87802072  ! 7193: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r26
	.word 0x87802074  ! 7195: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e8, %r23
	.word 0xe4b48400  ! 7197: STHA_R	stha	%r18, [%r18 + %r0] 0x20
	.word 0xe48c4400  ! 7198: LDUBA_R	lduba	[%r17, %r0] 0x20, %r18
	mov	0x7e8, %r20
	.word 0x87802072  ! 7200: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4afe000  ! 7201: STBA_I	stba	%r18, [%r31 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xe0b40400  ! 7203: STHA_R	stha	%r16, [%r16 + %r0] 0x20
	.word 0xe087e000  ! 7204: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r16
	.word 0xea9e89e0  ! 7205: LDDA_R	ldda	[%r26, %r0] 0x4f, %r21
	mov	0x3d0, %r21
	.word 0xecc6c9e0  ! 7207: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r22
	mov	0x3c8, %r23
	.word 0xecaf6000  ! 7209: STBA_I	stba	%r22, [%r29 + 0x0000] %asi
	.word 0xe49f0e60  ! 7210: LDDA_R	ldda	[%r28, %r0] 0x73, %r18
	.word 0xe8bcc400  ! 7211: STDA_R	stda	%r20, [%r19 + %r0] 0x20
	.word 0xe8b76000  ! 7212: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	.word 0xe8b72000  ! 7213: STHA_I	stha	%r20, [%r28 + 0x0000] %asi
	mov	0x7c0, %r23
	mov	0x7c0, %r23
	.word 0xe08649e0  ! 7216: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r16
	.word 0x8780204f  ! 7217: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6dcc400  ! 7218: LDXA_R	ldxa	[%r19, %r0] 0x20, %r19
	.word 0xe6d66000  ! 7219: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r19
	.word 0xe6f62000  ! 7220: STXA_I	stxa	%r19, [%r24 + 0x0000] %asi
	.word 0xe0f78e40  ! 7221: STXA_R	stxa	%r16, [%r30 + %r0] 0x72
	mov	0x58, %r24
	.word 0xe2a649e0  ! 7223: STWA_R	stwa	%r17, [%r25 + %r0] 0x4f
	.word 0xe6cc8400  ! 7224: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r19
	.word 0x87802025  ! 7225: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r20
	.word 0xeaf40400  ! 7227: STXA_R	stxa	%r21, [%r16 + %r0] 0x20
	.word 0x87802020  ! 7228: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe28584a0  ! 7229: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r17
	.word 0x8780204f  ! 7230: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2be6000  ! 7231: STDA_I	stda	%r17, [%r25 + 0x0000] %asi
	mov	0x70, %r17
	.word 0x87802072  ! 7233: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeadf0e80  ! 7234: LDXA_R	ldxa	[%r28, %r0] 0x74, %r21
	.word 0x87802020  ! 7235: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6f74e60  ! 7236: STXA_R	stxa	%r19, [%r29 + %r0] 0x73
	.word 0xe6aca000  ! 7237: STBA_I	stba	%r19, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 7238: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r16
	.word 0xe6ae89e0  ! 7240: STBA_R	stba	%r19, [%r26 + %r0] 0x4f
	.word 0xe0d7ce80  ! 7241: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r16
	mov	0x7d0, %r21
	.word 0xe0a42000  ! 7243: STWA_I	stwa	%r16, [%r16 + 0x0000] %asi
	.word 0xea870e40  ! 7244: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r21
	.word 0x87802072  ! 7245: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6f7ce80  ! 7246: STXA_R	stxa	%r19, [%r31 + %r0] 0x74
	.word 0xe4af0e80  ! 7247: STBA_R	stba	%r18, [%r28 + %r0] 0x74
	mov	0x60, %r25
	mov	0x60, %r17
	mov	0x38, %r24
	.word 0xe2bf0e60  ! 7251: STDA_R	stda	%r17, [%r28 + %r0] 0x73
	.word 0x87802025  ! 7252: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2bde000  ! 7253: STDA_I	stda	%r17, [%r23 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xeeb74e80  ! 7255: STHA_R	stha	%r23, [%r29 + %r0] 0x74
	.word 0xe2c70e40  ! 7256: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r17
	.word 0xe6df0e80  ! 7257: LDXA_R	ldxa	[%r28, %r0] 0x74, %r19
	.word 0xe695e000  ! 7258: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r19
	.word 0xe2cf8e80  ! 7259: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r17
	.word 0xe28da000  ! 7260: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r17
	mov	0x0, %r24
	.word 0xea8e49e0  ! 7262: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r21
	.word 0x87802072  ! 7263: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4a7ce80  ! 7264: STWA_R	stwa	%r18, [%r31 + %r0] 0x74
	.word 0xeef7ce80  ! 7265: STXA_R	stxa	%r23, [%r31 + %r0] 0x74
	.word 0xeeb7a000  ! 7266: STHA_I	stha	%r23, [%r30 + 0x0000] %asi
	mov	0x50, %r27
	mov	0x18, %r16
	.word 0x87802020  ! 7269: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6afce80  ! 7270: STBA_R	stba	%r19, [%r31 + %r0] 0x74
	.word 0xe6bf8e40  ! 7271: STDA_R	stda	%r19, [%r30 + %r0] 0x72
	.word 0x87802020  ! 7272: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r23
	.word 0xe6f4a000  ! 7274: STXA_I	stxa	%r19, [%r18 + 0x0000] %asi
	.word 0xecdfce80  ! 7275: LDXA_R	ldxa	[%r31, %r0] 0x74, %r22
	.word 0xeca4a000  ! 7276: STWA_I	stwa	%r22, [%r18 + 0x0000] %asi
	.word 0xec8ce000  ! 7277: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r22
	.word 0xeab504a0  ! 7278: STHA_R	stha	%r21, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 7279: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4df0e40  ! 7280: LDXA_R	ldxa	[%r28, %r0] 0x72, %r18
	.word 0xeaaf4e80  ! 7281: STBA_R	stba	%r21, [%r29 + %r0] 0x74
	mov	0x58, %r19
	mov	0x70, %r17
	.word 0x87802025  ! 7284: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeadd6000  ! 7285: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r21
	.word 0xe29504a0  ! 7286: LDUHA_R	lduha	[%r20, %r0] 0x25, %r17
	.word 0xec848400  ! 7287: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r22
	mov	0x0, %r25
	.word 0xe6a7ce80  ! 7289: STWA_R	stwa	%r19, [%r31 + %r0] 0x74
	.word 0xeaacc400  ! 7290: STBA_R	stba	%r21, [%r19 + %r0] 0x20
	mov	0x8, %r27
	.word 0xeacde000  ! 7292: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r21
	.word 0xe0944400  ! 7293: LDUHA_R	lduha	[%r17, %r0] 0x20, %r16
	.word 0xe0f5a000  ! 7294: STXA_I	stxa	%r16, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 7295: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6bf8e80  ! 7296: STDA_R	stda	%r19, [%r30 + %r0] 0x74
	mov	0x3c8, %r20
	.word 0x8780204f  ! 7298: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6cee000  ! 7299: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r19
	.word 0xec8c0400  ! 7300: LDUBA_R	lduba	[%r16, %r0] 0x20, %r22
	.word 0xecce2000  ! 7301: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r22
	mov	0x70, %r25
	mov	0x70, %r17
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe4a7ce80  ! 7305: STWA_R	stwa	%r18, [%r31 + %r0] 0x74
	.word 0xe4cea000  ! 7306: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r18
	.word 0x87802074  ! 7307: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r26
	.word 0xe8f48400  ! 7309: STXA_R	stxa	%r20, [%r18 + %r0] 0x20
	.word 0xe68584a0  ! 7310: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r19
	mov	0x7d8, %r23
	.word 0xe6a7a000  ! 7312: STWA_I	stwa	%r19, [%r30 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0xeab7ce60  ! 7314: STHA_R	stha	%r21, [%r31 + %r0] 0x73
	mov	0x68, %r25
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x8780204f  ! 7317: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeace2000  ! 7318: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r21
	.word 0xe69dc4a0  ! 7319: LDDA_R	ldda	[%r23, %r0] 0x25, %r19
	.word 0xe6b62000  ! 7320: STHA_I	stha	%r19, [%r24 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xe6cee000  ! 7322: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r19
	.word 0x87802020  ! 7323: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 7324: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6b7e000  ! 7325: STHA_I	stha	%r19, [%r31 + 0x0000] %asi
	mov	0x60, %r25
	.word 0x87802020  ! 7327: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2978e60  ! 7328: LDUHA_R	lduha	[%r30, %r0] 0x73, %r17
	.word 0xe88cc400  ! 7329: LDUBA_R	lduba	[%r19, %r0] 0x20, %r20
	.word 0xe8a42000  ! 7330: STWA_I	stwa	%r20, [%r16 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xe8d46000  ! 7332: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r20
	.word 0xe8b42000  ! 7333: STHA_I	stha	%r20, [%r16 + 0x0000] %asi
	.word 0xe89c2000  ! 7334: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r20
	.word 0x87802020  ! 7335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeedcc400  ! 7336: LDXA_R	ldxa	[%r19, %r0] 0x20, %r23
	.word 0xee84a000  ! 7337: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r23
	mov	0x60, %r19
	.word 0xee8e89e0  ! 7339: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r23
	.word 0xe8bd44a0  ! 7340: STDA_R	stda	%r20, [%r21 + %r0] 0x25
	.word 0xe8d74e40  ! 7341: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r20
	mov	0x3f8, %r21
	.word 0xecb7ce60  ! 7343: STHA_R	stha	%r22, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 7344: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r20
	.word 0xe8b70e40  ! 7346: STHA_R	stha	%r20, [%r28 + %r0] 0x72
	.word 0xe4bd44a0  ! 7347: STDA_R	stda	%r18, [%r21 + %r0] 0x25
	.word 0xe4862000  ! 7348: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r18
	.word 0xeabe89e0  ! 7349: STDA_R	stda	%r21, [%r26 + %r0] 0x4f
	.word 0xeace49e0  ! 7350: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r21
	.word 0x87802072  ! 7351: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xea872000  ! 7352: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r21
	.word 0xeaf7e000  ! 7353: STXA_I	stxa	%r21, [%r31 + 0x0000] %asi
	mov	0x20, %r26
	mov	0x3c0, %r20
	mov	0x8, %r25
	.word 0xeadfe000  ! 7357: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r21
	.word 0xeabf6000  ! 7358: STDA_I	stda	%r21, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 7359: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaf42000  ! 7360: STXA_I	stxa	%r21, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 7361: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r19
	.word 0xeaf7a000  ! 7363: STXA_I	stxa	%r21, [%r30 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xeaa7a000  ! 7365: STWA_I	stwa	%r21, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 7366: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r22
	mov	0x8, %r24
	.word 0xe4a48400  ! 7369: STWA_R	stwa	%r18, [%r18 + %r0] 0x20
	.word 0xe4cc6000  ! 7370: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r18
	mov	0x18, %r16
	.word 0xe4942000  ! 7372: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r18
	.word 0xe0d7ce60  ! 7373: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r16
	.word 0xe2f44400  ! 7374: STXA_R	stxa	%r17, [%r17 + %r0] 0x20
	.word 0xe2ace000  ! 7375: STBA_I	stba	%r17, [%r19 + 0x0000] %asi
	.word 0xe2d4a000  ! 7376: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r17
	.word 0xe8a544a0  ! 7377: STWA_R	stwa	%r20, [%r21 + %r0] 0x25
	mov	0x7d0, %r20
	.word 0xe884e000  ! 7379: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r20
	mov	0x0, %r16
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xea8584a0  ! 7382: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r21
	.word 0xeaa4a000  ! 7383: STWA_I	stwa	%r21, [%r18 + 0x0000] %asi
	mov	0x68, %r26
	.word 0x87802072  ! 7385: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 7386: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xea972000  ! 7387: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r21
	.word 0x87802020  ! 7388: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea84e000  ! 7389: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r21
	.word 0xeab46000  ! 7390: STHA_I	stha	%r21, [%r17 + 0x0000] %asi
	.word 0xee8f8e80  ! 7391: LDUBA_R	lduba	[%r30, %r0] 0x74, %r23
	.word 0xeecc6000  ! 7392: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r23
	.word 0xeebf0e40  ! 7393: STDA_R	stda	%r23, [%r28 + %r0] 0x72
	ta	T_CHANGE_PRIV	! macro
	.word 0xe0c70e60  ! 7395: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r16
	.word 0xeeaf8e40  ! 7396: STBA_R	stba	%r23, [%r30 + %r0] 0x72
	.word 0xee94c400  ! 7397: LDUHA_R	lduha	[%r19, %r0] 0x20, %r23
	.word 0xeaf6c9e0  ! 7398: STXA_R	stxa	%r21, [%r27 + %r0] 0x4f
	.word 0xe8a689e0  ! 7399: STWA_R	stwa	%r20, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 7400: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6b74e60  ! 7401: STHA_R	stha	%r19, [%r29 + %r0] 0x73
	.word 0xe0af8e80  ! 7402: STBA_R	stba	%r16, [%r30 + %r0] 0x74
	.word 0xe09e49e0  ! 7403: LDDA_R	ldda	[%r25, %r0] 0x4f, %r16
	.word 0xe08c2000  ! 7404: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r16
	.word 0xe0f4a000  ! 7405: STXA_I	stxa	%r16, [%r18 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xe4f40400  ! 7407: STXA_R	stxa	%r18, [%r16 + %r0] 0x20
	.word 0xe4bce000  ! 7408: STDA_I	stda	%r18, [%r19 + 0x0000] %asi
	.word 0xe08f4e80  ! 7409: LDUBA_R	lduba	[%r29, %r0] 0x74, %r16
	.word 0xe0f4e000  ! 7410: STXA_I	stxa	%r16, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 7411: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r20
	mov	0x40, %r24
	.word 0xe0f72000  ! 7414: STXA_I	stxa	%r16, [%r28 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xeeaf4e60  ! 7416: STBA_R	stba	%r23, [%r29 + %r0] 0x73
	.word 0xeea7e000  ! 7417: STWA_I	stwa	%r23, [%r31 + 0x0000] %asi
	mov	0x40, %r24
	.word 0x8780204f  ! 7419: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r27
	mov	0x28, %r18
	.word 0xeea6e000  ! 7422: STWA_I	stwa	%r23, [%r27 + 0x0000] %asi
	mov	0x10, %r18
	mov	0x10, %r18
	.word 0xeeb6e000  ! 7425: STHA_I	stha	%r23, [%r27 + 0x0000] %asi
	.word 0xeea6e000  ! 7426: STWA_I	stwa	%r23, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 7427: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeeb5e000  ! 7428: STHA_I	stha	%r23, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 7429: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r18
	.word 0xec970e80  ! 7431: LDUHA_R	lduha	[%r28, %r0] 0x74, %r22
	.word 0xeca5c4a0  ! 7432: STWA_R	stwa	%r22, [%r23 + %r0] 0x25
	mov	0x3d0, %r20
	.word 0xe0bf4e80  ! 7434: STDA_R	stda	%r16, [%r29 + %r0] 0x74
	.word 0xe0b4a000  ! 7435: STHA_I	stha	%r16, [%r18 + 0x0000] %asi
	.word 0xe0b46000  ! 7436: STHA_I	stha	%r16, [%r17 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xe8af4e80  ! 7438: STBA_R	stba	%r20, [%r29 + %r0] 0x74
	.word 0x87802072  ! 7439: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8bf8e40  ! 7440: STDA_R	stda	%r20, [%r30 + %r0] 0x72
	.word 0xecf649e0  ! 7441: STXA_R	stxa	%r22, [%r25 + %r0] 0x4f
	mov	0x3c0, %r22
	.word 0xecb76000  ! 7443: STHA_I	stha	%r22, [%r29 + 0x0000] %asi
	.word 0xec976000  ! 7444: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r22
	.word 0xe2cd04a0  ! 7445: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r17
	.word 0xe69c0400  ! 7446: LDDA_R	ldda	[%r16, %r0] 0x20, %r19
	wr_tick_cmpr_0_59:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf4, %g2
	or	%g4, 0xfc, %g4
	or	%g6, 0xc3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe6c7a000  ! 7448: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r19
	.word 0xe09cc400  ! 7449: LDDA_R	ldda	[%r19, %r0] 0x20, %r16
	.word 0xe0bfe000  ! 7450: STDA_I	stda	%r16, [%r31 + 0x0000] %asi
	.word 0xeaac8400  ! 7451: STBA_R	stba	%r21, [%r18 + %r0] 0x20
	mov	0x7f8, %r22
	mov	0x70, %r18
	.word 0xe88609e0  ! 7454: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r20
	.word 0xe8c72000  ! 7455: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r20
	.word 0x8780204f  ! 7456: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4bd04a0  ! 7457: STDA_R	stda	%r18, [%r20 + %r0] 0x25
	.word 0xe486e000  ! 7458: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r18
	.word 0xe4dee000  ! 7459: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r18
	.word 0xecb4c400  ! 7460: STHA_R	stha	%r22, [%r19 + %r0] 0x20
	.word 0xec8e2000  ! 7461: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r22
	.word 0xec8ee000  ! 7462: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r22
	.word 0xead74e60  ! 7463: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r21
	.word 0xe6a70e40  ! 7464: STWA_R	stwa	%r19, [%r28 + %r0] 0x72
	mov	0x8, %r24
	.word 0xea8609e0  ! 7466: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r21
	.word 0xea962000  ! 7467: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r21
	.word 0xeebec9e0  ! 7468: STDA_R	stda	%r23, [%r27 + %r0] 0x4f
	.word 0xe6cdc4a0  ! 7469: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r19
	ta	T_CHANGE_HPRIV	! macro
	mov	0x30, %r18
	mov	0x8, %r16
	.word 0xeea78e40  ! 7473: STWA_R	stwa	%r23, [%r30 + %r0] 0x72
	.word 0xe6ccc400  ! 7474: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r19
	.word 0xe6be2000  ! 7475: STDA_I	stda	%r19, [%r24 + 0x0000] %asi
	.word 0xe686e000  ! 7476: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r19
	.word 0xe29c8400  ! 7477: LDDA_R	ldda	[%r18, %r0] 0x20, %r17
	.word 0xe2af4e80  ! 7478: STBA_R	stba	%r17, [%r29 + %r0] 0x74
	.word 0x87802025  ! 7479: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2d5a000  ! 7480: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r17
	.word 0xe2f56000  ! 7481: STXA_I	stxa	%r17, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 7482: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2ce6000  ! 7483: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r17
	.word 0xeef40400  ! 7484: STXA_R	stxa	%r23, [%r16 + %r0] 0x20
	.word 0xe4f40400  ! 7485: STXA_R	stxa	%r18, [%r16 + %r0] 0x20
	.word 0x87802072  ! 7486: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0b7ce60  ! 7487: STHA_R	stha	%r16, [%r31 + %r0] 0x73
	.word 0xe0bfa000  ! 7488: STDA_I	stda	%r16, [%r30 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x18, %r19
	.word 0xe0d7a000  ! 7491: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r16
	.word 0xe09f2000  ! 7492: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r16
	mov	0x3d0, %r20
	.word 0xeaa689e0  ! 7494: STWA_R	stwa	%r21, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 7495: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r26
	mov	0x68, %r25
	mov	0x7c8, %r21
	.word 0xe0970e60  ! 7499: LDUHA_R	lduha	[%r28, %r0] 0x73, %r16
	.word 0xe0c544a0  ! 7500: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r16
	.word 0xe0df2000  ! 7501: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r16
	.word 0xeca70e40  ! 7502: STWA_R	stwa	%r22, [%r28 + %r0] 0x72
	.word 0xe0f78e40  ! 7503: STXA_R	stxa	%r16, [%r30 + %r0] 0x72
	.word 0x87802074  ! 7504: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 7505: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r18
	.word 0xe6a74e40  ! 7507: STWA_R	stwa	%r19, [%r29 + %r0] 0x72
	mov	0x40, %r24
	.word 0x8780204f  ! 7509: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r27
	.word 0x8780204f  ! 7511: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r22
	.word 0x87802025  ! 7513: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r22
	.word 0xe4f609e0  ! 7515: STXA_R	stxa	%r18, [%r24 + %r0] 0x4f
	.word 0xe4b52000  ! 7516: STHA_I	stha	%r18, [%r20 + 0x0000] %asi
	.word 0xe4c52000  ! 7517: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r18
	.word 0x87802072  ! 7518: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 7519: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4b4e000  ! 7520: STHA_I	stha	%r18, [%r19 + 0x0000] %asi
	.word 0xeaddc4a0  ! 7521: LDXA_R	ldxa	[%r23, %r0] 0x25, %r21
	mov	0x3f0, %r20
	.word 0xeef4c400  ! 7523: STXA_R	stxa	%r23, [%r19 + %r0] 0x20
	.word 0xeea4a000  ! 7524: STWA_I	stwa	%r23, [%r18 + 0x0000] %asi
	.word 0xee9ce000  ! 7525: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r23
	.word 0xea8f4e80  ! 7526: LDUBA_R	lduba	[%r29, %r0] 0x74, %r21
	.word 0x87802020  ! 7527: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 7528: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r16
	.word 0xeac7a000  ! 7530: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r21
	.word 0xeaa72000  ! 7531: STWA_I	stwa	%r21, [%r28 + 0x0000] %asi
	.word 0xe8d609e0  ! 7532: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r20
	.word 0xe4f7ce40  ! 7533: STXA_R	stxa	%r18, [%r31 + %r0] 0x72
	mov	0x58, %r16
	.word 0xe4df2000  ! 7535: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r18
	.word 0xe8ad04a0  ! 7536: STBA_R	stba	%r20, [%r20 + %r0] 0x25
	mov	0x3e8, %r21
	.word 0x87802072  ! 7538: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8bf6000  ! 7539: STDA_I	stda	%r20, [%r29 + 0x0000] %asi
	.word 0xe8972000  ! 7540: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r20
	.word 0xe8dfe000  ! 7541: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r20
	mov	0x0, %r17
	mov	0x7d8, %r22
	.word 0xe8b78e60  ! 7544: STHA_R	stha	%r20, [%r30 + %r0] 0x73
	mov	0x18, %r18
	.word 0xeecfce40  ! 7546: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r23
	.word 0xeeafe000  ! 7547: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0xeeafa000  ! 7548: STBA_I	stba	%r23, [%r30 + 0x0000] %asi
	.word 0xeccf8e40  ! 7549: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r22
	.word 0xecaf0e40  ! 7550: STBA_R	stba	%r22, [%r28 + %r0] 0x72
	mov	0x3c0, %r20
	mov	0x60, %r19
	.word 0xe8f5c4a0  ! 7553: STXA_R	stxa	%r20, [%r23 + %r0] 0x25
	.word 0xe8bfa000  ! 7554: STDA_I	stda	%r20, [%r30 + 0x0000] %asi
	.word 0xe6f74e80  ! 7555: STXA_R	stxa	%r19, [%r29 + %r0] 0x74
	mov	0x3d0, %r20
	wr_tick_cmpr_0_60:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xed, %g2
	or	%g4, 0xa3, %g4
	or	%g6, 0x9a, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe6bfa000  ! 7558: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xe6af2000  ! 7559: STBA_I	stba	%r19, [%r28 + 0x0000] %asi
	.word 0xe6bf2000  ! 7560: STDA_I	stda	%r19, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 7561: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6b4e000  ! 7562: STHA_I	stha	%r19, [%r19 + 0x0000] %asi
	.word 0xec8ec9e0  ! 7563: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r22
	.word 0xecdce000  ! 7564: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r22
	mov	0x20, %r27
	mov	0x18, %r27
	.word 0xecace000  ! 7567: STBA_I	stba	%r22, [%r19 + 0x0000] %asi
	.word 0xeea6c9e0  ! 7568: STWA_R	stwa	%r23, [%r27 + %r0] 0x4f
	.word 0xee8ca000  ! 7569: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r23
	.word 0xecf4c400  ! 7570: STXA_R	stxa	%r22, [%r19 + %r0] 0x20
	mov	0x28, %r16
	mov	0x30, %r25
	.word 0xecbc2000  ! 7573: STDA_I	stda	%r22, [%r16 + 0x0000] %asi
	.word 0xec84e000  ! 7574: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r22
	.word 0xecaf4e40  ! 7575: STBA_R	stba	%r22, [%r29 + %r0] 0x72
	.word 0xec846000  ! 7576: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r22
	.word 0xe6974e60  ! 7577: LDUHA_R	lduha	[%r29, %r0] 0x73, %r19
	.word 0xe6b70e80  ! 7578: STHA_R	stha	%r19, [%r28 + %r0] 0x74
	mov	0x3e8, %r21
	.word 0xe6ace000  ! 7580: STBA_I	stba	%r19, [%r19 + 0x0000] %asi
	.word 0xe69ca000  ! 7581: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r19
	.word 0xe6c42000  ! 7582: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r19
	.word 0xe6942000  ! 7583: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r19
	mov	0x38, %r16
	mov	0x18, %r18
	mov	0x58, %r19
	.word 0xe68ce000  ! 7587: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r19
	mov	0x78, %r26
	mov	0x7f8, %r21
	.word 0xe6aca000  ! 7590: STBA_I	stba	%r19, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 7591: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe687a000  ! 7592: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r19
	.word 0xe6afe000  ! 7593: STBA_I	stba	%r19, [%r31 + 0x0000] %asi
	.word 0xeed40400  ! 7594: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r23
	.word 0xeeb7a000  ! 7595: STHA_I	stha	%r23, [%r30 + 0x0000] %asi
	.word 0xee972000  ! 7596: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r23
	.word 0x87802074  ! 7597: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xee978e60  ! 7598: LDUHA_R	lduha	[%r30, %r0] 0x73, %r23
	.word 0x87802073  ! 7599: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8940400  ! 7600: LDUHA_R	lduha	[%r16, %r0] 0x20, %r20
	mov	0x20, %r16
	.word 0xe4b70e40  ! 7602: STHA_R	stha	%r18, [%r28 + %r0] 0x72
	.word 0xe4b7a000  ! 7603: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	.word 0xe48fe000  ! 7604: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r18
	.word 0xe49f6000  ! 7605: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r18
	.word 0x87802020  ! 7606: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 7607: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2a74e40  ! 7608: STWA_R	stwa	%r17, [%r29 + %r0] 0x72
	.word 0xe2afa000  ! 7609: STBA_I	stba	%r17, [%r30 + 0x0000] %asi
	.word 0xe2f7a000  ! 7610: STXA_I	stxa	%r17, [%r30 + 0x0000] %asi
	.word 0xe29fa000  ! 7611: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r17
	.word 0x8780204f  ! 7612: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2b66000  ! 7613: STHA_I	stha	%r17, [%r25 + 0x0000] %asi
	.word 0xe4b40400  ! 7614: STHA_R	stha	%r18, [%r16 + %r0] 0x20
	.word 0xe4bc8400  ! 7615: STDA_R	stda	%r18, [%r18 + %r0] 0x20
	mov	0x40, %r18
	.word 0x87802020  ! 7617: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r16
	.word 0xeab40400  ! 7619: STHA_R	stha	%r21, [%r16 + %r0] 0x20
	.word 0xeed4c400  ! 7620: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r23
	.word 0xe2f609e0  ! 7621: STXA_R	stxa	%r17, [%r24 + %r0] 0x4f
	mov	0x3f8, %r20
	.word 0xee9e89e0  ! 7623: LDDA_R	ldda	[%r26, %r0] 0x4f, %r23
	.word 0xe6970e40  ! 7624: LDUHA_R	lduha	[%r28, %r0] 0x72, %r19
	.word 0xecbd44a0  ! 7625: STDA_R	stda	%r22, [%r21 + %r0] 0x25
	.word 0xecbc6000  ! 7626: STDA_I	stda	%r22, [%r17 + 0x0000] %asi
	.word 0xec9fce60  ! 7627: LDDA_R	ldda	[%r31, %r0] 0x73, %r22
	.word 0xe6ce89e0  ! 7628: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r19
	mov	0x78, %r24
	.word 0xe6a42000  ! 7630: STWA_I	stwa	%r19, [%r16 + 0x0000] %asi
	mov	0x48, %r25
	mov	0x7e8, %r22
	.word 0xeea4c400  ! 7633: STWA_R	stwa	%r23, [%r19 + %r0] 0x20
	.word 0xead74e80  ! 7634: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r21
	.word 0xe68544a0  ! 7635: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r19
	.word 0x87802025  ! 7636: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6bd6000  ! 7637: STDA_I	stda	%r19, [%r21 + 0x0000] %asi
	.word 0xe2aec9e0  ! 7638: STBA_R	stba	%r17, [%r27 + %r0] 0x4f
	.word 0xe2cde000  ! 7639: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r17
	.word 0xe4a544a0  ! 7640: STWA_R	stwa	%r18, [%r21 + %r0] 0x25
	wr_tick_cmpr_0_61:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf8, %g2
	or	%g4, 0xe5, %g4
	or	%g6, 0xe0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x20, %r18
	.word 0xeaa649e0  ! 7643: STWA_R	stwa	%r21, [%r25 + %r0] 0x4f
	.word 0xeab52000  ! 7644: STHA_I	stha	%r21, [%r20 + 0x0000] %asi
	.word 0xe4bf4e40  ! 7645: STDA_R	stda	%r18, [%r29 + %r0] 0x72
	.word 0xe6ddc4a0  ! 7646: LDXA_R	ldxa	[%r23, %r0] 0x25, %r19
	.word 0x87802074  ! 7647: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6a76000  ! 7648: STWA_I	stwa	%r19, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 7649: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r27
	.word 0xea978e80  ! 7651: LDUHA_R	lduha	[%r30, %r0] 0x74, %r21
	mov	0x20, %r18
	.word 0xea8d2000  ! 7653: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r21
	.word 0xe8bcc400  ! 7654: STDA_R	stda	%r20, [%r19 + %r0] 0x20
	.word 0xeaf40400  ! 7655: STXA_R	stxa	%r21, [%r16 + %r0] 0x20
	mov	0x10, %r16
	.word 0x87802025  ! 7657: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r24
	.word 0xe8f78e80  ! 7659: STXA_R	stxa	%r20, [%r30 + %r0] 0x74
	.word 0xe8cd2000  ! 7660: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r20
	.word 0xe8852000  ! 7661: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r20
	.word 0xe8cd6000  ! 7662: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r20
	.word 0x87802074  ! 7663: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 7664: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r19
	.word 0xe6f6c9e0  ! 7666: STXA_R	stxa	%r19, [%r27 + %r0] 0x4f
	.word 0xec97ce80  ! 7667: LDUHA_R	lduha	[%r31, %r0] 0x74, %r22
	.word 0xecb66000  ! 7668: STHA_I	stha	%r22, [%r25 + 0x0000] %asi
	.word 0xe4a544a0  ! 7669: STWA_R	stwa	%r18, [%r21 + %r0] 0x25
	.word 0xe4ae6000  ! 7670: STBA_I	stba	%r18, [%r25 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xecdf4e80  ! 7672: LDXA_R	ldxa	[%r29, %r0] 0x74, %r22
	mov	0x10, %r17
	.word 0xecce6000  ! 7674: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r22
	.word 0xecb6a000  ! 7675: STHA_I	stha	%r22, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 7676: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6978e80  ! 7677: LDUHA_R	lduha	[%r30, %r0] 0x74, %r19
	mov	0x18, %r16
	mov	0x18, %r24
	.word 0xe6c5a000  ! 7680: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r19
	.word 0xe6852000  ! 7681: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r19
	mov	0x7f0, %r22
	.word 0xe6b52000  ! 7683: STHA_I	stha	%r19, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 7684: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6976000  ! 7685: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r19
	.word 0xe48544a0  ! 7686: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r18
	wr_tick_cmpr_0_62:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb8, %g2
	or	%g4, 0x83, %g4
	or	%g6, 0xdc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe4afe000  ! 7688: STBA_I	stba	%r18, [%r31 + 0x0000] %asi
	.word 0xe4bfe000  ! 7689: STDA_I	stda	%r18, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 7690: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe49fa000  ! 7691: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r18
	.word 0x87802020  ! 7692: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 7693: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_0_63:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd1, %g2
	or	%g4, 0xf8, %g4
	or	%g6, 0xb2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe4872000  ! 7695: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r18
	.word 0xe4b72000  ! 7696: STHA_I	stha	%r18, [%r28 + 0x0000] %asi
	mov	0x7e8, %r22
	mov	0x60, %r18
	.word 0xe4afa000  ! 7699: STBA_I	stba	%r18, [%r30 + 0x0000] %asi
	.word 0xe0af8e60  ! 7700: STBA_R	stba	%r16, [%r30 + %r0] 0x73
	.word 0xe0d76000  ! 7701: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r16
	mov	0x0, %r24
	.word 0xe6af0e60  ! 7703: STBA_R	stba	%r19, [%r28 + %r0] 0x73
	.word 0xe6bfa000  ! 7704: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xe6bfe000  ! 7705: STDA_I	stda	%r19, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe6bc8400  ! 7707: STDA_R	stda	%r19, [%r18 + %r0] 0x20
	mov	0x7d8, %r21
	.word 0x87802072  ! 7709: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6b7a000  ! 7710: STHA_I	stha	%r19, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 7711: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r21
	.word 0xe6dc6000  ! 7713: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r19
	.word 0x8780204f  ! 7714: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4bfce80  ! 7715: STDA_R	stda	%r18, [%r31 + %r0] 0x74
	mov	0x38, %r25
	.word 0xe48e6000  ! 7717: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r18
	.word 0xe0bc8400  ! 7718: STDA_R	stda	%r16, [%r18 + %r0] 0x20
	.word 0xe0866000  ! 7719: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r16
	.word 0xec9d04a0  ! 7720: LDDA_R	ldda	[%r20, %r0] 0x25, %r22
	.word 0xe4f44400  ! 7721: STXA_R	stxa	%r18, [%r17 + %r0] 0x20
	.word 0xe4b6e000  ! 7722: STHA_I	stha	%r18, [%r27 + 0x0000] %asi
	.word 0xe4962000  ! 7723: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r18
	.word 0x87802072  ! 7724: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r26
	.word 0x87802020  ! 7726: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb74e80  ! 7727: STHA_R	stha	%r22, [%r29 + %r0] 0x74
	.word 0xeebf8e60  ! 7728: STDA_R	stda	%r23, [%r30 + %r0] 0x73
	.word 0x87802025  ! 7729: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6bec9e0  ! 7730: STDA_R	stda	%r19, [%r27 + %r0] 0x4f
	.word 0xe6952000  ! 7731: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r19
	mov	0x7e8, %r23
	.word 0xe6dda000  ! 7733: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r19
	mov	0x48, %r19
	.word 0xe6a5a000  ! 7735: STWA_I	stwa	%r19, [%r22 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x30, %r27
	mov	0x38, %r16
	.word 0xeca74e80  ! 7739: STWA_R	stwa	%r22, [%r29 + %r0] 0x74
	mov	0x38, %r17
	mov	0x38, %r26
	.word 0xe6bfce40  ! 7742: STDA_R	stda	%r19, [%r31 + %r0] 0x72
	.word 0xecc48400  ! 7743: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r22
	mov	0x7f0, %r21
	.word 0xecbd6000  ! 7745: STDA_I	stda	%r22, [%r21 + 0x0000] %asi
	mov	0x0, %r26
	mov	0x70, %r16
	.word 0xecb5e000  ! 7748: STHA_I	stha	%r22, [%r23 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xecdd6000  ! 7750: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r22
	.word 0xecb56000  ! 7751: STHA_I	stha	%r22, [%r21 + 0x0000] %asi
	mov	0x50, %r26
	mov	0x70, %r18
	.word 0xeca5e000  ! 7754: STWA_I	stwa	%r22, [%r23 + 0x0000] %asi
	.word 0xec8d6000  ! 7755: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r22
	.word 0xe6f44400  ! 7756: STXA_R	stxa	%r19, [%r17 + %r0] 0x20
	mov	0x18, %r24
	.word 0xe69da000  ! 7758: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r19
	.word 0xeece49e0  ! 7759: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r23
	.word 0xeef56000  ! 7760: STXA_I	stxa	%r23, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 7761: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeec7e000  ! 7762: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r23
	.word 0xe4f584a0  ! 7763: STXA_R	stxa	%r18, [%r22 + %r0] 0x25
	.word 0xecae09e0  ! 7764: STBA_R	stba	%r22, [%r24 + %r0] 0x4f
	.word 0xecbf2000  ! 7765: STDA_I	stda	%r22, [%r28 + 0x0000] %asi
	.word 0xecb7a000  ! 7766: STHA_I	stha	%r22, [%r30 + 0x0000] %asi
	.word 0xeca7a000  ! 7767: STWA_I	stwa	%r22, [%r30 + 0x0000] %asi
	.word 0xeedfce80  ! 7768: LDXA_R	ldxa	[%r31, %r0] 0x74, %r23
	.word 0xeab70e40  ! 7769: STHA_R	stha	%r21, [%r28 + %r0] 0x72
	mov	0x38, %r19
	.word 0x87802074  ! 7771: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r23
	mov	0x7f0, %r23
	.word 0xeadf6000  ! 7774: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r21
	.word 0xe29e09e0  ! 7775: LDDA_R	ldda	[%r24, %r0] 0x4f, %r17
	.word 0xe2cf6000  ! 7776: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r17
	mov	0x58, %r16
	.word 0x87802073  ! 7778: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 7779: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2dca000  ! 7780: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r17
	.word 0x87802073  ! 7781: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0df0e60  ! 7782: LDXA_R	ldxa	[%r28, %r0] 0x73, %r16
	.word 0xe2a5c4a0  ! 7783: STWA_R	stwa	%r17, [%r23 + %r0] 0x25
	.word 0x87802020  ! 7784: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 7785: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2a4e000  ! 7786: STWA_I	stwa	%r17, [%r19 + 0x0000] %asi
	.word 0xe2f42000  ! 7787: STXA_I	stxa	%r17, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 7788: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r20
	.word 0xe2c5a000  ! 7790: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r17
	mov	0x68, %r24
	ta	T_CHANGE_PRIV	! macro
	.word 0xeaacc400  ! 7793: STBA_R	stba	%r21, [%r19 + %r0] 0x20
	wr_tick_cmpr_0_64:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd4, %g2
	or	%g4, 0xc1, %g4
	or	%g6, 0xd6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeacda000  ! 7795: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r21
	mov	0x20, %r27
	mov	0x20, %r19
	.word 0xeab5e000  ! 7798: STHA_I	stha	%r21, [%r23 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xeaa70e60  ! 7800: STWA_R	stwa	%r21, [%r28 + %r0] 0x73
	mov	0x68, %r27
	mov	0x60, %r24
	.word 0xeab5a000  ! 7803: STHA_I	stha	%r21, [%r22 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xe0bc8400  ! 7805: STDA_R	stda	%r16, [%r18 + %r0] 0x20
	mov	0x3d8, %r21
	wr_tick_cmpr_0_65:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe7, %g2
	or	%g4, 0x96, %g4
	or	%g6, 0x85, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 7808: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e0, %r23
	.word 0x87802073  ! 7810: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 7811: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802074  ! 7813: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe08fe000  ! 7814: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r16
	mov	0x7d8, %r23
	.word 0xea8504a0  ! 7816: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r21
	.word 0xeadfe000  ! 7817: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r21
	.word 0x87802025  ! 7818: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r19
	.word 0xea8d2000  ! 7820: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r21
	.word 0xeac5a000  ! 7821: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r21
	.word 0xeadd2000  ! 7822: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r21
	.word 0xe6af8e40  ! 7823: STBA_R	stba	%r19, [%r30 + %r0] 0x72
	mov	0x0, %r16
	.word 0xe8f44400  ! 7825: STXA_R	stxa	%r20, [%r17 + %r0] 0x20
	.word 0xe8d7ce60  ! 7826: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r20
	.word 0xe885a000  ! 7827: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r20
	mov	0x28, %r16
	mov	0x20, %r16
	.word 0xe88da000  ! 7830: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r20
	.word 0xeec74e40  ! 7831: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r23
	.word 0xe6cc0400  ! 7832: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r19
	.word 0xe6dda000  ! 7833: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r19
	.word 0x87802025  ! 7834: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6dd2000  ! 7835: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r19
	.word 0xea9e89e0  ! 7836: LDDA_R	ldda	[%r26, %r0] 0x4f, %r21
	.word 0xe0c4c400  ! 7837: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r16
	mov	0x7c0, %r23
	mov	0x7c0, %r22
	.word 0xe0bd2000  ! 7840: STDA_I	stda	%r16, [%r20 + 0x0000] %asi
	.word 0xe0ade000  ! 7841: STBA_I	stba	%r16, [%r23 + 0x0000] %asi
	.word 0xeca78e80  ! 7842: STWA_R	stwa	%r22, [%r30 + %r0] 0x74
	mov	0x3d8, %r22
	.word 0xecad2000  ! 7844: STBA_I	stba	%r22, [%r20 + 0x0000] %asi
	mov	0x3f8, %r21
	.word 0x87802073  ! 7846: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeca76000  ! 7847: STWA_I	stwa	%r22, [%r29 + 0x0000] %asi
	wr_tick_cmpr_0_66:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9c, %g2
	or	%g4, 0xe8, %g4
	or	%g6, 0xf0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe88fce60  ! 7849: LDUBA_R	lduba	[%r31, %r0] 0x73, %r20
	.word 0xe2be09e0  ! 7850: STDA_R	stda	%r17, [%r24 + %r0] 0x4f
	.word 0xe2b72000  ! 7851: STHA_I	stha	%r17, [%r28 + 0x0000] %asi
	.word 0xe0bf8e80  ! 7852: STDA_R	stda	%r16, [%r30 + %r0] 0x74
	.word 0xecb7ce60  ! 7853: STHA_R	stha	%r22, [%r31 + %r0] 0x73
	.word 0xee8f0e40  ! 7854: LDUBA_R	lduba	[%r28, %r0] 0x72, %r23
	.word 0xecae49e0  ! 7855: STBA_R	stba	%r22, [%r25 + %r0] 0x4f
	.word 0xecd4c400  ! 7856: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r22
	.word 0xe8bf0e40  ! 7857: STDA_R	stda	%r20, [%r28 + %r0] 0x72
	.word 0xe8a7e000  ! 7858: STWA_I	stwa	%r20, [%r31 + 0x0000] %asi
	.word 0xe6b70e60  ! 7859: STHA_R	stha	%r19, [%r28 + %r0] 0x73
	mov	0x18, %r18
	.word 0xe6afa000  ! 7861: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xe8dfce80  ! 7863: LDXA_R	ldxa	[%r31, %r0] 0x74, %r20
	.word 0xecf649e0  ! 7864: STXA_R	stxa	%r22, [%r25 + %r0] 0x4f
	.word 0xecf72000  ! 7865: STXA_I	stxa	%r22, [%r28 + 0x0000] %asi
	mov	0x38, %r17
	.word 0x87802073  ! 7867: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2f649e0  ! 7868: STXA_R	stxa	%r17, [%r25 + %r0] 0x4f
	mov	0x70, %r18
	.word 0xe2876000  ! 7870: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r17
	.word 0xeebc8400  ! 7871: STDA_R	stda	%r23, [%r18 + %r0] 0x20
	mov	0x78, %r19
	.word 0xeebf2000  ! 7873: STDA_I	stda	%r23, [%r28 + 0x0000] %asi
	.word 0xee8d44a0  ! 7874: LDUBA_R	lduba	[%r21, %r0] 0x25, %r23
	.word 0xec96c9e0  ! 7875: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r22
	mov	0x7e8, %r22
	.word 0xecbf4e40  ! 7877: STDA_R	stda	%r22, [%r29 + %r0] 0x72
	.word 0xecbfe000  ! 7878: STDA_I	stda	%r22, [%r31 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xeaa7ce60  ! 7880: STWA_R	stwa	%r21, [%r31 + %r0] 0x73
	.word 0xeaf72000  ! 7881: STXA_I	stxa	%r21, [%r28 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xeaf7a000  ! 7883: STXA_I	stxa	%r21, [%r30 + 0x0000] %asi
	.word 0xe0ae09e0  ! 7884: STBA_R	stba	%r16, [%r24 + %r0] 0x4f
	.word 0xe0bfe000  ! 7885: STDA_I	stda	%r16, [%r31 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xe0d76000  ! 7887: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r16
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802073  ! 7889: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r27
	.word 0xe0bf2000  ! 7891: STDA_I	stda	%r16, [%r28 + 0x0000] %asi
	.word 0xeaacc400  ! 7892: STBA_R	stba	%r21, [%r19 + %r0] 0x20
	.word 0xeacfa000  ! 7893: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r21
	.word 0xe6b48400  ! 7894: STHA_R	stha	%r19, [%r18 + %r0] 0x20
	.word 0xe6d7a000  ! 7895: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r19
	.word 0xe2b649e0  ! 7896: STHA_R	stha	%r17, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 7897: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r22
	.word 0xeca7ce60  ! 7899: STWA_R	stwa	%r22, [%r31 + %r0] 0x73
	mov	0x40, %r19
	.word 0xe4970e60  ! 7901: LDUHA_R	lduha	[%r28, %r0] 0x73, %r18
	mov	0x3d8, %r22
	mov	0x30, %r18
	.word 0xe4ac4400  ! 7904: STBA_R	stba	%r18, [%r17 + %r0] 0x20
	.word 0x87802020  ! 7905: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4ace000  ! 7906: STBA_I	stba	%r18, [%r19 + 0x0000] %asi
	.word 0xe4bc2000  ! 7907: STDA_I	stda	%r18, [%r16 + 0x0000] %asi
	.word 0xe4aca000  ! 7908: STBA_I	stba	%r18, [%r18 + 0x0000] %asi
	.word 0xe48c6000  ! 7909: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r18
	.word 0xe2bf0e40  ! 7910: STDA_R	stda	%r17, [%r28 + %r0] 0x72
	.word 0x87802020  ! 7911: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2842000  ! 7912: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r17
	.word 0x87802020  ! 7913: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a4c400  ! 7914: STWA_R	stwa	%r16, [%r19 + %r0] 0x20
	.word 0xe0dc6000  ! 7915: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r16
	.word 0xe48c0400  ! 7916: LDUBA_R	lduba	[%r16, %r0] 0x20, %r18
	.word 0xe484a000  ! 7917: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r18
	.word 0xe49c2000  ! 7918: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r18
	mov	0x0, %r26
	mov	0x7c8, %r22
	.word 0xe4c4a000  ! 7921: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r18
	.word 0xe0be09e0  ! 7922: STDA_R	stda	%r16, [%r24 + %r0] 0x4f
	.word 0xe0a74e40  ! 7923: STWA_R	stwa	%r16, [%r29 + %r0] 0x72
	.word 0xe0f42000  ! 7924: STXA_I	stxa	%r16, [%r16 + 0x0000] %asi
	.word 0xe0b46000  ! 7925: STHA_I	stha	%r16, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 7926: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeeac0400  ! 7927: STBA_R	stba	%r23, [%r16 + %r0] 0x20
	mov	0x8, %r18
	.word 0xee85a000  ! 7929: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r23
	wr_tick_cmpr_0_67:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x83, %g2
	or	%g4, 0xc2, %g4
	or	%g6, 0xe6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x68, %r18
	mov	0x60, %r24
	.word 0x87802020  ! 7933: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6a70e80  ! 7934: STWA_R	stwa	%r19, [%r28 + %r0] 0x74
	.word 0xe6ac2000  ! 7935: STBA_I	stba	%r19, [%r16 + 0x0000] %asi
	.word 0xe2f504a0  ! 7936: STXA_R	stxa	%r17, [%r20 + %r0] 0x25
	mov	0x10, %r27
	.word 0xe28c6000  ! 7938: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r17
	mov	0x0, %r27
	.word 0xe2946000  ! 7940: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r17
	.word 0xe4b544a0  ! 7941: STHA_R	stha	%r18, [%r21 + %r0] 0x25
	.word 0xecc44400  ! 7942: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r22
	.word 0xec946000  ! 7943: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r22
	.word 0x87802025  ! 7944: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeca5e000  ! 7945: STWA_I	stwa	%r22, [%r23 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xe2a40400  ! 7947: STWA_R	stwa	%r17, [%r16 + %r0] 0x20
	mov	0x30, %r18
	.word 0xe2f5e000  ! 7949: STXA_I	stxa	%r17, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 7950: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r27
	.word 0xe2dce000  ! 7952: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r17
	.word 0xe2846000  ! 7953: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r17
	.word 0xe2b4a000  ! 7954: STHA_I	stha	%r17, [%r18 + 0x0000] %asi
	.word 0xe29544a0  ! 7955: LDUHA_R	lduha	[%r21, %r0] 0x25, %r17
	.word 0x87802020  ! 7956: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2f7ce40  ! 7957: STXA_R	stxa	%r17, [%r31 + %r0] 0x72
	.word 0xe2f4e000  ! 7958: STXA_I	stxa	%r17, [%r19 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x8, %r17
	.word 0xeed40400  ! 7961: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r23
	mov	0x40, %r24
	.word 0x8780204f  ! 7963: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 7964: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe48504a0  ! 7965: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r18
	.word 0xe4a52000  ! 7966: STWA_I	stwa	%r18, [%r20 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xe09649e0  ! 7968: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r16
	.word 0xe09da000  ! 7969: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r16
	.word 0xe0c56000  ! 7970: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r16
	mov	0x18, %r24
	.word 0xe49f8e60  ! 7972: LDDA_R	ldda	[%r30, %r0] 0x73, %r18
	.word 0xe4cde000  ! 7973: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r18
	.word 0xe4b5e000  ! 7974: STHA_I	stha	%r18, [%r23 + 0x0000] %asi
	.word 0xe8cd44a0  ! 7975: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r20
	mov	0x10, %r27
	.word 0xeabfce40  ! 7977: STDA_R	stda	%r21, [%r31 + %r0] 0x72
	.word 0x87802020  ! 7978: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 7979: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xea8de000  ! 7980: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r21
	.word 0xeed7ce60  ! 7981: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r23
	.word 0xe09f8e40  ! 7982: LDDA_R	ldda	[%r30, %r0] 0x72, %r16
	.word 0xe8870e40  ! 7983: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r20
	.word 0xe8cd2000  ! 7984: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r20
	.word 0xeecf4e80  ! 7985: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r23
	mov	0x58, %r24
	mov	0x20, %r24
	.word 0xeedd6000  ! 7988: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r23
	.word 0x87802074  ! 7989: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2a7ce60  ! 7990: STWA_R	stwa	%r17, [%r31 + %r0] 0x73
	.word 0xe2af2000  ! 7991: STBA_I	stba	%r17, [%r28 + 0x0000] %asi
	.word 0xeaa5c4a0  ! 7992: STWA_R	stwa	%r21, [%r23 + %r0] 0x25
	.word 0xeabfe000  ! 7993: STDA_I	stda	%r21, [%r31 + 0x0000] %asi
	mov	0x78, %r17
	.word 0x87802025  ! 7995: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecf70e40  ! 7996: STXA_R	stxa	%r22, [%r28 + %r0] 0x72
	.word 0xe8f609e0  ! 7997: STXA_R	stxa	%r20, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 7998: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r26
	.word 0xeac609e0  ! 8000: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r21
	.word 0x87802073  ! 8001: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r17
	.word 0xe084c400  ! 8003: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r16
	.word 0xe0af8e40  ! 8004: STBA_R	stba	%r16, [%r30 + %r0] 0x72
	.word 0xecf48400  ! 8005: STXA_R	stxa	%r22, [%r18 + %r0] 0x20
	.word 0xec8d04a0  ! 8006: LDUBA_R	lduba	[%r20, %r0] 0x25, %r22
	.word 0xeef609e0  ! 8007: STXA_R	stxa	%r23, [%r24 + %r0] 0x4f
	.word 0xeed7a000  ! 8008: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r23
	.word 0xe8a78e60  ! 8009: STWA_R	stwa	%r20, [%r30 + %r0] 0x73
	.word 0xe88f2000  ! 8010: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r20
	mov	0x3e8, %r21
	.word 0xe8af6000  ! 8012: STBA_I	stba	%r20, [%r29 + 0x0000] %asi
	mov	0x20, %r27
	.word 0x87802025  ! 8014: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe89da000  ! 8015: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r20
	.word 0xe88de000  ! 8016: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r20
	.word 0x87802073  ! 8017: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe68d44a0  ! 8018: LDUBA_R	lduba	[%r21, %r0] 0x25, %r19
	mov	0x60, %r19
	mov	0x0, %r27
	.word 0x87802025  ! 8021: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 8022: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeeb649e0  ! 8023: STHA_R	stha	%r23, [%r25 + %r0] 0x4f
	.word 0xeea7e000  ! 8024: STWA_I	stwa	%r23, [%r31 + 0x0000] %asi
	.word 0xeedf6000  ! 8025: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r23
	mov	0x7d0, %r21
	mov	0x78, %r25
	.word 0x8780204f  ! 8028: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeaf78e60  ! 8029: STXA_R	stxa	%r21, [%r30 + %r0] 0x73
	mov	0x40, %r26
	.word 0xeea609e0  ! 8031: STWA_R	stwa	%r23, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 8032: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeef40400  ! 8033: STXA_R	stxa	%r23, [%r16 + %r0] 0x20
	.word 0xe8ae09e0  ! 8034: STBA_R	stba	%r20, [%r24 + %r0] 0x4f
	.word 0xe8df2000  ! 8035: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r20
	.word 0xeed78e60  ! 8036: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r23
	mov	0x8, %r26
	.word 0xeec7e000  ! 8038: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r23
	mov	0x30, %r19
	mov	0x3d0, %r20
	.word 0xeed76000  ! 8041: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r23
	.word 0xeef76000  ! 8042: STXA_I	stxa	%r23, [%r29 + 0x0000] %asi
	.word 0xe6bf8e60  ! 8043: STDA_R	stda	%r19, [%r30 + %r0] 0x73
	.word 0xee8f4e60  ! 8044: LDUBA_R	lduba	[%r29, %r0] 0x73, %r23
	mov	0x38, %r18
	.word 0xe2b40400  ! 8046: STHA_R	stha	%r17, [%r16 + %r0] 0x20
	.word 0x87802020  ! 8047: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2a4e000  ! 8048: STWA_I	stwa	%r17, [%r19 + 0x0000] %asi
	.word 0xe2cca000  ! 8049: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r17
	mov	0x50, %r26
	.word 0xe2ace000  ! 8051: STBA_I	stba	%r17, [%r19 + 0x0000] %asi
	.word 0xe2b40400  ! 8052: STHA_R	stha	%r17, [%r16 + %r0] 0x20
	.word 0xe2d4a000  ! 8053: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r17
	.word 0xe2946000  ! 8054: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r17
	.word 0x87802025  ! 8055: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r18
	.word 0xe28689e0  ! 8057: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r17
	.word 0x87802074  ! 8058: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xec8609e0  ! 8059: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r22
	.word 0xe2974e80  ! 8060: LDUHA_R	lduha	[%r29, %r0] 0x74, %r17
	.word 0x87802073  ! 8061: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2876000  ! 8062: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r17
	mov	0x38, %r26
	.word 0xe2d7e000  ! 8064: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r17
	.word 0xe2b72000  ! 8065: STHA_I	stha	%r17, [%r28 + 0x0000] %asi
	.word 0xe0f40400  ! 8066: STXA_R	stxa	%r16, [%r16 + %r0] 0x20
	.word 0x87802020  ! 8067: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0f42000  ! 8068: STXA_I	stxa	%r16, [%r16 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xe0f46000  ! 8070: STXA_I	stxa	%r16, [%r17 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xeaa689e0  ! 8072: STWA_R	stwa	%r21, [%r26 + %r0] 0x4f
	.word 0xea9c2000  ! 8073: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r21
	.word 0xeaaca000  ! 8074: STBA_I	stba	%r21, [%r18 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0xe6840400  ! 8076: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r19
	.word 0x8780204f  ! 8077: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6dee000  ! 8078: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r19
	.word 0xe6a6a000  ! 8079: STWA_I	stwa	%r19, [%r26 + 0x0000] %asi
	.word 0xe6966000  ! 8080: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r19
	.word 0xe6ae2000  ! 8081: STBA_I	stba	%r19, [%r24 + 0x0000] %asi
	.word 0xe6b6a000  ! 8082: STHA_I	stha	%r19, [%r26 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xe29609e0  ! 8084: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r17
	mov	0x7c0, %r21
	.word 0xe29ea000  ! 8086: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r17
	.word 0xe2ae2000  ! 8087: STBA_I	stba	%r17, [%r24 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xe6bfce60  ! 8089: STDA_R	stda	%r19, [%r31 + %r0] 0x73
	.word 0x87802020  ! 8090: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeca5c4a0  ! 8091: STWA_R	stwa	%r22, [%r23 + %r0] 0x25
	mov	0x38, %r24
	.word 0xe6c7ce60  ! 8093: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r19
	.word 0xe4940400  ! 8094: LDUHA_R	lduha	[%r16, %r0] 0x20, %r18
	.word 0xe6970e80  ! 8095: LDUHA_R	lduha	[%r28, %r0] 0x74, %r19
	.word 0xea87ce40  ! 8096: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r21
	.word 0xeab42000  ! 8097: STHA_I	stha	%r21, [%r16 + 0x0000] %asi
	.word 0xeaf4a000  ! 8098: STXA_I	stxa	%r21, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 8099: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeca584a0  ! 8100: STWA_R	stwa	%r22, [%r22 + %r0] 0x25
	.word 0x87802025  ! 8101: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeca52000  ! 8102: STWA_I	stwa	%r22, [%r20 + 0x0000] %asi
	.word 0xe2bc8400  ! 8103: STDA_R	stda	%r17, [%r18 + %r0] 0x20
	.word 0x87802073  ! 8104: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r20
	.word 0xe8b6c9e0  ! 8106: STHA_R	stha	%r20, [%r27 + %r0] 0x4f
	.word 0xe8b7e000  ! 8107: STHA_I	stha	%r20, [%r31 + 0x0000] %asi
	.word 0xe68fce60  ! 8108: LDUBA_R	lduba	[%r31, %r0] 0x73, %r19
	.word 0xe6b76000  ! 8109: STHA_I	stha	%r19, [%r29 + 0x0000] %asi
	.word 0xe697e000  ! 8110: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r19
	.word 0xe09ec9e0  ! 8111: LDDA_R	ldda	[%r27, %r0] 0x4f, %r16
	.word 0xe0f76000  ! 8112: STXA_I	stxa	%r16, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 8113: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4bc0400  ! 8114: STDA_R	stda	%r18, [%r16 + %r0] 0x20
	.word 0xe48c4400  ! 8115: LDUBA_R	lduba	[%r17, %r0] 0x20, %r18
	mov	0x3d8, %r23
	.word 0xe496e000  ! 8117: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r18
	.word 0x87802020  ! 8118: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 8119: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4878e60  ! 8120: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r18
	.word 0x87802020  ! 8121: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe28e09e0  ! 8122: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r17
	.word 0xe2a40400  ! 8123: STWA_R	stwa	%r17, [%r16 + %r0] 0x20
	mov	0x10, %r19
	mov	0x10, %r17
	.word 0xe2f4e000  ! 8126: STXA_I	stxa	%r17, [%r19 + 0x0000] %asi
	mov	0x18, %r27
	.word 0x87802074  ! 8128: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r16
	mov	0x18, %r27
	.word 0xe2cf6000  ! 8131: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r17
	.word 0xeaa4c400  ! 8132: STWA_R	stwa	%r21, [%r19 + %r0] 0x20
	mov	0x48, %r17
	.word 0x87802025  ! 8134: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8c78e40  ! 8135: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r20
	.word 0xe4c584a0  ! 8136: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r18
	mov	0x58, %r18
	.word 0xeea78e40  ! 8138: STWA_R	stwa	%r23, [%r30 + %r0] 0x72
	.word 0xee85e000  ! 8139: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r23
	mov	0x3c0, %r23
	.word 0xecaf0e40  ! 8141: STBA_R	stba	%r22, [%r28 + %r0] 0x72
	.word 0x87802020  ! 8142: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r22
	.word 0xeca4e000  ! 8144: STWA_I	stwa	%r22, [%r19 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xe8f4c400  ! 8146: STXA_R	stxa	%r20, [%r19 + %r0] 0x20
	.word 0xe8cce000  ! 8147: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r20
	.word 0xe8dc6000  ! 8148: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r20
	.word 0xe0b4c400  ! 8149: STHA_R	stha	%r16, [%r19 + %r0] 0x20
	.word 0xe4b44400  ! 8150: STHA_R	stha	%r18, [%r17 + %r0] 0x20
	.word 0xe8a609e0  ! 8151: STWA_R	stwa	%r20, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 8152: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6940400  ! 8153: LDUHA_R	lduha	[%r16, %r0] 0x20, %r19
	mov	0x28, %r24
	mov	0x3e0, %r23
	.word 0x87802020  ! 8156: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xeeb40400  ! 8158: STHA_R	stha	%r23, [%r16 + %r0] 0x20
	.word 0xeec46000  ! 8159: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r23
	.word 0xeabdc4a0  ! 8160: STDA_R	stda	%r21, [%r23 + %r0] 0x25
	.word 0xea9c6000  ! 8161: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r21
	.word 0xe0bf0e80  ! 8162: STDA_R	stda	%r16, [%r28 + %r0] 0x74
	.word 0xe8f40400  ! 8163: STXA_R	stxa	%r20, [%r16 + %r0] 0x20
	.word 0xe8d4e000  ! 8164: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r20
	mov	0x58, %r18
	.word 0x87802020  ! 8166: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_0_68:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdb, %g2
	or	%g4, 0xc4, %g4
	or	%g6, 0xaa, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe8cc2000  ! 8168: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r20
	.word 0xe8bf8e60  ! 8169: STDA_R	stda	%r20, [%r30 + %r0] 0x73
	.word 0xe8cc6000  ! 8170: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r20
	mov	0x18, %r19
	.word 0x87802072  ! 8172: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6afce40  ! 8173: STBA_R	stba	%r19, [%r31 + %r0] 0x72
	.word 0xe8b40400  ! 8174: STHA_R	stha	%r20, [%r16 + %r0] 0x20
	.word 0xe8b7a000  ! 8175: STHA_I	stha	%r20, [%r30 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0x87802020  ! 8177: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r19
	.word 0xeaf70e80  ! 8179: STXA_R	stxa	%r21, [%r28 + %r0] 0x74
	.word 0xe0f70e60  ! 8180: STXA_R	stxa	%r16, [%r28 + %r0] 0x73
	.word 0xe2a70e60  ! 8181: STWA_R	stwa	%r17, [%r28 + %r0] 0x73
	.word 0xe2cce000  ! 8182: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r17
	.word 0xe8940400  ! 8183: LDUHA_R	lduha	[%r16, %r0] 0x20, %r20
	mov	0x10, %r25
	.word 0xee85c4a0  ! 8185: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r23
	.word 0xee870e60  ! 8186: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r23
	.word 0xe0bc0400  ! 8187: STDA_R	stda	%r16, [%r16 + %r0] 0x20
	.word 0x87802072  ! 8188: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 8189: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0a76000  ! 8190: STWA_I	stwa	%r16, [%r29 + 0x0000] %asi
	.word 0xe8a78e80  ! 8191: STWA_R	stwa	%r20, [%r30 + %r0] 0x74
	mov	0x7c0, %r21
	.word 0xee85c4a0  ! 8193: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r23
	.word 0xec8e09e0  ! 8194: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r22
	.word 0xeca7e000  ! 8195: STWA_I	stwa	%r22, [%r31 + 0x0000] %asi
	.word 0xe8b40400  ! 8196: STHA_R	stha	%r20, [%r16 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0xe88fa000  ! 8198: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r20
	mov	0x7e8, %r22
	.word 0xe4bf8e60  ! 8200: STDA_R	stda	%r18, [%r30 + %r0] 0x73
	.word 0xe4b7a000  ! 8201: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 8202: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4a7e000  ! 8203: STWA_I	stwa	%r18, [%r31 + 0x0000] %asi
	.word 0xe4ccc400  ! 8204: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r18
	mov	0x50, %r19
	mov	0x20, %r27
	.word 0xe4df2000  ! 8207: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r18
	.word 0xecb609e0  ! 8208: STHA_R	stha	%r22, [%r24 + %r0] 0x4f
	mov	0x7c8, %r20
	mov	0x3c0, %r22
	mov	0x3d0, %r21
	mov	0x50, %r17
	.word 0xe0f504a0  ! 8213: STXA_R	stxa	%r16, [%r20 + %r0] 0x25
	.word 0x87802073  ! 8214: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0d72000  ! 8215: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r16
	mov	0x3d0, %r23
	.word 0xe08fa000  ! 8217: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r16
	mov	0x3c8, %r21
	.word 0x87802072  ! 8219: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r18
	.word 0xe0a76000  ! 8221: STWA_I	stwa	%r16, [%r29 + 0x0000] %asi
	.word 0xecdf4e60  ! 8222: LDXA_R	ldxa	[%r29, %r0] 0x73, %r22
	.word 0xecaf2000  ! 8223: STBA_I	stba	%r22, [%r28 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xecafa000  ! 8225: STBA_I	stba	%r22, [%r30 + 0x0000] %asi
	.word 0xec876000  ! 8226: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r22
	.word 0xec976000  ! 8227: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r22
	.word 0xec976000  ! 8228: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r22
	.word 0xec8fe000  ! 8229: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r22
	mov	0x8, %r19
	.word 0xe0bf4e80  ! 8231: STDA_R	stda	%r16, [%r29 + %r0] 0x74
	.word 0xe6a649e0  ! 8232: STWA_R	stwa	%r19, [%r25 + %r0] 0x4f
	.word 0xeed78e80  ! 8233: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r23
	.word 0xe0d4c400  ! 8234: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r16
	.word 0xe4870e80  ! 8235: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r18
	.word 0xe4c72000  ! 8236: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r18
	.word 0xe4bf6000  ! 8237: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 8238: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r27
	mov	0x10, %r24
	.word 0xea8ec9e0  ! 8241: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r21
	ta	T_CHANGE_PRIV	! macro
	.word 0xea9c6000  ! 8243: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r21
	.word 0xeaa42000  ! 8244: STWA_I	stwa	%r21, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 8245: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 8246: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r21
	.word 0xe0a70e40  ! 8248: STWA_R	stwa	%r16, [%r28 + %r0] 0x72
	.word 0xe6bcc400  ! 8249: STDA_R	stda	%r19, [%r19 + %r0] 0x20
	.word 0xe6cfa000  ! 8250: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r19
	mov	0x7c8, %r22
	.word 0xe6876000  ! 8252: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r19
	.word 0xe6f7a000  ! 8253: STXA_I	stxa	%r19, [%r30 + 0x0000] %asi
	mov	0x68, %r27
	mov	0x3c0, %r21
	mov	0x50, %r19
	.word 0xe6cf2000  ! 8257: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r19
	.word 0xe697e000  ! 8258: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r19
	.word 0xe6f72000  ! 8259: STXA_I	stxa	%r19, [%r28 + 0x0000] %asi
	mov	0x48, %r19
	.word 0x87802020  ! 8261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8d7ce40  ! 8262: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r20
	.word 0x87802020  ! 8263: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeec44400  ! 8264: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r23
	.word 0xeedc2000  ! 8265: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r23
	.word 0x8780204f  ! 8266: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 8267: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r19
	mov	0x7f0, %r20
	.word 0xeeb72000  ! 8270: STHA_I	stha	%r23, [%r28 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xee8fa000  ! 8272: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r23
	.word 0x87802073  ! 8273: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2a5c4a0  ! 8274: STWA_R	stwa	%r17, [%r23 + %r0] 0x25
	mov	0x7d0, %r20
	.word 0xe2a76000  ! 8276: STWA_I	stwa	%r17, [%r29 + 0x0000] %asi
	.word 0xe4dc8400  ! 8277: LDXA_R	ldxa	[%r18, %r0] 0x20, %r18
	.word 0xe6de09e0  ! 8278: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r19
	.word 0xe6cfa000  ! 8279: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r19
	.word 0xe6a72000  ! 8280: STWA_I	stwa	%r19, [%r28 + 0x0000] %asi
	.word 0xe68fe000  ! 8281: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r19
	.word 0xeaac8400  ! 8282: STBA_R	stba	%r21, [%r18 + %r0] 0x20
	.word 0xea8f6000  ! 8283: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r21
	mov	0x28, %r25
	.word 0xeacfe000  ! 8285: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r21
	.word 0xe4ac4400  ! 8286: STBA_R	stba	%r18, [%r17 + %r0] 0x20
	.word 0x87802025  ! 8287: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4f56000  ! 8288: STXA_I	stxa	%r18, [%r21 + 0x0000] %asi
	.word 0xe48f0e40  ! 8289: LDUBA_R	lduba	[%r28, %r0] 0x72, %r18
	.word 0xe4c5e000  ! 8290: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r18
	.word 0xe48da000  ! 8291: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r18
	.word 0xe0d609e0  ! 8292: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r16
	.word 0xe0bd2000  ! 8293: STDA_I	stda	%r16, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 8294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0d4e000  ! 8295: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r16
	.word 0x87802020  ! 8296: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r16
	.word 0xe88e09e0  ! 8298: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r20
	.word 0x8780204f  ! 8299: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8c62000  ! 8300: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r20
	.word 0xe8b62000  ! 8301: STHA_I	stha	%r20, [%r24 + 0x0000] %asi
	.word 0xe8ae6000  ! 8302: STBA_I	stba	%r20, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 8303: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe88dc4a0  ! 8304: LDUBA_R	lduba	[%r23, %r0] 0x25, %r20
	.word 0xe8a52000  ! 8305: STWA_I	stwa	%r20, [%r20 + 0x0000] %asi
	.word 0xe8bd6000  ! 8306: STDA_I	stda	%r20, [%r21 + 0x0000] %asi
	.word 0xe6a7ce60  ! 8307: STWA_R	stwa	%r19, [%r31 + %r0] 0x73
	.word 0xe6a56000  ! 8308: STWA_I	stwa	%r19, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 8309: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0b44400  ! 8310: STHA_R	stha	%r16, [%r17 + %r0] 0x20
	.word 0xeedcc400  ! 8311: LDXA_R	ldxa	[%r19, %r0] 0x20, %r23
	mov	0x30, %r18
	.word 0xeea72000  ! 8313: STWA_I	stwa	%r23, [%r28 + 0x0000] %asi
	.word 0xee8fe000  ! 8314: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r23
	.word 0xeef7e000  ! 8315: STXA_I	stxa	%r23, [%r31 + 0x0000] %asi
	.word 0xeecfa000  ! 8316: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r23
	.word 0x8780204f  ! 8317: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeea6a000  ! 8318: STWA_I	stwa	%r23, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 8319: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeebe2000  ! 8320: STDA_I	stda	%r23, [%r24 + 0x0000] %asi
	.word 0xee862000  ! 8321: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r23
	mov	0x3e0, %r23
	.word 0xeece6000  ! 8323: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r23
	.word 0xead544a0  ! 8324: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r21
	.word 0x87802020  ! 8325: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe08544a0  ! 8326: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r16
	.word 0xe0cce000  ! 8327: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r16
	mov	0x3d8, %r23
	.word 0xeedf8e60  ! 8329: LDXA_R	ldxa	[%r30, %r0] 0x73, %r23
	.word 0xeedc6000  ! 8330: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r23
	.word 0xeecce000  ! 8331: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r23
	.word 0xeeb42000  ! 8332: STHA_I	stha	%r23, [%r16 + 0x0000] %asi
	.word 0xeedc6000  ! 8333: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r23
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xeace09e0  ! 8335: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r21
	.word 0xe0dcc400  ! 8336: LDXA_R	ldxa	[%r19, %r0] 0x20, %r16
	mov	0x7c0, %r20
	mov	0x38, %r19
	mov	0x70, %r18
	.word 0xe6b5c4a0  ! 8340: STHA_R	stha	%r19, [%r23 + %r0] 0x25
	mov	0x7c8, %r21
	.word 0xe6b4a000  ! 8342: STHA_I	stha	%r19, [%r18 + 0x0000] %asi
	.word 0xea86c9e0  ! 8343: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r21
	mov	0x58, %r27
	.word 0xeaaca000  ! 8345: STBA_I	stba	%r21, [%r18 + 0x0000] %asi
	.word 0xeea44400  ! 8346: STWA_R	stwa	%r23, [%r17 + %r0] 0x20
	mov	0x50, %r27
	.word 0xeeac6000  ! 8348: STBA_I	stba	%r23, [%r17 + 0x0000] %asi
	.word 0xee8ce000  ! 8349: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r23
	.word 0xe48f4e60  ! 8350: LDUBA_R	lduba	[%r29, %r0] 0x73, %r18
	.word 0xe4f46000  ! 8351: STXA_I	stxa	%r18, [%r17 + 0x0000] %asi
	.word 0xeaa609e0  ! 8352: STWA_R	stwa	%r21, [%r24 + %r0] 0x4f
	mov	0x8, %r26
	.word 0xeabc6000  ! 8354: STDA_I	stda	%r21, [%r17 + 0x0000] %asi
	.word 0xeedf0e40  ! 8355: LDXA_R	ldxa	[%r28, %r0] 0x72, %r23
	mov	0x7e0, %r23
	.word 0xe6a70e60  ! 8357: STWA_R	stwa	%r19, [%r28 + %r0] 0x73
	mov	0x10, %r27
	.word 0xe6f4a000  ! 8359: STXA_I	stxa	%r19, [%r18 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xeec584a0  ! 8361: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r23
	wr_tick_cmpr_0_69:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xae, %g2
	or	%g4, 0xb8, %g4
	or	%g6, 0x99, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeebc6000  ! 8363: STDA_I	stda	%r23, [%r17 + 0x0000] %asi
	.word 0xee9c6000  ! 8364: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r23
	.word 0x87802020  ! 8365: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r18
	mov	0x38, %r18
	.word 0xee94a000  ! 8368: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r23
	.word 0xeebc2000  ! 8369: STDA_I	stda	%r23, [%r16 + 0x0000] %asi
	mov	0x3d8, %r22
	ta	T_CHANGE_PRIV	! macro
	mov	0x58, %r17
	mov	0x30, %r16
	.word 0x87802072  ! 8374: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r19
	.word 0xeeaf6000  ! 8376: STBA_I	stba	%r23, [%r29 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xe0870e40  ! 8378: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r16
	.word 0xe8cc8400  ! 8379: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r20
	.word 0xe8972000  ! 8380: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r20
	.word 0x87802073  ! 8381: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 8383: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8866000  ! 8384: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r20
	mov	0x58, %r18
	.word 0xe88e6000  ! 8386: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r20
	mov	0x28, %r27
	.word 0x87802020  ! 8388: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8ace000  ! 8389: STBA_I	stba	%r20, [%r19 + 0x0000] %asi
	.word 0xeadec9e0  ! 8390: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r21
	.word 0xea9ce000  ! 8391: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r21
	.word 0xee87ce60  ! 8392: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r23
	.word 0xeea7ce40  ! 8393: STWA_R	stwa	%r23, [%r31 + %r0] 0x72
	mov	0x8, %r27
	.word 0xe6d40400  ! 8395: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r19
	mov	0x78, %r17
	.word 0xe0d689e0  ! 8397: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r16
	mov	0x48, %r18
	.word 0xe08ca000  ! 8399: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r16
	.word 0xe4ae09e0  ! 8400: STBA_R	stba	%r18, [%r24 + %r0] 0x4f
	.word 0xecdc8400  ! 8401: LDXA_R	ldxa	[%r18, %r0] 0x20, %r22
	.word 0xecf4e000  ! 8402: STXA_I	stxa	%r22, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 8403: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 8404: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 8405: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6bcc400  ! 8406: STDA_R	stda	%r19, [%r19 + %r0] 0x20
	.word 0xe6872000  ! 8407: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r19
	.word 0xe6af2000  ! 8408: STBA_I	stba	%r19, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 8409: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6afa000  ! 8410: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	mov	0x18, %r16
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x0, %r27
	.word 0x87802072  ! 8414: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6bfa000  ! 8415: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xe88609e0  ! 8416: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r20
	.word 0xe8dfa000  ! 8417: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r20
	.word 0xe2be49e0  ! 8418: STDA_R	stda	%r17, [%r25 + %r0] 0x4f
	.word 0xeea44400  ! 8419: STWA_R	stwa	%r23, [%r17 + %r0] 0x20
	mov	0x60, %r26
	.word 0xeeaf2000  ! 8421: STBA_I	stba	%r23, [%r28 + 0x0000] %asi
	.word 0xeeafe000  ! 8422: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0xe89689e0  ! 8423: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r20
	.word 0xe8d78e80  ! 8424: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r20
	mov	0x40, %r16
	.word 0x87802020  ! 8426: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	mov	0x3d0, %r23
	mov	0x7d8, %r23
	.word 0x87802020  ! 8430: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeeaec9e0  ! 8431: STBA_R	stba	%r23, [%r27 + %r0] 0x4f
	.word 0xeccf8e60  ! 8432: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r22
	.word 0x87802073  ! 8433: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r20
	mov	0x3c8, %r20
	.word 0xe6ad04a0  ! 8436: STBA_R	stba	%r19, [%r20 + %r0] 0x25
	.word 0xeccfce60  ! 8437: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r22
	.word 0x87802020  ! 8438: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6dd44a0  ! 8439: LDXA_R	ldxa	[%r21, %r0] 0x25, %r19
	.word 0xe6a46000  ! 8440: STWA_I	stwa	%r19, [%r17 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xea8e49e0  ! 8442: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r21
	.word 0xe6f504a0  ! 8443: STXA_R	stxa	%r19, [%r20 + %r0] 0x25
	.word 0xe4cf8e40  ! 8444: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r18
	.word 0xeacf8e40  ! 8445: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r21
	.word 0xea8ce000  ! 8446: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r21
	.word 0xeac70e40  ! 8447: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r21
	.word 0xe69e09e0  ! 8448: LDDA_R	ldda	[%r24, %r0] 0x4f, %r19
	.word 0x87802072  ! 8449: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xea9f4e40  ! 8450: LDDA_R	ldda	[%r29, %r0] 0x72, %r21
	.word 0x87802074  ! 8451: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6dc0400  ! 8452: LDXA_R	ldxa	[%r16, %r0] 0x20, %r19
	.word 0xe6bf2000  ! 8453: STDA_I	stda	%r19, [%r28 + 0x0000] %asi
	mov	0x40, %r27
	.word 0x87802072  ! 8455: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6d7a000  ! 8456: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r19
	mov	0x38, %r16
	.word 0xe6b72000  ! 8458: STHA_I	stha	%r19, [%r28 + 0x0000] %asi
	.word 0xe6bf2000  ! 8459: STDA_I	stda	%r19, [%r28 + 0x0000] %asi
	.word 0xeef649e0  ! 8460: STXA_R	stxa	%r23, [%r25 + %r0] 0x4f
	.word 0xe2878e80  ! 8461: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r17
	.word 0x87802074  ! 8462: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 8463: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r18
	.word 0xe6c44400  ! 8465: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r19
	.word 0xe6de09e0  ! 8466: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r19
	mov	0x3c8, %r20
	.word 0xee870e60  ! 8468: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r23
	.word 0xe487ce40  ! 8469: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r18
	.word 0xe2bc0400  ! 8470: STDA_R	stda	%r17, [%r16 + %r0] 0x20
	mov	0x20, %r19
	.word 0xe2b7a000  ! 8472: STHA_I	stha	%r17, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 8473: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2c66000  ! 8474: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r17
	.word 0x87802072  ! 8475: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8b7ce60  ! 8476: STHA_R	stha	%r20, [%r31 + %r0] 0x73
	.word 0xe8b7e000  ! 8477: STHA_I	stha	%r20, [%r31 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xe88f2000  ! 8479: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r20
	.word 0xeedc4400  ! 8480: LDXA_R	ldxa	[%r17, %r0] 0x20, %r23
	.word 0xe08689e0  ! 8481: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r16
	.word 0xeaac4400  ! 8482: STBA_R	stba	%r21, [%r17 + %r0] 0x20
	.word 0xeab7a000  ! 8483: STHA_I	stha	%r21, [%r30 + 0x0000] %asi
	mov	0x3f0, %r23
	ta	T_CHANGE_PRIV	! macro
	.word 0xea972000  ! 8486: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r21
	.word 0xe2dc4400  ! 8487: LDXA_R	ldxa	[%r17, %r0] 0x20, %r17
	.word 0xe2bf6000  ! 8488: STDA_I	stda	%r17, [%r29 + 0x0000] %asi
	.word 0xe2d70e60  ! 8489: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r17
	.word 0xe2b7a000  ! 8490: STHA_I	stha	%r17, [%r30 + 0x0000] %asi
	mov	0x58, %r19
	mov	0x78, %r19
	.word 0xeca544a0  ! 8493: STWA_R	stwa	%r22, [%r21 + %r0] 0x25
	mov	0x48, %r19
	.word 0xeea7ce80  ! 8495: STWA_R	stwa	%r23, [%r31 + %r0] 0x74
	.word 0x87802073  ! 8496: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xec8609e0  ! 8497: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r22
	mov	0x0, %r24
	.word 0xec8f6000  ! 8499: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	.word 0xecafe000  ! 8500: STBA_I	stba	%r22, [%r31 + 0x0000] %asi
	.word 0xecaf2000  ! 8501: STBA_I	stba	%r22, [%r28 + 0x0000] %asi
	.word 0xeccfa000  ! 8502: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r22
	.word 0x87802073  ! 8503: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r17
	.word 0xeeacc400  ! 8505: STBA_R	stba	%r23, [%r19 + %r0] 0x20
	.word 0xe4a584a0  ! 8506: STWA_R	stwa	%r18, [%r22 + %r0] 0x25
	mov	0x30, %r27
	mov	0x3c0, %r21
	mov	0x60, %r24
	.word 0xe4dfe000  ! 8510: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r18
	.word 0x8780204f  ! 8511: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xecac4400  ! 8513: STBA_R	stba	%r22, [%r17 + %r0] 0x20
	.word 0xe0bcc400  ! 8514: STDA_R	stda	%r16, [%r19 + %r0] 0x20
	.word 0xe0aee000  ! 8515: STBA_I	stba	%r16, [%r27 + 0x0000] %asi
	.word 0xe8f4c400  ! 8516: STXA_R	stxa	%r20, [%r19 + %r0] 0x20
	mov	0x70, %r18
	.word 0xe4f44400  ! 8518: STXA_R	stxa	%r18, [%r17 + %r0] 0x20
	.word 0xeabe49e0  ! 8519: STDA_R	stda	%r21, [%r25 + %r0] 0x4f
	.word 0xe0af4e60  ! 8520: STBA_R	stba	%r16, [%r29 + %r0] 0x73
	.word 0xe0a6e000  ! 8521: STWA_I	stwa	%r16, [%r27 + 0x0000] %asi
	.word 0xe08e2000  ! 8522: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r16
	.word 0xe0b6a000  ! 8523: STHA_I	stha	%r16, [%r26 + 0x0000] %asi
	.word 0xe48cc400  ! 8524: LDUBA_R	lduba	[%r19, %r0] 0x20, %r18
	.word 0xe4ce2000  ! 8525: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r18
	.word 0xe4cee000  ! 8526: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r18
	.word 0xe0f70e80  ! 8527: STXA_R	stxa	%r16, [%r28 + %r0] 0x74
	.word 0xe0d6e000  ! 8528: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r16
	mov	0x0, %r25
	mov	0x50, %r19
	.word 0xe4f74e60  ! 8531: STXA_R	stxa	%r18, [%r29 + %r0] 0x73
	.word 0xe4d6e000  ! 8532: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r18
	.word 0x8780204f  ! 8533: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4d66000  ! 8534: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r18
	.word 0xeecfce60  ! 8535: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r23
	mov	0x7d0, %r21
	.word 0xee8e6000  ! 8537: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r23
	.word 0xee9e2000  ! 8538: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r23
	mov	0x20, %r19
	.word 0xe2974e40  ! 8540: LDUHA_R	lduha	[%r29, %r0] 0x72, %r17
	.word 0xe2ae6000  ! 8541: STBA_I	stba	%r17, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 8542: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_0_70:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe3, %g2
	or	%g4, 0x83, %g4
	or	%g6, 0xbb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 8544: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2a76000  ! 8545: STWA_I	stwa	%r17, [%r29 + 0x0000] %asi
	.word 0xe2d76000  ! 8546: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r17
	.word 0xe2b72000  ! 8547: STHA_I	stha	%r17, [%r28 + 0x0000] %asi
	.word 0xe2b76000  ! 8548: STHA_I	stha	%r17, [%r29 + 0x0000] %asi
	mov	0x18, %r19
	mov	0x3e8, %r20
	.word 0xeacf8e60  ! 8551: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r21
	.word 0xead72000  ! 8552: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r21
	.word 0xeaa7a000  ! 8553: STWA_I	stwa	%r21, [%r30 + 0x0000] %asi
	.word 0xe4c544a0  ! 8554: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r18
	.word 0xe49f6000  ! 8555: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r18
	.word 0xe4af2000  ! 8556: STBA_I	stba	%r18, [%r28 + 0x0000] %asi
	.word 0xe2ac4400  ! 8557: STBA_R	stba	%r17, [%r17 + %r0] 0x20
	.word 0xe2d7a000  ! 8558: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r17
	.word 0xee870e60  ! 8559: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r23
	.word 0xee9fe000  ! 8560: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r23
	mov	0x28, %r26
	.word 0xe8ce09e0  ! 8562: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r20
	mov	0x30, %r19
	.word 0xe08f0e80  ! 8564: LDUBA_R	lduba	[%r28, %r0] 0x74, %r16
	mov	0x48, %r16
	.word 0xe0bf6000  ! 8566: STDA_I	stda	%r16, [%r29 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xe0f7a000  ! 8568: STXA_I	stxa	%r16, [%r30 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xe0872000  ! 8570: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r16
	.word 0xe09f6000  ! 8571: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r16
	.word 0xec970e60  ! 8572: LDUHA_R	lduha	[%r28, %r0] 0x73, %r22
	.word 0xecf7e000  ! 8573: STXA_I	stxa	%r22, [%r31 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xe6bc8400  ! 8575: STDA_R	stda	%r19, [%r18 + %r0] 0x20
	.word 0xe8cf8e40  ! 8576: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r20
	.word 0x87802020  ! 8577: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 8578: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 8579: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r16
	mov	0x50, %r19
	.word 0xe2bc0400  ! 8582: STDA_R	stda	%r17, [%r16 + %r0] 0x20
	.word 0xe2a5e000  ! 8583: STWA_I	stwa	%r17, [%r23 + 0x0000] %asi
	.word 0xe2f6c9e0  ! 8584: STXA_R	stxa	%r17, [%r27 + %r0] 0x4f
	mov	0x58, %r17
	mov	0x40, %r16
	.word 0xe2ada000  ! 8587: STBA_I	stba	%r17, [%r22 + 0x0000] %asi
	.word 0xe6b48400  ! 8588: STHA_R	stha	%r19, [%r18 + %r0] 0x20
	.word 0x87802074  ! 8589: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 8590: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6872000  ! 8591: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r19
	mov	0x18, %r16
	.word 0xe6d7e000  ! 8593: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r19
	.word 0x87802020  ! 8594: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	.word 0x87802072  ! 8596: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 8597: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r20
	.word 0x87802025  ! 8599: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 8600: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6b4a000  ! 8601: STHA_I	stha	%r19, [%r18 + 0x0000] %asi
	.word 0xe69c4400  ! 8602: LDDA_R	ldda	[%r17, %r0] 0x20, %r19
	mov	0x30, %r17
	.word 0xeef544a0  ! 8604: STXA_R	stxa	%r23, [%r21 + %r0] 0x25
	mov	0x0, %r19
	mov	0x28, %r24
	mov	0x20, %r27
	mov	0x0, %r27
	.word 0xeeb4a000  ! 8609: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	.word 0xeedfce60  ! 8610: LDXA_R	ldxa	[%r31, %r0] 0x73, %r23
	.word 0xeebc2000  ! 8611: STDA_I	stda	%r23, [%r16 + 0x0000] %asi
	.word 0xe0b4c400  ! 8612: STHA_R	stha	%r16, [%r19 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0xe0c74e40  ! 8614: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r16
	.word 0xe0f42000  ! 8615: STXA_I	stxa	%r16, [%r16 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xe0dc2000  ! 8617: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r16
	.word 0x87802020  ! 8618: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8f78e40  ! 8619: STXA_R	stxa	%r20, [%r30 + %r0] 0x72
	mov	0x7d0, %r20
	.word 0xe4d4c400  ! 8621: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r18
	.word 0xe4dc6000  ! 8622: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r18
	.word 0x87802020  ! 8623: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea8649e0  ! 8624: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r21
	.word 0xe8a48400  ! 8625: STWA_R	stwa	%r20, [%r18 + %r0] 0x20
	.word 0xe4be49e0  ! 8626: STDA_R	stda	%r18, [%r25 + %r0] 0x4f
	.word 0xe2de09e0  ! 8627: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r17
	mov	0x38, %r19
	mov	0x7f8, %r23
	.word 0xe2b46000  ! 8630: STHA_I	stha	%r17, [%r17 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0xecdf0e40  ! 8632: LDXA_R	ldxa	[%r28, %r0] 0x72, %r22
	mov	0x30, %r18
	.word 0x8780204f  ! 8634: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c0, %r23
	mov	0x8, %r27
	mov	0x3c8, %r21
	.word 0xe6b78e80  ! 8638: STHA_R	stha	%r19, [%r30 + %r0] 0x74
	.word 0xe6cea000  ! 8639: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r19
	.word 0xea974e80  ! 8640: LDUHA_R	lduha	[%r29, %r0] 0x74, %r21
	.word 0xe6cd44a0  ! 8641: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r19
	.word 0xe2f7ce60  ! 8642: STXA_R	stxa	%r17, [%r31 + %r0] 0x73
	.word 0xe2d66000  ! 8643: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r17
	.word 0x87802072  ! 8644: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2a7e000  ! 8645: STWA_I	stwa	%r17, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 8646: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 8647: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xec874e60  ! 8648: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r22
	mov	0x68, %r25
	.word 0xeabd04a0  ! 8650: STDA_R	stda	%r21, [%r20 + %r0] 0x25
	.word 0xe4bf0e40  ! 8651: STDA_R	stda	%r18, [%r28 + %r0] 0x72
	.word 0xe2a70e80  ! 8652: STWA_R	stwa	%r17, [%r28 + %r0] 0x74
	.word 0x87802025  ! 8653: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802074  ! 8655: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe484c400  ! 8656: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r18
	mov	0x20, %r19
	mov	0x50, %r18
	mov	0x68, %r26
	.word 0xe4f7e000  ! 8660: STXA_I	stxa	%r18, [%r31 + 0x0000] %asi
	mov	0x28, %r18
	.word 0x87802072  ! 8662: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4bf6000  ! 8663: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xe4afe000  ! 8665: STBA_I	stba	%r18, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 8666: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r17
	.word 0xe4f4e000  ! 8668: STXA_I	stxa	%r18, [%r19 + 0x0000] %asi
	.word 0xeebdc4a0  ! 8669: STDA_R	stda	%r23, [%r23 + %r0] 0x25
	.word 0xeeb46000  ! 8670: STHA_I	stha	%r23, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 8671: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r20
	.word 0x87802073  ! 8673: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r27
	mov	0x30, %r26
	mov	0x3f0, %r23
	.word 0xe4df8e80  ! 8677: LDXA_R	ldxa	[%r30, %r0] 0x74, %r18
	.word 0x87802072  ! 8678: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4a76000  ! 8679: STWA_I	stwa	%r18, [%r29 + 0x0000] %asi
	mov	0x68, %r17
	mov	0x7e0, %r23
	.word 0xe4ccc400  ! 8682: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r18
	.word 0xe4976000  ! 8683: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r18
	mov	0x7d8, %r23
	.word 0x87802020  ! 8685: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r17
	.word 0xe4a46000  ! 8687: STWA_I	stwa	%r18, [%r17 + 0x0000] %asi
	.word 0xe4a46000  ! 8688: STWA_I	stwa	%r18, [%r17 + 0x0000] %asi
	.word 0xee8cc400  ! 8689: LDUBA_R	lduba	[%r19, %r0] 0x20, %r23
	.word 0x87802073  ! 8690: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2f44400  ! 8691: STXA_R	stxa	%r17, [%r17 + %r0] 0x20
	mov	0x3e0, %r21
	.word 0xe8df0e60  ! 8693: LDXA_R	ldxa	[%r28, %r0] 0x73, %r20
	.word 0xe8c6c9e0  ! 8694: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r20
	.word 0xe0f584a0  ! 8695: STXA_R	stxa	%r16, [%r22 + %r0] 0x25
	.word 0x87802074  ! 8696: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r17
	.word 0xe09fa000  ! 8698: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r16
	.word 0xe8c7ce60  ! 8699: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r20
	mov	0x70, %r26
	.word 0xe89fe000  ! 8701: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r20
	.word 0x87802074  ! 8702: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r24
	mov	0x7c8, %r23
	.word 0xea8f4e80  ! 8705: LDUBA_R	lduba	[%r29, %r0] 0x74, %r21
	.word 0xe2ac8400  ! 8706: STBA_R	stba	%r17, [%r18 + %r0] 0x20
	mov	0x40, %r26
	.word 0xecf40400  ! 8708: STXA_R	stxa	%r22, [%r16 + %r0] 0x20
	mov	0x10, %r19
	mov	0x10, %r27
	wr_tick_cmpr_0_71:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xdd, %g2
	or	%g4, 0x8d, %g4
	or	%g6, 0xd0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe68ec9e0  ! 8712: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r19
	.word 0xe69f2000  ! 8713: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r19
	mov	0x3f0, %r20
	.word 0xe6f7e000  ! 8715: STXA_I	stxa	%r19, [%r31 + 0x0000] %asi
	.word 0xe6876000  ! 8716: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r19
	mov	0x10, %r17
	.word 0xecdf4e80  ! 8718: LDXA_R	ldxa	[%r29, %r0] 0x74, %r22
	.word 0x87802020  ! 8719: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeccf8e40  ! 8720: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r22
	.word 0xe8b504a0  ! 8721: STHA_R	stha	%r20, [%r20 + %r0] 0x25
	.word 0x87802073  ! 8722: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 8723: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r22
	.word 0xe8d66000  ! 8725: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r20
	.word 0x87802020  ! 8726: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8b78e40  ! 8727: STHA_R	stha	%r20, [%r30 + %r0] 0x72
	.word 0xe88c2000  ! 8728: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r20
	.word 0xecb584a0  ! 8729: STHA_R	stha	%r22, [%r22 + %r0] 0x25
	mov	0x7e8, %r20
	.word 0x87802025  ! 8731: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeea7ce60  ! 8732: STWA_R	stwa	%r23, [%r31 + %r0] 0x73
	.word 0xe0cd04a0  ! 8733: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r16
	mov	0x3e8, %r23
	.word 0x87802072  ! 8735: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe89c4400  ! 8736: LDDA_R	ldda	[%r17, %r0] 0x20, %r20
	.word 0xe4f4c400  ! 8737: STXA_R	stxa	%r18, [%r19 + %r0] 0x20
	.word 0x87802020  ! 8738: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xee97ce40  ! 8739: LDUHA_R	lduha	[%r31, %r0] 0x72, %r23
	.word 0x87802020  ! 8740: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4de49e0  ! 8741: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r18
	mov	0x18, %r17
	.word 0x87802074  ! 8743: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 8744: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4b52000  ! 8745: STHA_I	stha	%r18, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 8746: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4f52000  ! 8747: STXA_I	stxa	%r18, [%r20 + 0x0000] %asi
	.word 0xe4ada000  ! 8748: STBA_I	stba	%r18, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 8749: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe49ce000  ! 8750: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r18
	.word 0xe6cf4e80  ! 8751: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r19
	.word 0x87802020  ! 8752: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r16
	mov	0x40, %r17
	.word 0xe6cc2000  ! 8755: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r19
	.word 0xe8ae89e0  ! 8756: STBA_R	stba	%r20, [%r26 + %r0] 0x4f
	.word 0xe4f74e80  ! 8757: STXA_R	stxa	%r18, [%r29 + %r0] 0x74
	.word 0xe49c2000  ! 8758: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r18
	.word 0x87802074  ! 8759: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r26
	.word 0xe497e000  ! 8761: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r18
	.word 0xe49fe000  ! 8762: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r18
	.word 0xe4a78e80  ! 8763: STWA_R	stwa	%r18, [%r30 + %r0] 0x74
	.word 0x87802025  ! 8764: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4ada000  ! 8765: STBA_I	stba	%r18, [%r22 + 0x0000] %asi
	.word 0xe4b5e000  ! 8766: STHA_I	stha	%r18, [%r23 + 0x0000] %asi
	.word 0xe4b40400  ! 8767: STHA_R	stha	%r18, [%r16 + %r0] 0x20
	.word 0x87802072  ! 8768: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 8769: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4af2000  ! 8770: STBA_I	stba	%r18, [%r28 + 0x0000] %asi
	.word 0xe0b74e80  ! 8771: STHA_R	stha	%r16, [%r29 + %r0] 0x74
	.word 0xe087a000  ! 8772: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r16
	.word 0x87802020  ! 8773: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 8774: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0f74e60  ! 8775: STXA_R	stxa	%r16, [%r29 + %r0] 0x73
	.word 0xee85c4a0  ! 8776: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r23
	mov	0x8, %r17
	.word 0xeea4a000  ! 8778: STWA_I	stwa	%r23, [%r18 + 0x0000] %asi
	.word 0xee946000  ! 8779: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r23
	.word 0xeecc6000  ! 8780: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r23
	.word 0xe4a689e0  ! 8781: STWA_R	stwa	%r18, [%r26 + %r0] 0x4f
	mov	0x3f0, %r22
	.word 0xe48c2000  ! 8783: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r18
	.word 0xe48ca000  ! 8784: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r18
	.word 0xe0dec9e0  ! 8785: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r16
	.word 0xe2974e80  ! 8786: LDUHA_R	lduha	[%r29, %r0] 0x74, %r17
	mov	0x60, %r26
	.word 0xe6de09e0  ! 8788: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r19
	.word 0xe69ce000  ! 8789: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r19
	.word 0xe4ad84a0  ! 8790: STBA_R	stba	%r18, [%r22 + %r0] 0x25
	mov	0x8, %r26
	.word 0xe4bc6000  ! 8792: STDA_I	stda	%r18, [%r17 + 0x0000] %asi
	.word 0xeabf8e60  ! 8793: STDA_R	stda	%r21, [%r30 + %r0] 0x73
	.word 0xeaace000  ! 8794: STBA_I	stba	%r21, [%r19 + 0x0000] %asi
	.word 0xeadc6000  ! 8795: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r21
	mov	0x60, %r17
	.word 0xeac46000  ! 8797: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r21
	.word 0xeed4c400  ! 8798: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r23
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802074  ! 8800: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r20
	mov	0x58, %r26
	mov	0x58, %r24
	.word 0xeed72000  ! 8804: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r23
	mov	0x7e0, %r23
	mov	0x7e8, %r20
	.word 0xeebfe000  ! 8807: STDA_I	stda	%r23, [%r31 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xe6dc8400  ! 8809: LDXA_R	ldxa	[%r18, %r0] 0x20, %r19
	.word 0xeabf0e80  ! 8810: STDA_R	stda	%r21, [%r28 + %r0] 0x74
	.word 0x87802025  ! 8811: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4840400  ! 8812: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r18
	.word 0xe4f56000  ! 8813: STXA_I	stxa	%r18, [%r21 + 0x0000] %asi
	.word 0xeeae49e0  ! 8814: STBA_R	stba	%r23, [%r25 + %r0] 0x4f
	.word 0xeeade000  ! 8815: STBA_I	stba	%r23, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 8816: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecd544a0  ! 8817: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r22
	.word 0xe6f44400  ! 8818: STXA_R	stxa	%r19, [%r17 + %r0] 0x20
	mov	0x10, %r26
	.word 0xe6bc2000  ! 8820: STDA_I	stda	%r19, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 8821: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0ccc400  ! 8822: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r16
	.word 0x87802072  ! 8823: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeca609e0  ! 8824: STWA_R	stwa	%r22, [%r24 + %r0] 0x4f
	.word 0xec8f6000  ! 8825: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	.word 0xec97a000  ! 8826: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r22
	.word 0x87802073  ! 8827: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe08c0400  ! 8828: LDUBA_R	lduba	[%r16, %r0] 0x20, %r16
	.word 0xe0d7a000  ! 8829: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r16
	.word 0xeca44400  ! 8830: STWA_R	stwa	%r22, [%r17 + %r0] 0x20
	.word 0xecc7e000  ! 8831: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r22
	.word 0xe6940400  ! 8832: LDUHA_R	lduha	[%r16, %r0] 0x20, %r19
	.word 0xe6f7a000  ! 8833: STXA_I	stxa	%r19, [%r30 + 0x0000] %asi
	.word 0xeebfce40  ! 8834: STDA_R	stda	%r23, [%r31 + %r0] 0x72
	.word 0xe8978e80  ! 8835: LDUHA_R	lduha	[%r30, %r0] 0x74, %r20
	.word 0x87802020  ! 8836: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe484c400  ! 8837: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r18
	.word 0xe2ad04a0  ! 8838: STBA_R	stba	%r17, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 8839: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2966000  ! 8840: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r17
	mov	0x7f8, %r21
	mov	0x28, %r16
	mov	0x68, %r26
	.word 0xe2b66000  ! 8844: STHA_I	stha	%r17, [%r25 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xe2862000  ! 8846: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r17
	.word 0xe296e000  ! 8847: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r17
	mov	0x50, %r18
	.word 0xe6d48400  ! 8849: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r19
	mov	0x38, %r18
	mov	0x48, %r25
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xeab609e0  ! 8853: STHA_R	stha	%r21, [%r24 + %r0] 0x4f
	.word 0xe49584a0  ! 8854: LDUHA_R	lduha	[%r22, %r0] 0x25, %r18
	.word 0xe4c649e0  ! 8855: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r18
	.word 0xe4d6a000  ! 8856: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r18
	mov	0x3d8, %r22
	.word 0x87802073  ! 8858: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 8859: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4bfa000  ! 8860: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	.word 0xecf70e40  ! 8861: STXA_R	stxa	%r22, [%r28 + %r0] 0x72
	.word 0x8780204f  ! 8862: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r18
	.word 0xecc62000  ! 8864: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r22
	.word 0xec9ea000  ! 8865: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r22
	.word 0xe2b584a0  ! 8866: STHA_R	stha	%r17, [%r22 + %r0] 0x25
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802074  ! 8868: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8ac4400  ! 8869: STBA_R	stba	%r20, [%r17 + %r0] 0x20
	.word 0x87802074  ! 8870: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8b649e0  ! 8871: STHA_R	stha	%r20, [%r25 + %r0] 0x4f
	.word 0xeac70e80  ! 8872: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r21
	mov	0x60, %r16
	mov	0x10, %r16
	.word 0xeaf76000  ! 8875: STXA_I	stxa	%r21, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 8876: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeace6000  ! 8877: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r21
	.word 0xeadee000  ! 8878: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r21
	mov	0x7f8, %r22
	.word 0x87802074  ! 8880: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 8881: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xea8cc400  ! 8882: LDUBA_R	lduba	[%r19, %r0] 0x20, %r21
	.word 0xeac7e000  ! 8883: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r21
	.word 0x8780204f  ! 8884: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0c5c4a0  ! 8885: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r16
	.word 0xe0aea000  ! 8886: STBA_I	stba	%r16, [%r26 + 0x0000] %asi
	mov	0x10, %r24
	mov	0x50, %r27
	.word 0xe0a6a000  ! 8889: STWA_I	stwa	%r16, [%r26 + 0x0000] %asi
	.word 0xe0b62000  ! 8890: STHA_I	stha	%r16, [%r24 + 0x0000] %asi
	.word 0xe0ae2000  ! 8891: STBA_I	stba	%r16, [%r24 + 0x0000] %asi
	.word 0xe0be6000  ! 8892: STDA_I	stda	%r16, [%r25 + 0x0000] %asi
	.word 0xe0a6a000  ! 8893: STWA_I	stwa	%r16, [%r26 + 0x0000] %asi
	mov	0x40, %r25
	mov	0x58, %r18
	.word 0xe4f74e80  ! 8896: STXA_R	stxa	%r18, [%r29 + %r0] 0x74
	.word 0xe6b4c400  ! 8897: STHA_R	stha	%r19, [%r19 + %r0] 0x20
	.word 0xe6bea000  ! 8898: STDA_I	stda	%r19, [%r26 + 0x0000] %asi
	mov	0x18, %r18
	mov	0x8, %r17
	mov	0x7c0, %r23
	.word 0xe487ce60  ! 8902: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r18
	mov	0x68, %r25
	.word 0xe48ea000  ! 8904: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r18
	.word 0xeea40400  ! 8905: STWA_R	stwa	%r23, [%r16 + %r0] 0x20
	mov	0x0, %r16
	.word 0xecd544a0  ! 8907: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r22
	.word 0x87802020  ! 8908: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r25
	.word 0xe0bc4400  ! 8910: STDA_R	stda	%r16, [%r17 + %r0] 0x20
	mov	0x3c8, %r21
	.word 0x87802074  ! 8912: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 8913: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r19
	.word 0xeabdc4a0  ! 8915: STDA_R	stda	%r21, [%r23 + %r0] 0x25
	.word 0x87802072  ! 8916: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r16
	.word 0xea97a000  ! 8918: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r21
	.word 0xe284c400  ! 8919: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r17
	.word 0xe2d76000  ! 8920: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r17
	.word 0xe2d7e000  ! 8921: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r17
	.word 0xe4ae09e0  ! 8922: STBA_R	stba	%r18, [%r24 + %r0] 0x4f
	.word 0xe48fe000  ! 8923: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r18
	.word 0x87802020  ! 8924: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8bc8400  ! 8925: STDA_R	stda	%r20, [%r18 + %r0] 0x20
	.word 0xe8cce000  ! 8926: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r20
	.word 0xe2b70e60  ! 8927: STHA_R	stha	%r17, [%r28 + %r0] 0x73
	mov	0x78, %r16
	.word 0x87802020  ! 8929: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecf689e0  ! 8930: STXA_R	stxa	%r22, [%r26 + %r0] 0x4f
	.word 0xecdca000  ! 8931: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r22
	.word 0xea9cc400  ! 8932: LDDA_R	ldda	[%r19, %r0] 0x20, %r21
	.word 0xe8878e80  ! 8933: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r20
	.word 0x87802025  ! 8934: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8d78e60  ! 8935: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r20
	.word 0xe8f5a000  ! 8936: STXA_I	stxa	%r20, [%r22 + 0x0000] %asi
	.word 0xe8d52000  ! 8937: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r20
	.word 0xe6f7ce40  ! 8938: STXA_R	stxa	%r19, [%r31 + %r0] 0x72
	.word 0x87802074  ! 8939: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r20
	mov	0x68, %r19
	.word 0xe6a44400  ! 8942: STWA_R	stwa	%r19, [%r17 + %r0] 0x20
	.word 0xe68fe000  ! 8943: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r19
	.word 0x87802072  ! 8944: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6f7e000  ! 8945: STXA_I	stxa	%r19, [%r31 + 0x0000] %asi
	.word 0xeedfce60  ! 8946: LDXA_R	ldxa	[%r31, %r0] 0x73, %r23
	mov	0x60, %r24
	ta	T_CHANGE_HPRIV	! macro
	.word 0xe0a44400  ! 8949: STWA_R	stwa	%r16, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 8950: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c0, %r20
	.word 0x87802020  ! 8952: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 8953: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0b7ce80  ! 8954: STHA_R	stha	%r16, [%r31 + %r0] 0x74
	.word 0xee9c0400  ! 8955: LDDA_R	ldda	[%r16, %r0] 0x20, %r23
	.word 0xe68c4400  ! 8956: LDUBA_R	lduba	[%r17, %r0] 0x20, %r19
	.word 0xe6d7e000  ! 8957: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r19
	mov	0x10, %r26
	.word 0xe0f44400  ! 8959: STXA_R	stxa	%r16, [%r17 + %r0] 0x20
	mov	0x18, %r25
	.word 0xeeb4c400  ! 8961: STHA_R	stha	%r23, [%r19 + %r0] 0x20
	.word 0x87802020  ! 8962: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	mov	0x7d8, %r20
	.word 0xe4bcc400  ! 8965: STDA_R	stda	%r18, [%r19 + %r0] 0x20
	.word 0xe494e000  ! 8966: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r18
	mov	0x3e0, %r22
	.word 0xe08e09e0  ! 8968: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r16
	.word 0xeec78e80  ! 8969: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r23
	mov	0x30, %r25
	.word 0xeeb46000  ! 8971: STHA_I	stha	%r23, [%r17 + 0x0000] %asi
	.word 0xeeb4a000  ! 8972: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	mov	0x60, %r16
	mov	0x20, %r17
	.word 0x87802072  ! 8975: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r21
	mov	0x70, %r26
	.word 0xe8bd04a0  ! 8978: STDA_R	stda	%r20, [%r20 + %r0] 0x25
	mov	0x3e0, %r21
	.word 0xe2c40400  ! 8980: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r17
	.word 0xec9f4e60  ! 8981: LDDA_R	ldda	[%r29, %r0] 0x73, %r22
	.word 0xe8df4e40  ! 8982: LDXA_R	ldxa	[%r29, %r0] 0x72, %r20
	.word 0x87802025  ! 8983: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 8984: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r25
	.word 0x87802025  ! 8986: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8a5e000  ! 8987: STWA_I	stwa	%r20, [%r23 + 0x0000] %asi
	.word 0xe8b56000  ! 8988: STHA_I	stha	%r20, [%r21 + 0x0000] %asi
	.word 0xe2f70e80  ! 8989: STXA_R	stxa	%r17, [%r28 + %r0] 0x74
	mov	0x58, %r16
	mov	0x7f0, %r20
	mov	0x28, %r18
	mov	0x30, %r17
	.word 0xe2b52000  ! 8994: STHA_I	stha	%r17, [%r20 + 0x0000] %asi
	.word 0xe2a5e000  ! 8995: STWA_I	stwa	%r17, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 8996: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 8997: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2bc6000  ! 8998: STDA_I	stda	%r17, [%r17 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0x87802073  ! 9000: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0bd84a0  ! 9001: STDA_R	stda	%r16, [%r22 + %r0] 0x25
	mov	0x30, %r24
	mov	0x78, %r26
	.word 0xe0bfa000  ! 9004: STDA_I	stda	%r16, [%r30 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xe09f2000  ! 9006: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r16
	mov	0x3f8, %r20
	mov	0x3f8, %r22
	.word 0xe0bf2000  ! 9009: STDA_I	stda	%r16, [%r28 + 0x0000] %asi
	.word 0xe4af0e40  ! 9010: STBA_R	stba	%r18, [%r28 + %r0] 0x72
	.word 0x87802025  ! 9011: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r18
	.word 0xe4a5a000  ! 9013: STWA_I	stwa	%r18, [%r22 + 0x0000] %asi
	.word 0xe49d2000  ! 9014: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r18
	.word 0xec8fce60  ! 9015: LDUBA_R	lduba	[%r31, %r0] 0x73, %r22
	.word 0x87802025  ! 9016: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecbd2000  ! 9017: STDA_I	stda	%r22, [%r20 + 0x0000] %asi
	.word 0xe2a44400  ! 9018: STWA_R	stwa	%r17, [%r17 + %r0] 0x20
	.word 0xe2d52000  ! 9019: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r17
	.word 0xe2bd6000  ! 9020: STDA_I	stda	%r17, [%r21 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xe6a6c9e0  ! 9022: STWA_R	stwa	%r19, [%r27 + %r0] 0x4f
	.word 0xeeac8400  ! 9023: STBA_R	stba	%r23, [%r18 + %r0] 0x20
	mov	0x3e8, %r22
	.word 0xeea52000  ! 9025: STWA_I	stwa	%r23, [%r20 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xee9de000  ! 9027: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r23
	.word 0xe0a78e60  ! 9028: STWA_R	stwa	%r16, [%r30 + %r0] 0x73
	.word 0xe4a609e0  ! 9029: STWA_R	stwa	%r18, [%r24 + %r0] 0x4f
	.word 0xe4a52000  ! 9030: STWA_I	stwa	%r18, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 9031: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xea840400  ! 9032: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r21
	.word 0x87802072  ! 9033: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeab689e0  ! 9034: STHA_R	stha	%r21, [%r26 + %r0] 0x4f
	.word 0xeab7e000  ! 9035: STHA_I	stha	%r21, [%r31 + 0x0000] %asi
	.word 0xeadf6000  ! 9036: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r21
	mov	0x50, %r16
	.word 0xea97e000  ! 9038: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r21
	.word 0xe0afce60  ! 9039: STBA_R	stba	%r16, [%r31 + %r0] 0x73
	.word 0xe0a504a0  ! 9040: STWA_R	stwa	%r16, [%r20 + %r0] 0x25
	.word 0xe087e000  ! 9041: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r16
	.word 0x87802020  ! 9042: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0b4a000  ! 9043: STHA_I	stha	%r16, [%r18 + 0x0000] %asi
	.word 0xeaf7ce40  ! 9044: STXA_R	stxa	%r21, [%r31 + %r0] 0x72
	.word 0xeec74e40  ! 9045: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r23
	.word 0xe6f74e60  ! 9046: STXA_R	stxa	%r19, [%r29 + %r0] 0x73
	.word 0xe68c2000  ! 9047: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r19
	.word 0xea87ce40  ! 9048: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r21
	.word 0x8780204f  ! 9049: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 9050: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8c649e0  ! 9051: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r20
	mov	0x38, %r24
	mov	0x7d0, %r20
	mov	0x38, %r18
	.word 0xe8afa000  ! 9055: STBA_I	stba	%r20, [%r30 + 0x0000] %asi
	.word 0xec9f8e60  ! 9056: LDDA_R	ldda	[%r30, %r0] 0x73, %r22
	mov	0x7f8, %r21
	mov	0x0, %r25
	mov	0x20, %r25
	.word 0xecafe000  ! 9060: STBA_I	stba	%r22, [%r31 + 0x0000] %asi
	.word 0xecc7a000  ! 9061: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r22
	mov	0x28, %r24
	mov	0x3d8, %r22
	.word 0xe68609e0  ! 9064: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r19
	.word 0xe68fe000  ! 9065: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r19
	mov	0x20, %r16
	.word 0xe0d7ce80  ! 9067: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r16
	.word 0xe0a72000  ! 9068: STWA_I	stwa	%r16, [%r28 + 0x0000] %asi
	.word 0xe08fe000  ! 9069: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r16
	.word 0xecbe89e0  ! 9070: STDA_R	stda	%r22, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 9071: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 9072: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r18
	.word 0xecd42000  ! 9074: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r22
	mov	0x18, %r16
	mov	0x7e8, %r23
	.word 0xecdca000  ! 9077: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r22
	.word 0xe8cd84a0  ! 9078: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r20
	.word 0xe2ae09e0  ! 9079: STBA_R	stba	%r17, [%r24 + %r0] 0x4f
	.word 0xe28c2000  ! 9080: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r17
	.word 0x8780204f  ! 9081: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 9083: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r26
	.word 0xe2ac2000  ! 9085: STBA_I	stba	%r17, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 9086: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 9087: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe09f4e80  ! 9088: LDDA_R	ldda	[%r29, %r0] 0x74, %r16
	.word 0xe08de000  ! 9089: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r16
	.word 0xe8bf8e40  ! 9090: STDA_R	stda	%r20, [%r30 + %r0] 0x72
	.word 0xe8dde000  ! 9091: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r20
	.word 0x87802074  ! 9092: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r18
	.word 0xeaa44400  ! 9094: STWA_R	stwa	%r21, [%r17 + %r0] 0x20
	.word 0x87802025  ! 9095: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6844400  ! 9096: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r19
	.word 0xe6aec9e0  ! 9097: STBA_R	stba	%r19, [%r27 + %r0] 0x4f
	mov	0x40, %r19
	ta	T_CHANGE_HPRIV	! macro
	.word 0xe6b5a000  ! 9100: STHA_I	stha	%r19, [%r22 + 0x0000] %asi
	.word 0xe69d2000  ! 9101: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r19
	mov	0x28, %r26
	.word 0x87802072  ! 9103: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r24
	.word 0xec8c4400  ! 9105: LDUBA_R	lduba	[%r17, %r0] 0x20, %r22
	.word 0xeccfa000  ! 9106: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r22
	wr_tick_cmpr_0_72:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x80, %g2
	or	%g4, 0xfe, %g4
	or	%g6, 0xde, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 9108: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6a74e40  ! 9109: STWA_R	stwa	%r19, [%r29 + %r0] 0x72
	.word 0xe6afa000  ! 9110: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	.word 0xe2a544a0  ! 9111: STWA_R	stwa	%r17, [%r21 + %r0] 0x25
	.word 0xe28fa000  ! 9112: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r17
	.word 0xec8fce40  ! 9113: LDUBA_R	lduba	[%r31, %r0] 0x72, %r22
	.word 0xecdfa000  ! 9114: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r22
	.word 0xe0974e40  ! 9115: LDUHA_R	lduha	[%r29, %r0] 0x72, %r16
	.word 0xe09fa000  ! 9116: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r16
	.word 0xe0a7a000  ! 9117: STWA_I	stwa	%r16, [%r30 + 0x0000] %asi
	.word 0xe6944400  ! 9118: LDUHA_R	lduha	[%r17, %r0] 0x20, %r19
	.word 0xe4bcc400  ! 9119: STDA_R	stda	%r18, [%r19 + %r0] 0x20
	.word 0xe48f2000  ! 9120: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r18
	.word 0xe4dfe000  ! 9121: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r18
	.word 0x87802025  ! 9122: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecf609e0  ! 9123: STXA_R	stxa	%r22, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 9124: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeccda000  ! 9125: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r22
	.word 0xe0d609e0  ! 9126: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r16
	mov	0x3c8, %r20
	.word 0x87802074  ! 9128: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0bf2000  ! 9129: STDA_I	stda	%r16, [%r28 + 0x0000] %asi
	.word 0xee9649e0  ! 9130: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r23
	.word 0xee976000  ! 9131: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r23
	.word 0xe4af0e80  ! 9132: STBA_R	stba	%r18, [%r28 + %r0] 0x74
	mov	0x78, %r27
	wr_tick_cmpr_0_73:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa8, %g2
	or	%g4, 0xe7, %g4
	or	%g6, 0xa3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 9136: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeebf0e40  ! 9137: STDA_R	stda	%r23, [%r28 + %r0] 0x72
	.word 0x87802074  ! 9138: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r23
	.word 0xe0be49e0  ! 9140: STDA_R	stda	%r16, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 9141: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0bf2000  ! 9142: STDA_I	stda	%r16, [%r28 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xe0bf2000  ! 9144: STDA_I	stda	%r16, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 9145: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r27
	mov	0x7c8, %r21
	mov	0x78, %r25
	.word 0xe086e000  ! 9149: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r16
	.word 0xe08ee000  ! 9150: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r16
	.word 0xe2b4c400  ! 9151: STHA_R	stha	%r17, [%r19 + %r0] 0x20
	.word 0xe6acc400  ! 9152: STBA_R	stba	%r19, [%r19 + %r0] 0x20
	mov	0x48, %r27
	.word 0xe686a000  ! 9154: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r19
	.word 0x8780204f  ! 9155: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xee9c4400  ! 9156: LDDA_R	ldda	[%r17, %r0] 0x20, %r23
	.word 0xe8b584a0  ! 9157: STHA_R	stha	%r20, [%r22 + %r0] 0x25
	mov	0x40, %r18
	.word 0x8780204f  ! 9159: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8c62000  ! 9160: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r20
	.word 0xe8866000  ! 9161: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r20
	.word 0xe8c6e000  ! 9162: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r20
	.word 0x87802074  ! 9163: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r23
	.word 0xe29584a0  ! 9165: LDUHA_R	lduha	[%r22, %r0] 0x25, %r17
	.word 0x87802074  ! 9166: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r27
	.word 0xe0d48400  ! 9168: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r16
	mov	0x0, %r26
	.word 0xe0d72000  ! 9170: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r16
	.word 0xe0b7a000  ! 9171: STHA_I	stha	%r16, [%r30 + 0x0000] %asi
	.word 0xe0dfce80  ! 9172: LDXA_R	ldxa	[%r31, %r0] 0x74, %r16
	.word 0xe0f72000  ! 9173: STXA_I	stxa	%r16, [%r28 + 0x0000] %asi
	.word 0xe4ac4400  ! 9174: STBA_R	stba	%r18, [%r17 + %r0] 0x20
	.word 0xe4b72000  ! 9175: STHA_I	stha	%r18, [%r28 + 0x0000] %asi
	mov	0x0, %r18
	.word 0x87802074  ! 9177: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4c7e000  ! 9178: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r18
	mov	0x28, %r16
	.word 0xec87ce80  ! 9180: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r22
	.word 0xe6f689e0  ! 9181: STXA_R	stxa	%r19, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 9182: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeec70e60  ! 9183: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r23
	.word 0x87802073  ! 9184: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeea76000  ! 9185: STWA_I	stwa	%r23, [%r29 + 0x0000] %asi
	.word 0xeeaf2000  ! 9186: STBA_I	stba	%r23, [%r28 + 0x0000] %asi
	mov	0x28, %r26
	.word 0x87802025  ! 9188: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0af4e40  ! 9189: STBA_R	stba	%r16, [%r29 + %r0] 0x72
	.word 0xe0b52000  ! 9190: STHA_I	stha	%r16, [%r20 + 0x0000] %asi
	.word 0xecb48400  ! 9191: STHA_R	stha	%r22, [%r18 + %r0] 0x20
	.word 0xe0f4c400  ! 9192: STXA_R	stxa	%r16, [%r19 + %r0] 0x20
	.word 0xe0ad2000  ! 9193: STBA_I	stba	%r16, [%r20 + 0x0000] %asi
	.word 0xe09d2000  ! 9194: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r16
	.word 0xe487ce40  ! 9195: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r18
	mov	0x8, %r27
	.word 0xe4c52000  ! 9197: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r18
	.word 0xe4f52000  ! 9198: STXA_I	stxa	%r18, [%r20 + 0x0000] %asi
	.word 0xe4f4c400  ! 9199: STXA_R	stxa	%r18, [%r19 + %r0] 0x20
	.word 0x87802073  ! 9200: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2f40400  ! 9201: STXA_R	stxa	%r17, [%r16 + %r0] 0x20
	.word 0xe2afa000  ! 9202: STBA_I	stba	%r17, [%r30 + 0x0000] %asi
	mov	0x20, %r16
	mov	0x7d0, %r20
	.word 0xe4d74e40  ! 9205: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r18
	mov	0x20, %r19
	mov	0x3d0, %r21
	.word 0xe4df2000  ! 9208: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r18
	.word 0xe0b48400  ! 9209: STHA_R	stha	%r16, [%r18 + %r0] 0x20
	mov	0x60, %r19
	mov	0x7d0, %r21
	mov	0x38, %r19
	.word 0xe6b78e40  ! 9213: STHA_R	stha	%r19, [%r30 + %r0] 0x72
	.word 0xecb74e80  ! 9214: STHA_R	stha	%r22, [%r29 + %r0] 0x74
	.word 0xecc7e000  ! 9215: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r22
	.word 0xec9f8e80  ! 9216: LDDA_R	ldda	[%r30, %r0] 0x74, %r22
	mov	0x3d8, %r20
	mov	0x7d8, %r22
	mov	0x7f0, %r21
	mov	0x7f8, %r21
	mov	0x70, %r24
	.word 0xe0bd44a0  ! 9222: STDA_R	stda	%r16, [%r21 + %r0] 0x25
	.word 0xe0afa000  ! 9223: STBA_I	stba	%r16, [%r30 + 0x0000] %asi
	.word 0xeaf649e0  ! 9224: STXA_R	stxa	%r21, [%r25 + %r0] 0x4f
	.word 0xeaf72000  ! 9225: STXA_I	stxa	%r21, [%r28 + 0x0000] %asi
	.word 0xecd4c400  ! 9226: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r22
	.word 0xecf72000  ! 9227: STXA_I	stxa	%r22, [%r28 + 0x0000] %asi
	.word 0xe2ae09e0  ! 9228: STBA_R	stba	%r17, [%r24 + %r0] 0x4f
	.word 0xe2cfa000  ! 9229: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r17
	.word 0xe2a72000  ! 9230: STWA_I	stwa	%r17, [%r28 + 0x0000] %asi
	.word 0xe0b78e60  ! 9231: STHA_R	stha	%r16, [%r30 + %r0] 0x73
	.word 0x87802020  ! 9232: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 9233: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r17
	.word 0xe0b4a000  ! 9235: STHA_I	stha	%r16, [%r18 + 0x0000] %asi
	mov	0x38, %r24
	.word 0x87802020  ! 9237: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0846000  ! 9238: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r16
	.word 0xe6bf8e80  ! 9239: STDA_R	stda	%r19, [%r30 + %r0] 0x74
	mov	0x78, %r27
	mov	0x20, %r25
	.word 0xe6ac6000  ! 9242: STBA_I	stba	%r19, [%r17 + 0x0000] %asi
	.word 0xe6946000  ! 9243: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r19
	mov	0x70, %r24
	mov	0x7c8, %r23
	.word 0xe2af8e40  ! 9246: STBA_R	stba	%r17, [%r30 + %r0] 0x72
	.word 0xe2bca000  ! 9247: STDA_I	stda	%r17, [%r18 + 0x0000] %asi
	.word 0xe6d48400  ! 9248: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r19
	.word 0xe6f46000  ! 9249: STXA_I	stxa	%r19, [%r17 + 0x0000] %asi
	.word 0xe2a78e80  ! 9250: STWA_R	stwa	%r17, [%r30 + %r0] 0x74
	.word 0xe2b46000  ! 9251: STHA_I	stha	%r17, [%r17 + 0x0000] %asi
	mov	0x58, %r25
	ta	T_CHANGE_PRIV	! macro
	.word 0xe8a74e80  ! 9254: STWA_R	stwa	%r20, [%r29 + %r0] 0x74
	mov	0x20, %r27
	.word 0xe8b4e000  ! 9256: STHA_I	stha	%r20, [%r19 + 0x0000] %asi
	.word 0xe8bc2000  ! 9257: STDA_I	stda	%r20, [%r16 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xeede49e0  ! 9259: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r23
	mov	0x48, %r18
	.word 0xe8f70e40  ! 9261: STXA_R	stxa	%r20, [%r28 + %r0] 0x72
	.word 0xe0be09e0  ! 9262: STDA_R	stda	%r16, [%r24 + %r0] 0x4f
	.word 0xe0c46000  ! 9263: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r16
	.word 0x87802020  ! 9264: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe2840400  ! 9266: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r17
	.word 0xee84c400  ! 9267: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r23
	.word 0xeebce000  ! 9268: STDA_I	stda	%r23, [%r19 + 0x0000] %asi
	.word 0xee8c6000  ! 9269: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r23
	mov	0x48, %r24
	.word 0xee8c6000  ! 9271: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r23
	.word 0xeeaca000  ! 9272: STBA_I	stba	%r23, [%r18 + 0x0000] %asi
	mov	0x70, %r19
	.word 0xeebce000  ! 9274: STDA_I	stda	%r23, [%r19 + 0x0000] %asi
	.word 0xeef504a0  ! 9275: STXA_R	stxa	%r23, [%r20 + %r0] 0x25
	.word 0x87802073  ! 9276: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xee9f6000  ! 9277: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r23
	mov	0x60, %r17
	.word 0xecaf8e80  ! 9279: STBA_R	stba	%r22, [%r30 + %r0] 0x74
	wr_tick_cmpr_0_74:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa3, %g2
	or	%g4, 0xd6, %g4
	or	%g6, 0xfe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe48504a0  ! 9281: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r18
	.word 0xe4c7e000  ! 9282: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r18
	.word 0xecbc8400  ! 9283: STDA_R	stda	%r22, [%r18 + %r0] 0x20
	mov	0x28, %r27
	.word 0xe4c78e60  ! 9285: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r18
	mov	0x40, %r18
	.word 0xe48f2000  ! 9287: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r18
	.word 0xe4a72000  ! 9288: STWA_I	stwa	%r18, [%r28 + 0x0000] %asi
	.word 0xe49fa000  ! 9289: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r18
	.word 0xe0b689e0  ! 9290: STHA_R	stha	%r16, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 9291: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0cc0400  ! 9292: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r16
	.word 0xe0dfa000  ! 9293: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r16
	wr_tick_cmpr_0_75:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x98, %g2
	or	%g4, 0x83, %g4
	or	%g6, 0xdb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x58, %r19
	.word 0xec94c400  ! 9296: LDUHA_R	lduha	[%r19, %r0] 0x20, %r22
	mov	0x28, %r26
	.word 0xecaf6000  ! 9298: STBA_I	stba	%r22, [%r29 + 0x0000] %asi
	.word 0xead649e0  ! 9299: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r21
	.word 0xe69584a0  ! 9300: LDUHA_R	lduha	[%r22, %r0] 0x25, %r19
	.word 0xeace89e0  ! 9301: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r21
	.word 0xeaa7e000  ! 9302: STWA_I	stwa	%r21, [%r31 + 0x0000] %asi
	.word 0xeab7a000  ! 9303: STHA_I	stha	%r21, [%r30 + 0x0000] %asi
	mov	0x10, %r19
	.word 0x87802020  ! 9305: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xead46000  ! 9306: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r21
	.word 0xea9c2000  ! 9307: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r21
	mov	0x70, %r24
	.word 0x87802020  ! 9309: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea842000  ! 9310: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r21
	.word 0x8780204f  ! 9311: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeaa62000  ! 9312: STWA_I	stwa	%r21, [%r24 + 0x0000] %asi
	.word 0xeacee000  ! 9313: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r21
	.word 0x87802072  ! 9314: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 9315: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a44400  ! 9316: STWA_R	stwa	%r16, [%r17 + %r0] 0x20
	.word 0xe4ad04a0  ! 9317: STBA_R	stba	%r18, [%r20 + %r0] 0x25
	.word 0xe2af0e80  ! 9318: STBA_R	stba	%r17, [%r28 + %r0] 0x74
	.word 0xe2cfce60  ! 9319: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r17
	.word 0xe2d46000  ! 9320: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r17
	.word 0xe294a000  ! 9321: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r17
	.word 0xe2bc2000  ! 9322: STDA_I	stda	%r17, [%r16 + 0x0000] %asi
	wr_tick_cmpr_0_76:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb1, %g2
	or	%g4, 0x9b, %g4
	or	%g6, 0x8c, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe2a4e000  ! 9324: STWA_I	stwa	%r17, [%r19 + 0x0000] %asi
	mov	0x18, %r16
	.word 0x87802073  ! 9326: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 9327: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecbf8e80  ! 9328: STDA_R	stda	%r22, [%r30 + %r0] 0x74
	.word 0x87802074  ! 9329: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r22
	.word 0xeab609e0  ! 9331: STHA_R	stha	%r21, [%r24 + %r0] 0x4f
	.word 0xe89584a0  ! 9332: LDUHA_R	lduha	[%r22, %r0] 0x25, %r20
	mov	0x10, %r16
	.word 0xe88fa000  ! 9334: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r20
	.word 0xe8872000  ! 9335: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r20
	.word 0xecc584a0  ! 9336: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r22
	.word 0xecd76000  ! 9337: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r22
	.word 0xe2c7ce60  ! 9338: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r17
	.word 0xec8fce60  ! 9339: LDUBA_R	lduba	[%r31, %r0] 0x73, %r22
	.word 0xec976000  ! 9340: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r22
	.word 0xec9fe000  ! 9341: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r22
	.word 0x8780204f  ! 9342: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r27
	.word 0xeeafce40  ! 9344: STBA_R	stba	%r23, [%r31 + %r0] 0x72
	.word 0xeec6a000  ! 9345: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r23
	.word 0x87802072  ! 9346: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeed7a000  ! 9347: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r23
	.word 0xee8f6000  ! 9348: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r23
	.word 0xe4ce09e0  ! 9349: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r18
	.word 0xe4876000  ! 9350: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r18
	mov	0x8, %r17
	.word 0xe4a7a000  ! 9352: STWA_I	stwa	%r18, [%r30 + 0x0000] %asi
	.word 0xe4dc8400  ! 9353: LDXA_R	ldxa	[%r18, %r0] 0x20, %r18
	.word 0x87802025  ! 9354: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4cd2000  ! 9355: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r18
	mov	0x3d0, %r22
	wr_tick_cmpr_0_77:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf0, %g2
	or	%g4, 0xfa, %g4
	or	%g6, 0xfb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802025  ! 9358: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe09c0400  ! 9359: LDDA_R	ldda	[%r16, %r0] 0x20, %r16
	.word 0xec95c4a0  ! 9360: LDUHA_R	lduha	[%r23, %r0] 0x25, %r22
	.word 0xeca5a000  ! 9361: STWA_I	stwa	%r22, [%r22 + 0x0000] %asi
	.word 0xee9cc400  ! 9362: LDDA_R	ldda	[%r19, %r0] 0x20, %r23
	mov	0x3f8, %r22
	.word 0x87802073  ! 9364: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea874e40  ! 9365: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r21
	.word 0xeaaf6000  ! 9366: STBA_I	stba	%r21, [%r29 + 0x0000] %asi
	wr_tick_cmpr_0_78:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb7, %g2
	or	%g4, 0xc0, %g4
	or	%g6, 0xcc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeaf7a000  ! 9368: STXA_I	stxa	%r21, [%r30 + 0x0000] %asi
	.word 0xe8df4e40  ! 9369: LDXA_R	ldxa	[%r29, %r0] 0x72, %r20
	.word 0xecb74e40  ! 9370: STHA_R	stha	%r22, [%r29 + %r0] 0x72
	.word 0x87802072  ! 9371: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 9372: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeebe89e0  ! 9373: STDA_R	stda	%r23, [%r26 + %r0] 0x4f
	.word 0xeea42000  ! 9374: STWA_I	stwa	%r23, [%r16 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xec878e40  ! 9376: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r22
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 9378: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecbc6000  ! 9379: STDA_I	stda	%r22, [%r17 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xe49fce80  ! 9381: LDDA_R	ldda	[%r31, %r0] 0x74, %r18
	mov	0x3e0, %r22
	.word 0xe29f4e80  ! 9383: LDDA_R	ldda	[%r29, %r0] 0x74, %r17
	mov	0x7d8, %r21
	.word 0xe0878e60  ! 9385: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r16
	.word 0x87802020  ! 9386: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2b70e60  ! 9387: STHA_R	stha	%r17, [%r28 + %r0] 0x73
	.word 0xe2f4e000  ! 9388: STXA_I	stxa	%r17, [%r19 + 0x0000] %asi
	mov	0x38, %r25
	mov	0x7f8, %r23
	.word 0x87802020  ! 9391: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 9392: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 9393: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 9394: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2bf6000  ! 9395: STDA_I	stda	%r17, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 9396: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeadc0400  ! 9397: LDXA_R	ldxa	[%r16, %r0] 0x20, %r21
	.word 0xe696c9e0  ! 9398: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r19
	.word 0x87802025  ! 9399: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe685a000  ! 9400: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r19
	.word 0xe2bf0e80  ! 9401: STDA_R	stda	%r17, [%r28 + %r0] 0x74
	.word 0xec9c8400  ! 9402: LDDA_R	ldda	[%r18, %r0] 0x20, %r22
	.word 0x8780204f  ! 9403: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4ad04a0  ! 9404: STBA_R	stba	%r18, [%r20 + %r0] 0x25
	.word 0xeef7ce40  ! 9405: STXA_R	stxa	%r23, [%r31 + %r0] 0x72
	.word 0xeea6a000  ! 9406: STWA_I	stwa	%r23, [%r26 + 0x0000] %asi
	.word 0xe0c70e60  ! 9407: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r16
	mov	0x50, %r18
	.word 0xeca70e80  ! 9409: STWA_R	stwa	%r22, [%r28 + %r0] 0x74
	.word 0xecafce40  ! 9410: STBA_R	stba	%r22, [%r31 + %r0] 0x72
	.word 0xe8848400  ! 9411: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r20
	.word 0xe886e000  ! 9412: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r20
	mov	0x7f0, %r22
	.word 0xe0cd04a0  ! 9414: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r16
	.word 0xe0be2000  ! 9415: STDA_I	stda	%r16, [%r24 + 0x0000] %asi
	.word 0xe0bea000  ! 9416: STDA_I	stda	%r16, [%r26 + 0x0000] %asi
	.word 0xe0a78e40  ! 9417: STWA_R	stwa	%r16, [%r30 + %r0] 0x72
	.word 0x87802025  ! 9418: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 9419: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0c6a000  ! 9420: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r16
	.word 0xe2f44400  ! 9421: STXA_R	stxa	%r17, [%r17 + %r0] 0x20
	mov	0x38, %r16
	.word 0x8780204f  ! 9423: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0dc8400  ! 9424: LDXA_R	ldxa	[%r18, %r0] 0x20, %r16
	.word 0xe8cdc4a0  ! 9425: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r20
	.word 0xe8be6000  ! 9426: STDA_I	stda	%r20, [%r25 + 0x0000] %asi
	.word 0xe0ddc4a0  ! 9427: LDXA_R	ldxa	[%r23, %r0] 0x25, %r16
	.word 0xe0dee000  ! 9428: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r16
	.word 0xe0bea000  ! 9429: STDA_I	stda	%r16, [%r26 + 0x0000] %asi
	.word 0xe0d6a000  ! 9430: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r16
	.word 0xe0af0e80  ! 9431: STBA_R	stba	%r16, [%r28 + %r0] 0x74
	.word 0xe0b6a000  ! 9432: STHA_I	stha	%r16, [%r26 + 0x0000] %asi
	.word 0xe4af0e40  ! 9433: STBA_R	stba	%r18, [%r28 + %r0] 0x72
	.word 0xecb78e80  ! 9434: STHA_R	stha	%r22, [%r30 + %r0] 0x74
	mov	0x48, %r26
	.word 0x87802074  ! 9436: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r27
	mov	0x0, %r17
	.word 0x8780204f  ! 9439: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8940400  ! 9440: LDUHA_R	lduha	[%r16, %r0] 0x20, %r20
	mov	0x7f8, %r23
	mov	0x8, %r18
	.word 0xe8c66000  ! 9443: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r20
	.word 0x8780204f  ! 9444: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8840400  ! 9445: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r20
	.word 0xe8a6a000  ! 9446: STWA_I	stwa	%r20, [%r26 + 0x0000] %asi
	.word 0xe8c6c9e0  ! 9447: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r20
	.word 0xecbd04a0  ! 9448: STDA_R	stda	%r22, [%r20 + %r0] 0x25
	.word 0xee8fce80  ! 9449: LDUBA_R	lduba	[%r31, %r0] 0x74, %r23
	.word 0xe6840400  ! 9450: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r19
	.word 0xeaafce80  ! 9451: STBA_R	stba	%r21, [%r31 + %r0] 0x74
	.word 0xe887ce80  ! 9452: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r20
	.word 0xe8bee000  ! 9453: STDA_I	stda	%r20, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 9454: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8df6000  ! 9455: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r20
	mov	0x7d8, %r21
	.word 0xe88fa000  ! 9457: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r20
	.word 0xe8c7a000  ! 9458: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r20
	mov	0x3f0, %r21
	mov	0x48, %r25
	.word 0xea9c0400  ! 9461: LDDA_R	ldda	[%r16, %r0] 0x20, %r21
	.word 0x87802020  ! 9462: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeeac8400  ! 9463: STBA_R	stba	%r23, [%r18 + %r0] 0x20
	mov	0x3d8, %r23
	.word 0xe4df8e40  ! 9465: LDXA_R	ldxa	[%r30, %r0] 0x72, %r18
	.word 0xe2f649e0  ! 9466: STXA_R	stxa	%r17, [%r25 + %r0] 0x4f
	.word 0xeadfce40  ! 9467: LDXA_R	ldxa	[%r31, %r0] 0x72, %r21
	.word 0xeab4e000  ! 9468: STHA_I	stha	%r21, [%r19 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xeaa609e0  ! 9470: STWA_R	stwa	%r21, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 9471: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaf46000  ! 9472: STXA_I	stxa	%r21, [%r17 + 0x0000] %asi
	.word 0xe2bf8e80  ! 9473: STDA_R	stda	%r17, [%r30 + %r0] 0x74
	mov	0x48, %r26
	.word 0xe2f42000  ! 9475: STXA_I	stxa	%r17, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 9476: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 9477: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xecaf4e80  ! 9478: STBA_R	stba	%r22, [%r29 + %r0] 0x74
	.word 0xeab7ce60  ! 9479: STHA_R	stha	%r21, [%r31 + %r0] 0x73
	.word 0xeaf40400  ! 9480: STXA_R	stxa	%r21, [%r16 + %r0] 0x20
	.word 0xee944400  ! 9481: LDUHA_R	lduha	[%r17, %r0] 0x20, %r23
	.word 0xeaad04a0  ! 9482: STBA_R	stba	%r21, [%r20 + %r0] 0x25
	.word 0xeadf2000  ! 9483: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r21
	.word 0x87802074  ! 9484: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8a78e40  ! 9485: STWA_R	stwa	%r20, [%r30 + %r0] 0x72
	.word 0xe0f44400  ! 9486: STXA_R	stxa	%r16, [%r17 + %r0] 0x20
	.word 0xe0bf6000  ! 9487: STDA_I	stda	%r16, [%r29 + 0x0000] %asi
	.word 0xe0cf6000  ! 9488: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r16
	.word 0xe09f2000  ! 9489: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r16
	.word 0xe8c609e0  ! 9490: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r20
	.word 0xe08609e0  ! 9491: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r16
	.word 0xe0afe000  ! 9492: STBA_I	stba	%r16, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 9493: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r16
	.word 0xeea78e60  ! 9495: STWA_R	stwa	%r23, [%r30 + %r0] 0x73
	.word 0x87802073  ! 9496: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6b544a0  ! 9497: STHA_R	stha	%r19, [%r21 + %r0] 0x25
	mov	0x30, %r17
	ta	T_CHANGE_PRIV	! macro
	mov	0x40, %r26
	.word 0xe6d72000  ! 9501: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r19
	mov	0x68, %r24
	mov	0x7d8, %r21
	.word 0xee9cc400  ! 9504: LDDA_R	ldda	[%r19, %r0] 0x20, %r23
	.word 0xee87a000  ! 9505: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r23
	mov	0x3e8, %r23
	.word 0xe487ce60  ! 9507: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r18
	.word 0xe487e000  ! 9508: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r18
	.word 0x87802073  ! 9509: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 9510: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r16
	.word 0xe4bfa000  ! 9512: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	.word 0xe4874e60  ! 9513: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r18
	.word 0xe4872000  ! 9514: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r18
	.word 0xe4bf6000  ! 9515: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	.word 0xe4cd44a0  ! 9516: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r18
	.word 0x87802020  ! 9517: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe494e000  ! 9518: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r18
	.word 0xeebf8e40  ! 9519: STDA_R	stda	%r23, [%r30 + %r0] 0x72
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xeeac2000  ! 9521: STBA_I	stba	%r23, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 9522: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeebfa000  ! 9523: STDA_I	stda	%r23, [%r30 + 0x0000] %asi
	mov	0x8, %r16
	.word 0xe0a4c400  ! 9525: STWA_R	stwa	%r16, [%r19 + %r0] 0x20
	.word 0xecb44400  ! 9526: STHA_R	stha	%r22, [%r17 + %r0] 0x20
	.word 0xecc7e000  ! 9527: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r22
	.word 0xecf70e80  ! 9528: STXA_R	stxa	%r22, [%r28 + %r0] 0x74
	.word 0xe2ac4400  ! 9529: STBA_R	stba	%r17, [%r17 + %r0] 0x20
	.word 0xe2af6000  ! 9530: STBA_I	stba	%r17, [%r29 + 0x0000] %asi
	.word 0xe287e000  ! 9531: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r17
	.word 0x87802072  ! 9532: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2dfe000  ! 9533: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r17
	.word 0x87802025  ! 9534: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 9535: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 9536: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 9537: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 9538: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2a46000  ! 9539: STWA_I	stwa	%r17, [%r17 + 0x0000] %asi
	.word 0xe2b4e000  ! 9540: STHA_I	stha	%r17, [%r19 + 0x0000] %asi
	.word 0xe8f44400  ! 9541: STXA_R	stxa	%r20, [%r17 + %r0] 0x20
	.word 0xe0870e60  ! 9542: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r16
	.word 0xe0a4c400  ! 9543: STWA_R	stwa	%r16, [%r19 + %r0] 0x20
	mov	0x50, %r24
	.word 0x87802020  ! 9545: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0c46000  ! 9546: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r16
	.word 0xe0cc2000  ! 9547: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r16
	.word 0xe0bc6000  ! 9548: STDA_I	stda	%r16, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 9549: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecf40400  ! 9550: STXA_R	stxa	%r22, [%r16 + %r0] 0x20
	.word 0xeccca000  ! 9551: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r22
	.word 0xe29649e0  ! 9552: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r17
	.word 0xe2a42000  ! 9553: STWA_I	stwa	%r17, [%r16 + 0x0000] %asi
	.word 0xe2b42000  ! 9554: STHA_I	stha	%r17, [%r16 + 0x0000] %asi
	.word 0xe4a689e0  ! 9555: STWA_R	stwa	%r18, [%r26 + %r0] 0x4f
	mov	0x7c8, %r22
	.word 0xe4ace000  ! 9557: STBA_I	stba	%r18, [%r19 + 0x0000] %asi
	mov	0x60, %r16
	.word 0x87802073  ! 9559: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r18
	mov	0x0, %r26
	.word 0xe4d7e000  ! 9562: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r18
	.word 0xe4b7e000  ! 9563: STHA_I	stha	%r18, [%r31 + 0x0000] %asi
	.word 0xe4f76000  ! 9564: STXA_I	stxa	%r18, [%r29 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xecaf0e80  ! 9566: STBA_R	stba	%r22, [%r28 + %r0] 0x74
	.word 0xee9f4e80  ! 9567: LDDA_R	ldda	[%r29, %r0] 0x74, %r23
	.word 0xeecf6000  ! 9568: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r23
	.word 0xee9fa000  ! 9569: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r23
	.word 0xe4a7ce40  ! 9570: STWA_R	stwa	%r18, [%r31 + %r0] 0x72
	.word 0xe4af6000  ! 9571: STBA_I	stba	%r18, [%r29 + 0x0000] %asi
	.word 0xe4f72000  ! 9572: STXA_I	stxa	%r18, [%r28 + 0x0000] %asi
	.word 0xeca40400  ! 9573: STWA_R	stwa	%r22, [%r16 + %r0] 0x20
	.word 0xe6970e40  ! 9574: LDUHA_R	lduha	[%r28, %r0] 0x72, %r19
	.word 0xe6d7a000  ! 9575: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r19
	mov	0x7d8, %r20
	mov	0x60, %r26
	.word 0x87802074  ! 9578: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6d72000  ! 9579: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r19
	mov	0x0, %r18
	.word 0xe68f2000  ! 9581: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r19
	.word 0xe687a000  ! 9582: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r19
	.word 0xe0d6c9e0  ! 9583: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r16
	mov	0x68, %r24
	mov	0x7d8, %r20
	.word 0xe2a78e40  ! 9586: STWA_R	stwa	%r17, [%r30 + %r0] 0x72
	.word 0xe8b6c9e0  ! 9587: STHA_R	stha	%r20, [%r27 + %r0] 0x4f
	.word 0xe8972000  ! 9588: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r20
	.word 0xe8d72000  ! 9589: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r20
	.word 0xe2f48400  ! 9590: STXA_R	stxa	%r17, [%r18 + %r0] 0x20
	.word 0xe2f72000  ! 9591: STXA_I	stxa	%r17, [%r28 + 0x0000] %asi
	mov	0x30, %r25
	wr_tick_cmpr_0_79:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x81, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0xa8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe2b7e000  ! 9594: STHA_I	stha	%r17, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 9595: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe49584a0  ! 9596: LDUHA_R	lduha	[%r22, %r0] 0x25, %r18
	.word 0xe4b66000  ! 9597: STHA_I	stha	%r18, [%r25 + 0x0000] %asi
	.word 0xe89cc400  ! 9598: LDDA_R	ldda	[%r19, %r0] 0x20, %r20
	.word 0xe8a6e000  ! 9599: STWA_I	stwa	%r20, [%r27 + 0x0000] %asi
	.word 0xecf74e40  ! 9600: STXA_R	stxa	%r22, [%r29 + %r0] 0x72
	.word 0xeccea000  ! 9601: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r22
	.word 0xeca62000  ! 9602: STWA_I	stwa	%r22, [%r24 + 0x0000] %asi
	.word 0xecf6a000  ! 9603: STXA_I	stxa	%r22, [%r26 + 0x0000] %asi
	.word 0xecf6a000  ! 9604: STXA_I	stxa	%r22, [%r26 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xecbe6000  ! 9606: STDA_I	stda	%r22, [%r25 + 0x0000] %asi
	.word 0xecd6e000  ! 9607: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r22
	.word 0xeea44400  ! 9608: STWA_R	stwa	%r23, [%r17 + %r0] 0x20
	mov	0x40, %r25
	.word 0xee86e000  ! 9610: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r23
	.word 0xeebf4e80  ! 9611: STDA_R	stda	%r23, [%r29 + %r0] 0x74
	ta	T_CHANGE_HPRIV	! macro
	mov	0x8, %r18
	.word 0xe4b70e40  ! 9614: STHA_R	stha	%r18, [%r28 + %r0] 0x72
	.word 0xe6afce80  ! 9615: STBA_R	stba	%r19, [%r31 + %r0] 0x74
	.word 0xe6ce2000  ! 9616: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r19
	.word 0xe6be6000  ! 9617: STDA_I	stda	%r19, [%r25 + 0x0000] %asi
	.word 0xeeb504a0  ! 9618: STHA_R	stha	%r23, [%r20 + %r0] 0x25
	.word 0xe4f584a0  ! 9619: STXA_R	stxa	%r18, [%r22 + %r0] 0x25
	.word 0xeabc0400  ! 9620: STDA_R	stda	%r21, [%r16 + %r0] 0x20
	.word 0xeaaea000  ! 9621: STBA_I	stba	%r21, [%r26 + 0x0000] %asi
	.word 0xeadee000  ! 9622: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r21
	.word 0xea8ee000  ! 9623: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r21
	.word 0xeeb74e60  ! 9624: STHA_R	stha	%r23, [%r29 + %r0] 0x73
	.word 0xe2ccc400  ! 9625: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r17
	.word 0xe2b6e000  ! 9626: STHA_I	stha	%r17, [%r27 + 0x0000] %asi
	.word 0xe2862000  ! 9627: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r17
	.word 0xe2af0e80  ! 9628: STBA_R	stba	%r17, [%r28 + %r0] 0x74
	mov	0x3e0, %r20
	mov	0x50, %r26
	.word 0xe8a649e0  ! 9631: STWA_R	stwa	%r20, [%r25 + %r0] 0x4f
	mov	0x3c8, %r20
	.word 0xeabdc4a0  ! 9633: STDA_R	stda	%r21, [%r23 + %r0] 0x25
	mov	0x7e0, %r22
	.word 0xeabc4400  ! 9635: STDA_R	stda	%r21, [%r17 + %r0] 0x20
	.word 0xeabe6000  ! 9636: STDA_I	stda	%r21, [%r25 + 0x0000] %asi
	.word 0xeab6a000  ! 9637: STHA_I	stha	%r21, [%r26 + 0x0000] %asi
	.word 0xead66000  ! 9638: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r21
	.word 0xe4cf8e40  ! 9639: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r18
	.word 0xeaf78e40  ! 9640: STXA_R	stxa	%r21, [%r30 + %r0] 0x72
	.word 0x87802073  ! 9641: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xead7e000  ! 9642: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r21
	.word 0xe2f7ce80  ! 9643: STXA_R	stxa	%r17, [%r31 + %r0] 0x74
	mov	0x3d8, %r22
	.word 0xe8bf0e40  ! 9645: STDA_R	stda	%r20, [%r28 + %r0] 0x72
	.word 0xe8afa000  ! 9646: STBA_I	stba	%r20, [%r30 + 0x0000] %asi
	.word 0xe8bfe000  ! 9647: STDA_I	stda	%r20, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 9648: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecce09e0  ! 9649: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r22
	mov	0x20, %r24
	.word 0x8780204f  ! 9651: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d0, %r21
	.word 0xeea4c400  ! 9653: STWA_R	stwa	%r23, [%r19 + %r0] 0x20
	mov	0x10, %r25
	.word 0xecf584a0  ! 9655: STXA_R	stxa	%r22, [%r22 + %r0] 0x25
	.word 0xe2a40400  ! 9656: STWA_R	stwa	%r17, [%r16 + %r0] 0x20
	mov	0x7f0, %r23
	.word 0xe2dea000  ! 9658: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r17
	.word 0xe2cee000  ! 9659: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r17
	.word 0xe29e6000  ! 9660: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r17
	.word 0xe2a6a000  ! 9661: STWA_I	stwa	%r17, [%r26 + 0x0000] %asi
	.word 0xe2f66000  ! 9662: STXA_I	stxa	%r17, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 9663: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8b7ce40  ! 9664: STHA_R	stha	%r20, [%r31 + %r0] 0x72
	mov	0x8, %r17
	.word 0xe4a40400  ! 9666: STWA_R	stwa	%r18, [%r16 + %r0] 0x20
	.word 0xe48ca000  ! 9667: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r18
	.word 0x87802073  ! 9668: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe497e000  ! 9669: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r18
	.word 0xe4a72000  ! 9670: STWA_I	stwa	%r18, [%r28 + 0x0000] %asi
	.word 0xeca584a0  ! 9671: STWA_R	stwa	%r22, [%r22 + %r0] 0x25
	.word 0xec9f6000  ! 9672: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r22
	.word 0x87802074  ! 9673: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xecaf6000  ! 9674: STBA_I	stba	%r22, [%r29 + 0x0000] %asi
	.word 0xeccf2000  ! 9675: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r22
	.word 0x87802074  ! 9676: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeace89e0  ! 9677: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r21
	.word 0xeabfe000  ! 9678: STDA_I	stda	%r21, [%r31 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xe6df4e80  ! 9680: LDXA_R	ldxa	[%r29, %r0] 0x74, %r19
	.word 0xe4878e60  ! 9681: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r18
	.word 0xe4b7e000  ! 9682: STHA_I	stha	%r18, [%r31 + 0x0000] %asi
	wr_tick_cmpr_0_80:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xda, %g2
	or	%g4, 0xeb, %g4
	or	%g6, 0xd8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7f8, %r22
	.word 0xe49fe000  ! 9685: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r18
	.word 0xe4bd44a0  ! 9686: STDA_R	stda	%r18, [%r21 + %r0] 0x25
	.word 0xecb689e0  ! 9687: STHA_R	stha	%r22, [%r26 + %r0] 0x4f
	.word 0xecbfa000  ! 9688: STDA_I	stda	%r22, [%r30 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xecafe000  ! 9690: STBA_I	stba	%r22, [%r31 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xe89f4e60  ! 9692: LDDA_R	ldda	[%r29, %r0] 0x73, %r20
	.word 0x87802073  ! 9693: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r16
	.word 0xe8c78e80  ! 9695: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r20
	.word 0xe8b72000  ! 9696: STHA_I	stha	%r20, [%r28 + 0x0000] %asi
	.word 0xe88f2000  ! 9697: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r20
	.word 0x8780204f  ! 9698: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 9699: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r24
	.word 0x87802025  ! 9701: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xea9cc400  ! 9702: LDDA_R	ldda	[%r19, %r0] 0x20, %r21
	.word 0xeab52000  ! 9703: STHA_I	stha	%r21, [%r20 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0xeadd2000  ! 9705: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r21
	.word 0xea95e000  ! 9706: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r21
	.word 0xe29d44a0  ! 9707: LDDA_R	ldda	[%r21, %r0] 0x25, %r17
	.word 0xe28d2000  ! 9708: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r17
	.word 0xe8c78e60  ! 9709: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r20
	.word 0x87802025  ! 9710: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r24
	.word 0xeaaf8e80  ! 9712: STBA_R	stba	%r21, [%r30 + %r0] 0x74
	.word 0xeef44400  ! 9713: STXA_R	stxa	%r23, [%r17 + %r0] 0x20
	.word 0xeab584a0  ! 9714: STHA_R	stha	%r21, [%r22 + %r0] 0x25
	.word 0x87802074  ! 9715: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe28d44a0  ! 9716: LDUBA_R	lduba	[%r21, %r0] 0x25, %r17
	.word 0xe8ce49e0  ! 9717: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r20
	.word 0x87802073  ! 9718: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8afa000  ! 9719: STBA_I	stba	%r20, [%r30 + 0x0000] %asi
	.word 0xe89f6000  ! 9720: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r20
	.word 0xe8a76000  ! 9721: STWA_I	stwa	%r20, [%r29 + 0x0000] %asi
	.word 0xeea74e40  ! 9722: STWA_R	stwa	%r23, [%r29 + %r0] 0x72
	.word 0xee9f6000  ! 9723: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r23
	.word 0xeea7a000  ! 9724: STWA_I	stwa	%r23, [%r30 + 0x0000] %asi
	.word 0xeac78e60  ! 9725: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r21
	.word 0xe0af4e40  ! 9726: STBA_R	stba	%r16, [%r29 + %r0] 0x72
	.word 0xeed5c4a0  ! 9727: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r23
	mov	0x3c0, %r23
	.word 0x87802020  ! 9729: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r22
	.word 0xee94a000  ! 9731: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r23
	mov	0x28, %r16
	mov	0x7c0, %r23
	mov	0x3c8, %r21
	.word 0xeef74e60  ! 9735: STXA_R	stxa	%r23, [%r29 + %r0] 0x73
	.word 0xeec4a000  ! 9736: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r23
	.word 0xe0dd04a0  ! 9737: LDXA_R	ldxa	[%r20, %r0] 0x25, %r16
	.word 0xe08ce000  ! 9738: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r16
	ta	T_CHANGE_HPRIV	! macro
	.word 0xeec609e0  ! 9740: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r23
	mov	0x7e8, %r21
	.word 0xe4a78e40  ! 9742: STWA_R	stwa	%r18, [%r30 + %r0] 0x72
	.word 0xe8b6c9e0  ! 9743: STHA_R	stha	%r20, [%r27 + %r0] 0x4f
	.word 0xe88ca000  ! 9744: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r20
	.word 0xe4b48400  ! 9745: STHA_R	stha	%r18, [%r18 + %r0] 0x20
	mov	0x7d0, %r20
	.word 0xe4c46000  ! 9747: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r18
	.word 0xe4d4e000  ! 9748: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r18
	.word 0xe4dc6000  ! 9749: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r18
	.word 0xe4bc2000  ! 9750: STDA_I	stda	%r18, [%r16 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xec8fce60  ! 9752: LDUBA_R	lduba	[%r31, %r0] 0x73, %r22
	mov	0x7c8, %r20
	.word 0xecaca000  ! 9754: STBA_I	stba	%r22, [%r18 + 0x0000] %asi
	.word 0xe28c8400  ! 9755: LDUBA_R	lduba	[%r18, %r0] 0x20, %r17
	.word 0xe4be09e0  ! 9756: STDA_R	stda	%r18, [%r24 + %r0] 0x4f
	.word 0xe4d4e000  ! 9757: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r18
	.word 0xecbdc4a0  ! 9758: STDA_R	stda	%r22, [%r23 + %r0] 0x25
	mov	0x50, %r25
	.word 0xe0ae49e0  ! 9760: STBA_R	stba	%r16, [%r25 + %r0] 0x4f
	.word 0xe0ace000  ! 9761: STBA_I	stba	%r16, [%r19 + 0x0000] %asi
	.word 0xeef78e80  ! 9762: STXA_R	stxa	%r23, [%r30 + %r0] 0x74
	.word 0xeeac6000  ! 9763: STBA_I	stba	%r23, [%r17 + 0x0000] %asi
	.word 0xe6acc400  ! 9764: STBA_R	stba	%r19, [%r19 + %r0] 0x20
	.word 0xe6d4e000  ! 9765: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r19
	mov	0x60, %r16
	.word 0xe68ce000  ! 9767: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r19
	.word 0xea878e60  ! 9768: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r21
	.word 0xeab4a000  ! 9769: STHA_I	stha	%r21, [%r18 + 0x0000] %asi
	.word 0xead4e000  ! 9770: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r21
	mov	0x7f8, %r22
	.word 0x87802074  ! 9772: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4b74e80  ! 9773: STHA_R	stha	%r18, [%r29 + %r0] 0x74
	.word 0x87802072  ! 9774: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4b7e000  ! 9775: STHA_I	stha	%r18, [%r31 + 0x0000] %asi
	mov	0x10, %r25
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe48f2000  ! 9778: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r18
	mov	0x10, %r17
	.word 0xe4f76000  ! 9780: STXA_I	stxa	%r18, [%r29 + 0x0000] %asi
	.word 0xe4bfa000  ! 9781: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 9782: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe48c2000  ! 9783: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r18
	mov	0x7f8, %r23
	.word 0x87802020  ! 9785: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 9786: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4b44400  ! 9787: STHA_R	stha	%r18, [%r17 + %r0] 0x20
	.word 0xe08e49e0  ! 9788: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r16
	.word 0xe4c44400  ! 9789: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r18
	.word 0xe4852000  ! 9790: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r18
	.word 0xe8b48400  ! 9791: STHA_R	stha	%r20, [%r18 + %r0] 0x20
	.word 0xe89de000  ! 9792: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r20
	.word 0x87802073  ! 9793: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 9794: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	mov	0x30, %r17
	.word 0xe8ac4400  ! 9797: STBA_R	stba	%r20, [%r17 + %r0] 0x20
	.word 0x87802025  ! 9798: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r17
	.word 0xe8d5e000  ! 9800: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r20
	mov	0x3d8, %r20
	.word 0xeebf8e60  ! 9802: STDA_R	stda	%r23, [%r30 + %r0] 0x73
	.word 0xeea5e000  ! 9803: STWA_I	stwa	%r23, [%r23 + 0x0000] %asi
	.word 0xee97ce40  ! 9804: LDUHA_R	lduha	[%r31, %r0] 0x72, %r23
	.word 0xee852000  ! 9805: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r23
	.word 0xeeb44400  ! 9806: STHA_R	stha	%r23, [%r17 + %r0] 0x20
	.word 0xeea5a000  ! 9807: STWA_I	stwa	%r23, [%r22 + 0x0000] %asi
	.word 0xeedd6000  ! 9808: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r23
	.word 0xeeb56000  ! 9809: STHA_I	stha	%r23, [%r21 + 0x0000] %asi
	.word 0xee9da000  ! 9810: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r23
	.word 0xe29504a0  ! 9811: LDUHA_R	lduha	[%r20, %r0] 0x25, %r17
	.word 0x87802025  ! 9812: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r25
	.word 0xe2852000  ! 9814: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r17
	.word 0xe6970e60  ! 9815: LDUHA_R	lduha	[%r28, %r0] 0x73, %r19
	.word 0xec9f8e80  ! 9816: LDDA_R	ldda	[%r30, %r0] 0x74, %r22
	.word 0xeacd04a0  ! 9817: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r21
	.word 0xea956000  ! 9818: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r21
	.word 0xea95e000  ! 9819: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r21
	.word 0xe6d609e0  ! 9820: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r19
	.word 0xe4af4e60  ! 9821: STBA_R	stba	%r18, [%r29 + %r0] 0x73
	.word 0xe4ad6000  ! 9822: STBA_I	stba	%r18, [%r21 + 0x0000] %asi
	.word 0xe4f5a000  ! 9823: STXA_I	stxa	%r18, [%r22 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xe4a5e000  ! 9825: STWA_I	stwa	%r18, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 9826: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4bc2000  ! 9827: STDA_I	stda	%r18, [%r16 + 0x0000] %asi
	mov	0x20, %r18
	mov	0x8, %r16
	.word 0xe4d46000  ! 9830: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r18
	mov	0x7d0, %r23
	.word 0x8780204f  ! 9832: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d0, %r23
	.word 0xeedfce60  ! 9834: LDXA_R	ldxa	[%r31, %r0] 0x73, %r23
	.word 0xee86e000  ! 9835: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r23
	.word 0xee8f8e60  ! 9836: LDUBA_R	lduba	[%r30, %r0] 0x73, %r23
	.word 0xecb504a0  ! 9837: STHA_R	stha	%r22, [%r20 + %r0] 0x25
	.word 0xecf66000  ! 9838: STXA_I	stxa	%r22, [%r25 + 0x0000] %asi
	.word 0xec9e2000  ! 9839: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r22
	.word 0xe0f48400  ! 9840: STXA_R	stxa	%r16, [%r18 + %r0] 0x20
	.word 0x87802025  ! 9841: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802073  ! 9843: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6f609e0  ! 9844: STXA_R	stxa	%r19, [%r24 + %r0] 0x4f
	.word 0xe6bfa000  ! 9845: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xe6f7e000  ! 9846: STXA_I	stxa	%r19, [%r31 + 0x0000] %asi
	.word 0xe69d84a0  ! 9847: LDDA_R	ldda	[%r22, %r0] 0x25, %r19
	mov	0x18, %r24
	.word 0xe2dfce80  ! 9849: LDXA_R	ldxa	[%r31, %r0] 0x74, %r17
	.word 0x87802020  ! 9850: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0bc4400  ! 9851: STDA_R	stda	%r16, [%r17 + %r0] 0x20
	mov	0x20, %r25
	.word 0xe4b48400  ! 9853: STHA_R	stha	%r18, [%r18 + %r0] 0x20
	.word 0xe2874e40  ! 9854: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r17
	.word 0xe284a000  ! 9855: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r17
	.word 0xe2f70e40  ! 9856: STXA_R	stxa	%r17, [%r28 + %r0] 0x72
	mov	0x18, %r17
	.word 0x87802072  ! 9858: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2b7a000  ! 9859: STHA_I	stha	%r17, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 9860: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2cea000  ! 9861: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r17
	.word 0xe2bee000  ! 9862: STDA_I	stda	%r17, [%r27 + 0x0000] %asi
	.word 0xe2bee000  ! 9863: STDA_I	stda	%r17, [%r27 + 0x0000] %asi
	.word 0xe0b44400  ! 9864: STHA_R	stha	%r16, [%r17 + %r0] 0x20
	mov	0x7f0, %r21
	.word 0xec95c4a0  ! 9866: LDUHA_R	lduha	[%r23, %r0] 0x25, %r22
	.word 0xe8ae49e0  ! 9867: STBA_R	stba	%r20, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 9868: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 9869: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe88e6000  ! 9870: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r20
	.word 0xecb70e80  ! 9871: STHA_R	stha	%r22, [%r28 + %r0] 0x74
	.word 0x87802073  ! 9872: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe49f0e60  ! 9873: LDDA_R	ldda	[%r28, %r0] 0x73, %r18
	.word 0xee9f0e60  ! 9874: LDDA_R	ldda	[%r28, %r0] 0x73, %r23
	.word 0xe0bf4e60  ! 9875: STDA_R	stda	%r16, [%r29 + %r0] 0x73
	.word 0xe2c70e80  ! 9876: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r17
	.word 0x87802020  ! 9877: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2a46000  ! 9878: STWA_I	stwa	%r17, [%r17 + 0x0000] %asi
	.word 0xecbc8400  ! 9879: STDA_R	stda	%r22, [%r18 + %r0] 0x20
	.word 0xecdc6000  ! 9880: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r22
	mov	0x10, %r16
	.word 0xecb4e000  ! 9882: STHA_I	stha	%r22, [%r19 + 0x0000] %asi
	.word 0xeebcc400  ! 9883: STDA_R	stda	%r23, [%r19 + %r0] 0x20
	.word 0xe294c400  ! 9884: LDUHA_R	lduha	[%r19, %r0] 0x20, %r17
	mov	0x70, %r27
	.word 0xe2b46000  ! 9886: STHA_I	stha	%r17, [%r17 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0x87802072  ! 9888: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2b76000  ! 9889: STHA_I	stha	%r17, [%r29 + 0x0000] %asi
	.word 0xe2a7e000  ! 9890: STWA_I	stwa	%r17, [%r31 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xe2876000  ! 9892: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r17
	mov	0x50, %r26
	.word 0xe2af6000  ! 9894: STBA_I	stba	%r17, [%r29 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x68, %r25
	.word 0xe2972000  ! 9897: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r17
	mov	0x3e0, %r22
	mov	0x8, %r25
	mov	0x0, %r18
	.word 0xe4f4c400  ! 9901: STXA_R	stxa	%r18, [%r19 + %r0] 0x20
	.word 0xe4df6000  ! 9902: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r18
	mov	0x38, %r19
	.word 0xeeacc400  ! 9904: STBA_R	stba	%r23, [%r19 + %r0] 0x20
	.word 0xee87e000  ! 9905: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r23
	.word 0xeeafe000  ! 9906: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0xeebfe000  ! 9907: STDA_I	stda	%r23, [%r31 + 0x0000] %asi
	.word 0xeeaf6000  ! 9908: STBA_I	stba	%r23, [%r29 + 0x0000] %asi
	mov	0x0, %r26
	.word 0x87802074  ! 9910: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeef7e000  ! 9911: STXA_I	stxa	%r23, [%r31 + 0x0000] %asi
	.word 0xee8f6000  ! 9912: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r23
	.word 0x87802020  ! 9913: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 9914: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8dc8400  ! 9915: LDXA_R	ldxa	[%r18, %r0] 0x20, %r20
	.word 0x87802020  ! 9916: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8f4a000  ! 9917: STXA_I	stxa	%r20, [%r18 + 0x0000] %asi
	.word 0xe6af8e40  ! 9918: STBA_R	stba	%r19, [%r30 + %r0] 0x72
	.word 0xea8f0e80  ! 9919: LDUBA_R	lduba	[%r28, %r0] 0x74, %r21
	.word 0x87802020  ! 9920: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaf4a000  ! 9921: STXA_I	stxa	%r21, [%r18 + 0x0000] %asi
	.word 0xeed4c400  ! 9922: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r23
	mov	0x48, %r19
	mov	0x7c8, %r22
	.word 0xeaa504a0  ! 9925: STWA_R	stwa	%r21, [%r20 + %r0] 0x25
	.word 0xe88544a0  ! 9926: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r20
	.word 0xeed584a0  ! 9927: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r23
	.word 0x87802020  ! 9928: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe29f4e80  ! 9929: LDDA_R	ldda	[%r29, %r0] 0x74, %r17
	mov	0x50, %r27
	.word 0xe2b4a000  ! 9931: STHA_I	stha	%r17, [%r18 + 0x0000] %asi
	.word 0xe2d42000  ! 9932: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r17
	.word 0xe8b48400  ! 9933: STHA_R	stha	%r20, [%r18 + %r0] 0x20
	.word 0xeca78e80  ! 9934: STWA_R	stwa	%r22, [%r30 + %r0] 0x74
	.word 0x87802073  ! 9935: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r22
	.word 0xe8f5c4a0  ! 9937: STXA_R	stxa	%r20, [%r23 + %r0] 0x25
	.word 0xe6c48400  ! 9938: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r19
	mov	0x8, %r27
	.word 0xe6a7e000  ! 9940: STWA_I	stwa	%r19, [%r31 + 0x0000] %asi
	.word 0xe6c7e000  ! 9941: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r19
	.word 0x8780204f  ! 9942: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 9943: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2c7ce40  ! 9944: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r17
	.word 0xe2a66000  ! 9945: STWA_I	stwa	%r17, [%r25 + 0x0000] %asi
	.word 0xe2b66000  ! 9946: STHA_I	stha	%r17, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 9947: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_0_81:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd3, %g2
	or	%g4, 0xd9, %g4
	or	%g6, 0xb5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe2b5a000  ! 9949: STHA_I	stha	%r17, [%r22 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xe6874e60  ! 9951: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r19
	mov	0x10, %r19
	mov	0x60, %r17
	.word 0x87802020  ! 9954: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe684e000  ! 9955: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r19
	.word 0x87802025  ! 9956: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r17
	.word 0xeedc0400  ! 9958: LDXA_R	ldxa	[%r16, %r0] 0x20, %r23
	.word 0xec94c400  ! 9959: LDUHA_R	lduha	[%r19, %r0] 0x20, %r22
	.word 0xecc52000  ! 9960: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r22
	.word 0xe29f0e80  ! 9961: LDDA_R	ldda	[%r28, %r0] 0x74, %r17
	.word 0xe2ad6000  ! 9962: STBA_I	stba	%r17, [%r21 + 0x0000] %asi
	.word 0xe2f544a0  ! 9963: STXA_R	stxa	%r17, [%r21 + %r0] 0x25
	mov	0x10, %r18
	.word 0xe0af0e80  ! 9965: STBA_R	stba	%r16, [%r28 + %r0] 0x74
	mov	0x58, %r25
	.word 0xe4f70e60  ! 9967: STXA_R	stxa	%r18, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 9968: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 9969: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2bcc400  ! 9970: STDA_R	stda	%r17, [%r19 + %r0] 0x20
	.word 0xe2f66000  ! 9971: STXA_I	stxa	%r17, [%r25 + 0x0000] %asi
	.word 0xe89cc400  ! 9972: LDDA_R	ldda	[%r19, %r0] 0x20, %r20
	mov	0x3e8, %r22
	mov	0x7c8, %r23
	.word 0x87802072  ! 9975: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r24
	.word 0xe887e000  ! 9977: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r20
	mov	0x50, %r26
	.word 0xeacc0400  ! 9979: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r21
	.word 0xe2840400  ! 9980: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r17
	.word 0xe2bfce40  ! 9981: STDA_R	stda	%r17, [%r31 + %r0] 0x72
	mov	0x78, %r19
	mov	0x68, %r16
	mov	0x78, %r16
	.word 0xe29fe000  ! 9985: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r17
	.word 0xeef7ce40  ! 9986: STXA_R	stxa	%r23, [%r31 + %r0] 0x72
	mov	0x10, %r26
	mov	0x50, %r26
	ta	T_CHANGE_HPRIV	! macro
	.word 0xeedfa000  ! 9990: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r23
	.word 0xeea76000  ! 9991: STWA_I	stwa	%r23, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 9992: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeeb4e000  ! 9993: STHA_I	stha	%r23, [%r19 + 0x0000] %asi
	mov	0x8, %r24
	.word 0xeedc6000  ! 9995: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r23
	.word 0xeccf4e60  ! 9996: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r22
	mov	0x38, %r27
	.word 0xeccfce60  ! 9998: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r22
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_3:
	.word 0xe8b544a0  ! 1: STHA_R	stha	%r20, [%r21 + %r0] 0x25
	.word 0xec9e89e0  ! 2: LDDA_R	ldda	[%r26, %r0] 0x4f, %r22
	mov	0x18, %r17
	.word 0xecb70e80  ! 4: STHA_R	stha	%r22, [%r28 + %r0] 0x74
	.word 0xe6a66000  ! 5: STWA_I	stwa	%r19, [%r25 + 0x0000] %asi
	.word 0xe69e2000  ! 6: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r19
	.word 0x87802020  ! 7: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe097ce40  ! 8: LDUHA_R	lduha	[%r31, %r0] 0x72, %r16
	mov	0x78, %r17
	.word 0xe0848400  ! 10: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r16
	.word 0xe69f0e80  ! 11: LDDA_R	ldda	[%r28, %r0] 0x74, %r19
	mov	0x7f0, %r23
	.word 0x87802020  ! 13: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 14: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r17
	mov	0x68, %r27
	.word 0xea870e40  ! 17: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r21
	.word 0xe68d84a0  ! 18: LDUBA_R	lduba	[%r22, %r0] 0x25, %r19
	.word 0xeea609e0  ! 19: STWA_R	stwa	%r23, [%r24 + %r0] 0x4f
	.word 0xe6d62000  ! 20: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r19
	.word 0xe6d66000  ! 21: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r19
	.word 0xe6aee000  ! 22: STBA_I	stba	%r19, [%r27 + 0x0000] %asi
	.word 0xe6f6e000  ! 23: STXA_I	stxa	%r19, [%r27 + 0x0000] %asi
	.word 0xe6a689e0  ! 24: STWA_R	stwa	%r19, [%r26 + %r0] 0x4f
	.word 0xeadea000  ! 25: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r21
	.word 0xe4acc400  ! 26: STBA_R	stba	%r18, [%r19 + %r0] 0x20
	.word 0xe0a66000  ! 27: STWA_I	stwa	%r16, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 28: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 29: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r17
	.word 0xe2cd44a0  ! 31: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r17
	.word 0xecf42000  ! 32: STXA_I	stxa	%r22, [%r16 + 0x0000] %asi
	mov	0x28, %r18
	mov	0x3e8, %r21
	.word 0xecbce000  ! 35: STDA_I	stda	%r22, [%r19 + 0x0000] %asi
	.word 0xea96c9e0  ! 36: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r21
	.word 0xeeb4a000  ! 37: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xee8c2000  ! 39: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r23
	.word 0x87802074  ! 40: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeef72000  ! 41: STXA_I	stxa	%r23, [%r28 + 0x0000] %asi
	.word 0xeef7e000  ! 42: STXA_I	stxa	%r23, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 43: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4878e60  ! 44: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r18
	.word 0x87802020  ! 45: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4b584a0  ! 46: STHA_R	stha	%r18, [%r22 + %r0] 0x25
	.word 0xe896e000  ! 47: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r20
	mov	0x7e0, %r21
	.word 0xeab78e60  ! 49: STHA_R	stha	%r21, [%r30 + %r0] 0x73
	.word 0xe6be6000  ! 50: STDA_I	stda	%r19, [%r25 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xe6ce2000  ! 52: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r19
	mov	0x3d0, %r20
	.word 0xe4848400  ! 54: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r18
	.word 0xe0bee000  ! 55: STDA_I	stda	%r16, [%r27 + 0x0000] %asi
	.word 0xe0d62000  ! 56: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r16
	.word 0xe0be6000  ! 57: STDA_I	stda	%r16, [%r25 + 0x0000] %asi
	.word 0xe0de6000  ! 58: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r16
	.word 0x87802025  ! 59: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeaad84a0  ! 60: STBA_R	stba	%r21, [%r22 + %r0] 0x25
	mov	0x3c8, %r22
	.word 0xe6f7a000  ! 62: STXA_I	stxa	%r19, [%r30 + 0x0000] %asi
	.word 0xe8df0e60  ! 63: LDXA_R	ldxa	[%r28, %r0] 0x73, %r20
	.word 0xecb7e000  ! 64: STHA_I	stha	%r22, [%r31 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xecbf6000  ! 66: STDA_I	stda	%r22, [%r29 + 0x0000] %asi
	.word 0xeec6c9e0  ! 67: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r23
	mov	0x0, %r24
	.word 0xeab76000  ! 69: STHA_I	stha	%r21, [%r29 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xeaa7a000  ! 71: STWA_I	stwa	%r21, [%r30 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xe2bcc400  ! 73: STDA_R	stda	%r17, [%r19 + %r0] 0x20
	.word 0x87802020  ! 74: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r16
	.word 0xe6866000  ! 76: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r19
	mov	0x28, %r19
	.word 0xe6c62000  ! 78: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r19
	mov	0x70, %r16
	.word 0xe0f78e40  ! 80: STXA_R	stxa	%r16, [%r30 + %r0] 0x72
	mov	0x3f8, %r20
	.word 0xe2f62000  ! 82: STXA_I	stxa	%r17, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 83: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe284a000  ! 84: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r17
	mov	0x38, %r24
	mov	0x50, %r16
	mov	0x8, %r25
	.word 0xeebd84a0  ! 88: STDA_R	stda	%r23, [%r22 + %r0] 0x25
	.word 0xe4bdc4a0  ! 89: STDA_R	stda	%r18, [%r23 + %r0] 0x25
	mov	0x3d8, %r20
	.word 0x87802020  ! 91: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeeb4a000  ! 92: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	.word 0xe4cf4e80  ! 93: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r18
	mov	0x7c0, %r20
	.word 0xe0df4e40  ! 95: LDXA_R	ldxa	[%r29, %r0] 0x72, %r16
	.word 0xe08689e0  ! 96: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r16
	.word 0xeef44400  ! 97: STXA_R	stxa	%r23, [%r17 + %r0] 0x20
	.word 0xe8cc6000  ! 98: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r20
	.word 0xe2afce60  ! 99: STBA_R	stba	%r17, [%r31 + %r0] 0x73
	.word 0xe4dca000  ! 100: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r18
	.word 0xe8d5c4a0  ! 101: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r20
	mov	0x30, %r25
	.word 0xe68fce40  ! 103: LDUBA_R	lduba	[%r31, %r0] 0x72, %r19
	.word 0xeacc2000  ! 104: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r21
	.word 0xe4a70e80  ! 105: STWA_R	stwa	%r18, [%r28 + %r0] 0x74
	.word 0x87802025  ! 106: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeabca000  ! 107: STDA_I	stda	%r21, [%r18 + 0x0000] %asi
	.word 0xeaf4e000  ! 108: STXA_I	stxa	%r21, [%r19 + 0x0000] %asi
	mov	0x7c8, %r21
	mov	0x3f0, %r20
	mov	0x3f8, %r20
	mov	0x3d8, %r22
	.word 0xea84a000  ! 113: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r21
	mov	0x20, %r26
	.word 0xe8de09e0  ! 115: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r20
	.word 0xeca4e000  ! 116: STWA_I	stwa	%r22, [%r19 + 0x0000] %asi
	wr_tick_cmpr_3_0:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0xbc, %g4
	or	%g6, 0xcd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xec9c2000  ! 118: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r22
	.word 0x8780204f  ! 119: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeef5c4a0  ! 120: STXA_R	stxa	%r23, [%r23 + %r0] 0x25
	.word 0x87802073  ! 121: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r23
	.word 0xeca7e000  ! 123: STWA_I	stwa	%r22, [%r31 + 0x0000] %asi
	mov	0x7e0, %r23
	mov	0x0, %r27
	.word 0xeccf2000  ! 126: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r22
	.word 0xec8f6000  ! 127: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	.word 0xecbfa000  ! 128: STDA_I	stda	%r22, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 129: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xec86a000  ! 130: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r22
	.word 0x87802072  ! 131: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xee8f8e60  ! 132: LDUBA_R	lduba	[%r30, %r0] 0x73, %r23
	.word 0xecdf8e40  ! 133: LDXA_R	ldxa	[%r30, %r0] 0x72, %r22
	mov	0x0, %r26
	.word 0xeabf0e60  ! 135: STDA_R	stda	%r21, [%r28 + %r0] 0x73
	.word 0xe4ad2000  ! 136: STBA_I	stba	%r18, [%r20 + 0x0000] %asi
	.word 0xe485a000  ! 137: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r18
	.word 0xeadf8e60  ! 138: LDXA_R	ldxa	[%r30, %r0] 0x73, %r21
	.word 0xea852000  ! 139: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r21
	mov	0x68, %r19
	.word 0xeabd6000  ! 141: STDA_I	stda	%r21, [%r21 + 0x0000] %asi
	.word 0xe2de09e0  ! 142: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r17
	.word 0xe4bd6000  ! 143: STDA_I	stda	%r18, [%r21 + 0x0000] %asi
	.word 0xe4bda000  ! 144: STDA_I	stda	%r18, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 145: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xea85c4a0  ! 146: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r21
	.word 0x87802074  ! 147: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 148: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r17
	.word 0xec9f8e40  ! 150: LDDA_R	ldda	[%r30, %r0] 0x72, %r22
	.word 0xe8d72000  ! 151: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r20
	.word 0xe8f72000  ! 152: STXA_I	stxa	%r20, [%r28 + 0x0000] %asi
	.word 0xe8bf2000  ! 153: STDA_I	stda	%r20, [%r28 + 0x0000] %asi
	.word 0xe8af6000  ! 154: STBA_I	stba	%r20, [%r29 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0xe8a7e000  ! 156: STWA_I	stwa	%r20, [%r31 + 0x0000] %asi
	.word 0xe8a649e0  ! 157: STWA_R	stwa	%r20, [%r25 + %r0] 0x4f
	.word 0xeedc0400  ! 158: LDXA_R	ldxa	[%r16, %r0] 0x20, %r23
	.word 0xe2b649e0  ! 159: STHA_R	stha	%r17, [%r25 + %r0] 0x4f
	.word 0xeeafa000  ! 160: STBA_I	stba	%r23, [%r30 + 0x0000] %asi
	.word 0xe8a649e0  ! 161: STWA_R	stwa	%r20, [%r25 + %r0] 0x4f
	.word 0xe4f76000  ! 162: STXA_I	stxa	%r18, [%r29 + 0x0000] %asi
	.word 0xe0af4e40  ! 163: STBA_R	stba	%r16, [%r29 + %r0] 0x72
	mov	0x7d8, %r21
	.word 0x87802073  ! 165: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xead609e0  ! 166: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r21
	.word 0x87802020  ! 167: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 168: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4a72000  ! 169: STWA_I	stwa	%r18, [%r28 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xeea48400  ! 171: STWA_R	stwa	%r23, [%r18 + %r0] 0x20
	.word 0xeadf2000  ! 172: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r21
	.word 0xeab40400  ! 173: STHA_R	stha	%r21, [%r16 + %r0] 0x20
	mov	0x3f0, %r22
	.word 0xe2bfe000  ! 175: STDA_I	stda	%r17, [%r31 + 0x0000] %asi
	mov	0x7e8, %r21
	mov	0x70, %r24
	.word 0xeab6c9e0  ! 178: STHA_R	stha	%r21, [%r27 + %r0] 0x4f
	.word 0xeef7ce80  ! 179: STXA_R	stxa	%r23, [%r31 + %r0] 0x74
	.word 0x87802025  ! 180: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r23
	.word 0xe2cc6000  ! 182: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r17
	.word 0xeebf0e60  ! 183: STDA_R	stda	%r23, [%r28 + %r0] 0x73
	.word 0xecac2000  ! 184: STBA_I	stba	%r22, [%r16 + 0x0000] %asi
	.word 0xe2afce80  ! 185: STBA_R	stba	%r17, [%r31 + %r0] 0x74
	mov	0x50, %r16
	.word 0xe0df0e80  ! 187: LDXA_R	ldxa	[%r28, %r0] 0x74, %r16
	.word 0xecdc8400  ! 188: LDXA_R	ldxa	[%r18, %r0] 0x20, %r22
	mov	0x0, %r19
	.word 0x87802074  ! 190: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r24
	.word 0xe4bfe000  ! 192: STDA_I	stda	%r18, [%r31 + 0x0000] %asi
	.word 0xe4f7a000  ! 193: STXA_I	stxa	%r18, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 194: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r24
	.word 0xe6ac8400  ! 196: STBA_R	stba	%r19, [%r18 + %r0] 0x20
	.word 0x87802020  ! 197: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeebd44a0  ! 198: STDA_R	stda	%r23, [%r21 + %r0] 0x25
	mov	0x48, %r16
	mov	0x3e0, %r20
	.word 0xeaac4400  ! 201: STBA_R	stba	%r21, [%r17 + %r0] 0x20
	mov	0x50, %r24
	mov	0x78, %r17
	.word 0xe4bf6000  ! 204: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	.word 0xe4d4c400  ! 205: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r18
	mov	0x60, %r18
	.word 0xe0bd04a0  ! 207: STDA_R	stda	%r16, [%r20 + %r0] 0x25
	.word 0xe4f48400  ! 208: STXA_R	stxa	%r18, [%r18 + %r0] 0x20
	mov	0x38, %r16
	.word 0xe89f2000  ! 210: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r20
	.word 0x87802072  ! 211: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xec9e49e0  ! 212: LDDA_R	ldda	[%r25, %r0] 0x4f, %r22
	.word 0xe4a6c9e0  ! 213: STWA_R	stwa	%r18, [%r27 + %r0] 0x4f
	.word 0xe8f56000  ! 214: STXA_I	stxa	%r20, [%r21 + 0x0000] %asi
	.word 0xe69f0e60  ! 215: LDDA_R	ldda	[%r28, %r0] 0x73, %r19
	.word 0xe0afce80  ! 216: STBA_R	stba	%r16, [%r31 + %r0] 0x74
	.word 0x87802020  ! 217: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecf72000  ! 218: STXA_I	stxa	%r22, [%r28 + 0x0000] %asi
	.word 0xec87a000  ! 219: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r22
	.word 0xe48e49e0  ! 220: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r18
	.word 0xeac5c4a0  ! 221: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r21
	.word 0xe88f8e60  ! 222: LDUBA_R	lduba	[%r30, %r0] 0x73, %r20
	.word 0xe8c72000  ! 223: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r20
	.word 0x87802073  ! 224: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2b504a0  ! 225: STHA_R	stha	%r17, [%r20 + %r0] 0x25
	.word 0xea8c2000  ! 226: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r21
	.word 0xeaa46000  ! 227: STWA_I	stwa	%r21, [%r17 + 0x0000] %asi
	.word 0xe6c70e60  ! 228: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r19
	.word 0xe0974e40  ! 229: LDUHA_R	lduha	[%r29, %r0] 0x72, %r16
	.word 0xe6f7ce60  ! 230: STXA_R	stxa	%r19, [%r31 + %r0] 0x73
	.word 0xe2ac2000  ! 231: STBA_I	stba	%r17, [%r16 + 0x0000] %asi
	.word 0xe2d74e40  ! 232: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r17
	.word 0xe0d40400  ! 233: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r16
	.word 0xe2a4a000  ! 234: STWA_I	stwa	%r17, [%r18 + 0x0000] %asi
	.word 0xe2bca000  ! 235: STDA_I	stda	%r17, [%r18 + 0x0000] %asi
	.word 0xe8d544a0  ! 236: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r20
	mov	0x10, %r25
	mov	0x28, %r24
	mov	0x7f8, %r21
	.word 0x87802073  ! 240: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6cf2000  ! 241: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r19
	.word 0x87802025  ! 242: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6f7a000  ! 243: STXA_I	stxa	%r19, [%r30 + 0x0000] %asi
	.word 0xe8ac4400  ! 244: STBA_R	stba	%r20, [%r17 + %r0] 0x20
	.word 0xeef72000  ! 245: STXA_I	stxa	%r23, [%r28 + 0x0000] %asi
	.word 0xeecfa000  ! 246: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r23
	.word 0xe8a78e40  ! 247: STWA_R	stwa	%r20, [%r30 + %r0] 0x72
	.word 0xe8c78e80  ! 248: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r20
	.word 0xe29e89e0  ! 249: LDDA_R	ldda	[%r26, %r0] 0x4f, %r17
	.word 0x87802073  ! 250: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4af2000  ! 251: STBA_I	stba	%r18, [%r28 + 0x0000] %asi
	.word 0xe09e49e0  ! 252: LDDA_R	ldda	[%r25, %r0] 0x4f, %r16
	.word 0x87802074  ! 253: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 254: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6876000  ! 255: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r19
	mov	0x78, %r26
	.word 0xea9609e0  ! 257: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r21
	mov	0x3d8, %r21
	.word 0x87802074  ! 259: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8be49e0  ! 260: STDA_R	stda	%r20, [%r25 + %r0] 0x4f
	.word 0xee9d04a0  ! 261: LDDA_R	ldda	[%r20, %r0] 0x25, %r23
	.word 0xeeac6000  ! 262: STBA_I	stba	%r23, [%r17 + 0x0000] %asi
	mov	0x30, %r24
	mov	0x7d0, %r20
	.word 0xeab70e80  ! 265: STHA_R	stha	%r21, [%r28 + %r0] 0x74
	mov	0x3e0, %r22
	.word 0xe4c42000  ! 267: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r18
	.word 0x87802020  ! 268: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2b74e80  ! 269: STHA_R	stha	%r17, [%r29 + %r0] 0x74
	mov	0x30, %r25
	.word 0xe8846000  ! 271: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r20
	.word 0xe0b689e0  ! 272: STHA_R	stha	%r16, [%r26 + %r0] 0x4f
	mov	0x0, %r17
	.word 0xe4f44400  ! 274: STXA_R	stxa	%r18, [%r17 + %r0] 0x20
	.word 0xecf74e60  ! 275: STXA_R	stxa	%r22, [%r29 + %r0] 0x73
	.word 0xeecc6000  ! 276: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r23
	.word 0xe29fce80  ! 277: LDDA_R	ldda	[%r31, %r0] 0x74, %r17
	.word 0x87802020  ! 278: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0c46000  ! 279: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r16
	.word 0xe0f7ce40  ! 280: STXA_R	stxa	%r16, [%r31 + %r0] 0x72
	.word 0xe6bc8400  ! 281: STDA_R	stda	%r19, [%r18 + %r0] 0x20
	.word 0xeaf504a0  ! 282: STXA_R	stxa	%r21, [%r20 + %r0] 0x25
	mov	0x8, %r24
	.word 0xec874e60  ! 284: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r22
	.word 0xe0844400  ! 285: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r16
	mov	0x48, %r24
	.word 0x8780204f  ! 287: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xec9fce40  ! 288: LDDA_R	ldda	[%r31, %r0] 0x72, %r22
	.word 0x87802074  ! 289: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeed70e80  ! 290: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r23
	mov	0x68, %r18
	mov	0x3c8, %r22
	.word 0xe2c7e000  ! 293: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r17
	.word 0x87802020  ! 294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6af8e40  ! 295: STBA_R	stba	%r19, [%r30 + %r0] 0x72
	.word 0xecdd84a0  ! 296: LDXA_R	ldxa	[%r22, %r0] 0x25, %r22
	.word 0x87802073  ! 297: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 298: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r17
	.word 0xe4afe000  ! 300: STBA_I	stba	%r18, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 301: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeadc8400  ! 302: LDXA_R	ldxa	[%r18, %r0] 0x20, %r21
	mov	0x7f0, %r23
	.word 0xe8df8e80  ! 304: LDXA_R	ldxa	[%r30, %r0] 0x74, %r20
	.word 0x87802074  ! 305: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 306: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0944400  ! 307: LDUHA_R	lduha	[%r17, %r0] 0x20, %r16
	.word 0xe0df4e40  ! 308: LDXA_R	ldxa	[%r29, %r0] 0x72, %r16
	.word 0xe0f74e60  ! 309: STXA_R	stxa	%r16, [%r29 + %r0] 0x73
	mov	0x7d8, %r20
	.word 0xe4ac2000  ! 311: STBA_I	stba	%r18, [%r16 + 0x0000] %asi
	.word 0xe4d46000  ! 312: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r18
	.word 0xe4c78e60  ! 313: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r18
	.word 0x87802025  ! 314: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r19
	mov	0x30, %r26
	wr_tick_cmpr_3_1:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb0, %g2
	or	%g4, 0xfc, %g4
	or	%g6, 0xe1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 318: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec8c6000  ! 319: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r22
	.word 0xeca4e000  ! 320: STWA_I	stwa	%r22, [%r19 + 0x0000] %asi
	.word 0xe0bf8e80  ! 321: STDA_R	stda	%r16, [%r30 + %r0] 0x74
	.word 0xe4aca000  ! 322: STBA_I	stba	%r18, [%r18 + 0x0000] %asi
	wr_tick_cmpr_3_2:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xcc, %g2
	or	%g4, 0x85, %g4
	or	%g6, 0xbe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 324: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4b7a000  ! 325: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 326: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 327: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r18
	.word 0xee8689e0  ! 329: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r23
	.word 0xe4bc6000  ! 330: STDA_I	stda	%r18, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 331: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6a74e60  ! 332: STWA_R	stwa	%r19, [%r29 + %r0] 0x73
	.word 0x87802020  ! 333: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r25
	.word 0xeeb62000  ! 335: STHA_I	stha	%r23, [%r24 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xeeb66000  ! 337: STHA_I	stha	%r23, [%r25 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 339: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6b78e40  ! 340: STHA_R	stha	%r19, [%r30 + %r0] 0x72
	.word 0x87802072  ! 341: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r23
	mov	0x60, %r25
	.word 0x8780204f  ! 344: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r16
	.word 0xecb70e40  ! 346: STHA_R	stha	%r22, [%r28 + %r0] 0x72
	.word 0xecd4c400  ! 347: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r22
	.word 0xe0c7e000  ! 348: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r16
	.word 0xe0dfa000  ! 349: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r16
	mov	0x18, %r24
	mov	0x68, %r25
	.word 0xe0b7a000  ! 352: STHA_I	stha	%r16, [%r30 + 0x0000] %asi
	.word 0xe0b76000  ! 353: STHA_I	stha	%r16, [%r29 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x7e0, %r22
	mov	0x78, %r27
	.word 0xe4cfce80  ! 357: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r18
	.word 0xee9f8e80  ! 358: LDDA_R	ldda	[%r30, %r0] 0x74, %r23
	.word 0xeebcc400  ! 359: STDA_R	stda	%r23, [%r19 + %r0] 0x20
	.word 0xe88f2000  ! 360: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r20
	.word 0xe8dfa000  ! 361: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r20
	.word 0xe8dfe000  ! 362: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r20
	.word 0xeedf8e80  ! 363: LDXA_R	ldxa	[%r30, %r0] 0x74, %r23
	.word 0xe2a72000  ! 364: STWA_I	stwa	%r17, [%r28 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xe2d7a000  ! 366: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r17
	.word 0x87802072  ! 367: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2cf2000  ! 368: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r17
	.word 0x87802073  ! 369: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 370: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2bf2000  ! 371: STDA_I	stda	%r17, [%r28 + 0x0000] %asi
	.word 0xe2a76000  ! 372: STWA_I	stwa	%r17, [%r29 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xe2976000  ! 374: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r17
	mov	0x3f8, %r23
	.word 0xe2cf8e40  ! 376: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r17
	.word 0xe0ac8400  ! 377: STBA_R	stba	%r16, [%r18 + %r0] 0x20
	.word 0xe49f2000  ! 378: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r18
	.word 0xe68649e0  ! 379: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r19
	.word 0xee976000  ! 380: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r23
	.word 0xec9689e0  ! 381: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r22
	mov	0x3e0, %r20
	.word 0xe4cfe000  ! 383: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r18
	mov	0x3d0, %r20
	.word 0xe4f7a000  ! 385: STXA_I	stxa	%r18, [%r30 + 0x0000] %asi
	.word 0xe497a000  ! 386: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r18
	.word 0xe49f2000  ! 387: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r18
	mov	0x28, %r24
	.word 0xec9c0400  ! 389: LDDA_R	ldda	[%r16, %r0] 0x20, %r22
	mov	0x20, %r17
	.word 0xe28f6000  ! 391: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r17
	.word 0xe2f48400  ! 392: STXA_R	stxa	%r17, [%r18 + %r0] 0x20
	.word 0xe0f7e000  ! 393: STXA_I	stxa	%r16, [%r31 + 0x0000] %asi
	.word 0xe0c7e000  ! 394: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r16
	.word 0xe88584a0  ! 395: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r20
	.word 0xe8b76000  ! 396: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	.word 0xe8f72000  ! 397: STXA_I	stxa	%r20, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 399: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6d7ce80  ! 400: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r19
	.word 0xe4bf6000  ! 401: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xeeaf8e40  ! 403: STBA_R	stba	%r23, [%r30 + %r0] 0x72
	.word 0xe0df2000  ! 404: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r16
	mov	0x58, %r25
	.word 0xe08f6000  ! 406: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r16
	.word 0xe0bd84a0  ! 407: STDA_R	stda	%r16, [%r22 + %r0] 0x25
	mov	0x7c0, %r21
	mov	0x50, %r17
	.word 0xe2f70e60  ! 410: STXA_R	stxa	%r17, [%r28 + %r0] 0x73
	.word 0xe8d70e60  ! 411: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r20
	.word 0x87802074  ! 412: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xecb6c9e0  ! 413: STHA_R	stha	%r22, [%r27 + %r0] 0x4f
	mov	0x20, %r26
	.word 0xe0bc4400  ! 415: STDA_R	stda	%r16, [%r17 + %r0] 0x20
	mov	0x18, %r16
	mov	0x7e8, %r21
	.word 0x87802020  ! 418: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6f78e80  ! 419: STXA_R	stxa	%r19, [%r30 + %r0] 0x74
	.word 0xe0bda000  ! 420: STDA_I	stda	%r16, [%r22 + 0x0000] %asi
	.word 0xe08d2000  ! 421: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r16
	mov	0x3e8, %r21
	.word 0xe6df4e80  ! 423: LDXA_R	ldxa	[%r29, %r0] 0x74, %r19
	.word 0xeeb70e60  ! 424: STHA_R	stha	%r23, [%r28 + %r0] 0x73
	.word 0xeab56000  ! 425: STHA_I	stha	%r21, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 426: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 427: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 428: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6aec9e0  ! 429: STBA_R	stba	%r19, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 430: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6d4c400  ! 431: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r19
	.word 0x8780204f  ! 432: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6a4a000  ! 433: STWA_I	stwa	%r19, [%r18 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0x8780204f  ! 435: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6c40400  ! 436: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r19
	.word 0xe0dfa000  ! 437: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r16
	.word 0xe68fce80  ! 438: LDUBA_R	lduba	[%r31, %r0] 0x74, %r19
	mov	0x18, %r27
	.word 0xe89c0400  ! 440: LDDA_R	ldda	[%r16, %r0] 0x20, %r20
	mov	0x50, %r27
	.word 0xe8f689e0  ! 442: STXA_R	stxa	%r20, [%r26 + %r0] 0x4f
	mov	0x68, %r26
	.word 0x87802072  ! 444: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe48f0e60  ! 445: LDUBA_R	lduba	[%r28, %r0] 0x73, %r18
	.word 0x87802072  ! 446: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeaa689e0  ! 447: STWA_R	stwa	%r21, [%r26 + %r0] 0x4f
	.word 0xe4a52000  ! 448: STWA_I	stwa	%r18, [%r20 + 0x0000] %asi
	.word 0xe4a5e000  ! 449: STWA_I	stwa	%r18, [%r23 + 0x0000] %asi
	.word 0xe2978e80  ! 450: LDUHA_R	lduha	[%r30, %r0] 0x74, %r17
	.word 0x87802020  ! 451: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r25
	.word 0xeef544a0  ! 453: STXA_R	stxa	%r23, [%r21 + %r0] 0x25
	.word 0xeebfe000  ! 454: STDA_I	stda	%r23, [%r31 + 0x0000] %asi
	.word 0xeea7a000  ! 455: STWA_I	stwa	%r23, [%r30 + 0x0000] %asi
	.word 0xeedf2000  ! 456: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r23
	.word 0x87802020  ! 457: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 458: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeecfe000  ! 459: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r23
	.word 0xe8f70e80  ! 460: STXA_R	stxa	%r20, [%r28 + %r0] 0x74
	.word 0xeab72000  ! 461: STHA_I	stha	%r21, [%r28 + 0x0000] %asi
	mov	0x40, %r19
	.word 0x87802025  ! 463: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4f7ce60  ! 464: STXA_R	stxa	%r18, [%r31 + %r0] 0x73
	.word 0x87802074  ! 465: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 466: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xee86e000  ! 467: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r23
	mov	0x7f0, %r23
	.word 0x87802074  ! 469: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 470: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeef62000  ! 471: STXA_I	stxa	%r23, [%r24 + 0x0000] %asi
	.word 0xeeb62000  ! 472: STHA_I	stha	%r23, [%r24 + 0x0000] %asi
	mov	0x78, %r18
	mov	0x30, %r19
	.word 0x87802020  ! 475: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xee9c2000  ! 476: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r23
	.word 0xeebce000  ! 477: STDA_I	stda	%r23, [%r19 + 0x0000] %asi
	.word 0xeaf7ce80  ! 478: STXA_R	stxa	%r21, [%r31 + %r0] 0x74
	.word 0xe2c74e60  ! 479: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r17
	.word 0xe2dce000  ! 480: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r17
	.word 0xe2cce000  ! 481: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r17
	.word 0xe0848400  ! 482: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r16
	.word 0xe2aca000  ! 483: STBA_I	stba	%r17, [%r18 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xe2ac2000  ! 485: STBA_I	stba	%r17, [%r16 + 0x0000] %asi
	.word 0xe2846000  ! 486: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r17
	.word 0xe2b584a0  ! 487: STHA_R	stha	%r17, [%r22 + %r0] 0x25
	.word 0xe6bc2000  ! 488: STDA_I	stda	%r19, [%r16 + 0x0000] %asi
	.word 0xe6a4a000  ! 489: STWA_I	stwa	%r19, [%r18 + 0x0000] %asi
	.word 0xe6aca000  ! 490: STBA_I	stba	%r19, [%r18 + 0x0000] %asi
	.word 0xe6842000  ! 491: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r19
	.word 0x87802020  ! 492: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r21
	mov	0x3c8, %r23
	.word 0xe4acc400  ! 495: STBA_R	stba	%r18, [%r19 + %r0] 0x20
	mov	0x50, %r25
	.word 0x87802020  ! 497: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r21
	.word 0xe2a4c400  ! 499: STWA_R	stwa	%r17, [%r19 + %r0] 0x20
	.word 0x87802073  ! 500: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe884a000  ! 501: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r20
	mov	0x3e8, %r22
	.word 0xe8d4a000  ! 503: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r20
	.word 0xe8942000  ! 504: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r20
	.word 0xe884a000  ! 505: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r20
	.word 0x87802073  ! 506: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xee9584a0  ! 507: LDUHA_R	lduha	[%r22, %r0] 0x25, %r23
	.word 0xe2cf8e40  ! 508: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r17
	.word 0xee9ca000  ! 509: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r23
	.word 0xeebe89e0  ! 510: STDA_R	stda	%r23, [%r26 + %r0] 0x4f
	mov	0x78, %r19
	.word 0xe8c5c4a0  ! 512: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r20
	.word 0xecc7ce60  ! 513: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r22
	.word 0xe49e49e0  ! 514: LDDA_R	ldda	[%r25, %r0] 0x4f, %r18
	.word 0xecc4c400  ! 515: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r22
	mov	0x3d0, %r22
	.word 0x8780204f  ! 517: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r19
	.word 0xe0cf6000  ! 519: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r16
	.word 0xe0876000  ! 520: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r16
	.word 0xe0a72000  ! 521: STWA_I	stwa	%r16, [%r28 + 0x0000] %asi
	.word 0xe0b7e000  ! 522: STHA_I	stha	%r16, [%r31 + 0x0000] %asi
	.word 0xe4c609e0  ! 523: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r18
	.word 0xe89fa000  ! 524: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r20
	.word 0xe8bf2000  ! 525: STDA_I	stda	%r20, [%r28 + 0x0000] %asi
	.word 0xe8972000  ! 526: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r20
	.word 0xec9504a0  ! 527: LDUHA_R	lduha	[%r20, %r0] 0x25, %r22
	.word 0xeeafe000  ! 528: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0xeef76000  ! 529: STXA_I	stxa	%r23, [%r29 + 0x0000] %asi
	.word 0xeeafa000  ! 530: STBA_I	stba	%r23, [%r30 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xe0f40400  ! 532: STXA_R	stxa	%r16, [%r16 + %r0] 0x20
	.word 0xe4870e60  ! 533: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r18
	mov	0x28, %r17
	.word 0xe4cf8e60  ! 535: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r18
	mov	0x60, %r16
	.word 0xe6f72000  ! 537: STXA_I	stxa	%r19, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe68f2000  ! 539: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r19
	.word 0x87802020  ! 540: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0b5c4a0  ! 541: STHA_R	stha	%r16, [%r23 + %r0] 0x25
	mov	0x40, %r17
	.word 0xeeafe000  ! 543: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0xeeafe000  ! 544: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0xeed76000  ! 545: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r23
	.word 0xeebf2000  ! 546: STDA_I	stda	%r23, [%r28 + 0x0000] %asi
	.word 0xeec7a000  ! 547: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r23
	.word 0x87802072  ! 548: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xeef7e000  ! 550: STXA_I	stxa	%r23, [%r31 + 0x0000] %asi
	.word 0xeeb76000  ! 551: STHA_I	stha	%r23, [%r29 + 0x0000] %asi
	.word 0xeebfa000  ! 552: STDA_I	stda	%r23, [%r30 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xeedfe000  ! 554: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r23
	.word 0x87802074  ! 555: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xea878e40  ! 556: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r21
	.word 0xe2f4c400  ! 557: STXA_R	stxa	%r17, [%r19 + %r0] 0x20
	.word 0xe297e000  ! 558: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r17
	.word 0xecaf0e80  ! 559: STBA_R	stba	%r22, [%r28 + %r0] 0x74
	mov	0x78, %r19
	.word 0xecb7e000  ! 561: STHA_I	stha	%r22, [%r31 + 0x0000] %asi
	.word 0xe0c609e0  ! 562: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r16
	mov	0x7d8, %r21
	.word 0xe6f72000  ! 564: STXA_I	stxa	%r19, [%r28 + 0x0000] %asi
	.word 0xec8c0400  ! 565: LDUBA_R	lduba	[%r16, %r0] 0x20, %r22
	.word 0xe6cfa000  ! 566: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r19
	.word 0xecdc8400  ! 567: LDXA_R	ldxa	[%r18, %r0] 0x20, %r22
	.word 0xead48400  ! 568: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r21
	.word 0xecacc400  ! 569: STBA_R	stba	%r22, [%r19 + %r0] 0x20
	.word 0xec8504a0  ! 570: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r22
	.word 0xeec7ce60  ! 571: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r23
	.word 0xea9e49e0  ! 572: LDDA_R	ldda	[%r25, %r0] 0x4f, %r21
	.word 0xe4f72000  ! 573: STXA_I	stxa	%r18, [%r28 + 0x0000] %asi
	.word 0xe6a609e0  ! 574: STWA_R	stwa	%r19, [%r24 + %r0] 0x4f
	.word 0xeaf76000  ! 575: STXA_I	stxa	%r21, [%r29 + 0x0000] %asi
	mov	0x50, %r24
	.word 0x87802072  ! 577: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeadca000  ! 578: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r21
	.word 0x87802020  ! 579: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea84e000  ! 580: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r21
	.word 0xead48400  ! 581: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r21
	.word 0xeeb40400  ! 582: STHA_R	stha	%r23, [%r16 + %r0] 0x20
	.word 0xe0aca000  ! 583: STBA_I	stba	%r16, [%r18 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xe0bc2000  ! 585: STDA_I	stda	%r16, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 586: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0f76000  ! 587: STXA_I	stxa	%r16, [%r29 + 0x0000] %asi
	.word 0xeaaf0e40  ! 588: STBA_R	stba	%r21, [%r28 + %r0] 0x72
	.word 0xe6d78e40  ! 589: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r19
	mov	0x3e0, %r20
	.word 0xe6872000  ! 591: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r19
	wr_tick_cmpr_3_3:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x80, %g2
	or	%g4, 0xb4, %g4
	or	%g6, 0xf9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeebec9e0  ! 593: STDA_R	stda	%r23, [%r27 + %r0] 0x4f
	.word 0xecbf6000  ! 594: STDA_I	stda	%r22, [%r29 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xec872000  ! 596: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r22
	.word 0xe0bec9e0  ! 597: STDA_R	stda	%r16, [%r27 + %r0] 0x4f
	.word 0xec97e000  ! 598: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r22
	.word 0xec97e000  ! 599: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r22
	.word 0xeea504a0  ! 600: STWA_R	stwa	%r23, [%r20 + %r0] 0x25
	.word 0xe4be09e0  ! 601: STDA_R	stda	%r18, [%r24 + %r0] 0x4f
	.word 0xe0d5c4a0  ! 602: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r16
	.word 0xe6f7a000  ! 603: STXA_I	stxa	%r19, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 604: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 605: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeeb44400  ! 606: STHA_R	stha	%r23, [%r17 + %r0] 0x20
	.word 0xe0a7e000  ! 607: STWA_I	stwa	%r16, [%r31 + 0x0000] %asi
	mov	0x78, %r26
	.word 0xe494c400  ! 609: LDUHA_R	lduha	[%r19, %r0] 0x20, %r18
	.word 0x87802020  ! 610: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4a44400  ! 611: STWA_R	stwa	%r18, [%r17 + %r0] 0x20
	.word 0xeea76000  ! 612: STWA_I	stwa	%r23, [%r29 + 0x0000] %asi
	.word 0xee97e000  ! 613: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r23
	.word 0xeef72000  ! 614: STXA_I	stxa	%r23, [%r28 + 0x0000] %asi
	.word 0xe8bf4e60  ! 615: STDA_R	stda	%r20, [%r29 + %r0] 0x73
	.word 0xeede89e0  ! 616: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r23
	.word 0x87802074  ! 617: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0bf6000  ! 618: STDA_I	stda	%r16, [%r29 + 0x0000] %asi
	.word 0xea9c4400  ! 619: LDDA_R	ldda	[%r17, %r0] 0x20, %r21
	.word 0x87802073  ! 620: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4b70e40  ! 621: STHA_R	stha	%r18, [%r28 + %r0] 0x72
	.word 0x87802025  ! 622: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecbf4e40  ! 623: STDA_R	stda	%r22, [%r29 + %r0] 0x72
	.word 0xeacfce80  ! 624: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r21
	.word 0xe4cfe000  ! 625: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r18
	.word 0xe88e89e0  ! 626: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r20
	.word 0xe0bfce80  ! 627: STDA_R	stda	%r16, [%r31 + %r0] 0x74
	mov	0x7d0, %r21
	wr_tick_cmpr_3_4:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xcf, %g2
	or	%g4, 0x9b, %g4
	or	%g6, 0xd3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x50, %r24
	wr_tick_cmpr_3_5:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x91, %g2
	or	%g4, 0x91, %g4
	or	%g6, 0x88, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeecc0400  ! 632: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r23
	.word 0x87802073  ! 633: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r18
	mov	0x10, %r25
	.word 0xe4876000  ! 636: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r18
	.word 0xe4872000  ! 637: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r18
	.word 0xeeafce80  ! 638: STBA_R	stba	%r23, [%r31 + %r0] 0x74
	.word 0xe69f0e80  ! 639: LDDA_R	ldda	[%r28, %r0] 0x74, %r19
	.word 0xec97e000  ! 640: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r22
	mov	0x70, %r18
	mov	0x8, %r26
	.word 0x87802020  ! 643: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe09649e0  ! 644: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r16
	mov	0x70, %r17
	.word 0xe4a4a000  ! 646: STWA_I	stwa	%r18, [%r18 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xe6870e80  ! 648: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r19
	.word 0xe4b689e0  ! 649: STHA_R	stha	%r18, [%r26 + %r0] 0x4f
	.word 0xe4974e80  ! 650: LDUHA_R	lduha	[%r29, %r0] 0x74, %r18
	.word 0xea940400  ! 651: LDUHA_R	lduha	[%r16, %r0] 0x20, %r21
	.word 0xe8a48400  ! 652: STWA_R	stwa	%r20, [%r18 + %r0] 0x20
	.word 0xe6c78e40  ! 653: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r19
	.word 0xe8b4e000  ! 654: STHA_I	stha	%r20, [%r19 + 0x0000] %asi
	mov	0x78, %r17
	mov	0x3f0, %r23
	mov	0x3f0, %r20
	mov	0x68, %r25
	mov	0x70, %r17
	mov	0x7f0, %r21
	mov	0x3e0, %r22
	.word 0xeede89e0  ! 662: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r23
	.word 0x87802025  ! 663: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2acc400  ! 664: STBA_R	stba	%r17, [%r19 + %r0] 0x20
	.word 0xe4cf6000  ! 665: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r18
	.word 0xe4df6000  ! 666: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r18
	mov	0x7e8, %r20
	.word 0x8780204f  ! 668: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r25
	wr_tick_cmpr_3_6:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x89, %g2
	or	%g4, 0xd4, %g4
	or	%g6, 0xc0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe4c46000  ! 671: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r18
	.word 0xe4ace000  ! 672: STBA_I	stba	%r18, [%r19 + 0x0000] %asi
	.word 0xe8c5c4a0  ! 673: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r20
	.word 0x87802020  ! 674: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaaf8e40  ! 675: STBA_R	stba	%r21, [%r30 + %r0] 0x72
	.word 0x87802072  ! 676: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xecc544a0  ! 678: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r22
	.word 0xe6afa000  ! 679: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xe68fe000  ! 681: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r19
	.word 0x87802072  ! 682: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 683: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6d66000  ! 684: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r19
	.word 0xeaa70e40  ! 685: STWA_R	stwa	%r21, [%r28 + %r0] 0x72
	.word 0xe2acc400  ! 686: STBA_R	stba	%r17, [%r19 + %r0] 0x20
	mov	0x48, %r19
	.word 0xeaf62000  ! 688: STXA_I	stxa	%r21, [%r24 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xeeb48400  ! 690: STHA_R	stha	%r23, [%r18 + %r0] 0x20
	mov	0x8, %r18
	.word 0xe6d66000  ! 692: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r19
	.word 0xe2b48400  ! 693: STHA_R	stha	%r17, [%r18 + %r0] 0x20
	.word 0xe8c66000  ! 694: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r20
	.word 0xe0d78e40  ! 695: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r16
	.word 0xe29fce60  ! 696: LDDA_R	ldda	[%r31, %r0] 0x73, %r17
	.word 0xe08c4400  ! 697: LDUBA_R	lduba	[%r17, %r0] 0x20, %r16
	.word 0xe6b62000  ! 698: STHA_I	stha	%r19, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 699: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6dee000  ! 700: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r19
	mov	0x58, %r24
	.word 0x87802020  ! 702: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0d6c9e0  ! 703: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r16
	.word 0x87802020  ! 704: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r19
	.word 0xe68c6000  ! 706: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r19
	.word 0x87802020  ! 707: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6aca000  ! 708: STBA_I	stba	%r19, [%r18 + 0x0000] %asi
	.word 0xe6948400  ! 709: LDUHA_R	lduha	[%r18, %r0] 0x20, %r19
	mov	0x40, %r26
	.word 0xe8cce000  ! 711: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r20
	.word 0xe88ca000  ! 712: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r20
	.word 0xe89c6000  ! 713: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r20
	.word 0xeab5c4a0  ! 714: STHA_R	stha	%r21, [%r23 + %r0] 0x25
	mov	0x48, %r18
	.word 0xe68ca000  ! 716: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r19
	.word 0xe2c44400  ! 717: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r17
	mov	0x70, %r17
	.word 0xe8bce000  ! 719: STDA_I	stda	%r20, [%r19 + 0x0000] %asi
	.word 0xe89ce000  ! 720: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r20
	mov	0x78, %r16
	.word 0xe8b4e000  ! 722: STHA_I	stha	%r20, [%r19 + 0x0000] %asi
	.word 0xe8b4a000  ! 723: STHA_I	stha	%r20, [%r18 + 0x0000] %asi
	.word 0xe8c46000  ! 724: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r20
	.word 0xe2cfce40  ! 725: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r17
	.word 0xea9fce80  ! 726: LDDA_R	ldda	[%r31, %r0] 0x74, %r21
	.word 0xeeb4a000  ! 727: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xeedce000  ! 729: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r23
	.word 0xeef4a000  ! 730: STXA_I	stxa	%r23, [%r18 + 0x0000] %asi
	.word 0xeca78e40  ! 731: STWA_R	stwa	%r22, [%r30 + %r0] 0x72
	.word 0xe0a4a000  ! 732: STWA_I	stwa	%r16, [%r18 + 0x0000] %asi
	.word 0xe0f4e000  ! 733: STXA_I	stxa	%r16, [%r19 + 0x0000] %asi
	.word 0xe09c2000  ! 734: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r16
	.word 0xe0d4e000  ! 735: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r16
	.word 0xe0c504a0  ! 736: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r16
	.word 0xeacf8e80  ! 737: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r21
	wr_tick_cmpr_3_7:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xef, %g2
	or	%g4, 0xf9, %g4
	or	%g6, 0xb7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeac70e40  ! 739: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r21
	mov	0x7e0, %r22
	.word 0x8780204f  ! 741: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0bce000  ! 742: STDA_I	stda	%r16, [%r19 + 0x0000] %asi
	.word 0xe4af8e40  ! 743: STBA_R	stba	%r18, [%r30 + %r0] 0x72
	.word 0xeef46000  ! 744: STXA_I	stxa	%r23, [%r17 + 0x0000] %asi
	mov	0x18, %r24
	mov	0x68, %r16
	.word 0x87802020  ! 747: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeeafa000  ! 748: STBA_I	stba	%r23, [%r30 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xeebfa000  ! 750: STDA_I	stda	%r23, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 751: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeebea000  ! 752: STDA_I	stda	%r23, [%r26 + 0x0000] %asi
	.word 0xee8ee000  ! 753: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r23
	.word 0xeeaee000  ! 754: STBA_I	stba	%r23, [%r27 + 0x0000] %asi
	mov	0x58, %r27
	.word 0x87802074  ! 756: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2c504a0  ! 757: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r17
	.word 0x87802020  ! 758: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r18
	mov	0x40, %r24
	.word 0xe2df6000  ! 761: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r17
	.word 0xe2f48400  ! 762: STXA_R	stxa	%r17, [%r18 + %r0] 0x20
	mov	0x7c0, %r23
	.word 0xe2c6c9e0  ! 764: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r17
	.word 0xe0a72000  ! 765: STWA_I	stwa	%r16, [%r28 + 0x0000] %asi
	.word 0xe0af2000  ! 766: STBA_I	stba	%r16, [%r28 + 0x0000] %asi
	.word 0xe0d7e000  ! 767: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r16
	mov	0x60, %r26
	.word 0xe09fa000  ! 769: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r16
	.word 0xe08fe000  ! 770: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r16
	.word 0xe0afa000  ! 771: STBA_I	stba	%r16, [%r30 + 0x0000] %asi
	mov	0x3d0, %r23
	mov	0x8, %r27
	.word 0x87802073  ! 774: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r23
	mov	0x18, %r18
	mov	0x78, %r26
	mov	0x58, %r16
	.word 0xe2970e40  ! 779: LDUHA_R	lduha	[%r28, %r0] 0x72, %r17
	.word 0xe294a000  ! 780: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r17
	mov	0x70, %r26
	.word 0xe29ca000  ! 782: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r17
	.word 0xe8d584a0  ! 783: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r20
	mov	0x60, %r17
	mov	0x58, %r18
	.word 0xeacca000  ! 786: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r21
	.word 0x87802020  ! 787: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeab7e000  ! 788: STHA_I	stha	%r21, [%r31 + 0x0000] %asi
	.word 0xeeb44400  ! 789: STHA_R	stha	%r23, [%r17 + %r0] 0x20
	.word 0x87802073  ! 790: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xecc76000  ! 791: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0xe097ce60  ! 792: LDUHA_R	lduha	[%r31, %r0] 0x73, %r16
	.word 0xec876000  ! 793: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r22
	mov	0x7e8, %r21
	.word 0xecacc400  ! 795: STBA_R	stba	%r22, [%r19 + %r0] 0x20
	.word 0xe0bf6000  ! 796: STDA_I	stda	%r16, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 797: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_3_8:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf7, %g2
	or	%g4, 0x8d, %g4
	or	%g6, 0xa4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 799: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0dee000  ! 800: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r16
	mov	0x30, %r27
	.word 0x87802073  ! 802: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 803: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0d46000  ! 804: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r16
	.word 0xe0c46000  ! 805: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r16
	.word 0xe0bc2000  ! 806: STDA_I	stda	%r16, [%r16 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xeeafce80  ! 808: STBA_R	stba	%r23, [%r31 + %r0] 0x74
	.word 0xea878e60  ! 809: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r21
	.word 0xe8ac2000  ! 810: STBA_I	stba	%r20, [%r16 + 0x0000] %asi
	mov	0x20, %r26
	.word 0xe4dfce40  ! 812: LDXA_R	ldxa	[%r31, %r0] 0x72, %r18
	mov	0x3c8, %r22
	wr_tick_cmpr_3_9:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb2, %g2
	or	%g4, 0x8a, %g4
	or	%g6, 0xa4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 815: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a46000  ! 816: STWA_I	stwa	%r16, [%r17 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xe2b70e40  ! 818: STHA_R	stha	%r17, [%r28 + %r0] 0x72
	mov	0x28, %r16
	.word 0xeedca000  ! 820: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r23
	.word 0xeeb4e000  ! 821: STHA_I	stha	%r23, [%r19 + 0x0000] %asi
	wr_tick_cmpr_3_10:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb3, %g2
	or	%g4, 0xf9, %g4
	or	%g6, 0x84, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x18, %r25
	.word 0xe08d44a0  ! 824: LDUBA_R	lduba	[%r21, %r0] 0x25, %r16
	.word 0xe4dd84a0  ! 825: LDXA_R	ldxa	[%r22, %r0] 0x25, %r18
	mov	0x3f0, %r21
	.word 0xe0bca000  ! 827: STDA_I	stda	%r16, [%r18 + 0x0000] %asi
	.word 0xe0cca000  ! 828: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r16
	.word 0x87802072  ! 829: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe88ec9e0  ! 830: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r20
	mov	0x20, %r27
	.word 0xeac6c9e0  ! 832: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r21
	.word 0xe29e89e0  ! 833: LDDA_R	ldda	[%r26, %r0] 0x4f, %r17
	.word 0xeca56000  ! 834: STWA_I	stwa	%r22, [%r21 + 0x0000] %asi
	.word 0xee8fce60  ! 835: LDUBA_R	lduba	[%r31, %r0] 0x73, %r23
	.word 0xe6dd6000  ! 836: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r19
	.word 0xe4adc4a0  ! 837: STBA_R	stba	%r18, [%r23 + %r0] 0x25
	.word 0xe0c52000  ! 838: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r16
	.word 0xe0cde000  ! 839: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r16
	.word 0x87802025  ! 840: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xea948400  ! 841: LDUHA_R	lduha	[%r18, %r0] 0x20, %r21
	mov	0x70, %r17
	.word 0xe0a48400  ! 843: STWA_R	stwa	%r16, [%r18 + %r0] 0x20
	.word 0xe4f78e60  ! 844: STXA_R	stxa	%r18, [%r30 + %r0] 0x73
	.word 0xeebc8400  ! 845: STDA_R	stda	%r23, [%r18 + %r0] 0x20
	mov	0x7e8, %r23
	.word 0xea9ea000  ! 847: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r21
	mov	0x68, %r24
	.word 0x8780204f  ! 849: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4b5c4a0  ! 850: STHA_R	stha	%r18, [%r23 + %r0] 0x25
	.word 0xe8c609e0  ! 851: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r20
	.word 0xea9544a0  ! 852: LDUHA_R	lduha	[%r21, %r0] 0x25, %r21
	.word 0xe2f72000  ! 853: STXA_I	stxa	%r17, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 854: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeabec9e0  ! 855: STDA_R	stda	%r21, [%r27 + %r0] 0x4f
	mov	0x8, %r17
	.word 0xec862000  ! 857: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r22
	.word 0x87802020  ! 858: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecdf6000  ! 859: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r22
	.word 0x87802020  ! 860: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec8fa000  ! 861: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r22
	.word 0x87802020  ! 862: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeebe49e0  ! 863: STDA_R	stda	%r23, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 864: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8c689e0  ! 865: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r20
	mov	0x7d8, %r22
	.word 0xeea76000  ! 867: STWA_I	stwa	%r23, [%r29 + 0x0000] %asi
	.word 0xeecf2000  ! 868: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r23
	.word 0xeebfe000  ! 869: STDA_I	stda	%r23, [%r31 + 0x0000] %asi
	.word 0xe89f8e60  ! 870: LDDA_R	ldda	[%r30, %r0] 0x73, %r20
	.word 0x87802020  ! 871: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeed5c4a0  ! 872: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r23
	.word 0x87802025  ! 873: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4f72000  ! 874: STXA_I	stxa	%r18, [%r28 + 0x0000] %asi
	.word 0xe48fa000  ! 875: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r18
	mov	0x68, %r25
	mov	0x50, %r19
	.word 0xe0df0e40  ! 878: LDXA_R	ldxa	[%r28, %r0] 0x72, %r16
	.word 0xe2876000  ! 879: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r17
	.word 0x87802073  ! 880: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0bcc400  ! 881: STDA_R	stda	%r16, [%r19 + %r0] 0x20
	.word 0xe8a4a000  ! 882: STWA_I	stwa	%r20, [%r18 + 0x0000] %asi
	.word 0xe8dca000  ! 883: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r20
	.word 0xecc78e40  ! 884: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r22
	mov	0x7c8, %r21
	mov	0x3c0, %r22
	.word 0xec844400  ! 887: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r22
	.word 0xe2b609e0  ! 888: STHA_R	stha	%r17, [%r24 + %r0] 0x4f
	.word 0xe0ac6000  ! 889: STBA_I	stba	%r16, [%r17 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xee94c400  ! 891: LDUHA_R	lduha	[%r19, %r0] 0x20, %r23
	.word 0xee870e60  ! 892: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r23
	mov	0x60, %r26
	.word 0x87802072  ! 894: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2942000  ! 895: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r17
	.word 0x87802072  ! 896: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r24
	mov	0x68, %r26
	.word 0xe29da000  ! 899: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r17
	.word 0x87802072  ! 900: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0cf8e60  ! 901: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r16
	mov	0x38, %r26
	.word 0x87802074  ! 903: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeea74e40  ! 904: STWA_R	stwa	%r23, [%r29 + %r0] 0x72
	.word 0xe2bc6000  ! 905: STDA_I	stda	%r17, [%r17 + 0x0000] %asi
	.word 0xe2b4a000  ! 906: STHA_I	stha	%r17, [%r18 + 0x0000] %asi
	.word 0xe28c4400  ! 907: LDUBA_R	lduba	[%r17, %r0] 0x20, %r17
	.word 0xe6bf0e40  ! 908: STDA_R	stda	%r19, [%r28 + %r0] 0x72
	.word 0xe0cc0400  ! 909: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r16
	mov	0x70, %r25
	mov	0x50, %r24
	.word 0xecbca000  ! 912: STDA_I	stda	%r22, [%r18 + 0x0000] %asi
	.word 0xec946000  ! 913: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r22
	.word 0xecb4a000  ! 914: STHA_I	stha	%r22, [%r18 + 0x0000] %asi
	.word 0xe6cfce80  ! 915: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r19
	mov	0x3f0, %r22
	.word 0xe6cce000  ! 917: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r19
	.word 0xe684e000  ! 918: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r19
	.word 0xe6f584a0  ! 919: STXA_R	stxa	%r19, [%r22 + %r0] 0x25
	.word 0xe8a42000  ! 920: STWA_I	stwa	%r20, [%r16 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xe4c78e80  ! 922: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r18
	.word 0x87802074  ! 923: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2a70e60  ! 924: STWA_R	stwa	%r17, [%r28 + %r0] 0x73
	.word 0xeec70e80  ! 925: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r23
	.word 0xe08ca000  ! 926: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r16
	.word 0xe09ce000  ! 927: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r16
	mov	0x3f0, %r20
	.word 0x87802074  ! 929: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r26
	.word 0xe0bc2000  ! 931: STDA_I	stda	%r16, [%r16 + 0x0000] %asi
	mov	0x8, %r24
	mov	0x18, %r19
	wr_tick_cmpr_3_11:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc5, %g2
	or	%g4, 0x9b, %g4
	or	%g6, 0xfe, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeeaf0e60  ! 935: STBA_R	stba	%r23, [%r28 + %r0] 0x73
	.word 0xe09ce000  ! 936: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r16
	mov	0x7f0, %r22
	.word 0xe0bc6000  ! 938: STDA_I	stda	%r16, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 939: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 941: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe08e6000  ! 942: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r16
	.word 0xe0a62000  ! 943: STWA_I	stwa	%r16, [%r24 + 0x0000] %asi
	.word 0xe0c689e0  ! 944: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r16
	.word 0x87802074  ! 945: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe09dc4a0  ! 946: LDDA_R	ldda	[%r23, %r0] 0x25, %r16
	.word 0xe2ccc400  ! 947: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r17
	.word 0xe6b584a0  ! 948: STHA_R	stha	%r19, [%r22 + %r0] 0x25
	.word 0xecc4c400  ! 949: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r22
	wr_tick_cmpr_3_12:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa2, %g2
	or	%g4, 0xe8, %g4
	or	%g6, 0x87, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 951: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0af6000  ! 952: STBA_I	stba	%r16, [%r29 + 0x0000] %asi
	.word 0xe09fa000  ! 953: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r16
	mov	0x20, %r19
	.word 0xe097e000  ! 955: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r16
	mov	0x10, %r25
	.word 0xe0af6000  ! 957: STBA_I	stba	%r16, [%r29 + 0x0000] %asi
	.word 0xe0f76000  ! 958: STXA_I	stxa	%r16, [%r29 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x7c0, %r23
	.word 0xe0a7e000  ! 961: STWA_I	stwa	%r16, [%r31 + 0x0000] %asi
	mov	0x0, %r27
	mov	0x0, %r18
	.word 0x8780204f  ! 964: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0bca000  ! 965: STDA_I	stda	%r16, [%r18 + 0x0000] %asi
	.word 0xe0d4a000  ! 966: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r16
	.word 0xec874e40  ! 967: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r22
	.word 0xe0f46000  ! 968: STXA_I	stxa	%r16, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 969: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r27
	.word 0x87802072  ! 971: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 972: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0ade000  ! 973: STBA_I	stba	%r16, [%r23 + 0x0000] %asi
	.word 0xe09de000  ! 974: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r16
	.word 0xea8f0e80  ! 975: LDUBA_R	lduba	[%r28, %r0] 0x74, %r21
	.word 0xeea7ce40  ! 976: STWA_R	stwa	%r23, [%r31 + %r0] 0x72
	.word 0xe2a584a0  ! 977: STWA_R	stwa	%r17, [%r22 + %r0] 0x25
	mov	0x40, %r25
	.word 0x87802074  ! 979: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r23
	.word 0x87802025  ! 981: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8d40400  ! 982: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r20
	.word 0xe4f5a000  ! 983: STXA_I	stxa	%r18, [%r22 + 0x0000] %asi
	.word 0xe4a56000  ! 984: STWA_I	stwa	%r18, [%r21 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xe4a56000  ! 986: STWA_I	stwa	%r18, [%r21 + 0x0000] %asi
	.word 0xee8d84a0  ! 987: LDUBA_R	lduba	[%r22, %r0] 0x25, %r23
	mov	0x3f0, %r20
	.word 0xe4b78e40  ! 989: STHA_R	stha	%r18, [%r30 + %r0] 0x72
	mov	0x8, %r18
	.word 0x87802020  ! 991: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 992: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r21
	.word 0xe4dfce80  ! 994: LDXA_R	ldxa	[%r31, %r0] 0x74, %r18
	.word 0xeea5e000  ! 995: STWA_I	stwa	%r23, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 996: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r26
	.word 0xee96a000  ! 998: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r23
	mov	0x10, %r26
	mov	0x70, %r19
	.word 0xeeae2000  ! 1001: STBA_I	stba	%r23, [%r24 + 0x0000] %asi
	.word 0xeeae2000  ! 1002: STBA_I	stba	%r23, [%r24 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0x87802020  ! 1004: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeea46000  ! 1005: STWA_I	stwa	%r23, [%r17 + 0x0000] %asi
	mov	0x70, %r17
	.word 0x87802072  ! 1007: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r24
	mov	0x0, %r25
	.word 0x87802074  ! 1010: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r27
	mov	0x38, %r24
	.word 0xeebfce60  ! 1013: STDA_R	stda	%r23, [%r31 + %r0] 0x73
	.word 0xe0ce6000  ! 1014: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r16
	.word 0xe0ae2000  ! 1015: STBA_I	stba	%r16, [%r24 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xe0de2000  ! 1017: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r16
	mov	0x78, %r16
	.word 0x8780204f  ! 1019: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeca74e40  ! 1020: STWA_R	stwa	%r22, [%r29 + %r0] 0x72
	.word 0xeec70e80  ! 1021: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r23
	mov	0x38, %r17
	.word 0xec9c4400  ! 1023: LDDA_R	ldda	[%r17, %r0] 0x20, %r22
	.word 0xee9c8400  ! 1024: LDDA_R	ldda	[%r18, %r0] 0x20, %r23
	mov	0x68, %r25
	.word 0xe4bf8e40  ! 1026: STDA_R	stda	%r18, [%r30 + %r0] 0x72
	.word 0xecc4a000  ! 1027: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r22
	mov	0x7e8, %r23
	mov	0x60, %r17
	.word 0xec846000  ! 1030: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r22
	mov	0x7f8, %r23
	.word 0xe29f8e80  ! 1032: LDDA_R	ldda	[%r30, %r0] 0x74, %r17
	mov	0x70, %r25
	.word 0x87802020  ! 1034: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0f7ce60  ! 1035: STXA_R	stxa	%r16, [%r31 + %r0] 0x73
	.word 0xe8a44400  ! 1036: STWA_R	stwa	%r20, [%r17 + %r0] 0x20
	.word 0xe48cc400  ! 1037: LDUBA_R	lduba	[%r19, %r0] 0x20, %r18
	.word 0xe2cd04a0  ! 1038: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r17
	mov	0x7d8, %r21
	.word 0xeaf609e0  ! 1040: STXA_R	stxa	%r21, [%r24 + %r0] 0x4f
	.word 0xe49fce80  ! 1041: LDDA_R	ldda	[%r31, %r0] 0x74, %r18
	.word 0xe8b7a000  ! 1042: STHA_I	stha	%r20, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1043: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6844400  ! 1044: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r19
	mov	0x48, %r24
	.word 0xeeb46000  ! 1046: STHA_I	stha	%r23, [%r17 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xe89f0e60  ! 1048: LDDA_R	ldda	[%r28, %r0] 0x73, %r20
	.word 0xea8d04a0  ! 1049: LDUBA_R	lduba	[%r20, %r0] 0x25, %r21
	.word 0xe4aca000  ! 1050: STBA_I	stba	%r18, [%r18 + 0x0000] %asi
	.word 0xe4c42000  ! 1051: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r18
	.word 0x87802074  ! 1052: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xee9f4e60  ! 1053: LDDA_R	ldda	[%r29, %r0] 0x73, %r23
	.word 0xeec40400  ! 1054: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r23
	.word 0xe0df0e60  ! 1055: LDXA_R	ldxa	[%r28, %r0] 0x73, %r16
	wr_tick_cmpr_3_13:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf1, %g2
	or	%g4, 0xf0, %g4
	or	%g6, 0x94, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3f0, %r23
	mov	0x70, %r24
	.word 0xe2ae6000  ! 1059: STBA_I	stba	%r17, [%r25 + 0x0000] %asi
	mov	0x8, %r19
	mov	0x60, %r16
	.word 0xe2f6e000  ! 1062: STXA_I	stxa	%r17, [%r27 + 0x0000] %asi
	.word 0xe4f40400  ! 1063: STXA_R	stxa	%r18, [%r16 + %r0] 0x20
	.word 0xe2de6000  ! 1064: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r17
	mov	0x3f0, %r22
	.word 0xe296e000  ! 1066: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r17
	.word 0xe0d584a0  ! 1067: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r16
	.word 0x87802072  ! 1068: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r19
	.word 0xe0bc2000  ! 1070: STDA_I	stda	%r16, [%r16 + 0x0000] %asi
	.word 0xe6f584a0  ! 1071: STXA_R	stxa	%r19, [%r22 + %r0] 0x25
	.word 0xe6b44400  ! 1072: STHA_R	stha	%r19, [%r17 + %r0] 0x20
	.word 0xe8cce000  ! 1073: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r20
	.word 0xe6c48400  ! 1074: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r19
	mov	0x20, %r27
	.word 0xe0ac0400  ! 1076: STBA_R	stba	%r16, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1077: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeeacc400  ! 1078: STBA_R	stba	%r23, [%r19 + %r0] 0x20
	.word 0xe08584a0  ! 1079: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r16
	.word 0x87802025  ! 1080: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r25
	.word 0x87802072  ! 1082: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe49c6000  ! 1083: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r18
	.word 0xe2c504a0  ! 1084: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r17
	mov	0x78, %r18
	.word 0xecbc6000  ! 1086: STDA_I	stda	%r22, [%r17 + 0x0000] %asi
	.word 0xeca4a000  ! 1087: STWA_I	stwa	%r22, [%r18 + 0x0000] %asi
	.word 0xe2b7ce40  ! 1088: STHA_R	stha	%r17, [%r31 + %r0] 0x72
	mov	0x78, %r27
	mov	0x68, %r17
	.word 0xe0f46000  ! 1091: STXA_I	stxa	%r16, [%r17 + 0x0000] %asi
	.word 0xe4bcc400  ! 1092: STDA_R	stda	%r18, [%r19 + %r0] 0x20
	mov	0x7d8, %r23
	.word 0xeabdc4a0  ! 1094: STDA_R	stda	%r21, [%r23 + %r0] 0x25
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3e8, %r21
	.word 0xeaf70e60  ! 1097: STXA_R	stxa	%r21, [%r28 + %r0] 0x73
	mov	0x0, %r17
	.word 0xe69fce80  ! 1099: LDDA_R	ldda	[%r31, %r0] 0x74, %r19
	.word 0xeabc2000  ! 1100: STDA_I	stda	%r21, [%r16 + 0x0000] %asi
	.word 0xec86c9e0  ! 1101: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r22
	.word 0xee8649e0  ! 1102: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r23
	mov	0x3f0, %r22
	.word 0xe8d70e60  ! 1104: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r20
	.word 0xeac4c400  ! 1105: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r21
	.word 0xee9689e0  ! 1106: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r23
	.word 0xe6bc6000  ! 1107: STDA_I	stda	%r19, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 1108: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r25
	.word 0xe2a504a0  ! 1110: STWA_R	stwa	%r17, [%r20 + %r0] 0x25
	.word 0xe6f48400  ! 1111: STXA_R	stxa	%r19, [%r18 + %r0] 0x20
	.word 0xee9c0400  ! 1112: LDDA_R	ldda	[%r16, %r0] 0x20, %r23
	.word 0xe6dfe000  ! 1113: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r19
	.word 0xe4b40400  ! 1114: STHA_R	stha	%r18, [%r16 + %r0] 0x20
	mov	0x78, %r27
	mov	0x78, %r18
	.word 0xe4ac4400  ! 1117: STBA_R	stba	%r18, [%r17 + %r0] 0x20
	mov	0x10, %r26
	.word 0x87802020  ! 1119: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r17
	.word 0xe684a000  ! 1121: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r19
	.word 0xe4c78e80  ! 1122: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r18
	.word 0xeaa4e000  ! 1123: STWA_I	stwa	%r21, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 1124: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeac52000  ! 1125: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r21
	.word 0xeaf5e000  ! 1126: STXA_I	stxa	%r21, [%r23 + 0x0000] %asi
	.word 0xeacda000  ! 1127: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r21
	.word 0xea8da000  ! 1128: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r21
	.word 0x87802020  ! 1129: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaaf2000  ! 1130: STBA_I	stba	%r21, [%r28 + 0x0000] %asi
	.word 0xea8fe000  ! 1131: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r21
	.word 0xeadf6000  ! 1132: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r21
	.word 0x87802074  ! 1133: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6f44400  ! 1134: STXA_R	stxa	%r19, [%r17 + %r0] 0x20
	.word 0xe2ad6000  ! 1135: STBA_I	stba	%r17, [%r21 + 0x0000] %asi
	.word 0xe2852000  ! 1136: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r17
	mov	0x7f0, %r20
	mov	0x58, %r25
	mov	0x8, %r16
	.word 0xe2bd6000  ! 1140: STDA_I	stda	%r17, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 1141: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2bfa000  ! 1142: STDA_I	stda	%r17, [%r30 + 0x0000] %asi
	.word 0xe28f6000  ! 1143: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r17
	mov	0x8, %r19
	.word 0x87802072  ! 1145: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 1146: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeaf44400  ! 1147: STXA_R	stxa	%r21, [%r17 + %r0] 0x20
	.word 0xe89fe000  ! 1148: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r20
	mov	0x0, %r19
	.word 0xe8bfe000  ! 1150: STDA_I	stda	%r20, [%r31 + 0x0000] %asi
	.word 0xe8afa000  ! 1151: STBA_I	stba	%r20, [%r30 + 0x0000] %asi
	.word 0xe8afa000  ! 1152: STBA_I	stba	%r20, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1153: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8d4c400  ! 1154: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r20
	mov	0x40, %r26
	.word 0xe29dc4a0  ! 1156: LDDA_R	ldda	[%r23, %r0] 0x25, %r17
	wr_tick_cmpr_3_14:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf2, %g2
	or	%g4, 0xe4, %g4
	or	%g6, 0xd6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x28, %r16
	.word 0x87802025  ! 1159: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8d584a0  ! 1160: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r20
	.word 0x87802020  ! 1161: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2bd2000  ! 1162: STDA_I	stda	%r17, [%r20 + 0x0000] %asi
	mov	0x78, %r19
	.word 0x87802074  ! 1164: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r20
	.word 0xeab504a0  ! 1166: STHA_R	stha	%r21, [%r20 + %r0] 0x25
	.word 0xe0bfe000  ! 1167: STDA_I	stda	%r16, [%r31 + 0x0000] %asi
	mov	0x20, %r26
	.word 0x87802025  ! 1169: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r21
	.word 0xe0f46000  ! 1171: STXA_I	stxa	%r16, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 1172: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0a4a000  ! 1173: STWA_I	stwa	%r16, [%r18 + 0x0000] %asi
	.word 0xeeaf8e60  ! 1174: STBA_R	stba	%r23, [%r30 + %r0] 0x73
	.word 0xe2b7ce40  ! 1175: STHA_R	stha	%r17, [%r31 + %r0] 0x72
	mov	0x58, %r27
	.word 0xe0ccc400  ! 1177: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r16
	mov	0x7c0, %r23
	mov	0x30, %r18
	.word 0xe6f74e40  ! 1180: STXA_R	stxa	%r19, [%r29 + %r0] 0x72
	.word 0xecbce000  ! 1181: STDA_I	stda	%r22, [%r19 + 0x0000] %asi
	.word 0xecf46000  ! 1182: STXA_I	stxa	%r22, [%r17 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xeccc0400  ! 1184: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r22
	.word 0xe2f4a000  ! 1185: STXA_I	stxa	%r17, [%r18 + 0x0000] %asi
	mov	0x3c0, %r22
	mov	0x3d0, %r22
	.word 0xe2b46000  ! 1188: STHA_I	stha	%r17, [%r17 + 0x0000] %asi
	.word 0xe4c584a0  ! 1189: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r18
	.word 0xe6a48400  ! 1190: STWA_R	stwa	%r19, [%r18 + %r0] 0x20
	.word 0xecf78e80  ! 1191: STXA_R	stxa	%r22, [%r30 + %r0] 0x74
	.word 0xe2c70e40  ! 1192: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r17
	.word 0xeac4a000  ! 1193: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r21
	mov	0x18, %r19
	.word 0xe88f8e40  ! 1195: LDUBA_R	lduba	[%r30, %r0] 0x72, %r20
	.word 0xecbca000  ! 1196: STDA_I	stda	%r22, [%r18 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xe4974e80  ! 1198: LDUHA_R	lduha	[%r29, %r0] 0x74, %r18
	mov	0x3d8, %r21
	.word 0xe2cc6000  ! 1200: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r17
	.word 0xe2f46000  ! 1201: STXA_I	stxa	%r17, [%r17 + 0x0000] %asi
	.word 0xe2ae89e0  ! 1202: STBA_R	stba	%r17, [%r26 + %r0] 0x4f
	.word 0xe4cce000  ! 1203: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r18
	.word 0xec970e80  ! 1204: LDUHA_R	lduha	[%r28, %r0] 0x74, %r22
	mov	0x30, %r17
	.word 0xe2874e80  ! 1206: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r17
	.word 0xe89c6000  ! 1207: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r20
	.word 0xeadc8400  ! 1208: LDXA_R	ldxa	[%r18, %r0] 0x20, %r21
	mov	0x3e0, %r22
	mov	0x68, %r16
	mov	0x7c8, %r22
	.word 0xe8bca000  ! 1212: STDA_I	stda	%r20, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 1213: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r21
	.word 0xe8aca000  ! 1215: STBA_I	stba	%r20, [%r18 + 0x0000] %asi
	.word 0xe8cc6000  ! 1216: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r20
	mov	0x60, %r19
	.word 0xe8ac2000  ! 1218: STBA_I	stba	%r20, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 1219: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8be89e0  ! 1220: STDA_R	stda	%r20, [%r26 + %r0] 0x4f
	.word 0xe4a5c4a0  ! 1221: STWA_R	stwa	%r18, [%r23 + %r0] 0x25
	mov	0x38, %r25
	.word 0xe69f0e40  ! 1223: LDDA_R	ldda	[%r28, %r0] 0x72, %r19
	mov	0x3d8, %r20
	mov	0x7d0, %r20
	.word 0xe0aea000  ! 1226: STBA_I	stba	%r16, [%r26 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xe0a62000  ! 1228: STWA_I	stwa	%r16, [%r24 + 0x0000] %asi
	.word 0xe0cf0e60  ! 1229: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r16
	.word 0xeca4c400  ! 1230: STWA_R	stwa	%r22, [%r19 + %r0] 0x20
	.word 0xeaa4c400  ! 1231: STWA_R	stwa	%r21, [%r19 + %r0] 0x20
	.word 0xecb40400  ! 1232: STHA_R	stha	%r22, [%r16 + %r0] 0x20
	.word 0xe8c6e000  ! 1233: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r20
	.word 0xe8f66000  ! 1234: STXA_I	stxa	%r20, [%r25 + 0x0000] %asi
	.word 0xe4b7ce40  ! 1235: STHA_R	stha	%r18, [%r31 + %r0] 0x72
	.word 0xe2de2000  ! 1236: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r17
	mov	0x18, %r17
	mov	0x30, %r16
	.word 0xe6d7ce80  ! 1239: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r19
	.word 0xecaee000  ! 1240: STBA_I	stba	%r22, [%r27 + 0x0000] %asi
	.word 0x87802025  ! 1241: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r20
	.word 0xec96a000  ! 1243: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r22
	.word 0x87802025  ! 1244: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xec8f2000  ! 1245: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r22
	.word 0xe4be89e0  ! 1246: STDA_R	stda	%r18, [%r26 + %r0] 0x4f
	.word 0xeadfce80  ! 1247: LDXA_R	ldxa	[%r31, %r0] 0x74, %r21
	.word 0x87802072  ! 1248: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1249: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xec874e80  ! 1250: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r22
	.word 0x87802072  ! 1251: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe69ca000  ! 1252: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r19
	.word 0xe694e000  ! 1253: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r19
	.word 0xeccc8400  ! 1254: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r22
	mov	0x70, %r17
	.word 0xe48ca000  ! 1256: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r18
	.word 0xeaf70e60  ! 1257: STXA_R	stxa	%r21, [%r28 + %r0] 0x73
	.word 0xe88ce000  ! 1258: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r20
	.word 0xe8aca000  ! 1259: STBA_I	stba	%r20, [%r18 + 0x0000] %asi
	.word 0xe6cc8400  ! 1260: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r19
	.word 0xeab74e80  ! 1261: STHA_R	stha	%r21, [%r29 + %r0] 0x74
	.word 0x87802074  ! 1262: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6ae6000  ! 1263: STBA_I	stba	%r19, [%r25 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0xe48e89e0  ! 1265: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r18
	mov	0x20, %r19
	.word 0xea862000  ! 1267: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r21
	.word 0xeac62000  ! 1268: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r21
	ta	T_CHANGE_HPRIV	! macro
	.word 0xeabe6000  ! 1270: STDA_I	stda	%r21, [%r25 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xe0f78e40  ! 1272: STXA_R	stxa	%r16, [%r30 + %r0] 0x72
	.word 0xeab70e60  ! 1273: STHA_R	stha	%r21, [%r28 + %r0] 0x73
	.word 0xec9c0400  ! 1274: LDDA_R	ldda	[%r16, %r0] 0x20, %r22
	.word 0xeaad04a0  ! 1275: STBA_R	stba	%r21, [%r20 + %r0] 0x25
	mov	0x7d0, %r22
	.word 0xe4a66000  ! 1277: STWA_I	stwa	%r18, [%r25 + 0x0000] %asi
	.word 0xecc4c400  ! 1278: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r22
	.word 0xecde09e0  ! 1279: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r22
	.word 0xeeb6a000  ! 1280: STHA_I	stha	%r23, [%r26 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xeef6a000  ! 1282: STXA_I	stxa	%r23, [%r26 + 0x0000] %asi
	.word 0xe2be89e0  ! 1283: STDA_R	stda	%r17, [%r26 + %r0] 0x4f
	mov	0x7d0, %r20
	mov	0x3c8, %r20
	mov	0x7f0, %r20
	.word 0xe69ea000  ! 1287: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r19
	.word 0x87802020  ! 1288: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2d7ce40  ! 1289: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r17
	mov	0x40, %r26
	.word 0xeaa7e000  ! 1291: STWA_I	stwa	%r21, [%r31 + 0x0000] %asi
	.word 0xe4d584a0  ! 1292: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r18
	.word 0x87802020  ! 1293: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r26
	.word 0xe8b40400  ! 1295: STHA_R	stha	%r20, [%r16 + %r0] 0x20
	.word 0xeaf52000  ! 1296: STXA_I	stxa	%r21, [%r20 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xeadda000  ! 1298: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r21
	.word 0xeab56000  ! 1299: STHA_I	stha	%r21, [%r21 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0x87802074  ! 1301: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xecd78e80  ! 1302: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r22
	.word 0xe085c4a0  ! 1303: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r16
	mov	0x50, %r16
	.word 0xe2f76000  ! 1305: STXA_I	stxa	%r17, [%r29 + 0x0000] %asi
	mov	0x7d0, %r20
	mov	0x70, %r24
	mov	0x0, %r18
	.word 0xe2a7a000  ! 1309: STWA_I	stwa	%r17, [%r30 + 0x0000] %asi
	mov	0x38, %r17
	mov	0x3f0, %r20
	.word 0xeea40400  ! 1312: STWA_R	stwa	%r23, [%r16 + %r0] 0x20
	mov	0x7f8, %r20
	.word 0xe48fa000  ! 1314: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r18
	.word 0xe4d609e0  ! 1315: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r18
	.word 0xead7ce60  ! 1316: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r21
	.word 0xe2c7a000  ! 1317: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r17
	.word 0xe6c74e40  ! 1318: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r19
	.word 0xe2dfe000  ! 1319: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r17
	.word 0xe2d72000  ! 1320: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r17
	.word 0x87802025  ! 1321: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r26
	.word 0xecf70e40  ! 1323: STXA_R	stxa	%r22, [%r28 + %r0] 0x72
	.word 0xe8ae89e0  ! 1324: STBA_R	stba	%r20, [%r26 + %r0] 0x4f
	.word 0xecafce40  ! 1325: STBA_R	stba	%r22, [%r31 + %r0] 0x72
	.word 0xeebfe000  ! 1326: STDA_I	stda	%r23, [%r31 + 0x0000] %asi
	mov	0x70, %r17
	mov	0x18, %r25
	.word 0xee87e000  ! 1329: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r23
	.word 0xe0bf0e80  ! 1330: STDA_R	stda	%r16, [%r28 + %r0] 0x74
	.word 0xee8fa000  ! 1331: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r23
	.word 0xeeaf6000  ! 1332: STBA_I	stba	%r23, [%r29 + 0x0000] %asi
	.word 0xeeaf2000  ! 1333: STBA_I	stba	%r23, [%r28 + 0x0000] %asi
	.word 0xe8cd04a0  ! 1334: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r20
	.word 0xe0bf2000  ! 1335: STDA_I	stda	%r16, [%r28 + 0x0000] %asi
	.word 0xe097e000  ! 1336: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r16
	.word 0xe0a72000  ! 1337: STWA_I	stwa	%r16, [%r28 + 0x0000] %asi
	.word 0xeaa7ce40  ! 1338: STWA_R	stwa	%r21, [%r31 + %r0] 0x72
	mov	0x48, %r25
	.word 0xe0af8e80  ! 1340: STBA_R	stba	%r16, [%r30 + %r0] 0x74
	.word 0xeca649e0  ! 1341: STWA_R	stwa	%r22, [%r25 + %r0] 0x4f
	.word 0xe8f584a0  ! 1342: STXA_R	stxa	%r20, [%r22 + %r0] 0x25
	.word 0xea8fa000  ! 1343: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r21
	.word 0xeed4c400  ! 1344: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r23
	.word 0xecaf0e40  ! 1345: STBA_R	stba	%r22, [%r28 + %r0] 0x72
	.word 0xea8fce80  ! 1346: LDUBA_R	lduba	[%r31, %r0] 0x74, %r21
	.word 0xee87ce60  ! 1347: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r23
	.word 0x87802072  ! 1348: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xead5c4a0  ! 1349: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r21
	mov	0x7f8, %r20
	.word 0xe6cc2000  ! 1351: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r19
	mov	0x7f8, %r20
	mov	0x20, %r26
	.word 0xe6a4a000  ! 1354: STWA_I	stwa	%r19, [%r18 + 0x0000] %asi
	.word 0xe6b4e000  ! 1355: STHA_I	stha	%r19, [%r19 + 0x0000] %asi
	.word 0xe6946000  ! 1356: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r19
	.word 0x87802020  ! 1357: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecad84a0  ! 1358: STBA_R	stba	%r22, [%r22 + %r0] 0x25
	.word 0xeaa5e000  ! 1359: STWA_I	stwa	%r21, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 1360: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r21
	.word 0x87802020  ! 1362: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xead46000  ! 1363: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r21
	.word 0x87802025  ! 1364: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xead7a000  ! 1365: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r21
	mov	0x3f0, %r22
	.word 0x87802073  ! 1367: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeaa4e000  ! 1368: STWA_I	stwa	%r21, [%r19 + 0x0000] %asi
	.word 0xeaf504a0  ! 1369: STXA_R	stxa	%r21, [%r20 + %r0] 0x25
	.word 0xe494e000  ! 1370: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r18
	.word 0x87802020  ! 1371: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1372: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4d56000  ! 1373: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r18
	.word 0xe0d649e0  ! 1374: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r16
	mov	0x68, %r25
	mov	0x10, %r27
	mov	0x7d8, %r20
	.word 0xe0bd2000  ! 1378: STDA_I	stda	%r16, [%r20 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xe0bde000  ! 1380: STDA_I	stda	%r16, [%r23 + 0x0000] %asi
	.word 0xecaec9e0  ! 1381: STBA_R	stba	%r22, [%r27 + %r0] 0x4f
	.word 0xeeaf0e60  ! 1382: STBA_R	stba	%r23, [%r28 + %r0] 0x73
	.word 0xe8ade000  ! 1383: STBA_I	stba	%r20, [%r23 + 0x0000] %asi
	.word 0xe8d5a000  ! 1384: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r20
	.word 0xe885e000  ! 1385: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r20
	.word 0xe8a52000  ! 1386: STWA_I	stwa	%r20, [%r20 + 0x0000] %asi
	.word 0xea8649e0  ! 1387: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r21
	.word 0xea85a000  ! 1388: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r21
	.word 0xeab52000  ! 1389: STHA_I	stha	%r21, [%r20 + 0x0000] %asi
	mov	0x20, %r16
	mov	0x60, %r26
	.word 0xe0978e80  ! 1392: LDUHA_R	lduha	[%r30, %r0] 0x74, %r16
	.word 0xe4b56000  ! 1393: STHA_I	stha	%r18, [%r21 + 0x0000] %asi
	.word 0xe4dde000  ! 1394: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r18
	mov	0x7c0, %r20
	.word 0xe4c5a000  ! 1396: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r18
	.word 0xe4ada000  ! 1397: STBA_I	stba	%r18, [%r22 + 0x0000] %asi
	.word 0xeaa74e80  ! 1398: STWA_R	stwa	%r21, [%r29 + %r0] 0x74
	.word 0xecf74e60  ! 1399: STXA_R	stxa	%r22, [%r29 + %r0] 0x73
	mov	0x3c8, %r22
	.word 0xe28d84a0  ! 1401: LDUBA_R	lduba	[%r22, %r0] 0x25, %r17
	.word 0xe89d6000  ! 1402: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r20
	.word 0xe89d6000  ! 1403: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r20
	.word 0xe8dd2000  ! 1404: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r20
	.word 0xe88689e0  ! 1405: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r20
	.word 0xe4f48400  ! 1406: STXA_R	stxa	%r18, [%r18 + %r0] 0x20
	.word 0xe28f4e80  ! 1407: LDUBA_R	lduba	[%r29, %r0] 0x74, %r17
	.word 0xe0ad2000  ! 1408: STBA_I	stba	%r16, [%r20 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xeef7ce40  ! 1410: STXA_R	stxa	%r23, [%r31 + %r0] 0x72
	.word 0xecb689e0  ! 1411: STHA_R	stha	%r22, [%r26 + %r0] 0x4f
	.word 0xea8d2000  ! 1412: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r21
	.word 0xec84c400  ! 1413: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r22
	mov	0x68, %r24
	.word 0x87802072  ! 1415: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r16
	.word 0xe0c78e60  ! 1417: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r16
	mov	0x58, %r18
	.word 0xe2f689e0  ! 1419: STXA_R	stxa	%r17, [%r26 + %r0] 0x4f
	.word 0xead7e000  ! 1420: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r21
	mov	0x50, %r24
	.word 0xead7e000  ! 1422: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r21
	.word 0x87802020  ! 1423: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeabfe000  ! 1424: STDA_I	stda	%r21, [%r31 + 0x0000] %asi
	mov	0x10, %r16
	.word 0xeaf72000  ! 1426: STXA_I	stxa	%r21, [%r28 + 0x0000] %asi
	mov	0x50, %r18
	mov	0x3e0, %r20
	.word 0xeaa7e000  ! 1429: STWA_I	stwa	%r21, [%r31 + 0x0000] %asi
	.word 0xe4ac0400  ! 1430: STBA_R	stba	%r18, [%r16 + %r0] 0x20
	.word 0xeeb70e80  ! 1431: STHA_R	stha	%r23, [%r28 + %r0] 0x74
	.word 0xe29f6000  ! 1432: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r17
	.word 0xe6dec9e0  ! 1433: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r19
	.word 0xe6cc8400  ! 1434: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r19
	.word 0xea97e000  ! 1435: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r21
	.word 0xeadf2000  ! 1436: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r21
	.word 0xea97e000  ! 1437: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r21
	mov	0x10, %r26
	mov	0x60, %r24
	.word 0xeadfa000  ! 1440: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r21
	.word 0x87802074  ! 1441: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r20
	mov	0x60, %r26
	mov	0x18, %r26
	.word 0xecb7ce60  ! 1445: STHA_R	stha	%r22, [%r31 + %r0] 0x73
	.word 0xe28fce60  ! 1446: LDUBA_R	lduba	[%r31, %r0] 0x73, %r17
	.word 0xe2f70e40  ! 1447: STXA_R	stxa	%r17, [%r28 + %r0] 0x72
	.word 0xe4ad84a0  ! 1448: STBA_R	stba	%r18, [%r22 + %r0] 0x25
	.word 0xe6862000  ! 1449: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r19
	.word 0x87802020  ! 1450: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r19
	.word 0x87802074  ! 1452: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6942000  ! 1453: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r19
	mov	0x70, %r27
	.word 0xe6a46000  ! 1455: STWA_I	stwa	%r19, [%r17 + 0x0000] %asi
	.word 0xe6cce000  ! 1456: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r19
	mov	0x10, %r27
	mov	0x50, %r19
	.word 0xe6a42000  ! 1459: STWA_I	stwa	%r19, [%r16 + 0x0000] %asi
	mov	0x10, %r24
	mov	0x7c0, %r21
	.word 0xe2dc4400  ! 1462: LDXA_R	ldxa	[%r17, %r0] 0x20, %r17
	.word 0xe88c8400  ! 1463: LDUBA_R	lduba	[%r18, %r0] 0x20, %r20
	.word 0xe4bc6000  ! 1464: STDA_I	stda	%r18, [%r17 + 0x0000] %asi
	.word 0xeea689e0  ! 1465: STWA_R	stwa	%r23, [%r26 + %r0] 0x4f
	ta	T_CHANGE_PRIV	! macro
	.word 0xe0a4e000  ! 1467: STWA_I	stwa	%r16, [%r19 + 0x0000] %asi
	.word 0xeacf8e60  ! 1468: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r21
	.word 0xecf4c400  ! 1469: STXA_R	stxa	%r22, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1470: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb72000  ! 1471: STHA_I	stha	%r22, [%r28 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xe6a609e0  ! 1473: STWA_R	stwa	%r19, [%r24 + %r0] 0x4f
	.word 0xe89f2000  ! 1474: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r20
	.word 0x87802074  ! 1475: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeeac8400  ! 1476: STBA_R	stba	%r23, [%r18 + %r0] 0x20
	.word 0xecd6c9e0  ! 1477: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r22
	.word 0xe2ae49e0  ! 1478: STBA_R	stba	%r17, [%r25 + %r0] 0x4f
	.word 0xeef78e80  ! 1479: STXA_R	stxa	%r23, [%r30 + %r0] 0x74
	.word 0xecb72000  ! 1480: STHA_I	stha	%r22, [%r28 + 0x0000] %asi
	.word 0xe4f6c9e0  ! 1481: STXA_R	stxa	%r18, [%r27 + %r0] 0x4f
	mov	0x70, %r26
	mov	0x10, %r19
	.word 0xe8d7e000  ! 1484: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r20
	mov	0x58, %r27
	mov	0x58, %r26
	.word 0xea970e60  ! 1487: LDUHA_R	lduha	[%r28, %r0] 0x73, %r21
	mov	0x8, %r18
	.word 0xe6afe000  ! 1489: STBA_I	stba	%r19, [%r31 + 0x0000] %asi
	.word 0xe6df2000  ! 1490: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r19
	.word 0xe4b7ce40  ! 1491: STHA_R	stha	%r18, [%r31 + %r0] 0x72
	mov	0x58, %r24
	.word 0xe09fa000  ! 1493: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r16
	.word 0xe0cc8400  ! 1494: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r16
	.word 0xeaaf6000  ! 1495: STBA_I	stba	%r21, [%r29 + 0x0000] %asi
	.word 0xe8b74e40  ! 1496: STHA_R	stha	%r20, [%r29 + %r0] 0x72
	.word 0xec9f2000  ! 1497: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r22
	.word 0xe6df8e60  ! 1498: LDXA_R	ldxa	[%r30, %r0] 0x73, %r19
	.word 0x87802020  ! 1499: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1500: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4bf4e80  ! 1501: STDA_R	stda	%r18, [%r29 + %r0] 0x74
	.word 0xe49fa000  ! 1502: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r18
	.word 0xeed584a0  ! 1503: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r23
	mov	0x78, %r18
	.word 0x87802072  ! 1505: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0a649e0  ! 1506: STWA_R	stwa	%r16, [%r25 + %r0] 0x4f
	.word 0xe6bd2000  ! 1507: STDA_I	stda	%r19, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 1508: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r18
	mov	0x50, %r19
	.word 0xeabfce80  ! 1511: STDA_R	stda	%r21, [%r31 + %r0] 0x74
	.word 0xe8aea000  ! 1512: STBA_I	stba	%r20, [%r26 + 0x0000] %asi
	.word 0xe8866000  ! 1513: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r20
	.word 0x87802020  ! 1514: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1515: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2ad44a0  ! 1516: STBA_R	stba	%r17, [%r21 + %r0] 0x25
	.word 0x87802072  ! 1517: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8d42000  ! 1518: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r20
	.word 0x87802072  ! 1519: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8cd2000  ! 1520: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r20
	mov	0x3f8, %r22
	.word 0xe8c52000  ! 1522: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r20
	.word 0xe88d2000  ! 1523: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r20
	.word 0xe4f5c4a0  ! 1524: STXA_R	stxa	%r18, [%r23 + %r0] 0x25
	.word 0xec8e49e0  ! 1525: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r22
	mov	0x18, %r24
	.word 0xeebd2000  ! 1527: STDA_I	stda	%r23, [%r20 + 0x0000] %asi
	.word 0xe4d4c400  ! 1528: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r18
	mov	0x28, %r25
	.word 0xe8840400  ! 1530: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r20
	.word 0xe4a5e000  ! 1531: STWA_I	stwa	%r18, [%r23 + 0x0000] %asi
	.word 0xecbfce40  ! 1532: STDA_R	stda	%r22, [%r31 + %r0] 0x72
	.word 0x87802074  ! 1533: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xee9d6000  ! 1534: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r23
	.word 0xeeb5e000  ! 1535: STHA_I	stha	%r23, [%r23 + 0x0000] %asi
	wr_tick_cmpr_3_15:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xde, %g2
	or	%g4, 0xcf, %g4
	or	%g6, 0xac, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeef4c400  ! 1537: STXA_R	stxa	%r23, [%r19 + %r0] 0x20
	.word 0xe4970e80  ! 1538: LDUHA_R	lduha	[%r28, %r0] 0x74, %r18
	ta	T_CHANGE_HPRIV	! macro
	.word 0xec9c0400  ! 1540: LDDA_R	ldda	[%r16, %r0] 0x20, %r22
	.word 0xec9d6000  ! 1541: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r22
	mov	0x0, %r26
	mov	0x28, %r19
	.word 0xecb52000  ! 1544: STHA_I	stha	%r22, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 1545: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1546: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0afce60  ! 1547: STBA_R	stba	%r16, [%r31 + %r0] 0x73
	.word 0xee8d2000  ! 1548: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r23
	.word 0xe8f48400  ! 1549: STXA_R	stxa	%r20, [%r18 + %r0] 0x20
	.word 0xeed5a000  ! 1550: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r23
	.word 0xeed52000  ! 1551: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r23
	.word 0xeead6000  ! 1552: STBA_I	stba	%r23, [%r21 + 0x0000] %asi
	.word 0xe4a70e40  ! 1553: STWA_R	stwa	%r18, [%r28 + %r0] 0x72
	.word 0xe2d5a000  ! 1554: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r17
	.word 0xe0bf0e60  ! 1555: STDA_R	stda	%r16, [%r28 + %r0] 0x73
	.word 0xe6cc0400  ! 1556: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r19
	.word 0xe8a584a0  ! 1557: STWA_R	stwa	%r20, [%r22 + %r0] 0x25
	.word 0xeabde000  ! 1558: STDA_I	stda	%r21, [%r23 + 0x0000] %asi
	.word 0xe0be09e0  ! 1559: STDA_R	stda	%r16, [%r24 + %r0] 0x4f
	.word 0xe8be49e0  ! 1560: STDA_R	stda	%r20, [%r25 + %r0] 0x4f
	.word 0xe6b649e0  ! 1561: STHA_R	stha	%r19, [%r25 + %r0] 0x4f
	.word 0xee9cc400  ! 1562: LDDA_R	ldda	[%r19, %r0] 0x20, %r23
	.word 0x87802025  ! 1563: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeabf0e80  ! 1564: STDA_R	stda	%r21, [%r28 + %r0] 0x74
	.word 0xe2f689e0  ! 1565: STXA_R	stxa	%r17, [%r26 + %r0] 0x4f
	.word 0xeac40400  ! 1566: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r21
	.word 0x87802020  ! 1567: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1568: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4c78e40  ! 1569: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r18
	.word 0xe4bdc4a0  ! 1570: STDA_R	stda	%r18, [%r23 + %r0] 0x25
	.word 0xe8c6c9e0  ! 1571: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r20
	.word 0xe8acc400  ! 1572: STBA_R	stba	%r20, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1573: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeccfce60  ! 1574: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r22
	.word 0xe4bfe000  ! 1575: STDA_I	stda	%r18, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1576: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r24
	.word 0xe8af4e40  ! 1578: STBA_R	stba	%r20, [%r29 + %r0] 0x72
	mov	0x0, %r24
	.word 0xeca689e0  ! 1580: STWA_R	stwa	%r22, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 1581: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeeb7a000  ! 1582: STHA_I	stha	%r23, [%r30 + 0x0000] %asi
	mov	0x78, %r17
	mov	0x38, %r16
	mov	0x30, %r25
	.word 0xeecd04a0  ! 1586: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r23
	.word 0xe6848400  ! 1587: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r19
	mov	0x48, %r17
	.word 0xe2afa000  ! 1589: STBA_I	stba	%r17, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1590: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r25
	.word 0xe6a4c400  ! 1592: STWA_R	stwa	%r19, [%r19 + %r0] 0x20
	.word 0x87802074  ! 1593: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeed4c400  ! 1594: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r23
	.word 0x87802025  ! 1595: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xec86a000  ! 1596: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r22
	.word 0xe4dc4400  ! 1597: LDXA_R	ldxa	[%r17, %r0] 0x20, %r18
	.word 0xe4a62000  ! 1598: STWA_I	stwa	%r18, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 1599: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1600: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4a42000  ! 1601: STWA_I	stwa	%r18, [%r16 + 0x0000] %asi
	.word 0xeea7ce80  ! 1602: STWA_R	stwa	%r23, [%r31 + %r0] 0x74
	.word 0xe0974e40  ! 1603: LDUHA_R	lduha	[%r29, %r0] 0x72, %r16
	.word 0x87802020  ! 1604: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0af0e40  ! 1605: STBA_R	stba	%r16, [%r28 + %r0] 0x72
	.word 0xe486c9e0  ! 1606: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r18
	.word 0xe6cf2000  ! 1607: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r19
	mov	0x7c0, %r22
	wr_tick_cmpr_3_16:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfb, %g2
	or	%g4, 0x9f, %g4
	or	%g6, 0xf6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeea4c400  ! 1610: STWA_R	stwa	%r23, [%r19 + %r0] 0x20
	.word 0xec8fa000  ! 1611: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r22
	.word 0xeca649e0  ! 1612: STWA_R	stwa	%r22, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 1613: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r17
	.word 0xecb40400  ! 1615: STHA_R	stha	%r22, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1616: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1617: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeca48400  ! 1618: STWA_R	stwa	%r22, [%r18 + %r0] 0x20
	mov	0x40, %r16
	mov	0x3c0, %r22
	mov	0x38, %r24
	.word 0xe294e000  ! 1622: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r17
	.word 0x87802074  ! 1623: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe48584a0  ! 1624: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r18
	.word 0xe49fce60  ! 1625: LDDA_R	ldda	[%r31, %r0] 0x73, %r18
	mov	0x70, %r19
	.word 0x87802074  ! 1627: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeeb72000  ! 1628: STHA_I	stha	%r23, [%r28 + 0x0000] %asi
	.word 0xe09689e0  ! 1629: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r16
	.word 0x87802074  ! 1630: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4c5c4a0  ! 1631: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r18
	.word 0x8780204f  ! 1632: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeeb6a000  ! 1633: STHA_I	stha	%r23, [%r26 + 0x0000] %asi
	.word 0xeece2000  ! 1634: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r23
	.word 0xeef6e000  ! 1635: STXA_I	stxa	%r23, [%r27 + 0x0000] %asi
	.word 0xee862000  ! 1636: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r23
	.word 0xee862000  ! 1637: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r23
	.word 0xeece2000  ! 1638: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r23
	.word 0xee8c0400  ! 1639: LDUBA_R	lduba	[%r16, %r0] 0x20, %r23
	.word 0xe2bee000  ! 1640: STDA_I	stda	%r17, [%r27 + 0x0000] %asi
	.word 0xe2b62000  ! 1641: STHA_I	stha	%r17, [%r24 + 0x0000] %asi
	.word 0x87802074  ! 1642: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r18
	.word 0xea9d84a0  ! 1644: LDDA_R	ldda	[%r22, %r0] 0x25, %r21
	.word 0xe0c70e80  ! 1645: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r16
	.word 0xe4dce000  ! 1646: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r18
	.word 0x87802073  ! 1647: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8f78e80  ! 1648: STXA_R	stxa	%r20, [%r30 + %r0] 0x74
	.word 0x87802020  ! 1649: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1650: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8bce000  ! 1651: STDA_I	stda	%r20, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1652: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8b76000  ! 1653: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 1654: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1655: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r22
	mov	0x30, %r24
	.word 0xec9e89e0  ! 1658: LDDA_R	ldda	[%r26, %r0] 0x4f, %r22
	.word 0xe49de000  ! 1659: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r18
	.word 0xeef44400  ! 1660: STXA_R	stxa	%r23, [%r17 + %r0] 0x20
	.word 0xee8fce40  ! 1661: LDUBA_R	lduba	[%r31, %r0] 0x72, %r23
	.word 0xe2bd44a0  ! 1662: STDA_R	stda	%r17, [%r21 + %r0] 0x25
	mov	0x7c8, %r20
	.word 0xec9689e0  ! 1664: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r22
	mov	0x50, %r19
	.word 0xeca5e000  ! 1666: STWA_I	stwa	%r22, [%r23 + 0x0000] %asi
	.word 0xecbde000  ! 1667: STDA_I	stda	%r22, [%r23 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xe0d78e40  ! 1669: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r16
	.word 0xe0cc4400  ! 1670: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r16
	mov	0x7f0, %r23
	mov	0x60, %r17
	mov	0x28, %r18
	.word 0xe2ad6000  ! 1674: STBA_I	stba	%r17, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 1675: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1676: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6cf4e80  ! 1677: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r19
	.word 0xe4c5e000  ! 1678: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r18
	.word 0xe4a5e000  ! 1679: STWA_I	stwa	%r18, [%r23 + 0x0000] %asi
	.word 0xee9649e0  ! 1680: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r23
	mov	0x3e8, %r20
	mov	0x50, %r16
	.word 0xe4b649e0  ! 1683: STHA_R	stha	%r18, [%r25 + %r0] 0x4f
	.word 0xe8d52000  ! 1684: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r20
	.word 0xe4c74e60  ! 1685: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r18
	mov	0x68, %r26
	.word 0xe68fce80  ! 1687: LDUBA_R	lduba	[%r31, %r0] 0x74, %r19
	.word 0xeaac4400  ! 1688: STBA_R	stba	%r21, [%r17 + %r0] 0x20
	mov	0x18, %r27
	mov	0x7d8, %r20
	.word 0xe4c5a000  ! 1691: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r18
	mov	0x18, %r16
	mov	0x68, %r17
	.word 0x8780204f  ! 1694: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r23
	.word 0xe4bd44a0  ! 1696: STDA_R	stda	%r18, [%r21 + %r0] 0x25
	mov	0x7d8, %r21
	.word 0xe4ad6000  ! 1698: STBA_I	stba	%r18, [%r21 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xe0974e40  ! 1700: LDUHA_R	lduha	[%r29, %r0] 0x72, %r16
	.word 0xeedde000  ! 1701: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r23
	wr_tick_cmpr_3_17:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xae, %g2
	or	%g4, 0xce, %g4
	or	%g6, 0x83, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe0b584a0  ! 1703: STHA_R	stha	%r16, [%r22 + %r0] 0x25
	.word 0xee9d6000  ! 1704: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r23
	mov	0x58, %r18
	mov	0x3e0, %r23
	mov	0x40, %r19
	.word 0x87802074  ! 1708: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2f78e60  ! 1709: STXA_R	stxa	%r17, [%r30 + %r0] 0x73
	.word 0xea8c0400  ! 1710: LDUBA_R	lduba	[%r16, %r0] 0x20, %r21
	mov	0x38, %r25
	.word 0xeeaf4e80  ! 1712: STBA_R	stba	%r23, [%r29 + %r0] 0x74
	.word 0x87802025  ! 1713: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r19
	.word 0xe6a76000  ! 1715: STWA_I	stwa	%r19, [%r29 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xe6b72000  ! 1717: STHA_I	stha	%r19, [%r28 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xeedd84a0  ! 1719: LDXA_R	ldxa	[%r22, %r0] 0x25, %r23
	.word 0x87802073  ! 1720: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r18
	.word 0xe6a40400  ! 1722: STWA_R	stwa	%r19, [%r16 + %r0] 0x20
	.word 0xe0c7e000  ! 1723: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r16
	.word 0x8780204f  ! 1724: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xea9504a0  ! 1725: LDUHA_R	lduha	[%r20, %r0] 0x25, %r21
	.word 0x87802074  ! 1726: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8df8e80  ! 1727: LDXA_R	ldxa	[%r30, %r0] 0x74, %r20
	mov	0x68, %r19
	.word 0x8780204f  ! 1729: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0cd6000  ! 1730: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r16
	.word 0xec87ce80  ! 1731: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r22
	wr_tick_cmpr_3_18:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x86, %g2
	or	%g4, 0xba, %g4
	or	%g6, 0xa5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeed4c400  ! 1733: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r23
	.word 0xe68dc4a0  ! 1734: LDUBA_R	lduba	[%r23, %r0] 0x25, %r19
	.word 0xecdda000  ! 1735: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r22
	.word 0xe48504a0  ! 1736: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r18
	mov	0x28, %r17
	.word 0x87802020  ! 1738: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8f7e000  ! 1739: STXA_I	stxa	%r20, [%r31 + 0x0000] %asi
	.word 0xeedc8400  ! 1740: LDXA_R	ldxa	[%r18, %r0] 0x20, %r23
	.word 0xec87ce40  ! 1741: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r22
	.word 0xe6d78e40  ! 1742: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r19
	.word 0xeace09e0  ! 1743: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r21
	.word 0xe4bf2000  ! 1744: STDA_I	stda	%r18, [%r28 + 0x0000] %asi
	.word 0xe8a7ce40  ! 1745: STWA_R	stwa	%r20, [%r31 + %r0] 0x72
	.word 0xeabf8e60  ! 1746: STDA_R	stda	%r21, [%r30 + %r0] 0x73
	.word 0xea948400  ! 1747: LDUHA_R	lduha	[%r18, %r0] 0x20, %r21
	.word 0x87802020  ! 1748: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r23
	.word 0xea870e80  ! 1750: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r21
	mov	0x38, %r19
	mov	0x40, %r26
	mov	0x28, %r25
	.word 0xe49c4400  ! 1754: LDDA_R	ldda	[%r17, %r0] 0x20, %r18
	.word 0xe8a48400  ! 1755: STWA_R	stwa	%r20, [%r18 + %r0] 0x20
	.word 0xe69de000  ! 1756: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r19
	.word 0xea84c400  ! 1757: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r21
	.word 0xeea5e000  ! 1758: STWA_I	stwa	%r23, [%r23 + 0x0000] %asi
	.word 0xeea5a000  ! 1759: STWA_I	stwa	%r23, [%r22 + 0x0000] %asi
	.word 0xee95a000  ! 1760: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r23
	.word 0xee8d6000  ! 1761: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r23
	mov	0x48, %r17
	mov	0x70, %r16
	mov	0x7e8, %r23
	.word 0xee8d2000  ! 1765: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r23
	.word 0xeed5a000  ! 1766: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r23
	.word 0x87802025  ! 1767: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8f78e80  ! 1768: STXA_R	stxa	%r20, [%r30 + %r0] 0x74
	mov	0x3d0, %r20
	.word 0xe88f2000  ! 1770: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r20
	.word 0xe2be89e0  ! 1771: STDA_R	stda	%r17, [%r26 + %r0] 0x4f
	.word 0xe2872000  ! 1772: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r17
	.word 0xe0dd84a0  ! 1773: LDXA_R	ldxa	[%r22, %r0] 0x25, %r16
	.word 0xeca584a0  ! 1774: STWA_R	stwa	%r22, [%r22 + %r0] 0x25
	.word 0x87802072  ! 1775: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0b48400  ! 1776: STHA_R	stha	%r16, [%r18 + %r0] 0x20
	.word 0xe28f2000  ! 1777: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r17
	mov	0x60, %r25
	.word 0x87802074  ! 1779: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r25
	mov	0x18, %r17
	.word 0xe2ce2000  ! 1782: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r17
	.word 0x87802074  ! 1783: WRASI_I	wr	%r0, 0x0074, %asi
	wr_tick_cmpr_3_19:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbe, %g2
	or	%g4, 0xc4, %g4
	or	%g6, 0xd6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe8be49e0  ! 1785: STDA_R	stda	%r20, [%r25 + %r0] 0x4f
	.word 0xeaf44400  ! 1786: STXA_R	stxa	%r21, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1787: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r23
	mov	0x18, %r17
	.word 0xe8f70e80  ! 1790: STXA_R	stxa	%r20, [%r28 + %r0] 0x74
	.word 0xe09c2000  ! 1791: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r16
	.word 0x87802025  ! 1792: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe49649e0  ! 1793: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r18
	.word 0xeabf6000  ! 1794: STDA_I	stda	%r21, [%r29 + 0x0000] %asi
	.word 0xea9fe000  ! 1795: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r21
	mov	0x7d0, %r22
	.word 0xecdf4e80  ! 1797: LDXA_R	ldxa	[%r29, %r0] 0x74, %r22
	.word 0xe08c4400  ! 1798: LDUBA_R	lduba	[%r17, %r0] 0x20, %r16
	mov	0x70, %r17
	.word 0xe4f4c400  ! 1800: STXA_R	stxa	%r18, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1801: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r18
	.word 0xee85c4a0  ! 1803: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r23
	.word 0xe6a72000  ! 1804: STWA_I	stwa	%r19, [%r28 + 0x0000] %asi
	.word 0xe6848400  ! 1805: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r19
	.word 0xecdf6000  ! 1806: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r22
	.word 0xecb40400  ! 1807: STHA_R	stha	%r22, [%r16 + %r0] 0x20
	mov	0x28, %r19
	.word 0xee8c0400  ! 1809: LDUBA_R	lduba	[%r16, %r0] 0x20, %r23
	.word 0xe8af2000  ! 1810: STBA_I	stba	%r20, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1811: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeaf4c400  ! 1812: STXA_R	stxa	%r21, [%r19 + %r0] 0x20
	.word 0xee8c6000  ! 1813: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r23
	.word 0xe2dd44a0  ! 1814: LDXA_R	ldxa	[%r21, %r0] 0x25, %r17
	.word 0xe284a000  ! 1815: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r17
	.word 0xe28ce000  ! 1816: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r17
	mov	0x38, %r18
	mov	0x0, %r16
	.word 0x8780204f  ! 1819: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2d42000  ! 1820: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r17
	.word 0xeca44400  ! 1821: STWA_R	stwa	%r22, [%r17 + %r0] 0x20
	.word 0xee94a000  ! 1822: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r23
	.word 0xeabd44a0  ! 1823: STDA_R	stda	%r21, [%r21 + %r0] 0x25
	.word 0xecbf4e60  ! 1824: STDA_R	stda	%r22, [%r29 + %r0] 0x73
	mov	0x30, %r24
	.word 0xe4b46000  ! 1826: STHA_I	stha	%r18, [%r17 + 0x0000] %asi
	.word 0xe4aca000  ! 1827: STBA_I	stba	%r18, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 1828: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4a6a000  ! 1829: STWA_I	stwa	%r18, [%r26 + 0x0000] %asi
	.word 0xecaf0e40  ! 1830: STBA_R	stba	%r22, [%r28 + %r0] 0x72
	.word 0xeea66000  ! 1831: STWA_I	stwa	%r23, [%r25 + 0x0000] %asi
	.word 0xeef6a000  ! 1832: STXA_I	stxa	%r23, [%r26 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xeef62000  ! 1834: STXA_I	stxa	%r23, [%r24 + 0x0000] %asi
	.word 0xe49f0e60  ! 1835: LDDA_R	ldda	[%r28, %r0] 0x73, %r18
	.word 0xe6a62000  ! 1836: STWA_I	stwa	%r19, [%r24 + 0x0000] %asi
	.word 0xe6cee000  ! 1837: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r19
	.word 0xe2de89e0  ! 1838: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r17
	.word 0xea9f8e40  ! 1839: LDDA_R	ldda	[%r30, %r0] 0x72, %r21
	mov	0x0, %r19
	mov	0x18, %r19
	.word 0xec95c4a0  ! 1842: LDUHA_R	lduha	[%r23, %r0] 0x25, %r22
	.word 0xeef70e80  ! 1843: STXA_R	stxa	%r23, [%r28 + %r0] 0x74
	mov	0x70, %r18
	.word 0xecde6000  ! 1845: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r22
	.word 0xe2cd04a0  ! 1846: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r17
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3e0, %r20
	.word 0xe68e6000  ! 1849: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r19
	ta	T_CHANGE_PRIV	! macro
	.word 0xe6ae6000  ! 1851: STBA_I	stba	%r19, [%r25 + 0x0000] %asi
	.word 0xe6f6e000  ! 1852: STXA_I	stxa	%r19, [%r27 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xeebcc400  ! 1854: STDA_R	stda	%r23, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1855: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe49f0e40  ! 1856: LDDA_R	ldda	[%r28, %r0] 0x72, %r18
	.word 0xecbc4400  ! 1857: STDA_R	stda	%r22, [%r17 + %r0] 0x20
	.word 0xe4af6000  ! 1858: STBA_I	stba	%r18, [%r29 + 0x0000] %asi
	.word 0xe4b7a000  ! 1859: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	.word 0xe4c72000  ! 1860: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r18
	.word 0xe6a40400  ! 1861: STWA_R	stwa	%r19, [%r16 + %r0] 0x20
	.word 0xea9f6000  ! 1862: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r21
	.word 0x87802073  ! 1863: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea9e6000  ! 1864: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r21
	.word 0xeaf6e000  ! 1865: STXA_I	stxa	%r21, [%r27 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xecdc4400  ! 1867: LDXA_R	ldxa	[%r17, %r0] 0x20, %r22
	.word 0xe0f4c400  ! 1868: STXA_R	stxa	%r16, [%r19 + %r0] 0x20
	.word 0xecde89e0  ! 1869: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r22
	.word 0xe2b544a0  ! 1870: STHA_R	stha	%r17, [%r21 + %r0] 0x25
	.word 0xeede2000  ! 1871: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r23
	.word 0xe48c0400  ! 1872: LDUBA_R	lduba	[%r16, %r0] 0x20, %r18
	mov	0x38, %r17
	.word 0xe0a66000  ! 1874: STWA_I	stwa	%r16, [%r25 + 0x0000] %asi
	.word 0xe2f689e0  ! 1875: STXA_R	stxa	%r17, [%r26 + %r0] 0x4f
	.word 0xe2848400  ! 1876: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r17
	.word 0xead5c4a0  ! 1877: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r21
	mov	0x3d0, %r22
	.word 0xea96e000  ! 1879: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r21
	mov	0x48, %r25
	.word 0xea96a000  ! 1881: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r21
	.word 0xeaf6e000  ! 1882: STXA_I	stxa	%r21, [%r27 + 0x0000] %asi
	.word 0xea966000  ! 1883: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r21
	.word 0xeab62000  ! 1884: STHA_I	stha	%r21, [%r24 + 0x0000] %asi
	.word 0xe08dc4a0  ! 1885: LDUBA_R	lduba	[%r23, %r0] 0x25, %r16
	.word 0xea9e2000  ! 1886: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r21
	.word 0xe89f4e40  ! 1887: LDDA_R	ldda	[%r29, %r0] 0x72, %r20
	.word 0xeaac0400  ! 1888: STBA_R	stba	%r21, [%r16 + %r0] 0x20
	.word 0xea940400  ! 1889: LDUHA_R	lduha	[%r16, %r0] 0x20, %r21
	mov	0x48, %r27
	.word 0xeec74e60  ! 1891: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r23
	.word 0xe4bee000  ! 1892: STDA_I	stda	%r18, [%r27 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xee8544a0  ! 1894: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r23
	.word 0xeede49e0  ! 1895: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r23
	.word 0x87802072  ! 1896: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeecce000  ! 1897: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r23
	.word 0xecb74e80  ! 1898: STHA_R	stha	%r22, [%r29 + %r0] 0x74
	.word 0xe8d44400  ! 1899: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r20
	.word 0xe48fce40  ! 1900: LDUBA_R	lduba	[%r31, %r0] 0x72, %r18
	.word 0xe6d4c400  ! 1901: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r19
	mov	0x38, %r19
	.word 0xeaa44400  ! 1903: STWA_R	stwa	%r21, [%r17 + %r0] 0x20
	.word 0x87802025  ! 1904: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8bf0e60  ! 1905: STDA_R	stda	%r20, [%r28 + %r0] 0x73
	mov	0x7c8, %r20
	.word 0xe08fa000  ! 1907: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r16
	.word 0xe0c72000  ! 1908: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r16
	mov	0x7c0, %r22
	mov	0x3f8, %r22
	mov	0x7c8, %r22
	.word 0xe0bf2000  ! 1912: STDA_I	stda	%r16, [%r28 + 0x0000] %asi
	mov	0x3c0, %r20
	.word 0x87802025  ! 1914: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0bfe000  ! 1915: STDA_I	stda	%r16, [%r31 + 0x0000] %asi
	.word 0xeabdc4a0  ! 1916: STDA_R	stda	%r21, [%r23 + %r0] 0x25
	.word 0xecb76000  ! 1917: STHA_I	stha	%r22, [%r29 + 0x0000] %asi
	.word 0xecc76000  ! 1918: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0xeca76000  ! 1919: STWA_I	stwa	%r22, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1920: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r23
	.word 0xecbd2000  ! 1922: STDA_I	stda	%r22, [%r20 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x0, %r25
	.word 0x87802025  ! 1925: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f0, %r23
	wr_tick_cmpr_3_20:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa7, %g2
	or	%g4, 0xdc, %g4
	or	%g6, 0xad, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe6be49e0  ! 1928: STDA_R	stda	%r19, [%r25 + %r0] 0x4f
	mov	0x8, %r17
	.word 0xe09f6000  ! 1930: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r16
	.word 0xe8aec9e0  ! 1931: STBA_R	stba	%r20, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1932: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1933: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0a7e000  ! 1934: STWA_I	stwa	%r16, [%r31 + 0x0000] %asi
	.word 0xe09f2000  ! 1935: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r16
	.word 0xe0972000  ! 1936: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r16
	.word 0x8780204f  ! 1937: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0a66000  ! 1938: STWA_I	stwa	%r16, [%r25 + 0x0000] %asi
	.word 0xe0b6e000  ! 1939: STHA_I	stha	%r16, [%r27 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xeaf40400  ! 1941: STXA_R	stxa	%r21, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1942: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 1943: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xee8649e0  ! 1944: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r23
	.word 0xe4f6e000  ! 1945: STXA_I	stxa	%r18, [%r27 + 0x0000] %asi
	.word 0xe4c66000  ! 1946: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r18
	mov	0x8, %r18
	.word 0xecd40400  ! 1948: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r22
	.word 0x87802025  ! 1949: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0a78e60  ! 1950: STWA_R	stwa	%r16, [%r30 + %r0] 0x73
	.word 0xe8dea000  ! 1951: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r20
	mov	0x20, %r27
	.word 0xe8a66000  ! 1953: STWA_I	stwa	%r20, [%r25 + 0x0000] %asi
	.word 0xe8bf8e80  ! 1954: STDA_R	stda	%r20, [%r30 + %r0] 0x74
	.word 0xe0b74e80  ! 1955: STHA_R	stha	%r16, [%r29 + %r0] 0x74
	.word 0x87802020  ! 1956: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a649e0  ! 1957: STWA_R	stwa	%r16, [%r25 + %r0] 0x4f
	mov	0x0, %r25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xee9cc400  ! 1960: LDDA_R	ldda	[%r19, %r0] 0x20, %r23
	.word 0xe0bc6000  ! 1961: STDA_I	stda	%r16, [%r17 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x3f8, %r22
	.word 0xe2a6c9e0  ! 1964: STWA_R	stwa	%r17, [%r27 + %r0] 0x4f
	.word 0xee944400  ! 1965: LDUHA_R	lduha	[%r17, %r0] 0x20, %r23
	.word 0xe4a584a0  ! 1966: STWA_R	stwa	%r18, [%r22 + %r0] 0x25
	.word 0xe0f4c400  ! 1967: STXA_R	stxa	%r16, [%r19 + %r0] 0x20
	.word 0xe0946000  ! 1968: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r16
	.word 0xe8c4c400  ! 1969: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r20
	wr_tick_cmpr_3_21:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb4, %g2
	or	%g4, 0x98, %g4
	or	%g6, 0x8f, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3e8, %r23
	.word 0xe0d48400  ! 1972: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r16
	.word 0xe0dce000  ! 1973: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r16
	.word 0xe0ac6000  ! 1974: STBA_I	stba	%r16, [%r17 + 0x0000] %asi
	.word 0xe0bce000  ! 1975: STDA_I	stda	%r16, [%r19 + 0x0000] %asi
	.word 0xeea70e40  ! 1976: STWA_R	stwa	%r23, [%r28 + %r0] 0x72
	.word 0xeabf8e60  ! 1977: STDA_R	stda	%r21, [%r30 + %r0] 0x73
	.word 0xecc7ce80  ! 1978: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r22
	mov	0x60, %r27
	.word 0xe2b44400  ! 1980: STHA_R	stha	%r17, [%r17 + %r0] 0x20
	mov	0x78, %r27
	.word 0x8780204f  ! 1982: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r23
	wr_tick_cmpr_3_22:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfd, %g2
	or	%g4, 0x9b, %g4
	or	%g6, 0x8b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe2f4c400  ! 1985: STXA_R	stxa	%r17, [%r19 + %r0] 0x20
	.word 0xe4d74e40  ! 1986: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r18
	mov	0x3c8, %r21
	.word 0xe4970e80  ! 1988: LDUHA_R	lduha	[%r28, %r0] 0x74, %r18
	.word 0x87802025  ! 1989: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeecc2000  ! 1990: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r23
	.word 0xeed42000  ! 1991: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r23
	.word 0xeecc6000  ! 1992: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r23
	mov	0x18, %r18
	.word 0xeec46000  ! 1994: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r23
	.word 0xeea4a000  ! 1995: STWA_I	stwa	%r23, [%r18 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xeef4a000  ! 1997: STXA_I	stxa	%r23, [%r18 + 0x0000] %asi
	.word 0xe6be09e0  ! 1998: STDA_R	stda	%r19, [%r24 + %r0] 0x4f
	.word 0xe4d46000  ! 1999: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r18
	.word 0xe48c2000  ! 2000: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r18
	.word 0xe884c400  ! 2001: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r20
	.word 0xe0af8e40  ! 2002: STBA_R	stba	%r16, [%r30 + %r0] 0x72
	mov	0x3f0, %r22
	.word 0xe4b42000  ! 2004: STHA_I	stha	%r18, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 2005: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeef48400  ! 2006: STXA_R	stxa	%r23, [%r18 + %r0] 0x20
	.word 0xe4f62000  ! 2007: STXA_I	stxa	%r18, [%r24 + 0x0000] %asi
	.word 0xe68cc400  ! 2008: LDUBA_R	lduba	[%r19, %r0] 0x20, %r19
	mov	0x68, %r26
	.word 0xeccf8e40  ! 2010: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r22
	.word 0xe09ea000  ! 2011: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r16
	.word 0xeec48400  ! 2012: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r23
	.word 0xead40400  ! 2013: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r21
	mov	0x30, %r25
	.word 0xe0afce80  ! 2015: STBA_R	stba	%r16, [%r31 + %r0] 0x74
	.word 0xecdc4400  ! 2016: LDXA_R	ldxa	[%r17, %r0] 0x20, %r22
	.word 0xe8866000  ! 2017: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r20
	.word 0x87802020  ! 2018: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8976000  ! 2019: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r20
	.word 0x87802020  ! 2020: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r24
	.word 0xe2b7ce40  ! 2022: STHA_R	stha	%r17, [%r31 + %r0] 0x72
	.word 0x87802073  ! 2023: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2024: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8c7ce80  ! 2025: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r20
	.word 0xe6af0e40  ! 2026: STBA_R	stba	%r19, [%r28 + %r0] 0x72
	.word 0xec946000  ! 2027: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r22
	.word 0xec8ca000  ! 2028: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r22
	mov	0x50, %r17
	.word 0xeccc2000  ! 2030: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r22
	mov	0x68, %r17
	.word 0xecf4a000  ! 2032: STXA_I	stxa	%r22, [%r18 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xe8ce09e0  ! 2034: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r20
	.word 0xe2bca000  ! 2035: STDA_I	stda	%r17, [%r18 + 0x0000] %asi
	.word 0xe6cc8400  ! 2036: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r19
	mov	0x0, %r24
	.word 0xe2bc2000  ! 2038: STDA_I	stda	%r17, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 2039: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r19
	mov	0x58, %r26
	mov	0x3f0, %r23
	.word 0x87802074  ! 2043: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r22
	.word 0x87802020  ! 2045: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2046: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2047: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeac78e80  ! 2048: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r21
	.word 0xeeb6e000  ! 2049: STHA_I	stha	%r23, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 2050: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8bd04a0  ! 2051: STDA_R	stda	%r20, [%r20 + %r0] 0x25
	mov	0x7e8, %r21
	mov	0x68, %r17
	mov	0x50, %r16
	mov	0x30, %r17
	.word 0x87802073  ! 2056: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xee9c2000  ! 2057: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r23
	.word 0xeeac2000  ! 2058: STBA_I	stba	%r23, [%r16 + 0x0000] %asi
	mov	0x30, %r25
	mov	0x50, %r24
	mov	0x58, %r16
	mov	0x3f0, %r20
	.word 0xeebca000  ! 2063: STDA_I	stda	%r23, [%r18 + 0x0000] %asi
	.word 0xeef4e000  ! 2064: STXA_I	stxa	%r23, [%r19 + 0x0000] %asi
	.word 0xeecc2000  ! 2065: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r23
	mov	0x7e8, %r23
	mov	0x3f0, %r21
	.word 0x87802020  ! 2068: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeebfe000  ! 2069: STDA_I	stda	%r23, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 2070: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe69f4e40  ! 2071: LDDA_R	ldda	[%r29, %r0] 0x72, %r19
	.word 0xea84c400  ! 2072: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r21
	.word 0xeeb7ce40  ! 2073: STHA_R	stha	%r23, [%r31 + %r0] 0x72
	mov	0x7c0, %r21
	mov	0x38, %r27
	.word 0xe0ace000  ! 2076: STBA_I	stba	%r16, [%r19 + 0x0000] %asi
	mov	0x7d0, %r23
	mov	0x3e8, %r22
	.word 0xe0bc0400  ! 2079: STDA_R	stda	%r16, [%r16 + %r0] 0x20
	mov	0x28, %r24
	.word 0xeea70e80  ! 2081: STWA_R	stwa	%r23, [%r28 + %r0] 0x74
	.word 0xe6bc4400  ! 2082: STDA_R	stda	%r19, [%r17 + %r0] 0x20
	.word 0xe8dd84a0  ! 2083: LDXA_R	ldxa	[%r22, %r0] 0x25, %r20
	.word 0xe4cc6000  ! 2084: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r18
	.word 0x87802072  ! 2085: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe69d44a0  ! 2086: LDDA_R	ldda	[%r21, %r0] 0x25, %r19
	.word 0x87802072  ! 2087: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8afa000  ! 2088: STBA_I	stba	%r20, [%r30 + 0x0000] %asi
	.word 0xe4f649e0  ! 2089: STXA_R	stxa	%r18, [%r25 + %r0] 0x4f
	mov	0x7d8, %r21
	.word 0xe0870e80  ! 2091: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r16
	mov	0x40, %r16
	.word 0xe0afa000  ! 2093: STBA_I	stba	%r16, [%r30 + 0x0000] %asi
	.word 0xe08fa000  ! 2094: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r16
	.word 0xe0f7ce80  ! 2095: STXA_R	stxa	%r16, [%r31 + %r0] 0x74
	.word 0xeacf8e60  ! 2096: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r21
	mov	0x38, %r18
	mov	0x38, %r25
	.word 0xeeb609e0  ! 2099: STHA_R	stha	%r23, [%r24 + %r0] 0x4f
	.word 0xe2ae89e0  ! 2100: STBA_R	stba	%r17, [%r26 + %r0] 0x4f
	.word 0xe2bc0400  ! 2101: STDA_R	stda	%r17, [%r16 + %r0] 0x20
	mov	0x7d0, %r21
	.word 0xee8f4e80  ! 2103: LDUBA_R	lduba	[%r29, %r0] 0x74, %r23
	.word 0xe68f4e80  ! 2104: LDUBA_R	lduba	[%r29, %r0] 0x74, %r19
	.word 0xeaf76000  ! 2105: STXA_I	stxa	%r21, [%r29 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xea8fa000  ! 2107: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r21
	.word 0xeab76000  ! 2108: STHA_I	stha	%r21, [%r29 + 0x0000] %asi
	.word 0xe28f8e80  ! 2109: LDUBA_R	lduba	[%r30, %r0] 0x74, %r17
	.word 0xe6afce80  ! 2110: STBA_R	stba	%r19, [%r31 + %r0] 0x74
	mov	0x20, %r24
	.word 0xe0a44400  ! 2112: STWA_R	stwa	%r16, [%r17 + %r0] 0x20
	.word 0xeab44400  ! 2113: STHA_R	stha	%r21, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2114: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeea48400  ! 2115: STWA_R	stwa	%r23, [%r18 + %r0] 0x20
	.word 0xe0b4a000  ! 2116: STHA_I	stha	%r16, [%r18 + 0x0000] %asi
	.word 0xe0bce000  ! 2117: STDA_I	stda	%r16, [%r19 + 0x0000] %asi
	.word 0xe09ca000  ! 2118: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r16
	.word 0xe0d4a000  ! 2119: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r16
	mov	0x28, %r24
	mov	0x7d8, %r23
	.word 0xe6a78e80  ! 2122: STWA_R	stwa	%r19, [%r30 + %r0] 0x74
	mov	0x38, %r18
	.word 0x87802020  ! 2124: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2af6000  ! 2125: STBA_I	stba	%r17, [%r29 + 0x0000] %asi
	.word 0xeabcc400  ! 2126: STDA_R	stda	%r21, [%r19 + %r0] 0x20
	mov	0x28, %r18
	.word 0xec97a000  ! 2128: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r22
	.word 0x87802020  ! 2129: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2130: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2b6c9e0  ! 2131: STHA_R	stha	%r17, [%r27 + %r0] 0x4f
	.word 0xe8a7a000  ! 2132: STWA_I	stwa	%r20, [%r30 + 0x0000] %asi
	.word 0xe8a7a000  ! 2133: STWA_I	stwa	%r20, [%r30 + 0x0000] %asi
	.word 0xeea584a0  ! 2134: STWA_R	stwa	%r23, [%r22 + %r0] 0x25
	.word 0xe6b70e80  ! 2135: STHA_R	stha	%r19, [%r28 + %r0] 0x74
	.word 0xea870e80  ! 2136: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r21
	mov	0x30, %r16
	.word 0xee97e000  ! 2138: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r23
	.word 0xe8970e80  ! 2139: LDUHA_R	lduha	[%r28, %r0] 0x74, %r20
	mov	0x10, %r16
	.word 0xeecfa000  ! 2141: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r23
	mov	0x8, %r26
	.word 0xe08fce80  ! 2143: LDUBA_R	lduba	[%r31, %r0] 0x74, %r16
	.word 0x87802072  ! 2144: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8b5c4a0  ! 2145: STHA_R	stha	%r20, [%r23 + %r0] 0x25
	.word 0x87802020  ! 2146: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0df4e60  ! 2147: LDXA_R	ldxa	[%r29, %r0] 0x73, %r16
	.word 0xe084e000  ! 2148: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r16
	.word 0xe0a42000  ! 2149: STWA_I	stwa	%r16, [%r16 + 0x0000] %asi
	.word 0xeade89e0  ! 2150: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r21
	.word 0xee8c6000  ! 2151: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r23
	mov	0x48, %r26
	.word 0x87802025  ! 2153: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r23
	mov	0x10, %r16
	.word 0x87802074  ! 2156: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeea56000  ! 2157: STWA_I	stwa	%r23, [%r21 + 0x0000] %asi
	mov	0x78, %r27
	mov	0x10, %r17
	.word 0xee9d6000  ! 2160: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r23
	.word 0xe4d7ce60  ! 2161: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r18
	.word 0xe8f5e000  ! 2162: STXA_I	stxa	%r20, [%r23 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xecdf0e60  ! 2164: LDXA_R	ldxa	[%r28, %r0] 0x73, %r22
	.word 0x87802073  ! 2165: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r20
	mov	0x18, %r17
	.word 0x87802025  ! 2168: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2976000  ! 2169: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r17
	mov	0x28, %r26
	.word 0xeab544a0  ! 2171: STHA_R	stha	%r21, [%r21 + %r0] 0x25
	mov	0x40, %r27
	mov	0x3c0, %r22
	mov	0x38, %r27
	.word 0x87802074  ! 2175: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r23
	.word 0xe09649e0  ! 2177: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r16
	.word 0xe0f66000  ! 2178: STXA_I	stxa	%r16, [%r25 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xeec7ce40  ! 2180: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r23
	mov	0x40, %r27
	.word 0xeeb66000  ! 2182: STHA_I	stha	%r23, [%r25 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xee9ea000  ! 2184: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r23
	mov	0x60, %r18
	mov	0x70, %r27
	.word 0xeccf8e40  ! 2187: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r22
	.word 0xe8b48400  ! 2188: STHA_R	stha	%r20, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2189: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec9fe000  ! 2190: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r22
	mov	0x18, %r24
	.word 0xecdfa000  ! 2192: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r22
	.word 0x87802020  ! 2193: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecbce000  ! 2194: STDA_I	stda	%r22, [%r19 + 0x0000] %asi
	.word 0xec8ce000  ! 2195: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r22
	.word 0x87802073  ! 2196: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe49649e0  ! 2197: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r18
	.word 0xe0d74e60  ! 2198: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r16
	.word 0x87802072  ! 2199: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeebce000  ! 2200: STDA_I	stda	%r23, [%r19 + 0x0000] %asi
	mov	0x3d0, %r23
	mov	0x40, %r24
	.word 0xea878e60  ! 2203: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r21
	.word 0xe0bca000  ! 2204: STDA_I	stda	%r16, [%r18 + 0x0000] %asi
	.word 0xe4dec9e0  ! 2205: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r18
	.word 0xe0b584a0  ! 2206: STHA_R	stha	%r16, [%r22 + %r0] 0x25
	.word 0x87802072  ! 2207: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe69609e0  ! 2208: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r19
	.word 0xe6d40400  ! 2209: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r19
	mov	0x3e8, %r20
	.word 0xeef72000  ! 2211: STXA_I	stxa	%r23, [%r28 + 0x0000] %asi
	.word 0xe8f584a0  ! 2212: STXA_R	stxa	%r20, [%r22 + %r0] 0x25
	.word 0xeacfe000  ! 2213: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r21
	.word 0xea97a000  ! 2214: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r21
	mov	0x40, %r24
	.word 0xead76000  ! 2216: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r21
	.word 0xe4a7ce60  ! 2217: STWA_R	stwa	%r18, [%r31 + %r0] 0x73
	.word 0xe6b5c4a0  ! 2218: STHA_R	stha	%r19, [%r23 + %r0] 0x25
	.word 0xe2cd04a0  ! 2219: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r17
	.word 0xe4bd44a0  ! 2220: STDA_R	stda	%r18, [%r21 + %r0] 0x25
	mov	0x28, %r18
	.word 0xe8bfe000  ! 2222: STDA_I	stda	%r20, [%r31 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xeeac8400  ! 2224: STBA_R	stba	%r23, [%r18 + %r0] 0x20
	.word 0xe88fe000  ! 2225: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r20
	mov	0x3e0, %r21
	.word 0xe69ec9e0  ! 2227: LDDA_R	ldda	[%r27, %r0] 0x4f, %r19
	mov	0x0, %r16
	.word 0xeca76000  ! 2229: STWA_I	stwa	%r22, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2230: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecdf2000  ! 2231: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r22
	.word 0xeaf584a0  ! 2232: STXA_R	stxa	%r21, [%r22 + %r0] 0x25
	mov	0x3f0, %r22
	.word 0xe0af2000  ! 2234: STBA_I	stba	%r16, [%r28 + 0x0000] %asi
	.word 0xe0cf2000  ! 2235: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r16
	mov	0x58, %r26
	ta	T_CHANGE_HPRIV	! macro
	.word 0xe8a7ce60  ! 2238: STWA_R	stwa	%r20, [%r31 + %r0] 0x73
	.word 0xecf74e80  ! 2239: STXA_R	stxa	%r22, [%r29 + %r0] 0x74
	.word 0xec9c4400  ! 2240: LDDA_R	ldda	[%r17, %r0] 0x20, %r22
	.word 0xecbc8400  ! 2241: STDA_R	stda	%r22, [%r18 + %r0] 0x20
	.word 0x87802025  ! 2242: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeaac8400  ! 2243: STBA_R	stba	%r21, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2244: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaac6000  ! 2245: STBA_I	stba	%r21, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 2246: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6ccc400  ! 2247: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r19
	.word 0x8780204f  ! 2248: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe49649e0  ! 2249: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r18
	.word 0xecbf8e80  ! 2250: STDA_R	stda	%r22, [%r30 + %r0] 0x74
	.word 0xe68c2000  ! 2251: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r19
	.word 0xe2a4c400  ! 2252: STWA_R	stwa	%r17, [%r19 + %r0] 0x20
	.word 0xe4a78e40  ! 2253: STWA_R	stwa	%r18, [%r30 + %r0] 0x72
	.word 0x87802025  ! 2254: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2255: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeeb72000  ! 2256: STHA_I	stha	%r23, [%r28 + 0x0000] %asi
	.word 0xeef78e40  ! 2257: STXA_R	stxa	%r23, [%r30 + %r0] 0x72
	mov	0x0, %r26
	.word 0xeaa72000  ! 2259: STWA_I	stwa	%r21, [%r28 + 0x0000] %asi
	.word 0xe0dec9e0  ! 2260: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r16
	mov	0x3e0, %r23
	mov	0x3e8, %r21
	mov	0x60, %r19
	.word 0xe89f0e80  ! 2264: LDDA_R	ldda	[%r28, %r0] 0x74, %r20
	mov	0x20, %r24
	mov	0x48, %r18
	.word 0xe2ce89e0  ! 2267: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r17
	.word 0xec8c0400  ! 2268: LDUBA_R	lduba	[%r16, %r0] 0x20, %r22
	mov	0x20, %r27
	mov	0x10, %r27
	mov	0x7f0, %r20
	.word 0xe2bfe000  ! 2272: STDA_I	stda	%r17, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2273: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2b4a000  ! 2274: STHA_I	stha	%r17, [%r18 + 0x0000] %asi
	.word 0xeab74e80  ! 2275: STHA_R	stha	%r21, [%r29 + %r0] 0x74
	.word 0xe4f4e000  ! 2276: STXA_I	stxa	%r18, [%r19 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xe4942000  ! 2278: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r18
	mov	0x58, %r27
	.word 0xe4ace000  ! 2280: STBA_I	stba	%r18, [%r19 + 0x0000] %asi
	.word 0xe4942000  ! 2281: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r18
	.word 0x87802020  ! 2282: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2283: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4b72000  ! 2284: STHA_I	stha	%r18, [%r28 + 0x0000] %asi
	.word 0xe4d72000  ! 2285: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r18
	.word 0xeca609e0  ! 2286: STWA_R	stwa	%r22, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 2287: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r22
	.word 0xe09d2000  ! 2289: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r16
	mov	0x38, %r24
	.word 0x87802073  ! 2291: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeedf8e60  ! 2292: LDXA_R	ldxa	[%r30, %r0] 0x73, %r23
	.word 0xee9e09e0  ! 2293: LDDA_R	ldda	[%r24, %r0] 0x4f, %r23
	.word 0x87802073  ! 2294: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xecf6e000  ! 2295: STXA_I	stxa	%r22, [%r27 + 0x0000] %asi
	.word 0xecb62000  ! 2296: STHA_I	stha	%r22, [%r24 + 0x0000] %asi
	.word 0xecbea000  ! 2297: STDA_I	stda	%r22, [%r26 + 0x0000] %asi
	mov	0x30, %r25
	mov	0x3d0, %r20
	.word 0xecf6a000  ! 2300: STXA_I	stxa	%r22, [%r26 + 0x0000] %asi
	.word 0xe4a48400  ! 2301: STWA_R	stwa	%r18, [%r18 + %r0] 0x20
	.word 0xe6a7ce80  ! 2302: STWA_R	stwa	%r19, [%r31 + %r0] 0x74
	mov	0x30, %r17
	.word 0xea96a000  ! 2304: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r21
	.word 0xeacf4e40  ! 2305: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r21
	.word 0xe4b66000  ! 2306: STHA_I	stha	%r18, [%r25 + 0x0000] %asi
	.word 0xe4be6000  ! 2307: STDA_I	stda	%r18, [%r25 + 0x0000] %asi
	.word 0xe4bee000  ! 2308: STDA_I	stda	%r18, [%r27 + 0x0000] %asi
	.word 0xe4f6a000  ! 2309: STXA_I	stxa	%r18, [%r26 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe4a6a000  ! 2311: STWA_I	stwa	%r18, [%r26 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xe0d78e40  ! 2313: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r16
	.word 0xe0f544a0  ! 2314: STXA_R	stxa	%r16, [%r21 + %r0] 0x25
	.word 0xe2f504a0  ! 2315: STXA_R	stxa	%r17, [%r20 + %r0] 0x25
	.word 0xe8b6a000  ! 2316: STHA_I	stha	%r20, [%r26 + 0x0000] %asi
	.word 0xe294c400  ! 2317: LDUHA_R	lduha	[%r19, %r0] 0x20, %r17
	.word 0xeaa6c9e0  ! 2318: STWA_R	stwa	%r21, [%r27 + %r0] 0x4f
	.word 0xe4d70e40  ! 2319: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r18
	.word 0x87802020  ! 2320: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a48400  ! 2321: STWA_R	stwa	%r16, [%r18 + %r0] 0x20
	.word 0x87802073  ! 2322: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeeacc400  ! 2323: STBA_R	stba	%r23, [%r19 + %r0] 0x20
	mov	0x7e8, %r20
	mov	0x10, %r24
	.word 0xeebfa000  ! 2326: STDA_I	stda	%r23, [%r30 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xee87a000  ! 2328: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r23
	.word 0xecb649e0  ! 2329: STHA_R	stha	%r22, [%r25 + %r0] 0x4f
	.word 0xeadf8e80  ! 2330: LDXA_R	ldxa	[%r30, %r0] 0x74, %r21
	.word 0x87802072  ! 2331: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2872000  ! 2332: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r17
	.word 0xe29e09e0  ! 2333: LDDA_R	ldda	[%r24, %r0] 0x4f, %r17
	mov	0x3e0, %r21
	.word 0xecbe49e0  ! 2335: STDA_R	stda	%r22, [%r25 + %r0] 0x4f
	mov	0x38, %r18
	.word 0xe8972000  ! 2337: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r20
	.word 0xeadf8e60  ! 2338: LDXA_R	ldxa	[%r30, %r0] 0x73, %r21
	.word 0xeef74e40  ! 2339: STXA_R	stxa	%r23, [%r29 + %r0] 0x72
	.word 0xeaa7ce40  ! 2340: STWA_R	stwa	%r21, [%r31 + %r0] 0x72
	.word 0xe2bf8e40  ! 2341: STDA_R	stda	%r17, [%r30 + %r0] 0x72
	ta	T_CHANGE_PRIV	! macro
	mov	0x3c0, %r22
	.word 0xe6df4e60  ! 2344: LDXA_R	ldxa	[%r29, %r0] 0x73, %r19
	mov	0x8, %r25
	.word 0xe48fe000  ! 2346: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r18
	.word 0xe6d4c400  ! 2347: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r19
	mov	0x50, %r18
	.word 0xeabfce60  ! 2349: STDA_R	stda	%r21, [%r31 + %r0] 0x73
	.word 0x87802072  ! 2350: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r24
	.word 0xe8bda000  ! 2352: STDA_I	stda	%r20, [%r22 + 0x0000] %asi
	.word 0xe88649e0  ! 2353: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r20
	.word 0xeca44400  ! 2354: STWA_R	stwa	%r22, [%r17 + %r0] 0x20
	mov	0x3e0, %r20
	.word 0xe8cfce40  ! 2356: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r20
	mov	0x3e0, %r23
	.word 0xe2ada000  ! 2358: STBA_I	stba	%r17, [%r22 + 0x0000] %asi
	.word 0xe2cd04a0  ! 2359: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r17
	.word 0xeead2000  ! 2360: STBA_I	stba	%r23, [%r20 + 0x0000] %asi
	.word 0xeead6000  ! 2361: STBA_I	stba	%r23, [%r21 + 0x0000] %asi
	.word 0xeabc8400  ! 2362: STDA_R	stda	%r21, [%r18 + %r0] 0x20
	.word 0xeccd6000  ! 2363: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r22
	.word 0xec9d6000  ! 2364: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r22
	.word 0xecd56000  ! 2365: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r22
	.word 0xe0a6c9e0  ! 2366: STWA_R	stwa	%r16, [%r27 + %r0] 0x4f
	mov	0x30, %r24
	mov	0x7d0, %r23
	.word 0xe8ac4400  ! 2369: STBA_R	stba	%r20, [%r17 + %r0] 0x20
	.word 0xe8c52000  ! 2370: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r20
	.word 0xe6874e60  ! 2371: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r19
	.word 0xe4dc0400  ! 2372: LDXA_R	ldxa	[%r16, %r0] 0x20, %r18
	mov	0x7c8, %r21
	.word 0xe2a40400  ! 2374: STWA_R	stwa	%r17, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2375: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6ac2000  ! 2376: STBA_I	stba	%r19, [%r16 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xe6a42000  ! 2378: STWA_I	stwa	%r19, [%r16 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xe6bc2000  ! 2380: STDA_I	stda	%r19, [%r16 + 0x0000] %asi
	.word 0xe0c70e60  ! 2381: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r16
	.word 0x87802025  ! 2382: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r19
	.word 0xe0a504a0  ! 2384: STWA_R	stwa	%r16, [%r20 + %r0] 0x25
	.word 0xe4f7ce60  ! 2385: STXA_R	stxa	%r18, [%r31 + %r0] 0x73
	.word 0xec9d84a0  ! 2386: LDDA_R	ldda	[%r22, %r0] 0x25, %r22
	.word 0xe684e000  ! 2387: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r19
	.word 0xe6b46000  ! 2388: STHA_I	stha	%r19, [%r17 + 0x0000] %asi
	mov	0x28, %r16
	mov	0x60, %r17
	.word 0xe6c4e000  ! 2391: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r19
	.word 0xe6cc2000  ! 2392: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r19
	mov	0x18, %r19
	mov	0x8, %r25
	.word 0xe6f4e000  ! 2395: STXA_I	stxa	%r19, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2396: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6a4a000  ! 2397: STWA_I	stwa	%r19, [%r18 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0x87802020  ! 2399: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8bc8400  ! 2400: STDA_R	stda	%r20, [%r18 + %r0] 0x20
	.word 0xeeada000  ! 2401: STBA_I	stba	%r23, [%r22 + 0x0000] %asi
	.word 0xe48cc400  ! 2402: LDUBA_R	lduba	[%r19, %r0] 0x20, %r18
	.word 0xecb52000  ! 2403: STHA_I	stha	%r22, [%r20 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xe6f74e60  ! 2405: STXA_R	stxa	%r19, [%r29 + %r0] 0x73
	mov	0x3c0, %r23
	.word 0xecc5e000  ! 2407: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r22
	.word 0xe49e49e0  ! 2408: LDDA_R	ldda	[%r25, %r0] 0x4f, %r18
	.word 0x87802074  ! 2409: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r19
	.word 0xec870e60  ! 2411: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r22
	.word 0xe4b7e000  ! 2412: STHA_I	stha	%r18, [%r31 + 0x0000] %asi
	mov	0x70, %r26
	.word 0x87802020  ! 2414: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r20
	.word 0xe8bf0e40  ! 2416: STDA_R	stda	%r20, [%r28 + %r0] 0x72
	mov	0x28, %r26
	.word 0xe6af2000  ! 2418: STBA_I	stba	%r19, [%r28 + 0x0000] %asi
	.word 0xe6afe000  ! 2419: STBA_I	stba	%r19, [%r31 + 0x0000] %asi
	.word 0xe4b78e60  ! 2420: STHA_R	stha	%r18, [%r30 + %r0] 0x73
	mov	0x48, %r19
	.word 0xe6dfce80  ! 2422: LDXA_R	ldxa	[%r31, %r0] 0x74, %r19
	.word 0xe0848400  ! 2423: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r16
	.word 0xecf72000  ! 2424: STXA_I	stxa	%r22, [%r28 + 0x0000] %asi
	.word 0xecc76000  ! 2425: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0xe2a544a0  ! 2426: STWA_R	stwa	%r17, [%r21 + %r0] 0x25
	.word 0xecbcc400  ! 2427: STDA_R	stda	%r22, [%r19 + %r0] 0x20
	.word 0xecc6c9e0  ! 2428: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r22
	.word 0x87802020  ! 2429: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea9f6000  ! 2430: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r21
	mov	0x78, %r24
	.word 0xeaafa000  ! 2432: STBA_I	stba	%r21, [%r30 + 0x0000] %asi
	mov	0x8, %r27
	mov	0x38, %r25
	.word 0xe6a6c9e0  ! 2435: STWA_R	stwa	%r19, [%r27 + %r0] 0x4f
	mov	0x40, %r19
	.word 0x87802020  ! 2437: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8bec9e0  ! 2438: STDA_R	stda	%r20, [%r27 + %r0] 0x4f
	.word 0xe0ad6000  ! 2439: STBA_I	stba	%r16, [%r21 + 0x0000] %asi
	.word 0xeef689e0  ! 2440: STXA_R	stxa	%r23, [%r26 + %r0] 0x4f
	.word 0xe68cc400  ! 2441: LDUBA_R	lduba	[%r19, %r0] 0x20, %r19
	.word 0xecade000  ! 2442: STBA_I	stba	%r22, [%r23 + 0x0000] %asi
	.word 0xecd56000  ! 2443: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r22
	mov	0x48, %r25
	.word 0xecb52000  ! 2445: STHA_I	stha	%r22, [%r20 + 0x0000] %asi
	.word 0xecada000  ! 2446: STBA_I	stba	%r22, [%r22 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xecbd6000  ! 2448: STDA_I	stda	%r22, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 2449: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8ad44a0  ! 2450: STBA_R	stba	%r20, [%r21 + %r0] 0x25
	.word 0xe4b7a000  ! 2451: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	mov	0x3d8, %r23
	mov	0x50, %r18
	.word 0xe0f74e80  ! 2454: STXA_R	stxa	%r16, [%r29 + %r0] 0x74
	wr_tick_cmpr_3_23:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc9, %g2
	or	%g4, 0xd2, %g4
	or	%g6, 0xd0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 2456: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe28544a0  ! 2457: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r17
	mov	0x0, %r19
	.word 0x87802074  ! 2459: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r17
	.word 0xe6a52000  ! 2461: STWA_I	stwa	%r19, [%r20 + 0x0000] %asi
	.word 0xec9f0e60  ! 2462: LDDA_R	ldda	[%r28, %r0] 0x73, %r22
	.word 0xe4bde000  ! 2463: STDA_I	stda	%r18, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 2464: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 2465: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xec9c4400  ! 2466: LDDA_R	ldda	[%r17, %r0] 0x20, %r22
	.word 0xe8df2000  ! 2467: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r20
	.word 0x87802025  ! 2468: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0c70e80  ! 2469: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r16
	.word 0xeaf609e0  ! 2470: STXA_R	stxa	%r21, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 2471: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2876000  ! 2472: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r17
	.word 0xe4df8e60  ! 2473: LDXA_R	ldxa	[%r30, %r0] 0x73, %r18
	mov	0x10, %r19
	.word 0x87802020  ! 2475: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeca78e40  ! 2476: STWA_R	stwa	%r22, [%r30 + %r0] 0x72
	.word 0xeef649e0  ! 2477: STXA_R	stxa	%r23, [%r25 + %r0] 0x4f
	.word 0xeef74e40  ! 2478: STXA_R	stxa	%r23, [%r29 + %r0] 0x72
	.word 0xe88fa000  ! 2479: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r20
	.word 0xe897a000  ! 2480: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r20
	.word 0xe88e89e0  ! 2481: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r20
	.word 0x8780204f  ! 2482: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xea874e40  ! 2483: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r21
	.word 0xe2a7ce60  ! 2484: STWA_R	stwa	%r17, [%r31 + %r0] 0x73
	mov	0x20, %r18
	.word 0xee97a000  ! 2486: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r23
	mov	0x8, %r16
	mov	0x10, %r18
	mov	0x3c0, %r20
	.word 0xeeb72000  ! 2490: STHA_I	stha	%r23, [%r28 + 0x0000] %asi
	mov	0x68, %r19
	mov	0x38, %r24
	.word 0xeec78e40  ! 2493: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r23
	.word 0xecc78e40  ! 2494: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r22
	.word 0xe29fa000  ! 2495: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r17
	.word 0xeef70e60  ! 2496: STXA_R	stxa	%r23, [%r28 + %r0] 0x73
	.word 0xe8de89e0  ! 2497: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r20
	.word 0xe097e000  ! 2498: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r16
	.word 0xe0f7e000  ! 2499: STXA_I	stxa	%r16, [%r31 + 0x0000] %asi
	.word 0xe0d7a000  ! 2500: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r16
	.word 0xe0ac0400  ! 2501: STBA_R	stba	%r16, [%r16 + %r0] 0x20
	.word 0xeaa76000  ! 2502: STWA_I	stwa	%r21, [%r29 + 0x0000] %asi
	.word 0xeaafa000  ! 2503: STBA_I	stba	%r21, [%r30 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xeabfe000  ! 2505: STDA_I	stda	%r21, [%r31 + 0x0000] %asi
	.word 0xeacf2000  ! 2506: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r21
	mov	0x18, %r17
	.word 0x87802072  ! 2508: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xee8d84a0  ! 2509: LDUBA_R	lduba	[%r22, %r0] 0x25, %r23
	mov	0x40, %r17
	mov	0x60, %r24
	mov	0x3c8, %r21
	mov	0x3c8, %r23
	mov	0x3d0, %r20
	.word 0xeab42000  ! 2515: STHA_I	stha	%r21, [%r16 + 0x0000] %asi
	.word 0xe4874e40  ! 2516: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r18
	mov	0x18, %r16
	.word 0xe6bf8e80  ! 2518: STDA_R	stda	%r19, [%r30 + %r0] 0x74
	.word 0xe4ddc4a0  ! 2519: LDXA_R	ldxa	[%r23, %r0] 0x25, %r18
	mov	0x38, %r18
	.word 0xe0d4a000  ! 2521: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r16
	.word 0xe0aca000  ! 2522: STBA_I	stba	%r16, [%r18 + 0x0000] %asi
	.word 0xe29f0e80  ! 2523: LDDA_R	ldda	[%r28, %r0] 0x74, %r17
	mov	0x7e0, %r20
	.word 0xe4ae89e0  ! 2525: STBA_R	stba	%r18, [%r26 + %r0] 0x4f
	.word 0xe4cc6000  ! 2526: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r18
	.word 0xe4bc6000  ! 2527: STDA_I	stda	%r18, [%r17 + 0x0000] %asi
	wr_tick_cmpr_3_24:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xc3, %g2
	or	%g4, 0xfe, %g4
	or	%g6, 0xf5, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe4c4e000  ! 2529: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r18
	mov	0x28, %r17
	.word 0xe6de89e0  ! 2531: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r19
	mov	0x3c0, %r22
	.word 0xe2974e60  ! 2533: LDUHA_R	lduha	[%r29, %r0] 0x73, %r17
	.word 0x87802072  ! 2534: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xec848400  ! 2535: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r22
	mov	0x70, %r17
	.word 0xeede6000  ! 2537: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r23
	.word 0xeef7ce80  ! 2538: STXA_R	stxa	%r23, [%r31 + %r0] 0x74
	.word 0xe0b66000  ! 2539: STHA_I	stha	%r16, [%r25 + 0x0000] %asi
	.word 0xe49f4e60  ! 2540: LDDA_R	ldda	[%r29, %r0] 0x73, %r18
	.word 0xe08e2000  ! 2541: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r16
	.word 0xe8d40400  ! 2542: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r20
	mov	0x28, %r16
	mov	0x8, %r26
	.word 0xecc66000  ! 2545: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r22
	.word 0xe49f8e80  ! 2546: LDDA_R	ldda	[%r30, %r0] 0x74, %r18
	.word 0xe8ae89e0  ! 2547: STBA_R	stba	%r20, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 2548: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6aca000  ! 2549: STBA_I	stba	%r19, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 2550: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r22
	.word 0xe684c400  ! 2552: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r19
	.word 0xe4af6000  ! 2553: STBA_I	stba	%r18, [%r29 + 0x0000] %asi
	mov	0x28, %r27
	mov	0x58, %r25
	.word 0x87802073  ! 2556: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4ade000  ! 2557: STBA_I	stba	%r18, [%r23 + 0x0000] %asi
	.word 0xe4bda000  ! 2558: STDA_I	stda	%r18, [%r22 + 0x0000] %asi
	.word 0xe4cd2000  ! 2559: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r18
	.word 0xe4f5e000  ! 2560: STXA_I	stxa	%r18, [%r23 + 0x0000] %asi
	.word 0xeabe49e0  ! 2561: STDA_R	stda	%r21, [%r25 + %r0] 0x4f
	mov	0x3e0, %r21
	.word 0xe6856000  ! 2563: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r19
	mov	0x28, %r16
	.word 0xe6b52000  ! 2565: STHA_I	stha	%r19, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 2566: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6876000  ! 2567: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r19
	mov	0x3f0, %r23
	mov	0x40, %r26
	.word 0xe6876000  ! 2570: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r19
	.word 0xe6b72000  ! 2571: STHA_I	stha	%r19, [%r28 + 0x0000] %asi
	.word 0xe68f2000  ! 2572: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r19
	.word 0xe6dfa000  ! 2573: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r19
	.word 0xe6bfa000  ! 2574: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xe6bf8e40  ! 2575: STDA_R	stda	%r19, [%r30 + %r0] 0x72
	.word 0xe4dc4400  ! 2576: LDXA_R	ldxa	[%r17, %r0] 0x20, %r18
	mov	0x8, %r25
	.word 0xecdf0e40  ! 2578: LDXA_R	ldxa	[%r28, %r0] 0x72, %r22
	.word 0x87802020  ! 2579: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeedc8400  ! 2580: LDXA_R	ldxa	[%r18, %r0] 0x20, %r23
	.word 0xe6d78e40  ! 2581: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r19
	mov	0x78, %r27
	mov	0x28, %r19
	.word 0xeebf4e80  ! 2584: STDA_R	stda	%r23, [%r29 + %r0] 0x74
	.word 0xe6a5e000  ! 2585: STWA_I	stwa	%r19, [%r23 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xeebc4400  ! 2587: STDA_R	stda	%r23, [%r17 + %r0] 0x20
	.word 0xecb52000  ! 2588: STHA_I	stha	%r22, [%r20 + 0x0000] %asi
	.word 0xecf5a000  ! 2589: STXA_I	stxa	%r22, [%r22 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0x87802025  ! 2591: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2be09e0  ! 2592: STDA_R	stda	%r17, [%r24 + %r0] 0x4f
	.word 0xe2a6e000  ! 2593: STWA_I	stwa	%r17, [%r27 + 0x0000] %asi
	mov	0x30, %r25
	mov	0x60, %r16
	.word 0xe8f584a0  ! 2596: STXA_R	stxa	%r20, [%r22 + %r0] 0x25
	.word 0xeacee000  ! 2597: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r21
	mov	0x3d0, %r22
	.word 0xead66000  ! 2599: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r21
	.word 0x87802073  ! 2600: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r20
	.word 0xe6de09e0  ! 2602: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r19
	.word 0xe6df0e80  ! 2603: LDXA_R	ldxa	[%r28, %r0] 0x74, %r19
	.word 0x87802074  ! 2604: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeaa76000  ! 2605: STWA_I	stwa	%r21, [%r29 + 0x0000] %asi
	.word 0xea9f2000  ! 2606: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r21
	.word 0x87802073  ! 2607: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeaa4e000  ! 2608: STWA_I	stwa	%r21, [%r19 + 0x0000] %asi
	.word 0xea94a000  ! 2609: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r21
	.word 0xecac4400  ! 2610: STBA_R	stba	%r22, [%r17 + %r0] 0x20
	mov	0x3e0, %r21
	.word 0xe4b649e0  ! 2612: STHA_R	stha	%r18, [%r25 + %r0] 0x4f
	.word 0xecdc2000  ! 2613: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r22
	mov	0x7d0, %r23
	.word 0xe0cd44a0  ! 2615: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r16
	.word 0xeeb504a0  ! 2616: STHA_R	stha	%r23, [%r20 + %r0] 0x25
	.word 0xe2bca000  ! 2617: STDA_I	stda	%r17, [%r18 + 0x0000] %asi
	.word 0xe6af0e40  ! 2618: STBA_R	stba	%r19, [%r28 + %r0] 0x72
	mov	0x28, %r26
	.word 0xe0bca000  ! 2620: STDA_I	stda	%r16, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 2621: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r27
	mov	0x40, %r16
	.word 0xe09f4e80  ! 2624: LDDA_R	ldda	[%r29, %r0] 0x74, %r16
	mov	0x7e8, %r22
	.word 0xe6b78e40  ! 2626: STHA_R	stha	%r19, [%r30 + %r0] 0x72
	.word 0xe6d544a0  ! 2627: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r19
	.word 0x8780204f  ! 2628: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r20
	.word 0xe0ace000  ! 2630: STBA_I	stba	%r16, [%r19 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0x87802072  ! 2632: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0846000  ! 2633: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r16
	.word 0xeebf8e80  ! 2634: STDA_R	stda	%r23, [%r30 + %r0] 0x74
	.word 0xe6bf4e40  ! 2635: STDA_R	stda	%r19, [%r29 + %r0] 0x72
	.word 0xe284a000  ! 2636: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r17
	.word 0xe2f4e000  ! 2637: STXA_I	stxa	%r17, [%r19 + 0x0000] %asi
	mov	0x30, %r18
	.word 0x87802025  ! 2639: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2ac6000  ! 2640: STBA_I	stba	%r17, [%r17 + 0x0000] %asi
	mov	0x38, %r16
	mov	0x48, %r17
	mov	0x38, %r25
	mov	0x60, %r17
	.word 0x8780204f  ! 2645: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4df8e40  ! 2646: LDXA_R	ldxa	[%r30, %r0] 0x72, %r18
	.word 0xeeb7a000  ! 2647: STHA_I	stha	%r23, [%r30 + 0x0000] %asi
	.word 0xee876000  ! 2648: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r23
	.word 0xeeb7a000  ! 2649: STHA_I	stha	%r23, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 2650: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r22
	.word 0x87802074  ! 2652: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xee8ce000  ! 2653: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r23
	.word 0xea8f0e40  ! 2654: LDUBA_R	lduba	[%r28, %r0] 0x72, %r21
	.word 0xe6b46000  ! 2655: STHA_I	stha	%r19, [%r17 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xe8b44400  ! 2657: STHA_R	stha	%r20, [%r17 + %r0] 0x20
	mov	0x78, %r24
	.word 0xe69c6000  ! 2659: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r19
	.word 0x87802025  ! 2660: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r19
	.word 0xe08d84a0  ! 2662: LDUBA_R	lduba	[%r22, %r0] 0x25, %r16
	mov	0x78, %r25
	.word 0xe4f7e000  ! 2664: STXA_I	stxa	%r18, [%r31 + 0x0000] %asi
	.word 0xe6b48400  ! 2665: STHA_R	stha	%r19, [%r18 + %r0] 0x20
	mov	0x7e8, %r20
	mov	0x3e0, %r23
	.word 0xe0b40400  ! 2668: STHA_R	stha	%r16, [%r16 + %r0] 0x20
	.word 0x87802025  ! 2669: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecada000  ! 2670: STBA_I	stba	%r22, [%r22 + 0x0000] %asi
	.word 0xea87ce80  ! 2671: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r21
	.word 0x87802020  ! 2672: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2cd6000  ! 2673: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r17
	.word 0xeaf6c9e0  ! 2674: STXA_R	stxa	%r21, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 2675: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r25
	.word 0xe2c52000  ! 2677: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r17
	.word 0xeaaf4e40  ! 2678: STBA_R	stba	%r21, [%r29 + %r0] 0x72
	.word 0xeab689e0  ! 2679: STHA_R	stha	%r21, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 2680: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecf649e0  ! 2681: STXA_R	stxa	%r22, [%r25 + %r0] 0x4f
	.word 0xe8b7e000  ! 2682: STHA_I	stha	%r20, [%r31 + 0x0000] %asi
	.word 0xeaa44400  ! 2683: STWA_R	stwa	%r21, [%r17 + %r0] 0x20
	.word 0xe48fce60  ! 2684: LDUBA_R	lduba	[%r31, %r0] 0x73, %r18
	mov	0x8, %r18
	.word 0xe4b544a0  ! 2686: STHA_R	stha	%r18, [%r21 + %r0] 0x25
	.word 0x87802025  ! 2687: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecd66000  ! 2688: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r22
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x3e8, %r22
	.word 0x87802073  ! 2691: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeeb649e0  ! 2692: STHA_R	stha	%r23, [%r25 + %r0] 0x4f
	.word 0xecbd44a0  ! 2693: STDA_R	stda	%r22, [%r21 + %r0] 0x25
	mov	0x70, %r19
	mov	0x60, %r19
	.word 0xecdc2000  ! 2696: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r22
	.word 0xeccc2000  ! 2697: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r22
	.word 0xeab4c400  ! 2698: STHA_R	stha	%r21, [%r19 + %r0] 0x20
	mov	0x20, %r26
	.word 0xe2bc2000  ! 2700: STDA_I	stda	%r17, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2701: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2702: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a6c9e0  ! 2703: STWA_R	stwa	%r16, [%r27 + %r0] 0x4f
	.word 0xe0f7a000  ! 2704: STXA_I	stxa	%r16, [%r30 + 0x0000] %asi
	.word 0xe0d72000  ! 2705: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r16
	.word 0xeaa4c400  ! 2706: STWA_R	stwa	%r21, [%r19 + %r0] 0x20
	.word 0xe0976000  ! 2707: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r16
	mov	0x3d8, %r20
	mov	0x7c0, %r22
	.word 0xe0a7e000  ! 2710: STWA_I	stwa	%r16, [%r31 + 0x0000] %asi
	.word 0xe4d48400  ! 2711: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r18
	mov	0x38, %r17
	.word 0xe48f6000  ! 2713: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r18
	.word 0xe4bf6000  ! 2714: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	.word 0xe4bf6000  ! 2715: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2716: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r24
	.word 0xe4d62000  ! 2718: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r18
	mov	0x3f8, %r23
	mov	0x10, %r24
	.word 0xecf48400  ! 2721: STXA_R	stxa	%r22, [%r18 + %r0] 0x20
	.word 0xe68f8e60  ! 2722: LDUBA_R	lduba	[%r30, %r0] 0x73, %r19
	.word 0xe4cea000  ! 2723: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r18
	.word 0xeabf4e80  ! 2724: STDA_R	stda	%r21, [%r29 + %r0] 0x74
	.word 0xe4ae2000  ! 2725: STBA_I	stba	%r18, [%r24 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 2727: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4d7e000  ! 2728: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r18
	mov	0x3f0, %r21
	mov	0x3e0, %r22
	.word 0x8780204f  ! 2731: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0a70e80  ! 2732: STWA_R	stwa	%r16, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2733: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2734: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2735: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecdfce40  ! 2736: LDXA_R	ldxa	[%r31, %r0] 0x72, %r22
	.word 0xe4ddc4a0  ! 2737: LDXA_R	ldxa	[%r23, %r0] 0x25, %r18
	.word 0x8780204f  ! 2738: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r27
	.word 0x87802020  ! 2740: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0b40400  ! 2741: STHA_R	stha	%r16, [%r16 + %r0] 0x20
	.word 0xea940400  ! 2742: LDUHA_R	lduha	[%r16, %r0] 0x20, %r21
	mov	0x3f0, %r23
	.word 0xecf46000  ! 2744: STXA_I	stxa	%r22, [%r17 + 0x0000] %asi
	.word 0xec8ca000  ! 2745: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r22
	.word 0xe0ce09e0  ! 2746: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r16
	mov	0x28, %r26
	.word 0x87802020  ! 2748: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2a6e000  ! 2749: STWA_I	stwa	%r17, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 2750: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2bee000  ! 2751: STDA_I	stda	%r17, [%r27 + 0x0000] %asi
	.word 0xeab6c9e0  ! 2752: STHA_R	stha	%r21, [%r27 + %r0] 0x4f
	.word 0xecf7ce40  ! 2753: STXA_R	stxa	%r22, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 2754: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe29ec9e0  ! 2755: LDDA_R	ldda	[%r27, %r0] 0x4f, %r17
	.word 0xe8af4e60  ! 2756: STBA_R	stba	%r20, [%r29 + %r0] 0x73
	mov	0x58, %r24
	.word 0x87802025  ! 2758: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0c5a000  ! 2759: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r16
	mov	0x3c8, %r23
	mov	0x28, %r25
	.word 0xe0f52000  ! 2762: STXA_I	stxa	%r16, [%r20 + 0x0000] %asi
	.word 0xe29689e0  ! 2763: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r17
	mov	0x8, %r26
	.word 0xe8b609e0  ! 2765: STHA_R	stha	%r20, [%r24 + %r0] 0x4f
	.word 0xecdf4e80  ! 2766: LDXA_R	ldxa	[%r29, %r0] 0x74, %r22
	.word 0x87802073  ! 2767: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeaa4e000  ! 2768: STWA_I	stwa	%r21, [%r19 + 0x0000] %asi
	.word 0xea8ce000  ! 2769: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r21
	.word 0xead42000  ! 2770: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r21
	.word 0xeab4c400  ! 2771: STHA_R	stha	%r21, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 2772: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeeb7ce40  ! 2773: STHA_R	stha	%r23, [%r31 + %r0] 0x72
	mov	0x58, %r27
	.word 0x87802020  ! 2775: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r27
	.word 0xee8544a0  ! 2777: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r23
	mov	0x7e0, %r20
	.word 0x87802073  ! 2779: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea8ea000  ! 2780: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r21
	.word 0xeabea000  ! 2781: STDA_I	stda	%r21, [%r26 + 0x0000] %asi
	.word 0xea966000  ! 2782: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r21
	mov	0x70, %r26
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x28, %r25
	.word 0xe4f4c400  ! 2786: STXA_R	stxa	%r18, [%r19 + %r0] 0x20
	.word 0xeab6a000  ! 2787: STHA_I	stha	%r21, [%r26 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0x87802025  ! 2789: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r20
	.word 0xe8ac8400  ! 2791: STBA_R	stba	%r20, [%r18 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x8780204f  ! 2793: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2794: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeadd6000  ! 2795: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r21
	.word 0xe4870e80  ! 2796: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r18
	.word 0xecf6c9e0  ! 2797: STXA_R	stxa	%r22, [%r27 + %r0] 0x4f
	mov	0x3d8, %r20
	.word 0xe6bd6000  ! 2799: STDA_I	stda	%r19, [%r21 + 0x0000] %asi
	mov	0x60, %r27
	mov	0x0, %r25
	.word 0xee8689e0  ! 2802: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r23
	.word 0xead7ce60  ! 2803: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r21
	.word 0xe4d56000  ! 2804: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r18
	mov	0x70, %r18
	.word 0x8780204f  ! 2806: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r21
	.word 0xeebe89e0  ! 2808: STDA_R	stda	%r23, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 2809: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xee8de000  ! 2810: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r23
	.word 0xe0bcc400  ! 2811: STDA_R	stda	%r16, [%r19 + %r0] 0x20
	.word 0x87802025  ! 2812: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xead7ce60  ! 2813: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r21
	mov	0x3e0, %r22
	mov	0x68, %r16
	.word 0xeebce000  ! 2816: STDA_I	stda	%r23, [%r19 + 0x0000] %asi
	.word 0xee846000  ! 2817: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r23
	.word 0x87802020  ! 2818: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeec6a000  ! 2819: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r23
	.word 0xecf74e80  ! 2820: STXA_R	stxa	%r22, [%r29 + %r0] 0x74
	.word 0x87802020  ! 2821: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2822: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r22
	mov	0x7f8, %r20
	mov	0x40, %r25
	.word 0xeaf7a000  ! 2826: STXA_I	stxa	%r21, [%r30 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xeab7e000  ! 2828: STHA_I	stha	%r21, [%r31 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0x87802073  ! 2830: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeabf4e80  ! 2831: STDA_R	stda	%r21, [%r29 + %r0] 0x74
	.word 0xe48649e0  ! 2832: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r18
	.word 0xe8aea000  ! 2833: STBA_I	stba	%r20, [%r26 + 0x0000] %asi
	.word 0xe68ec9e0  ! 2834: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r19
	.word 0xe4bc8400  ! 2835: STDA_R	stda	%r18, [%r18 + %r0] 0x20
	mov	0x30, %r24
	mov	0x68, %r18
	.word 0xeabf8e40  ! 2838: STDA_R	stda	%r21, [%r30 + %r0] 0x72
	mov	0x7d8, %r20
	mov	0x58, %r18
	.word 0x87802073  ! 2841: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d0, %r23
	mov	0x38, %r24
	.word 0x87802074  ! 2844: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xec9544a0  ! 2845: LDUHA_R	lduha	[%r21, %r0] 0x25, %r22
	.word 0xe68ce000  ! 2846: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r19
	.word 0xeec78e60  ! 2847: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r23
	mov	0x38, %r18
	.word 0xe0adc4a0  ! 2849: STBA_R	stba	%r16, [%r23 + %r0] 0x25
	.word 0xe68c6000  ! 2850: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r19
	.word 0x87802020  ! 2851: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6ade000  ! 2852: STBA_I	stba	%r19, [%r23 + 0x0000] %asi
	.word 0xe6f48400  ! 2853: STXA_R	stxa	%r19, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2854: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0cfa000  ! 2855: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r16
	.word 0x8780204f  ! 2856: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0f72000  ! 2857: STXA_I	stxa	%r16, [%r28 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xe2f74e80  ! 2859: STXA_R	stxa	%r17, [%r29 + %r0] 0x74
	.word 0xea9f2000  ! 2860: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r21
	.word 0xecb544a0  ! 2861: STHA_R	stha	%r22, [%r21 + %r0] 0x25
	mov	0x28, %r25
	wr_tick_cmpr_3_25:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc9, %g2
	or	%g4, 0xa9, %g4
	or	%g6, 0xea, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x78, %r18
	.word 0xe6f7ce40  ! 2865: STXA_R	stxa	%r19, [%r31 + %r0] 0x72
	.word 0xe0944400  ! 2866: LDUHA_R	lduha	[%r17, %r0] 0x20, %r16
	mov	0x58, %r19
	.word 0xe2d504a0  ! 2868: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r17
	.word 0xe2afe000  ! 2869: STBA_I	stba	%r17, [%r31 + 0x0000] %asi
	.word 0xe29f2000  ! 2870: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r17
	.word 0xe4944400  ! 2871: LDUHA_R	lduha	[%r17, %r0] 0x20, %r18
	.word 0xe88fce40  ! 2872: LDUBA_R	lduba	[%r31, %r0] 0x72, %r20
	.word 0xe8a76000  ! 2873: STWA_I	stwa	%r20, [%r29 + 0x0000] %asi
	.word 0xea9f0e40  ! 2874: LDDA_R	ldda	[%r28, %r0] 0x72, %r21
	.word 0x87802072  ! 2875: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 2877: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeec70e80  ! 2878: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r23
	.word 0x87802020  ! 2879: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeac72000  ! 2880: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r21
	.word 0x87802074  ! 2881: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r27
	mov	0x38, %r24
	.word 0xeaf72000  ! 2884: STXA_I	stxa	%r21, [%r28 + 0x0000] %asi
	.word 0xea9f2000  ! 2885: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r21
	.word 0xeaafe000  ! 2886: STBA_I	stba	%r21, [%r31 + 0x0000] %asi
	.word 0xeacfa000  ! 2887: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r21
	.word 0xeaafa000  ! 2888: STBA_I	stba	%r21, [%r30 + 0x0000] %asi
	.word 0xea8f2000  ! 2889: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r21
	.word 0x87802020  ! 2890: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeac4e000  ! 2891: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r21
	mov	0x20, %r27
	.word 0x87802025  ! 2893: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r27
	.word 0xeaa6a000  ! 2895: STWA_I	stwa	%r21, [%r26 + 0x0000] %asi
	.word 0xe6b78e40  ! 2896: STHA_R	stha	%r19, [%r30 + %r0] 0x72
	.word 0xec8f4e80  ! 2897: LDUBA_R	lduba	[%r29, %r0] 0x74, %r22
	mov	0x58, %r16
	.word 0xe0be6000  ! 2899: STDA_I	stda	%r16, [%r25 + 0x0000] %asi
	.word 0xe0ce2000  ! 2900: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r16
	mov	0x78, %r27
	.word 0xe0bc4400  ! 2902: STDA_R	stda	%r16, [%r17 + %r0] 0x20
	.word 0xe4ae6000  ! 2903: STBA_I	stba	%r18, [%r25 + 0x0000] %asi
	.word 0xee944400  ! 2904: LDUHA_R	lduha	[%r17, %r0] 0x20, %r23
	mov	0x60, %r18
	.word 0x87802020  ! 2906: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r24
	.word 0x87802020  ! 2908: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r16
	.word 0x87802020  ! 2910: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2911: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0d7a000  ! 2912: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r16
	.word 0xe0dfe000  ! 2913: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r16
	.word 0xe0a72000  ! 2914: STWA_I	stwa	%r16, [%r28 + 0x0000] %asi
	.word 0xe0a7e000  ! 2915: STWA_I	stwa	%r16, [%r31 + 0x0000] %asi
	.word 0xe097a000  ! 2916: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r16
	mov	0x38, %r16
	.word 0x87802020  ! 2918: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe08f6000  ! 2919: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r16
	.word 0xe6dc8400  ! 2920: LDXA_R	ldxa	[%r18, %r0] 0x20, %r19
	.word 0xe0bf0e40  ! 2921: STDA_R	stda	%r16, [%r28 + %r0] 0x72
	.word 0x87802074  ! 2922: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4d649e0  ! 2923: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r18
	.word 0xec8c6000  ! 2924: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r22
	.word 0xe6b44400  ! 2925: STHA_R	stha	%r19, [%r17 + %r0] 0x20
	.word 0xe8840400  ! 2926: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r20
	mov	0x48, %r26
	mov	0x28, %r25
	mov	0x68, %r17
	.word 0xeaaf8e80  ! 2930: STBA_R	stba	%r21, [%r30 + %r0] 0x74
	.word 0xecf42000  ! 2931: STXA_I	stxa	%r22, [%r16 + 0x0000] %asi
	.word 0xe2f7ce40  ! 2932: STXA_R	stxa	%r17, [%r31 + %r0] 0x72
	.word 0xe6ad44a0  ! 2933: STBA_R	stba	%r19, [%r21 + %r0] 0x25
	.word 0xe4b4e000  ! 2934: STHA_I	stha	%r18, [%r19 + 0x0000] %asi
	.word 0xe4ac2000  ! 2935: STBA_I	stba	%r18, [%r16 + 0x0000] %asi
	.word 0xe68f0e60  ! 2936: LDUBA_R	lduba	[%r28, %r0] 0x73, %r19
	.word 0xea9c6000  ! 2937: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r21
	.word 0xeac4e000  ! 2938: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r21
	.word 0x87802074  ! 2939: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8df4e40  ! 2940: LDXA_R	ldxa	[%r29, %r0] 0x72, %r20
	.word 0xe8a609e0  ! 2941: STWA_R	stwa	%r20, [%r24 + %r0] 0x4f
	.word 0xe0af0e80  ! 2942: STBA_R	stba	%r16, [%r28 + %r0] 0x74
	mov	0x8, %r18
	.word 0xe8cf6000  ! 2944: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r20
	mov	0x58, %r27
	.word 0xe2dc0400  ! 2946: LDXA_R	ldxa	[%r16, %r0] 0x20, %r17
	.word 0xeeafe000  ! 2947: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0xeebf2000  ! 2948: STDA_I	stda	%r23, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2949: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r18
	.word 0xe6d584a0  ! 2951: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r19
	mov	0x7f0, %r23
	mov	0x8, %r27
	.word 0xe4978e80  ! 2954: LDUHA_R	lduha	[%r30, %r0] 0x74, %r18
	mov	0x20, %r17
	.word 0xecf74e60  ! 2956: STXA_R	stxa	%r22, [%r29 + %r0] 0x73
	.word 0xe2bcc400  ! 2957: STDA_R	stda	%r17, [%r19 + %r0] 0x20
	.word 0xe284e000  ! 2958: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r17
	.word 0x87802020  ! 2959: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r27
	.word 0xeaa74e80  ! 2961: STWA_R	stwa	%r21, [%r29 + %r0] 0x74
	mov	0x38, %r25
	mov	0x48, %r18
	.word 0xeaf74e80  ! 2964: STXA_R	stxa	%r21, [%r29 + %r0] 0x74
	.word 0xe0c5c4a0  ! 2965: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r16
	.word 0xe6d42000  ! 2966: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r19
	mov	0x10, %r18
	.word 0xee8c0400  ! 2968: LDUBA_R	lduba	[%r16, %r0] 0x20, %r23
	.word 0x8780204f  ! 2969: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2970: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2842000  ! 2971: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r17
	.word 0xeebc4400  ! 2972: STDA_R	stda	%r23, [%r17 + %r0] 0x20
	mov	0x58, %r26
	.word 0xea8c8400  ! 2974: LDUBA_R	lduba	[%r18, %r0] 0x20, %r21
	.word 0xe09c2000  ! 2975: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r16
	mov	0x3f8, %r22
	mov	0x10, %r26
	.word 0x87802074  ! 2978: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0f7e000  ! 2979: STXA_I	stxa	%r16, [%r31 + 0x0000] %asi
	.word 0xe0b72000  ! 2980: STHA_I	stha	%r16, [%r28 + 0x0000] %asi
	.word 0xe2b48400  ! 2981: STHA_R	stha	%r17, [%r18 + %r0] 0x20
	.word 0xe8bf6000  ! 2982: STDA_I	stda	%r20, [%r29 + 0x0000] %asi
	.word 0xe6b44400  ! 2983: STHA_R	stha	%r19, [%r17 + %r0] 0x20
	.word 0xeec76000  ! 2984: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r23
	.word 0x87802073  ! 2985: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea8f0e60  ! 2986: LDUBA_R	lduba	[%r28, %r0] 0x73, %r21
	mov	0x7f8, %r20
	.word 0xeebf0e60  ! 2988: STDA_R	stda	%r23, [%r28 + %r0] 0x73
	wr_tick_cmpr_3_26:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc3, %g2
	or	%g4, 0xb0, %g4
	or	%g6, 0xf1, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeeb48400  ! 2990: STHA_R	stha	%r23, [%r18 + %r0] 0x20
	.word 0xea9da000  ! 2991: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r21
	.word 0xecbf0e40  ! 2992: STDA_R	stda	%r22, [%r28 + %r0] 0x72
	.word 0xea9f4e60  ! 2993: LDDA_R	ldda	[%r29, %r0] 0x73, %r21
	mov	0x50, %r24
	.word 0xecc78e40  ! 2995: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r22
	.word 0xeabc8400  ! 2996: STDA_R	stda	%r21, [%r18 + %r0] 0x20
	mov	0x8, %r27
	.word 0x87802025  ! 2998: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8f7e000  ! 2999: STXA_I	stxa	%r20, [%r31 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xe8df6000  ! 3001: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r20
	.word 0x87802020  ! 3002: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3003: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3004: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3005: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xee940400  ! 3006: LDUHA_R	lduha	[%r16, %r0] 0x20, %r23
	.word 0xe6b7ce60  ! 3007: STHA_R	stha	%r19, [%r31 + %r0] 0x73
	.word 0x87802072  ! 3008: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r16
	.word 0xec97a000  ! 3010: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r22
	mov	0x8, %r19
	.word 0xec940400  ! 3012: LDUHA_R	lduha	[%r16, %r0] 0x20, %r22
	.word 0xea844400  ! 3013: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r21
	.word 0xe2f48400  ! 3014: STXA_R	stxa	%r17, [%r18 + %r0] 0x20
	.word 0x87802073  ! 3015: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeccc0400  ! 3016: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r22
	mov	0x8, %r25
	.word 0xe48d44a0  ! 3018: LDUBA_R	lduba	[%r21, %r0] 0x25, %r18
	.word 0xe6a4e000  ! 3019: STWA_I	stwa	%r19, [%r19 + 0x0000] %asi
	.word 0xe4be49e0  ! 3020: STDA_R	stda	%r18, [%r25 + %r0] 0x4f
	mov	0x7c8, %r21
	.word 0xe8ccc400  ! 3022: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r20
	.word 0xeef46000  ! 3023: STXA_I	stxa	%r23, [%r17 + 0x0000] %asi
	.word 0xe2bf8e60  ! 3024: STDA_R	stda	%r17, [%r30 + %r0] 0x73
	.word 0x87802072  ! 3025: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2dd44a0  ! 3026: LDXA_R	ldxa	[%r21, %r0] 0x25, %r17
	.word 0xe68f8e40  ! 3027: LDUBA_R	lduba	[%r30, %r0] 0x72, %r19
	.word 0xe0bf0e60  ! 3028: STDA_R	stda	%r16, [%r28 + %r0] 0x73
	mov	0x70, %r24
	.word 0xe29544a0  ! 3030: LDUHA_R	lduha	[%r21, %r0] 0x25, %r17
	mov	0x20, %r18
	.word 0xec85a000  ! 3032: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r22
	.word 0xe686c9e0  ! 3033: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r19
	mov	0x3c8, %r22
	.word 0xeaa5e000  ! 3035: STWA_I	stwa	%r21, [%r23 + 0x0000] %asi
	.word 0xea856000  ! 3036: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r21
	mov	0x18, %r27
	.word 0xe6cf0e80  ! 3038: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r19
	.word 0xe2d70e40  ! 3039: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r17
	.word 0x87802073  ! 3040: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeaac4400  ! 3041: STBA_R	stba	%r21, [%r17 + %r0] 0x20
	.word 0xe2d42000  ! 3042: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r17
	.word 0x87802073  ! 3043: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6cdc4a0  ! 3044: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r19
	.word 0x87802074  ! 3045: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8a4e000  ! 3046: STWA_I	stwa	%r20, [%r19 + 0x0000] %asi
	.word 0xe8dce000  ! 3047: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r20
	.word 0xe8942000  ! 3048: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r20
	.word 0xe4dc8400  ! 3049: LDXA_R	ldxa	[%r18, %r0] 0x20, %r18
	.word 0xeaf42000  ! 3050: STXA_I	stxa	%r21, [%r16 + 0x0000] %asi
	.word 0xe2c48400  ! 3051: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r17
	mov	0x18, %r16
	mov	0x48, %r24
	.word 0xeaf74e60  ! 3054: STXA_R	stxa	%r21, [%r29 + %r0] 0x73
	.word 0xe8afce80  ! 3055: STBA_R	stba	%r20, [%r31 + %r0] 0x74
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x10, %r18
	mov	0x28, %r24
	.word 0x8780204f  ! 3059: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6f7e000  ! 3060: STXA_I	stxa	%r19, [%r31 + 0x0000] %asi
	.word 0xecdd44a0  ! 3061: LDXA_R	ldxa	[%r21, %r0] 0x25, %r22
	.word 0xecdfa000  ! 3062: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r22
	mov	0x0, %r16
	.word 0xea870e80  ! 3064: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r21
	.word 0xe0f76000  ! 3065: STXA_I	stxa	%r16, [%r29 + 0x0000] %asi
	.word 0xeabf0e80  ! 3066: STDA_R	stda	%r21, [%r28 + %r0] 0x74
	.word 0xecaf2000  ! 3067: STBA_I	stba	%r22, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3068: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xec8ce000  ! 3069: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r22
	.word 0xe29f4e40  ! 3070: LDDA_R	ldda	[%r29, %r0] 0x72, %r17
	.word 0xeec649e0  ! 3071: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r23
	.word 0xe6af8e60  ! 3072: STBA_R	stba	%r19, [%r30 + %r0] 0x73
	.word 0x87802020  ! 3073: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3074: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2dfe000  ! 3075: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r17
	.word 0xe29fe000  ! 3076: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r17
	.word 0xe08f0e40  ! 3077: LDUBA_R	lduba	[%r28, %r0] 0x72, %r16
	.word 0xe6a7a000  ! 3078: STWA_I	stwa	%r19, [%r30 + 0x0000] %asi
	mov	0x7f0, %r20
	mov	0x3d8, %r22
	.word 0x87802072  ! 3081: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6b72000  ! 3082: STHA_I	stha	%r19, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3083: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r18
	.word 0xec944400  ! 3085: LDUHA_R	lduha	[%r17, %r0] 0x20, %r22
	.word 0xe0a42000  ! 3086: STWA_I	stwa	%r16, [%r16 + 0x0000] %asi
	.word 0xe4b4c400  ! 3087: STHA_R	stha	%r18, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3088: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3089: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r17
	mov	0x28, %r18
	.word 0xe6bdc4a0  ! 3092: STDA_R	stda	%r19, [%r23 + %r0] 0x25
	.word 0x87802073  ! 3093: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 3094: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8a4e000  ! 3095: STWA_I	stwa	%r20, [%r19 + 0x0000] %asi
	.word 0xe89c6000  ! 3096: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r20
	.word 0xe8c46000  ! 3097: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r20
	.word 0xe8c46000  ! 3098: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r20
	.word 0x87802020  ! 3099: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe88ca000  ! 3100: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r20
	mov	0x3d0, %r22
	.word 0xe484c400  ! 3102: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r18
	.word 0xea94c400  ! 3103: LDUHA_R	lduha	[%r19, %r0] 0x20, %r21
	mov	0x50, %r26
	mov	0x3f8, %r20
	.word 0xe0bce000  ! 3106: STDA_I	stda	%r16, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3107: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4cf8e60  ! 3108: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r18
	.word 0x87802072  ! 3109: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xee8fce60  ! 3110: LDUBA_R	lduba	[%r31, %r0] 0x73, %r23
	mov	0x30, %r17
	.word 0xe6d544a0  ! 3112: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r19
	.word 0xeca7ce80  ! 3113: STWA_R	stwa	%r22, [%r31 + %r0] 0x74
	.word 0xec8f6000  ! 3114: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	.word 0xe8a44400  ! 3115: STWA_R	stwa	%r20, [%r17 + %r0] 0x20
	.word 0xe49f8e60  ! 3116: LDDA_R	ldda	[%r30, %r0] 0x73, %r18
	mov	0x7f8, %r22
	.word 0xe8878e80  ! 3118: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r20
	.word 0xeedf6000  ! 3119: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r23
	mov	0x60, %r18
	.word 0xeed7a000  ! 3121: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r23
	.word 0x8780204f  ! 3122: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xee87a000  ! 3123: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r23
	.word 0xe68f4e80  ! 3124: LDUBA_R	lduba	[%r29, %r0] 0x74, %r19
	.word 0xe4f76000  ! 3125: STXA_I	stxa	%r18, [%r29 + 0x0000] %asi
	.word 0xe69cc400  ! 3126: LDDA_R	ldda	[%r19, %r0] 0x20, %r19
	.word 0xea9fe000  ! 3127: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r21
	mov	0x38, %r17
	.word 0xeabfa000  ! 3129: STDA_I	stda	%r21, [%r30 + 0x0000] %asi
	.word 0xeabfa000  ! 3130: STDA_I	stda	%r21, [%r30 + 0x0000] %asi
	.word 0xe6944400  ! 3131: LDUHA_R	lduha	[%r17, %r0] 0x20, %r19
	.word 0xe2f7e000  ! 3132: STXA_I	stxa	%r17, [%r31 + 0x0000] %asi
	.word 0xe69d84a0  ! 3133: LDDA_R	ldda	[%r22, %r0] 0x25, %r19
	mov	0x78, %r25
	.word 0xe2ae89e0  ! 3135: STBA_R	stba	%r17, [%r26 + %r0] 0x4f
	.word 0xeeafe000  ! 3136: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0xe4d78e80  ! 3137: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r18
	mov	0x7f8, %r20
	.word 0xecaf2000  ! 3139: STBA_I	stba	%r22, [%r28 + 0x0000] %asi
	wr_tick_cmpr_3_27:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa3, %g2
	or	%g4, 0xbd, %g4
	or	%g6, 0xa4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x20, %r26
	.word 0x8780204f  ! 3142: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecc4e000  ! 3143: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r22
	.word 0xecf46000  ! 3144: STXA_I	stxa	%r22, [%r17 + 0x0000] %asi
	.word 0xecace000  ! 3145: STBA_I	stba	%r22, [%r19 + 0x0000] %asi
	.word 0xeaa70e60  ! 3146: STWA_R	stwa	%r21, [%r28 + %r0] 0x73
	.word 0xe6946000  ! 3147: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r19
	.word 0x87802074  ! 3148: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe297ce80  ! 3149: LDUHA_R	lduha	[%r31, %r0] 0x74, %r17
	mov	0x50, %r26
	.word 0xe6cc2000  ! 3151: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r19
	mov	0x7c0, %r20
	.word 0x87802073  ! 3153: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6a5a000  ! 3154: STWA_I	stwa	%r19, [%r22 + 0x0000] %asi
	.word 0xeacc4400  ! 3155: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r21
	.word 0xecad6000  ! 3156: STBA_I	stba	%r22, [%r21 + 0x0000] %asi
	.word 0xe0cdc4a0  ! 3157: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r16
	mov	0x68, %r17
	mov	0x3f8, %r21
	mov	0x20, %r18
	mov	0x7d8, %r21
	mov	0x78, %r16
	mov	0x40, %r17
	.word 0xe4b5a000  ! 3164: STHA_I	stha	%r18, [%r22 + 0x0000] %asi
	.word 0xeebf0e60  ! 3165: STDA_R	stda	%r23, [%r28 + %r0] 0x73
	.word 0xe0d5a000  ! 3166: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r16
	.word 0x87802020  ! 3167: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0df6000  ! 3168: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r16
	mov	0x70, %r19
	.word 0xe09f2000  ! 3170: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r16
	.word 0xe09f6000  ! 3171: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r16
	.word 0xecbfce60  ! 3172: STDA_R	stda	%r22, [%r31 + %r0] 0x73
	.word 0xe0b72000  ! 3173: STHA_I	stha	%r16, [%r28 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xe89cc400  ! 3175: LDDA_R	ldda	[%r19, %r0] 0x20, %r20
	.word 0xecaf4e60  ! 3176: STBA_R	stba	%r22, [%r29 + %r0] 0x73
	.word 0x87802025  ! 3177: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeab7ce60  ! 3178: STHA_R	stha	%r21, [%r31 + %r0] 0x73
	.word 0xeadca000  ! 3179: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r21
	mov	0x7e8, %r21
	.word 0xe2a78e40  ! 3181: STWA_R	stwa	%r17, [%r30 + %r0] 0x72
	.word 0xe28f0e80  ! 3182: LDUBA_R	lduba	[%r28, %r0] 0x74, %r17
	.word 0xe8d7ce80  ! 3183: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r20
	.word 0xe894e000  ! 3184: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r20
	.word 0xe4bdc4a0  ! 3185: STDA_R	stda	%r18, [%r23 + %r0] 0x25
	mov	0x30, %r19
	.word 0x87802074  ! 3187: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2de6000  ! 3188: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r17
	.word 0xe2f66000  ! 3189: STXA_I	stxa	%r17, [%r25 + 0x0000] %asi
	.word 0xe0cc8400  ! 3190: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r16
	.word 0xecd504a0  ! 3191: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r22
	.word 0xe0c62000  ! 3192: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r16
	.word 0xec944400  ! 3193: LDUHA_R	lduha	[%r17, %r0] 0x20, %r22
	.word 0xe4bf4e80  ! 3194: STDA_R	stda	%r18, [%r29 + %r0] 0x74
	.word 0xec970e60  ! 3195: LDUHA_R	lduha	[%r28, %r0] 0x73, %r22
	mov	0x3e8, %r20
	.word 0x87802072  ! 3197: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0cf2000  ! 3198: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r16
	mov	0x40, %r17
	.word 0x87802073  ! 3200: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r16
	.word 0xe0c76000  ! 3202: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r16
	mov	0x28, %r18
	mov	0x3c0, %r23
	mov	0x58, %r18
	mov	0x10, %r27
	.word 0xe097a000  ! 3207: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r16
	mov	0x7f0, %r23
	.word 0xe2df4e80  ! 3209: LDXA_R	ldxa	[%r29, %r0] 0x74, %r17
	.word 0x8780204f  ! 3210: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecc5a000  ! 3211: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r22
	.word 0x87802025  ! 3212: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0cf4e40  ! 3213: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r16
	.word 0x87802020  ! 3214: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r21
	.word 0x87802020  ! 3216: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea962000  ! 3217: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r21
	.word 0xe0bfce40  ! 3218: STDA_R	stda	%r16, [%r31 + %r0] 0x72
	.word 0xe0c504a0  ! 3219: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r16
	.word 0xeca609e0  ! 3220: STWA_R	stwa	%r22, [%r24 + %r0] 0x4f
	.word 0xe29ee000  ! 3221: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r17
	.word 0xe2b62000  ! 3222: STHA_I	stha	%r17, [%r24 + 0x0000] %asi
	.word 0xe48e89e0  ! 3223: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r18
	.word 0xe48ea000  ! 3224: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r18
	mov	0x7c8, %r21
	.word 0xe4f649e0  ! 3226: STXA_R	stxa	%r18, [%r25 + %r0] 0x4f
	.word 0xe496e000  ! 3227: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r18
	mov	0x78, %r26
	.word 0x87802074  ! 3229: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3230: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3231: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3232: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r27
	.word 0x87802072  ! 3234: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeeb70e80  ! 3235: STHA_R	stha	%r23, [%r28 + %r0] 0x74
	.word 0xea874e80  ! 3236: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r21
	.word 0xeaac8400  ! 3237: STBA_R	stba	%r21, [%r18 + %r0] 0x20
	.word 0x87802072  ! 3238: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6940400  ! 3239: LDUHA_R	lduha	[%r16, %r0] 0x20, %r19
	.word 0xecf4c400  ! 3240: STXA_R	stxa	%r22, [%r19 + %r0] 0x20
	.word 0xe0cf8e40  ! 3241: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r16
	mov	0x58, %r25
	.word 0xecdf8e80  ! 3243: LDXA_R	ldxa	[%r30, %r0] 0x74, %r22
	mov	0x50, %r24
	mov	0x30, %r16
	.word 0x87802073  ! 3246: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6a78e40  ! 3247: STWA_R	stwa	%r19, [%r30 + %r0] 0x72
	.word 0xe687a000  ! 3248: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r19
	.word 0xe6cf6000  ! 3249: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r19
	.word 0xe0f70e80  ! 3250: STXA_R	stxa	%r16, [%r28 + %r0] 0x74
	.word 0xe8b7a000  ! 3251: STHA_I	stha	%r20, [%r30 + 0x0000] %asi
	.word 0xea9fce40  ! 3252: LDDA_R	ldda	[%r31, %r0] 0x72, %r21
	mov	0x58, %r27
	mov	0x3c0, %r20
	.word 0x87802074  ! 3255: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3256: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r18
	.word 0xeea46000  ! 3258: STWA_I	stwa	%r23, [%r17 + 0x0000] %asi
	.word 0xeea4e000  ! 3259: STWA_I	stwa	%r23, [%r19 + 0x0000] %asi
	.word 0xeebca000  ! 3260: STDA_I	stda	%r23, [%r18 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xeecce000  ! 3262: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r23
	.word 0xee9c2000  ! 3263: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r23
	.word 0xe0974e60  ! 3264: LDUHA_R	lduha	[%r29, %r0] 0x73, %r16
	.word 0xe49c0400  ! 3265: LDDA_R	ldda	[%r16, %r0] 0x20, %r18
	.word 0x87802020  ! 3266: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3267: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r22
	.word 0xeccf2000  ! 3269: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r22
	.word 0xecf76000  ! 3270: STXA_I	stxa	%r22, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 3271: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xea9c4400  ! 3272: LDDA_R	ldda	[%r17, %r0] 0x20, %r21
	.word 0xe4b6c9e0  ! 3273: STHA_R	stha	%r18, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 3274: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe484a000  ! 3275: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r18
	.word 0xecd48400  ! 3276: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r22
	mov	0x7f0, %r20
	.word 0xeab70e80  ! 3278: STHA_R	stha	%r21, [%r28 + %r0] 0x74
	.word 0x87802025  ! 3279: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeab7ce80  ! 3280: STHA_R	stha	%r21, [%r31 + %r0] 0x74
	.word 0xe8bc6000  ! 3281: STDA_I	stda	%r20, [%r17 + 0x0000] %asi
	.word 0xe4a40400  ! 3282: STWA_R	stwa	%r18, [%r16 + %r0] 0x20
	mov	0x20, %r26
	.word 0xeab4a000  ! 3284: STHA_I	stha	%r21, [%r18 + 0x0000] %asi
	.word 0xeabca000  ! 3285: STDA_I	stda	%r21, [%r18 + 0x0000] %asi
	.word 0xeade49e0  ! 3286: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r21
	.word 0xe8cf0e40  ! 3287: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r20
	.word 0xe684a000  ! 3288: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r19
	.word 0xe6842000  ! 3289: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r19
	.word 0xe6cc6000  ! 3290: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r19
	mov	0x7c0, %r23
	.word 0xeaa70e40  ! 3292: STWA_R	stwa	%r21, [%r28 + %r0] 0x72
	mov	0x60, %r17
	.word 0xe4d78e60  ! 3294: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r18
	mov	0x10, %r26
	.word 0x87802074  ! 3296: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r16
	.word 0x87802020  ! 3298: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3299: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2a7ce80  ! 3300: STWA_R	stwa	%r17, [%r31 + %r0] 0x74
	.word 0xe8f7e000  ! 3301: STXA_I	stxa	%r20, [%r31 + 0x0000] %asi
	.word 0xe8b78e60  ! 3302: STHA_R	stha	%r20, [%r30 + %r0] 0x73
	.word 0xeeb5c4a0  ! 3303: STHA_R	stha	%r23, [%r23 + %r0] 0x25
	.word 0x87802020  ! 3304: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r17
	.word 0xe0c6a000  ! 3306: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r16
	wr_tick_cmpr_3_28:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb0, %g2
	or	%g4, 0xb8, %g4
	or	%g6, 0xd6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x30, %r16
	.word 0xe0be2000  ! 3309: STDA_I	stda	%r16, [%r24 + 0x0000] %asi
	.word 0xe2f74e60  ! 3310: STXA_R	stxa	%r17, [%r29 + %r0] 0x73
	.word 0xe2966000  ! 3311: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r17
	.word 0xe2d6a000  ! 3312: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r17
	.word 0xe2c66000  ! 3313: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r17
	.word 0xe2be6000  ! 3314: STDA_I	stda	%r17, [%r25 + 0x0000] %asi
	.word 0xe2a66000  ! 3315: STWA_I	stwa	%r17, [%r25 + 0x0000] %asi
	.word 0xe2cee000  ! 3316: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r17
	.word 0xe0d6c9e0  ! 3317: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r16
	mov	0x0, %r25
	.word 0xe2cea000  ! 3319: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r17
	.word 0xe2c62000  ! 3320: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r17
	.word 0xe286e000  ! 3321: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r17
	.word 0xe2cee000  ! 3322: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r17
	mov	0x50, %r27
	.word 0xeead04a0  ! 3324: STBA_R	stba	%r23, [%r20 + %r0] 0x25
	.word 0xe2afce80  ! 3325: STBA_R	stba	%r17, [%r31 + %r0] 0x74
	.word 0x87802025  ! 3326: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeab42000  ! 3327: STHA_I	stha	%r21, [%r16 + 0x0000] %asi
	.word 0xe69e49e0  ! 3328: LDDA_R	ldda	[%r25, %r0] 0x4f, %r19
	.word 0xe8974e80  ! 3329: LDUHA_R	lduha	[%r29, %r0] 0x74, %r20
	.word 0xe49c6000  ! 3330: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r18
	.word 0xe4b46000  ! 3331: STHA_I	stha	%r18, [%r17 + 0x0000] %asi
	mov	0x78, %r24
	mov	0x3d0, %r23
	.word 0xe4d46000  ! 3334: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r18
	.word 0xe4cc6000  ! 3335: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r18
	.word 0xe4c649e0  ! 3336: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r18
	mov	0x60, %r18
	.word 0xe6878e60  ! 3338: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r19
	mov	0x18, %r26
	.word 0xeeac2000  ! 3340: STBA_I	stba	%r23, [%r16 + 0x0000] %asi
	.word 0xee8ca000  ! 3341: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r23
	mov	0x70, %r24
	.word 0xeef46000  ! 3343: STXA_I	stxa	%r23, [%r17 + 0x0000] %asi
	.word 0xeeb4a000  ! 3344: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	mov	0x78, %r16
	.word 0x87802020  ! 3346: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe08d04a0  ! 3347: LDUBA_R	lduba	[%r20, %r0] 0x25, %r16
	.word 0xe2cf8e60  ! 3348: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r17
	.word 0xec966000  ! 3349: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r22
	.word 0x87802025  ! 3350: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4944400  ! 3351: LDUHA_R	lduha	[%r17, %r0] 0x20, %r18
	.word 0xee8ce000  ! 3352: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r23
	.word 0xeebc6000  ! 3353: STDA_I	stda	%r23, [%r17 + 0x0000] %asi
	.word 0xeea42000  ! 3354: STWA_I	stwa	%r23, [%r16 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xecf40400  ! 3356: STXA_R	stxa	%r22, [%r16 + %r0] 0x20
	.word 0x87802072  ! 3357: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecb5a000  ! 3358: STHA_I	stha	%r22, [%r22 + 0x0000] %asi
	mov	0x30, %r26
	mov	0x7d0, %r20
	mov	0x3d8, %r22
	mov	0x0, %r16
	.word 0xec8da000  ! 3363: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r22
	mov	0x20, %r24
	.word 0x8780204f  ! 3365: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecdea000  ! 3366: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r22
	mov	0x60, %r25
	mov	0x8, %r16
	.word 0x87802073  ! 3369: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6dc8400  ! 3370: LDXA_R	ldxa	[%r18, %r0] 0x20, %r19
	.word 0xe0ce09e0  ! 3371: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r16
	.word 0xe88c6000  ! 3372: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r20
	mov	0x3d0, %r23
	.word 0xe8bca000  ! 3374: STDA_I	stda	%r20, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 3375: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r25
	.word 0xec8d44a0  ! 3377: LDUBA_R	lduba	[%r21, %r0] 0x25, %r22
	.word 0x87802020  ! 3378: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe89fce40  ! 3379: LDDA_R	ldda	[%r31, %r0] 0x72, %r20
	.word 0x8780204f  ! 3380: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe28c4400  ! 3381: LDUBA_R	lduba	[%r17, %r0] 0x20, %r17
	.word 0xe6a72000  ! 3382: STWA_I	stwa	%r19, [%r28 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xe8bc4400  ! 3384: STDA_R	stda	%r20, [%r17 + %r0] 0x20
	.word 0xe6a76000  ! 3385: STWA_I	stwa	%r19, [%r29 + 0x0000] %asi
	mov	0x7e0, %r23
	mov	0x68, %r17
	mov	0x3c0, %r22
	.word 0xe0bcc400  ! 3389: STDA_R	stda	%r16, [%r19 + %r0] 0x20
	.word 0xec974e60  ! 3390: LDUHA_R	lduha	[%r29, %r0] 0x73, %r22
	.word 0xea8fa000  ! 3391: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r21
	.word 0xe08504a0  ! 3392: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r16
	.word 0xe4d76000  ! 3393: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r18
	.word 0xe4972000  ! 3394: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r18
	mov	0x50, %r25
	.word 0xe497a000  ! 3396: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r18
	.word 0xeaf7ce60  ! 3397: STXA_R	stxa	%r21, [%r31 + %r0] 0x73
	.word 0xe4dfa000  ! 3398: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r18
	.word 0x87802020  ! 3399: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4a7ce60  ! 3400: STWA_R	stwa	%r18, [%r31 + %r0] 0x73
	mov	0x28, %r17
	.word 0x87802072  ! 3402: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0b52000  ! 3403: STHA_I	stha	%r16, [%r20 + 0x0000] %asi
	.word 0xe08d6000  ! 3404: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r16
	mov	0x40, %r24
	.word 0xeedc0400  ! 3406: LDXA_R	ldxa	[%r16, %r0] 0x20, %r23
	mov	0x50, %r16
	.word 0xeab5a000  ! 3408: STHA_I	stha	%r21, [%r22 + 0x0000] %asi
	.word 0xe8bcc400  ! 3409: STDA_R	stda	%r20, [%r19 + %r0] 0x20
	mov	0x8, %r25
	.word 0x87802074  ! 3411: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r26
	mov	0x18, %r16
	.word 0x87802025  ! 3414: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8a4c400  ! 3415: STWA_R	stwa	%r20, [%r19 + %r0] 0x20
	.word 0xea8ca000  ! 3416: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r21
	.word 0xea8ca000  ! 3417: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r21
	.word 0xea9c2000  ! 3418: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r21
	.word 0xe496c9e0  ! 3419: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r18
	.word 0xeebca000  ! 3420: STDA_I	stda	%r23, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 3421: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r27
	.word 0xee876000  ! 3423: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r23
	.word 0xe88f0e60  ! 3424: LDUBA_R	lduba	[%r28, %r0] 0x73, %r20
	.word 0xeea7ce60  ! 3425: STWA_R	stwa	%r23, [%r31 + %r0] 0x73
	.word 0x87802072  ! 3426: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8c7ce60  ! 3427: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r20
	mov	0x78, %r18
	.word 0x87802074  ! 3429: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3430: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r19
	.word 0xeebc0400  ! 3432: STDA_R	stda	%r23, [%r16 + %r0] 0x20
	.word 0x87802025  ! 3433: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6bf6000  ! 3434: STDA_I	stda	%r19, [%r29 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xe0dcc400  ! 3436: LDXA_R	ldxa	[%r19, %r0] 0x20, %r16
	.word 0xe8cf4e40  ! 3437: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r20
	mov	0x3f0, %r22
	.word 0xeaf70e40  ! 3439: STXA_R	stxa	%r21, [%r28 + %r0] 0x72
	.word 0xe8b76000  ! 3440: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	.word 0xe6b40400  ! 3441: STHA_R	stha	%r19, [%r16 + %r0] 0x20
	.word 0xe6dc4400  ! 3442: LDXA_R	ldxa	[%r17, %r0] 0x20, %r19
	.word 0xe4d6c9e0  ! 3443: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r18
	.word 0xeed70e40  ! 3444: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r23
	.word 0xe8d72000  ! 3445: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r20
	.word 0x87802074  ! 3446: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8972000  ! 3447: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r20
	.word 0x87802073  ! 3448: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeaf5c4a0  ! 3449: STXA_R	stxa	%r21, [%r23 + %r0] 0x25
	.word 0xee84a000  ! 3450: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r23
	.word 0xee8ca000  ! 3451: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r23
	.word 0xeeac2000  ! 3452: STBA_I	stba	%r23, [%r16 + 0x0000] %asi
	mov	0x18, %r16
	mov	0x40, %r25
	mov	0x70, %r18
	.word 0xe6bf0e80  ! 3456: STDA_R	stda	%r19, [%r28 + %r0] 0x74
	.word 0xeef40400  ! 3457: STXA_R	stxa	%r23, [%r16 + %r0] 0x20
	.word 0xecace000  ! 3458: STBA_I	stba	%r22, [%r19 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xe4f7ce80  ! 3460: STXA_R	stxa	%r18, [%r31 + %r0] 0x74
	.word 0xe09c6000  ! 3461: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r16
	.word 0xe68c4400  ! 3462: LDUBA_R	lduba	[%r17, %r0] 0x20, %r19
	.word 0xecf78e40  ! 3463: STXA_R	stxa	%r22, [%r30 + %r0] 0x72
	.word 0xecac6000  ! 3464: STBA_I	stba	%r22, [%r17 + 0x0000] %asi
	.word 0xe0c689e0  ! 3465: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r16
	.word 0x87802025  ! 3466: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6d504a0  ! 3467: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r19
	.word 0xecafe000  ! 3468: STBA_I	stba	%r22, [%r31 + 0x0000] %asi
	.word 0xe6f78e60  ! 3469: STXA_R	stxa	%r19, [%r30 + %r0] 0x73
	mov	0x38, %r17
	.word 0xeac76000  ! 3471: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r21
	.word 0xeeaf8e80  ! 3472: STBA_R	stba	%r23, [%r30 + %r0] 0x74
	.word 0xe0bf2000  ! 3473: STDA_I	stda	%r16, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3474: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3475: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r27
	.word 0xe0a7a000  ! 3477: STWA_I	stwa	%r16, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 3478: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3479: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0b78e60  ! 3480: STHA_R	stha	%r16, [%r30 + %r0] 0x73
	.word 0xe8c72000  ! 3481: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r20
	.word 0xe8afe000  ! 3482: STBA_I	stba	%r20, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3483: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe89544a0  ! 3484: LDUHA_R	lduha	[%r21, %r0] 0x25, %r20
	.word 0xe0b46000  ! 3485: STHA_I	stha	%r16, [%r17 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xe0d46000  ! 3487: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r16
	mov	0x20, %r27
	.word 0x87802072  ! 3489: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe88c4400  ! 3490: LDUBA_R	lduba	[%r17, %r0] 0x20, %r20
	.word 0xe8c74e80  ! 3491: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r20
	.word 0xe8b70e80  ! 3492: STHA_R	stha	%r20, [%r28 + %r0] 0x74
	.word 0xeabfce40  ! 3493: STDA_R	stda	%r21, [%r31 + %r0] 0x72
	.word 0xe2a78e80  ! 3494: STWA_R	stwa	%r17, [%r30 + %r0] 0x74
	mov	0x20, %r26
	.word 0xeca7ce80  ! 3496: STWA_R	stwa	%r22, [%r31 + %r0] 0x74
	.word 0xe2dca000  ! 3497: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r17
	.word 0xe4af8e60  ! 3498: STBA_R	stba	%r18, [%r30 + %r0] 0x73
	.word 0xe0f42000  ! 3499: STXA_I	stxa	%r16, [%r16 + 0x0000] %asi
	.word 0xe6874e40  ! 3500: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r19
	mov	0x7f8, %r20
	.word 0xe0bca000  ! 3502: STDA_I	stda	%r16, [%r18 + 0x0000] %asi
	.word 0xe0a42000  ! 3503: STWA_I	stwa	%r16, [%r16 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xe08ce000  ! 3505: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r16
	.word 0xe6be49e0  ! 3506: STDA_R	stda	%r19, [%r25 + %r0] 0x4f
	.word 0xe8df4e60  ! 3507: LDXA_R	ldxa	[%r29, %r0] 0x73, %r20
	wr_tick_cmpr_3_29:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd8, %g2
	or	%g4, 0xaf, %g4
	or	%g6, 0xed, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeccdc4a0  ! 3509: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r22
	.word 0xe89f0e80  ! 3510: LDDA_R	ldda	[%r28, %r0] 0x74, %r20
	.word 0x87802072  ! 3511: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe69c8400  ! 3512: LDDA_R	ldda	[%r18, %r0] 0x20, %r19
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xecb78e60  ! 3514: STHA_R	stha	%r22, [%r30 + %r0] 0x73
	.word 0xe6840400  ! 3515: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r19
	.word 0xeab78e40  ! 3516: STHA_R	stha	%r21, [%r30 + %r0] 0x72
	.word 0xe8afe000  ! 3517: STBA_I	stba	%r20, [%r31 + 0x0000] %asi
	.word 0xe8a72000  ! 3518: STWA_I	stwa	%r20, [%r28 + 0x0000] %asi
	.word 0xe8876000  ! 3519: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r20
	.word 0xe8c7e000  ! 3520: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r20
	.word 0x87802025  ! 3521: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4ac4400  ! 3522: STBA_R	stba	%r18, [%r17 + %r0] 0x20
	.word 0xee876000  ! 3523: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r23
	.word 0xeadc0400  ! 3524: LDXA_R	ldxa	[%r16, %r0] 0x20, %r21
	mov	0x7d8, %r21
	.word 0xe2be49e0  ! 3526: STDA_R	stda	%r17, [%r25 + %r0] 0x4f
	.word 0xe4b584a0  ! 3527: STHA_R	stha	%r18, [%r22 + %r0] 0x25
	.word 0xecb504a0  ! 3528: STHA_R	stha	%r22, [%r20 + %r0] 0x25
	.word 0xe68e09e0  ! 3529: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r19
	.word 0xeec544a0  ! 3530: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r23
	.word 0xe0bfe000  ! 3531: STDA_I	stda	%r16, [%r31 + 0x0000] %asi
	.word 0xe0bf6000  ! 3532: STDA_I	stda	%r16, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 3533: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0d4a000  ! 3534: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r16
	.word 0x8780204f  ! 3535: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3536: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6a689e0  ! 3537: STWA_R	stwa	%r19, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 3538: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe08ec9e0  ! 3539: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r16
	.word 0x87802073  ! 3540: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d0, %r22
	.word 0x87802020  ! 3542: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3543: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3544: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xead7a000  ! 3545: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r21
	mov	0x78, %r25
	mov	0x0, %r25
	.word 0xea976000  ! 3548: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r21
	.word 0x87802025  ! 3549: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeaad2000  ! 3550: STBA_I	stba	%r21, [%r20 + 0x0000] %asi
	mov	0x10, %r27
	.word 0x8780204f  ! 3552: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2c74e60  ! 3553: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r17
	.word 0xecbda000  ! 3554: STDA_I	stda	%r22, [%r22 + 0x0000] %asi
	.word 0xeaa74e40  ! 3555: STWA_R	stwa	%r21, [%r29 + %r0] 0x72
	.word 0xeac7ce80  ! 3556: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r21
	.word 0xecbd2000  ! 3557: STDA_I	stda	%r22, [%r20 + 0x0000] %asi
	.word 0xeaa44400  ! 3558: STWA_R	stwa	%r21, [%r17 + %r0] 0x20
	mov	0x7d8, %r22
	mov	0x3f0, %r21
	.word 0x87802072  ! 3561: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2b584a0  ! 3562: STHA_R	stha	%r17, [%r22 + %r0] 0x25
	mov	0x10, %r25
	.word 0x87802074  ! 3564: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeebf2000  ! 3565: STDA_I	stda	%r23, [%r28 + 0x0000] %asi
	.word 0xeeafe000  ! 3566: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0xeeaf2000  ! 3567: STBA_I	stba	%r23, [%r28 + 0x0000] %asi
	.word 0xeea76000  ! 3568: STWA_I	stwa	%r23, [%r29 + 0x0000] %asi
	.word 0xe6d48400  ! 3569: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r19
	mov	0x3d0, %r21
	mov	0x60, %r17
	mov	0x18, %r16
	mov	0x3f0, %r21
	.word 0xeedd04a0  ! 3574: LDXA_R	ldxa	[%r20, %r0] 0x25, %r23
	.word 0xeec544a0  ! 3575: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r23
	.word 0xeec72000  ! 3576: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r23
	.word 0xe0c609e0  ! 3577: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r16
	mov	0x7e0, %r23
	.word 0xe0afe000  ! 3579: STBA_I	stba	%r16, [%r31 + 0x0000] %asi
	.word 0xe0f72000  ! 3580: STXA_I	stxa	%r16, [%r28 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xe0b7e000  ! 3582: STHA_I	stha	%r16, [%r31 + 0x0000] %asi
	.word 0xe0af2000  ! 3583: STBA_I	stba	%r16, [%r28 + 0x0000] %asi
	.word 0xe0cfa000  ! 3584: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r16
	mov	0x18, %r25
	.word 0x87802072  ! 3586: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6a70e80  ! 3587: STWA_R	stwa	%r19, [%r28 + %r0] 0x74
	.word 0xe8afa000  ! 3588: STBA_I	stba	%r20, [%r30 + 0x0000] %asi
	.word 0xe8d78e80  ! 3589: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r20
	.word 0xeabfa000  ! 3590: STDA_I	stda	%r21, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3591: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeaa72000  ! 3592: STWA_I	stwa	%r21, [%r28 + 0x0000] %asi
	.word 0xe6ae49e0  ! 3593: STBA_R	stba	%r19, [%r25 + %r0] 0x4f
	mov	0x50, %r26
	.word 0xecf689e0  ! 3595: STXA_R	stxa	%r22, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 3596: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec946000  ! 3597: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r22
	.word 0xe0d70e40  ! 3598: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r16
	mov	0x7c0, %r23
	mov	0x0, %r26
	.word 0x87802020  ! 3601: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r25
	.word 0xe087a000  ! 3603: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r16
	mov	0x60, %r26
	.word 0xe0d72000  ! 3605: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r16
	.word 0xe0ce09e0  ! 3606: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r16
	.word 0xe4df0e60  ! 3607: LDXA_R	ldxa	[%r28, %r0] 0x73, %r18
	.word 0xecc7e000  ! 3608: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r22
	.word 0xecaf6000  ! 3609: STBA_I	stba	%r22, [%r29 + 0x0000] %asi
	mov	0x50, %r19
	mov	0x0, %r24
	.word 0xecf76000  ! 3612: STXA_I	stxa	%r22, [%r29 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xe08504a0  ! 3614: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r16
	.word 0xecf76000  ! 3615: STXA_I	stxa	%r22, [%r29 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xecf76000  ! 3617: STXA_I	stxa	%r22, [%r29 + 0x0000] %asi
	.word 0xecc76000  ! 3618: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	mov	0x18, %r26
	.word 0xeca544a0  ! 3620: STWA_R	stwa	%r22, [%r21 + %r0] 0x25
	.word 0xe0de49e0  ! 3621: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r16
	.word 0xe0cf8e80  ! 3622: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r16
	.word 0xe49fe000  ! 3623: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r18
	.word 0xe0bd04a0  ! 3624: STDA_R	stda	%r16, [%r20 + %r0] 0x25
	.word 0xe2ce49e0  ! 3625: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r17
	.word 0xe6f4c400  ! 3626: STXA_R	stxa	%r19, [%r19 + %r0] 0x20
	.word 0xe2b74e60  ! 3627: STHA_R	stha	%r17, [%r29 + %r0] 0x73
	.word 0xe4a6c9e0  ! 3628: STWA_R	stwa	%r18, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 3629: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r26
	.word 0xe69fa000  ! 3631: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r19
	.word 0xe6af2000  ! 3632: STBA_I	stba	%r19, [%r28 + 0x0000] %asi
	.word 0xe6bfa000  ! 3633: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xee8ec9e0  ! 3634: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r23
	.word 0xead76000  ! 3635: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r21
	.word 0xe6d584a0  ! 3636: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r19
	mov	0x68, %r17
	.word 0xe49c4400  ! 3638: LDDA_R	ldda	[%r17, %r0] 0x20, %r18
	mov	0x7f8, %r22
	.word 0x8780204f  ! 3640: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeadea000  ! 3641: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r21
	.word 0xeaa6a000  ! 3642: STWA_I	stwa	%r21, [%r26 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xea866000  ! 3644: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r21
	.word 0xeab6e000  ! 3645: STHA_I	stha	%r21, [%r27 + 0x0000] %asi
	.word 0xeec74e60  ! 3646: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r23
	mov	0x18, %r18
	.word 0xe6f6a000  ! 3648: STXA_I	stxa	%r19, [%r26 + 0x0000] %asi
	.word 0xe68ea000  ! 3649: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r19
	.word 0xe6ce6000  ! 3650: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r19
	mov	0x3e8, %r22
	mov	0x78, %r18
	.word 0xe2ac4400  ! 3653: STBA_R	stba	%r17, [%r17 + %r0] 0x20
	.word 0xeaaec9e0  ! 3654: STBA_R	stba	%r21, [%r27 + %r0] 0x4f
	.word 0xe08ea000  ! 3655: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r16
	.word 0xe086e000  ! 3656: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r16
	.word 0xe0ae49e0  ! 3657: STBA_R	stba	%r16, [%r25 + %r0] 0x4f
	.word 0xe08f8e80  ! 3658: LDUBA_R	lduba	[%r30, %r0] 0x74, %r16
	.word 0x87802020  ! 3659: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe48c4400  ! 3660: LDUBA_R	lduba	[%r17, %r0] 0x20, %r18
	.word 0xee944400  ! 3661: LDUHA_R	lduha	[%r17, %r0] 0x20, %r23
	mov	0x50, %r26
	.word 0xe4a72000  ! 3663: STWA_I	stwa	%r18, [%r28 + 0x0000] %asi
	.word 0xe4df8e60  ! 3664: LDXA_R	ldxa	[%r30, %r0] 0x73, %r18
	.word 0xecf74e60  ! 3665: STXA_R	stxa	%r22, [%r29 + %r0] 0x73
	.word 0xec9fa000  ! 3666: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r22
	mov	0x0, %r16
	.word 0xecafe000  ! 3668: STBA_I	stba	%r22, [%r31 + 0x0000] %asi
	.word 0xecc70e40  ! 3669: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r22
	.word 0x87802020  ! 3670: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeccfe000  ! 3671: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r22
	.word 0xeaa74e40  ! 3672: STWA_R	stwa	%r21, [%r29 + %r0] 0x72
	.word 0xe29609e0  ! 3673: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r17
	.word 0xeeb70e80  ! 3674: STHA_R	stha	%r23, [%r28 + %r0] 0x74
	.word 0xe4b7e000  ! 3675: STHA_I	stha	%r18, [%r31 + 0x0000] %asi
	.word 0xee97ce60  ! 3676: LDUHA_R	lduha	[%r31, %r0] 0x73, %r23
	mov	0x7f0, %r21
	.word 0xe0a689e0  ! 3678: STWA_R	stwa	%r16, [%r26 + %r0] 0x4f
	.word 0xec8f6000  ! 3679: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	mov	0x50, %r27
	.word 0xecbfe000  ! 3681: STDA_I	stda	%r22, [%r31 + 0x0000] %asi
	.word 0xecc76000  ! 3682: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0xe6a7ce40  ! 3683: STWA_R	stwa	%r19, [%r31 + %r0] 0x72
	.word 0x87802072  ! 3684: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8f649e0  ! 3685: STXA_R	stxa	%r20, [%r25 + %r0] 0x4f
	mov	0x60, %r16
	.word 0xee97ce40  ! 3687: LDUHA_R	lduha	[%r31, %r0] 0x72, %r23
	.word 0xe8dd6000  ! 3688: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r20
	mov	0x28, %r16
	.word 0xe885e000  ! 3690: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r20
	.word 0xe4cfce80  ! 3691: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r18
	.word 0x87802025  ! 3692: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e0, %r22
	.word 0x87802074  ! 3694: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6a40400  ! 3695: STWA_R	stwa	%r19, [%r16 + %r0] 0x20
	mov	0x70, %r19
	.word 0xe89fce40  ! 3697: LDDA_R	ldda	[%r31, %r0] 0x72, %r20
	.word 0xe0a7e000  ! 3698: STWA_I	stwa	%r16, [%r31 + 0x0000] %asi
	mov	0x40, %r24
	.word 0xeabc0400  ! 3700: STDA_R	stda	%r21, [%r16 + %r0] 0x20
	.word 0xeaaf0e40  ! 3701: STBA_R	stba	%r21, [%r28 + %r0] 0x72
	.word 0xe6bf6000  ! 3702: STDA_I	stda	%r19, [%r29 + 0x0000] %asi
	wr_tick_cmpr_3_30:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x9e, %g2
	or	%g4, 0xab, %g4
	or	%g6, 0xdb, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3c0, %r22
	.word 0xeca40400  ! 3705: STWA_R	stwa	%r22, [%r16 + %r0] 0x20
	.word 0x87802025  ! 3706: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8c584a0  ! 3707: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r20
	mov	0x70, %r16
	.word 0xe2f5e000  ! 3709: STXA_I	stxa	%r17, [%r23 + 0x0000] %asi
	.word 0xeab584a0  ! 3710: STHA_R	stha	%r21, [%r22 + %r0] 0x25
	.word 0xe4b74e80  ! 3711: STHA_R	stha	%r18, [%r29 + %r0] 0x74
	.word 0x87802074  ! 3712: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r24
	.word 0xead78e60  ! 3714: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r21
	.word 0xe6d78e40  ! 3715: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r19
	.word 0xeeb70e60  ! 3716: STHA_R	stha	%r23, [%r28 + %r0] 0x73
	.word 0xe0cd6000  ! 3717: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r16
	mov	0x8, %r17
	.word 0x87802073  ! 3719: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d0, %r21
	.word 0xe0c46000  ! 3721: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r16
	.word 0xe0b4e000  ! 3722: STHA_I	stha	%r16, [%r19 + 0x0000] %asi
	mov	0x8, %r25
	.word 0x87802074  ! 3724: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r26
	.word 0xe0972000  ! 3726: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r16
	.word 0xe6ac4400  ! 3727: STBA_R	stba	%r19, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 3728: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeebe2000  ! 3729: STDA_I	stda	%r23, [%r24 + 0x0000] %asi
	.word 0xee966000  ! 3730: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r23
	.word 0xeebe2000  ! 3731: STDA_I	stda	%r23, [%r24 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xe8dc0400  ! 3733: LDXA_R	ldxa	[%r16, %r0] 0x20, %r20
	.word 0xeaf504a0  ! 3734: STXA_R	stxa	%r21, [%r20 + %r0] 0x25
	mov	0x3e0, %r22
	.word 0x8780204f  ! 3736: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeede09e0  ! 3737: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r23
	.word 0xeccca000  ! 3738: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r22
	.word 0xecb4e000  ! 3739: STHA_I	stha	%r22, [%r19 + 0x0000] %asi
	.word 0xecd4e000  ! 3740: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r22
	.word 0xecbc2000  ! 3741: STDA_I	stda	%r22, [%r16 + 0x0000] %asi
	.word 0xe09649e0  ! 3742: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r16
	.word 0xead4e000  ! 3743: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r21
	mov	0x78, %r26
	.word 0xe2afce40  ! 3745: STBA_R	stba	%r17, [%r31 + %r0] 0x72
	.word 0x87802072  ! 3746: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeab7ce40  ! 3747: STHA_R	stha	%r21, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 3748: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2cea000  ! 3749: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r17
	.word 0xe29ee000  ! 3750: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r17
	.word 0x8780204f  ! 3751: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802074  ! 3753: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2dde000  ! 3754: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r17
	.word 0xee9689e0  ! 3755: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r23
	.word 0xe6bc8400  ! 3756: STDA_R	stda	%r19, [%r18 + %r0] 0x20
	.word 0xeab5a000  ! 3757: STHA_I	stha	%r21, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 3758: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe097ce80  ! 3759: LDUHA_R	lduha	[%r31, %r0] 0x74, %r16
	.word 0xeaaf4e60  ! 3760: STBA_R	stba	%r21, [%r29 + %r0] 0x73
	.word 0xe0a7ce60  ! 3761: STWA_R	stwa	%r16, [%r31 + %r0] 0x73
	.word 0x87802020  ! 3762: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x0, %r24
	.word 0xea87a000  ! 3765: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r21
	mov	0x3c8, %r22
	.word 0xe4ac4400  ! 3767: STBA_R	stba	%r18, [%r17 + %r0] 0x20
	.word 0xe4bec9e0  ! 3768: STDA_R	stda	%r18, [%r27 + %r0] 0x4f
	mov	0x40, %r18
	.word 0x8780204f  ! 3770: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0cf0e60  ! 3771: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r16
	mov	0x3e0, %r22
	.word 0xe8946000  ! 3773: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r20
	mov	0x68, %r19
	.word 0xe8d42000  ! 3775: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r20
	.word 0xe8aca000  ! 3776: STBA_I	stba	%r20, [%r18 + 0x0000] %asi
	.word 0xe8f42000  ! 3777: STXA_I	stxa	%r20, [%r16 + 0x0000] %asi
	mov	0x7e0, %r20
	.word 0xe88c2000  ! 3779: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r20
	.word 0xe8cca000  ! 3780: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r20
	.word 0xe6bc0400  ! 3781: STDA_R	stda	%r19, [%r16 + %r0] 0x20
	.word 0xee948400  ! 3782: LDUHA_R	lduha	[%r18, %r0] 0x20, %r23
	mov	0x58, %r16
	.word 0xeab40400  ! 3784: STHA_R	stha	%r21, [%r16 + %r0] 0x20
	.word 0xe684e000  ! 3785: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r19
	.word 0x87802025  ! 3786: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeef44400  ! 3787: STXA_R	stxa	%r23, [%r17 + %r0] 0x20
	.word 0xe8952000  ! 3788: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r20
	.word 0xe895e000  ! 3789: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r20
	.word 0xe8c5a000  ! 3790: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r20
	mov	0x48, %r26
	.word 0xea9689e0  ! 3792: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r21
	.word 0xec956000  ! 3793: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r22
	.word 0x87802025  ! 3794: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeedc8400  ! 3795: LDXA_R	ldxa	[%r18, %r0] 0x20, %r23
	mov	0x3e8, %r22
	.word 0xea962000  ! 3797: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r21
	.word 0xea86e000  ! 3798: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r21
	.word 0xeab66000  ! 3799: STHA_I	stha	%r21, [%r25 + 0x0000] %asi
	.word 0xea96a000  ! 3800: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r21
	.word 0x87802074  ! 3801: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xea9da000  ! 3802: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r21
	.word 0xeebf4e60  ! 3803: STDA_R	stda	%r23, [%r29 + %r0] 0x73
	.word 0xe6a6c9e0  ! 3804: STWA_R	stwa	%r19, [%r27 + %r0] 0x4f
	.word 0xe28d6000  ! 3805: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r17
	.word 0xe2c52000  ! 3806: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r17
	mov	0x18, %r25
	mov	0x3f8, %r20
	.word 0xecc6c9e0  ! 3809: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r22
	.word 0xe68d2000  ! 3810: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r19
	.word 0x87802074  ! 3811: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 3812: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r24
	.word 0x87802025  ! 3814: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6bda000  ! 3815: STDA_I	stda	%r19, [%r22 + 0x0000] %asi
	.word 0xeea584a0  ! 3816: STWA_R	stwa	%r23, [%r22 + %r0] 0x25
	.word 0x87802074  ! 3817: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2bc6000  ! 3818: STDA_I	stda	%r17, [%r17 + 0x0000] %asi
	.word 0xe29c6000  ! 3819: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r17
	.word 0xe2c42000  ! 3820: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r17
	.word 0xecccc400  ! 3821: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r22
	.word 0xe2ddc4a0  ! 3822: LDXA_R	ldxa	[%r23, %r0] 0x25, %r17
	.word 0xeadcc400  ! 3823: LDXA_R	ldxa	[%r19, %r0] 0x20, %r21
	.word 0xe6b7ce60  ! 3824: STHA_R	stha	%r19, [%r31 + %r0] 0x73
	.word 0xec8c2000  ! 3825: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r22
	mov	0x3f0, %r21
	mov	0x58, %r16
	mov	0x3c8, %r20
	mov	0x7c0, %r22
	.word 0xec8c2000  ! 3830: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r22
	mov	0x40, %r26
	.word 0xecdc2000  ! 3832: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r22
	.word 0xeca4e000  ! 3833: STWA_I	stwa	%r22, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 3834: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4b48400  ! 3835: STHA_R	stha	%r18, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3836: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3837: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xea87ce60  ! 3838: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r21
	.word 0x87802073  ! 3839: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xec8609e0  ! 3840: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r22
	mov	0x28, %r26
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x68, %r27
	mov	0x7e8, %r23
	mov	0x7c8, %r21
	.word 0xeca4e000  ! 3846: STWA_I	stwa	%r22, [%r19 + 0x0000] %asi
	.word 0xec8ca000  ! 3847: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r22
	mov	0x78, %r24
	.word 0xec8c6000  ! 3849: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r22
	.word 0xecc4e000  ! 3850: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r22
	.word 0x87802072  ! 3851: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e8, %r22
	mov	0x7c8, %r20
	.word 0xec9fe000  ! 3854: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r22
	.word 0xecac0400  ! 3855: STBA_R	stba	%r22, [%r16 + %r0] 0x20
	.word 0xe09fa000  ! 3856: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r16
	.word 0xea9dc4a0  ! 3857: LDDA_R	ldda	[%r23, %r0] 0x25, %r21
	.word 0xec8f0e40  ! 3858: LDUBA_R	lduba	[%r28, %r0] 0x72, %r22
	.word 0xe6b7e000  ! 3859: STHA_I	stha	%r19, [%r31 + 0x0000] %asi
	mov	0x38, %r25
	mov	0x60, %r18
	.word 0xecb74e80  ! 3862: STHA_R	stha	%r22, [%r29 + %r0] 0x74
	.word 0xe69c0400  ! 3863: LDDA_R	ldda	[%r16, %r0] 0x20, %r19
	.word 0xee8fe000  ! 3864: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r23
	.word 0x87802020  ! 3865: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeacf0e40  ! 3866: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r21
	mov	0x28, %r25
	.word 0x87802020  ! 3868: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3869: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xecb46000  ! 3870: STHA_I	stha	%r22, [%r17 + 0x0000] %asi
	.word 0xecac6000  ! 3871: STBA_I	stba	%r22, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3872: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecf6e000  ! 3873: STXA_I	stxa	%r22, [%r27 + 0x0000] %asi
	.word 0xe2af8e60  ! 3874: STBA_R	stba	%r17, [%r30 + %r0] 0x73
	.word 0x87802072  ! 3875: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d0, %r22
	.word 0x87802020  ! 3877: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeac5e000  ! 3878: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r21
	.word 0xe8ae89e0  ! 3879: STBA_R	stba	%r20, [%r26 + %r0] 0x4f
	.word 0xeecd2000  ! 3880: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r23
	.word 0xe6ac8400  ! 3881: STBA_R	stba	%r19, [%r18 + %r0] 0x20
	.word 0xe4a4c400  ! 3882: STWA_R	stwa	%r18, [%r19 + %r0] 0x20
	.word 0x87802025  ! 3883: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe28544a0  ! 3884: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r17
	.word 0xec9fce60  ! 3885: LDDA_R	ldda	[%r31, %r0] 0x73, %r22
	.word 0xeebe89e0  ! 3886: STDA_R	stda	%r23, [%r26 + %r0] 0x4f
	mov	0x7f8, %r22
	.word 0xe8c70e60  ! 3888: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r20
	mov	0x28, %r27
	.word 0xe8c72000  ! 3890: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r20
	mov	0x7f0, %r23
	.word 0xe8a7e000  ! 3892: STWA_I	stwa	%r20, [%r31 + 0x0000] %asi
	mov	0x7c8, %r20
	.word 0xe0874e60  ! 3894: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r16
	.word 0xe8cf2000  ! 3895: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r20
	.word 0x87802020  ! 3896: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6870e40  ! 3897: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r19
	.word 0x87802020  ! 3898: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3899: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecd56000  ! 3900: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r22
	.word 0xe2adc4a0  ! 3901: STBA_R	stba	%r17, [%r23 + %r0] 0x25
	.word 0xe6ad2000  ! 3902: STBA_I	stba	%r19, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 3903: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3904: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_31:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf9, %g2
	or	%g4, 0xfa, %g4
	or	%g6, 0x95, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3f8, %r20
	.word 0xe6a4a000  ! 3907: STWA_I	stwa	%r19, [%r18 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xe684e000  ! 3909: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r19
	.word 0xecdf8e40  ! 3910: LDXA_R	ldxa	[%r30, %r0] 0x72, %r22
	mov	0x20, %r19
	.word 0xe4a42000  ! 3912: STWA_I	stwa	%r18, [%r16 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xe4f4a000  ! 3914: STXA_I	stxa	%r18, [%r18 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xe2bf4e80  ! 3916: STDA_R	stda	%r17, [%r29 + %r0] 0x74
	.word 0xe4a46000  ! 3917: STWA_I	stwa	%r18, [%r17 + 0x0000] %asi
	.word 0xe484a000  ! 3918: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r18
	mov	0x3d0, %r22
	.word 0xe4bc2000  ! 3920: STDA_I	stda	%r18, [%r16 + 0x0000] %asi
	.word 0xe4bc6000  ! 3921: STDA_I	stda	%r18, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 3922: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r21
	mov	0x7f8, %r22
	.word 0x87802074  ! 3925: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r16
	.word 0x87802020  ! 3927: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4ace000  ! 3928: STBA_I	stba	%r18, [%r19 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xeabc8400  ! 3930: STDA_R	stda	%r21, [%r18 + %r0] 0x20
	.word 0xea842000  ! 3931: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r21
	.word 0xecb544a0  ! 3932: STHA_R	stha	%r22, [%r21 + %r0] 0x25
	.word 0x87802020  ! 3933: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4c4c400  ! 3934: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r18
	.word 0xeebfce60  ! 3935: STDA_R	stda	%r23, [%r31 + %r0] 0x73
	.word 0xecd7a000  ! 3936: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r22
	.word 0x87802020  ! 3937: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec846000  ! 3938: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r22
	.word 0xe6f544a0  ! 3939: STXA_R	stxa	%r19, [%r21 + %r0] 0x25
	.word 0x87802020  ! 3940: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r27
	mov	0x50, %r18
	.word 0xe8a46000  ! 3943: STWA_I	stwa	%r20, [%r17 + 0x0000] %asi
	.word 0xe8b46000  ! 3944: STHA_I	stha	%r20, [%r17 + 0x0000] %asi
	.word 0xe8aca000  ! 3945: STBA_I	stba	%r20, [%r18 + 0x0000] %asi
	.word 0xe48c0400  ! 3946: LDUBA_R	lduba	[%r16, %r0] 0x20, %r18
	.word 0xea9f0e60  ! 3947: LDDA_R	ldda	[%r28, %r0] 0x73, %r21
	.word 0xe0a48400  ! 3948: STWA_R	stwa	%r16, [%r18 + %r0] 0x20
	mov	0x3e0, %r22
	.word 0x8780204f  ! 3950: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2bf6000  ! 3951: STDA_I	stda	%r17, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 3952: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r16
	.word 0x87802072  ! 3954: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r17
	.word 0xe2b7a000  ! 3956: STHA_I	stha	%r17, [%r30 + 0x0000] %asi
	.word 0xe48d44a0  ! 3957: LDUBA_R	lduba	[%r21, %r0] 0x25, %r18
	.word 0xecae89e0  ! 3958: STBA_R	stba	%r22, [%r26 + %r0] 0x4f
	.word 0xe4872000  ! 3959: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r18
	mov	0x78, %r17
	.word 0xe4b72000  ! 3961: STHA_I	stha	%r18, [%r28 + 0x0000] %asi
	.word 0xe88d44a0  ! 3962: LDUBA_R	lduba	[%r21, %r0] 0x25, %r20
	.word 0xeead04a0  ! 3963: STBA_R	stba	%r23, [%r20 + %r0] 0x25
	.word 0xe8970e40  ! 3964: LDUHA_R	lduha	[%r28, %r0] 0x72, %r20
	.word 0xeedc4400  ! 3965: LDXA_R	ldxa	[%r17, %r0] 0x20, %r23
	mov	0x58, %r26
	.word 0xee9c0400  ! 3967: LDDA_R	ldda	[%r16, %r0] 0x20, %r23
	.word 0xee8544a0  ! 3968: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r23
	.word 0xe6dc0400  ! 3969: LDXA_R	ldxa	[%r16, %r0] 0x20, %r19
	.word 0xe4a7e000  ! 3970: STWA_I	stwa	%r18, [%r31 + 0x0000] %asi
	.word 0xe4cfa000  ! 3971: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r18
	.word 0xe4b76000  ! 3972: STHA_I	stha	%r18, [%r29 + 0x0000] %asi
	.word 0xe4bf2000  ! 3973: STDA_I	stda	%r18, [%r28 + 0x0000] %asi
	.word 0xe4bf2000  ! 3974: STDA_I	stda	%r18, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3975: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r24
	.word 0xeec649e0  ! 3977: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r23
	.word 0xee8fce40  ! 3978: LDUBA_R	lduba	[%r31, %r0] 0x72, %r23
	.word 0xe2f42000  ! 3979: STXA_I	stxa	%r17, [%r16 + 0x0000] %asi
	.word 0xeabc8400  ! 3980: STDA_R	stda	%r21, [%r18 + %r0] 0x20
	.word 0xe8bc8400  ! 3981: STDA_R	stda	%r20, [%r18 + %r0] 0x20
	.word 0xecdc6000  ! 3982: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r22
	.word 0xec942000  ! 3983: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r22
	.word 0x87802074  ! 3984: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0b584a0  ! 3985: STHA_R	stha	%r16, [%r22 + %r0] 0x25
	mov	0x38, %r17
	.word 0xeea544a0  ! 3987: STWA_R	stwa	%r23, [%r21 + %r0] 0x25
	.word 0xe8cdc4a0  ! 3988: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r20
	.word 0xead649e0  ! 3989: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r21
	.word 0x87802074  ! 3990: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8d40400  ! 3991: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r20
	.word 0xe4c72000  ! 3992: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r18
	.word 0x87802020  ! 3993: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6b44400  ! 3994: STHA_R	stha	%r19, [%r17 + %r0] 0x20
	.word 0xe4bd2000  ! 3995: STDA_I	stda	%r18, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 3996: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r24
	.word 0xecb44400  ! 3998: STHA_R	stha	%r22, [%r17 + %r0] 0x20
	mov	0x18, %r16
	mov	0x50, %r24
	.word 0x87802074  ! 4001: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2bcc400  ! 4002: STDA_R	stda	%r17, [%r19 + %r0] 0x20
	mov	0x38, %r19
	.word 0xe497a000  ! 4004: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r18
	.word 0xe4cfe000  ! 4005: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r18
	.word 0xe0ce89e0  ! 4006: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r16
	.word 0xeed78e60  ! 4007: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r23
	.word 0x87802020  ! 4008: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe28c0400  ! 4009: LDUBA_R	lduba	[%r16, %r0] 0x20, %r17
	mov	0x48, %r16
	.word 0xeccd44a0  ! 4011: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r22
	.word 0xe4cf8e60  ! 4012: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r18
	.word 0xe4a76000  ! 4013: STWA_I	stwa	%r18, [%r29 + 0x0000] %asi
	mov	0x58, %r17
	.word 0x87802025  ! 4015: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 4016: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r19
	.word 0xe8c48400  ! 4018: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r20
	.word 0xe287a000  ! 4019: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r17
	.word 0xe2c76000  ! 4020: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r17
	.word 0xeab70e80  ! 4021: STHA_R	stha	%r21, [%r28 + %r0] 0x74
	mov	0x3d0, %r22
	mov	0x0, %r27
	.word 0xe8cf2000  ! 4024: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r20
	.word 0xea9e89e0  ! 4025: LDDA_R	ldda	[%r26, %r0] 0x4f, %r21
	.word 0xeca7e000  ! 4026: STWA_I	stwa	%r22, [%r31 + 0x0000] %asi
	mov	0x18, %r26
	.word 0x87802072  ! 4028: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4f7ce80  ! 4029: STXA_R	stxa	%r18, [%r31 + %r0] 0x74
	.word 0xe8b7ce40  ! 4030: STHA_R	stha	%r20, [%r31 + %r0] 0x72
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3d0, %r20
	mov	0x7c8, %r20
	.word 0x87802025  ! 4034: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4ae89e0  ! 4035: STBA_R	stba	%r18, [%r26 + %r0] 0x4f
	.word 0xe88fa000  ! 4036: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r20
	.word 0x87802025  ! 4037: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8f7a000  ! 4038: STXA_I	stxa	%r20, [%r30 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xe09cc400  ! 4040: LDDA_R	ldda	[%r19, %r0] 0x20, %r16
	.word 0xe8af6000  ! 4041: STBA_I	stba	%r20, [%r29 + 0x0000] %asi
	.word 0xe2f74e40  ! 4042: STXA_R	stxa	%r17, [%r29 + %r0] 0x72
	mov	0x3e8, %r23
	mov	0x3d0, %r21
	.word 0xe2848400  ! 4045: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r17
	mov	0x7f8, %r21
	.word 0xe6df0e40  ! 4047: LDXA_R	ldxa	[%r28, %r0] 0x72, %r19
	.word 0xeaa76000  ! 4048: STWA_I	stwa	%r21, [%r29 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xe8dc8400  ! 4050: LDXA_R	ldxa	[%r18, %r0] 0x20, %r20
	.word 0xe0af6000  ! 4051: STBA_I	stba	%r16, [%r29 + 0x0000] %asi
	.word 0xe08d04a0  ! 4052: LDUBA_R	lduba	[%r20, %r0] 0x25, %r16
	.word 0xe6dc4400  ! 4053: LDXA_R	ldxa	[%r17, %r0] 0x20, %r19
	.word 0x87802073  ! 4054: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe487ce40  ! 4055: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r18
	.word 0x87802074  ! 4056: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2f609e0  ! 4057: STXA_R	stxa	%r17, [%r24 + %r0] 0x4f
	.word 0xeacde000  ! 4058: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r21
	.word 0xeabd6000  ! 4059: STDA_I	stda	%r21, [%r21 + 0x0000] %asi
	.word 0xe8840400  ! 4060: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r20
	.word 0xe6ad2000  ! 4061: STBA_I	stba	%r19, [%r20 + 0x0000] %asi
	mov	0x40, %r18
	.word 0x8780204f  ! 4063: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r27
	.word 0xe6f42000  ! 4065: STXA_I	stxa	%r19, [%r16 + 0x0000] %asi
	.word 0xead48400  ! 4066: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r21
	.word 0xecb4e000  ! 4067: STHA_I	stha	%r22, [%r19 + 0x0000] %asi
	.word 0xecd4e000  ! 4068: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r22
	mov	0x10, %r16
	.word 0xecd4a000  ! 4070: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r22
	mov	0x7c8, %r20
	.word 0x87802020  ! 4072: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec8f6000  ! 4073: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	mov	0x20, %r24
	.word 0xe6c74e60  ! 4075: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r19
	.word 0xe69f6000  ! 4076: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r19
	.word 0x87802073  ! 4077: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe697e000  ! 4078: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r19
	.word 0xe6af2000  ! 4079: STBA_I	stba	%r19, [%r28 + 0x0000] %asi
	.word 0xe0bfce60  ! 4080: STDA_R	stda	%r16, [%r31 + %r0] 0x73
	.word 0x87802072  ! 4081: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8f6c9e0  ! 4082: STXA_R	stxa	%r20, [%r27 + %r0] 0x4f
	mov	0x10, %r17
	.word 0x87802074  ! 4084: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0cf4e60  ! 4085: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r16
	.word 0xeccc8400  ! 4086: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r22
	.word 0xe2b504a0  ! 4087: STHA_R	stha	%r17, [%r20 + %r0] 0x25
	.word 0xea9c2000  ! 4088: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r21
	.word 0xea8c6000  ! 4089: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r21
	.word 0xeaace000  ! 4090: STBA_I	stba	%r21, [%r19 + 0x0000] %asi
	.word 0xeab544a0  ! 4091: STHA_R	stha	%r21, [%r21 + %r0] 0x25
	.word 0xeef544a0  ! 4092: STXA_R	stxa	%r23, [%r21 + %r0] 0x25
	mov	0x0, %r16
	.word 0x87802025  ! 4094: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8b6a000  ! 4095: STHA_I	stha	%r20, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 4096: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0a74e40  ! 4097: STWA_R	stwa	%r16, [%r29 + %r0] 0x72
	.word 0xecf4a000  ! 4098: STXA_I	stxa	%r22, [%r18 + 0x0000] %asi
	.word 0xecdca000  ! 4099: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r22
	.word 0xee8c4400  ! 4100: LDUBA_R	lduba	[%r17, %r0] 0x20, %r23
	.word 0xe4b4e000  ! 4101: STHA_I	stha	%r18, [%r19 + 0x0000] %asi
	.word 0xe4aca000  ! 4102: STBA_I	stba	%r18, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4103: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4104: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4105: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4a46000  ! 4106: STWA_I	stwa	%r18, [%r17 + 0x0000] %asi
	.word 0xe4c42000  ! 4107: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r18
	.word 0xe6ce49e0  ! 4108: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r19
	.word 0xee8ce000  ! 4109: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r23
	.word 0xee8ce000  ! 4110: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r23
	.word 0xee9c2000  ! 4111: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r23
	.word 0xead689e0  ! 4112: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r21
	.word 0xeed4e000  ! 4113: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r23
	.word 0x87802072  ! 4114: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeebfa000  ! 4115: STDA_I	stda	%r23, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 4116: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r18
	.word 0xe6f6c9e0  ! 4118: STXA_R	stxa	%r19, [%r27 + %r0] 0x4f
	.word 0xe6ccc400  ! 4119: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r19
	.word 0xe0f44400  ! 4120: STXA_R	stxa	%r16, [%r17 + %r0] 0x20
	.word 0xe0c5a000  ! 4121: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r16
	.word 0xe2f609e0  ! 4122: STXA_R	stxa	%r17, [%r24 + %r0] 0x4f
	.word 0xecb4c400  ! 4123: STHA_R	stha	%r22, [%r19 + %r0] 0x20
	mov	0x70, %r25
	.word 0xe0f504a0  ! 4125: STXA_R	stxa	%r16, [%r20 + %r0] 0x25
	.word 0x87802073  ! 4126: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe28f2000  ! 4127: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r17
	mov	0x68, %r19
	ta	T_CHANGE_PRIV	! macro
	.word 0xe2c7a000  ! 4130: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r17
	.word 0xe2b72000  ! 4131: STHA_I	stha	%r17, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 4132: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4133: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4134: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe29fa000  ! 4135: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r17
	.word 0xe287e000  ! 4136: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r17
	.word 0x87802020  ! 4137: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6f70e80  ! 4138: STXA_R	stxa	%r19, [%r28 + %r0] 0x74
	.word 0xee8f6000  ! 4139: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r23
	.word 0x87802072  ! 4140: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4141: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe08f4e80  ! 4142: LDUBA_R	lduba	[%r29, %r0] 0x74, %r16
	.word 0xe6f44400  ! 4143: STXA_R	stxa	%r19, [%r17 + %r0] 0x20
	mov	0x3e0, %r21
	mov	0x18, %r24
	.word 0xe8cf0e80  ! 4146: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r20
	mov	0x30, %r26
	.word 0x87802020  ! 4148: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4149: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeeaf4e60  ! 4150: STBA_R	stba	%r23, [%r29 + %r0] 0x73
	.word 0xe0dd6000  ! 4151: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r16
	.word 0xe0bd6000  ! 4152: STDA_I	stda	%r16, [%r21 + 0x0000] %asi
	.word 0xe0f5a000  ! 4153: STXA_I	stxa	%r16, [%r22 + 0x0000] %asi
	.word 0xe0c5a000  ! 4154: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r16
	.word 0xe0956000  ! 4155: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r16
	.word 0xeaa70e40  ! 4156: STWA_R	stwa	%r21, [%r28 + %r0] 0x72
	mov	0x8, %r27
	.word 0xeaf52000  ! 4158: STXA_I	stxa	%r21, [%r20 + 0x0000] %asi
	.word 0xea85e000  ! 4159: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r21
	.word 0xea970e80  ! 4160: LDUHA_R	lduha	[%r28, %r0] 0x74, %r21
	.word 0x8780204f  ! 4161: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4af6000  ! 4162: STBA_I	stba	%r18, [%r29 + 0x0000] %asi
	.word 0xe4f72000  ! 4163: STXA_I	stxa	%r18, [%r28 + 0x0000] %asi
	.word 0xe28f0e60  ! 4164: LDUBA_R	lduba	[%r28, %r0] 0x73, %r17
	.word 0xe2f78e40  ! 4165: STXA_R	stxa	%r17, [%r30 + %r0] 0x72
	.word 0xeaaf6000  ! 4166: STBA_I	stba	%r21, [%r29 + 0x0000] %asi
	.word 0xeadfe000  ! 4167: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r21
	.word 0xea876000  ! 4168: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r21
	mov	0x40, %r26
	mov	0x3e0, %r20
	mov	0x78, %r17
	.word 0xe0b4c400  ! 4172: STHA_R	stha	%r16, [%r19 + %r0] 0x20
	.word 0xe4f76000  ! 4173: STXA_I	stxa	%r18, [%r29 + 0x0000] %asi
	.word 0xe4f72000  ! 4174: STXA_I	stxa	%r18, [%r28 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0xeef544a0  ! 4176: STXA_R	stxa	%r23, [%r21 + %r0] 0x25
	.word 0xeadc4400  ! 4177: LDXA_R	ldxa	[%r17, %r0] 0x20, %r21
	.word 0xeef7a000  ! 4178: STXA_I	stxa	%r23, [%r30 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7d0, %r21
	.word 0xeec72000  ! 4181: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r23
	.word 0x87802020  ! 4182: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeea7e000  ! 4183: STWA_I	stwa	%r23, [%r31 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xeeb72000  ! 4185: STHA_I	stha	%r23, [%r28 + 0x0000] %asi
	.word 0xeeb76000  ! 4186: STHA_I	stha	%r23, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4187: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8c544a0  ! 4188: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r20
	.word 0xecc7ce80  ! 4189: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r22
	mov	0x18, %r17
	.word 0xe08f8e60  ! 4191: LDUBA_R	lduba	[%r30, %r0] 0x73, %r16
	.word 0xe8ac6000  ! 4192: STBA_I	stba	%r20, [%r17 + 0x0000] %asi
	.word 0xe8bc2000  ! 4193: STDA_I	stda	%r20, [%r16 + 0x0000] %asi
	.word 0xea8f0e60  ! 4194: LDUBA_R	lduba	[%r28, %r0] 0x73, %r21
	mov	0x8, %r17
	.word 0x8780204f  ! 4196: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r21
	mov	0x60, %r26
	mov	0x3d0, %r20
	.word 0xe4cf0e40  ! 4200: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r18
	.word 0xe6ae2000  ! 4201: STBA_I	stba	%r19, [%r24 + 0x0000] %asi
	.word 0xeef4c400  ! 4202: STXA_R	stxa	%r23, [%r19 + %r0] 0x20
	mov	0x48, %r16
	.word 0x87802020  ! 4204: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2f70e40  ! 4205: STXA_R	stxa	%r17, [%r28 + %r0] 0x72
	.word 0x87802072  ! 4206: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeeb4a000  ! 4207: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	.word 0xe8afce60  ! 4208: STBA_R	stba	%r20, [%r31 + %r0] 0x73
	.word 0x87802072  ! 4209: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6af2000  ! 4210: STBA_I	stba	%r19, [%r28 + 0x0000] %asi
	mov	0x18, %r27
	.word 0xe6b7ce40  ! 4212: STHA_R	stha	%r19, [%r31 + %r0] 0x72
	.word 0x87802025  ! 4213: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r20
	.word 0xe8b40400  ! 4215: STHA_R	stha	%r20, [%r16 + %r0] 0x20
	.word 0xec97ce60  ! 4216: LDUHA_R	lduha	[%r31, %r0] 0x73, %r22
	.word 0x87802020  ! 4217: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8c78e80  ! 4218: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r20
	.word 0xe2df8e80  ! 4219: LDXA_R	ldxa	[%r30, %r0] 0x74, %r17
	.word 0x87802020  ! 4220: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb4a000  ! 4221: STHA_I	stha	%r22, [%r18 + 0x0000] %asi
	.word 0xecc42000  ! 4222: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r22
	mov	0x8, %r17
	.word 0xe8b70e40  ! 4224: STHA_R	stha	%r20, [%r28 + %r0] 0x72
	.word 0xe8d42000  ! 4225: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r20
	mov	0x8, %r16
	mov	0x58, %r25
	.word 0xe8b42000  ! 4228: STHA_I	stha	%r20, [%r16 + 0x0000] %asi
	.word 0xe8846000  ! 4229: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r20
	.word 0xe8dce000  ! 4230: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r20
	.word 0xeca7ce40  ! 4231: STWA_R	stwa	%r22, [%r31 + %r0] 0x72
	.word 0xe2b7ce60  ! 4232: STHA_R	stha	%r17, [%r31 + %r0] 0x73
	mov	0x70, %r25
	.word 0x87802025  ! 4234: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r27
	.word 0x8780204f  ! 4236: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xea844400  ! 4237: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r21
	.word 0xe2aca000  ! 4238: STBA_I	stba	%r17, [%r18 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xe2942000  ! 4240: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r17
	mov	0x48, %r27
	.word 0xe2dc2000  ! 4242: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r17
	wr_tick_cmpr_3_32:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfb, %g2
	or	%g4, 0xb2, %g4
	or	%g6, 0xc8, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe6b4c400  ! 4244: STHA_R	stha	%r19, [%r19 + %r0] 0x20
	.word 0xe2ce09e0  ! 4245: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r17
	.word 0xeccc2000  ! 4246: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r22
	mov	0x18, %r25
	.word 0xecace000  ! 4248: STBA_I	stba	%r22, [%r19 + 0x0000] %asi
	.word 0xecf4e000  ! 4249: STXA_I	stxa	%r22, [%r19 + 0x0000] %asi
	.word 0xe2bc8400  ! 4250: STDA_R	stda	%r17, [%r18 + %r0] 0x20
	.word 0xec874e80  ! 4251: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r22
	.word 0xeea74e60  ! 4252: STWA_R	stwa	%r23, [%r29 + %r0] 0x73
	mov	0x28, %r24
	.word 0xe4cc4400  ! 4254: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r18
	.word 0x87802072  ! 4255: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeedcc400  ! 4256: LDXA_R	ldxa	[%r19, %r0] 0x20, %r23
	mov	0x60, %r17
	mov	0x10, %r18
	.word 0xecdec9e0  ! 4259: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r22
	.word 0xee8ec9e0  ! 4260: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r23
	mov	0x18, %r16
	.word 0xeeac6000  ! 4262: STBA_I	stba	%r23, [%r17 + 0x0000] %asi
	.word 0xee8ca000  ! 4263: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r23
	.word 0xeea42000  ! 4264: STWA_I	stwa	%r23, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 4265: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeccc0400  ! 4266: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r22
	mov	0x60, %r17
	.word 0xe6af4e40  ! 4268: STBA_R	stba	%r19, [%r29 + %r0] 0x72
	.word 0xeeaf2000  ! 4269: STBA_I	stba	%r23, [%r28 + 0x0000] %asi
	mov	0x30, %r18
	mov	0x38, %r19
	mov	0x48, %r18
	.word 0xeeb76000  ! 4273: STHA_I	stha	%r23, [%r29 + 0x0000] %asi
	mov	0x78, %r26
	.word 0x87802074  ! 4275: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeeace000  ! 4276: STBA_I	stba	%r23, [%r19 + 0x0000] %asi
	mov	0x48, %r18
	.word 0x87802020  ! 4278: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4279: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r16
	mov	0x30, %r25
	.word 0xe8df8e80  ! 4282: LDXA_R	ldxa	[%r30, %r0] 0x74, %r20
	.word 0xe8bf0e80  ! 4283: STDA_R	stda	%r20, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 4284: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r26
	.word 0xe8b40400  ! 4286: STHA_R	stha	%r20, [%r16 + %r0] 0x20
	mov	0x7c0, %r21
	.word 0xe4df2000  ! 4288: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r18
	mov	0x70, %r17
	.word 0xe4876000  ! 4290: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r18
	.word 0xe4bfa000  ! 4291: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4292: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4293: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4c76000  ! 4294: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r18
	.word 0xe4bf6000  ! 4295: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 4296: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe495e000  ! 4297: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r18
	.word 0xe4952000  ! 4298: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r18
	.word 0xe0d70e40  ! 4299: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r16
	.word 0x8780204f  ! 4300: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8bf4e40  ! 4301: STDA_R	stda	%r20, [%r29 + %r0] 0x72
	.word 0xe6a6c9e0  ! 4302: STWA_R	stwa	%r19, [%r27 + %r0] 0x4f
	.word 0xe2bf6000  ! 4303: STDA_I	stda	%r17, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4304: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe28ce000  ! 4305: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r17
	.word 0xe08fce60  ! 4306: LDUBA_R	lduba	[%r31, %r0] 0x73, %r16
	.word 0xe8c649e0  ! 4307: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r20
	mov	0x0, %r17
	mov	0x30, %r27
	.word 0xe29f0e80  ! 4310: LDDA_R	ldda	[%r28, %r0] 0x74, %r17
	mov	0x70, %r17
	.word 0x87802020  ! 4312: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r22
	.word 0xe0dd04a0  ! 4314: LDXA_R	ldxa	[%r20, %r0] 0x25, %r16
	.word 0xeef42000  ! 4315: STXA_I	stxa	%r23, [%r16 + 0x0000] %asi
	.word 0xe2948400  ! 4316: LDUHA_R	lduha	[%r18, %r0] 0x20, %r17
	.word 0xecac4400  ! 4317: STBA_R	stba	%r22, [%r17 + %r0] 0x20
	.word 0xec8f4e60  ! 4318: LDUBA_R	lduba	[%r29, %r0] 0x73, %r22
	.word 0xe2af4e80  ! 4319: STBA_R	stba	%r17, [%r29 + %r0] 0x74
	.word 0xeeace000  ! 4320: STBA_I	stba	%r23, [%r19 + 0x0000] %asi
	.word 0xe28d84a0  ! 4321: LDUBA_R	lduba	[%r22, %r0] 0x25, %r17
	mov	0x3d8, %r22
	.word 0xecc4a000  ! 4323: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r22
	.word 0xeebd04a0  ! 4324: STDA_R	stda	%r23, [%r20 + %r0] 0x25
	.word 0xee94e000  ! 4325: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r23
	.word 0xeeb4a000  ! 4326: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	.word 0xe8bf0e80  ! 4327: STDA_R	stda	%r20, [%r28 + %r0] 0x74
	.word 0xecdca000  ! 4328: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r22
	.word 0xecaca000  ! 4329: STBA_I	stba	%r22, [%r18 + 0x0000] %asi
	.word 0xecdc2000  ! 4330: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r22
	mov	0x3f8, %r21
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 4333: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeca66000  ! 4334: STWA_I	stwa	%r22, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 4335: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xec94e000  ! 4336: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r22
	.word 0x87802020  ! 4337: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb42000  ! 4338: STHA_I	stha	%r22, [%r16 + 0x0000] %asi
	.word 0xeccc2000  ! 4339: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r22
	.word 0xe08f8e40  ! 4340: LDUBA_R	lduba	[%r30, %r0] 0x72, %r16
	.word 0x87802072  ! 4341: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4342: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a74e80  ! 4343: STWA_R	stwa	%r16, [%r29 + %r0] 0x74
	.word 0xe29f2000  ! 4344: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r17
	.word 0xe2c72000  ! 4345: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r17
	mov	0x28, %r17
	.word 0x87802074  ! 4347: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r23
	.word 0x8780204f  ! 4349: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4350: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2876000  ! 4351: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r17
	.word 0xe287a000  ! 4352: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r17
	.word 0xe2b76000  ! 4353: STHA_I	stha	%r17, [%r29 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xe4bf4e40  ! 4355: STDA_R	stda	%r18, [%r29 + %r0] 0x72
	.word 0x87802020  ! 4356: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb7a000  ! 4357: STHA_I	stha	%r22, [%r30 + 0x0000] %asi
	.word 0xe2bc0400  ! 4358: STDA_R	stda	%r17, [%r16 + %r0] 0x20
	.word 0xe2d7a000  ! 4359: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r17
	.word 0x87802025  ! 4360: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2f42000  ! 4361: STXA_I	stxa	%r17, [%r16 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xe8ad44a0  ! 4363: STBA_R	stba	%r20, [%r21 + %r0] 0x25
	.word 0xe2d46000  ! 4364: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r17
	.word 0xe8ac8400  ! 4365: STBA_R	stba	%r20, [%r18 + %r0] 0x20
	.word 0xe4b78e40  ! 4366: STHA_R	stha	%r18, [%r30 + %r0] 0x72
	.word 0xeeb46000  ! 4367: STHA_I	stha	%r23, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 4368: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeec42000  ! 4369: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r23
	mov	0x30, %r19
	.word 0xe2b74e60  ! 4371: STHA_R	stha	%r17, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 4372: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe0c40400  ! 4373: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r16
	.word 0xe484e000  ! 4374: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r18
	.word 0xeef4c400  ! 4375: STXA_R	stxa	%r23, [%r19 + %r0] 0x20
	mov	0x68, %r17
	.word 0xe0b42000  ! 4377: STHA_I	stha	%r16, [%r16 + 0x0000] %asi
	mov	0x70, %r25
	.word 0x87802025  ! 4379: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0b46000  ! 4380: STHA_I	stha	%r16, [%r17 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xe0a46000  ! 4382: STWA_I	stwa	%r16, [%r17 + 0x0000] %asi
	.word 0xe0846000  ! 4383: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r16
	.word 0xec974e80  ! 4384: LDUHA_R	lduha	[%r29, %r0] 0x74, %r22
	mov	0x70, %r18
	mov	0x68, %r19
	.word 0xeebca000  ! 4387: STDA_I	stda	%r23, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4388: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r18
	.word 0x8780204f  ! 4390: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d0, %r20
	mov	0x8, %r27
	.word 0x87802020  ! 4393: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeec76000  ! 4394: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r23
	.word 0xee8f6000  ! 4395: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r23
	.word 0xeecfa000  ! 4396: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r23
	.word 0xe4bc8400  ! 4397: STDA_R	stda	%r18, [%r18 + %r0] 0x20
	mov	0x3f8, %r20
	.word 0xe0bd84a0  ! 4399: STDA_R	stda	%r16, [%r22 + %r0] 0x25
	.word 0xe8d72000  ! 4400: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r20
	.word 0xe8972000  ! 4401: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r20
	.word 0xe89fa000  ! 4402: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r20
	.word 0xe494c400  ! 4403: LDUHA_R	lduha	[%r19, %r0] 0x20, %r18
	mov	0x68, %r19
	.word 0xe2b70e80  ! 4405: STHA_R	stha	%r17, [%r28 + %r0] 0x74
	.word 0xecb649e0  ! 4406: STHA_R	stha	%r22, [%r25 + %r0] 0x4f
	.word 0xe6cf2000  ! 4407: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r19
	.word 0x87802025  ! 4408: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4f78e60  ! 4409: STXA_R	stxa	%r18, [%r30 + %r0] 0x73
	mov	0x38, %r17
	.word 0xeabc4400  ! 4411: STDA_R	stda	%r21, [%r17 + %r0] 0x20
	.word 0xe8b46000  ! 4412: STHA_I	stha	%r20, [%r17 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0x87802074  ! 4414: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4415: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r26
	.word 0x87802025  ! 4417: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8df4e60  ! 4418: LDXA_R	ldxa	[%r29, %r0] 0x73, %r20
	.word 0xe2a70e80  ! 4419: STWA_R	stwa	%r17, [%r28 + %r0] 0x74
	.word 0xeaa70e60  ! 4420: STWA_R	stwa	%r21, [%r28 + %r0] 0x73
	.word 0xe8866000  ! 4421: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r20
	.word 0xe2b70e40  ! 4422: STHA_R	stha	%r17, [%r28 + %r0] 0x72
	.word 0xecaea000  ! 4423: STBA_I	stba	%r22, [%r26 + 0x0000] %asi
	.word 0xecd66000  ! 4424: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r22
	.word 0xec866000  ! 4425: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r22
	.word 0xecae2000  ! 4426: STBA_I	stba	%r22, [%r24 + 0x0000] %asi
	.word 0xecf6a000  ! 4427: STXA_I	stxa	%r22, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 4428: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecc6e000  ! 4429: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r22
	.word 0xec9e2000  ! 4430: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r22
	.word 0xec862000  ! 4431: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r22
	.word 0xe4f48400  ! 4432: STXA_R	stxa	%r18, [%r18 + %r0] 0x20
	.word 0xe68c4400  ! 4433: LDUBA_R	lduba	[%r17, %r0] 0x20, %r19
	.word 0xe6c6c9e0  ! 4434: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r19
	.word 0xe0b48400  ! 4435: STHA_R	stha	%r16, [%r18 + %r0] 0x20
	.word 0x87802025  ! 4436: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 4437: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeaf44400  ! 4438: STXA_R	stxa	%r21, [%r17 + %r0] 0x20
	mov	0x70, %r27
	.word 0xe6f4c400  ! 4440: STXA_R	stxa	%r19, [%r19 + %r0] 0x20
	.word 0xecb72000  ! 4441: STHA_I	stha	%r22, [%r28 + 0x0000] %asi
	.word 0xecdfe000  ! 4442: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r22
	.word 0xecdfa000  ! 4443: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r22
	.word 0xeecf0e80  ! 4444: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r23
	wr_tick_cmpr_3_33:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x88, %g2
	or	%g4, 0xa0, %g4
	or	%g6, 0xd7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeedf4e60  ! 4446: LDXA_R	ldxa	[%r29, %r0] 0x73, %r23
	mov	0x3d0, %r23
	.word 0xecaf0e60  ! 4448: STBA_R	stba	%r22, [%r28 + %r0] 0x73
	.word 0xe49c8400  ! 4449: LDDA_R	ldda	[%r18, %r0] 0x20, %r18
	.word 0xe6d44400  ! 4450: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r19
	mov	0x3f8, %r23
	.word 0xe4f7ce80  ! 4452: STXA_R	stxa	%r18, [%r31 + %r0] 0x74
	.word 0xe8c48400  ! 4453: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r20
	.word 0xe6afe000  ! 4454: STBA_I	stba	%r19, [%r31 + 0x0000] %asi
	mov	0x68, %r25
	mov	0x20, %r26
	.word 0xeeb70e60  ! 4457: STHA_R	stha	%r23, [%r28 + %r0] 0x73
	.word 0xe8b48400  ! 4458: STHA_R	stha	%r20, [%r18 + %r0] 0x20
	.word 0xe6dfe000  ! 4459: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r19
	.word 0xe6a7ce80  ! 4460: STWA_R	stwa	%r19, [%r31 + %r0] 0x74
	.word 0xea8fce60  ! 4461: LDUBA_R	lduba	[%r31, %r0] 0x73, %r21
	mov	0x20, %r16
	.word 0x8780204f  ! 4463: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe28de000  ! 4464: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r17
	.word 0xe29da000  ! 4465: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r17
	.word 0xe2bde000  ! 4466: STDA_I	stda	%r17, [%r23 + 0x0000] %asi
	.word 0xe28da000  ! 4467: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r17
	.word 0x87802072  ! 4468: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2d76000  ! 4469: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r17
	.word 0xeaaf0e60  ! 4470: STBA_R	stba	%r21, [%r28 + %r0] 0x73
	wr_tick_cmpr_3_34:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x9a, %g2
	or	%g4, 0xac, %g4
	or	%g6, 0xca, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe6af6000  ! 4472: STBA_I	stba	%r19, [%r29 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xeeac0400  ! 4474: STBA_R	stba	%r23, [%r16 + %r0] 0x20
	.word 0xecde89e0  ! 4475: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r22
	.word 0xe0a7e000  ! 4476: STWA_I	stwa	%r16, [%r31 + 0x0000] %asi
	.word 0xeeb74e40  ! 4477: STHA_R	stha	%r23, [%r29 + %r0] 0x72
	mov	0x7c8, %r23
	.word 0xe4f74e80  ! 4479: STXA_R	stxa	%r18, [%r29 + %r0] 0x74
	.word 0xeebc4400  ! 4480: STDA_R	stda	%r23, [%r17 + %r0] 0x20
	.word 0xe68fe000  ! 4481: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r19
	mov	0x60, %r25
	.word 0xe4a609e0  ! 4483: STWA_R	stwa	%r18, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 4484: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2d44400  ! 4485: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r17
	.word 0xe0c76000  ! 4486: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r16
	.word 0xe0df2000  ! 4487: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r16
	.word 0x87802020  ! 4488: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe28f0e80  ! 4489: LDUBA_R	lduba	[%r28, %r0] 0x74, %r17
	.word 0xe8f56000  ! 4490: STXA_I	stxa	%r20, [%r21 + 0x0000] %asi
	mov	0x7d8, %r21
	.word 0x87802072  ! 4492: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe89da000  ! 4493: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r20
	.word 0xe2b74e80  ! 4494: STHA_R	stha	%r17, [%r29 + %r0] 0x74
	mov	0x78, %r27
	mov	0x3c0, %r21
	.word 0x87802020  ! 4497: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8bec9e0  ! 4498: STDA_R	stda	%r20, [%r27 + %r0] 0x4f
	.word 0xeed44400  ! 4499: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r23
	.word 0xe2cf2000  ! 4500: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r17
	.word 0x87802072  ! 4501: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4502: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe29c0400  ! 4503: LDDA_R	ldda	[%r16, %r0] 0x20, %r17
	.word 0xeadf6000  ! 4504: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r21
	.word 0x87802020  ! 4505: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0948400  ! 4506: LDUHA_R	lduha	[%r18, %r0] 0x20, %r16
	.word 0xeaf70e40  ! 4507: STXA_R	stxa	%r21, [%r28 + %r0] 0x72
	.word 0xea9d84a0  ! 4508: LDDA_R	ldda	[%r22, %r0] 0x25, %r21
	.word 0xe4d5c4a0  ! 4509: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r18
	.word 0xe8ae6000  ! 4510: STBA_I	stba	%r20, [%r25 + 0x0000] %asi
	.word 0xe69ec9e0  ! 4511: LDDA_R	ldda	[%r27, %r0] 0x4f, %r19
	mov	0x3f0, %r20
	.word 0xeea7ce40  ! 4513: STWA_R	stwa	%r23, [%r31 + %r0] 0x72
	.word 0xe2b609e0  ! 4514: STHA_R	stha	%r17, [%r24 + %r0] 0x4f
	.word 0xe4dc0400  ! 4515: LDXA_R	ldxa	[%r16, %r0] 0x20, %r18
	.word 0xe6b66000  ! 4516: STHA_I	stha	%r19, [%r25 + 0x0000] %asi
	.word 0xe6bea000  ! 4517: STDA_I	stda	%r19, [%r26 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xe6f66000  ! 4519: STXA_I	stxa	%r19, [%r25 + 0x0000] %asi
	.word 0xecbe09e0  ! 4520: STDA_R	stda	%r22, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 4521: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeeb78e60  ! 4522: STHA_R	stha	%r23, [%r30 + %r0] 0x73
	mov	0x28, %r26
	.word 0xe8b52000  ! 4524: STHA_I	stha	%r20, [%r20 + 0x0000] %asi
	.word 0xe8c5a000  ! 4525: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r20
	.word 0xe885e000  ! 4526: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r20
	.word 0x87802074  ! 4527: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r18
	.word 0xeef74e40  ! 4529: STXA_R	stxa	%r23, [%r29 + %r0] 0x72
	.word 0xee9504a0  ! 4530: LDUHA_R	lduha	[%r20, %r0] 0x25, %r23
	.word 0xec8fe000  ! 4531: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r22
	.word 0xecdfe000  ! 4532: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r22
	.word 0x87802073  ! 4533: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r24
	.word 0xec9c6000  ! 4535: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r22
	.word 0xe48c0400  ! 4536: LDUBA_R	lduba	[%r16, %r0] 0x20, %r18
	mov	0x3c8, %r20
	mov	0x3c0, %r20
	.word 0xe69649e0  ! 4539: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r19
	.word 0x8780204f  ! 4540: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8b74e40  ! 4541: STHA_R	stha	%r20, [%r29 + %r0] 0x72
	.word 0xe4f78e40  ! 4542: STXA_R	stxa	%r18, [%r30 + %r0] 0x72
	.word 0xe4bdc4a0  ! 4543: STDA_R	stda	%r18, [%r23 + %r0] 0x25
	.word 0xe2ae49e0  ! 4544: STBA_R	stba	%r17, [%r25 + %r0] 0x4f
	mov	0x40, %r18
	.word 0x87802074  ! 4546: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r16
	mov	0x3d0, %r22
	.word 0xec9f2000  ! 4549: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r22
	.word 0xecc76000  ! 4550: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0x87802020  ! 4551: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecf72000  ! 4552: STXA_I	stxa	%r22, [%r28 + 0x0000] %asi
	.word 0xe4acc400  ! 4553: STBA_R	stba	%r18, [%r19 + %r0] 0x20
	.word 0xeec72000  ! 4554: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r23
	mov	0x78, %r16
	mov	0x7c0, %r20
	.word 0xe8844400  ! 4557: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r20
	.word 0xeecd84a0  ! 4558: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r23
	.word 0xeaa74e40  ! 4559: STWA_R	stwa	%r21, [%r29 + %r0] 0x72
	.word 0xee8f4e60  ! 4560: LDUBA_R	lduba	[%r29, %r0] 0x73, %r23
	.word 0xeacf8e40  ! 4561: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r21
	.word 0xe0a4c400  ! 4562: STWA_R	stwa	%r16, [%r19 + %r0] 0x20
	.word 0xe4d76000  ! 4563: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r18
	.word 0x87802020  ! 4564: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe48c8400  ! 4565: LDUBA_R	lduba	[%r18, %r0] 0x20, %r18
	.word 0xeabce000  ! 4566: STDA_I	stda	%r21, [%r19 + 0x0000] %asi
	.word 0xe0a7ce80  ! 4567: STWA_R	stwa	%r16, [%r31 + %r0] 0x74
	.word 0xeadd44a0  ! 4568: LDXA_R	ldxa	[%r21, %r0] 0x25, %r21
	.word 0xeeaf0e60  ! 4569: STBA_R	stba	%r23, [%r28 + %r0] 0x73
	.word 0xe8c4e000  ! 4570: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r20
	mov	0x20, %r24
	.word 0xe8f74e40  ! 4572: STXA_R	stxa	%r20, [%r29 + %r0] 0x72
	.word 0xecb42000  ! 4573: STHA_I	stha	%r22, [%r16 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x78, %r18
	mov	0x3e8, %r21
	.word 0xe8bf8e40  ! 4577: STDA_R	stda	%r20, [%r30 + %r0] 0x72
	.word 0xe6970e80  ! 4578: LDUHA_R	lduha	[%r28, %r0] 0x74, %r19
	.word 0xe08dc4a0  ! 4579: LDUBA_R	lduba	[%r23, %r0] 0x25, %r16
	.word 0xeccce000  ! 4580: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r22
	.word 0x87802020  ! 4581: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecf7e000  ! 4582: STXA_I	stxa	%r22, [%r31 + 0x0000] %asi
	.word 0xeeb4c400  ! 4583: STHA_R	stha	%r23, [%r19 + %r0] 0x20
	.word 0x87802025  ! 4584: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4585: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r26
	.word 0x87802020  ! 4587: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2c72000  ! 4588: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r17
	.word 0xe8ce49e0  ! 4589: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r20
	mov	0x0, %r25
	.word 0xe0afe000  ! 4591: STBA_I	stba	%r16, [%r31 + 0x0000] %asi
	.word 0xe4b649e0  ! 4592: STHA_R	stha	%r18, [%r25 + %r0] 0x4f
	mov	0x20, %r17
	.word 0xe8bf4e40  ! 4594: STDA_R	stda	%r20, [%r29 + %r0] 0x72
	mov	0x20, %r19
	mov	0x3f8, %r21
	mov	0x3d0, %r21
	mov	0x7c0, %r20
	mov	0x7c8, %r21
	mov	0x7f0, %r23
	.word 0xe6afe000  ! 4601: STBA_I	stba	%r19, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4602: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r21
	.word 0xe6af8e80  ! 4604: STBA_R	stba	%r19, [%r30 + %r0] 0x74
	.word 0xe4f7ce40  ! 4605: STXA_R	stxa	%r18, [%r31 + %r0] 0x72
	.word 0xecbfa000  ! 4606: STDA_I	stda	%r22, [%r30 + 0x0000] %asi
	.word 0xeadec9e0  ! 4607: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r21
	mov	0x68, %r19
	.word 0x87802073  ! 4609: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 4610: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r21
	mov	0x3c8, %r23
	.word 0xe2872000  ! 4613: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r17
	.word 0xeace09e0  ! 4614: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r21
	.word 0xeaa44400  ! 4615: STWA_R	stwa	%r21, [%r17 + %r0] 0x20
	mov	0x10, %r18
	mov	0x40, %r17
	mov	0x7c8, %r20
	.word 0x87802073  ! 4619: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 4620: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r16
	mov	0x68, %r25
	mov	0x8, %r18
	.word 0x87802074  ! 4624: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r21
	.word 0xe0b76000  ! 4626: STHA_I	stha	%r16, [%r29 + 0x0000] %asi
	.word 0xe09fe000  ! 4627: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r16
	mov	0x7e8, %r23
	.word 0xeac40400  ! 4629: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r21
	.word 0xe2bf2000  ! 4630: STDA_I	stda	%r17, [%r28 + 0x0000] %asi
	.word 0xe2d7a000  ! 4631: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r17
	.word 0xe08fce80  ! 4632: LDUBA_R	lduba	[%r31, %r0] 0x74, %r16
	.word 0xeaf7ce80  ! 4633: STXA_R	stxa	%r21, [%r31 + %r0] 0x74
	.word 0xe4a76000  ! 4634: STWA_I	stwa	%r18, [%r29 + 0x0000] %asi
	.word 0xe8a6c9e0  ! 4635: STWA_R	stwa	%r20, [%r27 + %r0] 0x4f
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xe6876000  ! 4637: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r19
	.word 0xe6c7a000  ! 4638: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r19
	.word 0xe687e000  ! 4639: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r19
	.word 0xe6ae89e0  ! 4640: STBA_R	stba	%r19, [%r26 + %r0] 0x4f
	.word 0xe2bfe000  ! 4641: STDA_I	stda	%r17, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4642: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xee9cc400  ! 4643: LDDA_R	ldda	[%r19, %r0] 0x20, %r23
	.word 0xe28f2000  ! 4644: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r17
	mov	0x7f0, %r23
	.word 0xe2b72000  ! 4646: STHA_I	stha	%r17, [%r28 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x60, %r17
	.word 0x87802072  ! 4649: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4948400  ! 4650: LDUHA_R	lduha	[%r18, %r0] 0x20, %r18
	.word 0xe8bea000  ! 4651: STDA_I	stda	%r20, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 4652: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4653: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8bc0400  ! 4654: STDA_R	stda	%r20, [%r16 + %r0] 0x20
	.word 0xecaf2000  ! 4655: STBA_I	stba	%r22, [%r28 + 0x0000] %asi
	.word 0xee8f8e40  ! 4656: LDUBA_R	lduba	[%r30, %r0] 0x72, %r23
	mov	0x7d8, %r22
	.word 0xe2d72000  ! 4658: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r17
	.word 0x87802020  ! 4659: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeab689e0  ! 4660: STHA_R	stha	%r21, [%r26 + %r0] 0x4f
	.word 0xe8be6000  ! 4661: STDA_I	stda	%r20, [%r25 + 0x0000] %asi
	.word 0xe68f0e60  ! 4662: LDUBA_R	lduba	[%r28, %r0] 0x73, %r19
	.word 0x8780204f  ! 4663: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe49649e0  ! 4664: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r18
	.word 0xe094a000  ! 4665: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r16
	.word 0x8780204f  ! 4666: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r18
	mov	0x48, %r24
	.word 0xe0c6c9e0  ! 4669: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r16
	.word 0xe8f40400  ! 4670: STXA_R	stxa	%r20, [%r16 + %r0] 0x20
	.word 0xe0ac6000  ! 4671: STBA_I	stba	%r16, [%r17 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xe0a4e000  ! 4673: STWA_I	stwa	%r16, [%r19 + 0x0000] %asi
	.word 0xe09c6000  ! 4674: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r16
	.word 0xe0d46000  ! 4675: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r16
	.word 0xee940400  ! 4676: LDUHA_R	lduha	[%r16, %r0] 0x20, %r23
	.word 0xe694a000  ! 4677: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r19
	.word 0xe4a40400  ! 4678: STWA_R	stwa	%r18, [%r16 + %r0] 0x20
	mov	0x3f8, %r21
	.word 0xee9c8400  ! 4680: LDDA_R	ldda	[%r18, %r0] 0x20, %r23
	.word 0x87802074  ! 4681: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2f6c9e0  ! 4682: STXA_R	stxa	%r17, [%r27 + %r0] 0x4f
	.word 0xecb7ce80  ! 4683: STHA_R	stha	%r22, [%r31 + %r0] 0x74
	.word 0xe0a5e000  ! 4684: STWA_I	stwa	%r16, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 4685: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0af2000  ! 4686: STBA_I	stba	%r16, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4687: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb7ce80  ! 4688: STHA_R	stha	%r22, [%r31 + %r0] 0x74
	.word 0xe694c400  ! 4689: LDUHA_R	lduha	[%r19, %r0] 0x20, %r19
	.word 0xeab70e60  ! 4690: STHA_R	stha	%r21, [%r28 + %r0] 0x73
	mov	0x50, %r17
	.word 0xecac0400  ! 4692: STBA_R	stba	%r22, [%r16 + %r0] 0x20
	.word 0xe6f4a000  ! 4693: STXA_I	stxa	%r19, [%r18 + 0x0000] %asi
	.word 0xe4b44400  ! 4694: STHA_R	stha	%r18, [%r17 + %r0] 0x20
	.word 0xe4b4c400  ! 4695: STHA_R	stha	%r18, [%r19 + %r0] 0x20
	.word 0xee8689e0  ! 4696: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r23
	mov	0x30, %r19
	mov	0x7e8, %r22
	.word 0xeaaca000  ! 4699: STBA_I	stba	%r21, [%r18 + 0x0000] %asi
	.word 0xe2c4c400  ! 4700: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r17
	.word 0xe4c584a0  ! 4701: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r18
	.word 0xe6b70e60  ! 4702: STHA_R	stha	%r19, [%r28 + %r0] 0x73
	.word 0x87802072  ! 4703: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeadca000  ! 4704: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r21
	mov	0x7c0, %r20
	.word 0xead42000  ! 4706: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r21
	.word 0xe0bf4e40  ! 4707: STDA_R	stda	%r16, [%r29 + %r0] 0x72
	.word 0xecf48400  ! 4708: STXA_R	stxa	%r22, [%r18 + %r0] 0x20
	.word 0xe29dc4a0  ! 4709: LDDA_R	ldda	[%r23, %r0] 0x25, %r17
	.word 0xe0846000  ! 4710: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r16
	mov	0x48, %r27
	.word 0xe0a46000  ! 4712: STWA_I	stwa	%r16, [%r17 + 0x0000] %asi
	.word 0xe8b649e0  ! 4713: STHA_R	stha	%r20, [%r25 + %r0] 0x4f
	.word 0xecc6c9e0  ! 4714: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r22
	.word 0xe8b4e000  ! 4715: STHA_I	stha	%r20, [%r19 + 0x0000] %asi
	.word 0xe8cc6000  ! 4716: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r20
	mov	0x30, %r17
	.word 0xe8bce000  ! 4718: STDA_I	stda	%r20, [%r19 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xe8bc2000  ! 4720: STDA_I	stda	%r20, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 4721: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r24
	.word 0xec948400  ! 4723: LDUHA_R	lduha	[%r18, %r0] 0x20, %r22
	.word 0xea9cc400  ! 4724: LDDA_R	ldda	[%r19, %r0] 0x20, %r21
	.word 0xe4b6e000  ! 4725: STHA_I	stha	%r18, [%r27 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xe4ae2000  ! 4727: STBA_I	stba	%r18, [%r24 + 0x0000] %asi
	.word 0xe4b6e000  ! 4728: STHA_I	stha	%r18, [%r27 + 0x0000] %asi
	mov	0x10, %r17
	.word 0xeecc8400  ! 4730: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r23
	.word 0x87802073  ! 4731: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeec5a000  ! 4732: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r23
	.word 0xeed52000  ! 4733: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r23
	mov	0x7d8, %r20
	.word 0xeead2000  ! 4735: STBA_I	stba	%r23, [%r20 + 0x0000] %asi
	.word 0xeea52000  ! 4736: STWA_I	stwa	%r23, [%r20 + 0x0000] %asi
	mov	0x8, %r27
	mov	0x70, %r25
	.word 0xee8d6000  ! 4739: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r23
	.word 0xeeade000  ! 4740: STBA_I	stba	%r23, [%r23 + 0x0000] %asi
	.word 0xeea52000  ! 4741: STWA_I	stwa	%r23, [%r20 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xe4c70e80  ! 4743: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r18
	mov	0x40, %r19
	mov	0x3f0, %r23
	.word 0x8780204f  ! 4746: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2df6000  ! 4747: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r17
	mov	0x7c0, %r21
	.word 0xecb40400  ! 4749: STHA_R	stha	%r22, [%r16 + %r0] 0x20
	.word 0xeaf76000  ! 4750: STXA_I	stxa	%r21, [%r29 + 0x0000] %asi
	.word 0xe08c0400  ! 4751: LDUBA_R	lduba	[%r16, %r0] 0x20, %r16
	.word 0xe4bfa000  ! 4752: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4753: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4754: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c0, %r21
	.word 0xe6a40400  ! 4756: STWA_R	stwa	%r19, [%r16 + %r0] 0x20
	.word 0xee9f0e60  ! 4757: LDDA_R	ldda	[%r28, %r0] 0x73, %r23
	.word 0xe09c2000  ! 4758: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r16
	.word 0xe08504a0  ! 4759: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r16
	.word 0xe09c0400  ! 4760: LDDA_R	ldda	[%r16, %r0] 0x20, %r16
	mov	0x7f8, %r21
	.word 0xe8b46000  ! 4762: STHA_I	stha	%r20, [%r17 + 0x0000] %asi
	.word 0xe89f8e60  ! 4763: LDDA_R	ldda	[%r30, %r0] 0x73, %r20
	.word 0xe694e000  ! 4764: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r19
	.word 0xe6ac6000  ! 4765: STBA_I	stba	%r19, [%r17 + 0x0000] %asi
	.word 0xead40400  ! 4766: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r21
	.word 0xe2c78e60  ! 4767: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r17
	.word 0xeeb40400  ! 4768: STHA_R	stha	%r23, [%r16 + %r0] 0x20
	.word 0xe4bce000  ! 4769: STDA_I	stda	%r18, [%r19 + 0x0000] %asi
	.word 0xee944400  ! 4770: LDUHA_R	lduha	[%r17, %r0] 0x20, %r23
	.word 0xe2f46000  ! 4771: STXA_I	stxa	%r17, [%r17 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xe0948400  ! 4773: LDUHA_R	lduha	[%r18, %r0] 0x20, %r16
	.word 0x87802074  ! 4774: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeec76000  ! 4775: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r23
	.word 0x87802073  ! 4776: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0f504a0  ! 4777: STXA_R	stxa	%r16, [%r20 + %r0] 0x25
	.word 0xe0df6000  ! 4778: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r16
	.word 0xe0a7a000  ! 4779: STWA_I	stwa	%r16, [%r30 + 0x0000] %asi
	.word 0xe0c40400  ! 4780: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r16
	.word 0xeed44400  ! 4781: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r23
	.word 0xe88f2000  ! 4782: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r20
	.word 0x87802073  ! 4783: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0f78e80  ! 4784: STXA_R	stxa	%r16, [%r30 + %r0] 0x74
	.word 0xecb4a000  ! 4785: STHA_I	stha	%r22, [%r18 + 0x0000] %asi
	.word 0xeca4a000  ! 4786: STWA_I	stwa	%r22, [%r18 + 0x0000] %asi
	.word 0xec9c6000  ! 4787: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r22
	.word 0xe48c4400  ! 4788: LDUBA_R	lduba	[%r17, %r0] 0x20, %r18
	.word 0x87802020  ! 4789: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4790: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c8, %r20
	mov	0x40, %r27
	.word 0xe8ac8400  ! 4793: STBA_R	stba	%r20, [%r18 + %r0] 0x20
	.word 0xe4d6e000  ! 4794: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r18
	mov	0x0, %r24
	.word 0xe49e6000  ! 4796: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r18
	.word 0xee9dc4a0  ! 4797: LDDA_R	ldda	[%r23, %r0] 0x25, %r23
	.word 0xeaf44400  ! 4798: STXA_R	stxa	%r21, [%r17 + %r0] 0x20
	mov	0x48, %r25
	.word 0xe2f6e000  ! 4800: STXA_I	stxa	%r17, [%r27 + 0x0000] %asi
	.word 0xecdc0400  ! 4801: LDXA_R	ldxa	[%r16, %r0] 0x20, %r22
	.word 0x87802074  ! 4802: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f8, %r22
	.word 0xe0dce000  ! 4804: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r16
	mov	0x3d8, %r23
	mov	0x18, %r26
	.word 0xeed70e80  ! 4807: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r23
	.word 0xe2b4e000  ! 4808: STHA_I	stha	%r17, [%r19 + 0x0000] %asi
	.word 0xe8ad44a0  ! 4809: STBA_R	stba	%r20, [%r21 + %r0] 0x25
	mov	0x40, %r16
	.word 0xec9ce000  ! 4811: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r22
	.word 0x87802020  ! 4812: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe48649e0  ! 4813: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r18
	.word 0xecb4e000  ! 4814: STHA_I	stha	%r22, [%r19 + 0x0000] %asi
	.word 0xe8f70e80  ! 4815: STXA_R	stxa	%r20, [%r28 + %r0] 0x74
	mov	0x48, %r26
	.word 0xe6bc6000  ! 4817: STDA_I	stda	%r19, [%r17 + 0x0000] %asi
	wr_tick_cmpr_3_35:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xfc, %g2
	or	%g4, 0x8c, %g4
	or	%g6, 0xab, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 4819: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeccc0400  ! 4820: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r22
	.word 0xe6d7a000  ! 4821: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r19
	.word 0x8780204f  ! 4822: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 4823: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2ad04a0  ! 4824: STBA_R	stba	%r17, [%r20 + %r0] 0x25
	.word 0xead5c4a0  ! 4825: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r21
	.word 0xec8f6000  ! 4826: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	mov	0x7e8, %r22
	.word 0xecbfa000  ! 4828: STDA_I	stda	%r22, [%r30 + 0x0000] %asi
	.word 0xec8f2000  ! 4829: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r22
	mov	0x18, %r26
	.word 0xec8f2000  ! 4831: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r22
	mov	0x3c8, %r21
	.word 0xecd72000  ! 4833: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r22
	.word 0xec97a000  ! 4834: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r22
	.word 0xec9f2000  ! 4835: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r22
	.word 0xec872000  ! 4836: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r22
	.word 0xecd76000  ! 4837: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r22
	mov	0x28, %r18
	.word 0xecf7e000  ! 4839: STXA_I	stxa	%r22, [%r31 + 0x0000] %asi
	.word 0xec976000  ! 4840: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r22
	.word 0x8780204f  ! 4841: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe48649e0  ! 4842: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r18
	.word 0xe6974e60  ! 4843: LDUHA_R	lduha	[%r29, %r0] 0x73, %r19
	.word 0xe2bca000  ! 4844: STDA_I	stda	%r17, [%r18 + 0x0000] %asi
	.word 0xe2bc2000  ! 4845: STDA_I	stda	%r17, [%r16 + 0x0000] %asi
	.word 0xe29c6000  ! 4846: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r17
	.word 0xe2d78e80  ! 4847: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r17
	.word 0xe0a70e80  ! 4848: STWA_R	stwa	%r16, [%r28 + %r0] 0x74
	.word 0xe6b74e80  ! 4849: STHA_R	stha	%r19, [%r29 + %r0] 0x74
	.word 0xe29c6000  ! 4850: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r17
	.word 0xe0cfce80  ! 4851: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r16
	.word 0xe8dc2000  ! 4852: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r20
	.word 0xecc44400  ! 4853: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r22
	.word 0xe6dc2000  ! 4854: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r19
	.word 0xe6c4a000  ! 4855: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r19
	.word 0xe6f4a000  ! 4856: STXA_I	stxa	%r19, [%r18 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xeed584a0  ! 4858: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r23
	.word 0x87802072  ! 4859: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4860: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4a76000  ! 4861: STWA_I	stwa	%r18, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 4862: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe4afa000  ! 4863: STBA_I	stba	%r18, [%r30 + 0x0000] %asi
	.word 0xe4dfe000  ! 4864: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r18
	.word 0xe4afa000  ! 4865: STBA_I	stba	%r18, [%r30 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xe4f72000  ! 4867: STXA_I	stxa	%r18, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 4868: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4d6a000  ! 4869: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r18
	.word 0x87802020  ! 4870: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r16
	.word 0xe4be49e0  ! 4872: STDA_R	stda	%r18, [%r25 + %r0] 0x4f
	.word 0xeca40400  ! 4873: STWA_R	stwa	%r22, [%r16 + %r0] 0x20
	mov	0x3d8, %r22
	mov	0x30, %r16
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xeabfa000  ! 4877: STDA_I	stda	%r21, [%r30 + 0x0000] %asi
	mov	0x68, %r19
	ta	T_CHANGE_PRIV	! macro
	.word 0xe48f4e80  ! 4880: LDUBA_R	lduba	[%r29, %r0] 0x74, %r18
	.word 0xe8f649e0  ! 4881: STXA_R	stxa	%r20, [%r25 + %r0] 0x4f
	mov	0x7c0, %r22
	.word 0xecc7e000  ! 4883: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r22
	mov	0x40, %r18
	mov	0x0, %r24
	.word 0xe0a48400  ! 4886: STWA_R	stwa	%r16, [%r18 + %r0] 0x20
	.word 0xec97e000  ! 4887: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r22
	.word 0xecbfa000  ! 4888: STDA_I	stda	%r22, [%r30 + 0x0000] %asi
	.word 0xecc7a000  ! 4889: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r22
	.word 0xecb7a000  ! 4890: STHA_I	stha	%r22, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4891: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecbde000  ! 4892: STDA_I	stda	%r22, [%r23 + 0x0000] %asi
	.word 0xea8689e0  ! 4893: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r21
	.word 0xe496c9e0  ! 4894: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r18
	.word 0xe8a56000  ! 4895: STWA_I	stwa	%r20, [%r21 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xe885e000  ! 4897: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r20
	.word 0xe8856000  ! 4898: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r20
	.word 0xe8dda000  ! 4899: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r20
	.word 0xe4f78e40  ! 4900: STXA_R	stxa	%r18, [%r30 + %r0] 0x72
	.word 0xeeb5e000  ! 4901: STHA_I	stha	%r23, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 4902: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4903: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4904: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_36:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x8c, %g2
	or	%g4, 0xa0, %g4
	or	%g6, 0xaf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe4ac4400  ! 4906: STBA_R	stba	%r18, [%r17 + %r0] 0x20
	.word 0xe487ce80  ! 4907: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r18
	.word 0xe4b74e80  ! 4908: STHA_R	stha	%r18, [%r29 + %r0] 0x74
	.word 0xeca74e80  ! 4909: STWA_R	stwa	%r22, [%r29 + %r0] 0x74
	.word 0xe0976000  ! 4910: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r16
	.word 0xe09f6000  ! 4911: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r16
	.word 0xe8adc4a0  ! 4912: STBA_R	stba	%r20, [%r23 + %r0] 0x25
	.word 0xe2d7a000  ! 4913: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r17
	mov	0x18, %r17
	mov	0x58, %r26
	.word 0xecc40400  ! 4916: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r22
	.word 0xe497ce80  ! 4917: LDUHA_R	lduha	[%r31, %r0] 0x74, %r18
	.word 0xe8bc8400  ! 4918: STDA_R	stda	%r20, [%r18 + %r0] 0x20
	.word 0xe4bf0e40  ! 4919: STDA_R	stda	%r18, [%r28 + %r0] 0x72
	mov	0x3f0, %r22
	.word 0xec97e000  ! 4921: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r22
	mov	0x68, %r27
	.word 0xecd72000  ! 4923: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r22
	.word 0xecdfe000  ! 4924: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r22
	.word 0xecdfe000  ! 4925: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r22
	mov	0x50, %r19
	.word 0xec9c4400  ! 4927: LDDA_R	ldda	[%r17, %r0] 0x20, %r22
	mov	0x38, %r18
	.word 0xecf44400  ! 4929: STXA_R	stxa	%r22, [%r17 + %r0] 0x20
	.word 0x87802073  ! 4930: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r17
	mov	0x48, %r25
	.word 0xe4970e60  ! 4933: LDUHA_R	lduha	[%r28, %r0] 0x73, %r18
	.word 0xe2b78e40  ! 4934: STHA_R	stha	%r17, [%r30 + %r0] 0x72
	.word 0xe8c42000  ! 4935: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r20
	wr_tick_cmpr_3_37:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfe, %g2
	or	%g4, 0xd5, %g4
	or	%g6, 0xc0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeeb78e60  ! 4937: STHA_R	stha	%r23, [%r30 + %r0] 0x73
	.word 0xe495c4a0  ! 4938: LDUHA_R	lduha	[%r23, %r0] 0x25, %r18
	.word 0xe8bca000  ! 4939: STDA_I	stda	%r20, [%r18 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xe0a74e60  ! 4941: STWA_R	stwa	%r16, [%r29 + %r0] 0x73
	.word 0xe8bc4400  ! 4942: STDA_R	stda	%r20, [%r17 + %r0] 0x20
	mov	0x7c8, %r23
	.word 0xe8dce000  ! 4944: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r20
	mov	0x58, %r25
	mov	0x7c0, %r22
	.word 0xe8f4a000  ! 4947: STXA_I	stxa	%r20, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 4948: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c0, %r20
	.word 0x8780204f  ! 4950: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8c46000  ! 4951: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r20
	.word 0xe8ace000  ! 4952: STBA_I	stba	%r20, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 4953: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe89d6000  ! 4954: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r20
	.word 0xe8a5a000  ! 4955: STWA_I	stwa	%r20, [%r22 + 0x0000] %asi
	.word 0xe8b5e000  ! 4956: STHA_I	stha	%r20, [%r23 + 0x0000] %asi
	.word 0xe0bc0400  ! 4957: STDA_R	stda	%r16, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 4958: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2bce000  ! 4959: STDA_I	stda	%r17, [%r19 + 0x0000] %asi
	.word 0xe2ac6000  ! 4960: STBA_I	stba	%r17, [%r17 + 0x0000] %asi
	.word 0xe6f78e60  ! 4961: STXA_R	stxa	%r19, [%r30 + %r0] 0x73
	.word 0xe496c9e0  ! 4962: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r18
	.word 0xe0dcc400  ! 4963: LDXA_R	ldxa	[%r19, %r0] 0x20, %r16
	.word 0xecb4e000  ! 4964: STHA_I	stha	%r22, [%r19 + 0x0000] %asi
	.word 0xe2f40400  ! 4965: STXA_R	stxa	%r17, [%r16 + %r0] 0x20
	.word 0xe8ac6000  ! 4966: STBA_I	stba	%r20, [%r17 + 0x0000] %asi
	.word 0xe8bce000  ! 4967: STDA_I	stda	%r20, [%r19 + 0x0000] %asi
	mov	0x8, %r27
	.word 0xe6f48400  ! 4969: STXA_R	stxa	%r19, [%r18 + %r0] 0x20
	.word 0xecde49e0  ! 4970: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r22
	.word 0xeeb4e000  ! 4971: STHA_I	stha	%r23, [%r19 + 0x0000] %asi
	.word 0xeeb4e000  ! 4972: STHA_I	stha	%r23, [%r19 + 0x0000] %asi
	mov	0x38, %r27
	mov	0x38, %r26
	.word 0xe0b48400  ! 4975: STHA_R	stha	%r16, [%r18 + %r0] 0x20
	.word 0xe496c9e0  ! 4976: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r18
	.word 0xecac6000  ! 4977: STBA_I	stba	%r22, [%r17 + 0x0000] %asi
	.word 0xeca46000  ! 4978: STWA_I	stwa	%r22, [%r17 + 0x0000] %asi
	.word 0xec94a000  ! 4979: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r22
	.word 0xecac6000  ! 4980: STBA_I	stba	%r22, [%r17 + 0x0000] %asi
	.word 0xecbca000  ! 4981: STDA_I	stda	%r22, [%r18 + 0x0000] %asi
	.word 0xecd4a000  ! 4982: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r22
	.word 0xecbca000  ! 4983: STDA_I	stda	%r22, [%r18 + 0x0000] %asi
	.word 0xecb4a000  ! 4984: STHA_I	stha	%r22, [%r18 + 0x0000] %asi
	.word 0xe29504a0  ! 4985: LDUHA_R	lduha	[%r20, %r0] 0x25, %r17
	.word 0xe8ce09e0  ! 4986: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r20
	.word 0xe6bc2000  ! 4987: STDA_I	stda	%r19, [%r16 + 0x0000] %asi
	.word 0xe6dd84a0  ! 4988: LDXA_R	ldxa	[%r22, %r0] 0x25, %r19
	.word 0xe0a504a0  ! 4989: STWA_R	stwa	%r16, [%r20 + %r0] 0x25
	.word 0xecadc4a0  ! 4990: STBA_R	stba	%r22, [%r23 + %r0] 0x25
	mov	0x20, %r19
	.word 0x87802073  ! 4992: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8b7e000  ! 4993: STHA_I	stha	%r20, [%r31 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xe09c4400  ! 4995: LDDA_R	ldda	[%r17, %r0] 0x20, %r16
	mov	0x3e8, %r20
	mov	0x60, %r17
	.word 0xe8afe000  ! 4998: STBA_I	stba	%r20, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 4999: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r26
	.word 0xe8b74e40  ! 5001: STHA_R	stha	%r20, [%r29 + %r0] 0x72
	.word 0x87802074  ! 5002: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xecbfa000  ! 5003: STDA_I	stda	%r22, [%r30 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xe2c40400  ! 5005: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r17
	.word 0x87802074  ! 5006: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r24
	.word 0xeaa7e000  ! 5008: STWA_I	stwa	%r21, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 5009: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7d8, %r22
	.word 0xeab7e000  ! 5011: STHA_I	stha	%r21, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 5012: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xea9c6000  ! 5013: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r21
	mov	0x20, %r16
	.word 0x87802020  ! 5015: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaf72000  ! 5016: STXA_I	stxa	%r21, [%r28 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xe08c8400  ! 5018: LDUBA_R	lduba	[%r18, %r0] 0x20, %r16
	.word 0xe6bec9e0  ! 5019: STDA_R	stda	%r19, [%r27 + %r0] 0x4f
	.word 0xe8b44400  ! 5020: STHA_R	stha	%r20, [%r17 + %r0] 0x20
	.word 0xeaf7a000  ! 5021: STXA_I	stxa	%r21, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 5022: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xea9c2000  ! 5023: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r21
	.word 0xeca74e60  ! 5024: STWA_R	stwa	%r22, [%r29 + %r0] 0x73
	.word 0xeaa46000  ! 5025: STWA_I	stwa	%r21, [%r17 + 0x0000] %asi
	.word 0xeac4a000  ! 5026: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r21
	.word 0x8780204f  ! 5027: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeea78e60  ! 5028: STWA_R	stwa	%r23, [%r30 + %r0] 0x73
	.word 0xee874e60  ! 5029: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r23
	.word 0xee84c400  ! 5030: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r23
	mov	0x3c8, %r23
	.word 0xe08544a0  ! 5032: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r16
	.word 0xeece09e0  ! 5033: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r23
	mov	0x38, %r16
	.word 0xeeb78e60  ! 5035: STHA_R	stha	%r23, [%r30 + %r0] 0x73
	.word 0x87802020  ! 5036: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r21
	mov	0x7c8, %r23
	.word 0xeab42000  ! 5039: STHA_I	stha	%r21, [%r16 + 0x0000] %asi
	.word 0xeadc2000  ! 5040: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r21
	.word 0xeaf4e000  ! 5041: STXA_I	stxa	%r21, [%r19 + 0x0000] %asi
	.word 0xeaf46000  ! 5042: STXA_I	stxa	%r21, [%r17 + 0x0000] %asi
	mov	0x3d0, %r22
	.word 0x87802073  ! 5044: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_3_38:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf2, %g2
	or	%g4, 0xdd, %g4
	or	%g6, 0xd0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 5046: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r24
	.word 0xeccec9e0  ! 5048: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r22
	.word 0xe4f7a000  ! 5049: STXA_I	stxa	%r18, [%r30 + 0x0000] %asi
	.word 0xe4afe000  ! 5050: STBA_I	stba	%r18, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 5051: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4d7e000  ! 5052: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r18
	mov	0x7d0, %r22
	.word 0xe2a5c4a0  ! 5054: STWA_R	stwa	%r17, [%r23 + %r0] 0x25
	.word 0xe4cc4400  ! 5055: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r18
	.word 0x87802074  ! 5056: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x28, %r18
	.word 0xec94a000  ! 5059: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r22
	.word 0x87802072  ! 5060: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r19
	.word 0xe2d70e60  ! 5062: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r17
	.word 0xecf72000  ! 5063: STXA_I	stxa	%r22, [%r28 + 0x0000] %asi
	.word 0xecb7a000  ! 5064: STHA_I	stha	%r22, [%r30 + 0x0000] %asi
	.word 0xe4bc4400  ! 5065: STDA_R	stda	%r18, [%r17 + %r0] 0x20
	.word 0x87802020  ! 5066: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r16
	.word 0xe6dc4400  ! 5068: LDXA_R	ldxa	[%r17, %r0] 0x20, %r19
	.word 0xeab46000  ! 5069: STHA_I	stha	%r21, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 5070: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xead4e000  ! 5071: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r21
	.word 0xeab42000  ! 5072: STHA_I	stha	%r21, [%r16 + 0x0000] %asi
	.word 0xeab46000  ! 5073: STHA_I	stha	%r21, [%r17 + 0x0000] %asi
	.word 0xe0b7ce80  ! 5074: STHA_R	stha	%r16, [%r31 + %r0] 0x74
	.word 0xe4974e80  ! 5075: LDUHA_R	lduha	[%r29, %r0] 0x74, %r18
	mov	0x7c8, %r22
	.word 0xeebcc400  ! 5077: STDA_R	stda	%r23, [%r19 + %r0] 0x20
	.word 0xe0f7ce60  ! 5078: STXA_R	stxa	%r16, [%r31 + %r0] 0x73
	mov	0x38, %r18
	wr_tick_cmpr_3_39:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x81, %g2
	or	%g4, 0x9e, %g4
	or	%g6, 0xa6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe2de89e0  ! 5081: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r17
	.word 0xe6f4c400  ! 5082: STXA_R	stxa	%r19, [%r19 + %r0] 0x20
	.word 0x87802073  ! 5083: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r22
	.word 0xec9c2000  ! 5085: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r22
	.word 0x87802020  ! 5086: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecb6a000  ! 5087: STHA_I	stha	%r22, [%r26 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xecf70e80  ! 5089: STXA_R	stxa	%r22, [%r28 + %r0] 0x74
	mov	0x3f0, %r20
	.word 0xeca504a0  ! 5091: STWA_R	stwa	%r22, [%r20 + %r0] 0x25
	.word 0xe4aee000  ! 5092: STBA_I	stba	%r18, [%r27 + 0x0000] %asi
	.word 0xe4a6e000  ! 5093: STWA_I	stwa	%r18, [%r27 + 0x0000] %asi
	.word 0xeabc8400  ! 5094: STDA_R	stda	%r21, [%r18 + %r0] 0x20
	.word 0xe0b44400  ! 5095: STHA_R	stha	%r16, [%r17 + %r0] 0x20
	.word 0x87802072  ! 5096: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeedd04a0  ! 5097: LDXA_R	ldxa	[%r20, %r0] 0x25, %r23
	mov	0x0, %r18
	.word 0xe6f56000  ! 5099: STXA_I	stxa	%r19, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 5100: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe69e2000  ! 5101: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r19
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xe6c6e000  ! 5103: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r19
	mov	0x48, %r19
	.word 0x87802020  ! 5105: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r23
	.word 0xe6c74e60  ! 5107: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r19
	mov	0x3e8, %r20
	.word 0x87802025  ! 5109: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeccfa000  ! 5110: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r22
	.word 0x87802020  ! 5111: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 5112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xec9ea000  ! 5113: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r22
	mov	0x3c0, %r20
	mov	0x10, %r16
	.word 0xe8a44400  ! 5116: STWA_R	stwa	%r20, [%r17 + %r0] 0x20
	.word 0xe48c0400  ! 5117: LDUBA_R	lduba	[%r16, %r0] 0x20, %r18
	.word 0x87802020  ! 5118: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r17
	.word 0xeeb7e000  ! 5120: STHA_I	stha	%r23, [%r31 + 0x0000] %asi
	.word 0xeebfe000  ! 5121: STDA_I	stda	%r23, [%r31 + 0x0000] %asi
	.word 0xe0f7ce60  ! 5122: STXA_R	stxa	%r16, [%r31 + %r0] 0x73
	mov	0x48, %r17
	.word 0xe4ac0400  ! 5124: STBA_R	stba	%r18, [%r16 + %r0] 0x20
	.word 0xecbc0400  ! 5125: STDA_R	stda	%r22, [%r16 + %r0] 0x20
	.word 0xee972000  ! 5126: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r23
	.word 0xee972000  ! 5127: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r23
	ta	T_CHANGE_HPRIV	! macro
	.word 0xeeb76000  ! 5129: STHA_I	stha	%r23, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 5130: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xea8ec9e0  ! 5131: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r21
	.word 0xee9e2000  ! 5132: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r23
	mov	0x3d0, %r21
	.word 0xeef66000  ! 5134: STXA_I	stxa	%r23, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 5135: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 5136: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeecc8400  ! 5137: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r23
	.word 0xeec689e0  ! 5138: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r23
	.word 0xe6f48400  ! 5139: STXA_R	stxa	%r19, [%r18 + %r0] 0x20
	.word 0xe6b5e000  ! 5140: STHA_I	stha	%r19, [%r23 + 0x0000] %asi
	.word 0xe6f52000  ! 5141: STXA_I	stxa	%r19, [%r20 + 0x0000] %asi
	.word 0xe6ada000  ! 5142: STBA_I	stba	%r19, [%r22 + 0x0000] %asi
	.word 0xe6a5e000  ! 5143: STWA_I	stwa	%r19, [%r23 + 0x0000] %asi
	mov	0x10, %r19
	.word 0xe6c5e000  ! 5145: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r19
	.word 0xe0d504a0  ! 5146: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r16
	mov	0x78, %r26
	.word 0x87802025  ! 5148: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r25
	.word 0xe0bfe000  ! 5150: STDA_I	stda	%r16, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 5151: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r23
	.word 0xeaa44400  ! 5153: STWA_R	stwa	%r21, [%r17 + %r0] 0x20
	.word 0xead76000  ! 5154: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r21
	mov	0x3c0, %r23
	mov	0x3d0, %r22
	mov	0x8, %r16
	mov	0x10, %r27
	mov	0x48, %r25
	.word 0xeadf6000  ! 5160: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r21
	.word 0xeeaf0e80  ! 5161: STBA_R	stba	%r23, [%r28 + %r0] 0x74
	.word 0xe0ae89e0  ! 5162: STBA_R	stba	%r16, [%r26 + %r0] 0x4f
	.word 0xeea7a000  ! 5163: STWA_I	stwa	%r23, [%r30 + 0x0000] %asi
	mov	0x48, %r24
	.word 0xe6d689e0  ! 5165: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r19
	.word 0xecd609e0  ! 5166: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r22
	.word 0xeacfe000  ! 5167: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r21
	mov	0x20, %r19
	.word 0x87802020  ! 5169: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea962000  ! 5170: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r21
	.word 0xeadee000  ! 5171: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r21
	mov	0x50, %r19
	.word 0xe6bfce60  ! 5173: STDA_R	stda	%r19, [%r31 + %r0] 0x73
	mov	0x28, %r25
	.word 0xe6b66000  ! 5175: STHA_I	stha	%r19, [%r25 + 0x0000] %asi
	.word 0xea9f0e40  ! 5176: LDDA_R	ldda	[%r28, %r0] 0x72, %r21
	.word 0x87802073  ! 5177: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e8, %r20
	.word 0x8780204f  ! 5179: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6dea000  ! 5180: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r19
	.word 0xe6af4e60  ! 5181: STBA_R	stba	%r19, [%r29 + %r0] 0x73
	.word 0xeab40400  ! 5182: STHA_R	stha	%r21, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 5183: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xec9f6000  ! 5184: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r22
	.word 0xe4cf0e80  ! 5185: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r18
	.word 0xec8fa000  ! 5186: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r22
	mov	0x0, %r26
	mov	0x10, %r18
	.word 0xeaadc4a0  ! 5189: STBA_R	stba	%r21, [%r23 + %r0] 0x25
	mov	0x8, %r19
	.word 0xeca7e000  ! 5191: STWA_I	stwa	%r22, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 5192: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 5193: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xea874e60  ! 5194: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r21
	.word 0xe2d7a000  ! 5195: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r17
	.word 0xecf78e40  ! 5196: STXA_R	stxa	%r22, [%r30 + %r0] 0x72
	.word 0xe2d70e60  ! 5197: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r17
	.word 0xe6f7a000  ! 5198: STXA_I	stxa	%r19, [%r30 + 0x0000] %asi
	.word 0xe0be49e0  ! 5199: STDA_R	stda	%r16, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 5200: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 5201: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeea70e60  ! 5202: STWA_R	stwa	%r23, [%r28 + %r0] 0x73
	mov	0x60, %r25
	.word 0xe8b76000  ! 5204: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	.word 0xe8d7e000  ! 5205: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r20
	.word 0xe8cfe000  ! 5206: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r20
	.word 0xeeb40400  ! 5207: STHA_R	stha	%r23, [%r16 + %r0] 0x20
	.word 0xecb74e40  ! 5208: STHA_R	stha	%r22, [%r29 + %r0] 0x72
	.word 0xe8dfa000  ! 5209: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r20
	.word 0xe8b76000  ! 5210: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	mov	0x60, %r24
	.word 0xe8f76000  ! 5212: STXA_I	stxa	%r20, [%r29 + 0x0000] %asi
	mov	0x20, %r19
	.word 0x87802074  ! 5214: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2940400  ! 5215: LDUHA_R	lduha	[%r16, %r0] 0x20, %r17
	.word 0xe6a4c400  ! 5216: STWA_R	stwa	%r19, [%r19 + %r0] 0x20
	mov	0x28, %r17
	.word 0xe8cf0e80  ! 5218: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r20
	.word 0xeabca000  ! 5219: STDA_I	stda	%r21, [%r18 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xeaf46000  ! 5221: STXA_I	stxa	%r21, [%r17 + 0x0000] %asi
	.word 0xea942000  ! 5222: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r21
	.word 0xeaf42000  ! 5223: STXA_I	stxa	%r21, [%r16 + 0x0000] %asi
	.word 0xecb74e60  ! 5224: STHA_R	stha	%r22, [%r29 + %r0] 0x73
	.word 0xe8a46000  ! 5225: STWA_I	stwa	%r20, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 5226: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r19
	.word 0xeabfce60  ! 5228: STDA_R	stda	%r21, [%r31 + %r0] 0x73
	.word 0x87802020  ! 5229: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaa72000  ! 5230: STWA_I	stwa	%r21, [%r28 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xeca74e40  ! 5232: STWA_R	stwa	%r22, [%r29 + %r0] 0x72
	.word 0xe687e000  ! 5233: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r19
	.word 0xe6b7a000  ! 5234: STHA_I	stha	%r19, [%r30 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xe0be09e0  ! 5236: STDA_R	stda	%r16, [%r24 + %r0] 0x4f
	.word 0xe6a7e000  ! 5237: STWA_I	stwa	%r19, [%r31 + 0x0000] %asi
	mov	0x48, %r18
	mov	0x60, %r18
	mov	0x7c0, %r23
	.word 0xeaac8400  ! 5241: STBA_R	stba	%r21, [%r18 + %r0] 0x20
	.word 0xe8b78e80  ! 5242: STHA_R	stha	%r20, [%r30 + %r0] 0x74
	mov	0x3f0, %r21
	mov	0x10, %r27
	.word 0xe2940400  ! 5245: LDUHA_R	lduha	[%r16, %r0] 0x20, %r17
	mov	0x60, %r16
	.word 0xe2d72000  ! 5247: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r17
	.word 0xe2f76000  ! 5248: STXA_I	stxa	%r17, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 5249: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 5250: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r23
	.word 0xe2df2000  ! 5252: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r17
	.word 0x8780204f  ! 5253: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2b4a000  ! 5254: STHA_I	stha	%r17, [%r18 + 0x0000] %asi
	.word 0xe2a4a000  ! 5255: STWA_I	stwa	%r17, [%r18 + 0x0000] %asi
	mov	0x7f8, %r21
	mov	0x10, %r18
	.word 0x87802073  ! 5258: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe285e000  ! 5259: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r17
	mov	0x7f0, %r20
	.word 0x87802025  ! 5261: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xec9f8e40  ! 5262: LDDA_R	ldda	[%r30, %r0] 0x72, %r22
	.word 0x87802072  ! 5263: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r23
	mov	0x18, %r17
	.word 0xeaf72000  ! 5266: STXA_I	stxa	%r21, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 5267: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xea8f6000  ! 5268: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r21
	mov	0x68, %r24
	.word 0x87802073  ! 5270: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xecbf8e40  ! 5271: STDA_R	stda	%r22, [%r30 + %r0] 0x72
	.word 0xeedf4e80  ! 5272: LDXA_R	ldxa	[%r29, %r0] 0x74, %r23
	.word 0xe8df2000  ! 5273: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r20
	.word 0x8780204f  ! 5274: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r17
	.word 0x87802020  ! 5276: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe28d84a0  ! 5277: LDUBA_R	lduba	[%r22, %r0] 0x25, %r17
	.word 0xecc76000  ! 5278: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0xe4af8e80  ! 5279: STBA_R	stba	%r18, [%r30 + %r0] 0x74
	.word 0x87802020  ! 5280: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r21
	mov	0x7f0, %r23
	.word 0xe8b76000  ! 5283: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	.word 0xe8c7a000  ! 5284: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r20
	.word 0xee86c9e0  ! 5285: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r23
	.word 0x87802074  ! 5286: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4d6c9e0  ! 5287: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r18
	.word 0xeca56000  ! 5288: STWA_I	stwa	%r22, [%r21 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xe08d04a0  ! 5290: LDUBA_R	lduba	[%r20, %r0] 0x25, %r16
	.word 0xeab56000  ! 5291: STHA_I	stha	%r21, [%r21 + 0x0000] %asi
	.word 0xeabd2000  ! 5292: STDA_I	stda	%r21, [%r20 + 0x0000] %asi
	.word 0xe0a40400  ! 5293: STWA_R	stwa	%r16, [%r16 + %r0] 0x20
	.word 0xe2cd2000  ! 5294: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r17
	mov	0x10, %r17
	.word 0xecadc4a0  ! 5296: STBA_R	stba	%r22, [%r23 + %r0] 0x25
	.word 0x87802025  ! 5297: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r19
	mov	0x3f0, %r20
	mov	0x7f0, %r20
	.word 0xe2b66000  ! 5301: STHA_I	stha	%r17, [%r25 + 0x0000] %asi
	.word 0xee87ce40  ! 5302: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r23
	mov	0x38, %r26
	.word 0xe4ae2000  ! 5304: STBA_I	stba	%r18, [%r24 + 0x0000] %asi
	.word 0xeea78e40  ! 5305: STWA_R	stwa	%r23, [%r30 + %r0] 0x72
	.word 0xe8a6e000  ! 5306: STWA_I	stwa	%r20, [%r27 + 0x0000] %asi
	.word 0xe8c66000  ! 5307: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r20
	.word 0xec8e09e0  ! 5308: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r22
	mov	0x28, %r26
	.word 0xe6a5c4a0  ! 5310: STWA_R	stwa	%r19, [%r23 + %r0] 0x25
	.word 0xe0be6000  ! 5311: STDA_I	stda	%r16, [%r25 + 0x0000] %asi
	.word 0xe09e2000  ! 5312: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r16
	.word 0xe2df8e40  ! 5313: LDXA_R	ldxa	[%r30, %r0] 0x72, %r17
	.word 0xe8a44400  ! 5314: STWA_R	stwa	%r20, [%r17 + %r0] 0x20
	mov	0x3e8, %r23
	.word 0xeaccc400  ! 5316: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r21
	.word 0xeea7ce60  ! 5317: STWA_R	stwa	%r23, [%r31 + %r0] 0x73
	.word 0xeaaea000  ! 5318: STBA_I	stba	%r21, [%r26 + 0x0000] %asi
	.word 0xe8cd84a0  ! 5319: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r20
	.word 0xe2ce2000  ! 5320: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r17
	.word 0xe2d6a000  ! 5321: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r17
	.word 0x87802020  ! 5322: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	.word 0xe287e000  ! 5324: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r17
	.word 0xe0afce80  ! 5325: STBA_R	stba	%r16, [%r31 + %r0] 0x74
	.word 0xe6a76000  ! 5326: STWA_I	stwa	%r19, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 5327: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 5328: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 5329: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 5330: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe68e6000  ! 5331: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r19
	.word 0xe6a62000  ! 5332: STWA_I	stwa	%r19, [%r24 + 0x0000] %asi
	.word 0xea9fce60  ! 5333: LDDA_R	ldda	[%r31, %r0] 0x73, %r21
	.word 0xe89e09e0  ! 5334: LDDA_R	ldda	[%r24, %r0] 0x4f, %r20
	.word 0xe6c44400  ! 5335: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r19
	.word 0xe8d6a000  ! 5336: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r20
	.word 0xe8d6e000  ! 5337: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r20
	.word 0x8780204f  ! 5338: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r23
	mov	0x78, %r16
	.word 0x87802020  ! 5341: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8ce6000  ! 5342: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r20
	mov	0x8, %r19
	.word 0xe8aee000  ! 5344: STBA_I	stba	%r20, [%r27 + 0x0000] %asi
	.word 0xe8ae2000  ! 5345: STBA_I	stba	%r20, [%r24 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xe8c6a000  ! 5347: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r20
	.word 0xe896a000  ! 5348: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r20
	.word 0xe8d5c4a0  ! 5349: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r20
	.word 0xe6978e60  ! 5350: LDUHA_R	lduha	[%r30, %r0] 0x73, %r19
	.word 0xea96e000  ! 5351: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r21
	.word 0xe4978e80  ! 5352: LDUHA_R	lduha	[%r30, %r0] 0x74, %r18
	.word 0xe8df4e80  ! 5353: LDXA_R	ldxa	[%r29, %r0] 0x74, %r20
	.word 0xe6f4c400  ! 5354: STXA_R	stxa	%r19, [%r19 + %r0] 0x20
	mov	0x3c8, %r21
	mov	0x70, %r25
	.word 0xea9d84a0  ! 5357: LDDA_R	ldda	[%r22, %r0] 0x25, %r21
	.word 0x87802072  ! 5358: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 5359: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecace000  ! 5360: STBA_I	stba	%r22, [%r19 + 0x0000] %asi
	.word 0xe484c400  ! 5361: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r18
	.word 0xe2cec9e0  ! 5362: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r17
	.word 0xe084e000  ! 5363: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r16
	.word 0xe0f4e000  ! 5364: STXA_I	stxa	%r16, [%r19 + 0x0000] %asi
	.word 0xe0948400  ! 5365: LDUHA_R	lduha	[%r18, %r0] 0x20, %r16
	.word 0x87802072  ! 5366: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xea9609e0  ! 5367: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r21
	.word 0xe4f7ce40  ! 5368: STXA_R	stxa	%r18, [%r31 + %r0] 0x72
	.word 0x87802072  ! 5369: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xec978e40  ! 5370: LDUHA_R	lduha	[%r30, %r0] 0x72, %r22
	mov	0x70, %r17
	.word 0xe4c4a000  ! 5372: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r18
	.word 0x8780204f  ! 5373: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecf70e80  ! 5374: STXA_R	stxa	%r22, [%r28 + %r0] 0x74
	wr_tick_cmpr_3_40:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbe, %g2
	or	%g4, 0xb9, %g4
	or	%g6, 0xd4, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 5376: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r19
	mov	0x18, %r19
	.word 0xe0dc6000  ! 5379: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r16
	.word 0x87802020  ! 5380: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 5381: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0af8e40  ! 5382: STBA_R	stba	%r16, [%r30 + %r0] 0x72
	.word 0xeea74e60  ! 5383: STWA_R	stwa	%r23, [%r29 + %r0] 0x73
	.word 0xeabe89e0  ! 5384: STDA_R	stda	%r21, [%r26 + %r0] 0x4f
	.word 0xec8dc4a0  ! 5385: LDUBA_R	lduba	[%r23, %r0] 0x25, %r22
	wr_tick_cmpr_3_41:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd9, %g2
	or	%g4, 0xad, %g4
	or	%g6, 0xb6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802074  ! 5387: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 5388: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6cc2000  ! 5389: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r19
	mov	0x60, %r24
	.word 0x87802020  ! 5391: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	.word 0x87802020  ! 5393: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6c4e000  ! 5394: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r19
	.word 0x87802020  ! 5395: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8970e40  ! 5396: LDUHA_R	lduha	[%r28, %r0] 0x72, %r20
	.word 0xeeae6000  ! 5397: STBA_I	stba	%r23, [%r25 + 0x0000] %asi
	.word 0xeecea000  ! 5398: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r23
	mov	0x28, %r26
	.word 0x87802072  ! 5400: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r21
	wr_tick_cmpr_3_42:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xd6, %g2
	or	%g4, 0xc1, %g4
	or	%g6, 0xaf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xee96a000  ! 5403: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r23
	.word 0x87802025  ! 5404: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r18
	.word 0xeec56000  ! 5406: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r23
	.word 0xeebda000  ! 5407: STDA_I	stda	%r23, [%r22 + 0x0000] %asi
	mov	0x40, %r19
	.word 0x8780204f  ! 5409: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeed76000  ! 5410: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r23
	.word 0xeed7e000  ! 5411: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r23
	.word 0xe2a544a0  ! 5412: STWA_R	stwa	%r17, [%r21 + %r0] 0x25
	.word 0xe8b689e0  ! 5413: STHA_R	stha	%r20, [%r26 + %r0] 0x4f
	mov	0x48, %r17
	.word 0xe6f76000  ! 5415: STXA_I	stxa	%r19, [%r29 + 0x0000] %asi
	.word 0xe6d76000  ! 5416: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r19
	.word 0xeccc4400  ! 5417: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r22
	mov	0x70, %r18
	mov	0x58, %r24
	.word 0xe4b7a000  ! 5420: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	mov	0x58, %r19
	.word 0xe4bf2000  ! 5422: STDA_I	stda	%r18, [%r28 + 0x0000] %asi
	.word 0xeeb609e0  ! 5423: STHA_R	stha	%r23, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 5424: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4a72000  ! 5425: STWA_I	stwa	%r18, [%r28 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xe4afe000  ! 5427: STBA_I	stba	%r18, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 5428: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4866000  ! 5429: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r18
	.word 0xe6cf0e40  ! 5430: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r19
	mov	0x7e8, %r21
	mov	0x20, %r27
	.word 0xeeb48400  ! 5433: STHA_R	stha	%r23, [%r18 + %r0] 0x20
	mov	0x20, %r25
	.word 0xec97ce40  ! 5435: LDUHA_R	lduha	[%r31, %r0] 0x72, %r22
	.word 0xe6ac0400  ! 5436: STBA_R	stba	%r19, [%r16 + %r0] 0x20
	.word 0xe6a504a0  ! 5437: STWA_R	stwa	%r19, [%r20 + %r0] 0x25
	.word 0xe88e49e0  ! 5438: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r20
	.word 0xeedea000  ! 5439: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r23
	.word 0xe49dc4a0  ! 5440: LDDA_R	ldda	[%r23, %r0] 0x25, %r18
	mov	0x3c0, %r23
	.word 0x87802020  ! 5442: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	.word 0x87802020  ! 5444: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 5445: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r18
	.word 0xe0f40400  ! 5447: STXA_R	stxa	%r16, [%r16 + %r0] 0x20
	.word 0x87802020  ! 5448: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 5449: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6f78e60  ! 5450: STXA_R	stxa	%r19, [%r30 + %r0] 0x73
	mov	0x3e8, %r22
	mov	0x3f8, %r20
	mov	0x3d8, %r22
	.word 0xe8a5e000  ! 5454: STWA_I	stwa	%r20, [%r23 + 0x0000] %asi
	.word 0xea87ce60  ! 5455: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r21
	.word 0x87802025  ! 5456: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0afa000  ! 5457: STBA_I	stba	%r16, [%r30 + 0x0000] %asi
	.word 0xe0f76000  ! 5458: STXA_I	stxa	%r16, [%r29 + 0x0000] %asi
	mov	0x3c8, %r21
	.word 0xe0b7e000  ! 5460: STHA_I	stha	%r16, [%r31 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xe8940400  ! 5462: LDUHA_R	lduha	[%r16, %r0] 0x20, %r20
	.word 0xeed76000  ! 5463: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r23
	.word 0xeed76000  ! 5464: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r23
	.word 0xe6cf8e80  ! 5465: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r19
	.word 0xecbf8e40  ! 5466: STDA_R	stda	%r22, [%r30 + %r0] 0x72
	.word 0xe4bdc4a0  ! 5467: STDA_R	stda	%r18, [%r23 + %r0] 0x25
	.word 0xe6976000  ! 5468: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r19
	.word 0xe6976000  ! 5469: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r19
	.word 0xe6b72000  ! 5470: STHA_I	stha	%r19, [%r28 + 0x0000] %asi
	.word 0xe68f2000  ! 5471: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r19
	.word 0xe69f2000  ! 5472: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r19
	.word 0xe6c72000  ! 5473: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r19
	.word 0xecb48400  ! 5474: STHA_R	stha	%r22, [%r18 + %r0] 0x20
	.word 0xe0cd44a0  ! 5475: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r16
	.word 0xe4f44400  ! 5476: STXA_R	stxa	%r18, [%r17 + %r0] 0x20
	.word 0xeeb76000  ! 5477: STHA_I	stha	%r23, [%r29 + 0x0000] %asi
	.word 0xeeaf0e40  ! 5478: STBA_R	stba	%r23, [%r28 + %r0] 0x72
	.word 0xe0af2000  ! 5479: STBA_I	stba	%r16, [%r28 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xe0af6000  ! 5481: STBA_I	stba	%r16, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 5482: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r26
	.word 0xe0b72000  ! 5484: STHA_I	stha	%r16, [%r28 + 0x0000] %asi
	wr_tick_cmpr_3_43:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xb3, %g2
	or	%g4, 0xbd, %g4
	or	%g6, 0x89, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe087e000  ! 5486: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r16
	.word 0xe2ac4400  ! 5487: STBA_R	stba	%r17, [%r17 + %r0] 0x20
	.word 0xe8bf6000  ! 5488: STDA_I	stda	%r20, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 5489: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeedcc400  ! 5490: LDXA_R	ldxa	[%r19, %r0] 0x20, %r23
	.word 0xeca649e0  ! 5491: STWA_R	stwa	%r22, [%r25 + %r0] 0x4f
	mov	0x28, %r19
	.word 0xeaaea000  ! 5493: STBA_I	stba	%r21, [%r26 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xeade2000  ! 5495: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r21
	.word 0x8780204f  ! 5496: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6cf8e60  ! 5497: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r19
	mov	0x7d0, %r22
	.word 0xee9fce40  ! 5499: LDDA_R	ldda	[%r31, %r0] 0x72, %r23
	.word 0x87802072  ! 5500: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r23
	.word 0x87802020  ! 5502: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8b42000  ! 5503: STHA_I	stha	%r20, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 5504: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0b40400  ! 5505: STHA_R	stha	%r16, [%r16 + %r0] 0x20
	mov	0x0, %r17
	.word 0xe8afa000  ! 5507: STBA_I	stba	%r20, [%r30 + 0x0000] %asi
	wr_tick_cmpr_3_44:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x94, %g2
	or	%g4, 0xcd, %g4
	or	%g6, 0xa3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 5509: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe88ca000  ! 5510: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r20
	.word 0x87802020  ! 5511: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe8afa000  ! 5513: STBA_I	stba	%r20, [%r30 + 0x0000] %asi
	.word 0xe8b72000  ! 5514: STHA_I	stha	%r20, [%r28 + 0x0000] %asi
	.word 0xead5c4a0  ! 5515: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r21
	.word 0x87802020  ! 5516: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2dc8400  ! 5517: LDXA_R	ldxa	[%r18, %r0] 0x20, %r17
	mov	0x7e8, %r22
	.word 0xeaa48400  ! 5519: STWA_R	stwa	%r21, [%r18 + %r0] 0x20
	.word 0xe08f2000  ! 5520: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r16
	.word 0x87802072  ! 5521: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeacf0e60  ! 5522: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r21
	.word 0xe6f4c400  ! 5523: STXA_R	stxa	%r19, [%r19 + %r0] 0x20
	.word 0xe4ae89e0  ! 5524: STBA_R	stba	%r18, [%r26 + %r0] 0x4f
	.word 0xe8d7e000  ! 5525: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r20
	.word 0x87802073  ! 5526: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe887a000  ! 5527: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r20
	.word 0xe4d78e40  ! 5528: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r18
	.word 0x8780204f  ! 5529: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe08c8400  ! 5530: LDUBA_R	lduba	[%r18, %r0] 0x20, %r16
	.word 0xe6944400  ! 5531: LDUHA_R	lduha	[%r17, %r0] 0x20, %r19
	.word 0xe2c42000  ! 5532: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r17
	.word 0xe2d42000  ! 5533: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r17
	.word 0xe294a000  ! 5534: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r17
	mov	0x30, %r18
	.word 0xeeb689e0  ! 5536: STHA_R	stha	%r23, [%r26 + %r0] 0x4f
	.word 0xeaf42000  ! 5537: STXA_I	stxa	%r21, [%r16 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xeebf0e80  ! 5539: STDA_R	stda	%r23, [%r28 + %r0] 0x74
	.word 0xe0874e40  ! 5540: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r16
	.word 0x87802073  ! 5541: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 5542: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0b52000  ! 5543: STHA_I	stha	%r16, [%r20 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xe0d56000  ! 5545: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r16
	.word 0xe2cf8e40  ! 5546: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r17
	.word 0xe6f52000  ! 5547: STXA_I	stxa	%r19, [%r20 + 0x0000] %asi
	.word 0xe6c5e000  ! 5548: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r19
	.word 0x87802025  ! 5549: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6d7ce80  ! 5550: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r19
	.word 0x87802020  ! 5551: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r26
	.word 0xe6c609e0  ! 5553: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r19
	mov	0x68, %r19
	wr_tick_cmpr_3_45:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa5, %g2
	or	%g4, 0xda, %g4
	or	%g6, 0xf0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe2f4a000  ! 5556: STXA_I	stxa	%r17, [%r18 + 0x0000] %asi
	.word 0xe4c48400  ! 5557: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r18
	.word 0xe2a4e000  ! 5558: STWA_I	stwa	%r17, [%r19 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe8a44400  ! 5560: STWA_R	stwa	%r20, [%r17 + %r0] 0x20
	mov	0x10, %r16
	.word 0x87802020  ! 5562: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 5563: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8f78e60  ! 5564: STXA_R	stxa	%r20, [%r30 + %r0] 0x73
	.word 0xeeb70e80  ! 5565: STHA_R	stha	%r23, [%r28 + %r0] 0x74
	.word 0xe2df2000  ! 5566: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r17
	.word 0x87802072  ! 5567: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8dcc400  ! 5568: LDXA_R	ldxa	[%r19, %r0] 0x20, %r20
	mov	0x40, %r25
	.word 0xec8689e0  ! 5570: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r22
	.word 0x8780204f  ! 5571: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r27
	.word 0xe4df2000  ! 5573: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r18
	.word 0xeadd84a0  ! 5574: LDXA_R	ldxa	[%r22, %r0] 0x25, %r21
	.word 0xe6df6000  ! 5575: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r19
	mov	0x68, %r27
	.word 0xe6b76000  ! 5577: STHA_I	stha	%r19, [%r29 + 0x0000] %asi
	.word 0xe0f78e60  ! 5578: STXA_R	stxa	%r16, [%r30 + %r0] 0x73
	mov	0x78, %r16
	.word 0xeccfe000  ! 5580: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r22
	.word 0xeca72000  ! 5581: STWA_I	stwa	%r22, [%r28 + 0x0000] %asi
	.word 0xeca72000  ! 5582: STWA_I	stwa	%r22, [%r28 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xec96c9e0  ! 5584: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r22
	.word 0xecf4c400  ! 5585: STXA_R	stxa	%r22, [%r19 + %r0] 0x20
	.word 0xe4af2000  ! 5586: STBA_I	stba	%r18, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 5587: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r27
	.word 0xeac40400  ! 5589: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r21
	mov	0x3c8, %r22
	mov	0x28, %r16
	.word 0xeeb44400  ! 5592: STHA_R	stha	%r23, [%r17 + %r0] 0x20
	mov	0x38, %r27
	.word 0xeeb70e60  ! 5594: STHA_R	stha	%r23, [%r28 + %r0] 0x73
	.word 0xe4ae89e0  ! 5595: STBA_R	stba	%r18, [%r26 + %r0] 0x4f
	mov	0x50, %r16
	.word 0xeacd44a0  ! 5597: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r21
	.word 0xe6f4c400  ! 5598: STXA_R	stxa	%r19, [%r19 + %r0] 0x20
	.word 0xe8d40400  ! 5599: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r20
	.word 0xe6b504a0  ! 5600: STHA_R	stha	%r19, [%r20 + %r0] 0x25
	mov	0x7c8, %r21
	mov	0x10, %r26
	.word 0xe8a52000  ! 5603: STWA_I	stwa	%r20, [%r20 + 0x0000] %asi
	.word 0xe88d6000  ! 5604: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r20
	mov	0x3f8, %r20
	.word 0xec95c4a0  ! 5606: LDUHA_R	lduha	[%r23, %r0] 0x25, %r22
	.word 0xe8f52000  ! 5607: STXA_I	stxa	%r20, [%r20 + 0x0000] %asi
	.word 0xe08e49e0  ! 5608: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r16
	.word 0xe8a5e000  ! 5609: STWA_I	stwa	%r20, [%r23 + 0x0000] %asi
	.word 0xe8d56000  ! 5610: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r20
	mov	0x30, %r16
	.word 0xe4d609e0  ! 5612: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r18
	.word 0xe6d4c400  ! 5613: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r19
	.word 0xe2c44400  ! 5614: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r17
	.word 0xe8ad6000  ! 5615: STBA_I	stba	%r20, [%r21 + 0x0000] %asi
	.word 0xe8a56000  ! 5616: STWA_I	stwa	%r20, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 5617: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8966000  ! 5618: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r20
	.word 0xe8cea000  ! 5619: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r20
	.word 0x87802025  ! 5620: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0bf4e80  ! 5621: STDA_R	stda	%r16, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 5622: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecbc4400  ! 5623: STDA_R	stda	%r22, [%r17 + %r0] 0x20
	.word 0xee9c8400  ! 5624: LDDA_R	ldda	[%r18, %r0] 0x20, %r23
	.word 0xeebcc400  ! 5625: STDA_R	stda	%r23, [%r19 + %r0] 0x20
	.word 0xe8ac4400  ! 5626: STBA_R	stba	%r20, [%r17 + %r0] 0x20
	mov	0x40, %r27
	.word 0xe0bdc4a0  ! 5628: STDA_R	stda	%r16, [%r23 + %r0] 0x25
	.word 0xe2a52000  ! 5629: STWA_I	stwa	%r17, [%r20 + 0x0000] %asi
	.word 0xe2b5e000  ! 5630: STHA_I	stha	%r17, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 5631: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r20
	.word 0xe28c0400  ! 5633: LDUBA_R	lduba	[%r16, %r0] 0x20, %r17
	.word 0xe0de6000  ! 5634: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r16
	.word 0xe2f4c400  ! 5635: STXA_R	stxa	%r17, [%r19 + %r0] 0x20
	.word 0xe0c70e60  ! 5636: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r16
	mov	0x70, %r27
	mov	0x78, %r17
	.word 0x87802020  ! 5639: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	mov	0x3c8, %r23
	mov	0x40, %r16
	.word 0xec97ce60  ! 5643: LDUHA_R	lduha	[%r31, %r0] 0x73, %r22
	.word 0x8780204f  ! 5644: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r26
	.word 0xeac7ce60  ! 5646: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r21
	.word 0xe2f6a000  ! 5647: STXA_I	stxa	%r17, [%r26 + 0x0000] %asi
	.word 0xe4a609e0  ! 5648: STWA_R	stwa	%r18, [%r24 + %r0] 0x4f
	.word 0xee8609e0  ! 5649: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r23
	.word 0xe6c6e000  ! 5650: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r19
	mov	0x40, %r27
	.word 0xecdf8e40  ! 5652: LDXA_R	ldxa	[%r30, %r0] 0x72, %r22
	mov	0x8, %r19
	.word 0xec870e80  ! 5654: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r22
	mov	0x40, %r19
	mov	0x48, %r19
	mov	0x3e8, %r23
	ta	T_CHANGE_HPRIV	! macro
	.word 0xe2f6a000  ! 5659: STXA_I	stxa	%r17, [%r26 + 0x0000] %asi
	.word 0xe2d6e000  ! 5660: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r17
	.word 0xe4974e80  ! 5661: LDUHA_R	lduha	[%r29, %r0] 0x74, %r18
	mov	0x8, %r24
	.word 0x87802020  ! 5663: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 5664: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r16
	wr_tick_cmpr_3_46:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xe5, %g2
	or	%g4, 0xb9, %g4
	or	%g6, 0xaa, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x28, %r17
	.word 0xee842000  ! 5668: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r23
	mov	0x7c0, %r20
	.word 0xee9c6000  ! 5670: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r23
	.word 0x87802020  ! 5671: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeed76000  ! 5672: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r23
	.word 0x87802020  ! 5673: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	mov	0x10, %r25
	.word 0xeecf2000  ! 5676: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r23
	.word 0xecb584a0  ! 5677: STHA_R	stha	%r22, [%r22 + %r0] 0x25
	.word 0xeab70e80  ! 5678: STHA_R	stha	%r21, [%r28 + %r0] 0x74
	.word 0x87802072  ! 5679: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2bc2000  ! 5680: STDA_I	stda	%r17, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 5681: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe284e000  ! 5682: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r17
	.word 0x8780204f  ! 5683: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeea7ce40  ! 5684: STWA_R	stwa	%r23, [%r31 + %r0] 0x72
	.word 0x87802025  ! 5685: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r21
	.word 0x87802072  ! 5687: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 5688: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2b42000  ! 5689: STHA_I	stha	%r17, [%r16 + 0x0000] %asi
	.word 0xe08f0e80  ! 5690: LDUBA_R	lduba	[%r28, %r0] 0x74, %r16
	.word 0x87802025  ! 5691: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeea42000  ! 5692: STWA_I	stwa	%r23, [%r16 + 0x0000] %asi
	.word 0xe49cc400  ! 5693: LDDA_R	ldda	[%r19, %r0] 0x20, %r18
	mov	0x3e0, %r22
	.word 0xecf70e60  ! 5695: STXA_R	stxa	%r22, [%r28 + %r0] 0x73
	.word 0x87802072  ! 5696: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r16
	.word 0x87802072  ! 5698: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r25
	mov	0x30, %r24
	mov	0x3d0, %r22
	mov	0x38, %r17
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xeed7e000  ! 5704: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r23
	mov	0x30, %r26
	.word 0xecf4c400  ! 5706: STXA_R	stxa	%r22, [%r19 + %r0] 0x20
	.word 0xe08609e0  ! 5707: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r16
	mov	0x60, %r17
	.word 0xea9fe000  ! 5709: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r21
	.word 0xea872000  ! 5710: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r21
	.word 0x87802073  ! 5711: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3d8, %r22
	.word 0xe6978e60  ! 5713: LDUHA_R	lduha	[%r30, %r0] 0x73, %r19
	mov	0x7c0, %r21
	wr_tick_cmpr_3_47:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xdd, %g2
	or	%g4, 0xa1, %g4
	or	%g6, 0xdd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x58, %r27
	.word 0xe29d2000  ! 5717: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r17
	.word 0xea9cc400  ! 5718: LDDA_R	ldda	[%r19, %r0] 0x20, %r21
	mov	0x7d8, %r21
	.word 0xec9de000  ! 5720: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r22
	.word 0xeca52000  ! 5721: STWA_I	stwa	%r22, [%r20 + 0x0000] %asi
	mov	0x8, %r17
	.word 0xe68e89e0  ! 5723: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r19
	mov	0x18, %r24
	.word 0xe8b52000  ! 5725: STHA_I	stha	%r20, [%r20 + 0x0000] %asi
	.word 0xe8b56000  ! 5726: STHA_I	stha	%r20, [%r21 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xea9cc400  ! 5728: LDDA_R	ldda	[%r19, %r0] 0x20, %r21
	.word 0xe2f5a000  ! 5729: STXA_I	stxa	%r17, [%r22 + 0x0000] %asi
	mov	0x78, %r19
	mov	0x0, %r16
	mov	0x48, %r24
	.word 0xe4ce49e0  ! 5733: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r18
	.word 0xe8cf4e80  ! 5734: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r20
	mov	0x8, %r17
	mov	0x38, %r25
	.word 0xead44400  ! 5737: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r21
	.word 0xec85a000  ! 5738: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r22
	.word 0x87802020  ! 5739: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecd4e000  ! 5740: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r22
	.word 0xe29c4400  ! 5741: LDDA_R	ldda	[%r17, %r0] 0x20, %r17
	.word 0xe4bf4e80  ! 5742: STDA_R	stda	%r18, [%r29 + %r0] 0x74
	.word 0xeef504a0  ! 5743: STXA_R	stxa	%r23, [%r20 + %r0] 0x25
	.word 0xe2a4a000  ! 5744: STWA_I	stwa	%r17, [%r18 + 0x0000] %asi
	mov	0x58, %r26
	.word 0x87802072  ! 5746: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2d46000  ! 5747: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r17
	mov	0x0, %r24
	.word 0x87802073  ! 5749: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 5750: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe28ce000  ! 5751: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r17
	.word 0xe0f504a0  ! 5752: STXA_R	stxa	%r16, [%r20 + %r0] 0x25
	mov	0x8, %r26
	.word 0xe0b4a000  ! 5754: STHA_I	stha	%r16, [%r18 + 0x0000] %asi
	.word 0xe6af0e80  ! 5755: STBA_R	stba	%r19, [%r28 + %r0] 0x74
	.word 0xeadca000  ! 5756: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r21
	.word 0xeabf0e80  ! 5757: STDA_R	stda	%r21, [%r28 + %r0] 0x74
	.word 0xe8b74e80  ! 5758: STHA_R	stha	%r20, [%r29 + %r0] 0x74
	.word 0xe8af0e60  ! 5759: STBA_R	stba	%r20, [%r28 + %r0] 0x73
	.word 0x87802074  ! 5760: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r24
	.word 0xe8cfce60  ! 5762: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r20
	.word 0xeec7e000  ! 5763: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r23
	.word 0xec8c8400  ! 5764: LDUBA_R	lduba	[%r18, %r0] 0x20, %r22
	.word 0xe4ce49e0  ! 5765: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r18
	.word 0xe0b76000  ! 5766: STHA_I	stha	%r16, [%r29 + 0x0000] %asi
	mov	0x50, %r24
	.word 0xe0c7e000  ! 5768: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r16
	.word 0xecf40400  ! 5769: STXA_R	stxa	%r22, [%r16 + %r0] 0x20
	.word 0xe4bc0400  ! 5770: STDA_R	stda	%r18, [%r16 + %r0] 0x20
	.word 0xea9fa000  ! 5771: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r21
	mov	0x3d0, %r20
	.word 0xeaf4c400  ! 5773: STXA_R	stxa	%r21, [%r19 + %r0] 0x20
	mov	0x30, %r27
	.word 0xe2af2000  ! 5775: STBA_I	stba	%r17, [%r28 + 0x0000] %asi
	.word 0xe2af6000  ! 5776: STBA_I	stba	%r17, [%r29 + 0x0000] %asi
	.word 0xe2f76000  ! 5777: STXA_I	stxa	%r17, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 5778: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe294c400  ! 5779: LDUHA_R	lduha	[%r19, %r0] 0x20, %r17
	.word 0xee978e40  ! 5780: LDUHA_R	lduha	[%r30, %r0] 0x72, %r23
	.word 0xea8ce000  ! 5781: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r21
	.word 0xe0b48400  ! 5782: STHA_R	stha	%r16, [%r18 + %r0] 0x20
	.word 0xe2a4a000  ! 5783: STWA_I	stwa	%r17, [%r18 + 0x0000] %asi
	mov	0x70, %r25
	.word 0xe6ac4400  ! 5785: STBA_R	stba	%r19, [%r17 + %r0] 0x20
	.word 0xe6b504a0  ! 5786: STHA_R	stha	%r19, [%r20 + %r0] 0x25
	.word 0xe0ae89e0  ! 5787: STBA_R	stba	%r16, [%r26 + %r0] 0x4f
	.word 0xe0bc0400  ! 5788: STDA_R	stda	%r16, [%r16 + %r0] 0x20
	.word 0xeccfce80  ! 5789: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r22
	.word 0x8780204f  ! 5790: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecbc4400  ! 5791: STDA_R	stda	%r22, [%r17 + %r0] 0x20
	.word 0xeeb48400  ! 5792: STHA_R	stha	%r23, [%r18 + %r0] 0x20
	.word 0xead70e80  ! 5793: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r21
	mov	0x48, %r26
	.word 0xe8b6c9e0  ! 5795: STHA_R	stha	%r20, [%r27 + %r0] 0x4f
	.word 0xee972000  ! 5796: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r23
	.word 0xee9f2000  ! 5797: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r23
	.word 0xe2dcc400  ! 5798: LDXA_R	ldxa	[%r19, %r0] 0x20, %r17
	.word 0xecac8400  ! 5799: STBA_R	stba	%r22, [%r18 + %r0] 0x20
	mov	0x7f8, %r22
	.word 0xe6c48400  ! 5801: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r19
	mov	0x20, %r16
	mov	0x70, %r18
	mov	0x7e8, %r23
	.word 0x87802072  ! 5805: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 5806: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8b4c400  ! 5807: STHA_R	stha	%r20, [%r19 + %r0] 0x20
	.word 0x87802020  ! 5808: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeec7a000  ! 5809: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r23
	mov	0x7f8, %r21
	.word 0xeca78e60  ! 5811: STWA_R	stwa	%r22, [%r30 + %r0] 0x73
	.word 0x87802074  ! 5812: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4dd04a0  ! 5813: LDXA_R	ldxa	[%r20, %r0] 0x25, %r18
	mov	0x38, %r24
	mov	0x20, %r27
	mov	0x10, %r27
	.word 0xeaaec9e0  ! 5817: STBA_R	stba	%r21, [%r27 + %r0] 0x4f
	mov	0x48, %r17
	.word 0xea970e60  ! 5819: LDUHA_R	lduha	[%r28, %r0] 0x73, %r21
	.word 0xe0f689e0  ! 5820: STXA_R	stxa	%r16, [%r26 + %r0] 0x4f
	.word 0xecae49e0  ! 5821: STBA_R	stba	%r22, [%r25 + %r0] 0x4f
	.word 0xe6f5e000  ! 5822: STXA_I	stxa	%r19, [%r23 + 0x0000] %asi
	mov	0x78, %r19
	.word 0xeeb48400  ! 5824: STHA_R	stha	%r23, [%r18 + %r0] 0x20
	.word 0xe88d6000  ! 5825: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r20
	.word 0xeebc4400  ! 5826: STDA_R	stda	%r23, [%r17 + %r0] 0x20
	.word 0xee85e000  ! 5827: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r23
	.word 0xe2dc8400  ! 5828: LDXA_R	ldxa	[%r18, %r0] 0x20, %r17
	mov	0x78, %r27
	.word 0x87802020  ! 5830: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 5831: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r21
	.word 0xe2b72000  ! 5833: STHA_I	stha	%r17, [%r28 + 0x0000] %asi
	.word 0xe297e000  ! 5834: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r17
	.word 0x87802073  ! 5835: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 5836: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r26
	mov	0x50, %r25
	.word 0xeaa74e60  ! 5839: STWA_R	stwa	%r21, [%r29 + %r0] 0x73
	.word 0xe6974e40  ! 5840: LDUHA_R	lduha	[%r29, %r0] 0x72, %r19
	.word 0x87802020  ! 5841: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6de2000  ! 5842: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r19
	mov	0x3f8, %r22
	.word 0xeabf4e60  ! 5844: STDA_R	stda	%r21, [%r29 + %r0] 0x73
	.word 0xeadf4e40  ! 5845: LDXA_R	ldxa	[%r29, %r0] 0x72, %r21
	.word 0xe086a000  ! 5846: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r16
	.word 0xe0b66000  ! 5847: STHA_I	stha	%r16, [%r25 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	mov	0x18, %r17
	.word 0xe0dee000  ! 5850: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r16
	.word 0xe0f6a000  ! 5851: STXA_I	stxa	%r16, [%r26 + 0x0000] %asi
	.word 0xe4af0e60  ! 5852: STBA_R	stba	%r18, [%r28 + %r0] 0x73
	.word 0xeea6a000  ! 5853: STWA_I	stwa	%r23, [%r26 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xeed6e000  ! 5855: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r23
	.word 0x87802072  ! 5856: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8f78e80  ! 5857: STXA_R	stxa	%r20, [%r30 + %r0] 0x74
	.word 0xe0bfe000  ! 5858: STDA_I	stda	%r16, [%r31 + 0x0000] %asi
	.word 0xe0bf2000  ! 5859: STDA_I	stda	%r16, [%r28 + 0x0000] %asi
	mov	0x78, %r25
	.word 0xe8bc8400  ! 5861: STDA_R	stda	%r20, [%r18 + %r0] 0x20
	.word 0xe4cd44a0  ! 5862: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r18
	.word 0xe29f6000  ! 5863: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r17
	.word 0xe2a7e000  ! 5864: STWA_I	stwa	%r17, [%r31 + 0x0000] %asi
	.word 0xe2a72000  ! 5865: STWA_I	stwa	%r17, [%r28 + 0x0000] %asi
	.word 0xe29fa000  ! 5866: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r17
	.word 0xe29fa000  ! 5867: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r17
	mov	0x7c8, %r23
	.word 0xe287e000  ! 5869: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r17
	.word 0xecd48400  ! 5870: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r22
	.word 0xecbfce40  ! 5871: STDA_R	stda	%r22, [%r31 + %r0] 0x72
	.word 0xe2876000  ! 5872: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r17
	mov	0x70, %r18
	mov	0x7e8, %r21
	.word 0xe0cd04a0  ! 5875: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r16
	mov	0x18, %r27
	.word 0xeebf2000  ! 5877: STDA_I	stda	%r23, [%r28 + 0x0000] %asi
	.word 0xeecfa000  ! 5878: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r23
	mov	0x30, %r25
	.word 0xeebfe000  ! 5880: STDA_I	stda	%r23, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 5881: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeef46000  ! 5882: STXA_I	stxa	%r23, [%r17 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xee842000  ! 5884: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r23
	.word 0xe687ce80  ! 5885: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r19
	mov	0x78, %r17
	.word 0xec94a000  ! 5887: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r22
	.word 0xec8c2000  ! 5888: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r22
	.word 0xe8ce49e0  ! 5889: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r20
	.word 0x87802020  ! 5890: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0b44400  ! 5891: STHA_R	stha	%r16, [%r17 + %r0] 0x20
	.word 0xe4a76000  ! 5892: STWA_I	stwa	%r18, [%r29 + 0x0000] %asi
	.word 0xe2ae49e0  ! 5893: STBA_R	stba	%r17, [%r25 + %r0] 0x4f
	.word 0xecbd44a0  ! 5894: STDA_R	stda	%r22, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 5895: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6a76000  ! 5896: STWA_I	stwa	%r19, [%r29 + 0x0000] %asi
	.word 0xe697a000  ! 5897: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r19
	mov	0x3f0, %r21
	.word 0xecdcc400  ! 5899: LDXA_R	ldxa	[%r19, %r0] 0x20, %r22
	mov	0x7d0, %r21
	.word 0xe0972000  ! 5901: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r16
	.word 0xe28f0e80  ! 5902: LDUBA_R	lduba	[%r28, %r0] 0x74, %r17
	mov	0x7f0, %r21
	.word 0xe6b74e80  ! 5904: STHA_R	stha	%r19, [%r29 + %r0] 0x74
	.word 0x87802025  ! 5905: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r26
	mov	0x10, %r18
	.word 0xea8d6000  ! 5908: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r21
	.word 0xea856000  ! 5909: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r21
	.word 0x87802025  ! 5910: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 5911: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 5912: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeaa46000  ! 5913: STWA_I	stwa	%r21, [%r17 + 0x0000] %asi
	.word 0xe4c40400  ! 5914: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r18
	mov	0x50, %r19
	mov	0x40, %r24
	.word 0xe2d4a000  ! 5917: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r17
	.word 0xe2ace000  ! 5918: STBA_I	stba	%r17, [%r19 + 0x0000] %asi
	.word 0xe2d4a000  ! 5919: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r17
	.word 0xe2ddc4a0  ! 5920: LDXA_R	ldxa	[%r23, %r0] 0x25, %r17
	.word 0xecd74e60  ! 5921: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r22
	.word 0x8780204f  ! 5922: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 5923: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r25
	.word 0xe8ad2000  ! 5925: STBA_I	stba	%r20, [%r20 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xe4a78e80  ! 5927: STWA_R	stwa	%r18, [%r30 + %r0] 0x74
	.word 0xeeb56000  ! 5928: STHA_I	stha	%r23, [%r21 + 0x0000] %asi
	.word 0xe4a649e0  ! 5929: STWA_R	stwa	%r18, [%r25 + %r0] 0x4f
	.word 0xe8856000  ! 5930: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r20
	.word 0xecbf8e60  ! 5931: STDA_R	stda	%r22, [%r30 + %r0] 0x73
	mov	0x38, %r17
	.word 0xeab609e0  ! 5933: STHA_R	stha	%r21, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 5934: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r26
	.word 0xec9f0e80  ! 5936: LDDA_R	ldda	[%r28, %r0] 0x74, %r22
	.word 0xe88f2000  ! 5937: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r20
	.word 0xe8bf2000  ! 5938: STDA_I	stda	%r20, [%r28 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xe887e000  ! 5940: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r20
	.word 0x87802020  ! 5941: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeec74e60  ! 5942: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r23
	.word 0xee94e000  ! 5943: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r23
	.word 0xeca44400  ! 5944: STWA_R	stwa	%r22, [%r17 + %r0] 0x20
	.word 0xe69c2000  ! 5945: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r19
	mov	0x78, %r18
	mov	0x10, %r24
	.word 0xec940400  ! 5948: LDUHA_R	lduha	[%r16, %r0] 0x20, %r22
	.word 0xe49e09e0  ! 5949: LDDA_R	ldda	[%r24, %r0] 0x4f, %r18
	.word 0xe8cc6000  ! 5950: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r20
	.word 0x87802073  ! 5951: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeeaf0e60  ! 5952: STBA_R	stba	%r23, [%r28 + %r0] 0x73
	.word 0xe8dc6000  ! 5953: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r20
	.word 0xe6f40400  ! 5954: STXA_R	stxa	%r19, [%r16 + %r0] 0x20
	mov	0x7f8, %r21
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x20, %r17
	.word 0xec8c4400  ! 5958: LDUBA_R	lduba	[%r17, %r0] 0x20, %r22
	.word 0xec942000  ! 5959: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r22
	.word 0xe2ac0400  ! 5960: STBA_R	stba	%r17, [%r16 + %r0] 0x20
	.word 0xe69f8e40  ! 5961: LDDA_R	ldda	[%r30, %r0] 0x72, %r19
	mov	0x20, %r19
	.word 0x87802020  ! 5963: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_48:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xd3, %g2
	or	%g4, 0xf2, %g4
	or	%g6, 0xc6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe485a000  ! 5965: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r18
	.word 0xe4cd2000  ! 5966: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r18
	.word 0xe29fce60  ! 5967: LDDA_R	ldda	[%r31, %r0] 0x73, %r17
	mov	0x60, %r25
	wr_tick_cmpr_3_49:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x84, %g2
	or	%g4, 0xff, %g4
	or	%g6, 0xe9, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	wr_tick_cmpr_3_50:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0x8c, %g2
	or	%g4, 0xbe, %g4
	or	%g6, 0xe6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x7f8, %r20
	.word 0xe6bd6000  ! 5972: STDA_I	stda	%r19, [%r21 + 0x0000] %asi
	.word 0xe6956000  ! 5973: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r19
	.word 0xe6956000  ! 5974: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r19
	.word 0xe6b56000  ! 5975: STHA_I	stha	%r19, [%r21 + 0x0000] %asi
	.word 0xe6b5e000  ! 5976: STHA_I	stha	%r19, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 5977: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r25
	mov	0x28, %r27
	.word 0xe6dee000  ! 5980: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r19
	.word 0xecc70e60  ! 5981: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r22
	.word 0x8780204f  ! 5982: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xecaf8e60  ! 5983: STBA_R	stba	%r22, [%r30 + %r0] 0x73
	mov	0x7f8, %r23
	.word 0x87802020  ! 5985: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 5986: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6f7a000  ! 5987: STXA_I	stxa	%r19, [%r30 + 0x0000] %asi
	.word 0xe69f6000  ! 5988: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r19
	.word 0xe6cfe000  ! 5989: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r19
	.word 0xe6bfa000  ! 5990: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xee9544a0  ! 5991: LDUHA_R	lduha	[%r21, %r0] 0x25, %r23
	mov	0x18, %r27
	.word 0xe2f76000  ! 5993: STXA_I	stxa	%r17, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 5994: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeaaec9e0  ! 5995: STBA_R	stba	%r21, [%r27 + %r0] 0x4f
	mov	0x3d8, %r22
	.word 0xe0f5e000  ! 5997: STXA_I	stxa	%r16, [%r23 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xe28649e0  ! 5999: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r17
	.word 0xe0d5a000  ! 6000: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r16
	.word 0xeaa70e40  ! 6001: STWA_R	stwa	%r21, [%r28 + %r0] 0x72
	.word 0xe0878e80  ! 6002: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r16
	.word 0xe0dda000  ! 6003: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r16
	.word 0xe8afce60  ! 6004: STBA_R	stba	%r20, [%r31 + %r0] 0x73
	.word 0xec85a000  ! 6005: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r22
	.word 0xecb74e40  ! 6006: STHA_R	stha	%r22, [%r29 + %r0] 0x72
	mov	0x48, %r16
	.word 0xe8ad2000  ! 6008: STBA_I	stba	%r20, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 6009: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	mov	0x50, %r16
	.word 0xe8bfe000  ! 6012: STDA_I	stda	%r20, [%r31 + 0x0000] %asi
	.word 0xe89c0400  ! 6013: LDDA_R	ldda	[%r16, %r0] 0x20, %r20
	.word 0x87802025  ! 6014: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2cce000  ! 6015: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r17
	mov	0x7c8, %r23
	.word 0xeecc0400  ! 6017: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r23
	.word 0xecbc2000  ! 6018: STDA_I	stda	%r22, [%r16 + 0x0000] %asi
	mov	0x8, %r16
	.word 0xe6ae49e0  ! 6020: STBA_R	stba	%r19, [%r25 + %r0] 0x4f
	.word 0xe88c6000  ! 6021: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r20
	.word 0xe88c2000  ! 6022: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r20
	mov	0x58, %r17
	.word 0xe0cd84a0  ! 6024: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r16
	.word 0xeabcc400  ! 6025: STDA_R	stda	%r21, [%r19 + %r0] 0x20
	.word 0xe284e000  ! 6026: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r17
	.word 0xe2ace000  ! 6027: STBA_I	stba	%r17, [%r19 + 0x0000] %asi
	.word 0xee9fce80  ! 6028: LDDA_R	ldda	[%r31, %r0] 0x74, %r23
	.word 0xe6b504a0  ! 6029: STHA_R	stha	%r19, [%r20 + %r0] 0x25
	.word 0xe894c400  ! 6030: LDUHA_R	lduha	[%r19, %r0] 0x20, %r20
	.word 0x87802020  ! 6031: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r18
	mov	0x20, %r27
	.word 0xe6af2000  ! 6034: STBA_I	stba	%r19, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 6035: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 6036: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeaa40400  ! 6037: STWA_R	stwa	%r21, [%r16 + %r0] 0x20
	.word 0xe4c4a000  ! 6038: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r18
	.word 0x87802020  ! 6039: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0d504a0  ! 6040: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r16
	.word 0xeab6e000  ! 6041: STHA_I	stha	%r21, [%r27 + 0x0000] %asi
	mov	0x40, %r27
	mov	0x20, %r26
	.word 0x8780204f  ! 6044: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 6045: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea9f6000  ! 6046: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r21
	.word 0x87802025  ! 6047: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xee8c8400  ! 6048: LDUBA_R	lduba	[%r18, %r0] 0x20, %r23
	.word 0x87802073  ! 6049: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0a7ce80  ! 6050: STWA_R	stwa	%r16, [%r31 + %r0] 0x74
	.word 0x87802073  ! 6051: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r26
	.word 0xee8da000  ! 6053: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r23
	.word 0x87802020  ! 6054: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6bc8400  ! 6055: STDA_R	stda	%r19, [%r18 + %r0] 0x20
	mov	0x78, %r19
	mov	0x70, %r24
	.word 0xeeaf2000  ! 6058: STBA_I	stba	%r23, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 6059: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4ac0400  ! 6060: STBA_R	stba	%r18, [%r16 + %r0] 0x20
	.word 0xecbea000  ! 6061: STDA_I	stda	%r22, [%r26 + 0x0000] %asi
	.word 0xecaf8e60  ! 6062: STBA_R	stba	%r22, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 6063: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeabc4400  ! 6064: STDA_R	stda	%r21, [%r17 + %r0] 0x20
	.word 0xe29f4e60  ! 6065: LDDA_R	ldda	[%r29, %r0] 0x73, %r17
	.word 0xecbe09e0  ! 6066: STDA_R	stda	%r22, [%r24 + %r0] 0x4f
	.word 0xeac584a0  ! 6067: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r21
	.word 0xe6cc4400  ! 6068: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r19
	.word 0xe08504a0  ! 6069: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r16
	.word 0xe4ac8400  ! 6070: STBA_R	stba	%r18, [%r18 + %r0] 0x20
	.word 0x87802020  ! 6071: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4d7a000  ! 6072: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r18
	.word 0xe8af0e60  ! 6073: STBA_R	stba	%r20, [%r28 + %r0] 0x73
	.word 0xeccf0e60  ! 6074: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r22
	.word 0xeca7a000  ! 6075: STWA_I	stwa	%r22, [%r30 + 0x0000] %asi
	.word 0xecd7e000  ! 6076: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r22
	.word 0xec87e000  ! 6077: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r22
	.word 0xe2bc4400  ! 6078: STDA_R	stda	%r17, [%r17 + %r0] 0x20
	mov	0x48, %r25
	.word 0xe0944400  ! 6080: LDUHA_R	lduha	[%r17, %r0] 0x20, %r16
	.word 0x87802072  ! 6081: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c0, %r20
	.word 0xe8b7e000  ! 6083: STHA_I	stha	%r20, [%r31 + 0x0000] %asi
	.word 0xe6a7ce80  ! 6084: STWA_R	stwa	%r19, [%r31 + %r0] 0x74
	.word 0xee8fa000  ! 6085: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r23
	.word 0xe6cf0e80  ! 6086: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r19
	mov	0x48, %r19
	.word 0x87802072  ! 6088: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8bd04a0  ! 6089: STDA_R	stda	%r20, [%r20 + %r0] 0x25
	.word 0xe49d6000  ! 6090: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r18
	.word 0xe4a5e000  ! 6091: STWA_I	stwa	%r18, [%r23 + 0x0000] %asi
	.word 0xe4ade000  ! 6092: STBA_I	stba	%r18, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 6093: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4cf4e40  ! 6094: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r18
	.word 0xeacdc4a0  ! 6095: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r21
	.word 0x87802025  ! 6096: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0bd04a0  ! 6097: STDA_R	stda	%r16, [%r20 + %r0] 0x25
	.word 0xe0a4c400  ! 6098: STWA_R	stwa	%r16, [%r19 + %r0] 0x20
	mov	0x7f0, %r20
	.word 0xe8976000  ! 6100: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r20
	mov	0x70, %r27
	.word 0xe8d76000  ! 6102: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r20
	.word 0xe8b4c400  ! 6103: STHA_R	stha	%r20, [%r19 + %r0] 0x20
	.word 0x87802025  ! 6104: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeea7e000  ! 6105: STWA_I	stwa	%r23, [%r31 + 0x0000] %asi
	.word 0xec84c400  ! 6106: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r22
	.word 0x87802020  ! 6107: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeacfa000  ! 6108: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r21
	.word 0xea976000  ! 6109: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r21
	.word 0x87802020  ! 6110: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r16
	.word 0xeaf7a000  ! 6112: STXA_I	stxa	%r21, [%r30 + 0x0000] %asi
	.word 0xecae09e0  ! 6113: STBA_R	stba	%r22, [%r24 + %r0] 0x4f
	.word 0xe0a6c9e0  ! 6114: STWA_R	stwa	%r16, [%r27 + %r0] 0x4f
	mov	0x18, %r19
	.word 0xe4a7e000  ! 6116: STWA_I	stwa	%r18, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802074  ! 6118: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4f689e0  ! 6119: STXA_R	stxa	%r18, [%r26 + %r0] 0x4f
	.word 0xecdd2000  ! 6120: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r22
	.word 0xecc5e000  ! 6121: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r22
	.word 0xecd56000  ! 6122: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r22
	.word 0x87802073  ! 6123: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xec8d6000  ! 6124: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r22
	mov	0x70, %r18
	.word 0xecbde000  ! 6126: STDA_I	stda	%r22, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 6127: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r26
	.word 0xe2b78e80  ! 6129: STHA_R	stha	%r17, [%r30 + %r0] 0x74
	.word 0xe0f70e40  ! 6130: STXA_R	stxa	%r16, [%r28 + %r0] 0x72
	.word 0xeeb42000  ! 6131: STHA_I	stha	%r23, [%r16 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x48, %r25
	mov	0x40, %r16
	mov	0x3c0, %r20
	mov	0x50, %r26
	.word 0xe0840400  ! 6137: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r16
	.word 0xe08c6000  ! 6138: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r16
	mov	0x10, %r25
	.word 0xe0846000  ! 6140: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r16
	mov	0x3c8, %r22
	mov	0x18, %r27
	.word 0xe0bce000  ! 6143: STDA_I	stda	%r16, [%r19 + 0x0000] %asi
	.word 0xe0ac6000  ! 6144: STBA_I	stba	%r16, [%r17 + 0x0000] %asi
	.word 0xe084e000  ! 6145: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r16
	mov	0x3d0, %r21
	.word 0xe2ce09e0  ! 6147: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r17
	.word 0xe4c4c400  ! 6148: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r18
	.word 0xe2dc6000  ! 6149: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r17
	.word 0xe2ace000  ! 6150: STBA_I	stba	%r17, [%r19 + 0x0000] %asi
	mov	0x20, %r19
	mov	0x3f8, %r23
	.word 0xeed48400  ! 6153: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r23
	mov	0x7f8, %r21
	.word 0xe88ca000  ! 6155: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r20
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7e8, %r23
	.word 0xe0b48400  ! 6158: STHA_R	stha	%r16, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 6159: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe68fce40  ! 6160: LDUBA_R	lduba	[%r31, %r0] 0x72, %r19
	.word 0xe89f4e60  ! 6161: LDDA_R	ldda	[%r29, %r0] 0x73, %r20
	.word 0xeecf4e60  ! 6162: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r23
	.word 0xe68ea000  ! 6163: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r19
	.word 0xe2a4c400  ! 6164: STWA_R	stwa	%r17, [%r19 + %r0] 0x20
	.word 0xe4f4c400  ! 6165: STXA_R	stxa	%r18, [%r19 + %r0] 0x20
	mov	0x3d8, %r21
	.word 0x87802072  ! 6167: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r16
	.word 0xeadc8400  ! 6169: LDXA_R	ldxa	[%r18, %r0] 0x20, %r21
	mov	0x18, %r17
	.word 0xe49584a0  ! 6171: LDUHA_R	lduha	[%r22, %r0] 0x25, %r18
	.word 0xe28f6000  ! 6172: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r17
	.word 0xe297e000  ! 6173: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r17
	.word 0xe2a7a000  ! 6174: STWA_I	stwa	%r17, [%r30 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xe88c8400  ! 6176: LDUBA_R	lduba	[%r18, %r0] 0x20, %r20
	mov	0x7f0, %r21
	.word 0x87802025  ! 6178: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e0, %r21
	.word 0xec9584a0  ! 6180: LDUHA_R	lduha	[%r22, %r0] 0x25, %r22
	mov	0x7c8, %r22
	.word 0xea944400  ! 6182: LDUHA_R	lduha	[%r17, %r0] 0x20, %r21
	.word 0xeace09e0  ! 6183: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r21
	.word 0x87802072  ! 6184: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r17
	.word 0x87802020  ! 6186: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6c76000  ! 6187: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r19
	.word 0xe6af6000  ! 6188: STBA_I	stba	%r19, [%r29 + 0x0000] %asi
	.word 0xe2d78e60  ! 6189: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r17
	.word 0xe4bf6000  ! 6190: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xe4f7a000  ! 6192: STXA_I	stxa	%r18, [%r30 + 0x0000] %asi
	.word 0xe89c8400  ! 6193: LDDA_R	ldda	[%r18, %r0] 0x20, %r20
	.word 0xeef584a0  ! 6194: STXA_R	stxa	%r23, [%r22 + %r0] 0x25
	mov	0x10, %r25
	.word 0xe69f2000  ! 6196: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r19
	.word 0xe6df2000  ! 6197: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r19
	mov	0x28, %r27
	.word 0xe6bf6000  ! 6199: STDA_I	stda	%r19, [%r29 + 0x0000] %asi
	.word 0xe6c7e000  ! 6200: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r19
	.word 0xeaf78e80  ! 6201: STXA_R	stxa	%r21, [%r30 + %r0] 0x74
	.word 0xeec76000  ! 6202: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r23
	mov	0x20, %r25
	.word 0xeeaf0e40  ! 6204: STBA_R	stba	%r23, [%r28 + %r0] 0x72
	mov	0x30, %r25
	.word 0xe4f7e000  ! 6206: STXA_I	stxa	%r18, [%r31 + 0x0000] %asi
	.word 0xe4dfa000  ! 6207: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r18
	mov	0x7f0, %r21
	.word 0xe4c76000  ! 6209: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r18
	.word 0xe4afe000  ! 6210: STBA_I	stba	%r18, [%r31 + 0x0000] %asi
	mov	0x7d8, %r20
	.word 0xe4c72000  ! 6212: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r18
	.word 0xe6dc0400  ! 6213: LDXA_R	ldxa	[%r16, %r0] 0x20, %r19
	.word 0xeabc4400  ! 6214: STDA_R	stda	%r21, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 6215: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r26
	.word 0xe6dc6000  ! 6217: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r19
	mov	0x7e8, %r20
	.word 0x87802020  ! 6219: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6afa000  ! 6220: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	.word 0xe6cfa000  ! 6221: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r19
	.word 0xecd70e40  ! 6222: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r22
	.word 0xe0f40400  ! 6223: STXA_R	stxa	%r16, [%r16 + %r0] 0x20
	mov	0x28, %r26
	.word 0xeeb7e000  ! 6225: STHA_I	stha	%r23, [%r31 + 0x0000] %asi
	.word 0xee976000  ! 6226: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r23
	mov	0x3c8, %r23
	.word 0xeec76000  ! 6228: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r23
	.word 0xe4a78e80  ! 6229: STWA_R	stwa	%r18, [%r30 + %r0] 0x74
	.word 0xe2af6000  ! 6230: STBA_I	stba	%r17, [%r29 + 0x0000] %asi
	.word 0xe8a48400  ! 6231: STWA_R	stwa	%r20, [%r18 + %r0] 0x20
	.word 0xe4d7ce60  ! 6232: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r18
	.word 0x87802074  ! 6233: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 6234: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4bfa000  ! 6235: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	.word 0xe0d78e60  ! 6236: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r16
	mov	0x40, %r27
	.word 0x87802072  ! 6238: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeec72000  ! 6239: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r23
	mov	0x0, %r17
	.word 0xeeb5c4a0  ! 6241: STHA_R	stha	%r23, [%r23 + %r0] 0x25
	.word 0x87802074  ! 6242: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r23
	.word 0x8780204f  ! 6244: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeab7e000  ! 6245: STHA_I	stha	%r21, [%r31 + 0x0000] %asi
	.word 0xe4bc4400  ! 6246: STDA_R	stda	%r18, [%r17 + %r0] 0x20
	mov	0x8, %r16
	mov	0x60, %r16
	.word 0x87802074  ! 6249: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeeaf0e60  ! 6250: STBA_R	stba	%r23, [%r28 + %r0] 0x73
	.word 0xe49609e0  ! 6251: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r18
	.word 0x8780204f  ! 6252: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 6253: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8974e60  ! 6254: LDUHA_R	lduha	[%r29, %r0] 0x73, %r20
	mov	0x7e8, %r22
	.word 0xe0f7e000  ! 6256: STXA_I	stxa	%r16, [%r31 + 0x0000] %asi
	.word 0xe48544a0  ! 6257: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r18
	.word 0x87802072  ! 6258: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xee9fa000  ! 6259: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r23
	.word 0xeeaf2000  ! 6260: STBA_I	stba	%r23, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 6261: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r19
	.word 0xeed76000  ! 6263: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r23
	mov	0x3f0, %r22
	mov	0x30, %r27
	.word 0xeea72000  ! 6266: STWA_I	stwa	%r23, [%r28 + 0x0000] %asi
	mov	0x70, %r25
	mov	0x7d0, %r23
	mov	0x3e0, %r21
	.word 0xe4c70e60  ! 6270: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r18
	mov	0x7c0, %r20
	mov	0x40, %r24
	.word 0xe2940400  ! 6273: LDUHA_R	lduha	[%r16, %r0] 0x20, %r17
	.word 0xe48f6000  ! 6274: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r18
	mov	0x78, %r16
	.word 0xe8f48400  ! 6276: STXA_R	stxa	%r20, [%r18 + %r0] 0x20
	mov	0x8, %r25
	.word 0xecafce60  ! 6278: STBA_R	stba	%r22, [%r31 + %r0] 0x73
	.word 0xeeafe000  ! 6279: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0xeeafe000  ! 6280: STBA_I	stba	%r23, [%r31 + 0x0000] %asi
	.word 0xeef7e000  ! 6281: STXA_I	stxa	%r23, [%r31 + 0x0000] %asi
	mov	0x3f8, %r22
	mov	0x3d8, %r22
	mov	0x7f0, %r21
	.word 0xe2f4c400  ! 6285: STXA_R	stxa	%r17, [%r19 + %r0] 0x20
	.word 0x87802074  ! 6286: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4a72000  ! 6287: STWA_I	stwa	%r18, [%r28 + 0x0000] %asi
	.word 0xe48f6000  ! 6288: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r18
	.word 0xe4972000  ! 6289: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r18
	mov	0x28, %r26
	.word 0xe2ddc4a0  ! 6291: LDXA_R	ldxa	[%r23, %r0] 0x25, %r17
	.word 0xe4bf2000  ! 6292: STDA_I	stda	%r18, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 6293: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2a649e0  ! 6294: STWA_R	stwa	%r17, [%r25 + %r0] 0x4f
	.word 0xe2dc8400  ! 6295: LDXA_R	ldxa	[%r18, %r0] 0x20, %r17
	.word 0xec9ce000  ! 6296: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r22
	mov	0x78, %r18
	.word 0xe0cc8400  ! 6298: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r16
	.word 0xe0f4c400  ! 6299: STXA_R	stxa	%r16, [%r19 + %r0] 0x20
	.word 0xe8d48400  ! 6300: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r20
	.word 0x87802073  ! 6301: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xee852000  ! 6302: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r23
	.word 0xeed649e0  ! 6303: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r23
	.word 0xe0d5a000  ! 6304: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r16
	mov	0x28, %r16
	.word 0xe09de000  ! 6306: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r16
	.word 0xe08d6000  ! 6307: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r16
	mov	0x58, %r16
	.word 0xe4d74e60  ! 6309: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r18
	.word 0xeed5a000  ! 6310: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r23
	.word 0xea8d44a0  ! 6311: LDUBA_R	lduba	[%r21, %r0] 0x25, %r21
	.word 0xe4ada000  ! 6312: STBA_I	stba	%r18, [%r22 + 0x0000] %asi
	.word 0xe4a5e000  ! 6313: STWA_I	stwa	%r18, [%r23 + 0x0000] %asi
	.word 0xe4ade000  ! 6314: STBA_I	stba	%r18, [%r23 + 0x0000] %asi
	.word 0xecadc4a0  ! 6315: STBA_R	stba	%r22, [%r23 + %r0] 0x25
	.word 0xe8f5a000  ! 6316: STXA_I	stxa	%r20, [%r22 + 0x0000] %asi
	mov	0x7c8, %r23
	mov	0x0, %r27
	.word 0xe4bcc400  ! 6319: STDA_R	stda	%r18, [%r19 + %r0] 0x20
	.word 0xeab5a000  ! 6320: STHA_I	stha	%r21, [%r22 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0x87802025  ! 6322: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 6323: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeed40400  ! 6324: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r23
	.word 0x87802074  ! 6325: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4aec9e0  ! 6326: STBA_R	stba	%r18, [%r27 + %r0] 0x4f
	mov	0x7c8, %r22
	.word 0xecd44400  ! 6328: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r22
	mov	0x78, %r24
	mov	0x10, %r25
	.word 0x87802074  ! 6331: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r18
	.word 0xe4af8e60  ! 6333: STBA_R	stba	%r18, [%r30 + %r0] 0x73
	mov	0x7f8, %r22
	.word 0xe8bd44a0  ! 6335: STDA_R	stda	%r20, [%r21 + %r0] 0x25
	.word 0xe49609e0  ! 6336: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r18
	.word 0xeedfa000  ! 6337: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r23
	.word 0x8780204f  ! 6338: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xea9fce60  ! 6339: LDDA_R	ldda	[%r31, %r0] 0x73, %r21
	.word 0xe0b46000  ! 6340: STHA_I	stha	%r16, [%r17 + 0x0000] %asi
	mov	0x20, %r24
	mov	0x20, %r24
	mov	0x3c8, %r23
	.word 0xe0c46000  ! 6344: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r16
	.word 0xe09504a0  ! 6345: LDUHA_R	lduha	[%r20, %r0] 0x25, %r16
	mov	0x38, %r26
	.word 0x87802073  ! 6347: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r20
	mov	0x38, %r18
	.word 0x87802025  ! 6350: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4b70e80  ! 6351: STHA_R	stha	%r18, [%r28 + %r0] 0x74
	.word 0xe2946000  ! 6352: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r17
	.word 0x87802020  ! 6353: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2af2000  ! 6354: STBA_I	stba	%r17, [%r28 + 0x0000] %asi
	.word 0xe0b74e40  ! 6355: STHA_R	stha	%r16, [%r29 + %r0] 0x72
	.word 0xe6972000  ! 6356: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r19
	.word 0xeea7ce60  ! 6357: STWA_R	stwa	%r23, [%r31 + %r0] 0x73
	mov	0x3e8, %r20
	.word 0x87802025  ! 6359: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r18
	.word 0xe4cd04a0  ! 6361: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r18
	mov	0x60, %r26
	.word 0xead7a000  ! 6363: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r21
	mov	0x30, %r25
	mov	0x7d0, %r20
	.word 0xeab7e000  ! 6366: STHA_I	stha	%r21, [%r31 + 0x0000] %asi
	wr_tick_cmpr_3_51:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xc7, %g2
	or	%g4, 0xd1, %g4
	or	%g6, 0xe2, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802073  ! 6368: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeac7e000  ! 6369: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r21
	.word 0x8780204f  ! 6370: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r23
	.word 0xeccc8400  ! 6372: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r22
	.word 0xe0c4e000  ! 6373: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r16
	.word 0xe0f42000  ! 6374: STXA_I	stxa	%r16, [%r16 + 0x0000] %asi
	.word 0xecc4c400  ! 6375: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r22
	.word 0xe2f6c9e0  ! 6376: STXA_R	stxa	%r17, [%r27 + %r0] 0x4f
	mov	0x20, %r27
	.word 0xeef42000  ! 6378: STXA_I	stxa	%r23, [%r16 + 0x0000] %asi
	.word 0xee842000  ! 6379: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r23
	.word 0xe2af0e60  ! 6380: STBA_R	stba	%r17, [%r28 + %r0] 0x73
	mov	0x40, %r27
	.word 0xe4bfce60  ! 6382: STDA_R	stda	%r18, [%r31 + %r0] 0x73
	.word 0xe6be49e0  ! 6383: STDA_R	stda	%r19, [%r25 + %r0] 0x4f
	.word 0xe0dc2000  ! 6384: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r16
	.word 0xe0cca000  ! 6385: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r16
	.word 0xe4c48400  ! 6386: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r18
	.word 0xe4a7ce40  ! 6387: STWA_R	stwa	%r18, [%r31 + %r0] 0x72
	.word 0xe6bc4400  ! 6388: STDA_R	stda	%r19, [%r17 + %r0] 0x20
	.word 0xeeb46000  ! 6389: STHA_I	stha	%r23, [%r17 + 0x0000] %asi
	mov	0x7c0, %r21
	mov	0x50, %r17
	.word 0xeeb4e000  ! 6392: STHA_I	stha	%r23, [%r19 + 0x0000] %asi
	.word 0xe8cf0e60  ! 6393: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r20
	.word 0xe68504a0  ! 6394: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r19
	mov	0x78, %r19
	.word 0x87802074  ! 6396: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 6397: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeebe89e0  ! 6398: STDA_R	stda	%r23, [%r26 + %r0] 0x4f
	.word 0xea9fe000  ! 6399: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r21
	mov	0x18, %r24
	.word 0xeaf7e000  ! 6401: STXA_I	stxa	%r21, [%r31 + 0x0000] %asi
	.word 0xe0cc0400  ! 6402: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r16
	.word 0xeec72000  ! 6403: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r23
	.word 0xeecd84a0  ! 6404: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r23
	.word 0xeedf4e60  ! 6405: LDXA_R	ldxa	[%r29, %r0] 0x73, %r23
	.word 0xe0f44400  ! 6406: STXA_R	stxa	%r16, [%r17 + %r0] 0x20
	mov	0x7d8, %r20
	mov	0x0, %r26
	.word 0xe8c544a0  ! 6409: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r20
	.word 0xe497e000  ! 6410: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r18
	.word 0xe4972000  ! 6411: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r18
	.word 0xe48fa000  ! 6412: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r18
	.word 0xe4af6000  ! 6413: STBA_I	stba	%r18, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 6414: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6978e80  ! 6415: LDUHA_R	lduha	[%r30, %r0] 0x74, %r19
	.word 0xeacc4400  ! 6416: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r21
	mov	0x7f8, %r23
	.word 0xe495c4a0  ! 6418: LDUHA_R	lduha	[%r23, %r0] 0x25, %r18
	mov	0x10, %r27
	mov	0x7e8, %r20
	.word 0x87802025  ! 6421: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2bf8e40  ! 6422: STDA_R	stda	%r17, [%r30 + %r0] 0x72
	.word 0xe8b52000  ! 6423: STHA_I	stha	%r20, [%r20 + 0x0000] %asi
	.word 0xe8d52000  ! 6424: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r20
	.word 0xe28f0e80  ! 6425: LDUBA_R	lduba	[%r28, %r0] 0x74, %r17
	.word 0xe89d6000  ! 6426: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r20
	mov	0x30, %r17
	.word 0xe8f5e000  ! 6428: STXA_I	stxa	%r20, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 6429: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r20
	.word 0xe8846000  ! 6431: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r20
	wr_tick_cmpr_3_52:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xba, %g2
	or	%g4, 0xb0, %g4
	or	%g6, 0xf3, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802020  ! 6433: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 6434: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6df8e60  ! 6435: LDXA_R	ldxa	[%r30, %r0] 0x73, %r19
	.word 0xec8c0400  ! 6436: LDUBA_R	lduba	[%r16, %r0] 0x20, %r22
	mov	0x7f8, %r23
	mov	0x68, %r19
	.word 0xecc66000  ! 6439: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r22
	mov	0x3f0, %r22
	.word 0x87802025  ! 6441: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecbfa000  ! 6442: STDA_I	stda	%r22, [%r30 + 0x0000] %asi
	.word 0xe4c74e40  ! 6443: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r18
	mov	0x18, %r19
	mov	0x7c0, %r21
	.word 0xe0af6000  ! 6446: STBA_I	stba	%r16, [%r29 + 0x0000] %asi
	.word 0xe0b7e000  ! 6447: STHA_I	stha	%r16, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 6448: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0c6e000  ! 6449: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r16
	.word 0xea848400  ! 6450: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r21
	.word 0xe6a6e000  ! 6451: STWA_I	stwa	%r19, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 6452: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0ae49e0  ! 6453: STBA_R	stba	%r16, [%r25 + %r0] 0x4f
	.word 0xeaafce60  ! 6454: STBA_R	stba	%r21, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 6455: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r20
	mov	0x7f0, %r20
	.word 0xe0cce000  ! 6458: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r16
	.word 0xe0dc6000  ! 6459: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r16
	.word 0xe09c2000  ! 6460: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r16
	.word 0xe2cc8400  ! 6461: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r17
	.word 0xeaa6c9e0  ! 6462: STWA_R	stwa	%r21, [%r27 + %r0] 0x4f
	.word 0xe6ac6000  ! 6463: STBA_I	stba	%r19, [%r17 + 0x0000] %asi
	.word 0xeeb7ce80  ! 6464: STHA_R	stha	%r23, [%r31 + %r0] 0x74
	mov	0x48, %r17
	.word 0x8780204f  ! 6466: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe285a000  ! 6467: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r17
	wr_tick_cmpr_3_53:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xb6, %g2
	or	%g4, 0xcc, %g4
	or	%g6, 0x85, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x3c0, %r22
	mov	0x30, %r25
	.word 0x87802020  ! 6471: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r20
	.word 0x87802074  ! 6473: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r24
	mov	0x18, %r16
	.word 0xe2d7ce40  ! 6476: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r17
	.word 0xeabee000  ! 6477: STDA_I	stda	%r21, [%r27 + 0x0000] %asi
	.word 0xeace6000  ! 6478: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r21
	.word 0x87802074  ! 6479: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xead42000  ! 6480: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r21
	mov	0x3e8, %r23
	.word 0xea84e000  ! 6482: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r21
	.word 0xe4bcc400  ! 6483: STDA_R	stda	%r18, [%r19 + %r0] 0x20
	.word 0xe6b7ce40  ! 6484: STHA_R	stha	%r19, [%r31 + %r0] 0x72
	.word 0xecf42000  ! 6485: STXA_I	stxa	%r22, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 6486: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8ac0400  ! 6487: STBA_R	stba	%r20, [%r16 + %r0] 0x20
	mov	0x7d0, %r20
	.word 0x87802020  ! 6489: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2ace000  ! 6490: STBA_I	stba	%r17, [%r19 + 0x0000] %asi
	.word 0xeeb6c9e0  ! 6491: STHA_R	stha	%r23, [%r27 + %r0] 0x4f
	.word 0xe6d4e000  ! 6492: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r19
	.word 0xe6c4e000  ! 6493: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r19
	.word 0xe8cf0e80  ! 6494: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r20
	.word 0xe0cd04a0  ! 6495: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r16
	.word 0xeef42000  ! 6496: STXA_I	stxa	%r23, [%r16 + 0x0000] %asi
	.word 0xeeb44400  ! 6497: STHA_R	stha	%r23, [%r17 + %r0] 0x20
	.word 0xe8cc6000  ! 6498: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r20
	mov	0x50, %r25
	mov	0x60, %r24
	mov	0x3f8, %r21
	.word 0x87802020  ! 6502: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaf4c400  ! 6503: STXA_R	stxa	%r21, [%r19 + %r0] 0x20
	.word 0xe0d74e60  ! 6504: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r16
	.word 0x87802020  ! 6505: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0846000  ! 6506: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r16
	.word 0xe0b4e000  ! 6507: STHA_I	stha	%r16, [%r19 + 0x0000] %asi
	mov	0x18, %r17
	.word 0x8780204f  ! 6509: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f8, %r20
	.word 0xe0c7a000  ! 6511: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r16
	.word 0x87802020  ! 6512: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0aca000  ! 6513: STBA_I	stba	%r16, [%r18 + 0x0000] %asi
	.word 0xe094a000  ! 6514: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r16
	.word 0xe0cc6000  ! 6515: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r16
	.word 0xe8a48400  ! 6516: STWA_R	stwa	%r20, [%r18 + %r0] 0x20
	mov	0x30, %r17
	ta	T_CHANGE_PRIV	! macro
	ta	T_CHANGE_PRIV	! macro
	mov	0x48, %r16
	.word 0xe8874e40  ! 6521: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r20
	.word 0x87802020  ! 6522: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8f544a0  ! 6523: STXA_R	stxa	%r20, [%r21 + %r0] 0x25
	.word 0xec8f0e80  ! 6524: LDUBA_R	lduba	[%r28, %r0] 0x74, %r22
	mov	0x3d8, %r20
	.word 0xe2dd2000  ! 6526: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r17
	.word 0xe29de000  ! 6527: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r17
	.word 0xe2bd2000  ! 6528: STDA_I	stda	%r17, [%r20 + 0x0000] %asi
	.word 0xe2bf8e60  ! 6529: STDA_R	stda	%r17, [%r30 + %r0] 0x73
	.word 0xe8b56000  ! 6530: STHA_I	stha	%r20, [%r21 + 0x0000] %asi
	.word 0xe8bde000  ! 6531: STDA_I	stda	%r20, [%r23 + 0x0000] %asi
	.word 0xe29e49e0  ! 6532: LDDA_R	ldda	[%r25, %r0] 0x4f, %r17
	mov	0x3c8, %r21
	.word 0x87802020  ! 6534: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 6535: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d0, %r20
	mov	0x10, %r24
	.word 0xe2ac6000  ! 6538: STBA_I	stba	%r17, [%r17 + 0x0000] %asi
	.word 0xe2bc6000  ! 6539: STDA_I	stda	%r17, [%r17 + 0x0000] %asi
	.word 0xe2f4a000  ! 6540: STXA_I	stxa	%r17, [%r18 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xe8870e40  ! 6542: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r20
	.word 0x87802020  ! 6543: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeacde000  ! 6544: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r21
	.word 0xe8a689e0  ! 6545: STWA_R	stwa	%r20, [%r26 + %r0] 0x4f
	.word 0xe28d2000  ! 6546: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r17
	mov	0x78, %r27
	.word 0xeac5c4a0  ! 6548: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r21
	.word 0xe2cd2000  ! 6549: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r17
	mov	0x50, %r25
	.word 0xec8cc400  ! 6551: LDUBA_R	lduba	[%r19, %r0] 0x20, %r22
	.word 0xe6852000  ! 6552: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r19
	mov	0x60, %r18
	.word 0x8780204f  ! 6554: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe68c2000  ! 6555: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r19
	.word 0xe6b4e000  ! 6556: STHA_I	stha	%r19, [%r19 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xe69c2000  ! 6558: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r19
	.word 0xe68c2000  ! 6559: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r19
	.word 0xe6f4a000  ! 6560: STXA_I	stxa	%r19, [%r18 + 0x0000] %asi
	.word 0xe6dce000  ! 6561: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r19
	.word 0x87802025  ! 6562: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r19
	.word 0xe6bf6000  ! 6564: STDA_I	stda	%r19, [%r29 + 0x0000] %asi
	.word 0xe6c74e80  ! 6565: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r19
	mov	0x8, %r18
	.word 0xee97a000  ! 6567: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r23
	mov	0x3c8, %r21
	.word 0x8780204f  ! 6569: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 6570: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f8, %r22
	.word 0xe6cc0400  ! 6572: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r19
	.word 0xec8544a0  ! 6573: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r22
	.word 0xecd4a000  ! 6574: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r22
	.word 0xeccce000  ! 6575: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r22
	.word 0xe6b689e0  ! 6576: STHA_R	stha	%r19, [%r26 + %r0] 0x4f
	mov	0x58, %r16
	.word 0x87802073  ! 6578: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea852000  ! 6579: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r21
	.word 0x87802025  ! 6580: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xea9689e0  ! 6581: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r21
	.word 0xec8ca000  ! 6582: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r22
	.word 0x87802073  ! 6583: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeeafce40  ! 6584: STBA_R	stba	%r23, [%r31 + %r0] 0x72
	.word 0xe2970e60  ! 6585: LDUHA_R	lduha	[%r28, %r0] 0x73, %r17
	.word 0x87802074  ! 6586: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe0c52000  ! 6587: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r16
	.word 0x87802020  ! 6588: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 6589: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 6590: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r20
	mov	0x70, %r19
	.word 0xe8a44400  ! 6593: STWA_R	stwa	%r20, [%r17 + %r0] 0x20
	.word 0xe29ec9e0  ! 6594: LDDA_R	ldda	[%r27, %r0] 0x4f, %r17
	.word 0xe4dec9e0  ! 6595: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r18
	.word 0xe2c40400  ! 6596: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r17
	.word 0xe4a48400  ! 6597: STWA_R	stwa	%r18, [%r18 + %r0] 0x20
	.word 0xe6878e60  ! 6598: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r19
	.word 0x87802020  ! 6599: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r27
	mov	0x50, %r18
	.word 0xee976000  ! 6602: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r23
	.word 0xee97e000  ! 6603: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r23
	mov	0x40, %r18
	.word 0xeec7a000  ! 6605: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r23
	.word 0x87802020  ! 6606: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea8c4400  ! 6607: LDUBA_R	lduba	[%r17, %r0] 0x20, %r21
	.word 0x87802020  ! 6608: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r27
	.word 0xeac7e000  ! 6610: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r21
	mov	0x3d8, %r20
	mov	0x68, %r27
	.word 0xe09f4e80  ! 6613: LDDA_R	ldda	[%r29, %r0] 0x74, %r16
	.word 0x87802072  ! 6614: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2874e60  ! 6615: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r17
	.word 0x87802074  ! 6616: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeabde000  ! 6617: STDA_I	stda	%r21, [%r23 + 0x0000] %asi
	.word 0xea8d6000  ! 6618: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r21
	.word 0xe89e49e0  ! 6619: LDDA_R	ldda	[%r25, %r0] 0x4f, %r20
	.word 0xe8ade000  ! 6620: STBA_I	stba	%r20, [%r23 + 0x0000] %asi
	.word 0x87802073  ! 6621: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8f46000  ! 6622: STXA_I	stxa	%r20, [%r17 + 0x0000] %asi
	.word 0xe88c6000  ! 6623: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r20
	mov	0x7d8, %r21
	.word 0xe0bcc400  ! 6625: STDA_R	stda	%r16, [%r19 + %r0] 0x20
	.word 0xe0a4e000  ! 6626: STWA_I	stwa	%r16, [%r19 + 0x0000] %asi
	mov	0x40, %r18
	.word 0x87802073  ! 6628: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r18
	mov	0x7f0, %r21
	.word 0xe0bc2000  ! 6631: STDA_I	stda	%r16, [%r16 + 0x0000] %asi
	.word 0xe0d504a0  ! 6632: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r16
	mov	0x3e0, %r20
	.word 0xe8b544a0  ! 6634: STHA_R	stha	%r20, [%r21 + %r0] 0x25
	.word 0xeaccc400  ! 6635: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r21
	.word 0xe0c649e0  ! 6636: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r16
	.word 0xe8974e60  ! 6637: LDUHA_R	lduha	[%r29, %r0] 0x73, %r20
	.word 0xe8d4c400  ! 6638: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r20
	.word 0xeecf4e40  ! 6639: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r23
	.word 0xea9c6000  ! 6640: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r21
	mov	0x50, %r16
	mov	0x10, %r16
	.word 0xeabca000  ! 6643: STDA_I	stda	%r21, [%r18 + 0x0000] %asi
	.word 0xe2940400  ! 6644: LDUHA_R	lduha	[%r16, %r0] 0x20, %r17
	mov	0x10, %r26
	mov	0x28, %r19
	mov	0x3c8, %r22
	.word 0xeab4e000  ! 6648: STHA_I	stha	%r21, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 6649: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6be09e0  ! 6650: STDA_R	stda	%r19, [%r24 + %r0] 0x4f
	.word 0xecbcc400  ! 6651: STDA_R	stda	%r22, [%r19 + %r0] 0x20
	.word 0x87802020  ! 6652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea8f2000  ! 6653: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r21
	mov	0x78, %r16
	.word 0xe8b40400  ! 6655: STHA_R	stha	%r20, [%r16 + %r0] 0x20
	.word 0x87802073  ! 6656: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe4bea000  ! 6657: STDA_I	stda	%r18, [%r26 + 0x0000] %asi
	mov	0x10, %r26
	mov	0x50, %r16
	.word 0xe4962000  ! 6660: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r18
	.word 0xeacc4400  ! 6661: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r21
	.word 0x87802072  ! 6662: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8df0e40  ! 6663: LDXA_R	ldxa	[%r28, %r0] 0x72, %r20
	.word 0xea9f0e80  ! 6664: LDDA_R	ldda	[%r28, %r0] 0x74, %r21
	.word 0x87802025  ! 6665: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe09ca000  ! 6666: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r16
	.word 0x87802074  ! 6667: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r20
	.word 0xe097e000  ! 6669: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r16
	.word 0xe0d7a000  ! 6670: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r16
	mov	0x38, %r19
	mov	0x7c8, %r21
	.word 0xe0df2000  ! 6673: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r16
	.word 0xe0872000  ! 6674: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r16
	.word 0xe0cf6000  ! 6675: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r16
	mov	0x28, %r25
	mov	0x7d8, %r22
	.word 0xe0bf6000  ! 6678: STDA_I	stda	%r16, [%r29 + 0x0000] %asi
	.word 0xe0df2000  ! 6679: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r16
	mov	0x3c0, %r20
	.word 0xe6a40400  ! 6681: STWA_R	stwa	%r19, [%r16 + %r0] 0x20
	.word 0xe0cfa000  ! 6682: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r16
	.word 0xe09f6000  ! 6683: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r16
	mov	0x7e8, %r22
	.word 0xe08c0400  ! 6685: LDUBA_R	lduba	[%r16, %r0] 0x20, %r16
	.word 0xeead44a0  ! 6686: STBA_R	stba	%r23, [%r21 + %r0] 0x25
	.word 0xe48f6000  ! 6687: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r18
	mov	0x3f0, %r20
	.word 0xe4bf6000  ! 6689: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xe4bf6000  ! 6691: STDA_I	stda	%r18, [%r29 + 0x0000] %asi
	.word 0xe4b7e000  ! 6692: STHA_I	stha	%r18, [%r31 + 0x0000] %asi
	mov	0x38, %r27
	.word 0x87802025  ! 6694: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4a4e000  ! 6695: STWA_I	stwa	%r18, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 6696: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4df6000  ! 6697: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r18
	.word 0xeaa4c400  ! 6698: STWA_R	stwa	%r21, [%r19 + %r0] 0x20
	mov	0x10, %r24
	mov	0x48, %r16
	mov	0x7d8, %r22
	.word 0xe0bdc4a0  ! 6702: STDA_R	stda	%r16, [%r23 + %r0] 0x25
	.word 0xe8f4c400  ! 6703: STXA_R	stxa	%r20, [%r19 + %r0] 0x20
	.word 0xe6a7e000  ! 6704: STWA_I	stwa	%r19, [%r31 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xe8ce09e0  ! 6706: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r20
	.word 0xee976000  ! 6707: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r23
	.word 0xe2a544a0  ! 6708: STWA_R	stwa	%r17, [%r21 + %r0] 0x25
	.word 0xe2d78e80  ! 6709: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r17
	.word 0xe087e000  ! 6710: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r16
	.word 0xe0f78e60  ! 6711: STXA_R	stxa	%r16, [%r30 + %r0] 0x73
	.word 0xe8974e40  ! 6712: LDUHA_R	lduha	[%r29, %r0] 0x72, %r20
	.word 0xe487a000  ! 6713: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r18
	mov	0x10, %r25
	.word 0xe4b7a000  ! 6715: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	.word 0xe29f8e40  ! 6716: LDDA_R	ldda	[%r30, %r0] 0x72, %r17
	.word 0xe697a000  ! 6717: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r19
	.word 0xe6f72000  ! 6718: STXA_I	stxa	%r19, [%r28 + 0x0000] %asi
	.word 0xe6bfa000  ! 6719: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xe0a74e80  ! 6720: STWA_R	stwa	%r16, [%r29 + %r0] 0x74
	.word 0xeec76000  ! 6721: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r23
	.word 0x87802025  ! 6722: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8dc0400  ! 6723: LDXA_R	ldxa	[%r16, %r0] 0x20, %r20
	mov	0x10, %r24
	.word 0x87802025  ! 6725: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r17
	.word 0xeeada000  ! 6727: STBA_I	stba	%r23, [%r22 + 0x0000] %asi
	.word 0xeea52000  ! 6728: STWA_I	stwa	%r23, [%r20 + 0x0000] %asi
	.word 0xe0a70e80  ! 6729: STWA_R	stwa	%r16, [%r28 + %r0] 0x74
	mov	0x38, %r26
	.word 0xec9584a0  ! 6731: LDUHA_R	lduha	[%r22, %r0] 0x25, %r22
	mov	0x0, %r19
	.word 0xee8d44a0  ! 6733: LDUBA_R	lduba	[%r21, %r0] 0x25, %r23
	.word 0xe8f56000  ! 6734: STXA_I	stxa	%r20, [%r21 + 0x0000] %asi
	.word 0xe8bde000  ! 6735: STDA_I	stda	%r20, [%r23 + 0x0000] %asi
	.word 0xee8f4e40  ! 6736: LDUBA_R	lduba	[%r29, %r0] 0x72, %r23
	.word 0xe0944400  ! 6737: LDUHA_R	lduha	[%r17, %r0] 0x20, %r16
	.word 0xe6afce40  ! 6738: STBA_R	stba	%r19, [%r31 + %r0] 0x72
	mov	0x70, %r24
	mov	0x3c0, %r23
	mov	0x60, %r16
	.word 0xeaa70e60  ! 6742: STWA_R	stwa	%r21, [%r28 + %r0] 0x73
	.word 0xeedde000  ! 6743: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r23
	.word 0xe0b48400  ! 6744: STHA_R	stha	%r16, [%r18 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xeca649e0  ! 6746: STWA_R	stwa	%r22, [%r25 + %r0] 0x4f
	.word 0xe4f544a0  ! 6747: STXA_R	stxa	%r18, [%r21 + %r0] 0x25
	.word 0xe28da000  ! 6748: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r17
	mov	0x10, %r19
	.word 0xe09dc4a0  ! 6750: LDDA_R	ldda	[%r23, %r0] 0x25, %r16
	.word 0x87802073  ! 6751: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0972000  ! 6752: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r16
	.word 0x87802073  ! 6753: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r24
	mov	0x0, %r26
	.word 0xe0c74e60  ! 6756: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r16
	ta	T_CHANGE_PRIV	! macro
	.word 0x8780204f  ! 6758: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4f70e60  ! 6759: STXA_R	stxa	%r18, [%r28 + %r0] 0x73
	wr_tick_cmpr_3_54:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbb, %g2
	or	%g4, 0xb9, %g4
	or	%g6, 0xcd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x28, %r24
	.word 0xe6a48400  ! 6762: STWA_R	stwa	%r19, [%r18 + %r0] 0x20
	.word 0xe8bfe000  ! 6763: STDA_I	stda	%r20, [%r31 + 0x0000] %asi
	.word 0xe8afe000  ! 6764: STBA_I	stba	%r20, [%r31 + 0x0000] %asi
	.word 0xe6a5c4a0  ! 6765: STWA_R	stwa	%r19, [%r23 + %r0] 0x25
	.word 0xe4d78e60  ! 6766: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r18
	.word 0xecbec9e0  ! 6767: STDA_R	stda	%r22, [%r27 + %r0] 0x4f
	.word 0xe8a7a000  ! 6768: STWA_I	stwa	%r20, [%r30 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xe4ac4400  ! 6770: STBA_R	stba	%r18, [%r17 + %r0] 0x20
	.word 0x87802020  ! 6771: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r20
	.word 0xe6842000  ! 6773: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r19
	.word 0xeaaf0e80  ! 6774: STBA_R	stba	%r21, [%r28 + %r0] 0x74
	.word 0xe8af4e40  ! 6775: STBA_R	stba	%r20, [%r29 + %r0] 0x72
	.word 0xe2f4a000  ! 6776: STXA_I	stxa	%r17, [%r18 + 0x0000] %asi
	.word 0xe2d42000  ! 6777: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r17
	mov	0x10, %r18
	.word 0x87802074  ! 6779: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeeccc400  ! 6780: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r23
	.word 0xea9f0e80  ! 6781: LDDA_R	ldda	[%r28, %r0] 0x74, %r21
	.word 0xe6dfce80  ! 6782: LDXA_R	ldxa	[%r31, %r0] 0x74, %r19
	.word 0xecbf6000  ! 6783: STDA_I	stda	%r22, [%r29 + 0x0000] %asi
	.word 0xecd76000  ! 6784: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r22
	mov	0x10, %r19
	.word 0xec8fe000  ! 6786: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r22
	.word 0xe2b44400  ! 6787: STHA_R	stha	%r17, [%r17 + %r0] 0x20
	.word 0xeaa72000  ! 6788: STWA_I	stwa	%r21, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 6789: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r24
	mov	0x60, %r17
	.word 0x87802020  ! 6792: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r24
	.word 0xecf70e80  ! 6794: STXA_R	stxa	%r22, [%r28 + %r0] 0x74
	.word 0xe0f5c4a0  ! 6795: STXA_R	stxa	%r16, [%r23 + %r0] 0x25
	.word 0x87802020  ! 6796: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r20
	.word 0xe4a48400  ! 6798: STWA_R	stwa	%r18, [%r18 + %r0] 0x20
	.word 0x87802020  ! 6799: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 6800: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r23
	.word 0xe0a7ce40  ! 6802: STWA_R	stwa	%r16, [%r31 + %r0] 0x72
	.word 0xe28c4400  ! 6803: LDUBA_R	lduba	[%r17, %r0] 0x20, %r17
	.word 0xe2bfa000  ! 6804: STDA_I	stda	%r17, [%r30 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xe2b7a000  ! 6806: STHA_I	stha	%r17, [%r30 + 0x0000] %asi
	.word 0xeecc4400  ! 6807: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r23
	mov	0x70, %r19
	.word 0xecdf2000  ! 6809: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r22
	.word 0xecc76000  ! 6810: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0xecc76000  ! 6811: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r22
	.word 0xec87e000  ! 6812: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r22
	.word 0xec8fa000  ! 6813: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r22
	.word 0xecf7e000  ! 6814: STXA_I	stxa	%r22, [%r31 + 0x0000] %asi
	.word 0xecf76000  ! 6815: STXA_I	stxa	%r22, [%r29 + 0x0000] %asi
	.word 0xec97e000  ! 6816: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r22
	mov	0x70, %r27
	mov	0x68, %r16
	.word 0xeca72000  ! 6819: STWA_I	stwa	%r22, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 6820: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeeafce40  ! 6821: STBA_R	stba	%r23, [%r31 + %r0] 0x72
	.word 0xecbc4400  ! 6822: STDA_R	stda	%r22, [%r17 + %r0] 0x20
	.word 0xe0c7a000  ! 6823: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r16
	.word 0xe0df2000  ! 6824: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r16
	.word 0x87802025  ! 6825: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe0f42000  ! 6826: STXA_I	stxa	%r16, [%r16 + 0x0000] %asi
	mov	0x3c8, %r20
	mov	0x50, %r16
	mov	0x7e8, %r21
	mov	0x3c0, %r20
	.word 0x87802020  ! 6831: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2c70e40  ! 6832: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r17
	.word 0xe2dfa000  ! 6833: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r17
	.word 0x8780204f  ! 6834: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2b72000  ! 6835: STHA_I	stha	%r17, [%r28 + 0x0000] %asi
	.word 0xe2f7e000  ! 6836: STXA_I	stxa	%r17, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 6837: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2a74e80  ! 6838: STWA_R	stwa	%r17, [%r29 + %r0] 0x74
	.word 0xeadfce40  ! 6839: LDXA_R	ldxa	[%r31, %r0] 0x72, %r21
	.word 0xe0cd44a0  ! 6840: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r16
	.word 0xe484a000  ! 6841: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r18
	mov	0x20, %r18
	.word 0xe0f4c400  ! 6843: STXA_R	stxa	%r16, [%r19 + %r0] 0x20
	mov	0x7e0, %r20
	.word 0x87802020  ! 6845: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 6846: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea840400  ! 6847: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r21
	.word 0xe09ca000  ! 6848: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r16
	mov	0x40, %r17
	.word 0xe0b46000  ! 6850: STHA_I	stha	%r16, [%r17 + 0x0000] %asi
	.word 0xe4b7ce80  ! 6851: STHA_R	stha	%r18, [%r31 + %r0] 0x74
	.word 0xe294e000  ! 6852: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r17
	.word 0xeeb48400  ! 6853: STHA_R	stha	%r23, [%r18 + %r0] 0x20
	.word 0x87802020  ! 6854: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 6855: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xecb6e000  ! 6856: STHA_I	stha	%r22, [%r27 + 0x0000] %asi
	.word 0xe0a78e80  ! 6857: STWA_R	stwa	%r16, [%r30 + %r0] 0x74
	.word 0xe28504a0  ! 6858: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r17
	mov	0x0, %r24
	.word 0xec97ce60  ! 6860: LDUHA_R	lduha	[%r31, %r0] 0x73, %r22
	.word 0xe8862000  ! 6861: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r20
	.word 0xeea609e0  ! 6862: STWA_R	stwa	%r23, [%r24 + %r0] 0x4f
	.word 0xe8a6a000  ! 6863: STWA_I	stwa	%r20, [%r26 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xe4df0e60  ! 6865: LDXA_R	ldxa	[%r28, %r0] 0x73, %r18
	.word 0xe0afce80  ! 6866: STBA_R	stba	%r16, [%r31 + %r0] 0x74
	mov	0x18, %r17
	.word 0xe2a74e80  ! 6868: STWA_R	stwa	%r17, [%r29 + %r0] 0x74
	mov	0x48, %r17
	.word 0xe6c7ce80  ! 6870: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r19
	.word 0xe69e6000  ! 6871: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r19
	.word 0xe6f70e40  ! 6872: STXA_R	stxa	%r19, [%r28 + %r0] 0x72
	mov	0x78, %r17
	.word 0xeeaee000  ! 6874: STBA_I	stba	%r23, [%r27 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xeec6e000  ! 6876: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r23
	.word 0xe69f8e60  ! 6877: LDDA_R	ldda	[%r30, %r0] 0x73, %r19
	mov	0x3e8, %r23
	mov	0x8, %r24
	.word 0x87802073  ! 6880: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2af2000  ! 6881: STBA_I	stba	%r17, [%r28 + 0x0000] %asi
	.word 0xe2cf6000  ! 6882: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r17
	.word 0xe0bfce80  ! 6883: STDA_R	stda	%r16, [%r31 + %r0] 0x74
	mov	0x60, %r18
	.word 0xe48fe000  ! 6885: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r18
	.word 0xee9c4400  ! 6886: LDDA_R	ldda	[%r17, %r0] 0x20, %r23
	.word 0xe68fa000  ! 6887: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r19
	.word 0xe6b7e000  ! 6888: STHA_I	stha	%r19, [%r31 + 0x0000] %asi
	.word 0xec9fce40  ! 6889: LDDA_R	ldda	[%r31, %r0] 0x72, %r22
	.word 0xe4d76000  ! 6890: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r18
	mov	0x0, %r19
	.word 0xec85c4a0  ! 6892: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r22
	mov	0x30, %r27
	.word 0xe4df6000  ! 6894: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r18
	.word 0xe4d7e000  ! 6895: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r18
	.word 0x87802025  ! 6896: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 6897: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r24
	.word 0xe4ace000  ! 6899: STBA_I	stba	%r18, [%r19 + 0x0000] %asi
	mov	0x38, %r27
	mov	0x78, %r19
	.word 0xe4bc6000  ! 6902: STDA_I	stda	%r18, [%r17 + 0x0000] %asi
	mov	0x10, %r26
	mov	0x48, %r26
	.word 0xeab78e40  ! 6905: STHA_R	stha	%r21, [%r30 + %r0] 0x72
	.word 0xe6df0e40  ! 6906: LDXA_R	ldxa	[%r28, %r0] 0x72, %r19
	mov	0x60, %r19
	mov	0x7f0, %r21
	.word 0xe8b544a0  ! 6909: STHA_R	stha	%r20, [%r21 + %r0] 0x25
	.word 0xe88ca000  ! 6910: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r20
	.word 0xe4b7ce80  ! 6911: STHA_R	stha	%r18, [%r31 + %r0] 0x74
	.word 0x87802074  ! 6912: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe09f6000  ! 6913: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r16
	.word 0xe8c74e80  ! 6914: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r20
	.word 0x87802074  ! 6915: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe8c7e000  ! 6916: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r20
	.word 0xe8afe000  ! 6917: STBA_I	stba	%r20, [%r31 + 0x0000] %asi
	.word 0xe89fe000  ! 6918: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r20
	mov	0x30, %r27
	.word 0xe8cf6000  ! 6920: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r20
	.word 0xe8cf2000  ! 6921: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r20
	mov	0x7e8, %r21
	.word 0xe8f72000  ! 6923: STXA_I	stxa	%r20, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 6924: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8dc6000  ! 6925: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r20
	.word 0x87802020  ! 6926: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8dce000  ! 6927: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r20
	.word 0xecbe49e0  ! 6928: STDA_R	stda	%r22, [%r25 + %r0] 0x4f
	.word 0xea96c9e0  ! 6929: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r21
	.word 0xecf78e40  ! 6930: STXA_R	stxa	%r22, [%r30 + %r0] 0x72
	mov	0x10, %r26
	.word 0xe0bce000  ! 6932: STDA_I	stda	%r16, [%r19 + 0x0000] %asi
	.word 0xe0ace000  ! 6933: STBA_I	stba	%r16, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 6934: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe09ce000  ! 6935: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r16
	.word 0xe0f42000  ! 6936: STXA_I	stxa	%r16, [%r16 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xe0b46000  ! 6938: STHA_I	stha	%r16, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 6939: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 6940: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0f42000  ! 6941: STXA_I	stxa	%r16, [%r16 + 0x0000] %asi
	.word 0xe2b74e60  ! 6942: STHA_R	stha	%r17, [%r29 + %r0] 0x73
	.word 0xe68f0e40  ! 6943: LDUBA_R	lduba	[%r28, %r0] 0x72, %r19
	mov	0x38, %r17
	.word 0xeedc6000  ! 6945: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r23
	.word 0xe2b74e60  ! 6946: STHA_R	stha	%r17, [%r29 + %r0] 0x73
	.word 0xe2d4a000  ! 6947: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r17
	mov	0x28, %r27
	mov	0x8, %r17
	.word 0xeabf0e40  ! 6950: STDA_R	stda	%r21, [%r28 + %r0] 0x72
	.word 0xe284a000  ! 6951: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r17
	.word 0xe2b46000  ! 6952: STHA_I	stha	%r17, [%r17 + 0x0000] %asi
	.word 0xeadd44a0  ! 6953: LDXA_R	ldxa	[%r21, %r0] 0x25, %r21
	.word 0xecb4c400  ! 6954: STHA_R	stha	%r22, [%r19 + %r0] 0x20
	.word 0xe4bc6000  ! 6955: STDA_I	stda	%r18, [%r17 + 0x0000] %asi
	.word 0xeac74e80  ! 6956: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r21
	.word 0xe8dfce60  ! 6957: LDXA_R	ldxa	[%r31, %r0] 0x73, %r20
	.word 0xeeb4a000  ! 6958: STHA_I	stha	%r23, [%r18 + 0x0000] %asi
	.word 0xe287ce80  ! 6959: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r17
	.word 0xe6a40400  ! 6960: STWA_R	stwa	%r19, [%r16 + %r0] 0x20
	.word 0xe8dfce60  ! 6961: LDXA_R	ldxa	[%r31, %r0] 0x73, %r20
	.word 0x87802025  ! 6962: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecbea000  ! 6963: STDA_I	stda	%r22, [%r26 + 0x0000] %asi
	.word 0xeea74e40  ! 6964: STWA_R	stwa	%r23, [%r29 + %r0] 0x72
	.word 0xe6b66000  ! 6965: STHA_I	stha	%r19, [%r25 + 0x0000] %asi
	.word 0xe686e000  ! 6966: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r19
	mov	0x7c8, %r20
	.word 0xe6af0e40  ! 6968: STBA_R	stba	%r19, [%r28 + %r0] 0x72
	.word 0x87802025  ! 6969: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4d7e000  ! 6970: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r18
	.word 0xecd7ce80  ! 6971: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r22
	.word 0x8780204f  ! 6972: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8f48400  ! 6973: STXA_R	stxa	%r20, [%r18 + %r0] 0x20
	.word 0xe48f6000  ! 6974: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r18
	.word 0xe4de49e0  ! 6975: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r18
	.word 0xe0af4e40  ! 6976: STBA_R	stba	%r16, [%r29 + %r0] 0x72
	mov	0x0, %r27
	.word 0xe687e000  ! 6978: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r19
	mov	0x8, %r24
	mov	0x38, %r17
	mov	0x3d0, %r23
	.word 0x87802020  ! 6982: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	.word 0xe69da000  ! 6984: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r19
	.word 0xe6a5a000  ! 6985: STWA_I	stwa	%r19, [%r22 + 0x0000] %asi
	.word 0xe6ad44a0  ! 6986: STBA_R	stba	%r19, [%r21 + %r0] 0x25
	.word 0x87802073  ! 6987: WRASI_I	wr	%r0, 0x0073, %asi
	wr_tick_cmpr_3_55:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xab, %g2
	or	%g4, 0xb5, %g4
	or	%g6, 0xe7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe8f56000  ! 6989: STXA_I	stxa	%r20, [%r21 + 0x0000] %asi
	mov	0x68, %r25
	.word 0xeaa78e60  ! 6991: STWA_R	stwa	%r21, [%r30 + %r0] 0x73
	.word 0x87802073  ! 6992: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 6993: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeeac8400  ! 6994: STBA_R	stba	%r23, [%r18 + %r0] 0x20
	mov	0x7e0, %r21
	.word 0xe2b74e80  ! 6996: STHA_R	stha	%r17, [%r29 + %r0] 0x74
	.word 0xea9544a0  ! 6997: LDUHA_R	lduha	[%r21, %r0] 0x25, %r21
	.word 0x8780204f  ! 6998: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe48584a0  ! 6999: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r18
	.word 0x87802072  ! 7000: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe88fce80  ! 7001: LDUBA_R	lduba	[%r31, %r0] 0x74, %r20
	.word 0xee8d44a0  ! 7002: LDUBA_R	lduba	[%r21, %r0] 0x25, %r23
	.word 0xe2d44400  ! 7003: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r17
	.word 0xeef4e000  ! 7004: STXA_I	stxa	%r23, [%r19 + 0x0000] %asi
	.word 0xeebc2000  ! 7005: STDA_I	stda	%r23, [%r16 + 0x0000] %asi
	.word 0xeaaf4e80  ! 7006: STBA_R	stba	%r21, [%r29 + %r0] 0x74
	.word 0xecc44400  ! 7007: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r22
	mov	0x60, %r19
	.word 0xe6aca000  ! 7009: STBA_I	stba	%r19, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 7010: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4f78e40  ! 7011: STXA_R	stxa	%r18, [%r30 + %r0] 0x72
	mov	0x40, %r25
	.word 0xead4a000  ! 7013: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r21
	.word 0x87802072  ! 7014: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r27
	.word 0xeaaca000  ! 7016: STBA_I	stba	%r21, [%r18 + 0x0000] %asi
	.word 0xeca7ce80  ! 7017: STWA_R	stwa	%r22, [%r31 + %r0] 0x74
	mov	0x7e8, %r23
	.word 0xe6f42000  ! 7019: STXA_I	stxa	%r19, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 7020: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6afa000  ! 7021: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	.word 0xe6dfa000  ! 7022: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r19
	.word 0x8780204f  ! 7023: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r25
	.word 0xe28e89e0  ! 7025: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r17
	mov	0x70, %r27
	.word 0xea97e000  ! 7027: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r21
	.word 0xeaf72000  ! 7028: STXA_I	stxa	%r21, [%r28 + 0x0000] %asi
	.word 0xe69f4e60  ! 7029: LDDA_R	ldda	[%r29, %r0] 0x73, %r19
	.word 0xe8af6000  ! 7030: STBA_I	stba	%r20, [%r29 + 0x0000] %asi
	.word 0xe8af6000  ! 7031: STBA_I	stba	%r20, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 7032: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r25
	.word 0xe8c76000  ! 7034: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r20
	.word 0xe8af6000  ! 7035: STBA_I	stba	%r20, [%r29 + 0x0000] %asi
	.word 0xe8cfe000  ! 7036: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r20
	.word 0xe8b7e000  ! 7037: STHA_I	stha	%r20, [%r31 + 0x0000] %asi
	.word 0xe4a40400  ! 7038: STWA_R	stwa	%r18, [%r16 + %r0] 0x20
	.word 0xea97a000  ! 7039: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r21
	.word 0xe8ae89e0  ! 7040: STBA_R	stba	%r20, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 7041: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r21
	mov	0x3c0, %r23
	.word 0xe4f4a000  ! 7044: STXA_I	stxa	%r18, [%r18 + 0x0000] %asi
	.word 0xe6cf8e80  ! 7045: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r19
	.word 0xe8a46000  ! 7046: STWA_I	stwa	%r20, [%r17 + 0x0000] %asi
	mov	0x70, %r26
	.word 0x87802020  ! 7048: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe8d4e000  ! 7049: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r20
	.word 0xe89ec9e0  ! 7050: LDDA_R	ldda	[%r27, %r0] 0x4f, %r20
	.word 0xe2a4e000  ! 7051: STWA_I	stwa	%r17, [%r19 + 0x0000] %asi
	.word 0xe29ce000  ! 7052: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r17
	.word 0x87802020  ! 7053: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2bc2000  ! 7054: STDA_I	stda	%r17, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 7055: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2cde000  ! 7056: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r17
	.word 0xee8cc400  ! 7057: LDUBA_R	lduba	[%r19, %r0] 0x20, %r23
	.word 0xe4a56000  ! 7058: STWA_I	stwa	%r18, [%r21 + 0x0000] %asi
	.word 0xe48d2000  ! 7059: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r18
	.word 0xe4bf8e40  ! 7060: STDA_R	stda	%r18, [%r30 + %r0] 0x72
	.word 0x87802073  ! 7061: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 7062: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeaace000  ! 7063: STBA_I	stba	%r21, [%r19 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xea9ce000  ! 7065: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r21
	.word 0xeacc8400  ! 7066: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r21
	.word 0xe2bf0e40  ! 7067: STDA_R	stda	%r17, [%r28 + %r0] 0x72
	.word 0x87802074  ! 7068: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r19
	.word 0xe2bc8400  ! 7070: STDA_R	stda	%r17, [%r18 + %r0] 0x20
	.word 0xe29649e0  ! 7071: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r17
	.word 0x87802025  ! 7072: WRASI_I	wr	%r0, 0x0025, %asi
	wr_tick_cmpr_3_56:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xae, %g2
	or	%g4, 0xf3, %g4
	or	%g6, 0x92, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe88f0e40  ! 7074: LDUBA_R	lduba	[%r28, %r0] 0x72, %r20
	.word 0xecada000  ! 7075: STBA_I	stba	%r22, [%r22 + 0x0000] %asi
	.word 0xecbda000  ! 7076: STDA_I	stda	%r22, [%r22 + 0x0000] %asi
	.word 0xe2848400  ! 7077: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r17
	mov	0x58, %r16
	.word 0xe28de000  ! 7079: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r17
	mov	0x7f0, %r21
	.word 0xe28de000  ! 7081: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r17
	.word 0xe2a5e000  ! 7082: STWA_I	stwa	%r17, [%r23 + 0x0000] %asi
	.word 0xe2f5e000  ! 7083: STXA_I	stxa	%r17, [%r23 + 0x0000] %asi
	.word 0xe2b56000  ! 7084: STHA_I	stha	%r17, [%r21 + 0x0000] %asi
	.word 0xec8ec9e0  ! 7085: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r22
	.word 0xe2f56000  ! 7086: STXA_I	stxa	%r17, [%r21 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xeadec9e0  ! 7088: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r21
	.word 0xe6956000  ! 7089: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r19
	.word 0x87802072  ! 7090: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r16
	.word 0x8780204f  ! 7092: WRASI_I	wr	%r0, 0x004f, %asi
	wr_tick_cmpr_3_57:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf4, %g2
	or	%g4, 0xb8, %g4
	or	%g6, 0xde, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe69fe000  ! 7094: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r19
	mov	0x3d8, %r20
	.word 0xe6a76000  ! 7096: STWA_I	stwa	%r19, [%r29 + 0x0000] %asi
	.word 0xe68fa000  ! 7097: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r19
	.word 0xe2b4c400  ! 7098: STHA_R	stha	%r17, [%r19 + %r0] 0x20
	.word 0xec9609e0  ! 7099: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r22
	mov	0x7d8, %r20
	mov	0x70, %r26
	.word 0xe6944400  ! 7102: LDUHA_R	lduha	[%r17, %r0] 0x20, %r19
	.word 0xeca7a000  ! 7103: STWA_I	stwa	%r22, [%r30 + 0x0000] %asi
	.word 0xeca76000  ! 7104: STWA_I	stwa	%r22, [%r29 + 0x0000] %asi
	.word 0xec97e000  ! 7105: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r22
	.word 0xec8fa000  ! 7106: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r22
	.word 0xee8fce80  ! 7107: LDUBA_R	lduba	[%r31, %r0] 0x74, %r23
	.word 0x87802020  ! 7108: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe08d04a0  ! 7109: LDUBA_R	lduba	[%r20, %r0] 0x25, %r16
	mov	0x10, %r19
	.word 0xe0dd44a0  ! 7111: LDXA_R	ldxa	[%r21, %r0] 0x25, %r16
	.word 0xe09fe000  ! 7112: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r16
	mov	0x0, %r16
	.word 0x87802072  ! 7114: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7e0, %r23
	.word 0xe0bc2000  ! 7116: STDA_I	stda	%r16, [%r16 + 0x0000] %asi
	.word 0xe2a6c9e0  ! 7117: STWA_R	stwa	%r17, [%r27 + %r0] 0x4f
	mov	0x7e0, %r20
	.word 0xe0a4a000  ! 7119: STWA_I	stwa	%r16, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 7120: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 7121: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0f42000  ! 7122: STXA_I	stxa	%r16, [%r16 + 0x0000] %asi
	.word 0xe4f689e0  ! 7123: STXA_R	stxa	%r18, [%r26 + %r0] 0x4f
	mov	0x38, %r18
	mov	0x8, %r25
	.word 0xecc4e000  ! 7126: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r22
	.word 0xeeac4400  ! 7127: STBA_R	stba	%r23, [%r17 + %r0] 0x20
	.word 0xecc42000  ! 7128: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r22
	.word 0xecb42000  ! 7129: STHA_I	stha	%r22, [%r16 + 0x0000] %asi
	.word 0xe4afce80  ! 7130: STBA_R	stba	%r18, [%r31 + %r0] 0x74
	wr_tick_cmpr_3_58:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xcf, %g2
	or	%g4, 0xb9, %g4
	or	%g6, 0xd6, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x20, %r25
	.word 0xeed46000  ! 7133: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r23
	mov	0x7f0, %r22
	mov	0x28, %r16
	.word 0xeecca000  ! 7136: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r23
	.word 0x87802073  ! 7137: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2a70e40  ! 7138: STWA_R	stwa	%r17, [%r28 + %r0] 0x72
	.word 0xe8d66000  ! 7139: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r20
	.word 0xe8f62000  ! 7140: STXA_I	stxa	%r20, [%r24 + 0x0000] %asi
	.word 0xeeaf0e40  ! 7141: STBA_R	stba	%r23, [%r28 + %r0] 0x72
	.word 0xeedf0e80  ! 7142: LDXA_R	ldxa	[%r28, %r0] 0x74, %r23
	.word 0x87802074  ! 7143: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r23
	mov	0x3e8, %r20
	mov	0x20, %r24
	.word 0xe8df6000  ! 7147: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r20
	mov	0x7c0, %r21
	mov	0x0, %r16
	.word 0xe8af2000  ! 7150: STBA_I	stba	%r20, [%r28 + 0x0000] %asi
	.word 0xe8848400  ! 7151: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r20
	.word 0xe4c7e000  ! 7152: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r18
	.word 0x87802073  ! 7153: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe49fa000  ! 7154: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r18
	.word 0xe49fe000  ! 7155: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r18
	.word 0xeac78e60  ! 7156: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r21
	.word 0x87802073  ! 7157: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe8bc8400  ! 7158: STDA_R	stda	%r20, [%r18 + %r0] 0x20
	.word 0x87802074  ! 7159: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 7160: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeaaee000  ! 7161: STBA_I	stba	%r21, [%r27 + 0x0000] %asi
	.word 0xeaa6e000  ! 7162: STWA_I	stwa	%r21, [%r27 + 0x0000] %asi
	.word 0xe6f48400  ! 7163: STXA_R	stxa	%r19, [%r18 + %r0] 0x20
	mov	0x3e8, %r22
	.word 0x87802072  ! 7165: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0ae89e0  ! 7166: STBA_R	stba	%r16, [%r26 + %r0] 0x4f
	.word 0xee97a000  ! 7167: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r23
	.word 0x87802025  ! 7168: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r16
	.word 0xee862000  ! 7170: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r23
	.word 0xeaf78e40  ! 7171: STXA_R	stxa	%r21, [%r30 + %r0] 0x72
	mov	0x38, %r24
	mov	0x0, %r16
	.word 0xe2c6a000  ! 7174: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r17
	.word 0xe2be2000  ! 7175: STDA_I	stda	%r17, [%r24 + 0x0000] %asi
	.word 0xe6cf0e40  ! 7176: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r19
	.word 0xe88f4e60  ! 7177: LDUBA_R	lduba	[%r29, %r0] 0x73, %r20
	.word 0xee8ea000  ! 7178: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r23
	.word 0xe2f48400  ! 7179: STXA_R	stxa	%r17, [%r18 + %r0] 0x20
	.word 0xe6dc4400  ! 7180: LDXA_R	ldxa	[%r17, %r0] 0x20, %r19
	.word 0xeccf8e60  ! 7181: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r22
	.word 0xe2b62000  ! 7182: STHA_I	stha	%r17, [%r24 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xe6af0e80  ! 7184: STBA_R	stba	%r19, [%r28 + %r0] 0x74
	mov	0x40, %r24
	.word 0xeac62000  ! 7186: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r21
	.word 0xea8e6000  ! 7187: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r21
	.word 0xec9609e0  ! 7188: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r22
	.word 0xe08f8e60  ! 7189: LDUBA_R	lduba	[%r30, %r0] 0x73, %r16
	.word 0xe6aea000  ! 7190: STBA_I	stba	%r19, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 7191: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0f78e60  ! 7192: STXA_R	stxa	%r16, [%r30 + %r0] 0x73
	.word 0x87802020  ! 7193: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	.word 0x87802025  ! 7195: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r23
	.word 0xe2b4c400  ! 7197: STHA_R	stha	%r17, [%r19 + %r0] 0x20
	.word 0xee8e49e0  ! 7198: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r23
	mov	0x7f0, %r21
	.word 0x87802020  ! 7200: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4af6000  ! 7201: STBA_I	stba	%r18, [%r29 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xe6b40400  ! 7203: STHA_R	stha	%r19, [%r16 + %r0] 0x20
	.word 0xe0872000  ! 7204: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r16
	.word 0xe89f4e40  ! 7205: LDDA_R	ldda	[%r29, %r0] 0x72, %r20
	mov	0x7d0, %r21
	.word 0xe0c7ce80  ! 7207: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r16
	mov	0x7f0, %r22
	.word 0xecafa000  ! 7209: STBA_I	stba	%r22, [%r30 + 0x0000] %asi
	.word 0xe49f4e60  ! 7210: LDDA_R	ldda	[%r29, %r0] 0x73, %r18
	.word 0xe0be89e0  ! 7211: STDA_R	stda	%r16, [%r26 + %r0] 0x4f
	.word 0xe8b76000  ! 7212: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	.word 0xe8b76000  ! 7213: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	mov	0x3e0, %r21
	mov	0x3d8, %r21
	.word 0xea87ce60  ! 7216: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r21
	.word 0x87802074  ! 7217: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeade09e0  ! 7218: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r21
	.word 0xe6d6e000  ! 7219: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r19
	.word 0xe6f6e000  ! 7220: STXA_I	stxa	%r19, [%r27 + 0x0000] %asi
	.word 0xe2f78e60  ! 7221: STXA_R	stxa	%r17, [%r30 + %r0] 0x73
	mov	0x68, %r24
	.word 0xeea74e80  ! 7223: STWA_R	stwa	%r23, [%r29 + %r0] 0x74
	.word 0xeacd44a0  ! 7224: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r21
	.word 0x8780204f  ! 7225: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r23
	.word 0xe6f7ce80  ! 7227: STXA_R	stxa	%r19, [%r31 + %r0] 0x74
	.word 0x87802073  ! 7228: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe684c400  ! 7229: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r19
	.word 0x87802025  ! 7230: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2be2000  ! 7231: STDA_I	stda	%r17, [%r24 + 0x0000] %asi
	mov	0x38, %r17
	.word 0x87802020  ! 7233: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeedf4e40  ! 7234: LDXA_R	ldxa	[%r29, %r0] 0x72, %r23
	.word 0x87802020  ! 7235: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecf40400  ! 7236: STXA_R	stxa	%r22, [%r16 + %r0] 0x20
	.word 0xe6aca000  ! 7237: STBA_I	stba	%r19, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 7238: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r19
	.word 0xe6ad84a0  ! 7240: STBA_R	stba	%r19, [%r22 + %r0] 0x25
	.word 0xe0d74e60  ! 7241: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r16
	mov	0x3d0, %r20
	.word 0xe0a46000  ! 7243: STWA_I	stwa	%r16, [%r17 + 0x0000] %asi
	.word 0xe0848400  ! 7244: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r16
	.word 0x87802025  ! 7245: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe4f7ce80  ! 7246: STXA_R	stxa	%r18, [%r31 + %r0] 0x74
	.word 0xeaac8400  ! 7247: STBA_R	stba	%r21, [%r18 + %r0] 0x20
	mov	0x20, %r24
	mov	0x70, %r18
	mov	0x18, %r26
	.word 0xe2bf0e40  ! 7251: STDA_R	stda	%r17, [%r28 + %r0] 0x72
	.word 0x87802072  ! 7252: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2bd2000  ! 7253: STDA_I	stda	%r17, [%r20 + 0x0000] %asi
	mov	0x48, %r16
	.word 0xecb7ce40  ! 7255: STHA_R	stha	%r22, [%r31 + %r0] 0x72
	.word 0xeac78e80  ! 7256: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r21
	.word 0xe6dd84a0  ! 7257: LDXA_R	ldxa	[%r22, %r0] 0x25, %r19
	.word 0xe695a000  ! 7258: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r19
	.word 0xeccc8400  ! 7259: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r22
	.word 0xe28da000  ! 7260: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r17
	mov	0x8, %r24
	.word 0xe28c8400  ! 7262: LDUBA_R	lduba	[%r18, %r0] 0x20, %r17
	.word 0x87802020  ! 7263: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaa78e80  ! 7264: STWA_R	stwa	%r21, [%r30 + %r0] 0x74
	.word 0xe4f70e40  ! 7265: STXA_R	stxa	%r18, [%r28 + %r0] 0x72
	.word 0xeeb7a000  ! 7266: STHA_I	stha	%r23, [%r30 + 0x0000] %asi
	mov	0x48, %r25
	mov	0x58, %r16
	.word 0x87802073  ! 7269: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2ac0400  ! 7270: STBA_R	stba	%r17, [%r16 + %r0] 0x20
	.word 0xe4bf8e60  ! 7271: STDA_R	stda	%r18, [%r30 + %r0] 0x73
	.word 0x87802025  ! 7272: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3c8, %r21
	.word 0xe6f4a000  ! 7274: STXA_I	stxa	%r19, [%r18 + 0x0000] %asi
	.word 0xecdf0e80  ! 7275: LDXA_R	ldxa	[%r28, %r0] 0x74, %r22
	.word 0xeca4e000  ! 7276: STWA_I	stwa	%r22, [%r19 + 0x0000] %asi
	.word 0xec8ce000  ! 7277: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r22
	.word 0xeeb4c400  ! 7278: STHA_R	stha	%r23, [%r19 + %r0] 0x20
	.word 0x87802020  ! 7279: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecde09e0  ! 7280: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r22
	.word 0xe0af0e40  ! 7281: STBA_R	stba	%r16, [%r28 + %r0] 0x72
	mov	0x50, %r19
	mov	0x48, %r19
	.word 0x87802072  ! 7284: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeadde000  ! 7285: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r21
	.word 0xec9544a0  ! 7286: LDUHA_R	lduha	[%r21, %r0] 0x25, %r22
	.word 0xe48609e0  ! 7287: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r18
	mov	0x30, %r27
	.word 0xe8a7ce40  ! 7289: STWA_R	stwa	%r20, [%r31 + %r0] 0x72
	.word 0xeeae89e0  ! 7290: STBA_R	stba	%r23, [%r26 + %r0] 0x4f
	mov	0x8, %r24
	.word 0xeacde000  ! 7292: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r21
	.word 0xe497ce80  ! 7293: LDUHA_R	lduha	[%r31, %r0] 0x74, %r18
	.word 0xe0f5e000  ! 7294: STXA_I	stxa	%r16, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 7295: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2bf8e80  ! 7296: STDA_R	stda	%r17, [%r30 + %r0] 0x74
	mov	0x7d8, %r20
	.word 0x8780204f  ! 7298: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6ce6000  ! 7299: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r19
	.word 0xe88ec9e0  ! 7300: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r20
	.word 0xeccee000  ! 7301: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r22
	mov	0x38, %r27
	mov	0x28, %r19
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe2a544a0  ! 7305: STWA_R	stwa	%r17, [%r21 + %r0] 0x25
	.word 0xe4cee000  ! 7306: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r18
	.word 0x87802020  ! 7307: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r26
	.word 0xe0f70e60  ! 7309: STXA_R	stxa	%r16, [%r28 + %r0] 0x73
	.word 0xee870e60  ! 7310: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r23
	mov	0x3d0, %r23
	.word 0xe6a76000  ! 7312: STWA_I	stwa	%r19, [%r29 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xecb74e80  ! 7314: STHA_R	stha	%r22, [%r29 + %r0] 0x74
	mov	0x78, %r24
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802073  ! 7317: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeacee000  ! 7318: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r21
	.word 0xec9c0400  ! 7319: LDDA_R	ldda	[%r16, %r0] 0x20, %r22
	.word 0xe6b6e000  ! 7320: STHA_I	stha	%r19, [%r27 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xe6ce2000  ! 7322: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r19
	.word 0x87802020  ! 7323: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 7324: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6b76000  ! 7325: STHA_I	stha	%r19, [%r29 + 0x0000] %asi
	mov	0x50, %r27
	.word 0x87802074  ! 7327: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe295c4a0  ! 7328: LDUHA_R	lduha	[%r23, %r0] 0x25, %r17
	.word 0xe28f4e80  ! 7329: LDUBA_R	lduba	[%r29, %r0] 0x74, %r17
	.word 0xe8a46000  ! 7330: STWA_I	stwa	%r20, [%r17 + 0x0000] %asi
	mov	0x18, %r16
	.word 0xe8d4a000  ! 7332: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r20
	.word 0xe8b4e000  ! 7333: STHA_I	stha	%r20, [%r19 + 0x0000] %asi
	.word 0xe89c2000  ! 7334: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r20
	.word 0x87802020  ! 7335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2dec9e0  ! 7336: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r17
	.word 0xee846000  ! 7337: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r23
	mov	0x60, %r17
	.word 0xee8f4e40  ! 7339: LDUBA_R	lduba	[%r29, %r0] 0x72, %r23
	.word 0xe6bc0400  ! 7340: STDA_R	stda	%r19, [%r16 + %r0] 0x20
	.word 0xeed544a0  ! 7341: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r23
	mov	0x7f0, %r23
	.word 0xe6b70e60  ! 7343: STHA_R	stha	%r19, [%r28 + %r0] 0x73
	.word 0x87802025  ! 7344: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r20
	.word 0xe8b70e60  ! 7346: STHA_R	stha	%r20, [%r28 + %r0] 0x73
	.word 0xe8bf8e60  ! 7347: STDA_R	stda	%r20, [%r30 + %r0] 0x73
	.word 0xe486e000  ! 7348: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r18
	.word 0xecbc8400  ! 7349: STDA_R	stda	%r22, [%r18 + %r0] 0x20
	.word 0xe8ce09e0  ! 7350: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r20
	.word 0x87802020  ! 7351: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea87e000  ! 7352: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r21
	.word 0xeaf72000  ! 7353: STXA_I	stxa	%r21, [%r28 + 0x0000] %asi
	mov	0x38, %r24
	mov	0x3e0, %r22
	mov	0x40, %r26
	.word 0xeadf6000  ! 7357: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r21
	.word 0xeabf2000  ! 7358: STDA_I	stda	%r21, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 7359: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeaf4a000  ! 7360: STXA_I	stxa	%r21, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 7361: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r16
	.word 0xeaf7a000  ! 7363: STXA_I	stxa	%r21, [%r30 + 0x0000] %asi
	mov	0x78, %r17
	.word 0xeaa7e000  ! 7365: STWA_I	stwa	%r21, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 7366: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r22
	mov	0x40, %r26
	.word 0xe6a5c4a0  ! 7369: STWA_R	stwa	%r19, [%r23 + %r0] 0x25
	.word 0xe4cc2000  ! 7370: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r18
	mov	0x38, %r18
	.word 0xe494a000  ! 7372: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r18
	.word 0xe6d504a0  ! 7373: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r19
	.word 0xe0f7ce80  ! 7374: STXA_R	stxa	%r16, [%r31 + %r0] 0x74
	.word 0xe2ac6000  ! 7375: STBA_I	stba	%r17, [%r17 + 0x0000] %asi
	.word 0xe2d4a000  ! 7376: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r17
	.word 0xeea7ce60  ! 7377: STWA_R	stwa	%r23, [%r31 + %r0] 0x73
	mov	0x7f0, %r22
	.word 0xe884e000  ! 7379: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r20
	mov	0x30, %r17
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xe086c9e0  ! 7382: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r16
	.word 0xeaa46000  ! 7383: STWA_I	stwa	%r21, [%r17 + 0x0000] %asi
	mov	0x8, %r24
	.word 0x8780204f  ! 7385: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 7386: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea972000  ! 7387: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r21
	.word 0x87802073  ! 7388: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xea846000  ! 7389: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r21
	.word 0xeab46000  ! 7390: STHA_I	stha	%r21, [%r17 + 0x0000] %asi
	.word 0xee8c4400  ! 7391: LDUBA_R	lduba	[%r17, %r0] 0x20, %r23
	.word 0xeecce000  ! 7392: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r23
	.word 0xe2bec9e0  ! 7393: STDA_R	stda	%r17, [%r27 + %r0] 0x4f
	ta	T_CHANGE_PRIV	! macro
	.word 0xeac78e80  ! 7395: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r21
	.word 0xe8afce80  ! 7396: STBA_R	stba	%r20, [%r31 + %r0] 0x74
	.word 0xe897ce80  ! 7397: LDUHA_R	lduha	[%r31, %r0] 0x74, %r20
	.word 0xe8f48400  ! 7398: STXA_R	stxa	%r20, [%r18 + %r0] 0x20
	.word 0xeca609e0  ! 7399: STWA_R	stwa	%r22, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 7400: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecb609e0  ! 7401: STHA_R	stha	%r22, [%r24 + %r0] 0x4f
	.word 0xeeae89e0  ! 7402: STBA_R	stba	%r23, [%r26 + %r0] 0x4f
	.word 0xee9d44a0  ! 7403: LDDA_R	ldda	[%r21, %r0] 0x25, %r23
	.word 0xe08ca000  ! 7404: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r16
	.word 0xe0f46000  ! 7405: STXA_I	stxa	%r16, [%r17 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xe2f78e80  ! 7407: STXA_R	stxa	%r17, [%r30 + %r0] 0x74
	.word 0xe4bce000  ! 7408: STDA_I	stda	%r18, [%r19 + 0x0000] %asi
	.word 0xec8ec9e0  ! 7409: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r22
	.word 0xe0f4e000  ! 7410: STXA_I	stxa	%r16, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 7411: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r23
	mov	0x40, %r25
	.word 0xe0f72000  ! 7414: STXA_I	stxa	%r16, [%r28 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xe8acc400  ! 7416: STBA_R	stba	%r20, [%r19 + %r0] 0x20
	.word 0xeea72000  ! 7417: STWA_I	stwa	%r23, [%r28 + 0x0000] %asi
	mov	0x30, %r27
	.word 0x87802074  ! 7419: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r27
	mov	0x58, %r17
	.word 0xeea66000  ! 7422: STWA_I	stwa	%r23, [%r25 + 0x0000] %asi
	mov	0x38, %r19
	mov	0x8, %r17
	.word 0xeeb66000  ! 7425: STHA_I	stha	%r23, [%r25 + 0x0000] %asi
	.word 0xeea62000  ! 7426: STWA_I	stwa	%r23, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 7427: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeeb56000  ! 7428: STHA_I	stha	%r23, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 7429: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r18
	.word 0xe4970e80  ! 7431: LDUHA_R	lduha	[%r28, %r0] 0x74, %r18
	.word 0xe2a584a0  ! 7432: STWA_R	stwa	%r17, [%r22 + %r0] 0x25
	mov	0x7f0, %r20
	.word 0xeabc8400  ! 7434: STDA_R	stda	%r21, [%r18 + %r0] 0x20
	.word 0xe0b4a000  ! 7435: STHA_I	stha	%r16, [%r18 + 0x0000] %asi
	.word 0xe0b46000  ! 7436: STHA_I	stha	%r16, [%r17 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xe8af0e40  ! 7438: STBA_R	stba	%r20, [%r28 + %r0] 0x72
	.word 0x87802073  ! 7439: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6bf8e40  ! 7440: STDA_R	stda	%r19, [%r30 + %r0] 0x72
	.word 0xe8f78e60  ! 7441: STXA_R	stxa	%r20, [%r30 + %r0] 0x73
	mov	0x3f0, %r21
	.word 0xecb7a000  ! 7443: STHA_I	stha	%r22, [%r30 + 0x0000] %asi
	.word 0xec976000  ! 7444: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r22
	.word 0xe4cfce60  ! 7445: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r18
	.word 0xe69e49e0  ! 7446: LDDA_R	ldda	[%r25, %r0] 0x4f, %r19
	wr_tick_cmpr_3_59:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xf6, %g2
	or	%g4, 0x91, %g4
	or	%g6, 0xbc, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe6c76000  ! 7448: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r19
	.word 0xe29dc4a0  ! 7449: LDDA_R	ldda	[%r23, %r0] 0x25, %r17
	.word 0xe0bf6000  ! 7450: STDA_I	stda	%r16, [%r29 + 0x0000] %asi
	.word 0xe0af0e40  ! 7451: STBA_R	stba	%r16, [%r28 + %r0] 0x72
	mov	0x3c0, %r20
	mov	0x48, %r18
	.word 0xe6874e80  ! 7454: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r19
	.word 0xe8c7a000  ! 7455: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r20
	.word 0x87802025  ! 7456: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xecbd04a0  ! 7457: STDA_R	stda	%r22, [%r20 + %r0] 0x25
	.word 0xe4866000  ! 7458: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r18
	.word 0xe4dee000  ! 7459: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r18
	.word 0xeab4c400  ! 7460: STHA_R	stha	%r21, [%r19 + %r0] 0x20
	.word 0xec8e2000  ! 7461: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r22
	.word 0xec8ee000  ! 7462: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r22
	.word 0xeed70e40  ! 7463: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r23
	.word 0xeaa4c400  ! 7464: STWA_R	stwa	%r21, [%r19 + %r0] 0x20
	mov	0x60, %r27
	.word 0xe6874e60  ! 7466: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r19
	.word 0xea96a000  ! 7467: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r21
	.word 0xeebdc4a0  ! 7468: STDA_R	stda	%r23, [%r23 + %r0] 0x25
	.word 0xeacd44a0  ! 7469: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r21
	ta	T_CHANGE_HPRIV	! macro
	mov	0x58, %r18
	mov	0x0, %r16
	.word 0xe6a44400  ! 7473: STWA_R	stwa	%r19, [%r17 + %r0] 0x20
	.word 0xeacf4e80  ! 7474: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r21
	.word 0xe6be6000  ! 7475: STDA_I	stda	%r19, [%r25 + 0x0000] %asi
	.word 0xe6862000  ! 7476: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r19
	.word 0xe89d44a0  ! 7477: LDDA_R	ldda	[%r21, %r0] 0x25, %r20
	.word 0xe4ac8400  ! 7478: STBA_R	stba	%r18, [%r18 + %r0] 0x20
	.word 0x87802020  ! 7479: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2d56000  ! 7480: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r17
	.word 0xe2f5e000  ! 7481: STXA_I	stxa	%r17, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 7482: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2ce2000  ! 7483: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r17
	.word 0xecf44400  ! 7484: STXA_R	stxa	%r22, [%r17 + %r0] 0x20
	.word 0xe8f40400  ! 7485: STXA_R	stxa	%r20, [%r16 + %r0] 0x20
	.word 0x87802025  ! 7486: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe6b40400  ! 7487: STHA_R	stha	%r19, [%r16 + %r0] 0x20
	.word 0xe0bf2000  ! 7488: STDA_I	stda	%r16, [%r28 + 0x0000] %asi
	mov	0x68, %r26
	mov	0x30, %r17
	.word 0xe0d7a000  ! 7491: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r16
	.word 0xe09fe000  ! 7492: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r16
	mov	0x7e8, %r23
	.word 0xeca74e40  ! 7494: STWA_R	stwa	%r22, [%r29 + %r0] 0x72
	.word 0x8780204f  ! 7495: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r24
	mov	0x78, %r26
	mov	0x7f8, %r20
	.word 0xe696c9e0  ! 7499: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r19
	.word 0xe8c5c4a0  ! 7500: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r20
	.word 0xe0dfa000  ! 7501: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r16
	.word 0xe8a5c4a0  ! 7502: STWA_R	stwa	%r20, [%r23 + %r0] 0x25
	.word 0xe2f5c4a0  ! 7503: STXA_R	stxa	%r17, [%r23 + %r0] 0x25
	.word 0x87802020  ! 7504: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 7505: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r17
	.word 0xeea40400  ! 7507: STWA_R	stwa	%r23, [%r16 + %r0] 0x20
	mov	0x68, %r24
	.word 0x87802025  ! 7509: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r26
	.word 0x87802025  ! 7511: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r23
	.word 0x87802020  ! 7513: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r23
	.word 0xe2f7ce40  ! 7515: STXA_R	stxa	%r17, [%r31 + %r0] 0x72
	.word 0xe4b5a000  ! 7516: STHA_I	stha	%r18, [%r22 + 0x0000] %asi
	.word 0xe4c56000  ! 7517: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r18
	.word 0x8780204f  ! 7518: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 7519: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe4b4e000  ! 7520: STHA_I	stha	%r18, [%r19 + 0x0000] %asi
	.word 0xe4df8e60  ! 7521: LDXA_R	ldxa	[%r30, %r0] 0x73, %r18
	mov	0x7e0, %r23
	.word 0xe8f74e60  ! 7523: STXA_R	stxa	%r20, [%r29 + %r0] 0x73
	.word 0xeea42000  ! 7524: STWA_I	stwa	%r23, [%r16 + 0x0000] %asi
	.word 0xee9c2000  ! 7525: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r23
	.word 0xe28fce80  ! 7526: LDUBA_R	lduba	[%r31, %r0] 0x74, %r17
	.word 0x87802020  ! 7527: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 7528: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r17
	.word 0xeac76000  ! 7530: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r21
	.word 0xeaa7a000  ! 7531: STWA_I	stwa	%r21, [%r30 + 0x0000] %asi
	.word 0xe6d78e40  ! 7532: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r19
	.word 0xe6f7ce40  ! 7533: STXA_R	stxa	%r19, [%r31 + %r0] 0x72
	mov	0x10, %r17
	.word 0xe4df6000  ! 7535: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r18
	.word 0xe2ac8400  ! 7536: STBA_R	stba	%r17, [%r18 + %r0] 0x20
	mov	0x7f8, %r20
	.word 0x87802025  ! 7538: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8bfe000  ! 7539: STDA_I	stda	%r20, [%r31 + 0x0000] %asi
	.word 0xe8972000  ! 7540: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r20
	.word 0xe8df2000  ! 7541: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r20
	mov	0x30, %r19
	mov	0x7c8, %r21
	.word 0xe2b5c4a0  ! 7544: STHA_R	stha	%r17, [%r23 + %r0] 0x25
	mov	0x10, %r19
	.word 0xe0cc4400  ! 7546: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r16
	.word 0xeeafa000  ! 7547: STBA_I	stba	%r23, [%r30 + 0x0000] %asi
	.word 0xeeafa000  ! 7548: STBA_I	stba	%r23, [%r30 + 0x0000] %asi
	.word 0xe8cf8e60  ! 7549: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r20
	.word 0xe4ad44a0  ! 7550: STBA_R	stba	%r18, [%r21 + %r0] 0x25
	mov	0x7c8, %r20
	mov	0x60, %r16
	.word 0xe4f544a0  ! 7553: STXA_R	stxa	%r18, [%r21 + %r0] 0x25
	.word 0xe8bfa000  ! 7554: STDA_I	stda	%r20, [%r30 + 0x0000] %asi
	.word 0xecf74e80  ! 7555: STXA_R	stxa	%r22, [%r29 + %r0] 0x74
	mov	0x3c8, %r23
	wr_tick_cmpr_3_60:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x83, %g2
	or	%g4, 0xaf, %g4
	or	%g6, 0xd0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe6bfe000  ! 7558: STDA_I	stda	%r19, [%r31 + 0x0000] %asi
	.word 0xe6afa000  ! 7559: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	.word 0xe6bf6000  ! 7560: STDA_I	stda	%r19, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 7561: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6b4e000  ! 7562: STHA_I	stha	%r19, [%r19 + 0x0000] %asi
	.word 0xe88f0e80  ! 7563: LDUBA_R	lduba	[%r28, %r0] 0x74, %r20
	.word 0xecdc6000  ! 7564: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r22
	mov	0x68, %r25
	mov	0x28, %r27
	.word 0xecac6000  ! 7567: STBA_I	stba	%r22, [%r17 + 0x0000] %asi
	.word 0xeea74e80  ! 7568: STWA_R	stwa	%r23, [%r29 + %r0] 0x74
	.word 0xee8ce000  ! 7569: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r23
	.word 0xeaf74e40  ! 7570: STXA_R	stxa	%r21, [%r29 + %r0] 0x72
	mov	0x60, %r19
	mov	0x10, %r25
	.word 0xecbc2000  ! 7573: STDA_I	stda	%r22, [%r16 + 0x0000] %asi
	.word 0xec84e000  ! 7574: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r22
	.word 0xecafce80  ! 7575: STBA_R	stba	%r22, [%r31 + %r0] 0x74
	.word 0xec84a000  ! 7576: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r22
	.word 0xee97ce40  ! 7577: LDUHA_R	lduha	[%r31, %r0] 0x72, %r23
	.word 0xeab504a0  ! 7578: STHA_R	stha	%r21, [%r20 + %r0] 0x25
	mov	0x7f0, %r20
	.word 0xe6ac6000  ! 7580: STBA_I	stba	%r19, [%r17 + 0x0000] %asi
	.word 0xe69c2000  ! 7581: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r19
	.word 0xe6c46000  ! 7582: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r19
	.word 0xe6946000  ! 7583: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r19
	mov	0x68, %r18
	mov	0x20, %r16
	mov	0x78, %r19
	.word 0xe68ca000  ! 7587: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r19
	mov	0x10, %r27
	mov	0x3d8, %r21
	.word 0xe6aca000  ! 7590: STBA_I	stba	%r19, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 7591: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe6876000  ! 7592: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r19
	.word 0xe6afe000  ! 7593: STBA_I	stba	%r19, [%r31 + 0x0000] %asi
	.word 0xe2d40400  ! 7594: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r17
	.word 0xeeb72000  ! 7595: STHA_I	stha	%r23, [%r28 + 0x0000] %asi
	.word 0xee972000  ! 7596: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r23
	.word 0x87802072  ! 7597: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2974e60  ! 7598: LDUHA_R	lduha	[%r29, %r0] 0x73, %r17
	.word 0x87802072  ! 7599: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2940400  ! 7600: LDUHA_R	lduha	[%r16, %r0] 0x20, %r17
	mov	0x38, %r17
	.word 0xe4b4c400  ! 7602: STHA_R	stha	%r18, [%r19 + %r0] 0x20
	.word 0xe4b7e000  ! 7603: STHA_I	stha	%r18, [%r31 + 0x0000] %asi
	.word 0xe48fe000  ! 7604: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r18
	.word 0xe49f6000  ! 7605: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r18
	.word 0x87802020  ! 7606: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 7607: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeaa544a0  ! 7608: STWA_R	stwa	%r21, [%r21 + %r0] 0x25
	.word 0xe2afe000  ! 7609: STBA_I	stba	%r17, [%r31 + 0x0000] %asi
	.word 0xe2f72000  ! 7610: STXA_I	stxa	%r17, [%r28 + 0x0000] %asi
	.word 0xe29f6000  ! 7611: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r17
	.word 0x8780204f  ! 7612: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe2b66000  ! 7613: STHA_I	stha	%r17, [%r25 + 0x0000] %asi
	.word 0xeeb4c400  ! 7614: STHA_R	stha	%r23, [%r19 + %r0] 0x20
	.word 0xe8bc0400  ! 7615: STDA_R	stda	%r20, [%r16 + %r0] 0x20
	mov	0x38, %r19
	.word 0x87802020  ! 7617: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r18
	.word 0xecb44400  ! 7619: STHA_R	stha	%r22, [%r17 + %r0] 0x20
	.word 0xecd7ce40  ! 7620: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r22
	.word 0xe6f70e80  ! 7621: STXA_R	stxa	%r19, [%r28 + %r0] 0x74
	mov	0x3c8, %r21
	.word 0xe09fce60  ! 7623: LDDA_R	ldda	[%r31, %r0] 0x73, %r16
	.word 0xee96c9e0  ! 7624: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r23
	.word 0xe4bf4e80  ! 7625: STDA_R	stda	%r18, [%r29 + %r0] 0x74
	.word 0xecbc2000  ! 7626: STDA_I	stda	%r22, [%r16 + 0x0000] %asi
	.word 0xe29c4400  ! 7627: LDDA_R	ldda	[%r17, %r0] 0x20, %r17
	.word 0xe6cfce80  ! 7628: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r19
	mov	0x18, %r26
	.word 0xe6a4e000  ! 7630: STWA_I	stwa	%r19, [%r19 + 0x0000] %asi
	mov	0x68, %r27
	mov	0x3e8, %r20
	.word 0xe4a78e80  ! 7633: STWA_R	stwa	%r18, [%r30 + %r0] 0x74
	.word 0xeed78e80  ! 7634: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r23
	.word 0xe68504a0  ! 7635: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r19
	.word 0x87802074  ! 7636: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe6bd2000  ! 7637: STDA_I	stda	%r19, [%r20 + 0x0000] %asi
	.word 0xecaf4e80  ! 7638: STBA_R	stba	%r22, [%r29 + %r0] 0x74
	.word 0xe2cd2000  ! 7639: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r17
	.word 0xe2a584a0  ! 7640: STWA_R	stwa	%r17, [%r22 + %r0] 0x25
	wr_tick_cmpr_3_61:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa4, %g2
	or	%g4, 0xe1, %g4
	or	%g6, 0xcf, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x28, %r19
	.word 0xeaa40400  ! 7643: STWA_R	stwa	%r21, [%r16 + %r0] 0x20
	.word 0xeab56000  ! 7644: STHA_I	stha	%r21, [%r21 + 0x0000] %asi
	.word 0xe4bd84a0  ! 7645: STDA_R	stda	%r18, [%r22 + %r0] 0x25
	.word 0xe4dec9e0  ! 7646: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r18
	.word 0x8780204f  ! 7647: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe6a7a000  ! 7648: STWA_I	stwa	%r19, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 7649: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r25
	.word 0xe0974e80  ! 7651: LDUHA_R	lduha	[%r29, %r0] 0x74, %r16
	mov	0x28, %r16
	.word 0xea8de000  ! 7653: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r21
	.word 0xecbfce80  ! 7654: STDA_R	stda	%r22, [%r31 + %r0] 0x74
	.word 0xeaf78e80  ! 7655: STXA_R	stxa	%r21, [%r30 + %r0] 0x74
	mov	0x70, %r18
	.word 0x8780204f  ! 7657: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r25
	.word 0xe2f4c400  ! 7659: STXA_R	stxa	%r17, [%r19 + %r0] 0x20
	.word 0xe8cde000  ! 7660: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r20
	.word 0xe8852000  ! 7661: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r20
	.word 0xe8cd6000  ! 7662: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r20
	.word 0x87802020  ! 7663: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 7664: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r19
	.word 0xeef74e80  ! 7666: STXA_R	stxa	%r23, [%r29 + %r0] 0x74
	.word 0xe697ce40  ! 7667: LDUHA_R	lduha	[%r31, %r0] 0x72, %r19
	.word 0xecb6e000  ! 7668: STHA_I	stha	%r22, [%r27 + 0x0000] %asi
	.word 0xeaa6c9e0  ! 7669: STWA_R	stwa	%r21, [%r27 + %r0] 0x4f
	.word 0xe4ae2000  ! 7670: STBA_I	stba	%r18, [%r24 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xe2df8e60  ! 7672: LDXA_R	ldxa	[%r30, %r0] 0x73, %r17
	mov	0x58, %r19
	.word 0xeccea000  ! 7674: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r22
	.word 0xecb62000  ! 7675: STHA_I	stha	%r22, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 7676: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea974e60  ! 7677: LDUHA_R	lduha	[%r29, %r0] 0x73, %r21
	mov	0x18, %r19
	mov	0x30, %r25
	.word 0xe6c52000  ! 7680: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r19
	.word 0xe685a000  ! 7681: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r19
	mov	0x3f8, %r20
	.word 0xe6b52000  ! 7683: STHA_I	stha	%r19, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 7684: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe697e000  ! 7685: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r19
	.word 0xe28504a0  ! 7686: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r17
	wr_tick_cmpr_3_62:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xfd, %g2
	or	%g4, 0xb0, %g4
	or	%g6, 0x89, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe4afa000  ! 7688: STBA_I	stba	%r18, [%r30 + 0x0000] %asi
	.word 0xe4bfa000  ! 7689: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 7690: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe49f2000  ! 7691: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r18
	.word 0x87802074  ! 7692: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 7693: WRASI_I	wr	%r0, 0x0020, %asi
	wr_tick_cmpr_3_63:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xa8, %g2
	or	%g4, 0xd5, %g4
	or	%g6, 0xdd, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe4872000  ! 7695: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r18
	.word 0xe4b7a000  ! 7696: STHA_I	stha	%r18, [%r30 + 0x0000] %asi
	mov	0x7c8, %r20
	mov	0x50, %r16
	.word 0xe4afa000  ! 7699: STBA_I	stba	%r18, [%r30 + 0x0000] %asi
	.word 0xecae09e0  ! 7700: STBA_R	stba	%r22, [%r24 + %r0] 0x4f
	.word 0xe0d72000  ! 7701: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r16
	mov	0x70, %r24
	.word 0xe8ac0400  ! 7703: STBA_R	stba	%r20, [%r16 + %r0] 0x20
	.word 0xe6bfa000  ! 7704: STDA_I	stda	%r19, [%r30 + 0x0000] %asi
	.word 0xe6bfe000  ! 7705: STDA_I	stda	%r19, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xe2bf8e60  ! 7707: STDA_R	stda	%r17, [%r30 + %r0] 0x73
	mov	0x7f8, %r22
	.word 0x87802020  ! 7709: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe6b7e000  ! 7710: STHA_I	stha	%r19, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 7711: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7d8, %r21
	.word 0xe6dce000  ! 7713: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r19
	.word 0x8780204f  ! 7714: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8bd44a0  ! 7715: STDA_R	stda	%r20, [%r21 + %r0] 0x25
	mov	0x50, %r24
	.word 0xe48e2000  ! 7717: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r18
	.word 0xe2bf0e40  ! 7718: STDA_R	stda	%r17, [%r28 + %r0] 0x72
	.word 0xe086a000  ! 7719: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r16
	.word 0xe29f8e40  ! 7720: LDDA_R	ldda	[%r30, %r0] 0x72, %r17
	.word 0xe2f5c4a0  ! 7721: STXA_R	stxa	%r17, [%r23 + %r0] 0x25
	.word 0xe4b6a000  ! 7722: STHA_I	stha	%r18, [%r26 + 0x0000] %asi
	.word 0xe4962000  ! 7723: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r18
	.word 0x87802020  ! 7724: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r24
	.word 0x8780204f  ! 7726: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8b5c4a0  ! 7727: STHA_R	stha	%r20, [%r23 + %r0] 0x25
	.word 0xe2bfce60  ! 7728: STDA_R	stda	%r17, [%r31 + %r0] 0x73
	.word 0x87802072  ! 7729: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe8be49e0  ! 7730: STDA_R	stda	%r20, [%r25 + %r0] 0x4f
	.word 0xe6952000  ! 7731: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r19
	mov	0x3e0, %r20
	.word 0xe6dda000  ! 7733: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r19
	mov	0x8, %r19
	.word 0xe6a5e000  ! 7735: STWA_I	stwa	%r19, [%r23 + 0x0000] %asi
	mov	0x38, %r25
	mov	0x10, %r27
	mov	0x58, %r16
	.word 0xe6a689e0  ! 7739: STWA_R	stwa	%r19, [%r26 + %r0] 0x4f
	mov	0x8, %r18
	mov	0x58, %r25
	.word 0xe6bc0400  ! 7742: STDA_R	stda	%r19, [%r16 + %r0] 0x20
	.word 0xe4c48400  ! 7743: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r18
	mov	0x3e0, %r22
	.word 0xecbd2000  ! 7745: STDA_I	stda	%r22, [%r20 + 0x0000] %asi
	mov	0x60, %r26
	mov	0x48, %r19
	.word 0xecb5a000  ! 7748: STHA_I	stha	%r22, [%r22 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xecdda000  ! 7750: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r22
	.word 0xecb52000  ! 7751: STHA_I	stha	%r22, [%r20 + 0x0000] %asi
	mov	0x30, %r27
	mov	0x8, %r16
	.word 0xeca56000  ! 7754: STWA_I	stwa	%r22, [%r21 + 0x0000] %asi
	.word 0xec8da000  ! 7755: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r22
	.word 0xe8f78e60  ! 7756: STXA_R	stxa	%r20, [%r30 + %r0] 0x73
	mov	0x10, %r25
	.word 0xe69da000  ! 7758: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r19
	.word 0xeece09e0  ! 7759: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r23
	.word 0xeef52000  ! 7760: STXA_I	stxa	%r23, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 7761: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeec72000  ! 7762: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r23
	.word 0xecf4c400  ! 7763: STXA_R	stxa	%r22, [%r19 + %r0] 0x20
	.word 0xe0af4e40  ! 7764: STBA_R	stba	%r16, [%r29 + %r0] 0x72
	.word 0xecbf6000  ! 7765: STDA_I	stda	%r22, [%r29 + 0x0000] %asi
	.word 0xecb7a000  ! 7766: STHA_I	stha	%r22, [%r30 + 0x0000] %asi
	.word 0xeca76000  ! 7767: STWA_I	stwa	%r22, [%r29 + 0x0000] %asi
	.word 0xe8df0e60  ! 7768: LDXA_R	ldxa	[%r28, %r0] 0x73, %r20
	.word 0xeab609e0  ! 7769: STHA_R	stha	%r21, [%r24 + %r0] 0x4f
	mov	0x48, %r16
	.word 0x87802074  ! 7771: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r23
	mov	0x7d0, %r21
	.word 0xeadfe000  ! 7774: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r21
	.word 0xe09f8e80  ! 7775: LDDA_R	ldda	[%r30, %r0] 0x74, %r16
	.word 0xe2cf2000  ! 7776: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r17
	mov	0x68, %r18
	.word 0x87802073  ! 7778: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 7779: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xe2dca000  ! 7780: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r17
	.word 0x87802073  ! 7781: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xeedf8e80  ! 7782: LDXA_R	ldxa	[%r30, %r0] 0x74, %r23
	.word 0xeca78e80  ! 7783: STWA_R	stwa	%r22, [%r30 + %r0] 0x74
	.word 0x87802020  ! 7784: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 7785: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2a46000  ! 7786: STWA_I	stwa	%r17, [%r17 + 0x0000] %asi
	.word 0xe2f4a000  ! 7787: STXA_I	stxa	%r17, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 7788: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r22
	.word 0xe2c52000  ! 7790: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r17
	mov	0x20, %r24
	ta	T_CHANGE_PRIV	! macro
	.word 0xe6ac0400  ! 7793: STBA_R	stba	%r19, [%r16 + %r0] 0x20
	wr_tick_cmpr_3_64:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x0, %g1, %g6
	or	%g2, 0xf4, %g2
	or	%g4, 0xfd, %g4
	or	%g6, 0xb0, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xeacd2000  ! 7795: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r21
	mov	0x0, %r25
	mov	0x78, %r19
	.word 0xeab52000  ! 7798: STHA_I	stha	%r21, [%r20 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xe0a649e0  ! 7800: STWA_R	stwa	%r16, [%r25 + %r0] 0x4f
	mov	0x8, %r24
	mov	0x78, %r27
	.word 0xeab5e000  ! 7803: STHA_I	stha	%r21, [%r23 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xe0be09e0  ! 7805: STDA_R	stda	%r16, [%r24 + %r0] 0x4f
	mov	0x3f0, %r20
	wr_tick_cmpr_3_65:
	ta	T_CHANGE_HPRIV
	setx	0x8000000000000000, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xa3, %g2
	or	%g4, 0xd1, %g4
	or	%g6, 0xda, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0x87802072  ! 7808: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7c0, %r22
	.word 0x8780204f  ! 7810: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 7811: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802072  ! 7813: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe08fa000  ! 7814: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r16
	mov	0x7c8, %r23
	.word 0xee848400  ! 7816: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r23
	.word 0xeadfe000  ! 7817: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r21
	.word 0x8780204f  ! 7818: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r18
	.word 0xea8de000  ! 7820: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r21
	.word 0xeac5a000  ! 7821: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r21
	.word 0xeadda000  ! 7822: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r21
	.word 0xe0af0e60  ! 7823: STBA_R	stba	%r16, [%r28 + %r0] 0x73
	mov	0x28, %r16
	.word 0xe8f689e0  ! 7825: STXA_R	stxa	%r20, [%r26 + %r0] 0x4f
	.word 0xecd44400  ! 7826: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r22
	.word 0xe885e000  ! 7827: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r20
	mov	0x28, %r18
	mov	0x10, %r16
	.word 0xe88da000  ! 7830: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r20
	.word 0xeec48400  ! 7831: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r23
	.word 0xe4cf0e80  ! 7832: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r18
	.word 0xe6dde000  ! 7833: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r19
	.word 0x87802072  ! 7834: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6dda000  ! 7835: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r19
	.word 0xee9f8e40  ! 7836: LDDA_R	ldda	[%r30, %r0] 0x72, %r23
	.word 0xeec74e60  ! 7837: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r23
	mov	0x7d8, %r20
	mov	0x3e8, %r23
	.word 0xe0bde000  ! 7840: STDA_I	stda	%r16, [%r23 + 0x0000] %asi
	.word 0xe0ad2000  ! 7841: STBA_I	stba	%r16, [%r20 + 0x0000] %asi
	.word 0xeea70e80  ! 7842: STWA_R	stwa	%r23, [%r28 + %r0] 0x74
	mov	0x7f8, %r22
	.word 0xecad6000  ! 7844: STBA_I	stba	%r22, [%r21 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0x87802074  ! 7846: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeca76000  ! 7847: STWA_I	stwa	%r22, [%r29 + 0x0000] %asi
	wr_tick_cmpr_3_66:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0x95, %g2
	or	%g4, 0xcb, %g4
	or	%g6, 0x8e, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xee8f8e60  ! 7849: LDUBA_R	lduba	[%r30, %r0] 0x73, %r23
	.word 0xe0bd04a0  ! 7850: STDA_R	stda	%r16, [%r20 + %r0] 0x25
	.word 0xe2b72000  ! 7851: STHA_I	stha	%r17, [%r28 + 0x0000] %asi
	.word 0xe0bd04a0  ! 7852: STDA_R	stda	%r16, [%r20 + %r0] 0x25
	.word 0xeab5c4a0  ! 7853: STHA_R	stha	%r21, [%r23 + %r0] 0x25
	.word 0xe88c8400  ! 7854: LDUBA_R	lduba	[%r18, %r0] 0x20, %r20
	.word 0xe4af4e60  ! 7855: STBA_R	stba	%r18, [%r29 + %r0] 0x73
	.word 0xe6d48400  ! 7856: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r19
	.word 0xe0bc0400  ! 7857: STDA_R	stda	%r16, [%r16 + %r0] 0x20
	.word 0xe8a76000  ! 7858: STWA_I	stwa	%r20, [%r29 + 0x0000] %asi
	.word 0xe4b4c400  ! 7859: STHA_R	stha	%r18, [%r19 + %r0] 0x20
	mov	0x48, %r17
	.word 0xe6afa000  ! 7861: STBA_I	stba	%r19, [%r30 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xe6dc8400  ! 7863: LDXA_R	ldxa	[%r18, %r0] 0x20, %r19
	.word 0xe6f6c9e0  ! 7864: STXA_R	stxa	%r19, [%r27 + %r0] 0x4f
	.word 0xecf7e000  ! 7865: STXA_I	stxa	%r22, [%r31 + 0x0000] %asi
	mov	0x78, %r16
	.word 0x87802020  ! 7867: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecf609e0  ! 7868: STXA_R	stxa	%r22, [%r24 + %r0] 0x4f
	mov	0x0, %r19
	.word 0xe2872000  ! 7870: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r17
	.word 0xe0bf8e80  ! 7871: STDA_R	stda	%r16, [%r30 + %r0] 0x74
	mov	0x50, %r17
	.word 0xeebf6000  ! 7873: STDA_I	stda	%r23, [%r29 + 0x0000] %asi
	.word 0xe28c8400  ! 7874: LDUBA_R	lduba	[%r18, %r0] 0x20, %r17
	.word 0xec96c9e0  ! 7875: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r22
	mov	0x3d8, %r21
	.word 0xe4bf4e80  ! 7877: STDA_R	stda	%r18, [%r29 + %r0] 0x74
	.word 0xecbfa000  ! 7878: STDA_I	stda	%r22, [%r30 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xe8a74e40  ! 7880: STWA_R	stwa	%r20, [%r29 + %r0] 0x72
	.word 0xeaf76000  ! 7881: STXA_I	stxa	%r21, [%r29 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xeaf7e000  ! 7883: STXA_I	stxa	%r21, [%r31 + 0x0000] %asi
	.word 0xeaafce40  ! 7884: STBA_R	stba	%r21, [%r31 + %r0] 0x72
	.word 0xe0bfa000  ! 7885: STDA_I	stda	%r16, [%r30 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xe0d7e000  ! 7887: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r16
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802072  ! 7889: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r25
	.word 0xe0bfa000  ! 7891: STDA_I	stda	%r16, [%r30 + 0x0000] %asi
	.word 0xe0afce40  ! 7892: STBA_R	stba	%r16, [%r31 + %r0] 0x72
	.word 0xeacfe000  ! 7893: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r21
	.word 0xe2b689e0  ! 7894: STHA_R	stha	%r17, [%r26 + %r0] 0x4f
	.word 0xe6d76000  ! 7895: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r19
	.word 0xe0b689e0  ! 7896: STHA_R	stha	%r16, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 7897: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r21
	.word 0xeaa40400  ! 7899: STWA_R	stwa	%r21, [%r16 + %r0] 0x20
	mov	0x10, %r18
	.word 0xe49544a0  ! 7901: LDUHA_R	lduha	[%r21, %r0] 0x25, %r18
	mov	0x3c8, %r21
	mov	0x30, %r18
	.word 0xecae89e0  ! 7904: STBA_R	stba	%r22, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 7905: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe4ac6000  ! 7906: STBA_I	stba	%r18, [%r17 + 0x0000] %asi
	.word 0xe4bc2000  ! 7907: STDA_I	stda	%r18, [%r16 + 0x0000] %asi
	.word 0xe4ac6000  ! 7908: STBA_I	stba	%r18, [%r17 + 0x0000] %asi
	.word 0xe48c6000  ! 7909: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r18
	.word 0xe2be49e0  ! 7910: STDA_R	stda	%r17, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 7911: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe284e000  ! 7912: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r17
	.word 0x87802072  ! 7913: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe2a78e80  ! 7914: STWA_R	stwa	%r17, [%r30 + %r0] 0x74
	.word 0xe0dce000  ! 7915: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r16
	.word 0xec8d84a0  ! 7916: LDUBA_R	lduba	[%r22, %r0] 0x25, %r22
	.word 0xe4842000  ! 7917: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r18
	.word 0xe49ce000  ! 7918: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r18
	mov	0x38, %r26
	mov	0x7c0, %r21
	.word 0xe4c42000  ! 7921: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r18
	.word 0xecbcc400  ! 7922: STDA_R	stda	%r22, [%r19 + %r0] 0x20
	.word 0xe4a48400  ! 7923: STWA_R	stwa	%r18, [%r18 + %r0] 0x20
	.word 0xe0f46000  ! 7924: STXA_I	stxa	%r16, [%r17 + 0x0000] %asi
	.word 0xe0b42000  ! 7925: STHA_I	stha	%r16, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 7926: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeeac8400  ! 7927: STBA_R	stba	%r23, [%r18 + %r0] 0x20
	mov	0x70, %r18
	.word 0xee852000  ! 7929: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r23
	wr_tick_cmpr_3_67:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x8000000000000000, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xe0, %g2
	or	%g4, 0xb6, %g4
	or	%g6, 0x9b, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 0, %pstate
	ta	T_CHANGE_NONHPRIV
	mov	0x60, %r19
	mov	0x78, %r26
	.word 0x87802072  ! 7933: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0a504a0  ! 7934: STWA_R	stwa	%r16, [%r20 + %r0] 0x25
	.word 0xe6aca000  ! 7935: STBA_I	stba	%r19, [%r18 + 0x0000] %asi
	.word 0xecf78e40  ! 7936: STXA_R	stxa	%r22, [%r30 + %r0] 0x72
	mov	0x60, %r26
	.word 0xe28ce000  ! 7938: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r17
	mov	0x40, %r25
	.word 0xe294a000  ! 7940: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r17
	.word 0xeeb504a0  ! 7941: STHA_R	stha	%r23, [%r20 + %r0] 0x25
	.word 0xe6c689e0  ! 7942: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r19
	.word 0xec94a000  ! 7943: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r22
	.word 0x8780204f  ! 7944: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeca5e000  ! 7945: STWA_I	stwa	%r22, [%r23 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xeaa504a0  ! 7947: STWA_R	stwa	%r21, [%r20 + %r0] 0x25
	mov	0x60, %r16
	.word 0xe2f5e000  ! 7949: STXA_I	stxa	%r17, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 7950: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r27
	.word 0xe2dc2000  ! 7952: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r17
	.word 0xe284e000  ! 7953: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r17
	.word 0xe2b4e000  ! 7954: STHA_I	stha	%r17, [%r19 + 0x0000] %asi
	.word 0xe897ce80  ! 7955: LDUHA_R	lduha	[%r31, %r0] 0x74, %r20
	.word 0x87802020  ! 7956: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecf40400  ! 7957: STXA_R	stxa	%r22, [%r16 + %r0] 0x20
	.word 0xe2f4a000  ! 7958: STXA_I	stxa	%r17, [%r18 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x10, %r17
	.word 0xe2d40400  ! 7961: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r17
	mov	0x18, %r26
	.word 0x87802073  ! 7963: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 7964: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xec844400  ! 7965: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r22
	.word 0xe4a52000  ! 7966: STWA_I	stwa	%r18, [%r20 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xee9504a0  ! 7968: LDUHA_R	lduha	[%r20, %r0] 0x25, %r23
	.word 0xe09de000  ! 7969: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r16
	.word 0xe0c5e000  ! 7970: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r16
	mov	0x68, %r25
	.word 0xee9f0e60  ! 7972: LDDA_R	ldda	[%r28, %r0] 0x73, %r23
	.word 0xe4cd2000  ! 7973: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r18
	.word 0xe4b5e000  ! 7974: STHA_I	stha	%r18, [%r23 + 0x0000] %asi
	.word 0xeacf0e60  ! 7975: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r21
	mov	0x40, %r25
	.word 0xeebe09e0  ! 7977: STDA_R	stda	%r23, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 7978: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 7979: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xea8d6000  ! 7980: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r21
	.word 0xead40400  ! 7981: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r21
	.word 0xe49c0400  ! 7982: LDDA_R	ldda	[%r16, %r0] 0x20, %r18
	.word 0xea840400  ! 7983: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r21
	.word 0xe8cda000  ! 7984: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r20
	.word 0xe4cf8e60  ! 7985: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r18
	mov	0x78, %r24
	mov	0x28, %r25
	.word 0xeedd2000  ! 7988: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r23
	.word 0x87802020  ! 7989: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeaa7ce60  ! 7990: STWA_R	stwa	%r21, [%r31 + %r0] 0x73
	.word 0xe2afa000  ! 7991: STBA_I	stba	%r17, [%r30 + 0x0000] %asi
	.word 0xe6a649e0  ! 7992: STWA_R	stwa	%r19, [%r25 + %r0] 0x4f
	.word 0xeabfa000  ! 7993: STDA_I	stda	%r21, [%r30 + 0x0000] %asi
	mov	0x68, %r16
	.word 0x87802072  ! 7995: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xeaf4c400  ! 7996: STXA_R	stxa	%r21, [%r19 + %r0] 0x20
	.word 0xe4f649e0  ! 7997: STXA_R	stxa	%r18, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 7998: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r25
	.word 0xe8c649e0  ! 8000: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r20
	.word 0x8780204f  ! 8001: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r18
	.word 0xe084c400  ! 8003: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r16
	.word 0xe6afce40  ! 8004: STBA_R	stba	%r19, [%r31 + %r0] 0x72
	.word 0xe8f78e40  ! 8005: STXA_R	stxa	%r20, [%r30 + %r0] 0x72
	.word 0xe48fce40  ! 8006: LDUBA_R	lduba	[%r31, %r0] 0x72, %r18
	.word 0xe2f44400  ! 8007: STXA_R	stxa	%r17, [%r17 + %r0] 0x20
	.word 0xeed76000  ! 8008: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r23
	.word 0xe2a584a0  ! 8009: STWA_R	stwa	%r17, [%r22 + %r0] 0x25
	.word 0xe88fe000  ! 8010: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r20
	mov	0x3f8, %r23
	.word 0xe8af6000  ! 8012: STBA_I	stba	%r20, [%r29 + 0x0000] %asi
	mov	0x38, %r27
	.word 0x87802072  ! 8014: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe89d2000  ! 8015: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r20
	.word 0xe88de000  ! 8016: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r20
	.word 0x87802025  ! 8017: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xec8c8400  ! 8018: LDUBA_R	lduba	[%r18, %r0] 0x20, %r22
	mov	0x38, %r16
	mov	0x70, %r24
	.word 0x87802025  ! 8021: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 8022: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xeab78e40  ! 8023: STHA_R	stha	%r21, [%r30 + %r0] 0x72
	.word 0xeea76000  ! 8024: STWA_I	stwa	%r23, [%r29 + 0x0000] %asi
	.word 0xeedfe000  ! 8025: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r23
	mov	0x3d0, %r22
	mov	0x68, %r25
	.word 0x87802072  ! 8028: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0f649e0  ! 8029: STXA_R	stxa	%r16, [%r25 + %r0] 0x4f
	mov	0x68, %r26
	.word 0xe0a7ce40  ! 8031: STWA_R	stwa	%r16, [%r31 + %r0] 0x72
	.word 0x87802074  ! 8032: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xeaf40400  ! 8033: STXA_R	stxa	%r21, [%r16 + %r0] 0x20
	.word 0xe0ac0400  ! 8034: STBA_R	stba	%r16, [%r16 + %r0] 0x20
	.word 0xe8dfa000  ! 8035: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r20
	.word 0xe6d78e80  ! 8036: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r19
	mov	0x18, %r24
	.word 0xeec7e000  ! 8038: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r23
	mov	0x60, %r16
	mov	0x7f8, %r20
	.word 0xeed7a000  ! 8041: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r23
	.word 0xeef7e000  ! 8042: STXA_I	stxa	%r23, [%r31 + 0x0000] %asi
	.word 0xe2bf4e60  ! 8043: STDA_R	stda	%r17, [%r29 + %r0] 0x73
	.word 0xe08dc4a0  ! 8044: LDUBA_R	lduba	[%r23, %r0] 0x25, %r16
	mov	0x70, %r17
	.word 0xe8b48400  ! 8046: STHA_R	stha	%r20, [%r18 + %r0] 0x20
	.word 0x87802073  ! 8047: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe2a42000  ! 8048: STWA_I	stwa	%r17, [%r16 + 0x0000] %asi
	.word 0xe2cca000  ! 8049: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r17
	mov	0x8, %r27
	.word 0xe2ac2000  ! 8051: STBA_I	stba	%r17, [%r16 + 0x0000] %asi
	.word 0xe4b78e60  ! 8052: STHA_R	stha	%r18, [%r30 + %r0] 0x73
	.word 0xe2d42000  ! 8053: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r17
	.word 0xe294a000  ! 8054: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r17
	.word 0x87802025  ! 8055: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r16
	.word 0xec874e80  ! 8057: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r22
	.word 0x87802072  ! 8058: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe484c400  ! 8059: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r18
	.word 0xee95c4a0  ! 8060: LDUHA_R	lduha	[%r23, %r0] 0x25, %r23
	.word 0x87802020  ! 8061: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe287a000  ! 8062: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r17
	mov	0x50, %r27
	.word 0xe2d7e000  ! 8064: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r17
	.word 0xe2b7a000  ! 8065: STHA_I	stha	%r17, [%r30 + 0x0000] %asi
	.word 0xe0f78e80  ! 8066: STXA_R	stxa	%r16, [%r30 + %r0] 0x74
	.word 0x87802073  ! 8067: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xe0f4e000  ! 8068: STXA_I	stxa	%r16, [%r19 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xe0f46000  ! 8070: STXA_I	stxa	%r16, [%r17 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xe8a74e80  ! 8072: STWA_R	stwa	%r20, [%r29 + %r0] 0x74
	.word 0xea9ca000  ! 8073: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r21
	.word 0xeaace000  ! 8074: STBA_I	stba	%r21, [%r19 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xe48649e0  ! 8076: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r18
	.word 0x87802072  ! 8077: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe6dea000  ! 8078: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r19
	.word 0xe6a62000  ! 8079: STWA_I	stwa	%r19, [%r24 + 0x0000] %asi
	.word 0xe6962000  ! 8080: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r19
	.word 0xe6ae2000  ! 8081: STBA_I	stba	%r19, [%r24 + 0x0000] %asi
	.word 0xe6b66000  ! 8082: STHA_I	stha	%r19, [%r25 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xee94c400  ! 8084: LDUHA_R	lduha	[%r19, %r0] 0x20, %r23
	mov	0x3d0, %r20
	.word 0xe29ea000  ! 8086: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r17
	.word 0xe2ae2000  ! 8087: STBA_I	stba	%r17, [%r24 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xe6bd04a0  ! 8089: STDA_R	stda	%r19, [%r20 + %r0] 0x25
	.word 0x87802020  ! 8090: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a78e60  ! 8091: STWA_R	stwa	%r16, [%r30 + %r0] 0x73
	mov	0x10, %r26
	.word 0xecc6c9e0  ! 8093: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r22
	.word 0xe697ce60  ! 8094: LDUHA_R	lduha	[%r31, %r0] 0x73, %r19
	.word 0xe8948400  ! 8095: LDUHA_R	lduha	[%r18, %r0] 0x20, %r20
	.word 0xec8584a0  ! 8096: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r22
	.word 0xeab46000  ! 8097: STHA_I	stha	%r21, [%r17 + 0x0000] %asi
	.word 0xeaf4a000  ! 8098: STXA_I	stxa	%r21, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 8099: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xeea7ce80  ! 8100: STWA_R	stwa	%r23, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 8101: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xeca5a000  ! 8102: STWA_I	stwa	%r22, [%r22 + 0x0000] %asi
	.word 0xe4bf8e40  ! 8103: STDA_R	stda	%r18, [%r30 + %r0] 0x72
	.word 0x87802025  ! 8104: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r23
	.word 0xeab7ce80  ! 8106: STHA_R	stha	%r21, [%r31 + %r0] 0x74
	.word 0xe8b76000  ! 8107: STHA_I	stha	%r20, [%r29 + 0x0000] %asi
	.word 0xe28f4e40  ! 8108: LDUBA_R	lduba	[%r29, %r0] 0x72, %r17
	.word 0xe6b72000  ! 8109: STHA_I	stha	%r19, [%r28 + 0x0000] %asi
	.word 0xe6972000  ! 8110: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r19
	.word 0xe29c8400  ! 8111: LDDA_R	ldda	[%r18, %r0] 0x20, %r17
	.word 0xe0f7e000  ! 8112: STXA_I	stxa	%r16, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 8113: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe8bc0400  ! 8114: STDA_R	stda	%r20, [%r16 + %r0] 0x20
	.word 0xe48f8e40  ! 8115: LDUBA_R	lduba	[%r30, %r0] 0x72, %r18
	mov	0x7d0, %r20
	.word 0xe496e000  ! 8117: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r18
	.word 0x87802025  ! 8118: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 8119: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe887ce40  ! 8120: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r20
	.word 0x87802025  ! 8121: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe08f4e60  ! 8122: LDUBA_R	lduba	[%r29, %r0] 0x73, %r16
	.word 0xe4a70e80  ! 8123: STWA_R	stwa	%r18, [%r28 + %r0] 0x74
	mov	0x30, %r16
	mov	0x18, %r19
	.word 0xe2f46000  ! 8126: STXA_I	stxa	%r17, [%r17 + 0x0000] %asi
	mov	0x40, %r27
	.word 0x87802074  ! 8128: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r19
	mov	0x60, %r26
	.word 0xe2cf6000  ! 8131: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r17
	.word 0xeea44400  ! 8132: STWA_R	stwa	%r23, [%r17 + %r0] 0x20
	mov	0x8, %r18
	.word 0x87802020  ! 8134: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xecc544a0  ! 8135: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r22
	.word 0xe6c48400  ! 8136: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r19
	mov	0x8, %r18
	.word 0xe0a6c9e0  ! 8138: STWA_R	stwa	%r16, [%r27 + %r0] 0x4f
	.word 0xee852000  ! 8139: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r23
	mov	0x7e8, %r20
	.word 0xeeacc400  ! 8141: STBA_R	stba	%r23, [%r19 + %r0] 0x20
	.word 0x87802020  ! 8142: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r20
	.word 0xeca42000  ! 8144: STWA_I	stwa	%r22, [%r16 + 0x0000] %asi
	mov	0x38, %r27
	.word 0xeaf78e80  ! 8146: STXA_R	stxa	%r21, [%r30 + %r0] 0x74
	.word 0xe8cc6000  ! 8147: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r20
	.word 0xe8dc2000  ! 8148: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r20
	.word 0xe8b74e80  ! 8149: STHA_R	stha	%r20, [%r29 + %r0] 0x74
	.word 0xe0b44400  ! 8150: STHA_R	stha	%r16, [%r17 + %r0] 0x20
	.word 0xe2a48400  ! 8151: STWA_R	stwa	%r17, [%r18 + %r0] 0x20
	.word 0x87802025  ! 8152: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xe2974e80  ! 8153: LDUHA_R	lduha	[%r29, %r0] 0x74, %r17
	mov	0x48, %r26
	mov	0x3e8, %r20
	.word 0x87802020  ! 8156: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xe4b74e60  ! 8158: STHA_R	stha	%r18, [%r29 + %r0] 0x73
	.word 0xeec4e000  ! 8159: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r23
	.word 0xe4bd44a0  ! 8160: STDA_R	stda	%r18, [%r21 + %r0] 0x25
	.word 0xea9ce000  ! 8161: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r21
	.word 0xeabf8e80  ! 8162: STDA_R	stda	%r21, [%r30 + %r0] 0x74
	.word 0xe4f609e0  ! 8163: STXA_R	stxa	%r18, [%r24 + %r0] 0x4f
	.word 0xe8d42000  ! 8164: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r20
	mov	0x68, %r19
	.word 0x87802072  ! 8166: WRASI_I	wr	%r0, 0x0072, %asi
	wr_tick_cmpr_3_68:
	ta	T_CHANGE_HPRIV
	setx	0x0, %g1, %g2
	setx	0x0, %g1, %g4
	setx	0x8000000000000000, %g1, %g6
	or	%g2, 0xbf, %g2
	or	%g4, 0xfd, %g4
	or	%g6, 0xe7, %g6
	wrpr	%g0, 0, %tick
	wr	%g2, 0, %tick_cmpr
	wr	%g4, 0, %sys_tick_cmpr
	wrhpr	%g6, 0, %hsys_tick_cmpr
	rdpr	%pstate, %g1
	wrpr	%g1, 2, %pstate
	ta	T_CHANGE_NONHPRIV
	.word 0xe8cce000  ! 8168: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r20
	.word 0xe8bd44a0  ! 8169: STDA_R	stda	%r20, [%r21 + %r0] 0x25
	.word 0xe8cca000  ! 8170: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r20
	mov	0x30, %r17
	.word 0x87802020  ! 8172: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2af4e80  ! 8173: STBA_R	stba	%r17, [%r29 + %r0] 0x74
	.word 0xeeb44400  ! 8174: STHA_R	stha	%r23, [%r17 + %r0] 0x20
	.word 0xe8b7a000  ! 8175: STHA_I	stha	%r20, [%r30 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0x87802020  ! 8177: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r18
	.word 0xe2f44400  ! 8179: STXA_R	stxa	%r17, [%r17 + %r0] 0x20
	.word 0xeaf70e40  ! 8180: STXA_R	stxa	%r21, [%r28 + %r0] 0x72
	.word 0xeca6c9e0  ! 8181: STWA_R	stwa	%r22, [%r27 + %r0] 0x4f
	.word 0xe2cce000  ! 8182: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r17
	.word 0xea978e80  ! 8183: LDUHA_R	lduha	[%r30, %r0] 0x74, %r21
	mov	0x60, %r26
	.word 0xea8689e0  ! 8185: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r21
	.word 0xe0840400  ! 8186: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r16
	.word 0xeebc8400  ! 8187: STDA_R	stda	%r23, [%r18 + %r0] 0x20
	.word 0x87802025  ! 8188: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 8189: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0a7a000  ! 8190: STWA_I	stwa	%r16, [%r30 + 0x0000] %asi
	.word 0xe6a78e80  ! 8191: STWA_R	stwa	%r19, [%r30 + %r0] 0x74
	mov	0x3f8, %r23
	.word 0xea87ce80  ! 8193: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r21
	.word 0xea8f0e80  ! 8194: LDUBA_R	lduba	[%r28, %r0] 0x74, %r21
	.word 0xeca7a000  ! 8195: STWA_I	stwa	%r22, [%r30 + 0x0000] %asi
	.word 0xe6b78e40  ! 8196: STHA_R	stha	%r19, [%r30 + %r0] 0x72
	mov	0x3d8, %r21
	.word 0xe88f6000  ! 8198: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r20
	mov	0x7e8, %r21
	.word 0xeabe09e0  ! 8200: STDA_R	stda	%r21, [%r24 + %r0] 0x4f
	.word 0xe4b76000  ! 8201: STHA_I	stha	%r18, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 8202: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4a76000  ! 8203: STWA_I	stwa	%r18, [%r29 + 0x0000] %asi
	.word 0xe2ce49e0  ! 8204: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r17
	mov	0x70, %r16
	mov	0x50, %r24
	.word 0xe4dfa000  ! 8207: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r18
	.word 0xeeb70e60  ! 8208: STHA_R	stha	%r23, [%r28 + %r0] 0x73
	mov	0x7d8, %r23
	mov	0x3c8, %r21
	mov	0x7e0, %r20
	mov	0x50, %r19
	.word 0xeaf78e60  ! 8213: STXA_R	stxa	%r21, [%r30 + %r0] 0x73
	.word 0x87802072  ! 8214: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0d72000  ! 8215: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r16
	mov	0x3e8, %r21
	.word 0xe08f2000  ! 8217: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r16
	mov	0x7d0, %r22
	.word 0x87802072  ! 8219: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r19
	.word 0xe0a76000  ! 8221: STWA_I	stwa	%r16, [%r29 + 0x0000] %asi
	.word 0xe6df0e60  ! 8222: LDXA_R	ldxa	[%r28, %r0] 0x73, %r19
	.word 0xecafa000  ! 8223: STBA_I	stba	%r22, [%r30 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xecaf6000  ! 8225: STBA_I	stba	%r22, [%r29 + 0x0000] %asi
	.word 0xec872000  ! 8226: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r22
	.word 0xec976000  ! 8227: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r22
	.word 0xec976000  ! 8228: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r22
	.word 0xec8f6000  ! 8229: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r22
	mov	0x68, %r16
	.word 0xe8bf4e80  ! 8231: STDA_R	stda	%r20, [%r29 + %r0] 0x74
	.word 0xe2a5c4a0  ! 8232: STWA_R	stwa	%r17, [%r23 + %r0] 0x25
	.word 0xe2d7ce80  ! 8233: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r17
	.word 0xe4d40400  ! 8234: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r18
	.word 0xe6840400  ! 8235: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r19
	.word 0xe4c7e000  ! 8236: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r18
	.word 0xe4bfa000  ! 8237: STDA_I	stda	%r18, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 8238: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r25
	mov	0x28, %r25
	.word 0xe48f4e40  ! 8241: LDUBA_R	lduba	[%r29, %r0] 0x72, %r18
	ta	T_CHANGE_PRIV	! macro
	.word 0xea9ca000  ! 8243: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r21
	.word 0xeaa46000  ! 8244: STWA_I	stwa	%r21, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 8245: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 8246: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d0, %r21
	.word 0xe4a584a0  ! 8248: STWA_R	stwa	%r18, [%r22 + %r0] 0x25
	.word 0xe4bcc400  ! 8249: STDA_R	stda	%r18, [%r19 + %r0] 0x20
	.word 0xe6cf6000  ! 8250: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r19
	mov	0x7c8, %r23
	.word 0xe687a000  ! 8252: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r19
	.word 0xe6f76000  ! 8253: STXA_I	stxa	%r19, [%r29 + 0x0000] %asi
	mov	0x8, %r24
	mov	0x7c8, %r23
	mov	0x30, %r18
	.word 0xe6cfe000  ! 8257: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r19
	.word 0xe6972000  ! 8258: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r19
	.word 0xe6f76000  ! 8259: STXA_I	stxa	%r19, [%r29 + 0x0000] %asi
	mov	0x38, %r17
	.word 0x87802072  ! 8261: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xe0d40400  ! 8262: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r16
	.word 0x87802020  ! 8263: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe2c689e0  ! 8264: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r17
	.word 0xeedca000  ! 8265: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r23
	.word 0x8780204f  ! 8266: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 8267: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r19
	mov	0x7d8, %r22
	.word 0xeeb76000  ! 8270: STHA_I	stha	%r23, [%r29 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xee8f2000  ! 8272: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r23
	.word 0x8780204f  ! 8273: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xe8a4c400  ! 8274: STWA_R	stwa	%r20, [%r19 + %r0] 0x20
	mov	0x3c8, %r22
	.word 0xe2a7a000  ! 8276: STWA_I	stwa	%r17, [%r30 + 0x0000] %asi
	.word 0xe2de49e0  ! 8277: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r17
	.word 0xe8df8e40  ! 8278: LDXA_R	ldxa	[%r30, %r0] 0x72, %r20
	.word 0xe6cfe000  ! 8279: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r19
	.word 0xe6a72000  ! 8280: STWA_I	stwa	%r19, [%r28 + 0x0000] %asi
	.word 0xe68fe000  ! 8281: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r19
	.word 0xeeae49e0  ! 8282: STBA_R	stba	%r23, [%r25 + %r0] 0x4f
	.word 0xea8f6000  ! 8283: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r21
	mov	0x68, %r25
	.word 0xeacfe000  ! 8285: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r21
	.word 0xe2aec9e0  ! 8286: STBA_R	stba	%r17, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 8287: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe4f56000  ! 8288: STXA_I	stxa	%r18, [%r21 + 0x0000] %asi
	.word 0xe28c8400  ! 8289: LDUBA_R	lduba	[%r18, %r0] 0x20, %r17
	.word 0xe4c56000  ! 8290: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r18
	.word 0xe48da000  ! 8291: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r18
	.word 0xe0d609e0  ! 8292: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r16
	.word 0xe0bd6000  ! 8293: STDA_I	stda	%r16, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 8294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xe0d4e000  ! 8295: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r16
	.word 0x87