// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: tlu_asi_access_mt_1_rand_42_s2.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
********************************************************************************
   random seed:	399429203
   Jal tlu_asi_access_mt_1.j:	
********************************************************************************/



#define PCONTEXT	0x10
#define SCONTEXT	0x10

#define MAIN_PAGE_NUCLEUS_ALSO
#define MAIN_PAGE_HV_ALSO

#define ALL_MY_INTR_HANDLERS
#include "my_intr_handlers.s"
#include "my_trap_handlers.s"
#include "tlu_custom_trap_handlers.s"

#include "enable_traps.h"
#include "boot.s"

.text
.global main

main:

	ta 	%icc, T_CHANGE_HPRIV
	mov	0x123, %g1
	wr	%g0, 0x20, %asi
	stxa	%g1, [0x00] %asi
	stxa	%g1, [0x08] %asi
	stxa	%g1, [0x10] %asi
	stxa	%g1, [0x18] %asi
	stxa	%g1, [0x20] %asi
	stxa	%g1, [0x28] %asi
	stxa	%g1, [0x30] %asi
	stxa	%g1, [0x38] %asi
	ta 	%icc, T_CHANGE_NONHPRIV

! Register init code

	setx 0x273c74970000c251, %g1, %g0
	setx 0x48de4c430000e30e, %g1, %g1
	setx 0x9a0200230000237e, %g1, %g2
	setx 0x15d23ef00000e275, %g1, %g3
	setx 0x2776d6d200002317, %g1, %g4
	setx 0x4b2559e500002379, %g1, %g5
	setx 0x8184a4a800004131, %g1, %g6
	setx 0x7a7cdf960000202f, %g1, %g7
	setx 0x64e23e9a000000f2, %g1, %r16
	setx 0x9c023e5e0000a373, %g1, %r17
	setx 0x304cc5830000c228, %g1, %r18
	setx 0xfeb60ddb0000827f, %g1, %r19
	setx 0x56457d5f0000c226, %g1, %r20
	setx 0x6c6392110000c025, %g1, %r21
	setx 0x76a953a90000a06b, %g1, %r22
	setx 0x8b3d14960000a039, %g1, %r23
	setx 0x71c101e8000000a4, %g1, %r24
	setx 0x1b75977c0000010b, %g1, %r25
	setx 0x8407a60a000002e1, %g1, %r26
	setx 0xd51985810000620b, %g1, %r27
	setx 0x5f6131be000043d0, %g1, %r28
	setx 0xf9abc5bf0000e24a, %g1, %r29
	setx 0x5aea329c000003f4, %g1, %r30
	setx 0xe1e7775900000329, %g1, %r31
	save
	setx 0x7a7a034300006143, %g1, %r16
	setx 0xb2990f7e0000c098, %g1, %r17
	setx 0xe8bc5bd80000a12a, %g1, %r18
	setx 0x0d37d1790000c157, %g1, %r19
	setx 0xcb512d78000003fe, %g1, %r20
	setx 0xe78e5a740000a04d, %g1, %r21
	setx 0x4484ea47000001ea, %g1, %r22
	setx 0xc8f65e3300004323, %g1, %r23
	setx 0x71233f0c0000627c, %g1, %r24
	setx 0x945a278d0000c33f, %g1, %r25
	setx 0xb617507b00008094, %g1, %r26
	setx 0xdfd628390000e3e7, %g1, %r27
	setx 0xd40330bd000041f8, %g1, %r28
	setx 0x3c502f8600002109, %g1, %r29
	setx 0xe615cf0c0000a1d8, %g1, %r30
	setx 0xda0052fb0000a3e6, %g1, %r31
	restore
#ifdef PORTABLE_CORE
	mov	PORTABLE_CORE, %g1
	sllx	%g1, 10, %g1
	or	%r8, %g1, %r8
	or	%r9, %g1, %r9
	or	%r10, %g1, %r10
	or	%r11, %g1, %r11
	or	%r12, %g1, %r12
	or	%r13, %g1, %r13
	or	%r14, %g1, %r14
	or	%r15, %g1, %r15
#endif
	mov	0x18, %r16
	mov	0x48, %r17
	mov	0x78, %r18
	mov	0x38, %r19
	mov	0x7f0, %r20
	mov	0x7e8, %r21
	mov	0x7c8, %r22
	mov	0x7e0, %r23
	mov	0x50, %r24
	mov	0x30, %r25
	mov	0x60, %r26
	mov	0x40, %r27
	mov	0, %r28
	mov	0, %r29
	mov	0, %r30
	mov	0, %r31
	ta	%icc, T_CHANGE_HPRIV
	wr	%g0, 0x4f, %asi
	stxa	%g0, [%g0] 0x42
	mov	0x38, %g1
	stxa	%g0, [%g1] 0x58
	ta	%icc, T_RD_THID
! fork: source strm = 0xffffffff; target strm = 0x2
	cmp	%o1, 1
	setx	fork_lbl_0_1, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x4
	cmp	%o1, 2
	setx	fork_lbl_0_2, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
! fork: source strm = 0xffffffff; target strm = 0x8
	cmp	%o1, 3
	setx	fork_lbl_0_3, %g2, %g3
	be,a	.+8
	jmp	%g3
	nop
	.word 0xd2f649e0  ! 1: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	.word 0xdc8f8e80  ! 2: LDUBA_R	lduba	[%r30, %r0] 0x74, %r14
	.word 0xdc9e6000  ! 3: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	.word 0xdcc6e000  ! 4: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0xdc962000  ! 5: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r14
	.word 0xd4ac0400  ! 6: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	mov	0x40, %r24
	.word 0xdabc4400  ! 8: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	mov	0x68, %r25
	.word 0xdaf48400  ! 10: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd6f74e80  ! 11: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xd6a40400  ! 12: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x18, %r25
	mov	0x38, %r18
	.word 0xdc9fce40  ! 15: LDDA_R	ldda	[%r31, %r0] 0x72, %r14
	mov	0x48, %r18
	.word 0xdcaee000  ! 17: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0xdc9ea000  ! 18: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r14
	.word 0xdcd6e000  ! 19: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r14
	.word 0xdcc6e000  ! 20: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0x87802072  ! 21: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 22: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a7ce80  ! 23: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	mov	0x3e8, %r23
	.word 0x8780204f  ! 25: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd896a000  ! 26: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r12
	mov	0x50, %r16
	.word 0x87802025  ! 28: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e0, %r21
	.word 0xd8ad6000  ! 30: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xdea609e0  ! 31: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xd8ac4400  ! 32: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	mov	0x7c8, %r21
	.word 0xd0dec9e0  ! 34: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	mov	0x3d8, %r21
	.word 0xd2bfce40  ! 36: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0x87802073  ! 37: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa7ce80  ! 38: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	.word 0x87802074  ! 39: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r27
	.word 0xdec7ce40  ! 41: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r15
	.word 0xd2cc4400  ! 42: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	mov	0x18, %r19
	.word 0xd2c74e80  ! 44: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	mov	0x10, %r17
	mov	0x0, %r16
	.word 0x87802020  ! 47: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f42000  ! 48: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd4cf8e60  ! 49: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	.word 0xd4b4a000  ! 50: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 51: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4972000  ! 52: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd0af0e40  ! 53: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xd2c78e80  ! 54: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r9
	.word 0xdadf4e80  ! 55: LDXA_R	ldxa	[%r29, %r0] 0x74, %r13
	.word 0xdaf7a000  ! 56: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xd2a4c400  ! 57: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd6c74e60  ! 58: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r11
	mov	0x30, %r24
	.word 0x87802020  ! 60: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b4e000  ! 61: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 62: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r18
	.word 0xd6c46000  ! 64: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	.word 0xd694a000  ! 65: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	mov	0x3d0, %r23
	.word 0xd2ae89e0  ! 67: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 68: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r18
	.word 0xdcb6c9e0  ! 70: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xdca76000  ! 71: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc87a000  ! 72: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0xd0df0e60  ! 73: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0x87802020  ! 74: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 75: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09e2000  ! 76: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r8
	.word 0xd0c40400  ! 77: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd2df8e40  ! 78: LDXA_R	ldxa	[%r30, %r0] 0x72, %r9
	.word 0xd28e2000  ! 79: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2a6a000  ! 80: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	.word 0xd286a000  ! 81: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0x87802020  ! 82: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28ca000  ! 83: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2846000  ! 84: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	.word 0xd097ce60  ! 85: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	mov	0x20, %r19
	.word 0xde944400  ! 87: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	mov	0x7c0, %r21
	mov	0x78, %r24
	.word 0xd6d5c4a0  ! 90: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	.word 0xd6846000  ! 91: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6b46000  ! 92: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd6b46000  ! 93: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd6dce000  ! 94: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd8b70e80  ! 95: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	.word 0xdec74e80  ! 96: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	.word 0xded46000  ! 97: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 98: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8878e40  ! 99: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r12
	.word 0xdec44400  ! 100: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xda878e60  ! 101: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r13
	mov	0x0, %r27
	.word 0x87802020  ! 103: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69d84a0  ! 104: LDDA_R	ldda	[%r22, %r0] 0x25, %r11
	.word 0xd8df8e80  ! 105: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xd8d4a000  ! 106: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0x87802025  ! 107: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8d56000  ! 108: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	.word 0xd8dc4400  ! 109: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xd8a56000  ! 110: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xd8ad2000  ! 112: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd8d7ce60  ! 113: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r12
	mov	0x3c0, %r21
	mov	0x7f0, %r23
	.word 0x8780204f  ! 116: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r27
	.word 0xd6cf8e80  ! 118: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0xd6b40400  ! 119: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xdabf4e80  ! 120: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xdac6a000  ! 121: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xdaae2000  ! 122: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xdabea000  ! 124: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xdaa74e80  ! 125: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xdaa6a000  ! 126: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	.word 0xda962000  ! 127: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r13
	mov	0x60, %r16
	mov	0x8, %r26
	.word 0x8780204f  ! 130: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9e2000  ! 131: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r13
	.word 0xd0b609e0  ! 132: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	mov	0x8, %r18
	mov	0x3c0, %r23
	.word 0xdea70e60  ! 135: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	.word 0xdeaea000  ! 136: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xd2f4c400  ! 137: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd2862000  ! 138: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0xd6df4e40  ! 139: LDXA_R	ldxa	[%r29, %r0] 0x72, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2f609e0  ! 141: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 142: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f6a000  ! 143: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	mov	0x3f8, %r23
	mov	0x68, %r24
	.word 0xd88e49e0  ! 146: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	.word 0xd8ce2000  ! 147: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	.word 0xd88ee000  ! 148: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r12
	.word 0xd8c62000  ! 149: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	.word 0xd0a78e80  ! 150: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0x87802020  ! 151: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c4c400  ! 152: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r10
	.word 0xd4a42000  ! 153: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd0b78e40  ! 154: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0xd48f8e40  ! 155: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	mov	0x38, %r26
	.word 0x87802072  ! 157: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a78e60  ! 158: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	.word 0xd887e000  ! 159: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd887a000  ! 160: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd0dd84a0  ! 161: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0xdadc0400  ! 162: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xdabf4e60  ! 163: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	.word 0xda9f2000  ! 164: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	mov	0x3e8, %r23
	.word 0xdabf2000  ! 166: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 167: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa6e000  ! 168: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xd4a504a0  ! 169: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	.word 0xd4f544a0  ! 170: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	mov	0x7d8, %r21
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4b6e000  ! 173: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	.word 0xd4ae2000  ! 174: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xd4de2000  ! 175: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4ae2000  ! 176: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xdcf48400  ! 177: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xdc966000  ! 178: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r14
	.word 0xdc86a000  ! 179: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	.word 0xd4f78e60  ! 180: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	mov	0x18, %r26
	mov	0x3c0, %r22
	.word 0xd4a689e0  ! 183: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	mov	0x50, %r18
	mov	0x7d8, %r22
	.word 0x87802020  ! 186: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7e0, %r23
	.word 0x8780204f  ! 189: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r16
	.word 0xdca74e40  ! 191: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	mov	0x58, %r25
	mov	0x68, %r26
	.word 0xd0ae89e0  ! 194: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xd0b6a000  ! 195: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0xda9f4e60  ! 196: LDDA_R	ldda	[%r29, %r0] 0x73, %r13
	.word 0xda866000  ! 197: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r13
	.word 0xdaa62000  ! 198: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	.word 0xdab78e60  ! 199: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0xdaaea000  ! 200: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xd4a7ce40  ! 201: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xd4be2000  ! 202: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd4dea000  ! 204: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd4cea000  ! 205: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r10
	mov	0x38, %r18
	mov	0x18, %r27
	mov	0x40, %r18
	mov	0x40, %r24
	mov	0x3d8, %r22
	.word 0xd0f74e40  ! 211: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xd0f66000  ! 212: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd0a66000  ! 213: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	.word 0xdef689e0  ! 214: STXA_R	stxa	%r15, [%r26 + %r0] 0x4f
	.word 0xd49d84a0  ! 215: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0xdeccc400  ! 216: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r15
	.word 0xded70e60  ! 217: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	mov	0x48, %r26
	.word 0xde962000  ! 219: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r15
	mov	0x7c0, %r21
	.word 0xdeb6a000  ! 221: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	.word 0xde862000  ! 222: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	mov	0x30, %r16
	.word 0x87802020  ! 224: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdef42000  ! 226: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xde942000  ! 227: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0x87802020  ! 228: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaca000  ! 229: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xd6b44400  ! 230: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4a689e0  ! 232: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	.word 0xd4a4a000  ! 233: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd4b42000  ! 234: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd4a42000  ! 235: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd48c6000  ! 236: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xded70e60  ! 237: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	.word 0xd2ce89e0  ! 238: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r9
	mov	0x3e0, %r21
	.word 0xd28ca000  ! 240: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2f46000  ! 241: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xdea44400  ! 242: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0xdcde89e0  ! 244: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r14
	.word 0xdc8fce60  ! 245: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	mov	0x7d0, %r23
	.word 0xdccc2000  ! 247: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	mov	0x70, %r26
	mov	0x50, %r19
	.word 0xdca42000  ! 250: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 251: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd496c9e0  ! 252: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	mov	0x7e8, %r22
	.word 0xd4a5c4a0  ! 254: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xd49ca000  ! 255: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xdc97ce80  ! 256: LDUHA_R	lduha	[%r31, %r0] 0x74, %r14
	.word 0xd69e49e0  ! 257: LDDA_R	ldda	[%r25, %r0] 0x4f, %r11
	mov	0x60, %r18
	.word 0xde9ec9e0  ! 259: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdac40400  ! 261: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 262: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r23
	mov	0x40, %r19
	.word 0xdaf42000  ! 265: STXA_I	stxa	%r13, [%r16 + 0x0000] %asi
	.word 0xd69fce60  ! 266: LDDA_R	ldda	[%r31, %r0] 0x73, %r11
	.word 0xd29f8e60  ! 267: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	.word 0xd2942000  ! 268: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c4a000  ! 269: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	mov	0x7e8, %r23
	.word 0xd2cc6000  ! 271: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 272: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 273: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09c8400  ! 274: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	mov	0x58, %r24
	.word 0xd6f74e80  ! 276: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0xd6f76000  ! 277: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xdec609e0  ! 279: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r15
	.word 0xdeaf6000  ! 280: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd88e09e0  ! 282: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0xd8a72000  ! 283: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cf2000  ! 284: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	mov	0x3d8, %r20
	.word 0xd88fe000  ! 286: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802074  ! 287: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ae89e0  ! 288: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 289: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r19
	.word 0xd8afce80  ! 291: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0xd8bc6000  ! 292: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xda84c400  ! 293: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	mov	0x38, %r26
	.word 0xdcb44400  ! 295: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0x87802073  ! 296: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 297: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 298: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r16
	.word 0xdcdce000  ! 300: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xdef48400  ! 301: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd0b48400  ! 302: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	mov	0x7f8, %r20
	mov	0x7d0, %r20
	.word 0xd0d46000  ! 305: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0x87802073  ! 306: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbf0e60  ! 307: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	mov	0x3d0, %r21
	.word 0xd0be09e0  ! 309: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xdec78e80  ! 310: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r15
	.word 0x87802073  ! 311: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0a74e60  ! 313: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	mov	0x40, %r19
	.word 0xd0dfa000  ! 315: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0dfe000  ! 316: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 317: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a66000  ! 318: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	.word 0xd0f6e000  ! 319: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd4a504a0  ! 320: STWA_R	stwa	%r10, [%r20 + %r0] 0x25
	mov	0x58, %r26
	.word 0xd8c649e0  ! 322: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r12
	.word 0x87802072  ! 323: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69fce80  ! 324: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	mov	0x40, %r25
	.word 0xd6f7e000  ! 326: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x7c0, %r21
	.word 0xd68584a0  ! 328: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r11
	.word 0x87802074  ! 329: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r27
	mov	0x10, %r24
	.word 0x87802074  ! 332: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6d7a000  ! 333: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 334: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6df2000  ! 335: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xdeacc400  ! 336: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	mov	0x78, %r17
	.word 0xde9fe000  ! 338: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xd6af0e40  ! 339: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0x87802072  ! 340: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r19
	.word 0xd6bf6000  ! 342: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xdaa544a0  ! 344: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	mov	0x58, %r19
	mov	0x40, %r19
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdecec9e0  ! 348: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r15
	.word 0xdef72000  ! 349: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdeafa000  ! 350: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd4b48400  ! 351: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd49dc4a0  ! 352: LDDA_R	ldda	[%r23, %r0] 0x25, %r10
	.word 0xd4dfe000  ! 353: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 354: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x40, %r19
	mov	0x20, %r26
	.word 0x87802020  ! 358: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b4e000  ! 359: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xda9544a0  ! 360: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0xda9ca000  ! 361: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xdad42000  ! 362: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 363: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdaac6000  ! 364: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xdacc2000  ! 365: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0x87802072  ! 366: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r19
	.word 0xd2bcc400  ! 368: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd4f70e40  ! 369: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0xd4ac0400  ! 370: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd4a7a000  ! 371: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 372: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4ad6000  ! 373: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0xd4cc8400  ! 374: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	mov	0x3d8, %r20
	.word 0xd4bd6000  ! 376: STDA_I	stda	%r10, [%r21 + 0x0000] %asi
	.word 0xd8c7ce80  ! 377: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r12
	.word 0x8780204f  ! 378: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r19
	.word 0xd8de2000  ! 380: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xd6cc4400  ! 381: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd6de6000  ! 382: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r11
	.word 0xd6dee000  ! 383: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	.word 0xde8689e0  ! 384: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0xd4bf4e60  ! 385: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 386: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 387: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a649e0  ! 388: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	.word 0xd0d5c4a0  ! 389: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0xd6f7ce80  ! 390: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd68e89e0  ! 391: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r11
	.word 0x87802025  ! 392: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bd6000  ! 393: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd8b649e0  ! 394: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	mov	0x7c0, %r20
	.word 0xd2bf8e60  ! 396: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	.word 0xd29d6000  ! 397: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0xd2bda000  ! 398: STDA_I	stda	%r9, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 399: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a78e60  ! 400: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd89f8e60  ! 401: LDDA_R	ldda	[%r30, %r0] 0x73, %r12
	mov	0x7e8, %r22
	.word 0x87802072  ! 403: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd887ce40  ! 404: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	.word 0xd28d44a0  ! 405: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xd2a7a000  ! 406: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd4cc4400  ! 407: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xdeb649e0  ! 408: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xdef76000  ! 409: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xde9f6000  ! 411: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0x87802073  ! 412: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde87e000  ! 413: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd2b7ce60  ! 414: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xd4a44400  ! 415: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xde9c4400  ! 416: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0xd8a78e60  ! 417: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	.word 0xd4ac8400  ! 418: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd8974e60  ! 419: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	.word 0xdaaf8e40  ! 420: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0xdaa76000  ! 421: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xda97a000  ! 422: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdadf2000  ! 423: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802073  ! 424: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r23
	.word 0xdeb70e40  ! 426: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xdad44400  ! 427: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0x87802073  ! 428: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r24
	.word 0x87802025  ! 430: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 431: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9fce40  ! 432: LDDA_R	ldda	[%r31, %r0] 0x72, %r15
	mov	0x18, %r27
	.word 0xd4df0e40  ! 434: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0xdac70e60  ! 435: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r13
	.word 0xd4ddc4a0  ! 436: LDXA_R	ldxa	[%r23, %r0] 0x25, %r10
	.word 0xd29d84a0  ! 437: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xd294a000  ! 438: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2f46000  ! 439: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bce000  ! 440: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 441: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 442: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cf6000  ! 443: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2f76000  ! 444: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xde87ce80  ! 445: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r15
	mov	0x40, %r18
	mov	0x3f8, %r22
	.word 0xd0ccc400  ! 448: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xd48f8e40  ! 449: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	.word 0xd4f7e000  ! 450: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 451: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d5a000  ! 452: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	.word 0xd4ade000  ! 453: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	.word 0xd4ade000  ! 454: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	.word 0xdab74e80  ! 455: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xd2bfce40  ! 456: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xd2ada000  ! 457: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xdaac0400  ! 458: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	mov	0x3d8, %r21
	.word 0xd6c40400  ! 460: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0xd485c4a0  ! 461: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r10
	mov	0x3f0, %r21
	.word 0xdab74e60  ! 463: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0xdab52000  ! 464: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdaad2000  ! 465: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xd09d44a0  ! 466: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	mov	0x70, %r19
	.word 0xd8df0e40  ! 468: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8856000  ! 470: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8af8e60  ! 471: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	mov	0x3f0, %r21
	.word 0xd2bc8400  ! 473: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xd2ad2000  ! 474: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd8f7ce80  ! 475: STXA_R	stxa	%r12, [%r31 + %r0] 0x74
	.word 0xd89de000  ! 476: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	mov	0x0, %r17
	.word 0xdaaf8e40  ! 478: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0xd6c74e80  ! 479: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r11
	.word 0xd0a504a0  ! 480: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0xd0ade000  ! 481: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	.word 0xd2bc8400  ! 482: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xd2ad6000  ! 483: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd0a44400  ! 484: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x7e8, %r23
	.word 0xdcc689e0  ! 486: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r14
	.word 0xdcbda000  ! 487: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xdc9d2000  ! 488: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	mov	0x8, %r26
	.word 0xd29fce80  ! 490: LDDA_R	ldda	[%r31, %r0] 0x74, %r9
	.word 0xde9e09e0  ! 491: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0x87802020  ! 492: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb4a000  ! 493: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 494: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde872000  ! 495: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xd4bf0e40  ! 496: STDA_R	stda	%r10, [%r28 + %r0] 0x72
	.word 0xd4b7e000  ! 497: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4cf2000  ! 498: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd6b48400  ! 499: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd69fe000  ! 500: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xdca6c9e0  ! 501: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xdcad44a0  ! 502: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	.word 0xd2d70e60  ! 503: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0xd28fa000  ! 504: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xd6bc0400  ! 505: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	mov	0x50, %r18
	.word 0xd8df8e80  ! 507: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xd0bfce80  ! 508: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	.word 0xd0f7a000  ! 509: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bfe000  ! 510: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd6d48400  ! 511: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd6b76000  ! 512: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd6afa000  ! 514: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xd6af4e60  ! 516: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xd6b7a000  ! 517: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6d76000  ! 518: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	mov	0x68, %r16
	.word 0x87802020  ! 520: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cc2000  ! 521: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r11
	mov	0x40, %r25
	.word 0xd6f46000  ! 523: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x70, %r25
	mov	0x28, %r24
	mov	0x28, %r19
	mov	0x40, %r19
	.word 0xd6cc6000  ! 529: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	mov	0x3f0, %r23
	.word 0xdc8e09e0  ! 531: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0xd2940400  ! 532: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0x87802073  ! 533: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8ad44a0  ! 534: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0xd8bfe000  ! 535: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd6ac0400  ! 536: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xd2df0e80  ! 537: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	mov	0x3f0, %r21
	.word 0x87802072  ! 539: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28f6000  ! 540: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2b70e40  ! 541: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	.word 0xde978e40  ! 542: LDUHA_R	lduha	[%r30, %r0] 0x72, %r15
	.word 0xde8f6000  ! 543: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xd2bf0e60  ! 544: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0xd2d76000  ! 545: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2a76000  ! 546: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xd8a40400  ! 548: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	mov	0x3f8, %r20
	mov	0x50, %r26
	.word 0xd8bfa000  ! 551: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xdebe89e0  ! 553: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xdecf2000  ! 554: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xd08f0e60  ! 555: LDUBA_R	lduba	[%r28, %r0] 0x73, %r8
	.word 0x87802073  ! 556: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r16
	.word 0xd884c400  ! 558: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xd8af2000  ! 559: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8d7e000  ! 560: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xda94c400  ! 561: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xd2b6c9e0  ! 562: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	mov	0x38, %r18
	.word 0xd2bc8400  ! 564: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xdcb78e60  ! 565: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xdcbfa000  ! 566: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 567: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 568: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb40400  ! 569: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd2b4c400  ! 570: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xd2bd2000  ! 571: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xd0a7ce40  ! 572: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	mov	0x78, %r27
	mov	0x3c8, %r20
	.word 0xd494c400  ! 575: LDUHA_R	lduha	[%r19, %r0] 0x20, %r10
	.word 0x87802072  ! 576: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cf6000  ! 577: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x28, %r27
	.word 0xd88f0e60  ! 579: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	.word 0xd897a000  ! 580: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f76000  ! 581: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	mov	0x3d0, %r23
	mov	0x30, %r27
	.word 0xd8af2000  ! 584: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xd48f8e60  ! 586: LDUBA_R	lduba	[%r30, %r0] 0x73, %r10
	.word 0xd4872000  ! 587: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xda84c400  ! 588: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xdabf2000  ! 589: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 590: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea584a0  ! 591: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0x87802072  ! 592: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r26
	.word 0xdeaf6000  ! 594: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd0cf8e40  ! 595: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	.word 0xdc940400  ! 596: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	.word 0xd484c400  ! 597: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x50, %r17
	.word 0xd6bf0e60  ! 600: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	.word 0xdea584a0  ! 601: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0xdea76000  ! 602: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0x8780204f  ! 604: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 605: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedda000  ! 606: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r15
	mov	0x28, %r18
	.word 0x87802020  ! 608: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r23
	mov	0x0, %r27
	.word 0x87802073  ! 611: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6cf4e80  ! 612: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r11
	.word 0xd6b4c400  ! 613: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd89c4400  ! 614: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xd0f544a0  ! 615: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 616: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ae2000  ! 617: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xd6940400  ! 618: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xd6aea000  ! 619: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	.word 0x87802074  ! 620: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cf6000  ! 621: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bfe000  ! 622: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6cfa000  ! 623: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6dfe000  ! 624: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	mov	0x40, %r19
	.word 0xd6972000  ! 626: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xdcd44400  ! 627: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xdc97a000  ! 628: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xd88504a0  ! 629: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r12
	.word 0x87802073  ! 630: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af0e60  ! 631: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xd2df2000  ! 632: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	mov	0x10, %r18
	mov	0x18, %r17
	.word 0xd2bfa000  ! 635: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 636: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bdc4a0  ! 637: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xdabf0e60  ! 638: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xd48f4e60  ! 639: LDUBA_R	lduba	[%r29, %r0] 0x73, %r10
	mov	0x3e8, %r20
	mov	0x38, %r19
	.word 0xd0840400  ! 642: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xde8f0e60  ! 643: LDUBA_R	lduba	[%r28, %r0] 0x73, %r15
	.word 0x87802072  ! 644: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8fe000  ! 645: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xdec7e000  ! 646: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 647: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bc8400  ! 648: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xdebc0400  ! 649: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	mov	0x40, %r27
	.word 0x87802020  ! 651: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 652: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb72000  ! 653: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	mov	0x70, %r19
	.word 0x87802074  ! 655: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r20
	.word 0xdeb7a000  ! 657: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd4dc0400  ! 658: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0xd49fe000  ! 659: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4dfa000  ! 660: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd88f8e40  ! 661: LDUBA_R	lduba	[%r30, %r0] 0x72, %r12
	.word 0xdca74e60  ! 662: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xd0b44400  ! 663: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd0bf2000  ! 664: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	mov	0x60, %r17
	.word 0xd2f70e60  ! 666: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xd297a000  ! 667: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xdc840400  ! 668: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	mov	0x68, %r25
	.word 0xdcd544a0  ! 670: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	mov	0x18, %r16
	.word 0xdcaf6000  ! 672: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdac74e40  ! 673: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r13
	.word 0xdcac0400  ! 674: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 675: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r19
	.word 0xdaa74e40  ! 677: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xdaac6000  ! 678: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 679: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf4a000  ! 680: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 681: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8dc4400  ! 682: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xdec40400  ! 683: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd8c78e40  ! 684: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	.word 0xdcc78e60  ! 685: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r14
	mov	0x7f0, %r23
	.word 0xdad44400  ! 687: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xd2f78e40  ! 688: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xd285e000  ! 689: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r9
	.word 0xd4a70e40  ! 690: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	mov	0x3c0, %r21
	.word 0xd49d6000  ! 692: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r10
	.word 0xdcc78e40  ! 693: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r14
	.word 0x87802020  ! 694: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 695: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8c8400  ! 696: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0xdcb46000  ! 697: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xd886c9e0  ! 698: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r12
	.word 0xd8ac6000  ! 699: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 700: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd68d84a0  ! 701: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	mov	0x3d0, %r23
	.word 0xd4c78e40  ! 703: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r10
	.word 0xd4d7e000  ! 704: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4f7a000  ! 705: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a72000  ! 706: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4f70e80  ! 707: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0xd4a76000  ! 708: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 709: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r16
	.word 0xd4d72000  ! 711: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xde848400  ! 712: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	mov	0x58, %r25
	.word 0xdcbf4e80  ! 714: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xdcb72000  ! 715: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 716: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf42000  ! 717: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	mov	0x8, %r16
	mov	0x60, %r26
	.word 0xdcf4e000  ! 720: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcaca000  ! 721: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xda9d44a0  ! 722: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xdad46000  ! 723: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xda8c6000  ! 724: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0x87802025  ! 725: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68f0e60  ! 726: LDUBA_R	lduba	[%r28, %r0] 0x73, %r11
	mov	0x8, %r18
	.word 0xd695e000  ! 728: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r11
	.word 0xd6dd6000  ! 729: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6d52000  ! 730: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r11
	.word 0xdab78e80  ! 731: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xdea544a0  ! 732: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xdab74e40  ! 733: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0x87802020  ! 734: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9d04a0  ! 735: LDDA_R	ldda	[%r20, %r0] 0x25, %r14
	.word 0xdcbc6000  ! 736: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdc8ca000  ! 737: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r14
	.word 0x87802025  ! 738: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r18
	.word 0xdeb4c400  ! 740: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xde95a000  ! 741: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r15
	.word 0xde95a000  ! 742: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r15
	.word 0xdebde000  ! 743: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xdec52000  ! 745: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r15
	mov	0x7f8, %r22
	.word 0x87802025  ! 747: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r24
	.word 0xde96c9e0  ! 749: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r15
	mov	0x20, %r27
	.word 0xdebda000  ! 751: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xdebde000  ! 752: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 753: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebc8400  ! 754: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	mov	0x3e0, %r22
	.word 0xdeafe000  ! 756: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdea76000  ! 757: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xde876000  ! 758: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdef76000  ! 759: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xd8f70e80  ! 760: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xd8afa000  ! 761: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 762: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd88da000  ! 763: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r12
	.word 0xdaa5c4a0  ! 764: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	mov	0x38, %r27
	mov	0x38, %r19
	mov	0x50, %r18
	.word 0xd6af4e40  ! 768: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0xd6bd6000  ! 769: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	mov	0x7d0, %r21
	mov	0x70, %r18
	.word 0xd6878e40  ! 772: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0xdad544a0  ! 773: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r13
	.word 0x87802020  ! 774: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8af8e80  ! 775: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	.word 0xd8b4a000  ! 776: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd2ac8400  ! 777: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	.word 0xd2ac2000  ! 778: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 779: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ce49e0  ! 780: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xd4bf6000  ! 781: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xdc9f4e40  ! 782: LDDA_R	ldda	[%r29, %r0] 0x72, %r14
	.word 0xdca40400  ! 783: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdef44400  ! 784: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x50, %r26
	.word 0xde9c8400  ! 786: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xdcccc400  ! 787: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r14
	.word 0xdca7e000  ! 788: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd4bcc400  ! 789: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd4a72000  ! 790: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xdebe89e0  ! 791: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xde8f2000  ! 792: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0x87802073  ! 793: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 794: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef66000  ! 795: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	.word 0xdcf70e40  ! 796: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xdcb6e000  ! 797: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 798: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc978e80  ! 799: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	mov	0x0, %r24
	mov	0x7d8, %r21
	.word 0xdcdc2000  ! 802: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xd4b504a0  ! 803: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xd4f4e000  ! 804: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x28, %r25
	.word 0xd4970e40  ! 807: LDUHA_R	lduha	[%r28, %r0] 0x72, %r10
	mov	0x10, %r25
	mov	0x3c0, %r22
	.word 0xdcb7ce60  ! 810: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xd6a649e0  ! 811: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	mov	0x18, %r19
	.word 0xd297ce40  ! 813: LDUHA_R	lduha	[%r31, %r0] 0x72, %r9
	.word 0xd2f4e000  ! 814: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2f46000  ! 815: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 816: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0df0e40  ! 817: LDXA_R	ldxa	[%r28, %r0] 0x72, %r8
	.word 0xd0ce2000  ! 818: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r8
	.word 0xd0f66000  ! 819: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd0966000  ! 820: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0x87802020  ! 821: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ac6000  ! 822: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xd0f4e000  ! 823: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0f42000  ! 824: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd094e000  ! 825: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd8df8e40  ! 826: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	mov	0x40, %r19
	mov	0x20, %r19
	.word 0xd8d4e000  ! 829: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	mov	0x18, %r25
	.word 0x87802074  ! 831: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r22
	.word 0xdad44400  ! 833: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xdadf6000  ! 834: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdec5c4a0  ! 835: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r15
	mov	0x70, %r16
	.word 0xd4bd04a0  ! 837: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0xd4df6000  ! 838: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd496c9e0  ! 839: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r10
	mov	0x7d8, %r20
	mov	0x20, %r24
	.word 0xd4af2000  ! 842: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 843: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6de09e0  ! 844: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	mov	0x28, %r16
	mov	0x20, %r16
	.word 0xd6ac2000  ! 847: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a42000  ! 848: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 849: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd696e000  ! 850: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0x87802074  ! 851: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bfe000  ! 852: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xdab70e60  ! 854: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	mov	0x28, %r19
	.word 0xdad7a000  ! 856: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0x87802074  ! 857: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 858: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd08c4400  ! 859: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	.word 0xd8a44400  ! 860: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd8dfe000  ! 861: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0x87802072  ! 862: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f7e000  ! 863: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd4b74e80  ! 864: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	mov	0x8, %r19
	.word 0xd49fe000  ! 866: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	mov	0x68, %r18
	.word 0x87802074  ! 868: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4dcc400  ! 869: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xd6a609e0  ! 870: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	.word 0xd6cf6000  ! 871: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0x87802020  ! 872: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c46000  ! 873: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	mov	0x8, %r18
	mov	0x3f0, %r21
	mov	0x7f8, %r21
	.word 0xd4b7ce60  ! 877: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xd4bca000  ! 878: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4f46000  ! 879: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd49ce000  ! 880: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd4a42000  ! 881: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xdeb78e60  ! 882: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0x87802072  ! 883: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded76000  ! 884: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	mov	0x7d8, %r21
	.word 0xde9f2000  ! 886: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdeb72000  ! 887: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdecf2000  ! 888: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xd2b689e0  ! 889: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 890: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 891: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d689e0  ! 892: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	.word 0xd2b46000  ! 893: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	.word 0xd4a6c9e0  ! 894: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xd4b42000  ! 895: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd4dc6000  ! 896: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	mov	0x28, %r16
	.word 0xd4d42000  ! 898: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xd89f4e40  ! 899: LDDA_R	ldda	[%r29, %r0] 0x72, %r12
	.word 0xd8b4c400  ! 900: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd6df0e60  ! 901: LDXA_R	ldxa	[%r28, %r0] 0x73, %r11
	.word 0xd69c2000  ! 902: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r11
	.word 0xd6a42000  ! 903: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 904: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 905: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r23
	.word 0xd6b6a000  ! 907: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xdaa504a0  ! 908: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0x87802074  ! 909: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda872000  ! 910: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xdcaf4e40  ! 911: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0x87802020  ! 912: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r26
	.word 0xdc8ce000  ! 914: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xd4a584a0  ! 915: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0xd4c46000  ! 916: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd6cc8400  ! 917: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xdcae89e0  ! 918: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xd8c48400  ! 919: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xd8f42000  ! 920: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd89ce000  ! 921: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	mov	0x3c0, %r23
	.word 0xd8bca000  ! 923: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8ac2000  ! 924: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd8b46000  ! 926: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 927: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8d76000  ! 928: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8c72000  ! 929: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8df2000  ! 930: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	mov	0x7f8, %r22
	.word 0xdaf7ce80  ! 932: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xdabfa000  ! 933: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 934: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a609e0  ! 935: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	.word 0xd0bf4e60  ! 936: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	mov	0x58, %r18
	.word 0x87802025  ! 938: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49fce40  ! 939: LDDA_R	ldda	[%r31, %r0] 0x72, %r10
	mov	0x48, %r17
	.word 0xd8bc8400  ! 941: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd8bd2000  ! 942: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xd0840400  ! 943: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd0dde000  ! 944: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0d52000  ! 945: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0xd0d56000  ! 946: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0xd0a56000  ! 947: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd09da000  ! 949: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0xd08d2000  ! 950: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r8
	mov	0x3c0, %r22
	.word 0xde844400  ! 952: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0x87802073  ! 953: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cf0e40  ! 954: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xd2b76000  ! 955: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 956: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 957: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a7ce60  ! 958: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xdab78e80  ! 959: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xdabc6000  ! 960: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xd0df8e80  ! 961: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	mov	0x58, %r26
	.word 0x87802025  ! 963: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r18
	.word 0xd0dd6000  ! 965: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd095e000  ! 966: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r8
	.word 0xd4b74e40  ! 967: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0x87802074  ! 968: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r22
	.word 0xd8d7ce60  ! 970: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r12
	.word 0xd49f8e60  ! 971: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	.word 0xd487a000  ! 972: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd29fce40  ! 973: LDDA_R	ldda	[%r31, %r0] 0x72, %r9
	.word 0xd884c400  ! 974: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xd69c8400  ! 975: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xd8cfce60  ! 976: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r12
	.word 0xd6b74e80  ! 977: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xdca5c4a0  ! 978: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xd2ae89e0  ! 979: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xd2bf2000  ! 980: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd6af0e60  ! 981: STBA_R	stba	%r11, [%r28 + %r0] 0x73
	.word 0x87802072  ! 982: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bf6000  ! 983: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cfa000  ! 984: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6bfa000  ! 985: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	mov	0x58, %r24
	.word 0x87802020  ! 987: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb48400  ! 988: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xdcc4a000  ! 989: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802025  ! 990: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d0, %r21
	mov	0x3e8, %r20
	.word 0xdcb5a000  ! 993: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xda9f4e80  ! 994: LDDA_R	ldda	[%r29, %r0] 0x74, %r13
	mov	0x18, %r17
	mov	0x7c8, %r22
	mov	0x7f8, %r23
	.word 0x87802025  ! 998: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f40400  ! 999: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd0c5e000  ! 1000: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0852000  ! 1001: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1002: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08e2000  ! 1003: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd4dc0400  ! 1004: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	mov	0x3c8, %r21
	.word 0xd4aea000  ! 1006: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xdcddc4a0  ! 1007: LDXA_R	ldxa	[%r23, %r0] 0x25, %r14
	.word 0xdcf40400  ! 1008: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdcae2000  ! 1009: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	.word 0xdcf66000  ! 1010: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	.word 0xdcaea000  ! 1011: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xd8ddc4a0  ! 1012: LDXA_R	ldxa	[%r23, %r0] 0x25, %r12
	mov	0x3c0, %r22
	.word 0xd886e000  ! 1014: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xde970e80  ! 1015: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	mov	0x40, %r19
	mov	0x70, %r26
	.word 0x87802020  ! 1018: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6840400  ! 1019: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd68c2000  ! 1020: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	.word 0xdeafce40  ! 1021: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	mov	0x58, %r25
	.word 0xdec46000  ! 1023: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	.word 0xd2cc0400  ! 1024: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802073  ! 1026: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c7a000  ! 1027: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd8a44400  ! 1028: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0x87802025  ! 1029: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c44400  ! 1030: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0xda9c8400  ! 1031: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	.word 0xdad52000  ! 1032: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1033: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28f8e40  ! 1034: LDUBA_R	lduba	[%r30, %r0] 0x72, %r9
	mov	0x30, %r25
	mov	0x58, %r16
	.word 0xd294a000  ! 1037: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd8adc4a0  ! 1038: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xd8bc2000  ! 1039: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8c42000  ! 1040: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x78, %r17
	.word 0x8780204f  ! 1042: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8862000  ! 1043: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	mov	0x68, %r16
	.word 0xd8aee000  ! 1045: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xdc8544a0  ! 1046: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0xd6c7ce60  ! 1047: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	.word 0xd6bea000  ! 1048: STDA_I	stda	%r11, [%r26 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xd8bc0400  ! 1050: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1051: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r17
	.word 0xd8d544a0  ! 1053: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	.word 0x8780204f  ! 1054: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8dc0400  ! 1055: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0x87802020  ! 1056: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c40400  ! 1057: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xd8c46000  ! 1058: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	mov	0x50, %r25
	mov	0x7d0, %r22
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2df0e80  ! 1062: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	.word 0xd2ac6000  ! 1063: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd28ce000  ! 1064: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0xd6c70e80  ! 1065: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	mov	0x68, %r18
	.word 0xd6ac2000  ! 1067: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 1068: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r24
	.word 0xd696e000  ! 1070: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xd6be2000  ! 1071: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xd6bfce40  ! 1073: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd6cea000  ! 1074: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	.word 0xdab5c4a0  ! 1075: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	.word 0xd0dc8400  ! 1076: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd0d62000  ! 1077: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r8
	mov	0x28, %r16
	.word 0xd4974e40  ! 1079: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0x87802072  ! 1080: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f7a000  ! 1081: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bf2000  ! 1082: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xdaaf4e60  ! 1083: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xda9f6000  ! 1084: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xd2a70e60  ! 1085: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	mov	0x20, %r26
	.word 0x8780204f  ! 1087: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r21
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2be2000  ! 1090: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd2de6000  ! 1091: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcdd04a0  ! 1093: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	.word 0xdc862000  ! 1094: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	.word 0xdcb6a000  ! 1095: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	.word 0xdcd66000  ! 1096: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	.word 0xdcbe2000  ! 1097: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0xdede49e0  ! 1098: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r15
	.word 0xd2b44400  ! 1099: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xdef74e60  ! 1100: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xd086c9e0  ! 1101: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r8
	.word 0xdedd84a0  ! 1102: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	.word 0xdc8c0400  ! 1103: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0xdcb6a000  ! 1104: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	.word 0xdc8ea000  ! 1105: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	mov	0x18, %r27
	.word 0xdadf8e40  ! 1107: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0xdabee000  ! 1108: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xd09ec9e0  ! 1109: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	mov	0x0, %r16
	.word 0xd6d44400  ! 1111: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xd8cf8e60  ! 1112: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0xd8ce6000  ! 1113: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0xd89ee000  ! 1114: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r12
	.word 0x87802072  ! 1115: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4948400  ! 1116: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd4bf6000  ! 1117: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd49f6000  ! 1118: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a609e0  ! 1119: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	mov	0x0, %r17
	mov	0x3d0, %r20
	.word 0xd487a000  ! 1122: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xdc8fce80  ! 1123: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	.word 0xdc972000  ! 1124: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 1125: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x7c0, %r20
	.word 0xd6b40400  ! 1127: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xdac7ce40  ! 1128: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r13
	.word 0xdeb7ce80  ! 1129: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	mov	0x48, %r16
	mov	0x78, %r16
	.word 0xde8f6000  ! 1132: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xdebe89e0  ! 1133: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xdec72000  ! 1134: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdeb544a0  ! 1135: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0xdeaf6000  ! 1136: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd6f78e60  ! 1137: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0x87802020  ! 1138: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1139: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a7a000  ! 1140: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xd68fa000  ! 1142: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r11
	mov	0x0, %r17
	.word 0xd6bfa000  ! 1144: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6dfa000  ! 1145: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 1146: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd8c649e0  ! 1147: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r12
	.word 0xd8b76000  ! 1148: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd8878e80  ! 1149: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	.word 0xd8d72000  ! 1150: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8afa000  ! 1151: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	mov	0x50, %r18
	.word 0xd8a72000  ! 1153: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8c72000  ! 1154: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bf6000  ! 1155: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd49fce80  ! 1156: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	.word 0xd8f609e0  ! 1157: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 1158: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4a000  ! 1159: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1160: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8df2000  ! 1161: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xdaf4c400  ! 1162: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdab72000  ! 1163: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 1164: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e8, %r22
	mov	0x10, %r26
	.word 0xdabf6000  ! 1167: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xd69c8400  ! 1169: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0x87802020  ! 1170: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6842000  ! 1171: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6bce000  ! 1172: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0xd6b4a000  ! 1173: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xd6a46000  ! 1174: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd0f70e40  ! 1176: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd0a42000  ! 1177: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1178: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08ce000  ! 1179: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f46000  ! 1180: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	mov	0x78, %r24
	mov	0x28, %r18
	.word 0x87802025  ! 1183: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1184: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2840400  ! 1185: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0xd6940400  ! 1186: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xd6b66000  ! 1187: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	.word 0xd08e09e0  ! 1188: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	mov	0x10, %r25
	.word 0xdcad04a0  ! 1190: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0xdadfce80  ! 1191: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0xdab62000  ! 1192: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0x87802074  ! 1193: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r21
	.word 0xd0cec9e0  ! 1195: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r8
	mov	0x3d8, %r20
	.word 0x87802025  ! 1197: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a40400  ! 1198: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	mov	0x40, %r18
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 1201: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a4a000  ! 1202: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0c4a000  ! 1203: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0cca000  ! 1204: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r8
	mov	0x3e8, %r22
	.word 0xd094a000  ! 1206: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd88c8400  ! 1207: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0xd2f74e60  ! 1208: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	mov	0x48, %r26
	mov	0x7e0, %r22
	.word 0x87802074  ! 1211: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8ac4400  ! 1212: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd8bfa000  ! 1213: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd4ce49e0  ! 1214: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xd4d544a0  ! 1215: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xd4afe000  ! 1216: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd4a5c4a0  ! 1217: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xdebe89e0  ! 1218: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	ta	T_CHANGE_HPRIV	! macro
	.word 0xde8fa000  ! 1220: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802025  ! 1221: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef52000  ! 1222: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 1223: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde846000  ! 1224: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	mov	0x70, %r19
	.word 0x87802073  ! 1226: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r24
	mov	0x28, %r24
	mov	0x10, %r19
	.word 0xdc8fce40  ! 1230: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	.word 0xdca72000  ! 1231: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcf584a0  ! 1232: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0x87802073  ! 1233: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1234: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbf6000  ! 1235: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdaac4400  ! 1236: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 1237: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bf0e40  ! 1238: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	mov	0x8, %r17
	.word 0x87802020  ! 1240: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d46000  ! 1241: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r11
	.word 0xd0f78e80  ! 1242: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	mov	0x3c8, %r22
	.word 0xd0f4a000  ! 1244: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 1245: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd097e000  ! 1246: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xde8504a0  ! 1247: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0xde9fe000  ! 1248: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xde8fe000  ! 1249: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802025  ! 1250: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r16
	mov	0x50, %r18
	.word 0x87802074  ! 1253: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedf0e60  ! 1254: LDXA_R	ldxa	[%r28, %r0] 0x73, %r15
	mov	0x78, %r19
	ta	T_CHANGE_HPRIV	! macro
	mov	0x70, %r27
	.word 0xd29c4400  ! 1258: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd2afa000  ! 1259: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x68, %r17
	mov	0x0, %r27
	mov	0x7e8, %r23
	.word 0xd2bf6000  ! 1263: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b7a000  ! 1264: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd0bd44a0  ! 1265: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xd8bf8e80  ! 1266: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	mov	0x3d0, %r20
	.word 0xd8bfe000  ! 1268: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd6c70e80  ! 1269: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	mov	0x20, %r26
	.word 0xd6bf2000  ! 1271: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x78, %r17
	mov	0x60, %r24
	mov	0x7e8, %r22
	mov	0x18, %r27
	.word 0xd6d7ce40  ! 1276: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r11
	.word 0xd69f2000  ! 1277: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0x87802073  ! 1278: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f72000  ! 1279: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 1280: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1281: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bc2000  ! 1282: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1283: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd486c9e0  ! 1284: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	mov	0x38, %r18
	.word 0x87802072  ! 1286: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bf2000  ! 1287: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd4976000  ! 1288: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r10
	.word 0xd4878e40  ! 1289: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r10
	.word 0xd4bf6000  ! 1290: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x48, %r17
	.word 0x87802073  ! 1292: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49f2000  ! 1293: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1294: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb74e60  ! 1295: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0xdcf5a000  ! 1296: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 1297: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcaf0e60  ! 1298: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0xd6afce40  ! 1299: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	.word 0xd6c5e000  ! 1300: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r11
	.word 0xd4f609e0  ! 1301: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	mov	0x50, %r18
	.word 0xd4f56000  ! 1303: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 1304: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdecdc4a0  ! 1305: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	.word 0xde972000  ! 1306: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	mov	0x7f8, %r21
	mov	0x60, %r19
	.word 0xdeac8400  ! 1309: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xdef76000  ! 1310: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	mov	0x7e8, %r22
	mov	0x7f8, %r21
	.word 0xdea7e000  ! 1313: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd0c609e0  ! 1314: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r8
	.word 0xd6a78e60  ! 1315: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd6bf6000  ! 1316: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xde8fce40  ! 1317: LDUBA_R	lduba	[%r31, %r0] 0x72, %r15
	mov	0x60, %r18
	.word 0x87802020  ! 1319: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1320: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdedfa000  ! 1321: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x7e8, %r22
	.word 0xd89d84a0  ! 1323: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0xdaf4c400  ! 1324: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0acc400  ! 1326: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd0a7a000  ! 1327: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xdcd70e80  ! 1328: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0xdcb76000  ! 1329: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd8f70e60  ! 1330: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	.word 0xd88fe000  ! 1331: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xded78e60  ! 1332: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r15
	mov	0x68, %r19
	.word 0xdedfe000  ! 1334: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0x87802074  ! 1335: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef7a000  ! 1336: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdc8fce80  ! 1337: LDUBA_R	lduba	[%r31, %r0] 0x74, %r14
	.word 0xd0ac8400  ! 1338: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xde8c8400  ! 1339: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	mov	0x40, %r25
	.word 0x87802020  ! 1341: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde846000  ! 1342: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	mov	0x20, %r17
	mov	0x48, %r18
	.word 0xdea46000  ! 1345: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdecca000  ! 1346: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r15
	mov	0x7e0, %r20
	mov	0x0, %r18
	mov	0x3c0, %r21
	.word 0xd0870e80  ! 1350: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r8
	.word 0xd0f46000  ! 1351: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 1352: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r26
	.word 0x87802073  ! 1354: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r19
	.word 0xd8bcc400  ! 1356: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1357: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a504a0  ! 1358: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	mov	0x10, %r18
	.word 0x87802025  ! 1360: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b5e000  ! 1361: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	mov	0x30, %r18
	.word 0x87802073  ! 1363: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r18
	.word 0xd29f2000  ! 1365: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1366: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f7e000  ! 1367: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1368: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1369: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d8, %r20
	.word 0xd29f2000  ! 1371: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd4d78e80  ! 1372: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0xd6c48400  ! 1373: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd8dd44a0  ! 1374: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0x87802072  ! 1375: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0af8e60  ! 1376: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0xd08f2000  ! 1377: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd29e89e0  ! 1378: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	.word 0xd8df0e40  ! 1379: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	.word 0xd8bfe000  ! 1380: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd2a48400  ! 1381: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x7e0, %r23
	.word 0xd29f2000  ! 1383: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd29f2000  ! 1384: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xd2dfe000  ! 1385: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x0, %r19
	.word 0xd2972000  ! 1387: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bf2000  ! 1388: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2f76000  ! 1389: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	mov	0x50, %r18
	mov	0x0, %r26
	mov	0x20, %r16
	.word 0x87802072  ! 1393: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d7a000  ! 1394: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	mov	0x30, %r17
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2bf2000  ! 1397: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xd2f7a000  ! 1399: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xdeb44400  ! 1400: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xd6be89e0  ! 1401: STDA_R	stda	%r11, [%r26 + %r0] 0x4f
	mov	0x38, %r19
	mov	0x8, %r24
	.word 0xd6bfa000  ! 1404: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd0f74e60  ! 1405: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0xd2d609e0  ! 1406: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r9
	.word 0xd2cd44a0  ! 1407: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	.word 0xd2872000  ! 1408: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 1409: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd28f2000  ! 1410: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1411: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bc2000  ! 1412: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd0afce80  ! 1413: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd89d84a0  ! 1414: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0xd89ce000  ! 1415: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd884e000  ! 1416: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8f4a000  ! 1417: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8d42000  ! 1418: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8aca000  ! 1419: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd8aca000  ! 1420: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xdab7ce80  ! 1421: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	mov	0x70, %r16
	.word 0xdebd04a0  ! 1423: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xd0b7ce80  ! 1424: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0xdcb544a0  ! 1425: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	mov	0x3f0, %r23
	.word 0xd09609e0  ! 1427: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r8
	.word 0xdea48400  ! 1428: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	mov	0x58, %r26
	.word 0xde8c6000  ! 1430: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	mov	0x40, %r16
	.word 0xd6f4c400  ! 1432: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x7f8, %r20
	.word 0xd884c400  ! 1434: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xd8f44400  ! 1435: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	mov	0x10, %r27
	.word 0xd8946000  ! 1437: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8dc6000  ! 1438: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8cca000  ! 1439: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r12
	.word 0xdc84c400  ! 1440: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xdcc4a000  ! 1441: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf46000  ! 1442: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0x87802073  ! 1444: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1445: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f689e0  ! 1446: STXA_R	stxa	%r9, [%r26 + %r0] 0x4f
	mov	0x50, %r18
	.word 0xd2ac4400  ! 1448: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1449: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dce000  ! 1450: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	mov	0x7e8, %r22
	.word 0x87802020  ! 1452: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec44400  ! 1453: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xdeac2000  ! 1454: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdeb4a000  ! 1455: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xde8ce000  ! 1457: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0x87802025  ! 1458: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9689e0  ! 1459: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r15
	.word 0xde95e000  ! 1460: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r15
	.word 0xda8cc400  ! 1461: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xdaf56000  ! 1462: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xda9de000  ! 1463: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xda85e000  ! 1464: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xdccf0e40  ! 1465: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	mov	0x3c0, %r23
	mov	0x68, %r17
	.word 0x87802072  ! 1468: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 1469: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbfa000  ! 1470: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdca7a000  ! 1471: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xd0c544a0  ! 1473: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r8
	mov	0x20, %r18
	.word 0xd69e49e0  ! 1475: LDDA_R	ldda	[%r25, %r0] 0x4f, %r11
	.word 0xd6bfe000  ! 1476: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x7e0, %r20
	mov	0x8, %r27
	.word 0xdea74e60  ! 1479: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	.word 0xde8f2000  ! 1480: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	mov	0x3f8, %r23
	.word 0xdedfa000  ! 1482: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdabc4400  ! 1483: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xdabf4e60  ! 1484: STDA_R	stda	%r13, [%r29 + %r0] 0x73
	mov	0x58, %r26
	mov	0x3f8, %r23
	mov	0x50, %r17
	.word 0xda9fa000  ! 1488: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	.word 0xd89e89e0  ! 1489: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0xd8bfce40  ! 1490: STDA_R	stda	%r12, [%r31 + %r0] 0x72
	.word 0xdcdec9e0  ! 1491: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	mov	0x3f0, %r21
	.word 0xdeacc400  ! 1493: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd8b504a0  ! 1494: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	.word 0xd8f76000  ! 1495: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8dfe000  ! 1496: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x60, %r16
	.word 0x87802025  ! 1498: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd88d6000  ! 1499: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	.word 0xd8c56000  ! 1500: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0xd8dda000  ! 1501: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xd6874e60  ! 1502: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r11
	.word 0x87802072  ! 1503: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda940400  ! 1504: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	ta	T_CHANGE_PRIV	! macro
	mov	0x7c0, %r23
	.word 0xda872000  ! 1507: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda942000  ! 1509: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdabc6000  ! 1510: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xdaac6000  ! 1511: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xdaa4e000  ! 1512: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 1513: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac7ce40  ! 1514: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r13
	.word 0xd8f44400  ! 1515: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd8afe000  ! 1516: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8bf2000  ! 1517: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd897e000  ! 1518: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b76000  ! 1519: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1520: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cce000  ! 1521: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	mov	0x3e8, %r23
	.word 0xd8b4a000  ! 1523: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd8ac6000  ! 1524: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd8f42000  ! 1525: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd0f7ce80  ! 1526: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xd0ac6000  ! 1527: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd0bca000  ! 1529: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd0ac2000  ! 1531: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd094e000  ! 1532: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0b4e000  ! 1533: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd0dc2000  ! 1534: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0bce000  ! 1535: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x7d8, %r20
	mov	0x50, %r27
	.word 0xd4a4c400  ! 1538: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	mov	0x60, %r18
	.word 0xdaac8400  ! 1540: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0x87802025  ! 1541: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49f0e40  ! 1542: LDDA_R	ldda	[%r28, %r0] 0x72, %r10
	.word 0xd2cf0e40  ! 1543: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0xd2ade000  ! 1544: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 1545: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcc74e60  ! 1546: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	.word 0xd2dc8400  ! 1547: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xda9f8e60  ! 1548: LDDA_R	ldda	[%r30, %r0] 0x73, %r13
	.word 0x87802074  ! 1549: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa76000  ! 1550: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdec7ce80  ! 1551: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r15
	.word 0xdedfa000  ! 1552: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xded7e000  ! 1553: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802025  ! 1554: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bd44a0  ! 1555: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xdaaf8e40  ! 1556: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	mov	0x0, %r27
	.word 0xda9da000  ! 1558: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r13
	.word 0xdaf5a000  ! 1559: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xd09ec9e0  ! 1560: LDDA_R	ldda	[%r27, %r0] 0x4f, %r8
	.word 0xd0cf8e40  ! 1561: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	.word 0xdcc40400  ! 1562: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	mov	0x10, %r16
	.word 0xd6ad84a0  ! 1564: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xd6cd2000  ! 1565: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	.word 0xd4d74e60  ! 1566: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r10
	.word 0xd4d56000  ! 1567: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x8, %r27
	.word 0xd4a5a000  ! 1570: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0xdab7ce60  ! 1571: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0x87802072  ! 1572: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1573: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c8, %r23
	mov	0x68, %r26
	.word 0x87802020  ! 1576: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab42000  ! 1577: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdac4a000  ! 1578: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	mov	0x50, %r18
	mov	0x30, %r19
	mov	0x70, %r18
	.word 0xda84e000  ! 1582: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802025  ! 1583: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8d6000  ! 1584: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0xd88d84a0  ! 1585: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	mov	0x3d8, %r22
	.word 0xd8c5a000  ! 1587: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1588: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 1589: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b7e000  ! 1590: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd8df2000  ! 1591: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd6bc0400  ! 1592: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd6b72000  ! 1593: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a7e000  ! 1594: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1595: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a46000  ! 1596: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xd2cd04a0  ! 1598: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	.word 0xdead44a0  ! 1599: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 1601: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc84c400  ! 1602: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xd08c0400  ! 1603: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xd6d4c400  ! 1604: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xdcdcc400  ! 1605: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xdc84e000  ! 1606: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	mov	0x8, %r19
	mov	0x20, %r18
	.word 0xd2ad84a0  ! 1609: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	mov	0x38, %r17
	.word 0xd6b48400  ! 1611: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd69c8400  ! 1612: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xdcac8400  ! 1613: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1614: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r17
	.word 0xdcbca000  ! 1616: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdca6c9e0  ! 1617: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xdcf4e000  ! 1618: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcd7ce40  ! 1619: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0xdcb46000  ! 1620: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdca42000  ! 1621: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x3c8, %r23
	.word 0xdc846000  ! 1623: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	mov	0x0, %r25
	.word 0x8780204f  ! 1625: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdccee000  ! 1626: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r14
	mov	0x7d8, %r23
	mov	0x3d8, %r21
	.word 0x8780204f  ! 1629: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcce6000  ! 1630: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	.word 0xde844400  ! 1631: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xdcbec9e0  ! 1632: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xdc866000  ! 1633: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0xd485c4a0  ! 1634: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r10
	mov	0x3c8, %r22
	.word 0xd4f4c400  ! 1636: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0x87802072  ! 1637: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1638: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r18
	.word 0xd4b584a0  ! 1640: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0xd89f4e40  ! 1641: LDDA_R	ldda	[%r29, %r0] 0x72, %r12
	.word 0xdaccc400  ! 1642: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r13
	mov	0x30, %r24
	.word 0xdcc6c9e0  ! 1644: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r14
	.word 0xdca42000  ! 1645: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x7f8, %r22
	.word 0xdcbca000  ! 1647: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcac2000  ! 1648: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 1649: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 1650: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca6a000  ! 1651: STWA_I	stwa	%r14, [%r26 + 0x0000] %asi
	.word 0xd8a4c400  ! 1652: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd8f66000  ! 1653: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xd89ea000  ! 1654: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	.word 0xd8b62000  ! 1655: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xd8c6a000  ! 1657: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8c62000  ! 1658: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	.word 0xd2a44400  ! 1659: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd2aea000  ! 1660: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd2be6000  ! 1661: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2862000  ! 1662: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1663: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f44400  ! 1664: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0xd0f7a000  ! 1665: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0876000  ! 1666: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xdef74e40  ! 1667: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0x87802073  ! 1668: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89e89e0  ! 1669: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0xd6cc8400  ! 1670: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd6f7a000  ! 1671: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xdabe89e0  ! 1672: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xded74e80  ! 1673: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r15
	.word 0x87802074  ! 1674: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d0, %r22
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3e0, %r22
	.word 0x87802073  ! 1678: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1679: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0be89e0  ! 1680: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd0f544a0  ! 1681: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xdc94c400  ! 1682: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	.word 0xdccca000  ! 1683: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	mov	0x70, %r16
	.word 0xdccc2000  ! 1685: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	.word 0xd0c78e80  ! 1686: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r8
	.word 0xd6f74e60  ! 1687: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xdc948400  ! 1688: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	mov	0x7d0, %r20
	.word 0xd6b7ce60  ! 1690: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0xd684a000  ! 1691: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 1692: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69ea000  ! 1693: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r11
	.word 0xd2bec9e0  ! 1694: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 1695: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b504a0  ! 1696: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xdabdc4a0  ! 1697: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xd0af4e60  ! 1698: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0xdef78e60  ! 1699: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0xdea46000  ! 1700: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdcadc4a0  ! 1701: STBA_R	stba	%r14, [%r23 + %r0] 0x25
	.word 0xdcc4e000  ! 1702: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	mov	0x3e8, %r22
	mov	0x38, %r25
	.word 0xdc8ce000  ! 1705: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xd8974e40  ! 1706: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	.word 0x87802073  ! 1707: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49c4400  ! 1708: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xd4bfe000  ! 1709: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x68, %r25
	mov	0x70, %r17
	.word 0xd4f76000  ! 1712: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd8b70e60  ! 1713: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	mov	0x18, %r24
	.word 0xd68584a0  ! 1715: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r11
	.word 0x87802025  ! 1716: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a52000  ! 1717: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xdca584a0  ! 1718: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	mov	0x48, %r26
	.word 0xdc95e000  ! 1720: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	mov	0x18, %r25
	.word 0xd6f48400  ! 1722: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd6ad2000  ! 1723: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xd6bc0400  ! 1724: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	mov	0x7e8, %r23
	.word 0xd6dd6000  ! 1726: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6cd6000  ! 1727: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	mov	0x3e0, %r23
	mov	0x10, %r27
	.word 0xd2c689e0  ! 1730: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0xdcb78e60  ! 1731: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xdca56000  ! 1732: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0xdc856000  ! 1733: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r14
	mov	0x8, %r25
	.word 0x87802074  ! 1735: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b689e0  ! 1736: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0xd4f7e000  ! 1737: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1738: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4878e80  ! 1739: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0xd2a584a0  ! 1740: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	mov	0x3e8, %r22
	.word 0x87802074  ! 1742: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c72000  ! 1743: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd48fce80  ! 1744: LDUBA_R	lduba	[%r31, %r0] 0x74, %r10
	mov	0x40, %r26
	mov	0x58, %r27
	.word 0xd4a7a000  ! 1747: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x60, %r16
	mov	0x48, %r19
	mov	0x7c8, %r23
	.word 0xd49f2000  ! 1751: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4c76000  ! 1752: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	mov	0x7c8, %r22
	mov	0x20, %r17
	.word 0xd4df2000  ! 1755: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	mov	0x8, %r16
	.word 0xd49f6000  ! 1757: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1758: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r22
	mov	0x8, %r27
	.word 0x87802025  ! 1761: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xded649e0  ! 1762: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	.word 0xdeade000  ! 1763: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xdebd2000  ! 1764: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd8cc4400  ! 1766: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xd8cde000  ! 1767: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r12
	mov	0x20, %r16
	mov	0x7e0, %r20
	.word 0xd8bd2000  ! 1770: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xde9f8e60  ! 1771: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	.word 0xdca48400  ! 1772: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 1773: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd48cc400  ! 1774: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	mov	0x7e8, %r23
	.word 0xd4b66000  ! 1776: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x38, %r18
	.word 0xdecd44a0  ! 1778: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0xdec62000  ! 1779: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	.word 0xdeae2000  ! 1780: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	.word 0xdeac0400  ! 1781: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0x87802020  ! 1782: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a7ce60  ! 1783: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xd4f504a0  ! 1784: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd2acc400  ! 1785: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd2940400  ! 1786: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0xd29c8400  ! 1787: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xd2c4e000  ! 1788: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2f74e60  ! 1789: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	.word 0x87802072  ! 1790: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd085c4a0  ! 1791: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r8
	.word 0xd0b72000  ! 1792: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0f76000  ! 1793: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0b74e40  ! 1794: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xd0840400  ! 1795: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd0af4e60  ! 1796: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0x87802072  ! 1797: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1798: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b42000  ! 1799: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd08ca000  ! 1800: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	mov	0x60, %r16
	.word 0xd0d4a000  ! 1802: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f4e000  ! 1803: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0d4e000  ! 1804: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0x87802072  ! 1805: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0afe000  ! 1806: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0d7a000  ! 1807: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	mov	0x7d0, %r20
	.word 0xdca40400  ! 1809: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdcbfa000  ! 1810: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	mov	0x70, %r25
	.word 0x87802025  ! 1812: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca56000  ! 1813: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	mov	0x10, %r25
	.word 0x87802073  ! 1815: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ae09e0  ! 1816: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xdaa70e80  ! 1817: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1818: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1819: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f40400  ! 1820: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd8c72000  ! 1821: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8dc8400  ! 1822: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd89fe000  ! 1823: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd897e000  ! 1824: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8a76000  ! 1825: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8bf8e60  ! 1826: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0xd8d76000  ! 1827: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x38, %r26
	.word 0xd88fe000  ! 1829: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1830: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r26
	.word 0xd8a4e000  ! 1832: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	mov	0x3f8, %r23
	mov	0x70, %r16
	.word 0xd697ce40  ! 1835: LDUHA_R	lduha	[%r31, %r0] 0x72, %r11
	mov	0x58, %r24
	.word 0x87802072  ! 1837: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabf0e40  ! 1838: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	mov	0x7e0, %r23
	mov	0x58, %r25
	.word 0xdaafe000  ! 1841: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xdad7a000  ! 1842: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	mov	0x7f0, %r20
	mov	0x58, %r27
	.word 0x87802025  ! 1845: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8d6000  ! 1846: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r13
	.word 0xdadfce60  ! 1847: LDXA_R	ldxa	[%r31, %r0] 0x73, %r13
	.word 0x87802025  ! 1848: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf5a000  ! 1849: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdaada000  ! 1850: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	.word 0xdab5a000  ! 1851: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xd8970e60  ! 1852: LDUHA_R	lduha	[%r28, %r0] 0x73, %r12
	.word 0xd4bd44a0  ! 1853: STDA_R	stda	%r10, [%r21 + %r0] 0x25
	mov	0x3f0, %r21
	mov	0x3e8, %r23
	.word 0xd2f78e60  ! 1856: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd2dd2000  ! 1857: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	.word 0xdab78e80  ! 1858: STHA_R	stha	%r13, [%r30 + %r0] 0x74
	.word 0xdac5a000  ! 1859: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	.word 0xd0f48400  ! 1860: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1861: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d46000  ! 1862: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0xde844400  ! 1863: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xdea42000  ! 1864: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1865: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedfce40  ! 1866: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xd8bec9e0  ! 1867: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0xd4a40400  ! 1868: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	mov	0x7d0, %r23
	.word 0xd6b40400  ! 1870: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	mov	0x78, %r19
	.word 0xdcdc8400  ! 1872: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdcb4a000  ! 1873: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1874: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1875: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1876: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcae6000  ! 1877: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0xdea74e60  ! 1878: STWA_R	stwa	%r15, [%r29 + %r0] 0x73
	.word 0x87802072  ! 1879: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8f8e40  ! 1880: LDUBA_R	lduba	[%r30, %r0] 0x72, %r13
	.word 0xdeb44400  ! 1881: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x18, %r17
	.word 0xd0ccc400  ! 1883: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xd0b7a000  ! 1884: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xd0a72000  ! 1886: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xd0d7e000  ! 1888: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	mov	0x7f8, %r20
	.word 0xd0bf6000  ! 1890: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xde8504a0  ! 1891: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0xdebfa000  ! 1892: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 1893: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8de09e0  ! 1894: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0xdaf48400  ! 1895: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	mov	0x38, %r16
	.word 0xd2a44400  ! 1897: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	mov	0x3d0, %r20
	mov	0x58, %r24
	mov	0x3e0, %r23
	.word 0xd4b6c9e0  ! 1901: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xde8d84a0  ! 1902: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	.word 0xdea6e000  ! 1903: STWA_I	stwa	%r15, [%r27 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xdeae6000  ! 1905: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	mov	0x60, %r25
	mov	0x50, %r25
	.word 0x87802073  ! 1908: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r21
	.word 0x87802025  ! 1910: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4ae09e0  ! 1911: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xd4b78e80  ! 1912: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	mov	0x3f8, %r21
	.word 0xdc9d44a0  ! 1914: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	.word 0xdcc5a000  ! 1915: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0x87802073  ! 1916: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdabf4e80  ! 1917: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xdaf7a000  ! 1918: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdabf6000  ! 1919: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd88c4400  ! 1920: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd88f4e40  ! 1921: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	.word 0x87802074  ! 1922: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2df8e80  ! 1923: LDXA_R	ldxa	[%r30, %r0] 0x74, %r9
	.word 0x8780204f  ! 1924: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2862000  ! 1925: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0x87802072  ! 1926: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8ce09e0  ! 1927: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0x8780204f  ! 1928: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ae2000  ! 1929: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd8bee000  ! 1930: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	mov	0x30, %r26
	mov	0x7d8, %r20
	.word 0xded584a0  ! 1933: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r15
	.word 0x87802020  ! 1934: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1935: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1936: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac4c400  ! 1937: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r13
	mov	0x3c8, %r21
	mov	0x38, %r18
	.word 0x87802072  ! 1940: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa7e000  ! 1941: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 1942: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r16
	.word 0x87802020  ! 1944: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r26
	.word 0x87802020  ! 1946: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1947: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda87a000  ! 1948: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xded40400  ! 1949: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0x87802072  ! 1950: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb7a000  ! 1951: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x60, %r18
	.word 0xdef72000  ! 1953: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd6a74e40  ! 1954: STWA_R	stwa	%r11, [%r29 + %r0] 0x72
	mov	0x7d8, %r22
	.word 0xd6afe000  ! 1956: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd2bf8e40  ! 1957: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xd2bf2000  ! 1958: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd8c74e40  ! 1959: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	.word 0xd8b40400  ! 1960: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd8d76000  ! 1961: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8bf6000  ! 1962: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd88f2000  ! 1963: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	mov	0x3f8, %r22
	.word 0xd8b7e000  ! 1965: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1966: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r27
	mov	0x40, %r19
	mov	0x50, %r25
	.word 0x87802020  ! 1970: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1971: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8c0400  ! 1972: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xdaf6e000  ! 1973: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xd2dc4400  ! 1974: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd0870e80  ! 1975: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r8
	.word 0xd0b62000  ! 1976: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 1977: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2cd44a0  ! 1978: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r9
	.word 0xd2aee000  ! 1979: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	mov	0x28, %r19
	.word 0xdcaec9e0  ! 1981: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xd0940400  ! 1982: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	mov	0x3e8, %r22
	mov	0x38, %r24
	.word 0xd086e000  ! 1985: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	.word 0xd0a6e000  ! 1986: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0xdaf70e60  ! 1987: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1988: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab4e000  ! 1989: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdadc2000  ! 1990: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xdca44400  ! 1991: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xdcc584a0  ! 1992: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0xdcbca000  ! 1993: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdac74e40  ! 1994: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r13
	.word 0xdadca000  ! 1995: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xd4c649e0  ! 1996: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r10
	.word 0xd49c2000  ! 1997: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1998: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4afa000  ! 1999: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd0f40400  ! 2000: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	mov	0x50, %r18
	.word 0xd0872000  ! 2002: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xdca78e40  ! 2003: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 2004: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf6e000  ! 2005: STXA_I	stxa	%r14, [%r27 + 0x0000] %asi
	.word 0xdabf4e40  ! 2006: STDA_R	stda	%r13, [%r29 + %r0] 0x72
	mov	0x0, %r17
	.word 0xda9ea000  ! 2008: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2009: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0de89e0  ! 2010: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r8
	.word 0xd4b4c400  ! 2011: STHA_R	stha	%r10, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 2012: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2013: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c70e60  ! 2014: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r12
	mov	0x40, %r17
	.word 0x87802020  ! 2016: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a40400  ! 2017: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	mov	0x7f0, %r22
	.word 0xd8d544a0  ! 2019: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r12
	.word 0xd8b46000  ! 2020: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd8f42000  ! 2021: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd0b74e80  ! 2022: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xda8f8e60  ! 2023: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	mov	0x7d0, %r20
	mov	0x3f8, %r21
	.word 0x87802074  ! 2026: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r16
	mov	0x0, %r17
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0cc0400  ! 2030: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	.word 0xd0cf6000  ! 2031: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd4f7ce60  ! 2032: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xde848400  ! 2033: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0x87802073  ! 2034: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6af4e60  ! 2035: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0x87802025  ! 2036: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc9649e0  ! 2037: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r14
	mov	0x7e8, %r21
	mov	0x78, %r26
	.word 0xdc95e000  ! 2040: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	.word 0xdcf5a000  ! 2041: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xdab6c9e0  ! 2043: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xdecdc4a0  ! 2044: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r15
	.word 0xdedd6000  ! 2045: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r15
	.word 0xd6afce80  ! 2046: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	.word 0xd4a78e60  ! 2047: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xd8a7ce60  ! 2048: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	.word 0xd2bec9e0  ! 2049: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0xd2ade000  ! 2050: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 2051: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r17
	.word 0xd2c7e000  ! 2053: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2054: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2055: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e0, %r20
	mov	0x28, %r25
	.word 0xd2bf2000  ! 2058: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x20, %r17
	.word 0x87802074  ! 2060: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29fe000  ! 2061: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd6df0e80  ! 2062: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	.word 0xd6cf6000  ! 2063: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xdea48400  ! 2064: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xda9dc4a0  ! 2065: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	mov	0x3c0, %r22
	.word 0xd8b48400  ! 2067: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xd8972000  ! 2068: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	mov	0x50, %r18
	mov	0x18, %r24
	mov	0x20, %r17
	.word 0xdaf40400  ! 2072: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd0944400  ! 2073: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	mov	0x38, %r18
	.word 0xd0a44400  ! 2075: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x10, %r19
	.word 0xd09fa000  ! 2077: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r8
	mov	0x7c8, %r23
	.word 0xd8a7ce60  ! 2079: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	.word 0xd8afe000  ! 2080: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	mov	0x38, %r18
	mov	0x7f0, %r23
	.word 0x87802074  ! 2083: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69cc400  ! 2084: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xd4f544a0  ! 2085: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	mov	0x48, %r24
	.word 0xd0a7ce80  ! 2087: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	mov	0x20, %r27
	.word 0xd0b76000  ! 2089: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0b78e40  ! 2090: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0xd087a000  ! 2091: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0c7a000  ! 2092: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0a504a0  ! 2093: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0xd2af4e60  ! 2094: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0x87802074  ! 2095: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r26
	.word 0xdcd689e0  ! 2097: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r14
	.word 0x87802072  ! 2098: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0ac8400  ! 2099: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd0a72000  ! 2100: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 2101: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0afa000  ! 2102: STBA_I	stba	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bfe000  ! 2103: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	mov	0x60, %r24
	mov	0x20, %r25
	.word 0xd6f7ce40  ! 2106: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0x87802072  ! 2107: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r21
	.word 0xd6bfe000  ! 2109: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 2110: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9f4e40  ! 2111: LDDA_R	ldda	[%r29, %r0] 0x72, %r14
	.word 0x8780204f  ! 2112: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcd66000  ! 2113: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2114: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 2115: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2116: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r17
	.word 0xdcd7e000  ! 2118: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb72000  ! 2119: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x7c0, %r21
	mov	0x50, %r25
	mov	0x60, %r16
	.word 0x87802020  ! 2123: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbce000  ! 2124: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xdc846000  ! 2126: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	mov	0x70, %r25
	.word 0x87802020  ! 2128: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ae49e0  ! 2129: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	.word 0xdec40400  ! 2130: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xdedca000  ! 2131: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 2132: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdca544a0  ! 2133: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 2134: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8689e0  ! 2135: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r13
	mov	0x48, %r26
	.word 0xdaaee000  ! 2137: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	mov	0x20, %r24
	.word 0x87802020  ! 2139: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf40400  ! 2140: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xdaae49e0  ! 2141: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	.word 0xd6be09e0  ! 2142: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd8b78e80  ! 2143: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0x87802073  ! 2144: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r16
	.word 0xd8a76000  ! 2146: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd2b44400  ! 2147: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd2976000  ! 2148: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802074  ! 2149: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecf0e80  ! 2150: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	mov	0x3c0, %r21
	mov	0x28, %r24
	mov	0x18, %r19
	.word 0x87802074  ! 2154: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r25
	mov	0x70, %r24
	.word 0x87802025  ! 2157: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeade000  ! 2158: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xde952000  ! 2159: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r15
	.word 0xdeb56000  ! 2160: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xdead2000  ! 2161: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 2162: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb76000  ! 2163: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xdea7a000  ! 2164: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xd4d74e40  ! 2165: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r10
	.word 0xd4a7a000  ! 2166: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd8b48400  ! 2167: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xdea70e40  ! 2168: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0xded76000  ! 2169: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xde972000  ! 2170: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	mov	0x60, %r27
	.word 0xde876000  ! 2172: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	mov	0x3f0, %r22
	.word 0x87802073  ! 2174: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde97e000  ! 2175: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xd0b70e80  ! 2176: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xd08f2000  ! 2177: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd4d4c400  ! 2178: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 2179: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r27
	mov	0x10, %r19
	.word 0x87802020  ! 2182: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb74e40  ! 2183: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xd2878e60  ! 2184: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	.word 0xd2b42000  ! 2185: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xdaa7ce60  ! 2186: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	.word 0xd88e49e0  ! 2187: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	.word 0xd8c4e000  ! 2188: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0xd8c4e000  ! 2189: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	.word 0xd6c40400  ! 2190: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	.word 0x87802074  ! 2191: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd687a000  ! 2192: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 2193: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2194: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r27
	.word 0xd2dcc400  ! 2196: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	mov	0x30, %r24
	.word 0x87802020  ! 2198: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r25
	mov	0x20, %r27
	.word 0xdab78e40  ! 2201: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xdcafce40  ! 2202: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xd4c74e60  ! 2203: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r10
	.word 0xd4a4c400  ! 2204: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0x87802073  ! 2205: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r16
	.word 0xd49f2000  ! 2207: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	mov	0x3c8, %r21
	.word 0xdedcc400  ! 2209: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	mov	0x7c0, %r23
	.word 0xdeb504a0  ! 2211: STHA_R	stha	%r15, [%r20 + %r0] 0x25
	.word 0xdc978e80  ! 2212: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	.word 0xd2b70e40  ! 2213: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	mov	0x10, %r26
	.word 0xd29fe000  ! 2215: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2f7a000  ! 2216: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd29f6000  ! 2217: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	mov	0x68, %r27
	.word 0xda840400  ! 2219: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	mov	0x60, %r25
	.word 0xdaf74e80  ! 2221: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	mov	0x30, %r18
	.word 0x87802025  ! 2223: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r24
	.word 0xdabd2000  ! 2225: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xd6844400  ! 2226: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r11
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6f56000  ! 2228: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd2940400  ! 2229: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0x87802073  ! 2230: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b76000  ! 2231: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xdec7ce40  ! 2233: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r15
	.word 0xdef76000  ! 2234: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdedf2000  ! 2235: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x3d0, %r20
	mov	0x78, %r27
	mov	0x50, %r24
	mov	0x3d0, %r20
	.word 0x87802020  ! 2240: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4970e40  ! 2241: LDUHA_R	lduha	[%r28, %r0] 0x72, %r10
	.word 0xd4a4a000  ! 2242: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xda9c4400  ! 2243: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	mov	0x40, %r26
	mov	0x58, %r25
	.word 0xd2d74e40  ! 2246: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0xd89d84a0  ! 2247: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	mov	0x38, %r25
	.word 0xd6a584a0  ! 2249: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	mov	0x3c0, %r20
	.word 0xd6cc4400  ! 2251: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd6846000  ! 2252: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6b4a000  ! 2253: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0xdaafce60  ! 2254: STBA_R	stba	%r13, [%r31 + %r0] 0x73
	.word 0xd6dc4400  ! 2255: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd6f4e000  ! 2256: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	.word 0xd6a4a000  ! 2257: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd6846000  ! 2259: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2260: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef70e80  ! 2261: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0xdac7ce60  ! 2262: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r13
	.word 0xdcd44400  ! 2263: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0x8780204f  ! 2264: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8e2000  ! 2265: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r14
	mov	0x78, %r25
	mov	0x3f0, %r23
	.word 0xd6f609e0  ! 2268: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	mov	0x68, %r19
	.word 0x87802020  ! 2270: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d4e000  ! 2271: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2272: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09fce40  ! 2273: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xd0846000  ! 2274: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r8
	mov	0x78, %r18
	.word 0xd0aca000  ! 2276: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd0b42000  ! 2277: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 2278: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r23
	mov	0x18, %r17
	.word 0xd0bde000  ! 2281: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	.word 0xd0dd6000  ! 2282: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0952000  ! 2283: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0xd88f4e80  ! 2284: LDUBA_R	lduba	[%r29, %r0] 0x74, %r12
	.word 0x87802074  ! 2285: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r18
	.word 0xd8cf2000  ! 2287: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	mov	0x68, %r19
	.word 0xd8af6000  ! 2289: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd0d70e60  ! 2290: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r8
	.word 0xd0b76000  ! 2291: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd88f4e60  ! 2292: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	.word 0xd2a40400  ! 2293: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	mov	0x20, %r27
	.word 0xd4df0e80  ! 2295: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xd4f7a000  ! 2296: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4c76000  ! 2297: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	mov	0x8, %r24
	mov	0x0, %r17
	.word 0x87802074  ! 2300: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 2301: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2df8e80  ! 2302: LDXA_R	ldxa	[%r30, %r0] 0x74, %r9
	mov	0x3c0, %r22
	.word 0xd8a74e80  ! 2304: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	.word 0xd48f8e40  ! 2305: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	.word 0xd49ea000  ! 2306: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	mov	0x30, %r18
	.word 0xd4bee000  ! 2308: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	.word 0xd896c9e0  ! 2309: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r12
	mov	0x3e0, %r22
	.word 0x87802073  ! 2311: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r27
	.word 0xdcb544a0  ! 2313: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	.word 0xdcbfa000  ! 2314: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdc87e000  ! 2315: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2316: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r16
	.word 0xd4a70e60  ! 2318: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xd4dfe000  ! 2319: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x7f8, %r20
	.word 0xd6cf0e60  ! 2321: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r11
	.word 0xd6c7e000  ! 2322: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6ddc4a0  ! 2323: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	.word 0xd6b7e000  ! 2324: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6f48400  ! 2325: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd6a7a000  ! 2326: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6f76000  ! 2327: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xd285c4a0  ! 2328: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r9
	.word 0xd2b7e000  ! 2329: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xdea74e40  ! 2330: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	mov	0x0, %r18
	.word 0xdef72000  ! 2332: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xde8c4400  ! 2333: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xdeaf2000  ! 2334: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdecc4400  ! 2335: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	mov	0x68, %r16
	.word 0xde876000  ! 2337: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 2338: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 2339: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecfe000  ! 2340: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xde872000  ! 2341: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 2342: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 2343: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e0, %r22
	.word 0x87802020  ! 2345: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc6000  ! 2346: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd28c0400  ! 2347: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xd2bca000  ! 2348: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 2349: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd297ce60  ! 2350: LDUHA_R	lduha	[%r31, %r0] 0x73, %r9
	.word 0x87802072  ! 2351: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded40400  ! 2352: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd0be09e0  ! 2353: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 2354: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d46000  ! 2356: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0a46000  ! 2357: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xdcf48400  ! 2358: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0x87802072  ! 2359: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb70e60  ! 2360: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	mov	0x7c8, %r23
	mov	0x50, %r27
	.word 0xdea72000  ! 2363: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xdea72000  ! 2364: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xdea78e60  ! 2365: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xdea72000  ! 2366: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xdedfa000  ! 2368: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xded72000  ! 2369: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x20, %r24
	.word 0xd284c400  ! 2371: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	.word 0x8780204f  ! 2372: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f78e60  ! 2373: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	.word 0xd8ac0400  ! 2374: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 2375: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda848400  ! 2376: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r13
	.word 0xdab66000  ! 2377: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 2378: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2379: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaac0400  ! 2380: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	.word 0xdece89e0  ! 2381: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	.word 0xde8da000  ! 2382: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r15
	.word 0xd68dc4a0  ! 2383: LDUBA_R	lduba	[%r23, %r0] 0x25, %r11
	.word 0x87802073  ! 2384: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2385: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d46000  ! 2386: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r11
	.word 0xd6f74e40  ! 2387: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xdabf0e80  ! 2388: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	mov	0x7f0, %r21
	mov	0x20, %r18
	.word 0xdaaca000  ! 2391: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xd4bc8400  ! 2392: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0x87802072  ! 2393: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb544a0  ! 2394: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0xdcaf0e80  ! 2395: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	mov	0x10, %r24
	.word 0xdcc7e000  ! 2397: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca46000  ! 2399: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdebc0400  ! 2401: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2402: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeac2000  ! 2403: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdcbc0400  ! 2404: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xdcc4a000  ! 2405: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	mov	0x20, %r16
	mov	0x20, %r24
	.word 0xdef4c400  ! 2408: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xdedc2000  ! 2409: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xdebce000  ! 2410: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xd09f0e40  ! 2411: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xdcd544a0  ! 2412: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	.word 0x87802072  ! 2413: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r18
	.word 0xdcf7a000  ! 2415: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xd4ae49e0  ! 2416: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 2417: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49c2000  ! 2418: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xdc97ce40  ! 2419: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	.word 0xdcd46000  ! 2420: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	.word 0xdcbc6000  ! 2421: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	mov	0x3e0, %r22
	mov	0x7c0, %r20
	.word 0xdcace000  ! 2424: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xde8ec9e0  ! 2425: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r15
	.word 0xdecc2000  ! 2426: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	mov	0x50, %r16
	.word 0xdec46000  ! 2428: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	mov	0x3f8, %r20
	.word 0xdecf0e60  ! 2430: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0x87802072  ! 2431: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde972000  ! 2432: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xdecf2000  ! 2433: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdab4c400  ! 2434: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xdaf72000  ! 2435: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xd8bcc400  ! 2436: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd89d44a0  ! 2437: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	.word 0xd8a7a000  ! 2438: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xd4a78e80  ! 2440: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0x87802020  ! 2441: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f78e40  ! 2442: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xd2b4a000  ! 2443: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xd6c44400  ! 2445: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0xd6946000  ! 2446: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r11
	mov	0x30, %r25
	.word 0xdcd74e80  ! 2448: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	.word 0xdebcc400  ! 2449: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	mov	0x28, %r18
	.word 0x8780204f  ! 2451: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ae49e0  ! 2452: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xdcdc8400  ! 2453: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xdca6a000  ! 2454: STWA_I	stwa	%r14, [%r26 + 0x0000] %asi
	mov	0x7c0, %r20
	mov	0x20, %r26
	.word 0x8780204f  ! 2457: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2458: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc7e000  ! 2459: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0xd2f40400  ! 2460: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd2a74e60  ! 2461: STWA_R	stwa	%r9, [%r29 + %r0] 0x73
	.word 0x87802072  ! 2462: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cf2000  ! 2463: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2f76000  ! 2464: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xdcb5c4a0  ! 2465: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xdaa44400  ! 2466: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	mov	0x7d0, %r23
	.word 0xd8bc8400  ! 2468: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd8af2000  ! 2469: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xdcaf8e40  ! 2470: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	.word 0xdcb76000  ! 2471: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdcbf0e40  ! 2472: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	.word 0xd69f4e60  ! 2473: LDDA_R	ldda	[%r29, %r0] 0x73, %r11
	mov	0x38, %r17
	.word 0xd6972000  ! 2475: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 2476: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b7a000  ! 2477: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6c7a000  ! 2478: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 2479: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd88fce80  ! 2480: LDUBA_R	lduba	[%r31, %r0] 0x74, %r12
	mov	0x3f0, %r21
	.word 0xd8f7e000  ! 2482: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd4840400  ! 2483: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xd4bfe000  ! 2484: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd68dc4a0  ! 2485: LDUBA_R	lduba	[%r23, %r0] 0x25, %r11
	.word 0xd085c4a0  ! 2486: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r8
	.word 0x87802072  ! 2487: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2488: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c46000  ! 2489: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r8
	.word 0xd09ce000  ! 2490: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xd08ce000  ! 2491: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0x87802073  ! 2492: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0dfe000  ! 2493: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x10, %r24
	.word 0x87802073  ! 2495: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r21
	.word 0xd0b7e000  ! 2497: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a7e000  ! 2498: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f72000  ! 2499: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 2500: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r19
	.word 0xd2bf0e40  ! 2502: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0xd2f56000  ! 2503: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 2504: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r16
	mov	0x60, %r19
	.word 0x87802020  ! 2507: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2508: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ade000  ! 2509: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd2d56000  ! 2510: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r9
	.word 0xd2ad6000  ! 2511: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd8c6c9e0  ! 2512: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r12
	.word 0xd8d5e000  ! 2513: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8dd2000  ! 2514: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	.word 0xdeb70e80  ! 2515: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0xd6cc4400  ! 2516: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd2b4c400  ! 2517: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xd2ad6000  ! 2518: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd2b5e000  ! 2520: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd2a5a000  ! 2521: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xd6b584a0  ! 2522: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xd69d84a0  ! 2523: LDDA_R	ldda	[%r22, %r0] 0x25, %r11
	.word 0xd29cc400  ! 2524: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xde870e60  ! 2525: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	mov	0x0, %r18
	.word 0xdef5e000  ! 2527: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0xdca5c4a0  ! 2528: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0xdcd52000  ! 2529: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xdc952000  ! 2530: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	mov	0x7e8, %r21
	.word 0xdcc52000  ! 2532: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	mov	0x7f0, %r21
	.word 0xdab40400  ! 2534: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x30, %r16
	mov	0x60, %r25
	ta	T_CHANGE_HPRIV	! macro
	mov	0x60, %r25
	.word 0xd6d7ce60  ! 2539: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0x87802073  ! 2540: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 2541: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb44400  ! 2542: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xd4bf8e40  ! 2543: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0xd4be2000  ! 2544: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0xd8ddc4a0  ! 2545: LDXA_R	ldxa	[%r23, %r0] 0x25, %r12
	.word 0xd8a62000  ! 2546: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xd894c400  ! 2547: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	mov	0x60, %r24
	.word 0xdac74e60  ! 2549: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r13
	.word 0x87802073  ! 2550: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8f6000  ! 2551: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2552: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f74e80  ! 2553: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd0b46000  ! 2554: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd6b584a0  ! 2555: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xdc9c0400  ! 2556: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	mov	0x3c8, %r22
	.word 0xdcdcc400  ! 2558: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0x8780204f  ! 2559: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde940400  ! 2560: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xde866000  ! 2561: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	.word 0xde86a000  ! 2562: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	.word 0xd897ce80  ! 2563: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xd886a000  ! 2564: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	mov	0x38, %r16
	.word 0xd88e6000  ! 2566: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8a66000  ! 2567: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8b62000  ! 2568: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xd8c6a000  ! 2569: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8be6000  ! 2570: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0xd8d62000  ! 2571: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 2573: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f4a000  ! 2574: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8af8e80  ! 2575: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	mov	0x48, %r24
	.word 0xdab44400  ! 2577: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xdace09e0  ! 2578: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	mov	0x60, %r19
	.word 0xd8b4c400  ! 2580: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd6ae49e0  ! 2581: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	mov	0x60, %r17
	.word 0xd6ace000  ! 2583: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xdc948400  ! 2584: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xdc94a000  ! 2585: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0x87802025  ! 2586: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb56000  ! 2587: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0xdcd5e000  ! 2588: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r14
	.word 0xde87ce60  ! 2589: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r15
	.word 0xd887ce60  ! 2590: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r12
	.word 0x87802072  ! 2591: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r26
	.word 0xd8dfe000  ! 2593: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8bfe000  ! 2594: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd8cf6000  ! 2596: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	.word 0xd686c9e0  ! 2597: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r11
	mov	0x38, %r17
	.word 0xd08e49e0  ! 2599: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0x87802025  ! 2600: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49cc400  ! 2601: LDDA_R	ldda	[%r19, %r0] 0x20, %r10
	.word 0xdecf4e40  ! 2602: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0xd8a70e60  ! 2603: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	.word 0x87802020  ! 2604: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c4a000  ! 2605: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	mov	0x8, %r25
	.word 0x87802074  ! 2607: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef7ce60  ! 2608: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	mov	0x7d0, %r22
	mov	0x50, %r17
	.word 0xde872000  ! 2611: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xd4b48400  ! 2612: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2614: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r19
	.word 0xd4970e80  ! 2616: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	mov	0x10, %r18
	.word 0xd8bfce60  ! 2618: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0xd8b7e000  ! 2619: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd8bfe000  ! 2620: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd4bc0400  ! 2621: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	mov	0x40, %r16
	.word 0xdecc8400  ! 2623: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0x87802074  ! 2624: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd487ce80  ! 2625: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r10
	.word 0xdaf649e0  ! 2626: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 2627: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r20
	mov	0x3c8, %r21
	mov	0x40, %r18
	.word 0xdadc6000  ! 2631: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xda84a000  ! 2632: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xdadc6000  ! 2633: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xdaac2000  ! 2634: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xd8dec9e0  ! 2635: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	.word 0xd4a48400  ! 2636: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd4aca000  ! 2637: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x20, %r24
	.word 0x87802020  ! 2639: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89d84a0  ! 2640: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	mov	0x3d0, %r21
	.word 0xd6f48400  ! 2642: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd68ca000  ! 2643: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2644: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r20
	.word 0xdcd609e0  ! 2646: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r14
	.word 0x87802025  ! 2647: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x70, %r18
	.word 0xd4f7ce60  ! 2649: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	mov	0x3e8, %r23
	.word 0xd4b56000  ! 2651: STHA_I	stha	%r10, [%r21 + 0x0000] %asi
	.word 0xd4f5a000  ! 2652: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xde8fce60  ! 2654: LDUBA_R	lduba	[%r31, %r0] 0x73, %r15
	.word 0xded5c4a0  ! 2655: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r15
	.word 0xdeb56000  ! 2656: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xde9da000  ! 2658: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0xdeb5e000  ! 2659: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xdaa40400  ! 2660: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 2661: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2dfce60  ! 2662: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xd2be2000  ! 2663: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd48f0e80  ! 2664: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0xd4b66000  ! 2665: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xd8bc4400  ! 2667: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd8b6c9e0  ! 2668: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	.word 0xd8be89e0  ! 2669: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	.word 0xdc8e89e0  ! 2670: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r14
	mov	0x7e0, %r22
	.word 0xdcc62000  ! 2672: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	.word 0xd6bcc400  ! 2673: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	mov	0x70, %r24
	.word 0xd696e000  ! 2675: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	mov	0x8, %r26
	.word 0xd8ac4400  ! 2677: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd886a000  ! 2678: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	.word 0xdec78e60  ! 2679: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	mov	0x68, %r16
	.word 0xd4af0e80  ! 2681: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	mov	0x0, %r19
	.word 0xd4a6e000  ! 2683: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 2684: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r24
	.word 0xd4c72000  ! 2686: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd2b4c400  ! 2687: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xda9e09e0  ! 2688: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0xd6cc0400  ! 2689: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	.word 0xd6a72000  ! 2690: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cfa000  ! 2691: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0x87802025  ! 2692: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r17
	.word 0xd4bec9e0  ! 2694: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0xd4d56000  ! 2695: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0x87802025  ! 2696: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4dda000  ! 2697: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r10
	.word 0xd4956000  ! 2698: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0xdccc4400  ! 2699: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	mov	0x58, %r16
	.word 0xd2d7ce40  ! 2701: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	.word 0xd0970e60  ! 2702: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	mov	0x7f8, %r21
	.word 0xd0b56000  ! 2704: STHA_I	stha	%r8, [%r21 + 0x0000] %asi
	.word 0xd08de000  ! 2705: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r8
	.word 0xd6f4c400  ! 2706: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0x87802073  ! 2707: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeafce40  ! 2708: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0xdedfe000  ! 2709: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x78, %r18
	.word 0x87802020  ! 2711: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r25
	mov	0x20, %r27
	mov	0x78, %r17
	.word 0xdea4a000  ! 2715: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xd89584a0  ! 2717: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0xd8a46000  ! 2718: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xdec4c400  ! 2719: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xd4cc4400  ! 2720: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0x87802072  ! 2721: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r25
	.word 0xd4dfa000  ! 2723: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd48fa000  ! 2724: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802074  ! 2725: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r25
	mov	0x3e0, %r23
	.word 0xda8fce40  ! 2728: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	.word 0xdcb4c400  ! 2729: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd2af8e40  ! 2730: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xd2a7e000  ! 2731: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 2732: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c7e000  ! 2733: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd4cc8400  ! 2734: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd4f7e000  ! 2735: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd48fe000  ! 2736: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4af6000  ! 2737: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	mov	0x3d8, %r20
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7d8, %r20
	.word 0xdca7ce40  ! 2741: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	.word 0xd0dc4400  ! 2742: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0xdab504a0  ! 2743: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0xdeac8400  ! 2744: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x10, %r27
	.word 0xd4d4c400  ! 2746: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	mov	0x60, %r16
	.word 0xd4bcc400  ! 2748: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xda87ce80  ! 2749: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	.word 0xdad72000  ! 2750: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd6acc400  ! 2751: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	mov	0x50, %r25
	.word 0x87802073  ! 2753: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb48400  ! 2754: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xdcbf4e40  ! 2755: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xdcdfe000  ! 2756: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xd2dc8400  ! 2757: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	mov	0x7e8, %r23
	.word 0xd2cfa000  ! 2759: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2b7e000  ! 2760: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2bf8e80  ! 2761: STDA_R	stda	%r9, [%r30 + %r0] 0x74
	.word 0xd2c7a000  ! 2762: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	mov	0x7e0, %r21
	.word 0xd2d7a000  ! 2764: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	mov	0x78, %r25
	.word 0xd2d7a000  ! 2766: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd4f70e40  ! 2767: STXA_R	stxa	%r10, [%r28 + %r0] 0x72
	.word 0x87802025  ! 2768: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48da000  ! 2769: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	mov	0x30, %r25
	.word 0xdeb78e40  ! 2771: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	mov	0x18, %r16
	.word 0x87802074  ! 2773: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2774: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea72000  ! 2775: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xdebf0e60  ! 2776: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdedfe000  ! 2777: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xd0b40400  ! 2778: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xd0b72000  ! 2779: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	mov	0x8, %r16
	mov	0x70, %r24
	.word 0xda9c0400  ! 2782: LDDA_R	ldda	[%r16, %r0] 0x20, %r13
	.word 0xdaaf2000  ! 2783: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 2784: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda876000  ! 2785: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xd68f8e60  ! 2786: LDUBA_R	lduba	[%r30, %r0] 0x73, %r11
	.word 0x87802072  ! 2787: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2788: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b78e60  ! 2789: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0xd8cc4400  ! 2790: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0x87802072  ! 2791: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8584a0  ! 2792: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r13
	mov	0x7c8, %r22
	.word 0xdaa72000  ! 2794: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xd2d5c4a0  ! 2795: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r9
	.word 0xd89cc400  ! 2796: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	mov	0x18, %r18
	.word 0xd8a76000  ! 2798: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2799: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49649e0  ! 2800: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	.word 0xda8c0400  ! 2801: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xda9fe000  ! 2802: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdaa76000  ! 2803: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdaaf6000  ! 2804: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdabfce60  ! 2805: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	mov	0x28, %r18
	.word 0xd2874e40  ! 2807: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	.word 0xd2876000  ! 2808: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xde940400  ! 2809: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xdec7a000  ! 2810: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdaa609e0  ! 2811: STWA_R	stwa	%r13, [%r24 + %r0] 0x4f
	.word 0xd4f78e60  ! 2812: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0xd0948400  ! 2813: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0xd0a72000  ! 2814: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x7d8, %r23
	mov	0x0, %r25
	mov	0x0, %r16
	mov	0x7f8, %r20
	.word 0xd0cfa000  ! 2819: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2820: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc2000  ! 2821: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	mov	0x10, %r18
	mov	0x28, %r27
	.word 0xdcd48400  ! 2824: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0x87802073  ! 2825: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca7e000  ! 2826: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd0acc400  ! 2827: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd0cc8400  ! 2828: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd0d7e000  ! 2829: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	mov	0x8, %r17
	mov	0x8, %r25
	mov	0x18, %r24
	mov	0x3d8, %r21
	.word 0xd087e000  ! 2834: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xdcbf8e80  ! 2835: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	.word 0xdc976000  ! 2836: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	.word 0xdcf7e000  ! 2837: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcf7e000  ! 2838: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xdebe09e0  ! 2839: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 2840: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec4e000  ! 2841: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r15
	.word 0xd0f74e60  ! 2842: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	.word 0xd49f8e40  ! 2843: LDDA_R	ldda	[%r30, %r0] 0x72, %r10
	.word 0xd4ccc400  ! 2844: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd4870e40  ! 2845: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	.word 0xd4a7ce60  ! 2846: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	mov	0x28, %r19
	.word 0xd8bf0e40  ! 2848: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0xdedc0400  ! 2849: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xdaf74e40  ! 2850: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0x8780204f  ! 2851: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded4c400  ! 2852: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0xd8c70e40  ! 2853: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	.word 0x8780204f  ! 2854: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r24
	.word 0xd88ea000  ! 2856: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	mov	0x78, %r17
	mov	0x0, %r19
	.word 0xd8a66000  ! 2859: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	mov	0x7d0, %r20
	mov	0x8, %r26
	.word 0xd8b6e000  ! 2862: STHA_I	stha	%r12, [%r27 + 0x0000] %asi
	.word 0xd8dea000  ! 2863: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0xdca5c4a0  ! 2864: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0x87802025  ! 2865: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabc8400  ! 2866: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xdac5a000  ! 2867: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r13
	.word 0xdad56000  ! 2868: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	mov	0x48, %r25
	.word 0xd4de89e0  ! 2870: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	mov	0x28, %r25
	.word 0xd2d74e40  ! 2872: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0x87802020  ! 2873: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f46000  ! 2874: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd8f4c400  ! 2876: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd2ccc400  ! 2877: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0xd0bf8e60  ! 2878: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0x87802073  ! 2879: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea78e60  ! 2880: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xd4948400  ! 2881: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3e8, %r22
	mov	0x3d8, %r22
	.word 0xd2f7ce40  ! 2885: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0x87802025  ! 2886: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0dc8400  ! 2887: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd0a5e000  ! 2888: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xd085a000  ! 2890: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	mov	0x68, %r17
	.word 0x8780204f  ! 2892: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f649e0  ! 2893: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	.word 0xdab70e60  ! 2894: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0xd885c4a0  ! 2895: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	.word 0x87802072  ! 2896: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 2897: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89f6000  ! 2898: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r12
	.word 0xd4adc4a0  ! 2899: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0x87802073  ! 2900: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d72000  ! 2901: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bf2000  ! 2902: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd2ac0400  ! 2903: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xd6bc4400  ! 2904: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xd6f76000  ! 2905: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xdef48400  ! 2906: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xdeaf0e80  ! 2907: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	.word 0xd2bf4e40  ! 2908: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	mov	0x70, %r27
	.word 0x8780204f  ! 2910: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b74e40  ! 2911: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xd484c400  ! 2912: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xd2a70e40  ! 2913: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xdab5c4a0  ! 2914: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	mov	0x10, %r17
	.word 0xdade2000  ! 2916: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r13
	.word 0xdacee000  ! 2917: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r13
	.word 0xd2d544a0  ! 2918: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r9
	.word 0xd2966000  ! 2919: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	.word 0xde974e40  ! 2920: LDUHA_R	lduha	[%r29, %r0] 0x72, %r15
	.word 0xdef609e0  ! 2921: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	mov	0x48, %r18
	.word 0x87802072  ! 2923: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b78e80  ! 2924: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	mov	0x48, %r27
	.word 0xd68f6000  ! 2926: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bdc4a0  ! 2927: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xd6bfe000  ! 2928: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 2929: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6972000  ! 2930: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2931: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68ca000  ! 2932: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xd8af4e80  ! 2933: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0xd29e89e0  ! 2934: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	.word 0xd8bc0400  ! 2935: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xdebe09e0  ! 2936: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0xdcd78e60  ! 2937: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r14
	.word 0xdcac2000  ! 2938: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 2939: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2940: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca42000  ! 2941: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0xdc84a000  ! 2942: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4a000  ! 2943: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcd46000  ! 2944: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r14
	mov	0x7c0, %r23
	mov	0x3f0, %r23
	.word 0xdcf46000  ! 2947: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 2948: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 2949: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd09504a0  ! 2950: LDUHA_R	lduha	[%r20, %r0] 0x25, %r8
	.word 0xd6944400  ! 2951: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	mov	0x50, %r27
	.word 0xd6a7e000  ! 2953: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd0bf0e80  ! 2954: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	.word 0xd0d76000  ! 2955: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2956: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea74e40  ! 2957: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xd2bc0400  ! 2958: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd2ae2000  ! 2959: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 2960: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r22
	mov	0x50, %r18
	.word 0x87802073  ! 2963: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdf4e80  ! 2964: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	.word 0xdaaf0e80  ! 2965: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	mov	0x3d8, %r20
	.word 0xde9f8e40  ! 2967: LDDA_R	ldda	[%r30, %r0] 0x72, %r15
	.word 0xde84c400  ! 2968: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	mov	0x3f0, %r23
	mov	0x70, %r25
	mov	0x58, %r19
	.word 0xd6bf4e40  ! 2972: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	.word 0xdede89e0  ! 2973: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	mov	0x7e8, %r23
	.word 0x87802073  ! 2975: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdf8e40  ! 2976: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	.word 0x87802020  ! 2977: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r17
	.word 0xdedd84a0  ! 2979: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	mov	0x50, %r25
	.word 0x87802020  ! 2981: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde842000  ! 2982: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	mov	0x28, %r26
	.word 0xdaf74e60  ! 2984: STXA_R	stxa	%r13, [%r29 + %r0] 0x73
	.word 0xd8a504a0  ! 2985: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	mov	0x68, %r26
	mov	0x3d8, %r23
	.word 0xd4cc4400  ! 2988: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	mov	0x70, %r27
	.word 0xd2bf8e40  ! 2990: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xd2a4a000  ! 2991: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xd2f4c400  ! 2993: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd2a4e000  ! 2994: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 2995: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2af6000  ! 2996: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xdca48400  ! 2997: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xdcf72000  ! 2998: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xd6f4c400  ! 2999: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3000: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r20
	.word 0xd6842000  ! 3002: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6f44400  ! 3003: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0x87802025  ! 3004: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a52000  ! 3005: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xdeae09e0  ! 3006: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xdeb5a000  ! 3007: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x38, %r26
	.word 0x8780204f  ! 3010: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3011: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c0, %r21
	.word 0xdedfa000  ! 3013: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdea7e000  ! 3014: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xdeb74e80  ! 3015: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xdec7a000  ! 3016: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xd4bc8400  ! 3017: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd487e000  ! 3018: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd2dc0400  ! 3019: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0x87802020  ! 3020: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bca000  ! 3021: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd2c4a000  ! 3022: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3023: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd294e000  ! 3024: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2df4e60  ! 3025: LDXA_R	ldxa	[%r29, %r0] 0x73, %r9
	mov	0x50, %r18
	mov	0x18, %r16
	.word 0xd4944400  ! 3028: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	mov	0x30, %r18
	mov	0x48, %r24
	.word 0x8780204f  ! 3031: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3032: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8f4e80  ! 3033: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0x87802073  ! 3034: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r17
	mov	0x38, %r17
	mov	0x28, %r16
	mov	0x3f0, %r20
	.word 0xde976000  ! 3039: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xde9f2000  ! 3040: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0x87802072  ! 3041: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebfe000  ! 3042: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 3043: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r17
	mov	0x3d0, %r21
	.word 0xd4dc8400  ! 3046: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xd4af6000  ! 3047: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4d72000  ! 3048: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x7e8, %r23
	.word 0xd487e000  ! 3050: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd6bf0e40  ! 3051: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xd69fe000  ! 3052: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b76000  ! 3053: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xd6d76000  ! 3055: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xd68f0e80  ! 3056: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0xd68fe000  ! 3057: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd2f44400  ! 3058: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	mov	0x3e0, %r20
	.word 0xd2f76000  ! 3060: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xde9c0400  ! 3061: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	mov	0x3f0, %r21
	.word 0xd6cfce40  ! 3063: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	mov	0x3e0, %r23
	.word 0x87802072  ! 3065: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c72000  ! 3066: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6c72000  ! 3067: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6b7e000  ! 3068: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3069: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdec9e0  ! 3070: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0xd0d78e60  ! 3071: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	mov	0x28, %r19
	mov	0x78, %r27
	.word 0xd0a72000  ! 3074: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0cfe000  ! 3075: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0b7a000  ! 3076: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3077: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0c4e000  ! 3079: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0a46000  ! 3080: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0b4a000  ! 3081: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd49fce60  ! 3082: LDDA_R	ldda	[%r31, %r0] 0x73, %r10
	.word 0x87802074  ! 3083: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49fe000  ! 3084: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3085: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0af0e80  ! 3086: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	mov	0x0, %r24
	.word 0xd2ac4400  ! 3088: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x50, %r27
	.word 0xd8df8e60  ! 3090: LDXA_R	ldxa	[%r30, %r0] 0x73, %r12
	mov	0x0, %r25
	.word 0x87802025  ! 3092: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaafce80  ! 3093: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0x87802073  ! 3094: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f6c9e0  ! 3095: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xd69fe000  ! 3096: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd6d70e80  ! 3097: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xda874e60  ! 3098: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	.word 0x87802073  ! 3099: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3100: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8ce000  ! 3101: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	mov	0x70, %r26
	.word 0xd6f7ce40  ! 3103: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	mov	0x7e8, %r21
	mov	0x8, %r27
	.word 0xdacd84a0  ! 3106: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r13
	mov	0x18, %r18
	.word 0xd29d84a0  ! 3108: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	mov	0x40, %r24
	.word 0xd2942000  ! 3110: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2dc2000  ! 3111: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	.word 0xd28c6000  ! 3112: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0x87802025  ! 3113: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f52000  ! 3114: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xd4cf8e60  ! 3116: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	mov	0x7d0, %r20
	mov	0x3e0, %r23
	.word 0xdab78e60  ! 3119: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0xd0cf4e60  ! 3120: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r8
	.word 0xd0f56000  ! 3121: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0ad2000  ! 3122: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xd0bd6000  ! 3124: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xd0dda000  ! 3126: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xd09d2000  ! 3127: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r8
	.word 0xde97ce80  ! 3128: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0xdebde000  ! 3129: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	.word 0xdea5a000  ! 3130: STWA_I	stwa	%r15, [%r22 + 0x0000] %asi
	.word 0xd0a689e0  ! 3131: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	mov	0x30, %r27
	.word 0xd0a5a000  ! 3133: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	.word 0x87802072  ! 3134: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cfa000  ! 3135: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xde97ce40  ! 3136: LDUHA_R	lduha	[%r31, %r0] 0x72, %r15
	mov	0x70, %r26
	.word 0x87802074  ! 3138: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28f4e40  ! 3139: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	mov	0x3d0, %r21
	mov	0x58, %r27
	mov	0x8, %r18
	.word 0xdcc74e60  ! 3143: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	.word 0x8780204f  ! 3144: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded74e80  ! 3145: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r15
	.word 0xdecf4e40  ! 3146: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0x87802020  ! 3147: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d7ce40  ! 3148: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	.word 0xd2bce000  ! 3149: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2d4e000  ! 3150: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd48c4400  ! 3151: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	.word 0x87802073  ! 3152: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b70e60  ! 3153: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0xd4afe000  ! 3154: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x50, %r19
	mov	0x0, %r26
	mov	0x60, %r25
	.word 0xd4a7a000  ! 3158: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bf2000  ! 3159: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x58, %r19
	.word 0xd2cf4e80  ! 3161: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r9
	.word 0xd2c72000  ! 3162: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2cf6000  ! 3163: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3164: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ac6000  ! 3165: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd29ce000  ! 3166: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd08dc4a0  ! 3167: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	.word 0xd6bd44a0  ! 3168: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 3169: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r27
	mov	0x3e8, %r23
	.word 0xd696a000  ! 3172: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	mov	0x30, %r17
	.word 0xd6878e40  ! 3174: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	mov	0x28, %r27
	mov	0x70, %r17
	.word 0xd6966000  ! 3177: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	.word 0xd6a6a000  ! 3178: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0xd6b66000  ! 3180: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	.word 0x87802025  ! 3181: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3182: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bfa000  ! 3183: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3184: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a78e40  ! 3185: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	mov	0x3e0, %r20
	.word 0xdaaf0e60  ! 3187: STBA_R	stba	%r13, [%r28 + %r0] 0x73
	.word 0xdac4a000  ! 3188: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	mov	0x48, %r27
	.word 0xdab7ce60  ! 3190: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	.word 0xd0840400  ! 3191: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0x87802072  ! 3192: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d44400  ! 3193: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0xd2b7a000  ! 3194: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2cfa000  ! 3195: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2bf2000  ! 3196: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x10, %r27
	mov	0x68, %r18
	mov	0x7c8, %r23
	.word 0x87802073  ! 3200: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 3201: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cfa000  ! 3202: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2af2000  ! 3203: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd29fa000  ! 3205: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xdab649e0  ! 3206: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	.word 0xd8d44400  ! 3207: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r12
	.word 0xd8f7e000  ! 3208: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8d7e000  ! 3209: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x68, %r26
	.word 0xd8872000  ! 3211: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3212: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbc4400  ! 3213: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xdcdd84a0  ! 3214: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	.word 0xd4bf8e40  ! 3215: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0x87802074  ! 3216: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 3217: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeaf8e80  ! 3218: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	mov	0x48, %r16
	.word 0xda978e60  ! 3220: LDUHA_R	lduha	[%r30, %r0] 0x73, %r13
	.word 0xdaa52000  ! 3221: STWA_I	stwa	%r13, [%r20 + 0x0000] %asi
	mov	0x40, %r17
	.word 0xdaf5e000  ! 3223: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0x87802072  ! 3225: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabfa000  ! 3226: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xd0b689e0  ! 3227: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	mov	0x48, %r18
	.word 0xd8f44400  ! 3229: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd8bfa000  ! 3230: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd8d7a000  ! 3231: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x3f0, %r21
	.word 0xd8d7a000  ! 3233: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd0bc4400  ! 3234: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd69f8e60  ! 3235: LDDA_R	ldda	[%r30, %r0] 0x73, %r11
	.word 0xd89c0400  ! 3236: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	mov	0x18, %r26
	.word 0xdca6c9e0  ! 3238: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0xdef48400  ! 3239: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd6cc8400  ! 3240: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd687a000  ! 3241: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	mov	0x3d8, %r23
	.word 0x8780204f  ! 3243: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3244: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3245: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0x8780204f  ! 3247: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9cc400  ! 3248: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xdebe2000  ! 3249: STDA_I	stda	%r15, [%r24 + 0x0000] %asi
	.word 0xd0bc0400  ! 3250: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd0aea000  ! 3251: STBA_I	stba	%r8, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3252: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bca000  ! 3253: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd084a000  ! 3254: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b46000  ! 3255: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd0ac2000  ! 3256: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd4b78e80  ! 3257: STHA_R	stha	%r10, [%r30 + %r0] 0x74
	mov	0x58, %r25
	.word 0xd0b48400  ! 3259: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	mov	0x10, %r18
	mov	0x38, %r17
	mov	0x50, %r19
	.word 0x87802020  ! 3263: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3264: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r16
	mov	0x8, %r17
	.word 0xd6a78e60  ! 3267: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd6a504a0  ! 3268: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8cf8e60  ! 3270: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0x87802020  ! 3271: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f74e60  ! 3272: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xd6aca000  ! 3273: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd6846000  ! 3274: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 3275: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3276: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r25
	mov	0x0, %r25
	.word 0xd6afa000  ! 3279: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd8b70e60  ! 3280: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xd4a544a0  ! 3281: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0xd08f8e60  ! 3282: LDUBA_R	lduba	[%r30, %r0] 0x73, %r8
	.word 0xded70e60  ! 3283: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	mov	0x7f8, %r22
	.word 0xdea7a000  ! 3285: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 3286: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebf6000  ! 3287: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdeafe000  ! 3288: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c74e80  ! 3290: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r12
	mov	0x28, %r18
	.word 0x87802072  ! 3292: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c72000  ! 3293: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bfe000  ! 3294: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xdc874e40  ! 3295: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r14
	.word 0xdcc7e000  ! 3296: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802073  ! 3297: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r23
	.word 0xdca7a000  ! 3299: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x18, %r19
	.word 0xd2ae49e0  ! 3301: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd2972000  ! 3302: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd29fa000  ! 3303: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd287e000  ! 3304: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x18, %r17
	.word 0xd88c0400  ! 3306: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0x87802072  ! 3307: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcaf0e80  ! 3308: STBA_R	stba	%r14, [%r28 + %r0] 0x74
	.word 0x87802074  ! 3309: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f70e40  ! 3310: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0x87802073  ! 3311: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeac8400  ! 3312: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd4cf8e60  ! 3313: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r10
	.word 0xdea7ce80  ! 3314: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	mov	0x28, %r25
	.word 0xda8dc4a0  ! 3316: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0xdaac8400  ! 3317: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0x87802073  ! 3318: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa7e000  ! 3319: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xdaafe000  ! 3321: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xda8fe000  ! 3323: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdc878e40  ! 3324: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	.word 0xdc8f2000  ! 3325: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdaad04a0  ! 3326: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0xdab7e000  ! 3327: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xda9fe000  ! 3328: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdacfe000  ! 3329: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	mov	0x78, %r16
	.word 0xda8f6000  ! 3331: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xd2d48400  ! 3332: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 3333: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a7ce40  ! 3334: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0x87802074  ! 3335: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r23
	.word 0xd2af2000  ! 3337: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2974e60  ! 3338: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	mov	0x38, %r19
	.word 0xdab609e0  ! 3340: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	mov	0x38, %r27
	.word 0xd0af8e40  ! 3342: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0x87802025  ! 3343: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea504a0  ! 3344: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	.word 0x87802072  ! 3345: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e8, %r21
	.word 0xded7a000  ! 3347: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xd0af4e40  ! 3348: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	.word 0xd097e000  ! 3349: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0c72000  ! 3350: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	mov	0x3f8, %r21
	.word 0xd0cf6000  ! 3352: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a7e000  ! 3353: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd0b7a000  ! 3355: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 3356: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r18
	.word 0xd08d6000  ! 3358: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	.word 0xdcdd04a0  ! 3359: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	mov	0x60, %r17
	.word 0xd6a48400  ! 3361: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xdeb40400  ! 3362: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	mov	0x7f0, %r20
	mov	0x28, %r24
	.word 0xdea5e000  ! 3365: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xdecd2000  ! 3366: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3367: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf44400  ! 3368: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd4b649e0  ! 3369: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 3370: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c7ce60  ! 3371: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r9
	.word 0xdab70e40  ! 3372: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	mov	0x7c8, %r21
	.word 0xdac4e000  ! 3374: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0xd8c584a0  ! 3375: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	.word 0xd8ac2000  ! 3376: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 3377: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r27
	mov	0x20, %r24
	.word 0xd8d7e000  ! 3380: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xdaa74e80  ! 3381: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xdabfa000  ! 3382: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdac7a000  ! 3383: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xdadfa000  ! 3384: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x48, %r27
	.word 0xde874e60  ! 3386: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xdeaf6000  ! 3387: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xdab4c400  ! 3388: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3c0, %r20
	.word 0xdabfa000  ! 3391: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xda9f6000  ! 3393: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	mov	0x3c8, %r22
	.word 0x87802020  ! 3395: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dd44a0  ! 3396: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0xd4f4c400  ! 3397: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd4cc2000  ! 3398: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd0a4c400  ! 3399: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd0f4a000  ! 3400: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xdcb70e40  ! 3401: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0xd48e09e0  ! 3402: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r10
	.word 0x87802074  ! 3403: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r24
	.word 0x87802020  ! 3405: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0944400  ! 3406: LDUHA_R	lduha	[%r17, %r0] 0x20, %r8
	.word 0xdc878e40  ! 3407: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	.word 0x8780204f  ! 3408: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d4c400  ! 3409: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd09689e0  ! 3410: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r8
	.word 0xd0a6e000  ! 3411: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd0ae2000  ! 3413: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xd4a609e0  ! 3414: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	mov	0x3d8, %r22
	.word 0xda970e80  ! 3416: LDUHA_R	lduha	[%r28, %r0] 0x74, %r13
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcc74e60  ! 3418: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	.word 0xdccee000  ! 3419: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3420: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r25
	.word 0xdcae6000  ! 3422: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 3423: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r24
	.word 0xdcdc2000  ! 3425: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3426: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd89e89e0  ! 3427: LDDA_R	ldda	[%r26, %r0] 0x4f, %r12
	.word 0x87802020  ! 3428: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r21
	mov	0x7c0, %r22
	.word 0xd88ce000  ! 3431: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	mov	0x68, %r26
	.word 0x87802072  ! 3433: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bc8400  ! 3434: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd6a7a000  ! 3435: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bfe000  ! 3436: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3437: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3438: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r16
	mov	0x30, %r18
	mov	0x3f8, %r22
	.word 0xdcbcc400  ! 3442: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xd4f4c400  ! 3443: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xd4c78e40  ! 3444: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r10
	.word 0xd4c7e000  ! 3445: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd48f6000  ! 3446: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xd0af0e60  ! 3447: STBA_R	stba	%r8, [%r28 + %r0] 0x73
	.word 0xd0b7e000  ! 3448: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3449: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f7e000  ! 3450: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x58, %r19
	mov	0x10, %r24
	.word 0xd2cf8e80  ! 3453: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	.word 0x87802020  ! 3454: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bc6000  ! 3455: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4a40400  ! 3457: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	mov	0x7d0, %r22
	.word 0x87802074  ! 3459: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a7e000  ! 3460: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4afa000  ! 3461: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3462: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4dc6000  ! 3463: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd48ca000  ! 3464: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xd49ca000  ! 3465: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd88fce60  ! 3466: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	.word 0xd89c6000  ! 3467: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xd8ac6000  ! 3468: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd894e000  ! 3469: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3470: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3471: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d46000  ! 3472: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xdea78e40  ! 3473: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xdcf609e0  ! 3474: STXA_R	stxa	%r14, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 3475: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a689e0  ! 3476: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	mov	0x3c8, %r22
	.word 0xd68f0e60  ! 3478: LDUBA_R	lduba	[%r28, %r0] 0x73, %r11
	.word 0xd08f4e40  ! 3479: LDUBA_R	lduba	[%r29, %r0] 0x72, %r8
	.word 0xd0bee000  ! 3480: STDA_I	stda	%r8, [%r27 + 0x0000] %asi
	.word 0xd096e000  ! 3481: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	.word 0xd48f4e60  ! 3482: LDUBA_R	lduba	[%r29, %r0] 0x73, %r10
	mov	0x38, %r17
	.word 0xd6ae09e0  ! 3484: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0xd88d44a0  ! 3485: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	mov	0x3d8, %r22
	mov	0x10, %r27
	mov	0x8, %r18
	.word 0xd89ee000  ! 3489: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 3491: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd894a000  ! 3492: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8a4a000  ! 3493: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xdab78e40  ! 3494: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xdeb609e0  ! 3495: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xdeac6000  ! 3496: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdef46000  ! 3497: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd4d48400  ! 3498: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	.word 0x87802072  ! 3499: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b609e0  ! 3500: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0xd8f584a0  ! 3501: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0xd2ad04a0  ! 3502: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	mov	0x7e8, %r22
	.word 0xd2d7e000  ! 3504: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0x87802073  ! 3505: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdecc0400  ! 3506: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xdef7e000  ! 3507: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xd29fce60  ! 3509: LDDA_R	ldda	[%r31, %r0] 0x73, %r9
	mov	0x50, %r17
	.word 0xd2b7e000  ! 3511: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd29f4e40  ! 3512: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	mov	0x38, %r19
	.word 0xd4dc8400  ! 3514: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xd487a000  ! 3515: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4a76000  ! 3516: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4cf2000  ! 3517: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4f7e000  ! 3518: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 3519: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r19
	.word 0xd4c6a000  ! 3521: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r10
	mov	0x10, %r18
	.word 0xdeb74e80  ! 3523: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0x87802025  ! 3524: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 3525: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebe6000  ! 3526: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 3527: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r27
	.word 0xd8c7ce80  ! 3529: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r12
	.word 0xde9cc400  ! 3530: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0x87802020  ! 3531: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r16
	.word 0xdeb4a000  ! 3533: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xd6de09e0  ! 3535: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	.word 0xd6af4e80  ! 3536: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	mov	0x3d0, %r22
	.word 0xd6bce000  ! 3538: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 3539: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3540: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r21
	.word 0x87802020  ! 3542: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf8e40  ! 3543: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	.word 0xdebc4400  ! 3544: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	mov	0x30, %r16
	.word 0xd4f689e0  ! 3546: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0xd4a42000  ! 3547: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	mov	0x7e0, %r20
	.word 0xd4bce000  ! 3549: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xd4d4a000  ! 3551: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd2878e80  ! 3552: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r9
	mov	0x28, %r25
	.word 0xd2946000  ! 3554: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2cc6000  ! 3555: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2b4a000  ! 3556: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 3557: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabcc400  ! 3558: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xdadd2000  ! 3559: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3560: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d4c400  ! 3561: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0x8780204f  ! 3562: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b66000  ! 3563: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 3564: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0af2000  ! 3565: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x0, %r25
	.word 0xd4a78e60  ! 3567: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xdcac0400  ! 3568: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802074  ! 3570: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3571: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcdfa000  ! 3572: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0xdcd72000  ! 3573: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd6c44400  ! 3574: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	.word 0x87802025  ! 3575: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69d6000  ! 3576: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r11
	.word 0xd6a44400  ! 3577: STWA_R	stwa	%r11, [%r17 + %r0] 0x20
	.word 0xd6bd6000  ! 3578: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6856000  ! 3579: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 3580: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68ee000  ! 3581: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r11
	.word 0xd6ae6000  ! 3582: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0x87802020  ! 3583: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r18
	.word 0x87802072  ! 3585: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6872000  ! 3586: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6a76000  ! 3587: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd8d609e0  ! 3588: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0xd4ae89e0  ! 3589: STBA_R	stba	%r10, [%r26 + %r0] 0x4f
	.word 0xd4dfe000  ! 3590: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802074  ! 3591: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b76000  ! 3592: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4a76000  ! 3593: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd8f6c9e0  ! 3594: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 3595: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8bfce60  ! 3596: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0xdcd70e80  ! 3597: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r14
	.word 0xdaaf0e80  ! 3598: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	mov	0x58, %r26
	mov	0x40, %r27
	.word 0xda97e000  ! 3601: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xda972000  ! 3602: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x7d8, %r22
	.word 0xd48f0e80  ! 3604: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0xd4dfa000  ! 3605: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4b7e000  ! 3606: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd48f2000  ! 3607: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	mov	0x38, %r18
	.word 0xd4c7e000  ! 3609: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd497e000  ! 3610: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3611: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ace000  ! 3612: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd8bc4400  ! 3613: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	mov	0x20, %r18
	.word 0x87802020  ! 3615: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7e0, %r20
	mov	0x78, %r17
	.word 0x87802020  ! 3619: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28f8e80  ! 3620: LDUBA_R	lduba	[%r30, %r0] 0x74, %r9
	.word 0xded504a0  ! 3621: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	.word 0xdaaf4e80  ! 3622: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	mov	0x7d0, %r21
	.word 0xdadc6000  ! 3624: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	mov	0x40, %r26
	mov	0x7e8, %r21
	.word 0xda8c2000  ! 3627: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3628: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48e89e0  ! 3629: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xd4b5e000  ! 3630: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0xd4ada000  ! 3631: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 3632: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r26
	.word 0xd4872000  ! 3634: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd2bc0400  ! 3635: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd2b7e000  ! 3636: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2df2000  ! 3637: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd29d44a0  ! 3638: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	.word 0xde9cc400  ! 3639: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xded72000  ! 3640: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x7c8, %r23
	ta	T_CHANGE_PRIV	! macro
	.word 0xded72000  ! 3643: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdecfe000  ! 3644: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xd8ad04a0  ! 3645: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xd8afe000  ! 3646: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3647: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3648: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8de2000  ! 3649: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xd8a66000  ! 3650: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd886e000  ! 3651: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd89e2000  ! 3652: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r12
	.word 0xd2af0e60  ! 3653: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	mov	0x70, %r26
	mov	0x7d8, %r20
	.word 0xdcdd84a0  ! 3656: LDXA_R	ldxa	[%r22, %r0] 0x25, %r14
	mov	0x3c0, %r21
	.word 0xdcf44400  ! 3658: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdef7ce80  ! 3659: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0xd8b649e0  ! 3660: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	.word 0xd8a62000  ! 3661: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xdaf609e0  ! 3662: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	mov	0x3e8, %r22
	.word 0xd6b44400  ! 3664: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd6c6e000  ! 3665: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6a66000  ! 3666: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xdea7ce80  ! 3667: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0x87802072  ! 3668: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f7ce60  ! 3669: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xd0dfa000  ! 3670: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd8d5c4a0  ! 3671: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r12
	.word 0xd8d7a000  ! 3672: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802073  ! 3674: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88fe000  ! 3675: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xd2dd84a0  ! 3676: LDXA_R	ldxa	[%r22, %r0] 0x25, %r9
	.word 0xd8ce49e0  ! 3677: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	mov	0x0, %r27
	.word 0xdcb5c4a0  ! 3679: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	mov	0x78, %r17
	.word 0xdcf7e000  ! 3681: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3682: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb76000  ! 3683: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdcafe000  ! 3684: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdcb7e000  ! 3685: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xd4c40400  ! 3687: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xd487e000  ! 3688: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4cf6000  ! 3689: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3690: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r18
	.word 0xd8b7ce40  ! 3692: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0x87802072  ! 3693: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8dec9e0  ! 3694: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	mov	0x18, %r24
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802074  ! 3697: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r27
	mov	0x48, %r16
	.word 0xdaaf4e60  ! 3700: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xdad72000  ! 3701: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd0ac8400  ! 3702: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd4de89e0  ! 3703: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	mov	0x20, %r26
	.word 0xd487e000  ! 3705: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd49f6000  ! 3706: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd49fa000  ! 3707: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	mov	0x3f0, %r21
	.word 0xd4f72000  ! 3709: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3710: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3711: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6df4e80  ! 3712: LDXA_R	ldxa	[%r29, %r0] 0x74, %r11
	.word 0xd2adc4a0  ! 3713: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	.word 0x87802072  ! 3714: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bfce60  ! 3715: STDA_R	stda	%r11, [%r31 + %r0] 0x73
	.word 0xd6876000  ! 3716: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0xd8df0e80  ! 3717: LDXA_R	ldxa	[%r28, %r0] 0x74, %r12
	mov	0x3d0, %r22
	mov	0x3f8, %r20
	mov	0x60, %r18
	.word 0xd6c70e40  ! 3721: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r11
	mov	0x78, %r16
	.word 0xd88c4400  ! 3723: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0x87802020  ! 3724: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bfce60  ! 3725: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0xd4842000  ! 3726: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4a42000  ! 3727: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd8f78e40  ! 3728: STXA_R	stxa	%r12, [%r30 + %r0] 0x72
	mov	0x28, %r18
	.word 0xd89e09e0  ! 3730: LDDA_R	ldda	[%r24, %r0] 0x4f, %r12
	mov	0x3e8, %r23
	.word 0xd8a42000  ! 3732: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 3733: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b72000  ! 3734: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	mov	0x38, %r27
	.word 0x87802020  ! 3736: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3737: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2af4e80  ! 3738: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	mov	0x70, %r24
	mov	0x18, %r17
	.word 0x87802020  ! 3741: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a4c400  ! 3742: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd4f504a0  ! 3743: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0xd4cc6000  ! 3744: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	mov	0x60, %r24
	.word 0xd4d42000  ! 3746: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xd8ae49e0  ! 3747: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	mov	0x3f0, %r22
	.word 0xd8dce000  ! 3749: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3750: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b78e80  ! 3751: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xd8a72000  ! 3752: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 3753: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4844400  ! 3754: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd4c7ce40  ! 3755: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	.word 0xd4b76000  ! 3756: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4a7e000  ! 3757: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd487e000  ! 3758: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4d7e000  ! 3759: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4b76000  ! 3760: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 3761: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3762: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 3763: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r18
	mov	0x7d0, %r22
	.word 0xd4862000  ! 3766: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	mov	0x3d0, %r22
	.word 0xd496a000  ! 3768: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r10
	.word 0xd4d7ce40  ! 3769: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r10
	.word 0xd496e000  ! 3770: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	mov	0x10, %r17
	.word 0xd4b6a000  ! 3772: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0xd4c66000  ! 3773: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r10
	.word 0xd68c0400  ! 3774: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xd6c66000  ! 3775: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	.word 0xd6de2000  ! 3776: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6ae6000  ! 3777: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0xd2b48400  ! 3778: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd4b504a0  ! 3779: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xdcbc8400  ! 3780: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd6f5c4a0  ! 3781: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	mov	0x50, %r24
	mov	0x40, %r26
	.word 0xd0c78e60  ! 3784: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	.word 0xda9c8400  ! 3785: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	mov	0x0, %r27
	.word 0xdaaee000  ! 3787: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	.word 0xdac6a000  ! 3788: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xdaf6a000  ! 3789: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	.word 0xdcad04a0  ! 3790: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	mov	0x18, %r18
	mov	0x28, %r16
	mov	0x70, %r25
	.word 0xdcb66000  ! 3794: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0xdcbee000  ! 3795: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	mov	0x3d0, %r21
	.word 0xdca40400  ! 3797: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	mov	0x7e0, %r20
	.word 0xdcc62000  ! 3799: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	mov	0x68, %r24
	mov	0x8, %r25
	.word 0xdc8ee000  ! 3802: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r14
	mov	0x70, %r24
	.word 0x87802074  ! 3804: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r26
	.word 0x87802074  ! 3806: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3807: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7e8, %r22
	.word 0xdcdf6000  ! 3809: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3810: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r16
	.word 0xdea544a0  ! 3812: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xdcb649e0  ! 3813: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xd2c584a0  ! 3814: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r9
	.word 0x87802020  ! 3815: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af0e60  ! 3816: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xd8bcc400  ! 3817: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xdea6c9e0  ! 3818: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xd2f40400  ! 3819: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xdea7ce80  ! 3820: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xded42000  ! 3821: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	mov	0x18, %r24
	.word 0xdebc2000  ! 3823: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdeb4e000  ! 3824: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xdeac2000  ! 3825: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 3826: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3827: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r23
	mov	0x20, %r25
	.word 0xd6b584a0  ! 3830: STHA_R	stha	%r11, [%r22 + %r0] 0x25
	.word 0xd6df6000  ! 3831: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xded78e40  ! 3832: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r15
	mov	0x48, %r19
	.word 0xda978e80  ! 3834: LDUHA_R	lduha	[%r30, %r0] 0x74, %r13
	.word 0xdaf7a000  ! 3835: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd0df4e40  ! 3837: LDXA_R	ldxa	[%r29, %r0] 0x72, %r8
	.word 0xd0b7a000  ! 3838: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0a72000  ! 3839: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	.word 0xdadf0e80  ! 3840: LDXA_R	ldxa	[%r28, %r0] 0x74, %r13
	ta	T_CHANGE_HPRIV	! macro
	mov	0x40, %r27
	.word 0xd6bec9e0  ! 3843: STDA_R	stda	%r11, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 3844: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r24
	.word 0x87802074  ! 3846: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c8, %r23
	mov	0x10, %r24
	.word 0xd697e000  ! 3849: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0x87802073  ! 3850: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69f6000  ! 3851: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xda840400  ! 3852: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	mov	0x8, %r25
	.word 0x87802020  ! 3854: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac4e000  ! 3855: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3856: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3857: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r16
	.word 0xda8fe000  ! 3859: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xd0a48400  ! 3860: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	.word 0xda84c400  ! 3861: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0x87802020  ! 3862: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r25
	mov	0x28, %r24
	mov	0x3c8, %r21
	.word 0xdab46000  ! 3866: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xdaae49e0  ! 3868: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	mov	0x0, %r26
	mov	0x18, %r18
	.word 0xdadce000  ! 3871: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3872: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4844400  ! 3873: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd4b42000  ! 3874: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd4dfce60  ! 3875: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	mov	0x3d8, %r22
	.word 0xda9f0e80  ! 3877: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	.word 0xdacc2000  ! 3878: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd4ccc400  ! 3879: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	mov	0x7e0, %r22
	.word 0xd4d4e000  ! 3881: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3882: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d504a0  ! 3883: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r11
	.word 0x87802074  ! 3884: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3885: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r18
	.word 0xd6f6e000  ! 3887: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 3888: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r16
	.word 0xd6aea000  ! 3890: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xd6c6e000  ! 3892: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0xd4d584a0  ! 3893: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0xd4b66000  ! 3894: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 3895: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r26
	.word 0xd4d66000  ! 3897: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r10
	.word 0xd4c6e000  ! 3898: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r10
	mov	0x8, %r17
	mov	0x40, %r27
	.word 0x87802074  ! 3901: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d7a000  ! 3902: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xd49f6000  ! 3903: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	mov	0x3c8, %r23
	.word 0x87802074  ! 3905: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r24
	.word 0xd4cd04a0  ! 3907: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	.word 0xd4a7a000  ! 3908: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xda878e80  ! 3909: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r13
	.word 0x8780204f  ! 3910: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8e6000  ! 3911: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r13
	.word 0xdaa66000  ! 3912: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xde9f0e80  ! 3913: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	.word 0x87802020  ! 3914: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea4a000  ! 3915: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdcad44a0  ! 3916: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	mov	0x3e0, %r22
	.word 0xd2dc8400  ! 3918: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xd2a46000  ! 3919: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd8b40400  ! 3920: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xda97ce60  ! 3921: LDUHA_R	lduha	[%r31, %r0] 0x73, %r13
	mov	0x78, %r26
	.word 0xd6ce89e0  ! 3923: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r11
	.word 0xd6ac2000  ! 3924: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a42000  ! 3925: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd684c400  ! 3926: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xd6f46000  ! 3927: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd697ce40  ! 3929: LDUHA_R	lduha	[%r31, %r0] 0x72, %r11
	.word 0xd4b7ce60  ! 3930: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xdeae89e0  ! 3931: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	.word 0xde8ce000  ! 3932: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xdabfce80  ! 3933: STDA_R	stda	%r13, [%r31 + %r0] 0x74
	.word 0xd0bf4e40  ! 3934: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xd4b74e60  ! 3935: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0xd4c4e000  ! 3936: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	mov	0x18, %r19
	mov	0x7f8, %r21
	.word 0x87802020  ! 3939: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d8, %r23
	.word 0xd48ca000  ! 3941: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3942: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a56000  ! 3943: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 3944: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49c2000  ! 3945: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	mov	0x40, %r17
	.word 0xdca40400  ! 3947: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xdcdca000  ! 3948: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xdca46000  ! 3949: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	mov	0x38, %r27
	.word 0xd6a78e60  ! 3951: STWA_R	stwa	%r11, [%r30 + %r0] 0x73
	.word 0xd8af8e60  ! 3952: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	mov	0x30, %r19
	.word 0xd8aca000  ! 3954: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 3955: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x18, %r25
	.word 0xdab48400  ! 3957: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd8cc4400  ! 3958: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xd8f66000  ! 3959: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 3960: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r24
	.word 0x87802072  ! 3962: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4ae09e0  ! 3963: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xd88cc400  ! 3964: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xd8bc0400  ! 3965: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xdea504a0  ! 3966: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	mov	0x30, %r16
	.word 0xdca649e0  ! 3968: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	.word 0xdca7a000  ! 3969: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xd0bec9e0  ! 3970: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 3972: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c48400  ! 3973: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0x87802074  ! 3974: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r17
	.word 0xd2af6000  ! 3976: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a70e60  ! 3977: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xdedcc400  ! 3978: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	.word 0x87802072  ! 3979: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3980: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef42000  ! 3981: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xde940400  ! 3982: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xdea4a000  ! 3983: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 3984: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde87a000  ! 3985: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdeac4400  ! 3986: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0x87802073  ! 3987: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c7ce80  ! 3988: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xd6940400  ! 3989: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	mov	0x60, %r24
	mov	0x28, %r19
	.word 0xdaa44400  ! 3992: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	mov	0x68, %r24
	.word 0xdcb649e0  ! 3994: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xdca76000  ! 3995: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc8e09e0  ! 3996: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0xdcbfe000  ! 3997: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xd0c4c400  ! 3998: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xde874e60  ! 3999: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xd8ac0400  ! 4000: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	mov	0x3f0, %r21
	.word 0xd88fe000  ! 4002: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xdec40400  ! 4003: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	mov	0x48, %r16
	mov	0x38, %r18
	mov	0x3d8, %r20
	.word 0x87802072  ! 4007: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdedf6000  ! 4008: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xde976000  ! 4009: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xd4ad84a0  ! 4010: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0xd8dc8400  ! 4011: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd8f72000  ! 4012: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8b7e000  ! 4013: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd8af6000  ! 4014: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd0d584a0  ! 4015: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r8
	.word 0xd8d70e40  ! 4016: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r12
	mov	0x50, %r26
	.word 0xd8a76000  ! 4018: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8afa000  ! 4019: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd8f72000  ! 4021: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bfe000  ! 4022: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd6f609e0  ! 4023: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	mov	0x38, %r26
	.word 0x87802073  ! 4025: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r23
	.word 0x87802072  ! 4027: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r25
	.word 0xd8d48400  ! 4029: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r12
	.word 0xd8c76000  ! 4030: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xdaad44a0  ! 4031: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0xda97e000  ! 4032: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xdaaf6000  ! 4033: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xda9e09e0  ! 4034: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0xded7ce60  ! 4035: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	.word 0xd8970e60  ! 4036: LDUHA_R	lduha	[%r28, %r0] 0x73, %r12
	.word 0xdabf0e60  ! 4037: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	mov	0x30, %r17
	mov	0x28, %r18
	.word 0xdaafe000  ! 4040: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd4dec9e0  ! 4041: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r10
	.word 0x87802020  ! 4042: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ac6000  ! 4043: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0x87802073  ! 4045: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaae89e0  ! 4046: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 4047: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabe49e0  ! 4048: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xd28fce80  ! 4049: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	.word 0xd0bfce40  ! 4050: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0xd0dc2000  ! 4051: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd88f4e60  ! 4052: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	mov	0x60, %r18
	.word 0x87802073  ! 4054: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd284c400  ! 4055: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	mov	0x48, %r16
	.word 0xd4cf4e40  ! 4057: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r10
	.word 0xdcdfce60  ! 4058: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	mov	0x10, %r16
	.word 0xdcafe000  ! 4060: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdca7a000  ! 4061: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdccfe000  ! 4062: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r14
	mov	0x28, %r24
	.word 0xdcd7e000  ! 4064: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4065: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4066: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca7a000  ! 4067: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcaf4e60  ! 4068: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	mov	0x48, %r27
	.word 0xd88ec9e0  ! 4070: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0xde87ce40  ! 4071: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r15
	.word 0xdcc70e60  ! 4072: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r14
	mov	0x58, %r24
	.word 0x87802074  ! 4074: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 4075: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0af8e40  ! 4076: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0xd2de09e0  ! 4077: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	.word 0xd29fa000  ! 4078: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0x87802072  ! 4079: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded78e60  ! 4080: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r15
	mov	0x7f8, %r20
	.word 0xdef72000  ! 4082: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xd8bf0e60  ! 4084: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	mov	0x18, %r16
	.word 0xde8d84a0  ! 4086: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	.word 0xd8bdc4a0  ! 4087: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xd4dcc400  ! 4088: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	mov	0x0, %r26
	mov	0x7e0, %r20
	.word 0x87802020  ! 4091: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a4a000  ! 4092: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd0f48400  ! 4093: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	mov	0x18, %r26
	.word 0xd0942000  ! 4095: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	.word 0xd8b649e0  ! 4096: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 4097: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd884a000  ! 4098: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8dcc400  ! 4099: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0x87802025  ! 4100: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cda000  ! 4101: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4102: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4103: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bf0e60  ! 4104: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4bc0400  ! 4106: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd68d04a0  ! 4107: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	.word 0xdcf70e80  ! 4108: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xdca4a000  ! 4109: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 4110: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8da000  ! 4111: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbce000  ! 4113: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdc94a000  ! 4114: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0xdeacc400  ! 4115: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xdeac2000  ! 4116: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xd2d74e40  ! 4117: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0x87802020  ! 4118: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29ce000  ! 4119: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd2d42000  ! 4120: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2a46000  ! 4121: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 4122: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa70e60  ! 4123: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xd8844400  ! 4124: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xd8c6a000  ! 4125: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xda8c8400  ! 4126: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	mov	0x48, %r17
	.word 0xdab62000  ! 4128: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0xd287ce40  ! 4129: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r9
	.word 0xd2c66000  ! 4130: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2962000  ! 4131: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xdaf48400  ! 4132: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xdaf66000  ! 4133: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	.word 0xda8e6000  ! 4134: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r13
	.word 0xdaae6000  ! 4135: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 4136: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdacf2000  ! 4137: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x0, %r17
	mov	0x48, %r24
	.word 0x87802073  ! 4140: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4141: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8fe000  ! 4142: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xd8ac8400  ! 4143: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	mov	0x78, %r18
	.word 0xd8b544a0  ! 4145: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	.word 0xd887e000  ! 4146: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd4a584a0  ! 4147: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	mov	0x8, %r16
	.word 0xd4af2000  ! 4149: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd48fe000  ! 4150: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xdcdf8e60  ! 4151: LDXA_R	ldxa	[%r30, %r0] 0x73, %r14
	mov	0x50, %r27
	mov	0x8, %r26
	.word 0xd0b78e60  ! 4154: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	.word 0xd0cfe000  ! 4155: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	mov	0x40, %r16
	.word 0xd0d7e000  ! 4157: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xdeaf4e60  ! 4158: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	mov	0x40, %r16
	.word 0xdef7e000  ! 4160: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdebf6000  ! 4161: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xde976000  ! 4162: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xdeb7ce60  ! 4163: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	mov	0x40, %r18
	.word 0xd2af4e40  ! 4165: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0xd29f6000  ! 4166: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	mov	0x3e0, %r23
	.word 0x87802072  ! 4168: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d72000  ! 4169: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xdef70e60  ! 4170: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	mov	0x3d8, %r22
	mov	0x8, %r24
	mov	0x58, %r19
	mov	0x28, %r26
	.word 0xd0d649e0  ! 4175: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r8
	mov	0x48, %r17
	.word 0xd0c72000  ! 4177: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd2f7ce60  ! 4178: STXA_R	stxa	%r9, [%r31 + %r0] 0x73
	.word 0xd2dfa000  ! 4179: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd287a000  ! 4180: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2c72000  ! 4181: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 4182: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	mov	0x0, %r26
	mov	0x60, %r25
	.word 0xd2af2000  ! 4185: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd29fe000  ! 4186: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x3e0, %r20
	.word 0xda97ce80  ! 4188: LDUHA_R	lduha	[%r31, %r0] 0x74, %r13
	.word 0xd28649e0  ! 4189: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r9
	mov	0x7e0, %r23
	.word 0xdeaf4e80  ! 4191: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0xdcc7ce40  ! 4192: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r14
	.word 0xdebe89e0  ! 4193: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	mov	0x28, %r27
	.word 0xd4af0e80  ! 4195: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	mov	0x7c8, %r20
	.word 0xd4a72000  ! 4197: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd2a78e80  ! 4198: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0xd2bfe000  ! 4199: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2afe000  ! 4200: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd28f6000  ! 4201: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd28f2000  ! 4202: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd297e000  ! 4203: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	mov	0x20, %r27
	.word 0xd2af6000  ! 4205: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xdaf649e0  ! 4206: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	mov	0x3d0, %r23
	mov	0x0, %r25
	.word 0x87802073  ! 4209: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r27
	.word 0xdad7e000  ! 4211: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	mov	0x58, %r26
	.word 0x87802020  ! 4213: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b689e0  ! 4214: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xd6b4e000  ! 4215: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 4216: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f76000  ! 4217: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xd6afe000  ! 4219: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xd6a72000  ! 4221: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd69f6000  ! 4222: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	mov	0x3d8, %r21
	.word 0xd4ad84a0  ! 4224: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	.word 0xdcc4c400  ! 4225: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xdc84c400  ! 4226: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	mov	0x58, %r27
	mov	0x58, %r26
	.word 0xdcae49e0  ! 4229: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 4230: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4231: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdf2000  ! 4232: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdeb7ce60  ! 4233: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0x87802020  ! 4234: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8f4e60  ! 4235: LDUBA_R	lduba	[%r29, %r0] 0x73, %r15
	.word 0x87802025  ! 4236: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcd78e80  ! 4237: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r14
	.word 0xdcf5e000  ! 4238: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	.word 0xdca56000  ! 4239: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xdcb56000  ! 4241: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 4242: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb4e000  ! 4243: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	mov	0x7e0, %r22
	mov	0x68, %r27
	.word 0xdcbca000  ! 4246: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdc9d44a0  ! 4247: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	.word 0xdcf74e80  ! 4248: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	.word 0xdc870e40  ! 4249: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r14
	mov	0x3d0, %r22
	.word 0xdebc4400  ! 4251: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	mov	0x3e8, %r21
	.word 0xd4a44400  ! 4253: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xde9cc400  ! 4254: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdc84c400  ! 4256: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xdcd4e000  ! 4257: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4258: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r24
	.word 0xdcac6000  ! 4260: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4261: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaae89e0  ! 4262: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xd4a5c4a0  ! 4263: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xd2b4c400  ! 4264: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x87802073  ! 4265: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d7e000  ! 4266: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xdab44400  ! 4267: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x68, %r26
	.word 0x87802074  ! 4269: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf7e000  ! 4270: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 4271: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d7ce40  ! 4272: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r12
	mov	0x50, %r26
	.word 0xd6bd04a0  ! 4274: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	.word 0x87802020  ! 4275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cce000  ! 4276: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	.word 0xd6a46000  ! 4277: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xdeaf8e40  ! 4279: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	mov	0x0, %r16
	mov	0x30, %r18
	.word 0xded4a000  ! 4282: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xdef4a000  ! 4283: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 4284: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4285: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r16
	mov	0x40, %r19
	.word 0xd4f649e0  ! 4288: STXA_R	stxa	%r10, [%r25 + %r0] 0x4f
	.word 0x87802074  ! 4289: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4af2000  ! 4290: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 4291: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4974e40  ! 4292: LDUHA_R	lduha	[%r29, %r0] 0x72, %r10
	.word 0xd4f72000  ! 4293: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	mov	0x3d8, %r21
	.word 0xd48f2000  ! 4295: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802025  ! 4296: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd485a000  ! 4297: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r10
	.word 0xd2a609e0  ! 4298: STWA_R	stwa	%r9, [%r24 + %r0] 0x4f
	mov	0x20, %r18
	.word 0xd8b70e40  ! 4300: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	mov	0x48, %r16
	.word 0xd88f0e60  ! 4302: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	.word 0x87802072  ! 4303: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8af2000  ! 4304: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8d72000  ! 4305: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8f689e0  ! 4306: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0xdebcc400  ! 4307: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xdebf6000  ! 4308: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xdea544a0  ! 4309: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xded72000  ! 4310: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdecf6000  ! 4311: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xdebf4e60  ! 4312: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xda9d44a0  ! 4313: LDDA_R	ldda	[%r21, %r0] 0x25, %r13
	.word 0xd8bd44a0  ! 4314: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0x87802074  ! 4315: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0af8e60  ! 4316: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0x87802074  ! 4317: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4318: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r25
	.word 0x87802020  ! 4320: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6df8e80  ! 4321: LDXA_R	ldxa	[%r30, %r0] 0x74, %r11
	.word 0xdcb7ce60  ! 4322: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	mov	0x7d0, %r22
	.word 0xdcb4e000  ! 4324: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdcf4e000  ! 4325: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcb4e000  ! 4326: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4327: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc842000  ! 4328: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4329: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca62000  ! 4330: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	.word 0xd6878e40  ! 4331: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0x87802074  ! 4332: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6dfe000  ! 4333: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802073  ! 4334: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r17
	mov	0x7f8, %r20
	.word 0xd2d74e40  ! 4337: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0xd29fe000  ! 4338: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x3e8, %r23
	.word 0xdcd44400  ! 4340: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	.word 0xdcb7a000  ! 4341: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdcb7a000  ! 4342: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdca7e000  ! 4343: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd4c6c9e0  ! 4344: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r10
	.word 0xd09f8e60  ! 4345: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	mov	0x38, %r17
	.word 0xd6f5c4a0  ! 4347: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	mov	0x58, %r19
	.word 0x87802020  ! 4349: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4350: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6976000  ! 4351: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	mov	0x20, %r26
	.word 0xd6f7a000  ! 4353: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd4cfce40  ! 4354: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r10
	.word 0x87802072  ! 4355: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49f6000  ! 4356: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd0c74e40  ! 4357: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	mov	0x18, %r25
	mov	0x7e8, %r23
	.word 0xd0f7a000  ! 4360: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xde9cc400  ! 4361: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xd0a78e80  ! 4362: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	mov	0x68, %r27
	.word 0x8780204f  ! 4364: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4365: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabdc4a0  ! 4366: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xdadce000  ! 4367: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xda94a000  ! 4368: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802025  ! 4369: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 4370: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r25
	.word 0xdec44400  ! 4372: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	mov	0x48, %r17
	.word 0xde876000  ! 4374: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdec7a000  ! 4375: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdea7a000  ! 4376: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 4377: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r18
	.word 0xd4a4c400  ! 4379: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	mov	0x8, %r18
	.word 0xde8f0e80  ! 4381: LDUBA_R	lduba	[%r28, %r0] 0x74, %r15
	.word 0xdc8689e0  ! 4382: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	.word 0xdcbfe000  ! 4383: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdedcc400  ! 4384: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	.word 0xd2b689e0  ! 4385: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	mov	0x68, %r18
	.word 0xd8a70e80  ! 4387: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	mov	0x0, %r16
	.word 0xd8c7a000  ! 4389: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8afe000  ! 4390: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4391: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8d72000  ! 4392: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	mov	0x7e0, %r20
	.word 0xda94c400  ! 4394: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0x87802025  ! 4395: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r16
	.word 0xdacde000  ! 4397: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r13
	.word 0xda95a000  ! 4398: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	.word 0xda95a000  ! 4399: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4400: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4ac8400  ! 4401: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd4c4e000  ! 4402: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	mov	0x3c8, %r21
	mov	0x7d8, %r22
	mov	0x3e8, %r22
	.word 0xd4a7ce80  ! 4406: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	.word 0xdeb584a0  ! 4407: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0xd8f544a0  ! 4408: STXA_R	stxa	%r12, [%r21 + %r0] 0x25
	.word 0xd6bf4e60  ! 4409: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xd68e49e0  ! 4410: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r11
	mov	0x68, %r19
	.word 0xd694e000  ! 4412: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0xd69ce000  ! 4413: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xdecc4400  ! 4414: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	mov	0x68, %r24
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802074  ! 4417: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac544a0  ! 4418: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r13
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcc4c400  ! 4420: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xdcafe000  ! 4421: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdc872000  ! 4422: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x0, %r25
	.word 0xdcb7a000  ! 4424: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdcafe000  ! 4425: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdc8fe000  ! 4426: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xdca7a000  ! 4427: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdaa504a0  ! 4428: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0xd4844400  ! 4429: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xd0cdc4a0  ! 4430: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r8
	mov	0x7d0, %r22
	mov	0x8, %r24
	mov	0x30, %r17
	.word 0xd0876000  ! 4434: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd8a78e80  ! 4435: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	mov	0x8, %r27
	.word 0xd8f7a000  ! 4437: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8f7e000  ! 4438: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8bec9e0  ! 4439: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0xd887e000  ! 4440: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd887a000  ! 4441: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8b76000  ! 4442: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4443: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bce000  ! 4444: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8b42000  ! 4445: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xd89c2000  ! 4447: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xda87ce80  ! 4448: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	.word 0xda94a000  ! 4449: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0xdac42000  ! 4450: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4451: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4452: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r27
	.word 0xd8be89e0  ! 4454: STDA_R	stda	%r12, [%r26 + %r0] 0x4f
	mov	0x0, %r24
	.word 0xd2b689e0  ! 4456: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xd8dc0400  ! 4457: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0x87802073  ! 4458: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r25
	.word 0xd8afe000  ! 4460: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xdaf609e0  ! 4461: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	mov	0x40, %r27
	.word 0xdac72000  ! 4463: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 4464: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 4465: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa7a000  ! 4466: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xda87a000  ! 4467: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	mov	0x7c0, %r22
	.word 0x8780204f  ! 4469: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b7ce40  ! 4470: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd896e000  ! 4471: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r12
	.word 0x87802072  ! 4472: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r16
	.word 0xd2dfce60  ! 4474: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	.word 0xd486c9e0  ! 4475: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	.word 0xdef74e40  ! 4476: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0x87802020  ! 4477: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4478: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8f4e40  ! 4479: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0xd2b78e60  ! 4480: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	.word 0xd294e000  ! 4481: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd6adc4a0  ! 4482: STBA_R	stba	%r11, [%r23 + %r0] 0x25
	.word 0xd0b649e0  ! 4483: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	.word 0xd0cd04a0  ! 4484: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r8
	mov	0x7d0, %r22
	.word 0xd6cfce60  ! 4486: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r11
	mov	0x50, %r25
	.word 0x87802072  ! 4488: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4ae49e0  ! 4489: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xd4af2000  ! 4490: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd4df2000  ! 4491: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4df2000  ! 4492: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	mov	0x3d8, %r21
	.word 0xdeaf0e40  ! 4494: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	mov	0x7d8, %r21
	.word 0x87802072  ! 4496: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde9fe000  ! 4497: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	mov	0x7d8, %r22
	.word 0xdeb7e000  ! 4499: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdecfce60  ! 4500: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r15
	.word 0xdca40400  ! 4501: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xda9dc4a0  ! 4502: LDDA_R	ldda	[%r23, %r0] 0x25, %r13
	mov	0x68, %r25
	mov	0x70, %r17
	.word 0xdaa7e000  ! 4505: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x7c8, %r21
	.word 0xdca7ce40  ! 4508: STWA_R	stwa	%r14, [%r31 + %r0] 0x72
	mov	0x28, %r18
	mov	0x8, %r18
	.word 0xd89584a0  ! 4511: LDUHA_R	lduha	[%r22, %r0] 0x25, %r12
	.word 0x87802073  ! 4512: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b72000  ! 4513: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 4514: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc844400  ! 4515: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xdcf52000  ! 4516: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	mov	0x28, %r16
	mov	0x10, %r27
	mov	0x50, %r17
	.word 0xdcb52000  ! 4520: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0x87802020  ! 4521: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r23
	.word 0xdc9ce000  ! 4523: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	.word 0xd6f6c9e0  ! 4524: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	mov	0x7e0, %r20
	mov	0x28, %r26
	.word 0xd0d4c400  ! 4527: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd6df8e80  ! 4528: LDXA_R	ldxa	[%r30, %r0] 0x74, %r11
	.word 0xde848400  ! 4529: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	mov	0x58, %r25
	.word 0xdef48400  ! 4531: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	mov	0x7e0, %r23
	.word 0xd8dd84a0  ! 4533: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0xd8a42000  ! 4534: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd29f4e60  ! 4535: LDDA_R	ldda	[%r29, %r0] 0x73, %r9
	mov	0x40, %r24
	.word 0xd2942000  ! 4537: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 4538: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4539: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29ce000  ! 4540: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd2b4a000  ! 4541: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4542: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r25
	.word 0xd2f544a0  ! 4544: STXA_R	stxa	%r9, [%r21 + %r0] 0x25
	.word 0x87802020  ! 4545: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a46000  ! 4546: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bc2000  ! 4547: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xdc8f4e60  ! 4548: LDUBA_R	lduba	[%r29, %r0] 0x73, %r14
	.word 0x87802020  ! 4549: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r26
	.word 0xd0bdc4a0  ! 4551: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0x87802072  ! 4552: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cc0400  ! 4553: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	mov	0x3f8, %r23
	.word 0xd087e000  ! 4555: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	mov	0x28, %r17
	.word 0x87802073  ! 4557: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r26
	.word 0xd08fe000  ! 4559: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xd097a000  ! 4560: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd2a78e60  ! 4561: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0x87802020  ! 4562: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29ce000  ! 4563: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd6a689e0  ! 4564: STWA_R	stwa	%r11, [%r26 + %r0] 0x4f
	mov	0x38, %r25
	.word 0x87802072  ! 4566: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bd44a0  ! 4567: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	mov	0x60, %r25
	.word 0xd8a4c400  ! 4569: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xd8d76000  ! 4570: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8a7e000  ! 4571: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd6d4c400  ! 4572: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xd2c44400  ! 4573: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	mov	0x30, %r26
	.word 0xd29f6000  ! 4575: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	mov	0x7d0, %r23
	mov	0x78, %r27
	mov	0x28, %r26
	.word 0xdad70e40  ! 4579: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	.word 0xda8f2000  ! 4580: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdabf2000  ! 4581: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xd895c4a0  ! 4582: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	.word 0xd8af6000  ! 4583: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4584: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f74e60  ! 4585: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0x87802020  ! 4586: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6af8e80  ! 4587: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0x87802072  ! 4588: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb584a0  ! 4589: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xd0bcc400  ! 4590: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xdaac4400  ! 4591: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xd0ccc400  ! 4592: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0x87802020  ! 4593: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c78e40  ! 4594: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	.word 0xdedcc400  ! 4595: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	mov	0x38, %r27
	mov	0x40, %r17
	.word 0xdeb46000  ! 4598: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 4599: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d5c4a0  ! 4600: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r8
	.word 0x87802073  ! 4601: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4602: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea48400  ! 4603: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	mov	0x18, %r18
	.word 0xdeb7e000  ! 4605: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd4a48400  ! 4606: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 4607: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r16
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd49e6000  ! 4610: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	.word 0xd4a66000  ! 4611: STWA_I	stwa	%r10, [%r25 + 0x0000] %asi
	.word 0xd0bc8400  ! 4612: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xded7ce80  ! 4613: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	.word 0xd4f78e40  ! 4614: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	mov	0x0, %r24
	.word 0xd4f6e000  ! 4616: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xd4f62000  ! 4618: STXA_I	stxa	%r10, [%r24 + 0x0000] %asi
	.word 0xd2cf0e80  ! 4619: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xdcdf0e40  ! 4620: LDXA_R	ldxa	[%r28, %r0] 0x72, %r14
	.word 0x87802074  ! 4621: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4622: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b78e80  ! 4623: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	.word 0xd6b44400  ! 4624: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	mov	0x3c0, %r21
	mov	0x10, %r26
	.word 0xd6876000  ! 4627: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	.word 0x87802073  ! 4628: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r17
	.word 0xd2a584a0  ! 4630: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	.word 0x87802074  ! 4631: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r16
	.word 0xd08544a0  ! 4633: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	.word 0xd0b40400  ! 4634: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	mov	0x50, %r27
	.word 0xd0af2000  ! 4636: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xd0b76000  ! 4638: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0af2000  ! 4639: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xdac6c9e0  ! 4640: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r13
	mov	0x0, %r18
	.word 0x87802074  ! 4642: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3d8, %r20
	.word 0xda8f6000  ! 4644: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	mov	0x3f8, %r22
	.word 0xdab7a000  ! 4646: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0xdadd44a0  ! 4647: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	.word 0xda876000  ! 4648: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xda9f2000  ! 4649: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	mov	0x20, %r26
	.word 0xdacf6000  ! 4651: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xda9f6000  ! 4652: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0x87802025  ! 4653: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda95a000  ! 4654: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	mov	0x3e0, %r22
	.word 0x8780204f  ! 4656: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bc0400  ! 4657: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd2a7ce40  ! 4658: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0xdac74e80  ! 4659: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0x87802020  ! 4660: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r23
	.word 0xd2f5c4a0  ! 4662: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0xd0bc4400  ! 4663: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd0b4e000  ! 4664: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd0dc2000  ! 4665: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xd08c2000  ! 4666: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd09c6000  ! 4667: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b4a000  ! 4668: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0f4a000  ! 4670: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0bce000  ! 4671: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd8974e80  ! 4672: LDUHA_R	lduha	[%r29, %r0] 0x74, %r12
	.word 0x8780204f  ! 4673: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ce6000  ! 4674: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0xd6b544a0  ! 4675: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xd6cee000  ! 4676: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	mov	0x38, %r17
	mov	0x78, %r24
	mov	0x3f8, %r22
	.word 0x87802020  ! 4680: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeac4400  ! 4681: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0x87802074  ! 4682: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab6c9e0  ! 4683: STHA_R	stha	%r13, [%r27 + %r0] 0x4f
	.word 0xda9fe000  ! 4684: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0x87802074  ! 4685: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r26
	mov	0x7d8, %r20
	.word 0xd2a7ce40  ! 4688: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	mov	0x50, %r27
	.word 0xd2b7e000  ! 4690: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd6a544a0  ! 4692: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0xd08cc400  ! 4693: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	.word 0xd685c4a0  ! 4694: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r11
	mov	0x7f8, %r22
	.word 0xde944400  ! 4696: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xdcbec9e0  ! 4697: STDA_R	stda	%r14, [%r27 + %r0] 0x4f
	.word 0xd6f584a0  ! 4698: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	mov	0x0, %r24
	.word 0xd6afe000  ! 4700: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6b7a000  ! 4701: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 4702: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 4703: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc7ce80  ! 4704: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r14
	.word 0xdca62000  ! 4705: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xdcb6e000  ! 4707: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	mov	0x20, %r24
	mov	0x30, %r19
	.word 0xdcae2000  ! 4710: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	mov	0x0, %r19
	mov	0x40, %r18
	.word 0xd8c7ce40  ! 4713: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r12
	mov	0x30, %r24
	mov	0x38, %r16
	.word 0xd8b66000  ! 4716: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	mov	0x3d0, %r22
	mov	0x78, %r18
	.word 0x87802072  ! 4719: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd887e000  ! 4720: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	mov	0x58, %r27
	.word 0xd4a5c4a0  ! 4722: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xd0cf4e40  ! 4723: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	mov	0x40, %r25
	.word 0x87802072  ! 4725: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dfce60  ! 4726: LDXA_R	ldxa	[%r31, %r0] 0x73, %r8
	.word 0xd0f70e80  ! 4727: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	.word 0xd0f7e000  ! 4728: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4729: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 4730: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4731: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bfe000  ! 4732: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd2f70e80  ! 4733: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	.word 0xd2f72000  ! 4734: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd0b48400  ! 4735: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd0f72000  ! 4736: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0b7a000  ! 4737: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bf2000  ! 4738: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	mov	0x38, %r26
	.word 0x87802072  ! 4740: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4741: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dfe000  ! 4742: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd88c4400  ! 4743: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	mov	0x30, %r25
	.word 0xde9649e0  ! 4745: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	.word 0x87802074  ! 4746: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8c8400  ! 4747: LDUBA_R	lduba	[%r18, %r0] 0x20, %r13
	mov	0x7e8, %r21
	.word 0xd6a7ce80  ! 4749: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 4750: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68d44a0  ! 4751: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	mov	0x60, %r16
	mov	0x58, %r26
	.word 0xd6d62000  ! 4754: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r11
	.word 0x87802020  ! 4755: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a78e40  ! 4756: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	mov	0x8, %r24
	mov	0x3f8, %r20
	.word 0xd4dc6000  ! 4759: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd6b44400  ! 4760: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd8cfce80  ! 4761: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xd8846000  ! 4762: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	mov	0x38, %r24
	mov	0x3d8, %r21
	.word 0x87802073  ! 4765: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 4766: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2acc400  ! 4767: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xd6bc4400  ! 4768: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xd0878e80  ! 4769: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r8
	.word 0x87802020  ! 4770: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ace000  ! 4771: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xdcf74e60  ! 4772: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0xdc94e000  ! 4773: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	mov	0x3e8, %r23
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcb4a000  ! 4776: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdccca000  ! 4777: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xdcc44400  ! 4778: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	mov	0x70, %r18
	.word 0xd89e49e0  ! 4780: LDDA_R	ldda	[%r25, %r0] 0x4f, %r12
	.word 0xd2d74e60  ! 4781: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xd28c6000  ! 4782: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	mov	0x58, %r18
	.word 0xd2b4a000  ! 4784: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0x87802072  ! 4785: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4786: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29ce000  ! 4787: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd28c6000  ! 4788: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd4cdc4a0  ! 4789: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r10
	.word 0xd0874e40  ! 4790: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r8
	.word 0xd2978e60  ! 4791: LDUHA_R	lduha	[%r30, %r0] 0x73, %r9
	.word 0xd2842000  ! 4792: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ac6000  ! 4793: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd2a4a000  ! 4794: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x58, %r17
	mov	0x48, %r26
	mov	0x78, %r19
	.word 0xd2bca000  ! 4798: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd0f78e80  ! 4799: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0xde8f8e60  ! 4800: LDUBA_R	lduba	[%r30, %r0] 0x73, %r15
	.word 0xdec74e80  ! 4801: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	.word 0x87802020  ! 4802: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded649e0  ! 4803: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	mov	0x7e8, %r22
	mov	0x7f0, %r20
	.word 0xdeac6000  ! 4806: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xd4f584a0  ! 4807: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	.word 0xd2bc0400  ! 4808: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	mov	0x3d8, %r20
	.word 0xd284e000  ! 4810: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd4c78e40  ! 4811: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r10
	.word 0xd6f544a0  ! 4812: STXA_R	stxa	%r11, [%r21 + %r0] 0x25
	.word 0xd2c40400  ! 4813: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	.word 0xd4f44400  ! 4814: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd4b649e0  ! 4815: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xd684c400  ! 4816: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xd88f0e60  ! 4817: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	.word 0xd89c6000  ! 4818: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xd49504a0  ! 4819: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	.word 0xd89544a0  ! 4820: LDUHA_R	lduha	[%r21, %r0] 0x25, %r12
	.word 0xd88ce000  ! 4821: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r12
	.word 0xd8b44400  ! 4822: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0x87802025  ! 4823: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r19
	.word 0xd8ad2000  ! 4825: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	mov	0x3c8, %r22
	.word 0xd88d6000  ! 4827: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	.word 0xd4adc4a0  ! 4828: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xd8bf4e60  ! 4829: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xd8d56000  ! 4830: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	.word 0xd8cd2000  ! 4831: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	.word 0xd8bd6000  ! 4832: STDA_I	stda	%r12, [%r21 + 0x0000] %asi
	mov	0x3e0, %r20
	mov	0x70, %r17
	mov	0x60, %r27
	.word 0xdebc8400  ! 4836: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0xd4bd04a0  ! 4837: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	mov	0x3f0, %r22
	.word 0xd4d5a000  ! 4839: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	mov	0x48, %r19
	mov	0x20, %r19
	.word 0xd4a52000  ! 4842: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xdeb4c400  ! 4844: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdadf4e60  ! 4845: LDXA_R	ldxa	[%r29, %r0] 0x73, %r13
	.word 0xdaf52000  ! 4846: STXA_I	stxa	%r13, [%r20 + 0x0000] %asi
	.word 0xd2a70e80  ! 4847: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	mov	0x70, %r26
	mov	0x38, %r25
	.word 0xd4a48400  ! 4850: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd4956000  ! 4851: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	mov	0x3e0, %r21
	.word 0xd48da000  ! 4853: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	.word 0x87802020  ! 4854: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 4855: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bf2000  ! 4856: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd68c0400  ! 4857: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xd8af8e40  ! 4858: STBA_R	stba	%r12, [%r30 + %r0] 0x72
	mov	0x48, %r25
	mov	0x28, %r19
	.word 0x87802073  ! 4861: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r24
	.word 0xd8b7a000  ! 4863: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 4864: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd08609e0  ! 4866: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	mov	0x10, %r16
	.word 0xd2cd04a0  ! 4868: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	.word 0x87802073  ! 4869: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r22
	.word 0xd2f7e000  ! 4871: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0x87802025  ! 4873: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4874: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2df2000  ! 4875: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2d76000  ! 4876: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4877: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cce000  ! 4878: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd294e000  ! 4879: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd28c2000  ! 4880: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4881: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4882: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4883: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d78e40  ! 4884: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	.word 0xd4a42000  ! 4885: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd4bca000  ! 4886: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4bc2000  ! 4887: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd68c0400  ! 4888: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xd6942000  ! 4889: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	.word 0xd8b74e80  ! 4890: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 4891: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcd7ce80  ! 4892: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	.word 0xdcaea000  ! 4893: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	mov	0x38, %r25
	.word 0x87802025  ! 4895: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdcc400  ! 4896: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	mov	0x60, %r27
	.word 0xd6f70e40  ! 4898: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xdebc0400  ! 4899: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xde95a000  ! 4900: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r15
	.word 0xd49609e0  ! 4901: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r10
	.word 0xd4f5a000  ! 4902: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xd495e000  ! 4903: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0xd8f74e60  ! 4904: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd6cd84a0  ! 4905: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0xdcb649e0  ! 4906: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 4907: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r21
	.word 0xdadcc400  ! 4909: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xdadca000  ! 4910: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	mov	0x48, %r24
	.word 0xd8a44400  ! 4912: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd8d42000  ! 4913: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	mov	0x28, %r16
	.word 0xd8d4e000  ! 4915: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	mov	0x10, %r27
	.word 0xd88544a0  ! 4917: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	mov	0x78, %r24
	.word 0xd88c2000  ! 4919: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd8a46000  ! 4920: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8f4e000  ! 4921: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	mov	0x3e0, %r22
	.word 0xd8a4a000  ! 4923: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x78, %r27
	.word 0xda8fce60  ! 4925: LDUBA_R	lduba	[%r31, %r0] 0x73, %r13
	.word 0xdab4e000  ! 4926: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdab42000  ! 4927: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 4928: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf72000  ! 4929: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xdabf2000  ! 4931: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xd88cc400  ! 4932: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0x87802020  ! 4933: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49649e0  ! 4934: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	.word 0xd4b42000  ! 4935: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd4ac2000  ! 4936: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	.word 0xd28e49e0  ! 4937: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r9
	.word 0x87802073  ! 4938: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaaf0e80  ! 4939: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	mov	0x38, %r24
	.word 0xdaf7e000  ! 4941: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd49f8e40  ! 4942: LDDA_R	ldda	[%r30, %r0] 0x72, %r10
	mov	0x7f8, %r20
	mov	0x3f8, %r21
	.word 0xd4dfa000  ! 4945: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd497e000  ! 4946: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd48cc400  ! 4947: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	mov	0x60, %r19
	.word 0xd4bfa000  ! 4949: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xde95c4a0  ! 4950: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xdedfce80  ! 4951: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	.word 0xde87e000  ! 4952: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdabf0e80  ! 4953: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0x87802020  ! 4954: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8c689e0  ! 4955: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r12
	.word 0xd29c8400  ! 4956: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	.word 0xd2c46000  ! 4957: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2bc2000  ! 4958: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2842000  ! 4959: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcd4c400  ! 4961: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	mov	0x7c8, %r22
	.word 0xdec649e0  ! 4963: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r15
	.word 0x87802020  ! 4964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8874e40  ! 4965: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r12
	.word 0xd8bc6000  ! 4966: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8d4a000  ! 4967: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd0f5c4a0  ! 4968: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0xd0dc6000  ! 4969: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xdca504a0  ! 4970: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xda9d04a0  ! 4971: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	.word 0x87802020  ! 4972: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a649e0  ! 4973: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0xd6bc6000  ! 4974: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd4b78e60  ! 4975: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0x87802020  ! 4976: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	.word 0xd4bce000  ! 4978: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd49ca000  ! 4979: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd0d70e80  ! 4980: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r8
	.word 0x87802025  ! 4981: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ada000  ! 4982: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	.word 0xd0a52000  ! 4983: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xdebc4400  ! 4984: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	mov	0x3c0, %r22
	.word 0xd4ad04a0  ! 4986: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0xd0a7ce60  ! 4987: STWA_R	stwa	%r8, [%r31 + %r0] 0x73
	.word 0xd8ac0400  ! 4988: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd8bd2000  ! 4989: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	mov	0x28, %r24
	.word 0xd285c4a0  ! 4991: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r9
	mov	0x3d8, %r20
	mov	0x48, %r25
	.word 0xd2dda000  ! 4994: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r9
	.word 0xd28da000  ! 4995: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4996: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebfce60  ! 4997: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	mov	0x3e0, %r23
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_3:
	.word 0xd4f689e0  ! 1: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0xd48c8400  ! 2: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	.word 0xdc9ee000  ! 3: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r14
	.word 0xdcc62000  ! 4: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	.word 0xdc962000  ! 5: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r14
	.word 0xd2af8e80  ! 6: STBA_R	stba	%r9, [%r30 + %r0] 0x74
	mov	0x28, %r24
	.word 0xdabfce60  ! 8: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	mov	0x48, %r25
	.word 0xd2f40400  ! 10: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd4f7ce40  ! 11: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0xd8a70e80  ! 12: STWA_R	stwa	%r12, [%r28 + %r0] 0x74
	mov	0x8, %r26
	mov	0x70, %r18
	.word 0xd89d84a0  ! 15: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	mov	0x50, %r17
	.word 0xdcae2000  ! 17: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	.word 0xdc9e2000  ! 18: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	.word 0xdcd6e000  ! 19: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r14
	.word 0xdcc6a000  ! 20: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0x87802025  ! 21: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 22: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a504a0  ! 23: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	mov	0x3d0, %r22
	.word 0x87802074  ! 25: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8962000  ! 26: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	mov	0x60, %r18
	.word 0x87802073  ! 28: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7c8, %r21
	.word 0xd8ad2000  ! 30: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd4a78e80  ! 31: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xd8afce80  ! 32: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	mov	0x3d0, %r20
	.word 0xd0dd44a0  ! 34: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	mov	0x3d8, %r23
	.word 0xd0bc4400  ! 36: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0x87802074  ! 37: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4a4c400  ! 38: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0x87802074  ! 39: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r24
	.word 0xdec609e0  ! 41: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r15
	.word 0xdacf4e60  ! 42: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r13
	mov	0x48, %r18
	.word 0xdac74e80  ! 44: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	mov	0x68, %r18
	mov	0x28, %r17
	.word 0x87802072  ! 47: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f4e000  ! 48: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd8cc8400  ! 49: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xd4b46000  ! 50: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 51: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4972000  ! 52: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xdcaec9e0  ! 53: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xdec504a0  ! 54: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r15
	.word 0xdcdf0e80  ! 55: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0xdaf7a000  ! 56: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaa4c400  ! 57: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xd2c74e80  ! 58: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r9
	mov	0x58, %r24
	.word 0x87802020  ! 60: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b46000  ! 61: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 62: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r17
	.word 0xd6c4a000  ! 64: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r11
	.word 0xd694e000  ! 65: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	mov	0x3c8, %r23
	.word 0xd0af8e60  ! 67: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0x87802074  ! 68: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r17
	.word 0xdab70e60  ! 70: STHA_R	stha	%r13, [%r28 + %r0] 0x73
	.word 0xdca76000  ! 71: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdc87e000  ! 72: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xd8dcc400  ! 73: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0x87802020  ! 74: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 75: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd09e2000  ! 76: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r8
	.word 0xd0c40400  ! 77: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd6dc4400  ! 78: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd28e6000  ! 79: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r9
	.word 0xd2a6a000  ! 80: STWA_I	stwa	%r9, [%r26 + 0x0000] %asi
	.word 0xd2866000  ! 81: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	.word 0x87802072  ! 82: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28c6000  ! 83: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2842000  ! 84: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xdc948400  ! 85: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	mov	0x78, %r18
	.word 0xd2940400  ! 87: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	mov	0x7e8, %r23
	mov	0x30, %r25
	.word 0xdcd48400  ! 90: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	.word 0xd684a000  ! 91: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6b46000  ! 92: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd6b42000  ! 93: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd6dce000  ! 94: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd4b649e0  ! 95: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xd4c40400  ! 96: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xded42000  ! 97: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0x87802072  ! 98: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd687ce80  ! 99: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r11
	.word 0xd0c689e0  ! 100: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r8
	.word 0xd484c400  ! 101: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x58, %r27
	.word 0x87802025  ! 103: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29c4400  ! 104: LDDA_R	ldda	[%r17, %r0] 0x20, %r9
	.word 0xd6de89e0  ! 105: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r11
	.word 0xd8d46000  ! 106: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0x87802073  ! 107: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d56000  ! 108: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	.word 0xdedfce40  ! 109: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xd8a52000  ! 110: STWA_I	stwa	%r12, [%r20 + 0x0000] %asi
	mov	0x68, %r24
	.word 0xd8ad6000  ! 112: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	.word 0xdcd44400  ! 113: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r14
	mov	0x3c0, %r20
	mov	0x3d0, %r23
	.word 0x87802072  ! 116: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r27
	.word 0xd6cf0e80  ! 118: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r11
	.word 0xd0b7ce60  ! 119: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd8bf4e60  ! 120: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	.word 0xdac6a000  ! 121: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xdaae2000  ! 122: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xdabee000  ! 124: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xd4a70e40  ! 125: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xdaa6e000  ! 126: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xda96a000  ! 127: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r13
	mov	0x70, %r16
	mov	0x58, %r27
	.word 0x87802025  ! 130: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda9e6000  ! 131: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0xdab7ce60  ! 132: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	mov	0x60, %r16
	mov	0x3c0, %r23
	.word 0xd2a48400  ! 135: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xdeaee000  ! 136: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	.word 0xd0f70e40  ! 137: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xd2866000  ! 138: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	.word 0xdcdc0400  ! 139: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0f70e40  ! 141: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0x87802020  ! 142: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f6a000  ! 143: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	mov	0x7d8, %r20
	mov	0x0, %r24
	.word 0xd88f4e40  ! 146: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	.word 0xd8ce6000  ! 147: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0xd88ee000  ! 148: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r12
	.word 0xd8c6a000  ! 149: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xd6a40400  ! 150: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0x87802025  ! 151: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c7ce80  ! 152: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r8
	.word 0xd4a42000  ! 153: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xdeb78e60  ! 154: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xd68e09e0  ! 155: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r11
	mov	0x30, %r25
	.word 0x87802074  ! 157: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea78e60  ! 158: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0xd8872000  ! 159: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xd887e000  ! 160: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd4df4e80  ! 161: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	.word 0xd2dd44a0  ! 162: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	.word 0xdcbf0e80  ! 163: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0xda9fa000  ! 164: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x3c8, %r21
	.word 0xdabf2000  ! 166: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 167: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa62000  ! 168: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	.word 0xdca504a0  ! 169: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xd0f7ce40  ! 170: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	mov	0x7f0, %r23
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4b62000  ! 173: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	.word 0xd4aea000  ! 174: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xd4dea000  ! 175: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd4aea000  ! 176: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xd2f78e40  ! 177: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xdc96e000  ! 178: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r14
	.word 0xdc86e000  ! 179: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0xdef4c400  ! 180: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x28, %r27
	mov	0x3c8, %r22
	.word 0xd0a7ce40  ! 183: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	mov	0x30, %r19
	mov	0x3f0, %r23
	.word 0x87802025  ! 186: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7e8, %r22
	.word 0x87802020  ! 189: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r19
	.word 0xd0a70e40  ! 191: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	mov	0x68, %r26
	mov	0x48, %r26
	.word 0xdcac4400  ! 194: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	.word 0xd0b66000  ! 195: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0xd69f0e60  ! 196: LDDA_R	ldda	[%r28, %r0] 0x73, %r11
	.word 0xda86e000  ! 197: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r13
	.word 0xdaa66000  ! 198: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xd4b74e40  ! 199: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xdaaea000  ! 200: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	.word 0xd0a649e0  ! 201: STWA_R	stwa	%r8, [%r25 + %r0] 0x4f
	.word 0xd4be6000  ! 202: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xd4dea000  ! 204: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd4cee000  ! 205: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	mov	0x40, %r18
	mov	0x58, %r26
	mov	0x50, %r18
	mov	0x10, %r24
	mov	0x3d0, %r21
	.word 0xdaf48400  ! 211: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd0f62000  ! 212: STXA_I	stxa	%r8, [%r24 + 0x0000] %asi
	.word 0xd0a6e000  ! 213: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0xd8f48400  ! 214: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd09f4e40  ! 215: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	.word 0xdece89e0  ! 216: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	.word 0xdad584a0  ! 217: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r13
	mov	0x18, %r24
	.word 0xde962000  ! 219: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r15
	mov	0x3d0, %r23
	.word 0xdeb62000  ! 221: STHA_I	stha	%r15, [%r24 + 0x0000] %asi
	.word 0xde866000  ! 222: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	mov	0x18, %r19
	.word 0x87802025  ! 224: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdef4e000  ! 226: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xde94a000  ! 227: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r15
	.word 0x87802074  ! 228: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeace000  ! 229: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xd6b40400  ! 230: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdea44400  ! 232: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd4a46000  ! 233: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd4b4e000  ! 234: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4a42000  ! 235: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	.word 0xd48ce000  ! 236: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r10
	.word 0xd2d44400  ! 237: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0xd2cf4e60  ! 238: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	mov	0x3f0, %r20
	.word 0xd28ca000  ! 240: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2f4a000  ! 241: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xdaa7ce40  ! 242: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	mov	0x7c8, %r23
	.word 0xdcdcc400  ! 244: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xd88d84a0  ! 245: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	mov	0x7f0, %r20
	.word 0xdccc2000  ! 247: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	mov	0x60, %r26
	mov	0x60, %r16
	.word 0xdca42000  ! 250: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 251: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2948400  ! 252: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	mov	0x7f8, %r20
	.word 0xdea40400  ! 254: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd49ca000  ! 255: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd097ce60  ! 256: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xda9c0400  ! 257: LDDA_R	ldda	[%r16, %r0] 0x20, %r13
	mov	0x28, %r18
	.word 0xd29c8400  ! 259: LDDA_R	ldda	[%r18, %r0] 0x20, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd8c40400  ! 261: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0x87802025  ! 262: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r20
	mov	0x58, %r19
	.word 0xdaf4e000  ! 265: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xd89fce40  ! 266: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0xd09f8e60  ! 267: LDDA_R	ldda	[%r30, %r0] 0x73, %r8
	.word 0xd2942000  ! 268: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2c4a000  ! 269: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	mov	0x7e8, %r22
	.word 0xd2cce000  ! 271: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd2ac2000  ! 272: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 273: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd69f8e40  ! 274: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	mov	0x30, %r27
	.word 0xdef6c9e0  ! 276: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xd6f7e000  ! 277: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xdac7ce60  ! 279: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r13
	.word 0xdeaf6000  ! 280: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd88c4400  ! 282: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd8a72000  ! 283: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8cfa000  ! 284: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r12
	mov	0x3c8, %r21
	.word 0xd88f6000  ! 286: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802074  ! 287: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ae89e0  ! 288: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 289: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r17
	.word 0xdcaec9e0  ! 291: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xd8bce000  ! 292: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd684c400  ! 293: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	mov	0x38, %r27
	.word 0xd2b70e80  ! 295: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0x87802074  ! 296: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 297: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 298: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r16
	.word 0xdcdca000  ! 300: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xdef70e60  ! 301: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xdcb584a0  ! 302: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	mov	0x3c8, %r23
	mov	0x7d8, %r20
	.word 0xd0d46000  ! 305: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0x87802020  ! 306: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebdc4a0  ! 307: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	mov	0x7e8, %r22
	.word 0xd2bf0e60  ! 309: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0xd8c78e60  ! 310: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	.word 0x87802020  ! 311: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdea584a0  ! 313: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	mov	0x30, %r18
	.word 0xd0df6000  ! 315: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0dfa000  ! 316: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0x87802072  ! 317: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a6e000  ! 318: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0f6a000  ! 319: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	.word 0xd0a4c400  ! 320: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	mov	0x8, %r25
	.word 0xd2c78e60  ! 322: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r9
	.word 0x87802020  ! 323: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89d44a0  ! 324: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	mov	0x58, %r25
	.word 0xd6f72000  ! 326: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd08649e0  ! 328: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	.word 0x87802074  ! 329: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r24
	mov	0x70, %r24
	.word 0x87802020  ! 332: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d7e000  ! 333: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 334: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6dfe000  ! 335: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0xd8ac0400  ! 336: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	mov	0x18, %r17
	.word 0xde9fe000  ! 338: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xd8af4e80  ! 339: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0x87802025  ! 340: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r17
	.word 0xd6bfe000  ! 342: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xd2a689e0  ! 344: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	mov	0x48, %r17
	mov	0x10, %r19
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdacdc4a0  ! 348: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	.word 0xdef7a000  ! 349: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdeaf6000  ! 350: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd6b78e40  ! 351: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xde9f8e40  ! 352: LDDA_R	ldda	[%r30, %r0] 0x72, %r15
	.word 0xd4df6000  ! 353: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 354: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x60, %r16
	mov	0x28, %r26
	.word 0x8780204f  ! 358: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b46000  ! 359: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xde9504a0  ! 360: LDUHA_R	lduha	[%r20, %r0] 0x25, %r15
	.word 0xda9ce000  ! 361: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xdad4a000  ! 362: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 363: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdaac6000  ! 364: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xdacca000  ! 365: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0x87802025  ! 366: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r17
	.word 0xd8bf4e80  ! 368: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xd0f504a0  ! 369: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xd6af8e40  ! 370: STBA_R	stba	%r11, [%r30 + %r0] 0x72
	.word 0xd4a7e000  ! 371: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 372: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ada000  ! 373: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0xd0cfce40  ! 374: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r8
	mov	0x7d8, %r20
	.word 0xd4bda000  ! 376: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0xd8c4c400  ! 377: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0x87802020  ! 378: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r17
	.word 0xd8de6000  ! 380: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r12
	.word 0xd4ccc400  ! 381: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd6de6000  ! 382: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r11
	.word 0xd6dee000  ! 383: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	.word 0xd4844400  ! 384: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0xdabf0e40  ! 385: STDA_R	stda	%r13, [%r28 + %r0] 0x72
	.word 0x87802072  ! 386: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 387: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca40400  ! 388: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd0d44400  ! 389: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0xd2f584a0  ! 390: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0xd68c4400  ! 391: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0x8780204f  ! 392: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bde000  ! 393: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	.word 0xd2b4c400  ! 394: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	mov	0x3f8, %r23
	.word 0xd0bf8e60  ! 396: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	.word 0xd29d6000  ! 397: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r9
	.word 0xd2bde000  ! 398: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 399: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a44400  ! 400: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd09f0e40  ! 401: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	mov	0x3c8, %r21
	.word 0x87802020  ! 403: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd687ce40  ! 404: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r11
	.word 0xd88fce60  ! 405: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	.word 0xd2a7a000  ! 406: STWA_I	stwa	%r9, [%r30 + 0x0000] %asi
	.word 0xd8cf8e80  ! 407: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r12
	.word 0xdab44400  ! 408: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xdef7a000  ! 409: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xde9f6000  ! 411: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0x87802072  ! 412: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde87e000  ! 413: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd2b48400  ! 414: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xdca504a0  ! 415: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xd49fce40  ! 416: LDDA_R	ldda	[%r31, %r0] 0x72, %r10
	.word 0xd4a4c400  ! 417: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xd6ae09e0  ! 418: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0xde974e60  ! 419: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	.word 0xdcaf4e40  ! 420: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0xdaa76000  ! 421: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xda97e000  ! 422: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xdadfe000  ! 423: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802073  ! 424: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e0, %r23
	.word 0xdab689e0  ! 426: STHA_R	stha	%r13, [%r26 + %r0] 0x4f
	.word 0xdcd4c400  ! 427: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0x87802025  ! 428: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r26
	.word 0x87802073  ! 430: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 431: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9c8400  ! 432: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	mov	0x10, %r25
	.word 0xd8df0e60  ! 434: LDXA_R	ldxa	[%r28, %r0] 0x73, %r12
	.word 0xd4c6c9e0  ! 435: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r10
	.word 0xdadc4400  ! 436: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xd29c0400  ! 437: LDDA_R	ldda	[%r16, %r0] 0x20, %r9
	.word 0xd2942000  ! 438: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2f42000  ! 439: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xd2bce000  ! 440: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 441: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 442: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cfe000  ! 443: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 444: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xda840400  ! 445: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	mov	0x20, %r17
	mov	0x7f0, %r23
	.word 0xd0cf4e80  ! 448: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	.word 0xde8f4e80  ! 449: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0xd4f72000  ! 450: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 451: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d5a000  ! 452: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	.word 0xd4ade000  ! 453: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	.word 0xd4ad2000  ! 454: STBA_I	stba	%r10, [%r20 + 0x0000] %asi
	.word 0xdcb74e60  ! 455: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0xd2be09e0  ! 456: STDA_R	stda	%r9, [%r24 + %r0] 0x4f
	.word 0xd2ad6000  ! 457: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd4adc4a0  ! 458: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	mov	0x3d0, %r20
	.word 0xdac48400  ! 460: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd68649e0  ! 461: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r11
	mov	0x3e8, %r23
	.word 0xdcb44400  ! 463: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xdab5a000  ! 464: STHA_I	stha	%r13, [%r22 + 0x0000] %asi
	.word 0xdaada000  ! 465: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	.word 0xde9c4400  ! 466: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	mov	0x18, %r17
	.word 0xd0dfce40  ! 468: LDXA_R	ldxa	[%r31, %r0] 0x72, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8856000  ! 470: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd4af4e60  ! 471: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	mov	0x3d8, %r20
	.word 0xd0bd84a0  ! 473: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd2ad6000  ! 474: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xdef40400  ! 475: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd89da000  ! 476: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r12
	mov	0x78, %r16
	.word 0xd4afce60  ! 478: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xd2c78e60  ! 479: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r9
	.word 0xd8a48400  ! 480: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xd0ad6000  ! 481: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0xd2bfce40  ! 482: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xd2ad6000  ! 483: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xdaa4c400  ! 484: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	mov	0x7c0, %r23
	.word 0xdec6c9e0  ! 486: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r15
	.word 0xdcbd2000  ! 487: STDA_I	stda	%r14, [%r20 + 0x0000] %asi
	.word 0xdc9d2000  ! 488: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r14
	mov	0x78, %r25
	.word 0xd09f4e60  ! 490: LDDA_R	ldda	[%r29, %r0] 0x73, %r8
	.word 0xde9e09e0  ! 491: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0x87802025  ! 492: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb42000  ! 493: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 494: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde87a000  ! 495: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdabd44a0  ! 496: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xd4b7a000  ! 497: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4cfe000  ! 498: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd8b70e40  ! 499: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xd69f2000  ! 500: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd4a7ce60  ! 501: STWA_R	stwa	%r10, [%r31 + %r0] 0x73
	.word 0xdeadc4a0  ! 502: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xd4d40400  ! 503: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xd28fe000  ! 504: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r9
	.word 0xdcbc0400  ! 505: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	mov	0x48, %r16
	.word 0xd4df8e60  ! 507: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0xd0bd44a0  ! 508: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xd0f72000  ! 509: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0bf2000  ! 510: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	.word 0xd6d70e60  ! 511: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0xd6b7a000  ! 512: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xd6afe000  ! 514: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x28, %r25
	.word 0xdaaf4e60  ! 516: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xd6b7a000  ! 517: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6d7e000  ! 518: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	mov	0x10, %r16
	.word 0x87802073  ! 520: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6cce000  ! 521: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	mov	0x0, %r24
	.word 0xd6f4e000  ! 523: STXA_I	stxa	%r11, [%r19 + 0x0000] %asi
	mov	0x38, %r26
	mov	0x78, %r27
	mov	0x30, %r24
	mov	0x30, %r17
	mov	0x38, %r19
	.word 0xd6cc6000  ! 529: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	mov	0x7f8, %r22
	.word 0xdc8c4400  ! 531: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xd097ce40  ! 532: LDUHA_R	lduha	[%r31, %r0] 0x72, %r8
	.word 0x87802025  ! 533: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcae89e0  ! 534: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xd8bf2000  ! 535: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xdeaf4e80  ! 536: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0xd8dc0400  ! 537: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	mov	0x7d0, %r22
	.word 0x87802020  ! 539: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28fa000  ! 540: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xd0b44400  ! 541: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xde97ce80  ! 542: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0xde8fa000  ! 543: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdcbd44a0  ! 544: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	.word 0xd2d7e000  ! 545: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2a7e000  ! 546: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x38, %r27
	.word 0xdea7ce80  ! 548: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	mov	0x3e0, %r23
	mov	0x50, %r27
	.word 0xd8bf2000  ! 551: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xdcbfce80  ! 553: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0xdecf2000  ! 554: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xd68d44a0  ! 555: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0x87802020  ! 556: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	.word 0xd4870e40  ! 558: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	.word 0xd8af2000  ! 559: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8d76000  ! 560: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xde9649e0  ! 561: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	.word 0xd8b44400  ! 562: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	mov	0x10, %r17
	.word 0xd2bcc400  ! 564: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xdcb70e60  ! 565: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xdcbf2000  ! 566: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 567: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 568: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b4c400  ! 569: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd4b649e0  ! 570: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xd2bd6000  ! 571: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xdea7ce60  ! 572: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	mov	0x68, %r25
	mov	0x3d0, %r20
	.word 0xd8978e80  ! 575: LDUHA_R	lduha	[%r30, %r0] 0x74, %r12
	.word 0x87802020  ! 576: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4cfa000  ! 577: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	mov	0x50, %r25
	.word 0xda8e49e0  ! 579: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r13
	.word 0xd897a000  ! 580: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 581: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	mov	0x3e8, %r21
	mov	0x68, %r26
	.word 0xd8af2000  ! 584: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x8, %r26
	.word 0xd28c4400  ! 586: LDUBA_R	lduba	[%r17, %r0] 0x20, %r9
	.word 0xd487a000  ! 587: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xda8504a0  ! 588: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r13
	.word 0xdabfa000  ! 589: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 590: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea5c4a0  ! 591: STWA_R	stwa	%r15, [%r23 + %r0] 0x25
	.word 0x87802020  ! 592: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r25
	.word 0xdeaf2000  ! 594: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdecc8400  ! 595: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xd4978e40  ! 596: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0xd487ce60  ! 597: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x78, %r19
	.word 0xd2bc0400  ! 600: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd4a649e0  ! 601: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	.word 0xdea76000  ! 602: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0x87802074  ! 604: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 605: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedd2000  ! 606: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r15
	mov	0x0, %r18
	.word 0x87802020  ! 608: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r23
	mov	0x70, %r25
	.word 0x87802072  ! 611: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4ce89e0  ! 612: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r10
	.word 0xdcb584a0  ! 613: STHA_R	stha	%r14, [%r22 + %r0] 0x25
	.word 0xd49ec9e0  ! 614: LDDA_R	ldda	[%r27, %r0] 0x4f, %r10
	.word 0xd8f584a0  ! 615: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0x87802074  ! 616: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ae2000  ! 617: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xdc95c4a0  ! 618: LDUHA_R	lduha	[%r23, %r0] 0x25, %r14
	.word 0xd6aea000  ! 619: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	.word 0x8780204f  ! 620: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6cfe000  ! 621: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6bfa000  ! 622: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6cf6000  ! 623: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6df6000  ! 624: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	mov	0x0, %r19
	.word 0xd6972000  ! 626: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xded689e0  ! 627: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r15
	.word 0xdc972000  ! 628: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xde848400  ! 629: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0x87802020  ! 630: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaf4e60  ! 631: STBA_R	stba	%r15, [%r29 + %r0] 0x73
	.word 0xd2dfe000  ! 632: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x70, %r16
	mov	0x28, %r18
	.word 0xd2bf6000  ! 635: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 636: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2bfce80  ! 637: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd6bc4400  ! 638: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xd48e89e0  ! 639: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	mov	0x3f0, %r20
	mov	0x0, %r19
	.word 0xd2840400  ! 642: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0xd48f8e60  ! 643: LDUBA_R	lduba	[%r30, %r0] 0x73, %r10
	.word 0x8780204f  ! 644: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8f6000  ! 645: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xdec7e000  ! 646: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4be49e0  ! 648: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	.word 0xd2bf4e80  ! 649: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	mov	0x68, %r27
	.word 0x87802020  ! 651: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 652: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb7a000  ! 653: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x30, %r17
	.word 0x87802073  ! 655: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r21
	.word 0xdeb72000  ! 657: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd8df4e80  ! 658: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	.word 0xd49f2000  ! 659: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4dfe000  ! 660: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd68c8400  ! 661: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xd8a689e0  ! 662: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0xd8b7ce40  ! 663: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd0bfa000  ! 664: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xd2f74e40  ! 666: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0xd2976000  ! 667: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd28504a0  ! 668: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	mov	0x18, %r24
	.word 0xdad40400  ! 670: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	mov	0x48, %r17
	.word 0xdcaf2000  ! 672: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xd4c504a0  ! 673: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	.word 0xdeafce60  ! 674: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0x87802072  ! 675: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r19
	.word 0xd0a544a0  ! 677: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xdaac2000  ! 678: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 679: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf46000  ! 680: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 681: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2dc8400  ! 682: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xdcc78e40  ! 683: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r14
	.word 0xdec689e0  ! 684: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r15
	.word 0xd0c584a0  ! 685: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r8
	mov	0x7f8, %r20
	.word 0xd0d74e80  ! 687: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r8
	.word 0xdef74e80  ! 688: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0xd2852000  ! 689: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r9
	.word 0xdaa78e40  ! 690: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	mov	0x3f8, %r22
	.word 0xd49d2000  ! 692: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r10
	.word 0xdcc544a0  ! 693: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r14
	.word 0x87802073  ! 694: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 695: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68f8e80  ! 696: LDUBA_R	lduba	[%r30, %r0] 0x74, %r11
	.word 0xdcb4e000  ! 697: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xd6840400  ! 698: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd8ace000  ! 699: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 700: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08fce80  ! 701: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	mov	0x3f0, %r23
	.word 0xdec504a0  ! 703: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r15
	.word 0xd4d7e000  ! 704: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4f7a000  ! 705: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a7a000  ! 706: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xdaf78e80  ! 707: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xd4a72000  ! 708: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 709: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r19
	.word 0xd4d72000  ! 711: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xda840400  ! 712: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	mov	0x20, %r27
	.word 0xdebf0e60  ! 714: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdcb7e000  ! 715: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 716: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf4a000  ! 717: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	mov	0x18, %r16
	mov	0x28, %r24
	.word 0xdcf46000  ! 720: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcac2000  ! 721: STBA_I	stba	%r14, [%r16 + 0x0000] %asi
	.word 0xd69c8400  ! 722: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xdad46000  ! 723: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xda8ce000  ! 724: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0x87802073  ! 725: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd48c4400  ! 726: LDUBA_R	lduba	[%r17, %r0] 0x20, %r10
	mov	0x70, %r16
	.word 0xd6952000  ! 728: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0xd6dd6000  ! 729: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r11
	.word 0xd6d5a000  ! 730: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r11
	.word 0xdcb44400  ! 731: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xdaa504a0  ! 732: STWA_R	stwa	%r13, [%r20 + %r0] 0x25
	.word 0xd8b4c400  ! 733: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 734: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49e89e0  ! 735: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	.word 0xdcbc2000  ! 736: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdc8ce000  ! 737: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0x87802025  ! 738: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r19
	.word 0xdeb7ce60  ! 740: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xde952000  ! 741: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r15
	.word 0xde95e000  ! 742: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r15
	.word 0xdebd6000  ! 743: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xdec5a000  ! 745: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r15
	mov	0x7d0, %r21
	.word 0x87802073  ! 747: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r27
	.word 0xd4948400  ! 749: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	mov	0x58, %r26
	.word 0xdebda000  ! 751: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xdebd6000  ! 752: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 753: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbe09e0  ! 754: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	mov	0x3f8, %r21
	.word 0xdeaf2000  ! 756: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdea76000  ! 757: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xde87e000  ! 758: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdef7a000  ! 759: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdcf70e40  ! 760: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xd8afa000  ! 761: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 762: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd88de000  ! 763: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r12
	.word 0xdea4c400  ! 764: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x0, %r24
	mov	0x70, %r19
	mov	0x78, %r17
	.word 0xdeaf4e40  ! 768: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0xd6bd6000  ! 769: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	mov	0x7f0, %r20
	mov	0x38, %r19
	.word 0xdc844400  ! 772: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xd8d74e60  ! 773: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r12
	.word 0x8780204f  ! 774: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2af4e80  ! 775: STBA_R	stba	%r9, [%r29 + %r0] 0x74
	.word 0xd8b46000  ! 776: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xd6af8e80  ! 777: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0xd2ac6000  ! 778: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 779: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdece89e0  ! 780: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	.word 0xd4bf6000  ! 781: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd49f4e60  ! 782: LDDA_R	ldda	[%r29, %r0] 0x73, %r10
	.word 0xd0a78e60  ! 783: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	.word 0xd8f44400  ! 784: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	mov	0x8, %r25
	.word 0xd89fce40  ! 786: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0xd6cf4e80  ! 787: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r11
	.word 0xdca7a000  ! 788: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbf4e40  ! 789: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xd4a76000  ! 790: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd2bfce40  ! 791: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xde8fe000  ! 792: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802074  ! 793: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 794: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef66000  ! 795: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	.word 0xdaf689e0  ! 796: STXA_R	stxa	%r13, [%r26 + %r0] 0x4f
	.word 0xdcb6e000  ! 797: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 798: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde974e80  ! 799: LDUHA_R	lduha	[%r29, %r0] 0x74, %r15
	mov	0x20, %r24
	mov	0x3d0, %r20
	.word 0xdcdce000  ! 802: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xdcb48400  ! 803: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd4f4e000  ! 804: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	mov	0x70, %r26
	mov	0x58, %r24
	.word 0xd89504a0  ! 807: LDUHA_R	lduha	[%r20, %r0] 0x25, %r12
	mov	0x10, %r26
	mov	0x3c8, %r20
	.word 0xd0b78e80  ! 810: STHA_R	stha	%r8, [%r30 + %r0] 0x74
	.word 0xdaa78e80  ! 811: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	mov	0x10, %r16
	.word 0xde9544a0  ! 813: LDUHA_R	lduha	[%r21, %r0] 0x25, %r15
	.word 0xd2f4a000  ! 814: STXA_I	stxa	%r9, [%r18 + 0x0000] %asi
	.word 0xd2f42000  ! 815: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 816: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dc0400  ! 817: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd0cea000  ! 818: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r8
	.word 0xd0f6e000  ! 819: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0962000  ! 820: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0x87802074  ! 821: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ace000  ! 822: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd0f42000  ! 823: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0f4e000  ! 824: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0946000  ! 825: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd4df4e80  ! 826: LDXA_R	ldxa	[%r29, %r0] 0x74, %r10
	mov	0x18, %r18
	mov	0x18, %r16
	.word 0xd8d4a000  ! 829: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	mov	0x30, %r25
	.word 0x87802020  ! 831: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r20
	.word 0xd2d7ce80  ! 833: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0xdadfa000  ! 834: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xdac609e0  ! 835: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	mov	0x60, %r16
	.word 0xd6bd84a0  ! 837: STDA_R	stda	%r11, [%r22 + %r0] 0x25
	.word 0xd4df6000  ! 838: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xdc9689e0  ! 839: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r14
	mov	0x7d0, %r20
	mov	0x58, %r26
	.word 0xd4afa000  ! 842: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 843: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4df0e40  ! 844: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	mov	0x60, %r18
	mov	0x60, %r17
	.word 0xd6ace000  ! 847: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd6a46000  ! 848: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 849: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6966000  ! 850: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	.word 0x87802073  ! 851: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bf2000  ! 852: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd2b5c4a0  ! 854: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	mov	0x8, %r19
	.word 0xdad7a000  ! 856: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 857: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 858: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28d04a0  ! 859: LDUBA_R	lduba	[%r20, %r0] 0x25, %r9
	.word 0xd2a70e40  ! 860: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xd8dfa000  ! 861: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802020  ! 862: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f7e000  ! 863: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xdcb40400  ! 864: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	mov	0x8, %r16
	.word 0xd49f2000  ! 866: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	mov	0x8, %r19
	.word 0x8780204f  ! 868: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6dc4400  ! 869: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd8a44400  ! 870: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xd6cf6000  ! 871: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 872: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6c42000  ! 873: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r11
	mov	0x58, %r19
	mov	0x7c8, %r21
	mov	0x7c0, %r20
	.word 0xd4b584a0  ! 877: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0xd4bc6000  ! 878: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd4f42000  ! 879: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	.word 0xd49c6000  ! 880: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xd4a4a000  ! 881: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd0b609e0  ! 882: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 883: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xded7a000  ! 884: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x3d8, %r21
	.word 0xde9fe000  ! 886: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xdeb7e000  ! 887: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdecf6000  ! 888: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xd6b544a0  ! 889: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0x87802072  ! 890: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 891: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdad40400  ! 892: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xd2b4a000  ! 893: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2a649e0  ! 894: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	.word 0xd4b4e000  ! 895: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4dc6000  ! 896: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	mov	0x78, %r18
	.word 0xd4d4e000  ! 898: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd29d04a0  ! 899: LDDA_R	ldda	[%r20, %r0] 0x25, %r9
	.word 0xd6b544a0  ! 900: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xd4dc8400  ! 901: LDXA_R	ldxa	[%r18, %r0] 0x20, %r10
	.word 0xd69ce000  ! 902: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r11
	.word 0xd6a42000  ! 903: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 904: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 905: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3f0, %r20
	.word 0xd6b6e000  ! 907: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	.word 0xd4a48400  ! 908: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0x87802073  ! 909: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda872000  ! 910: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xdeac8400  ! 911: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0x87802020  ! 912: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r27
	.word 0xdc8ce000  ! 914: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xdaa6c9e0  ! 915: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	.word 0xd4c4e000  ! 916: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	.word 0xd8cec9e0  ! 917: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	.word 0xd8af0e80  ! 918: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0xdec4c400  ! 919: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r15
	.word 0xd8f4a000  ! 920: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd89ca000  ! 921: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	mov	0x3f8, %r20
	.word 0xd8bca000  ! 923: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8ace000  ! 924: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xd8b46000  ! 926: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 927: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d76000  ! 928: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8c7e000  ! 929: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8df2000  ! 930: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	mov	0x7d8, %r21
	.word 0xd2f7ce40  ! 932: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0xdabf2000  ! 933: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 934: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca70e40  ! 935: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	.word 0xd0bf8e40  ! 936: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	mov	0x40, %r19
	.word 0x87802074  ! 938: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd89c8400  ! 939: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	mov	0x48, %r16
	.word 0xd4bcc400  ! 941: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd8bda000  ! 942: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd2878e60  ! 943: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r9
	.word 0xd0dd2000  ! 944: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0d5e000  ! 945: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r8
	.word 0xd0d5e000  ! 946: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r8
	.word 0xd0a56000  ! 947: STWA_I	stwa	%r8, [%r21 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd09d6000  ! 949: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0xd08de000  ! 950: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r8
	mov	0x3e8, %r20
	.word 0xda874e80  ! 952: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	.word 0x87802020  ! 953: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdacdc4a0  ! 954: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	.word 0xd2b72000  ! 955: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 956: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 957: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca74e40  ! 958: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xdcb649e0  ! 959: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xdabca000  ! 960: STDA_I	stda	%r13, [%r18 + 0x0000] %asi
	.word 0xd0de09e0  ! 961: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r8
	mov	0x18, %r25
	.word 0x87802020  ! 963: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r17
	.word 0xd0dd2000  ! 965: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd095a000  ! 966: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0xd0b70e60  ! 967: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0x87802020  ! 968: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r21
	.word 0xd4d40400  ! 970: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xde9f0e80  ! 971: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	.word 0xd487a000  ! 972: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd09c0400  ! 973: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0xde8689e0  ! 974: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0xd69c0400  ! 975: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xd4cd84a0  ! 976: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	.word 0xd2b44400  ! 977: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd4a48400  ! 978: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd4af4e80  ! 979: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0xd2bfa000  ! 980: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd0acc400  ! 981: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 982: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bfa000  ! 983: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6cfe000  ! 984: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6bf2000  ! 985: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x18, %r25
	.word 0x87802073  ! 987: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb6c9e0  ! 988: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xdcc4a000  ! 989: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0x87802020  ! 990: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r23
	mov	0x3e8, %r23
	.word 0xdcb5a000  ! 993: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0xdc9f8e60  ! 994: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	mov	0x30, %r18
	mov	0x3e8, %r20
	mov	0x7f8, %r22
	.word 0x87802020  ! 998: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f48400  ! 999: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd0c5a000  ! 1000: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r8
	.word 0xd085a000  ! 1001: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r8
	.word 0x87802020  ! 1002: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08ee000  ! 1003: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r8
	.word 0xd2dfce60  ! 1004: LDXA_R	ldxa	[%r31, %r0] 0x73, %r9
	mov	0x3f0, %r20
	.word 0xd4ae2000  ! 1006: STBA_I	stba	%r10, [%r24 + 0x0000] %asi
	.word 0xdadf8e80  ! 1007: LDXA_R	ldxa	[%r30, %r0] 0x74, %r13
	.word 0xdef70e80  ! 1008: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	.word 0xdcaee000  ! 1009: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0xdcf66000  ! 1010: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	.word 0xdcaea000  ! 1011: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdcdfce60  ! 1012: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	mov	0x3c8, %r21
	.word 0xd886e000  ! 1014: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd897ce60  ! 1015: LDUHA_R	lduha	[%r31, %r0] 0x73, %r12
	mov	0x8, %r19
	mov	0x50, %r24
	.word 0x87802074  ! 1018: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd887ce40  ! 1019: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	.word 0xd68c2000  ! 1020: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	.word 0xd8af8e60  ! 1021: STBA_R	stba	%r12, [%r30 + %r0] 0x73
	mov	0x50, %r27
	.word 0xdec4a000  ! 1023: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xd4cfce40  ! 1024: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r10
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 1026: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c7a000  ! 1027: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xdaa78e40  ! 1028: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0x87802020  ! 1029: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec74e80  ! 1030: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r15
	.word 0xd69fce80  ! 1031: LDDA_R	ldda	[%r31, %r0] 0x74, %r11
	.word 0xdad56000  ! 1032: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1033: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88d04a0  ! 1034: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	mov	0x38, %r27
	mov	0x40, %r18
	.word 0xd2942000  ! 1037: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xdaafce40  ! 1038: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0xd8bca000  ! 1039: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8c42000  ! 1040: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x78, %r16
	.word 0x87802072  ! 1042: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd886a000  ! 1043: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r12
	mov	0x28, %r18
	.word 0xd8ae2000  ! 1045: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd087ce60  ! 1046: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r8
	.word 0xd2c48400  ! 1047: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xd6be2000  ! 1048: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd2bfce40  ! 1050: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0x87802073  ! 1051: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r17
	.word 0xdcd74e80  ! 1053: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r14
	.word 0x87802072  ! 1054: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdede09e0  ! 1055: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	.word 0x87802020  ! 1056: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c40400  ! 1057: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd8c42000  ! 1058: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x70, %r27
	mov	0x7f8, %r21
	ta	T_CHANGE_PRIV	! macro
	.word 0xdcdcc400  ! 1062: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xd2aca000  ! 1063: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0xd28c6000  ! 1064: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xdec6c9e0  ! 1065: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r15
	mov	0x8, %r18
	.word 0xd6aca000  ! 1067: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 1068: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r25
	.word 0xd696a000  ! 1070: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xd6be2000  ! 1071: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xdebf8e80  ! 1073: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	.word 0xd6ce6000  ! 1074: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r11
	.word 0xdeb74e40  ! 1075: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xdadf4e60  ! 1076: LDXA_R	ldxa	[%r29, %r0] 0x73, %r13
	.word 0xd0d62000  ! 1077: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r8
	mov	0x68, %r16
	.word 0xd6974e60  ! 1079: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	.word 0x87802025  ! 1080: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4f76000  ! 1081: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bf6000  ! 1082: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd2ac0400  ! 1083: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xda9f2000  ! 1084: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xd2a70e40  ! 1085: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	mov	0x60, %r24
	.word 0x87802020  ! 1087: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r21
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2be6000  ! 1090: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2de2000  ! 1091: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdadf4e60  ! 1093: LDXA_R	ldxa	[%r29, %r0] 0x73, %r13
	.word 0xdc86a000  ! 1094: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	.word 0xdcb66000  ! 1095: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	.word 0xdcd66000  ! 1096: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r14
	.word 0xdcbe2000  ! 1097: STDA_I	stda	%r14, [%r24 + 0x0000] %asi
	.word 0xd8de09e0  ! 1098: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0xd6b70e40  ! 1099: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0xdef4c400  ! 1100: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd684c400  ! 1101: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	.word 0xd0dd04a0  ! 1102: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	.word 0xd08fce40  ! 1103: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	.word 0xdcb6e000  ! 1104: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0xdc8ea000  ! 1105: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	mov	0x18, %r26
	.word 0xd0dc4400  ! 1107: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0xdabea000  ! 1108: STDA_I	stda	%r13, [%r26 + 0x0000] %asi
	.word 0xd69c4400  ! 1109: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	mov	0x8, %r17
	.word 0xd8d4c400  ! 1111: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r12
	.word 0xdccf8e60  ! 1112: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r14
	.word 0xd8ce6000  ! 1113: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r12
	.word 0xd89ea000  ! 1114: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 1115: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd897ce40  ! 1116: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	.word 0xd4bf2000  ! 1117: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd49fa000  ! 1118: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd0a689e0  ! 1119: STWA_R	stwa	%r8, [%r26 + %r0] 0x4f
	mov	0x58, %r18
	mov	0x7e0, %r20
	.word 0xd4872000  ! 1122: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd08dc4a0  ! 1123: LDUBA_R	lduba	[%r23, %r0] 0x25, %r8
	.word 0xdc97e000  ! 1124: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	.word 0xdc97e000  ! 1125: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r14
	mov	0x7c8, %r20
	.word 0xdcb40400  ! 1127: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xd0c78e80  ! 1128: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r8
	.word 0xd6b5c4a0  ! 1129: STHA_R	stha	%r11, [%r23 + %r0] 0x25
	mov	0x38, %r19
	mov	0x60, %r16
	.word 0xde8fa000  ! 1132: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xd4bf8e80  ! 1133: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0xdec76000  ! 1134: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd0b70e40  ! 1135: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xdeafa000  ! 1136: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd8f689e0  ! 1137: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0x87802072  ! 1138: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1139: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a7e000  ! 1140: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xd68fe000  ! 1142: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	mov	0x30, %r19
	.word 0xd6bfa000  ! 1144: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd6df6000  ! 1145: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6f7e000  ! 1146: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd2c40400  ! 1147: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	.word 0xd8b7a000  ! 1148: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xda85c4a0  ! 1149: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r13
	.word 0xd8d72000  ! 1150: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8af2000  ! 1151: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd8a7e000  ! 1153: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8c72000  ! 1154: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bf6000  ! 1155: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd89f4e40  ! 1156: LDDA_R	ldda	[%r29, %r0] 0x72, %r12
	.word 0xdef7ce60  ! 1157: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 1158: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d42000  ! 1159: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 1160: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8dfe000  ! 1161: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xdaf4c400  ! 1162: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdab72000  ! 1163: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1164: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r23
	mov	0x48, %r25
	.word 0xdabf2000  ! 1167: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xd29fce40  ! 1169: LDDA_R	ldda	[%r31, %r0] 0x72, %r9
	.word 0x87802074  ! 1170: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6842000  ! 1171: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6bc6000  ! 1172: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd6b4e000  ! 1173: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd6a46000  ! 1174: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xdaf6c9e0  ! 1176: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0xd0a42000  ! 1177: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 1178: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08c2000  ! 1179: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0f4a000  ! 1180: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	mov	0x50, %r26
	mov	0x40, %r16
	.word 0x87802020  ! 1183: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1184: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda840400  ! 1185: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	.word 0xdc9609e0  ! 1186: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r14
	.word 0xd6b66000  ! 1187: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	.word 0xd88f4e40  ! 1188: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	mov	0x10, %r27
	.word 0xd8af8e40  ! 1190: STBA_R	stba	%r12, [%r30 + %r0] 0x72
	.word 0xd0df8e40  ! 1191: LDXA_R	ldxa	[%r30, %r0] 0x72, %r8
	.word 0xdab6a000  ! 1192: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 1193: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r22
	.word 0xd6cd44a0  ! 1195: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r11
	mov	0x3c8, %r22
	.word 0x8780204f  ! 1197: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a7ce60  ! 1198: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	mov	0x0, %r16
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 1201: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0a4e000  ! 1202: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0c4a000  ! 1203: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0cc2000  ! 1204: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	mov	0x3e8, %r21
	.word 0xd0946000  ! 1206: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd88f0e40  ! 1207: LDUBA_R	lduba	[%r28, %r0] 0x72, %r12
	.word 0xd8f78e80  ! 1208: STXA_R	stxa	%r12, [%r30 + %r0] 0x74
	mov	0x68, %r24
	mov	0x3d0, %r20
	.word 0x87802073  ! 1211: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af0e40  ! 1212: STBA_R	stba	%r9, [%r28 + %r0] 0x72
	.word 0xd8bfe000  ! 1213: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd6cc4400  ! 1214: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r11
	.word 0xd2d48400  ! 1215: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd4afa000  ! 1216: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xdaa689e0  ! 1217: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xd4bfce80  ! 1218: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	ta	T_CHANGE_HPRIV	! macro
	.word 0xde8f2000  ! 1220: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1221: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef56000  ! 1222: STXA_I	stxa	%r15, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 1223: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde84e000  ! 1224: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	mov	0x30, %r16
	.word 0x87802074  ! 1226: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r26
	mov	0x40, %r25
	mov	0x50, %r16
	.word 0xda8d84a0  ! 1230: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0xdca7a000  ! 1231: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xd8f7ce60  ! 1232: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0x87802074  ! 1233: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1234: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbfe000  ! 1235: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xd4ac8400  ! 1236: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0x87802073  ! 1237: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bfce60  ! 1238: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	mov	0x78, %r16
	.word 0x87802025  ! 1240: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6d46000  ! 1241: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r11
	.word 0xd0f649e0  ! 1242: STXA_R	stxa	%r8, [%r25 + %r0] 0x4f
	mov	0x7d0, %r21
	.word 0xd0f4e000  ! 1244: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1245: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd097a000  ! 1246: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd4878e60  ! 1247: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r10
	.word 0xde9f6000  ! 1248: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xde8fe000  ! 1249: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1250: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	mov	0x20, %r18
	.word 0x87802025  ! 1253: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4de49e0  ! 1254: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r10
	mov	0x28, %r19
	ta	T_CHANGE_HPRIV	! macro
	mov	0x30, %r27
	.word 0xdc9cc400  ! 1258: LDDA_R	ldda	[%r19, %r0] 0x20, %r14
	.word 0xd2af6000  ! 1259: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	mov	0x58, %r18
	mov	0x60, %r27
	mov	0x3c0, %r22
	.word 0xd2bf6000  ! 1263: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b76000  ! 1264: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd8bc0400  ! 1265: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xd4bf8e60  ! 1266: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	mov	0x7e8, %r23
	.word 0xd8bf6000  ! 1268: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd4c70e80  ! 1269: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	mov	0x60, %r26
	.word 0xd6bf2000  ! 1271: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x60, %r17
	mov	0x70, %r24
	mov	0x3c8, %r22
	mov	0x8, %r24
	.word 0xd4d544a0  ! 1276: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xd69fe000  ! 1277: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 1278: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6f72000  ! 1279: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1280: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1281: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bca000  ! 1282: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 1283: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8649e0  ! 1284: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	mov	0x70, %r18
	.word 0x87802020  ! 1286: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bfa000  ! 1287: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4972000  ! 1288: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xda878e40  ! 1289: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0xd4bfe000  ! 1290: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	mov	0x60, %r17
	.word 0x87802073  ! 1292: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49fe000  ! 1293: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0x87802025  ! 1294: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb4c400  ! 1295: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdcf56000  ! 1296: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 1297: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4af0e80  ! 1298: STBA_R	stba	%r10, [%r28 + %r0] 0x74
	.word 0xd4ac0400  ! 1299: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd6c56000  ! 1300: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r11
	.word 0xd2f44400  ! 1301: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	mov	0x30, %r17
	.word 0xd4f5e000  ! 1303: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	.word 0x87802072  ! 1304: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0cf8e60  ! 1305: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0xde97a000  ! 1306: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	mov	0x3d0, %r23
	mov	0x70, %r16
	.word 0xd0ac0400  ! 1309: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xdef7e000  ! 1310: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x3e0, %r23
	mov	0x3d8, %r21
	.word 0xdea7a000  ! 1313: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdec6c9e0  ! 1314: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r15
	.word 0xdea78e40  ! 1315: STWA_R	stwa	%r15, [%r30 + %r0] 0x72
	.word 0xd6bfe000  ! 1316: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd68c0400  ! 1317: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	mov	0x48, %r16
	.word 0x8780204f  ! 1319: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1320: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdedf6000  ! 1321: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x7c8, %r23
	.word 0xda9c0400  ! 1323: LDDA_R	ldda	[%r16, %r0] 0x20, %r13
	.word 0xd8f44400  ! 1324: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	ta	T_CHANGE_PRIV	! macro
	.word 0xdaafce40  ! 1326: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0xd0a76000  ! 1327: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xdad609e0  ! 1328: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r13
	.word 0xdcb7e000  ! 1329: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xd2f74e80  ! 1330: STXA_R	stxa	%r9, [%r29 + %r0] 0x74
	.word 0xd88fa000  ! 1331: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd2d78e60  ! 1332: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r9
	mov	0x0, %r19
	.word 0xdedfe000  ! 1334: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0x87802074  ! 1335: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef7e000  ! 1336: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd68fce80  ! 1337: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	.word 0xd0af4e40  ! 1338: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	.word 0xd48ec9e0  ! 1339: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r10
	mov	0x8, %r26
	.word 0x87802020  ! 1341: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde84e000  ! 1342: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	mov	0x70, %r18
	mov	0x60, %r18
	.word 0xdea4e000  ! 1345: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdecce000  ! 1346: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	mov	0x7d0, %r22
	mov	0x70, %r17
	mov	0x7e8, %r21
	.word 0xda874e80  ! 1350: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	.word 0xd0f42000  ! 1351: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1352: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r25
	.word 0x87802073  ! 1354: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r18
	.word 0xdabe89e0  ! 1356: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0x8780204f  ! 1357: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a48400  ! 1358: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x18, %r16
	.word 0x87802074  ! 1360: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b5a000  ! 1361: STHA_I	stha	%r9, [%r22 + 0x0000] %asi
	mov	0x18, %r16
	.word 0x87802020  ! 1363: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r19
	.word 0xd29f2000  ! 1365: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0x87802025  ! 1366: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f76000  ! 1367: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1368: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1369: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r22
	.word 0xd29fa000  ! 1371: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xded40400  ! 1372: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd8c48400  ! 1373: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xdedf4e40  ! 1374: LDXA_R	ldxa	[%r29, %r0] 0x72, %r15
	.word 0x87802020  ! 1375: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcad84a0  ! 1376: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xd08fe000  ! 1377: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xdc9c8400  ! 1378: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	.word 0xd2dc8400  ! 1379: LDXA_R	ldxa	[%r18, %r0] 0x20, %r9
	.word 0xd8bfa000  ! 1380: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd6a649e0  ! 1381: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	mov	0x7f8, %r23
	.word 0xd29fa000  ! 1383: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd29fe000  ! 1384: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 1385: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	mov	0x28, %r17
	.word 0xd2976000  ! 1387: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bfe000  ! 1388: STDA_I	stda	%r9, [%r31 + 0x0000] %asi
	.word 0xd2f7a000  ! 1389: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x8, %r17
	mov	0x10, %r24
	mov	0x8, %r18
	.word 0x8780204f  ! 1393: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2d7e000  ! 1394: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x40, %r16
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2bf6000  ! 1397: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd2f76000  ! 1399: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xdeb74e60  ! 1400: STHA_R	stha	%r15, [%r29 + %r0] 0x73
	.word 0xd2bf0e40  ! 1401: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	mov	0x18, %r17
	mov	0x60, %r24
	.word 0xd6bfe000  ! 1404: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xdef44400  ! 1405: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd8d6c9e0  ! 1406: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0xd4cec9e0  ! 1407: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r10
	.word 0xd287a000  ! 1408: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2afe000  ! 1409: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd28f2000  ! 1410: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1411: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2bce000  ! 1412: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd8af8e80  ! 1413: STBA_R	stba	%r12, [%r30 + %r0] 0x74
	.word 0xd49d04a0  ! 1414: LDDA_R	ldda	[%r20, %r0] 0x25, %r10
	.word 0xd89c2000  ! 1415: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd8846000  ! 1416: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8f42000  ! 1417: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8d4e000  ! 1418: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8ac6000  ! 1419: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd8ac2000  ! 1420: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd4b584a0  ! 1421: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	mov	0x38, %r19
	.word 0xdebf8e80  ! 1423: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	.word 0xd2b4c400  ! 1424: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xdab5c4a0  ! 1425: STHA_R	stha	%r13, [%r23 + %r0] 0x25
	mov	0x7c0, %r23
	.word 0xdc95c4a0  ! 1427: LDUHA_R	lduha	[%r23, %r0] 0x25, %r14
	.word 0xd4a584a0  ! 1428: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	mov	0x30, %r26
	.word 0xde8c2000  ! 1430: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	mov	0x0, %r18
	.word 0xdaf74e40  ! 1432: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	mov	0x3f0, %r22
	.word 0xd8870e60  ! 1434: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	.word 0xd8f70e60  ! 1435: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	mov	0x18, %r25
	.word 0xd8946000  ! 1437: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8dc2000  ! 1438: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8cce000  ! 1439: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	.word 0xde878e40  ! 1440: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	.word 0xdcc46000  ! 1441: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcf46000  ! 1442: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0x8780204f  ! 1444: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1445: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f70e40  ! 1446: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	mov	0x18, %r19
	.word 0xd8ad44a0  ! 1448: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0x87802020  ! 1449: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dc2000  ! 1450: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r9
	mov	0x3f8, %r22
	.word 0x87802074  ! 1452: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdac544a0  ! 1453: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r13
	.word 0xdeac6000  ! 1454: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdeb46000  ! 1455: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	mov	0x78, %r17
	.word 0xde8c2000  ! 1457: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1458: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6940400  ! 1459: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xde95a000  ! 1460: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r15
	.word 0xd08e09e0  ! 1461: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	.word 0xdaf56000  ! 1462: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xda9da000  ! 1463: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r13
	.word 0xda85a000  ! 1464: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	.word 0xd6ce09e0  ! 1465: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	mov	0x7f8, %r22
	mov	0x58, %r18
	.word 0x87802073  ! 1468: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1469: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbf2000  ! 1470: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdca72000  ! 1471: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd6c48400  ! 1473: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	mov	0x58, %r17
	.word 0xdc9f8e60  ! 1475: LDDA_R	ldda	[%r30, %r0] 0x73, %r14
	.word 0xd6bfa000  ! 1476: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	mov	0x7f0, %r21
	mov	0x60, %r27
	.word 0xd6a6c9e0  ! 1479: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0xde8f2000  ! 1480: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	mov	0x7d8, %r23
	.word 0xdedfa000  ! 1482: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xd0be89e0  ! 1483: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd4bc4400  ! 1484: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	mov	0x50, %r27
	mov	0x7e8, %r22
	mov	0x60, %r18
	.word 0xda9f2000  ! 1488: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xd89c8400  ! 1489: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	.word 0xdebf4e60  ! 1490: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xdcdfce60  ! 1491: LDXA_R	ldxa	[%r31, %r0] 0x73, %r14
	mov	0x3e8, %r20
	.word 0xd8aec9e0  ! 1493: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xd6b48400  ! 1494: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd8f7a000  ! 1495: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8df6000  ! 1496: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	mov	0x30, %r18
	.word 0x87802020  ! 1498: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88d6000  ! 1499: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	.word 0xd8c5e000  ! 1500: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r12
	.word 0xd8dd2000  ! 1501: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r12
	.word 0xd2844400  ! 1502: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0x87802020  ! 1503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4944400  ! 1504: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	ta	T_CHANGE_PRIV	! macro
	mov	0x7c0, %r23
	.word 0xda87e000  ! 1507: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda942000  ! 1509: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdabc2000  ! 1510: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdaace000  ! 1511: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xdaa42000  ! 1512: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 1513: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdac504a0  ! 1514: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r13
	.word 0xdef7ce80  ! 1515: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	.word 0xd8af6000  ! 1516: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd8bf2000  ! 1517: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd897e000  ! 1518: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8b7a000  ! 1519: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1520: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cce000  ! 1521: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	mov	0x7c8, %r23
	.word 0xd8b4a000  ! 1523: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd8ac2000  ! 1524: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd8f4a000  ! 1525: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd0f40400  ! 1526: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd0ace000  ! 1527: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xd0bce000  ! 1529: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd0ace000  ! 1531: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd094e000  ! 1532: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0b42000  ! 1533: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd0dce000  ! 1534: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0bc6000  ! 1535: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x3e8, %r22
	mov	0x40, %r25
	.word 0xd2a48400  ! 1538: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x20, %r19
	.word 0xdeae89e0  ! 1540: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 1541: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29f0e60  ! 1542: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0xd4cc8400  ! 1543: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	.word 0xd2ade000  ! 1544: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 1545: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc48400  ! 1546: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	.word 0xd2de49e0  ! 1547: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0xd49fce80  ! 1548: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	.word 0x8780204f  ! 1549: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa76000  ! 1550: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdac74e80  ! 1551: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r13
	.word 0xdedfa000  ! 1552: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xded7e000  ! 1553: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1554: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebf8e40  ! 1555: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xd8af0e60  ! 1556: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	mov	0x50, %r25
	.word 0xda9de000  ! 1558: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xdaf5e000  ! 1559: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xd09dc4a0  ! 1560: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xd6cdc4a0  ! 1561: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r11
	.word 0xd0c609e0  ! 1562: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r8
	mov	0x28, %r17
	.word 0xd2af0e60  ! 1564: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xd6cd6000  ! 1565: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	.word 0xded78e40  ! 1566: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r15
	.word 0xd4d52000  ! 1567: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x40, %r25
	.word 0xd4a5a000  ! 1570: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0xdeb70e80  ! 1571: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0x8780204f  ! 1572: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1573: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c8, %r23
	mov	0x60, %r27
	.word 0x87802073  ! 1576: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdab4a000  ! 1577: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xdac42000  ! 1578: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	mov	0x28, %r18
	mov	0x50, %r19
	mov	0x48, %r17
	.word 0xda84a000  ! 1582: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1583: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8da000  ! 1584: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xda8f0e40  ! 1585: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	mov	0x3f0, %r20
	.word 0xd8c56000  ! 1587: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1588: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1589: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b76000  ! 1590: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd8dfe000  ! 1591: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xdebfce60  ! 1592: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0xd6b72000  ! 1593: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a7e000  ! 1594: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1595: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a42000  ! 1596: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xd4ccc400  ! 1598: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0xd0acc400  ! 1599: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	.word 0x8780204f  ! 1601: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc874e60  ! 1602: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r14
	.word 0xd28d84a0  ! 1603: LDUBA_R	lduba	[%r22, %r0] 0x25, %r9
	.word 0xdad40400  ! 1604: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xdedd84a0  ! 1605: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	.word 0xdc842000  ! 1606: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	mov	0x30, %r17
	mov	0x8, %r19
	.word 0xd0af8e80  ! 1609: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	mov	0x78, %r19
	.word 0xd6b40400  ! 1611: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd09f4e40  ! 1612: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	.word 0xd8acc400  ! 1613: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1614: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r18
	.word 0xdcbc6000  ! 1616: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdea70e80  ! 1617: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0xdcf46000  ! 1618: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcd7ce40  ! 1619: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0xdcb4a000  ! 1620: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdca42000  ! 1621: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xdc842000  ! 1623: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	mov	0x58, %r27
	.word 0x87802072  ! 1625: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcce6000  ! 1626: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	mov	0x3f8, %r22
	mov	0x7f8, %r20
	.word 0x87802072  ! 1629: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcce2000  ! 1630: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r14
	.word 0xd2874e40  ! 1631: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	.word 0xd8bf0e40  ! 1632: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0xdc866000  ! 1633: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0xd4878e60  ! 1634: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r10
	mov	0x3e8, %r21
	.word 0xdcf7ce60  ! 1636: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0x87802025  ! 1637: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1638: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r17
	.word 0xdab649e0  ! 1640: STHA_R	stha	%r13, [%r25 + %r0] 0x4f
	.word 0xd89c4400  ! 1641: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xdacf0e80  ! 1642: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	mov	0x48, %r24
	.word 0xd2c4c400  ! 1644: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xdca4e000  ! 1645: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xdcbca000  ! 1647: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcaca000  ! 1648: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1649: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1650: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca66000  ! 1651: STWA_I	stwa	%r14, [%r25 + 0x0000] %asi
	.word 0xdea40400  ! 1652: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd8f66000  ! 1653: STXA_I	stxa	%r12, [%r25 + 0x0000] %asi
	.word 0xd89ea000  ! 1654: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	.word 0xd8b6a000  ! 1655: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	mov	0x38, %r16
	.word 0xd8c66000  ! 1657: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r12
	.word 0xd8c6a000  ! 1658: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xdca544a0  ! 1659: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd2aee000  ! 1660: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0xd2bea000  ! 1661: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xd2862000  ! 1662: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0x87802025  ! 1663: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8f40400  ! 1664: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd0f7a000  ! 1665: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd087e000  ! 1666: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd0f44400  ! 1667: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	.word 0x87802072  ! 1668: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09d44a0  ! 1669: LDDA_R	ldda	[%r21, %r0] 0x25, %r8
	.word 0xd6cd84a0  ! 1670: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0xd6f7e000  ! 1671: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xdebc0400  ! 1672: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xd6d70e80  ! 1673: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0x87802074  ! 1674: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r23
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3d8, %r20
	.word 0x87802020  ! 1678: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1679: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4be89e0  ! 1680: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	.word 0xdaf74e80  ! 1681: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0xd89689e0  ! 1682: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r12
	.word 0xdccca000  ! 1683: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	mov	0x10, %r17
	.word 0xdccce000  ! 1685: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xd2c44400  ! 1686: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd4f48400  ! 1687: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xde95c4a0  ! 1688: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	mov	0x3e8, %r22
	.word 0xd4b70e60  ! 1690: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	.word 0xd6846000  ! 1691: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1692: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69e2000  ! 1693: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r11
	.word 0xd6bcc400  ! 1694: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1695: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b689e0  ! 1696: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0xdabfce40  ! 1697: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xd8adc4a0  ! 1698: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xd8f44400  ! 1699: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xdea4e000  ! 1700: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xd6af8e80  ! 1701: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0xdcc46000  ! 1702: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	mov	0x3c8, %r22
	mov	0x38, %r25
	.word 0xdc8ce000  ! 1705: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xde944400  ! 1706: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0x87802072  ! 1707: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29f8e60  ! 1708: LDDA_R	ldda	[%r30, %r0] 0x73, %r9
	.word 0xd4bf6000  ! 1709: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x68, %r25
	mov	0x18, %r16
	.word 0xd4f7a000  ! 1712: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd2b544a0  ! 1713: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	mov	0x78, %r25
	.word 0xd4878e60  ! 1715: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r10
	.word 0x87802020  ! 1716: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a56000  ! 1717: STWA_I	stwa	%r11, [%r21 + 0x0000] %asi
	.word 0xd8a584a0  ! 1718: STWA_R	stwa	%r12, [%r22 + %r0] 0x25
	mov	0x40, %r26
	.word 0xdc952000  ! 1720: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r14
	mov	0x28, %r26
	.word 0xd8f74e80  ! 1722: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	.word 0xd6ade000  ! 1723: STBA_I	stba	%r11, [%r23 + 0x0000] %asi
	.word 0xd8bf4e80  ! 1724: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	mov	0x7d0, %r22
	.word 0xd6dda000  ! 1726: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r11
	.word 0xd6cde000  ! 1727: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r11
	mov	0x3c0, %r20
	mov	0x70, %r24
	.word 0xd6c74e40  ! 1730: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r11
	.word 0xdcb5c4a0  ! 1731: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xdca56000  ! 1732: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	.word 0xdc852000  ! 1733: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	mov	0x28, %r25
	.word 0x8780204f  ! 1735: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b40400  ! 1736: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xd4f76000  ! 1737: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 1738: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd086c9e0  ! 1739: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r8
	.word 0xd0a544a0  ! 1740: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	mov	0x3d8, %r20
	.word 0x87802020  ! 1742: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c7e000  ! 1743: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd68d84a0  ! 1744: LDUBA_R	lduba	[%r22, %r0] 0x25, %r11
	mov	0x50, %r27
	mov	0x50, %r25
	.word 0xd4a7a000  ! 1747: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x70, %r19
	mov	0x48, %r16
	mov	0x3e8, %r21
	.word 0xd49f6000  ! 1751: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd4c7a000  ! 1752: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x3c0, %r23
	mov	0x30, %r18
	.word 0xd4df6000  ! 1755: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	mov	0x70, %r16
	.word 0xd49fa000  ! 1757: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1758: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r20
	mov	0x48, %r27
	.word 0x87802020  ! 1761: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d78e80  ! 1762: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r11
	.word 0xdead2000  ! 1763: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	.word 0xdebde000  ! 1764: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xdecf4e40  ! 1766: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r15
	.word 0xd8cd2000  ! 1767: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	mov	0x20, %r19
	mov	0x7e8, %r23
	.word 0xd8bda000  ! 1770: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xd49c4400  ! 1771: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xd4a74e80  ! 1772: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	.word 0x87802074  ! 1773: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28f8e60  ! 1774: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	mov	0x7c0, %r20
	.word 0xd4b66000  ! 1776: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xdccf0e40  ! 1778: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0xdec6e000  ! 1779: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r15
	.word 0xdeaea000  ! 1780: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xd2af8e60  ! 1781: STBA_R	stba	%r9, [%r30 + %r0] 0x73
	.word 0x87802073  ! 1782: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a78e40  ! 1783: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xd0f544a0  ! 1784: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xd4ae09e0  ! 1785: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xd895c4a0  ! 1786: LDUHA_R	lduha	[%r23, %r0] 0x25, %r12
	.word 0xd29f0e80  ! 1787: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	.word 0xd2c42000  ! 1788: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r9
	.word 0xd4f504a0  ! 1789: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	.word 0x87802073  ! 1790: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6870e60  ! 1791: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	.word 0xd0b7e000  ! 1792: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0f72000  ! 1793: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xdcb48400  ! 1794: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd2874e80  ! 1795: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r9
	.word 0xd0ac4400  ! 1796: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1797: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1798: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b42000  ! 1799: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd08c6000  ! 1800: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	mov	0x28, %r17
	.word 0xd0d4e000  ! 1802: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f42000  ! 1803: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	.word 0xd0d42000  ! 1804: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1805: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0af2000  ! 1806: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0d72000  ! 1807: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	mov	0x7e0, %r20
	.word 0xdea544a0  ! 1809: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xdcbf6000  ! 1810: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	mov	0x70, %r26
	.word 0x87802073  ! 1812: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca56000  ! 1813: STWA_I	stwa	%r14, [%r21 + 0x0000] %asi
	mov	0x60, %r26
	.word 0x87802073  ! 1815: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6ae89e0  ! 1816: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0xd4a44400  ! 1817: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0x87802025  ! 1818: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1819: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf40400  ! 1820: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd8c7a000  ! 1821: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd2df0e40  ! 1822: LDXA_R	ldxa	[%r28, %r0] 0x72, %r9
	.word 0xd89f2000  ! 1823: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd897e000  ! 1824: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8a72000  ! 1825: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd4bfce60  ! 1826: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0xd8d72000  ! 1827: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	mov	0x20, %r25
	.word 0xd88fa000  ! 1829: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 1830: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r24
	.word 0xd8a42000  ! 1832: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	mov	0x3e0, %r23
	mov	0x70, %r17
	.word 0xde970e80  ! 1835: LDUHA_R	lduha	[%r28, %r0] 0x74, %r15
	mov	0x30, %r26
	.word 0x8780204f  ! 1837: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbf0e80  ! 1838: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	mov	0x3f0, %r21
	mov	0x28, %r25
	.word 0xdaaf2000  ! 1841: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdad72000  ! 1842: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	mov	0x7f8, %r21
	mov	0x50, %r24
	.word 0x87802074  ! 1845: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8da000  ! 1846: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xd8de49e0  ! 1847: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r12
	.word 0x87802073  ! 1848: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf56000  ! 1849: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xdaad2000  ! 1850: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xdab56000  ! 1851: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xdc974e60  ! 1852: LDUHA_R	lduha	[%r29, %r0] 0x73, %r14
	.word 0xdabfce60  ! 1853: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	mov	0x7f0, %r22
	mov	0x3e8, %r22
	.word 0xdef40400  ! 1856: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd2dd2000  ! 1857: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r9
	.word 0xdeb78e60  ! 1858: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xdac52000  ! 1859: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r13
	.word 0xd4f7ce60  ! 1860: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0x87802074  ! 1861: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d46000  ! 1862: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0xd887ce40  ! 1863: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r12
	.word 0xdea46000  ! 1864: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1865: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8dd44a0  ! 1866: LDXA_R	ldxa	[%r21, %r0] 0x25, %r12
	.word 0xd6bf8e40  ! 1867: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	.word 0xd6a7ce80  ! 1868: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	mov	0x7d8, %r21
	.word 0xd4b544a0  ! 1870: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	mov	0x38, %r17
	.word 0xdadd44a0  ! 1872: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	.word 0xdcb46000  ! 1873: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1874: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1875: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1876: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcaea000  ! 1877: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdea7ce80  ! 1878: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0x87802073  ! 1879: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8f0e80  ! 1880: LDUBA_R	lduba	[%r28, %r0] 0x74, %r14
	.word 0xdcb544a0  ! 1881: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	mov	0x20, %r16
	.word 0xd2cec9e0  ! 1883: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r9
	.word 0xd0b7e000  ! 1884: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xd0a72000  ! 1886: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd0d76000  ! 1888: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	mov	0x7e0, %r22
	.word 0xd0bfa000  ! 1890: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd887ce80  ! 1891: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	.word 0xdebf6000  ! 1892: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 1893: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2de49e0  ! 1894: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0xd6f5c4a0  ! 1895: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	mov	0x20, %r17
	.word 0xd2a78e40  ! 1897: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	mov	0x7e0, %r22
	mov	0x50, %r27
	mov	0x7d0, %r20
	.word 0xdcb48400  ! 1901: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd68c0400  ! 1902: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xdea6a000  ! 1903: STWA_I	stwa	%r15, [%r26 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xdeae6000  ! 1905: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	mov	0x48, %r25
	mov	0x8, %r25
	.word 0x87802020  ! 1908: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r23
	.word 0x87802020  ! 1910: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4af8e60  ! 1911: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xd4b78e40  ! 1912: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	mov	0x3e0, %r22
	.word 0xd69f8e60  ! 1914: LDDA_R	ldda	[%r30, %r0] 0x73, %r11
	.word 0xdcc56000  ! 1915: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1916: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bfce40  ! 1917: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xdaf72000  ! 1918: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdabf6000  ! 1919: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd08fce80  ! 1920: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0xda8e09e0  ! 1921: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	.word 0x87802072  ! 1922: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dec9e0  ! 1923: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	.word 0x87802020  ! 1924: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2866000  ! 1925: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	.word 0x87802072  ! 1926: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8cec9e0  ! 1927: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r12
	.word 0x8780204f  ! 1928: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ae2000  ! 1929: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd8bee000  ! 1930: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	mov	0x20, %r26
	mov	0x3c8, %r22
	.word 0xd8d78e40  ! 1933: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r12
	.word 0x87802072  ! 1934: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 1935: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1936: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac74e60  ! 1937: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r13
	mov	0x3d0, %r22
	mov	0x10, %r17
	.word 0x87802073  ! 1940: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa7a000  ! 1941: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 1942: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r18
	.word 0x87802020  ! 1944: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r27
	.word 0x87802020  ! 1946: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1947: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda872000  ! 1948: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xd0d70e60  ! 1949: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r8
	.word 0x87802072  ! 1950: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb76000  ! 1951: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x58, %r18
	.word 0xdef72000  ! 1953: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdca649e0  ! 1954: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	mov	0x7c0, %r22
	.word 0xd6af2000  ! 1956: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6bdc4a0  ! 1957: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xd2bf6000  ! 1958: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xdcc44400  ! 1959: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xd6b74e60  ! 1960: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xd8d7a000  ! 1961: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 1962: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd88fe000  ! 1963: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	mov	0x3e8, %r23
	.word 0xd8b72000  ! 1965: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1966: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r27
	mov	0x78, %r16
	mov	0x40, %r24
	.word 0x87802020  ! 1970: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08fce80  ! 1972: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0xdaf62000  ! 1973: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xdedc0400  ! 1974: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	.word 0xd286c9e0  ! 1975: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r9
	.word 0xd0b66000  ! 1976: STHA_I	stha	%r8, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 1977: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cd04a0  ! 1978: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r9
	.word 0xd2ae6000  ! 1979: STBA_I	stba	%r9, [%r25 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd8afce60  ! 1981: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xd696c9e0  ! 1982: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r11
	mov	0x3c0, %r23
	mov	0x40, %r27
	.word 0xd086a000  ! 1985: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r8
	.word 0xd0a6a000  ! 1986: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	.word 0xd6f4c400  ! 1987: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 1988: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab42000  ! 1989: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdadc6000  ! 1990: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	.word 0xd8a7ce80  ! 1991: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0xdcc7ce40  ! 1992: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r14
	.word 0xdcbc6000  ! 1993: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xd8c4c400  ! 1994: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0xdadca000  ! 1995: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xd8c584a0  ! 1996: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	.word 0xd49c6000  ! 1997: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0x87802073  ! 1998: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af2000  ! 1999: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xdaf544a0  ! 2000: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	mov	0x10, %r18
	.word 0xd0872000  ! 2002: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd2a74e80  ! 2003: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0x87802073  ! 2004: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf66000  ! 2005: STXA_I	stxa	%r14, [%r25 + 0x0000] %asi
	.word 0xdabd04a0  ! 2006: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	mov	0x0, %r16
	.word 0xda9ee000  ! 2008: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0x87802072  ! 2009: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4df4e40  ! 2010: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xdab44400  ! 2011: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0x87802074  ! 2012: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2013: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c70e80  ! 2014: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	mov	0x40, %r16
	.word 0x8780204f  ! 2016: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a7ce80  ! 2017: STWA_R	stwa	%r10, [%r31 + %r0] 0x74
	mov	0x3d8, %r20
	.word 0xded4c400  ! 2019: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0xd8b42000  ! 2020: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0xd8f4a000  ! 2021: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd6b78e40  ! 2022: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xda8f0e80  ! 2023: LDUBA_R	lduba	[%r28, %r0] 0x74, %r13
	mov	0x7e8, %r21
	mov	0x7c8, %r20
	.word 0x87802020  ! 2026: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r17
	mov	0x38, %r18
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd0cd84a0  ! 2030: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0xd0cfa000  ! 2031: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd2f7ce40  ! 2032: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0xdc87ce40  ! 2033: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r14
	.word 0x87802074  ! 2034: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcacc400  ! 2035: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	.word 0x87802072  ! 2036: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8940400  ! 2037: LDUHA_R	lduha	[%r16, %r0] 0x20, %r12
	mov	0x7f0, %r22
	mov	0x20, %r27
	.word 0xdc95a000  ! 2040: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xdcf5a000  ! 2041: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	mov	0x48, %r26
	.word 0xdeb78e60  ! 2043: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xd8cf0e60  ! 2044: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r12
	.word 0xdedde000  ! 2045: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r15
	.word 0xd0af8e60  ! 2046: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0xd4a609e0  ! 2047: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	.word 0xd8a40400  ! 2048: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xd8bec9e0  ! 2049: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0xd2ad2000  ! 2050: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 2051: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r16
	.word 0xd2c7e000  ! 2053: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0x87802072  ! 2054: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2055: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r22
	mov	0x10, %r24
	.word 0xd2bfa000  ! 2058: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x70, %r16
	.word 0x87802072  ! 2060: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29fe000  ! 2061: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd6ddc4a0  ! 2062: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	.word 0xd6cfe000  ! 2063: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd8a609e0  ! 2064: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0xd89d44a0  ! 2065: LDDA_R	ldda	[%r21, %r0] 0x25, %r12
	mov	0x7f8, %r21
	.word 0xd2b7ce60  ! 2067: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xd8972000  ! 2068: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	mov	0x28, %r17
	mov	0x8, %r25
	mov	0x50, %r18
	.word 0xd4f44400  ! 2072: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0xd09584a0  ! 2073: LDUHA_R	lduha	[%r22, %r0] 0x25, %r8
	mov	0x78, %r16
	.word 0xd4a689e0  ! 2075: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	mov	0x30, %r18
	.word 0xd09fe000  ! 2077: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r8
	mov	0x3f8, %r20
	.word 0xd6a70e80  ! 2079: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	.word 0xd8af2000  ! 2080: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x38, %r19
	mov	0x3f0, %r23
	.word 0x87802072  ! 2083: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69f4e40  ! 2084: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	.word 0xdaf78e60  ! 2085: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	mov	0x10, %r25
	.word 0xd0a74e60  ! 2087: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	mov	0x78, %r27
	.word 0xd0b7a000  ! 2089: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xdcb48400  ! 2090: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd0872000  ! 2091: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0c72000  ! 2092: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd6a48400  ! 2093: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0xdeac4400  ! 2094: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0x87802072  ! 2095: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r25
	.word 0xd0d649e0  ! 2097: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r8
	.word 0x87802020  ! 2098: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ad04a0  ! 2099: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xd0a76000  ! 2100: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2101: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0afe000  ! 2102: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0bf2000  ! 2103: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	mov	0x50, %r25
	mov	0x8, %r26
	.word 0xd2f6c9e0  ! 2106: STXA_R	stxa	%r9, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 2107: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r21
	.word 0xd6bfe000  ! 2109: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 2110: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9d04a0  ! 2111: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0x87802020  ! 2112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd6e000  ! 2113: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2114: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2116: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x28, %r19
	.word 0xdcd7e000  ! 2118: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb7e000  ! 2119: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x7c0, %r23
	mov	0x50, %r27
	mov	0x30, %r18
	.word 0x87802072  ! 2123: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbce000  ! 2124: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xdc842000  ! 2126: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	mov	0x78, %r25
	.word 0x87802074  ! 2128: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0af0e80  ! 2129: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xd0c48400  ! 2130: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xdedca000  ! 2131: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdec42000  ! 2132: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xd2a70e80  ! 2133: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	.word 0x87802020  ! 2134: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0848400  ! 2135: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	mov	0x30, %r26
	.word 0xdaaea000  ! 2137: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	mov	0x10, %r26
	.word 0x87802025  ! 2139: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f74e40  ! 2140: STXA_R	stxa	%r9, [%r29 + %r0] 0x72
	.word 0xdcafce40  ! 2141: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xd8be49e0  ! 2142: STDA_R	stda	%r12, [%r25 + %r0] 0x4f
	.word 0xdab504a0  ! 2143: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0x87802025  ! 2144: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r17
	.word 0xd8a7a000  ! 2146: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xdab4c400  ! 2147: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd2976000  ! 2148: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802025  ! 2149: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4ce49e0  ! 2150: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	mov	0x3e8, %r22
	mov	0x30, %r25
	mov	0x60, %r18
	.word 0x87802020  ! 2154: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r24
	mov	0x8, %r24
	.word 0x8780204f  ! 2157: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdead2000  ! 2158: STBA_I	stba	%r15, [%r20 + 0x0000] %asi
	.word 0xde95e000  ! 2159: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r15
	.word 0xdeb5e000  ! 2160: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xdeada000  ! 2161: STBA_I	stba	%r15, [%r22 + 0x0000] %asi
	.word 0x87802020  ! 2162: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb7a000  ! 2163: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdea72000  ! 2164: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xded70e80  ! 2165: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r15
	.word 0xd4a72000  ! 2166: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd6b78e40  ! 2167: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xdaa6c9e0  ! 2168: STWA_R	stwa	%r13, [%r27 + %r0] 0x4f
	.word 0xded7a000  ! 2169: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xde972000  ! 2170: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	mov	0x18, %r26
	.word 0xde87a000  ! 2172: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	mov	0x7c0, %r22
	.word 0x87802073  ! 2174: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde976000  ! 2175: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xd0b40400  ! 2176: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xd08fe000  ! 2177: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r8
	.word 0xd0d689e0  ! 2178: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r8
	.word 0x87802020  ! 2179: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r24
	mov	0x10, %r18
	.word 0x87802074  ! 2182: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6b6c9e0  ! 2183: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xdc87ce60  ! 2184: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r14
	.word 0xd2b4a000  ! 2185: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0xd2a7ce80  ! 2186: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xde8d84a0  ! 2187: LDUBA_R	lduba	[%r22, %r0] 0x25, %r15
	.word 0xd8c46000  ! 2188: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8c42000  ! 2189: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	.word 0xdac78e60  ! 2190: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0x87802073  ! 2191: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd687a000  ! 2192: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2193: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2194: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r26
	.word 0xd8dc8400  ! 2196: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	mov	0x70, %r27
	.word 0x87802020  ! 2198: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r26
	mov	0x28, %r24
	.word 0xd6b544a0  ! 2201: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xd0afce80  ! 2202: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd8c78e80  ! 2203: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r12
	.word 0xd6a544a0  ! 2204: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0x87802074  ! 2205: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r16
	.word 0xd49fa000  ! 2207: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	mov	0x7d8, %r20
	.word 0xd0df4e40  ! 2209: LDXA_R	ldxa	[%r29, %r0] 0x72, %r8
	mov	0x7d0, %r23
	.word 0xdcb6c9e0  ! 2211: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xd697ce80  ! 2212: LDUHA_R	lduha	[%r31, %r0] 0x74, %r11
	.word 0xdab48400  ! 2213: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	mov	0x8, %r24
	.word 0xd29fa000  ! 2215: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f76000  ! 2216: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd29f2000  ! 2217: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x10, %r27
	.word 0xdc840400  ! 2219: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	mov	0x68, %r25
	.word 0xd2f78e80  ! 2221: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	mov	0x68, %r16
	.word 0x87802025  ! 2223: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r26
	.word 0xdabda000  ! 2225: STDA_I	stda	%r13, [%r22 + 0x0000] %asi
	.word 0xdc874e60  ! 2226: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r14
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6f52000  ! 2228: STXA_I	stxa	%r11, [%r20 + 0x0000] %asi
	.word 0xd4978e40  ! 2229: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0x87802074  ! 2230: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2b7a000  ! 2231: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0xdcc40400  ! 2233: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xdef76000  ! 2234: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdedfa000  ! 2235: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x3e0, %r23
	mov	0x60, %r27
	mov	0x0, %r26
	mov	0x3e8, %r23
	.word 0x87802025  ! 2240: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda97ce80  ! 2241: LDUHA_R	lduha	[%r31, %r0] 0x74, %r13
	.word 0xd4a4e000  ! 2242: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xda9cc400  ! 2243: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	mov	0x38, %r26
	mov	0x48, %r26
	.word 0xdcd649e0  ! 2246: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r14
	.word 0xd49fce80  ! 2247: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	mov	0x48, %r24
	.word 0xd2a7ce80  ! 2249: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	mov	0x7e8, %r23
	.word 0xdece09e0  ! 2251: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	.word 0xd684e000  ! 2252: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6b4e000  ! 2253: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd2ac4400  ! 2254: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd8dfce80  ! 2255: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	.word 0xd6f46000  ! 2256: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6a46000  ! 2257: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xd6846000  ! 2259: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0x87802073  ! 2260: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f7ce80  ! 2261: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xdcc74e60  ! 2262: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	.word 0xd6d5c4a0  ! 2263: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	.word 0x87802072  ! 2264: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8ea000  ! 2265: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	mov	0x38, %r25
	mov	0x3c8, %r22
	.word 0xd0f78e60  ! 2268: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	mov	0x10, %r18
	.word 0x87802073  ! 2270: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d4a000  ! 2271: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0x87802074  ! 2272: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdc9d44a0  ! 2273: LDDA_R	ldda	[%r21, %r0] 0x25, %r14
	.word 0xd084a000  ! 2274: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	mov	0x78, %r17
	.word 0xd0ace000  ! 2276: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd0b42000  ! 2277: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 2278: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7d0, %r22
	mov	0x38, %r18
	.word 0xd0bd2000  ! 2281: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	.word 0xd0dde000  ! 2282: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r8
	.word 0xd0952000  ! 2283: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0xda8c4400  ! 2284: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0x87802072  ! 2285: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r18
	.word 0xd8cfe000  ! 2287: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	mov	0x60, %r19
	.word 0xd8af6000  ! 2289: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd0d7ce40  ! 2290: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r8
	.word 0xd0b72000  ! 2291: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd28fce80  ! 2292: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	.word 0xdca7ce80  ! 2293: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	mov	0x20, %r26
	.word 0xd2dec9e0  ! 2295: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r9
	.word 0xd4f72000  ! 2296: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4c7a000  ! 2297: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x40, %r27
	mov	0x30, %r17
	.word 0x87802020  ! 2300: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2301: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ddc4a0  ! 2302: LDXA_R	ldxa	[%r23, %r0] 0x25, %r12
	mov	0x7e0, %r22
	.word 0xd0a44400  ! 2304: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xdc8f8e40  ! 2305: LDUBA_R	lduba	[%r30, %r0] 0x72, %r14
	.word 0xd49ee000  ! 2306: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r10
	mov	0x18, %r16
	.word 0xd4be6000  ! 2308: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xdc978e60  ! 2309: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	mov	0x7c8, %r21
	.word 0x87802072  ! 2311: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r26
	.word 0xd0b40400  ! 2313: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xdcbfa000  ! 2314: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xdc87a000  ! 2315: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2316: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r16
	.word 0xd2a584a0  ! 2318: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	.word 0xd4df2000  ! 2319: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	mov	0x3e8, %r22
	.word 0xdecd44a0  ! 2321: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r15
	.word 0xd6c7e000  ! 2322: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd4de89e0  ! 2323: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r10
	.word 0xd6b76000  ! 2324: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd8f48400  ! 2325: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd6a72000  ! 2326: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6f76000  ! 2327: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xda870e80  ! 2328: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r13
	.word 0xd2b7a000  ! 2329: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xdea78e60  ! 2330: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	mov	0x38, %r17
	.word 0xdef7a000  ! 2332: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xde8dc4a0  ! 2333: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xdeaf6000  ! 2334: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd6cc0400  ! 2335: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	mov	0x10, %r17
	.word 0xde87a000  ! 2337: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xdea7e000  ! 2338: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2339: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecf2000  ! 2340: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xde87e000  ! 2341: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 2342: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2343: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d8, %r21
	.word 0x87802020  ! 2345: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc2000  ! 2346: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xd88c8400  ! 2347: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0xd2bc6000  ! 2348: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 2349: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc9649e0  ! 2350: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r14
	.word 0x87802073  ! 2351: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d78e80  ! 2352: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r9
	.word 0xd8bfce60  ! 2353: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0x87802073  ! 2354: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0d4a000  ! 2356: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0a46000  ! 2357: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd2f48400  ! 2358: STXA_R	stxa	%r9, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 2359: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab504a0  ! 2360: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	mov	0x3f0, %r21
	mov	0x68, %r26
	.word 0xdea7a000  ! 2363: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdea76000  ! 2364: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xd8a74e60  ! 2365: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	.word 0xdea7a000  ! 2366: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xdedf6000  ! 2368: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	.word 0xded72000  ! 2369: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x10, %r25
	.word 0xdc874e60  ! 2371: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r14
	.word 0x87802073  ! 2372: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcf74e40  ! 2373: STXA_R	stxa	%r14, [%r29 + %r0] 0x72
	.word 0xd2ac4400  ! 2374: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2375: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88544a0  ! 2376: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r12
	.word 0xdab6e000  ! 2377: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 2378: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2379: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0af8e60  ! 2380: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0xdacf0e40  ! 2381: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r13
	.word 0xde8d2000  ! 2382: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r15
	.word 0xd68e49e0  ! 2383: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r11
	.word 0x87802020  ! 2384: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2385: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6d46000  ! 2386: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r11
	.word 0xd8f44400  ! 2387: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd6bfce40  ! 2388: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	mov	0x7e8, %r20
	mov	0x40, %r18
	.word 0xdaac2000  ! 2391: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xd4bfce60  ! 2392: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0x87802073  ! 2393: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b44400  ! 2394: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xd2acc400  ! 2395: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	mov	0x20, %r26
	.word 0xdcc7e000  ! 2397: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca42000  ! 2399: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4bcc400  ! 2401: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2402: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaca000  ! 2403: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xd0bfce40  ! 2404: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0xdcc4a000  ! 2405: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	mov	0x50, %r17
	mov	0x10, %r26
	.word 0xdaf544a0  ! 2408: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0xdedca000  ! 2409: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdebce000  ! 2410: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xde9c0400  ! 2411: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0xded504a0  ! 2412: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	.word 0x87802073  ! 2413: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r18
	.word 0xdcf7e000  ! 2415: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd6ad04a0  ! 2416: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0x87802073  ! 2417: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49ca000  ! 2418: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4970e40  ! 2419: LDUHA_R	lduha	[%r28, %r0] 0x72, %r10
	.word 0xdcd4e000  ! 2420: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0xdcbca000  ! 2421: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	mov	0x3c8, %r22
	mov	0x3f0, %r21
	.word 0xdcaca000  ! 2424: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0xd48cc400  ! 2425: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xdecce000  ! 2426: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	mov	0x58, %r17
	.word 0xdec42000  ! 2428: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	mov	0x3c0, %r20
	.word 0xd8cc4400  ! 2430: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0x8780204f  ! 2431: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde976000  ! 2432: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xdecfa000  ! 2433: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xd0b584a0  ! 2434: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0xdaf76000  ! 2435: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xd2be89e0  ! 2436: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	.word 0xda9c8400  ! 2437: LDDA_R	ldda	[%r18, %r0] 0x20, %r13
	.word 0xd8a7e000  ! 2438: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xdca48400  ! 2440: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0x87802025  ! 2441: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f7ce60  ! 2442: STXA_R	stxa	%r8, [%r31 + %r0] 0x73
	.word 0xd2b4e000  ! 2443: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	mov	0x18, %r18
	.word 0xd6c7ce40  ! 2445: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r11
	.word 0xd694e000  ! 2446: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	mov	0x70, %r27
	.word 0xd6d5c4a0  ! 2448: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	.word 0xd4bcc400  ! 2449: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x10, %r17
	.word 0x8780204f  ! 2451: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2af8e40  ! 2452: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xd2dc4400  ! 2453: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xdca66000  ! 2454: STWA_I	stwa	%r14, [%r25 + 0x0000] %asi
	mov	0x3d8, %r23
	mov	0x70, %r24
	.word 0x87802020  ! 2457: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2458: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc72000  ! 2459: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xd6f4c400  ! 2460: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xdaa40400  ! 2461: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0x87802072  ! 2462: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cf6000  ! 2463: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2f76000  ! 2464: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd4b544a0  ! 2465: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xd4a78e40  ! 2466: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	mov	0x7d0, %r22
	.word 0xdabc8400  ! 2468: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd8af2000  ! 2469: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xdeac0400  ! 2470: STBA_R	stba	%r15, [%r16 + %r0] 0x20
	.word 0xdcb7a000  ! 2471: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd6bc0400  ! 2472: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd09c0400  ! 2473: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	mov	0x78, %r19
	.word 0xd6972000  ! 2475: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 2476: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6b7a000  ! 2477: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6c72000  ! 2478: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 2479: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd88e49e0  ! 2480: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	mov	0x3e0, %r20
	.word 0xd8f7e000  ! 2482: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd486c9e0  ! 2483: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	.word 0xd4bf6000  ! 2484: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd08c0400  ! 2485: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	.word 0xd2844400  ! 2486: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0x8780204f  ! 2487: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2488: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0c4e000  ! 2489: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xd09c6000  ! 2490: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0xd08c6000  ! 2491: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2492: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dfe000  ! 2493: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	mov	0x50, %r24
	.word 0x87802020  ! 2495: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r22
	.word 0xd0b76000  ! 2497: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0a76000  ! 2498: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0f7a000  ! 2499: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 2500: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	.word 0xd0bf8e80  ! 2502: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd2f52000  ! 2503: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 2504: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x40, %r18
	mov	0x50, %r17
	.word 0x8780204f  ! 2507: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2508: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2ad6000  ! 2509: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd2d52000  ! 2510: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r9
	.word 0xd2ade000  ! 2511: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd2c70e40  ! 2512: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r9
	.word 0xd8d56000  ! 2513: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r12
	.word 0xd8dda000  ! 2514: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xdeb7ce40  ! 2515: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xdece89e0  ! 2516: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	.word 0xd8b4c400  ! 2517: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd2ada000  ! 2518: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xd2b5e000  ! 2520: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd2a5a000  ! 2521: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xd2b70e60  ! 2522: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd09d84a0  ! 2523: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	.word 0xd89c8400  ! 2524: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	.word 0xda874e80  ! 2525: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r13
	mov	0x78, %r16
	.word 0xdef52000  ! 2527: STXA_I	stxa	%r15, [%r20 + 0x0000] %asi
	.word 0xd0a6c9e0  ! 2528: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xdcd52000  ! 2529: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xdc956000  ! 2530: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r14
	mov	0x3e0, %r22
	.word 0xdcc5e000  ! 2532: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r14
	mov	0x7c0, %r21
	.word 0xd0b74e60  ! 2534: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	mov	0x58, %r18
	mov	0x70, %r27
	ta	T_CHANGE_HPRIV	! macro
	mov	0x10, %r26
	.word 0xd0d70e40  ! 2539: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0x87802073  ! 2540: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2541: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b74e80  ! 2542: STHA_R	stha	%r10, [%r29 + %r0] 0x74
	.word 0xdebf4e60  ! 2543: STDA_R	stda	%r15, [%r29 + %r0] 0x73
	.word 0xd4bea000  ! 2544: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	.word 0xd0df8e40  ! 2545: LDXA_R	ldxa	[%r30, %r0] 0x72, %r8
	.word 0xd8a62000  ! 2546: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xd49649e0  ! 2547: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	mov	0x40, %r25
	.word 0xd8c584a0  ! 2549: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	.word 0x87802020  ! 2550: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8f2000  ! 2551: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2552: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f48400  ! 2553: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd0b4e000  ! 2554: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd6b70e40  ! 2555: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0xda9e49e0  ! 2556: LDDA_R	ldda	[%r25, %r0] 0x4f, %r13
	mov	0x3e0, %r20
	.word 0xd6de09e0  ! 2558: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	.word 0x87802020  ! 2559: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89649e0  ! 2560: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0xde862000  ! 2561: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r15
	.word 0xde86e000  ! 2562: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xd4948400  ! 2563: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd8862000  ! 2564: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	mov	0x78, %r19
	.word 0xd88e6000  ! 2566: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8a6e000  ! 2567: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xd8b6a000  ! 2568: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xd8c6a000  ! 2569: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8be6000  ! 2570: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0xd8d6e000  ! 2571: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r12
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802073  ! 2573: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f46000  ! 2574: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd0af4e40  ! 2575: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	mov	0x78, %r27
	.word 0xd2b584a0  ! 2577: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xdacf0e80  ! 2578: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	mov	0x28, %r19
	.word 0xd0b74e40  ! 2580: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xdeaf4e80  ! 2581: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	mov	0x28, %r18
	.word 0xd6aca000  ! 2583: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xd49649e0  ! 2584: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	.word 0xdc942000  ! 2585: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 2586: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcb52000  ! 2587: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0xdcd5a000  ! 2588: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r14
	.word 0xd0848400  ! 2589: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r8
	.word 0xd88609e0  ! 2590: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	.word 0x87802025  ! 2591: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r25
	.word 0xd8df6000  ! 2593: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8bfe000  ! 2594: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x3c0, %r22
	.word 0xd8cfe000  ! 2596: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xd087ce80  ! 2597: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	mov	0x38, %r18
	.word 0xd68f8e40  ! 2599: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0x87802073  ! 2600: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda9c4400  ! 2601: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xd4cf8e80  ! 2602: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r10
	.word 0xd4a584a0  ! 2603: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0x87802072  ! 2604: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c42000  ! 2605: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x58, %r27
	.word 0x87802074  ! 2607: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f4c400  ! 2608: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x3d0, %r21
	mov	0x60, %r19
	.word 0xde876000  ! 2611: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xd2b48400  ! 2612: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2614: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r17
	.word 0xd89609e0  ! 2616: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r12
	mov	0x18, %r19
	.word 0xdebf0e60  ! 2618: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xd8b7a000  ! 2619: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd8bf2000  ! 2620: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xdcbf4e40  ! 2621: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	mov	0x78, %r17
	.word 0xdacdc4a0  ! 2623: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r13
	.word 0x87802020  ! 2624: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde844400  ! 2625: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xdcf78e60  ! 2626: STXA_R	stxa	%r14, [%r30 + %r0] 0x73
	.word 0x87802072  ! 2627: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r21
	mov	0x7d8, %r21
	mov	0x78, %r16
	.word 0xdadce000  ! 2631: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xda842000  ! 2632: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	.word 0xdadce000  ! 2633: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdaac6000  ! 2634: STBA_I	stba	%r13, [%r17 + 0x0000] %asi
	.word 0xd6df0e60  ! 2635: LDXA_R	ldxa	[%r28, %r0] 0x73, %r11
	.word 0xd4a48400  ! 2636: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd4ac2000  ! 2637: STBA_I	stba	%r10, [%r16 + 0x0000] %asi
	mov	0x68, %r27
	.word 0x87802020  ! 2639: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9c4400  ! 2640: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	mov	0x3c0, %r21
	.word 0xd6f70e40  ! 2642: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xd68ca000  ! 2643: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2644: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r21
	.word 0xd6d4c400  ! 2646: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0x87802072  ! 2647: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r17
	.word 0xdef609e0  ! 2649: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	mov	0x3c0, %r22
	.word 0xd4b52000  ! 2651: STHA_I	stha	%r10, [%r20 + 0x0000] %asi
	.word 0xd4f5e000  ! 2652: STXA_I	stxa	%r10, [%r23 + 0x0000] %asi
	mov	0x50, %r27
	.word 0xd28c0400  ! 2654: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xd2d78e60  ! 2655: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r9
	.word 0xdeb5a000  ! 2656: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xde9da000  ! 2658: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r15
	.word 0xdeb5a000  ! 2659: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xd2a7ce40  ! 2660: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	.word 0x87802020  ! 2661: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dc8400  ! 2662: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd2bea000  ! 2663: STDA_I	stda	%r9, [%r26 + 0x0000] %asi
	.word 0xda8ec9e0  ! 2664: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r13
	.word 0xd4b66000  ! 2665: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd6bc4400  ! 2667: STDA_R	stda	%r11, [%r17 + %r0] 0x20
	.word 0xdcb40400  ! 2668: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdabfce60  ! 2669: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xd08c4400  ! 2670: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	mov	0x3c0, %r20
	.word 0xdcc62000  ! 2672: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	.word 0xd0bc4400  ! 2673: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	mov	0x28, %r26
	.word 0xd696e000  ! 2675: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	mov	0x68, %r24
	.word 0xdeafce80  ! 2677: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	.word 0xd8866000  ! 2678: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xd8c689e0  ! 2679: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r12
	mov	0x40, %r18
	.word 0xdcacc400  ! 2681: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	mov	0x10, %r17
	.word 0xd4a6a000  ! 2683: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 2684: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r25
	.word 0xd4c7e000  ! 2686: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd0b7ce80  ! 2687: STHA_R	stha	%r8, [%r31 + %r0] 0x74
	.word 0xd29f0e80  ! 2688: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	.word 0xd6ccc400  ! 2689: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xd6a72000  ! 2690: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cfa000  ! 2691: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2692: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r18
	.word 0xd0bc8400  ! 2694: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xd4d52000  ! 2695: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	.word 0x87802025  ! 2696: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4dda000  ! 2697: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r10
	.word 0xd495e000  ! 2698: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r10
	.word 0xd6cc0400  ! 2699: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r11
	mov	0x8, %r17
	.word 0xdad6c9e0  ! 2701: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r13
	.word 0xd0974e60  ! 2702: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	mov	0x3d8, %r21
	.word 0xd0b5e000  ! 2704: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0xd08d6000  ! 2705: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	.word 0xd6f4c400  ! 2706: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 2707: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcaec9e0  ! 2708: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	.word 0xdedfa000  ! 2709: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x68, %r16
	.word 0x87802073  ! 2711: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r27
	mov	0x70, %r24
	mov	0x10, %r17
	.word 0xdea4a000  ! 2715: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xda94c400  ! 2717: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xd8a4e000  ! 2718: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xdcc78e80  ! 2719: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r14
	.word 0xd4ccc400  ! 2720: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r10
	.word 0x8780204f  ! 2721: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r24
	.word 0xd4df6000  ! 2723: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd48f2000  ! 2724: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802073  ! 2725: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r25
	mov	0x7c8, %r23
	.word 0xd88c8400  ! 2728: LDUBA_R	lduba	[%r18, %r0] 0x20, %r12
	.word 0xdcb48400  ! 2729: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd8ad04a0  ! 2730: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	.word 0xd2a72000  ! 2731: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2732: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c76000  ! 2733: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xd0cf8e40  ! 2734: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r8
	.word 0xd4f76000  ! 2735: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd48fe000  ! 2736: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4af6000  ! 2737: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	mov	0x7f0, %r21
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7c0, %r20
	.word 0xdea6c9e0  ! 2741: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xdadc4400  ! 2742: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xdeb40400  ! 2743: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd2af0e60  ! 2744: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	mov	0x8, %r24
	.word 0xdcd48400  ! 2746: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	mov	0x78, %r19
	.word 0xd4bf8e80  ! 2748: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0xde870e60  ! 2749: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	.word 0xdad76000  ! 2750: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xd4afce80  ! 2751: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	mov	0x0, %r25
	.word 0x87802020  ! 2753: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b544a0  ! 2754: STHA_R	stha	%r10, [%r21 + %r0] 0x25
	.word 0xd6bc0400  ! 2755: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xdcdf2000  ! 2756: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdedf8e80  ! 2757: LDXA_R	ldxa	[%r30, %r0] 0x74, %r15
	mov	0x7c0, %r20
	.word 0xd2cfa000  ! 2759: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2b76000  ! 2760: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xdabdc4a0  ! 2761: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xd2c7a000  ! 2762: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	mov	0x7e8, %r20
	.word 0xd2d7e000  ! 2764: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x8, %r25
	.word 0xd2d7e000  ! 2766: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xdef70e60  ! 2767: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0x87802020  ! 2768: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48da000  ! 2769: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r10
	mov	0x78, %r27
	.word 0xd4b504a0  ! 2771: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	mov	0x30, %r18
	.word 0x87802074  ! 2773: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 2774: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea7a000  ! 2775: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdabf4e80  ! 2776: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xdedfa000  ! 2777: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xd6b40400  ! 2778: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd0b76000  ! 2779: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x68, %r19
	mov	0x30, %r24
	.word 0xd09e09e0  ! 2782: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0xdaaf2000  ! 2783: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 2784: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda87a000  ! 2785: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	.word 0xde8e09e0  ! 2786: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0x8780204f  ! 2787: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 2788: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b44400  ! 2789: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd2cf0e40  ! 2790: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0x8780204f  ! 2791: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6848400  ! 2792: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	mov	0x3c8, %r23
	.word 0xdaa7e000  ! 2794: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xdcd74e40  ! 2795: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	.word 0xde9c8400  ! 2796: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	mov	0x28, %r17
	.word 0xd8a7a000  ! 2798: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 2799: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4944400  ! 2800: LDUHA_R	lduha	[%r17, %r0] 0x20, %r10
	.word 0xd88fce40  ! 2801: LDUBA_R	lduba	[%r31, %r0] 0x72, %r12
	.word 0xda9f6000  ! 2802: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdaa76000  ! 2803: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdaaf6000  ! 2804: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdcbf4e60  ! 2805: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	mov	0x78, %r19
	.word 0xd48584a0  ! 2807: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	.word 0xd287e000  ! 2808: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	.word 0xda9544a0  ! 2809: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0xdec72000  ! 2810: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xd8a4c400  ! 2811: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0xdef504a0  ! 2812: STXA_R	stxa	%r15, [%r20 + %r0] 0x25
	.word 0xda974e40  ! 2813: LDUHA_R	lduha	[%r29, %r0] 0x72, %r13
	.word 0xd0a72000  ! 2814: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x3c0, %r20
	mov	0x0, %r27
	mov	0x78, %r16
	mov	0x7d0, %r20
	.word 0xd0cf6000  ! 2819: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2820: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc2000  ! 2821: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	mov	0x0, %r16
	mov	0x70, %r24
	.word 0xd2d74e40  ! 2824: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0x87802025  ! 2825: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca76000  ! 2826: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xd0af0e80  ! 2827: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xd8ce49e0  ! 2828: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0xd0d76000  ! 2829: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	mov	0x28, %r16
	mov	0x10, %r24
	mov	0x50, %r25
	mov	0x7e8, %r21
	.word 0xd0876000  ! 2834: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd8bc8400  ! 2835: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xdc972000  ! 2836: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 2837: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcf7a000  ! 2838: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xdcbd04a0  ! 2839: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0x87802074  ! 2840: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec42000  ! 2841: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r15
	.word 0xd2f504a0  ! 2842: STXA_R	stxa	%r9, [%r20 + %r0] 0x25
	.word 0xd89fce60  ! 2843: LDDA_R	ldda	[%r31, %r0] 0x73, %r12
	.word 0xdccf0e40  ! 2844: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r14
	.word 0xd0874e60  ! 2845: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r8
	.word 0xdca609e0  ! 2846: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	mov	0x58, %r16
	.word 0xd8bd44a0  ! 2848: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xdedec9e0  ! 2849: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r15
	.word 0xd4f44400  ! 2850: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0x87802072  ! 2851: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd6c9e0  ! 2852: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r14
	.word 0xd4c78e60  ! 2853: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r10
	.word 0x87802025  ! 2854: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r26
	.word 0xd88e2000  ! 2856: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r12
	mov	0x28, %r18
	mov	0x70, %r18
	.word 0xd8a66000  ! 2859: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	mov	0x7c8, %r22
	mov	0x30, %r25
	.word 0xd8b6a000  ! 2862: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	.word 0xd8dee000  ! 2863: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	.word 0xdea78e60  ! 2864: STWA_R	stwa	%r15, [%r30 + %r0] 0x73
	.word 0x87802074  ! 2865: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bc8400  ! 2866: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xdac5e000  ! 2867: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	.word 0xdad52000  ! 2868: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r13
	mov	0x28, %r24
	.word 0xd0dfce60  ! 2870: LDXA_R	ldxa	[%r31, %r0] 0x73, %r8
	mov	0x68, %r24
	.word 0xd4d689e0  ! 2872: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r10
	.word 0x87802074  ! 2873: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f4e000  ! 2874: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	mov	0x3e8, %r20
	.word 0xd6f584a0  ! 2876: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xdacd84a0  ! 2877: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r13
	.word 0xdcbdc4a0  ! 2878: STDA_R	stda	%r14, [%r23 + %r0] 0x25
	.word 0x87802073  ! 2879: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a70e40  ! 2880: STWA_R	stwa	%r10, [%r28 + %r0] 0x72
	.word 0xd094c400  ! 2881: LDUHA_R	lduha	[%r19, %r0] 0x20, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7e8, %r23
	mov	0x7c0, %r23
	.word 0xd2f70e40  ! 2885: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0x87802025  ! 2886: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdc0400  ! 2887: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0xd0a5a000  ! 2888: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xd085e000  ! 2890: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	mov	0x28, %r17
	.word 0x87802074  ! 2892: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef649e0  ! 2893: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xd4b40400  ! 2894: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd6848400  ! 2895: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0x87802020  ! 2896: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2897: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd89f2000  ! 2898: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xd6ac8400  ! 2899: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2900: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d72000  ! 2901: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xd4bfa000  ! 2902: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xdcac8400  ! 2903: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xd0be49e0  ! 2904: STDA_R	stda	%r8, [%r25 + %r0] 0x4f
	.word 0xd6f72000  ! 2905: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd0f48400  ! 2906: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xdaae89e0  ! 2907: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xdabc4400  ! 2908: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	mov	0x48, %r26
	.word 0x87802072  ! 2910: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b78e60  ! 2911: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xd887ce60  ! 2912: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r12
	.word 0xdaa689e0  ! 2913: STWA_R	stwa	%r13, [%r26 + %r0] 0x4f
	.word 0xdab70e40  ! 2914: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	mov	0x8, %r19
	.word 0xdade2000  ! 2916: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r13
	.word 0xdacea000  ! 2917: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r13
	.word 0xded74e80  ! 2918: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r15
	.word 0xd296a000  ! 2919: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r9
	.word 0xdc978e80  ! 2920: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	.word 0xd4f48400  ! 2921: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	mov	0x50, %r16
	.word 0x87802020  ! 2923: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab44400  ! 2924: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x10, %r24
	.word 0xd68fe000  ! 2926: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xd8bcc400  ! 2927: STDA_R	stda	%r12, [%r19 + %r0] 0x20
	.word 0xd6bfa000  ! 2928: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 2929: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd697a000  ! 2930: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 2931: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68ce000  ! 2932: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xdcafce40  ! 2933: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0xda9f8e60  ! 2934: LDDA_R	ldda	[%r30, %r0] 0x73, %r13
	.word 0xdabe89e0  ! 2935: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	.word 0xd8bec9e0  ! 2936: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0xdad609e0  ! 2937: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r13
	.word 0xdcace000  ! 2938: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 2939: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2940: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca4a000  ! 2941: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0xdc842000  ! 2942: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0xdcf46000  ! 2943: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcd4e000  ! 2944: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	mov	0x3f8, %r22
	mov	0x3e8, %r23
	.word 0xdcf4a000  ! 2947: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2948: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2949: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29689e0  ! 2950: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	.word 0xd0974e40  ! 2951: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	mov	0x40, %r25
	.word 0xd6a7e000  ! 2953: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd4bd04a0  ! 2954: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	.word 0xd0d72000  ! 2955: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2956: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca40400  ! 2957: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd8bc8400  ! 2958: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	.word 0xd2aee000  ! 2959: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 2960: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3d8, %r20
	mov	0x58, %r16
	.word 0x87802074  ! 2963: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4dfce40  ! 2964: LDXA_R	ldxa	[%r31, %r0] 0x72, %r10
	.word 0xd4ac4400  ! 2965: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	mov	0x7f8, %r20
	.word 0xd49f8e80  ! 2967: LDDA_R	ldda	[%r30, %r0] 0x74, %r10
	.word 0xd8878e80  ! 2968: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r12
	mov	0x3d8, %r22
	mov	0x60, %r27
	mov	0x60, %r19
	.word 0xdcbf4e40  ! 2972: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xd6df0e80  ! 2973: LDXA_R	ldxa	[%r28, %r0] 0x74, %r11
	mov	0x7c0, %r23
	.word 0x87802074  ! 2975: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadfce80  ! 2976: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0x87802072  ! 2977: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r18
	.word 0xd8dec9e0  ! 2979: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	mov	0x0, %r27
	.word 0x87802074  ! 2981: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde842000  ! 2982: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r15
	mov	0x8, %r24
	.word 0xd6f5c4a0  ! 2984: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	.word 0xd8a4c400  ! 2985: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x8, %r25
	mov	0x7c0, %r22
	.word 0xdccd44a0  ! 2988: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	mov	0x18, %r26
	.word 0xd6bf8e40  ! 2990: STDA_R	stda	%r11, [%r30 + %r0] 0x72
	.word 0xd2a4a000  ! 2991: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xdcf70e40  ! 2993: STXA_R	stxa	%r14, [%r28 + %r0] 0x72
	.word 0xd2a42000  ! 2994: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 2995: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2afa000  ! 2996: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xdaa70e60  ! 2997: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xdcf72000  ! 2998: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcf7ce40  ! 2999: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	.word 0x87802074  ! 3000: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r20
	.word 0xd684e000  ! 3002: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0xd0f78e80  ! 3003: STXA_R	stxa	%r8, [%r30 + %r0] 0x74
	.word 0x87802025  ! 3004: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a52000  ! 3005: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xd4af4e80  ! 3006: STBA_R	stba	%r10, [%r29 + %r0] 0x74
	.word 0xdeb56000  ! 3007: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x48, %r27
	.word 0x87802025  ! 3010: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3011: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e0, %r22
	.word 0xdedfe000  ! 3013: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 3014: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xd2b544a0  ! 3015: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	.word 0xdec7e000  ! 3016: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xd6bf8e60  ! 3017: STDA_R	stda	%r11, [%r30 + %r0] 0x73
	.word 0xd487e000  ! 3018: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4ddc4a0  ! 3019: LDXA_R	ldxa	[%r23, %r0] 0x25, %r10
	.word 0x8780204f  ! 3020: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bc6000  ! 3021: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd2c46000  ! 3022: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0x87802025  ! 3023: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2946000  ! 3024: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xdcdcc400  ! 3025: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	mov	0x18, %r17
	mov	0x70, %r19
	.word 0xde970e60  ! 3028: LDUHA_R	lduha	[%r28, %r0] 0x73, %r15
	mov	0x58, %r16
	mov	0x18, %r24
	.word 0x8780204f  ! 3031: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3032: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8e89e0  ! 3033: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r15
	.word 0x87802072  ! 3034: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r17
	mov	0x78, %r19
	mov	0x18, %r16
	mov	0x7d8, %r20
	.word 0xde97a000  ! 3039: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xde9f6000  ! 3040: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3041: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebf6000  ! 3042: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 3043: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r17
	mov	0x3e8, %r21
	.word 0xd8df4e60  ! 3046: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	.word 0xd4afa000  ! 3047: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4d72000  ! 3048: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x7c8, %r20
	.word 0xd4876000  ! 3050: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xdebf8e40  ! 3051: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xd69fe000  ! 3052: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b7a000  ! 3053: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	mov	0x8, %r19
	.word 0xd6d7a000  ! 3055: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xda8d04a0  ! 3056: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	.word 0xd68f6000  ! 3057: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6f4c400  ! 3058: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x3c8, %r22
	.word 0xd2f7e000  ! 3060: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd29d44a0  ! 3061: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	mov	0x3e0, %r23
	.word 0xdacec9e0  ! 3063: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r13
	mov	0x7e0, %r21
	.word 0x87802073  ! 3065: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6c7a000  ! 3066: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6c7a000  ! 3067: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6b7a000  ! 3068: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 3069: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4dcc400  ! 3070: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xded48400  ! 3071: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	mov	0x50, %r16
	mov	0x48, %r25
	.word 0xd0a7a000  ! 3074: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0cfa000  ! 3075: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0b72000  ! 3076: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3077: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0c42000  ! 3079: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0a4e000  ! 3080: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0b4a000  ! 3081: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd89e09e0  ! 3082: LDDA_R	ldda	[%r24, %r0] 0x4f, %r12
	.word 0x87802072  ! 3083: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49f6000  ! 3084: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0x87802074  ! 3085: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ad84a0  ! 3086: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	mov	0x10, %r26
	.word 0xd8af0e80  ! 3088: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	mov	0x48, %r26
	.word 0xd0dd04a0  ! 3090: LDXA_R	ldxa	[%r20, %r0] 0x25, %r8
	mov	0x78, %r25
	.word 0x87802073  ! 3092: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0ae09e0  ! 3093: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 3094: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcf44400  ! 3095: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xd69fa000  ! 3096: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xd8d609e0  ! 3097: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0xd88649e0  ! 3098: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r12
	.word 0x8780204f  ! 3099: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 3100: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8c6000  ! 3101: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	mov	0x10, %r26
	.word 0xd8f584a0  ! 3103: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	mov	0x7c8, %r23
	mov	0x10, %r27
	.word 0xdccc8400  ! 3106: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	mov	0x38, %r18
	.word 0xdc9f0e60  ! 3108: LDDA_R	ldda	[%r28, %r0] 0x73, %r14
	mov	0x68, %r25
	.word 0xd2946000  ! 3110: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2dc6000  ! 3111: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd28c2000  ! 3112: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0x87802074  ! 3113: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f5e000  ! 3114: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xd0cd04a0  ! 3116: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r8
	mov	0x7f8, %r20
	mov	0x3c8, %r20
	.word 0xdcb48400  ! 3119: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0xd8ccc400  ! 3120: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	.word 0xd0f5e000  ! 3121: STXA_I	stxa	%r8, [%r23 + 0x0000] %asi
	.word 0xd0ada000  ! 3122: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xd0bd2000  ! 3124: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd0dd6000  ! 3126: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd09d6000  ! 3127: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0xd297ce80  ! 3128: LDUHA_R	lduha	[%r31, %r0] 0x74, %r9
	.word 0xdebda000  ! 3129: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xdea5a000  ! 3130: STWA_I	stwa	%r15, [%r22 + 0x0000] %asi
	.word 0xdca7ce80  ! 3131: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	mov	0x38, %r26
	.word 0xd0a5a000  ! 3133: STWA_I	stwa	%r8, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 3134: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cfa000  ! 3135: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd69609e0  ! 3136: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r11
	mov	0x18, %r27
	.word 0x87802073  ! 3138: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc8f8e80  ! 3139: LDUBA_R	lduba	[%r30, %r0] 0x74, %r14
	mov	0x7f0, %r21
	mov	0x30, %r25
	mov	0x30, %r16
	.word 0xd8c4c400  ! 3143: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0x87802020  ! 3144: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d4c400  ! 3145: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xdecf8e60  ! 3146: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0x87802072  ! 3147: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d48400  ! 3148: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd2bce000  ! 3149: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2d46000  ! 3150: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xda8c4400  ! 3151: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0x87802073  ! 3152: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b48400  ! 3153: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd4afa000  ! 3154: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	mov	0x30, %r17
	mov	0x58, %r24
	mov	0x68, %r24
	.word 0xd4a7e000  ! 3158: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4bfa000  ! 3159: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xd4cd04a0  ! 3161: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r10
	.word 0xd2c7a000  ! 3162: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2cfa000  ! 3163: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0x87802073  ! 3164: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2ac6000  ! 3165: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd29ce000  ! 3166: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xda8f8e60  ! 3167: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0xd2bc4400  ! 3168: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0x87802025  ! 3169: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r26
	mov	0x3d8, %r20
	.word 0xd696a000  ! 3172: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	mov	0x48, %r19
	.word 0xd2844400  ! 3174: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	mov	0x58, %r27
	mov	0x48, %r18
	.word 0xd6962000  ! 3177: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	.word 0xd6a6a000  ! 3178: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0xd6b62000  ! 3180: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 3181: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3182: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bfa000  ! 3183: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3184: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a78e80  ! 3185: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	mov	0x3d8, %r22
	.word 0xd4af8e60  ! 3187: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xdac4e000  ! 3188: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	mov	0x38, %r26
	.word 0xd8b78e40  ! 3190: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xd2844400  ! 3191: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r9
	.word 0x87802074  ! 3192: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6d584a0  ! 3193: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r11
	.word 0xd2b72000  ! 3194: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd2cfe000  ! 3195: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2bf2000  ! 3196: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x48, %r26
	mov	0x50, %r16
	mov	0x7e0, %r22
	.word 0x87802074  ! 3200: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 3201: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cf6000  ! 3202: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2afa000  ! 3203: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd29f6000  ! 3205: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xdcb7ce60  ! 3206: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xd8d7ce80  ! 3207: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r12
	.word 0xd8f7e000  ! 3208: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8d7e000  ! 3209: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x20, %r26
	.word 0xd8872000  ! 3211: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3212: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbf8e40  ! 3213: STDA_R	stda	%r14, [%r30 + %r0] 0x72
	.word 0xd2ddc4a0  ! 3214: LDXA_R	ldxa	[%r23, %r0] 0x25, %r9
	.word 0xd4bc4400  ! 3215: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0x87802074  ! 3216: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3217: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6afce80  ! 3218: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	mov	0x40, %r17
	.word 0xd4978e60  ! 3220: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0xdaa56000  ! 3221: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xdaf5e000  ! 3223: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0x87802072  ! 3225: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabfe000  ! 3226: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xd0b78e60  ! 3227: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	mov	0x38, %r19
	.word 0xd2f70e40  ! 3229: STXA_R	stxa	%r9, [%r28 + %r0] 0x72
	.word 0xd8bf2000  ! 3230: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8d7a000  ! 3231: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x3f0, %r20
	.word 0xd8d76000  ! 3233: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd6be09e0  ! 3234: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0xd89f4e60  ! 3235: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	.word 0xdc9dc4a0  ! 3236: LDDA_R	ldda	[%r23, %r0] 0x25, %r14
	mov	0x78, %r25
	.word 0xdca40400  ! 3238: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd6f74e60  ! 3239: STXA_R	stxa	%r11, [%r29 + %r0] 0x73
	.word 0xd2cd84a0  ! 3240: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r9
	.word 0xd6876000  ! 3241: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r11
	mov	0x7d8, %r22
	.word 0x8780204f  ! 3243: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3244: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3245: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802073  ! 3247: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69e89e0  ! 3248: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	.word 0xdebea000  ! 3249: STDA_I	stda	%r15, [%r26 + 0x0000] %asi
	.word 0xd4bf4e80  ! 3250: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	.word 0xd0aee000  ! 3251: STBA_I	stba	%r8, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 3252: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bc2000  ! 3253: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0xd084a000  ! 3254: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b4a000  ! 3255: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd0ac2000  ! 3256: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd8b70e80  ! 3257: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	mov	0x18, %r26
	.word 0xd0b649e0  ! 3259: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	mov	0x78, %r17
	mov	0x60, %r19
	mov	0x70, %r16
	.word 0x87802020  ! 3263: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3264: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r18
	mov	0x70, %r18
	.word 0xd4a40400  ! 3267: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xd6a74e60  ! 3268: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2cf0e40  ! 3270: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0x87802020  ! 3271: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf5c4a0  ! 3272: STXA_R	stxa	%r14, [%r23 + %r0] 0x25
	.word 0xd6ac6000  ! 3273: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd6846000  ! 3274: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3276: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r27
	mov	0x70, %r27
	.word 0xd6af6000  ! 3279: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd0b44400  ! 3280: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd4a6c9e0  ! 3281: STWA_R	stwa	%r10, [%r27 + %r0] 0x4f
	.word 0xd48fce40  ! 3282: LDUBA_R	lduba	[%r31, %r0] 0x72, %r10
	.word 0xd0d70e40  ! 3283: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	mov	0x7d8, %r20
	.word 0xdea7e000  ! 3285: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3286: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebfa000  ! 3287: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdeaf2000  ! 3288: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3289: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c40400  ! 3290: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	mov	0x38, %r16
	.word 0x87802073  ! 3292: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c72000  ! 3293: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bf6000  ! 3294: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd687ce80  ! 3295: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r11
	.word 0xdcc72000  ! 3296: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3297: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r21
	.word 0xdca7e000  ! 3299: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xd0ad04a0  ! 3301: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xd297e000  ! 3302: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd29fe000  ! 3303: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd287e000  ! 3304: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r9
	mov	0x18, %r16
	.word 0xda8c0400  ! 3306: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0x87802074  ! 3307: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2ad84a0  ! 3308: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3309: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f584a0  ! 3310: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3311: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ad44a0  ! 3312: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0xdecd04a0  ! 3313: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r15
	.word 0xdea78e80  ! 3314: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	mov	0x70, %r27
	.word 0xd48cc400  ! 3316: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xd6af4e80  ! 3317: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 3318: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa76000  ! 3319: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xdaaf2000  ! 3321: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xda8fa000  ! 3323: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xd4878e80  ! 3324: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	.word 0xdc8fa000  ! 3325: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdaaf4e60  ! 3326: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xdab7e000  ! 3327: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xda9f6000  ! 3328: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdacf2000  ! 3329: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x28, %r17
	.word 0xda8f6000  ! 3331: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xd4d78e80  ! 3332: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0x87802025  ! 3333: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a48400  ! 3334: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0x87802020  ! 3335: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r22
	.word 0xd2afa000  ! 3337: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd29649e0  ! 3338: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r9
	mov	0x60, %r19
	.word 0xdcb544a0  ! 3340: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	mov	0x50, %r27
	.word 0xd8ac0400  ! 3342: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0x87802025  ! 3343: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa48400  ! 3344: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 3345: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e8, %r22
	.word 0xded72000  ! 3347: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdaad04a0  ! 3348: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0xd097e000  ! 3349: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0c7e000  ! 3350: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r8
	mov	0x7f8, %r20
	.word 0xd0cf2000  ! 3352: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0a72000  ! 3353: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xd0b7a000  ! 3355: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3356: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x48, %r18
	.word 0xd08da000  ! 3358: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r8
	.word 0xd8df4e80  ! 3359: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	mov	0x78, %r18
	.word 0xdea44400  ! 3361: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd8b649e0  ! 3362: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	mov	0x7e0, %r23
	mov	0x58, %r24
	.word 0xdea56000  ! 3365: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0xdecd6000  ! 3366: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r15
	.word 0x87802073  ! 3367: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4f74e60  ! 3368: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	.word 0xd4b5c4a0  ! 3369: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0x87802025  ! 3370: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6c584a0  ! 3371: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r11
	.word 0xdab48400  ! 3372: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	mov	0x3e0, %r20
	.word 0xdac4a000  ! 3374: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0xd0c44400  ! 3375: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0xd8ace000  ! 3376: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3377: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x78, %r25
	mov	0x38, %r24
	.word 0xd8d7a000  ! 3380: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8a44400  ! 3381: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0xdabfa000  ! 3382: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdac7a000  ! 3383: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r13
	.word 0xdadf2000  ! 3384: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r13
	mov	0x28, %r27
	.word 0xd6840400  ! 3386: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xdeafe000  ! 3387: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdeb40400  ! 3388: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7e8, %r22
	.word 0xdabf6000  ! 3391: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xda9fa000  ! 3393: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x3c0, %r22
	.word 0x87802073  ! 3395: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0dc8400  ! 3396: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd0f504a0  ! 3397: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xd4cc2000  ! 3398: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd0a6c9e0  ! 3399: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xd0f46000  ! 3400: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xdeb7ce40  ! 3401: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xd68f8e60  ! 3402: LDUBA_R	lduba	[%r30, %r0] 0x73, %r11
	.word 0x87802073  ! 3403: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r24
	.word 0x87802072  ! 3405: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4974e60  ! 3406: LDUHA_R	lduha	[%r29, %r0] 0x73, %r10
	.word 0xd08609e0  ! 3407: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	.word 0x87802073  ! 3408: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d40400  ! 3409: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xd2940400  ! 3410: LDUHA_R	lduha	[%r16, %r0] 0x20, %r9
	.word 0xd0a6a000  ! 3411: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xd0ae2000  ! 3413: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xd2a544a0  ! 3414: STWA_R	stwa	%r9, [%r21 + %r0] 0x25
	mov	0x3d0, %r20
	.word 0xd8974e60  ! 3416: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcc78e60  ! 3418: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r14
	.word 0xdcce6000  ! 3419: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	.word 0x87802073  ! 3420: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r25
	.word 0xdcae6000  ! 3422: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 3423: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r25
	.word 0xdcdc2000  ! 3425: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3426: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9f0e80  ! 3427: LDDA_R	ldda	[%r28, %r0] 0x74, %r15
	.word 0x87802072  ! 3428: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r23
	mov	0x7c0, %r23
	.word 0xd88ca000  ! 3431: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	mov	0x40, %r27
	.word 0x8780204f  ! 3433: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbcc400  ! 3434: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xd6a7a000  ! 3435: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bfe000  ! 3436: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3437: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3438: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r16
	mov	0x58, %r16
	mov	0x3f8, %r23
	.word 0xdebf4e80  ! 3442: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	.word 0xdcf70e60  ! 3443: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xdcc4c400  ! 3444: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xd4c72000  ! 3445: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd48fe000  ! 3446: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xdeacc400  ! 3447: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd0b72000  ! 3448: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 3449: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f72000  ! 3450: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	mov	0x78, %r19
	mov	0x60, %r26
	.word 0xd2ccc400  ! 3453: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	.word 0x87802074  ! 3454: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bc6000  ! 3455: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2a48400  ! 3457: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x3d8, %r21
	.word 0x87802020  ! 3459: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a72000  ! 3460: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4afa000  ! 3461: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3462: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4dce000  ! 3463: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xd48c2000  ! 3464: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0xd49ce000  ! 3465: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd48d04a0  ! 3466: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0xd89c6000  ! 3467: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xd8aca000  ! 3468: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd8946000  ! 3469: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 3470: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 3471: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8d4a000  ! 3472: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0xd6a70e60  ! 3473: STWA_R	stwa	%r11, [%r28 + %r0] 0x73
	.word 0xd2f4c400  ! 3474: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0x87802020  ! 3475: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a609e0  ! 3476: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	mov	0x7c0, %r21
	.word 0xd48f0e80  ! 3478: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0xde8f4e80  ! 3479: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	.word 0xd0be6000  ! 3480: STDA_I	stda	%r8, [%r25 + 0x0000] %asi
	.word 0xd0966000  ! 3481: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r8
	.word 0xde8f4e80  ! 3482: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	mov	0x30, %r19
	.word 0xdeafce80  ! 3484: STBA_R	stba	%r15, [%r31 + %r0] 0x74
	.word 0xd68c8400  ! 3485: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	mov	0x3c0, %r23
	mov	0x20, %r25
	mov	0x70, %r17
	.word 0xd89e2000  ! 3489: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802025  ! 3491: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd894e000  ! 3492: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r12
	.word 0xd8a46000  ! 3493: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xdeb544a0  ! 3494: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0xdcb7ce60  ! 3495: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xdeaca000  ! 3496: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdef46000  ! 3497: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd8d689e0  ! 3498: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r12
	.word 0x87802020  ! 3499: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6b44400  ! 3500: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	.word 0xd8f4c400  ! 3501: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd6aec9e0  ! 3502: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	mov	0x3e8, %r22
	.word 0xd2d76000  ! 3504: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802074  ! 3505: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cf4e60  ! 3506: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r9
	.word 0xdef76000  ! 3507: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xd69f8e60  ! 3509: LDDA_R	ldda	[%r30, %r0] 0x73, %r11
	mov	0x18, %r16
	.word 0xd2b7a000  ! 3511: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd89ec9e0  ! 3512: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	mov	0x38, %r19
	.word 0xdede09e0  ! 3514: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	.word 0xd4876000  ! 3515: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4a76000  ! 3516: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4cf2000  ! 3517: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4f7a000  ! 3518: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3519: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r19
	.word 0xd4c66000  ! 3521: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r10
	mov	0x58, %r17
	.word 0xdcb504a0  ! 3523: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0x87802072  ! 3524: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3525: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebe6000  ! 3526: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 3527: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r27
	.word 0xd0c40400  ! 3529: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	.word 0xd09d04a0  ! 3530: LDDA_R	ldda	[%r20, %r0] 0x25, %r8
	.word 0x87802025  ! 3531: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r17
	.word 0xdeb4e000  ! 3533: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xdadc4400  ! 3535: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xd0acc400  ! 3536: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	mov	0x7c8, %r22
	.word 0xd6bc6000  ! 3538: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 3539: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 3540: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r22
	.word 0x87802074  ! 3542: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bf0e40  ! 3543: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xd6be49e0  ! 3544: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	mov	0x78, %r17
	.word 0xdaf70e60  ! 3546: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xd4a4e000  ! 3547: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xd4bc6000  ! 3549: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd4d42000  ! 3551: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xdc870e40  ! 3552: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r14
	mov	0x68, %r27
	.word 0xd294e000  ! 3554: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2cc2000  ! 3555: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2b4e000  ! 3556: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3557: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabe49e0  ! 3558: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xdadd2000  ! 3559: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3560: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d48400  ! 3561: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0x87802072  ! 3562: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b6e000  ! 3563: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 3564: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0afe000  ! 3565: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x30, %r24
	.word 0xd0a70e60  ! 3567: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	.word 0xdcacc400  ! 3568: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 3570: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3571: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdfe000  ! 3572: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcd7a000  ! 3573: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0xd8c40400  ! 3574: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0x87802025  ! 3575: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd69d6000  ! 3576: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r11
	.word 0xd0a7ce40  ! 3577: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0xd6bd6000  ! 3578: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd685e000  ! 3579: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3580: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68e2000  ! 3581: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	.word 0xd6aee000  ! 3582: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 3583: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r16
	.word 0x8780204f  ! 3585: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd687e000  ! 3586: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6a76000  ! 3587: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd8d78e40  ! 3588: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r12
	.word 0xdaae89e0  ! 3589: STBA_R	stba	%r13, [%r26 + %r0] 0x4f
	.word 0xd4dfe000  ! 3590: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3591: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b7a000  ! 3592: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a76000  ! 3593: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd8f689e0  ! 3594: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 3595: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcbfce40  ! 3596: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xd6d40400  ! 3597: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xd0afce40  ! 3598: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	mov	0x28, %r27
	mov	0x0, %r27
	.word 0xda97e000  ! 3601: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xda976000  ! 3602: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r13
	mov	0x7d0, %r20
	.word 0xda8f0e40  ! 3604: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	.word 0xd4dfa000  ! 3605: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4b7a000  ! 3606: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd48f2000  ! 3607: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	mov	0x48, %r19
	.word 0xd4c7a000  ! 3609: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4972000  ! 3610: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3611: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ace000  ! 3612: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xdcbc8400  ! 3613: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	mov	0x48, %r19
	.word 0x87802074  ! 3615: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3d8, %r22
	mov	0x58, %r16
	.word 0x87802073  ! 3619: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd68cc400  ! 3620: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd0d4c400  ! 3621: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0xd2ae49e0  ! 3622: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	mov	0x7d8, %r22
	.word 0xdadce000  ! 3624: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	mov	0x38, %r27
	mov	0x7e0, %r21
	.word 0xda8c6000  ! 3627: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3628: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68d04a0  ! 3629: LDUBA_R	lduba	[%r20, %r0] 0x25, %r11
	.word 0xd4b5e000  ! 3630: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0xd4ada000  ! 3631: STBA_I	stba	%r10, [%r22 + 0x0000] %asi
	.word 0x8780204f  ! 3632: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r24
	.word 0xd487e000  ! 3634: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xdcbf4e40  ! 3635: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xd2b76000  ! 3636: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0xd2df6000  ! 3637: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xda9e09e0  ! 3638: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	.word 0xda9ec9e0  ! 3639: LDDA_R	ldda	[%r27, %r0] 0x4f, %r13
	.word 0xded7a000  ! 3640: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x7d0, %r23
	ta	T_CHANGE_PRIV	! macro
	.word 0xded72000  ! 3643: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xdecf2000  ! 3644: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdcaf4e40  ! 3645: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0xd8afa000  ! 3646: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3648: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8de2000  ! 3649: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xd8a6a000  ! 3650: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8862000  ! 3651: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	.word 0xd89e2000  ! 3652: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r12
	.word 0xd2ac4400  ! 3653: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	mov	0x20, %r26
	mov	0x3c0, %r23
	.word 0xd0df0e80  ! 3656: LDXA_R	ldxa	[%r28, %r0] 0x74, %r8
	mov	0x3d8, %r23
	.word 0xdaf4c400  ! 3658: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdef6c9e0  ! 3659: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xd4b6c9e0  ! 3660: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd8a6a000  ! 3661: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd0f78e40  ! 3662: STXA_R	stxa	%r8, [%r30 + %r0] 0x72
	mov	0x7c8, %r22
	.word 0xd8b7ce60  ! 3664: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	.word 0xd6c62000  ! 3665: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6a66000  ! 3666: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xdaa78e60  ! 3667: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	.word 0x87802025  ! 3668: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f48400  ! 3669: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd0dfe000  ! 3670: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0xd8d504a0  ! 3671: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0xd8d7a000  ! 3672: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 3674: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88fe000  ! 3675: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0xdcdf0e80  ! 3676: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0xdecc4400  ! 3677: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	mov	0x28, %r26
	.word 0xd6b78e40  ! 3679: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	mov	0x30, %r18
	.word 0xdcf7a000  ! 3681: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 3682: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb7e000  ! 3683: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdcaf6000  ! 3684: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcb72000  ! 3685: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd2c48400  ! 3687: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r9
	.word 0xd487e000  ! 3688: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4cf6000  ! 3689: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3690: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r17
	.word 0xdeb544a0  ! 3692: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0x87802072  ! 3693: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dc4400  ! 3694: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	mov	0x40, %r27
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802074  ! 3697: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r26
	mov	0x68, %r18
	.word 0xd2ae49e0  ! 3700: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xdad76000  ! 3701: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xd2af4e60  ! 3702: STBA_R	stba	%r9, [%r29 + %r0] 0x73
	.word 0xdadcc400  ! 3703: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	mov	0x30, %r25
	.word 0xd487e000  ! 3705: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 3706: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd49f6000  ! 3707: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	mov	0x3d8, %r22
	.word 0xd4f72000  ! 3709: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3710: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3711: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadcc400  ! 3712: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd2af0e80  ! 3713: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0x87802074  ! 3714: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2bd44a0  ! 3715: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xd687e000  ! 3716: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6dc0400  ! 3717: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	mov	0x3f0, %r20
	mov	0x7c0, %r21
	mov	0x18, %r17
	.word 0xdcc44400  ! 3721: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	mov	0x18, %r17
	.word 0xd28c8400  ! 3723: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0x87802073  ! 3724: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bc4400  ! 3725: STDA_R	stda	%r8, [%r17 + %r0] 0x20
	.word 0xd484a000  ! 3726: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r10
	.word 0xd4a46000  ! 3727: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xdaf584a0  ! 3728: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	mov	0x18, %r18
	.word 0xd29f0e80  ! 3730: LDDA_R	ldda	[%r28, %r0] 0x74, %r9
	mov	0x3c0, %r21
	.word 0xd8a4e000  ! 3732: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 3733: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b7a000  ! 3734: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	mov	0x38, %r26
	.word 0x87802072  ! 3736: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3737: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8afce80  ! 3738: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	mov	0x50, %r25
	mov	0x60, %r18
	.word 0x8780204f  ! 3741: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea74e40  ! 3742: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xdaf70e60  ! 3743: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0xd4cc2000  ! 3744: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	mov	0x38, %r24
	.word 0xd4d4e000  ! 3746: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xdcae49e0  ! 3747: STBA_R	stba	%r14, [%r25 + %r0] 0x4f
	mov	0x3c8, %r23
	.word 0xd8dc6000  ! 3749: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3750: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb48400  ! 3751: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xd8a72000  ! 3752: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 3753: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2874e40  ! 3754: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	.word 0xd0c74e40  ! 3755: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	.word 0xd4b7e000  ! 3756: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4a7a000  ! 3757: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd487e000  ! 3758: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4d7e000  ! 3759: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4b72000  ! 3760: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 3761: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 3762: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3763: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r17
	mov	0x3e8, %r21
	.word 0xd486e000  ! 3766: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	mov	0x7e0, %r20
	.word 0xd496a000  ! 3768: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r10
	.word 0xd2d40400  ! 3769: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xd496a000  ! 3770: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r10
	mov	0x18, %r16
	.word 0xd4b6a000  ! 3772: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0xd4c6e000  ! 3773: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r10
	.word 0xdc8ec9e0  ! 3774: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0xd6c62000  ! 3775: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6de2000  ! 3776: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6aee000  ! 3777: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	.word 0xdeb40400  ! 3778: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xd8b48400  ! 3779: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xd4be09e0  ! 3780: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0xd8f74e40  ! 3781: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	mov	0x70, %r24
	mov	0x40, %r27
	.word 0xdcc649e0  ! 3784: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r14
	.word 0xda9f0e60  ! 3785: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	mov	0x8, %r25
	.word 0xdaae2000  ! 3787: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0xdac62000  ! 3788: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r13
	.word 0xdaf62000  ! 3789: STXA_I	stxa	%r13, [%r24 + 0x0000] %asi
	.word 0xd0afce60  ! 3790: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	mov	0x68, %r19
	mov	0x10, %r19
	mov	0x58, %r24
	.word 0xdcb6a000  ! 3794: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	.word 0xdcbe6000  ! 3795: STDA_I	stda	%r14, [%r25 + 0x0000] %asi
	mov	0x3f0, %r21
	.word 0xdea544a0  ! 3797: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	mov	0x3f0, %r20
	.word 0xdcc62000  ! 3799: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r14
	mov	0x38, %r27
	mov	0x70, %r26
	.word 0xdc8ea000  ! 3802: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	mov	0x60, %r25
	.word 0x87802020  ! 3804: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	.word 0x87802020  ! 3806: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3807: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r23
	.word 0xdcdfa000  ! 3809: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3810: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r17
	.word 0xd2a7ce60  ! 3812: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0xd8b44400  ! 3813: STHA_R	stha	%r12, [%r17 + %r0] 0x20
	.word 0xd8c4c400  ! 3814: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0x87802074  ! 3815: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0afce80  ! 3816: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd2bc0400  ! 3817: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xdea48400  ! 3818: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0xdaf70e40  ! 3819: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	.word 0xd6a40400  ! 3820: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xded4e000  ! 3821: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	mov	0x40, %r27
	.word 0xdebc2000  ! 3823: STDA_I	stda	%r15, [%r16 + 0x0000] %asi
	.word 0xdeb4e000  ! 3824: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	.word 0xdeaca000  ! 3825: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 3826: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 3827: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r21
	mov	0x0, %r25
	.word 0xd4b40400  ! 3830: STHA_R	stha	%r10, [%r16 + %r0] 0x20
	.word 0xd6df6000  ! 3831: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xded7ce40  ! 3832: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	mov	0x10, %r18
	.word 0xd4948400  ! 3834: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xdaf72000  ! 3835: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0xdedfce40  ! 3837: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	.word 0xd0b7e000  ! 3838: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a7a000  ! 3839: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd6dd84a0  ! 3840: LDXA_R	ldxa	[%r22, %r0] 0x25, %r11
	ta	T_CHANGE_HPRIV	! macro
	mov	0x38, %r25
	.word 0xdcbfce80  ! 3843: STDA_R	stda	%r14, [%r31 + %r0] 0x74
	.word 0x87802073  ! 3844: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r25
	.word 0x87802074  ! 3846: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r20
	mov	0x60, %r27
	.word 0xd697e000  ! 3849: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0x87802020  ! 3850: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69fa000  ! 3851: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xda86c9e0  ! 3852: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	mov	0x20, %r27
	.word 0x87802025  ! 3854: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdac4e000  ! 3855: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3856: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3857: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r18
	.word 0xda8f2000  ! 3859: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdea4c400  ! 3860: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	.word 0xdc848400  ! 3861: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0x87802020  ! 3862: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r27
	mov	0x18, %r26
	mov	0x7e0, %r23
	.word 0xdab4e000  ! 3866: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xd8ae89e0  ! 3868: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	mov	0x70, %r27
	mov	0x28, %r18
	.word 0xdadca000  ! 3871: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3872: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde874e60  ! 3873: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r15
	.word 0xd4b4a000  ! 3874: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xdedfce40  ! 3875: LDXA_R	ldxa	[%r31, %r0] 0x72, %r15
	mov	0x7f0, %r23
	.word 0xd09e09e0  ! 3877: LDDA_R	ldda	[%r24, %r0] 0x4f, %r8
	.word 0xdacc2000  ! 3878: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xd8cc0400  ! 3879: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	mov	0x3c8, %r22
	.word 0xd4d4e000  ! 3881: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3882: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xded74e40  ! 3883: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r15
	.word 0x87802072  ! 3884: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3885: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x10, %r18
	.word 0xd6f6e000  ! 3887: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 3888: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r18
	.word 0xd6aea000  ! 3890: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	mov	0x70, %r27
	.word 0xd6c62000  ! 3892: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	.word 0xdad689e0  ! 3893: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r13
	.word 0xd4b6a000  ! 3894: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 3895: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r27
	.word 0xd4d6e000  ! 3897: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r10
	.word 0xd4c66000  ! 3898: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r10
	mov	0x20, %r19
	mov	0x30, %r27
	.word 0x87802025  ! 3901: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d7a000  ! 3902: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 3903: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	mov	0x7f0, %r23
	.word 0x87802020  ! 3905: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r25
	.word 0xd0cf8e80  ! 3907: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r8
	.word 0xd4a7e000  ! 3908: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd68689e0  ! 3909: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	.word 0x87802074  ! 3910: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8e6000  ! 3911: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r13
	.word 0xdaa62000  ! 3912: STWA_I	stwa	%r13, [%r24 + 0x0000] %asi
	.word 0xd29f4e80  ! 3913: LDDA_R	ldda	[%r29, %r0] 0x74, %r9
	.word 0x87802073  ! 3914: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea46000  ! 3915: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0xdaac0400  ! 3916: STBA_R	stba	%r13, [%r16 + %r0] 0x20
	mov	0x7e8, %r23
	.word 0xd0df8e40  ! 3918: LDXA_R	ldxa	[%r30, %r0] 0x72, %r8
	.word 0xd2a42000  ! 3919: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0xd8b78e80  ! 3920: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xdc974e60  ! 3921: LDUHA_R	lduha	[%r29, %r0] 0x73, %r14
	mov	0x58, %r26
	.word 0xdccd04a0  ! 3923: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r14
	.word 0xd6ac6000  ! 3924: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd6a42000  ! 3925: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0xd4840400  ! 3926: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xd6f42000  ! 3927: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	mov	0x20, %r24
	.word 0xda978e80  ! 3929: LDUHA_R	lduha	[%r30, %r0] 0x74, %r13
	.word 0xd4b70e40  ! 3930: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xdcaf8e40  ! 3931: STBA_R	stba	%r14, [%r30 + %r0] 0x72
	.word 0xde8ca000  ! 3932: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	.word 0xd8bf0e80  ! 3933: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	.word 0xd4be89e0  ! 3934: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	.word 0xd0b4c400  ! 3935: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd4c46000  ! 3936: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	mov	0x20, %r16
	mov	0x7f0, %r20
	.word 0x87802072  ! 3939: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c8, %r21
	.word 0xd48ca000  ! 3941: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3942: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a52000  ! 3943: STWA_I	stwa	%r10, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 3944: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49c2000  ! 3945: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	mov	0x38, %r17
	.word 0xdea6c9e0  ! 3947: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xdcdc2000  ! 3948: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xdca4a000  ! 3949: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xd6a4c400  ! 3951: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd8ae89e0  ! 3952: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	mov	0x40, %r18
	.word 0xd8ac6000  ! 3954: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3955: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r26
	.word 0xd2b48400  ! 3957: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd0cdc4a0  ! 3958: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r8
	.word 0xd8f62000  ! 3959: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 3960: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r27
	.word 0x8780204f  ! 3962: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaaec9e0  ! 3963: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	.word 0xd68f4e40  ! 3964: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	.word 0xd4bc4400  ! 3965: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd4a7ce40  ! 3966: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	mov	0x20, %r17
	.word 0xd2a7ce60  ! 3968: STWA_R	stwa	%r9, [%r31 + %r0] 0x73
	.word 0xdca76000  ! 3969: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xd0bfce80  ! 3970: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 3972: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4c609e0  ! 3973: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0x87802073  ! 3974: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r18
	.word 0xd2af2000  ! 3976: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2a70e40  ! 3977: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	.word 0xd0dec9e0  ! 3978: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	.word 0x87802072  ! 3979: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3980: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef46000  ! 3981: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0xd49689e0  ! 3982: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r10
	.word 0xdea42000  ! 3983: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 3984: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde876000  ! 3985: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xd6ae09e0  ! 3986: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0x87802025  ! 3987: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4c48400  ! 3988: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r10
	.word 0xde978e60  ! 3989: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	mov	0x60, %r26
	mov	0x50, %r18
	.word 0xdca7ce60  ! 3992: STWA_R	stwa	%r14, [%r31 + %r0] 0x73
	mov	0x58, %r25
	.word 0xd6b504a0  ! 3994: STHA_R	stha	%r11, [%r20 + %r0] 0x25
	.word 0xdca7a000  ! 3995: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xde8f4e60  ! 3996: LDUBA_R	lduba	[%r29, %r0] 0x73, %r15
	.word 0xdcbfe000  ! 3997: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xd4c584a0  ! 3998: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	.word 0xd6878e40  ! 3999: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0xd0afce40  ! 4000: STBA_R	stba	%r8, [%r31 + %r0] 0x72
	mov	0x7c0, %r22
	.word 0xd88f2000  ! 4002: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xdac70e80  ! 4003: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r13
	mov	0x28, %r17
	mov	0x28, %r17
	mov	0x3d0, %r22
	.word 0x87802020  ! 4007: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedf2000  ! 4008: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xde976000  ! 4009: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xdaaf4e40  ! 4010: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xd0dd44a0  ! 4011: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0xd8f76000  ! 4012: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8b76000  ! 4013: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd8af6000  ! 4014: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd6d44400  ! 4015: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0xd4d4c400  ! 4016: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	mov	0x48, %r26
	.word 0xd8a72000  ! 4018: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8af2000  ! 4019: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xd8f72000  ! 4021: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bfe000  ! 4022: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8f48400  ! 4023: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	mov	0x70, %r27
	.word 0x87802074  ! 4025: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r23
	.word 0x87802074  ! 4027: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r27
	.word 0xd2d689e0  ! 4029: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r9
	.word 0xd8c7e000  ! 4030: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd6ae49e0  ! 4031: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	.word 0xda972000  ! 4032: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdaafa000  ! 4033: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xd49fce80  ! 4034: LDDA_R	ldda	[%r31, %r0] 0x74, %r10
	.word 0xd8d40400  ! 4035: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xdc974e40  ! 4036: LDUHA_R	lduha	[%r29, %r0] 0x72, %r14
	.word 0xd2bf8e40  ! 4037: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	mov	0x10, %r16
	mov	0x48, %r19
	.word 0xdaaf2000  ! 4040: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdcdf4e60  ! 4041: LDXA_R	ldxa	[%r29, %r0] 0x73, %r14
	.word 0x87802073  ! 4042: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4aca000  ! 4043: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0x87802020  ! 4045: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcad04a0  ! 4046: STBA_R	stba	%r14, [%r20 + %r0] 0x25
	.word 0x87802020  ! 4047: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc0400  ! 4048: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xd68f8e60  ! 4049: LDUBA_R	lduba	[%r30, %r0] 0x73, %r11
	.word 0xdcbf0e40  ! 4050: STDA_R	stda	%r14, [%r28 + %r0] 0x72
	.word 0xd0dc2000  ! 4051: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r8
	.word 0xdc8fce40  ! 4052: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	mov	0x78, %r19
	.word 0x87802073  ! 4054: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc848400  ! 4055: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	mov	0x58, %r17
	.word 0xdacf0e80  ! 4057: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	.word 0xdedc0400  ! 4058: LDXA_R	ldxa	[%r16, %r0] 0x20, %r15
	mov	0x60, %r17
	.word 0xdcaf2000  ! 4060: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdca7e000  ! 4061: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdccf2000  ! 4062: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	mov	0x30, %r25
	.word 0xdcd72000  ! 4064: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4065: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4066: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca76000  ! 4067: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdeaf4e40  ! 4068: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	mov	0x28, %r26
	.word 0xd88f0e40  ! 4070: LDUBA_R	lduba	[%r28, %r0] 0x72, %r12
	.word 0xd4874e80  ! 4071: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r10
	.word 0xd8c689e0  ! 4072: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r12
	mov	0x18, %r26
	.word 0x87802072  ! 4074: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4075: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6ac0400  ! 4076: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xdadcc400  ! 4077: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd29fe000  ! 4078: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0x87802073  ! 4079: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d48400  ! 4080: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	mov	0x3e0, %r20
	.word 0xdef7a000  ! 4082: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xdabe89e0  ! 4084: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	mov	0x48, %r16
	.word 0xda8f0e60  ! 4086: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	.word 0xd0be09e0  ! 4087: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd0dd44a0  ! 4088: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	mov	0x58, %r25
	mov	0x3f0, %r23
	.word 0x87802072  ! 4091: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a4a000  ! 4092: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd0f689e0  ! 4093: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	mov	0x58, %r26
	.word 0xd094a000  ! 4095: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xdeb689e0  ! 4096: STHA_R	stha	%r15, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 4097: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd884e000  ! 4098: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r12
	.word 0xd4df0e60  ! 4099: LDXA_R	ldxa	[%r28, %r0] 0x73, %r10
	.word 0x87802020  ! 4100: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cd2000  ! 4101: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 4102: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4103: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf4e60  ! 4104: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdabdc4a0  ! 4106: STDA_R	stda	%r13, [%r23 + %r0] 0x25
	.word 0xd28e89e0  ! 4107: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	.word 0xd6f48400  ! 4108: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xdca46000  ! 4109: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 4110: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8d2000  ! 4111: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4112: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbc2000  ! 4113: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdc942000  ! 4114: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0xd2ae89e0  ! 4115: STBA_R	stba	%r9, [%r26 + %r0] 0x4f
	.word 0xdeac6000  ! 4116: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdcd544a0  ! 4117: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r14
	.word 0x87802020  ! 4118: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29ce000  ! 4119: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd2d4a000  ! 4120: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2a46000  ! 4121: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0x87802073  ! 4122: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca4c400  ! 4123: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd0840400  ! 4124: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd8c6e000  ! 4125: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r12
	.word 0xda8c4400  ! 4126: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	mov	0x68, %r16
	.word 0xdab62000  ! 4128: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0xd0844400  ! 4129: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xd2c66000  ! 4130: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r9
	.word 0xd2962000  ! 4131: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r9
	.word 0xd6f6c9e0  ! 4132: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xdaf6e000  ! 4133: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xda8e2000  ! 4134: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r13
	.word 0xdaae2000  ! 4135: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 4136: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdacf2000  ! 4137: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x60, %r17
	mov	0x38, %r24
	.word 0x87802073  ! 4140: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 4141: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8f6000  ! 4142: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xd0ad84a0  ! 4143: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	mov	0x38, %r19
	.word 0xd0b504a0  ! 4145: STHA_R	stha	%r8, [%r20 + %r0] 0x25
	.word 0xd887a000  ! 4146: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xdea6c9e0  ! 4147: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	mov	0x48, %r18
	.word 0xd4af2000  ! 4149: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd48fe000  ! 4150: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd2dfce40  ! 4151: LDXA_R	ldxa	[%r31, %r0] 0x72, %r9
	mov	0x38, %r25
	mov	0x68, %r26
	.word 0xdab78e60  ! 4154: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0xd0cf6000  ! 4155: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	mov	0x58, %r16
	.word 0xd0d7e000  ! 4157: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0xd2ae49e0  ! 4158: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	mov	0x68, %r16
	.word 0xdef72000  ! 4160: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xdebf6000  ! 4161: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xde97e000  ! 4162: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xd6b689e0  ! 4163: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	mov	0x58, %r16
	.word 0xd4af4e60  ! 4165: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	.word 0xd29fe000  ! 4166: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x3c8, %r20
	.word 0x87802072  ! 4168: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d76000  ! 4169: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xdef74e80  ! 4170: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	mov	0x7e0, %r23
	mov	0x30, %r26
	mov	0x58, %r18
	mov	0x38, %r25
	.word 0xd2d504a0  ! 4175: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r9
	mov	0x38, %r19
	.word 0xd0c72000  ! 4177: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xd4f40400  ! 4178: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd2df2000  ! 4179: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r9
	.word 0xd287a000  ! 4180: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2c7a000  ! 4181: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2b7e000  ! 4182: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	mov	0x8, %r25
	mov	0x18, %r26
	.word 0xd2afe000  ! 4185: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd29f2000  ! 4186: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x3f8, %r23
	.word 0xd09649e0  ! 4188: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r8
	.word 0xd68609e0  ! 4189: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r11
	mov	0x3e0, %r21
	.word 0xd6ad84a0  ! 4191: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	.word 0xdec70e60  ! 4192: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r15
	.word 0xdabc4400  ! 4193: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	mov	0x40, %r25
	.word 0xdaae09e0  ! 4195: STBA_R	stba	%r13, [%r24 + %r0] 0x4f
	mov	0x7e8, %r20
	.word 0xd4a76000  ! 4197: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xdea40400  ! 4198: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd2bf2000  ! 4199: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd2af6000  ! 4200: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd28f2000  ! 4201: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd28fa000  ! 4202: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2972000  ! 4203: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	mov	0x18, %r26
	.word 0xd2af6000  ! 4205: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd6f74e80  ! 4206: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	mov	0x3f8, %r23
	mov	0x28, %r25
	.word 0x87802020  ! 4209: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r26
	.word 0xdad7e000  ! 4211: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	mov	0x48, %r25
	.word 0x87802025  ! 4213: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b7ce40  ! 4214: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xd6b4a000  ! 4215: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 4216: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f72000  ! 4217: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0xd6af2000  ! 4219: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xd6a72000  ! 4221: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd69f2000  ! 4222: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	mov	0x3c8, %r22
	.word 0xd4ad44a0  ! 4224: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	.word 0xd6c5c4a0  ! 4225: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r11
	.word 0xda86c9e0  ! 4226: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	mov	0x20, %r25
	mov	0x50, %r26
	.word 0xd0af8e40  ! 4229: STBA_R	stba	%r8, [%r30 + %r0] 0x72
	.word 0x87802020  ! 4230: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4231: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcdf2000  ! 4232: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdab44400  ! 4233: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 4234: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8c0400  ! 4235: LDUBA_R	lduba	[%r16, %r0] 0x20, %r14
	.word 0x87802073  ! 4236: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0d70e40  ! 4237: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xdcf56000  ! 4238: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xdca5a000  ! 4239: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xdcb56000  ! 4241: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 4242: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcb42000  ! 4243: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	mov	0x3e8, %r20
	mov	0x20, %r27
	.word 0xdcbce000  ! 4246: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xd29f4e40  ! 4247: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xd4f544a0  ! 4248: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0xdc84c400  ! 4249: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	mov	0x3c8, %r21
	.word 0xdabc0400  ! 4251: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xd4a544a0  ! 4253: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0xd69f4e40  ! 4254: LDDA_R	ldda	[%r29, %r0] 0x72, %r11
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2848400  ! 4256: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0xdcd4e000  ! 4257: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0x87802020  ! 4258: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r27
	.word 0xdcace000  ! 4260: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 4261: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcad84a0  ! 4262: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xd2a78e80  ! 4263: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	.word 0xdeb78e40  ! 4264: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 4265: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2d72000  ! 4266: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd0b70e80  ! 4267: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	mov	0x20, %r26
	.word 0x8780204f  ! 4269: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf76000  ! 4270: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 4271: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded7ce40  ! 4272: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	mov	0x68, %r24
	.word 0xdcbc8400  ! 4274: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0x87802020  ! 4275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cca000  ! 4276: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r11
	.word 0xd6a4e000  ! 4277: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	mov	0x7d0, %r21
	.word 0xd0afce80  ! 4279: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	mov	0x38, %r19
	mov	0x58, %r18
	.word 0xded42000  ! 4282: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0xdef46000  ! 4283: STXA_I	stxa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 4284: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4285: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r19
	mov	0x38, %r18
	.word 0xd8f44400  ! 4288: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0x87802073  ! 4289: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4af2000  ! 4290: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 4291: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9649e0  ! 4292: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	.word 0xd4f7a000  ! 4293: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd48f2000  ! 4295: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4296: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd485a000  ! 4297: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r10
	.word 0xd6a40400  ! 4298: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x38, %r19
	.word 0xdab504a0  ! 4300: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	mov	0x20, %r18
	.word 0xda8cc400  ! 4302: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0x87802074  ! 4303: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8af6000  ! 4304: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd8d72000  ! 4305: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd2f78e80  ! 4306: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	.word 0xd4bec9e0  ! 4307: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0xdebfa000  ! 4308: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdaa649e0  ! 4309: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xded76000  ! 4310: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xdecfe000  ! 4311: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xd8bfce60  ! 4312: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	.word 0xd89f0e40  ! 4313: LDDA_R	ldda	[%r28, %r0] 0x72, %r12
	.word 0xd2bc4400  ! 4314: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0x87802020  ! 4315: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0af4e40  ! 4316: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	.word 0x87802072  ! 4317: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 4318: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r27
	.word 0x87802020  ! 4320: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdf0e60  ! 4321: LDXA_R	ldxa	[%r28, %r0] 0x73, %r14
	.word 0xd8b7ce80  ! 4322: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	mov	0x7d8, %r22
	.word 0xdcb4a000  ! 4324: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xdcf4e000  ! 4325: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	.word 0xdcb4a000  ! 4326: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0x8780204f  ! 4327: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc842000  ! 4328: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802074  ! 4329: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca62000  ! 4330: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	.word 0xde840400  ! 4331: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 4332: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dfe000  ! 4333: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802074  ! 4334: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r18
	mov	0x3c8, %r21
	.word 0xded4c400  ! 4337: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r15
	.word 0xd29fa000  ! 4338: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	mov	0x3d0, %r21
	.word 0xd4d7ce80  ! 4340: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r10
	.word 0xdcb7e000  ! 4341: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdcb7a000  ! 4342: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdca7e000  ! 4343: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd6c6c9e0  ! 4344: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r11
	.word 0xd69ec9e0  ! 4345: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	mov	0x70, %r17
	.word 0xd8f40400  ! 4347: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	mov	0x38, %r17
	.word 0x87802074  ! 4349: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4350: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6972000  ! 4351: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	mov	0x38, %r26
	.word 0xd6f7a000  ! 4353: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6ce49e0  ! 4354: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	.word 0x87802020  ! 4355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49fa000  ! 4356: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd0c40400  ! 4357: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r8
	mov	0x10, %r26
	mov	0x7d8, %r22
	.word 0xd0f72000  ! 4360: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd89fce40  ! 4361: LDDA_R	ldda	[%r31, %r0] 0x72, %r12
	.word 0xd4a48400  ! 4362: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	mov	0x38, %r25
	.word 0x87802025  ! 4364: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 4365: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcbd04a0  ! 4366: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xdadc2000  ! 4367: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xda94a000  ! 4368: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0x87802074  ! 4369: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4370: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r27
	.word 0xdcc74e60  ! 4372: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	mov	0x30, %r18
	.word 0xde872000  ! 4374: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdec7a000  ! 4375: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0xdea7e000  ! 4376: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 4377: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r17
	.word 0xd6a78e80  ! 4379: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	mov	0x58, %r16
	.word 0xda8ec9e0  ! 4381: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r13
	.word 0xde878e60  ! 4382: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	.word 0xdcbfa000  ! 4383: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd8dd84a0  ! 4384: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0xdeb48400  ! 4385: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	mov	0x68, %r17
	.word 0xd0a4c400  ! 4387: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	mov	0x30, %r18
	.word 0xd8c72000  ! 4389: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8af6000  ! 4390: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 4391: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d76000  ! 4392: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x3d0, %r23
	.word 0xd8974e80  ! 4394: LDUHA_R	lduha	[%r29, %r0] 0x74, %r12
	.word 0x87802072  ! 4395: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r19
	.word 0xdacd6000  ! 4397: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r13
	.word 0xda95a000  ! 4398: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	.word 0xda952000  ! 4399: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4400: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac4400  ! 4401: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd4c4e000  ! 4402: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r10
	mov	0x3d0, %r20
	mov	0x3c8, %r20
	mov	0x7c0, %r22
	.word 0xd0a4c400  ! 4406: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xd2b70e80  ! 4407: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0xdcf74e60  ! 4408: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0xdcbf0e60  ! 4409: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xd48f0e80  ! 4410: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	mov	0x38, %r17
	.word 0xd694e000  ! 4412: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0xd69c6000  ! 4413: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd8cf8e60  ! 4414: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	mov	0x70, %r24
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x8780204f  ! 4417: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8c584a0  ! 4418: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd2c504a0  ! 4420: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r9
	.word 0xdcafe000  ! 4421: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdc87e000  ! 4422: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	mov	0x48, %r25
	.word 0xdcb72000  ! 4424: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdcafe000  ! 4425: STBA_I	stba	%r14, [%r31 + 0x0000] %asi
	.word 0xdc8f2000  ! 4426: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 4427: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdca48400  ! 4428: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xd08649e0  ! 4429: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	.word 0xd2ce89e0  ! 4430: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r9
	mov	0x3e8, %r22
	mov	0x68, %r26
	mov	0x20, %r17
	.word 0xd087a000  ! 4434: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xd4a4c400  ! 4435: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	mov	0x58, %r27
	.word 0xd8f76000  ! 4437: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8f7e000  ! 4438: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd2be49e0  ! 4439: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	.word 0xd8876000  ! 4440: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8876000  ! 4441: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8b76000  ! 4442: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4443: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8bca000  ! 4444: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8b4a000  ! 4445: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xd89c2000  ! 4447: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd4870e60  ! 4448: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	.word 0xda94e000  ! 4449: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r13
	.word 0xdac4e000  ! 4450: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4451: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4452: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x38, %r26
	.word 0xd0bf8e60  ! 4454: STDA_R	stda	%r8, [%r30 + %r0] 0x73
	mov	0x60, %r24
	.word 0xd6b649e0  ! 4456: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xd6df4e40  ! 4457: LDXA_R	ldxa	[%r29, %r0] 0x72, %r11
	.word 0x87802074  ! 4458: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r25
	.word 0xd8af2000  ! 4460: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0xd8f74e60  ! 4461: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	mov	0x48, %r27
	.word 0xdac7e000  ! 4463: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdab7a000  ! 4464: STHA_I	stha	%r13, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 4465: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa7a000  ! 4466: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xda876000  ! 4467: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	mov	0x7e8, %r21
	.word 0x87802074  ! 4469: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b609e0  ! 4470: STHA_R	stha	%r10, [%r24 + %r0] 0x4f
	.word 0xd8962000  ! 4471: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4472: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r16
	.word 0xdcdf4e60  ! 4474: LDXA_R	ldxa	[%r29, %r0] 0x73, %r14
	.word 0xda8689e0  ! 4475: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r13
	.word 0xd8f40400  ! 4476: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0x87802025  ! 4477: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4478: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68e09e0  ! 4479: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r11
	.word 0xd2b44400  ! 4480: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd294a000  ! 4481: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xdeaf0e40  ! 4482: STBA_R	stba	%r15, [%r28 + %r0] 0x72
	.word 0xd2b44400  ! 4483: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd8cf4e80  ! 4484: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	mov	0x7d8, %r21
	.word 0xd8cc8400  ! 4486: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	mov	0x0, %r25
	.word 0x87802020  ! 4488: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaaf4e40  ! 4489: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xd4af2000  ! 4490: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd4df2000  ! 4491: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4df2000  ! 4492: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	mov	0x3f0, %r20
	.word 0xdcae89e0  ! 4494: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	mov	0x7e8, %r20
	.word 0x87802020  ! 4496: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9f6000  ! 4497: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	mov	0x7f0, %r22
	.word 0xdeb7e000  ! 4499: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd0ccc400  ! 4500: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r8
	.word 0xdea70e80  ! 4501: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0xdc9c8400  ! 4502: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	mov	0x28, %r25
	mov	0x78, %r16
	.word 0xdaa7e000  ! 4505: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	mov	0x3d8, %r20
	mov	0x7c8, %r22
	.word 0xdca70e60  ! 4508: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	mov	0x18, %r17
	mov	0x48, %r19
	.word 0xdc970e60  ! 4511: LDUHA_R	lduha	[%r28, %r0] 0x73, %r14
	.word 0x87802074  ! 4512: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8b7a000  ! 4513: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 4514: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd886c9e0  ! 4515: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r12
	.word 0xdcf5e000  ! 4516: STXA_I	stxa	%r14, [%r23 + 0x0000] %asi
	mov	0x18, %r17
	mov	0x68, %r25
	mov	0x48, %r16
	.word 0xdcb5e000  ! 4520: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 4521: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c8, %r22
	.word 0xdc9c2000  ! 4523: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r14
	.word 0xd6f70e80  ! 4524: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	mov	0x3c8, %r22
	mov	0x18, %r24
	.word 0xd4d78e80  ! 4527: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0xdedc8400  ! 4528: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	.word 0xdc8584a0  ! 4529: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r14
	mov	0x0, %r26
	.word 0xdaf70e60  ! 4531: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	mov	0x3d8, %r23
	.word 0xdadcc400  ! 4533: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xd8a42000  ! 4534: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xda9f8e80  ! 4535: LDDA_R	ldda	[%r30, %r0] 0x74, %r13
	mov	0x40, %r26
	.word 0xd2942000  ! 4537: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2aca000  ! 4538: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 4539: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29ca000  ! 4540: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r9
	.word 0xd2b4a000  ! 4541: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 4542: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r24
	.word 0xdaf544a0  ! 4544: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0x8780204f  ! 4545: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a46000  ! 4546: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bce000  ! 4547: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd88f0e60  ! 4548: LDUBA_R	lduba	[%r28, %r0] 0x73, %r12
	.word 0x87802073  ! 4549: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x48, %r27
	.word 0xdebe49e0  ! 4551: STDA_R	stda	%r15, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 4552: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ce49e0  ! 4553: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	mov	0x7c8, %r22
	.word 0xd087a000  ! 4555: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	mov	0x40, %r19
	.word 0x87802025  ! 4557: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r27
	.word 0xd08fa000  ! 4559: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r8
	.word 0xd097e000  ! 4560: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd6a48400  ! 4561: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0x87802072  ! 4562: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29ce000  ! 4563: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xdaa78e60  ! 4564: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	mov	0x70, %r25
	.word 0x87802020  ! 4566: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bf0e60  ! 4567: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	mov	0x18, %r24
	.word 0xd4a78e80  ! 4569: STWA_R	stwa	%r10, [%r30 + %r0] 0x74
	.word 0xd8d7a000  ! 4570: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8a7a000  ! 4571: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xded5c4a0  ! 4572: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r15
	.word 0xd2c5c4a0  ! 4573: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r9
	mov	0x58, %r24
	.word 0xd29fe000  ! 4575: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x3e8, %r22
	mov	0x10, %r24
	mov	0x0, %r27
	.word 0xd2d6c9e0  ! 4579: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r9
	.word 0xda8fa000  ! 4580: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xdabf6000  ! 4581: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd8948400  ! 4582: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0xd8af2000  ! 4583: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 4584: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f7ce40  ! 4585: STXA_R	stxa	%r9, [%r31 + %r0] 0x72
	.word 0x87802020  ! 4586: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0af4e40  ! 4587: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	.word 0x87802020  ! 4588: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb544a0  ! 4589: STHA_R	stha	%r14, [%r21 + %r0] 0x25
	.word 0xd2bf8e40  ! 4590: STDA_R	stda	%r9, [%r30 + %r0] 0x72
	.word 0xdeaf8e60  ! 4591: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	.word 0xd8cd84a0  ! 4592: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r12
	.word 0x87802073  ! 4593: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdac78e60  ! 4594: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r13
	.word 0xd4de49e0  ! 4595: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r10
	mov	0x78, %r25
	mov	0x10, %r18
	.word 0xdeb46000  ! 4598: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 4599: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d4c400  ! 4600: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r10
	.word 0x8780204f  ! 4601: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 4602: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8a504a0  ! 4603: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	mov	0x38, %r16
	.word 0xdeb7a000  ! 4605: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xd0a609e0  ! 4606: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 4607: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r19
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd49e2000  ! 4610: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	.word 0xd4a6e000  ! 4611: STWA_I	stwa	%r10, [%r27 + 0x0000] %asi
	.word 0xd0bf0e40  ! 4612: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xd6d4c400  ! 4613: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r11
	.word 0xd0f689e0  ! 4614: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	mov	0x8, %r25
	.word 0xd4f6a000  ! 4616: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd4f66000  ! 4618: STXA_I	stxa	%r10, [%r25 + 0x0000] %asi
	.word 0xd2ce49e0  ! 4619: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r9
	.word 0xd4df8e60  ! 4620: LDXA_R	ldxa	[%r30, %r0] 0x73, %r10
	.word 0x87802072  ! 4621: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4622: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b6c9e0  ! 4623: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xd0b544a0  ! 4624: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	mov	0x7d0, %r22
	mov	0x28, %r27
	.word 0xd687a000  ! 4627: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0x87802072  ! 4628: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r17
	.word 0xd6a609e0  ! 4630: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 4631: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r17
	.word 0xd287ce60  ! 4633: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r9
	.word 0xd8b544a0  ! 4634: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	mov	0x48, %r27
	.word 0xd0afe000  ! 4636: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd0b7a000  ! 4638: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0af6000  ! 4639: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd6c40400  ! 4640: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r11
	mov	0x38, %r19
	.word 0x8780204f  ! 4642: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r23
	.word 0xda8fe000  ! 4644: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	mov	0x3f8, %r20
	.word 0xdab72000  ! 4646: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xdedd84a0  ! 4647: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	.word 0xda87e000  ! 4648: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xda9f2000  ! 4649: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	mov	0x68, %r26
	.word 0xdacf6000  ! 4651: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r13
	.word 0xda9f2000  ! 4652: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4653: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda952000  ! 4654: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r13
	mov	0x7c8, %r22
	.word 0x8780204f  ! 4656: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bfce60  ! 4657: STDA_R	stda	%r9, [%r31 + %r0] 0x73
	.word 0xdea584a0  ! 4658: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0xd0c70e40  ! 4659: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r8
	.word 0x87802020  ! 4660: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r20
	.word 0xdcf4c400  ! 4662: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	.word 0xdabf8e80  ! 4663: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0xd0b46000  ! 4664: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd0dca000  ! 4665: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xd08c2000  ! 4666: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd09ca000  ! 4667: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b42000  ! 4668: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0f4e000  ! 4670: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0bc2000  ! 4671: STDA_I	stda	%r8, [%r16 + 0x0000] %asi
	.word 0xda970e40  ! 4672: LDUHA_R	lduha	[%r28, %r0] 0x72, %r13
	.word 0x8780204f  ! 4673: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ce2000  ! 4674: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	.word 0xd8b689e0  ! 4675: STHA_R	stha	%r12, [%r26 + %r0] 0x4f
	.word 0xd6cea000  ! 4676: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r11
	mov	0x38, %r18
	mov	0x68, %r24
	mov	0x7f0, %r20
	.word 0x87802074  ! 4680: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2acc400  ! 4681: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0x87802025  ! 4682: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b7ce60  ! 4683: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	.word 0xda9f2000  ! 4684: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0x87802025  ! 4685: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r25
	mov	0x7f8, %r22
	.word 0xd0a544a0  ! 4688: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	mov	0x38, %r24
	.word 0xd2b72000  ! 4690: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdca44400  ! 4692: STWA_R	stwa	%r14, [%r17 + %r0] 0x20
	.word 0xd08fce80  ! 4693: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0xd4878e80  ! 4694: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r10
	mov	0x7d8, %r20
	.word 0xda9544a0  ! 4696: LDUHA_R	lduha	[%r21, %r0] 0x25, %r13
	.word 0xd4bc8400  ! 4697: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd2f40400  ! 4698: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	mov	0x28, %r25
	.word 0xd6af2000  ! 4700: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b76000  ! 4701: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4702: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4703: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc7ce40  ! 4704: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r14
	.word 0xdca62000  ! 4705: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xdcb6a000  ! 4707: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	mov	0x60, %r26
	mov	0x58, %r17
	.word 0xdcae2000  ! 4710: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	mov	0x60, %r18
	mov	0x58, %r17
	.word 0xdec544a0  ! 4713: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	mov	0x10, %r26
	mov	0x38, %r17
	.word 0xd8b6a000  ! 4716: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	mov	0x7c0, %r23
	mov	0x78, %r18
	.word 0x8780204f  ! 4719: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd887a000  ! 4720: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	mov	0x0, %r26
	.word 0xd8a609e0  ! 4722: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0xd0cfce60  ! 4723: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r8
	mov	0x78, %r26
	.word 0x87802074  ! 4725: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6dfce60  ! 4726: LDXA_R	ldxa	[%r31, %r0] 0x73, %r11
	.word 0xd8f78e60  ! 4727: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xd0f76000  ! 4728: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4729: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4730: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 4731: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0bfa000  ! 4732: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	.word 0xd6f5c4a0  ! 4733: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	.word 0xd2f7a000  ! 4734: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xdcb689e0  ! 4735: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0xd0f76000  ! 4736: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd0b76000  ! 4737: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bfa000  ! 4738: STDA_I	stda	%r8, [%r30 + 0x0000] %asi
	mov	0x8, %r26
	.word 0x87802020  ! 4740: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 4741: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0df2000  ! 4742: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xdc8d44a0  ! 4743: LDUBA_R	lduba	[%r21, %r0] 0x25, %r14
	mov	0x78, %r27
	.word 0xd6944400  ! 4745: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0x87802072  ! 4746: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68f0e40  ! 4747: LDUBA_R	lduba	[%r28, %r0] 0x72, %r11
	mov	0x3f8, %r22
	.word 0xdea609e0  ! 4749: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 4750: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd68f4e80  ! 4751: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	mov	0x50, %r17
	mov	0x78, %r27
	.word 0xd6d6e000  ! 4754: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r11
	.word 0x87802072  ! 4755: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8a6c9e0  ! 4756: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	mov	0x40, %r25
	mov	0x7d0, %r22
	.word 0xd4dce000  ! 4759: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xdeb48400  ! 4760: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xdccc4400  ! 4761: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r14
	.word 0xd8842000  ! 4762: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r12
	mov	0x78, %r24
	mov	0x3f8, %r20
	.word 0x87802072  ! 4765: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 4766: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeaf8e60  ! 4767: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	.word 0xd8bf0e80  ! 4768: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	.word 0xdc84c400  ! 4769: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0x87802073  ! 4770: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0ac2000  ! 4771: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd8f74e60  ! 4772: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xdc942000  ! 4773: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	mov	0x7c8, %r22
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcb42000  ! 4776: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0xdccce000  ! 4777: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xdcc74e40  ! 4778: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r14
	mov	0x40, %r19
	.word 0xd49d44a0  ! 4780: LDDA_R	ldda	[%r21, %r0] 0x25, %r10
	.word 0xd0d78e40  ! 4781: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r8
	.word 0xd28c2000  ! 4782: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	mov	0x60, %r19
	.word 0xd2b42000  ! 4784: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 4785: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4786: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29ce000  ! 4787: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd28ca000  ! 4788: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd8cc4400  ! 4789: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r12
	.word 0xd0840400  ! 4790: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd8948400  ! 4791: LDUHA_R	lduha	[%r18, %r0] 0x20, %r12
	.word 0xd2842000  ! 4792: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 4793: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0xd2a42000  ! 4794: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x20, %r19
	mov	0x58, %r25
	mov	0x18, %r16
	.word 0xd2bce000  ! 4798: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd0f40400  ! 4799: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd48e89e0  ! 4800: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xdac584a0  ! 4801: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r13
	.word 0x87802072  ! 4802: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d48400  ! 4803: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r10
	mov	0x3c8, %r22
	mov	0x7c8, %r21
	.word 0xdeace000  ! 4806: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xd2f40400  ! 4807: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd8bc0400  ! 4808: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	mov	0x3e0, %r21
	.word 0xd2842000  ! 4810: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xd8c7ce80  ! 4811: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r12
	.word 0xdcf48400  ! 4812: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xdac48400  ! 4813: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd8f70e80  ! 4814: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xd8b74e40  ! 4815: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0xde84c400  ! 4816: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xda8f4e40  ! 4817: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	.word 0xd89ce000  ! 4818: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd89649e0  ! 4819: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r12
	.word 0xde974e80  ! 4820: LDUHA_R	lduha	[%r29, %r0] 0x74, %r15
	.word 0xd88ca000  ! 4821: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd0b649e0  ! 4822: STHA_R	stha	%r8, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 4823: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x48, %r19
	.word 0xd8ade000  ! 4825: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd88de000  ! 4827: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r12
	.word 0xd2ae49e0  ! 4828: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd0bd44a0  ! 4829: STDA_R	stda	%r8, [%r21 + %r0] 0x25
	.word 0xd8d52000  ! 4830: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8cd2000  ! 4831: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r12
	.word 0xd8bda000  ! 4832: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	mov	0x3c0, %r21
	mov	0x28, %r16
	mov	0x78, %r27
	.word 0xd6be49e0  ! 4836: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xd6bd44a0  ! 4837: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	mov	0x3c0, %r21
	.word 0xd4d5a000  ! 4839: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	mov	0x60, %r19
	mov	0x48, %r17
	.word 0xd4a5e000  ! 4842: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	mov	0x7e0, %r20
	.word 0xd0b7ce60  ! 4844: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd8dd84a0  ! 4845: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0xdaf5e000  ! 4846: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xd0a6c9e0  ! 4847: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	mov	0x40, %r24
	mov	0x50, %r25
	.word 0xdaa584a0  ! 4850: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xd4952000  ! 4851: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r10
	mov	0x3e8, %r20
	.word 0xd48de000  ! 4853: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 4854: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4855: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4bf6000  ! 4856: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xdc8d04a0  ! 4857: LDUBA_R	lduba	[%r20, %r0] 0x25, %r14
	.word 0xd8af8e40  ! 4858: STBA_R	stba	%r12, [%r30 + %r0] 0x72
	mov	0x48, %r26
	mov	0x58, %r17
	.word 0x87802072  ! 4861: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r24
	.word 0xd8b7e000  ! 4863: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 4864: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd48689e0  ! 4866: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r10
	mov	0x8, %r18
	.word 0xd8cf4e60  ! 4868: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	.word 0x87802020  ! 4869: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r23
	.word 0xd2f76000  ! 4871: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0x87802074  ! 4873: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 4874: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2dfa000  ! 4875: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2d72000  ! 4876: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0x87802025  ! 4877: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cce000  ! 4878: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd294a000  ! 4879: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd28ca000  ! 4880: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802074  ! 4881: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4882: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 4883: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded40400  ! 4884: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0xd4a46000  ! 4885: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd4bca000  ! 4886: STDA_I	stda	%r10, [%r18 + 0x0000] %asi
	.word 0xd4bc6000  ! 4887: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd88c4400  ! 4888: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd694e000  ! 4889: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r11
	.word 0xdab504a0  ! 4890: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0x87802020  ! 4891: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded44400  ! 4892: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0xdcae2000  ! 4893: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	mov	0x0, %r26
	.word 0x8780204f  ! 4895: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdade89e0  ! 4896: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r13
	mov	0x0, %r27
	.word 0xd0f5c4a0  ! 4898: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0xd2bf4e80  ! 4899: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0xde956000  ! 4900: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r15
	.word 0xd294c400  ! 4901: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xd4f5a000  ! 4902: STXA_I	stxa	%r10, [%r22 + 0x0000] %asi
	.word 0xd4956000  ! 4903: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0xd6f584a0  ! 4904: STXA_R	stxa	%r11, [%r22 + %r0] 0x25
	.word 0xdece89e0  ! 4905: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	.word 0xd4b78e60  ! 4906: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0x87802025  ! 4907: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7c0, %r23
	.word 0xd0dfce60  ! 4909: LDXA_R	ldxa	[%r31, %r0] 0x73, %r8
	.word 0xdadc2000  ! 4910: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	mov	0x50, %r27
	.word 0xdaa649e0  ! 4912: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	.word 0xd8d46000  ! 4913: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	mov	0x30, %r18
	.word 0xd8d4a000  ! 4915: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	mov	0x20, %r24
	.word 0xda840400  ! 4917: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	mov	0x8, %r24
	.word 0xd88c2000  ! 4919: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd8a42000  ! 4920: STWA_I	stwa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8f4a000  ! 4921: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	mov	0x7f8, %r23
	.word 0xd8a46000  ! 4923: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	mov	0x8, %r25
	.word 0xd28e89e0  ! 4925: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	.word 0xdab4e000  ! 4926: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdab4e000  ! 4927: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4928: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf7a000  ! 4929: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xdabf2000  ! 4931: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	.word 0xde8c8400  ! 4932: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0x87802025  ! 4933: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda96c9e0  ! 4934: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r13
	.word 0xd4b4a000  ! 4935: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4ace000  ! 4936: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xd08e09e0  ! 4937: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	.word 0x87802074  ! 4938: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcaec9e0  ! 4939: STBA_R	stba	%r14, [%r27 + %r0] 0x4f
	mov	0x8, %r26
	.word 0xdaf76000  ! 4941: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xd89f8e40  ! 4942: LDDA_R	ldda	[%r30, %r0] 0x72, %r12
	mov	0x7e8, %r23
	mov	0x7f0, %r23
	.word 0xd4dfa000  ! 4945: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd497a000  ! 4946: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xde8d44a0  ! 4947: LDUBA_R	lduba	[%r21, %r0] 0x25, %r15
	mov	0x30, %r18
	.word 0xd4bfa000  ! 4949: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd2974e40  ! 4950: LDUHA_R	lduha	[%r29, %r0] 0x72, %r9
	.word 0xd2df4e60  ! 4951: LDXA_R	ldxa	[%r29, %r0] 0x73, %r9
	.word 0xde87e000  ! 4952: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd6bc0400  ! 4953: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0x87802073  ! 4954: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c70e80  ! 4955: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r10
	.word 0xd69f0e80  ! 4956: LDDA_R	ldda	[%r28, %r0] 0x74, %r11
	.word 0xd2c4e000  ! 4957: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd2bca000  ! 4958: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd284a000  ! 4959: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd4d40400  ! 4961: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	mov	0x3c0, %r22
	.word 0xd8c70e40  ! 4963: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	.word 0x87802020  ! 4964: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8844400  ! 4965: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xd8bc6000  ! 4966: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8d4e000  ! 4967: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd0f48400  ! 4968: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd0dce000  ! 4969: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd8a78e40  ! 4970: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	.word 0xdc9ec9e0  ! 4971: LDDA_R	ldda	[%r27, %r0] 0x4f, %r14
	.word 0x87802020  ! 4972: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2a6c9e0  ! 4973: STWA_R	stwa	%r9, [%r27 + %r0] 0x4f
	.word 0xd6bc6000  ! 4974: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xdcb6c9e0  ! 4975: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 4976: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r25
	.word 0xd4bce000  ! 4978: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd49ca000  ! 4979: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xdad74e40  ! 4980: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r13
	.word 0x87802020  ! 4981: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ad2000  ! 4982: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	.word 0xd0a52000  ! 4983: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xdabc0400  ! 4984: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	mov	0x3d0, %r21
	.word 0xdaaf8e40  ! 4986: STBA_R	stba	%r13, [%r30 + %r0] 0x72
	.word 0xd8a649e0  ! 4987: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xd0af0e80  ! 4988: STBA_R	stba	%r8, [%r28 + %r0] 0x74
	.word 0xd8bde000  ! 4989: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd28544a0  ! 4991: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	mov	0x7f0, %r23
	mov	0x10, %r24
	.word 0xd2dde000  ! 4994: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r9
	.word 0xd28d6000  ! 4995: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r9
	.word 0x87802072  ! 4996: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bf4e80  ! 4997: STDA_R	stda	%r11, [%r29 + %r0] 0x74
	mov	0x7f8, %r20
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_2:
	.word 0xd4f7ce60  ! 1: STXA_R	stxa	%r10, [%r31 + %r0] 0x73
	.word 0xd68e09e0  ! 2: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r11
	.word 0xdc9ea000  ! 3: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r14
	.word 0xdcc6a000  ! 4: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0xdc96e000  ! 5: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r14
	.word 0xd8ad84a0  ! 6: STBA_R	stba	%r12, [%r22 + %r0] 0x25
	mov	0x20, %r25
	.word 0xd6bf4e40  ! 8: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	mov	0x0, %r24
	.word 0xd6f70e40  ! 10: STXA_R	stxa	%r11, [%r28 + %r0] 0x72
	.word 0xd6f7ce80  ! 11: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xdaa7ce80  ! 12: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	mov	0x38, %r26
	mov	0x28, %r19
	.word 0xd69f4e80  ! 15: LDDA_R	ldda	[%r29, %r0] 0x74, %r11
	mov	0x10, %r16
	.word 0xdcaea000  ! 17: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdc9e6000  ! 18: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	.word 0xdcd6e000  ! 19: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r14
	.word 0xdcc66000  ! 20: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0x87802073  ! 21: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 22: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a48400  ! 23: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	mov	0x3e8, %r20
	.word 0x8780204f  ! 25: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8962000  ! 26: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	mov	0x30, %r18
	.word 0x87802025  ! 28: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f0, %r21
	.word 0xd8ada000  ! 30: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xd2a74e80  ! 31: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xd2af4e40  ! 32: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	mov	0x3f0, %r23
	.word 0xd0df0e40  ! 34: LDXA_R	ldxa	[%r28, %r0] 0x72, %r8
	mov	0x3f0, %r21
	.word 0xdcbcc400  ! 36: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 37: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea44400  ! 38: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0x87802072  ! 39: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r27
	.word 0xdcc74e80  ! 41: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r14
	.word 0xdccf4e80  ! 42: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r14
	mov	0x58, %r19
	.word 0xd6c7ce80  ! 44: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r11
	mov	0x70, %r16
	mov	0x18, %r18
	.word 0x87802020  ! 47: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f4e000  ! 48: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd8cf8e60  ! 49: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	.word 0xd4b42000  ! 50: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 51: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd497e000  ! 52: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r10
	.word 0xd2aec9e0  ! 53: STBA_R	stba	%r9, [%r27 + %r0] 0x4f
	.word 0xdec78e60  ! 54: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	.word 0xdadfce80  ! 55: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0xdaf7a000  ! 56: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xd8a48400  ! 57: STWA_R	stwa	%r12, [%r18 + %r0] 0x20
	.word 0xd4c40400  ! 58: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	mov	0x10, %r25
	.word 0x8780204f  ! 60: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b46000  ! 61: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 62: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r17
	.word 0xd6c4e000  ! 64: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r11
	.word 0xd694a000  ! 65: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	mov	0x7d0, %r21
	.word 0xd8ae49e0  ! 67: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 68: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x10, %r19
	.word 0xd4b6c9e0  ! 70: STHA_R	stha	%r10, [%r27 + %r0] 0x4f
	.word 0xdca7a000  ! 71: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdc87e000  ! 72: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xd4df0e60  ! 73: LDXA_R	ldxa	[%r28, %r0] 0x73, %r10
	.word 0x87802072  ! 74: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 75: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09e6000  ! 76: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r8
	.word 0xdac48400  ! 77: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r13
	.word 0xd0df0e60  ! 78: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0xd28e2000  ! 79: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r9
	.word 0xd2a66000  ! 80: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0xd286a000  ! 81: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0x87802073  ! 82: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28c2000  ! 83: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd284e000  ! 84: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r9
	.word 0xd6944400  ! 85: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	mov	0x78, %r16
	.word 0xde978e60  ! 87: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	mov	0x3f8, %r23
	mov	0x58, %r26
	.word 0xd4d70e60  ! 90: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	.word 0xd6842000  ! 91: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6b46000  ! 92: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd6b46000  ! 93: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd6dce000  ! 94: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r11
	.word 0xd8b48400  ! 95: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xd0c6c9e0  ! 96: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r8
	.word 0xded42000  ! 97: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r15
	.word 0x87802074  ! 98: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda844400  ! 99: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	.word 0xdec584a0  ! 100: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r15
	.word 0xd0878e40  ! 101: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r8
	mov	0x20, %r25
	.word 0x87802025  ! 103: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29dc4a0  ! 104: LDDA_R	ldda	[%r23, %r0] 0x25, %r9
	.word 0xdcdc0400  ! 105: LDXA_R	ldxa	[%r16, %r0] 0x20, %r14
	.word 0xd8d42000  ! 106: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0x8780204f  ! 107: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d5a000  ! 108: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0xdedc4400  ! 109: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xd8a56000  ! 110: STWA_I	stwa	%r12, [%r21 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xd8ada000  ! 112: STBA_I	stba	%r12, [%r22 + 0x0000] %asi
	.word 0xd0d74e60  ! 113: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r8
	mov	0x7e8, %r23
	mov	0x3e8, %r23
	.word 0x87802074  ! 116: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x58, %r24
	.word 0xd8cd04a0  ! 118: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r12
	.word 0xd6b48400  ! 119: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd0bf8e40  ! 120: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	.word 0xdac6e000  ! 121: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r13
	.word 0xdaaee000  ! 122: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xdabe6000  ! 124: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xdaa70e80  ! 125: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xdaa6a000  ! 126: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	.word 0xda96a000  ! 127: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r13
	mov	0x70, %r19
	mov	0x78, %r24
	.word 0x8780204f  ! 130: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda9ee000  ! 131: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0xdab70e40  ! 132: STHA_R	stha	%r13, [%r28 + %r0] 0x72
	mov	0x48, %r17
	mov	0x7c8, %r23
	.word 0xd4a5c4a0  ! 135: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xdeae6000  ! 136: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xdaf6c9e0  ! 137: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0xd2862000  ! 138: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0xd0dc4400  ! 139: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4f78e60  ! 141: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	.word 0x87802072  ! 142: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f62000  ! 143: STXA_I	stxa	%r9, [%r24 + 0x0000] %asi
	mov	0x3c8, %r22
	mov	0x58, %r25
	.word 0xd68c8400  ! 146: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xd8ce2000  ! 147: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	.word 0xd88e6000  ! 148: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8c66000  ! 149: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r12
	.word 0xdca5c4a0  ! 150: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0x87802020  ! 151: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c74e40  ! 152: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r8
	.word 0xd4a46000  ! 153: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd6b4c400  ! 154: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xda8dc4a0  ! 155: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	mov	0x38, %r25
	.word 0x87802073  ! 157: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0a609e0  ! 158: STWA_R	stwa	%r8, [%r24 + %r0] 0x4f
	.word 0xd8872000  ! 159: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xd887e000  ! 160: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8dc0400  ! 161: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xdede89e0  ! 162: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	.word 0xd0bc8400  ! 163: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xda9f6000  ! 164: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	mov	0x7d0, %r20
	.word 0xdabfa000  ! 166: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 167: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaa6a000  ! 168: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	.word 0xd4a44400  ! 169: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xd2f44400  ! 170: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	mov	0x3f0, %r20
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4b6e000  ! 173: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	.word 0xd4ae6000  ! 174: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd4dea000  ! 175: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd4aea000  ! 176: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xdaf6c9e0  ! 177: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0xdc96e000  ! 178: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r14
	.word 0xdc866000  ! 179: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0xd6f4c400  ! 180: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x58, %r27
	mov	0x7c0, %r20
	.word 0xd0a48400  ! 183: STWA_R	stwa	%r8, [%r18 + %r0] 0x20
	mov	0x78, %r18
	mov	0x7d0, %r21
	.word 0x87802074  ! 186: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7e8, %r22
	.word 0x87802025  ! 189: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r16
	.word 0xd8a504a0  ! 191: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	mov	0x58, %r27
	mov	0x68, %r26
	.word 0xd2af8e40  ! 194: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xd0b6e000  ! 195: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0xd89f0e60  ! 196: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	.word 0xda86e000  ! 197: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r13
	.word 0xdaa66000  ! 198: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xdeb7ce60  ! 199: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xdaae6000  ! 200: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	.word 0xd0a7ce40  ! 201: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0xd4be6000  ! 202: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xd4dee000  ! 204: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r10
	.word 0xd4cee000  ! 205: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r10
	mov	0x70, %r18
	mov	0x28, %r25
	mov	0x20, %r19
	mov	0x30, %r27
	mov	0x3f8, %r21
	.word 0xd4f7ce40  ! 211: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0xd0f6e000  ! 212: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0a6e000  ! 213: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0f70e40  ! 214: STXA_R	stxa	%r8, [%r28 + %r0] 0x72
	.word 0xde9f0e60  ! 215: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	.word 0xd6cec9e0  ! 216: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	.word 0xd6d70e80  ! 217: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	mov	0x30, %r24
	.word 0xde962000  ! 219: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r15
	mov	0x7c0, %r22
	.word 0xdeb6a000  ! 221: STHA_I	stha	%r15, [%r26 + 0x0000] %asi
	.word 0xde86a000  ! 222: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r15
	mov	0x0, %r18
	.word 0x87802020  ! 224: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdef42000  ! 226: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xde942000  ! 227: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r15
	.word 0x87802025  ! 228: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeac2000  ! 229: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xd6b689e0  ! 230: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdea74e40  ! 232: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	.word 0xd4a4e000  ! 233: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4b4a000  ! 234: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4a46000  ! 235: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd48c2000  ! 236: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0xd4d44400  ! 237: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0xdacd84a0  ! 238: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r13
	mov	0x7c8, %r21
	.word 0xd28c2000  ! 240: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2f46000  ! 241: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd6a4c400  ! 242: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	mov	0x3f0, %r23
	.word 0xdcdec9e0  ! 244: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0xd28f4e80  ! 245: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	mov	0x7c0, %r23
	.word 0xdccc2000  ! 247: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r14
	mov	0x28, %r26
	mov	0x38, %r16
	.word 0xdca42000  ! 250: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 251: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd897ce40  ! 252: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	mov	0x7d8, %r23
	.word 0xdca4c400  ! 254: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd49c2000  ! 255: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0xdc974e80  ! 256: LDUHA_R	lduha	[%r29, %r0] 0x74, %r14
	.word 0xd69f8e80  ! 257: LDDA_R	ldda	[%r30, %r0] 0x74, %r11
	mov	0x8, %r16
	.word 0xde9c4400  ! 259: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdec544a0  ! 261: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0x8780204f  ! 262: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f0, %r21
	mov	0x10, %r16
	.word 0xdaf4e000  ! 265: STXA_I	stxa	%r13, [%r19 + 0x0000] %asi
	.word 0xd69c4400  ! 266: LDDA_R	ldda	[%r17, %r0] 0x20, %r11
	.word 0xd69c8400  ! 267: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	.word 0xd294a000  ! 268: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2c4a000  ! 269: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	mov	0x3f0, %r23
	.word 0xd2cc6000  ! 271: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r9
	.word 0xd2ac6000  ! 272: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 273: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09f0e60  ! 274: LDDA_R	ldda	[%r28, %r0] 0x73, %r8
	mov	0x18, %r25
	.word 0xd6f48400  ! 276: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd6f7a000  ! 277: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	mov	0x30, %r27
	.word 0xdcc609e0  ! 279: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	.word 0xdeaf2000  ! 280: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0xd48cc400  ! 282: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xd8a7e000  ! 283: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cfe000  ! 284: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	mov	0x7d0, %r23
	.word 0xd88fe000  ! 286: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r12
	.word 0x87802073  ! 287: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcaf8e60  ! 288: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	.word 0x87802020  ! 289: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r18
	.word 0xdaaf8e80  ! 291: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0xd8bca000  ! 292: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xdc870e80  ! 293: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r14
	mov	0x10, %r24
	.word 0xdab4c400  ! 295: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0x87802072  ! 296: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 297: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 298: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r16
	.word 0xdcdc6000  ! 300: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcf48400  ! 301: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	.word 0xd6b609e0  ! 302: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	mov	0x7f8, %r22
	mov	0x7c0, %r23
	.word 0xd0d42000  ! 305: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0x87802025  ! 306: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdabe89e0  ! 307: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	mov	0x7d8, %r21
	.word 0xdcbfce40  ! 309: STDA_R	stda	%r14, [%r31 + %r0] 0x72
	.word 0xd2c689e0  ! 310: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0x8780204f  ! 311: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2a44400  ! 313: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	mov	0x10, %r18
	.word 0xd0dfa000  ! 315: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0df6000  ! 316: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 317: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a6e000  ! 318: STWA_I	stwa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0f6a000  ! 319: STXA_I	stxa	%r8, [%r26 + 0x0000] %asi
	.word 0xdca4c400  ! 320: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x20, %r26
	.word 0xd8c70e80  ! 322: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r12
	.word 0x87802072  ! 323: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd09e89e0  ! 324: LDDA_R	ldda	[%r26, %r0] 0x4f, %r8
	mov	0x48, %r27
	.word 0xd6f76000  ! 326: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xd886c9e0  ! 328: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r12
	.word 0x87802020  ! 329: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r27
	mov	0x8, %r27
	.word 0x87802020  ! 332: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d7a000  ! 333: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 334: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6df2000  ! 335: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd2ad44a0  ! 336: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	mov	0x50, %r16
	.word 0xde9fa000  ! 338: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r15
	.word 0xdcafce40  ! 339: STBA_R	stba	%r14, [%r31 + %r0] 0x72
	.word 0x87802020  ! 340: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r18
	.word 0xd6bfa000  ! 342: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	mov	0x7d0, %r23
	.word 0xd2a78e40  ! 344: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	mov	0x38, %r18
	mov	0x0, %r19
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdcce09e0  ! 348: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r14
	.word 0xdef7e000  ! 349: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdeaf2000  ! 350: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd4b7ce80  ! 351: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0xd09dc4a0  ! 352: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xd4dfe000  ! 353: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0x87802025  ! 354: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x8, %r19
	mov	0x30, %r24
	.word 0x8780204f  ! 358: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b46000  ! 359: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xdc970e80  ! 360: LDUHA_R	lduha	[%r28, %r0] 0x74, %r14
	.word 0xda9ca000  ! 361: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r13
	.word 0xdad4e000  ! 362: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xdab4a000  ! 363: STHA_I	stha	%r13, [%r18 + 0x0000] %asi
	.word 0xdaaca000  ! 364: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdacce000  ! 365: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0x87802072  ! 366: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r17
	.word 0xdcbc8400  ! 368: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd0f74e80  ! 369: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd6af4e40  ! 370: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0xd4a7e000  ! 371: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 372: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4ade000  ! 373: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	.word 0xd6ce49e0  ! 374: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r11
	mov	0x7d8, %r20
	.word 0xd4bd2000  ! 376: STDA_I	stda	%r10, [%r20 + 0x0000] %asi
	.word 0xd8c7ce60  ! 377: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	.word 0x87802074  ! 378: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r17
	.word 0xd8de2000  ! 380: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xd0cec9e0  ! 381: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r8
	.word 0xd6de2000  ! 382: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6dee000  ! 383: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	.word 0xda878e80  ! 384: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r13
	.word 0xdabe09e0  ! 385: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 386: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 387: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2a40400  ! 388: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xded689e0  ! 389: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r15
	.word 0xd8f78e60  ! 390: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xda8c0400  ! 391: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0x87802074  ! 392: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6bd6000  ! 393: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6b7ce40  ! 394: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	mov	0x3c8, %r20
	.word 0xd4be89e0  ! 396: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	.word 0xd29da000  ! 397: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r9
	.word 0xd2bde000  ! 398: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 399: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdea70e80  ! 400: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0xd09dc4a0  ! 401: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	mov	0x7e0, %r22
	.word 0x87802074  ! 403: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde844400  ! 404: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xdc8e89e0  ! 405: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r14
	.word 0xd2a72000  ! 406: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	.word 0xdacfce40  ! 407: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	.word 0xd6b609e0  ! 408: STHA_R	stha	%r11, [%r24 + %r0] 0x4f
	.word 0xdef7e000  ! 409: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x30, %r26
	.word 0xde9f2000  ! 411: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0x87802020  ! 412: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde87e000  ! 413: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdab74e80  ! 414: STHA_R	stha	%r13, [%r29 + %r0] 0x74
	.word 0xd2a48400  ! 415: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xd89c8400  ! 416: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	.word 0xdea544a0  ! 417: STWA_R	stwa	%r15, [%r21 + %r0] 0x25
	.word 0xdaac4400  ! 418: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0xdc97ce40  ! 419: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	.word 0xd0ac8400  ! 420: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xdaa7e000  ! 421: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xda97a000  ! 422: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdadfe000  ! 423: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802074  ! 424: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r23
	.word 0xdab78e60  ! 426: STHA_R	stha	%r13, [%r30 + %r0] 0x73
	.word 0xd4d584a0  ! 427: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r10
	.word 0x8780204f  ! 428: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r25
	.word 0x87802072  ! 430: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 431: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde9f8e80  ! 432: LDDA_R	ldda	[%r30, %r0] 0x74, %r15
	mov	0x8, %r26
	.word 0xd0dfce60  ! 434: LDXA_R	ldxa	[%r31, %r0] 0x73, %r8
	.word 0xdcc584a0  ! 435: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0xd4dc0400  ! 436: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0xda9cc400  ! 437: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xd2942000  ! 438: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2f46000  ! 439: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bc6000  ! 440: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 441: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 442: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cfa000  ! 443: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f76000  ! 444: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xda840400  ! 445: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r13
	mov	0x0, %r16
	mov	0x7c8, %r22
	.word 0xdecf8e40  ! 448: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r15
	.word 0xde8f4e60  ! 449: LDUBA_R	lduba	[%r29, %r0] 0x73, %r15
	.word 0xd4f7e000  ! 450: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 451: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4d52000  ! 452: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	.word 0xd4ade000  ! 453: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	.word 0xd4ade000  ! 454: STBA_I	stba	%r10, [%r23 + 0x0000] %asi
	.word 0xd4b78e60  ! 455: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xd0bd04a0  ! 456: STDA_R	stda	%r8, [%r20 + %r0] 0x25
	.word 0xd2ad6000  ! 457: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd8af4e80  ! 458: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	mov	0x7c0, %r22
	.word 0xdec78e40  ! 460: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r15
	.word 0xd8870e60  ! 461: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r12
	mov	0x7e0, %r20
	.word 0xd8b48400  ! 463: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xdab56000  ! 464: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xdaad2000  ! 465: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xd89c4400  ! 466: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	mov	0x30, %r19
	.word 0xdedd84a0  ! 468: LDXA_R	ldxa	[%r22, %r0] 0x25, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd885a000  ! 470: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r12
	.word 0xd4afce40  ! 471: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	mov	0x3f0, %r21
	.word 0xdcbf4e60  ! 473: STDA_R	stda	%r14, [%r29 + %r0] 0x73
	.word 0xd2ada000  ! 474: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xd0f504a0  ! 475: STXA_R	stxa	%r8, [%r20 + %r0] 0x25
	.word 0xd89de000  ! 476: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	mov	0x8, %r19
	.word 0xd8af0e80  ! 478: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	.word 0xd4c7ce80  ! 479: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xd2a40400  ! 480: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd0ada000  ! 481: STBA_I	stba	%r8, [%r22 + 0x0000] %asi
	.word 0xd2bf0e80  ! 482: STDA_R	stda	%r9, [%r28 + %r0] 0x74
	.word 0xd2ada000  ! 483: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xdea78e80  ! 484: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	mov	0x3f8, %r21
	.word 0xd4c40400  ! 486: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xdcbda000  ! 487: STDA_I	stda	%r14, [%r22 + 0x0000] %asi
	.word 0xdc9d6000  ! 488: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r14
	mov	0x8, %r25
	.word 0xd09e49e0  ! 490: LDDA_R	ldda	[%r25, %r0] 0x4f, %r8
	.word 0xd69e89e0  ! 491: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	.word 0x87802073  ! 492: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeb46000  ! 493: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 494: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde87a000  ! 495: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd0bd84a0  ! 496: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd4b76000  ! 497: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4cf6000  ! 498: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	.word 0xdcb4c400  ! 499: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xd69fe000  ! 500: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd2a74e80  ! 501: STWA_R	stwa	%r9, [%r29 + %r0] 0x74
	.word 0xd0ac8400  ! 502: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xd8d6c9e0  ! 503: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0xd28fa000  ! 504: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xdabe09e0  ! 505: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	mov	0x60, %r19
	.word 0xd6ddc4a0  ! 507: LDXA_R	ldxa	[%r23, %r0] 0x25, %r11
	.word 0xd0bdc4a0  ! 508: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xd0f7a000  ! 509: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0bf6000  ! 510: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xd6d48400  ! 511: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0xd6b7e000  ! 512: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd6afe000  ! 514: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xd2ac4400  ! 516: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd6b7e000  ! 517: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xd6d7a000  ! 518: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	mov	0x18, %r16
	.word 0x87802020  ! 520: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cc6000  ! 521: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	mov	0x60, %r27
	.word 0xd6f42000  ! 523: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	mov	0x20, %r27
	mov	0x78, %r25
	mov	0x48, %r25
	mov	0x28, %r16
	mov	0x40, %r18
	.word 0xd6cce000  ! 529: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	mov	0x3d0, %r23
	.word 0xd28d44a0  ! 531: LDUBA_R	lduba	[%r21, %r0] 0x25, %r9
	.word 0xd295c4a0  ! 532: LDUHA_R	lduha	[%r23, %r0] 0x25, %r9
	.word 0x87802020  ! 533: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8af4e60  ! 534: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	.word 0xd8bf6000  ! 535: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd2ac4400  ! 536: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xdadd44a0  ! 537: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	mov	0x3f8, %r20
	.word 0x87802025  ! 539: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd28f6000  ! 540: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd8b74e80  ! 541: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xd2948400  ! 542: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xde8fe000  ! 543: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xd6bc8400  ! 544: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd2d7a000  ! 545: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xd2a7e000  ! 546: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	mov	0x60, %r27
	.word 0xdca40400  ! 548: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	mov	0x3e0, %r22
	mov	0x28, %r24
	.word 0xd8bfe000  ! 551: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x50, %r17
	.word 0xd4bc8400  ! 553: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xdecf6000  ! 554: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xdc8d84a0  ! 555: LDUBA_R	lduba	[%r22, %r0] 0x25, %r14
	.word 0x87802072  ! 556: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r17
	.word 0xd4870e40  ! 558: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	.word 0xd8af6000  ! 559: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd8d76000  ! 560: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd6940400  ! 561: LDUHA_R	lduha	[%r16, %r0] 0x20, %r11
	.word 0xd2b48400  ! 562: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	mov	0x50, %r18
	.word 0xdabe49e0  ! 564: STDA_R	stda	%r13, [%r25 + %r0] 0x4f
	.word 0xd8b609e0  ! 565: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0xdcbfa000  ! 566: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 567: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 568: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0b74e80  ! 569: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xd8b78e40  ! 570: STHA_R	stha	%r12, [%r30 + %r0] 0x72
	.word 0xd2bd2000  ! 571: STDA_I	stda	%r9, [%r20 + 0x0000] %asi
	.word 0xd0a78e40  ! 572: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	mov	0x48, %r24
	mov	0x7e0, %r21
	.word 0xd0940400  ! 575: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0x87802074  ! 576: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cf6000  ! 577: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x58, %r24
	.word 0xd28fce80  ! 579: LDUBA_R	lduba	[%r31, %r0] 0x74, %r9
	.word 0xd897a000  ! 580: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8f7e000  ! 581: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	mov	0x7d0, %r20
	mov	0x18, %r27
	.word 0xd8af2000  ! 584: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xda8dc4a0  ! 586: LDUBA_R	lduba	[%r23, %r0] 0x25, %r13
	.word 0xd4876000  ! 587: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd0870e60  ! 588: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r8
	.word 0xdabfa000  ! 589: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 590: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a78e60  ! 591: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0x87802025  ! 592: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r27
	.word 0xdeaf2000  ! 594: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd8cf4e40  ! 595: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r12
	.word 0xde940400  ! 596: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xde8609e0  ! 597: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r15
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x68, %r18
	.word 0xdabfce80  ! 600: STDA_R	stda	%r13, [%r31 + %r0] 0x74
	.word 0xdaa40400  ! 601: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xdea7e000  ! 602: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x7c0, %r22
	.word 0x87802074  ! 604: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 605: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedda000  ! 606: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r15
	mov	0x78, %r17
	.word 0x87802020  ! 608: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r20
	mov	0x20, %r26
	.word 0x87802074  ! 611: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ccc400  ! 612: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0xdcb649e0  ! 613: STHA_R	stha	%r14, [%r25 + %r0] 0x4f
	.word 0xd09f8e40  ! 614: LDDA_R	ldda	[%r30, %r0] 0x72, %r8
	.word 0xdaf70e60  ! 615: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0x87802072  ! 616: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0ae2000  ! 617: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xd0970e80  ! 618: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	.word 0xd6aea000  ! 619: STBA_I	stba	%r11, [%r26 + 0x0000] %asi
	.word 0x87802074  ! 620: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cfe000  ! 621: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0xd6bf2000  ! 622: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cfa000  ! 623: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd6df2000  ! 624: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	mov	0x0, %r19
	.word 0xd6976000  ! 626: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xded48400  ! 627: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r15
	.word 0xdc97a000  ! 628: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xde870e40  ! 629: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r15
	.word 0x87802025  ! 630: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0afce80  ! 631: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	.word 0xd2dfe000  ! 632: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x70, %r16
	mov	0x68, %r18
	.word 0xd2bf6000  ! 635: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 636: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6be49e0  ! 637: STDA_R	stda	%r11, [%r25 + %r0] 0x4f
	.word 0xdcbf0e60  ! 638: STDA_R	stda	%r14, [%r28 + %r0] 0x73
	.word 0xd08e89e0  ! 639: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r8
	mov	0x3e8, %r22
	mov	0x0, %r18
	.word 0xd2870e60  ! 642: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r9
	.word 0xda8f8e60  ! 643: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0x87802074  ! 644: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8fa000  ! 645: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdec7a000  ! 646: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 647: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bfce80  ! 648: STDA_R	stda	%r9, [%r31 + %r0] 0x74
	.word 0xd4bf0e60  ! 649: STDA_R	stda	%r10, [%r28 + %r0] 0x73
	mov	0x78, %r24
	.word 0x8780204f  ! 651: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 652: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb7a000  ! 653: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x8, %r19
	.word 0x87802020  ! 655: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r23
	.word 0xdeb7e000  ! 657: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdadd44a0  ! 658: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	.word 0xd49f6000  ! 659: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd4df2000  ! 660: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xda8c0400  ! 661: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xdca70e60  ! 662: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xd4b7ce40  ! 663: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	.word 0xd0bfe000  ! 664: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	mov	0x28, %r16
	.word 0xd2f70e60  ! 666: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xd2972000  ! 667: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xde840400  ! 668: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	mov	0x0, %r24
	.word 0xdcd7ce80  ! 670: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	mov	0x68, %r19
	.word 0xdcafa000  ! 672: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdcc40400  ! 673: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r14
	.word 0xdcae89e0  ! 674: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 675: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r17
	.word 0xdaa70e60  ! 677: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xdaac2000  ! 678: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 679: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaf4a000  ! 680: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 681: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0df8e80  ! 682: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	.word 0xd0c74e80  ! 683: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	.word 0xdec78e60  ! 684: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r15
	.word 0xd2c7ce40  ! 685: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r9
	mov	0x3e0, %r20
	.word 0xdcd74e40  ! 687: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	.word 0xd8f5c4a0  ! 688: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xd285a000  ! 689: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r9
	.word 0xd4a689e0  ! 690: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	mov	0x3f0, %r21
	.word 0xd49de000  ! 692: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r10
	.word 0xd4c504a0  ! 693: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r10
	.word 0x8780204f  ! 694: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 695: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde8dc4a0  ! 696: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xdcb4a000  ! 697: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xde878e40  ! 698: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r15
	.word 0xd8ac6000  ! 699: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 700: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88ec9e0  ! 701: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	mov	0x3f0, %r23
	.word 0xd8c70e40  ! 703: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r12
	.word 0xd4d7a000  ! 704: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4f72000  ! 705: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4a7a000  ! 706: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd8f689e0  ! 707: STXA_R	stxa	%r12, [%r26 + %r0] 0x4f
	.word 0xd4a7a000  ! 708: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 709: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x20, %r19
	.word 0xd4d76000  ! 711: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xdc848400  ! 712: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	mov	0x38, %r24
	.word 0xd8bd44a0  ! 714: STDA_R	stda	%r12, [%r21 + %r0] 0x25
	.word 0xdcb72000  ! 715: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 716: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf4a000  ! 717: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	mov	0x8, %r16
	mov	0x30, %r26
	.word 0xdcf46000  ! 720: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcace000  ! 721: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xd29d84a0  ! 722: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xdad46000  ! 723: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xda8c2000  ! 724: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r13
	.word 0x87802020  ! 725: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8fce60  ! 726: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	mov	0x48, %r17
	.word 0xd6952000  ! 728: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0xd6dd2000  ! 729: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	.word 0xd6d52000  ! 730: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r11
	.word 0xd8b70e40  ! 731: STHA_R	stha	%r12, [%r28 + %r0] 0x72
	.word 0xdaa78e80  ! 732: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	.word 0xd4b48400  ! 733: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0x87802020  ! 734: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29e89e0  ! 735: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	.word 0xdcbca000  ! 736: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdc8c6000  ! 737: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 738: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x58, %r19
	.word 0xd8b48400  ! 740: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xde95a000  ! 741: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r15
	.word 0xde956000  ! 742: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r15
	.word 0xdebd2000  ! 743: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xdec5a000  ! 745: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r15
	mov	0x7e0, %r22
	.word 0x8780204f  ! 747: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x8, %r24
	.word 0xde940400  ! 749: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	mov	0x8, %r24
	.word 0xdebda000  ! 751: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xdebd6000  ! 752: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 753: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf8e80  ! 754: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	mov	0x3d8, %r21
	.word 0xdeafe000  ! 756: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xdea7e000  ! 757: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xde872000  ! 758: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdef7e000  ! 759: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd6f78e80  ! 760: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0xd8afe000  ! 761: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 762: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88da000  ! 763: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r12
	.word 0xdea44400  ! 764: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	mov	0x30, %r24
	mov	0x30, %r16
	mov	0x40, %r17
	.word 0xdead04a0  ! 768: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0xd6bde000  ! 769: STDA_I	stda	%r11, [%r23 + 0x0000] %asi
	mov	0x3f0, %r21
	mov	0x48, %r17
	.word 0xde878e60  ! 772: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r15
	.word 0xd4d44400  ! 773: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0x87802020  ! 774: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ac0400  ! 775: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0xd8b4a000  ! 776: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd6af0e40  ! 777: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xd2ace000  ! 778: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0x8780204f  ! 779: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdecf0e60  ! 780: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0xd4bf2000  ! 781: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd49e89e0  ! 782: LDDA_R	ldda	[%r26, %r0] 0x4f, %r10
	.word 0xd4a689e0  ! 783: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	.word 0xd4f504a0  ! 784: STXA_R	stxa	%r10, [%r20 + %r0] 0x25
	mov	0x68, %r27
	.word 0xd29cc400  ! 786: LDDA_R	ldda	[%r19, %r0] 0x20, %r9
	.word 0xdacf4e80  ! 787: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r13
	.word 0xdca7e000  ! 788: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd2bfce40  ! 789: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xd4a72000  ! 790: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd0bec9e0  ! 791: STDA_R	stda	%r8, [%r27 + %r0] 0x4f
	.word 0xde8fa000  ! 792: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802020  ! 793: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 794: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdef6e000  ! 795: STXA_I	stxa	%r15, [%r27 + 0x0000] %asi
	.word 0xd8f6c9e0  ! 796: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0xdcb6a000  ! 797: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 798: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd49504a0  ! 799: LDUHA_R	lduha	[%r20, %r0] 0x25, %r10
	mov	0x70, %r27
	mov	0x3e8, %r22
	.word 0xdcdca000  ! 802: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xd2b584a0  ! 803: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd4f4a000  ! 804: STXA_I	stxa	%r10, [%r18 + 0x0000] %asi
	mov	0x60, %r24
	mov	0x30, %r25
	.word 0xd0974e60  ! 807: LDUHA_R	lduha	[%r29, %r0] 0x73, %r8
	mov	0x58, %r27
	mov	0x7f8, %r21
	.word 0xdeb649e0  ! 810: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xdca504a0  ! 811: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	mov	0x78, %r16
	.word 0xda9689e0  ! 813: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r13
	.word 0xd2f4e000  ! 814: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2f42000  ! 815: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 816: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedf0e60  ! 817: LDXA_R	ldxa	[%r28, %r0] 0x73, %r15
	.word 0xd0ce6000  ! 818: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r8
	.word 0xd0f66000  ! 819: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd096a000  ! 820: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	.word 0x87802074  ! 821: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ac2000  ! 822: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd0f4a000  ! 823: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0f46000  ! 824: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0946000  ! 825: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0de09e0  ! 826: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r8
	mov	0x68, %r17
	mov	0x68, %r17
	.word 0xd8d46000  ! 829: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	mov	0x60, %r26
	.word 0x8780204f  ! 831: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r21
	.word 0xd2d4c400  ! 833: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	.word 0xdadfa000  ! 834: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	.word 0xd6c7ce80  ! 835: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r11
	mov	0x60, %r19
	.word 0xd2bec9e0  ! 837: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0xd4dfa000  ! 838: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xdc940400  ! 839: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	mov	0x7d0, %r20
	mov	0x70, %r27
	.word 0xd4afe000  ! 842: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 843: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0dc4400  ! 844: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	mov	0x78, %r19
	mov	0x18, %r18
	.word 0xd6ac2000  ! 847: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a4a000  ! 848: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 849: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6966000  ! 850: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	.word 0x87802072  ! 851: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6bf6000  ! 852: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xd8b6c9e0  ! 854: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	mov	0x20, %r19
	.word 0xdad72000  ! 856: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0x87802025  ! 857: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 858: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8f8e40  ! 859: LDUBA_R	lduba	[%r30, %r0] 0x72, %r13
	.word 0xd2a7ce80  ! 860: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	.word 0xd8dfa000  ! 861: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802072  ! 862: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f7e000  ! 863: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd6b689e0  ! 864: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	mov	0x50, %r19
	.word 0xd49f2000  ! 866: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	mov	0x18, %r18
	.word 0x87802072  ! 868: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dec9e0  ! 869: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	.word 0xd0a504a0  ! 870: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0xd6cfe000  ! 871: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0x87802072  ! 872: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6c46000  ! 873: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	mov	0x58, %r17
	mov	0x7c8, %r22
	mov	0x7d8, %r23
	.word 0xdeb584a0  ! 877: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0xd4bc6000  ! 878: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd4f46000  ! 879: STXA_I	stxa	%r10, [%r17 + 0x0000] %asi
	.word 0xd49ca000  ! 880: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4a4a000  ! 881: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xdcb74e60  ! 882: STHA_R	stha	%r14, [%r29 + %r0] 0x73
	.word 0x87802074  ! 883: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xded72000  ! 884: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x3c8, %r20
	.word 0xde9f6000  ! 886: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xdeb7a000  ! 887: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdecf2000  ! 888: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xdcb689e0  ! 889: STHA_R	stha	%r14, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 890: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 891: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d504a0  ! 892: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0xd2b42000  ! 893: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xd4a4c400  ! 894: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xd4b4e000  ! 895: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xd4dca000  ! 896: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	mov	0x58, %r18
	.word 0xd4d4e000  ! 898: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd29d84a0  ! 899: LDDA_R	ldda	[%r22, %r0] 0x25, %r9
	.word 0xd2b4c400  ! 900: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0xd4df4e40  ! 901: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xd69c6000  ! 902: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd6a4e000  ! 903: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 904: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 905: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r22
	.word 0xd6b6a000  ! 907: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xd6a74e80  ! 908: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0x87802020  ! 909: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda876000  ! 910: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xdaad04a0  ! 911: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0x8780204f  ! 912: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r26
	.word 0xdc8c6000  ! 914: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r14
	.word 0xdca40400  ! 915: STWA_R	stwa	%r14, [%r16 + %r0] 0x20
	.word 0xd4c46000  ! 916: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	.word 0xd0cfce40  ! 917: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r8
	.word 0xdeacc400  ! 918: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd0c48400  ! 919: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xd8f4e000  ! 920: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd89ce000  ! 921: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	mov	0x7f0, %r22
	.word 0xd8bc6000  ! 923: STDA_I	stda	%r12, [%r17 + 0x0000] %asi
	.word 0xd8aca000  ! 924: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	mov	0x48, %r17
	.word 0xd8b4a000  ! 926: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 927: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d7e000  ! 928: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xd8c7e000  ! 929: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 930: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x3f0, %r21
	.word 0xd6f4c400  ! 932: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xdabf6000  ! 933: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 934: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa78e40  ! 935: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xd6bf4e40  ! 936: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	mov	0x10, %r19
	.word 0x8780204f  ! 938: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9c8400  ! 939: LDDA_R	ldda	[%r18, %r0] 0x20, %r14
	mov	0x38, %r19
	.word 0xd4bcc400  ! 941: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	.word 0xd8bd2000  ! 942: STDA_I	stda	%r12, [%r20 + 0x0000] %asi
	.word 0xdc878e80  ! 943: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r14
	.word 0xd0dd2000  ! 944: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0d5e000  ! 945: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r8
	.word 0xd0d52000  ! 946: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r8
	.word 0xd0a5e000  ! 947: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	mov	0x70, %r26
	.word 0xd09d2000  ! 949: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r8
	.word 0xd08de000  ! 950: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r8
	mov	0x7f8, %r21
	.word 0xd2848400  ! 952: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r9
	.word 0x87802020  ! 953: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ce09e0  ! 954: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	.word 0xd2b76000  ! 955: STHA_I	stha	%r9, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 956: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 957: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a78e40  ! 958: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0xdcb40400  ! 959: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdabce000  ! 960: STDA_I	stda	%r13, [%r19 + 0x0000] %asi
	.word 0xd4de49e0  ! 961: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r10
	mov	0x60, %r26
	.word 0x87802074  ! 963: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r16
	.word 0xd0dd2000  ! 965: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd0956000  ! 966: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r8
	.word 0xdcb70e60  ! 967: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0x87802074  ! 968: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r20
	.word 0xdcd70e40  ! 970: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r14
	.word 0xd09dc4a0  ! 971: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xd487e000  ! 972: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xde9c4400  ! 973: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0xd0874e80  ! 974: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	.word 0xd49d84a0  ! 975: LDDA_R	ldda	[%r22, %r0] 0x25, %r10
	.word 0xd0cf0e60  ! 976: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	.word 0xdcb40400  ! 977: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xdea7ce40  ! 978: STWA_R	stwa	%r15, [%r31 + %r0] 0x72
	.word 0xdcafce80  ! 979: STBA_R	stba	%r14, [%r31 + %r0] 0x74
	.word 0xd2bf6000  ! 980: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2ae09e0  ! 981: STBA_R	stba	%r9, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 982: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bf2000  ! 983: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cf6000  ! 984: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bfa000  ! 985: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	mov	0x48, %r24
	.word 0x87802072  ! 987: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb4c400  ! 988: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdcc46000  ! 989: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0x87802020  ! 990: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r21
	mov	0x3c8, %r21
	.word 0xdcb5e000  ! 993: STHA_I	stha	%r14, [%r23 + 0x0000] %asi
	.word 0xd69f8e40  ! 994: LDDA_R	ldda	[%r30, %r0] 0x72, %r11
	mov	0x78, %r18
	mov	0x3e0, %r22
	mov	0x3d8, %r21
	.word 0x8780204f  ! 998: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef584a0  ! 999: STXA_R	stxa	%r15, [%r22 + %r0] 0x25
	.word 0xd0c5a000  ! 1000: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r8
	.word 0xd085e000  ! 1001: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1002: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd08e2000  ! 1003: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r8
	.word 0xd4df8e40  ! 1004: LDXA_R	ldxa	[%r30, %r0] 0x72, %r10
	mov	0x7d0, %r23
	.word 0xd4ae6000  ! 1006: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd6df8e80  ! 1007: LDXA_R	ldxa	[%r30, %r0] 0x74, %r11
	.word 0xd2f78e40  ! 1008: STXA_R	stxa	%r9, [%r30 + %r0] 0x72
	.word 0xdcaea000  ! 1009: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdcf6e000  ! 1010: STXA_I	stxa	%r14, [%r27 + 0x0000] %asi
	.word 0xdcaee000  ! 1011: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0xd8df4e60  ! 1012: LDXA_R	ldxa	[%r29, %r0] 0x73, %r12
	mov	0x3d8, %r21
	.word 0xd8866000  ! 1014: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xd8974e60  ! 1015: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	mov	0x30, %r17
	mov	0x70, %r24
	.word 0x87802072  ! 1018: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6874e40  ! 1019: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r11
	.word 0xd68c2000  ! 1020: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r11
	.word 0xd4af0e40  ! 1021: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	mov	0x20, %r25
	.word 0xdec4a000  ! 1023: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdece09e0  ! 1024: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 1026: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2c72000  ! 1027: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd8a74e80  ! 1028: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	.word 0x87802025  ! 1029: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c44400  ! 1030: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r8
	.word 0xde9cc400  ! 1031: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xdad5e000  ! 1032: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r13
	.word 0x87802073  ! 1033: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88f4e60  ! 1034: LDUBA_R	lduba	[%r29, %r0] 0x73, %r12
	mov	0x8, %r27
	mov	0x78, %r16
	.word 0xd294e000  ! 1037: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xdaaf4e40  ! 1038: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xd8bc2000  ! 1039: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8c42000  ! 1040: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x28, %r16
	.word 0x87802025  ! 1042: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8866000  ! 1043: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	mov	0x38, %r18
	.word 0xd8ae2000  ! 1045: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd48584a0  ! 1046: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	.word 0xdcc74e60  ! 1047: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r14
	.word 0xd6be6000  ! 1048: STDA_I	stda	%r11, [%r25 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xd0bdc4a0  ! 1050: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0x87802020  ! 1051: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r17
	.word 0xded44400  ! 1053: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0x87802073  ! 1054: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdadf4e80  ! 1055: LDXA_R	ldxa	[%r29, %r0] 0x74, %r13
	.word 0x87802073  ! 1056: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c78e80  ! 1057: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r10
	.word 0xd8c4a000  ! 1058: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	mov	0x78, %r27
	mov	0x3e8, %r21
	ta	T_CHANGE_PRIV	! macro
	.word 0xd2de89e0  ! 1062: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xd2ac6000  ! 1063: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd28ca000  ! 1064: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xdcc6c9e0  ! 1065: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r14
	mov	0x30, %r17
	.word 0xd6ace000  ! 1067: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1068: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r26
	.word 0xd6962000  ! 1070: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	.word 0xd6bee000  ! 1071: STDA_I	stda	%r11, [%r27 + 0x0000] %asi
	mov	0x38, %r16
	.word 0xd4bf8e60  ! 1073: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0xd6cee000  ! 1074: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	.word 0xdeb70e80  ! 1075: STHA_R	stha	%r15, [%r28 + %r0] 0x74
	.word 0xd6df8e80  ! 1076: LDXA_R	ldxa	[%r30, %r0] 0x74, %r11
	.word 0xd0d6e000  ! 1077: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r8
	mov	0x60, %r18
	.word 0xd6974e80  ! 1079: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	.word 0x87802020  ! 1080: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f7a000  ! 1081: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bf2000  ! 1082: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xdeae49e0  ! 1083: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xda9fe000  ! 1084: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xd2a7ce80  ! 1085: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	mov	0x58, %r24
	.word 0x8780204f  ! 1087: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r21
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2be6000  ! 1090: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2de2000  ! 1091: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r9
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdedfce60  ! 1093: LDXA_R	ldxa	[%r31, %r0] 0x73, %r15
	.word 0xdc862000  ! 1094: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r14
	.word 0xdcb62000  ! 1095: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xdcd6e000  ! 1096: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r14
	.word 0xdcbee000  ! 1097: STDA_I	stda	%r14, [%r27 + 0x0000] %asi
	.word 0xdedf4e60  ! 1098: LDXA_R	ldxa	[%r29, %r0] 0x73, %r15
	.word 0xd8b5c4a0  ! 1099: STHA_R	stha	%r12, [%r23 + %r0] 0x25
	.word 0xdcf544a0  ! 1100: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0xd8878e60  ! 1101: LDUWA_R	lduwa	[%r30, %r0] 0x73, %r12
	.word 0xdcdd04a0  ! 1102: LDXA_R	ldxa	[%r20, %r0] 0x25, %r14
	.word 0xd88d04a0  ! 1103: LDUBA_R	lduba	[%r20, %r0] 0x25, %r12
	.word 0xdcb62000  ! 1104: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xdc8e6000  ! 1105: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r14
	mov	0x20, %r26
	.word 0xd6dfce60  ! 1107: LDXA_R	ldxa	[%r31, %r0] 0x73, %r11
	.word 0xdabee000  ! 1108: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xda9e09e0  ! 1109: LDDA_R	ldda	[%r24, %r0] 0x4f, %r13
	mov	0x38, %r18
	.word 0xd0d70e60  ! 1111: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r8
	.word 0xd8cc0400  ! 1112: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xd8ce2000  ! 1113: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	.word 0xd89e6000  ! 1114: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1115: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6978e60  ! 1116: LDUHA_R	lduha	[%r30, %r0] 0x73, %r11
	.word 0xd4bf6000  ! 1117: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd49f6000  ! 1118: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r10
	.word 0xd0a44400  ! 1119: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x40, %r16
	mov	0x3c8, %r20
	.word 0xd487a000  ! 1122: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xda8d84a0  ! 1123: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0xdc97a000  ! 1124: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 1125: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x7d8, %r20
	.word 0xd4b78e40  ! 1127: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	.word 0xd6c649e0  ! 1128: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0xdcb70e80  ! 1129: STHA_R	stha	%r14, [%r28 + %r0] 0x74
	mov	0x50, %r17
	mov	0x8, %r18
	.word 0xde8f2000  ! 1132: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r15
	.word 0xdebf0e60  ! 1133: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdec76000  ! 1134: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd6b40400  ! 1135: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xdeafa000  ! 1136: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xdaf5c4a0  ! 1137: STXA_R	stxa	%r13, [%r23 + %r0] 0x25
	.word 0x87802073  ! 1138: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 1139: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a7e000  ! 1140: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	mov	0x48, %r25
	.word 0xd68fe000  ! 1142: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	mov	0x58, %r19
	.word 0xd6bfe000  ! 1144: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd6df2000  ! 1145: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6f76000  ! 1146: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xdcc78e40  ! 1147: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r14
	.word 0xd8b76000  ! 1148: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0xd8874e40  ! 1149: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r12
	.word 0xd8d72000  ! 1150: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8afe000  ! 1151: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	mov	0x30, %r18
	.word 0xd8a7a000  ! 1153: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8c7e000  ! 1154: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8bf2000  ! 1155: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xda9f4e80  ! 1156: LDDA_R	ldda	[%r29, %r0] 0x74, %r13
	.word 0xd6f78e80  ! 1157: STXA_R	stxa	%r11, [%r30 + %r0] 0x74
	.word 0x87802073  ! 1158: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d4e000  ! 1159: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1160: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8df2000  ! 1161: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xdaf7ce80  ! 1162: STXA_R	stxa	%r13, [%r31 + %r0] 0x74
	.word 0xdab76000  ! 1163: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 1164: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r20
	mov	0x18, %r25
	.word 0xdabf2000  ! 1167: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x50, %r19
	.word 0xd89dc4a0  ! 1169: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0x87802074  ! 1170: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6842000  ! 1171: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0xd6bc6000  ! 1172: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0xd6b4e000  ! 1173: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd6a42000  ! 1174: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xdcf584a0  ! 1176: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0xd0a42000  ! 1177: STWA_I	stwa	%r8, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1178: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd08ce000  ! 1179: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd0f42000  ! 1180: STXA_I	stxa	%r8, [%r16 + 0x0000] %asi
	mov	0x20, %r25
	mov	0x78, %r19
	.word 0x87802073  ! 1183: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1184: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8848400  ! 1185: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r12
	.word 0xda944400  ! 1186: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xd6b62000  ! 1187: STHA_I	stha	%r11, [%r24 + 0x0000] %asi
	.word 0xd88c4400  ! 1188: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	mov	0x10, %r27
	.word 0xdcae09e0  ! 1190: STBA_R	stba	%r14, [%r24 + %r0] 0x4f
	.word 0xd2dd04a0  ! 1191: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	.word 0xdab6e000  ! 1192: STHA_I	stha	%r13, [%r27 + 0x0000] %asi
	.word 0x8780204f  ! 1193: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e0, %r23
	.word 0xd0ce09e0  ! 1195: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	mov	0x3d8, %r21
	.word 0x87802072  ! 1197: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea70e60  ! 1198: STWA_R	stwa	%r15, [%r28 + %r0] 0x73
	mov	0x58, %r19
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802074  ! 1201: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0a4e000  ! 1202: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0c4a000  ! 1203: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0cc2000  ! 1204: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r8
	mov	0x7d0, %r20
	.word 0xd094e000  ! 1206: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xde8fce80  ! 1207: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	.word 0xd6f40400  ! 1208: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	mov	0x58, %r27
	mov	0x3e8, %r20
	.word 0x87802020  ! 1211: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af4e40  ! 1212: STBA_R	stba	%r9, [%r29 + %r0] 0x72
	.word 0xd8bf6000  ! 1213: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xdccc8400  ! 1214: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xd4d5c4a0  ! 1215: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r10
	.word 0xd4af2000  ! 1216: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd0a6c9e0  ! 1217: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xd8bf4e60  ! 1218: STDA_R	stda	%r12, [%r29 + %r0] 0x73
	ta	T_CHANGE_HPRIV	! macro
	.word 0xde8f6000  ! 1220: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 1221: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdef56000  ! 1222: STXA_I	stxa	%r15, [%r21 + 0x0000] %asi
	.word 0x87802072  ! 1223: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde84e000  ! 1224: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	mov	0x20, %r19
	.word 0x87802020  ! 1226: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	mov	0x28, %r27
	mov	0x18, %r16
	.word 0xd88e09e0  ! 1230: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0xdca7e000  ! 1231: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd0f78e60  ! 1232: STXA_R	stxa	%r8, [%r30 + %r0] 0x73
	.word 0x87802073  ! 1233: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1234: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbf6000  ! 1235: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xd4ac4400  ! 1236: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1237: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bc0400  ! 1238: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	mov	0x30, %r16
	.word 0x87802073  ! 1240: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6d42000  ! 1241: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	.word 0xd0f70e80  ! 1242: STXA_R	stxa	%r8, [%r28 + %r0] 0x74
	mov	0x7c0, %r22
	.word 0xd0f4a000  ! 1244: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 1245: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd097a000  ! 1246: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd887ce80  ! 1247: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r12
	.word 0xde9f6000  ! 1248: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r15
	.word 0xde8fa000  ! 1249: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802025  ! 1250: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x78, %r17
	mov	0x30, %r17
	.word 0x8780204f  ! 1253: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdadf8e80  ! 1254: LDXA_R	ldxa	[%r30, %r0] 0x74, %r13
	mov	0x58, %r19
	ta	T_CHANGE_HPRIV	! macro
	mov	0x10, %r26
	.word 0xd49c0400  ! 1258: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	.word 0xd2afe000  ! 1259: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	mov	0x70, %r16
	mov	0x58, %r24
	mov	0x7e0, %r22
	.word 0xd2bfa000  ! 1263: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2b72000  ! 1264: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd0bc8400  ! 1265: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xd4bf4e80  ! 1266: STDA_R	stda	%r10, [%r29 + %r0] 0x74
	mov	0x7f0, %r20
	.word 0xd8bf2000  ! 1268: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd4c74e80  ! 1269: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	mov	0x60, %r24
	.word 0xd6bfa000  ! 1271: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	mov	0x20, %r16
	mov	0x60, %r25
	mov	0x7e8, %r20
	mov	0x70, %r27
	.word 0xd6d70e80  ! 1276: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0xd69f6000  ! 1277: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1278: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f72000  ! 1279: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1280: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 1281: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bc6000  ! 1282: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1283: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2874e40  ! 1284: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	mov	0x0, %r18
	.word 0x87802073  ! 1286: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bfa000  ! 1287: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd4972000  ! 1288: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd6848400  ! 1289: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0xd4bfa000  ! 1290: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	mov	0x78, %r16
	.word 0x87802020  ! 1292: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49fa000  ! 1293: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1294: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb70e60  ! 1295: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xdcf52000  ! 1296: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 1297: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaaf0e80  ! 1298: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0xd6acc400  ! 1299: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0xd6c5e000  ! 1300: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6f44400  ! 1301: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	mov	0x50, %r19
	.word 0xd4f56000  ! 1303: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0x87802073  ! 1304: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cfce40  ! 1305: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	.word 0xde972000  ! 1306: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	mov	0x7c0, %r21
	mov	0x70, %r19
	.word 0xd0af4e80  ! 1309: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	.word 0xdef76000  ! 1310: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	mov	0x3c0, %r21
	mov	0x7e8, %r20
	.word 0xdea72000  ! 1313: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0xd8c40400  ! 1314: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r12
	.word 0xdaa78e80  ! 1315: STWA_R	stwa	%r13, [%r30 + %r0] 0x74
	.word 0xd6bfe000  ! 1316: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0xd08cc400  ! 1317: LDUBA_R	lduba	[%r19, %r0] 0x20, %r8
	mov	0x50, %r16
	.word 0x87802025  ! 1319: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802073  ! 1320: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedfa000  ! 1321: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x3e8, %r22
	.word 0xd89f4e80  ! 1323: LDDA_R	ldda	[%r29, %r0] 0x74, %r12
	.word 0xdef74e60  ! 1324: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	ta	T_CHANGE_PRIV	! macro
	.word 0xd0af8e80  ! 1326: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	.word 0xd0a76000  ! 1327: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xdad70e40  ! 1328: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	.word 0xdcb7a000  ! 1329: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xd6f7ce40  ! 1330: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xd88fa000  ! 1331: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd4d44400  ! 1332: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	mov	0x78, %r19
	.word 0xdedfe000  ! 1334: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0x87802072  ! 1335: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef72000  ! 1336: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd48f0e40  ! 1337: LDUBA_R	lduba	[%r28, %r0] 0x72, %r10
	.word 0xd0aec9e0  ! 1338: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xd68f0e80  ! 1339: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	mov	0x30, %r24
	.word 0x87802020  ! 1341: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde846000  ! 1342: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	mov	0x48, %r19
	mov	0x68, %r16
	.word 0xdea4a000  ! 1345: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	.word 0xdecc6000  ! 1346: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	mov	0x3e8, %r23
	mov	0x28, %r18
	mov	0x7c0, %r21
	.word 0xda8504a0  ! 1350: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r13
	.word 0xd0f4e000  ! 1351: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 1352: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r24
	.word 0x87802073  ! 1354: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r16
	.word 0xd2bf4e60  ! 1356: STDA_R	stda	%r9, [%r29 + %r0] 0x73
	.word 0x87802072  ! 1357: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a74e40  ! 1358: STWA_R	stwa	%r9, [%r29 + %r0] 0x72
	mov	0x0, %r18
	.word 0x87802072  ! 1360: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b56000  ! 1361: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	mov	0x48, %r17
	.word 0x87802074  ! 1363: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r19
	.word 0xd29f2000  ! 1365: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0x87802025  ! 1366: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f72000  ! 1367: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 1368: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 1369: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e0, %r23
	.word 0xd29f2000  ! 1371: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xded78e80  ! 1372: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r15
	.word 0xd2c78e40  ! 1373: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r9
	.word 0xdadc4400  ! 1374: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0x8780204f  ! 1375: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ac8400  ! 1376: STBA_R	stba	%r12, [%r18 + %r0] 0x20
	.word 0xd08f6000  ! 1377: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xd69fce40  ! 1378: LDDA_R	ldda	[%r31, %r0] 0x72, %r11
	.word 0xd4df8e40  ! 1379: LDXA_R	ldxa	[%r30, %r0] 0x72, %r10
	.word 0xd8bf2000  ! 1380: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd0a70e80  ! 1381: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	mov	0x7e8, %r21
	.word 0xd29fa000  ! 1383: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd29fe000  ! 1384: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 1385: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	mov	0x20, %r18
	.word 0xd2972000  ! 1387: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 1388: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2f7a000  ! 1389: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	mov	0x48, %r16
	mov	0x60, %r26
	mov	0x60, %r18
	.word 0x87802025  ! 1393: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2d7e000  ! 1394: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x40, %r17
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2bf2000  ! 1397: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd2f72000  ! 1399: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd2b74e80  ! 1400: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xd6bf0e80  ! 1401: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	mov	0x8, %r16
	mov	0x60, %r25
	.word 0xd6bf6000  ! 1404: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xdef78e40  ! 1405: STXA_R	stxa	%r15, [%r30 + %r0] 0x72
	.word 0xd4d70e60  ! 1406: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	.word 0xdccf8e40  ! 1407: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r14
	.word 0xd2872000  ! 1408: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2af2000  ! 1409: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd28f6000  ! 1410: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1411: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bc2000  ! 1412: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2ae49e0  ! 1413: STBA_R	stba	%r9, [%r25 + %r0] 0x4f
	.word 0xd89d84a0  ! 1414: LDDA_R	ldda	[%r22, %r0] 0x25, %r12
	.word 0xd89ca000  ! 1415: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xd8846000  ! 1416: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8f4e000  ! 1417: STXA_I	stxa	%r12, [%r19 + 0x0000] %asi
	.word 0xd8d46000  ! 1418: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8aca000  ! 1419: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd8ac2000  ! 1420: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xdab44400  ! 1421: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x50, %r16
	.word 0xdebe09e0  ! 1423: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0xd6b7ce40  ! 1424: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	.word 0xd6b44400  ! 1425: STHA_R	stha	%r11, [%r17 + %r0] 0x20
	mov	0x7e8, %r20
	.word 0xd49584a0  ! 1427: LDUHA_R	lduha	[%r22, %r0] 0x25, %r10
	.word 0xd8a609e0  ! 1428: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	mov	0x50, %r26
	.word 0xde8c6000  ! 1430: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	mov	0x30, %r18
	.word 0xdaf7ce40  ! 1432: STXA_R	stxa	%r13, [%r31 + %r0] 0x72
	mov	0x7f0, %r22
	.word 0xda84c400  ! 1434: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xd8f609e0  ! 1435: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	mov	0x40, %r26
	.word 0xd8946000  ! 1437: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8dc6000  ! 1438: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8cc2000  ! 1439: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r12
	.word 0xda878e40  ! 1440: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0xdcc4a000  ! 1441: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4e000  ! 1442: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0x8780204f  ! 1444: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 1445: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f70e60  ! 1446: STXA_R	stxa	%r11, [%r28 + %r0] 0x73
	mov	0x38, %r17
	.word 0xd4aec9e0  ! 1448: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 1449: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2dce000  ! 1450: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	mov	0x7e8, %r22
	.word 0x8780204f  ! 1452: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc584a0  ! 1453: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	.word 0xdeac6000  ! 1454: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xdeb46000  ! 1455: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	mov	0x78, %r17
	.word 0xde8c6000  ! 1457: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0x87802072  ! 1458: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69584a0  ! 1459: LDUHA_R	lduha	[%r22, %r0] 0x25, %r11
	.word 0xde95e000  ! 1460: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r15
	.word 0xd48f0e80  ! 1461: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0xdaf56000  ! 1462: STXA_I	stxa	%r13, [%r21 + 0x0000] %asi
	.word 0xda9da000  ! 1463: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r13
	.word 0xda85a000  ! 1464: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r13
	.word 0xd4cc0400  ! 1465: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r10
	mov	0x3c0, %r21
	mov	0x38, %r17
	.word 0x87802025  ! 1468: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1469: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbfe000  ! 1470: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xdca76000  ! 1471: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	mov	0x7e8, %r23
	.word 0xd2c7ce80  ! 1473: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	mov	0x50, %r17
	.word 0xda9cc400  ! 1475: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xd6bfe000  ! 1476: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	mov	0x3e8, %r22
	mov	0x68, %r25
	.word 0xd8a7ce40  ! 1479: STWA_R	stwa	%r12, [%r31 + %r0] 0x72
	.word 0xde8fe000  ! 1480: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	mov	0x3c0, %r23
	.word 0xdedfa000  ! 1482: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xd0be09e0  ! 1483: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd8bfce60  ! 1484: STDA_R	stda	%r12, [%r31 + %r0] 0x73
	mov	0x30, %r25
	mov	0x3e0, %r21
	mov	0x38, %r16
	.word 0xda9f6000  ! 1488: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xd69fce40  ! 1489: LDDA_R	ldda	[%r31, %r0] 0x72, %r11
	.word 0xd4bf4e60  ! 1490: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0xd8dc4400  ! 1491: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	mov	0x7c8, %r20
	.word 0xd6af0e40  ! 1493: STBA_R	stba	%r11, [%r28 + %r0] 0x72
	.word 0xdab4c400  ! 1494: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd8f76000  ! 1495: STXA_I	stxa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8dfe000  ! 1496: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x68, %r16
	.word 0x87802074  ! 1498: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd88de000  ! 1499: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r12
	.word 0xd8c5a000  ! 1500: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8dda000  ! 1501: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xdc878e80  ! 1502: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r14
	.word 0x87802020  ! 1503: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc940400  ! 1504: LDUHA_R	lduha	[%r16, %r0] 0x20, %r14
	ta	T_CHANGE_PRIV	! macro
	mov	0x7d0, %r22
	.word 0xda87e000  ! 1507: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda946000  ! 1509: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r13
	.word 0xdabc2000  ! 1510: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdaac2000  ! 1511: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xdaa4e000  ! 1512: STWA_I	stwa	%r13, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1513: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc70e60  ! 1514: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r14
	.word 0xdcf689e0  ! 1515: STXA_R	stxa	%r14, [%r26 + %r0] 0x4f
	.word 0xd8af6000  ! 1516: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0xd8bf2000  ! 1517: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8972000  ! 1518: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8b7a000  ! 1519: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 1520: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cce000  ! 1521: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	mov	0x7c0, %r23
	.word 0xd8b4e000  ! 1523: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd8aca000  ! 1524: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0xd8f42000  ! 1525: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd2f40400  ! 1526: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0xd0ace000  ! 1527: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xd0bca000  ! 1529: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	mov	0x0, %r26
	.word 0xd0ace000  ! 1531: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd0946000  ! 1532: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0b42000  ! 1533: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd0dce000  ! 1534: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0bc6000  ! 1535: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x3f8, %r21
	mov	0x58, %r27
	.word 0xdea649e0  ! 1538: STWA_R	stwa	%r15, [%r25 + %r0] 0x4f
	mov	0x20, %r17
	.word 0xd2acc400  ! 1540: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 1541: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd69fce60  ! 1542: LDDA_R	ldda	[%r31, %r0] 0x73, %r11
	.word 0xd4cc4400  ! 1543: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r10
	.word 0xd2ad2000  ! 1544: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0x87802072  ! 1545: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4c40400  ! 1546: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xd8dd04a0  ! 1547: LDXA_R	ldxa	[%r20, %r0] 0x25, %r12
	.word 0xdc9fce40  ! 1548: LDDA_R	ldda	[%r31, %r0] 0x72, %r14
	.word 0x87802025  ! 1549: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa7e000  ! 1550: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xd4c609e0  ! 1551: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0xdedfe000  ! 1552: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xded7a000  ! 1553: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 1554: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bc0400  ! 1555: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xd4ad84a0  ! 1556: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	mov	0x60, %r24
	.word 0xda9da000  ! 1558: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r13
	.word 0xdaf5e000  ! 1559: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xda9c4400  ! 1560: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	.word 0xd8ce09e0  ! 1561: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r12
	.word 0xd2c70e60  ! 1562: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r9
	mov	0x10, %r18
	.word 0xd8af4e80  ! 1564: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0xd6cd2000  ! 1565: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	.word 0xd0d44400  ! 1566: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0xd4d5a000  ! 1567: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x38, %r25
	.word 0xd4a5e000  ! 1570: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	.word 0xdab74e60  ! 1571: STHA_R	stha	%r13, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 1572: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 1573: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r21
	mov	0x70, %r24
	.word 0x87802074  ! 1576: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab46000  ! 1577: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xdac4a000  ! 1578: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	mov	0x0, %r19
	mov	0x20, %r18
	mov	0x8, %r18
	.word 0xda846000  ! 1582: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r13
	.word 0x87802020  ! 1583: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8da000  ! 1584: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r13
	.word 0xd48cc400  ! 1585: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	mov	0x7c8, %r22
	.word 0xd8c52000  ! 1587: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1588: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1589: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b7a000  ! 1590: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd8dfe000  ! 1591: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xdcbf8e60  ! 1592: STDA_R	stda	%r14, [%r30 + %r0] 0x73
	.word 0xd6b76000  ! 1593: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6a7e000  ! 1594: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1595: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a4e000  ! 1596: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xd6cf0e60  ! 1598: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r11
	.word 0xd8af0e80  ! 1599: STBA_R	stba	%r12, [%r28 + %r0] 0x74
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 1601: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda870e60  ! 1602: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r13
	.word 0xd28c0400  ! 1603: LDUBA_R	lduba	[%r16, %r0] 0x20, %r9
	.word 0xd2d584a0  ! 1604: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r9
	.word 0xd2dc0400  ! 1605: LDXA_R	ldxa	[%r16, %r0] 0x20, %r9
	.word 0xdc84a000  ! 1606: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x40, %r19
	mov	0x78, %r19
	.word 0xd0af4e60  ! 1609: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	mov	0x70, %r16
	.word 0xdab74e40  ! 1611: STHA_R	stha	%r13, [%r29 + %r0] 0x72
	.word 0xd49f8e60  ! 1612: LDDA_R	ldda	[%r30, %r0] 0x73, %r10
	.word 0xdaac4400  ! 1613: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1614: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r16
	.word 0xdcbc6000  ! 1616: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdaa584a0  ! 1617: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0xdcf46000  ! 1618: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xd6d40400  ! 1619: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r11
	.word 0xdcb46000  ! 1620: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdca46000  ! 1621: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xdc84a000  ! 1623: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x78, %r24
	.word 0x87802020  ! 1625: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccea000  ! 1626: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	mov	0x3e8, %r22
	mov	0x7c0, %r22
	.word 0x87802020  ! 1629: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdccea000  ! 1630: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r14
	.word 0xde874e80  ! 1631: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r15
	.word 0xd8bf8e60  ! 1632: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0xdc86a000  ! 1633: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	.word 0xd28504a0  ! 1634: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r9
	mov	0x7f0, %r23
	.word 0xd4f689e0  ! 1636: STXA_R	stxa	%r10, [%r26 + %r0] 0x4f
	.word 0x87802074  ! 1637: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 1638: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r16
	.word 0xd0b70e40  ! 1640: STHA_R	stha	%r8, [%r28 + %r0] 0x72
	.word 0xd09f8e40  ! 1641: LDDA_R	ldda	[%r30, %r0] 0x72, %r8
	.word 0xdacf8e40  ! 1642: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r13
	mov	0x48, %r27
	.word 0xd2c44400  ! 1644: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xdca4e000  ! 1645: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xdcbc2000  ! 1647: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xdcac6000  ! 1648: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 1649: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 1650: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca6a000  ! 1651: STWA_I	stwa	%r14, [%r26 + 0x0000] %asi
	.word 0xd0a7ce40  ! 1652: STWA_R	stwa	%r8, [%r31 + %r0] 0x72
	.word 0xd8f6e000  ! 1653: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	.word 0xd89ea000  ! 1654: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	.word 0xd8b6a000  ! 1655: STHA_I	stha	%r12, [%r26 + 0x0000] %asi
	mov	0x38, %r16
	.word 0xd8c6a000  ! 1657: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8c62000  ! 1658: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	.word 0xd4a5c4a0  ! 1659: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	.word 0xd2aea000  ! 1660: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd2be6000  ! 1661: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2866000  ! 1662: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1663: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f6c9e0  ! 1664: STXA_R	stxa	%r11, [%r27 + %r0] 0x4f
	.word 0xd0f76000  ! 1665: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xd087e000  ! 1666: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd4f70e60  ! 1667: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 1668: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9fce80  ! 1669: LDDA_R	ldda	[%r31, %r0] 0x74, %r15
	.word 0xd6ce09e0  ! 1670: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r11
	.word 0xd6f72000  ! 1671: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6bfce80  ! 1672: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xd6d70e80  ! 1673: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0x87802025  ! 1674: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d0, %r20
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7f8, %r22
	.word 0x87802073  ! 1678: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1679: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8bf0e80  ! 1680: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	.word 0xd0f70e60  ! 1681: STXA_R	stxa	%r8, [%r28 + %r0] 0x73
	.word 0xd2978e40  ! 1682: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0xdccc6000  ! 1683: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	mov	0x0, %r17
	.word 0xdccca000  ! 1685: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	.word 0xd4c4c400  ! 1686: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r10
	.word 0xd6f7ce40  ! 1687: STXA_R	stxa	%r11, [%r31 + %r0] 0x72
	.word 0xde974e60  ! 1688: LDUHA_R	lduha	[%r29, %r0] 0x73, %r15
	mov	0x3d8, %r22
	.word 0xdab48400  ! 1690: STHA_R	stha	%r13, [%r18 + %r0] 0x20
	.word 0xd684e000  ! 1691: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1692: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69ea000  ! 1693: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r11
	.word 0xdabf8e40  ! 1694: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	.word 0x87802020  ! 1695: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b74e80  ! 1696: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xd8bd04a0  ! 1697: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xd6ac8400  ! 1698: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xdef70e60  ! 1699: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xdea42000  ! 1700: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xd0adc4a0  ! 1701: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0xdcc4e000  ! 1702: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	mov	0x7e8, %r22
	mov	0x50, %r26
	.word 0xdc8c2000  ! 1705: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0xd2978e40  ! 1706: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0x87802072  ! 1707: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29f0e60  ! 1708: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0xd4bf6000  ! 1709: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x40, %r24
	mov	0x40, %r17
	.word 0xd4f7a000  ! 1712: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xdab44400  ! 1713: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	mov	0x18, %r25
	.word 0xd4844400  ! 1715: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0x8780204f  ! 1716: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6a52000  ! 1717: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xdca504a0  ! 1718: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	mov	0x70, %r27
	.word 0xdc95a000  ! 1720: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	mov	0x70, %r26
	.word 0xdaf78e60  ! 1722: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0xd6ad2000  ! 1723: STBA_I	stba	%r11, [%r20 + 0x0000] %asi
	.word 0xd8bf0e40  ! 1724: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	mov	0x7e0, %r21
	.word 0xd6dd2000  ! 1726: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r11
	.word 0xd6cd6000  ! 1727: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r11
	mov	0x3d0, %r20
	mov	0x38, %r25
	.word 0xd0c48400  ! 1730: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xdeb7ce60  ! 1731: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xdca5a000  ! 1732: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	.word 0xdc852000  ! 1733: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r14
	mov	0x40, %r27
	.word 0x87802074  ! 1735: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b7ce60  ! 1736: STHA_R	stha	%r8, [%r31 + %r0] 0x73
	.word 0xd4f7a000  ! 1737: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 1738: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd284c400  ! 1739: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	.word 0xd2a689e0  ! 1740: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	mov	0x3d0, %r22
	.word 0x87802073  ! 1742: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2c7a000  ! 1743: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xdc8e89e0  ! 1744: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r14
	mov	0x50, %r26
	mov	0x28, %r25
	.word 0xd4a7a000  ! 1747: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x20, %r17
	mov	0x70, %r18
	mov	0x7c8, %r22
	.word 0xd49fe000  ! 1751: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd4c76000  ! 1752: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	mov	0x3d8, %r20
	mov	0x30, %r16
	.word 0xd4dfe000  ! 1755: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x38, %r19
	.word 0xd49fa000  ! 1757: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0x87802072  ! 1758: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3c0, %r20
	mov	0x0, %r24
	.word 0x87802025  ! 1761: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xded609e0  ! 1762: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r15
	.word 0xdead6000  ! 1763: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0xdebd6000  ! 1764: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xd0cc8400  ! 1766: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd8cd6000  ! 1767: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r12
	mov	0x28, %r18
	mov	0x3f8, %r22
	.word 0xd8bde000  ! 1770: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd69f4e80  ! 1771: LDDA_R	ldda	[%r29, %r0] 0x74, %r11
	.word 0xd2a649e0  ! 1772: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	.word 0x8780204f  ! 1773: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8fce60  ! 1774: LDUBA_R	lduba	[%r31, %r0] 0x73, %r14
	mov	0x7e8, %r21
	.word 0xd4b62000  ! 1776: STHA_I	stha	%r10, [%r24 + 0x0000] %asi
	mov	0x78, %r18
	.word 0xdace09e0  ! 1778: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0xdec62000  ! 1779: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	.word 0xdeae2000  ! 1780: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	.word 0xd0adc4a0  ! 1781: STBA_R	stba	%r8, [%r23 + %r0] 0x25
	.word 0x87802073  ! 1782: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6a4c400  ! 1783: STWA_R	stwa	%r11, [%r19 + %r0] 0x20
	.word 0xd4f78e40  ! 1784: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	.word 0xd0acc400  ! 1785: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd4948400  ! 1786: LDUHA_R	lduha	[%r18, %r0] 0x20, %r10
	.word 0xd89c4400  ! 1787: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xd2c4e000  ! 1788: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r9
	.word 0xd8f70e80  ! 1789: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0x87802020  ! 1790: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda87ce40  ! 1791: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	.word 0xd0b7a000  ! 1792: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd0f76000  ! 1793: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0xdeb7ce60  ! 1794: STHA_R	stha	%r15, [%r31 + %r0] 0x73
	.word 0xdc8584a0  ! 1795: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r14
	.word 0xdeafce40  ! 1796: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	.word 0x87802025  ! 1797: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1798: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b4e000  ! 1799: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd08c6000  ! 1800: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r8
	mov	0x68, %r18
	.word 0xd0d4a000  ! 1802: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0xd0f46000  ! 1803: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0d4a000  ! 1804: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 1805: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0af6000  ! 1806: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	.word 0xd0d7a000  ! 1807: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r8
	mov	0x3d0, %r21
	.word 0xd0a70e80  ! 1809: STWA_R	stwa	%r8, [%r28 + %r0] 0x74
	.word 0xdcbf2000  ! 1810: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	mov	0x60, %r27
	.word 0x87802025  ! 1812: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca5a000  ! 1813: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x60, %r26
	.word 0x87802074  ! 1815: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0ae49e0  ! 1816: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	.word 0xdea6c9e0  ! 1817: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 1818: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 1819: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef4c400  ! 1820: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xd8c76000  ! 1821: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd4df8e40  ! 1822: LDXA_R	ldxa	[%r30, %r0] 0x72, %r10
	.word 0xd89fa000  ! 1823: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd897a000  ! 1824: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8a7a000  ! 1825: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd6bf4e40  ! 1826: STDA_R	stda	%r11, [%r29 + %r0] 0x72
	.word 0xd8d7a000  ! 1827: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x0, %r24
	.word 0xd88fa000  ! 1829: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0x87802074  ! 1830: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r24
	.word 0xd8a4a000  ! 1832: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	mov	0x7c8, %r20
	mov	0x78, %r19
	.word 0xd6970e60  ! 1835: LDUHA_R	lduha	[%r28, %r0] 0x73, %r11
	mov	0x0, %r26
	.word 0x87802020  ! 1837: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bfce80  ! 1838: STDA_R	stda	%r8, [%r31 + %r0] 0x74
	mov	0x3c8, %r21
	mov	0x58, %r27
	.word 0xdaaf2000  ! 1841: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xdad7e000  ! 1842: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r13
	mov	0x3c0, %r23
	mov	0x58, %r27
	.word 0x87802072  ! 1845: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8de000  ! 1846: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0xd8dc4400  ! 1847: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0x87802072  ! 1848: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf5a000  ! 1849: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xdaad2000  ! 1850: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xdab56000  ! 1851: STHA_I	stha	%r13, [%r21 + 0x0000] %asi
	.word 0xd697ce60  ! 1852: LDUHA_R	lduha	[%r31, %r0] 0x73, %r11
	.word 0xdebd84a0  ! 1853: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	mov	0x7c0, %r20
	mov	0x3d0, %r20
	.word 0xd0f5c4a0  ! 1856: STXA_R	stxa	%r8, [%r23 + %r0] 0x25
	.word 0xd2dd6000  ! 1857: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	.word 0xdeb609e0  ! 1858: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xdac56000  ! 1859: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r13
	.word 0xdaf7ce60  ! 1860: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0x87802025  ! 1861: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0d42000  ! 1862: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0xda84c400  ! 1863: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0xdea46000  ! 1864: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0x8780204f  ! 1865: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdf0e80  ! 1866: LDXA_R	ldxa	[%r28, %r0] 0x74, %r14
	.word 0xd0bf0e80  ! 1867: STDA_R	stda	%r8, [%r28 + %r0] 0x74
	.word 0xd2a649e0  ! 1868: STWA_R	stwa	%r9, [%r25 + %r0] 0x4f
	mov	0x7f8, %r21
	.word 0xdeb4c400  ! 1870: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	mov	0x10, %r17
	.word 0xdadd04a0  ! 1872: LDXA_R	ldxa	[%r20, %r0] 0x25, %r13
	.word 0xdcb42000  ! 1873: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 1874: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 1875: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 1876: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcaea000  ! 1877: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdaa70e40  ! 1878: STWA_R	stwa	%r13, [%r28 + %r0] 0x72
	.word 0x87802020  ! 1879: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88f0e80  ! 1880: LDUBA_R	lduba	[%r28, %r0] 0x74, %r12
	.word 0xd8b40400  ! 1881: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	mov	0x20, %r16
	.word 0xd8cc8400  ! 1883: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0xd0b76000  ! 1884: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xd0a76000  ! 1886: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	mov	0x70, %r24
	.word 0xd0d72000  ! 1888: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	mov	0x3c0, %r20
	.word 0xd0bf6000  ! 1890: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xde870e40  ! 1891: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r15
	.word 0xdebf2000  ! 1892: STDA_I	stda	%r15, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1893: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdedc4400  ! 1894: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xdef78e60  ! 1895: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	mov	0x0, %r16
	.word 0xd2a70e80  ! 1897: STWA_R	stwa	%r9, [%r28 + %r0] 0x74
	mov	0x7c8, %r22
	mov	0x58, %r24
	mov	0x7d0, %r23
	.word 0xdeb609e0  ! 1901: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	.word 0xd48f0e80  ! 1902: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0xdea66000  ! 1903: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xdeaee000  ! 1905: STBA_I	stba	%r15, [%r27 + 0x0000] %asi
	mov	0x48, %r25
	mov	0x70, %r27
	.word 0x87802020  ! 1908: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r21
	.word 0x8780204f  ! 1910: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8af4e80  ! 1911: STBA_R	stba	%r12, [%r29 + %r0] 0x74
	.word 0xd2b5c4a0  ! 1912: STHA_R	stha	%r9, [%r23 + %r0] 0x25
	mov	0x3f0, %r22
	.word 0xdc9f8e40  ! 1914: LDDA_R	ldda	[%r30, %r0] 0x72, %r14
	.word 0xdcc52000  ! 1915: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1916: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf0e80  ! 1917: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0xdaf76000  ! 1918: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	.word 0xdabf6000  ! 1919: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd48d84a0  ! 1920: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd48f0e80  ! 1921: LDUBA_R	lduba	[%r28, %r0] 0x74, %r10
	.word 0x87802072  ! 1922: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2de49e0  ! 1923: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r9
	.word 0x87802020  ! 1924: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2862000  ! 1925: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1926: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4cd84a0  ! 1927: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	.word 0x87802074  ! 1928: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8aee000  ! 1929: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xd8be6000  ! 1930: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	mov	0x60, %r24
	mov	0x3c0, %r22
	.word 0xd6d44400  ! 1933: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	.word 0x87802020  ! 1934: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 1935: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1936: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c544a0  ! 1937: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r10
	mov	0x3f0, %r22
	mov	0x70, %r17
	.word 0x87802020  ! 1940: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa72000  ! 1941: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 1942: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r19
	.word 0x87802020  ! 1944: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r27
	.word 0x87802073  ! 1946: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 1947: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda876000  ! 1948: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xd6d74e40  ! 1949: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r11
	.word 0x8780204f  ! 1950: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeb7a000  ! 1951: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x40, %r19
	.word 0xdef7a000  ! 1953: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xd2a78e40  ! 1954: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	mov	0x3e0, %r21
	.word 0xd6afe000  ! 1956: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xdabd44a0  ! 1957: STDA_R	stda	%r13, [%r21 + %r0] 0x25
	.word 0xd2bf6000  ! 1958: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd8c70e60  ! 1959: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r12
	.word 0xdeb44400  ! 1960: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xd8d7a000  ! 1961: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8bfe000  ! 1962: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd88f6000  ! 1963: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	mov	0x3e8, %r21
	.word 0xd8b7e000  ! 1965: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 1966: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x8, %r26
	mov	0x18, %r19
	mov	0x48, %r26
	.word 0x87802025  ! 1970: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88ec9e0  ! 1972: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0xdaf6a000  ! 1973: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	.word 0xdadc8400  ! 1974: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xd6878e80  ! 1975: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r11
	.word 0xd0b6a000  ! 1976: STHA_I	stha	%r8, [%r26 + 0x0000] %asi
	.word 0x87802025  ! 1977: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdacd44a0  ! 1978: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r13
	.word 0xd2aee000  ! 1979: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	mov	0x68, %r18
	.word 0xd0ad04a0  ! 1981: STBA_R	stba	%r8, [%r20 + %r0] 0x25
	.word 0xde940400  ! 1982: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	mov	0x3d8, %r21
	mov	0x48, %r25
	.word 0xd0866000  ! 1985: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r8
	.word 0xd0a62000  ! 1986: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	.word 0xdaf7ce60  ! 1987: STXA_R	stxa	%r13, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 1988: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab42000  ! 1989: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdadce000  ! 1990: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xd0a6c9e0  ! 1991: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xd6c7ce60  ! 1992: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	.word 0xdcbca000  ! 1993: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xd6c4c400  ! 1994: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r11
	.word 0xdadce000  ! 1995: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xd4c609e0  ! 1996: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0xd49c2000  ! 1997: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1998: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4af6000  ! 1999: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd0f4c400  ! 2000: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x10, %r18
	.word 0xd087e000  ! 2002: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd8a7ce60  ! 2003: STWA_R	stwa	%r12, [%r31 + %r0] 0x73
	.word 0x87802025  ! 2004: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf6e000  ! 2005: STXA_I	stxa	%r14, [%r27 + 0x0000] %asi
	.word 0xdebf0e80  ! 2006: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	mov	0x68, %r16
	.word 0xda9ea000  ! 2008: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2009: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadd44a0  ! 2010: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	.word 0xd2b7ce40  ! 2011: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0x87802072  ! 2012: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 2013: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac70e40  ! 2014: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	mov	0x70, %r18
	.word 0x87802020  ! 2016: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca649e0  ! 2017: STWA_R	stwa	%r14, [%r25 + %r0] 0x4f
	mov	0x7d0, %r21
	.word 0xd8d504a0  ! 2019: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0xd8b4a000  ! 2020: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd8f4a000  ! 2021: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xd4b7ce40  ! 2022: STHA_R	stha	%r10, [%r31 + %r0] 0x72
	.word 0xda8f0e60  ! 2023: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	mov	0x7c0, %r21
	mov	0x7c0, %r23
	.word 0x87802025  ! 2026: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r17
	mov	0x60, %r18
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6ce89e0  ! 2030: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r11
	.word 0xd0cf6000  ! 2031: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd6f44400  ! 2032: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xdc85c4a0  ! 2033: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0x87802074  ! 2034: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6ae89e0  ! 2035: STBA_R	stba	%r11, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 2036: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8978e40  ! 2037: LDUHA_R	lduha	[%r30, %r0] 0x72, %r12
	mov	0x7f8, %r23
	mov	0x30, %r26
	.word 0xdc95e000  ! 2040: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	.word 0xdcf52000  ! 2041: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xd6b6c9e0  ! 2043: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xdccec9e0  ! 2044: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	.word 0xdedda000  ! 2045: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r15
	.word 0xd6af8e80  ! 2046: STBA_R	stba	%r11, [%r30 + %r0] 0x74
	.word 0xd4a74e80  ! 2047: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	.word 0xd6a74e60  ! 2048: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0xd4be89e0  ! 2049: STDA_R	stda	%r10, [%r26 + %r0] 0x4f
	.word 0xd2ada000  ! 2050: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0x87802025  ! 2051: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r19
	.word 0xd2c72000  ! 2053: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2054: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2055: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r22
	mov	0x8, %r24
	.word 0xd2bf6000  ! 2058: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x10, %r18
	.word 0x87802025  ! 2060: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd29f6000  ! 2061: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd0dec9e0  ! 2062: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r8
	.word 0xd6cfa000  ! 2063: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r11
	.word 0xd8a40400  ! 2064: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xde9e89e0  ! 2065: LDDA_R	ldda	[%r26, %r0] 0x4f, %r15
	mov	0x3f0, %r20
	.word 0xd4b504a0  ! 2067: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xd897a000  ! 2068: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r12
	mov	0x28, %r18
	mov	0x78, %r27
	mov	0x40, %r17
	.word 0xd0f74e80  ! 2072: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd297ce60  ! 2073: LDUHA_R	lduha	[%r31, %r0] 0x73, %r9
	mov	0x8, %r18
	.word 0xdea70e80  ! 2075: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	mov	0x18, %r18
	.word 0xd09f6000  ! 2077: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r8
	mov	0x3d0, %r20
	.word 0xd4a74e80  ! 2079: STWA_R	stwa	%r10, [%r29 + %r0] 0x74
	.word 0xd8af6000  ! 2080: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	mov	0x60, %r16
	mov	0x3c8, %r22
	.word 0x87802020  ! 2083: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69c0400  ! 2084: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0xdef7ce60  ! 2085: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	mov	0x68, %r24
	.word 0xd4a649e0  ! 2087: STWA_R	stwa	%r10, [%r25 + %r0] 0x4f
	mov	0x30, %r26
	.word 0xd0b7e000  ! 2089: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd2b48400  ! 2090: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd0876000  ! 2091: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd0c72000  ! 2092: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xdea40400  ! 2093: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	.word 0xd8ad44a0  ! 2094: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	.word 0x87802020  ! 2095: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r26
	.word 0xd8d504a0  ! 2097: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0x87802074  ! 2098: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaaf0e80  ! 2099: STBA_R	stba	%r13, [%r28 + %r0] 0x74
	.word 0xd0a7e000  ! 2100: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2101: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0af2000  ! 2102: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd0bfe000  ! 2103: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	mov	0x0, %r27
	mov	0x70, %r26
	.word 0xdaf78e60  ! 2106: STXA_R	stxa	%r13, [%r30 + %r0] 0x73
	.word 0x87802074  ! 2107: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r21
	.word 0xd6bfa000  ! 2109: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 2110: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde9ec9e0  ! 2111: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0x87802025  ! 2112: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcd62000  ! 2113: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2114: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 2115: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2116: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r18
	.word 0xdcd7e000  ! 2118: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r14
	.word 0xdcb7e000  ! 2119: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x7e8, %r22
	mov	0x38, %r24
	mov	0x48, %r16
	.word 0x87802073  ! 2123: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbce000  ! 2124: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	mov	0x18, %r24
	.word 0xdc846000  ! 2126: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	mov	0x10, %r27
	.word 0x87802074  ! 2128: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeafce60  ! 2129: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xdcc4c400  ! 2130: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xdedc6000  ! 2131: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 2132: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdca5c4a0  ! 2133: STWA_R	stwa	%r14, [%r23 + %r0] 0x25
	.word 0x87802072  ! 2134: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd684c400  ! 2135: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r11
	mov	0x38, %r24
	.word 0xdaaea000  ! 2137: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	mov	0x50, %r25
	.word 0x87802020  ! 2139: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf7ce40  ! 2140: STXA_R	stxa	%r14, [%r31 + %r0] 0x72
	.word 0xd4ac8400  ! 2141: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0xd8bc0400  ! 2142: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xdab609e0  ! 2143: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 2144: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r16
	.word 0xd8a7a000  ! 2146: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xdcb78e60  ! 2147: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xd297a000  ! 2148: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2149: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ccc400  ! 2150: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r9
	mov	0x3d8, %r20
	mov	0x68, %r24
	mov	0x8, %r16
	.word 0x87802020  ! 2154: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r25
	mov	0x0, %r26
	.word 0x8780204f  ! 2157: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdead6000  ! 2158: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0xde952000  ! 2159: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r15
	.word 0xdeb5e000  ! 2160: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xdeade000  ! 2161: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0x87802025  ! 2162: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdeb76000  ! 2163: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	.word 0xdea76000  ! 2164: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xd2d7ce80  ! 2165: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0xd4a7a000  ! 2166: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd6b40400  ! 2167: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xdea504a0  ! 2168: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	.word 0xded7e000  ! 2169: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xde976000  ! 2170: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	mov	0x60, %r25
	.word 0xde87a000  ! 2172: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	mov	0x7c0, %r22
	.word 0x87802020  ! 2174: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde976000  ! 2175: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xdcb40400  ! 2176: STHA_R	stha	%r14, [%r16 + %r0] 0x20
	.word 0xd08f2000  ! 2177: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xded40400  ! 2178: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 2179: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r24
	mov	0x30, %r18
	.word 0x8780204f  ! 2182: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6b649e0  ! 2183: STHA_R	stha	%r11, [%r25 + %r0] 0x4f
	.word 0xdc8689e0  ! 2184: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	.word 0xd2b42000  ! 2185: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0xdea44400  ! 2186: STWA_R	stwa	%r15, [%r17 + %r0] 0x20
	.word 0xd08fce80  ! 2187: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0xd8c42000  ! 2188: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	.word 0xd8c46000  ! 2189: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	.word 0xd6c649e0  ! 2190: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r11
	.word 0x87802020  ! 2191: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd687e000  ! 2192: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2193: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2194: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r27
	.word 0xd8df8e40  ! 2196: LDXA_R	ldxa	[%r30, %r0] 0x72, %r12
	mov	0x30, %r24
	.word 0x87802020  ! 2198: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r24
	mov	0x58, %r27
	.word 0xd2b504a0  ! 2201: STHA_R	stha	%r9, [%r20 + %r0] 0x25
	.word 0xdeae49e0  ! 2202: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0xd4c7ce80  ! 2203: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xdaa48400  ! 2204: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0x87802074  ! 2205: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r19
	.word 0xd49f2000  ! 2207: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	mov	0x3c8, %r20
	.word 0xd6dd44a0  ! 2209: LDXA_R	ldxa	[%r21, %r0] 0x25, %r11
	mov	0x3d8, %r23
	.word 0xd8b70e60  ! 2211: STHA_R	stha	%r12, [%r28 + %r0] 0x73
	.word 0xda96c9e0  ! 2212: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r13
	.word 0xdcb44400  ! 2213: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x78, %r27
	.word 0xd29fa000  ! 2215: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f7a000  ! 2216: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd29fe000  ! 2217: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	mov	0x18, %r24
	.word 0xde85c4a0  ! 2219: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r15
	mov	0x8, %r24
	.word 0xd0f4c400  ! 2221: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x78, %r18
	.word 0x87802025  ! 2223: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r26
	.word 0xdabde000  ! 2225: STDA_I	stda	%r13, [%r23 + 0x0000] %asi
	.word 0xd4870e40  ! 2226: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r10
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6f5e000  ! 2228: STXA_I	stxa	%r11, [%r23 + 0x0000] %asi
	.word 0xd6974e60  ! 2229: LDUHA_R	lduha	[%r29, %r0] 0x73, %r11
	.word 0x87802025  ! 2230: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2b7e000  ! 2231: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd6c78e60  ! 2233: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r11
	.word 0xdef7e000  ! 2234: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xdedf6000  ! 2235: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r15
	mov	0x7f0, %r21
	mov	0x18, %r27
	mov	0x28, %r26
	mov	0x3e8, %r23
	.word 0x87802072  ! 2240: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2974e60  ! 2241: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0xd4a4e000  ! 2242: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd69e89e0  ! 2243: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	mov	0x20, %r27
	mov	0x68, %r26
	.word 0xd4d7ce80  ! 2246: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r10
	.word 0xd09f0e40  ! 2247: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	mov	0x40, %r25
	.word 0xd4a44400  ! 2249: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	mov	0x7f0, %r23
	.word 0xd8cf0e80  ! 2251: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r12
	.word 0xd684e000  ! 2252: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0xd6b4e000  ! 2253: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd2afce40  ! 2254: STBA_R	stba	%r9, [%r31 + %r0] 0x72
	.word 0xdeddc4a0  ! 2255: LDXA_R	ldxa	[%r23, %r0] 0x25, %r15
	.word 0xd6f4a000  ! 2256: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	.word 0xd6a42000  ! 2257: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	mov	0x50, %r25
	.word 0xd684e000  ! 2259: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2260: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6f44400  ! 2261: STXA_R	stxa	%r11, [%r17 + %r0] 0x20
	.word 0xd2c6c9e0  ! 2262: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	.word 0xded70e60  ! 2263: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r15
	.word 0x87802020  ! 2264: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc8e6000  ! 2265: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r14
	mov	0x70, %r24
	mov	0x7e8, %r20
	.word 0xd0f40400  ! 2268: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	mov	0x40, %r16
	.word 0x8780204f  ! 2270: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6d4e000  ! 2271: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r11
	.word 0x87802073  ! 2272: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdc9f0e40  ! 2273: LDDA_R	ldda	[%r28, %r0] 0x72, %r14
	.word 0xd084e000  ! 2274: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r8
	mov	0x78, %r16
	.word 0xd0ac2000  ! 2276: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd0b4a000  ! 2277: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 2278: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c0, %r22
	mov	0x28, %r17
	.word 0xd0bde000  ! 2281: STDA_I	stda	%r8, [%r23 + 0x0000] %asi
	.word 0xd0dda000  ! 2282: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r8
	.word 0xd095a000  ! 2283: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r8
	.word 0xd88ec9e0  ! 2284: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0x87802025  ! 2285: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r18
	.word 0xd8cf2000  ! 2287: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	mov	0x0, %r16
	.word 0xd8afa000  ! 2289: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xdad48400  ! 2290: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r13
	.word 0xd0b76000  ! 2291: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd68f4e60  ! 2292: LDUBA_R	lduba	[%r29, %r0] 0x73, %r11
	.word 0xdaa48400  ! 2293: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	mov	0x78, %r26
	.word 0xd6dfce60  ! 2295: LDXA_R	ldxa	[%r31, %r0] 0x73, %r11
	.word 0xd4f7a000  ! 2296: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4c7a000  ! 2297: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	mov	0x0, %r25
	mov	0x18, %r16
	.word 0x87802073  ! 2300: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2301: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ddc4a0  ! 2302: LDXA_R	ldxa	[%r23, %r0] 0x25, %r12
	mov	0x3f8, %r23
	.word 0xdea7ce60  ! 2304: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	.word 0xda8c4400  ! 2305: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xd49e2000  ! 2306: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r10
	mov	0x50, %r18
	.word 0xd4be2000  ! 2308: STDA_I	stda	%r10, [%r24 + 0x0000] %asi
	.word 0xdc944400  ! 2309: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	mov	0x3c0, %r22
	.word 0x87802020  ! 2311: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r25
	.word 0xd0b70e80  ! 2313: STHA_R	stha	%r8, [%r28 + %r0] 0x74
	.word 0xdcbf6000  ! 2314: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdc872000  ! 2315: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2316: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r16
	.word 0xdaa4c400  ! 2318: STWA_R	stwa	%r13, [%r19 + %r0] 0x20
	.word 0xd4dfe000  ! 2319: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x3e8, %r20
	.word 0xd0cd84a0  ! 2321: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r8
	.word 0xd6c72000  ! 2322: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r11
	.word 0xd2df4e80  ! 2323: LDXA_R	ldxa	[%r29, %r0] 0x74, %r9
	.word 0xd6b72000  ! 2324: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xdcf544a0  ! 2325: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0xd6a7e000  ! 2326: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6f72000  ! 2327: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xde84c400  ! 2328: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r15
	.word 0xd2b7a000  ! 2329: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd8a74e80  ! 2330: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	mov	0x0, %r19
	.word 0xdef7a000  ! 2332: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdc8f4e80  ! 2333: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	.word 0xdeaf6000  ! 2334: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0xd4cf0e40  ! 2335: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r10
	mov	0x58, %r17
	.word 0xde87e000  ! 2337: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 2338: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 2339: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdecfe000  ! 2340: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xde876000  ! 2341: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r15
	.word 0xdea76000  ! 2342: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2343: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r20
	.word 0x87802072  ! 2345: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdebce000  ! 2346: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xd48f4e40  ! 2347: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	.word 0xd2bc2000  ! 2348: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2349: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd497ce40  ! 2350: LDUHA_R	lduha	[%r31, %r0] 0x72, %r10
	.word 0x87802020  ! 2351: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded7ce80  ! 2352: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r15
	.word 0xd2bc8400  ! 2353: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2354: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2355: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0d42000  ! 2356: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0xd0a4e000  ! 2357: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd4f7ce40  ! 2358: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0x87802074  ! 2359: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb74e80  ! 2360: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	mov	0x3c0, %r20
	mov	0x58, %r26
	.word 0xdea7a000  ! 2363: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdea7e000  ! 2364: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd8a7ce80  ! 2365: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0xdea7e000  ! 2366: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xdedf2000  ! 2368: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xded7e000  ! 2369: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x70, %r26
	.word 0xda8609e0  ! 2371: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r13
	.word 0x8780204f  ! 2372: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f7ce60  ! 2373: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0xd4ac4400  ! 2374: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0x87802072  ! 2375: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc878e80  ! 2376: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r14
	.word 0xdab66000  ! 2377: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0x87802073  ! 2378: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2379: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4af4e40  ! 2380: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	.word 0xd6cf8e80  ! 2381: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0xde8de000  ! 2382: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r15
	.word 0xdc8e09e0  ! 2383: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0x87802074  ! 2384: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2385: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6d4a000  ! 2386: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0xd6f48400  ! 2387: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0xd6bf0e60  ! 2388: STDA_R	stda	%r11, [%r28 + %r0] 0x73
	mov	0x7e0, %r22
	mov	0x10, %r18
	.word 0xdaaca000  ! 2391: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xd2bcc400  ! 2392: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0x87802020  ! 2393: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb649e0  ! 2394: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xdcacc400  ! 2395: STBA_R	stba	%r14, [%r19 + %r0] 0x20
	mov	0x40, %r24
	.word 0xdcc76000  ! 2397: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2398: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca4e000  ! 2399: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4bd84a0  ! 2401: STDA_R	stda	%r10, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 2402: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeaca000  ! 2403: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xd0bd04a0  ! 2404: STDA_R	stda	%r8, [%r20 + %r0] 0x25
	.word 0xdcc4a000  ! 2405: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	mov	0x60, %r19
	mov	0x60, %r26
	.word 0xd0f40400  ! 2408: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xdedca000  ! 2409: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdebca000  ! 2410: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xd29f4e40  ! 2411: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xd0d40400  ! 2412: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r8
	.word 0x87802073  ! 2413: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r19
	.word 0xdcf76000  ! 2415: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xd4af0e60  ! 2416: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 2417: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49ca000  ! 2418: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xde948400  ! 2419: LDUHA_R	lduha	[%r18, %r0] 0x20, %r15
	.word 0xdcd42000  ! 2420: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r14
	.word 0xdcbca000  ! 2421: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	mov	0x7d8, %r23
	mov	0x3c0, %r23
	.word 0xdcac6000  ! 2424: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xd08f0e40  ! 2425: LDUBA_R	lduba	[%r28, %r0] 0x72, %r8
	.word 0xdecc6000  ! 2426: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r15
	mov	0x50, %r18
	.word 0xdec46000  ! 2428: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	mov	0x7e0, %r23
	.word 0xdece09e0  ! 2430: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r15
	.word 0x87802072  ! 2431: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde97a000  ! 2432: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	.word 0xdecfe000  ! 2433: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xd0b44400  ! 2434: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xdaf7a000  ! 2435: STXA_I	stxa	%r13, [%r30 + 0x0000] %asi
	.word 0xdebe09e0  ! 2436: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0xd69f0e80  ! 2437: LDDA_R	ldda	[%r28, %r0] 0x74, %r11
	.word 0xd8a76000  ! 2438: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	mov	0x3f0, %r22
	.word 0xd2a78e40  ! 2440: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	.word 0x87802020  ! 2441: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f4c400  ! 2442: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd2b4a000  ! 2443: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	mov	0x40, %r16
	.word 0xd8c4c400  ! 2445: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0xd6942000  ! 2446: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	mov	0x48, %r26
	.word 0xdad584a0  ! 2448: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r13
	.word 0xdcbfce60  ! 2449: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	mov	0x0, %r16
	.word 0x87802020  ! 2451: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0af4e60  ! 2452: STBA_R	stba	%r8, [%r29 + %r0] 0x73
	.word 0xdadd44a0  ! 2453: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	.word 0xdca62000  ! 2454: STWA_I	stwa	%r14, [%r24 + 0x0000] %asi
	mov	0x7e8, %r20
	mov	0x8, %r24
	.word 0x87802073  ! 2457: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 2458: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcc72000  ! 2459: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf44400  ! 2460: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdea689e0  ! 2461: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 2462: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2cf2000  ! 2463: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 2464: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd8b40400  ! 2465: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0xdaa78e60  ! 2466: STWA_R	stwa	%r13, [%r30 + %r0] 0x73
	mov	0x3d0, %r20
	.word 0xdcbe49e0  ! 2468: STDA_R	stda	%r14, [%r25 + %r0] 0x4f
	.word 0xd8afa000  ! 2469: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd4aec9e0  ! 2470: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xdcb76000  ! 2471: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xd0be09e0  ! 2472: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd89f8e40  ! 2473: LDDA_R	ldda	[%r30, %r0] 0x72, %r12
	mov	0x40, %r19
	.word 0xd697e000  ! 2475: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 2476: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd6b7a000  ! 2477: STHA_I	stha	%r11, [%r30 + 0x0000] %asi
	.word 0xd6c76000  ! 2478: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 2479: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd08c0400  ! 2480: LDUBA_R	lduba	[%r16, %r0] 0x20, %r8
	mov	0x3e8, %r20
	.word 0xd8f72000  ! 2482: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd487ce60  ! 2483: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r10
	.word 0xd4bf2000  ! 2484: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd68ec9e0  ! 2485: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r11
	.word 0xde8689e0  ! 2486: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0x8780204f  ! 2487: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2488: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0c4a000  ! 2489: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xd09c2000  ! 2490: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r8
	.word 0xd08ca000  ! 2491: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2492: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0dfa000  ! 2493: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	mov	0x48, %r25
	.word 0x87802020  ! 2495: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f8, %r20
	.word 0xd0b7e000  ! 2497: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0xd0a7a000  ! 2498: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0f76000  ! 2499: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 2500: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x28, %r17
	.word 0xd8bf8e80  ! 2502: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0xd2f52000  ! 2503: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	.word 0x87802073  ! 2504: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r17
	mov	0x68, %r16
	.word 0x8780204f  ! 2507: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2508: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2ad6000  ! 2509: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd2d5a000  ! 2510: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r9
	.word 0xd2ada000  ! 2511: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xdac70e40  ! 2512: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	.word 0xd8d52000  ! 2513: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r12
	.word 0xd8dd6000  ! 2514: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0xd0b609e0  ! 2515: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	.word 0xd0cf4e40  ! 2516: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r8
	.word 0xd4b78e60  ! 2517: STHA_R	stha	%r10, [%r30 + %r0] 0x73
	.word 0xd2ad6000  ! 2518: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	mov	0x68, %r17
	.word 0xd2b52000  ! 2520: STHA_I	stha	%r9, [%r20 + 0x0000] %asi
	.word 0xd2a52000  ! 2521: STWA_I	stwa	%r9, [%r20 + 0x0000] %asi
	.word 0xdab504a0  ! 2522: STHA_R	stha	%r13, [%r20 + %r0] 0x25
	.word 0xd09f0e40  ! 2523: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xdc9d84a0  ! 2524: LDDA_R	ldda	[%r22, %r0] 0x25, %r14
	.word 0xd8844400  ! 2525: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	mov	0x18, %r19
	.word 0xdef5a000  ! 2527: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdca7ce80  ! 2528: STWA_R	stwa	%r14, [%r31 + %r0] 0x74
	.word 0xdcd52000  ! 2529: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xdc956000  ! 2530: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r14
	mov	0x7c8, %r21
	.word 0xdcc52000  ! 2532: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r14
	mov	0x7f8, %r21
	.word 0xd0b5c4a0  ! 2534: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	mov	0x78, %r18
	mov	0x70, %r24
	ta	T_CHANGE_HPRIV	! macro
	mov	0x68, %r24
	.word 0xd8d40400  ! 2539: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0x87802073  ! 2540: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 2541: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b6c9e0  ! 2542: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xdebc4400  ! 2543: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd4bea000  ! 2544: STDA_I	stda	%r10, [%r26 + 0x0000] %asi
	.word 0xdcdd44a0  ! 2545: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	.word 0xd8a62000  ! 2546: STWA_I	stwa	%r12, [%r24 + 0x0000] %asi
	.word 0xdc94c400  ! 2547: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	mov	0x20, %r24
	.word 0xd4c7ce40  ! 2549: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	.word 0x87802020  ! 2550: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda8f2000  ! 2551: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 2552: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf78e80  ! 2553: STXA_R	stxa	%r13, [%r30 + %r0] 0x74
	.word 0xd0b4e000  ! 2554: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0xd2b78e80  ! 2555: STHA_R	stha	%r9, [%r30 + %r0] 0x74
	.word 0xd69e49e0  ! 2556: LDDA_R	ldda	[%r25, %r0] 0x4f, %r11
	mov	0x7e8, %r22
	.word 0xdade89e0  ! 2558: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r13
	.word 0x87802020  ! 2559: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd894c400  ! 2560: LDUHA_R	lduha	[%r19, %r0] 0x20, %r12
	.word 0xde866000  ! 2561: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	.word 0xde86e000  ! 2562: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xd8970e60  ! 2563: LDUHA_R	lduha	[%r28, %r0] 0x73, %r12
	.word 0xd8862000  ! 2564: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	mov	0x30, %r16
	.word 0xd88ea000  ! 2566: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	.word 0xd8a66000  ! 2567: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8b62000  ! 2568: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xd8c62000  ! 2569: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r12
	.word 0xd8bee000  ! 2570: STDA_I	stda	%r12, [%r27 + 0x0000] %asi
	.word 0xd8d62000  ! 2571: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r12
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802072  ! 2573: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8f4a000  ! 2574: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	.word 0xdaacc400  ! 2575: STBA_R	stba	%r13, [%r19 + %r0] 0x20
	mov	0x50, %r25
	.word 0xd6b40400  ! 2577: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xd6cf8e60  ! 2578: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r11
	mov	0x48, %r17
	.word 0xd8b78e60  ! 2580: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0xd0afce80  ! 2581: STBA_R	stba	%r8, [%r31 + %r0] 0x74
	mov	0x50, %r16
	.word 0xd6aca000  ! 2583: STBA_I	stba	%r11, [%r18 + 0x0000] %asi
	.word 0xda970e60  ! 2584: LDUHA_R	lduha	[%r28, %r0] 0x73, %r13
	.word 0xdc94a000  ! 2585: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r14
	.word 0x87802072  ! 2586: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb56000  ! 2587: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0xdcd52000  ! 2588: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xd88609e0  ! 2589: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	.word 0xda87ce60  ! 2590: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r13
	.word 0x87802073  ! 2591: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x40, %r24
	.word 0xd8df2000  ! 2593: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bf2000  ! 2594: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xd8cfe000  ! 2596: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xde844400  ! 2597: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	mov	0x68, %r18
	.word 0xd48cc400  ! 2599: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0x87802020  ! 2600: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd89f4e60  ! 2601: LDDA_R	ldda	[%r29, %r0] 0x73, %r12
	.word 0xdacf0e80  ! 2602: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r13
	.word 0xdea584a0  ! 2603: STWA_R	stwa	%r15, [%r22 + %r0] 0x25
	.word 0x87802073  ! 2604: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c42000  ! 2605: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x68, %r25
	.word 0x8780204f  ! 2607: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8f70e80  ! 2608: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	mov	0x7f8, %r21
	mov	0x50, %r16
	.word 0xde87e000  ! 2611: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdab7ce80  ! 2612: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 2613: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802073  ! 2614: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r17
	.word 0xdc96c9e0  ! 2616: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	mov	0x78, %r17
	.word 0xd8bf4e40  ! 2618: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0xd8b72000  ! 2619: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bfe000  ! 2620: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd2bf0e40  ! 2621: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	mov	0x10, %r19
	.word 0xdccd04a0  ! 2623: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r14
	.word 0x87802020  ! 2624: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc85c4a0  ! 2625: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r14
	.word 0xd0f544a0  ! 2626: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0x87802073  ! 2627: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3e0, %r20
	mov	0x7f0, %r20
	mov	0x60, %r17
	.word 0xdadce000  ! 2631: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xda842000  ! 2632: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r13
	.word 0xdadce000  ! 2633: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xdaac2000  ! 2634: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xd4de49e0  ! 2635: LDXA_R	ldxa	[%r25, %r0] 0x4f, %r10
	.word 0xd4a70e80  ! 2636: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xd4ace000  ! 2637: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	mov	0x40, %r24
	.word 0x87802020  ! 2639: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69c8400  ! 2640: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	mov	0x7d8, %r21
	.word 0xd0f74e80  ! 2642: STXA_R	stxa	%r8, [%r29 + %r0] 0x74
	.word 0xd68ce000  ! 2643: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0x87802073  ! 2644: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f0, %r21
	.word 0xd6d70e80  ! 2646: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0x87802074  ! 2647: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x10, %r17
	.word 0xd2f609e0  ! 2649: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	mov	0x7c0, %r23
	.word 0xd4b5e000  ! 2651: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0xd4f52000  ! 2652: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xd68c0400  ! 2654: LDUBA_R	lduba	[%r16, %r0] 0x20, %r11
	.word 0xdad44400  ! 2655: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xdeb5a000  ! 2656: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xde9de000  ! 2658: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xdeb5a000  ! 2659: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	.word 0xdea6c9e0  ! 2660: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 2661: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedf8e40  ! 2662: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0xd2be2000  ! 2663: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd08e09e0  ! 2664: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r8
	.word 0xd4b66000  ! 2665: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x70, %r16
	.word 0xdcbf0e80  ! 2667: STDA_R	stda	%r14, [%r28 + %r0] 0x74
	.word 0xdcb4c400  ! 2668: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	.word 0xdabf0e80  ! 2669: STDA_R	stda	%r13, [%r28 + %r0] 0x74
	.word 0xd68f4e40  ! 2670: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	mov	0x7f8, %r21
	.word 0xdcc66000  ! 2672: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0xdabd04a0  ! 2673: STDA_R	stda	%r13, [%r20 + %r0] 0x25
	mov	0x68, %r26
	.word 0xd6966000  ! 2675: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r11
	mov	0x28, %r26
	.word 0xd0af0e40  ! 2677: STBA_R	stba	%r8, [%r28 + %r0] 0x72
	.word 0xd8866000  ! 2678: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xdac70e40  ! 2679: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r13
	mov	0x58, %r19
	.word 0xd0acc400  ! 2681: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	mov	0x78, %r19
	.word 0xd4a62000  ! 2683: STWA_I	stwa	%r10, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 2684: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r27
	.word 0xd4c7a000  ! 2686: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r10
	.word 0xd6b48400  ! 2687: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xd69f0e40  ! 2688: LDDA_R	ldda	[%r28, %r0] 0x72, %r11
	.word 0xd6cc8400  ! 2689: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	.word 0xd6a7a000  ! 2690: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6cf2000  ! 2691: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2692: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r17
	.word 0xdcbc4400  ! 2694: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xd4d52000  ! 2695: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r10
	.word 0x87802074  ! 2696: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4dd2000  ! 2697: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0xd495a000  ! 2698: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r10
	.word 0xd4cc8400  ! 2699: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	mov	0x30, %r19
	.word 0xd8d649e0  ! 2701: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r12
	.word 0xdc97ce60  ! 2702: LDUHA_R	lduha	[%r31, %r0] 0x73, %r14
	mov	0x7d0, %r22
	.word 0xd0b5e000  ! 2704: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0xd08da000  ! 2705: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r8
	.word 0xd8f70e80  ! 2706: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0x87802072  ! 2707: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0afce60  ! 2708: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	.word 0xdedf2000  ! 2709: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x28, %r19
	.word 0x87802074  ! 2711: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x8, %r26
	mov	0x30, %r27
	mov	0x0, %r17
	.word 0xdea46000  ! 2715: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd4978e60  ! 2717: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0xd8a4a000  ! 2718: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8c44400  ! 2719: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r12
	.word 0xdecd04a0  ! 2720: LDSBA_R	ldsba	[%r20, %r0] 0x25, %r15
	.word 0x87802020  ! 2721: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x20, %r26
	.word 0xd4df2000  ! 2723: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd48fa000  ! 2724: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802072  ! 2725: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x38, %r25
	mov	0x7d0, %r22
	.word 0xd08f4e80  ! 2728: LDUBA_R	lduba	[%r29, %r0] 0x74, %r8
	.word 0xd8b78e80  ! 2729: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xd4acc400  ! 2730: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd2a7e000  ! 2731: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 2732: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2c7e000  ! 2733: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd0cd44a0  ! 2734: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r8
	.word 0xd4f7a000  ! 2735: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xd48fe000  ! 2736: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4afa000  ! 2737: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	mov	0x7d8, %r23
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3f8, %r22
	.word 0xdea70e80  ! 2741: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0xd8df4e80  ! 2742: LDXA_R	ldxa	[%r29, %r0] 0x74, %r12
	.word 0xd8b78e80  ! 2743: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xd4af4e60  ! 2744: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	mov	0x60, %r26
	.word 0xd2d70e60  ! 2746: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	mov	0x28, %r19
	.word 0xd2bc8400  ! 2748: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xd086c9e0  ! 2749: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r8
	.word 0xdad76000  ! 2750: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r13
	.word 0xd6afce40  ! 2751: STBA_R	stba	%r11, [%r31 + %r0] 0x72
	mov	0x28, %r25
	.word 0x87802074  ! 2753: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4b70e80  ! 2754: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xd8bd04a0  ! 2755: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xdcdfe000  ! 2756: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdadf0e40  ! 2757: LDXA_R	ldxa	[%r28, %r0] 0x72, %r13
	mov	0x3d8, %r22
	.word 0xd2cfa000  ! 2759: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2b7a000  ! 2760: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xdebf0e80  ! 2761: STDA_R	stda	%r15, [%r28 + %r0] 0x74
	.word 0xd2c76000  ! 2762: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	mov	0x3c8, %r22
	.word 0xd2d7e000  ! 2764: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x0, %r24
	.word 0xd2d7e000  ! 2766: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0xd4f584a0  ! 2767: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 2768: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd48d2000  ! 2769: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	mov	0x50, %r27
	.word 0xd4b5c4a0  ! 2771: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	mov	0x28, %r19
	.word 0x87802020  ! 2773: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2774: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdea7e000  ! 2775: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd6bd44a0  ! 2776: STDA_R	stda	%r11, [%r21 + %r0] 0x25
	.word 0xdedfa000  ! 2777: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdcb44400  ! 2778: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xd0b7e000  ! 2779: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	mov	0x8, %r17
	mov	0x10, %r25
	.word 0xd29f4e40  ! 2782: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	.word 0xdaafe000  ! 2783: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 2784: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda87e000  ! 2785: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xd48fce80  ! 2786: LDUBA_R	lduba	[%r31, %r0] 0x74, %r10
	.word 0x87802074  ! 2787: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 2788: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb70e40  ! 2789: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0xd4cf4e60  ! 2790: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r10
	.word 0x87802074  ! 2791: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28609e0  ! 2792: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r9
	mov	0x7d0, %r20
	.word 0xdaa7a000  ! 2794: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xd4d7ce60  ! 2795: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r10
	.word 0xd09c4400  ! 2796: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x20, %r16
	.word 0xd8a7a000  ! 2798: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2799: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2978e40  ! 2800: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	.word 0xda8f8e40  ! 2801: LDUBA_R	lduba	[%r30, %r0] 0x72, %r13
	.word 0xda9f2000  ! 2802: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdaa7a000  ! 2803: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xdaafe000  ! 2804: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd0bf0e40  ! 2805: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	mov	0x20, %r17
	.word 0xd4848400  ! 2807: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r10
	.word 0xd287a000  ! 2808: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r9
	.word 0xda96c9e0  ! 2809: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r13
	.word 0xdec72000  ! 2810: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xd4a689e0  ! 2811: STWA_R	stwa	%r10, [%r26 + %r0] 0x4f
	.word 0xd8f7ce60  ! 2812: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0xde97ce80  ! 2813: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0xd0a72000  ! 2814: STWA_I	stwa	%r8, [%r28 + 0x0000] %asi
	mov	0x7e8, %r22
	mov	0x30, %r25
	mov	0x60, %r18
	mov	0x3e8, %r20
	.word 0xd0cf6000  ! 2819: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 2820: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0bce000  ! 2821: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x20, %r16
	mov	0x78, %r27
	.word 0xd6d78e40  ! 2824: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r11
	.word 0x87802025  ! 2825: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca76000  ! 2826: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xd8afce60  ! 2827: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	.word 0xd2cf8e40  ! 2828: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r9
	.word 0xd0d7e000  ! 2829: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	mov	0x10, %r17
	mov	0x10, %r27
	mov	0x70, %r27
	mov	0x7d8, %r20
	.word 0xd087a000  ! 2834: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r8
	.word 0xdebf8e80  ! 2835: STDA_R	stda	%r15, [%r30 + %r0] 0x74
	.word 0xdc972000  ! 2836: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf76000  ! 2837: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xdcf76000  ! 2838: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0xd2bf0e40  ! 2839: STDA_R	stda	%r9, [%r28 + %r0] 0x72
	.word 0x87802073  ! 2840: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdec4a000  ! 2841: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdcf5c4a0  ! 2842: STXA_R	stxa	%r14, [%r23 + %r0] 0x25
	.word 0xde9e09e0  ! 2843: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0xd4cd44a0  ! 2844: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r10
	.word 0xdc844400  ! 2845: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xd2a78e60  ! 2846: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	mov	0x48, %r17
	.word 0xd2bfce40  ! 2848: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xdedf0e60  ! 2849: LDXA_R	ldxa	[%r28, %r0] 0x73, %r15
	.word 0xdcf44400  ! 2850: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2851: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded7ce60  ! 2852: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r15
	.word 0xd0c584a0  ! 2853: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r8
	.word 0x87802072  ! 2854: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r24
	.word 0xd88ea000  ! 2856: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	mov	0x50, %r19
	mov	0x40, %r19
	.word 0xd8a6e000  ! 2859: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	mov	0x7d8, %r22
	mov	0x40, %r26
	.word 0xd8b62000  ! 2862: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xd8dee000  ! 2863: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r12
	.word 0xd2a584a0  ! 2864: STWA_R	stwa	%r9, [%r22 + %r0] 0x25
	.word 0x87802074  ! 2865: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebd04a0  ! 2866: STDA_R	stda	%r15, [%r20 + %r0] 0x25
	.word 0xdac5e000  ! 2867: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	.word 0xdad56000  ! 2868: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	mov	0x20, %r25
	.word 0xdedf0e80  ! 2870: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	mov	0x60, %r27
	.word 0xd8d6c9e0  ! 2872: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0x87802020  ! 2873: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f46000  ! 2874: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	mov	0x3d8, %r20
	.word 0xd6f5c4a0  ! 2876: STXA_R	stxa	%r11, [%r23 + %r0] 0x25
	.word 0xd0cf8e60  ! 2877: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	.word 0xd8bf4e40  ! 2878: STDA_R	stda	%r12, [%r29 + %r0] 0x72
	.word 0x8780204f  ! 2879: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca48400  ! 2880: STWA_R	stwa	%r14, [%r18 + %r0] 0x20
	.word 0xd8974e40  ! 2881: LDUHA_R	lduha	[%r29, %r0] 0x72, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3c8, %r23
	mov	0x7d8, %r21
	.word 0xd6f74e40  ! 2885: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0x87802074  ! 2886: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdadc0400  ! 2887: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0xd0a52000  ! 2888: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	mov	0x10, %r24
	.word 0xd0852000  ! 2890: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r8
	mov	0x40, %r18
	.word 0x87802025  ! 2892: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6f40400  ! 2893: STXA_R	stxa	%r11, [%r16 + %r0] 0x20
	.word 0xd2b44400  ! 2894: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xda84c400  ! 2895: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r13
	.word 0x8780204f  ! 2896: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2897: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89f2000  ! 2898: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r12
	.word 0xdaaf4e80  ! 2899: STBA_R	stba	%r13, [%r29 + %r0] 0x74
	.word 0x87802073  ! 2900: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d76000  ! 2901: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd4bfe000  ! 2902: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xd0acc400  ! 2903: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd4bf8e60  ! 2904: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0xd6f72000  ! 2905: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xdaf70e40  ! 2906: STXA_R	stxa	%r13, [%r28 + %r0] 0x72
	.word 0xdaad44a0  ! 2907: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0xd4bd04a0  ! 2908: STDA_R	stda	%r10, [%r20 + %r0] 0x25
	mov	0x58, %r25
	.word 0x87802073  ! 2910: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b689e0  ! 2911: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xdc870e60  ! 2912: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r14
	.word 0xdca609e0  ! 2913: STWA_R	stwa	%r14, [%r24 + %r0] 0x4f
	.word 0xd2b544a0  ! 2914: STHA_R	stha	%r9, [%r21 + %r0] 0x25
	mov	0x20, %r18
	.word 0xdade6000  ! 2916: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r13
	.word 0xdace6000  ! 2917: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r13
	.word 0xd4d70e60  ! 2918: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	.word 0xd2966000  ! 2919: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	.word 0xd0974e40  ! 2920: LDUHA_R	lduha	[%r29, %r0] 0x72, %r8
	.word 0xd8f74e80  ! 2921: STXA_R	stxa	%r12, [%r29 + %r0] 0x74
	mov	0x50, %r16
	.word 0x87802020  ! 2923: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b4c400  ! 2924: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	mov	0x30, %r26
	.word 0xd68f2000  ! 2926: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xdabcc400  ! 2927: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xd6bf6000  ! 2928: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 2929: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6972000  ! 2930: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0x87802025  ! 2931: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68ce000  ! 2932: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r11
	.word 0xd2ac4400  ! 2933: STBA_R	stba	%r9, [%r17 + %r0] 0x20
	.word 0xd69f0e80  ! 2934: LDDA_R	ldda	[%r28, %r0] 0x74, %r11
	.word 0xd8bec9e0  ! 2935: STDA_R	stda	%r12, [%r27 + %r0] 0x4f
	.word 0xd8bfce80  ! 2936: STDA_R	stda	%r12, [%r31 + %r0] 0x74
	.word 0xd6d5c4a0  ! 2937: LDSHA_R	ldsha	[%r23, %r0] 0x25, %r11
	.word 0xdcaca000  ! 2938: STBA_I	stba	%r14, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 2939: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2940: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca46000  ! 2941: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdc846000  ! 2942: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r14
	.word 0xdcf4a000  ! 2943: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcd4a000  ! 2944: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	mov	0x7d0, %r21
	mov	0x7d8, %r22
	.word 0xdcf4a000  ! 2947: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 2948: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 2949: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2948400  ! 2950: LDUHA_R	lduha	[%r18, %r0] 0x20, %r9
	.word 0xd0970e60  ! 2951: LDUHA_R	lduha	[%r28, %r0] 0x73, %r8
	mov	0x30, %r27
	.word 0xd6a7e000  ! 2953: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xdebf4e80  ! 2954: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	.word 0xd0d7e000  ! 2955: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	.word 0x87802074  ! 2956: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a7ce60  ! 2957: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0xd2be89e0  ! 2958: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	.word 0xd2ae2000  ! 2959: STBA_I	stba	%r9, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 2960: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r22
	mov	0x58, %r16
	.word 0x87802072  ! 2963: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dd84a0  ! 2964: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0xdaae49e0  ! 2965: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	mov	0x3c8, %r20
	.word 0xd09f0e60  ! 2967: LDDA_R	ldda	[%r28, %r0] 0x73, %r8
	.word 0xda85c4a0  ! 2968: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r13
	mov	0x7d0, %r23
	mov	0x68, %r24
	mov	0x30, %r16
	.word 0xd6bfce40  ! 2972: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xdadf8e40  ! 2973: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	mov	0x3e0, %r23
	.word 0x87802020  ! 2975: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0df0e60  ! 2976: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	.word 0x87802074  ! 2977: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r17
	.word 0xdadfce80  ! 2979: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	mov	0x50, %r26
	.word 0x87802072  ! 2981: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde84a000  ! 2982: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	mov	0x38, %r26
	.word 0xdef649e0  ! 2984: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xd8a7ce80  ! 2985: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	mov	0x40, %r26
	mov	0x3c8, %r20
	.word 0xd0cec9e0  ! 2988: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r8
	mov	0x48, %r25
	.word 0xd0bfce40  ! 2990: STDA_R	stda	%r8, [%r31 + %r0] 0x72
	.word 0xd2a46000  ! 2991: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	mov	0x70, %r25
	.word 0xd4f70e60  ! 2993: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0xd2a4e000  ! 2994: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 2995: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2af2000  ! 2996: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xdca70e60  ! 2997: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xdcf7e000  ! 2998: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0xd4f6c9e0  ! 2999: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 3000: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r22
	.word 0xd6846000  ! 3002: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0xdcf584a0  ! 3003: STXA_R	stxa	%r14, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3004: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a52000  ! 3005: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xd2ac0400  ! 3006: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xdeb52000  ! 3007: STHA_I	stha	%r15, [%r20 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x68, %r26
	.word 0x87802072  ! 3010: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3011: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7f8, %r22
	.word 0xdedfe000  ! 3013: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xdea7a000  ! 3014: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xdab544a0  ! 3015: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	.word 0xdec76000  ! 3016: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd0bc0400  ! 3017: STDA_R	stda	%r8, [%r16 + %r0] 0x20
	.word 0xd487a000  ! 3018: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xdadf8e40  ! 3019: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0x87802020  ! 3020: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bc2000  ! 3021: STDA_I	stda	%r9, [%r16 + 0x0000] %asi
	.word 0xd2c46000  ! 3022: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3023: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd294a000  ! 3024: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xdadf0e40  ! 3025: LDXA_R	ldxa	[%r28, %r0] 0x72, %r13
	mov	0x0, %r18
	mov	0x8, %r18
	.word 0xd0970e80  ! 3028: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	mov	0x18, %r18
	mov	0x60, %r24
	.word 0x87802074  ! 3031: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3032: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8c4400  ! 3033: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0x87802072  ! 3034: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r17
	mov	0x38, %r17
	mov	0x48, %r16
	mov	0x7e0, %r22
	.word 0xde972000  ! 3039: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xde9fe000  ! 3040: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3041: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdebfe000  ! 3042: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0x87802073  ! 3043: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r18
	mov	0x3f0, %r23
	.word 0xd0dc0400  ! 3046: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd4afa000  ! 3047: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4d72000  ! 3048: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	mov	0x3e0, %r22
	.word 0xd4876000  ! 3050: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd6bc8400  ! 3051: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	.word 0xd69fe000  ! 3052: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b7e000  ! 3053: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xd6d76000  ! 3055: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r11
	.word 0xd28e49e0  ! 3056: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r9
	.word 0xd68fe000  ! 3057: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r11
	.word 0xdef4c400  ! 3058: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	mov	0x3e8, %r22
	.word 0xd2f7a000  ! 3060: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd09fce60  ! 3061: LDDA_R	ldda	[%r31, %r0] 0x73, %r8
	mov	0x3f8, %r21
	.word 0xd8cf8e40  ! 3063: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r12
	mov	0x7d8, %r22
	.word 0x87802074  ! 3065: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6c76000  ! 3066: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6c76000  ! 3067: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6b72000  ! 3068: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 3069: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdec9e0  ! 3070: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0xdcd7ce80  ! 3071: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	mov	0x60, %r18
	mov	0x58, %r26
	.word 0xd0a7e000  ! 3074: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0cfa000  ! 3075: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	.word 0xd0b72000  ! 3076: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 3077: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0c4e000  ! 3079: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r8
	.word 0xd0a4e000  ! 3080: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0b46000  ! 3081: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xdc9f0e80  ! 3082: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0x87802020  ! 3083: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49fe000  ! 3084: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3085: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6af4e40  ! 3086: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	mov	0x30, %r27
	.word 0xd4af8e60  ! 3088: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	mov	0x58, %r24
	.word 0xd6df0e60  ! 3090: LDXA_R	ldxa	[%r28, %r0] 0x73, %r11
	mov	0x68, %r26
	.word 0x87802020  ! 3092: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac8400  ! 3093: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0x87802025  ! 3094: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcf40400  ! 3095: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xd69fa000  ! 3096: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0xdcd74e60  ! 3097: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r14
	.word 0xd28649e0  ! 3098: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r9
	.word 0x87802074  ! 3099: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3100: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8ca000  ! 3101: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r13
	mov	0x18, %r24
	.word 0xdef48400  ! 3103: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	mov	0x7c8, %r20
	mov	0x48, %r27
	.word 0xdecfce40  ! 3106: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r15
	mov	0x8, %r19
	.word 0xd49f0e80  ! 3108: LDDA_R	ldda	[%r28, %r0] 0x74, %r10
	mov	0x70, %r25
	.word 0xd2946000  ! 3110: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2dce000  ! 3111: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r9
	.word 0xd28c2000  ! 3112: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0x87802020  ! 3113: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2f52000  ! 3114: STXA_I	stxa	%r9, [%r20 + 0x0000] %asi
	mov	0x7c8, %r22
	.word 0xd4cc8400  ! 3116: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r10
	mov	0x3f0, %r20
	mov	0x7f0, %r21
	.word 0xd8b74e40  ! 3119: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	.word 0xd4ce49e0  ! 3120: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0xd0f56000  ! 3121: STXA_I	stxa	%r8, [%r21 + 0x0000] %asi
	.word 0xd0ad2000  ! 3122: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xd0bd2000  ! 3124: STDA_I	stda	%r8, [%r20 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xd0dd2000  ! 3126: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r8
	.word 0xd09d6000  ! 3127: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r8
	.word 0xd4940400  ! 3128: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	.word 0xdebda000  ! 3129: STDA_I	stda	%r15, [%r22 + 0x0000] %asi
	.word 0xdea5e000  ! 3130: STWA_I	stwa	%r15, [%r23 + 0x0000] %asi
	.word 0xdea78e80  ! 3131: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	mov	0x20, %r27
	.word 0xd0a5e000  ! 3133: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 3134: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0cf6000  ! 3135: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xda974e40  ! 3136: LDUHA_R	lduha	[%r29, %r0] 0x72, %r13
	mov	0x48, %r26
	.word 0x87802025  ! 3138: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8f4e40  ! 3139: LDUBA_R	lduba	[%r29, %r0] 0x72, %r15
	mov	0x7d8, %r22
	mov	0x30, %r24
	mov	0x18, %r19
	.word 0xd8c74e80  ! 3143: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r12
	.word 0x87802074  ! 3144: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2d44400  ! 3145: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0xdcce09e0  ! 3146: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r14
	.word 0x87802074  ! 3147: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d44400  ! 3148: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0xd2bc6000  ! 3149: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	.word 0xd2d46000  ! 3150: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r9
	.word 0xd08f4e80  ! 3151: LDUBA_R	lduba	[%r29, %r0] 0x74, %r8
	.word 0x87802020  ! 3152: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b70e60  ! 3153: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xd4af6000  ! 3154: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	mov	0x8, %r19
	mov	0x40, %r24
	mov	0x0, %r25
	.word 0xd4a7e000  ! 3158: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4bf2000  ! 3159: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x18, %r17
	.word 0xd6cec9e0  ! 3161: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	.word 0xd2c72000  ! 3162: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2cfa000  ! 3163: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 3164: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2ac2000  ! 3165: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd29c2000  ! 3166: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd48d04a0  ! 3167: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0xd6bcc400  ! 3168: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0x87802074  ! 3169: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r26
	mov	0x3e0, %r22
	.word 0xd696a000  ! 3172: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	mov	0x60, %r16
	.word 0xd484c400  ! 3174: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	mov	0x18, %r26
	mov	0x40, %r17
	.word 0xd6962000  ! 3177: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	.word 0xd6a66000  ! 3178: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	mov	0x7f0, %r23
	.word 0xd6b6e000  ! 3180: STHA_I	stha	%r11, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 3181: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x8780204f  ! 3182: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bfe000  ! 3183: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3184: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a48400  ! 3185: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	mov	0x7d0, %r23
	.word 0xd0ad84a0  ! 3187: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	.word 0xdac42000  ! 3188: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r13
	mov	0x78, %r26
	.word 0xd4b48400  ! 3190: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xda870e80  ! 3191: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r13
	.word 0x87802020  ! 3192: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d70e60  ! 3193: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	.word 0xd2b7e000  ! 3194: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2cf6000  ! 3195: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 3196: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x18, %r26
	mov	0x38, %r17
	mov	0x7f8, %r23
	.word 0x87802074  ! 3200: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3201: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cf2000  ! 3202: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2afa000  ! 3203: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xd29fa000  ! 3205: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd4b504a0  ! 3206: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xdcd4c400  ! 3207: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r14
	.word 0xd8f72000  ! 3208: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8d76000  ! 3209: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x30, %r24
	.word 0xd887a000  ! 3211: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3212: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbcc400  ! 3213: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xdede89e0  ! 3214: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	.word 0xd6be09e0  ! 3215: STDA_R	stda	%r11, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 3216: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3217: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8af4e60  ! 3218: STBA_R	stba	%r12, [%r29 + %r0] 0x73
	mov	0x50, %r18
	.word 0xd4978e40  ! 3220: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0xdaa5a000  ! 3221: STWA_I	stwa	%r13, [%r22 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xdaf5e000  ! 3223: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0x87802074  ! 3225: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdabf6000  ! 3226: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd8b70e80  ! 3227: STHA_R	stha	%r12, [%r28 + %r0] 0x74
	mov	0x50, %r17
	.word 0xd6f4c400  ! 3229: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	.word 0xd8bfe000  ! 3230: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8d76000  ! 3231: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	mov	0x7c0, %r22
	.word 0xd8d7a000  ! 3233: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd4bf8e80  ! 3234: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0xd89c0400  ! 3235: LDDA_R	ldda	[%r16, %r0] 0x20, %r12
	.word 0xda9f0e80  ! 3236: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	mov	0x40, %r25
	.word 0xd2a70e60  ! 3238: STWA_R	stwa	%r9, [%r28 + %r0] 0x73
	.word 0xd2f609e0  ! 3239: STXA_R	stxa	%r9, [%r24 + %r0] 0x4f
	.word 0xdccf0e80  ! 3240: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	.word 0xd687e000  ! 3241: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	mov	0x7c8, %r20
	.word 0x87802072  ! 3243: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3244: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3245: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0x8780204f  ! 3247: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49c0400  ! 3248: LDDA_R	ldda	[%r16, %r0] 0x20, %r10
	.word 0xdebe6000  ! 3249: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0xd6bfce40  ! 3250: STDA_R	stda	%r11, [%r31 + %r0] 0x72
	.word 0xd0ae6000  ! 3251: STBA_I	stba	%r8, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 3252: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bce000  ! 3253: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	.word 0xd084a000  ! 3254: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0b42000  ! 3255: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd0ace000  ! 3256: STBA_I	stba	%r8, [%r19 + 0x0000] %asi
	.word 0xd0b6c9e0  ! 3257: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	mov	0x30, %r24
	.word 0xdeb44400  ! 3259: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	mov	0x18, %r18
	mov	0x38, %r18
	mov	0x40, %r19
	.word 0x87802073  ! 3263: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3264: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r19
	mov	0x28, %r18
	.word 0xd8a609e0  ! 3267: STWA_R	stwa	%r12, [%r24 + %r0] 0x4f
	.word 0xd4a48400  ! 3268: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2cf0e80  ! 3270: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0x8780204f  ! 3271: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f544a0  ! 3272: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0xd6ac6000  ! 3273: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd6842000  ! 3274: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3275: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3276: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r25
	mov	0x18, %r25
	.word 0xd6af6000  ! 3279: STBA_I	stba	%r11, [%r29 + 0x0000] %asi
	.word 0xd4b74e40  ! 3280: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	.word 0xd6a40400  ! 3281: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xd88f0e80  ! 3282: LDUBA_R	lduba	[%r28, %r0] 0x74, %r12
	.word 0xd2d4c400  ! 3283: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r9
	mov	0x3f0, %r23
	.word 0xdea76000  ! 3285: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 3286: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebfe000  ! 3287: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0xdeafe000  ! 3288: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 3289: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c40400  ! 3290: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	mov	0x10, %r16
	.word 0x8780204f  ! 3292: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8c76000  ! 3293: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8bf6000  ! 3294: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xde8584a0  ! 3295: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	.word 0xdcc76000  ! 3296: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 3297: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c0, %r23
	.word 0xdca76000  ! 3299: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	mov	0x28, %r17
	.word 0xd4adc4a0  ! 3301: STBA_R	stba	%r10, [%r23 + %r0] 0x25
	.word 0xd297e000  ! 3302: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd29fe000  ! 3303: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2876000  ! 3304: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	mov	0x78, %r17
	.word 0xde8c8400  ! 3306: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	.word 0x87802020  ! 3307: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcac0400  ! 3308: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0x87802020  ! 3309: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f584a0  ! 3310: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3311: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaf0e60  ! 3312: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	.word 0xdccfce40  ! 3313: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0xd8a78e60  ! 3314: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	mov	0x0, %r26
	.word 0xda8f8e60  ! 3316: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0xdeacc400  ! 3317: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 3318: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa72000  ! 3319: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	mov	0x68, %r26
	.word 0xdaafa000  ! 3321: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xda8f6000  ! 3323: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xd08649e0  ! 3324: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r8
	.word 0xdc8fe000  ! 3325: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r14
	.word 0xd8ac4400  ! 3326: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xdab76000  ! 3327: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0xda9f6000  ! 3328: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdacf2000  ! 3329: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r13
	mov	0x40, %r16
	.word 0xda8fe000  ! 3331: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xd4d7ce60  ! 3332: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r10
	.word 0x87802072  ! 3333: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca6c9e0  ! 3334: STWA_R	stwa	%r14, [%r27 + %r0] 0x4f
	.word 0x87802074  ! 3335: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f0, %r21
	.word 0xd2afe000  ! 3337: STBA_I	stba	%r9, [%r31 + 0x0000] %asi
	.word 0xd4978e80  ! 3338: LDUHA_R	lduha	[%r30, %r0] 0x74, %r10
	mov	0x0, %r17
	.word 0xd8b649e0  ! 3340: STHA_R	stha	%r12, [%r25 + %r0] 0x4f
	mov	0x30, %r27
	.word 0xdcafce60  ! 3342: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0x87802020  ! 3343: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a78e40  ! 3344: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0x87802020  ! 3345: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r21
	.word 0xded72000  ! 3347: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	.word 0xd2af0e80  ! 3348: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0xd0976000  ! 3349: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r8
	.word 0xd0c72000  ! 3350: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	mov	0x3f8, %r22
	.word 0xd0cf6000  ! 3352: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r8
	.word 0xd0a7e000  ! 3353: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd0b76000  ! 3355: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 3356: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x30, %r18
	.word 0xd08da000  ! 3358: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r8
	.word 0xd4dc0400  ! 3359: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	mov	0x8, %r19
	.word 0xd0a544a0  ! 3361: STWA_R	stwa	%r8, [%r21 + %r0] 0x25
	.word 0xdeb70e60  ! 3362: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	mov	0x7f0, %r22
	mov	0x58, %r24
	.word 0xdea5a000  ! 3365: STWA_I	stwa	%r15, [%r22 + 0x0000] %asi
	.word 0xdecda000  ! 3366: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r15
	.word 0x87802072  ! 3367: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4f544a0  ! 3368: STXA_R	stxa	%r10, [%r21 + %r0] 0x25
	.word 0xd0b78e40  ! 3369: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0x87802074  ! 3370: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcc7ce60  ! 3371: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r14
	.word 0xdcb4c400  ! 3372: STHA_R	stha	%r14, [%r19 + %r0] 0x20
	mov	0x3f0, %r22
	.word 0xdac46000  ! 3374: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0xd2c609e0  ! 3375: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r9
	.word 0xd8ac2000  ! 3376: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0x87802072  ! 3377: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x58, %r24
	mov	0x18, %r27
	.word 0xd8d7a000  ! 3380: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd4a78e60  ! 3381: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0xdabfa000  ! 3382: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0xdac7e000  ! 3383: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdadfa000  ! 3384: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x58, %r26
	.word 0xd084c400  ! 3386: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r8
	.word 0xdeafe000  ! 3387: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xd4b70e40  ! 3388: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3f0, %r20
	.word 0xdabf2000  ! 3391: STDA_I	stda	%r13, [%r28 + 0x0000] %asi
	mov	0x38, %r17
	.word 0xda9fa000  ! 3393: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r13
	mov	0x3e0, %r20
	.word 0x87802072  ! 3395: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0dd84a0  ! 3396: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	.word 0xd0f48400  ! 3397: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xd4cc2000  ! 3398: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r10
	.word 0xd4a584a0  ! 3399: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	.word 0xd0f46000  ! 3400: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd4b5c4a0  ! 3401: STHA_R	stha	%r10, [%r23 + %r0] 0x25
	.word 0xdc8ec9e0  ! 3402: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r14
	.word 0x87802072  ! 3403: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r26
	.word 0x87802025  ! 3405: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda97ce40  ! 3406: LDUHA_R	lduha	[%r31, %r0] 0x72, %r13
	.word 0xd88609e0  ! 3407: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	.word 0x87802073  ! 3408: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d78e60  ! 3409: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r10
	.word 0xde95c4a0  ! 3410: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xd0a62000  ! 3411: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	mov	0x0, %r16
	.word 0xd0aee000  ! 3413: STBA_I	stba	%r8, [%r27 + 0x0000] %asi
	.word 0xd6a48400  ! 3414: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	mov	0x7c0, %r23
	.word 0xdc948400  ! 3416: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcc44400  ! 3418: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r14
	.word 0xdcce6000  ! 3419: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3420: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x8, %r26
	.word 0xdcaea000  ! 3422: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3423: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r24
	.word 0xdcdc2000  ! 3425: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3426: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9f0e80  ! 3427: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	.word 0x87802073  ! 3428: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x7e8, %r21
	mov	0x3f0, %r23
	.word 0xd88c6000  ! 3431: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r12
	mov	0x38, %r27
	.word 0x87802072  ! 3433: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bc0400  ! 3434: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xd6a7a000  ! 3435: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bfe000  ! 3436: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 3437: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 3438: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r18
	mov	0x40, %r17
	mov	0x7d0, %r20
	.word 0xdebcc400  ! 3442: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xdef74e60  ! 3443: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0xd2c7ce80  ! 3444: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	.word 0xd4c7e000  ! 3445: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd48fa000  ! 3446: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r10
	.word 0xd2ac0400  ! 3447: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xd0b7a000  ! 3448: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 3449: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0f7e000  ! 3450: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	mov	0x28, %r16
	mov	0x30, %r27
	.word 0xd0cdc4a0  ! 3453: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r8
	.word 0x8780204f  ! 3454: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bca000  ! 3455: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdaa48400  ! 3457: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	mov	0x7f0, %r22
	.word 0x87802073  ! 3459: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a7a000  ! 3460: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4af6000  ! 3461: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3462: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4dca000  ! 3463: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	.word 0xd48c6000  ! 3464: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r10
	.word 0xd49ce000  ! 3465: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xd88c4400  ! 3466: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd89c2000  ! 3467: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd8ace000  ! 3468: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd8942000  ! 3469: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3470: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3471: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d4e000  ! 3472: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	.word 0xd4a544a0  ! 3473: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	.word 0xd4f70e60  ! 3474: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	.word 0x8780204f  ! 3475: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca70e40  ! 3476: STWA_R	stwa	%r14, [%r28 + %r0] 0x72
	mov	0x3d0, %r23
	.word 0xd68c4400  ! 3478: LDUBA_R	lduba	[%r17, %r0] 0x20, %r11
	.word 0xde8e09e0  ! 3479: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0xd0bea000  ! 3480: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xd096a000  ! 3481: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r8
	.word 0xdc8fce40  ! 3482: LDUBA_R	lduba	[%r31, %r0] 0x72, %r14
	mov	0x30, %r16
	.word 0xd2ad44a0  ! 3484: STBA_R	stba	%r9, [%r21 + %r0] 0x25
	.word 0xd68c8400  ! 3485: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	mov	0x3d0, %r23
	mov	0x10, %r27
	mov	0x20, %r19
	.word 0xd89ee000  ! 3489: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802073  ! 3491: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8946000  ! 3492: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0xd8a46000  ! 3493: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xdab40400  ! 3494: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	.word 0xdeb74e40  ! 3495: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xdeaca000  ! 3496: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdef4a000  ! 3497: STXA_I	stxa	%r15, [%r18 + 0x0000] %asi
	.word 0xded40400  ! 3498: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r15
	.word 0x87802020  ! 3499: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b7ce80  ! 3500: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd0f584a0  ! 3501: STXA_R	stxa	%r8, [%r22 + %r0] 0x25
	.word 0xdeaf0e80  ! 3502: STBA_R	stba	%r15, [%r28 + %r0] 0x74
	mov	0x7d0, %r23
	.word 0xd2d76000  ! 3504: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0x87802073  ! 3505: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdecf8e60  ! 3506: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r15
	.word 0xdef72000  ! 3507: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd49f4e60  ! 3509: LDDA_R	ldda	[%r29, %r0] 0x73, %r10
	mov	0x58, %r19
	.word 0xd2b7a000  ! 3511: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xda9f8e60  ! 3512: LDDA_R	ldda	[%r30, %r0] 0x73, %r13
	mov	0x38, %r18
	.word 0xdedf8e40  ! 3514: LDXA_R	ldxa	[%r30, %r0] 0x72, %r15
	.word 0xd4872000  ! 3515: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4a7e000  ! 3516: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4cf2000  ! 3517: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4f76000  ! 3518: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3519: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r19
	.word 0xd4c6e000  ! 3521: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r10
	mov	0x70, %r18
	.word 0xd2b44400  ! 3523: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0x87802020  ! 3524: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3525: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdebee000  ! 3526: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 3527: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x28, %r27
	.word 0xdec78e40  ! 3529: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r15
	.word 0xd49c8400  ! 3530: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0x87802073  ! 3531: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x68, %r16
	.word 0xdeb42000  ! 3533: STHA_I	stha	%r15, [%r16 + 0x0000] %asi
	mov	0x7c0, %r20
	.word 0xdcde89e0  ! 3535: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r14
	.word 0xd2acc400  ! 3536: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	mov	0x3f8, %r20
	.word 0xd6bce000  ! 3538: STDA_I	stda	%r11, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 3539: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 3540: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f8, %r22
	.word 0x87802025  ! 3542: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebec9e0  ! 3543: STDA_R	stda	%r15, [%r27 + %r0] 0x4f
	.word 0xd4bfce80  ! 3544: STDA_R	stda	%r10, [%r31 + %r0] 0x74
	mov	0x0, %r16
	.word 0xd8f40400  ! 3546: STXA_R	stxa	%r12, [%r16 + %r0] 0x20
	.word 0xd4a42000  ! 3547: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd4bc2000  ! 3549: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	mov	0x3e8, %r22
	.word 0xd4d4e000  ! 3551: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xdc8689e0  ! 3552: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r14
	mov	0x8, %r24
	.word 0xd294e000  ! 3554: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2cce000  ! 3555: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd2b42000  ! 3556: STHA_I	stha	%r9, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 3557: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bf0e40  ! 3558: STDA_R	stda	%r11, [%r28 + %r0] 0x72
	.word 0xdadde000  ! 3559: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3560: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad74e80  ! 3561: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r13
	.word 0x87802020  ! 3562: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0b62000  ! 3563: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0x87802025  ! 3564: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0af6000  ! 3565: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd6a7ce60  ! 3567: STWA_R	stwa	%r11, [%r31 + %r0] 0x73
	.word 0xdeae89e0  ! 3568: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802073  ! 3570: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3571: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcdf2000  ! 3572: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r14
	.word 0xdcd76000  ! 3573: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0xdec40400  ! 3574: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0x87802073  ! 3575: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69d2000  ! 3576: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r11
	.word 0xd6a544a0  ! 3577: STWA_R	stwa	%r11, [%r21 + %r0] 0x25
	.word 0xd6bd2000  ! 3578: STDA_I	stda	%r11, [%r20 + 0x0000] %asi
	.word 0xd685a000  ! 3579: LDUWA_I	lduwa	[%r22, + 0x0000] %asi, %r11
	.word 0x87802073  ! 3580: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd68ea000  ! 3581: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r11
	.word 0xd6ae2000  ! 3582: STBA_I	stba	%r11, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 3583: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r19
	.word 0x87802020  ! 3585: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6872000  ! 3586: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r11
	.word 0xd6a7e000  ! 3587: STWA_I	stwa	%r11, [%r31 + 0x0000] %asi
	.word 0xdad70e80  ! 3588: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r13
	.word 0xd8af8e40  ! 3589: STBA_R	stba	%r12, [%r30 + %r0] 0x72
	.word 0xd4df6000  ! 3590: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3591: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b7e000  ! 3592: STHA_I	stha	%r10, [%r31 + 0x0000] %asi
	.word 0xd4a7e000  ! 3593: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xdef74e60  ! 3594: STXA_R	stxa	%r15, [%r29 + %r0] 0x73
	.word 0x87802020  ! 3595: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2bc8400  ! 3596: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xdad78e80  ! 3597: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r13
	.word 0xd4ac8400  ! 3598: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	mov	0x8, %r27
	mov	0x50, %r27
	.word 0xda97e000  ! 3601: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xda972000  ! 3602: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	mov	0x7c0, %r21
	.word 0xd68f4e80  ! 3604: LDUBA_R	lduba	[%r29, %r0] 0x74, %r11
	.word 0xd4df6000  ! 3605: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4b7a000  ! 3606: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd48f6000  ! 3607: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	mov	0x8, %r17
	.word 0xd4c7e000  ! 3609: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4972000  ! 3610: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3611: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4aca000  ! 3612: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd6bcc400  ! 3613: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	mov	0x0, %r17
	.word 0x87802074  ! 3615: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7f0, %r23
	mov	0x8, %r19
	.word 0x87802025  ! 3619: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48cc400  ! 3620: LDUBA_R	lduba	[%r19, %r0] 0x20, %r10
	.word 0xd6d7ce60  ! 3621: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r11
	.word 0xdcaf4e40  ! 3622: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	mov	0x3d0, %r22
	.word 0xdadc6000  ! 3624: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	mov	0x48, %r24
	mov	0x7e8, %r22
	.word 0xda8ce000  ! 3627: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r13
	.word 0x87802073  ! 3628: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda8d84a0  ! 3629: LDUBA_R	lduba	[%r22, %r0] 0x25, %r13
	.word 0xd4b5a000  ! 3630: STHA_I	stha	%r10, [%r22 + 0x0000] %asi
	.word 0xd4ad6000  ! 3631: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0x8780204f  ! 3632: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r27
	.word 0xd487a000  ! 3634: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd8be09e0  ! 3635: STDA_R	stda	%r12, [%r24 + %r0] 0x4f
	.word 0xd2b7e000  ! 3636: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2dfa000  ! 3637: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xde9f0e60  ! 3638: LDDA_R	ldda	[%r28, %r0] 0x73, %r15
	.word 0xd69e09e0  ! 3639: LDDA_R	ldda	[%r24, %r0] 0x4f, %r11
	.word 0xded72000  ! 3640: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x7c0, %r23
	ta	T_CHANGE_PRIV	! macro
	.word 0xded7e000  ! 3643: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	.word 0xdecfa000  ! 3644: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r15
	.word 0xdeadc4a0  ! 3645: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xd8af2000  ! 3646: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 3647: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 3648: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8de2000  ! 3649: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xd8a66000  ! 3650: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd886e000  ! 3651: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd89e6000  ! 3652: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r12
	.word 0xd2acc400  ! 3653: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	mov	0x48, %r27
	mov	0x3d0, %r23
	.word 0xdedc8400  ! 3656: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	mov	0x7e8, %r21
	.word 0xdef609e0  ! 3658: STXA_R	stxa	%r15, [%r24 + %r0] 0x4f
	.word 0xdaf609e0  ! 3659: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xd0b4c400  ! 3660: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd8a6e000  ! 3661: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	.word 0xdef7ce40  ! 3662: STXA_R	stxa	%r15, [%r31 + %r0] 0x72
	mov	0x3d8, %r20
	.word 0xd6b78e40  ! 3664: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xd6c6e000  ! 3665: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6a66000  ! 3666: STWA_I	stwa	%r11, [%r25 + 0x0000] %asi
	.word 0xdca70e60  ! 3667: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0x87802072  ! 3668: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0f4c400  ! 3669: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd0dfa000  ! 3670: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0d544a0  ! 3671: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r8
	.word 0xd8d72000  ! 3672: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 3674: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88fa000  ! 3675: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd2de89e0  ! 3676: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	.word 0xd8ccc400  ! 3677: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r12
	mov	0x20, %r24
	.word 0xd4b70e60  ! 3679: STHA_R	stha	%r10, [%r28 + %r0] 0x73
	mov	0x30, %r17
	.word 0xdcf76000  ! 3681: STXA_I	stxa	%r14, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3682: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcb7e000  ! 3683: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdcaf2000  ! 3684: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdcb7e000  ! 3685: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xd4c649e0  ! 3687: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r10
	.word 0xd487a000  ! 3688: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4cfa000  ! 3689: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r10
	.word 0x87802073  ! 3690: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r16
	.word 0xd2b6c9e0  ! 3692: STHA_R	stha	%r9, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 3693: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8df4e40  ! 3694: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	mov	0x40, %r25
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 3697: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r24
	mov	0x8, %r18
	.word 0xdcad84a0  ! 3700: STBA_R	stba	%r14, [%r22 + %r0] 0x25
	.word 0xdad7a000  ! 3701: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xdcac0400  ! 3702: STBA_R	stba	%r14, [%r16 + %r0] 0x20
	.word 0xdedf8e60  ! 3703: LDXA_R	ldxa	[%r30, %r0] 0x73, %r15
	mov	0x0, %r26
	.word 0xd4872000  ! 3705: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 3706: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 3707: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	mov	0x7d0, %r23
	.word 0xd4f72000  ! 3709: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0x87802074  ! 3710: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 3711: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0dc8400  ! 3712: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xdeafce60  ! 3713: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0x8780204f  ! 3714: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbcc400  ! 3715: STDA_R	stda	%r14, [%r19 + %r0] 0x20
	.word 0xd687e000  ! 3716: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xdedc8400  ! 3717: LDXA_R	ldxa	[%r18, %r0] 0x20, %r15
	mov	0x7e8, %r20
	mov	0x7f0, %r20
	mov	0x50, %r18
	.word 0xd2c70e80  ! 3721: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r9
	mov	0x18, %r18
	.word 0xd88fce60  ! 3723: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	.word 0x87802020  ! 3724: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bf8e80  ! 3725: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd484e000  ! 3726: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r10
	.word 0xd4a46000  ! 3727: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd2f7ce80  ! 3728: STXA_R	stxa	%r9, [%r31 + %r0] 0x74
	mov	0x50, %r19
	.word 0xda9f0e60  ! 3730: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	mov	0x3c0, %r21
	.word 0xd8a46000  ! 3732: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3733: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b76000  ! 3734: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	mov	0x40, %r26
	.word 0x87802020  ! 3736: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3737: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0afce60  ! 3738: STBA_R	stba	%r8, [%r31 + %r0] 0x73
	mov	0x58, %r24
	mov	0x20, %r16
	.word 0x87802020  ! 3741: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa78e40  ! 3742: STWA_R	stwa	%r13, [%r30 + %r0] 0x72
	.word 0xdcf649e0  ! 3743: STXA_R	stxa	%r14, [%r25 + %r0] 0x4f
	.word 0xd4cc6000  ! 3744: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r10
	mov	0x0, %r25
	.word 0xd4d42000  ! 3746: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0xd0ac4400  ! 3747: STBA_R	stba	%r8, [%r17 + %r0] 0x20
	mov	0x7d8, %r20
	.word 0xd8dc6000  ! 3749: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r12
	.word 0x87802072  ! 3750: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb4c400  ! 3751: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd8a76000  ! 3752: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 3753: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd687ce80  ! 3754: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r11
	.word 0xdac6c9e0  ! 3755: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r13
	.word 0xd4b76000  ! 3756: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4a76000  ! 3757: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4876000  ! 3758: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd4d72000  ! 3759: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xd4b72000  ! 3760: STHA_I	stha	%r10, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 3761: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3762: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 3763: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x18, %r19
	mov	0x7d0, %r21
	.word 0xd4862000  ! 3766: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r10
	mov	0x3c0, %r21
	.word 0xd4966000  ! 3768: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	.word 0xd8d40400  ! 3769: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r12
	.word 0xd4966000  ! 3770: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	mov	0x70, %r19
	.word 0xd4b66000  ! 3772: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	.word 0xd4c6e000  ! 3773: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r10
	.word 0xda8d04a0  ! 3774: LDUBA_R	lduba	[%r20, %r0] 0x25, %r13
	.word 0xd6c62000  ! 3775: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6de6000  ! 3776: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r11
	.word 0xd6ae2000  ! 3777: STBA_I	stba	%r11, [%r24 + 0x0000] %asi
	.word 0xd0b44400  ! 3778: STHA_R	stha	%r8, [%r17 + %r0] 0x20
	.word 0xd6b40400  ! 3779: STHA_R	stha	%r11, [%r16 + %r0] 0x20
	.word 0xdebc8400  ! 3780: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0xdaf44400  ! 3781: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	mov	0x50, %r24
	mov	0x58, %r24
	.word 0xd0c4c400  ! 3784: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xd29f4e40  ! 3785: LDDA_R	ldda	[%r29, %r0] 0x72, %r9
	mov	0x18, %r27
	.word 0xdaae2000  ! 3787: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0xdac6a000  ! 3788: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xdaf66000  ! 3789: STXA_I	stxa	%r13, [%r25 + 0x0000] %asi
	.word 0xd0af8e80  ! 3790: STBA_R	stba	%r8, [%r30 + %r0] 0x74
	mov	0x20, %r17
	mov	0x30, %r18
	mov	0x38, %r27
	.word 0xdcb6a000  ! 3794: STHA_I	stha	%r14, [%r26 + 0x0000] %asi
	.word 0xdcbea000  ! 3795: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xd8a4c400  ! 3797: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x7f0, %r21
	.word 0xdcc6e000  ! 3799: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	mov	0x38, %r27
	mov	0x18, %r25
	.word 0xdc8ea000  ! 3802: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	mov	0x28, %r27
	.word 0x87802020  ! 3804: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r26
	.word 0x8780204f  ! 3806: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3807: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7d0, %r20
	.word 0xdcdfa000  ! 3809: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3810: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r18
	.word 0xdea70e80  ! 3812: STWA_R	stwa	%r15, [%r28 + %r0] 0x74
	.word 0xd2b70e60  ! 3813: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xdec504a0  ! 3814: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r15
	.word 0x87802073  ! 3815: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdeadc4a0  ! 3816: STBA_R	stba	%r15, [%r23 + %r0] 0x25
	.word 0xd0be89e0  ! 3817: STDA_R	stda	%r8, [%r26 + %r0] 0x4f
	.word 0xd8a40400  ! 3818: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0xdef78e60  ! 3819: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	.word 0xd4a48400  ! 3820: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xded4e000  ! 3821: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	mov	0x0, %r26
	.word 0xdebca000  ! 3823: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdeb46000  ! 3824: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0xdeac2000  ! 3825: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 3826: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3827: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7e0, %r23
	mov	0x10, %r26
	.word 0xd8b4c400  ! 3830: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	.word 0xd6dfa000  ! 3831: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r11
	.word 0xd2d78e40  ! 3832: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	mov	0x58, %r16
	.word 0xd4978e60  ! 3834: LDUHA_R	lduha	[%r30, %r0] 0x73, %r10
	.word 0xdaf72000  ! 3835: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	mov	0x7f8, %r21
	.word 0xdcdc8400  ! 3837: LDXA_R	ldxa	[%r18, %r0] 0x20, %r14
	.word 0xd0b72000  ! 3838: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0a76000  ! 3839: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xdcdf4e60  ! 3840: LDXA_R	ldxa	[%r29, %r0] 0x73, %r14
	ta	T_CHANGE_HPRIV	! macro
	mov	0x8, %r27
	.word 0xdabc4400  ! 3843: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0x87802025  ! 3844: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r27
	.word 0x8780204f  ! 3846: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3c8, %r20
	mov	0x20, %r24
	.word 0xd6976000  ! 3849: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0x87802073  ! 3850: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69f2000  ! 3851: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xd48584a0  ! 3852: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r10
	mov	0x68, %r24
	.word 0x87802020  ! 3854: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac46000  ! 3855: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0x87802025  ! 3856: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 3857: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	.word 0xda8f2000  ! 3859: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xd0a584a0  ! 3860: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xdc86c9e0  ! 3861: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	.word 0x87802074  ! 3862: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r26
	mov	0x28, %r27
	mov	0x3f8, %r21
	.word 0xdab4e000  ! 3866: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	mov	0x60, %r16
	.word 0xd4af0e40  ! 3868: STBA_R	stba	%r10, [%r28 + %r0] 0x72
	mov	0x20, %r26
	mov	0x28, %r16
	.word 0xdadca000  ! 3871: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3872: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0874e80  ! 3873: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	.word 0xd4b46000  ! 3874: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd6dd04a0  ! 3875: LDXA_R	ldxa	[%r20, %r0] 0x25, %r11
	mov	0x7d0, %r21
	.word 0xd89e49e0  ! 3877: LDDA_R	ldda	[%r25, %r0] 0x4f, %r12
	.word 0xdacc2000  ! 3878: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r13
	.word 0xdacfce40  ! 3879: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r13
	mov	0x7d0, %r21
	.word 0xd4d42000  ! 3881: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3882: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d40400  ! 3883: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0x87802072  ! 3884: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3885: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r17
	.word 0xd6f6a000  ! 3887: STXA_I	stxa	%r11, [%r26 + 0x0000] %asi
	.word 0x87802072  ! 3888: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x20, %r17
	.word 0xd6ae2000  ! 3890: STBA_I	stba	%r11, [%r24 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xd6c6a000  ! 3892: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r11
	.word 0xdad70e60  ! 3893: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r13
	.word 0xd4b6a000  ! 3894: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3895: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r25
	.word 0xd4d6a000  ! 3897: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r10
	.word 0xd4c66000  ! 3898: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r10
	mov	0x48, %r17
	mov	0x70, %r27
	.word 0x87802074  ! 3901: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4d7e000  ! 3902: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd49fe000  ! 3903: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	mov	0x3c8, %r22
	.word 0x87802020  ! 3905: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r25
	.word 0xd2cfce40  ! 3907: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r9
	.word 0xd4a7a000  ! 3908: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xdc8649e0  ! 3909: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r14
	.word 0x87802072  ! 3910: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8ee000  ! 3911: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r13
	.word 0xdaa66000  ! 3912: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xd69c0400  ! 3913: LDDA_R	ldda	[%r16, %r0] 0x20, %r11
	.word 0x87802020  ! 3914: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea4e000  ! 3915: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdaaec9e0  ! 3916: STBA_R	stba	%r13, [%r27 + %r0] 0x4f
	mov	0x3c0, %r20
	.word 0xdadd04a0  ! 3918: LDXA_R	ldxa	[%r20, %r0] 0x25, %r13
	.word 0xd2a4e000  ! 3919: STWA_I	stwa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2b7ce40  ! 3920: STHA_R	stha	%r9, [%r31 + %r0] 0x72
	.word 0xde95c4a0  ! 3921: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	mov	0x58, %r26
	.word 0xdecd84a0  ! 3923: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r15
	.word 0xd6ace000  ! 3924: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd6a46000  ! 3925: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xde8584a0  ! 3926: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r15
	.word 0xd6f42000  ! 3927: STXA_I	stxa	%r11, [%r16 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xda974e40  ! 3929: LDUHA_R	lduha	[%r29, %r0] 0x72, %r13
	.word 0xd2b609e0  ! 3930: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0xd2afce60  ! 3931: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xde8c2000  ! 3932: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r15
	.word 0xdcbd04a0  ! 3933: STDA_R	stda	%r14, [%r20 + %r0] 0x25
	.word 0xdabfce40  ! 3934: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xdeb74e40  ! 3935: STHA_R	stha	%r15, [%r29 + %r0] 0x72
	.word 0xd4c42000  ! 3936: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	mov	0x18, %r16
	mov	0x3d0, %r20
	.word 0x87802020  ! 3939: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r22
	.word 0xd48ca000  ! 3941: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3942: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a56000  ! 3943: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 3944: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49ce000  ! 3945: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	mov	0x10, %r19
	.word 0xd4a70e80  ! 3947: STWA_R	stwa	%r10, [%r28 + %r0] 0x74
	.word 0xdcdca000  ! 3948: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r14
	.word 0xdca4e000  ! 3949: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	mov	0x18, %r25
	.word 0xdaa7ce60  ! 3951: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	.word 0xd8ad04a0  ! 3952: STBA_R	stba	%r12, [%r20 + %r0] 0x25
	mov	0x48, %r16
	.word 0xd8ace000  ! 3954: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 3955: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r25
	.word 0xd2b7ce80  ! 3957: STHA_R	stha	%r9, [%r31 + %r0] 0x74
	.word 0xd0cf0e40  ! 3958: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0xd8f62000  ! 3959: STXA_I	stxa	%r12, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 3960: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r24
	.word 0x87802073  ! 3962: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6ac4400  ! 3963: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd88d44a0  ! 3964: LDUBA_R	lduba	[%r21, %r0] 0x25, %r12
	.word 0xd6bdc4a0  ! 3965: STDA_R	stda	%r11, [%r23 + %r0] 0x25
	.word 0xd6a40400  ! 3966: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x0, %r17
	.word 0xdaa7ce60  ! 3968: STWA_R	stwa	%r13, [%r31 + %r0] 0x73
	.word 0xdca76000  ! 3969: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdabe89e0  ! 3970: STDA_R	stda	%r13, [%r26 + %r0] 0x4f
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802025  ! 3972: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcc74e80  ! 3973: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r14
	.word 0x87802020  ! 3974: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r17
	.word 0xd2af6000  ! 3976: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd4a48400  ! 3977: STWA_R	stwa	%r10, [%r18 + %r0] 0x20
	.word 0xd0dcc400  ! 3978: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0x87802020  ! 3979: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 3980: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef42000  ! 3981: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xd294c400  ! 3982: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0xdea46000  ! 3983: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 3984: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde87e000  ! 3985: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd6afce80  ! 3986: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	.word 0x87802020  ! 3987: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c78e60  ! 3988: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r11
	.word 0xd096c9e0  ! 3989: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r8
	mov	0x40, %r26
	mov	0x70, %r18
	.word 0xdca70e60  ! 3992: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	mov	0x20, %r25
	.word 0xd0b40400  ! 3994: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xdca7e000  ! 3995: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd28f0e60  ! 3996: LDUBA_R	lduba	[%r28, %r0] 0x73, %r9
	.word 0xdcbfe000  ! 3997: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	.word 0xd0c70e60  ! 3998: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r8
	.word 0xd2840400  ! 3999: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r9
	.word 0xd4ad84a0  ! 4000: STBA_R	stba	%r10, [%r22 + %r0] 0x25
	mov	0x7d8, %r21
	.word 0xd88fa000  ! 4002: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	.word 0xd0c74e80  ! 4003: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	mov	0x58, %r19
	mov	0x8, %r16
	mov	0x7c8, %r23
	.word 0x87802073  ! 4007: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedfe000  ! 4008: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xde97e000  ! 4009: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r15
	.word 0xdeaf4e80  ! 4010: STBA_R	stba	%r15, [%r29 + %r0] 0x74
	.word 0xd8dc0400  ! 4011: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd8f7e000  ! 4012: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8b7e000  ! 4013: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0xd8afe000  ! 4014: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xded44400  ! 4015: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r15
	.word 0xd0d74e40  ! 4016: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r8
	mov	0x8, %r25
	.word 0xd8a76000  ! 4018: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8af2000  ! 4019: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x7e0, %r22
	.word 0xd8f72000  ! 4021: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bf6000  ! 4022: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xd4f70e60  ! 4023: STXA_R	stxa	%r10, [%r28 + %r0] 0x73
	mov	0x58, %r25
	.word 0x87802020  ! 4025: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r21
	.word 0x87802074  ! 4027: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r24
	.word 0xd4d609e0  ! 4029: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r10
	.word 0xd8c72000  ! 4030: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd2ac0400  ! 4031: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0xda972000  ! 4032: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r13
	.word 0xdaafe000  ! 4033: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0xd29f0e60  ! 4034: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0xd2d78e40  ! 4035: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r9
	.word 0xde978e60  ! 4036: LDUHA_R	lduha	[%r30, %r0] 0x73, %r15
	.word 0xd6bd04a0  ! 4037: STDA_R	stda	%r11, [%r20 + %r0] 0x25
	mov	0x28, %r19
	mov	0x28, %r18
	.word 0xdaafa000  ! 4040: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdcdf0e60  ! 4041: LDXA_R	ldxa	[%r28, %r0] 0x73, %r14
	.word 0x87802073  ! 4042: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4ac6000  ! 4043: STBA_I	stba	%r10, [%r17 + 0x0000] %asi
	mov	0x7c8, %r23
	.word 0x87802020  ! 4045: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8afce80  ! 4046: STBA_R	stba	%r12, [%r31 + %r0] 0x74
	.word 0x8780204f  ! 4047: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bec9e0  ! 4048: STDA_R	stda	%r10, [%r27 + %r0] 0x4f
	.word 0xd88e49e0  ! 4049: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r12
	.word 0xdabc0400  ! 4050: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd0dc6000  ! 4051: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xd28f8e60  ! 4052: LDUBA_R	lduba	[%r30, %r0] 0x73, %r9
	mov	0x0, %r18
	.word 0x87802073  ! 4054: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8840400  ! 4055: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r12
	mov	0x8, %r17
	.word 0xd2cc4400  ! 4057: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0xdcdfce80  ! 4058: LDXA_R	ldxa	[%r31, %r0] 0x74, %r14
	mov	0x50, %r19
	.word 0xdcaf2000  ! 4060: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdca7e000  ! 4061: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdccf2000  ! 4062: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r14
	mov	0x8, %r24
	.word 0xdcd7a000  ! 4064: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r14
	.word 0x87802025  ! 4065: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4066: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca72000  ! 4067: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd0ac8400  ! 4068: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	mov	0x78, %r27
	.word 0xdc8f8e60  ! 4070: LDUBA_R	lduba	[%r30, %r0] 0x73, %r14
	.word 0xd68649e0  ! 4071: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r11
	.word 0xdac5c4a0  ! 4072: LDSWA_R	ldswa	[%r23, %r0] 0x25, %r13
	mov	0x10, %r24
	.word 0x87802025  ! 4074: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 4075: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaad04a0  ! 4076: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0xd4dec9e0  ! 4077: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r10
	.word 0xd29fa000  ! 4078: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4079: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdad4c400  ! 4080: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	mov	0x3f8, %r20
	.word 0xdef76000  ! 4082: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xdcbf8e80  ! 4084: STDA_R	stda	%r14, [%r30 + %r0] 0x74
	mov	0x28, %r16
	.word 0xd48d84a0  ! 4086: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0xd0bc8400  ! 4087: STDA_R	stda	%r8, [%r18 + %r0] 0x20
	.word 0xd0df0e60  ! 4088: LDXA_R	ldxa	[%r28, %r0] 0x73, %r8
	mov	0x20, %r27
	mov	0x3d8, %r23
	.word 0x87802020  ! 4091: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a4e000  ! 4092: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd6f48400  ! 4093: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	mov	0x10, %r26
	.word 0xd0942000  ! 4095: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r8
	.word 0xd8b609e0  ! 4096: STHA_R	stha	%r12, [%r24 + %r0] 0x4f
	.word 0x87802073  ! 4097: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8846000  ! 4098: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd0dc4400  ! 4099: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0x87802020  ! 4100: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8cde000  ! 4101: LDSBA_I	ldsba	[%r23, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4102: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4103: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bd84a0  ! 4104: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdabc4400  ! 4106: STDA_R	stda	%r13, [%r17 + %r0] 0x20
	.word 0xd08f8e40  ! 4107: LDUBA_R	lduba	[%r30, %r0] 0x72, %r8
	.word 0xd8f7ce60  ! 4108: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0xdca4a000  ! 4109: STWA_I	stwa	%r14, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 4110: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc8da000  ! 4111: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4112: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbce000  ! 4113: STDA_I	stda	%r14, [%r19 + 0x0000] %asi
	.word 0xdc94e000  ! 4114: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r14
	.word 0xd4ae49e0  ! 4115: STBA_R	stba	%r10, [%r25 + %r0] 0x4f
	.word 0xdeace000  ! 4116: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xded7ce40  ! 4117: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0x87802020  ! 4118: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c6000  ! 4119: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd2d42000  ! 4120: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2a42000  ! 4121: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 4122: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8a7ce80  ! 4123: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0xde870e60  ! 4124: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	.word 0xd8c6a000  ! 4125: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xd68f4e40  ! 4126: LDUBA_R	lduba	[%r29, %r0] 0x72, %r11
	mov	0x28, %r19
	.word 0xdab6a000  ! 4128: STHA_I	stha	%r13, [%r26 + 0x0000] %asi
	.word 0xdc87ce40  ! 4129: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r14
	.word 0xd2c6e000  ! 4130: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r9
	.word 0xd296e000  ! 4131: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r9
	.word 0xdaf4c400  ! 4132: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xdaf6e000  ! 4133: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xda8ea000  ! 4134: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r13
	.word 0xdaae2000  ! 4135: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0x87802072  ! 4136: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdacfa000  ! 4137: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x38, %r16
	mov	0x60, %r26
	.word 0x87802072  ! 4140: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 4141: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8f6000  ! 4142: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0xdeaf8e60  ! 4143: STBA_R	stba	%r15, [%r30 + %r0] 0x73
	mov	0x18, %r18
	.word 0xdeb7ce40  ! 4145: STHA_R	stha	%r15, [%r31 + %r0] 0x72
	.word 0xd887a000  ! 4146: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xd8a74e60  ! 4147: STWA_R	stwa	%r12, [%r29 + %r0] 0x73
	mov	0x50, %r18
	.word 0xd4afe000  ! 4149: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd48fe000  ! 4150: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xdcde09e0  ! 4151: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r14
	mov	0x50, %r25
	mov	0x0, %r25
	.word 0xd4b70e80  ! 4154: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xd0cfa000  ! 4155: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r8
	mov	0x78, %r16
	.word 0xd0d72000  ! 4157: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	.word 0xdeaf0e60  ! 4158: STBA_R	stba	%r15, [%r28 + %r0] 0x73
	mov	0x58, %r16
	.word 0xdef7a000  ! 4160: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdebf6000  ! 4161: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xde976000  ! 4162: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xd0b78e60  ! 4163: STHA_R	stha	%r8, [%r30 + %r0] 0x73
	mov	0x48, %r18
	.word 0xdcaf0e40  ! 4165: STBA_R	stba	%r14, [%r28 + %r0] 0x72
	.word 0xd29f2000  ! 4166: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x3d8, %r20
	.word 0x87802073  ! 4168: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d72000  ! 4169: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r9
	.word 0xd2f78e80  ! 4170: STXA_R	stxa	%r9, [%r30 + %r0] 0x74
	mov	0x7c0, %r22
	mov	0x18, %r27
	mov	0x40, %r17
	mov	0x78, %r25
	.word 0xded78e40  ! 4175: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r15
	mov	0x28, %r16
	.word 0xd0c72000  ! 4177: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	.word 0xdaf48400  ! 4178: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd2dfa000  ! 4179: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2876000  ! 4180: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2c72000  ! 4181: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2b7e000  ! 4182: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	mov	0x60, %r26
	mov	0x28, %r25
	.word 0xd2afa000  ! 4185: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd29f6000  ! 4186: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	mov	0x3c8, %r22
	.word 0xdc97ce40  ! 4188: LDUHA_R	lduha	[%r31, %r0] 0x72, %r14
	.word 0xda8649e0  ! 4189: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r13
	mov	0x3c8, %r22
	.word 0xd6ac4400  ! 4191: STBA_R	stba	%r11, [%r17 + %r0] 0x20
	.word 0xd8c584a0  ! 4192: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	.word 0xdabf0e60  ! 4193: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	mov	0x60, %r24
	.word 0xd4afce40  ! 4195: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	mov	0x3f0, %r22
	.word 0xd4a7e000  ! 4197: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xdca78e40  ! 4198: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xd2bfa000  ! 4199: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2af6000  ! 4200: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd28fa000  ! 4201: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r9
	.word 0xd28f6000  ! 4202: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xd297a000  ! 4203: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	mov	0x70, %r25
	.word 0xd2af6000  ! 4205: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2f78e60  ! 4206: STXA_R	stxa	%r9, [%r30 + %r0] 0x73
	mov	0x7d0, %r23
	mov	0x10, %r25
	.word 0x87802074  ! 4209: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x68, %r27
	.word 0xdad7a000  ! 4211: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	mov	0x8, %r25
	.word 0x87802074  ! 4213: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0b584a0  ! 4214: STHA_R	stha	%r8, [%r22 + %r0] 0x25
	.word 0xd6b4a000  ! 4215: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 4216: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6f72000  ! 4217: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	mov	0x7f0, %r21
	.word 0xd6afa000  ! 4219: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xd6a72000  ! 4221: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd69f2000  ! 4222: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	mov	0x7c8, %r23
	.word 0xd2af0e60  ! 4224: STBA_R	stba	%r9, [%r28 + %r0] 0x73
	.word 0xd2c44400  ! 4225: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd886c9e0  ! 4226: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r12
	mov	0x78, %r25
	mov	0x8, %r27
	.word 0xd4ac8400  ! 4229: STBA_R	stba	%r10, [%r18 + %r0] 0x20
	.word 0x8780204f  ! 4230: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 4231: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcdf6000  ! 4232: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xd0b4c400  ! 4233: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 4234: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xda8f4e80  ! 4235: LDUBA_R	lduba	[%r29, %r0] 0x74, %r13
	.word 0x87802025  ! 4236: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdad7ce60  ! 4237: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r13
	.word 0xdcf56000  ! 4238: STXA_I	stxa	%r14, [%r21 + 0x0000] %asi
	.word 0xdca5a000  ! 4239: STWA_I	stwa	%r14, [%r22 + 0x0000] %asi
	mov	0x38, %r26
	.word 0xdcb52000  ! 4241: STHA_I	stha	%r14, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 4242: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb42000  ! 4243: STHA_I	stha	%r14, [%r16 + 0x0000] %asi
	mov	0x7e8, %r22
	mov	0x0, %r27
	.word 0xdcbc6000  ! 4246: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xde9e49e0  ! 4247: LDDA_R	ldda	[%r25, %r0] 0x4f, %r15
	.word 0xd2f44400  ! 4248: STXA_R	stxa	%r9, [%r17 + %r0] 0x20
	.word 0xd687ce80  ! 4249: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r11
	mov	0x7e8, %r23
	.word 0xd2be89e0  ! 4251: STDA_R	stda	%r9, [%r26 + %r0] 0x4f
	mov	0x3e8, %r22
	.word 0xd8a6c9e0  ! 4253: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0xd29e89e0  ! 4254: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd4870e60  ! 4256: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	.word 0xdcd4e000  ! 4257: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 4258: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r26
	.word 0xdcace000  ! 4260: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 4261: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8af8e40  ! 4262: STBA_R	stba	%r12, [%r30 + %r0] 0x72
	.word 0xdea689e0  ! 4263: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0xdcb48400  ! 4264: STHA_R	stha	%r14, [%r18 + %r0] 0x20
	.word 0x87802072  ! 4265: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d7a000  ! 4266: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	.word 0xdeb78e80  ! 4267: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	mov	0x58, %r24
	.word 0x87802020  ! 4269: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf7e000  ! 4270: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 4271: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d7ce40  ! 4272: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r12
	mov	0x50, %r25
	.word 0xd8bf0e60  ! 4274: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	.word 0x87802020  ! 4275: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cc6000  ! 4276: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	.word 0xd6a46000  ! 4277: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	mov	0x3c0, %r23
	.word 0xd0af4e80  ! 4279: STBA_R	stba	%r8, [%r29 + %r0] 0x74
	mov	0x58, %r17
	mov	0x8, %r19
	.word 0xded4a000  ! 4282: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r15
	.word 0xdef42000  ! 4283: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 4284: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 4285: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r19
	mov	0x20, %r16
	.word 0xd8f4c400  ! 4288: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0x87802020  ! 4289: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4afe000  ! 4290: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 4291: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda974e40  ! 4292: LDUHA_R	lduha	[%r29, %r0] 0x72, %r13
	.word 0xd4f7a000  ! 4293: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xd48f2000  ! 4295: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4296: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4852000  ! 4297: LDUWA_I	lduwa	[%r20, + 0x0000] %asi, %r10
	.word 0xd6a70e40  ! 4298: STWA_R	stwa	%r11, [%r28 + %r0] 0x72
	mov	0x50, %r19
	.word 0xd6b78e80  ! 4300: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	mov	0x30, %r19
	.word 0xdc8e09e0  ! 4302: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0x87802020  ! 4303: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8afe000  ! 4304: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8d76000  ! 4305: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd6f74e40  ! 4306: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xdcbf4e40  ! 4307: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xdebf6000  ! 4308: STDA_I	stda	%r15, [%r29 + 0x0000] %asi
	.word 0xd2a44400  ! 4309: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xded7a000  ! 4310: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xdecfe000  ! 4311: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xdebc0400  ! 4312: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xd49f8e40  ! 4313: LDDA_R	ldda	[%r30, %r0] 0x72, %r10
	.word 0xd8bf8e40  ! 4314: STDA_R	stda	%r12, [%r30 + %r0] 0x72
	.word 0x8780204f  ! 4315: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4af8e60  ! 4316: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0x87802020  ! 4317: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4318: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x0, %r24
	.word 0x87802072  ! 4320: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4df0e80  ! 4321: LDXA_R	ldxa	[%r28, %r0] 0x74, %r10
	.word 0xdeb544a0  ! 4322: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	mov	0x3d0, %r22
	.word 0xdcb4e000  ! 4324: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0xdcf4a000  ! 4325: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcb4e000  ! 4326: STHA_I	stha	%r14, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4327: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc84e000  ! 4328: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0x87802072  ! 4329: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca6e000  ! 4330: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	.word 0xd08689e0  ! 4331: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r8
	.word 0x87802020  ! 4332: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dfe000  ! 4333: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802072  ! 4334: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r18
	mov	0x3f0, %r21
	.word 0xd4d544a0  ! 4337: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r10
	.word 0xd29f2000  ! 4338: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x3f0, %r22
	.word 0xded7ce40  ! 4340: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r15
	.word 0xdcb7a000  ! 4341: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdcb76000  ! 4342: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	.word 0xdca72000  ! 4343: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdac584a0  ! 4344: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r13
	.word 0xd09f4e60  ! 4345: LDDA_R	ldda	[%r29, %r0] 0x73, %r8
	mov	0x68, %r16
	.word 0xd2f74e60  ! 4347: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	mov	0x58, %r19
	.word 0x8780204f  ! 4349: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 4350: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd697a000  ! 4351: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	mov	0x78, %r24
	.word 0xd6f7e000  ! 4353: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd6cfce40  ! 4354: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0x87802020  ! 4355: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49f2000  ! 4356: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd2c6c9e0  ! 4357: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r9
	mov	0x48, %r24
	mov	0x7c8, %r23
	.word 0xd0f72000  ! 4360: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xde9e09e0  ! 4361: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0xd0a4c400  ! 4362: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	mov	0x70, %r24
	.word 0x87802025  ! 4364: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 4365: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4bfce40  ! 4366: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xdadc2000  ! 4367: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xda94a000  ! 4368: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 4369: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x8780204f  ! 4370: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r25
	.word 0xdec48400  ! 4372: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	mov	0x40, %r17
	.word 0xde872000  ! 4374: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdec7e000  ! 4375: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r15
	.word 0xdea7a000  ! 4376: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 4377: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x58, %r19
	.word 0xd0a78e60  ! 4379: STWA_R	stwa	%r8, [%r30 + %r0] 0x73
	mov	0x8, %r16
	.word 0xd68f0e80  ! 4381: LDUBA_R	lduba	[%r28, %r0] 0x74, %r11
	.word 0xd487ce80  ! 4382: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r10
	.word 0xdcbfa000  ! 4383: STDA_I	stda	%r14, [%r30 + 0x0000] %asi
	.word 0xd8dc0400  ! 4384: LDXA_R	ldxa	[%r16, %r0] 0x20, %r12
	.word 0xd0b40400  ! 4385: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	mov	0x58, %r19
	.word 0xdca544a0  ! 4387: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	mov	0x48, %r19
	.word 0xd8c72000  ! 4389: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8af6000  ! 4390: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4391: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8d7a000  ! 4392: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x3d8, %r20
	.word 0xde97ce80  ! 4394: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0x87802020  ! 4395: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r17
	.word 0xdacda000  ! 4397: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r13
	.word 0xda956000  ! 4398: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r13
	.word 0xda95e000  ! 4399: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r13
	.word 0x87802074  ! 4400: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaaf4e40  ! 4401: STBA_R	stba	%r13, [%r29 + %r0] 0x72
	.word 0xd4c4a000  ! 4402: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r10
	mov	0x3c8, %r23
	mov	0x7f8, %r21
	mov	0x7f8, %r23
	.word 0xdca544a0  ! 4406: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd4b70e40  ! 4407: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xd0f40400  ! 4408: STXA_R	stxa	%r8, [%r16 + %r0] 0x20
	.word 0xd4bc4400  ! 4409: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd88fce60  ! 4410: LDUBA_R	lduba	[%r31, %r0] 0x73, %r12
	mov	0x28, %r16
	.word 0xd6942000  ! 4412: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	.word 0xd69c6000  ! 4413: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r11
	.word 0xd6cec9e0  ! 4414: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r11
	mov	0x70, %r25
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x8780204f  ! 4417: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4c4c400  ! 4418: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r10
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd4c7ce80  ! 4420: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r10
	.word 0xdcaf2000  ! 4421: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdc872000  ! 4422: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r14
	mov	0x58, %r27
	.word 0xdcb7a000  ! 4424: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdcaf2000  ! 4425: STBA_I	stba	%r14, [%r28 + 0x0000] %asi
	.word 0xdc8fa000  ! 4426: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r14
	.word 0xdca76000  ! 4427: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdaa70e60  ! 4428: STWA_R	stwa	%r13, [%r28 + %r0] 0x73
	.word 0xde870e60  ! 4429: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r15
	.word 0xdacc8400  ! 4430: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r13
	mov	0x7e8, %r23
	mov	0x20, %r27
	mov	0x50, %r19
	.word 0xd0876000  ! 4434: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd8a6c9e0  ! 4435: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	mov	0x58, %r24
	.word 0xd8f72000  ! 4437: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8f7a000  ! 4438: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xdcbd84a0  ! 4439: STDA_R	stda	%r14, [%r22 + %r0] 0x25
	.word 0xd8872000  ! 4440: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8876000  ! 4441: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	.word 0xd8b7a000  ! 4442: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 4443: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bca000  ! 4444: STDA_I	stda	%r12, [%r18 + 0x0000] %asi
	.word 0xd8b42000  ! 4445: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	mov	0x18, %r26
	.word 0xd89c6000  ! 4447: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	.word 0xda844400  ! 4448: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	.word 0xda942000  ! 4449: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdac4a000  ! 4450: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4451: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 4452: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r25
	.word 0xd2bc4400  ! 4454: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	mov	0x78, %r26
	.word 0xdcb70e60  ! 4456: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0xd0dfce60  ! 4457: LDXA_R	ldxa	[%r31, %r0] 0x73, %r8
	.word 0x87802020  ! 4458: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r25
	.word 0xd8afa000  ! 4460: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xdcf48400  ! 4461: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	mov	0x78, %r25
	.word 0xdac7e000  ! 4463: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r13
	.word 0xdab76000  ! 4464: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4465: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa7a000  ! 4466: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	.word 0xda87a000  ! 4467: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r13
	mov	0x3d0, %r21
	.word 0x8780204f  ! 4469: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b48400  ! 4470: STHA_R	stha	%r12, [%r18 + %r0] 0x20
	.word 0xd8962000  ! 4471: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	.word 0x87802020  ! 4472: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r17
	.word 0xd2de09e0  ! 4474: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r9
	.word 0xd08609e0  ! 4475: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r8
	.word 0xd6f74e80  ! 4476: STXA_R	stxa	%r11, [%r29 + %r0] 0x74
	.word 0x8780204f  ! 4477: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 4478: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88ec9e0  ! 4479: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0xdcb44400  ! 4480: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	.word 0xd2942000  ! 4481: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xdaac8400  ! 4482: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	.word 0xdcb70e40  ! 4483: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	.word 0xd4cf0e60  ! 4484: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r10
	mov	0x7c0, %r23
	.word 0xd0cf0e80  ! 4486: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r8
	mov	0x18, %r24
	.word 0x87802020  ! 4488: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaaf0e40  ! 4489: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	.word 0xd4afa000  ! 4490: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	.word 0xd4dfe000  ! 4491: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4df2000  ! 4492: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	mov	0x7d8, %r20
	.word 0xdcac4400  ! 4494: STBA_R	stba	%r14, [%r17 + %r0] 0x20
	mov	0x3e0, %r23
	.word 0x87802074  ! 4496: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde9fe000  ! 4497: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	mov	0x3e8, %r20
	.word 0xdeb7e000  ! 4499: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xd0cf0e60  ! 4500: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	.word 0xd6a74e80  ! 4501: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0xde9f4e40  ! 4502: LDDA_R	ldda	[%r29, %r0] 0x72, %r15
	mov	0x60, %r25
	mov	0x60, %r19
	.word 0xdaa7a000  ! 4505: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	mov	0x7f8, %r22
	mov	0x7d0, %r21
	.word 0xdea7ce60  ! 4508: STWA_R	stwa	%r15, [%r31 + %r0] 0x73
	mov	0x40, %r17
	mov	0x70, %r19
	.word 0xde97ce80  ! 4511: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0x8780204f  ! 4512: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8b76000  ! 4513: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4514: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4840400  ! 4515: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xdcf5a000  ! 4516: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	mov	0x18, %r16
	mov	0x40, %r25
	mov	0x18, %r16
	.word 0xdcb5a000  ! 4520: STHA_I	stha	%r14, [%r22 + 0x0000] %asi
	.word 0x87802074  ! 4521: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r23
	.word 0xdc9ce000  ! 4523: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r14
	.word 0xd8f78e60  ! 4524: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	mov	0x7f8, %r23
	mov	0x20, %r26
	.word 0xd4d78e60  ! 4527: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r10
	.word 0xdcdf4e80  ! 4528: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	.word 0xd4874e60  ! 4529: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r10
	mov	0x18, %r27
	.word 0xdcf78e40  ! 4531: STXA_R	stxa	%r14, [%r30 + %r0] 0x72
	mov	0x3f8, %r21
	.word 0xd8df8e80  ! 4533: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xd8a46000  ! 4534: STWA_I	stwa	%r12, [%r17 + 0x0000] %asi
	.word 0xd89cc400  ! 4535: LDDA_R	ldda	[%r19, %r0] 0x20, %r12
	mov	0x10, %r27
	.word 0xd2942000  ! 4537: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd2aca000  ! 4538: STBA_I	stba	%r9, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 4539: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29c6000  ! 4540: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r9
	.word 0xd2b4e000  ! 4541: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 4542: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r24
	.word 0xd4f74e40  ! 4544: STXA_R	stxa	%r10, [%r29 + %r0] 0x72
	.word 0x87802072  ! 4545: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2a46000  ! 4546: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bca000  ! 4547: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd08c8400  ! 4548: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0x8780204f  ! 4549: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x10, %r27
	.word 0xd2bf0e60  ! 4551: STDA_R	stda	%r9, [%r28 + %r0] 0x73
	.word 0x87802020  ! 4552: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cf8e80  ! 4553: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	mov	0x3f8, %r23
	.word 0xd087e000  ! 4555: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	mov	0x48, %r17
	.word 0x87802074  ! 4557: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r26
	.word 0xd08f6000  ! 4559: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r8
	.word 0xd097a000  ! 4560: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r8
	.word 0xd8a74e80  ! 4561: STWA_R	stwa	%r12, [%r29 + %r0] 0x74
	.word 0x87802020  ! 4562: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29c2000  ! 4563: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd6a609e0  ! 4564: STWA_R	stwa	%r11, [%r24 + %r0] 0x4f
	mov	0x20, %r26
	.word 0x87802020  ! 4566: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc8400  ! 4567: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	mov	0x0, %r24
	.word 0xd4a74e40  ! 4569: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	.word 0xd8d72000  ! 4570: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8a7a000  ! 4571: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0xd6d689e0  ! 4572: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r11
	.word 0xd4c7ce60  ! 4573: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r10
	mov	0x68, %r27
	.word 0xd29fa000  ! 4575: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	mov	0x7d8, %r22
	mov	0x28, %r24
	mov	0x20, %r27
	.word 0xd2d74e40  ! 4579: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r9
	.word 0xda8f2000  ! 4580: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	.word 0xdabf6000  ! 4581: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd0978e80  ! 4582: LDUHA_R	lduha	[%r30, %r0] 0x74, %r8
	.word 0xd8af6000  ! 4583: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 4584: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf70e60  ! 4585: STXA_R	stxa	%r13, [%r28 + %r0] 0x73
	.word 0x87802025  ! 4586: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2ac0400  ! 4587: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 4588: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b70e40  ! 4589: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xd8bf0e80  ! 4590: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	.word 0xd2ad84a0  ! 4591: STBA_R	stba	%r9, [%r22 + %r0] 0x25
	.word 0xdecd84a0  ! 4592: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r15
	.word 0x87802020  ! 4593: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4c74e40  ! 4594: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r10
	.word 0xdade89e0  ! 4595: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r13
	mov	0x0, %r24
	mov	0x30, %r18
	.word 0xdeb4a000  ! 4598: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 4599: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0d48400  ! 4600: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r8
	.word 0x87802020  ! 4601: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4602: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa609e0  ! 4603: STWA_R	stwa	%r13, [%r24 + %r0] 0x4f
	mov	0x50, %r16
	.word 0xdeb72000  ! 4605: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xd2a689e0  ! 4606: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 4607: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r16
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd49ea000  ! 4610: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r10
	.word 0xd4a6a000  ! 4611: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0xd0bf8e80  ! 4612: STDA_R	stda	%r8, [%r30 + %r0] 0x74
	.word 0xd6d584a0  ! 4613: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r11
	.word 0xdcf74e60  ! 4614: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	mov	0x28, %r27
	.word 0xd4f6a000  ! 4616: STXA_I	stxa	%r10, [%r26 + 0x0000] %asi
	mov	0x20, %r16
	.word 0xd4f6e000  ! 4618: STXA_I	stxa	%r10, [%r27 + 0x0000] %asi
	.word 0xd8cf4e60  ! 4619: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r12
	.word 0xd8dd04a0  ! 4620: LDXA_R	ldxa	[%r20, %r0] 0x25, %r12
	.word 0x87802020  ! 4621: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4622: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b48400  ! 4623: STHA_R	stha	%r10, [%r18 + %r0] 0x20
	.word 0xd8b544a0  ! 4624: STHA_R	stha	%r12, [%r21 + %r0] 0x25
	mov	0x7f0, %r20
	mov	0x30, %r25
	.word 0xd687e000  ! 4627: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0x87802020  ! 4628: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x58, %r16
	.word 0xd8a4c400  ! 4630: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	.word 0x87802074  ! 4631: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r17
	.word 0xd4840400  ! 4633: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r10
	.word 0xdab7ce60  ! 4634: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	mov	0x10, %r26
	.word 0xd0af6000  ! 4636: STBA_I	stba	%r8, [%r29 + 0x0000] %asi
	mov	0x58, %r24
	.word 0xd0b76000  ! 4638: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0af2000  ! 4639: STBA_I	stba	%r8, [%r28 + 0x0000] %asi
	.word 0xd8c7ce40  ! 4640: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r12
	mov	0x38, %r19
	.word 0x87802072  ! 4642: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3e0, %r21
	.word 0xda8f2000  ! 4644: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r13
	mov	0x3e0, %r23
	.word 0xdab7e000  ! 4646: STHA_I	stha	%r13, [%r31 + 0x0000] %asi
	.word 0xdade89e0  ! 4647: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r13
	.word 0xda876000  ! 4648: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xda9f6000  ! 4649: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	mov	0x8, %r27
	.word 0xdacfe000  ! 4651: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r13
	.word 0xda9fe000  ! 4652: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0x87802020  ! 4653: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda95a000  ! 4654: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r13
	mov	0x3f8, %r20
	.word 0x87802020  ! 4656: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6bcc400  ! 4657: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xd6a6c9e0  ! 4658: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0xd2c40400  ! 4659: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r9
	.word 0x87802072  ! 4660: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3f8, %r21
	.word 0xd2f4c400  ! 4662: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	.word 0xd8bc4400  ! 4663: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	.word 0xd0b46000  ! 4664: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd0dce000  ! 4665: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xd08ce000  ! 4666: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	.word 0xd09ce000  ! 4667: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r8
	.word 0xd0b4e000  ! 4668: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0f4e000  ! 4670: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0bc6000  ! 4671: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	.word 0xda978e40  ! 4672: LDUHA_R	lduha	[%r30, %r0] 0x72, %r13
	.word 0x87802025  ! 4673: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8cee000  ! 4674: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r12
	.word 0xd6b74e60  ! 4675: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xd6cee000  ! 4676: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r11
	mov	0x58, %r17
	mov	0x0, %r27
	mov	0x7f0, %r23
	.word 0x8780204f  ! 4680: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ae89e0  ! 4681: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0x87802020  ! 4682: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb78e60  ! 4683: STHA_R	stha	%r15, [%r30 + %r0] 0x73
	.word 0xda9fe000  ! 4684: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0x87802074  ! 4685: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r26
	mov	0x3d0, %r21
	.word 0xdca4c400  ! 4688: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	mov	0x0, %r26
	.word 0xd2b7e000  ! 4690: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdaa74e40  ! 4692: STWA_R	stwa	%r13, [%r29 + %r0] 0x72
	.word 0xd08fce40  ! 4693: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	.word 0xd284c400  ! 4694: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	mov	0x7e8, %r22
	.word 0xd0948400  ! 4696: LDUHA_R	lduha	[%r18, %r0] 0x20, %r8
	.word 0xd0bf4e60  ! 4697: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	.word 0xd4f584a0  ! 4698: STXA_R	stxa	%r10, [%r22 + %r0] 0x25
	mov	0x68, %r26
	.word 0xd6af2000  ! 4700: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b72000  ! 4701: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 4702: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 4703: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4c40400  ! 4704: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xdca66000  ! 4705: STWA_I	stwa	%r14, [%r25 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xdcb66000  ! 4707: STHA_I	stha	%r14, [%r25 + 0x0000] %asi
	mov	0x60, %r24
	mov	0x50, %r16
	.word 0xdcae6000  ! 4710: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	mov	0x58, %r17
	mov	0x0, %r19
	.word 0xdec44400  ! 4713: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	mov	0x78, %r27
	mov	0x48, %r16
	.word 0xd8b66000  ! 4716: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	mov	0x7e0, %r22
	mov	0x0, %r16
	.word 0x87802073  ! 4719: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8876000  ! 4720: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r12
	mov	0x58, %r25
	.word 0xdaa44400  ! 4722: STWA_R	stwa	%r13, [%r17 + %r0] 0x20
	.word 0xd2cd84a0  ! 4723: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r9
	mov	0x48, %r26
	.word 0x87802025  ! 4725: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2dd84a0  ! 4726: LDXA_R	ldxa	[%r22, %r0] 0x25, %r9
	.word 0xd8f44400  ! 4727: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd0f76000  ! 4728: STXA_I	stxa	%r8, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 4729: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4730: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 4731: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bf6000  ! 4732: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	.word 0xdcf70e60  ! 4733: STXA_R	stxa	%r14, [%r28 + %r0] 0x73
	.word 0xd2f7a000  ! 4734: STXA_I	stxa	%r9, [%r30 + 0x0000] %asi
	.word 0xd8b74e80  ! 4735: STHA_R	stha	%r12, [%r29 + %r0] 0x74
	.word 0xd0f7e000  ! 4736: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0b76000  ! 4737: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0xd0bf6000  ! 4738: STDA_I	stda	%r8, [%r29 + 0x0000] %asi
	mov	0x48, %r24
	.word 0x87802072  ! 4740: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 4741: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0df2000  ! 4742: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	.word 0xd28e09e0  ! 4743: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r9
	mov	0x38, %r25
	.word 0xd294c400  ! 4745: LDUHA_R	lduha	[%r19, %r0] 0x20, %r9
	.word 0x87802020  ! 4746: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48f0e40  ! 4747: LDUBA_R	lduba	[%r28, %r0] 0x72, %r10
	mov	0x3f0, %r22
	.word 0xd6a48400  ! 4749: STWA_R	stwa	%r11, [%r18 + %r0] 0x20
	.word 0x87802072  ! 4750: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd28f4e60  ! 4751: LDUBA_R	lduba	[%r29, %r0] 0x73, %r9
	mov	0x68, %r16
	mov	0x10, %r25
	.word 0xd6d6e000  ! 4754: LDSHA_I	ldsha	[%r27, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 4755: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea40400  ! 4756: STWA_R	stwa	%r15, [%r16 + %r0] 0x20
	mov	0x78, %r25
	mov	0x7f0, %r21
	.word 0xd4dce000  ! 4759: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r10
	.word 0xdeb7ce80  ! 4760: STHA_R	stha	%r15, [%r31 + %r0] 0x74
	.word 0xd2cc4400  ! 4761: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r9
	.word 0xd884a000  ! 4762: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r12
	mov	0x28, %r24
	mov	0x7d8, %r23
	.word 0x87802020  ! 4765: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 4766: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeafce60  ! 4767: STBA_R	stba	%r15, [%r31 + %r0] 0x73
	.word 0xdebc0400  ! 4768: STDA_R	stda	%r15, [%r16 + %r0] 0x20
	.word 0xde8689e0  ! 4769: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0x87802025  ! 4770: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0ac2000  ! 4771: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xdcf40400  ! 4772: STXA_R	stxa	%r14, [%r16 + %r0] 0x20
	.word 0xdc946000  ! 4773: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r14
	mov	0x7d8, %r23
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcb46000  ! 4776: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdccc6000  ! 4777: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r14
	.word 0xd6c78e40  ! 4778: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r11
	mov	0x50, %r18
	.word 0xda9cc400  ! 4780: LDDA_R	ldda	[%r19, %r0] 0x20, %r13
	.word 0xdad7ce60  ! 4781: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r13
	.word 0xd28c6000  ! 4782: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	mov	0x70, %r16
	.word 0xd2b4a000  ! 4784: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 4785: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4786: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd29c2000  ! 4787: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r9
	.word 0xd28ca000  ! 4788: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2cc8400  ! 4789: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd885c4a0  ! 4790: LDUWA_R	lduwa	[%r23, %r0] 0x25, %r12
	.word 0xd2974e60  ! 4791: LDUHA_R	lduha	[%r29, %r0] 0x73, %r9
	.word 0xd2846000  ! 4792: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r9
	.word 0xd2ac2000  ! 4793: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd2a4a000  ! 4794: STWA_I	stwa	%r9, [%r18 + 0x0000] %asi
	mov	0x70, %r19
	mov	0x38, %r26
	mov	0x68, %r18
	.word 0xd2bce000  ! 4798: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xdaf44400  ! 4799: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xde8fce80  ! 4800: LDUBA_R	lduba	[%r31, %r0] 0x74, %r15
	.word 0xdcc48400  ! 4801: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	.word 0x87802072  ! 4802: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6d44400  ! 4803: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r11
	mov	0x7e8, %r23
	mov	0x7e8, %r20
	.word 0xdeaca000  ! 4806: STBA_I	stba	%r15, [%r18 + 0x0000] %asi
	.word 0xdef7ce60  ! 4807: STXA_R	stxa	%r15, [%r31 + %r0] 0x73
	.word 0xd0bf8e40  ! 4808: STDA_R	stda	%r8, [%r30 + %r0] 0x72
	mov	0x3f0, %r20
	.word 0xd2842000  ! 4810: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xd0c74e80  ! 4811: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r8
	.word 0xdef70e60  ! 4812: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xdcc70e40  ! 4813: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	.word 0xdef74e40  ! 4814: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0xd0b70e60  ! 4815: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xd6870e60  ! 4816: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	.word 0xd68cc400  ! 4817: LDUBA_R	lduba	[%r19, %r0] 0x20, %r11
	.word 0xd89ca000  ! 4818: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r12
	.word 0xde940400  ! 4819: LDUHA_R	lduha	[%r16, %r0] 0x20, %r15
	.word 0xda96c9e0  ! 4820: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r13
	.word 0xd88c2000  ! 4821: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r12
	.word 0xd2b609e0  ! 4822: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0x87802072  ! 4823: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x48, %r17
	.word 0xd8ad6000  ! 4825: STBA_I	stba	%r12, [%r21 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xd88de000  ! 4827: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r12
	.word 0xd6ad04a0  ! 4828: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0xd0bf0e40  ! 4829: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xd8d5e000  ! 4830: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8cda000  ! 4831: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	.word 0xd8bde000  ! 4832: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x48, %r18
	mov	0x28, %r26
	.word 0xd2bc0400  ! 4836: STDA_R	stda	%r9, [%r16 + %r0] 0x20
	.word 0xdcbc4400  ! 4837: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	mov	0x7c8, %r20
	.word 0xd4d5a000  ! 4839: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	mov	0x78, %r16
	mov	0x18, %r16
	.word 0xd4a5e000  ! 4842: STWA_I	stwa	%r10, [%r23 + 0x0000] %asi
	mov	0x7d0, %r20
	.word 0xd0b70e60  ! 4844: STHA_R	stha	%r8, [%r28 + %r0] 0x73
	.word 0xdadf4e80  ! 4845: LDXA_R	ldxa	[%r29, %r0] 0x74, %r13
	.word 0xdaf5e000  ! 4846: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xd8a70e60  ! 4847: STWA_R	stwa	%r12, [%r28 + %r0] 0x73
	mov	0x78, %r27
	mov	0x68, %r25
	.word 0xd2a504a0  ! 4850: STWA_R	stwa	%r9, [%r20 + %r0] 0x25
	.word 0xd495a000  ! 4851: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r10
	mov	0x7d8, %r22
	.word 0xd48d2000  ! 4853: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r10
	.word 0x87802074  ! 4854: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 4855: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4bfe000  ! 4856: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xda8c0400  ! 4857: LDUBA_R	lduba	[%r16, %r0] 0x20, %r13
	.word 0xd6af4e80  ! 4858: STBA_R	stba	%r11, [%r29 + %r0] 0x74
	mov	0x0, %r27
	mov	0x18, %r18
	.word 0x87802020  ! 4861: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r26
	.word 0xd8b7e000  ! 4863: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 4864: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xda878e40  ! 4866: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	mov	0x30, %r18
	.word 0xd4ce49e0  ! 4868: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r10
	.word 0x87802025  ! 4869: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r20
	.word 0xd2f76000  ! 4871: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	mov	0x7e0, %r23
	.word 0x87802025  ! 4873: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 4874: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2df6000  ! 4875: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2d7e000  ! 4876: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0x87802074  ! 4877: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2cca000  ! 4878: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2942000  ! 4879: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd28ca000  ! 4880: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0x87802020  ! 4881: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 4882: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 4883: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcd40400  ! 4884: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xd4a4e000  ! 4885: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd4bc2000  ! 4886: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	.word 0xd4bc6000  ! 4887: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xde8f8e80  ! 4888: LDUBA_R	lduba	[%r30, %r0] 0x74, %r15
	.word 0xd694a000  ! 4889: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	.word 0xd2b70e80  ! 4890: STHA_R	stha	%r9, [%r28 + %r0] 0x74
	.word 0x87802020  ! 4891: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2d70e60  ! 4892: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0xdcaee000  ! 4893: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	mov	0x50, %r27
	.word 0x87802020  ! 4895: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2dd04a0  ! 4896: LDXA_R	ldxa	[%r20, %r0] 0x25, %r9
	mov	0x60, %r25
	.word 0xd6f78e60  ! 4898: STXA_R	stxa	%r11, [%r30 + %r0] 0x73
	.word 0xd6bf4e60  ! 4899: STDA_R	stda	%r11, [%r29 + %r0] 0x73
	.word 0xde95a000  ! 4900: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r15
	.word 0xd29689e0  ! 4901: LDUHA_R	lduha	[%r26, %r0] 0x4f, %r9
	.word 0xd4f52000  ! 4902: STXA_I	stxa	%r10, [%r20 + 0x0000] %asi
	.word 0xd4956000  ! 4903: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0xdef44400  ! 4904: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	.word 0xd8ce49e0  ! 4905: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r12
	.word 0xd8b40400  ! 4906: STHA_R	stha	%r12, [%r16 + %r0] 0x20
	.word 0x87802025  ! 4907: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r20
	.word 0xdadc4400  ! 4909: LDXA_R	ldxa	[%r17, %r0] 0x20, %r13
	.word 0xdadca000  ! 4910: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	mov	0x28, %r25
	.word 0xd0a70e40  ! 4912: STWA_R	stwa	%r8, [%r28 + %r0] 0x72
	.word 0xd8d4a000  ! 4913: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	mov	0x58, %r18
	.word 0xd8d46000  ! 4915: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r12
	mov	0x70, %r26
	.word 0xd0840400  ! 4917: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	mov	0x20, %r24
	.word 0xd88ca000  ! 4919: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	.word 0xd8a4a000  ! 4920: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd8f4a000  ! 4921: STXA_I	stxa	%r12, [%r18 + 0x0000] %asi
	mov	0x3d0, %r20
	.word 0xd8a4e000  ! 4923: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	mov	0x60, %r26
	.word 0xd28ec9e0  ! 4925: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r9
	.word 0xdab4e000  ! 4926: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdab4e000  ! 4927: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 4928: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaf7e000  ! 4929: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	mov	0x70, %r25
	.word 0xdabf6000  ! 4931: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xd28fce40  ! 4932: LDUBA_R	lduba	[%r31, %r0] 0x72, %r9
	.word 0x87802073  ! 4933: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd29544a0  ! 4934: LDUHA_R	lduha	[%r21, %r0] 0x25, %r9
	.word 0xd4b42000  ! 4935: STHA_I	stha	%r10, [%r16 + 0x0000] %asi
	.word 0xd4ace000  ! 4936: STBA_I	stba	%r10, [%r19 + 0x0000] %asi
	.word 0xdc8c8400  ! 4937: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0x87802020  ! 4938: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6ad04a0  ! 4939: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	mov	0x60, %r27
	.word 0xdaf7e000  ! 4941: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdc9e09e0  ! 4942: LDDA_R	ldda	[%r24, %r0] 0x4f, %r14
	mov	0x3f0, %r22
	mov	0x3d0, %r20
	.word 0xd4dfa000  ! 4945: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4972000  ! 4946: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0xd08f8e60  ! 4947: LDUBA_R	lduba	[%r30, %r0] 0x73, %r8
	mov	0x28, %r18
	.word 0xd4bfe000  ! 4949: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xdc96c9e0  ! 4950: LDUHA_R	lduha	[%r27, %r0] 0x4f, %r14
	.word 0xd2dcc400  ! 4951: LDXA_R	ldxa	[%r19, %r0] 0x20, %r9
	.word 0xde87e000  ! 4952: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdabec9e0  ! 4953: STDA_R	stda	%r13, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 4954: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c44400  ! 4955: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0xd69e49e0  ! 4956: LDDA_R	ldda	[%r25, %r0] 0x4f, %r11
	.word 0xd2c4a000  ! 4957: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	.word 0xd2bce000  ! 4958: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xd2842000  ! 4959: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8d7ce40  ! 4961: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r12
	mov	0x7f8, %r23
	.word 0xdcc4c400  ! 4963: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0x87802074  ! 4964: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0840400  ! 4965: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r8
	.word 0xd8bc2000  ! 4966: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8d42000  ! 4967: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8f609e0  ! 4968: STXA_R	stxa	%r12, [%r24 + %r0] 0x4f
	.word 0xd0dce000  ! 4969: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r8
	.word 0xdaa74e80  ! 4970: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xd09c0400  ! 4971: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0x87802020  ! 4972: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca70e60  ! 4973: STWA_R	stwa	%r14, [%r28 + %r0] 0x73
	.word 0xd6bc2000  ! 4974: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0xd2b4c400  ! 4975: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x87802025  ! 4976: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r27
	.word 0xd4bc6000  ! 4978: STDA_I	stda	%r10, [%r17 + 0x0000] %asi
	.word 0xd49ca000  ! 4979: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd8d78e80  ! 4980: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r12
	.word 0x87802020  ! 4981: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ad6000  ! 4982: STBA_I	stba	%r8, [%r21 + 0x0000] %asi
	.word 0xd0a52000  ! 4983: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0xd8bf0e80  ! 4984: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	mov	0x3f8, %r21
	.word 0xd0ae89e0  ! 4986: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0xd6a74e80  ! 4987: STWA_R	stwa	%r11, [%r29 + %r0] 0x74
	.word 0xd8aec9e0  ! 4988: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xd8bde000  ! 4989: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xde870e80  ! 4991: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r15
	mov	0x3f0, %r21
	mov	0x10, %r24
	.word 0xd2dd6000  ! 4994: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r9
	.word 0xd28d6000  ! 4995: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4996: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcbf4e80  ! 4997: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	mov	0x3d0, %r23
	setx	join_lbl_0_0, %g1, %g2
	jmp	%g2
	nop
fork_lbl_0_1:
	.word 0xd8f74e60  ! 1: STXA_R	stxa	%r12, [%r29 + %r0] 0x73
	.word 0xd28cc400  ! 2: LDUBA_R	lduba	[%r19, %r0] 0x20, %r9
	.word 0xdc9e6000  ! 3: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r14
	.word 0xdcc66000  ! 4: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	.word 0xdc96a000  ! 5: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r14
	.word 0xdcaf4e60  ! 6: STBA_R	stba	%r14, [%r29 + %r0] 0x73
	mov	0x48, %r27
	.word 0xdebdc4a0  ! 8: STDA_R	stda	%r15, [%r23 + %r0] 0x25
	mov	0x18, %r25
	.word 0xd4f6c9e0  ! 10: STXA_R	stxa	%r10, [%r27 + %r0] 0x4f
	.word 0xd4f74e80  ! 11: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xdca78e60  ! 12: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	mov	0x40, %r26
	mov	0x30, %r18
	.word 0xd69cc400  ! 15: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	mov	0x60, %r18
	.word 0xdcaee000  ! 17: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0xdc9e2000  ! 18: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r14
	.word 0xdcd62000  ! 19: LDSHA_I	ldsha	[%r24, + 0x0000] %asi, %r14
	.word 0xdcc6e000  ! 20: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r14
	.word 0x8780204f  ! 21: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 22: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a7ce80  ! 23: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	mov	0x3f0, %r23
	.word 0x87802020  ! 25: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8962000  ! 26: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r12
	mov	0x8, %r16
	.word 0x87802020  ! 28: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d8, %r20
	.word 0xd8ade000  ! 30: STBA_I	stba	%r12, [%r23 + 0x0000] %asi
	.word 0xd6a6c9e0  ! 31: STWA_R	stwa	%r11, [%r27 + %r0] 0x4f
	.word 0xdeaf8e80  ! 32: STBA_R	stba	%r15, [%r30 + %r0] 0x74
	mov	0x7e0, %r23
	.word 0xd8df4e40  ! 34: LDXA_R	ldxa	[%r29, %r0] 0x72, %r12
	mov	0x3e0, %r20
	.word 0xd6bcc400  ! 36: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0x87802072  ! 37: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a78e60  ! 38: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	.word 0x87802020  ! 39: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r27
	.word 0xdec544a0  ! 41: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r15
	.word 0xdccf4e60  ! 42: LDSBA_R	ldsba	[%r29, %r0] 0x73, %r14
	mov	0x78, %r19
	.word 0xd4c74e80  ! 44: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r10
	mov	0x78, %r19
	mov	0x40, %r16
	.word 0x87802072  ! 47: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2f42000  ! 48: STXA_I	stxa	%r9, [%r16 + 0x0000] %asi
	.word 0xdccd84a0  ! 49: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r14
	.word 0xd4b4a000  ! 50: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 51: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd497a000  ! 52: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xdead44a0  ! 53: STBA_R	stba	%r15, [%r21 + %r0] 0x25
	.word 0xdcc70e40  ! 54: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	.word 0xd4dfce60  ! 55: LDXA_R	ldxa	[%r31, %r0] 0x73, %r10
	.word 0xdaf72000  ! 56: STXA_I	stxa	%r13, [%r28 + 0x0000] %asi
	.word 0xdaa40400  ! 57: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xd8c78e40  ! 58: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	mov	0x0, %r24
	.word 0x87802073  ! 60: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b4a000  ! 61: STHA_I	stha	%r11, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 62: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r19
	.word 0xd6c46000  ! 64: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6942000  ! 65: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r11
	mov	0x3f8, %r20
	.word 0xdaaf8e80  ! 67: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0x87802020  ! 68: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r17
	.word 0xdeb74e80  ! 70: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xdca7a000  ! 71: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xdc87e000  ! 72: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r14
	.word 0xd0dcc400  ! 73: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0x87802020  ! 74: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 75: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd09ee000  ! 76: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r8
	.word 0xd0c74e60  ! 77: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r8
	.word 0xd8de09e0  ! 78: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0xd28ee000  ! 79: LDUBA_I	lduba	[%r27, + 0x0000] %asi, %r9
	.word 0xd2a66000  ! 80: STWA_I	stwa	%r9, [%r25 + 0x0000] %asi
	.word 0xd286a000  ! 81: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r9
	.word 0x87802020  ! 82: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd28c2000  ! 83: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r9
	.word 0xd2842000  ! 84: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r9
	.word 0xd8974e60  ! 85: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	mov	0x10, %r18
	.word 0xd097ce80  ! 87: LDUHA_R	lduha	[%r31, %r0] 0x74, %r8
	mov	0x7c8, %r22
	mov	0x70, %r25
	.word 0xdad40400  ! 90: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r13
	.word 0xd6846000  ! 91: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0xd6b4e000  ! 92: STHA_I	stha	%r11, [%r19 + 0x0000] %asi
	.word 0xd6b46000  ! 93: STHA_I	stha	%r11, [%r17 + 0x0000] %asi
	.word 0xd6dc2000  ! 94: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r11
	.word 0xd2b649e0  ! 95: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xd4c40400  ! 96: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r10
	.word 0xded46000  ! 97: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r15
	.word 0x87802072  ! 98: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde8649e0  ! 99: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r15
	.word 0xd6c70e80  ! 100: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r11
	.word 0xda87ce80  ! 101: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	mov	0x70, %r24
	.word 0x8780204f  ! 103: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc9f4e80  ! 104: LDDA_R	ldda	[%r29, %r0] 0x74, %r14
	.word 0xd4ddc4a0  ! 105: LDXA_R	ldxa	[%r23, %r0] 0x25, %r10
	.word 0xd8d4a000  ! 106: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r12
	.word 0x87802073  ! 107: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8d5e000  ! 108: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r12
	.word 0xd8de09e0  ! 109: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r12
	.word 0xd8a5e000  ! 110: STWA_I	stwa	%r12, [%r23 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd8ad2000  ! 112: STBA_I	stba	%r12, [%r20 + 0x0000] %asi
	.word 0xd4d78e40  ! 113: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r10
	mov	0x3c8, %r20
	mov	0x3e8, %r20
	.word 0x87802074  ! 116: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r27
	.word 0xdecf0e80  ! 118: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	.word 0xd0b74e60  ! 119: STHA_R	stha	%r8, [%r29 + %r0] 0x73
	.word 0xd6bc0400  ! 120: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xdac6a000  ! 121: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xdaae6000  ! 122: STBA_I	stba	%r13, [%r25 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xdabee000  ! 124: STDA_I	stda	%r13, [%r27 + 0x0000] %asi
	.word 0xdea504a0  ! 125: STWA_R	stwa	%r15, [%r20 + %r0] 0x25
	.word 0xdaa6e000  ! 126: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xda966000  ! 127: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r13
	mov	0x10, %r17
	mov	0x60, %r24
	.word 0x87802020  ! 130: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9ee000  ! 131: LDDA_I	ldda	[%r27, + 0x0000] %asi, %r13
	.word 0xd6b544a0  ! 132: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	mov	0x78, %r19
	mov	0x3c8, %r22
	.word 0xd2a44400  ! 135: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xdeaea000  ! 136: STBA_I	stba	%r15, [%r26 + 0x0000] %asi
	.word 0xdaf44400  ! 137: STXA_R	stxa	%r13, [%r17 + %r0] 0x20
	.word 0xd286e000  ! 138: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	.word 0xd8dec9e0  ! 139: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r12
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8f584a0  ! 141: STXA_R	stxa	%r12, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 142: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2f6a000  ! 143: STXA_I	stxa	%r9, [%r26 + 0x0000] %asi
	mov	0x7f8, %r22
	mov	0x28, %r27
	.word 0xd08c4400  ! 146: LDUBA_R	lduba	[%r17, %r0] 0x20, %r8
	.word 0xd8cea000  ! 147: LDSBA_I	ldsba	[%r26, + 0x0000] %asi, %r12
	.word 0xd88ea000  ! 148: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	.word 0xd8c6a000  ! 149: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xdaa584a0  ! 150: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0x87802073  ! 151: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4c609e0  ! 152: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r10
	.word 0xd4a4a000  ! 153: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xdeb4c400  ! 154: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xd48ec9e0  ! 155: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r10
	mov	0x60, %r24
	.word 0x87802073  ! 157: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdea689e0  ! 158: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0xd8872000  ! 159: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0xd887a000  ! 160: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r12
	.word 0xdadfce60  ! 161: LDXA_R	ldxa	[%r31, %r0] 0x73, %r13
	.word 0xdadfce80  ! 162: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0xdabf8e40  ! 163: STDA_R	stda	%r13, [%r30 + %r0] 0x72
	.word 0xda9f2000  ! 164: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	mov	0x3c0, %r23
	.word 0xdabfa000  ! 166: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	.word 0x8780204f  ! 167: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa6a000  ! 168: STWA_I	stwa	%r13, [%r26 + 0x0000] %asi
	.word 0xd8a504a0  ! 169: STWA_R	stwa	%r12, [%r20 + %r0] 0x25
	.word 0xd0f74e60  ! 170: STXA_R	stxa	%r8, [%r29 + %r0] 0x73
	mov	0x3e8, %r22
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4b6a000  ! 173: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0xd4aea000  ! 174: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xd4dea000  ! 175: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r10
	.word 0xd4ae6000  ! 176: STBA_I	stba	%r10, [%r25 + 0x0000] %asi
	.word 0xd6f7ce60  ! 177: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0xdc96a000  ! 178: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r14
	.word 0xdc866000  ! 179: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r14
	.word 0xd6f78e40  ! 180: STXA_R	stxa	%r11, [%r30 + %r0] 0x72
	mov	0x10, %r24
	mov	0x3c8, %r22
	.word 0xdea74e40  ! 183: STWA_R	stwa	%r15, [%r29 + %r0] 0x72
	mov	0x28, %r18
	mov	0x3d0, %r23
	.word 0x87802020  ! 186: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7d0, %r21
	.word 0x87802025  ! 189: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r17
	.word 0xdea7ce80  ! 191: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	mov	0x48, %r26
	mov	0x20, %r25
	.word 0xd8ac0400  ! 194: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd0b62000  ! 195: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0xde9e49e0  ! 196: LDDA_R	ldda	[%r25, %r0] 0x4f, %r15
	.word 0xda862000  ! 197: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r13
	.word 0xdaa66000  ! 198: STWA_I	stwa	%r13, [%r25 + 0x0000] %asi
	.word 0xd2b74e80  ! 199: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	.word 0xdaae2000  ! 200: STBA_I	stba	%r13, [%r24 + 0x0000] %asi
	.word 0xd8a78e80  ! 201: STWA_R	stwa	%r12, [%r30 + %r0] 0x74
	.word 0xd4bee000  ! 202: STDA_I	stda	%r10, [%r27 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xd4de2000  ! 204: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r10
	.word 0xd4ce2000  ! 205: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r10
	mov	0x58, %r16
	mov	0x30, %r24
	mov	0x78, %r16
	mov	0x60, %r25
	mov	0x3f8, %r21
	.word 0xdaf48400  ! 211: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd0f6e000  ! 212: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd0a62000  ! 213: STWA_I	stwa	%r8, [%r24 + 0x0000] %asi
	.word 0xdef70e60  ! 214: STXA_R	stxa	%r15, [%r28 + %r0] 0x73
	.word 0xd29f0e40  ! 215: LDDA_R	ldda	[%r28, %r0] 0x72, %r9
	.word 0xdecf0e60  ! 216: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0xdcd48400  ! 217: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r14
	mov	0x68, %r26
	.word 0xde96e000  ! 219: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r15
	mov	0x7c8, %r20
	.word 0xdeb6e000  ! 221: STHA_I	stha	%r15, [%r27 + 0x0000] %asi
	.word 0xde866000  ! 222: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r15
	mov	0x28, %r16
	.word 0x87802020  ! 224: WRASI_I	wr	%r0, 0x0020, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdef42000  ! 226: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xde94e000  ! 227: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r15
	.word 0x87802020  ! 228: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeac6000  ! 229: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0xd2b70e40  ! 230: STHA_R	stha	%r9, [%r28 + %r0] 0x72
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xdaa74e80  ! 232: STWA_R	stwa	%r13, [%r29 + %r0] 0x74
	.word 0xd4a46000  ! 233: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd4b46000  ! 234: STHA_I	stha	%r10, [%r17 + 0x0000] %asi
	.word 0xd4a4e000  ! 235: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xd48ca000  ! 236: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0xd6d6c9e0  ! 237: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r11
	.word 0xd8cf8e60  ! 238: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r12
	mov	0x3f8, %r20
	.word 0xd28ca000  ! 240: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2f4e000  ! 241: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2a48400  ! 242: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x7e0, %r20
	.word 0xd8dfce80  ! 244: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	.word 0xd08fce80  ! 245: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	mov	0x7d0, %r20
	.word 0xdccca000  ! 247: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r14
	mov	0x78, %r25
	mov	0x10, %r19
	.word 0xdca46000  ! 250: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 251: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc9544a0  ! 252: LDUHA_R	lduha	[%r21, %r0] 0x25, %r14
	mov	0x3f8, %r22
	.word 0xd0a74e80  ! 254: STWA_R	stwa	%r8, [%r29 + %r0] 0x74
	.word 0xd49ca000  ! 255: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd8974e60  ! 256: LDUHA_R	lduha	[%r29, %r0] 0x73, %r12
	.word 0xde9c0400  ! 257: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	mov	0x50, %r19
	.word 0xd69c8400  ! 259: LDDA_R	ldda	[%r18, %r0] 0x20, %r11
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2c78e60  ! 261: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r9
	.word 0x87802020  ! 262: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f0, %r23
	mov	0x18, %r17
	.word 0xdaf4a000  ! 265: STXA_I	stxa	%r13, [%r18 + 0x0000] %asi
	.word 0xd09f8e80  ! 266: LDDA_R	ldda	[%r30, %r0] 0x74, %r8
	.word 0xd09f0e40  ! 267: LDDA_R	ldda	[%r28, %r0] 0x72, %r8
	.word 0xd294e000  ! 268: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r9
	.word 0xd2c4a000  ! 269: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r9
	mov	0x3f8, %r23
	.word 0xd2cce000  ! 271: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r9
	.word 0xd2ace000  ! 272: STBA_I	stba	%r9, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 273: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd49c4400  ! 274: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	mov	0x78, %r26
	.word 0xd8f5c4a0  ! 276: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xd6f7a000  ! 277: STXA_I	stxa	%r11, [%r30 + 0x0000] %asi
	mov	0x40, %r27
	.word 0xdac40400  ! 279: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	.word 0xdeafe000  ! 280: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	mov	0x7e8, %r21
	.word 0xd88e09e0  ! 282: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0xd8a7e000  ! 283: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8cf2000  ! 284: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r12
	mov	0x7e0, %r23
	.word 0xd88f2000  ! 286: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 287: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0af8e60  ! 288: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0x8780204f  ! 289: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r18
	.word 0xd8ac4400  ! 291: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd8bc2000  ! 292: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd6870e40  ! 293: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r11
	mov	0x38, %r25
	.word 0xd2b4c400  ! 295: STHA_R	stha	%r9, [%r19 + %r0] 0x20
	.word 0x87802020  ! 296: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 297: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 298: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r19
	.word 0xdcdce000  ! 300: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r14
	.word 0xdaf544a0  ! 301: STXA_R	stxa	%r13, [%r21 + %r0] 0x25
	.word 0xdab7ce60  ! 302: STHA_R	stha	%r13, [%r31 + %r0] 0x73
	mov	0x7c0, %r22
	mov	0x3c8, %r23
	.word 0xd0d46000  ! 305: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0x87802020  ! 306: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0bf4e80  ! 307: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	mov	0x7c8, %r20
	.word 0xd0bcc400  ! 309: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xdcc4c400  ! 310: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0x87802072  ! 311: WRASI_I	wr	%r0, 0x0072, %asi
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6a78e80  ! 313: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	mov	0x40, %r18
	.word 0xd0dfa000  ! 315: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r8
	.word 0xd0dfe000  ! 316: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r8
	.word 0x8780204f  ! 317: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a66000  ! 318: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	.word 0xd0f66000  ! 319: STXA_I	stxa	%r8, [%r25 + 0x0000] %asi
	.word 0xd6a40400  ! 320: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x20, %r25
	.word 0xd2c74e60  ! 322: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r9
	.word 0x87802074  ! 323: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda9c4400  ! 324: LDDA_R	ldda	[%r17, %r0] 0x20, %r13
	mov	0x48, %r24
	.word 0xd6f7e000  ! 326: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	mov	0x3f0, %r20
	.word 0xd087ce80  ! 328: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	.word 0x87802074  ! 329: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r26
	mov	0x50, %r24
	.word 0x87802020  ! 332: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d7e000  ! 333: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r11
	.word 0xd6afe000  ! 334: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	.word 0xd6df2000  ! 335: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r11
	.word 0xdeae89e0  ! 336: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	mov	0x70, %r16
	.word 0xde9f2000  ! 338: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xd6acc400  ! 339: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	.word 0x87802020  ! 340: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r17
	.word 0xd6bf6000  ! 342: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	mov	0x7c0, %r23
	.word 0xd8a78e60  ! 344: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	mov	0x58, %r18
	mov	0x38, %r16
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd6cf8e80  ! 348: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0xdef76000  ! 349: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	.word 0xdeafa000  ! 350: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd4b78e40  ! 351: STHA_R	stha	%r10, [%r30 + %r0] 0x72
	.word 0xdc9c0400  ! 352: LDDA_R	ldda	[%r16, %r0] 0x20, %r14
	.word 0xd4df6000  ! 353: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0x8780204f  ! 354: WRASI_I	wr	%r0, 0x004f, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x20, %r19
	mov	0x20, %r27
	.word 0x87802072  ! 358: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4b4e000  ! 359: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xde97ce80  ! 360: LDUHA_R	lduha	[%r31, %r0] 0x74, %r15
	.word 0xda9ce000  ! 361: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r13
	.word 0xdad4e000  ! 362: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r13
	.word 0xdab42000  ! 363: STHA_I	stha	%r13, [%r16 + 0x0000] %asi
	.word 0xdaac2000  ! 364: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xdacce000  ! 365: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r13
	.word 0x87802025  ! 366: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r19
	.word 0xd0bdc4a0  ! 368: STDA_R	stda	%r8, [%r23 + %r0] 0x25
	.word 0xd2f5c4a0  ! 369: STXA_R	stxa	%r9, [%r23 + %r0] 0x25
	.word 0xd4afce40  ! 370: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	.word 0xd4a7e000  ! 371: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 372: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4ad6000  ! 373: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0xdcce49e0  ! 374: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r14
	mov	0x7f0, %r23
	.word 0xd4bda000  ! 376: STDA_I	stda	%r10, [%r22 + 0x0000] %asi
	.word 0xd8c609e0  ! 377: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r12
	.word 0x87802073  ! 378: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x18, %r17
	.word 0xd8de2000  ! 380: LDXA_I	ldxa	[%r24, + 0x0000] %asi, %r12
	.word 0xdccfce40  ! 381: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r14
	.word 0xd6dee000  ! 382: LDXA_I	ldxa	[%r27, + 0x0000] %asi, %r11
	.word 0xd6de6000  ! 383: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r11
	.word 0xd6840400  ! 384: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r11
	.word 0xd0bd84a0  ! 385: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0x87802074  ! 386: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 387: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdaa7ce40  ! 388: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	.word 0xdad504a0  ! 389: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r13
	.word 0xdef40400  ! 390: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd88c0400  ! 391: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0x8780204f  ! 392: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bda000  ! 393: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	.word 0xdeb609e0  ! 394: STHA_R	stha	%r15, [%r24 + %r0] 0x4f
	mov	0x3e0, %r22
	.word 0xdabf0e60  ! 396: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xd29d2000  ! 397: LDDA_I	ldda	[%r20, + 0x0000] %asi, %r9
	.word 0xd2bde000  ! 398: STDA_I	stda	%r9, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 399: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdea7ce80  ! 400: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xd49c8400  ! 401: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	mov	0x3e8, %r21
	.word 0x8780204f  ! 403: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8504a0  ! 404: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r15
	.word 0xd48f8e40  ! 405: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	.word 0xd2a76000  ! 406: STWA_I	stwa	%r9, [%r29 + 0x0000] %asi
	.word 0xd2cf0e80  ! 407: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xd6b70e40  ! 408: STHA_R	stha	%r11, [%r28 + %r0] 0x72
	.word 0xdef76000  ! 409: STXA_I	stxa	%r15, [%r29 + 0x0000] %asi
	mov	0x30, %r25
	.word 0xde9f2000  ! 411: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0x87802072  ! 412: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde87e000  ! 413: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd8b7ce40  ! 414: STHA_R	stha	%r12, [%r31 + %r0] 0x72
	.word 0xdca74e60  ! 415: STWA_R	stwa	%r14, [%r29 + %r0] 0x73
	.word 0xde9e09e0  ! 416: LDDA_R	ldda	[%r24, %r0] 0x4f, %r15
	.word 0xdea78e80  ! 417: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	.word 0xd8af0e60  ! 418: STBA_R	stba	%r12, [%r28 + %r0] 0x73
	.word 0xdc944400  ! 419: LDUHA_R	lduha	[%r17, %r0] 0x20, %r14
	.word 0xd0ac8400  ! 420: STBA_R	stba	%r8, [%r18 + %r0] 0x20
	.word 0xdaa7e000  ! 421: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0xda97e000  ! 422: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r13
	.word 0xdadf6000  ! 423: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0x87802025  ! 424: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3f8, %r22
	.word 0xd8b7ce60  ! 426: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	.word 0xd2d70e40  ! 427: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r9
	.word 0x87802073  ! 428: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x60, %r27
	.word 0x87802020  ! 430: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 431: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29f0e60  ! 432: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	mov	0x38, %r24
	.word 0xd8dc4400  ! 434: LDXA_R	ldxa	[%r17, %r0] 0x20, %r12
	.word 0xdcc70e80  ! 435: LDSWA_R	ldswa	[%r28, %r0] 0x74, %r14
	.word 0xd2df4e60  ! 436: LDXA_R	ldxa	[%r29, %r0] 0x73, %r9
	.word 0xde9f8e80  ! 437: LDDA_R	ldda	[%r30, %r0] 0x74, %r15
	.word 0xd2946000  ! 438: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2f46000  ! 439: STXA_I	stxa	%r9, [%r17 + 0x0000] %asi
	.word 0xd2bca000  ! 440: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 441: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 442: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2cfa000  ! 443: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 444: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd284c400  ! 445: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r9
	mov	0x78, %r18
	mov	0x3e8, %r21
	.word 0xd2cf0e80  ! 448: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r9
	.word 0xd28f8e80  ! 449: LDUBA_R	lduba	[%r30, %r0] 0x74, %r9
	.word 0xd4f76000  ! 450: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 451: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4d56000  ! 452: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0xd4ad6000  ! 453: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0xd4ad6000  ! 454: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0xdcb6c9e0  ! 455: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0xd0be09e0  ! 456: STDA_R	stda	%r8, [%r24 + %r0] 0x4f
	.word 0xd2ad6000  ! 457: STBA_I	stba	%r9, [%r21 + 0x0000] %asi
	.word 0xd4af4e60  ! 458: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	mov	0x7d0, %r21
	.word 0xdcc6c9e0  ! 460: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r14
	.word 0xd28544a0  ! 461: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	mov	0x7d8, %r23
	.word 0xd8b78e80  ! 463: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xdab52000  ! 464: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xdaad2000  ! 465: STBA_I	stba	%r13, [%r20 + 0x0000] %asi
	.word 0xde9dc4a0  ! 466: LDDA_R	ldda	[%r23, %r0] 0x25, %r15
	mov	0x38, %r18
	.word 0xdcdcc400  ! 468: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8856000  ! 470: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r12
	.word 0xd4af4e40  ! 471: STBA_R	stba	%r10, [%r29 + %r0] 0x72
	mov	0x3e8, %r20
	.word 0xd2bc8400  ! 473: STDA_R	stda	%r9, [%r18 + %r0] 0x20
	.word 0xd2ade000  ! 474: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xd6f74e40  ! 475: STXA_R	stxa	%r11, [%r29 + %r0] 0x72
	.word 0xd89de000  ! 476: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r12
	mov	0x60, %r18
	.word 0xdaafce80  ! 478: STBA_R	stba	%r13, [%r31 + %r0] 0x74
	.word 0xd8c74e60  ! 479: LDSWA_R	ldswa	[%r29, %r0] 0x73, %r12
	.word 0xd6a78e80  ! 480: STWA_R	stwa	%r11, [%r30 + %r0] 0x74
	.word 0xd0ad2000  ! 481: STBA_I	stba	%r8, [%r20 + 0x0000] %asi
	.word 0xdebcc400  ! 482: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	.word 0xd2ada000  ! 483: STBA_I	stba	%r9, [%r22 + 0x0000] %asi
	.word 0xdaa609e0  ! 484: STWA_R	stwa	%r13, [%r24 + %r0] 0x4f
	mov	0x3e0, %r21
	.word 0xd0c544a0  ! 486: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r8
	.word 0xdcbd6000  ! 487: STDA_I	stda	%r14, [%r21 + 0x0000] %asi
	.word 0xdc9da000  ! 488: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r14
	mov	0x30, %r24
	.word 0xde9c8400  ! 490: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xde9f8e60  ! 491: LDDA_R	ldda	[%r30, %r0] 0x73, %r15
	.word 0x87802072  ! 492: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdeb46000  ! 493: STHA_I	stha	%r15, [%r17 + 0x0000] %asi
	.word 0x87802020  ! 494: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde87e000  ! 495: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd4bc0400  ! 496: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xd4b7a000  ! 497: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4cfe000  ! 498: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r10
	.word 0xd6b4c400  ! 499: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xd69f2000  ! 500: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xdca70e80  ! 501: STWA_R	stwa	%r14, [%r28 + %r0] 0x74
	.word 0xdaaf8e80  ! 502: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0xd2d7ce80  ! 503: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r9
	.word 0xd28f6000  ! 504: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0xdabc0400  ! 505: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	mov	0x20, %r18
	.word 0xd8dd84a0  ! 507: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0xd0bf4e40  ! 508: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0xd0f7e000  ! 509: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0xd0bfe000  ! 510: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd2d7ce40  ! 511: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r9
	.word 0xd6b72000  ! 512: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	mov	0x7d0, %r22
	.word 0xd6afe000  ! 514: STBA_I	stba	%r11, [%r31 + 0x0000] %asi
	mov	0x48, %r27
	.word 0xd4afce60  ! 516: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	.word 0xd6b76000  ! 517: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	.word 0xd6d7a000  ! 518: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	mov	0x68, %r19
	.word 0x87802073  ! 520: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6cc6000  ! 521: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r11
	mov	0x68, %r24
	.word 0xd6f4a000  ! 523: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	mov	0x40, %r26
	mov	0x70, %r27
	mov	0x20, %r27
	mov	0x58, %r16
	mov	0x48, %r19
	.word 0xd6cce000  ! 529: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r11
	mov	0x7c8, %r21
	.word 0xd68f8e40  ! 531: LDUBA_R	lduba	[%r30, %r0] 0x72, %r11
	.word 0xd6978e60  ! 532: LDUHA_R	lduha	[%r30, %r0] 0x73, %r11
	.word 0x87802020  ! 533: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8ac4400  ! 534: STBA_R	stba	%r12, [%r17 + %r0] 0x20
	.word 0xd8bf6000  ! 535: STDA_I	stda	%r12, [%r29 + 0x0000] %asi
	.word 0xdaad44a0  ! 536: STBA_R	stba	%r13, [%r21 + %r0] 0x25
	.word 0xd8df0e40  ! 537: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	mov	0x3f0, %r22
	.word 0x87802074  ! 539: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd28f2000  ! 540: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r9
	.word 0xd0b4c400  ! 541: STHA_R	stha	%r8, [%r19 + %r0] 0x20
	.word 0xd095c4a0  ! 542: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	.word 0xde8fa000  ! 543: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0xdcbc8400  ! 544: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd2d76000  ! 545: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd2a72000  ! 546: STWA_I	stwa	%r9, [%r28 + 0x0000] %asi
	mov	0x58, %r25
	.word 0xdea78e80  ! 548: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	mov	0x3d0, %r23
	mov	0x50, %r24
	.word 0xd8bfe000  ! 551: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	mov	0x30, %r17
	.word 0xd4bfce60  ! 553: STDA_R	stda	%r10, [%r31 + %r0] 0x73
	.word 0xdecfe000  ! 554: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xd88cc400  ! 555: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0x87802025  ! 556: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x20, %r18
	.word 0xd08544a0  ! 558: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r8
	.word 0xd8afe000  ! 559: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd8d7a000  ! 560: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xdc978e80  ! 561: LDUHA_R	lduha	[%r30, %r0] 0x74, %r14
	.word 0xd4b74e40  ! 562: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	mov	0x0, %r19
	.word 0xdabfce60  ! 564: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0xd4b689e0  ! 565: STHA_R	stha	%r10, [%r26 + %r0] 0x4f
	.word 0xdcbf2000  ! 566: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 567: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 568: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0b609e0  ! 569: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	.word 0xd2b44400  ! 570: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd2bd6000  ! 571: STDA_I	stda	%r9, [%r21 + 0x0000] %asi
	.word 0xdea4c400  ! 572: STWA_R	stwa	%r15, [%r19 + %r0] 0x20
	mov	0x60, %r27
	mov	0x3d0, %r22
	.word 0xda94c400  ! 575: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0x87802072  ! 576: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4cf6000  ! 577: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r10
	mov	0x38, %r25
	.word 0xde8c4400  ! 579: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xd8976000  ! 580: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8f72000  ! 581: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	mov	0x3f0, %r21
	mov	0x10, %r25
	.word 0xd8afa000  ! 584: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	mov	0x20, %r25
	.word 0xde8f4e40  ! 586: LDUBA_R	lduba	[%r29, %r0] 0x72, %r15
	.word 0xd487a000  ! 587: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r10
	.word 0xde848400  ! 588: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r15
	.word 0xdabf6000  ! 589: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 590: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a78e40  ! 591: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	.word 0x87802072  ! 592: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r27
	.word 0xdeaf2000  ! 594: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xd6cd84a0  ! 595: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r11
	.word 0xd0940400  ! 596: LDUHA_R	lduha	[%r16, %r0] 0x20, %r8
	.word 0xd08584a0  ! 597: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x48, %r19
	.word 0xd0bd84a0  ! 600: STDA_R	stda	%r8, [%r22 + %r0] 0x25
	.word 0xd2a4c400  ! 601: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xdea7e000  ! 602: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	mov	0x3e0, %r21
	.word 0x8780204f  ! 604: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 605: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedde000  ! 606: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r15
	mov	0x70, %r19
	.word 0x87802025  ! 608: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3d8, %r21
	mov	0x58, %r25
	.word 0x87802025  ! 611: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6cfce40  ! 612: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xdeb584a0  ! 613: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0xd69cc400  ! 614: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xd6f609e0  ! 615: STXA_R	stxa	%r11, [%r24 + %r0] 0x4f
	.word 0x8780204f  ! 616: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0aea000  ! 617: STBA_I	stba	%r8, [%r26 + 0x0000] %asi
	.word 0xd4978e40  ! 618: LDUHA_R	lduha	[%r30, %r0] 0x72, %r10
	.word 0xd6ae6000  ! 619: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 620: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cf6000  ! 621: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6bf6000  ! 622: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cf6000  ! 623: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r11
	.word 0xd6dfe000  ! 624: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	mov	0x8, %r18
	.word 0xd6976000  ! 626: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r11
	.word 0xd4d504a0  ! 627: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r10
	.word 0xdc97a000  ! 628: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xd4870e60  ! 629: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r10
	.word 0x8780204f  ! 630: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdeac4400  ! 631: STBA_R	stba	%r15, [%r17 + %r0] 0x20
	.word 0xd2dfe000  ! 632: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r9
	mov	0x8, %r18
	mov	0x70, %r16
	.word 0xd2bfa000  ! 635: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0x87802073  ! 636: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bf4e40  ! 637: STDA_R	stda	%r10, [%r29 + %r0] 0x72
	.word 0xd0bf0e40  ! 638: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xd48ec9e0  ! 639: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r10
	mov	0x7d0, %r22
	mov	0x40, %r19
	.word 0xdc848400  ! 642: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	.word 0xd28e89e0  ! 643: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r9
	.word 0x8780204f  ! 644: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8f6000  ! 645: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	.word 0xdec7a000  ! 646: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r15
	.word 0x8780204f  ! 647: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4bf0e80  ! 648: STDA_R	stda	%r10, [%r28 + %r0] 0x74
	.word 0xdabe09e0  ! 649: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	mov	0x0, %r25
	.word 0x87802020  ! 651: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 652: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb7a000  ! 653: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	mov	0x60, %r19
	.word 0x87802020  ! 655: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r23
	.word 0xdeb7e000  ! 657: STHA_I	stha	%r15, [%r31 + 0x0000] %asi
	.word 0xdadf8e40  ! 658: LDXA_R	ldxa	[%r30, %r0] 0x72, %r13
	.word 0xd49f2000  ! 659: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4dfa000  ! 660: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd08f0e40  ! 661: LDUBA_R	lduba	[%r28, %r0] 0x72, %r8
	.word 0xdea70e40  ! 662: STWA_R	stwa	%r15, [%r28 + %r0] 0x72
	.word 0xdab44400  ! 663: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0xd0bfe000  ! 664: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	mov	0x38, %r19
	.word 0xdcf74e60  ! 666: STXA_R	stxa	%r14, [%r29 + %r0] 0x73
	.word 0xd297a000  ! 667: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r9
	.word 0xd08504a0  ! 668: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r8
	mov	0x78, %r24
	.word 0xd6d584a0  ! 670: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r11
	mov	0x60, %r19
	.word 0xdcafa000  ! 672: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xd6c7ce60  ! 673: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r11
	.word 0xd4afce40  ! 674: STBA_R	stba	%r10, [%r31 + %r0] 0x72
	.word 0x87802074  ! 675: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x30, %r16
	.word 0xd8a649e0  ! 677: STWA_R	stwa	%r12, [%r25 + %r0] 0x4f
	.word 0xdaace000  ! 678: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0x87802020  ! 679: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf46000  ! 680: STXA_I	stxa	%r13, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 681: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdadfce80  ! 682: LDXA_R	ldxa	[%r31, %r0] 0x74, %r13
	.word 0xdac609e0  ! 683: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	.word 0xd2c78e60  ! 684: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r9
	.word 0xdcc584a0  ! 685: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r14
	mov	0x3c8, %r23
	.word 0xdcd7ce40  ! 687: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0xd4f40400  ! 688: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0xd2856000  ! 689: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r9
	.word 0xd0a44400  ! 690: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	mov	0x7e8, %r21
	.word 0xd49da000  ! 692: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r10
	.word 0xd0c78e40  ! 693: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r8
	.word 0x87802020  ! 694: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 695: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd68ec9e0  ! 696: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r11
	.word 0xdcb4a000  ! 697: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0xd68689e0  ! 698: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r11
	.word 0xd8aca000  ! 699: STBA_I	stba	%r12, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 700: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd48f4e80  ! 701: LDUBA_R	lduba	[%r29, %r0] 0x74, %r10
	mov	0x3d0, %r21
	.word 0xdcc609e0  ! 703: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r14
	.word 0xd4d72000  ! 704: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r10
	.word 0xd4f72000  ! 705: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4a76000  ! 706: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xdaf74e80  ! 707: STXA_R	stxa	%r13, [%r29 + %r0] 0x74
	.word 0xd4a76000  ! 708: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 709: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x18, %r18
	.word 0xd4d76000  ! 711: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd486c9e0  ! 712: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	mov	0x40, %r25
	.word 0xd6bf0e80  ! 714: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	.word 0xdcb7a000  ! 715: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 716: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcf4e000  ! 717: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x58, %r17
	mov	0x60, %r25
	.word 0xdcf4a000  ! 720: STXA_I	stxa	%r14, [%r18 + 0x0000] %asi
	.word 0xdcace000  ! 721: STBA_I	stba	%r14, [%r19 + 0x0000] %asi
	.word 0xda9f8e80  ! 722: LDDA_R	ldda	[%r30, %r0] 0x74, %r13
	.word 0xdad46000  ! 723: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r13
	.word 0xda8ca000  ! 724: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r13
	.word 0x87802073  ! 725: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88f4e40  ! 726: LDUBA_R	lduba	[%r29, %r0] 0x72, %r12
	mov	0x10, %r17
	.word 0xd6952000  ! 728: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r11
	.word 0xd6dde000  ! 729: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6d56000  ! 730: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r11
	.word 0xd0b6c9e0  ! 731: STHA_R	stha	%r8, [%r27 + %r0] 0x4f
	.word 0xd0a6c9e0  ! 732: STWA_R	stwa	%r8, [%r27 + %r0] 0x4f
	.word 0xd8b584a0  ! 733: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 734: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde9ec9e0  ! 735: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0xdcbc6000  ! 736: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdc8c2000  ! 737: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0x87802025  ! 738: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x68, %r17
	.word 0xd0b40400  ! 740: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xde956000  ! 741: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r15
	.word 0xde952000  ! 742: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r15
	.word 0xdebd2000  ! 743: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	mov	0x3d0, %r23
	.word 0xdec5a000  ! 745: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r15
	mov	0x7f8, %r20
	.word 0x87802073  ! 747: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x30, %r26
	.word 0xdc978e60  ! 749: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	mov	0x68, %r26
	.word 0xdebd6000  ! 751: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xdebd2000  ! 752: STDA_I	stda	%r15, [%r20 + 0x0000] %asi
	.word 0x8780204f  ! 753: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8bf8e60  ! 754: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	mov	0x3c0, %r22
	.word 0xdeafa000  ! 756: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xdea7e000  ! 757: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xde87e000  ! 758: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdef7e000  ! 759: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	.word 0xd4f74e80  ! 760: STXA_R	stxa	%r10, [%r29 + %r0] 0x74
	.word 0xd8afa000  ! 761: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0x87802020  ! 762: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88da000  ! 763: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r12
	.word 0xd2a78e80  ! 764: STWA_R	stwa	%r9, [%r30 + %r0] 0x74
	mov	0x18, %r24
	mov	0x0, %r16
	mov	0x20, %r18
	.word 0xd8ae89e0  ! 768: STBA_R	stba	%r12, [%r26 + %r0] 0x4f
	.word 0xd6bda000  ! 769: STDA_I	stda	%r11, [%r22 + 0x0000] %asi
	mov	0x7c8, %r20
	mov	0x8, %r17
	.word 0xd8874e60  ! 772: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r12
	.word 0xd0d70e40  ! 773: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0x87802074  ! 774: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeac8400  ! 775: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0xd8b46000  ! 776: STHA_I	stha	%r12, [%r17 + 0x0000] %asi
	.word 0xdaad04a0  ! 777: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	.word 0xd2ac2000  ! 778: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0x8780204f  ! 779: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0cc8400  ! 780: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r8
	.word 0xd4bfe000  ! 781: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xda9f0e80  ! 782: LDDA_R	ldda	[%r28, %r0] 0x74, %r13
	.word 0xd8a689e0  ! 783: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0xd0f44400  ! 784: STXA_R	stxa	%r8, [%r17 + %r0] 0x20
	mov	0x0, %r24
	.word 0xd89ec9e0  ! 786: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0xd8cf4e80  ! 787: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r12
	.word 0xdca7e000  ! 788: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xdcbfce60  ! 789: STDA_R	stda	%r14, [%r31 + %r0] 0x73
	.word 0xd4a76000  ! 790: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xdabf4e80  ! 791: STDA_R	stda	%r13, [%r29 + %r0] 0x74
	.word 0xde8fe000  ! 792: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 793: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 794: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdef66000  ! 795: STXA_I	stxa	%r15, [%r25 + 0x0000] %asi
	.word 0xdcf7ce60  ! 796: STXA_R	stxa	%r14, [%r31 + %r0] 0x73
	.word 0xdcb62000  ! 797: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 798: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd897ce40  ! 799: LDUHA_R	lduha	[%r31, %r0] 0x72, %r12
	mov	0x28, %r25
	mov	0x3e0, %r23
	.word 0xdcdc2000  ! 802: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r14
	.word 0xd6b6c9e0  ! 803: STHA_R	stha	%r11, [%r27 + %r0] 0x4f
	.word 0xd4f42000  ! 804: STXA_I	stxa	%r10, [%r16 + 0x0000] %asi
	mov	0x68, %r26
	mov	0x58, %r24
	.word 0xd2978e40  ! 807: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	mov	0x18, %r25
	mov	0x3c8, %r20
	.word 0xdcb5c4a0  ! 810: STHA_R	stha	%r14, [%r23 + %r0] 0x25
	.word 0xd4a609e0  ! 811: STWA_R	stwa	%r10, [%r24 + %r0] 0x4f
	mov	0x20, %r18
	.word 0xda940400  ! 813: LDUHA_R	lduha	[%r16, %r0] 0x20, %r13
	.word 0xd2f4e000  ! 814: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0xd2f4e000  ! 815: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	.word 0x87802074  ! 816: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0dcc400  ! 817: LDXA_R	ldxa	[%r19, %r0] 0x20, %r8
	.word 0xd0cee000  ! 818: LDSBA_I	ldsba	[%r27, + 0x0000] %asi, %r8
	.word 0xd0f6e000  ! 819: STXA_I	stxa	%r8, [%r27 + 0x0000] %asi
	.word 0xd096e000  ! 820: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r8
	.word 0x87802072  ! 821: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0aca000  ! 822: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd0f4a000  ! 823: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xd0f4e000  ! 824: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	.word 0xd094e000  ! 825: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0dd84a0  ! 826: LDXA_R	ldxa	[%r22, %r0] 0x25, %r8
	mov	0x8, %r18
	mov	0x78, %r17
	.word 0xd8d4e000  ! 829: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r12
	mov	0x50, %r24
	.word 0x87802025  ! 831: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x3e8, %r22
	.word 0xd8d6c9e0  ! 833: LDSHA_R	ldsha	[%r27, %r0] 0x4f, %r12
	.word 0xdadf6000  ! 834: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r13
	.word 0xdac78e80  ! 835: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r13
	mov	0x28, %r17
	.word 0xd2bdc4a0  ! 837: STDA_R	stda	%r9, [%r23 + %r0] 0x25
	.word 0xd4df2000  ! 838: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r10
	.word 0xd69504a0  ! 839: LDUHA_R	lduha	[%r20, %r0] 0x25, %r11
	mov	0x3c8, %r23
	mov	0x10, %r24
	.word 0xd4af2000  ! 842: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0x8780204f  ! 843: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcdc4400  ! 844: LDXA_R	ldxa	[%r17, %r0] 0x20, %r14
	mov	0x30, %r16
	mov	0x50, %r18
	.word 0xd6ac6000  ! 847: STBA_I	stba	%r11, [%r17 + 0x0000] %asi
	.word 0xd6a46000  ! 848: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0x87802074  ! 849: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6962000  ! 850: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	.word 0x87802073  ! 851: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bf2000  ! 852: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x8, %r16
	.word 0xd8b78e60  ! 854: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	mov	0x28, %r18
	.word 0xdad72000  ! 856: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0x87802020  ! 857: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 858: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68fce60  ! 859: LDUBA_R	lduba	[%r31, %r0] 0x73, %r11
	.word 0xd0a7ce80  ! 860: STWA_R	stwa	%r8, [%r31 + %r0] 0x74
	.word 0xd8df6000  ! 861: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0x87802020  ! 862: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f7e000  ! 863: STXA_I	stxa	%r12, [%r31 + 0x0000] %asi
	.word 0xd4b74e40  ! 864: STHA_R	stha	%r10, [%r29 + %r0] 0x72
	mov	0x50, %r19
	.word 0xd49fe000  ! 866: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	mov	0x0, %r17
	.word 0x87802073  ! 868: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdade89e0  ! 869: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r13
	.word 0xd0a504a0  ! 870: STWA_R	stwa	%r8, [%r20 + %r0] 0x25
	.word 0xd6cf2000  ! 871: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 872: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6c46000  ! 873: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r11
	mov	0x8, %r18
	mov	0x7e0, %r23
	mov	0x3f0, %r21
	.word 0xd4b504a0  ! 877: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xd4bce000  ! 878: STDA_I	stda	%r10, [%r19 + 0x0000] %asi
	.word 0xd4f4e000  ! 879: STXA_I	stxa	%r10, [%r19 + 0x0000] %asi
	.word 0xd49ca000  ! 880: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r10
	.word 0xd4a4e000  ! 881: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xdeb70e40  ! 882: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0x87802072  ! 883: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xded7a000  ! 884: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	mov	0x3c0, %r20
	.word 0xde9f2000  ! 886: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r15
	.word 0xdeb7a000  ! 887: STHA_I	stha	%r15, [%r30 + 0x0000] %asi
	.word 0xdecf6000  ! 888: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xdab70e80  ! 889: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	.word 0x87802020  ! 890: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 891: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcd7ce40  ! 892: LDSHA_R	ldsha	[%r31, %r0] 0x72, %r14
	.word 0xd2b4e000  ! 893: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xdca504a0  ! 894: STWA_R	stwa	%r14, [%r20 + %r0] 0x25
	.word 0xd4b4a000  ! 895: STHA_I	stha	%r10, [%r18 + 0x0000] %asi
	.word 0xd4dca000  ! 896: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r10
	mov	0x10, %r19
	.word 0xd4d46000  ! 898: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r10
	.word 0xd09dc4a0  ! 899: LDDA_R	ldda	[%r23, %r0] 0x25, %r8
	.word 0xd6b74e40  ! 900: STHA_R	stha	%r11, [%r29 + %r0] 0x72
	.word 0xd4dc0400  ! 901: LDXA_R	ldxa	[%r16, %r0] 0x20, %r10
	.word 0xd69ca000  ! 902: LDDA_I	ldda	[%r18, + 0x0000] %asi, %r11
	.word 0xd6a42000  ! 903: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 904: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 905: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3f0, %r21
	.word 0xd6b6a000  ! 907: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0xd6a649e0  ! 908: STWA_R	stwa	%r11, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 909: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda872000  ! 910: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0xd6af4e40  ! 911: STBA_R	stba	%r11, [%r29 + %r0] 0x72
	.word 0x87802020  ! 912: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r24
	.word 0xdc8ce000  ! 914: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r14
	.word 0xdca74e40  ! 915: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xd4c42000  ! 916: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r10
	.word 0xd6cf8e80  ! 917: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r11
	.word 0xd6af4e60  ! 918: STBA_R	stba	%r11, [%r29 + %r0] 0x73
	.word 0xdec44400  ! 919: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0xd8f46000  ! 920: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd89c6000  ! 921: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r12
	mov	0x3f8, %r20
	.word 0xd8bc2000  ! 923: STDA_I	stda	%r12, [%r16 + 0x0000] %asi
	.word 0xd8ac6000  ! 924: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	mov	0x20, %r17
	.word 0xd8b42000  ! 926: STHA_I	stha	%r12, [%r16 + 0x0000] %asi
	.word 0x87802074  ! 927: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8d76000  ! 928: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8c72000  ! 929: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8dfe000  ! 930: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	mov	0x3c0, %r21
	.word 0xdcf44400  ! 932: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	.word 0xdabf6000  ! 933: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 934: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0a4c400  ! 935: STWA_R	stwa	%r8, [%r19 + %r0] 0x20
	.word 0xdebf4e80  ! 936: STDA_R	stda	%r15, [%r29 + %r0] 0x74
	mov	0x10, %r18
	.word 0x87802020  ! 938: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f0e80  ! 939: LDDA_R	ldda	[%r28, %r0] 0x74, %r11
	mov	0x58, %r18
	.word 0xdcbf4e40  ! 941: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xd8bda000  ! 942: STDA_I	stda	%r12, [%r22 + 0x0000] %asi
	.word 0xda8504a0  ! 943: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r13
	.word 0xd0dd6000  ! 944: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0d56000  ! 945: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0xd0d56000  ! 946: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r8
	.word 0xd0a5e000  ! 947: STWA_I	stwa	%r8, [%r23 + 0x0000] %asi
	mov	0x28, %r27
	.word 0xd09da000  ! 949: LDDA_I	ldda	[%r22, + 0x0000] %asi, %r8
	.word 0xd08d6000  ! 950: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r8
	mov	0x7c8, %r21
	.word 0xd28544a0  ! 952: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r9
	.word 0x87802072  ! 953: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdacfce60  ! 954: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r13
	.word 0xd2b7a000  ! 955: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 956: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 957: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca584a0  ! 958: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	.word 0xd6b689e0  ! 959: STHA_R	stha	%r11, [%r26 + %r0] 0x4f
	.word 0xdabc6000  ! 960: STDA_I	stda	%r13, [%r17 + 0x0000] %asi
	.word 0xd8df0e40  ! 961: LDXA_R	ldxa	[%r28, %r0] 0x72, %r12
	mov	0x38, %r25
	.word 0x8780204f  ! 963: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x50, %r18
	.word 0xd0dd6000  ! 965: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0956000  ! 966: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r8
	.word 0xdeb78e80  ! 967: STHA_R	stha	%r15, [%r30 + %r0] 0x74
	.word 0x8780204f  ! 968: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7c8, %r21
	.word 0xd2d48400  ! 970: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd09fce40  ! 971: LDDA_R	ldda	[%r31, %r0] 0x72, %r8
	.word 0xd4876000  ! 972: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd69d44a0  ! 973: LDDA_R	ldda	[%r21, %r0] 0x25, %r11
	.word 0xd087ce40  ! 974: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r8
	.word 0xd09f8e40  ! 975: LDDA_R	ldda	[%r30, %r0] 0x72, %r8
	.word 0xd0cf0e40  ! 976: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r8
	.word 0xd2b649e0  ! 977: STHA_R	stha	%r9, [%r25 + %r0] 0x4f
	.word 0xdaa48400  ! 978: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0xd8ae49e0  ! 979: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd2bf2000  ! 980: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xdaaf8e60  ! 981: STBA_R	stba	%r13, [%r30 + %r0] 0x73
	.word 0x87802073  ! 982: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bf6000  ! 983: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0xd6cf2000  ! 984: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xd6bf2000  ! 985: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	mov	0x0, %r25
	.word 0x8780204f  ! 987: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab70e80  ! 988: STHA_R	stha	%r13, [%r28 + %r0] 0x74
	.word 0xdcc46000  ! 989: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r14
	.word 0x87802020  ! 990: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7f8, %r20
	mov	0x7f8, %r23
	.word 0xdcb56000  ! 993: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0xd29fce40  ! 994: LDDA_R	ldda	[%r31, %r0] 0x72, %r9
	mov	0x78, %r18
	mov	0x7f0, %r21
	mov	0x7e8, %r22
	.word 0x87802072  ! 998: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaf584a0  ! 999: STXA_R	stxa	%r13, [%r22 + %r0] 0x25
	.word 0xd0c56000  ! 1000: LDSWA_I	ldswa	[%r21, + 0x0000] %asi, %r8
	.word 0xd085e000  ! 1001: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r8
	.word 0x87802074  ! 1002: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd08e6000  ! 1003: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r8
	.word 0xdcdd44a0  ! 1004: LDXA_R	ldxa	[%r21, %r0] 0x25, %r14
	mov	0x7c8, %r22
	.word 0xd4aea000  ! 1006: STBA_I	stba	%r10, [%r26 + 0x0000] %asi
	.word 0xd6dc0400  ! 1007: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0xd4f48400  ! 1008: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xdcaea000  ! 1009: STBA_I	stba	%r14, [%r26 + 0x0000] %asi
	.word 0xdcf6a000  ! 1010: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	.word 0xdcae2000  ! 1011: STBA_I	stba	%r14, [%r24 + 0x0000] %asi
	.word 0xd8dc8400  ! 1012: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	mov	0x3e8, %r20
	.word 0xd8866000  ! 1014: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	.word 0xde95c4a0  ! 1015: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	mov	0x68, %r18
	mov	0x28, %r25
	.word 0x87802072  ! 1018: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6874e80  ! 1019: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r11
	.word 0xd68c6000  ! 1020: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	.word 0xdaad84a0  ! 1021: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	mov	0x78, %r24
	.word 0xdec4a000  ! 1023: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xd0cf0e60  ! 1024: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r8
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 1026: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c7a000  ! 1027: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xdca78e60  ! 1028: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0x87802074  ! 1029: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdec40400  ! 1030: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xd69cc400  ! 1031: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	.word 0xdad56000  ! 1032: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1033: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xde8c4400  ! 1034: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	mov	0x20, %r24
	mov	0x78, %r19
	.word 0xd2942000  ! 1037: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xdeae89e0  ! 1038: STBA_R	stba	%r15, [%r26 + %r0] 0x4f
	.word 0xd8bce000  ! 1039: STDA_I	stda	%r12, [%r19 + 0x0000] %asi
	.word 0xd8c4e000  ! 1040: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r12
	mov	0x48, %r19
	.word 0x87802073  ! 1042: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd886e000  ! 1043: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	mov	0x68, %r19
	.word 0xd8aee000  ! 1045: STBA_I	stba	%r12, [%r27 + 0x0000] %asi
	.word 0xd8844400  ! 1046: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r12
	.word 0xd4c689e0  ! 1047: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r10
	.word 0xd6bea000  ! 1048: STDA_I	stda	%r11, [%r26 + 0x0000] %asi
	mov	0x0, %r18
	.word 0xd0bf4e40  ! 1050: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	.word 0x87802074  ! 1051: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x50, %r18
	.word 0xd4d44400  ! 1053: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r10
	.word 0x87802025  ! 1054: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4df4e40  ! 1055: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0x8780204f  ! 1056: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcc4c400  ! 1057: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r14
	.word 0xd8c42000  ! 1058: LDSWA_I	ldswa	[%r16, + 0x0000] %asi, %r12
	mov	0x30, %r24
	mov	0x3e0, %r20
	ta	T_CHANGE_PRIV	! macro
	.word 0xdedc4400  ! 1062: LDXA_R	ldxa	[%r17, %r0] 0x20, %r15
	.word 0xd2ac2000  ! 1063: STBA_I	stba	%r9, [%r16 + 0x0000] %asi
	.word 0xd28c6000  ! 1064: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r9
	.word 0xd4c7ce40  ! 1065: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r10
	mov	0x78, %r16
	.word 0xd6ace000  ! 1067: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0x87802072  ! 1068: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r24
	.word 0xd696a000  ! 1070: LDUHA_I	lduha	[%r26, + 0x0000] %asi, %r11
	.word 0xd6be2000  ! 1071: STDA_I	stda	%r11, [%r24 + 0x0000] %asi
	mov	0x58, %r16
	.word 0xd8bd84a0  ! 1073: STDA_R	stda	%r12, [%r22 + %r0] 0x25
	.word 0xd6ce2000  ! 1074: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r11
	.word 0xd6b48400  ! 1075: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	.word 0xdadfce60  ! 1076: LDXA_R	ldxa	[%r31, %r0] 0x73, %r13
	.word 0xd0d66000  ! 1077: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r8
	mov	0x70, %r18
	.word 0xdc9544a0  ! 1079: LDUHA_R	lduha	[%r21, %r0] 0x25, %r14
	.word 0x87802020  ! 1080: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f76000  ! 1081: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4bfe000  ! 1082: STDA_I	stda	%r10, [%r31 + 0x0000] %asi
	.word 0xdeacc400  ! 1083: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xda9f6000  ! 1084: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdaa7ce40  ! 1085: STWA_R	stwa	%r13, [%r31 + %r0] 0x72
	mov	0x18, %r26
	.word 0x87802073  ! 1087: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3c8, %r22
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd2be2000  ! 1090: STDA_I	stda	%r9, [%r24 + 0x0000] %asi
	.word 0xd2de6000  ! 1091: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r9
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd8dcc400  ! 1093: LDXA_R	ldxa	[%r19, %r0] 0x20, %r12
	.word 0xdc86e000  ! 1094: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r14
	.word 0xdcb62000  ! 1095: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xdcd6a000  ! 1096: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r14
	.word 0xdcbea000  ! 1097: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	.word 0xd4df4e40  ! 1098: LDXA_R	ldxa	[%r29, %r0] 0x72, %r10
	.word 0xd8b74e60  ! 1099: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xdaf40400  ! 1100: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xda8584a0  ! 1101: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r13
	.word 0xd4dc4400  ! 1102: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0xda8cc400  ! 1103: LDUBA_R	lduba	[%r19, %r0] 0x20, %r13
	.word 0xdcb6e000  ! 1104: STHA_I	stha	%r14, [%r27 + 0x0000] %asi
	.word 0xdc8e6000  ! 1105: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r14
	mov	0x30, %r26
	.word 0xd4df0e40  ! 1107: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0xdabe6000  ! 1108: STDA_I	stda	%r13, [%r25 + 0x0000] %asi
	.word 0xde9c8400  ! 1109: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	mov	0x48, %r17
	.word 0xd4d78e80  ! 1111: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0xd0cec9e0  ! 1112: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r8
	.word 0xd8ce2000  ! 1113: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r12
	.word 0xd89ea000  ! 1114: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	.word 0x87802025  ! 1115: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd897ce80  ! 1116: LDUHA_R	lduha	[%r31, %r0] 0x74, %r12
	.word 0xd4bf6000  ! 1117: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd49fe000  ! 1118: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0xd6a584a0  ! 1119: STWA_R	stwa	%r11, [%r22 + %r0] 0x25
	mov	0x38, %r19
	mov	0x3d0, %r22
	.word 0xd4876000  ! 1122: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd48fce60  ! 1123: LDUBA_R	lduba	[%r31, %r0] 0x73, %r10
	.word 0xdc97a000  ! 1124: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r14
	.word 0xdc976000  ! 1125: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r14
	mov	0x3c8, %r22
	.word 0xdcb78e60  ! 1127: STHA_R	stha	%r14, [%r30 + %r0] 0x73
	.word 0xd4c6c9e0  ! 1128: LDSWA_R	ldswa	[%r27, %r0] 0x4f, %r10
	.word 0xd8b74e40  ! 1129: STHA_R	stha	%r12, [%r29 + %r0] 0x72
	mov	0x68, %r19
	mov	0x20, %r18
	.word 0xde8fe000  ! 1132: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0xd2bc4400  ! 1133: STDA_R	stda	%r9, [%r17 + %r0] 0x20
	.word 0xdec76000  ! 1134: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd6b7ce40  ! 1135: STHA_R	stha	%r11, [%r31 + %r0] 0x72
	.word 0xdeaf2000  ! 1136: STBA_I	stba	%r15, [%r28 + 0x0000] %asi
	.word 0xdef6c9e0  ! 1137: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 1138: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 1139: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6a7a000  ! 1140: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd68f6000  ! 1142: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r11
	mov	0x28, %r18
	.word 0xd6bf2000  ! 1144: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xd6df6000  ! 1145: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6f72000  ! 1146: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xdac609e0  ! 1147: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r13
	.word 0xd8b7a000  ! 1148: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd484c400  ! 1149: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r10
	.word 0xd8d76000  ! 1150: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8af2000  ! 1151: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x30, %r19
	.word 0xd8a76000  ! 1153: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xd8c7e000  ! 1154: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8bfe000  ! 1155: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xdc9f0e80  ! 1156: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xd8f6c9e0  ! 1157: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0x8780204f  ! 1158: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8d42000  ! 1159: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0x87802020  ! 1160: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dfa000  ! 1161: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r12
	.word 0xd0f48400  ! 1162: STXA_R	stxa	%r8, [%r18 + %r0] 0x20
	.word 0xdab76000  ! 1163: STHA_I	stha	%r13, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 1164: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r23
	mov	0x60, %r26
	.word 0xdabfa000  ! 1167: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xda9d04a0  ! 1169: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	.word 0x87802074  ! 1170: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd684a000  ! 1171: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6bca000  ! 1172: STDA_I	stda	%r11, [%r18 + 0x0000] %asi
	.word 0xd6b42000  ! 1173: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd6a4a000  ! 1174: STWA_I	stwa	%r11, [%r18 + 0x0000] %asi
	mov	0x3d8, %r23
	.word 0xdaf48400  ! 1176: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xd0a4a000  ! 1177: STWA_I	stwa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802073  ! 1178: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd08c2000  ! 1179: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0xd0f4e000  ! 1180: STXA_I	stxa	%r8, [%r19 + 0x0000] %asi
	mov	0x40, %r25
	mov	0x58, %r19
	.word 0x87802074  ! 1183: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 1184: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc8544a0  ! 1185: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r14
	.word 0xdc978e40  ! 1186: LDUHA_R	lduha	[%r30, %r0] 0x72, %r14
	.word 0xd6b66000  ! 1187: STHA_I	stha	%r11, [%r25 + 0x0000] %asi
	.word 0xda8f4e40  ! 1188: LDUBA_R	lduba	[%r29, %r0] 0x72, %r13
	mov	0x18, %r27
	.word 0xd4acc400  ! 1190: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xdcdf8e40  ! 1191: LDXA_R	ldxa	[%r30, %r0] 0x72, %r14
	.word 0xdab62000  ! 1192: STHA_I	stha	%r13, [%r24 + 0x0000] %asi
	.word 0x87802020  ! 1193: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e0, %r22
	.word 0xd0cc0400  ! 1195: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r8
	mov	0x7f8, %r22
	.word 0x87802020  ! 1197: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca584a0  ! 1198: STWA_R	stwa	%r14, [%r22 + %r0] 0x25
	mov	0x30, %r19
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802072  ! 1201: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0a4e000  ! 1202: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd0c4a000  ! 1203: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0cc6000  ! 1204: LDSBA_I	ldsba	[%r17, + 0x0000] %asi, %r8
	mov	0x3f0, %r22
	.word 0xd094a000  ! 1206: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r8
	.word 0xd88e09e0  ! 1207: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r12
	.word 0xdef70e80  ! 1208: STXA_R	stxa	%r15, [%r28 + %r0] 0x74
	mov	0x48, %r26
	mov	0x7c0, %r21
	.word 0x87802072  ! 1211: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8adc4a0  ! 1212: STBA_R	stba	%r12, [%r23 + %r0] 0x25
	.word 0xd8bfe000  ! 1213: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd6cfce40  ! 1214: LDSBA_R	ldsba	[%r31, %r0] 0x72, %r11
	.word 0xd2d70e80  ! 1215: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r9
	.word 0xd4afe000  ! 1216: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0xd6a40400  ! 1217: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	.word 0xd6bc8400  ! 1218: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	.word 0xde8fe000  ! 1220: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r15
	.word 0x87802025  ! 1221: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef5e000  ! 1222: STXA_I	stxa	%r15, [%r23 + 0x0000] %asi
	.word 0x8780204f  ! 1223: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde846000  ! 1224: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r15
	mov	0x10, %r16
	.word 0x87802072  ! 1226: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x68, %r25
	mov	0x28, %r27
	mov	0x30, %r16
	.word 0xdc8c4400  ! 1230: LDUBA_R	lduba	[%r17, %r0] 0x20, %r14
	.word 0xdca7e000  ! 1231: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	.word 0xd0f7ce40  ! 1232: STXA_R	stxa	%r8, [%r31 + %r0] 0x72
	.word 0x87802025  ! 1233: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1234: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbf6000  ! 1235: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xd2ac0400  ! 1236: STBA_R	stba	%r9, [%r16 + %r0] 0x20
	.word 0x87802072  ! 1237: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4be49e0  ! 1238: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	mov	0x30, %r16
	.word 0x8780204f  ! 1240: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6d4a000  ! 1241: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0xd2f70e60  ! 1242: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	mov	0x3f0, %r23
	.word 0xd0f4a000  ! 1244: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802074  ! 1245: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0972000  ! 1246: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r8
	.word 0xd486c9e0  ! 1247: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r10
	.word 0xde9fe000  ! 1248: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0xde8fa000  ! 1249: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r15
	.word 0x87802074  ! 1250: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r18
	mov	0x20, %r17
	.word 0x87802020  ! 1253: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdadf0e40  ! 1254: LDXA_R	ldxa	[%r28, %r0] 0x72, %r13
	mov	0x0, %r19
	ta	T_CHANGE_HPRIV	! macro
	mov	0x0, %r24
	.word 0xde9d04a0  ! 1258: LDDA_R	ldda	[%r20, %r0] 0x25, %r15
	.word 0xd2afa000  ! 1259: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x58, %r16
	mov	0x30, %r26
	mov	0x3d8, %r23
	.word 0xd2bf6000  ! 1263: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	.word 0xd2b7e000  ! 1264: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd4bfce40  ! 1265: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0xdebd44a0  ! 1266: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	mov	0x7d0, %r23
	.word 0xd8bf2000  ! 1268: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xdcc70e40  ! 1269: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r14
	mov	0x30, %r25
	.word 0xd6bfa000  ! 1271: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	mov	0x70, %r18
	mov	0x8, %r24
	mov	0x7d8, %r20
	mov	0x8, %r24
	.word 0xd2d74e60  ! 1276: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xd69fa000  ! 1277: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r11
	.word 0x87802072  ! 1278: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f76000  ! 1279: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 1280: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1281: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6bc2000  ! 1282: STDA_I	stda	%r11, [%r16 + 0x0000] %asi
	.word 0x87802073  ! 1283: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd884c400  ! 1284: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	mov	0x60, %r19
	.word 0x87802073  ! 1286: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4bf2000  ! 1287: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	.word 0xd497a000  ! 1288: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r10
	.word 0xde844400  ! 1289: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	.word 0xd4bf2000  ! 1290: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x8, %r16
	.word 0x8780204f  ! 1292: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd49fe000  ! 1293: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1294: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4b70e40  ! 1295: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xdcf5a000  ! 1296: STXA_I	stxa	%r14, [%r22 + 0x0000] %asi
	.word 0x87802073  ! 1297: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcad44a0  ! 1298: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	.word 0xd8ac0400  ! 1299: STBA_R	stba	%r12, [%r16 + %r0] 0x20
	.word 0xd6c52000  ! 1300: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r11
	.word 0xdef44400  ! 1301: STXA_R	stxa	%r15, [%r17 + %r0] 0x20
	mov	0x30, %r19
	.word 0xd4f56000  ! 1303: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 1304: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6cf0e60  ! 1305: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r11
	.word 0xde97a000  ! 1306: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r15
	mov	0x7c0, %r22
	mov	0x70, %r16
	.word 0xd0aec9e0  ! 1309: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0xdef7e000  ! 1310: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x3f8, %r20
	mov	0x3d0, %r23
	.word 0xdea76000  ! 1313: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xdcc504a0  ! 1314: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r14
	.word 0xdaa40400  ! 1315: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xd6bf2000  ! 1316: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0xde8cc400  ! 1317: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	mov	0x28, %r18
	.word 0x87802072  ! 1319: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 1320: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdedf2000  ! 1321: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	mov	0x3c0, %r22
	.word 0xd89c4400  ! 1323: LDDA_R	ldda	[%r17, %r0] 0x20, %r12
	.word 0xd4f74e60  ! 1324: STXA_R	stxa	%r10, [%r29 + %r0] 0x73
	ta	T_CHANGE_PRIV	! macro
	.word 0xd4aec9e0  ! 1326: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xd0a76000  ! 1327: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd4d78e80  ! 1328: LDSHA_R	ldsha	[%r30, %r0] 0x74, %r10
	.word 0xdcb7e000  ! 1329: STHA_I	stha	%r14, [%r31 + 0x0000] %asi
	.word 0xdef649e0  ! 1330: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0xd88f2000  ! 1331: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xdcd78e60  ! 1332: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r14
	mov	0x18, %r18
	.word 0xdedfe000  ! 1334: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1335: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdef72000  ! 1336: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd88c4400  ! 1337: LDUBA_R	lduba	[%r17, %r0] 0x20, %r12
	.word 0xd2ad04a0  ! 1338: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xd68fce80  ! 1339: LDUBA_R	lduba	[%r31, %r0] 0x74, %r11
	mov	0x0, %r27
	.word 0x87802072  ! 1341: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xde84a000  ! 1342: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r15
	mov	0x50, %r17
	mov	0x28, %r18
	.word 0xdea42000  ! 1345: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0xdecc2000  ! 1346: LDSBA_I	ldsba	[%r16, + 0x0000] %asi, %r15
	mov	0x3f8, %r21
	mov	0x70, %r17
	mov	0x7c8, %r21
	.word 0xd48609e0  ! 1350: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r10
	.word 0xd0f4a000  ! 1351: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 1352: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r24
	.word 0x87802025  ! 1354: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r19
	.word 0xdcbe09e0  ! 1356: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0x87802074  ! 1357: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a70e80  ! 1358: STWA_R	stwa	%r11, [%r28 + %r0] 0x74
	mov	0x30, %r19
	.word 0x87802073  ! 1360: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b56000  ! 1361: STHA_I	stha	%r9, [%r21 + 0x0000] %asi
	mov	0x70, %r19
	.word 0x87802020  ! 1363: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x68, %r17
	.word 0xd29f6000  ! 1365: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0x87802074  ! 1366: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2f7e000  ! 1367: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 1368: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1369: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7f0, %r22
	.word 0xd29f2000  ! 1371: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	.word 0xdcd40400  ! 1372: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xdcc78e40  ! 1373: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r14
	.word 0xdadc0400  ! 1374: LDXA_R	ldxa	[%r16, %r0] 0x20, %r13
	.word 0x87802020  ! 1375: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0acc400  ! 1376: STBA_R	stba	%r8, [%r19 + %r0] 0x20
	.word 0xd08f2000  ! 1377: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd29f8e40  ! 1378: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	.word 0xdadf8e60  ! 1379: LDXA_R	ldxa	[%r30, %r0] 0x73, %r13
	.word 0xd8bfe000  ! 1380: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd6a40400  ! 1381: STWA_R	stwa	%r11, [%r16 + %r0] 0x20
	mov	0x7c0, %r23
	.word 0xd29fe000  ! 1383: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd29f6000  ! 1384: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r9
	.word 0xd2dfa000  ! 1385: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	mov	0x40, %r18
	.word 0xd297e000  ! 1387: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r9
	.word 0xd2bfa000  ! 1388: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	.word 0xd2f76000  ! 1389: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	mov	0x50, %r18
	mov	0x30, %r26
	mov	0x78, %r18
	.word 0x87802072  ! 1393: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2d7a000  ! 1394: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r9
	mov	0x58, %r17
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd2bfa000  ! 1397: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x28, %r18
	.word 0xd2f7e000  ! 1399: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xdeb74e80  ! 1400: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xd8bc8400  ! 1401: STDA_R	stda	%r12, [%r18 + %r0] 0x20
	mov	0x28, %r17
	mov	0x0, %r24
	.word 0xd6bfa000  ! 1404: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	.word 0xd0f4c400  ! 1405: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xd2d44400  ! 1406: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r9
	.word 0xdecc4400  ! 1407: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r15
	.word 0xd2872000  ! 1408: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r9
	.word 0xd2af2000  ! 1409: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd28f6000  ! 1410: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 1411: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2bce000  ! 1412: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0xdcaf8e60  ! 1413: STBA_R	stba	%r14, [%r30 + %r0] 0x73
	.word 0xd09e49e0  ! 1414: LDDA_R	ldda	[%r25, %r0] 0x4f, %r8
	.word 0xd89c2000  ! 1415: LDDA_I	ldda	[%r16, + 0x0000] %asi, %r12
	.word 0xd8846000  ! 1416: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8f42000  ! 1417: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xd8d42000  ! 1418: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xd8ac6000  ! 1419: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xd8ac6000  ! 1420: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0xdcb44400  ! 1421: STHA_R	stha	%r14, [%r17 + %r0] 0x20
	mov	0x30, %r17
	.word 0xdabe09e0  ! 1423: STDA_R	stda	%r13, [%r24 + %r0] 0x4f
	.word 0xdab4c400  ! 1424: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xd8b4c400  ! 1425: STHA_R	stha	%r12, [%r19 + %r0] 0x20
	mov	0x7f0, %r23
	.word 0xda944400  ! 1427: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	.word 0xdea689e0  ! 1428: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	mov	0x50, %r26
	.word 0xde8ca000  ! 1430: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r15
	mov	0x20, %r17
	.word 0xd8f70e60  ! 1432: STXA_R	stxa	%r12, [%r28 + %r0] 0x73
	mov	0x7d0, %r23
	.word 0xd8874e40  ! 1434: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r12
	.word 0xd4f40400  ! 1435: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	mov	0x78, %r26
	.word 0xd894a000  ! 1437: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8dca000  ! 1438: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r12
	.word 0xd8cce000  ! 1439: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r12
	.word 0xde840400  ! 1440: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r15
	.word 0xdcc4a000  ! 1441: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	.word 0xdcf4e000  ! 1442: STXA_I	stxa	%r14, [%r19 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0x87802074  ! 1444: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802025  ! 1445: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdef48400  ! 1446: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	mov	0x18, %r18
	.word 0xd2af0e80  ! 1448: STBA_R	stba	%r9, [%r28 + %r0] 0x74
	.word 0x87802074  ! 1449: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd2dc6000  ! 1450: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	mov	0x3c0, %r23
	.word 0x87802073  ! 1452: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdec40400  ! 1453: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r15
	.word 0xdeac2000  ! 1454: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdeb4a000  ! 1455: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	mov	0x48, %r18
	.word 0xde8c6000  ! 1457: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r15
	.word 0x87802020  ! 1458: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd697ce80  ! 1459: LDUHA_R	lduha	[%r31, %r0] 0x74, %r11
	.word 0xde95e000  ! 1460: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r15
	.word 0xd88f8e80  ! 1461: LDUBA_R	lduba	[%r30, %r0] 0x74, %r12
	.word 0xdaf5a000  ! 1462: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	.word 0xda9d6000  ! 1463: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r13
	.word 0xda85e000  ! 1464: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r13
	.word 0xd8cdc4a0  ! 1465: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r12
	mov	0x7e0, %r21
	mov	0x18, %r16
	.word 0x87802073  ! 1468: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 1469: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbf6000  ! 1470: STDA_I	stda	%r14, [%r29 + 0x0000] %asi
	.word 0xdca7a000  ! 1471: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd6c44400  ! 1473: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r11
	mov	0x48, %r16
	.word 0xd69fce40  ! 1475: LDDA_R	ldda	[%r31, %r0] 0x72, %r11
	.word 0xd6bfa000  ! 1476: STDA_I	stda	%r11, [%r30 + 0x0000] %asi
	mov	0x3f8, %r20
	mov	0x38, %r25
	.word 0xd8a7ce80  ! 1479: STWA_R	stwa	%r12, [%r31 + %r0] 0x74
	.word 0xde8f6000  ! 1480: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r15
	mov	0x7e0, %r23
	.word 0xdedfa000  ! 1482: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xd2bd44a0  ! 1483: STDA_R	stda	%r9, [%r21 + %r0] 0x25
	.word 0xdabd84a0  ! 1484: STDA_R	stda	%r13, [%r22 + %r0] 0x25
	mov	0x48, %r27
	mov	0x3d0, %r21
	mov	0x30, %r16
	.word 0xda9f6000  ! 1488: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r13
	.word 0xdc9f4e60  ! 1489: LDDA_R	ldda	[%r29, %r0] 0x73, %r14
	.word 0xdcbc0400  ! 1490: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xd8dd04a0  ! 1491: LDXA_R	ldxa	[%r20, %r0] 0x25, %r12
	mov	0x7c8, %r20
	.word 0xd8acc400  ! 1493: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0xd4b584a0  ! 1494: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0xd8f7a000  ! 1495: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8df2000  ! 1496: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r12
	mov	0x70, %r16
	.word 0x8780204f  ! 1498: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd88d6000  ! 1499: LDUBA_I	lduba	[%r21, + 0x0000] %asi, %r12
	.word 0xd8c5a000  ! 1500: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r12
	.word 0xd8dda000  ! 1501: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r12
	.word 0xd4844400  ! 1502: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r10
	.word 0x87802025  ! 1503: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0970e40  ! 1504: LDUHA_R	lduha	[%r28, %r0] 0x72, %r8
	ta	T_CHANGE_PRIV	! macro
	mov	0x3e8, %r23
	.word 0xda872000  ! 1507: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1508: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda942000  ! 1509: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r13
	.word 0xdabc2000  ! 1510: STDA_I	stda	%r13, [%r16 + 0x0000] %asi
	.word 0xdaaca000  ! 1511: STBA_I	stba	%r13, [%r18 + 0x0000] %asi
	.word 0xdaa42000  ! 1512: STWA_I	stwa	%r13, [%r16 + 0x0000] %asi
	.word 0x87802025  ! 1513: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c78e40  ! 1514: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r12
	.word 0xdaf6c9e0  ! 1515: STXA_R	stxa	%r13, [%r27 + %r0] 0x4f
	.word 0xd8afa000  ! 1516: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd8bf2000  ! 1517: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xd8972000  ! 1518: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r12
	.word 0xd8b76000  ! 1519: STHA_I	stha	%r12, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 1520: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8cca000  ! 1521: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r12
	mov	0x7f8, %r23
	.word 0xd8b4a000  ! 1523: STHA_I	stha	%r12, [%r18 + 0x0000] %asi
	.word 0xd8ac2000  ! 1524: STBA_I	stba	%r12, [%r16 + 0x0000] %asi
	.word 0xd8f42000  ! 1525: STXA_I	stxa	%r12, [%r16 + 0x0000] %asi
	.word 0xdef74e80  ! 1526: STXA_R	stxa	%r15, [%r29 + %r0] 0x74
	.word 0xd0ac6000  ! 1527: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	mov	0x3e0, %r20
	.word 0xd0bca000  ! 1529: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	mov	0x50, %r26
	.word 0xd0ac2000  ! 1531: STBA_I	stba	%r8, [%r16 + 0x0000] %asi
	.word 0xd094e000  ! 1532: LDUHA_I	lduha	[%r19, + 0x0000] %asi, %r8
	.word 0xd0b4a000  ! 1533: STHA_I	stha	%r8, [%r18 + 0x0000] %asi
	.word 0xd0dc6000  ! 1534: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r8
	.word 0xd0bce000  ! 1535: STDA_I	stda	%r8, [%r19 + 0x0000] %asi
	mov	0x3c8, %r21
	mov	0x30, %r26
	.word 0xd2a7ce80  ! 1538: STWA_R	stwa	%r9, [%r31 + %r0] 0x74
	mov	0x60, %r19
	.word 0xd4acc400  ! 1540: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0x87802073  ! 1541: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd89ec9e0  ! 1542: LDDA_R	ldda	[%r27, %r0] 0x4f, %r12
	.word 0xd8cfce80  ! 1543: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r12
	.word 0xd2ade000  ! 1544: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0x87802074  ! 1545: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0c78e80  ! 1546: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r8
	.word 0xd8dc8400  ! 1547: LDXA_R	ldxa	[%r18, %r0] 0x20, %r12
	.word 0xd29d04a0  ! 1548: LDDA_R	ldda	[%r20, %r0] 0x25, %r9
	.word 0x87802072  ! 1549: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdaa72000  ! 1550: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xd8c504a0  ! 1551: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r12
	.word 0xdedf2000  ! 1552: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xded7a000  ! 1553: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0x87802025  ! 1554: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8bf8e80  ! 1555: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0xdaac8400  ! 1556: STBA_R	stba	%r13, [%r18 + %r0] 0x20
	mov	0x0, %r26
	.word 0xda9de000  ! 1558: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r13
	.word 0xdaf5e000  ! 1559: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xd89f4e80  ! 1560: LDDA_R	ldda	[%r29, %r0] 0x74, %r12
	.word 0xdecf0e80  ! 1561: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r15
	.word 0xdac44400  ! 1562: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r13
	mov	0x10, %r16
	.word 0xd8ae09e0  ! 1564: STBA_R	stba	%r12, [%r24 + %r0] 0x4f
	.word 0xd6cd2000  ! 1565: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	.word 0xdad4c400  ! 1566: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xd4d5a000  ! 1567: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r10
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x18, %r27
	.word 0xd4a5a000  ! 1570: STWA_I	stwa	%r10, [%r22 + 0x0000] %asi
	.word 0xdcb70e60  ! 1571: STHA_R	stha	%r14, [%r28 + %r0] 0x73
	.word 0x87802020  ! 1572: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802074  ! 1573: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r21
	mov	0x68, %r26
	.word 0x87802020  ! 1576: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab46000  ! 1577: STHA_I	stha	%r13, [%r17 + 0x0000] %asi
	.word 0xdac4a000  ! 1578: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	mov	0x10, %r16
	mov	0x28, %r17
	mov	0x58, %r17
	.word 0xda84e000  ! 1582: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802074  ! 1583: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8d2000  ! 1584: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r13
	.word 0xd08fce40  ! 1585: LDUBA_R	lduba	[%r31, %r0] 0x72, %r8
	mov	0x7c0, %r21
	.word 0xd8c52000  ! 1587: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r12
	.word 0x87802073  ! 1588: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 1589: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8b7a000  ! 1590: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd8df6000  ! 1591: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r12
	.word 0xd2bf4e40  ! 1592: STDA_R	stda	%r9, [%r29 + %r0] 0x72
	.word 0xd6b72000  ! 1593: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6a72000  ! 1594: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0x87802025  ! 1595: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6a4e000  ! 1596: STWA_I	stwa	%r11, [%r19 + 0x0000] %asi
	mov	0x38, %r24
	.word 0xd8cf0e60  ! 1598: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r12
	.word 0xd4ac0400  ! 1599: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802020  ! 1601: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0844400  ! 1602: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xd28d84a0  ! 1603: LDUBA_R	lduba	[%r22, %r0] 0x25, %r9
	.word 0xd2d74e60  ! 1604: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xd4dcc400  ! 1605: LDXA_R	ldxa	[%r19, %r0] 0x20, %r10
	.word 0xdc84a000  ! 1606: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x68, %r16
	mov	0x60, %r17
	.word 0xdeacc400  ! 1609: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	mov	0x10, %r18
	.word 0xdeb70e40  ! 1611: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xdc9f4e60  ! 1612: LDDA_R	ldda	[%r29, %r0] 0x73, %r14
	.word 0xd6ae09e0  ! 1613: STBA_R	stba	%r11, [%r24 + %r0] 0x4f
	.word 0x87802020  ! 1614: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x28, %r16
	.word 0xdcbc6000  ! 1616: STDA_I	stda	%r14, [%r17 + 0x0000] %asi
	.word 0xdca78e40  ! 1617: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xdcf42000  ! 1618: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0xd2d74e60  ! 1619: LDSHA_R	ldsha	[%r29, %r0] 0x73, %r9
	.word 0xdcb46000  ! 1620: STHA_I	stha	%r14, [%r17 + 0x0000] %asi
	.word 0xdca4e000  ! 1621: STWA_I	stwa	%r14, [%r19 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xdc84a000  ! 1623: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r14
	mov	0x50, %r26
	.word 0x8780204f  ! 1625: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcce2000  ! 1626: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r14
	mov	0x7f0, %r20
	mov	0x7c8, %r23
	.word 0x87802020  ! 1629: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcce6000  ! 1630: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	.word 0xdc874e40  ! 1631: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r14
	.word 0xd4bf8e60  ! 1632: STDA_R	stda	%r10, [%r30 + %r0] 0x73
	.word 0xdc86a000  ! 1633: LDUWA_I	lduwa	[%r26, + 0x0000] %asi, %r14
	.word 0xda870e80  ! 1634: LDUWA_R	lduwa	[%r28, %r0] 0x74, %r13
	mov	0x3f0, %r23
	.word 0xd2f74e60  ! 1636: STXA_R	stxa	%r9, [%r29 + %r0] 0x73
	.word 0x87802074  ! 1637: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802074  ! 1638: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r18
	.word 0xdeb48400  ! 1640: STHA_R	stha	%r15, [%r18 + %r0] 0x20
	.word 0xde9ec9e0  ! 1641: LDDA_R	ldda	[%r27, %r0] 0x4f, %r15
	.word 0xd0cf8e60  ! 1642: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r8
	mov	0x70, %r25
	.word 0xd2c70e60  ! 1644: LDSWA_R	ldswa	[%r28, %r0] 0x73, %r9
	.word 0xdca42000  ! 1645: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x7d8, %r23
	.word 0xdcbca000  ! 1647: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	.word 0xdcac6000  ! 1648: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1649: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 1650: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdca6a000  ! 1651: STWA_I	stwa	%r14, [%r26 + 0x0000] %asi
	.word 0xdca4c400  ! 1652: STWA_R	stwa	%r14, [%r19 + %r0] 0x20
	.word 0xd8f6a000  ! 1653: STXA_I	stxa	%r12, [%r26 + 0x0000] %asi
	.word 0xd89ea000  ! 1654: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	.word 0xd8b62000  ! 1655: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xd8c6e000  ! 1657: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r12
	.word 0xd8c6a000  ! 1658: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xdea7ce80  ! 1659: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0xd2aea000  ! 1660: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0xd2be6000  ! 1661: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd2862000  ! 1662: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r9
	.word 0x87802073  ! 1663: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f504a0  ! 1664: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0xd0f72000  ! 1665: STXA_I	stxa	%r8, [%r28 + 0x0000] %asi
	.word 0xd0876000  ! 1666: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r8
	.word 0xd4f44400  ! 1667: STXA_R	stxa	%r10, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1668: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69f0e60  ! 1669: LDDA_R	ldda	[%r28, %r0] 0x73, %r11
	.word 0xd2ce09e0  ! 1670: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r9
	.word 0xd6f72000  ! 1671: STXA_I	stxa	%r11, [%r28 + 0x0000] %asi
	.word 0xdebe09e0  ! 1672: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0xdad544a0  ! 1673: LDSHA_R	ldsha	[%r21, %r0] 0x25, %r13
	.word 0x8780204f  ! 1674: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3f8, %r23
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x3c8, %r21
	.word 0x87802025  ! 1678: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1679: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebfce40  ! 1680: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xdcf70e80  ! 1681: STXA_R	stxa	%r14, [%r28 + %r0] 0x74
	.word 0xde95c4a0  ! 1682: LDUHA_R	lduha	[%r23, %r0] 0x25, %r15
	.word 0xdccce000  ! 1683: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	mov	0x70, %r17
	.word 0xdccce000  ! 1685: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r14
	.word 0xd2c7ce60  ! 1686: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r9
	.word 0xdcf74e80  ! 1687: STXA_R	stxa	%r14, [%r29 + %r0] 0x74
	.word 0xd2978e40  ! 1688: LDUHA_R	lduha	[%r30, %r0] 0x72, %r9
	mov	0x3e8, %r22
	.word 0xd2b70e60  ! 1690: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xd684e000  ! 1691: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0x87802020  ! 1692: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd69e2000  ! 1693: LDDA_I	ldda	[%r24, + 0x0000] %asi, %r11
	.word 0xd4bf8e80  ! 1694: STDA_R	stda	%r10, [%r30 + %r0] 0x74
	.word 0x8780204f  ! 1695: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdab584a0  ! 1696: STHA_R	stha	%r13, [%r22 + %r0] 0x25
	.word 0xd8bf8e80  ! 1697: STDA_R	stda	%r12, [%r30 + %r0] 0x74
	.word 0xdead04a0  ! 1698: STBA_R	stba	%r15, [%r20 + %r0] 0x25
	.word 0xdef4c400  ! 1699: STXA_R	stxa	%r15, [%r19 + %r0] 0x20
	.word 0xdea4e000  ! 1700: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xd6ac8400  ! 1701: STBA_R	stba	%r11, [%r18 + %r0] 0x20
	.word 0xdcc4e000  ! 1702: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r14
	mov	0x7f8, %r20
	mov	0x30, %r24
	.word 0xdc8c2000  ! 1705: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r14
	.word 0xda978e60  ! 1706: LDUHA_R	lduha	[%r30, %r0] 0x73, %r13
	.word 0x87802025  ! 1707: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49c4400  ! 1708: LDDA_R	ldda	[%r17, %r0] 0x20, %r10
	.word 0xd4bf6000  ! 1709: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	mov	0x40, %r27
	mov	0x28, %r17
	.word 0xd4f7a000  ! 1712: STXA_I	stxa	%r10, [%r30 + 0x0000] %asi
	.word 0xdab609e0  ! 1713: STHA_R	stha	%r13, [%r24 + %r0] 0x4f
	mov	0x8, %r25
	.word 0xd68504a0  ! 1715: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r11
	.word 0x87802074  ! 1716: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6a5e000  ! 1717: STWA_I	stwa	%r11, [%r23 + 0x0000] %asi
	.word 0xd0a78e40  ! 1718: STWA_R	stwa	%r8, [%r30 + %r0] 0x72
	mov	0x70, %r26
	.word 0xdc95a000  ! 1720: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	mov	0x18, %r27
	.word 0xdaf40400  ! 1722: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xd6ada000  ! 1723: STBA_I	stba	%r11, [%r22 + 0x0000] %asi
	.word 0xd4bcc400  ! 1724: STDA_R	stda	%r10, [%r19 + %r0] 0x20
	mov	0x3c8, %r23
	.word 0xd6dde000  ! 1726: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r11
	.word 0xd6cd2000  ! 1727: LDSBA_I	ldsba	[%r20, + 0x0000] %asi, %r11
	mov	0x7c0, %r23
	mov	0x58, %r26
	.word 0xd4c584a0  ! 1730: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r10
	.word 0xdab78e40  ! 1731: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	.word 0xdca5e000  ! 1732: STWA_I	stwa	%r14, [%r23 + 0x0000] %asi
	.word 0xdc85e000  ! 1733: LDUWA_I	lduwa	[%r23, + 0x0000] %asi, %r14
	mov	0x50, %r27
	.word 0x87802020  ! 1735: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb649e0  ! 1736: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0xd4f76000  ! 1737: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 1738: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdc840400  ! 1739: LDUWA_R	lduwa	[%r16, %r0] 0x20, %r14
	.word 0xd4a78e60  ! 1740: STWA_R	stwa	%r10, [%r30 + %r0] 0x73
	mov	0x3e0, %r20
	.word 0x87802020  ! 1742: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c7e000  ! 1743: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0xd48f4e40  ! 1744: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	mov	0x60, %r27
	mov	0x50, %r25
	.word 0xd4a7a000  ! 1747: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	mov	0x20, %r16
	mov	0x50, %r19
	mov	0x7f8, %r23
	.word 0xd49f2000  ! 1751: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	.word 0xd4c72000  ! 1752: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	mov	0x7f8, %r22
	mov	0x40, %r17
	.word 0xd4dfe000  ! 1755: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r10
	mov	0x70, %r19
	.word 0xd49fe000  ! 1757: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	.word 0x87802020  ! 1758: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r23
	mov	0x60, %r26
	.word 0x87802074  ! 1761: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0d78e60  ! 1762: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	.word 0xdead6000  ! 1763: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0xdebde000  ! 1764: STDA_I	stda	%r15, [%r23 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xdccec9e0  ! 1766: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	.word 0xd8cda000  ! 1767: LDSBA_I	ldsba	[%r22, + 0x0000] %asi, %r12
	mov	0x30, %r17
	mov	0x3f8, %r22
	.word 0xd8bde000  ! 1770: STDA_I	stda	%r12, [%r23 + 0x0000] %asi
	.word 0xd69e89e0  ! 1771: LDDA_R	ldda	[%r26, %r0] 0x4f, %r11
	.word 0xdaa40400  ! 1772: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 1773: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd28d84a0  ! 1774: LDUBA_R	lduba	[%r22, %r0] 0x25, %r9
	mov	0x7d0, %r21
	.word 0xd4b66000  ! 1776: STHA_I	stha	%r10, [%r25 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xdace09e0  ! 1778: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r13
	.word 0xdec62000  ! 1779: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r15
	.word 0xdeae6000  ! 1780: STBA_I	stba	%r15, [%r25 + 0x0000] %asi
	.word 0xdeac8400  ! 1781: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	.word 0x87802073  ! 1782: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4a7ce40  ! 1783: STWA_R	stwa	%r10, [%r31 + %r0] 0x72
	.word 0xd8f7ce60  ! 1784: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0xd6af8e60  ! 1785: STBA_R	stba	%r11, [%r30 + %r0] 0x73
	.word 0xd4974e80  ! 1786: LDUHA_R	lduha	[%r29, %r0] 0x74, %r10
	.word 0xd89dc4a0  ! 1787: LDDA_R	ldda	[%r23, %r0] 0x25, %r12
	.word 0xd2c46000  ! 1788: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0xdef649e0  ! 1789: STXA_R	stxa	%r15, [%r25 + %r0] 0x4f
	.word 0x87802072  ! 1790: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd48609e0  ! 1791: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r10
	.word 0xd0b72000  ! 1792: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0f7a000  ! 1793: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	.word 0xd6b74e80  ! 1794: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	.word 0xda878e40  ! 1795: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r13
	.word 0xdeae49e0  ! 1796: STBA_R	stba	%r15, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 1797: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802073  ! 1798: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b42000  ! 1799: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd08ce000  ! 1800: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r8
	mov	0x18, %r18
	.word 0xd0d46000  ! 1802: LDSHA_I	ldsha	[%r17, + 0x0000] %asi, %r8
	.word 0xd0f46000  ! 1803: STXA_I	stxa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0d4a000  ! 1804: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r8
	.word 0x87802025  ! 1805: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0afe000  ! 1806: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0d7e000  ! 1807: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r8
	mov	0x7c8, %r21
	.word 0xdea74e80  ! 1809: STWA_R	stwa	%r15, [%r29 + %r0] 0x74
	.word 0xdcbfe000  ! 1810: STDA_I	stda	%r14, [%r31 + 0x0000] %asi
	mov	0x18, %r27
	.word 0x87802020  ! 1812: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca52000  ! 1813: STWA_I	stwa	%r14, [%r20 + 0x0000] %asi
	mov	0x18, %r27
	.word 0x87802072  ! 1815: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcac8400  ! 1816: STBA_R	stba	%r14, [%r18 + %r0] 0x20
	.word 0xdaa48400  ! 1817: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	.word 0x87802020  ! 1818: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 1819: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcf544a0  ! 1820: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0xd8c7a000  ! 1821: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xd6dc8400  ! 1822: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xd89fa000  ! 1823: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r12
	.word 0xd8976000  ! 1824: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	.word 0xd8a72000  ! 1825: STWA_I	stwa	%r12, [%r28 + 0x0000] %asi
	.word 0xd4bdc4a0  ! 1826: STDA_R	stda	%r10, [%r23 + %r0] 0x25
	.word 0xd8d7a000  ! 1827: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	mov	0x30, %r26
	.word 0xd88f6000  ! 1829: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0x87802025  ! 1830: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r26
	.word 0xd8a4e000  ! 1832: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	mov	0x7f8, %r21
	mov	0x8, %r19
	.word 0xde9649e0  ! 1835: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r15
	mov	0x30, %r27
	.word 0x87802072  ! 1837: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2be49e0  ! 1838: STDA_R	stda	%r9, [%r25 + %r0] 0x4f
	mov	0x7d8, %r21
	mov	0x60, %r25
	.word 0xdaafa000  ! 1841: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xdad7a000  ! 1842: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	mov	0x3f0, %r20
	mov	0x20, %r27
	.word 0x87802072  ! 1845: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda8de000  ! 1846: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r13
	.word 0xd8dfce80  ! 1847: LDXA_R	ldxa	[%r31, %r0] 0x74, %r12
	.word 0x8780204f  ! 1848: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaf5e000  ! 1849: STXA_I	stxa	%r13, [%r23 + 0x0000] %asi
	.word 0xdaada000  ! 1850: STBA_I	stba	%r13, [%r22 + 0x0000] %asi
	.word 0xdab52000  ! 1851: STHA_I	stha	%r13, [%r20 + 0x0000] %asi
	.word 0xd2970e40  ! 1852: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	.word 0xdabc0400  ! 1853: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	mov	0x3e8, %r20
	mov	0x3c8, %r22
	.word 0xdef48400  ! 1856: STXA_R	stxa	%r15, [%r18 + %r0] 0x20
	.word 0xd2dde000  ! 1857: LDXA_I	ldxa	[%r23, + 0x0000] %asi, %r9
	.word 0xdab4c400  ! 1858: STHA_R	stha	%r13, [%r19 + %r0] 0x20
	.word 0xdac5e000  ! 1859: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r13
	.word 0xd2f649e0  ! 1860: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	.word 0x87802073  ! 1861: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0d42000  ! 1862: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0xd2878e40  ! 1863: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r9
	.word 0xdea46000  ! 1864: STWA_I	stwa	%r15, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 1865: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4df0e40  ! 1866: LDXA_R	ldxa	[%r28, %r0] 0x72, %r10
	.word 0xd2bf8e60  ! 1867: STDA_R	stda	%r9, [%r30 + %r0] 0x73
	.word 0xd2a7ce40  ! 1868: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	mov	0x3d8, %r22
	.word 0xd2b74e40  ! 1870: STHA_R	stha	%r9, [%r29 + %r0] 0x72
	mov	0x20, %r19
	.word 0xd0dd44a0  ! 1872: LDXA_R	ldxa	[%r21, %r0] 0x25, %r8
	.word 0xdcb4a000  ! 1873: STHA_I	stha	%r14, [%r18 + 0x0000] %asi
	.word 0x87802025  ! 1874: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1875: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 1876: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcaee000  ! 1877: STBA_I	stba	%r14, [%r27 + 0x0000] %asi
	.word 0xd2a78e60  ! 1878: STWA_R	stwa	%r9, [%r30 + %r0] 0x73
	.word 0x87802073  ! 1879: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd28c8400  ! 1880: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0xdcb70e40  ! 1881: STHA_R	stha	%r14, [%r28 + %r0] 0x72
	mov	0x28, %r18
	.word 0xd2cdc4a0  ! 1883: LDSBA_R	ldsba	[%r23, %r0] 0x25, %r9
	.word 0xd0b76000  ! 1884: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	mov	0x68, %r27
	.word 0xd0a7a000  ! 1886: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	mov	0x78, %r24
	.word 0xd0d76000  ! 1888: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	mov	0x3e0, %r23
	.word 0xd0bfe000  ! 1890: STDA_I	stda	%r8, [%r31 + 0x0000] %asi
	.word 0xd28609e0  ! 1891: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r9
	.word 0xdebfe000  ! 1892: STDA_I	stda	%r15, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 1893: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8df8e80  ! 1894: LDXA_R	ldxa	[%r30, %r0] 0x74, %r12
	.word 0xd2f70e80  ! 1895: STXA_R	stxa	%r9, [%r28 + %r0] 0x74
	mov	0x10, %r18
	.word 0xdaa7ce80  ! 1897: STWA_R	stwa	%r13, [%r31 + %r0] 0x74
	mov	0x3e8, %r20
	mov	0x38, %r24
	mov	0x3d0, %r23
	.word 0xd2b584a0  ! 1901: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xda8fce40  ! 1902: LDUBA_R	lduba	[%r31, %r0] 0x72, %r13
	.word 0xdea66000  ! 1903: STWA_I	stwa	%r15, [%r25 + 0x0000] %asi
	mov	0x58, %r17
	.word 0xdeae2000  ! 1905: STBA_I	stba	%r15, [%r24 + 0x0000] %asi
	mov	0x38, %r26
	mov	0x50, %r27
	.word 0x87802072  ! 1908: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x7d8, %r22
	.word 0x87802020  ! 1910: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaaf8e80  ! 1911: STBA_R	stba	%r13, [%r30 + %r0] 0x74
	.word 0xd0b5c4a0  ! 1912: STHA_R	stha	%r8, [%r23 + %r0] 0x25
	mov	0x3f0, %r22
	.word 0xd89d04a0  ! 1914: LDDA_R	ldda	[%r20, %r0] 0x25, %r12
	.word 0xdcc5a000  ! 1915: LDSWA_I	ldswa	[%r22, + 0x0000] %asi, %r14
	.word 0x87802020  ! 1916: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf0e40  ! 1917: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0xdaf7e000  ! 1918: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xdabfe000  ! 1919: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xd08fce60  ! 1920: LDUBA_R	lduba	[%r31, %r0] 0x73, %r8
	.word 0xd28d04a0  ! 1921: LDUBA_R	lduba	[%r20, %r0] 0x25, %r9
	.word 0x87802072  ! 1922: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4dc4400  ! 1923: LDXA_R	ldxa	[%r17, %r0] 0x20, %r10
	.word 0x87802074  ! 1924: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd286e000  ! 1925: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r9
	.word 0x87802020  ! 1926: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6cf8e40  ! 1927: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0x8780204f  ! 1928: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8ae2000  ! 1929: STBA_I	stba	%r12, [%r24 + 0x0000] %asi
	.word 0xd8bea000  ! 1930: STDA_I	stda	%r12, [%r26 + 0x0000] %asi
	mov	0x40, %r24
	mov	0x7f0, %r23
	.word 0xdad70e40  ! 1933: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r13
	.word 0x87802025  ! 1934: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x8780204f  ! 1935: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 1936: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8c74e80  ! 1937: LDSWA_R	ldswa	[%r29, %r0] 0x74, %r12
	mov	0x7f8, %r23
	mov	0x68, %r17
	.word 0x87802025  ! 1940: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa7e000  ! 1941: STWA_I	stwa	%r13, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 1942: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x40, %r17
	.word 0x87802072  ! 1944: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r25
	.word 0x87802025  ! 1946: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802025  ! 1947: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda876000  ! 1948: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r13
	.word 0xd4d74e40  ! 1949: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r10
	.word 0x87802020  ! 1950: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeb76000  ! 1951: STHA_I	stha	%r15, [%r29 + 0x0000] %asi
	mov	0x60, %r19
	.word 0xdef72000  ! 1953: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd0a78e80  ! 1954: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	mov	0x7c8, %r21
	.word 0xd6afa000  ! 1956: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd4bc4400  ! 1957: STDA_R	stda	%r10, [%r17 + %r0] 0x20
	.word 0xd2bf2000  ! 1958: STDA_I	stda	%r9, [%r28 + 0x0000] %asi
	.word 0xd4c44400  ! 1959: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r10
	.word 0xd0b689e0  ! 1960: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	.word 0xd8d7a000  ! 1961: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 1962: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd88fa000  ! 1963: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r12
	mov	0x3c0, %r22
	.word 0xd8b72000  ! 1965: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0x87802073  ! 1966: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r24
	mov	0x48, %r16
	mov	0x50, %r25
	.word 0x87802073  ! 1970: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 1971: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88c0400  ! 1972: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xdaf6a000  ! 1973: STXA_I	stxa	%r13, [%r26 + 0x0000] %asi
	.word 0xd6dc8400  ! 1974: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	.word 0xd886c9e0  ! 1975: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r12
	.word 0xd0b6e000  ! 1976: STHA_I	stha	%r8, [%r27 + 0x0000] %asi
	.word 0x87802073  ! 1977: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdacf4e40  ! 1978: LDSBA_R	ldsba	[%r29, %r0] 0x72, %r13
	.word 0xd2aee000  ! 1979: STBA_I	stba	%r9, [%r27 + 0x0000] %asi
	mov	0x40, %r18
	.word 0xd4afce80  ! 1981: STBA_R	stba	%r10, [%r31 + %r0] 0x74
	.word 0xd097ce80  ! 1982: LDUHA_R	lduha	[%r31, %r0] 0x74, %r8
	mov	0x7f0, %r23
	mov	0x18, %r25
	.word 0xd086e000  ! 1985: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r8
	.word 0xd0a66000  ! 1986: STWA_I	stwa	%r8, [%r25 + 0x0000] %asi
	.word 0xd8f44400  ! 1987: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0x87802020  ! 1988: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdab4e000  ! 1989: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	.word 0xdadc2000  ! 1990: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r13
	.word 0xd6a7ce80  ! 1991: STWA_R	stwa	%r11, [%r31 + %r0] 0x74
	.word 0xd2c689e0  ! 1992: LDSWA_R	ldswa	[%r26, %r0] 0x4f, %r9
	.word 0xdcbc2000  ! 1993: STDA_I	stda	%r14, [%r16 + 0x0000] %asi
	.word 0xd8c74e40  ! 1994: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	.word 0xdadce000  ! 1995: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xd0c544a0  ! 1996: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r8
	.word 0xd49ce000  ! 1997: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0x87802074  ! 1998: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd4af2000  ! 1999: STBA_I	stba	%r10, [%r28 + 0x0000] %asi
	.word 0xd4f70e80  ! 2000: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	mov	0x40, %r17
	.word 0xd087e000  ! 2002: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd6a74e60  ! 2003: STWA_R	stwa	%r11, [%r29 + %r0] 0x73
	.word 0x8780204f  ! 2004: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcf6a000  ! 2005: STXA_I	stxa	%r14, [%r26 + 0x0000] %asi
	.word 0xd0bf4e80  ! 2006: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	mov	0x10, %r19
	.word 0xda9e6000  ! 2008: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2009: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2df0e80  ! 2010: LDXA_R	ldxa	[%r28, %r0] 0x74, %r9
	.word 0xdcb6c9e0  ! 2011: STHA_R	stha	%r14, [%r27 + %r0] 0x4f
	.word 0x87802073  ! 2012: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 2013: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8c78e60  ! 2014: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r12
	mov	0x50, %r18
	.word 0x87802073  ! 2016: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2a7ce40  ! 2017: STWA_R	stwa	%r9, [%r31 + %r0] 0x72
	mov	0x3d8, %r22
	.word 0xd4d74e80  ! 2019: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r10
	.word 0xd8b4e000  ! 2020: STHA_I	stha	%r12, [%r19 + 0x0000] %asi
	.word 0xd8f46000  ! 2021: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd8b74e60  ! 2022: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xda8e09e0  ! 2023: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r13
	mov	0x3c0, %r20
	mov	0x3c8, %r21
	.word 0x87802020  ! 2026: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x38, %r19
	mov	0x28, %r18
	ta	T_CHANGE_NONPRIV	! macro
	.word 0xd8cd44a0  ! 2030: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r12
	.word 0xd0cfe000  ! 2031: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0xd4f4c400  ! 2032: STXA_R	stxa	%r10, [%r19 + %r0] 0x20
	.word 0xda87ce40  ! 2033: LDUWA_R	lduwa	[%r31, %r0] 0x72, %r13
	.word 0x87802073  ! 2034: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaadc4a0  ! 2035: STBA_R	stba	%r13, [%r23 + %r0] 0x25
	.word 0x87802025  ! 2036: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8978e60  ! 2037: LDUHA_R	lduha	[%r30, %r0] 0x73, %r12
	mov	0x7f0, %r21
	mov	0x8, %r24
	.word 0xdc95a000  ! 2040: LDUHA_I	lduha	[%r22, + 0x0000] %asi, %r14
	.word 0xdcf52000  ! 2041: STXA_I	stxa	%r14, [%r20 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xd2b689e0  ! 2043: STHA_R	stha	%r9, [%r26 + %r0] 0x4f
	.word 0xd2cfce60  ! 2044: LDSBA_R	ldsba	[%r31, %r0] 0x73, %r9
	.word 0xdedda000  ! 2045: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r15
	.word 0xdaae49e0  ! 2046: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	.word 0xd2a4c400  ! 2047: STWA_R	stwa	%r9, [%r19 + %r0] 0x20
	.word 0xd0a584a0  ! 2048: STWA_R	stwa	%r8, [%r22 + %r0] 0x25
	.word 0xd8bc0400  ! 2049: STDA_R	stda	%r12, [%r16 + %r0] 0x20
	.word 0xd2ad2000  ! 2050: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0x87802074  ! 2051: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x78, %r16
	.word 0xd2c7e000  ! 2053: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r9
	.word 0x87802020  ! 2054: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 2055: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x7f0, %r21
	mov	0x58, %r24
	.word 0xd2bfa000  ! 2058: STDA_I	stda	%r9, [%r30 + 0x0000] %asi
	mov	0x58, %r17
	.word 0x87802074  ! 2060: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd29fe000  ! 2061: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd8dd84a0  ! 2062: LDXA_R	ldxa	[%r22, %r0] 0x25, %r12
	.word 0xd6cf2000  ! 2063: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r11
	.word 0xdca78e60  ! 2064: STWA_R	stwa	%r14, [%r30 + %r0] 0x73
	.word 0xd09cc400  ! 2065: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	mov	0x3f0, %r23
	.word 0xd2b78e40  ! 2067: STHA_R	stha	%r9, [%r30 + %r0] 0x72
	.word 0xd8976000  ! 2068: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r12
	mov	0x20, %r17
	mov	0x8, %r25
	mov	0x68, %r19
	.word 0xd8f4c400  ! 2072: STXA_R	stxa	%r12, [%r19 + %r0] 0x20
	.word 0xd29504a0  ! 2073: LDUHA_R	lduha	[%r20, %r0] 0x25, %r9
	mov	0x20, %r19
	.word 0xd2a78e40  ! 2075: STWA_R	stwa	%r9, [%r30 + %r0] 0x72
	mov	0x70, %r18
	.word 0xd09f2000  ! 2077: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r8
	mov	0x7c0, %r22
	.word 0xdaa544a0  ! 2079: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	.word 0xd8af6000  ! 2080: STBA_I	stba	%r12, [%r29 + 0x0000] %asi
	mov	0x78, %r18
	mov	0x3c8, %r22
	.word 0x87802020  ! 2083: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd09f8e40  ! 2084: LDDA_R	ldda	[%r30, %r0] 0x72, %r8
	.word 0xdcf7ce80  ! 2085: STXA_R	stxa	%r14, [%r31 + %r0] 0x74
	mov	0x30, %r26
	.word 0xd8a78e60  ! 2087: STWA_R	stwa	%r12, [%r30 + %r0] 0x73
	mov	0x0, %r24
	.word 0xd0b72000  ! 2089: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xdcb7ce80  ! 2090: STHA_R	stha	%r14, [%r31 + %r0] 0x74
	.word 0xd0872000  ! 2091: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r8
	.word 0xd0c76000  ! 2092: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r8
	.word 0xd2a48400  ! 2093: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	.word 0xd6aec9e0  ! 2094: STBA_R	stba	%r11, [%r27 + %r0] 0x4f
	.word 0x87802025  ! 2095: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r24
	.word 0xded649e0  ! 2097: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	.word 0x87802020  ! 2098: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0ae09e0  ! 2099: STBA_R	stba	%r8, [%r24 + %r0] 0x4f
	.word 0xd0a7e000  ! 2100: STWA_I	stwa	%r8, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 2101: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0afe000  ! 2102: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	.word 0xd0bf2000  ! 2103: STDA_I	stda	%r8, [%r28 + 0x0000] %asi
	mov	0x68, %r24
	mov	0x58, %r27
	.word 0xdaf649e0  ! 2106: STXA_R	stxa	%r13, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 2107: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7c0, %r23
	.word 0xd6bf2000  ! 2109: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 2110: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89f0e80  ! 2111: LDDA_R	ldda	[%r28, %r0] 0x74, %r12
	.word 0x87802072  ! 2112: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd6a000  ! 2113: LDSHA_I	ldsha	[%r26, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2114: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2115: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2116: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x28, %r16
	.word 0xdcd72000  ! 2118: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcb7a000  ! 2119: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	mov	0x7d8, %r21
	mov	0x0, %r24
	mov	0x28, %r17
	.word 0x87802073  ! 2123: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcbca000  ! 2124: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	mov	0x20, %r27
	.word 0xdc842000  ! 2126: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r14
	mov	0x30, %r25
	.word 0x8780204f  ! 2128: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdcae89e0  ! 2129: STBA_R	stba	%r14, [%r26 + %r0] 0x4f
	.word 0xd0c504a0  ! 2130: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	.word 0xdedc2000  ! 2131: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r15
	.word 0xdec4a000  ! 2132: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xd8a44400  ! 2133: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0x87802025  ! 2134: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdc87ce60  ! 2135: LDUWA_R	lduwa	[%r31, %r0] 0x73, %r14
	mov	0x28, %r24
	.word 0xdaaea000  ! 2137: STBA_I	stba	%r13, [%r26 + 0x0000] %asi
	mov	0x50, %r24
	.word 0x8780204f  ! 2139: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0f7ce80  ! 2140: STXA_R	stxa	%r8, [%r31 + %r0] 0x74
	.word 0xd4af8e60  ! 2141: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xd8bf4e80  ! 2142: STDA_R	stda	%r12, [%r29 + %r0] 0x74
	.word 0xdeb649e0  ! 2143: STHA_R	stha	%r15, [%r25 + %r0] 0x4f
	.word 0x87802025  ! 2144: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x8, %r19
	.word 0xd8a76000  ! 2146: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0xdeb70e40  ! 2147: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xd2976000  ! 2148: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 2149: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6cf8e40  ! 2150: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	mov	0x7c0, %r20
	mov	0x60, %r27
	mov	0x68, %r16
	.word 0x87802073  ! 2154: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x50, %r26
	mov	0x48, %r25
	.word 0x87802020  ! 2157: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeade000  ! 2158: STBA_I	stba	%r15, [%r23 + 0x0000] %asi
	.word 0xde956000  ! 2159: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r15
	.word 0xdeb5e000  ! 2160: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	.word 0xdead6000  ! 2161: STBA_I	stba	%r15, [%r21 + 0x0000] %asi
	.word 0x87802074  ! 2162: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeb72000  ! 2163: STHA_I	stha	%r15, [%r28 + 0x0000] %asi
	.word 0xdea76000  ! 2164: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xd6d70e60  ! 2165: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r11
	.word 0xd4a76000  ! 2166: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd0b78e40  ! 2167: STHA_R	stha	%r8, [%r30 + %r0] 0x72
	.word 0xdea689e0  ! 2168: STWA_R	stwa	%r15, [%r26 + %r0] 0x4f
	.word 0xded7a000  ! 2169: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r15
	.word 0xde972000  ! 2170: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	mov	0x10, %r25
	.word 0xde87e000  ! 2172: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	mov	0x7d8, %r23
	.word 0x87802020  ! 2174: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde972000  ! 2175: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xd8b584a0  ! 2176: STHA_R	stha	%r12, [%r22 + %r0] 0x25
	.word 0xd08f2000  ! 2177: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r8
	.word 0xd6d74e40  ! 2178: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r11
	.word 0x87802020  ! 2179: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r27
	mov	0x28, %r19
	.word 0x87802025  ! 2182: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6b78e40  ! 2183: STHA_R	stha	%r11, [%r30 + %r0] 0x72
	.word 0xd0874e80  ! 2184: LDUWA_R	lduwa	[%r29, %r0] 0x74, %r8
	.word 0xd2b4e000  ! 2185: STHA_I	stha	%r9, [%r19 + 0x0000] %asi
	.word 0xd8a6c9e0  ! 2186: STWA_R	stwa	%r12, [%r27 + %r0] 0x4f
	.word 0xd28c8400  ! 2187: LDUBA_R	lduba	[%r18, %r0] 0x20, %r9
	.word 0xd8c46000  ! 2188: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r12
	.word 0xd8c4a000  ! 2189: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	.word 0xdac544a0  ! 2190: LDSWA_R	ldswa	[%r21, %r0] 0x25, %r13
	.word 0x87802020  ! 2191: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd687a000  ! 2192: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2193: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802020  ! 2194: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x78, %r26
	.word 0xd0df8e80  ! 2196: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	mov	0x50, %r24
	.word 0x8780204f  ! 2198: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x20, %r24
	mov	0x0, %r25
	.word 0xd6b4c400  ! 2201: STHA_R	stha	%r11, [%r19 + %r0] 0x20
	.word 0xdeae09e0  ! 2202: STBA_R	stba	%r15, [%r24 + %r0] 0x4f
	.word 0xd0c78e40  ! 2203: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r8
	.word 0xdea7ce80  ! 2204: STWA_R	stwa	%r15, [%r31 + %r0] 0x74
	.word 0x87802072  ! 2205: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x30, %r17
	.word 0xd49fe000  ! 2207: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	mov	0x3f8, %r23
	.word 0xd2de89e0  ! 2209: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r9
	mov	0x7e0, %r20
	.word 0xd0b48400  ! 2211: STHA_R	stha	%r8, [%r18 + %r0] 0x20
	.word 0xd4970e80  ! 2212: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	.word 0xd6b544a0  ! 2213: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	mov	0x18, %r25
	.word 0xd29fe000  ! 2215: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd2f72000  ! 2216: STXA_I	stxa	%r9, [%r28 + 0x0000] %asi
	.word 0xd29f2000  ! 2217: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r9
	mov	0x50, %r26
	.word 0xde878e80  ! 2219: LDUWA_R	lduwa	[%r30, %r0] 0x74, %r15
	mov	0x60, %r27
	.word 0xdcf44400  ! 2221: STXA_R	stxa	%r14, [%r17 + %r0] 0x20
	mov	0x20, %r17
	.word 0x87802074  ! 2223: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x60, %r27
	.word 0xdabd2000  ! 2225: STDA_I	stda	%r13, [%r20 + 0x0000] %asi
	.word 0xda86c9e0  ! 2226: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd6f56000  ! 2228: STXA_I	stxa	%r11, [%r21 + 0x0000] %asi
	.word 0xd497ce60  ! 2229: LDUHA_R	lduha	[%r31, %r0] 0x73, %r10
	.word 0x87802073  ! 2230: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2b72000  ! 2231: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0xdec48400  ! 2233: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r15
	.word 0xdef7a000  ! 2234: STXA_I	stxa	%r15, [%r30 + 0x0000] %asi
	.word 0xdedfa000  ! 2235: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	mov	0x3f0, %r21
	mov	0x70, %r26
	mov	0x30, %r26
	mov	0x7f0, %r21
	.word 0x87802072  ! 2240: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xda94c400  ! 2241: LDUHA_R	lduha	[%r19, %r0] 0x20, %r13
	.word 0xd4a46000  ! 2242: STWA_I	stwa	%r10, [%r17 + 0x0000] %asi
	.word 0xd89f0e60  ! 2243: LDDA_R	ldda	[%r28, %r0] 0x73, %r12
	mov	0x40, %r27
	mov	0x30, %r26
	.word 0xd4d70e80  ! 2246: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r10
	.word 0xd69e49e0  ! 2247: LDDA_R	ldda	[%r25, %r0] 0x4f, %r11
	mov	0x70, %r26
	.word 0xd6a7ce40  ! 2249: STWA_R	stwa	%r11, [%r31 + %r0] 0x72
	mov	0x3f0, %r21
	.word 0xd2cfce80  ! 2251: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r9
	.word 0xd684a000  ! 2252: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0xd6b42000  ! 2253: STHA_I	stha	%r11, [%r16 + 0x0000] %asi
	.word 0xd0ac0400  ! 2254: STBA_R	stba	%r8, [%r16 + %r0] 0x20
	.word 0xd2dd44a0  ! 2255: LDXA_R	ldxa	[%r21, %r0] 0x25, %r9
	.word 0xd6f46000  ! 2256: STXA_I	stxa	%r11, [%r17 + 0x0000] %asi
	.word 0xd6a42000  ! 2257: STWA_I	stwa	%r11, [%r16 + 0x0000] %asi
	mov	0x0, %r24
	.word 0xd684a000  ! 2259: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r11
	.word 0x87802074  ! 2260: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f5c4a0  ! 2261: STXA_R	stxa	%r12, [%r23 + %r0] 0x25
	.word 0xd8c74e40  ! 2262: LDSWA_R	ldswa	[%r29, %r0] 0x72, %r12
	.word 0xd4d70e80  ! 2263: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r10
	.word 0x87802072  ! 2264: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdc8ea000  ! 2265: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	mov	0x20, %r27
	mov	0x7e8, %r21
	.word 0xdef7ce80  ! 2268: STXA_R	stxa	%r15, [%r31 + %r0] 0x74
	mov	0x18, %r16
	.word 0x87802020  ! 2270: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d4a000  ! 2271: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r11
	.word 0x87802072  ! 2272: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd89e09e0  ! 2273: LDDA_R	ldda	[%r24, %r0] 0x4f, %r12
	.word 0xd084a000  ! 2274: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r8
	mov	0x40, %r16
	.word 0xd0aca000  ! 2276: STBA_I	stba	%r8, [%r18 + 0x0000] %asi
	.word 0xd0b4e000  ! 2277: STHA_I	stha	%r8, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 2278: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7e8, %r20
	mov	0x40, %r17
	.word 0xd0bd6000  ! 2281: STDA_I	stda	%r8, [%r21 + 0x0000] %asi
	.word 0xd0dd6000  ! 2282: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd0952000  ! 2283: LDUHA_I	lduha	[%r20, + 0x0000] %asi, %r8
	.word 0xd48d04a0  ! 2284: LDUBA_R	lduba	[%r20, %r0] 0x25, %r10
	.word 0x87802074  ! 2285: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r17
	.word 0xd8cf6000  ! 2287: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r12
	mov	0x0, %r16
	.word 0xd8afe000  ! 2289: STBA_I	stba	%r12, [%r31 + 0x0000] %asi
	.word 0xd0d70e40  ! 2290: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r8
	.word 0xd0b7a000  ! 2291: STHA_I	stha	%r8, [%r30 + 0x0000] %asi
	.word 0xd68d44a0  ! 2292: LDUBA_R	lduba	[%r21, %r0] 0x25, %r11
	.word 0xdaa544a0  ! 2293: STWA_R	stwa	%r13, [%r21 + %r0] 0x25
	mov	0x28, %r25
	.word 0xdadd44a0  ! 2295: LDXA_R	ldxa	[%r21, %r0] 0x25, %r13
	.word 0xd4f7e000  ! 2296: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0xd4c72000  ! 2297: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	mov	0x48, %r25
	mov	0x28, %r16
	.word 0x87802073  ! 2300: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2301: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedfce80  ! 2302: LDXA_R	ldxa	[%r31, %r0] 0x74, %r15
	mov	0x7c0, %r23
	.word 0xd0a78e80  ! 2304: STWA_R	stwa	%r8, [%r30 + %r0] 0x74
	.word 0xd08c8400  ! 2305: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd49e6000  ! 2306: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r10
	mov	0x58, %r16
	.word 0xd4be6000  ! 2308: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xda974e80  ! 2309: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	mov	0x7c0, %r22
	.word 0x8780204f  ! 2311: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x78, %r25
	.word 0xd0b74e40  ! 2313: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xdcbf2000  ! 2314: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xdc876000  ! 2315: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r14
	.word 0x87802020  ! 2316: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r18
	.word 0xd2a44400  ! 2318: STWA_R	stwa	%r9, [%r17 + %r0] 0x20
	.word 0xd4dfa000  ! 2319: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	mov	0x3d0, %r20
	.word 0xd8cc0400  ! 2321: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r12
	.word 0xd6c76000  ! 2322: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xdadf8e60  ! 2323: LDXA_R	ldxa	[%r30, %r0] 0x73, %r13
	.word 0xd6b7e000  ! 2324: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0xdaf4c400  ! 2325: STXA_R	stxa	%r13, [%r19 + %r0] 0x20
	.word 0xd6a72000  ! 2326: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6f76000  ! 2327: STXA_I	stxa	%r11, [%r29 + 0x0000] %asi
	.word 0xdc878e40  ! 2328: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r14
	.word 0xd2b7e000  ! 2329: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd0a74e60  ! 2330: STWA_R	stwa	%r8, [%r29 + %r0] 0x73
	mov	0x30, %r17
	.word 0xdef72000  ! 2332: STXA_I	stxa	%r15, [%r28 + 0x0000] %asi
	.word 0xd88cc400  ! 2333: LDUBA_R	lduba	[%r19, %r0] 0x20, %r12
	.word 0xdeafe000  ! 2334: STBA_I	stba	%r15, [%r31 + 0x0000] %asi
	.word 0xd2cf8e80  ! 2335: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r9
	mov	0x20, %r17
	.word 0xde87e000  ! 2337: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xdea72000  ! 2338: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	.word 0x87802020  ! 2339: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdecf2000  ! 2340: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r15
	.word 0xde872000  ! 2341: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r15
	.word 0xdea7a000  ! 2342: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 2343: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7c0, %r22
	.word 0x87802020  ! 2345: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc6000  ! 2346: STDA_I	stda	%r15, [%r17 + 0x0000] %asi
	.word 0xd08fce80  ! 2347: LDUBA_R	lduba	[%r31, %r0] 0x74, %r8
	.word 0xd2bce000  ! 2348: STDA_I	stda	%r9, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 2349: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xda97ce60  ! 2350: LDUHA_R	lduha	[%r31, %r0] 0x73, %r13
	.word 0x87802073  ! 2351: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2d48400  ! 2352: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r9
	.word 0xd2bd84a0  ! 2353: STDA_R	stda	%r9, [%r22 + %r0] 0x25
	.word 0x8780204f  ! 2354: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802072  ! 2355: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0d42000  ! 2356: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r8
	.word 0xd0a4e000  ! 2357: STWA_I	stwa	%r8, [%r19 + 0x0000] %asi
	.word 0xd2f40400  ! 2358: STXA_R	stxa	%r9, [%r16 + %r0] 0x20
	.word 0x87802073  ! 2359: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8b6c9e0  ! 2360: STHA_R	stha	%r12, [%r27 + %r0] 0x4f
	mov	0x3e8, %r23
	mov	0x50, %r25
	.word 0xdea76000  ! 2363: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0xdea7a000  ! 2364: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xd0a44400  ! 2365: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0xdea72000  ! 2366: STWA_I	stwa	%r15, [%r28 + 0x0000] %asi
	mov	0x3f8, %r20
	.word 0xdedfe000  ! 2368: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	.word 0xded7e000  ! 2369: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r15
	mov	0x10, %r24
	.word 0xde8689e0  ! 2371: LDUWA_R	lduwa	[%r26, %r0] 0x4f, %r15
	.word 0x87802074  ! 2372: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f44400  ! 2373: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd6ad04a0  ! 2374: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0x87802025  ! 2375: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd6848400  ! 2376: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r11
	.word 0xdab66000  ! 2377: STHA_I	stha	%r13, [%r25 + 0x0000] %asi
	.word 0x8780204f  ! 2378: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802025  ! 2379: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4aec9e0  ! 2380: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	.word 0xd6cf8e60  ! 2381: LDSBA_R	ldsba	[%r30, %r0] 0x73, %r11
	.word 0xde8d2000  ! 2382: LDUBA_I	lduba	[%r20, + 0x0000] %asi, %r15
	.word 0xdc8c8400  ! 2383: LDUBA_R	lduba	[%r18, %r0] 0x20, %r14
	.word 0x87802025  ! 2384: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2385: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6d42000  ! 2386: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r11
	.word 0xdef78e80  ! 2387: STXA_R	stxa	%r15, [%r30 + %r0] 0x74
	.word 0xdebcc400  ! 2388: STDA_R	stda	%r15, [%r19 + %r0] 0x20
	mov	0x7d8, %r23
	mov	0x30, %r18
	.word 0xdaace000  ! 2391: STBA_I	stba	%r13, [%r19 + 0x0000] %asi
	.word 0xdabf8e80  ! 2392: STDA_R	stda	%r13, [%r30 + %r0] 0x74
	.word 0x87802020  ! 2393: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8b78e80  ! 2394: STHA_R	stha	%r12, [%r30 + %r0] 0x74
	.word 0xd4ac0400  ! 2395: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	mov	0x38, %r27
	.word 0xdcc7e000  ! 2397: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2398: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdca46000  ! 2399: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xdcbd44a0  ! 2401: STDA_R	stda	%r14, [%r21 + %r0] 0x25
	.word 0x87802074  ! 2402: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdeac2000  ! 2403: STBA_I	stba	%r15, [%r16 + 0x0000] %asi
	.word 0xdcbc0400  ! 2404: STDA_R	stda	%r14, [%r16 + %r0] 0x20
	.word 0xdcc4a000  ! 2405: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r14
	mov	0x40, %r18
	mov	0x10, %r27
	.word 0xd0f74e40  ! 2408: STXA_R	stxa	%r8, [%r29 + %r0] 0x72
	.word 0xdedca000  ! 2409: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r15
	.word 0xdebce000  ! 2410: STDA_I	stda	%r15, [%r19 + 0x0000] %asi
	.word 0xda9d04a0  ! 2411: LDDA_R	ldda	[%r20, %r0] 0x25, %r13
	.word 0xded74e80  ! 2412: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r15
	.word 0x8780204f  ! 2413: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r16
	.word 0xdcf7a000  ! 2415: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xd0ae89e0  ! 2416: STBA_R	stba	%r8, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 2417: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd49ce000  ! 2418: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r10
	.word 0xde944400  ! 2419: LDUHA_R	lduha	[%r17, %r0] 0x20, %r15
	.word 0xdcd4a000  ! 2420: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r14
	.word 0xdcbca000  ! 2421: STDA_I	stda	%r14, [%r18 + 0x0000] %asi
	mov	0x7e8, %r23
	mov	0x7c0, %r21
	.word 0xdcac6000  ! 2424: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0xde8c4400  ! 2425: LDUBA_R	lduba	[%r17, %r0] 0x20, %r15
	.word 0xdecce000  ! 2426: LDSBA_I	ldsba	[%r19, + 0x0000] %asi, %r15
	mov	0x48, %r19
	.word 0xdec46000  ! 2428: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r15
	mov	0x3f8, %r23
	.word 0xdccf0e80  ! 2430: LDSBA_R	ldsba	[%r28, %r0] 0x74, %r14
	.word 0x87802020  ! 2431: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde976000  ! 2432: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r15
	.word 0xdecf6000  ! 2433: LDSBA_I	ldsba	[%r29, + 0x0000] %asi, %r15
	.word 0xd8b74e60  ! 2434: STHA_R	stha	%r12, [%r29 + %r0] 0x73
	.word 0xdaf7e000  ! 2435: STXA_I	stxa	%r13, [%r31 + 0x0000] %asi
	.word 0xd8bf0e80  ! 2436: STDA_R	stda	%r12, [%r28 + %r0] 0x74
	.word 0xd29f8e80  ! 2437: LDDA_R	ldda	[%r30, %r0] 0x74, %r9
	.word 0xd8a7a000  ! 2438: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	mov	0x3f0, %r23
	.word 0xd8a40400  ! 2440: STWA_R	stwa	%r12, [%r16 + %r0] 0x20
	.word 0x87802020  ! 2441: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f48400  ! 2442: STXA_R	stxa	%r10, [%r18 + %r0] 0x20
	.word 0xd2b46000  ! 2443: STHA_I	stha	%r9, [%r17 + 0x0000] %asi
	mov	0x70, %r18
	.word 0xd2c7ce80  ! 2445: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r9
	.word 0xd694a000  ! 2446: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r11
	mov	0x18, %r26
	.word 0xd2d70e40  ! 2448: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r9
	.word 0xd0bf4e40  ! 2449: STDA_R	stda	%r8, [%r29 + %r0] 0x72
	mov	0x8, %r18
	.word 0x87802025  ! 2451: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2af8e40  ! 2452: STBA_R	stba	%r9, [%r30 + %r0] 0x72
	.word 0xdcdec9e0  ! 2453: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0xdca6e000  ! 2454: STWA_I	stwa	%r14, [%r27 + 0x0000] %asi
	mov	0x7c0, %r20
	mov	0x18, %r25
	.word 0x87802074  ! 2457: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 2458: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcc7a000  ! 2459: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r14
	.word 0xdaf40400  ! 2460: STXA_R	stxa	%r13, [%r16 + %r0] 0x20
	.word 0xdea48400  ! 2461: STWA_R	stwa	%r15, [%r18 + %r0] 0x20
	.word 0x87802025  ! 2462: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2cf2000  ! 2463: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r9
	.word 0xd2f7e000  ! 2464: STXA_I	stxa	%r9, [%r31 + 0x0000] %asi
	.word 0xd4b7ce60  ! 2465: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xd2a48400  ! 2466: STWA_R	stwa	%r9, [%r18 + %r0] 0x20
	mov	0x3e8, %r20
	.word 0xd2bcc400  ! 2468: STDA_R	stda	%r9, [%r19 + %r0] 0x20
	.word 0xd8afa000  ! 2469: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd2acc400  ! 2470: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0xdcb72000  ! 2471: STHA_I	stha	%r14, [%r28 + 0x0000] %asi
	.word 0xdebc4400  ! 2472: STDA_R	stda	%r15, [%r17 + %r0] 0x20
	.word 0xd69cc400  ! 2473: LDDA_R	ldda	[%r19, %r0] 0x20, %r11
	mov	0x50, %r18
	.word 0xd697a000  ! 2475: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r11
	.word 0xd6af2000  ! 2476: STBA_I	stba	%r11, [%r28 + 0x0000] %asi
	.word 0xd6b72000  ! 2477: STHA_I	stha	%r11, [%r28 + 0x0000] %asi
	.word 0xd6c7a000  ! 2478: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r11
	.word 0xd6afa000  ! 2479: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xdc8dc4a0  ! 2480: LDUBA_R	lduba	[%r23, %r0] 0x25, %r14
	mov	0x3e8, %r21
	.word 0xd8f7a000  ! 2482: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd2874e40  ! 2483: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r9
	.word 0xd4bfa000  ! 2484: STDA_I	stda	%r10, [%r30 + 0x0000] %asi
	.word 0xd08c8400  ! 2485: LDUBA_R	lduba	[%r18, %r0] 0x20, %r8
	.word 0xd6870e60  ! 2486: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r11
	.word 0x87802074  ! 2487: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802020  ! 2488: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0c4a000  ! 2489: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xd09c6000  ! 2490: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r8
	.word 0xd08c2000  ! 2491: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r8
	.word 0x87802072  ! 2492: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0df2000  ! 2493: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r8
	mov	0x48, %r25
	.word 0x87802025  ! 2495: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7f8, %r20
	.word 0xd0b72000  ! 2497: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0a7a000  ! 2498: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0f7e000  ! 2499: STXA_I	stxa	%r8, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 2500: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x38, %r18
	.word 0xd0bf0e40  ! 2502: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xd2f5e000  ! 2503: STXA_I	stxa	%r9, [%r23 + 0x0000] %asi
	.word 0x87802020  ! 2504: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x60, %r18
	mov	0x60, %r19
	.word 0x87802073  ! 2507: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 2508: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2ad2000  ! 2509: STBA_I	stba	%r9, [%r20 + 0x0000] %asi
	.word 0xd2d56000  ! 2510: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r9
	.word 0xd2ade000  ! 2511: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	.word 0xdcc78e40  ! 2512: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r14
	.word 0xd8d5a000  ! 2513: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r12
	.word 0xd8dd6000  ! 2514: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r12
	.word 0xd2b609e0  ! 2515: STHA_R	stha	%r9, [%r24 + %r0] 0x4f
	.word 0xdecfce80  ! 2516: LDSBA_R	ldsba	[%r31, %r0] 0x74, %r15
	.word 0xd8b78e60  ! 2517: STHA_R	stha	%r12, [%r30 + %r0] 0x73
	.word 0xd2ade000  ! 2518: STBA_I	stba	%r9, [%r23 + 0x0000] %asi
	mov	0x78, %r16
	.word 0xd2b5e000  ! 2520: STHA_I	stha	%r9, [%r23 + 0x0000] %asi
	.word 0xd2a5a000  ! 2521: STWA_I	stwa	%r9, [%r22 + 0x0000] %asi
	.word 0xdab544a0  ! 2522: STHA_R	stha	%r13, [%r21 + %r0] 0x25
	.word 0xd49c8400  ! 2523: LDDA_R	ldda	[%r18, %r0] 0x20, %r10
	.word 0xd29f0e60  ! 2524: LDDA_R	ldda	[%r28, %r0] 0x73, %r9
	.word 0xda870e60  ! 2525: LDUWA_R	lduwa	[%r28, %r0] 0x73, %r13
	mov	0x78, %r17
	.word 0xdef5a000  ! 2527: STXA_I	stxa	%r15, [%r22 + 0x0000] %asi
	.word 0xdaa40400  ! 2528: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xdcd5e000  ! 2529: LDSHA_I	ldsha	[%r23, + 0x0000] %asi, %r14
	.word 0xdc95e000  ! 2530: LDUHA_I	lduha	[%r23, + 0x0000] %asi, %r14
	mov	0x3c8, %r22
	.word 0xdcc5e000  ! 2532: LDSWA_I	ldswa	[%r23, + 0x0000] %asi, %r14
	mov	0x3f0, %r22
	.word 0xd2b74e80  ! 2534: STHA_R	stha	%r9, [%r29 + %r0] 0x74
	mov	0x50, %r18
	mov	0x50, %r24
	ta	T_CHANGE_HPRIV	! macro
	mov	0x38, %r24
	.word 0xd6d70e80  ! 2539: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r11
	.word 0x87802020  ! 2540: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802072  ! 2541: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcb7ce60  ! 2542: STHA_R	stha	%r14, [%r31 + %r0] 0x73
	.word 0xd8bf0e60  ! 2543: STDA_R	stda	%r12, [%r28 + %r0] 0x73
	.word 0xd4be6000  ! 2544: STDA_I	stda	%r10, [%r25 + 0x0000] %asi
	.word 0xdcdf4e80  ! 2545: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	.word 0xd8a6a000  ! 2546: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd49649e0  ! 2547: LDUHA_R	lduha	[%r25, %r0] 0x4f, %r10
	mov	0x30, %r25
	.word 0xd8c4c400  ! 2549: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r12
	.word 0x87802025  ! 2550: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8f6000  ! 2551: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r13
	.word 0x87802020  ! 2552: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4f70e80  ! 2553: STXA_R	stxa	%r10, [%r28 + %r0] 0x74
	.word 0xd0b42000  ! 2554: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xdcb504a0  ! 2555: STHA_R	stha	%r14, [%r20 + %r0] 0x25
	.word 0xd09d84a0  ! 2556: LDDA_R	ldda	[%r22, %r0] 0x25, %r8
	mov	0x7c0, %r23
	.word 0xd4ddc4a0  ! 2558: LDXA_R	ldxa	[%r23, %r0] 0x25, %r10
	.word 0x87802073  ! 2559: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd097ce60  ! 2560: LDUHA_R	lduha	[%r31, %r0] 0x73, %r8
	.word 0xde86e000  ! 2561: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xde86e000  ! 2562: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r15
	.word 0xd6948400  ! 2563: LDUHA_R	lduha	[%r18, %r0] 0x20, %r11
	.word 0xd8866000  ! 2564: LDUWA_I	lduwa	[%r25, + 0x0000] %asi, %r12
	mov	0x0, %r16
	.word 0xd88e6000  ! 2566: LDUBA_I	lduba	[%r25, + 0x0000] %asi, %r12
	.word 0xd8a6a000  ! 2567: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd8b66000  ! 2568: STHA_I	stha	%r12, [%r25 + 0x0000] %asi
	.word 0xd8c6a000  ! 2569: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8be6000  ! 2570: STDA_I	stda	%r12, [%r25 + 0x0000] %asi
	.word 0xd8d66000  ! 2571: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r12
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802020  ! 2573: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8f46000  ! 2574: STXA_I	stxa	%r12, [%r17 + 0x0000] %asi
	.word 0xd0af4e40  ! 2575: STBA_R	stba	%r8, [%r29 + %r0] 0x72
	mov	0x0, %r25
	.word 0xd0b544a0  ! 2577: STHA_R	stha	%r8, [%r21 + %r0] 0x25
	.word 0xdece89e0  ! 2578: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r15
	mov	0x70, %r16
	.word 0xd2b44400  ! 2580: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd8ad44a0  ! 2581: STBA_R	stba	%r12, [%r21 + %r0] 0x25
	mov	0x40, %r16
	.word 0xd6ac2000  ! 2583: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xd89609e0  ! 2584: LDUHA_R	lduha	[%r24, %r0] 0x4f, %r12
	.word 0xdc942000  ! 2585: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r14
	.word 0x87802074  ! 2586: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdcb56000  ! 2587: STHA_I	stha	%r14, [%r21 + 0x0000] %asi
	.word 0xdcd52000  ! 2588: LDSHA_I	ldsha	[%r20, + 0x0000] %asi, %r14
	.word 0xd6878e40  ! 2589: LDUWA_R	lduwa	[%r30, %r0] 0x72, %r11
	.word 0xdc844400  ! 2590: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0x8780204f  ! 2591: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x30, %r25
	.word 0xd8dfe000  ! 2593: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r12
	.word 0xd8bfa000  ! 2594: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	mov	0x7f0, %r22
	.word 0xd8cfe000  ! 2596: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r12
	.word 0xdc848400  ! 2597: LDUWA_R	lduwa	[%r18, %r0] 0x20, %r14
	mov	0x58, %r19
	.word 0xd28f4e40  ! 2599: LDUBA_R	lduba	[%r29, %r0] 0x72, %r9
	.word 0x87802073  ! 2600: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9cc400  ! 2601: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xdecc0400  ! 2602: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r15
	.word 0xd6a504a0  ! 2603: STWA_R	stwa	%r11, [%r20 + %r0] 0x25
	.word 0x87802072  ! 2604: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8c4a000  ! 2605: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r12
	mov	0x18, %r24
	.word 0x87802072  ! 2607: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6f4c400  ! 2608: STXA_R	stxa	%r11, [%r19 + %r0] 0x20
	mov	0x3c0, %r22
	mov	0x50, %r19
	.word 0xde87e000  ! 2611: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r15
	.word 0xd4b74e60  ! 2612: STHA_R	stha	%r10, [%r29 + %r0] 0x73
	.word 0x87802020  ! 2613: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 2614: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x18, %r18
	.word 0xda948400  ! 2616: LDUHA_R	lduha	[%r18, %r0] 0x20, %r13
	mov	0x20, %r17
	.word 0xdabc8400  ! 2618: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd8b72000  ! 2619: STHA_I	stha	%r12, [%r28 + 0x0000] %asi
	.word 0xd8bfa000  ! 2620: STDA_I	stda	%r12, [%r30 + 0x0000] %asi
	.word 0xd4be49e0  ! 2621: STDA_R	stda	%r10, [%r25 + %r0] 0x4f
	mov	0x58, %r19
	.word 0xd8cc8400  ! 2623: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r12
	.word 0x87802025  ! 2624: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde87ce80  ! 2625: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r15
	.word 0xd2f584a0  ! 2626: STXA_R	stxa	%r9, [%r22 + %r0] 0x25
	.word 0x87802020  ! 2627: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e0, %r22
	mov	0x7f8, %r21
	mov	0x40, %r17
	.word 0xdadce000  ! 2631: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0xda84a000  ! 2632: LDUWA_I	lduwa	[%r18, + 0x0000] %asi, %r13
	.word 0xdadca000  ! 2633: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r13
	.word 0xdaac2000  ! 2634: STBA_I	stba	%r13, [%r16 + 0x0000] %asi
	.word 0xd0dc0400  ! 2635: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xd4a70e60  ! 2636: STWA_R	stwa	%r10, [%r28 + %r0] 0x73
	.word 0xd4aca000  ! 2637: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x58, %r25
	.word 0x87802020  ! 2639: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd29f8e40  ! 2640: LDDA_R	ldda	[%r30, %r0] 0x72, %r9
	mov	0x7d0, %r21
	.word 0xd4f609e0  ! 2642: STXA_R	stxa	%r10, [%r24 + %r0] 0x4f
	.word 0xd68c6000  ! 2643: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r11
	.word 0x87802074  ! 2644: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3e8, %r22
	.word 0xded504a0  ! 2646: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	.word 0x87802072  ! 2647: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r16
	.word 0xdcf48400  ! 2649: STXA_R	stxa	%r14, [%r18 + %r0] 0x20
	mov	0x7e0, %r23
	.word 0xd4b52000  ! 2651: STHA_I	stha	%r10, [%r20 + 0x0000] %asi
	.word 0xd4f56000  ! 2652: STXA_I	stxa	%r10, [%r21 + 0x0000] %asi
	mov	0x40, %r26
	.word 0xd28f4e80  ! 2654: LDUBA_R	lduba	[%r29, %r0] 0x74, %r9
	.word 0xd6d78e60  ! 2655: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r11
	.word 0xdeb5a000  ! 2656: STHA_I	stha	%r15, [%r22 + 0x0000] %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xde9de000  ! 2658: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r15
	.word 0xdeb56000  ! 2659: STHA_I	stha	%r15, [%r21 + 0x0000] %asi
	.word 0xd8a44400  ! 2660: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	.word 0x87802020  ! 2661: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6dc4400  ! 2662: LDXA_R	ldxa	[%r17, %r0] 0x20, %r11
	.word 0xd2be6000  ! 2663: STDA_I	stda	%r9, [%r25 + 0x0000] %asi
	.word 0xd28fce40  ! 2664: LDUBA_R	lduba	[%r31, %r0] 0x72, %r9
	.word 0xd4b6e000  ! 2665: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xd4be09e0  ! 2667: STDA_R	stda	%r10, [%r24 + %r0] 0x4f
	.word 0xdeb544a0  ! 2668: STHA_R	stha	%r15, [%r21 + %r0] 0x25
	.word 0xdcbc8400  ! 2669: STDA_R	stda	%r14, [%r18 + %r0] 0x20
	.word 0xd48c8400  ! 2670: LDUBA_R	lduba	[%r18, %r0] 0x20, %r10
	mov	0x7f0, %r23
	.word 0xdcc6a000  ! 2672: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r14
	.word 0xd6bf0e80  ! 2673: STDA_R	stda	%r11, [%r28 + %r0] 0x74
	mov	0x58, %r25
	.word 0xd6962000  ! 2675: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r11
	mov	0x50, %r27
	.word 0xd4ad04a0  ! 2677: STBA_R	stba	%r10, [%r20 + %r0] 0x25
	.word 0xd886e000  ! 2678: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r12
	.word 0xd2c78e60  ! 2679: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r9
	mov	0x78, %r19
	.word 0xdcaf4e80  ! 2681: STBA_R	stba	%r14, [%r29 + %r0] 0x74
	mov	0x58, %r17
	.word 0xd4a6a000  ! 2683: STWA_I	stwa	%r10, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 2684: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r25
	.word 0xd4c7e000  ! 2686: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r10
	.word 0xd0b689e0  ! 2687: STHA_R	stha	%r8, [%r26 + %r0] 0x4f
	.word 0xde9cc400  ! 2688: LDDA_R	ldda	[%r19, %r0] 0x20, %r15
	.word 0xdecc8400  ! 2689: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r15
	.word 0xd6a72000  ! 2690: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xd6cfe000  ! 2691: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r11
	.word 0x8780204f  ! 2692: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x70, %r19
	.word 0xd8bd04a0  ! 2694: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xd4d56000  ! 2695: LDSHA_I	ldsha	[%r21, + 0x0000] %asi, %r10
	.word 0x87802072  ! 2696: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4dd2000  ! 2697: LDXA_I	ldxa	[%r20, + 0x0000] %asi, %r10
	.word 0xd4956000  ! 2698: LDUHA_I	lduha	[%r21, + 0x0000] %asi, %r10
	.word 0xdecf8e40  ! 2699: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r15
	mov	0x68, %r16
	.word 0xd4d40400  ! 2701: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r10
	.word 0xd4940400  ! 2702: LDUHA_R	lduha	[%r16, %r0] 0x20, %r10
	mov	0x3e0, %r20
	.word 0xd0b5e000  ! 2704: STHA_I	stha	%r8, [%r23 + 0x0000] %asi
	.word 0xd08da000  ! 2705: LDUBA_I	lduba	[%r22, + 0x0000] %asi, %r8
	.word 0xd4f40400  ! 2706: STXA_R	stxa	%r10, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 2707: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4af8e60  ! 2708: STBA_R	stba	%r10, [%r30 + %r0] 0x73
	.word 0xdedfe000  ! 2709: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r15
	mov	0x40, %r18
	.word 0x87802074  ! 2711: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x40, %r24
	mov	0x30, %r24
	mov	0x18, %r16
	.word 0xdea4a000  ! 2715: STWA_I	stwa	%r15, [%r18 + 0x0000] %asi
	mov	0x60, %r25
	.word 0xd6944400  ! 2717: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0xd8a4a000  ! 2718: STWA_I	stwa	%r12, [%r18 + 0x0000] %asi
	.word 0xd0c48400  ! 2719: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r8
	.word 0xd6cf8e40  ! 2720: LDSBA_R	ldsba	[%r30, %r0] 0x72, %r11
	.word 0x87802073  ! 2721: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x70, %r25
	.word 0xd4dfa000  ! 2723: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd48f6000  ! 2724: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0x87802025  ! 2725: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x60, %r24
	mov	0x7c0, %r22
	.word 0xda8d44a0  ! 2728: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	.word 0xd6b7ce60  ! 2729: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0xd0ad84a0  ! 2730: STBA_R	stba	%r8, [%r22 + %r0] 0x25
	.word 0xd2a7e000  ! 2731: STWA_I	stwa	%r9, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2732: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2c76000  ! 2733: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	.word 0xdacc4400  ! 2734: LDSBA_R	ldsba	[%r17, %r0] 0x20, %r13
	.word 0xd4f72000  ! 2735: STXA_I	stxa	%r10, [%r28 + 0x0000] %asi
	.word 0xd48fe000  ! 2736: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	.word 0xd4afe000  ! 2737: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	mov	0x3c0, %r20
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7f0, %r20
	.word 0xdea609e0  ! 2741: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xd4dfce80  ! 2742: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	.word 0xdeb70e40  ! 2743: STHA_R	stha	%r15, [%r28 + %r0] 0x72
	.word 0xd6ad84a0  ! 2744: STBA_R	stba	%r11, [%r22 + %r0] 0x25
	mov	0x58, %r26
	.word 0xd8d7ce60  ! 2746: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r12
	mov	0x0, %r16
	.word 0xdabfce40  ! 2748: STDA_R	stda	%r13, [%r31 + %r0] 0x72
	.word 0xd687ce80  ! 2749: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r11
	.word 0xdad72000  ! 2750: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r13
	.word 0xd4afce60  ! 2751: STBA_R	stba	%r10, [%r31 + %r0] 0x73
	mov	0x18, %r27
	.word 0x87802072  ! 2753: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6b74e60  ! 2754: STHA_R	stha	%r11, [%r29 + %r0] 0x73
	.word 0xdebd84a0  ! 2755: STDA_R	stda	%r15, [%r22 + %r0] 0x25
	.word 0xdcdf6000  ! 2756: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r14
	.word 0xdedcc400  ! 2757: LDXA_R	ldxa	[%r19, %r0] 0x20, %r15
	mov	0x3f0, %r22
	.word 0xd2cfe000  ! 2759: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2b72000  ! 2760: STHA_I	stha	%r9, [%r28 + 0x0000] %asi
	.word 0xd8bdc4a0  ! 2761: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xd2c76000  ! 2762: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r9
	mov	0x3d8, %r23
	.word 0xd2d7e000  ! 2764: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	mov	0x40, %r25
	.word 0xd2d76000  ! 2766: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r9
	.word 0xd6f48400  ! 2767: STXA_R	stxa	%r11, [%r18 + %r0] 0x20
	.word 0x87802020  ! 2768: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd48de000  ! 2769: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r10
	mov	0x60, %r27
	.word 0xd6b48400  ! 2771: STHA_R	stha	%r11, [%r18 + %r0] 0x20
	mov	0x10, %r16
	.word 0x87802025  ! 2773: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802020  ! 2774: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdea7e000  ! 2775: STWA_I	stwa	%r15, [%r31 + 0x0000] %asi
	.word 0xd8bf0e40  ! 2776: STDA_R	stda	%r12, [%r28 + %r0] 0x72
	.word 0xdedf2000  ! 2777: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xd4b7ce60  ! 2778: STHA_R	stha	%r10, [%r31 + %r0] 0x73
	.word 0xd0b72000  ! 2779: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	mov	0x40, %r17
	mov	0x10, %r25
	.word 0xd69ec9e0  ! 2782: LDDA_R	ldda	[%r27, %r0] 0x4f, %r11
	.word 0xdaafe000  ! 2783: STBA_I	stba	%r13, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 2784: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda87e000  ! 2785: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r13
	.word 0xda8d44a0  ! 2786: LDUBA_R	lduba	[%r21, %r0] 0x25, %r13
	.word 0x87802073  ! 2787: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802074  ! 2788: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdab7ce80  ! 2789: STHA_R	stha	%r13, [%r31 + %r0] 0x74
	.word 0xd6ccc400  ! 2790: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	.word 0x87802025  ! 2791: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2870e40  ! 2792: LDUWA_R	lduwa	[%r28, %r0] 0x72, %r9
	mov	0x7f0, %r20
	.word 0xdaa76000  ! 2794: STWA_I	stwa	%r13, [%r29 + 0x0000] %asi
	.word 0xdcd40400  ! 2795: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	.word 0xd29d44a0  ! 2796: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	mov	0x18, %r18
	.word 0xd8a76000  ! 2798: STWA_I	stwa	%r12, [%r29 + 0x0000] %asi
	.word 0x87802020  ! 2799: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde94c400  ! 2800: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xdc8f8e40  ! 2801: LDUBA_R	lduba	[%r30, %r0] 0x72, %r14
	.word 0xda9f2000  ! 2802: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r13
	.word 0xdaa72000  ! 2803: STWA_I	stwa	%r13, [%r28 + 0x0000] %asi
	.word 0xdaafa000  ! 2804: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	.word 0xd8bc4400  ! 2805: STDA_R	stda	%r12, [%r17 + %r0] 0x20
	mov	0x50, %r19
	.word 0xde8544a0  ! 2807: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r15
	.word 0xd2876000  ! 2808: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	.word 0xd2970e40  ! 2809: LDUHA_R	lduha	[%r28, %r0] 0x72, %r9
	.word 0xdec72000  ! 2810: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r15
	.word 0xdca74e40  ! 2811: STWA_R	stwa	%r14, [%r29 + %r0] 0x72
	.word 0xd8f649e0  ! 2812: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0xd4970e80  ! 2813: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	.word 0xd0a7a000  ! 2814: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	mov	0x3f0, %r23
	mov	0x50, %r27
	mov	0x60, %r18
	mov	0x7d8, %r22
	.word 0xd0cfe000  ! 2819: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r8
	.word 0x87802025  ! 2820: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0bc6000  ! 2821: STDA_I	stda	%r8, [%r17 + 0x0000] %asi
	mov	0x10, %r16
	mov	0x70, %r25
	.word 0xded504a0  ! 2824: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r15
	.word 0x87802020  ! 2825: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca7a000  ! 2826: STWA_I	stwa	%r14, [%r30 + 0x0000] %asi
	.word 0xd4ac4400  ! 2827: STBA_R	stba	%r10, [%r17 + %r0] 0x20
	.word 0xdccec9e0  ! 2828: LDSBA_R	ldsba	[%r27, %r0] 0x4f, %r14
	.word 0xd0d72000  ! 2829: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r8
	mov	0x78, %r19
	mov	0x10, %r26
	mov	0x58, %r24
	mov	0x3c0, %r22
	.word 0xd087e000  ! 2834: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r8
	.word 0xd4bf4e60  ! 2835: STDA_R	stda	%r10, [%r29 + %r0] 0x73
	.word 0xdc972000  ! 2836: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r14
	.word 0xdcf72000  ! 2837: STXA_I	stxa	%r14, [%r28 + 0x0000] %asi
	.word 0xdcf7a000  ! 2838: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xd4bf8e40  ! 2839: STDA_R	stda	%r10, [%r30 + %r0] 0x72
	.word 0x87802020  ! 2840: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdec4a000  ! 2841: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r15
	.word 0xdef6c9e0  ! 2842: STXA_R	stxa	%r15, [%r27 + %r0] 0x4f
	.word 0xde9c0400  ! 2843: LDDA_R	ldda	[%r16, %r0] 0x20, %r15
	.word 0xdecf0e60  ! 2844: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r15
	.word 0xda874e40  ! 2845: LDUWA_R	lduwa	[%r29, %r0] 0x72, %r13
	.word 0xd2a70e40  ! 2846: STWA_R	stwa	%r9, [%r28 + %r0] 0x72
	mov	0x8, %r18
	.word 0xd4bc8400  ! 2848: STDA_R	stda	%r10, [%r18 + %r0] 0x20
	.word 0xd0dc8400  ! 2849: LDXA_R	ldxa	[%r18, %r0] 0x20, %r8
	.word 0xd0f544a0  ! 2850: STXA_R	stxa	%r8, [%r21 + %r0] 0x25
	.word 0x87802020  ! 2851: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xded649e0  ! 2852: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r15
	.word 0xd0c78e60  ! 2853: LDSWA_R	ldswa	[%r30, %r0] 0x73, %r8
	.word 0x87802074  ! 2854: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x0, %r25
	.word 0xd88ea000  ! 2856: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r12
	mov	0x30, %r19
	mov	0x38, %r17
	.word 0xd8a6e000  ! 2859: STWA_I	stwa	%r12, [%r27 + 0x0000] %asi
	mov	0x7e8, %r21
	mov	0x68, %r27
	.word 0xd8b62000  ! 2862: STHA_I	stha	%r12, [%r24 + 0x0000] %asi
	.word 0xd8dea000  ! 2863: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0xd0a44400  ! 2864: STWA_R	stwa	%r8, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 2865: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebf0e60  ! 2866: STDA_R	stda	%r15, [%r28 + %r0] 0x73
	.word 0xdac52000  ! 2867: LDSWA_I	ldswa	[%r20, + 0x0000] %asi, %r13
	.word 0xdad5a000  ! 2868: LDSHA_I	ldsha	[%r22, + 0x0000] %asi, %r13
	mov	0x48, %r26
	.word 0xd0dc0400  ! 2870: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	mov	0x48, %r24
	.word 0xd8d609e0  ! 2872: LDSHA_R	ldsha	[%r24, %r0] 0x4f, %r12
	.word 0x87802073  ! 2873: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd2f4e000  ! 2874: STXA_I	stxa	%r9, [%r19 + 0x0000] %asi
	mov	0x3c8, %r20
	.word 0xd4f7ce40  ! 2876: STXA_R	stxa	%r10, [%r31 + %r0] 0x72
	.word 0xdccf8e80  ! 2877: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r14
	.word 0xd4bfce40  ! 2878: STDA_R	stda	%r10, [%r31 + %r0] 0x72
	.word 0x8780204f  ! 2879: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0a40400  ! 2880: STWA_R	stwa	%r8, [%r16 + %r0] 0x20
	.word 0xd09544a0  ! 2881: LDUHA_R	lduha	[%r21, %r0] 0x25, %r8
	ta	T_CHANGE_NONHPRIV	! macro
	mov	0x7f8, %r22
	mov	0x3f8, %r22
	.word 0xdcf544a0  ! 2885: STXA_R	stxa	%r14, [%r21 + %r0] 0x25
	.word 0x87802073  ! 2886: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdede89e0  ! 2887: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r15
	.word 0xd0a52000  ! 2888: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xd0856000  ! 2890: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r8
	mov	0x18, %r19
	.word 0x87802020  ! 2892: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaf48400  ! 2893: STXA_R	stxa	%r13, [%r18 + %r0] 0x20
	.word 0xdeb44400  ! 2894: STHA_R	stha	%r15, [%r17 + %r0] 0x20
	.word 0xda874e60  ! 2895: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r13
	.word 0x8780204f  ! 2896: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802074  ! 2897: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd89fe000  ! 2898: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r12
	.word 0xd2acc400  ! 2899: STBA_R	stba	%r9, [%r19 + %r0] 0x20
	.word 0x87802072  ! 2900: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4d7e000  ! 2901: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r10
	.word 0xd4bf6000  ! 2902: STDA_I	stda	%r10, [%r29 + 0x0000] %asi
	.word 0xd8ae49e0  ! 2903: STBA_R	stba	%r12, [%r25 + %r0] 0x4f
	.word 0xd6bc0400  ! 2904: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	.word 0xd6f7e000  ! 2905: STXA_I	stxa	%r11, [%r31 + 0x0000] %asi
	.word 0xd2f649e0  ! 2906: STXA_R	stxa	%r9, [%r25 + %r0] 0x4f
	.word 0xd4acc400  ! 2907: STBA_R	stba	%r10, [%r19 + %r0] 0x20
	.word 0xd6bc0400  ! 2908: STDA_R	stda	%r11, [%r16 + %r0] 0x20
	mov	0x28, %r27
	.word 0x8780204f  ! 2910: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4b504a0  ! 2911: STHA_R	stha	%r10, [%r20 + %r0] 0x25
	.word 0xdc844400  ! 2912: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r14
	.word 0xdea609e0  ! 2913: STWA_R	stwa	%r15, [%r24 + %r0] 0x4f
	.word 0xdab78e40  ! 2914: STHA_R	stha	%r13, [%r30 + %r0] 0x72
	mov	0x38, %r18
	.word 0xdadea000  ! 2916: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r13
	.word 0xdace2000  ! 2917: LDSBA_I	ldsba	[%r24, + 0x0000] %asi, %r13
	.word 0xd6d74e80  ! 2918: LDSHA_R	ldsha	[%r29, %r0] 0x74, %r11
	.word 0xd2966000  ! 2919: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r9
	.word 0xd0970e80  ! 2920: LDUHA_R	lduha	[%r28, %r0] 0x74, %r8
	.word 0xd2f4c400  ! 2921: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	mov	0x40, %r17
	.word 0x87802073  ! 2923: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd4b70e40  ! 2924: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	mov	0x68, %r26
	.word 0xd68f2000  ! 2926: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xd8bd04a0  ! 2927: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xd6bf6000  ! 2928: STDA_I	stda	%r11, [%r29 + 0x0000] %asi
	.word 0x87802073  ! 2929: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6972000  ! 2930: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r11
	.word 0x87802020  ! 2931: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd68ca000  ! 2932: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r11
	.word 0xd6ad04a0  ! 2933: STBA_R	stba	%r11, [%r20 + %r0] 0x25
	.word 0xde9c4400  ! 2934: LDDA_R	ldda	[%r17, %r0] 0x20, %r15
	.word 0xd0bcc400  ! 2935: STDA_R	stda	%r8, [%r19 + %r0] 0x20
	.word 0xd4bc0400  ! 2936: STDA_R	stda	%r10, [%r16 + %r0] 0x20
	.word 0xdad4c400  ! 2937: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r13
	.word 0xdcac6000  ! 2938: STBA_I	stba	%r14, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 2939: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802025  ! 2940: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdca46000  ! 2941: STWA_I	stwa	%r14, [%r17 + 0x0000] %asi
	.word 0xdc84e000  ! 2942: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r14
	.word 0xdcf46000  ! 2943: STXA_I	stxa	%r14, [%r17 + 0x0000] %asi
	.word 0xdcd4e000  ! 2944: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r14
	mov	0x3e0, %r21
	mov	0x3f8, %r22
	.word 0xdcf42000  ! 2947: STXA_I	stxa	%r14, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2948: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 2949: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd697ce60  ! 2950: LDUHA_R	lduha	[%r31, %r0] 0x73, %r11
	.word 0xde9584a0  ! 2951: LDUHA_R	lduha	[%r22, %r0] 0x25, %r15
	mov	0x68, %r26
	.word 0xd6a72000  ! 2953: STWA_I	stwa	%r11, [%r28 + 0x0000] %asi
	.word 0xdcbf4e40  ! 2954: STDA_R	stda	%r14, [%r29 + %r0] 0x72
	.word 0xd0d76000  ! 2955: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r8
	.word 0x87802020  ! 2956: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdca78e40  ! 2957: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	.word 0xdebd44a0  ! 2958: STDA_R	stda	%r15, [%r21 + %r0] 0x25
	.word 0xd2aea000  ! 2959: STBA_I	stba	%r9, [%r26 + 0x0000] %asi
	.word 0x87802073  ! 2960: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x3f0, %r21
	mov	0x50, %r19
	.word 0x87802020  ! 2963: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd0df8e80  ! 2964: LDXA_R	ldxa	[%r30, %r0] 0x74, %r8
	.word 0xd4af0e60  ! 2965: STBA_R	stba	%r10, [%r28 + %r0] 0x73
	mov	0x7f0, %r23
	.word 0xd09f4e40  ! 2967: LDDA_R	ldda	[%r29, %r0] 0x72, %r8
	.word 0xd68584a0  ! 2968: LDUWA_R	lduwa	[%r22, %r0] 0x25, %r11
	mov	0x7f0, %r23
	mov	0x58, %r24
	mov	0x38, %r16
	.word 0xdebe89e0  ! 2972: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xd6dec9e0  ! 2973: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r11
	mov	0x3c0, %r23
	.word 0x87802020  ! 2975: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdec9e0  ! 2976: LDXA_R	ldxa	[%r27, %r0] 0x4f, %r14
	.word 0x87802072  ! 2977: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x60, %r18
	.word 0xd0dc0400  ! 2979: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	mov	0x58, %r26
	.word 0x87802020  ! 2981: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde84e000  ! 2982: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r15
	mov	0x8, %r25
	.word 0xd6f70e80  ! 2984: STXA_R	stxa	%r11, [%r28 + %r0] 0x74
	.word 0xd4a544a0  ! 2985: STWA_R	stwa	%r10, [%r21 + %r0] 0x25
	mov	0x50, %r27
	mov	0x7e8, %r21
	.word 0xdacf0e40  ! 2988: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r13
	mov	0x70, %r27
	.word 0xdebfce40  ! 2990: STDA_R	stda	%r15, [%r31 + %r0] 0x72
	.word 0xd2a42000  ! 2991: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	mov	0x40, %r25
	.word 0xd0f6c9e0  ! 2993: STXA_R	stxa	%r8, [%r27 + %r0] 0x4f
	.word 0xd2a42000  ! 2994: STWA_I	stwa	%r9, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 2995: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2af2000  ! 2996: STBA_I	stba	%r9, [%r28 + 0x0000] %asi
	.word 0xd2a5c4a0  ! 2997: STWA_R	stwa	%r9, [%r23 + %r0] 0x25
	.word 0xdcf7a000  ! 2998: STXA_I	stxa	%r14, [%r30 + 0x0000] %asi
	.word 0xd8f7ce60  ! 2999: STXA_R	stxa	%r12, [%r31 + %r0] 0x73
	.word 0x87802020  ! 3000: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r20
	.word 0xd684e000  ! 3002: LDUWA_I	lduwa	[%r19, + 0x0000] %asi, %r11
	.word 0xd8f6c9e0  ! 3003: STXA_R	stxa	%r12, [%r27 + %r0] 0x4f
	.word 0x87802072  ! 3004: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6a52000  ! 3005: STWA_I	stwa	%r11, [%r20 + 0x0000] %asi
	.word 0xdaad84a0  ! 3006: STBA_R	stba	%r13, [%r22 + %r0] 0x25
	.word 0xdeb5e000  ! 3007: STHA_I	stha	%r15, [%r23 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	mov	0x8, %r26
	.word 0x87802072  ! 3010: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3011: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x7f8, %r20
	.word 0xdedfa000  ! 3013: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r15
	.word 0xdea7a000  ! 3014: STWA_I	stwa	%r15, [%r30 + 0x0000] %asi
	.word 0xd2b584a0  ! 3015: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xdec76000  ! 3016: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r15
	.word 0xd2bf4e80  ! 3017: STDA_R	stda	%r9, [%r29 + %r0] 0x74
	.word 0xd487e000  ! 3018: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd2df8e40  ! 3019: LDXA_R	ldxa	[%r30, %r0] 0x72, %r9
	.word 0x87802072  ! 3020: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bca000  ! 3021: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd2c46000  ! 3022: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r9
	.word 0x87802025  ! 3023: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2942000  ! 3024: LDUHA_I	lduha	[%r16, + 0x0000] %asi, %r9
	.word 0xd0dc4400  ! 3025: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	mov	0x78, %r16
	mov	0x20, %r17
	.word 0xde94c400  ! 3028: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	mov	0x58, %r19
	mov	0x78, %r26
	.word 0x87802072  ! 3031: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3032: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd88d84a0  ! 3033: LDUBA_R	lduba	[%r22, %r0] 0x25, %r12
	.word 0x87802020  ! 3034: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x50, %r18
	mov	0x68, %r18
	mov	0x38, %r18
	mov	0x7c8, %r20
	.word 0xde972000  ! 3039: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xde9fe000  ! 3040: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r15
	.word 0x87802025  ! 3041: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebfa000  ! 3042: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0x87802074  ! 3043: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x20, %r19
	mov	0x7e8, %r23
	.word 0xdcdcc400  ! 3046: LDXA_R	ldxa	[%r19, %r0] 0x20, %r14
	.word 0xd4af6000  ! 3047: STBA_I	stba	%r10, [%r29 + 0x0000] %asi
	.word 0xd4d76000  ! 3048: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	mov	0x7e0, %r21
	.word 0xd4872000  ! 3050: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd2bfce40  ! 3051: STDA_R	stda	%r9, [%r31 + %r0] 0x72
	.word 0xd69f6000  ! 3052: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd6b76000  ! 3053: STHA_I	stha	%r11, [%r29 + 0x0000] %asi
	mov	0x70, %r17
	.word 0xd6d7a000  ! 3055: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r11
	.word 0xd68c8400  ! 3056: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xd68f2000  ! 3057: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r11
	.word 0xdaf504a0  ! 3058: STXA_R	stxa	%r13, [%r20 + %r0] 0x25
	mov	0x7d8, %r21
	.word 0xd2f76000  ! 3060: STXA_I	stxa	%r9, [%r29 + 0x0000] %asi
	.word 0xd49f0e40  ! 3061: LDDA_R	ldda	[%r28, %r0] 0x72, %r10
	mov	0x7f8, %r20
	.word 0xdacf8e80  ! 3063: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r13
	mov	0x3e8, %r20
	.word 0x87802020  ! 3065: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6c76000  ! 3066: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r11
	.word 0xd6c7e000  ! 3067: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6b7e000  ! 3068: STHA_I	stha	%r11, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 3069: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2dc4400  ! 3070: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xdcd40400  ! 3071: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r14
	mov	0x68, %r19
	mov	0x60, %r24
	.word 0xd0a7a000  ! 3074: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	.word 0xd0cf2000  ! 3075: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0b76000  ! 3076: STHA_I	stha	%r8, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 3077: WRASI_I	wr	%r0, 0x0025, %asi
	ta	T_CHANGE_HPRIV	! macro
	.word 0xd0c4a000  ! 3079: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r8
	.word 0xd0a46000  ! 3080: STWA_I	stwa	%r8, [%r17 + 0x0000] %asi
	.word 0xd0b46000  ! 3081: STHA_I	stha	%r8, [%r17 + 0x0000] %asi
	.word 0xd09c0400  ! 3082: LDDA_R	ldda	[%r16, %r0] 0x20, %r8
	.word 0x87802073  ! 3083: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd49fa000  ! 3084: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3085: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6acc400  ! 3086: STBA_R	stba	%r11, [%r19 + %r0] 0x20
	mov	0x10, %r26
	.word 0xd4aec9e0  ! 3088: STBA_R	stba	%r10, [%r27 + %r0] 0x4f
	mov	0x68, %r24
	.word 0xd4dfce80  ! 3090: LDXA_R	ldxa	[%r31, %r0] 0x74, %r10
	mov	0x28, %r26
	.word 0x87802073  ! 3092: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcaf4e40  ! 3093: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	.word 0x87802073  ! 3094: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8f44400  ! 3095: STXA_R	stxa	%r12, [%r17 + %r0] 0x20
	.word 0xd69f6000  ! 3096: LDDA_I	ldda	[%r29, + 0x0000] %asi, %r11
	.word 0xd6d649e0  ! 3097: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	.word 0xd88609e0  ! 3098: LDUWA_R	lduwa	[%r24, %r0] 0x4f, %r12
	.word 0x87802020  ! 3099: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802025  ! 3100: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xda8ca000  ! 3101: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r13
	mov	0x0, %r26
	.word 0xd4f78e60  ! 3103: STXA_R	stxa	%r10, [%r30 + %r0] 0x73
	mov	0x7c8, %r23
	mov	0x50, %r26
	.word 0xd6cc8400  ! 3106: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r11
	mov	0x68, %r17
	.word 0xda9f8e40  ! 3108: LDDA_R	ldda	[%r30, %r0] 0x72, %r13
	mov	0x78, %r24
	.word 0xd294a000  ! 3110: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r9
	.word 0xd2dc6000  ! 3111: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r9
	.word 0xd28ce000  ! 3112: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r9
	.word 0x87802025  ! 3113: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd2f56000  ! 3114: STXA_I	stxa	%r9, [%r21 + 0x0000] %asi
	mov	0x7d8, %r22
	.word 0xd0cf4e80  ! 3116: LDSBA_R	ldsba	[%r29, %r0] 0x74, %r8
	mov	0x3f8, %r21
	mov	0x3d0, %r21
	.word 0xd6b544a0  ! 3119: STHA_R	stha	%r11, [%r21 + %r0] 0x25
	.word 0xdece49e0  ! 3120: LDSBA_R	ldsba	[%r25, %r0] 0x4f, %r15
	.word 0xd0f52000  ! 3121: STXA_I	stxa	%r8, [%r20 + 0x0000] %asi
	.word 0xd0ade000  ! 3122: STBA_I	stba	%r8, [%r23 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xd0bda000  ! 3124: STDA_I	stda	%r8, [%r22 + 0x0000] %asi
	mov	0x7c8, %r21
	.word 0xd0dd6000  ! 3126: LDXA_I	ldxa	[%r21, + 0x0000] %asi, %r8
	.word 0xd09de000  ! 3127: LDDA_I	ldda	[%r23, + 0x0000] %asi, %r8
	.word 0xd6944400  ! 3128: LDUHA_R	lduha	[%r17, %r0] 0x20, %r11
	.word 0xdebd6000  ! 3129: STDA_I	stda	%r15, [%r21 + 0x0000] %asi
	.word 0xdea56000  ! 3130: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0xd8a4c400  ! 3131: STWA_R	stwa	%r12, [%r19 + %r0] 0x20
	mov	0x50, %r27
	.word 0xd0a52000  ! 3133: STWA_I	stwa	%r8, [%r20 + 0x0000] %asi
	.word 0x87802025  ! 3134: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0cf2000  ! 3135: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd694c400  ! 3136: LDUHA_R	lduha	[%r19, %r0] 0x20, %r11
	mov	0x0, %r27
	.word 0x87802025  ! 3138: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xde8f4e80  ! 3139: LDUBA_R	lduba	[%r29, %r0] 0x74, %r15
	mov	0x7e0, %r20
	mov	0x60, %r25
	mov	0x20, %r17
	.word 0xdcc78e80  ! 3143: LDSWA_R	ldswa	[%r30, %r0] 0x74, %r14
	.word 0x87802072  ! 3144: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdad44400  ! 3145: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xd6cf0e40  ! 3146: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r11
	.word 0x87802072  ! 3147: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdcd78e60  ! 3148: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r14
	.word 0xd2bca000  ! 3149: STDA_I	stda	%r9, [%r18 + 0x0000] %asi
	.word 0xd2d4e000  ! 3150: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r9
	.word 0xd48d84a0  ! 3151: LDUBA_R	lduba	[%r22, %r0] 0x25, %r10
	.word 0x87802072  ! 3152: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2b7ce60  ! 3153: STHA_R	stha	%r9, [%r31 + %r0] 0x73
	.word 0xd4afa000  ! 3154: STBA_I	stba	%r10, [%r30 + 0x0000] %asi
	mov	0x68, %r16
	mov	0x70, %r24
	mov	0x30, %r26
	.word 0xd4a7a000  ! 3158: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4bf2000  ! 3159: STDA_I	stda	%r10, [%r28 + 0x0000] %asi
	mov	0x0, %r17
	.word 0xd2cc8400  ! 3161: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r9
	.word 0xd2c7a000  ! 3162: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r9
	.word 0xd2cfa000  ! 3163: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0x87802072  ! 3164: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ac6000  ! 3165: STBA_I	stba	%r9, [%r17 + 0x0000] %asi
	.word 0xd29ce000  ! 3166: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r9
	.word 0xd88c0400  ! 3167: LDUBA_R	lduba	[%r16, %r0] 0x20, %r12
	.word 0xdebfce60  ! 3168: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	.word 0x87802072  ! 3169: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x0, %r26
	mov	0x3e8, %r21
	.word 0xd696e000  ! 3172: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	mov	0x68, %r17
	.word 0xd087ce80  ! 3174: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r8
	mov	0x60, %r25
	mov	0x48, %r16
	.word 0xd696e000  ! 3177: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r11
	.word 0xd6a6a000  ! 3178: STWA_I	stwa	%r11, [%r26 + 0x0000] %asi
	mov	0x3e8, %r21
	.word 0xd6b6a000  ! 3180: STHA_I	stha	%r11, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3181: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3182: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6bfe000  ! 3183: STDA_I	stda	%r11, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 3184: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd2a40400  ! 3185: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	mov	0x7f8, %r23
	.word 0xd2afce60  ! 3187: STBA_R	stba	%r9, [%r31 + %r0] 0x73
	.word 0xdac4e000  ! 3188: LDSWA_I	ldswa	[%r19, + 0x0000] %asi, %r13
	mov	0x8, %r24
	.word 0xd4b70e80  ! 3190: STHA_R	stha	%r10, [%r28 + %r0] 0x74
	.word 0xd48544a0  ! 3191: LDUWA_R	lduwa	[%r21, %r0] 0x25, %r10
	.word 0x87802073  ! 3192: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdad44400  ! 3193: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r13
	.word 0xd2b7a000  ! 3194: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd2cfa000  ! 3195: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r9
	.word 0xd2bf6000  ! 3196: STDA_I	stda	%r9, [%r29 + 0x0000] %asi
	mov	0x60, %r27
	mov	0x48, %r18
	mov	0x7e0, %r21
	.word 0x87802072  ! 3200: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3201: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2cfe000  ! 3202: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r9
	.word 0xd2afa000  ! 3203: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	mov	0x10, %r25
	.word 0xd29fe000  ! 3205: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0xd6b7ce60  ! 3206: STHA_R	stha	%r11, [%r31 + %r0] 0x73
	.word 0xdcd7ce80  ! 3207: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r14
	.word 0xd8f72000  ! 3208: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8d7e000  ! 3209: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x50, %r25
	.word 0xd8872000  ! 3211: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3212: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcbe09e0  ! 3213: STDA_R	stda	%r14, [%r24 + %r0] 0x4f
	.word 0xd0dc0400  ! 3214: LDXA_R	ldxa	[%r16, %r0] 0x20, %r8
	.word 0xdabfce60  ! 3215: STDA_R	stda	%r13, [%r31 + %r0] 0x73
	.word 0x87802074  ! 3216: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802073  ! 3217: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcaf4e40  ! 3218: STBA_R	stba	%r14, [%r29 + %r0] 0x72
	mov	0x18, %r17
	.word 0xde94c400  ! 3220: LDUHA_R	lduha	[%r19, %r0] 0x20, %r15
	.word 0xdaa56000  ! 3221: STWA_I	stwa	%r13, [%r21 + 0x0000] %asi
	mov	0x0, %r19
	.word 0xdaf5a000  ! 3223: STXA_I	stxa	%r13, [%r22 + 0x0000] %asi
	mov	0x3c0, %r21
	.word 0x87802020  ! 3225: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabf6000  ! 3226: STDA_I	stda	%r13, [%r29 + 0x0000] %asi
	.word 0xdab40400  ! 3227: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x38, %r18
	.word 0xd8f78e60  ! 3229: STXA_R	stxa	%r12, [%r30 + %r0] 0x73
	.word 0xd8bfe000  ! 3230: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xd8d7e000  ! 3231: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	mov	0x7d8, %r23
	.word 0xd8d7e000  ! 3233: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xdebe09e0  ! 3234: STDA_R	stda	%r15, [%r24 + %r0] 0x4f
	.word 0xde9e89e0  ! 3235: LDDA_R	ldda	[%r26, %r0] 0x4f, %r15
	.word 0xd89c8400  ! 3236: LDDA_R	ldda	[%r18, %r0] 0x20, %r12
	mov	0x10, %r27
	.word 0xd4a78e40  ! 3238: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xd8f74e40  ! 3239: STXA_R	stxa	%r12, [%r29 + %r0] 0x72
	.word 0xdecf8e80  ! 3240: LDSBA_R	ldsba	[%r30, %r0] 0x74, %r15
	.word 0xd687a000  ! 3241: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r11
	mov	0x3d0, %r22
	.word 0x8780204f  ! 3243: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0x87802020  ! 3244: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x87802073  ! 3245: WRASI_I	wr	%r0, 0x0073, %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0x87802073  ! 3247: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xde9c8400  ! 3248: LDDA_R	ldda	[%r18, %r0] 0x20, %r15
	.word 0xdebe6000  ! 3249: STDA_I	stda	%r15, [%r25 + 0x0000] %asi
	.word 0xdabf0e60  ! 3250: STDA_R	stda	%r13, [%r28 + %r0] 0x73
	.word 0xd0ae6000  ! 3251: STBA_I	stba	%r8, [%r25 + 0x0000] %asi
	.word 0x87802074  ! 3252: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0bca000  ! 3253: STDA_I	stda	%r8, [%r18 + 0x0000] %asi
	.word 0xd0842000  ! 3254: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r8
	.word 0xd0b42000  ! 3255: STHA_I	stha	%r8, [%r16 + 0x0000] %asi
	.word 0xd0ac6000  ! 3256: STBA_I	stba	%r8, [%r17 + 0x0000] %asi
	.word 0xdeb70e60  ! 3257: STHA_R	stha	%r15, [%r28 + %r0] 0x73
	mov	0x30, %r27
	.word 0xd2b78e60  ! 3259: STHA_R	stha	%r9, [%r30 + %r0] 0x73
	mov	0x38, %r19
	mov	0x18, %r16
	mov	0x38, %r18
	.word 0x87802073  ! 3263: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 3264: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r17
	mov	0x38, %r16
	.word 0xdea6c9e0  ! 3267: STWA_R	stwa	%r15, [%r27 + %r0] 0x4f
	.word 0xdca78e40  ! 3268: STWA_R	stwa	%r14, [%r30 + %r0] 0x72
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xdcce89e0  ! 3270: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r14
	.word 0x87802073  ! 3271: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6f7ce80  ! 3272: STXA_R	stxa	%r11, [%r31 + %r0] 0x74
	.word 0xd6ac2000  ! 3273: STBA_I	stba	%r11, [%r16 + 0x0000] %asi
	.word 0xd6846000  ! 3274: LDUWA_I	lduwa	[%r17, + 0x0000] %asi, %r11
	.word 0x87802025  ! 3275: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3276: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r24
	mov	0x18, %r24
	.word 0xd6afa000  ! 3279: STBA_I	stba	%r11, [%r30 + 0x0000] %asi
	.word 0xd2b70e60  ! 3280: STHA_R	stha	%r9, [%r28 + %r0] 0x73
	.word 0xdca78e80  ! 3281: STWA_R	stwa	%r14, [%r30 + %r0] 0x74
	.word 0xd48c0400  ! 3282: LDUBA_R	lduba	[%r16, %r0] 0x20, %r10
	.word 0xd6d7ce80  ! 3283: LDSHA_R	ldsha	[%r31, %r0] 0x74, %r11
	mov	0x7f8, %r22
	.word 0xdea76000  ! 3285: STWA_I	stwa	%r15, [%r29 + 0x0000] %asi
	.word 0x87802025  ! 3286: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebfa000  ! 3287: STDA_I	stda	%r15, [%r30 + 0x0000] %asi
	.word 0xdeaf6000  ! 3288: STBA_I	stba	%r15, [%r29 + 0x0000] %asi
	.word 0x8780204f  ! 3289: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdac40400  ! 3290: LDSWA_R	ldswa	[%r16, %r0] 0x20, %r13
	mov	0x58, %r16
	.word 0x87802073  ! 3292: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd8c72000  ! 3293: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r12
	.word 0xd8bfe000  ! 3294: STDA_I	stda	%r12, [%r31 + 0x0000] %asi
	.word 0xda86c9e0  ! 3295: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r13
	.word 0xdcc7e000  ! 3296: LDSWA_I	ldswa	[%r31, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3297: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3d0, %r23
	.word 0xdca7e000  ! 3299: STWA_I	stwa	%r14, [%r31 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xd4ac0400  ! 3301: STBA_R	stba	%r10, [%r16 + %r0] 0x20
	.word 0xd2976000  ! 3302: LDUHA_I	lduha	[%r29, + 0x0000] %asi, %r9
	.word 0xd29fa000  ! 3303: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r9
	.word 0xd2876000  ! 3304: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r9
	mov	0x48, %r19
	.word 0xd08f4e80  ! 3306: LDUBA_R	lduba	[%r29, %r0] 0x74, %r8
	.word 0x87802020  ! 3307: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdeaf4e40  ! 3308: STBA_R	stba	%r15, [%r29 + %r0] 0x72
	.word 0x87802025  ! 3309: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd0f689e0  ! 3310: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0x87802073  ! 3311: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdcafce60  ! 3312: STBA_R	stba	%r14, [%r31 + %r0] 0x73
	.word 0xd0ce09e0  ! 3313: LDSBA_R	ldsba	[%r24, %r0] 0x4f, %r8
	.word 0xd4a5c4a0  ! 3314: STWA_R	stwa	%r10, [%r23 + %r0] 0x25
	mov	0x28, %r24
	.word 0xda8c4400  ! 3316: LDUBA_R	lduba	[%r17, %r0] 0x20, %r13
	.word 0xd6ac0400  ! 3317: STBA_R	stba	%r11, [%r16 + %r0] 0x20
	.word 0x8780204f  ! 3318: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdaa7a000  ! 3319: STWA_I	stwa	%r13, [%r30 + 0x0000] %asi
	mov	0x58, %r26
	.word 0xdaafa000  ! 3321: STBA_I	stba	%r13, [%r30 + 0x0000] %asi
	mov	0x7f0, %r20
	.word 0xda8fa000  ! 3323: LDUBA_I	lduba	[%r30, + 0x0000] %asi, %r13
	.word 0xda87ce80  ! 3324: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r13
	.word 0xdc8f2000  ! 3325: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r14
	.word 0xdaaf0e40  ! 3326: STBA_R	stba	%r13, [%r28 + %r0] 0x72
	.word 0xdab72000  ! 3327: STHA_I	stha	%r13, [%r28 + 0x0000] %asi
	.word 0xda9fe000  ! 3328: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	.word 0xdacfa000  ! 3329: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r13
	mov	0x50, %r18
	.word 0xda8fe000  ! 3331: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xd0d4c400  ! 3332: LDSHA_R	ldsha	[%r19, %r0] 0x20, %r8
	.word 0x87802025  ! 3333: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaa5c4a0  ! 3334: STWA_R	stwa	%r13, [%r23 + %r0] 0x25
	.word 0x87802025  ! 3335: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x7d8, %r20
	.word 0xd2afa000  ! 3337: STBA_I	stba	%r9, [%r30 + 0x0000] %asi
	.word 0xd095c4a0  ! 3338: LDUHA_R	lduha	[%r23, %r0] 0x25, %r8
	mov	0x68, %r19
	.word 0xdeb78e40  ! 3340: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	mov	0x38, %r26
	.word 0xd0aec9e0  ! 3342: STBA_R	stba	%r8, [%r27 + %r0] 0x4f
	.word 0x87802020  ! 3343: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdaa584a0  ! 3344: STWA_R	stwa	%r13, [%r22 + %r0] 0x25
	.word 0x87802020  ! 3345: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r22
	.word 0xded76000  ! 3347: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xd4ad44a0  ! 3348: STBA_R	stba	%r10, [%r21 + %r0] 0x25
	.word 0xd097e000  ! 3349: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r8
	.word 0xd0c72000  ! 3350: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r8
	mov	0x3c0, %r21
	.word 0xd0cf2000  ! 3352: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r8
	.word 0xd0a7a000  ! 3353: STWA_I	stwa	%r8, [%r30 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xd0b7e000  ! 3355: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x8780204f  ! 3356: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x68, %r19
	.word 0xd08de000  ! 3358: LDUBA_I	lduba	[%r23, + 0x0000] %asi, %r8
	.word 0xdcdf4e80  ! 3359: LDXA_R	ldxa	[%r29, %r0] 0x74, %r14
	mov	0x28, %r18
	.word 0xd0a70e60  ! 3361: STWA_R	stwa	%r8, [%r28 + %r0] 0x73
	.word 0xd0b609e0  ! 3362: STHA_R	stha	%r8, [%r24 + %r0] 0x4f
	mov	0x7c8, %r22
	mov	0x0, %r25
	.word 0xdea56000  ! 3365: STWA_I	stwa	%r15, [%r21 + 0x0000] %asi
	.word 0xdecd6000  ! 3366: LDSBA_I	ldsba	[%r21, + 0x0000] %asi, %r15
	.word 0x87802074  ! 3367: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd8f504a0  ! 3368: STXA_R	stxa	%r12, [%r20 + %r0] 0x25
	.word 0xd8b7ce60  ! 3369: STHA_R	stha	%r12, [%r31 + %r0] 0x73
	.word 0x87802072  ! 3370: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2c4c400  ! 3371: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r9
	.word 0xd6b74e80  ! 3372: STHA_R	stha	%r11, [%r29 + %r0] 0x74
	mov	0x7e8, %r20
	.word 0xdac46000  ! 3374: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r13
	.word 0xdcc7ce80  ! 3375: LDSWA_R	ldswa	[%r31, %r0] 0x74, %r14
	.word 0xd8ace000  ! 3376: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0x87802073  ! 3377: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r26
	mov	0x50, %r27
	.word 0xd8d7e000  ! 3380: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r12
	.word 0xdaa40400  ! 3381: STWA_R	stwa	%r13, [%r16 + %r0] 0x20
	.word 0xdabfe000  ! 3382: STDA_I	stda	%r13, [%r31 + 0x0000] %asi
	.word 0xdac72000  ! 3383: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r13
	.word 0xdadfa000  ! 3384: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r13
	mov	0x38, %r25
	.word 0xde86c9e0  ! 3386: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r15
	.word 0xdeafa000  ! 3387: STBA_I	stba	%r15, [%r30 + 0x0000] %asi
	.word 0xd8b504a0  ! 3388: STHA_R	stha	%r12, [%r20 + %r0] 0x25
	ta	T_CHANGE_HPRIV	! macro
	mov	0x7f0, %r20
	.word 0xdabfa000  ! 3391: STDA_I	stda	%r13, [%r30 + 0x0000] %asi
	mov	0x48, %r19
	.word 0xda9fe000  ! 3393: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r13
	mov	0x7d0, %r22
	.word 0x87802074  ! 3395: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0dfce60  ! 3396: LDXA_R	ldxa	[%r31, %r0] 0x73, %r8
	.word 0xdaf609e0  ! 3397: STXA_R	stxa	%r13, [%r24 + %r0] 0x4f
	.word 0xd4cca000  ! 3398: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	.word 0xd4a74e40  ! 3399: STWA_R	stwa	%r10, [%r29 + %r0] 0x72
	.word 0xd0f4a000  ! 3400: STXA_I	stxa	%r8, [%r18 + 0x0000] %asi
	.word 0xdeb584a0  ! 3401: STHA_R	stha	%r15, [%r22 + %r0] 0x25
	.word 0xdc8d84a0  ! 3402: LDUBA_R	lduba	[%r22, %r0] 0x25, %r14
	.word 0x87802074  ! 3403: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x70, %r25
	.word 0x87802020  ! 3405: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6978e40  ! 3406: LDUHA_R	lduha	[%r30, %r0] 0x72, %r11
	.word 0xda8504a0  ! 3407: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r13
	.word 0x87802020  ! 3408: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8d504a0  ! 3409: LDSHA_R	ldsha	[%r20, %r0] 0x25, %r12
	.word 0xdc948400  ! 3410: LDUHA_R	lduha	[%r18, %r0] 0x20, %r14
	.word 0xd0a6a000  ! 3411: STWA_I	stwa	%r8, [%r26 + 0x0000] %asi
	mov	0x50, %r16
	.word 0xd0ae2000  ! 3413: STBA_I	stba	%r8, [%r24 + 0x0000] %asi
	.word 0xd4a584a0  ! 3414: STWA_R	stwa	%r10, [%r22 + %r0] 0x25
	mov	0x3f8, %r21
	.word 0xdc94c400  ! 3416: LDUHA_R	lduha	[%r19, %r0] 0x20, %r14
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0xd8c48400  ! 3418: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r12
	.word 0xdcce6000  ! 3419: LDSBA_I	ldsba	[%r25, + 0x0000] %asi, %r14
	.word 0x87802072  ! 3420: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x70, %r27
	.word 0xdcae6000  ! 3422: STBA_I	stba	%r14, [%r25 + 0x0000] %asi
	.word 0x87802072  ! 3423: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r26
	.word 0xdcdc6000  ! 3425: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0x87802020  ! 3426: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xda9f0e60  ! 3427: LDDA_R	ldda	[%r28, %r0] 0x73, %r13
	.word 0x87802020  ! 3428: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x7e8, %r23
	mov	0x3d0, %r23
	.word 0xd88ca000  ! 3431: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r12
	mov	0x10, %r26
	.word 0x87802025  ! 3433: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcbc4400  ! 3434: STDA_R	stda	%r14, [%r17 + %r0] 0x20
	.word 0xd6a7a000  ! 3435: STWA_I	stwa	%r11, [%r30 + 0x0000] %asi
	.word 0xd6bf2000  ! 3436: STDA_I	stda	%r11, [%r28 + 0x0000] %asi
	.word 0x87802072  ! 3437: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802073  ! 3438: WRASI_I	wr	%r0, 0x0073, %asi
	mov	0x8, %r19
	mov	0x68, %r18
	mov	0x3f0, %r22
	.word 0xd6bfce80  ! 3442: STDA_R	stda	%r11, [%r31 + %r0] 0x74
	.word 0xd0f689e0  ! 3443: STXA_R	stxa	%r8, [%r26 + %r0] 0x4f
	.word 0xd6c48400  ! 3444: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r11
	.word 0xd4c76000  ! 3445: LDSWA_I	ldswa	[%r29, + 0x0000] %asi, %r10
	.word 0xd48f6000  ! 3446: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r10
	.word 0xdeacc400  ! 3447: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xd0b7e000  ! 3448: STHA_I	stha	%r8, [%r31 + 0x0000] %asi
	.word 0x87802074  ! 3449: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd0f7a000  ! 3450: STXA_I	stxa	%r8, [%r30 + 0x0000] %asi
	mov	0x70, %r19
	mov	0x0, %r26
	.word 0xd2cf0e40  ! 3453: LDSBA_R	ldsba	[%r28, %r0] 0x72, %r9
	.word 0x87802072  ! 3454: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2bc6000  ! 3455: STDA_I	stda	%r9, [%r17 + 0x0000] %asi
	ta	T_CHANGE_PRIV	! macro
	.word 0xdaa649e0  ! 3457: STWA_R	stwa	%r13, [%r25 + %r0] 0x4f
	mov	0x3d8, %r20
	.word 0x87802072  ! 3459: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4a72000  ! 3460: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xd4afe000  ! 3461: STBA_I	stba	%r10, [%r31 + 0x0000] %asi
	.word 0x87802072  ! 3462: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4dc6000  ! 3463: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r10
	.word 0xd48c2000  ! 3464: LDUBA_I	lduba	[%r16, + 0x0000] %asi, %r10
	.word 0xd49c6000  ! 3465: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	.word 0xda8f0e60  ! 3466: LDUBA_R	lduba	[%r28, %r0] 0x73, %r13
	.word 0xd89ce000  ! 3467: LDDA_I	ldda	[%r19, + 0x0000] %asi, %r12
	.word 0xd8ace000  ! 3468: STBA_I	stba	%r12, [%r19 + 0x0000] %asi
	.word 0xd8946000  ! 3469: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r12
	.word 0x87802073  ! 3470: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802072  ! 3471: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd8d42000  ! 3472: LDSHA_I	ldsha	[%r16, + 0x0000] %asi, %r12
	.word 0xdca544a0  ! 3473: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd6f7ce60  ! 3474: STXA_R	stxa	%r11, [%r31 + %r0] 0x73
	.word 0x87802073  ! 3475: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdca689e0  ! 3476: STWA_R	stwa	%r14, [%r26 + %r0] 0x4f
	mov	0x7c8, %r23
	.word 0xd88ec9e0  ! 3478: LDUBA_R	lduba	[%r27, %r0] 0x4f, %r12
	.word 0xde8cc400  ! 3479: LDUBA_R	lduba	[%r19, %r0] 0x20, %r15
	.word 0xd0bea000  ! 3480: STDA_I	stda	%r8, [%r26 + 0x0000] %asi
	.word 0xd0962000  ! 3481: LDUHA_I	lduha	[%r24, + 0x0000] %asi, %r8
	.word 0xd48f4e40  ! 3482: LDUBA_R	lduba	[%r29, %r0] 0x72, %r10
	mov	0x40, %r16
	.word 0xd2ad04a0  ! 3484: STBA_R	stba	%r9, [%r20 + %r0] 0x25
	.word 0xde8c8400  ! 3485: LDUBA_R	lduba	[%r18, %r0] 0x20, %r15
	mov	0x7d8, %r22
	mov	0x68, %r26
	mov	0x68, %r18
	.word 0xd89e6000  ! 3489: LDDA_I	ldda	[%r25, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802020  ! 3491: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd894a000  ! 3492: LDUHA_I	lduha	[%r18, + 0x0000] %asi, %r12
	.word 0xd8a4e000  ! 3493: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0xd2b584a0  ! 3494: STHA_R	stha	%r9, [%r22 + %r0] 0x25
	.word 0xd8b7ce80  ! 3495: STHA_R	stha	%r12, [%r31 + %r0] 0x74
	.word 0xdeace000  ! 3496: STBA_I	stba	%r15, [%r19 + 0x0000] %asi
	.word 0xdef42000  ! 3497: STXA_I	stxa	%r15, [%r16 + 0x0000] %asi
	.word 0xd8d70e40  ! 3498: LDSHA_R	ldsha	[%r28, %r0] 0x72, %r12
	.word 0x87802073  ! 3499: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd6b78e80  ! 3500: STHA_R	stha	%r11, [%r30 + %r0] 0x74
	.word 0xd8f70e80  ! 3501: STXA_R	stxa	%r12, [%r28 + %r0] 0x74
	.word 0xd6ae49e0  ! 3502: STBA_R	stba	%r11, [%r25 + %r0] 0x4f
	mov	0x3e8, %r21
	.word 0xd2d7e000  ! 3504: LDSHA_I	ldsha	[%r31, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 3505: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdacc0400  ! 3506: LDSBA_R	ldsba	[%r16, %r0] 0x20, %r13
	.word 0xdef7e000  ! 3507: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x10, %r18
	.word 0xdc9e09e0  ! 3509: LDDA_R	ldda	[%r24, %r0] 0x4f, %r14
	mov	0x68, %r16
	.word 0xd2b7a000  ! 3511: STHA_I	stha	%r9, [%r30 + 0x0000] %asi
	.word 0xd09cc400  ! 3512: LDDA_R	ldda	[%r19, %r0] 0x20, %r8
	mov	0x40, %r18
	.word 0xdcde09e0  ! 3514: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r14
	.word 0xd487e000  ! 3515: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r10
	.word 0xd4a76000  ! 3516: STWA_I	stwa	%r10, [%r29 + 0x0000] %asi
	.word 0xd4cf2000  ! 3517: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0xd4f7e000  ! 3518: STXA_I	stxa	%r10, [%r31 + 0x0000] %asi
	.word 0x87802020  ! 3519: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x18, %r17
	.word 0xd4c6e000  ! 3521: LDSWA_I	ldswa	[%r27, + 0x0000] %asi, %r10
	mov	0x68, %r16
	.word 0xd4b7ce80  ! 3523: STHA_R	stha	%r10, [%r31 + %r0] 0x74
	.word 0x87802073  ! 3524: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802025  ! 3525: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdebee000  ! 3526: STDA_I	stda	%r15, [%r27 + 0x0000] %asi
	.word 0x87802072  ! 3527: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r24
	.word 0xdec609e0  ! 3529: LDSWA_R	ldswa	[%r24, %r0] 0x4f, %r15
	.word 0xdc9f0e40  ! 3530: LDDA_R	ldda	[%r28, %r0] 0x72, %r14
	.word 0x87802020  ! 3531: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x0, %r18
	.word 0xdeb4e000  ! 3533: STHA_I	stha	%r15, [%r19 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xdadcc400  ! 3535: LDXA_R	ldxa	[%r19, %r0] 0x20, %r13
	.word 0xdeac8400  ! 3536: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x3d8, %r22
	.word 0xd6bc6000  ! 3538: STDA_I	stda	%r11, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 3539: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3540: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r20
	.word 0x87802020  ! 3542: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdabc8400  ! 3543: STDA_R	stda	%r13, [%r18 + %r0] 0x20
	.word 0xd0bf4e80  ! 3544: STDA_R	stda	%r8, [%r29 + %r0] 0x74
	mov	0x68, %r17
	.word 0xd8f48400  ! 3546: STXA_R	stxa	%r12, [%r18 + %r0] 0x20
	.word 0xd4a42000  ! 3547: STWA_I	stwa	%r10, [%r16 + 0x0000] %asi
	mov	0x3e0, %r23
	.word 0xd4bc2000  ! 3549: STDA_I	stda	%r10, [%r16 + 0x0000] %asi
	mov	0x3e8, %r23
	.word 0xd4d4a000  ! 3551: LDSHA_I	ldsha	[%r18, + 0x0000] %asi, %r10
	.word 0xd4874e60  ! 3552: LDUWA_R	lduwa	[%r29, %r0] 0x73, %r10
	mov	0x30, %r25
	.word 0xd2946000  ! 3554: LDUHA_I	lduha	[%r17, + 0x0000] %asi, %r9
	.word 0xd2cca000  ! 3555: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r9
	.word 0xd2b4a000  ! 3556: STHA_I	stha	%r9, [%r18 + 0x0000] %asi
	.word 0x87802020  ! 3557: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdebc8400  ! 3558: STDA_R	stda	%r15, [%r18 + %r0] 0x20
	.word 0xdadda000  ! 3559: LDXA_I	ldxa	[%r22, + 0x0000] %asi, %r13
	.word 0x87802074  ! 3560: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xd6d48400  ! 3561: LDSHA_R	ldsha	[%r18, %r0] 0x20, %r11
	.word 0x87802073  ! 3562: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd0b62000  ! 3563: STHA_I	stha	%r8, [%r24 + 0x0000] %asi
	.word 0x8780204f  ! 3564: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0afe000  ! 3565: STBA_I	stba	%r8, [%r31 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd4a4c400  ! 3567: STWA_R	stwa	%r10, [%r19 + %r0] 0x20
	.word 0xdeafce40  ! 3568: STBA_R	stba	%r15, [%r31 + %r0] 0x72
	ta	T_CHANGE_HPRIV	! macro
	.word 0x87802073  ! 3570: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 3571: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdcdfe000  ! 3572: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r14
	.word 0xdcd72000  ! 3573: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r14
	.word 0xd2c44400  ! 3574: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r9
	.word 0x87802073  ! 3575: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd69d6000  ! 3576: LDDA_I	ldda	[%r21, + 0x0000] %asi, %r11
	.word 0xd8a78e40  ! 3577: STWA_R	stwa	%r12, [%r30 + %r0] 0x72
	.word 0xd6bd6000  ! 3578: STDA_I	stda	%r11, [%r21 + 0x0000] %asi
	.word 0xd6856000  ! 3579: LDUWA_I	lduwa	[%r21, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3580: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd68e2000  ! 3581: LDUBA_I	lduba	[%r24, + 0x0000] %asi, %r11
	.word 0xd6aee000  ! 3582: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	.word 0x87802074  ! 3583: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x38, %r18
	.word 0x87802020  ! 3585: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd687e000  ! 3586: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd6a76000  ! 3587: STWA_I	stwa	%r11, [%r29 + 0x0000] %asi
	.word 0xd2d70e60  ! 3588: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r9
	.word 0xdaae49e0  ! 3589: STBA_R	stba	%r13, [%r25 + %r0] 0x4f
	.word 0xd4df6000  ! 3590: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3591: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4b7a000  ! 3592: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd4a7e000  ! 3593: STWA_I	stwa	%r10, [%r31 + 0x0000] %asi
	.word 0xd8f649e0  ! 3594: STXA_R	stxa	%r12, [%r25 + %r0] 0x4f
	.word 0x87802020  ! 3595: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8bf8e60  ! 3596: STDA_R	stda	%r12, [%r30 + %r0] 0x73
	.word 0xd0d7ce60  ! 3597: LDSHA_R	ldsha	[%r31, %r0] 0x73, %r8
	.word 0xdaad04a0  ! 3598: STBA_R	stba	%r13, [%r20 + %r0] 0x25
	mov	0x40, %r25
	mov	0x68, %r24
	.word 0xda97a000  ! 3601: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xda97a000  ! 3602: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	mov	0x3e8, %r23
	.word 0xd68c8400  ! 3604: LDUBA_R	lduba	[%r18, %r0] 0x20, %r11
	.word 0xd4dfa000  ! 3605: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r10
	.word 0xd4b7a000  ! 3606: STHA_I	stha	%r10, [%r30 + 0x0000] %asi
	.word 0xd48fe000  ! 3607: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r10
	mov	0x30, %r19
	.word 0xd4c72000  ! 3609: LDSWA_I	ldswa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4972000  ! 3610: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r10
	.word 0x87802072  ! 3611: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd4aca000  ! 3612: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	.word 0xd0bd04a0  ! 3613: STDA_R	stda	%r8, [%r20 + %r0] 0x25
	mov	0x58, %r19
	.word 0x87802074  ! 3615: WRASI_I	wr	%r0, 0x0074, %asi
	ta	T_CHANGE_HPRIV	! macro
	mov	0x3e8, %r20
	mov	0x10, %r16
	.word 0x8780204f  ! 3619: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xde8dc4a0  ! 3620: LDUBA_R	lduba	[%r23, %r0] 0x25, %r15
	.word 0xd0d44400  ! 3621: LDSHA_R	ldsha	[%r17, %r0] 0x20, %r8
	.word 0xd4af4e60  ! 3622: STBA_R	stba	%r10, [%r29 + %r0] 0x73
	mov	0x3d0, %r21
	.word 0xdadc6000  ! 3624: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r13
	mov	0x38, %r26
	mov	0x7d0, %r21
	.word 0xda8c6000  ! 3627: LDUBA_I	lduba	[%r17, + 0x0000] %asi, %r13
	.word 0x8780204f  ! 3628: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd08e49e0  ! 3629: LDUBA_R	lduba	[%r25, %r0] 0x4f, %r8
	.word 0xd4b5e000  ! 3630: STHA_I	stha	%r10, [%r23 + 0x0000] %asi
	.word 0xd4ad6000  ! 3631: STBA_I	stba	%r10, [%r21 + 0x0000] %asi
	.word 0x87802025  ! 3632: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x58, %r24
	.word 0xd4876000  ! 3634: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd0bf0e40  ! 3635: STDA_R	stda	%r8, [%r28 + %r0] 0x72
	.word 0xd2b7e000  ! 3636: STHA_I	stha	%r9, [%r31 + 0x0000] %asi
	.word 0xd2dfa000  ! 3637: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r9
	.word 0xda9f8e80  ! 3638: LDDA_R	ldda	[%r30, %r0] 0x74, %r13
	.word 0xdc9f0e80  ! 3639: LDDA_R	ldda	[%r28, %r0] 0x74, %r14
	.word 0xded72000  ! 3640: LDSHA_I	ldsha	[%r28, + 0x0000] %asi, %r15
	mov	0x3d8, %r22
	ta	T_CHANGE_PRIV	! macro
	.word 0xded76000  ! 3643: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r15
	.word 0xdecfe000  ! 3644: LDSBA_I	ldsba	[%r31, + 0x0000] %asi, %r15
	.word 0xdaafce40  ! 3645: STBA_R	stba	%r13, [%r31 + %r0] 0x72
	.word 0xd8afa000  ! 3646: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0x87802072  ! 3647: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802020  ! 3648: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8dea000  ! 3649: LDXA_I	ldxa	[%r26, + 0x0000] %asi, %r12
	.word 0xd8a66000  ! 3650: STWA_I	stwa	%r12, [%r25 + 0x0000] %asi
	.word 0xd8862000  ! 3651: LDUWA_I	lduwa	[%r24, + 0x0000] %asi, %r12
	.word 0xd89ea000  ! 3652: LDDA_I	ldda	[%r26, + 0x0000] %asi, %r12
	.word 0xd6af0e80  ! 3653: STBA_R	stba	%r11, [%r28 + %r0] 0x74
	mov	0x68, %r27
	mov	0x3f0, %r23
	.word 0xdedf4e80  ! 3656: LDXA_R	ldxa	[%r29, %r0] 0x74, %r15
	mov	0x3c0, %r20
	.word 0xd0f4c400  ! 3658: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	.word 0xdef74e40  ! 3659: STXA_R	stxa	%r15, [%r29 + %r0] 0x72
	.word 0xd2b44400  ! 3660: STHA_R	stha	%r9, [%r17 + %r0] 0x20
	.word 0xd8a6a000  ! 3661: STWA_I	stwa	%r12, [%r26 + 0x0000] %asi
	.word 0xd4f78e40  ! 3662: STXA_R	stxa	%r10, [%r30 + %r0] 0x72
	mov	0x3e0, %r20
	.word 0xd4b70e40  ! 3664: STHA_R	stha	%r10, [%r28 + %r0] 0x72
	.word 0xd6c66000  ! 3665: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	.word 0xd6a6e000  ! 3666: STWA_I	stwa	%r11, [%r27 + 0x0000] %asi
	.word 0xd8a689e0  ! 3667: STWA_R	stwa	%r12, [%r26 + %r0] 0x4f
	.word 0x87802025  ! 3668: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdaf74e40  ! 3669: STXA_R	stxa	%r13, [%r29 + %r0] 0x72
	.word 0xd0df6000  ! 3670: LDXA_I	ldxa	[%r29, + 0x0000] %asi, %r8
	.word 0xd8d78e40  ! 3671: LDSHA_R	ldsha	[%r30, %r0] 0x72, %r12
	.word 0xd8d76000  ! 3672: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r12
	ta	T_CHANGE_NONHPRIV	! macro
	.word 0x87802073  ! 3674: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xd88f6000  ! 3675: LDUBA_I	lduba	[%r29, + 0x0000] %asi, %r12
	.word 0xd0dc4400  ! 3676: LDXA_R	ldxa	[%r17, %r0] 0x20, %r8
	.word 0xd8cf0e60  ! 3677: LDSBA_R	ldsba	[%r28, %r0] 0x73, %r12
	mov	0x38, %r27
	.word 0xdab40400  ! 3679: STHA_R	stha	%r13, [%r16 + %r0] 0x20
	mov	0x68, %r17
	.word 0xdcf7e000  ! 3681: STXA_I	stxa	%r14, [%r31 + 0x0000] %asi
	.word 0x87802025  ! 3682: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xdcb7a000  ! 3683: STHA_I	stha	%r14, [%r30 + 0x0000] %asi
	.word 0xdcaf6000  ! 3684: STBA_I	stba	%r14, [%r29 + 0x0000] %asi
	.word 0xdcb76000  ! 3685: STHA_I	stha	%r14, [%r29 + 0x0000] %asi
	mov	0x8, %r18
	.word 0xd8c7ce60  ! 3687: LDSWA_R	ldswa	[%r31, %r0] 0x73, %r12
	.word 0xd4872000  ! 3688: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4cf2000  ! 3689: LDSBA_I	ldsba	[%r28, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3690: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x50, %r16
	.word 0xdab44400  ! 3692: STHA_R	stha	%r13, [%r17 + %r0] 0x20
	.word 0x87802072  ! 3693: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd2ddc4a0  ! 3694: LDXA_R	ldxa	[%r23, %r0] 0x25, %r9
	mov	0x50, %r25
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x87802072  ! 3697: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x78, %r25
	mov	0x10, %r18
	.word 0xd4ae09e0  ! 3700: STBA_R	stba	%r10, [%r24 + %r0] 0x4f
	.word 0xdad7a000  ! 3701: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r13
	.word 0xdeaf8e40  ! 3702: STBA_R	stba	%r15, [%r30 + %r0] 0x72
	.word 0xd6dc0400  ! 3703: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	mov	0x0, %r27
	.word 0xd4876000  ! 3705: LDUWA_I	lduwa	[%r29, + 0x0000] %asi, %r10
	.word 0xd49fa000  ! 3706: LDDA_I	ldda	[%r30, + 0x0000] %asi, %r10
	.word 0xd49fe000  ! 3707: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r10
	mov	0x7d0, %r21
	.word 0xd4f76000  ! 3709: STXA_I	stxa	%r10, [%r29 + 0x0000] %asi
	.word 0x87802074  ! 3710: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x87802072  ! 3711: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd6de09e0  ! 3712: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r11
	.word 0xd0af8e60  ! 3713: STBA_R	stba	%r8, [%r30 + %r0] 0x73
	.word 0x87802072  ! 3714: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdabcc400  ! 3715: STDA_R	stda	%r13, [%r19 + %r0] 0x20
	.word 0xd687e000  ! 3716: LDUWA_I	lduwa	[%r31, + 0x0000] %asi, %r11
	.word 0xd0df4e60  ! 3717: LDXA_R	ldxa	[%r29, %r0] 0x73, %r8
	mov	0x7c8, %r21
	mov	0x7e0, %r20
	mov	0x18, %r18
	.word 0xdcc48400  ! 3721: LDSWA_R	ldswa	[%r18, %r0] 0x20, %r14
	mov	0x40, %r18
	.word 0xdc8f4e80  ! 3723: LDUBA_R	lduba	[%r29, %r0] 0x74, %r14
	.word 0x8780204f  ! 3724: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdebe89e0  ! 3725: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	.word 0xd4842000  ! 3726: LDUWA_I	lduwa	[%r16, + 0x0000] %asi, %r10
	.word 0xd4a4e000  ! 3727: STWA_I	stwa	%r10, [%r19 + 0x0000] %asi
	.word 0xdef78e60  ! 3728: STXA_R	stxa	%r15, [%r30 + %r0] 0x73
	mov	0x48, %r16
	.word 0xd89f8e40  ! 3730: LDDA_R	ldda	[%r30, %r0] 0x72, %r12
	mov	0x3f0, %r20
	.word 0xd8a4e000  ! 3732: STWA_I	stwa	%r12, [%r19 + 0x0000] %asi
	.word 0x87802025  ! 3733: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd8b7e000  ! 3734: STHA_I	stha	%r12, [%r31 + 0x0000] %asi
	mov	0x0, %r25
	.word 0x87802072  ! 3736: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x8780204f  ! 3737: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0ae49e0  ! 3738: STBA_R	stba	%r8, [%r25 + %r0] 0x4f
	mov	0x78, %r24
	mov	0x70, %r16
	.word 0x8780204f  ! 3741: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd4a40400  ! 3742: STWA_R	stwa	%r10, [%r16 + %r0] 0x20
	.word 0xdef40400  ! 3743: STXA_R	stxa	%r15, [%r16 + %r0] 0x20
	.word 0xd4cca000  ! 3744: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r10
	mov	0x78, %r27
	.word 0xd4d4e000  ! 3746: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0xd2adc4a0  ! 3747: STBA_R	stba	%r9, [%r23 + %r0] 0x25
	mov	0x3f8, %r23
	.word 0xd8dc2000  ! 3749: LDXA_I	ldxa	[%r16, + 0x0000] %asi, %r12
	.word 0x87802020  ! 3750: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd2b48400  ! 3751: STHA_R	stha	%r9, [%r18 + %r0] 0x20
	.word 0xd8a7a000  ! 3752: STWA_I	stwa	%r12, [%r30 + 0x0000] %asi
	.word 0x87802025  ! 3753: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd884c400  ! 3754: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r12
	.word 0xdec7ce40  ! 3755: LDSWA_R	ldswa	[%r31, %r0] 0x72, %r15
	.word 0xd4b76000  ! 3756: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0xd4a7a000  ! 3757: STWA_I	stwa	%r10, [%r30 + 0x0000] %asi
	.word 0xd4872000  ! 3758: LDUWA_I	lduwa	[%r28, + 0x0000] %asi, %r10
	.word 0xd4d7a000  ! 3759: LDSHA_I	ldsha	[%r30, + 0x0000] %asi, %r10
	.word 0xd4b76000  ! 3760: STHA_I	stha	%r10, [%r29 + 0x0000] %asi
	.word 0x87802072  ! 3761: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802074  ! 3762: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 3763: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x0, %r16
	mov	0x3d0, %r21
	.word 0xd486e000  ! 3766: LDUWA_I	lduwa	[%r27, + 0x0000] %asi, %r10
	mov	0x3c0, %r21
	.word 0xd496e000  ! 3768: LDUHA_I	lduha	[%r27, + 0x0000] %asi, %r10
	.word 0xd4d70e80  ! 3769: LDSHA_R	ldsha	[%r28, %r0] 0x74, %r10
	.word 0xd4966000  ! 3770: LDUHA_I	lduha	[%r25, + 0x0000] %asi, %r10
	mov	0x68, %r17
	.word 0xd4b6e000  ! 3772: STHA_I	stha	%r10, [%r27 + 0x0000] %asi
	.word 0xd4c62000  ! 3773: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r10
	.word 0xd48f8e40  ! 3774: LDUBA_R	lduba	[%r30, %r0] 0x72, %r10
	.word 0xd6c62000  ! 3775: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r11
	.word 0xd6de6000  ! 3776: LDXA_I	ldxa	[%r25, + 0x0000] %asi, %r11
	.word 0xd6ae6000  ! 3777: STBA_I	stba	%r11, [%r25 + 0x0000] %asi
	.word 0xdeb4c400  ! 3778: STHA_R	stha	%r15, [%r19 + %r0] 0x20
	.word 0xdeb74e80  ! 3779: STHA_R	stha	%r15, [%r29 + %r0] 0x74
	.word 0xdebf8e40  ! 3780: STDA_R	stda	%r15, [%r30 + %r0] 0x72
	.word 0xd2f4c400  ! 3781: STXA_R	stxa	%r9, [%r19 + %r0] 0x20
	mov	0x20, %r25
	mov	0x60, %r26
	.word 0xdec649e0  ! 3784: LDSWA_R	ldswa	[%r25, %r0] 0x4f, %r15
	.word 0xd09c4400  ! 3785: LDDA_R	ldda	[%r17, %r0] 0x20, %r8
	mov	0x48, %r26
	.word 0xdaaee000  ! 3787: STBA_I	stba	%r13, [%r27 + 0x0000] %asi
	.word 0xdac6a000  ! 3788: LDSWA_I	ldswa	[%r26, + 0x0000] %asi, %r13
	.word 0xdaf6e000  ! 3789: STXA_I	stxa	%r13, [%r27 + 0x0000] %asi
	.word 0xd2ac8400  ! 3790: STBA_R	stba	%r9, [%r18 + %r0] 0x20
	mov	0x58, %r17
	mov	0x60, %r16
	mov	0x10, %r25
	.word 0xdcb62000  ! 3794: STHA_I	stha	%r14, [%r24 + 0x0000] %asi
	.word 0xdcbea000  ! 3795: STDA_I	stda	%r14, [%r26 + 0x0000] %asi
	mov	0x7e8, %r20
	.word 0xd8a44400  ! 3797: STWA_R	stwa	%r12, [%r17 + %r0] 0x20
	mov	0x7d0, %r21
	.word 0xdcc66000  ! 3799: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r14
	mov	0x58, %r24
	mov	0x10, %r25
	.word 0xdc8ea000  ! 3802: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r14
	mov	0x18, %r25
	.word 0x87802020  ! 3804: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x40, %r27
	.word 0x87802025  ! 3806: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802074  ! 3807: WRASI_I	wr	%r0, 0x0074, %asi
	mov	0x3c0, %r23
	.word 0xdcdfa000  ! 3809: LDXA_I	ldxa	[%r30, + 0x0000] %asi, %r14
	.word 0x87802025  ! 3810: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x10, %r19
	.word 0xdaa70e80  ! 3812: STWA_R	stwa	%r13, [%r28 + %r0] 0x74
	.word 0xd0b40400  ! 3813: STHA_R	stha	%r8, [%r16 + %r0] 0x20
	.word 0xdec44400  ! 3814: LDSWA_R	ldswa	[%r17, %r0] 0x20, %r15
	.word 0x87802020  ! 3815: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd8aec9e0  ! 3816: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	.word 0xd2bec9e0  ! 3817: STDA_R	stda	%r9, [%r27 + %r0] 0x4f
	.word 0xdca544a0  ! 3818: STWA_R	stwa	%r14, [%r21 + %r0] 0x25
	.word 0xd2f70e60  ! 3819: STXA_R	stxa	%r9, [%r28 + %r0] 0x73
	.word 0xd4a74e60  ! 3820: STWA_R	stwa	%r10, [%r29 + %r0] 0x73
	.word 0xded4e000  ! 3821: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r15
	mov	0x0, %r27
	.word 0xdebca000  ! 3823: STDA_I	stda	%r15, [%r18 + 0x0000] %asi
	.word 0xdeb4a000  ! 3824: STHA_I	stha	%r15, [%r18 + 0x0000] %asi
	.word 0xdeac6000  ! 3825: STBA_I	stba	%r15, [%r17 + 0x0000] %asi
	.word 0x87802025  ! 3826: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3827: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x3d0, %r23
	mov	0x48, %r25
	.word 0xd0b74e80  ! 3830: STHA_R	stha	%r8, [%r29 + %r0] 0x74
	.word 0xd6dfe000  ! 3831: LDXA_I	ldxa	[%r31, + 0x0000] %asi, %r11
	.word 0xded78e60  ! 3832: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r15
	mov	0x50, %r18
	.word 0xd6970e40  ! 3834: LDUHA_R	lduha	[%r28, %r0] 0x72, %r11
	.word 0xdaf76000  ! 3835: STXA_I	stxa	%r13, [%r29 + 0x0000] %asi
	mov	0x7e8, %r22
	.word 0xdadc8400  ! 3837: LDXA_R	ldxa	[%r18, %r0] 0x20, %r13
	.word 0xd0b72000  ! 3838: STHA_I	stha	%r8, [%r28 + 0x0000] %asi
	.word 0xd0a76000  ! 3839: STWA_I	stwa	%r8, [%r29 + 0x0000] %asi
	.word 0xd6dc8400  ! 3840: LDXA_R	ldxa	[%r18, %r0] 0x20, %r11
	ta	T_CHANGE_HPRIV	! macro
	mov	0x48, %r26
	.word 0xd0bf4e60  ! 3843: STDA_R	stda	%r8, [%r29 + %r0] 0x73
	.word 0x87802025  ! 3844: WRASI_I	wr	%r0, 0x0025, %asi
	mov	0x0, %r24
	.word 0x87802020  ! 3846: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3c0, %r21
	mov	0x38, %r24
	.word 0xd697e000  ! 3849: LDUHA_I	lduha	[%r31, + 0x0000] %asi, %r11
	.word 0x87802072  ! 3850: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd69f2000  ! 3851: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r11
	.word 0xde844400  ! 3852: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r15
	mov	0x0, %r27
	.word 0x87802020  ! 3854: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdac4a000  ! 3855: LDSWA_I	ldswa	[%r18, + 0x0000] %asi, %r13
	.word 0x87802020  ! 3856: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0x8780204f  ! 3857: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x60, %r18
	.word 0xda8fe000  ! 3859: LDUBA_I	lduba	[%r31, + 0x0000] %asi, %r13
	.word 0xdea78e80  ! 3860: STWA_R	stwa	%r15, [%r30 + %r0] 0x74
	.word 0xdc87ce80  ! 3861: LDUWA_R	lduwa	[%r31, %r0] 0x74, %r14
	.word 0x87802020  ! 3862: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x70, %r27
	mov	0x68, %r26
	mov	0x3c0, %r20
	.word 0xdab4e000  ! 3866: STHA_I	stha	%r13, [%r19 + 0x0000] %asi
	mov	0x68, %r16
	.word 0xd8afce60  ! 3868: STBA_R	stba	%r12, [%r31 + %r0] 0x73
	mov	0x78, %r26
	mov	0x40, %r18
	.word 0xdadce000  ! 3871: LDXA_I	ldxa	[%r19, + 0x0000] %asi, %r13
	.word 0x87802072  ! 3872: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xd0844400  ! 3873: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r8
	.word 0xd4b4e000  ! 3874: STHA_I	stha	%r10, [%r19 + 0x0000] %asi
	.word 0xdade89e0  ! 3875: LDXA_R	ldxa	[%r26, %r0] 0x4f, %r13
	mov	0x7d0, %r21
	.word 0xd09c8400  ! 3877: LDDA_R	ldda	[%r18, %r0] 0x20, %r8
	.word 0xdacca000  ! 3878: LDSBA_I	ldsba	[%r18, + 0x0000] %asi, %r13
	.word 0xd6ccc400  ! 3879: LDSBA_R	ldsba	[%r19, %r0] 0x20, %r11
	mov	0x7f0, %r22
	.word 0xd4d4e000  ! 3881: LDSHA_I	ldsha	[%r19, + 0x0000] %asi, %r10
	.word 0x87802025  ! 3882: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4d689e0  ! 3883: LDSHA_R	ldsha	[%r26, %r0] 0x4f, %r10
	.word 0x87802025  ! 3884: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0x87802072  ! 3885: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x50, %r19
	.word 0xd6f6e000  ! 3887: STXA_I	stxa	%r11, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 3888: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x48, %r16
	.word 0xd6aee000  ! 3890: STBA_I	stba	%r11, [%r27 + 0x0000] %asi
	mov	0x38, %r27
	.word 0xd6c66000  ! 3892: LDSWA_I	ldswa	[%r25, + 0x0000] %asi, %r11
	.word 0xd4d70e60  ! 3893: LDSHA_R	ldsha	[%r28, %r0] 0x73, %r10
	.word 0xd4b6a000  ! 3894: STHA_I	stha	%r10, [%r26 + 0x0000] %asi
	.word 0x87802020  ! 3895: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r27
	.word 0xd4d66000  ! 3897: LDSHA_I	ldsha	[%r25, + 0x0000] %asi, %r10
	.word 0xd4c62000  ! 3898: LDSWA_I	ldswa	[%r24, + 0x0000] %asi, %r10
	mov	0x10, %r16
	mov	0x28, %r24
	.word 0x87802020  ! 3901: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4d76000  ! 3902: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r10
	.word 0xd49f2000  ! 3903: LDDA_I	ldda	[%r28, + 0x0000] %asi, %r10
	mov	0x3c8, %r20
	.word 0x87802020  ! 3905: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x30, %r25
	.word 0xd4ce89e0  ! 3907: LDSBA_R	ldsba	[%r26, %r0] 0x4f, %r10
	.word 0xd4a72000  ! 3908: STWA_I	stwa	%r10, [%r28 + 0x0000] %asi
	.word 0xda844400  ! 3909: LDUWA_R	lduwa	[%r17, %r0] 0x20, %r13
	.word 0x87802074  ! 3910: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xda8ea000  ! 3911: LDUBA_I	lduba	[%r26, + 0x0000] %asi, %r13
	.word 0xdaa6e000  ! 3912: STWA_I	stwa	%r13, [%r27 + 0x0000] %asi
	.word 0xd29d44a0  ! 3913: LDDA_R	ldda	[%r21, %r0] 0x25, %r9
	.word 0x87802074  ! 3914: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0xdea4e000  ! 3915: STWA_I	stwa	%r15, [%r19 + 0x0000] %asi
	.word 0xdeaec9e0  ! 3916: STBA_R	stba	%r15, [%r27 + %r0] 0x4f
	mov	0x7f0, %r21
	.word 0xd2dc4400  ! 3918: LDXA_R	ldxa	[%r17, %r0] 0x20, %r9
	.word 0xd2a46000  ! 3919: STWA_I	stwa	%r9, [%r17 + 0x0000] %asi
	.word 0xd4b649e0  ! 3920: STHA_R	stha	%r10, [%r25 + %r0] 0x4f
	.word 0xda944400  ! 3921: LDUHA_R	lduha	[%r17, %r0] 0x20, %r13
	mov	0x78, %r26
	.word 0xd4cd84a0  ! 3923: LDSBA_R	ldsba	[%r22, %r0] 0x25, %r10
	.word 0xd6ace000  ! 3924: STBA_I	stba	%r11, [%r19 + 0x0000] %asi
	.word 0xd6a46000  ! 3925: STWA_I	stwa	%r11, [%r17 + 0x0000] %asi
	.word 0xdc84c400  ! 3926: LDUWA_R	lduwa	[%r19, %r0] 0x20, %r14
	.word 0xd6f4a000  ! 3927: STXA_I	stxa	%r11, [%r18 + 0x0000] %asi
	mov	0x0, %r27
	.word 0xdc978e60  ! 3929: LDUHA_R	lduha	[%r30, %r0] 0x73, %r14
	.word 0xdeb78e40  ! 3930: STHA_R	stha	%r15, [%r30 + %r0] 0x72
	.word 0xdeacc400  ! 3931: STBA_R	stba	%r15, [%r19 + %r0] 0x20
	.word 0xde8ce000  ! 3932: LDUBA_I	lduba	[%r19, + 0x0000] %asi, %r15
	.word 0xdcbf4e80  ! 3933: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xd8bd04a0  ! 3934: STDA_R	stda	%r12, [%r20 + %r0] 0x25
	.word 0xd4b584a0  ! 3935: STHA_R	stha	%r10, [%r22 + %r0] 0x25
	.word 0xd4c46000  ! 3936: LDSWA_I	ldswa	[%r17, + 0x0000] %asi, %r10
	mov	0x38, %r18
	mov	0x7c8, %r22
	.word 0x87802020  ! 3939: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x3e8, %r22
	.word 0xd48ca000  ! 3941: LDUBA_I	lduba	[%r18, + 0x0000] %asi, %r10
	.word 0x87802020  ! 3942: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4a56000  ! 3943: STWA_I	stwa	%r10, [%r21 + 0x0000] %asi
	.word 0x87802020  ! 3944: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd49c6000  ! 3945: LDDA_I	ldda	[%r17, + 0x0000] %asi, %r10
	mov	0x0, %r18
	.word 0xd4a44400  ! 3947: STWA_R	stwa	%r10, [%r17 + %r0] 0x20
	.word 0xdcdc6000  ! 3948: LDXA_I	ldxa	[%r17, + 0x0000] %asi, %r14
	.word 0xdca42000  ! 3949: STWA_I	stwa	%r14, [%r16 + 0x0000] %asi
	mov	0x10, %r27
	.word 0xd2a40400  ! 3951: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	.word 0xd8af8e40  ! 3952: STBA_R	stba	%r12, [%r30 + %r0] 0x72
	mov	0x78, %r19
	.word 0xd8ac6000  ! 3954: STBA_I	stba	%r12, [%r17 + 0x0000] %asi
	.word 0x87802072  ! 3955: WRASI_I	wr	%r0, 0x0072, %asi
	mov	0x28, %r25
	.word 0xdeb40400  ! 3957: STHA_R	stha	%r15, [%r16 + %r0] 0x20
	.word 0xdccd44a0  ! 3958: LDSBA_R	ldsba	[%r21, %r0] 0x25, %r14
	.word 0xd8f6e000  ! 3959: STXA_I	stxa	%r12, [%r27 + 0x0000] %asi
	.word 0x87802020  ! 3960: WRASI_I	wr	%r0, 0x0020, %asi
	mov	0x10, %r27
	.word 0x87802073  ! 3962: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaaf4e60  ! 3963: STBA_R	stba	%r13, [%r29 + %r0] 0x73
	.word 0xd28f0e40  ! 3964: LDUBA_R	lduba	[%r28, %r0] 0x72, %r9
	.word 0xdcbf4e80  ! 3965: STDA_R	stda	%r14, [%r29 + %r0] 0x74
	.word 0xd2a40400  ! 3966: STWA_R	stwa	%r9, [%r16 + %r0] 0x20
	mov	0x8, %r18
	.word 0xd4a78e40  ! 3968: STWA_R	stwa	%r10, [%r30 + %r0] 0x72
	.word 0xdca72000  ! 3969: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xdebfce60  ! 3970: STDA_R	stda	%r15, [%r31 + %r0] 0x73
	ta	T_CHANGE_NONPRIV	! macro
	.word 0x8780204f  ! 3972: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd8c584a0  ! 3973: LDSWA_R	ldswa	[%r22, %r0] 0x25, %r12
	.word 0x8780204f  ! 3974: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x40, %r16
	.word 0xd2af6000  ! 3976: STBA_I	stba	%r9, [%r29 + 0x0000] %asi
	.word 0xd2a689e0  ! 3977: STWA_R	stwa	%r9, [%r26 + %r0] 0x4f
	.word 0xd6dc0400  ! 3978: LDXA_R	ldxa	[%r16, %r0] 0x20, %r11
	.word 0x87802072  ! 3979: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0x87802072  ! 3980: WRASI_I	wr	%r0, 0x0072, %asi
	.word 0xdef4e000  ! 3981: STXA_I	stxa	%r15, [%r19 + 0x0000] %asi
	.word 0xda974e80  ! 3982: LDUHA_R	lduha	[%r29, %r0] 0x74, %r13
	.word 0xdea42000  ! 3983: STWA_I	stwa	%r15, [%r16 + 0x0000] %asi
	.word 0x87802020  ! 3984: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xde87a000  ! 3985: LDUWA_I	lduwa	[%r30, + 0x0000] %asi, %r15
	.word 0xd8acc400  ! 3986: STBA_R	stba	%r12, [%r19 + %r0] 0x20
	.word 0x8780204f  ! 3987: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdec70e40  ! 3988: LDSWA_R	ldswa	[%r28, %r0] 0x72, %r15
	.word 0xd6974e80  ! 3989: LDUHA_R	lduha	[%r29, %r0] 0x74, %r11
	mov	0x68, %r26
	mov	0x38, %r19
	.word 0xdaa48400  ! 3992: STWA_R	stwa	%r13, [%r18 + %r0] 0x20
	mov	0x0, %r26
	.word 0xd0b74e40  ! 3994: STHA_R	stha	%r8, [%r29 + %r0] 0x72
	.word 0xdca72000  ! 3995: STWA_I	stwa	%r14, [%r28 + 0x0000] %asi
	.word 0xd48e89e0  ! 3996: LDUBA_R	lduba	[%r26, %r0] 0x4f, %r10
	.word 0xdcbf2000  ! 3997: STDA_I	stda	%r14, [%r28 + 0x0000] %asi
	.word 0xd0c4c400  ! 3998: LDSWA_R	ldswa	[%r19, %r0] 0x20, %r8
	.word 0xd08504a0  ! 3999: LDUWA_R	lduwa	[%r20, %r0] 0x25, %r8
	.word 0xd8aec9e0  ! 4000: STBA_R	stba	%r12, [%r27 + %r0] 0x4f
	mov	0x7e0, %r22
	.word 0xd88f2000  ! 4002: LDUBA_I	lduba	[%r28, + 0x0000] %asi, %r12
	.word 0xd0c504a0  ! 4003: LDSWA_R	ldswa	[%r20, %r0] 0x25, %r8
	mov	0x20, %r17
	mov	0x10, %r17
	mov	0x7c8, %r20
	.word 0x87802020  ! 4007: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdedf2000  ! 4008: LDXA_I	ldxa	[%r28, + 0x0000] %asi, %r15
	.word 0xde972000  ! 4009: LDUHA_I	lduha	[%r28, + 0x0000] %asi, %r15
	.word 0xdcad44a0  ! 4010: STBA_R	stba	%r14, [%r21 + %r0] 0x25
	.word 0xdede09e0  ! 4011: LDXA_R	ldxa	[%r24, %r0] 0x4f, %r15
	.word 0xd8f72000  ! 4012: STXA_I	stxa	%r12, [%r28 + 0x0000] %asi
	.word 0xd8b7a000  ! 4013: STHA_I	stha	%r12, [%r30 + 0x0000] %asi
	.word 0xd8afa000  ! 4014: STBA_I	stba	%r12, [%r30 + 0x0000] %asi
	.word 0xd2d40400  ! 4015: LDSHA_R	ldsha	[%r16, %r0] 0x20, %r9
	.word 0xd6d649e0  ! 4016: LDSHA_R	ldsha	[%r25, %r0] 0x4f, %r11
	mov	0x30, %r24
	.word 0xd8a7e000  ! 4018: STWA_I	stwa	%r12, [%r31 + 0x0000] %asi
	.word 0xd8af2000  ! 4019: STBA_I	stba	%r12, [%r28 + 0x0000] %asi
	mov	0x7f8, %r20
	.word 0xd8f7a000  ! 4021: STXA_I	stxa	%r12, [%r30 + 0x0000] %asi
	.word 0xd8bf2000  ! 4022: STDA_I	stda	%r12, [%r28 + 0x0000] %asi
	.word 0xdcf4c400  ! 4023: STXA_R	stxa	%r14, [%r19 + %r0] 0x20
	mov	0x20, %r27
	.word 0x8780204f  ! 4025: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x3e8, %r21
	.word 0x8780204f  ! 4027: WRASI_I	wr	%r0, 0x004f, %asi
	mov	0x38, %r25
	.word 0xdcd74e40  ! 4029: LDSHA_R	ldsha	[%r29, %r0] 0x72, %r14
	.word 0xd8c7a000  ! 4030: LDSWA_I	ldswa	[%r30, + 0x0000] %asi, %r12
	.word 0xdcaf0e60  ! 4031: STBA_R	stba	%r14, [%r28 + %r0] 0x73
	.word 0xda97a000  ! 4032: LDUHA_I	lduha	[%r30, + 0x0000] %asi, %r13
	.word 0xdaaf2000  ! 4033: STBA_I	stba	%r13, [%r28 + 0x0000] %asi
	.word 0xd29e89e0  ! 4034: LDDA_R	ldda	[%r26, %r0] 0x4f, %r9
	.word 0xdcd584a0  ! 4035: LDSHA_R	ldsha	[%r22, %r0] 0x25, %r14
	.word 0xd4970e80  ! 4036: LDUHA_R	lduha	[%r28, %r0] 0x74, %r10
	.word 0xdebe89e0  ! 4037: STDA_R	stda	%r15, [%r26 + %r0] 0x4f
	mov	0x0, %r16
	mov	0x28, %r17
	.word 0xdaaf6000  ! 4040: STBA_I	stba	%r13, [%r29 + 0x0000] %asi
	.word 0xdadd04a0  ! 4041: LDXA_R	ldxa	[%r20, %r0] 0x25, %r13
	.word 0x87802020  ! 4042: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd4aca000  ! 4043: STBA_I	stba	%r10, [%r18 + 0x0000] %asi
	mov	0x3d8, %r22
	.word 0x87802073  ! 4045: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0xdaac4400  ! 4046: STBA_R	stba	%r13, [%r17 + %r0] 0x20
	.word 0x8780204f  ! 4047: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd6bcc400  ! 4048: STDA_R	stda	%r11, [%r19 + %r0] 0x20
	.word 0xda8f8e60  ! 4049: LDUBA_R	lduba	[%r30, %r0] 0x73, %r13
	.word 0xdabc0400  ! 4050: STDA_R	stda	%r13, [%r16 + %r0] 0x20
	.word 0xd0dca000  ! 4051: LDXA_I	ldxa	[%r18, + 0x0000] %asi, %r8
	.word 0xda8f0e40  ! 4052: LDUBA_R	lduba	[%r28, %r0] 0x72, %r13
	mov	0x68, %r17
	.word 0x87802020  ! 4054: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xdc86c9e0  ! 4055: LDUWA_R	lduwa	[%r27, %r0] 0x4f, %r14
	mov	0x18, %r19
	.word 0xdccc8400  ! 4057: LDSBA_R	ldsba	[%r18, %r0] 0x20, %r14
	.word 0xdedf0e80  ! 4058: LDXA_R	ldxa	[%r28, %r0] 0x74, %r15
	mov	0x10, %r18
	.word 0xdcafa000  ! 4060: STBA_I	stba	%r14, [%r30 + 0x0000] %asi
	.word 0xdca76000  ! 4061: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdccfa000  ! 4062: LDSBA_I	ldsba	[%r30, + 0x0000] %asi, %r14
	mov	0x30, %r24
	.word 0xdcd76000  ! 4064: LDSHA_I	ldsha	[%r29, + 0x0000] %asi, %r14
	.word 0x87802074  ! 4065: WRASI_I	wr	%r0, 0x0074, %asi
	.word 0x8780204f  ! 4066: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xdca76000  ! 4067: STWA_I	stwa	%r14, [%r29 + 0x0000] %asi
	.word 0xdeac8400  ! 4068: STBA_R	stba	%r15, [%r18 + %r0] 0x20
	mov	0x20, %r25
	.word 0xdc8e09e0  ! 4070: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r14
	.word 0xd68649e0  ! 4071: LDUWA_R	lduwa	[%r25, %r0] 0x4f, %r11
	.word 0xd4c78e40  ! 4072: LDSWA_R	ldswa	[%r30, %r0] 0x72, %r10
	mov	0x18, %r27
	.word 0x87802073  ! 4074: WRASI_I	wr	%r0, 0x0073, %asi
	.word 0x87802020  ! 4075: WRASI_I	wr	%r0, 0x0020, %asi
	.word 0xd6afce80  ! 4076: STBA_R	stba	%r11, [%r31 + %r0] 0x74
	.word 0xd6df8e40  ! 4077: LDXA_R	ldxa	[%r30, %r0] 0x72, %r11
	.word 0xd29fe000  ! 4078: LDDA_I	ldda	[%r31, + 0x0000] %asi, %r9
	.word 0x8780204f  ! 4079: WRASI_I	wr	%r0, 0x004f, %asi
	.word 0xd0d78e60  ! 4080: LDSHA_R	ldsha	[%r30, %r0] 0x73, %r8
	mov	0x3e8, %r21
	.word 0xdef7e000  ! 4082: STXA_I	stxa	%r15, [%r31 + 0x0000] %asi
	mov	0x28, %r26
	.word 0xd6bc8400  ! 4084: STDA_R	stda	%r11, [%r18 + %r0] 0x20
	mov	0x30, %r19
	.word 0xde8e09e0  ! 4086: LDUBA_R	lduba	[%r24, %r0] 0x4f, %r15
	.word 0xd8bdc4a0  ! 4087: STDA_R	stda	%r12, [%r23 + %r0] 0x25
	.word 0xdadf0e60  ! 4088: LDXA_R	ldxa	[%r28, %r0] 0x73, %r13
	mov	0x20, %r27
	mov	0x7e8, %r21
	.word 0x87802025  ! 4091: WRASI_I	wr	%r0, 0x0025, %asi
	.word 0xd4a4a000  ! 4092: STWA_I	stwa	%r10, [%r18 + 0x0000] %asi
	.word 0xd0f4c400  ! 4093: STXA_R	stxa	%r8, [%r19 + %r0] 0x20
	mov	0x0, %r25
	.word 0xd09