// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: spu_rdg09_15_19_33.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/*
  	   * Random diag for testing LSU 
*/
#define MAIN_PAGE_NUCLEUS_ALSO
#define MAIN_TEXT_DATA_ALSO
#define THREAD_COUNT 4 
#define MAIN_PAGE_HV_ALSO
#include "spu_diag.h"
#include "enable_traps.h"
#include "boot.s"
.text
.global main


.global run_th_0

.global run_th_1

.global run_th_2

.global run_th_3

main:

	 th_fork(run_th)
        		ba diag_fail    /* should not come here */
        		nop 

run_th_0:
         wr %g0, 64, %asi

         ta T_CHANGE_HPRIV
         nop


        setpa   (spu_data_src, %l0, %l1, %l5)
        stxa    %l5, [%g0+REG_MPA_ADDR] %asi
        ! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
        setpa   (spu_data_dest, %l0, %l1, %l6)
        stxa    %g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

        add     %g0, 64, %i3  ! %i3 contains number of xwords to load/store
        mov     0, %g1
        sllx    %g1,    11,     %g1     ! add the thread ID to the SPU_MA_CTL reg
        or      %g1,    %i3,    %i3
        sub     %i3, 1,  %i0    ! #of xwords to load to MAMEM minus 1


        stxa    %i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
        ldxa    [%g0+MASync_ADDR] %asi, %l7

        ta T_CHANGE_NONHPRIV
	nop

	 wr %g0, 129, %asi

	 ta T_CHANGE_PRIV 
	 nop 
	 set 2100359945, %i0
	 set 1231065961, %i1
	 set 3416807506, %i2
	 set 2708445565, %i3
	 set 14111486, %i4
	 set 390932088, %i5
	 set 900121245, %i6
	 set 557030946, %i7
	 set 1829041424, %o0
	 set 85461381, %o1
	 set 1222315208, %o2
	 set 2890208915, %o3
	 set 1439597041, %o4
	 set 3906396952, %o5
	 set 354862893, %o6
	 set 2956603988, %o7
	 set 3075026634, %l0
	 set 3776826405, %l1
	 set 1673132954, %l2
	 set 3333821888, %l3
	 set 1355849931, %l4
	 set 836355895, %l5
	 set 52471420, %l6
	 set 388744802, %l7
	 set 449381604, %g0
	 set 2852058857, %g1
	 set 1649155642, %g2
	 set 3572697218, %g3
	 set 1359241164, %g4
	 set 1379878811, %g5
	 set 2596343006, %g6
	 set 1045758467, %g7

wr %g0, 0x4, %fprs 
	 setx self_modcode, %l0, %l3
	 ldd [%l3], %f0
	 add 0x8, %l3, %l3
	 ldd [%l3], %f2
	 add 0x8, %l3, %l3
	 ldd [%l3], %f4
	 add 0x8, %l3, %l3
	 ldd [%l3], %f6
	 add 0x8, %l3, %l3
	 ldd [%l3], %f8
	 add 0x8, %l3, %l3
	 ldd [%l3], %f10
	 add 0x8, %l3, %l3
	 ldd [%l3], %f12
	 add 0x8, %l3, %l3
	 ldd [%l3], %f14
	 add 0x8, %l3, %l3
	 ldd [%l3], %f16
	 add 0x8, %l3, %l3
	 ldd [%l3], %f18
	 add 0x8, %l3, %l3
	 ldd [%l3], %f20
	 add 0x8, %l3, %l3
	 ldd [%l3], %f22
	 add 0x8, %l3, %l3
	 ldd [%l3], %f24
	 add 0x8, %l3, %l3
	 ldd [%l3], %f26
	 add 0x8, %l3, %l3
	 ldd [%l3], %f28
	 add 0x8, %l3, %l3
	 ldd [%l3], %f30
	 add 0x8, %l3, %l3
	 ldd [%l3], %f32
	 add 0x8, %l3, %l3
	 ldd [%l3], %f34
	 add 0x8, %l3, %l3
	 ldd [%l3], %f36
	 add 0x8, %l3, %l3
	 ldd [%l3], %f38
	 add 0x8, %l3, %l3
	 ldd [%l3], %f40
	 add 0x8, %l3, %l3
	 ldd [%l3], %f42
	 add 0x8, %l3, %l3
	 ldd [%l3], %f44
	 add 0x8, %l3, %l3
	 ldd [%l3], %f46
	 add 0x8, %l3, %l3
	 ldd [%l3], %f48
	 add 0x8, %l3, %l3
	 ldd [%l3], %f50
	 add 0x8, %l3, %l3
	 ldd [%l3], %f52
	 add 0x8, %l3, %l3
	 ldd [%l3], %f54
	 add 0x8, %l3, %l3
	 ldd [%l3], %f56
	 add 0x8, %l3, %l3
	 ldd [%l3], %f58
	 add 0x8, %l3, %l3
	 ldd [%l3], %f60
	 add 0x8, %l3, %l3
	 ldd [%l3], %f62
	 add 0x8, %l3, %l3
	 setx data2, %l0, %l3
	 setx self_modcode, %l0, %l1

.global ecc_err_0 
ecc_err_0:
!$EV error(0, expr(@VA(.MAIN.ecc_err_0),16,16),1, DC_DATA, 49) 
	 .word 0xf3f4e000


.global ecc_err_1 
ecc_err_1:
!$EV error(0, expr(@VA(.MAIN.ecc_err_1),16,16),1, IC_DATA, IR,2,x) 
	 .word 0xf5e4e000

	 .word 0xf2fcdd40


.global ecc_err_2 
ecc_err_2:
!$EV error(0, expr(@VA(.MAIN.ecc_err_2),16,16),1, DC_TAG, 45) 
	 .word 0xee54e002

	 .word 0xeeacc540

	 .word 0xf8ece024

	 .word 0xf26cc000

	 .word 0xec3ce010

	 .word 0xfafcdd40


.global ecc_err_3 
ecc_err_3:
!$EV error(0, expr(@VA(.MAIN.ecc_err_3),16,16),1, DC_TAG, 9) 
	 .word 0xf9f4e000

	 .word 0xf6a4dd60

	 .word 0xede4d020

	 .word 0xf1f4e000


.global ecc_err_4 
ecc_err_4:
!$EV error(0, expr(@VA(.MAIN.ecc_err_4),16,16),1, IC_TAG, IR,12, x) 
	 .word 0xf05ce008


.global ecc_err_5 
ecc_err_5:
!$EV error(0, expr(@VA(.MAIN.ecc_err_5),16,16),1, IC_TAG, IR,13, x) 
	 .word 0xf20ce002

	 .word 0xec6ce035


.global ecc_err_6 
ecc_err_6:
!$EV error(0, expr(@VA(.MAIN.ecc_err_6),16,16),1, DC_DATA, 26) 
	 .word 0xf4ecdd60


.global ecc_err_7 
ecc_err_7:
!$EV error(0, expr(@VA(.MAIN.ecc_err_7),16,16),1, DC_DATA, 2) 
	 .word 0xeff4e000

	 .word 0xfa8cd020

	 .word 0xec74c000


.global ecc_err_8 
ecc_err_8:
!$EV error(0, expr(@VA(.MAIN.ecc_err_8),16,16),1, DC_DATA, 3) 
	 .word 0xf66cc000


.global ecc_err_9 
ecc_err_9:
!$EV error(0, expr(@VA(.MAIN.ecc_err_9),16,16),1, DC_DATA, 6) 
	 .word 0xeaecc560


.global ecc_err_10 
ecc_err_10:
!$EV error(0, expr(@VA(.MAIN.ecc_err_10),16,16),1, DC_TAG, 13) 
	 .word 0xf0ecd120


.global ecc_err_11 
ecc_err_11:
!$EV error(0, expr(@VA(.MAIN.ecc_err_11),16,16),1, DC_DATA, 5) 
	 .word 0xee6ce01e


.global ecc_err_12 
ecc_err_12:
!$EV error(0, expr(@VA(.MAIN.ecc_err_12),16,16),1, DC_TAG, 62) 
	 .word 0xf6ece029


.global ecc_err_13 
ecc_err_13:
!$EV error(0, expr(@VA(.MAIN.ecc_err_13),16,16),1, IC_TAG, IR,20, x) 
	 .word 0xf2ece036


.global ecc_err_14 
ecc_err_14:
!$EV error(0, expr(@VA(.MAIN.ecc_err_14),16,16),1, DC_DATA, 9) 
	 .word 0xeaece03a


.global ecc_err_15 
ecc_err_15:
!$EV error(0, expr(@VA(.MAIN.ecc_err_15),16,16),1, IC_DATA, IR,14,x) 
	 .word 0xea04e004

	 .word 0xeeecdc40


.global ecc_err_16 
ecc_err_16:
!$EV error(0, expr(@VA(.MAIN.ecc_err_16),16,16),1, IC_DATA, IR,23,x) 
	 .word 0xececc440

	 .word 0xf1f4d020


.global ecc_err_17 
ecc_err_17:
!$EV error(0, expr(@VA(.MAIN.ecc_err_17),16,16),1, IC_TAG, IR,4, x) 
	 .word 0xf6c4c540

	 .word 0xf67cc000

	 .word 0xf824c000

	 .word 0xf0a4e000

	 .word 0xf1f4c480

	 .word 0xf47ce004

	 .word 0xeab4c580


.global ecc_err_18 
ecc_err_18:
!$EV error(0, expr(@VA(.MAIN.ecc_err_18),16,16),1, DC_TAG, 38) 
	 .word 0xf46ce028


.global ecc_err_19 
ecc_err_19:
!$EV error(0, expr(@VA(.MAIN.ecc_err_19),16,16),1, DC_DATA, 44) 
	 .word 0xebe4e000


.global ecc_err_20 
ecc_err_20:
!$EV error(0, expr(@VA(.MAIN.ecc_err_20),16,16),1, DC_DATA, 37) 
	 .word 0xeff4e000

	 .word 0xf684e000

	 .word 0xf8ece021


.global ecc_err_21 
ecc_err_21:
!$EV error(0, expr(@VA(.MAIN.ecc_err_21),16,16),1, DC_TAG, 37) 
	 .word 0xf2ece03a

	 .word 0xf684dd60


.global ecc_err_22 
ecc_err_22:
!$EV error(0, expr(@VA(.MAIN.ecc_err_22),16,16),1, DC_DATA, 1) 
	 .word 0xfa7ce004

	 .word 0xec74c000


.global ecc_err_23 
ecc_err_23:
!$EV error(0, expr(@VA(.MAIN.ecc_err_23),16,16),1, DC_DATA, 57) 
	 .word 0xf6d4dc40


.global ecc_err_24 
ecc_err_24:
!$EV error(0, expr(@VA(.MAIN.ecc_err_24),16,16),1, IC_TAG, IR,31, x) 
	 .word 0xf06cc000


.global ecc_err_25 
ecc_err_25:
!$EV error(0, expr(@VA(.MAIN.ecc_err_25),16,16),1, DC_TAG, 35) 
	 .word 0xf604e004


.global ecc_err_26 
ecc_err_26:
!$EV error(0, expr(@VA(.MAIN.ecc_err_26),16,16),1, DC_DATA, 11) 
	 .word 0xf67cc000


.global ecc_err_27 
ecc_err_27:
!$EV error(0, expr(@VA(.MAIN.ecc_err_27),16,16),1, IC_TAG, IR,6, x) 
	 .word 0xf9e4e000


.global ecc_err_28 
ecc_err_28:
!$EV error(0, expr(@VA(.MAIN.ecc_err_28),16,16),1, DC_DATA, 58) 
	 .word 0xf6d4c480

	 .word 0xf06cc000

	 .word 0xea14c000


.global ecc_err_29 
ecc_err_29:
!$EV error(0, expr(@VA(.MAIN.ecc_err_29),16,16),1, DC_DATA, 54) 
	 .word 0xf24ce034

	 .word 0xf64cc000

	 .word 0xf3e4e000

	 .word 0xf07ce000

	 .word 0xee7ce004

	 .word 0xecb4e002

	 .word 0xf4fce000

	 .word 0xf8c4e004


.global ecc_err_30 
ecc_err_30:
!$EV error(0, expr(@VA(.MAIN.ecc_err_30),16,16),1, DC_TAG, 27) 
	 .word 0xec9cc580


.global ecc_err_31 
ecc_err_31:
!$EV error(0, expr(@VA(.MAIN.ecc_err_31),16,16),1, IC_TAG, IR,2, x) 
	 .word 0xf1f4dc60

	 .word 0xf0fcd120


.global ecc_err_32 
ecc_err_32:
!$EV error(0, expr(@VA(.MAIN.ecc_err_32),16,16),1, IC_TAG, IR,23, x) 
	 .word 0xf9f4c580


.global ecc_err_33 
ecc_err_33:
!$EV error(0, expr(@VA(.MAIN.ecc_err_33),16,16),1, DC_DATA, 44) 
	 .word 0xedf4c580


.global ecc_err_34 
ecc_err_34:
!$EV error(0, expr(@VA(.MAIN.ecc_err_34),16,16),1, IC_DATA, IR,20,x) 
	 .word 0xec6ce00d

	 .word 0xf85ce008

	 .word 0xefe4d100


.global ecc_err_35 
ecc_err_35:
!$EV error(0, expr(@VA(.MAIN.ecc_err_35),16,16),1, IC_TAG, IR,11, x) 
	 .word 0xee6ce027


.global ecc_err_36 
ecc_err_36:
!$EV error(0, expr(@VA(.MAIN.ecc_err_36),16,16),1, IC_TAG, IR,19, x) 
	 .word 0xf20cc000


.global ecc_err_37 
ecc_err_37:
!$EV error(0, expr(@VA(.MAIN.ecc_err_37),16,16),1, IC_DATA, IR,6,x) 
	 .word 0xf7f4e000


.global ecc_err_38 
ecc_err_38:
!$EV error(0, expr(@VA(.MAIN.ecc_err_38),16,16),1, IC_DATA, IR,16,x) 
	 .word 0xf3f4e000

	 .word 0xebe4e000

	 .word 0xf8b4e002


.global ecc_err_39 
ecc_err_39:
!$EV error(0, expr(@VA(.MAIN.ecc_err_39),16,16),1, DC_DATA, 35) 
	 .word 0xf06cc000

	 .word 0xf014e000

	 .word 0xec3ce010


.global ecc_err_40 
ecc_err_40:
!$EV error(0, expr(@VA(.MAIN.ecc_err_40),16,16),1, IC_DATA, IR,25,x) 
	 .word 0xea54e002

	 .word 0xecc4c540


.global ecc_err_41 
ecc_err_41:
!$EV error(0, expr(@VA(.MAIN.ecc_err_41),16,16),1, DC_DATA, 10) 
	 .word 0xec04c000


.global ecc_err_42 
ecc_err_42:
!$EV error(0, expr(@VA(.MAIN.ecc_err_42),16,16),1, IC_TAG, IR,4, x) 
	 .word 0xebe4c580

	 .word 0xeeece002


.global ecc_err_43 
ecc_err_43:
!$EV error(0, expr(@VA(.MAIN.ecc_err_43),16,16),1, DC_TAG, 8) 
	 .word 0xf7f4c480


.global ecc_err_44 
ecc_err_44:
!$EV error(0, expr(@VA(.MAIN.ecc_err_44),16,16),1, DC_TAG, 32) 
	 .word 0xf07cc000


.global ecc_err_45 
ecc_err_45:
!$EV error(0, expr(@VA(.MAIN.ecc_err_45),16,16),1, IC_TAG, IR,22, x) 
	 .word 0xf66cc000


.global ecc_err_46 
ecc_err_46:
!$EV error(0, expr(@VA(.MAIN.ecc_err_46),16,16),1, DC_DATA, 62) 
	 .word 0xf86cc000

	 .word 0xf1e4d020


.global ecc_err_47 
ecc_err_47:
!$EV error(0, expr(@VA(.MAIN.ecc_err_47),16,16),1, DC_TAG, 34) 
	 .word 0xeaece003


.global ecc_err_48 
ecc_err_48:
!$EV error(0, expr(@VA(.MAIN.ecc_err_48),16,16),1, IC_DATA, IR,20,x) 
	 .word 0xea6ce031


.global ecc_err_49 
ecc_err_49:
!$EV error(0, expr(@VA(.MAIN.ecc_err_49),16,16),1, DC_DATA, 31) 
	 .word 0xee6ce016

	 .word 0xf4dce008

	 .word 0xf86ce008


.global ecc_err_50 
ecc_err_50:
!$EV error(0, expr(@VA(.MAIN.ecc_err_50),16,16),1, IC_DATA, IR,26,x) 
	 .word 0xfa7cc000

	 .word 0xf8acc560


.global ecc_err_51 
ecc_err_51:
!$EV error(0, expr(@VA(.MAIN.ecc_err_51),16,16),1, DC_DATA, 55) 
	 .word 0xedf4e000

	 .word 0xfa44e000


.global ecc_err_52 
ecc_err_52:
!$EV error(0, expr(@VA(.MAIN.ecc_err_52),16,16),1, DC_TAG, 14) 
	 .word 0xefe4c480


.global ecc_err_53 
ecc_err_53:
!$EV error(0, expr(@VA(.MAIN.ecc_err_53),16,16),1, DC_TAG, 56) 
	 .word 0xec44c000

	 .word 0xfa5ce000


.global ecc_err_54 
ecc_err_54:
!$EV error(0, expr(@VA(.MAIN.ecc_err_54),16,16),1, IC_DATA, IR,5,x) 
	 .word 0xf07ce000


.global ecc_err_55 
ecc_err_55:
!$EV error(0, expr(@VA(.MAIN.ecc_err_55),16,16),1, DC_TAG, 39) 
	 .word 0xf66cc000

	 .word 0xfa7cc000

	 .word 0xec4ce039


.global ecc_err_56 
ecc_err_56:
!$EV error(0, expr(@VA(.MAIN.ecc_err_56),16,16),1, DC_TAG, 49) 
	 .word 0xeff4d120

	 .word 0xf46cc000


.global ecc_err_57 
ecc_err_57:
!$EV error(0, expr(@VA(.MAIN.ecc_err_57),16,16),1, IC_TAG, IR,7, x) 
	 .word 0xebf4c460


.global ecc_err_58 
ecc_err_58:
!$EV error(0, expr(@VA(.MAIN.ecc_err_58),16,16),1, DC_DATA, 34) 
	 .word 0xec6ce018


.global ecc_err_59 
ecc_err_59:
!$EV error(0, expr(@VA(.MAIN.ecc_err_59),16,16),1, IC_TAG, IR,10, x) 
	 .word 0xefe4e000

	 .word 0xea6ce008


.global ecc_err_60 
ecc_err_60:
!$EV error(0, expr(@VA(.MAIN.ecc_err_60),16,16),1, DC_TAG, 22) 
	 .word 0xf25ce008

	 .word 0xecf4e008


.global ecc_err_61 
ecc_err_61:
!$EV error(0, expr(@VA(.MAIN.ecc_err_61),16,16),1, DC_DATA, 19) 
	 .word 0xf87ce000


.global ecc_err_62 
ecc_err_62:
!$EV error(0, expr(@VA(.MAIN.ecc_err_62),16,16),1, DC_DATA, 12) 
	 .word 0xf07cc000

	 .word 0xf6a4e000

	 .word 0xeaecc440


.global ecc_err_63 
ecc_err_63:
!$EV error(0, expr(@VA(.MAIN.ecc_err_63),16,16),1, DC_TAG, 32) 
	 .word 0xf0d4d120


.global ecc_err_64 
ecc_err_64:
!$EV error(0, expr(@VA(.MAIN.ecc_err_64),16,16),1, IC_TAG, IR,21, x) 
	 .word 0xf4ecdc60


.global ecc_err_65 
ecc_err_65:
!$EV error(0, expr(@VA(.MAIN.ecc_err_65),16,16),1, IC_DATA, IR,19,x) 
	 .word 0xea6cc000

	 .word 0xeca4dd60


.global ecc_err_66 
ecc_err_66:
!$EV error(0, expr(@VA(.MAIN.ecc_err_66),16,16),1, DC_TAG, 59) 
	 .word 0xefe4e000


.global ecc_err_67 
ecc_err_67:
!$EV error(0, expr(@VA(.MAIN.ecc_err_67),16,16),1, DC_DATA, 11) 
	 .word 0xee84e004


.global ecc_err_68 
ecc_err_68:
!$EV error(0, expr(@VA(.MAIN.ecc_err_68),16,16),1, DC_TAG, 6) 
	 .word 0xeff4d000

	 .word 0xf1e4e000


.global ecc_err_69 
ecc_err_69:
!$EV error(0, expr(@VA(.MAIN.ecc_err_69),16,16),1, DC_DATA, 40) 
	 .word 0xf46cc000


.global ecc_err_70 
ecc_err_70:
!$EV error(0, expr(@VA(.MAIN.ecc_err_70),16,16),1, DC_TAG, 26) 
	 .word 0xf1f4c560


.global ecc_err_71 
ecc_err_71:
!$EV error(0, expr(@VA(.MAIN.ecc_err_71),16,16),1, DC_DATA, 25) 
	 .word 0xede4c580


.global ecc_err_72 
ecc_err_72:
!$EV error(0, expr(@VA(.MAIN.ecc_err_72),16,16),1, DC_TAG, 55) 
	 .word 0xea6ce009


.global ecc_err_73 
ecc_err_73:
!$EV error(0, expr(@VA(.MAIN.ecc_err_73),16,16),1, IC_DATA, IR,20,x) 
	 .word 0xec54c000

	 .word 0xf2fce000


.global ecc_err_74 
ecc_err_74:
!$EV error(0, expr(@VA(.MAIN.ecc_err_74),16,16),1, DC_TAG, 9) 
	 .word 0xf8ecdc60


.global ecc_err_75 
ecc_err_75:
!$EV error(0, expr(@VA(.MAIN.ecc_err_75),16,16),1, IC_DATA, IR,18,x) 
	 .word 0xedf4e000


.global ecc_err_76 
ecc_err_76:
!$EV error(0, expr(@VA(.MAIN.ecc_err_76),16,16),1, IC_TAG, IR,14, x) 
	 .word 0xea54c000

	 .word 0xecccdc40

	 .word 0xf60cc000

	 .word 0xf854e000

	 .word 0xecfcd100


.global ecc_err_77 
ecc_err_77:
!$EV error(0, expr(@VA(.MAIN.ecc_err_77),16,16),1, IC_TAG, IR,22, x) 
	 .word 0xf3e4e000

	 .word 0xede4c460

	 .word 0xfafcdd60

	 .word 0xebf4c480


.global ecc_err_78 
ecc_err_78:
!$EV error(0, expr(@VA(.MAIN.ecc_err_78),16,16),1, DC_TAG, 39) 
	 .word 0xf2ecc580

	 .word 0xebf4dc60

	 .word 0xf46ce00f

	 .word 0xec7cc000

	 .word 0xfa7cc000

	 .word 0xf86cc000


.global ecc_err_79 
ecc_err_79:
!$EV error(0, expr(@VA(.MAIN.ecc_err_79),16,16),1, IC_DATA, IR,31,x) 
	 .word 0xf87cc000

	 .word 0xf86ce017


.global ecc_err_80 
ecc_err_80:
!$EV error(0, expr(@VA(.MAIN.ecc_err_80),16,16),1, IC_TAG, IR,3, x) 
	 .word 0xea6ce038

	 .word 0xee84e000

	 .word 0xecfcdc60


.global ecc_err_81 
ecc_err_81:
!$EV error(0, expr(@VA(.MAIN.ecc_err_81),16,16),1, IC_DATA, IR,28,x) 
	 .word 0xedf4d020

	 .word 0xf1e4e000


.global ecc_err_82 
ecc_err_82:
!$EV error(0, expr(@VA(.MAIN.ecc_err_82),16,16),1, DC_DATA, 19) 
	 .word 0xec7ce004


.global ecc_err_83 
ecc_err_83:
!$EV error(0, expr(@VA(.MAIN.ecc_err_83),16,16),1, DC_DATA, 37) 
	 .word 0xf67cc000

	 .word 0xfaf4c560


.global ecc_err_84 
ecc_err_84:
!$EV error(0, expr(@VA(.MAIN.ecc_err_84),16,16),1, DC_TAG, 1) 
	 .word 0xecece03a

	 .word 0xeafcc560

	 .word 0xf5e4e000

	 .word 0xea24e000

	 .word 0xf2f4d100


.global ecc_err_85 
ecc_err_85:
!$EV error(0, expr(@VA(.MAIN.ecc_err_85),16,16),1, IC_DATA, IR,20,x) 
	 .word 0xefe4d000


.global ecc_err_86 
ecc_err_86:
!$EV error(0, expr(@VA(.MAIN.ecc_err_86),16,16),1, DC_DATA, 15) 
	 .word 0xefe4dc40

	 .word 0xebf4dc40


.global ecc_err_87 
ecc_err_87:
!$EV error(0, expr(@VA(.MAIN.ecc_err_87),16,16),1, DC_DATA, 33) 
	 .word 0xf2ccc580

	 .word 0xefe4c540

	 .word 0xea94d000

	 .word 0xf1f4e000

	 .word 0xebf4c480


.global ecc_err_88 
ecc_err_88:
!$EV error(0, expr(@VA(.MAIN.ecc_err_88),16,16),1, DC_DATA, 11) 
	 .word 0xee6ce007


.global ecc_err_89 
ecc_err_89:
!$EV error(0, expr(@VA(.MAIN.ecc_err_89),16,16),1, DC_TAG, 29) 
	 .word 0xfa7ce004


.global ecc_err_90 
ecc_err_90:
!$EV error(0, expr(@VA(.MAIN.ecc_err_90),16,16),1, IC_TAG, IR,13, x) 
	 .word 0xf644e004

	 .word 0xf2acdd40

	 .word 0xecbce000


.global ecc_err_91 
ecc_err_91:
!$EV error(0, expr(@VA(.MAIN.ecc_err_91),16,16),1, DC_TAG, 30) 
	 .word 0xf3e4e000


.global ecc_err_92 
ecc_err_92:
!$EV error(0, expr(@VA(.MAIN.ecc_err_92),16,16),1, IC_TAG, IR,15, x) 
	 .word 0xee04c000


.global ecc_err_93 
ecc_err_93:
!$EV error(0, expr(@VA(.MAIN.ecc_err_93),16,16),1, DC_TAG, 41) 
	 .word 0xee6ce038


.global ecc_err_94 
ecc_err_94:
!$EV error(0, expr(@VA(.MAIN.ecc_err_94),16,16),1, DC_DATA, 12) 
	 .word 0xec84e000

	 .word 0xf8ece035

	 .word 0xf224e000

	 .word 0xf8b4e000


.global ecc_err_95 
ecc_err_95:
!$EV error(0, expr(@VA(.MAIN.ecc_err_95),16,16),1, DC_DATA, 16) 
	 .word 0xf7e4d000

	 .word 0xea24e000

	 .word 0xefe4e000


.global ecc_err_96 
ecc_err_96:
!$EV error(0, expr(@VA(.MAIN.ecc_err_96),16,16),1, DC_TAG, 13) 
	 .word 0xf66cc000


.global ecc_err_97 
ecc_err_97:
!$EV error(0, expr(@VA(.MAIN.ecc_err_97),16,16),1, DC_DATA, 32) 
	 .word 0xf1f4c560

	 .word 0xf2fcd020


.global ecc_err_98 
ecc_err_98:
!$EV error(0, expr(@VA(.MAIN.ecc_err_98),16,16),1, IC_DATA, IR,10,x) 
	 .word 0xf24ce00f

	 .word 0xee5ce000

	 .word 0xedf4e000

	 .word 0xf5e4e000


.global ecc_err_99 
ecc_err_99:
!$EV error(0, expr(@VA(.MAIN.ecc_err_99),16,16),1, DC_TAG, 47) 
	 .word 0xf9e4d120


.global ecc_err_100 
ecc_err_100:
!$EV error(0, expr(@VA(.MAIN.ecc_err_100),16,16),1, DC_TAG, 63) 
	 .word 0xf5e4d120

	 .word 0xebe4c480

	 .word 0xeeb4d000

	 .word 0xf07ce000


.global ecc_err_101 
ecc_err_101:
!$EV error(0, expr(@VA(.MAIN.ecc_err_101),16,16),1, DC_DATA, 42) 
	 .word 0xedf4e000


.global ecc_err_102 
ecc_err_102:
!$EV error(0, expr(@VA(.MAIN.ecc_err_102),16,16),1, IC_TAG, IR,5, x) 
	 .word 0xfa84e000

	 .word 0xede4e000

	 .word 0xecf4e008

	 .word 0xf1f4dc60


.global ecc_err_103 
ecc_err_103:
!$EV error(0, expr(@VA(.MAIN.ecc_err_103),16,16),1, DC_TAG, 2) 
	 .word 0xfa7cc000

	 .word 0xf86cc000


.global ecc_err_104 
ecc_err_104:
!$EV error(0, expr(@VA(.MAIN.ecc_err_104),16,16),1, DC_TAG, 36) 
	 .word 0xf64ce010


.global ecc_err_105 
ecc_err_105:
!$EV error(0, expr(@VA(.MAIN.ecc_err_105),16,16),1, IC_TAG, IR,26, x) 
	 .word 0xf48ce006


.global ecc_err_106 
ecc_err_106:
!$EV error(0, expr(@VA(.MAIN.ecc_err_106),16,16),1, IC_TAG, IR,15, x) 
	 .word 0xfa0cc000


.global ecc_err_107 
ecc_err_107:
!$EV error(0, expr(@VA(.MAIN.ecc_err_107),16,16),1, DC_TAG, 60) 
	 .word 0xf46ce013


.global ecc_err_108 
ecc_err_108:
!$EV error(0, expr(@VA(.MAIN.ecc_err_108),16,16),1, IC_DATA, IR,11,x) 
	 .word 0xec7ce000


.global ecc_err_109 
ecc_err_109:
!$EV error(0, expr(@VA(.MAIN.ecc_err_109),16,16),1, IC_TAG, IR,10, x) 
	 .word 0xf4ecdd60

	 .word 0xea34e002


.global ecc_err_110 
ecc_err_110:
!$EV error(0, expr(@VA(.MAIN.ecc_err_110),16,16),1, DC_TAG, 37) 
	 .word 0xea7ce000


.global ecc_err_111 
ecc_err_111:
!$EV error(0, expr(@VA(.MAIN.ecc_err_111),16,16),1, DC_TAG, 44) 
	 .word 0xee7cc000


.global ecc_err_112 
ecc_err_112:
!$EV error(0, expr(@VA(.MAIN.ecc_err_112),16,16),1, DC_TAG, 13) 
	 .word 0xf7e4dc60

	 .word 0xeaece007


.global ecc_err_113 
ecc_err_113:
!$EV error(0, expr(@VA(.MAIN.ecc_err_113),16,16),1, IC_TAG, IR,29, x) 
	 .word 0xeff4c540


.global ecc_err_114 
ecc_err_114:
!$EV error(0, expr(@VA(.MAIN.ecc_err_114),16,16),1, DC_TAG, 26) 
	 .word 0xefe4e000


.global ecc_err_115 
ecc_err_115:
!$EV error(0, expr(@VA(.MAIN.ecc_err_115),16,16),1, DC_TAG, 20) 
	 .word 0xec6ce000


.global ecc_err_116 
ecc_err_116:
!$EV error(0, expr(@VA(.MAIN.ecc_err_116),16,16),1, IC_TAG, IR,9, x) 
	 .word 0xf66ce03d


.global ecc_err_117 
ecc_err_117:
!$EV error(0, expr(@VA(.MAIN.ecc_err_117),16,16),1, DC_DATA, 26) 
	 .word 0xf06cc000


.global ecc_err_118 
ecc_err_118:
!$EV error(0, expr(@VA(.MAIN.ecc_err_118),16,16),1, DC_DATA, 26) 
	 .word 0xf5e4e000

	 .word 0xecfce000

	 .word 0xf2ece03d

	 .word 0xf3f4e000

	 .word 0xf6ece013

	 .word 0xf5f4e000

	 .word 0xfa2cc000


.global ecc_err_119 
ecc_err_119:
!$EV error(0, expr(@VA(.MAIN.ecc_err_119),16,16),1, IC_TAG, IR,11, x) 
	 .word 0xf86ce016

	 .word 0xea7cc000

	 .word 0xfafcd000


.global ecc_err_120 
ecc_err_120:
!$EV error(0, expr(@VA(.MAIN.ecc_err_120),16,16),1, DC_DATA, 35) 
	 .word 0xf86cc000

	 .word 0xf5f4e000


.global ecc_err_121 
ecc_err_121:
!$EV error(0, expr(@VA(.MAIN.ecc_err_121),16,16),1, DC_TAG, 22) 
	 .word 0xf8dce000


.global ecc_err_122 
ecc_err_122:
!$EV error(0, expr(@VA(.MAIN.ecc_err_122),16,16),1, IC_TAG, IR,0, x) 
	 .word 0xee7ce004

	 .word 0xf6ece009


.global ecc_err_123 
ecc_err_123:
!$EV error(0, expr(@VA(.MAIN.ecc_err_123),16,16),1, IC_TAG, IR,1, x) 
	 .word 0xefe4e000

	 .word 0xf5e4e000

	 .word 0xee7ce004

	 .word 0xf0fcd000

	 .word 0xfa84e004


.global ecc_err_124 
ecc_err_124:
!$EV error(0, expr(@VA(.MAIN.ecc_err_124),16,16),1, DC_DATA, 44) 
	 .word 0xf27cc000

	 .word 0xecbcc580

	 .word 0xede4c440

	 .word 0xf044e004


.global ecc_err_125 
ecc_err_125:
!$EV error(0, expr(@VA(.MAIN.ecc_err_125),16,16),1, IC_DATA, IR,13,x) 
	 .word 0xee94d100

	 .word 0xf0a4d100


.global ecc_err_126 
ecc_err_126:
!$EV error(0, expr(@VA(.MAIN.ecc_err_126),16,16),1, DC_TAG, 13) 
	 .word 0xeeece02b

	 .word 0xfafce004

	 .word 0xfaccd020


.global ecc_err_127 
ecc_err_127:
!$EV error(0, expr(@VA(.MAIN.ecc_err_127),16,16),1, IC_TAG, IR,17, x) 
	 .word 0xf46cc000


.global ecc_err_128 
ecc_err_128:
!$EV error(0, expr(@VA(.MAIN.ecc_err_128),16,16),1, IC_DATA, IR,15,x) 
	 .word 0xf86cc000


.global ecc_err_129 
ecc_err_129:
!$EV error(0, expr(@VA(.MAIN.ecc_err_129),16,16),1, IC_DATA, IR,19,x) 
	 .word 0xec7ce000

	 .word 0xf26cc000


.global ecc_err_130 
ecc_err_130:
!$EV error(0, expr(@VA(.MAIN.ecc_err_130),16,16),1, DC_DATA, 47) 
	 .word 0xf27cc000

	 .word 0xf634e000

	 .word 0xfa84d120


.global ecc_err_131 
ecc_err_131:
!$EV error(0, expr(@VA(.MAIN.ecc_err_131),16,16),1, DC_DATA, 44) 
	 .word 0xf46ce03f

	 .word 0xf284d100

	 .word 0xecbcd000


.global ecc_err_132 
ecc_err_132:
!$EV error(0, expr(@VA(.MAIN.ecc_err_132),16,16),1, DC_TAG, 20) 
	 .word 0xf5e4e000

	 .word 0xf82cc000


.global ecc_err_133 
ecc_err_133:
!$EV error(0, expr(@VA(.MAIN.ecc_err_133),16,16),1, DC_TAG, 34) 
	 .word 0xf9f4d120


.global ecc_err_134 
ecc_err_134:
!$EV error(0, expr(@VA(.MAIN.ecc_err_134),16,16),1, DC_TAG, 43) 
	 .word 0xf844e000

	 .word 0xeedce008


.global ecc_err_135 
ecc_err_135:
!$EV error(0, expr(@VA(.MAIN.ecc_err_135),16,16),1, DC_DATA, 23) 
	 .word 0xf06cc000

	 .word 0xebf4e000

	 .word 0xee2ce004

	 .word 0xf8fcd100


.global ecc_err_136 
ecc_err_136:
!$EV error(0, expr(@VA(.MAIN.ecc_err_136),16,16),1, IC_TAG, IR,11, x) 
	 .word 0xececdc40

	 .word 0xf1e4e000

	 .word 0xf87cc000

	 .word 0xf0ece03b

	 .word 0xec1cc000

	 .word 0xf66cc000

	 .word 0xf66cc000

	 .word 0xebe4e000

	 .word 0xf0d4e002


.global ecc_err_137 
ecc_err_137:
!$EV error(0, expr(@VA(.MAIN.ecc_err_137),16,16),1, DC_DATA, 5) 
	 .word 0xf28ce039

	 .word 0xecbce000


.global ecc_err_138 
ecc_err_138:
!$EV error(0, expr(@VA(.MAIN.ecc_err_138),16,16),1, DC_TAG, 51) 
	 .word 0xf45cc000


.global ecc_err_139 
ecc_err_139:
!$EV error(0, expr(@VA(.MAIN.ecc_err_139),16,16),1, DC_DATA, 30) 
	 .word 0xfa8ce037

	 .word 0xeeece008

	 .word 0xea04e000

	 .word 0xfa44c000

	 .word 0xebe4e000

	 .word 0xf8d4d120


.global ecc_err_140 
ecc_err_140:
!$EV error(0, expr(@VA(.MAIN.ecc_err_140),16,16),1, DC_TAG, 59) 
	 .word 0xf40ce01e

	 .word 0xf8a4e004

	 .word 0xea6cc000


.global ecc_err_141 
ecc_err_141:
!$EV error(0, expr(@VA(.MAIN.ecc_err_141),16,16),1, DC_DATA, 13) 
	 .word 0xebe4dc40


.global ecc_err_142 
ecc_err_142:
!$EV error(0, expr(@VA(.MAIN.ecc_err_142),16,16),1, DC_TAG, 40) 
	 .word 0xeedce008


.global ecc_err_143 
ecc_err_143:
!$EV error(0, expr(@VA(.MAIN.ecc_err_143),16,16),1, DC_DATA, 37) 
	 .word 0xfa7ce004


.global ecc_err_144 
ecc_err_144:
!$EV error(0, expr(@VA(.MAIN.ecc_err_144),16,16),1, DC_DATA, 36) 
	 .word 0xf07cc000

	 .word 0xf404e000

	 .word 0xf47ce000

	 .word 0xf2fce000


.global ecc_err_145 
ecc_err_145:
!$EV error(0, expr(@VA(.MAIN.ecc_err_145),16,16),1, IC_DATA, IR,26,x) 
	 .word 0xebf4e000

	 .word 0xf6cce014


.global ecc_err_146 
ecc_err_146:
!$EV error(0, expr(@VA(.MAIN.ecc_err_146),16,16),1, IC_DATA, IR,7,x) 
	 .word 0xf67ce000


.global ecc_err_147 
ecc_err_147:
!$EV error(0, expr(@VA(.MAIN.ecc_err_147),16,16),1, IC_TAG, IR,5, x) 
	 .word 0xeeece00d

	 .word 0xeff4dc40


.global ecc_err_148 
ecc_err_148:
!$EV error(0, expr(@VA(.MAIN.ecc_err_148),16,16),1, DC_DATA, 52) 
	 .word 0xf214e002

	 .word 0xf46ce02a

	 .word 0xee4ce018


.global ecc_err_149 
ecc_err_149:
!$EV error(0, expr(@VA(.MAIN.ecc_err_149),16,16),1, DC_DATA, 7) 
	 .word 0xf4ece034


.global ecc_err_150 
ecc_err_150:
!$EV error(0, expr(@VA(.MAIN.ecc_err_150),16,16),1, DC_DATA, 10) 
	 .word 0xfa14c000

	 .word 0xf06ce02a


.global ecc_err_151 
ecc_err_151:
!$EV error(0, expr(@VA(.MAIN.ecc_err_151),16,16),1, IC_TAG, IR,15, x) 
	 .word 0xf0ece02f

	 .word 0xeff4dd60

	 .word 0xf0ecdd60


.global ecc_err_152 
ecc_err_152:
!$EV error(0, expr(@VA(.MAIN.ecc_err_152),16,16),1, IC_DATA, IR,11,x) 
	 .word 0xec9cd020

	 .word 0xf414e000

	 .word 0xec6cc000


.global ecc_err_153 
ecc_err_153:
!$EV error(0, expr(@VA(.MAIN.ecc_err_153),16,16),1, DC_DATA, 49) 
	 .word 0xfa7cc000


.global ecc_err_154 
ecc_err_154:
!$EV error(0, expr(@VA(.MAIN.ecc_err_154),16,16),1, DC_TAG, 36) 
	 .word 0xf86cc000

	 .word 0xeab4dc60

	 .word 0xebf4e000


.global ecc_err_155 
ecc_err_155:
!$EV error(0, expr(@VA(.MAIN.ecc_err_155),16,16),1, IC_TAG, IR,7, x) 
	 .word 0xeeece018

	 .word 0xebf4e000

	 .word 0xf094e000


.global ecc_err_156 
ecc_err_156:
!$EV error(0, expr(@VA(.MAIN.ecc_err_156),16,16),1, IC_DATA, IR,27,x) 
	 .word 0xf07ce000

	 .word 0xf8fcc560


.global ecc_err_157 
ecc_err_157:
!$EV error(0, expr(@VA(.MAIN.ecc_err_157),16,16),1, DC_DATA, 34) 
	 .word 0xf9e4d100

	 .word 0xf06ce018

	 .word 0xf46cc000


.global ecc_err_158 
ecc_err_158:
!$EV error(0, expr(@VA(.MAIN.ecc_err_158),16,16),1, DC_TAG, 27) 
	 .word 0xf7f4e000


.global ecc_err_159 
ecc_err_159:
!$EV error(0, expr(@VA(.MAIN.ecc_err_159),16,16),1, DC_DATA, 3) 
	 .word 0xec1cc000

	 .word 0xfa7cc000


.global ecc_err_160 
ecc_err_160:
!$EV error(0, expr(@VA(.MAIN.ecc_err_160),16,16),1, DC_TAG, 24) 
	 .word 0xf4ecc540

	 .word 0xeac4dc40

	 .word 0xf07ce004

	 .word 0xedf4dd40

	 .word 0xf27cc000


.global ecc_err_161 
ecc_err_161:
!$EV error(0, expr(@VA(.MAIN.ecc_err_161),16,16),1, IC_DATA, IR,28,x) 
	 .word 0xf86cc000

	 .word 0xeefce004


.global ecc_err_162 
ecc_err_162:
!$EV error(0, expr(@VA(.MAIN.ecc_err_162),16,16),1, IC_TAG, IR,31, x) 
	 .word 0xec7ce000

	 .word 0xf024e004

	 .word 0xeec4d000

	 .word 0xee6cc000

	 .word 0xeeecdd60

	 .word 0xf46ce001


.global ecc_err_163 
ecc_err_163:
!$EV error(0, expr(@VA(.MAIN.ecc_err_163),16,16),1, DC_TAG, 2) 
	 .word 0xedf4e000

	 .word 0xebe4d120

	 .word 0xeaece005

	 .word 0xf804c000

	 .word 0xf45cc000

	 .word 0xf0ecc580


.global ecc_err_164 
ecc_err_164:
!$EV error(0, expr(@VA(.MAIN.ecc_err_164),16,16),1, IC_TAG, IR,24, x) 
	 .word 0xea5ce008


.global ecc_err_165 
ecc_err_165:
!$EV error(0, expr(@VA(.MAIN.ecc_err_165),16,16),1, DC_TAG, 18) 
	 .word 0xf4ece01b


.global ecc_err_166 
ecc_err_166:
!$EV error(0, expr(@VA(.MAIN.ecc_err_166),16,16),1, DC_DATA, 55) 
	 .word 0xf9e4dc60

	 .word 0xea04c000

	 .word 0xf0f4e008

	 .word 0xeedce008

	 .word 0xececc460


.global ecc_err_167 
ecc_err_167:
!$EV error(0, expr(@VA(.MAIN.ecc_err_167),16,16),1, DC_TAG, 42) 
	 .word 0xf00cc000

	 .word 0xebf4c580

	 .word 0xf7f4d120


.global ecc_err_168 
ecc_err_168:
!$EV error(0, expr(@VA(.MAIN.ecc_err_168),16,16),1, DC_TAG, 9) 
	 .word 0xf694c480

	 .word 0xeefce004


.global ecc_err_169 
ecc_err_169:
!$EV error(0, expr(@VA(.MAIN.ecc_err_169),16,16),1, DC_TAG, 6) 
	 .word 0xea7cc000


.global ecc_err_170 
ecc_err_170:
!$EV error(0, expr(@VA(.MAIN.ecc_err_170),16,16),1, DC_DATA, 21) 
	 .word 0xf894e000

	 .word 0xf22cc000

	 .word 0xf284c480

	 .word 0xf9f4c560

	 .word 0xfa34c000


.global ecc_err_171 
ecc_err_171:
!$EV error(0, expr(@VA(.MAIN.ecc_err_171),16,16),1, DC_TAG, 46) 
	 .word 0xee6cc000


.global ecc_err_172 
ecc_err_172:
!$EV error(0, expr(@VA(.MAIN.ecc_err_172),16,16),1, DC_TAG, 54) 
	 .word 0xede4c440

	 .word 0xf26ce014


.global ecc_err_173 
ecc_err_173:
!$EV error(0, expr(@VA(.MAIN.ecc_err_173),16,16),1, DC_TAG, 45) 
	 .word 0xf6ecd100

	 .word 0xf04cc000


.global ecc_err_174 
ecc_err_174:
!$EV error(0, expr(@VA(.MAIN.ecc_err_174),16,16),1, IC_DATA, IR,6,x) 
	 .word 0xee4ce021


.global ecc_err_175 
ecc_err_175:
!$EV error(0, expr(@VA(.MAIN.ecc_err_175),16,16),1, DC_TAG, 24) 
	 .word 0xebf4c480


.global ecc_err_176 
ecc_err_176:
!$EV error(0, expr(@VA(.MAIN.ecc_err_176),16,16),1, DC_TAG, 56) 
	 .word 0xf3e4c560


.global ecc_err_177 
ecc_err_177:
!$EV error(0, expr(@VA(.MAIN.ecc_err_177),16,16),1, IC_TAG, IR,22, x) 
	 .word 0xececdc60


.global ecc_err_178 
ecc_err_178:
!$EV error(0, expr(@VA(.MAIN.ecc_err_178),16,16),1, IC_TAG, IR,17, x) 
	 .word 0xede4d120


.global ecc_err_179 
ecc_err_179:
!$EV error(0, expr(@VA(.MAIN.ecc_err_179),16,16),1, DC_TAG, 2) 
	 .word 0xf244e000


.global ecc_err_180 
ecc_err_180:
!$EV error(0, expr(@VA(.MAIN.ecc_err_180),16,16),1, DC_TAG, 61) 
	 .word 0xf7e4e000


.global ecc_err_181 
ecc_err_181:
!$EV error(0, expr(@VA(.MAIN.ecc_err_181),16,16),1, DC_DATA, 13) 
	 .word 0xec6ce03f

	 .word 0xf86cc000


.global ecc_err_182 
ecc_err_182:
!$EV error(0, expr(@VA(.MAIN.ecc_err_182),16,16),1, DC_TAG, 7) 
	 .word 0xeeecdc40


.global ecc_err_183 
ecc_err_183:
!$EV error(0, expr(@VA(.MAIN.ecc_err_183),16,16),1, DC_TAG, 26) 
	 .word 0xec9ce010


.global ecc_err_184 
ecc_err_184:
!$EV error(0, expr(@VA(.MAIN.ecc_err_184),16,16),1, IC_TAG, IR,23, x) 
	 .word 0xf2ccc540

	 .word 0xf5f4c560


.global ecc_err_185 
ecc_err_185:
!$EV error(0, expr(@VA(.MAIN.ecc_err_185),16,16),1, IC_TAG, IR,24, x) 
	 .word 0xf46cc000


.global ecc_err_186 
ecc_err_186:
!$EV error(0, expr(@VA(.MAIN.ecc_err_186),16,16),1, DC_DATA, 61) 
	 .word 0xf40ce023

	 .word 0xf294e000


.global ecc_err_187 
ecc_err_187:
!$EV error(0, expr(@VA(.MAIN.ecc_err_187),16,16),1, IC_TAG, IR,0, x) 
	 .word 0xf6c4e004


.global ecc_err_188 
ecc_err_188:
!$EV error(0, expr(@VA(.MAIN.ecc_err_188),16,16),1, IC_TAG, IR,1, x) 
	 .word 0xf8dcd000

	 .word 0xecbcdd60


.global ecc_err_189 
ecc_err_189:
!$EV error(0, expr(@VA(.MAIN.ecc_err_189),16,16),1, DC_TAG, 24) 
	 .word 0xfa5cc000


.global ecc_err_190 
ecc_err_190:
!$EV error(0, expr(@VA(.MAIN.ecc_err_190),16,16),1, IC_DATA, IR,4,x) 
	 .word 0xf67ce004


.global ecc_err_191 
ecc_err_191:
!$EV error(0, expr(@VA(.MAIN.ecc_err_191),16,16),1, IC_TAG, IR,25, x) 
	 .word 0xf2ecd100


.global ecc_err_192 
ecc_err_192:
!$EV error(0, expr(@VA(.MAIN.ecc_err_192),16,16),1, IC_DATA, IR,21,x) 
	 .word 0xea94c480


.global ecc_err_193 
ecc_err_193:
!$EV error(0, expr(@VA(.MAIN.ecc_err_193),16,16),1, DC_TAG, 1) 
	 .word 0xedf4e000

	 .word 0xf5f4c440


.global ecc_err_194 
ecc_err_194:
!$EV error(0, expr(@VA(.MAIN.ecc_err_194),16,16),1, DC_DATA, 52) 
	 .word 0xf67cc000

	 .word 0xecfce004

	 .word 0xf424e004

	 .word 0xeff4e000

	 .word 0xf4ece036


.global ecc_err_195 
ecc_err_195:
!$EV error(0, expr(@VA(.MAIN.ecc_err_195),16,16),1, IC_DATA, IR,6,x) 
	 .word 0xede4e000


.global ecc_err_196 
ecc_err_196:
!$EV error(0, expr(@VA(.MAIN.ecc_err_196),16,16),1, DC_TAG, 32) 
	 .word 0xf48cd100

	 .word 0xec3ce010

	 .word 0xf0ece02d


.global ecc_err_197 
ecc_err_197:
!$EV error(0, expr(@VA(.MAIN.ecc_err_197),16,16),1, IC_TAG, IR,7, x) 
	 .word 0xf2ecd120


.global ecc_err_198 
ecc_err_198:
!$EV error(0, expr(@VA(.MAIN.ecc_err_198),16,16),1, DC_TAG, 26) 
	 .word 0xfa7ce000

	 .word 0xefe4c460

	 .word 0xebe4c540

	 .word 0xf1f4dc40


.global ecc_err_199 
ecc_err_199:
!$EV error(0, expr(@VA(.MAIN.ecc_err_199),16,16),1, IC_TAG, IR,22, x) 
	 .word 0xf644e000


.global ecc_err_200 
ecc_err_200:
!$EV error(0, expr(@VA(.MAIN.ecc_err_200),16,16),1, IC_TAG, IR,4, x) 
	 .word 0xfa7cc000

	 .word 0xf6ecd100


.global ecc_err_201 
ecc_err_201:
!$EV error(0, expr(@VA(.MAIN.ecc_err_201),16,16),1, DC_TAG, 4) 
	 .word 0xecece005


.global ecc_err_202 
ecc_err_202:
!$EV error(0, expr(@VA(.MAIN.ecc_err_202),16,16),1, DC_TAG, 55) 
	 .word 0xec1cc000

	 .word 0xeaa4dd60


.global ecc_err_203 
ecc_err_203:
!$EV error(0, expr(@VA(.MAIN.ecc_err_203),16,16),1, DC_TAG, 53) 
	 .word 0xf7e4e000

	 .word 0xeca4dc40

	 .word 0xf6ecd100


.global ecc_err_204 
ecc_err_204:
!$EV error(0, expr(@VA(.MAIN.ecc_err_204),16,16),1, DC_DATA, 28) 
	 .word 0xf7e4e000


.global ecc_err_205 
ecc_err_205:
!$EV error(0, expr(@VA(.MAIN.ecc_err_205),16,16),1, IC_DATA, IR,21,x) 
	 .word 0xecd4c480


.global ecc_err_206 
ecc_err_206:
!$EV error(0, expr(@VA(.MAIN.ecc_err_206),16,16),1, DC_TAG, 13) 
	 .word 0xee6ce02c

	 .word 0xf4ecdc40

	 .word 0xee2ce036


.global ecc_err_207 
ecc_err_207:
!$EV error(0, expr(@VA(.MAIN.ecc_err_207),16,16),1, IC_DATA, IR,4,x) 
	 .word 0xf46cc000

	 .word 0xecbcdc40

	 .word 0xf3e4e000

	 .word 0xf474c000

	 .word 0xeeece020

	 .word 0xf874e000


.global ecc_err_208 
ecc_err_208:
!$EV error(0, expr(@VA(.MAIN.ecc_err_208),16,16),1, IC_TAG, IR,17, x) 
	 .word 0xf44ce035


.global ecc_err_209 
ecc_err_209:
!$EV error(0, expr(@VA(.MAIN.ecc_err_209),16,16),1, DC_DATA, 11) 
	 .word 0xf80ce029

	 .word 0xfa04c000


.global ecc_err_210 
ecc_err_210:
!$EV error(0, expr(@VA(.MAIN.ecc_err_210),16,16),1, IC_TAG, IR,29, x) 
	 .word 0xea6cc000

	 .word 0xeff4e000


.global ecc_err_211 
ecc_err_211:
!$EV error(0, expr(@VA(.MAIN.ecc_err_211),16,16),1, DC_TAG, 57) 
	 .word 0xf47cc000

	 .word 0xf5f4dc40


.global ecc_err_212 
ecc_err_212:
!$EV error(0, expr(@VA(.MAIN.ecc_err_212),16,16),1, IC_TAG, IR,3, x) 
	 .word 0xf86cc000

	 .word 0xf08ce02b


.global ecc_err_213 
ecc_err_213:
!$EV error(0, expr(@VA(.MAIN.ecc_err_213),16,16),1, IC_TAG, IR,23, x) 
	 .word 0xf614e000


.global ecc_err_214 
ecc_err_214:
!$EV error(0, expr(@VA(.MAIN.ecc_err_214),16,16),1, IC_TAG, IR,25, x) 
	 .word 0xf65cc000

	 .word 0xf07cc000

	 .word 0xf234c000

	 .word 0xebe4e000


.global ecc_err_215 
ecc_err_215:
!$EV error(0, expr(@VA(.MAIN.ecc_err_215),16,16),1, IC_DATA, IR,13,x) 
	 .word 0xede4c460

	 .word 0xf2ece02b

	 .word 0xf874e008

	 .word 0xf4ecd100


.global ecc_err_216 
ecc_err_216:
!$EV error(0, expr(@VA(.MAIN.ecc_err_216),16,16),1, IC_DATA, IR,2,x) 
	 .word 0xf054c000


.global ecc_err_217 
ecc_err_217:
!$EV error(0, expr(@VA(.MAIN.ecc_err_217),16,16),1, DC_TAG, 11) 
	 .word 0xf7f4e000

	 .word 0xecccc560


.global ecc_err_218 
ecc_err_218:
!$EV error(0, expr(@VA(.MAIN.ecc_err_218),16,16),1, DC_TAG, 10) 
	 .word 0xf86ce02a


.global ecc_err_219 
ecc_err_219:
!$EV error(0, expr(@VA(.MAIN.ecc_err_219),16,16),1, IC_TAG, IR,10, x) 
	 .word 0xf5f4e000


.global ecc_err_220 
ecc_err_220:
!$EV error(0, expr(@VA(.MAIN.ecc_err_220),16,16),1, IC_DATA, IR,24,x) 
	 .word 0xea84dd60

	 .word 0xf26cc000

	 .word 0xf4f4c460

	 .word 0xee7cc000

	 .word 0xf44ce004


.global ecc_err_221 
ecc_err_221:
!$EV error(0, expr(@VA(.MAIN.ecc_err_221),16,16),1, DC_TAG, 8) 
	 .word 0xf0ece013

	 .word 0xecece015


.global ecc_err_222 
ecc_err_222:
!$EV error(0, expr(@VA(.MAIN.ecc_err_222),16,16),1, IC_TAG, IR,11, x) 
	 .word 0xf8c4c440

	 .word 0xf3e4dd60

	 .word 0xf614e000

	 .word 0xea6ce036


.global ecc_err_223 
ecc_err_223:
!$EV error(0, expr(@VA(.MAIN.ecc_err_223),16,16),1, IC_TAG, IR,12, x) 
	 .word 0xec6cc000


.global ecc_err_224 
ecc_err_224:
!$EV error(0, expr(@VA(.MAIN.ecc_err_224),16,16),1, IC_DATA, IR,23,x) 
	 .word 0xeeece01f


.global ecc_err_225 
ecc_err_225:
!$EV error(0, expr(@VA(.MAIN.ecc_err_225),16,16),1, IC_TAG, IR,15, x) 
	 .word 0xf8ecc580


.global ecc_err_226 
ecc_err_226:
!$EV error(0, expr(@VA(.MAIN.ecc_err_226),16,16),1, IC_TAG, IR,6, x) 
	 .word 0xf6ece031

	 .word 0xf9f4e000

	 .word 0xf27ce000

	 .word 0xf054c000

	 .word 0xf9f4d020


.global ecc_err_227 
ecc_err_227:
!$EV error(0, expr(@VA(.MAIN.ecc_err_227),16,16),1, IC_DATA, IR,0,x) 
	 .word 0xebe4dc60


.global ecc_err_228 
ecc_err_228:
!$EV error(0, expr(@VA(.MAIN.ecc_err_228),16,16),1, DC_DATA, 14) 
	 .word 0xf494dd60

	 .word 0xea7ce004


.global ecc_err_229 
ecc_err_229:
!$EV error(0, expr(@VA(.MAIN.ecc_err_229),16,16),1, DC_TAG, 43) 
	 .word 0xf8ecc480

	 .word 0xf0cce030


.global ecc_err_230 
ecc_err_230:
!$EV error(0, expr(@VA(.MAIN.ecc_err_230),16,16),1, IC_DATA, IR,2,x) 
	 .word 0xf3f4d020


.global ecc_err_231 
ecc_err_231:
!$EV error(0, expr(@VA(.MAIN.ecc_err_231),16,16),1, DC_TAG, 50) 
	 .word 0xf68cc440

	 .word 0xecece003

	 .word 0xecbcc540


.global ecc_err_232 
ecc_err_232:
!$EV error(0, expr(@VA(.MAIN.ecc_err_232),16,16),1, IC_TAG, IR,24, x) 
	 .word 0xf1f4dd40


.global ecc_err_233 
ecc_err_233:
!$EV error(0, expr(@VA(.MAIN.ecc_err_233),16,16),1, IC_TAG, IR,11, x) 
	 .word 0xec6cc000

	 .word 0xf644e004


.global ecc_err_234 
ecc_err_234:
!$EV error(0, expr(@VA(.MAIN.ecc_err_234),16,16),1, DC_DATA, 60) 
	 .word 0xec7ce004

	 .word 0xeeecc540


.global ecc_err_235 
ecc_err_235:
!$EV error(0, expr(@VA(.MAIN.ecc_err_235),16,16),1, DC_DATA, 21) 
	 .word 0xf2ecd000


.global ecc_err_236 
ecc_err_236:
!$EV error(0, expr(@VA(.MAIN.ecc_err_236),16,16),1, DC_TAG, 31) 
	 .word 0xede4e000

	 .word 0xf87ce004

	 .word 0xf62cc000

	 .word 0xf9e4e000

	 .word 0xeeb4d000

	 .word 0xec34c000


.global ecc_err_237 
ecc_err_237:
!$EV error(0, expr(@VA(.MAIN.ecc_err_237),16,16),1, DC_DATA, 45) 
	 .word 0xf9e4e000


.global ecc_err_238 
ecc_err_238:
!$EV error(0, expr(@VA(.MAIN.ecc_err_238),16,16),1, DC_DATA, 35) 
	 .word 0xefe4e000

	 .word 0xf8fcd120


.global ecc_err_239 
ecc_err_239:
!$EV error(0, expr(@VA(.MAIN.ecc_err_239),16,16),1, DC_DATA, 44) 
	 .word 0xee7cc000

	 .word 0xea34c000

	 .word 0xf5e4d120


.global ecc_err_240 
ecc_err_240:
!$EV error(0, expr(@VA(.MAIN.ecc_err_240),16,16),1, DC_TAG, 45) 
	 .word 0xf5f4e000


.global ecc_err_241 
ecc_err_241:
!$EV error(0, expr(@VA(.MAIN.ecc_err_241),16,16),1, DC_TAG, 9) 
	 .word 0xf9e4d100

	 .word 0xea6cc000

	 .word 0xfa14e002

	 .word 0xf4ecd000


.global ecc_err_242 
ecc_err_242:
!$EV error(0, expr(@VA(.MAIN.ecc_err_242),16,16),1, IC_TAG, IR,19, x) 
	 .word 0xf3e4c580

	 .word 0xf0fcdd60


.global ecc_err_243 
ecc_err_243:
!$EV error(0, expr(@VA(.MAIN.ecc_err_243),16,16),1, DC_DATA, 8) 
	 .word 0xf0dcc460


.global ecc_err_244 
ecc_err_244:
!$EV error(0, expr(@VA(.MAIN.ecc_err_244),16,16),1, DC_TAG, 14) 
	 .word 0xf06cc000


.global ecc_err_245 
ecc_err_245:
!$EV error(0, expr(@VA(.MAIN.ecc_err_245),16,16),1, IC_TAG, IR,3, x) 
	 .word 0xf26cc000


.global ecc_err_246 
ecc_err_246:
!$EV error(0, expr(@VA(.MAIN.ecc_err_246),16,16),1, DC_DATA, 27) 
	 .word 0xf3e4e000

	 .word 0xf0fce004


.global ecc_err_247 
ecc_err_247:
!$EV error(0, expr(@VA(.MAIN.ecc_err_247),16,16),1, IC_TAG, IR,15, x) 
	 .word 0xf2dcc540


.global ecc_err_248 
ecc_err_248:
!$EV error(0, expr(@VA(.MAIN.ecc_err_248),16,16),1, DC_DATA, 59) 
	 .word 0xec8cdc40

	 .word 0xecc4e000


.global ecc_err_249 
ecc_err_249:
!$EV error(0, expr(@VA(.MAIN.ecc_err_249),16,16),1, DC_DATA, 46) 
	 .word 0xec1ce010


.global ecc_err_250 
ecc_err_250:
!$EV error(0, expr(@VA(.MAIN.ecc_err_250),16,16),1, IC_DATA, IR,30,x) 
	 .word 0xf214e002

	 .word 0xf5e4d120

	 .word 0xf254c000


.global ecc_err_251 
ecc_err_251:
!$EV error(0, expr(@VA(.MAIN.ecc_err_251),16,16),1, IC_DATA, IR,1,x) 
	 .word 0xec1cc000


.global ecc_err_252 
ecc_err_252:
!$EV error(0, expr(@VA(.MAIN.ecc_err_252),16,16),1, IC_TAG, IR,3, x) 
	 .word 0xfa94d100


.global ecc_err_253 
ecc_err_253:
!$EV error(0, expr(@VA(.MAIN.ecc_err_253),16,16),1, DC_TAG, 23) 
	 .word 0xf0ecd000


.global ecc_err_254 
ecc_err_254:
!$EV error(0, expr(@VA(.MAIN.ecc_err_254),16,16),1, DC_DATA, 51) 
	 .word 0xf5f4e000


.global ecc_err_255 
ecc_err_255:
!$EV error(0, expr(@VA(.MAIN.ecc_err_255),16,16),1, DC_DATA, 12) 
	 .word 0xf3e4d020


.global ecc_err_256 
ecc_err_256:
!$EV error(0, expr(@VA(.MAIN.ecc_err_256),16,16),1, DC_DATA, 4) 
	 .word 0xf9f4c580


.global ecc_err_257 
ecc_err_257:
!$EV error(0, expr(@VA(.MAIN.ecc_err_257),16,16),1, IC_TAG, IR,19, x) 
	 .word 0xf27ce000


.global ecc_err_258 
ecc_err_258:
!$EV error(0, expr(@VA(.MAIN.ecc_err_258),16,16),1, DC_TAG, 14) 
	 .word 0xec1cc000


.global ecc_err_259 
ecc_err_259:
!$EV error(0, expr(@VA(.MAIN.ecc_err_259),16,16),1, DC_DATA, 60) 
	 .word 0xf0ece032


.global ecc_err_260 
ecc_err_260:
!$EV error(0, expr(@VA(.MAIN.ecc_err_260),16,16),1, IC_DATA, IR,16,x) 
	 .word 0xf8ece02c

	 .word 0xfad4e000

	 .word 0xeaccdc60

	 .word 0xf5e4e000


.global ecc_err_261 
ecc_err_261:
!$EV error(0, expr(@VA(.MAIN.ecc_err_261),16,16),1, IC_TAG, IR,20, x) 
	 .word 0xf1f4dc40


.global ecc_err_262 
ecc_err_262:
!$EV error(0, expr(@VA(.MAIN.ecc_err_262),16,16),1, IC_DATA, IR,6,x) 
	 .word 0xf9e4e000

	 .word 0xf87cc000


.global ecc_err_263 
ecc_err_263:
!$EV error(0, expr(@VA(.MAIN.ecc_err_263),16,16),1, DC_DATA, 35) 
	 .word 0xf46cc000


.global ecc_err_264 
ecc_err_264:
!$EV error(0, expr(@VA(.MAIN.ecc_err_264),16,16),1, DC_TAG, 58) 
	 .word 0xf87cc000


.global ecc_err_265 
ecc_err_265:
!$EV error(0, expr(@VA(.MAIN.ecc_err_265),16,16),1, DC_TAG, 49) 
	 .word 0xedf4d100

	 .word 0xf7f4c460


.global ecc_err_266 
ecc_err_266:
!$EV error(0, expr(@VA(.MAIN.ecc_err_266),16,16),1, IC_TAG, IR,1, x) 
	 .word 0xf1f4e000


.global ecc_err_267 
ecc_err_267:
!$EV error(0, expr(@VA(.MAIN.ecc_err_267),16,16),1, IC_TAG, IR,21, x) 
	 .word 0xf07ce000

	 .word 0xfa7ce004


.global ecc_err_268 
ecc_err_268:
!$EV error(0, expr(@VA(.MAIN.ecc_err_268),16,16),1, DC_DATA, 10) 
	 .word 0xede4c580

	 .word 0xebf4e000


.global ecc_err_269 
ecc_err_269:
!$EV error(0, expr(@VA(.MAIN.ecc_err_269),16,16),1, DC_DATA, 13) 
	 .word 0xf1f4d100

	 .word 0xf694e002


.global ecc_err_270 
ecc_err_270:
!$EV error(0, expr(@VA(.MAIN.ecc_err_270),16,16),1, DC_DATA, 22) 
	 .word 0xf47ce004


.global ecc_err_271 
ecc_err_271:
!$EV error(0, expr(@VA(.MAIN.ecc_err_271),16,16),1, DC_TAG, 29) 
	 .word 0xf844e004


.global ecc_err_272 
ecc_err_272:
!$EV error(0, expr(@VA(.MAIN.ecc_err_272),16,16),1, DC_DATA, 11) 
	 .word 0xede4e000


.global ecc_err_273 
ecc_err_273:
!$EV error(0, expr(@VA(.MAIN.ecc_err_273),16,16),1, DC_DATA, 6) 
	 .word 0xf1e4e000

	 .word 0xecb4d100


.global ecc_err_274 
ecc_err_274:
!$EV error(0, expr(@VA(.MAIN.ecc_err_274),16,16),1, DC_TAG, 4) 
	 .word 0xf26cc000


.global ecc_err_275 
ecc_err_275:
!$EV error(0, expr(@VA(.MAIN.ecc_err_275),16,16),1, DC_DATA, 42) 
	 .word 0xececc460


.global ecc_err_276 
ecc_err_276:
!$EV error(0, expr(@VA(.MAIN.ecc_err_276),16,16),1, DC_TAG, 19) 
	 .word 0xefe4e000

	 .word 0xf08ce03d

	 .word 0xeff4c460

	 .word 0xf474e008


.global ecc_err_277 
ecc_err_277:
!$EV error(0, expr(@VA(.MAIN.ecc_err_277),16,16),1, IC_TAG, IR,19, x) 
	 .word 0xf1f4e000

	 .word 0xf27ce000


.global ecc_err_278 
ecc_err_278:
!$EV error(0, expr(@VA(.MAIN.ecc_err_278),16,16),1, DC_TAG, 28) 
	 .word 0xf044e004


.global ecc_err_279 
ecc_err_279:
!$EV error(0, expr(@VA(.MAIN.ecc_err_279),16,16),1, IC_DATA, IR,16,x) 
	 .word 0xeeecc540

	 .word 0xeaecdc40

	 .word 0xebf4c560


.global ecc_err_280 
ecc_err_280:
!$EV error(0, expr(@VA(.MAIN.ecc_err_280),16,16),1, IC_TAG, IR,28, x) 
	 .word 0xf4ece00e


.global ecc_err_281 
ecc_err_281:
!$EV error(0, expr(@VA(.MAIN.ecc_err_281),16,16),1, IC_DATA, IR,25,x) 
	 .word 0xf46cc000


.global ecc_err_282 
ecc_err_282:
!$EV error(0, expr(@VA(.MAIN.ecc_err_282),16,16),1, DC_DATA, 34) 
	 .word 0xf1f4e000

	 .word 0xf66ce00c

	 .word 0xecc4e004

	 .word 0xf66cc000


.global ecc_err_283 
ecc_err_283:
!$EV error(0, expr(@VA(.MAIN.ecc_err_283),16,16),1, DC_TAG, 25) 
	 .word 0xf27ce004


.global ecc_err_284 
ecc_err_284:
!$EV error(0, expr(@VA(.MAIN.ecc_err_284),16,16),1, DC_TAG, 18) 
	 .word 0xf7e4dc60

	 .word 0xfa7ce000


.global ecc_err_285 
ecc_err_285:
!$EV error(0, expr(@VA(.MAIN.ecc_err_285),16,16),1, IC_TAG, IR,15, x) 
	 .word 0xf87cc000

	 .word 0xee54c000

	 .word 0xeac4e000


.global ecc_err_286 
ecc_err_286:
!$EV error(0, expr(@VA(.MAIN.ecc_err_286),16,16),1, DC_TAG, 22) 
	 .word 0xee7ce004


.global ecc_err_287 
ecc_err_287:
!$EV error(0, expr(@VA(.MAIN.ecc_err_287),16,16),1, DC_DATA, 32) 
	 .word 0xf6c4e000

	 .word 0xf05ce008


.global ecc_err_288 
ecc_err_288:
!$EV error(0, expr(@VA(.MAIN.ecc_err_288),16,16),1, DC_DATA, 48) 
	 .word 0xf0c4c580


.global ecc_err_289 
ecc_err_289:
!$EV error(0, expr(@VA(.MAIN.ecc_err_289),16,16),1, IC_TAG, IR,13, x) 
	 .word 0xf45cc000


.global ecc_err_290 
ecc_err_290:
!$EV error(0, expr(@VA(.MAIN.ecc_err_290),16,16),1, DC_TAG, 26) 
	 .word 0xf5f4d020


.global ecc_err_291 
ecc_err_291:
!$EV error(0, expr(@VA(.MAIN.ecc_err_291),16,16),1, DC_TAG, 6) 
	 .word 0xf6c4e004


.global ecc_err_292 
ecc_err_292:
!$EV error(0, expr(@VA(.MAIN.ecc_err_292),16,16),1, IC_TAG, IR,18, x) 
	 .word 0xf46ce03c

	 .word 0xf2fcc440

	 .word 0xea44e000

	 .word 0xf214c000

	 .word 0xf0a4c540


.global ecc_err_293 
ecc_err_293:
!$EV error(0, expr(@VA(.MAIN.ecc_err_293),16,16),1, DC_DATA, 0) 
	 .word 0xf6c4dc60


.global ecc_err_294 
ecc_err_294:
!$EV error(0, expr(@VA(.MAIN.ecc_err_294),16,16),1, DC_DATA, 31) 
	 .word 0xf444e000

	 .word 0xf24cc000


.global ecc_err_295 
ecc_err_295:
!$EV error(0, expr(@VA(.MAIN.ecc_err_295),16,16),1, DC_DATA, 30) 
	 .word 0xf9e4dd60


.global ecc_err_296 
ecc_err_296:
!$EV error(0, expr(@VA(.MAIN.ecc_err_296),16,16),1, DC_DATA, 17) 
	 .word 0xec9cd120


.global ecc_err_297 
ecc_err_297:
!$EV error(0, expr(@VA(.MAIN.ecc_err_297),16,16),1, IC_TAG, IR,30, x) 
	 .word 0xf2ecc540

	 .word 0xf684dc40

	 .word 0xebe4e000

	 .word 0xf2ece030


.global ecc_err_298 
ecc_err_298:
!$EV error(0, expr(@VA(.MAIN.ecc_err_298),16,16),1, IC_TAG, IR,5, x) 
	 .word 0xf5f4e000


.global ecc_err_299 
ecc_err_299:
!$EV error(0, expr(@VA(.MAIN.ecc_err_299),16,16),1, DC_TAG, 8) 
	 .word 0xf094d120


.global ecc_err_300 
ecc_err_300:
!$EV error(0, expr(@VA(.MAIN.ecc_err_300),16,16),1, DC_DATA, 26) 
	 .word 0xf4c4d020


.global ecc_err_301 
ecc_err_301:
!$EV error(0, expr(@VA(.MAIN.ecc_err_301),16,16),1, IC_DATA, IR,9,x) 
	 .word 0xf2ece00c

	 .word 0xeed4e000

	 .word 0xf854c000


.global ecc_err_302 
ecc_err_302:
!$EV error(0, expr(@VA(.MAIN.ecc_err_302),16,16),1, IC_DATA, IR,8,x) 
	 .word 0xec1cc000


.global ecc_err_303 
ecc_err_303:
!$EV error(0, expr(@VA(.MAIN.ecc_err_303),16,16),1, DC_TAG, 19) 
	 .word 0xee8cdd60


.global ecc_err_304 
ecc_err_304:
!$EV error(0, expr(@VA(.MAIN.ecc_err_304),16,16),1, IC_TAG, IR,8, x) 
	 .word 0xf1f4c480


.global ecc_err_305 
ecc_err_305:
!$EV error(0, expr(@VA(.MAIN.ecc_err_305),16,16),1, DC_DATA, 49) 
	 .word 0xf66cc000


.global ecc_err_306 
ecc_err_306:
!$EV error(0, expr(@VA(.MAIN.ecc_err_306),16,16),1, DC_DATA, 47) 
	 .word 0xf6ecc480

	 .word 0xeedce000


.global ecc_err_307 
ecc_err_307:
!$EV error(0, expr(@VA(.MAIN.ecc_err_307),16,16),1, IC_DATA, IR,23,x) 
	 .word 0xf9e4d120


.global ecc_err_308 
ecc_err_308:
!$EV error(0, expr(@VA(.MAIN.ecc_err_308),16,16),1, IC_TAG, IR,10, x) 
	 .word 0xf6c4c460

	 .word 0xf014c000

	 .word 0xea6ce013

	 .word 0xfa2cc000

	 .word 0xf26ce037


.global ecc_err_309 
ecc_err_309:
!$EV error(0, expr(@VA(.MAIN.ecc_err_309),16,16),1, IC_DATA, IR,16,x) 
	 .word 0xf3e4c460

	 .word 0xf4ecdc60


.global ecc_err_310 
ecc_err_310:
!$EV error(0, expr(@VA(.MAIN.ecc_err_310),16,16),1, IC_TAG, IR,11, x) 
	 .word 0xea6ce018


.global ecc_err_311 
ecc_err_311:
!$EV error(0, expr(@VA(.MAIN.ecc_err_311),16,16),1, DC_DATA, 60) 
	 .word 0xec8cc540

	 .word 0xecbcdd40

	 .word 0xf0fcdd40


.global ecc_err_312 
ecc_err_312:
!$EV error(0, expr(@VA(.MAIN.ecc_err_312),16,16),1, IC_DATA, IR,26,x) 
	 .word 0xf8ecdd60

	 .word 0xf3e4dc60


.global ecc_err_313 
ecc_err_313:
!$EV error(0, expr(@VA(.MAIN.ecc_err_313),16,16),1, DC_DATA, 28) 
	 .word 0xf7f4c540


.global ecc_err_314 
ecc_err_314:
!$EV error(0, expr(@VA(.MAIN.ecc_err_314),16,16),1, IC_DATA, IR,28,x) 
	 .word 0xf7e4e000


.global ecc_err_315 
ecc_err_315:
!$EV error(0, expr(@VA(.MAIN.ecc_err_315),16,16),1, DC_DATA, 5) 
	 .word 0xf0ecd100

	 .word 0xea74c000

	 .word 0xfafce000

	 .word 0xf26cc000

	 .word 0xecfcc540

	 .word 0xf67ce000

	 .word 0xf6fce004


.global ecc_err_316 
ecc_err_316:
!$EV error(0, expr(@VA(.MAIN.ecc_err_316),16,16),1, DC_DATA, 0) 
	 .word 0xf7e4d100

	 .word 0xec14c000

	 .word 0xf6acc480


.global ecc_err_317 
ecc_err_317:
!$EV error(0, expr(@VA(.MAIN.ecc_err_317),16,16),1, IC_DATA, IR,27,x) 
	 .word 0xf46cc000


.global ecc_err_318 
ecc_err_318:
!$EV error(0, expr(@VA(.MAIN.ecc_err_318),16,16),1, IC_TAG, IR,8, x) 
	 .word 0xebf4d000

	 .word 0xf084e000

	 .word 0xecbce010


.global ecc_err_319 
ecc_err_319:
!$EV error(0, expr(@VA(.MAIN.ecc_err_319),16,16),1, DC_DATA, 51) 
	 .word 0xec7cc000


.global ecc_err_320 
ecc_err_320:
!$EV error(0, expr(@VA(.MAIN.ecc_err_320),16,16),1, DC_DATA, 45) 
	 .word 0xec1cc000


.global ecc_err_321 
ecc_err_321:
!$EV error(0, expr(@VA(.MAIN.ecc_err_321),16,16),1, IC_DATA, IR,7,x) 
	 .word 0xf8ecc540


.global ecc_err_322 
ecc_err_322:
!$EV error(0, expr(@VA(.MAIN.ecc_err_322),16,16),1, IC_TAG, IR,20, x) 
	 .word 0xefe4e000


.global ecc_err_323 
ecc_err_323:
!$EV error(0, expr(@VA(.MAIN.ecc_err_323),16,16),1, DC_TAG, 29) 
	 .word 0xf9f4e000


.global ecc_err_324 
ecc_err_324:
!$EV error(0, expr(@VA(.MAIN.ecc_err_324),16,16),1, IC_DATA, IR,6,x) 
	 .word 0xf9e4e000


.global ecc_err_325 
ecc_err_325:
!$EV error(0, expr(@VA(.MAIN.ecc_err_325),16,16),1, DC_TAG, 3) 
	 .word 0xf6ece039


.global ecc_err_326 
ecc_err_326:
!$EV error(0, expr(@VA(.MAIN.ecc_err_326),16,16),1, DC_TAG, 63) 
	 .word 0xefe4c540

	 .word 0xf6f4dd40


.global ecc_err_327 
ecc_err_327:
!$EV error(0, expr(@VA(.MAIN.ecc_err_327),16,16),1, DC_DATA, 17) 
	 .word 0xf84ce018


.global ecc_err_328 
ecc_err_328:
!$EV error(0, expr(@VA(.MAIN.ecc_err_328),16,16),1, DC_TAG, 16) 
	 .word 0xec9ce010

	 .word 0xebf4e000

	 .word 0xebf4e000


.global ecc_err_329 
ecc_err_329:
!$EV error(0, expr(@VA(.MAIN.ecc_err_329),16,16),1, IC_DATA, IR,22,x) 
	 .word 0xee6cc000


.global ecc_err_330 
ecc_err_330:
!$EV error(0, expr(@VA(.MAIN.ecc_err_330),16,16),1, DC_TAG, 25) 
	 .word 0xefe4d100

	 .word 0xecfce004

	 .word 0xf8ecd020

	 .word 0xfa94e002


.global ecc_err_331 
ecc_err_331:
!$EV error(0, expr(@VA(.MAIN.ecc_err_331),16,16),1, IC_TAG, IR,6, x) 
	 .word 0xf7f4dc60


.global ecc_err_332 
ecc_err_332:
!$EV error(0, expr(@VA(.MAIN.ecc_err_332),16,16),1, IC_TAG, IR,23, x) 
	 .word 0xf26cc000


.global ecc_err_333 
ecc_err_333:
!$EV error(0, expr(@VA(.MAIN.ecc_err_333),16,16),1, DC_DATA, 54) 
	 .word 0xf9f4c560


.global ecc_err_334 
ecc_err_334:
!$EV error(0, expr(@VA(.MAIN.ecc_err_334),16,16),1, DC_TAG, 36) 
	 .word 0xf3f4d000

	 .word 0xf034c000


.global ecc_err_335 
ecc_err_335:
!$EV error(0, expr(@VA(.MAIN.ecc_err_335),16,16),1, DC_TAG, 23) 
	 .word 0xea7cc000

	 .word 0xeaecc580

	 .word 0xecbcd000

	 .word 0xf5f4c580


.global ecc_err_336 
ecc_err_336:
!$EV error(0, expr(@VA(.MAIN.ecc_err_336),16,16),1, DC_DATA, 5) 
	 .word 0xede4d020

	 .word 0xf86cc000


.global ecc_err_337 
ecc_err_337:
!$EV error(0, expr(@VA(.MAIN.ecc_err_337),16,16),1, DC_DATA, 15) 
	 .word 0xebf4e000


.global ecc_err_338 
ecc_err_338:
!$EV error(0, expr(@VA(.MAIN.ecc_err_338),16,16),1, IC_TAG, IR,4, x) 
	 .word 0xea6ce01c


.global ecc_err_339 
ecc_err_339:
!$EV error(0, expr(@VA(.MAIN.ecc_err_339),16,16),1, DC_TAG, 15) 
	 .word 0xf2ece02c


.global ecc_err_340 
ecc_err_340:
!$EV error(0, expr(@VA(.MAIN.ecc_err_340),16,16),1, DC_TAG, 31) 
	 .word 0xebf4e000

	 .word 0xf4ecdc60


.global ecc_err_341 
ecc_err_341:
!$EV error(0, expr(@VA(.MAIN.ecc_err_341),16,16),1, IC_DATA, IR,22,x) 
	 .word 0xfac4dc60


.global ecc_err_342 
ecc_err_342:
!$EV error(0, expr(@VA(.MAIN.ecc_err_342),16,16),1, DC_DATA, 50) 
	 .word 0xf4ccdc60


.global ecc_err_343 
ecc_err_343:
!$EV error(0, expr(@VA(.MAIN.ecc_err_343),16,16),1, DC_TAG, 8) 
	 .word 0xf5e4e000


.global ecc_err_344 
ecc_err_344:
!$EV error(0, expr(@VA(.MAIN.ecc_err_344),16,16),1, DC_TAG, 50) 
	 .word 0xf8ecd000

	 .word 0xf6fcc560

	 .word 0xf5e4dd60

	 .word 0xec7cc000


.global ecc_err_345 
ecc_err_345:
!$EV error(0, expr(@VA(.MAIN.ecc_err_345),16,16),1, IC_DATA, IR,22,x) 
	 .word 0xf87ce000


.global ecc_err_346 
ecc_err_346:
!$EV error(0, expr(@VA(.MAIN.ecc_err_346),16,16),1, DC_DATA, 12) 
	 .word 0xf85ce008


.global ecc_err_347 
ecc_err_347:
!$EV error(0, expr(@VA(.MAIN.ecc_err_347),16,16),1, IC_DATA, IR,3,x) 
	 .word 0xee6cc000


.global ecc_err_348 
ecc_err_348:
!$EV error(0, expr(@VA(.MAIN.ecc_err_348),16,16),1, DC_DATA, 62) 
	 .word 0xf6c4e000


.global ecc_err_349 
ecc_err_349:
!$EV error(0, expr(@VA(.MAIN.ecc_err_349),16,16),1, IC_TAG, IR,21, x) 
	 .word 0xfadce008

	 .word 0xf87cc000


.global ecc_err_350 
ecc_err_350:
!$EV error(0, expr(@VA(.MAIN.ecc_err_350),16,16),1, IC_TAG, IR,4, x) 
	 .word 0xf5e4c480


.global ecc_err_351 
ecc_err_351:
!$EV error(0, expr(@VA(.MAIN.ecc_err_351),16,16),1, DC_TAG, 40) 
	 .word 0xf26cc000

	 .word 0xee74e000


.global ecc_err_352 
ecc_err_352:
!$EV error(0, expr(@VA(.MAIN.ecc_err_352),16,16),1, DC_TAG, 51) 
	 .word 0xf9f4d100


.global ecc_err_353 
ecc_err_353:
!$EV error(0, expr(@VA(.MAIN.ecc_err_353),16,16),1, IC_DATA, IR,14,x) 
	 .word 0xea6cc000

	 .word 0xececdd40

	 .word 0xf884dd60


.global ecc_err_354 
ecc_err_354:
!$EV error(0, expr(@VA(.MAIN.ecc_err_354),16,16),1, DC_TAG, 7) 
	 .word 0xea0ce014


.global ecc_err_355 
ecc_err_355:
!$EV error(0, expr(@VA(.MAIN.ecc_err_355),16,16),1, IC_DATA, IR,4,x) 
	 .word 0xf46cc000

	 .word 0xf67cc000


.global ecc_err_356 
ecc_err_356:
!$EV error(0, expr(@VA(.MAIN.ecc_err_356),16,16),1, DC_TAG, 47) 
	 .word 0xf6d4d020


.global ecc_err_357 
ecc_err_357:
!$EV error(0, expr(@VA(.MAIN.ecc_err_357),16,16),1, IC_TAG, IR,18, x) 
	 .word 0xee7ce004

	 .word 0xecf4c560

	 .word 0xf674c000

	 .word 0xf0a4e004


.global ecc_err_358 
ecc_err_358:
!$EV error(0, expr(@VA(.MAIN.ecc_err_358),16,16),1, IC_TAG, IR,7, x) 
	 .word 0xf7f4c560

	 .word 0xf67ce000


.global ecc_err_359 
ecc_err_359:
!$EV error(0, expr(@VA(.MAIN.ecc_err_359),16,16),1, DC_TAG, 27) 
	 .word 0xf7e4e000


.global ecc_err_360 
ecc_err_360:
!$EV error(0, expr(@VA(.MAIN.ecc_err_360),16,16),1, DC_DATA, 39) 
	 .word 0xf87cc000

	 .word 0xfa34e000

	 .word 0xeea4e000


.global ecc_err_361 
ecc_err_361:
!$EV error(0, expr(@VA(.MAIN.ecc_err_361),16,16),1, IC_DATA, IR,3,x) 
	 .word 0xf3e4d120


.global ecc_err_362 
ecc_err_362:
!$EV error(0, expr(@VA(.MAIN.ecc_err_362),16,16),1, DC_TAG, 15) 
	 .word 0xf5f4c480


.global ecc_err_363 
ecc_err_363:
!$EV error(0, expr(@VA(.MAIN.ecc_err_363),16,16),1, IC_DATA, IR,25,x) 
	 .word 0xf5f4e000

	 .word 0xf67cc000


.global ecc_err_364 
ecc_err_364:
!$EV error(0, expr(@VA(.MAIN.ecc_err_364),16,16),1, DC_TAG, 0) 
	 .word 0xedf4d120


.global ecc_err_365 
ecc_err_365:
!$EV error(0, expr(@VA(.MAIN.ecc_err_365),16,16),1, IC_TAG, IR,28, x) 
	 .word 0xf87ce004


.global ecc_err_366 
ecc_err_366:
!$EV error(0, expr(@VA(.MAIN.ecc_err_366),16,16),1, IC_DATA, IR,13,x) 
	 .word 0xf9f4d100

	 .word 0xec44e004

	 .word 0xf6fce004

	 .word 0xf26ce00e

	 .word 0xf46cc000


.global ecc_err_367 
ecc_err_367:
!$EV error(0, expr(@VA(.MAIN.ecc_err_367),16,16),1, DC_TAG, 52) 
	 .word 0xea7ce004


.global ecc_err_368 
ecc_err_368:
!$EV error(0, expr(@VA(.MAIN.ecc_err_368),16,16),1, DC_TAG, 51) 
	 .word 0xf444c000


.global ecc_err_369 
ecc_err_369:
!$EV error(0, expr(@VA(.MAIN.ecc_err_369),16,16),1, DC_TAG, 8) 
	 .word 0xeeece008


.global ecc_err_370 
ecc_err_370:
!$EV error(0, expr(@VA(.MAIN.ecc_err_370),16,16),1, IC_DATA, IR,26,x) 
	 .word 0xf8ecdc40

	 .word 0xf27ce000

	 .word 0xebf4c440

	 .word 0xeed4e000

	 .word 0xf67cc000

	 .word 0xfa8cc580


.global ecc_err_371 
ecc_err_371:
!$EV error(0, expr(@VA(.MAIN.ecc_err_371),16,16),1, DC_TAG, 32) 
	 .word 0xf9f4c480


.global ecc_err_372 
ecc_err_372:
!$EV error(0, expr(@VA(.MAIN.ecc_err_372),16,16),1, DC_TAG, 54) 
	 .word 0xf1f4e000

	 .word 0xeefcc540


.global ecc_err_373 
ecc_err_373:
!$EV error(0, expr(@VA(.MAIN.ecc_err_373),16,16),1, DC_DATA, 10) 
	 .word 0xf06cc000

	 .word 0xf634c000


.global ecc_err_374 
ecc_err_374:
!$EV error(0, expr(@VA(.MAIN.ecc_err_374),16,16),1, DC_DATA, 13) 
	 .word 0xf06ce028

	 .word 0xf4ece017


.global ecc_err_375 
ecc_err_375:
!$EV error(0, expr(@VA(.MAIN.ecc_err_375),16,16),1, IC_TAG, IR,2, x) 
	 .word 0xf854c000

	 .word 0xf9f4e000

	 .word 0xf424e000


.global ecc_err_376 
ecc_err_376:
!$EV error(0, expr(@VA(.MAIN.ecc_err_376),16,16),1, IC_TAG, IR,13, x) 
	 .word 0xf7e4c560


.global ecc_err_377 
ecc_err_377:
!$EV error(0, expr(@VA(.MAIN.ecc_err_377),16,16),1, IC_DATA, IR,19,x) 
	 .word 0xea7ce004


.global ecc_err_378 
ecc_err_378:
!$EV error(0, expr(@VA(.MAIN.ecc_err_378),16,16),1, IC_DATA, IR,14,x) 
	 .word 0xf254c000


.global ecc_err_379 
ecc_err_379:
!$EV error(0, expr(@VA(.MAIN.ecc_err_379),16,16),1, DC_TAG, 36) 
	 .word 0xec7ce004

	 .word 0xf66cc000


.global ecc_err_380 
ecc_err_380:
!$EV error(0, expr(@VA(.MAIN.ecc_err_380),16,16),1, IC_DATA, IR,28,x) 
	 .word 0xf7e4e000

	 .word 0xea04c000


.global ecc_err_381 
ecc_err_381:
!$EV error(0, expr(@VA(.MAIN.ecc_err_381),16,16),1, DC_TAG, 57) 
	 .word 0xea7ce000


.global ecc_err_382 
ecc_err_382:
!$EV error(0, expr(@VA(.MAIN.ecc_err_382),16,16),1, IC_TAG, IR,13, x) 
	 .word 0xf26cc000

	 .word 0xecc4c440


.global ecc_err_383 
ecc_err_383:
!$EV error(0, expr(@VA(.MAIN.ecc_err_383),16,16),1, IC_TAG, IR,19, x) 
	 .word 0xeccce038

	 .word 0xec7ce000

	 .word 0xf0ecc480

	 .word 0xec3cc000


.global ecc_err_384 
ecc_err_384:
!$EV error(0, expr(@VA(.MAIN.ecc_err_384),16,16),1, IC_TAG, IR,5, x) 
	 .word 0xf6ece03f

	 .word 0xf62cc000

	 .word 0xec1cc000


.global ecc_err_385 
ecc_err_385:
!$EV error(0, expr(@VA(.MAIN.ecc_err_385),16,16),1, IC_TAG, IR,0, x) 
	 .word 0xfadce008


.global ecc_err_386 
ecc_err_386:
!$EV error(0, expr(@VA(.MAIN.ecc_err_386),16,16),1, IC_DATA, IR,11,x) 
	 .word 0xeeecc440


.global ecc_err_387 
ecc_err_387:
!$EV error(0, expr(@VA(.MAIN.ecc_err_387),16,16),1, IC_DATA, IR,8,x) 
	 .word 0xebf4c540


.global ecc_err_388 
ecc_err_388:
!$EV error(0, expr(@VA(.MAIN.ecc_err_388),16,16),1, DC_DATA, 40) 
	 .word 0xf07ce000

	 .word 0xf27cc000


.global ecc_err_389 
ecc_err_389:
!$EV error(0, expr(@VA(.MAIN.ecc_err_389),16,16),1, IC_TAG, IR,19, x) 
	 .word 0xf88ce03d


.global ecc_err_390 
ecc_err_390:
!$EV error(0, expr(@VA(.MAIN.ecc_err_390),16,16),1, DC_TAG, 24) 
	 .word 0xebf4e000

	 .word 0xf67ce000

	 .word 0xec9ce000


.global ecc_err_391 
ecc_err_391:
!$EV error(0, expr(@VA(.MAIN.ecc_err_391),16,16),1, DC_TAG, 59) 
	 .word 0xf8ece024


.global ecc_err_392 
ecc_err_392:
!$EV error(0, expr(@VA(.MAIN.ecc_err_392),16,16),1, DC_TAG, 8) 
	 .word 0xf1e4e000


.global ecc_err_393 
ecc_err_393:
!$EV error(0, expr(@VA(.MAIN.ecc_err_393),16,16),1, IC_TAG, IR,19, x) 
	 .word 0xf4ecc440


.global ecc_err_394 
ecc_err_394:
!$EV error(0, expr(@VA(.MAIN.ecc_err_394),16,16),1, DC_TAG, 11) 
	 .word 0xf84cc000


.global ecc_err_395 
ecc_err_395:
!$EV error(0, expr(@VA(.MAIN.ecc_err_395),16,16),1, DC_TAG, 25) 
	 .word 0xf87ce000


.global ecc_err_396 
ecc_err_396:
!$EV error(0, expr(@VA(.MAIN.ecc_err_396),16,16),1, DC_DATA, 48) 
	 .word 0xfa94e002

	 .word 0xf274c000

	 .word 0xea7cc000


.global ecc_err_397 
ecc_err_397:
!$EV error(0, expr(@VA(.MAIN.ecc_err_397),16,16),1, DC_DATA, 36) 
	 .word 0xeeecdc40


.global ecc_err_398 
ecc_err_398:
!$EV error(0, expr(@VA(.MAIN.ecc_err_398),16,16),1, DC_DATA, 25) 
	 .word 0xf8ece01f


.global ecc_err_399 
ecc_err_399:
!$EV error(0, expr(@VA(.MAIN.ecc_err_399),16,16),1, IC_TAG, IR,23, x) 
	 .word 0xf5e4c460

	 .word 0xf4a4d120

	 .word 0xf2ecd000

	 .word 0xec7ce004

	 .word 0xecbce010

	 .word 0xec6ce014


.global ecc_err_400 
ecc_err_400:
!$EV error(0, expr(@VA(.MAIN.ecc_err_400),16,16),1, DC_TAG, 18) 
	 .word 0xf3e4e000

	 .word 0xee6cc000

	 .word 0xea7ce000


.global ecc_err_401 
ecc_err_401:
!$EV error(0, expr(@VA(.MAIN.ecc_err_401),16,16),1, DC_DATA, 51) 
	 .word 0xea6ce028


.global ecc_err_402 
ecc_err_402:
!$EV error(0, expr(@VA(.MAIN.ecc_err_402),16,16),1, IC_DATA, IR,17,x) 
	 .word 0xf1f4c440

	 .word 0xecfce004


.global ecc_err_403 
ecc_err_403:
!$EV error(0, expr(@VA(.MAIN.ecc_err_403),16,16),1, DC_TAG, 1) 
	 .word 0xeaecdd40


.global ecc_err_404 
ecc_err_404:
!$EV error(0, expr(@VA(.MAIN.ecc_err_404),16,16),1, IC_DATA, IR,24,x) 
	 .word 0xf1f4d000


.global ecc_err_405 
ecc_err_405:
!$EV error(0, expr(@VA(.MAIN.ecc_err_405),16,16),1, DC_DATA, 59) 
	 .word 0xf2ecd120

	 .word 0xeff4dc60

	 .word 0xec1cc000

	 .word 0xf6ece010


.global ecc_err_406 
ecc_err_406:
!$EV error(0, expr(@VA(.MAIN.ecc_err_406),16,16),1, IC_DATA, IR,1,x) 
	 .word 0xf47ce000


.global ecc_err_407 
ecc_err_407:
!$EV error(0, expr(@VA(.MAIN.ecc_err_407),16,16),1, DC_TAG, 29) 
	 .word 0xf0ecd000


.global ecc_err_408 
ecc_err_408:
!$EV error(0, expr(@VA(.MAIN.ecc_err_408),16,16),1, DC_DATA, 8) 
	 .word 0xfa0cc000

	 .word 0xf66cc000


.global ecc_err_409 
ecc_err_409:
!$EV error(0, expr(@VA(.MAIN.ecc_err_409),16,16),1, DC_TAG, 63) 
	 .word 0xf0ecc580


.global ecc_err_410 
ecc_err_410:
!$EV error(0, expr(@VA(.MAIN.ecc_err_410),16,16),1, IC_DATA, IR,17,x) 
	 .word 0xfa5cc000

	 .word 0xf5e4d100


.global ecc_err_411 
ecc_err_411:
!$EV error(0, expr(@VA(.MAIN.ecc_err_411),16,16),1, IC_TAG, IR,11, x) 
	 .word 0xf9e4c580


.global ecc_err_412 
ecc_err_412:
!$EV error(0, expr(@VA(.MAIN.ecc_err_412),16,16),1, IC_TAG, IR,10, x) 
	 .word 0xeed4c580

	 .word 0xec1cc000


.global ecc_err_413 
ecc_err_413:
!$EV error(0, expr(@VA(.MAIN.ecc_err_413),16,16),1, IC_TAG, IR,17, x) 
	 .word 0xf00ce003


.global ecc_err_414 
ecc_err_414:
!$EV error(0, expr(@VA(.MAIN.ecc_err_414),16,16),1, IC_TAG, IR,29, x) 
	 .word 0xee04e004


.global ecc_err_415 
ecc_err_415:
!$EV error(0, expr(@VA(.MAIN.ecc_err_415),16,16),1, IC_TAG, IR,8, x) 
	 .word 0xf5f4e000


.global ecc_err_416 
ecc_err_416:
!$EV error(0, expr(@VA(.MAIN.ecc_err_416),16,16),1, DC_DATA, 53) 
	 .word 0xec1cc000

	 .word 0xeaece032

	 .word 0xea0cc000


.global ecc_err_417 
ecc_err_417:
!$EV error(0, expr(@VA(.MAIN.ecc_err_417),16,16),1, IC_TAG, IR,0, x) 
	 .word 0xea94e002

	 .word 0xf8ecdd60

	 .word 0xf04cc000

	 .word 0xea7cc000


.global ecc_err_418 
ecc_err_418:
!$EV error(0, expr(@VA(.MAIN.ecc_err_418),16,16),1, IC_DATA, IR,2,x) 
	 .word 0xecece037


.global ecc_err_419 
ecc_err_419:
!$EV error(0, expr(@VA(.MAIN.ecc_err_419),16,16),1, DC_DATA, 16) 
	 .word 0xebe4e000

	 .word 0xf8fce004


.global ecc_err_420 
ecc_err_420:
!$EV error(0, expr(@VA(.MAIN.ecc_err_420),16,16),1, IC_TAG, IR,9, x) 
	 .word 0xf4ecc540


.global ecc_err_421 
ecc_err_421:
!$EV error(0, expr(@VA(.MAIN.ecc_err_421),16,16),1, DC_TAG, 58) 
	 .word 0xf8dce000


.global ecc_err_422 
ecc_err_422:
!$EV error(0, expr(@VA(.MAIN.ecc_err_422),16,16),1, DC_TAG, 22) 
	 .word 0xeaccc580

	 .word 0xede4d020


.global ecc_err_423 
ecc_err_423:
!$EV error(0, expr(@VA(.MAIN.ecc_err_423),16,16),1, DC_TAG, 1) 
	 .word 0xf1e4c480


.global ecc_err_424 
ecc_err_424:
!$EV error(0, expr(@VA(.MAIN.ecc_err_424),16,16),1, IC_DATA, IR,26,x) 
	 .word 0xf4d4dc60


.global ecc_err_425 
ecc_err_425:
!$EV error(0, expr(@VA(.MAIN.ecc_err_425),16,16),1, DC_DATA, 56) 
	 .word 0xea7cc000

	 .word 0xec7ce004


.global ecc_err_426 
ecc_err_426:
!$EV error(0, expr(@VA(.MAIN.ecc_err_426),16,16),1, IC_DATA, IR,5,x) 
	 .word 0xf47ce004


.global ecc_err_427 
ecc_err_427:
!$EV error(0, expr(@VA(.MAIN.ecc_err_427),16,16),1, IC_TAG, IR,8, x) 
	 .word 0xebf4c580


.global ecc_err_428 
ecc_err_428:
!$EV error(0, expr(@VA(.MAIN.ecc_err_428),16,16),1, DC_TAG, 41) 
	 .word 0xeeece01b

	 .word 0xf2dce008

	 .word 0xec1cc000

	 .word 0xf4ace028


.global ecc_err_429 
ecc_err_429:
!$EV error(0, expr(@VA(.MAIN.ecc_err_429),16,16),1, DC_DATA, 32) 
	 .word 0xea7ce004

	 .word 0xee74c000


.global ecc_err_430 
ecc_err_430:
!$EV error(0, expr(@VA(.MAIN.ecc_err_430),16,16),1, DC_TAG, 21) 
	 .word 0xee8ce03c

	 .word 0xea24e000

	 .word 0xf3f4c440


.global ecc_err_431 
ecc_err_431:
!$EV error(0, expr(@VA(.MAIN.ecc_err_431),16,16),1, IC_TAG, IR,7, x) 
	 .word 0xf86ce00b


.global ecc_err_432 
ecc_err_432:
!$EV error(0, expr(@VA(.MAIN.ecc_err_432),16,16),1, IC_DATA, IR,0,x) 
	 .word 0xf4cce01d

	 .word 0xf67cc000


.global ecc_err_433 
ecc_err_433:
!$EV error(0, expr(@VA(.MAIN.ecc_err_433),16,16),1, IC_DATA, IR,12,x) 
	 .word 0xf27ce000


.global ecc_err_434 
ecc_err_434:
!$EV error(0, expr(@VA(.MAIN.ecc_err_434),16,16),1, DC_TAG, 14) 
	 .word 0xf1f4e000

	 .word 0xf47cc000

	 .word 0xf6f4dc60

	 .word 0xf0ecd020

	 .word 0xecb4e002


.global ecc_err_435 
ecc_err_435:
!$EV error(0, expr(@VA(.MAIN.ecc_err_435),16,16),1, IC_DATA, IR,5,x) 
	 .word 0xf7f4c440


.global ecc_err_436 
ecc_err_436:
!$EV error(0, expr(@VA(.MAIN.ecc_err_436),16,16),1, IC_TAG, IR,16, x) 
	 .word 0xea7cc000


.global ecc_err_437 
ecc_err_437:
!$EV error(0, expr(@VA(.MAIN.ecc_err_437),16,16),1, IC_DATA, IR,9,x) 
	 .word 0xf1f4d000

	 .word 0xf5f4d100


.global ecc_err_438 
ecc_err_438:
!$EV error(0, expr(@VA(.MAIN.ecc_err_438),16,16),1, IC_TAG, IR,19, x) 
	 .word 0xfa44c000

	 .word 0xf5f4e000

	 .word 0xf4b4d000

	 .word 0xf24ce010


.global ecc_err_439 
ecc_err_439:
!$EV error(0, expr(@VA(.MAIN.ecc_err_439),16,16),1, IC_DATA, IR,30,x) 
	 .word 0xec7cc000


.global ecc_err_440 
ecc_err_440:
!$EV error(0, expr(@VA(.MAIN.ecc_err_440),16,16),1, DC_TAG, 51) 
	 .word 0xf87ce004

	 .word 0xee84c560


.global ecc_err_441 
ecc_err_441:
!$EV error(0, expr(@VA(.MAIN.ecc_err_441),16,16),1, IC_TAG, IR,5, x) 
	 .word 0xf06ce012

	 .word 0xf4fcdc40


.global ecc_err_442 
ecc_err_442:
!$EV error(0, expr(@VA(.MAIN.ecc_err_442),16,16),1, DC_DATA, 0) 
	 .word 0xf844e000


.global ecc_err_443 
ecc_err_443:
!$EV error(0, expr(@VA(.MAIN.ecc_err_443),16,16),1, IC_DATA, IR,5,x) 
	 .word 0xf6ece039

	 .word 0xf5e4e000


.global ecc_err_444 
ecc_err_444:
!$EV error(0, expr(@VA(.MAIN.ecc_err_444),16,16),1, DC_DATA, 47) 
	 .word 0xebf4e000

	 .word 0xec4ce01e

	 .word 0xf4fce000

	 .word 0xf014c000

	 .word 0xebe4e000

	 .word 0xf66ce02d

	 .word 0xeea4d020

	 .word 0xefe4e000


.global ecc_err_445 
ecc_err_445:
!$EV error(0, expr(@VA(.MAIN.ecc_err_445),16,16),1, IC_DATA, IR,23,x) 
	 .word 0xedf4c460

	 .word 0xf7f4e000


.global ecc_err_446 
ecc_err_446:
!$EV error(0, expr(@VA(.MAIN.ecc_err_446),16,16),1, DC_TAG, 60) 
	 .word 0xf0ecdd40

	 .word 0xf4ccd020


.global ecc_err_447 
ecc_err_447:
!$EV error(0, expr(@VA(.MAIN.ecc_err_447),16,16),1, IC_TAG, IR,14, x) 
	 .word 0xea0ce036


.global ecc_err_448 
ecc_err_448:
!$EV error(0, expr(@VA(.MAIN.ecc_err_448),16,16),1, IC_TAG, IR,31, x) 
	 .word 0xf7f4e000

	 .word 0xec14c000

	 .word 0xf86cc000

	 .word 0xea6cc000

	 .word 0xeab4e002

	 .word 0xf87ce004

	 .word 0xec94c440

	 .word 0xee14c000

	 .word 0xf86ce037


.global ecc_err_449 
ecc_err_449:
!$EV error(0, expr(@VA(.MAIN.ecc_err_449),16,16),1, DC_TAG, 61) 
	 .word 0xfa8cc460


.global ecc_err_450 
ecc_err_450:
!$EV error(0, expr(@VA(.MAIN.ecc_err_450),16,16),1, IC_DATA, IR,23,x) 
	 .word 0xecece031

	 .word 0xf494c440

	 .word 0xebf4c440

	 .word 0xecfce004


.global ecc_err_451 
ecc_err_451:
!$EV error(0, expr(@VA(.MAIN.ecc_err_451),16,16),1, IC_DATA, IR,5,x) 
	 .word 0xf2ece010


.global ecc_err_452 
ecc_err_452:
!$EV error(0, expr(@VA(.MAIN.ecc_err_452),16,16),1, IC_TAG, IR,26, x) 
	 .word 0xede4d120

	 .word 0xeccce020


.global ecc_err_453 
ecc_err_453:
!$EV error(0, expr(@VA(.MAIN.ecc_err_453),16,16),1, DC_DATA, 42) 
	 .word 0xf2cce03f


.global ecc_err_454 
ecc_err_454:
!$EV error(0, expr(@VA(.MAIN.ecc_err_454),16,16),1, DC_TAG, 36) 
	 .word 0xf5e4c440

	 .word 0xf06ce02e

	 .word 0xf0fce000

	 .word 0xf4ecd120


.global ecc_err_455 
ecc_err_455:
!$EV error(0, expr(@VA(.MAIN.ecc_err_455),16,16),1, IC_DATA, IR,6,x) 
	 .word 0xf9e4e000


.global ecc_err_456 
ecc_err_456:
!$EV error(0, expr(@VA(.MAIN.ecc_err_456),16,16),1, DC_DATA, 42) 
	 .word 0xf27cc000


.global ecc_err_457 
ecc_err_457:
!$EV error(0, expr(@VA(.MAIN.ecc_err_457),16,16),1, DC_TAG, 50) 
	 .word 0xf4ecdc60


.global ecc_err_458 
ecc_err_458:
!$EV error(0, expr(@VA(.MAIN.ecc_err_458),16,16),1, IC_DATA, IR,11,x) 
	 .word 0xf694c460


.global ecc_err_459 
ecc_err_459:
!$EV error(0, expr(@VA(.MAIN.ecc_err_459),16,16),1, IC_TAG, IR,19, x) 
	 .word 0xf4ece017

	 .word 0xf66cc000

	 .word 0xf7f4c440

	 .word 0xecbcd020


.global ecc_err_460 
ecc_err_460:
!$EV error(0, expr(@VA(.MAIN.ecc_err_460),16,16),1, IC_TAG, IR,2, x) 
	 .word 0xeff4c580


.global ecc_err_461 
ecc_err_461:
!$EV error(0, expr(@VA(.MAIN.ecc_err_461),16,16),1, DC_DATA, 47) 
	 .word 0xf6d4e002


.global ecc_err_462 
ecc_err_462:
!$EV error(0, expr(@VA(.MAIN.ecc_err_462),16,16),1, DC_TAG, 63) 
	 .word 0xf9f4e000

	 .word 0xf66cc000

	 .word 0xf0f4dc60


.global ecc_err_463 
ecc_err_463:
!$EV error(0, expr(@VA(.MAIN.ecc_err_463),16,16),1, IC_DATA, IR,16,x) 
	 .word 0xf64ce003


.global ecc_err_464 
ecc_err_464:
!$EV error(0, expr(@VA(.MAIN.ecc_err_464),16,16),1, DC_DATA, 8) 
	 .word 0xee6cc000


.global ecc_err_465 
ecc_err_465:
!$EV error(0, expr(@VA(.MAIN.ecc_err_465),16,16),1, DC_TAG, 1) 
	 .word 0xf3f4e000

	 .word 0xecfcdc60

	 .word 0xf3f4e000

	 .word 0xee7cc000


.global ecc_err_466 
ecc_err_466:
!$EV error(0, expr(@VA(.MAIN.ecc_err_466),16,16),1, IC_TAG, IR,3, x) 
	 .word 0xfa8ce03b

	 .word 0xf1f4dd60

	 .word 0xea84c440


.global ecc_err_467 
ecc_err_467:
!$EV error(0, expr(@VA(.MAIN.ecc_err_467),16,16),1, DC_TAG, 2) 
	 .word 0xf4ecc460

	 .word 0xf3f4dc60


.global ecc_err_468 
ecc_err_468:
!$EV error(0, expr(@VA(.MAIN.ecc_err_468),16,16),1, IC_DATA, IR,22,x) 
	 .word 0xecece00b

	 .word 0xeaece011

	 .word 0xfa7cc000

	 .word 0xeeecd120


.global ecc_err_469 
ecc_err_469:
!$EV error(0, expr(@VA(.MAIN.ecc_err_469),16,16),1, DC_DATA, 12) 
	 .word 0xf07ce004


.global ecc_err_470 
ecc_err_470:
!$EV error(0, expr(@VA(.MAIN.ecc_err_470),16,16),1, DC_TAG, 0) 
	 .word 0xec6cc000

	 .word 0xec6cc000


.global ecc_err_471 
ecc_err_471:
!$EV error(0, expr(@VA(.MAIN.ecc_err_471),16,16),1, DC_DATA, 37) 
	 .word 0xeeecc560

	 .word 0xf2fce000


.global ecc_err_472 
ecc_err_472:
!$EV error(0, expr(@VA(.MAIN.ecc_err_472),16,16),1, DC_TAG, 3) 
	 .word 0xebe4dd40


.global ecc_err_473 
ecc_err_473:
!$EV error(0, expr(@VA(.MAIN.ecc_err_473),16,16),1, DC_DATA, 43) 
	 .word 0xeeece01a


.global ecc_err_474 
ecc_err_474:
!$EV error(0, expr(@VA(.MAIN.ecc_err_474),16,16),1, DC_DATA, 33) 
	 .word 0xec7ce000


.global ecc_err_475 
ecc_err_475:
!$EV error(0, expr(@VA(.MAIN.ecc_err_475),16,16),1, DC_DATA, 63) 
	 .word 0xf3f4e000


.global ecc_err_476 
ecc_err_476:
!$EV error(0, expr(@VA(.MAIN.ecc_err_476),16,16),1, IC_DATA, IR,17,x) 
	 .word 0xeaece016


.global ecc_err_477 
ecc_err_477:
!$EV error(0, expr(@VA(.MAIN.ecc_err_477),16,16),1, IC_DATA, IR,9,x) 
	 .word 0xf3f4e000


.global ecc_err_478 
ecc_err_478:
!$EV error(0, expr(@VA(.MAIN.ecc_err_478),16,16),1, IC_TAG, IR,26, x) 
	 .word 0xf06ce026

	 .word 0xf2ecc460

	 .word 0xebe4c560

	 .word 0xf4ecdc60


.global ecc_err_479 
ecc_err_479:
!$EV error(0, expr(@VA(.MAIN.ecc_err_479),16,16),1, DC_TAG, 21) 
	 .word 0xf7e4c440


.global ecc_err_480 
ecc_err_480:
!$EV error(0, expr(@VA(.MAIN.ecc_err_480),16,16),1, DC_DATA, 52) 
	 .word 0xf27cc000


.global ecc_err_481 
ecc_err_481:
!$EV error(0, expr(@VA(.MAIN.ecc_err_481),16,16),1, IC_DATA, IR,14,x) 
	 .word 0xeff4dd40

	 .word 0xea7ce004


.global ecc_err_482 
ecc_err_482:
!$EV error(0, expr(@VA(.MAIN.ecc_err_482),16,16),1, DC_TAG, 60) 
	 .word 0xf6ecd100


.global ecc_err_483 
ecc_err_483:
!$EV error(0, expr(@VA(.MAIN.ecc_err_483),16,16),1, DC_DATA, 17) 
	 .word 0xf64cc000


.global ecc_err_484 
ecc_err_484:
!$EV error(0, expr(@VA(.MAIN.ecc_err_484),16,16),1, IC_DATA, IR,18,x) 
	 .word 0xec6ce02a


.global ecc_err_485 
ecc_err_485:
!$EV error(0, expr(@VA(.MAIN.ecc_err_485),16,16),1, IC_DATA, IR,18,x) 
	 .word 0xee0cc000


.global ecc_err_486 
ecc_err_486:
!$EV error(0, expr(@VA(.MAIN.ecc_err_486),16,16),1, DC_TAG, 57) 
	 .word 0xf86ce011


.global ecc_err_487 
ecc_err_487:
!$EV error(0, expr(@VA(.MAIN.ecc_err_487),16,16),1, DC_TAG, 57) 
	 .word 0xeeecc540

	 .word 0xf0ece037


.global ecc_err_488 
ecc_err_488:
!$EV error(0, expr(@VA(.MAIN.ecc_err_488),16,16),1, DC_DATA, 13) 
	 .word 0xea7ce000

	 .word 0xeeecc580


.global ecc_err_489 
ecc_err_489:
!$EV error(0, expr(@VA(.MAIN.ecc_err_489),16,16),1, DC_TAG, 30) 
	 .word 0xf3f4e000

	 .word 0xf2ecd120


.global ecc_err_490 
ecc_err_490:
!$EV error(0, expr(@VA(.MAIN.ecc_err_490),16,16),1, IC_DATA, IR,4,x) 
	 .word 0xf8ecd020


.global ecc_err_491 
ecc_err_491:
!$EV error(0, expr(@VA(.MAIN.ecc_err_491),16,16),1, DC_TAG, 22) 
	 .word 0xf47cc000

	 .word 0xfaace032


.global ecc_err_492 
ecc_err_492:
!$EV error(0, expr(@VA(.MAIN.ecc_err_492),16,16),1, IC_DATA, IR,0,x) 
	 .word 0xfa94e000


.global ecc_err_493 
ecc_err_493:
!$EV error(0, expr(@VA(.MAIN.ecc_err_493),16,16),1, IC_DATA, IR,11,x) 
	 .word 0xeedce000

	 .word 0xf8ece01f

	 .word 0xecd4e002


.global ecc_err_494 
ecc_err_494:
!$EV error(0, expr(@VA(.MAIN.ecc_err_494),16,16),1, DC_TAG, 43) 
	 .word 0xf9e4e000

	 .word 0xf9f4e000

	 .word 0xeefce004


.global ecc_err_495 
ecc_err_495:
!$EV error(0, expr(@VA(.MAIN.ecc_err_495),16,16),1, DC_TAG, 45) 
	 .word 0xf46ce01a

	 .word 0xedf4dd40

	 .word 0xf8ecd000


.global ecc_err_496 
ecc_err_496:
!$EV error(0, expr(@VA(.MAIN.ecc_err_496),16,16),1, IC_TAG, IR,24, x) 
	 .word 0xf46ce019


.global ecc_err_497 
ecc_err_497:
!$EV error(0, expr(@VA(.MAIN.ecc_err_497),16,16),1, DC_DATA, 16) 
	 .word 0xeaecc480


.global ecc_err_498 
ecc_err_498:
!$EV error(0, expr(@VA(.MAIN.ecc_err_498),16,16),1, DC_TAG, 59) 
	 .word 0xf27cc000


.global ecc_err_499 
ecc_err_499:
!$EV error(0, expr(@VA(.MAIN.ecc_err_499),16,16),1, DC_TAG, 41) 
	 .word 0xfa54c000


.global ecc_err_500 
ecc_err_500:
!$EV error(0, expr(@VA(.MAIN.ecc_err_500),16,16),1, DC_TAG, 54) 
	 .word 0xfa14e002

	 .word 0xececdd40


.global ecc_err_501 
ecc_err_501:
!$EV error(0, expr(@VA(.MAIN.ecc_err_501),16,16),1, DC_TAG, 55) 
	 .word 0xec9ce000

	 .word 0xeff4e000


.global ecc_err_502 
ecc_err_502:
!$EV error(0, expr(@VA(.MAIN.ecc_err_502),16,16),1, IC_DATA, IR,17,x) 
	 .word 0xec9ce000

	 .word 0xeafcc480


.global ecc_err_503 
ecc_err_503:
!$EV error(0, expr(@VA(.MAIN.ecc_err_503),16,16),1, DC_DATA, 23) 
	 .word 0xf3f4d000

	 .word 0xf2fcd120


.global ecc_err_504 
ecc_err_504:
!$EV error(0, expr(@VA(.MAIN.ecc_err_504),16,16),1, DC_DATA, 55) 
	 .word 0xf67ce004


.global ecc_err_505 
ecc_err_505:
!$EV error(0, expr(@VA(.MAIN.ecc_err_505),16,16),1, DC_TAG, 30) 
	 .word 0xf46cc000

	 .word 0xf06ce029


.global ecc_err_506 
ecc_err_506:
!$EV error(0, expr(@VA(.MAIN.ecc_err_506),16,16),1, IC_DATA, IR,2,x) 
	 .word 0xea8ce036

	 .word 0xf08ce009

	 .word 0xee4cc000

	 .word 0xee6ce033


.global ecc_err_507 
ecc_err_507:
!$EV error(0, expr(@VA(.MAIN.ecc_err_507),16,16),1, IC_TAG, IR,10, x) 
	 .word 0xf3f4e000

	 .word 0xf7e4dc60


.global ecc_err_508 
ecc_err_508:
!$EV error(0, expr(@VA(.MAIN.ecc_err_508),16,16),1, DC_TAG, 16) 
	 .word 0xf2ece01c

	 .word 0xec7cc000

	 .word 0xeef4e008

	 .word 0xfad4e002


.global ecc_err_509 
ecc_err_509:
!$EV error(0, expr(@VA(.MAIN.ecc_err_509),16,16),1, DC_TAG, 34) 
	 .word 0xf27cc000


.global ecc_err_510 
ecc_err_510:
!$EV error(0, expr(@VA(.MAIN.ecc_err_510),16,16),1, DC_DATA, 26) 
	 .word 0xf3f4dd60


.global ecc_err_511 
ecc_err_511:
!$EV error(0, expr(@VA(.MAIN.ecc_err_511),16,16),1, DC_TAG, 59) 
	 .word 0xf9f4dc60


.global ecc_err_512 
ecc_err_512:
!$EV error(0, expr(@VA(.MAIN.ecc_err_512),16,16),1, DC_DATA, 19) 
	 .word 0xf5f4e000


.global ecc_err_513 
ecc_err_513:
!$EV error(0, expr(@VA(.MAIN.ecc_err_513),16,16),1, DC_TAG, 23) 
	 .word 0xec9ce010


.global ecc_err_514 
ecc_err_514:
!$EV error(0, expr(@VA(.MAIN.ecc_err_514),16,16),1, DC_TAG, 29) 
	 .word 0xfa8cd120

	 .word 0xf894c540

	 .word 0xfa7cc000

	 .word 0xf4b4e000


.global ecc_err_515 
ecc_err_515:
!$EV error(0, expr(@VA(.MAIN.ecc_err_515),16,16),1, DC_TAG, 4) 
	 .word 0xfa44e000

	 .word 0xfab4c440

	 .word 0xefe4dc40


	 ba diag_pass 
	 nop 
run_th_1:

	 wr %g0, 249, %asi

	 ta T_CHANGE_HPRIV 
	 nop 
	 set 2832378915, %i0
	 set 1149291367, %i1
	 set 3248937125, %i2
	 set 3863816361, %i3
	 set 2037777780, %i4
	 set 2133145729, %i5
	 set 1329882348, %i6
	 set 1016669646, %i7
	 set 480410696, %o0
	 set 1493939893, %o1
	 set 1725882853, %o2
	 set 3556738174, %o3
	 set 1674060935, %o4
	 set 1533919695, %o5
	 set 3859353867, %o6
	 set 66554386, %o7
	 set 2724633457, %l0
	 set 3950359363, %l1
	 set 2009755938, %l2
	 set 3317949326, %l3
	 set 2092694995, %l4
	 set 2346733135, %l5
	 set 327172489, %l6
	 set 3433990258, %l7
	 set 196119927, %g0
	 set 4259867228, %g1
	 set 2289755858, %g2
	 set 1893303728, %g3
	 set 231913945, %g4
	 set 2857918377, %g5
	 set 1093960852, %g6
	 set 2200106231, %g7

wr %g0, 0x4, %fprs 
	 setx self_modcode, %l0, %l3
	 ldd [%l3], %f0
	 add 0x8, %l3, %l3
	 ldd [%l3], %f2
	 add 0x8, %l3, %l3
	 ldd [%l3], %f4
	 add 0x8, %l3, %l3
	 ldd [%l3], %f6
	 add 0x8, %l3, %l3
	 ldd [%l3], %f8
	 add 0x8, %l3, %l3
	 ldd [%l3], %f10
	 add 0x8, %l3, %l3
	 ldd [%l3], %f12
	 add 0x8, %l3, %l3
	 ldd [%l3], %f14
	 add 0x8, %l3, %l3
	 ldd [%l3], %f16
	 add 0x8, %l3, %l3
	 ldd [%l3], %f18
	 add 0x8, %l3, %l3
	 ldd [%l3], %f20
	 add 0x8, %l3, %l3
	 ldd [%l3], %f22
	 add 0x8, %l3, %l3
	 ldd [%l3], %f24
	 add 0x8, %l3, %l3
	 ldd [%l3], %f26
	 add 0x8, %l3, %l3
	 ldd [%l3], %f28
	 add 0x8, %l3, %l3
	 ldd [%l3], %f30
	 add 0x8, %l3, %l3
	 ldd [%l3], %f32
	 add 0x8, %l3, %l3
	 ldd [%l3], %f34
	 add 0x8, %l3, %l3
	 ldd [%l3], %f36
	 add 0x8, %l3, %l3
	 ldd [%l3], %f38
	 add 0x8, %l3, %l3
	 ldd [%l3], %f40
	 add 0x8, %l3, %l3
	 ldd [%l3], %f42
	 add 0x8, %l3, %l3
	 ldd [%l3], %f44
	 add 0x8, %l3, %l3
	 ldd [%l3], %f46
	 add 0x8, %l3, %l3
	 ldd [%l3], %f48
	 add 0x8, %l3, %l3
	 ldd [%l3], %f50
	 add 0x8, %l3, %l3
	 ldd [%l3], %f52
	 add 0x8, %l3, %l3
	 ldd [%l3], %f54
	 add 0x8, %l3, %l3
	 ldd [%l3], %f56
	 add 0x8, %l3, %l3
	 ldd [%l3], %f58
	 add 0x8, %l3, %l3
	 ldd [%l3], %f60
	 add 0x8, %l3, %l3
	 ldd [%l3], %f62
	 add 0x8, %l3, %l3
	 setx data5, %l0, %l3
	 setx self_modcode, %l0, %l1
.global spu_ldst_0
spu_ldst_0:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_0:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_1
spu_ldst_1:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_1:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 31, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_2
spu_ldst_2:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_2:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 5, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_3
spu_ldst_3:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_3:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_4
spu_ldst_4:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_4:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_5
spu_ldst_5:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_5:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_6
spu_ldst_6:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_6:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_7
spu_ldst_7:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_7:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_8
spu_ldst_8:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_8:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 49, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_9
spu_ldst_9:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_9:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_10
spu_ldst_10:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_10:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_11
spu_ldst_11:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_11:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_12
spu_ldst_12:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_12:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_13
spu_ldst_13:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_13:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_14
spu_ldst_14:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_14:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_15
spu_ldst_15:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_15:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_16
spu_ldst_16:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_16:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_17
spu_ldst_17:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_17:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_18
spu_ldst_18:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_18:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_19
spu_ldst_19:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_19:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 46, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_20
spu_ldst_20:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_20:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 27, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_21
spu_ldst_21:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_21:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 34, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_22
spu_ldst_22:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_22:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_23
spu_ldst_23:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_23:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_24
spu_ldst_24:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_24:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_25
spu_ldst_25:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_25:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_26
spu_ldst_26:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_26:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_27
spu_ldst_27:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_27:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_28
spu_ldst_28:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_28:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_29
spu_ldst_29:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_29:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_30
spu_ldst_30:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_30:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_31
spu_ldst_31:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_31:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_32
spu_ldst_32:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_32:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 29, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_33
spu_ldst_33:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_33:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_34
spu_ldst_34:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_34:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_35
spu_ldst_35:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_35:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_36
spu_ldst_36:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_36:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_37
spu_ldst_37:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_37:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_38
spu_ldst_38:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_38:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_39
spu_ldst_39:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_39:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_40
spu_ldst_40:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_40:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_41
spu_ldst_41:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_41:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_42
spu_ldst_42:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_42:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_43
spu_ldst_43:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_43:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_44
spu_ldst_44:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_44:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_45
spu_ldst_45:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_45:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_46
spu_ldst_46:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_46:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_47
spu_ldst_47:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_47:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_48
spu_ldst_48:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_48:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_49
spu_ldst_49:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_49:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_50
spu_ldst_50:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_50:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_51
spu_ldst_51:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_51:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_52
spu_ldst_52:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_52:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_53
spu_ldst_53:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_53:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_54
spu_ldst_54:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_54:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_55
spu_ldst_55:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_55:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_56
spu_ldst_56:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_56:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 9, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_57
spu_ldst_57:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_57:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_58
spu_ldst_58:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_58:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_59
spu_ldst_59:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_59:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_60
spu_ldst_60:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_60:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_61
spu_ldst_61:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_61:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_62
spu_ldst_62:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_62:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_63
spu_ldst_63:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_63:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_64
spu_ldst_64:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_64:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_65
spu_ldst_65:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_65:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_66
spu_ldst_66:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_66:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_67
spu_ldst_67:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_67:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_68
spu_ldst_68:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_68:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_69
spu_ldst_69:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_69:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_70
spu_ldst_70:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_70:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_71
spu_ldst_71:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_71:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_72
spu_ldst_72:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_72:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_73
spu_ldst_73:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_73:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 3, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_74
spu_ldst_74:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_74:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_75
spu_ldst_75:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_75:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_76
spu_ldst_76:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_76:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_77
spu_ldst_77:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_77:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_78
spu_ldst_78:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_78:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_79
spu_ldst_79:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_79:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_80
spu_ldst_80:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_80:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_81
spu_ldst_81:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_81:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_82
spu_ldst_82:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_82:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_83
spu_ldst_83:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_83:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_84
spu_ldst_84:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_84:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_85
spu_ldst_85:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_85:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_86
spu_ldst_86:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_86:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 40, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_87
spu_ldst_87:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_87:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_88
spu_ldst_88:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_88:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_89
spu_ldst_89:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_89:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 46, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_90
spu_ldst_90:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_90:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_91
spu_ldst_91:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_91:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_92
spu_ldst_92:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_92:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_93
spu_ldst_93:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_93:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_94
spu_ldst_94:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_94:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 3, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_95
spu_ldst_95:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_95:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_96
spu_ldst_96:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_96:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_97
spu_ldst_97:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_97:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_98
spu_ldst_98:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_98:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_99
spu_ldst_99:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_99:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_100
spu_ldst_100:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_100:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_101
spu_ldst_101:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_101:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_102
spu_ldst_102:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_102:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_103
spu_ldst_103:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_103:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_104
spu_ldst_104:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_104:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_105
spu_ldst_105:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_105:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_106
spu_ldst_106:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_106:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_107
spu_ldst_107:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_107:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 50, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_108
spu_ldst_108:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_108:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_109
spu_ldst_109:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_109:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_110
spu_ldst_110:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_110:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 40, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_111
spu_ldst_111:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_111:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_112
spu_ldst_112:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_112:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_113
spu_ldst_113:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_113:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_114
spu_ldst_114:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_114:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 34, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_115
spu_ldst_115:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_115:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_116
spu_ldst_116:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_116:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_117
spu_ldst_117:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_117:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_118
spu_ldst_118:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_118:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_119
spu_ldst_119:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_119:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_120
spu_ldst_120:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_120:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_121
spu_ldst_121:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_121:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_122
spu_ldst_122:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_122:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 5, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_123
spu_ldst_123:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_123:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_124
spu_ldst_124:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_124:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_125
spu_ldst_125:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_125:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_126
spu_ldst_126:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_126:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_127
spu_ldst_127:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_127:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_128
spu_ldst_128:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_128:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_129
spu_ldst_129:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_129:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 39, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_130
spu_ldst_130:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_130:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_131
spu_ldst_131:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_131:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_132
spu_ldst_132:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_132:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_133
spu_ldst_133:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_133:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 40, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_134
spu_ldst_134:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_134:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_135
spu_ldst_135:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_135:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_136
spu_ldst_136:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_136:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 3, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_137
spu_ldst_137:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_137:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_138
spu_ldst_138:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_138:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 5, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_139
spu_ldst_139:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_139:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_140
spu_ldst_140:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_140:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 53, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_141
spu_ldst_141:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_141:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 46, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_142
spu_ldst_142:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_142:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_143
spu_ldst_143:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_143:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_144
spu_ldst_144:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_144:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_145
spu_ldst_145:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_145:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 31, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_146
spu_ldst_146:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_146:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_147
spu_ldst_147:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_147:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_148
spu_ldst_148:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_148:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 3, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_149
spu_ldst_149:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_149:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_150
spu_ldst_150:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_150:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_151
spu_ldst_151:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_151:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_152
spu_ldst_152:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_152:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_153
spu_ldst_153:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_153:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_154
spu_ldst_154:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_154:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_155
spu_ldst_155:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_155:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 53, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_156
spu_ldst_156:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_156:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_157
spu_ldst_157:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_157:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_158
spu_ldst_158:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_158:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 46, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_159
spu_ldst_159:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_159:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_160
spu_ldst_160:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_160:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_161
spu_ldst_161:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_161:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_162
spu_ldst_162:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_162:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_163
spu_ldst_163:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_163:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_164
spu_ldst_164:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_164:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_165
spu_ldst_165:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_165:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_166
spu_ldst_166:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_166:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_167
spu_ldst_167:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_167:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_168
spu_ldst_168:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_168:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_169
spu_ldst_169:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_169:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_170
spu_ldst_170:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_170:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_171
spu_ldst_171:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_171:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_172
spu_ldst_172:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_172:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_173
spu_ldst_173:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_173:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_174
spu_ldst_174:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_174:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 50, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_175
spu_ldst_175:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_175:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_176
spu_ldst_176:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_176:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 34, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_177
spu_ldst_177:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_177:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_178
spu_ldst_178:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_178:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_179
spu_ldst_179:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_179:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_180
spu_ldst_180:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_180:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_181
spu_ldst_181:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_181:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_182
spu_ldst_182:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_182:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_183
spu_ldst_183:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_183:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_184
spu_ldst_184:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_184:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 34, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_185
spu_ldst_185:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_185:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_186
spu_ldst_186:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_186:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 3, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_187
spu_ldst_187:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_187:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 49, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_188
spu_ldst_188:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_188:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_189
spu_ldst_189:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_189:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 9, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_190
spu_ldst_190:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_190:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_191
spu_ldst_191:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_191:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_192
spu_ldst_192:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_192:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_193
spu_ldst_193:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_193:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_194
spu_ldst_194:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_194:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_195
spu_ldst_195:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_195:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 42, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_196
spu_ldst_196:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_196:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_197
spu_ldst_197:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_197:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 49, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_198
spu_ldst_198:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_198:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_199
spu_ldst_199:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_199:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_200
spu_ldst_200:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_200:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_201
spu_ldst_201:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_201:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 9, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_202
spu_ldst_202:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_202:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_203
spu_ldst_203:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_203:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_204
spu_ldst_204:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_204:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_205
spu_ldst_205:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_205:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_206
spu_ldst_206:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_206:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_207
spu_ldst_207:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_207:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_208
spu_ldst_208:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_208:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_209
spu_ldst_209:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_209:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_210
spu_ldst_210:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_210:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_211
spu_ldst_211:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_211:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_212
spu_ldst_212:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_212:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_213
spu_ldst_213:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_213:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_214
spu_ldst_214:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_214:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_215
spu_ldst_215:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_215:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_216
spu_ldst_216:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_216:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_217
spu_ldst_217:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_217:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_218
spu_ldst_218:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_218:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_219
spu_ldst_219:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_219:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_220
spu_ldst_220:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_220:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_221
spu_ldst_221:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_221:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_222
spu_ldst_222:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_222:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_223
spu_ldst_223:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_223:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_224
spu_ldst_224:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_224:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 27, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_225
spu_ldst_225:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_225:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_226
spu_ldst_226:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_226:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_227
spu_ldst_227:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_227:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_228
spu_ldst_228:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_228:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_229
spu_ldst_229:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_229:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_230
spu_ldst_230:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_230:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_231
spu_ldst_231:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_231:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 29, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_232
spu_ldst_232:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_232:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_233
spu_ldst_233:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_233:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_234
spu_ldst_234:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_234:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_235
spu_ldst_235:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_235:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_236
spu_ldst_236:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_236:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_237
spu_ldst_237:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_237:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_238
spu_ldst_238:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_238:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_239
spu_ldst_239:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_239:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_240
spu_ldst_240:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_240:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_241
spu_ldst_241:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_241:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_242
spu_ldst_242:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_242:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 31, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_243
spu_ldst_243:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_243:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_244
spu_ldst_244:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_244:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_245
spu_ldst_245:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_245:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_246
spu_ldst_246:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_246:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_247
spu_ldst_247:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_247:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 49, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_248
spu_ldst_248:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_248:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 34, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_249
spu_ldst_249:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_249:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_250
spu_ldst_250:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_250:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_251
spu_ldst_251:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_251:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_252
spu_ldst_252:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_252:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 3, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_253
spu_ldst_253:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_253:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_254
spu_ldst_254:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_254:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_255
spu_ldst_255:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_255:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_256
spu_ldst_256:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_256:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_257
spu_ldst_257:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_257:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_258
spu_ldst_258:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_258:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_259
spu_ldst_259:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_259:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_260
spu_ldst_260:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_260:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_261
spu_ldst_261:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_261:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_262
spu_ldst_262:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_262:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_263
spu_ldst_263:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_263:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_264
spu_ldst_264:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_264:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_265
spu_ldst_265:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_265:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_266
spu_ldst_266:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_266:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_267
spu_ldst_267:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_267:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_268
spu_ldst_268:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_268:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_269
spu_ldst_269:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_269:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_270
spu_ldst_270:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_270:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_271
spu_ldst_271:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_271:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_272
spu_ldst_272:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_272:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_273
spu_ldst_273:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_273:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_274
spu_ldst_274:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_274:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_275
spu_ldst_275:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_275:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 27, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_276
spu_ldst_276:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_276:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_277
spu_ldst_277:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_277:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_278
spu_ldst_278:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_278:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_279
spu_ldst_279:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_279:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_280
spu_ldst_280:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_280:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 42, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_281
spu_ldst_281:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_281:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_282
spu_ldst_282:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_282:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_283
spu_ldst_283:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_283:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_284
spu_ldst_284:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_284:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_285
spu_ldst_285:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_285:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_286
spu_ldst_286:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_286:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_287
spu_ldst_287:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_287:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_288
spu_ldst_288:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_288:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_289
spu_ldst_289:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_289:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_290
spu_ldst_290:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_290:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 50, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_291
spu_ldst_291:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_291:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_292
spu_ldst_292:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_292:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_293
spu_ldst_293:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_293:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 53, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_294
spu_ldst_294:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_294:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_295
spu_ldst_295:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_295:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 27, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_296
spu_ldst_296:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_296:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_297
spu_ldst_297:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_297:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_298
spu_ldst_298:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_298:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 50, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_299
spu_ldst_299:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_299:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_300
spu_ldst_300:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_300:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_301
spu_ldst_301:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_301:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_302
spu_ldst_302:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_302:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_303
spu_ldst_303:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_303:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_304
spu_ldst_304:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_304:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_305
spu_ldst_305:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_305:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_306
spu_ldst_306:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_306:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_307
spu_ldst_307:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_307:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_308
spu_ldst_308:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_308:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_309
spu_ldst_309:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_309:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_310
spu_ldst_310:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_310:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_311
spu_ldst_311:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_311:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 29, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_312
spu_ldst_312:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_312:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_313
spu_ldst_313:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_313:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_314
spu_ldst_314:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_314:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_315
spu_ldst_315:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_315:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_316
spu_ldst_316:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_316:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_317
spu_ldst_317:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_317:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_318
spu_ldst_318:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_318:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 34, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_319
spu_ldst_319:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_319:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_320
spu_ldst_320:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_320:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_321
spu_ldst_321:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_321:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_322
spu_ldst_322:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_322:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_323
spu_ldst_323:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_323:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_324
spu_ldst_324:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_324:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_325
spu_ldst_325:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_325:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_326
spu_ldst_326:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_326:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_327
spu_ldst_327:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_327:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_328
spu_ldst_328:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_328:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_329
spu_ldst_329:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_329:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_330
spu_ldst_330:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_330:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_331
spu_ldst_331:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_331:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_332
spu_ldst_332:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_332:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_333
spu_ldst_333:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_333:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_334
spu_ldst_334:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_334:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_335
spu_ldst_335:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_335:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_336
spu_ldst_336:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_336:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_337
spu_ldst_337:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_337:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_338
spu_ldst_338:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_338:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 40, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_339
spu_ldst_339:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_339:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_340
spu_ldst_340:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_340:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_341
spu_ldst_341:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_341:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_342
spu_ldst_342:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_342:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_343
spu_ldst_343:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_343:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_344
spu_ldst_344:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_344:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_345
spu_ldst_345:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_345:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_346
spu_ldst_346:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_346:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_347
spu_ldst_347:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_347:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_348
spu_ldst_348:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_348:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_349
spu_ldst_349:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_349:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_350
spu_ldst_350:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_350:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_351
spu_ldst_351:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_351:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_352
spu_ldst_352:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_352:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_353
spu_ldst_353:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_353:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_354
spu_ldst_354:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_354:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_355
spu_ldst_355:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_355:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_356
spu_ldst_356:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_356:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_357
spu_ldst_357:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_357:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_358
spu_ldst_358:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_358:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_359
spu_ldst_359:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_359:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_360
spu_ldst_360:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_360:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_361
spu_ldst_361:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_361:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_362
spu_ldst_362:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_362:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_363
spu_ldst_363:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_363:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_364
spu_ldst_364:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_364:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_365
spu_ldst_365:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_365:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_366
spu_ldst_366:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_366:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_367
spu_ldst_367:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_367:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_368
spu_ldst_368:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_368:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_369
spu_ldst_369:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_369:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_370
spu_ldst_370:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_370:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 29, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_371
spu_ldst_371:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_371:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 5, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_372
spu_ldst_372:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_372:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_373
spu_ldst_373:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_373:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_374
spu_ldst_374:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_374:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 29, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_375
spu_ldst_375:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_375:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_376
spu_ldst_376:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_376:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_377
spu_ldst_377:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_377:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 31, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_378
spu_ldst_378:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_378:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_379
spu_ldst_379:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_379:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 27, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_380
spu_ldst_380:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_380:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_381
spu_ldst_381:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_381:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 3, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_382
spu_ldst_382:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_382:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 29, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_383
spu_ldst_383:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_383:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_384
spu_ldst_384:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_384:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_385
spu_ldst_385:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_385:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_386
spu_ldst_386:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_386:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_387
spu_ldst_387:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_387:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_388
spu_ldst_388:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_388:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_389
spu_ldst_389:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_389:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 3, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_390
spu_ldst_390:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_390:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_391
spu_ldst_391:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_391:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_392
spu_ldst_392:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_392:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_393
spu_ldst_393:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_393:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_394
spu_ldst_394:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_394:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_395
spu_ldst_395:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_395:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_396
spu_ldst_396:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_396:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_397
spu_ldst_397:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_397:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_398
spu_ldst_398:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_398:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_399
spu_ldst_399:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_399:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_400
spu_ldst_400:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_400:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_401
spu_ldst_401:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_401:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_402
spu_ldst_402:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_402:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 42, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_403
spu_ldst_403:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_403:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_404
spu_ldst_404:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_404:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_405
spu_ldst_405:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_405:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_406
spu_ldst_406:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_406:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_407
spu_ldst_407:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_407:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 42, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_408
spu_ldst_408:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_408:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_409
spu_ldst_409:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_409:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_410
spu_ldst_410:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_410:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_411
spu_ldst_411:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_411:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_412
spu_ldst_412:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_412:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_413
spu_ldst_413:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_413:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_414
spu_ldst_414:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_414:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_415
spu_ldst_415:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_415:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_416
spu_ldst_416:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_416:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_417
spu_ldst_417:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_417:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_418
spu_ldst_418:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_418:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_419
spu_ldst_419:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_419:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 50, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_420
spu_ldst_420:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_420:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_421
spu_ldst_421:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_421:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_422
spu_ldst_422:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_422:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_423
spu_ldst_423:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_423:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_424
spu_ldst_424:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_424:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_425
spu_ldst_425:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_425:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_426
spu_ldst_426:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_426:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_427
spu_ldst_427:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_427:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_428
spu_ldst_428:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_428:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 3, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_429
spu_ldst_429:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_429:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_430
spu_ldst_430:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_430:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_431
spu_ldst_431:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_431:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_432
spu_ldst_432:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_432:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_433
spu_ldst_433:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_433:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_434
spu_ldst_434:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_434:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_435
spu_ldst_435:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_435:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_436
spu_ldst_436:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_436:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_437
spu_ldst_437:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_437:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_438
spu_ldst_438:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_438:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_439
spu_ldst_439:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_439:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_440
spu_ldst_440:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_440:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_441
spu_ldst_441:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_441:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_442
spu_ldst_442:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_442:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_443
spu_ldst_443:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_443:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_444
spu_ldst_444:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_444:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_445
spu_ldst_445:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_445:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 46, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_446
spu_ldst_446:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_446:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_447
spu_ldst_447:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_447:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 9, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_448
spu_ldst_448:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_448:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_449
spu_ldst_449:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_449:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_450
spu_ldst_450:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_450:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 50, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_451
spu_ldst_451:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_451:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_452
spu_ldst_452:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_452:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 27, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_453
spu_ldst_453:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_453:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_454
spu_ldst_454:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_454:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_455
spu_ldst_455:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_455:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_456
spu_ldst_456:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_456:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_457
spu_ldst_457:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_457:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_458
spu_ldst_458:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_458:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_459
spu_ldst_459:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_459:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_460
spu_ldst_460:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_460:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_461
spu_ldst_461:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_461:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_462
spu_ldst_462:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_462:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_463
spu_ldst_463:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_463:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_464
spu_ldst_464:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_464:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 5, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_465
spu_ldst_465:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_465:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_466
spu_ldst_466:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_466:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_467
spu_ldst_467:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_467:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_468
spu_ldst_468:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_468:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_469
spu_ldst_469:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_469:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 46, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_470
spu_ldst_470:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_470:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_471
spu_ldst_471:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_471:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_472
spu_ldst_472:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_472:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_473
spu_ldst_473:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_473:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_474
spu_ldst_474:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_474:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_475
spu_ldst_475:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_475:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_476
spu_ldst_476:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_476:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_477
spu_ldst_477:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_477:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 46, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_478
spu_ldst_478:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_478:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_479
spu_ldst_479:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_479:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_480
spu_ldst_480:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_480:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_481
spu_ldst_481:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_481:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_482
spu_ldst_482:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_482:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_483
spu_ldst_483:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_483:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 42, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_484
spu_ldst_484:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_484:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_485
spu_ldst_485:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_485:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_486
spu_ldst_486:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_486:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 39, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_487
spu_ldst_487:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_487:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_488
spu_ldst_488:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_488:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_489
spu_ldst_489:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_489:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_490
spu_ldst_490:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_490:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 9, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_491
spu_ldst_491:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_491:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_492
spu_ldst_492:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_492:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_493
spu_ldst_493:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_493:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_494
spu_ldst_494:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_494:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_495
spu_ldst_495:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_495:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_496
spu_ldst_496:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_496:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_497
spu_ldst_497:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_497:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_498
spu_ldst_498:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_498:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_499
spu_ldst_499:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_499:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_500
spu_ldst_500:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_500:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_501
spu_ldst_501:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_501:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_502
spu_ldst_502:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_502:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_503
spu_ldst_503:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_503:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 9, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_504
spu_ldst_504:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_504:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_505
spu_ldst_505:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_505:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_506
spu_ldst_506:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_506:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_507
spu_ldst_507:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_507:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_508
spu_ldst_508:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_508:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_509
spu_ldst_509:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_509:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_510
spu_ldst_510:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_510:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_511
spu_ldst_511:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_511:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_512
spu_ldst_512:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_512:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_513
spu_ldst_513:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_513:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_514
spu_ldst_514:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_514:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_515
spu_ldst_515:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_515:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_516
spu_ldst_516:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_516:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 5, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_517
spu_ldst_517:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_517:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_518
spu_ldst_518:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_518:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_519
spu_ldst_519:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_519:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_520
spu_ldst_520:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_520:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_521
spu_ldst_521:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_521:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_522
spu_ldst_522:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_522:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_523
spu_ldst_523:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_523:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_524
spu_ldst_524:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_524:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_525
spu_ldst_525:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_525:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_526
spu_ldst_526:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_526:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_527
spu_ldst_527:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_527:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_528
spu_ldst_528:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_528:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_529
spu_ldst_529:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_529:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 50, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_530
spu_ldst_530:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_530:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_531
spu_ldst_531:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_531:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_532
spu_ldst_532:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_532:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_533
spu_ldst_533:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_533:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_534
spu_ldst_534:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_534:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_535
spu_ldst_535:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_535:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_536
spu_ldst_536:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_536:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_537
spu_ldst_537:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_537:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_538
spu_ldst_538:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_538:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_539
spu_ldst_539:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_539:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_540
spu_ldst_540:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_540:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_541
spu_ldst_541:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_541:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_542
spu_ldst_542:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_542:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_543
spu_ldst_543:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_543:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_544
spu_ldst_544:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_544:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_545
spu_ldst_545:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_545:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_546
spu_ldst_546:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_546:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_547
spu_ldst_547:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_547:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_548
spu_ldst_548:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_548:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_549
spu_ldst_549:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_549:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_550
spu_ldst_550:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_550:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_551
spu_ldst_551:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_551:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_552
spu_ldst_552:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_552:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_553
spu_ldst_553:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_553:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_554
spu_ldst_554:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_554:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_555
spu_ldst_555:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_555:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_556
spu_ldst_556:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_556:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_557
spu_ldst_557:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_557:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 40, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_558
spu_ldst_558:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_558:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 29, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_559
spu_ldst_559:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_559:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_560
spu_ldst_560:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_560:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_561
spu_ldst_561:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_561:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_562
spu_ldst_562:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_562:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_563
spu_ldst_563:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_563:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_564
spu_ldst_564:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_564:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_565
spu_ldst_565:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_565:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_566
spu_ldst_566:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_566:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_567
spu_ldst_567:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_567:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_568
spu_ldst_568:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_568:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 27, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_569
spu_ldst_569:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_569:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_570
spu_ldst_570:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_570:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_571
spu_ldst_571:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_571:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_572
spu_ldst_572:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_572:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_573
spu_ldst_573:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_573:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_574
spu_ldst_574:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_574:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_575
spu_ldst_575:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_575:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 53, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_576
spu_ldst_576:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_576:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_577
spu_ldst_577:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_577:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_578
spu_ldst_578:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_578:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 9, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_579
spu_ldst_579:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_579:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_580
spu_ldst_580:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_580:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_581
spu_ldst_581:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_581:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_582
spu_ldst_582:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_582:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_583
spu_ldst_583:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_583:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_584
spu_ldst_584:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_584:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_585
spu_ldst_585:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_585:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_586
spu_ldst_586:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_586:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_587
spu_ldst_587:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_587:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_588
spu_ldst_588:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_588:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_589
spu_ldst_589:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_589:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_590
spu_ldst_590:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_590:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_591
spu_ldst_591:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_591:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_592
spu_ldst_592:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_592:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_593
spu_ldst_593:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_593:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_594
spu_ldst_594:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_594:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_595
spu_ldst_595:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_595:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_596
spu_ldst_596:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_596:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_597
spu_ldst_597:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_597:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 40, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_598
spu_ldst_598:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_598:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_599
spu_ldst_599:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_599:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_600
spu_ldst_600:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_600:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_601
spu_ldst_601:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_601:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_602
spu_ldst_602:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_602:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_603
spu_ldst_603:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_603:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_604
spu_ldst_604:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_604:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_605
spu_ldst_605:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_605:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_606
spu_ldst_606:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_606:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_607
spu_ldst_607:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_607:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_608
spu_ldst_608:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_608:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 42, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_609
spu_ldst_609:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_609:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 49, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_610
spu_ldst_610:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_610:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_611
spu_ldst_611:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_611:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_612
spu_ldst_612:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_612:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_613
spu_ldst_613:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_613:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_614
spu_ldst_614:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_614:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_615
spu_ldst_615:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_615:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_616
spu_ldst_616:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_616:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_617
spu_ldst_617:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_617:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_618
spu_ldst_618:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_618:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_619
spu_ldst_619:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_619:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 3, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_620
spu_ldst_620:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_620:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 50, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_621
spu_ldst_621:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_621:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_622
spu_ldst_622:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_622:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 39, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_623
spu_ldst_623:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_623:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_624
spu_ldst_624:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_624:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_625
spu_ldst_625:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_625:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 5, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_626
spu_ldst_626:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_626:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_627
spu_ldst_627:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_627:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 31, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_628
spu_ldst_628:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_628:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_629
spu_ldst_629:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_629:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_630
spu_ldst_630:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_630:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_631
spu_ldst_631:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_631:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_632
spu_ldst_632:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_632:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_633
spu_ldst_633:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_633:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_634
spu_ldst_634:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_634:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_635
spu_ldst_635:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_635:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_636
spu_ldst_636:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_636:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_637
spu_ldst_637:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_637:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_638
spu_ldst_638:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_638:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_639
spu_ldst_639:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_639:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_640
spu_ldst_640:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_640:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_641
spu_ldst_641:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_641:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_642
spu_ldst_642:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_642:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_643
spu_ldst_643:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_643:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 31, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_644
spu_ldst_644:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_644:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 39, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_645
spu_ldst_645:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_645:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_646
spu_ldst_646:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_646:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_647
spu_ldst_647:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_647:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_648
spu_ldst_648:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_648:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_649
spu_ldst_649:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_649:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_650
spu_ldst_650:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_650:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_651
spu_ldst_651:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_651:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_652
spu_ldst_652:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_652:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_653
spu_ldst_653:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_653:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_654
spu_ldst_654:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_654:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_655
spu_ldst_655:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_655:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_656
spu_ldst_656:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_656:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_657
spu_ldst_657:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_657:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 3, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_658
spu_ldst_658:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_658:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_659
spu_ldst_659:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_659:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_660
spu_ldst_660:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_660:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 50, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_661
spu_ldst_661:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_661:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_662
spu_ldst_662:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_662:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_663
spu_ldst_663:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_663:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_664
spu_ldst_664:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_664:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_665
spu_ldst_665:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_665:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_666
spu_ldst_666:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_666:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_667
spu_ldst_667:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_667:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 29, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_668
spu_ldst_668:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_668:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_669
spu_ldst_669:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_669:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_670
spu_ldst_670:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_670:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_671
spu_ldst_671:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_671:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_672
spu_ldst_672:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_672:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_673
spu_ldst_673:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_673:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_674
spu_ldst_674:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_674:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_675
spu_ldst_675:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_675:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_676
spu_ldst_676:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_676:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_677
spu_ldst_677:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_677:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 53, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_678
spu_ldst_678:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_678:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_679
spu_ldst_679:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_679:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_680
spu_ldst_680:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_680:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_681
spu_ldst_681:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_681:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 40, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_682
spu_ldst_682:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_682:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_683
spu_ldst_683:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_683:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_684
spu_ldst_684:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_684:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_685
spu_ldst_685:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_685:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 50, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_686
spu_ldst_686:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_686:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_687
spu_ldst_687:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_687:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_688
spu_ldst_688:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_688:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_689
spu_ldst_689:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_689:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_690
spu_ldst_690:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_690:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_691
spu_ldst_691:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_691:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_692
spu_ldst_692:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_692:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_693
spu_ldst_693:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_693:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_694
spu_ldst_694:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_694:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_695
spu_ldst_695:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_695:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_696
spu_ldst_696:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_696:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_697
spu_ldst_697:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_697:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_698
spu_ldst_698:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_698:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_699
spu_ldst_699:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_699:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_700
spu_ldst_700:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_700:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_701
spu_ldst_701:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_701:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_702
spu_ldst_702:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_702:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_703
spu_ldst_703:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_703:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 31, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_704
spu_ldst_704:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_704:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_705
spu_ldst_705:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_705:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_706
spu_ldst_706:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_706:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_707
spu_ldst_707:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_707:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_708
spu_ldst_708:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_708:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_709
spu_ldst_709:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_709:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_710
spu_ldst_710:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_710:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_711
spu_ldst_711:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_711:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_712
spu_ldst_712:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_712:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_713
spu_ldst_713:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_713:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_714
spu_ldst_714:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_714:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_715
spu_ldst_715:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_715:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_716
spu_ldst_716:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_716:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_717
spu_ldst_717:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_717:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_718
spu_ldst_718:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_718:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 40, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_719
spu_ldst_719:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_719:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_720
spu_ldst_720:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_720:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 42, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_721
spu_ldst_721:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_721:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_722
spu_ldst_722:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_722:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_723
spu_ldst_723:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_723:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_724
spu_ldst_724:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_724:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_725
spu_ldst_725:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_725:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_726
spu_ldst_726:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_726:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 5, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_727
spu_ldst_727:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_727:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 31, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_728
spu_ldst_728:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_728:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_729
spu_ldst_729:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_729:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_730
spu_ldst_730:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_730:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_731
spu_ldst_731:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_731:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_732
spu_ldst_732:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_732:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_733
spu_ldst_733:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_733:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_734
spu_ldst_734:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_734:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 49, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_735
spu_ldst_735:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_735:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_736
spu_ldst_736:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_736:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_737
spu_ldst_737:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_737:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_738
spu_ldst_738:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_738:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_739
spu_ldst_739:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_739:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_740
spu_ldst_740:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_740:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_741
spu_ldst_741:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_741:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_742
spu_ldst_742:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_742:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_743
spu_ldst_743:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_743:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_744
spu_ldst_744:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_744:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_745
spu_ldst_745:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_745:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_746
spu_ldst_746:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_746:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 31, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_747
spu_ldst_747:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_747:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_748
spu_ldst_748:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_748:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 31, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_749
spu_ldst_749:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_749:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_750
spu_ldst_750:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_750:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_751
spu_ldst_751:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_751:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_752
spu_ldst_752:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_752:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_753
spu_ldst_753:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_753:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_754
spu_ldst_754:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_754:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_755
spu_ldst_755:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_755:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_756
spu_ldst_756:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_756:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_757
spu_ldst_757:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_757:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_758
spu_ldst_758:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_758:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 50, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_759
spu_ldst_759:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_759:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_760
spu_ldst_760:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_760:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_761
spu_ldst_761:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_761:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_762
spu_ldst_762:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_762:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_763
spu_ldst_763:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_763:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_764
spu_ldst_764:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_764:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_765
spu_ldst_765:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_765:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_766
spu_ldst_766:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_766:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_767
spu_ldst_767:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_767:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_768
spu_ldst_768:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_768:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_769
spu_ldst_769:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_769:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_770
spu_ldst_770:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_770:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 39, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_771
spu_ldst_771:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_771:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_772
spu_ldst_772:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_772:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_773
spu_ldst_773:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_773:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_774
spu_ldst_774:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_774:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 1, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_775
spu_ldst_775:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_775:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_776
spu_ldst_776:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_776:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_777
spu_ldst_777:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_777:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_778
spu_ldst_778:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_778:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_779
spu_ldst_779:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_779:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_780
spu_ldst_780:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_780:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_781
spu_ldst_781:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_781:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_782
spu_ldst_782:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_782:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_783
spu_ldst_783:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_783:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_784
spu_ldst_784:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_784:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_785
spu_ldst_785:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_785:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_786
spu_ldst_786:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_786:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_787
spu_ldst_787:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_787:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_788
spu_ldst_788:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_788:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_789
spu_ldst_789:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_789:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_790
spu_ldst_790:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_790:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_791
spu_ldst_791:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_791:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_792
spu_ldst_792:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_792:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_793
spu_ldst_793:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_793:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_794
spu_ldst_794:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_794:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_795
spu_ldst_795:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_795:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_796
spu_ldst_796:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_796:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_797
spu_ldst_797:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_797:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_798
spu_ldst_798:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_798:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_799
spu_ldst_799:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_799:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_800
spu_ldst_800:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_800:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_801
spu_ldst_801:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_801:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_802
spu_ldst_802:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_802:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_803
spu_ldst_803:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_803:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 49, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_804
spu_ldst_804:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_804:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_805
spu_ldst_805:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_805:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_806
spu_ldst_806:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_806:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_807
spu_ldst_807:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_807:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_808
spu_ldst_808:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_808:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_809
spu_ldst_809:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_809:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_810
spu_ldst_810:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_810:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_811
spu_ldst_811:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_811:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_812
spu_ldst_812:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_812:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_813
spu_ldst_813:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_813:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_814
spu_ldst_814:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_814:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 49, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_815
spu_ldst_815:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_815:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 52, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_816
spu_ldst_816:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_816:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_817
spu_ldst_817:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_817:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_818
spu_ldst_818:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_818:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_819
spu_ldst_819:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_819:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_820
spu_ldst_820:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_820:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_821
spu_ldst_821:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_821:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_822
spu_ldst_822:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_822:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 42, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_823
spu_ldst_823:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_823:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_824
spu_ldst_824:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_824:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_825
spu_ldst_825:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_825:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_826
spu_ldst_826:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_826:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 40, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_827
spu_ldst_827:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_827:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_828
spu_ldst_828:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_828:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 46, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_829
spu_ldst_829:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_829:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_830
spu_ldst_830:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_830:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_831
spu_ldst_831:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_831:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_832
spu_ldst_832:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_832:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 41, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_833
spu_ldst_833:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_833:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_834
spu_ldst_834:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_834:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 39, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_835
spu_ldst_835:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_835:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 27, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_836
spu_ldst_836:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_836:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 27, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_837
spu_ldst_837:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_837:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 29, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_838
spu_ldst_838:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_838:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_839
spu_ldst_839:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_839:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_840
spu_ldst_840:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_840:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_841
spu_ldst_841:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_841:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 49, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_842
spu_ldst_842:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_842:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_843
spu_ldst_843:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_843:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 15, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_844
spu_ldst_844:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_844:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_845
spu_ldst_845:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_845:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_846
spu_ldst_846:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_846:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_847
spu_ldst_847:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_847:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_848
spu_ldst_848:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_848:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_849
spu_ldst_849:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_849:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_850
spu_ldst_850:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_850:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_851
spu_ldst_851:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_851:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_852
spu_ldst_852:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_852:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_853
spu_ldst_853:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_853:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_854
spu_ldst_854:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_854:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_855
spu_ldst_855:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_855:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_856
spu_ldst_856:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_856:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_857
spu_ldst_857:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_857:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_858
spu_ldst_858:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_858:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_859
spu_ldst_859:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_859:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_860
spu_ldst_860:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_860:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 21, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_861
spu_ldst_861:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_861:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_862
spu_ldst_862:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_862:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_863
spu_ldst_863:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_863:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_864
spu_ldst_864:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_864:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_865
spu_ldst_865:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_865:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_866
spu_ldst_866:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_866:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 29, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_867
spu_ldst_867:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_867:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 35, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_868
spu_ldst_868:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_868:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_869
spu_ldst_869:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_869:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_870
spu_ldst_870:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_870:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_871
spu_ldst_871:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_871:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 46, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_872
spu_ldst_872:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_872:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_873
spu_ldst_873:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_873:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_874
spu_ldst_874:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_874:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 29, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_875
spu_ldst_875:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_875:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_876
spu_ldst_876:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_876:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_877
spu_ldst_877:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_877:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_878
spu_ldst_878:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_878:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_879
spu_ldst_879:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_879:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 7, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_880
spu_ldst_880:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_880:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_881
spu_ldst_881:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_881:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_882
spu_ldst_882:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_882:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_883
spu_ldst_883:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_883:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_884
spu_ldst_884:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_884:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_885
spu_ldst_885:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_885:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_886
spu_ldst_886:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_886:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_887
spu_ldst_887:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_887:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 13, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_888
spu_ldst_888:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_888:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 5, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_889
spu_ldst_889:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_889:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_890
spu_ldst_890:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_890:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_891
spu_ldst_891:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_891:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_892
spu_ldst_892:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_892:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 51, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_893
spu_ldst_893:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_893:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 10, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_894
spu_ldst_894:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_894:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_895
spu_ldst_895:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_895:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_896
spu_ldst_896:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_896:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 57, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_897
spu_ldst_897:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_897:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 43, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_898
spu_ldst_898:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_898:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_899
spu_ldst_899:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_899:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_900
spu_ldst_900:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_900:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_901
spu_ldst_901:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_901:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 40, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_902
spu_ldst_902:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_902:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_903
spu_ldst_903:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_903:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_904
spu_ldst_904:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_904:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_905
spu_ldst_905:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_905:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_906
spu_ldst_906:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_906:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 29, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_907
spu_ldst_907:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_907:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_908
spu_ldst_908:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_908:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 53, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_909
spu_ldst_909:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_909:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_910
spu_ldst_910:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_910:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_911
spu_ldst_911:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_911:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_912
spu_ldst_912:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_912:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_913
spu_ldst_913:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_913:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_914
spu_ldst_914:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_914:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_915
spu_ldst_915:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_915:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_916
spu_ldst_916:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_916:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 30, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_917
spu_ldst_917:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_917:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_918
spu_ldst_918:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_918:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_919
spu_ldst_919:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_919:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_920
spu_ldst_920:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_920:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_921
spu_ldst_921:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_921:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_922
spu_ldst_922:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_922:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_923
spu_ldst_923:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_923:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 31, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_924
spu_ldst_924:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_924:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_925
spu_ldst_925:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_925:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_926
spu_ldst_926:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_926:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 9, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_927
spu_ldst_927:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_927:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 50, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_928
spu_ldst_928:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_928:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_929
spu_ldst_929:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_929:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 39, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_930
spu_ldst_930:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_930:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 11, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_931
spu_ldst_931:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_931:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_932
spu_ldst_932:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_932:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_933
spu_ldst_933:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_933:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_934
spu_ldst_934:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_934:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 26, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_935
spu_ldst_935:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_935:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_936
spu_ldst_936:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_936:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_937
spu_ldst_937:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_937:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 23, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_938
spu_ldst_938:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_938:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 62, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_939
spu_ldst_939:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_939:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_940
spu_ldst_940:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_940:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 39, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_941
spu_ldst_941:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_941:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_942
spu_ldst_942:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_942:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 58, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_943
spu_ldst_943:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_943:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_944
spu_ldst_944:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_944:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_945
spu_ldst_945:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_945:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_946
spu_ldst_946:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_946:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 28, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_947
spu_ldst_947:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_947:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_948
spu_ldst_948:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_948:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_949
spu_ldst_949:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_949:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_950
spu_ldst_950:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_950:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 60, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_951
spu_ldst_951:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_951:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 8, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_952
spu_ldst_952:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_952:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_953
spu_ldst_953:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_953:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 32, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_954
spu_ldst_954:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_954:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_955
spu_ldst_955:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_955:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 19, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_956
spu_ldst_956:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_956:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 54, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_957
spu_ldst_957:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_957:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_958
spu_ldst_958:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_958:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_959
spu_ldst_959:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_959:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 5, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_960
spu_ldst_960:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_960:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_961
spu_ldst_961:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_961:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_962
spu_ldst_962:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_962:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 46, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_963
spu_ldst_963:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_963:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 44, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_964
spu_ldst_964:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_964:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_965
spu_ldst_965:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_965:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 14, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_966
spu_ldst_966:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_966:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 25, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_967
spu_ldst_967:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_967:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_968
spu_ldst_968:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_968:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 63, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_969
spu_ldst_969:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_969:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 64, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_970
spu_ldst_970:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_970:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 22, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_971
spu_ldst_971:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_971:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 36, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_972
spu_ldst_972:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_972:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 17, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_973
spu_ldst_973:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_973:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_974
spu_ldst_974:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_974:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 59, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_975
spu_ldst_975:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_975:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 38, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_976
spu_ldst_976:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_976:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 18, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_977
spu_ldst_977:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_977:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 3, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_978
spu_ldst_978:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_978:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_979
spu_ldst_979:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_979:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_980
spu_ldst_980:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_980:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 9, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_981
spu_ldst_981:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_981:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 48, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_982
spu_ldst_982:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_982:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 4, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_983
spu_ldst_983:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_983:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 33, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_984
spu_ldst_984:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_984:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 45, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_985
spu_ldst_985:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_985:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 56, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_986
spu_ldst_986:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_986:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 37, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_987
spu_ldst_987:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_987:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 2, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_988
spu_ldst_988:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_988:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 20, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_989
spu_ldst_989:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_989:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 27, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_990
spu_ldst_990:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_990:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 49, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_991
spu_ldst_991:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_991:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 16, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_992
spu_ldst_992:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_992:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 55, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_993
spu_ldst_993:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_993:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 24, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_994
spu_ldst_994:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_994:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 6, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_995
spu_ldst_995:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_995:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 27, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_996
spu_ldst_996:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_996:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_997
spu_ldst_997:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_997:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 61, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_998
spu_ldst_998:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_998:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 47, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  
.global spu_ldst_999
spu_ldst_999:

	
  	wr	%g0, SPU_ASI, %asi  ! set up the asi register to contain SPU asi
init_spu_ldst_999:
	setpa	(spu_data_src, %l0, %l1, %l5)  
	stxa	%l5, [%g0+REG_MPA_ADDR] %asi
	! set the PA of spu_data_dest to %l6 using %l0 and %l1 as temp regs
	setpa	(spu_data_dest, %l0, %l1, %l6)  
	stxa	%g0, [%g0+REG_MA_ADDR_ADDR] %asi   ! set 0 to the REG_MA_ADDR for MAMEM offset

	add	%g0, 12, %i3  ! %i3 contains number of xwords to load/store
	sub	%i3, 1,  %i0	! #of xwords to load to MAMEM minus 1
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! store to the MA_CTL register to load %i0 + 1 xwords to MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
	stxa	%l6, [%g0+REG_MPA_ADDR] %asi ! set spu_data_dest to MPA
	or	%i0, 0x40, %i0
	stxa	%i0, [%g0+REG_MA_CTL_ADDR] %asi   ! set the MA_CTL register to store out %i0 + 1 xwords of MAMEM
	ldxa	[%g0+MASync_ADDR] %asi, %l7
  

	 ba diag_pass 
	 nop 
run_th_2:

	 wr %g0, 248, %asi

	 ta T_CHANGE_PRIV 
	 nop 
	 set 2430866107, %i0
	 set 749056619, %i1
	 set 1085606506, %i2
	 set 4148121874, %i3
	 set 1350417553, %i4
	 set 1197303836, %i5
	 set 2190453686, %i6
	 set 2636098926, %i7
	 set 3574352650, %o0
	 set 3610422619, %o1
	 set 622130510, %o2
	 set 373330342, %o3
	 set 2422736073, %o4
	 set 1834291173, %o5
	 set 65774138, %o6
	 set 1994782052, %o7
	 set 448629150, %l0
	 set 3823589100, %l1
	 set 306638650, %l2
	 set 1500321061, %l3
	 set 3726879838, %l4
	 set 3052517986, %l5
	 set 1432304305, %l6
	 set 4031628574, %l7
	 set 332699133, %g0
	 set 3567897207, %g1
	 set 868233184, %g2
	 set 4045639261, %g3
	 set 476939733, %g4
	 set 2798832479, %g5
	 set 1416753496, %g6
	 set 1346959920, %g7

wr %g0, 0x4, %fprs 
	 setx self_modcode, %l0, %l3
	 ldd [%l3], %f0
	 add 0x8, %l3, %l3
	 ldd [%l3], %f2
	 add 0x8, %l3, %l3
	 ldd [%l3], %f4
	 add 0x8, %l3, %l3
	 ldd [%l3], %f6
	 add 0x8, %l3, %l3
	 ldd [%l3], %f8
	 add 0x8, %l3, %l3
	 ldd [%l3], %f10
	 add 0x8, %l3, %l3
	 ldd [%l3], %f12
	 add 0x8, %l3, %l3
	 ldd [%l3], %f14
	 add 0x8, %l3, %l3
	 ldd [%l3], %f16
	 add 0x8, %l3, %l3
	 ldd [%l3], %f18
	 add 0x8, %l3, %l3
	 ldd [%l3], %f20
	 add 0x8, %l3, %l3
	 ldd [%l3], %f22
	 add 0x8, %l3, %l3
	 ldd [%l3], %f24
	 add 0x8, %l3, %l3
	 ldd [%l3], %f26
	 add 0x8, %l3, %l3
	 ldd [%l3], %f28
	 add 0x8, %l3, %l3
	 ldd [%l3], %f30
	 add 0x8, %l3, %l3
	 ldd [%l3], %f32
	 add 0x8, %l3, %l3
	 ldd [%l3], %f34
	 add 0x8, %l3, %l3
	 ldd [%l3], %f36
	 add 0x8, %l3, %l3
	 ldd [%l3], %f38
	 add 0x8, %l3, %l3
	 ldd [%l3], %f40
	 add 0x8, %l3, %l3
	 ldd [%l3], %f42
	 add 0x8, %l3, %l3
	 ldd [%l3], %f44
	 add 0x8, %l3, %l3
	 ldd [%l3], %f46
	 add 0x8, %l3, %l3
	 ldd [%l3], %f48
	 add 0x8, %l3, %l3
	 ldd [%l3], %f50
	 add 0x8, %l3, %l3
	 ldd [%l3], %f52
	 add 0x8, %l3, %l3
	 ldd [%l3], %f54
	 add 0x8, %l3, %l3
	 ldd [%l3], %f56
	 add 0x8, %l3, %l3
	 ldd [%l3], %f58
	 add 0x8, %l3, %l3
	 ldd [%l3], %f60
	 add 0x8, %l3, %l3
	 ldd [%l3], %f62
	 add 0x8, %l3, %l3
	 setx data0, %l0, %l3
	 setx self_modcode, %l0, %l1
	 .word 0xc11ce000
	 .word 0xe1bce080

	 .word 0xecbcdf00
	 .word 0xe1bcdf00

	 .word 0xf3f4e000
	 .word 0xe19cde00

	 .word 0x81dce0c6
	 .word 0xe19ce240

	 .word 0xec1ce010
	 .word 0xc1bce000

	 .word 0xecbcdf00
	 .word 0xc19cdf00

	 .word 0xc11ce030
	 .word 0xe1bcde20

	 .word 0xc13cc000
	 .word 0xe19ce140

	 .word 0xc1bce380
	 .word 0xc1bcdf00

	 .word 0xeea4e004
	 .word 0xc1bce080

	 .word 0xf024c000
	 .word 0xe1bce140

	 .word 0xf9f4de20
	 .word 0xe1bce3c0

	 .word 0x8143e02a
	 .word 0xe1bcde00

	 .word 0xf87cc000
	 .word 0xe1bce180

	 .word 0xf44ce01e
	 .word 0xc1bcdf20

	 .word 0xf86cc000
	 .word 0xc19ce2c0

	 .word 0xf26cc000
	 .word 0xc1bce1c0

	 .word 0xf3e4df20
	 .word 0xe19cdf20

	 .word 0x8143e00c
	 .word 0xe19ce000

	 .word 0xf7e4e000
	 .word 0xc1bcde20

	 .word 0xf6ece035
	 .word 0xc19cdf20

	 .word 0xf66ce00d
	 .word 0xc19cdf20

	 .word 0xe19ce080
	 .word 0xe1bcde20

	 .word 0xc924e024
	 .word 0xe19ce300

	 .word 0xf86cc000
	 .word 0xc19ce240

	 .word 0xec9cdf20
	 .word 0xe1bce380

	 .word 0x8143c000
	 .word 0xc1bcdf00

	 .word 0xea7cc000
	 .word 0xe19cde00

	 .word 0xd3ecdf00
	 .word 0xe1bce000

	 .word 0xf0fcdf00
	 .word 0xe1bcdf00

	 .word 0xf2ece03e
	 .word 0xe1bce080

	 .word 0x81dce05b
	 .word 0xc19cde20

	 .word 0xec9cdf20
	 .word 0xe1bcdf20

	 .word 0x8143c000
	 .word 0xe19cde20

	 .word 0xf8fce000
	 .word 0xe19ce2c0

	 .word 0xdd1cc000
	 .word 0xe19ce340

	 .word 0xd56ce040
	 .word 0xc19cdf00

	 .word 0x8143c000
	 .word 0xc1bcdf20

	 .word 0xf414e000
	 .word 0xc1bcdf20

	 .word 0xf454e002
	 .word 0xc1bce0c0

	 .word 0xf684e004
	 .word 0xc19cdf00

	 .word 0xf47ce000
	 .word 0xc19cde20

	 .word 0xecbce010
	 .word 0xe19ce140

	 .word 0xf46cc000
	 .word 0xe19ce300

	 .word 0xc1bce200
	 .word 0xc19ce3c0

	 .word 0xeeb4df20
	 .word 0xc1bcdf20

	 .word 0xf07cc000
	 .word 0xe19ce1c0

	 .word 0xf7e4df00
	 .word 0xe1bce3c0

	 .word 0x8143e021
	 .word 0xc19cdf00

	 .word 0xfaa4de20
	 .word 0xe1bcde20

	 .word 0xf4d4df20
	 .word 0xe19ce000

	 .word 0xfa04e004
	 .word 0xe1bce0c0

	 .word 0xe1bcde20
	 .word 0xc19cde20

	 .word 0xcb24e004
	 .word 0xe1bce0c0

	 .word 0xe1bcdf00
	 .word 0xc1bcdf00

	 .word 0xf224c000
	 .word 0xe1bcdf20

	 .word 0xf5f4e000
	 .word 0xc1bcde00

	 .word 0xf3f4df20
	 .word 0xe19cdf20

	 .word 0xe19ce380
	 .word 0xe19cdf20

	 .word 0xf02cc000
	 .word 0xc1bcde00

	 .word 0xcd04c000
	 .word 0xe19ce2c0

	 .word 0xf8b4e002
	 .word 0xe19cdf00

	 .word 0xddece010
	 .word 0xe19ce340

	 .word 0x81dcc000
	 .word 0xe19ce340

	 .word 0xe19ce140
	 .word 0xe19cdf20

	 .word 0x8143c000
	 .word 0xe19cdf00

	 .word 0xc1bcdf20
	 .word 0xc19cdf20

	 .word 0xdd3ce010
	 .word 0xc1bcde00

	 .word 0xec6ce037
	 .word 0xc19cde00

	 .word 0xf274e008
	 .word 0xe1bce180

	 .word 0xf76ce050
	 .word 0xc19cdf00

	 .word 0xe19ce340
	 .word 0xe1bce2c0

	 .word 0xf0c4de20
	 .word 0xe1bcde20

	 .word 0xf7e4e000
	 .word 0xc19ce1c0

	 .word 0xf3e4e000
	 .word 0xe19cdf00

	 .word 0xf87ce000
	 .word 0xe19cde00

	 .word 0xec7cc000
	 .word 0xe19cdf00

	 .word 0x8143e053
	 .word 0xe1bce040

	 .word 0xee24e000
	 .word 0xc1bce140

	 .word 0xc104e034
	 .word 0xc19cde00

	 .word 0xdf04c000
	 .word 0xe1bce180

	 .word 0xf224c000
	 .word 0xc1bcdf00

	 .word 0xc7ece060
	 .word 0xe1bce100

	 .word 0xeaece022
	 .word 0xc19cde00

	 .word 0x8143c000
	 .word 0xc19ce080

	 .word 0xc11ce030
	 .word 0xe19ce100

	 .word 0xf66cc000
	 .word 0xe1bce080

	 .word 0xe19ce0c0
	 .word 0xe19ce200

	 .word 0x81dcc000
	 .word 0xe19ce340

	 .word 0xf86ce010
	 .word 0xc19ce3c0

	 .word 0xf06ce002
	 .word 0xe1bcde20

	 .word 0xf4b4df20
	 .word 0xc19ce240

	 .word 0xc124e03c
	 .word 0xc19cde00

	 .word 0xec7ce004
	 .word 0xc1bce180

	 .word 0xe19cdf20
	 .word 0xc19cdf20

	 .word 0xf0b4e002
	 .word 0xe1bcde20

	 .word 0xcbece020
	 .word 0xc1bce140

	 .word 0xf87ce000
	 .word 0xc1bcdf20

	 .word 0xea8cdf20
	 .word 0xe19ce100

	 .word 0xc11cc000
	 .word 0xe19ce380

	 .word 0xefe4e000
	 .word 0xe1bce340

	 .word 0xc36cc000
	 .word 0xc1bce000

	 .word 0xc104e024
	 .word 0xe19ce380

	 .word 0xf07cc000
	 .word 0xc19ce340

	 .word 0xd53cc000
	 .word 0xe1bcde00

	 .word 0x8143c000
	 .word 0xc1bcde00

	 .word 0xc16ce020
	 .word 0xc1bcde20

	 .word 0xf454c000
	 .word 0xc19ce240

	 .word 0xecfce000
	 .word 0xe19ce040

	 .word 0xc19ce300
	 .word 0xe1bcdf20

	 .word 0xf62cc000
	 .word 0xe19ce280

	 .word 0xc11ce030
	 .word 0xc1bce200

	 .word 0xf2ece01f
	 .word 0xc19cdf00

	 .word 0xc104e004
	 .word 0xc19ce300

	 .word 0xfb6cc000
	 .word 0xc19ce2c0

	 .word 0xcd04c000
	 .word 0xc1bcde20

	 .word 0xeaece029
	 .word 0xe1bcdf20

	 .word 0xf3e4e000
	 .word 0xe19cdf20

	 .word 0xc11ce000
	 .word 0xc1bce240

	 .word 0xfafce004
	 .word 0xc1bcdf20

	 .word 0xc19cde00
	 .word 0xe1bce380

	 .word 0x8143e014
	 .word 0xc19cde20

	 .word 0xf6dcdf00
	 .word 0xe1bcdf00

	 .word 0xea34c000
	 .word 0xe19ce2c0

	 .word 0xeff4e000
	 .word 0xe1bcdf00

	 .word 0xc124e014
	 .word 0xc19ce340

	 .word 0xf46ce03c
	 .word 0xc1bcdf00

	 .word 0xeeece030
	 .word 0xe19cdf00

	 .word 0xf26ce02e
	 .word 0xe19cdf00

	 .word 0xebe4e000
	 .word 0xe19cdf00

	 .word 0xe19ce140
	 .word 0xc1bcdf00

	 .word 0xee7cc000
	 .word 0xe19cdf20

	 .word 0xfab4e000
	 .word 0xe1bcdf20

	 .word 0xeec4e000
	 .word 0xc1bcdf00

	 .word 0xf07ce004
	 .word 0xe1bcdf00

	 .word 0xfaace01a
	 .word 0xc19ce140

	 .word 0xf9e4e000
	 .word 0xe1bce300

	 .word 0xf56cc000
	 .word 0xe19ce180

	 .word 0xecbcde00
	 .word 0xc1bcde00

	 .word 0xf9f4df00
	 .word 0xe1bcdf00

	 .word 0xc11ce010
	 .word 0xe1bcdf20

	 .word 0xc11cc000
	 .word 0xc19cde20

	 .word 0xcfecde00
	 .word 0xc19ce380

	 .word 0xf67cc000
	 .word 0xe19ce100

	 .word 0xc104e00e
	 .word 0xc19ce2c0

	 .word 0xf1e4e000
	 .word 0xc1bce140

	 .word 0xc19ce2c0
	 .word 0xc19cde00

	 .word 0xf0dcdf00
	 .word 0xc1bcdf00

	 .word 0xd3ece0a0
	 .word 0xe19cdf20

	 .word 0xf5e4e000
	 .word 0xc1bcde00

	 .word 0xee6ce00a
	 .word 0xc19cde20

	 .word 0xe19ce040
	 .word 0xe1bce040

	 .word 0xea74c000
	 .word 0xc19cde00

	 .word 0xc93cc000
	 .word 0xc19ce1c0

	 .word 0xf2dcdf20
	 .word 0xe1bcdf20

	 .word 0xc104e012
	 .word 0xc1bcde20

	 .word 0xf2ace02b
	 .word 0xe19ce280

	 .word 0x81dce0ea
	 .word 0xc19ce180

	 .word 0xf814e000
	 .word 0xc1bcdf00

	 .word 0xf2fcde00
	 .word 0xe19cde00

	 .word 0x8143c000
	 .word 0xc19ce080

	 .word 0x8143e01c
	 .word 0xe19cdf00

	 .word 0xeefce004
	 .word 0xc1bce200

	 .word 0xf24cc000
	 .word 0xe19cde20

	 .word 0x8143e024
	 .word 0xc19ce200

	 .word 0xc724e038
	 .word 0xe19ce080

	 .word 0xfa84df00
	 .word 0xc1bcdf00

	 .word 0xecf4df20
	 .word 0xc19cdf20

	 .word 0xf6ece012
	 .word 0xc19cdf00

	 .word 0xc324e00c
	 .word 0xc19ce240

	 .word 0xeefce000
	 .word 0xe19ce1c0

	 .word 0xf6dce000
	 .word 0xe1bce280

	 .word 0xf4fcdf20
	 .word 0xc19cdf20

	 .word 0xc13ce030
	 .word 0xc1bcde20

	 .word 0xeedcde00
	 .word 0xc1bce3c0

	 .word 0xecb4df00
	 .word 0xe1bcdf00

	 .word 0xcd04c000
	 .word 0xe1bcde20

	 .word 0xf0fce004
	 .word 0xc1bcde20

	 .word 0xf1f4e000
	 .word 0xc1bcde00

	 .word 0xfafce000
	 .word 0xe1bce0c0

	 .word 0xd504c000
	 .word 0xe19cdf00

	 .word 0xf4c4e000
	 .word 0xc1bce140

	 .word 0xf5f4df20
	 .word 0xe1bcdf20

	 .word 0xc19cde20
	 .word 0xe1bcde20

	 .word 0xecf4e008
	 .word 0xc1bcdf00

	 .word 0xec9ce000
	 .word 0xe1bcdf20

	 .word 0xc11ce010
	 .word 0xe1bce1c0

	 .word 0x8143c000
	 .word 0xc1bce0c0

	 .word 0xf9e4df00
	 .word 0xe1bce0c0

	 .word 0xf2ecdf00
	 .word 0xc19ce380

	 .word 0xf4acde20
	 .word 0xc1bcde20

	 .word 0xfa5cc000
	 .word 0xe19cde20

	 .word 0xf084df20
	 .word 0xe19cdf20

	 .word 0xf7e4df00
	 .word 0xc1bce080

	 .word 0xc104e006
	 .word 0xe1bcde20

	 .word 0x81dcc000
	 .word 0xe1bcde00

	 .word 0xc104e006
	 .word 0xc1bce080

	 .word 0xebe4e000
	 .word 0xc19ce340

	 .word 0xfa04c000
	 .word 0xe19cdf00

	 .word 0xf674e000
	 .word 0xc1bcde00

	 .word 0x8143c000
	 .word 0xc1bcde20

	 .word 0xf0b4e000
	 .word 0xc1bcdf00

	 .word 0xf3f4e000
	 .word 0xc19cde20

	 .word 0xf274c000
	 .word 0xc1bce280

	 .word 0xe19ce2c0
	 .word 0xc19cdf00

	 .word 0xec9cdf00
	 .word 0xc19ce100

	 .word 0xec7cc000
	 .word 0xe19ce280

	 .word 0xc1bce100
	 .word 0xe19cde00

	 .word 0xede4de20
	 .word 0xc19cde20

	 .word 0xe19cde20
	 .word 0xc19ce100

	 .word 0xec14c000
	 .word 0xc19cde20

	 .word 0xe19cdf00
	 .word 0xe1bce040

	 .word 0xe1bcdf20
	 .word 0xc19ce3c0

	 .word 0xf3f4e000
	 .word 0xe19cdf00

	 .word 0xea74e008
	 .word 0xe1bcde20

	 .word 0xf1e4de00
	 .word 0xc1bcde00

	 .word 0xf8f4e008
	 .word 0xe19cdf20

	 .word 0xec94e002
	 .word 0xc19ce380

	 .word 0xc19cde20
	 .word 0xc1bce280

	 .word 0xe1bce080
	 .word 0xc1bce1c0

	 .word 0xede4e000
	 .word 0xc1bcde00

	 .word 0x81dce090
	 .word 0xc1bce300

	 .word 0xefe4e000
	 .word 0xe1bcde00

	 .word 0xedf4e000
	 .word 0xe1bce000

	 .word 0xfafce004
	 .word 0xc19ce140

	 .word 0xf06ce01d
	 .word 0xc19cde20

	 .word 0xedf4e000
	 .word 0xc1bce340

	 .word 0xec84e004
	 .word 0xe19ce340

	 .word 0x8143e041
	 .word 0xc1bcdf20

	 .word 0xc1bcde20
	 .word 0xc19ce140

	 .word 0xf07cc000
	 .word 0xe19cde20

	 .word 0xf6fcde00
	 .word 0xe19cde00

	 .word 0xf87ce000
	 .word 0xc19ce180

	 .word 0xc1bcdf00
	 .word 0xc1bce040

	 .word 0xcd3cc000
	 .word 0xe19ce340

	 .word 0xdd24c000
	 .word 0xe1bce340

	 .word 0xf4ecdf00
	 .word 0xe1bce3c0

	 .word 0xc1bce140
	 .word 0xc19ce280

	 .word 0xf8ece02d
	 .word 0xc1bce100

	 .word 0xe76cc000
	 .word 0xe19cde00

	 .word 0xeefce004
	 .word 0xc19ce140

	 .word 0xf1f4e000
	 .word 0xc1bcdf20

	 .word 0xf234c000
	 .word 0xe19cde00

	 .word 0xdf24c000
	 .word 0xc19ce3c0

	 .word 0xecfcdf00
	 .word 0xc19ce240

	 .word 0x81dcc000
	 .word 0xe1bce000

	 .word 0xeff4e000
	 .word 0xc19ce300

	 .word 0xedf4e000
	 .word 0xc1bce1c0

	 .word 0x8143c000
	 .word 0xc19ce100

	 .word 0xf06ce03b
	 .word 0xe19ce240

	 .word 0xf004c000
	 .word 0xe1bcdf20

	 .word 0xf26cc000
	 .word 0xc19ce3c0

	 .word 0xfa7cc000
	 .word 0xe1bce240

	 .word 0xc13cc000
	 .word 0xe19ce140

	 .word 0xf9e4de00
	 .word 0xc19ce1c0

	 .word 0xf3f4df00
	 .word 0xe19cdf00

	 .word 0xe1bcdf20
	 .word 0xe1bce340

	 .word 0xf5e4df20
	 .word 0xe19ce000

	 .word 0xec5ce008
	 .word 0xe19ce1c0

	 .word 0xcdece0e0
	 .word 0xc1bce280

	 .word 0xee5cc000
	 .word 0xe1bcde00

	 .word 0xea24c000
	 .word 0xe1bce2c0

	 .word 0xf024e000
	 .word 0xe1bcde20

	 .word 0xeaece00a
	 .word 0xe19cdf00

	 .word 0xea7cc000
	 .word 0xe19cde20

	 .word 0xf26cc000
	 .word 0xe19ce300

	 .word 0xdd3ce030
	 .word 0xe1bce000

	 .word 0xf8fcde00
	 .word 0xc19ce300

	 .word 0xf044c000
	 .word 0xc1bce280

	 .word 0xf9e4de00
	 .word 0xc19ce2c0

	 .word 0xf6fcde20
	 .word 0xc1bcde20

	 .word 0xc13cc000
	 .word 0xe1bcde20

	 .word 0xead4e002
	 .word 0xe1bce200

	 .word 0xeeece032
	 .word 0xc1bce3c0

	 .word 0x8143c000
	 .word 0xc19ce180

	 .word 0xecece007
	 .word 0xc19cdf20

	 .word 0xf46ce012
	 .word 0xc1bcde00

	 .word 0xf2f4e000
	 .word 0xc1bcdf00

	 .word 0xf0f4e008
	 .word 0xc19cde20

	 .word 0xc1bce180
	 .word 0xe1bcde20

	 .word 0xf3e4de00
	 .word 0xc19ce000

	 .word 0xf1f4e000
	 .word 0xc1bce100

	 .word 0xd924e030
	 .word 0xc1bce180

	 .word 0xeea4e004
	 .word 0xe1bce0c0

	 .word 0xea7cc000
	 .word 0xe1bce380

	 .word 0xebe4e000
	 .word 0xc19ce080

	 .word 0xeff4df20
	 .word 0xe1bcdf20

	 .word 0xf86ce018
	 .word 0xc19cdf00

	 .word 0xc76ce020
	 .word 0xe1bcdf00

	 .word 0xf7e4df20
	 .word 0xe1bce380

	 .word 0xf8b4e000
	 .word 0xc19ce340

	 .word 0xec9cde20
	 .word 0xc1bce280

	 .word 0xe1bcde00
	 .word 0xc19cde00

	 .word 0xc1bcde20
	 .word 0xc1bce000

	 .word 0xececdf20
	 .word 0xc19cdf20

	 .word 0xececdf20
	 .word 0xe19cdf20

	 .word 0x81dcc000
	 .word 0xc1bce240

	 .word 0xfa7cc000
	 .word 0xc1bce240

	 .word 0xe1bcde20
	 .word 0xc19cde20

	 .word 0xee7cc000
	 .word 0xc19ce300

	 .word 0xdd3cc000
	 .word 0xc1bce380

	 .word 0xc11ce010
	 .word 0xe1bcde00

	 .word 0xf22cc000
	 .word 0xc19ce2c0

	 .word 0xf4d4de00
	 .word 0xe1bcde00

	 .word 0xe1bce000
	 .word 0xe1bce040

	 .word 0xf5e4e000
	 .word 0xc19ce280

	 .word 0xf2ece01d
	 .word 0xc1bce280

	 .word 0xc19cdf20
	 .word 0xe19ce1c0

	 .word 0xf06cc000
	 .word 0xe19ce140

	 .word 0xe19ce100
	 .word 0xc1bcde20

	 .word 0xf414e000
	 .word 0xe1bce080

	 .word 0xc924c000
	 .word 0xc19cde20

	 .word 0xf6ecde00
	 .word 0xe19cde00

	 .word 0x8143c000
	 .word 0xe1bcde00

	 .word 0xc1ecdf20
	 .word 0xc19ce240

	 .word 0xefe4de00
	 .word 0xc19ce380

	 .word 0xf6ece03d
	 .word 0xc1bcdf00

	 .word 0xc53ce020
	 .word 0xc19ce080

	 .word 0xea7cc000
	 .word 0xc19cdf20

	 .word 0xea04c000
	 .word 0xe19ce0c0

	 .word 0x8143e019
	 .word 0xe19ce0c0

	 .word 0xc19ce200
	 .word 0xe1bcdf20

	 .word 0xf8fcdf00
	 .word 0xc19cdf00

	 .word 0xec3cc000
	 .word 0xc19ce240

	 .word 0xf8a4de00
	 .word 0xc1bcde00

	 .word 0xf1f4e000
	 .word 0xe19cdf00

	 .word 0xf5ecde00
	 .word 0xe1bce000

	 .word 0xf4ece001
	 .word 0xc1bce180

	 .word 0xeaece03f
	 .word 0xc1bce000

	 .word 0xf9e4e000
	 .word 0xc19ce340

	 .word 0xee7ce000
	 .word 0xe1bcdf20

	 .word 0xc19cdf20
	 .word 0xe1bcdf20

	 .word 0xf6ccde20
	 .word 0xc1bce100

	 .word 0xf7f4e000
	 .word 0xe1bcdf00

	 .word 0xf254c000
	 .word 0xe1bcde00

	 .word 0xee7cc000
	 .word 0xe1bce340

	 .word 0xf1e4e000
	 .word 0xc1bce1c0

	 .word 0xc76ce040
	 .word 0xc19ce140

	 .word 0xe1bcde20
	 .word 0xe1bcde20

	 .word 0xf244e004
	 .word 0xe19ce300

	 .word 0xf5f4e000
	 .word 0xc1bcde20

	 .word 0xe1bcdf20
	 .word 0xe19ce340

	 .word 0xf6ace013
	 .word 0xe19cdf00

	 .word 0xfa7cc000
	 .word 0xc19cde20

	 .word 0xd324e030
	 .word 0xe1bcdf20

	 .word 0xea44e004
	 .word 0xc1bce140

	 .word 0xf2ece033
	 .word 0xe1bcdf20

	 .word 0x8143c000
	 .word 0xe19ce040

	 .word 0xe56cc000
	 .word 0xe19ce340

	 .word 0x8143c000
	 .word 0xe19cde00

	 .word 0xf2d4de20
	 .word 0xc19ce080

	 .word 0xc1bcde20
	 .word 0xc19cde20

	 .word 0xfa54c000
	 .word 0xe1bcde00

	 .word 0x8143c000
	 .word 0xe19cde00

	 .word 0xc724c000
	 .word 0xe19cde20

	 .word 0xede4df00
	 .word 0xc19ce180

	 .word 0xeafce004
	 .word 0xe19cdf20

	 .word 0xf8acde20
	 .word 0xc19cde20

	 .word 0xf9f4e000
	 .word 0xe1bcde00

	 .word 0xdb6cc000
	 .word 0xe1bcdf00

	 .word 0xf0ecde00
	 .word 0xc1bce200

	 .word 0xf46cc000
	 .word 0xe19ce300

	 .word 0xf7e4df20
	 .word 0xe1bce340

	 .word 0xf424e000
	 .word 0xc19cde20

	 .word 0xebe4df00
	 .word 0xc1bcdf00

	 .word 0xf414c000
	 .word 0xc1bcde00

	 .word 0xf1e4df00
	 .word 0xc1bcdf00

	 .word 0xf66ce01d
	 .word 0xe19cde20

	 .word 0xf4ecdf00
	 .word 0xe1bcdf00

	 .word 0xf1f4df00
	 .word 0xc1bcdf00

	 .word 0xf9e4df20
	 .word 0xe19cdf20

	 .word 0xf1f4e000
	 .word 0xe19cde20

	 .word 0xfac4e004
	 .word 0xe19cdf00

	 .word 0x8143c000
	 .word 0xc1bce080

	 .word 0xe1bce100
	 .word 0xc19cde20

	 .word 0xc3ece030
	 .word 0xe1bce200

	 .word 0xf7f4e000
	 .word 0xc1bce0c0

	 .word 0xecbcdf20
	 .word 0xc1bcdf20

	 .word 0xf4ecdf20
	 .word 0xc19cdf20

	 .word 0xf9f4e000
	 .word 0xc19ce040

	 .word 0xe1bce3c0
	 .word 0xc1bce200

	 .word 0xc704c000
	 .word 0xe1bcdf00

	 .word 0xee34c000
	 .word 0xe19cde00

	 .word 0xe19ce140
	 .word 0xe1bcde20

	 .word 0xf87ce004
	 .word 0xe19cde00

	 .word 0xe1bce280
	 .word 0xc19cde20

	 .word 0xf82cc000
	 .word 0xc19cdf20

	 .word 0xc1bcde00
	 .word 0xc19ce1c0

	 .word 0xc304c000
	 .word 0xc1bcdf00

	 .word 0xf0a4e004
	 .word 0xe1bce3c0

	 .word 0xea44c000
	 .word 0xe19ce240

	 .word 0xede4de20
	 .word 0xe19ce200

	 .word 0xe19ce3c0
	 .word 0xc19cde20

	 .word 0xf5f4e000
	 .word 0xe19cdf20

	 .word 0xefe4de00
	 .word 0xe1bcde00

	 .word 0xe56ce020
	 .word 0xc1bcde00

	 .word 0xec3ce010
	 .word 0xc19ce100

	 .word 0xf86ce007
	 .word 0xc19ce1c0

	 .word 0x81dcc000
	 .word 0xc19cdf20

	 .word 0xee6cc000
	 .word 0xc19cde00

	 .word 0xf5e4e000
	 .word 0xe1bcde20

	 .word 0xf7f4df20
	 .word 0xe1bcdf20

	 .word 0xfab4df20
	 .word 0xc1bce180

	 .word 0x8143e04d
	 .word 0xe1bce300

	 .word 0xf4ece015
	 .word 0xe19cdf20

	 .word 0xf9e4e000
	 .word 0xc1bce140

	 .word 0x81dce0f3
	 .word 0xe19cdf00

	 .word 0xc11ce000
	 .word 0xe19ce1c0

	 .word 0xf3f4de00
	 .word 0xc1bce100

	 .word 0xe19cde20
	 .word 0xe1bcde20

	 .word 0xf07ce004
	 .word 0xc1bce100

	 .word 0x81dce0bd
	 .word 0xc1bce280

	 .word 0xf6fcde00
	 .word 0xc19ce040

	 .word 0xfb6ce060
	 .word 0xc19ce140

	 .word 0xf9f4de00
	 .word 0xc19cde00

	 .word 0xf8b4e000
	 .word 0xc19cdf00

	 .word 0xf4fce004
	 .word 0xc19cdf00

	 .word 0xc104e018
	 .word 0xc19cde00

	 .word 0xc1bcde20
	 .word 0xe1bce100

	 .word 0xea0ce01f
	 .word 0xc19ce340

	 .word 0x8143c000
	 .word 0xc1bce1c0

	 .word 0xc19cde20
	 .word 0xc19cde20

	 .word 0xf5e4df00
	 .word 0xe19cdf00

	 .word 0xf3f4de00
	 .word 0xc1bcde00

	 .word 0xf9e4de00
	 .word 0xc19ce040

	 .word 0xe1bce0c0
	 .word 0xe19ce280

	 .word 0xf7e4df00
	 .word 0xc19cdf00

	 .word 0xf27ce000
	 .word 0xc1bce3c0

	 .word 0xecbce000
	 .word 0xc19ce3c0

	 .word 0xc51cc000
	 .word 0xc1bcde20

	 .word 0xc19ce0c0
	 .word 0xe1bce2c0

	 .word 0xc104e02e
	 .word 0xe19ce200

	 .word 0xf024e000
	 .word 0xe19cde00

	 .word 0xeaece03f
	 .word 0xe19ce340

	 .word 0xf87cc000
	 .word 0xe19ce240

	 .word 0xf8ecde20
	 .word 0xc1bcde20

	 .word 0xf824e000
	 .word 0xe1bce3c0

	 .word 0xecfce004
	 .word 0xc19cdf00

	 .word 0xebe4de20
	 .word 0xe1bce3c0

	 .word 0xf5f4e000
	 .word 0xc19ce100

	 .word 0xf45cc000
	 .word 0xe19cde00

	 .word 0x8143e001
	 .word 0xc1bcde00

	 .word 0xd104c000
	 .word 0xc19ce340

	 .word 0xec9cde20
	 .word 0xe1bcde20

	 .word 0xc104e03c
	 .word 0xc1bce080

	 .word 0xeefcde00
	 .word 0xe1bce000

	 .word 0xd96ce0a0
	 .word 0xe1bcde20

	 .word 0xeafce004
	 .word 0xe19cdf20

	 .word 0xecbcde20
	 .word 0xc1bce300

	 .word 0xc93ce000
	 .word 0xe19ce300

	 .word 0xf054c000
	 .word 0xc19cdf20

	 .word 0xf66ce01a
	 .word 0xe1bce240

	 .word 0x81dcc000
	 .word 0xe1bcde00

	 .word 0xf5f4e000
	 .word 0xe1bcde00

	 .word 0xdd24e014
	 .word 0xc19ce380

	 .word 0xe19ce180
	 .word 0xc1bce000

	 .word 0xf0fcde00
	 .word 0xe1bce2c0

	 .word 0xe19ce280
	 .word 0xe1bcde20

	 .word 0xf9e4df00
	 .word 0xe19cdf00

	 .word 0xf2fce000
	 .word 0xe1bcde20

	 .word 0xeeece010
	 .word 0xc1bce000

	 .word 0x81dcc000
	 .word 0xe19cdf20

	 .word 0xc11ce000
	 .word 0xe1bce240

	 .word 0xdd24e030
	 .word 0xe19cde20

	 .word 0xee34e000
	 .word 0xc19ce1c0

	 .word 0xecbce010
	 .word 0xc19ce200

	 .word 0xcf04c000
	 .word 0xe19ce200

	 .word 0xf0fcde00
	 .word 0xc19cde00

	 .word 0xc19ce100
	 .word 0xe19ce180

	 .word 0xf6ece023
	 .word 0xc19ce380

	 .word 0xf6ecde00
	 .word 0xc19cde00

	 .word 0xecece020
	 .word 0xc1bcdf00

	 .word 0xea6cc000
	 .word 0xc1bce2c0

	 .word 0xf07ce000
	 .word 0xc1bce240

	 .word 0xf624e004
	 .word 0xe19ce2c0

	 .word 0xc1bce0c0
	 .word 0xe19ce100

	 .word 0xe7ece0e0
	 .word 0xc19ce1c0

	 .word 0xf684e004
	 .word 0xc1bcde00

	 .word 0xec8ce018
	 .word 0xc19ce100

	 .word 0xdf24e02c
	 .word 0xe1bce1c0

	 .word 0xf644e000
	 .word 0xc1bcde00

	 .word 0x81dce013
	 .word 0xc1bce300

	 .word 0xecbce000
	 .word 0xe1bcde00

	 .word 0xcd24c000
	 .word 0xc1bcde20

	 .word 0xec1ce000
	 .word 0xe1bcde20

	 .word 0xc93ce030
	 .word 0xc1bcdf20

	 .word 0xf9f4e000
	 .word 0xc19cde20

	 .word 0xf04ce017
	 .word 0xc19ce1c0

	 .word 0xeff4df00
	 .word 0xe1bce100

	 .word 0xecacdf00
	 .word 0xc1bce000

	 .word 0xeafce000
	 .word 0xe19ce3c0

	 .word 0xf3e4de20
	 .word 0xc19cde20

	 .word 0xee84df00
	 .word 0xc19ce340

	 .word 0xd13ce030
	 .word 0xe19ce080

	 .word 0xf604e000
	 .word 0xe1bce200

	 .word 0xc11ce010
	 .word 0xc19cdf20

	 .word 0xc19cde20
	 .word 0xe19cde20

	 .word 0x8143c000
	 .word 0xe19ce080

	 .word 0xf07cc000
	 .word 0xe1bce080

	 .word 0xf3f4df00
	 .word 0xc19ce040

	 .word 0xf4fce004
	 .word 0xc19ce2c0

	 .word 0xf8ece02f
	 .word 0xc19ce1c0

	 .word 0xf4ace03d
	 .word 0xc19ce1c0

	 .word 0xedf4e000
	 .word 0xe19ce200

	 .word 0xedf4e000
	 .word 0xe1bce240

	 .word 0xe9ecdf00
	 .word 0xe1bcdf00

	 .word 0xf4f4de20
	 .word 0xc1bce080

	 .word 0xf86cc000
	 .word 0xe19cdf00

	 .word 0xdd3cc000
	 .word 0xc19ce240

	 .word 0xf86ce011
	 .word 0xc19cde20

	 .word 0xeff4e000
	 .word 0xc1bce200

	 .word 0xf3f4de00
	 .word 0xe19cde00

	 .word 0xf8fce000
	 .word 0xc19ce340

	 .word 0xf67cc000
	 .word 0xe1bcdf00

	 .word 0xf5f4e000
	 .word 0xe1bce100

	 .word 0xc1bce240
	 .word 0xe19ce240

	 .word 0xe1bce040
	 .word 0xc19ce1c0

	 .word 0xc104e036
	 .word 0xc1bcdf00

	 .word 0xe19cde20
	 .word 0xc1bce180

	 .word 0xecd4de20
	 .word 0xe19cde20

	 .word 0xf86ce03d
	 .word 0xc19cde00

	 .word 0xc704c000
	 .word 0xe1bcdf20

	 .word 0xfa2ce030
	 .word 0xe19ce140

	 .word 0xc56ce070
	 .word 0xc1bcdf20

	 .word 0xf47ce004
	 .word 0xe19cde00

	 .word 0xf00cc000
	 .word 0xc19cdf00

	 .word 0xf6ecdf00
	 .word 0xc1bce000

	 .word 0xf5e4de00
	 .word 0xc19ce100

	 .word 0xfa4ce03a
	 .word 0xe1bce2c0

	 .word 0xf244c000
	 .word 0xe19ce200

	 .word 0xf6ece025
	 .word 0xc19cde20

	 .word 0xc19cde00
	 .word 0xc1bce0c0

	 .word 0xf4fce004
	 .word 0xc19cde20

	 .word 0xdd24e03c
	 .word 0xc1bcde00

	 .word 0xf054c000
	 .word 0xc1bcdf20

	 .word 0xe19ce3c0
	 .word 0xc1bcde20

	 .word 0xe1bcde20
	 .word 0xe19ce100

	 .word 0xc1bce080
	 .word 0xe19ce340

	 .word 0xf4c4de20
	 .word 0xe1bcde20

	 .word 0xc524e004
	 .word 0xc1bce040

	 .word 0xc11ce020
	 .word 0xc1bcdf20

	 .word 0xeaacdf00
	 .word 0xe19ce2c0

	 .word 0xf3e4e000
	 .word 0xe19cde00

	 .word 0xf26ce003
	 .word 0xe19ce140

	 .word 0xf46cc000
	 .word 0xe19ce1c0

	 .word 0xeafcde00
	 .word 0xc1bcde00

	 .word 0xc5ece0a0
	 .word 0xc19ce280

	 .word 0xf47cc000
	 .word 0xc1bce180

	 .word 0xdd24c000
	 .word 0xe19cdf20

	 .word 0xfaacdf00
	 .word 0xe19cdf00

	 .word 0xe19ce380
	 .word 0xe19ce300

	 .word 0xf24cc000
	 .word 0xe1bcdf00

	 .word 0xfadcdf00
	 .word 0xe1bce140

	 .word 0xc19cde20
	 .word 0xe1bcde20

	 .word 0x8143c000
	 .word 0xc1bcdf00

	 .word 0xec9ce010
	 .word 0xc1bcde20

	 .word 0xf67ce004
	 .word 0xc19cde00

	 .word 0xc11ce030
	 .word 0xe1bce040

	 .word 0xeeacde00
	 .word 0xe1bcde00

	 .word 0xeafcdf00
	 .word 0xc19ce300

	 .word 0xecece032
	 .word 0xe19cdf00

	 .word 0xede4df00
	 .word 0xc1bce040

	 .word 0x8143e04c
	 .word 0xc1bce040

	 .word 0xdd1cc000
	 .word 0xc19ce300

	 .word 0xd524e004
	 .word 0xc19cde20

	 .word 0x8143e06e
	 .word 0xc1bce180

	 .word 0xc524c000
	 .word 0xc1bce240

	 .word 0xecbcdf20
	 .word 0xc1bcdf20

	 .word 0xfab4e002
	 .word 0xc19cde00

	 .word 0xee84df00
	 .word 0xc1bce340

	 .word 0xf6fcdf20
	 .word 0xc19ce100

	 .word 0xf7f4de00
	 .word 0xe19cde00

	 .word 0xcd24c000
	 .word 0xe1bce040

	 .word 0xf5e4e000
	 .word 0xc1bcde20

	 .word 0xecece01f
	 .word 0xe19cde20

	 .word 0xf27cc000
	 .word 0xe19ce0c0

	 .word 0xd93cc000
	 .word 0xc1bcdf00

	 .word 0xec9cde00
	 .word 0xc19cde00

	 .word 0xc56ce020
	 .word 0xe19ce100

	 .word 0xec1ce000
	 .word 0xc1bce0c0

	 .word 0xe19ce140
	 .word 0xc19cdf00

	 .word 0x8143c000
	 .word 0xe19ce100

	 .word 0xecb4e002
	 .word 0xe19ce280

	 .word 0xd13cc000
	 .word 0xc19cde00

	 .word 0xf3f4e000
	 .word 0xe1bce000

	 .word 0xede4e000
	 .word 0xc19ce240

	 .word 0x81dcc000
	 .word 0xe1bcdf20

	 .word 0xf2b4df00
	 .word 0xe1bcdf00

	 .word 0xf27ce004
	 .word 0xe19cde20

	 .word 0xc19cdf20
	 .word 0xe19cdf20

	 .word 0xeaece023
	 .word 0xe19ce340

	 .word 0x8143c000
	 .word 0xe1bcde20

	 .word 0xf2ecde20
	 .word 0xe19ce140

	 .word 0xfa7cc000
	 .word 0xc1bcde00

	 .word 0xf24cc000
	 .word 0xe19ce040

	 .word 0xf654e000
	 .word 0xe1bce200

	 .word 0xe19cdf20
	 .word 0xe1bcdf20

	 .word 0xe124c000
	 .word 0xe1bce300

	 .word 0xec3cc000
	 .word 0xc1bcdf20

	 .word 0xc76cc000
	 .word 0xe19ce300

	 .word 0xf694de00
	 .word 0xc19cde00

	 .word 0xc1bcdf20
	 .word 0xe19ce0c0

	 .word 0xf6c4de00
	 .word 0xe19cde00

	 .word 0xc1bcde00
	 .word 0xe19ce300

	 .word 0xf2cce021
	 .word 0xe19cde00

	 .word 0xf204c000
	 .word 0xc19cdf20

	 .word 0xfa7cc000
	 .word 0xc1bcde00

	 .word 0xe1bce2c0
	 .word 0xc1bce2c0

	 .word 0xf6dcde20
	 .word 0xe1bce100

	 .word 0xea7cc000
	 .word 0xe19ce200

	 .word 0xeaa4e004
	 .word 0xe1bce1c0

	 .word 0xc1bcdf20
	 .word 0xe19cdf20

	 .word 0x8143e014
	 .word 0xc19cdf20

	 .word 0x8143e05d
	 .word 0xc1bce3c0

	 .word 0xf474c000
	 .word 0xe1bce080

	 .word 0xf3e4de20
	 .word 0xe1bce2c0

	 .word 0x8143e054
	 .word 0xe19ce380

	 .word 0xf674e000
	 .word 0xe19ce080

	 .word 0xea6ce013
	 .word 0xc1bcde00

	 .word 0xf88ce006
	 .word 0xc1bce2c0

	 .word 0xf9f4de20
	 .word 0xc19cde20

	 .word 0xe124c000
	 .word 0xc19ce280

	 .word 0x8143e06e
	 .word 0xc1bce200

	 .word 0xf8ecde00
	 .word 0xe19cde00

	 .word 0xf0b4e000
	 .word 0xe1bcde00

	 .word 0xf8ccde00
	 .word 0xc1bce000

	 .word 0xc5ecde20
	 .word 0xe19cde20

	 .word 0xecf4df00
	 .word 0xc1bcdf00

	 .word 0xe19cdf20
	 .word 0xe19cdf20

	 .word 0xf0fcdf20
	 .word 0xe19ce1c0

	 .word 0xd124e038
	 .word 0xc19ce1c0

	 .word 0xf4b4e002
	 .word 0xc19cdf00

	 .word 0xeefce004
	 .word 0xc1bcde20

	 .word 0xea7ce000
	 .word 0xc19ce380

	 .word 0xfa34c000
	 .word 0xc19cde20

	 .word 0xec6ce005
	 .word 0xe1bcdf20

	 .word 0xc96cc000
	 .word 0xc19cde00

	 .word 0xdf24e010
	 .word 0xc1bcdf20

	 .word 0xc19ce140
	 .word 0xe19ce100

	 .word 0xecfce004
	 .word 0xe1bcdf00

	 .word 0xc1bce040
	 .word 0xc19cde00

	 .word 0xee7cc000
	 .word 0xe1bcdf00

	 .word 0xf0a4e000
	 .word 0xc1bce380

	 .word 0xf2acdf20
	 .word 0xc19ce3c0

	 .word 0xd53ce010
	 .word 0xe1bce100

	 .word 0xdb6ce060
	 .word 0xe1bce380

	 .word 0xc53ce010
	 .word 0xc1bce000

	 .word 0xeafcdf00
	 .word 0xe19cdf00

	 .word 0xf644e000
	 .word 0xc19cdf20

	 .word 0xcb24e034
	 .word 0xe19ce380

	 .word 0xf22cc000
	 .word 0xc1bcdf20

	 .word 0xf4f4de20
	 .word 0xe19cde20

	 .word 0xf46ce03c
	 .word 0xe1bcde20

	 .word 0xf85cc000
	 .word 0xc1bcdf00

	 .word 0xf234c000
	 .word 0xe19cde00

	 .word 0xf8acdf00
	 .word 0xe1bcdf00

	 .word 0xc19cdf20
	 .word 0xe19cdf20

	 .word 0xeeecde00
	 .word 0xc19cde00

	 .word 0xf6b4df00
	 .word 0xc1bcdf00

	 .word 0xf4ecdf20
	 .word 0xe19ce300

	 .word 0xe1bce240
	 .word 0xe1bce080

	 .word 0xc104e028
	 .word 0xc1bce340

	 .word 0xf6ece01d
	 .word 0xc19ce1c0

	 .word 0xfa84e004
	 .word 0xc1bcdf00

	 .word 0xd1ece0a0
	 .word 0xe19ce340

	 .word 0xe19cde20
	 .word 0xe19ce140

	 .word 0xc13ce030
	 .word 0xe19ce100

	 .word 0xf2acde00
	 .word 0xe19cde00

	 .word 0xf0fce000
	 .word 0xc19cdf00

	 .word 0xec6cc000
	 .word 0xe1bcde00

	 .word 0xececde00
	 .word 0xe19cde00

	 .word 0x81dcc000
	 .word 0xe19cde00

	 .word 0xf5e4df20
	 .word 0xc1bce300

	 .word 0xee94e002
	 .word 0xe19cdf20

	 .word 0xf2fcde20
	 .word 0xc1bcde20

	 .word 0xc11ce030
	 .word 0xe1bcde20

	 .word 0xec6ce008
	 .word 0xc19cde00

	 .word 0xeff4e000
	 .word 0xc19cde00

	 .word 0xeaecdf00
	 .word 0xe1bce100

	 .word 0xea4cc000
	 .word 0xc1bcde00

	 .word 0xec3ce010
	 .word 0xe1bcdf20

	 .word 0x8143e059
	 .word 0xc1bcde00

	 .word 0xfaf4e000
	 .word 0xe1bcdf20

	 .word 0xf4ecdf00
	 .word 0xe19ce300

	 .word 0xc1bcde20
	 .word 0xc19ce0c0

	 .word 0xc1ecde20
	 .word 0xe19cde20

	 .word 0xee6cc000
	 .word 0xe19cdf20

	 .word 0xc3ece0e0
	 .word 0xe1bcde00

	 .word 0xf274e008
	 .word 0xe19cdf20

	 .word 0xf8d4e000
	 .word 0xe1bce200

	 .word 0xfa7cc000
	 .word 0xe1bce2c0

	 .word 0xec84e004
	 .word 0xe1bce180

	 .word 0xf3e4df00
	 .word 0xc1bce240

	 .word 0xd324e02c
	 .word 0xe1bce180

	 .word 0x81dcc000
	 .word 0xe1bce100

	 .word 0xc724c000
	 .word 0xe19ce2c0

	 .word 0xecd4de00
	 .word 0xe19ce340

	 .word 0xea74e000
	 .word 0xc19cde00

	 .word 0xedece0b0
	 .word 0xc1bcde20

	 .word 0xc93cc000
	 .word 0xc1bce080

	 .word 0xf07ce000
	 .word 0xc19cde00

	 .word 0xefe4de20
	 .word 0xe1bcde20

	 .word 0xf5f4e000
	 .word 0xe19ce200

	 .word 0xea84de00
	 .word 0xe19ce0c0

	 .word 0xeaece024
	 .word 0xe1bcde00

	 .word 0xf86cc000
	 .word 0xe1bce300

	 .word 0xc19cde00
	 .word 0xe19cde00

	 .word 0xec9cde00
	 .word 0xe19ce180

	 .word 0xedecde00
	 .word 0xe1bcde00

	 .word 0xc76ce0f0
	 .word 0xc19ce3c0

	 .word 0x81dce044
	 .word 0xc19ce040

	 .word 0xf86ce015
	 .word 0xc19ce300

	 .word 0xf054e000
	 .word 0xc19cde20

	 .word 0x8143c000
	 .word 0xe19ce240

	 .word 0xeff4de20
	 .word 0xc1bce040

	 .word 0xec7ce000
	 .word 0xe1bcde00

	 .word 0xf46cc000
	 .word 0xe1bcdf20

	 .word 0xecbcdf00
	 .word 0xc19ce380

	 .word 0xf1e4e000
	 .word 0xc1bce340

	 .word 0xc76cc000
	 .word 0xe19ce0c0

	 .word 0x8143c000
	 .word 0xc19cde20

	 .word 0xf5e4de20
	 .word 0xc19ce3c0

	 .word 0xf67ce004
	 .word 0xc1bce1c0

	 .word 0xf87cc000
	 .word 0xe1bce000

	 .word 0xd11cc000
	 .word 0xe19ce240

	 .word 0xf8fce000
	 .word 0xc19ce040

	 .word 0xec3ce010
	 .word 0xc19cde00

	 .word 0x81dce007
	 .word 0xe1bce180

	 .word 0x8143c000
	 .word 0xe19ce3c0

	 .word 0xeaa4df20
	 .word 0xe1bcdf20

	 .word 0x8143e00d
	 .word 0xe1bcde00

	 .word 0xf844c000
	 .word 0xe19ce2c0

	 .word 0xec24c000
	 .word 0xe1bcde00

	 .word 0xc11ce010
	 .word 0xc19ce3c0

	 .word 0xc1bcde00
	 .word 0xe1bce180

	 .word 0xf1f4de20
	 .word 0xc19cde20

	 .word 0xc19cdf00
	 .word 0xc1bce3c0

	 .word 0xf244e004
	 .word 0xe19cdf00

	 .word 0xf0ece020
	 .word 0xc1bcdf00

	 .word 0xdd3cc000
	 .word 0xe19cdf20

	 .word 0xeff4e000
	 .word 0xc19cdf00

	 .word 0xc5ecde00
	 .word 0xc1bce280

	 .word 0xffece060
	 .word 0xc1bce000

	 .word 0xf6ece02d
	 .word 0xe19cdf20

	 .word 0xf40ce002
	 .word 0xe19ce1c0

	 .word 0xead4e002
	 .word 0xe19cdf20

	 .word 0xf4ece016
	 .word 0xc1bcde00

	 .word 0xf02cc000
	 .word 0xe1bce240

	 .word 0xf27cc000
	 .word 0xc1bce040

	 .word 0xe19cdf00
	 .word 0xc19ce100

	 .word 0xc1bce000
	 .word 0xc1bce180

	 .word 0xf9e4e000
	 .word 0xe19cdf20

	 .word 0xdf24c000
	 .word 0xe19ce100

	 .word 0xc19cde20
	 .word 0xc1bcde20

	 .word 0xf8ecdf20
	 .word 0xc19ce1c0

	 .word 0xecbcdf00
	 .word 0xe19cdf00

	 .word 0xeff4e000
	 .word 0xc19ce040

	 .word 0xf9e4e000
	 .word 0xe19ce180

	 .word 0xee8cde20
	 .word 0xc1bcde20

	 .word 0xeefce004
	 .word 0xe1bcdf00

	 .word 0xebf4e000
	 .word 0xc1bcdf00

	 .word 0xeaa4e000
	 .word 0xe1bce3c0

	 .word 0xee0cc000
	 .word 0xc1bce3c0

	 .word 0xc3ece090
	 .word 0xc1bcdf00

	 .word 0xf44ce02a
	 .word 0xe19cdf00

	 .word 0xf26ce014
	 .word 0xc19ce280

	 .word 0xec2ce021
	 .word 0xc19cdf20

	 .word 0xe1bce100
	 .word 0xe1bce040

	 .word 0xf6fcde20
	 .word 0xc19ce180

	 .word 0xf44cc000
	 .word 0xe19cde00

	 .word 0xf1e4de00
	 .word 0xc1bce280

	 .word 0xea0cc000
	 .word 0xe19cde20

	 .word 0xf86ce017
	 .word 0xc19cdf20

	 .word 0xef6cc000
	 .word 0xe1bcde00

	 .word 0x81dcc000
	 .word 0xe19cdf00

	 .word 0xe5ece0e0
	 .word 0xe19cdf20

	 .word 0xc1bce140
	 .word 0xc19ce080

	 .word 0xe19cdf20
	 .word 0xe19cdf20

	 .word 0xc51cc000
	 .word 0xc1bce100

	 .word 0xf9f4e000
	 .word 0xe19ce040

	 .word 0xee04e004
	 .word 0xe1bcde00

	 .word 0xf9f4df20
	 .word 0xe19cdf20

	 .word 0xecace00b
	 .word 0xc19cde00

	 .word 0xd924c000
	 .word 0xc1bcdf20

	 .word 0xf2ece006
	 .word 0xe19ce000

	 .word 0xf8c4e000
	 .word 0xe1bce100

	 .word 0xec6cc000
	 .word 0xe19ce1c0

	 .word 0x8143e057
	 .word 0xe1bce140

	 .word 0xc1bce240
	 .word 0xe19ce380

	 .word 0xec3ce000
	 .word 0xc1bce300

	 .word 0xe9ece0c0
	 .word 0xe19ce380

	 .word 0xee7ce004
	 .word 0xc1bcdf20

	 .word 0xc11ce020
	 .word 0xe19ce280

	 .word 0xfab4de20
	 .word 0xc1bcde20

	 .word 0xf2f4e008
	 .word 0xe1bcde00

	 .word 0xc91cc000
	 .word 0xc1bcdf00

	 .word 0xe1bce300
	 .word 0xe19cde20

	 .word 0xcd24c000
	 .word 0xe19ce000

	 .word 0xec3cc000
	 .word 0xe1bce3c0

	 .word 0xf66ce03f
	 .word 0xc1bce080

	 .word 0xee84e000
	 .word 0xc1bce2c0

	 .word 0x8143e04d
	 .word 0xe1bce340

	 .word 0xee24c000
	 .word 0xc1bcde20

	 .word 0xf014c000
	 .word 0xc19ce100

	 .word 0xec7ce000
	 .word 0xc1bcdf20

	 .word 0xf8ace01c
	 .word 0xc1bcdf20

	 .word 0xec0ce026
	 .word 0xc19ce300

	 .word 0xe19cde00
	 .word 0xe1bce380

	 .word 0xc104e008
	 .word 0xc19cde00

	 .word 0x8143e040
	 .word 0xe1bce140

	 .word 0xec44e000
	 .word 0xe19ce380

	 .word 0xeeecdf00
	 .word 0xe1bce180

	 .word 0xf2ecde20
	 .word 0xc1bcde20

	 .word 0x8143e008
	 .word 0xe19cdf00

	 .word 0xf604c000
	 .word 0xc1bcde20

	 .word 0xf04cc000
	 .word 0xe19cdf00

	 .word 0xc104e00e
	 .word 0xc1bcde20

	 .word 0xec3cc000
	 .word 0xe19ce1c0

	 .word 0xea4ce001
	 .word 0xe19ce2c0

	 .word 0xe19cdf00
	 .word 0xe19cdf00

	 .word 0xecbce010
	 .word 0xe19cdf00

	 .word 0xf27cc000
	 .word 0xc19ce240

	 .word 0xf4fce000
	 .word 0xe1bce380

	 .word 0xebf4df00
	 .word 0xe1bce040

	 .word 0xfafce000
	 .word 0xc19cdf20

	 .word 0xc19ce0c0
	 .word 0xe19cde20

	 .word 0xee24e004
	 .word 0xc19cdf00

	 .word 0xf8ece034
	 .word 0xc19ce100

	 .word 0x81dce0f8
	 .word 0xc19cdf20

	 .word 0xc11ce020
	 .word 0xc19ce100

	 .word 0xd704c000
	 .word 0xc1bce000

	 .word 0xf1f4df20
	 .word 0xe19cdf20

	 .word 0xc9ece080
	 .word 0xc1bce280

	 .word 0xeafcdf20
	 .word 0xc19cdf20

	 .word 0xf5e4e000
	 .word 0xc19cde20

	 .word 0xf44ce022
	 .word 0xc1bcde20

	 .word 0x8143c000
	 .word 0xc1bcdf00

	 .word 0xf27cc000
	 .word 0xe19cde00

	 .word 0xea5cc000
	 .word 0xe19cdf20

	 .word 0xc5ece0d0
	 .word 0xe1bce280

	 .word 0xec2cc000
	 .word 0xe19cdf00

	 .word 0xc16ce0b0
	 .word 0xc1bcde00

	 .word 0xe1bce340
	 .word 0xe19cdf20

	 .word 0xf1f4e000
	 .word 0xe1bce200

	 .word 0xf86ce028
	 .word 0xe1bcde20

	 .word 0xebf4df20
	 .word 0xe1bcdf20

	 .word 0x81dcc000
	 .word 0xc1bce2c0

	 .word 0x8143e04c
	 .word 0xc1bcdf00

	 .word 0x8143c000
	 .word 0xc1bce380

	 .word 0xf7e4df20
	 .word 0xe1bce080

	 .word 0xcb24c000
	 .word 0xe19ce2c0

	 .word 0x8143e021
	 .word 0xe19cdf00

	 .word 0xeeace01a
	 .word 0xe19cde20

	 .word 0xf7f4e000
	 .word 0xe1bce3c0

	 .word 0xc1bce100
	 .word 0xe1bce280

	 .word 0xe1bcdf00
	 .word 0xc19cdf00

	 .word 0xf7f4e000
	 .word 0xe1bcdf00

	 .word 0x8143e041
	 .word 0xc1bce2c0

	 .word 0xf9f4e000
	 .word 0xc19cdf00

	 .word 0xf6f4de00
	 .word 0xc1bcde00

	 .word 0xea7cc000
	 .word 0xe1bce380

	 .word 0xec9ce010
	 .word 0xe19cde00

	 .word 0xedf4df20
	 .word 0xc1bcdf20

	 .word 0xeab4e002
	 .word 0xe19ce140

	 .word 0xf0fcdf00
	 .word 0xe1bcdf00

	 .word 0xf8dcde20
	 .word 0xc19ce180

	 .word 0xf26ce008
	 .word 0xe19cde20

	 .word 0xfaf4e000
	 .word 0xc1bcdf20

	 .word 0xf2ecdf00
	 .word 0xe19ce0c0

	 .word 0xf5f4de20
	 .word 0xe1bcde20

	 .word 0xe1bce200
	 .word 0xe1bce0c0

	 .word 0xf8a4e000
	 .word 0xc19cde20

	 .word 0xd724e000
	 .word 0xe19cdf20

	 .word 0x81dcc000
	 .word 0xe1bce3c0

	 .word 0xf3f4de20
	 .word 0xc1bce0c0

	 .word 0xc1bcde20
	 .word 0xe19ce240

	 .word 0xc3ece000
	 .word 0xc1bce140

	 .word 0xf0ece014
	 .word 0xc19ce040

	 .word 0xc36ce0d0
	 .word 0xe19cde00

	 .word 0xec9cde20
	 .word 0xc1bce3c0

	 .word 0xf9f4de20
	 .word 0xe1bce040

	 .word 0xecbcde20
	 .word 0xc19cde20

	 .word 0x8143c000
	 .word 0xc19ce200

	 .word 0xc3ece050
	 .word 0xc1bcde20

	 .word 0xc11ce030
	 .word 0xe19ce2c0

	 .word 0xf8fce004
	 .word 0xc1bce380

	 .word 0xf1e4e000
	 .word 0xc1bcdf00

	 .word 0xe1bcdf20
	 .word 0xc19ce240

	 .word 0xc104e02a
	 .word 0xc1bcde20

	 .word 0xc1bce300
	 .word 0xe1bce140

	 .word 0xf6ece005
	 .word 0xe1bce040

	 .word 0xfaacde20
	 .word 0xe19cde20

	 .word 0xf46cc000
	 .word 0xc1bce200

	 .word 0xecbcde00
	 .word 0xc1bcde00

	 .word 0xecfce004
	 .word 0xe19cde00

	 .word 0xdd1cc000
	 .word 0xe19cdf20

	 .word 0x8143c000
	 .word 0xc19ce140

	 .word 0xf3e4e000
	 .word 0xc19cde20

	 .word 0xc1bcde00
	 .word 0xe1bce080

	 .word 0xfafcde20
	 .word 0xc19cde20

	 .word 0xecece018
	 .word 0xe1bcdf20

	 .word 0xc11ce030
	 .word 0xe1bcdf20

	 .word 0xf004e000
	 .word 0xc19ce040

	 .word 0xeefcdf00
	 .word 0xe1bce180

	 .word 0xc19cde00
	 .word 0xc19cde00

	 .word 0xc1bce3c0
	 .word 0xc19ce0c0

	 .word 0xf3f4df20
	 .word 0xe19cdf20

	 .word 0xc9ece0e0
	 .word 0xc1bcde20

	 .word 0xf0ecde20
	 .word 0xc19ce040

	 .word 0xf7f4de20
	 .word 0xc1bce240

	 .word 0x8143c000
	 .word 0xe1bce080

	 .word 0xf6fcde20
	 .word 0xe1bcde20

	 .word 0xc11cc000
	 .word 0xc1bcde20

	 .word 0xd504c000
	 .word 0xe1bcdf20

	 .word 0xc11ce030
	 .word 0xe19cdf20

	 .word 0xc1bce300
	 .word 0xe1bce300

	 .word 0xe56cc000
	 .word 0xc1bce180

	 .word 0xe1bcde00
	 .word 0xc1bce280

	 .word 0x8143e01a
	 .word 0xc19ce240

	 .word 0x81dce05c
	 .word 0xc19cde20

	 .word 0xc11cc000
	 .word 0xc19cdf20

	 .word 0xc504c000
	 .word 0xe1bce200

	 .word 0xc1bce300
	 .word 0xe1bcde00

	 .word 0xefe4e000
	 .word 0xc19ce000

	 .word 0xcd3ce000
	 .word 0xc1bcde00

	 .word 0xecece023
	 .word 0xe1bce280

	 .word 0xeeece01a
	 .word 0xc19cde00

	 .word 0xc924e034
	 .word 0xe19cdf20

	 .word 0x8143c000
	 .word 0xe19cde00

	 .word 0xea7cc000
	 .word 0xc1bce180

	 .word 0xf87ce000
	 .word 0xe1bcde20

	 .word 0xec1cc000
	 .word 0xc1bce140

	 .word 0xec6ce02f
	 .word 0xe1bce2c0

	 .word 0xec1ce010
	 .word 0xc19cde20

	 .word 0xf9f4df20
	 .word 0xc1bce080

	 .word 0xf674c000
	 .word 0xe19cde20

	 .word 0x8143c000
	 .word 0xc19cdf20

	 .word 0xec1ce010
	 .word 0xc19ce3c0

	 .word 0xe1bcde20
	 .word 0xe19ce140

	 .word 0xec24e004
	 .word 0xc1bcdf20

	 .word 0xec3ce010
	 .word 0xe1bcdf20

	 .word 0xc1bcde20
	 .word 0xc19ce200

	 .word 0xf5e4e000
	 .word 0xc1bcdf20

	 .word 0x81dcc000
	 .word 0xc1bcdf00

	 .word 0xedf4e000
	 .word 0xe19ce180

	 .word 0xc16cc000
	 .word 0xe1bcdf20

	 .word 0xf22ce039
	 .word 0xe19ce2c0

	 .word 0xf4fcde00
	 .word 0xe1bcde00

	 .word 0xeaf4df20
	 .word 0xc19ce200

	 .word 0xe19ce380
	 .word 0xc1bce100

	 .word 0xeeccde00
	 .word 0xe1bcde00

	 .word 0xf4ecde20
	 .word 0xe1bce040

	 .word 0xf9e4e000
	 .word 0xe1bce100

	 .word 0xeafce000
	 .word 0xc1bcde20

	 .word 0xf414c000
	 .word 0xc19cdf20

	 .word 0xcd3cc000
	 .word 0xe19cde20

	 .word 0xeafcde00
	 .word 0xc19ce1c0

	 .word 0xec9ce010
	 .word 0xe19ce180

	 .word 0xe1bce3c0
	 .word 0xe19ce0c0

	 .word 0xeeecde20
	 .word 0xe19ce300

	 .word 0xeeace005
	 .word 0xe19ce040

	 .word 0xf444e004
	 .word 0xc19cdf20

	 .word 0xc19cdf20
	 .word 0xc1bcdf20

	 .word 0xe19ce0c0
	 .word 0xc19ce000

	 .word 0xfa7cc000
	 .word 0xe1bce280

	 .word 0xcd24e038
	 .word 0xc1bce100

	 .word 0xc104e024
	 .word 0xc19ce180

	 .word 0xf044e004
	 .word 0xe19cde20

	 .word 0xcb04c000
	 .word 0xe1bcdf20

	 .word 0xf9f4de20
	 .word 0xc19cde20

	 .word 0xede4e000
	 .word 0xc1bcdf00

	 .word 0xc19ce0c0
	 .word 0xe1bcdf00

	 .word 0xf47ce000
	 .word 0xc19ce040

	 .word 0xf0ecde20
	 .word 0xc1bcde20

	 .word 0xec1cc000
	 .word 0xe1bcde20

	 .word 0xc19cdf20
	 .word 0xc1bce1c0

	 .word 0xf05cc000
	 .word 0xe1bce240

	 .word 0xe19ce380
	 .word 0xc19cdf00

	 .word 0xc11ce020
	 .word 0xc1bcde20

	 .word 0xf0ece021
	 .word 0xe1bcdf20

	 .word 0xf4ace034
	 .word 0xc1bce300

	 .word 0xececde00
	 .word 0xe1bce3c0

	 .word 0xc19ce0c0
	 .word 0xe19ce3c0

	 .word 0xf3e4de20
	 .word 0xc1bce000

	 .word 0xfa7ce004
	 .word 0xc19cdf20

	 .word 0xe19ce280
	 .word 0xe19ce080

	 .word 0xe19ce0c0
	 .word 0xc19ce340

	 .word 0xeefcdf00
	 .word 0xc1bce080

	 .word 0xe1bce300
	 .word 0xe1bcdf00

	 .word 0xf6fce000
	 .word 0xe1bce240

	 .word 0xd724e030
	 .word 0xc1bcdf20

	 .word 0xf624c000
	 .word 0xe1bce200

	 .word 0xea7ce004
	 .word 0xc1bcde20

	 .word 0xd13ce020
	 .word 0xe19ce000

	 .word 0xf46cc000
	 .word 0xe19cdf20

	 .word 0xc1bce140
	 .word 0xc1bce340

	 .word 0xd93ce020
	 .word 0xe19cde00

	 .word 0xf604e000
	 .word 0xc1bcdf20

	 .word 0xec6ce00a
	 .word 0xc19cde20

	 .word 0xf3e4e000
	 .word 0xc1bce3c0


	 ba diag_pass 
	 nop 
run_th_3:

	 wr %g0, 240, %asi

	 ta T_CHANGE_PRIV 
	 nop 
	 set 4057648752, %i0
	 set 2480881937, %i1
	 set 1524373685, %i2
	 set 3405372483, %i3
	 set 1361319160, %i4
	 set 336262609, %i5
	 set 4152375075, %i6
	 set 2157578442, %i7
	 set 738383589, %o0
	 set 692069556, %o1
	 set 343728157, %o2
	 set 3575269893, %o3
	 set 2111279648, %o4
	 set 585777648, %o5
	 set 717771523, %o6
	 set 1123606802, %o7
	 set 522162576, %l0
	 set 752521487, %l1
	 set 1948436374, %l2
	 set 2703713049, %l3
	 set 4221220780, %l4
	 set 1775263218, %l5
	 set 2717928617, %l6
	 set 2292466677, %l7
	 set 1315626578, %g0
	 set 3965534745, %g1
	 set 3215285783, %g2
	 set 508552986, %g3
	 set 1227415511, %g4
	 set 2003958306, %g5
	 set 60974583, %g6
	 set 1854364337, %g7

wr %g0, 0x4, %fprs 
	 setx self_modcode, %l0, %l3
	 ldd [%l3], %f0
	 add 0x8, %l3, %l3
	 ldd [%l3], %f2
	 add 0x8, %l3, %l3
	 ldd [%l3], %f4
	 add 0x8, %l3, %l3
	 ldd [%l3], %f6
	 add 0x8, %l3, %l3
	 ldd [%l3], %f8
	 add 0x8, %l3, %l3
	 ldd [%l3], %f10
	 add 0x8, %l3, %l3
	 ldd [%l3], %f12
	 add 0x8, %l3, %l3
	 ldd [%l3], %f14
	 add 0x8, %l3, %l3
	 ldd [%l3], %f16
	 add 0x8, %l3, %l3
	 ldd [%l3], %f18
	 add 0x8, %l3, %l3
	 ldd [%l3], %f20
	 add 0x8, %l3, %l3
	 ldd [%l3], %f22
	 add 0x8, %l3, %l3
	 ldd [%l3], %f24
	 add 0x8, %l3, %l3
	 ldd [%l3], %f26
	 add 0x8, %l3, %l3
	 ldd [%l3], %f28
	 add 0x8, %l3, %l3
	 ldd [%l3], %f30
	 add 0x8, %l3, %l3
	 ldd [%l3], %f32
	 add 0x8, %l3, %l3
	 ldd [%l3], %f34
	 add 0x8, %l3, %l3
	 ldd [%l3], %f36
	 add 0x8, %l3, %l3
	 ldd [%l3], %f38
	 add 0x8, %l3, %l3
	 ldd [%l3], %f40
	 add 0x8, %l3, %l3
	 ldd [%l3], %f42
	 add 0x8, %l3, %l3
	 ldd [%l3], %f44
	 add 0x8, %l3, %l3
	 ldd [%l3], %f46
	 add 0x8, %l3, %l3
	 ldd [%l3], %f48
	 add 0x8, %l3, %l3
	 ldd [%l3], %f50
	 add 0x8, %l3, %l3
	 ldd [%l3], %f52
	 add 0x8, %l3, %l3
	 ldd [%l3], %f54
	 add 0x8, %l3, %l3
	 ldd [%l3], %f56
	 add 0x8, %l3, %l3
	 ldd [%l3], %f58
	 add 0x8, %l3, %l3
	 ldd [%l3], %f60
	 add 0x8, %l3, %l3
	 ldd [%l3], %f62
	 add 0x8, %l3, %l3
	 setx data5, %l0, %l3
	 setx self_modcode, %l0, %l1
	 .word 0xc96ce000
	 .word 0xc5ece0a0
	 .word 0xc19ce340

	 .word 0xfac4e004
	 .word 0xc76ce0e0
	 .word 0xe1bcc580

	 .word 0xefe4c460
	 .word 0xcd6ce020
	 .word 0xe19ce2c0


.global invldic_0
 invldic_0:
	 mov 2, %l6; mov 0, %l7 
	setx invldic_0_lp, %l0, %l2
.align 0x10 
.global invldic_0_lp
invldic_0_lp:
	 nop
	 ld [%l1], %o2; st %o2, [%l2]
	 add %l1, 4, %l1
	 sub %l7, %l6, %o3; brlz %o3, invldic_0_lp; add %l7, 1, %l7

	 .word 0xf8fce000
	 .word 0xc96ce070
	 .word 0xe1bcd020

	 .word 0xc19cc440
	 .word 0xff6cc000
	 .word 0xe19ce0c0


.global invldic_1
 invldic_1:
	 mov 2, %l6; mov 0, %l7 
	setx invldic_1_lp, %l0, %l2
.align 0x10 
.global invldic_1_lp
invldic_1_lp:
	 nop
	 ld [%l1], %o2; st %o2, [%l2]
	 add %l1, 4, %l1
	 sub %l7, %l6, %o3; brlz %o3, invldic_1_lp; add %l7, 1, %l7

	 .word 0xf5f4e000
	 .word 0xc7ecc460
	 .word 0xe1bce100


.global invldic_2
 invldic_2:
	 mov 2, %l6; mov 0, %l7 
	setx invldic_2_lp, %l0, %l2
.align 0x10 
.global invldic_2_lp
invldic_2_lp:
	 nop
	 ld [%l1], %o2; st %o2, [%l2]
	 add %l1, 4, %l1
	 sub %l7, %l6, %o3; brlz %o3, invldic_2_lp; add %l7, 1, %l7


.global invldic_3
 invldic_3:
	 mov 2, %l6; mov 0, %l7 
	setx invldic_3_lp, %l0, %l2
.align 0x10 
.global invldic_3_lp
invldic_3_lp:
	 nop
	 ld [%l1], %o2; st %o2, [%l2]
	 add %l1, 4, %l1
	 sub %l7, %l6, %o3; brlz %o3, invldic_3_lp; add %l7, 1, %l7

	 .word 0xf1f4c540
	 .word 0xdf6cc000
	 .word 0xe1bcc540

	 .word 0xf3e4e000
	 .word 0xe3ecd000
	 .word 0xe19cd000

	 .word 0xf5e4d000
	 .word 0xd1ecd000
	 .word 0xe19ce380

	 .word 0xc9ece0b0
	 .word 0xd3ecc440
	 .word 0xc19ce140


.global invldic_4
 invldic_4:
	 mov 2, %l6; mov 0, %l7 
	setx invldic_4_lp, %l0, %l2
.align 0x10 
.global invldic_4_lp
invldic_4_lp:
	 nop
	 ld [%l1], %o2; st %o2, [%l2]
	 add %l1, 4, %l1
	 sub %l7, %l6, %o3; brlz %o3, invldic_4_lp; add %l7, 1, %l7

	 .word 0xc1bce0c0
	 .word 0xc36ce0d0
	 .word 0xc19cd100


.global invldic_5
 invldic_5:
	 mov 2, %l6; mov 0, %l7 
	setx invldic_5_lp, %l0, %l2
.align 0x10 
.global invldic_5_lp
invldic_5_lp:
	 nop
	 ld [%l1], %o2; st %o2, [%l2]
	 add %l1, 4, %l1
	 sub %l7, %l6, %o3; brlz %o3, invldic_5_lp; add %l7, 1, %l7


.global invldic_6
 invldic_6:
	 mov 2, %l6; mov 0, %l7 
	setx invldic_6_lp, %l0, %l2
.align