// Copyright (c) 2015 Princeton University
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Princeton University nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY PRINCETON UNIVERSITY "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL PRINCETON UNIVERSITY BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Wraps the TLU and ties unused inputs

`include    "sys.h"
`include    "tlu.h"
`include    "define.tmp.h"
`include    "lsu.tmp.h"

module tlu_nospu_wrap
(
    input           rclk,
    input [2:0]     const_cpuid,
    input [`ASI_VA_WIDTH-1:0] exu_lsu_ldst_va_e,
    input [`TLU_ASI_VA_WIDTH-1:0] lsu_tlu_ldst_va_m,
    input [7:0]     exu_mmu_early_va_e,
    input [7:0]     exu_tlu_ccr0_w,
    input [7:0]     exu_tlu_ccr1_w,
`ifndef CONFIG_NUM_THREADS
`else
    input [7:0]     exu_tlu_ccr2_w,
    input [7:0]     exu_tlu_ccr3_w,
`endif
    input [2:0]     exu_tlu_cwp0,
    input [2:0]     exu_tlu_cwp1,
    input [2:0]     exu_tlu_cwp2,
    input [2:0]     exu_tlu_cwp3,
    input           exu_tlu_cwp_cmplt ,
    input [1:0]     exu_tlu_cwp_cmplt_tid,
    input           exu_tlu_cwp_retry,
    input           exu_tlu_misalign_addr_jmpl_rtn_m,
    input           exu_tlu_spill,
    input [1:0]     exu_tlu_spill_tid,
    input           exu_tlu_spill_other,
    input [2:0]     exu_tlu_spill_wtype,
    input [8:0]     exu_tlu_ttype_m,
    input           exu_tlu_ttype_vld_m,
    input           exu_tlu_va_oor_jl_ret_m,
    input           exu_tlu_va_oor_m,
    input           ffu_tlu_ill_inst_m,
    input [1:0]     ffu_ifu_tid_w2,
    input           ffu_tlu_trap_ieee754,
    input           ffu_tlu_trap_other,
    input           ffu_tlu_trap_ue,
    input           ifu_lsu_ld_inst_e,
    input           ifu_lsu_memref_d,
    input           ifu_lsu_st_inst_e,
    input           ifu_tlu_done_inst_d,
    input           ifu_tlu_flush_m,
    input           ifu_tlu_flush_fd_w,
    input           ifu_tlu_flush_fd2_w,
    input           ifu_tlu_flush_fd3_w,
    input           lsu_tlu_early_flush_w,
    input           lsu_tlu_early_flush2_w,
    input           ifu_tlu_hwint_m,
    input           ifu_tlu_immu_miss_m,
    input           ifu_tlu_pc_oor_e,
    input [`TLU_THRD_NUM-1:0] ifu_tlu_l2imiss,
    input           ifu_tlu_inst_vld_m,
    // input           ifu_tlu_inst_vld_m_bf1,
    input           ifu_tlu_itlb_done,
    input [48:0]        ifu_tlu_npc_m,
    input [48:0]        ifu_tlu_pc_m,
    input           ifu_tlu_priv_violtn_m,
    input           ifu_tlu_retry_inst_d,
    input           ifu_tlu_rstint_m,
    input           ifu_tlu_sir_inst_m,
    input           ifu_tlu_swint_m,
    input [1:0]     ifu_tlu_thrid_d,
    input [1:0]     ifu_lsu_thrid_s,
    input [8:0]     ifu_tlu_ttype_m,
    input           ifu_tlu_ttype_vld_m,
    input           ifu_mmu_trap_m,
    input           ifu_tlu_trap_m,
    input [7:0]     lsu_asi_reg0,
    input [7:0]     lsu_asi_reg1,
    input [7:0]     lsu_asi_reg2,
    input [7:0]     lsu_asi_reg3,
    input [`TLU_ASI_STATE_WIDTH-1:0] lsu_asi_state,
    input           lsu_tlu_async_ttype_vld_g,
    input           lsu_tlu_defr_trp_taken_g,
    input           lsu_mmu_defr_trp_taken_g,
    input [6:0]     lsu_tlu_async_ttype_g,
    input [1:0]     lsu_tlu_async_tid_g,
    input [3:0]     lsu_tlu_cpx_req,
    input           lsu_tlu_cpx_vld,
    input           lsu_tlu_daccess_excptn_g,
    input           lsu_tlu_daccess_prot_g,
    input           lsu_tlu_dmmu_miss_g,
    input [12:0]    lsu_tlu_dside_ctxt_m,
    input           lsu_tlu_dtlb_done,
    input [17:16]   lsu_tlu_intpkt_17_16,
    input [12:8]    lsu_tlu_intpkt_12_8,
    input [5:0]     lsu_tlu_intpkt_5_0,
    input           lsu_tlu_misalign_addr_ldst_atm_m,
    input [12:0]    lsu_tlu_pctxt_m,
    input           lsu_tlu_pcxpkt_ack,
    input           lsu_tlu_priv_action_g,
    input [63:59]   lsu_tlu_st_rs3_data_g_63_59,
    input [48:0]    lsu_tlu_st_rs3_data_g_48_0,
    input [63:0]    lsu_tlu_rs3_data_g,
    input [1:0]     lsu_tlu_tlb_access_tid_m,
    input [7:0]     lsu_tlu_tlb_asi_state_m,
    input [47:13]   lsu_tlu_tlb_dmp_va_m,
    input           lsu_tlu_tlb_ld_inst_m,
    input [`L1D_ADDRESS_HI:0]    lsu_tlu_tlb_ldst_va_m,
    input           lsu_tlu_tlb_st_inst_m,
    input [8:0]     lsu_tlu_ttype_m2,
    input           lsu_tlu_ttype_vld_m2,
    input           lsu_tlu_wtchpt_trp_g,
    input           grst_l,
    input           arst_l,
    // input           mem_write_disable,
    // input           mux_drive_disable,
    input   [`TLU_ASR_ADDR_WIDTH-1:0] ifu_tlu_sraddr_d,
    input   [`TLU_ASR_ADDR_WIDTH-1:0] ifu_tlu_sraddr_d_v2,
    input           ifu_tlu_rsr_inst_d,
    input           lsu_tlu_wsr_inst_e ,
    input   [63:0]  exu_tlu_wsr_data_m ,
    input   [7:0]   lsu_tlu_rsr_data_e ,
    input           ifu_lsu_alt_space_e,
    input           ifu_tlu_alt_space_d,
    input           lsu_tlu_squash_va_oor_m,
    input           ifu_tlu_imiss_e,
    input [3:0]     lsu_tlu_dcache_miss_w2,
    input [3:0]     lsu_tlu_l2_dmiss,
    input [3:0]     lsu_tlu_stb_full_w2,
    input [1:0]     ffu_tlu_fpu_tid,
    input           ffu_tlu_fpu_cmplt,
    input  [2:0]    lsu_pid_state0,
    input  [2:0]    lsu_pid_state1,
    input  [2:0]    lsu_pid_state2,
    input  [2:0]    lsu_pid_state3,
    input           lsu_tlu_nucleus_ctxt_m,
    input  [2:0]    lsu_tlu_tte_pg_sz_g,
    input   [3:0]   ifu_lsu_error_inj,
    input   [8:0]   ifu_lsu_imm_asi_d,
    input           ifu_lsu_imm_asi_vld_d,
    input   [23:0]  lsu_dsfsr_din_g ,
    input   [3:0]   lsu_dmmu_sfsr_trp_wr,
    input       lsu_mmu_flush_pipe_w,
    input       exu_lsu_priority_trap_m,

    // jtag debug
    // output wire [`CORE_JTAG_BUS_WIDTH-1:0] core_rtap_data,
    input wire rtap_core_val,
    input wire [1:0] rtap_core_threadid,
    input wire [`JTAG_CORE_ID_WIDTH-1:0]  rtap_core_id,
    input wire [33:0] rtap_core_data_33_0,

    output [63:0]   tlu_lsu_int_ldxa_data_w2,
    output          tlu_lsu_int_ld_ill_va_w2,
    output          tlu_lsu_int_ldxa_vld_w2,
    output          tlu_dtlb_data_rd_g ,
    output          tlu_dtlb_dmp_actxt_g,
    output          tlu_dtlb_dmp_all_g,
    output          tlu_dtlb_dmp_nctxt_g,
    output          tlu_dtlb_dmp_pctxt_g,
    output          tlu_dtlb_dmp_sctxt_g,
    output          tlu_dtlb_dmp_vld_g,
    output          tlu_dtlb_invalidate_all_g,
    output [5:0]    tlu_dtlb_rw_index_g,
    output          tlu_dtlb_rw_index_vld_g,
    output          tlu_dtlb_tag_rd_g,
    output [42:0]   tlu_dtlb_tte_data_w2,
    output [58:0]   tlu_dtlb_tte_tag_w2,
    output[3:0]     lsu_ifu_inj_ack,
    output [`TSA_GLOBAL_WIDTH-1:0] tlu_exu_agp,
    output          tlu_exu_agp_swap,
    output [1:0]    tlu_exu_agp_tid,
    output [7:0]    tlu_exu_ccr_m,
    output [2:0]    tlu_exu_cwp_m,
    output          tlu_exu_cwp_retry_m,
    output          tlu_exu_cwpccr_update_m,
    output [`TLU_ASR_DATA_WIDTH-1:0] tlu_exu_rsr_data_m,
    output [40:0]   tlu_idtlb_dmp_key_g,
    output [1:0]    tlu_idtlb_dmp_thrid_g,
    output [3:0]    tlu_ifu_hwint_i3,
    output          tlu_ifu_nukeint_i2,
    output [3:0]    tlu_ifu_pstate_ie,
    output [3:0]    tlu_ifu_pstate_pef,
    output          tlu_ifu_resumint_i2,
    output          tlu_ifu_rstint_i2,
    output [3:0]    tlu_ifu_rstthr_i2,
    output [1:0]    tlu_ifu_trap_tid_w1,
    output          tlu_ifu_trapnpc_vld_w1,
    output [48:0]   tlu_ifu_trapnpc_w2,
    output [48:0]   tlu_ifu_trappc_w2,
    output          tlu_ifu_trappc_vld_w1,
    output          tlu_itlb_data_rd_g,
    output          tlu_itlb_dmp_actxt_g,
    output          tlu_itlb_dmp_all_g,
    output          tlu_itlb_dmp_nctxt_g,
    output          tlu_itlb_dmp_vld_g,
    output          tlu_itlb_invalidate_all_g,
    output [5:0]    tlu_itlb_rw_index_g,
    output          tlu_itlb_rw_index_vld_g,
    output          tlu_itlb_tag_rd_g,
    output [42:0]   tlu_itlb_tte_data_w2,
    output [58:0]   tlu_itlb_tte_tag_w2,
    output          tlu_itlb_wr_vld_g,
    output [7:0]    tlu_lsu_asi_m,
    output          tlu_lsu_asi_update_m,
`ifndef NO_RTL_CSM
    output          tlu_dtlb_csm_rd_g,
    output          tlu_itlb_csm_rd_g,
    output [`TLB_CSM] tlu_dtlb_tte_csm_w2,
    output [`TLB_CSM] tlu_itlb_tte_csm_w2,
    output          tlu_itlb_wr_csm_sel_g,
    output          tlu_dtlb_wr_csm_sel_g,
`endif
    output [62:0]   tlu_sscan_test_data,
    output [1:0]    tlu_lsu_ldxa_tid_w2,
    output [25:0]   tlu_lsu_pcxpkt,
    output [3:0]    tlu_lsu_pstate_am,
    output [3:0]    tlu_lsu_pstate_cle,
    output [3:0]    tlu_lsu_pstate_priv,
    output [3:0]    tlu_lsu_redmode,
    output [3:0]    tlu_lsu_redmode_rst_d1,
    output          tlu_lsu_stxa_ack,
    output [1:0]    tlu_lsu_stxa_ack_tid,
    output [1:0]    tlu_lsu_tid_m,
    output [`TLU_THRD_NUM-1:0] tlu_lsu_tl_zero,
    output [`TLU_THRD_NUM-1:0] tlu_sftint_vld,
    output [`TLU_THRD_NUM-1:0] tlu_hintp_vld,
    output [`TLU_THRD_NUM-1:0] tlu_rerr_vld,
    output tlu_early_flush_pipe_w,
    output tlu_early_flush_pipe2_w,
    output tlu_exu_early_flush_pipe_w,
    output tlu_lsu_ldxa_async_data_vld,
    output [`TLU_THRD_NUM-1:0] tlu_hpstate_priv,
    output [`TLU_THRD_NUM-1:0] tlu_hpstate_enb,
    output [`TLU_THRD_NUM-1:0] tlu_hpstate_ibe,
    output tlu_exu_priv_trap_m,
    output tlu_lsu_priv_trap_m,
    output tlu_exu_pic_onebelow_m,
    output tlu_exu_pic_twobelow_m,
    output      lsu_exu_ldxa_m ,
    output  [63:0]  lsu_exu_ldxa_data_g,
    output  [3:0]   tlu_dsfsr_flt_vld
);
    wire [63:0] lsu_tlu_st_rs3_data_g = {lsu_tlu_st_rs3_data_g_63_59, 10'bx, lsu_tlu_st_rs3_data_g_48_0};
    wire [17:0] lsu_tlu_intpkt = {lsu_tlu_intpkt_17_16, 3'bx, lsu_tlu_intpkt_12_8, 2'bx, lsu_tlu_intpkt_5_0};
wire [`CORE_JTAG_BUS_WIDTH-1:0] core_rtap_data;
wire ifu_tlu_inst_vld_m_bf1 = ifu_tlu_inst_vld_m; // trin: exactly the same signal; for synthesis

    tlu tlu(
          .short_si0              (),
          .short_si1              (),
          .short_so0              (),
          .short_so1              (),
          .si0 (),
          .si1 (),
          .so0 (),
          .so1 (),
          .grst_l                (grst_l),
          .arst_l                (arst_l),
          .tlu_sftint_vld		    (tlu_sftint_vld),
          .ifu_tlu_swint_m		    (ifu_tlu_swint_m),
          .exu_tlu_cwp0                (exu_tlu_cwp0),
          .exu_tlu_cwp1                (exu_tlu_cwp1),
          .exu_tlu_cwp2                (exu_tlu_cwp2),
          .exu_tlu_cwp3                (exu_tlu_cwp3),
          .exu_tlu_ue_trap_m           (1'b0),
          .spu_tlu_rsrv_illgl_m        (1'b0),
          .ifu_lsu_imm_asi_d           (ifu_lsu_imm_asi_d),
          .ifu_tlu_imiss_e       (ifu_tlu_imiss_e),
          .ifu_tlu_thrid_d             (ifu_tlu_thrid_d),
          .lsu_tlu_st_rs3_data_g       (lsu_tlu_st_rs3_data_g),
          .lsu_tlu_async_ttype_g       (lsu_tlu_async_ttype_g),
          .lsu_tlu_async_tid_g         (lsu_tlu_async_tid_g),
          .lsu_tlu_async_ttype_vld_g   (lsu_tlu_async_ttype_vld_g),
`ifndef NO_RTL_CSM
          .tlu_dtlb_csm_rd_g           (tlu_dtlb_csm_rd_g),
          .tlu_itlb_csm_rd_g           (tlu_itlb_csm_rd_g),
          .tlu_dtlb_tte_csm_w2         (tlu_dtlb_tte_csm_w2),
          .tlu_itlb_tte_csm_w2         (tlu_itlb_tte_csm_w2),
          .tlu_itlb_wr_csm_sel_g       (tlu_itlb_wr_csm_sel_g),
          .tlu_dtlb_wr_csm_sel_g       (tlu_dtlb_wr_csm_sel_g),
`endif
          .tlu_lsu_int_ldxa_data_w2    (tlu_lsu_int_ldxa_data_w2),
          .tlu_lsu_int_ld_ill_va_w2    (tlu_lsu_int_ld_ill_va_w2),
          .tlu_lsu_int_ldxa_vld_w2     (tlu_lsu_int_ldxa_vld_w2),
          .tlu_dtlb_data_rd_g          (tlu_dtlb_data_rd_g),
          .tlu_dtlb_dmp_actxt_g        (tlu_dtlb_dmp_actxt_g),
          .tlu_dtlb_dmp_all_g          (tlu_dtlb_dmp_all_g),
          .tlu_dtlb_dmp_nctxt_g        (tlu_dtlb_dmp_nctxt_g),
          .tlu_dtlb_dmp_pctxt_g        (tlu_dtlb_dmp_pctxt_g),
          .tlu_dtlb_dmp_sctxt_g        (tlu_dtlb_dmp_sctxt_g),
          .tlu_dtlb_dmp_vld_g          (tlu_dtlb_dmp_vld_g),
          .tlu_dtlb_invalidate_all_g   (tlu_dtlb_invalidate_all_g),
          .tlu_dtlb_rw_index_g         (tlu_dtlb_rw_index_g),
          .tlu_dtlb_rw_index_vld_g     (tlu_dtlb_rw_index_vld_g),
          .tlu_dtlb_tag_rd_g           (tlu_dtlb_tag_rd_g),
          .tlu_dtlb_tte_data_w2        (tlu_dtlb_tte_data_w2),
          .tlu_dtlb_tte_tag_w2         (tlu_dtlb_tte_tag_w2),
          .lsu_ifu_inj_ack             (lsu_ifu_inj_ack),
          .tlu_exu_agp                 (tlu_exu_agp),
          .tlu_exu_agp_swap            (tlu_exu_agp_swap),
          .tlu_exu_agp_tid             (tlu_exu_agp_tid),
          .tlu_exu_ccr_m               (tlu_exu_ccr_m),
          .tlu_exu_cwp_m               (tlu_exu_cwp_m),
          .tlu_exu_cwp_retry_m         (tlu_exu_cwp_retry_m),
          .tlu_exu_cwpccr_update_m     (tlu_exu_cwpccr_update_m),
          .tlu_exu_rsr_data_m          (tlu_exu_rsr_data_m),
          .tlu_idtlb_dmp_key_g         (tlu_idtlb_dmp_key_g),
          .tlu_idtlb_dmp_thrid_g       (tlu_idtlb_dmp_thrid_g),
          .tlu_ifu_hwint_i3            (tlu_ifu_hwint_i3),
          .tlu_ifu_nukeint_i2          (tlu_ifu_nukeint_i2),
          .tlu_ifu_pstate_ie           (tlu_ifu_pstate_ie),
          .tlu_ifu_pstate_pef          (tlu_ifu_pstate_pef),
          .tlu_ifu_resumint_i2         (tlu_ifu_resumint_i2),
          .tlu_ifu_rstint_i2           (tlu_ifu_rstint_i2),
          .tlu_ifu_rstthr_i2           (tlu_ifu_rstthr_i2),
          .tlu_ifu_trap_tid_w1         (tlu_ifu_trap_tid_w1),
          .tlu_ifu_trapnpc_vld_w1      (tlu_ifu_trapnpc_vld_w1),
          .tlu_ifu_trapnpc_w2          (tlu_ifu_trapnpc_w2),
          .tlu_ifu_trappc_w2           (tlu_ifu_trappc_w2),
          .tlu_ifu_trappc_vld_w1       (tlu_ifu_trappc_vld_w1),
          .tlu_itlb_data_rd_g          (tlu_itlb_data_rd_g),
          .tlu_itlb_dmp_actxt_g        (tlu_itlb_dmp_actxt_g),
          .tlu_itlb_dmp_all_g          (tlu_itlb_dmp_all_g),
          .tlu_itlb_dmp_nctxt_g        (tlu_itlb_dmp_nctxt_g),
          .tlu_itlb_dmp_vld_g          (tlu_itlb_dmp_vld_g),
          .tlu_itlb_invalidate_all_g   (tlu_itlb_invalidate_all_g),
          .tlu_itlb_rw_index_g         (tlu_itlb_rw_index_g),
          .tlu_itlb_rw_index_vld_g     (tlu_itlb_rw_index_vld_g),
          .tlu_itlb_tag_rd_g           (tlu_itlb_tag_rd_g),
          .tlu_itlb_tte_data_w2        (tlu_itlb_tte_data_w2),
          .tlu_itlb_tte_tag_w2         (tlu_itlb_tte_tag_w2),
          .tlu_itlb_wr_vld_g           (tlu_itlb_wr_vld_g),
          .tlu_lsu_asi_m               (tlu_lsu_asi_m),
          .tlu_lsu_asi_update_m        (tlu_lsu_asi_update_m),
          .tlu_sscan_test_data         (tlu_sscan_test_data),
          .tlu_lsu_ldxa_tid_w2         (tlu_lsu_ldxa_tid_w2),
          .tlu_lsu_pcxpkt              (tlu_lsu_pcxpkt),
          .tlu_lsu_pstate_am           (tlu_lsu_pstate_am),
          .tlu_lsu_pstate_cle          (tlu_lsu_pstate_cle),
          .tlu_lsu_pstate_priv         (tlu_lsu_pstate_priv),
          .tlu_lsu_redmode             (tlu_lsu_redmode),
          .tlu_lsu_redmode_rst_d1      (tlu_lsu_redmode_rst_d1),
          .tlu_lsu_stxa_ack            (tlu_lsu_stxa_ack),
          .tlu_lsu_stxa_ack_tid        (tlu_lsu_stxa_ack_tid),
          .tlu_lsu_tid_m               (tlu_lsu_tid_m),
          .tlu_lsu_tl_zero             (tlu_lsu_tl_zero),
          .tlu_hintp_vld               (tlu_hintp_vld),
          .tlu_rerr_vld                (tlu_rerr_vld),
          .tlu_early_flush_pipe_w      (tlu_early_flush_pipe_w),
          .tlu_early_flush_pipe2_w     (tlu_early_flush_pipe2_w),
          .tlu_exu_early_flush_pipe_w  (tlu_exu_early_flush_pipe_w),
          .tlu_lsu_ldxa_async_data_vld (tlu_lsu_ldxa_async_data_vld),
          .tlu_hpstate_priv            (tlu_hpstate_priv),
          .tlu_hpstate_enb             (tlu_hpstate_enb),
          .tlu_hpstate_ibe             (tlu_hpstate_ibe),
          .tlu_exu_priv_trap_m         (tlu_exu_priv_trap_m),
          .tlu_lsu_priv_trap_m         (tlu_lsu_priv_trap_m),
          .tlu_exu_pic_onebelow_m      (tlu_exu_pic_onebelow_m),
          .tlu_exu_pic_twobelow_m      (tlu_exu_pic_twobelow_m),
          .lsu_exu_ldxa_m              (lsu_exu_ldxa_m),
          .lsu_exu_ldxa_data_g         (lsu_exu_ldxa_data_g),
          .tlu_dsfsr_flt_vld           (tlu_dsfsr_flt_vld),
          .rclk                        (rclk),
          .const_cpuid                 ({1'bx, const_cpuid}),
          .exu_lsu_ldst_va_e           (exu_lsu_ldst_va_e),
          .lsu_tlu_ldst_va_m           (lsu_tlu_ldst_va_m),
          .exu_mmu_early_va_e          (exu_mmu_early_va_e),
          .exu_tlu_ccr0_w              (exu_tlu_ccr0_w),
          .exu_tlu_ccr1_w              (exu_tlu_ccr1_w),
`ifndef CONFIG_NUM_THREADS
          .exu_tlu_ccr2_w              (8'bx),
          .exu_tlu_ccr3_w              (8'bx),
`else
          .exu_tlu_ccr2_w              (exu_tlu_ccr2_w),
          .exu_tlu_ccr3_w              (exu_tlu_ccr3_w),
`endif
          .exu_tlu_cwp_cmplt           (exu_tlu_cwp_cmplt),
          .exu_tlu_cwp_cmplt_tid       (exu_tlu_cwp_cmplt_tid),
          .exu_tlu_cwp_retry           (exu_tlu_cwp_retry),
          .exu_tlu_misalign_addr_jmpl_rtn_m(exu_tlu_misalign_addr_jmpl_rtn_m),
          .exu_tlu_spill               (exu_tlu_spill),
          .exu_tlu_spill_tid           (exu_tlu_spill_tid),
          .exu_tlu_spill_other         (exu_tlu_spill_other),
          .exu_tlu_spill_wtype         (exu_tlu_spill_wtype),
          .exu_tlu_ttype_m             (exu_tlu_ttype_m),
          .exu_tlu_ttype_vld_m         (exu_tlu_ttype_vld_m),
          .exu_tlu_va_oor_jl_ret_m     (exu_tlu_va_oor_jl_ret_m),
          .exu_tlu_va_oor_m            (exu_tlu_va_oor_m),
          .ffu_tlu_ill_inst_m          (ffu_tlu_ill_inst_m),
          .ffu_ifu_tid_w2              (ffu_ifu_tid_w2),
          .ffu_tlu_trap_ieee754        (ffu_tlu_trap_ieee754),
          .ffu_tlu_trap_other          (ffu_tlu_trap_other),
          .ffu_tlu_trap_ue             (ffu_tlu_trap_ue),
          .ifu_lsu_ld_inst_e           (ifu_lsu_ld_inst_e),
          .ifu_lsu_memref_d            (ifu_lsu_memref_d),
          .ifu_lsu_st_inst_e           (ifu_lsu_st_inst_e),
          .ifu_tlu_done_inst_d         (ifu_tlu_done_inst_d),
          .ifu_tlu_flush_m             (ifu_tlu_flush_m),
          .ifu_tlu_flush_fd_w          (ifu_tlu_flush_fd_w),
          .ifu_tlu_flush_fd2_w         (ifu_tlu_flush_fd2_w),
          .ifu_tlu_flush_fd3_w         (ifu_tlu_flush_fd3_w),
          .lsu_tlu_early_flush_w       (lsu_tlu_early_flush_w),
          .lsu_tlu_early_flush2_w      (lsu_tlu_early_flush2_w),
          .ifu_tlu_hwint_m             (ifu_tlu_hwint_m),
          .ifu_tlu_immu_miss_m         (ifu_tlu_immu_miss_m),
          .ifu_tlu_pc_oor_e            (ifu_tlu_pc_oor_e),
          .ifu_tlu_l2imiss             (ifu_tlu_l2imiss),
          .ifu_tlu_inst_vld_m          (ifu_tlu_inst_vld_m),
          .ifu_tlu_inst_vld_m_bf1      (ifu_tlu_inst_vld_m_bf1),
          .ifu_tlu_itlb_done           (ifu_tlu_itlb_done),
          .ifu_tlu_npc_m               (ifu_tlu_npc_m),
          .ifu_tlu_pc_m                (ifu_tlu_pc_m),
          .ifu_tlu_priv_violtn_m       (ifu_tlu_priv_violtn_m),
          .ifu_tlu_retry_inst_d        (ifu_tlu_retry_inst_d),
          .ifu_tlu_rstint_m            (ifu_tlu_rstint_m),
          .ifu_tlu_sir_inst_m          (ifu_tlu_sir_inst_m),
          .ifu_lsu_thrid_s             (ifu_lsu_thrid_s),
          .ifu_tlu_ttype_m             (ifu_tlu_ttype_m),
          .ifu_tlu_ttype_vld_m         (ifu_tlu_ttype_vld_m),
          .ifu_mmu_trap_m              (ifu_mmu_trap_m),
          .ifu_tlu_trap_m              (ifu_tlu_trap_m),
          .lsu_asi_reg0                (lsu_asi_reg0),
          .lsu_asi_reg1                (lsu_asi_reg1),
          .lsu_asi_reg2                (lsu_asi_reg2),
          .lsu_asi_reg3                (lsu_asi_reg3),
          .lsu_asi_state               (lsu_asi_state),
          .lsu_tlu_defr_trp_taken_g    (lsu_tlu_defr_trp_taken_g),
          .lsu_mmu_defr_trp_taken_g    (lsu_mmu_defr_trp_taken_g),
          .lsu_tlu_cpx_req             (lsu_tlu_cpx_req),
          .lsu_tlu_cpx_vld             (lsu_tlu_cpx_vld),
          .lsu_tlu_daccess_excptn_g    (lsu_tlu_daccess_excptn_g),
          .lsu_tlu_daccess_prot_g      (lsu_tlu_daccess_prot_g),
          .lsu_tlu_dmmu_miss_g         (lsu_tlu_dmmu_miss_g),
          .lsu_tlu_dside_ctxt_m        (lsu_tlu_dside_ctxt_m),
          .lsu_tlu_dtlb_done           (lsu_tlu_dtlb_done),
          .lsu_tlu_intpkt              (lsu_tlu_intpkt),
          .lsu_tlu_misalign_addr_ldst_atm_m(lsu_tlu_misalign_addr_ldst_atm_m),
          .lsu_tlu_pctxt_m             (lsu_tlu_pctxt_m),
          .lsu_tlu_pcxpkt_ack          (lsu_tlu_pcxpkt_ack),
          .lsu_tlu_priv_action_g       (lsu_tlu_priv_action_g),
          .lsu_tlu_rs3_data_g          (lsu_tlu_rs3_data_g),
          .lsu_tlu_tlb_access_tid_m    (lsu_tlu_tlb_access_tid_m),
          .lsu_tlu_tlb_asi_state_m     (lsu_tlu_tlb_asi_state_m),
          .lsu_tlu_tlb_dmp_va_m        (lsu_tlu_tlb_dmp_va_m),
          .lsu_tlu_tlb_ld_inst_m       (lsu_tlu_tlb_ld_inst_m),
          .lsu_tlu_tlb_ldst_va_m       (lsu_tlu_tlb_ldst_va_m),
          .lsu_tlu_tlb_st_inst_m       (lsu_tlu_tlb_st_inst_m),
          .lsu_tlu_ttype_m2            (lsu_tlu_ttype_m2),
          .lsu_tlu_ttype_vld_m2        (lsu_tlu_ttype_vld_m2),
          .lsu_tlu_wtchpt_trp_g        (lsu_tlu_wtchpt_trp_g),
          // .mem_write_disable           (mem_write_disable),
          // .mux_drive_disable           (mux_drive_disable),
          .sehold                      (1'b0),
          .se                          (1'b0),
          .ifu_tlu_sraddr_d            (ifu_tlu_sraddr_d),
          .ifu_tlu_sraddr_d_v2         (ifu_tlu_sraddr_d_v2),
          .ifu_tlu_rsr_inst_d          (ifu_tlu_rsr_inst_d),
          .lsu_tlu_wsr_inst_e          (lsu_tlu_wsr_inst_e),
          .exu_tlu_wsr_data_m          (exu_tlu_wsr_data_m),
          .lsu_tlu_rsr_data_e          (lsu_tlu_rsr_data_e),
          .ifu_lsu_alt_space_e         (ifu_lsu_alt_space_e),
          .ifu_tlu_alt_space_d         (ifu_tlu_alt_space_d),
          .lsu_tlu_squash_va_oor_m     (lsu_tlu_squash_va_oor_m),
          .lsu_tlu_dcache_miss_w2      (lsu_tlu_dcache_miss_w2),
          .lsu_tlu_l2_dmiss            (lsu_tlu_l2_dmiss),
          .lsu_tlu_stb_full_w2         (lsu_tlu_stb_full_w2),
          .ffu_tlu_fpu_tid             (ffu_tlu_fpu_tid),
          .ffu_tlu_fpu_cmplt           (ffu_tlu_fpu_cmplt),
          .lsu_pid_state0              (lsu_pid_state0),
          .lsu_pid_state1              (lsu_pid_state1),
          .lsu_pid_state2              (lsu_pid_state2),
          .lsu_pid_state3              (lsu_pid_state3),
          .lsu_tlu_nucleus_ctxt_m      (lsu_tlu_nucleus_ctxt_m),
          .lsu_tlu_tte_pg_sz_g         (lsu_tlu_tte_pg_sz_g),
          .ifu_lsu_error_inj           (ifu_lsu_error_inj),
          .ifu_lsu_imm_asi_vld_d       (ifu_lsu_imm_asi_vld_d),
          .lsu_dsfsr_din_g             (lsu_dsfsr_din_g),
          .lsu_dmmu_sfsr_trp_wr        (lsu_dmmu_sfsr_trp_wr),
          .lsu_mmu_flush_pipe_w        (lsu_mmu_flush_pipe_w),
          .exu_lsu_priority_trap_m     (exu_lsu_priority_trap_m),

    .core_rtap_data          (core_rtap_data),
    .rtap_core_val         (rtap_core_val),
    .rtap_core_threadid         (rtap_core_threadid),
    .rtap_core_id         (rtap_core_id),
    .rtap_core_data         ({{(`CORE_JTAG_BUS_WIDTH - 34){1'bx}}, rtap_core_data_33_0})
          );

endmodule
