/////////////////////////////////////////////////////////////////////
////                                                             ////
////  				Galois Field Multiplier                      ////
////                 Computes Multiplication in 8 clk cycles     ////
////                                                             ////
//// 		   Author: Guy Hutchison   		   		             ////
////          ghutchis@gmail.com                                 ////
////                                                             ////
////  Downloaded from: http://www.opencores.org/				 ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2010 	 Guy Hutchison						 ////
////                         									 ////
////                                                			 ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
////     THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY     ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED   ////
//// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS   ////
//// FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL THE AUTHOR      ////
//// OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,         ////
//// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES    ////
//// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE   ////
//// GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR        ////
//// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF  ////
//// LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT  ////
//// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  ////
//// OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE         ////
//// POSSIBILITY OF SUCH DAMAGE.                                 ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
 




`timescale 1ns / 1ps

module gfm128_16(v_in,z_in,b_in,v_out,z_out);
input  [127:0] v_in;
input  [127:0] z_in;
input  [15:0] b_in;
output [127:0] v_out;
output [127:0] z_out;
assign v_out[0] = v_in[16];
assign z_out[0] = ((((z_in[0]) ^ ((v_in[0]) & (b_in[15]))) ^ (((v_in[1]) & (b_in[14])) ^ ((v_in[2]) & (b_in[13])))) ^ ((((v_in[4]) & (b_in[11])) ^ ((v_in[3]) & (b_in[12]))) ^ (((v_in[5]) & (b_in[10])) ^ ((v_in[6]) & (b_in[9]))))) ^ ((((((v_in[10]) & (b_in[5])) ^ ((v_in[9]) & (b_in[6]))) ^ ((v_in[11]) & (b_in[4]))) ^ (((v_in[8]) & (b_in[7])) ^ ((v_in[7]) & (b_in[8])))) ^ ((((v_in[13]) & (b_in[2])) ^ ((v_in[12]) & (b_in[3]))) ^ (((v_in[14]) & (b_in[1])) ^ ((v_in[15]) & (b_in[0])))));
assign v_out[1] = v_in[17];
assign z_out[1] = ((((z_in[1]) ^ ((v_in[1]) & (b_in[15]))) ^ (((v_in[2]) & (b_in[14])) ^ ((v_in[3]) & (b_in[13])))) ^ ((((v_in[5]) & (b_in[11])) ^ ((v_in[4]) & (b_in[12]))) ^ (((v_in[6]) & (b_in[10])) ^ ((v_in[7]) & (b_in[9]))))) ^ ((((((v_in[11]) & (b_in[5])) ^ ((v_in[10]) & (b_in[6]))) ^ ((v_in[12]) & (b_in[4]))) ^ (((v_in[9]) & (b_in[7])) ^ ((v_in[8]) & (b_in[8])))) ^ ((((v_in[14]) & (b_in[2])) ^ ((v_in[13]) & (b_in[3]))) ^ (((v_in[15]) & (b_in[1])) ^ ((v_in[16]) & (b_in[0])))));
assign v_out[2] = v_in[18];
assign z_out[2] = ((((z_in[2]) ^ ((v_in[2]) & (b_in[15]))) ^ (((v_in[3]) & (b_in[14])) ^ ((v_in[4]) & (b_in[13])))) ^ ((((v_in[6]) & (b_in[11])) ^ ((v_in[5]) & (b_in[12]))) ^ (((v_in[7]) & (b_in[10])) ^ ((v_in[8]) & (b_in[9]))))) ^ ((((((v_in[12]) & (b_in[5])) ^ ((v_in[11]) & (b_in[6]))) ^ ((v_in[13]) & (b_in[4]))) ^ (((v_in[10]) & (b_in[7])) ^ ((v_in[9]) & (b_in[8])))) ^ ((((v_in[15]) & (b_in[2])) ^ ((v_in[14]) & (b_in[3]))) ^ (((v_in[16]) & (b_in[1])) ^ ((v_in[17]) & (b_in[0])))));
assign v_out[3] = v_in[19];
assign z_out[3] = ((((z_in[3]) ^ ((v_in[3]) & (b_in[15]))) ^ (((v_in[4]) & (b_in[14])) ^ ((v_in[5]) & (b_in[13])))) ^ ((((v_in[7]) & (b_in[11])) ^ ((v_in[6]) & (b_in[12]))) ^ (((v_in[8]) & (b_in[10])) ^ ((v_in[9]) & (b_in[9]))))) ^ ((((((v_in[13]) & (b_in[5])) ^ ((v_in[12]) & (b_in[6]))) ^ ((v_in[14]) & (b_in[4]))) ^ (((v_in[11]) & (b_in[7])) ^ ((v_in[10]) & (b_in[8])))) ^ ((((v_in[16]) & (b_in[2])) ^ ((v_in[15]) & (b_in[3]))) ^ (((v_in[17]) & (b_in[1])) ^ ((v_in[18]) & (b_in[0])))));
assign v_out[4] = v_in[20];
assign z_out[4] = ((((z_in[4]) ^ ((v_in[4]) & (b_in[15]))) ^ (((v_in[5]) & (b_in[14])) ^ ((v_in[6]) & (b_in[13])))) ^ ((((v_in[8]) & (b_in[11])) ^ ((v_in[7]) & (b_in[12]))) ^ (((v_in[9]) & (b_in[10])) ^ ((v_in[10]) & (b_in[9]))))) ^ ((((((v_in[14]) & (b_in[5])) ^ ((v_in[13]) & (b_in[6]))) ^ ((v_in[15]) & (b_in[4]))) ^ (((v_in[12]) & (b_in[7])) ^ ((v_in[11]) & (b_in[8])))) ^ ((((v_in[17]) & (b_in[2])) ^ ((v_in[16]) & (b_in[3]))) ^ (((v_in[18]) & (b_in[1])) ^ ((v_in[19]) & (b_in[0])))));
assign v_out[5] = v_in[21];
assign z_out[5] = ((((z_in[5]) ^ ((v_in[5]) & (b_in[15]))) ^ (((v_in[6]) & (b_in[14])) ^ ((v_in[7]) & (b_in[13])))) ^ ((((v_in[9]) & (b_in[11])) ^ ((v_in[8]) & (b_in[12]))) ^ (((v_in[10]) & (b_in[10])) ^ ((v_in[11]) & (b_in[9]))))) ^ ((((((v_in[15]) & (b_in[5])) ^ ((v_in[14]) & (b_in[6]))) ^ ((v_in[16]) & (b_in[4]))) ^ (((v_in[13]) & (b_in[7])) ^ ((v_in[12]) & (b_in[8])))) ^ ((((v_in[18]) & (b_in[2])) ^ ((v_in[17]) & (b_in[3]))) ^ (((v_in[19]) & (b_in[1])) ^ ((v_in[20]) & (b_in[0])))));
assign v_out[6] = v_in[22];
assign z_out[6] = ((((z_in[6]) ^ ((v_in[6]) & (b_in[15]))) ^ (((v_in[7]) & (b_in[14])) ^ ((v_in[8]) & (b_in[13])))) ^ ((((v_in[10]) & (b_in[11])) ^ ((v_in[9]) & (b_in[12]))) ^ (((v_in[11]) & (b_in[10])) ^ ((v_in[12]) & (b_in[9]))))) ^ ((((((v_in[16]) & (b_in[5])) ^ ((v_in[15]) & (b_in[6]))) ^ ((v_in[17]) & (b_in[4]))) ^ (((v_in[14]) & (b_in[7])) ^ ((v_in[13]) & (b_in[8])))) ^ ((((v_in[19]) & (b_in[2])) ^ ((v_in[18]) & (b_in[3]))) ^ (((v_in[20]) & (b_in[1])) ^ ((v_in[21]) & (b_in[0])))));
assign v_out[7] = v_in[23];
assign z_out[7] = ((((z_in[7]) ^ ((v_in[7]) & (b_in[15]))) ^ (((v_in[8]) & (b_in[14])) ^ ((v_in[9]) & (b_in[13])))) ^ ((((v_in[11]) & (b_in[11])) ^ ((v_in[10]) & (b_in[12]))) ^ (((v_in[12]) & (b_in[10])) ^ ((v_in[13]) & (b_in[9]))))) ^ ((((((v_in[17]) & (b_in[5])) ^ ((v_in[16]) & (b_in[6]))) ^ ((v_in[18]) & (b_in[4]))) ^ (((v_in[15]) & (b_in[7])) ^ ((v_in[14]) & (b_in[8])))) ^ ((((v_in[20]) & (b_in[2])) ^ ((v_in[19]) & (b_in[3]))) ^ (((v_in[21]) & (b_in[1])) ^ ((v_in[22]) & (b_in[0])))));
assign v_out[8] = v_in[24];
assign z_out[8] = ((((z_in[8]) ^ ((v_in[8]) & (b_in[15]))) ^ (((v_in[9]) & (b_in[14])) ^ ((v_in[10]) & (b_in[13])))) ^ ((((v_in[12]) & (b_in[11])) ^ ((v_in[11]) & (b_in[12]))) ^ (((v_in[13]) & (b_in[10])) ^ ((v_in[14]) & (b_in[9]))))) ^ ((((((v_in[18]) & (b_in[5])) ^ ((v_in[17]) & (b_in[6]))) ^ ((v_in[19]) & (b_in[4]))) ^ (((v_in[16]) & (b_in[7])) ^ ((v_in[15]) & (b_in[8])))) ^ ((((v_in[21]) & (b_in[2])) ^ ((v_in[20]) & (b_in[3]))) ^ (((v_in[22]) & (b_in[1])) ^ ((v_in[23]) & (b_in[0])))));
assign v_out[9] = v_in[25];
assign z_out[9] = ((((z_in[9]) ^ ((v_in[9]) & (b_in[15]))) ^ (((v_in[10]) & (b_in[14])) ^ ((v_in[11]) & (b_in[13])))) ^ ((((v_in[13]) & (b_in[11])) ^ ((v_in[12]) & (b_in[12]))) ^ (((v_in[14]) & (b_in[10])) ^ ((v_in[15]) & (b_in[9]))))) ^ ((((((v_in[19]) & (b_in[5])) ^ ((v_in[18]) & (b_in[6]))) ^ ((v_in[20]) & (b_in[4]))) ^ (((v_in[17]) & (b_in[7])) ^ ((v_in[16]) & (b_in[8])))) ^ ((((v_in[22]) & (b_in[2])) ^ ((v_in[21]) & (b_in[3]))) ^ (((v_in[23]) & (b_in[1])) ^ ((v_in[24]) & (b_in[0])))));
assign v_out[10] = v_in[26];
assign z_out[10] = ((((z_in[10]) ^ ((v_in[10]) & (b_in[15]))) ^ (((v_in[11]) & (b_in[14])) ^ ((v_in[12]) & (b_in[13])))) ^ ((((v_in[14]) & (b_in[11])) ^ ((v_in[13]) & (b_in[12]))) ^ (((v_in[15]) & (b_in[10])) ^ ((v_in[16]) & (b_in[9]))))) ^ ((((((v_in[20]) & (b_in[5])) ^ ((v_in[19]) & (b_in[6]))) ^ ((v_in[21]) & (b_in[4]))) ^ (((v_in[18]) & (b_in[7])) ^ ((v_in[17]) & (b_in[8])))) ^ ((((v_in[23]) & (b_in[2])) ^ ((v_in[22]) & (b_in[3]))) ^ (((v_in[24]) & (b_in[1])) ^ ((v_in[25]) & (b_in[0])))));
assign v_out[11] = v_in[27];
assign z_out[11] = ((((z_in[11]) ^ ((v_in[11]) & (b_in[15]))) ^ (((v_in[12]) & (b_in[14])) ^ ((v_in[13]) & (b_in[13])))) ^ ((((v_in[15]) & (b_in[11])) ^ ((v_in[14]) & (b_in[12]))) ^ (((v_in[16]) & (b_in[10])) ^ ((v_in[17]) & (b_in[9]))))) ^ ((((((v_in[21]) & (b_in[5])) ^ ((v_in[20]) & (b_in[6]))) ^ ((v_in[22]) & (b_in[4]))) ^ (((v_in[19]) & (b_in[7])) ^ ((v_in[18]) & (b_in[8])))) ^ ((((v_in[24]) & (b_in[2])) ^ ((v_in[23]) & (b_in[3]))) ^ (((v_in[25]) & (b_in[1])) ^ ((v_in[26]) & (b_in[0])))));
assign v_out[12] = v_in[28];
assign z_out[12] = ((((z_in[12]) ^ ((v_in[12]) & (b_in[15]))) ^ (((v_in[13]) & (b_in[14])) ^ ((v_in[14]) & (b_in[13])))) ^ ((((v_in[16]) & (b_in[11])) ^ ((v_in[15]) & (b_in[12]))) ^ (((v_in[17]) & (b_in[10])) ^ ((v_in[18]) & (b_in[9]))))) ^ ((((((v_in[22]) & (b_in[5])) ^ ((v_in[21]) & (b_in[6]))) ^ ((v_in[23]) & (b_in[4]))) ^ (((v_in[20]) & (b_in[7])) ^ ((v_in[19]) & (b_in[8])))) ^ ((((v_in[25]) & (b_in[2])) ^ ((v_in[24]) & (b_in[3]))) ^ (((v_in[26]) & (b_in[1])) ^ ((v_in[27]) & (b_in[0])))));
assign v_out[13] = v_in[29];
assign z_out[13] = ((((z_in[13]) ^ ((v_in[13]) & (b_in[15]))) ^ (((v_in[14]) & (b_in[14])) ^ ((v_in[15]) & (b_in[13])))) ^ ((((v_in[17]) & (b_in[11])) ^ ((v_in[16]) & (b_in[12]))) ^ (((v_in[18]) & (b_in[10])) ^ ((v_in[19]) & (b_in[9]))))) ^ ((((((v_in[23]) & (b_in[5])) ^ ((v_in[22]) & (b_in[6]))) ^ ((v_in[24]) & (b_in[4]))) ^ (((v_in[21]) & (b_in[7])) ^ ((v_in[20]) & (b_in[8])))) ^ ((((v_in[26]) & (b_in[2])) ^ ((v_in[25]) & (b_in[3]))) ^ (((v_in[27]) & (b_in[1])) ^ ((v_in[28]) & (b_in[0])))));
assign v_out[14] = v_in[30];
assign z_out[14] = ((((z_in[14]) ^ ((v_in[14]) & (b_in[15]))) ^ (((v_in[15]) & (b_in[14])) ^ ((v_in[16]) & (b_in[13])))) ^ ((((v_in[18]) & (b_in[11])) ^ ((v_in[17]) & (b_in[12]))) ^ (((v_in[19]) & (b_in[10])) ^ ((v_in[20]) & (b_in[9]))))) ^ ((((((v_in[24]) & (b_in[5])) ^ ((v_in[23]) & (b_in[6]))) ^ ((v_in[25]) & (b_in[4]))) ^ (((v_in[22]) & (b_in[7])) ^ ((v_in[21]) & (b_in[8])))) ^ ((((v_in[27]) & (b_in[2])) ^ ((v_in[26]) & (b_in[3]))) ^ (((v_in[28]) & (b_in[1])) ^ ((v_in[29]) & (b_in[0])))));
assign v_out[15] = v_in[31];
assign z_out[15] = ((((z_in[15]) ^ ((v_in[15]) & (b_in[15]))) ^ (((v_in[16]) & (b_in[14])) ^ ((v_in[17]) & (b_in[13])))) ^ ((((v_in[19]) & (b_in[11])) ^ ((v_in[18]) & (b_in[12]))) ^ (((v_in[20]) & (b_in[10])) ^ ((v_in[21]) & (b_in[9]))))) ^ ((((((v_in[25]) & (b_in[5])) ^ ((v_in[24]) & (b_in[6]))) ^ ((v_in[26]) & (b_in[4]))) ^ (((v_in[23]) & (b_in[7])) ^ ((v_in[22]) & (b_in[8])))) ^ ((((v_in[28]) & (b_in[2])) ^ ((v_in[27]) & (b_in[3]))) ^ (((v_in[29]) & (b_in[1])) ^ ((v_in[30]) & (b_in[0])))));
assign v_out[16] = v_in[32];
assign z_out[16] = ((((z_in[16]) ^ ((v_in[16]) & (b_in[15]))) ^ (((v_in[17]) & (b_in[14])) ^ ((v_in[18]) & (b_in[13])))) ^ ((((v_in[20]) & (b_in[11])) ^ ((v_in[19]) & (b_in[12]))) ^ (((v_in[21]) & (b_in[10])) ^ ((v_in[22]) & (b_in[9]))))) ^ ((((((v_in[26]) & (b_in[5])) ^ ((v_in[25]) & (b_in[6]))) ^ ((v_in[27]) & (b_in[4]))) ^ (((v_in[24]) & (b_in[7])) ^ ((v_in[23]) & (b_in[8])))) ^ ((((v_in[29]) & (b_in[2])) ^ ((v_in[28]) & (b_in[3]))) ^ (((v_in[30]) & (b_in[1])) ^ ((v_in[31]) & (b_in[0])))));
assign v_out[17] = v_in[33];
assign z_out[17] = ((((z_in[17]) ^ ((v_in[17]) & (b_in[15]))) ^ (((v_in[18]) & (b_in[14])) ^ ((v_in[19]) & (b_in[13])))) ^ ((((v_in[21]) & (b_in[11])) ^ ((v_in[20]) & (b_in[12]))) ^ (((v_in[22]) & (b_in[10])) ^ ((v_in[23]) & (b_in[9]))))) ^ ((((((v_in[27]) & (b_in[5])) ^ ((v_in[26]) & (b_in[6]))) ^ ((v_in[28]) & (b_in[4]))) ^ (((v_in[25]) & (b_in[7])) ^ ((v_in[24]) & (b_in[8])))) ^ ((((v_in[30]) & (b_in[2])) ^ ((v_in[29]) & (b_in[3]))) ^ (((v_in[31]) & (b_in[1])) ^ ((v_in[32]) & (b_in[0])))));
assign v_out[18] = v_in[34];
assign z_out[18] = ((((z_in[18]) ^ ((v_in[18]) & (b_in[15]))) ^ (((v_in[19]) & (b_in[14])) ^ ((v_in[20]) & (b_in[13])))) ^ ((((v_in[22]) & (b_in[11])) ^ ((v_in[21]) & (b_in[12]))) ^ (((v_in[23]) & (b_in[10])) ^ ((v_in[24]) & (b_in[9]))))) ^ ((((((v_in[28]) & (b_in[5])) ^ ((v_in[27]) & (b_in[6]))) ^ ((v_in[29]) & (b_in[4]))) ^ (((v_in[26]) & (b_in[7])) ^ ((v_in[25]) & (b_in[8])))) ^ ((((v_in[31]) & (b_in[2])) ^ ((v_in[30]) & (b_in[3]))) ^ (((v_in[32]) & (b_in[1])) ^ ((v_in[33]) & (b_in[0])))));
assign v_out[19] = v_in[35];
assign z_out[19] = ((((z_in[19]) ^ ((v_in[19]) & (b_in[15]))) ^ (((v_in[20]) & (b_in[14])) ^ ((v_in[21]) & (b_in[13])))) ^ ((((v_in[23]) & (b_in[11])) ^ ((v_in[22]) & (b_in[12]))) ^ (((v_in[24]) & (b_in[10])) ^ ((v_in[25]) & (b_in[9]))))) ^ ((((((v_in[29]) & (b_in[5])) ^ ((v_in[28]) & (b_in[6]))) ^ ((v_in[30]) & (b_in[4]))) ^ (((v_in[27]) & (b_in[7])) ^ ((v_in[26]) & (b_in[8])))) ^ ((((v_in[32]) & (b_in[2])) ^ ((v_in[31]) & (b_in[3]))) ^ (((v_in[33]) & (b_in[1])) ^ ((v_in[34]) & (b_in[0])))));
assign v_out[20] = v_in[36];
assign z_out[20] = ((((z_in[20]) ^ ((v_in[20]) & (b_in[15]))) ^ (((v_in[21]) & (b_in[14])) ^ ((v_in[22]) & (b_in[13])))) ^ ((((v_in[24]) & (b_in[11])) ^ ((v_in[23]) & (b_in[12]))) ^ (((v_in[25]) & (b_in[10])) ^ ((v_in[26]) & (b_in[9]))))) ^ ((((((v_in[30]) & (b_in[5])) ^ ((v_in[29]) & (b_in[6]))) ^ ((v_in[31]) & (b_in[4]))) ^ (((v_in[28]) & (b_in[7])) ^ ((v_in[27]) & (b_in[8])))) ^ ((((v_in[33]) & (b_in[2])) ^ ((v_in[32]) & (b_in[3]))) ^ (((v_in[34]) & (b_in[1])) ^ ((v_in[35]) & (b_in[0])))));
assign v_out[21] = v_in[37];
assign z_out[21] = ((((z_in[21]) ^ ((v_in[21]) & (b_in[15]))) ^ (((v_in[22]) & (b_in[14])) ^ ((v_in[23]) & (b_in[13])))) ^ ((((v_in[25]) & (b_in[11])) ^ ((v_in[24]) & (b_in[12]))) ^ (((v_in[26]) & (b_in[10])) ^ ((v_in[27]) & (b_in[9]))))) ^ ((((((v_in[31]) & (b_in[5])) ^ ((v_in[30]) & (b_in[6]))) ^ ((v_in[32]) & (b_in[4]))) ^ (((v_in[29]) & (b_in[7])) ^ ((v_in[28]) & (b_in[8])))) ^ ((((v_in[34]) & (b_in[2])) ^ ((v_in[33]) & (b_in[3]))) ^ (((v_in[35]) & (b_in[1])) ^ ((v_in[36]) & (b_in[0])))));
assign v_out[22] = v_in[38];
assign z_out[22] = ((((z_in[22]) ^ ((v_in[22]) & (b_in[15]))) ^ (((v_in[23]) & (b_in[14])) ^ ((v_in[24]) & (b_in[13])))) ^ ((((v_in[26]) & (b_in[11])) ^ ((v_in[25]) & (b_in[12]))) ^ (((v_in[27]) & (b_in[10])) ^ ((v_in[28]) & (b_in[9]))))) ^ ((((((v_in[32]) & (b_in[5])) ^ ((v_in[31]) & (b_in[6]))) ^ ((v_in[33]) & (b_in[4]))) ^ (((v_in[30]) & (b_in[7])) ^ ((v_in[29]) & (b_in[8])))) ^ ((((v_in[35]) & (b_in[2])) ^ ((v_in[34]) & (b_in[3]))) ^ (((v_in[36]) & (b_in[1])) ^ ((v_in[37]) & (b_in[0])))));
assign v_out[23] = v_in[39];
assign z_out[23] = ((((z_in[23]) ^ ((v_in[23]) & (b_in[15]))) ^ (((v_in[24]) & (b_in[14])) ^ ((v_in[25]) & (b_in[13])))) ^ ((((v_in[27]) & (b_in[11])) ^ ((v_in[26]) & (b_in[12]))) ^ (((v_in[28]) & (b_in[10])) ^ ((v_in[29]) & (b_in[9]))))) ^ ((((((v_in[33]) & (b_in[5])) ^ ((v_in[32]) & (b_in[6]))) ^ ((v_in[34]) & (b_in[4]))) ^ (((v_in[31]) & (b_in[7])) ^ ((v_in[30]) & (b_in[8])))) ^ ((((v_in[36]) & (b_in[2])) ^ ((v_in[35]) & (b_in[3]))) ^ (((v_in[37]) & (b_in[1])) ^ ((v_in[38]) & (b_in[0])))));
assign v_out[24] = v_in[40];
assign z_out[24] = ((((z_in[24]) ^ ((v_in[24]) & (b_in[15]))) ^ (((v_in[25]) & (b_in[14])) ^ ((v_in[26]) & (b_in[13])))) ^ ((((v_in[28]) & (b_in[11])) ^ ((v_in[27]) & (b_in[12]))) ^ (((v_in[29]) & (b_in[10])) ^ ((v_in[30]) & (b_in[9]))))) ^ ((((((v_in[34]) & (b_in[5])) ^ ((v_in[33]) & (b_in[6]))) ^ ((v_in[35]) & (b_in[4]))) ^ (((v_in[32]) & (b_in[7])) ^ ((v_in[31]) & (b_in[8])))) ^ ((((v_in[37]) & (b_in[2])) ^ ((v_in[36]) & (b_in[3]))) ^ (((v_in[38]) & (b_in[1])) ^ ((v_in[39]) & (b_in[0])))));
assign v_out[25] = v_in[41];
assign z_out[25] = ((((z_in[25]) ^ ((v_in[25]) & (b_in[15]))) ^ (((v_in[26]) & (b_in[14])) ^ ((v_in[27]) & (b_in[13])))) ^ ((((v_in[29]) & (b_in[11])) ^ ((v_in[28]) & (b_in[12]))) ^ (((v_in[30]) & (b_in[10])) ^ ((v_in[31]) & (b_in[9]))))) ^ ((((((v_in[35]) & (b_in[5])) ^ ((v_in[34]) & (b_in[6]))) ^ ((v_in[36]) & (b_in[4]))) ^ (((v_in[33]) & (b_in[7])) ^ ((v_in[32]) & (b_in[8])))) ^ ((((v_in[38]) & (b_in[2])) ^ ((v_in[37]) & (b_in[3]))) ^ (((v_in[39]) & (b_in[1])) ^ ((v_in[40]) & (b_in[0])))));
assign v_out[26] = v_in[42];
assign z_out[26] = ((((z_in[26]) ^ ((v_in[26]) & (b_in[15]))) ^ (((v_in[27]) & (b_in[14])) ^ ((v_in[28]) & (b_in[13])))) ^ ((((v_in[30]) & (b_in[11])) ^ ((v_in[29]) & (b_in[12]))) ^ (((v_in[31]) & (b_in[10])) ^ ((v_in[32]) & (b_in[9]))))) ^ ((((((v_in[36]) & (b_in[5])) ^ ((v_in[35]) & (b_in[6]))) ^ ((v_in[37]) & (b_in[4]))) ^ (((v_in[34]) & (b_in[7])) ^ ((v_in[33]) & (b_in[8])))) ^ ((((v_in[39]) & (b_in[2])) ^ ((v_in[38]) & (b_in[3]))) ^ (((v_in[40]) & (b_in[1])) ^ ((v_in[41]) & (b_in[0])))));
assign v_out[27] = v_in[43];
assign z_out[27] = ((((z_in[27]) ^ ((v_in[27]) & (b_in[15]))) ^ (((v_in[28]) & (b_in[14])) ^ ((v_in[29]) & (b_in[13])))) ^ ((((v_in[31]) & (b_in[11])) ^ ((v_in[30]) & (b_in[12]))) ^ (((v_in[32]) & (b_in[10])) ^ ((v_in[33]) & (b_in[9]))))) ^ ((((((v_in[37]) & (b_in[5])) ^ ((v_in[36]) & (b_in[6]))) ^ ((v_in[38]) & (b_in[4]))) ^ (((v_in[35]) & (b_in[7])) ^ ((v_in[34]) & (b_in[8])))) ^ ((((v_in[40]) & (b_in[2])) ^ ((v_in[39]) & (b_in[3]))) ^ (((v_in[41]) & (b_in[1])) ^ ((v_in[42]) & (b_in[0])))));
assign v_out[28] = v_in[44];
assign z_out[28] = ((((z_in[28]) ^ ((v_in[28]) & (b_in[15]))) ^ (((v_in[29]) & (b_in[14])) ^ ((v_in[30]) & (b_in[13])))) ^ ((((v_in[32]) & (b_in[11])) ^ ((v_in[31]) & (b_in[12]))) ^ (((v_in[33]) & (b_in[10])) ^ ((v_in[34]) & (b_in[9]))))) ^ ((((((v_in[38]) & (b_in[5])) ^ ((v_in[37]) & (b_in[6]))) ^ ((v_in[39]) & (b_in[4]))) ^ (((v_in[36]) & (b_in[7])) ^ ((v_in[35]) & (b_in[8])))) ^ ((((v_in[41]) & (b_in[2])) ^ ((v_in[40]) & (b_in[3]))) ^ (((v_in[42]) & (b_in[1])) ^ ((v_in[43]) & (b_in[0])))));
assign v_out[29] = v_in[45];
assign z_out[29] = ((((z_in[29]) ^ ((v_in[29]) & (b_in[15]))) ^ (((v_in[30]) & (b_in[14])) ^ ((v_in[31]) & (b_in[13])))) ^ ((((v_in[33]) & (b_in[11])) ^ ((v_in[32]) & (b_in[12]))) ^ (((v_in[34]) & (b_in[10])) ^ ((v_in[35]) & (b_in[9]))))) ^ ((((((v_in[39]) & (b_in[5])) ^ ((v_in[38]) & (b_in[6]))) ^ ((v_in[40]) & (b_in[4]))) ^ (((v_in[37]) & (b_in[7])) ^ ((v_in[36]) & (b_in[8])))) ^ ((((v_in[42]) & (b_in[2])) ^ ((v_in[41]) & (b_in[3]))) ^ (((v_in[43]) & (b_in[1])) ^ ((v_in[44]) & (b_in[0])))));
assign v_out[30] = v_in[46];
assign z_out[30] = ((((z_in[30]) ^ ((v_in[30]) & (b_in[15]))) ^ (((v_in[31]) & (b_in[14])) ^ ((v_in[32]) & (b_in[13])))) ^ ((((v_in[34]) & (b_in[11])) ^ ((v_in[33]) & (b_in[12]))) ^ (((v_in[35]) & (b_in[10])) ^ ((v_in[36]) & (b_in[9]))))) ^ ((((((v_in[40]) & (b_in[5])) ^ ((v_in[39]) & (b_in[6]))) ^ ((v_in[41]) & (b_in[4]))) ^ (((v_in[38]) & (b_in[7])) ^ ((v_in[37]) & (b_in[8])))) ^ ((((v_in[43]) & (b_in[2])) ^ ((v_in[42]) & (b_in[3]))) ^ (((v_in[44]) & (b_in[1])) ^ ((v_in[45]) & (b_in[0])))));
assign v_out[31] = v_in[47];
assign z_out[31] = ((((z_in[31]) ^ ((v_in[31]) & (b_in[15]))) ^ (((v_in[32]) & (b_in[14])) ^ ((v_in[33]) & (b_in[13])))) ^ ((((v_in[35]) & (b_in[11])) ^ ((v_in[34]) & (b_in[12]))) ^ (((v_in[36]) & (b_in[10])) ^ ((v_in[37]) & (b_in[9]))))) ^ ((((((v_in[41]) & (b_in[5])) ^ ((v_in[40]) & (b_in[6]))) ^ ((v_in[42]) & (b_in[4]))) ^ (((v_in[39]) & (b_in[7])) ^ ((v_in[38]) & (b_in[8])))) ^ ((((v_in[44]) & (b_in[2])) ^ ((v_in[43]) & (b_in[3]))) ^ (((v_in[45]) & (b_in[1])) ^ ((v_in[46]) & (b_in[0])))));
assign v_out[32] = v_in[48];
assign z_out[32] = ((((z_in[32]) ^ ((v_in[32]) & (b_in[15]))) ^ (((v_in[33]) & (b_in[14])) ^ ((v_in[34]) & (b_in[13])))) ^ ((((v_in[36]) & (b_in[11])) ^ ((v_in[35]) & (b_in[12]))) ^ (((v_in[37]) & (b_in[10])) ^ ((v_in[38]) & (b_in[9]))))) ^ ((((((v_in[42]) & (b_in[5])) ^ ((v_in[41]) & (b_in[6]))) ^ ((v_in[43]) & (b_in[4]))) ^ (((v_in[40]) & (b_in[7])) ^ ((v_in[39]) & (b_in[8])))) ^ ((((v_in[45]) & (b_in[2])) ^ ((v_in[44]) & (b_in[3]))) ^ (((v_in[46]) & (b_in[1])) ^ ((v_in[47]) & (b_in[0])))));
assign v_out[33] = v_in[49];
assign z_out[33] = ((((z_in[33]) ^ ((v_in[33]) & (b_in[15]))) ^ (((v_in[34]) & (b_in[14])) ^ ((v_in[35]) & (b_in[13])))) ^ ((((v_in[37]) & (b_in[11])) ^ ((v_in[36]) & (b_in[12]))) ^ (((v_in[38]) & (b_in[10])) ^ ((v_in[39]) & (b_in[9]))))) ^ ((((((v_in[43]) & (b_in[5])) ^ ((v_in[42]) & (b_in[6]))) ^ ((v_in[44]) & (b_in[4]))) ^ (((v_in[41]) & (b_in[7])) ^ ((v_in[40]) & (b_in[8])))) ^ ((((v_in[46]) & (b_in[2])) ^ ((v_in[45]) & (b_in[3]))) ^ (((v_in[47]) & (b_in[1])) ^ ((v_in[48]) & (b_in[0])))));
assign v_out[34] = v_in[50];
assign z_out[34] = ((((z_in[34]) ^ ((v_in[34]) & (b_in[15]))) ^ (((v_in[35]) & (b_in[14])) ^ ((v_in[36]) & (b_in[13])))) ^ ((((v_in[38]) & (b_in[11])) ^ ((v_in[37]) & (b_in[12]))) ^ (((v_in[39]) & (b_in[10])) ^ ((v_in[40]) & (b_in[9]))))) ^ ((((((v_in[44]) & (b_in[5])) ^ ((v_in[43]) & (b_in[6]))) ^ ((v_in[45]) & (b_in[4]))) ^ (((v_in[42]) & (b_in[7])) ^ ((v_in[41]) & (b_in[8])))) ^ ((((v_in[47]) & (b_in[2])) ^ ((v_in[46]) & (b_in[3]))) ^ (((v_in[48]) & (b_in[1])) ^ ((v_in[49]) & (b_in[0])))));
assign v_out[35] = v_in[51];
assign z_out[35] = ((((z_in[35]) ^ ((v_in[35]) & (b_in[15]))) ^ (((v_in[36]) & (b_in[14])) ^ ((v_in[37]) & (b_in[13])))) ^ ((((v_in[39]) & (b_in[11])) ^ ((v_in[38]) & (b_in[12]))) ^ (((v_in[40]) & (b_in[10])) ^ ((v_in[41]) & (b_in[9]))))) ^ ((((((v_in[45]) & (b_in[5])) ^ ((v_in[44]) & (b_in[6]))) ^ ((v_in[46]) & (b_in[4]))) ^ (((v_in[43]) & (b_in[7])) ^ ((v_in[42]) & (b_in[8])))) ^ ((((v_in[48]) & (b_in[2])) ^ ((v_in[47]) & (b_in[3]))) ^ (((v_in[49]) & (b_in[1])) ^ ((v_in[50]) & (b_in[0])))));
assign v_out[36] = v_in[52];
assign z_out[36] = ((((z_in[36]) ^ ((v_in[36]) & (b_in[15]))) ^ (((v_in[37]) & (b_in[14])) ^ ((v_in[38]) & (b_in[13])))) ^ ((((v_in[40]) & (b_in[11])) ^ ((v_in[39]) & (b_in[12]))) ^ (((v_in[41]) & (b_in[10])) ^ ((v_in[42]) & (b_in[9]))))) ^ ((((((v_in[46]) & (b_in[5])) ^ ((v_in[45]) & (b_in[6]))) ^ ((v_in[47]) & (b_in[4]))) ^ (((v_in[44]) & (b_in[7])) ^ ((v_in[43]) & (b_in[8])))) ^ ((((v_in[49]) & (b_in[2])) ^ ((v_in[48]) & (b_in[3]))) ^ (((v_in[50]) & (b_in[1])) ^ ((v_in[51]) & (b_in[0])))));
assign v_out[37] = v_in[53];
assign z_out[37] = ((((z_in[37]) ^ ((v_in[37]) & (b_in[15]))) ^ (((v_in[38]) & (b_in[14])) ^ ((v_in[39]) & (b_in[13])))) ^ ((((v_in[41]) & (b_in[11])) ^ ((v_in[40]) & (b_in[12]))) ^ (((v_in[42]) & (b_in[10])) ^ ((v_in[43]) & (b_in[9]))))) ^ ((((((v_in[47]) & (b_in[5])) ^ ((v_in[46]) & (b_in[6]))) ^ ((v_in[48]) & (b_in[4]))) ^ (((v_in[45]) & (b_in[7])) ^ ((v_in[44]) & (b_in[8])))) ^ ((((v_in[50]) & (b_in[2])) ^ ((v_in[49]) & (b_in[3]))) ^ (((v_in[51]) & (b_in[1])) ^ ((v_in[52]) & (b_in[0])))));
assign v_out[38] = v_in[54];
assign z_out[38] = ((((z_in[38]) ^ ((v_in[38]) & (b_in[15]))) ^ (((v_in[39]) & (b_in[14])) ^ ((v_in[40]) & (b_in[13])))) ^ ((((v_in[42]) & (b_in[11])) ^ ((v_in[41]) & (b_in[12]))) ^ (((v_in[43]) & (b_in[10])) ^ ((v_in[44]) & (b_in[9]))))) ^ ((((((v_in[48]) & (b_in[5])) ^ ((v_in[47]) & (b_in[6]))) ^ ((v_in[49]) & (b_in[4]))) ^ (((v_in[46]) & (b_in[7])) ^ ((v_in[45]) & (b_in[8])))) ^ ((((v_in[51]) & (b_in[2])) ^ ((v_in[50]) & (b_in[3]))) ^ (((v_in[52]) & (b_in[1])) ^ ((v_in[53]) & (b_in[0])))));
assign v_out[39] = v_in[55];
assign z_out[39] = ((((z_in[39]) ^ ((v_in[39]) & (b_in[15]))) ^ (((v_in[40]) & (b_in[14])) ^ ((v_in[41]) & (b_in[13])))) ^ ((((v_in[43]) & (b_in[11])) ^ ((v_in[42]) & (b_in[12]))) ^ (((v_in[44]) & (b_in[10])) ^ ((v_in[45]) & (b_in[9]))))) ^ ((((((v_in[49]) & (b_in[5])) ^ ((v_in[48]) & (b_in[6]))) ^ ((v_in[50]) & (b_in[4]))) ^ (((v_in[47]) & (b_in[7])) ^ ((v_in[46]) & (b_in[8])))) ^ ((((v_in[52]) & (b_in[2])) ^ ((v_in[51]) & (b_in[3]))) ^ (((v_in[53]) & (b_in[1])) ^ ((v_in[54]) & (b_in[0])))));
assign v_out[40] = v_in[56];
assign z_out[40] = ((((z_in[40]) ^ ((v_in[40]) & (b_in[15]))) ^ (((v_in[41]) & (b_in[14])) ^ ((v_in[42]) & (b_in[13])))) ^ ((((v_in[44]) & (b_in[11])) ^ ((v_in[43]) & (b_in[12]))) ^ (((v_in[45]) & (b_in[10])) ^ ((v_in[46]) & (b_in[9]))))) ^ ((((((v_in[50]) & (b_in[5])) ^ ((v_in[49]) & (b_in[6]))) ^ ((v_in[51]) & (b_in[4]))) ^ (((v_in[48]) & (b_in[7])) ^ ((v_in[47]) & (b_in[8])))) ^ ((((v_in[53]) & (b_in[2])) ^ ((v_in[52]) & (b_in[3]))) ^ (((v_in[54]) & (b_in[1])) ^ ((v_in[55]) & (b_in[0])))));
assign v_out[41] = v_in[57];
assign z_out[41] = ((((z_in[41]) ^ ((v_in[41]) & (b_in[15]))) ^ (((v_in[42]) & (b_in[14])) ^ ((v_in[43]) & (b_in[13])))) ^ ((((v_in[45]) & (b_in[11])) ^ ((v_in[44]) & (b_in[12]))) ^ (((v_in[46]) & (b_in[10])) ^ ((v_in[47]) & (b_in[9]))))) ^ ((((((v_in[51]) & (b_in[5])) ^ ((v_in[50]) & (b_in[6]))) ^ ((v_in[52]) & (b_in[4]))) ^ (((v_in[49]) & (b_in[7])) ^ ((v_in[48]) & (b_in[8])))) ^ ((((v_in[54]) & (b_in[2])) ^ ((v_in[53]) & (b_in[3]))) ^ (((v_in[55]) & (b_in[1])) ^ ((v_in[56]) & (b_in[0])))));
assign v_out[42] = v_in[58];
assign z_out[42] = ((((z_in[42]) ^ ((v_in[42]) & (b_in[15]))) ^ (((v_in[43]) & (b_in[14])) ^ ((v_in[44]) & (b_in[13])))) ^ ((((v_in[46]) & (b_in[11])) ^ ((v_in[45]) & (b_in[12]))) ^ (((v_in[47]) & (b_in[10])) ^ ((v_in[48]) & (b_in[9]))))) ^ ((((((v_in[52]) & (b_in[5])) ^ ((v_in[51]) & (b_in[6]))) ^ ((v_in[53]) & (b_in[4]))) ^ (((v_in[50]) & (b_in[7])) ^ ((v_in[49]) & (b_in[8])))) ^ ((((v_in[55]) & (b_in[2])) ^ ((v_in[54]) & (b_in[3]))) ^ (((v_in[56]) & (b_in[1])) ^ ((v_in[57]) & (b_in[0])))));
assign v_out[43] = v_in[59];
assign z_out[43] = ((((z_in[43]) ^ ((v_in[43]) & (b_in[15]))) ^ (((v_in[44]) & (b_in[14])) ^ ((v_in[45]) & (b_in[13])))) ^ ((((v_in[47]) & (b_in[11])) ^ ((v_in[46]) & (b_in[12]))) ^ (((v_in[48]) & (b_in[10])) ^ ((v_in[49]) & (b_in[9]))))) ^ ((((((v_in[53]) & (b_in[5])) ^ ((v_in[52]) & (b_in[6]))) ^ ((v_in[54]) & (b_in[4]))) ^ (((v_in[51]) & (b_in[7])) ^ ((v_in[50]) & (b_in[8])))) ^ ((((v_in[56]) & (b_in[2])) ^ ((v_in[55]) & (b_in[3]))) ^ (((v_in[57]) & (b_in[1])) ^ ((v_in[58]) & (b_in[0])))));
assign v_out[44] = v_in[60];
assign z_out[44] = ((((z_in[44]) ^ ((v_in[44]) & (b_in[15]))) ^ (((v_in[45]) & (b_in[14])) ^ ((v_in[46]) & (b_in[13])))) ^ ((((v_in[48]) & (b_in[11])) ^ ((v_in[47]) & (b_in[12]))) ^ (((v_in[49]) & (b_in[10])) ^ ((v_in[50]) & (b_in[9]))))) ^ ((((((v_in[54]) & (b_in[5])) ^ ((v_in[53]) & (b_in[6]))) ^ ((v_in[55]) & (b_in[4]))) ^ (((v_in[52]) & (b_in[7])) ^ ((v_in[51]) & (b_in[8])))) ^ ((((v_in[57]) & (b_in[2])) ^ ((v_in[56]) & (b_in[3]))) ^ (((v_in[58]) & (b_in[1])) ^ ((v_in[59]) & (b_in[0])))));
assign v_out[45] = v_in[61];
assign z_out[45] = ((((z_in[45]) ^ ((v_in[45]) & (b_in[15]))) ^ (((v_in[46]) & (b_in[14])) ^ ((v_in[47]) & (b_in[13])))) ^ ((((v_in[49]) & (b_in[11])) ^ ((v_in[48]) & (b_in[12]))) ^ (((v_in[50]) & (b_in[10])) ^ ((v_in[51]) & (b_in[9]))))) ^ ((((((v_in[55]) & (b_in[5])) ^ ((v_in[54]) & (b_in[6]))) ^ ((v_in[56]) & (b_in[4]))) ^ (((v_in[53]) & (b_in[7])) ^ ((v_in[52]) & (b_in[8])))) ^ ((((v_in[58]) & (b_in[2])) ^ ((v_in[57]) & (b_in[3]))) ^ (((v_in[59]) & (b_in[1])) ^ ((v_in[60]) & (b_in[0])))));
assign v_out[46] = v_in[62];
assign z_out[46] = ((((z_in[46]) ^ ((v_in[46]) & (b_in[15]))) ^ (((v_in[47]) & (b_in[14])) ^ ((v_in[48]) & (b_in[13])))) ^ ((((v_in[50]) & (b_in[11])) ^ ((v_in[49]) & (b_in[12]))) ^ (((v_in[51]) & (b_in[10])) ^ ((v_in[52]) & (b_in[9]))))) ^ ((((((v_in[56]) & (b_in[5])) ^ ((v_in[55]) & (b_in[6]))) ^ ((v_in[57]) & (b_in[4]))) ^ (((v_in[54]) & (b_in[7])) ^ ((v_in[53]) & (b_in[8])))) ^ ((((v_in[59]) & (b_in[2])) ^ ((v_in[58]) & (b_in[3]))) ^ (((v_in[60]) & (b_in[1])) ^ ((v_in[61]) & (b_in[0])))));
assign v_out[47] = v_in[63];
assign z_out[47] = ((((z_in[47]) ^ ((v_in[47]) & (b_in[15]))) ^ (((v_in[48]) & (b_in[14])) ^ ((v_in[49]) & (b_in[13])))) ^ ((((v_in[51]) & (b_in[11])) ^ ((v_in[50]) & (b_in[12]))) ^ (((v_in[52]) & (b_in[10])) ^ ((v_in[53]) & (b_in[9]))))) ^ ((((((v_in[57]) & (b_in[5])) ^ ((v_in[56]) & (b_in[6]))) ^ ((v_in[58]) & (b_in[4]))) ^ (((v_in[55]) & (b_in[7])) ^ ((v_in[54]) & (b_in[8])))) ^ ((((v_in[60]) & (b_in[2])) ^ ((v_in[59]) & (b_in[3]))) ^ (((v_in[61]) & (b_in[1])) ^ ((v_in[62]) & (b_in[0])))));
assign v_out[48] = v_in[64];
assign z_out[48] = ((((z_in[48]) ^ ((v_in[48]) & (b_in[15]))) ^ (((v_in[49]) & (b_in[14])) ^ ((v_in[50]) & (b_in[13])))) ^ ((((v_in[52]) & (b_in[11])) ^ ((v_in[51]) & (b_in[12]))) ^ (((v_in[53]) & (b_in[10])) ^ ((v_in[54]) & (b_in[9]))))) ^ ((((((v_in[58]) & (b_in[5])) ^ ((v_in[57]) & (b_in[6]))) ^ ((v_in[59]) & (b_in[4]))) ^ (((v_in[56]) & (b_in[7])) ^ ((v_in[55]) & (b_in[8])))) ^ ((((v_in[61]) & (b_in[2])) ^ ((v_in[60]) & (b_in[3]))) ^ (((v_in[62]) & (b_in[1])) ^ ((v_in[63]) & (b_in[0])))));
assign v_out[49] = v_in[65];
assign z_out[49] = ((((z_in[49]) ^ ((v_in[49]) & (b_in[15]))) ^ (((v_in[50]) & (b_in[14])) ^ ((v_in[51]) & (b_in[13])))) ^ ((((v_in[53]) & (b_in[11])) ^ ((v_in[52]) & (b_in[12]))) ^ (((v_in[54]) & (b_in[10])) ^ ((v_in[55]) & (b_in[9]))))) ^ ((((((v_in[59]) & (b_in[5])) ^ ((v_in[58]) & (b_in[6]))) ^ ((v_in[60]) & (b_in[4]))) ^ (((v_in[57]) & (b_in[7])) ^ ((v_in[56]) & (b_in[8])))) ^ ((((v_in[62]) & (b_in[2])) ^ ((v_in[61]) & (b_in[3]))) ^ (((v_in[63]) & (b_in[1])) ^ ((v_in[64]) & (b_in[0])))));
assign v_out[50] = v_in[66];
assign z_out[50] = ((((z_in[50]) ^ ((v_in[50]) & (b_in[15]))) ^ (((v_in[51]) & (b_in[14])) ^ ((v_in[52]) & (b_in[13])))) ^ ((((v_in[54]) & (b_in[11])) ^ ((v_in[53]) & (b_in[12]))) ^ (((v_in[55]) & (b_in[10])) ^ ((v_in[56]) & (b_in[9]))))) ^ ((((((v_in[60]) & (b_in[5])) ^ ((v_in[59]) & (b_in[6]))) ^ ((v_in[61]) & (b_in[4]))) ^ (((v_in[58]) & (b_in[7])) ^ ((v_in[57]) & (b_in[8])))) ^ ((((v_in[63]) & (b_in[2])) ^ ((v_in[62]) & (b_in[3]))) ^ (((v_in[64]) & (b_in[1])) ^ ((v_in[65]) & (b_in[0])))));
assign v_out[51] = v_in[67];
assign z_out[51] = ((((z_in[51]) ^ ((v_in[51]) & (b_in[15]))) ^ (((v_in[52]) & (b_in[14])) ^ ((v_in[53]) & (b_in[13])))) ^ ((((v_in[55]) & (b_in[11])) ^ ((v_in[54]) & (b_in[12]))) ^ (((v_in[56]) & (b_in[10])) ^ ((v_in[57]) & (b_in[9]))))) ^ ((((((v_in[61]) & (b_in[5])) ^ ((v_in[60]) & (b_in[6]))) ^ ((v_in[62]) & (b_in[4]))) ^ (((v_in[59]) & (b_in[7])) ^ ((v_in[58]) & (b_in[8])))) ^ ((((v_in[64]) & (b_in[2])) ^ ((v_in[63]) & (b_in[3]))) ^ (((v_in[65]) & (b_in[1])) ^ ((v_in[66]) & (b_in[0])))));
assign v_out[52] = v_in[68];
assign z_out[52] = ((((z_in[52]) ^ ((v_in[52]) & (b_in[15]))) ^ (((v_in[53]) & (b_in[14])) ^ ((v_in[54]) & (b_in[13])))) ^ ((((v_in[56]) & (b_in[11])) ^ ((v_in[55]) & (b_in[12]))) ^ (((v_in[57]) & (b_in[10])) ^ ((v_in[58]) & (b_in[9]))))) ^ ((((((v_in[62]) & (b_in[5])) ^ ((v_in[61]) & (b_in[6]))) ^ ((v_in[63]) & (b_in[4]))) ^ (((v_in[60]) & (b_in[7])) ^ ((v_in[59]) & (b_in[8])))) ^ ((((v_in[65]) & (b_in[2])) ^ ((v_in[64]) & (b_in[3]))) ^ (((v_in[66]) & (b_in[1])) ^ ((v_in[67]) & (b_in[0])))));
assign v_out[53] = v_in[69];
assign z_out[53] = ((((z_in[53]) ^ ((v_in[53]) & (b_in[15]))) ^ (((v_in[54]) & (b_in[14])) ^ ((v_in[55]) & (b_in[13])))) ^ ((((v_in[57]) & (b_in[11])) ^ ((v_in[56]) & (b_in[12]))) ^ (((v_in[58]) & (b_in[10])) ^ ((v_in[59]) & (b_in[9]))))) ^ ((((((v_in[63]) & (b_in[5])) ^ ((v_in[62]) & (b_in[6]))) ^ ((v_in[64]) & (b_in[4]))) ^ (((v_in[61]) & (b_in[7])) ^ ((v_in[60]) & (b_in[8])))) ^ ((((v_in[66]) & (b_in[2])) ^ ((v_in[65]) & (b_in[3]))) ^ (((v_in[67]) & (b_in[1])) ^ ((v_in[68]) & (b_in[0])))));
assign v_out[54] = v_in[70];
assign z_out[54] = ((((z_in[54]) ^ ((v_in[54]) & (b_in[15]))) ^ (((v_in[55]) & (b_in[14])) ^ ((v_in[56]) & (b_in[13])))) ^ ((((v_in[58]) & (b_in[11])) ^ ((v_in[57]) & (b_in[12]))) ^ (((v_in[59]) & (b_in[10])) ^ ((v_in[60]) & (b_in[9]))))) ^ ((((((v_in[64]) & (b_in[5])) ^ ((v_in[63]) & (b_in[6]))) ^ ((v_in[65]) & (b_in[4]))) ^ (((v_in[62]) & (b_in[7])) ^ ((v_in[61]) & (b_in[8])))) ^ ((((v_in[67]) & (b_in[2])) ^ ((v_in[66]) & (b_in[3]))) ^ (((v_in[68]) & (b_in[1])) ^ ((v_in[69]) & (b_in[0])))));
assign v_out[55] = v_in[71];
assign z_out[55] = ((((z_in[55]) ^ ((v_in[55]) & (b_in[15]))) ^ (((v_in[56]) & (b_in[14])) ^ ((v_in[57]) & (b_in[13])))) ^ ((((v_in[59]) & (b_in[11])) ^ ((v_in[58]) & (b_in[12]))) ^ (((v_in[60]) & (b_in[10])) ^ ((v_in[61]) & (b_in[9]))))) ^ ((((((v_in[65]) & (b_in[5])) ^ ((v_in[64]) & (b_in[6]))) ^ ((v_in[66]) & (b_in[4]))) ^ (((v_in[63]) & (b_in[7])) ^ ((v_in[62]) & (b_in[8])))) ^ ((((v_in[68]) & (b_in[2])) ^ ((v_in[67]) & (b_in[3]))) ^ (((v_in[69]) & (b_in[1])) ^ ((v_in[70]) & (b_in[0])))));
assign v_out[56] = v_in[72];
assign z_out[56] = ((((z_in[56]) ^ ((v_in[56]) & (b_in[15]))) ^ (((v_in[57]) & (b_in[14])) ^ ((v_in[58]) & (b_in[13])))) ^ ((((v_in[60]) & (b_in[11])) ^ ((v_in[59]) & (b_in[12]))) ^ (((v_in[61]) & (b_in[10])) ^ ((v_in[62]) & (b_in[9]))))) ^ ((((((v_in[66]) & (b_in[5])) ^ ((v_in[65]) & (b_in[6]))) ^ ((v_in[67]) & (b_in[4]))) ^ (((v_in[64]) & (b_in[7])) ^ ((v_in[63]) & (b_in[8])))) ^ ((((v_in[69]) & (b_in[2])) ^ ((v_in[68]) & (b_in[3]))) ^ (((v_in[70]) & (b_in[1])) ^ ((v_in[71]) & (b_in[0])))));
assign v_out[57] = v_in[73];
assign z_out[57] = ((((z_in[57]) ^ ((v_in[57]) & (b_in[15]))) ^ (((v_in[58]) & (b_in[14])) ^ ((v_in[59]) & (b_in[13])))) ^ ((((v_in[61]) & (b_in[11])) ^ ((v_in[60]) & (b_in[12]))) ^ (((v_in[62]) & (b_in[10])) ^ ((v_in[63]) & (b_in[9]))))) ^ ((((((v_in[67]) & (b_in[5])) ^ ((v_in[66]) & (b_in[6]))) ^ ((v_in[68]) & (b_in[4]))) ^ (((v_in[65]) & (b_in[7])) ^ ((v_in[64]) & (b_in[8])))) ^ ((((v_in[70]) & (b_in[2])) ^ ((v_in[69]) & (b_in[3]))) ^ (((v_in[71]) & (b_in[1])) ^ ((v_in[72]) & (b_in[0])))));
assign v_out[58] = v_in[74];
assign z_out[58] = ((((z_in[58]) ^ ((v_in[58]) & (b_in[15]))) ^ (((v_in[59]) & (b_in[14])) ^ ((v_in[60]) & (b_in[13])))) ^ ((((v_in[62]) & (b_in[11])) ^ ((v_in[61]) & (b_in[12]))) ^ (((v_in[63]) & (b_in[10])) ^ ((v_in[64]) & (b_in[9]))))) ^ ((((((v_in[68]) & (b_in[5])) ^ ((v_in[67]) & (b_in[6]))) ^ ((v_in[69]) & (b_in[4]))) ^ (((v_in[66]) & (b_in[7])) ^ ((v_in[65]) & (b_in[8])))) ^ ((((v_in[71]) & (b_in[2])) ^ ((v_in[70]) & (b_in[3]))) ^ (((v_in[72]) & (b_in[1])) ^ ((v_in[73]) & (b_in[0])))));
assign v_out[59] = v_in[75];
assign z_out[59] = ((((z_in[59]) ^ ((v_in[59]) & (b_in[15]))) ^ (((v_in[60]) & (b_in[14])) ^ ((v_in[61]) & (b_in[13])))) ^ ((((v_in[63]) & (b_in[11])) ^ ((v_in[62]) & (b_in[12]))) ^ (((v_in[64]) & (b_in[10])) ^ ((v_in[65]) & (b_in[9]))))) ^ ((((((v_in[69]) & (b_in[5])) ^ ((v_in[68]) & (b_in[6]))) ^ ((v_in[70]) & (b_in[4]))) ^ (((v_in[67]) & (b_in[7])) ^ ((v_in[66]) & (b_in[8])))) ^ ((((v_in[72]) & (b_in[2])) ^ ((v_in[71]) & (b_in[3]))) ^ (((v_in[73]) & (b_in[1])) ^ ((v_in[74]) & (b_in[0])))));
assign v_out[60] = v_in[76];
assign z_out[60] = ((((z_in[60]) ^ ((v_in[60]) & (b_in[15]))) ^ (((v_in[61]) & (b_in[14])) ^ ((v_in[62]) & (b_in[13])))) ^ ((((v_in[64]) & (b_in[11])) ^ ((v_in[63]) & (b_in[12]))) ^ (((v_in[65]) & (b_in[10])) ^ ((v_in[66]) & (b_in[9]))))) ^ ((((((v_in[70]) & (b_in[5])) ^ ((v_in[69]) & (b_in[6]))) ^ ((v_in[71]) & (b_in[4]))) ^ (((v_in[68]) & (b_in[7])) ^ ((v_in[67]) & (b_in[8])))) ^ ((((v_in[73]) & (b_in[2])) ^ ((v_in[72]) & (b_in[3]))) ^ (((v_in[74]) & (b_in[1])) ^ ((v_in[75]) & (b_in[0])))));
assign v_out[61] = v_in[77];
assign z_out[61] = ((((z_in[61]) ^ ((v_in[61]) & (b_in[15]))) ^ (((v_in[62]) & (b_in[14])) ^ ((v_in[63]) & (b_in[13])))) ^ ((((v_in[65]) & (b_in[11])) ^ ((v_in[64]) & (b_in[12]))) ^ (((v_in[66]) & (b_in[10])) ^ ((v_in[67]) & (b_in[9]))))) ^ ((((((v_in[71]) & (b_in[5])) ^ ((v_in[70]) & (b_in[6]))) ^ ((v_in[72]) & (b_in[4]))) ^ (((v_in[69]) & (b_in[7])) ^ ((v_in[68]) & (b_in[8])))) ^ ((((v_in[74]) & (b_in[2])) ^ ((v_in[73]) & (b_in[3]))) ^ (((v_in[75]) & (b_in[1])) ^ ((v_in[76]) & (b_in[0])))));
assign v_out[62] = v_in[78];
assign z_out[62] = ((((z_in[62]) ^ ((v_in[62]) & (b_in[15]))) ^ (((v_in[63]) & (b_in[14])) ^ ((v_in[64]) & (b_in[13])))) ^ ((((v_in[66]) & (b_in[11])) ^ ((v_in[65]) & (b_in[12]))) ^ (((v_in[67]) & (b_in[10])) ^ ((v_in[68]) & (b_in[9]))))) ^ ((((((v_in[72]) & (b_in[5])) ^ ((v_in[71]) & (b_in[6]))) ^ ((v_in[73]) & (b_in[4]))) ^ (((v_in[70]) & (b_in[7])) ^ ((v_in[69]) & (b_in[8])))) ^ ((((v_in[75]) & (b_in[2])) ^ ((v_in[74]) & (b_in[3]))) ^ (((v_in[76]) & (b_in[1])) ^ ((v_in[77]) & (b_in[0])))));
assign v_out[63] = v_in[79];
assign z_out[63] = ((((z_in[63]) ^ ((v_in[63]) & (b_in[15]))) ^ (((v_in[64]) & (b_in[14])) ^ ((v_in[65]) & (b_in[13])))) ^ ((((v_in[67]) & (b_in[11])) ^ ((v_in[66]) & (b_in[12]))) ^ (((v_in[68]) & (b_in[10])) ^ ((v_in[69]) & (b_in[9]))))) ^ ((((((v_in[73]) & (b_in[5])) ^ ((v_in[72]) & (b_in[6]))) ^ ((v_in[74]) & (b_in[4]))) ^ (((v_in[71]) & (b_in[7])) ^ ((v_in[70]) & (b_in[8])))) ^ ((((v_in[76]) & (b_in[2])) ^ ((v_in[75]) & (b_in[3]))) ^ (((v_in[77]) & (b_in[1])) ^ ((v_in[78]) & (b_in[0])))));
assign v_out[64] = v_in[80];
assign z_out[64] = ((((z_in[64]) ^ ((v_in[64]) & (b_in[15]))) ^ (((v_in[65]) & (b_in[14])) ^ ((v_in[66]) & (b_in[13])))) ^ ((((v_in[68]) & (b_in[11])) ^ ((v_in[67]) & (b_in[12]))) ^ (((v_in[69]) & (b_in[10])) ^ ((v_in[70]) & (b_in[9]))))) ^ ((((((v_in[74]) & (b_in[5])) ^ ((v_in[73]) & (b_in[6]))) ^ ((v_in[75]) & (b_in[4]))) ^ (((v_in[72]) & (b_in[7])) ^ ((v_in[71]) & (b_in[8])))) ^ ((((v_in[77]) & (b_in[2])) ^ ((v_in[76]) & (b_in[3]))) ^ (((v_in[78]) & (b_in[1])) ^ ((v_in[79]) & (b_in[0])))));
assign v_out[65] = v_in[81];
assign z_out[65] = ((((z_in[65]) ^ ((v_in[65]) & (b_in[15]))) ^ (((v_in[66]) & (b_in[14])) ^ ((v_in[67]) & (b_in[13])))) ^ ((((v_in[69]) & (b_in[11])) ^ ((v_in[68]) & (b_in[12]))) ^ (((v_in[70]) & (b_in[10])) ^ ((v_in[71]) & (b_in[9]))))) ^ ((((((v_in[75]) & (b_in[5])) ^ ((v_in[74]) & (b_in[6]))) ^ ((v_in[76]) & (b_in[4]))) ^ (((v_in[73]) & (b_in[7])) ^ ((v_in[72]) & (b_in[8])))) ^ ((((v_in[78]) & (b_in[2])) ^ ((v_in[77]) & (b_in[3]))) ^ (((v_in[79]) & (b_in[1])) ^ ((v_in[80]) & (b_in[0])))));
assign v_out[66] = v_in[82];
assign z_out[66] = ((((z_in[66]) ^ ((v_in[66]) & (b_in[15]))) ^ (((v_in[67]) & (b_in[14])) ^ ((v_in[68]) & (b_in[13])))) ^ ((((v_in[70]) & (b_in[11])) ^ ((v_in[69]) & (b_in[12]))) ^ (((v_in[71]) & (b_in[10])) ^ ((v_in[72]) & (b_in[9]))))) ^ ((((((v_in[76]) & (b_in[5])) ^ ((v_in[75]) & (b_in[6]))) ^ ((v_in[77]) & (b_in[4]))) ^ (((v_in[74]) & (b_in[7])) ^ ((v_in[73]) & (b_in[8])))) ^ ((((v_in[79]) & (b_in[2])) ^ ((v_in[78]) & (b_in[3]))) ^ (((v_in[80]) & (b_in[1])) ^ ((v_in[81]) & (b_in[0])))));
assign v_out[67] = v_in[83];
assign z_out[67] = ((((z_in[67]) ^ ((v_in[67]) & (b_in[15]))) ^ (((v_in[68]) & (b_in[14])) ^ ((v_in[69]) & (b_in[13])))) ^ ((((v_in[71]) & (b_in[11])) ^ ((v_in[70]) & (b_in[12]))) ^ (((v_in[72]) & (b_in[10])) ^ ((v_in[73]) & (b_in[9]))))) ^ ((((((v_in[77]) & (b_in[5])) ^ ((v_in[76]) & (b_in[6]))) ^ ((v_in[78]) & (b_in[4]))) ^ (((v_in[75]) & (b_in[7])) ^ ((v_in[74]) & (b_in[8])))) ^ ((((v_in[80]) & (b_in[2])) ^ ((v_in[79]) & (b_in[3]))) ^ (((v_in[81]) & (b_in[1])) ^ ((v_in[82]) & (b_in[0])))));
assign v_out[68] = v_in[84];
assign z_out[68] = ((((z_in[68]) ^ ((v_in[68]) & (b_in[15]))) ^ (((v_in[69]) & (b_in[14])) ^ ((v_in[70]) & (b_in[13])))) ^ ((((v_in[72]) & (b_in[11])) ^ ((v_in[71]) & (b_in[12]))) ^ (((v_in[73]) & (b_in[10])) ^ ((v_in[74]) & (b_in[9]))))) ^ ((((((v_in[78]) & (b_in[5])) ^ ((v_in[77]) & (b_in[6]))) ^ ((v_in[79]) & (b_in[4]))) ^ (((v_in[76]) & (b_in[7])) ^ ((v_in[75]) & (b_in[8])))) ^ ((((v_in[81]) & (b_in[2])) ^ ((v_in[80]) & (b_in[3]))) ^ (((v_in[82]) & (b_in[1])) ^ ((v_in[83]) & (b_in[0])))));
assign v_out[69] = v_in[85];
assign z_out[69] = ((((z_in[69]) ^ ((v_in[69]) & (b_in[15]))) ^ (((v_in[70]) & (b_in[14])) ^ ((v_in[71]) & (b_in[13])))) ^ ((((v_in[73]) & (b_in[11])) ^ ((v_in[72]) & (b_in[12]))) ^ (((v_in[74]) & (b_in[10])) ^ ((v_in[75]) & (b_in[9]))))) ^ ((((((v_in[79]) & (b_in[5])) ^ ((v_in[78]) & (b_in[6]))) ^ ((v_in[80]) & (b_in[4]))) ^ (((v_in[77]) & (b_in[7])) ^ ((v_in[76]) & (b_in[8])))) ^ ((((v_in[82]) & (b_in[2])) ^ ((v_in[81]) & (b_in[3]))) ^ (((v_in[83]) & (b_in[1])) ^ ((v_in[84]) & (b_in[0])))));
assign v_out[70] = v_in[86];
assign z_out[70] = ((((z_in[70]) ^ ((v_in[70]) & (b_in[15]))) ^ (((v_in[71]) & (b_in[14])) ^ ((v_in[72]) & (b_in[13])))) ^ ((((v_in[74]) & (b_in[11])) ^ ((v_in[73]) & (b_in[12]))) ^ (((v_in[75]) & (b_in[10])) ^ ((v_in[76]) & (b_in[9]))))) ^ ((((((v_in[80]) & (b_in[5])) ^ ((v_in[79]) & (b_in[6]))) ^ ((v_in[81]) & (b_in[4]))) ^ (((v_in[78]) & (b_in[7])) ^ ((v_in[77]) & (b_in[8])))) ^ ((((v_in[83]) & (b_in[2])) ^ ((v_in[82]) & (b_in[3]))) ^ (((v_in[84]) & (b_in[1])) ^ ((v_in[85]) & (b_in[0])))));
assign v_out[71] = v_in[87];
assign z_out[71] = ((((z_in[71]) ^ ((v_in[71]) & (b_in[15]))) ^ (((v_in[72]) & (b_in[14])) ^ ((v_in[73]) & (b_in[13])))) ^ ((((v_in[75]) & (b_in[11])) ^ ((v_in[74]) & (b_in[12]))) ^ (((v_in[76]) & (b_in[10])) ^ ((v_in[77]) & (b_in[9]))))) ^ ((((((v_in[81]) & (b_in[5])) ^ ((v_in[80]) & (b_in[6]))) ^ ((v_in[82]) & (b_in[4]))) ^ (((v_in[79]) & (b_in[7])) ^ ((v_in[78]) & (b_in[8])))) ^ ((((v_in[84]) & (b_in[2])) ^ ((v_in[83]) & (b_in[3]))) ^ (((v_in[85]) & (b_in[1])) ^ ((v_in[86]) & (b_in[0])))));
assign v_out[72] = v_in[88];
assign z_out[72] = ((((z_in[72]) ^ ((v_in[72]) & (b_in[15]))) ^ (((v_in[73]) & (b_in[14])) ^ ((v_in[74]) & (b_in[13])))) ^ ((((v_in[76]) & (b_in[11])) ^ ((v_in[75]) & (b_in[12]))) ^ (((v_in[77]) & (b_in[10])) ^ ((v_in[78]) & (b_in[9]))))) ^ ((((((v_in[82]) & (b_in[5])) ^ ((v_in[81]) & (b_in[6]))) ^ ((v_in[83]) & (b_in[4]))) ^ (((v_in[80]) & (b_in[7])) ^ ((v_in[79]) & (b_in[8])))) ^ ((((v_in[85]) & (b_in[2])) ^ ((v_in[84]) & (b_in[3]))) ^ (((v_in[86]) & (b_in[1])) ^ ((v_in[87]) & (b_in[0])))));
assign v_out[73] = v_in[89];
assign z_out[73] = ((((z_in[73]) ^ ((v_in[73]) & (b_in[15]))) ^ (((v_in[74]) & (b_in[14])) ^ ((v_in[75]) & (b_in[13])))) ^ ((((v_in[77]) & (b_in[11])) ^ ((v_in[76]) & (b_in[12]))) ^ (((v_in[78]) & (b_in[10])) ^ ((v_in[79]) & (b_in[9]))))) ^ ((((((v_in[83]) & (b_in[5])) ^ ((v_in[82]) & (b_in[6]))) ^ ((v_in[84]) & (b_in[4]))) ^ (((v_in[81]) & (b_in[7])) ^ ((v_in[80]) & (b_in[8])))) ^ ((((v_in[86]) & (b_in[2])) ^ ((v_in[85]) & (b_in[3]))) ^ (((v_in[87]) & (b_in[1])) ^ ((v_in[88]) & (b_in[0])))));
assign v_out[74] = v_in[90];
assign z_out[74] = ((((z_in[74]) ^ ((v_in[74]) & (b_in[15]))) ^ (((v_in[75]) & (b_in[14])) ^ ((v_in[76]) & (b_in[13])))) ^ ((((v_in[78]) & (b_in[11])) ^ ((v_in[77]) & (b_in[12]))) ^ (((v_in[79]) & (b_in[10])) ^ ((v_in[80]) & (b_in[9]))))) ^ ((((((v_in[84]) & (b_in[5])) ^ ((v_in[83]) & (b_in[6]))) ^ ((v_in[85]) & (b_in[4]))) ^ (((v_in[82]) & (b_in[7])) ^ ((v_in[81]) & (b_in[8])))) ^ ((((v_in[87]) & (b_in[2])) ^ ((v_in[86]) & (b_in[3]))) ^ (((v_in[88]) & (b_in[1])) ^ ((v_in[89]) & (b_in[0])))));
assign v_out[75] = v_in[91];
assign z_out[75] = ((((z_in[75]) ^ ((v_in[75]) & (b_in[15]))) ^ (((v_in[76]) & (b_in[14])) ^ ((v_in[77]) & (b_in[13])))) ^ ((((v_in[79]) & (b_in[11])) ^ ((v_in[78]) & (b_in[12]))) ^ (((v_in[80]) & (b_in[10])) ^ ((v_in[81]) & (b_in[9]))))) ^ ((((((v_in[85]) & (b_in[5])) ^ ((v_in[84]) & (b_in[6]))) ^ ((v_in[86]) & (b_in[4]))) ^ (((v_in[83]) & (b_in[7])) ^ ((v_in[82]) & (b_in[8])))) ^ ((((v_in[88]) & (b_in[2])) ^ ((v_in[87]) & (b_in[3]))) ^ (((v_in[89]) & (b_in[1])) ^ ((v_in[90]) & (b_in[0])))));
assign v_out[76] = v_in[92];
assign z_out[76] = ((((z_in[76]) ^ ((v_in[76]) & (b_in[15]))) ^ (((v_in[77]) & (b_in[14])) ^ ((v_in[78]) & (b_in[13])))) ^ ((((v_in[80]) & (b_in[11])) ^ ((v_in[79]) & (b_in[12]))) ^ (((v_in[81]) & (b_in[10])) ^ ((v_in[82]) & (b_in[9]))))) ^ ((((((v_in[86]) & (b_in[5])) ^ ((v_in[85]) & (b_in[6]))) ^ ((v_in[87]) & (b_in[4]))) ^ (((v_in[84]) & (b_in[7])) ^ ((v_in[83]) & (b_in[8])))) ^ ((((v_in[89]) & (b_in[2])) ^ ((v_in[88]) & (b_in[3]))) ^ (((v_in[90]) & (b_in[1])) ^ ((v_in[91]) & (b_in[0])))));
assign v_out[77] = v_in[93];
assign z_out[77] = ((((z_in[77]) ^ ((v_in[77]) & (b_in[15]))) ^ (((v_in[78]) & (b_in[14])) ^ ((v_in[79]) & (b_in[13])))) ^ ((((v_in[81]) & (b_in[11])) ^ ((v_in[80]) & (b_in[12]))) ^ (((v_in[82]) & (b_in[10])) ^ ((v_in[83]) & (b_in[9]))))) ^ ((((((v_in[87]) & (b_in[5])) ^ ((v_in[86]) & (b_in[6]))) ^ ((v_in[88]) & (b_in[4]))) ^ (((v_in[85]) & (b_in[7])) ^ ((v_in[84]) & (b_in[8])))) ^ ((((v_in[90]) & (b_in[2])) ^ ((v_in[89]) & (b_in[3]))) ^ (((v_in[91]) & (b_in[1])) ^ ((v_in[92]) & (b_in[0])))));
assign v_out[78] = v_in[94];
assign z_out[78] = ((((z_in[78]) ^ ((v_in[78]) & (b_in[15]))) ^ (((v_in[79]) & (b_in[14])) ^ ((v_in[80]) & (b_in[13])))) ^ ((((v_in[82]) & (b_in[11])) ^ ((v_in[81]) & (b_in[12]))) ^ (((v_in[83]) & (b_in[10])) ^ ((v_in[84]) & (b_in[9]))))) ^ ((((((v_in[88]) & (b_in[5])) ^ ((v_in[87]) & (b_in[6]))) ^ ((v_in[89]) & (b_in[4]))) ^ (((v_in[86]) & (b_in[7])) ^ ((v_in[85]) & (b_in[8])))) ^ ((((v_in[91]) & (b_in[2])) ^ ((v_in[90]) & (b_in[3]))) ^ (((v_in[92]) & (b_in[1])) ^ ((v_in[93]) & (b_in[0])))));
assign v_out[79] = v_in[95];
assign z_out[79] = ((((z_in[79]) ^ ((v_in[79]) & (b_in[15]))) ^ (((v_in[80]) & (b_in[14])) ^ ((v_in[81]) & (b_in[13])))) ^ ((((v_in[83]) & (b_in[11])) ^ ((v_in[82]) & (b_in[12]))) ^ (((v_in[84]) & (b_in[10])) ^ ((v_in[85]) & (b_in[9]))))) ^ ((((((v_in[89]) & (b_in[5])) ^ ((v_in[88]) & (b_in[6]))) ^ ((v_in[90]) & (b_in[4]))) ^ (((v_in[87]) & (b_in[7])) ^ ((v_in[86]) & (b_in[8])))) ^ ((((v_in[92]) & (b_in[2])) ^ ((v_in[91]) & (b_in[3]))) ^ (((v_in[93]) & (b_in[1])) ^ ((v_in[94]) & (b_in[0])))));
assign v_out[80] = v_in[96];
assign z_out[80] = ((((z_in[80]) ^ ((v_in[80]) & (b_in[15]))) ^ (((v_in[81]) & (b_in[14])) ^ ((v_in[82]) & (b_in[13])))) ^ ((((v_in[84]) & (b_in[11])) ^ ((v_in[83]) & (b_in[12]))) ^ (((v_in[85]) & (b_in[10])) ^ ((v_in[86]) & (b_in[9]))))) ^ ((((((v_in[90]) & (b_in[5])) ^ ((v_in[89]) & (b_in[6]))) ^ ((v_in[91]) & (b_in[4]))) ^ (((v_in[88]) & (b_in[7])) ^ ((v_in[87]) & (b_in[8])))) ^ ((((v_in[93]) & (b_in[2])) ^ ((v_in[92]) & (b_in[3]))) ^ (((v_in[94]) & (b_in[1])) ^ ((v_in[95]) & (b_in[0])))));
assign v_out[81] = v_in[97];
assign z_out[81] = ((((z_in[81]) ^ ((v_in[81]) & (b_in[15]))) ^ (((v_in[82]) & (b_in[14])) ^ ((v_in[83]) & (b_in[13])))) ^ ((((v_in[85]) & (b_in[11])) ^ ((v_in[84]) & (b_in[12]))) ^ (((v_in[86]) & (b_in[10])) ^ ((v_in[87]) & (b_in[9]))))) ^ ((((((v_in[91]) & (b_in[5])) ^ ((v_in[90]) & (b_in[6]))) ^ ((v_in[92]) & (b_in[4]))) ^ (((v_in[89]) & (b_in[7])) ^ ((v_in[88]) & (b_in[8])))) ^ ((((v_in[94]) & (b_in[2])) ^ ((v_in[93]) & (b_in[3]))) ^ (((v_in[95]) & (b_in[1])) ^ ((v_in[96]) & (b_in[0])))));
assign v_out[82] = v_in[98];
assign z_out[82] = ((((z_in[82]) ^ ((v_in[82]) & (b_in[15]))) ^ (((v_in[83]) & (b_in[14])) ^ ((v_in[84]) & (b_in[13])))) ^ ((((v_in[86]) & (b_in[11])) ^ ((v_in[85]) & (b_in[12]))) ^ (((v_in[87]) & (b_in[10])) ^ ((v_in[88]) & (b_in[9]))))) ^ ((((((v_in[92]) & (b_in[5])) ^ ((v_in[91]) & (b_in[6]))) ^ ((v_in[93]) & (b_in[4]))) ^ (((v_in[90]) & (b_in[7])) ^ ((v_in[89]) & (b_in[8])))) ^ ((((v_in[95]) & (b_in[2])) ^ ((v_in[94]) & (b_in[3]))) ^ (((v_in[96]) & (b_in[1])) ^ ((v_in[97]) & (b_in[0])))));
assign v_out[83] = v_in[99];
assign z_out[83] = ((((z_in[83]) ^ ((v_in[83]) & (b_in[15]))) ^ (((v_in[84]) & (b_in[14])) ^ ((v_in[85]) & (b_in[13])))) ^ ((((v_in[87]) & (b_in[11])) ^ ((v_in[86]) & (b_in[12]))) ^ (((v_in[88]) & (b_in[10])) ^ ((v_in[89]) & (b_in[9]))))) ^ ((((((v_in[93]) & (b_in[5])) ^ ((v_in[92]) & (b_in[6]))) ^ ((v_in[94]) & (b_in[4]))) ^ (((v_in[91]) & (b_in[7])) ^ ((v_in[90]) & (b_in[8])))) ^ ((((v_in[96]) & (b_in[2])) ^ ((v_in[95]) & (b_in[3]))) ^ (((v_in[97]) & (b_in[1])) ^ ((v_in[98]) & (b_in[0])))));
assign v_out[84] = v_in[100];
assign z_out[84] = ((((z_in[84]) ^ ((v_in[84]) & (b_in[15]))) ^ (((v_in[85]) & (b_in[14])) ^ ((v_in[86]) & (b_in[13])))) ^ ((((v_in[88]) & (b_in[11])) ^ ((v_in[87]) & (b_in[12]))) ^ (((v_in[89]) & (b_in[10])) ^ ((v_in[90]) & (b_in[9]))))) ^ ((((((v_in[94]) & (b_in[5])) ^ ((v_in[93]) & (b_in[6]))) ^ ((v_in[95]) & (b_in[4]))) ^ (((v_in[92]) & (b_in[7])) ^ ((v_in[91]) & (b_in[8])))) ^ ((((v_in[97]) & (b_in[2])) ^ ((v_in[96]) & (b_in[3]))) ^ (((v_in[98]) & (b_in[1])) ^ ((v_in[99]) & (b_in[0])))));
assign v_out[85] = v_in[101];
assign z_out[85] = ((((z_in[85]) ^ ((v_in[85]) & (b_in[15]))) ^ (((v_in[86]) & (b_in[14])) ^ ((v_in[87]) & (b_in[13])))) ^ ((((v_in[89]) & (b_in[11])) ^ ((v_in[88]) & (b_in[12]))) ^ (((v_in[90]) & (b_in[10])) ^ ((v_in[91]) & (b_in[9]))))) ^ ((((((v_in[95]) & (b_in[5])) ^ ((v_in[94]) & (b_in[6]))) ^ ((v_in[96]) & (b_in[4]))) ^ (((v_in[93]) & (b_in[7])) ^ ((v_in[92]) & (b_in[8])))) ^ ((((v_in[98]) & (b_in[2])) ^ ((v_in[97]) & (b_in[3]))) ^ (((v_in[99]) & (b_in[1])) ^ ((v_in[100]) & (b_in[0])))));
assign v_out[86] = v_in[102];
assign z_out[86] = ((((z_in[86]) ^ ((v_in[86]) & (b_in[15]))) ^ (((v_in[87]) & (b_in[14])) ^ ((v_in[88]) & (b_in[13])))) ^ ((((v_in[90]) & (b_in[11])) ^ ((v_in[89]) & (b_in[12]))) ^ (((v_in[91]) & (b_in[10])) ^ ((v_in[92]) & (b_in[9]))))) ^ ((((((v_in[96]) & (b_in[5])) ^ ((v_in[95]) & (b_in[6]))) ^ ((v_in[97]) & (b_in[4]))) ^ (((v_in[94]) & (b_in[7])) ^ ((v_in[93]) & (b_in[8])))) ^ ((((v_in[99]) & (b_in[2])) ^ ((v_in[98]) & (b_in[3]))) ^ (((v_in[100]) & (b_in[1])) ^ ((v_in[101]) & (b_in[0])))));
assign v_out[87] = v_in[103];
assign z_out[87] = ((((z_in[87]) ^ ((v_in[87]) & (b_in[15]))) ^ (((v_in[88]) & (b_in[14])) ^ ((v_in[89]) & (b_in[13])))) ^ ((((v_in[91]) & (b_in[11])) ^ ((v_in[90]) & (b_in[12]))) ^ (((v_in[92]) & (b_in[10])) ^ ((v_in[93]) & (b_in[9]))))) ^ ((((((v_in[97]) & (b_in[5])) ^ ((v_in[96]) & (b_in[6]))) ^ ((v_in[98]) & (b_in[4]))) ^ (((v_in[95]) & (b_in[7])) ^ ((v_in[94]) & (b_in[8])))) ^ ((((v_in[100]) & (b_in[2])) ^ ((v_in[99]) & (b_in[3]))) ^ (((v_in[101]) & (b_in[1])) ^ ((v_in[102]) & (b_in[0])))));
assign v_out[88] = v_in[104];
assign z_out[88] = ((((z_in[88]) ^ ((v_in[88]) & (b_in[15]))) ^ (((v_in[89]) & (b_in[14])) ^ ((v_in[90]) & (b_in[13])))) ^ ((((v_in[92]) & (b_in[11])) ^ ((v_in[91]) & (b_in[12]))) ^ (((v_in[93]) & (b_in[10])) ^ ((v_in[94]) & (b_in[9]))))) ^ ((((((v_in[98]) & (b_in[5])) ^ ((v_in[97]) & (b_in[6]))) ^ ((v_in[99]) & (b_in[4]))) ^ (((v_in[96]) & (b_in[7])) ^ ((v_in[95]) & (b_in[8])))) ^ ((((v_in[101]) & (b_in[2])) ^ ((v_in[100]) & (b_in[3]))) ^ (((v_in[102]) & (b_in[1])) ^ ((v_in[103]) & (b_in[0])))));
assign v_out[89] = v_in[105];
assign z_out[89] = ((((z_in[89]) ^ ((v_in[89]) & (b_in[15]))) ^ (((v_in[90]) & (b_in[14])) ^ ((v_in[91]) & (b_in[13])))) ^ ((((v_in[93]) & (b_in[11])) ^ ((v_in[92]) & (b_in[12]))) ^ (((v_in[94]) & (b_in[10])) ^ ((v_in[95]) & (b_in[9]))))) ^ ((((((v_in[99]) & (b_in[5])) ^ ((v_in[98]) & (b_in[6]))) ^ ((v_in[100]) & (b_in[4]))) ^ (((v_in[97]) & (b_in[7])) ^ ((v_in[96]) & (b_in[8])))) ^ ((((v_in[102]) & (b_in[2])) ^ ((v_in[101]) & (b_in[3]))) ^ (((v_in[103]) & (b_in[1])) ^ ((v_in[104]) & (b_in[0])))));
assign v_out[90] = v_in[106];
assign z_out[90] = ((((z_in[90]) ^ ((v_in[90]) & (b_in[15]))) ^ (((v_in[91]) & (b_in[14])) ^ ((v_in[92]) & (b_in[13])))) ^ ((((v_in[94]) & (b_in[11])) ^ ((v_in[93]) & (b_in[12]))) ^ (((v_in[95]) & (b_in[10])) ^ ((v_in[96]) & (b_in[9]))))) ^ ((((((v_in[100]) & (b_in[5])) ^ ((v_in[99]) & (b_in[6]))) ^ ((v_in[101]) & (b_in[4]))) ^ (((v_in[98]) & (b_in[7])) ^ ((v_in[97]) & (b_in[8])))) ^ ((((v_in[103]) & (b_in[2])) ^ ((v_in[102]) & (b_in[3]))) ^ (((v_in[104]) & (b_in[1])) ^ ((v_in[105]) & (b_in[0])))));
assign v_out[91] = v_in[107];
assign z_out[91] = ((((z_in[91]) ^ ((v_in[91]) & (b_in[15]))) ^ (((v_in[92]) & (b_in[14])) ^ ((v_in[93]) & (b_in[13])))) ^ ((((v_in[95]) & (b_in[11])) ^ ((v_in[94]) & (b_in[12]))) ^ (((v_in[96]) & (b_in[10])) ^ ((v_in[97]) & (b_in[9]))))) ^ ((((((v_in[101]) & (b_in[5])) ^ ((v_in[100]) & (b_in[6]))) ^ ((v_in[102]) & (b_in[4]))) ^ (((v_in[99]) & (b_in[7])) ^ ((v_in[98]) & (b_in[8])))) ^ ((((v_in[104]) & (b_in[2])) ^ ((v_in[103]) & (b_in[3]))) ^ (((v_in[105]) & (b_in[1])) ^ ((v_in[106]) & (b_in[0])))));
assign v_out[92] = v_in[108];
assign z_out[92] = ((((z_in[92]) ^ ((v_in[92]) & (b_in[15]))) ^ (((v_in[93]) & (b_in[14])) ^ ((v_in[94]) & (b_in[13])))) ^ ((((v_in[96]) & (b_in[11])) ^ ((v_in[95]) & (b_in[12]))) ^ (((v_in[97]) & (b_in[10])) ^ ((v_in[98]) & (b_in[9]))))) ^ ((((((v_in[102]) & (b_in[5])) ^ ((v_in[101]) & (b_in[6]))) ^ ((v_in[103]) & (b_in[4]))) ^ (((v_in[100]) & (b_in[7])) ^ ((v_in[99]) & (b_in[8])))) ^ ((((v_in[105]) & (b_in[2])) ^ ((v_in[104]) & (b_in[3]))) ^ (((v_in[106]) & (b_in[1])) ^ ((v_in[107]) & (b_in[0])))));
assign v_out[93] = v_in[109];
assign z_out[93] = ((((z_in[93]) ^ ((v_in[93]) & (b_in[15]))) ^ (((v_in[94]) & (b_in[14])) ^ ((v_in[95]) & (b_in[13])))) ^ ((((v_in[97]) & (b_in[11])) ^ ((v_in[96]) & (b_in[12]))) ^ (((v_in[98]) & (b_in[10])) ^ ((v_in[99]) & (b_in[9]))))) ^ ((((((v_in[103]) & (b_in[5])) ^ ((v_in[102]) & (b_in[6]))) ^ ((v_in[104]) & (b_in[4]))) ^ (((v_in[101]) & (b_in[7])) ^ ((v_in[100]) & (b_in[8])))) ^ ((((v_in[106]) & (b_in[2])) ^ ((v_in[105]) & (b_in[3]))) ^ (((v_in[107]) & (b_in[1])) ^ ((v_in[108]) & (b_in[0])))));
assign v_out[94] = v_in[110];
assign z_out[94] = ((((z_in[94]) ^ ((v_in[94]) & (b_in[15]))) ^ (((v_in[95]) & (b_in[14])) ^ ((v_in[96]) & (b_in[13])))) ^ ((((v_in[98]) & (b_in[11])) ^ ((v_in[97]) & (b_in[12]))) ^ (((v_in[99]) & (b_in[10])) ^ ((v_in[100]) & (b_in[9]))))) ^ ((((((v_in[104]) & (b_in[5])) ^ ((v_in[103]) & (b_in[6]))) ^ ((v_in[105]) & (b_in[4]))) ^ (((v_in[102]) & (b_in[7])) ^ ((v_in[101]) & (b_in[8])))) ^ ((((v_in[107]) & (b_in[2])) ^ ((v_in[106]) & (b_in[3]))) ^ (((v_in[108]) & (b_in[1])) ^ ((v_in[109]) & (b_in[0])))));
assign v_out[95] = v_in[111];
assign z_out[95] = ((((z_in[95]) ^ ((v_in[95]) & (b_in[15]))) ^ (((v_in[96]) & (b_in[14])) ^ ((v_in[97]) & (b_in[13])))) ^ ((((v_in[99]) & (b_in[11])) ^ ((v_in[98]) & (b_in[12]))) ^ (((v_in[100]) & (b_in[10])) ^ ((v_in[101]) & (b_in[9]))))) ^ ((((((v_in[105]) & (b_in[5])) ^ ((v_in[104]) & (b_in[6]))) ^ ((v_in[106]) & (b_in[4]))) ^ (((v_in[103]) & (b_in[7])) ^ ((v_in[102]) & (b_in[8])))) ^ ((((v_in[108]) & (b_in[2])) ^ ((v_in[107]) & (b_in[3]))) ^ (((v_in[109]) & (b_in[1])) ^ ((v_in[110]) & (b_in[0])))));
assign v_out[96] = v_in[112];
assign z_out[96] = ((((z_in[96]) ^ ((v_in[96]) & (b_in[15]))) ^ (((v_in[97]) & (b_in[14])) ^ ((v_in[98]) & (b_in[13])))) ^ ((((v_in[100]) & (b_in[11])) ^ ((v_in[99]) & (b_in[12]))) ^ (((v_in[101]) & (b_in[10])) ^ ((v_in[102]) & (b_in[9]))))) ^ ((((((v_in[106]) & (b_in[5])) ^ ((v_in[105]) & (b_in[6]))) ^ ((v_in[107]) & (b_in[4]))) ^ (((v_in[104]) & (b_in[7])) ^ ((v_in[103]) & (b_in[8])))) ^ ((((v_in[109]) & (b_in[2])) ^ ((v_in[108]) & (b_in[3]))) ^ (((v_in[110]) & (b_in[1])) ^ ((v_in[111]) & (b_in[0])))));
assign v_out[97] = v_in[113];
assign z_out[97] = ((((z_in[97]) ^ ((v_in[97]) & (b_in[15]))) ^ (((v_in[98]) & (b_in[14])) ^ ((v_in[99]) & (b_in[13])))) ^ ((((v_in[101]) & (b_in[11])) ^ ((v_in[100]) & (b_in[12]))) ^ (((v_in[102]) & (b_in[10])) ^ ((v_in[103]) & (b_in[9]))))) ^ ((((((v_in[107]) & (b_in[5])) ^ ((v_in[106]) & (b_in[6]))) ^ ((v_in[108]) & (b_in[4]))) ^ (((v_in[105]) & (b_in[7])) ^ ((v_in[104]) & (b_in[8])))) ^ ((((v_in[110]) & (b_in[2])) ^ ((v_in[109]) & (b_in[3]))) ^ (((v_in[111]) & (b_in[1])) ^ ((v_in[112]) & (b_in[0])))));
assign v_out[98] = v_in[114];
assign z_out[98] = ((((z_in[98]) ^ ((v_in[98]) & (b_in[15]))) ^ (((v_in[99]) & (b_in[14])) ^ ((v_in[100]) & (b_in[13])))) ^ ((((v_in[102]) & (b_in[11])) ^ ((v_in[101]) & (b_in[12]))) ^ (((v_in[103]) & (b_in[10])) ^ ((v_in[104]) & (b_in[9]))))) ^ ((((((v_in[108]) & (b_in[5])) ^ ((v_in[107]) & (b_in[6]))) ^ ((v_in[109]) & (b_in[4]))) ^ (((v_in[106]) & (b_in[7])) ^ ((v_in[105]) & (b_in[8])))) ^ ((((v_in[111]) & (b_in[2])) ^ ((v_in[110]) & (b_in[3]))) ^ (((v_in[112]) & (b_in[1])) ^ ((v_in[113]) & (b_in[0])))));
assign v_out[99] = v_in[115];
assign z_out[99] = ((((z_in[99]) ^ ((v_in[99]) & (b_in[15]))) ^ (((v_in[100]) & (b_in[14])) ^ ((v_in[101]) & (b_in[13])))) ^ ((((v_in[103]) & (b_in[11])) ^ ((v_in[102]) & (b_in[12]))) ^ (((v_in[104]) & (b_in[10])) ^ ((v_in[105]) & (b_in[9]))))) ^ ((((((v_in[109]) & (b_in[5])) ^ ((v_in[108]) & (b_in[6]))) ^ ((v_in[110]) & (b_in[4]))) ^ (((v_in[107]) & (b_in[7])) ^ ((v_in[106]) & (b_in[8])))) ^ ((((v_in[112]) & (b_in[2])) ^ ((v_in[111]) & (b_in[3]))) ^ (((v_in[113]) & (b_in[1])) ^ ((v_in[114]) & (b_in[0])))));
assign v_out[100] = v_in[116];
assign z_out[100] = ((((z_in[100]) ^ ((v_in[100]) & (b_in[15]))) ^ (((v_in[101]) & (b_in[14])) ^ ((v_in[102]) & (b_in[13])))) ^ ((((v_in[104]) & (b_in[11])) ^ ((v_in[103]) & (b_in[12]))) ^ (((v_in[105]) & (b_in[10])) ^ ((v_in[106]) & (b_in[9]))))) ^ ((((((v_in[110]) & (b_in[5])) ^ ((v_in[109]) & (b_in[6]))) ^ ((v_in[111]) & (b_in[4]))) ^ (((v_in[108]) & (b_in[7])) ^ ((v_in[107]) & (b_in[8])))) ^ ((((v_in[113]) & (b_in[2])) ^ ((v_in[112]) & (b_in[3]))) ^ (((v_in[114]) & (b_in[1])) ^ ((v_in[115]) & (b_in[0])))));
assign v_out[101] = v_in[117];
assign z_out[101] = ((((z_in[101]) ^ ((v_in[101]) & (b_in[15]))) ^ (((v_in[102]) & (b_in[14])) ^ ((v_in[103]) & (b_in[13])))) ^ ((((v_in[105]) & (b_in[11])) ^ ((v_in[104]) & (b_in[12]))) ^ (((v_in[106]) & (b_in[10])) ^ ((v_in[107]) & (b_in[9]))))) ^ ((((((v_in[111]) & (b_in[5])) ^ ((v_in[110]) & (b_in[6]))) ^ ((v_in[112]) & (b_in[4]))) ^ (((v_in[109]) & (b_in[7])) ^ ((v_in[108]) & (b_in[8])))) ^ ((((v_in[114]) & (b_in[2])) ^ ((v_in[113]) & (b_in[3]))) ^ (((v_in[115]) & (b_in[1])) ^ ((v_in[116]) & (b_in[0])))));
assign v_out[102] = v_in[118];
assign z_out[102] = ((((z_in[102]) ^ ((v_in[102]) & (b_in[15]))) ^ (((v_in[103]) & (b_in[14])) ^ ((v_in[104]) & (b_in[13])))) ^ ((((v_in[106]) & (b_in[11])) ^ ((v_in[105]) & (b_in[12]))) ^ (((v_in[107]) & (b_in[10])) ^ ((v_in[108]) & (b_in[9]))))) ^ ((((((v_in[112]) & (b_in[5])) ^ ((v_in[111]) & (b_in[6]))) ^ ((v_in[113]) & (b_in[4]))) ^ (((v_in[110]) & (b_in[7])) ^ ((v_in[109]) & (b_in[8])))) ^ ((((v_in[115]) & (b_in[2])) ^ ((v_in[114]) & (b_in[3]))) ^ (((v_in[116]) & (b_in[1])) ^ ((v_in[117]) & (b_in[0])))));
assign v_out[103] = v_in[119];
assign z_out[103] = ((((z_in[103]) ^ ((v_in[103]) & (b_in[15]))) ^ (((v_in[104]) & (b_in[14])) ^ ((v_in[105]) & (b_in[13])))) ^ ((((v_in[107]) & (b_in[11])) ^ ((v_in[106]) & (b_in[12]))) ^ (((v_in[108]) & (b_in[10])) ^ ((v_in[109]) & (b_in[9]))))) ^ ((((((v_in[113]) & (b_in[5])) ^ ((v_in[112]) & (b_in[6]))) ^ ((v_in[114]) & (b_in[4]))) ^ (((v_in[111]) & (b_in[7])) ^ ((v_in[110]) & (b_in[8])))) ^ ((((v_in[116]) & (b_in[2])) ^ ((v_in[115]) & (b_in[3]))) ^ (((v_in[117]) & (b_in[1])) ^ ((v_in[118]) & (b_in[0])))));
assign v_out[104] = v_in[120];
assign z_out[104] = ((((z_in[104]) ^ ((v_in[104]) & (b_in[15]))) ^ (((v_in[105]) & (b_in[14])) ^ ((v_in[106]) & (b_in[13])))) ^ ((((v_in[108]) & (b_in[11])) ^ ((v_in[107]) & (b_in[12]))) ^ (((v_in[109]) & (b_in[10])) ^ ((v_in[110]) & (b_in[9]))))) ^ ((((((v_in[114]) & (b_in[5])) ^ ((v_in[113]) & (b_in[6]))) ^ ((v_in[115]) & (b_in[4]))) ^ (((v_in[112]) & (b_in[7])) ^ ((v_in[111]) & (b_in[8])))) ^ ((((v_in[117]) & (b_in[2])) ^ ((v_in[116]) & (b_in[3]))) ^ (((v_in[118]) & (b_in[1])) ^ ((v_in[119]) & (b_in[0])))));
assign v_out[105] = (v_in[0]) ^ (v_in[121]);
assign z_out[105] = ((((z_in[105]) ^ ((v_in[105]) & (b_in[15]))) ^ (((v_in[106]) & (b_in[14])) ^ ((v_in[107]) & (b_in[13])))) ^ ((((v_in[109]) & (b_in[11])) ^ ((v_in[108]) & (b_in[12]))) ^ (((v_in[110]) & (b_in[10])) ^ ((v_in[111]) & (b_in[9]))))) ^ ((((((v_in[115]) & (b_in[5])) ^ ((v_in[114]) & (b_in[6]))) ^ ((v_in[116]) & (b_in[4]))) ^ (((v_in[113]) & (b_in[7])) ^ ((v_in[112]) & (b_in[8])))) ^ ((((v_in[118]) & (b_in[2])) ^ ((v_in[117]) & (b_in[3]))) ^ (((v_in[119]) & (b_in[1])) ^ ((v_in[120]) & (b_in[0])))));
assign v_out[106] = (v_in[1]) ^ (v_in[122]);
assign z_out[106] = ((((z_in[106]) ^ ((v_in[106]) & (b_in[15]))) ^ (((v_in[107]) & (b_in[14])) ^ ((v_in[108]) & (b_in[13])))) ^ (((((v_in[110]) & (b_in[11])) ^ ((v_in[111]) & (b_in[10]))) ^ ((v_in[109]) & (b_in[12]))) ^ (((v_in[112]) & (b_in[9])) ^ ((v_in[113]) & (b_in[8]))))) ^ ((((((v_in[117]) & (b_in[4])) ^ ((v_in[116]) & (b_in[5]))) ^ ((v_in[118]) & (b_in[3]))) ^ (((v_in[115]) & (b_in[6])) ^ ((v_in[114]) & (b_in[7])))) ^ ((((v_in[120]) & (b_in[1])) ^ ((v_in[119]) & (b_in[2]))) ^ (((v_in[0]) ^ (v_in[121])) & (b_in[0]))));
assign v_out[107] = (v_in[2]) ^ (v_in[123]);
assign z_out[107] = ((((z_in[107]) ^ ((v_in[107]) & (b_in[15]))) ^ (((v_in[108]) & (b_in[14])) ^ ((v_in[109]) & (b_in[13])))) ^ (((((v_in[111]) & (b_in[11])) ^ ((v_in[112]) & (b_in[10]))) ^ ((v_in[110]) & (b_in[12]))) ^ (((v_in[113]) & (b_in[9])) ^ ((v_in[114]) & (b_in[8]))))) ^ ((((((v_in[118]) & (b_in[4])) ^ ((v_in[117]) & (b_in[5]))) ^ ((v_in[119]) & (b_in[3]))) ^ (((v_in[116]) & (b_in[6])) ^ ((v_in[115]) & (b_in[7])))) ^ (((((v_in[0]) ^ (v_in[121])) & (b_in[1])) ^ ((v_in[120]) & (b_in[2]))) ^ (((v_in[1]) ^ (v_in[122])) & (b_in[0]))));
assign v_out[108] = (v_in[3]) ^ (v_in[124]);
assign z_out[108] = ((((z_in[108]) ^ ((v_in[108]) & (b_in[15]))) ^ (((v_in[109]) & (b_in[14])) ^ ((v_in[110]) & (b_in[13])))) ^ (((((v_in[112]) & (b_in[11])) ^ ((v_in[113]) & (b_in[10]))) ^ ((v_in[111]) & (b_in[12]))) ^ (((v_in[114]) & (b_in[9])) ^ ((v_in[115]) & (b_in[8]))))) ^ ((((((v_in[119]) & (b_in[4])) ^ ((v_in[118]) & (b_in[5]))) ^ ((v_in[120]) & (b_in[3]))) ^ (((v_in[117]) & (b_in[6])) ^ ((v_in[116]) & (b_in[7])))) ^ (((((v_in[1]) ^ (v_in[122])) & (b_in[1])) ^ (((v_in[0]) ^ (v_in[121])) & (b_in[2]))) ^ (((v_in[2]) ^ (v_in[123])) & (b_in[0]))));
assign v_out[109] = (v_in[4]) ^ (v_in[125]);
assign z_out[109] = ((((z_in[109]) ^ ((v_in[109]) & (b_in[15]))) ^ (((v_in[110]) & (b_in[14])) ^ ((v_in[111]) & (b_in[13])))) ^ (((((v_in[113]) & (b_in[11])) ^ ((v_in[114]) & (b_in[10]))) ^ ((v_in[112]) & (b_in[12]))) ^ (((v_in[115]) & (b_in[9])) ^ ((v_in[116]) & (b_in[8]))))) ^ (((((v_in[120]) & (b_in[4])) ^ (((v_in[0]) ^ (v_in[121])) & (b_in[3]))) ^ ((((v_in[118]) & (b_in[6])) ^ ((v_in[119]) & (b_in[5]))) ^ ((v_in[117]) & (b_in[7])))) ^ (((((v_in[2]) ^ (v_in[123])) & (b_in[1])) ^ (((v_in[1]) ^ (v_in[122])) & (b_in[2]))) ^ (((v_in[3]) ^ (v_in[124])) & (b_in[0]))));
assign v_out[110] = (v_in[5]) ^ ((v_in[0]) ^ (v_in[126]));
assign z_out[110] = ((((z_in[110]) ^ ((v_in[110]) & (b_in[15]))) ^ (((v_in[111]) & (b_in[14])) ^ ((v_in[112]) & (b_in[13])))) ^ (((((v_in[114]) & (b_in[11])) ^ ((v_in[115]) & (b_in[10]))) ^ ((v_in[113]) & (b_in[12]))) ^ (((v_in[116]) & (b_in[9])) ^ ((v_in[117]) & (b_in[8]))))) ^ ((((((v_in[0]) ^ (v_in[121])) & (b_in[4])) ^ (((v_in[1]) ^ (v_in[122])) & (b_in[3]))) ^ ((((v_in[119]) & (b_in[6])) ^ ((v_in[120]) & (b_in[5]))) ^ ((v_in[118]) & (b_in[7])))) ^ (((((v_in[3]) ^ (v_in[124])) & (b_in[1])) ^ (((v_in[2]) ^ (v_in[123])) & (b_in[2]))) ^ (((v_in[4]) ^ (v_in[125])) & (b_in[0]))));
assign v_out[111] = (v_in[6]) ^ ((v_in[1]) ^ ((v_in[0]) ^ (v_in[127])));
assign z_out[111] = ((((z_in[111]) ^ ((v_in[111]) & (b_in[15]))) ^ (((v_in[112]) & (b_in[14])) ^ ((v_in[113]) & (b_in[13])))) ^ (((((v_in[115]) & (b_in[11])) ^ ((v_in[116]) & (b_in[10]))) ^ ((v_in[114]) & (b_in[12]))) ^ (((v_in[117]) & (b_in[9])) ^ ((v_in[118]) & (b_in[8]))))) ^ ((((((v_in[1]) ^ (v_in[122])) & (b_in[4])) ^ (((v_in[2]) ^ (v_in[123])) & (b_in[3]))) ^ ((((v_in[0]) ^ (v_in[121])) & (b_in[5])) ^ (((v_in[120]) & (b_in[6])) ^ ((v_in[119]) & (b_in[7]))))) ^ (((((v_in[4]) ^ (v_in[125])) & (b_in[1])) ^ (((v_in[3]) ^ (v_in[124])) & (b_in[2]))) ^ ((((v_in[0]) ^ (v_in[5])) ^ (v_in[126])) & (b_in[0]))));
assign v_out[112] = (v_in[7]) ^ ((v_in[2]) ^ ((v_in[1]) ^ (v_in[0])));
assign z_out[112] = ((((z_in[112]) ^ ((v_in[112]) & (b_in[15]))) ^ ((((v_in[114]) & (b_in[13])) ^ ((v_in[113]) & (b_in[14]))) ^ ((v_in[115]) & (b_in[12])))) ^ (((((v_in[117]) & (b_in[10])) ^ ((v_in[118]) & (b_in[9]))) ^ ((v_in[116]) & (b_in[11]))) ^ (((v_in[119]) & (b_in[8])) ^ ((v_in[120]) & (b_in[7]))))) ^ (((((((v_in[3]) ^ (v_in[124])) & (b_in[3])) ^ (((v_in[2]) ^ (v_in[123])) & (b_in[4]))) ^ (((v_in[4]) ^ (v_in[125])) & (b_in[2]))) ^ ((((v_in[1]) ^ (v_in[122])) & (b_in[5])) ^ (((v_in[0]) ^ (v_in[121])) & (b_in[6])))) ^ ((((v_in[0]) ^ ((v_in[5]) ^ (v_in[126]))) & (b_in[1])) ^ ((((v_in[1]) ^ (v_in[6])) ^ ((v_in[0]) ^ (v_in[127]))) & (b_in[0]))));
assign v_out[113] = (v_in[8]) ^ ((v_in[3]) ^ ((v_in[2]) ^ (v_in[1])));
assign z_out[113] = ((((z_in[113]) ^ ((v_in[113]) & (b_in[15]))) ^ ((((v_in[115]) & (b_in[13])) ^ ((v_in[114]) & (b_in[14]))) ^ ((v_in[116]) & (b_in[12])))) ^ (((((v_in[118]) & (b_in[10])) ^ ((v_in[119]) & (b_in[9]))) ^ ((v_in[117]) & (b_in[11]))) ^ (((v_in[120]) & (b_in[8])) ^ (((v_in[0]) ^ (v_in[121])) & (b_in[7]))))) ^ ((((((v_in[4]) ^ (v_in[125])) & (b_in[3])) ^ ((((v_in[5]) ^ (v_in[0])) ^ (v_in[126])) & (b_in[2]))) ^ (((((v_in[2]) ^ (v_in[123])) & (b_in[5])) ^ (((v_in[3]) ^ (v_in[124])) & (b_in[4]))) ^ (((v_in[1]) ^ (v_in[122])) & (b_in[6])))) ^ (((((v_in[1]) ^ (v_in[6])) ^ ((v_in[0]) ^ (v_in[127]))) & (b_in[1])) ^ ((((v_in[2]) ^ (v_in[7])) ^ ((v_in[1]) ^ (v_in[0]))) & (b_in[0]))));
assign v_out[114] = (v_in[9]) ^ ((v_in[4]) ^ ((v_in[3]) ^ (v_in[2])));
assign z_out[114] = ((((z_in[114]) ^ ((v_in[114]) & (b_in[15]))) ^ ((((v_in[116]) & (b_in[13])) ^ ((v_in[115]) & (b_in[14]))) ^ ((v_in[117]) & (b_in[12])))) ^ (((((v_in[119]) & (b_in[10])) ^ ((v_in[120]) & (b_in[9]))) ^ ((v_in[118]) & (b_in[11]))) ^ ((((v_in[0]) ^ (v_in[121])) & (b_in[8])) ^ (((v_in[1]) ^ (v_in[122])) & (b_in[7]))))) ^ ((((((v_in[5]) ^ ((v_in[0]) ^ (v_in[126]))) & (b_in[3])) ^ ((((v_in[1]) ^ (v_in[6])) ^ ((v_in[0]) ^ (v_in[127]))) & (b_in[2]))) ^ (((((v_in[3]) ^ (v_in[124])) & (b_in[5])) ^ (((v_in[4]) ^ (v_in[125])) & (b_in[4]))) ^ (((v_in[2]) ^ (v_in[123])) & (b_in[6])))) ^ (((((v_in[2]) ^ (v_in[7])) ^ ((v_in[1]) ^ (v_in[0]))) & (b_in[1])) ^ ((((v_in[3]) ^ (v_in[8])) ^ ((v_in[2]) ^ (v_in[1]))) & (b_in[0]))));
assign v_out[115] = (v_in[10]) ^ ((v_in[5]) ^ ((v_in[4]) ^ (v_in[3])));
assign z_out[115] = ((((z_in[115]) ^ ((v_in[115]) & (b_in[15]))) ^ ((((v_in[117]) & (b_in[13])) ^ ((v_in[116]) & (b_in[14]))) ^ ((v_in[118]) & (b_in[12])))) ^ (((((v_in[0]) ^ (v_in[121])) & (b_in[9])) ^ (((v_in[120]) & (b_in[10])) ^ ((v_in[119]) & (b_in[11])))) ^ ((((v_in[1]) ^ (v_in[122])) & (b_in[8])) ^ (((v_in[2]) ^ (v_in[123])) & (b_in[7]))))) ^ (((((((v_in[1]) ^ (v_in[6])) ^ ((v_in[0]) ^ (v_in[127]))) & (b_in[3])) ^ ((((v_in[2]) ^ (v_in[7])) ^ ((v_in[1]) ^ (v_in[0]))) & (b_in[2]))) ^ (((((v_in[0]) ^ (v_in[5])) ^ (v_in[126])) & (b_in[4])) ^ ((((v_in[4]) ^ (v_in[125])) & (b_in[5])) ^ (((v_in[3]) ^ (v_in[124])) & (b_in[6]))))) ^ (((((v_in[3]) ^ (v_in[8])) ^ ((v_in[2]) ^ (v_in[1]))) & (b_in[1])) ^ ((((v_in[4]) ^ (v_in[9])) ^ ((v_in[3]) ^ (v_in[2]))) & (b_in[0]))));
assign v_out[116] = (v_in[11]) ^ ((v_in[6]) ^ ((v_in[5]) ^ (v_in[4])));
assign z_out[116] = ((((z_in[116]) ^ ((v_in[116]) & (b_in[15]))) ^ ((((v_in[118]) & (b_in[13])) ^ ((v_in[117]) & (b_in[14]))) ^ ((v_in[119]) & (b_in[12])))) ^ ((((((v_in[0]) ^ (v_in[121])) & (b_in[10])) ^ (((v_in[1]) ^ (v_in[122])) & (b_in[9]))) ^ ((v_in[120]) & (b_in[11]))) ^ ((((v_in[2]) ^ (v_in[123])) & (b_in[8])) ^ (((v_in[3]) ^ (v_in[124])) & (b_in[7]))))) ^ (((((((v_in[1]) ^ (v_in[6])) ^ ((v_in[0]) ^ (v_in[127]))) & (b_in[4])) ^ ((((v_in[2]) ^ (v_in[7])) ^ ((v_in[1]) ^ (v_in[0]))) & (b_in[3]))) ^ ((((v_in[0]) ^ ((v_in[5]) ^ (v_in[126]))) & (b_in[5])) ^ (((v_in[4]) ^ (v_in[125])) & (b_in[6])))) ^ ((((((v_in[4]) ^ (v_in[9])) ^ ((v_in[3]) ^ (v_in[2]))) & (b_in[1])) ^ ((((v_in[3]) ^ (v_in[8])) ^ ((v_in[2]) ^ (v_in[1]))) & (b_in[2]))) ^ ((((v_in[5]) ^ (v_in[10])) ^ ((v_in[4]) ^ (v_in[3]))) & (b_in[0]))));
assign v_out[117] = (v_in[12]) ^ ((v_in[7]) ^ ((v_in[6]) ^ (v_in[5])));
assign z_out[117] = ((((z_in[117]) ^ ((v_in[117]) & (b_in[15]))) ^ ((((v_in[119]) & (b_in[13])) ^ ((v_in[118]) & (b_in[14]))) ^ ((v_in[120]) & (b_in[12])))) ^ ((((((v_in[1]) ^ (v_in[122])) & (b_in[10])) ^ (((v_in[2]) ^ (v_in[123])) & (b_in[9]))) ^ (((v_in[0]) ^ (v_in[121])) & (b_in[11]))) ^ ((((v_in[3]) ^ (v_in[124])) & (b_in[8])) ^ (((v_in[4]) ^ (v_in[125])) & (b_in[7]))))) ^ (((((((v_in[2]) ^ (v_in[7])) ^ ((v_in[1]) ^ (v_in[0]))) & (b_in[4])) ^ ((((v_in[3]) ^ (v_in[8])) ^ ((v_in[2]) ^ (v_in[1]))) & (b_in[3]))) ^ (((((v_in[1]) ^ (v_in[6])) ^ ((v_in[0]) ^ (v_in[127]))) & (b_in[5])) ^ ((((v_in[5]) ^ (v_in[0])) ^ (v_in[126])) & (b_in[6])))) ^ ((((((v_in[5]) ^ (v_in[10])) ^ ((v_in[4]) ^ (v_in[3]))) & (b_in[1])) ^ ((((v_in[4]) ^ (v_in[9])) ^ ((v_in[3]) ^ (v_in[2]))) & (b_in[2]))) ^ ((((v_in[6]) ^ (v_in[11])) ^ ((v_in[5]) ^ (v_in[4]))) & (b_in[0]))));
assign v_out[118] = (v_in[13]) ^ ((v_in[8]) ^ ((v_in[7]) ^ (v_in[6])));
assign z_out[118] = ((((z_in[118]) ^ (((v_in[118]) & (b_in[15])) ^ ((v_in[119]) & (b_in[14])))) ^ (((((v_in[0]) ^ (v_in[121])) & (b_in[12])) ^ ((v_in[120]) & (b_in[13]))) ^ (((v_in[1]) ^ (v_in[122])) & (b_in[11])))) ^ ((((((v_in[3]) ^ (v_in[124])) & (b_in[9])) ^ (((v_in[4]) ^ (v_in[125])) & (b_in[8]))) ^ (((v_in[2]) ^ (v_in[123])) & (b_in[10]))) ^ (((v_in[5]) ^ ((v_in[0]) ^ (v_in[126]))) & (b_in[7])))) ^ (((((((v_in[3]) ^ (v_in[8])) ^ ((v_in[2]) ^ (v_in[1]))) & (b_in[4])) ^ ((((v_in[4]) ^ (v_in[9])) ^ ((v_in[3]) ^ (v_in[2]))) & (b_in[3]))) ^ (((((v_in[2]) ^ (v_in[7])) ^ ((v_in[1]) ^ (v_in[0]))) & (b_in[5])) ^ ((((v_in[1]) ^ (v_in[6])) ^ ((v_in[0]) ^ (v_in[127]))) & (b_in[6])))) ^ ((((((v_in[6]) ^ (v_in[11])) ^ ((v_in[5]) ^ (v_in[4]))) & (b_in[1])) ^ ((((v_in[5]) ^ (v_in[10])) ^ ((v_in[4]) ^ (v_in[3]))) & (b_in[2]))) ^ ((((v_in[7]) ^ (v_in[12])) ^ ((v_in[6]) ^ (v_in[5]))) & (b_in[0]))));
assign v_out[119] = (v_in[14]) ^ ((v_in[9]) ^ ((v_in[8]) ^ (v_in[7])));
assign z_out[119] = ((((z_in[119]) ^ (((v_in[119]) & (b_in[15])) ^ ((v_in[120]) & (b_in[14])))) ^ (((((v_in[1]) ^ (v_in[122])) & (b_in[12])) ^ (((v_in[0]) ^ (v_in[121])) & (b_in[13]))) ^ (((v_in[2]) ^ (v_in[123])) & (b_in[11])))) ^ ((((((v_in[0]) ^ (v_in[5])) ^ (v_in[126])) & (b_in[8])) ^ ((((v_in[4]) ^ (v_in[125])) & (b_in[9])) ^ (((v_in[3]) ^ (v_in[124])) & (b_in[10])))) ^ ((((v_in[1]) ^ (v_in[6])) ^ ((v_in[0]) ^ (v_in[127]))) & (b_in[7])))) ^ (((((((v_in[4]) ^ (v_in[9])) ^ ((v_in[3]) ^ (v_in[2]))) & (b_in[4])) ^ ((((v_in[5]) ^ (v_in[10])) ^ ((v_in[4]) ^ (v_in[3]))) & (b_in[3]))) ^ (((((v_in[3]) ^ (v_in[8])) ^ ((v_in[2]) ^ (v_in[1]))) & (b_in[5])) ^ ((((v_in[2]) ^ (v_in[7])) ^ ((v_in[1]) ^ (v_in[0]))) & (b_in[6])))) ^ ((((((v_in[7]) ^ (v_in[12])) ^ ((v_in[6]) ^ (v_in[5]))) & (b_in[1])) ^ ((((v_in[6]) ^ (v_in[11])) ^ ((v_in[5]) ^ (v_in[4]))) & (b_in[2]))) ^ ((((v_in[8]) ^ (v_in[13])) ^ ((v_in[7]) ^ (v_in[6]))) & (b_in[0]))));
assign v_out[120] = (v_in[15]) ^ ((v_in[10]) ^ ((v_in[9]) ^ (v_in[8])));
assign z_out[120] = (((((z_in[120]) ^ ((v_in[120]) & (b_in[15]))) ^ (((v_in[0]) ^ (v_in[121])) & (b_in[14]))) ^ (((((v_in[2]) ^ (v_in[123])) & (b_in[12])) ^ (((v_in[1]) ^ (v_in[122])) & (b_in[13]))) ^ (((v_in[3]) ^ (v_in[124])) & (b_in[11])))) ^ (((((v_in[0]) ^ ((v_in[5]) ^ (v_in[126]))) & (b_in[9])) ^ (((v_in[4]) ^ (v_in[125])) & (b_in[10]))) ^ (((((v_in[1]) ^ (v_in[6])) ^ ((v_in[0]) ^ (v_in[127]))) & (b_in[8])) ^ ((((v_in[2]) ^ (v_in[7])) ^ ((v_in[1]) ^ (v_in[0]))) & (b_in[7]))))) ^ (((((((v_in[5]) ^ (v_in[10])) ^ ((v_in[4]) ^ (v_in[3]))) & (b_in[4])) ^ ((((v_in[6]) ^ (v_in[11])) ^ ((v_in[5]) ^ (v_in[4]))) & (b_in[3]))) ^ (((((v_in[4]) ^ (v_in[9])) ^ ((v_in[3]) ^ (v_in[2]))) & (b_in[5])) ^ ((((v_in[3]) ^ (v_in[8])) ^ ((v_in[2]) ^ (v_in[1]))) & (b_in[6])))) ^ ((((((v_in[8]) ^ (v_in[13])) ^ ((v_in[7]) ^ (v_in[6]))) & (b_in[1])) ^ ((((v_in[7]) ^ (v_in[12])) ^ ((v_in[6]) ^ (v_in[5]))) & (b_in[2]))) ^ ((((v_in[9]) ^ (v_in[14])) ^ ((v_in[8]) ^ (v_in[7]))) & (b_in[0]))));
assign v_out[121] = (v_in[11]) ^ ((v_in[10]) ^ (v_in[9]));
assign z_out[121] = ((((z_in[121]) ^ ((v_in[121]) & (b_in[15]))) ^ ((((v_in[123]) & (b_in[13])) ^ ((v_in[122]) & (b_in[14]))) ^ ((v_in[124]) & (b_in[12])))) ^ ((((((v_in[0]) ^ (v_in[1])) ^ (v_in[127])) & (b_in[9])) ^ ((((v_in[0]) ^ (v_in[126])) & (b_in[10])) ^ ((v_in[125]) & (b_in[11])))) ^ ((((v_in[1]) ^ (v_in[2])) ^ (v_in[0])) & (b_in[8])))) ^ (((((((v_in[4]) ^ (v_in[5])) ^ (v_in[3])) & (b_in[5])) ^ ((((v_in[5]) ^ (v_in[6])) ^ (v_in[4])) & (b_in[4]))) ^ (((((v_in[3]) ^ (v_in[4])) ^ (v_in[2])) & (b_in[6])) ^ ((((v_in[2]) ^ (v_in[3])) ^ (v_in[1])) & (b_in[7])))) ^ ((((((v_in[7]) ^ (v_in[8])) ^ (v_in[6])) & (b_in[2])) ^ ((((v_in[6]) ^ (v_in[7])) ^ (v_in[5])) & (b_in[3]))) ^ (((((v_in[8]) ^ (v_in[9])) ^ (v_in[7])) & (b_in[1])) ^ ((((v_in[9]) ^ (v_in[10])) ^ (v_in[8])) & (b_in[0])))));
assign v_out[122] = (v_in[12]) ^ ((v_in[11]) ^ (v_in[10]));
assign z_out[122] = ((((z_in[122]) ^ ((v_in[122]) & (b_in[15]))) ^ ((((v_in[124]) & (b_in[13])) ^ ((v_in[123]) & (b_in[14]))) ^ ((v_in[125]) & (b_in[12])))) ^ (((((v_in[0]) ^ ((v_in[1]) ^ (v_in[127]))) & (b_in[10])) ^ (((v_in[0]) ^ (v_in[126])) & (b_in[11]))) ^ ((((v_in[1]) ^ ((v_in[2]) ^ (v_in[0]))) & (b_in[9])) ^ (((v_in[2]) ^ ((v_in[3]) ^ (v_in[1]))) & (b_in[8]))))) ^ ((((((v_in[5]) ^ ((v_in[6]) ^ (v_in[4]))) & (b_in[5])) ^ (((v_in[6]) ^ ((v_in[7]) ^ (v_in[5]))) & (b_in[4]))) ^ ((((v_in[4]) ^ ((v_in[5]) ^ (v_in[3]))) & (b_in[6])) ^ (((v_in[3]) ^ ((v_in[4]) ^ (v_in[2]))) & (b_in[7])))) ^ (((((v_in[8]) ^ ((v_in[9]) ^ (v_in[7]))) & (b_in[2])) ^ (((v_in[7]) ^ ((v_in[8]) ^ (v_in[6]))) & (b_in[3]))) ^ ((((v_in[9]) ^ ((v_in[10]) ^ (v_in[8]))) & (b_in[1])) ^ ((((v_in[10]) ^ (v_in[11])) ^ (v_in[9])) & (b_in[0])))));
assign v_out[123] = (v_in[13]) ^ ((v_in[12]) ^ (v_in[11]));
assign z_out[123] = ((((z_in[123]) ^ (((v_in[123]) & (b_in[15])) ^ ((v_in[124]) & (b_in[14])))) ^ (((v_in[125]) & (b_in[13])) ^ (((v_in[0]) ^ (v_in[126])) & (b_in[12])))) ^ ((((((v_in[2]) ^ (v_in[1])) ^ (v_in[0])) & (b_in[10])) ^ ((((v_in[1]) ^ (v_in[0])) ^ (v_in[127])) & (b_in[11]))) ^ (((((v_in[3]) ^ (v_in[2])) ^ (v_in[1])) & (b_in[9])) ^ ((((v_in[4]) ^ (v_in[3])) ^ (v_in[2])) & (b_in[8]))))) ^ (((((((v_in[7]) ^ (v_in[6])) ^ (v_in[5])) & (b_in[5])) ^ ((((v_in[8]) ^ (v_in[7])) ^ (v_in[6])) & (b_in[4]))) ^ (((((v_in[6]) ^ (v_in[5])) ^ (v_in[4])) & (b_in[6])) ^ ((((v_in[5]) ^ (v_in[4])) ^ (v_in[3])) & (b_in[7])))) ^ ((((((v_in[10]) ^ (v_in[9])) ^ (v_in[8])) & (b_in[2])) ^ ((((v_in[9]) ^ (v_in[8])) ^ (v_in[7])) & (b_in[3]))) ^ ((((v_in[10]) ^ ((v_in[11]) ^ (v_in[9]))) & (b_in[1])) ^ ((((v_in[11]) ^ (v_in[12])) ^ (v_in[10])) & (b_in[0])))));
assign v_out[124] = (v_in[14]) ^ ((v_in[13]) ^ (v_in[12]));
assign z_out[124] = ((((z_in[124]) ^ (((v_in[124]) & (b_in[15])) ^ ((v_in[125]) & (b_in[14])))) ^ ((((v_in[0]) ^ (v_in[126])) & (b_in[13])) ^ (((v_in[1]) ^ ((v_in[0]) ^ (v_in[127]))) & (b_in[12])))) ^ (((((v_in[3]) ^ ((v_in[2]) ^ (v_in[1]))) & (b_in[10])) ^ (((v_in[2]) ^ ((v_in[1]) ^ (v_in[0]))) & (b_in[11]))) ^ ((((v_in[4]) ^ ((v_in[3]) ^ (v_in[2]))) & (b_in[9])) ^ (((v_in[5]) ^ ((v_in[4]) ^ (v_in[3]))) & (b_in[8]))))) ^ ((((((v_in[8]) ^ ((v_in[7]) ^ (v_in[6]))) & (b_in[5])) ^ (((v_in[9]) ^ ((v_in[8]) ^ (v_in[7]))) & (b_in[4]))) ^ ((((v_in[7]) ^ ((v_in[6]) ^ (v_in[5]))) & (b_in[6])) ^ (((v_in[6]) ^ ((v_in[5]) ^ (v_in[4]))) & (b_in[7])))) ^ ((((((v_in[11]) ^ (v_in[10])) ^ (v_in[9])) & (b_in[2])) ^ (((v_in[10]) ^ ((v_in[9]) ^ (v_in[8]))) & (b_in[3]))) ^ ((((v_in[11]) ^ ((v_in[12]) ^ (v_in[10]))) & (b_in[1])) ^ ((((v_in[12]) ^ (v_in[13])) ^ (v_in[11])) & (b_in[0])))));
assign v_out[125] = (v_in[15]) ^ ((v_in[14]) ^ (v_in[13]));
assign z_out[125] = (((((z_in[125]) ^ ((v_in[125]) & (b_in[15]))) ^ (((v_in[0]) ^ (v_in[126])) & (b_in[14]))) ^ (((((v_in[0]) ^ (v_in[1])) ^ (v_in[127])) & (b_in[13])) ^ ((((v_in[1]) ^ (v_in[2])) ^ (v_in[0])) & (b_in[12])))) ^ ((((((v_in[3]) ^ (v_in[4])) ^ (v_in[2])) & (b_in[10])) ^ ((((v_in[2]) ^ (v_in[3])) ^ (v_in[1])) & (b_in[11]))) ^ (((((v_in[4]) ^ (v_in[5])) ^ (v_in[3])) & (b_in[9])) ^ ((((v_in[5]) ^ (v_in[6])) ^ (v_in[4])) & (b_in[8]))))) ^ (((((((v_in[8]) ^ (v_in[9])) ^ (v_in[7])) & (b_in[5])) ^ ((((v_in[9]) ^ (v_in[10])) ^ (v_in[8])) & (b_in[4]))) ^ (((((v_in[7]) ^ (v_in[8])) ^ (v_in[6])) & (b_in[6])) ^ ((((v_in[6]) ^ (v_in[7])) ^ (v_in[5])) & (b_in[7])))) ^ ((((((v_in[12]) ^ (v_in[11])) ^ (v_in[10])) & (b_in[2])) ^ (((v_in[11]) ^ ((v_in[10]) ^ (v_in[9]))) & (b_in[3]))) ^ ((((v_in[12]) ^ ((v_in[13]) ^ (v_in[11]))) & (b_in[1])) ^ ((((v_in[13]) ^ (v_in[14])) ^ (v_in[12])) & (b_in[0])))));
assign v_out[126] = (v_in[15]) ^ (v_in[14]);
assign z_out[126] = (((((z_in[126]) ^ ((v_in[126]) & (b_in[15]))) ^ (((v_in[0]) ^ (v_in[127])) & (b_in[14]))) ^ ((((v_in[1]) ^ (v_in[0])) & (b_in[13])) ^ (((v_in[2]) ^ (v_in[1])) & (b_in[12])))) ^ (((((v_in[4]) ^ (v_in[3])) & (b_in[10])) ^ (((v_in[3]) ^ (v_in[2])) & (b_in[11]))) ^ ((((v_in[5]) ^ (v_in[4])) & (b_in[9])) ^ (((v_in[6]) ^ (v_in[5])) & (b_in[8]))))) ^ ((((((v_in[9]) ^ (v_in[8])) & (b_in[5])) ^ (((v_in[10]) ^ (v_in[9])) & (b_in[4]))) ^ ((((v_in[8]) ^ (v_in[7])) & (b_in[6])) ^ (((v_in[7]) ^ (v_in[6])) & (b_in[7])))) ^ (((((v_in[12]) ^ (v_in[11])) & (b_in[2])) ^ (((v_in[11]) ^ (v_in[10])) & (b_in[3]))) ^ ((((v_in[13]) ^ (v_in[12])) & (b_in[1])) ^ (((v_in[14]) ^ (v_in[13])) & (b_in[0])))));
assign v_out[127] = v_in[15];
assign z_out[127] = ((((z_in[127]) ^ ((v_in[127]) & (b_in[15]))) ^ (((v_in[0]) & (b_in[14])) ^ ((v_in[1]) & (b_in[13])))) ^ ((((v_in[3]) & (b_in[11])) ^ ((v_in[2]) & (b_in[12]))) ^ (((v_in[4]) & (b_in[10])) ^ ((v_in[5]) & (b_in[9]))))) ^ ((((((v_in[9]) & (b_in[5])) ^ ((v_in[8]) & (b_in[6]))) ^ ((v_in[10]) & (b_in[4]))) ^ (((v_in[7]) & (b_in[7])) ^ ((v_in[6]) & (b_in[8])))) ^ ((((v_in[12]) & (b_in[2])) ^ ((v_in[11]) & (b_in[3]))) ^ (((v_in[13]) & (b_in[1])) ^ ((v_in[14]) & (b_in[0])))));
endmodule
