# HW_CWEs_LLM

## Artifacts/results evaluated in our work

- Buggy designs are provided in `designs/`.
- Bugs detected by CWEAT are in *results/bug_locations/h-21.csv*
- Bug locations for other designs ar e in `results/bug_locations`.
- Instruction variations used to guide LLMs are present in `repairs/instructions/`
- Repairs generated for each LLM are in `repairs/repairs_<model-name>/`
- Testbenches used in functional and security evaluation are present in `tools/functional_tests/` and `tools/security_tests/` respectively.
- Repairs evaluated for each model are present in `results/repairs/results_<model-name>.csv`
- Comparison with Cirfix repairs are present in `verilog_repair/all_repairs.txt`. Evaluation was done manually.

## Regarding Licenses and use of third party tools

- The provided artifacts are currectly provided for the purpose of peer review. Parts of it are expected to be confidential at the moment. 
- Verific: We used Verific libraries provided by Verific under an academic license. Please contact Verific access to their products.
- CWEAT: We got CWEAT code from the authors of the paper "Don't CWEAT It: Toward CWE Analysis Techniques in Early Stages of Hardware Design". The paper is available at https://dl.acm.org/doi/abs/10.1145/3508352.3549369. Please contact the authors for use/help with their codebase.
- Cirfix: We used the Cirfix benchmarks and results provided in their open-source github repository. https://github.com/hammad-a/verilog_repair. Please contact the authors about use of their tools. Their paper is available at https://dl.acm.org/doi/10.1145/3503222.3507763.
- Hack@DAC SoC: We use the SoC used during the 2021 competition. Please contact them at info@hackatevent.org for more information/access.

## If you wish to use the tools from scratch i.e., bug detection, repair generation, functional and security evaluation, you may follow the following steps:

Verifc libraries and license is required for bug detection and security evaluation using CWEAT. This is pertinent to bugs 8-10. The generation of repairs for these bugs is done with OpenAI models, so that does not require Verific or CWEAT.

Bugs 1-7 do not require Verific or CWEAT.

## Setup

Set Open AI api key\
`export OPENAI_API_KEY=<your_key>`\
Set Xilinx Vivado\
`source <path-to-Xilinx installation>/Xilinx/Vivado/2022.2/settings64.sh`\
Set Verific license\
`export VERIFIC_LICENSE_FILE = <path to license file>`\

## Detection of bugs with CWEAT

Obtain Verific Libraries for Verilog and name the top folder `verific_lib_eval`.\
Move `verific_lib_eval` to tools/CWEAT/ \
Move `tools/CWEAT/CWEET-internal-main` to `tools/CWEAT/verific_lib_eval/examples/` \
` cd tools/CWEAT/verific_lib_eval/examples/CWEET-internal-main `\
`./cweet_scanner-linux <design setup file>`\
E.g.\
`./cweet_scanner-linux designs_filepaths/h-21.txt`\
This produces a *design.csv* file in *results/bug_locations*\
E.g. *results/bug_locations/h-21.csv*\
May need to add bug IDs in the csv after the csv files are produced.

## Generate repairs

`cd repairs`\
If you wish to regenerate responses for bugs, make sure a directory for their bug ID does not exist in `repairs/`.\
Modify *designs* list in *gen_repairs.py* to run those designs in the list\
`python3 gen_repairs.py`\
This uses the *designs.csv* files and instruction files in *instructions/bug...* to produce resposes i.e. *example(n).v* files in *repairs/bug(n)*\
A file *repairs/bug1/prompt-to-LLM.txt* is produced which contains the prompt for the bug that is fed to the LLM.

## Evaluation of repairs with CWEAT (bugs 8-10)

`cd tools`\
`python3 evaluate_repairs_CWEAT.py`\
This uses the */results/bug_locations/<design>.csv* file and resposes i.e. *example(n).v* files in *repairs/bug(n)* to produce a large *results/repairs/results.csv* file which informs us whether each example was secure.\

## Evaluation of repairs with custom testbenches (bugs 1-7)

`cd tools`\
Modify *bugs* list in *evaluate_repairs.py* to evaluate those bugs in the list\
`python3 evaluate_repairs.py.py`\
This uses the *example(n).v* files, *bug(n).f* files and *tb_bug(n).sv* files to produce results in *results/repairs/results.csv*.

## Process of adding a new design and its evaluation to the pipeline

1. Create a directory by the design name in *designs/*
2. Add design files to this directory
3. Create file `<design>.csv` in `results/bug_locations/`
4. Add information for the bug. Include the header:\
"ID,filepath,module,cwe,line-start,line-end"\
and the bug information e.g.\
"bug(x),../../../../../designs/hackdac21_phase1/piton/design/chip/tile/ariane/src/csr_regfile.sv,csr_regfile,1234,1006,1008"\
Make sure that the bug ID is uniqure across all design files.
5. Produce instruction files in `repairs/instructions/`.
6. Modify gen_repairs.py to include design in `designs` list.
7. Generate repairs
8. Use CWEAT or custom testbenches for evaluation\
    a. If using custom testbenches, write functional testbench in  `tools/functional_tests/testbenches`, write security testbench in `tools/security_tests/testbenches`, write .f file in `tools/` if needed.\
    b. If using CWEAT, write functional testbench in  `tools/functional_tests/testbenches`, security evaluation is taken care of is the bug falls under the CWEs CWEAT can detect, write .f file in `tools/` if needed.

