title:  Tutorials and Training
---

## Tutorials featuring VTK.js and OHIF web apps

**What:** The Open Health Imaging Foundation (OHIF) and Kitware have teamed up to help you create amazing 3D zero-footprint medical imaging web applications using state-of-the-art open-source software. Did we mention it’s totally free and commercially friendly?!? Also, if you ever wanted to try the Visualization Toolkit (VTK) for the web but never knew where to start, now you can watch a few tutorial videos on VTK.js! Learn how to use VTK.js, and harness the power of 3D visualization on the web today!

**Target audience:** medical imaging professionals and developers looking to understand what’s possible with web apps and how to make it happen. JavaScript and graphics development experience helpful but not strictly required.

### Tutorials

This training course is split into four parts. First you will learn the background of the VTK and OHIF projects, and then you will learn how to start a VTK project. The third course does a deep dive into the architecture and tooling support in VTK, and the fourth course wraps up with an investigation into how VTK is used in the OHIF Viewer as a viewport extension. Course materials are available in Google Slides and expertly narrated videos by Forrest Li and James Petts, leading developers in the VTK.js and OHIF communities.

1. [ [Slides](https://docs.google.com/presentation/d/1NCJxpfx_qUGJI_2DhbECzaOg0k-Z6b65QlUptCofN-A/edit#slide=id.p) | [Video](https://vimeo.com/375520781) ] Introduction to VTK.js and OHIF
2. [ [Slides](https://docs.google.com/presentation/d/17TCS6EhFi6SWFIrcAJ-DFdFzFFL-WD9BBTv-owmMdDU/edit?usp=sharing) | [Video](https://vimeo.com/375521036) ] Developing with VTK.js
3. [ [Slides](https://docs.google.com/presentation/d/1Sr1OGxMSw0oCt46koKQbmwSIE11Kqq8MGtyW3W0ASpk/edit?usp=gmail_thread) | [Video](https://vimeo.com/375521810) ] VTK.js Architecture and Tooling
4. [ [Slides](https://docs.google.com/presentation/d/1Iwg-u01HGVf1CgC6NbcBD3gm3uHN9WhjU59FSz55TN8/edit?ts=5d9c9ce4#slide=id.g59aa99cda4_0_131) | [Video](https://vimeo.com/375521206) ] OHIF + VTK.js Integration

### Reference links:

- [Discourse announcement](https://discourse.vtk.org/t/new-free-video-tutorials-vtk-js-and-ohif-web-apps/2164)
- [Blog post](https://blog.kitware.com/vtk-js-video-tutorials-integrating-scientific-visualizations-into-ohif-and-other-web-applications/)
- Github: [VTK.js](https://github.com/Kitware/vtk-js) | [OHIF](https://github.com/OHIF/Viewers)
- Documentation: [VTK.js](https://kitware.github.io/vtk-js/) | [OHIF](https://docs.ohif.org/)

### Funding partners

Funding for this work was provided by Kitware (NIH NINDS R44NS081792, NIH NINDS R42NS086295, NIH NIBIB and NIGMS R01EB021396, NIH NIBIB R01EB014955), Isomics (NIH P41 EB015902), and Massachusetts General Hospital (NIH U24 CA199460).

## Training Webinar on VTK.js, ParaViewWeb, ParaView Glance, Girder, and more

**What:** The Kitware EU office has worked to release an informative recorded webinar demonstrating several amazing web technologies to help you build a wide variety of web-based visualization platforms.

**Target audience:** Anyone who has an interest in bringing their complex 3D visualization needs to the web, and want to see what sort of advanced platforms Kitware offers in that space.

The recorded webinar and associated Discourse announcement can be found below.
- [Webinar (https://vimeo.com/467338846)](https://vimeo.com/467338846)
- [Discourse Announcement](https://discourse.vtk.org/t/visualization-on-the-web-webinar/4416)
