# Title of Dataset: Data on: Earlier leaf senescence dates are constrained by soil moisture
---

This dataset contains historical observations of leaf senescence dates (LSD) from ground and satellite during 1982-2015, and future simulations of the LSD in the period 2081-2100. 


## Description of the Data and file structure

Details for: ground_phenological_observations.xlsx
---------------------------------------

* Description:  this file contains leaf colouring date of four species from different ground sites. The "info" sheet records the approximate geographic location of the ground sites.

* Format(s): .xlsx

* Variables:
  * ID: an unique identification code for each ground site.
  * year: the year of phenological observation
  * leaf colouring date:  observed dates of leaf colouring, the unit is day of year.
  * lat: latitude of the site.
  * lon:  longitude of the site.


Details for: lsd_ndvi3g.rar
---------------------------------------

* Description:  a package containing satellite derived leaf senescence dates in the Northern Hemisphere (>30°N) during the period 1982-2015. The detailed information can be found in the METHODS section of the original GCB paper "Earlier leaf senescence dates are constrained by soil moisture
". The ".tif" files can be opened in ArcGIS or QGIS. The value of the pixel represents the date of leaf colouring and the unit is day of year.

* Format(s): .tif


Details for: lsd_cddsm_ssp126.rar
---------------------------------------

* Description:  a package containing simulated leaf senescence dates from CDDSM model in the Northern Hemisphere (>30°N) during 2081-2100 under the SSP126 scenarios. The detailed information can be found in the METHODS section of the original GCB paper "Earlier leaf senescence dates are constrained by soil moisture". The ".tif" files can be opened in ArcGIS or QGIS. The value of the pixel represents the date of leaf colouring and the unit is day of year.

* Format(s): .tif


Details for: lsd_cddsm_ssp585.rar
---------------------------------------

* Description:  a package containing simulated leaf senescence dates from CDDSM model in the Northern Hemisphere (>30°N) during 2081-2100 under the SSP585 scenarios. The detailed information can be found in the METHODS section of the original GCB paper "Earlier leaf senescence dates are constrained by soil moisture". The ".tif" files can be opened in ArcGIS or QGIS. The value of the pixel represents the date of leaf colouring and the unit is day of year.

* Format(s): .tif


Details for: lsd_cdd_ssp126.rar
---------------------------------------

* Description:  a package containing simulated leaf senescence dates from CDD model in the Northern Hemisphere (>30°N) during 2081-2100 under the SSP126 scenarios. The detailed information can be found in the METHODS section of the original GCB paper "Earlier leaf senescence dates are constrained by soil moisture". The ".tif" files can be opened in ArcGIS or QGIS. The value of the pixel represents the date of leaf colouring and the unit is day of year.

* Format(s): .tif


Details for: lsd_cdd_ssp585.rar
---------------------------------------

* Description:  a package containing simulated leaf senescence dates from CDD model in the Northern Hemisphere (>30°N) during 2081-2100 under the SSP585 scenarios. The detailed information can be found in the METHODS section of the original GCB paper "Earlier leaf senescence dates are constrained by soil moisture". The ".tif" files can be opened in ArcGIS or QGIS. The value of the pixel represents the date of leaf colouring and the unit is day of year.

* Format(s): .tif


Details for: lsd_dm_ssp126.rar
---------------------------------------

* Description:  a package containing simulated leaf senescence dates from DM model in the Northern Hemisphere (>30°N) during 2081-2100 under the SSP126 scenarios. The detailed information can be found in the METHODS section of the original GCB paper "Earlier leaf senescence dates are constrained by soil moisture". The ".tif" files can be opened in ArcGIS or QGIS. The value of the pixel represents the date of leaf colouring and the unit is day of year.

* Format(s): .tif


Details for: lsd_dm_ssp585.rar
---------------------------------------

* Description:  a package containing simulated leaf senescence dates from DM model in the Northern Hemisphere (>30°N) during 2081-2100 under the SSP585 scenarios. The detailed information can be found in the METHODS section of the original GCB paper "Earlier leaf senescence dates are constrained by soil moisture". The ".tif" files can be opened in ArcGIS or QGIS. The value of the pixel represents the date of leaf colouring and the unit is day of year.

* Format(s): .tif


Details for: lsd_siam_ssp126.rar
---------------------------------------

* Description:  a package containing simulated leaf senescence dates from SIAM model in the Northern Hemisphere (>30°N) during 2081-2100 under the SSP126 scenarios. The detailed information can be found in the METHODS section of the original GCB paper "Earlier leaf senescence dates are constrained by soil moisture". The ".tif" files can be opened in ArcGIS or QGIS. The value of the pixel represents the date of leaf colouring and the unit is day of year.

* Format(s): .tif


Details for: lsd_siam_ssp585.rar
---------------------------------------

* Description:  a package containing simulated leaf senescence dates from SIAM model in the Northern Hemisphere (>30°N) during 2081-2100 under the SSP585 scenarios. The detailed information can be found in the METHODS section of the original GCB paper "Earlier leaf senescence dates are constrained by soil moisture". The ".tif" files can be opened in ArcGIS or QGIS. The value of the pixel represents the date of leaf colouring and the unit is day of year.

* Format(s): .tif
