********************************************************************************
* Replication
* Stata Masterfile

clear all
set more off
cap log close

********************************************************************************
* Preamble

ssc install rsource, replace

global genpath "F:\LSE\Car_Recovery\new fold"
* change version number, if necessary
global Rpath "C:\Programmi\R\R-4.2.2\bin\x64\Rterm.exe"


global figures 	 	= "${genpath}\3.replication\figures"
global dobuild     	= "${genpath}\3.replication\stata_code\build"
global doanalysis  	= "${genpath}\3.replication\stata_code\analysis"
global dostata  	= "${genpath}\3.replication\stata_code"
global datbuild 	= "${genpath}\3.replication\deriveddatasets"

global doR  		= "${genpath}\3.replication\R_code"

global dominion	 	= "${genpath}\4.Confidential_data_not_for_publication\Dominion\Final"
global IHS_char		= "${genpath}\4.Confidential_data_not_for_publication\IHS_Characteristics"

cd "${dostata}"
 
set scheme s2colorag

********************************************************************************
* DATASETS CONSTRUCTION

* Import data on price of new cars transactions from Dominion
do "${dobuild}/cr_RP_master_newprice.do"

* Import data on car characteristics from IHS
do "${dobuild}/cr_RP_d_IHS_charact.do"

* Build dataset with characteristics
do "${dobuild}/cr_RP_d_entryexit_models_IHS_char.do"
do "${dobuild}/cr_RP_d_entryexit_models_IHS_char_regs.do"
do "${dobuild}/cr_RP_d_entryexit_models_expanded_IHS_char_regs.do"

*** Matching ***
* Extract models strings
do "${dobuild}/cr_RP_d_dominion_model_list.do"
do "${dobuild}/cr_RP_d_IHS_model_list.do"

* Extract list of models-year in the two datasets
do "${dobuild}/cr_RP_d_dominion_model_year_list.do"
do "${dobuild}/cr_RP_d_IHS_model_year_list.do"

* MATCHING IN R
if "`c(os)'"=="MacOSX" | "`c(os)'"=="UNIX" {
	cd "${doR}"
    rsource using "${doR}\Merging_algorithm_FV.R", rpath("$Rpath"") roptions(`"--vanilla"')
	cd "${dostata}"
}
else {  // windows
	cd "${doR}"
    rsource using "${doR}\Merging_algorithm_FV.R", rpath("$Rpath") roptions(`"--vanilla"')  
	cd "${dostata}"
}

* Create new model identifers and new models introduction year and attach them 
* to Dominion transactions data
do "${dobuild}/cr_RPa_d_newmodels_matchIHS_dominion.do"
do "${dobuild}/cr_RPa_d_expshare_matchIHS_newmodels_dominion.do"

* Characteristics+average prices by models
do "${dobuild}/cr_RP_d_pricechar_matchIHS_dominion.do"

do "${dobuild}/cr_RP_d_expshare_matchIHS_newmodels_dominion_harmonmaker.do"


********************************************************************************
* FIGURES MAIN PAPER

* Figure 1 and Appendix
do "${doanalysis}/an_RP_figure1.do"

* Figure 2 and Appendix
do "${doanalysis}/an_RP_figure2.do"

* Figure 3 - Panels (a) and (b) 
* See MATLAB Code

* Figure 3 - Panel (c)
do "${doanalysis}/an_RP_figure3c.do"

* Figure 4
do "${doanalysis}/an_RP_figure4.do"

* Figure 5 
do "${doanalysis}/an_RP_figure5.do"


********************************************************************************
* APPENDIX

* Figure B1
* See MATLAB Code

* Figure B2
do "${doanalysis}/an_RP_figureB2.do"

* Figure B3
do "${doanalysis}/an_RP_figureB3.do"

* Figure B4
do "${doanalysis}/an_RP_figureB4.do"

* Figure B5
do "${doanalysis}/an_RP_figureB5.do"

* Figure B6
do "${doanalysis}/an_RP_figureB6.do"

* Figure B7
do "${doanalysis}/an_RP_figureB7.do"

* Figure B8
do "${doanalysis}/an_RP_figureB8.do"

* Figure B9
do "${doanalysis}/an_RP_figureB9.do"

* Figure B10
do "${doanalysis}/an_RP_figureB10.do"

* Figure B11
do "${doanalysis}/an_RP_figureB11.do"

* Figure B12
do "${doanalysis}/an_RP_figureB12.do"

* Table B1A
do "${doanalysis}/an_RP_tableB1A.do"

* Table B1B
do "${doanalysis}/an_RP_tableB1B.do"

* Table B2
do "${doanalysis}/an_RP_tableB2.do"

* Figure B13
do "${doanalysis}/an_RP_figureB13ab.do"
do "${doanalysis}/an_RP_figureB13c.do"

* Figure B14
do "${doanalysis}/an_RP_figureB14.do"

* Figure B15
do "${doanalysis}/an_RP_figureB15.do"

* Figure B16
do "${doanalysis}/an_RP_figureB16.do"

* Input to Figure B17
do "${doanalysis}/an_RP_figureB17input.do"


********************************************************************************
* Specific figures in the text of the paper
do "${doanalysis}/an_RP_specific_figures.do"

* Specific figures in the text of the Appendix
do "${doanalysis}/an_RP_specific_figures_appendix.do"

