* cr_RPa_d_expshare_matchIHS_newmodels_dominion


set more off
cap log close


********************************************************************************
* First import output from the model-year matching algorithm
import delim "${doR}/algorithm_dominion_IHS_model_year_output.csv", clear
save "${datbuild}/algorithm_dominion_IHS_model_year_output.dta", replace

*******************************************************************************
use "${datbuild}/master_newprice.dta", clear

drop if sprice==. | sprice==0
drop if lease==1

rename year model_year
rename yy year

drop pumps city lease countynum 

* Clean zip codes
gen byte notnumericzip = real(zip)==.
replace zip="" if notnumericzip==1
destring zip, replace
drop notnumericzip

gen model_d2 = word(model,1)
replace model_d2=upper(model_d2)

drop if segment=="Full-Sized Van" | segment=="Medium & Heavy Truck"
drop if make=="FRHT" | make=="INTL" | make=="WEST" | ///
make=="UD" | make=="STER" | make=="PETE" | make=="MACK" | ///
make=="KENW" | make=="HINO" | make=="WEST" | make=="BLUB" // Drop producer of trucks only

drop if body=="HT" | body=="VN" | body=="BU" | body=="MH"
drop if make=="FORD" & model_d2=="MTR" // Drop Ford motor home
drop if make=="FORD" & model_d2=="TRANSIT" // Van
drop if make=="CADI" & model_d2=="HEARSE" // Funeral coach

drop model_d2

merge m:1 make model model_year using "${datbuild}/algorithm_dominion_IHS_model_year_output.dta", keep(3) nogenerate

rename make_ihs make_IHS
rename model_ihs model_IHS
rename generationmodelyear GenerationModelYear

gen _m_dom_IHS=1 if make_IHS=="" | model_IHS==""
replace _m_dom_IHS=3 if _m_dom_IHS==.

replace make_IHS=make if make_IHS==""
replace model_IHS=model_d2 if model_IHS==""

* Now attach information on introduction year and model_id
merge m:1 make_IHS model_IHS GenerationModelYear using "${datbuild}/d_newmodels_matchIHS_dominion.dta", ///
keepusing(model_id model_intro_year)

gen d_new_model = (year<=model_intro_year & model_intro_year!=.)
keep if _merge==3
drop _merge

bys model_id: egen min_month=min(mon)
gen d_new_model_12m=(mon<=min_month+100)

drop if body=="PU" | body=="CC"
drop generation custom_generation flag_model_manual flag_year_manual


* Save the dataset
save "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", replace

* Erase intermediate datasets
erase "${datbuild}/algorithm_dominion_IHS_model_year_output.dta"
