* cr_master_newprice

* This dofile aggregates data on new cars transactions from Dominion into a single 
* dataset
	   
clear all
set more off
cap log close

********************************************************************************
* Import datasets one by one and do cleaning on each individually

foreach state in CON IDN NDN OHN TXN {

	forvalues i=2004/2012 {
	
	import delim using "${dominion}/`state'`i'.csv", delim(",") clear
	cap drop if year=="T" // For NDN2012, one record reports "T", creating issues
	destring year, replace
	replace year=`i' if year==.
	gen yy=`i'
	
	* In the case of OHN2008 fleet is always empty, so it is replaced with "" first
	cap tostring fleet, force replace
	cap tostring lease, force replace
		
	gen fleetn=0 if fleet=="" | fleet=="."
	replace fleetn=1 if fleet=="Y"
	gen leasen=0 if lease=="" | lease=="."
	replace leasen=1 if lease=="Y"
	drop fleet lease
	rename fleetn fleet
	rename leasen lease
	
	drop seller lienholder
	disp "price destring start"
	cap destring sprice, force replace
	cap drop if sprice==. | sprice==0
	disp "price destring end"
	
	cap tostring pumps, force replace
	cap tostring city, force replace
	cap tostring zip, force replace
	
	cap drop id
	
	gen state_th="`state'"
	replace state_th=substr(state_th,1,2)
	
	* Save the dataset temporarily
	save "${datbuild}/`state'`i'.dta", replace

}
}


* Then append the different datasets
clear 

foreach state in CON IDN NDN OHN TXN {

	forvalues i=2004/2012 {
	
	append using "${datbuild}/`state'`i'.dta", force
	erase "${datbuild}/`state'`i'.dta"

}
}

* Save the dataset
save "${datbuild}/master_newprice.dta", replace
