* cr_RP_d_pricechar_matchIHS_dominion_rrcol_stateweights

set more off
cap log close

set scheme s2colorag

*******************************************************************************
use "${datbuild}\d_expshare_matchIHS_newmodels_dominion.dta", clear

* Get average price by model and year
gen nb_trans_dominion=1
collapse (mean) sprice _m_dom_IHS (firstnm) make_IHS model_IHS GenerationModelYear ///
(sum) nb_trans_dominion (max) d_new_model, by(model_id year state)

keep if state=="CO" | state=="ID" | state=="ND" | state=="OH" | state=="TX"

rename GenerationModelYear GenerationYear
rename make_IHS Make
rename model_IHS Model

* Generate customized generations counts for the merge
preserve
keep Make Model GenerationYear
duplicates drop
sort Make Model GenerationYear, stable
bys Make Model: gen Generation=_n
* Save temporarily
save "${datbuild}\d_domgy_temp.dta", replace
restore

* Add back information on generations
merge m:1 Make Model GenerationYear using "${datbuild}\d_domgy_temp.dta", keepusing(Generation)

keep if _merge==3
drop GenerationYear _merge

* Drop unmatched models
drop if _m_dom_IHS==1
drop _m_dom_IHS

* Save temporarily
save "${datbuild}\d_domprices_temp.dta", replace


********************************************************************************
***** Then attach price info to IHS
use "${datbuild}/d_entryexit_models_IHS_char_regs.dta", clear


**********************
* Collapse the dataset of characteristics to be uniquely identified by a triplet
* Make Model GenerationYear (same level of transaction observation in collapsed Dominion)
 
gen one=1
collapse (mean) Turbo Manual D4x4 NoofDoors Engineltr Engineccm EnginekW EngineHP ///
NoofCylinders NoofGears NoofSeats Fuelconscombined Fuelconsurban Fuelconsextraurban ///
GrossVehicleWeight Height Length Width Wheelbase Diesel ///
maker_code FuelEfficiency (firstnm) BodyGroup BodyType DrivenWheels ///
(sum) one (max) d_entry [fw=NewRegistrations], by(Make Model GenerationYear year)

rename one NewRegistrations

local vars Engineltr Engineccm Fuelconsurban Fuelconsextraurban ///
Height Length Width Wheelbase EnginekW FuelEfficiency EngineHP GrossVehicleWeight

foreach v of local vars {
	replace `v'=ln(`v')
	gen `v'_sq=`v'^2 
}

replace NoofSeats=round(NoofSeats)
replace NoofGears=floor(NoofGears)
replace NoofCylinders=round(NoofCylinders)
replace NoofDoors=round(NoofDoors)


*****************
* Impute veichle weight were missing
areg GrossVehicleWeight Wheelbase Width Height i.NoofSeats , absorb(maker)

predict hat_weight, xb
gen miss_w=GrossVehicleWeight==.
replace GrossVehicleWeight=hat_weight if GrossVehicleWeight==.

drop GrossVehicleWeight_sq
gen GrossVehicleWeight_sq=GrossVehicleWeight^2

replace BodyType="SUV Closed" if BodyType=="Monospace"

encode BodyType, gen(BT)
encode BodyGroup, gen(BG)
drop BodyType BodyGroup
rename BT BodyType
rename BG BodyGroup

replace Manual=round(Manual)
replace Diesel=floor(Diesel)
replace Turbo=round(Turbo)
replace D4x4=round(D4x4)

*****************
* Get indentifier for Generations
preserve
keep Make Model GenerationYear
duplicates drop
sort Make Model GenerationYear, stable
bys Make Model: gen Generation=_n
* Save temporarily
save "${datbuild}\d_ihsgy_temp.dta", replace
restore

******** Attach back generation identifiers
merge m:1 Make Model GenerationYear using "${datbuild}\d_ihsgy_temp.dta"
keep if _merge==3
drop _merge

***********
* Expand to accommodate state-specific prices and weights
expand 2, gen(state_increm)
gen state="CO" if state_increm==0
replace state="ID" if state_increm==1
drop state_increm
expand 2 if state=="ID", gen(state_increm)
replace state="ND" if state_increm==1
drop state_increm
expand 2 if state=="ND", gen(state_increm)
replace state="OH" if state_increm==1
drop state_increm
expand 2 if state=="OH", gen(state_increm)
replace state="TX" if state_increm==1
drop state_increm


******** Attach price info and transactions from dominion
merge 1:1 Make Model Generation year state using "${datbuild}\d_domprices_temp.dta"
keep if _merge==3
drop _merge



* Save
save "${datbuild}\d_pricechar_matchIHS_dominion_rrcol_stateweights.dta", replace

erase "${datbuild}\d_domprices_temp.dta"
erase "${datbuild}\d_domgy_temp.dta"
