* cr_RP_d_pricechar_matchIHS_dominion

set more off
cap log close

set scheme s2colorag

*******************************************************************************
use "${datbuild}\d_expshare_matchIHS_newmodels_dominion.dta", clear

* Get average price by model and year
gen nb_trans_dominion=1
collapse (mean) sprice _m_dom_IHS (firstnm) make_IHS model_IHS GenerationModelYear ///
(sum) nb_trans_dominion (max) d_new_model, by(model_id year)

rename GenerationModelYear GenerationYear
rename make_IHS Make
rename model_IHS Model

* Generate customized generations counts for the merge
preserve
keep Make Model GenerationYear
duplicates drop
sort Make Model GenerationYear, stable
bys Make Model: gen Generation=_n

* Save temporarily
save "${datbuild}\d_domgy_temp.dta", replace
restore

* Add back information on generations
merge m:1 Make Model GenerationYear using "${datbuild}\d_domgy_temp.dta", keepusing(Generation)

keep if _merge==3
drop GenerationYear _merge

* Drop unmatched models
drop if _m_dom_IHS==1
drop _m_dom_IHS

* Save temporarily
save  "${datbuild}\d_domprices_temp.dta", replace

********************************************************************************
***** Then attach price info to IHS
use "${datbuild}/d_entryexit_models_IHS_char_regs.dta", clear

preserve
keep Make Model GenerationYear
duplicates drop
sort Make Model GenerationYear, stable
bys Make Model: gen Generation=_n
* Save temporarily
save "${datbuild}\d_ihsgy_temp.dta", replace
restore

merge m:1 Make Model GenerationYear using "${datbuild}\d_ihsgy_temp.dta"
keep if _merge==3
drop _merge

merge m:1 Make Model Generation year using "${datbuild}\d_domprices_temp.dta"
keep if _merge==3
drop _merge

replace NoofSeats=round(NoofSeats)
replace NoofGears=floor(NoofGears)
replace NoofCylinders=round(NoofCylinders)
replace NoofDoors=round(NoofDoors)


* Save
save "${datbuild}\d_pricechar_matchIHS_dominion.dta", replace

erase "${datbuild}\d_domprices_temp.dta"
erase "${datbuild}\d_domgy_temp.dta"
