* cr_RP_d_expshare_matchIHS_newmodels_dominion_harmonmaker

set more off
cap log close

set scheme s2colorag

*******************************************************************************
********************************************************************************
use "${datbuild}/d_expshare_matchIHS_newmodels_dominion.dta", clear

* Keep years in a relevant time-window
keep if (year>=2004 & year<=2012)

* Harmonize makers' names
replace make_IHS=upper(make_IHS)
replace make_IHS="CADILLAC" if make_IHS=="CADI"
replace make_IHS="CHEVROLET" if make_IHS=="CHEV"
replace make_IHS="CHRYSLER" if make_IHS=="CHRY"
replace make_IHS="HUMMER" if make_IHS=="HUMM"
replace make_IHS="ISUZU" if make_IHS=="ISU"
replace make_IHS="JEEP" if make_IHS=="JEP"
replace make_IHS="NISSAN" if make_IHS=="NISS"
replace make_IHS="TOYOTA" if make_IHS=="TOYT"
replace make_IHS="HONDA" if make_IHS=="HOND"

egen make_IHS_id=group(make_IHS)

* Region of the maker
gen make_region="Asia" if make_IHS=="ACURA" | make_IHS=="HONDA" | make_IHS=="HYUNDAI" | ///
make_IHS=="INFINITI" | make_IHS=="ISUZU" | make_IHS=="KIA" | make_IHS=="LEXUS" | ///
make_IHS=="MAZDA" | make_IHS=="MITSUBISHI" | make_IHS=="NISSAN" | make_IHS=="SATURN" | ///
make_IHS=="SUBARU" | make_IHS=="SUZUKI" | make_IHS=="TOYOTA"

replace make_region="Europe" if make_IHS=="ASTON MARTIN" | make_IHS=="AUDI" | make_IHS=="BENTLEY" | ///
make_IHS=="BMW" | make_IHS=="FERRARI" | make_IHS=="JAGUAR" | make_IHS=="LAMBORGHINI" | ///
make_IHS=="LAND ROVER" | make_IHS=="LOTUS" | make_IHS=="MASERATI" | make_IHS=="MAYBACH" | ///
make_IHS=="MERCEDES-BENZ" | make_IHS=="MINI" | make_IHS=="PORSCHE" | make_IHS=="ROLLS-ROYCE" | ///
make_IHS=="SAAB" | make_IHS=="VOLKSWAGEN" | make_IHS=="VOLVO" 

replace make_region="USA" if make_IHS=="BUICK" | make_IHS=="CADILLAC" | make_IHS=="CHEVROLET" | ///
make_IHS=="CHRYSLER" | make_IHS=="DODGE" | make_IHS=="FORD" | make_IHS=="GEM" | ///
make_IHS=="GMC" | make_IHS=="HUMMER" | make_IHS=="JEEP" | make_IHS=="LINCOLN" | ///
make_IHS=="MERCURY" | make_IHS=="PONTIAC"

* Save dataset
save "${datbuild}/d_expshare_matchIHS_newmodels_dominion_harmonmaker.dta", replace






